function [Radius,OK] = spejorad(A,dA,M,p,Err)

% function [Radius,OK] = spejorad(A,dA,M,p,Err)
% 
% This function checks if the joint spectral radius of the matrices A1 and A2
% in A = [A1, A2] is given by the maximum of the spectral
% radii of A1 and A2
% OK = 1 if this is the case and Radius gives upper and lower bounds for this
% radius.
%
% dA is an estimate of the norm of the error in the matrices in A
% If dA = [dA(1)], the errors are assumed to be dA(1)*norm(Ai,p)
% 
% This function calls eigpert.m, checkpro.m, and smallpro.m
%
% G. Gripenberg 5.8.1996
% Reference: G. Gripenberg, Computing the joint spectral radius, Linear
%      Algebra Appl.  234 (1996) 43--60.


if nargin < 4
  p = 2;
end

if nargin < 3
 M=50;
end


[ma,na] = size(A);

if (na > ma & rem(na,ma) == 0)
  N = fix(na/ma);
  n = ma;
elseif (ma > na & rem(ma,na) == 0)
  A = A.';
  N = fix(ma/na);
  n = na;
else
 disp('The matrix has wrong dimensions');
 A = [];
 dA = [];
 return;
end


if nargin < 5
 Err = [];
end

if  size(Err)*[1;1] < 3
  if p==1 | p==inf
    Err = [2^(-50)*n,2^(-49)*n];
  else
    Err = [2^(-50)*n^2,2^(-49)*n^2];
  end
end



if  size(dA)*[1;1] < 3
  dA = dA(1)*(1+Err(2))*[norm(A(:,1:n),p),norm(A(:,n+1:2*n),p)];
end



II = [];
for j =1:N
  II = [II;((j-1)*n+1:j*n)];
end
OK = 1;
for j = 1:N
      [V,D] = eig(A(:,II(j,:)));
      if cond(V) > 10^10
        return
      end
      dL = eigpert(A(:,II(j,:)),D,V,inv(V),dA(j),2,Err);
      r = sort(abs(diag(D)));
      RR(j,:) = [r(n)-dL(n),r(n)+dL(n),r(n-1)+dL(n-1)];
      if dL(n) == NaN | dL(n-1) == NaN
         OK = 0;
      end
    end
    Radius = max(RR(:,1:2));
    mu = min(1,RR(:,2:3)/Radius(1));

 for j = 1:N
   if OK
       [V,D] = eig(A(:,II(j,:)));
       W = inv(V);
       [dL,dV,dW] = eigpert(A(:,II(j,:)),D,V,W,dA(j),p,Err);
       [r,i] = max(abs(diag(D)));
       DD= zeros(1,n);
       DD(i) = 1;
       Z = (V*diag(DD))*W;
       VN = norm(V,p)*(1+Err(2));
       WN = norm(W,p)*(1+Err(2));
       dZ = (1+Err(2))*norm(V*diag(DD),p)*(Err(1)*WN + dW) +  dV *(WN+dW);
       CondV = (WN + dW)*(VN+dV);
       OK = 0;
       q =0;
       while q < M & ~OK
          q = q+10;
          OK = checkpro([A,Z],[dA,dZ],j,(mu(j,:).^q.*[1,CondV]), ...
                        Radius(1),M,p,Err);
       end
       if OK
          for jj = 1:q-1
             OKOK = smallpro(A,dA,[jj,j],Radius(1),M+q,p,Err);
             OK = OKOK*OK;
          end
       end
   end
 end

  





