function [OK,m,Bound] = smallpro(A,dA,K,r,M,p,Err)

% function [OK,m,Bound] = smallpro(A,dA,K,r,M,p,Err)
%
% A = [A(1),A(2)], 
%
% This function checks whether M_1*M_2* ... M_j > r^j
% M_1=M_2=...=M_K(1)=A(K(2)), M_K(1)+1 = A(3-K(2))
%
% G. Gripenberg 5.8.1996
% Reference: G. Gripenberg, Computing the joint spectral radius, Linear
%      Algebra Appl.  234 (1996) 43--60.


OK = 0;

if nargin < 7
 Err = [];
end

if nargin < 6
  p = 2;
end

if nargin < 5
  M = 50;
end

if size(K)*[1;1] < 3
  K = [K,1];
end
KK = [K(2),3-K(2)];

if ~(prod([1,2]==KK) | prod([2,1]==KK))
  return
end

[ma,na] = size(A);

if (na > ma & rem(na,ma) == 0)
  N = fix(na/ma);
  n = ma;
elseif (ma > na & rem(ma,na) == 0)
  A = A.';
  N = fix(ma/na);
  n = na;
else
 disp('The matrix has wrong dimensions');
 return;
end





if  size(Err)*[1;1] < 3
  if p==1 | p==inf
    Err = [2^(-50)*n,2^(-49)*n];
  else
    Err = [2^(-50)*n^2,2^(-49)*n^2];
  end
end


NormA = [norm(A(:,1:n),p); norm(A(:,n+1:2*n),p)];
dA = dA(:);
if  size(dA)*[1;0] ~= N
  dA = dA(1)*(1+Err(2))*NormA;
end


X = A(:,(KK(1)-1)*n+1:KK(1)*n);
NORM(1) = NormA(KK(1));
NormErr(1) = dA(KK(1));
for i = 2:K(1)
  X = X*A(:,(KK(1)-1)*n+1:KK(1)*n);
  NORM(1) = norm(X,p)*(1+Err(2));
  NormErr(1) =  (NORM(1)*(Err(1)*NormA(KK(1))+dA(KK(1))) + ...
         NormErr(1)*(NormA(KK(1))+dA(KK(1))));
end
X = X*A(:,(KK(2)-1)*n+1:KK(2)*n);
NORM(1) = norm(X,p)*(1+Err(2));
NormErr(1) =  NORM(1)*(Err(1)*NormA(KK(2))+dA(KK(2))) + ...
         NormErr(1)*(NormA(KK(2))+dA(KK(2)));
m = K(1)+1; 
UpBound(1) =  (NORM(1) + NormErr(1))^(1/m);

   
 Bound = UpBound(1);
 BestBound = 0;
 JJ = 1;
 mm = K(1); JJ = 1; MaxJJ = 1;
 BestPower = m;
 
while mm < M & Bound >= r
  m = m + 1;
  OldBound = Bound;
  Bound = 0;
  NewJJ = 0;
  for k = 1:JJ
    for i = 1:N
     NJJN = NewJJ + 1;
     XX = X((k-1)*n+1:k*n,:)*A(:,(i-1)*n+1:i*n);
     NewNormErr(NJJN) = (NORM(k)*(Err(1)*NormA(i)+dA(i)) + ...
         NormErr(k)*(NormA(i)+dA(i)));
     NewNORM(NJJN) = norm(XX,p)*(1+Err(2));
     NewUpBound(NJJN) = min(UpBound(k), (NewNORM(NJJN)+NewNormErr(NJJN))^(1/m));
     Bound = max(Bound,NewUpBound(NJJN));
     if NewUpBound(NJJN) >= r
        NewJJ = NewJJ + 1;
        NewX((NewJJ-1)*n+1:NewJJ*n,:) = XX;
     else
        BestBound = max(BestBound,NewUpBound(NJJN));
     end

    end
  end
  X = NewX;
  mm = mm+JJ*N;
  NORM = NewNORM;
  UpBound = NewUpBound(1:NewJJ);
  NormErr = NewNormErr;
  JJ = NewJJ;
  MaxJJ = max(JJ,MaxJJ);
  Bound = max(UpBound);
  if Bound < OldBound
   BestPower = m;
  end

end

Bound =  max(BestBound,Bound);

if Bound < r
  OK = 1;
end

m = [BestPower,m,mm,MaxJJ];




