function [OK,m,Bound] = checkpro(A,dA,K,mu,r,M,p,Err)

% function [OK,m,Bound] = checkpro(A,dA,K,mu,r,M,p,Err)
%
% A = [A,B,Z]
% dA = [dA,dB,dZ]
% The program checks if mu(1) |(Z*A*.. )| + mu(2) |(A*.. )| < r^j
%
% M is the maximum number of matrix multiplications
% K gives the index of the matrix that is diagonalized
%
% G. Gripenberg 5.8.1996
% Reference: G. Gripenberg, Computing the joint spectral radius, Linear
%      Algebra Appl.  234 (1996) 43--60.


OK = 0;

if nargin < 7
 Err = [];
end

if nargin < 6
  p = 2;
end

if nargin < 5
  M = 50;
end

if size(mu)*[1;1] < 3
  mu = [1,mu];
end

[ma,na] = size(A);

if (na > ma & rem(na,ma) == 0)
  N = fix(na/ma);
  n = ma;
elseif (ma > na & rem(ma,na) == 0)
  A = A.';
  N = fix(ma/na);
  n = na;
else
 disp('The matrix has wrong dimensions');
 return;
end

if N < 3
 return
end



if  size(Err)*[1;1] < 3
  if p==1 | p==inf
    Err = [2^(-50)*n,2^(-49)*n];
  else
    Err = [2^(-50)*n^2,2^(-49)*n^2];
  end
end

Z = A(:,2*n+1:3*n);

NormA = (1+Err(2))*[norm(A(:,1:n),p); norm(A(:,n+1:2*n),p)];
NormZ = (1+Err(2))*norm(Z,p);

dA = dA(:);
if  size(dA)*[1;0] ~= N
  dA = dA(1)*NormA;
  dZ = dA(1)*NormZ;
else
  dZ = dA(3);
end
N=2;

X = A(:,(2-K)*n+1:(3-K)*n);
NORM(1) = NormA(3-K);
NormErr(1) = dA(3-K);
UpBound(1) = mu(1)*(1+Err(2))*norm(Z*X,p) + ...
   mu(1)*(NormZ*(Err(1)*NormA(3-K) + dA(3-K)) + dZ*(NormA(3-K) + dA(3-K))) ...
   + mu(2)*(NormA(3-K) + dA(3-K));
m = 1; 
JJ = 1;
mm = 1; JJ = 1; MaxJJ = 1;
Bound = UpBound(1);
BestBound = 0;
BestPower = 1;
 
while mm < M & Bound >= r
  m = m + 1;
  OldBound = Bound;
  Bound = 0;
  NewJJ = 0;
  for k = 1:JJ
    for i = 1:N
     NJJN = NewJJ + 1;
     XX = X((k-1)*n+1:k*n,:)*A(:,(i-1)*n+1:i*n);
     NewNormErr(NJJN) = (NORM(k)*(Err(1)*NormA(i)+dA(i)) + ...
         NormErr(k)*(NormA(i)+dA(i)));
     NewNORM(NJJN) = norm(XX,p)*(1+Err(2));
     TestExp = mu(1)*((1+Err(2))*norm(Z*XX) + ...
         NormZ*(Err(1)*NewNORM(NJJN) + NewNormErr(NJJN))  + ...
           dZ*(NewNORM(NJJN) +  NewNormErr(NJJN))) + ...
             mu(2)*(NewNORM(NJJN) + NewNormErr(NJJN));
     NewUpBound(NJJN) = min(UpBound(k),  TestExp^(1/m));
     Bound = max(Bound,NewUpBound(NJJN));
     if NewUpBound(NJJN) >= r
        NewJJ = NewJJ + 1;
        NewX((NewJJ-1)*n+1:NewJJ*n,:) = XX;
     else
        BestBound = max(BestBound,NewUpBound(NJJN));
     end
    end
  end
  X = NewX;
  mm = mm+JJ*N;
  NORM = NewNORM;
  UpBound = NewUpBound(1:NewJJ);
  NormErr = NewNormErr;
  JJ = NewJJ;
  MaxJJ = max(JJ,MaxJJ);
  Bound = max(UpBound);
  if Bound < OldBound
     BestPower = m;
  end
end


Bound =  max(BestBound,Bound);

if Bound < r
  OK = 1;
end

m = [BestPower,m,mm,MaxJJ];




