function r = lowspera(A,dA,p,Err,Bound)

%  function r = lowspera(A,dA,p,Err,Bound)
%  
%  This function calculates a lower bound for the spectral radius of the
%  matrix A
%  dA is an estimate of the norm of the error in the matrix A
%  p gives the norm to be used
%  Err = [Err(1), Err(2)] gives the relative errors in evaluating products
%     and norms.
%  The program only attempts to find lower bounds larger than or equal to Bound
%
% G. Gripenberg 5.8.1996
% Reference: G. Gripenberg, Computing the joint spectral radius, Linear
%      Algebra Appl.  234 (1996) 43--60.







if nargin < 4
  Bound = inf;
end

[V,D] = eig(A);

n = size(A)*[0;1];

s = svd(V);

if min(s) < eps |  min(s)/max(s) < eps
  r = 0;
  return
end

W = inv(V);

a = norm(W,p)*norm(V,p)*dA;

[L,II] = sort(abs(diag(D)));
L = diag(D); L=L(II);

 d = 0;
LL = abs(triu(L*ones(1,n)-ones(n,1)*L'));
 i = 0;
 while d <= 2*a & i < n - 1
  i = i + 1;
  d = min(min(LL(1:n-i,n-i+1:n)));
 end
 if d > 2*a
  JJ = II(n-i+1:n);
 else
  JJ = (1:n)';
 end
r = min(abs(L(n-i+1:n)));

if r < Bound
  r= 0;
  return
end


PJJ = zeros(1,n)';
PJJ(JJ) = 1+0*JJ;
PJJ = diag(PJJ);


VN = norm(V,p)*(1+Err(2));
WN = norm(W,p)*(1+Err(2));

check1 = (1-Err(1)*VN*WN-norm(V*W-eye(n),p)*(1+Err(2)));
if check1 < eps
 r = 0;
 return
end

CII = (Err(1)*VN*WN + norm(W*V-eye(n),p)*(1+Err(2)))*WN/check1;

CP = (dA + norm(A-(V*D)*W,p)*(1+Err(2)) ...
      + norm(V*D,p)*(1+Err(2))*(Err(1)*WN+CII) ...
   + Err(1)*VN*max(abs(diag(D)))*(WN+CII));


CA = CP*(norm(PJJ*W,p)*(1+Err(2))+ CII)*VN;
CB = CP*(norm((eye(n)-PJJ)*W,p)*(1+Err(2))+ CII)*VN;

if d <= (sqrt(CA) + sqrt(CB))^2 
  r=0;
  return
end

rd = 2*CA*d/(CA-CB+ d + sqrt((CA-CB+ d)^2-4*CA*d));


r = r-rd;

