
/*
 * Propo.java  -  Java 2 program for training the eye to see proportions.
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.Container.*;
import java.awt.event.*;
import java.util.Date.*;

// Application class
public class Propo extends JApplet 
{
    // UI objects
    DrawArea coordinateArea; 
    ScribbleArea coordinateArea2; 
    Toprow toprow;

    // Draw/Scribbleworlds and AI for them
    public WorldAI w;
    
    public void NewExercise()
    {
	w.NewExercise( coordinateArea.getSize() );

	coordinateArea.repaint();
	coordinateArea2.repaint();
	toprow.repaint();
    }

    // Called when this is run as an applet.
    public void init() 
    {
        Propo controller = new Propo();
        controller.buildUI( getContentPane() );

	controller.w = new WorldAI();
	controller.NewExercise();

    }

    void buildUI(Container container) 
    {
        container.setLayout(new BoxLayout( container, BoxLayout.Y_AXIS ));

	// top row for statistics
	toprow = new Toprow( this );
	container.add( toprow );

	// drawing area
        coordinateArea = new DrawArea( this );
        container.add( coordinateArea );

	// scribble area
	coordinateArea2 = new ScribbleArea( this );
        container.add( coordinateArea2 );

	// do the layout. 
	container.doLayout();


    }

    // Update statistics on the screen
    public void updateStats() 
    {
    }

    public static void main(String[] args) 
    {
        JFrame f = new JFrame("Propo 0.1");

	// check for exit button 
        f.addWindowListener(new WindowAdapter() 
	    {
            public void windowClosing(WindowEvent e) 
		{
		System.out.println("Exiting."); 
                System.exit(0);
		}
	    });

        Propo controller = new Propo();
	controller.w = new WorldAI();	
        controller.buildUI( f.getContentPane() );
        f.pack();
        f.setVisible(true);
	
	controller.NewExercise();
	controller.toprow.repaint();

    }
}

