
/*
 * DrawArea.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

import java.util.*;


// computer draws using this class
class DrawArea extends JPanel 
{
    Propo controller;
    Dimension preferredSize = new Dimension(400,300);

    public DrawArea(Propo caller) 
    {
        this.controller = caller;     // save reference to caller

        Border raisedBevel = BorderFactory.createRaisedBevelBorder();
        Border loweredBevel = BorderFactory.createLoweredBevelBorder();
        Border compound = BorderFactory.createCompoundBorder
                              (raisedBevel, loweredBevel);
        setBorder(compound);
	setBackground(Color.white);

    }

    public Dimension getPreferredSize() 
    {
        return preferredSize;
    }

    public void paintComponent(Graphics g) 
    {
        super.paintComponent(g);  
	controller.w.DrawWorld.DrawAll(g);	
    }
}

