/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.geom.Line2D;
import java.util.Date;

public class WorldAI {
    int Ex = 0;
    int ExOK = 0;
    float SuccessRate = 0.0f;
    boolean LastOK = true;
    boolean BullsEye = false;
    public World DrawWorld = new World();
    public World ScribbleWorld = new World();
    float currentScaleFactor = 1.0f;
    int para_numPoints = 5;
    int para_minDist = 30;
    float para_border = 0.05f;
    float para_sborder = 0.3f;
    float para_pRad = 4.0f;
    Date startdate;

    WorldAI() {
    }

    public void JudgePoint(PPoint pPoint) {
        ++this.Ex;
        this.BullsEye = false;
        if (this.ScribbleWorld.DistanceFromSpecialPoint(pPoint) <= 2.0f * this.para_pRad * this.currentScaleFactor) {
            ++this.ExOK;
            this.LastOK = true;
            if (this.ScribbleWorld.DistanceFromSpecialPoint(pPoint) <= this.para_pRad * this.currentScaleFactor) {
                this.BullsEye = true;
            }
        } else {
            this.LastOK = false;
        }
        if (this.Ex != 0) {
            this.SuccessRate = (float)this.ExOK / (float)this.Ex;
        }
    }

    public boolean AllOK() {
        return this.Ex == this.ExOK;
    }

    public void NewExercise(Dimension dimension) {
        this.DrawWorld.Empty();
        this.ScribbleWorld.Empty();
        int n = 0;
        while ((n = (int)Math.ceil(Math.random() * 3.0)) == 0) {
        }
        switch (n) {
            case 1: {
                this.RandomPoints(dimension);
                break;
            }
            case 2: {
                this.ProportionalLine(dimension);
                break;
            }
            case 3: {
                this.PointsOnCircle(dimension);
                break;
            }
            default: {
                this.ProportionalLine(dimension);
            }
        }
        this.rescale(dimension);
    }

    private float ranborder(float f) {
        return (1.0f - 2.0f * f) * (float)Math.random() + f;
    }

    private float random2(float f, float f2) {
        float f3 = (float)Math.random();
        float f4 = f2 * f3 + (1.0f - f3) * f;
        return f4;
    }

    private void rescale(Dimension dimension) {
        float f = (float)this.para_minDist / this.ScribbleWorld.minDistance();
        f = Math.max(0.5f, f);
        PPoint pPoint = new PPoint(this.ScribbleWorld.ULCorner(), 0.0f);
        pPoint.Scale(-1.0f);
        this.ScribbleWorld.Shift(pPoint);
        pPoint = new PPoint(this.ScribbleWorld.LRCorner(), 0.0f);
        float f2 = Math.min((float)(dimension.width - 10) / pPoint.x(), (float)(dimension.height - 10) / pPoint.y());
        f2 = (float)((double)f2 * (1.0 - 2.0 * (double)this.para_border));
        if (f < f2) {
            this.currentScaleFactor = this.random2(f, f2);
            this.ScribbleWorld.Scale(this.currentScaleFactor);
        } else {
            this.currentScaleFactor = 1.0f;
        }
        pPoint = new PPoint(this.ScribbleWorld.LRCorner(), 0.0f);
        PPoint pPoint2 = new PPoint(((float)dimension.width - pPoint.x()) / 2.0f, ((float)dimension.height - pPoint.y()) / 2.0f, 0.0f);
        this.ScribbleWorld.Shift(pPoint2);
    }

    public void RandomPoints(Dimension dimension) {
        int n = (int)((double)dimension.width * (double)this.ranborder(this.para_sborder));
        int n2 = (int)((double)dimension.height * (double)this.ranborder(this.para_sborder));
        PPoint pPoint = new PPoint(n, n2, this.para_pRad);
        this.DrawWorld.SetSpecialPoint(pPoint);
        pPoint = new PPoint(n, n2, this.para_pRad);
        this.ScribbleWorld.SetSpecialPoint(pPoint);
        int n3 = 0;
        while (n3 < this.para_numPoints) {
            n = (int)((double)dimension.width * (double)this.ranborder(this.para_border));
            PPoint pPoint2 = new PPoint(n, n2 = (int)((double)dimension.height * (double)this.ranborder(this.para_border)), this.para_pRad);
            if (!(this.DrawWorld.minDistance(pPoint2) > (float)this.para_minDist)) continue;
            ++n3;
            this.DrawWorld.AddPoint(pPoint2);
            pPoint2 = new PPoint(n, n2, this.para_pRad);
            this.ScribbleWorld.AddPoint(pPoint2);
        }
    }

    public void ProportionalLine(Dimension dimension) {
        int n;
        int n2;
        PPoint pPoint;
        int n3 = (int)((double)dimension.width * (double)this.ranborder(this.para_border));
        int n4 = (int)((double)dimension.height * (double)this.ranborder(this.para_border));
        PPoint pPoint2 = new PPoint(n3, n4, this.para_pRad);
        while (pPoint2.Distance(pPoint = new PPoint(n2 = (int)((double)dimension.width * (double)this.ranborder(this.para_border)), n = (int)((double)dimension.height * (double)this.ranborder(this.para_border)), this.para_pRad)) < (float)(this.para_minDist * 3)) {
        }
        this.DrawWorld.AddPoint(new PPoint(n3, n4, this.para_pRad));
        this.DrawWorld.AddPoint(new PPoint(n2, n, this.para_pRad));
        this.ScribbleWorld.AddPoint(new PPoint(n3, n4, this.para_pRad));
        this.ScribbleWorld.AddPoint(new PPoint(n2, n, this.para_pRad));
        this.DrawWorld.Add(new Line2D.Float(n3, n4, n2, n));
        this.ScribbleWorld.Add(new Line2D.Float(n3, n4, n2, n));
        if (Math.random() > 0.5) {
            int n5 = (int)((double)dimension.width * (double)this.ranborder(this.para_sborder));
            int n6 = (int)((double)dimension.height * (double)this.ranborder(this.para_sborder));
            this.DrawWorld.SetSpecialPoint(new PPoint(n5, n6, this.para_pRad));
            this.ScribbleWorld.SetSpecialPoint(new PPoint(n5, n6, this.para_pRad));
        } else {
            PPoint pPoint3 = new PPoint(n3 - n2, n4 - n, 0.0f);
            float f = this.ranborder(0.2f);
            pPoint3.Scale(f);
            PPoint pPoint4 = new PPoint(n2, n, this.para_pRad);
            pPoint4.Shift(pPoint3);
            this.DrawWorld.SetSpecialPoint(pPoint4);
            this.ScribbleWorld.SetSpecialPoint(pPoint4.Clone());
        }
    }

    public void PointsOnCircle(Dimension dimension) {
        int n = (int)((double)dimension.width * (double)this.ranborder(this.para_sborder));
        int n2 = (int)((double)dimension.height * (double)this.ranborder(this.para_sborder));
        PPoint pPoint = new PPoint(n, n2, this.para_pRad);
        int n3 = Math.min(n, dimension.width - n);
        n3 = Math.min(n3, n2);
        n3 = Math.min(n3, dimension.height - n2);
        n3 = (int)((float)n3 * 0.85f);
        this.DrawWorld.AddCircle(n, n2, n3, this.para_pRad);
        this.ScribbleWorld.AddCircle(n, n2, n3, this.para_pRad);
        if (Math.random() < 0.5) {
            this.DrawWorld.AddPoint(pPoint);
            this.ScribbleWorld.AddPoint(pPoint.Clone());
            float f = this.random2(0.0f, (float)Math.PI * 2);
            PPoint pPoint2 = new PPoint((float)((double)n + (double)n3 * Math.cos(f)), (float)((double)n2 + (double)n3 * Math.sin(f)), this.para_pRad);
            this.DrawWorld.AddPoint(pPoint2);
            this.ScribbleWorld.AddPoint(pPoint2.Clone());
            PPoint pPoint3 = new PPoint((float)((double)n + (double)n3 * Math.cos(f += this.random2(0.17453292f, 6.1086526f))), (float)((double)n2 + (double)n3 * Math.sin(f)), this.para_pRad);
            this.DrawWorld.SetSpecialPoint(pPoint3);
            this.ScribbleWorld.SetSpecialPoint(pPoint3.Clone());
            this.DrawWorld.Add(new Line2D.Float(n, n2, pPoint2.x(), pPoint2.y()));
            this.DrawWorld.Add(new Line2D.Float(n, n2, pPoint3.x(), pPoint3.y()));
            this.ScribbleWorld.Add(new Line2D.Float(n, n2, pPoint2.x(), pPoint2.y()));
        } else {
            float f = this.random2(0.0f, (float)Math.PI * 2);
            float f2 = this.random2(0.0f, n3);
            PPoint pPoint4 = new PPoint((float)((double)n + (double)f2 * Math.cos(f)), (float)((double)n2 + (double)f2 * Math.sin(f)), this.para_pRad);
            this.DrawWorld.SetSpecialPoint(pPoint4);
            this.ScribbleWorld.SetSpecialPoint(pPoint4.Clone());
        }
    }
}

