
/*
 * Propo.java  -  Java 2 program for training the eye to see proportions.
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import java.awt.*;
import java.awt.Container.*;
import java.awt.event.*;
import java.util.Date.*;

import java.util.Date;
import java.text.DateFormat;

import java.util.Locale;
import java.util.*;
import java.text.*;

import java.lang.Class.*;
import java.io.InputStream;
import java.io.*;

//import java.io.*;


import java.util.Calendar;
import java.util.TimeZone;

import java.util.Properties;

// Application class
public class Propo 
{
    public WorldAI propoAI;
    public PropoGUI propoGUI;
    public Locale currentLocale;
    public ResourceBundle rb;
    public String playerName;


    // return username or "Anonymous" if no username is found. 
    public String getUserName()
    {
	String player = System.getProperty( "user.name" );
	player.trim();
	
	if ((player == "") || (player == null))
	    {
		player = rb.getString( "anonymousPlayer" );
	    }
	else
	    {
		// make first letter in username uppercase
		char c = player.charAt(0);

		if (Character.isLetter( c ))
		    {
			c = Character.toUpperCase( c );
			
		    }
		player = Character.toString( c ) + player.substring(1);
		
	    }

	return ( player );

    }




    public Propo()
    {
	// debug:
	//Properties pr = System.getProperties();
	//pr.list(System.out);
	currentLocale = java.util.Locale.getDefault();
	playerName = getUserName();

        rb = ResourceBundle.getBundle("messages", currentLocale);

        propoGUI = new PropoGUI( this );
	propoAI = new WorldAI( this );	

        propoGUI.buildUI( propoGUI.getContentPane() );
        propoGUI.pack();
        propoGUI.setVisible(true);

	propoGUI.newGame();

    }

       
    public static void main(String[] args) 
    {
	Propo test = new Propo();
    }
}

