
/*
 * PLine.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;


import java.awt.geom.*;
import java.awt.BasicStroke.*;
import java.util.*;


public class PLine extends Line2D.Float implements PObject
{
    float width;

    PPoint p1, p2;
    

    PLine()
    {
	super();
    }
    

    PLine(float x1, float y1, float x2, float y2, float lineWidth) 
    {
	super (x1, y1, x2, y2);

	p1 = new PPoint (x1, y1, 0f);
	p2 = new PPoint (x2, y2, 0f);
	width=lineWidth;
    }
    
    public void print() 
    {
	System.out.println("PLine.print: " );
    }

    public void setWidth( float w )
    {
	width = w;
    }

    public double getMaxX()
    {
	return ((float) Math.max( p1.getMaxX(), p2.getMaxX() ));
    }

    public double getMinX()
    {
	return ((float) Math.min( p1.getMinX(), p2.getMinX() ));
    }

    public double getMaxY()
    {
	return ((float) Math.max( p1.getMaxY(), p2.getMaxY() ));
    }

    public double getMinY()
    {
	return ((float) Math.min( p1.getMinY(), p2.getMinY() ));
    }


    // operations 
    // ----------


    public int OType()
    {
	return ( Consts.PLINE );
    }

    public Object clone()
    {
	PLine temp=new PLine ( p1.x(), p1.y(), p2.x(), p2.y(), width );
	return ( (Object) temp );
    }


    public void rotate( PPoint origin, double angle )
    {
	p1.rotate( origin, angle);
	p2.rotate( origin, angle);
    }

    // Scale a point
    public void scale(float factor)
    {
	p1.scale(factor);
	p2.scale(factor);
	width *= factor;
    }

    // Shift a point
    public void shift(PPoint pp)
    {
	p1.shift( pp );
	p2.shift( pp );
    }

    // Draw point
    public void draw(Graphics2D g2, Color c)
    {
	Stroke oldStroke = g2.getStroke();
	g2.setColor ( c );
	g2.setStroke(new BasicStroke(width));

	Line2D.Float drawObject = new Line2D.Float ( p1.x(), p1.y(), p2.x(), p2.y() );
	g2.draw( drawObject );
	g2.setStroke( oldStroke );
    }

}

