
/*
 * PCircle.java (part of Propo.java)
 * 
 * Copyright (c) 2003, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;


import java.awt.geom.*;
import java.awt.BasicStroke.*;
import java.util.*;


public class PCircle extends Ellipse2D.Float implements PObject
{
    float lineWidth;

    PCircle()
    {
	super();
    }
    
    // Add circle to the world
    PCircle (float x, float y, float r, float lw)
    {
	super(x-r,y-r,2*r, 2*r);
	lineWidth = lw;
    }

    PCircle (float x, float y, float w, float h, float lw)
    {
	super();
	setFrame ( x, y, w, h );
	lineWidth = lw;
    }

    public void print() 
    {
	System.out.println("PCircle.print: " );
    }

    public void setLineWidth( float lw )
    {
	lineWidth = lw;
    }

    // operations 
    // ----------


    public int OType()
    {
	return ( Consts.PCIRCLE );
    }

    public Object clone()
    {
	PCircle temp = new PCircle( this.x, this.y, this.width, this.height, this.lineWidth );
	return ( (Object) temp );
    }

    // Scale a point
    public void scale(float factor)
    {
	setFrame ( factor * this.x, factor * this.y, factor * this.width, factor * this.height );
	lineWidth *= factor;

    }

    public void rotate( PPoint origin, double angle )
    {
	// not supported .. yet..
    }

    // Shift a point
    public void shift(PPoint pp)
    {
	setFrame ( this.x+ pp.x(), this.y + pp.y(), this.width, this.height );
    }

    // Draw point
    public void draw(Graphics2D g2, Color c)
    {
	Stroke oldStroke = g2.getStroke();
	g2.setColor ( c );
	g2.setStroke(new BasicStroke(lineWidth));
	g2.draw( this );
	g2.setStroke( oldStroke );
    }

}

