
/*
 * HighScores.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.JOptionPane;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import javax.swing.table.TableColumn;


public class HighScores extends JDialog
{
    JDialog dialog;
    Propo controller;

    public HighScores (JFrame frame, String windowtitle, int record, Propo caller) 
    {


	// owner, title, modal?
	super(frame, windowtitle, true);
	dialog = this;
	controller = caller;

	JPanel hsPane = new JPanel();
	hsPane.setBackground(Color.white);
        hsPane.setLayout(new BoxLayout(hsPane, BoxLayout.Y_AXIS));

        HighScoreTable hst = new HighScoreTable( controller );
        JTable jtable = new JTable(hst);
	jtable.setShowGrid( false );

	jtable.setRowHeight( 30 );
	jtable.setPreferredScrollableViewportSize( new Dimension(800   , 70)) ;

	jtable.getColumnModel().getColumn(0).setPreferredWidth(65);
	jtable.getColumnModel().getColumn(1).setPreferredWidth(250);
	jtable.getColumnModel().getColumn(2).setPreferredWidth(260);
	jtable.getColumnModel().getColumn(3).setPreferredWidth(180);


	jtable.setSelectionForeground( Color.black );
	jtable.setSelectionBackground( Color.white );
	jtable.setRowSelectionAllowed( false );
	jtable.setColumnSelectionAllowed( false );

	
	HighScoreRenderer hsr = new HighScoreRenderer( record );

	try
	    {
		jtable.setDefaultRenderer( Class.forName( "java.lang.String" ), hsr );
	    }
	catch( ClassNotFoundException ex )
	    {
		System.out.println("HighScores.java: error.");
		System.exit( 0 );
	    }

	hsPane.add (jtable, BorderLayout.CENTER);

	// OK button
	JButton ok = new JButton ("OK");

	ok.addActionListener( new ActionListener() 
	    {
               public void actionPerformed(ActionEvent evt) 
		{
		    dialog.dispose();
               } 
	    });
	setDefaultCloseOperation( JDialog.DISPOSE_ON_CLOSE );

	hsPane.add(ok);
	hsPane.doLayout();
	getContentPane().add(hsPane);

	pack();
	setVisible( true );

    }

}

