
/*
 * PPoint.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;


import java.awt.geom.*;
import java.awt.BasicStroke.*;
import java.util.*;


public class PPoint implements PObject
{
    private float x0, y0;
    private float radius;

    PPoint()
    {
    }

    PPoint(float radius0)
    {
	radius = radius0;
    }
    
    PPoint(PPoint pp, float rad)
    {
	x0 = pp.x();
	y0 = pp.y();
	radius = rad;
    }

    PPoint(float x1, float x2, float rad) 
    {
	x0 = x1;
	y0 = x2;
	radius = rad;
    }

    public int OType()
    {
	return ( Consts.PPOINT );
    }

    public Object clone()
    {
	PPoint t = new PPoint(this.x(), this.y(), this.radius);
	return ( (Object) t );
    }

    public float x()
    {
	return ( x0 );
    }

    public float y()
    {
	return ( y0 );
    }

    public float radius()
    {
	return ( radius );
    }


    public double getMaxX()
    {
	return (x0+radius);
    }

    public double getMaxY()
    {
	return (y0+radius);
    }


    public double getMinX()
    {
	return (x0-radius);
    }

    public double getMinY()
    {
	return (y0-radius);
    }

    public String toString()
    {
	return ("PPoint: x="+ x0 + ", y=" + y0 + ", radius=" + radius + ".");
    }
    
    public void print() 
    {
	System.out.println( this.toString() ); 
    }

    // measure length between this point and otherpoint. 
    public float distance(PPoint otherpoint)
    {
	double a = Math.pow((double) this.x() - otherpoint.x(), 2) +
	           Math.pow((double) this.y() - otherpoint.y(), 2);
	return ((float) Math.sqrt(a));

    }

    public float length()
    {
	return (this.distance (new PPoint (0,0, 0f) ));
    }
    

    public void set(float x1, float x2) 
    {
	x0 = x1;
	y0 = x2;
    }

    public void setX(float x1) 
    {
	x0 = x1;
    }

    public void setY(float y1) 
    {
	y0 = y1;
    }


    public void setRadius(float rr) 
    {
	this.radius = rr;
    }

    // operations 
    // ---------- 

    public void rotate(PPoint origin, double angle)
    {
	origin.scale( (float) -1.0 );
	this.shift( origin );
	float x0prime = x0 * (float) Math.cos(angle) + y0 * (float) Math.sin(angle);
	float y0prime = y0 * (float) Math.cos(angle) - x0 * (float) Math.sin(angle);

	x0 = x0prime;
	y0 = y0prime;

	origin.scale( (float) -1.0 );
	this.shift( origin );
    }

    // Scale a point
    public void scale(float factor)
    {
	this.x0 *= factor;
	this.y0 *= factor;
	this.radius *= factor;
    }

    // Shift a point
    public void shift(PPoint pp)
    {
	this.x0 += pp.x();
	this.y0 += pp.y();
    }

    // Draw point
    public void draw(Graphics2D g2, Color c)
    {

	g2.setColor ( c );
	Ellipse2D.Float pd =  new Ellipse2D.Float((int) this.x()-this.radius, 
						  (int) this.y()-this.radius, 
						  this.radius*2, 
						  this.radius*2);
	g2.draw( pd );
	g2.fill( pd );
    }

}

