/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.util.Date;

public class WorldAI {
    public GameStatistics CurrentGame;
    public HighScoreData HighScores = new HighScoreData(10);
    boolean LastOK;
    boolean BullsEye;
    public World DrawWorld;
    public World ScribbleWorld;
    float currentScaleFactor = 1.0f;
    int para_numPoints = 5;
    int para_minDist = 80;
    float para_border = 0.05f;
    float para_sborder = 0.3f;
    float para_pRad = 4.0f;
    float para_lw = 3.0f;
    Propo controller;
    Date startdate;

    WorldAI(Propo propo) {
        this.reset();
        this.BullsEye = false;
        this.LastOK = true;
        this.DrawWorld = new World();
        this.ScribbleWorld = new World();
        this.controller = propo;
    }

    public void JudgePoint(PPoint pPoint) {
        if (this.ScribbleWorld.DistanceFromSpecialPoint(pPoint) <= 2.0f * this.ScribbleWorld.specialPoint.radius() + 1.0f) {
            this.CurrentGame.ExerciseOK();
            this.LastOK = true;
            this.BullsEye = this.ScribbleWorld.DistanceFromSpecialPoint(pPoint) <= this.ScribbleWorld.specialPoint.radius();
        } else {
            this.CurrentGame.ExerciseNotOK();
            this.LastOK = false;
        }
    }

    public void reset() {
        this.CurrentGame = new GameStatistics();
    }

    public void NewExercise() {
        Dimension dimension = this.controller.propoGUI.coordinateArea.getSize();
        do {
            this.DrawWorld.clear();
            this.ScribbleWorld.clear();
            int n = 0;
            while ((n = (int)Math.ceil(Math.random() * 4.0)) == 0) {
            }
            switch (n) {
                case 1: {
                    this.RandomPoints(dimension);
                    break;
                }
                case 2: {
                    this.ProportionalLine(dimension);
                    break;
                }
                case 3: {
                    this.PointsOnCircle(dimension);
                    break;
                }
                case 4: {
                    this.PointInRectangle(dimension);
                    break;
                }
                default: {
                    this.ProportionalLine(dimension);
                }
            }
        } while (!this.rescale(dimension, this.ScribbleWorld) || !this.rescale(dimension, this.DrawWorld));
    }

    private float ranborder(float f) {
        return (1.0f - 2.0f * f) * (float)Math.random() + f;
    }

    private float random2(float f, float f2) {
        float f3 = (float)Math.random();
        float f4 = f2 * f3 + (1.0f - f3) * f;
        return f4;
    }

    private boolean rescale(Dimension dimension, World world) {
        float f = (float)this.para_minDist / this.ScribbleWorld.minDistance();
        f = Math.max(0.5f, f);
        PPoint pPoint = new PPoint(world.ULCorner(), 0.0f);
        pPoint.scale(-1.0f);
        world.shift(pPoint);
        pPoint = new PPoint(world.LRCorner(), 0.0f);
        float f2 = Math.min((float)(dimension.width - 10) / pPoint.x(), (float)(dimension.height - 10) / pPoint.y());
        f2 = (float)((double)f2 * (1.0 - 2.0 * (double)this.para_border));
        if (!(f < f2)) {
            return false;
        }
        this.currentScaleFactor = this.random2(f, f2);
        world.scale(this.currentScaleFactor);
        pPoint = new PPoint(world.LRCorner(), 0.0f);
        PPoint pPoint2 = new PPoint(0.0f, 0.0f, 0.0f);
        pPoint2.setX(this.random2((float)dimension.width * 0.1f, 0.9f * (float)dimension.width - pPoint.x()));
        pPoint2.setY(this.random2((float)dimension.height * 0.1f, 0.9f * (float)dimension.height - pPoint.y()));
        world.shift(pPoint2);
        return true;
    }

    private void PointInRectangle(Dimension dimension) {
        int n = (int)((float)dimension.width * this.random2(0.1f, 0.5f));
        int n2 = (int)((float)dimension.height * this.random2(0.1f, 0.5f));
        int n3 = (int)this.random2((float)n + 2.0f * (float)this.para_minDist, (float)dimension.width * 0.9f);
        int n4 = (int)this.random2((float)n2 + 2.0f * (float)this.para_minDist, (float)dimension.height * 0.9f);
        this.DrawWorld.add(new PPoint(n, n2, this.para_pRad));
        this.DrawWorld.add(new PPoint(n, n4, this.para_pRad));
        this.DrawWorld.add(new PPoint(n3, n2, this.para_pRad));
        this.DrawWorld.add(new PPoint(n3, n4, this.para_pRad));
        this.DrawWorld.add(new PLine(n, n2, n, n4, this.para_lw));
        this.DrawWorld.add(new PLine(n, n2, n3, n2, this.para_lw));
        this.DrawWorld.add(new PLine(n3, n2, n3, n4, this.para_lw));
        this.DrawWorld.add(new PLine(n, n4, n3, n4, this.para_lw));
        float f = n4 - n2;
        float f2 = n3 - n;
        PPoint pPoint = new PPoint(this.random2((float)((double)n + 0.01 * (double)f2), (float)((double)n3 - 0.01 * (double)f2)), this.random2((float)((double)n2 + 0.01 * (double)f), (float)((double)n4 - 0.01 * (double)f)), this.para_pRad);
        this.DrawWorld.setSpecialPoint(pPoint);
        this.DrawWorld.rotate(new PPoint(0.0f, 0.0f, 0.0f), this.random2(0.0f, (float)Math.PI * 2));
        this.ScribbleWorld = this.DrawWorld.Clone();
    }

    public void RandomPoints(Dimension dimension) {
        int n = (int)((double)dimension.width * (double)this.ranborder(this.para_sborder));
        int n2 = (int)((double)dimension.height * (double)this.ranborder(this.para_sborder));
        PPoint pPoint = new PPoint(n, n2, this.para_pRad);
        this.DrawWorld.setSpecialPoint(pPoint);
        int n3 = 0;
        while (n3 < this.para_numPoints) {
            n = (int)((double)dimension.width * (double)this.ranborder(this.para_border));
            PPoint pPoint2 = new PPoint(n, n2 = (int)((double)dimension.height * (double)this.ranborder(this.para_border)), this.para_pRad);
            if (!(this.DrawWorld.minDistance(pPoint2) > (float)this.para_minDist)) continue;
            ++n3;
            this.DrawWorld.add(pPoint2);
        }
        this.ScribbleWorld = this.DrawWorld.Clone();
    }

    public void ProportionalLine(Dimension dimension) {
        int n;
        int n2;
        int n3;
        int n4;
        PPoint pPoint = new PPoint(this.para_pRad);
        PPoint pPoint2 = new PPoint(this.para_pRad);
        do {
            n4 = (int)((double)dimension.width * (double)this.ranborder(this.para_border));
            n3 = (int)((double)dimension.height * (double)this.ranborder(this.para_border));
            pPoint.set(n4, n3);
            n2 = (int)((double)dimension.width * (double)this.ranborder(this.para_border));
            n = (int)((double)dimension.height * (double)this.ranborder(this.para_border));
            pPoint2.set(n2, n);
        } while (pPoint.distance(pPoint2) < (float)(this.para_minDist * 3));
        this.DrawWorld.add(new PPoint(n4, n3, this.para_pRad));
        this.DrawWorld.add(new PPoint(n2, n, this.para_pRad));
        this.DrawWorld.add(new PLine(n4, n3, n2, n, this.para_lw));
        if (Math.random() > 0.5) {
            int n5 = (int)((double)dimension.width * (double)this.ranborder(this.para_sborder));
            int n6 = (int)((double)dimension.height * (double)this.ranborder(this.para_sborder));
            this.DrawWorld.setSpecialPoint(new PPoint(n5, n6, this.para_pRad));
        } else {
            PPoint pPoint3 = new PPoint(n4 - n2, n3 - n, 0.0f);
            float f = this.ranborder(0.2f);
            pPoint3.scale(f);
            PPoint pPoint4 = new PPoint(n2, n, this.para_pRad);
            pPoint4.shift(pPoint3);
            this.DrawWorld.setSpecialPoint(pPoint4);
        }
        this.ScribbleWorld = this.DrawWorld.Clone();
    }

    public void PointsOnCircle(Dimension dimension) {
        int n = (int)((double)dimension.width * (double)this.ranborder(this.para_sborder));
        int n2 = (int)((double)dimension.height * (double)this.ranborder(this.para_sborder));
        PPoint pPoint = new PPoint(n, n2, this.para_pRad);
        int n3 = Math.min(n, dimension.width - n);
        n3 = Math.min(n3, n2);
        n3 = Math.min(n3, dimension.height - n2);
        n3 = (int)((float)n3 * 0.85f);
        this.DrawWorld.add(new PCircle(n, n2, n3, this.para_lw));
        if (Math.random() < 0.5) {
            this.DrawWorld.add(pPoint);
            float f = this.random2(0.0f, (float)Math.PI * 2);
            PPoint pPoint2 = new PPoint((float)((double)n + (double)n3 * Math.cos(f)), (float)((double)n2 + (double)n3 * Math.sin(f)), this.para_pRad);
            this.DrawWorld.add(pPoint2);
            this.DrawWorld.add(new PLine(n, n2, pPoint2.x(), pPoint2.y(), this.para_lw));
            this.ScribbleWorld = this.DrawWorld.Clone();
            PPoint pPoint3 = new PPoint((float)((double)n + (double)n3 * Math.cos(f += this.random2(0.17453292f, 6.1086526f))), (float)((double)n2 + (double)n3 * Math.sin(f)), this.para_pRad);
            this.DrawWorld.setSpecialPoint(pPoint3);
            this.ScribbleWorld.setSpecialPoint((PPoint)pPoint3.clone());
            this.DrawWorld.add(new PLine(n, n2, pPoint3.x(), pPoint3.y(), this.para_lw));
        } else {
            float f = this.random2(0.0f, (float)Math.PI * 2);
            float f2 = this.random2(0.0f, n3);
            this.ScribbleWorld = this.DrawWorld.Clone();
            PPoint pPoint4 = new PPoint((float)((double)n + (double)f2 * Math.cos(f)), (float)((double)n2 + (double)f2 * Math.sin(f)), this.para_pRad);
            this.DrawWorld.setSpecialPoint(pPoint4);
            this.ScribbleWorld.setSpecialPoint((PPoint)pPoint4.clone());
        }
    }
}

