/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

class ScribbleArea
extends JPanel {
    PPoint point;
    Dimension preferredSize = new Dimension(400, 300);
    boolean enableMouse;
    boolean pointSet;
    Timer timer;
    int tCount;
    Propo controller;

    public ScribbleArea(Propo propo) {
        this.controller = propo;
        this.point = new PPoint();
        this.pointSet = false;
        this.timer = new Timer(1500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScribbleArea.this.pointSet = false;
                ScribbleArea.this.timer.stop();
                ScribbleArea.this.controller.propoAI.NewExercise();
                ScribbleArea.this.controller.propoGUI.update();
                ScribbleArea.this.enableMouse = true;
            }
        });
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createLoweredBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
        this.setBorder(compoundBorder);
        this.setBackground(Color.white);
        this.setCursor(new Cursor(1));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!ScribbleArea.this.enableMouse) {
                    return;
                }
                ScribbleArea.this.pointSet = true;
                ScribbleArea.this.point.set(mouseEvent.getX(), mouseEvent.getY());
                ScribbleArea.this.point.setRadius(ScribbleArea.this.controller.propoAI.ScribbleWorld.specialPoint.radius());
                ScribbleArea.this.controller.propoAI.JudgePoint(ScribbleArea.this.point);
                ScribbleArea.this.controller.propoGUI.toprow.repaint();
                ScribbleArea.this.repaint();
                if (ScribbleArea.this.controller.propoAI.CurrentGame.ExercisesCompleted() == 50) {
                    int n = ScribbleArea.this.controller.propoGUI.addHighScore();
                    if (n == 0) {
                        JOptionPane.showMessageDialog(null, ScribbleArea.this.controller.rb.getString("sorry"), ScribbleArea.this.controller.rb.getString("gameOver"), -1);
                    }
                    ScribbleArea.this.pointSet = false;
                    ScribbleArea.this.controller.propoGUI.newGame();
                } else {
                    ScribbleArea.this.tCount = 1500;
                    ScribbleArea.this.timer.start();
                    ScribbleArea.this.enableMouse = false;
                }
            }
        });
        this.enableMouse = true;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.controller.propoAI.ScribbleWorld.DrawObjects(graphics);
        if (this.pointSet) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.point.draw(graphics2D, Color.blue);
            this.controller.propoAI.ScribbleWorld.DrawSpecialPoint(graphics);
        }
    }
}

