/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

public class PPoint
implements PObject {
    private float x0;
    private float y0;
    private float radius;

    PPoint() {
    }

    PPoint(float f) {
        this.radius = f;
    }

    PPoint(PPoint pPoint, float f) {
        this.x0 = pPoint.x();
        this.y0 = pPoint.y();
        this.radius = f;
    }

    PPoint(float f, float f2, float f3) {
        this.x0 = f;
        this.y0 = f2;
        this.radius = f3;
    }

    public int OType() {
        return 1;
    }

    public Object clone() {
        PPoint pPoint = new PPoint(this.x(), this.y(), this.radius);
        return pPoint;
    }

    public float x() {
        return this.x0;
    }

    public float y() {
        return this.y0;
    }

    public float radius() {
        return this.radius;
    }

    public double getMaxX() {
        return this.x0 + this.radius;
    }

    public double getMaxY() {
        return this.y0 + this.radius;
    }

    public double getMinX() {
        return this.x0 - this.radius;
    }

    public double getMinY() {
        return this.y0 - this.radius;
    }

    public String toString() {
        return "PPoint: x=" + this.x0 + ", y=" + this.y0 + ", radius=" + this.radius + ".";
    }

    public void print() {
        System.out.println(this.toString());
    }

    public float distance(PPoint pPoint) {
        double d = Math.pow((double)this.x() - (double)pPoint.x(), 2.0) + Math.pow((double)this.y() - (double)pPoint.y(), 2.0);
        return (float)Math.sqrt(d);
    }

    public float length() {
        return this.distance(new PPoint(0.0f, 0.0f, 0.0f));
    }

    public void set(float f, float f2) {
        this.x0 = f;
        this.y0 = f2;
    }

    public void setX(float f) {
        this.x0 = f;
    }

    public void setY(float f) {
        this.y0 = f;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void rotate(PPoint pPoint, double d) {
        pPoint.scale(-1.0f);
        this.shift(pPoint);
        float f = this.x0 * (float)Math.cos(d) + this.y0 * (float)Math.sin(d);
        float f2 = this.y0 * (float)Math.cos(d) - this.x0 * (float)Math.sin(d);
        this.x0 = f;
        this.y0 = f2;
        pPoint.scale(-1.0f);
        this.shift(pPoint);
    }

    public void scale(float f) {
        this.x0 *= f;
        this.y0 *= f;
        this.radius *= f;
    }

    public void shift(PPoint pPoint) {
        this.x0 += pPoint.x();
        this.y0 += pPoint.y();
    }

    public void draw(Graphics2D graphics2D, Color color) {
        graphics2D.setColor(color);
        Ellipse2D.Float float_ = new Ellipse2D.Float((float)((int)this.x()) - this.radius, (float)((int)this.y()) - this.radius, this.radius * 2.0f, this.radius * 2.0f);
        graphics2D.draw(float_);
        graphics2D.fill(float_);
    }
}

