/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class World {
    float F_MIN = Float.MIN_VALUE;
    float F_MAX = Float.MAX_VALUE;
    public PPoint specialPoint;
    LinkedList worldData = new LinkedList();

    World() {
        this.specialPoint = new PPoint();
    }

    public void add(PObject pObject) {
        this.worldData.add(pObject);
    }

    public void add(PPoint pPoint) {
        this.worldData.add(pPoint);
    }

    public void add(PLine pLine) {
        this.worldData.add(pLine);
    }

    public void add(PCircle pCircle) {
        this.worldData.add(pCircle);
    }

    public void clear() {
        this.worldData.clear();
    }

    public World Clone() {
        World world = new World();
        Iterator iterator = this.worldData.iterator();
        while (iterator.hasNext()) {
            PObject pObject = (PObject)iterator.next();
            world.add((PObject)pObject.clone());
        }
        world.setSpecialPoint((PPoint)this.specialPoint.clone());
        return world;
    }

    public String toString() {
        String string = "\nWorld: \n";
        ListIterator listIterator = this.worldData.listIterator();
        string = string + "Special point = " + this.specialPoint.toString() + "\n";
        while (listIterator.hasNext()) {
            PObject pObject = (PObject)listIterator.next();
            string = string + "" + listIterator.nextIndex() + " : " + pObject.toString() + "\n";
        }
        string = string + "---- \n";
        return string;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public void setSpecialPoint(PPoint pPoint) {
        this.specialPoint = pPoint;
    }

    public float DistanceFromSpecialPoint(PPoint pPoint) {
        return pPoint.distance(this.specialPoint);
    }

    public float minDistance(PPoint pPoint) {
        float f = this.DistanceFromSpecialPoint(pPoint);
        ListIterator listIterator = this.worldData.listIterator();
        while (this.hasNextPoint(listIterator)) {
            PObject pObject = (PObject)listIterator.next();
            if (pObject.OType() != 1) continue;
            f = Math.min(pPoint.distance((PPoint)pObject), f);
        }
        return f;
    }

    private PPoint nextPoint(ListIterator listIterator) {
        PObject pObject = null;
        while (listIterator.hasNext()) {
            pObject = (PObject)listIterator.next();
            if (pObject.OType() != 1) continue;
            return (PPoint)pObject;
        }
        return null;
    }

    private boolean hasNextPoint(ListIterator listIterator) {
        PObject pObject = null;
        int n = listIterator.nextIndex();
        while (listIterator.hasNext()) {
            pObject = (PObject)listIterator.next();
            if (pObject.OType() != 1) continue;
            while (listIterator.nextIndex() != n) {
                listIterator.previous();
            }
            return true;
        }
        while (listIterator.nextIndex() != n) {
            listIterator.previous();
        }
        return false;
    }

    public float minDistance() {
        float f = this.F_MAX;
        ListIterator listIterator = this.worldData.listIterator();
        while (this.hasNextPoint(listIterator)) {
            PPoint pPoint = new PPoint(this.nextPoint(listIterator), 0.0f);
            f = Math.min(f, this.DistanceFromSpecialPoint(pPoint));
            int n = listIterator.nextIndex();
            while (this.hasNextPoint(listIterator)) {
                PPoint pPoint2 = new PPoint(this.nextPoint(listIterator), 0.0f);
                f = Math.min(f, pPoint.distance(pPoint2));
            }
            while (n != listIterator.nextIndex()) {
                listIterator.previous();
            }
        }
        return f;
    }

    public PPoint LRCorner() {
        PPoint pPoint = new PPoint(this.specialPoint, 0.0f);
        Iterator iterator = this.worldData.iterator();
        while (iterator.hasNext()) {
            PObject pObject = (PObject)iterator.next();
            pPoint.setX(Math.max((float)pObject.getMaxX(), pPoint.x()));
            pPoint.setY(Math.max((float)pObject.getMaxY(), pPoint.y()));
        }
        return pPoint;
    }

    public PPoint ULCorner() {
        PPoint pPoint = new PPoint(this.specialPoint, 0.0f);
        Iterator iterator = this.worldData.iterator();
        while (iterator.hasNext()) {
            PObject pObject = (PObject)iterator.next();
            pPoint.setX(Math.min((float)pObject.getMinX(), pPoint.x()));
            pPoint.setY(Math.min((float)pObject.getMinY(), pPoint.y()));
        }
        return pPoint;
    }

    public void scale(float f) {
        Iterator iterator = this.worldData.iterator();
        while (iterator.hasNext()) {
            PObject pObject = (PObject)iterator.next();
            pObject.scale(f);
        }
        this.specialPoint.scale(f);
    }

    public void rotate(PPoint pPoint, double d) {
        Iterator iterator = this.worldData.iterator();
        while (iterator.hasNext()) {
            PObject pObject = (PObject)iterator.next();
            pObject.rotate(pPoint, d);
        }
        this.specialPoint.rotate(pPoint, d);
    }

    public void shift(PPoint pPoint) {
        Iterator iterator = this.worldData.iterator();
        while (iterator.hasNext()) {
            PObject pObject = (PObject)iterator.next();
            pObject.shift(pPoint);
        }
        this.specialPoint.shift(pPoint);
    }

    public void DrawAll(Graphics graphics) {
        this.DrawObjects(graphics);
        this.DrawSpecialPoint(graphics);
    }

    public void DrawSpecialPoint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.specialPoint.draw(graphics2D, Color.red);
    }

    public void DrawObjects(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setColor(Color.black);
        Iterator iterator = this.worldData.iterator();
        while (iterator.hasNext()) {
            PObject pObject = (PObject)iterator.next();
            pObject.draw(graphics2D, Color.black);
        }
    }
}

