/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class PropoGUI
extends JFrame {
    public DrawArea coordinateArea;
    public ScribbleArea coordinateArea2;
    public Toprow toprow;
    Propo controller;

    private Integer getMnemonic(String string) {
        int n = this.controller.rb.getString(string).charAt(0) - 65 + 65;
        return new Integer(n);
    }

    public void showHighScores(int n) {
        if (this.controller.propoAI.HighScores.size() == 0) {
            JOptionPane.showMessageDialog(null, this.controller.rb.getString("hsEmpty"), this.controller.rb.getString("hsEmptyTitle"), 0);
        } else {
            new HighScores(this.controller.propoGUI, this.controller.rb.getString("hsTitle"), n, this.controller);
        }
    }

    public void newGame() {
        this.controller.propoAI.CurrentGame = new GameStatistics();
        this.controller.propoAI.NewExercise();
        this.toprow.Reset();
        this.update();
    }

    public int addHighScore() {
        GameStatistics gameStatistics = this.controller.propoAI.CurrentGame.Clone();
        int n = this.controller.propoAI.HighScores.ranking(gameStatistics);
        if (n != -1) {
            String string = JOptionPane.showInputDialog(this.controller.rb.getString("bravo"), (Object)this.controller.playerName);
            if (string != null) {
                string.trim();
                this.controller.playerName = string.length() == 0 ? this.controller.rb.getString("anonymousPlayer") : string;
                gameStatistics.SetName(this.controller.playerName);
                this.controller.propoAI.HighScores.add(gameStatistics);
                this.controller.propoAI.HighScores.Save();
                this.showHighScores(n);
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public PropoGUI(Propo propo) {
        super("Propo 0.1.2");
        this.controller = propo;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        ActionReset actionReset = new ActionReset();
        ActionViewHS actionViewHS = new ActionViewHS();
        ActionQuit actionQuit = new ActionQuit();
        ActionInstructions actionInstructions = new ActionInstructions();
        ActionAbout actionAbout = new ActionAbout();
        JMenu jMenu = new JMenu(this.controller.rb.getString("game"));
        jMenu.setMnemonic(this.getMnemonic("game_sc"));
        JMenuItem jMenuItem = new JMenuItem(actionReset);
        jMenu.add(actionReset);
        jMenu.add(actionViewHS);
        jMenu.add(actionQuit);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(this.controller.rb.getString("help"));
        jMenu2.setMnemonic(this.getMnemonic("help_sc"));
        jMenu2.add(actionInstructions);
        jMenu2.add(actionAbout);
        jMenuBar.add(jMenu2);
    }

    public void buildUI(Container container) {
        container.setLayout(new BoxLayout(container, 1));
        this.toprow = new Toprow(this.controller);
        container.add(this.toprow);
        this.coordinateArea = new DrawArea(this.controller);
        container.add(this.coordinateArea);
        this.coordinateArea2 = new ScribbleArea(this.controller);
        container.add(this.coordinateArea2);
        container.doLayout();
    }

    public void update() {
        this.coordinateArea.repaint();
        this.coordinateArea2.repaint();
        this.toprow.repaint();
    }

    private class ActionAbout
    extends AbstractAction {
        public ActionAbout() {
            super(PropoGUI.this.controller.rb.getString("about"));
            this.putValue("MnemonicKey", PropoGUI.this.getMnemonic("about_sc"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{new String("0.1.2")};
            URL uRL = this.getClass().getResource("bitmaps/icon_64x64.png");
            ImageIcon imageIcon = new ImageIcon(uRL);
            String string = MessageFormat.format(PropoGUI.this.controller.rb.getString("aboutMessage"), objectArray);
            JOptionPane.showMessageDialog(null, string, PropoGUI.this.controller.rb.getString("aboutTitle"), 1, imageIcon);
        }
    }

    private class ActionInstructions
    extends AbstractAction {
        public ActionInstructions() {
            super(PropoGUI.this.controller.rb.getString("instructions"));
            this.putValue("MnemonicKey", PropoGUI.this.getMnemonic("instructions_sc"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{Integer.toString(50)};
            String string = MessageFormat.format(PropoGUI.this.controller.rb.getString("instructionMessage"), objectArray);
            JOptionPane.showMessageDialog(null, string, PropoGUI.this.controller.rb.getString("instructionTitle"), 1);
        }
    }

    private class ActionQuit
    extends AbstractAction {
        public ActionQuit() {
            super(PropoGUI.this.controller.rb.getString("quit"));
            this.putValue("MnemonicKey", PropoGUI.this.getMnemonic("quit_sc"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    private class ActionViewHS
    extends AbstractAction {
        public ActionViewHS() {
            super(PropoGUI.this.controller.rb.getString("viewHighScores"));
            this.putValue("MnemonicKey", PropoGUI.this.getMnemonic("viewHighScores_sc"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropoGUI.this.showHighScores(-1);
        }
    }

    private class ActionReset
    extends AbstractAction {
        public ActionReset() {
            super(PropoGUI.this.controller.rb.getString("reset"));
            this.putValue("MnemonicKey", PropoGUI.this.getMnemonic("reset_sc"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropoGUI.this.newGame();
        }
    }
}

