
/*
 * Toprow.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

import java.util.*;
import java.net.*;

// Toprow of window
class Toprow extends JPanel 
{
    Propo controller;
    Dimension preferredSize = new Dimension(400,30);

    // bitmaps
    ImageIcon face_smiling, face_sunglasses, face_ohno, face_sleep;
    
    // statistics and time labels
    JLabel label, facelabel, label_time;

    private ImageIcon LoadIcon ( String loc )
    {
	ImageIcon res = new ImageIcon( loc );         

	if ( res == null ) 
	    {
		URL url = Propo.class.getResource( loc ); 
	        res = new ImageIcon( url );         
	    }

	return ( res );
    }

    public Toprow(Propo caller) 
    {
        this.controller = caller;     // save reference to caller
	setBackground(Color.white);

	// load faces

	face_smiling = LoadIcon("bitmaps/smile.jpg");         // :)
	face_sunglasses = LoadIcon("bitmaps/smile_happy.jpg");     // 8)
        face_ohno = LoadIcon("bitmaps/smile_ohno.jpg");            // :(
	face_sleep = LoadIcon("bitmaps/smile_ohno.jpg");           // :|

	this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

	// success rate 
        this.add(Box.createRigidArea(new Dimension(10, 0)));  
        label = new JLabel("");
	label.setFont(new Font("SansSerif", Font.BOLD, 24));
        label.setAlignmentX(LEFT_ALIGNMENT);
	this.add(label);
	this.add(Box.createHorizontalGlue());

	// face in the middle
	facelabel = new JLabel();
        this.add(facelabel);
        facelabel.setAlignmentX(RIGHT_ALIGNMENT);
	facelabel.setIcon (face_smiling);
	//this.add(Box.createHorizontalGlue());

	// time
        //label_time = new JLabel("time");
	//label_time.setFont(new Font("SansSerif", Font.BOLD, 24));
        //label_time.setAlignmentX(RIGHT_ALIGNMENT);
	//this.add(label_time);
	
	this.add(Box.createRigidArea(new Dimension(10, 0)));
	 

    }

    public Dimension getPreferredSize() 
    {
        return preferredSize;
    }

    // set value for first exercise
    public void Reset()
    {
	label.setText("");
	facelabel.setIcon (face_smiling);  // :-)
    }

    public void paintComponent(Graphics g) 
    {

	if ( controller.propoAI.CurrentGame.ExercisesCompleted() > 0 )
	    {
		label.setText (controller.propoAI.CurrentGame.toString() );

		// set face
		if (controller.propoAI.LastOK==true)
		    {
			if (controller.propoAI.BullsEye==false)
			    {
				facelabel.setIcon (face_smiling);  // :-)
			    }
			else
			    {
				facelabel.setIcon (face_sunglasses);  // 8-)
			    }
		    }
		else
		    {
			facelabel.setIcon (face_ohno);   // :-(
		    }
	    }
	else
	    {
		label.setText ("New game" );
	    }
		
        super.paintComponent(g);  
    }
}

