
/*
 * ScribbleArea.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

import java.util.*;
import java.lang.Thread.*;
import java.lang.InterruptedException;

// user points using this class
class ScribbleArea extends JPanel 
{
    PPoint point;
    Dimension preferredSize = new Dimension(400,300);
    boolean enableMouse;
    boolean pointSet;


    // stuff related to the timedelay between exercises. 
    javax.swing.Timer timer;
    int tCount;

    Propo controller;

    public ScribbleArea(Propo caller) 
    {
	// Reference to caller
        this.controller = caller;   

	// init entered point data
	point = new PPoint();
	pointSet = false;

	// create timer code
	timer = new javax.swing.Timer(500, new ActionListener() {
		public void actionPerformed(ActionEvent evt)
		{
		    tCount--;
		    if (tCount == 0)
			{
			    // .. choose new exercise after xx seconds.
			    pointSet = false;
			    timer.stop();

			    controller.propoAI.NewExercise();
			    controller.propoGUI.update();
			    enableMouse = true;
			}
		}
	    });

	// Set up GUI 
        Border raisedBevel = BorderFactory.createRaisedBevelBorder();
        Border loweredBevel = BorderFactory.createLoweredBevelBorder();
        Border compound = BorderFactory.createCompoundBorder
                              (raisedBevel, loweredBevel);
        setBorder(compound);
	setBackground (Color.white);
	setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));

        addMouseListener(new MouseAdapter() 
	    {

		//
		// Mouse handler for scribble area
		//
		public void mousePressed(MouseEvent e) 
		{
		    if (enableMouse == false)   // waiting for next exercise
			{
			    return;
			}
		    
		    // record chosen point
		    point.Set(e.getX(), e.getY());
		    point.SetRadius( controller.propoAI.para_pRad * 
				     controller.propoAI.currentScaleFactor );

		    // update top row
		    controller.propoAI.JudgePoint ( point );
		    controller.propoGUI.toprow.repaint();

		    pointSet = true;        // mark that point is chosen 
                                         // and should be drawn

		    repaint();           // .. and draw it

		    // is this the last exercise in the game?
		    if (controller.propoAI.CurrentGame.ExercisesCompleted() == 50)
			{
			    // yes, add possible highscore

			    int s = controller.propoGUI.addHighScore();
			    // s = 0 if no hs
			    if (s == 0)
				{
				    JOptionPane.showMessageDialog(null, "Game over", "Sorry!\n You did not make a high score this time.", JOptionPane.PLAIN_MESSAGE); 
				}

			    pointSet = false;
			    controller.propoGUI.newGame();

			}
		    else
			{
			    // no, start counter to set up next exercise
			    tCount = 3;          //  500ms delays.
			    timer.start();
			    enableMouse = false;
			}
		}
	    });

	enableMouse = true;
    }

    public Dimension getPreferredSize() 
    {
        return preferredSize;
    }

    public void paintComponent(Graphics g) 
    {
        super.paintComponent(g);  //paint background

	controller.propoAI.ScribbleWorld.DrawObjects(g);	

	// if user has chosen a point, draw it 
	if (pointSet == true)
	    {
		point.Draw( (Graphics2D) g, Color.blue);
		controller.propoAI.ScribbleWorld.DrawAll(g);
	    }
    }
}
