
/*
 * HighScoreRenderer.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.awt.Component;
import java.awt.Color;
import javax.swing.table.DefaultTableCellRenderer;

import javax.swing.JTable;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

public class HighScoreRenderer extends DefaultTableCellRenderer 
{
    int record;

    public HighScoreRenderer( int highlight )
    {
	record = highlight;
    }
    
    public Component getTableCellRendererComponent
        (JTable table, Object value, boolean isSelected,
        boolean hasFocus, int row, int column) 
    {
         Component cell = super.getTableCellRendererComponent
            (table, value, isSelected, hasFocus, row, column);

	 cell.setBackground( Color.white );
	 cell.setFont( new Font("SansSerif", Font.BOLD, 24) );

	 if (row == record)
	     {
		 cell.setForeground( Color.red );
	     }
	 else
	     {
		 cell.setForeground( Color.black );
	     }

	 if (column == 0)
	     {
		 setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
	     }
	 else
	     {
		 setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
	     }
         return cell;

     }
 }


