
/*
 * HighScoreData.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.util.*;
import java.io.*;

public class HighScoreData extends ArrayList
{
    //List hsdata;
    int size;
    
    public HighScoreData(int hs_size)
    {
	super();
	size = hs_size;

	Load();
    }

    // load Highscores from file 
    public void Load()
    {
	try 
	    {
		FileInputStream in = new FileInputStream("propo.highscores");
		ObjectInputStream ois = new ObjectInputStream(in);
		List temp =  (ArrayList) (ois.readObject());
		in.close();
		addAll ( temp );
		temp.clear();

	    } 
	catch (Exception e) 
	    {
		System.out.println("There was a problem reading the highscores.");
	    }
    }


    public void Save()
    {
	try 
	    {
		FileOutputStream out = new FileOutputStream("propo.highscores");
		ObjectOutputStream oos = new ObjectOutputStream(out);
		oos.writeObject( this );
		oos.flush();
		out.close();
	    } 
	catch (Exception e) 
	    {
		System.out.println("There was a problem writing the highscores.");
	    }
    }
    
    public void add( GameStatistics record )
    {
	super.add (record);
        Collections.sort(this);	

	// size() = elements in list
	// size = elements that should be in list
	while (size() > size)
	    {
		remove ( size()-1 );
	    }
        Collections.sort(this);	

    }

    // what is the ranking of record. Returns -1 if
    // record does not fit into the highscore list. 
    public int ranking( GameStatistics record )
    {
	super.add (record);   // normal ArrayList.add()
        Collections.sort(this);	
	int result =  indexOf( record );
	remove ( result);
        Collections.sort(this);	

	if (result == size)
	    {
		return ( -1 );
	    }
	return ( result );
    }

}
