
/*
 * GameStatistics.java (part of Propo.java)
 * 
 * Copyright (c) 2003, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import java.io.Serializable;
import java.io.*;
import java.util.Date;


public class GameStatistics implements Serializable, Comparable 
{
    public String Player;
    private int Ex;
    private int ExOK;
    public Date playDate;

    public GameStatistics()
    {
	Player = "";
	Ex = 0;
	ExOK = 0;
	playDate = new Date();
    }


    public GameStatistics Clone()
    {
	GameStatistics clone = new GameStatistics();

	clone.Player = this.Player;
	clone.ExOK = this.ExOK;
	clone.Ex = this.Ex;
	clone.playDate = (Date) this.playDate.clone();

	return (clone);
    }
    
    public void SetName(String newname)
    {
	Player = newname;
    }

    // record a successful exercise
    public void ExerciseOK()
    {
	Ex++;
	ExOK++;
    }

    // record an unsuccessful exercise
    public void ExerciseNotOK()
    {
	Ex++;
    }
    
    public float SuccessRate()
    {
	if ( Ex != 0 )
	    {
		return ( (float) ExOK) / ((float) Ex );
	    }
	return (1000f);
    }

    public int ExercisesCompleted()
    {
	return (Ex);
    }

    // are all entered points OK?
    public boolean AllOK ()
    {
	if (Ex == ExOK)
	    {
		return ( true );
	    }
	return ( false );
    }


    // are none of the entered points OK?
    public boolean NoneOK ()
    {
	if (ExOK == 0)
	    {
		return ( true );
	    }
	return ( false );
    }

    // compare function for highscore table
    public int compareTo(Object o) 
    {
        GameStatistics n = (GameStatistics) o;
	int s1 = (int) Math.round(100.0f * (float) this.ExOK / (float) this.Ex);
	int s2 = (int) Math.round(100.0f * (float) n.ExOK / (float) n.Ex);

	if (s1 < s2) 
	    {
		return (+1);
	    }
	else if (s1 == s2)
	    {
		if (this.Ex < n.Ex)
		    {
			return (+1);
		    }
		else if (this.Ex > n.Ex)
		    {
			return (-1);
		    }		    
		else 
		    {
			int t = this.Player.compareTo( n.Player );
			if (t!=0) 
			    { 
				return (t);
			    }
			t = this.playDate.compareTo( n.playDate );
			if (t!=0) 
			    {
				return (t);
			    }
			return (0);
		    }
	    }
	else if (s1 > s2)
	    {
		return (-1);
	    }

	return (0);   // for compiler

    }


    public boolean equals ( GameStatistics o)
    {
	if (this.compareTo( (GameStatistics) o ) == 0)
	    {
		return (true);
	    }
	else
	    {
		return (false);
	    }
    }


    // debug routines

    public String toString()
    {
	// all all OK or only a fraction?
	if (AllOK() == true)
	    {
		return("All of " + ExercisesCompleted() );
	    }
	else if (NoneOK() == true)
	    {			
		return("None of " + ExercisesCompleted() );
	    }
	int percent = (int) Math.round( 100f*SuccessRate() );

	return("" + percent + "% of " + ExercisesCompleted() );
    }


    public void print()
    {
	System.out.println(Player + " : " + toString());
    }


}
