
/*
 * PropoGUI.java  (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import java.awt.*;
import java.awt.Container.*;
import java.awt.event.*;
import java.util.Date.*;



// Application class
public class PropoGUI extends JFrame
{
    // UI objects
    public DrawArea coordinateArea; 
    public ScribbleArea coordinateArea2; 
    public Toprow toprow;

    // pointer to main program
    Propo controller;

    public void showHighScores(int hiscore)
    {
	if (controller.propoAI.HighScores.size() == 0)
	    {
		JOptionPane.showMessageDialog(null,  "The highscore list is empty!", "", JOptionPane.ERROR_MESSAGE); 
	    }
	else
	    {
		HighScores ss = new HighScores (controller.propoGUI, "Highscores", hiscore, controller );
	    }
    }


    // new game
    public void newGame() 
    {
	controller.propoAI.CurrentGame = new GameStatistics();
	controller.propoAI.NewExercise();
	
	toprow.Reset();
	update();
    }

    // add game to highscore list if it was a highscore.
    //
    // returns     0 = no hs,
    //             1 = was hs; OK button clicked, hs added,
    //             2 = was hs; cancel clicked, hs not added.
    public int addHighScore()
    {
	GameStatistics record = controller.propoAI.CurrentGame.Clone();
	
	int ranking  = controller.propoAI.HighScores.ranking( record );

	if (ranking != -1)
	    {
		// new highscore
		String name = JOptionPane.showInputDialog("You have a highscore. \nPlease enter your name.", controller.playerName);

		if (name != null) // cancel button yields null
		    {
			name.trim();  // leading and trailing whitespaces

			if (name.length() == 0)
			    {
				controller.playerName = "Anonymous";        // save name for next highscore entry
			    }
			else
			    {
				controller.playerName = name;
			    }

			record.SetName( controller.playerName );
			controller.propoAI.HighScores.add( record );
			controller.propoAI.HighScores.Save();
       			showHighScores( ranking );
			return ( 1 );
		    }
		return ( 2 );

	    }
	else
	    {
		return ( 0 );  // no hs.
	    }

    }

    // Action: for resetting statistics
    private class ActionReset extends AbstractAction 
    {

	public ActionReset() {
	    super("Reset");
	}

	public void actionPerformed(ActionEvent e) {
	    newGame();
	}
    }

    // Action: View Highscores
    private class ActionViewHS extends AbstractAction 
    {

	public ActionViewHS() {
	    super("View Highscores");
	}

	public void actionPerformed(ActionEvent e) 
	{
	    // -1 = do not hilight any entry 
	    showHighScores ( -1 );
	}
    }

    // Action: Exit Propo
    private class ActionExit extends AbstractAction 
    {

	public ActionExit() 
	{
	    super("Exit");
	}

	public void actionPerformed(ActionEvent e) 
	{
	    System.exit(0);
	}
    }

    // constructor
    public PropoGUI(Propo caller)
    {
	super ("Propo 0.1.1");  // give name to window

	controller = caller;
	
	// check for exit button 
        addWindowListener(new WindowAdapter() 
	    {
            public void windowClosing(WindowEvent e) 
		{
                System.exit(0);
		}
	    });

        // Create menu bar.
        JMenuBar MenuBar = new JMenuBar();
        setJMenuBar(MenuBar);

	Action actionReset = new ActionReset();
	Action actionViewHS = new ActionViewHS();
	Action actionExit = new ActionExit();

        //Build the first menu.
        JMenu Menu = new JMenu("Game");
        Menu.setMnemonic(KeyEvent.VK_A);
        Menu.getAccessibleContext().setAccessibleDescription(
                "Game menu for Propo");
        MenuBar.add(Menu);

	Menu.add ( actionReset );
	Menu.add ( actionViewHS );
	Menu.add ( actionExit );


    }

    public void buildUI(Container container) 
    {
        container.setLayout(new BoxLayout( container, BoxLayout.Y_AXIS ));

	// top row for statistics
	toprow = new Toprow( controller );
	container.add( toprow );

	// drawing area
        coordinateArea = new DrawArea( controller );
        container.add( coordinateArea );

	// scribble area
	coordinateArea2 = new ScribbleArea( controller );
        container.add( coordinateArea2 );

	// do the layout. 
	container.doLayout();


    }

    public void update()
    {
	coordinateArea.repaint(); 
	coordinateArea2.repaint(); 
	toprow.repaint();
	
    }


 
}
