
/*
 * PPoint.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;


import java.awt.geom.*;
import java.awt.BasicStroke.*;
import java.util.*;


public class PPoint
{
    float x0,y0;
    float radius;

    PPoint()
    {
    }

    PPoint(PPoint pp, float rad)
    {
	x0 = pp.x();
	y0 = pp.y();
	radius = rad;
    }

    PPoint(float x1, float x2, float rad) 
    {
	x0 = x1;
	y0 = x2;
	radius = rad;
    }

    public PPoint Clone()
    {
	PPoint t = new PPoint(this.x(), this.y(), this.radius);
	return (t);
    }

    public float x()
    {
	return (x0);
    }

    public float y()
    {
	return (y0);
    }

    
    public void Print() 
    {
	System.out.println("PPoint.print: " + x0 + "," + y0 + ". rad = "+ radius); 
    }

    // measure length between this point and otherpoint. 
    public float Distance(PPoint otherpoint)
    {
	double a = Math.pow((double) this.x() - otherpoint.x(), 2) +
	           Math.pow((double) this.y() - otherpoint.y(), 2);
	return ((float) Math.sqrt(a));

    }

    public float Length()
    {
	return (this.Distance (new PPoint (0,0, 0f) ));
    }
    

    public void Set(float x1, float x2) 
    {
	//System.out.println("PPoint set to " + x1 + x2 + "."); 
	x0 = x1;
	y0 = x2;
    }

    public void SetX(float x1) 
    {
	x0 = x1;
    }

    public void SetY(float y1) 
    {
	y0 = y1;
    }


    public void SetRadius(float rr) 
    {
	this.radius = rr;
    }

    // operations 
    // ----------

    // Scale a point
    public void Scale(float factor)
    {
	this.x0 *= factor;
	this.y0 *= factor;
	this.radius *= factor;
    }

    // Shift a point
    public void Shift(PPoint pp)
    {
	this.x0 += pp.x();
	this.y0 += pp.y();
    }

    // Draw point
    public void Draw(Graphics2D g2, Color c)
    {

	g2.setColor ( c );
	Ellipse2D.Float pd =  new Ellipse2D.Float((int) this.x()-this.radius, 
						  (int) this.y()-this.radius, 
						  this.radius*2, 
						  this.radius*2);
	g2.draw( pd );
	g2.fill( pd );
    }

}

