
/*
 * HighScoreTable.java (part of Propo.java)
 * 
 * Copyright (c) 2002, Matias Dahl 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.JScrollPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.JOptionPane;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Date;
import java.text.DateFormat;

import java.util.*;
import java.text.*;

class HighScoreTable extends AbstractTableModel 
{
    HighScoreData hsd;
    Locale locale;

    public HighScoreTable ( Locale loc, HighScoreData hs )
    {
	locale = loc;
	hsd = hs;
    }
    
    public int getColumnCount() 
    {
	return (4);
    }
    
    public int getRowCount() 
    {
	return ( hsd.size() );
    }
    
    //public String getColumnName(int col) {
    //	return columnNames[col];
    //}
    
    public Object getValueAt(int row, int col) 
    {
	GameStatistics en = (GameStatistics) hsd.get( row );
	if (col == 0)
	    {
		return (row+1 + ".");
	    }

	if (col == 1 )
	    {
		return (en.Player);
	    }

	if (col == 2)
	    {
		return (en.toString());
	    }
	
	if (col == 3)
	    {
		DateFormat dateFormatter;
		//dateFormatter = DateFormat.getDateTimeInstance(DateFormat.FULL, DateFormat.FULL, locale );
		dateFormatter = DateFormat.getDateInstance(DateFormat.DEFAULT,  locale );

		return (dateFormatter.format(en.playDate));
	    }
	
	return ("");  // for compiler
    }

    public Class getColumnClass(int c) 
    {
	return (String.class);
    }

    public boolean isCellEditable(int row, int col) 
    {
    	return false;
    }

}

