/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

class ScribbleArea
extends JPanel {
    PPoint point;
    Dimension preferredSize = new Dimension(400, 300);
    boolean enableMouse;
    boolean pointSet;
    Timer timer;
    int tCount;
    Propo controller;

    public ScribbleArea(Propo propo) {
        this.controller = propo;
        this.point = new PPoint();
        this.pointSet = false;
        this.timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                --ScribbleArea.this.tCount;
                if (ScribbleArea.this.tCount == 0) {
                    ScribbleArea.this.pointSet = false;
                    ScribbleArea.this.timer.stop();
                    ScribbleArea.this.controller.propoAI.NewExercise();
                    ScribbleArea.this.controller.propoGUI.update();
                    ScribbleArea.this.enableMouse = true;
                }
            }
        });
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createLoweredBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
        this.setBorder(compoundBorder);
        this.setBackground(Color.white);
        this.setCursor(new Cursor(1));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!ScribbleArea.this.enableMouse) {
                    return;
                }
                ScribbleArea.this.point.Set(mouseEvent.getX(), mouseEvent.getY());
                ScribbleArea.this.point.SetRadius(ScribbleArea.this.controller.propoAI.para_pRad * ScribbleArea.this.controller.propoAI.currentScaleFactor);
                ScribbleArea.this.controller.propoAI.JudgePoint(ScribbleArea.this.point);
                ScribbleArea.this.controller.propoGUI.toprow.repaint();
                ScribbleArea.this.pointSet = true;
                ScribbleArea.this.repaint();
                if (ScribbleArea.this.controller.propoAI.CurrentGame.ExercisesCompleted() == 50) {
                    int n = ScribbleArea.this.controller.propoGUI.addHighScore();
                    if (n == 0) {
                        JOptionPane.showMessageDialog(null, "Game over", "Sorry!\n You did not make a high score this time.", -1);
                    }
                    ScribbleArea.this.pointSet = false;
                    ScribbleArea.this.controller.propoGUI.newGame();
                } else {
                    ScribbleArea.this.tCount = 3;
                    ScribbleArea.this.timer.start();
                    ScribbleArea.this.enableMouse = false;
                }
            }
        });
        this.enableMouse = true;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.controller.propoAI.ScribbleWorld.DrawObjects(graphics);
        if (this.pointSet) {
            this.point.Draw((Graphics2D)graphics, Color.blue);
            this.controller.propoAI.ScribbleWorld.DrawAll(graphics);
        }
    }
}

