/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

public class PropoGUI
extends JFrame {
    public DrawArea coordinateArea;
    public ScribbleArea coordinateArea2;
    public Toprow toprow;
    Propo controller;

    public void showHighScores(int n) {
        if (this.controller.propoAI.HighScores.size() == 0) {
            JOptionPane.showMessageDialog(null, "The highscore list is empty!", "", 0);
        } else {
            HighScores highScores = new HighScores(this.controller.propoGUI, "Highscores", n, this.controller);
        }
    }

    public void newGame() {
        this.controller.propoAI.CurrentGame = new GameStatistics();
        this.controller.propoAI.NewExercise();
        this.toprow.Reset();
        this.update();
    }

    public int addHighScore() {
        GameStatistics gameStatistics = this.controller.propoAI.CurrentGame.Clone();
        int n = this.controller.propoAI.HighScores.ranking(gameStatistics);
        if (n != -1) {
            String string = JOptionPane.showInputDialog("You have a highscore. \nPlease enter your name.", (Object)this.controller.playerName);
            if (string != null) {
                string.trim();
                this.controller.playerName = string.length() == 0 ? "Anonymous" : string;
                gameStatistics.SetName(this.controller.playerName);
                this.controller.propoAI.HighScores.add(gameStatistics);
                this.controller.propoAI.HighScores.Save();
                this.showHighScores(n);
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public PropoGUI(Propo propo) {
        super("Propo 0.1.1");
        this.controller = propo;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        ActionReset actionReset = new ActionReset();
        ActionViewHS actionViewHS = new ActionViewHS();
        ActionExit actionExit = new ActionExit();
        JMenu jMenu = new JMenu("Game");
        jMenu.setMnemonic(65);
        jMenu.getAccessibleContext().setAccessibleDescription("Game menu for Propo");
        jMenuBar.add(jMenu);
        jMenu.add(actionReset);
        jMenu.add(actionViewHS);
        jMenu.add(actionExit);
    }

    public void buildUI(Container container) {
        container.setLayout(new BoxLayout(container, 1));
        this.toprow = new Toprow(this.controller);
        container.add(this.toprow);
        this.coordinateArea = new DrawArea(this.controller);
        container.add(this.coordinateArea);
        this.coordinateArea2 = new ScribbleArea(this.controller);
        container.add(this.coordinateArea2);
        container.doLayout();
    }

    public void update() {
        this.coordinateArea.repaint();
        this.coordinateArea2.repaint();
        this.toprow.repaint();
    }

    private class ActionExit
    extends AbstractAction {
        public ActionExit() {
            super("Exit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    private class ActionViewHS
    extends AbstractAction {
        public ActionViewHS() {
            super("View Highscores");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropoGUI.this.showHighScores(-1);
        }
    }

    private class ActionReset
    extends AbstractAction {
        public ActionReset() {
            super("Reset");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropoGUI.this.newGame();
        }
    }
}

