
function RNew = subRelationDT(P1,P2,R);
% 
% function RNew = subRelationDT(P1,P2,R);
% Lasse Leskela 2008-10-01
%
% Compute one step of the subrelation algorithm [1, Section 3.2] for a pair of
% probability matrices of discrete-time finite-state Markov processes.
%
% Input:
% - P1: S1xS1 probability matrix
% - P2: S2xS2 probability matrix
% - R:  S1xS2 array of logicals, R(x,y) = true if x and y are related
%
% Output:
% - RNew: S1xS2 array of logicals
%
% References:
% [1] L. Leskela. Stochastic relations of random variables and processes.
% http://arxiv.org/abs/0806.3562
%

RNew = R;
S1 = size(R,1);
S2 = size(R,2);

for x = 1:S1,
  % K is the set of states in y in S1 such that P1(x,y) > 0.
  K = find(P1(x,:)>0);
  xRight = rightConjugate(x,R);
  
  % i indexes the elements y in S2 that are related to x
  for i = 1:length(xRight),
    y = xRight(i);

    % j indexes the nonempty subsets of K
    for j = 1:(power(2,length(K)) - 1),
      U = getSubset(K,j);
      URight = rightConjugate(U,R);
      if sum(P1(x,U)) > sum(P2(y,URight)) + eps,
        RNew(x,y) = false;
        break;
      end;
    end;
  end;
end;
