
function printRelation(R,state1,state2)
%
% function printRelation(R,state1,state2)
% Lasse Leskela 2008-010-01
%
% Print R-related state pairs.
%
% Input:
% - R (array)     R(i,j) = 1 iff state1{i}is related to state2{j}
% - state1        state1{i} outputs the i-th state of state space 1
% - state2        state2{j} outputs the j-th state of state space 2
%

for sx=1:length(state1),
  if not(all(R(sx,:)==0)),
    for sy = find(R(sx,:)),
      disp(['(' num2str(state1{sx}) ') ~ (' num2str(state2{sy}) ')']);
    end;
    disp([' ']);
  end;
end;
