
function [R2,iter] = maximalSubrelationDT(P1,P2,R);
% 
% function R2 = maximalSubrelationDT(P1,P2,R);
% Lasse Leskela 2007-10-01
%
% Compute the maximal subrelation of a relation R that is preserved by a
% pair of probability matrices P1 and P2, see [1, Section 3.2].
%
% Input:
% - P1: S1xS1 probability matrix
% - P2: S2xS2 probability matrix
% - R:  S1xS2 array of logicals, R(x,y) = true if x and y are related
%
% Output:
% - R2:   S1xS2 array of logicals
% - iter: integer; the number of iterations used to compute R2
%
% References:
% [1] L. Leskela. Stochastic relations of random variables and processes.
% http://arxiv.org/abs/0806.3562
%

iter = 0;
R2 = subrelationCT(Q1,Q2,R);
while any(any(R2 ~= R)),
  iter = iter + 1;
  R = R2;
  R2 = subrelationCT(Q1,Q2,R);
end;

if not(any(any(R2)))
  disp('No nontrivial subrelation found.');
end;
