
function [R2,iter] = maximalSubrelationCT(Q1,Q2,R);
% 
% function R2 = maximalSubrelationCT(Q1,Q2,R);
% Lasse Leskela 2007-10-01
%
% Compute the maximal subrelation of a relation R that is preserved by a
% pair of rate kernels Q1 and Q2, see [1, Theorems 4.11 and 4.14].
%
% Input:
% - Q1: S1xS1 rate matrix (diagonal values are ignored)
% - Q2: S2xS2 rate matrix (diagonal values are ignored)
% - R:  S1xS2 array of logicals, R(x,y) = true if x and y are related
%
% Output:
% - R2:   S1xS2;   array of logicals
% - iter: integer; the number of iterations used to compute R2
%
% References:
% [1] L. Leskela. Stochastic relations of random variables and processes.
% http://arxiv.org/abs/0806.3562
%

iter = 0;
R2 = subrelationCT(Q1,Q2,R);
while any(any(R2 ~= R)),
  iter = iter + 1;
  R = R2;
  R2 = subrelationCT(Q1,Q2,R);
end;

if not(any(any(R2)))
  disp('No nontrivial subrelation found.');
end;
