
function b = isTransitive(R)
%
% function b = isTransitive(R)
% Lasse Leskela 2008-10-01
% 
% Check whether a relation is transitive, that is, whether
% x ~ y and y ~ z imply x ~ z.
%

s = size(R);
if s(1) ~= s(2),
  b = 0;
else,
  b = 1;
  S = s(1);
  for sx=1:S,
    for sy=1:S,
      for sz=1:S,
        if R(sx,sy) & R(sy,sz) & ~R(sx,sz),
          b = 0;
        end;
      end;
    end;
  end;
end;
