
function b = isAntisymmetric(R)
%
% function b = isAntisymmetric(R)
% Lasse Leskela 2008-10-01
% 
% Check whether a relation is antisymmetric, that is, whether
% x ~ y and y ~ x imply x = y.
%

s = size(R);
if s(1) ~= s(2),
  b = 0;
else,
  REq = eye(s(1));
  b = all(all(REq | not(R & R')));
end;
