
function V = getSubset(U,i);
% 
% function V = getSubset(U,i);
% Lasse Leskela 2008-10-01
%
% Return the i-th nonempty subset of a set U. The set U is represented
% by a number array, where it is assumed that the array does not contain
% duplicate values.
%
% input:
% - U: array of numbers
% - i: integer in the range [1, power(2,length(U))-1].
%
% output:
% - V: array of integers
%

mask = (dec2bin(i) == '1');
V = U([false(1,length(U)-length(mask)) mask]);
