% Mat-5.3701 
% Exercise 8, Problem 1b

% ----------------------------------------
% Time integration for the solution curve:
% ----------------------------------------
disp('Ex. 8 Pr. 1b');
clear all;

% Principal moments of inertia
I1 = 1;
I2 = 2;
I3 = 3;

% Constants of motion
% T = 1/2*(I1*ome1^2 + I2*ome2^2 + I3*ome3^2)
% With the initial values ome1 = 1, ome2 = 1, ome3 = 1
ome1init = 1;
ome2init = 1;
ome3init = 1;
T = 1/2*(I1*ome1init^2 + I2*ome2init^2 + I3*ome3init^2);
% L^2 = I1^2 + I2^2 + I3^2
R2 = I1^2 + I2^2 + I3^2;

% Constants for the ellipsoid and sphere
C1 = 1/I1 - 1/I3;
C2 = 1/I2 - 1/I3;
C3 = 2*T - R2/I3;


% Surface plots:
% --------------
disp('Plot the surfaces');

% Limits for the grid
xmax = sqrt(2*T*I1) + 0.5;
ymax = sqrt(2*T*I2) + 0.5;

% x,y grid
[x, y] = meshgrid([0: 0.1: xmax],[0: 0.1: ymax]);

% Sphere
z1 = sqrt( R2 - x.^2 - y.^2 );

% Ellipsoid
z2 = sqrt( 2*T*I3*( 1 - x.^2/(2*T*I1) - y.^2/(2*T*I2) ) );

figure(3); clf;

mesh(x, y, z1); hold on;
mesh(x, -y, z1); hold on;
mesh(-x, y, z1); hold on;
mesh(-x, -y, z1); hold on;

mesh(x, y, z2); hold on;
mesh(x, -y, z2); hold on;
mesh(-x, y, z2); hold on;
mesh(-x, -y, z2); hold on;


% Solve the equations of motion: 
% -----------------------------
disp('Solve the equations of motion for omega');

%[A, b, c] = rk_gauss_collocation(1);
% explicit Euler
%A = [0];
%b = [1];
% implicit Euler
%A = [1];
%b = [1];
% implicit midpoint rule
%A = [1/2];
%b = [1];
% implicit trapetsoidal rule
%A = [0 0 ; 1/2 1/2];
%b = [1/2 1/2];
%yt2 = rk_integrator(b, A, @(x)(Omega8b(0,x)), [ome1init ome2init ome3init], [0:0.1:10]);
%t = 0:0.1:10;
%yt = yt2';

% Explicit Runge-Kutta (4,5)
[t, yt] = ode45(@Omega8b, [0 10], [ome1init ome2init ome3init]);

% If any imaginary components
imaginary = any(imag(yt) ~= 0)

% The solution curve:
% ------------------
disp('Plot the solution curve');

for i = 1:length(t);
  
    L1(i) = I1*yt(i,1);
    L2(i) = I2*yt(i,2);
    L3(i) = I3*yt(i,3);
    % just to see it better
    L3(i) = I3*yt(i,3) + 0.1;
  
end

plot3(L1, L2, L3, 'b*-', 'Linewidth', 3); 

xlabel('L1')
ylabel('L2')
zlabel('L3')
hold off;


% The reference curve:
% --------------------
disp('Plot the surfaces');

figure(4); clf;

mesh(x, y, z1); hold on;
mesh(x, -y, z1); hold on;
mesh(-x, y, z1); hold on;
mesh(-x, -y, z1); hold on;

mesh(x, y, z2); hold on;
mesh(x, -y, z2); hold on;
mesh(-x, y, z2); hold on;
mesh(-x, -y, z2); hold on;

disp('Plot the reference curve');
xP = -sqrt( C3/C1 ): 0.05: sqrt( C3/C1 );

yP = sqrt( (C3 - C1*xP.^2)/C2 );
zP = sqrt( R2 - xP.^2 - yP.^2 );
plot3(xP, yP, zP, 'k*-','Linewidth', 3); 
hold on;

yP = -sqrt( (C3 - C1*xP.^2)/C2 );
zP = sqrt( R2 - xP.^2 - yP.^2 );
plot3(xP, yP, zP, 'k*-','Linewidth', 3); 

xlabel('L1')
ylabel('L2')
zlabel('L3')
hold off;
