% NCM   M-files and data files for use with
% "Numerical Computing with MATLAB", (c) 2004, Cleve Moler.
%
% See also NCMGUI, BLACKJACK, CENSUSGUI, EIGSVDGUI, FERN, FFTGUI, FLOATGUI,
% FZEROGUI, INTERPGUI, LORENZGUI, LUGUI, PDEGUI, PENNYMELT, QUADGUI, RANDGUI,
% SWINGER, TOUCHTONE, WALKER, WAVES, BSLASHTX, FFTTX, FMINTX, FZEROTX, LUTX,
% MEMBRANETX, ODE23TX, RANDTX, RANDNTX, QUADTX, PCHIPTX, SPLINETX
%
% "gui" files, interactive demonstrations
%
%   ncmgui      Master "gui".  
%   blackjack   Use random numbers in Monte Carlo simulation.
%   censusgui   Try to predict the US population in the year 2010.
%   eigsvdgui   Demonstrate computation of eigenvalues and singular values.
%   fern        Fractal fern.
%   fftgui      Demonstration of finite fourier transform.
%   floatgui    Show structure of floating point numbers.
%   fzerogui    Demonstrate scalar nonlinear zero finding.
%   interpgui   Behavior of interpolating functions.
%   lorenzgui   Plot the orbit around the Lorenz chaotic attractor.
%   lugui       Gaussian elimination demonstration.
%   pdegui      Demonstrate soluton of model partial differential equations.
%   pennymelt   Heat a penny.
%   pivotgolf   Pivot picking golf.
%   quadgui     Demonstrate numerical evaluation of a definite integral.
%   randgui     Monte carlo computation of pi.
%   swinger     Classic double pendulum.
%   touchtone   Use FFT to analyze touchtone dialing.
%   walker      Human gait.
%   waves       Wave equation in one and two space dimensions.
%
% "tx" files, textbook versions of MATLAB functions
%   bslashtx    Solve linear system (backslash).
%   ffttx       Fast finite fourier transform.
%   fmintx      Minimize function of one variable.
%   fzerotx     Find a zero of a function of one variable.
%   lutx        Triangular factorization.
%   membranetx  Eigenfunctions of the L-membrane.
%   ode23tx     Solve non-stiff differential equations.
%   randtx      Uniform random number generator.
%   randntx     Normal random number generator.
%   quadtx      Evaluate definite integral numerically.
%   pchiptx     Piecewise cubic hermite interpolant.
%   splinetx    Spline interpolant.
%
% Miscellaneous M-files
%   bizcard     Future version of The MathWorks business card.
%   brownian    Two-dimensional random walk.
%   circlegen   Generate approximate circles.
%   crypto      Cryptography example.
%   encrypt     Apply crypto to a text file.
%   digraph     Generate and analyze text digraph frequency matrix.
%   finitefern  Finite fractal fern.
%   fibnum      Fibonacci number.
%   fibonacci   Fibonacci sequence.
%   fftmatrix   Plot columns of the FFT matrix.
%   flame       Increasing radius of a spherical flame.
%   goldfract   Golden ratio continued fraction.
%   goldrect    Golden rectangle.
%   golub       Badly conditioned integer test matrices.
%   greetings   Seasonal holiday fractal.
%   imagesvd    Principle component analysis of images.
%   inregion    Points inside a polygonal region in the plane.
%   interp2dgui Behavior of periodic parametric curves.
%   qrsteps     Orthogonal-triangular decomposition.
%   pagerank    Google's PageRank.
%   pagerankpow PageRank by power method.
%   piecelin    Piecewise linear interpolation.
%   polyinterp  Polynomial interpolation.
%   powersin    Power series for sin(x).
%   primespiral Ulam's prime number spiral.
%   randmcg     Multiplicative congruential random number generator.
%   randssp     Parameters used by IBM's Scientific Subroutine Package.
%   randncond   Condition of random matrices.
%   rungeinterp Runge's polynomial interpolation example.
%   stegano     Investigate steganography in the default image.
%   sunspotstx  Updated version of toolbox/matlab/demos/sunspots.m.
%   surfer      Create the adjacency matrix of a portion of the Web.
%   threenplus1 The 3n+1 sequence.
%   tridisolve  Solve tridiagonal system of equations.
%   vandal      Exercise: what does this program do?
%
% Data files
%   elnino.dat
%   gettysburg.txt
%   longley.dat
%   harvard500.mat
%   membrane.mat
%   touchtone.mat
%   fern.png
%   walker.mat
