function y = Hami1b(x, m1, m2, l1, l2)

% Hamilton formalism

g = 9.81;

% x = q(1), phii = q(2)
q = x(1:2)';
% p_x = q(3), p_phii = q(4)
p = x(3:4)';

% Compute M and dM/dq
M = [ m1 + m2          m2*l2*cos(q(2)) ;
      m2*l2*cos(q(2))  m2*l2^2];

DM1 = [ 0 0 ; 0 0];

DM2 = [ 0 -m2*l2*sin(q(2)) ; 0 -m2*l2*sin(q(2))];

qq = inv(M)*p';

% Hamilton system's right hand side
pp(1) = 0.5*p*inv(M)*DM1*inv(M)*p';
pp(2) = 0.5*p*inv(M)*DM2*inv(M)*p' - m2*g*l2*sin(q(2));

y = [qq(1) qq(2) pp(1) pp(2)]';