maxIterations = 500;
gridSize = 1000;
rlim = [-0.748766713922161, -0.748766707771757];
ilim = [ 0.123640844894862,  0.123640851045266];

% Setup
t = tic();
x = linspace( rlim(1), rlim(2), gridSize );
y = linspace( ilim(1), ilim(2), gridSize );
[xGrid,yGrid] = meshgrid( x, y );
z0 = xGrid + 1i*yGrid;
count = zeros( size(z0) );

% Calculate
z = z0;
for n = 0:maxIterations
    z = z.*z + z0;
    inside = abs( z )<=2;
    count = count + inside;
end
count = log( count+1 );

% Show
cpuTime = toc( t );
%set( gcf, 'Position', [200 200 600 600] );
%imagesc( x, y, count );
%axis image
%colormap( [jet();flipud( jet() );0 0 0] );
%title( sprintf( '%1.2fsecs (without GPU)', cpuTime ) );
fprintf( '%1.2fsecs (without GPU)\n', cpuTime );

