maxIterations = 500;
gridSize = 1000;
rlim = [-0.748766713922161, -0.748766707771757];
ilim = [ 0.123640844894862,  0.123640851045266];


% Setup
t = tic();
x = gpuArray.linspace( rlim(1), rlim(2), gridSize );
y = gpuArray.linspace( ilim(1), ilim(2), gridSize );
[xGrid,yGrid] = meshgrid( x, y );

% Calculate
count = arrayfun( @processMandelbrotElement, xGrid, yGrid, maxIterations );

% Show
gpuArrayfunTime = toc( t );
%imagesc( x, y, count )
%axis image
%title( sprintf( '%1.2fsecs (GPU arrayfun) = %1.1fx faster', ...
%    gpuArrayfunTime, cpuTime/gpuArrayfunTime ) );

fprintf( '%1.2fsecs (with GPU smartly)\n', gpuArrayfunTime );

