hornerFcn = @horner;
data1  = rand( 5000, 'single' );
data2  = rand( 5000, 'double' );
gdata1 = gpuArray( data1 );
gdata2 = gpuArray( data2 );

gresult1 = arrayfun( hornerFcn, gdata1 );
gresult2 = arrayfun( hornerFcn, gdata2 );

tic; comparesingle = max( max( abs( gresult1 - horner( data1 ) ) ) );toc
tic; comparedouble = max( max( abs( gresult2 - horner( data2 ) ) ) );toc


% CPU execution
tic
hornerFcn( data1 );
tcpu = toc;

% GPU execution using only gpuArray objects
tgpuObject = gputimeit(@() hornerFcn(gdata1));

% GPU execution using gpuArray objects with arrayfun
tgpuArrayfun = gputimeit(@() arrayfun(hornerFcn, gdata1));


fprintf('Time with CPU: %g\n',tcpu);
fprintf('Time with naive GPU: %g\n',tgpuObject);
fprintf('Time with arrayfun GPU: %g\n',tgpuArrayfun);
