(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    738887,      29655]*)
(*NotebookOutlinePosition[    739791,      29683]*)
(*  CellTagsIndexPosition[    739747,      29679]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(<< Graphics`Graphics3D`\)], "Input"],

Cell["funktio f symbolisesti", "Text"],

Cell[BoxData[
    \(f0[u_] := \((1 - u^2)\) \((\[Alpha]0 - \[Beta]0*u)\) - \((b0 - 
              a0*u)\)^2\)], "Input"],

Cell["\<\
Kertoimet \[Alpha], \[Beta], a ja b haetaan asettamalla aluksi \
juuret polynomille s\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(flist = CoefficientList[f0[x], x];\)\), "\[IndentingNewLine]", 
    \(\(x1 = 1/5;\)\), "\[IndentingNewLine]", 
    \(\(x2 = 1/2;\)\), "\[IndentingNewLine]", 
    \(\(x3 = 2;\)\), "\[IndentingNewLine]", 
    \(s[x_] := \((x - x1)\) \((x - x2)\) \((x - x3)\)\), "\n", 
    \(\(slist = CoefficientList[s[x], x];\)\), "\[IndentingNewLine]", 
    \(\(solc = \(Solve[{flist \[Equal] slist}, {a0, 
              b0, \[Alpha]0, \[Beta]0}]\)[\([1]\)];\)\), \
"\[IndentingNewLine]", 
    \(\({\[Alpha], \[Beta], a, b} = {\[Alpha]0, \[Beta]0, a0, b0} /. 
          solc;\)\), "\[IndentingNewLine]", 
    \({\[Alpha], \[Beta], a, b} // N\), "\[IndentingNewLine]", 
    \(f[x_] := f0[x] /. solc\)}], "Input"],

Cell[BoxData[
    \({0.5151530771650467`, 1.`, 1.4781227698790633`, 
      0.8456672378453872`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b/a // N\)], "Input"],

Cell[BoxData[
    \(0.5721224617320372`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[f[x], {x, 0, 1}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.553235 1.3463 [
[.21429 .54073 -9 -9 ]
[.21429 .54073 9 0 ]
[.40476 .54073 -9 -9 ]
[.40476 .54073 9 0 ]
[.59524 .54073 -9 -9 ]
[.59524 .54073 9 0 ]
[.78571 .54073 -9 -9 ]
[.78571 .54073 9 0 ]
[.97619 .54073 -3 -9 ]
[.97619 .54073 3 0 ]
[.01131 .01472 -24 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .14934 -24 -4.5 ]
[.01131 .14934 0 4.5 ]
[.01131 .28397 -24 -4.5 ]
[.01131 .28397 0 4.5 ]
[.01131 .4186 -24 -4.5 ]
[.01131 .4186 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .55323 m
.21429 .55948 L
s
[(0.2)] .21429 .54073 0 1 Mshowa
.40476 .55323 m
.40476 .55948 L
s
[(0.4)] .40476 .54073 0 1 Mshowa
.59524 .55323 m
.59524 .55948 L
s
[(0.6)] .59524 .54073 0 1 Mshowa
.78571 .55323 m
.78571 .55948 L
s
[(0.8)] .78571 .54073 0 1 Mshowa
.97619 .55323 m
.97619 .55948 L
s
[(1)] .97619 .54073 0 1 Mshowa
.125 Mabswid
.07143 .55323 m
.07143 .55698 L
s
.11905 .55323 m
.11905 .55698 L
s
.16667 .55323 m
.16667 .55698 L
s
.2619 .55323 m
.2619 .55698 L
s
.30952 .55323 m
.30952 .55698 L
s
.35714 .55323 m
.35714 .55698 L
s
.45238 .55323 m
.45238 .55698 L
s
.5 .55323 m
.5 .55698 L
s
.54762 .55323 m
.54762 .55698 L
s
.64286 .55323 m
.64286 .55698 L
s
.69048 .55323 m
.69048 .55698 L
s
.7381 .55323 m
.7381 .55698 L
s
.83333 .55323 m
.83333 .55698 L
s
.88095 .55323 m
.88095 .55698 L
s
.92857 .55323 m
.92857 .55698 L
s
.25 Mabswid
0 .55323 m
1 .55323 L
s
.02381 .01472 m
.03006 .01472 L
s
[(-0.4)] .01131 .01472 1 0 Mshowa
.02381 .14934 m
.03006 .14934 L
s
[(-0.3)] .01131 .14934 1 0 Mshowa
.02381 .28397 m
.03006 .28397 L
s
[(-0.2)] .01131 .28397 1 0 Mshowa
.02381 .4186 m
.03006 .4186 L
s
[(-0.1)] .01131 .4186 1 0 Mshowa
.125 Mabswid
.02381 .04164 m
.02756 .04164 L
s
.02381 .06857 m
.02756 .06857 L
s
.02381 .09549 m
.02756 .09549 L
s
.02381 .12242 m
.02756 .12242 L
s
.02381 .17627 m
.02756 .17627 L
s
.02381 .2032 m
.02756 .2032 L
s
.02381 .23012 m
.02756 .23012 L
s
.02381 .25705 m
.02756 .25705 L
s
.02381 .3109 m
.02756 .3109 L
s
.02381 .33783 m
.02756 .33783 L
s
.02381 .36475 m
.02756 .36475 L
s
.02381 .39168 m
.02756 .39168 L
s
.02381 .44553 m
.02756 .44553 L
s
.02381 .47246 m
.02756 .47246 L
s
.02381 .49938 m
.02756 .49938 L
s
.02381 .52631 m
.02756 .52631 L
s
.02381 .58016 m
.02756 .58016 L
s
.02381 .60709 m
.02756 .60709 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .28398 m
.06244 .36001 L
.10458 .42992 L
.14415 .48383 L
.18221 .52549 L
.22272 .55945 L
.24141 .57168 L
.26171 .58259 L
.28302 .59148 L
.2926 .59465 L
.30316 .59755 L
.3134 .59979 L
.32299 .60138 L
.32828 .60206 L
.33312 .60255 L
.33579 .60276 L
.33871 .60296 L
.34146 .60311 L
.34402 .60321 L
.34531 .60325 L
.34667 .60328 L
.34783 .6033 L
.3491 .60331 L
.34981 .60332 L
.35047 .60332 L
.35122 .60332 L
.35194 .60332 L
.35321 .6033 L
.35393 .60329 L
.35459 .60328 L
.35688 .60322 L
.35819 .60318 L
.35942 .60313 L
.36191 .60301 L
.36454 .60285 L
.36922 .60248 L
.3735 .60205 L
.38315 .60076 L
.3927 .59906 L
.40289 .59678 L
.42126 .59152 L
.44261 .58358 L
.46276 .57437 L
.50122 .55245 L
.54214 .52338 L
.58155 .49036 L
.61943 .45451 L
.65977 .41249 L
.6986 .36886 L
.73987 .31967 L
Mistroke
.77963 .27015 L
.81788 .2211 L
.85858 .16797 L
.89776 .11649 L
.93939 .06206 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0
oooo0`3oool000P0oooo0P0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo00070?ooo`040000003oool0oooo000000X0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo00070?ooo`040000003o
ool0oooo000000L0oooo1@0000040?ooo`800000n`3oool00`000000oooo0?ooo`050?ooo`0000<0
oooo0000000000000P0000020?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`3i0?ooo`030000003oool0oooo00H0oooo00070?ooo`040000
003oool0oooo000000P0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`3h0?ooo`03
0000003oool0oooo00L0oooo00070?ooo`040000003oool0oooo000000T0oooo0P0000050?ooo`03
0000003oool0oooo0?P0oooo00<000000?ooo`3oool01`3oool000P0oooo0P00000;0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0m`3oool00`000000oooo0?ooo`080?ooo`006`3o
ool00`000000oooo0?ooo`3f0?ooo`030000003oool0oooo00T0oooo000K0?ooo`030000003oool0
oooo0?D0oooo00<000000?ooo`3oool02P3oool001/0oooo0P00003f0?ooo`030000003oool0oooo
00X0oooo000K0?ooo`030000003oool0oooo0?@0oooo00<000000?ooo`3oool02`3oool001/0oooo
00<000000?ooo`3oool0l`3oool00`000000oooo0?ooo`0<0?ooo`006`3oool00`000000oooo0?oo
o`3b0?ooo`030000003oool0oooo00d0oooo000K0?ooo`030000003oool0oooo0?80oooo00<00000
0?ooo`3oool03@3oool001/0oooo00<000000?ooo`3oool0l@3oool00`000000oooo0?ooo`0>0?oo
o`006`3oool00`000000oooo0?ooo`3`0?ooo`030000003oool0oooo00l0oooo000K0?ooo`800000
l03oool00`000000oooo0?ooo`0@0?ooo`006`3oool00`000000oooo0?ooo`3^0?ooo`030000003o
ool0oooo0140oooo000K0?ooo`030000003oool0oooo0>h0oooo00<000000?ooo`3oool04@3oool0
01/0oooo00<000000?ooo`3oool0k@3oool00`000000oooo0?ooo`0B0?ooo`006`3oool00`000000
oooo0?ooo`3/0?ooo`030000003oool0oooo01<0oooo000K0?ooo`030000003oool0oooo0>/0oooo
00<000000?ooo`3oool0503oool001/0oooo00<000000?ooo`3oool0j`3oool00`000000oooo0?oo
o`0D0?ooo`006`3oool00`000000oooo0?ooo`3Z0?ooo`030000003oool0oooo01D0oooo000K0?oo
o`800000jP3oool00`000000oooo0?ooo`0F0?ooo`006`3oool00`000000oooo0?ooo`3X0?ooo`03
0000003oool0oooo01L0oooo000K0?ooo`030000003oool0oooo0>L0oooo00<000000?ooo`3oool0
603oool001/0oooo00<000000?ooo`3oool0i`3oool00`000000oooo0?ooo`0H0?ooo`006`3oool0
0`000000oooo0?ooo`3V0?ooo`030000003oool0oooo01T0oooo000K0?ooo`030000003oool0oooo
0>D0oooo00<000000?ooo`3oool06P3oool001/0oooo00<000000?ooo`3oool0i03oool00`000000
oooo0?ooo`0K0?ooo`006`3oool200000>D0oooo00<000000?ooo`3oool06`3oool001/0oooo00<0
00000?ooo`3oool0h`3oool00`000000oooo0?ooo`0L0?ooo`006`3oool00`000000oooo0?ooo`3R
0?ooo`030000003oool0oooo01d0oooo000K0?ooo`030000003oool0oooo0>40oooo00<000000?oo
o`3oool07P3oool001/0oooo00<000000?ooo`3oool0h@3oool00`000000oooo0?ooo`0N0?ooo`00
203oool2000000@0oooo00<000000?ooo`3oool00`3oool2000000D0oooo00<000000?ooo`3oool0
h03oool00`000000oooo0?ooo`0O0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0g`3oool00`000000oooo0?ooo`0P0?ooo`00
1`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo0P00003P0?ooo`03
0000003oool0oooo0200oooo00000`3oool000000000000200000080oooo00@000000?ooo`3oool0
00002@3oool2000000D0oooo00<000000?ooo`3oool0gP3oool00`000000oooo0?ooo`0Q0?ooo`00
1`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3o
ool0g@3oool00`000000oooo0?ooo`0R0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0g03oool00`000000oooo0?ooo`0S0?oo
o`00203oool2000000X0oooo0P0000050?ooo`030000003oool0oooo0=`0oooo00<000000?ooo`3o
ool08`3oool001/0oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`0T0?ooo`006`3o
ool00`000000oooo0?ooo`3J0?ooo`030000003oool0oooo02D0oooo000K0?ooo`800000fP3oool0
0`000000oooo0?ooo`0V0?ooo`006`3oool00`000000oooo0?ooo`3I0?ooo`030000003oool0oooo
02H0oooo000K0?ooo`030000003oool0oooo0=P0oooo00<000000?ooo`3oool09`3oool001/0oooo
00<000000?ooo`3oool0e`3oool00`000000oooo0?ooo`0X0?ooo`006`3oool00`000000oooo0?oo
o`3F0?ooo`030000003oool0oooo02T0oooo000K0?ooo`030000003oool0oooo0=H0oooo00<00000
0?ooo`3oool0:@3oool001/0oooo00<000000?ooo`3oool0e@3oool00`000000oooo0?ooo`0Z0?oo
o`006`3oool200000=D0oooo00<000000?ooo`3oool0:`3oool001/0oooo00<000000?ooo`3oool0
d`3oool00`000000oooo0?ooo`0/0?ooo`006`3oool00`000000oooo0?ooo`3B0?ooo`030000003o
ool0oooo02d0oooo000K0?ooo`030000003oool0oooo0=80oooo00<000000?ooo`3oool0;@3oool0
01/0oooo00<000000?ooo`3oool0d@3oool00`000000oooo0?ooo`0^0?ooo`006`3oool00`000000
oooo0?ooo`3@0?ooo`030000003oool0oooo02l0oooo000K0?ooo`030000003oool0oooo0<l0oooo
00<000000?ooo`3oool0<03oool001/0oooo0P00003?0?ooo`030000003oool0oooo0340oooo000K
0?ooo`030000003oool0oooo0<h0oooo00<000000?ooo`3oool0<@3oool001/0oooo00<000000?oo
o`3oool0c@3oool00`000000oooo0?ooo`0b0?ooo`006`3oool00`000000oooo0?ooo`3<0?ooo`03
0000003oool0oooo03<0oooo000K0?ooo`030000003oool0oooo0</0oooo00<000000?ooo`3oool0
=03oool001/0oooo00<000000?ooo`3oool0b`3oool00`000000oooo0?ooo`0d0?ooo`006`3oool0
0`000000oooo0?ooo`3:0?ooo`030000003oool0oooo03D0oooo000K0?ooo`800000bP3oool00`00
0000oooo0?ooo`0f0?ooo`006`3oool00`000000oooo0?ooo`380?ooo`030000003oool0oooo03L0
oooo000K0?ooo`030000003oool0oooo0<P0oooo00<000000?ooo`3oool0=`3oool001/0oooo00<0
00000?ooo`3oool0a`3oool00`000000oooo0?ooo`0h0?ooo`006`3oool00`000000oooo0?ooo`36
0?ooo`030000003oool0oooo03T0oooo000K0?ooo`030000003oool0oooo0<D0oooo00<000000?oo
o`3oool0>P3oool000P0oooo0P0000040?ooo`030000003oool0oooo0080oooo100000040?ooo`03
0000003oool0oooo0<@0oooo00<000000?ooo`3oool0>`3oool000L0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0<<0oooo00<000000?ooo`3o
ool0?03oool000L0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`80
0000a03oool00`000000oooo0?ooo`0l0?ooo`0000<0oooo0000000000000P0000020?ooo`040000
003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`320?ooo`03
0000003oool0oooo03d0oooo00070?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3o
ool00P3oool200000<80oooo00<000000?ooo`3oool0?P3oool000L0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`0000040?ooo`800000`@3oool00`000000oooo0?ooo`0o0?oo
o`00203oool2000000X0oooo0P0000050?ooo`030000003oool000000;l0oooo00<000000?ooo`3o
ool0@03oool001/0oooo00<000000?ooo`000000_P3oool00`000000oooo0?ooo`110?ooo`006`3o
ool010000000oooo0?ooo`00002m0?ooo`030000003oool0oooo0440oooo000K0?ooo`80000000<0
oooo0000003oool0^`3oool00`000000oooo0?ooo`120?ooo`006`3oool01@000000oooo0?ooo`3o
ool000000;X0oooo00<000000?ooo`3oool0@`3oool001/0oooo00D000000?ooo`3oool0oooo0000
002i0?ooo`030000003oool0oooo04@0oooo000K0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0]@3oool00`000000oooo0?ooo`150?ooo`006`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0;@0oooo00<000000?ooo`3oool0AP3oool001/0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`2b0?ooo`030000003oool0oooo04L0oooo000K0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`170?ooo`006`3o
ool2000000D0oooo00<000000?ooo`3oool0/03oool00`000000oooo0?ooo`180?ooo`006`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0B@3oool0
01/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`2]0?ooo`030000003oool0oooo
04X0oooo000K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0[03oool00`000000
oooo0?ooo`1;0?ooo`006`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0:X0oooo
00<000000?ooo`3oool0C03oool001/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`2Z0?ooo`030000003oool0oooo04`0oooo000K0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0Z03oool00`000000oooo0?ooo`1=0?ooo`006`3oool2000000T0oooo00<000000?oo
o`3oool0YP3oool00`000000oooo0?ooo`1>0?ooo`006`3oool00`000000oooo0?ooo`080?ooo`03
0000003oool0oooo0:D0oooo00<000000?ooo`3oool0C`3oool001/0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`2S0?ooo`030000003oool0oooo0500oooo000K0?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0XP3oool00`000000oooo0?ooo`1A0?ooo`006`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3oool0D@3oool0
01/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo
0580oooo000K0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0WP3oool00`000000
oooo0?ooo`1C0?ooo`006`3oool2000000d0oooo00<000000?ooo`3oool0W03oool00`000000oooo
0?ooo`1D0?ooo`006`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo09/0oooo00<0
00000?ooo`3oool0E@3oool001/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`2I
0?ooo`030000003oool0oooo05H0oooo000K0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0V03oool00`000000oooo0?ooo`1F0?ooo`006`3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo09L0oooo00<000000?ooo`3oool0E`3oool000P0oooo0P0000040?ooo`030000
003oool0oooo0080oooo100000040?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
U@3oool00`000000oooo0?ooo`1H0?ooo`001`3oool010000000oooo0?ooo`00000:0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`2C0?ooo`030000
003oool0oooo05T0oooo00070?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0
0`3oool200000140oooo00<000000?ooo`3oool0TP3oool00`000000oooo0?ooo`1J0?ooo`0000<0
oooo0000000000000P0000020?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3oool0
F`3oool000L0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`1L0?ooo`001`3o
ool010000000oooo0?ooo`0000080?ooo`<000001@3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo08d0oooo00<000000?ooo`3oool0G@3oool000P0oooo0P00000;0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`2;0?ooo`030000003o
ool0oooo05h0oooo000K0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0RP3oool0
0`000000oooo0?ooo`1O0?ooo`006`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
08P0oooo00<000000?ooo`3oool0H03oool001/0oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`260?ooo`030000003oool0oooo0640oooo000K0?ooo`8000005`3oool00`000000oooo
0?ooo`240?ooo`030000003oool0oooo0680oooo000K0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0P`3oool00`000000oooo0?ooo`1S0?ooo`006`3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo0840oooo00<000000?ooo`3oool0I03oool001/0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`1o0?ooo`030000003oool0oooo06D0oooo000K0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`1V0?ooo`00
6`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo07`0oooo00<000000?ooo`3oool0
I`3oool001/0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1j0?ooo`030000003o
ool0oooo06P0oooo000K0?ooo`800000703oool00`000000oooo0?ooo`1h0?ooo`030000003oool0
oooo06T0oooo000K0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0MP3oool00`00
0000oooo0?ooo`1Z0?ooo`006`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo07D0
oooo00<000000?ooo`3oool0J`3oool001/0oooo00<000000?ooo`3oool07@3oool00`000000oooo
0?ooo`1c0?ooo`030000003oool0oooo06`0oooo000K0?ooo`030000003oool0oooo01h0oooo00<0
00000?ooo`3oool0L@3oool00`000000oooo0?ooo`1]0?ooo`006`3oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool0KP3oool001/0oooo00<000000?oo
o`3oool0803oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo06l0oooo000K0?ooo`80
00008P3oool00`000000oooo0?ooo`1Z0?ooo`800000LP3oool001/0oooo00<000000?ooo`3oool0
8P3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo0780oooo000K0?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`1c0?ooo`006`3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0M03oool0
01/0oooo00<000000?ooo`3oool0903oool010000000oooo0?ooo`3oool2000000@0oooo00<00000
0?ooo`3oool00P3oool4000002@0oooo0P0000040?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool07P3oool2000000<0oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P00000T
0?ooo`800000103oool00`000000oooo0?ooo`030?ooo`800000:P3oool4000000H0oooo000K0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`0000000P3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo02@0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000R0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000:`3oool00`00
0000oooo0?ooo`050?ooo`006`3oool00`000000oooo0?ooo`0V0?ooo`8000000P3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo02<0oooo00@000000?ooo`3oool000001`3oool50000
01d0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo00000280oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00000[0?ooo`03
0000003oool0oooo00D0oooo000K0?ooo`800000:03oool010000000oooo0?ooo`00000:0?ooo`03
0000003oool0oooo0280oooo00@000000?ooo`3oool000001`3oool010000000oooo0?ooo`00000L
0?ooo`8000001P3oool010000000oooo0?ooo`0000080?ooo`<000008`3oool010000000oooo0?oo
o`0000090?ooo`800000;03oool00`000000oooo0?ooo`050?ooo`006`3oool00`000000oooo0?oo
o`0W0?ooo`80000000<0oooo0000003oool02P3oool00`000000oooo0?ooo`0Q0?ooo`040000003o
ool0oooo000000P0oooo00<000000?ooo`0000006`3oool00`000000oooo0?ooo`060?ooo`040000
003oool0oooo000000P0oooo00<000000?ooo`3oool08`3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000002/0oooo00<000000?ooo`3oool01@3oool001/0oooo00<000000?oo
o`3oool09`3oool010000000oooo0000000000080?ooo`040000003oool0oooo000002<0oooo00@0
00000?ooo`3oool000002@3oool2000001X0oooo00<000000?ooo`3oool01`3oool010000000oooo
0?ooo`0000080?ooo`030000003oool0oooo02<0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`00000Y0?ooo`<000001`3oool001/0oooo00<000000?ooo`3oool0:03oool20000
00030?ooo`000000oooo00L0oooo0P00000U0?ooo`8000002`3oool00`000000oooo0?ooo`0F0?oo
o`8000002`3oool2000000X0oooo0`00000S0?ooo`8000002P3oool2000002`0oooo00<000000?oo
o`3oool01@3oool001/0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`1A0?ooo`03
0000003oool0oooo07l0oooo000K0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0
C`3oool00`000000oooo0?ooo`200?ooo`006`3oool00`000000oooo0?ooo`0^0?ooo`030000003o
ool0oooo04`0oooo0P0000230?ooo`00503ooooo000000d00000000K0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`0000002P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
00P0oooo0P00000<0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo000K0?ooo`030000003oool0oooo02l0
oooo00@000000?ooo`3oool00000;`3oool00`000000oooo0?ooo`0C0?ooo`8000006`3oool00`00
0000oooo0?ooo`0_0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool01@3oool001/0
oooo00<000000?ooo`3oool0<`3oool200000480oooo00<000000?ooo`3oool0R03oool001/0oooo
00<000000?ooo`3oool0=@3oool2000003h0oooo0P00002;0?ooo`006`3oool00`000000oooo0?oo
o`0g0?ooo`030000003oool0oooo03T0oooo0P00002=0?ooo`006`3oool00`000000oooo0?ooo`0h
0?ooo`800000=`3oool2000008l0oooo000K0?ooo`800000>`3oool200000380oooo0`00002A0?oo
o`006`3oool00`000000oooo0?ooo`0l0?ooo`800000;@3oool3000009@0oooo000K0?ooo`030000
003oool0oooo03h0oooo0`00000X0?ooo`800000U`3oool001/0oooo00<000000?ooo`3oool0@@3o
ool2000002<0oooo0`00002I0?ooo`006`3oool00`000000oooo0?ooo`130?ooo`<000007P3oool2
000009`0oooo000K0?ooo`030000003oool0oooo04H0oooo0`00000E0?ooo`H00000WP3oool001/0
oooo00<000000?ooo`3oool0B@3oool8000000H0oooo1`00002T0?ooo`006`3oool00`000000oooo
0?ooo`1A0?ooo`L00000ZP3oool001/0oooo0P00003o0?ooo`@0oooo000K0?ooo`030000003oool0
oooo0?l0oooo0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000
oooo0?ooo`3o0?ooo`<0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107864, -0.429251, \
0.00394728, 0.00279233}}]
}, Open  ]],

Cell["u:lle rajat ", "Text"],

Cell[BoxData[
    \(\({u1, u2} = SetAccuracy[{x1, x2}, 80];\)\)], "Input"],

Cell["\<\
T\[ADoubleDot]m\[ADoubleDot] kakee integraalin arvon, kun \
integrandi on singulaarinen\
\>", "Text"],

Cell[BoxData[
    \(\(NIntegroi[Intf_, rajat_, acc_] := 
        Module[{}, \[IndentingNewLine]tarkkuus = 
            1; \[IndentingNewLine]\[Epsilon] = 
            10^\(-4\); \[IndentingNewLine]{x1, x2} = 
            rajat; \[IndentingNewLine]int0 = \((\((Intf /. 
                      x -> x2 - \[Epsilon])\) - \((Intf /. 
                      x -> x1 + \[Epsilon])\))\) // 
              Re; \[IndentingNewLine]While[
            tarkkuus > acc, \[IndentingNewLine]\[Epsilon] *= 
              10^\(-2\); \[IndentingNewLine]int1 = \((\((Intf /. 
                        x -> x2 - \[Epsilon])\) - \((Intf /. 
                        x -> x1 + \[Epsilon])\))\) // 
                Re; \[IndentingNewLine]tarkkuus = 
              10^Log[10, 
                  Abs[\((int1 - int0)\)/int0]]; \[IndentingNewLine]int0 = 
              int1;\[IndentingNewLine]]; \[IndentingNewLine]int1\
\[IndentingNewLine]];\)\)], "Input"],

Cell["Lasketaan yhden jakson pituus (kaava 5.63)", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(It = Integrate[1/Sqrt[f[x]], x];\)\), "\[IndentingNewLine]", 
    \(tmax = \(NIntegroi[It, {u1, u2}, 10^\(-16\)] // Re\) // N\)}], "Input"],

Cell[BoxData[
    \(2.44953365607055`\)], "Output"]
}, Open  ]],

Cell["M\[ADoubleDot]\[ADoubleDot]ritell\[ADoubleDot]\[ADoubleDot]n u:n \
derivaatta paloittain ", "Text"],

Cell[BoxData[{
    \(g[x_] := Sqrt[f[x]] /; Re[x] \[LessEqual] u2\), "\[IndentingNewLine]", 
    \(g[x_] := \(-Sqrt[f[2  u2 - x]]\) /; 
        Re[x] \[GreaterEqual] u2\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[g[x], {x, u1, 1.1*u2}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.520408 2.72109 0.26144 1.77253 [
[.15986 .24894 -12 -9 ]
[.15986 .24894 12 0 ]
[.29592 .24894 -9 -9 ]
[.29592 .24894 9 0 ]
[.43197 .24894 -12 -9 ]
[.43197 .24894 12 0 ]
[.56803 .24894 -9 -9 ]
[.56803 .24894 9 0 ]
[.70408 .24894 -12 -9 ]
[.70408 .24894 12 0 ]
[.84014 .24894 -9 -9 ]
[.84014 .24894 9 0 ]
[.97619 .24894 -12 -9 ]
[.97619 .24894 12 0 ]
[.01131 .08419 -24 -4.5 ]
[.01131 .08419 0 4.5 ]
[.01131 .17281 -30 -4.5 ]
[.01131 .17281 0 4.5 ]
[.01131 .35007 -24 -4.5 ]
[.01131 .35007 0 4.5 ]
[.01131 .43869 -18 -4.5 ]
[.01131 .43869 0 4.5 ]
[.01131 .52732 -24 -4.5 ]
[.01131 .52732 0 4.5 ]
[.01131 .61595 -18 -4.5 ]
[.01131 .61595 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15986 .26144 m
.15986 .26769 L
s
[(0.25)] .15986 .24894 0 1 Mshowa
.29592 .26144 m
.29592 .26769 L
s
[(0.3)] .29592 .24894 0 1 Mshowa
.43197 .26144 m
.43197 .26769 L
s
[(0.35)] .43197 .24894 0 1 Mshowa
.56803 .26144 m
.56803 .26769 L
s
[(0.4)] .56803 .24894 0 1 Mshowa
.70408 .26144 m
.70408 .26769 L
s
[(0.45)] .70408 .24894 0 1 Mshowa
.84014 .26144 m
.84014 .26769 L
s
[(0.5)] .84014 .24894 0 1 Mshowa
.97619 .26144 m
.97619 .26769 L
s
[(0.55)] .97619 .24894 0 1 Mshowa
.125 Mabswid
.05102 .26144 m
.05102 .26519 L
s
.07823 .26144 m
.07823 .26519 L
s
.10544 .26144 m
.10544 .26519 L
s
.13265 .26144 m
.13265 .26519 L
s
.18707 .26144 m
.18707 .26519 L
s
.21429 .26144 m
.21429 .26519 L
s
.2415 .26144 m
.2415 .26519 L
s
.26871 .26144 m
.26871 .26519 L
s
.32313 .26144 m
.32313 .26519 L
s
.35034 .26144 m
.35034 .26519 L
s
.37755 .26144 m
.37755 .26519 L
s
.40476 .26144 m
.40476 .26519 L
s
.45918 .26144 m
.45918 .26519 L
s
.48639 .26144 m
.48639 .26519 L
s
.51361 .26144 m
.51361 .26519 L
s
.54082 .26144 m
.54082 .26519 L
s
.59524 .26144 m
.59524 .26519 L
s
.62245 .26144 m
.62245 .26519 L
s
.64966 .26144 m
.64966 .26519 L
s
.67687 .26144 m
.67687 .26519 L
s
.73129 .26144 m
.73129 .26519 L
s
.7585 .26144 m
.7585 .26519 L
s
.78571 .26144 m
.78571 .26519 L
s
.81293 .26144 m
.81293 .26519 L
s
.86735 .26144 m
.86735 .26519 L
s
.89456 .26144 m
.89456 .26519 L
s
.92177 .26144 m
.92177 .26519 L
s
.94898 .26144 m
.94898 .26519 L
s
.25 Mabswid
0 .26144 m
1 .26144 L
s
.02381 .08419 m
.03006 .08419 L
s
[(-0.1)] .01131 .08419 1 0 Mshowa
.02381 .17281 m
.03006 .17281 L
s
[(-0.05)] .01131 .17281 1 0 Mshowa
.02381 .35007 m
.03006 .35007 L
s
[(0.05)] .01131 .35007 1 0 Mshowa
.02381 .43869 m
.03006 .43869 L
s
[(0.1)] .01131 .43869 1 0 Mshowa
.02381 .52732 m
.03006 .52732 L
s
[(0.15)] .01131 .52732 1 0 Mshowa
.02381 .61595 m
.03006 .61595 L
s
[(0.2)] .01131 .61595 1 0 Mshowa
.125 Mabswid
.02381 .10191 m
.02756 .10191 L
s
.02381 .11964 m
.02756 .11964 L
s
.02381 .13736 m
.02756 .13736 L
s
.02381 .15509 m
.02756 .15509 L
s
.02381 .19054 m
.02756 .19054 L
s
.02381 .20826 m
.02756 .20826 L
s
.02381 .22599 m
.02756 .22599 L
s
.02381 .24371 m
.02756 .24371 L
s
.02381 .27917 m
.02756 .27917 L
s
.02381 .29689 m
.02756 .29689 L
s
.02381 .31462 m
.02756 .31462 L
s
.02381 .33234 m
.02756 .33234 L
s
.02381 .36779 m
.02756 .36779 L
s
.02381 .38552 m
.02756 .38552 L
s
.02381 .40324 m
.02756 .40324 L
s
.02381 .42097 m
.02756 .42097 L
s
.02381 .45642 m
.02756 .45642 L
s
.02381 .47414 m
.02756 .47414 L
s
.02381 .49187 m
.02756 .49187 L
s
.02381 .50959 m
.02756 .50959 L
s
.02381 .54504 m
.02756 .54504 L
s
.02381 .56277 m
.02756 .56277 L
s
.02381 .58049 m
.02756 .58049 L
s
.02381 .59822 m
.02756 .59822 L
s
.02381 .06646 m
.02756 .06646 L
s
.02381 .04874 m
.02756 .04874 L
s
.02381 .03101 m
.02756 .03101 L
s
.02381 .01329 m
.02756 .01329 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .2616 m
.02499 .28849 L
.02605 .2988 L
.02846 .31509 L
.03279 .33577 L
.03784 .35403 L
.04262 .36827 L
.06244 .41233 L
.08265 .44483 L
.10458 .4727 L
.14545 .51231 L
.1848 .5406 L
.22263 .56138 L
.26292 .5781 L
.30169 .58977 L
.32283 .59451 L
.34292 .59803 L
.3525 .59938 L
.36272 .6006 L
.3723 .60154 L
.38111 .60222 L
.39139 .60281 L
.3968 .60303 L
.39956 .60312 L
.40252 .60319 L
.40512 .60325 L
.40749 .60328 L
.40864 .60329 L
.40988 .60331 L
.41105 .60331 L
.41214 .60332 L
.41339 .60332 L
.41457 .60332 L
.41586 .60331 L
.41659 .60331 L
.41725 .6033 L
.41852 .60329 L
.4199 .60328 L
.42269 .60323 L
.42523 .60318 L
.42798 .6031 L
.43297 .60293 L
.4423 .60247 L
.4532 .6017 L
.46325 .60078 L
.48202 .5985 L
.50266 .59515 L
.543 .586 L
.58182 .57377 L
.6231 .55672 L
Mistroke
.66286 .53574 L
.7011 .51039 L
.7418 .47597 L
.78098 .4315 L
.80243 .39876 L
.81225 .38013 L
.82262 .35602 L
.82725 .34274 L
.83221 .32535 L
.83506 .31266 L
.83641 .30535 L
.83766 .29728 L
.83891 .28669 L
.83957 .27864 L
.84027 .25323 L
.84144 .23543 L
.84273 .22475 L
.84513 .21062 L
.84733 .20053 L
.85227 .1825 L
.86122 .15787 L
.88018 .12009 L
.90089 .08924 L
.94151 .04401 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`008@3oool00`000000oooo0?ooo`3l0?ooo`008@3o
ool00`000000oooo0?ooo`3l0?ooo`008@3oool00`000000oooo0?ooo`3l0?ooo`008@3oool20000
0?00oooo00<000000?ooo`3oool02P3oool00240oooo00<000000?ooo`3oool0kP3oool00`000000
oooo0?ooo`0;0?ooo`008@3oool00`000000oooo0?ooo`3]0?ooo`030000003oool0oooo00`0oooo
000Q0?ooo`030000003oool0oooo0>`0oooo00<000000?ooo`3oool03@3oool00240oooo0P00003[
0?ooo`800000403oool00240oooo00<000000?ooo`3oool0j@3oool00`000000oooo0?ooo`0@0?oo
o`008@3oool00`000000oooo0?ooo`3X0?ooo`030000003oool0oooo0140oooo000Q0?ooo`030000
003oool0oooo0>L0oooo00<000000?ooo`3oool04P3oool00240oooo00<000000?ooo`3oool0iP3o
ool00`000000oooo0?ooo`0C0?ooo`008@3oool200000>H0oooo00<000000?ooo`3oool0503oool0
0240oooo00<000000?ooo`3oool0i03oool00`000000oooo0?ooo`0E0?ooo`008@3oool00`000000
oooo0?ooo`3S0?ooo`030000003oool0oooo01H0oooo000Q0?ooo`030000003oool0oooo0>80oooo
00<000000?ooo`3oool05`3oool00240oooo0P00003R0?ooo`030000003oool0oooo01P0oooo000Q
0?ooo`030000003oool0oooo0>00oooo00<000000?ooo`3oool06@3oool00240oooo00<000000?oo
o`3oool0g`3oool00`000000oooo0?ooo`0J0?ooo`003P3oool2000000@0oooo00<000000?ooo`3o
ool00P3oool4000000@0oooo00<000000?ooo`3oool0gP3oool00`000000oooo0?ooo`0K0?ooo`00
3@3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0g@3oool00`000000oooo0?ooo`0L0?ooo`003@3oool010000000oooo0?ooo`00000:0?ooo`03
0000003oool0oooo00<0oooo0P00003M0?ooo`030000003oool0oooo01d0oooo00070?ooo`@00000
0P3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0f`3oool00`000000oooo0?ooo`0N0?ooo`003@3oool010000000oooo0?ooo`00000:0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0fP3oool00`000000oooo0?ooo`0O0?ooo`00
3@3oool010000000oooo0?ooo`0000080?ooo`<000001@3oool00`000000oooo0?ooo`3J0?ooo`03
0000003oool0oooo01l0oooo000>0?ooo`8000002`3oool00`000000oooo0?ooo`030?ooo`800000
fP3oool00`000000oooo0?ooo`0P0?ooo`008@3oool00`000000oooo0?ooo`3I0?ooo`030000003o
ool0oooo0200oooo000Q0?ooo`030000003oool0oooo0=P0oooo00<000000?ooo`3oool08@3oool0
0240oooo00<000000?ooo`3oool0e`3oool00`000000oooo0?ooo`0R0?ooo`008@3oool00`000000
oooo0?ooo`3G0?ooo`030000003oool0oooo0280oooo000Q0?ooo`800000e`3oool00`000000oooo
0?ooo`0S0?ooo`008@3oool00`000000oooo0?ooo`3F0?ooo`030000003oool0oooo02<0oooo000Q
0?ooo`030000003oool0oooo0=D0oooo00<000000?ooo`3oool0903oool00240oooo00<000000?oo
o`3oool0e@3oool00`000000oooo0?ooo`0T0?ooo`008@3oool200000=D0oooo00<000000?ooo`3o
ool09@3oool00240oooo00<000000?ooo`3oool0e03oool00`000000oooo0?ooo`0U0?ooo`008@3o
ool00`000000oooo0?ooo`3C0?ooo`030000003oool0oooo02H0oooo000Q0?ooo`030000003oool0
oooo0=<0oooo00<000000?ooo`3oool09P3oool00240oooo00<000000?ooo`3oool0dP3oool00`00
0000oooo0?ooo`0W0?ooo`008@3oool200000=<0oooo00<000000?ooo`3oool09`3oool00240oooo
00<000000?ooo`3oool0d@3oool00`000000oooo0?ooo`0X0?ooo`00203oool2000000@0oooo00<0
00000?ooo`3oool00`3oool2000000<0oooo0`0000050?ooo`030000003oool0oooo0=40oooo00<0
00000?ooo`3oool0:03oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0d03oool00`000000oooo
0?ooo`0Y0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000D0
oooo00<000000?ooo`3oool00P3oool200000=40oooo00<000000?ooo`3oool0:@3oool000030?oo
o`0000000000008000000P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
0080oooo0`0000050?ooo`030000003oool0oooo0=00oooo00<000000?ooo`3oool0:@3oool000L0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0c`3oool00`000000oooo0?ooo`0Z0?ooo`001`3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`3?0?ooo`030000003oool0oooo02X0oooo00080?ooo`8000002P3oool2
000000<0oooo100000040?ooo`030000003oool0oooo0<l0oooo00<000000?ooo`3oool0:P3oool0
0240oooo0P00003@0?ooo`030000003oool0oooo02X0oooo000Q0?ooo`030000003oool0oooo0<h0
oooo00<000000?ooo`3oool0:`3oool00240oooo00<000000?ooo`3oool0cP3oool00`000000oooo
0?ooo`0[0?ooo`008@3oool00`000000oooo0?ooo`3>0?ooo`030000003oool0oooo02/0oooo000Q
0?ooo`800000cP3oool00`000000oooo0?ooo`0/0?ooo`008@3oool00`000000oooo0?ooo`3=0?oo
o`030000003oool0oooo02`0oooo000Q0?ooo`030000003oool0oooo0<d0oooo00<000000?ooo`3o
ool0;03oool00240oooo00<000000?ooo`3oool0c@3oool00`000000oooo0?ooo`0/0?ooo`008@3o
ool00`000000oooo0?ooo`0E0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@000000P3o
ool300000180oooo0P0000040?ooo`030000003oool0oooo00<0oooo0P00000A0?ooo`800000103o
ool00`000000oooo0?ooo`030?ooo`8000000`3oool300000180oooo0P0000040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool03`3oool2000000@0oooo00<000000?ooo`3oool0103o
ool010000000oooo0?ooo`3oool300000180oooo0P0000040?ooo`030000003oool000000080oooo
0`00000B0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000000`3oool3000000<0oooo
000Q0?ooo`8000005@3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool03P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
00l0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000050?ooo`030000003o
ool0oooo00h0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`0>0?ooo`040000
003oool0oooo000000X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0>0?ooo`04
0000003oool0oooo000000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0>0?oo
o`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00`3oool100000040oooo0@3oool0
0240oooo00<000000?ooo`3oool0503oool010000000oooo0?ooo`0000090?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool03P3oool010000000oooo0?ooo`00000;0?ooo`030000003o
ool0oooo00d0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00h0oooo00@000000?ooo`3oool000001`3oool5000000l0oooo00@000000?ooo`3o
ool000001`3oool5000000D0oooo00<000000?ooo`3oool03P3oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03P3oool010000000oooo0?ooo`00
000;0?ooo`030000003oool0oooo00<0oooo0@0000010?ooo`40oooo000Q0?ooo`030000003oool0
oooo01@0oooo00@000000?ooo`3oool000002P3oool010000000oooo0?ooo`3oool300000140oooo
00@000000?ooo`3oool000002@3oool200000100oooo00@000000?ooo`3oool000002@3oool20000
00<0oooo0`00000A0?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3oool00000403o
ool010000000oooo0?ooo`0000070?ooo`040000003oool0oooo000000<0oooo0`00000A0?ooo`04
0000003oool0oooo000000@0oooo00@000000?ooo`3oool0oooo0`00000A0?ooo`040000003oool0
oooo000000P0oooo0`0000030?ooo`<000000`3oool00240oooo00<000000?ooo`3oool0503oool0
10000000oooo0?ooo`00000;0?ooo`040000003oool0oooo000001<0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`0=0?ooo`040000003oool0oooo000000/0oooo00@000000?oo
o`3oool000004`3oool010000000oooo0?ooo`0000080?ooo`030000003oool000000100oooo00@0
00000?ooo`3oool00000203oool00`000000oooo000000030?ooo`030000003oool0oooo0140oooo
00@000000?ooo`3oool00000103oool01@000000oooo0?ooo`3oool0000001<0oooo00@000000?oo
o`3oool00000203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo000Q0?oo
o`8000005@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool04@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000l0
oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo0140oooo00@000000?ooo`3oool000002@3oool200000100oooo00@000000?ooo`3oool00000
2@3oool2000000<0oooo00<000000?ooo`3oool04@3oool010000000oooo0?ooo`0000040?ooo`05
0000003oool0oooo0?ooo`0000004`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool00240oooo00<000000?ooo`3oool05@3oool20000
00X0oooo0P0000030?ooo`@000004@3oool2000000X0oooo0P00000A0?ooo`8000002P3oool20000
00<0oooo1000000A0?ooo`8000002`3oool00`000000oooo0?ooo`0?0?ooo`8000002`3oool01000
0000oooo0?ooo`3oool400000140oooo0P0000050?ooo`040000003oool0oooo0?ooo`@000004@3o
ool2000000T0oooo100000020?ooo`@000000P3oool00240oooo00<000000?ooo`3oool0c03oool0
0`000000oooo0?ooo`0]0?ooo`008@3oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo
02d0oooo000Q0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0;@3oool001/0oooo
o`0000060?ooo`008@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool02P3oool00240oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0O
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0:
0?ooo`008@3oool00`000000oooo0?ooo`3<0?ooo`030000003oool0oooo02d0oooo000Q0?ooo`80
0000c@3oool00`000000oooo0?ooo`0]0?ooo`008@3oool00`000000oooo0?ooo`3<0?ooo`030000
003oool0oooo02d0oooo000Q0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3oool0;@3o
ool00240oooo00<000000?ooo`3oool0c03oool00`000000oooo0?ooo`0]0?ooo`008@3oool00`00
0000oooo0?ooo`3;0?ooo`030000003oool0oooo02h0oooo000Q0?ooo`800000c03oool00`000000
oooo0?ooo`0^0?ooo`008@3oool00`000000oooo0?ooo`3;0?ooo`030000003oool0oooo02h0oooo
000Q0?ooo`030000003oool0oooo0</0oooo00<000000?ooo`3oool0;P3oool00240oooo0P00003<
0?ooo`030000003oool0oooo02h0oooo000Q0?ooo`800000c03oool00`000000oooo0?ooo`0^0?oo
o`008@3oool200000<`0oooo00<000000?ooo`3oool0;P3oool00240oooo0P00003;0?ooo`030000
003oool0oooo02l0oooo000Q0?ooo`800000b`3oool00`000000oooo0?ooo`0_0?ooo`008@3oool0
0`000000oooo0000003:0?ooo`030000003oool0oooo02l0oooo000Q0?ooo`<00000bP3oool00`00
0000oooo0?ooo`0_0?ooo`008@3oool00`000000oooo000000390?ooo`030000003oool0oooo0300
oooo00080?ooo`800000103oool00`000000oooo0?ooo`030?ooo`8000000`3oool3000000D0oooo
00<000000?ooo`000000b@3oool00`000000oooo0?ooo`0`0?ooo`001`3oool010000000oooo0?oo
o`0000080?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool00P3oool00`000000
oooo000000390?ooo`030000003oool0oooo0300oooo00070?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`80000000<0oooo0000
003oool0a`3oool00`000000oooo0?ooo`0`0?ooo`001`3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000080oooo0`0000050?ooo`040000003oool0oooo00000<L0oooo00<0
00000?ooo`3oool0<@3oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo00D0oooo00@000000?ooo`3oool00000a`3oool00`000000
oooo0?ooo`0a0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool01@3oool010000000oooo0?ooo`0000370?ooo`030000003oool0
oooo0340oooo00080?ooo`8000002P3oool2000000<0oooo100000040?ooo`050000003oool0oooo
0?ooo`000000a@3oool00`000000oooo0?ooo`0b0?ooo`008@3oool200000080oooo00<000000?oo
o`3oool0``3oool00`000000oooo0?ooo`0b0?ooo`008@3oool01@000000oooo0?ooo`3oool00000
0<@0oooo00<000000?ooo`3oool0<`3oool00240oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`310?ooo`030000003oool0oooo03<0oooo000Q0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0`03oool00`000000oooo0?ooo`0d0?ooo`008@3oool2000000@0oooo00<0
00000?ooo`3oool0_P3oool00`000000oooo0?ooo`0e0?ooo`008@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0;h0oooo00<000000?ooo`3oool0=@3oool00240oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo03H0oooo000Q0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0_03oool00`000000oooo0?ooo`0f0?ooo`00
8@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0;X0oooo00<000000?ooo`3oool0
=`3oool00240oooo0P0000060?ooo`030000003oool0oooo0;T0oooo00<000000?ooo`3oool0>03o
ool00240oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0
oooo03P0oooo000Q0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0]`3oool00`00
0000oooo0?ooo`0i0?ooo`008@3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0;H0
oooo00<000000?ooo`3oool0>@3oool00240oooo0P0000080?ooo`030000003oool0oooo0;D0oooo
00<000000?ooo`3oool0>P3oool00240oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`2c0?ooo`030000003oool0oooo03/0oooo000Q0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0/P3oool00`000000oooo0?ooo`0k0?ooo`003P3oool2000000@0oooo00<000000?oo
o`3oool00P3oool4000000@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`2a0?oo
o`030000003oool0oooo03`0oooo000=0?ooo`040000003oool0oooo000000X0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0:l0oooo00<000000?oo
o`3oool0?@3oool000d0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`030?oo
o`800000303oool00`000000oooo0?ooo`2]0?ooo`030000003oool0oooo03h0oooo000=0?ooo`04
0000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo0:`0oooo00<000000?ooo`3oool0?`3oool000d0oooo00@000000?ooo`3o
ool000002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0ZP3oool00`000000oooo0?ooo`100?ooo`003@3oool010000000oooo0?ooo`0000080?oo
o`<000001@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0:P0oooo00<000000?oo
o`3oool0@@3oool000h0oooo0P00000;0?ooo`030000003oool0oooo00<0oooo0P00000>0?ooo`03
0000003oool0oooo0:P0oooo00<000000?ooo`3oool0@@3oool00240oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo0480oooo000Q0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`130?ooo`008@3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0:80oooo00<000000?ooo`3oool0A03oool0
0240oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo
04D0oooo000Q0?ooo`8000004P3oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo04H0
oooo000Q0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0W@3oool00`000000oooo
0?ooo`170?ooo`008@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo09/0oooo00<0
00000?ooo`3oool0B03oool00240oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`2I
0?ooo`030000003oool0oooo04T0oooo000Q0?ooo`8000005P3oool00`000000oooo0?ooo`2F0?oo
o`800000C03oool00240oooo00<000000?ooo`3oool05P3oool2000009D0oooo00<000000?ooo`3o
ool0C03oool00240oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`2A0?ooo`030000
003oool0oooo04d0oooo000Q0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0S`3o
ool00`000000oooo0?ooo`1>0?ooo`008@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo08d0oooo00<000000?ooo`3oool0C`3oool00240oooo0P00000L0?ooo`030000003oool0oooo
08/0oooo00<000000?ooo`3oool0D03oool00240oooo00<000000?ooo`3oool0703oool00`000000
oooo0?ooo`280?ooo`800000D`3oool000P0oooo0P0000040?ooo`030000003oool0oooo0080oooo
100000020?ooo`<000001@3oool00`000000oooo0?ooo`0M0?ooo`800000Q`3oool00`000000oooo
0?ooo`1C0?ooo`001`3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0880oooo
0P00001F0?ooo`001`3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00P3oool200000240oooo00<000000?ooo`3oool0P03oool00`000000oooo
0?ooo`1F0?ooo`001`3oool010000000oooo0?ooo`00000:0?ooo`040000003oool0oooo0?ooo`<0
00001@3oool00`000000oooo0?ooo`0Q0?ooo`800000O`3oool00`000000oooo0?ooo`1G0?ooo`00
1`3oool010000000oooo0?ooo`00000:0?ooo`050000003oool0oooo0?ooo`0000001`3oool00`00
0000oooo0?ooo`0S0?ooo`030000003oool0oooo07X0oooo0P00001J0?ooo`001`3oool010000000
oooo0?ooo`0000080?ooo`<000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
02@0oooo0P00001h0?ooo`800000G03oool000P0oooo0P00000;0?ooo`040000003oool0oooo0?oo
o`@00000103oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo07<0oooo0P00001N0?oo
o`008@3oool2000002P0oooo0P00001a0?ooo`800000H03oool00240oooo00<000000?ooo`3oool0
:@3oool2000006d0oooo0P00001R0?ooo`008@3oool00`000000oooo0?ooo`0[0?ooo`800000J@3o
ool2000006@0oooo000Q0?ooo`030000003oool0oooo02d0oooo0P00001U0?ooo`800000IP3oool0
0240oooo0P00000`0?ooo`800000H03oool3000006P0oooo000Q0?ooo`030000003oool0oooo0340
oooo0P00001L0?ooo`800000J`3oool00240oooo00<000000?ooo`3oool0<`3oool3000005H0oooo
0`00001]0?ooo`008@3oool00`000000oooo0?ooo`0f0?ooo`800000D@3oool300000700oooo000Q
0?ooo`030000003oool0oooo03P0oooo0`00001;0?ooo`<00000L`3oool00240oooo0P00000l0?oo
o`<00000A@3oool3000007H0oooo000Q0?ooo`030000003oool0oooo03h0oooo1000000n0?ooo`<0
0000N@3oool00240oooo00<000000?ooo`3oool0@P3oool3000003L0oooo1000001l0?ooo`008@3o
ool00`000000oooo0?ooo`150?ooo`<00000<03oool400000800oooo000Q0?ooo`800000B@3oool7
000002D0oooo100000240?ooo`008@3oool00`000000oooo0?ooo`1?0?ooo`X00000403oool;0000
08P0oooo000Q0?ooo`030000003oool0oooo05T0oooo4000002C0?ooo`003P3oool2000000@0oooo
00<000000?ooo`3oool00P3oool4000000@0oooo00<000000?ooo`3oool0o03oool000d0oooo00@0
00000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0?`0oooo
000=0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool0103oool200000?d0oooo
000=0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`3l0?ooo`003@3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0?l0oooo
0P3oool000d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`00003o0?ooo`@0
oooo000>0?ooo`8000002P3oool200000?l0oooo1@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {0.151984, -0.165313, \
0.00144733, 0.00222187}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\[Theta]:n derivaatta", "Text"],

Cell[BoxData[
    \(\(g2[u_] := \((b - a*u)\)/\((1 - u^2)\);\)\)], "Input"],

Cell["Ratkaistaan teht\[ADoubleDot]v\[ADoubleDot]\[ADoubleDot] jakso \
kerrallaan", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ti = Range[0, tmax, tmax/100];\)\), "\[IndentingNewLine]", 
    \(\(kerroin = \(-1\);\)\), "\[IndentingNewLine]", 
    \(\(jaksoja = 16;\)\), "\[IndentingNewLine]", 
    \(\(kuvat = Table[0, {jaksoja}];\)\), "\[IndentingNewLine]", 
    \(\(\[Phi]0 = Pi/2;\)\), "\[IndentingNewLine]", 
    \(\(\[Epsilon] = 0.00001;\)\), "\[IndentingNewLine]", 
    \(\(For[j = 1, 
        j \[LessEqual] 
          jaksoja, \(j++\), \[IndentingNewLine]kerroin *= \(-1\); \
\[IndentingNewLine]u0 = {u1 + \[Epsilon], 
              u2 - \[Epsilon]}[\([kerroin]\)]; \[IndentingNewLine]solu = \
\(NDSolve[{\(u'\)[t] \[Equal] kerroin*Re[g[u[t]]], u[0] \[Equal] u0}, 
              u[t], {t, 0, tmax}, MaxStepSize \[Rule] 0.0001, 
              MaxSteps \[Rule] 50000]\)[\([1]\)]; \[IndentingNewLine]U[t_] = 
          u[t] /. solu; \[IndentingNewLine]\[Theta][t_] := 
          ArcCos[U[
              t]]; \[IndentingNewLine]sol\[Phi] = \(NDSolve[{\(\[Phi]'\)[
                    t] \[Equal] \((b - a*U[t])\)/\((1 - U[t]^2)\), \[Phi][
                    0] \[Equal] \[Phi]0}, \[Phi][t], {t, 0, 
                tmax}]\)[\([1]\)]; \[IndentingNewLine]\[Theta]i = \[Theta][
            ti]; \[IndentingNewLine]\[Phi]i = \((\[Phi][t] /. sol\[Phi])\) /. 
            t \[Rule] 
              ti; \[IndentingNewLine]\[Phi]0 = \((\[Phi][t] /. sol\[Phi])\) /. 
            t \[Rule] tmax; \[IndentingNewLine]X = 
          Sin[\[Theta]i]*Cos[\[Phi]i]; \[IndentingNewLine]Y = 
          Sin[\[Theta]i]*Sin[\[Phi]i]; \[IndentingNewLine]Z = 
          Cos[\[Theta]i]; \[IndentingNewLine]kuvat[\([j]\)] = 
          ScatterPlot3D[{X, Y, Z} // Transpose, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]Print[
          j, "\</\>", jaksoja];\[IndentingNewLine]];\)\)}], "Input"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(\[Phi]0\\)\\\" is similar to existing \
symbols \\!\\({\[Alpha]0, \[Beta]0}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(solu\\)\\\" is similar to existing symbols \
\\!\\({solc, soly, solz}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(\[Theta]i\\)\\\" is similar to existing \
symbol \\\"\\!\\(\[Theta]\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(\[Phi]i\\)\\\" is similar to existing \
symbols \\!\\({\[Theta]i, \[Phi]}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 1, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 2, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 3, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 4, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(5\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 5, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(6\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 6, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(7\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 7, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(8\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 8, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(9\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 9, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(10\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 10, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(11\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 11, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(12\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 12, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(13\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 13, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(14\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 14, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(15\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 15, "/", 16],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\(16\[InvisibleSpace]"/"\[InvisibleSpace]16\),
      SequenceForm[ 16, "/", 16],
      Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[{
    \(\(pallo = 
        ParametricPlot3D[{Cos[t]\ Cos[u], Sin[t]\ Cos[u], Sin[u]}, {t, 0, 
            2  Pi}, {u, \(-Pi\)/2, Pi/2}, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(kuvaa = 
        Show[pallo, kuvat, 
          DisplayFunction \[Rule] $DisplayFunction];\)\)}], "Input"],

Cell[TextData[{
  "Tapaus a: (x1, x2 < b/a)\n{x1,x2,x3} = ",
  Cell[BoxData[
      \({1\/5, 1\/2, 2}\)]],
  "\n{\[Alpha],\[Beta],a,b} = {0.515153, 1., 1.47812, 0.845667}\nb/a \
=0.572122"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[kuvaa];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08777 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0576738 1.16792 -2.79724e-17 1.16792 [
[.08885 .23035 -11.8346 -9 ]
[.08885 .23035 .16541 0 ]
[.21763 .17597 -22.6208 -9 ]
[.21763 .17597 1.37923 0 ]
[.35353 .11861 -5.39309 -9 ]
[.35353 .11861 .60691 0 ]
[.49716 .05803 -15.393 -9 ]
[.49716 .05803 2.60705 0 ]
[.6492 -0.00605 -4.86888 -9 ]
[.6492 -0.00605 1.13112 0 ]
[.00886 .82785 -6.92493 0 ]
[.00886 .82785 5.07507 9 ]
[.12049 .90619 -13.4177 0 ]
[.12049 .90619 10.5823 9 ]
[.22061 .97645 -3.26163 0 ]
[.22061 .97645 2.73837 9 ]
[.3109 1.03981 -9.54321 0 ]
[.3109 1.03981 8.45679 9 ]
[.39276 1.09724 -3.11047 0 ]
[.39276 1.09724 2.88953 9 ]
[.07322 .26204 -12 -2.61848 ]
[.07322 .26204 0 6.38152 ]
[.05471 .37835 -24 -2.72137 ]
[.05471 .37835 0 6.27863 ]
[.03459 .50481 -6 -2.83416 ]
[.03459 .50481 0 6.16584 ]
[.01263 .64281 -18 -2.95834 ]
[.01263 .64281 0 6.04166 ]
[-0.01142 .794 -6 -3.09573 ]
[-0.01142 .794 0 5.90427 ]
[ 0 0 0 0 ]
[ 1 1.08777 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08845 .24527 m
.67201 0 L
s
.09903 .24082 m
.10412 .24605 L
s
[(-1)] .08885 .23035 .97243 1 Mshowa
.22731 .1869 m
.23214 .19237 L
s
[(-0.5)] .21763 .17597 .88506 1 Mshowa
.36263 .13003 m
.36719 .13573 L
s
[(0)] .35353 .11861 .7977 1 Mshowa
.50562 .06993 m
.50984 .07588 L
s
[(0.5)] .49716 .05803 .71033 1 Mshowa
.65692 .00634 m
.66078 .01254 L
s
[(1)] .6492 -0.00605 .62296 1 Mshowa
.125 Mabswid
.12415 .23026 m
.12717 .23343 L
s
.14953 .21959 m
.15253 .22279 L
s
.17518 .20881 m
.17815 .21204 L
s
.2011 .19792 m
.20404 .20117 L
s
.25379 .17577 m
.25666 .17908 L
s
.28056 .16452 m
.28339 .16786 L
s
.30762 .15315 m
.31042 .15652 L
s
.33498 .14165 m
.33774 .14505 L
s
.3906 .11827 m
.39329 .12173 L
s
.41887 .10639 m
.42153 .10987 L
s
.44746 .09437 m
.45008 .09789 L
s
.47638 .08222 m
.47895 .08576 L
s
.53519 .0575 m
.53768 .0611 L
s
.5651 .04493 m
.56755 .04856 L
s
.59535 .03222 m
.59776 .03588 L
s
.62596 .01935 m
.62832 .02304 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-1)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-0.5)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(0.5)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(1)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
.08669 .25641 m
.09342 .25359 L
s
[(-1)] .07322 .26204 1 -0.41811 Mshowa
.06829 .37298 m
.07508 .3703 L
s
[(-0.5)] .05471 .37835 1 -0.39525 Mshowa
.04828 .49974 m
.05513 .4972 L
s
[(0)] .03459 .50481 1 -0.37019 Mshowa
.02644 .63807 m
.03335 .63571 L
s
[(0.5)] .01263 .64281 1 -0.34259 Mshowa
.00252 .78966 m
.00949 .78748 L
s
[(1)] -0.01142 .794 1 -0.31206 Mshowa
.125 Mabswid
.08313 .27897 m
.08717 .27729 L
s
.07951 .3019 m
.08356 .30024 L
s
.07583 .3252 m
.07989 .32356 L
s
.07209 .34889 m
.07616 .34727 L
s
.06442 .39748 m
.0685 .39588 L
s
.06049 .42239 m
.06458 .42081 L
s
.05649 .44773 m
.06058 .44617 L
s
.05242 .47351 m
.05652 .47197 L
s
.04407 .52643 m
.04818 .52493 L
s
.03978 .5536 m
.0439 .55211 L
s
.03541 .58125 m
.03954 .57979 L
s
.03097 .60941 m
.03511 .60796 L
s
.02184 .66727 m
.02599 .66588 L
s
.01714 .69701 m
.0213 .69564 L
s
.01236 .72731 m
.01652 .72596 L
s
.00749 .75819 m
.01166 .75686 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
.41815 .58175 m
.08845 .24527 L
s
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.41815 .58175 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
0 0 m
1 0 L
1 1.08777 L
0 1.08777 L
closepath
clip
newpath
.5 Mabswid
.739 .591 .691 r
.44786 .61772 m .50085 .62415 L .50244 .59379 L p F P
0 g
s
.739 .591 .691 r
.50244 .59379 m .45288 .58767 L .44786 .61772 L p F P
0 g
s
.705 .562 .69 r
.55282 .59353 m .50244 .59379 L .50085 .62415 L p F P
0 g
s
.737 .605 .711 r
.45288 .58767 m .50244 .59379 L .50427 .56337 L p F P
0 g
s
.706 .578 .71 r
.50244 .59379 m .55282 .59353 L .55067 .56312 L p F P
0 g
s
.706 .578 .71 r
.55067 .56312 m .50427 .56337 L .50244 .59379 L p F P
0 g
s
.705 .562 .69 r
.50085 .62415 m .55469 .62387 L .55282 .59353 L p F P
0 g
s
.67 .535 .691 r
.60223 .58688 m .55282 .59353 L .55469 .62387 L p F P
0 g
s
.673 .554 .711 r
.55282 .59353 m .60223 .58688 L .59615 .55689 L p F P
0 g
s
.673 .554 .711 r
.59615 .55689 m .55067 .56312 L .55282 .59353 L p F P
0 g
s
.737 .605 .711 r
.50427 .56337 m .45864 .55763 L .45288 .58767 L p F P
0 g
s
.734 .619 .731 r
.45864 .55763 m .50427 .56337 L .50632 .53311 L p F P
0 g
s
.706 .595 .729 r
.50427 .56337 m .55067 .56312 L .54825 .53288 L p F P
0 g
s
.706 .595 .729 r
.54825 .53288 m .50632 .53311 L .50427 .56337 L p F P
0 g
s
.676 .572 .731 r
.55067 .56312 m .59615 .55689 L .58933 .52715 L p F P
0 g
s
.676 .572 .731 r
.58933 .52715 m .54825 .53288 L .55067 .56312 L p F P
0 g
s
.741 .576 .67 r
.44362 .64756 m .49951 .65421 L .50085 .62415 L p F P
0 g
s
.741 .576 .67 r
.50085 .62415 m .44786 .61772 L .44362 .64756 L p F P
0 g
s
.705 .545 .669 r
.55469 .62387 m .50085 .62415 L .49951 .65421 L p F P
0 g
s
.705 .545 .669 r
.49951 .65421 m .55627 .65392 L .55469 .62387 L p F P
0 g
s
.667 .516 .67 r
.60753 .61689 m .55469 .62387 L .55627 .65392 L p F P
0 g
s
.67 .535 .691 r
.55469 .62387 m .60753 .61689 L .60223 .58688 L p F P
0 g
s
.734 .619 .731 r
.50632 .53311 m .4651 .52783 L .45864 .55763 L p F P
0 g
s
.731 .633 .75 r
.4651 .52783 m .50632 .53311 L .50857 .50323 L p F P
0 g
s
.705 .61 .749 r
.50632 .53311 m .54825 .53288 L .54559 .50303 L p F P
0 g
s
.705 .61 .749 r
.54559 .50303 m .50857 .50323 L .50632 .53311 L p F P
0 g
s
.678 .59 .75 r
.54825 .53288 m .58933 .52715 L .58183 .49788 L p F P
0 g
s
.678 .59 .75 r
.58183 .49788 m .54559 .50303 L .54825 .53288 L p F P
0 g
s
.767 .635 .715 r
.40592 .5753 m .45288 .58767 L .45864 .55763 L p F P
0 g
s
.767 .635 .715 r
.45864 .55763 m .41546 .54604 L .40592 .5753 L p F P
0 g
s
.762 .647 .735 r
.41546 .54604 m .45864 .55763 L .4651 .52783 L p F P
0 g
s
.772 .623 .694 r
.39759 .60473 m .44786 .61772 L .45288 .58767 L p F P
0 g
s
.772 .623 .694 r
.45288 .58767 m .40592 .5753 L .39759 .60473 L p F P
0 g
s
.742 .559 .647 r
.44021 .67695 m .49843 .68375 L .49951 .65421 L p F P
0 g
s
.742 .559 .647 r
.49951 .65421 m .44362 .64756 L .44021 .67695 L p F P
0 g
s
.703 .527 .647 r
.55627 .65392 m .49951 .65421 L .49843 .68375 L p F P
0 g
s
.638 .53 .716 r
.63904 .54483 m .59615 .55689 L .60223 .58688 L p F P
0 g
s
.644 .551 .736 r
.59615 .55689 m .63904 .54483 L .62801 .51607 L p F P
0 g
s
.644 .551 .736 r
.62801 .51607 m .58933 .52715 L .59615 .55689 L p F P
0 g
s
.703 .527 .647 r
.49843 .68375 m .55754 .68346 L .55627 .65392 L p F P
0 g
s
.663 .495 .647 r
.61199 .6467 m .55627 .65392 L .55754 .68346 L p F P
0 g
s
.667 .516 .67 r
.55627 .65392 m .61199 .6467 L .60753 .61689 L p F P
0 g
s
.632 .509 .695 r
.64889 .57401 m .60223 .58688 L .60753 .61689 L p F P
0 g
s
.638 .53 .716 r
.60223 .58688 m .64889 .57401 L .63904 .54483 L p F P
0 g
s
.762 .647 .735 r
.4651 .52783 m .42615 .51718 L .41546 .54604 L p F P
0 g
s
.755 .659 .755 r
.42615 .51718 m .4651 .52783 L .47221 .49849 L p F P
0 g
s
.731 .633 .75 r
.50857 .50323 m .47221 .49849 L .4651 .52783 L p F P
0 g
s
.726 .647 .77 r
.47221 .49849 m .50857 .50323 L .51102 .47397 L p F P
0 g
s
.703 .626 .768 r
.50857 .50323 m .54559 .50303 L .54269 .47379 L p F P
0 g
s
.703 .626 .768 r
.54269 .47379 m .51102 .47397 L .50857 .50323 L p F P
0 g
s
.679 .609 .77 r
.54559 .50303 m .58183 .49788 L .57369 .46931 L p F P
0 g
s
.679 .609 .77 r
.57369 .46931 m .54269 .47379 L .54559 .50303 L p F P
0 g
s
.776 .609 .673 r
.39056 .6341 m .44362 .64756 L .44786 .61772 L p F P
0 g
s
.776 .609 .673 r
.44786 .61772 m .39759 .60473 L .39056 .6341 L p F P
0 g
s
.649 .572 .755 r
.58933 .52715 m .62801 .51607 L .61589 .48795 L p F P
0 g
s
.649 .572 .755 r
.61589 .48795 m .58183 .49788 L .58933 .52715 L p F P
0 g
s
.625 .487 .673 r
.65748 .60337 m .60753 .61689 L .61199 .6467 L p F P
0 g
s
.632 .509 .695 r
.60753 .61689 m .65748 .60337 L .64889 .57401 L p F P
0 g
s
.755 .659 .755 r
.47221 .49849 m .43791 .48894 L .42615 .51718 L p F P
0 g
s
.748 .67 .774 r
.43791 .48894 m .47221 .49849 L .47992 .46984 L p F P
0 g
s
.726 .647 .77 r
.51102 .47397 m .47992 .46984 L .47221 .49849 L p F P
0 g
s
.654 .593 .775 r
.58183 .49788 m .61589 .48795 L .60276 .46069 L p F P
0 g
s
.654 .593 .775 r
.60276 .46069 m .57369 .46931 L .58183 .49788 L p F P
0 g
s
.742 .542 .623 r
.43765 .70566 m .49761 .71254 L .49843 .68375 L p F P
0 g
s
.742 .542 .623 r
.49843 .68375 m .44021 .67695 L .43765 .70566 L p F P
0 g
s
.701 .507 .623 r
.55754 .68346 m .49843 .68375 L .49761 .71254 L p F P
0 g
s
.78 .595 .649 r
.38488 .66318 m .44021 .67695 L .44362 .64756 L p F P
0 g
s
.78 .595 .649 r
.44362 .64756 m .39056 .6341 L .38488 .66318 L p F P
0 g
s
.701 .507 .623 r
.49761 .71254 m .55849 .71224 L .55754 .68346 L p F P
0 g
s
.658 .473 .623 r
.61559 .67607 m .55754 .68346 L .55849 .71224 L p F P
0 g
s
.663 .495 .647 r
.55754 .68346 m .61559 .67607 L .61199 .6467 L p F P
0 g
s
.618 .463 .65 r
.66473 .63269 m .61199 .6467 L .61559 .67607 L p F P
0 g
s
.625 .487 .673 r
.61199 .6467 m .66473 .63269 L .65748 .60337 L p F P
0 g
s
.721 .661 .789 r
.47992 .46984 m .51102 .47397 L .51364 .44555 L p F P
0 g
s
.701 .643 .788 r
.51102 .47397 m .54269 .47379 L .53959 .4454 L p F P
0 g
s
.701 .643 .788 r
.53959 .4454 m .51364 .44555 L .51102 .47397 L p F P
0 g
s
.68 .628 .79 r
.54269 .47379 m .57369 .46931 L .56496 .44168 L p F P
0 g
s
.68 .628 .79 r
.56496 .44168 m .53959 .4454 L .54269 .47379 L p F P
0 g
s
.797 .669 .722 r
.36334 .557 m .40592 .5753 L .41546 .54604 L p F P
0 g
s
.797 .669 .722 r
.41546 .54604 m .37641 .52893 L .36334 .557 L p F P
0 g
s
.789 .679 .743 r
.37641 .52893 m .41546 .54604 L .42615 .51718 L p F P
0 g
s
.789 .679 .743 r
.42615 .51718 m .39102 .50148 L .37641 .52893 L p F P
0 g
s
.779 .687 .762 r
.39102 .50148 m .42615 .51718 L .43791 .48894 L p F P
0 g
s
.805 .659 .701 r
.35192 .58549 m .39759 .60473 L .40592 .5753 L p F P
0 g
s
.805 .659 .701 r
.40592 .5753 m .36334 .557 L .35192 .58549 L p F P
0 g
s
.599 .508 .723 r
.67766 .52728 m .63904 .54483 L .64889 .57401 L p F P
0 g
s
.609 .532 .743 r
.63904 .54483 m .67766 .52728 L .66275 .49998 L p F P
0 g
s
.609 .532 .743 r
.66275 .49998 m .62801 .51607 L .63904 .54483 L p F P
0 g
s
.618 .556 .763 r
.62801 .51607 m .66275 .49998 L .64638 .47354 L p F P
0 g
s
.618 .556 .763 r
.64638 .47354 m .61589 .48795 L .62801 .51607 L p F P
0 g
s
.748 .67 .774 r
.47992 .46984 m .45064 .46155 L .43791 .48894 L p F P
0 g
s
.739 .681 .794 r
.45064 .46155 m .47992 .46984 L .48818 .44212 L p F P
0 g
s
.721 .661 .789 r
.51364 .44555 m .48818 .44212 L .47992 .46984 L p F P
0 g
s
.589 .483 .701 r
.69101 .55524 m .64889 .57401 L .65748 .60337 L p F P
0 g
s
.599 .508 .723 r
.64889 .57401 m .69101 .55524 L .67766 .52728 L p F P
0 g
s
.658 .615 .794 r
.57369 .46931 m .60276 .46069 L .58871 .43451 L p F P
0 g
s
.658 .615 .794 r
.58871 .43451 m .56496 .44168 L .57369 .46931 L p F P
0 g
s
.782 .578 .624 r
.38063 .69174 m .43765 .70566 L .44021 .67695 L p F P
0 g
s
.782 .578 .624 r
.44021 .67695 m .38488 .66318 L .38063 .69174 L p F P
0 g
s
.658 .473 .623 r
.55849 .71224 m .61828 .70477 L .61559 .67607 L p F P
0 g
s
.61 .438 .624 r
.67058 .66174 m .61559 .67607 L .61828 .70477 L p F P
0 g
s
.618 .463 .65 r
.61559 .67607 m .67058 .66174 L .66473 .63269 L p F P
0 g
s
.779 .687 .762 r
.43791 .48894 m .40706 .47489 L .39102 .50148 L p F P
0 g
s
.769 .696 .782 r
.40706 .47489 m .43791 .48894 L .45064 .46155 L p F P
0 g
s
.812 .647 .678 r
.34225 .61415 m .39056 .6341 L .39759 .60473 L p F P
0 g
s
.812 .647 .678 r
.39759 .60473 m .35192 .58549 L .34225 .61415 L p F P
0 g
s
.741 .522 .596 r
.43599 .73345 m .49708 .74033 L .49761 .71254 L p F P
0 g
s
.741 .522 .596 r
.49761 .71254 m .43765 .70566 L .43599 .73345 L p F P
0 g
s
.698 .486 .597 r
.55849 .71224 m .49761 .71254 L .49708 .74033 L p F P
0 g
s
.626 .58 .783 r
.61589 .48795 m .64638 .47354 L .62869 .4482 L p F P
0 g
s
.626 .58 .783 r
.62869 .4482 m .60276 .46069 L .61589 .48795 L p F P
0 g
s
.698 .486 .597 r
.49708 .74033 m .55911 .74004 L .55849 .71224 L p F P
0 g
s
.652 .449 .596 r
.61828 .70477 m .55849 .71224 L .55911 .74004 L p F P
0 g
s
.578 .457 .678 r
.70267 .58364 m .65748 .60337 L .66473 .63269 L p F P
0 g
s
.589 .483 .701 r
.65748 .60337 m .70267 .58364 L .69101 .55524 L p F P
0 g
s
.714 .675 .81 r
.48818 .44212 m .51364 .44555 L .51642 .41822 L p F P
0 g
s
.698 .66 .809 r
.51364 .44555 m .53959 .4454 L .5363 .4181 L p F P
0 g
s
.698 .66 .809 r
.5363 .4181 m .51642 .41822 L .51364 .44555 L p F P
0 g
s
.68 .647 .81 r
.53959 .4454 m .56496 .44168 L .55572 .41521 L p F P
0 g
s
.68 .647 .81 r
.55572 .41521 m .5363 .4181 L .53959 .4454 L p F P
0 g
s
.769 .696 .782 r
.45064 .46155 m .42438 .44937 L .40706 .47489 L p F P
0 g
s
.757 .703 .801 r
.42438 .44937 m .45064 .46155 L .46425 .43523 L p F P
0 g
s
.739 .681 .794 r
.48818 .44212 m .46425 .43523 L .45064 .46155 L p F P
0 g
s
.819 .634 .653 r
.33445 .64276 m .38488 .66318 L .39056 .6341 L p F P
0 g
s
.819 .634 .653 r
.39056 .6341 m .34225 .61415 L .33445 .64276 L p F P
0 g
s
.635 .604 .802 r
.60276 .46069 m .62869 .4482 L .60982 .42416 L p F P
0 g
s
.635 .604 .802 r
.60982 .42416 m .58871 .43451 L .60276 .46069 L p F P
0 g
s
.729 .691 .814 r
.46425 .43523 m .48818 .44212 L .49693 .41555 L p F P
0 g
s
.714 .675 .81 r
.51642 .41822 m .49693 .41555 L .48818 .44212 L p F P
0 g
s
.566 .429 .653 r
.71253 .61223 m .66473 .63269 L .67058 .66174 L p F P
0 g
s
.578 .457 .678 r
.66473 .63269 m .71253 .61223 L .70267 .58364 L p F P
0 g
s
.662 .637 .814 r
.56496 .44168 m .58871 .43451 L .57385 .40965 L p F P
0 g
s
.662 .637 .814 r
.57385 .40965 m .55572 .41521 L .56496 .44168 L p F P
0 g
s
.784 .56 .596 r
.37787 .71952 m .43599 .73345 L .43765 .70566 L p F P
0 g
s
.784 .56 .596 r
.43765 .70566 m .38063 .69174 L .37787 .71952 L p F P
0 g
s
.652 .449 .596 r
.55911 .74004 m .62003 .73256 L .61828 .70477 L p F P
0 g
s
.6 .41 .596 r
.67495 .69028 m .61828 .70477 L .62003 .73256 L p F P
0 g
s
.61 .438 .624 r
.61828 .70477 m .67495 .69028 L .67058 .66174 L p F P
0 g
s
.815 .715 .754 r
.34312 .50679 m .37641 .52893 L .39102 .50148 L p F P
0 g
s
.815 .715 .754 r
.39102 .50148 m .3612 .48122 L .34312 .50679 L p F P
0 g
s
.802 .72 .774 r
.3612 .48122 m .39102 .50148 L .40706 .47489 L p F P
0 g
s
.74 .5 .566 r
.43525 .76008 m .49685 .76689 L .49708 .74033 L p F P
0 g
s
.74 .5 .566 r
.49708 .74033 m .43599 .73345 L .43525 .76008 L p F P
0 g
s
.693 .461 .567 r
.55911 .74004 m .49708 .74033 L .49685 .76689 L p F P
0 g
s
.828 .708 .733 r
.32691 .53329 m .36334 .557 L .37641 .52893 L p F P
0 g
s
.828 .708 .733 r
.37641 .52893 m .34312 .50679 L .32691 .53329 L p F P
0 g
s
.693 .461 .567 r
.49685 .76689 m .55937 .7666 L .55911 .74004 L p F P
0 g
s
.644 .422 .566 r
.62003 .73256 m .55911 .74004 L .55937 .7666 L p F P
0 g
s
.569 .515 .755 r
.69205 .47936 m .66275 .49998 L .67766 .52728 L p F P
0 g
s
.583 .543 .775 r
.66275 .49998 m .69205 .47936 L .67198 .45514 L p F P
0 g
s
.583 .543 .775 r
.67198 .45514 m .64638 .47354 L .66275 .49998 L p F P
0 g
s
.757 .703 .801 r
.46425 .43523 m .44288 .42513 L .42438 .44937 L p F P
0 g
s
.743 .71 .82 r
.44288 .42513 m .46425 .43523 L .47866 .4102 L p F P
0 g
s
.729 .691 .814 r
.49693 .41555 m .47866 .4102 L .46425 .43523 L p F P
0 g
s
.802 .72 .774 r
.40706 .47489 m .38099 .4568 L .3612 .48122 L p F P
0 g
s
.788 .725 .793 r
.38099 .4568 m .40706 .47489 L .42438 .44937 L p F P
0 g
s
.824 .619 .625 r
.32861 .67106 m .38063 .69174 L .38488 .66318 L p F P
0 g
s
.824 .619 .625 r
.38488 .66318 m .33445 .64276 L .32861 .67106 L p F P
0 g
s
.554 .486 .734 r
.71039 .50475 m .67766 .52728 L .69101 .55524 L p F P
0 g
s
.569 .515 .755 r
.67766 .52728 m .71039 .50475 L .69205 .47936 L p F P
0 g
s
.643 .629 .821 r
.58871 .43451 m .60982 .42416 L .58991 .40164 L p F P
0 g
s
.643 .629 .821 r
.58991 .40164 m .57385 .40965 L .58871 .43451 L p F P
0 g
s
.597 .57 .794 r
.64638 .47354 m .67198 .45514 L .65036 .43229 L p F P
0 g
s
.597 .57 .794 r
.65036 .43229 m .62869 .4482 L .64638 .47354 L p F P
0 g
s
.553 .399 .625 r
.72049 .64079 m .67058 .66174 L .67495 .69028 L p F P
0 g
s
.566 .429 .653 r
.67058 .66174 m .72049 .64079 L .71253 .61223 L p F P
0 g
s
.839 .7 .71 r
.31271 .5605 m .35192 .58549 L .36334 .557 L p F P
0 g
s
.839 .7 .71 r
.36334 .557 m .32691 .53329 L .31271 .5605 L p F P
0 g
s
.706 .689 .831 r
.49693 .41555 m .51642 .41822 L .51934 .39222 L p F P
0 g
s
.693 .678 .83 r
.51642 .41822 m .5363 .4181 L .53284 .39214 L p F P
0 g
s
.693 .678 .83 r
.53284 .39214 m .51934 .39222 L .51642 .41822 L p F P
0 g
s
.68 .668 .832 r
.5363 .4181 m .55572 .41521 L .54601 .39015 L p F P
0 g
s
.68 .668 .832 r
.54601 .39015 m .53284 .39214 L .5363 .4181 L p F P
0 g
s
.539 .457 .711 r
.72684 .53111 m .69101 .55524 L .70267 .58364 L p F P
0 g
s
.554 .486 .734 r
.69101 .55524 m .72684 .53111 L .71039 .50475 L p F P
0 g
s
.788 .725 .793 r
.42438 .44937 m .40231 .43372 L .38099 .4568 L p F P
0 g
s
.772 .728 .811 r
.40231 .43372 m .42438 .44937 L .44288 .42513 L p F P
0 g
s
.61 .597 .813 r
.62869 .4482 m .65036 .43229 L .62736 .41101 L p F P
0 g
s
.61 .597 .813 r
.62736 .41101 m .60982 .42416 L .62869 .4482 L p F P
0 g
s
.717 .702 .835 r
.47866 .4102 m .49693 .41555 L .50612 .39038 L p F P
0 g
s
.706 .689 .831 r
.51934 .39222 m .50612 .39038 L .49693 .41555 L p F P
0 g
s
.666 .661 .835 r
.55572 .41521 m .57385 .40965 L .55829 .38633 L p F P
0 g
s
.666 .661 .835 r
.55829 .38633 m .54601 .39015 L .55572 .41521 L p F P
0 g
s
.85 .691 .685 r
.30068 .58821 m .34225 .61415 L .35192 .58549 L p F P
0 g
s
.85 .691 .685 r
.35192 .58549 m .31271 .5605 L .30068 .58821 L p F P
0 g
s
.785 .539 .564 r
.37665 .74627 m .43525 .76008 L .43599 .73345 L p F P
0 g
s
.785 .539 .564 r
.43599 .73345 m .37787 .71952 L .37665 .74627 L p F P
0 g
s
.644 .422 .566 r
.55937 .7666 m .62079 .7592 L .62003 .73256 L p F P
0 g
s
.588 .378 .564 r
.67779 .71806 m .62003 .73256 L .62079 .7592 L p F P
0 g
s
.6 .41 .596 r
.62003 .73256 m .67779 .71806 L .67495 .69028 L p F P
0 g
s
.522 .425 .686 r
.74124 .55821 m .70267 .58364 L .71253 .61223 L p F P
0 g
s
.539 .457 .711 r
.70267 .58364 m .74124 .55821 L .72684 .53111 L p F P
0 g
s
.772 .728 .811 r
.44288 .42513 m .425 .41219 L .40231 .43372 L p F P
0 g
s
.755 .73 .83 r
.425 .41219 m .44288 .42513 L .46239 .40238 L p F P
0 g
s
.743 .71 .82 r
.47866 .4102 m .46239 .40238 L .44288 .42513 L p F P
0 g
s
.727 .716 .84 r
.46239 .40238 m .47866 .4102 L .49375 .38671 L p F P
0 g
s
.717 .702 .835 r
.50612 .39038 m .49375 .38671 L .47866 .4102 L p F P
0 g
s
.829 .602 .594 r
.3248 .69882 m .37787 .71952 L .38063 .69174 L p F P
0 g
s
.829 .602 .594 r
.38063 .69174 m .32861 .67106 L .3248 .69882 L p F P
0 g
s
.624 .624 .83 r
.60982 .42416 m .62736 .41101 L .60318 .39149 L p F P
0 g
s
.624 .624 .83 r
.60318 .39149 m .58991 .40164 L .60982 .42416 L p F P
0 g
s
.652 .655 .84 r
.57385 .40965 m .58991 .40164 L .56911 .38083 L p F P
0 g
s
.652 .655 .84 r
.56911 .38083 m .55829 .38633 L .57385 .40965 L p F P
0 g
s
.538 .365 .594 r
.72646 .66907 m .67495 .69028 L .67779 .71806 L p F P
0 g
s
.553 .399 .625 r
.67495 .69028 m .72646 .66907 L .72049 .64079 L p F P
0 g
s
.736 .474 .532 r
.43547 .78528 m .49691 .79197 L .49685 .76689 L p F P
0 g
s
.736 .474 .532 r
.49685 .76689 m .43525 .76008 L .43547 .78528 L p F P
0 g
s
.688 .434 .533 r
.55937 .7666 m .49685 .76689 L .49691 .79197 L p F P
0 g
s
.688 .434 .533 r
.49691 .79197 m .55928 .79168 L .55937 .7666 L p F P
0 g
s
.635 .391 .531 r
.62079 .7592 m .55937 .7666 L .55928 .79168 L p F P
0 g
s
.86 .68 .658 r
.29095 .61616 m .33445 .64276 L .34225 .61415 L p F P
0 g
s
.86 .68 .658 r
.34225 .61415 m .30068 .58821 L .29095 .61616 L p F P
0 g
s
.503 .39 .658 r
.75344 .58582 m .71253 .61223 L .72049 .64079 L p F P
0 g
s
.522 .425 .686 r
.71253 .61223 m .75344 .58582 L .74124 .55821 L p F P
0 g
s
.695 .704 .854 r
.50612 .39038 m .51934 .39222 L .52239 .3678 L p F P
0 g
s
.687 .697 .854 r
.51934 .39222 m .53284 .39214 L .52924 .36776 L p F P
0 g
s
.687 .697 .854 r
.52924 .36776 m .52239 .3678 L .51934 .39222 L p F P
0 g
s
.678 .69 .854 r
.53284 .39214 m .54601 .39015 L .53592 .36673 L p F P
0 g
s
.678 .69 .854 r
.53592 .36673 m .52924 .36776 L .53284 .39214 L p F P
0 g
s
.755 .73 .83 r
.46239 .40238 m .44886 .39239 L .425 .41219 L p F P
0 g
s
.735 .731 .847 r
.44886 .39239 m .46239 .40238 L .48278 .38134 L p F P
0 g
s
.727 .716 .84 r
.49375 .38671 m .48278 .38134 L .46239 .40238 L p F P
0 g
s
.824 .757 .79 r
.3381 .45706 m .3612 .48122 L .38099 .4568 L p F P
0 g
s
.824 .757 .79 r
.38099 .4568 m .36094 .43529 L .3381 .45706 L p F P
0 g
s
.805 .757 .808 r
.36094 .43529 m .38099 .4568 L .40231 .43372 L p F P
0 g
s
.637 .652 .848 r
.58991 .40164 m .60318 .39149 L .578 .3739 L p F P
0 g
s
.637 .652 .848 r
.578 .3739 m .56911 .38083 L .58991 .40164 L p F P
0 g
s
.841 .756 .769 r
.31717 .48032 m .34312 .50679 L .3612 .48122 L p F P
0 g
s
.841 .756 .769 r
.3612 .48122 m .3381 .45706 L .31717 .48032 L p F P
0 g
s
.805 .757 .808 r
.40231 .43372 m .38547 .41519 L .36094 .43529 L p F P
0 g
s
.786 .755 .825 r
.38547 .41519 m .40231 .43372 L .425 .41219 L p F P
0 g
s
.702 .712 .856 r
.49375 .38671 m .50612 .39038 L .51567 .36686 L p F P
0 g
s
.695 .704 .854 r
.52239 .3678 m .51567 .36686 L .50612 .39038 L p F P
0 g
s
.669 .686 .857 r
.54601 .39015 m .55829 .38633 L .54213 .36477 L p F P
0 g
s
.669 .686 .857 r
.54213 .36477 m .53592 .36673 L .54601 .39015 L p F P
0 g
s
.544 .531 .791 r
.69147 .43339 m .67198 .45514 L .69205 .47936 L p F P
0 g
s
.565 .562 .81 r
.67198 .45514 m .69147 .43339 L .66672 .41355 L p F P
0 g
s
.565 .562 .81 r
.66672 .41355 m .65036 .43229 L .67198 .45514 L p F P
0 g
s
.584 .592 .827 r
.65036 .43229 m .66672 .41355 L .64049 .39557 L p F P
0 g
s
.584 .592 .827 r
.64049 .39557 m .62736 .41101 L .65036 .43229 L p F P
0 g
s
.523 .499 .771 r
.71452 .45492 m .69205 .47936 L .71039 .50475 L p F P
0 g
s
.544 .531 .791 r
.69205 .47936 m .71452 .45492 L .69147 .43339 L p F P
0 g
s
.784 .514 .527 r
.37701 .77175 m .43547 .78528 L .43525 .76008 L p F P
0 g
s
.784 .514 .527 r
.43525 .76008 m .37665 .74627 L .37701 .77175 L p F P
0 g
s
.858 .754 .747 r
.29834 .50487 m .32691 .53329 L .34312 .50679 L p F P
0 g
s
.858 .754 .747 r
.34312 .50679 m .31717 .48032 L .29834 .50487 L p F P
0 g
s
.786 .755 .825 r
.425 .41219 m .41147 .39692 L .38547 .41519 L p F P
0 g
s
.764 .752 .842 r
.41147 .39692 m .425 .41219 L .44886 .39239 L p F P
0 g
s
.635 .391 .531 r
.55928 .79168 m .62055 .78442 L .62079 .7592 L p F P
0 g
s
.575 .342 .526 r
.67904 .74483 m .62079 .7592 L .62055 .78442 L p F P
0 g
s
.588 .378 .564 r
.62079 .7592 m .67904 .74483 L .67779 .71806 L p F P
0 g
s
.869 .666 .626 r
.28366 .64412 m .32861 .67106 L .33445 .64276 L p F P
0 g
s
.869 .666 .626 r
.33445 .64276 m .29095 .61616 L .28366 .64412 L p F P
0 g
s
.708 .722 .86 r
.48278 .38134 m .49375 .38671 L .50941 .36497 L p F P
0 g
s
.702 .712 .856 r
.51567 .36686 m .50941 .36497 L .49375 .38671 L p F P
0 g
s
.832 .581 .559 r
.32312 .72577 m .37665 .74627 L .37787 .71952 L p F P
0 g
s
.832 .581 .559 r
.37787 .71952 m .3248 .69882 L .32312 .72577 L p F P
0 g
s
.66 .683 .86 r
.55829 .38633 m .56911 .38083 L .54759 .36196 L p F P
0 g
s
.66 .683 .86 r
.54759 .36196 m .54213 .36477 L .55829 .38633 L p F P
0 g
s
.604 .622 .843 r
.62736 .41101 m .64049 .39557 L .61301 .37961 L p F P
0 g
s
.604 .622 .843 r
.61301 .37961 m .60318 .39149 L .62736 .41101 L p F P
0 g
s
.501 .465 .749 r
.73565 .47797 m .71039 .50475 L .72684 .53111 L p F P
0 g
s
.523 .499 .771 r
.71039 .50475 m .73565 .47797 L .71452 .45492 L p F P
0 g
s
.521 .327 .558 r
.73033 .69683 m .67779 .71806 L .67904 .74483 L p F P
0 g
s
.538 .365 .594 r
.67779 .71806 m .73033 .69683 L .72646 .66907 L p F P
0 g
s
.483 .352 .626 r
.7633 .61371 m .72049 .64079 L .72646 .66907 L p F P
0 g
s
.503 .39 .658 r
.72049 .64079 m .7633 .61371 L .75344 .58582 L p F P
0 g
s
.874 .75 .723 r
.28181 .5305 m .31271 .5605 L .32691 .53329 L p F P
0 g
s
.874 .75 .723 r
.32691 .53329 m .29834 .50487 L .28181 .5305 L p F P
0 g
s
.764 .752 .842 r
.44886 .39239 m .43871 .38065 L .41147 .39692 L p F P
0 g
s
.742 .748 .857 r
.43871 .38065 m .44886 .39239 L .47371 .37452 L p F P
0 g
s
.735 .731 .847 r
.48278 .38134 m .47371 .37452 L .44886 .39239 L p F P
0 g
s
.713 .731 .865 r
.47371 .37452 m .48278 .38134 L .50388 .36222 L p F P
0 g
s
.708 .722 .86 r
.50941 .36497 m .50388 .36222 L .48278 .38134 L p F P
0 g
s
.623 .652 .858 r
.60318 .39149 m .61301 .37961 L .58453 .36581 L p F P
0 g
s
.623 .652 .858 r
.58453 .36581 m .578 .3739 L .60318 .39149 L p F P
0 g
s
.651 .681 .866 r
.56911 .38083 m .578 .3739 L .55204 .35842 L p F P
0 g
s
.651 .681 .866 r
.55204 .35842 m .54759 .36196 L .56911 .38083 L p F P
0 g
s
.477 .428 .724 r
.75466 .50234 m .72684 .53111 L .74124 .55821 L p F P
0 g
s
.501 .465 .749 r
.72684 .53111 m .75466 .50234 L .73565 .47797 L p F P
0 g
s
.731 .443 .491 r
.43667 .80881 m .49728 .81531 L .49691 .79197 L p F P
0 g
s
.731 .443 .491 r
.49691 .79197 m .43547 .78528 L .43667 .80881 L p F P
0 g
s
.679 .401 .493 r
.55928 .79168 m .49691 .79197 L .49728 .81531 L p F P
0 g
s
.679 .401 .493 r
.49728 .81531 m .55883 .81503 L .55928 .79168 L p F P
0 g
s
.623 .355 .49 r
.62055 .78442 m .55928 .79168 L .55883 .81503 L p F P
0 g
s
.889 .744 .695 r
.26778 .55699 m .30068 .58821 L .31271 .5605 L p F P
0 g
s
.889 .744 .695 r
.31271 .5605 m .28181 .5305 L .26778 .55699 L p F P
0 g
s
.877 .65 .591 r
.2789 .67183 m .3248 .69882 L .32861 .67106 L p F P
0 g
s
.877 .65 .591 r
.32861 .67106 m .28366 .64412 L .2789 .67183 L p F P
0 g
s
.742 .748 .857 r
.47371 .37452 m .46697 .36652 L .43871 .38065 L p F P
0 g
s
.716 .741 .871 r
.46697 .36652 m .47371 .37452 L .49933 .35873 L p F P
0 g
s
.713 .731 .865 r
.50388 .36222 m .49933 .35873 L .47371 .37452 L p F P
0 g
s
.681 .72 .879 r
.52552 .34522 m .51567 .36686 L .52239 .3678 L closepath p F P
0 g
s
.678 .717 .878 r
.52552 .34522 m .52239 .3678 L .52924 .36776 L closepath p F P
0 g
s
.675 .715 .879 r
.52552 .34522 m .52924 .36776 L .53592 .36673 L closepath p F P
0 g
s
.642 .682 .872 r
.578 .3739 m .58453 .36581 L .55528 .35431 L p F P
0 g
s
.642 .682 .872 r
.55528 .35431 m .55204 .35842 L .578 .3739 L p F P
0 g
s
.45 .388 .696 r
.77134 .52783 m .74124 .55821 L .75344 .58582 L p F P
0 g
s
.477 .428 .724 r
.74124 .55821 m .77134 .52783 L .75466 .50234 L p F P
0 g
s
.684 .723 .879 r
.52552 .34522 m .50941 .36497 L .51567 .36686 L closepath p F P
0 g
s
.672 .713 .879 r
.52552 .34522 m .53592 .36673 L .54213 .36477 L closepath p F P
0 g
s
.459 .31 .59 r
.7707 .64164 m .72646 .66907 L .73033 .69683 L p F P
0 g
s
.483 .352 .626 r
.72646 .66907 m .7707 .64164 L .7633 .61371 L p F P
0 g
s
.795 .785 .843 r
.37475 .39449 m .38547 .41519 L .41147 .39692 L p F P
0 g
s
.795 .785 .843 r
.41147 .39692 m .40299 .37993 L .37475 .39449 L p F P
0 g
s
.771 .775 .856 r
.40299 .37993 m .41147 .39692 L .43871 .38065 L p F P
0 g
s
.819 .793 .828 r
.34799 .41119 m .36094 .43529 L .38547 .41519 L p F P
0 g
s
.819 .793 .828 r
.38547 .41519 m .37475 .39449 L .34799 .41119 L p F P
0 g
s
.686 .726 .881 r
.52552 .34522 m .50388 .36222 L .50941 .36497 L closepath p F P
0 g
s
.668 .712 .881 r
.52552 .34522 m .54213 .36477 L .54759 .36196 L closepath p F P
0 g
s
.834 .556 .517 r
.32363 .75164 m .37701 .77175 L .37665 .74627 L p F P
0 g
s
.834 .556 .517 r
.37665 .74627 m .32312 .72577 L .32363 .75164 L p F P
0 g
s
.782 .483 .483 r
.37901 .79568 m .43667 .80881 L .43547 .78528 L p F P
0 g
s
.782 .483 .483 r
.43547 .78528 m .37701 .77175 L .37901 .79568 L p F P
0 g
s
.557 .592 .845 r
.6485 .37848 m .64049 .39557 L .66672 .41355 L p F P
0 g
s
.583 .624 .858 r
.64049 .39557 m .6485 .37848 L .61891 .36652 L p F P
0 g
s
.583 .624 .858 r
.61891 .36652 m .61301 .37961 L .64049 .39557 L p F P
0 g
s
.771 .775 .856 r
.43871 .38065 m .43247 .36763 L .40299 .37993 L p F P
0 g
s
.745 .764 .868 r
.43247 .36763 m .43871 .38065 L .46697 .36652 L p F P
0 g
s
.529 .558 .829 r
.67688 .39272 m .66672 .41355 L .69147 .43339 L p F P
0 g
s
.557 .592 .845 r
.66672 .41355 m .67688 .39272 L .6485 .37848 L p F P
0 g
s
.623 .355 .49 r
.55883 .81503 m .61927 .80798 L .62055 .78442 L p F P
0 g
s
.557 .3 .482 r
.67865 .77033 m .62055 .78442 L .61927 .80798 L p F P
0 g
s
.575 .342 .526 r
.62055 .78442 m .67865 .77033 L .67904 .74483 L p F P
0 g
s
.842 .799 .81 r
.32298 .4299 m .3381 .45706 L .36094 .43529 L p F P
0 g
s
.842 .799 .81 r
.36094 .43529 m .34799 .41119 L .32298 .4299 L p F P
0 g
s
.5 .283 .516 r
.73204 .72379 m .67904 .74483 L .67865 .77033 L p F P
0 g
s
.521 .327 .558 r
.67904 .74483 m .73204 .72379 L .73033 .69683 L p F P
0 g
s
.609 .654 .869 r
.61301 .37961 m .61891 .36652 L .58836 .35694 L p F P
0 g
s
.609 .654 .869 r
.58836 .35694 m .58453 .36581 L .61301 .37961 L p F P
0 g
s
.687 .73 .883 r
.52552 .34522 m .49933 .35873 L .50388 .36222 L closepath p F P
0 g
s
.665 .712 .883 r
.52552 .34522 m .54759 .36196 L .55204 .35842 L closepath p F P
0 g
s
.5 .523 .812 r
.70377 .40912 m .69147 .43339 L .71452 .45492 L p F P
0 g
s
.529 .558 .829 r
.69147 .43339 m .70377 .40912 L .67688 .39272 L p F P
0 g
s
.903 .735 .663 r
.25641 .58412 m .29095 .61616 L .30068 .58821 L p F P
0 g
s
.903 .735 .663 r
.30068 .58821 m .26778 .55699 L .25641 .58412 L p F P
0 g
s
.745 .764 .868 r
.46697 .36652 m .4629 .35769 L .43247 .36763 L p F P
0 g
s
.717 .751 .879 r
.4629 .35769 m .46697 .36652 L .49599 .35466 L p F P
0 g
s
.716 .741 .871 r
.49933 .35873 m .49599 .35466 L .46697 .36652 L p F P
0 g
s
.635 .684 .879 r
.58453 .36581 m .58836 .35694 L .55714 .34982 L p F P
0 g
s
.635 .684 .879 r
.55714 .34982 m .55528 .35431 L .58453 .36581 L p F P
0 g
s
.864 .804 .79 r
.29998 .45046 m .31717 .48032 L .3381 .45706 L p F P
0 g
s
.864 .804 .79 r
.3381 .45706 m .32298 .4299 L .29998 .45046 L p F P
0 g
s
.688 .733 .885 r
.52552 .34522 m .49599 .35466 L .49933 .35873 L closepath p F P
0 g
s
.662 .712 .885 r
.52552 .34522 m .55204 .35842 L .55528 .35431 L closepath p F P
0 g
s
.421 .343 .663 r
.78551 .55421 m .75344 .58582 L .7633 .61371 L p F P
0 g
s
.45 .388 .696 r
.75344 .58582 m .78551 .55421 L .77134 .52783 L p F P
0 g
s
.468 .484 .792 r
.7289 .42756 m .71452 .45492 L .73565 .47797 L p F P
0 g
s
.5 .523 .812 r
.71452 .45492 m .7289 .42756 L .70377 .40912 L p F P
0 g
s
.883 .629 .549 r
.2768 .69902 m .32312 .72577 L .3248 .69882 L p F P
0 g
s
.883 .629 .549 r
.3248 .69882 m .2789 .67183 L .2768 .69902 L p F P
0 g
s
.717 .751 .879 r
.49599 .35466 m .49401 .3502 L .4629 .35769 L p F P
0 g
s
.688 .736 .888 r
.52552 .34522 m .49401 .3502 L .49599 .35466 L closepath p F P
0 g
s
.66 .713 .888 r
.52552 .34522 m .55528 .35431 L .55714 .34982 L closepath p F P
0 g
s
.886 .808 .767 r
.27923 .47271 m .29834 .50487 L .31717 .48032 L p F P
0 g
s
.886 .808 .767 r
.31717 .48032 m .29998 .45046 L .27923 .47271 L p F P
0 g
s
.723 .405 .441 r
.43887 .8304 m .49797 .83664 L .49728 .81531 L p F P
0 g
s
.723 .405 .441 r
.49728 .81531 m .43667 .80881 L .43887 .8304 L p F P
0 g
s
.668 .361 .445 r
.55883 .81503 m .49728 .81531 L .49797 .83664 L p F P
0 g
s
.668 .361 .445 r
.49797 .83664 m .55799 .83637 L .55883 .81503 L p F P
0 g
s
.607 .311 .44 r
.61927 .80798 m .55883 .81503 L .55799 .83637 L p F P
0 g
s
.432 .261 .547 r
.77552 .66935 m .73033 .69683 L .73204 .72379 L p F P
0 g
s
.459 .31 .59 r
.73033 .69683 m .77552 .66935 L .7707 .64164 L p F P
0 g
s
.745 .78 .881 r
.43049 .35393 m .43247 .36763 L .4629 .35769 L p F P
0 g
s
.745 .78 .881 r
.4629 .35769 m .46172 .34844 L .43049 .35393 L p F P
0 g
s
.716 .76 .887 r
.46172 .34844 m .4629 .35769 L .49401 .3502 L p F P
0 g
s
.434 .442 .768 r
.75203 .44788 m .73565 .47797 L .75466 .50234 L p F P
0 g
s
.468 .484 .792 r
.73565 .47797 m .75203 .44788 L .7289 .42756 L p F P
0 g
s
.772 .798 .874 r
.4001 .36197 m .40299 .37993 L .43247 .36763 L p F P
0 g
s
.772 .798 .874 r
.43247 .36763 m .43049 .35393 L .4001 .36197 L p F P
0 g
s
.596 .66 .883 r
.58929 .34767 m .58836 .35694 L .61891 .36652 L p F P
0 g
s
.628 .689 .887 r
.58836 .35694 m .58929 .34767 L .55753 .34515 L p F P
0 g
s
.628 .689 .887 r
.55753 .34515 m .55714 .34982 L .58836 .35694 L p F P
0 g
s
.716 .76 .887 r
.49401 .3502 m .49349 .34553 L .46172 .34844 L p F P
0 g
s
.687 .739 .89 r
.52552 .34522 m .49349 .34553 L .49401 .3502 L closepath p F P
0 g
s
.658 .715 .891 r
.52552 .34522 m .55714 .34982 L .55753 .34515 L closepath p F P
0 g
s
.917 .723 .626 r
.24787 .61163 m .28366 .64412 L .29095 .61616 L p F P
0 g
s
.917 .723 .626 r
.29095 .61616 m .25641 .58412 L .24787 .61163 L p F P
0 g
s
.563 .63 .875 r
.62051 .35279 m .61891 .36652 L .6485 .37848 L p F P
0 g
s
.596 .66 .883 r
.61891 .36652 m .62051 .35279 L .58929 .34767 L p F P
0 g
s
.8 .815 .864 r
.37085 .37251 m .37475 .39449 L .40299 .37993 L p F P
0 g
s
.8 .815 .864 r
.40299 .37993 m .4001 .36197 L .37085 .37251 L p F P
0 g
s
.681 .744 .899 r
.52552 .34522 m .50073 .33256 L .49692 .3365 L closepath p F P
0 g
s
.684 .743 .896 r
.52552 .34522 m .49692 .3365 L .49447 .3409 L closepath p F P
0 g
s
.686 .741 .893 r
.52552 .34522 m .49447 .3409 L .49349 .34553 L closepath p F P
0 g
s
.656 .717 .893 r
.52552 .34522 m .55753 .34515 L .55642 .34052 L closepath p F P
0 g
s
.656 .72 .896 r
.52552 .34522 m .55642 .34052 L .55385 .33615 L closepath p F P
0 g
s
.656 .724 .899 r
.52552 .34522 m .55385 .33615 L .54994 .33226 L closepath p F P
0 g
s
.657 .727 .901 r
.52552 .34522 m .54994 .33226 L .54486 .32902 L closepath p F P
0 g
s
.658 .731 .903 r
.52552 .34522 m .54486 .32902 L .53885 .32659 L closepath p F P
0 g
s
.661 .734 .904 r
.52552 .34522 m .53885 .32659 L .5322 .32511 L closepath p F P
0 g
s
.664 .738 .905 r
.52552 .34522 m .5322 .32511 L .52522 .32463 L closepath p F P
0 g
s
.667 .74 .905 r
.52552 .34522 m .52522 .32463 L .51826 .32519 L closepath p F P
0 g
s
.671 .742 .904 r
.52552 .34522 m .51826 .32519 L .51166 .32676 L closepath p F P
0 g
s
.674 .744 .903 r
.52552 .34522 m .51166 .32676 L .50572 .32925 L closepath p F P
0 g
s
.678 .744 .901 r
.52552 .34522 m .50572 .32925 L .50073 .33256 L closepath p F P
0 g
s
.834 .524 .466 r
.32638 .77616 m .37901 .79568 L .37701 .77175 L p F P
0 g
s
.834 .524 .466 r
.37701 .77175 m .32363 .75164 L .32638 .77616 L p F P
0 g
s
.388 .293 .626 r
.79699 .58126 m .7633 .61371 L .7707 .64164 L p F P
0 g
s
.421 .343 .663 r
.7633 .61371 m .79699 .58126 L .78551 .55421 L p F P
0 g
s
.528 .596 .866 r
.65091 .36046 m .6485 .37848 L .67688 .39272 L p F P
0 g
s
.563 .63 .875 r
.6485 .37848 m .65091 .36046 L .62051 .35279 L p F P
0 g
s
.907 .809 .739 r
.26096 .49646 m .28181 .5305 L .29834 .50487 L p F P
0 g
s
.907 .809 .739 r
.29834 .50487 m .27923 .47271 L .26096 .49646 L p F P
0 g
s
.713 .768 .895 r
.46352 .33919 m .46172 .34844 L .49349 .34553 L p F P
0 g
s
.713 .768 .895 r
.49349 .34553 m .49447 .3409 L .46352 .33919 L p F P
0 g
s
.557 .3 .482 r
.61927 .80798 m .67657 .7943 L .67865 .77033 L p F P
0 g
s
.474 .23 .464 r
.7315 .7497 m .67865 .77033 L .67657 .7943 L p F P
0 g
s
.5 .283 .516 r
.67865 .77033 m .7315 .7497 L .73204 .72379 L p F P
0 g
s
.623 .695 .896 r
.55642 .34052 m .55753 .34515 L .58929 .34767 L p F P
0 g
s
.775 .445 .429 r
.38267 .81778 m .43887 .8304 L .43667 .80881 L p F P
0 g
s
.775 .445 .429 r
.43667 .80881 m .37901 .79568 L .38267 .81778 L p F P
0 g
s
.827 .831 .851 r
.34301 .38548 m .34799 .41119 L .37475 .39449 L p F P
0 g
s
.827 .831 .851 r
.37475 .39449 m .37085 .37251 L .34301 .38548 L p F P
0 g
s
.607 .311 .44 r
.55799 .83637 m .61693 .8296 L .61927 .80798 L p F P
0 g
s
.535 .249 .427 r
.67657 .7943 m .61927 .80798 L .61693 .8296 L p F P
0 g
s
.396 .395 .741 r
.77289 .46993 m .75466 .50234 L .77134 .52783 L p F P
0 g
s
.434 .442 .768 r
.75466 .50234 m .77289 .46993 L .75203 .44788 L p F P
0 g
s
.49 .559 .854 r
.68018 .37066 m .67688 .39272 L .70377 .40912 L p F P
0 g
s
.528 .596 .866 r
.67688 .39272 m .68018 .37066 L .65091 .36046 L p F P
0 g
s
.74 .794 .896 r
.43296 .34016 m .43049 .35393 L .46172 .34844 L p F P
0 g
s
.74 .794 .896 r
.46172 .34844 m .46352 .33919 L .43296 .34016 L p F P
0 g
s
.586 .669 .897 r
.58722 .33844 m .58929 .34767 L .62051 .35279 L p F P
0 g
s
.623 .695 .896 r
.58929 .34767 m .58722 .33844 L .55642 .34052 L p F P
0 g
s
.707 .774 .904 r
.46828 .33039 m .46352 .33919 L .49447 .3409 L p F P
0 g
s
.707 .774 .904 r
.49447 .3409 m .49692 .3365 L .46828 .33039 L p F P
0 g
s
.619 .703 .905 r
.55385 .33615 m .55642 .34052 L .58722 .33844 L p F P
0 g
s
.888 .602 .498 r
.27744 .72542 m .32363 .75164 L .32312 .72577 L p F P
0 g
s
.888 .602 .498 r
.32312 .72577 m .2768 .69902 L .27744 .72542 L p F P
0 g
s
.854 .846 .835 r
.3169 .40081 m .32298 .4299 L .34799 .41119 L p F P
0 g
s
.854 .846 .835 r
.34799 .41119 m .34301 .38548 L .3169 .40081 L p F P
0 g
s
.768 .82 .893 r
.40308 .34383 m .4001 .36197 L .43049 .35393 L p F P
0 g
s
.768 .82 .893 r
.43049 .35393 m .43296 .34016 L .40308 .34383 L p F P
0 g
s
.929 .707 .582 r
.24231 .63926 m .2789 .67183 L .28366 .64412 L p F P
0 g
s
.929 .707 .582 r
.28366 .64412 m .24787 .61163 L .24231 .63926 L p F P
0 g
s
.398 .203 .496 r
.77764 .69656 m .73204 .72379 L .7315 .7497 L p F P
0 g
s
.432 .261 .547 r
.73204 .72379 m .77764 .69656 L .77552 .66935 L p F P
0 g
s
.699 .778 .913 r
.47579 .32245 m .46828 .33039 L .49692 .3365 L p F P
0 g
s
.699 .778 .913 r
.49692 .3365 m .50073 .33256 L .47579 .32245 L p F P
0 g
s
.928 .807 .706 r
.24541 .52151 m .26778 .55699 L .28181 .5305 L p F P
0 g
s
.928 .807 .706 r
.28181 .5305 m .26096 .49646 L .24541 .52151 L p F P
0 g
s
.618 .713 .913 r
.54994 .33226 m .55385 .33615 L .58222 .32969 L p F P
0 g
s
.619 .703 .905 r
.58722 .33844 m .58222 .32969 L .55385 .33615 L p F P
0 g
s
.447 .518 .838 r
.70803 .38332 m .70377 .40912 L .7289 .42756 L p F P
0 g
s
.49 .559 .854 r
.70377 .40912 m .70803 .38332 L .68018 .37066 L p F P
0 g
s
.545 .64 .895 r
.61766 .33904 m .62051 .35279 L .65091 .36046 L p F P
0 g
s
.586 .669 .897 r
.62051 .35279 m .61766 .33904 L .58722 .33844 L p F P
0 g
s
.349 .235 .58 r
.80561 .60873 m .7707 .64164 L .77552 .66935 L p F P
0 g
s
.388 .293 .626 r
.7707 .64164 m .80561 .60873 L .79699 .58126 L p F P
0 g
s
.353 .342 .707 r
.79126 .49351 m .77134 .52783 L .78551 .55421 L p F P
0 g
s
.396 .395 .741 r
.77134 .52783 m .79126 .49351 L .77289 .46993 L p F P
0 g
s
.732 .806 .91 r
.43987 .32699 m .43296 .34016 L .46352 .33919 L p F P
0 g
s
.732 .806 .91 r
.46352 .33919 m .46828 .33039 L .43987 .32699 L p F P
0 g
s
.689 .78 .92 r
.48573 .31579 m .47579 .32245 L .50073 .33256 L p F P
0 g
s
.689 .78 .92 r
.50073 .33256 m .50572 .32925 L .48573 .31579 L p F P
0 g
s
.618 .713 .913 r
.58222 .32969 m .57449 .32185 L .54994 .33226 L p F P
0 g
s
.62 .724 .921 r
.54486 .32902 m .54994 .33226 L .57449 .32185 L p F P
0 g
s
.577 .682 .912 r
.58222 .32969 m .58722 .33844 L .61766 .33904 L p F P
0 g
s
.709 .357 .379 r
.44208 .84977 m .49898 .8557 L .49797 .83664 L p F P
0 g
s
.709 .357 .379 r
.49797 .83664 m .43887 .8304 L .44208 .84977 L p F P
0 g
s
.651 .311 .384 r
.55799 .83637 m .49797 .83664 L .49898 .8557 L p F P
0 g
s
.651 .311 .384 r
.49898 .8557 m .55678 .85544 L .55799 .83637 L p F P
0 g
s
.585 .256 .378 r
.61693 .8296 m .55799 .83637 L .55678 .85544 L p F P
0 g
s
.881 .859 .815 r
.29278 .41837 m .29998 .45046 L .32298 .4299 L p F P
0 g
s
.881 .859 .815 r
.32298 .4299 m .3169 .40081 L .29278 .41837 L p F P
0 g
s
.796 .846 .888 r
.37419 .35022 m .37085 .37251 L .4001 .36197 L p F P
0 g
s
.796 .846 .888 r
.4001 .36197 m .40308 .34383 L .37419 .35022 L p F P
0 g
s
.677 .778 .926 r
.49763 .31073 m .48573 .31579 L .50572 .32925 L p F P
0 g
s
.677 .778 .926 r
.50572 .32925 m .51166 .32676 L .49763 .31073 L p F P
0 g
s
.62 .724 .921 r
.57449 .32185 m .56437 .3153 L .54486 .32902 L p F P
0 g
s
.624 .736 .927 r
.53885 .32659 m .54486 .32902 L .56437 .3153 L p F P
0 g
s
.499 .606 .89 r
.64742 .34235 m .65091 .36046 L .68018 .37066 L p F P
0 g
s
.545 .64 .895 r
.65091 .36046 m .64742 .34235 L .61766 .33904 L p F P
0 g
s
.4 .471 .818 r
.73418 .39836 m .7289 .42756 L .75203 .44788 L p F P
0 g
s
.447 .518 .838 r
.7289 .42756 m .73418 .39836 L .70803 .38332 L p F P
0 g
s
.829 .484 .404 r
.33143 .79905 m .38267 .81778 L .37901 .79568 L p F P
0 g
s
.829 .484 .404 r
.37901 .79568 m .32638 .77616 L .33143 .79905 L p F P
0 g
s
.665 .774 .931 r
.51091 .30755 m .49763 .31073 L .51166 .32676 L p F P
0 g
s
.665 .774 .931 r
.51166 .32676 m .51826 .32519 L .51091 .30755 L p F P
0 g
s
.624 .736 .927 r
.56437 .3153 m .55233 .3104 L .53885 .32659 L p F P
0 g
s
.631 .747 .931 r
.5322 .32511 m .53885 .32659 L .55233 .3104 L p F P
0 g
s
.535 .249 .427 r
.61693 .8296 m .67278 .81647 L .67657 .7943 L p F P
0 g
s
.441 .167 .4 r
.72867 .77428 m .67657 .7943 L .67278 .81647 L p F P
0 g
s
.474 .23 .464 r
.67657 .7943 m .72867 .77428 L .7315 .7497 L p F P
0 g
s
.652 .767 .933 r
.52492 .30641 m .51091 .30755 L .51826 .32519 L p F P
0 g
s
.652 .767 .933 r
.51826 .32519 m .52522 .32463 L .52492 .30641 L p F P
0 g
s
.947 .802 .667 r
.23278 .54763 m .25641 .58412 L .26778 .55699 L p F P
0 g
s
.947 .802 .667 r
.26778 .55699 m .24541 .52151 L .23278 .54763 L p F P
0 g
s
.631 .747 .931 r
.55233 .3104 m .53896 .30738 L .5322 .32511 L p F P
0 g
s
.641 .758 .933 r
.52522 .32463 m .5322 .32511 L .53896 .30738 L p F P
0 g
s
.641 .758 .933 r
.53896 .30738 m .52492 .30641 L .52522 .32463 L p F P
0 g
s
.718 .815 .925 r
.45096 .31507 m .43987 .32699 L .46828 .33039 L p F P
0 g
s
.718 .815 .925 r
.46828 .33039 m .47579 .32245 L .45096 .31507 L p F P
0 g
s
.573 .698 .926 r
.57449 .32185 m .58222 .32969 L .61038 .32595 L p F P
0 g
s
.577 .682 .912 r
.61766 .33904 m .61038 .32595 L .58222 .32969 L p F P
0 g
s
.764 .397 .36 r
.38802 .83779 m .44208 .84977 L .43887 .8304 L p F P
0 g
s
.764 .397 .36 r
.43887 .8304 m .38267 .81778 L .38802 .83779 L p F P
0 g
s
.757 .839 .914 r
.41197 .3264 m .40308 .34383 L .43296 .34016 L p F P
0 g
s
.757 .839 .914 r
.43296 .34016 m .43987 .32699 L .41197 .3264 L p F P
0 g
s
.938 .685 .528 r
.23984 .66673 m .2768 .69902 L .2789 .67183 L p F P
0 g
s
.938 .685 .528 r
.2789 .67183 m .24231 .63926 L .23984 .66673 L p F P
0 g
s
.304 .28 .667 r
.80691 .51844 m .78551 .55421 L .79699 .58126 L p F P
0 g
s
.353 .342 .707 r
.78551 .55421 m .80691 .51844 L .79126 .49351 L p F P
0 g
s
.585 .256 .378 r
.55678 .85544 m .61352 .84901 L .61693 .8296 L p F P
0 g
s
.505 .185 .358 r
.67278 .81647 m .61693 .8296 L .61352 .84901 L p F P
0 g
s
.528 .655 .916 r
.61038 .32595 m .61766 .33904 L .64742 .34235 L p F P
0 g
s
.825 .871 .879 r
.34658 .35931 m .34301 .38548 L .37085 .37251 L p F P
0 g
s
.825 .871 .879 r
.37085 .37251 m .37419 .35022 L .34658 .35931 L p F P
0 g
s
.908 .871 .79 r
.27095 .43805 m .27923 .47271 L .29998 .45046 L p F P
0 g
s
.908 .871 .79 r
.29998 .45046 m .29278 .41837 L .27095 .43805 L p F P
0 g
s
.888 .568 .436 r
.28088 .75073 m .32638 .77616 L .32363 .75164 L p F P
0 g
s
.888 .568 .436 r
.32363 .75164 m .27744 .72542 L .28088 .75073 L p F P
0 g
s
.446 .565 .882 r
.67621 .3484 m .68018 .37066 L .70803 .38332 L p F P
0 g
s
.499 .606 .89 r
.68018 .37066 m .67621 .3484 L .64742 .34235 L p F P
0 g
s
.303 .167 .525 r
.81122 .63635 m .77552 .66935 L .77764 .69656 L p F P
0 g
s
.349 .235 .58 r
.77552 .66935 m .81122 .63635 L .80561 .60873 L p F P
0 g
s
.358 .134 .432 r
.77698 .723 m .7315 .7497 L .72867 .77428 L p F P
0 g
s
.398 .203 .496 r
.7315 .7497 m .77698 .723 L .77764 .69656 L p F P
0 g
s
.346 .417 .792 r
.75833 .41567 m .75203 .44788 L .77289 .46993 L p F P
0 g
s
.4 .471 .818 r
.75203 .44788 m .75833 .41567 L .73418 .39836 L p F P
0 g
s
.699 .818 .939 r
.46576 .30502 m .45096 .31507 L .47579 .32245 L p F P
0 g
s
.699 .818 .939 r
.47579 .32245 m .48573 .31579 L .46576 .30502 L p F P
0 g
s
.573 .698 .926 r
.61038 .32595 m .59895 .31416 L .57449 .32185 L p F P
0 g
s
.573 .716 .94 r
.56437 .3153 m .57449 .32185 L .59895 .31416 L p F P
0 g
s
.965 .792 .618 r
.22328 .57458 m .24787 .61163 L .25641 .58412 L p F P
0 g
s
.965 .792 .618 r
.25641 .58412 m .23278 .54763 L .22328 .57458 L p F P
0 g
s
.782 .873 .914 r
.38486 .3287 m .37419 .35022 L .40308 .34383 L p F P
0 g
s
.782 .873 .914 r
.40308 .34383 m .41197 .3264 L .38486 .3287 L p F P
0 g
s
.854 .896 .865 r
.32056 .37107 m .3169 .40081 L .34301 .38548 L p F P
0 g
s
.854 .896 .865 r
.34301 .38548 m .34658 .35931 L .32056 .37107 L p F P
0 g
s
.934 .879 .757 r
.25167 .45967 m .26096 .49646 L .27923 .47271 L p F P
0 g
s
.934 .879 .757 r
.27923 .47271 m .27095 .43805 L .25167 .45967 L p F P
0 g
s
.47 .622 .917 r
.63804 .32502 m .64742 .34235 L .67621 .3484 L p F P
0 g
s
.528 .655 .916 r
.64742 .34235 m .63804 .32502 L .61038 .32595 L p F P
0 g
s
.737 .853 .935 r
.42647 .31056 m .41197 .3264 L .43987 .32699 L p F P
0 g
s
.737 .853 .935 r
.43987 .32699 m .45096 .31507 L .42647 .31056 L p F P
0 g
s
.677 .816 .95 r
.48357 .29738 m .46576 .30502 L .48573 .31579 L p F P
0 g
s
.677 .816 .95 r
.48573 .31579 m .49763 .31073 L .48357 .29738 L p F P
0 g
s
.385 .517 .868 r
.70373 .35717 m .70803 .38332 L .73418 .39836 L p F P
0 g
s
.446 .565 .882 r
.70803 .38332 m .70373 .35717 L .67621 .3484 L p F P
0 g
s
.247 .209 .617 r
.8196 .54447 m .79699 .58126 L .80561 .60873 L p F P
0 g
s
.304 .28 .667 r
.79699 .58126 m .8196 .54447 L .80691 .51844 L p F P
0 g
s
.573 .716 .94 r
.59895 .31416 m .58387 .30429 L .56437 .3153 L p F P
0 g
s
.578 .737 .951 r
.55233 .3104 m .56437 .3153 L .58387 .30429 L p F P
0 g
s
.516 .676 .937 r
.59895 .31416 m .61038 .32595 L .63804 .32502 L p F P
0 g
s
.284 .353 .758 r
.7802 .43512 m .77289 .46993 L .79126 .49351 L p F P
0 g
s
.346 .417 .792 r
.77289 .46993 m .7802 .43512 L .75833 .41567 L p F P
0 g
s
.687 .295 .297 r
.44631 .86666 m .50032 .87222 L .49898 .8557 L p F P
0 g
s
.687 .295 .297 r
.49898 .8557 m .44208 .84977 L .44631 .86666 L p F P
0 g
s
.626 .247 .305 r
.55678 .85544 m .49898 .8557 L .50032 .87222 L p F P
0 g
s
.626 .247 .305 r
.50032 .87222 m .55519 .87198 L .55678 .85544 L p F P
0 g
s
.554 .185 .296 r
.61352 .84901 m .55678 .85544 L .55519 .87198 L p F P
0 g
s
.817 .431 .323 r
.33878 .82003 m .38802 .83779 L .38267 .81778 L p F P
0 g
s
.817 .431 .323 r
.38267 .81778 m .33143 .79905 L .33878 .82003 L p F P
0 g
s
.943 .654 .461 r
.24059 .69376 m .27744 .72542 L .2768 .69902 L p F P
0 g
s
.943 .654 .461 r
.2768 .69902 m .23984 .66673 L .24059 .69376 L p F P
0 g
s
.653 .808 .958 r
.50353 .29256 m .48357 .29738 L .49763 .31073 L p F P
0 g
s
.653 .808 .958 r
.49763 .31073 m .51091 .30755 L .50353 .29256 L p F P
0 g
s
.505 .185 .358 r
.61352 .84901 m .66724 .83654 L .67278 .81647 L p F P
0 g
s
.397 .087 .319 r
.7235 .79725 m .67278 .81647 L .66724 .83654 L p F P
0 g
s
.441 .167 .4 r
.67278 .81647 m .7235 .79725 L .72867 .77428 L p F P
0 g
s
.578 .737 .951 r
.58387 .30429 m .56584 .29687 L .55233 .3104 L p F P
0 g
s
.59 .758 .958 r
.53896 .30738 m .55233 .3104 L .56584 .29687 L p F P
0 g
s
.248 .086 .456 r
.8137 .66385 m .77764 .69656 L .77698 .723 L p F P
0 g
s
.303 .167 .525 r
.77764 .69656 m .8137 .66385 L .81122 .63635 L p F P
0 g
s
.882 .521 .357 r
.28719 .77466 m .33143 .79905 L .32638 .77616 L p F P
0 g
s
.882 .521 .357 r
.32638 .77616 m .28088 .75073 L .28719 .77466 L p F P
0 g
s
.629 .795 .962 r
.52461 .29083 m .50353 .29256 L .51091 .30755 L p F P
0 g
s
.629 .795 .962 r
.51091 .30755 m .52492 .30641 L .52461 .29083 L p F P
0 g
s
.59 .758 .958 r
.56584 .29687 m .54575 .2923 L .53896 .30738 L p F P
0 g
s
.607 .778 .962 r
.52492 .30641 m .53896 .30738 L .54575 .2923 L p F P
0 g
s
.883 .918 .844 r
.29644 .38545 m .29278 .41837 L .3169 .40081 L p F P
0 g
s
.883 .918 .844 r
.3169 .40081 m .32056 .37107 L .29644 .38545 L p F P
0 g
s
.607 .778 .962 r
.54575 .2923 m .52461 .29083 L .52492 .30641 L p F P
0 g
s
.306 .049 .351 r
.77346 .74838 m .72867 .77428 L .7235 .79725 L p F P
0 g
s
.358 .134 .432 r
.72867 .77428 m .77346 .74838 L .77698 .723 L p F P
0 g
s
.743 .332 .271 r
.39505 .85543 m .44631 .86666 L .44208 .84977 L p F P
0 g
s
.743 .332 .271 r
.44208 .84977 m .38802 .83779 L .39505 .85543 L p F P
0 g
s
.808 .908 .909 r
.35886 .33393 m .34658 .35931 L .37419 .35022 L p F P
0 g
s
.808 .908 .909 r
.37419 .35022 m .38486 .3287 L .35886 .33393 L p F P
0 g
s
.959 .883 .715 r
.23522 .48307 m .24541 .52151 L .26096 .49646 L p F P
0 g
s
.959 .883 .715 r
.26096 .49646 m .25167 .45967 L .23522 .48307 L p F P
0 g
s
.979 .774 .558 r
.21708 .60209 m .24231 .63926 L .24787 .61163 L p F P
0 g
s
.979 .774 .558 r
.24787 .61163 m .22328 .57458 L .21708 .60209 L p F P
0 g
s
.554 .185 .296 r
.55519 .87198 m .60903 .86594 L .61352 .84901 L p F P
0 g
s
.463 .102 .267 r
.66724 .83654 m .61352 .84901 L .60903 .86594 L p F P
0 g
s
.708 .86 .954 r
.44599 .29716 m .42647 .31056 L .45096 .31507 L p F P
0 g
s
.708 .86 .954 r
.45096 .31507 m .46576 .30502 L .44599 .29716 L p F P
0 g
s
.313 .458 .846 r
.72967 .36863 m .73418 .39836 L .75833 .41567 L p F P
0 g
s
.385 .517 .868 r
.73418 .39836 m .72967 .36863 L .70373 .35717 L p F P
0 g
s
.516 .676 .937 r
.63804 .32502 m .62309 .30936 L .59895 .31416 L p F P
0 g
s
.511 .701 .956 r
.58387 .30429 m .59895 .31416 L .62309 .30936 L p F P
0 g
s
.399 .578 .912 r
.66492 .32699 m .67621 .3484 L .70373 .35717 L p F P
0 g
s
.47 .622 .917 r
.67621 .3484 m .66492 .32699 L .63804 .32502 L p F P
0 g
s
.211 .278 .715 r
.79951 .45656 m .79126 .49351 L .80691 .51844 L p F P
0 g
s
.284 .353 .758 r
.79126 .49351 m .79951 .45656 L .7802 .43512 L p F P
0 g
s
.179 .124 .554 r
.82915 .57136 m .80561 .60873 L .81122 .63635 L p F P
0 g
s
.247 .209 .617 r
.80561 .60873 m .82915 .57136 L .8196 .54447 L p F P
0 g
s
.754 .894 .941 r
.40259 .30907 m .38486 .3287 L .41197 .3264 L p F P
0 g
s
.754 .894 .941 r
.41197 .3264 m .42647 .31056 L .40259 .30907 L p F P
0 g
s
.445 .644 .943 r
.62309 .30936 m .63804 .32502 L .66492 .32699 L p F P
0 g
s
.941 .61 .376 r
.24463 .72003 m .28088 .75073 L .27744 .72542 L p F P
0 g
s
.941 .61 .376 r
.27744 .72542 m .24059 .69376 L .24463 .72003 L p F P
0 g
s
.671 .857 .97 r
.46963 .28693 m .44599 .29716 L .46576 .30502 L p F P
0 g
s
.671 .857 .97 r
.46576 .30502 m .48357 .29738 L .46963 .28693 L p F P
0 g
s
.911 .938 .813 r
.27453 .40237 m .27095 .43805 L .29278 .41837 L p F P
0 g
s
.911 .938 .813 r
.29278 .41837 m .29644 .38545 L .27453 .40237 L p F P
0 g
s
.511 .701 .956 r
.62309 .30936 m .60318 .29619 L .58387 .30429 L p F P
0 g
s
.514 .731 .972 r
.56584 .29687 m .58387 .30429 L .60318 .29619 L p F P
0 g
s
.98 .88 .66 r
.22183 .50802 m .23278 .54763 L .24541 .52151 L p F P
0 g
s
.98 .88 .66 r
.24541 .52151 m .23522 .48307 L .22183 .50802 L p F P
0 g
s
.179 0 .368 r
.81293 .69093 m .77698 .723 L .77346 .74838 L p F P
0 g
s
.248 .086 .456 r
.77698 .723 m .81293 .69093 L .8137 .66385 L p F P
0 g
s
.833 .941 .896 r
.33425 .34213 m .32056 .37107 L .34658 .35931 L p F P
0 g
s
.833 .941 .896 r
.34658 .35931 m .35886 .33393 L .33425 .34213 L p F P
0 g
s
.226 .386 .814 r
.75372 .38275 m .75833 .41567 L .7802 .43512 L p F P
0 g
s
.313 .458 .846 r
.75833 .41567 m .75372 .38275 L .72967 .36863 L p F P
0 g
s
.792 .358 .217 r
.34846 .83879 m .39505 .85543 L .38802 .83779 L p F P
0 g
s
.792 .358 .217 r
.38802 .83779 m .33878 .82003 L .34846 .83879 L p F P
0 g
s
.987 .746 .48 r
.21434 .62987 m .23984 .66673 L .24231 .63926 L p F P
0 g
s
.987 .746 .48 r
.24231 .63926 m .21708 .60209 L .21434 .62987 L p F P
0 g
s
.311 .521 .898 r
.69072 .33192 m .70373 .35717 L .72967 .36863 L p F P
0 g
s
.399 .578 .912 r
.70373 .35717 m .69072 .33192 L .66492 .32699 L p F P
0 g
s
.125 .187 .657 r
.81599 .47981 m .80691 .51844 L .8196 .54447 L p F P
0 g
s
.211 .278 .715 r
.80691 .51844 m .81599 .47981 L .79951 .45656 L p F P
0 g
s
.651 .209 .188 r
.45156 .88078 m .50197 .88592 L .50032 .87222 L p F P
0 g
s
.651 .209 .188 r
.50032 .87222 m .44631 .86666 L .45156 .88078 L p F P
0 g
s
.587 .16 .199 r
.55519 .87198 m .50032 .87222 L .50197 .88592 L p F P
0 g
s
.587 .16 .199 r
.50197 .88592 m .55321 .8857 L .55519 .87198 L p F P
0 g
s
.507 .091 .186 r
.60903 .86594 m .55519 .87198 L .55321 .8857 L p F P
0 g
s
.463 .102 .267 r
.60903 .86594 m .65996 .85426 L .66724 .83654 L p F P
0 g
s
.337 0 .211 r
.71597 .81832 m .66724 .83654 L .65996 .85426 L p F P
0 g
s
.397 .087 .319 r
.66724 .83654 m .71597 .81832 L .7235 .79725 L p F P
0 g
s
.865 .457 .254 r
.29637 .79691 m .33878 .82003 L .33143 .79905 L p F P
0 g
s
.865 .457 .254 r
.33143 .79905 m .28719 .77466 L .29637 .79691 L p F P
0 g
s
.63 .844 .982 r
.49619 .28047 m .46963 .28693 L .48357 .29738 L p F P
0 g
s
.63 .844 .982 r
.48357 .29738 m .50353 .29256 L .49619 .28047 L p F P
0 g
s
.514 .731 .972 r
.60318 .29619 m .57925 .28625 L .56584 .29687 L p F P
0 g
s
.529 .762 .983 r
.54575 .2923 m .56584 .29687 L .57925 .28625 L p F P
0 g
s
.098 .022 .473 r
.83538 .59885 m .81122 .63635 L .8137 .66385 L p F P
0 g
s
.179 .124 .554 r
.81122 .63635 m .83538 .59885 L .82915 .57136 L p F P
0 g
s
.238 0 .246 r
.76705 .77241 m .7235 .79725 L .71597 .81832 L p F P
0 g
s
.306 .049 .351 r
.7235 .79725 m .76705 .77241 L .77346 .74838 L p F P
0 g
s
.711 .903 .964 r
.42665 .29239 m .40259 .30907 L .42647 .31056 L p F P
0 g
s
.711 .903 .964 r
.42647 .31056 m .44599 .29716 L .42665 .29239 L p F P
0 g
s
.769 .935 .938 r
.37958 .31069 m .35886 .33393 L .38486 .3287 L p F P
0 g
s
.769 .935 .938 r
.38486 .3287 m .40259 .30907 L .37958 .31069 L p F P
0 g
s
.445 .644 .943 r
.66492 .32699 m .64662 .30756 L .62309 .30936 L p F P
0 g
s
.427 .674 .966 r
.60318 .29619 m .62309 .30936 L .64662 .30756 L p F P
0 g
s
.589 .822 .988 r
.52431 .27816 m .49619 .28047 L .50353 .29256 L p F P
0 g
s
.589 .822 .988 r
.50353 .29256 m .52461 .29083 L .52431 .27816 L p F P
0 g
s
.352 .599 .94 r
.64662 .30756 m .66492 .32699 L .69072 .33192 L p F P
0 g
s
.529 .762 .983 r
.57925 .28625 m .55249 .28012 L .54575 .2923 L p F P
0 g
s
.554 .794 .988 r
.52461 .29083 m .54575 .2923 L .55249 .28012 L p F P
0 g
s
.705 .242 .15 r
.40377 .87041 m .45156 .88078 L .44631 .86666 L p F P
0 g
s
.705 .242 .15 r
.44631 .86666 m .39505 .85543 L .40377 .87041 L p F P
0 g
s
.554 .794 .988 r
.55249 .28012 m .52431 .27816 L .52461 .29083 L p F P
0 g
s
.935 .952 .768 r
.25512 .42169 m .25167 .45967 L .27095 .43805 L p F P
0 g
s
.935 .952 .768 r
.27095 .43805 m .27453 .40237 L .25512 .42169 L p F P
0 g
s
.507 .091 .186 r
.55321 .8857 m .60347 .88012 L .60903 .86594 L p F P
0 g
s
.402 0 .145 r
.65996 .85426 m .60903 .86594 L .60347 .88012 L p F P
0 g
s
.995 .866 .586 r
.21174 .5343 m .22328 .57458 L .23278 .54763 L p F P
0 g
s
.995 .866 .586 r
.23278 .54763 m .22183 .50802 L .21174 .5343 L p F P
0 g
s
.122 .295 .767 r
.77558 .39943 m .7802 .43512 L .79951 .45656 L p F P
0 g
s
.226 .386 .814 r
.7802 .43512 m .77558 .39943 L .75372 .38275 L p F P
0 g
s
.854 .971 .869 r
.31136 .3533 m .29644 .38545 L .32056 .37107 L p F P
0 g
s
.854 .971 .869 r
.32056 .37107 m .33425 .34213 L .31136 .3533 L p F P
0 g
s
.926 .548 .267 r
.25201 .74524 m .28719 .77466 L .28088 .75073 L p F P
0 g
s
.926 .548 .267 r
.28088 .75073 m .24463 .72003 L .25201 .74524 L p F P
0 g
s
.022 .077 .581 r
.8294 .50466 m .8196 .54447 L .82915 .57136 L p F P
0 g
s
.125 .187 .657 r
.8196 .54447 m .8294 .50466 L .81599 .47981 L p F P
0 g
s
.201 .446 .87 r
.71513 .33983 m .72967 .36863 L .75372 .38275 L p F P
0 g
s
.311 .521 .898 r
.72967 .36863 m .71513 .33983 L .69072 .33192 L p F P
0 g
s
.984 .702 .38 r
.21517 .65762 m .24059 .69376 L .23984 .66673 L p F P
0 g
s
.984 .702 .38 r
.23984 .66673 m .21434 .62987 L .21517 .65762 L p F P
0 g
s
.093 0 .255 r
.80883 .71729 m .77346 .74838 L .76705 .77241 L p F P
0 g
s
.179 0 .368 r
.77346 .74838 m .80883 .71729 L .81293 .69093 L p F P
0 g
s
.653 .896 .982 r
.45594 .27963 m .42665 .29239 L .44599 .29716 L p F P
0 g
s
.653 .896 .982 r
.44599 .29716 m .46963 .28693 L .45594 .27963 L p F P
0 g
s
.427 .674 .966 r
.64662 .30756 m .62207 .29118 L .60318 .29619 L p F P
0 g
s
.422 .711 .983 r
.57925 .28625 m .60318 .29619 L .62207 .29118 L p F P
0 g
s
0 0 .37 r
.83813 .62666 m .8137 .66385 L .81293 .69093 L p F P
0 g
s
.098 .022 .473 r
.8137 .66385 m .83813 .62666 L .83538 .59885 L p F P
0 g
s
.777 .971 .919 r
.35774 .31553 m .33425 .34213 L .35886 .33393 L p F P
0 g
s
.777 .971 .919 r
.35886 .33393 m .37958 .31069 L .35774 .31553 L p F P
0 g
s
.827 .366 .119 r
.30842 .81718 m .34846 .83879 L .33878 .82003 L p F P
0 g
s
.827 .366 .119 r
.33878 .82003 m .29637 .79691 L .30842 .81718 L p F P
0 g
s
.951 .955 .702 r
.23851 .44328 m .23522 .48307 L .25167 .45967 L p F P
0 g
s
.951 .955 .702 r
.25167 .45967 m .25512 .42169 L .23851 .44328 L p F P
0 g
s
.745 .256 .075 r
.36042 .85507 m .40377 .87041 L .39505 .85543 L p F P
0 g
s
.745 .256 .075 r
.39505 .85543 m .34846 .83879 L .36042 .85507 L p F P
0 g
s
.703 .943 .96 r
.40796 .29088 m .37958 .31069 L .40259 .30907 L p F P
0 g
s
.703 .943 .96 r
.40259 .30907 m .42665 .29239 L .40796 .29088 L p F P
0 g
s
.229 .531 .921 r
.6693 .30891 m .69072 .33192 L .71513 .33983 L p F P
0 g
s
.352 .599 .94 r
.69072 .33192 m .6693 .30891 L .64662 .30756 L p F P
0 g
s
.402 0 .145 r
.60347 .88012 m .65094 .86933 L .65996 .85426 L p F P
0 g
s
.253 0 .066 r
.70607 .83719 m .65996 .85426 L .65094 .86933 L p F P
0 g
s
.337 0 .211 r
.65996 .85426 m .70607 .83719 L .71597 .81832 L p F P
0 g
s
.149 0 .107 r
.75771 .79478 m .71597 .81832 L .70607 .83719 L p F P
0 g
s
.238 0 .246 r
.71597 .81832 m .75771 .79478 L .76705 .77241 L p F P
0 g
s
.31 .627 .961 r
.62207 .29118 m .64662 .30756 L .6693 .30891 L p F P
0 g
s
0 .182 .698 r
.79494 .41856 m .79951 .45656 L .81599 .47981 L p F P
0 g
s
.122 .295 .767 r
.79951 .45656 m .79494 .41856 L .77558 .39943 L p F P
0 g
s
.997 .836 .49 r
.20515 .56163 m .21708 .60209 L .22328 .57458 L p F P
0 g
s
.997 .836 .49 r
.22328 .57458 m .21174 .5343 L .20515 .56163 L p F P
0 g
s
.586 .874 .994 r
.48898 .27155 m .45594 .27963 L .46963 .28693 L p F P
0 g
s
.586 .874 .994 r
.46963 .28693 m .49619 .28047 L .48898 .27155 L p F P
0 g
s
.589 .09 .036 r
.45781 .89188 m .50394 .89654 L .50197 .88592 L p F P
0 g
s
.589 .09 .036 r
.50197 .88592 m .45156 .88078 L .45781 .89188 L p F P
0 g
s
.522 .04 .052 r
.55321 .8857 m .50197 .88592 L .50394 .89654 L p F P
0 g
s
.522 .04 .052 r
.50394 .89654 m .55086 .89634 L .55321 .8857 L p F P
0 g
s
.433 0 .033 r
.60347 .88012 m .55321 .8857 L .55086 .89634 L p F P
0 g
s
.422 .711 .983 r
.62207 .29118 m .5924 .27878 L .57925 .28625 L p F P
0 g
s
.435 .752 .994 r
.55249 .28012 m .57925 .28625 L .5924 .27878 L p F P
0 g
s
.867 .992 .821 r
.29049 .3674 m .27453 .40237 L .29644 .38545 L p F P
0 g
s
.867 .992 .821 r
.29644 .38545 m .31136 .3533 L .29049 .3674 L p F P
0 g
s
0 0 .479 r
.83951 .53088 m .82915 .57136 L .83538 .59885 L p F P
0 g
s
.022 .077 .581 r
.82915 .57136 m .83951 .53088 L .8294 .50466 L p F P
0 g
s
.063 .344 .82 r
.73785 .35074 m .75372 .38275 L .77558 .39943 L p F P
0 g
s
.201 .446 .87 r
.75372 .38275 m .73785 .35074 L .71513 .33983 L p F P
0 g
s
.888 .459 .125 r
.26275 .76908 m .29637 .79691 L .28719 .77466 L p F P
0 g
s
.888 .459 .125 r
.28719 .77466 m .25201 .74524 L .26275 .76908 L p F P
0 g
s
.522 .839 .999 r
.52401 .26865 m .48898 .27155 L .49619 .28047 L p F P
0 g
s
.522 .839 .999 r
.49619 .28047 m .52431 .27816 L .52401 .26865 L p F P
0 g
s
.961 .634 .252 r
.21967 .68501 m .24463 .72003 L .24059 .69376 L p F P
0 g
s
.961 .634 .252 r
.24059 .69376 m .21517 .65762 L .21967 .68501 L p F P
0 g
s
.435 .752 .994 r
.5924 .27878 m .55912 .27111 L .55249 .28012 L p F P
0 g
s
.469 .796 .999 r
.52431 .27816 m .55249 .28012 L .55912 .27111 L p F P
0 g
s
.637 .115 0 r
.41414 .88247 m .45781 .89188 L .45156 .88078 L p F P
0 g
s
.637 .115 0 r
.45156 .88078 m .40377 .87041 L .41414 .88247 L p F P
0 g
s
.433 0 .033 r
.55086 .89634 m .59685 .89128 L .60347 .88012 L p F P
0 g
s
.31 0 0 r
.65094 .86933 m .60347 .88012 L .59685 .89128 L p F P
0 g
s
.469 .796 .999 r
.55912 .27111 m .52401 .26865 L .52431 .27816 L p F P
0 g
s
0 0 .109 r
.80135 .74262 m .76705 .77241 L .75771 .79478 L p F P
0 g
s
.093 0 .255 r
.76705 .77241 m .80135 .74262 L .80883 .71729 L p F P
0 g
s
0 0 .236 r
.83727 .65447 m .81293 .69093 L .80883 .71729 L p F P
0 g
s
0 0 .37 r
.81293 .69093 m .83727 .65447 L .83813 .62666 L p F P
0 g
s
.952 .938 .608 r
.22496 .46694 m .22183 .50802 L .23522 .48307 L p F P
0 g
s
.952 .938 .608 r
.23522 .48307 m .23851 .44328 L .22496 .46694 L p F P
0 g
s
.611 .925 .971 r
.44269 .27568 m .40796 .29088 L .42665 .29239 L p F P
0 g
s
.611 .925 .971 r
.42665 .29239 m .45594 .27963 L .44269 .27568 L p F P
0 g
s
.768 .994 .873 r
.33734 .32363 m .31136 .3533 L .33425 .34213 L p F P
0 g
s
.768 .994 .873 r
.33425 .34213 m .35774 .31553 L .33734 .32363 L p F P
0 g
s
.31 .627 .961 r
.6693 .30891 m .64033 .28944 L .62207 .29118 L p F P
0 g
s
.285 .664 .971 r
.5924 .27878 m .62207 .29118 L .64033 .28944 L p F P
0 g
s
0 .04 .6 r
.81151 .43999 m .81599 .47981 L .8294 .50466 L p F P
0 g
s
0 .182 .698 r
.81599 .47981 m .81151 .43999 L .79494 .41856 L p F P
0 g
s
.977 .78 .362 r
.20223 .58973 m .21434 .62987 L .21708 .60209 L p F P
0 g
s
.977 .78 .362 r
.21708 .60209 m .20515 .56163 L .20223 .58973 L p F P
0 g
s
.067 .43 .871 r
.69084 .31348 m .71513 .33983 L .73785 .35074 L p F P
0 g
s
.229 .531 .921 r
.71513 .33983 m .69084 .31348 L .6693 .30891 L p F P
0 g
s
.861 .992 .741 r
.27194 .38436 m .25512 .42169 L .27453 .40237 L p F P
0 g
s
.861 .992 .741 r
.27453 .40237 m .29049 .3674 L .27194 .38436 L p F P
0 g
s
.673 .967 .925 r
.39016 .29277 m .35774 .31553 L .37958 .31069 L p F P
0 g
s
.673 .967 .925 r
.37958 .31069 m .40796 .29088 L .39016 .29277 L p F P
0 g
s
.755 .239 0 r
.32331 .83517 m .36042 .85507 L .34846 .83879 L p F P
0 g
s
.755 .239 0 r
.34846 .83879 m .30842 .81718 L .32331 .83517 L p F P
0 g
s
0 0 .345 r
.84611 .5582 m .83538 .59885 L .83813 .62666 L p F P
0 g
s
0 0 .479 r
.83538 .59885 m .84611 .5582 L .83951 .53088 L p F P
0 g
s
.147 .545 .924 r
.64033 .28944 m .6693 .30891 L .69084 .31348 L p F P
0 g
s
.253 0 .066 r
.65094 .86933 m .69383 .85359 L .70607 .83719 L p F P
0 g
s
.029 0 0 r
.74546 .81519 m .70607 .83719 L .69383 .85359 L p F P
0 g
s
.149 0 .107 r
.70607 .83719 m .74546 .81519 L .75771 .79478 L p F P
0 g
s
0 .209 .735 r
.75856 .3646 m .77558 .39943 L .79494 .41856 L p F P
0 g
s
.063 .344 .82 r
.77558 .39943 m .75856 .3646 L .73785 .35074 L p F P
0 g
s
.658 .111 0 r
.37464 .86857 m .41414 .88247 L .40377 .87041 L p F P
0 g
s
.658 .111 0 r
.40377 .87041 m .36042 .85507 L .37464 .86857 L p F P
0 g
s
.31 0 0 r
.59685 .89128 m .64022 .88149 L .65094 .86933 L p F P
0 g
s
.134 0 0 r
.69383 .85359 m .65094 .86933 L .64022 .88149 L p F P
0 g
s
.906 .533 .088 r
.22789 .71173 m .25201 .74524 L .24463 .72003 L p F P
0 g
s
.906 .533 .088 r
.24463 .72003 m .21967 .68501 L .22789 .71173 L p F P
0 g
s
.504 .882 .972 r
.48198 .26603 m .44269 .27568 L .45594 .27963 L p F P
0 g
s
.504 .882 .972 r
.45594 .27963 m .48898 .27155 L .48198 .26603 L p F P
0 g
s
.812 .333 0 r
.27682 .7912 m .30842 .81718 L .29637 .79691 L p F P
0 g
s
.812 .333 0 r
.29637 .79691 m .26275 .76908 L .27682 .7912 L p F P
0 g
s
.285 .664 .971 r
.64033 .28944 m .60514 .27466 L .5924 .27878 L p F P
0 g
s
.289 .709 .971 r
.55912 .27111 m .5924 .27878 L .60514 .27466 L p F P
0 g
s
0 0 .067 r
.83273 .68197 m .80883 .71729 L .80135 .74262 L p F P
0 g
s
0 0 .236 r
.80883 .71729 m .83273 .68197 L .83727 .65447 L p F P
0 g
s
.925 .89 .478 r
.21473 .49246 m .21174 .5343 L .22183 .50802 L p F P
0 g
s
.925 .89 .478 r
.22183 .50802 m .22496 .46694 L .21473 .49246 L p F P
0 g
s
.48 0 0 r
.46504 .89969 m .50623 .90383 L .50394 .89654 L p F P
0 g
s
.48 0 0 r
.50394 .89654 m .45781 .89188 L .46504 .89969 L p F P
0 g
s
.413 0 0 r
.55086 .89634 m .50394 .89654 L .50623 .90383 L p F P
0 g
s
.413 0 0 r
.50623 .90383 m .54814 .90365 L .55086 .89634 L p F P
0 g
s
.314 0 0 r
.59685 .89128 m .55086 .89634 L .54814 .90365 L p F P
0 g
s
0 0 0 r
.79048 .7666 m .75771 .79478 L .74546 .81519 L p F P
0 g
s
0 0 .109 r
.75771 .79478 m .79048 .7666 L .80135 .74262 L p F P
0 g
s
0 0 .462 r
.82503 .46355 m .8294 .50466 L .83951 .53088 L p F P
0 g
s
0 .04 .6 r
.8294 .50466 m .82503 .46355 L .81151 .43999 L p F P
0 g
s
.924 .689 .199 r
.20311 .61827 m .21517 .65762 L .21434 .62987 L p F P
0 g
s
.924 .689 .199 r
.21434 .62987 m .20223 .58973 L .20311 .61827 L p F P
0 g
s
.404 .824 .969 r
.52372 .26257 m .48198 .26603 L .48898 .27155 L p F P
0 g
s
.404 .824 .969 r
.48898 .27155 m .52401 .26865 L .52372 .26257 L p F P
0 g
s
.727 .984 .781 r
.31869 .33503 m .29049 .3674 L .31136 .3533 L p F P
0 g
s
.727 .984 .781 r
.31136 .3533 m .33734 .32363 L .31869 .33503 L p F P
0 g
s
.289 .709 .971 r
.60514 .27466 m .56555 .26551 L .55912 .27111 L p F P
0 g
s
.328 .763 .969 r
.52401 .26865 m .55912 .27111 L .56555 .26551 L p F P
0 g
s
.515 0 0 r
.42612 .89134 m .46504 .89969 L .45781 .89188 L p F P
0 g
s
.515 0 0 r
.45781 .89188 m .41414 .88247 L .42612 .89134 L p F P
0 g
s
.314 0 0 r
.54814 .90365 m .58919 .89916 L .59685 .89128 L p F P
0 g
s
.172 0 0 r
.64022 .88149 m .59685 .89128 L .58919 .89916 L p F P
0 g
s
.823 .956 .617 r
.25603 .40407 m .23851 .44328 L .25512 .42169 L p F P
0 g
s
.823 .956 .617 r
.25512 .42169 m .27194 .38436 L .25603 .40407 L p F P
0 g
s
0 0 .176 r
.84902 .58632 m .83813 .62666 L .83727 .65447 L p F P
0 g
s
0 0 .345 r
.83813 .62666 m .84902 .58632 L .84611 .5582 L p F P
0 g
s
.328 .763 .969 r
.56555 .26551 m .52372 .26257 L .52401 .26865 L p F P
0 g
s
0 .285 .773 r
.71096 .32135 m .73785 .35074 L .75856 .3646 L p F P
0 g
s
.067 .43 .871 r
.73785 .35074 m .71096 .32135 L .69084 .31348 L p F P
0 g
s
.524 .917 .907 r
.43003 .27526 m .39016 .29277 L .40796 .29088 L p F P
0 g
s
.524 .917 .907 r
.40796 .29088 m .44269 .27568 L .43003 .27526 L p F P
0 g
s
0 .037 .604 r
.77697 .38137 m .79494 .41856 L .81151 .43999 L p F P
0 g
s
0 .209 .735 r
.79494 .41856 m .77697 .38137 L .75856 .3646 L p F P
0 g
s
.147 .545 .924 r
.69084 .31348 m .65773 .29111 L .64033 .28944 L p F P
0 g
s
.088 .565 .904 r
.60514 .27466 m .64033 .28944 L .65773 .29111 L p F P
0 g
s
.601 .951 .835 r
.37348 .29818 m .33734 .32363 L .35774 .31553 L p F P
0 g
s
.601 .951 .835 r
.35774 .31553 m .39016 .29277 L .37348 .29818 L p F P
0 g
s
.626 .064 0 r
.34094 .85058 m .37464 .86857 L .36042 .85507 L p F P
0 g
s
.626 .064 0 r
.36042 .85507 m .32331 .83517 L .34094 .85058 L p F P
0 g
s
0 .41 .829 r
.65773 .29111 m .69084 .31348 L .71096 .32135 L p F P
0 g
s
.806 .391 0 r
.23983 .73741 m .26275 .76908 L .25201 .74524 L p F P
0 g
s
.806 .391 0 r
.25201 .74524 m .22789 .71173 L .23983 .73741 L p F P
0 g
s
.134 0 0 r
.64022 .88149 m .67929 .86723 L .69383 .85359 L p F P
0 g
s
0 0 0 r
.73033 .83334 m .69383 .85359 L .67929 .86723 L p F P
0 g
s
.029 0 0 r
.69383 .85359 m .73033 .83334 L .74546 .81519 L p F P
0 g
s
.858 .799 .308 r
.20804 .51957 m .20515 .56163 L .21174 .5343 L p F P
0 g
s
.858 .799 .308 r
.21174 .5343 m .21473 .49246 L .20804 .51957 L p F P
0 g
s
0 0 0 r
.82444 .70882 m .80135 .74262 L .79048 .7666 L p F P
0 g
s
0 0 .067 r
.80135 .74262 m .82444 .70882 L .83273 .68197 L p F P
0 g
s
.506 0 0 r
.39101 .87903 m .42612 .89134 L .41414 .88247 L p F P
0 g
s
.506 0 0 r
.41414 .88247 m .37464 .86857 L .39101 .87903 L p F P
0 g
s
.682 .164 0 r
.29416 .81131 m .32331 .83517 L .30842 .81718 L p F P
0 g
s
.682 .164 0 r
.30842 .81718 m .27682 .7912 L .29416 .81131 L p F P
0 g
s
0 0 .284 r
.83523 .489 m .83951 .53088 L .84611 .5582 L p F P
0 g
s
0 0 .462 r
.83951 .53088 m .83523 .489 L .82503 .46355 L p F P
0 g
s
.172 0 0 r
.58919 .89916 m .62784 .89047 L .64022 .88149 L p F P
0 g
s
0 0 0 r
.67929 .86723 m .64022 .88149 L .62784 .89047 L p F P
0 g
s
.825 .555 .004 r
.2079 .64692 m .21967 .68501 L .21517 .65762 L p F P
0 g
s
.825 .555 .004 r
.21517 .65762 m .20311 .61827 L .2079 .64692 L p F P
0 g
s
0 0 0 r
.77625 .78889 m .74546 .81519 L .73033 .83334 L p F P
0 g
s
0 0 0 r
.74546 .81519 m .77625 .78889 L .79048 .7666 L p F P
0 g
s
.359 .83 .873 r
.47529 .26414 m .43003 .27526 L .44269 .27568 L p F P
0 g
s
.359 .83 .873 r
.44269 .27568 m .48198 .26603 L .47529 .26414 L p F P
0 g
s
0 0 0 r
.84812 .61493 m .83727 .65447 L .83273 .68197 L p F P
0 g
s
0 0 .176 r
.83727 .65447 m .84812 .61493 L .84902 .58632 L p F P
0 g
s
.088 .565 .904 r
.65773 .29111 m .61731 .27409 L .60514 .27466 L p F P
0 g
s
.072 .599 .871 r
.56555 .26551 m .60514 .27466 L .61731 .27409 L p F P
0 g
s
.739 .866 .442 r
.24302 .42638 m .22496 .46694 L .23851 .44328 L p F P
0 g
s
.739 .866 .442 r
.23851 .44328 m .25603 .40407 L .24302 .42638 L p F P
0 g
s
.638 .915 .624 r
.30206 .34971 m .27194 .38436 L .29049 .3674 L p F P
0 g
s
.638 .915 .624 r
.29049 .3674 m .31869 .33503 L .30206 .34971 L p F P
0 g
s
.299 0 0 r
.4732 .90398 m .50881 .90755 L .50623 .90383 L p F P
0 g
s
.299 0 0 r
.50623 .90383 m .46504 .89969 L .4732 .90398 L p F P
0 g
s
.237 0 0 r
.54814 .90365 m .50623 .90383 L .50881 .90755 L p F P
0 g
s
.237 0 0 r
.50881 .90755 m .54506 .9074 L .54814 .90365 L p F P
0 g
s
.132 0 0 r
.58919 .89916 m .54814 .90365 L .54506 .9074 L p F P
0 g
s
0 .094 .609 r
.72936 .33254 m .75856 .3646 L .77697 .38137 L p F P
0 g
s
0 .285 .773 r
.75856 .3646 m .72936 .33254 L .71096 .32135 L p F P
0 g
s
0 0 .42 r
.79277 .40093 m .81151 .43999 L .82503 .46355 L p F P
0 g
s
0 .037 .604 r
.81151 .43999 m .79277 .40093 L .77697 .38137 L p F P
0 g
s
.743 .659 .104 r
.20507 .54798 m .20223 .58973 L .20515 .56163 L p F P
0 g
s
.743 .659 .104 r
.20515 .56163 m .20804 .51957 L .20507 .54798 L p F P
0 g
s
.214 .735 .848 r
.52344 .26014 m .47529 .26414 L .48198 .26603 L p F P
0 g
s
.214 .735 .848 r
.48198 .26603 m .52372 .26257 L .52344 .26014 L p F P
0 g
s
.316 0 0 r
.43962 .89679 m .4732 .90398 L .46504 .89969 L p F P
0 g
s
.316 0 0 r
.46504 .89969 m .42612 .89134 L .43962 .89679 L p F P
0 g
s
.072 .599 .871 r
.61731 .27409 m .5717 .26353 L .56555 .26551 L p F P
0 g
s
.114 .655 .847 r
.52372 .26257 m .56555 .26551 L .5717 .26353 L p F P
0 g
s
.651 .211 0 r
.25544 .76172 m .27682 .7912 L .26275 .76908 L p F P
0 g
s
.651 .211 0 r
.26275 .76908 m .23983 .73741 L .25544 .76172 L p F P
0 g
s
.132 0 0 r
.54506 .9074 m .58055 .90352 L .58919 .89916 L p F P
0 g
s
0 0 0 r
.62784 .89047 m .58919 .89916 L .58055 .90352 L p F P
0 g
s
.374 .833 .752 r
.41815 .27855 m .37348 .29818 L .39016 .29277 L p F P
0 g
s
.374 .833 .752 r
.39016 .29277 m .43003 .27526 L .41815 .27855 L p F P
0 g
s
.471 .861 .663 r
.35819 .30719 m .31869 .33503 L .33734 .32363 L p F P
0 g
s
.471 .861 .663 r
.33734 .32363 m .37348 .29818 L .35819 .30719 L p F P
0 g
s
0 .41 .829 r
.71096 .32135 m .67402 .29632 L .65773 .29111 L p F P
0 g
s
0 .395 .744 r
.61731 .27409 m .65773 .29111 L .67402 .29632 L p F P
0 g
s
.114 .655 .847 r
.5717 .26353 m .52344 .26014 L .52372 .26257 L p F P
0 g
s
0 0 .076 r
.8419 .51609 m .84611 .5582 L .84902 .58632 L p F P
0 g
s
0 0 .284 r
.84611 .5582 m .8419 .51609 L .83523 .489 L p F P
0 g
s
0 0 0 r
.81241 .73467 m .79048 .7666 L .77625 .78889 L p F P
0 g
s
0 0 0 r
.79048 .7666 m .81241 .73467 L .82444 .70882 L p F P
0 g
s
0 .216 .65 r
.67402 .29632 m .71096 .32135 L .72936 .33254 L p F P
0 g
s
.428 0 0 r
.36121 .86314 m .39101 .87903 L .37464 .86857 L p F P
0 g
s
.428 0 0 r
.37464 .86857 m .34094 .85058 L .36121 .86314 L p F P
0 g
s
.677 .383 0 r
.21664 .67532 m .22789 .71173 L .21967 .68501 L p F P
0 g
s
.677 .383 0 r
.21967 .68501 m .2079 .64692 L .21664 .67532 L p F P
0 g
s
0 0 0 r
.62784 .89047 m .66255 .87785 L .67929 .86723 L p F P
0 g
s
0 0 0 r
.71241 .84893 m .67929 .86723 L .66255 .87785 L p F P
0 g
s
0 0 0 r
.67929 .86723 m .71241 .84893 L .73033 .83334 L p F P
0 g
s
.491 0 0 r
.31465 .82907 m .34094 .85058 L .32331 .83517 L p F P
0 g
s
.491 0 0 r
.32331 .83517 m .29416 .81131 L .31465 .82907 L p F P
0 g
s
0 0 0 r
.83273 .68197 m .8433 .64369 L .84812 .61493 L p F P
0 g
s
.71 .744 .234 r
.8433 .64369 m .83273 .68197 L .82444 .70882 L p F P
0 g
s
0 0 0 r
.75871 .80919 m .73033 .83334 L .71241 .84893 L p F P
0 g
s
0 0 0 r
.73033 .83334 m .75871 .80919 L .77625 .78889 L p F P
0 g
s
0 0 0 r
.23318 .45108 m .21473 .49246 L .22496 .46694 L p F P
0 g
s
0 0 0 r
.22496 .46694 m .24302 .42638 L .23318 .45108 L p F P
0 g
s
.01 w
.21177 .65986 Mdot
.5 Mabswid
.279 0 0 r
.40944 .88621 m .43962 .89679 L .42612 .89134 L p F P
0 g
s
.279 0 0 r
.42612 .89134 m .39101 .87903 L .40944 .88621 L p F P
0 g
s
.01 w
.84094 .65248 Mdot
.5 Mabswid
0 0 0 r
.28776 .36759 m .25603 .40407 L .27194 .38436 L p F P
0 g
s
0 0 0 r
.27194 .38436 m .30206 .34971 L .28776 .36759 L p F P
0 g
s
0 0 0 r
.58055 .90352 m .61389 .89604 L .62784 .89047 L p F P
0 g
s
0 0 0 r
.66255 .87785 m .62784 .89047 L .61389 .89604 L p F P
0 g
s
0 0 .42 r
.82503 .46355 m .80568 .42313 L .79277 .40093 L p F P
0 g
s
.724 .363 0 r
.80568 .42313 m .82503 .46355 L .83523 .489 L p F P
0 g
s
.01 w
.21099 .65807 Mdot
.84178 .65002 Mdot
.5 Mabswid
0 .094 .609 r
.77697 .38137 m .74575 .34703 L .72936 .33254 L p F P
0 g
s
.606 .121 0 r
.74575 .34703 m .77697 .38137 L .79277 .40093 L p F P
0 g
s
.01 w
.25227 .75682 Mdot
.25133 .75539 Mdot
.25037 .75391 Mdot
.2494 .75237 Mdot
.2484 .75079 Mdot
.5 Mabswid
0 0 .109 r
.20597 .57736 m .20311 .61827 L .20223 .58973 L p F P
0 g
s
0 0 .109 r
.20223 .58973 m .20507 .54798 L .20597 .57736 L p F P
0 g
s
.01 w
.21028 .65633 Mdot
.5 Mabswid
0 0 0 r
.469 .26605 m .41815 .27855 L .43003 .27526 L p F P
0 g
s
0 0 0 r
.43003 .27526 m .47529 .26414 L .469 .26605 L p F P
0 g
s
.01 w
.84255 .64758 Mdot
.5 Mabswid
0 .395 .744 r
.67402 .29632 m .62873 .27724 L .61731 .27409 L p F P
0 g
s
.193 0 0 r
.5717 .26353 m .61731 .27409 L .62873 .27724 L p F P
0 g
s
0 0 .532 r
.27462 .78429 m .29416 .81131 L .27682 .7912 L p F P
0 g
s
0 0 .532 r
.27682 .7912 m .25544 .76172 L .27462 .78429 L p F P
0 g
s
.01 w
.20963 .65464 Mdot
.5 Mabswid
0 0 .076 r
.84902 .58632 m .84484 .54453 L .8419 .51609 L p F P
0 g
s
.838 .676 .136 r
.84484 .54453 m .84902 .58632 L .84812 .61493 L p F P
0 g
s
.01 w
.84326 .64519 Mdot
.23539 .72791 Mdot
.5 Mabswid
0 0 0 r
.77625 .78889 m .79668 .75916 L .81241 .73467 L p F P
0 g
s
.667 .897 .552 r
.79668 .75916 m .77625 .78889 L .75871 .80919 L p F P
0 g
s
0 0 .407 r
.2293 .70308 m .23983 .73741 L .22789 .71173 L p F P
0 g
s
0 0 .407 r
.22789 .71173 m .21664 .67532 L .2293 .70308 L p F P
0 g
s
.01 w
.23425 .72568 Mdot
.5 Mabswid
0 .537 .727 r
.48225 .90453 m .51168 .90748 L .50881 .90755 L p F P
0 g
s
0 .537 .727 r
.50881 .90755 m .4732 .90398 L .48225 .90453 L p F P
0 g
s
.007 .583 .711 r
.54506 .9074 m .50881 .90755 L .51168 .90748 L p F P
0 g
s
.007 .583 .711 r
.51168 .90748 m .54166 .90735 L .54506 .9074 L p F P
0 g
s
.102 .657 .73 r
.58055 .90352 m .54506 .9074 L .54166 .90735 L p F P
0 g
s
.01 w
.23311 .7234 Mdot
.20905 .65298 Mdot
.84389 .64283 Mdot
.81716 .72476 Mdot
.5 Mabswid
0 0 0 r
.34453 .31982 m .30206 .34971 L .31869 .33503 L p F P
0 g
s
0 0 0 r
.31869 .33503 m .35819 .30719 L .34453 .31982 L p F P
0 g
s
.01 w
.23197 .72107 Mdot
.23083 .71869 Mdot
.2297 .71627 Mdot
.5 Mabswid
0 0 0 r
.40723 .28566 m .35819 .30719 L .37348 .29818 L p F P
0 g
s
0 0 0 r
.37348 .29818 m .41815 .27855 L .40723 .28566 L p F P
0 g
s
.01 w
.81729 .72474 Mdot
.5 Mabswid
.812 .87 .43 r
.83452 .67223 m .82444 .70882 L .81241 .73467 L p F P
0 g
s
.71 .744 .234 r
.82444 .70882 m .83452 .67223 L .8433 .64369 L p F P
0 g
s
.01 w
.22857 .7138 Mdot
.5 Mabswid
0 .216 .65 r
.72936 .33254 m .68896 .30515 L .67402 .29632 L p F P
0 g
s
.565 .009 0 r
.68896 .30515 m .72936 .33254 L .74575 .34703 L p F P
0 g
s
.01 w
.20854 .65138 Mdot
.84447 .64051 Mdot
.22745 .71129 Mdot
.5 Mabswid
.426 0 0 r
.62873 .27724 m .67402 .29632 L .68896 .30515 L p F P
0 g
s
0 0 0 r
.22673 .47794 m .20804 .51957 L .21473 .49246 L p F P
0 g
s
0 0 0 r
.21473 .49246 m .23318 .45108 L .22673 .47794 L p F P
0 g
s
.01 w
.22633 .70873 Mdot
.5 Mabswid
0 .518 .773 r
.45455 .89859 m .48225 .90453 L .4732 .90398 L p F P
0 g
s
0 .518 .773 r
.4732 .90398 m .43962 .89679 L .45455 .89859 L p F P
0 g
s
.031 0 0 r
.52317 .26155 m .469 .26605 L .47529 .26414 L p F P
0 g
s
.031 0 0 r
.47529 .26414 m .52344 .26014 L .52317 .26155 L p F P
0 g
s
.01 w
.81739 .72474 Mdot
.5 Mabswid
0 .364 .749 r
.38395 .87259 m .40944 .88621 L .39101 .87903 L p F P
0 g
s
0 .364 .749 r
.39101 .87903 m .36121 .86314 L .38395 .87259 L p F P
0 g
s
.102 .657 .73 r
.54166 .90735 m .57098 .90415 L .58055 .90352 L p F P
0 g
s
.235 .753 .778 r
.61389 .89604 m .58055 .90352 L .57098 .90415 L p F P
0 g
s
.193 0 0 r
.62873 .27724 m .57748 .26537 L .5717 .26353 L p F P
0 g
s
.146 0 0 r
.52344 .26014 m .5717 .26353 L .57748 .26537 L p F P
0 g
s
0 .246 .705 r
.33813 .8442 m .36121 .86314 L .34094 .85058 L p F P
0 g
s
0 .246 .705 r
.34094 .85058 m .31465 .82907 L .33813 .8442 L p F P
0 g
s
.01 w
.22523 .70612 Mdot
.22413 .70347 Mdot
.2081 .64982 Mdot
.84497 .63823 Mdot
.5 Mabswid
0 0 0 r
.61389 .89604 m .64373 .88519 L .66255 .87785 L p F P
0 g
s
0 0 0 r
.66255 .87785 m .69183 .86169 L .71241 .84893 L p F P
0 g
s
.443 .87 .759 r
.69183 .86169 m .66255 .87785 L .64373 .88519 L p F P
0 g
s
.01 w
.81746 .72474 Mdot
.22306 .70078 Mdot
.5 Mabswid
0 0 0 r
.71241 .84893 m .738 .82716 L .75871 .80919 L p F P
0 g
s
.568 .918 .718 r
.738 .82716 m .71241 .84893 L .69183 .86169 L p F P
0 g
s
.867 .534 .022 r
.81545 .44776 m .83523 .489 L .8419 .51609 L p F P
0 g
s
.724 .363 0 r
.83523 .489 m .81545 .44776 L .80568 .42313 L p F P
0 g
s
.01 w
.22199 .69805 Mdot
.5 Mabswid
.146 0 0 r
.57748 .26537 m .52317 .26155 L .52344 .26014 L p F P
0 g
s
0 0 0 r
.27605 .38856 m .24302 .42638 L .25603 .40407 L p F P
0 g
s
0 0 0 r
.25603 .40407 m .28776 .36759 L .27605 .38856 L p F P
0 g
s
.01 w
.8175 .72475 Mdot
.22095 .69527 Mdot
.8454 .63599 Mdot
.20772 .64831 Mdot
.5 Mabswid
0 0 .305 r
.21084 .60734 m .2079 .64692 L .20311 .61827 L p F P
0 g
s
0 0 .305 r
.20311 .61827 m .20597 .57736 L .21084 .60734 L p F P
0 g
s
.01 w
.21992 .69246 Mdot
.81752 .72477 Mdot
.21892 .68961 Mdot
.5 Mabswid
.782 .318 0 r
.75986 .36477 m .79277 .40093 L .80568 .42313 L p F P
0 g
s
.606 .121 0 r
.79277 .40093 m .75986 .36477 L .74575 .34703 L p F P
0 g
s
.01 w
.81751 .72479 Mdot
.21794 .68672 Mdot
.84577 .63379 Mdot
.20741 .64684 Mdot
.5 Mabswid
.926 .796 .327 r
.84393 .57397 m .84812 .61493 L .8433 .64369 L p F P
0 g
s
.838 .676 .136 r
.84812 .61493 m .84393 .57397 L .84484 .54453 L p F P
0 g
s
.01 w
.21698 .68379 Mdot
.5 Mabswid
0 .522 .836 r
.42975 .88988 m .45455 .89859 L .43962 .89679 L p F P
0 g
s
0 .522 .836 r
.43962 .89679 m .40944 .88621 L .42975 .88988 L p F P
0 g
s
.01 w
.81749 .72482 Mdot
.5 Mabswid
0 .179 .699 r
.29722 .8048 m .31465 .82907 L .29416 .81131 L p F P
0 g
s
0 .179 .699 r
.29416 .81131 m .27462 .78429 L .29722 .8048 L p F P
0 g
s
.01 w
.21605 .68083 Mdot
.5 Mabswid
.235 .753 .778 r
.57098 .90415 m .59847 .89798 L .61389 .89604 L p F P
0 g
s
.393 .852 .842 r
.64373 .88519 m .61389 .89604 L .59847 .89798 L p F P
0 g
s
.01 w
.84606 .63164 Mdot
.20717 .64543 Mdot
.81744 .72485 Mdot
.5 Mabswid
0 0 .574 r
.24583 .72982 m .25544 .76172 L .23983 .73741 L p F P
0 g
s
0 0 .574 r
.23983 .73741 m .2293 .70308 L .24583 .72982 L p F P
0 g
s
.01 w
.21515 .67784 Mdot
.5 Mabswid
.738 .971 .712 r
.77736 .78196 m .75871 .80919 L .738 .82716 L p F P
0 g
s
.667 .897 .552 r
.75871 .80919 m .77736 .78196 L .79668 .75916 L p F P
0 g
s
.01 w
.21429 .67481 Mdot
.81738 .72488 Mdot
.84629 .62954 Mdot
.21345 .67176 Mdot
.20699 .64406 Mdot
.5 Mabswid
.87 .948 .59 r
.8218 .70017 m .81241 .73467 L .79668 .75916 L p F P
0 g
s
.812 .87 .43 r
.81241 .73467 m .8218 .70017 L .83452 .67223 L p F P
0 g
s
.01 w
.8173 .72492 Mdot
.21265 .66867 Mdot
.5 Mabswid
.079 0 0 r
.46321 .27193 m .40723 .28566 L .41815 .27855 L p F P
0 g
s
.079 0 0 r
.41815 .27855 m .469 .26605 L .46321 .27193 L p F P
0 g
s
.01 w
.81721 .72496 Mdot
.21189 .66556 Mdot
.5 Mabswid
0 0 .195 r
.22387 .50664 m .20507 .54798 L .20804 .51957 L p F P
0 g
s
0 0 .195 r
.20804 .51957 m .22673 .47794 L .22387 .50664 L p F P
0 g
s
.01 w
.84644 .62748 Mdot
.5 Mabswid
.426 0 0 r
.68896 .30515 m .63923 .28422 L .62873 .27724 L p F P
0 g
s
.433 0 0 r
.57748 .26537 m .62873 .27724 L .63923 .28422 L p F P
0 g
s
.01 w
.20687 .64275 Mdot
.5 Mabswid
0 0 0 r
.33275 .33606 m .28776 .36759 L .30206 .34971 L p F P
0 g
s
0 0 0 r
.30206 .34971 m .34453 .31982 L .33275 .33606 L p F P
0 g
s
.01 w
.81711 .72499 Mdot
.21117 .66242 Mdot
.817 .72502 Mdot
.21049 .65926 Mdot
.84653 .62547 Mdot
.5 Mabswid
.735 .211 0 r
.70231 .31763 m .74575 .34703 L .75986 .36477 L p F P
0 g
s
.565 .009 0 r
.74575 .34703 m .70231 .31763 L .68896 .30515 L p F P
0 g
s
.01 w
.20682 .64148 Mdot
.5 Mabswid
.951 .66 .216 r
.82184 .47459 m .8419 .51609 L .84484 .54453 L p F P
0 g
s
.867 .534 .022 r
.8419 .51609 m .82184 .47459 L .81545 .44776 L p F P
0 g
s
.01 w
.81687 .72505 Mdot
.5 Mabswid
0 .422 .847 r
.36436 .85641 m .38395 .87259 L .36121 .86314 L p F P
0 g
s
0 .422 .847 r
.36121 .86314 m .33813 .8442 L .36436 .85641 L p F P
0 g
s
0 0 .466 r
.2197 .63753 m .21664 .67532 L .2079 .64692 L p F P
0 g
s
0 0 .466 r
.2079 .64692 m .21084 .60734 L .2197 .63753 L p F P
0 g
s
.01 w
.20985 .65607 Mdot
.5 Mabswid
.031 0 0 r
.39746 .29667 m .34453 .31982 L .35819 .30719 L p F P
0 g
s
.031 0 0 r
.35819 .30719 m .40723 .28566 L .39746 .29667 L p F P
0 g
s
.01 w
.81674 .72507 Mdot
.5 Mabswid
.211 .706 .917 r
.49209 .90117 m .5148 .90345 L .51168 .90748 L p F P
0 g
s
.211 .706 .917 r
.51168 .90748 m .48225 .90453 L .49209 .90117 L p F P
0 g
s
.252 .746 .911 r
.54166 .90735 m .51168 .90748 L .5148 .90345 L p F P
0 g
s
.01 w
.20926 .65286 Mdot
.5 Mabswid
0 0 .053 r
.26717 .41245 m .23318 .45108 L .24302 .42638 L p F P
0 g
s
0 0 .053 r
.24302 .42638 m .27605 .38856 L .26717 .41245 L p F P
0 g
s
.252 .746 .911 r
.5148 .90345 m .53795 .90335 L .54166 .90735 L p F P
0 g
s
.322 .796 .918 r
.57098 .90415 m .54166 .90735 L .53795 .90335 L p F P
0 g
s
.443 .87 .759 r
.64373 .88519 m .66876 .87135 L .69183 .86169 L p F P
0 g
s
.642 .967 .853 r
.71428 .84252 m .69183 .86169 L .66876 .87135 L p F P
0 g
s
.568 .918 .718 r
.69183 .86169 m .71428 .84252 L .738 .82716 L p F P
0 g
s
.01 w
.84655 .62351 Mdot
.20683 .64027 Mdot
.5 Mabswid
.062 .537 .894 r
.40893 .8787 m .42975 .88988 L .40944 .88621 L p F P
0 g
s
.062 .537 .894 r
.40944 .88621 m .38395 .87259 L .40893 .8787 L p F P
0 g
s
.621 .055 0 r
.63923 .28422 m .68896 .30515 L .70231 .31763 L p F P
0 g
s
.01 w
.81661 .72508 Mdot
.20872 .64964 Mdot
.5 Mabswid
.393 .852 .842 r
.59847 .89798 m .62298 .88905 L .64373 .88519 L p F P
0 g
s
.549 .929 .899 r
.66876 .87135 m .64373 .88519 L .62298 .88905 L p F P
0 g
s
.968 .873 .481 r
.83905 .60406 m .8433 .64369 L .83452 .67223 L p F P
0 g
s
.926 .796 .327 r
.8433 .64369 m .83905 .60406 L .84393 .57397 L p F P
0 g
s
.01 w
.81647 .72509 Mdot
.5 Mabswid
.889 .47 .073 r
.77141 .38564 m .80568 .42313 L .81545 .44776 L p F P
0 g
s
.782 .318 0 r
.80568 .42313 m .77141 .38564 L .75986 .36477 L p F P
0 g
s
.01 w
.20822 .6464 Mdot
.8465 .62161 Mdot
.2069 .6391 Mdot
.81633 .72508 Mdot
.5 Mabswid
.201 .679 .934 r
.47078 .89658 m .49209 .90117 L .48225 .90453 L p F P
0 g
s
.201 .679 .934 r
.48225 .90453 m .45455 .89859 L .47078 .89658 L p F P
0 g
s
.322 .796 .918 r
.53795 .90335 m .56057 .90087 L .57098 .90415 L p F P
0 g
s
.413 .85 .935 r
.59847 .89798 m .57098 .90415 L .56057 .90087 L p F P
0 g
s
.257 0 0 r
.52293 .26699 m .46321 .27193 L .469 .26605 L p F P
0 g
s
.257 0 0 r
.469 .26605 m .52317 .26155 L .52293 .26699 L p F P
0 g
s
0 .162 .701 r
.2661 .75515 m .27462 .78429 L .25544 .76172 L p F P
0 g
s
0 .162 .701 r
.25544 .76172 m .24583 .72982 L .2661 .75515 L p F P
0 g
s
.433 0 0 r
.63923 .28422 m .58279 .27118 L .57748 .26537 L p F P
0 g
s
.373 0 0 r
.52317 .26155 m .57748 .26537 L .58279 .27118 L p F P
0 g
s
.01 w
.20777 .64314 Mdot
.5 Mabswid
0 .341 .818 r
.32302 .8229 m .33813 .8442 L .31465 .82907 L p F P
0 g
s
0 .341 .818 r
.31465 .82907 m .29722 .8048 L .32302 .8229 L p F P
0 g
s
.01 w
.81619 .72507 Mdot
.81605 .72504 Mdot
.84639 .61975 Mdot
.20703 .63799 Mdot
.20738 .63987 Mdot
.5 Mabswid
.769 .997 .823 r
.75461 .8027 m .738 .82716 L .71428 .84252 L p F P
0 g
s
.738 .971 .712 r
.738 .82716 m .75461 .8027 L .77736 .78196 L p F P
0 g
s
.01 w
.81591 .725 Mdot
.5 Mabswid
.889 .984 .71 r
.80521 .72712 m .79668 .75916 L .77736 .78196 L p F P
0 g
s
.87 .948 .59 r
.79668 .75916 m .80521 .72712 L .8218 .70017 L p F P
0 g
s
.373 0 0 r
.58279 .27118 m .52293 .26699 L .52317 .26155 L p F P
0 g
s
.01 w
.20704 .63659 Mdot
.81578 .72494 Mdot
.20722 .63692 Mdot
.8462 .61795 Mdot
.81565 .72487 Mdot
.20676 .6333 Mdot
.5 Mabswid
0 0 .357 r
.22474 .53684 m .20597 .57736 L .20507 .54798 L p F P
0 g
s
0 0 .357 r
.20507 .54798 m .22387 .50664 L .22474 .53684 L p F P
0 g
s
.01 w
.81553 .72478 Mdot
.5 Mabswid
.22 .662 .953 r
.45176 .88986 m .47078 .89658 L .45455 .89859 L p F P
0 g
s
.22 .662 .953 r
.45455 .89859 m .42975 .88988 L .45176 .88986 L p F P
0 g
s
.01 w
.81541 .72467 Mdot
.20653 .63 Mdot
.5 Mabswid
.413 .85 .935 r
.56057 .90087 m .58173 .8961 L .59847 .89798 L p F P
0 g
s
.512 .897 .954 r
.62298 .88905 m .59847 .89798 L .58173 .8961 L p F P
0 g
s
.01 w
.20747 .63591 Mdot
.84595 .6162 Mdot
.81531 .72454 Mdot
.5 Mabswid
0 .047 .591 r
.23253 .66751 m .2293 .70308 L .21664 .67532 L p F P
0 g
s
0 .047 .591 r
.21664 .67532 m .2197 .63753 L .23253 .66751 L p F P
0 g
s
.01 w
.81521 .72439 Mdot
.5 Mabswid
.99 .743 .372 r
.82467 .50331 m .84484 .54453 L .84393 .57397 L p F P
0 g
s
.951 .66 .216 r
.84484 .54453 m .82467 .50331 L .82184 .47459 L p F P
0 g
s
.01 w
.20637 .6267 Mdot
.81513 .72421 Mdot
.20778 .63495 Mdot
.84563 .61451 Mdot
.81506 .72401 Mdot
.5 Mabswid
.057 0 .056 r
.32309 .35582 m .27605 .38856 L .28776 .36759 L p F P
0 g
s
.057 0 .056 r
.28776 .36759 m .33275 .33606 L .32309 .35582 L p F P
0 g
s
.01 w
.20626 .6234 Mdot
.815 .72378 Mdot
.5 Mabswid
.977 .915 .6 r
.83019 .6344 m .83452 .67223 L .8218 .70017 L p F P
0 g
s
.968 .873 .481 r
.83452 .67223 m .83019 .6344 L .83905 .60406 L p F P
0 g
s
.01 w
.81495 .72353 Mdot
.20622 .6201 Mdot
.5 Mabswid
.161 .552 .929 r
.39308 .86546 m .40893 .8787 L .38395 .87259 L p F P
0 g
s
.161 .552 .929 r
.38395 .87259 m .36436 .85641 L .39308 .86546 L p F P
0 g
s
.01 w
.20814 .63404 Mdot
.5 Mabswid
0 0 .231 r
.26135 .43902 m .22673 .47794 L .23318 .45108 L p F P
0 g
s
0 0 .231 r
.23318 .45108 m .26717 .41245 L .26135 .43902 L p F P
0 g
s
.01 w
.81492 .72325 Mdot
.5 Mabswid
.833 .364 .07 r
.71382 .33375 m .75986 .36477 L .77141 .38564 L p F P
0 g
s
.735 .211 0 r
.75986 .36477 m .71382 .33375 L .70231 .31763 L p F P
0 g
s
.259 0 0 r
.45802 .28188 m .39746 .29667 L .40723 .28566 L p F P
0 g
s
.259 0 0 r
.40723 .28566 m .46321 .27193 L .45802 .28188 L p F P
0 g
s
.01 w
.84525 .61287 Mdot
.81491 .72294 Mdot
.5 Mabswid
.549 .929 .899 r
.62298 .88905 m .64341 .87768 L .66876 .87135 L p F P
0 g
s
.675 .966 .93 r
.68779 .85498 m .66876 .87135 L .64341 .87768 L p F P
0 g
s
.642 .967 .853 r
.66876 .87135 m .68779 .85498 L .71428 .84252 L p F P
0 g
s
.621 .055 0 r
.70231 .31763 m .64862 .29511 L .63923 .28422 L p F P
0 g
s
.593 .048 0 r
.58279 .27118 m .63923 .28422 L .64862 .29511 L p F P
0 g
s
.01 w
.81491 .7226 Mdot
.20624 .6168 Mdot
.5 Mabswid
.026 .299 .791 r
.28989 .7787 m .29722 .8048 L .27462 .78429 L p F P
0 g
s
.026 .299 .791 r
.27462 .78429 m .2661 .75515 L .28989 .7787 L p F P
0 g
s
.01 w
.81493 .72222 Mdot
.20855 .63317 Mdot
.81496 .72182 Mdot
.5 Mabswid
.942 .576 .245 r
.78017 .40946 m .81545 .44776 L .82184 .47459 L p F P
0 g
s
.889 .47 .073 r
.81545 .44776 m .78017 .40946 L .77141 .38564 L p F P
0 g
s
.01 w
.8448 .61129 Mdot
.20633 .6135 Mdot
.81502 .72137 Mdot
.5 Mabswid
.124 .467 .892 r
.35174 .83829 m .36436 .85641 L .33813 .8442 L p F P
0 g
s
.124 .467 .892 r
.33813 .8442 m .32302 .8229 L .35174 .83829 L p F P
0 g
s
.19 0 .006 r
.38901 .31159 m .33275 .33606 L .34453 .31982 L p F P
0 g
s
.19 0 .006 r
.34453 .31982 m .39746 .29667 L .38901 .31159 L p F P
0 g
s
.01 w
.81509 .7209 Mdot
.5 Mabswid
.261 .65 .965 r
.4359 .88127 m .45176 .88986 L .42975 .88988 L p F P
0 g
s
.261 .65 .965 r
.42975 .88988 m .40893 .8787 L .4359 .88127 L p F P
0 g
s
.884 .99 .795 r
.78489 .75269 m .77736 .78196 L .75461 .8027 L p F P
0 g
s
.889 .984 .71 r
.77736 .78196 m .78489 .75269 L .80521 .72712 L p F P
0 g
s
.01 w
.81518 .72038 Mdot
.81518 .72039 Mdot
.5 Mabswid
.512 .897 .954 r
.58173 .8961 m .6005 .88922 L .62298 .88905 L p F P
0 g
s
.606 .928 .966 r
.64341 .87768 m .62298 .88905 L .6005 .88922 L p F P
0 g
s
.01 w
.20902 .63236 Mdot
.8153 .71983 Mdot
.20648 .61021 Mdot
.5 Mabswid
.772 .989 .894 r
.72865 .82106 m .71428 .84252 L .68779 .85498 L p F P
0 g
s
.769 .997 .823 r
.71428 .84252 m .72865 .82106 L .75461 .8027 L p F P
0 g
s
.735 .228 .016 r
.64862 .29511 m .70231 .31763 L .71382 .33375 L p F P
0 g
s
.01 w
.84429 .60976 Mdot
.81543 .71924 Mdot
.81558 .7186 Mdot
.81575 .71793 Mdot
.2067 .60693 Mdot
.5 Mabswid
.004 0 .482 r
.22943 .56817 m .21084 .60734 L .20597 .57736 L p F P
0 g
s
.004 0 .482 r
.20597 .57736 m .22474 .53684 L .22943 .56817 L p F P
0 g
s
.01 w
.81594 .71721 Mdot
.20954 .6316 Mdot
.5 Mabswid
.403 .783 .992 r
.50264 .89376 m .51815 .89533 L .5148 .90345 L p F P
0 g
s
.403 .783 .992 r
.5148 .90345 m .49209 .90117 L .50264 .89376 L p F P
0 g
s
.431 .811 .991 r
.53795 .90335 m .5148 .90345 L .51815 .89533 L p F P
0 g
s
.01 w
.81615 .71646 Mdot
.5 Mabswid
.431 .811 .991 r
.51815 .89533 m .53397 .89526 L .53795 .90335 L p F P
0 g
s
.473 .839 .992 r
.56057 .90087 m .53795 .90335 L .53397 .89526 L p F P
0 g
s
.01 w
.81638 .71565 Mdot
.84372 .60829 Mdot
.81662 .7148 Mdot
.5 Mabswid
.034 .179 .684 r
.24923 .69686 m .24583 .72982 L .2293 .70308 L p F P
0 g
s
.034 .179 .684 r
.2293 .70308 m .23253 .66751 L .24923 .69686 L p F P
0 g
s
.01 w
.207 .60367 Mdot
.81689 .71391 Mdot
.81718 .71297 Mdot
.81748 .71198 Mdot
.21011 .63088 Mdot
.5 Mabswid
.391 .758 .992 r
.48812 .89061 m .50264 .89376 L .49209 .90117 L p F P
0 g
s
.391 .758 .992 r
.49209 .90117 m .47078 .89658 L .48812 .89061 L p F P
0 g
s
.999 .795 .491 r
.82379 .53359 m .84393 .57397 L .83905 .60406 L p F P
0 g
s
.99 .743 .372 r
.84393 .57397 m .82379 .53359 L .82467 .50331 L p F P
0 g
s
.01 w
.8178 .71095 Mdot
.5 Mabswid
.473 .839 .992 r
.53397 .89526 m .54941 .89356 L .56057 .90087 L p F P
0 g
s
.524 .865 .993 r
.58173 .8961 m .56057 .90087 L .54941 .89356 L p F P
0 g
s
.01 w
.81814 .70986 Mdot
.20736 .60041 Mdot
.84309 .60688 Mdot
.5 Mabswid
.414 0 0 r
.52271 .27655 m .45802 .28188 L .46321 .27193 L p F P
0 g
s
.414 0 0 r
.46321 .27193 m .52293 .26699 L .52271 .27655 L p F P
0 g
s
.01 w
.8185 .70873 Mdot
.81887 .70754 Mdot
.5 Mabswid
.593 .048 0 r
.64862 .29511 m .58756 .28107 L .58279 .27118 L p F P
0 g
s
.522 0 0 r
.52293 .26699 m .58279 .27118 L .58756 .28107 L p F P
0 g
s
.967 .933 .688 r
.81736 .66457 m .8218 .70017 L .80521 .72712 L p F P
0 g
s
.977 .915 .6 r
.8218 .70017 m .81736 .66457 L .83019 .6344 L p F P
0 g
s
.01 w
.81925 .70631 Mdot
.81965 .70502 Mdot
.21072 .63022 Mdot
.82007 .70368 Mdot
.20779 .59717 Mdot
.82049 .70229 Mdot
.84239 .60553 Mdot
.82093 .70084 Mdot
.82138 .69935 Mdot
.82183 .6978 Mdot
.5 Mabswid
.155 .409 .852 r
.31694 .80009 m .32302 .8229 L .29722 .8048 L p F P
0 g
s
.155 .409 .852 r
.29722 .8048 m .28989 .7787 L .31694 .80009 L p F P
0 g
s
.01 w
.21138 .6296 Mdot
.8223 .69619 Mdot
.20829 .59396 Mdot
.5 Mabswid
.522 0 0 r
.58756 .28107 m .52271 .27655 L .52293 .26699 L p F P
0 g
s
.01 w
.82277 .69453 Mdot
.5 Mabswid
.394 .736 .992 r
.47523 .88602 m .48812 .89061 L .47078 .89658 L p F P
0 g
s
.394 .736 .992 r
.47078 .89658 m .45176 .88986 L .47523 .88602 L p F P
0 g
s
.106 0 .367 r
.25876 .46798 m .22387 .50664 L .22673 .47794 L p F P
0 g
s
.106 0 .367 r
.22673 .47794 m .26135 .43902 L .25876 .46798 L p F P
0 g
s
.01 w
.82324 .69282 Mdot
.5 Mabswid
.177 0 .224 r
.31575 .37896 m .26717 .41245 L .27605 .38856 L p F P
0 g
s
.177 0 .224 r
.27605 .38856 m .32309 .35582 L .31575 .37896 L p F P
0 g
s
.524 .865 .993 r
.54941 .89356 m .56382 .89029 L .58173 .8961 L p F P
0 g
s
.579 .885 .991 r
.6005 .88922 m .58173 .8961 L .56382 .89029 L p F P
0 g
s
.01 w
.82372 .69105 Mdot
.84164 .60423 Mdot
.82421 .68923 Mdot
.5 Mabswid
.315 .642 .967 r
.42395 .87114 m .4359 .88127 L .40893 .8787 L p F P
0 g
s
.315 .642 .967 r
.40893 .8787 m .39308 .86546 L .42395 .87114 L p F P
0 g
s
.863 .979 .853 r
.76104 .7765 m .75461 .8027 L .72865 .82106 L p F P
0 g
s
.884 .99 .795 r
.75461 .8027 m .76104 .7765 L .78489 .75269 L p F P
0 g
s
.01 w
.20887 .59076 Mdot
.82469 .68736 Mdot
.21209 .62903 Mdot
.82517 .68543 Mdot
.5 Mabswid
.606 .928 .966 r
.6005 .88922 m .61605 .88049 L .64341 .87768 L p F P
0 g
s
.681 .936 .966 r
.65879 .8643 m .64341 .87768 L .61605 .88049 L p F P
0 g
s
.675 .966 .93 r
.64341 .87768 m .65879 .8643 L .68779 .85498 L p F P
0 g
s
.262 .563 .935 r
.38304 .85071 m .39308 .86546 L .36436 .85641 L p F P
0 g
s
.262 .563 .935 r
.36436 .85641 m .35174 .83829 L .38304 .85071 L p F P
0 g
s
.01 w
.82565 .68344 Mdot
.5 Mabswid
.88 .47 .235 r
.72326 .35341 m .77141 .38564 L .78017 .40946 L p F P
0 g
s
.833 .364 .07 r
.77141 .38564 m .72326 .35341 L .71382 .33375 L p F P
0 g
s
.962 .647 .376 r
.7859 .43601 m .82184 .47459 L .82467 .50331 L p F P
0 g
s
.942 .576 .245 r
.82184 .47459 m .7859 .43601 L .78017 .40946 L p F P
0 g
s
.01 w
.82613 .68141 Mdot
.84082 .603 Mdot
.20953 .58759 Mdot
.8266 .67932 Mdot
.5 Mabswid
.757 .962 .934 r
.69977 .83673 m .68779 .85498 L .65879 .8643 L p F P
0 g
s
.772 .989 .894 r
.68779 .85498 m .69977 .83673 L .72865 .82106 L p F P
0 g
s
.01 w
.21284 .62851 Mdot
.82707 .67717 Mdot
.82753 .67497 Mdot
.5 Mabswid
.107 .109 .577 r
.23795 .60018 m .2197 .63753 L .21084 .60734 L p F P
0 g
s
.107 .109 .577 r
.21084 .60734 m .22943 .56817 L .23795 .60018 L p F P
0 g
s
.01 w
.82797 .67272 Mdot
.5 Mabswid
.141 .287 .753 r
.26965 .72514 m .2661 .75515 L .24583 .72982 L p F P
0 g
s
.141 .287 .753 r
.24583 .72982 m .24923 .69686 L .26965 .72514 L p F P
0 g
s
.01 w
.21025 .58444 Mdot
.83996 .60182 Mdot
.82841 .67042 Mdot
.21362 .62803 Mdot
.82882 .66807 Mdot
.5 Mabswid
.381 0 .098 r
.45354 .29594 m .38901 .31159 L .39746 .29667 L p F P
0 g
s
.381 0 .098 r
.39746 .29667 m .45802 .28188 L .45354 .29594 L p F P
0 g
s
.01 w
.82923 .66566 Mdot
.5 Mabswid
.409 .717 .987 r
.46455 .88016 m .47523 .88602 L .45176 .88986 L p F P
0 g
s
.409 .717 .987 r
.45176 .88986 m .4359 .88127 L .46455 .88016 L p F P
0 g
s
.01 w
.21106 .58132 Mdot
.82961 .66321 Mdot
.5 Mabswid
.735 .228 .016 r
.71382 .33375 m .65673 .30994 L .64862 .29511 L p F P
0 g
s
.683 .203 .103 r
.58756 .28107 m .64862 .29511 L .65673 .30994 L p F P
0 g
s
.991 .827 .582 r
.81912 .56502 m .83905 .60406 L .83019 .6344 L p F P
0 g
s
.999 .795 .491 r
.83905 .60406 m .81912 .56502 L .82379 .53359 L p F P
0 g
s
.301 0 .182 r
.38208 .33037 m .32309 .35582 L .33275 .33606 L p F P
0 g
s
.301 0 .182 r
.33275 .33606 m .38901 .31159 L .38208 .33037 L p F P
0 g
s
.945 .937 .755 r
.80067 .69414 m .80521 .72712 L .78489 .75269 L p F P
0 g
s
.967 .933 .688 r
.80521 .72712 m .80067 .69414 L .81736 .66457 L p F P
0 g
s
.579 .885 .991 r
.56382 .89029 m .57655 .88558 L .6005 .88922 L p F P
0 g
s
.63 .895 .986 r
.61605 .88049 m .6005 .88922 L .57655 .88558 L p F P
0 g
s
.01 w
.83903 .6007 Mdot
.82998 .6607 Mdot
.21445 .62759 Mdot
.83032 .65815 Mdot
.21193 .57823 Mdot
.83064 .65554 Mdot
.5 Mabswid
.795 .35 .19 r
.65673 .30994 m .71382 .33375 L .72326 .35341 L p F P
0 g
s
.01 w
.83093 .65289 Mdot
.21531 .6272 Mdot
.83806 .59964 Mdot
.5 Mabswid
.262 .498 .894 r
.34692 .81897 m .35174 .83829 L .32302 .8229 L p F P
0 g
s
.262 .498 .894 r
.32302 .8229 m .31694 .80009 L .34692 .81897 L p F P
0 g
s
.01 w
.8312 .6502 Mdot
.21289 .57518 Mdot
.83143 .64746 Mdot
.83164 .64467 Mdot
.21621 .62686 Mdot
.5 Mabswid
.834 .958 .893 r
.73393 .79817 m .72865 .82106 L .69977 .83673 L p F P
0 g
s
.863 .979 .853 r
.72865 .82106 m .73393 .79817 L .76104 .7765 L p F P
0 g
s
.01 w
.83703 .59864 Mdot
.8318 .64185 Mdot
.21392 .57216 Mdot
.83194 .63898 Mdot
.5 Mabswid
.195 .068 .47 r
.25955 .49896 m .22474 .53684 L .22387 .50664 L p F P
0 g
s
.195 .068 .47 r
.22387 .50664 m .25876 .46798 L .25955 .49896 L p F P
0 g
s
.525 .799 .996 r
.51379 .88224 m .52169 .88304 L .51815 .89533 L p F P
0 g
s
.525 .799 .996 r
.51815 .89533 m .50264 .89376 L .51379 .88224 L p F P
0 g
s
.54 .814 .997 r
.53397 .89526 m .51815 .89533 L .52169 .88304 L p F P
0 g
s
.01 w
.21714 .62655 Mdot
.5 Mabswid
.54 .814 .997 r
.52169 .88304 m .52976 .88301 L .53397 .89526 L p F P
0 g
s
.561 .828 .996 r
.54941 .89356 m .53397 .89526 L .52976 .88301 L p F P
0 g
s
.01 w
.83203 .63607 Mdot
.83596 .5977 Mdot
.5 Mabswid
.372 .635 .956 r
.41652 .8599 m .42395 .87114 L .39308 .86546 L p F P
0 g
s
.372 .635 .956 r
.39308 .86546 m .38304 .85071 L .41652 .8599 L p F P
0 g
s
.01 w
.21503 .56918 Mdot
.5 Mabswid
.229 .377 .805 r
.29354 .75191 m .28989 .7787 L .2661 .75515 L p F P
0 g
s
.229 .377 .805 r
.2661 .75515 m .26965 .72514 L .29354 .75191 L p F P
0 g
s
.01 w
.83209 .63312 Mdot
.5 Mabswid
.516 .784 .993 r
.5064 .88062 m .51379 .88224 L .50264 .89376 L p F P
0 g
s
.516 .784 .993 r
.50264 .89376 m .48812 .89061 L .5064 .88062 L p F P
0 g
s
.191 .21 .65 r
.25028 .63243 m .23253 .66751 L .2197 .63753 L p F P
0 g
s
.191 .21 .65 r
.2197 .63753 m .23795 .60018 L .25028 .63243 L p F P
0 g
s
.561 .828 .996 r
.52976 .88301 m .53764 .88213 L .54941 .89356 L p F P
0 g
s
.585 .839 .993 r
.56382 .89029 m .54941 .89356 L .53764 .88213 L p F P
0 g
s
.433 .702 .978 r
.45658 .87329 m .46455 .88016 L .4359 .88127 L p F P
0 g
s
.433 .702 .978 r
.4359 .88127 m .42395 .87114 L .45658 .87329 L p F P
0 g
s
.681 .936 .966 r
.61605 .88049 m .62764 .87025 L .65879 .8643 L p F P
0 g
s
.734 .925 .955 r
.6683 .84944 m .65879 .8643 L .62764 .87025 L p F P
0 g
s
.757 .962 .934 r
.65879 .8643 m .6683 .84944 L .69977 .83673 L p F P
0 g
s
.01 w
.2181 .62628 Mdot
.5 Mabswid
.266 .025 .349 r
.31094 .40525 m .26135 .43902 L .26717 .41245 L p F P
0 g
s
.266 .025 .349 r
.26717 .41245 m .31575 .37896 L .31094 .40525 L p F P
0 g
s
.01 w
.8321 .63014 Mdot
.5 Mabswid
.963 .694 .476 r
.78844 .46498 m .82467 .50331 L .82379 .53359 L p F P
0 g
s
.962 .647 .376 r
.82467 .50331 m .78844 .46498 L .7859 .43601 L p F P
0 g
s
.63 .895 .986 r
.57655 .88558 m .58701 .87963 L .61605 .88049 L p F P
0 g
s
.673 .895 .977 r
.62764 .87025 m .61605 .88049 L .58701 .87963 L p F P
0 g
s
.511 .071 .139 r
.52251 .29029 m .45354 .29594 L .45802 .28188 L p F P
0 g
s
.511 .071 .139 r
.45802 .28188 m .52271 .27655 L .52251 .29029 L p F P
0 g
s
.01 w
.21621 .56625 Mdot
.83483 .59682 Mdot
.83206 .62712 Mdot
.5 Mabswid
.683 .203 .103 r
.65673 .30994 m .59167 .29508 L .58756 .28107 L p F P
0 g
s
.608 .15 .14 r
.52271 .27655 m .58756 .28107 L .59167 .29508 L p F P
0 g
s
.916 .932 .805 r
.78028 .72267 m .78489 .75269 L .76104 .7765 L p F P
0 g
s
.945 .937 .755 r
.78489 .75269 m .78028 .72267 L .80067 .69414 L p F P
0 g
s
.01 w
.83198 .62406 Mdot
.21909 .62606 Mdot
.5 Mabswid
.9 .542 .356 r
.73043 .3765 m .78017 .40946 L .7859 .43601 L p F P
0 g
s
.88 .47 .235 r
.78017 .40946 m .73043 .3765 L .72326 .35341 L p F P
0 g
s
.974 .845 .653 r
.81062 .59718 m .83019 .6344 L .81736 .66457 L p F P
0 g
s
.991 .827 .582 r
.83019 .6344 m .81062 .59718 L .81912 .56502 L p F P
0 g
s
.01 w
.83186 .62098 Mdot
.21748 .56335 Mdot
.5 Mabswid
.513 .768 .989 r
.49988 .87826 m .5064 .88062 L .48812 .89061 L p F P
0 g
s
.513 .768 .989 r
.48812 .89061 m .47523 .88602 L .49988 .87826 L p F P
0 g
s
.01 w
.83366 .59599 Mdot
.5 Mabswid
.585 .839 .993 r
.53764 .88213 m .54496 .88045 L .56382 .89029 L p F P
0 g
s
.61 .847 .988 r
.57655 .88558 m .56382 .89029 L .54496 .88045 L p F P
0 g
s
.01 w
.22011 .62587 Mdot
.83168 .61786 Mdot
.5 Mabswid
.351 .57 .921 r
.37945 .83505 m .38304 .85071 L .35174 .83829 L p F P
0 g
s
.351 .57 .921 r
.35174 .83829 m .34692 .81897 L .37945 .83505 L p F P
0 g
s
.608 .15 .14 r
.59167 .29508 m .52251 .29029 L .52271 .27655 L p F P
0 g
s
.01 w
.83145 .61471 Mdot
.21881 .5605 Mdot
.83245 .59522 Mdot
.22115 .62572 Mdot
.83116 .61154 Mdot
.5 Mabswid
.8 .931 .919 r
.70389 .81735 m .69977 .83673 L .6683 .84944 L p F P
0 g
s
.834 .958 .893 r
.69977 .83673 m .70389 .81735 L .73393 .79817 L p F P
0 g
s
.01 w
.83082 .60834 Mdot
.22023 .5577 Mdot
.22222 .6256 Mdot
.8312 .59451 Mdot
.5 Mabswid
.516 .755 .983 r
.49451 .87527 m .49988 .87826 L .47523 .88602 L p F P
0 g
s
.516 .755 .983 r
.47523 .88602 m .46455 .88016 L .49451 .87527 L p F P
0 g
s
.01 w
.83042 .60512 Mdot
.5 Mabswid
.61 .847 .988 r
.54496 .88045 m .5514 .87804 L .57655 .88558 L p F P
0 g
s
.635 .85 .982 r
.58701 .87963 m .57655 .88558 L .5514 .87804 L p F P
0 g
s
.305 .453 .845 r
.3206 .77677 m .31694 .80009 L .28989 .7787 L p F P
0 g
s
.305 .453 .845 r
.28989 .7787 m .29354 .75191 L .3206 .77677 L p F P
0 g
s
.379 .07 .311 r
.3768 .35289 m .31575 .37896 L .32309 .35582 L p F P
0 g
s
.379 .07 .311 r
.32309 .35582 m .38208 .33037 L .3768 .35289 L p F P
0 g
s
.01 w
.22172 .55494 Mdot
.82996 .60187 Mdot
.2233 .62552 Mdot
.5 Mabswid
.459 .088 .247 r
.44984 .31408 m .38208 .33037 L .38901 .31159 L p F P
0 g
s
.459 .088 .247 r
.38901 .31159 m .45354 .29594 L .44984 .31408 L p F P
0 g
s
.01 w
.8299 .59385 Mdot
.5 Mabswid
.26 .294 .708 r
.2663 .66443 m .24923 .69686 L .23253 .66751 L p F P
0 g
s
.26 .294 .708 r
.23253 .66751 m .25028 .63243 L .2663 .66443 L p F P
0 g
s
.01 w
.82944 .59861 Mdot
.5 Mabswid
.264 .164 .549 r
.26378 .53157 m .22943 .56817 L .22474 .53684 L p F P
0 g
s
.264 .164 .549 r
.22474 .53684 m .25955 .49896 L .26378 .53157 L p F P
0 g
s
.462 .689 .965 r
.45174 .86569 m .45658 .87329 L .42395 .87114 L p F P
0 g
s
.462 .689 .965 r
.42395 .87114 m .41652 .8599 L .45174 .86569 L p F P
0 g
s
.884 .921 .843 r
.75642 .74971 m .76104 .7765 L .73393 .79817 L p F P
0 g
s
.916 .932 .805 r
.76104 .7765 m .75642 .74971 L .78028 .72267 L p F P
0 g
s
.795 .35 .19 r
.72326 .35341 m .6634 .32866 L .65673 .30994 L p F P
0 g
s
.731 .311 .25 r
.59167 .29508 m .65673 .30994 L .6634 .32866 L p F P
0 g
s
.823 .434 .316 r
.6634 .32866 m .72326 .35341 L .73043 .3765 L p F P
0 g
s
.01 w
.2244 .62547 Mdot
.22329 .55224 Mdot
.5 Mabswid
.673 .895 .977 r
.58701 .87963 m .59473 .87268 L .62764 .87025 L p F P
0 g
s
.705 .885 .964 r
.63466 .85894 m .62764 .87025 L .59473 .87268 L p F P
0 g
s
.734 .925 .955 r
.62764 .87025 m .63466 .85894 L .6683 .84944 L p F P
0 g
s
.01 w
.82886 .59533 Mdot
.82857 .59325 Mdot
.82821 .59204 Mdot
.5 Mabswid
.952 .855 .708 r
.79836 .62962 m .81736 .66457 L .80067 .69414 L p F P
0 g
s
.974 .845 .653 r
.81736 .66457 m .79836 .62962 L .81062 .59718 L p F P
0 g
s
.01 w
.22552 .62545 Mdot
.5 Mabswid
.955 .727 .553 r
.78765 .49603 m .82379 .53359 L .81912 .56502 L p F P
0 g
s
.963 .694 .476 r
.82379 .53359 m .78765 .49603 L .78844 .46498 L p F P
0 g
s
.01 w
.22493 .5496 Mdot
.82749 .58873 Mdot
.5 Mabswid
.524 .742 .975 r
.49055 .87178 m .49451 .87527 L .46455 .88016 L p F P
0 g
s
.524 .742 .975 r
.46455 .88016 m .45658 .87329 L .49055 .87178 L p F P
0 g
s
.427 .63 .939 r
.41407 .84804 m .41652 .8599 L .38304 .85071 L p F P
0 g
s
.427 .63 .939 r
.38304 .85071 m .37945 .83505 L .41407 .84804 L p F P
0 g
s
.01 w
.8272 .59271 Mdot
.5 Mabswid
.635 .85 .982 r
.5514 .87804 m .55665 .875 L .58701 .87963 L p F P
0 g
s
.656 .849 .974 r
.59473 .87268 m .58701 .87963 L .55665 .875 L p F P
0 g
s
.01 w
.22666 .62546 Mdot
.5 Mabswid
.332 .126 .444 r
.3088 .43442 m .25876 .46798 L .26135 .43902 L p F P
0 g
s
.332 .126 .444 r
.26135 .43902 m .31094 .40525 L .3088 .43442 L p F P
0 g
s
.01 w
.82671 .58542 Mdot
.5 Mabswid
.764 .901 .937 r
.67132 .83374 m .6683 .84944 L .63466 .85894 L p F P
0 g
s
.8 .931 .919 r
.6683 .84944 m .67132 .83374 L .70389 .81735 L p F P
0 g
s
.01 w
.22665 .547 Mdot
.82579 .59222 Mdot
.82585 .58209 Mdot
.2278 .6255 Mdot
.5 Mabswid
.369 .518 .875 r
.35046 .79932 m .34692 .81897 L .31694 .80009 L p F P
0 g
s
.369 .518 .875 r
.31694 .80009 m .3206 .77677 L .35046 .79932 L p F P
0 g
s
.904 .594 .448 r
.73512 .40277 m .7859 .43601 L .78844 .46498 L p F P
0 g
s
.9 .542 .356 r
.7859 .43601 m .73512 .40277 L .73043 .3765 L p F P
0 g
s
.01 w
.22845 .54447 Mdot
.22845 .54447 Mdot
.82493 .57877 Mdot
.22896 .62557 Mdot
.82435 .59178 Mdot
.5 Mabswid
.599 .789 .972 r
.52169 .88304 m .51379 .88224 L .52538 .86658 L closepath p F P
0 g
s
.604 .794 .972 r
.52976 .88301 m .52169 .88304 L .52538 .86658 L closepath p F P
0 g
s
.61 .798 .971 r
.53764 .88213 m .52976 .88301 L .52538 .86658 L closepath p F P
0 g
s
.85 .906 .873 r
.72942 .77486 m .73393 .79817 L .70389 .81735 L p F P
0 g
s
.884 .921 .843 r
.73393 .79817 m .72942 .77486 L .75642 .74971 L p F P
0 g
s
.01 w
.82393 .57543 Mdot
.5 Mabswid
.319 .366 .754 r
.28582 .6957 m .26965 .72514 L .24923 .69686 L p F P
0 g
s
.319 .366 .754 r
.24923 .69686 m .2663 .66443 L .28582 .6957 L p F P
0 g
s
.596 .784 .97 r
.51379 .88224 m .5064 .88062 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23012 .62566 Mdot
.5 Mabswid
.616 .801 .97 r
.54496 .88045 m .53764 .88213 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23031 .542 Mdot
.82285 .5721 Mdot
.82289 .59139 Mdot
.5 Mabswid
.57 .186 .274 r
.52235 .30819 m .44984 .31408 L .45354 .29594 L p F P
0 g
s
.57 .186 .274 r
.45354 .29594 m .52251 .29029 L .52235 .30819 L p F P
0 g
s
.535 .732 .965 r
.4882 .86795 m .49055 .87178 L .45658 .87329 L p F P
0 g
s
.535 .732 .965 r
.45658 .87329 m .45174 .86569 L .4882 .86795 L p F P
0 g
s
.01 w
.2313 .62577 Mdot
.5 Mabswid
.594 .779 .969 r
.5064 .88062 m .49988 .87826 L .52538 .86658 L closepath p F P
0 g
s
.623 .803 .968 r
.5514 .87804 m .54496 .88045 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.8217 .56877 Mdot
.5 Mabswid
.731 .311 .25 r
.6634 .32866 m .59506 .31319 L .59167 .29508 L p F P
0 g
s
.657 .257 .275 r
.52251 .29029 m .59167 .29508 L .59506 .31319 L p F P
0 g
s
.656 .849 .974 r
.55665 .875 m .56048 .87148 L .59473 .87268 L p F P
0 g
s
.674 .844 .964 r
.59929 .86505 m .59473 .87268 L .56048 .87148 L p F P
0 g
s
.705 .885 .964 r
.59473 .87268 m .59929 .86505 L .63466 .85894 L p F P
0 g
s
.01 w
.23225 .53958 Mdot
.5 Mabswid
.32 .244 .612 r
.27148 .56534 m .23795 .60018 L .22943 .56817 L p F P
0 g
s
.32 .244 .612 r
.22943 .56817 m .26378 .53157 L .27148 .56534 L p F P
0 g
s
.927 .859 .753 r
.78243 .66184 m .80067 .69414 L .78028 .72267 L p F P
0 g
s
.952 .855 .708 r
.80067 .69414 m .78243 .66184 L .79836 .62962 L p F P
0 g
s
.492 .68 .949 r
.45029 .85772 m .45174 .86569 L .41652 .8599 L p F P
0 g
s
.492 .68 .949 r
.41652 .8599 m .41407 .84804 L .45029 .85772 L p F P
0 g
s
.01 w
.8214 .59105 Mdot
.23247 .6259 Mdot
.82048 .56545 Mdot
.5 Mabswid
.726 .869 .948 r
.63667 .84705 m .63466 .85894 L .59929 .86505 L p F P
0 g
s
.764 .901 .937 r
.63466 .85894 m .63667 .84705 L .67132 .83374 L p F P
0 g
s
.594 .774 .966 r
.49988 .87826 m .49451 .87527 L .52538 .86658 L closepath p F P
0 g
s
.63 .803 .966 r
.55665 .875 m .5514 .87804 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23426 .53724 Mdot
.5 Mabswid
.426 .576 .899 r
.3827 .81919 m .37945 .83505 L .34692 .81897 L p F P
0 g
s
.426 .576 .899 r
.34692 .81897 m .35046 .79932 L .3827 .81919 L p F P
0 g
s
.01 w
.23365 .62605 Mdot
.81918 .56213 Mdot
.81988 .59076 Mdot
.5 Mabswid
.942 .749 .613 r
.78345 .52874 m .81912 .56502 L .81062 .59718 L p F P
0 g
s
.955 .727 .553 r
.81912 .56502 m .78345 .52874 L .78765 .49603 L p F P
0 g
s
.657 .257 .275 r
.59506 .31319 m .52235 .30819 L .52251 .29029 L p F P
0 g
s
.814 .889 .897 r
.69963 .79771 m .70389 .81735 L .67132 .83374 L p F P
0 g
s
.85 .906 .873 r
.70389 .81735 m .69963 .79771 L .72942 .77486 L p F P
0 g
s
.01 w
.23484 .62622 Mdot
.8178 .55883 Mdot
.5 Mabswid
.433 .165 .407 r
.37334 .37896 m .31094 .40525 L .31575 .37896 L p F P
0 g
s
.433 .165 .407 r
.31575 .37896 m .3768 .35289 L .37334 .37896 L p F P
0 g
s
.01 w
.23634 .53495 Mdot
.81833 .59052 Mdot
.5 Mabswid
.595 .77 .963 r
.49451 .87527 m .49055 .87178 L .52538 .86658 L closepath p F P
0 g
s
.636 .803 .963 r
.56048 .87148 m .55665 .875 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23602 .62641 Mdot
.81633 .55553 Mdot
.5 Mabswid
.369 .429 .792 r
.30859 .72574 m .29354 .75191 L .26965 .72514 L p F P
0 g
s
.369 .429 .792 r
.26965 .72514 m .28582 .6957 L .30859 .72574 L p F P
0 g
s
.835 .494 .41 r
.66846 .35114 m .73043 .3765 L .73512 .40277 L p F P
0 g
s
.823 .434 .316 r
.73043 .3765 m .66846 .35114 L .6634 .32866 L p F P
0 g
s
.51 .186 .354 r
.44704 .3362 m .3768 .35289 L .38208 .33037 L p F P
0 g
s
.51 .186 .354 r
.38208 .33037 m .44984 .31408 L .44704 .3362 L p F P
0 g
s
.01 w
.23849 .53274 Mdot
.81677 .59033 Mdot
.23719 .62661 Mdot
.81479 .55225 Mdot
.5 Mabswid
.55 .724 .955 r
.48758 .86394 m .4882 .86795 L .45174 .86569 L p F P
0 g
s
.55 .724 .955 r
.45174 .86569 m .45029 .85772 L .48758 .86394 L p F P
0 g
s
.382 .207 .516 r
.30944 .46608 m .25955 .49896 L .25876 .46798 L p F P
0 g
s
.382 .207 .516 r
.25876 .46798 m .3088 .43442 L .30944 .46608 L p F P
0 g
s
.756 .388 .356 r
.59506 .31319 m .6634 .32866 L .66846 .35114 L p F P
0 g
s
.674 .844 .964 r
.56048 .87148 m .56269 .86762 L .59929 .86505 L p F P
0 g
s
.687 .835 .954 r
.60044 .85706 m .59929 .86505 L .56269 .86762 L p F P
0 g
s
.726 .869 .948 r
.59929 .86505 m .60044 .85706 L .63667 .84705 L p F P
0 g
s
.477 .627 .918 r
.41683 .83609 m .41407 .84804 L .37945 .83505 L p F P
0 g
s
.477 .627 .918 r
.37945 .83505 m .3827 .81919 L .41683 .83609 L p F P
0 g
s
.01 w
.23837 .62682 Mdot
.5 Mabswid
.901 .859 .791 r
.76302 .69335 m .78028 .72267 L .75642 .74971 L p F P
0 g
s
.927 .859 .753 r
.78028 .72267 m .76302 .69335 L .78243 .66184 L p F P
0 g
s
.01 w
.81317 .54899 Mdot
.81519 .59018 Mdot
.2407 .53059 Mdot
.5 Mabswid
.597 .766 .96 r
.49055 .87178 m .4882 .86795 L .52538 .86658 L closepath p F P
0 g
s
.642 .801 .96 r
.56269 .86762 m .56048 .87148 L .52538 .86658 L closepath p F P
0 g
s
.777 .869 .916 r
.66748 .8179 m .67132 .83374 L .63667 .84705 L p F P
0 g
s
.814 .889 .897 r
.67132 .83374 m .66748 .8179 L .69963 .79771 L p F P
0 g
s
.01 w
.23954 .62704 Mdot
.5 Mabswid
.901 .631 .519 r
.7372 .43195 m .78844 .46498 L .78765 .49603 L p F P
0 g
s
.904 .594 .448 r
.78844 .46498 m .7372 .43195 L .73512 .40277 L p F P
0 g
s
.01 w
.81147 .54576 Mdot
.81359 .59008 Mdot
.2407 .62727 Mdot
.5 Mabswid
.366 .311 .663 r
.28259 .59976 m .25028 .63243 L .23795 .60018 L p F P
0 g
s
.366 .311 .663 r
.23795 .60018 m .27148 .56534 L .28259 .59976 L p F P
0 g
s
.01 w
.24298 .52851 Mdot
.80968 .54254 Mdot
.24185 .6275 Mdot
.81198 .59002 Mdot
.5 Mabswid
.523 .674 .933 r
.45235 .84974 m .45029 .85772 L .41407 .84804 L p F P
0 g
s
.523 .674 .933 r
.41407 .84804 m .41683 .83609 L .45235 .84974 L p F P
0 g
s
.601 .763 .956 r
.4882 .86795 m .48758 .86394 L .52538 .86658 L closepath p F P
0 g
s
.412 .484 .824 r
.33428 .75408 m .3206 .77677 L .29354 .75191 L p F P
0 g
s
.412 .484 .824 r
.29354 .75191 m .30859 .72574 L .33428 .75408 L p F P
0 g
s
.01 w
.80782 .53935 Mdot
.24533 .52651 Mdot
.5 Mabswid
.646 .799 .956 r
.56316 .86361 m .56269 .86762 L .52538 .86658 L closepath p F P
0 g
s
.687 .835 .954 r
.56269 .86762 m .56316 .86361 L .60044 .85706 L p F P
0 g
s
.01 w
.243 .62774 Mdot
.5 Mabswid
.926 .766 .663 r
.77583 .56264 m .81062 .59718 L .79836 .62962 L p F P
0 g
s
.942 .749 .613 r
.81062 .59718 m .77583 .56264 L .78345 .52874 L p F P
0 g
s
.737 .847 .932 r
.63346 .83511 m .63667 .84705 L .60044 .85706 L p F P
0 g
s
.777 .869 .916 r
.63667 .84705 m .63346 .83511 L .66748 .8179 L p F P
0 g
s
.01 w
.81035 .59 Mdot
.24413 .62798 Mdot
.80587 .53619 Mdot
.5 Mabswid
.873 .856 .822 r
.7404 .72365 m .75642 .74971 L .72942 .77486 L p F P
0 g
s
.901 .859 .791 r
.75642 .74971 m .7404 .72365 L .76302 .69335 L p F P
0 g
s
.01 w
.24774 .52457 Mdot
.5 Mabswid
.565 .718 .944 r
.48872 .85995 m .48758 .86394 L .45029 .85772 L p F P
0 g
s
.565 .718 .944 r
.45029 .85772 m .45235 .84974 L .48872 .85995 L p F P
0 g
s
.01 w
.24525 .62823 Mdot
.80871 .59002 Mdot
.80383 .53307 Mdot
.5 Mabswid
.695 .823 .944 r
.59808 .84909 m .60044 .85706 L .56316 .86361 L p F P
0 g
s
.737 .847 .932 r
.60044 .85706 m .59808 .84909 L .63346 .83511 L p F P
0 g
s
.01 w
.24635 .62847 Mdot
.5 Mabswid
.652 .787 .946 r
.55424 .85251 m .55885 .85586 L .52538 .86658 L closepath p F P
0 g
s
.611 .758 .949 r
.48872 .85995 m .4916 .85616 L .52538 .86658 L closepath p F P
0 g
s
.606 .76 .953 r
.48758 .86394 m .48872 .85995 L .52538 .86658 L closepath p F P
0 g
s
.65 .795 .952 r
.56187 .85963 m .56316 .86361 L .52538 .86658 L closepath p F P
0 g
s
.652 .791 .949 r
.55885 .85586 m .56187 .85963 L .52538 .86658 L closepath p F P
0 g
s
.652 .782 .943 r
.54824 .84971 m .55424 .85251 L .52538 .86658 L closepath p F P
0 g
s
.65 .777 .941 r
.54114 .84762 m .54824 .84971 L .52538 .86658 L closepath p F P
0 g
s
.647 .772 .94 r
.53328 .84634 m .54114 .84762 L .52538 .86658 L closepath p F P
0 g
s
.644 .768 .939 r
.52503 .84593 m .53328 .84634 L .52538 .86658 L closepath p F P
0 g
s
.639 .765 .939 r
.5168 .84641 m .52503 .84593 L .52538 .86658 L closepath p F P
0 g
s
.634 .762 .94 r
.50899 .84776 m .5168 .84641 L .52538 .86658 L closepath p F P
0 g
s
.628 .759 .941 r
.50197 .84992 m .50899 .84776 L .52538 .86658 L closepath p F P
0 g
s
.622 .758 .943 r
.49608 .85276 m .50197 .84992 L .52538 .86658 L closepath p F P
0 g
s
.617 .758 .946 r
.4916 .85616 m .49608 .85276 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.2502 .52271 Mdot
.5 Mabswid
.695 .823 .944 r
.56316 .86361 m .56187 .85963 L .59808 .84909 L p F P
0 g
s
.01 w
.80707 .59007 Mdot
.80172 .52997 Mdot
.24744 .62871 Mdot
.5 Mabswid
.452 .535 .852 r
.36251 .78027 m .35046 .79932 L .3206 .77677 L p F P
0 g
s
.452 .535 .852 r
.3206 .77677 m .33428 .75408 L .36251 .78027 L p F P
0 g
s
.607 .269 .372 r
.52223 .33016 m .44704 .3362 L .44984 .31408 L p F P
0 g
s
.607 .269 .372 r
.44984 .31408 m .52235 .30819 L .52223 .33016 L p F P
0 g
s
.01 w
.24852 .62894 Mdot
.80542 .59017 Mdot
.79952 .52692 Mdot
.25273 .52093 Mdot
.5 Mabswid
.756 .388 .356 r
.66846 .35114 m .59763 .33528 L .59506 .31319 L p F P
0 g
s
.686 .334 .373 r
.52235 .30819 m .59506 .31319 L .59763 .33528 L p F P
0 g
s
.01 w
.24957 .62916 Mdot
.5 Mabswid
.473 .24 .479 r
.3718 .40828 m .3088 .43442 L .31094 .40525 L p F P
0 g
s
.473 .24 .479 r
.31094 .40525 m .37334 .37896 L .3718 .40828 L p F P
0 g
s
.404 .368 .705 r
.29699 .63431 m .2663 .66443 L .25028 .63243 L p F P
0 g
s
.404 .368 .705 r
.25028 .63243 m .28259 .59976 L .29699 .63431 L p F P
0 g
s
.843 .851 .85 r
.71488 .75228 m .72942 .77486 L .69963 .79771 L p F P
0 g
s
.873 .856 .822 r
.72942 .77486 m .71488 .75228 L .7404 .72365 L p F P
0 g
s
.421 .274 .574 r
.31294 .49983 m .26378 .53157 L .25955 .49896 L p F P
0 g
s
.421 .274 .574 r
.25955 .49896 m .30944 .46608 L .31294 .49983 L p F P
0 g
s
.01 w
.79723 .5239 Mdot
.25061 .62938 Mdot
.80376 .5903 Mdot
.5 Mabswid
.582 .715 .934 r
.4916 .85616 m .48872 .85995 L .45235 .84974 L p F P
0 g
s
.699 .81 .934 r
.56187 .85963 m .55885 .85586 L .59224 .84152 L p F P
0 g
s
.699 .81 .934 r
.59224 .84152 m .59808 .84909 L .56187 .85963 L p F P
0 g
s
.01 w
.25532 .51922 Mdot
.25163 .62958 Mdot
.5 Mabswid
.839 .539 .482 r
.67178 .37719 m .73512 .40277 L .7372 .43195 L p F P
0 g
s
.835 .494 .41 r
.73512 .40277 m .67178 .37719 L .66846 .35114 L p F P
0 g
s
.487 .583 .876 r
.39285 .80391 m .3827 .81919 L .35046 .79932 L p F P
0 g
s
.487 .583 .876 r
.35046 .79932 m .36251 .78027 L .39285 .80391 L p F P
0 g
s
.01 w
.79487 .52093 Mdot
.8021 .59045 Mdot
.5 Mabswid
.908 .778 .705 r
.76485 .59724 m .79836 .62962 L .78243 .66184 L p F P
0 g
s
.926 .766 .663 r
.79836 .62962 m .76485 .59724 L .77583 .56264 L p F P
0 g
s
.894 .659 .576 r
.73655 .46367 m .78765 .49603 L .78345 .52874 L p F P
0 g
s
.901 .631 .519 r
.78765 .49603 m .73655 .46367 L .7372 .43195 L p F P
0 g
s
.01 w
.25263 .62978 Mdot
.5 Mabswid
.686 .334 .373 r
.59763 .33528 m .52223 .33016 L .52235 .30819 L p F P
0 g
s
.01 w
.25796 .51759 Mdot
.25361 .62995 Mdot
.5 Mabswid
.812 .844 .874 r
.68685 .77876 m .69963 .79771 L .66748 .8179 L p F P
0 g
s
.843 .851 .85 r
.69963 .79771 m .68685 .77876 L .71488 .75228 L p F P
0 g
s
.582 .715 .934 r
.45235 .84974 m .4579 .84212 L .4916 .85616 L p F P
0 g
s
.552 .672 .917 r
.4579 .84212 m .45235 .84974 L .41683 .83609 L p F P
0 g
s
.01 w
.80044 .59064 Mdot
.79242 .518 Mdot
.5 Mabswid
.546 .261 .434 r
.44519 .3621 m .37334 .37896 L .3768 .35289 L p F P
0 g
s
.546 .261 .434 r
.3768 .35289 m .44704 .3362 L .44519 .3621 L p F P
0 g
s
.521 .628 .898 r
.42481 .82462 m .41683 .83609 L .3827 .81919 L p F P
0 g
s
.521 .628 .898 r
.3827 .81919 m .39285 .80391 L .42481 .82462 L p F P
0 g
s
.01 w
.25456 .63012 Mdot
.5 Mabswid
.741 .824 .916 r
.59808 .84909 m .59224 .84152 L .62505 .82372 L p F P
0 g
s
.741 .824 .916 r
.62505 .82372 m .63346 .83511 L .59808 .84909 L p F P
0 g
s
.552 .672 .917 r
.41683 .83609 m .42481 .82462 L .4579 .84212 L p F P
0 g
s
.598 .714 .925 r
.49608 .85276 m .4916 .85616 L .4579 .84212 L p F P
0 g
s
.01 w
.2555 .63026 Mdot
.5 Mabswid
.699 .795 .925 r
.55885 .85586 m .55424 .85251 L .58316 .83472 L p F P
0 g
s
.699 .795 .925 r
.58316 .83472 m .59224 .84152 L .55885 .85586 L p F P
0 g
s
.769 .444 .436 r
.59763 .33528 m .66846 .35114 L .67178 .37719 L p F P
0 g
s
.01 w
.79879 .59086 Mdot
.5 Mabswid
.778 .835 .896 r
.65675 .8027 m .66748 .8179 L .63346 .83511 L p F P
0 g
s
.812 .844 .874 r
.66748 .8179 m .65675 .8027 L .68685 .77876 L p F P
0 g
s
.01 w
.7899 .51513 Mdot
.26065 .51604 Mdot
.5 Mabswid
.778 .835 .896 r
.63346 .83511 m .62505 .82372 L .65675 .8027 L p F P
0 g
s
.01 w
.25641 .63038 Mdot
.2573 .63048 Mdot
.79713 .59111 Mdot
.78729 .5123 Mdot
.5 Mabswid
.437 .42 .742 r
.3145 .66843 m .28582 .6957 L .2663 .66443 L p F P
0 g
s
.437 .42 .742 r
.2663 .66443 m .29699 .63431 L .3145 .66843 L p F P
0 g
s
.01 w
.25816 .63056 Mdot
.26339 .51456 Mdot
.25901 .63061 Mdot
.79549 .59138 Mdot
.5 Mabswid
.615 .716 .918 r
.50197 .84992 m .49608 .85276 L .46671 .83525 L p F P
0 g
s
.598 .714 .925 r
.4579 .84212 m .46671 .83525 L .49608 .85276 L p F P
0 g
s
.696 .781 .917 r
.55424 .85251 m .54824 .84971 L .57125 .82905 L p F P
0 g
s
.696 .781 .917 r
.57125 .82905 m .58316 .83472 L .55424 .85251 L p F P
0 g
s
.01 w
.7846 .50953 Mdot
.25982 .63064 Mdot
.26062 .63064 Mdot
.26619 .51317 Mdot
.79385 .59167 Mdot
.5 Mabswid
.889 .786 .741 r
.75061 .63198 m .78243 .66184 L .76302 .69335 L p F P
0 g
s
.908 .778 .705 r
.78243 .66184 m .75061 .63198 L .76485 .59724 L p F P
0 g
s
.01 w
.26139 .6306 Mdot
.78183 .50681 Mdot
.26214 .63054 Mdot
.79221 .59198 Mdot
.5 Mabswid
.453 .33 .622 r
.31931 .53515 m .27148 .56534 L .26378 .53157 L p F P
0 g
s
.453 .33 .622 r
.26378 .53157 m .31294 .49983 L .31931 .53515 L p F P
0 g
s
.63 .72 .912 r
.50899 .84776 m .50197 .84992 L .47841 .82947 L p F P
0 g
s
.615 .716 .918 r
.46671 .83525 m .47841 .82947 L .50197 .84992 L p F P
0 g
s
.579 .673 .903 r
.46671 .83525 m .4579 .84212 L .42481 .82462 L p F P
0 g
s
.01 w
.26286 .63044 Mdot
.5 Mabswid
.69 .768 .911 r
.54824 .84971 m .54114 .84762 L .55705 .82478 L p F P
0 g
s
.69 .768 .911 r
.55705 .82478 m .57125 .82905 L .54824 .84971 L p F P
0 g
s
.01 w
.26903 .51185 Mdot
.77898 .50415 Mdot
.26356 .6303 Mdot
.5 Mabswid
.738 .8 .902 r
.59224 .84152 m .58316 .83472 L .61172 .81344 L p F P
0 g
s
.738 .8 .902 r
.61172 .81344 m .62505 .82372 L .59224 .84152 L p F P
0 g
s
.01 w
.79059 .59232 Mdot
.26424 .63013 Mdot
.26489 .62993 Mdot
.5 Mabswid
.466 .467 .774 r
.33486 .70158 m .30859 .72574 L .28582 .6957 L p F P
0 g
s
.466 .467 .774 r
.28582 .6957 m .3145 .66843 L .33486 .70158 L p F P
0 g
s
.645 .726 .907 r
.5168 .84641 m .50899 .84776 L .49244 .82508 L p F P
0 g
s
.63 .72 .912 r
.47841 .82947 m .49244 .82508 L .50899 .84776 L p F P
0 g
s
.884 .681 .623 r
.73311 .49749 m .78345 .52874 L .77583 .56264 L p F P
0 g
s
.894 .659 .576 r
.78345 .52874 m .73311 .49749 L .73655 .46367 L p F P
0 g
s
.01 w
.77606 .50155 Mdot
.27191 .51062 Mdot
.5 Mabswid
.681 .755 .907 r
.54114 .84762 m .53328 .84634 L .54126 .82216 L p F P
0 g
s
.681 .755 .907 r
.54126 .82216 m .55705 .82478 L .54114 .84762 L p F P
0 g
s
.01 w
.26552 .62968 Mdot
.78898 .59266 Mdot
.5 Mabswid
.502 .3 .537 r
.37226 .44048 m .30944 .46608 L .3088 .43442 L p F P
0 g
s
.502 .3 .537 r
.3088 .43442 m .3718 .40828 L .37226 .44048 L p F P
0 g
s
.01 w
.26613 .62939 Mdot
.26672 .62907 Mdot
.5 Mabswid
.658 .734 .905 r
.52503 .84593 m .5168 .84641 L .50812 .82231 L p F P
0 g
s
.645 .726 .907 r
.49244 .82508 m .50812 .82231 L .5168 .84641 L p F P
0 g
s
.671 .744 .905 r
.53328 .84634 m .52503 .84593 L .52467 .82132 L p F P
0 g
s
.671 .744 .905 r
.52467 .82132 m .54126 .82216 L .53328 .84634 L p F P
0 g
s
.01 w
.78739 .59303 Mdot
.77306 .49901 Mdot
.26728 .62869 Mdot
.5 Mabswid
.658 .734 .905 r
.50812 .82231 m .52467 .82132 L .52503 .84593 L p F P
0 g
s
.869 .793 .773 r
.73331 .66633 m .76302 .69335 L .7404 .72365 L p F P
0 g
s
.889 .786 .741 r
.76302 .69335 m .73331 .66633 L .75061 .63198 L p F P
0 g
s
.01 w
.27483 .50946 Mdot
.26783 .62828 Mdot
.5 Mabswid
.838 .573 .538 r
.67324 .40652 m .7372 .43195 L .73655 .46367 L p F P
0 g
s
.839 .539 .482 r
.7372 .43195 m .67324 .40652 L .67178 .37719 L p F P
0 g
s
.01 w
.26836 .62782 Mdot
.78581 .5934 Mdot
.5 Mabswid
.579 .673 .903 r
.42481 .82462 m .43774 .81423 L .46671 .83525 L p F P
0 g
s
.559 .632 .88 r
.43774 .81423 m .42481 .82462 L .39285 .80391 L p F P
0 g
s
.631 .333 .446 r
.52214 .35601 m .44519 .3621 L .44704 .3362 L p F P
0 g
s
.631 .333 .446 r
.44704 .3362 m .52223 .33016 L .52214 .35601 L p F P
0 g
s
.01 w
.26887 .62731 Mdot
.26887 .62731 Mdot
.76999 .49654 Mdot
.26936 .62675 Mdot
.5 Mabswid
.771 .802 .879 r
.62505 .82372 m .61172 .81344 L .63944 .78891 L p F P
0 g
s
.771 .802 .879 r
.63944 .78891 m .65675 .8027 L .62505 .82372 L p F P
0 g
s
.769 .444 .436 r
.67178 .37719 m .59931 .36118 L .59763 .33528 L p F P
0 g
s
.703 .391 .447 r
.52223 .33016 m .59763 .33528 L .59931 .36118 L p F P
0 g
s
.01 w
.78425 .59379 Mdot
.26984 .62615 Mdot
.27779 .50839 Mdot
.5 Mabswid
.492 .51 .804 r
.35775 .73322 m .33428 .75408 L .30859 .72574 L p F P
0 g
s
.492 .51 .804 r
.30859 .72574 m .33486 .70158 L .35775 .73322 L p F P
0 g
s
.01 w
.2703 .62549 Mdot
.27074 .62479 Mdot
.5 Mabswid
.605 .676 .891 r
.47841 .82947 m .46671 .83525 L .43774 .81423 L p F P
0 g
s
.01 w
.76684 .49414 Mdot
.7827 .59418 Mdot
.27117 .62403 Mdot
.5 Mabswid
.73 .777 .891 r
.58316 .83472 m .57125 .82905 L .59405 .80481 L p F P
0 g
s
.73 .777 .891 r
.59405 .80481 m .61172 .81344 L .58316 .83472 L p F P
0 g
s
.01 w
.2716 .62322 Mdot
.5 Mabswid
.559 .632 .88 r
.39285 .80391 m .40962 .78998 L .43774 .81423 L p F P
0 g
s
.538 .592 .856 r
.40962 .78998 m .39285 .80391 L .36251 .78027 L p F P
0 g
s
.01 w
.28079 .50739 Mdot
.5 Mabswid
.848 .798 .802 r
.71321 .69972 m .7404 .72365 L .71488 .75228 L p F P
0 g
s
.869 .793 .773 r
.7404 .72365 m .71321 .69972 L .73331 .66633 L p F P
0 g
s
.01 w
.27201 .62236 Mdot
.78117 .59458 Mdot
.27241 .62145 Mdot
.5 Mabswid
.516 .551 .831 r
.38281 .76284 m .36251 .78027 L .33428 .75408 L p F P
0 g
s
.516 .551 .831 r
.33428 .75408 m .35775 .73322 L .38281 .76284 L p F P
0 g
s
.01 w
.76362 .49181 Mdot
.5 Mabswid
.571 .32 .497 r
.44436 .39151 m .3718 .40828 L .37334 .37896 L p F P
0 g
s
.571 .32 .497 r
.37334 .37896 m .44519 .3621 L .44436 .39151 L p F P
0 g
s
.01 w
.27281 .62048 Mdot
.5 Mabswid
.799 .802 .854 r
.65675 .8027 m .63944 .78891 L .66589 .7615 L p F P
0 g
s
.799 .802 .854 r
.66589 .7615 m .68685 .77876 L .65675 .8027 L p F P
0 g
s
.538 .592 .856 r
.36251 .78027 m .38281 .76284 L .40962 .78998 L p F P
0 g
s
.01 w
.2732 .61946 Mdot
.5 Mabswid
.479 .378 .663 r
.32848 .5715 m .28259 .59976 L .27148 .56534 L p F P
0 g
s
.479 .378 .663 r
.27148 .56534 m .31931 .53515 L .32848 .5715 L p F P
0 g
s
.01 w
.77967 .59498 Mdot
.5 Mabswid
.703 .391 .447 r
.59931 .36118 m .52214 .35601 L .52223 .33016 L p F P
0 g
s
.01 w
.27358 .61838 Mdot
.28382 .50648 Mdot
.5 Mabswid
.776 .487 .498 r
.59931 .36118 m .67178 .37719 L .67324 .40652 L p F P
0 g
s
.01 w
.27396 .61725 Mdot
.76033 .48955 Mdot
.5 Mabswid
.825 .801 .829 r
.69061 .73162 m .71488 .75228 L .68685 .77876 L p F P
0 g
s
.848 .798 .802 r
.71488 .75228 m .69061 .73162 L .71321 .69972 L p F P
0 g
s
.01 w
.77818 .59539 Mdot
.27435 .61607 Mdot
.5 Mabswid
.825 .801 .829 r
.68685 .77876 m .66589 .7615 L .69061 .73162 L p F P
0 g
s
.01 w
.27473 .61482 Mdot
.27511 .61352 Mdot
.77672 .5958 Mdot
.2755 .61217 Mdot
.5 Mabswid
.873 .699 .663 r
.72687 .53293 m .77583 .56264 L .76485 .59724 L p F P
0 g
s
.884 .681 .623 r
.77583 .56264 m .72687 .53293 L .73311 .49749 L p F P
0 g
s
.01 w
.28689 .50564 Mdot
.75698 .48736 Mdot
.2759 .61076 Mdot
.2763 .60929 Mdot
.77528 .5962 Mdot
.27672 .60776 Mdot
.5 Mabswid
.629 .683 .882 r
.49244 .82508 m .47841 .82947 L .45507 .80545 L p F P
0 g
s
.605 .676 .891 r
.43774 .81423 m .45507 .80545 L .47841 .82947 L p F P
0 g
s
.01 w
.27714 .60618 Mdot
.5 Mabswid
.719 .756 .882 r
.57125 .82905 m .55705 .82478 L .57286 .79831 L p F P
0 g
s
.719 .756 .882 r
.57286 .79831 m .59405 .80481 L .57125 .82905 L p F P
0 g
s
.01 w
.77387 .5966 Mdot
.75356 .48525 Mdot
.27758 .60455 Mdot
.28998 .50488 Mdot
.27804 .60286 Mdot
.77248 .59699 Mdot
.27851 .60111 Mdot
.279 .59931 Mdot
.75007 .48321 Mdot
.75007 .48322 Mdot
.27952 .59745 Mdot
.5 Mabswid
.526 .349 .585 r
.37477 .47512 m .31294 .49983 L .30944 .46608 L p F P
0 g
s
.526 .349 .585 r
.30944 .46608 m .37226 .44048 L .37477 .47512 L p F P
0 g
s
.594 .639 .865 r
.45507 .80545 m .43774 .81423 L .40962 .78998 L p F P
0 g
s
.01 w
.77111 .59737 Mdot
.2931 .50421 Mdot
.28006 .59554 Mdot
.28063 .59358 Mdot
.5 Mabswid
.758 .772 .864 r
.61172 .81344 m .59405 .80481 L .61627 .7773 L p F P
0 g
s
.758 .772 .864 r
.61627 .7773 m .63944 .78891 L .61172 .81344 L p F P
0 g
s
.01 w
.76978 .59775 Mdot
.28122 .59156 Mdot
.74653 .48126 Mdot
.28185 .58949 Mdot
.76847 .59811 Mdot
.5 Mabswid
.501 .422 .698 r
.34034 .60831 m .29699 .63431 L .28259 .59976 L p F P
0 g
s
.501 .422 .698 r
.28259 .59976 m .32848 .5715 L .34034 .60831 L p F P
0 g
s
.834 .601 .585 r
.67278 .43875 m .73655 .46367 L .73311 .49749 L p F P
0 g
s
.838 .573 .538 r
.73655 .46367 m .67278 .43875 L .67324 .40652 L p F P
0 g
s
.65 .693 .876 r
.50812 .82231 m .49244 .82508 L .47599 .79876 L p F P
0 g
s
.629 .683 .882 r
.45507 .80545 m .47599 .79876 L .49244 .82508 L p F P
0 g
s
.01 w
.29624 .50361 Mdot
.28251 .58737 Mdot
.5 Mabswid
.705 .737 .876 r
.55705 .82478 m .54126 .82216 L .54921 .7943 L p F P
0 g
s
.705 .737 .876 r
.54921 .7943 m .57286 .79831 L .55705 .82478 L p F P
0 g
s
.01 w
.76718 .59845 Mdot
.2832 .5852 Mdot
.74292 .47939 Mdot
.28393 .58299 Mdot
.76593 .59878 Mdot
.2847 .58072 Mdot
.2994 .50309 Mdot
.28551 .57841 Mdot
.5 Mabswid
.861 .714 .698 r
.71788 .56943 m .76485 .59724 L .75061 .63198 L p F P
0 g
s
.873 .699 .663 r
.76485 .59724 m .71788 .56943 L .72687 .53293 L p F P
0 g
s
.01 w
.7647 .59909 Mdot
.28637 .57605 Mdot
.73926 .47759 Mdot
.5 Mabswid
.67 .705 .873 r
.52467 .82132 m .50812 .82231 L .49948 .79453 L p F P
0 g
s
.65 .693 .876 r
.47599 .79876 m .49948 .79453 L .50812 .82231 L p F P
0 g
s
.01 w
.7635 .59938 Mdot
.5 Mabswid
.689 .72 .873 r
.54126 .82216 m .52467 .82132 L .52432 .79302 L p F P
0 g
s
.689 .72 .873 r
.52432 .79302 m .54921 .7943 L .54126 .82216 L p F P
0 g
s
.01 w
.28727 .57365 Mdot
.28822 .57121 Mdot
.76233 .59965 Mdot
.30257 .50265 Mdot
.5 Mabswid
.67 .705 .873 r
.49948 .79453 m .52432 .79302 L .52467 .82132 L p F P
0 g
s
.01 w
.28922 .56872 Mdot
.73554 .47588 Mdot
.76119 .5999 Mdot
.5 Mabswid
.647 .382 .504 r
.5221 .38546 m .44436 .39151 L .44519 .3621 L p F P
0 g
s
.647 .382 .504 r
.44519 .3621 m .52214 .35601 L .5221 .38546 L p F P
0 g
s
.594 .639 .865 r
.40962 .78998 m .43233 .77816 L .45507 .80545 L p F P
0 g
s
.581 .603 .84 r
.43233 .77816 m .40962 .78998 L .38281 .76284 L p F P
0 g
s
.01 w
.29027 .5662 Mdot
.76008 .60012 Mdot
.5 Mabswid
.776 .487 .498 r
.67324 .40652 m .60006 .3906 L .59931 .36118 L p F P
0 g
s
.714 .436 .504 r
.52214 .35601 m .59931 .36118 L .60006 .3906 L p F P
0 g
s
.01 w
.29137 .56363 Mdot
.30577 .50228 Mdot
.5 Mabswid
.781 .765 .838 r
.63944 .78891 m .61627 .7773 L .63755 .74691 L p F P
0 g
s
.781 .765 .838 r
.63755 .74691 m .66589 .7615 L .63944 .78891 L p F P
0 g
s
.01 w
.759 .60031 Mdot
.29254 .56103 Mdot
.73177 .47426 Mdot
.5 Mabswid
.521 .461 .73 r
.35474 .64496 m .3145 .66843 L .29699 .63431 L p F P
0 g
s
.521 .461 .73 r
.29699 .63431 m .34034 .60831 L .35474 .64496 L p F P
0 g
s
.589 .367 .547 r
.4446 .42406 m .37226 .44048 L .3718 .40828 L p F P
0 g
s
.589 .367 .547 r
.3718 .40828 m .44436 .39151 L .4446 .42406 L p F P
0 g
s
.01 w
.75794 .60047 Mdot
.29375 .5584 Mdot
.75691 .6006 Mdot
.5 Mabswid
.624 .649 .854 r
.47599 .79876 m .45507 .80545 L .43233 .77816 L p F P
0 g
s
.01 w
.29503 .55573 Mdot
.30897 .50199 Mdot
.72795 .47272 Mdot
.5 Mabswid
.779 .522 .548 r
.60006 .3906 m .67324 .40652 L .67278 .43875 L p F P
0 g
s
.01 w
.75591 .6007 Mdot
.29638 .55303 Mdot
.5 Mabswid
.741 .744 .854 r
.59405 .80481 m .57286 .79831 L .58832 .76852 L p F P
0 g
s
.741 .744 .854 r
.58832 .76852 m .61627 .7773 L .59405 .80481 L p F P
0 g
s
.848 .726 .729 r
.70626 .6064 m .75061 .63198 L .73331 .66633 L p F P
0 g
s
.861 .714 .698 r
.75061 .63198 m .70626 .6064 L .71788 .56943 L p F P
0 g
s
.01 w
.75494 .60076 Mdot
.29778 .55031 Mdot
.75399 .60079 Mdot
.29925 .54755 Mdot
.72408 .47127 Mdot
.5 Mabswid
.545 .392 .625 r
.37934 .51167 m .31931 .53515 L .31294 .49983 L p F P
0 g
s
.545 .392 .625 r
.31294 .49983 m .37477 .47512 L .37934 .51167 L p F P
0 g
s
.01 w
.31219 .50177 Mdot
.5 Mabswid
.581 .603 .84 r
.38281 .76284 m .41056 .74799 L .43233 .77816 L p F P
0 g
s
.568 .568 .813 r
.41056 .74799 m .38281 .76284 L .35775 .73322 L p F P
0 g
s
.01 w
.75307 .60078 Mdot
.5 Mabswid
.714 .436 .504 r
.60006 .3906 m .5221 .38546 L .52214 .35601 L p F P
0 g
s
.01 w
.30079 .54478 Mdot
.75217 .60073 Mdot
.5 Mabswid
.538 .498 .759 r
.37143 .68085 m .33486 .70158 L .3145 .66843 L p F P
0 g
s
.538 .498 .759 r
.3145 .66843 m .35474 .64496 L .37143 .68085 L p F P
0 g
s
.01 w
.3024 .54198 Mdot
.7513 .60064 Mdot
.5 Mabswid
.801 .757 .812 r
.66589 .7615 m .63755 .74691 L .65751 .71408 L p F P
0 g
s
.801 .757 .812 r
.65751 .71408 m .69061 .73162 L .66589 .7615 L p F P
0 g
s
.01 w
.72017 .46991 Mdot
.30407 .53915 Mdot
.75045 .60051 Mdot
.31541 .50163 Mdot
.5 Mabswid
.829 .624 .625 r
.67034 .47345 m .73311 .49749 L .72687 .53293 L p F P
0 g
s
.834 .601 .585 r
.73311 .49749 m .67034 .47345 L .67278 .43875 L p F P
0 g
s
.01 w
.74962 .60034 Mdot
.30582 .53632 Mdot
.5 Mabswid
.568 .568 .813 r
.35775 .73322 m .39015 .71538 L .41056 .74799 L p F P
0 g
s
.554 .534 .787 r
.39015 .71538 m .35775 .73322 L .33486 .70158 L p F P
0 g
s
.01 w
.74882 .60012 Mdot
.5 Mabswid
.554 .534 .787 r
.33486 .70158 m .37143 .68085 L .39015 .71538 L p F P
0 g
s
.834 .738 .758 r
.69216 .64324 m .73331 .66633 L .71321 .69972 L p F P
0 g
s
.848 .726 .729 r
.73331 .66633 m .69216 .64324 L .70626 .6064 L p F P
0 g
s
.01 w
.30764 .53346 Mdot
.74804 .59986 Mdot
.71621 .46863 Mdot
.31863 .50156 Mdot
.74727 .59955 Mdot
.30954 .53059 Mdot
.74653 .59919 Mdot
.5 Mabswid
.818 .748 .786 r
.69061 .73162 m .65751 .71408 L .67582 .67933 L p F P
0 g
s
.818 .748 .786 r
.67582 .67933 m .71321 .69972 L .69061 .73162 L p F P
0 g
s
.01 w
.31152 .52772 Mdot
.7458 .59879 Mdot
.7458 .59879 Mdot
.5 Mabswid
.834 .738 .758 r
.71321 .69972 m .67582 .67933 L .69216 .64324 L p F P
0 g
s
.01 w
.71222 .46745 Mdot
.74509 .59833 Mdot
.5 Mabswid
.652 .662 .847 r
.49948 .79453 m .47599 .79876 L .45992 .76913 L p F P
0 g
s
.624 .649 .854 r
.43233 .77816 m .45992 .76913 L .47599 .79876 L p F P
0 g
s
.01 w
.31357 .52483 Mdot
.32186 .50155 Mdot
.74439 .59782 Mdot
.5 Mabswid
.722 .719 .847 r
.57286 .79831 m .54921 .7943 L .557 .7631 L p F P
0 g
s
.722 .719 .847 r
.557 .7631 m .58832 .76852 L .57286 .79831 L p F P
0 g
s
.01 w
.74371 .59726 Mdot
.3157 .52194 Mdot
.74303 .59665 Mdot
.70819 .46636 Mdot
.31791 .51905 Mdot
.74237 .59599 Mdot
.32508 .50162 Mdot
.74172 .59527 Mdot
.3202 .51615 Mdot
.74107 .5945 Mdot
.74042 .59368 Mdot
.5 Mabswid
.619 .617 .827 r
.45992 .76913 m .43233 .77816 L .41056 .74799 L p F P
0 g
s
.01 w
.32257 .51326 Mdot
.70413 .46535 Mdot
.73979 .5928 Mdot
.73915 .59186 Mdot
.3283 .50175 Mdot
.32502 .51038 Mdot
.5 Mabswid
.759 .731 .826 r
.61627 .7773 m .58832 .76852 L .60316 .73583 L p F P
0 g
s
.759 .731 .826 r
.60316 .73583 m .63755 .74691 L .61627 .7773 L p F P
0 g
s
.01 w
.73851 .59087 Mdot
.73787 .58982 Mdot
.32756 .5075 Mdot
.73722 .58872 Mdot
.5 Mabswid
.678 .678 .843 r
.52432 .79302 m .49948 .79453 L .49102 .76341 L p F P
0 g
s
.652 .662 .847 r
.45992 .76913 m .49102 .76341 L .49948 .79453 L p F P
0 g
s
.01 w
.70005 .46444 Mdot
.5 Mabswid
.56 .43 .66 r
.38593 .54956 m .32848 .5715 L .31931 .53515 L p F P
0 g
s
.56 .43 .66 r
.31931 .53515 m .37934 .51167 L .38593 .54956 L p F P
0 g
s
.701 .697 .843 r
.54921 .7943 m .52432 .79302 L .52397 .76136 L p F P
0 g
s
.701 .697 .843 r
.52397 .76136 m .557 .7631 L .54921 .7943 L p F P
0 g
s
.01 w
.73657 .58756 Mdot
.33018 .50463 Mdot
.33151 .50195 Mdot
.73591 .58635 Mdot
.5 Mabswid
.604 .408 .589 r
.44594 .45928 m .37477 .47512 L .37226 .44048 L p F P
0 g
s
.604 .408 .589 r
.37226 .44048 m .4446 .42406 L .44594 .45928 L p F P
0 g
s
.01 w
.73524 .58507 Mdot
.33289 .50178 Mdot
.73456 .58375 Mdot
.5 Mabswid
.659 .423 .551 r
.5221 .41813 m .4446 .42406 L .44436 .39151 L p F P
0 g
s
.659 .423 .551 r
.44436 .39151 m .5221 .38546 L .5221 .41813 L p F P
0 g
s
.01 w
.69593 .46362 Mdot
.5 Mabswid
.678 .678 .843 r
.49102 .76341 m .52397 .76136 L .52432 .79302 L p F P
0 g
s
.01 w
.73387 .58236 Mdot
.33568 .49895 Mdot
.5 Mabswid
.823 .643 .66 r
.66593 .51009 m .72687 .53293 L .71788 .56943 L p F P
0 g
s
.829 .624 .625 r
.72687 .53293 m .66593 .51009 L .67034 .47345 L p F P
0 g
s
.01 w
.73315 .58092 Mdot
.5 Mabswid
.779 .522 .548 r
.67278 .43875 m .59982 .42316 L .60006 .3906 L p F P
0 g
s
.72 .473 .551 r
.5221 .38546 m .60006 .3906 L .59982 .42316 L p F P
0 g
s
.01 w
.33472 .50221 Mdot
.5 Mabswid
.779 .55 .589 r
.59982 .42316 m .67278 .43875 L .67034 .47345 L p F P
0 g
s
.01 w
.73242 .57943 Mdot
.33855 .49613 Mdot
.73167 .57788 Mdot
.69179 .46289 Mdot
.7309 .57628 Mdot
.34151 .49334 Mdot
.7301 .57462 Mdot
.33791 .50254 Mdot
.72927 .57291 Mdot
.34455 .49058 Mdot
.72842 .57115 Mdot
.68763 .46225 Mdot
.72753 .56933 Mdot
.34768 .48784 Mdot
.72661 .56747 Mdot
.34109 .50292 Mdot
.72565 .56555 Mdot
.35089 .48514 Mdot
.72466 .56359 Mdot
.68345 .4617 Mdot
.5 Mabswid
.619 .617 .827 r
.41056 .74799 m .4445 .7366 L .45992 .76913 L p F P
0 g
s
.612 .587 .801 r
.4445 .7366 m .41056 .74799 L .39015 .71538 L p F P
0 g
s
.01 w
.72362 .56158 Mdot
.35418 .48247 Mdot
.5 Mabswid
.72 .473 .551 r
.59982 .42316 m .5221 .41813 L .5221 .38546 L p F P
0 g
s
.01 w
.72255 .55952 Mdot
.34425 .50336 Mdot
.72143 .55741 Mdot
.35756 .47984 Mdot
.5 Mabswid
.774 .718 .8 r
.63755 .74691 m .60316 .73583 L .61713 .70073 L p F P
0 g
s
.774 .718 .8 r
.61713 .70073 m .65751 .71408 L .63755 .74691 L p F P
0 g
s
.574 .464 .691 r
.39443 .58815 m .34034 .60831 L .32848 .5715 L p F P
0 g
s
.574 .464 .691 r
.32848 .5715 m .38593 .54956 L .39443 .58815 L p F P
0 g
s
.01 w
.72026 .55527 Mdot
.67926 .46124 Mdot
.71904 .55308 Mdot
.5 Mabswid
.652 .634 .819 r
.49102 .76341 m .45992 .76913 L .4445 .7366 L p F P
0 g
s
.01 w
.36102 .47725 Mdot
.71778 .55085 Mdot
.34739 .50386 Mdot
.5 Mabswid
.735 .702 .819 r
.58832 .76852 m .557 .7631 L .56449 .72898 L p F P
0 g
s
.735 .702 .819 r
.56449 .72898 m .60316 .73583 L .58832 .76852 L p F P
0 g
s
.01 w
.36457 .47471 Mdot
.71646 .54858 Mdot
.67506 .46087 Mdot
.71508 .54627 Mdot
.5 Mabswid
.815 .661 .691 r
.65958 .54808 m .71788 .56943 L .70626 .6064 L p F P
0 g
s
.823 .643 .66 r
.71788 .56943 m .65958 .54808 L .66593 .51009 L p F P
0 g
s
.01 w
.36819 .47221 Mdot
.71365 .54393 Mdot
.35051 .50441 Mdot
.71216 .54155 Mdot
.37189 .46976 Mdot
.67085 .4606 Mdot
.71061 .53914 Mdot
.37568 .46736 Mdot
.709 .5367 Mdot
.35361 .50501 Mdot
.70733 .53423 Mdot
.37954 .46502 Mdot
.5 Mabswid
.612 .587 .801 r
.39015 .71538 m .42999 .70165 L .4445 .7366 L p F P
0 g
s
.604 .557 .775 r
.42999 .70165 m .39015 .71538 L .37143 .68085 L p F P
0 g
s
.01 w
.66664 .46041 Mdot
.70558 .53174 Mdot
.38347 .46274 Mdot
.70378 .52922 Mdot
.5 Mabswid
.585 .496 .72 r
.40473 .6268 m .35474 .64496 L .34034 .60831 L p F P
0 g
s
.585 .496 .72 r
.34034 .60831 m .39443 .58815 L .40473 .6268 L p F P
0 g
s
.01 w
.35668 .50566 Mdot
.5 Mabswid
.615 .442 .625 r
.44837 .49663 m .37934 .51167 L .37477 .47512 L p F P
0 g
s
.615 .442 .625 r
.37477 .47512 m .44594 .45928 L .44837 .49663 L p F P
0 g
s
.01 w
.7019 .52668 Mdot
.5 Mabswid
.787 .705 .774 r
.65751 .71408 m .61713 .70073 L .62997 .66378 L p F P
0 g
s
.787 .705 .774 r
.62997 .66378 m .67582 .67933 L .65751 .71408 L p F P
0 g
s
.01 w
.38748 .46052 Mdot
.66243 .4603 Mdot
.69995 .52412 Mdot
.39156 .45836 Mdot
.69793 .52154 Mdot
.35973 .50636 Mdot
.69584 .51895 Mdot
.5 Mabswid
.777 .575 .625 r
.59857 .45841 m .67034 .47345 L .66593 .51009 L p F P
0 g
s
.779 .55 .589 r
.67034 .47345 m .59857 .45841 L .59982 .42316 L p F P
0 g
s
.682 .653 .815 r
.52397 .76136 m .49102 .76341 L .48288 .72937 L p F P
0 g
s
.652 .634 .819 r
.4445 .7366 m .48288 .72937 L .49102 .76341 L p F P
0 g
s
.807 .676 .72 r
.65138 .5868 m .70626 .6064 L .69216 .64324 L p F P
0 g
s
.815 .661 .691 r
.70626 .6064 m .65138 .5868 L .65958 .54808 L p F P
0 g
s
.01 w
.39572 .45627 Mdot
.65821 .46029 Mdot
.5 Mabswid
.604 .557 .775 r
.37143 .68085 m .41665 .66485 L .42999 .70165 L p F P
0 g
s
.595 .527 .748 r
.41665 .66485 m .37143 .68085 L .35474 .64496 L p F P
0 g
s
.71 .676 .815 r
.557 .7631 m .52397 .76136 L .52364 .72678 L p F P
0 g
s
.71 .676 .815 r
.52364 .72678 m .56449 .72898 L .557 .7631 L p F P
0 g
s
.01 w
.69367 .51634 Mdot
.5 Mabswid
.595 .527 .748 r
.35474 .64496 m .40473 .6268 L .41665 .66485 L p F P
0 g
s
.01 w
.39994 .45425 Mdot
.69143 .51373 Mdot
.36274 .5071 Mdot
.5 Mabswid
.668 .457 .591 r
.52215 .45356 m .44594 .45928 L .4446 .42406 L p F P
0 g
s
.668 .457 .591 r
.4446 .42406 m .5221 .41813 L .52215 .45356 L p F P
0 g
s
.01 w
.68912 .51111 Mdot
.40423 .45229 Mdot
.65401 .46036 Mdot
.68672 .50848 Mdot
.5 Mabswid
.797 .691 .747 r
.67582 .67933 m .62997 .66378 L .64145 .62559 L p F P
0 g
s
.797 .691 .747 r
.64145 .62559 m .69216 .64324 L .67582 .67933 L p F P
0 g
s
.01 w
.40858 .45042 Mdot
.5 Mabswid
.724 .504 .591 r
.5221 .41813 m .59982 .42316 L .59857 .45841 L p F P
0 g
s
.01 w
.68425 .50585 Mdot
.5 Mabswid
.682 .653 .815 r
.48288 .72937 m .52364 .72678 L .52397 .76136 L p F P
0 g
s
.01 w
.36573 .50789 Mdot
.5 Mabswid
.807 .676 .72 r
.69216 .64324 m .64145 .62559 L .65138 .5868 L p F P
0 g
s
.01 w
.413 .44862 Mdot
.68169 .50323 Mdot
.64981 .46051 Mdot
.67906 .5006 Mdot
.41747 .44689 Mdot
.36868 .50871 Mdot
.67635 .49799 Mdot
.422 .44525 Mdot
.67355 .49538 Mdot
.5 Mabswid
.65 .607 .793 r
.48288 .72937 m .4445 .7366 L .42999 .70165 L p F P
0 g
s
.01 w
.64562 .46075 Mdot
.42659 .44369 Mdot
.67068 .49279 Mdot
.3716 .50957 Mdot
.66772 .49021 Mdot
.43123 .44222 Mdot
.5 Mabswid
.746 .685 .792 r
.60316 .73583 m .56449 .72898 L .57155 .69245 L p F P
0 g
s
.746 .685 .792 r
.57155 .69245 m .61713 .70073 L .60316 .73583 L p F P
0 g
s
.01 w
.66468 .48765 Mdot
.64144 .46107 Mdot
.43592 .44083 Mdot
.66156 .48511 Mdot
.37448 .51047 Mdot
.44065 .43953 Mdot
.65836 .48259 Mdot
.44543 .43832 Mdot
.65507 .48011 Mdot
.5 Mabswid
.724 .504 .591 r
.59857 .45841 m .52215 .45356 L .5221 .41813 L p F P
0 g
s
.01 w
.63729 .46147 Mdot
.65171 .47765 Mdot
.45025 .4372 Mdot
.37732 .51139 Mdot
.64826 .47522 Mdot
.45511 .43617 Mdot
.64474 .47283 Mdot
.5 Mabswid
.624 .474 .657 r
.45186 .53552 m .38593 .54956 L .37934 .51167 L p F P
0 g
s
.624 .474 .657 r
.37934 .51167 m .44837 .49663 L .45186 .53552 L p F P
0 g
s
.01 w
.63315 .46195 Mdot
.46 .43524 Mdot
.64114 .47048 Mdot
.38012 .51235 Mdot
.46492 .4344 Mdot
.63745 .46818 Mdot
.46986 .43366 Mdot
.63369 .46592 Mdot
.62904 .4625 Mdot
.62986 .4637 Mdot
.47483 .43302 Mdot
.38289 .51334 Mdot
.5 Mabswid
.775 .596 .657 r
.59632 .49581 m .66593 .51009 L .65958 .54808 L p F P
0 g
s
.777 .575 .625 r
.66593 .51009 m .59632 .49581 L .59857 .45841 L p F P
0 g
s
.01 w
.62595 .46154 Mdot
.47982 .43247 Mdot
.62196 .45943 Mdot
.48483 .43202 Mdot
.61791 .45738 Mdot
.62495 .46313 Mdot
.48985 .43167 Mdot
.48985 .43167 Mdot
.61378 .45538 Mdot
.38561 .51434 Mdot
.49488 .43142 Mdot
.60959 .45345 Mdot
.49992 .43126 Mdot
.60532 .45159 Mdot
.50496 .43121 Mdot
.601 .44979 Mdot
.50999 .43125 Mdot
.62089 .46383 Mdot
.59661 .44806 Mdot
.38829 .51538 Mdot
.51503 .4314 Mdot
.59216 .4464 Mdot
.58765 .44482 Mdot
.52005 .43164 Mdot
.58309 .44332 Mdot
.52507 .43198 Mdot
.57848 .44189 Mdot
.53006 .43242 Mdot
.57381 .44055 Mdot
.53504 .43295 Mdot
.5691 .43929 Mdot
.54 .43358 Mdot
.56434 .43811 Mdot
.5 Mabswid
.65 .607 .793 r
.42999 .70165 m .47522 .69293 L .48288 .72937 L p F P
0 g
s
.647 .581 .767 r
.47522 .69293 m .42999 .70165 L .41665 .66485 L p F P
0 g
s
.01 w
.54493 .4343 Mdot
.5 Mabswid
.684 .63 .789 r
.52364 .72678 m .48288 .72937 L .47522 .69293 L p F P
0 g
s
.01 w
.55955 .43703 Mdot
.54984 .43512 Mdot
.55471 .43603 Mdot
.61686 .46461 Mdot
.39092 .51643 Mdot
.5 Mabswid
.716 .656 .788 r
.56449 .72898 m .52364 .72678 L .52332 .68979 L p F P
0 g
s
.716 .656 .788 r
.52332 .68979 m .57155 .69245 L .56449 .72898 L p F P
0 g
s
.754 .668 .766 r
.61713 .70073 m .57155 .69245 L .57805 .65411 L p F P
0 g
s
.754 .668 .766 r
.57805 .65411 m .62997 .66378 L .61713 .70073 L p F P
0 g
s
.674 .487 .625 r
.52224 .4912 m .44837 .49663 L .44594 .45928 L p F P
0 g
s
.674 .487 .625 r
.44594 .45928 m .52215 .45356 L .52224 .4912 L p F P
0 g
s
.01 w
.39351 .51749 Mdot
.61286 .46545 Mdot
.5 Mabswid
.727 .53 .625 r
.52215 .45356 m .59857 .45841 L .59632 .49581 L p F P
0 g
s
.01 w
.39606 .51857 Mdot
.60891 .46636 Mdot
.5 Mabswid
.632 .502 .687 r
.45638 .57527 m .39443 .58815 L .38593 .54956 L p F P
0 g
s
.632 .502 .687 r
.38593 .54956 m .45186 .53552 L .45638 .57527 L p F P
0 g
s
.684 .63 .789 r
.47522 .69293 m .52332 .68979 L .52364 .72678 L p F P
0 g
s
.01 w
.39855 .51966 Mdot
.60499 .46733 Mdot
.401 .52076 Mdot
.5 Mabswid
.771 .616 .686 r
.59309 .53475 m .65958 .54808 L .65138 .5868 L p F P
0 g
s
.775 .596 .657 r
.65958 .54808 m .59309 .53475 L .59632 .49581 L p F P
0 g
s
.01 w
.60111 .46836 Mdot
.40341 .52187 Mdot
.59727 .46945 Mdot
.5 Mabswid
.647 .581 .767 r
.41665 .66485 m .46816 .65466 L .47522 .69293 L p F P
0 g
s
.643 .555 .741 r
.46816 .65466 m .41665 .66485 L .40473 .6268 L p F P
0 g
s
.01 w
.40576 .52298 Mdot
.59348 .4706 Mdot
.40807 .52409 Mdot
.5 Mabswid
.761 .651 .74 r
.62997 .66378 m .57805 .65411 L .58388 .61459 L p F P
0 g
s
.761 .651 .74 r
.58388 .61459 m .64145 .62559 L .62997 .66378 L p F P
0 g
s
.638 .529 .714 r
.46185 .61522 m .40473 .6268 L .39443 .58815 L p F P
0 g
s
.638 .529 .714 r
.39443 .58815 m .45638 .57527 L .46185 .61522 L p F P
0 g
s
.727 .53 .625 r
.59632 .49581 m .52224 .4912 L .52215 .45356 L p F P
0 g
s
.01 w
.58973 .47181 Mdot
.41033 .52521 Mdot
.5 Mabswid
.643 .555 .741 r
.40473 .6268 m .46185 .61522 L .46816 .65466 L p F P
0 g
s
.01 w
.41254 .52631 Mdot
.58604 .47306 Mdot
.5 Mabswid
.767 .634 .714 r
.58892 .57457 m .65138 .5868 L .64145 .62559 L p F P
0 g
s
.771 .616 .686 r
.65138 .5868 m .58892 .57457 L .59309 .53475 L p F P
0 g
s
.01 w
.4147 .52741 Mdot
.58239 .47437 Mdot
.5 Mabswid
.767 .634 .714 r
.64145 .62559 m .58388 .61459 L .58892 .57457 L p F P
0 g
s
.01 w
.41681 .52851 Mdot
.5788 .47572 Mdot
.41888 .52959 Mdot
.5 Mabswid
.685 .607 .763 r
.52332 .68979 m .47522 .69293 L .46816 .65466 L p F P
0 g
s
.01 w
.57526 .47712 Mdot
.5 Mabswid
.721 .636 .762 r
.57155 .69245 m .52332 .68979 L .52304 .651 L p F P
0 g
s
.721 .636 .762 r
.52304 .651 m .57805 .65411 L .57155 .69245 L p F P
0 g
s
.01 w
.4209 .53066 Mdot
.5 Mabswid
.678 .514 .656 r
.52238 .53045 m .45186 .53552 L .44837 .49663 L p F P
0 g
s
.678 .514 .656 r
.44837 .49663 m .52224 .4912 L .52238 .53045 L p F P
0 g
s
.01 w
.57178 .47855 Mdot
.42287 .53171 Mdot
.5 Mabswid
.727 .554 .656 r
.52224 .4912 m .59632 .49581 L .59309 .53475 L p F P
0 g
s
.01 w
.42479 .53275 Mdot
.56835 .48003 Mdot
.42666 .53376 Mdot
.56498 .48154 Mdot
.42849 .53476 Mdot
.56167 .48308 Mdot
.43028 .53573 Mdot
.5 Mabswid
.685 .607 .763 r
.46816 .65466 m .52304 .651 L .52332 .68979 L p F P
0 g
s
.01 w
.55843 .48465 Mdot
.43202 .53667 Mdot
.43372 .53758 Mdot
.55524 .48625 Mdot
.43537 .53847 Mdot
.55211 .48787 Mdot
.43698 .53932 Mdot
.54905 .48951 Mdot
.43856 .54014 Mdot
.44009 .54093 Mdot
.54605 .49118 Mdot
.44159 .54168 Mdot
.54311 .49285 Mdot
.5 Mabswid
.727 .554 .656 r
.59309 .53475 m .52238 .53045 L .52224 .4912 L p F P
0 g
s
.01 w
.44304 .54239 Mdot
.54024 .49454 Mdot
.44447 .54306 Mdot
.5 Mabswid
.685 .585 .737 r
.52304 .651 m .46816 .65466 L .46185 .61522 L p F P
0 g
s
.01 w
.44586 .54368 Mdot
.53743 .49624 Mdot
.5 Mabswid
.682 .539 .684 r
.52256 .57063 m .45638 .57527 L .45186 .53552 L p F P
0 g
s
.682 .539 .684 r
.45186 .53552 m .52238 .53045 L .52256 .57063 L p F P
0 g
s
.01 w
.44722 .54427 Mdot
.5 Mabswid
.724 .616 .737 r
.57805 .65411 m .52304 .651 L .52278 .61105 L p F P
0 g
s
.724 .616 .737 r
.52278 .61105 m .58388 .61459 L .57805 .65411 L p F P
0 g
s
.01 w
.53468 .49795 Mdot
.44855 .54481 Mdot
.44984 .54531 Mdot
.532 .49966 Mdot
.5 Mabswid
.727 .576 .684 r
.52238 .53045 m .59309 .53475 L .58892 .57457 L p F P
0 g
s
.01 w
.45112 .54575 Mdot
.52939 .50138 Mdot
.45236 .54615 Mdot
.52683 .50309 Mdot
.45359 .54651 Mdot
.45479 .54681 Mdot
.52434 .5048 Mdot
.45597 .54706 Mdot
.52192 .5065 Mdot
.45713 .54726 Mdot
.45828 .54741 Mdot
.51955 .5082 Mdot
.45941 .5475 Mdot
.51725 .50988 Mdot
.46053 .54754 Mdot
.46164 .54753 Mdot
.515 .51155 Mdot
.46275 .54746 Mdot
.51282 .51321 Mdot
.46385 .54734 Mdot
.46385 .54735 Mdot
.5107 .51484 Mdot
.46494 .54716 Mdot
.5 Mabswid
.685 .585 .737 r
.46185 .61522 m .52278 .61105 L .52304 .651 L p F P
0 g
s
.684 .562 .711 r
.52278 .61105 m .46185 .61522 L .45638 .57527 L p F P
0 g
s
.01 w
.46603 .54693 Mdot
.50863 .51646 Mdot
.5 Mabswid
.684 .562 .711 r
.45638 .57527 m .52256 .57063 L .52278 .61105 L p F P
0 g
s
.01 w
.46713 .54664 Mdot
.50663 .51805 Mdot
.46822 .54629 Mdot
.46932 .54589 Mdot
.50467 .51962 Mdot
.47043 .54544 Mdot
.50278 .52116 Mdot
.47155 .54493 Mdot
.50093 .52268 Mdot
.47268 .54436 Mdot
.5 Mabswid
.726 .596 .711 r
.58388 .61459 m .52278 .61105 L .52256 .57063 L p F P
0 g
s
.726 .596 .711 r
.52256 .57063 m .58892 .57457 L .58388 .61459 L p F P
0 g
s
.01 w
.49914 .52416 Mdot
.47382 .54374 Mdot
.47498 .54307 Mdot
.4974 .52561 Mdot
.47616 .54234 Mdot
.49571 .52702 Mdot
.5 Mabswid
.727 .576 .684 r
.58892 .57457 m .52256 .57063 L .52238 .53045 L p F P
0 g
s
.01 w
.47736 .54156 Mdot
.49406 .5284 Mdot
.47858 .54073 Mdot
.49246 .52974 Mdot
.47982 .53984 Mdot
.4909 .53104 Mdot
.48109 .53891 Mdot
.48939 .5323 Mdot
.48239 .53793 Mdot
.48792 .53351 Mdot
.48372 .53689 Mdot
.48509 .53581 Mdot
.48648 .53468 Mdot
.25 Mabswid
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.08845 .24527 m
.67201 0 L
s
.09903 .24082 m
.10412 .24605 L
s
[(-1)] .08885 .23035 .97243 1 Mshowa
.22731 .1869 m
.23214 .19237 L
s
[(-0.5)] .21763 .17597 .88506 1 Mshowa
.36263 .13003 m
.36719 .13573 L
s
[(0)] .35353 .11861 .7977 1 Mshowa
.50562 .06993 m
.50984 .07588 L
s
[(0.5)] .49716 .05803 .71033 1 Mshowa
.65692 .00634 m
.66078 .01254 L
s
[(1)] .6492 -0.00605 .62296 1 Mshowa
.125 Mabswid
.12415 .23026 m
.12717 .23343 L
s
.14953 .21959 m
.15253 .22279 L
s
.17518 .20881 m
.17815 .21204 L
s
.2011 .19792 m
.20404 .20117 L
s
.25379 .17577 m
.25666 .17908 L
s
.28056 .16452 m
.28339 .16786 L
s
.30762 .15315 m
.31042 .15652 L
s
.33498 .14165 m
.33774 .14505 L
s
.3906 .11827 m
.39329 .12173 L
s
.41887 .10639 m
.42153 .10987 L
s
.44746 .09437 m
.45008 .09789 L
s
.47638 .08222 m
.47895 .08576 L
s
.53519 .0575 m
.53768 .0611 L
s
.5651 .04493 m
.56755 .04856 L
s
.59535 .03222 m
.59776 .03588 L
s
.62596 .01935 m
.62832 .02304 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-1)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-0.5)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(0.5)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(1)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{264.75, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004800017b000`400?l00000o`00003oo`3oool9
0?ooo`00o`3oool90?ooo`00Z`3oool4000005T0oooo002]0?ooo`030000003oool0oooo05P0oooo
002]0?ooo`030000003oool0oooo05P0oooo002]0?ooo`030000003oool0oooo05P0oooo002]0?oo
o`030000003oool0oooo05P0oooo002[0?ooo`<00000FP3oool00:d0oooo00<000000?ooo`3oool0
F03oool00?l0oooo2@3oool00;@0oooo0P00001B0?ooo`00/P3oool2000000030?ooo`0000000000
0540oooo002`0?ooo`8000000`3oool200000540oooo002]0?ooo`<000000P3oool01P000000oooo
0?ooo`000000oooo00000500oooo002[0?ooo`800000203oool00`000000oooo0000001@0?ooo`00
Z03oool3000000X0oooo00@000000?ooo`3oool00000C`3oool00:H0oooo0P0000020?ooo`030000
003oool0oooo00P0oooo00D000000?ooo`3oool0oooo0000001>0?ooo`00O@3oool2000000@0oooo
00<000000?ooo`3oool00P3oool3000001T0oooo0P00000?0?ooo`050000003oool0oooo0?ooo`00
0000CP3oool007`0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0C0?ooo`<0
00004@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04/0oooo001l0?ooo`040000
003oool0oooo000000/0oooo00<000000?ooo`3oool04@3oool200000080oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04X0oooo001l0?ooo`040000
003oool0oooo000000P0oooo0`00000B0?ooo`8000005`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo04X0oooo001l0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3o
ool03`3oool3000001T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`190?ooo`00
O03oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00d0oooo0P0000000`3oool0
00000?ooo`0I0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0B@3oool007d0oooo
0P0000090?ooo`@000002P3oool2000001h0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`180?ooo`00T`3oool300000200oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`170?ooo`00T@3oool2000000030?ooo`000000oooo0200oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`170?ooo`00SP3oool3000002D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`160?ooo`00S03oool2000002P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`160?ooo`00RP3oool3000002T0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`150?ooo`00Q`3oool3000000<0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo04@0oooo00250?ooo`800000;`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo04@0oooo00230?ooo`80000000<0oooo0000003oool0;P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo04<0oooo001T0?ooo`8000006P3oool3000003<0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`120?ooo`00H`3oool010000000oooo
0?ooo`00000G0?ooo`800000=P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0480
oooo001S0?ooo`040000003oool0oooo000001D0oooo0P0000000`3oool000000?ooo`0e0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0@@3oool006<0oooo00@000000?ooo`3oool0
00004P3oool3000003X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`110?ooo`00
H`3oool010000000oooo0?ooo`00000@0?ooo`800000?@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo0400oooo001S0?ooo`040000003oool0oooo000000d0oooo0`0000000`3oool0
00000?ooo`0m0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0?`3oool006@0oooo
0P00000<0?ooo`800000@`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03l0oooo
001`0?ooo`800000A@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03h0oooo001]
0?ooo`<0000000<0oooo0000003oool0A03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo03h0oooo001[0?ooo`800000BP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
03d0oooo001Y0?ooo`800000C03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03`0
oooo001V0?ooo`<0000000<0oooo0000003oool0B`3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo03`0oooo001T0?ooo`800000D@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo03/0oooo001Q0?ooo`<00000D`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo03/0oooo000g0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000006P3oool20000
05H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`00=P3oool010000000
oooo0?ooo`00000;0?ooo`030000003oool0oooo01@0oooo0`00001H0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0>@3oool003H0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`0B0?ooo`@00000F@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
03T0oooo000`0?ooo`@000000P3oool010000000oooo0?ooo`0000080?ooo`<000004`3oool20000
05d0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0h0?ooo`00=P3oool010000000
oooo0?ooo`0000080?ooo`030000003oool0oooo0100oooo0`00001O0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0=`3oool003H0oooo00@000000?ooo`3oool00000203oool00`00
0000oooo0?ooo`0>0?ooo`@00000H03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
03L0oooo000g0?ooo`8000002@3oool4000000/0oooo0P00001T0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0=P3oool004l0oooo0P00001V0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0=P3oool004`0oooo0`0000000`3oool000000?ooo`1U0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0=@3oool004X0oooo0P00001/0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0=03oool004L0oooo0`00001^0?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool0=03oool004D0oooo0P0000020?ooo`800000K@3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo03<0oooo00120?ooo`<00000L`3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo03<0oooo000R0?ooo`@000006P3oool4000007@0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0b0?ooo`00903oool00`000000oooo0?ooo`0G
0?ooo`800000N03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0340oooo000T0?oo
o`030000003oool0oooo01D0oooo0P00001j0?ooo`030000003oool0oooo01T0oooo00<000000?oo
o`3oool0<@3oool001`0oooo100000040?ooo`030000003oool0oooo0180oooo1000001k0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool0<03oool002@0oooo00<000000?ooo`3oool0
403oool2000007l0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0_0?ooo`008P3o
ool300000100oooo0P0000210?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0;`3o
ool002@0oooo00<000000?ooo`3oool02`3oool3000008<0oooo00<000000?ooo`3oool0703oool0
0`000000oooo0?ooo`0^0?ooo`00;`3oool3000008H0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`0^0?ooo`00;@3oool4000008L0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0]0?ooo`00:`3oool2000008/0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`0/0?ooo`00:@3oool2000008d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`0/0?ooo`009`3oool2000000030?ooo`000000oooo08`0oooo00<000000?ooo`3oool07`3oool0
0`000000oooo0?ooo`0[0?ooo`009`3oool2000008l0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0[0?ooo`009`3oool3000008h0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`0Z0?ooo`009P3oool200000080oooo00<000000?ooo`3oool0GP3oool<00000280oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0Y0?ooo`007P3oool4000000@0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`1F0?oooa<0000000<09@000000000000001000
000K0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0:@3oool00200oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0540oooo8P00000G
0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0:03oool00200oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04`0oooo3@00000706T0
0003000000250000Q@0000D0Q@003P00000C0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool09`3oool001P0oooo100000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`180?ooo`P0000000<0@P000000001Y00002@1Y0007000000/0
Q@0000<0000009L<002G30001`00000@0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool09`3oool00200oooo00<000000?ooo`3oool00P3oool2000000P0oooo00<000000?ooo`3oool0
A03oool30000000401@0000000000000000000@0@P0000@0000006T0001Y0000J@0020000003088B
8`040000002K9R<0VbHS09/V8`P00000102500000`000000U``009L<000309L<00H000003@3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02H0oooo000N0?ooo`<000001@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0440oooo1P000005048000H000002`224R<00`00
0000VbHS09/V8`0909/V8`L00000202G3004000000X0oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`0V0?ooo`00803oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0?P3oool4000000@0@P001@00000206406@03000000224R<0PQ8S00`0
PQ8S00<0000009/V8`2K9R<03@2K9R<00`000000[S<J0:hc6P05000000H0U``00`0000080?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool09@3oool002D0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0j0?ooo`D0000000<0@P000000000000000`00000606406@030000
00224R<0PQ8S00D0PQ8S4@00000809/V8`030000002^<aX0[S<J00@0[S<J1@000000102G30000000
09h>002N3P03000000D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0T0?ooo`00
9@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03L0oooo2000000906406@X00000
202A;dH00`000000Z4560:Q1AP060:Q1APX000002P2^<aX400000080WPh00`0000030?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0903oool002D0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0d0?ooo`<0000000D01`00000000000000<0010000000706406@@00000
0P1e5Sl00`000000TBm6094_AP0=094_AP030000002X@DH0Z45600h0Z45600<000000;]??`2kCcl0
0`0000080:hc6P040000002l>P@00000000000<0WPh00P0000000`3oool000000?ooo`0W0?ooo`03
0000003oool0oooo02<0oooo000T0?ooo`8000003`3oool00`000000oooo0?ooo`0a0?ooo`<00000
00<01`000000000000000P0`00400`000000H@0I06406@0206406@@000001P1e5Sl00`000000TBm6
094_AP0=094_AP030000002X@DH0Z45600h0Z45600<000000;]??`2kCcl00`2kCcl4000000D0[S<J
00<000000;`j102l>P@00`00000209h>00800000:03oool00`000000oooo0?ooo`0S0?ooo`009@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02l0oooo0P0000000`07000000000000
000403000@D000002@1e5Sl00`000000TBm6094_AP0:094_APd000002@2X@DH00`000000^dlo0;]?
?`060;]??`@0000000<0[S<J0000002l>P@0102l>P@6000002L0oooo00<000000?ooo`3oool08P3o
ool002@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0]0?ooo`04000000070000
0000000000@0<0010`00000=07DF?`030000002A;dH0TBm60080TBm62000000409]4G`030000002_
EEl0[eEO00H0[eEO3000000:0;]??`@000001P2l>P@4000002L0oooo00<000000?ooo`3oool08@3o
ool002@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0Z0?ooo`@00000100`0042
0000000304d0;P000000MAHo00/0MAHo1`00000<09]4G`030000002_EEl0[eEO00l0[eEO00<00000
0<5SF`31He/0100000080;]??`030000003;FC000000008000000`2l>P@00`000000_3X400000002
000002H0oooo00<000000?ooo`3oool08@3oool002@0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0X0?ooo`<00000100`004200000080C@0^00<0000007DF?`1e5Sl01`1e5Sl40000
0080PRmJ00<0000009]4G`2KA5l03P2KA5l00`000000[eEO0:mEG`0?0:mEG`0300000031He/0`F=K
00@0`F=K100000050;]??`040000003;FC00beT`0<]I<080000000<0_3X40000002l>P@00P2l>P@3
000002D0oooo00<000000?ooo`3oool0803oool002<0oooo0P00000E0?ooo`030000003oool0oooo
02H0oooo0P00000303000@<00000101=02h00`000000MAHo07DF?`0307DF?`@000001P22;eX00`00
0000VdAO09]4G`0>09]4G`030000002_EEl0[eEO00l0[eEO00<000000<5SF`31He/02031He/40000
00030;]??`000000beT`00@0beT`0`0000020;`j10040000002l=P000000000002@0oooo00<00000
0?ooo`3oool0803oool002@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0S0?oo
o`@0000000<0<0010000000000001P1=02h00`000000MAHo07DF?`04000000T0PRmJ00<0000009]4
G`2KA5l03`2KA5l00`000000[eEO0:mEG`0@0:mEG`0300000031He/0`F=K00/0`F=K100000040<]I
<0030000003;FC00000000<0000000@0_3H000000000000000008`3oool00`000000oooo0?ooo`0O
0?ooo`00903oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0280oooo1P00000704d0
;P@000003@22;eX00`000000VdAO09]4G`0609]4Ga<000002@2_EEl00`000000`F=K0<5SF`0=0<5S
F`040000003BKe000000000000<0beT`00@000000<]I<03;FC00beT`0P000000102l=P0000000000
0000000S0?ooo`030000003oool0oooo01h0oooo000S0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0803oool5000000L0C@0^0P0000000`1Q4Dl00000088_FP0<088_FP/000002@2Q
EG800`000000/fAb0;=TLP070;=TLP`000003@31He/010000000dVm@0=9_D03BKe02000000030<]I
<0000000beT`00<0beT`00@000000=EM4@000000_3H00P00000R0?ooo`030000003oool0oooo01h0
oooo000S0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool07@3oool6000000H0C@0^
0P000003064AC`0300000022;eX0PRmJ00L0PRmJ1000000208]2K`030000002QEG80XEEb00l0XEEb
00<000000;=TLP2cI780402cI7800`000000a75_0<AaK`04000000T0`F=K00<000000=9_D03BKe00
0`3BKe03000000@0beT`00@000000=EM4@000000_3H00P00000R0?ooo`030000003oool0oooo01d0
oooo000S0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06`3oool40000000300h0
3P000000C@0^00<0C@0^0`000004064AC`0300000022;eX0PRmJ00@0PRmJ1000000608]2K`030000
002QEG80XEEb00l0XEEb00<000000;=TLP2cI780402cI7800`000000a75_0<AaK`040<AaK`@00000
1P31He/00`000000dVm@0=9_D0030=9_D0040000003BKe00000000000080beT`00D000000=EM4@3E
GA4000000;`f000200000280oooo00<000000?ooo`3oool0703oool002<0oooo0P00000J0?ooo`03
0000003oool0oooo01T0oooo1000000200h03P030000001=02h0C@0^008000001`1Q4Dl00`000000
PRmJ088_FP04000000X0Rd9_00<000000:5ELP2QEG803`2QEG800`000000/fAb0;=TLP0@0;=TLP03
00000034LFl0a75_00P0a75_100000020<5SF`030000003BKe00dVm@00<0dVm@00@000000=9_D03B
Ke00dVm@0P000000103;FC0000000=EM4@3EGA42000000030;`f00000000oooo0200oooo00<00000
0?ooo`3oool0703oool002<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0G0?oo
o`@000000P0>00h010000000C@0^000000000008064AC`@000003@2;@Vl00`000000XEEb0:5ELP0@
0:5ELP030000002cI780/fAb0100/fAb00<000000<AaK`34LFl03034LFl4000000@0dVm@00<00000
0=9_D03BKe000`3BKe02000000@0eEdA00<000000;`f000000008@3oool00`000000oooo0?ooo`0K
0?ooo`008`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01D0oooo0`00000400h0
3P800000201Q4Dl20000000306hZJ0000000Rd9_00h0Rd9_00<000000:5ELP2QEG801`2QEG8C0000
00T0/fAb00<000000<AaK`34LFl03P34LFl010000000eGiX0000000000020=9_D0030000003BKe00
dVm@00@0dVm@0`0000030=EM4@<00000803oool00`000000oooo0?ooo`0K0?ooo`008P3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo01<0oooo0`00000300h03P<000001P1Q4Dl30000
00<0KRYX00<0000008]2K`2;@Vl02`2;@Vl<000000T0YF6100<000000;I_P@2fKh401`2fKh4<0000
00h0a75_00@000000=EnJ03EOVP0eGiX0`0000070=9_D0030000003QN3`0000000<0eEdA0`00000P
0?ooo`030000003oool0oooo01X0oooo000R0?ooo`030000003oool0oooo01h0oooo00<000000?oo
o`3oool04@3oool3000000<03P0>00<0000002d0>@0000001@1Q4Dl2000000H0KRYX00<0000008]2
K`2;@Vl01`2;@Vl400000080TU5o00<000000:EQP@2UHH40402UHH400`000000]Vn10;I_P@0@0;I_
P@0300000036O7l0aWao00@000002P34LFl00`000000eGiX0=EnJ0030=EnJ0<000001@3BKe000`00
0000hGPl0>5h?002000000<0eEdA00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0I0?oo
o`008P3oool200000200oooo00<000000?ooo`3oool0403oool0100000003P0>00h03P0>00h20000
0080;@0i00<00000064AC`1Q4Dl00`00000706hZJ0030000002;@Vl0Rd9_00@0Rd9_10000006099A
O`030000002UHH40YF610100YF6100<000000;I_P@2fKh40402fKh400`000000aWao0<IlO`040<Il
O`D000001P34LFl00`000000eGiX0=EnJ0020=EnJ0030000003EOVP0eGiX00<000000P3BKe000`00
0000hGPl0>5h?0020>5h?0050000003EGA40eEdA0=EM4@000000803oool00`000000oooo0?ooo`0I
0?ooo`008P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00h0oooo00D0000000h0
3P0>00h03P0>0000000302d0>@040000001Q4Dl00000000000X0KRYX00<0000008]2K`2;@Vl01000
000:099AO`030000002UHH40YF610100YF6100<000000;I_P@2fKh40402fKh400`000000aWao0<Il
O`090<IlO`@000000P34LFl00`000000eGiX0=EnJ0020=EnJ0030000003EOVP0eGiX00<0eGiX0P00
00000`3BKe0000000>5h?0030>5h?080000000<0eEdA000000000000803oool00`000000oooo0?oo
o`0H0?ooo`003P3oool2000000@0oooo00<000000?ooo`3oool00P3oool3000000H0oooo00<00000
0?ooo`3oool08@3oool00`000000oooo0?ooo`0<0?ooo`80000000<03P0>000000000000100]03T2
000000/0KRYX1000000>099AO`030000002UHH40YF610100YF6100<000000;I_P@2fKh40402fKh40
0`000000aWao0<IlO`0=0<IlO`@000000`3EOVP00`000000eGiX0=EnJ0050=EnJ08000001P3QN3`0
10000000eEdA00000000000O0?ooo`030000003oool0oooo01P0oooo000=0?ooo`040000003oool0
oooo000000/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo00X0oooo0P0000000`0>00h0000002d0>@0302d0>@<000002P1^:VP20000000307TmNP00
0000TU5o00l0TU5o00<000000:EQP@2UHH40402UHH400`000000]Vn10;I_P@0@0;I_P@0300000036
O7l0aWao00l0aWao00H000000=J9N`00000000000=EnJ00000080=EnJ0<000001@3QN3`200000003
0<QA00000000oooo01h0oooo00<000000?ooo`3oool05`3oool000d0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool0203oool4000000@0;@0i00@0000004@6F@141UT00000201^:VP2000000<0NCej00<00000099A
O`2BDGl03P2BDGl00`000000YF610:EQP@070:EQPA<000002@2fKh400`000000aWao0<IlO`0?0<Il
O`040000003FRG/0eXUk0=J9N`<000001`3EOVP010000000iXYK0>J:F`0000060>5h?0<000007`3o
ool00`000000oooo0?ooo`0F0?ooo`001`3oool400000080oooo00@000000?ooo`3oool00000203o
ool3000000D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`060?ooo`<000001@0]
03T01@000000A0II04@6F@141UT0000000H0KRYX0P00000507TmNP030000002BDGl0TU5o00d0TU5o
2`0000090:Q/S@030000002hNHd0^7V=00L0^7V=3000000?0<IlO`030000003FRG/0eXUk0080eXUk
00@000000=J9N`00000000001@3EOVP010000000iXYK0>J:F`3VRU/2000000@0hGPl1000000N0?oo
o`030000003oool0oooo01H0oooo000=0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00@0oooo1000000302d0
>@8000000`141UT00`000000KRYX06hZJ00306hZJ08000001`1i?GX00`000000TU5o099AO`09099A
O`@0000000<0UUf<0000002XK8d04@2XK8d00`000000^7V=0;QiS@0@0;QiS@0300000037QH`0ahF<
00@000002`36O7l00`000000eXUk0=J9N`020=J9N`040000003FRG/0eXUk0=J9N`<000000`3EOVP0
0`000000iXYK0>J:F`020>J:F`030000003QN3`0hGPl0080hGPl0`00000O0?ooo`030000003oool0
oooo01D0oooo000=0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool2
000002P0oooo00<000000?ooo`3oool00`3oool3000000<0;@0i00<0000004@6F@141UT00`141UT0
10000000KRYX06hZJ01^:VP2000000T0NCej00<00000099AO`2BDGl01P2BDGl3000000D0UUf<00<0
00000:Q/S@2XK8d0402XK8d00`000000^7V=0;QiS@0@0;QiS@0300000037QH`0ahF<00@0ahF<1@00
00060<IlO`030000003FRG/0eXUk0080eXUk00<000000=J9N`3FRG/0103FRG/2000000030=EnJ000
0000iXYK00@0iXYK0P0000020>5h?0040000003SN1800000000001l0oooo00<000000?ooo`3oool0
503oool000h0oooo0P0000090?ooo`@00000103oool00`000000oooo0?ooo`0X0?ooo`040000003o
ool0oooo0?ooo`80000000D0000=0000000]03T0;@0i0000000604@6F@040000001^:VP000000000
00/0NCej00<00000099AO`2BDGl00`2BDGl3000000P0UUf<00<000000:Q/S@2XK8d0402XK8d00`00
0000^7V=0;QiS@0@0;QiS@0300000037QH`0ahF<00T0ahF<100000020<IlO`030000003FRG/0eXUk
0080eXUk00<000000=J9N`3FRG/01P3FRG/2000000L0iXYK00<000000>5h?00000000P3SN1820000
01h0oooo00<000000?ooo`3oool0503oool00240oooo00<000000?ooo`3oool0:@3oool010000000
oooo00000000000200003@<000001`141UT2000000d0NCej00<00000099AO`0000000`00000;09IM
S0030000002XK8d0Z6b=0100Z6b=00<000000;QiS@2hNHd0402hNHd00`000000ahF<0<N5S00=0<N5
S0@00000103FRG/00`000000eXUk0=J9N`060=J9N`<000001P3VRU/3000000040>=h4P000000b540
000001h0oooo00<000000?ooo`3oool04`3oool00240oooo00<000000?ooo`3oool0:P3oool30000
000300003@000000000000L0A0II0`00000=07TmNP<000003`2FGH`00`000000Z6b=0:Q/S@0@0:Q/
S@030000002hNHd0^7V=0100^7V=00<000000<N5S037QH`03`37QH`010000000eY:9000000000002
0=J9N`030000003FRG/0eXUk00H0eXUk00<000000>NHLP3WV7800P0000060>J:F`030000003SN180
hgPB008000007P3oool00`000000oooo0?ooo`0C0?ooo`00803oool00`000000oooo0?ooo`0[0?oo
o`8000000P0000d00`000000A0II04@6F@0504@6F@040000001D8740E21a000000X0NCej0`000000
0`20C8T0000009IMS00?09IMS0030000002XK8d0Z6b=0100Z6b=00<000000;QiS@2hNHd0402hNHd0
0`000000ahF<0<N5S00?0<N5S0040000003FTXT0eY:90=JBR@<00000203FRG/00`000000iiQb0>NH
LP020>NHLP030000003VRU/0iXYK00<0iXYK0P0000020>=h4P8000007@3oool2000001@0oooo000P
0?ooo`030000003oool0oooo02X0oooo0P00000200003@8000001@141UT2000000<0E21a00<00000
07TmNP1i?GX01P1i?GX2000000@0P4b900<0000009IMS02FGH`03P2FGH`00`000000Z6b=0:Q/S@07
0:Q/SA<000002@2hNHd00`000000ahF<0<N5S00?0<N5S0030000003FTXT0eY:900<0eY:910000006
0=J9N`030000003WV780iiQb0080iiQb0P0000040>J:F`8000000P3SN1800`000000oooo0?ooo`0H
0?ooo`<0000000<0oooo0000003oool04`3oool00200oooo0P00000[0?ooo`060000000000d0000=
0000000003/0000010141UT00`000000E21a05@PL@0205@PL@030000001i?GX0NCej00@0NCej0`00
0006081<R@030000002FGH`0UUf<00`0UUf<300000090:]dU`030000002iPIL0^H6G00L0^H6G3000
000?0<N5S0030000003FTXT0eY:900<0eY:900@000000=JBR@3FTXT0eY:90P0000040=J9N`030000
003WV780iiQb00@0iiQb00L000000>J:F`3VRU/0iXYK0000003aTch000000080hgPB00<000000?oo
o`3oool0503oool3000000@0oooo00<000000?ooo`3oool04P3oool00200oooo00<000000?ooo`3o
ool0:@3oool010000000000=00003@0000020000>`03000000141UT0A0II008000001@1D87401000
0000NCej07TmNP1i?GX3000000T0P4b900<0000009IMS02FGH`0202FGH`400000080VVRF00<00000
0:]dU`2[M9L0402[M9L00`000000^H6G0;V1U`0@0;V1U`0300000037S9H0ahbF00@000002`37QH`0
0`000000eY:90=JBR@030=JBR@030000003FTXT0eY:900<0eY:90`0000000`3FRG/000000>NHLP06
0>NHLP80000000L0iXYK0000003aTch0lI<n0000003SN180000001<0oooo0`0000070?ooo`030000
003oool0oooo0180oooo000P0?ooo`030000003oool0oooo02T0oooo00<0000000003@0000000P00
03/010000000A0II04@6F@00000705@PL@040000001i?GX00000000000`0P4b900<0000009IMS02F
GH`0102FGH`4000000H0VVRF00<000000:]dU`2[M9L00`2[M9LC000000d0^H6G00<000000<N<UP37
S9H01037S9H5000000H0ahF<00<000000=JBR@3FTXT00`3FTXT00`000000eY:90=JBR@060=JBR@80
00002@3WV78300000080lI<n00<000000>=h4P0000003`3oool3000000/0oooo00<000000?ooo`3o
ool04@3oool00200oooo00<000000?ooo`3oool0:03oool010000000000=00003@0000020000>`<0
0000201D8742000000h0P4b900<0000009IMS02FGH`01000000:09YXUP/0000000<0ZgBG00000000
00000P0000000`2[M9L0000000000003000000030;V1U`000000000000D00000202iPIL00`000000
ahbF0<N<UP090<N<UP@000000P37QH`00`000000eY:90=JBR@030=JBR@030000003FTXT0eY:900L0
eY:90`0000090>NHLP040000003aTch0lI<n0?6C?P800000303oool3000000h0oooo00<000000?oo
o`3oool04@3oool001l0oooo00<000000?ooo`3oool0:@3oool00`000000000=000000030000>`03
0000001D8740E21a00H0E21a0`00000>081<R@@00000302JJ9H7000000030:]dU`000000ZgBG00/0
ZgBG00<000000;V1U`2iPIL00`2iPIL3000000030;V1U`000000000000<00000102iPIL00`000000
ahbF0<N<UP0=0<N<UP@00000103FTXT00`000000eY:90=JBR@070=JBR@040000003VXH@0iZ640000
00P0iiQb0P0000030?6C?P800000203oool300000140oooo00<000000?ooo`3oool04@3oool001l0
oooo00<000000?ooo`3oool0:03oool3000000<0000k0P00000705@PL@040000001Q=8@0HCB40000
00`0P4b90P0000000`26FID0000009YXUP0909YXUP@0000000@0VVRF00000000000000004@2[M9L0
0`000000^H6G0;V1U`080;V1U`L0000000<0^H6G00000037S9H04037S9H010000000eIVE00000000
00020=JBR@030000003FTXT0eY:900L0eY:900@000000>JQQ03VXH@0iZ640P0000060>NHLP030000
003fYF00000000<0lI<n00<000000?ooo`3oool00`3oool3000001@0oooo00<000000?ooo`3oool0
4@3oool001l0oooo0P00000Y0?ooo`8000000`0003/00`0000006`1M0000000505@PL@8000000`1Q
=8@00`000000P4b9081<R@08081<R@8000000`26FID00`000000VVRF09YXUP0609YXUPH000000`2J
J9H00`000000ZgBG0:]dU`0?0:]dU`030000002iPIL0^H6G00`0^H6G00<000000;V1U`0000000`00
000@0<N<UP040000003EVID0eIVE0=FIU@<000002@3FTXT00`000000iZ640>JQQ0030>JQQ0030000
003WV780iiQb00<0iiQb00<000000?JUH0000000103aTch00`000000oooo00000002000001L0oooo
00<000000?ooo`3oool04@3oool001l0oooo00<000000?ooo`3oool0:03oool01@000000000k0000
>`0003/0000000806`1M00<0000005@PL@1D87400P1D87400`000000HCB4064dQ003064dQ0030000
0020C8T0P4b900D0P4b90`00000508IIU@030000002JJ9H0VVRF00<0VVRF1P00000609YXUP030000
002[M9L0ZgBG00l0ZgBG00<000000;V1U`2iPIL03`2iPIL5000000h0ahbF00<000000=FIU@3EVID0
0`3EVID3000000H0eY:900<000000>JQQ03VXH@01@3VXH@2000000<0iiQb00@000000?JUH03fYF00
00000`3aTch2000001X0oooo00<000000?ooo`3oool04@3oool001l0oooo00<000000?ooo`3oool0
9`3oool200000080000k00@0000001/0G@0K05d000000`1D8742000000H0HCB400<00000081<R@20
C8T00`20C8T2000000P0QUVE00@0000009YXUP2JJ9H0VVRF1P00000809YXUP030000002[M9L0ZgBG
00H0ZgBG4`0000090;V1U`0300000037S9H0000000<000003037S9H00`000000eIVE0=FIU@030=FI
U@030000003EVID0eIVE00<000000`3FTXT00`000000iZ640>JQQ0070>JQQ0040000003WV780iiQb
000000<0mZEP00<000000?6C?P3aTch00P00000J0?ooo`030000003oool0oooo0140oooo000O0?oo
o`030000003oool0oooo02L0oooo00D000000000>`0003/0000k0000000201/0G@040000001D8740
E21a000000P0HCB400@00000081<R@20C8T0P4b90P00000:08IIU@030000002JJ9H0VVRF00@00000
2@2JJ9H;000000T0[7bO00<000000;Z7W`2jQil01`2jQil<000000030<N<UP000000000001400000
00<0eIVE0000003EVID0103EVID2000000030=JBR@000000iZ6400T0iZ640`0000040?JUH0040000
003aTch000000=f81A/0oooo00<000000?ooo`3oool0403oool001h0oooo00<000000?ooo`3oool0
9`3oool200000080000k00@0000001/0G@0K05d06`1M0`000009064dQ00400000020C8T000000000
00`0QUVE1@00000709YXUP@000000P2MLIl00`000000[7bO0:alW`0?0:alW`030000002jQil0^XNO
0100^XNO00<000000<JCW`0000006@0000040=FIU@800000303VXH@00`000000mZEP0?JUH0030?JU
H0040000003aTch00000000001X0oooo00<000000?ooo`3oool0403oool001h0oooo00<000000?oo
o`3oool09`3oool2000000030000>`0000006`1M00<06`1M00<00000064dQ01Q=8@02@1Q=8@20000
00d0QUVE1@00000309YXUPD000001P2MLIl00`000000[7bO0:alW`0?0:alW`030000002jQil0^XNO
00h0^XNO4@0000020<N<UP030000003EVID0eIVE00<0eIVE200000020=FIU@<000002P3VXH@20000
00@0mZEP00@000000?6C?P00000000006P3oool00`000000oooo0?ooo`0@0?ooo`007P3oool20000
02P0oooo0`00000401/0G@8000002@1Q=8@3000000`0QUVE1@0000000`2JJ9H00000000000020000
00/0WG6O00<000000:alW`2/O9l03`2/O9l00`000000^XNO0;Z7W`0;0;Z7W`P000001`36Til20000
00<0aY>O100000050=FIU@040000003EVID0eIVE0=FIU@H000000P3TZ9<2000000P0iZ6400<00000
0?JaN@000000103fYF02000000030=f81@000000oooo01P0oooo00<000000?ooo`3oool0403oool0
01h0oooo00<000000?ooo`3oool09P3oool3000000@06`1M00<00000034AN0000000201Q=8@01000
0000JdJB06]6TP00000;08IIU@L000003`2MLIl00`000000[7bO0:alW`0?0:alW`030000002jQil0
^XNO00T0^XNO1P0000000`2jQil000000<JCW`090<JCW`<000000`36Til010000000e9nO00000000
00030=FIU@030000003EVID0eIVE00@0eIVE100000030>BXT`030000003VXH@0iZ6400D0iZ6400@0
00000?JaN@3f/GT00000103fYF000`000000gHP50000000I0?ooo`030000003oool0oooo0100oooo
000N0?ooo`030000003oool0oooo02H0oooo0P00000501/0G@030000000a4GP0000000H0HCB40P00
000306]6TP0300000026FID0QUVE00P0QUVE100000000`2;I9l0000009eaW`0@09eaW`030000002/
O9l0[7bO00l0[7bO00<000000;Z7W`2jQil01P2jQil6000000<0^XNO00<000000<JCW`36Til02P36
Til4000000030<JCW`000000e9nO0080e9nO0`0000000`3EVID000000=FIU@060=FIU@@000000P3T
Z9<2000000D0iZ6400D000000?JaN@3f/GT0m[5i000000030?JUH0040000003MR0D0gHP5000001P0
oooo00<000000?ooo`3oool0403oool001h0oooo00<000000?ooo`3oool09@3oool3000000@06`1M
00@00000034AN00a4GP000001@1Q=8@00`000000JdJB06]6TP0306]6TP0300000026FID0QUVE00L0
QUVE0`00000308]TW`030000002MLIl0WG6O00l0WG6O00<000000:alW`2/O9l03`2/O9l00`000000
^XNO0;Z7W`050;Z7W`D000001@2jQil00`000000aY>O0<JCW`0<0<JCW`@000001P3DWil3000000H0
eIVE00<000000>BXT`0000000`0000020>BXT`030000003VXH@0iZ640080iZ6400D000000?JaN@3f
/GT0m[5i000000030?JUH080000000<0gHP50000003oool05`3oool00`000000oooo0?ooo`0@0?oo
o`007@3oool00`000000oooo0?ooo`0V0?ooo`<000000`0K05d01@000000<A5h034AN00a4GP00000
00<0HCB40P00000706]6TP0300000026FID0QUVE00@0QUVE1000000408]TW`030000002MLIl0WG6O
00l0WG6O00<000000:alW`2/O9l03`2/O9l00`000000^XNO0;Z7W`020;Z7W`D00000202jQil00`00
0000aY>O0<JCW`0=0<JCW`<000001`3DWil010000000e9nO0000000000040=FIU@040000003TZ9<0
i:RC0>BXT`@0000000<0i:RC0000000000000P3VXH@00`000000m[5i0?JaN@020?JaN@050000003f
YF00mZEP0000003cZ3L00P3MR0D00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0100oooo
000M0?ooo`030000003oool0oooo02D0oooo1000000201/0G@030000000a4GP0<A5h0080<A5h00@0
0000064dQ01Q=8@000002@1[AY8010000000QUVE08IIU@26FID6000000D0RfBO00<0000009eaW`2M
LIl03`2MLIl00`000000[7bO0:alW`060:alWa8000002@2jQil00`000000aY>O0<JCW`0>0<JCW`<0
00001P3DWil010000000e9nO0=BOW`3DWil3000000030=FIU@000000i:RC00@0i:RC0`0000020>BX
T`<000001@3f/GT00`000000mZEP0?JUH002000000030=f81@000000oooo01L0oooo00<000000?oo
o`3oool03`3oool001d0oooo0P00000V0?ooo`80000000@0000a0000000K05d000001@0a4GP30000
00X0JdJB00D0000008IIU@000000000008]TW`04000000L0RfBO00<0000009eaW`2MLIl0302MLIl;
000000T0[H>W00<000000;Z=Y`2jSJL0100000020;Z=Y``000003P36Til010000000e9nO00000000
00050=BOW`030000003DWil0e9nO00@0e9nO0P0000060>BXT`@000000P3TZ9<00`000000m[5i0?Ja
N@040?JaN@060000003fYF0000000000003MR0D00000603oool00`000000oooo0?ooo`0?0?ooo`00
7@3oool00`000000oooo0?ooo`0U0?ooo`80000000@0000a0000000K05d000001@0a4GP00`000000
JdJB06]6TP0506]6TPh000001`2;I9l00`000000WG6O09eaW`0809eaW`@000000P2ONJP00`000000
[H>W0:f3Y`0?0:f3Y`D000003@2jSJL00`000000aYRX0<JHZ006000000P0aY>O00<000000=BOW`3D
Wil00P0000040=BOW`030000003DWil0e9nO00D0e9nO0`0000060>BXT`8000000P3TZ9<2000000H0
m[5i0P0000000`3cZ3L000000000000H0?ooo`030000003oool0oooo00l0oooo000E0?ooo`800000
1P3oool00`000000oooo0?ooo`0U0?ooo`80000000<0000a0000000000001@0a4GP2000000@0JdJB
5P00000208]TW`030000002MLIl0WG6O00@0WG6O1000000609miZ0030000002]PjL0[H>W00h0[H>W
1@00000>0;Z=Y`0300000036V:P0aYRX00H0aYRX1P0000020<JCW`040000003DWil0e9nO0=BOW`80
00000`3DWil00`000000e9nO0=BOW`050=BOW`040000003R[Yl0hZjO000000H0i:RC100000000`3d
^Xd000000?JaN@050?JaN@050000003cZ3L000000=f81@0000005`3oool00`000000oooo0?ooo`0?
0?ooo`00503oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo02@0oooo0P000002
0000<@030000000a4GP0<A5h00<0<A5h00@0000004<YS0000000JdJB2@00000207=DW`030000002;
I9l0000000<000000`2;I9l800000080WG6O1000000:09miZ0030000002]PjL0[H>W00d0[H>W1000
000@0;Z=Y`0300000036V:P0aYRX00`0aYRX100000030=BOW`8000000P3DWil00`000000e9nO0=BO
W`040=BOW`030000003R[Yl0hZjO0080hZjO0P0000050>BXT`<000000P3d^Xd00`000000m[5i0?Ja
N@030?JaN@030000003cZ3L0ljPg008000005`3oool00`000000oooo0?ooo`0?0?ooo`00503oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo02D0oooo0P0000020000<@030000000a
4GP0<A5h0080<A5h00<0000004<YS013:H`01P00000206]6TP800000101cE9l3000000T0RfBO1`00
000=09miZ0030000002]PjL0[H>W00`0[H>W1000000A0;Z=Y`0300000036V:P0aYRX00h0aYRX00@0
00000=:TZ000000000000P3DWil2000000030=BOW`000000e9nO00D0e9nO00<000000>:^W`3R[Yl0
103R[Yl00`000000i:RC0>BXT`030>BXT`<000000P3d^Xd00`000000m[5i0?JaN@020?JaN@800000
00<0ljPg0000000000005`3oool00`000000oooo0?ooo`0?0?ooo`00503oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo02D0oooo00<000000000<@0003400P000003034AN0030000
0013:H`0@bV<00@00000101[AY800`000000LeBO07=DW`0407=DW`<00000202;I9l30000000308m^
Z0000000000000@000002`2ONJP00`000000[H>W0:f3Y`0:0:f3Y`@0000000<0[H>W0000002jSJL0
402jSJL00`000000aYRX0<JHZ00>0<JHZ0040000003BY:P0dZBX0=:TZ0H000001P3DWil00`000000
hZjO0>:^W`050>:^W`8000000`3TZ9<3000000<0m;Z=00@000000?JaN@3f/GT0m[5i0P0000020?>X
=`030000003oool0oooo01D0oooo00<000000?ooo`3oool03`3oool001@0oooo00@000000?ooo`3o
ool00000103oool00`000000oooo0?ooo`0U0?ooo`03000000000340000a008000000`0a4GP60000
00<0JdJB0P00000607=DW`<000001P2;I9l3000000@0SfjX00@0000009miZ02ONJP0WgVX1@000009
09miZ0030000002]PjL0[H>W00P0[H>W100000020:f3Y`030000002jSJL0^XfW00l0^XfW00<00000
0<JHZ036V:P03P36V:P00`000000dZBX0=:TZ0040=:TZ0<000001P3DWil00`000000hZjO0>:^W`07
0>:^W`050000003TZ9<0i:RC0000003d^Xd00`0000020?BjS@080000003f/GT0m[5i0000003m_Ul0
00000?>X=`00000H0?ooo`030000003oool0oooo00h0oooo000D0?ooo`040000003oool0oooo0000
00@0oooo0P00000V0?ooo`0500000000034000000000F`0000000P0a4GP50000000504<YS0000000
JdJB06]6TP0000001`1cE9l3000000D0RfBO0P00000808m^Z0030000002ONJP0WgVX0080WgVX1000
000809miZ0030000002]PjL0[H>W00L0[H>W100000030:f3Y`030000002jSJL0^XfW00l0^XfW00<0
00000<JHZ036V:P03P36V:P00`000000dZBX0=:TZ0050=:TZ0@000000`3DWil00`000000hZjO0>:^
W`090>:^W`<000000P3d^Xd2000000<0m;Z=00L000000?JaN@000000oKiO0000003cZ3L0000001P0
oooo00<000000?ooo`3oool03P3oool001D0oooo0P0000050?ooo`030000003oool0oooo02D0oooo
00H000000000<@000000001K0000000a4GP500000080@bV<0`00000807=DW`@0000000@0RfBO0000
0000000000002P2?KZP00`000000WgVX09miZ00409miZ0@000001P2ONJP00`000000[H>W0:f3Y`06
0:f3Ya4000002@2jSJL00`000000aYRX0<JHZ00>0<JHZ0030000003BY:P0dZBX00H0dZBX0P000000
1@3BY:P000000000003DWil0000000d0hZjO00@000000?BjS@3d^Xd0m;Z=0P0000030?BjS@800000
0P3m_Ul2000001P0oooo00<000000?ooo`3oool03P3oool001`0oooo00<000000?ooo`3oool09@3o
ool200000080001K1@00000404<YS0030000001cE9l0LeBO00L0LeBO0`0000000`1cE9l000000000
000=08m^Z0030000002ONJP0WgVX00H0WgVX1000000409miZ0030000002]PjL0[H>W0080[H>W2000
00040:j9[`030000002jTjl0^Y>_00H0^Y>_2`00000>0<JHZ0030000003BY:P0dZBX00L0dZBX0`00
00020=:TZ08000003@3R[Yl200000080m;Z=0`0000030?BjS@060000003m_Ul0oKiO0000003cZ3L0
00005`3oool00`000000oooo0?ooo`0>0?ooo`00703oool00`000000oooo0?ooo`0T0?ooo`030000
0000034000000080001K1000000404<YS0800000201cE9l6000000h0SfjX00<0000009miZ02ONJP0
202ONJP;000000030:j9[`0000000000008000001`2^RJl00`000000^Y>_0;ZC[`0?0;ZC[`030000
0035WJl0000000<000002P36V:P00`000000dZBX0=:TZ0070=:TZ0<000000`3BY:P3000000/0hZjO
00<000000?6oW00000000P3d^Xd2000000<0m;Z=00@000000?fnG`3m_Ul0oKiO0P00000G0?ooo`03
0000003oool0oooo00h0oooo000K0?ooo`030000003oool0oooo02D0oooo0P0000030000F`<00000
1013:H`00`000000DCjL0000000807=DW`<000000P1jH:T00`000000SfjX08m^Z00=08m^Z0030000
002ONJP0WgVX00D0WgVX2@0000030:j9[`D00000202^RJl00`000000^Y>_0;ZC[`0?0;ZC[`030000
0035WJl0aIf_00<0aIf_100000060<JHZ0030000003BY:P0dZBX00L0dZBX00@000000=:TZ0000000
00000P3BY:P00`000000gk:Y0=nbZ@02000000P0hZjO00D000000?6oW03a_i`0lKnL000000020?Bj
S@8000000P3d^Xd200000080oKiO0P00000G0?ooo`030000003oool0oooo00h0oooo000K0?ooo`03
0000003oool0oooo02D0oooo0P0000020000F`<000001013:H`01@000000DCjL054nW01A?Y`00000
00H0LeBO0`00000407YPZ@030000002?KZP0SfjX00`0SfjX00<0000009miZ02ONJP01@0000060:60
[`X000002@2^RJl00`000000^Y>_0;ZC[`0?0;ZC[`0300000035WJl0aIf_00L0aIf_100000020<JH
Z0030000003BY:P0dZBX00L0dZBX00<000000=:TZ03BY:P00`0000050=nbZ@030000003R[Yl0hZjO
00D0hZjO00<000000?6oW03a_i`00P3a_i`010000000m;Z=0000000000020?BjS@8000000`3m_Ul0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00h0oooo000K0?ooo`030000003oool0oooo
02D0oooo00@000000000F`0005/0001K0`00000304<YS0030000001A?Y`0DCjL0080DCjL00<00000
07=DW`1cE9l0101cE9l3000000@0NV2Y00<0000008m^Z02?KZP02`2?KZP4000000d0XH2_1P00000;
0:j9[`030000002jTjl0^Y>_00l0^Y>_00<000000<FM[`35WJl02`35WJl4000000P0dZBX00<00000
0=:TZ03BY:P00`0000060=nbZ@8000001@3R[Yl00`000000lKnL0?6oW0030?6oW0@0000000@0m;Z=
0000003obgd000000P3m_Ul00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00d0oooo000K
0?ooo`8000009P3oool00`000000001K0000F`03000000@0@bV<00<00000054nW01A?Y`00P1A?Y`0
0`000000LeBO07=DW`0207=DW`@000001@1jH:T00`000000SfjX08m^Z00808m^Z0<0000000<0TWJ`
0000002QP:l03P2QP:l00`000000[XV_0:j9[`0>0:j9[`030000002jTjl0^Y>_00l0^Y>_00<00000
0<FM[`35WJl03@35WJl00`000000d:V`00000002000000H0dZBX00<000000=:TZ03BY:P00P000008
0=nbZ@8000000`3R[Yl00`000000lKnL0?6oW0040?6oW0@000000P3obgd010000000oKiO0?fnG`00
000H0?ooo`030000003oool0oooo00d0oooo000K0?ooo`030000003oool0oooo02D0oooo00<00000
0000F`0005/00P0000001@0107/0000004<YS013:H`0000000D0DCjL00H0000007=DW`1cE9l0LeBO
0000001jH:T3000000D0NV2Y00<0000008m^Z02?KZP01@2?KZP3000000@0TWJ`00<000000:60[`2Q
P:l03P2QP:l00`000000[XV_0:j9[`0=0:j9[`030000002jTjl0^Y>_00h0^Y>_00<000000<FM[`35
WJl03P35WJl00`000000d:V`0=2Y/0020=2Y/0800000103BY:P00`000000dZBX0=:TZ002000000X0
gk:Y0`0000080?6oW0<000000`3obgd00`000000oKiO0000000H0?ooo`030000003oool0oooo00d0
oooo000K0?ooo`030000003oool0oooo02D0oooo00<000000000F`0000000P000000100107/00000
04<YS0000007054nW0<0000000@0NV2Y00000000000000001`1jH:T00`000000SfjX08m^Z00208m^
Z0800000202BM[000`000000XH2_0:60[`0=0:60[`030000002^RJl0[XV_00d0[XV_00<000000;ZC
[`2jTjl03P2jTjl00`000000aIf_0<FM[`0=0<FM[`030000003@ZK00d:V`00D0d:V`0`000000103B
Y:P000000=:TZ03BY:P3000000/0gk:Y00<000000?6oW03a_i`01`3a_i`2000000<0ol]m00<00000
0?fnG`000000603oool00`000000oooo0?ooo`0=0?ooo`006P3oool00`000000oooo0?ooo`0V0?oo
o`040000000005/00000000000800@1k0P000008054nW0040000001jH:T0NV2Y07YPZ@800000201j
H:T00`000000SfjX00000002000000X0TWJ`00<000000:60[`2QP:l03@2QP:l00`000000[XV_0:j9
[`0=0:j9[`030000002jTjl0^Y>_00h0^Y>_00<000000<FM[`35WJl03@35WJl00`000000d:V`0=2Y
/0080=2Y/0<0000000@0dZBX00000000000000002`3O/ZT2000000T0lKnL0P0000030?o;O@800000
603oool00`000000oooo0?ooo`0=0?ooo`006P3oool00`000000oooo0?ooo`0V0?ooo`@000000P01
07/00`000000DCjL054nW006054nW08000000`1jH:T2000000P0NV2Y0P00000=099f/0030000002Q
P:l0XH2_00d0XH2_00<000000:j9[`2^RJl01@2^RJlA000000P0^Y>_00<000000<FM[`35WJl03@35
WJl00`000000d:V`0=2Y/0090=2Y/0050000003@ZK0000000000003O/ZT00P0000090=nbZ@040000
003]a:T0kLBY000000P0lKnL0P0000030?o;O@<000005`3oool00`000000oooo0?ooo`0=0?ooo`00
6P3oool00`000000oooo0?ooo`0U0?ooo`@000000P0107/2000000L0DCjL00D0000005e?Z@1MCjT0
000007YPZ@03000000H0NV2Y0`00000>099f/0030000002QP:l0XH2_00/0XH2_2P0000080:n?]P03
0000002iV;H0^IRf00H0^IRf2`00000=0<FM[`030000003@ZK00d:V`00T0d:V`00<000000=2Y/03@
ZK00100000090=nbZ@050000003]a:T0kLBY0>g4Z@0000001`3a_i`2000000@0ol]m0P00000G0?oo
o`030000003oool0oooo00d0oooo000J0?ooo`8000009P3oool4000000800@1k00<0000001/KT`00
00001@1A?Y`01P000000GDnY05e?Z@1MCjT0000007YPZ@8000001P1jH:T01@000000P6bb081//P20
K;80000000h0TWJ`00<000000:60[`2QP:l01@2QP:l500000080XhNf00<000000:n?]P2_SkH03@2_
SkH00`000000^IRf0;VH]P0>0;VH]P0300000034X[H0a::f00D000001`35WJl00`000000d:V`0=2Y
/00:0=2Y/0030000003@ZK00000000<0g;Jb0P0000080=nbZ@030000003]a:T0kLBY0080kLBY00<0
00000?6oW03a_i`00`3a_i`3000000@0ol]m0P00000G0?ooo`030000003oool0oooo00d0oooo000J
0?ooo`030000003oool0oooo02D0oooo100000001@0107/0000001/KT`0K6i<0000000@0DCjL00<0
000005e?Z@1MCjT00P1MCjT4000000@0NV2Y0P000004081//P030000002BM[00TWJ`00`0TWJ`00<0
00000:60[`2QP:l01@0000070:>7]P030000002_SkH0[hnf00d0[hnf00<000000;VH]P2iV;H03P2i
V;H00`000000a::f0<BR]P050<BR]PD000000P35WJl00`000000d:V`0=2Y/00:0=2Y/0030000003@
ZK00000000<0g;Jb0`0000060=nbZ@030000003]a:T0kLBY00@0kLBY00<000000?6oW03a_i`00P3a
_i`010000000oM>D0000000000020?o;O@<00000603oool00`000000oooo0?ooo`0<0?ooo`006P3o
ool00`000000oooo0?ooo`0U0?ooo`@0000000D00@1k0000000K6i<06a^C00000003054nW0030000
001MCjT0GDnY00@0GDnY0P00000307YPZ@8000001P20K;800`000000TWJ`099f/00;099f/0@00000
3@2SQkH00`000000[hnf0:n?]P0<0:n?]P030000002iV;H0^IRf00d0^IRf00<000000<BR]P34X[H0
2`34X[H4000000X0d:V`0P0000000`3@ZK0000000=bf/P030=bf/P@00000103O/ZT00`000000kLBY
0>g4Z@050>g4Z@060000003a_i`0lKnL0?6oW0000000oM>D0P0000020?o;O@<00000603oool00`00
0000oooo0?ooo`0<0?ooo`006@3oool00`000000oooo0?ooo`0V0?ooo`<0000000<00@1k0000000K
6i<00P0K6i<010000000DCjL054nW000000705e?Z@8000000P1jH:T00`000000P6bb081//P07081/
/P030000002BM[00TWJ`00P0TWJ`0P0000000`2EO[P000000:>7]P0>0:>7]P030000002_SkH0[hnf
00`0[hnf00<000000;VH]P2iV;H03@2iV;H00`000000a::f0<BR]P0=0<BR]P040000003>[KP00000
000000D0d:V`0`0000020=2Y/0030000003L][80g;Jb00<0g;Jb0`0000000`3L][8000000=nbZ@02
0=nbZ@030000003]a:T0kLBY00h0000000@0ol]m0000000000000000603oool00`000000oooo0?oo
o`0<0?ooo`006@3oool00`000000oooo0?ooo`0V0?ooo`<0000000<00@1k0000000K6i<00`0K6i<2
000000L0GDnY1@00000:081//P030000002BM[00TWJ`00D0TWJ`0`00000409En^0030000002SQkH0
XhNf00`0XhNf00<000000:n?]P2_SkH0302_SkH00`000000^IRf0;VH]P0=0;VH]P0300000034X[H0
a::f00`0a::f00<000000<j]^03>[KP00P3>[KP5000000D0d:V`0P0000050=bf/P<0000000<0g;Jb
0000000000005P00000H0?ooo`030000003oool0oooo00`0oooo000I0?ooo`030000003oool0oooo
02H0oooo1000000501/KT`030000001MCjT0GDnY00H0GDnY0`00000<081//P030000002BM[00TWJ`
0080TWJ`0`00000709En^0030000002SQkH0XhNf00`0XhNf00<000000:n?]P2_SkH0302_SkH00`00
0000^IRf0;VH]P0=0;VH]P0300000034X[H0a::f00`0a::f00<000000<j]^03>[KP00`0000020<j]
^0<00000103@ZK02000000H0g;Jb2`0000060>g4Z@030000003mdi@0oM>D00D0000000<0kL]C0000
003oool05`3oool00`000000oooo0?ooo`0<0?ooo`006@3oool00`000000oooo0?ooo`0V0?ooo`@0
00001@0K6i<00`000000GDnY05e?Z@0605e?Z@<000003@20K;8010000000TWJ`00000000000:09En
^0030000002SQkH0XhNf00`0XhNf00<000000:n?]P2_SkH0302_SkH00`000000^IRf0;VH]P0=0;VH
]P0300000034X[H0a::f00`0a::f0`0000080<j]^080000000D0d:V`0000003L][80g;Jb00000006
0=bf/PL000002@3]a:T010000000oM>D0?gCU03mdi@6000001P0oooo00<000000?ooo`3oool0303o
ool001T0oooo0P00000W0?ooo`<000001@0K6i<00`000000<3FV0000000705e?Z@80000000<0Iejd
00000020K;802`20K;82000000`0UGjh00<000000:>7]P2SQkH03@2SQkH00`000000[hnf0:n?]P0;
0:n?]P030000002iV;H0^IRf00`0^IRf00<000000<BR]P34X[H02P34X[H4000000`0cZfh0P000003
0=bf/P030000003L][80g;Jb00H0g;Jb00@000000>S7]03Xak@00000203]a:T00`000000nMRW0000
00020?gCU0H00000603oool00`000000oooo0?ooo`0<0?ooo`006@3oool00`000000oooo0?ooo`0V
0?ooo`<000001@0K6i<00`000000<3FV0000000605e?Z@<0000000<0Iejd00000020K;802@20K;83
000000h0UGjh00<000000:>7]P2SQkH0302SQkH00`000000[hnf0:n?]P040:n?]Pl000001`2iV;H0
0`000000a::f0<BR]P060<BR]P@000000P34X[H00`000000cZfh0<j]^00<0<j]^0<000000P3L][80
0`000000g;Jb0=bf/P050=bf/P050000003Xak@0j<Nd0>S7]00000001`3]a:T00`000000nMRW0000
00020?gCU0H000006@3oool00`000000oooo0?ooo`0;0?ooo`00603oool00`000000oooo0?ooo`0W
0?ooo`@000000`0K6i<010000000<3FV030eYP00000505e?Z@@0000000<0Iejd00000020K;802020
K;801@000000QGJj08Ef^P25M[X0000000d0UGjh00<000000:>7]P2SQkH02P2SQkH9000000L0[iFl
00<000000;VM_02iWK`01@2iWK`:000000<0a::f0`0000060<BR]P030000003>[KP0cZfh00/0cZfh
00@000000=Vi^P3I^KX0fKVj0P0000000`3L][8000000=bf/P050=bf/P030000003Xak@0j<Nd0080
j<Nd0P0000050>g4Z@050000003if:L0nMRW0000003mdi@00P000000103ggg/0000000000000000I
0?ooo`030000003oool0oooo00/0oooo000H0?ooo`030000003oool0oooo02L0oooo1000000301/K
T`050000000`=JH0<3FV030eYP0000000`1MCjT010000000Iejd00000000000306MN]00300000020
K;80P6bb00@0P6bb0P00000408Ef^P030000002EO[P0UGjh00/0UGjh00<000000:>7]P2SQkH01@2S
QkH500000080Y8jm00<000000:nE_02_UK`02`2_UK`00`000000^Ifl0;VM_00<0;VM_00300000032
Y[d0`ZJm00@000002034X[H00`000000cZfh0<j]^00;0<j]^0030000003I^KX0fKVj00<0fKVj0P00
00050=bf/P030000003Xak@0j<Nd00D0j<Nd00D000000>g4Z@3]a:T0kLBY000000030?WHY`050000
003mdi@000000000003ggg/00`00000I0?ooo`030000003oool0oooo00/0oooo000H0?ooo`030000
003oool0oooo02L0oooo2P0000001P0`=JH0000005e?Z@1MCjT0000006MN]0<000000`1WG[@00`00
0000P6bb081//P02081//P8000001P25M[X00`000000UGjh09En^00<09En^0030000002SQkH0XhNf
00@000001`2TS[d00`000000[iFl0:nE_00;0:nE_0030000002iWK`0^Ifl00`0^Ifl0`0000040<:V
_@D000000P34X[H00`000000cZfh0<j]^00<0<j]^0030000003I^KX0fKVj00D0fKVj0P0000030=bf
/P030000003Xak@0j<Nd00H0j<Nd00@000000>g4Z@3]a:T00000103if:L3000000040?OON`000000
0000000001T0oooo00<000000?ooo`3oool02`3oool001P0oooo00<000000?ooo`3oool0:03ooolA
000000@0Iejd00D00000081//P20K;80P6bb0000000908Ef^P030000002EO[P0UGjh00X0UGjh1000
000;0:B>_@030000002_UK`0[iFl00/0[iFl00<000000;VM_02iWK`0202iWK`5000000/0`ZJm1000
000<0<j]^0030000003I^KX0fKVj00L0fKVj1000000:0>S7]08000001@3if:L3000000040?OON`00
00000000000001T0oooo00<000000?ooo`3oool02`3oool001P0oooo00<000000?ooo`3oool0:03o
ool5000000<0<3FV2@00000506MN]0<000002P25M[X00`000000UGjh09En^00709En^0<0000000<0
V8Jo0000002TS[d0302TS[d00`000000[iFl0:nE_00;0:nE_0030000002iWK`0^Ifl00D0^Ifl0`00
00040;VM_00300000032Y[d0`ZJm00/0`ZJm00<000000<b`_`0000000P0000090<j]^0030000003I
^KX0fKVj00P0fKVj00<000000=Vi^P0000002`3Xak@00`000000nMRW0?WHY`040?WHY`80000000@0
mmmk00000000000000006@3oool00`000000oooo0?ooo`0;0?ooo`00603oool2000002T0oooo0P00
00020000M`030000000`=JH0<3FV00@0<3FV00<0000006MN]01WG[@0201WG[@00`000000QGJj08Ef
^P0:08Ef^P030000002EO[P0UGjh00<0UGjh1000000509R6_`030000002TS[d0Y8jm00X0Y8jm00<0
00000:nE_02_UK`02`2_UK`00`000000^Ifl0;VM_0020;VM_0<000001P2iWK`00`000000`ZJm0<:V
_@0<0<:V_@030000003</;l0c;2o0080c;2o100000050<j]^0030000003I^KX0fKVj00T0fKVj0`00
00090>S7]08000001P3if:L200000080mmmk0P00000I0?ooo`030000003oool0oooo00/0oooo0004
0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000001@3oool00`000000oooo0?ooo`0Y
0?ooo`8000000P0007L00`000000<3FV030eYP03030eYP0300000012BkD0000000P0Iejd00<00000
06m[_@0000003025M[X00`000000UGjh00000002000000T0V8Jo00<000000:B>_@2TS[d02`2TS[d0
0`000000[iFl0:nE_00:0:nE_0030000002iWK`00000008000002@2iWK`00`000000`ZJm0<:V_@0;
0<:V_@030000003</;l0c;2o00L0c;2o0`0000000`3>[KP000000=Vi^P0;0=Vi^P80000000<0hlVm
0000003Xak@01`3Xak@00`000000lmZe000000050?WHY`8000000P3ggg/00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo00X0oooo00030?ooo`040000003oool0oooo000000/0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0Y0?ooo`8000000P0007L2000000@0<3FV00<00000
049;]@0000001`1WG[@010000000Kf^m06m[_@00000<08Ef^P800000302HQ[l00`000000Y8jm0:B>
_@0;0:B>_@030000002_UK`0[iFl00P0[iFl1000000<0;VM_00300000032Y[d0`ZJm00/0`ZJm00<0
00000<b`_`3</;l02P3</;l2000000`0fKVj0P0000020>?9_@030000003Xak@0j<Nd00@0j<Nd00@0
00000??J]@3cf[D00000103if:L300000080mmmk00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0:0?ooo`000`3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0:@3oool200000080001g0P000003030eYP0500000012BkD0@T^e049;]@00
00001@1WG[@00`000000Kf^m06m[_@0206m[_@0300000025M[X0QGJj00L0QGJj0`00000>09R6_`03
0000002TS[d0Y8jm00X0Y8jm00<000000:nE_02_UK`01@2_UK`300000080[iFl00<000000;VM_02i
WK`02`2iWK`00`000000`ZJm0<:V_@0;0<:V_@030000003</;l0c;2o00/0c;2o0`0000090=Vi^P04
0000003SbKd0hlVm00000080hlVm0P0000040>S7]0050000003cf[D0lmZe0??J]@0000000`3if:L3
00000080mmmk00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0:0?ooo`000`3oool01000
0000oooo0?ooo`0000080?ooo`<000001@3oool00`000000oooo0?ooo`0Y0?ooo`8000000P0007L2
000000<0<3FV00D00000049;]@12BkD0@T^e0000000406MN]0030000001_Jkd0Kf^m00<0Kf^m00<0
000008Ef^P25M[X01P25M[X01@000000RGo208Uo`P29Ol80000000d0V8Jo00<000000:B>_@2TS[d0
2P2TS[d00`000000[iFl0:nE_0020:nE_1T000002`32Y[d00`000000c;2o0<b`_`0:0<b`_`040000
003E_<80eKc20=Fl`P8000001`3I^KX01@000000hlVm0>?9_@3SbKd0000000<0hlVm00@000000>S7
]03Xak@00000103cf[D01@000000nMRW0?WHY`000000n^ZI0080000000<0mmmk0000000000006`3o
ool00`000000oooo0?ooo`0:0?ooo`000`3oool010000000oooo0?ooo`0000080?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0:@3oool3000000060000M`00000000bG0000000`=JH0
00001@12BkD010000000Iejd06MN]000000706m[_@0300000025M[X0QGJj00<0QGJj0P00000408Uo
`P030000002HQ[l0V8Jo00/0V8Jo00<000000:B>_@2TS[d01`2TS[d:000000H0[i_300<000000;RR
``2hX/<02`2hX/<00`000000`J_40<6[a004000000H0`ZJm00<000000<b`_`3</;l02`3</;l00`00
0000eKc20=Fl`P030=Fl`P800000103I^KX00`000000hlVm0>?9_@030>?9_@070000003SbKd0hlVm
0>?9_@000000j<Nd000000050??J]@040000003if:L000000?[ZV@80000000<0mmmk0000003oool0
6`3oool00`000000oooo0?ooo`0:0?ooo`000`3oool010000000oooo0?ooo`0000080?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0:P3oool30000008000bG00<00000030eYP000000
1@12BkD00`000000Iejd0000000906m[_@0500000025M[X0QGJj08Ef^P0000001`29Ol800`000000
V8Jo09R6_`0;09R6_`030000002TS[d0Y8jm00H0000000<0YIC40000000000000P00000;0:nK``03
0000002hX/<0^:;300/0^:;300<000000<6[a031Zl@01031Zl@400000080`ZJm00<000000<b`_`3<
/;l02P3</;l00`000000eKc20=Fl`P060=Fl`P8000000P3I^KX00`000000hlVm0>?9_@040>?9_@05
0000003SbKd0hlVm0>?9_@0000001P3cf[D2000000030?[ZV@000000000000<00000703oool00`00
0000oooo0?ooo`0:0?ooo`00103oool2000000T0oooo100000040?ooo`030000003oool0oooo02X0
oooo0`000003000<U`0300000012BkD0@T^e00D0@T^e00<0000006m[_@1_Jkd0201_Jkd010000000
QGJj00000000000808Uo`P030000002HQ[l0V8Jo00X0V8Jo100000040:FDa0<000000P2UU<@00`00
0000[i_30:nK``0:0:nK``030000002hX/<0^:;300X0^:;300<000000<6[a031Zl@02@31Zl@40000
00/0c;2o00<000000=Fl`P3E_<80203E_<82000000L0hlVm00<000000>?9_@3SbKd00P0000070??J
]@030000003jjYT0000000<000007@3oool00`000000oooo0?ooo`0:0?ooo`005P3oool00`000000
oooo0?ooo`0[0?ooo`<000000`0039L00`000000@T^e049;]@05049;]@8000002P1_Jkd00`000000
RGo208Uo`P0908Uo`P030000002HQ[l0V8Jo00H0V8Jo0`0000000`2JS/H000000:FDa0020:FDa0<0
00001P2UU<@00`000000[i_30:nK``090:nK``030000002hX/<0^:;300X0^:;300<000000<6[a031
Zl@02`31Zl@00`000000bKC600000002000000L0c;2o00<000000=Fl`P3E_<802@3E_<800`000000
g/_5000000070>?9_@050000003SbKd000000>gK`00000001@3cf[D2000000050?[ZV@0000000000
0000002e_S/07P3oool00`000000oooo0?ooo`090?ooo`005P3oool00`000000oooo0?ooo`0/0?oo
o`8000000`0039L2000000D0@T^e00<00000055M`@0000002@1_Jkd00`000000MgO60000000:08Uo
`P030000002HQ[l0V8Jo00<0V8Jo0`00000509Z>aP<000002@2UU<@00`000000[i_30:nK``0:0:nK
``030000002hX/<0^:;300T0^:;300<000000<6[a031Zl@02P31Zl@00`000000bKC60<VdaP030<Vd
aP8000001@3</;l00`000000eKc20=Fl`P090=Fl`P040000003NblD0g/_5000000L0hlVm00@00000
0>gK`03]fl0000001@3cf[D2000000030?[ZV@0000000000008000007P3oool00`000000oooo0?oo
o`090?ooo`005P3oool00`000000oooo0?ooo`0/0?ooo`8000000`0039L2000000D0@T^e00@00000
055M`@1AGL4000001`1_Jkd010000000MgO607MgaP00000;08Uo`P030000002HQ[l0000000800000
102JS/H5000000/0YIC400<000000:nK``2_Vl<02P2_Vl<00`000000^:;30;RR``090;RR``030000
0031Zl@0`J_400X0`J_400<000000<VdaP39]<H01@39]<H3000000030<b`_`000000eKc200X0eKc2
00<000000=k;a@3NblD00P3NblD00`000000hlVm0>?9_@040>?9_@8000000P3]fl0020000000lmZe
0??J]@3cf[D000000?O^/0000000n^ZI0`00000O0?ooo`030000003oool0oooo00T0oooo000F0?oo
o`030000003oool0oooo02`0oooo0P000003000<U`0300000008;Jl0000000<0@T^e00D00000055M
`@1AGL40DEg10000000606m[_@030000001gMlH0MgO60080MgO600<0000008Uo`P29Ol802029Ol82
000000@0VXk60`00000409Z>aP030000002UU<@0YIC400T0YIC400<000000:nK``2_Vl<02P2_Vl<0
0`000000^:;30;RR``090;RR``0300000031Zl@0`J_400T0`J_400<000000<VdaP39]<H02@39]<H2
000000/0eKc200<000000=k;a@3NblD00`3NblD00`000000hlVm0>?9_@020>?9_@060000003]fl00
kM_00000003]fl0000000`3cf[D010000000mnj`0000003jjYT3000001l0oooo00<000000?ooo`3o
ool02@3oool001H0oooo00<000000?ooo`3oool0;03oool30000008000bG00<0000000P][`000000
0`12BkD00`000000DEg1055M`@02055M`@030000001_Jkd0Kf^m0080Kf^m00<0000007MgaP1gMlH0
0`1gMlH00`000000RGo208Uo`P0608Uo`P80000000<0SHS90000002JS/H00`00000809Z>aP030000
002UU<@0YIC400T0YIC400<000000:nK``2_Vl<02@2_Vl<00`000000^:;30;RR``080;RR``030000
0031Zl@0`J_400X0`J_400<000000<VdaP39]<H02@39]<H010000000dKo90000000000080=Fl`P03
0000003NblD0g/_500D0g/_500@000000>?9_@3SbKd000000`3]fl001P000000kM_00>gK`0000000
lmZe000000<0mnj`1000000O0?ooo`030000003oool0oooo00T0oooo000F0?ooo`030000003oool0
oooo02d0oooo0P0000000`0039L0000000P][`0200P][`0300000012BkD0000000H0DEg100@00000
06m[_@1_Jkd000001`1gMlH00`000000RGo208Uo`P0308Uo`P8000000P2=R<T3000000/0VXk600<0
00000:FDa02UU<@02@2UU<@00`000000[i_30:nK``030:nK```000001@2hX/<00`000000`J_40<6[
a0090<6[a00300000039]<H0bKC600X0bKC600@000000=6ob@3A_lT0dKo90P0000060=Fl`P030000
003NblD0g/_500H0g/_500<000000>?9_@000000103]fl001@000000kM_00000003cf[D0000000<0
mnj`0`00000P0?ooo`030000003oool0oooo00T0oooo000E0?ooo`030000003oool0oooo02h0oooo
1000000300P][`0300000012BkD0000000H0DEg100<0000006m[_@0000002@1gMlH010000000RGo2
08Uo`P29Ol8500000080SHS900<0000009Z>aP2JS/H02@2JS/H00`000000YIC40:FDa0070:FDa0P0
00001P2_XLT00`000000]jO90;NWb@030;NWb@P000002@31Zl@00`000000bKC60<VdaP090<VdaP03
0000003A_lT0dKo900@0dKo90P0000030=Fl`P030000003NblD0g/_500P0g/_500<000000>gK`03]
fl00103]fl000`000000kM_0000000040?O^/0<00000803oool00`000000oooo0?ooo`090?ooo`00
5@3oool2000002l0oooo1000000400P][`030000001AGL40DEg100H0DEg100<0000007MgaP1gMlH0
201gMlH00`000000RGo200000002000000H0SHS900<0000009Z>aP2JS/H02P2JS/H00`000000YIC4
0:FDa00600000080YY_;00<000000:nQb@2_XLT02@2_XLT00`000000]jO90;NWb@080;NWb@030000
002n[lX0_Zo:00H000000P31Zl@00`000000bKC60<VdaP0:0<VdaP030000003A_lT0dKo900H0dKo9
0P0000000`3E_<8000000=k;a@080=k;a@030000003VflX0000000H0kM_00P0000030?O^/0@00000
803oool00`000000oooo0?ooo`090?ooo`005@3oool00`000000oooo0?ooo`0_0?ooo`<000001008
;Jl2000000H0DEg100<0000005i]bP000000201gMlH3000000X0SHS900<0000009Z>aP2JS/H0202J
S/H4000000P0YY_;00<000000:nQb@2_XLT02@2_XLT00`000000]jO90;NWb@080;NWb@030000002n
[lX0_Zo:00H0_Zo:1000000:0<VdaP030000003A_lT0dKo900T0dKo900<000000=k;a@3NblD01`3N
blD010000000i]_:0>KKbP0000060>gK`08000000`3gk[0400000240oooo00<000000?ooo`3oool0
203oool001D0oooo00<000000?ooo`3oool0;`3oool4000000<022f_0P000006055M`@030000001N
KLX0000000D0MgO60`000000101gMlH0000007f2c@00000:08f8b@030000002JS/H0VXk600<0VXk6
100000000`2LU/d000000:JKb`0:0:JKb`030000002_XLT0[j7900P0[j7900<000000;NWb@2gYlT0
202gYlT00`000000_Zo:0;j_bP080;j_bP0300000036]l`00000008000001P39]<H00`000000dKo9
0=6ob@090=6ob@030000003Ic<d0000000L0g/_500<000000>KKbP3VflX00P3VflX00`000000kM_0
0>gK`0020>gK`0030000003akl40000000<0mnj`0`00000R0?ooo`030000003oool0oooo00P0oooo
000E0?ooo`030000003oool0oooo0300oooo0`00000300P][`030000000TBL00000000@0DEg100H0
000005i]bP1NKLX0GVg:0000001gMlH3000000<0MgO600@0000007f2c@1mP/d000002P2=R<T00`00
0000VXk609Z>aP03000000H0W9K=00<000000:JKb`2VVl/0202VVl/00`000000[j790:nQb@080:nQ
b@030000002gYlT0]jO900P0]jO900<000000;j_bP2n[lX01`2n[lX00`000000a[O<0<Jgc0030<Jg
c0@000000P39]<H00`000000dKo90=6ob@080=6ob@050000003Ic<d0fLc=0=W<c@0000001P3NblD0
0`000000i]_:0>KKbP020>KKbP050000003]fl00kM_00>gK`00000000P3akl4200000080mnj`0`00
000R0?ooo`030000003oool0oooo00P0oooo000E0?ooo`030000003oool0oooo0300oooo10000002
00P][`040000000TBL0094W0000000<0DEg100<0000005i]bP0000000`00000407MgaP800000101m
P/d00`000000SHS908f8b@0808f8b@8000002@2LU/d00`000000YY_;0:JKb`080:JKb`030000002_
XLT0[j7900P0[j7900<000000;NWb@2gYlT01`2gYlT00`000000_Zo:0;j_bP080;j_bP0300000036
]l`0a[O<00L0a[O<0P00000:0=6ob@030000003Ic<d0fLc=00<0fLc=0P0000030=k;a@030000003V
flX0i]_:00@0i]_:00<000000>gK`0000000103akl4600000280oooo00<000000?ooo`3oool0203o
ool001@0oooo00<000000?ooo`3oool0<P3oool30000000300P][`00000094W000<094W000<00000
055M`@0000000P00000405i]bP040000001gMlH0MgO6000000H0OH;=00<0000008f8b@2=R<T01P2=
R<T200000003096Ad0000000W9K=00P0W9K=00<000000:JKb`2VVl/0202VVl/00`000000[j790:nQ
b@080:nQb@030000002gYlT0]jO900L0]jO900<000000;j_bP2n[lX0202n[lX00`000000a[O<0<Jg
c0070<Jgc0040000003=`Ll00000000000P0dKo900<000000=W<c@3Ic<d01@3Ic<d00`000000g/_5
000000070>KKbP030000003]fl00000000@0lNo11@00000S0?ooo`030000003oool0oooo00P0oooo
000D0?ooo`030000003oool0oooo0380oooo0P0000000`00098000000000000302A9`0@000001P1N
KLX00`000000MgO60000000807f2c@030000002=R<T0SHS900<0SHS90P000003096Ad0030000002L
U/d0W9K=00P0W9K=00<000000:JKb`2VVl/0202VVl/00`000000[j790:nQb@070:nQb@030000002g
YlT0]jO900L0]jO900<000000;j_bP2n[lX01`2n[lX00`000000a[O<0<Jgc0080<Jgc0040000003=
`Ll0cL7?0<g1c`8000001@3A_lT00`000000fLc=0=W<c@070=W<c@030000003VflX0i]_:00L0i]_:
00<000000?7_`@3akl400`3akl45000002<0oooo00<000000?ooo`3oool0203oool001@0oooo0P00
000c0?ooo`80000000<0002B0000000000000`00000202A9`0030000001NKLX0GVg:00H0GVg:00<0
000007f2c@1mP/d0201mP/d01@000000SHS908f8b@2=R<T0000000H0TI7@00<0000009bFc@2LU/d0
1`2LU/d00`000000YY_;0:JKb`080:JKb`030000002_XLT0[j790080[j792P0000050;NWb@030000
002n[lX0_Zo:00L0_Zo:00<000000<Jgc036]l`01`36]l`00`000000cL7?0<g1c`040<g1c`800000
0P3A_lT00`000000fLc=0=W<c@070=W<c@030000003Ofm80000000L0i]_:0P0000050?7_`@030000
003NlYL0g_:G008000008`3oool00`000000oooo0?ooo`080?ooo`00503oool00`000000oooo0?oo
o`0c0?ooo`@000001@0TBL02000000L0GVg:0P00000907f2c@040000002=R<T00000000000L0TI7@
00<0000009bFc@2LU/d01`2LU/d00`000000YY_;0:JKb`060:JKb`L000001@2^Ym000`000000]Jg@
0;F]d0020;F]d0X00000102n[lX00`000000a[O<0<Jgc0080<Jgc0030000003=`Ll0cL7?00H0cL7?
0P0000090=W<c@040000003Ofm80gm_B000000H0i]_:00<000000>[^cP000000103akl4200000004
0=kbU`0000000000000002@0oooo00<000000?ooo`3oool01`3oool001@0oooo00<000000?ooo`3o
ool0<03oool3000000030?ooo`000000002B00800000100TBL000`000000>V3>0000000505i]bP04
0000001YNm80JG_B000000T0OH;=00<00000096Ad02ATM00202ATM000`000000W9K=09bFc@0709bF
c@030000002VVl/0YY_;00D000000P2VX]400`000000[ZO@0:jWd0070:jWd0030000002e[M00]Jg@
00L0]Jg@00<000000;bcd@2l/m400P2l/m46000000P0a[O<00<000000<g1c`3=`Ll01`3=`Ll00`00
0000dlgD000000070=W<c@030000003Ofm80gm_B0080gm_B00<000000>KKbP3VflX00P3VflX01000
0000j^k>0>[^cP0000040?7_`@80000000D0g_:G0000003oool0oooo0000000S0?ooo`030000003o
ool0oooo00L0oooo000D0?ooo`030000003oool0oooo02d0oooo0`0000040?ooo`05000000000980
0000000Y/`0000000`0TBL0010000000>V3>03YPcP00000405i]bP050000001YNm80JG_B06UkdP00
00001`1mP/d00`000000Q8gD0000000:096Ad0030000002LU/d0W9K=00@0W9K=1@0000070:JRd@03
0000002^Ym00[ZO@00L0[ZO@00<000000;F]d02e[M001`2e[M000`000000_;?A0;bcd@060;bcd@04
00000032^m<00000000000D0a[O<00<000000<g1c`3=`Ll0203=`Ll010000000dlgD0=?=e0000006
0=W<c@030000003Ofm80gm_B0080gm_B00<000000>KKbP3VflX00P3VflX010000000j^k>0>[^cP00
00030?7_`@80000000<0g_:G0000003oool00`3oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo00L0oooo000C0?ooo`030000003oool0oooo02/0oooo0`0000080?ooo`04000000000980
00000000008094W000<0000003YPcP0jH<h00P0jH<h010000000GVg:05i]bP00000406UkdP030000
001mP/d0OH;=00<0OH;=0P00000308B=e0030000002ATM00TI7@00L0TI7@00<0000009bFc@2LU/d0
1000000209jMd`030000002VX]40YZ;A00P0YZ;A00<000000:jWd02^Ym001P2^Ym000`000000]Jg@
0;F]d0060;F]d0030000002l/m40_;?A00H0_;?A00<000000<:kd`32^m<00P32^m<300000080a[O<
00<000000<g1c`3=`Ll01`3=`Ll00`000000dlgD0=?=e0020=?=e08000000`3Ic<d00`000000gm_B
0=oKdP040=oKdP040000003VflX0i]_:000000@0j^k>00L000000?7_`@000000ho^e0000003NlYL0
000000D0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`070?ooo`004`3oool00`00
0000oooo0?ooo`0W0?ooo`@000002`3oool01`000000002B00000000:K<0000002A9`00000001@0j
H<h00`000000GVg:0000000506UkdP050000001mP/d0OH;=07f2c@0000001P24SM@00`000000TI7@
096Ad007096Ad08000001`2NWM<00`000000YZ;A0:JRd@070:JRd@030000002^Ym00[ZO@00H0[ZO@
00<000000;F]d02e[M001P2e[M000`000000_;?A0;bcd@060;bcd@0300000032^m<0`[_C00D0`[_C
0P0000090<g1c`030000003CcM@0dlgD00D0dlgD00<000000=W<c@0000001`3Ofm800`000000i]_:
000000050>[^cP8000000P3SnkD2000000L0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`070?ooo`004`3oool00`000000oooo0?ooo`0T0?ooo`<00000403oool20000008002Vc0P00
000603YPcP030000001YNm80JG_B00D0JG_B00<0000007f2c@0000001`24SM@00`000000TI7@096A
d005096Ad080000000<0U9[G0000002NWM<01P2NWM<00`000000YZ;A0:JRd@070:JRd@030000002^
Ym00[ZO@00H0[ZO@00<000000;F]d02e[M001P2e[M000`000000_;?A0;bcd@050;bcd@0300000032
^m<0`[_C00H0`[_C00@000000<O3eP00000000001P3=`Ll00`000000dlgD0=?=e0070=?=e0030000
003Ofm80gm_B00L0gm_B00<000000>[^cP3Zk/h0103Zk/h200000080ho^e0P0000070?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool01`3oool001<0oooo00<000000?ooo`3oool08@3o
ool3000001@0oooo00D00000000Y/`00:K<002Vc0000000603YPcP8000001`1YNm800`000000Q8gD
08B=e00708B=e0030000002ATM00TI7@0080TI7@0P00000309BJe`030000002NWM<0WYgC00H0WYgC
00<000000:JRd@2VX]401P2VX]400`000000[ZO@0:jWd0060:jWd0030000002e[M00]Jg@00H0]Jg@
00<000000;bcd@2l/m401@2l/m400`000000`[_C0<:kd`060<:kd`0400000037`mH0al?F0<O3eP80
0000103=`Ll00`000000dlgD0=?=e0060=?=e0030000003GfMT0000000L0gm_B0P0000060>[^cP03
0000003SnkD0ho^e008000002@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00L0
oooo000C0?ooo`8000007`3oool3000001L0oooo0P000002000Y/`8000001@0jH<h00`000000CW?H
0000000506UkdP030000001cR=X0000000T0Q8gD00@00000096Ad000000000001P2DV]L00`000000
WYgC09jMd`0509jMd`030000002VX]40YZ;A00L0YZ;A00<000000:jWd02^Ym001@2^Ym000`000000
]Jg@0;F]d0050;F]d0030000002l/m40_;?A00D0_;?A00<000000<:kd`32^m<01P32^m<00`000000
al?F0<O3eP040<O3eP80000000<0cL7?0000003CcM@01`3CcM@010000000emWI0=OIf@0000060=oK
dP030000003RjmL0000000D0j^k>0P0000020>?k]@030000003oool0oooo00T0oooo00<000000?oo
o`3oool07@3oool00`000000oooo0?ooo`060?ooo`004`3oool00`000000oooo0?ooo`0J0?ooo`@0
00006`3oool01000000002Vc000Y/`00:K<2000000@0>V3>00@0000004icf01>LmP00000101YNm80
10000000LhSJ07>8fP00000908B=e0030000002DV]L0U9[G00H0U9[G00<0000009jMd`2NWM<01P2N
WM<00`000000YZ;A0:JRd@040:JRdAH00000102l/m400`000000`[_C0<:kd`060<:kd`0300000037
`mH0al?F00H0al?F00<000000=?=e03CcM@01P3CcM@00`000000emWI0=OIf@020=OIf@030000003O
fm80gm_B0080gm_B00@000000>;[e`3RjmL000000`3Zk/h300000080ho^e0P00000<0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool01P3oool00180oooo00<000000?ooo`3oool0603o
ool300000200oooo00H00000000Y/`00:K<0000000I<bP00000203YPcP030000001>LmP0CW?H0080
CW?H00@0000006UkdP1YNm800000101cR=X2000000H0Q8gD00<0000008VGf`000000202DV]L00`00
0000WYgC09jMd`0509jMd`030000002VX]40YZ;A00@000000P2VZMP00`000000[JgG0:f]e`050:f]
e`030000002c/]L0/k;G00D0/k;G00@000000;Rhf02h^=P0^;SH1@0000070<:kd`0300000037`mH0
al?F00H0al?F00<000000<c=fP0000001P3CcM@00`000000emWI0=OIf@040=OIf@040000003Ofm80
gm_B000000@0h^_G00<000000>[^cP0000000P3RoL/010000000ho^e00000000000>0?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool01P3oool00180oooo00<000000?ooo`3oool05@3o
ool3000002<0oooo0P0000001`00:K<0000000I<bP06C<X0000003YPcP0000001@1>LmP00`000000
JG_B0000000607>8fP0400000024SM@0Q8gD08B=e08000000`29Um/00`000000U9[G09BJe`0609BJ
e`030000002NWM<0WYgC00@0WYgC0`0000060:JYf0030000002][ML0[JgG00D0[JgG00<000000;>b
e`2c/]L01@2c/]L00`000000^;SH0;Rhf0040;Rhf0040000002m_]X00000000000@0`[_C00<00000
0<O3eP37`mH01P37`mH010000000c<gJ0<c=fP3<cMX2000000<0dlgD00<000000=OIf@3GfMT01@3G
fMT00`000000gm_B000000050>;[e`8000000`3RoL/00`000000ho^e0000000?0?ooo`030000003o
ool0oooo01/0oooo00<000000?ooo`3oool01P3oool00180oooo00<000000?ooo`3oool04P3oool3
000002L0oooo0`00000300I<bP8000001P1>LmP00`000000LhSJ07>8fP0607>8fP0300000024SM@0
000000H0RIOK00<0000009BJe`2DV]L01@2DV]L00`000000WYgC09jMd`0400000080WjKJ00<00000
0:JYf02VZMP01@2VZMP00`000000[JgG0:f]e`040:f]e`030000002c/]L0/k;G00@0/k;G00<00000
0;Rhf02h^=P0102h^=P00`000000_KkJ0;fnfP020;fnfP8000000P32^m<00`000000al?F0<O3eP05
0<O3eP030000003<cMX0c<gJ00@0c<gJ00<000000=?=e00000002@3GfMT00`000000h^_G0>;[e`04
0>;[e`030000003RoL/0h_g;0080h_g;0P00000A0?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool01P3oool00180oooo00<000000?ooo`3oool03P3oool4000002/0oooo0`00000300I<
bP030000001>LmP0CW?H00@0CW?H0P00000807>8fP0300000029Um/0RIOK00H0RIOK00<0000009BJ
e`2DV]L01@2DV]L2000000H0WjKJ00<000000:JYf02VZMP01@2VZMP00`000000[JgG0:f]e`040:f]
e`030000002c/]L0/k;G00@0/k;G00<000000;Rhf02h^=P0102h^=P00`000000_KkJ0;fnfP040;fn
fP<000001P37`mH00`000000c<gJ0<c=fP060<c=fP030000003GfMT0emWI00H0emWI0`0000050>;[
e`8000000`3RoL/300000180oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`060?oo
o`004P3oool00`000000oooo0?ooo`0;0?ooo`<00000<03oool2000000<01Tc:0P00000504icf003
0000001NQ=l0000000H0LhSJ00<0000007bEh00000002029Um/00`000000U9[G09BJe`0209BJe`80
000000<0V:?M0000002OY]X01P2OY]X00`000000YZWH0:JYf0040:JYf0030000002][ML0[JgG00@0
[JgG00<000000;>be`2c/]L0102c/]L00`000000^;SH0;Rhf0040;Rhf0030000002m_]X0_KkJ00@0
_KkJ00<000000<;5g@32aMd00`0000020<O3eP030000003<cMX0c<gJ00H0c<gJ00<000000<oHg`00
00001@3GfMT200000080fNOO00<000000>;[e`3RjmL00P3RjmL00`000000g?[J000000030>;mb`80
0000503oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00H0oooo000B0?ooo`800000
2@3oool3000003<0oooo00<000000000R00000000P06C<X00`0000009fSJ0000000404icf0030000
001NQ=l0GXCO00800000101cR=X00`000000O9GP07bEh002000000L0RIOK00@0000009BJe`000000
0000102HXmd00`000000WjKJ09nVfP0409nVfP030000002VZMP0YZWH00@0YZWH00<000000:f]e`2]
[ML0102][ML00`000000/k;G0;>be`040;>be`030000002h^=P0^;SH00<0^;SH00<000000;fnfP2m
_]X0102m_]X00`000000`/GM0<;5g@040<;5g@800000203<cMX010000000cmSO0<oHg`0000040=OI
f@030000003Iiml0fNOO0080fNOO00D000000>;[e`3RjmL0h^_G000000020=cjfP030000003RoL/0
h_g;008000005P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00D0oooo00090?oo
o`@00000103oool2000000L0oooo0`00000g0?ooo`<0000000@01Tc:0000000WJ=X09fSJ0P000000
0`1>LmP0000005j4g`0405j4g`040000001cR=X0LhSJ000000D0O9GP00<0000008VGf`29Um/01@29
Um/00`000000V:?M09RSg@0509RSg@030000002OY]X0WjKJ00@0WjKJ00<000000:JYf02VZMP0102V
ZMP00`000000[JgG0:f]e`06000000<0/k;G00<000000;Rhf02h^=P0102h^=P00`000000_KkJ0;fn
fP040;fnfP0300000032aMd0`/GM00@0`/GM00<000000<G=h@0000001@3<cMX2000000@0cmSO00@0
00000=OIf@00000000001P3Iiml00`000000h^_G000000020=cjfP030000003RoL/0h_g;00800000
5`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00D0oooo000;0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00P3oool4000003/0oooo0`0000000`06C<X0000002MX
fP0202MXfP8000001P1NQ=l00`000000LhSJ0000000607bEh00300000029Um/0RIOK0080RIOK0P00
00000`2?XN40000009RSg@0609RSg@030000002OY]X0WjKJ00<0WjKJ00@000000:JYf02VZMP0YZWH
1P0000030:^dg`030000002`^=l0/;SO00H000000`2h^=P00`000000_KkJ0;fnfP040;fnfP030000
0032aMd0`/GM00@0`/GM00D000000<G=h@35cN40aLgQ000000030<c=fP030000003?f=l0cmSO00D0
cmSO00<000000=WWg`3Iiml01P3Iiml2000000<0g?[J00@000000>;mb`00000000006@3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo00D0oooo000;0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`0000000P0000100?ooo`@00000100WJ=X00`000000GXCO05j4g`0505j4g`03
0000001lUN00O9GP00H0O9GP0P0000000`29Um/0000008nQh@0308nQh@030000002HXmd0V:?M00D0
V:?M00@0000009nVfP2OY]X0WjKJ1@0000030:Jah0030000002[]=l0ZkCO00<0ZkCO00<000000;2h
g`2`^=l00`2`^=l00`000000];cP0;Blh006000000<0_KkJ00<000000<;5g@32aMd00`32aMd20000
00D0aLgQ00<000000<c=fP0000001P3?f=l3000000P0fNOO00<000000=cjfP3Ln]X00P3Ln]X40000
01X0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`050?ooo`002`3oool00`000000
oooo0?ooo`030?ooo`800000A03oool3000000@09fSJ0`00000505j4g`<00000201lUN000`000000
Sj7Q08nQh@0408nQh@8000001P2HXmd3000000<0XJkQ00<000000:Jah02V/N000`2V/N000`000000
ZkCO0:^dg`020:^dg`030000002`^=l0/;SO0080/;SO00<000000;Blh02d_>000`2d_>0010000000
^<7Q0;S1h@2h`N43000000D0`/GM00<000000<G=h@35cN401P35cN400`000000cmSO0<oHg`040<oH
g`050000003@hnD0d>?U0=3Si@0000001@3Iiml3000000@0g?[J00<000000;ch]P000000703oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00D0oooo000;0?ooo`030000003oool0oooo
00@0oooo0`0000130?ooo`0400000000;K800000000000<09fSJ00<0000004=oi0000000101NQ=l0
10000000KI?V06fCiP00000607bEh00400000025X>D00000000000H0Sj7Q00@0000009RSg@2HXmd0
V:?M0P0000000`2J[N@000000:6^h@030:6^h@030000002V/N00Y[7P00<0Y[7P00<000000:^dg`2[
]=l00P2[]=l00`000000/;SO0;2hg`020;2hg`030000002d_>00];cP00<0];cP00<000000;S1h@2h
`N400P2h`N4010000000^/KT0000000000020<;5g@0300000035cN40aLgQ00D0aLgQ0P0000000`37
eND000000<oHg`030<oHg`030000003@hnD0d>?U0080d>?U00@000000=WWg`3Iiml0fNOO0P000002
0=Gei0030000003Ln]X0g?[J0080000000<0_?Rf0000003oool07@3oool00`000000oooo0?ooo`0D
0?ooo`030000003oool0oooo00D0oooo00090?ooo`<00000203oool00`000000oooo0?ooo`120?oo
o`0400000000;K800000000000809fSJ00<0000004=oi013On@00P00000205j4g`040000001]TnH0
KI?V06fCiP800000101lUN001@000000QJ3U08FPi@25X>D0000000H0Sj7Q00<0000009RSg@000000
102J[N@00`000000XJkQ0:6^h@020:6^h@030000002V/N00Y[7P0080Y[7P00<000000:^dg`2[]=l0
0P2[]=l00`000000/;SO0;2hg`020;2hg`030000002d_>00];cP0080];cP00<000000;S1h@2h`N40
0P2h`N400`000000^/KT0;[6i0020;[6i08000001P35cN42000000@0amGU00@000000<oHg`000000
00001P3@hnD3000000<0eOGT00D000000=cjfP3Ln]X000000<CodP02000001l0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`050?ooo`002`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0480oooo0P0000001000Em40000002MXfP00000404=oi0<000001@1]TnH20000
000307bEh0000000QJ3U00@0QJ3U0P00000508nQh@030000002J[N@0VZgT00@0VZgT00<000000:6^
h@2Q[^400P2Q[^400`000000Y[7P0:Jah0020:Jah0050000002[]=l0ZkCO0:^dg`0000000`2`^=l0
0`000000];cP0;Blh0020;Blh0030000002h`N40^<7Q0080^<7Q00<000000;[6i02ja^@00`2ja^@0
0`000000_<cV000000040<G=h@0300000037eND0amGU00D0amGU00<000000=3Si@3@hnD01@3@hnD2
000000D0eOGT0`0000000`34om8000000000000Q0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool01@3oool001H0oooo0P0000130?ooo`80000000@005OA00000000000000001@13On@0
0`000000KI?V06fCiP0506fCiP0300000025X>D0QJ3U00H0QJ3U0P000000102?XN4000000000002D
[>L2000000D0VZgT00D000000:6^h@2Q[^40XJkQ000000020:Jah0`000000`2d_>001@000000^<7Q
0;S1h@2h`N40000000D0^/KT00H000000;c<iP2lc>H0_<cV00000035cN42000000H0amGU0`000005
0=3Si@80000000<0c>k[0000003EmN@0103EmN@00`000000a?oB0<CodP02000002<0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`040?ooo`00603oool200000480oooo0P000002001G
d@8000001013On@3000000D0KI?V00@0000007ZPj`00000000001`25X>D00`000000U:cW09B/i`03
09B/i`030000002J[N@0VZgT00<0VZgT00<000000:6^h@2Q[^400`0000020:Fij0050000002X^nL0
Z;_W0:Rki`0000000`2[_^L00`000000[/7X0000000300000080^<7Q00<000000;[6i02ja^@00P2j
a^@2000000@0_<cV0P0000060<OEi@8000000P36g^X010000000d>?U0=3Si@3@hnD2000000<0c>k[
00@000000=Gei03EmN@0eOGT0P0000030<CodP030000003oool0oooo02<0oooo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`040?ooo`006@3oool2000004<0oooo00<00000001Gd@00Em40
0`00000204=oi0030000001ITN/0FI7[008000000`1]TnH010000000NZ3[07ZPj`1jX>/2000000@0
QJ3U00@0000008f/jP0000000000102D[>L00`000000VZgT09Z]i00309Z]i08000000P2Q^>T01@00
0000YKWX0:Fij02U^NP000000080Z;_W00@000000:^ni`2[_^L000000`2^`NP00`000000/<CY0;34
j@02000000@0^/KT00<000000;c<iP2lc>H00P2lc>H200000080_M;Z00@000000<OEi@37eND0amGU
0P0000050<KNjP<00000103<k^/00`000000eOGT0=Gei00300000080a?oB0P00000W0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0103oool001/0oooo00<000000?ooo`3oool0@@3o
ool00`00000005OA0000000201mgi080000000<0@goT0000001ITN/00P1ITN/3000000H0NZ3[0P00
000208FPi@040000002=[>X0SJcZ08f/jP8000000`2D[>L20000000509Z]i0000000000009fgj`00
00000P2Q^>T01@000000YKWX0:Fij02U^NP000000080Z;_W00@000000:^ni`2[_^L000000`2^`NP0
1@000000/<CY0;34j@000000//OZ0080000000<0^/KT0000002lc>H00P2lc>H2000000@0_M;Z00@0
00000<OEi@00000000001P36g^X2000000H0c>k[0`0000020<Gmi0@00000:@3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00@0oooo000L0?ooo`800000@P3oool3000000<07gOT0P00
000505VAj`030000001jX>/0NZ3[00H0NZ3[0P00000608f/jP8000000P2D[>L2000000@0WKO[00@0
00000:6hj@2Q^>T000000P2U^NP010000000Z;_W0:Rki`0000020:^ni`040000002^`NP0[/7X0000
0080/<CY00<000000;;7jP2banX00P2banX00`000000_<cV0;c<iP02000000H0_M;Z0P0000060<KN
jP80000000<0`nK_0000003<k^/0103<k^/2000000<0aOgT0P0000000`2AjkL000000?ooo`0Y0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0103oool001<0oooo100000070?ooo`80
0000@@3oool2000000D07gOT0`00000205VAj`030000001]XO000000008000001@1jX>/010000000
QJc^00000000000508f/jP8000000P2I]^`2000000<0WKO[00@000000:6hj@2Q^>T000000P2U^NP0
1@000000Z;_W0000002[_^L000000080[/7X00@000000;34j@2`a>T000000`2banX2000000030;;;
k0000000000000D0_M;Z0`0000000`2lf>h000000<KNjP030<KNjP8000000`33i^l00`000000c>k[
0<c^j`0400000080aOgT0P0000000`2AjkL000000?ooo`0/0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0103oool001D0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`100?ooo`<000000`0OMn@00`000000@i3_04>@k`020000000305VAj`000000KJ7`0080KJ7`0`00
00000`1jX>/0000008F/kP0308F/kP<000000P2=[>X010000000U;O_00000000000209Vfk0800000
0P2M]n/010000000XKSY0000002U^NP600000080[/7X00<000000;34j@0000000P2banX200000003
0;;;k000000000000080//o_00<000000;gBjP2md^X00P0000050;cHkP0400000036g^X000000000
00@0`nK_00@000000<c^j`00000000000`31m^l400000003097[]`000000oooo02h0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`040?ooo`005@3oool00`000000oooo0?ooo`080?oo
o`800000@P3oool3000000807gOT00@0000004>@k`13T>l0@i3_0P00000606fQl08000001`25[>h2
000000@0U;O_0P00000209Vfk080000000T0WKO[00000000000000000:;3l0000000Xl?`0000002T
a?001@000000102banX000000000002bbn`2000000@0//o_0`0000050;cHkP@000001033i^l40000
00@0`OK_0P000000102TmmX00000097[]`00000a0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool00`3oool000d0oooo100000040?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool0@03oool5000000D0@i3_0`00000406fQl0030000001m[_80OJkb00@000000P25[>h00`00
0000T;Oa0000000200000080U;O_0P00000209Vfk0D0000000D0X/?`00000000000000000:G5l005
000000030;;;k0000000000000<0//o_0`000000102ad_4000000;cHkP2lf>h400000080^Mkb00<0
00000<?Vk`0000000`0000020;_/m00400000031m^l0`OK_0<7fk`8000000P2TmmX3000003<0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`030?ooo`005@3oool00`000000oooo0?oo
o`0;0?ooo`800000@P3oool5000000<0@i3_00<0000005nRm01OX_@00`0000000`1]XO00000007f^
lP0507f^lP<00000102@]o430000000509Bgk`00000000000000002M`_803P0000020;;?k`<00000
0P2ad_45000000@0^Mkb100000050;_/m00300000031m^l0`OK_00<000000P2TmmX2000003D0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`030?ooo`004`3oool3000000h0oooo0P00
00120?ooo`80000000<006cH0000000000001000000405nRm0H00000101m[_800`000000S;Wd08bi
m00400000003092gl@000000000001<0000000<0/M;a0000000000000P0000020:oEm0030000002i
g_80^Mkb00@0000000<0]>;f0000002kk?@01P2kk?@5000000030:CgfP000000000003P0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`005@3oool00`000000oooo0?ooo`0>
0?ooo`800000@P3oool400000080:Hg]1@00000205nRm0040000001f/?L0M[3g07J`m`D000001P2<
^O@G00000080[mGd1`0000050;CRmP030000002kk?@0^ncd00H0000000<0[?O^0000000000000P00
000k0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00`3oool002P0oooo00<00000
0?ooo`3oool0@@3oool3000000<0:Hg]00<00000052Tm`1@Y?L01`00000307J`m`0300000028^oL0
R;_g0080R;_g6`0000040:cHmP030000002dh_H0]>;f00P000000P2^koL2000000030:cgkP000000
000000800000?P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00<0oooo000Y0?oo
o`800000@P3oool50000000302V=k@000000000000@0D:Cg00<0000006jcnP1^/oX03`0000000`2H
a_L0000000000008000000040:7=m`0000000000000000@0YmWi200000030:cUnP030000002^koL0
[^og00<0[^og1P0000110?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool0
02X0oooo0P0000130?ooo`T000000P1@Y?L00`000000K[?j06jcnP0406jcnP0300000026_OT0Q[gi
0080Q[gi0P00000208C1n`80000000<0V<Oh0000002Hb?P00P000000102JboP000000000002McOP3
000000D0X]Wk1`0000040:cUnP030000002^koL0[^og00D0000000<0S>gV000000000000@`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo000/0?ooo`030000003oool0oooo
04<0oooo0P00000200n9i0h000000`24`O/30000000308?4o@000000000000X000000P2Lf?`30000
0080X]Wk0P0000040:7Uo0L0000000@0Vngg000000000000S>gV0P0000160?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool00P3oool002d0oooo0`0000140?ooo`H000000P12Y_L20000
00@0J;Ol1@00000208?4o@8000000P24b?h01P000000Q/cn08K<oP000000R]3o00000080Sm?n00@0
000009GFoP00000000000`2Lf?`4000000@0XNGl0P00000409_]m`D00000B@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo0080oooo000_0?ooo`030000003oool0oooo04<0oooo00<0
00000?ooo`0000002P00000506Blo@<000000P24b?h010000000Q/cn08K<oP00000308[@o`040000
002?doh0Sm?n00000080UMKn0`00000409CRo@d00000C03oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0080oooo000`0?ooo`030000003oool0oooo0480oooo00@000000?ooo`3oool0
oooo0P0000001000QMH0000000000000000203RYl`8000000P1T_?d2000000<0I<;m3`00000408KM
oP@000001023iO@400000540oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?oo
o`00<@3oool200000440oooo00<000000?ooo`3oool0103oool<000000<0I<;m00<0000006O8o@1W
b?d00P1Wb?d01@000000K/om06k?o@1^cod0000000@0NMKm0P00000208KMoP8000000`1YfNl40000
05D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`020?ooo`00<`3oool2000003l0
oooo00<000000?ooo`3oool02@3oool60000000303>]k`000000000001P00000FP3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0080oooo000d0?ooo`800000?P3oool00`000000oooo
0?ooo`0?0?oooa@00000HP3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo
000f0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0QP3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0040oooo000g0?ooo`<00000>P3oool00`000000oooo0?ooo`27
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00@3oool002T0oooo0P0000040?oo
o`030000003oool0oooo0080oooo0`0000020?ooo`030000003oool0oooo03P0oooo00<000000?oo
o`3oool0R03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0040oooo000X0?ooo`04
0000003oool0oooo000000/0oooo00@000000?ooo`3oool00000>@3oool00`000000oooo0?ooo`28
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00@3oool002P0oooo00@000000?oo
o`3oool000002`3oool010000000oooo0?ooo`3oool2000003L0oooo00<000000?ooo`3oool0R@3o
ool01@000000oooo0?ooo`3oool0000000<0oooo000R0?ooo`@000000P3oool010000000oooo0?oo
o`0000080?ooo`<000001P3oool2000003D0oooo00<000000?ooo`3oool0RP3oool010000000oooo
0?ooo`0000030?ooo`00:03oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00L0
oooo0P00000d0?ooo`030000003oool0oooo08/0oooo00<000000?ooo`0000000`3oool002P0oooo
00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0340
oooo00<000000?ooo`3oool0S03oool00`000000oooo000000020?ooo`00:@3oool2000000T0oooo
100000090?ooo`800000<@3oool00`000000oooo0?ooo`2<0?ooo`030000003oool000000080oooo
00120?ooo`800000<03oool00`000000oooo0?ooo`2=0?ooo`8000000P3oool004@0oooo00<00000
0?ooo`3oool0;@3oool00`000000oooo0?ooo`2<0?ooo`<000000P3oool004D0oooo0`00000/0?oo
o`030000003oool0oooo08P0oooo100000050?ooo`00A`3oool00`000000oooo0?ooo`0Z0?ooo`03
0000003oool0oooo08<0oooo1@0000090?ooo`00A`3oool3000002X0oooo00<000000?ooo`3oool0
O`3oool4000000h0oooo001:0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0N`3o
ool400000180oooo001;0?ooo`8000009`3oool00`000000oooo0?ooo`1f0?ooo`D000005P3oool0
04`0oooo0P00000V0?ooo`030000003oool0oooo0780oooo1000000K0?ooo`00CP3oool00`000000
oooo0?ooo`0S0?ooo`030000003oool0oooo06d0oooo1@00000O0?ooo`00C`3oool2000002<0oooo
00<000000?ooo`3oool0J@3oool4000002@0oooo00150?ooo`8000002@3oool200000280oooo00<0
00000?ooo`3oool0I03oool5000002P0oooo00140?ooo`040000003oool0oooo000000X0oooo0P00
000P0?ooo`030000003oool0oooo0600oooo1000000]0?ooo`00A03oool010000000oooo0?ooo`00
000<0?ooo`8000007P3oool00`000000oooo0?ooo`1L0?ooo`@00000<@3oool004@0oooo00@00000
0?ooo`3oool00000303oool2000001h0oooo00<000000?ooo`3oool0E`3oool5000003D0oooo0014
0?ooo`040000003oool0oooo000000h0oooo0P00000L0?ooo`030000003oool0oooo05<0oooo1000
000j0?ooo`00A03oool010000000oooo0?ooo`00000@0?ooo`8000006P3oool00`000000oooo0?oo
o`1>0?ooo`D00000?P3oool004D0oooo0P00000B0?ooo`8000006@3oool00`000000oooo0?ooo`1:
0?ooo`@00000@`3oool005/0oooo00<000000?ooo`0000005P3oool00`000000oooo0?ooo`150?oo
o`D00000A`3oool005`0oooo0P00000F0?ooo`030000003oool0oooo0440oooo1000001<0?ooo`00
G@3oool2000001@0oooo00<000000?ooo`3oool0?P3oool400000500oooo001O0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0>@3oool5000005@0oooo001P0?ooo`8000004@3oool0
0`000000oooo0?ooo`0e0?ooo`@00000F@3oool00640oooo0P00000@0?ooo`030000003oool0oooo
0300oooo1@00001M0?ooo`00H`3oool2000000h0oooo00<000000?ooo`3oool0;03oool400000680
oooo001U0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0:03oool4000006H0oooo
001E0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000000P3oool2000000`0oooo00<0
00000?ooo`3oool08`3oool5000006X0oooo001D0?ooo`040000003oool0oooo000000/0oooo00@0
00000?ooo`3oool0oooo0`0000090?ooo`030000003oool0oooo01l0oooo1000001_0?ooo`00E03o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0J0?ooo`D00000L`3oool005@0oooo00@000000?ooo`3oool00000
203oool3000000H0oooo0`0000070?ooo`030000003oool0oooo01H0oooo1000001h0?ooo`00E03o
ool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00T0oooo0P0000050?ooo`030000
003oool0oooo0140oooo1@00001l0?ooo`00E03oool010000000oooo0?ooo`0000080?ooo`030000
003oool0oooo00X0oooo0P0000040?ooo`030000003oool0oooo00d0oooo100000210?ooo`00E@3o
ool2000000T0oooo1000000;0?ooo`050000003oool000000?ooo`0000002`3oool4000008D0oooo
001`0?ooo`80000000<0oooo0000003oool01@3oool5000008T0oooo001a0?ooo`<000000P3oool4
000008h0oooo001c0?ooo`<00000TP3oool00?l0oooo2@3oool00?l0oooo2@3oool00?l0oooo2@3o
ool00?l0oooo2@3oool006l0oooo1000002E0?ooo`00L@3oool00`000000oooo0?ooo`2D0?ooo`00
L@3oool00`000000oooo0?ooo`2D0?ooo`00L@3oool00`000000oooo0?ooo`2D0?ooo`00L@3oool0
0`000000oooo0?ooo`2D0?ooo`00K`3oool3000009H0oooo001a0?ooo`030000003oool0oooo09@0
oooo0000\
\>"],
  ImageRangeCache->{{{91.5625, 302.312}, {394.5, 165.188}} -> {-0.414409, \
0.689267, 0.00351649, 0.00351649}}]
}, Open  ]],

Cell[TextData[{
  "Tapaus b: (x1 < b/a < x2)\n{x1,x2,x3} = ",
  Cell[BoxData[
      \({1\/5, 4\/5, 3}\)]],
  "\n{\[Alpha],\[Beta],a,b} = {0.928616,1.,-1.75254,-1.18685}\nb/a = \
0.677219"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[kuvab];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08777 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0576738 1.16792 -2.79724e-17 1.16792 [
[.08885 .23035 -11.8346 -9 ]
[.08885 .23035 .16541 0 ]
[.21763 .17597 -22.6208 -9 ]
[.21763 .17597 1.37923 0 ]
[.35353 .11861 -5.39309 -9 ]
[.35353 .11861 .60691 0 ]
[.49716 .05803 -15.393 -9 ]
[.49716 .05803 2.60705 0 ]
[.6492 -0.00605 -4.86888 -9 ]
[.6492 -0.00605 1.13112 0 ]
[.00886 .82785 -6.92493 0 ]
[.00886 .82785 5.07507 9 ]
[.12049 .90619 -13.4177 0 ]
[.12049 .90619 10.5823 9 ]
[.22061 .97645 -3.26163 0 ]
[.22061 .97645 2.73837 9 ]
[.3109 1.03981 -9.54321 0 ]
[.3109 1.03981 8.45679 9 ]
[.39276 1.09724 -3.11047 0 ]
[.39276 1.09724 2.88953 9 ]
[.07322 .26204 -12 -2.61848 ]
[.07322 .26204 0 6.38152 ]
[.05471 .37835 -24 -2.72137 ]
[.05471 .37835 0 6.27863 ]
[.03459 .50481 -6 -2.83416 ]
[.03459 .50481 0 6.16584 ]
[.01263 .64281 -18 -2.95834 ]
[.01263 .64281 0 6.04166 ]
[-0.01142 .794 -6 -3.09573 ]
[-0.01142 .794 0 5.90427 ]
[ 0 0 0 0 ]
[ 1 1.08777 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08845 .24527 m
.67201 0 L
s
.09903 .24082 m
.10412 .24605 L
s
[(-1)] .08885 .23035 .97243 1 Mshowa
.22731 .1869 m
.23214 .19237 L
s
[(-0.5)] .21763 .17597 .88506 1 Mshowa
.36263 .13003 m
.36719 .13573 L
s
[(0)] .35353 .11861 .7977 1 Mshowa
.50562 .06993 m
.50984 .07588 L
s
[(0.5)] .49716 .05803 .71033 1 Mshowa
.65692 .00634 m
.66078 .01254 L
s
[(1)] .6492 -0.00605 .62296 1 Mshowa
.125 Mabswid
.12415 .23026 m
.12717 .23343 L
s
.14953 .21959 m
.15253 .22279 L
s
.17518 .20881 m
.17815 .21204 L
s
.2011 .19792 m
.20404 .20117 L
s
.25379 .17577 m
.25666 .17908 L
s
.28056 .16452 m
.28339 .16786 L
s
.30762 .15315 m
.31042 .15652 L
s
.33498 .14165 m
.33774 .14505 L
s
.3906 .11827 m
.39329 .12173 L
s
.41887 .10639 m
.42153 .10987 L
s
.44746 .09437 m
.45008 .09789 L
s
.47638 .08222 m
.47895 .08576 L
s
.53519 .0575 m
.53768 .0611 L
s
.5651 .04493 m
.56755 .04856 L
s
.59535 .03222 m
.59776 .03588 L
s
.62596 .01935 m
.62832 .02304 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-1)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-0.5)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(0.5)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(1)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
.08669 .25641 m
.09342 .25359 L
s
[(-1)] .07322 .26204 1 -0.41811 Mshowa
.06829 .37298 m
.07508 .3703 L
s
[(-0.5)] .05471 .37835 1 -0.39525 Mshowa
.04828 .49974 m
.05513 .4972 L
s
[(0)] .03459 .50481 1 -0.37019 Mshowa
.02644 .63807 m
.03335 .63571 L
s
[(0.5)] .01263 .64281 1 -0.34259 Mshowa
.00252 .78966 m
.00949 .78748 L
s
[(1)] -0.01142 .794 1 -0.31206 Mshowa
.125 Mabswid
.08313 .27897 m
.08717 .27729 L
s
.07951 .3019 m
.08356 .30024 L
s
.07583 .3252 m
.07989 .32356 L
s
.07209 .34889 m
.07616 .34727 L
s
.06442 .39748 m
.0685 .39588 L
s
.06049 .42239 m
.06458 .42081 L
s
.05649 .44773 m
.06058 .44617 L
s
.05242 .47351 m
.05652 .47197 L
s
.04407 .52643 m
.04818 .52493 L
s
.03978 .5536 m
.0439 .55211 L
s
.03541 .58125 m
.03954 .57979 L
s
.03097 .60941 m
.03511 .60796 L
s
.02184 .66727 m
.02599 .66588 L
s
.01714 .69701 m
.0213 .69564 L
s
.01236 .72731 m
.01652 .72596 L
s
.00749 .75819 m
.01166 .75686 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
.41815 .58175 m
.08845 .24527 L
s
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.41815 .58175 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
0 0 m
1 0 L
1 1.08777 L
0 1.08777 L
closepath
clip
newpath
.5 Mabswid
.739 .591 .691 r
.44786 .61772 m .50085 .62415 L .50244 .59379 L p F P
0 g
s
.739 .591 .691 r
.50244 .59379 m .45288 .58767 L .44786 .61772 L p F P
0 g
s
.705 .562 .69 r
.55282 .59353 m .50244 .59379 L .50085 .62415 L p F P
0 g
s
.737 .605 .711 r
.45288 .58767 m .50244 .59379 L .50427 .56337 L p F P
0 g
s
.706 .578 .71 r
.50244 .59379 m .55282 .59353 L .55067 .56312 L p F P
0 g
s
.706 .578 .71 r
.55067 .56312 m .50427 .56337 L .50244 .59379 L p F P
0 g
s
.705 .562 .69 r
.50085 .62415 m .55469 .62387 L .55282 .59353 L p F P
0 g
s
.67 .535 .691 r
.60223 .58688 m .55282 .59353 L .55469 .62387 L p F P
0 g
s
.673 .554 .711 r
.55282 .59353 m .60223 .58688 L .59615 .55689 L p F P
0 g
s
.673 .554 .711 r
.59615 .55689 m .55067 .56312 L .55282 .59353 L p F P
0 g
s
.737 .605 .711 r
.50427 .56337 m .45864 .55763 L .45288 .58767 L p F P
0 g
s
.734 .619 .731 r
.45864 .55763 m .50427 .56337 L .50632 .53311 L p F P
0 g
s
.706 .595 .729 r
.50427 .56337 m .55067 .56312 L .54825 .53288 L p F P
0 g
s
.706 .595 .729 r
.54825 .53288 m .50632 .53311 L .50427 .56337 L p F P
0 g
s
.676 .572 .731 r
.55067 .56312 m .59615 .55689 L .58933 .52715 L p F P
0 g
s
.676 .572 .731 r
.58933 .52715 m .54825 .53288 L .55067 .56312 L p F P
0 g
s
.741 .576 .67 r
.44362 .64756 m .49951 .65421 L .50085 .62415 L p F P
0 g
s
.741 .576 .67 r
.50085 .62415 m .44786 .61772 L .44362 .64756 L p F P
0 g
s
.705 .545 .669 r
.55469 .62387 m .50085 .62415 L .49951 .65421 L p F P
0 g
s
.705 .545 .669 r
.49951 .65421 m .55627 .65392 L .55469 .62387 L p F P
0 g
s
.667 .516 .67 r
.60753 .61689 m .55469 .62387 L .55627 .65392 L p F P
0 g
s
.67 .535 .691 r
.55469 .62387 m .60753 .61689 L .60223 .58688 L p F P
0 g
s
.734 .619 .731 r
.50632 .53311 m .4651 .52783 L .45864 .55763 L p F P
0 g
s
.731 .633 .75 r
.4651 .52783 m .50632 .53311 L .50857 .50323 L p F P
0 g
s
.705 .61 .749 r
.50632 .53311 m .54825 .53288 L .54559 .50303 L p F P
0 g
s
.705 .61 .749 r
.54559 .50303 m .50857 .50323 L .50632 .53311 L p F P
0 g
s
.678 .59 .75 r
.54825 .53288 m .58933 .52715 L .58183 .49788 L p F P
0 g
s
.678 .59 .75 r
.58183 .49788 m .54559 .50303 L .54825 .53288 L p F P
0 g
s
.767 .635 .715 r
.40592 .5753 m .45288 .58767 L .45864 .55763 L p F P
0 g
s
.767 .635 .715 r
.45864 .55763 m .41546 .54604 L .40592 .5753 L p F P
0 g
s
.762 .647 .735 r
.41546 .54604 m .45864 .55763 L .4651 .52783 L p F P
0 g
s
.772 .623 .694 r
.39759 .60473 m .44786 .61772 L .45288 .58767 L p F P
0 g
s
.772 .623 .694 r
.45288 .58767 m .40592 .5753 L .39759 .60473 L p F P
0 g
s
.742 .559 .647 r
.44021 .67695 m .49843 .68375 L .49951 .65421 L p F P
0 g
s
.742 .559 .647 r
.49951 .65421 m .44362 .64756 L .44021 .67695 L p F P
0 g
s
.703 .527 .647 r
.55627 .65392 m .49951 .65421 L .49843 .68375 L p F P
0 g
s
.638 .53 .716 r
.63904 .54483 m .59615 .55689 L .60223 .58688 L p F P
0 g
s
.644 .551 .736 r
.59615 .55689 m .63904 .54483 L .62801 .51607 L p F P
0 g
s
.644 .551 .736 r
.62801 .51607 m .58933 .52715 L .59615 .55689 L p F P
0 g
s
.703 .527 .647 r
.49843 .68375 m .55754 .68346 L .55627 .65392 L p F P
0 g
s
.663 .495 .647 r
.61199 .6467 m .55627 .65392 L .55754 .68346 L p F P
0 g
s
.667 .516 .67 r
.55627 .65392 m .61199 .6467 L .60753 .61689 L p F P
0 g
s
.632 .509 .695 r
.64889 .57401 m .60223 .58688 L .60753 .61689 L p F P
0 g
s
.638 .53 .716 r
.60223 .58688 m .64889 .57401 L .63904 .54483 L p F P
0 g
s
.762 .647 .735 r
.4651 .52783 m .42615 .51718 L .41546 .54604 L p F P
0 g
s
.755 .659 .755 r
.42615 .51718 m .4651 .52783 L .47221 .49849 L p F P
0 g
s
.731 .633 .75 r
.50857 .50323 m .47221 .49849 L .4651 .52783 L p F P
0 g
s
.726 .647 .77 r
.47221 .49849 m .50857 .50323 L .51102 .47397 L p F P
0 g
s
.703 .626 .768 r
.50857 .50323 m .54559 .50303 L .54269 .47379 L p F P
0 g
s
.703 .626 .768 r
.54269 .47379 m .51102 .47397 L .50857 .50323 L p F P
0 g
s
.679 .609 .77 r
.54559 .50303 m .58183 .49788 L .57369 .46931 L p F P
0 g
s
.679 .609 .77 r
.57369 .46931 m .54269 .47379 L .54559 .50303 L p F P
0 g
s
.776 .609 .673 r
.39056 .6341 m .44362 .64756 L .44786 .61772 L p F P
0 g
s
.776 .609 .673 r
.44786 .61772 m .39759 .60473 L .39056 .6341 L p F P
0 g
s
.649 .572 .755 r
.58933 .52715 m .62801 .51607 L .61589 .48795 L p F P
0 g
s
.649 .572 .755 r
.61589 .48795 m .58183 .49788 L .58933 .52715 L p F P
0 g
s
.625 .487 .673 r
.65748 .60337 m .60753 .61689 L .61199 .6467 L p F P
0 g
s
.632 .509 .695 r
.60753 .61689 m .65748 .60337 L .64889 .57401 L p F P
0 g
s
.755 .659 .755 r
.47221 .49849 m .43791 .48894 L .42615 .51718 L p F P
0 g
s
.748 .67 .774 r
.43791 .48894 m .47221 .49849 L .47992 .46984 L p F P
0 g
s
.726 .647 .77 r
.51102 .47397 m .47992 .46984 L .47221 .49849 L p F P
0 g
s
.654 .593 .775 r
.58183 .49788 m .61589 .48795 L .60276 .46069 L p F P
0 g
s
.654 .593 .775 r
.60276 .46069 m .57369 .46931 L .58183 .49788 L p F P
0 g
s
.742 .542 .623 r
.43765 .70566 m .49761 .71254 L .49843 .68375 L p F P
0 g
s
.742 .542 .623 r
.49843 .68375 m .44021 .67695 L .43765 .70566 L p F P
0 g
s
.701 .507 .623 r
.55754 .68346 m .49843 .68375 L .49761 .71254 L p F P
0 g
s
.78 .595 .649 r
.38488 .66318 m .44021 .67695 L .44362 .64756 L p F P
0 g
s
.78 .595 .649 r
.44362 .64756 m .39056 .6341 L .38488 .66318 L p F P
0 g
s
.701 .507 .623 r
.49761 .71254 m .55849 .71224 L .55754 .68346 L p F P
0 g
s
.658 .473 .623 r
.61559 .67607 m .55754 .68346 L .55849 .71224 L p F P
0 g
s
.663 .495 .647 r
.55754 .68346 m .61559 .67607 L .61199 .6467 L p F P
0 g
s
.618 .463 .65 r
.66473 .63269 m .61199 .6467 L .61559 .67607 L p F P
0 g
s
.625 .487 .673 r
.61199 .6467 m .66473 .63269 L .65748 .60337 L p F P
0 g
s
.721 .661 .789 r
.47992 .46984 m .51102 .47397 L .51364 .44555 L p F P
0 g
s
.701 .643 .788 r
.51102 .47397 m .54269 .47379 L .53959 .4454 L p F P
0 g
s
.701 .643 .788 r
.53959 .4454 m .51364 .44555 L .51102 .47397 L p F P
0 g
s
.68 .628 .79 r
.54269 .47379 m .57369 .46931 L .56496 .44168 L p F P
0 g
s
.68 .628 .79 r
.56496 .44168 m .53959 .4454 L .54269 .47379 L p F P
0 g
s
.797 .669 .722 r
.36334 .557 m .40592 .5753 L .41546 .54604 L p F P
0 g
s
.797 .669 .722 r
.41546 .54604 m .37641 .52893 L .36334 .557 L p F P
0 g
s
.789 .679 .743 r
.37641 .52893 m .41546 .54604 L .42615 .51718 L p F P
0 g
s
.789 .679 .743 r
.42615 .51718 m .39102 .50148 L .37641 .52893 L p F P
0 g
s
.779 .687 .762 r
.39102 .50148 m .42615 .51718 L .43791 .48894 L p F P
0 g
s
.805 .659 .701 r
.35192 .58549 m .39759 .60473 L .40592 .5753 L p F P
0 g
s
.805 .659 .701 r
.40592 .5753 m .36334 .557 L .35192 .58549 L p F P
0 g
s
.599 .508 .723 r
.67766 .52728 m .63904 .54483 L .64889 .57401 L p F P
0 g
s
.609 .532 .743 r
.63904 .54483 m .67766 .52728 L .66275 .49998 L p F P
0 g
s
.609 .532 .743 r
.66275 .49998 m .62801 .51607 L .63904 .54483 L p F P
0 g
s
.618 .556 .763 r
.62801 .51607 m .66275 .49998 L .64638 .47354 L p F P
0 g
s
.618 .556 .763 r
.64638 .47354 m .61589 .48795 L .62801 .51607 L p F P
0 g
s
.748 .67 .774 r
.47992 .46984 m .45064 .46155 L .43791 .48894 L p F P
0 g
s
.739 .681 .794 r
.45064 .46155 m .47992 .46984 L .48818 .44212 L p F P
0 g
s
.721 .661 .789 r
.51364 .44555 m .48818 .44212 L .47992 .46984 L p F P
0 g
s
.589 .483 .701 r
.69101 .55524 m .64889 .57401 L .65748 .60337 L p F P
0 g
s
.599 .508 .723 r
.64889 .57401 m .69101 .55524 L .67766 .52728 L p F P
0 g
s
.658 .615 .794 r
.57369 .46931 m .60276 .46069 L .58871 .43451 L p F P
0 g
s
.658 .615 .794 r
.58871 .43451 m .56496 .44168 L .57369 .46931 L p F P
0 g
s
.782 .578 .624 r
.38063 .69174 m .43765 .70566 L .44021 .67695 L p F P
0 g
s
.782 .578 .624 r
.44021 .67695 m .38488 .66318 L .38063 .69174 L p F P
0 g
s
.658 .473 .623 r
.55849 .71224 m .61828 .70477 L .61559 .67607 L p F P
0 g
s
.61 .438 .624 r
.67058 .66174 m .61559 .67607 L .61828 .70477 L p F P
0 g
s
.618 .463 .65 r
.61559 .67607 m .67058 .66174 L .66473 .63269 L p F P
0 g
s
.779 .687 .762 r
.43791 .48894 m .40706 .47489 L .39102 .50148 L p F P
0 g
s
.769 .696 .782 r
.40706 .47489 m .43791 .48894 L .45064 .46155 L p F P
0 g
s
.812 .647 .678 r
.34225 .61415 m .39056 .6341 L .39759 .60473 L p F P
0 g
s
.812 .647 .678 r
.39759 .60473 m .35192 .58549 L .34225 .61415 L p F P
0 g
s
.741 .522 .596 r
.43599 .73345 m .49708 .74033 L .49761 .71254 L p F P
0 g
s
.741 .522 .596 r
.49761 .71254 m .43765 .70566 L .43599 .73345 L p F P
0 g
s
.698 .486 .597 r
.55849 .71224 m .49761 .71254 L .49708 .74033 L p F P
0 g
s
.626 .58 .783 r
.61589 .48795 m .64638 .47354 L .62869 .4482 L p F P
0 g
s
.626 .58 .783 r
.62869 .4482 m .60276 .46069 L .61589 .48795 L p F P
0 g
s
.698 .486 .597 r
.49708 .74033 m .55911 .74004 L .55849 .71224 L p F P
0 g
s
.652 .449 .596 r
.61828 .70477 m .55849 .71224 L .55911 .74004 L p F P
0 g
s
.578 .457 .678 r
.70267 .58364 m .65748 .60337 L .66473 .63269 L p F P
0 g
s
.589 .483 .701 r
.65748 .60337 m .70267 .58364 L .69101 .55524 L p F P
0 g
s
.714 .675 .81 r
.48818 .44212 m .51364 .44555 L .51642 .41822 L p F P
0 g
s
.698 .66 .809 r
.51364 .44555 m .53959 .4454 L .5363 .4181 L p F P
0 g
s
.698 .66 .809 r
.5363 .4181 m .51642 .41822 L .51364 .44555 L p F P
0 g
s
.68 .647 .81 r
.53959 .4454 m .56496 .44168 L .55572 .41521 L p F P
0 g
s
.68 .647 .81 r
.55572 .41521 m .5363 .4181 L .53959 .4454 L p F P
0 g
s
.769 .696 .782 r
.45064 .46155 m .42438 .44937 L .40706 .47489 L p F P
0 g
s
.757 .703 .801 r
.42438 .44937 m .45064 .46155 L .46425 .43523 L p F P
0 g
s
.739 .681 .794 r
.48818 .44212 m .46425 .43523 L .45064 .46155 L p F P
0 g
s
.819 .634 .653 r
.33445 .64276 m .38488 .66318 L .39056 .6341 L p F P
0 g
s
.819 .634 .653 r
.39056 .6341 m .34225 .61415 L .33445 .64276 L p F P
0 g
s
.635 .604 .802 r
.60276 .46069 m .62869 .4482 L .60982 .42416 L p F P
0 g
s
.635 .604 .802 r
.60982 .42416 m .58871 .43451 L .60276 .46069 L p F P
0 g
s
.729 .691 .814 r
.46425 .43523 m .48818 .44212 L .49693 .41555 L p F P
0 g
s
.714 .675 .81 r
.51642 .41822 m .49693 .41555 L .48818 .44212 L p F P
0 g
s
.566 .429 .653 r
.71253 .61223 m .66473 .63269 L .67058 .66174 L p F P
0 g
s
.578 .457 .678 r
.66473 .63269 m .71253 .61223 L .70267 .58364 L p F P
0 g
s
.662 .637 .814 r
.56496 .44168 m .58871 .43451 L .57385 .40965 L p F P
0 g
s
.662 .637 .814 r
.57385 .40965 m .55572 .41521 L .56496 .44168 L p F P
0 g
s
.784 .56 .596 r
.37787 .71952 m .43599 .73345 L .43765 .70566 L p F P
0 g
s
.784 .56 .596 r
.43765 .70566 m .38063 .69174 L .37787 .71952 L p F P
0 g
s
.652 .449 .596 r
.55911 .74004 m .62003 .73256 L .61828 .70477 L p F P
0 g
s
.6 .41 .596 r
.67495 .69028 m .61828 .70477 L .62003 .73256 L p F P
0 g
s
.61 .438 .624 r
.61828 .70477 m .67495 .69028 L .67058 .66174 L p F P
0 g
s
.815 .715 .754 r
.34312 .50679 m .37641 .52893 L .39102 .50148 L p F P
0 g
s
.815 .715 .754 r
.39102 .50148 m .3612 .48122 L .34312 .50679 L p F P
0 g
s
.802 .72 .774 r
.3612 .48122 m .39102 .50148 L .40706 .47489 L p F P
0 g
s
.74 .5 .566 r
.43525 .76008 m .49685 .76689 L .49708 .74033 L p F P
0 g
s
.74 .5 .566 r
.49708 .74033 m .43599 .73345 L .43525 .76008 L p F P
0 g
s
.693 .461 .567 r
.55911 .74004 m .49708 .74033 L .49685 .76689 L p F P
0 g
s
.828 .708 .733 r
.32691 .53329 m .36334 .557 L .37641 .52893 L p F P
0 g
s
.828 .708 .733 r
.37641 .52893 m .34312 .50679 L .32691 .53329 L p F P
0 g
s
.693 .461 .567 r
.49685 .76689 m .55937 .7666 L .55911 .74004 L p F P
0 g
s
.644 .422 .566 r
.62003 .73256 m .55911 .74004 L .55937 .7666 L p F P
0 g
s
.569 .515 .755 r
.69205 .47936 m .66275 .49998 L .67766 .52728 L p F P
0 g
s
.583 .543 .775 r
.66275 .49998 m .69205 .47936 L .67198 .45514 L p F P
0 g
s
.583 .543 .775 r
.67198 .45514 m .64638 .47354 L .66275 .49998 L p F P
0 g
s
.757 .703 .801 r
.46425 .43523 m .44288 .42513 L .42438 .44937 L p F P
0 g
s
.743 .71 .82 r
.44288 .42513 m .46425 .43523 L .47866 .4102 L p F P
0 g
s
.729 .691 .814 r
.49693 .41555 m .47866 .4102 L .46425 .43523 L p F P
0 g
s
.802 .72 .774 r
.40706 .47489 m .38099 .4568 L .3612 .48122 L p F P
0 g
s
.788 .725 .793 r
.38099 .4568 m .40706 .47489 L .42438 .44937 L p F P
0 g
s
.824 .619 .625 r
.32861 .67106 m .38063 .69174 L .38488 .66318 L p F P
0 g
s
.824 .619 .625 r
.38488 .66318 m .33445 .64276 L .32861 .67106 L p F P
0 g
s
.554 .486 .734 r
.71039 .50475 m .67766 .52728 L .69101 .55524 L p F P
0 g
s
.569 .515 .755 r
.67766 .52728 m .71039 .50475 L .69205 .47936 L p F P
0 g
s
.643 .629 .821 r
.58871 .43451 m .60982 .42416 L .58991 .40164 L p F P
0 g
s
.643 .629 .821 r
.58991 .40164 m .57385 .40965 L .58871 .43451 L p F P
0 g
s
.597 .57 .794 r
.64638 .47354 m .67198 .45514 L .65036 .43229 L p F P
0 g
s
.597 .57 .794 r
.65036 .43229 m .62869 .4482 L .64638 .47354 L p F P
0 g
s
.553 .399 .625 r
.72049 .64079 m .67058 .66174 L .67495 .69028 L p F P
0 g
s
.566 .429 .653 r
.67058 .66174 m .72049 .64079 L .71253 .61223 L p F P
0 g
s
.839 .7 .71 r
.31271 .5605 m .35192 .58549 L .36334 .557 L p F P
0 g
s
.839 .7 .71 r
.36334 .557 m .32691 .53329 L .31271 .5605 L p F P
0 g
s
.706 .689 .831 r
.49693 .41555 m .51642 .41822 L .51934 .39222 L p F P
0 g
s
.693 .678 .83 r
.51642 .41822 m .5363 .4181 L .53284 .39214 L p F P
0 g
s
.693 .678 .83 r
.53284 .39214 m .51934 .39222 L .51642 .41822 L p F P
0 g
s
.68 .668 .832 r
.5363 .4181 m .55572 .41521 L .54601 .39015 L p F P
0 g
s
.68 .668 .832 r
.54601 .39015 m .53284 .39214 L .5363 .4181 L p F P
0 g
s
.539 .457 .711 r
.72684 .53111 m .69101 .55524 L .70267 .58364 L p F P
0 g
s
.554 .486 .734 r
.69101 .55524 m .72684 .53111 L .71039 .50475 L p F P
0 g
s
.788 .725 .793 r
.42438 .44937 m .40231 .43372 L .38099 .4568 L p F P
0 g
s
.772 .728 .811 r
.40231 .43372 m .42438 .44937 L .44288 .42513 L p F P
0 g
s
.61 .597 .813 r
.62869 .4482 m .65036 .43229 L .62736 .41101 L p F P
0 g
s
.61 .597 .813 r
.62736 .41101 m .60982 .42416 L .62869 .4482 L p F P
0 g
s
.717 .702 .835 r
.47866 .4102 m .49693 .41555 L .50612 .39038 L p F P
0 g
s
.706 .689 .831 r
.51934 .39222 m .50612 .39038 L .49693 .41555 L p F P
0 g
s
.666 .661 .835 r
.55572 .41521 m .57385 .40965 L .55829 .38633 L p F P
0 g
s
.666 .661 .835 r
.55829 .38633 m .54601 .39015 L .55572 .41521 L p F P
0 g
s
.85 .691 .685 r
.30068 .58821 m .34225 .61415 L .35192 .58549 L p F P
0 g
s
.85 .691 .685 r
.35192 .58549 m .31271 .5605 L .30068 .58821 L p F P
0 g
s
.785 .539 .564 r
.37665 .74627 m .43525 .76008 L .43599 .73345 L p F P
0 g
s
.785 .539 .564 r
.43599 .73345 m .37787 .71952 L .37665 .74627 L p F P
0 g
s
.644 .422 .566 r
.55937 .7666 m .62079 .7592 L .62003 .73256 L p F P
0 g
s
.588 .378 .564 r
.67779 .71806 m .62003 .73256 L .62079 .7592 L p F P
0 g
s
.6 .41 .596 r
.62003 .73256 m .67779 .71806 L .67495 .69028 L p F P
0 g
s
.522 .425 .686 r
.74124 .55821 m .70267 .58364 L .71253 .61223 L p F P
0 g
s
.539 .457 .711 r
.70267 .58364 m .74124 .55821 L .72684 .53111 L p F P
0 g
s
.772 .728 .811 r
.44288 .42513 m .425 .41219 L .40231 .43372 L p F P
0 g
s
.755 .73 .83 r
.425 .41219 m .44288 .42513 L .46239 .40238 L p F P
0 g
s
.743 .71 .82 r
.47866 .4102 m .46239 .40238 L .44288 .42513 L p F P
0 g
s
.727 .716 .84 r
.46239 .40238 m .47866 .4102 L .49375 .38671 L p F P
0 g
s
.717 .702 .835 r
.50612 .39038 m .49375 .38671 L .47866 .4102 L p F P
0 g
s
.829 .602 .594 r
.3248 .69882 m .37787 .71952 L .38063 .69174 L p F P
0 g
s
.829 .602 .594 r
.38063 .69174 m .32861 .67106 L .3248 .69882 L p F P
0 g
s
.624 .624 .83 r
.60982 .42416 m .62736 .41101 L .60318 .39149 L p F P
0 g
s
.624 .624 .83 r
.60318 .39149 m .58991 .40164 L .60982 .42416 L p F P
0 g
s
.652 .655 .84 r
.57385 .40965 m .58991 .40164 L .56911 .38083 L p F P
0 g
s
.652 .655 .84 r
.56911 .38083 m .55829 .38633 L .57385 .40965 L p F P
0 g
s
.538 .365 .594 r
.72646 .66907 m .67495 .69028 L .67779 .71806 L p F P
0 g
s
.553 .399 .625 r
.67495 .69028 m .72646 .66907 L .72049 .64079 L p F P
0 g
s
.736 .474 .532 r
.43547 .78528 m .49691 .79197 L .49685 .76689 L p F P
0 g
s
.736 .474 .532 r
.49685 .76689 m .43525 .76008 L .43547 .78528 L p F P
0 g
s
.688 .434 .533 r
.55937 .7666 m .49685 .76689 L .49691 .79197 L p F P
0 g
s
.688 .434 .533 r
.49691 .79197 m .55928 .79168 L .55937 .7666 L p F P
0 g
s
.635 .391 .531 r
.62079 .7592 m .55937 .7666 L .55928 .79168 L p F P
0 g
s
.86 .68 .658 r
.29095 .61616 m .33445 .64276 L .34225 .61415 L p F P
0 g
s
.86 .68 .658 r
.34225 .61415 m .30068 .58821 L .29095 .61616 L p F P
0 g
s
.503 .39 .658 r
.75344 .58582 m .71253 .61223 L .72049 .64079 L p F P
0 g
s
.522 .425 .686 r
.71253 .61223 m .75344 .58582 L .74124 .55821 L p F P
0 g
s
.695 .704 .854 r
.50612 .39038 m .51934 .39222 L .52239 .3678 L p F P
0 g
s
.687 .697 .854 r
.51934 .39222 m .53284 .39214 L .52924 .36776 L p F P
0 g
s
.687 .697 .854 r
.52924 .36776 m .52239 .3678 L .51934 .39222 L p F P
0 g
s
.678 .69 .854 r
.53284 .39214 m .54601 .39015 L .53592 .36673 L p F P
0 g
s
.678 .69 .854 r
.53592 .36673 m .52924 .36776 L .53284 .39214 L p F P
0 g
s
.755 .73 .83 r
.46239 .40238 m .44886 .39239 L .425 .41219 L p F P
0 g
s
.735 .731 .847 r
.44886 .39239 m .46239 .40238 L .48278 .38134 L p F P
0 g
s
.727 .716 .84 r
.49375 .38671 m .48278 .38134 L .46239 .40238 L p F P
0 g
s
.824 .757 .79 r
.3381 .45706 m .3612 .48122 L .38099 .4568 L p F P
0 g
s
.824 .757 .79 r
.38099 .4568 m .36094 .43529 L .3381 .45706 L p F P
0 g
s
.805 .757 .808 r
.36094 .43529 m .38099 .4568 L .40231 .43372 L p F P
0 g
s
.637 .652 .848 r
.58991 .40164 m .60318 .39149 L .578 .3739 L p F P
0 g
s
.637 .652 .848 r
.578 .3739 m .56911 .38083 L .58991 .40164 L p F P
0 g
s
.841 .756 .769 r
.31717 .48032 m .34312 .50679 L .3612 .48122 L p F P
0 g
s
.841 .756 .769 r
.3612 .48122 m .3381 .45706 L .31717 .48032 L p F P
0 g
s
.805 .757 .808 r
.40231 .43372 m .38547 .41519 L .36094 .43529 L p F P
0 g
s
.786 .755 .825 r
.38547 .41519 m .40231 .43372 L .425 .41219 L p F P
0 g
s
.702 .712 .856 r
.49375 .38671 m .50612 .39038 L .51567 .36686 L p F P
0 g
s
.695 .704 .854 r
.52239 .3678 m .51567 .36686 L .50612 .39038 L p F P
0 g
s
.669 .686 .857 r
.54601 .39015 m .55829 .38633 L .54213 .36477 L p F P
0 g
s
.669 .686 .857 r
.54213 .36477 m .53592 .36673 L .54601 .39015 L p F P
0 g
s
.544 .531 .791 r
.69147 .43339 m .67198 .45514 L .69205 .47936 L p F P
0 g
s
.565 .562 .81 r
.67198 .45514 m .69147 .43339 L .66672 .41355 L p F P
0 g
s
.565 .562 .81 r
.66672 .41355 m .65036 .43229 L .67198 .45514 L p F P
0 g
s
.584 .592 .827 r
.65036 .43229 m .66672 .41355 L .64049 .39557 L p F P
0 g
s
.584 .592 .827 r
.64049 .39557 m .62736 .41101 L .65036 .43229 L p F P
0 g
s
.523 .499 .771 r
.71452 .45492 m .69205 .47936 L .71039 .50475 L p F P
0 g
s
.544 .531 .791 r
.69205 .47936 m .71452 .45492 L .69147 .43339 L p F P
0 g
s
.784 .514 .527 r
.37701 .77175 m .43547 .78528 L .43525 .76008 L p F P
0 g
s
.784 .514 .527 r
.43525 .76008 m .37665 .74627 L .37701 .77175 L p F P
0 g
s
.858 .754 .747 r
.29834 .50487 m .32691 .53329 L .34312 .50679 L p F P
0 g
s
.858 .754 .747 r
.34312 .50679 m .31717 .48032 L .29834 .50487 L p F P
0 g
s
.786 .755 .825 r
.425 .41219 m .41147 .39692 L .38547 .41519 L p F P
0 g
s
.764 .752 .842 r
.41147 .39692 m .425 .41219 L .44886 .39239 L p F P
0 g
s
.635 .391 .531 r
.55928 .79168 m .62055 .78442 L .62079 .7592 L p F P
0 g
s
.575 .342 .526 r
.67904 .74483 m .62079 .7592 L .62055 .78442 L p F P
0 g
s
.588 .378 .564 r
.62079 .7592 m .67904 .74483 L .67779 .71806 L p F P
0 g
s
.869 .666 .626 r
.28366 .64412 m .32861 .67106 L .33445 .64276 L p F P
0 g
s
.869 .666 .626 r
.33445 .64276 m .29095 .61616 L .28366 .64412 L p F P
0 g
s
.708 .722 .86 r
.48278 .38134 m .49375 .38671 L .50941 .36497 L p F P
0 g
s
.702 .712 .856 r
.51567 .36686 m .50941 .36497 L .49375 .38671 L p F P
0 g
s
.832 .581 .559 r
.32312 .72577 m .37665 .74627 L .37787 .71952 L p F P
0 g
s
.832 .581 .559 r
.37787 .71952 m .3248 .69882 L .32312 .72577 L p F P
0 g
s
.66 .683 .86 r
.55829 .38633 m .56911 .38083 L .54759 .36196 L p F P
0 g
s
.66 .683 .86 r
.54759 .36196 m .54213 .36477 L .55829 .38633 L p F P
0 g
s
.604 .622 .843 r
.62736 .41101 m .64049 .39557 L .61301 .37961 L p F P
0 g
s
.604 .622 .843 r
.61301 .37961 m .60318 .39149 L .62736 .41101 L p F P
0 g
s
.501 .465 .749 r
.73565 .47797 m .71039 .50475 L .72684 .53111 L p F P
0 g
s
.523 .499 .771 r
.71039 .50475 m .73565 .47797 L .71452 .45492 L p F P
0 g
s
.521 .327 .558 r
.73033 .69683 m .67779 .71806 L .67904 .74483 L p F P
0 g
s
.538 .365 .594 r
.67779 .71806 m .73033 .69683 L .72646 .66907 L p F P
0 g
s
.483 .352 .626 r
.7633 .61371 m .72049 .64079 L .72646 .66907 L p F P
0 g
s
.503 .39 .658 r
.72049 .64079 m .7633 .61371 L .75344 .58582 L p F P
0 g
s
.874 .75 .723 r
.28181 .5305 m .31271 .5605 L .32691 .53329 L p F P
0 g
s
.874 .75 .723 r
.32691 .53329 m .29834 .50487 L .28181 .5305 L p F P
0 g
s
.764 .752 .842 r
.44886 .39239 m .43871 .38065 L .41147 .39692 L p F P
0 g
s
.742 .748 .857 r
.43871 .38065 m .44886 .39239 L .47371 .37452 L p F P
0 g
s
.735 .731 .847 r
.48278 .38134 m .47371 .37452 L .44886 .39239 L p F P
0 g
s
.713 .731 .865 r
.47371 .37452 m .48278 .38134 L .50388 .36222 L p F P
0 g
s
.708 .722 .86 r
.50941 .36497 m .50388 .36222 L .48278 .38134 L p F P
0 g
s
.623 .652 .858 r
.60318 .39149 m .61301 .37961 L .58453 .36581 L p F P
0 g
s
.623 .652 .858 r
.58453 .36581 m .578 .3739 L .60318 .39149 L p F P
0 g
s
.651 .681 .866 r
.56911 .38083 m .578 .3739 L .55204 .35842 L p F P
0 g
s
.651 .681 .866 r
.55204 .35842 m .54759 .36196 L .56911 .38083 L p F P
0 g
s
.477 .428 .724 r
.75466 .50234 m .72684 .53111 L .74124 .55821 L p F P
0 g
s
.501 .465 .749 r
.72684 .53111 m .75466 .50234 L .73565 .47797 L p F P
0 g
s
.731 .443 .491 r
.43667 .80881 m .49728 .81531 L .49691 .79197 L p F P
0 g
s
.731 .443 .491 r
.49691 .79197 m .43547 .78528 L .43667 .80881 L p F P
0 g
s
.679 .401 .493 r
.55928 .79168 m .49691 .79197 L .49728 .81531 L p F P
0 g
s
.679 .401 .493 r
.49728 .81531 m .55883 .81503 L .55928 .79168 L p F P
0 g
s
.623 .355 .49 r
.62055 .78442 m .55928 .79168 L .55883 .81503 L p F P
0 g
s
.889 .744 .695 r
.26778 .55699 m .30068 .58821 L .31271 .5605 L p F P
0 g
s
.889 .744 .695 r
.31271 .5605 m .28181 .5305 L .26778 .55699 L p F P
0 g
s
.877 .65 .591 r
.2789 .67183 m .3248 .69882 L .32861 .67106 L p F P
0 g
s
.877 .65 .591 r
.32861 .67106 m .28366 .64412 L .2789 .67183 L p F P
0 g
s
.742 .748 .857 r
.47371 .37452 m .46697 .36652 L .43871 .38065 L p F P
0 g
s
.716 .741 .871 r
.46697 .36652 m .47371 .37452 L .49933 .35873 L p F P
0 g
s
.713 .731 .865 r
.50388 .36222 m .49933 .35873 L .47371 .37452 L p F P
0 g
s
.681 .72 .879 r
.52552 .34522 m .51567 .36686 L .52239 .3678 L closepath p F P
0 g
s
.678 .717 .878 r
.52552 .34522 m .52239 .3678 L .52924 .36776 L closepath p F P
0 g
s
.675 .715 .879 r
.52552 .34522 m .52924 .36776 L .53592 .36673 L closepath p F P
0 g
s
.642 .682 .872 r
.578 .3739 m .58453 .36581 L .55528 .35431 L p F P
0 g
s
.642 .682 .872 r
.55528 .35431 m .55204 .35842 L .578 .3739 L p F P
0 g
s
.45 .388 .696 r
.77134 .52783 m .74124 .55821 L .75344 .58582 L p F P
0 g
s
.477 .428 .724 r
.74124 .55821 m .77134 .52783 L .75466 .50234 L p F P
0 g
s
.684 .723 .879 r
.52552 .34522 m .50941 .36497 L .51567 .36686 L closepath p F P
0 g
s
.672 .713 .879 r
.52552 .34522 m .53592 .36673 L .54213 .36477 L closepath p F P
0 g
s
.459 .31 .59 r
.7707 .64164 m .72646 .66907 L .73033 .69683 L p F P
0 g
s
.483 .352 .626 r
.72646 .66907 m .7707 .64164 L .7633 .61371 L p F P
0 g
s
.795 .785 .843 r
.37475 .39449 m .38547 .41519 L .41147 .39692 L p F P
0 g
s
.795 .785 .843 r
.41147 .39692 m .40299 .37993 L .37475 .39449 L p F P
0 g
s
.771 .775 .856 r
.40299 .37993 m .41147 .39692 L .43871 .38065 L p F P
0 g
s
.819 .793 .828 r
.34799 .41119 m .36094 .43529 L .38547 .41519 L p F P
0 g
s
.819 .793 .828 r
.38547 .41519 m .37475 .39449 L .34799 .41119 L p F P
0 g
s
.686 .726 .881 r
.52552 .34522 m .50388 .36222 L .50941 .36497 L closepath p F P
0 g
s
.668 .712 .881 r
.52552 .34522 m .54213 .36477 L .54759 .36196 L closepath p F P
0 g
s
.834 .556 .517 r
.32363 .75164 m .37701 .77175 L .37665 .74627 L p F P
0 g
s
.834 .556 .517 r
.37665 .74627 m .32312 .72577 L .32363 .75164 L p F P
0 g
s
.782 .483 .483 r
.37901 .79568 m .43667 .80881 L .43547 .78528 L p F P
0 g
s
.782 .483 .483 r
.43547 .78528 m .37701 .77175 L .37901 .79568 L p F P
0 g
s
.557 .592 .845 r
.6485 .37848 m .64049 .39557 L .66672 .41355 L p F P
0 g
s
.583 .624 .858 r
.64049 .39557 m .6485 .37848 L .61891 .36652 L p F P
0 g
s
.583 .624 .858 r
.61891 .36652 m .61301 .37961 L .64049 .39557 L p F P
0 g
s
.771 .775 .856 r
.43871 .38065 m .43247 .36763 L .40299 .37993 L p F P
0 g
s
.745 .764 .868 r
.43247 .36763 m .43871 .38065 L .46697 .36652 L p F P
0 g
s
.529 .558 .829 r
.67688 .39272 m .66672 .41355 L .69147 .43339 L p F P
0 g
s
.557 .592 .845 r
.66672 .41355 m .67688 .39272 L .6485 .37848 L p F P
0 g
s
.623 .355 .49 r
.55883 .81503 m .61927 .80798 L .62055 .78442 L p F P
0 g
s
.557 .3 .482 r
.67865 .77033 m .62055 .78442 L .61927 .80798 L p F P
0 g
s
.575 .342 .526 r
.62055 .78442 m .67865 .77033 L .67904 .74483 L p F P
0 g
s
.842 .799 .81 r
.32298 .4299 m .3381 .45706 L .36094 .43529 L p F P
0 g
s
.842 .799 .81 r
.36094 .43529 m .34799 .41119 L .32298 .4299 L p F P
0 g
s
.5 .283 .516 r
.73204 .72379 m .67904 .74483 L .67865 .77033 L p F P
0 g
s
.521 .327 .558 r
.67904 .74483 m .73204 .72379 L .73033 .69683 L p F P
0 g
s
.609 .654 .869 r
.61301 .37961 m .61891 .36652 L .58836 .35694 L p F P
0 g
s
.609 .654 .869 r
.58836 .35694 m .58453 .36581 L .61301 .37961 L p F P
0 g
s
.687 .73 .883 r
.52552 .34522 m .49933 .35873 L .50388 .36222 L closepath p F P
0 g
s
.665 .712 .883 r
.52552 .34522 m .54759 .36196 L .55204 .35842 L closepath p F P
0 g
s
.5 .523 .812 r
.70377 .40912 m .69147 .43339 L .71452 .45492 L p F P
0 g
s
.529 .558 .829 r
.69147 .43339 m .70377 .40912 L .67688 .39272 L p F P
0 g
s
.903 .735 .663 r
.25641 .58412 m .29095 .61616 L .30068 .58821 L p F P
0 g
s
.903 .735 .663 r
.30068 .58821 m .26778 .55699 L .25641 .58412 L p F P
0 g
s
.745 .764 .868 r
.46697 .36652 m .4629 .35769 L .43247 .36763 L p F P
0 g
s
.717 .751 .879 r
.4629 .35769 m .46697 .36652 L .49599 .35466 L p F P
0 g
s
.716 .741 .871 r
.49933 .35873 m .49599 .35466 L .46697 .36652 L p F P
0 g
s
.635 .684 .879 r
.58453 .36581 m .58836 .35694 L .55714 .34982 L p F P
0 g
s
.635 .684 .879 r
.55714 .34982 m .55528 .35431 L .58453 .36581 L p F P
0 g
s
.864 .804 .79 r
.29998 .45046 m .31717 .48032 L .3381 .45706 L p F P
0 g
s
.864 .804 .79 r
.3381 .45706 m .32298 .4299 L .29998 .45046 L p F P
0 g
s
.688 .733 .885 r
.52552 .34522 m .49599 .35466 L .49933 .35873 L closepath p F P
0 g
s
.662 .712 .885 r
.52552 .34522 m .55204 .35842 L .55528 .35431 L closepath p F P
0 g
s
.421 .343 .663 r
.78551 .55421 m .75344 .58582 L .7633 .61371 L p F P
0 g
s
.45 .388 .696 r
.75344 .58582 m .78551 .55421 L .77134 .52783 L p F P
0 g
s
.468 .484 .792 r
.7289 .42756 m .71452 .45492 L .73565 .47797 L p F P
0 g
s
.5 .523 .812 r
.71452 .45492 m .7289 .42756 L .70377 .40912 L p F P
0 g
s
.883 .629 .549 r
.2768 .69902 m .32312 .72577 L .3248 .69882 L p F P
0 g
s
.883 .629 .549 r
.3248 .69882 m .2789 .67183 L .2768 .69902 L p F P
0 g
s
.717 .751 .879 r
.49599 .35466 m .49401 .3502 L .4629 .35769 L p F P
0 g
s
.688 .736 .888 r
.52552 .34522 m .49401 .3502 L .49599 .35466 L closepath p F P
0 g
s
.66 .713 .888 r
.52552 .34522 m .55528 .35431 L .55714 .34982 L closepath p F P
0 g
s
.886 .808 .767 r
.27923 .47271 m .29834 .50487 L .31717 .48032 L p F P
0 g
s
.886 .808 .767 r
.31717 .48032 m .29998 .45046 L .27923 .47271 L p F P
0 g
s
.723 .405 .441 r
.43887 .8304 m .49797 .83664 L .49728 .81531 L p F P
0 g
s
.723 .405 .441 r
.49728 .81531 m .43667 .80881 L .43887 .8304 L p F P
0 g
s
.668 .361 .445 r
.55883 .81503 m .49728 .81531 L .49797 .83664 L p F P
0 g
s
.668 .361 .445 r
.49797 .83664 m .55799 .83637 L .55883 .81503 L p F P
0 g
s
.607 .311 .44 r
.61927 .80798 m .55883 .81503 L .55799 .83637 L p F P
0 g
s
.432 .261 .547 r
.77552 .66935 m .73033 .69683 L .73204 .72379 L p F P
0 g
s
.459 .31 .59 r
.73033 .69683 m .77552 .66935 L .7707 .64164 L p F P
0 g
s
.745 .78 .881 r
.43049 .35393 m .43247 .36763 L .4629 .35769 L p F P
0 g
s
.745 .78 .881 r
.4629 .35769 m .46172 .34844 L .43049 .35393 L p F P
0 g
s
.716 .76 .887 r
.46172 .34844 m .4629 .35769 L .49401 .3502 L p F P
0 g
s
.434 .442 .768 r
.75203 .44788 m .73565 .47797 L .75466 .50234 L p F P
0 g
s
.468 .484 .792 r
.73565 .47797 m .75203 .44788 L .7289 .42756 L p F P
0 g
s
.772 .798 .874 r
.4001 .36197 m .40299 .37993 L .43247 .36763 L p F P
0 g
s
.772 .798 .874 r
.43247 .36763 m .43049 .35393 L .4001 .36197 L p F P
0 g
s
.596 .66 .883 r
.58929 .34767 m .58836 .35694 L .61891 .36652 L p F P
0 g
s
.628 .689 .887 r
.58836 .35694 m .58929 .34767 L .55753 .34515 L p F P
0 g
s
.628 .689 .887 r
.55753 .34515 m .55714 .34982 L .58836 .35694 L p F P
0 g
s
.716 .76 .887 r
.49401 .3502 m .49349 .34553 L .46172 .34844 L p F P
0 g
s
.687 .739 .89 r
.52552 .34522 m .49349 .34553 L .49401 .3502 L closepath p F P
0 g
s
.658 .715 .891 r
.52552 .34522 m .55714 .34982 L .55753 .34515 L closepath p F P
0 g
s
.917 .723 .626 r
.24787 .61163 m .28366 .64412 L .29095 .61616 L p F P
0 g
s
.917 .723 .626 r
.29095 .61616 m .25641 .58412 L .24787 .61163 L p F P
0 g
s
.563 .63 .875 r
.62051 .35279 m .61891 .36652 L .6485 .37848 L p F P
0 g
s
.596 .66 .883 r
.61891 .36652 m .62051 .35279 L .58929 .34767 L p F P
0 g
s
.8 .815 .864 r
.37085 .37251 m .37475 .39449 L .40299 .37993 L p F P
0 g
s
.8 .815 .864 r
.40299 .37993 m .4001 .36197 L .37085 .37251 L p F P
0 g
s
.681 .744 .899 r
.52552 .34522 m .50073 .33256 L .49692 .3365 L closepath p F P
0 g
s
.684 .743 .896 r
.52552 .34522 m .49692 .3365 L .49447 .3409 L closepath p F P
0 g
s
.686 .741 .893 r
.52552 .34522 m .49447 .3409 L .49349 .34553 L closepath p F P
0 g
s
.656 .717 .893 r
.52552 .34522 m .55753 .34515 L .55642 .34052 L closepath p F P
0 g
s
.656 .72 .896 r
.52552 .34522 m .55642 .34052 L .55385 .33615 L closepath p F P
0 g
s
.656 .724 .899 r
.52552 .34522 m .55385 .33615 L .54994 .33226 L closepath p F P
0 g
s
.657 .727 .901 r
.52552 .34522 m .54994 .33226 L .54486 .32902 L closepath p F P
0 g
s
.658 .731 .903 r
.52552 .34522 m .54486 .32902 L .53885 .32659 L closepath p F P
0 g
s
.661 .734 .904 r
.52552 .34522 m .53885 .32659 L .5322 .32511 L closepath p F P
0 g
s
.664 .738 .905 r
.52552 .34522 m .5322 .32511 L .52522 .32463 L closepath p F P
0 g
s
.667 .74 .905 r
.52552 .34522 m .52522 .32463 L .51826 .32519 L closepath p F P
0 g
s
.671 .742 .904 r
.52552 .34522 m .51826 .32519 L .51166 .32676 L closepath p F P
0 g
s
.674 .744 .903 r
.52552 .34522 m .51166 .32676 L .50572 .32925 L closepath p F P
0 g
s
.678 .744 .901 r
.52552 .34522 m .50572 .32925 L .50073 .33256 L closepath p F P
0 g
s
.834 .524 .466 r
.32638 .77616 m .37901 .79568 L .37701 .77175 L p F P
0 g
s
.834 .524 .466 r
.37701 .77175 m .32363 .75164 L .32638 .77616 L p F P
0 g
s
.388 .293 .626 r
.79699 .58126 m .7633 .61371 L .7707 .64164 L p F P
0 g
s
.421 .343 .663 r
.7633 .61371 m .79699 .58126 L .78551 .55421 L p F P
0 g
s
.528 .596 .866 r
.65091 .36046 m .6485 .37848 L .67688 .39272 L p F P
0 g
s
.563 .63 .875 r
.6485 .37848 m .65091 .36046 L .62051 .35279 L p F P
0 g
s
.907 .809 .739 r
.26096 .49646 m .28181 .5305 L .29834 .50487 L p F P
0 g
s
.907 .809 .739 r
.29834 .50487 m .27923 .47271 L .26096 .49646 L p F P
0 g
s
.713 .768 .895 r
.46352 .33919 m .46172 .34844 L .49349 .34553 L p F P
0 g
s
.713 .768 .895 r
.49349 .34553 m .49447 .3409 L .46352 .33919 L p F P
0 g
s
.557 .3 .482 r
.61927 .80798 m .67657 .7943 L .67865 .77033 L p F P
0 g
s
.474 .23 .464 r
.7315 .7497 m .67865 .77033 L .67657 .7943 L p F P
0 g
s
.5 .283 .516 r
.67865 .77033 m .7315 .7497 L .73204 .72379 L p F P
0 g
s
.623 .695 .896 r
.55642 .34052 m .55753 .34515 L .58929 .34767 L p F P
0 g
s
.775 .445 .429 r
.38267 .81778 m .43887 .8304 L .43667 .80881 L p F P
0 g
s
.775 .445 .429 r
.43667 .80881 m .37901 .79568 L .38267 .81778 L p F P
0 g
s
.827 .831 .851 r
.34301 .38548 m .34799 .41119 L .37475 .39449 L p F P
0 g
s
.827 .831 .851 r
.37475 .39449 m .37085 .37251 L .34301 .38548 L p F P
0 g
s
.607 .311 .44 r
.55799 .83637 m .61693 .8296 L .61927 .80798 L p F P
0 g
s
.535 .249 .427 r
.67657 .7943 m .61927 .80798 L .61693 .8296 L p F P
0 g
s
.396 .395 .741 r
.77289 .46993 m .75466 .50234 L .77134 .52783 L p F P
0 g
s
.434 .442 .768 r
.75466 .50234 m .77289 .46993 L .75203 .44788 L p F P
0 g
s
.49 .559 .854 r
.68018 .37066 m .67688 .39272 L .70377 .40912 L p F P
0 g
s
.528 .596 .866 r
.67688 .39272 m .68018 .37066 L .65091 .36046 L p F P
0 g
s
.74 .794 .896 r
.43296 .34016 m .43049 .35393 L .46172 .34844 L p F P
0 g
s
.74 .794 .896 r
.46172 .34844 m .46352 .33919 L .43296 .34016 L p F P
0 g
s
.586 .669 .897 r
.58722 .33844 m .58929 .34767 L .62051 .35279 L p F P
0 g
s
.623 .695 .896 r
.58929 .34767 m .58722 .33844 L .55642 .34052 L p F P
0 g
s
.707 .774 .904 r
.46828 .33039 m .46352 .33919 L .49447 .3409 L p F P
0 g
s
.707 .774 .904 r
.49447 .3409 m .49692 .3365 L .46828 .33039 L p F P
0 g
s
.619 .703 .905 r
.55385 .33615 m .55642 .34052 L .58722 .33844 L p F P
0 g
s
.888 .602 .498 r
.27744 .72542 m .32363 .75164 L .32312 .72577 L p F P
0 g
s
.888 .602 .498 r
.32312 .72577 m .2768 .69902 L .27744 .72542 L p F P
0 g
s
.854 .846 .835 r
.3169 .40081 m .32298 .4299 L .34799 .41119 L p F P
0 g
s
.854 .846 .835 r
.34799 .41119 m .34301 .38548 L .3169 .40081 L p F P
0 g
s
.768 .82 .893 r
.40308 .34383 m .4001 .36197 L .43049 .35393 L p F P
0 g
s
.768 .82 .893 r
.43049 .35393 m .43296 .34016 L .40308 .34383 L p F P
0 g
s
.929 .707 .582 r
.24231 .63926 m .2789 .67183 L .28366 .64412 L p F P
0 g
s
.929 .707 .582 r
.28366 .64412 m .24787 .61163 L .24231 .63926 L p F P
0 g
s
.398 .203 .496 r
.77764 .69656 m .73204 .72379 L .7315 .7497 L p F P
0 g
s
.432 .261 .547 r
.73204 .72379 m .77764 .69656 L .77552 .66935 L p F P
0 g
s
.699 .778 .913 r
.47579 .32245 m .46828 .33039 L .49692 .3365 L p F P
0 g
s
.699 .778 .913 r
.49692 .3365 m .50073 .33256 L .47579 .32245 L p F P
0 g
s
.928 .807 .706 r
.24541 .52151 m .26778 .55699 L .28181 .5305 L p F P
0 g
s
.928 .807 .706 r
.28181 .5305 m .26096 .49646 L .24541 .52151 L p F P
0 g
s
.618 .713 .913 r
.54994 .33226 m .55385 .33615 L .58222 .32969 L p F P
0 g
s
.619 .703 .905 r
.58722 .33844 m .58222 .32969 L .55385 .33615 L p F P
0 g
s
.447 .518 .838 r
.70803 .38332 m .70377 .40912 L .7289 .42756 L p F P
0 g
s
.49 .559 .854 r
.70377 .40912 m .70803 .38332 L .68018 .37066 L p F P
0 g
s
.545 .64 .895 r
.61766 .33904 m .62051 .35279 L .65091 .36046 L p F P
0 g
s
.586 .669 .897 r
.62051 .35279 m .61766 .33904 L .58722 .33844 L p F P
0 g
s
.349 .235 .58 r
.80561 .60873 m .7707 .64164 L .77552 .66935 L p F P
0 g
s
.388 .293 .626 r
.7707 .64164 m .80561 .60873 L .79699 .58126 L p F P
0 g
s
.353 .342 .707 r
.79126 .49351 m .77134 .52783 L .78551 .55421 L p F P
0 g
s
.396 .395 .741 r
.77134 .52783 m .79126 .49351 L .77289 .46993 L p F P
0 g
s
.732 .806 .91 r
.43987 .32699 m .43296 .34016 L .46352 .33919 L p F P
0 g
s
.732 .806 .91 r
.46352 .33919 m .46828 .33039 L .43987 .32699 L p F P
0 g
s
.689 .78 .92 r
.48573 .31579 m .47579 .32245 L .50073 .33256 L p F P
0 g
s
.689 .78 .92 r
.50073 .33256 m .50572 .32925 L .48573 .31579 L p F P
0 g
s
.618 .713 .913 r
.58222 .32969 m .57449 .32185 L .54994 .33226 L p F P
0 g
s
.62 .724 .921 r
.54486 .32902 m .54994 .33226 L .57449 .32185 L p F P
0 g
s
.577 .682 .912 r
.58222 .32969 m .58722 .33844 L .61766 .33904 L p F P
0 g
s
.709 .357 .379 r
.44208 .84977 m .49898 .8557 L .49797 .83664 L p F P
0 g
s
.709 .357 .379 r
.49797 .83664 m .43887 .8304 L .44208 .84977 L p F P
0 g
s
.651 .311 .384 r
.55799 .83637 m .49797 .83664 L .49898 .8557 L p F P
0 g
s
.651 .311 .384 r
.49898 .8557 m .55678 .85544 L .55799 .83637 L p F P
0 g
s
.585 .256 .378 r
.61693 .8296 m .55799 .83637 L .55678 .85544 L p F P
0 g
s
.881 .859 .815 r
.29278 .41837 m .29998 .45046 L .32298 .4299 L p F P
0 g
s
.881 .859 .815 r
.32298 .4299 m .3169 .40081 L .29278 .41837 L p F P
0 g
s
.796 .846 .888 r
.37419 .35022 m .37085 .37251 L .4001 .36197 L p F P
0 g
s
.796 .846 .888 r
.4001 .36197 m .40308 .34383 L .37419 .35022 L p F P
0 g
s
.677 .778 .926 r
.49763 .31073 m .48573 .31579 L .50572 .32925 L p F P
0 g
s
.677 .778 .926 r
.50572 .32925 m .51166 .32676 L .49763 .31073 L p F P
0 g
s
.62 .724 .921 r
.57449 .32185 m .56437 .3153 L .54486 .32902 L p F P
0 g
s
.624 .736 .927 r
.53885 .32659 m .54486 .32902 L .56437 .3153 L p F P
0 g
s
.499 .606 .89 r
.64742 .34235 m .65091 .36046 L .68018 .37066 L p F P
0 g
s
.545 .64 .895 r
.65091 .36046 m .64742 .34235 L .61766 .33904 L p F P
0 g
s
.4 .471 .818 r
.73418 .39836 m .7289 .42756 L .75203 .44788 L p F P
0 g
s
.447 .518 .838 r
.7289 .42756 m .73418 .39836 L .70803 .38332 L p F P
0 g
s
.829 .484 .404 r
.33143 .79905 m .38267 .81778 L .37901 .79568 L p F P
0 g
s
.829 .484 .404 r
.37901 .79568 m .32638 .77616 L .33143 .79905 L p F P
0 g
s
.665 .774 .931 r
.51091 .30755 m .49763 .31073 L .51166 .32676 L p F P
0 g
s
.665 .774 .931 r
.51166 .32676 m .51826 .32519 L .51091 .30755 L p F P
0 g
s
.624 .736 .927 r
.56437 .3153 m .55233 .3104 L .53885 .32659 L p F P
0 g
s
.631 .747 .931 r
.5322 .32511 m .53885 .32659 L .55233 .3104 L p F P
0 g
s
.535 .249 .427 r
.61693 .8296 m .67278 .81647 L .67657 .7943 L p F P
0 g
s
.441 .167 .4 r
.72867 .77428 m .67657 .7943 L .67278 .81647 L p F P
0 g
s
.474 .23 .464 r
.67657 .7943 m .72867 .77428 L .7315 .7497 L p F P
0 g
s
.652 .767 .933 r
.52492 .30641 m .51091 .30755 L .51826 .32519 L p F P
0 g
s
.652 .767 .933 r
.51826 .32519 m .52522 .32463 L .52492 .30641 L p F P
0 g
s
.947 .802 .667 r
.23278 .54763 m .25641 .58412 L .26778 .55699 L p F P
0 g
s
.947 .802 .667 r
.26778 .55699 m .24541 .52151 L .23278 .54763 L p F P
0 g
s
.631 .747 .931 r
.55233 .3104 m .53896 .30738 L .5322 .32511 L p F P
0 g
s
.641 .758 .933 r
.52522 .32463 m .5322 .32511 L .53896 .30738 L p F P
0 g
s
.641 .758 .933 r
.53896 .30738 m .52492 .30641 L .52522 .32463 L p F P
0 g
s
.718 .815 .925 r
.45096 .31507 m .43987 .32699 L .46828 .33039 L p F P
0 g
s
.718 .815 .925 r
.46828 .33039 m .47579 .32245 L .45096 .31507 L p F P
0 g
s
.573 .698 .926 r
.57449 .32185 m .58222 .32969 L .61038 .32595 L p F P
0 g
s
.577 .682 .912 r
.61766 .33904 m .61038 .32595 L .58222 .32969 L p F P
0 g
s
.764 .397 .36 r
.38802 .83779 m .44208 .84977 L .43887 .8304 L p F P
0 g
s
.764 .397 .36 r
.43887 .8304 m .38267 .81778 L .38802 .83779 L p F P
0 g
s
.757 .839 .914 r
.41197 .3264 m .40308 .34383 L .43296 .34016 L p F P
0 g
s
.757 .839 .914 r
.43296 .34016 m .43987 .32699 L .41197 .3264 L p F P
0 g
s
.938 .685 .528 r
.23984 .66673 m .2768 .69902 L .2789 .67183 L p F P
0 g
s
.938 .685 .528 r
.2789 .67183 m .24231 .63926 L .23984 .66673 L p F P
0 g
s
.304 .28 .667 r
.80691 .51844 m .78551 .55421 L .79699 .58126 L p F P
0 g
s
.353 .342 .707 r
.78551 .55421 m .80691 .51844 L .79126 .49351 L p F P
0 g
s
.585 .256 .378 r
.55678 .85544 m .61352 .84901 L .61693 .8296 L p F P
0 g
s
.505 .185 .358 r
.67278 .81647 m .61693 .8296 L .61352 .84901 L p F P
0 g
s
.528 .655 .916 r
.61038 .32595 m .61766 .33904 L .64742 .34235 L p F P
0 g
s
.825 .871 .879 r
.34658 .35931 m .34301 .38548 L .37085 .37251 L p F P
0 g
s
.825 .871 .879 r
.37085 .37251 m .37419 .35022 L .34658 .35931 L p F P
0 g
s
.908 .871 .79 r
.27095 .43805 m .27923 .47271 L .29998 .45046 L p F P
0 g
s
.908 .871 .79 r
.29998 .45046 m .29278 .41837 L .27095 .43805 L p F P
0 g
s
.888 .568 .436 r
.28088 .75073 m .32638 .77616 L .32363 .75164 L p F P
0 g
s
.888 .568 .436 r
.32363 .75164 m .27744 .72542 L .28088 .75073 L p F P
0 g
s
.446 .565 .882 r
.67621 .3484 m .68018 .37066 L .70803 .38332 L p F P
0 g
s
.499 .606 .89 r
.68018 .37066 m .67621 .3484 L .64742 .34235 L p F P
0 g
s
.303 .167 .525 r
.81122 .63635 m .77552 .66935 L .77764 .69656 L p F P
0 g
s
.349 .235 .58 r
.77552 .66935 m .81122 .63635 L .80561 .60873 L p F P
0 g
s
.358 .134 .432 r
.77698 .723 m .7315 .7497 L .72867 .77428 L p F P
0 g
s
.398 .203 .496 r
.7315 .7497 m .77698 .723 L .77764 .69656 L p F P
0 g
s
.346 .417 .792 r
.75833 .41567 m .75203 .44788 L .77289 .46993 L p F P
0 g
s
.4 .471 .818 r
.75203 .44788 m .75833 .41567 L .73418 .39836 L p F P
0 g
s
.699 .818 .939 r
.46576 .30502 m .45096 .31507 L .47579 .32245 L p F P
0 g
s
.699 .818 .939 r
.47579 .32245 m .48573 .31579 L .46576 .30502 L p F P
0 g
s
.573 .698 .926 r
.61038 .32595 m .59895 .31416 L .57449 .32185 L p F P
0 g
s
.573 .716 .94 r
.56437 .3153 m .57449 .32185 L .59895 .31416 L p F P
0 g
s
.965 .792 .618 r
.22328 .57458 m .24787 .61163 L .25641 .58412 L p F P
0 g
s
.965 .792 .618 r
.25641 .58412 m .23278 .54763 L .22328 .57458 L p F P
0 g
s
.782 .873 .914 r
.38486 .3287 m .37419 .35022 L .40308 .34383 L p F P
0 g
s
.782 .873 .914 r
.40308 .34383 m .41197 .3264 L .38486 .3287 L p F P
0 g
s
.854 .896 .865 r
.32056 .37107 m .3169 .40081 L .34301 .38548 L p F P
0 g
s
.854 .896 .865 r
.34301 .38548 m .34658 .35931 L .32056 .37107 L p F P
0 g
s
.934 .879 .757 r
.25167 .45967 m .26096 .49646 L .27923 .47271 L p F P
0 g
s
.934 .879 .757 r
.27923 .47271 m .27095 .43805 L .25167 .45967 L p F P
0 g
s
.47 .622 .917 r
.63804 .32502 m .64742 .34235 L .67621 .3484 L p F P
0 g
s
.528 .655 .916 r
.64742 .34235 m .63804 .32502 L .61038 .32595 L p F P
0 g
s
.737 .853 .935 r
.42647 .31056 m .41197 .3264 L .43987 .32699 L p F P
0 g
s
.737 .853 .935 r
.43987 .32699 m .45096 .31507 L .42647 .31056 L p F P
0 g
s
.677 .816 .95 r
.48357 .29738 m .46576 .30502 L .48573 .31579 L p F P
0 g
s
.677 .816 .95 r
.48573 .31579 m .49763 .31073 L .48357 .29738 L p F P
0 g
s
.385 .517 .868 r
.70373 .35717 m .70803 .38332 L .73418 .39836 L p F P
0 g
s
.446 .565 .882 r
.70803 .38332 m .70373 .35717 L .67621 .3484 L p F P
0 g
s
.247 .209 .617 r
.8196 .54447 m .79699 .58126 L .80561 .60873 L p F P
0 g
s
.304 .28 .667 r
.79699 .58126 m .8196 .54447 L .80691 .51844 L p F P
0 g
s
.573 .716 .94 r
.59895 .31416 m .58387 .30429 L .56437 .3153 L p F P
0 g
s
.578 .737 .951 r
.55233 .3104 m .56437 .3153 L .58387 .30429 L p F P
0 g
s
.516 .676 .937 r
.59895 .31416 m .61038 .32595 L .63804 .32502 L p F P
0 g
s
.284 .353 .758 r
.7802 .43512 m .77289 .46993 L .79126 .49351 L p F P
0 g
s
.346 .417 .792 r
.77289 .46993 m .7802 .43512 L .75833 .41567 L p F P
0 g
s
.687 .295 .297 r
.44631 .86666 m .50032 .87222 L .49898 .8557 L p F P
0 g
s
.687 .295 .297 r
.49898 .8557 m .44208 .84977 L .44631 .86666 L p F P
0 g
s
.626 .247 .305 r
.55678 .85544 m .49898 .8557 L .50032 .87222 L p F P
0 g
s
.626 .247 .305 r
.50032 .87222 m .55519 .87198 L .55678 .85544 L p F P
0 g
s
.554 .185 .296 r
.61352 .84901 m .55678 .85544 L .55519 .87198 L p F P
0 g
s
.817 .431 .323 r
.33878 .82003 m .38802 .83779 L .38267 .81778 L p F P
0 g
s
.817 .431 .323 r
.38267 .81778 m .33143 .79905 L .33878 .82003 L p F P
0 g
s
.943 .654 .461 r
.24059 .69376 m .27744 .72542 L .2768 .69902 L p F P
0 g
s
.943 .654 .461 r
.2768 .69902 m .23984 .66673 L .24059 .69376 L p F P
0 g
s
.653 .808 .958 r
.50353 .29256 m .48357 .29738 L .49763 .31073 L p F P
0 g
s
.653 .808 .958 r
.49763 .31073 m .51091 .30755 L .50353 .29256 L p F P
0 g
s
.505 .185 .358 r
.61352 .84901 m .66724 .83654 L .67278 .81647 L p F P
0 g
s
.397 .087 .319 r
.7235 .79725 m .67278 .81647 L .66724 .83654 L p F P
0 g
s
.441 .167 .4 r
.67278 .81647 m .7235 .79725 L .72867 .77428 L p F P
0 g
s
.578 .737 .951 r
.58387 .30429 m .56584 .29687 L .55233 .3104 L p F P
0 g
s
.59 .758 .958 r
.53896 .30738 m .55233 .3104 L .56584 .29687 L p F P
0 g
s
.248 .086 .456 r
.8137 .66385 m .77764 .69656 L .77698 .723 L p F P
0 g
s
.303 .167 .525 r
.77764 .69656 m .8137 .66385 L .81122 .63635 L p F P
0 g
s
.882 .521 .357 r
.28719 .77466 m .33143 .79905 L .32638 .77616 L p F P
0 g
s
.882 .521 .357 r
.32638 .77616 m .28088 .75073 L .28719 .77466 L p F P
0 g
s
.629 .795 .962 r
.52461 .29083 m .50353 .29256 L .51091 .30755 L p F P
0 g
s
.629 .795 .962 r
.51091 .30755 m .52492 .30641 L .52461 .29083 L p F P
0 g
s
.59 .758 .958 r
.56584 .29687 m .54575 .2923 L .53896 .30738 L p F P
0 g
s
.607 .778 .962 r
.52492 .30641 m .53896 .30738 L .54575 .2923 L p F P
0 g
s
.883 .918 .844 r
.29644 .38545 m .29278 .41837 L .3169 .40081 L p F P
0 g
s
.883 .918 .844 r
.3169 .40081 m .32056 .37107 L .29644 .38545 L p F P
0 g
s
.607 .778 .962 r
.54575 .2923 m .52461 .29083 L .52492 .30641 L p F P
0 g
s
.306 .049 .351 r
.77346 .74838 m .72867 .77428 L .7235 .79725 L p F P
0 g
s
.358 .134 .432 r
.72867 .77428 m .77346 .74838 L .77698 .723 L p F P
0 g
s
.743 .332 .271 r
.39505 .85543 m .44631 .86666 L .44208 .84977 L p F P
0 g
s
.743 .332 .271 r
.44208 .84977 m .38802 .83779 L .39505 .85543 L p F P
0 g
s
.808 .908 .909 r
.35886 .33393 m .34658 .35931 L .37419 .35022 L p F P
0 g
s
.808 .908 .909 r
.37419 .35022 m .38486 .3287 L .35886 .33393 L p F P
0 g
s
.959 .883 .715 r
.23522 .48307 m .24541 .52151 L .26096 .49646 L p F P
0 g
s
.959 .883 .715 r
.26096 .49646 m .25167 .45967 L .23522 .48307 L p F P
0 g
s
.979 .774 .558 r
.21708 .60209 m .24231 .63926 L .24787 .61163 L p F P
0 g
s
.979 .774 .558 r
.24787 .61163 m .22328 .57458 L .21708 .60209 L p F P
0 g
s
.554 .185 .296 r
.55519 .87198 m .60903 .86594 L .61352 .84901 L p F P
0 g
s
.463 .102 .267 r
.66724 .83654 m .61352 .84901 L .60903 .86594 L p F P
0 g
s
.708 .86 .954 r
.44599 .29716 m .42647 .31056 L .45096 .31507 L p F P
0 g
s
.708 .86 .954 r
.45096 .31507 m .46576 .30502 L .44599 .29716 L p F P
0 g
s
.313 .458 .846 r
.72967 .36863 m .73418 .39836 L .75833 .41567 L p F P
0 g
s
.385 .517 .868 r
.73418 .39836 m .72967 .36863 L .70373 .35717 L p F P
0 g
s
.516 .676 .937 r
.63804 .32502 m .62309 .30936 L .59895 .31416 L p F P
0 g
s
.511 .701 .956 r
.58387 .30429 m .59895 .31416 L .62309 .30936 L p F P
0 g
s
.399 .578 .912 r
.66492 .32699 m .67621 .3484 L .70373 .35717 L p F P
0 g
s
.47 .622 .917 r
.67621 .3484 m .66492 .32699 L .63804 .32502 L p F P
0 g
s
.211 .278 .715 r
.79951 .45656 m .79126 .49351 L .80691 .51844 L p F P
0 g
s
.284 .353 .758 r
.79126 .49351 m .79951 .45656 L .7802 .43512 L p F P
0 g
s
.179 .124 .554 r
.82915 .57136 m .80561 .60873 L .81122 .63635 L p F P
0 g
s
.247 .209 .617 r
.80561 .60873 m .82915 .57136 L .8196 .54447 L p F P
0 g
s
.754 .894 .941 r
.40259 .30907 m .38486 .3287 L .41197 .3264 L p F P
0 g
s
.754 .894 .941 r
.41197 .3264 m .42647 .31056 L .40259 .30907 L p F P
0 g
s
.445 .644 .943 r
.62309 .30936 m .63804 .32502 L .66492 .32699 L p F P
0 g
s
.941 .61 .376 r
.24463 .72003 m .28088 .75073 L .27744 .72542 L p F P
0 g
s
.941 .61 .376 r
.27744 .72542 m .24059 .69376 L .24463 .72003 L p F P
0 g
s
.671 .857 .97 r
.46963 .28693 m .44599 .29716 L .46576 .30502 L p F P
0 g
s
.671 .857 .97 r
.46576 .30502 m .48357 .29738 L .46963 .28693 L p F P
0 g
s
.911 .938 .813 r
.27453 .40237 m .27095 .43805 L .29278 .41837 L p F P
0 g
s
.911 .938 .813 r
.29278 .41837 m .29644 .38545 L .27453 .40237 L p F P
0 g
s
.511 .701 .956 r
.62309 .30936 m .60318 .29619 L .58387 .30429 L p F P
0 g
s
.514 .731 .972 r
.56584 .29687 m .58387 .30429 L .60318 .29619 L p F P
0 g
s
.98 .88 .66 r
.22183 .50802 m .23278 .54763 L .24541 .52151 L p F P
0 g
s
.98 .88 .66 r
.24541 .52151 m .23522 .48307 L .22183 .50802 L p F P
0 g
s
.179 0 .368 r
.81293 .69093 m .77698 .723 L .77346 .74838 L p F P
0 g
s
.248 .086 .456 r
.77698 .723 m .81293 .69093 L .8137 .66385 L p F P
0 g
s
.833 .941 .896 r
.33425 .34213 m .32056 .37107 L .34658 .35931 L p F P
0 g
s
.833 .941 .896 r
.34658 .35931 m .35886 .33393 L .33425 .34213 L p F P
0 g
s
.226 .386 .814 r
.75372 .38275 m .75833 .41567 L .7802 .43512 L p F P
0 g
s
.313 .458 .846 r
.75833 .41567 m .75372 .38275 L .72967 .36863 L p F P
0 g
s
.792 .358 .217 r
.34846 .83879 m .39505 .85543 L .38802 .83779 L p F P
0 g
s
.792 .358 .217 r
.38802 .83779 m .33878 .82003 L .34846 .83879 L p F P
0 g
s
.987 .746 .48 r
.21434 .62987 m .23984 .66673 L .24231 .63926 L p F P
0 g
s
.987 .746 .48 r
.24231 .63926 m .21708 .60209 L .21434 .62987 L p F P
0 g
s
.311 .521 .898 r
.69072 .33192 m .70373 .35717 L .72967 .36863 L p F P
0 g
s
.399 .578 .912 r
.70373 .35717 m .69072 .33192 L .66492 .32699 L p F P
0 g
s
.125 .187 .657 r
.81599 .47981 m .80691 .51844 L .8196 .54447 L p F P
0 g
s
.211 .278 .715 r
.80691 .51844 m .81599 .47981 L .79951 .45656 L p F P
0 g
s
.651 .209 .188 r
.45156 .88078 m .50197 .88592 L .50032 .87222 L p F P
0 g
s
.651 .209 .188 r
.50032 .87222 m .44631 .86666 L .45156 .88078 L p F P
0 g
s
.587 .16 .199 r
.55519 .87198 m .50032 .87222 L .50197 .88592 L p F P
0 g
s
.587 .16 .199 r
.50197 .88592 m .55321 .8857 L .55519 .87198 L p F P
0 g
s
.507 .091 .186 r
.60903 .86594 m .55519 .87198 L .55321 .8857 L p F P
0 g
s
.463 .102 .267 r
.60903 .86594 m .65996 .85426 L .66724 .83654 L p F P
0 g
s
.337 0 .211 r
.71597 .81832 m .66724 .83654 L .65996 .85426 L p F P
0 g
s
.397 .087 .319 r
.66724 .83654 m .71597 .81832 L .7235 .79725 L p F P
0 g
s
.865 .457 .254 r
.29637 .79691 m .33878 .82003 L .33143 .79905 L p F P
0 g
s
.865 .457 .254 r
.33143 .79905 m .28719 .77466 L .29637 .79691 L p F P
0 g
s
.63 .844 .982 r
.49619 .28047 m .46963 .28693 L .48357 .29738 L p F P
0 g
s
.63 .844 .982 r
.48357 .29738 m .50353 .29256 L .49619 .28047 L p F P
0 g
s
.514 .731 .972 r
.60318 .29619 m .57925 .28625 L .56584 .29687 L p F P
0 g
s
.529 .762 .983 r
.54575 .2923 m .56584 .29687 L .57925 .28625 L p F P
0 g
s
.098 .022 .473 r
.83538 .59885 m .81122 .63635 L .8137 .66385 L p F P
0 g
s
.179 .124 .554 r
.81122 .63635 m .83538 .59885 L .82915 .57136 L p F P
0 g
s
.238 0 .246 r
.76705 .77241 m .7235 .79725 L .71597 .81832 L p F P
0 g
s
.306 .049 .351 r
.7235 .79725 m .76705 .77241 L .77346 .74838 L p F P
0 g
s
.711 .903 .964 r
.42665 .29239 m .40259 .30907 L .42647 .31056 L p F P
0 g
s
.711 .903 .964 r
.42647 .31056 m .44599 .29716 L .42665 .29239 L p F P
0 g
s
.769 .935 .938 r
.37958 .31069 m .35886 .33393 L .38486 .3287 L p F P
0 g
s
.769 .935 .938 r
.38486 .3287 m .40259 .30907 L .37958 .31069 L p F P
0 g
s
.445 .644 .943 r
.66492 .32699 m .64662 .30756 L .62309 .30936 L p F P
0 g
s
.427 .674 .966 r
.60318 .29619 m .62309 .30936 L .64662 .30756 L p F P
0 g
s
.589 .822 .988 r
.52431 .27816 m .49619 .28047 L .50353 .29256 L p F P
0 g
s
.589 .822 .988 r
.50353 .29256 m .52461 .29083 L .52431 .27816 L p F P
0 g
s
.352 .599 .94 r
.64662 .30756 m .66492 .32699 L .69072 .33192 L p F P
0 g
s
.529 .762 .983 r
.57925 .28625 m .55249 .28012 L .54575 .2923 L p F P
0 g
s
.554 .794 .988 r
.52461 .29083 m .54575 .2923 L .55249 .28012 L p F P
0 g
s
.705 .242 .15 r
.40377 .87041 m .45156 .88078 L .44631 .86666 L p F P
0 g
s
.705 .242 .15 r
.44631 .86666 m .39505 .85543 L .40377 .87041 L p F P
0 g
s
.554 .794 .988 r
.55249 .28012 m .52431 .27816 L .52461 .29083 L p F P
0 g
s
.935 .952 .768 r
.25512 .42169 m .25167 .45967 L .27095 .43805 L p F P
0 g
s
.935 .952 .768 r
.27095 .43805 m .27453 .40237 L .25512 .42169 L p F P
0 g
s
.507 .091 .186 r
.55321 .8857 m .60347 .88012 L .60903 .86594 L p F P
0 g
s
.402 0 .145 r
.65996 .85426 m .60903 .86594 L .60347 .88012 L p F P
0 g
s
.995 .866 .586 r
.21174 .5343 m .22328 .57458 L .23278 .54763 L p F P
0 g
s
.995 .866 .586 r
.23278 .54763 m .22183 .50802 L .21174 .5343 L p F P
0 g
s
.122 .295 .767 r
.77558 .39943 m .7802 .43512 L .79951 .45656 L p F P
0 g
s
.226 .386 .814 r
.7802 .43512 m .77558 .39943 L .75372 .38275 L p F P
0 g
s
.854 .971 .869 r
.31136 .3533 m .29644 .38545 L .32056 .37107 L p F P
0 g
s
.854 .971 .869 r
.32056 .37107 m .33425 .34213 L .31136 .3533 L p F P
0 g
s
.926 .548 .267 r
.25201 .74524 m .28719 .77466 L .28088 .75073 L p F P
0 g
s
.926 .548 .267 r
.28088 .75073 m .24463 .72003 L .25201 .74524 L p F P
0 g
s
.022 .077 .581 r
.8294 .50466 m .8196 .54447 L .82915 .57136 L p F P
0 g
s
.125 .187 .657 r
.8196 .54447 m .8294 .50466 L .81599 .47981 L p F P
0 g
s
.201 .446 .87 r
.71513 .33983 m .72967 .36863 L .75372 .38275 L p F P
0 g
s
.311 .521 .898 r
.72967 .36863 m .71513 .33983 L .69072 .33192 L p F P
0 g
s
.984 .702 .38 r
.21517 .65762 m .24059 .69376 L .23984 .66673 L p F P
0 g
s
.984 .702 .38 r
.23984 .66673 m .21434 .62987 L .21517 .65762 L p F P
0 g
s
.093 0 .255 r
.80883 .71729 m .77346 .74838 L .76705 .77241 L p F P
0 g
s
.179 0 .368 r
.77346 .74838 m .80883 .71729 L .81293 .69093 L p F P
0 g
s
.653 .896 .982 r
.45594 .27963 m .42665 .29239 L .44599 .29716 L p F P
0 g
s
.653 .896 .982 r
.44599 .29716 m .46963 .28693 L .45594 .27963 L p F P
0 g
s
.427 .674 .966 r
.64662 .30756 m .62207 .29118 L .60318 .29619 L p F P
0 g
s
.422 .711 .983 r
.57925 .28625 m .60318 .29619 L .62207 .29118 L p F P
0 g
s
0 0 .37 r
.83813 .62666 m .8137 .66385 L .81293 .69093 L p F P
0 g
s
.098 .022 .473 r
.8137 .66385 m .83813 .62666 L .83538 .59885 L p F P
0 g
s
.777 .971 .919 r
.35774 .31553 m .33425 .34213 L .35886 .33393 L p F P
0 g
s
.777 .971 .919 r
.35886 .33393 m .37958 .31069 L .35774 .31553 L p F P
0 g
s
.827 .366 .119 r
.30842 .81718 m .34846 .83879 L .33878 .82003 L p F P
0 g
s
.827 .366 .119 r
.33878 .82003 m .29637 .79691 L .30842 .81718 L p F P
0 g
s
.951 .955 .702 r
.23851 .44328 m .23522 .48307 L .25167 .45967 L p F P
0 g
s
.951 .955 .702 r
.25167 .45967 m .25512 .42169 L .23851 .44328 L p F P
0 g
s
.745 .256 .075 r
.36042 .85507 m .40377 .87041 L .39505 .85543 L p F P
0 g
s
.745 .256 .075 r
.39505 .85543 m .34846 .83879 L .36042 .85507 L p F P
0 g
s
.703 .943 .96 r
.40796 .29088 m .37958 .31069 L .40259 .30907 L p F P
0 g
s
.703 .943 .96 r
.40259 .30907 m .42665 .29239 L .40796 .29088 L p F P
0 g
s
.229 .531 .921 r
.6693 .30891 m .69072 .33192 L .71513 .33983 L p F P
0 g
s
.352 .599 .94 r
.69072 .33192 m .6693 .30891 L .64662 .30756 L p F P
0 g
s
.402 0 .145 r
.60347 .88012 m .65094 .86933 L .65996 .85426 L p F P
0 g
s
.253 0 .066 r
.70607 .83719 m .65996 .85426 L .65094 .86933 L p F P
0 g
s
.337 0 .211 r
.65996 .85426 m .70607 .83719 L .71597 .81832 L p F P
0 g
s
.149 0 .107 r
.75771 .79478 m .71597 .81832 L .70607 .83719 L p F P
0 g
s
.238 0 .246 r
.71597 .81832 m .75771 .79478 L .76705 .77241 L p F P
0 g
s
.31 .627 .961 r
.62207 .29118 m .64662 .30756 L .6693 .30891 L p F P
0 g
s
0 .182 .698 r
.79494 .41856 m .79951 .45656 L .81599 .47981 L p F P
0 g
s
.122 .295 .767 r
.79951 .45656 m .79494 .41856 L .77558 .39943 L p F P
0 g
s
.997 .836 .49 r
.20515 .56163 m .21708 .60209 L .22328 .57458 L p F P
0 g
s
.997 .836 .49 r
.22328 .57458 m .21174 .5343 L .20515 .56163 L p F P
0 g
s
.586 .874 .994 r
.48898 .27155 m .45594 .27963 L .46963 .28693 L p F P
0 g
s
.586 .874 .994 r
.46963 .28693 m .49619 .28047 L .48898 .27155 L p F P
0 g
s
.589 .09 .036 r
.45781 .89188 m .50394 .89654 L .50197 .88592 L p F P
0 g
s
.589 .09 .036 r
.50197 .88592 m .45156 .88078 L .45781 .89188 L p F P
0 g
s
.522 .04 .052 r
.55321 .8857 m .50197 .88592 L .50394 .89654 L p F P
0 g
s
.522 .04 .052 r
.50394 .89654 m .55086 .89634 L .55321 .8857 L p F P
0 g
s
.433 0 .033 r
.60347 .88012 m .55321 .8857 L .55086 .89634 L p F P
0 g
s
.422 .711 .983 r
.62207 .29118 m .5924 .27878 L .57925 .28625 L p F P
0 g
s
.435 .752 .994 r
.55249 .28012 m .57925 .28625 L .5924 .27878 L p F P
0 g
s
.867 .992 .821 r
.29049 .3674 m .27453 .40237 L .29644 .38545 L p F P
0 g
s
.867 .992 .821 r
.29644 .38545 m .31136 .3533 L .29049 .3674 L p F P
0 g
s
0 0 .479 r
.83951 .53088 m .82915 .57136 L .83538 .59885 L p F P
0 g
s
.022 .077 .581 r
.82915 .57136 m .83951 .53088 L .8294 .50466 L p F P
0 g
s
.063 .344 .82 r
.73785 .35074 m .75372 .38275 L .77558 .39943 L p F P
0 g
s
.201 .446 .87 r
.75372 .38275 m .73785 .35074 L .71513 .33983 L p F P
0 g
s
.888 .459 .125 r
.26275 .76908 m .29637 .79691 L .28719 .77466 L p F P
0 g
s
.888 .459 .125 r
.28719 .77466 m .25201 .74524 L .26275 .76908 L p F P
0 g
s
.522 .839 .999 r
.52401 .26865 m .48898 .27155 L .49619 .28047 L p F P
0 g
s
.522 .839 .999 r
.49619 .28047 m .52431 .27816 L .52401 .26865 L p F P
0 g
s
.961 .634 .252 r
.21967 .68501 m .24463 .72003 L .24059 .69376 L p F P
0 g
s
.961 .634 .252 r
.24059 .69376 m .21517 .65762 L .21967 .68501 L p F P
0 g
s
.435 .752 .994 r
.5924 .27878 m .55912 .27111 L .55249 .28012 L p F P
0 g
s
.469 .796 .999 r
.52431 .27816 m .55249 .28012 L .55912 .27111 L p F P
0 g
s
.637 .115 0 r
.41414 .88247 m .45781 .89188 L .45156 .88078 L p F P
0 g
s
.637 .115 0 r
.45156 .88078 m .40377 .87041 L .41414 .88247 L p F P
0 g
s
.433 0 .033 r
.55086 .89634 m .59685 .89128 L .60347 .88012 L p F P
0 g
s
.31 0 0 r
.65094 .86933 m .60347 .88012 L .59685 .89128 L p F P
0 g
s
.469 .796 .999 r
.55912 .27111 m .52401 .26865 L .52431 .27816 L p F P
0 g
s
0 0 .109 r
.80135 .74262 m .76705 .77241 L .75771 .79478 L p F P
0 g
s
.093 0 .255 r
.76705 .77241 m .80135 .74262 L .80883 .71729 L p F P
0 g
s
0 0 .236 r
.83727 .65447 m .81293 .69093 L .80883 .71729 L p F P
0 g
s
0 0 .37 r
.81293 .69093 m .83727 .65447 L .83813 .62666 L p F P
0 g
s
.952 .938 .608 r
.22496 .46694 m .22183 .50802 L .23522 .48307 L p F P
0 g
s
.952 .938 .608 r
.23522 .48307 m .23851 .44328 L .22496 .46694 L p F P
0 g
s
.611 .925 .971 r
.44269 .27568 m .40796 .29088 L .42665 .29239 L p F P
0 g
s
.611 .925 .971 r
.42665 .29239 m .45594 .27963 L .44269 .27568 L p F P
0 g
s
.768 .994 .873 r
.33734 .32363 m .31136 .3533 L .33425 .34213 L p F P
0 g
s
.768 .994 .873 r
.33425 .34213 m .35774 .31553 L .33734 .32363 L p F P
0 g
s
.31 .627 .961 r
.6693 .30891 m .64033 .28944 L .62207 .29118 L p F P
0 g
s
.285 .664 .971 r
.5924 .27878 m .62207 .29118 L .64033 .28944 L p F P
0 g
s
0 .04 .6 r
.81151 .43999 m .81599 .47981 L .8294 .50466 L p F P
0 g
s
0 .182 .698 r
.81599 .47981 m .81151 .43999 L .79494 .41856 L p F P
0 g
s
.977 .78 .362 r
.20223 .58973 m .21434 .62987 L .21708 .60209 L p F P
0 g
s
.977 .78 .362 r
.21708 .60209 m .20515 .56163 L .20223 .58973 L p F P
0 g
s
.067 .43 .871 r
.69084 .31348 m .71513 .33983 L .73785 .35074 L p F P
0 g
s
.229 .531 .921 r
.71513 .33983 m .69084 .31348 L .6693 .30891 L p F P
0 g
s
.861 .992 .741 r
.27194 .38436 m .25512 .42169 L .27453 .40237 L p F P
0 g
s
.861 .992 .741 r
.27453 .40237 m .29049 .3674 L .27194 .38436 L p F P
0 g
s
.673 .967 .925 r
.39016 .29277 m .35774 .31553 L .37958 .31069 L p F P
0 g
s
.673 .967 .925 r
.37958 .31069 m .40796 .29088 L .39016 .29277 L p F P
0 g
s
.755 .239 0 r
.32331 .83517 m .36042 .85507 L .34846 .83879 L p F P
0 g
s
.755 .239 0 r
.34846 .83879 m .30842 .81718 L .32331 .83517 L p F P
0 g
s
0 0 .345 r
.84611 .5582 m .83538 .59885 L .83813 .62666 L p F P
0 g
s
0 0 .479 r
.83538 .59885 m .84611 .5582 L .83951 .53088 L p F P
0 g
s
.147 .545 .924 r
.64033 .28944 m .6693 .30891 L .69084 .31348 L p F P
0 g
s
.253 0 .066 r
.65094 .86933 m .69383 .85359 L .70607 .83719 L p F P
0 g
s
.029 0 0 r
.74546 .81519 m .70607 .83719 L .69383 .85359 L p F P
0 g
s
.149 0 .107 r
.70607 .83719 m .74546 .81519 L .75771 .79478 L p F P
0 g
s
0 .209 .735 r
.75856 .3646 m .77558 .39943 L .79494 .41856 L p F P
0 g
s
.063 .344 .82 r
.77558 .39943 m .75856 .3646 L .73785 .35074 L p F P
0 g
s
.658 .111 0 r
.37464 .86857 m .41414 .88247 L .40377 .87041 L p F P
0 g
s
.658 .111 0 r
.40377 .87041 m .36042 .85507 L .37464 .86857 L p F P
0 g
s
.31 0 0 r
.59685 .89128 m .64022 .88149 L .65094 .86933 L p F P
0 g
s
.134 0 0 r
.69383 .85359 m .65094 .86933 L .64022 .88149 L p F P
0 g
s
.906 .533 .088 r
.22789 .71173 m .25201 .74524 L .24463 .72003 L p F P
0 g
s
.906 .533 .088 r
.24463 .72003 m .21967 .68501 L .22789 .71173 L p F P
0 g
s
.504 .882 .972 r
.48198 .26603 m .44269 .27568 L .45594 .27963 L p F P
0 g
s
.504 .882 .972 r
.45594 .27963 m .48898 .27155 L .48198 .26603 L p F P
0 g
s
.812 .333 0 r
.27682 .7912 m .30842 .81718 L .29637 .79691 L p F P
0 g
s
.812 .333 0 r
.29637 .79691 m .26275 .76908 L .27682 .7912 L p F P
0 g
s
.285 .664 .971 r
.64033 .28944 m .60514 .27466 L .5924 .27878 L p F P
0 g
s
.289 .709 .971 r
.55912 .27111 m .5924 .27878 L .60514 .27466 L p F P
0 g
s
0 0 .067 r
.83273 .68197 m .80883 .71729 L .80135 .74262 L p F P
0 g
s
0 0 .236 r
.80883 .71729 m .83273 .68197 L .83727 .65447 L p F P
0 g
s
.925 .89 .478 r
.21473 .49246 m .21174 .5343 L .22183 .50802 L p F P
0 g
s
.925 .89 .478 r
.22183 .50802 m .22496 .46694 L .21473 .49246 L p F P
0 g
s
.48 0 0 r
.46504 .89969 m .50623 .90383 L .50394 .89654 L p F P
0 g
s
.48 0 0 r
.50394 .89654 m .45781 .89188 L .46504 .89969 L p F P
0 g
s
.413 0 0 r
.55086 .89634 m .50394 .89654 L .50623 .90383 L p F P
0 g
s
.413 0 0 r
.50623 .90383 m .54814 .90365 L .55086 .89634 L p F P
0 g
s
.314 0 0 r
.59685 .89128 m .55086 .89634 L .54814 .90365 L p F P
0 g
s
0 0 0 r
.79048 .7666 m .75771 .79478 L .74546 .81519 L p F P
0 g
s
0 0 .109 r
.75771 .79478 m .79048 .7666 L .80135 .74262 L p F P
0 g
s
0 0 .462 r
.82503 .46355 m .8294 .50466 L .83951 .53088 L p F P
0 g
s
0 .04 .6 r
.8294 .50466 m .82503 .46355 L .81151 .43999 L p F P
0 g
s
.924 .689 .199 r
.20311 .61827 m .21517 .65762 L .21434 .62987 L p F P
0 g
s
.924 .689 .199 r
.21434 .62987 m .20223 .58973 L .20311 .61827 L p F P
0 g
s
.404 .824 .969 r
.52372 .26257 m .48198 .26603 L .48898 .27155 L p F P
0 g
s
.404 .824 .969 r
.48898 .27155 m .52401 .26865 L .52372 .26257 L p F P
0 g
s
.727 .984 .781 r
.31869 .33503 m .29049 .3674 L .31136 .3533 L p F P
0 g
s
.727 .984 .781 r
.31136 .3533 m .33734 .32363 L .31869 .33503 L p F P
0 g
s
.289 .709 .971 r
.60514 .27466 m .56555 .26551 L .55912 .27111 L p F P
0 g
s
.328 .763 .969 r
.52401 .26865 m .55912 .27111 L .56555 .26551 L p F P
0 g
s
.515 0 0 r
.42612 .89134 m .46504 .89969 L .45781 .89188 L p F P
0 g
s
.515 0 0 r
.45781 .89188 m .41414 .88247 L .42612 .89134 L p F P
0 g
s
.314 0 0 r
.54814 .90365 m .58919 .89916 L .59685 .89128 L p F P
0 g
s
.172 0 0 r
.64022 .88149 m .59685 .89128 L .58919 .89916 L p F P
0 g
s
.823 .956 .617 r
.25603 .40407 m .23851 .44328 L .25512 .42169 L p F P
0 g
s
.823 .956 .617 r
.25512 .42169 m .27194 .38436 L .25603 .40407 L p F P
0 g
s
0 0 .176 r
.84902 .58632 m .83813 .62666 L .83727 .65447 L p F P
0 g
s
0 0 .345 r
.83813 .62666 m .84902 .58632 L .84611 .5582 L p F P
0 g
s
.328 .763 .969 r
.56555 .26551 m .52372 .26257 L .52401 .26865 L p F P
0 g
s
0 .285 .773 r
.71096 .32135 m .73785 .35074 L .75856 .3646 L p F P
0 g
s
.067 .43 .871 r
.73785 .35074 m .71096 .32135 L .69084 .31348 L p F P
0 g
s
.524 .917 .907 r
.43003 .27526 m .39016 .29277 L .40796 .29088 L p F P
0 g
s
.524 .917 .907 r
.40796 .29088 m .44269 .27568 L .43003 .27526 L p F P
0 g
s
0 .037 .604 r
.77697 .38137 m .79494 .41856 L .81151 .43999 L p F P
0 g
s
0 .209 .735 r
.79494 .41856 m .77697 .38137 L .75856 .3646 L p F P
0 g
s
.147 .545 .924 r
.69084 .31348 m .65773 .29111 L .64033 .28944 L p F P
0 g
s
.088 .565 .904 r
.60514 .27466 m .64033 .28944 L .65773 .29111 L p F P
0 g
s
.601 .951 .835 r
.37348 .29818 m .33734 .32363 L .35774 .31553 L p F P
0 g
s
.601 .951 .835 r
.35774 .31553 m .39016 .29277 L .37348 .29818 L p F P
0 g
s
.626 .064 0 r
.34094 .85058 m .37464 .86857 L .36042 .85507 L p F P
0 g
s
.626 .064 0 r
.36042 .85507 m .32331 .83517 L .34094 .85058 L p F P
0 g
s
0 .41 .829 r
.65773 .29111 m .69084 .31348 L .71096 .32135 L p F P
0 g
s
.806 .391 0 r
.23983 .73741 m .26275 .76908 L .25201 .74524 L p F P
0 g
s
.806 .391 0 r
.25201 .74524 m .22789 .71173 L .23983 .73741 L p F P
0 g
s
.134 0 0 r
.64022 .88149 m .67929 .86723 L .69383 .85359 L p F P
0 g
s
0 0 0 r
.73033 .83334 m .69383 .85359 L .67929 .86723 L p F P
0 g
s
.029 0 0 r
.69383 .85359 m .73033 .83334 L .74546 .81519 L p F P
0 g
s
.858 .799 .308 r
.20804 .51957 m .20515 .56163 L .21174 .5343 L p F P
0 g
s
.858 .799 .308 r
.21174 .5343 m .21473 .49246 L .20804 .51957 L p F P
0 g
s
0 0 0 r
.82444 .70882 m .80135 .74262 L .79048 .7666 L p F P
0 g
s
0 0 .067 r
.80135 .74262 m .82444 .70882 L .83273 .68197 L p F P
0 g
s
.506 0 0 r
.39101 .87903 m .42612 .89134 L .41414 .88247 L p F P
0 g
s
.506 0 0 r
.41414 .88247 m .37464 .86857 L .39101 .87903 L p F P
0 g
s
.682 .164 0 r
.29416 .81131 m .32331 .83517 L .30842 .81718 L p F P
0 g
s
.682 .164 0 r
.30842 .81718 m .27682 .7912 L .29416 .81131 L p F P
0 g
s
0 0 .284 r
.83523 .489 m .83951 .53088 L .84611 .5582 L p F P
0 g
s
0 0 .462 r
.83951 .53088 m .83523 .489 L .82503 .46355 L p F P
0 g
s
.172 0 0 r
.58919 .89916 m .62784 .89047 L .64022 .88149 L p F P
0 g
s
0 0 0 r
.67929 .86723 m .64022 .88149 L .62784 .89047 L p F P
0 g
s
.825 .555 .004 r
.2079 .64692 m .21967 .68501 L .21517 .65762 L p F P
0 g
s
.825 .555 .004 r
.21517 .65762 m .20311 .61827 L .2079 .64692 L p F P
0 g
s
0 0 0 r
.77625 .78889 m .74546 .81519 L .73033 .83334 L p F P
0 g
s
0 0 0 r
.74546 .81519 m .77625 .78889 L .79048 .7666 L p F P
0 g
s
.359 .83 .873 r
.47529 .26414 m .43003 .27526 L .44269 .27568 L p F P
0 g
s
.359 .83 .873 r
.44269 .27568 m .48198 .26603 L .47529 .26414 L p F P
0 g
s
0 0 0 r
.84812 .61493 m .83727 .65447 L .83273 .68197 L p F P
0 g
s
0 0 .176 r
.83727 .65447 m .84812 .61493 L .84902 .58632 L p F P
0 g
s
.088 .565 .904 r
.65773 .29111 m .61731 .27409 L .60514 .27466 L p F P
0 g
s
.072 .599 .871 r
.56555 .26551 m .60514 .27466 L .61731 .27409 L p F P
0 g
s
.739 .866 .442 r
.24302 .42638 m .22496 .46694 L .23851 .44328 L p F P
0 g
s
.739 .866 .442 r
.23851 .44328 m .25603 .40407 L .24302 .42638 L p F P
0 g
s
.638 .915 .624 r
.30206 .34971 m .27194 .38436 L .29049 .3674 L p F P
0 g
s
.638 .915 .624 r
.29049 .3674 m .31869 .33503 L .30206 .34971 L p F P
0 g
s
.299 0 0 r
.4732 .90398 m .50881 .90755 L .50623 .90383 L p F P
0 g
s
.299 0 0 r
.50623 .90383 m .46504 .89969 L .4732 .90398 L p F P
0 g
s
.237 0 0 r
.54814 .90365 m .50623 .90383 L .50881 .90755 L p F P
0 g
s
.237 0 0 r
.50881 .90755 m .54506 .9074 L .54814 .90365 L p F P
0 g
s
.132 0 0 r
.58919 .89916 m .54814 .90365 L .54506 .9074 L p F P
0 g
s
0 .094 .609 r
.72936 .33254 m .75856 .3646 L .77697 .38137 L p F P
0 g
s
0 .285 .773 r
.75856 .3646 m .72936 .33254 L .71096 .32135 L p F P
0 g
s
0 0 .42 r
.79277 .40093 m .81151 .43999 L .82503 .46355 L p F P
0 g
s
0 .037 .604 r
.81151 .43999 m .79277 .40093 L .77697 .38137 L p F P
0 g
s
.743 .659 .104 r
.20507 .54798 m .20223 .58973 L .20515 .56163 L p F P
0 g
s
.743 .659 .104 r
.20515 .56163 m .20804 .51957 L .20507 .54798 L p F P
0 g
s
.214 .735 .848 r
.52344 .26014 m .47529 .26414 L .48198 .26603 L p F P
0 g
s
.214 .735 .848 r
.48198 .26603 m .52372 .26257 L .52344 .26014 L p F P
0 g
s
.316 0 0 r
.43962 .89679 m .4732 .90398 L .46504 .89969 L p F P
0 g
s
.316 0 0 r
.46504 .89969 m .42612 .89134 L .43962 .89679 L p F P
0 g
s
.072 .599 .871 r
.61731 .27409 m .5717 .26353 L .56555 .26551 L p F P
0 g
s
.114 .655 .847 r
.52372 .26257 m .56555 .26551 L .5717 .26353 L p F P
0 g
s
.651 .211 0 r
.25544 .76172 m .27682 .7912 L .26275 .76908 L p F P
0 g
s
.651 .211 0 r
.26275 .76908 m .23983 .73741 L .25544 .76172 L p F P
0 g
s
.132 0 0 r
.54506 .9074 m .58055 .90352 L .58919 .89916 L p F P
0 g
s
0 0 0 r
.62784 .89047 m .58919 .89916 L .58055 .90352 L p F P
0 g
s
.374 .833 .752 r
.41815 .27855 m .37348 .29818 L .39016 .29277 L p F P
0 g
s
.374 .833 .752 r
.39016 .29277 m .43003 .27526 L .41815 .27855 L p F P
0 g
s
.471 .861 .663 r
.35819 .30719 m .31869 .33503 L .33734 .32363 L p F P
0 g
s
.471 .861 .663 r
.33734 .32363 m .37348 .29818 L .35819 .30719 L p F P
0 g
s
0 .41 .829 r
.71096 .32135 m .67402 .29632 L .65773 .29111 L p F P
0 g
s
0 .395 .744 r
.61731 .27409 m .65773 .29111 L .67402 .29632 L p F P
0 g
s
.114 .655 .847 r
.5717 .26353 m .52344 .26014 L .52372 .26257 L p F P
0 g
s
0 0 .076 r
.8419 .51609 m .84611 .5582 L .84902 .58632 L p F P
0 g
s
0 0 .284 r
.84611 .5582 m .8419 .51609 L .83523 .489 L p F P
0 g
s
0 0 0 r
.81241 .73467 m .79048 .7666 L .77625 .78889 L p F P
0 g
s
0 0 0 r
.79048 .7666 m .81241 .73467 L .82444 .70882 L p F P
0 g
s
0 .216 .65 r
.67402 .29632 m .71096 .32135 L .72936 .33254 L p F P
0 g
s
.428 0 0 r
.36121 .86314 m .39101 .87903 L .37464 .86857 L p F P
0 g
s
.428 0 0 r
.37464 .86857 m .34094 .85058 L .36121 .86314 L p F P
0 g
s
.677 .383 0 r
.21664 .67532 m .22789 .71173 L .21967 .68501 L p F P
0 g
s
.677 .383 0 r
.21967 .68501 m .2079 .64692 L .21664 .67532 L p F P
0 g
s
0 0 0 r
.62784 .89047 m .66255 .87785 L .67929 .86723 L p F P
0 g
s
0 0 0 r
.71241 .84893 m .67929 .86723 L .66255 .87785 L p F P
0 g
s
0 0 0 r
.67929 .86723 m .71241 .84893 L .73033 .83334 L p F P
0 g
s
.491 0 0 r
.31465 .82907 m .34094 .85058 L .32331 .83517 L p F P
0 g
s
.491 0 0 r
.32331 .83517 m .29416 .81131 L .31465 .82907 L p F P
0 g
s
0 0 0 r
.83273 .68197 m .8433 .64369 L .84812 .61493 L p F P
0 g
s
.71 .744 .234 r
.8433 .64369 m .83273 .68197 L .82444 .70882 L p F P
0 g
s
0 0 0 r
.75871 .80919 m .73033 .83334 L .71241 .84893 L p F P
0 g
s
0 0 0 r
.73033 .83334 m .75871 .80919 L .77625 .78889 L p F P
0 g
s
0 0 0 r
.23318 .45108 m .21473 .49246 L .22496 .46694 L p F P
0 g
s
0 0 0 r
.22496 .46694 m .24302 .42638 L .23318 .45108 L p F P
0 g
s
.01 w
.84037 .65491 Mdot
.83009 .69085 Mdot
.5 Mabswid
.279 0 0 r
.40944 .88621 m .43962 .89679 L .42612 .89134 L p F P
0 g
s
.279 0 0 r
.42612 .89134 m .39101 .87903 L .40944 .88621 L p F P
0 g
s
0 0 0 r
.28776 .36759 m .25603 .40407 L .27194 .38436 L p F P
0 g
s
0 0 0 r
.27194 .38436 m .30206 .34971 L .28776 .36759 L p F P
0 g
s
0 0 0 r
.58055 .90352 m .61389 .89604 L .62784 .89047 L p F P
0 g
s
0 0 0 r
.66255 .87785 m .62784 .89047 L .61389 .89604 L p F P
0 g
s
.01 w
.83178 .68651 Mdot
.5 Mabswid
0 0 .42 r
.82503 .46355 m .80568 .42313 L .79277 .40093 L p F P
0 g
s
.724 .363 0 r
.80568 .42313 m .82503 .46355 L .83523 .489 L p F P
0 g
s
.01 w
.74564 .82055 Mdot
.8415 .65138 Mdot
.5 Mabswid
0 .094 .609 r
.77697 .38137 m .74575 .34703 L .72936 .33254 L p F P
0 g
s
.606 .121 0 r
.74575 .34703 m .77697 .38137 L .79277 .40093 L p F P
0 g
s
.01 w
.83339 .68217 Mdot
.74358 .82267 Mdot
.5 Mabswid
0 0 .109 r
.20597 .57736 m .20311 .61827 L .20223 .58973 L p F P
0 g
s
0 0 .109 r
.20223 .58973 m .20507 .54798 L .20597 .57736 L p F P
0 g
s
.01 w
.74157 .82469 Mdot
.83493 .67783 Mdot
.5 Mabswid
0 0 0 r
.469 .26605 m .41815 .27855 L .43003 .27526 L p F P
0 g
s
0 0 0 r
.43003 .27526 m .47529 .26414 L .469 .26605 L p F P
0 g
s
.01 w
.78023 .78341 Mdot
.84253 .6479 Mdot
.68672 .8646 Mdot
.5 Mabswid
0 .395 .744 r
.67402 .29632 m .62873 .27724 L .61731 .27409 L p F P
0 g
s
.193 0 0 r
.5717 .26353 m .61731 .27409 L .62873 .27724 L p F P
0 g
s
.01 w
.73962 .82662 Mdot
.83638 .67349 Mdot
.5 Mabswid
0 0 .532 r
.27462 .78429 m .29416 .81131 L .27682 .7912 L p F P
0 g
s
0 0 .532 r
.27682 .7912 m .25544 .76172 L .27462 .78429 L p F P
0 g
s
0 0 .076 r
.84902 .58632 m .84484 .54453 L .8419 .51609 L p F P
0 g
s
.838 .676 .136 r
.84484 .54453 m .84902 .58632 L .84812 .61493 L p F P
0 g
s
.01 w
.73772 .82846 Mdot
.68628 .86504 Mdot
.77946 .78475 Mdot
.20769 .6457 Mdot
.83775 .66916 Mdot
.38491 .87579 Mdot
.84345 .64449 Mdot
.73588 .8302 Mdot
.5 Mabswid
0 0 0 r
.77625 .78889 m .79668 .75916 L .81241 .73467 L p F P
0 g
s
.667 .897 .552 r
.79668 .75916 m .77625 .78889 L .75871 .80919 L p F P
0 g
s
0 0 .407 r
.2293 .70308 m .23983 .73741 L .22789 .71173 L p F P
0 g
s
0 0 .407 r
.22789 .71173 m .21664 .67532 L .2293 .70308 L p F P
0 g
s
.01 w
.68593 .86541 Mdot
.5 Mabswid
0 .537 .727 r
.48225 .90453 m .51168 .90748 L .50881 .90755 L p F P
0 g
s
0 .537 .727 r
.50881 .90755 m .4732 .90398 L .48225 .90453 L p F P
0 g
s
.007 .583 .711 r
.54506 .9074 m .50881 .90755 L .51168 .90748 L p F P
0 g
s
.01 w
.81053 .73767 Mdot
.5 Mabswid
.007 .583 .711 r
.51168 .90748 m .54166 .90735 L .54506 .9074 L p F P
0 g
s
.102 .657 .73 r
.58055 .90352 m .54506 .9074 L .54166 .90735 L p F P
0 g
s
.01 w
.38439 .87567 Mdot
.83904 .66485 Mdot
.5 Mabswid
0 0 0 r
.34453 .31982 m .30206 .34971 L .31869 .33503 L p F P
0 g
s
0 0 0 r
.31869 .33503 m .35819 .30719 L .34453 .31982 L p F P
0 g
s
.01 w
.7786 .78613 Mdot
.7341 .83186 Mdot
.84427 .64114 Mdot
.29837 .81516 Mdot
.68567 .86569 Mdot
.20696 .64304 Mdot
.38378 .87549 Mdot
.5 Mabswid
0 0 0 r
.40723 .28566 m .35819 .30719 L .37348 .29818 L p F P
0 g
s
0 0 0 r
.37348 .29818 m .41815 .27855 L .40723 .28566 L p F P
0 g
s
.01 w
.73239 .83341 Mdot
.84024 .66055 Mdot
.5 Mabswid
.812 .87 .43 r
.83452 .67223 m .82444 .70882 L .81241 .73467 L p F P
0 g
s
.71 .744 .234 r
.82444 .70882 m .83452 .67223 L .8433 .64369 L p F P
0 g
s
0 .216 .65 r
.72936 .33254 m .68896 .30515 L .67402 .29632 L p F P
0 g
s
.565 .009 0 r
.68896 .30515 m .72936 .33254 L .74575 .34703 L p F P
0 g
s
.01 w
.81029 .7385 Mdot
.77764 .78755 Mdot
.6855 .8659 Mdot
.29981 .81671 Mdot
.38309 .87525 Mdot
.5 Mabswid
.426 0 0 r
.62873 .27724 m .67402 .29632 L .68896 .30515 L p F P
0 g
s
0 0 0 r
.22673 .47794 m .20804 .51957 L .21473 .49246 L p F P
0 g
s
0 0 0 r
.21473 .49246 m .23318 .45108 L .22673 .47794 L p F P
0 g
s
.01 w
.73073 .83488 Mdot
.5 Mabswid
0 .518 .773 r
.45455 .89859 m .48225 .90453 L .4732 .90398 L p F P
0 g
s
0 .518 .773 r
.4732 .90398 m .43962 .89679 L .45455 .89859 L p F P
0 g
s
.031 0 0 r
.52317 .26155 m .469 .26605 L .47529 .26414 L p F P
0 g
s
.031 0 0 r
.47529 .26414 m .52344 .26014 L .52317 .26155 L p F P
0 g
s
0 .364 .749 r
.38395 .87259 m .40944 .88621 L .39101 .87903 L p F P
0 g
s
0 .364 .749 r
.39101 .87903 m .36121 .86314 L .38395 .87259 L p F P
0 g
s
.01 w
.84135 .65627 Mdot
.5 Mabswid
.102 .657 .73 r
.54166 .90735 m .57098 .90415 L .58055 .90352 L p F P
0 g
s
.235 .753 .778 r
.61389 .89604 m .58055 .90352 L .57098 .90415 L p F P
0 g
s
.193 0 0 r
.62873 .27724 m .57748 .26537 L .5717 .26353 L p F P
0 g
s
.146 0 0 r
.52344 .26014 m .5717 .26353 L .57748 .26537 L p F P
0 g
s
0 .246 .705 r
.33813 .8442 m .36121 .86314 L .34094 .85058 L p F P
0 g
s
0 .246 .705 r
.34094 .85058 m .31465 .82907 L .33813 .8442 L p F P
0 g
s
.01 w
.84499 .63787 Mdot
.20633 .64046 Mdot
.38231 .87494 Mdot
.68542 .86602 Mdot
.77658 .78901 Mdot
.30132 .81827 Mdot
.72915 .83625 Mdot
.5 Mabswid
0 0 0 r
.61389 .89604 m .64373 .88519 L .66255 .87785 L p F P
0 g
s
0 0 0 r
.66255 .87785 m .69183 .86169 L .71241 .84893 L p F P
0 g
s
.443 .87 .759 r
.69183 .86169 m .66255 .87785 L .64373 .88519 L p F P
0 g
s
.01 w
.80994 .73941 Mdot
.5 Mabswid
0 0 0 r
.71241 .84893 m .738 .82716 L .75871 .80919 L p F P
0 g
s
.568 .918 .718 r
.738 .82716 m .71241 .84893 L .69183 .86169 L p F P
0 g
s
.01 w
.84236 .65201 Mdot
.38144 .87456 Mdot
.5 Mabswid
.867 .534 .022 r
.81545 .44776 m .83523 .489 L .8419 .51609 L p F P
0 g
s
.724 .363 0 r
.83523 .489 m .81545 .44776 L .80568 .42313 L p F P
0 g
s
.01 w
.68544 .86608 Mdot
.30291 .81985 Mdot
.5 Mabswid
.146 0 0 r
.57748 .26537 m .52317 .26155 L .52344 .26014 L p F P
0 g
s
.01 w
.72763 .83752 Mdot
.5 Mabswid
0 0 0 r
.27605 .38856 m .24302 .42638 L .25603 .40407 L p F P
0 g
s
0 0 0 r
.25603 .40407 m .28776 .36759 L .27605 .38856 L p F P
0 g
s
.01 w
.8456 .63467 Mdot
.8456 .63467 Mdot
.77544 .7905 Mdot
.38049 .87412 Mdot
.20581 .63798 Mdot
.5 Mabswid
0 0 .305 r
.21084 .60734 m .2079 .64692 L .20311 .61827 L p F P
0 g
s
0 0 .305 r
.20311 .61827 m .20597 .57736 L .21084 .60734 L p F P
0 g
s
.01 w
.68554 .86605 Mdot
.84327 .64779 Mdot
.80948 .74037 Mdot
.30456 .82144 Mdot
.72619 .83871 Mdot
.37946 .87363 Mdot
.77421 .79202 Mdot
.5 Mabswid
.782 .318 0 r
.75986 .36477 m .79277 .40093 L .80568 .42313 L p F P
0 g
s
.606 .121 0 r
.79277 .40093 m .75986 .36477 L .74575 .34703 L p F P
0 g
s
.01 w
.30627 .82304 Mdot
.68574 .86595 Mdot
.72482 .83979 Mdot
.8461 .63155 Mdot
.37835 .87307 Mdot
.84409 .6436 Mdot
.2054 .63559 Mdot
.80891 .74141 Mdot
.5 Mabswid
.926 .796 .327 r
.84393 .57397 m .84812 .61493 L .8433 .64369 L p F P
0 g
s
.838 .676 .136 r
.84812 .61493 m .84393 .57397 L .84484 .54453 L p F P
0 g
s
.01 w
.30805 .82464 Mdot
.77289 .79358 Mdot
.68603 .86578 Mdot
.5 Mabswid
0 .522 .836 r
.42975 .88988 m .45455 .89859 L .43962 .89679 L p F P
0 g
s
0 .522 .836 r
.43962 .89679 m .40944 .88621 L .42975 .88988 L p F P
0 g
s
.01 w
.37716 .87245 Mdot
.72352 .84079 Mdot
.5 Mabswid
0 .179 .699 r
.29722 .8048 m .31465 .82907 L .29416 .81131 L p F P
0 g
s
0 .179 .699 r
.29416 .81131 m .27462 .78429 L .29722 .8048 L p F P
0 g
s
.235 .753 .778 r
.57098 .90415 m .59847 .89798 L .61389 .89604 L p F P
0 g
s
.393 .852 .842 r
.64373 .88519 m .61389 .89604 L .59847 .89798 L p F P
0 g
s
.01 w
.30988 .82626 Mdot
.84481 .63945 Mdot
.3759 .87177 Mdot
.5 Mabswid
0 0 .574 r
.24583 .72982 m .25544 .76172 L .23983 .73741 L p F P
0 g
s
0 0 .574 r
.23983 .73741 m .2293 .70308 L .24583 .72982 L p F P
0 g
s
.01 w
.6864 .86553 Mdot
.8465 .62851 Mdot
.7223 .84169 Mdot
.7715 .79516 Mdot
.80824 .74251 Mdot
.31176 .82788 Mdot
.37456 .87104 Mdot
.5 Mabswid
.738 .971 .712 r
.77736 .78196 m .75871 .80919 L .738 .82716 L p F P
0 g
s
.667 .897 .552 r
.75871 .80919 m .77736 .78196 L .79668 .75916 L p F P
0 g
s
.01 w
.20511 .63329 Mdot
.68687 .86521 Mdot
.72115 .84249 Mdot
.84543 .63533 Mdot
.37316 .87026 Mdot
.31369 .82951 Mdot
.77003 .79677 Mdot
.5 Mabswid
.87 .948 .59 r
.8218 .70017 m .81241 .73467 L .79668 .75916 L p F P
0 g
s
.812 .87 .43 r
.81241 .73467 m .8218 .70017 L .83452 .67223 L p F P
0 g
s
.01 w
.37168 .86942 Mdot
.68742 .86483 Mdot
.84678 .62555 Mdot
.31566 .83113 Mdot
.80747 .74367 Mdot
.72009 .84321 Mdot
.5 Mabswid
.079 0 0 r
.46321 .27193 m .40723 .28566 L .41815 .27855 L p F P
0 g
s
.079 0 0 r
.41815 .27855 m .469 .26605 L .46321 .27193 L p F P
0 g
s
.01 w
.76849 .79841 Mdot
.37014 .86852 Mdot
.37014 .86853 Mdot
.84594 .63127 Mdot
.31767 .83276 Mdot
.20492 .63109 Mdot
.5 Mabswid
0 0 .195 r
.22387 .50664 m .20507 .54798 L .20804 .51957 L p F P
0 g
s
0 0 .195 r
.20804 .51957 m .22673 .47794 L .22387 .50664 L p F P
0 g
s
.01 w
.68805 .86437 Mdot
.5 Mabswid
.426 0 0 r
.68896 .30515 m .63923 .28422 L .62873 .27724 L p F P
0 g
s
.433 0 0 r
.57748 .26537 m .62873 .27724 L .63923 .28422 L p F P
0 g
s
.01 w
.36853 .86758 Mdot
.7191 .84383 Mdot
.5 Mabswid
0 0 0 r
.33275 .33606 m .28776 .36759 L .30206 .34971 L p F P
0 g
s
0 0 0 r
.30206 .34971 m .34453 .31982 L .33275 .33606 L p F P
0 g
s
.01 w
.31972 .83438 Mdot
.76687 .80007 Mdot
.36687 .86659 Mdot
.80661 .74489 Mdot
.68878 .86384 Mdot
.3218 .836 Mdot
.84696 .62268 Mdot
.36514 .86555 Mdot
.84634 .62725 Mdot
.7182 .84436 Mdot
.3239 .83761 Mdot
.5 Mabswid
.735 .211 0 r
.70231 .31763 m .74575 .34703 L .75986 .36477 L p F P
0 g
s
.565 .009 0 r
.74575 .34703 m .70231 .31763 L .68896 .30515 L p F P
0 g
s
.01 w
.36336 .86447 Mdot
.7652 .80175 Mdot
.68958 .86325 Mdot
.5 Mabswid
.951 .66 .216 r
.82184 .47459 m .8419 .51609 L .84484 .54453 L p F P
0 g
s
.867 .534 .022 r
.8419 .51609 m .82184 .47459 L .81545 .44776 L p F P
0 g
s
.01 w
.20485 .629 Mdot
.32603 .83921 Mdot
.36153 .86334 Mdot
.5 Mabswid
0 .422 .847 r
.36436 .85641 m .38395 .87259 L .36121 .86314 L p F P
0 g
s
0 .422 .847 r
.36121 .86314 m .33813 .8442 L .36436 .85641 L p F P
0 g
s
0 0 .466 r
.2197 .63753 m .21664 .67532 L .2079 .64692 L p F P
0 g
s
0 0 .466 r
.2079 .64692 m .21084 .60734 L .2197 .63753 L p F P
0 g
s
.01 w
.32817 .84081 Mdot
.80564 .74617 Mdot
.71737 .8448 Mdot
.35965 .86217 Mdot
.5 Mabswid
.031 0 0 r
.39746 .29667 m .34453 .31982 L .35819 .30719 L p F P
0 g
s
.031 0 0 r
.35819 .30719 m .40723 .28566 L .39746 .29667 L p F P
0 g
s
.01 w
.69047 .86259 Mdot
.33033 .84239 Mdot
.76346 .80345 Mdot
.35773 .86096 Mdot
.84664 .62329 Mdot
.84702 .61991 Mdot
.33249 .84395 Mdot
.5 Mabswid
.211 .706 .917 r
.49209 .90117 m .5148 .90345 L .51168 .90748 L p F P
0 g
s
.211 .706 .917 r
.51168 .90748 m .48225 .90453 L .49209 .90117 L p F P
0 g
s
.252 .746 .911 r
.54166 .90735 m .51168 .90748 L .5148 .90345 L p F P
0 g
s
0 0 .053 r
.26717 .41245 m .23318 .45108 L .24302 .42638 L p F P
0 g
s
0 0 .053 r
.24302 .42638 m .27605 .38856 L .26717 .41245 L p F P
0 g
s
.01 w
.35577 .85971 Mdot
.5 Mabswid
.252 .746 .911 r
.5148 .90345 m .53795 .90335 L .54166 .90735 L p F P
0 g
s
.322 .796 .918 r
.57098 .90415 m .54166 .90735 L .53795 .90335 L p F P
0 g
s
.443 .87 .759 r
.64373 .88519 m .66876 .87135 L .69183 .86169 L p F P
0 g
s
.642 .967 .853 r
.71428 .84252 m .69183 .86169 L .66876 .87135 L p F P
0 g
s
.568 .918 .718 r
.69183 .86169 m .71428 .84252 L .738 .82716 L p F P
0 g
s
.01 w
.33466 .8455 Mdot
.35377 .85842 Mdot
.5 Mabswid
.062 .537 .894 r
.40893 .8787 m .42975 .88988 L .40944 .88621 L p F P
0 g
s
.062 .537 .894 r
.40944 .88621 m .38395 .87259 L .40893 .8787 L p F P
0 g
s
.01 w
.69144 .86187 Mdot
.33684 .84704 Mdot
.71663 .84514 Mdot
.35173 .8571 Mdot
.5 Mabswid
.621 .055 0 r
.63923 .28422 m .68896 .30515 L .70231 .31763 L p F P
0 g
s
.01 w
.33901 .84855 Mdot
.34966 .85575 Mdot
.76167 .80516 Mdot
.34117 .85004 Mdot
.34757 .85437 Mdot
.34332 .85151 Mdot
.34545 .85295 Mdot
.80459 .74751 Mdot
.20489 .62701 Mdot
.5 Mabswid
.393 .852 .842 r
.59847 .89798 m .62298 .88905 L .64373 .88519 L p F P
0 g
s
.549 .929 .899 r
.66876 .87135 m .64373 .88519 L .62298 .88905 L p F P
0 g
s
.968 .873 .481 r
.83905 .60406 m .8433 .64369 L .83452 .67223 L p F P
0 g
s
.926 .796 .327 r
.8433 .64369 m .83905 .60406 L .84393 .57397 L p F P
0 g
s
.01 w
.69249 .86108 Mdot
.84682 .61939 Mdot
.71598 .8454 Mdot
.75982 .8069 Mdot
.5 Mabswid
.889 .47 .073 r
.77141 .38564 m .80568 .42313 L .81545 .44776 L p F P
0 g
s
.782 .318 0 r
.80568 .42313 m .77141 .38564 L .75986 .36477 L p F P
0 g
s
.01 w
.84697 .61723 Mdot
.69362 .86024 Mdot
.5 Mabswid
.201 .679 .934 r
.47078 .89658 m .49209 .90117 L .48225 .90453 L p F P
0 g
s
.201 .679 .934 r
.48225 .90453 m .45455 .89859 L .47078 .89658 L p F P
0 g
s
.322 .796 .918 r
.53795 .90335 m .56057 .90087 L .57098 .90415 L p F P
0 g
s
.413 .85 .935 r
.59847 .89798 m .57098 .90415 L .56057 .90087 L p F P
0 g
s
.257 0 0 r
.52293 .26699 m .46321 .27193 L .469 .26605 L p F P
0 g
s
.257 0 0 r
.469 .26605 m .52317 .26155 L .52293 .26699 L p F P
0 g
s
.01 w
.75792 .80864 Mdot
.80344 .74891 Mdot
.5 Mabswid
0 .162 .701 r
.2661 .75515 m .27462 .78429 L .25544 .76172 L p F P
0 g
s
0 .162 .701 r
.25544 .76172 m .24583 .72982 L .2661 .75515 L p F P
0 g
s
.01 w
.71541 .84557 Mdot
.5 Mabswid
.433 0 0 r
.63923 .28422 m .58279 .27118 L .57748 .26537 L p F P
0 g
s
.373 0 0 r
.52317 .26155 m .57748 .26537 L .58279 .27118 L p F P
0 g
s
0 .341 .818 r
.32302 .8229 m .33813 .8442 L .31465 .82907 L p F P
0 g
s
0 .341 .818 r
.31465 .82907 m .29722 .8048 L .32302 .8229 L p F P
0 g
s
.01 w
.69482 .85933 Mdot
.20504 .62512 Mdot
.8469 .61555 Mdot
.75598 .8104 Mdot
.69609 .85837 Mdot
.69609 .85837 Mdot
.71493 .84565 Mdot
.84681 .61465 Mdot
.80221 .75036 Mdot
.5 Mabswid
.769 .997 .823 r
.75461 .8027 m .738 .82716 L .71428 .84252 L p F P
0 g
s
.738 .971 .712 r
.738 .82716 m .75461 .8027 L .77736 .78196 L p F P
0 g
s
.01 w
.754 .81216 Mdot
.69744 .85735 Mdot
.5 Mabswid
.889 .984 .71 r
.80521 .72712 m .79668 .75916 L .77736 .78196 L p F P
0 g
s
.87 .948 .59 r
.79668 .75916 m .80521 .72712 L .8218 .70017 L p F P
0 g
s
.373 0 0 r
.58279 .27118 m .52293 .26699 L .52317 .26155 L p F P
0 g
s
.01 w
.71453 .84564 Mdot
.75199 .81394 Mdot
.69886 .85628 Mdot
.84687 .61178 Mdot
.2053 .62334 Mdot
.70035 .85515 Mdot
.74994 .81571 Mdot
.8009 .75186 Mdot
.5 Mabswid
0 0 .357 r
.22474 .53684 m .20597 .57736 L .20507 .54798 L p F P
0 g
s
0 0 .357 r
.20507 .54798 m .22387 .50664 L .22474 .53684 L p F P
0 g
s
.01 w
.71422 .84555 Mdot
.7019 .85397 Mdot
.84654 .61217 Mdot
.74786 .81749 Mdot
.5 Mabswid
.22 .662 .953 r
.45176 .88986 m .47078 .89658 L .45455 .89859 L p F P
0 g
s
.22 .662 .953 r
.45455 .89859 m .42975 .88988 L .45176 .88986 L p F P
0 g
s
.01 w
.70351 .85274 Mdot
.84672 .60808 Mdot
.74576 .81927 Mdot
.5 Mabswid
.413 .85 .935 r
.56057 .90087 m .58173 .8961 L .59847 .89798 L p F P
0 g
s
.512 .897 .954 r
.62298 .88905 m .59847 .89798 L .58173 .8961 L p F P
0 g
s
.01 w
.71399 .84537 Mdot
.7995 .75342 Mdot
.70517 .85147 Mdot
.74365 .82105 Mdot
.20567 .62168 Mdot
.5 Mabswid
0 .047 .591 r
.23253 .66751 m .2293 .70308 L .21664 .67532 L p F P
0 g
s
0 .047 .591 r
.21664 .67532 m .2197 .63753 L .23253 .66751 L p F P
0 g
s
.01 w
.7069 .85015 Mdot
.74151 .82282 Mdot
.5 Mabswid
.99 .743 .372 r
.82467 .50331 m .84484 .54453 L .84393 .57397 L p F P
0 g
s
.951 .66 .216 r
.84484 .54453 m .82467 .50331 L .82184 .47459 L p F P
0 g
s
.01 w
.70868 .84879 Mdot
.71386 .8451 Mdot
.73937 .82459 Mdot
.84616 .60979 Mdot
.7105 .84739 Mdot
.79804 .75502 Mdot
.73722 .82635 Mdot
.84646 .60446 Mdot
.71238 .84595 Mdot
.5 Mabswid
.057 0 .056 r
.32309 .35582 m .27605 .38856 L .28776 .36759 L p F P
0 g
s
.057 0 .056 r
.28776 .36759 m .33275 .33606 L .32309 .35582 L p F P
0 g
s
.01 w
.73507 .8281 Mdot
.7143 .84447 Mdot
.73291 .82983 Mdot
.71381 .84475 Mdot
.71625 .84295 Mdot
.73077 .83155 Mdot
.71825 .8414 Mdot
.72863 .83325 Mdot
.72027 .83983 Mdot
.72651 .83493 Mdot
.5 Mabswid
.977 .915 .6 r
.83019 .6344 m .83452 .67223 L .8218 .70017 L p F P
0 g
s
.968 .873 .481 r
.83452 .67223 m .83019 .6344 L .83905 .60406 L p F P
0 g
s
.01 w
.72233 .83822 Mdot
.72441 .83659 Mdot
.20615 .62012 Mdot
.7965 .75667 Mdot
.5 Mabswid
.161 .552 .929 r
.39308 .86546 m .40893 .8787 L .38395 .87259 L p F P
0 g
s
.161 .552 .929 r
.38395 .87259 m .36436 .85641 L .39308 .86546 L p F P
0 g
s
.01 w
.71385 .84433 Mdot
.5 Mabswid
0 0 .231 r
.26135 .43902 m .22673 .47794 L .23318 .45108 L p F P
0 g
s
0 0 .231 r
.23318 .45108 m .26717 .41245 L .26135 .43902 L p F P
0 g
s
.833 .364 .07 r
.71382 .33375 m .75986 .36477 L .77141 .38564 L p F P
0 g
s
.735 .211 0 r
.75986 .36477 m .71382 .33375 L .70231 .31763 L p F P
0 g
s
.259 0 0 r
.45802 .28188 m .39746 .29667 L .40723 .28566 L p F P
0 g
s
.259 0 0 r
.40723 .28566 m .46321 .27193 L .45802 .28188 L p F P
0 g
s
.01 w
.84608 .60092 Mdot
.84566 .60752 Mdot
.5 Mabswid
.549 .929 .899 r
.62298 .88905 m .64341 .87768 L .66876 .87135 L p F P
0 g
s
.675 .966 .93 r
.68779 .85498 m .66876 .87135 L .64341 .87768 L p F P
0 g
s
.642 .967 .853 r
.66876 .87135 m .68779 .85498 L .71428 .84252 L p F P
0 g
s
.621 .055 0 r
.70231 .31763 m .64862 .29511 L .63923 .28422 L p F P
0 g
s
.593 .048 0 r
.58279 .27118 m .63923 .28422 L .64862 .29511 L p F P
0 g
s
.01 w
.71397 .84382 Mdot
.79489 .75837 Mdot
.5 Mabswid
.026 .299 .791 r
.28989 .7787 m .29722 .8048 L .27462 .78429 L p F P
0 g
s
.026 .299 .791 r
.27462 .78429 m .2661 .75515 L .28989 .7787 L p F P
0 g
s
.01 w
.20674 .61868 Mdot
.5 Mabswid
.942 .576 .245 r
.78017 .40946 m .81545 .44776 L .82184 .47459 L p F P
0 g
s
.889 .47 .073 r
.81545 .44776 m .78017 .40946 L .77141 .38564 L p F P
0 g
s
.01 w
.71418 .84323 Mdot
.84559 .59746 Mdot
.5 Mabswid
.124 .467 .892 r
.35174 .83829 m .36436 .85641 L .33813 .8442 L p F P
0 g
s
.124 .467 .892 r
.33813 .8442 m .32302 .8229 L .35174 .83829 L p F P
0 g
s
.01 w
.79322 .7601 Mdot
.5 Mabswid
.19 0 .006 r
.38901 .31159 m .33275 .33606 L .34453 .31982 L p F P
0 g
s
.19 0 .006 r
.34453 .31982 m .39746 .29667 L .38901 .31159 L p F P
0 g
s
.01 w
.84506 .60536 Mdot
.5 Mabswid
.261 .65 .965 r
.4359 .88127 m .45176 .88986 L .42975 .88988 L p F P
0 g
s
.261 .65 .965 r
.42975 .88988 m .40893 .8787 L .4359 .88127 L p F P
0 g
s
.884 .99 .795 r
.78489 .75269 m .77736 .78196 L .75461 .8027 L p F P
0 g
s
.889 .984 .71 r
.77736 .78196 m .78489 .75269 L .80521 .72712 L p F P
0 g
s
.01 w
.71448 .84256 Mdot
.5 Mabswid
.512 .897 .954 r
.58173 .8961 m .6005 .88922 L .62298 .88905 L p F P
0 g
s
.606 .928 .966 r
.64341 .87768 m .62298 .88905 L .6005 .88922 L p F P
0 g
s
.772 .989 .894 r
.72865 .82106 m .71428 .84252 L .68779 .85498 L p F P
0 g
s
.769 .997 .823 r
.71428 .84252 m .72865 .82106 L .75461 .8027 L p F P
0 g
s
.735 .228 .016 r
.64862 .29511 m .70231 .31763 L .71382 .33375 L p F P
0 g
s
.01 w
.79148 .76188 Mdot
.71487 .84181 Mdot
.84499 .59409 Mdot
.20743 .61735 Mdot
.5 Mabswid
.004 0 .482 r
.22943 .56817 m .21084 .60734 L .20597 .57736 L p F P
0 g
s
.004 0 .482 r
.20597 .57736 m .22474 .53684 L .22943 .56817 L p F P
0 g
s
.01 w
.84434 .60332 Mdot
.78969 .7637 Mdot
.5 Mabswid
.403 .783 .992 r
.50264 .89376 m .51815 .89533 L .5148 .90345 L p F P
0 g
s
.403 .783 .992 r
.5148 .90345 m .49209 .90117 L .50264 .89376 L p F P
0 g
s
.431 .811 .991 r
.53795 .90335 m .5148 .90345 L .51815 .89533 L p F P
0 g
s
.01 w
.71534 .841 Mdot
.5 Mabswid
.431 .811 .991 r
.51815 .89533 m .53397 .89526 L .53795 .90335 L p F P
0 g
s
.473 .839 .992 r
.56057 .90087 m .53795 .90335 L .53397 .89526 L p F P
0 g
s
.034 .179 .684 r
.24923 .69686 m .24583 .72982 L .2293 .70308 L p F P
0 g
s
.034 .179 .684 r
.2293 .70308 m .23253 .66751 L .24923 .69686 L p F P
0 g
s
.01 w
.7159 .8401 Mdot
.78785 .76555 Mdot
.84427 .5908 Mdot
.84427 .59081 Mdot
.20824 .61615 Mdot
.5 Mabswid
.391 .758 .992 r
.48812 .89061 m .50264 .89376 L .49209 .90117 L p F P
0 g
s
.391 .758 .992 r
.49209 .90117 m .47078 .89658 L .48812 .89061 L p F P
0 g
s
.999 .795 .491 r
.82379 .53359 m .84393 .57397 L .83905 .60406 L p F P
0 g
s
.99 .743 .372 r
.84393 .57397 m .82379 .53359 L .82467 .50331 L p F P
0 g
s
.01 w
.71654 .83914 Mdot
.5 Mabswid
.473 .839 .992 r
.53397 .89526 m .54941 .89356 L .56057 .90087 L p F P
0 g
s
.524 .865 .993 r
.58173 .8961 m .56057 .90087 L .54941 .89356 L p F P
0 g
s
.01 w
.84351 .60139 Mdot
.78596 .76743 Mdot
.5 Mabswid
.414 0 0 r
.52271 .27655 m .45802 .28188 L .46321 .27193 L p F P
0 g
s
.414 0 0 r
.46321 .27193 m .52293 .26699 L .52271 .27655 L p F P
0 g
s
.593 .048 0 r
.64862 .29511 m .58756 .28107 L .58279 .27118 L p F P
0 g
s
.522 0 0 r
.52293 .26699 m .58279 .27118 L .58756 .28107 L p F P
0 g
s
.967 .933 .688 r
.81736 .66457 m .8218 .70017 L .80521 .72712 L p F P
0 g
s
.977 .915 .6 r
.8218 .70017 m .81736 .66457 L .83019 .6344 L p F P
0 g
s
.01 w
.71726 .83811 Mdot
.78403 .76934 Mdot
.84343 .58762 Mdot
.71806 .83701 Mdot
.71806 .83701 Mdot
.20915 .61506 Mdot
.78206 .77129 Mdot
.84258 .59957 Mdot
.71895 .83584 Mdot
.5 Mabswid
.155 .409 .852 r
.31694 .80009 m .32302 .8229 L .29722 .8048 L p F P
0 g
s
.155 .409 .852 r
.29722 .8048 m .28989 .7787 L .31694 .80009 L p F P
0 g
s
.522 0 0 r
.58756 .28107 m .52271 .27655 L .52293 .26699 L p F P
0 g
s
.01 w
.78005 .77325 Mdot
.5 Mabswid
.394 .736 .992 r
.47523 .88602 m .48812 .89061 L .47078 .89658 L p F P
0 g
s
.394 .736 .992 r
.47078 .89658 m .45176 .88986 L .47523 .88602 L p F P
0 g
s
.01 w
.84248 .58453 Mdot
.71992 .83461 Mdot
.5 Mabswid
.106 0 .367 r
.25876 .46798 m .22387 .50664 L .22673 .47794 L p F P
0 g
s
.106 0 .367 r
.22673 .47794 m .26135 .43902 L .25876 .46798 L p F P
0 g
s
.177 0 .224 r
.31575 .37896 m .26717 .41245 L .27605 .38856 L p F P
0 g
s
.177 0 .224 r
.27605 .38856 m .32309 .35582 L .31575 .37896 L p F P
0 g
s
.524 .865 .993 r
.54941 .89356 m .56382 .89029 L .58173 .8961 L p F P
0 g
s
.579 .885 .991 r
.6005 .88922 m .58173 .8961 L .56382 .89029 L p F P
0 g
s
.01 w
.77801 .77524 Mdot
.72096 .83331 Mdot
.21016 .61409 Mdot
.5 Mabswid
.315 .642 .967 r
.42395 .87114 m .4359 .88127 L .40893 .8787 L p F P
0 g
s
.315 .642 .967 r
.40893 .8787 m .39308 .86546 L .42395 .87114 L p F P
0 g
s
.863 .979 .853 r
.76104 .7765 m .75461 .8027 L .72865 .82106 L p F P
0 g
s
.884 .99 .795 r
.75461 .8027 m .76104 .7765 L .78489 .75269 L p F P
0 g
s
.01 w
.84154 .59788 Mdot
.72208 .83196 Mdot
.5 Mabswid
.606 .928 .966 r
.6005 .88922 m .61605 .88049 L .64341 .87768 L p F P
0 g
s
.681 .936 .966 r
.65879 .8643 m .64341 .87768 L .61605 .88049 L p F P
0 g
s
.675 .966 .93 r
.64341 .87768 m .65879 .8643 L .68779 .85498 L p F P
0 g
s
.01 w
.77594 .77725 Mdot
.5 Mabswid
.262 .563 .935 r
.38304 .85071 m .39308 .86546 L .36436 .85641 L p F P
0 g
s
.262 .563 .935 r
.36436 .85641 m .35174 .83829 L .38304 .85071 L p F P
0 g
s
.88 .47 .235 r
.72326 .35341 m .77141 .38564 L .78017 .40946 L p F P
0 g
s
.833 .364 .07 r
.77141 .38564 m .72326 .35341 L .71382 .33375 L p F P
0 g
s
.962 .647 .376 r
.7859 .43601 m .82184 .47459 L .82467 .50331 L p F P
0 g
s
.942 .576 .245 r
.82184 .47459 m .7859 .43601 L .78017 .40946 L p F P
0 g
s
.01 w
.84141 .58155 Mdot
.72328 .83054 Mdot
.77385 .77928 Mdot
.5 Mabswid
.757 .962 .934 r
.69977 .83673 m .68779 .85498 L .65879 .8643 L p F P
0 g
s
.772 .989 .894 r
.68779 .85498 m .69977 .83673 L .72865 .82106 L p F P
0 g
s
.01 w
.72454 .82908 Mdot
.21128 .61324 Mdot
.77174 .78132 Mdot
.5 Mabswid
.107 .109 .577 r
.23795 .60018 m .2197 .63753 L .21084 .60734 L p F P
0 g
s
.107 .109 .577 r
.21084 .60734 m .22943 .56817 L .23795 .60018 L p F P
0 g
s
.01 w
.72588 .82755 Mdot
.5 Mabswid
.141 .287 .753 r
.26965 .72514 m .2661 .75515 L .24583 .72982 L p F P
0 g
s
.141 .287 .753 r
.24583 .72982 m .24923 .69686 L .26965 .72514 L p F P
0 g
s
.01 w
.84039 .59631 Mdot
.76962 .78338 Mdot
.72729 .82598 Mdot
.84023 .57868 Mdot
.76749 .78544 Mdot
.5 Mabswid
.381 0 .098 r
.45354 .29594 m .38901 .31159 L .39746 .29667 L p F P
0 g
s
.381 0 .098 r
.39746 .29667 m .45802 .28188 L .45354 .29594 L p F P
0 g
s
.01 w
.72876 .82436 Mdot
.76535 .78751 Mdot
.73029 .82269 Mdot
.5 Mabswid
.409 .717 .987 r
.46455 .88016 m .47523 .88602 L .45176 .88986 L p F P
0 g
s
.409 .717 .987 r
.45176 .88986 m .4359 .88127 L .46455 .88016 L p F P
0 g
s
.735 .228 .016 r
.71382 .33375 m .65673 .30994 L .64862 .29511 L p F P
0 g
s
.683 .203 .103 r
.58756 .28107 m .64862 .29511 L .65673 .30994 L p F P
0 g
s
.991 .827 .582 r
.81912 .56502 m .83905 .60406 L .83019 .6344 L p F P
0 g
s
.999 .795 .491 r
.83905 .60406 m .81912 .56502 L .82379 .53359 L p F P
0 g
s
.01 w
.21249 .61252 Mdot
.76321 .78958 Mdot
.5 Mabswid
.301 0 .182 r
.38208 .33037 m .32309 .35582 L .33275 .33606 L p F P
0 g
s
.301 0 .182 r
.33275 .33606 m .38901 .31159 L .38208 .33037 L p F P
0 g
s
.945 .937 .755 r
.80067 .69414 m .80521 .72712 L .78489 .75269 L p F P
0 g
s
.967 .933 .688 r
.80521 .72712 m .80067 .69414 L .81736 .66457 L p F P
0 g
s
.01 w
.73189 .82097 Mdot
.5 Mabswid
.579 .885 .991 r
.56382 .89029 m .57655 .88558 L .6005 .88922 L p F P
0 g
s
.63 .895 .986 r
.61605 .88049 m .6005 .88922 L .57655 .88558 L p F P
0 g
s
.01 w
.76107 .79165 Mdot
.83914 .59486 Mdot
.73354 .81921 Mdot
.75894 .79372 Mdot
.73525 .81742 Mdot
.83894 .57591 Mdot
.75682 .79579 Mdot
.73701 .81559 Mdot
.5 Mabswid
.795 .35 .19 r
.65673 .30994 m .71382 .33375 L .72326 .35341 L p F P
0 g
s
.01 w
.75471 .79785 Mdot
.73883 .81372 Mdot
.74068 .81182 Mdot
.75262 .7999 Mdot
.74259 .80989 Mdot
.75056 .80193 Mdot
.74453 .80793 Mdot
.74852 .80395 Mdot
.7465 .80595 Mdot
.5 Mabswid
.262 .498 .894 r
.34692 .81897 m .35174 .83829 L .32302 .8229 L p F P
0 g
s
.262 .498 .894 r
.32302 .8229 m .31694 .80009 L .34692 .81897 L p F P
0 g
s
.01 w
.2138 .61192 Mdot
.83778 .59354 Mdot
.83754 .57326 Mdot
.5 Mabswid
.834 .958 .893 r
.73393 .79817 m .72865 .82106 L .69977 .83673 L p F P
0 g
s
.863 .979 .853 r
.72865 .82106 m .73393 .79817 L .76104 .7765 L p F P
0 g
s
.01 w
.21521 .61144 Mdot
.5 Mabswid
.195 .068 .47 r
.25955 .49896 m .22474 .53684 L .22387 .50664 L p F P
0 g
s
.195 .068 .47 r
.22387 .50664 m .25876 .46798 L .25955 .49896 L p F P
0 g
s
.525 .799 .996 r
.51379 .88224 m .52169 .88304 L .51815 .89533 L p F P
0 g
s
.525 .799 .996 r
.51815 .89533 m .50264 .89376 L .51379 .88224 L p F P
0 g
s
.54 .814 .997 r
.53397 .89526 m .51815 .89533 L .52169 .88304 L p F P
0 g
s
.54 .814 .997 r
.52169 .88304 m .52976 .88301 L .53397 .89526 L p F P
0 g
s
.561 .828 .996 r
.54941 .89356 m .53397 .89526 L .52976 .88301 L p F P
0 g
s
.01 w
.83633 .59234 Mdot
.83602 .57072 Mdot
.5 Mabswid
.372 .635 .956 r
.41652 .8599 m .42395 .87114 L .39308 .86546 L p F P
0 g
s
.372 .635 .956 r
.39308 .86546 m .38304 .85071 L .41652 .8599 L p F P
0 g
s
.229 .377 .805 r
.29354 .75191 m .28989 .7787 L .2661 .75515 L p F P
0 g
s
.229 .377 .805 r
.2661 .75515 m .26965 .72514 L .29354 .75191 L p F P
0 g
s
.516 .784 .993 r
.5064 .88062 m .51379 .88224 L .50264 .89376 L p F P
0 g
s
.516 .784 .993 r
.50264 .89376 m .48812 .89061 L .5064 .88062 L p F P
0 g
s
.191 .21 .65 r
.25028 .63243 m .23253 .66751 L .2197 .63753 L p F P
0 g
s
.191 .21 .65 r
.2197 .63753 m .23795 .60018 L .25028 .63243 L p F P
0 g
s
.561 .828 .996 r
.52976 .88301 m .53764 .88213 L .54941 .89356 L p F P
0 g
s
.585 .839 .993 r
.56382 .89029 m .54941 .89356 L .53764 .88213 L p F P
0 g
s
.433 .702 .978 r
.45658 .87329 m .46455 .88016 L .4359 .88127 L p F P
0 g
s
.433 .702 .978 r
.4359 .88127 m .42395 .87114 L .45658 .87329 L p F P
0 g
s
.681 .936 .966 r
.61605 .88049 m .62764 .87025 L .65879 .8643 L p F P
0 g
s
.734 .925 .955 r
.6683 .84944 m .65879 .8643 L .62764 .87025 L p F P
0 g
s
.757 .962 .934 r
.65879 .8643 m .6683 .84944 L .69977 .83673 L p F P
0 g
s
.266 .025 .349 r
.31094 .40525 m .26135 .43902 L .26717 .41245 L p F P
0 g
s
.266 .025 .349 r
.26717 .41245 m .31575 .37896 L .31094 .40525 L p F P
0 g
s
.963 .694 .476 r
.78844 .46498 m .82467 .50331 L .82379 .53359 L p F P
0 g
s
.962 .647 .376 r
.82467 .50331 m .78844 .46498 L .7859 .43601 L p F P
0 g
s
.01 w
.21671 .61108 Mdot
.5 Mabswid
.63 .895 .986 r
.57655 .88558 m .58701 .87963 L .61605 .88049 L p F P
0 g
s
.673 .895 .977 r
.62764 .87025 m .61605 .88049 L .58701 .87963 L p F P
0 g
s
.511 .071 .139 r
.52251 .29029 m .45354 .29594 L .45802 .28188 L p F P
0 g
s
.511 .071 .139 r
.45802 .28188 m .52271 .27655 L .52251 .29029 L p F P
0 g
s
.683 .203 .103 r
.65673 .30994 m .59167 .29508 L .58756 .28107 L p F P
0 g
s
.608 .15 .14 r
.52271 .27655 m .58756 .28107 L .59167 .29508 L p F P
0 g
s
.01 w
.83478 .59127 Mdot
.8344 .56831 Mdot
.5 Mabswid
.916 .932 .805 r
.78028 .72267 m .78489 .75269 L .76104 .7765 L p F P
0 g
s
.945 .937 .755 r
.78489 .75269 m .78028 .72267 L .80067 .69414 L p F P
0 g
s
.9 .542 .356 r
.73043 .3765 m .78017 .40946 L .7859 .43601 L p F P
0 g
s
.88 .47 .235 r
.78017 .40946 m .73043 .3765 L .72326 .35341 L p F P
0 g
s
.974 .845 .653 r
.81062 .59718 m .83019 .6344 L .81736 .66457 L p F P
0 g
s
.991 .827 .582 r
.83019 .6344 m .81062 .59718 L .81912 .56502 L p F P
0 g
s
.513 .768 .989 r
.49988 .87826 m .5064 .88062 L .48812 .89061 L p F P
0 g
s
.513 .768 .989 r
.48812 .89061 m .47523 .88602 L .49988 .87826 L p F P
0 g
s
.585 .839 .993 r
.53764 .88213 m .54496 .88045 L .56382 .89029 L p F P
0 g
s
.61 .847 .988 r
.57655 .88558 m .56382 .89029 L .54496 .88045 L p F P
0 g
s
.01 w
.2183 .61085 Mdot
.83266 .56602 Mdot
.83313 .59033 Mdot
.5 Mabswid
.351 .57 .921 r
.37945 .83505 m .38304 .85071 L .35174 .83829 L p F P
0 g
s
.351 .57 .921 r
.35174 .83829 m .34692 .81897 L .37945 .83505 L p F P
0 g
s
.608 .15 .14 r
.59167 .29508 m .52251 .29029 L .52271 .27655 L p F P
0 g
s
.8 .931 .919 r
.70389 .81735 m .69977 .83673 L .6683 .84944 L p F P
0 g
s
.834 .958 .893 r
.69977 .83673 m .70389 .81735 L .73393 .79817 L p F P
0 g
s
.01 w
.21998 .61075 Mdot
.83082 .56385 Mdot
.83139 .58952 Mdot
.5 Mabswid
.516 .755 .983 r
.49451 .87527 m .49988 .87826 L .47523 .88602 L p F P
0 g
s
.516 .755 .983 r
.47523 .88602 m .46455 .88016 L .49451 .87527 L p F P
0 g
s
.61 .847 .988 r
.54496 .88045 m .5514 .87804 L .57655 .88558 L p F P
0 g
s
.635 .85 .982 r
.58701 .87963 m .57655 .88558 L .5514 .87804 L p F P
0 g
s
.305 .453 .845 r
.3206 .77677 m .31694 .80009 L .28989 .7787 L p F P
0 g
s
.305 .453 .845 r
.28989 .7787 m .29354 .75191 L .3206 .77677 L p F P
0 g
s
.379 .07 .311 r
.3768 .35289 m .31575 .37896 L .32309 .35582 L p F P
0 g
s
.379 .07 .311 r
.32309 .35582 m .38208 .33037 L .3768 .35289 L p F P
0 g
s
.459 .088 .247 r
.44984 .31408 m .38208 .33037 L .38901 .31159 L p F P
0 g
s
.459 .088 .247 r
.38901 .31159 m .45354 .29594 L .44984 .31408 L p F P
0 g
s
.01 w
.22174 .61076 Mdot
.5 Mabswid
.26 .294 .708 r
.2663 .66443 m .24923 .69686 L .23253 .66751 L p F P
0 g
s
.26 .294 .708 r
.23253 .66751 m .25028 .63243 L .2663 .66443 L p F P
0 g
s
.264 .164 .549 r
.26378 .53157 m .22943 .56817 L .22474 .53684 L p F P
0 g
s
.264 .164 .549 r
.22474 .53684 m .25955 .49896 L .26378 .53157 L p F P
0 g
s
.462 .689 .965 r
.45174 .86569 m .45658 .87329 L .42395 .87114 L p F P
0 g
s
.462 .689 .965 r
.42395 .87114 m .41652 .8599 L .45174 .86569 L p F P
0 g
s
.01 w
.82888 .56182 Mdot
.82955 .58884 Mdot
.5 Mabswid
.884 .921 .843 r
.75642 .74971 m .76104 .7765 L .73393 .79817 L p F P
0 g
s
.916 .932 .805 r
.76104 .7765 m .75642 .74971 L .78028 .72267 L p F P
0 g
s
.795 .35 .19 r
.72326 .35341 m .6634 .32866 L .65673 .30994 L p F P
0 g
s
.731 .311 .25 r
.59167 .29508 m .65673 .30994 L .6634 .32866 L p F P
0 g
s
.823 .434 .316 r
.6634 .32866 m .72326 .35341 L .73043 .3765 L p F P
0 g
s
.673 .895 .977 r
.58701 .87963 m .59473 .87268 L .62764 .87025 L p F P
0 g
s
.705 .885 .964 r
.63466 .85894 m .62764 .87025 L .59473 .87268 L p F P
0 g
s
.734 .925 .955 r
.62764 .87025 m .63466 .85894 L .6683 .84944 L p F P
0 g
s
.01 w
.22358 .61091 Mdot
.5 Mabswid
.952 .855 .708 r
.79836 .62962 m .81736 .66457 L .80067 .69414 L p F P
0 g
s
.974 .845 .653 r
.81736 .66457 m .79836 .62962 L .81062 .59718 L p F P
0 g
s
.955 .727 .553 r
.78765 .49603 m .82379 .53359 L .81912 .56502 L p F P
0 g
s
.963 .694 .476 r
.82379 .53359 m .78765 .49603 L .78844 .46498 L p F P
0 g
s
.01 w
.82683 .55991 Mdot
.82763 .5883 Mdot
.5 Mabswid
.524 .742 .975 r
.49055 .87178 m .49451 .87527 L .46455 .88016 L p F P
0 g
s
.524 .742 .975 r
.46455 .88016 m .45658 .87329 L .49055 .87178 L p F P
0 g
s
.427 .63 .939 r
.41407 .84804 m .41652 .8599 L .38304 .85071 L p F P
0 g
s
.427 .63 .939 r
.38304 .85071 m .37945 .83505 L .41407 .84804 L p F P
0 g
s
.635 .85 .982 r
.5514 .87804 m .55665 .875 L .58701 .87963 L p F P
0 g
s
.656 .849 .974 r
.59473 .87268 m .58701 .87963 L .55665 .875 L p F P
0 g
s
.332 .126 .444 r
.3088 .43442 m .25876 .46798 L .26135 .43902 L p F P
0 g
s
.332 .126 .444 r
.26135 .43902 m .31094 .40525 L .3088 .43442 L p F P
0 g
s
.764 .901 .937 r
.67132 .83374 m .6683 .84944 L .63466 .85894 L p F P
0 g
s
.8 .931 .919 r
.6683 .84944 m .67132 .83374 L .70389 .81735 L p F P
0 g
s
.01 w
.22551 .61117 Mdot
.24584 .69542 Mdot
.2443 .69145 Mdot
.24744 .69931 Mdot
.24283 .6874 Mdot
.24912 .70311 Mdot
.24144 .68327 Mdot
.25085 .70682 Mdot
.24013 .67906 Mdot
.25264 .71044 Mdot
.2389 .67479 Mdot
.82469 .55814 Mdot
.25448 .71397 Mdot
.23776 .67045 Mdot
.82563 .58789 Mdot
.25637 .7174 Mdot
.5 Mabswid
.369 .518 .875 r
.35046 .79932 m .34692 .81897 L .31694 .80009 L p F P
0 g
s
.369 .518 .875 r
.31694 .80009 m .3206 .77677 L .35046 .79932 L p F P
0 g
s
.01 w
.23671 .66604 Mdot
.25831 .72074 Mdot
.23576 .66158 Mdot
.5 Mabswid
.904 .594 .448 r
.73512 .40277 m .7859 .43601 L .78844 .46498 L p F P
0 g
s
.9 .542 .356 r
.7859 .43601 m .73512 .40277 L .73043 .3765 L p F P
0 g
s
.01 w
.26029 .72397 Mdot
.2349 .65705 Mdot
.2623 .7271 Mdot
.23414 .65247 Mdot
.2275 .61156 Mdot
.26435 .73013 Mdot
.5 Mabswid
.599 .789 .972 r
.52169 .88304 m .51379 .88224 L .52538 .86658 L closepath p F P
0 g
s
.604 .794 .972 r
.52976 .88301 m .52169 .88304 L .52538 .86658 L closepath p F P
0 g
s
.61 .798 .971 r
.53764 .88213 m .52976 .88301 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23348 .64785 Mdot
.5 Mabswid
.85 .906 .873 r
.72942 .77486 m .73393 .79817 L .70389 .81735 L p F P
0 g
s
.884 .921 .843 r
.73393 .79817 m .72942 .77486 L .75642 .74971 L p F P
0 g
s
.01 w
.26643 .73306 Mdot
.23293 .64318 Mdot
.82244 .5565 Mdot
.26854 .73587 Mdot
.5 Mabswid
.319 .366 .754 r
.28582 .6957 m .26965 .72514 L .24923 .69686 L p F P
0 g
s
.319 .366 .754 r
.24923 .69686 m .2663 .66443 L .28582 .6957 L p F P
0 g
s
.596 .784 .97 r
.51379 .88224 m .5064 .88062 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.82354 .5876 Mdot
.5 Mabswid
.616 .801 .97 r
.54496 .88045 m .53764 .88213 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23249 .63846 Mdot
.27067 .73858 Mdot
.23216 .63371 Mdot
.27282 .74117 Mdot
.22957 .61206 Mdot
.5 Mabswid
.57 .186 .274 r
.52235 .30819 m .44984 .31408 L .45354 .29594 L p F P
0 g
s
.57 .186 .274 r
.45354 .29594 m .52251 .29029 L .52235 .30819 L p F P
0 g
s
.535 .732 .965 r
.4882 .86795 m .49055 .87178 L .45658 .87329 L p F P
0 g
s
.535 .732 .965 r
.45658 .87329 m .45174 .86569 L .4882 .86795 L p F P
0 g
s
.594 .779 .969 r
.5064 .88062 m .49988 .87826 L .52538 .86658 L closepath p F P
0 g
s
.623 .803 .968 r
.5514 .87804 m .54496 .88045 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.27498 .74366 Mdot
.23195 .62893 Mdot
.5 Mabswid
.731 .311 .25 r
.6634 .32866 m .59506 .31319 L .59167 .29508 L p F P
0 g
s
.657 .257 .275 r
.52251 .29029 m .59167 .29508 L .59506 .31319 L p F P
0 g
s
.656 .849 .974 r
.55665 .875 m .56048 .87148 L .59473 .87268 L p F P
0 g
s
.674 .844 .964 r
.59929 .86505 m .59473 .87268 L .56048 .87148 L p F P
0 g
s
.705 .885 .964 r
.59473 .87268 m .59929 .86505 L .63466 .85894 L p F P
0 g
s
.32 .244 .612 r
.27148 .56534 m .23795 .60018 L .22943 .56817 L p F P
0 g
s
.32 .244 .612 r
.22943 .56817 m .26378 .53157 L .27148 .56534 L p F P
0 g
s
.927 .859 .753 r
.78243 .66184 m .80067 .69414 L .78028 .72267 L p F P
0 g
s
.952 .855 .708 r
.80067 .69414 m .78243 .66184 L .79836 .62962 L p F P
0 g
s
.492 .68 .949 r
.45029 .85772 m .45174 .86569 L .41652 .8599 L p F P
0 g
s
.492 .68 .949 r
.41652 .8599 m .41407 .84804 L .45029 .85772 L p F P
0 g
s
.01 w
.27715 .74603 Mdot
.23186 .62412 Mdot
.8201 .555 Mdot
.82137 .58746 Mdot
.27933 .74829 Mdot
.5 Mabswid
.726 .869 .948 r
.63667 .84705 m .63466 .85894 L .59929 .86505 L p F P
0 g
s
.764 .901 .937 r
.63466 .85894 m .63667 .84705 L .67132 .83374 L p F P
0 g
s
.01 w
.23189 .61929 Mdot
.5 Mabswid
.594 .774 .966 r
.49988 .87826 m .49451 .87527 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.28152 .75043 Mdot
.2317 .61269 Mdot
.5 Mabswid
.63 .803 .966 r
.55665 .875 m .5514 .87804 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23204 .61443 Mdot
.5 Mabswid
.426 .576 .899 r
.3827 .81919 m .37945 .83505 L .34692 .81897 L p F P
0 g
s
.426 .576 .899 r
.34692 .81897 m .35046 .79932 L .3827 .81919 L p F P
0 g
s
.01 w
.2837 .75246 Mdot
.5 Mabswid
.942 .749 .613 r
.78345 .52874 m .81912 .56502 L .81062 .59718 L p F P
0 g
s
.955 .727 .553 r
.81912 .56502 m .78345 .52874 L .78765 .49603 L p F P
0 g
s
.01 w
.23232 .60956 Mdot
.5 Mabswid
.657 .257 .275 r
.59506 .31319 m .52235 .30819 L .52251 .29029 L p F P
0 g
s
.01 w
.81767 .55364 Mdot
.28588 .75437 Mdot
.81913 .58744 Mdot
.5 Mabswid
.814 .889 .897 r
.69963 .79771 m .70389 .81735 L .67132 .83374 L p F P
0 g
s
.85 .906 .873 r
.70389 .81735 m .69963 .79771 L .72942 .77486 L p F P
0 g
s
.433 .165 .407 r
.37334 .37896 m .31094 .40525 L .31575 .37896 L p F P
0 g
s
.433 .165 .407 r
.31575 .37896 m .3768 .35289 L .37334 .37896 L p F P
0 g
s
.01 w
.23272 .60469 Mdot
.28805 .75616 Mdot
.2339 .61344 Mdot
.5 Mabswid
.595 .77 .963 r
.49451 .87527 m .49055 .87178 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23326 .5998 Mdot
.5 Mabswid
.636 .803 .963 r
.56048 .87148 m .55665 .875 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.29022 .75784 Mdot
.5 Mabswid
.369 .429 .792 r
.30859 .72574 m .29354 .75191 L .26965 .72514 L p F P
0 g
s
.369 .429 .792 r
.26965 .72514 m .28582 .6957 L .30859 .72574 L p F P
0 g
s
.835 .494 .41 r
.66846 .35114 m .73043 .3765 L .73512 .40277 L p F P
0 g
s
.823 .434 .316 r
.73043 .3765 m .66846 .35114 L .6634 .32866 L p F P
0 g
s
.01 w
.23393 .59492 Mdot
.5 Mabswid
.51 .186 .354 r
.44704 .3362 m .3768 .35289 L .38208 .33037 L p F P
0 g
s
.51 .186 .354 r
.38208 .33037 m .44984 .31408 L .44704 .3362 L p F P
0 g
s
.01 w
.29236 .7594 Mdot
.81516 .55242 Mdot
.81682 .58755 Mdot
.5 Mabswid
.55 .724 .955 r
.48758 .86394 m .4882 .86795 L .45174 .86569 L p F P
0 g
s
.55 .724 .955 r
.45174 .86569 m .45029 .85772 L .48758 .86394 L p F P
0 g
s
.382 .207 .516 r
.30944 .46608 m .25955 .49896 L .25876 .46798 L p F P
0 g
s
.382 .207 .516 r
.25876 .46798 m .3088 .43442 L .30944 .46608 L p F P
0 g
s
.01 w
.23616 .6143 Mdot
.23473 .59004 Mdot
.29449 .76083 Mdot
.5 Mabswid
.756 .388 .356 r
.59506 .31319 m .6634 .32866 L .66846 .35114 L p F P
0 g
s
.674 .844 .964 r
.56048 .87148 m .56269 .86762 L .59929 .86505 L p F P
0 g
s
.687 .835 .954 r
.60044 .85706 m .59929 .86505 L .56269 .86762 L p F P
0 g
s
.726 .869 .948 r
.59929 .86505 m .60044 .85706 L .63667 .84705 L p F P
0 g
s
.477 .627 .918 r
.41683 .83609 m .41407 .84804 L .37945 .83505 L p F P
0 g
s
.477 .627 .918 r
.37945 .83505 m .3827 .81919 L .41683 .83609 L p F P
0 g
s
.901 .859 .791 r
.76302 .69335 m .78028 .72267 L .75642 .74971 L p F P
0 g
s
.927 .859 .753 r
.78028 .72267 m .76302 .69335 L .78243 .66184 L p F P
0 g
s
.01 w
.2966 .76215 Mdot
.23567 .58518 Mdot
.5 Mabswid
.597 .766 .96 r
.49055 .87178 m .4882 .86795 L .52538 .86658 L closepath p F P
0 g
s
.642 .801 .96 r
.56269 .86762 m .56048 .87148 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.81444 .5878 Mdot
.81255 .55135 Mdot
.5 Mabswid
.777 .869 .916 r
.66748 .8179 m .67132 .83374 L .63667 .84705 L p F P
0 g
s
.814 .889 .897 r
.67132 .83374 m .66748 .8179 L .69963 .79771 L p F P
0 g
s
.01 w
.29869 .76335 Mdot
.5 Mabswid
.901 .631 .519 r
.7372 .43195 m .78844 .46498 L .78765 .49603 L p F P
0 g
s
.904 .594 .448 r
.78844 .46498 m .7372 .43195 L .73512 .40277 L p F P
0 g
s
.01 w
.23674 .58032 Mdot
.23847 .61528 Mdot
.30074 .76443 Mdot
.5 Mabswid
.366 .311 .663 r
.28259 .59976 m .25028 .63243 L .23795 .60018 L p F P
0 g
s
.366 .311 .663 r
.23795 .60018 m .27148 .56534 L .28259 .59976 L p F P
0 g
s
.01 w
.23796 .57549 Mdot
.30276 .76539 Mdot
.81199 .58818 Mdot
.80987 .55042 Mdot
.23931 .57069 Mdot
.24083 .61638 Mdot
.5 Mabswid
.523 .674 .933 r
.45235 .84974 m .45029 .85772 L .41407 .84804 L p F P
0 g
s
.523 .674 .933 r
.41407 .84804 m .41683 .83609 L .45235 .84974 L p F P
0 g
s
.01 w
.79476 .68105 Mdot
.79331 .68498 Mdot
.79613 .67705 Mdot
.79178 .68882 Mdot
.79742 .67296 Mdot
.5 Mabswid
.601 .763 .956 r
.4882 .86795 m .48758 .86394 L .52538 .86658 L closepath p F P
0 g
s
.412 .484 .824 r
.33428 .75408 m .3206 .77677 L .29354 .75191 L p F P
0 g
s
.412 .484 .824 r
.29354 .75191 m .30859 .72574 L .33428 .75408 L p F P
0 g
s
.01 w
.79018 .69257 Mdot
.79862 .66879 Mdot
.30475 .76623 Mdot
.78851 .69622 Mdot
.79973 .66455 Mdot
.5 Mabswid
.646 .799 .956 r
.56316 .86361 m .56269 .86762 L .52538 .86658 L closepath p F P
0 g
s
.687 .835 .954 r
.56269 .86762 m .56316 .86361 L .60044 .85706 L p F P
0 g
s
.01 w
.78678 .69978 Mdot
.80074 .66024 Mdot
.78499 .70325 Mdot
.5 Mabswid
.926 .766 .663 r
.77583 .56264 m .81062 .59718 L .79836 .62962 L p F P
0 g
s
.942 .749 .613 r
.81062 .59718 m .77583 .56264 L .78345 .52874 L p F P
0 g
s
.01 w
.80166 .65586 Mdot
.5 Mabswid
.737 .847 .932 r
.63346 .83511 m .63667 .84705 L .60044 .85706 L p F P
0 g
s
.777 .869 .916 r
.63667 .84705 m .63346 .83511 L .66748 .8179 L p F P
0 g
s
.01 w
.78314 .70661 Mdot
.24081 .56591 Mdot
.80247 .65142 Mdot
.78123 .70988 Mdot
.30671 .76695 Mdot
.80318 .64692 Mdot
.77928 .71304 Mdot
.80378 .64236 Mdot
.77728 .71609 Mdot
.5 Mabswid
.873 .856 .822 r
.7404 .72365 m .75642 .74971 L .72942 .77486 L p F P
0 g
s
.901 .859 .791 r
.75642 .74971 m .7404 .72365 L .76302 .69335 L p F P
0 g
s
.01 w
.80949 .58869 Mdot
.24324 .61758 Mdot
.80427 .63775 Mdot
.77524 .71904 Mdot
.30862 .76755 Mdot
.24244 .56118 Mdot
.8071 .54963 Mdot
.5 Mabswid
.565 .718 .944 r
.48872 .85995 m .48758 .86394 L .45029 .85772 L p F P
0 g
s
.565 .718 .944 r
.45029 .85772 m .45235 .84974 L .48872 .85995 L p F P
0 g
s
.01 w
.80464 .63309 Mdot
.77317 .72188 Mdot
.8049 .62839 Mdot
.5 Mabswid
.695 .823 .944 r
.59808 .84909 m .60044 .85706 L .56316 .86361 L p F P
0 g
s
.737 .847 .932 r
.60044 .85706 m .59808 .84909 L .63346 .83511 L p F P
0 g
s
.01 w
.77106 .7246 Mdot
.31048 .76804 Mdot
.24422 .55648 Mdot
.80503 .62364 Mdot
.76892 .72722 Mdot
.5 Mabswid
.652 .787 .946 r
.55424 .85251 m .55885 .85586 L .52538 .86658 L closepath p F P
0 g
s
.611 .758 .949 r
.48872 .85995 m .4916 .85616 L .52538 .86658 L closepath p F P
0 g
s
.606 .76 .953 r
.48758 .86394 m .48872 .85995 L .52538 .86658 L closepath p F P
0 g
s
.65 .795 .952 r
.56187 .85963 m .56316 .86361 L .52538 .86658 L closepath p F P
0 g
s
.652 .791 .949 r
.55885 .85586 m .56187 .85963 L .52538 .86658 L closepath p F P
0 g
s
.652 .782 .943 r
.54824 .84971 m .55424 .85251 L .52538 .86658 L closepath p F P
0 g
s
.65 .777 .941 r
.54114 .84762 m .54824 .84971 L .52538 .86658 L closepath p F P
0 g
s
.647 .772 .94 r
.53328 .84634 m .54114 .84762 L .52538 .86658 L closepath p F P
0 g
s
.644 .768 .939 r
.52503 .84593 m .53328 .84634 L .52538 .86658 L closepath p F P
0 g
s
.639 .765 .939 r
.5168 .84641 m .52503 .84593 L .52538 .86658 L closepath p F P
0 g
s
.634 .762 .94 r
.50899 .84776 m .5168 .84641 L .52538 .86658 L closepath p F P
0 g
s
.628 .759 .941 r
.50197 .84992 m .50899 .84776 L .52538 .86658 L closepath p F P
0 g
s
.622 .758 .943 r
.49608 .85276 m .50197 .84992 L .52538 .86658 L closepath p F P
0 g
s
.617 .758 .946 r
.4916 .85616 m .49608 .85276 L .52538 .86658 L closepath p F P
0 g
s
.695 .823 .944 r
.56316 .86361 m .56187 .85963 L .59808 .84909 L p F P
0 g
s
.01 w
.2457 .6189 Mdot
.76676 .72972 Mdot
.80504 .61887 Mdot
.3123 .7684 Mdot
.80693 .58932 Mdot
.76457 .7321 Mdot
.80493 .61406 Mdot
.24614 .55183 Mdot
.80426 .54898 Mdot
.5 Mabswid
.452 .535 .852 r
.36251 .78027 m .35046 .79932 L .3206 .77677 L p F P
0 g
s
.452 .535 .852 r
.3206 .77677 m .33428 .75408 L .36251 .78027 L p F P
0 g
s
.01 w
.76237 .73437 Mdot
.5 Mabswid
.607 .269 .372 r
.52223 .33016 m .44704 .3362 L .44984 .31408 L p F P
0 g
s
.607 .269 .372 r
.44984 .31408 m .52235 .30819 L .52223 .33016 L p F P
0 g
s
.01 w
.31407 .76865 Mdot
.80469 .60923 Mdot
.5 Mabswid
.756 .388 .356 r
.66846 .35114 m .59763 .33528 L .59506 .31319 L p F P
0 g
s
.686 .334 .373 r
.52235 .30819 m .59506 .31319 L .59763 .33528 L p F P
0 g
s
.01 w
.76016 .73652 Mdot
.80431 .60437 Mdot
.2482 .54724 Mdot
.24819 .62032 Mdot
.5 Mabswid
.473 .24 .479 r
.3718 .40828 m .3088 .43442 L .31094 .40525 L p F P
0 g
s
.473 .24 .479 r
.31094 .40525 m .37334 .37896 L .3718 .40828 L p F P
0 g
s
.404 .368 .705 r
.29699 .63431 m .2663 .66443 L .25028 .63243 L p F P
0 g
s
.404 .368 .705 r
.25028 .63243 m .28259 .59976 L .29699 .63431 L p F P
0 g
s
.01 w
.31579 .76878 Mdot
.5 Mabswid
.843 .851 .85 r
.71488 .75228 m .72942 .77486 L .69963 .79771 L p F P
0 g
s
.873 .856 .822 r
.72942 .77486 m .71488 .75228 L .7404 .72365 L p F P
0 g
s
.421 .274 .574 r
.31294 .49983 m .26378 .53157 L .25955 .49896 L p F P
0 g
s
.421 .274 .574 r
.25955 .49896 m .30944 .46608 L .31294 .49983 L p F P
0 g
s
.01 w
.75793 .73855 Mdot
.80431 .59008 Mdot
.8038 .5995 Mdot
.7557 .74047 Mdot
.80135 .54849 Mdot
.5 Mabswid
.582 .715 .934 r
.4916 .85616 m .48872 .85995 L .45235 .84974 L p F P
0 g
s
.01 w
.25041 .5427 Mdot
.31745 .76879 Mdot
.80316 .59462 Mdot
.5 Mabswid
.699 .81 .934 r
.56187 .85963 m .55885 .85586 L .59224 .84152 L p F P
0 g
s
.699 .81 .934 r
.59224 .84152 m .59808 .84909 L .56187 .85963 L p F P
0 g
s
.01 w
.75347 .74226 Mdot
.5 Mabswid
.839 .539 .482 r
.67178 .37719 m .73512 .40277 L .7372 .43195 L p F P
0 g
s
.835 .494 .41 r
.73512 .40277 m .67178 .37719 L .66846 .35114 L p F P
0 g
s
.01 w
.25072 .62185 Mdot
.5 Mabswid
.487 .583 .876 r
.39285 .80391 m .3827 .81919 L .35046 .79932 L p F P
0 g
s
.487 .583 .876 r
.35046 .79932 m .36251 .78027 L .39285 .80391 L p F P
0 g
s
.01 w
.80238 .58973 Mdot
.31905 .76869 Mdot
.5 Mabswid
.908 .778 .705 r
.76485 .59724 m .79836 .62962 L .78243 .66184 L p F P
0 g
s
.926 .766 .663 r
.79836 .62962 m .76485 .59724 L .77583 .56264 L p F P
0 g
s
.894 .659 .576 r
.73655 .46367 m .78765 .49603 L .78345 .52874 L p F P
0 g
s
.901 .631 .519 r
.78765 .49603 m .73655 .46367 L .7372 .43195 L p F P
0 g
s
.01 w
.75124 .74393 Mdot
.25276 .53823 Mdot
.80165 .59097 Mdot
.80146 .58484 Mdot
.5 Mabswid
.686 .334 .373 r
.59763 .33528 m .52223 .33016 L .52235 .30819 L p F P
0 g
s
.01 w
.74901 .74548 Mdot
.5 Mabswid
.812 .844 .874 r
.68685 .77876 m .69963 .79771 L .66748 .8179 L p F P
0 g
s
.843 .851 .85 r
.69963 .79771 m .68685 .77876 L .71488 .75228 L p F P
0 g
s
.01 w
.32059 .76847 Mdot
.79838 .54813 Mdot
.5 Mabswid
.582 .715 .934 r
.45235 .84974 m .4579 .84212 L .4916 .85616 L p F P
0 g
s
.552 .672 .917 r
.4579 .84212 m .45235 .84974 L .41683 .83609 L p F P
0 g
s
.01 w
.8004 .57995 Mdot
.5 Mabswid
.546 .261 .434 r
.44519 .3621 m .37334 .37896 L .3768 .35289 L p F P
0 g
s
.546 .261 .434 r
.3768 .35289 m .44704 .3362 L .44519 .3621 L p F P
0 g
s
.01 w
.25328 .62349 Mdot
.5 Mabswid
.521 .628 .898 r
.42481 .82462 m .41683 .83609 L .3827 .81919 L p F P
0 g
s
.521 .628 .898 r
.3827 .81919 m .39285 .80391 L .42481 .82462 L p F P
0 g
s
.01 w
.25525 .53382 Mdot
.74679 .74691 Mdot
.5 Mabswid
.741 .824 .916 r
.59808 .84909 m .59224 .84152 L .62505 .82372 L p F P
0 g
s
.741 .824 .916 r
.62505 .82372 m .63346 .83511 L .59808 .84909 L p F P
0 g
s
.552 .672 .917 r
.41683 .83609 m .42481 .82462 L .4579 .84212 L p F P
0 g
s
.01 w
.32207 .76814 Mdot
.5 Mabswid
.598 .714 .925 r
.49608 .85276 m .4916 .85616 L .4579 .84212 L p F P
0 g
s
.01 w
.79919 .57508 Mdot
.74459 .74821 Mdot
.79895 .59198 Mdot
.5 Mabswid
.699 .795 .925 r
.55885 .85586 m .55424 .85251 L .58316 .83472 L p F P
0 g
s
.699 .795 .925 r
.58316 .83472 m .59224 .84152 L .55885 .85586 L p F P
0 g
s
.769 .444 .436 r
.59763 .33528 m .66846 .35114 L .67178 .37719 L p F P
0 g
s
.778 .835 .896 r
.65675 .8027 m .66748 .8179 L .63346 .83511 L p F P
0 g
s
.812 .844 .874 r
.66748 .8179 m .65675 .8027 L .68685 .77876 L p F P
0 g
s
.778 .835 .896 r
.63346 .83511 m .62505 .82372 L .65675 .8027 L p F P
0 g
s
.01 w
.25788 .52949 Mdot
.79784 .57021 Mdot
.32348 .76769 Mdot
.7424 .7494 Mdot
.25586 .62522 Mdot
.79534 .54793 Mdot
.74024 .75046 Mdot
.79635 .56537 Mdot
.32483 .76714 Mdot
.26065 .52524 Mdot
.5 Mabswid
.437 .42 .742 r
.3145 .66843 m .28582 .6957 L .2663 .66443 L p F P
0 g
s
.437 .42 .742 r
.2663 .66443 m .29699 .63431 L .3145 .66843 L p F P
0 g
s
.01 w
.79621 .59312 Mdot
.73809 .75139 Mdot
.79471 .56055 Mdot
.25846 .62704 Mdot
.5 Mabswid
.615 .716 .918 r
.50197 .84992 m .49608 .85276 L .46671 .83525 L p F P
0 g
s
.598 .714 .925 r
.4579 .84212 m .46671 .83525 L .49608 .85276 L p F P
0 g
s
.01 w
.3261 .76647 Mdot
.5 Mabswid
.696 .781 .917 r
.55424 .85251 m .54824 .84971 L .57125 .82905 L p F P
0 g
s
.696 .781 .917 r
.57125 .82905 m .58316 .83472 L .55424 .85251 L p F P
0 g
s
.01 w
.73598 .75221 Mdot
.26356 .52107 Mdot
.79224 .54787 Mdot
.79292 .55576 Mdot
.3273 .7657 Mdot
.5 Mabswid
.889 .786 .741 r
.75061 .63198 m .78243 .66184 L .76302 .69335 L p F P
0 g
s
.908 .778 .705 r
.78243 .66184 m .75061 .63198 L .76485 .59724 L p F P
0 g
s
.01 w
.79343 .59437 Mdot
.73389 .7529 Mdot
.26109 .62897 Mdot
.79099 .55101 Mdot
.2666 .517 Mdot
.32843 .76481 Mdot
.73184 .75347 Mdot
.5 Mabswid
.453 .33 .622 r
.31931 .53515 m .27148 .56534 L .26378 .53157 L p F P
0 g
s
.453 .33 .622 r
.26378 .53157 m .31294 .49983 L .31931 .53515 L p F P
0 g
s
.63 .72 .912 r
.50899 .84776 m .50197 .84992 L .47841 .82947 L p F P
0 g
s
.615 .716 .918 r
.46671 .83525 m .47841 .82947 L .50197 .84992 L p F P
0 g
s
.579 .673 .903 r
.46671 .83525 m .4579 .84212 L .42481 .82462 L p F P
0 g
s
.69 .768 .911 r
.54824 .84971 m .54114 .84762 L .55705 .82478 L p F P
0 g
s
.69 .768 .911 r
.55705 .82478 m .57125 .82905 L .54824 .84971 L p F P
0 g
s
.01 w
.7889 .5463 Mdot
.78909 .54795 Mdot
.5 Mabswid
.738 .8 .902 r
.59224 .84152 m .58316 .83472 L .61172 .81344 L p F P
0 g
s
.738 .8 .902 r
.61172 .81344 m .62505 .82372 L .59224 .84152 L p F P
0 g
s
.01 w
.26372 .63098 Mdot
.32948 .76383 Mdot
.72983 .75391 Mdot
.79063 .59574 Mdot
.26979 .51301 Mdot
.78667 .54163 Mdot
.72785 .75423 Mdot
.33045 .76273 Mdot
.5 Mabswid
.466 .467 .774 r
.33486 .70158 m .30859 .72574 L .28582 .6957 L p F P
0 g
s
.466 .467 .774 r
.28582 .6957 m .3145 .66843 L .33486 .70158 L p F P
0 g
s
.645 .726 .907 r
.5168 .84641 m .50899 .84776 L .49244 .82508 L p F P
0 g
s
.63 .72 .912 r
.47841 .82947 m .49244 .82508 L .50899 .84776 L p F P
0 g
s
.884 .681 .623 r
.73311 .49749 m .78345 .52874 L .77583 .56264 L p F P
0 g
s
.894 .659 .576 r
.78345 .52874 m .73311 .49749 L .73655 .46367 L p F P
0 g
s
.681 .755 .907 r
.54114 .84762 m .53328 .84634 L .54126 .82216 L p F P
0 g
s
.681 .755 .907 r
.54126 .82216 m .55705 .82478 L .54114 .84762 L p F P
0 g
s
.01 w
.26636 .63308 Mdot
.5 Mabswid
.502 .3 .537 r
.37226 .44048 m .30944 .46608 L .3088 .43442 L p F P
0 g
s
.502 .3 .537 r
.3088 .43442 m .3718 .40828 L .37226 .44048 L p F P
0 g
s
.01 w
.2731 .50913 Mdot
.78429 .53702 Mdot
.72592 .75444 Mdot
.78589 .54818 Mdot
.33134 .76154 Mdot
.33134 .76154 Mdot
.7878 .59723 Mdot
.5 Mabswid
.658 .734 .905 r
.52503 .84593 m .5168 .84641 L .50812 .82231 L p F P
0 g
s
.645 .726 .907 r
.49244 .82508 m .50812 .82231 L .5168 .84641 L p F P
0 g
s
.671 .744 .905 r
.53328 .84634 m .52503 .84593 L .52467 .82132 L p F P
0 g
s
.671 .744 .905 r
.52467 .82132 m .54126 .82216 L .53328 .84634 L p F P
0 g
s
.658 .734 .905 r
.50812 .82231 m .52467 .82132 L .52503 .84593 L p F P
0 g
s
.01 w
.72404 .75452 Mdot
.78177 .53247 Mdot
.5 Mabswid
.869 .793 .773 r
.73331 .66633 m .76302 .69335 L .7404 .72365 L p F P
0 g
s
.889 .786 .741 r
.76302 .69335 m .73331 .66633 L .75061 .63198 L p F P
0 g
s
.01 w
.26901 .63526 Mdot
.33214 .76024 Mdot
.27655 .50536 Mdot
.5 Mabswid
.838 .573 .538 r
.67324 .40652 m .7372 .43195 L .73655 .46367 L p F P
0 g
s
.839 .539 .482 r
.7372 .43195 m .67324 .40652 L .67178 .37719 L p F P
0 g
s
.579 .673 .903 r
.42481 .82462 m .43774 .81423 L .46671 .83525 L p F P
0 g
s
.559 .632 .88 r
.43774 .81423 m .42481 .82462 L .39285 .80391 L p F P
0 g
s
.01 w
.7222 .75448 Mdot
.5 Mabswid
.631 .333 .446 r
.52214 .35601 m .44519 .3621 L .44704 .3362 L p F P
0 g
s
.631 .333 .446 r
.44704 .3362 m .52223 .33016 L .52214 .35601 L p F P
0 g
s
.01 w
.78495 .59882 Mdot
.7791 .52798 Mdot
.33286 .75884 Mdot
.78264 .54856 Mdot
.5 Mabswid
.771 .802 .879 r
.62505 .82372 m .61172 .81344 L .63944 .78891 L p F P
0 g
s
.771 .802 .879 r
.63944 .78891 m .65675 .8027 L .62505 .82372 L p F P
0 g
s
.01 w
.27165 .63752 Mdot
.5 Mabswid
.769 .444 .436 r
.67178 .37719 m .59931 .36118 L .59763 .33528 L p F P
0 g
s
.703 .391 .447 r
.52223 .33016 m .59763 .33528 L .59931 .36118 L p F P
0 g
s
.492 .51 .804 r
.35775 .73322 m .33428 .75408 L .30859 .72574 L p F P
0 g
s
.492 .51 .804 r
.30859 .72574 m .33486 .70158 L .35775 .73322 L p F P
0 g
s
.01 w
.72042 .75432 Mdot
.28013 .50169 Mdot
.33349 .75734 Mdot
.77628 .52356 Mdot
.5 Mabswid
.605 .676 .891 r
.47841 .82947 m .46671 .83525 L .43774 .81423 L p F P
0 g
s
.01 w
.7187 .75404 Mdot
.78208 .60053 Mdot
.27429 .63986 Mdot
.5 Mabswid
.73 .777 .891 r
.58316 .83472 m .57125 .82905 L .59405 .80481 L p F P
0 g
s
.73 .777 .891 r
.59405 .80481 m .61172 .81344 L .58316 .83472 L p F P
0 g
s
.01 w
.33404 .75575 Mdot
.5 Mabswid
.559 .632 .88 r
.39285 .80391 m .40962 .78998 L .43774 .81423 L p F P
0 g
s
.538 .592 .856 r
.40962 .78998 m .39285 .80391 L .36251 .78027 L p F P
0 g
s
.01 w
.28384 .49814 Mdot
.77935 .54907 Mdot
.77331 .51921 Mdot
.5 Mabswid
.848 .798 .802 r
.71321 .69972 m .7404 .72365 L .71488 .75228 L p F P
0 g
s
.869 .793 .773 r
.7404 .72365 m .71321 .69972 L .73331 .66633 L p F P
0 g
s
.01 w
.71703 .75365 Mdot
.5 Mabswid
.516 .551 .831 r
.38281 .76284 m .36251 .78027 L .33428 .75408 L p F P
0 g
s
.516 .551 .831 r
.33428 .75408 m .35775 .73322 L .38281 .76284 L p F P
0 g
s
.01 w
.3345 .75407 Mdot
.5 Mabswid
.571 .32 .497 r
.44436 .39151 m .3718 .40828 L .37334 .37896 L p F P
0 g
s
.571 .32 .497 r
.37334 .37896 m .44519 .3621 L .44436 .39151 L p F P
0 g
s
.01 w
.27691 .64227 Mdot
.5 Mabswid
.799 .802 .854 r
.65675 .8027 m .63944 .78891 L .66589 .7615 L p F P
0 g
s
.799 .802 .854 r
.66589 .7615 m .68685 .77876 L .65675 .8027 L p F P
0 g
s
.538 .592 .856 r
.36251 .78027 m .38281 .76284 L .40962 .78998 L p F P
0 g
s
.479 .378 .663 r
.32848 .5715 m .28259 .59976 L .27148 .56534 L p F P
0 g
s
.479 .378 .663 r
.27148 .56534 m .31931 .53515 L .32848 .5715 L p F P
0 g
s
.01 w
.7792 .60235 Mdot
.7702 .51494 Mdot
.71543 .75313 Mdot
.5 Mabswid
.703 .391 .447 r
.59931 .36118 m .52214 .35601 L .52223 .33016 L p F P
0 g
s
.01 w
.33487 .7523 Mdot
.28766 .49471 Mdot
.5 Mabswid
.776 .487 .498 r
.59931 .36118 m .67178 .37719 L .67324 .40652 L p F P
0 g
s
.825 .801 .829 r
.69061 .73162 m .71488 .75228 L .68685 .77876 L p F P
0 g
s
.848 .798 .802 r
.71488 .75228 m .69061 .73162 L .71321 .69972 L p F P
0 g
s
.01 w
.27953 .64476 Mdot
.77603 .54973 Mdot
.5 Mabswid
.825 .801 .829 r
.68685 .77876 m .66589 .7615 L .69061 .73162 L p F P
0 g
s
.01 w
.71389 .75251 Mdot
.33514 .75044 Mdot
.76695 .51076 Mdot
.77632 .60426 Mdot
.29162 .4914 Mdot
.5 Mabswid
.873 .699 .663 r
.72687 .53293 m .77583 .56264 L .76485 .59724 L p F P
0 g
s
.884 .681 .623 r
.77583 .56264 m .72687 .53293 L .73311 .49749 L p F P
0 g
s
.01 w
.76398 .66317 Mdot
.76267 .66701 Mdot
.7652 .65924 Mdot
.28212 .6473 Mdot
.76127 .67076 Mdot
.76633 .65523 Mdot
.33533 .74849 Mdot
.75978 .67441 Mdot
.71242 .75177 Mdot
.76735 .65114 Mdot
.75821 .67798 Mdot
.76826 .64697 Mdot
.75656 .68144 Mdot
.76907 .64273 Mdot
.75484 .6848 Mdot
.76356 .50667 Mdot
.76977 .63841 Mdot
.75305 .68806 Mdot
.77035 .63404 Mdot
.75119 .69121 Mdot
.33542 .74647 Mdot
.5 Mabswid
.629 .683 .882 r
.49244 .82508 m .47841 .82947 L .45507 .80545 L p F P
0 g
s
.605 .676 .891 r
.43774 .81423 m .45507 .80545 L .47841 .82947 L p F P
0 g
s
.01 w
.77268 .55053 Mdot
.77081 .62959 Mdot
.71102 .75091 Mdot
.28469 .64991 Mdot
.74927 .69425 Mdot
.77115 .6251 Mdot
.5 Mabswid
.719 .756 .882 r
.57125 .82905 m .55705 .82478 L .57286 .79831 L p F P
0 g
s
.719 .756 .882 r
.57286 .79831 m .59405 .80481 L .57125 .82905 L p F P
0 g
s
.01 w
.77343 .60628 Mdot
.74729 .69719 Mdot
.29568 .48822 Mdot
.77137 .62054 Mdot
.74526 .70001 Mdot
.76003 .50267 Mdot
.33543 .74436 Mdot
.77145 .61594 Mdot
.74318 .70272 Mdot
.70969 .74995 Mdot
.28724 .65257 Mdot
.77141 .61129 Mdot
.74106 .70531 Mdot
.33533 .74217 Mdot
.77123 .6066 Mdot
.73889 .70779 Mdot
.77055 .60839 Mdot
.75636 .49878 Mdot
.29987 .48518 Mdot
.70843 .74887 Mdot
.70843 .74888 Mdot
.77092 .60188 Mdot
.5 Mabswid
.526 .349 .585 r
.37477 .47512 m .31294 .49983 L .30944 .46608 L p F P
0 g
s
.526 .349 .585 r
.30944 .46608 m .37226 .44048 L .37477 .47512 L p F P
0 g
s
.01 w
.7693 .55147 Mdot
.5 Mabswid
.594 .639 .865 r
.45507 .80545 m .43774 .81423 L .40962 .78998 L p F P
0 g
s
.01 w
.28975 .65528 Mdot
.73669 .71014 Mdot
.33515 .73992 Mdot
.77047 .59712 Mdot
.73445 .71238 Mdot
.5 Mabswid
.758 .772 .864 r
.61172 .81344 m .59405 .80481 L .61627 .7773 L p F P
0 g
s
.758 .772 .864 r
.61627 .7773 m .63944 .78891 L .61172 .81344 L p F P
0 g
s
.01 w
.76988 .59234 Mdot
.33487 .73759 Mdot
.29223 .65805 Mdot
.70725 .74768 Mdot
.73218 .7145 Mdot
.75256 .49499 Mdot
.76914 .58753 Mdot
.76767 .6106 Mdot
.30416 .48227 Mdot
.72989 .71649 Mdot
.33449 .73519 Mdot
.5 Mabswid
.501 .422 .698 r
.34034 .60831 m .29699 .63431 L .28259 .59976 L p F P
0 g
s
.501 .422 .698 r
.28259 .59976 m .32848 .5715 L .34034 .60831 L p F P
0 g
s
.834 .601 .585 r
.67278 .43875 m .73655 .46367 L .73311 .49749 L p F P
0 g
s
.838 .573 .538 r
.73655 .46367 m .67278 .43875 L .67324 .40652 L p F P
0 g
s
.01 w
.29466 .66085 Mdot
.5 Mabswid
.65 .693 .876 r
.50812 .82231 m .49244 .82508 L .47599 .79876 L p F P
0 g
s
.629 .683 .882 r
.45507 .80545 m .47599 .79876 L .49244 .82508 L p F P
0 g
s
.01 w
.76826 .58271 Mdot
.70616 .74639 Mdot
.72758 .71836 Mdot
.7659 .55254 Mdot
.5 Mabswid
.705 .737 .876 r
.55705 .82478 m .54126 .82216 L .54921 .7943 L p F P
0 g
s
.705 .737 .876 r
.54921 .7943 m .57286 .79831 L .55705 .82478 L p F P
0 g
s
.01 w
.33403 .73272 Mdot
.76724 .57787 Mdot
.74863 .49131 Mdot
.29706 .6637 Mdot
.72526 .7201 Mdot
.70514 .74499 Mdot
.7648 .61289 Mdot
.33346 .7302 Mdot
.76606 .57303 Mdot
.30856 .4795 Mdot
.72292 .72172 Mdot
.29941 .66658 Mdot
.33281 .72762 Mdot
.76473 .56819 Mdot
.5 Mabswid
.861 .714 .698 r
.71788 .56943 m .76485 .59724 L .75061 .63198 L p F P
0 g
s
.873 .699 .663 r
.76485 .59724 m .71788 .56943 L .72687 .53293 L p F P
0 g
s
.01 w
.72057 .72322 Mdot
.74456 .48775 Mdot
.70421 .74349 Mdot
.30171 .6695 Mdot
.33206 .72498 Mdot
.76248 .55375 Mdot
.76325 .56335 Mdot
.5 Mabswid
.67 .705 .873 r
.52467 .82132 m .50812 .82231 L .49948 .79453 L p F P
0 g
s
.65 .693 .876 r
.47599 .79876 m .49948 .79453 L .50812 .82231 L p F P
0 g
s
.01 w
.76195 .61527 Mdot
.71822 .72458 Mdot
.5 Mabswid
.689 .72 .873 r
.54126 .82216 m .52467 .82132 L .52432 .79302 L p F P
0 g
s
.689 .72 .873 r
.52432 .79302 m .54921 .7943 L .54126 .82216 L p F P
0 g
s
.01 w
.30395 .67244 Mdot
.33121 .72229 Mdot
.31307 .47687 Mdot
.70336 .74189 Mdot
.76162 .55853 Mdot
.30614 .6754 Mdot
.33028 .71955 Mdot
.71586 .72582 Mdot
.74037 .48431 Mdot
.5 Mabswid
.67 .705 .873 r
.49948 .79453 m .52432 .79302 L .52467 .82132 L p F P
0 g
s
.01 w
.32925 .71677 Mdot
.30827 .67838 Mdot
.75984 .55371 Mdot
.5 Mabswid
.647 .382 .504 r
.5221 .38546 m .44436 .39151 L .44519 .3621 L p F P
0 g
s
.647 .382 .504 r
.44519 .3621 m .52214 .35601 L .5221 .38546 L p F P
0 g
s
.01 w
.75912 .61773 Mdot
.71351 .72694 Mdot
.7026 .74019 Mdot
.5 Mabswid
.594 .639 .865 r
.40962 .78998 m .43233 .77816 L .45507 .80545 L p F P
0 g
s
.581 .603 .84 r
.43233 .77816 m .40962 .78998 L .38281 .76284 L p F P
0 g
s
.01 w
.32813 .71395 Mdot
.31034 .68137 Mdot
.75906 .55509 Mdot
.32693 .71109 Mdot
.31233 .68437 Mdot
.7579 .54892 Mdot
.32563 .7082 Mdot
.5 Mabswid
.776 .487 .498 r
.67324 .40652 m .60006 .3906 L .59931 .36118 L p F P
0 g
s
.714 .436 .504 r
.52214 .35601 m .59931 .36118 L .60006 .3906 L p F P
0 g
s
.01 w
.31767 .4744 Mdot
.31426 .68738 Mdot
.71117 .72792 Mdot
.32425 .70528 Mdot
.73606 .481 Mdot
.31612 .69039 Mdot
.32279 .70233 Mdot
.31791 .69339 Mdot
.70193 .7384 Mdot
.32124 .69937 Mdot
.31961 .69638 Mdot
.5 Mabswid
.781 .765 .838 r
.63944 .78891 m .61627 .7773 L .63755 .74691 L p F P
0 g
s
.781 .765 .838 r
.63755 .74691 m .66589 .7615 L .63944 .78891 L p F P
0 g
s
.01 w
.7558 .54415 Mdot
.5 Mabswid
.521 .461 .73 r
.35474 .64496 m .3145 .66843 L .29699 .63431 L p F P
0 g
s
.521 .461 .73 r
.29699 .63431 m .34034 .60831 L .35474 .64496 L p F P
0 g
s
.01 w
.75632 .62027 Mdot
.70884 .72878 Mdot
.5 Mabswid
.589 .367 .547 r
.4446 .42406 m .37226 .44048 L .3718 .40828 L p F P
0 g
s
.589 .367 .547 r
.3718 .40828 m .44436 .39151 L .4446 .42406 L p F P
0 g
s
.01 w
.70134 .73651 Mdot
.75355 .53942 Mdot
.70653 .72951 Mdot
.73163 .47781 Mdot
.5 Mabswid
.624 .649 .854 r
.47599 .79876 m .45507 .80545 L .43233 .77816 L p F P
0 g
s
.01 w
.32236 .47207 Mdot
.32236 .47207 Mdot
.75562 .55656 Mdot
.75355 .62289 Mdot
.5 Mabswid
.779 .522 .548 r
.60006 .3906 m .67324 .40652 L .67278 .43875 L p F P
0 g
s
.01 w
.75114 .53472 Mdot
.70085 .73453 Mdot
.5 Mabswid
.741 .744 .854 r
.59405 .80481 m .57286 .79831 L .58832 .76852 L p F P
0 g
s
.741 .744 .854 r
.58832 .76852 m .61627 .7773 L .59405 .80481 L p F P
0 g
s
.01 w
.70423 .73011 Mdot
.5 Mabswid
.848 .726 .729 r
.70626 .6064 m .75061 .63198 L .73331 .66633 L p F P
0 g
s
.861 .714 .698 r
.75061 .63198 m .70626 .6064 L .71788 .56943 L p F P
0 g
s
.01 w
.74858 .53007 Mdot
.72709 .47476 Mdot
.70046 .73246 Mdot
.70196 .73058 Mdot
.75081 .62557 Mdot
.32715 .4699 Mdot
.5 Mabswid
.545 .392 .625 r
.37934 .51167 m .31931 .53515 L .31294 .49983 L p F P
0 g
s
.545 .392 .625 r
.31294 .49983 m .37477 .47512 L .37934 .51167 L p F P
0 g
s
.581 .603 .84 r
.38281 .76284 m .41056 .74799 L .43233 .77816 L p F P
0 g
s
.568 .568 .813 r
.41056 .74799 m .38281 .76284 L .35775 .73322 L p F P
0 g
s
.01 w
.75219 .55815 Mdot
.5 Mabswid
.714 .436 .504 r
.60006 .3906 m .5221 .38546 L .52214 .35601 L p F P
0 g
s
.01 w
.74586 .52546 Mdot
.69971 .73093 Mdot
.70015 .73031 Mdot
.7481 .62831 Mdot
.5 Mabswid
.538 .498 .759 r
.37143 .68085 m .33486 .70158 L .3145 .66843 L p F P
0 g
s
.538 .498 .759 r
.3145 .66843 m .35474 .64496 L .37143 .68085 L p F P
0 g
s
.01 w
.72243 .47185 Mdot
.74299 .52091 Mdot
.6975 .73114 Mdot
.5 Mabswid
.801 .757 .812 r
.66589 .7615 m .63755 .74691 L .65751 .71408 L p F P
0 g
s
.801 .757 .812 r
.65751 .71408 m .69061 .73162 L .66589 .7615 L p F P
0 g
s
.01 w
.69995 .72807 Mdot
.33202 .46788 Mdot
.5 Mabswid
.829 .624 .625 r
.67034 .47345 m .73311 .49749 L .72687 .53293 L p F P
0 g
s
.834 .601 .585 r
.73311 .49749 m .67034 .47345 L .67278 .43875 L p F P
0 g
s
.01 w
.73997 .51642 Mdot
.74544 .63112 Mdot
.74876 .55987 Mdot
.69532 .73123 Mdot
.69983 .72576 Mdot
.5 Mabswid
.568 .568 .813 r
.35775 .73322 m .39015 .71538 L .41056 .74799 L p F P
0 g
s
.554 .534 .787 r
.39015 .71538 m .35775 .73322 L .33486 .70158 L p F P
0 g
s
.01 w
.71767 .46908 Mdot
.5 Mabswid
.554 .534 .787 r
.33486 .70158 m .37143 .68085 L .39015 .71538 L p F P
0 g
s
.834 .738 .758 r
.69216 .64324 m .73331 .66633 L .71321 .69972 L p F P
0 g
s
.848 .726 .729 r
.73331 .66633 m .69216 .64324 L .70626 .6064 L p F P
0 g
s
.01 w
.73679 .512 Mdot
.69982 .72336 Mdot
.74283 .63398 Mdot
.69317 .7312 Mdot
.33697 .46603 Mdot
.73346 .50765 Mdot
.6999 .72089 Mdot
.5 Mabswid
.818 .748 .786 r
.69061 .73162 m .65751 .71408 L .67582 .67933 L p F P
0 g
s
.818 .748 .786 r
.67582 .67933 m .71321 .69972 L .69061 .73162 L p F P
0 g
s
.01 w
.7128 .46646 Mdot
.69107 .73104 Mdot
.74026 .63689 Mdot
.74534 .56171 Mdot
.5 Mabswid
.834 .738 .758 r
.71321 .69972 m .67582 .67933 L .69216 .64324 L p F P
0 g
s
.01 w
.70008 .71835 Mdot
.5 Mabswid
.652 .662 .847 r
.49948 .79453 m .47599 .79876 L .45992 .76913 L p F P
0 g
s
.624 .649 .854 r
.43233 .77816 m .45992 .76913 L .47599 .79876 L p F P
0 g
s
.01 w
.72998 .50337 Mdot
.68901 .73075 Mdot
.73775 .63985 Mdot
.5 Mabswid
.722 .719 .847 r
.57286 .79831 m .54921 .7943 L .557 .7631 L p F P
0 g
s
.722 .719 .847 r
.557 .7631 m .58832 .76852 L .57286 .79831 L p F P
0 g
s
.01 w
.34199 .46434 Mdot
.70036 .71575 Mdot
.70784 .46399 Mdot
.72635 .49918 Mdot
.73529 .64286 Mdot
.687 .73034 Mdot
.70074 .71307 Mdot
.74193 .56367 Mdot
.7329 .6459 Mdot
.72258 .49508 Mdot
.70122 .71034 Mdot
.68504 .72981 Mdot
.34708 .46281 Mdot
.70279 .46167 Mdot
.7018 .70755 Mdot
.73057 .64897 Mdot
.5 Mabswid
.619 .617 .827 r
.45992 .76913 m .43233 .77816 L .41056 .74799 L p F P
0 g
s
.01 w
.71866 .49107 Mdot
.68314 .72915 Mdot
.70248 .70471 Mdot
.73854 .56574 Mdot
.7283 .65207 Mdot
.5 Mabswid
.759 .731 .826 r
.61627 .7773 m .58832 .76852 L .60316 .73583 L p F P
0 g
s
.759 .731 .826 r
.60316 .73583 m .63755 .74691 L .61627 .7773 L p F P
0 g
s
.01 w
.70326 .70182 Mdot
.72611 .65519 Mdot
.69765 .45951 Mdot
.7146 .48716 Mdot
.70413 .69888 Mdot
.6813 .72837 Mdot
.35224 .46145 Mdot
.72399 .65834 Mdot
.5 Mabswid
.678 .678 .843 r
.52432 .79302 m .49948 .79453 L .49102 .76341 L p F P
0 g
s
.652 .662 .847 r
.45992 .76913 m .49102 .76341 L .49948 .79453 L p F P
0 g
s
.56 .43 .66 r
.38593 .54956 m .32848 .5715 L .31931 .53515 L p F P
0 g
s
.56 .43 .66 r
.31931 .53515 m .37934 .51167 L .38593 .54956 L p F P
0 g
s
.01 w
.7051 .69589 Mdot
.5 Mabswid
.701 .697 .843 r
.54921 .7943 m .52432 .79302 L .52397 .76136 L p F P
0 g
s
.701 .697 .843 r
.52397 .76136 m .557 .7631 L .54921 .7943 L p F P
0 g
s
.01 w
.72195 .6615 Mdot
.70618 .69287 Mdot
.7104 .48335 Mdot
.71998 .66466 Mdot
.73517 .56792 Mdot
.67951 .72748 Mdot
.67951 .72748 Mdot
.70734 .68982 Mdot
.71809 .66784 Mdot
.5 Mabswid
.604 .408 .589 r
.44594 .45928 m .37477 .47512 L .37226 .44048 L p F P
0 g
s
.604 .408 .589 r
.37226 .44048 m .4446 .42406 L .44594 .45928 L p F P
0 g
s
.01 w
.7086 .68673 Mdot
.71629 .67101 Mdot
.69242 .4575 Mdot
.70996 .68362 Mdot
.71458 .67418 Mdot
.71141 .68049 Mdot
.71295 .67734 Mdot
.5 Mabswid
.659 .423 .551 r
.5221 .41813 m .4446 .42406 L .44436 .39151 L p F P
0 g
s
.659 .423 .551 r
.44436 .39151 m .5221 .38546 L .5221 .41813 L p F P
0 g
s
.01 w
.70607 .47966 Mdot
.5 Mabswid
.678 .678 .843 r
.49102 .76341 m .52397 .76136 L .52432 .79302 L p F P
0 g
s
.01 w
.35745 .46025 Mdot
.67779 .72646 Mdot
.5 Mabswid
.823 .643 .66 r
.66593 .51009 m .72687 .53293 L .71788 .56943 L p F P
0 g
s
.829 .624 .625 r
.72687 .53293 m .66593 .51009 L .67034 .47345 L p F P
0 g
s
.779 .522 .548 r
.67278 .43875 m .59982 .42316 L .60006 .3906 L p F P
0 g
s
.72 .473 .551 r
.5221 .38546 m .60006 .3906 L .59982 .42316 L p F P
0 g
s
.779 .55 .589 r
.59982 .42316 m .67278 .43875 L .67034 .47345 L p F P
0 g
s
.01 w
.73184 .57021 Mdot
.7016 .47608 Mdot
.68712 .45566 Mdot
.68712 .45566 Mdot
.67615 .72532 Mdot
.36271 .45923 Mdot
.69701 .47262 Mdot
.67457 .72407 Mdot
.68175 .45399 Mdot
.72853 .5726 Mdot
.69229 .46928 Mdot
.67306 .72271 Mdot
.36802 .45838 Mdot
.68745 .46608 Mdot
.67163 .72123 Mdot
.67631 .45248 Mdot
.72526 .57508 Mdot
.5 Mabswid
.619 .617 .827 r
.41056 .74799 m .4445 .7366 L .45992 .76913 L p F P
0 g
s
.612 .587 .801 r
.4445 .7366 m .41056 .74799 L .39015 .71538 L p F P
0 g
s
.72 .473 .551 r
.59982 .42316 m .5221 .41813 L .5221 .38546 L p F P
0 g
s
.01 w
.68249 .463 Mdot
.67029 .71964 Mdot
.37337 .4577 Mdot
.5 Mabswid
.774 .718 .8 r
.63755 .74691 m .60316 .73583 L .61713 .70073 L p F P
0 g
s
.774 .718 .8 r
.61713 .70073 m .65751 .71408 L .63755 .74691 L p F P
0 g
s
.574 .464 .691 r
.39443 .58815 m .34034 .60831 L .32848 .5715 L p F P
0 g
s
.574 .464 .691 r
.32848 .5715 m .38593 .54956 L .39443 .58815 L p F P
0 g
s
.01 w
.67081 .45114 Mdot
.72204 .57766 Mdot
.67742 .46007 Mdot
.66902 .71795 Mdot
.5 Mabswid
.652 .634 .819 r
.49102 .76341 m .45992 .76913 L .4445 .7366 L p F P
0 g
s
.735 .702 .819 r
.58832 .76852 m .557 .7631 L .56449 .72898 L p F P
0 g
s
.735 .702 .819 r
.56449 .72898 m .60316 .73583 L .58832 .76852 L p F P
0 g
s
.01 w
.67224 .45728 Mdot
.66783 .71615 Mdot
.37875 .45719 Mdot
.66526 .44997 Mdot
.71886 .58034 Mdot
.5 Mabswid
.815 .661 .691 r
.65958 .54808 m .71788 .56943 L .70626 .6064 L p F P
0 g
s
.823 .643 .66 r
.71788 .56943 m .65958 .54808 L .66593 .51009 L p F P
0 g
s
.01 w
.66674 .71424 Mdot
.66696 .45464 Mdot
.65966 .44897 Mdot
.71574 .58309 Mdot
.38416 .45686 Mdot
.66573 .71224 Mdot
.66159 .45215 Mdot
.5 Mabswid
.612 .587 .801 r
.39015 .71538 m .42999 .70165 L .4445 .7366 L p F P
0 g
s
.604 .557 .775 r
.42999 .70165 m .39015 .71538 L .37143 .68085 L p F P
0 g
s
.01 w
.66481 .71013 Mdot
.65612 .44981 Mdot
.71266 .58593 Mdot
.65402 .44815 Mdot
.5 Mabswid
.585 .496 .72 r
.40473 .6268 m .35474 .64496 L .34034 .60831 L p F P
0 g
s
.585 .496 .72 r
.34034 .60831 m .39443 .58815 L .40473 .6268 L p F P
0 g
s
.01 w
.38959 .4567 Mdot
.5 Mabswid
.615 .442 .625 r
.44837 .49663 m .37934 .51167 L .37477 .47512 L p F P
0 g
s
.615 .442 .625 r
.37477 .47512 m .44594 .45928 L .44837 .49663 L p F P
0 g
s
.01 w
.66399 .70793 Mdot
.65056 .44763 Mdot
.5 Mabswid
.787 .705 .774 r
.65751 .71408 m .61713 .70073 L .62997 .66378 L p F P
0 g
s
.787 .705 .774 r
.62997 .66378 m .67582 .67933 L .65751 .71408 L p F P
0 g
s
.01 w
.70965 .58884 Mdot
.64835 .4475 Mdot
.66326 .70564 Mdot
.64492 .44561 Mdot
.5 Mabswid
.777 .575 .625 r
.59857 .45841 m .67034 .47345 L .66593 .51009 L p F P
0 g
s
.779 .55 .589 r
.67034 .47345 m .59857 .45841 L .59982 .42316 L p F P
0 g
s
.682 .653 .815 r
.52397 .76136 m .49102 .76341 L .48288 .72937 L p F P
0 g
s
.652 .634 .819 r
.4445 .7366 m .48288 .72937 L .49102 .76341 L p F P
0 g
s
.01 w
.39503 .45671 Mdot
.5 Mabswid
.807 .676 .72 r
.65138 .5868 m .70626 .6064 L .69216 .64324 L p F P
0 g
s
.815 .661 .691 r
.70626 .6064 m .65138 .5868 L .65958 .54808 L p F P
0 g
s
.604 .557 .775 r
.37143 .68085 m .41665 .66485 L .42999 .70165 L p F P
0 g
s
.595 .527 .748 r
.41665 .66485 m .37143 .68085 L .35474 .64496 L p F P
0 g
s
.01 w
.66263 .70326 Mdot
.5 Mabswid
.71 .676 .815 r
.557 .7631 m .52397 .76136 L .52364 .72678 L p F P
0 g
s
.71 .676 .815 r
.52364 .72678 m .56449 .72898 L .557 .7631 L p F P
0 g
s
.01 w
.7067 .59183 Mdot
.5 Mabswid
.595 .527 .748 r
.35474 .64496 m .40473 .6268 L .41665 .66485 L p F P
0 g
s
.01 w
.63921 .44376 Mdot
.64264 .44702 Mdot
.6621 .70078 Mdot
.5 Mabswid
.668 .457 .591 r
.52215 .45356 m .44594 .45928 L .4446 .42406 L p F P
0 g
s
.668 .457 .591 r
.4446 .42406 m .5221 .41813 L .52215 .45356 L p F P
0 g
s
.01 w
.70382 .59488 Mdot
.63342 .44207 Mdot
.40049 .4569 Mdot
.5 Mabswid
.797 .691 .747 r
.67582 .67933 m .62997 .66378 L .64145 .62559 L p F P
0 g
s
.797 .691 .747 r
.64145 .62559 m .69216 .64324 L .67582 .67933 L p F P
0 g
s
.01 w
.66167 .69823 Mdot
.5 Mabswid
.724 .504 .591 r
.5221 .41813 m .59982 .42316 L .59857 .45841 L p F P
0 g
s
.682 .653 .815 r
.48288 .72937 m .52364 .72678 L .52397 .76136 L p F P
0 g
s
.01 w
.63692 .44673 Mdot
.5 Mabswid
.807 .676 .72 r
.69216 .64324 m .64145 .62559 L .65138 .5868 L p F P
0 g
s
.01 w
.62758 .44055 Mdot
.70101 .59799 Mdot
.66135 .69559 Mdot
.40594 .45726 Mdot
.62167 .4392 Mdot
.66112 .69287 Mdot
.69827 .60116 Mdot
.63118 .44661 Mdot
.5 Mabswid
.65 .607 .793 r
.48288 .72937 m .4445 .7366 L .42999 .70165 L p F P
0 g
s
.01 w
.661 .69008 Mdot
.61572 .43803 Mdot
.69561 .60438 Mdot
.5 Mabswid
.746 .685 .792 r
.60316 .73583 m .56449 .72898 L .57155 .69245 L p F P
0 g
s
.746 .685 .792 r
.57155 .69245 m .61713 .70073 L .60316 .73583 L p F P
0 g
s
.01 w
.66099 .68722 Mdot
.41139 .45779 Mdot
.62543 .44666 Mdot
.60972 .43702 Mdot
.69303 .60764 Mdot
.66109 .68428 Mdot
.69054 .61095 Mdot
.66129 .68129 Mdot
.61967 .44689 Mdot
.5 Mabswid
.724 .504 .591 r
.59857 .45841 m .52215 .45356 L .5221 .41813 L p F P
0 g
s
.01 w
.41683 .45849 Mdot
.68813 .6143 Mdot
.6616 .67823 Mdot
.66203 .67512 Mdot
.68582 .61767 Mdot
.61393 .4473 Mdot
.5 Mabswid
.624 .474 .657 r
.45186 .53552 m .38593 .54956 L .37934 .51167 L p F P
0 g
s
.624 .474 .657 r
.37934 .51167 m .44837 .49663 L .45186 .53552 L p F P
0 g
s
.01 w
.66256 .67195 Mdot
.68359 .62108 Mdot
.42225 .45936 Mdot
.6632 .66873 Mdot
.68146 .6245 Mdot
.66396 .66547 Mdot
.67943 .62794 Mdot
.66482 .66217 Mdot
.60819 .44788 Mdot
.6775 .6314 Mdot
.6658 .65884 Mdot
.5 Mabswid
.775 .596 .657 r
.59632 .49581 m .66593 .51009 L .65958 .54808 L p F P
0 g
s
.777 .575 .625 r
.66593 .51009 m .59632 .49581 L .59857 .45841 L p F P
0 g
s
.01 w
.67566 .63485 Mdot
.66688 .65547 Mdot
.67394 .63831 Mdot
.66808 .65207 Mdot
.67231 .64177 Mdot
.66938 .64865 Mdot
.42765 .46039 Mdot
.67079 .64522 Mdot
.60247 .44863 Mdot
.43302 .46159 Mdot
.59677 .44956 Mdot
.5 Mabswid
.65 .607 .793 r
.42999 .70165 m .47522 .69293 L .48288 .72937 L p F P
0 g
s
.647 .581 .767 r
.47522 .69293 m .42999 .70165 L .41665 .66485 L p F P
0 g
s
.684 .63 .789 r
.52364 .72678 m .48288 .72937 L .47522 .69293 L p F P
0 g
s
.716 .656 .788 r
.56449 .72898 m .52364 .72678 L .52332 .68979 L p F P
0 g
s
.716 .656 .788 r
.52332 .68979 m .57155 .69245 L .56449 .72898 L p F P
0 g
s
.01 w
.43835 .46296 Mdot
.59111 .45065 Mdot
.5 Mabswid
.754 .668 .766 r
.61713 .70073 m .57155 .69245 L .57805 .65411 L p F P
0 g
s
.754 .668 .766 r
.57805 .65411 m .62997 .66378 L .61713 .70073 L p F P
0 g
s
.674 .487 .625 r
.52224 .4912 m .44837 .49663 L .44594 .45928 L p F P
0 g
s
.674 .487 .625 r
.44594 .45928 m .52215 .45356 L .52224 .4912 L p F P
0 g
s
.727 .53 .625 r
.52215 .45356 m .59857 .45841 L .59632 .49581 L p F P
0 g
s
.01 w
.58548 .45191 Mdot
.44364 .46448 Mdot
.5 Mabswid
.632 .502 .687 r
.45638 .57527 m .39443 .58815 L .38593 .54956 L p F P
0 g
s
.632 .502 .687 r
.38593 .54956 m .45186 .53552 L .45638 .57527 L p F P
0 g
s
.684 .63 .789 r
.47522 .69293 m .52332 .68979 L .52364 .72678 L p F P
0 g
s
.01 w
.57989 .45333 Mdot
.44888 .46616 Mdot
.5 Mabswid
.771 .616 .686 r
.59309 .53475 m .65958 .54808 L .65138 .5868 L p F P
0 g
s
.775 .596 .657 r
.65958 .54808 m .59309 .53475 L .59632 .49581 L p F P
0 g
s
.01 w
.57436 .45492 Mdot
.45407 .46799 Mdot
.5 Mabswid
.647 .581 .767 r
.41665 .66485 m .46816 .65466 L .47522 .69293 L p F P
0 g
s
.643 .555 .741 r
.46816 .65466 m .41665 .66485 L .40473 .6268 L p F P
0 g
s
.01 w
.56888 .45667 Mdot
.4592 .46997 Mdot
.5 Mabswid
.761 .651 .74 r
.62997 .66378 m .57805 .65411 L .58388 .61459 L p F P
0 g
s
.761 .651 .74 r
.58388 .61459 m .64145 .62559 L .62997 .66378 L p F P
0 g
s
.01 w
.56346 .45857 Mdot
.5 Mabswid
.638 .529 .714 r
.46185 .61522 m .40473 .6268 L .39443 .58815 L p F P
0 g
s
.638 .529 .714 r
.39443 .58815 m .45638 .57527 L .46185 .61522 L p F P
0 g
s
.727 .53 .625 r
.59632 .49581 m .52224 .4912 L .52215 .45356 L p F P
0 g
s
.01 w
.55811 .46063 Mdot
.5 Mabswid
.643 .555 .741 r
.40473 .6268 m .46185 .61522 L .46816 .65466 L p F P
0 g
s
.01 w
.46426 .4721 Mdot
.5 Mabswid
.767 .634 .714 r
.58892 .57457 m .65138 .5868 L .64145 .62559 L p F P
0 g
s
.771 .616 .686 r
.65138 .5868 m .58892 .57457 L .59309 .53475 L p F P
0 g
s
.01 w
.55283 .46283 Mdot
.46925 .47438 Mdot
.5 Mabswid
.767 .634 .714 r
.64145 .62559 m .58388 .61459 L .58892 .57457 L p F P
0 g
s
.01 w
.54764 .46518 Mdot
.5 Mabswid
.685 .607 .763 r
.52332 .68979 m .47522 .69293 L .46816 .65466 L p F P
0 g
s
.01 w
.47416 .47679 Mdot
.54253 .46768 Mdot
.5 Mabswid
.721 .636 .762 r
.57155 .69245 m .52332 .68979 L .52304 .651 L p F P
0 g
s
.721 .636 .762 r
.52304 .651 m .57805 .65411 L .57155 .69245 L p F P
0 g
s
.678 .514 .656 r
.52238 .53045 m .45186 .53552 L .44837 .49663 L p F P
0 g
s
.678 .514 .656 r
.44837 .49663 m .52224 .4912 L .52238 .53045 L p F P
0 g
s
.01 w
.47899 .47934 Mdot
.53751 .47031 Mdot
.5 Mabswid
.727 .554 .656 r
.52224 .4912 m .59632 .49581 L .59309 .53475 L p F P
0 g
s
.01 w
.53258 .47307 Mdot
.49286 .6899 Mdot
.49546 .69064 Mdot
.49029 .68902 Mdot
.49807 .69126 Mdot
.48373 .48202 Mdot
.48775 .68801 Mdot
.5007 .69174 Mdot
.48523 .68686 Mdot
.50334 .69208 Mdot
.48276 .68559 Mdot
.50598 .69229 Mdot
.48032 .68418 Mdot
.50863 .69236 Mdot
.47793 .68265 Mdot
.51128 .6923 Mdot
.51128 .6923 Mdot
.47559 .68098 Mdot
.51391 .69209 Mdot
.52776 .47597 Mdot
.47331 .6792 Mdot
.51654 .69176 Mdot
.47108 .67728 Mdot
.51914 .69129 Mdot
.46892 .67525 Mdot
.52173 .69068 Mdot
.46682 .67309 Mdot
.48837 .48482 Mdot
.52429 .68994 Mdot
.46479 .67081 Mdot
.5 Mabswid
.685 .607 .763 r
.46816 .65466 m .52304 .651 L .52332 .68979 L p F P
0 g
s
.01 w
.52304 .47898 Mdot
.46283 .66842 Mdot
.52682 .68907 Mdot
.46096 .66591 Mdot
.52932 .68806 Mdot
.45917 .66329 Mdot
.53178 .68693 Mdot
.51843 .48212 Mdot
.45746 .66055 Mdot
.49292 .48775 Mdot
.5342 .68566 Mdot
.45585 .65771 Mdot
.53657 .68427 Mdot
.45432 .65476 Mdot
.51393 .48537 Mdot
.53889 .68275 Mdot
.4529 .65171 Mdot
.54116 .6811 Mdot
.45158 .64857 Mdot
.49737 .4908 Mdot
.50956 .48873 Mdot
.54337 .67933 Mdot
.45037 .64532 Mdot
.44926 .64198 Mdot
.54551 .67743 Mdot
.44827 .63855 Mdot
.50531 .49219 Mdot
.54759 .67541 Mdot
.50171 .49395 Mdot
.5 Mabswid
.727 .554 .656 r
.59309 .53475 m .52238 .53045 L .52224 .4912 L p F P
0 g
s
.01 w
.44739 .63503 Mdot
.54959 .67328 Mdot
.44663 .63143 Mdot
.50118 .49576 Mdot
.5 Mabswid
.685 .585 .737 r
.52304 .651 m .46816 .65466 L .46185 .61522 L p F P
0 g
s
.01 w
.55152 .67102 Mdot
.44599 .62775 Mdot
.49718 .49941 Mdot
.44548 .62399 Mdot
.50594 .49722 Mdot
.55337 .66865 Mdot
.5 Mabswid
.682 .539 .684 r
.52256 .57063 m .45638 .57527 L .45186 .53552 L p F P
0 g
s
.682 .539 .684 r
.45186 .53552 m .52238 .53045 L .52256 .57063 L p F P
0 g
s
.01 w
.44509 .62016 Mdot
.5 Mabswid
.724 .616 .737 r
.57805 .65411 m .52304 .651 L .52278 .61105 L p F P
0 g
s
.724 .616 .737 r
.52278 .61105 m .58388 .61459 L .57805 .65411 L p F P
0 g
s
.01 w
.49332 .50315 Mdot
.55514 .66617 Mdot
.44484 .61626 Mdot
.44472 .6123 Mdot
.55682 .66358 Mdot
.48959 .50697 Mdot
.51006 .50058 Mdot
.44474 .60828 Mdot
.5 Mabswid
.727 .576 .684 r
.52238 .53045 m .59309 .53475 L .58892 .57457 L p F P
0 g
s
.01 w
.55841 .66087 Mdot
.486 .51087 Mdot
.44489 .60421 Mdot
.44519 .60008 Mdot
.48255 .51484 Mdot
.5599 .65806 Mdot
.51405 .50404 Mdot
.44563 .59591 Mdot
.47925 .51888 Mdot
.5613 .65515 Mdot
.44621 .5917 Mdot
.47609 .52297 Mdot
.44694 .58745 Mdot
.44782 .58317 Mdot
.5626 .65214 Mdot
.47308 .52712 Mdot
.51793 .5076 Mdot
.44884 .57886 Mdot
.47022 .53131 Mdot
.45002 .57453 Mdot
.46751 .53554 Mdot
.56379 .64903 Mdot
.45135 .57019 Mdot
.46496 .53981 Mdot
.45283 .56584 Mdot
.46255 .54411 Mdot
.45447 .56148 Mdot
.4603 .54843 Mdot
.45626 .55712 Mdot
.4582 .55277 Mdot
.56487 .64583 Mdot
.52167 .51124 Mdot
.56584 .64254 Mdot
.5 Mabswid
.685 .585 .737 r
.46185 .61522 m .52278 .61105 L .52304 .651 L p F P
0 g
s
.684 .562 .711 r
.52278 .61105 m .46185 .61522 L .45638 .57527 L p F P
0 g
s
.684 .562 .711 r
.45638 .57527 m .52256 .57063 L .52278 .61105 L p F P
0 g
s
.01 w
.52529 .51495 Mdot
.56669 .63915 Mdot
.56743 .63569 Mdot
.5 Mabswid
.726 .596 .711 r
.58388 .61459 m .52278 .61105 L .52256 .57063 L p F P
0 g
s
.726 .596 .711 r
.52256 .57063 m .58892 .57457 L .58388 .61459 L p F P
0 g
s
.01 w
.52878 .51875 Mdot
.5 Mabswid
.727 .576 .684 r
.58892 .57457 m .52256 .57063 L .52238 .53045 L p F P
0 g
s
.01 w
.56805 .63214 Mdot
.53213 .52261 Mdot
.56854 .62852 Mdot
.56891 .62483 Mdot
.53534 .52653 Mdot
.56915 .62106 Mdot
.53842 .53051 Mdot
.56925 .61724 Mdot
.56922 .61335 Mdot
.54135 .53455 Mdot
.56906 .60941 Mdot
.54414 .53863 Mdot
.56876 .60541 Mdot
.54679 .54274 Mdot
.56832 .60137 Mdot
.54929 .54689 Mdot
.56773 .59729 Mdot
.56701 .59317 Mdot
.55164 .55107 Mdot
.56613 .58902 Mdot
.55385 .55528 Mdot
.56512 .58484 Mdot
.5559 .55949 Mdot
.56395 .58064 Mdot
.55781 .56372 Mdot
.56264 .57642 Mdot
.55957 .56796 Mdot
.56118 .57219 Mdot
.25 Mabswid
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.08845 .24527 m
.67201 0 L
s
.09903 .24082 m
.10412 .24605 L
s
[(-1)] .08885 .23035 .97243 1 Mshowa
.22731 .1869 m
.23214 .19237 L
s
[(-0.5)] .21763 .17597 .88506 1 Mshowa
.36263 .13003 m
.36719 .13573 L
s
[(0)] .35353 .11861 .7977 1 Mshowa
.50562 .06993 m
.50984 .07588 L
s
[(0.5)] .49716 .05803 .71033 1 Mshowa
.65692 .00634 m
.66078 .01254 L
s
[(1)] .6492 -0.00605 .62296 1 Mshowa
.125 Mabswid
.12415 .23026 m
.12717 .23343 L
s
.14953 .21959 m
.15253 .22279 L
s
.17518 .20881 m
.17815 .21204 L
s
.2011 .19792 m
.20404 .20117 L
s
.25379 .17577 m
.25666 .17908 L
s
.28056 .16452 m
.28339 .16786 L
s
.30762 .15315 m
.31042 .15652 L
s
.33498 .14165 m
.33774 .14505 L
s
.3906 .11827 m
.39329 .12173 L
s
.41887 .10639 m
.42153 .10987 L
s
.44746 .09437 m
.45008 .09789 L
s
.47638 .08222 m
.47895 .08576 L
s
.53519 .0575 m
.53768 .0611 L
s
.5651 .04493 m
.56755 .04856 L
s
.59535 .03222 m
.59776 .03588 L
s
.62596 .01935 m
.62832 .02304 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-1)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-0.5)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(0.5)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(1)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{264.75, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004800017b000`400?l00000o`00003oo`3oool9
0?ooo`00o`3oool90?ooo`00Z`3oool4000005T0oooo002]0?ooo`030000003oool0oooo05P0oooo
002]0?ooo`030000003oool0oooo05P0oooo002]0?ooo`030000003oool0oooo05P0oooo002]0?oo
o`030000003oool0oooo05P0oooo002[0?ooo`<00000FP3oool00:d0oooo00<000000?ooo`3oool0
F03oool00?l0oooo2@3oool00;@0oooo0P00001B0?ooo`00/P3oool2000000030?ooo`0000000000
0540oooo002`0?ooo`8000000`3oool200000540oooo002]0?ooo`<000000P3oool01P000000oooo
0?ooo`000000oooo00000500oooo002[0?ooo`800000203oool00`000000oooo0000001@0?ooo`00
Z03oool3000000X0oooo00@000000?ooo`3oool00000C`3oool00:H0oooo0P0000020?ooo`030000
003oool0oooo00P0oooo00D000000?ooo`3oool0oooo0000001>0?ooo`00O@3oool2000000@0oooo
00<000000?ooo`3oool00P3oool3000001T0oooo0P00000?0?ooo`050000003oool0oooo0?ooo`00
0000CP3oool007`0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0C0?ooo`<0
00004@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04/0oooo001l0?ooo`040000
003oool0oooo000000/0oooo00<000000?ooo`3oool04@3oool200000080oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04X0oooo001l0?ooo`040000
003oool0oooo000000P0oooo0`00000B0?ooo`8000005`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo04X0oooo001l0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3o
ool03`3oool3000001T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`190?ooo`00
O03oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00d0oooo0P0000000`3oool0
00000?ooo`0I0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0B@3oool007d0oooo
0P0000090?ooo`@000002P3oool2000001h0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`180?ooo`00T`3oool300000200oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`170?ooo`00T@3oool2000000030?ooo`000000oooo0200oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`170?ooo`00SP3oool3000002D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`160?ooo`00S03oool2000002P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`160?ooo`00RP3oool3000002T0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`150?ooo`00Q`3oool3000000<0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo04@0oooo00250?ooo`800000;`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo04@0oooo00230?ooo`80000000<0oooo0000003oool0;P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo04<0oooo001T0?ooo`8000006P3oool3000003<0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`120?ooo`00H`3oool010000000oooo
0?ooo`00000G0?ooo`800000=P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0480
oooo001S0?ooo`040000003oool0oooo000001D0oooo0P0000000`3oool000000?ooo`0e0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0@@3oool006<0oooo00@000000?ooo`3oool0
00004P3oool3000003X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`110?ooo`00
H`3oool010000000oooo0?ooo`00000@0?ooo`800000?@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo0400oooo001S0?ooo`040000003oool0oooo000000d0oooo0`0000000`3oool0
00000?ooo`0m0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0?`3oool006@0oooo
0P00000<0?ooo`800000@`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03l0oooo
001`0?ooo`800000A@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03h0oooo001]
0?ooo`<0000000<0oooo0000003oool0A03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo03h0oooo001[0?ooo`800000BP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
03d0oooo001Y0?ooo`800000C03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03`0
oooo001V0?ooo`<0000000<0oooo0000003oool0B`3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo03`0oooo001T0?ooo`800000D@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo03/0oooo001Q0?ooo`<00000D`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo03/0oooo000g0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000006P3oool20000
05H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`00=P3oool010000000
oooo0?ooo`00000;0?ooo`030000003oool0oooo01@0oooo0`00001H0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0>@3oool003H0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`0B0?ooo`@00000F@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
03T0oooo000`0?ooo`@000000P3oool010000000oooo0?ooo`0000080?ooo`<000004`3oool20000
05d0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0h0?ooo`00=P3oool010000000
oooo0?ooo`0000080?ooo`030000003oool0oooo0100oooo0`00001O0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0=`3oool003H0oooo00@000000?ooo`3oool00000203oool00`00
0000oooo0?ooo`0>0?ooo`@00000H03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
03L0oooo000g0?ooo`8000002@3oool4000000/0oooo0P00001T0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0=P3oool004l0oooo0P00001V0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0=P3oool004`0oooo0`0000000`3oool000000?ooo`1U0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0=@3oool004X0oooo0P00001/0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0=03oool004L0oooo0`00001^0?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool0=03oool004D0oooo0P0000020?ooo`800000K@3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo03<0oooo00120?ooo`<00000L`3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo03<0oooo000R0?ooo`@000006P3oool4000007@0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0b0?ooo`00903oool00`000000oooo0?ooo`0G
0?ooo`800000N03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0340oooo000T0?oo
o`030000003oool0oooo01D0oooo0P00001j0?ooo`030000003oool0oooo01T0oooo00<000000?oo
o`3oool0<@3oool001`0oooo100000040?ooo`030000003oool0oooo0180oooo1000001k0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool0<03oool002@0oooo00<000000?ooo`3oool0
403oool2000007l0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0_0?ooo`008P3o
ool300000100oooo0P0000210?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0;`3o
ool002@0oooo00<000000?ooo`3oool02`3oool3000008<0oooo00<000000?ooo`3oool0703oool0
0`000000oooo0?ooo`0^0?ooo`00;`3oool3000008H0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`0^0?ooo`00;@3oool4000008L0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0]0?ooo`00:`3oool2000008/0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`0/0?ooo`00:@3oool2000008d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`0/0?ooo`009`3oool2000000030?ooo`000000oooo08`0oooo00<000000?ooo`3oool07`3oool0
0`000000oooo0?ooo`0[0?ooo`009`3oool2000008l0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0[0?ooo`009`3oool3000008h0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`0Z0?ooo`009P3oool200000080oooo00<000000?ooo`3oool0GP3oool<00000280oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0Y0?ooo`007P3oool4000000@0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`1F0?oooa<0000000<09@000000000000001000
000K0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0:@3oool00200oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0540oooo8P00000G
0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0:03oool00200oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04`0oooo3@00000706T0
0003000000250000Q@0000D0Q@003P00000C0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool09`3oool001P0oooo100000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`180?ooo`P0000000<0@P000000001Y00002@1Y0007000000/0
Q@0000<0000009L<002G30001`00000@0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool09`3oool00200oooo00<000000?ooo`3oool00P3oool2000000P0oooo00<000000?ooo`3oool0
A03oool30000000401@0000000000000000000@0@P0000@0000006T0001Y0000J@0020000003088B
8`040000002K9R<0VbHS09/V8`P00000102500000`000000U``009L<000309L<00H000003@3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02H0oooo000N0?ooo`<000001@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0440oooo1P000005048000H000002`224R<00`00
0000VbHS09/V8`0909/V8`L00000202G3004000000X0oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`0V0?ooo`00803oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0?P3oool4000000@0@P001@00000206406@03000000224R<0PQ8S00`0
PQ8S00<0000009/V8`2K9R<03@2K9R<00`000000[S<J0:hc6P05000000H0U``00`0000080?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool09@3oool002D0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0j0?ooo`D0000000<0@P000000000000000`00000606406@030000
00224R<0PQ8S00D0PQ8S4@00000809/V8`030000002^<aX0[S<J00@0[S<J1@000000102G30000000
09h>002N3P03000000D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0T0?ooo`00
9@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03L0oooo2000000906406@X00000
202A;dH00`000000Z4560:Q1AP060:Q1APX000002P2^<aX400000080WPh00`0000030?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0903oool002D0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0d0?ooo`<0000000D01`00000000000000<0010000000706406@@00000
0P1e5Sl00`000000TBm6094_AP0=094_AP030000002X@DH0Z45600h0Z45600<000000;]??`2kCcl0
0`0000080:hc6P040000002l>P@00000000000<0WPh00P0000000`3oool000000?ooo`0W0?ooo`03
0000003oool0oooo02<0oooo000T0?ooo`8000003`3oool00`000000oooo0?ooo`0a0?ooo`<00000
00<01`000000000000000P0`00400`000000H@0I06406@0206406@@000001P1e5Sl00`000000TBm6
094_AP0=094_AP030000002X@DH0Z45600h0Z45600<000000;]??`2kCcl00`2kCcl4000000D0[S<J
00<000000;`j102l>P@00`00000209h>00800000:03oool00`000000oooo0?ooo`0S0?ooo`009@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02l0oooo0P0000000`07000000000000
000403000@D000002@1e5Sl00`000000TBm6094_AP0:094_APd000002@2X@DH00`000000^dlo0;]?
?`060;]??`@0000000<0[S<J0000002l>P@0102l>P@6000002L0oooo00<000000?ooo`3oool08P3o
ool002@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0]0?ooo`04000000070000
0000000000@0<0010`00000=07DF?`030000002A;dH0TBm60080TBm62000000409]4G`030000002_
EEl0[eEO00H0[eEO3000000:0;]??`@000001P2l>P@4000002L0oooo00<000000?ooo`3oool08@3o
ool002@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0Z0?ooo`@00000100`0042
0000000304d0;P000000MAHo00/0MAHo1`00000<09]4G`030000002_EEl0[eEO00l0[eEO00<00000
0<5SF`31He/0100000080;]??`030000003;FC000000008000000`2l>P@00`000000_3X400000002
000002H0oooo00<000000?ooo`3oool08@3oool002@0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0X0?ooo`<00000100`004200000080C@0^00<0000007DF?`1e5Sl01`1e5Sl40000
0080PRmJ00<0000009]4G`2KA5l03P2KA5l00`000000[eEO0:mEG`0?0:mEG`0300000031He/0`F=K
00@0`F=K100000050;]??`040000003;FC00beT`0<]I<080000000<0_3X40000002l>P@00P2l>P@3
000002D0oooo00<000000?ooo`3oool0803oool002<0oooo0P00000E0?ooo`030000003oool0oooo
02H0oooo0P00000303000@<00000101=02h00`000000MAHo07DF?`0307DF?`@000001P22;eX00`00
0000VdAO09]4G`0>09]4G`030000002_EEl0[eEO00l0[eEO00<000000<5SF`31He/02031He/40000
00030;]??`000000beT`00@0beT`0`0000020;`j10040000002l=P000000000002@0oooo00<00000
0?ooo`3oool0803oool002@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0S0?oo
o`@0000000<0<0010000000000001P1=02h00`000000MAHo07DF?`04000000T0PRmJ00<0000009]4
G`2KA5l03`2KA5l00`000000[eEO0:mEG`0@0:mEG`0300000031He/0`F=K00/0`F=K100000040<]I
<0030000003;FC00000000<0000000@0_3H000000000000000008`3oool00`000000oooo0?ooo`0O
0?ooo`00903oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0280oooo1P00000704d0
;P@000003@22;eX00`000000VdAO09]4G`0609]4Ga<000002@2_EEl00`000000`F=K0<5SF`0=0<5S
F`040000003BKe000000000000<0beT`00@000000<]I<03;FC00beT`0P000000102l=P0000000000
0000000S0?ooo`030000003oool0oooo01h0oooo000S0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0803oool5000000L0C@0^0P0000000`1Q4Dl00000088_FP0<088_FP/000002@2Q
EG800`000000/fAb0;=TLP070;=TLP`000003@31He/010000000dVm@0=9_D03BKe02000000030<]I
<0000000beT`00<0beT`00@000000=EM4@000000_3H00P00000R0?ooo`030000003oool0oooo01h0
oooo000S0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool07@3oool6000000H0C@0^
0P000003064AC`0300000022;eX0PRmJ00L0PRmJ1000000208]2K`030000002QEG80XEEb00l0XEEb
00<000000;=TLP2cI780402cI7800`000000a75_0<AaK`04000000T0`F=K00<000000=9_D03BKe00
0`3BKe03000000@0beT`00@000000=EM4@000000_3H00P00000R0?ooo`030000003oool0oooo01d0
oooo000S0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06`3oool40000000300h0
3P000000C@0^00<0C@0^0`000004064AC`0300000022;eX0PRmJ00@0PRmJ1000000608]2K`030000
002QEG80XEEb00l0XEEb00<000000;=TLP2cI780402cI7800`000000a75_0<AaK`040<AaK`@00000
1P31He/00`000000dVm@0=9_D0030=9_D0040000003BKe00000000000080beT`00D000000=EM4@3E
GA4000000;`f000200000280oooo00<000000?ooo`3oool0703oool002<0oooo0P00000J0?ooo`03
0000003oool0oooo01T0oooo1000000200h03P030000001=02h0C@0^008000001`1Q4Dl00`000000
PRmJ088_FP04000000X0Rd9_00<000000:5ELP2QEG803`2QEG800`000000/fAb0;=TLP0@0;=TLP03
00000034LFl0a75_00P0a75_100000020<5SF`030000003BKe00dVm@00<0dVm@00@000000=9_D03B
Ke00dVm@0P000000103;FC0000000=EM4@3EGA42000000030;`f00000000oooo0200oooo00<00000
0?ooo`3oool0703oool002<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0G0?oo
o`@000000P0>00h010000000C@0^000000000008064AC`@000003@2;@Vl00`000000XEEb0:5ELP0@
0:5ELP030000002cI780/fAb0100/fAb00<000000<AaK`34LFl03034LFl4000000@0dVm@00<00000
0=9_D03BKe000`3BKe02000000@0eEdA00<000000;`f000000008@3oool00`000000oooo0?ooo`0K
0?ooo`008`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01D0oooo0`00000400h0
3P800000201Q4Dl20000000306hZJ0000000Rd9_00h0Rd9_00<000000:5ELP2QEG801`2QEG8C0000
00T0/fAb00<000000<AaK`34LFl03P34LFl010000000eGiX0000000000020=9_D0030000003BKe00
dVm@00@0dVm@0`0000030=EM4@<00000803oool00`000000oooo0?ooo`0K0?ooo`008P3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo01<0oooo0`00000300h03P<000001P1Q4Dl30000
00<0KRYX00<0000008]2K`2;@Vl02`2;@Vl<000000T0YF6100<000000;I_P@2fKh401`2fKh4<0000
00h0a75_00@000000=EnJ03EOVP0eGiX0`0000070=9_D0030000003QN3`0000000<0eEdA0`00000P
0?ooo`030000003oool0oooo01X0oooo000R0?ooo`030000003oool0oooo01h0oooo00<000000?oo
o`3oool04@3oool3000000<03P0>00<0000002d0>@0000001@1Q4Dl2000000H0KRYX00<0000008]2
K`2;@Vl01`2;@Vl400000080TU5o00<000000:EQP@2UHH40402UHH400`000000]Vn10;I_P@0@0;I_
P@0300000036O7l0aWao00@000002P34LFl00`000000eGiX0=EnJ0030=EnJ0<000001@3BKe000`00
0000hGPl0>5h?002000000<0eEdA00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0I0?oo
o`008P3oool200000200oooo00<000000?ooo`3oool0403oool0100000003P0>00h03P0>00h20000
0080;@0i00<00000064AC`1Q4Dl00`00000706hZJ0030000002;@Vl0Rd9_00@0Rd9_10000006099A
O`030000002UHH40YF610100YF6100<000000;I_P@2fKh40402fKh400`000000aWao0<IlO`040<Il
O`D000001P34LFl00`000000eGiX0=EnJ0020=EnJ0030000003EOVP0eGiX00<000000P3BKe000`00
0000hGPl0>5h?0020>5h?0050000003EGA40eEdA0=EM4@000000803oool00`000000oooo0?ooo`0I
0?ooo`008P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00h0oooo00D0000000h0
3P0>00h03P0>0000000302d0>@040000001Q4Dl00000000000X0KRYX00<0000008]2K`2;@Vl01000
000:099AO`030000002UHH40YF610100YF6100<000000;I_P@2fKh40402fKh400`000000aWao0<Il
O`090<IlO`@000000P34LFl00`000000eGiX0=EnJ0020=EnJ0030000003EOVP0eGiX00<0eGiX0P00
00000`3BKe0000000>5h?0030>5h?080000000<0eEdA000000000000803oool00`000000oooo0?oo
o`0H0?ooo`003P3oool2000000@0oooo00<000000?ooo`3oool00P3oool3000000H0oooo00<00000
0?ooo`3oool08@3oool00`000000oooo0?ooo`0<0?ooo`80000000<03P0>000000000000100]03T2
000000/0KRYX1000000>099AO`030000002UHH40YF610100YF6100<000000;I_P@2fKh40402fKh40
0`000000aWao0<IlO`0=0<IlO`@000000`3EOVP00`000000eGiX0=EnJ0050=EnJ08000001P3QN3`0
10000000eEdA00000000000O0?ooo`030000003oool0oooo01P0oooo000=0?ooo`040000003oool0
oooo000000/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo00X0oooo0P0000000`0>00h0000002d0>@0302d0>@<000002P1^:VP20000000307TmNP00
0000TU5o00l0TU5o00<000000:EQP@2UHH40402UHH400`000000]Vn10;I_P@0@0;I_P@0300000036
O7l0aWao00l0aWao00H000000=J9N`00000000000=EnJ00000080=EnJ0<000001@3QN3`200000003
0<QA00000000oooo01h0oooo00<000000?ooo`3oool05`3oool000d0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool0203oool4000000@0;@0i00@0000004@6F@141UT00000201^:VP2000000<0NCej00<00000099A
O`2BDGl03P2BDGl00`000000YF610:EQP@070:EQPA<000002@2fKh400`000000aWao0<IlO`0?0<Il
O`040000003FRG/0eXUk0=J9N`<000001`3EOVP010000000iXYK0>J:F`0000060>5h?0<000007`3o
ool00`000000oooo0?ooo`0F0?ooo`001`3oool400000080oooo00@000000?ooo`3oool00000203o
ool3000000D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`060?ooo`<000001@0]
03T01@000000A0II04@6F@141UT0000000H0KRYX0P00000507TmNP030000002BDGl0TU5o00d0TU5o
2`0000090:Q/S@030000002hNHd0^7V=00L0^7V=3000000?0<IlO`030000003FRG/0eXUk0080eXUk
00@000000=J9N`00000000001@3EOVP010000000iXYK0>J:F`3VRU/2000000@0hGPl1000000N0?oo
o`030000003oool0oooo01H0oooo000=0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00@0oooo1000000302d0
>@8000000`141UT00`000000KRYX06hZJ00306hZJ08000001`1i?GX00`000000TU5o099AO`09099A
O`@0000000<0UUf<0000002XK8d04@2XK8d00`000000^7V=0;QiS@0@0;QiS@0300000037QH`0ahF<
00@000002`36O7l00`000000eXUk0=J9N`020=J9N`040000003FRG/0eXUk0=J9N`<000000`3EOVP0
0`000000iXYK0>J:F`020>J:F`030000003QN3`0hGPl0080hGPl0`00000O0?ooo`030000003oool0
oooo01D0oooo000=0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool2
000002P0oooo00<000000?ooo`3oool00`3oool3000000<0;@0i00<0000004@6F@141UT00`141UT0
10000000KRYX06hZJ01^:VP2000000T0NCej00<00000099AO`2BDGl01P2BDGl3000000D0UUf<00<0
00000:Q/S@2XK8d0402XK8d00`000000^7V=0;QiS@0@0;QiS@0300000037QH`0ahF<00@0ahF<1@00
00060<IlO`030000003FRG/0eXUk0080eXUk00<000000=J9N`3FRG/0103FRG/2000000030=EnJ000
0000iXYK00@0iXYK0P0000020>5h?0040000003SN1800000000001l0oooo00<000000?ooo`3oool0
503oool000h0oooo0P0000090?ooo`@00000103oool00`000000oooo0?ooo`0X0?ooo`040000003o
ool0oooo0?ooo`80000000D0000=0000000]03T0;@0i0000000604@6F@040000001^:VP000000000
00/0NCej00<00000099AO`2BDGl00`2BDGl3000000P0UUf<00<000000:Q/S@2XK8d0402XK8d00`00
0000^7V=0;QiS@0@0;QiS@0300000037QH`0ahF<00T0ahF<100000020<IlO`030000003FRG/0eXUk
0080eXUk00<000000=J9N`3FRG/01P3FRG/2000000L0iXYK00<000000>5h?00000000P3SN1820000
01h0oooo00<000000?ooo`3oool0503oool00240oooo00<000000?ooo`3oool0:@3oool010000000
oooo00000000000200003@<000001`141UT2000000d0NCej00<00000099AO`0000000`00000;09IM
S0030000002XK8d0Z6b=0100Z6b=00<000000;QiS@2hNHd0402hNHd00`000000ahF<0<N5S00=0<N5
S0@00000103FRG/00`000000eXUk0=J9N`060=J9N`<000001P3VRU/3000000040>=h4P000000b540
000001h0oooo00<000000?ooo`3oool04`3oool00240oooo00<000000?ooo`3oool0:P3oool30000
000300003@000000000000L0A0II0`00000=07TmNP<000003`2FGH`00`000000Z6b=0:Q/S@0@0:Q/
S@030000002hNHd0^7V=0100^7V=00<000000<N5S037QH`03`37QH`010000000eY:9000000000002
0=J9N`030000003FRG/0eXUk00H0eXUk00<000000>NHLP3WV7800P0000060>J:F`030000003SN180
hgPB008000007P3oool00`000000oooo0?ooo`0C0?ooo`00803oool00`000000oooo0?ooo`0[0?oo
o`8000000P0000d00`000000A0II04@6F@0504@6F@040000001D8740E21a000000X0NCej0`000000
0`20C8T0000009IMS00?09IMS0030000002XK8d0Z6b=0100Z6b=00<000000;QiS@2hNHd0402hNHd0
0`000000ahF<0<N5S00?0<N5S0040000003FTXT0eY:90=JBR@<00000203FRG/00`000000iiQb0>NH
LP020>NHLP030000003VRU/0iXYK00<0iXYK0P0000020>=h4P8000007@3oool2000001@0oooo000P
0?ooo`030000003oool0oooo02X0oooo0P00000200003@8000001@141UT2000000<0E21a00<00000
07TmNP1i?GX01P1i?GX2000000@0P4b900<0000009IMS02FGH`03P2FGH`00`000000Z6b=0:Q/S@07
0:Q/SA<000002@2hNHd00`000000ahF<0<N5S00?0<N5S0030000003FTXT0eY:900<0eY:910000006
0=J9N`030000003WV780iiQb0080iiQb0P0000040>J:F`8000000P3SN1800`000000oooo0?ooo`0H
0?ooo`<0000000<0oooo0000003oool04`3oool00200oooo0P00000[0?ooo`060000000000d0000=
0000000003/0000010141UT00`000000E21a05@PL@0205@PL@030000001i?GX0NCej00@0NCej0`00
0006081<R@030000002FGH`0UUf<00`0UUf<300000090:]dU`030000002iPIL0^H6G00L0^H6G3000
000?0<N5S0030000003FTXT0eY:900<0eY:900@000000=JBR@3FTXT0eY:90P0000040=J9N`030000
003WV780iiQb00@0iiQb00L000000>J:F`3VRU/0iXYK0000003aTch000000080hgPB00<000000?oo
o`3oool0503oool3000000@0oooo00<000000?ooo`3oool04P3oool00200oooo00<000000?ooo`3o
ool0:@3oool010000000000=00003@0000020000>`03000000141UT0A0II008000001@1D87401000
0000NCej07TmNP1i?GX3000000T0P4b900<0000009IMS02FGH`0202FGH`400000080VVRF00<00000
0:]dU`2[M9L0402[M9L00`000000^H6G0;V1U`0@0;V1U`0300000037S9H0ahbF00@000002`37QH`0
0`000000eY:90=JBR@030=JBR@030000003FTXT0eY:900<0eY:90`0000000`3FRG/000000>NHLP06
0>NHLP80000000L0iXYK0000003aTch0lI<n0000003SN180000001<0oooo0`0000070?ooo`030000
003oool0oooo0180oooo000P0?ooo`030000003oool0oooo02T0oooo00<0000000003@0000000P00
03/010000000A0II04@6F@00000705@PL@040000001i?GX00000000000`0P4b900<0000009IMS02F
GH`0102FGH`4000000H0VVRF00<000000:]dU`2[M9L0402[M9L00`000000^H6G0;V1U`0@0;V1U`03
00000037S9H0ahbF00@0ahbF1@0000060<N5S0030000003FTXT0eY:900<0eY:900<000000=JBR@3F
TXT01P3FTXT2000000T0iiQb0`0000020?6C?P030000003SN180000000l0oooo0`00000;0?ooo`03
0000003oool0oooo0140oooo000P0?ooo`030000003oool0oooo02P0oooo00@0000000003@0000d0
00000P0003/3000000P0E21a0P00000>081<R@030000002FGH`0UUf<00@000002P2JJ9H00`000000
ZgBG0:]dU`0@0:]dU`030000002iPIL0^H6G0100^H6G00<000000<N<UP0000000P0000070<N<UP@0
00000P37QH`00`000000eY:90=JBR@030=JBR@030000003FTXT0eY:900L0eY:90`0000090>NHLP04
0000003aTch0lI<n0?6C?P800000303oool3000000h0oooo00<000000?ooo`3oool04@3oool001l0
oooo00<000000?ooo`3oool0:@3oool00`000000000=000000030000>`030000001D8740E21a00H0
E21a0`00000>081<R@@000003P2JJ9H00`000000ZgBG0:]dU`0@0:]dU`030000002iPIL0^H6G0100
^H6G00<000000<N<UP37S9H01`0000060<N<UP@00000103FTXT00`000000eY:90=JBR@070=JBR@04
0000003VXH@0iZ64000000P0iiQb0P0000030?6C?P800000203oool300000140oooo00<000000?oo
o`3oool04@3oool001l0oooo00<000000?ooo`3oool0:03oool3000000<0000k0P00000705@PL@04
0000001Q=8@0HCB4000000`0P4b90P0000000`26FID0000009YXUP0@09YXUP030000002[M9L0ZgBG
00l0ZgBG00<000000;V1U`2iPIL0402iPIL00`000000ahbF0<N<UP030<N<UP80000000@0ahbF0000
0000000000001P37S9H010000000eIVE0000000000020=JBR@030000003FTXT0eY:900L0eY:900@0
00000>JQQ03VXH@0iZ640P0000060>NHLP030000003fYF00000000<0lI<n00<000000?ooo`3oool0
0`3oool3000001@0oooo00<000000?ooo`3oool04@3oool001l0oooo0P00000Y0?ooo`8000000`00
03/00`0000006`1M0000000505@PL@8000000`1Q=8@00`000000P4b9081<R@08081<R@8000000`26
FID00`000000VVRF09YXUP0?09YXUP030000002[M9L0ZgBG00l0ZgBG00<000000;V1U`2iPIL03`2i
PILB000000030<N<UP000000eIVE0080eIVE0`0000090=JBR@030000003VXH@0iZ6400<0iZ6400<0
00000>NHLP3WV7800`3WV7800`000000mZEP000000040?6C?P030000003oool00000008000005`3o
ool00`000000oooo0?ooo`0A0?ooo`007`3oool00`000000oooo0?ooo`0X0?ooo`050000000003/0
000k0000>`0000000P0K05d00`000000E21a05@PL@0205@PL@030000001Q=8@0HCB400<0HCB400<0
0000081<R@20C8T01@20C8T3000000D0QUVE00<0000009YXUP2JJ9H03`2JJ9H00`000000ZgBG0:]d
U`0?0:]dU`030000002iPIL0^H6G00/0^H6G10000000102iPIL0000000000037S9H3000000040<N<
UP00000000000<N<UP/000000`3EVID3000000H0eY:900<000000>JQQ03VXH@01@3VXH@2000000<0
iiQb00@000000?JUH03fYF0000000`3aTch2000001X0oooo00<000000?ooo`3oool04@3oool001l0
oooo00<000000?ooo`3oool09`3oool200000080000k00@0000001/0G@0K05d000000`1D87420000
00H0HCB400<00000081<R@20C8T00`20C8T2000000H0QUVE3P00000609YXUP030000002[M9L0ZgBG
00H0ZgBG4`0000001@2iPIL00000000000000000^H6G00<0000000<0^H6G00000037S9H03P37S9H9
00000080eIVE0`0000030=JBR@030000003VXH@0iZ6400L0iZ6400@000000>NHLP3WV78000000`3f
YF000`000000lI<n0?6C?P02000001X0oooo00<000000?ooo`3oool04@3oool001l0oooo00<00000
0?ooo`3oool09`3oool01@000000000k0000>`0003/0000000806`1M00@0000005@PL@1D87400000
201Q=8@010000000P4b9081<R@20C8T2000000@0QUVE1`0000001@2JJ9H00000000000000000VVRF
00<0000000<0VVRF0000000000003`0000090:alW`030000002jQil0^XNO00D0^XNO3P00000>0<N<
UP<000000P3EVID5000000<0eIVE0P0000000`3FTXT000000>JQQ0090>JQQ0<00000103fYF001000
0000lI<n0000003MR0DK0?ooo`030000003oool0oooo0100oooo000N0?ooo`030000003oool0oooo
02L0oooo0P0000020000>`040000000K05d06`1M01/0G@<000002@1Q=8@010000000P4b900000000
000208IIU@L0000000@0QUVE00000026FID000002`2JJ9H800000100[7bO00<000000;Z7W`2jQil0
0`2jQil4000000030;Z7W`000000^XNO00H0^XNO00<000000<JCW`36Til01P0000080<N<UP030000
003EVID0000000<0000000<0eIVE0000003EVID00`0000030=FIU@800000303VXH@00`000000mZEP
0?JUH0030?JUH0040000003aTch00000000001X0oooo00<000000?ooo`3oool0403oool001h0oooo
00<000000?ooo`3oool09`3oool2000000030000>`0000006`1M00<06`1M00<00000064dQ01Q=8@0
2@1Q=8@200000080QUVE100000000`26FID000000000000508IIU@030000002JJ9H0VVRF00@0VVRF
1@00000409eaW`H000003P2/O9l00`000000^XNO0;Z7W`06000000X0^XNO00<000000<JCW`36Til0
1P36Til600000080ahbF00@000000=FIU@3EVID0eIVE100000020=FIU@<000000`3EVID3000000X0
iZ640P0000040?JUH0040000003aTch00000000001X0oooo00<000000?ooo`3oool0403oool001h0
oooo0P00000X0?ooo`<00000100K05d2000000T0HCB40`0000000`26FID0000000000003000000T0
QUVE00<0000009YXUP2JJ9H01000000;09eaW`030000002/O9l0000000@000002`2/O9l00`000000
^XNO00000002000000030;Z7W`000000^XNO00/0^XNO00<000000<JCW`36Til03036Til4000000@0
eIVE0P0000040=FIU@D000000P3TZ9<2000000P0iZ6400<000000?JaN@000000103fYF0200000003
0=f81@000000oooo01P0oooo00<000000?ooo`3oool0403oool001h0oooo00<000000?ooo`3oool0
9P3oool3000000@06`1M00<00000034AN0000000201Q=8@00`000000JdJB06]6TP05000000X0QUVE
1000000?09eaW`060000002/O9l0[7bO0:alW`000000[7bO0P00000:0:alW`@000003`2jQil00`00
0000aY>O0<JCW`0>0<JCW`040000003DWil00000000000<0eIVE0P0000040=FIU@040000003EVID0
0000000000@0i:RC00<000000>JQQ03VXH@01@3VXH@010000000m[5i0?JaN@0000040?JUH0030000
003MR0D0000001T0oooo00<000000?ooo`3oool0403oool001h0oooo00<000000?ooo`3oool09P3o
ool2000000D06`1M00<00000034AN00000001P1Q=8@20000000606]6TP000000000000000026FID0
00002P26FID20000000308]TW`000000WG6O0100WG6O00<000000:alW`2/O9l0102/O9l3000000L0
[7bO1000000?0;Z7W`0300000036Til0aY>O00l0aY>O00@000000=BOW`3DWil0e9nO0`0000000`3E
VID00000000000060=FIU@800000103TZ9<2000000D0iZ6400D000000?JaN@3f/GT0m[5i00000003
0?JUH0040000003MR0D0gHP5000001P0oooo00<000000?ooo`3oool0403oool001h0oooo00<00000
0?ooo`3oool09@3oool3000000@06`1M00@00000034AN00a4GP000001@1Q=8@00`000000JdJB06]6
TP04000000T0QUVE0`00000308]TW`030000002MLIl0WG6O00l0WG6O00<000000:alW`2/O9l01@2/
O9l3000000D0[7bO0`00000A0;Z7W`0300000036Til0aY>O00l0aY>O00<000000=BOW`3DWil0103D
Wil5000000@0eIVE0`0000050>BXT`030000003VXH@0iZ640080iZ6400D000000?JaN@3f/GT0m[5i
000000030?JUH080000000<0gHP50000003oool05`3oool00`000000oooo0?ooo`0@0?ooo`007@3o
ool00`000000oooo0?ooo`0V0?ooo`<000000`0K05d01@000000<A5h034AN00a4GP0000000<0HCB4
0P00000206]6TP<000000P1[AY800`000000QUVE08IIU@0408IIU@8000001P2;I9l00`000000WG6O
09eaW`0?09eaW`030000002/O9l0[7bO00L0[7bO1P0000000`2/O9l000000000000A0;Z7W`030000
0036Til0aY>O00l0aY>O00<000000=BOW`3DWil01@3DWil00`000000e9nO00000002000000<0eIVE
00<000000>BXT`0000000P0000040>BXT`8000000P3VXH@00`000000m[5i0?JaN@020?JaN@050000
003fYF00mZEP0000003cZ3L00P3MR0D00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0100
oooo000M0?ooo`030000003oool0oooo02D0oooo1000000201/0G@030000000a4GP0<A5h0080<A5h
00@00000064dQ01Q=8@000000P1[AY84000000<0JdJB00@0000008IIU@26FID0QUVE0`00000808]T
W`030000002MLIl0WG6O00l0WG6O00<000000:alW`2/O9l01P2/O9lB000000T0^XNO00<000000<JC
W`36Til03P36Til00`000000e9nO0=BOW`060=BOW`040000003DWil0e9nO0=BOW`<0000000@0eIVE
0000003TZ9<0i:RC0`0000050>BXT`<000001@3f/GT00`000000mZEP0?JUH002000000030=f81@00
0000oooo01L0oooo00<000000?ooo`3oool03`3oool001d0oooo0P00000V0?ooo`80000000@0000a
0000000K05d000001@0a4GP300000080JdJB1000000406]6TP0400000026FID00000000000`0RfBO
00<0000009eaW`2MLIl0302MLIl;00000080[H>W1@0000020:f3Y`030000002jSJL0^XfW00H0^XfW
3000000>0<JCW`030000003DWil0e9nO00H0e9nO00<000000=BOW`3DWil00P3DWil4000000@0i:RC
0P0000060>BXT`030000003f/GT0m[5i00@0m[5i00H000000?JUH000000000000=f81@00000H0?oo
o`030000003oool0oooo00l0oooo000M0?ooo`030000003oool0oooo02D0oooo0P00000010000340
000001/0G@000005034AN0030000001[AY80JdJB0080JdJB0P00000606]6TP8000003P2;I9l00`00
0000WG6O09eaW`0809eaW`@000000P2ONJP00`000000[H>W0:f3Y`080:f3Y`<0000000D0[H>W0000
00000000[H>W0000000A0;Z=Y`0300000036V:P0aYRX00H000002036Til00`000000e9nO0=BOW`06
0=BOW`030000003DWil0e9nO00<0e9nO1@0000030>BXT`8000001@3TZ9<2000000H0m[5i0P000000
0`3cZ3L000000000000H0?ooo`030000003oool0oooo00l0oooo000E0?ooo`8000001P3oool00`00
0000oooo0?ooo`0U0?ooo`80000000<0000a0000000000001@0a4GP2000000<0JdJB0`00000406]6
TP<000003`2;I9l00`000000WG6O09eaW`0409eaW`@000001P2ONJP00`000000[H>W0:f3Y`070:f3
Y`<000000`2]PjL300000140^XfW00<000000<JHZ036V:P01P36V:P600000080aY>O00<000000=BO
W`3DWil01P3DWil00`000000e9nO0=BOW`040=BOW`8000000P3R[Yl00`000000i:RC0>BXT`020000
00D0i:RC00<000000?BjS@0000001P3f/GT01@000000ljPg0000003MR0D0000001L0oooo00<00000
0?ooo`3oool03`3oool001@0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`0T
0?ooo`8000000P0003400`000000<A5h034AN003034AN00300000013:H`000000080JdJB0`000004
06]6TP040000001cE9l0LeBO000000l0RfBO00<0000009eaW`2MLIl01000000:09miZ0030000002]
PjL0[H>W00H0[H>W0`0000050:f3Y`8000004@2jSJL00`000000aYRX0<JHZ00<0<JHZ0@000001`3D
Wil00`000000e9nO0=BOW`040=BOW`8000000`3R[Yl2000000030>BXT`000000000000@0i:RC00@0
00000?BjS@3d^Xd000001@3f/GT00`000000ljPg0?>X=`02000001L0oooo00<000000?ooo`3oool0
3`3oool001@0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0U0?ooo`800000
0P0003400`000000<A5h034AN002034AN00500000013:H`0@bV<0000001[AY800`00000306]6TP80
0000101cE9l00`000000RfBO08]TW`0;08]TW`@000003P2ONJP00`000000[H>W0:f3Y`050:f3Y`<0
00001`2]PjL200000100^XfW00<000000<JHZ036V:P03P36V:P010000000dZBX0000000000050=BO
W`030000003DWil0e9nO00@0e9nO0`0000040>:^W`040000003TZ9<00000000000<0i:RC00D00000
0?BjS@3d^Xd0m;Z=000000040?JaN@80000000<0ljPg0000000000005`3oool00`000000oooo0?oo
o`0?0?ooo`00503oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo02D0oooo00<0
00000000<@0003400P000003034AN00400000013:H`0@bV<04<YS0@000000`1[AY800`000000LeBO
07=DW`0407=DW`030000002;I9l0RfBO00P0RfBO0`0000000`2?KZP0000009miZ00?09miZ0030000
002]PjL0[H>W00@0[H>W0`0000080:f3Y`<000003`2jSJL00`000000aYRX0<JHZ00>0<JHZ0040000
003BY:P0dZBX0=:TZ0<000000P3DWil00`000000e9nO0=BOW`040=BOW`040000003R[Yl000000000
00@0hZjO100000000`3TZ9<000000?BjS@040?BjS@040000003f/GT0m[5i0?JaN@8000000P3cZ3L0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00l0oooo000D0?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool09@3oool00`000000000a0000<@02000000<0<A5h00<00000
04<YS013:H`00P13:H`200000080JdJB0P00000707=DW`030000002;I9l0RfBO00D0RfBO0`000004
08m^Z0030000002ONJP0WgVX00l0WgVX00<000000:f3Y`2]PjL00P2]PjL3000000T0[H>W00@00000
0;Z=Y`00000000003P2jSJL00`000000aYRX0<JHZ00>0<JHZ0030000003BY:P0dZBX00@0dZBX0`00
00060=BOW`040000003R[Yl00000000000H0hZjO0P0000000`3TZ9<000000?BjS@050?BjS@080000
003f/GT0m[5i0000003m_Ul000000?>X=`00000H0?ooo`030000003oool0oooo00h0oooo000D0?oo
o`040000003oool0oooo000000@0oooo0P00000V0?ooo`0500000000034000000000F`0000000P0a
4GP00`000000@bV<04<YS00204<YS0<0000000<0JdJB0000001cE9l0201cE9l00`000000RfBO08]T
W`0308]TW`800000202?KZP00`000000WgVX09miZ00>09miZ0030000002]PjL0[H>W0080[H>W0P00
000:0:f3Y`030000002jSJL0^XfW008000003@2jSJL00`000000aYRX0<JHZ00>0<JHZ0030000003B
Y:P0dZBX00H0dZBX0`0000030=BOW`040000003R[Yl0hZjO0>:^W`8000001P3R[Yl3000000L0m;Z=
00L000000?JaN@000000oKiO0000003cZ3L0000001P0oooo00<000000?ooo`3oool03P3oool001D0
oooo0P0000050?ooo`030000003oool0oooo02D0oooo00L000000000<@000000001K0000000a4GP0
000000@0@bV<1@00000;07=DW`030000002;I9l00000008000002P2?KZP00`000000WgVX09miZ00>
09miZ0040000002]PjL0[H>W0:f3Y`<000001P2]PjL=000000T0^XfW00<000000<JHZ036V:P03P36
V:P00`000000dZBX0=:TZ0060=:TZ0030000003BY:P0dZBX0080000000<0e9nO0000003R[Yl00`3R
[Yl2000000H0hZjO0P0000080?BjS@8000000P3m_Ul2000001P0oooo00<000000?ooo`3oool03P3o
ool001`0oooo00<000000?ooo`3oool09@3oool200000080001K0P00000404<YS0@000003@1cE9l2
000000d0SfjX00<0000009miZ02ONJP03P2ONJP00`000000[H>W0:f3Y`0:000000@0[XV_00@00000
0;ZC[`2jTjl0^Y>_0P0000030;ZC[`/000003P36V:P00`000000dZBX0=:TZ0070=:TZ0030000003B
Y:P0dZBX0080dZBX0P0000040>:^W`8000001P3R[Yl3000000P0m;Z=00H000000?fnG`3m_Ul00000
0?>X=`00000G0?ooo`030000003oool0oooo00h0oooo000L0?ooo`030000003oool0oooo02@0oooo
00<000000000<@0000000P0005/00`000000@bV<04<YS00304<YS0@000002`1cE9l3000000h0SfjX
00<0000009miZ02ONJP0302ONJP7000000`0[XV_00<000000;ZC[`2jTjl00P2jTjl2000000/0^Y>_
00<000000<FM[`0000000`00000:0<JHZ0030000003BY:P0dZBX00L0dZBX00<000000=:TZ03BY:P0
0`3BY:P3000000<0hZjO0P0000050>:^W`80000000<0lKnL0000003d^Xd01P3d^Xd010000000oKiO
0?fnG`3m_Ul2000001L0oooo00<000000?ooo`3oool03P3oool001/0oooo00<000000?ooo`3oool0
9@3oool2000000<0001K00<0000004<YS013:H`00P13:H`300000003054nW0000000LeBO00T0LeBO
00@0000007YPZ@1jH:T000003`2?KZP00`000000WgVX09miZ00509miZ0H000000P2QP:l00`000000
[XV_00000002000000`0[XV_00<000000;ZC[`2jTjl00`2jTjl2000000X0^Y>_00<000000<FM[`35
WJl00`35WJl4000000H0aYRX00<000000=:TZ03BY:P01`3BY:P00`000000dZBX0=:TZ0030=:TZ003
0000003O/ZT0gk:Y008000000P3R[Yl2000000@0hZjO0`0000000`3a_i`000000?BjS@050?BjS@80
00000P3m_Ul2000001L0oooo00<000000?ooo`3oool03P3oool001/0oooo00<000000?ooo`3oool0
9@3oool200000080001K0P00000404<YS08000000`1A?Y`00`000000LeBO07=DW`0507=DW`800000
101jH:T00`000000SfjX08m^Z00<08m^Z0030000002ONJP0WgVX00D00000202QP:l4000000d0[XV_
00<000000;ZC[`2jTjl00`2jTjl2000000X0^Y>_00<000000<FM[`35WJl01`35WJl400000080aYRX
00<000000=:TZ03BY:P01`3BY:P00`000000dZBX0=:TZ0020=:TZ0030000003O/ZT0gk:Y00<0gk:Y
00@000000>:^W`3R[Yl00000103R[Yl7000000@0m;Z=0P0000030?fnG`030000003oool0oooo01D0
oooo00<000000?ooo`3oool03P3oool001/0oooo00<000000?ooo`3oool09@3oool010000000001K
0000F`0005/2000000<0@bV<0`000003054nW0030000001cE9l0LeBO00@0LeBO00<0000007YPZ@1j
H:T0101jH:T00`000000SfjX08m^Z00;08m^Z0@000003@2QP:l3000000h0[XV_00<000000;ZC[`2j
Tjl0102jTjl2000000T0^Y>_00<000000<FM[`35WJl02`35WJl4000000P0dZBX00<000000=:TZ03B
Y:P00P3BY:P00`000000gk:Y0=nbZ@040=nbZA40000000@0m;Z=0000003obgd000000P3m_Ul00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo00d0oooo000K0?ooo`8000009P3oool01P000000
001K0000F`0000000@1k000000<0@bV<0P000004054nW0030000001cE9l0LeBO0080LeBO0P000007
07YPZ@030000002?KZP0SfjX00P0SfjX0`0000000`2BM[0000000:60[`0>0:60[`030000002^RJl0
000000h0[XV_00<000000;ZC[`2jTjl0102jTjl2000000T0^Y>_00<000000<FM[`35WJl03@35WJl0
0`000000d:V`00000002000000H0dZBX00D000000=:TZ03BY:P0dZBX000000060=nbZ@P000000P3a
_i`2000000030?6oW0000000000000@0000000D0ol]m0000003m_Ul0oKiO0000000H0?ooo`030000
003oool0oooo00d0oooo000K0?ooo`030000003oool0oooo02D0oooo00@000000000F`0005/00000
0P0107/00`000000@bV<04<YS002000000@0DCjL00D0000007=DW`1cE9l0LeBO0000000907YPZ@03
0000002?KZP0SfjX00D0SfjX0`000004099f/0030000002QP:l0XH2_00d0XH2_0P00000?0:j9[`03
0000002jTjl0^Y>_00D0^Y>_0P0000070;ZC[`0300000035WJl0aIf_00h0aIf_00<000000=2Y/03@
ZK000P3@ZK02000000@0dZBX00D000000=:TZ03BY:P0dZBX000000050=nbZ@P000000`3a_i`20000
00<0lKnL00<000000?BjS@0000000P000000103obgd000000?fnG`00000H0?ooo`030000003oool0
oooo00d0oooo000K0?ooo`030000003oool0oooo02D0oooo00<000000000F`0000000`0107/01000
0000@bV<000000000006054nW0<000002`1jH:T00`000000SfjX08m^Z00208m^Z0800000202BM[00
0`000000XH2_0:60[`0<0:60[`8000003`2^RJl00`000000^Y>_0;ZC[`050;ZC[`8000001`2jTjl0
0`000000aIf_0<FM[`0=0<FM[`030000003@ZK00d:V`00D0d:V`0`0000001@3BY:P000000=:TZ03B
Y:P0000000@0gk:Y1`0000020=nbZ@030000003a_i`0lKnL0080lKnL00<000000?6oW03a_i`00P3a
_i`6000000030?fnG`000000oooo01L0oooo00<000000?ooo`3oool03@3oool001X0oooo00<00000
0?ooo`3oool09P3oool00`000000001K000000030040N`@000001P1A?Y`00`000000NV2Y07YPZ@0;
07YPZ@030000002?KZP00000008000002P2BM[000`000000XH2_0:60[`0<0:60[`8000003`2^RJl0
0`000000^Y>_0;ZC[`060;ZC[`8000001P2jTjl00`000000aIf_0<FM[`0=0<FM[`030000003@ZK00
d:V`00P0d:V`0`000000103BY:P000000=nbZ@3O/ZT5000000<0gk:Y0P0000000`3O/ZT000000000
00020?6oW08000001@3a_i`00`000000ol]m00000004000001P0oooo00<000000?ooo`3oool03@3o
ool001X0oooo00<000000?ooo`3oool09P3oool2000000@00@1k00@00000054nW000000000001@1A
?Y`2000000d0NV2Y0P00000=099f/0030000002QP:l0XH2_00/0XH2_0`0000070:j9[a<000001P2j
Tjl00`000000aIf_0<FM[`0=0<FM[`030000003@ZK00d:V`00T0d:V`00D000000=2Y/00000000000
0=nbZ@04000000D0gk:Y0`0000020>g4Z@030000003a_i`0lKnL00800000103a_i`00`000000ol]m
0?o;O@05000001L0oooo00<000000?ooo`3oool03@3oool001X0oooo00<000000?ooo`3oool09@3o
ool3000000<00@1k1@000004054nW0040000001MCjT0GDnY000000X0NV2Y0`00000>099f/0030000
002QP:l0XH2_00/0XH2_2P0000080:n?]P030000002iV;H0^IRf00H0^IRf2`00000=0<FM[`030000
003@ZK00d:V`00T0d:V`00<000000=2Y/03@ZK001@0000070=nbZ@8000000`3]a:T010000000lKnL
0000000000040?6oW08000000P3obgd4000001L0oooo00<000000?ooo`3oool03@3oool001X0oooo
0P00000V0?ooo`800000100107/0100000006a^C000000000004054nW0050000001MCjT0GDnY05e?
Z@0000002@1jH:T01@000000P6bb081//P20K;80000000h0TWJ`00<000000:60[`2QP:l01@2QP:l8
000000l0[hnf00<000000;VH]P2iV;H01`2iV;H2000000D0^IRf00<000000<BR]P34X[H01@000007
0<FM[`030000003@ZK00d:V`00X0d:V`00<000000=2Y/0000000100000070=nbZ@<00000103]a:T3
000000<0lKnL00<000000?gCU00000000P3obgd4000001L0oooo00<000000?ooo`3oool03@3oool0
01X0oooo00<000000?ooo`3oool09@3oool2000000<00@1k00<0000001/KT`0K6i<00P000003054n
W0030000001MCjT0GDnY0080GDnY00<0000007YPZ@1jH:T01@1jH:T2000000@0P6bb00<00000099f
/02BM[00302BM[000`000000XH2_0:60[`05000000@0XhNf1000000?0:n?]P030000002iV;H0^IRf
00L0^IRf0P0000050;VH]P0300000034X[H0a::f00D0a::f1@0000020<FM[`030000003@ZK00d:V`
00X0d:V`00<000000=2Y/00000000P0000020=bf/P8000001P3O/ZT2000000D0kLBY0`0000020?6o
W0040000003mdi@0oM>D00000080ol]m0`00000H0?ooo`030000003oool0oooo00`0oooo000J0?oo
o`030000003oool0oooo02D0oooo0P0000030040N`030000000K6i<06a^C008000000P1A?Y`00`00
0000GDnY05e?Z@0405e?Z@030000001jH:T0NV2Y0080NV2Y0P000006081//P030000002BM[00TWJ`
00/0TWJ`100000090:>7]P8000000P2SQkH00`000000[hnf0:n?]P0<0:n?]P030000002iV;H0^IRf
00L0^IRf0P0000040;VH]P0300000034X[H0a::f00/0a::f1000000:0=2Y/0D000001@3L][820000
00@0gk:Y0P0000060>g4Z@T0000000@0ol]m0000000000000000603oool00`000000oooo0?ooo`0<
0?ooo`006@3oool00`000000oooo0?ooo`0V0?ooo`8000000P0107/00`0000006a^C01/KT`020000
0080DCjL00<0000005e?Z@1MCjT01@1MCjT01@000000NV2Y07YPZ@1jH:T0000000T0P6bb00<00000
099f/02BM[00202BM[020000000309En^0000000XhNf00X0XhNf0P0000020:>7]P030000002_SkH0
[hnf00`0[hnf00<000000;VH]P2iV;H01`2iV;H2000000@0^IRf00<000000<BR]P34X[H03@34X[H0
10000000cZfh0000000000050=2Y/0<0000000@0d:V`0000000000000000203L][8010000000gk:Y
0=nbZ@3O/ZT2000000@0kLBY3`00000H0?ooo`030000003oool0oooo00`0oooo000I0?ooo`030000
003oool0oooo02H0oooo0`000000100107/0000001/KT`0K6i<4000000T0GDnY0`00000:081//P03
0000002BM[00TWJ`00D0TWJ`0`00000409En^0030000002SQkH0XhNf00P0XhNf0P0000020:>7]P03
0000002_SkH0[hnf00`0[hnf00<000000;VH]P2iV;H0202iV;H2000000<0^IRf00<000000<BR]P34
X[H03034X[H00`000000cZfh0<j]^0020<j]^0D000000P3@ZK05000000T0g;Jb1@0000020>g4Z@P0
0000103mdi@5000001P0oooo00<000000?ooo`3oool0303oool001T0oooo00<000000?ooo`3oool0
9P3oool4000000<06a^C0`00000:05e?Z@0300000020K;80P6bb00X0P6bb00<00000099f/02BM[00
0P2BM[03000000L0UGjh00<000000:>7]P2SQkH0202SQkH200000080XhNf00<000000:n?]P2_SkH0
302_SkH00`000000^IRf0;VH]P080;VH]P8000000`2iV;H00`000000a::f0<BR]P0<0<BR]P030000
003>[KP0cZfh00<000000P3>[KP9000000/0g;Jb0`0000000`3]a:T0000000000005000000030>g4
Z@000000oM>D00@0oM>D1000000H0?ooo`030000003oool0oooo00`0oooo000I0?ooo`030000003o
ool0oooo02H0oooo00@000000000CP00000000000`0K6i<3000000T0GDnY0P00000=081//P040000
002BM[000000000000X0UGjh00<000000:>7]P2SQkH0202SQkH200000080XhNf00<000000:n?]P2_
SkH0302_SkH00`000000^IRf0;VH]P080;VH]P8000000`2iV;H00`000000a::f0<BR]P0<0<BR]P<0
0000203>[KP2000000050=2Y/0000000g;Jb0=bf/P0000002P3L][8700000080kLBY0P0000000`3]
a:T000000?gCU0040?gCU0@00000603oool00`000000oooo0?ooo`0<0?ooo`006@3oool2000002L0
oooo00<000000000CP000000100K6i<200000003030eYP000000GDnY00H0GDnY00@0000006MN]01W
G[@000003020K;82000000`0UGjh00<000000:>7]P2SQkH0202SQkH2000000<0XhNf00<000000:n?
]P2_SkH02`2_SkH00`000000^IRf0;VH]P080;VH]P8000000P2iV;H00`000000a::f0<BR]P0:0<BR
]P@000002@3>[KP5000000<0g;Jb00<000000=bf/P3L][801P3L][800`000000j<Nd000000030000
00@0kLBY0`0000000`3if:L000000?gCU0030?gCU0@00000603oool00`000000oooo0?ooo`0<0?oo
o`006@3oool00`000000oooo0?ooo`0V0?ooo`/000001P1MCjT01@000000Iejd06MN]01WG[@00000
00X0P6bb0`00000>09En^0030000002SQkH0XhNf00L0XhNf0P0000030:>7]P030000002_SkH0[hnf
00@0[hnf3`0000030;VH]P8000000P2iV;H00`000000a::f0<BR]P060<BR]P@000000P34X[H00`00
0000cZfh0<j]^0070<j]^0<000000P3>[KP300000080g;Jb00<000000=bf/P3L][801@3L][850000
00D0kLBY0`0000000`3if:L000000?gCU0030?gCU0040000003]be<00000000001T0oooo00<00000
0?ooo`3oool02`3oool001P0oooo00<000000?ooo`3oool09`3oool<000000@0GDnY00<0000006MN
]01WG[@00P1WG[@00`000000P6bb081//P07081//P0500000025M[X0QGJj08Ef^P0000003@2EO[P0
0`000000XhNf0:>7]P070:>7]P80000000<0XhNf0000000000001`0000070:nE_0030000002iWK`0
^Ifl00D0^Ifl2P0000030<BR]P<000001P34X[H00`000000cZfh0<j]^0060<j]^0@0000000<0cZfh
0000003I^KX00P3I^KX2000000030=bf/P000000g;Jb00@0g;Jb1@0000000`3Xak@0000000000004
0>g4Z@8000000P3if:L01@000000oM>D0?gCU0000000mmmk00<000006@3oool00`000000oooo0?oo
o`0;0?ooo`00603oool00`000000oooo0?ooo`0W0?ooo`@000000`0K6i<600000080GDnY00<00000
06MN]01WG[@0101WG[@00`000000P6bb081//P04081//P8000001025M[X00`000000UGjh09En^00;
09En^0030000002SQkH0XhNf00D0XhNf1@0000020:B>_@030000002_UK`0[iFl00/0[iFl00<00000
0;VM_02iWK`0202iWK`200000080^Ifl00<000000<:V_@32Y[d0100000080<BR]P030000003>[KP0
cZfh00H0cZfh0P0000030<j]^0030000003I^KX0fKVj00<0fKVj0P0000050=bf/PD000000`3Xak@0
10000000kLBY0>g4Z@3]a:T200000080nMRW00D000000?gCU03mdi@000000?OON`03000001T0oooo
00<000000?ooo`3oool02`3oool001P0oooo00<000000?ooo`3oool09`3oool3000000030000M`00
00006a^C00<000000P0`=JH4000000L0Iejd00<00000081//P20K;800P20K;82000000H0QGJj00<0
000009En^02EO[P0302EO[P00`000000XhNf0:>7]P0400000080Y8jm0P0000030:B>_@030000002_
UK`0[iFl00/0[iFl00<000000;VM_02iWK`0202iWK`200000080^Ifl0`0000040<:V_@D000000P34
X[H00`000000cZfh0<j]^0060<j]^0<000000`3>[KP00`000000fKVj0=Vi^P050=Vi^P80000000<0
g;Jb0000000000000P0000000`3Xak@00000000000040>S7]0030000003]a:T0kLBY008000000`3i
f:L010000000oM>D0000003ggg/3000001T0oooo00<000000?ooo`3oool02`3oool001P0oooo00<0
00000?ooo`3oool09`3oool3000000030000M`0000006a^C00<000000`0`=JH4000000H0Iejd00D0
0000081//P20K;80P6bb0000000908Ef^P030000002EO[P0UGjh00X0UGjh100000060:B>_@800000
0`2TS[d00`000000[iFl0:nE_00;0:nE_0030000002iWK`0^Ifl00P0^Ifl1@00000;0<:V_@@00000
1`3>[KP2000000<0cZfh00<000000=Vi^P3I^KX01`3I^KX500000080j<Nd0P0000050>S7]0@00000
0`3if:L010000000oM>D0000003ggg/3000001T0oooo00<000000?ooo`3oool02`3oool001P0oooo
00<000000?ooo`3oool09`3oool300000080001g00@00000030eYP00000000000`0`=JH00`000000
Iejd00000002000000H0Iejd0`00000:08Ef^P030000002EO[P0UGjh00L0UGjh0`0000000`2HQ[l0
00000:B>_@070:B>_@8000000`2TS[d00`000000[iFl0:nE_00;0:nE_0030000002iWK`0^Ifl00D0
^Ifl1@0000020;VM_00300000032Y[d0`ZJm00/0`ZJm00<000000<b`_`0000000P0000030<j]^0<0
00000`3>[KP00`000000fKVj0=Vi^P070=Vi^P@000000`3Xak@2000000H0j<Nd0P0000050?WHY`03
0000003ggg/0mmmk00<000006@3oool00`000000oooo0?ooo`0;0?ooo`00603oool2000002P0oooo
0`0000020000M`040000000`=JH00000000000<0<3FV00@0000006MN]01WG[@0Iejd0P00000506MN
]00300000025M[X0QGJj00X0QGJj00<0000009En^02EO[P00`2EO[P4000000D0V8Jo00<000000:B>
_@2TS[d01@2TS[d300000080Y8jm00<000000:nE_02_UK`02`2_UK`00`000000^Ifl0;VM_0020;VM
_0<000000`2iWK`2000000030;VM_0000000`ZJm00d0`ZJm00<000000<b`_`3</;l00P3</;l50000
00@0cZfh00<000000=Vi^P3I^KX01`3I^KX500000080j<Nd0P0000050>S7]0<000001@3if:L01000
0000mmmk0?OON`3ggg/2000001T0oooo00<000000?ooo`3oool02`3oool000@0oooo0P0000040?oo
o`030000003oool0oooo0080oooo0`0000050?ooo`030000003oool0oooo02T0oooo0P0000020000
M`040000000`=JH0<3FV00000080<3FV00<00000049;]@0000000`1WG[@300000080Iejd00<00000
06m[_@0000003025M[X00`000000UGjh00000002000000T0V8Jo00<000000:B>_@2TS[d01P2TS[d2
000000<0Y8jm00<000000:nE_02_UK`02P2_UK`00`000000^Ifl00000002000000D0^Ifl0`000000
0`2iWK`000000<:V_@0<0<:V_@030000003</;l0c;2o00D0c;2o1@0000000`3>[KP000000=Vi^P08
0=Vi^PD0000000<0hlVm0000003Xak@00P0000050>S7]0<000001@3if:L01@000000mmmk0?OON`3g
gg/0000001/0oooo00<000000?ooo`3oool02P3oool000<0oooo00@000000?ooo`3oool000002`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02T0oooo0P0000020000M`@000000P0`
=JH00`000000@T^e0000000406MN]080000000D0Iejd0000001_Jkd0Kf^m0000000<08Ef^P800000
302HQ[l00`000000Y8jm0:B>_@060:B>_@8000000`2TS[d00`000000[iFl0:nE_0080:nE_0@00000
202iWK`200000080^Ifl00<000000<:V_@32Y[d02`32Y[d00`000000c;2o0<b`_`050<b`_`800000
0`3</;l2000000P0fKVj0`0000000`3I^KX00000000000020>?9_@<00000103Xak@010000000lmZe
0000000000040?WHY`8000000`3ggg/00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00X0
oooo00030?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0Z0?ooo`030000000007L0001g00@0000000<0<3FV00000012BkD00P12BkD00`000000
Iejd06MN]00206MN]0<000000`1_Jkd00`000000QGJj08Ef^P0708Ef^P<000003P2HQ[l00`000000
Y8jm0:B>_@050:B>_@8000000`2TS[d00`000000[iFl0:nE_0050:nE_0<000000P2_UK`00`000000
^Ifl0;VM_0070;VM_08000000P2iWK`00`000000`ZJm0<:V_@0;0<:V_@030000003</;l0c;2o00@0
c;2o0`0000040<b`_`<000001@3I^KX3000000060=Vi^P000000hlVm0>?9_@000000hlVm0`000004
0>S7]0030000003cf[D0lmZe008000000`3if:L2000000<0mmmk00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0:0?ooo`000`3oool010000000oooo0?ooo`0000080?ooo`<000001@3oool0
0`000000oooo0?ooo`0Z0?ooo`030000000007L0001g00@0000000<0<3FV00000012BkD00P12BkD0
0`000000Iejd06MN]00206MN]0@000000P1_Jkd00`000000QGJj08Ef^P0608Ef^P0500000029Ol80
RGo208Uo`P0000003@2HQ[l00`000000Y8jm0:B>_@060:B>_@8000000P2TS[d00`000000[iFl0:nE
_0020:nE_1T000002`32Y[d00`000000c;2o0<b`_`040<b`_`800000103</;l010000000eKc20=Fl
`P3E_<8200000080fKVj0`0000020=Vi^P040000003SbKd0hlVm0>?9_@<0000000D0hlVm0000003X
ak@0j<Nd000000020??J]@<000000P3if:L00`000000n^ZI000000020?OON`8000006`3oool00`00
0000oooo0?ooo`0:0?ooo`000`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0:`3oool010000000001g0000000039L3000000D0@T^e00@00000
06MN]01WG[@000000P1_Jkd300000080Kf^m00<0000008Ef^P25M[X00`25M[X2000000@0RGo200<0
000009R6_`2HQ[l02`2HQ[l00`000000Y8jm0:B>_@060:B>_@/000001P2_Vl<00`000000^:;30;RR
``060;RR``8000000`2hX/<00`000000`J_40<6[a004000000H0`ZJm00<000000<b`_`3</;l01@3<
/;l2000000@0c;2o00<000000=Fl`P3E_<800`3E_<85000000030=Vi^P000000hlVm00@0hlVm0P00
00020>?9_@030000003Xak@000000080lmZe0P000000103cf[D000000?WHY`0000020?[ZV@040000
003ggg/00000000001/0oooo00<000000?ooo`3oool02P3oool000<0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02/0oooo0P000002000<U`<0
00001@12BkD00`000000Iejd0000000406m[_@8000000`1_Jkd01@000000QGJj08Ef^P25M[X00000
00L0RGo200<0000009R6_`2HQ[l02`2HQ[l00`000000Y8jm0:B>_@0;000000/0[i_300<000000;RR
``2hX/<01@2hX/<3000000<0^:;300<000000<6[a031Zl@01031Zl@400000080`ZJm00<000000<b`
_`3</;l0103</;l3000000<0c;2o00<000000=Fl`P3E_<801@3E_<8300000080fKVj00<000000>?9
_@3SbKd00P3SbKd3000000<0hlVm00<000000??J]@3cf[D00`0000000`3cf[D00000000000030?[Z
V@<00000703oool00`000000oooo0?ooo`0:0?ooo`00103oool2000000T0oooo100000040?ooo`03
0000003oool0oooo02/0oooo0P000003000<U`8000001P12BkD00`000000Kf^m06m[_@0406m[_@80
00000P1_Jkd010000000QGJj00000000000808Uo`P030000002HQ[l0V8Jo00X0V8Jo100000040:FD
a0H00000302_Vl<00`000000^:;30;RR``050;RR``8000000`2hX/<00`000000`J_40<6[a0090<6[
a0@000001@3</;l2000000@0c;2o00<000000=Fl`P3E_<801@3E_<82000000030=Fl`P0000000000
00D0hlVm0`0000020>?9_@8000000P3cf[D2000000<0lmZe00@000000?[ZV@3jjYT0n^ZI0`00000L
0?ooo`030000003oool0oooo00X0oooo000F0?ooo`030000003oool0oooo02`0oooo0P000003000<
U`8000001P12BkD2000000H0Kf^m0P00000206m[_@0300000029Ol80RGo200T0RGo200<0000009R6
_`2HQ[l01P2HQ[l30000000309Z>aP000000YIC40080YIC40`0000030:FDa0@000002`2_Vl<00`00
0000^:;30;RR``040;RR``<000000`2hX/<00`000000`J_40<6[a00;0<6[a00300000039]<H00000
008000000P3</;l2000000<0c;2o00<000000=Fl`P3E_<801@3E_<83000000040=Fl`P000000g/_5
000000@0hlVm0P0000001`3SbKd000000>?9_@000000kM_00000003cf[D00P0000020??J]@800000
0`3jjYT00`000000]Khk0000000M0?ooo`030000003oool0oooo00T0oooo000F0?ooo`030000003o
ool0oooo02d0oooo00@00000000<U`0039L000bG0`000004049;]@030000001AGL40000000H0Kf^m
100000000`1gMlH0000008Uo`P0908Uo`P030000002HQ[l0V8Jo00<0V8Jo0`00000509Z>aP<00000
1`2UU<@3000000`0[i_300<000000;RR``2hX/<00P2hX/<3000000@0^:;300<000000<6[a031Zl@0
2P31Zl@00`000000bKC60<VdaP030<VdaP@000000`3</;l00`000000eKc20=Fl`P040=Fl`P<00000
0P3E_<8010000000g/_50=k;a@0000020>?9_@<000000P3SbKd01@000000kM_00>gK`0000000lmZe
008000000P3cf[D2000000<0n^ZI0P00000N0?ooo`030000003oool0oooo00T0oooo000F0?ooo`03
0000003oool0oooo02d0oooo00@00000000<U`0039L000bG0`000004049;]@040000001AGL40DEg1
000000H0Kf^m0P00000207MgaP0300000029Ol80RGo200T0RGo200<0000009R6_`0000000P000004
09Z>aPD000002P2UU<@3000000/0[i_300@000000;RR``2hX/<0^:;30`0000050;RR``0300000031
Zl@0`J_400X0`J_400<000000<VdaP39]<H01@39]<H3000000030<b`_`000000eKc200H0eKc20P00
00020=Fl`P030000003NblD0g/_50080g/_500@000000>?9_@00000000000`3SbKd200000080kM_0
0`000000103cf[D000000?O^/00000030?[ZV@8000007P3oool00`000000oooo0?ooo`090?ooo`00
5P3oool00`000000oooo0?ooo`0]0?ooo`040000000039L000bG000<U`<000000`12BkD01@000000
DEg1055M`@1AGL40000000H0Kf^m0`00000207MgaP0300000029Ol80RGo200P0RGo20P00000409Z>
aP<00000102JS/H00`000000YIC40:FDa0090:FDa0<000002P2_Vl<00`000000^:;30;RR``030000
00H0^:;300<000000<6[a031Zl@02@31Zl@00`000000bKC60<VdaP050<VdaP<0000000<0bKC60000
000000001P3E_<8300000080eKc200<000000=k;a@3NblD00`3NblD300000080hlVm00D000000>gK
`03]fl0000000>gK`00200000080lmZe00<000000?O^/00000000P3jjYT3000001h0oooo00<00000
0?ooo`3oool02@3oool001H0oooo00<000000?ooo`3oool0;P3oool00`00000000bG000<U`030000
00<0@T^e00<00000055M`@1AGL400P1AGL400`000000Kf^m06m[_@0206m[_@030000001gMlH00000
0080000000<0MgO600000029Ol801`29Ol820000000308f8b@000000VXk600<00000202JS/H00`00
0000YIC40:FDa0090:FDa0@00000202_Vl<5000000H0^:;300<000000<6[a031Zl@02P31Zl@00`00
0000bKC60<VdaP050<VdaP8000000P39]<H010000000dKo90000000000040=Fl`P<0000000<0eKc2
0000003NblD01@3NblD3000000030>?9_@000000kM_00080kM_000H000000>gK`000000000000??J
]@0000030?O^/0040000003jjYT00000000001l0oooo00<000000?ooo`3oool02@3oool001H0oooo
00<000000?ooo`3oool0;P3oool00`00000000bG0000000200P][`80000000<0@T^e0000001AGL40
1@1AGL4010000000Kf^m06m[_@00000307MgaP8000000P1gMlH00`000000RGo208Uo`P0308Uo`P80
00000P2=R<T3000000/0VXk600<000000:FDa02UU<@02@2UU<@00`000000[i_30000000?000000D0
^:;300<000000<6[a031Zl@02@31Zl@00`000000bKC60<VdaP060<VdaP8000000P39]<H010000000
dKo90=6ob@3A_lT200000080eKc20P0000020=Fl`P030000003NblD0g/_500<0g/_5100000000`3S
bKd000000>gK`0030>gK`0<0000000<0lmZe0000003gk[000P3gk[04000001l0oooo00<000000?oo
o`3oool02@3oool001D0oooo00<000000?ooo`3oool0;`3oool30000008022f_0P0000000`12BkD0
0000055M`@05055M`@030000001_Jkd0000000D0MgO60P00000207MgaP0400000029Ol80RGo208Uo
`PD000000P2=R<T00`000000VXk609Z>aP0909Z>aP030000002UU<@0YIC400L0YIC4400000040;NW
b@P000002@31Zl@00`000000bKC60<VdaP060<VdaP80000000<0bKC60000003A_lT01@3A_lT40000
00030=Fl`P000000g/_500D0g/_50P0000020=k;a@030000003]fl00kM_00080kM_00`0000000`3]
fl0000000?O^/0030?O^/0@000007`3oool00`000000oooo0?ooo`090?ooo`005@3oool200000340
oooo0P00000300P][`800000201AGL400`000000MgO607MgaP0507MgaP80000000<0MgO600000029
Ol800`00000608f8b@030000002JS/H0VXk600X0VXk600<000000:FDa02UU<@01P0000020:JKb`03
0000002_XLT0[j7900T0[j7900<000000;NWb@2gYlT0202gYlT00`000000_Zo:0;j_bP0600000080
`J_400<000000<VdaP39]<H02039]<H3000000L0dKo90`0000000`3E_<8000000=k;a@040=k;a@<0
000000@0g/_50000003VflX000000`3]fl05000000@0mnj`00<000000<oNKP000000803oool00`00
0000oooo0?ooo`090?ooo`005@3oool00`000000oooo0?ooo`0`0?ooo`8000000`08;Jl3000000H0
DEg100<0000005i]bP0000001P1gMlH5000000X0SHS900<0000009Z>aP2JS/H0202JS/H4000000P0
YY_;00<000000:nQb@2_XLT02@2_XLT00`000000]jO90;NWb@080;NWb@030000002n[lX0_Zo:00H0
_Zo:100000090<VdaP800000203A_lT2000000030=6ob@000000g/_500@0g/_50`0000001@3NblD0
00000>KKbP3VflX0000000<0kM_00P0000000`3]fl000000000000040?O^/0<000008@3oool00`00
0000oooo0?ooo`080?ooo`005@3oool00`000000oooo0?ooo`0`0?ooo`<000000P08;Jl3000000H0
DEg100<0000005i]bP0000001@1gMlH50000000307f2c@000000SHS900T0SHS900<0000009Z>aP2J
S/H00`2JS/H40000000309bFc@000000YY_;00X0YY_;00<000000:nQb@2_XLT0202_XLT00`000000
]jO90;NWb@080;NWb@030000002n[lX0_Zo:00P0_Zo:00<000000<Jgc00000000P0000060<VdaP80
00001`3A_lT4000000030=W<c@000000g/_50080g/_50`0000000`3NblD000000>KKbP030>KKbP03
0000003]fl00000000<0000000<0lNo10000003gk[000P3gk[0300000280oooo00<000000?ooo`3o
ool0203oool001D0oooo00<000000?ooo`3oool0<@3oool2000000<022f_0`000004055M`@060000
001NKLX0GVg:05i]bP000000MgO60`00000207MgaP8000000P1mP/d00`000000SHS908f8b@0808f8
b@030000002JS/H0VXk600<000001P2LU/d00`000000YY_;0:JKb`080:JKb`030000002_XLT0[j79
00P0[j7900<000000;NWb@2gYlT0202gYlT00`000000_Zo:0;j_bP070;j_bP0300000036]l`0a[O<
00<0a[O<100000020<VdaP<000001P3A_lT3000000<0fLc=00<000000=k;a@0000000`0000000`3N
blD000000>KKbP030>KKbP030000003]fl000000008000000P3akl4200000080mnj`0`00000R0?oo
o`030000003oool0oooo00P0oooo000E0?ooo`030000003oool0oooo0340oooo0`00000200P][`80
000000<094W00000001AGL400P1AGL400`000000GVg:00000003000000@0MgO61000000207f2c@03
0000002=R<T0SHS900P0SHS90P00000909bFc@030000002VVl/0YY_;00P0YY_;00<000000:nQb@2_
XLT0202_XLT00`000000]jO90;NWb@070;NWb@030000002n[lX0_Zo:00P0_Zo:00<000000<Jgc036
]l`01`36]l`2000000030=6ob@000000000000H0dKo90P0000050=W<c@@0000000<0g/_50000003V
flX01@3VflX3000000@0lNo1100000000`3?gVh000000?ooo`0Q0?ooo`030000003oool0oooo00P0
oooo000D0?ooo`030000003oool0oooo0380oooo0`0000000`08;Jl0000002A9`0020000000302A9
`0000000DEg100<00000101NKLX010000000MgO607MgaP00000207f2c@8000000P1mP/d00`000000
SHS908f8b@0608f8b@80000000<0TI7@0000002LU/d0202LU/d00`000000YY_;0:JKb`080:JKb`03
0000002_XLT0[j7900P0[j7900<000000;NWb@2gYlT01`2gYlT00`000000_Zo:0;j_bP080;j_bP03
00000036]l`0a[O<00L0a[O<00<000000<g1c`0000000`0000050=6ob@800000103Ic<d400000003
0=k;a@000000i]_:00D0i]_:100000040?7_`@D000008`3oool00`000000oooo0?ooo`080?ooo`00
503oool00`000000oooo0?ooo`0c0?ooo`0400000000098000000000008094W01@00000605i]bP03
0000001gMlH0000000<0OH;=0P00000307f2c@030000002=R<T0SHS900<0SHS90P000003096Ad003
0000002LU/d0W9K=00P0W9K=00<000000:JKb`2VVl/0202VVl/00`000000[j790:nQb@070:nQb@03
0000002gYlT0]jO900L0]jO900<000000;j_bP2n[lX01`2n[lX00`000000a[O<0<Jgc0080<Jgc004
0000003=`Ll0cL7?0<g1c`<00000103A_lT200000080fLc=1@0000000`3Ic<d000000>KKbP050>KK
bP@000001@3akl42000000030=kbU`000000000002<0oooo00<000000?ooo`3oool0203oool001@0
oooo0P00000d0?ooo`03000000000980000000D0000000<094W00000001NKLX01`1NKLX00`000000
OH;=07f2c@0207f2c@800000101mP/d01@000000SHS908f8b@2=R<T0000000H0TI7@00<0000009bF
c@2LU/d01`2LU/d00`000000YY_;0:JKb`080:JKb`030000002_XLT0[j790080[j792P0000050;NW
b@030000002n[lX0_Zo:00L0_Zo:00<000000<Jgc036]l`01`36]l`00`000000cL7?0<g1c`030<g1
c`@0000000<0dKo90000000000001P0000020=W<c@030000003Ofm80000000D0i]_:100000050?7_
`@030000003NlYL0g_:G008000008`3oool00`000000oooo0?ooo`080?ooo`00503oool00`000000
oooo0?ooo`0c0?ooo`@000000`0TBL04000000L0GVg:0P00000407f2c@8000000`1mP/d010000000
SHS9000000000007096Ad0030000002LU/d0W9K=00L0W9K=00<000000:JKb`2VVl/01P2VVl/70000
00D0[ZO@00<000000;F]d02e[M000P2e[M0:000000@0_Zo:00<000000<Jgc036]l`02036]l`00`00
0000cL7?0<g1c`040<g1c`/000000P3Ic<d010000000gm_B0=oKdP0000040>KKbP<0000000<0j^k>
0000003akl400`3akl42000000040=kbU`0000000000000002@0oooo00<000000?ooo`3oool01`3o
ool001@0oooo00<000000?ooo`3oool0<03oool3000000030?ooo`000000002B008000000`0TBL02
0000000303YPcP000000GVg:00@0GVg:00@0000006UkdP1YNm8000000`1mP/d2000000@0OH;=00<0
0000096Ad02ATM00202ATM000`000000W9K=09bFc@0709bFc@030000002VVl/0YY_;00D000000P2V
X]400`000000[ZO@0:jWd0070:jWd0030000002e[M00]Jg@00L0]Jg@00<000000;bcd@2l/m400P2l
/m46000000P0a[O<00<000000<g1c`3=`Ll01`3=`Ll6000000@0fLc=00<000000=oKdP3Ofm800P3O
fm800`000000i]_:0>KKbP0300000080j^k>00<000000?7_`@3akl400P3akl42000000050=kbU`00
0000oooo0?ooo`0000008`3oool00`000000oooo0?ooo`070?ooo`00503oool00`000000oooo0?oo
o`0]0?ooo`<00000103oool01@000000002B00000000:K<00000008094W00`0000000`0jH<h00000
05i]bP0305i]bP050000001YNm80JG_B06UkdP0000000P1mP/d2000000<0OH;=00<0000008B=e000
00002P2ATM000`000000W9K=09bFc@0409bFc@D000001`2VX]400`000000[ZO@0:jWd0070:jWd003
0000002e[M00]Jg@00L0]Jg@00<000000;bcd@2l/m401P2l/m4010000000`[_C0000000000050<Jg
c0030000003=`Ll0cL7?00P0cL7?00<000000=?=e03CcM@00`0000040=W<c@030000003Ofm80gm_B
0080gm_B1P0000020>[^cP040000003akl40lNo10?7_`@80000000<0g_:G0000000000000`3oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00L0oooo000C0?ooo`030000003oool0oooo
02/0oooo0`0000080?ooo`0400000000098000000000008094W00`00000203YPcP040000001NKLX0
GVg:000000@0JG_B00<0000007f2c@1mP/d00P0000000`1mP/d000000000000308B=e0030000002A
TM00TI7@00L0TI7@00<0000009bFc@2LU/d01000000209jMd`030000002VX]40YZ;A00P0YZ;A00<0
00000:jWd02^Ym001P2^Ym000`000000]Jg@0;F]d0060;F]d0030000002l/m40_;?A00H0_;?A00<0
00000<:kd`32^m<00P32^m<300000080a[O<00<000000<g1c`3=`Ll01`3=`Ll00`000000dlgD0=?=
e0020=?=e08000000`3Ic<d00`000000gm_B0=oKdP030=oKdPD00000103Zk/h010000000lNo10000
003SnkD4000000@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`070?ooo`004`3o
ool00`000000oooo0?ooo`0W0?ooo`@000002`3oool020000000002B00000000:K<0000002A9`000
0000>V3>0P00000203YPcP030000001NKLX0000000D0JG_B00<0000007f2c@0000000P00000608B=
e0030000002ATM00TI7@00L0TI7@0P00000709jMd`030000002VX]40YZ;A00L0YZ;A00<000000:jW
d02^Ym001P2^Ym000`000000]Jg@0;F]d0060;F]d0030000002l/m40_;?A00H0_;?A00<000000<:k
d`32^m<01@32^m<2000000T0cL7?00<000000=?=e03CcM@00`3CcM@3000000030=W<c@000000gm_B
00<0gm_B1P0000050>[^cP8000000P3SnkD3000000H0oooo00<000000?ooo`3oool07P3oool00`00
0000oooo0?ooo`070?ooo`004`3oool00`000000oooo0?ooo`0T0?ooo`<00000403oool200000080
02Vc0P00000203YPcP8000000P0jH<h00`000000JG_B06UkdP0506UkdP<000001`24SM@00`000000
TI7@096Ad005096Ad080000000<0U9[G0000002NWM<01P2NWM<00`000000YZ;A0:JRd@070:JRd@03
0000002^Ym00[ZO@00H0[ZO@00<000000;F]d02e[M001P2e[M000`000000_;?A0;bcd@050;bcd@03
00000032^m<0`[_C00H0`[_C00@000000<O3eP00000000001P3=`Ll00`000000dlgD0=?=e0050=?=
e0@0000000<0gm_B000000000000100000000`3Ofm8000000>[^cP050>[^cP80000000<0ho^e0000
000000000P0000060?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool01`3oool001<0
oooo00<000000?ooo`3oool08@3oool3000001@0oooo00D00000000Y/`00:K<002Vc0000000303YP
cPD000001`1YNm82000000P0Q8gD00<00000096Ad02ATM000P2ATM02000000<0U9[G00<0000009jM
d`2NWM<01P2NWM<00`000000YZ;A0:JRd@060:JRd@030000002^Ym00[ZO@00H0[ZO@00<000000;F]
d02e[M001P2e[M000`000000_;?A0;bcd@050;bcd@0300000032^m<0`[_C00H0`[_C00@000000<O3
eP37`mH0al?F0P0000040<g1c`030000003CcM@0dlgD00H0dlgD2@0000000`3Ofm80000000000006
0>[^cP030000003SnkD0000000<00000203oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo00L0oooo000C0?ooo`8000007`3oool3000001L0oooo0P000002000Y/`8000000`0jH<h30000
000304icf0000000JG_B00@0JG_B0`00000908B=e0040000002ATM000000000000H0U9[G00<00000
09jMd`2NWM<01@2NWM<00`000000YZ;A0:JRd@070:JRd@030000002^Ym00[ZO@00D0[ZO@00<00000
0;F]d02e[M001@2e[M000`000000_;?A0;bcd@050;bcd@0300000032^m<0`[_C00H0`[_C00<00000
0<O3eP37`mH01037`mH2000000030<g1c`000000dlgD00L0dlgD00<000000=OIf@3GfMT010000003
0=oKdP030000003RjmL0000000D0j^k>1P00000:0?ooo`030000003oool0oooo01d0oooo00<00000
0?ooo`3oool01P3oool001<0oooo00<000000?ooo`3oool06P3oool4000001/0oooo00@00000000Y
/`00:K<002Vc0P00000403YPcP@000000`1YNm830000000307>8fP000000Q8gD00P0Q8gD00<00000
09BJe`2DV]L01P2DV]L00`000000WYgC09jMd`0609jMd`030000002VX]40YZ;A00@0YZ;A5P000004
0;bcd@0300000032^m<0`[_C00H0`[_C00<000000<O3eP37`mH01P37`mH00`000000dlgD0=?=e006
0=?=e0030000003GfMT0emWI0080emWI00<000000=oKdP3Ofm800P3Ofm8010000000h^_G0>;[e`00
00030>[^cPL00000303oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00H0oooo000B
0?ooo`030000003oool0oooo01P0oooo0`00000P0?ooo`0600000000:K<002Vc00000006C<X00000
0P0jH<h00`000000CW?H0000000800000080LhSJ0P00000608B=e00300000029Um/0000000P0U9[G
00<0000009jMd`2NWM<01@2NWM<00`000000YZ;A0:JRd@0400000080YZWH00<000000:f]e`2][ML0
1@2][ML00`000000/k;G0;>be`050;>be`040000002h^=P0^;SH0;Rhf0D000001`32^m<00`000000
al?F0<O3eP060<O3eP030000003<cMX0000000H0dlgD00<000000=OIf@3GfMT0103GfMT010000000
gm_B0=oKdP0000040>;[e`030000003Zk/h000000080h_g;1000000>0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool01P3oool00180oooo00<000000?ooo`3oool05@3oool3000002<0
oooo0P0000001`00:K<0000000I<bP06C<X0000003YPcP0000000`1>LmP6000000D0LhSJ00@00000
08B=e024SM@0Q8gD0P00000308VGf`030000002DV]L0U9[G00H0U9[G00<0000009jMd`2NWM<0102N
WM<3000000H0YZWH00<000000:f]e`2][ML01@2][ML00`000000/k;G0;>be`050;>be`030000002h
^=P0^;SH00@0^;SH00@000000;fnfP00000000001032^m<00`000000al?F0<O3eP060<O3eP040000
003<cMX0c<gJ0<c=fP8000000`3CcM@00`000000emWI0=OIf@050=OIf@030000003Ofm80000000D0
h^_G0P0000020>;mb`@000003`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00H0
oooo000B0?ooo`030000003oool0oooo0180oooo0`00000W0?ooo`<000000`06C<X2000000H0CW?H
00<0000007>8fP1cR=X01P1cR=X00`000000Q8gD0000000608VGf`030000002DV]L0U9[G00D0U9[G
00<0000009jMd`2NWM<01000000209nVfP030000002VZMP0YZWH00D0YZWH00<000000:f]e`2][ML0
102][ML00`000000/k;G0;>be`040;>be`030000002h^=P0^;SH00@0^;SH00<000000;fnfP2m_]X0
0P2m_]X200000080`[_C00<000000<O3eP37`mH01@37`mH00`000000c<gJ0<c=fP040<c=fP030000
003CcM@0000000T0emWI00<000000>;[e`3RjmL0103RjmL00`000000h_g;0>;mb`0400000140oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`060?ooo`004P3oool00`000000oooo0?oo
o`0>0?ooo`@00000:`3oool3000000<01Tc:00<0000004icf01>LmP0101>LmP2000000P0LhSJ00<0
000008VGf`29Um/01P29Um/00`000000U9[G09BJe`0509BJe`8000001P2OY]X00`000000YZWH0:JY
f0050:JYf0030000002][ML0[JgG00@0[JgG00<000000;>be`2c/]L0102c/]L00`000000^;SH0;Rh
f0040;Rhf0030000002m_]X0_KkJ00@0_KkJ0`0000060<O3eP030000003<cMX0c<gJ00H0c<gJ00<0
00000=OIf@3GfMT01P3GfMT3000000D0h^_G0P0000000`3RoL/000000000000300000180oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`060?ooo`004P3oool00`000000oooo0?ooo`0;
0?ooo`<00000<03oool2000000<01Tc:0P00000504icf0030000001NQ=l0000000H0LhSJ00<00000
07bEh00000002029Um/00`000000U9[G09BJe`0209BJe`80000000<0V:?M0000002OY]X01P2OY]X0
0`000000YZWH0:JYf0040:JYf0030000002][ML0[JgG00@0[JgG00<000000;>be`2c/]L0102c/]L0
0`000000^;SH0;Rhf0040;Rhf0030000002m_]X0_KkJ00@0_KkJ00<000000<;5g@32aMd00`000002
0<O3eP030000003<cMX0c<gJ00H0c<gJ00<000000<oHg`0000001@3GfMT200000080fNOO00<00000
0>;[e`3RjmL00P3RjmL00`000000g?[J00000005000001@0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`060?ooo`004P3oool2000000T0oooo0`00000c0?ooo`030000000008P00000
00801Tc:00<0000002MXfP000000101>LmP00`000000GXCO05j4g`02000000@0LhSJ00<0000007bE
h01lUN000P00000708VGf`040000002DV]L00000000000@0V:?M00<0000009nVfP2OY]X0102OY]X0
0`000000YZWH0:JYf0040:JYf0030000002][ML0[JgG00@0[JgG00<000000;>be`2c/]L0102c/]L0
0`000000^;SH0;Rhf0030;Rhf0030000002m_]X0_KkJ00@0_KkJ00<000000<;5g@32aMd01032aMd2
000000P0c<gJ00@000000<oHg`3?f=l00000103GfMT00`000000fNOO0=WWg`020=WWg`050000003R
jmL0h^_G0>;[e`0000000P3Ln]X6000001D0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`050?ooo`002@3oool4000000@0oooo0P0000070?ooo`<00000=`3oool30000000400I<bP00
00009fSJ02MXfP80000000<0CW?H0000001NQ=l0101NQ=l010000000LhSJ07>8fP00000507bEh003
00000029Um/0RIOK00D0RIOK00<0000009RSg@2HXmd01@2HXmd00`000000WjKJ09nVfP0409nVfP03
0000002VZMP0YZWH00@0YZWH00<000000:f]e`2][ML01P0000030;>be`030000002h^=P0^;SH00@0
^;SH00<000000;fnfP2m_]X0102m_]X00`000000`/GM0<;5g@040<;5g@0300000035cN40000000D0
c<gJ0P0000040<oHg`040000003GfMT00000000000H0fNOO00<000000>;[e`0000000P3Ln]X70000
01D0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`050?ooo`002`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0080oooo1000000k0?ooo`<0000000<01Tc:0000000W
J=X00P0WJ=X2000000H0GXCO00<0000007>8fP0000001P1lUN000`000000RIOK08VGf`0208VGf`80
000000<0Sj7Q0000002HXmd01P2HXmd00`000000WjKJ09nVfP0309nVfP040000002VZMP0YZWH0:JY
f0H000000`2[]=l00`000000/;SO0;2hg`06000000<0^;SH00<000000;fnfP2m_]X0102m_]X00`00
0000`/GM0<;5g@040<;5g@0500000035cN40aLgQ0<G=h@0000000`3<cMX00`000000cmSO0<oHg`05
0<oHg`030000003Iiml0fNOO00H0fNOO0P0000020=cjfPL000005`3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo00D0oooo000;0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`0000000P0000100?ooo`@00000100WJ=X00`000000GXCO05j4g`0505j4g`030000001lUN00O9GP
00H0O9GP0P0000000`29Um/0000008nQh@0308nQh@030000002HXmd0V:?M00D0V:?M00@0000009nV
fP2OY]X0WjKJ1@0000030:Jah0030000002[]=l0ZkCO00<0ZkCO00<000000;2hg`2`^=l00`2`^=l0
0`000000];cP0;Blh006000000<0_KkJ00<000000<;5g@32aMd00`32aMd2000000D0aLgQ00<00000
0<c=fP0000001P3?f=l3000000P0fNOO00<000000=cjfP3Ln]X01`00000I0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool01@3oool000/0oooo00<000000?ooo`3oool00`3oool20000
04@0oooo0`00000402MXfP<000001@1NQ=l3000000P0O9GP00<0000008nQh@2?XN40102?XN420000
00H0V:?M0`0000030:6^h@030000002V/N00Y[7P00<0Y[7P00<000000:^dg`2[]=l00P2[]=l00`00
0000/;SO0;2hg`020;2hg`030000002d_>00];cP00<0];cP00@000000;S1h@2h`N40^<7Q0`000005
0<;5g@0300000035cN40aLgQ00H0aLgQ00<000000<oHg`3?f=l0103?f=l01@000000d>?U0=3Si@3@
hnD0000000D0fNOO0`0000000`3Ln]X0000000000005000001/0oooo00<000000?ooo`3oool05@3o
ool00`000000oooo0?ooo`050?ooo`002`3oool00`000000oooo0?ooo`040?ooo`<00000@`3oool0
1000000002fb00000000000302MXfP0300000013On@0000000@0GXCO00@0000006fCiP1]TnH00000
1P1lUN0010000000QJ3U00000000000608nQh@040000002HXmd0V:?M09RSg@80000000<0VZgT0000
002Q[^400`2Q[^400`000000Y[7P0:Jah0030:Jah0030000002[]=l0ZkCO0080ZkCO00<000000;2h
g`2`^=l00P2`^=l00`000000];cP0;Blh0030;Blh0030000002h`N40^<7Q0080^<7Q00@000000;[6
i000000000000P32aMd00`000000aLgQ0<G=h@050<G=h@80000000<0amGU0000003?f=l00`3?f=l0
0`000000d>?U0=3Si@020=3Si@040000003Iiml0fNOO0=WWg`8000000P3EmN@5000000030;ch]P00
0000000001d0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`050?ooo`002@3oool3
000000P0oooo00<000000?ooo`3oool0@P3oool01000000002fb00000000000202MXfP0300000013
On@0@goT008000000P1NQ=l010000000KI?V06fCiP1]TnH2000000@0O9GP00D0000008FPi@25X>D0
QJ3U0000000608nQh@030000002HXmd0000000@0VZgT00<000000:6^h@2Q[^400P2Q[^400`000000
Y[7P0:Jah0020:Jah0030000002[]=l0ZkCO0080ZkCO00<000000;2hg`2`^=l00P2`^=l00`000000
];cP0;Blh0020;Blh0030000002h`N40^<7Q0080^<7Q00<000000;[6i02ja^@00P2ja^@2000000H0
aLgQ0P0000040<OEi@040000003?f=l00000000000H0d>?U0`0000030=Gei0030000003Ln]X00000
00D000007P3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00D0oooo000;0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool0@@3oool300000004001Gd@0000009fSJ0000
00@0@goT0`00000506fCiP80000000<0O9GP00000025X>D01025X>D2000000D0Sj7Q00<0000009Z]
i02J[N@0102J[N@00`000000XJkQ0:6^h@020:6^h@030000002V/N00Y[7P0080Y[7P00D000000:^d
g`2[]=l0ZkCO000000030;2hg`030000002d_>00];cP0080];cP00<000000;S1h@2h`N400P2h`N40
0`000000^/KT0;[6i0030;[6i0030000002lc>H0000000@0aLgQ00<000000<OEi@37eND01@37eND0
0`000000d>?U0=3Si@050=3Si@8000001@3EmN@700000200oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`050?ooo`005P3oool200000480oooo0`0000001000Em400000000000000005
04=oi0030000001]TnH0KI?V00D0KI?V00<0000008FPi@25X>D01P25X>D20000000408nQh@000000
000009B/i`8000001@2J[N@01@000000XJkQ0:6^h@2Q[^4000000080Y[7P300000030;Blh0050000
002h`N40^<7Q0;S1h@0000001@2ja^@01P000000_<cV0;c<iP2lc>H000000<G=h@8000001P37eND3
000000D0d>?U0P0000000`3<k^/000000=Gei0040=Gei0H000008P3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo00@0oooo000H0?ooo`800000@@3oool30000008005OA0P00000404=o
i0<000001@1]TnH010000000NZ3[00000000000708FPi@030000002D[>L0U:cW00<0U:cW00<00000
09Z]i02J[N@00`2J[N@00`000000XJkQ0:6^h@0300000080YKWX00D000000:Rki`2X^nL0Z;_W0000
00030:^ni`030000002^`NP0000000<000000P2h`N400`000000^/KT0;[6i0020;[6i0800000102l
c>H2000000H0amGU0P0000020<KNjP040000003@hnD0d>?U0=3Si@8000000`3<k^/010000000eOGT
0=Gei03EmN@7000002@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`040?ooo`00
6@3oool200000440oooo0`000002001Gd@<000000P13On@00`000000FI7[05VAj`02000000<0KI?V
00@0000007ZPj`1jX>/0NZ3[0P00000408FPi@040000002=[>X00000000000@0U:cW00<0000009Z]
i02J[N@00`2J[N@200000080XKSY00D000000:Fij02U^NP0YKWX000000020:Rki`040000002[_^L0
ZkkW000000<0[/7X00<000000;34j@2`a>T00P0000040;[6i0030000002lc>H0_<cV0080_<cV0P00
00020;gBjP0400000037eND0amGU0<OEi@8000001@36g^X3000000@0c>k[00<000000=Gei03EmN@0
2000000V0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0103oool001/0oooo00<0
00000?ooo`3oool0?`3oool300000004001Gd@0000007gOT01mgi080000000<0@goT0000001ITN/0
0P1ITN/3000000H0NZ3[0P00000208FPi@040000002=[>X0SJcZ08f/jP8000000`2D[>L200000005
09Z]i0000000000009fgj`0000000P2Q^>T01@000000YKWX0:Fij02U^NP000000080Z;_W00@00000
0:^ni`2[_^L000000`2^`NP01@000000/<CY0;34j@000000//OZ0080000000<0^/KT0000002lc>H0
0P2lc>H2000000@0_M;Z00@000000<OEi@00000000001P36g^X2000000H0c>k[0`0000000`35oN@0
000000000004000002P0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`040?ooo`00
703oool200000440oooo1000000301mgi08000001@1ITN/00`000000NZ3[07ZPj`0607ZPj`800000
1P2=[>X200000080U:cW0P00000409fgj`040000002Q^>T0XKSY00000080YKWX00@000000:Rki`2X
^nL000000P2[_^L010000000[/7X0:k1j00000020;34j@030000002banX0//OZ0080//OZ00<00000
0;c<iP2lc>H00P0000060;gBjP8000001P36g^X2000000030<?Vk`000000c>k[00@0c>k[0P000002
0<Gmi0H00000:@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00@0oooo000C0?oo
o`@000001`3oool200000400oooo0`00000501mgi0<000000P1ITN/00`000000KJ7`000000020000
00D0NZ3[00@0000008F/kP00000000001@2=[>X200000080VKK/0P00000309fgj`040000002Q^>T0
XKSY00000080YKWX00D000000:Rki`000000ZkkW000000020:k1j0040000002`a>T0/<CY000000<0
//OZ0P0000000`2bbn`00000000000050;gBjP<0000000<0_=S^00000036g^X00`36g^X2000000<0
`nK_00<000000<c^j`3<k^/0100000020<Gmi0H00000:`3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00@0oooo000E0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
?`3oool4000000<07gOT00<0000004>@k`13T>l00P0000000`1ITN/0000006fQl00206fQl0<00000
00<0NZ3[00000025[>h00`25[>h300000080SJcZ00@0000009Bgk`00000000000P2I]^`200000080
WKO[00@000000:6hj@000000YKWX1P0000020:k1j0030000002`a>T000000080//OZ0P0000000`2b
bn`00000000000020;;?k`030000002md^X0_M;Z008000001@2lf>h010000000a]kZ000000000004
0<?Vk`040000003<k^/00000000000<0`OK_2000000]0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0103oool001D0oooo00<000000?ooo`3oool0203oool200000440oooo10000002
01mgi00400000013T>l0@i3_04>@k`8000001P1]XO02000000L0QJc^0P00000409Bgk`8000000P2I
]^`20000000909fgj`00000000000000002R`o0000000:?3l0000000Y<C`00D0000000@0//OZ0000
00000000//_/0P0000040;;?k`<000001@2lf>h4000000@0`nK_100000040<7fk`L00000<03oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<0oooo000=0?ooo`@00000103oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo03l0oooo1P00000504>@k`<00000101]XO000`00
0000OJkb07f^lP0400000080QJc^00<00000092gl@0000000P00000209Bgk`8000000P2I]^`50000
00050:;3l000000000000000002UaO001@0000000`2bbn`00000000000030;;?k`<0000000@0/M;a
0000002lf>h0_=S^100000020;WNlP0300000033i^l0000000<000000P2kk?@010000000`OK_0<7f
k`31m^l2000000030:CgfP000000000000800000<`3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo00<0oooo000E0?ooo`030000003oool0oooo00/0oooo0P0000100?ooo`L000000`13
T>l00`000000Gj;d05nRm0030000000306fQl0000000OJkb00D0OJkb0`000004092gl@<0000000D0
U;O_000000000000000009g2lP0>00000080//o_0`0000020;7Bl@D00000102ig_84000000D0^ncd
00<000000<7fk`31m^l02000000d0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
0`3oool001<0oooo0`00000>0?ooo`800000@@3oool300000003001/f0000000000000@00000101O
X_@6000000@0OJkb00<0000008bim02<^O@0100000000`2@]o4000000000000C000000030;7Bl@00
00000000008000000P2_eO@00`000000^Mkb0;WNlP04000000030;CRmP000000^ncd00H0^ncd1@00
0000102TmmX0000000000000000g0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
0`3oool001D0oooo00<000000?ooo`3oool03P3oool200000400oooo1P00000202V=k@D000000P1O
X_@010000000M[3g07J`m`1f/?L5000000H0S;Wd5`0000020:oEm0L000001@2dh_H00`000000^ncd
0;_/m006000000030:cgkP000000000000@00000>@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00<0oooo000X0?ooo`030000003oool0oooo03l0oooo1@00000302V=k@030000001@
Y?L0D:Cg00L000000`1f/?L00`000000R;_g08Rkm`0208Rkma/00000102/f?H00`000000]>;f0;CR
mP0800000080[^og0P0000000`2/mnh0000000000002000000030?ooo`000000000003/0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`00:@3oool200000440oooo1P000000
0`0YSNd0000000000004052Tm`030000001^/oX0K[?j00l0000000<0V<Kg00000000000020000000
102QcOL000000000000000040:OIn@P000000`2/iOX00`000000[^og0:k_m`030:k_m`H00000@@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo000Z0?ooo`800000@@3oool;
00000080D:Cg00<0000006jcnP1^/oX0101^/oX00`000000Q[gi08Jmn@0208Jmn@8000000P24`O/2
0000000309S7n0000000V<Sh0080000000@0V/_h000000000000WLgh0`0000050:;In`L00000102/
iOX00`000000[^og0:k_m`050000000308c]iP000000000004<0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`020?ooo`00;03oool00`000000oooo0?ooo`130?ooo`8000000P0?RN@>
000000<0Q<7k0`0000000`23a?d000000000000:00000080W=Sl0`0000020:;In`800000102QiO`7
0000000409_]m`000000000008c]iP800000AP3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0080oooo000]0?ooo`<00000A03oool600000080@ZKg0P00000406Rgo0D000000P23a?d2
00000080Q<Sn00H0000008K<oP26c?h0000008[@o`00000208oCoP040000002Ee_h00000000000<0
W=Sl100000040:7Uo0800000102KkOL5000004T0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`020?ooo`00;`3oool00`000000oooo0?ooo`130?ooo`030000003oool0000000X00000
1@1T_?d300000080Q<Sn00@0000008K<oP26c?h000000`2:d?l010000000Sm?n08oCoP00000209GF
oP<00000102Dh_d=000004`0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`020?oo
o`00<03oool00`000000oooo0?ooo`120?ooo`040000003oool0oooo0?ooo`80000000@008GF0000
0000000000000P0hZO<200000080I;cm0P00000306C2o@l000001026gOh4000000@0PnGd1000001A
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool00340oooo0P0000110?oo
o`030000003oool0oooo00@0oooo3000000306C2o@030000001Wb?d0IlSm0080IlSm00D0000006k?
o@1^cod0K/om0000000407WFo@8000000P26gOh2000000<0JMW_1000001E0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool00P3oool003<0oooo0P00000o0?ooo`030000003oool0oooo
00T0oooo1P0000000`0c[Nl000000000000H000005X0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`020?ooo`00=03oool2000003h0oooo00<000000?ooo`3oool03`3ooolD00000680
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`00=P3oool00`000000oooo
0?ooo`0k0?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`010?ooo`00=`3oool3000003X0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0040oooo000Y0?ooo`800000103oool00`000000oooo0?ooo`02
0?ooo`<000000P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo08P0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`010?ooo`00:03oool010000000oooo0?ooo`00000;
0?ooo`040000003oool0oooo000003T0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0040oooo000X0?ooo`040000003oool0oooo000000/0oooo00@0
00000?ooo`3oool0oooo0P00000g0?ooo`030000003oool0oooo08T0oooo00D000000?ooo`3oool0
oooo000000030?ooo`008P3oool400000080oooo00@000000?ooo`3oool00000203oool3000000H0
oooo0P00000e0?ooo`030000003oool0oooo08X0oooo00@000000?ooo`3oool000000`3oool002P0
oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`070?ooo`800000=03oool00`00
0000oooo0?ooo`2;0?ooo`030000003oool0000000<0oooo000X0?ooo`040000003oool0oooo0000
00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo
08`0oooo00<000000?ooo`0000000P3oool002T0oooo0P0000090?ooo`@000002@3oool200000340
oooo00<000000?ooo`3oool0S03oool00`000000oooo000000020?ooo`00@P3oool200000300oooo
00<000000?ooo`3oool0S@3oool200000080oooo00140?ooo`030000003oool0oooo02d0oooo00<0
00000?ooo`3oool0S03oool300000080oooo00150?ooo`<00000;03oool00`000000oooo0?ooo`28
0?ooo`@000001@3oool004L0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`230?oo
o`D000002@3oool004L0oooo0`00000Z0?ooo`030000003oool0oooo07l0oooo1000000>0?ooo`00
BP3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo07/0oooo1000000B0?ooo`00B`3o
ool2000002L0oooo00<000000?ooo`3oool0MP3oool5000001H0oooo001<0?ooo`8000009P3oool0
0`000000oooo0?ooo`1b0?ooo`@000006`3oool004h0oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`1]0?ooo`D000007`3oool004l0oooo0P00000S0?ooo`030000003oool0oooo06T0
oooo1000000T0?ooo`00A@3oool2000000T0oooo0P00000R0?ooo`030000003oool0oooo06@0oooo
1@00000X0?ooo`00A03oool010000000oooo0?ooo`00000:0?ooo`800000803oool00`000000oooo
0?ooo`1P0?ooo`@00000;@3oool004@0oooo00@000000?ooo`3oool00000303oool2000001h0oooo
00<000000?ooo`3oool0G03oool400000340oooo00140?ooo`040000003oool0oooo000000`0oooo
0P00000N0?ooo`030000003oool0oooo05L0oooo1@00000e0?ooo`00A03oool010000000oooo0?oo
o`00000>0?ooo`800000703oool00`000000oooo0?ooo`1C0?ooo`@00000>P3oool004@0oooo00@0
00000?ooo`3oool00000403oool2000001X0oooo00<000000?ooo`3oool0CP3oool5000003h0oooo
00150?ooo`8000004P3oool2000001T0oooo00<000000?ooo`3oool0BP3oool4000004<0oooo001K
0?ooo`030000003oool0000001H0oooo00<000000?ooo`3oool0A@3oool5000004L0oooo001L0?oo
o`8000005P3oool00`000000oooo0?ooo`110?ooo`@00000C03oool005d0oooo0P00000D0?ooo`03
0000003oool0oooo03h0oooo1000001@0?ooo`00G`3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo03T0oooo1@00001D0?ooo`00H03oool200000140oooo00<000000?ooo`3oool0=@3o
ool4000005T0oooo001Q0?ooo`800000403oool00`000000oooo0?ooo`0`0?ooo`D00000G@3oool0
06<0oooo0P00000>0?ooo`030000003oool0oooo02`0oooo1000001R0?ooo`00I@3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo02P0oooo1000001V0?ooo`00E@3oool2000000@0oooo
00<000000?ooo`3oool00P3oool300000080oooo0P00000<0?ooo`030000003oool0oooo02<0oooo
1@00001Z0?ooo`00E03oool010000000oooo0?ooo`00000;0?ooo`040000003oool0oooo0?ooo`<0
00002@3oool00`000000oooo0?ooo`0O0?ooo`@00000K`3oool005@0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3o
ool06P3oool5000007<0oooo001D0?ooo`040000003oool0oooo000000P0oooo0`0000060?ooo`<0
00001`3oool00`000000oooo0?ooo`0F0?ooo`@00000N03oool005@0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0?ooo`090?ooo`8000001@3oool00`000000oooo0?ooo`0A0?ooo`D0
0000O03oool005@0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`0:0?ooo`80
0000103oool00`000000oooo0?ooo`0=0?ooo`@00000P@3oool005D0oooo0P0000090?ooo`@00000
2`3oool01@000000oooo0000003oool0000000/0oooo100000250?ooo`00L03oool2000000030?oo
o`000000oooo00D0oooo1@0000290?ooo`00L@3oool300000080oooo1000002>0?ooo`00L`3oool3
00000980oooo003o0?ooo`T0oooo003o0?ooo`T0oooo003o0?ooo`T0oooo003o0?ooo`T0oooo001_
0?ooo`@00000U@3oool00740oooo00<000000?ooo`3oool0U03oool00740oooo00<000000?ooo`3o
ool0U03oool00740oooo00<000000?ooo`3oool0U03oool00740oooo00<000000?ooo`3oool0U03o
ool006l0oooo0`00002F0?ooo`00L@3oool00`000000oooo0?ooo`2D0?ooo`00\
\>"],
  ImageRangeCache->{{{91.5625, 302.312}, {386.25, 156.938}} -> {-0.414409, \
0.653003, 0.00351649, 0.00351649}}]
}, Open  ]],

Cell[TextData[{
  "Tapaus b: (b/a = x2)\n{x1,x2,x3} = ",
  Cell[BoxData[
      \({1\/5, 1\/2, 3}\)]],
  "\n{\[Alpha],\[Beta],a,b} = ",
  Cell[BoxData[
      \({0.5`, 1.`, \(-1.7888543819998317`\), \(-0.8944271909999159`\)}\)], 
    "Output"],
  "\nb/a = 0.5"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[kuvac];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08777 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0576738 1.16792 -2.79724e-17 1.16792 [
[.08885 .23035 -11.8346 -9 ]
[.08885 .23035 .16541 0 ]
[.21763 .17597 -22.6208 -9 ]
[.21763 .17597 1.37923 0 ]
[.35353 .11861 -5.39309 -9 ]
[.35353 .11861 .60691 0 ]
[.49716 .05803 -15.393 -9 ]
[.49716 .05803 2.60705 0 ]
[.6492 -0.00605 -4.86888 -9 ]
[.6492 -0.00605 1.13112 0 ]
[.00886 .82785 -6.92493 0 ]
[.00886 .82785 5.07507 9 ]
[.12049 .90619 -13.4177 0 ]
[.12049 .90619 10.5823 9 ]
[.22061 .97645 -3.26163 0 ]
[.22061 .97645 2.73837 9 ]
[.3109 1.03981 -9.54321 0 ]
[.3109 1.03981 8.45679 9 ]
[.39276 1.09724 -3.11047 0 ]
[.39276 1.09724 2.88953 9 ]
[.07322 .26204 -12 -2.61848 ]
[.07322 .26204 0 6.38152 ]
[.05471 .37835 -24 -2.72137 ]
[.05471 .37835 0 6.27863 ]
[.03459 .50481 -6 -2.83416 ]
[.03459 .50481 0 6.16584 ]
[.01263 .64281 -18 -2.95834 ]
[.01263 .64281 0 6.04166 ]
[-0.01142 .794 -6 -3.09573 ]
[-0.01142 .794 0 5.90427 ]
[ 0 0 0 0 ]
[ 1 1.08777 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08845 .24527 m
.67201 0 L
s
.09903 .24082 m
.10412 .24605 L
s
[(-1)] .08885 .23035 .97243 1 Mshowa
.22731 .1869 m
.23214 .19237 L
s
[(-0.5)] .21763 .17597 .88506 1 Mshowa
.36263 .13003 m
.36719 .13573 L
s
[(0)] .35353 .11861 .7977 1 Mshowa
.50562 .06993 m
.50984 .07588 L
s
[(0.5)] .49716 .05803 .71033 1 Mshowa
.65692 .00634 m
.66078 .01254 L
s
[(1)] .6492 -0.00605 .62296 1 Mshowa
.125 Mabswid
.12415 .23026 m
.12717 .23343 L
s
.14953 .21959 m
.15253 .22279 L
s
.17518 .20881 m
.17815 .21204 L
s
.2011 .19792 m
.20404 .20117 L
s
.25379 .17577 m
.25666 .17908 L
s
.28056 .16452 m
.28339 .16786 L
s
.30762 .15315 m
.31042 .15652 L
s
.33498 .14165 m
.33774 .14505 L
s
.3906 .11827 m
.39329 .12173 L
s
.41887 .10639 m
.42153 .10987 L
s
.44746 .09437 m
.45008 .09789 L
s
.47638 .08222 m
.47895 .08576 L
s
.53519 .0575 m
.53768 .0611 L
s
.5651 .04493 m
.56755 .04856 L
s
.59535 .03222 m
.59776 .03588 L
s
.62596 .01935 m
.62832 .02304 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-1)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-0.5)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(0.5)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(1)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
.08669 .25641 m
.09342 .25359 L
s
[(-1)] .07322 .26204 1 -0.41811 Mshowa
.06829 .37298 m
.07508 .3703 L
s
[(-0.5)] .05471 .37835 1 -0.39525 Mshowa
.04828 .49974 m
.05513 .4972 L
s
[(0)] .03459 .50481 1 -0.37019 Mshowa
.02644 .63807 m
.03335 .63571 L
s
[(0.5)] .01263 .64281 1 -0.34259 Mshowa
.00252 .78966 m
.00949 .78748 L
s
[(1)] -0.01142 .794 1 -0.31206 Mshowa
.125 Mabswid
.08313 .27897 m
.08717 .27729 L
s
.07951 .3019 m
.08356 .30024 L
s
.07583 .3252 m
.07989 .32356 L
s
.07209 .34889 m
.07616 .34727 L
s
.06442 .39748 m
.0685 .39588 L
s
.06049 .42239 m
.06458 .42081 L
s
.05649 .44773 m
.06058 .44617 L
s
.05242 .47351 m
.05652 .47197 L
s
.04407 .52643 m
.04818 .52493 L
s
.03978 .5536 m
.0439 .55211 L
s
.03541 .58125 m
.03954 .57979 L
s
.03097 .60941 m
.03511 .60796 L
s
.02184 .66727 m
.02599 .66588 L
s
.01714 .69701 m
.0213 .69564 L
s
.01236 .72731 m
.01652 .72596 L
s
.00749 .75819 m
.01166 .75686 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
.41815 .58175 m
.08845 .24527 L
s
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.41815 .58175 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
0 0 m
1 0 L
1 1.08777 L
0 1.08777 L
closepath
clip
newpath
.5 Mabswid
.739 .591 .691 r
.44786 .61772 m .50085 .62415 L .50244 .59379 L p F P
0 g
s
.739 .591 .691 r
.50244 .59379 m .45288 .58767 L .44786 .61772 L p F P
0 g
s
.705 .562 .69 r
.55282 .59353 m .50244 .59379 L .50085 .62415 L p F P
0 g
s
.737 .605 .711 r
.45288 .58767 m .50244 .59379 L .50427 .56337 L p F P
0 g
s
.706 .578 .71 r
.50244 .59379 m .55282 .59353 L .55067 .56312 L p F P
0 g
s
.706 .578 .71 r
.55067 .56312 m .50427 .56337 L .50244 .59379 L p F P
0 g
s
.705 .562 .69 r
.50085 .62415 m .55469 .62387 L .55282 .59353 L p F P
0 g
s
.67 .535 .691 r
.60223 .58688 m .55282 .59353 L .55469 .62387 L p F P
0 g
s
.673 .554 .711 r
.55282 .59353 m .60223 .58688 L .59615 .55689 L p F P
0 g
s
.673 .554 .711 r
.59615 .55689 m .55067 .56312 L .55282 .59353 L p F P
0 g
s
.737 .605 .711 r
.50427 .56337 m .45864 .55763 L .45288 .58767 L p F P
0 g
s
.734 .619 .731 r
.45864 .55763 m .50427 .56337 L .50632 .53311 L p F P
0 g
s
.706 .595 .729 r
.50427 .56337 m .55067 .56312 L .54825 .53288 L p F P
0 g
s
.706 .595 .729 r
.54825 .53288 m .50632 .53311 L .50427 .56337 L p F P
0 g
s
.676 .572 .731 r
.55067 .56312 m .59615 .55689 L .58933 .52715 L p F P
0 g
s
.676 .572 .731 r
.58933 .52715 m .54825 .53288 L .55067 .56312 L p F P
0 g
s
.741 .576 .67 r
.44362 .64756 m .49951 .65421 L .50085 .62415 L p F P
0 g
s
.741 .576 .67 r
.50085 .62415 m .44786 .61772 L .44362 .64756 L p F P
0 g
s
.705 .545 .669 r
.55469 .62387 m .50085 .62415 L .49951 .65421 L p F P
0 g
s
.705 .545 .669 r
.49951 .65421 m .55627 .65392 L .55469 .62387 L p F P
0 g
s
.667 .516 .67 r
.60753 .61689 m .55469 .62387 L .55627 .65392 L p F P
0 g
s
.67 .535 .691 r
.55469 .62387 m .60753 .61689 L .60223 .58688 L p F P
0 g
s
.734 .619 .731 r
.50632 .53311 m .4651 .52783 L .45864 .55763 L p F P
0 g
s
.731 .633 .75 r
.4651 .52783 m .50632 .53311 L .50857 .50323 L p F P
0 g
s
.705 .61 .749 r
.50632 .53311 m .54825 .53288 L .54559 .50303 L p F P
0 g
s
.705 .61 .749 r
.54559 .50303 m .50857 .50323 L .50632 .53311 L p F P
0 g
s
.678 .59 .75 r
.54825 .53288 m .58933 .52715 L .58183 .49788 L p F P
0 g
s
.678 .59 .75 r
.58183 .49788 m .54559 .50303 L .54825 .53288 L p F P
0 g
s
.767 .635 .715 r
.40592 .5753 m .45288 .58767 L .45864 .55763 L p F P
0 g
s
.767 .635 .715 r
.45864 .55763 m .41546 .54604 L .40592 .5753 L p F P
0 g
s
.762 .647 .735 r
.41546 .54604 m .45864 .55763 L .4651 .52783 L p F P
0 g
s
.772 .623 .694 r
.39759 .60473 m .44786 .61772 L .45288 .58767 L p F P
0 g
s
.772 .623 .694 r
.45288 .58767 m .40592 .5753 L .39759 .60473 L p F P
0 g
s
.742 .559 .647 r
.44021 .67695 m .49843 .68375 L .49951 .65421 L p F P
0 g
s
.742 .559 .647 r
.49951 .65421 m .44362 .64756 L .44021 .67695 L p F P
0 g
s
.703 .527 .647 r
.55627 .65392 m .49951 .65421 L .49843 .68375 L p F P
0 g
s
.638 .53 .716 r
.63904 .54483 m .59615 .55689 L .60223 .58688 L p F P
0 g
s
.644 .551 .736 r
.59615 .55689 m .63904 .54483 L .62801 .51607 L p F P
0 g
s
.644 .551 .736 r
.62801 .51607 m .58933 .52715 L .59615 .55689 L p F P
0 g
s
.703 .527 .647 r
.49843 .68375 m .55754 .68346 L .55627 .65392 L p F P
0 g
s
.663 .495 .647 r
.61199 .6467 m .55627 .65392 L .55754 .68346 L p F P
0 g
s
.667 .516 .67 r
.55627 .65392 m .61199 .6467 L .60753 .61689 L p F P
0 g
s
.632 .509 .695 r
.64889 .57401 m .60223 .58688 L .60753 .61689 L p F P
0 g
s
.638 .53 .716 r
.60223 .58688 m .64889 .57401 L .63904 .54483 L p F P
0 g
s
.762 .647 .735 r
.4651 .52783 m .42615 .51718 L .41546 .54604 L p F P
0 g
s
.755 .659 .755 r
.42615 .51718 m .4651 .52783 L .47221 .49849 L p F P
0 g
s
.731 .633 .75 r
.50857 .50323 m .47221 .49849 L .4651 .52783 L p F P
0 g
s
.726 .647 .77 r
.47221 .49849 m .50857 .50323 L .51102 .47397 L p F P
0 g
s
.703 .626 .768 r
.50857 .50323 m .54559 .50303 L .54269 .47379 L p F P
0 g
s
.703 .626 .768 r
.54269 .47379 m .51102 .47397 L .50857 .50323 L p F P
0 g
s
.679 .609 .77 r
.54559 .50303 m .58183 .49788 L .57369 .46931 L p F P
0 g
s
.679 .609 .77 r
.57369 .46931 m .54269 .47379 L .54559 .50303 L p F P
0 g
s
.776 .609 .673 r
.39056 .6341 m .44362 .64756 L .44786 .61772 L p F P
0 g
s
.776 .609 .673 r
.44786 .61772 m .39759 .60473 L .39056 .6341 L p F P
0 g
s
.649 .572 .755 r
.58933 .52715 m .62801 .51607 L .61589 .48795 L p F P
0 g
s
.649 .572 .755 r
.61589 .48795 m .58183 .49788 L .58933 .52715 L p F P
0 g
s
.625 .487 .673 r
.65748 .60337 m .60753 .61689 L .61199 .6467 L p F P
0 g
s
.632 .509 .695 r
.60753 .61689 m .65748 .60337 L .64889 .57401 L p F P
0 g
s
.755 .659 .755 r
.47221 .49849 m .43791 .48894 L .42615 .51718 L p F P
0 g
s
.748 .67 .774 r
.43791 .48894 m .47221 .49849 L .47992 .46984 L p F P
0 g
s
.726 .647 .77 r
.51102 .47397 m .47992 .46984 L .47221 .49849 L p F P
0 g
s
.654 .593 .775 r
.58183 .49788 m .61589 .48795 L .60276 .46069 L p F P
0 g
s
.654 .593 .775 r
.60276 .46069 m .57369 .46931 L .58183 .49788 L p F P
0 g
s
.742 .542 .623 r
.43765 .70566 m .49761 .71254 L .49843 .68375 L p F P
0 g
s
.742 .542 .623 r
.49843 .68375 m .44021 .67695 L .43765 .70566 L p F P
0 g
s
.701 .507 .623 r
.55754 .68346 m .49843 .68375 L .49761 .71254 L p F P
0 g
s
.78 .595 .649 r
.38488 .66318 m .44021 .67695 L .44362 .64756 L p F P
0 g
s
.78 .595 .649 r
.44362 .64756 m .39056 .6341 L .38488 .66318 L p F P
0 g
s
.701 .507 .623 r
.49761 .71254 m .55849 .71224 L .55754 .68346 L p F P
0 g
s
.658 .473 .623 r
.61559 .67607 m .55754 .68346 L .55849 .71224 L p F P
0 g
s
.663 .495 .647 r
.55754 .68346 m .61559 .67607 L .61199 .6467 L p F P
0 g
s
.618 .463 .65 r
.66473 .63269 m .61199 .6467 L .61559 .67607 L p F P
0 g
s
.625 .487 .673 r
.61199 .6467 m .66473 .63269 L .65748 .60337 L p F P
0 g
s
.721 .661 .789 r
.47992 .46984 m .51102 .47397 L .51364 .44555 L p F P
0 g
s
.701 .643 .788 r
.51102 .47397 m .54269 .47379 L .53959 .4454 L p F P
0 g
s
.701 .643 .788 r
.53959 .4454 m .51364 .44555 L .51102 .47397 L p F P
0 g
s
.68 .628 .79 r
.54269 .47379 m .57369 .46931 L .56496 .44168 L p F P
0 g
s
.68 .628 .79 r
.56496 .44168 m .53959 .4454 L .54269 .47379 L p F P
0 g
s
.797 .669 .722 r
.36334 .557 m .40592 .5753 L .41546 .54604 L p F P
0 g
s
.797 .669 .722 r
.41546 .54604 m .37641 .52893 L .36334 .557 L p F P
0 g
s
.789 .679 .743 r
.37641 .52893 m .41546 .54604 L .42615 .51718 L p F P
0 g
s
.789 .679 .743 r
.42615 .51718 m .39102 .50148 L .37641 .52893 L p F P
0 g
s
.779 .687 .762 r
.39102 .50148 m .42615 .51718 L .43791 .48894 L p F P
0 g
s
.805 .659 .701 r
.35192 .58549 m .39759 .60473 L .40592 .5753 L p F P
0 g
s
.805 .659 .701 r
.40592 .5753 m .36334 .557 L .35192 .58549 L p F P
0 g
s
.599 .508 .723 r
.67766 .52728 m .63904 .54483 L .64889 .57401 L p F P
0 g
s
.609 .532 .743 r
.63904 .54483 m .67766 .52728 L .66275 .49998 L p F P
0 g
s
.609 .532 .743 r
.66275 .49998 m .62801 .51607 L .63904 .54483 L p F P
0 g
s
.618 .556 .763 r
.62801 .51607 m .66275 .49998 L .64638 .47354 L p F P
0 g
s
.618 .556 .763 r
.64638 .47354 m .61589 .48795 L .62801 .51607 L p F P
0 g
s
.748 .67 .774 r
.47992 .46984 m .45064 .46155 L .43791 .48894 L p F P
0 g
s
.739 .681 .794 r
.45064 .46155 m .47992 .46984 L .48818 .44212 L p F P
0 g
s
.721 .661 .789 r
.51364 .44555 m .48818 .44212 L .47992 .46984 L p F P
0 g
s
.589 .483 .701 r
.69101 .55524 m .64889 .57401 L .65748 .60337 L p F P
0 g
s
.599 .508 .723 r
.64889 .57401 m .69101 .55524 L .67766 .52728 L p F P
0 g
s
.658 .615 .794 r
.57369 .46931 m .60276 .46069 L .58871 .43451 L p F P
0 g
s
.658 .615 .794 r
.58871 .43451 m .56496 .44168 L .57369 .46931 L p F P
0 g
s
.782 .578 .624 r
.38063 .69174 m .43765 .70566 L .44021 .67695 L p F P
0 g
s
.782 .578 .624 r
.44021 .67695 m .38488 .66318 L .38063 .69174 L p F P
0 g
s
.658 .473 .623 r
.55849 .71224 m .61828 .70477 L .61559 .67607 L p F P
0 g
s
.61 .438 .624 r
.67058 .66174 m .61559 .67607 L .61828 .70477 L p F P
0 g
s
.618 .463 .65 r
.61559 .67607 m .67058 .66174 L .66473 .63269 L p F P
0 g
s
.779 .687 .762 r
.43791 .48894 m .40706 .47489 L .39102 .50148 L p F P
0 g
s
.769 .696 .782 r
.40706 .47489 m .43791 .48894 L .45064 .46155 L p F P
0 g
s
.812 .647 .678 r
.34225 .61415 m .39056 .6341 L .39759 .60473 L p F P
0 g
s
.812 .647 .678 r
.39759 .60473 m .35192 .58549 L .34225 .61415 L p F P
0 g
s
.741 .522 .596 r
.43599 .73345 m .49708 .74033 L .49761 .71254 L p F P
0 g
s
.741 .522 .596 r
.49761 .71254 m .43765 .70566 L .43599 .73345 L p F P
0 g
s
.698 .486 .597 r
.55849 .71224 m .49761 .71254 L .49708 .74033 L p F P
0 g
s
.626 .58 .783 r
.61589 .48795 m .64638 .47354 L .62869 .4482 L p F P
0 g
s
.626 .58 .783 r
.62869 .4482 m .60276 .46069 L .61589 .48795 L p F P
0 g
s
.698 .486 .597 r
.49708 .74033 m .55911 .74004 L .55849 .71224 L p F P
0 g
s
.652 .449 .596 r
.61828 .70477 m .55849 .71224 L .55911 .74004 L p F P
0 g
s
.578 .457 .678 r
.70267 .58364 m .65748 .60337 L .66473 .63269 L p F P
0 g
s
.589 .483 .701 r
.65748 .60337 m .70267 .58364 L .69101 .55524 L p F P
0 g
s
.714 .675 .81 r
.48818 .44212 m .51364 .44555 L .51642 .41822 L p F P
0 g
s
.698 .66 .809 r
.51364 .44555 m .53959 .4454 L .5363 .4181 L p F P
0 g
s
.698 .66 .809 r
.5363 .4181 m .51642 .41822 L .51364 .44555 L p F P
0 g
s
.68 .647 .81 r
.53959 .4454 m .56496 .44168 L .55572 .41521 L p F P
0 g
s
.68 .647 .81 r
.55572 .41521 m .5363 .4181 L .53959 .4454 L p F P
0 g
s
.769 .696 .782 r
.45064 .46155 m .42438 .44937 L .40706 .47489 L p F P
0 g
s
.757 .703 .801 r
.42438 .44937 m .45064 .46155 L .46425 .43523 L p F P
0 g
s
.739 .681 .794 r
.48818 .44212 m .46425 .43523 L .45064 .46155 L p F P
0 g
s
.819 .634 .653 r
.33445 .64276 m .38488 .66318 L .39056 .6341 L p F P
0 g
s
.819 .634 .653 r
.39056 .6341 m .34225 .61415 L .33445 .64276 L p F P
0 g
s
.635 .604 .802 r
.60276 .46069 m .62869 .4482 L .60982 .42416 L p F P
0 g
s
.635 .604 .802 r
.60982 .42416 m .58871 .43451 L .60276 .46069 L p F P
0 g
s
.729 .691 .814 r
.46425 .43523 m .48818 .44212 L .49693 .41555 L p F P
0 g
s
.714 .675 .81 r
.51642 .41822 m .49693 .41555 L .48818 .44212 L p F P
0 g
s
.566 .429 .653 r
.71253 .61223 m .66473 .63269 L .67058 .66174 L p F P
0 g
s
.578 .457 .678 r
.66473 .63269 m .71253 .61223 L .70267 .58364 L p F P
0 g
s
.662 .637 .814 r
.56496 .44168 m .58871 .43451 L .57385 .40965 L p F P
0 g
s
.662 .637 .814 r
.57385 .40965 m .55572 .41521 L .56496 .44168 L p F P
0 g
s
.784 .56 .596 r
.37787 .71952 m .43599 .73345 L .43765 .70566 L p F P
0 g
s
.784 .56 .596 r
.43765 .70566 m .38063 .69174 L .37787 .71952 L p F P
0 g
s
.652 .449 .596 r
.55911 .74004 m .62003 .73256 L .61828 .70477 L p F P
0 g
s
.6 .41 .596 r
.67495 .69028 m .61828 .70477 L .62003 .73256 L p F P
0 g
s
.61 .438 .624 r
.61828 .70477 m .67495 .69028 L .67058 .66174 L p F P
0 g
s
.815 .715 .754 r
.34312 .50679 m .37641 .52893 L .39102 .50148 L p F P
0 g
s
.815 .715 .754 r
.39102 .50148 m .3612 .48122 L .34312 .50679 L p F P
0 g
s
.802 .72 .774 r
.3612 .48122 m .39102 .50148 L .40706 .47489 L p F P
0 g
s
.74 .5 .566 r
.43525 .76008 m .49685 .76689 L .49708 .74033 L p F P
0 g
s
.74 .5 .566 r
.49708 .74033 m .43599 .73345 L .43525 .76008 L p F P
0 g
s
.693 .461 .567 r
.55911 .74004 m .49708 .74033 L .49685 .76689 L p F P
0 g
s
.828 .708 .733 r
.32691 .53329 m .36334 .557 L .37641 .52893 L p F P
0 g
s
.828 .708 .733 r
.37641 .52893 m .34312 .50679 L .32691 .53329 L p F P
0 g
s
.693 .461 .567 r
.49685 .76689 m .55937 .7666 L .55911 .74004 L p F P
0 g
s
.644 .422 .566 r
.62003 .73256 m .55911 .74004 L .55937 .7666 L p F P
0 g
s
.569 .515 .755 r
.69205 .47936 m .66275 .49998 L .67766 .52728 L p F P
0 g
s
.583 .543 .775 r
.66275 .49998 m .69205 .47936 L .67198 .45514 L p F P
0 g
s
.583 .543 .775 r
.67198 .45514 m .64638 .47354 L .66275 .49998 L p F P
0 g
s
.757 .703 .801 r
.46425 .43523 m .44288 .42513 L .42438 .44937 L p F P
0 g
s
.743 .71 .82 r
.44288 .42513 m .46425 .43523 L .47866 .4102 L p F P
0 g
s
.729 .691 .814 r
.49693 .41555 m .47866 .4102 L .46425 .43523 L p F P
0 g
s
.802 .72 .774 r
.40706 .47489 m .38099 .4568 L .3612 .48122 L p F P
0 g
s
.788 .725 .793 r
.38099 .4568 m .40706 .47489 L .42438 .44937 L p F P
0 g
s
.824 .619 .625 r
.32861 .67106 m .38063 .69174 L .38488 .66318 L p F P
0 g
s
.824 .619 .625 r
.38488 .66318 m .33445 .64276 L .32861 .67106 L p F P
0 g
s
.554 .486 .734 r
.71039 .50475 m .67766 .52728 L .69101 .55524 L p F P
0 g
s
.569 .515 .755 r
.67766 .52728 m .71039 .50475 L .69205 .47936 L p F P
0 g
s
.643 .629 .821 r
.58871 .43451 m .60982 .42416 L .58991 .40164 L p F P
0 g
s
.643 .629 .821 r
.58991 .40164 m .57385 .40965 L .58871 .43451 L p F P
0 g
s
.597 .57 .794 r
.64638 .47354 m .67198 .45514 L .65036 .43229 L p F P
0 g
s
.597 .57 .794 r
.65036 .43229 m .62869 .4482 L .64638 .47354 L p F P
0 g
s
.553 .399 .625 r
.72049 .64079 m .67058 .66174 L .67495 .69028 L p F P
0 g
s
.566 .429 .653 r
.67058 .66174 m .72049 .64079 L .71253 .61223 L p F P
0 g
s
.839 .7 .71 r
.31271 .5605 m .35192 .58549 L .36334 .557 L p F P
0 g
s
.839 .7 .71 r
.36334 .557 m .32691 .53329 L .31271 .5605 L p F P
0 g
s
.706 .689 .831 r
.49693 .41555 m .51642 .41822 L .51934 .39222 L p F P
0 g
s
.693 .678 .83 r
.51642 .41822 m .5363 .4181 L .53284 .39214 L p F P
0 g
s
.693 .678 .83 r
.53284 .39214 m .51934 .39222 L .51642 .41822 L p F P
0 g
s
.68 .668 .832 r
.5363 .4181 m .55572 .41521 L .54601 .39015 L p F P
0 g
s
.68 .668 .832 r
.54601 .39015 m .53284 .39214 L .5363 .4181 L p F P
0 g
s
.539 .457 .711 r
.72684 .53111 m .69101 .55524 L .70267 .58364 L p F P
0 g
s
.554 .486 .734 r
.69101 .55524 m .72684 .53111 L .71039 .50475 L p F P
0 g
s
.788 .725 .793 r
.42438 .44937 m .40231 .43372 L .38099 .4568 L p F P
0 g
s
.772 .728 .811 r
.40231 .43372 m .42438 .44937 L .44288 .42513 L p F P
0 g
s
.61 .597 .813 r
.62869 .4482 m .65036 .43229 L .62736 .41101 L p F P
0 g
s
.61 .597 .813 r
.62736 .41101 m .60982 .42416 L .62869 .4482 L p F P
0 g
s
.717 .702 .835 r
.47866 .4102 m .49693 .41555 L .50612 .39038 L p F P
0 g
s
.706 .689 .831 r
.51934 .39222 m .50612 .39038 L .49693 .41555 L p F P
0 g
s
.666 .661 .835 r
.55572 .41521 m .57385 .40965 L .55829 .38633 L p F P
0 g
s
.666 .661 .835 r
.55829 .38633 m .54601 .39015 L .55572 .41521 L p F P
0 g
s
.85 .691 .685 r
.30068 .58821 m .34225 .61415 L .35192 .58549 L p F P
0 g
s
.85 .691 .685 r
.35192 .58549 m .31271 .5605 L .30068 .58821 L p F P
0 g
s
.785 .539 .564 r
.37665 .74627 m .43525 .76008 L .43599 .73345 L p F P
0 g
s
.785 .539 .564 r
.43599 .73345 m .37787 .71952 L .37665 .74627 L p F P
0 g
s
.644 .422 .566 r
.55937 .7666 m .62079 .7592 L .62003 .73256 L p F P
0 g
s
.588 .378 .564 r
.67779 .71806 m .62003 .73256 L .62079 .7592 L p F P
0 g
s
.6 .41 .596 r
.62003 .73256 m .67779 .71806 L .67495 .69028 L p F P
0 g
s
.522 .425 .686 r
.74124 .55821 m .70267 .58364 L .71253 .61223 L p F P
0 g
s
.539 .457 .711 r
.70267 .58364 m .74124 .55821 L .72684 .53111 L p F P
0 g
s
.772 .728 .811 r
.44288 .42513 m .425 .41219 L .40231 .43372 L p F P
0 g
s
.755 .73 .83 r
.425 .41219 m .44288 .42513 L .46239 .40238 L p F P
0 g
s
.743 .71 .82 r
.47866 .4102 m .46239 .40238 L .44288 .42513 L p F P
0 g
s
.727 .716 .84 r
.46239 .40238 m .47866 .4102 L .49375 .38671 L p F P
0 g
s
.717 .702 .835 r
.50612 .39038 m .49375 .38671 L .47866 .4102 L p F P
0 g
s
.829 .602 .594 r
.3248 .69882 m .37787 .71952 L .38063 .69174 L p F P
0 g
s
.829 .602 .594 r
.38063 .69174 m .32861 .67106 L .3248 .69882 L p F P
0 g
s
.624 .624 .83 r
.60982 .42416 m .62736 .41101 L .60318 .39149 L p F P
0 g
s
.624 .624 .83 r
.60318 .39149 m .58991 .40164 L .60982 .42416 L p F P
0 g
s
.652 .655 .84 r
.57385 .40965 m .58991 .40164 L .56911 .38083 L p F P
0 g
s
.652 .655 .84 r
.56911 .38083 m .55829 .38633 L .57385 .40965 L p F P
0 g
s
.538 .365 .594 r
.72646 .66907 m .67495 .69028 L .67779 .71806 L p F P
0 g
s
.553 .399 .625 r
.67495 .69028 m .72646 .66907 L .72049 .64079 L p F P
0 g
s
.736 .474 .532 r
.43547 .78528 m .49691 .79197 L .49685 .76689 L p F P
0 g
s
.736 .474 .532 r
.49685 .76689 m .43525 .76008 L .43547 .78528 L p F P
0 g
s
.688 .434 .533 r
.55937 .7666 m .49685 .76689 L .49691 .79197 L p F P
0 g
s
.688 .434 .533 r
.49691 .79197 m .55928 .79168 L .55937 .7666 L p F P
0 g
s
.635 .391 .531 r
.62079 .7592 m .55937 .7666 L .55928 .79168 L p F P
0 g
s
.86 .68 .658 r
.29095 .61616 m .33445 .64276 L .34225 .61415 L p F P
0 g
s
.86 .68 .658 r
.34225 .61415 m .30068 .58821 L .29095 .61616 L p F P
0 g
s
.503 .39 .658 r
.75344 .58582 m .71253 .61223 L .72049 .64079 L p F P
0 g
s
.522 .425 .686 r
.71253 .61223 m .75344 .58582 L .74124 .55821 L p F P
0 g
s
.695 .704 .854 r
.50612 .39038 m .51934 .39222 L .52239 .3678 L p F P
0 g
s
.687 .697 .854 r
.51934 .39222 m .53284 .39214 L .52924 .36776 L p F P
0 g
s
.687 .697 .854 r
.52924 .36776 m .52239 .3678 L .51934 .39222 L p F P
0 g
s
.678 .69 .854 r
.53284 .39214 m .54601 .39015 L .53592 .36673 L p F P
0 g
s
.678 .69 .854 r
.53592 .36673 m .52924 .36776 L .53284 .39214 L p F P
0 g
s
.755 .73 .83 r
.46239 .40238 m .44886 .39239 L .425 .41219 L p F P
0 g
s
.735 .731 .847 r
.44886 .39239 m .46239 .40238 L .48278 .38134 L p F P
0 g
s
.727 .716 .84 r
.49375 .38671 m .48278 .38134 L .46239 .40238 L p F P
0 g
s
.824 .757 .79 r
.3381 .45706 m .3612 .48122 L .38099 .4568 L p F P
0 g
s
.824 .757 .79 r
.38099 .4568 m .36094 .43529 L .3381 .45706 L p F P
0 g
s
.805 .757 .808 r
.36094 .43529 m .38099 .4568 L .40231 .43372 L p F P
0 g
s
.637 .652 .848 r
.58991 .40164 m .60318 .39149 L .578 .3739 L p F P
0 g
s
.637 .652 .848 r
.578 .3739 m .56911 .38083 L .58991 .40164 L p F P
0 g
s
.841 .756 .769 r
.31717 .48032 m .34312 .50679 L .3612 .48122 L p F P
0 g
s
.841 .756 .769 r
.3612 .48122 m .3381 .45706 L .31717 .48032 L p F P
0 g
s
.805 .757 .808 r
.40231 .43372 m .38547 .41519 L .36094 .43529 L p F P
0 g
s
.786 .755 .825 r
.38547 .41519 m .40231 .43372 L .425 .41219 L p F P
0 g
s
.702 .712 .856 r
.49375 .38671 m .50612 .39038 L .51567 .36686 L p F P
0 g
s
.695 .704 .854 r
.52239 .3678 m .51567 .36686 L .50612 .39038 L p F P
0 g
s
.669 .686 .857 r
.54601 .39015 m .55829 .38633 L .54213 .36477 L p F P
0 g
s
.669 .686 .857 r
.54213 .36477 m .53592 .36673 L .54601 .39015 L p F P
0 g
s
.544 .531 .791 r
.69147 .43339 m .67198 .45514 L .69205 .47936 L p F P
0 g
s
.565 .562 .81 r
.67198 .45514 m .69147 .43339 L .66672 .41355 L p F P
0 g
s
.565 .562 .81 r
.66672 .41355 m .65036 .43229 L .67198 .45514 L p F P
0 g
s
.584 .592 .827 r
.65036 .43229 m .66672 .41355 L .64049 .39557 L p F P
0 g
s
.584 .592 .827 r
.64049 .39557 m .62736 .41101 L .65036 .43229 L p F P
0 g
s
.523 .499 .771 r
.71452 .45492 m .69205 .47936 L .71039 .50475 L p F P
0 g
s
.544 .531 .791 r
.69205 .47936 m .71452 .45492 L .69147 .43339 L p F P
0 g
s
.784 .514 .527 r
.37701 .77175 m .43547 .78528 L .43525 .76008 L p F P
0 g
s
.784 .514 .527 r
.43525 .76008 m .37665 .74627 L .37701 .77175 L p F P
0 g
s
.858 .754 .747 r
.29834 .50487 m .32691 .53329 L .34312 .50679 L p F P
0 g
s
.858 .754 .747 r
.34312 .50679 m .31717 .48032 L .29834 .50487 L p F P
0 g
s
.786 .755 .825 r
.425 .41219 m .41147 .39692 L .38547 .41519 L p F P
0 g
s
.764 .752 .842 r
.41147 .39692 m .425 .41219 L .44886 .39239 L p F P
0 g
s
.635 .391 .531 r
.55928 .79168 m .62055 .78442 L .62079 .7592 L p F P
0 g
s
.575 .342 .526 r
.67904 .74483 m .62079 .7592 L .62055 .78442 L p F P
0 g
s
.588 .378 .564 r
.62079 .7592 m .67904 .74483 L .67779 .71806 L p F P
0 g
s
.869 .666 .626 r
.28366 .64412 m .32861 .67106 L .33445 .64276 L p F P
0 g
s
.869 .666 .626 r
.33445 .64276 m .29095 .61616 L .28366 .64412 L p F P
0 g
s
.708 .722 .86 r
.48278 .38134 m .49375 .38671 L .50941 .36497 L p F P
0 g
s
.702 .712 .856 r
.51567 .36686 m .50941 .36497 L .49375 .38671 L p F P
0 g
s
.832 .581 .559 r
.32312 .72577 m .37665 .74627 L .37787 .71952 L p F P
0 g
s
.832 .581 .559 r
.37787 .71952 m .3248 .69882 L .32312 .72577 L p F P
0 g
s
.66 .683 .86 r
.55829 .38633 m .56911 .38083 L .54759 .36196 L p F P
0 g
s
.66 .683 .86 r
.54759 .36196 m .54213 .36477 L .55829 .38633 L p F P
0 g
s
.604 .622 .843 r
.62736 .41101 m .64049 .39557 L .61301 .37961 L p F P
0 g
s
.604 .622 .843 r
.61301 .37961 m .60318 .39149 L .62736 .41101 L p F P
0 g
s
.501 .465 .749 r
.73565 .47797 m .71039 .50475 L .72684 .53111 L p F P
0 g
s
.523 .499 .771 r
.71039 .50475 m .73565 .47797 L .71452 .45492 L p F P
0 g
s
.521 .327 .558 r
.73033 .69683 m .67779 .71806 L .67904 .74483 L p F P
0 g
s
.538 .365 .594 r
.67779 .71806 m .73033 .69683 L .72646 .66907 L p F P
0 g
s
.483 .352 .626 r
.7633 .61371 m .72049 .64079 L .72646 .66907 L p F P
0 g
s
.503 .39 .658 r
.72049 .64079 m .7633 .61371 L .75344 .58582 L p F P
0 g
s
.874 .75 .723 r
.28181 .5305 m .31271 .5605 L .32691 .53329 L p F P
0 g
s
.874 .75 .723 r
.32691 .53329 m .29834 .50487 L .28181 .5305 L p F P
0 g
s
.764 .752 .842 r
.44886 .39239 m .43871 .38065 L .41147 .39692 L p F P
0 g
s
.742 .748 .857 r
.43871 .38065 m .44886 .39239 L .47371 .37452 L p F P
0 g
s
.735 .731 .847 r
.48278 .38134 m .47371 .37452 L .44886 .39239 L p F P
0 g
s
.713 .731 .865 r
.47371 .37452 m .48278 .38134 L .50388 .36222 L p F P
0 g
s
.708 .722 .86 r
.50941 .36497 m .50388 .36222 L .48278 .38134 L p F P
0 g
s
.623 .652 .858 r
.60318 .39149 m .61301 .37961 L .58453 .36581 L p F P
0 g
s
.623 .652 .858 r
.58453 .36581 m .578 .3739 L .60318 .39149 L p F P
0 g
s
.651 .681 .866 r
.56911 .38083 m .578 .3739 L .55204 .35842 L p F P
0 g
s
.651 .681 .866 r
.55204 .35842 m .54759 .36196 L .56911 .38083 L p F P
0 g
s
.477 .428 .724 r
.75466 .50234 m .72684 .53111 L .74124 .55821 L p F P
0 g
s
.501 .465 .749 r
.72684 .53111 m .75466 .50234 L .73565 .47797 L p F P
0 g
s
.731 .443 .491 r
.43667 .80881 m .49728 .81531 L .49691 .79197 L p F P
0 g
s
.731 .443 .491 r
.49691 .79197 m .43547 .78528 L .43667 .80881 L p F P
0 g
s
.679 .401 .493 r
.55928 .79168 m .49691 .79197 L .49728 .81531 L p F P
0 g
s
.679 .401 .493 r
.49728 .81531 m .55883 .81503 L .55928 .79168 L p F P
0 g
s
.623 .355 .49 r
.62055 .78442 m .55928 .79168 L .55883 .81503 L p F P
0 g
s
.889 .744 .695 r
.26778 .55699 m .30068 .58821 L .31271 .5605 L p F P
0 g
s
.889 .744 .695 r
.31271 .5605 m .28181 .5305 L .26778 .55699 L p F P
0 g
s
.877 .65 .591 r
.2789 .67183 m .3248 .69882 L .32861 .67106 L p F P
0 g
s
.877 .65 .591 r
.32861 .67106 m .28366 .64412 L .2789 .67183 L p F P
0 g
s
.742 .748 .857 r
.47371 .37452 m .46697 .36652 L .43871 .38065 L p F P
0 g
s
.716 .741 .871 r
.46697 .36652 m .47371 .37452 L .49933 .35873 L p F P
0 g
s
.713 .731 .865 r
.50388 .36222 m .49933 .35873 L .47371 .37452 L p F P
0 g
s
.681 .72 .879 r
.52552 .34522 m .51567 .36686 L .52239 .3678 L closepath p F P
0 g
s
.678 .717 .878 r
.52552 .34522 m .52239 .3678 L .52924 .36776 L closepath p F P
0 g
s
.675 .715 .879 r
.52552 .34522 m .52924 .36776 L .53592 .36673 L closepath p F P
0 g
s
.642 .682 .872 r
.578 .3739 m .58453 .36581 L .55528 .35431 L p F P
0 g
s
.642 .682 .872 r
.55528 .35431 m .55204 .35842 L .578 .3739 L p F P
0 g
s
.45 .388 .696 r
.77134 .52783 m .74124 .55821 L .75344 .58582 L p F P
0 g
s
.477 .428 .724 r
.74124 .55821 m .77134 .52783 L .75466 .50234 L p F P
0 g
s
.684 .723 .879 r
.52552 .34522 m .50941 .36497 L .51567 .36686 L closepath p F P
0 g
s
.672 .713 .879 r
.52552 .34522 m .53592 .36673 L .54213 .36477 L closepath p F P
0 g
s
.459 .31 .59 r
.7707 .64164 m .72646 .66907 L .73033 .69683 L p F P
0 g
s
.483 .352 .626 r
.72646 .66907 m .7707 .64164 L .7633 .61371 L p F P
0 g
s
.795 .785 .843 r
.37475 .39449 m .38547 .41519 L .41147 .39692 L p F P
0 g
s
.795 .785 .843 r
.41147 .39692 m .40299 .37993 L .37475 .39449 L p F P
0 g
s
.771 .775 .856 r
.40299 .37993 m .41147 .39692 L .43871 .38065 L p F P
0 g
s
.819 .793 .828 r
.34799 .41119 m .36094 .43529 L .38547 .41519 L p F P
0 g
s
.819 .793 .828 r
.38547 .41519 m .37475 .39449 L .34799 .41119 L p F P
0 g
s
.686 .726 .881 r
.52552 .34522 m .50388 .36222 L .50941 .36497 L closepath p F P
0 g
s
.668 .712 .881 r
.52552 .34522 m .54213 .36477 L .54759 .36196 L closepath p F P
0 g
s
.834 .556 .517 r
.32363 .75164 m .37701 .77175 L .37665 .74627 L p F P
0 g
s
.834 .556 .517 r
.37665 .74627 m .32312 .72577 L .32363 .75164 L p F P
0 g
s
.782 .483 .483 r
.37901 .79568 m .43667 .80881 L .43547 .78528 L p F P
0 g
s
.782 .483 .483 r
.43547 .78528 m .37701 .77175 L .37901 .79568 L p F P
0 g
s
.557 .592 .845 r
.6485 .37848 m .64049 .39557 L .66672 .41355 L p F P
0 g
s
.583 .624 .858 r
.64049 .39557 m .6485 .37848 L .61891 .36652 L p F P
0 g
s
.583 .624 .858 r
.61891 .36652 m .61301 .37961 L .64049 .39557 L p F P
0 g
s
.771 .775 .856 r
.43871 .38065 m .43247 .36763 L .40299 .37993 L p F P
0 g
s
.745 .764 .868 r
.43247 .36763 m .43871 .38065 L .46697 .36652 L p F P
0 g
s
.529 .558 .829 r
.67688 .39272 m .66672 .41355 L .69147 .43339 L p F P
0 g
s
.557 .592 .845 r
.66672 .41355 m .67688 .39272 L .6485 .37848 L p F P
0 g
s
.623 .355 .49 r
.55883 .81503 m .61927 .80798 L .62055 .78442 L p F P
0 g
s
.557 .3 .482 r
.67865 .77033 m .62055 .78442 L .61927 .80798 L p F P
0 g
s
.575 .342 .526 r
.62055 .78442 m .67865 .77033 L .67904 .74483 L p F P
0 g
s
.842 .799 .81 r
.32298 .4299 m .3381 .45706 L .36094 .43529 L p F P
0 g
s
.842 .799 .81 r
.36094 .43529 m .34799 .41119 L .32298 .4299 L p F P
0 g
s
.5 .283 .516 r
.73204 .72379 m .67904 .74483 L .67865 .77033 L p F P
0 g
s
.521 .327 .558 r
.67904 .74483 m .73204 .72379 L .73033 .69683 L p F P
0 g
s
.609 .654 .869 r
.61301 .37961 m .61891 .36652 L .58836 .35694 L p F P
0 g
s
.609 .654 .869 r
.58836 .35694 m .58453 .36581 L .61301 .37961 L p F P
0 g
s
.687 .73 .883 r
.52552 .34522 m .49933 .35873 L .50388 .36222 L closepath p F P
0 g
s
.665 .712 .883 r
.52552 .34522 m .54759 .36196 L .55204 .35842 L closepath p F P
0 g
s
.5 .523 .812 r
.70377 .40912 m .69147 .43339 L .71452 .45492 L p F P
0 g
s
.529 .558 .829 r
.69147 .43339 m .70377 .40912 L .67688 .39272 L p F P
0 g
s
.903 .735 .663 r
.25641 .58412 m .29095 .61616 L .30068 .58821 L p F P
0 g
s
.903 .735 .663 r
.30068 .58821 m .26778 .55699 L .25641 .58412 L p F P
0 g
s
.745 .764 .868 r
.46697 .36652 m .4629 .35769 L .43247 .36763 L p F P
0 g
s
.717 .751 .879 r
.4629 .35769 m .46697 .36652 L .49599 .35466 L p F P
0 g
s
.716 .741 .871 r
.49933 .35873 m .49599 .35466 L .46697 .36652 L p F P
0 g
s
.635 .684 .879 r
.58453 .36581 m .58836 .35694 L .55714 .34982 L p F P
0 g
s
.635 .684 .879 r
.55714 .34982 m .55528 .35431 L .58453 .36581 L p F P
0 g
s
.864 .804 .79 r
.29998 .45046 m .31717 .48032 L .3381 .45706 L p F P
0 g
s
.864 .804 .79 r
.3381 .45706 m .32298 .4299 L .29998 .45046 L p F P
0 g
s
.688 .733 .885 r
.52552 .34522 m .49599 .35466 L .49933 .35873 L closepath p F P
0 g
s
.662 .712 .885 r
.52552 .34522 m .55204 .35842 L .55528 .35431 L closepath p F P
0 g
s
.421 .343 .663 r
.78551 .55421 m .75344 .58582 L .7633 .61371 L p F P
0 g
s
.45 .388 .696 r
.75344 .58582 m .78551 .55421 L .77134 .52783 L p F P
0 g
s
.468 .484 .792 r
.7289 .42756 m .71452 .45492 L .73565 .47797 L p F P
0 g
s
.5 .523 .812 r
.71452 .45492 m .7289 .42756 L .70377 .40912 L p F P
0 g
s
.883 .629 .549 r
.2768 .69902 m .32312 .72577 L .3248 .69882 L p F P
0 g
s
.883 .629 .549 r
.3248 .69882 m .2789 .67183 L .2768 .69902 L p F P
0 g
s
.717 .751 .879 r
.49599 .35466 m .49401 .3502 L .4629 .35769 L p F P
0 g
s
.688 .736 .888 r
.52552 .34522 m .49401 .3502 L .49599 .35466 L closepath p F P
0 g
s
.66 .713 .888 r
.52552 .34522 m .55528 .35431 L .55714 .34982 L closepath p F P
0 g
s
.886 .808 .767 r
.27923 .47271 m .29834 .50487 L .31717 .48032 L p F P
0 g
s
.886 .808 .767 r
.31717 .48032 m .29998 .45046 L .27923 .47271 L p F P
0 g
s
.723 .405 .441 r
.43887 .8304 m .49797 .83664 L .49728 .81531 L p F P
0 g
s
.723 .405 .441 r
.49728 .81531 m .43667 .80881 L .43887 .8304 L p F P
0 g
s
.668 .361 .445 r
.55883 .81503 m .49728 .81531 L .49797 .83664 L p F P
0 g
s
.668 .361 .445 r
.49797 .83664 m .55799 .83637 L .55883 .81503 L p F P
0 g
s
.607 .311 .44 r
.61927 .80798 m .55883 .81503 L .55799 .83637 L p F P
0 g
s
.432 .261 .547 r
.77552 .66935 m .73033 .69683 L .73204 .72379 L p F P
0 g
s
.459 .31 .59 r
.73033 .69683 m .77552 .66935 L .7707 .64164 L p F P
0 g
s
.745 .78 .881 r
.43049 .35393 m .43247 .36763 L .4629 .35769 L p F P
0 g
s
.745 .78 .881 r
.4629 .35769 m .46172 .34844 L .43049 .35393 L p F P
0 g
s
.716 .76 .887 r
.46172 .34844 m .4629 .35769 L .49401 .3502 L p F P
0 g
s
.434 .442 .768 r
.75203 .44788 m .73565 .47797 L .75466 .50234 L p F P
0 g
s
.468 .484 .792 r
.73565 .47797 m .75203 .44788 L .7289 .42756 L p F P
0 g
s
.772 .798 .874 r
.4001 .36197 m .40299 .37993 L .43247 .36763 L p F P
0 g
s
.772 .798 .874 r
.43247 .36763 m .43049 .35393 L .4001 .36197 L p F P
0 g
s
.596 .66 .883 r
.58929 .34767 m .58836 .35694 L .61891 .36652 L p F P
0 g
s
.628 .689 .887 r
.58836 .35694 m .58929 .34767 L .55753 .34515 L p F P
0 g
s
.628 .689 .887 r
.55753 .34515 m .55714 .34982 L .58836 .35694 L p F P
0 g
s
.716 .76 .887 r
.49401 .3502 m .49349 .34553 L .46172 .34844 L p F P
0 g
s
.687 .739 .89 r
.52552 .34522 m .49349 .34553 L .49401 .3502 L closepath p F P
0 g
s
.658 .715 .891 r
.52552 .34522 m .55714 .34982 L .55753 .34515 L closepath p F P
0 g
s
.917 .723 .626 r
.24787 .61163 m .28366 .64412 L .29095 .61616 L p F P
0 g
s
.917 .723 .626 r
.29095 .61616 m .25641 .58412 L .24787 .61163 L p F P
0 g
s
.563 .63 .875 r
.62051 .35279 m .61891 .36652 L .6485 .37848 L p F P
0 g
s
.596 .66 .883 r
.61891 .36652 m .62051 .35279 L .58929 .34767 L p F P
0 g
s
.8 .815 .864 r
.37085 .37251 m .37475 .39449 L .40299 .37993 L p F P
0 g
s
.8 .815 .864 r
.40299 .37993 m .4001 .36197 L .37085 .37251 L p F P
0 g
s
.681 .744 .899 r
.52552 .34522 m .50073 .33256 L .49692 .3365 L closepath p F P
0 g
s
.684 .743 .896 r
.52552 .34522 m .49692 .3365 L .49447 .3409 L closepath p F P
0 g
s
.686 .741 .893 r
.52552 .34522 m .49447 .3409 L .49349 .34553 L closepath p F P
0 g
s
.656 .717 .893 r
.52552 .34522 m .55753 .34515 L .55642 .34052 L closepath p F P
0 g
s
.656 .72 .896 r
.52552 .34522 m .55642 .34052 L .55385 .33615 L closepath p F P
0 g
s
.656 .724 .899 r
.52552 .34522 m .55385 .33615 L .54994 .33226 L closepath p F P
0 g
s
.657 .727 .901 r
.52552 .34522 m .54994 .33226 L .54486 .32902 L closepath p F P
0 g
s
.658 .731 .903 r
.52552 .34522 m .54486 .32902 L .53885 .32659 L closepath p F P
0 g
s
.661 .734 .904 r
.52552 .34522 m .53885 .32659 L .5322 .32511 L closepath p F P
0 g
s
.664 .738 .905 r
.52552 .34522 m .5322 .32511 L .52522 .32463 L closepath p F P
0 g
s
.667 .74 .905 r
.52552 .34522 m .52522 .32463 L .51826 .32519 L closepath p F P
0 g
s
.671 .742 .904 r
.52552 .34522 m .51826 .32519 L .51166 .32676 L closepath p F P
0 g
s
.674 .744 .903 r
.52552 .34522 m .51166 .32676 L .50572 .32925 L closepath p F P
0 g
s
.678 .744 .901 r
.52552 .34522 m .50572 .32925 L .50073 .33256 L closepath p F P
0 g
s
.834 .524 .466 r
.32638 .77616 m .37901 .79568 L .37701 .77175 L p F P
0 g
s
.834 .524 .466 r
.37701 .77175 m .32363 .75164 L .32638 .77616 L p F P
0 g
s
.388 .293 .626 r
.79699 .58126 m .7633 .61371 L .7707 .64164 L p F P
0 g
s
.421 .343 .663 r
.7633 .61371 m .79699 .58126 L .78551 .55421 L p F P
0 g
s
.528 .596 .866 r
.65091 .36046 m .6485 .37848 L .67688 .39272 L p F P
0 g
s
.563 .63 .875 r
.6485 .37848 m .65091 .36046 L .62051 .35279 L p F P
0 g
s
.907 .809 .739 r
.26096 .49646 m .28181 .5305 L .29834 .50487 L p F P
0 g
s
.907 .809 .739 r
.29834 .50487 m .27923 .47271 L .26096 .49646 L p F P
0 g
s
.713 .768 .895 r
.46352 .33919 m .46172 .34844 L .49349 .34553 L p F P
0 g
s
.713 .768 .895 r
.49349 .34553 m .49447 .3409 L .46352 .33919 L p F P
0 g
s
.557 .3 .482 r
.61927 .80798 m .67657 .7943 L .67865 .77033 L p F P
0 g
s
.474 .23 .464 r
.7315 .7497 m .67865 .77033 L .67657 .7943 L p F P
0 g
s
.5 .283 .516 r
.67865 .77033 m .7315 .7497 L .73204 .72379 L p F P
0 g
s
.623 .695 .896 r
.55642 .34052 m .55753 .34515 L .58929 .34767 L p F P
0 g
s
.775 .445 .429 r
.38267 .81778 m .43887 .8304 L .43667 .80881 L p F P
0 g
s
.775 .445 .429 r
.43667 .80881 m .37901 .79568 L .38267 .81778 L p F P
0 g
s
.827 .831 .851 r
.34301 .38548 m .34799 .41119 L .37475 .39449 L p F P
0 g
s
.827 .831 .851 r
.37475 .39449 m .37085 .37251 L .34301 .38548 L p F P
0 g
s
.607 .311 .44 r
.55799 .83637 m .61693 .8296 L .61927 .80798 L p F P
0 g
s
.535 .249 .427 r
.67657 .7943 m .61927 .80798 L .61693 .8296 L p F P
0 g
s
.396 .395 .741 r
.77289 .46993 m .75466 .50234 L .77134 .52783 L p F P
0 g
s
.434 .442 .768 r
.75466 .50234 m .77289 .46993 L .75203 .44788 L p F P
0 g
s
.49 .559 .854 r
.68018 .37066 m .67688 .39272 L .70377 .40912 L p F P
0 g
s
.528 .596 .866 r
.67688 .39272 m .68018 .37066 L .65091 .36046 L p F P
0 g
s
.74 .794 .896 r
.43296 .34016 m .43049 .35393 L .46172 .34844 L p F P
0 g
s
.74 .794 .896 r
.46172 .34844 m .46352 .33919 L .43296 .34016 L p F P
0 g
s
.586 .669 .897 r
.58722 .33844 m .58929 .34767 L .62051 .35279 L p F P
0 g
s
.623 .695 .896 r
.58929 .34767 m .58722 .33844 L .55642 .34052 L p F P
0 g
s
.707 .774 .904 r
.46828 .33039 m .46352 .33919 L .49447 .3409 L p F P
0 g
s
.707 .774 .904 r
.49447 .3409 m .49692 .3365 L .46828 .33039 L p F P
0 g
s
.619 .703 .905 r
.55385 .33615 m .55642 .34052 L .58722 .33844 L p F P
0 g
s
.888 .602 .498 r
.27744 .72542 m .32363 .75164 L .32312 .72577 L p F P
0 g
s
.888 .602 .498 r
.32312 .72577 m .2768 .69902 L .27744 .72542 L p F P
0 g
s
.854 .846 .835 r
.3169 .40081 m .32298 .4299 L .34799 .41119 L p F P
0 g
s
.854 .846 .835 r
.34799 .41119 m .34301 .38548 L .3169 .40081 L p F P
0 g
s
.768 .82 .893 r
.40308 .34383 m .4001 .36197 L .43049 .35393 L p F P
0 g
s
.768 .82 .893 r
.43049 .35393 m .43296 .34016 L .40308 .34383 L p F P
0 g
s
.929 .707 .582 r
.24231 .63926 m .2789 .67183 L .28366 .64412 L p F P
0 g
s
.929 .707 .582 r
.28366 .64412 m .24787 .61163 L .24231 .63926 L p F P
0 g
s
.398 .203 .496 r
.77764 .69656 m .73204 .72379 L .7315 .7497 L p F P
0 g
s
.432 .261 .547 r
.73204 .72379 m .77764 .69656 L .77552 .66935 L p F P
0 g
s
.699 .778 .913 r
.47579 .32245 m .46828 .33039 L .49692 .3365 L p F P
0 g
s
.699 .778 .913 r
.49692 .3365 m .50073 .33256 L .47579 .32245 L p F P
0 g
s
.928 .807 .706 r
.24541 .52151 m .26778 .55699 L .28181 .5305 L p F P
0 g
s
.928 .807 .706 r
.28181 .5305 m .26096 .49646 L .24541 .52151 L p F P
0 g
s
.618 .713 .913 r
.54994 .33226 m .55385 .33615 L .58222 .32969 L p F P
0 g
s
.619 .703 .905 r
.58722 .33844 m .58222 .32969 L .55385 .33615 L p F P
0 g
s
.447 .518 .838 r
.70803 .38332 m .70377 .40912 L .7289 .42756 L p F P
0 g
s
.49 .559 .854 r
.70377 .40912 m .70803 .38332 L .68018 .37066 L p F P
0 g
s
.545 .64 .895 r
.61766 .33904 m .62051 .35279 L .65091 .36046 L p F P
0 g
s
.586 .669 .897 r
.62051 .35279 m .61766 .33904 L .58722 .33844 L p F P
0 g
s
.349 .235 .58 r
.80561 .60873 m .7707 .64164 L .77552 .66935 L p F P
0 g
s
.388 .293 .626 r
.7707 .64164 m .80561 .60873 L .79699 .58126 L p F P
0 g
s
.353 .342 .707 r
.79126 .49351 m .77134 .52783 L .78551 .55421 L p F P
0 g
s
.396 .395 .741 r
.77134 .52783 m .79126 .49351 L .77289 .46993 L p F P
0 g
s
.732 .806 .91 r
.43987 .32699 m .43296 .34016 L .46352 .33919 L p F P
0 g
s
.732 .806 .91 r
.46352 .33919 m .46828 .33039 L .43987 .32699 L p F P
0 g
s
.689 .78 .92 r
.48573 .31579 m .47579 .32245 L .50073 .33256 L p F P
0 g
s
.689 .78 .92 r
.50073 .33256 m .50572 .32925 L .48573 .31579 L p F P
0 g
s
.618 .713 .913 r
.58222 .32969 m .57449 .32185 L .54994 .33226 L p F P
0 g
s
.62 .724 .921 r
.54486 .32902 m .54994 .33226 L .57449 .32185 L p F P
0 g
s
.577 .682 .912 r
.58222 .32969 m .58722 .33844 L .61766 .33904 L p F P
0 g
s
.709 .357 .379 r
.44208 .84977 m .49898 .8557 L .49797 .83664 L p F P
0 g
s
.709 .357 .379 r
.49797 .83664 m .43887 .8304 L .44208 .84977 L p F P
0 g
s
.651 .311 .384 r
.55799 .83637 m .49797 .83664 L .49898 .8557 L p F P
0 g
s
.651 .311 .384 r
.49898 .8557 m .55678 .85544 L .55799 .83637 L p F P
0 g
s
.585 .256 .378 r
.61693 .8296 m .55799 .83637 L .55678 .85544 L p F P
0 g
s
.881 .859 .815 r
.29278 .41837 m .29998 .45046 L .32298 .4299 L p F P
0 g
s
.881 .859 .815 r
.32298 .4299 m .3169 .40081 L .29278 .41837 L p F P
0 g
s
.796 .846 .888 r
.37419 .35022 m .37085 .37251 L .4001 .36197 L p F P
0 g
s
.796 .846 .888 r
.4001 .36197 m .40308 .34383 L .37419 .35022 L p F P
0 g
s
.677 .778 .926 r
.49763 .31073 m .48573 .31579 L .50572 .32925 L p F P
0 g
s
.677 .778 .926 r
.50572 .32925 m .51166 .32676 L .49763 .31073 L p F P
0 g
s
.62 .724 .921 r
.57449 .32185 m .56437 .3153 L .54486 .32902 L p F P
0 g
s
.624 .736 .927 r
.53885 .32659 m .54486 .32902 L .56437 .3153 L p F P
0 g
s
.499 .606 .89 r
.64742 .34235 m .65091 .36046 L .68018 .37066 L p F P
0 g
s
.545 .64 .895 r
.65091 .36046 m .64742 .34235 L .61766 .33904 L p F P
0 g
s
.4 .471 .818 r
.73418 .39836 m .7289 .42756 L .75203 .44788 L p F P
0 g
s
.447 .518 .838 r
.7289 .42756 m .73418 .39836 L .70803 .38332 L p F P
0 g
s
.829 .484 .404 r
.33143 .79905 m .38267 .81778 L .37901 .79568 L p F P
0 g
s
.829 .484 .404 r
.37901 .79568 m .32638 .77616 L .33143 .79905 L p F P
0 g
s
.665 .774 .931 r
.51091 .30755 m .49763 .31073 L .51166 .32676 L p F P
0 g
s
.665 .774 .931 r
.51166 .32676 m .51826 .32519 L .51091 .30755 L p F P
0 g
s
.624 .736 .927 r
.56437 .3153 m .55233 .3104 L .53885 .32659 L p F P
0 g
s
.631 .747 .931 r
.5322 .32511 m .53885 .32659 L .55233 .3104 L p F P
0 g
s
.535 .249 .427 r
.61693 .8296 m .67278 .81647 L .67657 .7943 L p F P
0 g
s
.441 .167 .4 r
.72867 .77428 m .67657 .7943 L .67278 .81647 L p F P
0 g
s
.474 .23 .464 r
.67657 .7943 m .72867 .77428 L .7315 .7497 L p F P
0 g
s
.652 .767 .933 r
.52492 .30641 m .51091 .30755 L .51826 .32519 L p F P
0 g
s
.652 .767 .933 r
.51826 .32519 m .52522 .32463 L .52492 .30641 L p F P
0 g
s
.947 .802 .667 r
.23278 .54763 m .25641 .58412 L .26778 .55699 L p F P
0 g
s
.947 .802 .667 r
.26778 .55699 m .24541 .52151 L .23278 .54763 L p F P
0 g
s
.631 .747 .931 r
.55233 .3104 m .53896 .30738 L .5322 .32511 L p F P
0 g
s
.641 .758 .933 r
.52522 .32463 m .5322 .32511 L .53896 .30738 L p F P
0 g
s
.641 .758 .933 r
.53896 .30738 m .52492 .30641 L .52522 .32463 L p F P
0 g
s
.718 .815 .925 r
.45096 .31507 m .43987 .32699 L .46828 .33039 L p F P
0 g
s
.718 .815 .925 r
.46828 .33039 m .47579 .32245 L .45096 .31507 L p F P
0 g
s
.573 .698 .926 r
.57449 .32185 m .58222 .32969 L .61038 .32595 L p F P
0 g
s
.577 .682 .912 r
.61766 .33904 m .61038 .32595 L .58222 .32969 L p F P
0 g
s
.764 .397 .36 r
.38802 .83779 m .44208 .84977 L .43887 .8304 L p F P
0 g
s
.764 .397 .36 r
.43887 .8304 m .38267 .81778 L .38802 .83779 L p F P
0 g
s
.757 .839 .914 r
.41197 .3264 m .40308 .34383 L .43296 .34016 L p F P
0 g
s
.757 .839 .914 r
.43296 .34016 m .43987 .32699 L .41197 .3264 L p F P
0 g
s
.938 .685 .528 r
.23984 .66673 m .2768 .69902 L .2789 .67183 L p F P
0 g
s
.938 .685 .528 r
.2789 .67183 m .24231 .63926 L .23984 .66673 L p F P
0 g
s
.304 .28 .667 r
.80691 .51844 m .78551 .55421 L .79699 .58126 L p F P
0 g
s
.353 .342 .707 r
.78551 .55421 m .80691 .51844 L .79126 .49351 L p F P
0 g
s
.585 .256 .378 r
.55678 .85544 m .61352 .84901 L .61693 .8296 L p F P
0 g
s
.505 .185 .358 r
.67278 .81647 m .61693 .8296 L .61352 .84901 L p F P
0 g
s
.528 .655 .916 r
.61038 .32595 m .61766 .33904 L .64742 .34235 L p F P
0 g
s
.825 .871 .879 r
.34658 .35931 m .34301 .38548 L .37085 .37251 L p F P
0 g
s
.825 .871 .879 r
.37085 .37251 m .37419 .35022 L .34658 .35931 L p F P
0 g
s
.908 .871 .79 r
.27095 .43805 m .27923 .47271 L .29998 .45046 L p F P
0 g
s
.908 .871 .79 r
.29998 .45046 m .29278 .41837 L .27095 .43805 L p F P
0 g
s
.888 .568 .436 r
.28088 .75073 m .32638 .77616 L .32363 .75164 L p F P
0 g
s
.888 .568 .436 r
.32363 .75164 m .27744 .72542 L .28088 .75073 L p F P
0 g
s
.446 .565 .882 r
.67621 .3484 m .68018 .37066 L .70803 .38332 L p F P
0 g
s
.499 .606 .89 r
.68018 .37066 m .67621 .3484 L .64742 .34235 L p F P
0 g
s
.303 .167 .525 r
.81122 .63635 m .77552 .66935 L .77764 .69656 L p F P
0 g
s
.349 .235 .58 r
.77552 .66935 m .81122 .63635 L .80561 .60873 L p F P
0 g
s
.358 .134 .432 r
.77698 .723 m .7315 .7497 L .72867 .77428 L p F P
0 g
s
.398 .203 .496 r
.7315 .7497 m .77698 .723 L .77764 .69656 L p F P
0 g
s
.346 .417 .792 r
.75833 .41567 m .75203 .44788 L .77289 .46993 L p F P
0 g
s
.4 .471 .818 r
.75203 .44788 m .75833 .41567 L .73418 .39836 L p F P
0 g
s
.699 .818 .939 r
.46576 .30502 m .45096 .31507 L .47579 .32245 L p F P
0 g
s
.699 .818 .939 r
.47579 .32245 m .48573 .31579 L .46576 .30502 L p F P
0 g
s
.573 .698 .926 r
.61038 .32595 m .59895 .31416 L .57449 .32185 L p F P
0 g
s
.573 .716 .94 r
.56437 .3153 m .57449 .32185 L .59895 .31416 L p F P
0 g
s
.965 .792 .618 r
.22328 .57458 m .24787 .61163 L .25641 .58412 L p F P
0 g
s
.965 .792 .618 r
.25641 .58412 m .23278 .54763 L .22328 .57458 L p F P
0 g
s
.782 .873 .914 r
.38486 .3287 m .37419 .35022 L .40308 .34383 L p F P
0 g
s
.782 .873 .914 r
.40308 .34383 m .41197 .3264 L .38486 .3287 L p F P
0 g
s
.854 .896 .865 r
.32056 .37107 m .3169 .40081 L .34301 .38548 L p F P
0 g
s
.854 .896 .865 r
.34301 .38548 m .34658 .35931 L .32056 .37107 L p F P
0 g
s
.934 .879 .757 r
.25167 .45967 m .26096 .49646 L .27923 .47271 L p F P
0 g
s
.934 .879 .757 r
.27923 .47271 m .27095 .43805 L .25167 .45967 L p F P
0 g
s
.47 .622 .917 r
.63804 .32502 m .64742 .34235 L .67621 .3484 L p F P
0 g
s
.528 .655 .916 r
.64742 .34235 m .63804 .32502 L .61038 .32595 L p F P
0 g
s
.737 .853 .935 r
.42647 .31056 m .41197 .3264 L .43987 .32699 L p F P
0 g
s
.737 .853 .935 r
.43987 .32699 m .45096 .31507 L .42647 .31056 L p F P
0 g
s
.677 .816 .95 r
.48357 .29738 m .46576 .30502 L .48573 .31579 L p F P
0 g
s
.677 .816 .95 r
.48573 .31579 m .49763 .31073 L .48357 .29738 L p F P
0 g
s
.385 .517 .868 r
.70373 .35717 m .70803 .38332 L .73418 .39836 L p F P
0 g
s
.446 .565 .882 r
.70803 .38332 m .70373 .35717 L .67621 .3484 L p F P
0 g
s
.247 .209 .617 r
.8196 .54447 m .79699 .58126 L .80561 .60873 L p F P
0 g
s
.304 .28 .667 r
.79699 .58126 m .8196 .54447 L .80691 .51844 L p F P
0 g
s
.573 .716 .94 r
.59895 .31416 m .58387 .30429 L .56437 .3153 L p F P
0 g
s
.578 .737 .951 r
.55233 .3104 m .56437 .3153 L .58387 .30429 L p F P
0 g
s
.516 .676 .937 r
.59895 .31416 m .61038 .32595 L .63804 .32502 L p F P
0 g
s
.284 .353 .758 r
.7802 .43512 m .77289 .46993 L .79126 .49351 L p F P
0 g
s
.346 .417 .792 r
.77289 .46993 m .7802 .43512 L .75833 .41567 L p F P
0 g
s
.687 .295 .297 r
.44631 .86666 m .50032 .87222 L .49898 .8557 L p F P
0 g
s
.687 .295 .297 r
.49898 .8557 m .44208 .84977 L .44631 .86666 L p F P
0 g
s
.626 .247 .305 r
.55678 .85544 m .49898 .8557 L .50032 .87222 L p F P
0 g
s
.626 .247 .305 r
.50032 .87222 m .55519 .87198 L .55678 .85544 L p F P
0 g
s
.554 .185 .296 r
.61352 .84901 m .55678 .85544 L .55519 .87198 L p F P
0 g
s
.817 .431 .323 r
.33878 .82003 m .38802 .83779 L .38267 .81778 L p F P
0 g
s
.817 .431 .323 r
.38267 .81778 m .33143 .79905 L .33878 .82003 L p F P
0 g
s
.943 .654 .461 r
.24059 .69376 m .27744 .72542 L .2768 .69902 L p F P
0 g
s
.943 .654 .461 r
.2768 .69902 m .23984 .66673 L .24059 .69376 L p F P
0 g
s
.653 .808 .958 r
.50353 .29256 m .48357 .29738 L .49763 .31073 L p F P
0 g
s
.653 .808 .958 r
.49763 .31073 m .51091 .30755 L .50353 .29256 L p F P
0 g
s
.505 .185 .358 r
.61352 .84901 m .66724 .83654 L .67278 .81647 L p F P
0 g
s
.397 .087 .319 r
.7235 .79725 m .67278 .81647 L .66724 .83654 L p F P
0 g
s
.441 .167 .4 r
.67278 .81647 m .7235 .79725 L .72867 .77428 L p F P
0 g
s
.578 .737 .951 r
.58387 .30429 m .56584 .29687 L .55233 .3104 L p F P
0 g
s
.59 .758 .958 r
.53896 .30738 m .55233 .3104 L .56584 .29687 L p F P
0 g
s
.248 .086 .456 r
.8137 .66385 m .77764 .69656 L .77698 .723 L p F P
0 g
s
.303 .167 .525 r
.77764 .69656 m .8137 .66385 L .81122 .63635 L p F P
0 g
s
.882 .521 .357 r
.28719 .77466 m .33143 .79905 L .32638 .77616 L p F P
0 g
s
.882 .521 .357 r
.32638 .77616 m .28088 .75073 L .28719 .77466 L p F P
0 g
s
.629 .795 .962 r
.52461 .29083 m .50353 .29256 L .51091 .30755 L p F P
0 g
s
.629 .795 .962 r
.51091 .30755 m .52492 .30641 L .52461 .29083 L p F P
0 g
s
.59 .758 .958 r
.56584 .29687 m .54575 .2923 L .53896 .30738 L p F P
0 g
s
.607 .778 .962 r
.52492 .30641 m .53896 .30738 L .54575 .2923 L p F P
0 g
s
.883 .918 .844 r
.29644 .38545 m .29278 .41837 L .3169 .40081 L p F P
0 g
s
.883 .918 .844 r
.3169 .40081 m .32056 .37107 L .29644 .38545 L p F P
0 g
s
.607 .778 .962 r
.54575 .2923 m .52461 .29083 L .52492 .30641 L p F P
0 g
s
.306 .049 .351 r
.77346 .74838 m .72867 .77428 L .7235 .79725 L p F P
0 g
s
.358 .134 .432 r
.72867 .77428 m .77346 .74838 L .77698 .723 L p F P
0 g
s
.743 .332 .271 r
.39505 .85543 m .44631 .86666 L .44208 .84977 L p F P
0 g
s
.743 .332 .271 r
.44208 .84977 m .38802 .83779 L .39505 .85543 L p F P
0 g
s
.808 .908 .909 r
.35886 .33393 m .34658 .35931 L .37419 .35022 L p F P
0 g
s
.808 .908 .909 r
.37419 .35022 m .38486 .3287 L .35886 .33393 L p F P
0 g
s
.959 .883 .715 r
.23522 .48307 m .24541 .52151 L .26096 .49646 L p F P
0 g
s
.959 .883 .715 r
.26096 .49646 m .25167 .45967 L .23522 .48307 L p F P
0 g
s
.979 .774 .558 r
.21708 .60209 m .24231 .63926 L .24787 .61163 L p F P
0 g
s
.979 .774 .558 r
.24787 .61163 m .22328 .57458 L .21708 .60209 L p F P
0 g
s
.554 .185 .296 r
.55519 .87198 m .60903 .86594 L .61352 .84901 L p F P
0 g
s
.463 .102 .267 r
.66724 .83654 m .61352 .84901 L .60903 .86594 L p F P
0 g
s
.708 .86 .954 r
.44599 .29716 m .42647 .31056 L .45096 .31507 L p F P
0 g
s
.708 .86 .954 r
.45096 .31507 m .46576 .30502 L .44599 .29716 L p F P
0 g
s
.313 .458 .846 r
.72967 .36863 m .73418 .39836 L .75833 .41567 L p F P
0 g
s
.385 .517 .868 r
.73418 .39836 m .72967 .36863 L .70373 .35717 L p F P
0 g
s
.516 .676 .937 r
.63804 .32502 m .62309 .30936 L .59895 .31416 L p F P
0 g
s
.511 .701 .956 r
.58387 .30429 m .59895 .31416 L .62309 .30936 L p F P
0 g
s
.399 .578 .912 r
.66492 .32699 m .67621 .3484 L .70373 .35717 L p F P
0 g
s
.47 .622 .917 r
.67621 .3484 m .66492 .32699 L .63804 .32502 L p F P
0 g
s
.211 .278 .715 r
.79951 .45656 m .79126 .49351 L .80691 .51844 L p F P
0 g
s
.284 .353 .758 r
.79126 .49351 m .79951 .45656 L .7802 .43512 L p F P
0 g
s
.179 .124 .554 r
.82915 .57136 m .80561 .60873 L .81122 .63635 L p F P
0 g
s
.247 .209 .617 r
.80561 .60873 m .82915 .57136 L .8196 .54447 L p F P
0 g
s
.754 .894 .941 r
.40259 .30907 m .38486 .3287 L .41197 .3264 L p F P
0 g
s
.754 .894 .941 r
.41197 .3264 m .42647 .31056 L .40259 .30907 L p F P
0 g
s
.445 .644 .943 r
.62309 .30936 m .63804 .32502 L .66492 .32699 L p F P
0 g
s
.941 .61 .376 r
.24463 .72003 m .28088 .75073 L .27744 .72542 L p F P
0 g
s
.941 .61 .376 r
.27744 .72542 m .24059 .69376 L .24463 .72003 L p F P
0 g
s
.671 .857 .97 r
.46963 .28693 m .44599 .29716 L .46576 .30502 L p F P
0 g
s
.671 .857 .97 r
.46576 .30502 m .48357 .29738 L .46963 .28693 L p F P
0 g
s
.911 .938 .813 r
.27453 .40237 m .27095 .43805 L .29278 .41837 L p F P
0 g
s
.911 .938 .813 r
.29278 .41837 m .29644 .38545 L .27453 .40237 L p F P
0 g
s
.511 .701 .956 r
.62309 .30936 m .60318 .29619 L .58387 .30429 L p F P
0 g
s
.514 .731 .972 r
.56584 .29687 m .58387 .30429 L .60318 .29619 L p F P
0 g
s
.98 .88 .66 r
.22183 .50802 m .23278 .54763 L .24541 .52151 L p F P
0 g
s
.98 .88 .66 r
.24541 .52151 m .23522 .48307 L .22183 .50802 L p F P
0 g
s
.179 0 .368 r
.81293 .69093 m .77698 .723 L .77346 .74838 L p F P
0 g
s
.248 .086 .456 r
.77698 .723 m .81293 .69093 L .8137 .66385 L p F P
0 g
s
.833 .941 .896 r
.33425 .34213 m .32056 .37107 L .34658 .35931 L p F P
0 g
s
.833 .941 .896 r
.34658 .35931 m .35886 .33393 L .33425 .34213 L p F P
0 g
s
.226 .386 .814 r
.75372 .38275 m .75833 .41567 L .7802 .43512 L p F P
0 g
s
.313 .458 .846 r
.75833 .41567 m .75372 .38275 L .72967 .36863 L p F P
0 g
s
.792 .358 .217 r
.34846 .83879 m .39505 .85543 L .38802 .83779 L p F P
0 g
s
.792 .358 .217 r
.38802 .83779 m .33878 .82003 L .34846 .83879 L p F P
0 g
s
.987 .746 .48 r
.21434 .62987 m .23984 .66673 L .24231 .63926 L p F P
0 g
s
.987 .746 .48 r
.24231 .63926 m .21708 .60209 L .21434 .62987 L p F P
0 g
s
.311 .521 .898 r
.69072 .33192 m .70373 .35717 L .72967 .36863 L p F P
0 g
s
.399 .578 .912 r
.70373 .35717 m .69072 .33192 L .66492 .32699 L p F P
0 g
s
.125 .187 .657 r
.81599 .47981 m .80691 .51844 L .8196 .54447 L p F P
0 g
s
.211 .278 .715 r
.80691 .51844 m .81599 .47981 L .79951 .45656 L p F P
0 g
s
.651 .209 .188 r
.45156 .88078 m .50197 .88592 L .50032 .87222 L p F P
0 g
s
.651 .209 .188 r
.50032 .87222 m .44631 .86666 L .45156 .88078 L p F P
0 g
s
.587 .16 .199 r
.55519 .87198 m .50032 .87222 L .50197 .88592 L p F P
0 g
s
.587 .16 .199 r
.50197 .88592 m .55321 .8857 L .55519 .87198 L p F P
0 g
s
.507 .091 .186 r
.60903 .86594 m .55519 .87198 L .55321 .8857 L p F P
0 g
s
.463 .102 .267 r
.60903 .86594 m .65996 .85426 L .66724 .83654 L p F P
0 g
s
.337 0 .211 r
.71597 .81832 m .66724 .83654 L .65996 .85426 L p F P
0 g
s
.397 .087 .319 r
.66724 .83654 m .71597 .81832 L .7235 .79725 L p F P
0 g
s
.865 .457 .254 r
.29637 .79691 m .33878 .82003 L .33143 .79905 L p F P
0 g
s
.865 .457 .254 r
.33143 .79905 m .28719 .77466 L .29637 .79691 L p F P
0 g
s
.63 .844 .982 r
.49619 .28047 m .46963 .28693 L .48357 .29738 L p F P
0 g
s
.63 .844 .982 r
.48357 .29738 m .50353 .29256 L .49619 .28047 L p F P
0 g
s
.514 .731 .972 r
.60318 .29619 m .57925 .28625 L .56584 .29687 L p F P
0 g
s
.529 .762 .983 r
.54575 .2923 m .56584 .29687 L .57925 .28625 L p F P
0 g
s
.098 .022 .473 r
.83538 .59885 m .81122 .63635 L .8137 .66385 L p F P
0 g
s
.179 .124 .554 r
.81122 .63635 m .83538 .59885 L .82915 .57136 L p F P
0 g
s
.238 0 .246 r
.76705 .77241 m .7235 .79725 L .71597 .81832 L p F P
0 g
s
.306 .049 .351 r
.7235 .79725 m .76705 .77241 L .77346 .74838 L p F P
0 g
s
.711 .903 .964 r
.42665 .29239 m .40259 .30907 L .42647 .31056 L p F P
0 g
s
.711 .903 .964 r
.42647 .31056 m .44599 .29716 L .42665 .29239 L p F P
0 g
s
.769 .935 .938 r
.37958 .31069 m .35886 .33393 L .38486 .3287 L p F P
0 g
s
.769 .935 .938 r
.38486 .3287 m .40259 .30907 L .37958 .31069 L p F P
0 g
s
.445 .644 .943 r
.66492 .32699 m .64662 .30756 L .62309 .30936 L p F P
0 g
s
.427 .674 .966 r
.60318 .29619 m .62309 .30936 L .64662 .30756 L p F P
0 g
s
.589 .822 .988 r
.52431 .27816 m .49619 .28047 L .50353 .29256 L p F P
0 g
s
.589 .822 .988 r
.50353 .29256 m .52461 .29083 L .52431 .27816 L p F P
0 g
s
.352 .599 .94 r
.64662 .30756 m .66492 .32699 L .69072 .33192 L p F P
0 g
s
.529 .762 .983 r
.57925 .28625 m .55249 .28012 L .54575 .2923 L p F P
0 g
s
.554 .794 .988 r
.52461 .29083 m .54575 .2923 L .55249 .28012 L p F P
0 g
s
.705 .242 .15 r
.40377 .87041 m .45156 .88078 L .44631 .86666 L p F P
0 g
s
.705 .242 .15 r
.44631 .86666 m .39505 .85543 L .40377 .87041 L p F P
0 g
s
.554 .794 .988 r
.55249 .28012 m .52431 .27816 L .52461 .29083 L p F P
0 g
s
.935 .952 .768 r
.25512 .42169 m .25167 .45967 L .27095 .43805 L p F P
0 g
s
.935 .952 .768 r
.27095 .43805 m .27453 .40237 L .25512 .42169 L p F P
0 g
s
.507 .091 .186 r
.55321 .8857 m .60347 .88012 L .60903 .86594 L p F P
0 g
s
.402 0 .145 r
.65996 .85426 m .60903 .86594 L .60347 .88012 L p F P
0 g
s
.995 .866 .586 r
.21174 .5343 m .22328 .57458 L .23278 .54763 L p F P
0 g
s
.995 .866 .586 r
.23278 .54763 m .22183 .50802 L .21174 .5343 L p F P
0 g
s
.122 .295 .767 r
.77558 .39943 m .7802 .43512 L .79951 .45656 L p F P
0 g
s
.226 .386 .814 r
.7802 .43512 m .77558 .39943 L .75372 .38275 L p F P
0 g
s
.854 .971 .869 r
.31136 .3533 m .29644 .38545 L .32056 .37107 L p F P
0 g
s
.854 .971 .869 r
.32056 .37107 m .33425 .34213 L .31136 .3533 L p F P
0 g
s
.926 .548 .267 r
.25201 .74524 m .28719 .77466 L .28088 .75073 L p F P
0 g
s
.926 .548 .267 r
.28088 .75073 m .24463 .72003 L .25201 .74524 L p F P
0 g
s
.022 .077 .581 r
.8294 .50466 m .8196 .54447 L .82915 .57136 L p F P
0 g
s
.125 .187 .657 r
.8196 .54447 m .8294 .50466 L .81599 .47981 L p F P
0 g
s
.201 .446 .87 r
.71513 .33983 m .72967 .36863 L .75372 .38275 L p F P
0 g
s
.311 .521 .898 r
.72967 .36863 m .71513 .33983 L .69072 .33192 L p F P
0 g
s
.984 .702 .38 r
.21517 .65762 m .24059 .69376 L .23984 .66673 L p F P
0 g
s
.984 .702 .38 r
.23984 .66673 m .21434 .62987 L .21517 .65762 L p F P
0 g
s
.093 0 .255 r
.80883 .71729 m .77346 .74838 L .76705 .77241 L p F P
0 g
s
.179 0 .368 r
.77346 .74838 m .80883 .71729 L .81293 .69093 L p F P
0 g
s
.653 .896 .982 r
.45594 .27963 m .42665 .29239 L .44599 .29716 L p F P
0 g
s
.653 .896 .982 r
.44599 .29716 m .46963 .28693 L .45594 .27963 L p F P
0 g
s
.427 .674 .966 r
.64662 .30756 m .62207 .29118 L .60318 .29619 L p F P
0 g
s
.422 .711 .983 r
.57925 .28625 m .60318 .29619 L .62207 .29118 L p F P
0 g
s
0 0 .37 r
.83813 .62666 m .8137 .66385 L .81293 .69093 L p F P
0 g
s
.098 .022 .473 r
.8137 .66385 m .83813 .62666 L .83538 .59885 L p F P
0 g
s
.777 .971 .919 r
.35774 .31553 m .33425 .34213 L .35886 .33393 L p F P
0 g
s
.777 .971 .919 r
.35886 .33393 m .37958 .31069 L .35774 .31553 L p F P
0 g
s
.827 .366 .119 r
.30842 .81718 m .34846 .83879 L .33878 .82003 L p F P
0 g
s
.827 .366 .119 r
.33878 .82003 m .29637 .79691 L .30842 .81718 L p F P
0 g
s
.951 .955 .702 r
.23851 .44328 m .23522 .48307 L .25167 .45967 L p F P
0 g
s
.951 .955 .702 r
.25167 .45967 m .25512 .42169 L .23851 .44328 L p F P
0 g
s
.745 .256 .075 r
.36042 .85507 m .40377 .87041 L .39505 .85543 L p F P
0 g
s
.745 .256 .075 r
.39505 .85543 m .34846 .83879 L .36042 .85507 L p F P
0 g
s
.703 .943 .96 r
.40796 .29088 m .37958 .31069 L .40259 .30907 L p F P
0 g
s
.703 .943 .96 r
.40259 .30907 m .42665 .29239 L .40796 .29088 L p F P
0 g
s
.229 .531 .921 r
.6693 .30891 m .69072 .33192 L .71513 .33983 L p F P
0 g
s
.352 .599 .94 r
.69072 .33192 m .6693 .30891 L .64662 .30756 L p F P
0 g
s
.402 0 .145 r
.60347 .88012 m .65094 .86933 L .65996 .85426 L p F P
0 g
s
.253 0 .066 r
.70607 .83719 m .65996 .85426 L .65094 .86933 L p F P
0 g
s
.337 0 .211 r
.65996 .85426 m .70607 .83719 L .71597 .81832 L p F P
0 g
s
.149 0 .107 r
.75771 .79478 m .71597 .81832 L .70607 .83719 L p F P
0 g
s
.238 0 .246 r
.71597 .81832 m .75771 .79478 L .76705 .77241 L p F P
0 g
s
.31 .627 .961 r
.62207 .29118 m .64662 .30756 L .6693 .30891 L p F P
0 g
s
0 .182 .698 r
.79494 .41856 m .79951 .45656 L .81599 .47981 L p F P
0 g
s
.122 .295 .767 r
.79951 .45656 m .79494 .41856 L .77558 .39943 L p F P
0 g
s
.997 .836 .49 r
.20515 .56163 m .21708 .60209 L .22328 .57458 L p F P
0 g
s
.997 .836 .49 r
.22328 .57458 m .21174 .5343 L .20515 .56163 L p F P
0 g
s
.586 .874 .994 r
.48898 .27155 m .45594 .27963 L .46963 .28693 L p F P
0 g
s
.586 .874 .994 r
.46963 .28693 m .49619 .28047 L .48898 .27155 L p F P
0 g
s
.589 .09 .036 r
.45781 .89188 m .50394 .89654 L .50197 .88592 L p F P
0 g
s
.589 .09 .036 r
.50197 .88592 m .45156 .88078 L .45781 .89188 L p F P
0 g
s
.522 .04 .052 r
.55321 .8857 m .50197 .88592 L .50394 .89654 L p F P
0 g
s
.522 .04 .052 r
.50394 .89654 m .55086 .89634 L .55321 .8857 L p F P
0 g
s
.433 0 .033 r
.60347 .88012 m .55321 .8857 L .55086 .89634 L p F P
0 g
s
.422 .711 .983 r
.62207 .29118 m .5924 .27878 L .57925 .28625 L p F P
0 g
s
.435 .752 .994 r
.55249 .28012 m .57925 .28625 L .5924 .27878 L p F P
0 g
s
.867 .992 .821 r
.29049 .3674 m .27453 .40237 L .29644 .38545 L p F P
0 g
s
.867 .992 .821 r
.29644 .38545 m .31136 .3533 L .29049 .3674 L p F P
0 g
s
0 0 .479 r
.83951 .53088 m .82915 .57136 L .83538 .59885 L p F P
0 g
s
.022 .077 .581 r
.82915 .57136 m .83951 .53088 L .8294 .50466 L p F P
0 g
s
.063 .344 .82 r
.73785 .35074 m .75372 .38275 L .77558 .39943 L p F P
0 g
s
.201 .446 .87 r
.75372 .38275 m .73785 .35074 L .71513 .33983 L p F P
0 g
s
.888 .459 .125 r
.26275 .76908 m .29637 .79691 L .28719 .77466 L p F P
0 g
s
.888 .459 .125 r
.28719 .77466 m .25201 .74524 L .26275 .76908 L p F P
0 g
s
.522 .839 .999 r
.52401 .26865 m .48898 .27155 L .49619 .28047 L p F P
0 g
s
.522 .839 .999 r
.49619 .28047 m .52431 .27816 L .52401 .26865 L p F P
0 g
s
.961 .634 .252 r
.21967 .68501 m .24463 .72003 L .24059 .69376 L p F P
0 g
s
.961 .634 .252 r
.24059 .69376 m .21517 .65762 L .21967 .68501 L p F P
0 g
s
.435 .752 .994 r
.5924 .27878 m .55912 .27111 L .55249 .28012 L p F P
0 g
s
.469 .796 .999 r
.52431 .27816 m .55249 .28012 L .55912 .27111 L p F P
0 g
s
.637 .115 0 r
.41414 .88247 m .45781 .89188 L .45156 .88078 L p F P
0 g
s
.637 .115 0 r
.45156 .88078 m .40377 .87041 L .41414 .88247 L p F P
0 g
s
.433 0 .033 r
.55086 .89634 m .59685 .89128 L .60347 .88012 L p F P
0 g
s
.31 0 0 r
.65094 .86933 m .60347 .88012 L .59685 .89128 L p F P
0 g
s
.469 .796 .999 r
.55912 .27111 m .52401 .26865 L .52431 .27816 L p F P
0 g
s
0 0 .109 r
.80135 .74262 m .76705 .77241 L .75771 .79478 L p F P
0 g
s
.093 0 .255 r
.76705 .77241 m .80135 .74262 L .80883 .71729 L p F P
0 g
s
0 0 .236 r
.83727 .65447 m .81293 .69093 L .80883 .71729 L p F P
0 g
s
0 0 .37 r
.81293 .69093 m .83727 .65447 L .83813 .62666 L p F P
0 g
s
.952 .938 .608 r
.22496 .46694 m .22183 .50802 L .23522 .48307 L p F P
0 g
s
.952 .938 .608 r
.23522 .48307 m .23851 .44328 L .22496 .46694 L p F P
0 g
s
.611 .925 .971 r
.44269 .27568 m .40796 .29088 L .42665 .29239 L p F P
0 g
s
.611 .925 .971 r
.42665 .29239 m .45594 .27963 L .44269 .27568 L p F P
0 g
s
.768 .994 .873 r
.33734 .32363 m .31136 .3533 L .33425 .34213 L p F P
0 g
s
.768 .994 .873 r
.33425 .34213 m .35774 .31553 L .33734 .32363 L p F P
0 g
s
.31 .627 .961 r
.6693 .30891 m .64033 .28944 L .62207 .29118 L p F P
0 g
s
.285 .664 .971 r
.5924 .27878 m .62207 .29118 L .64033 .28944 L p F P
0 g
s
0 .04 .6 r
.81151 .43999 m .81599 .47981 L .8294 .50466 L p F P
0 g
s
0 .182 .698 r
.81599 .47981 m .81151 .43999 L .79494 .41856 L p F P
0 g
s
.977 .78 .362 r
.20223 .58973 m .21434 .62987 L .21708 .60209 L p F P
0 g
s
.977 .78 .362 r
.21708 .60209 m .20515 .56163 L .20223 .58973 L p F P
0 g
s
.067 .43 .871 r
.69084 .31348 m .71513 .33983 L .73785 .35074 L p F P
0 g
s
.229 .531 .921 r
.71513 .33983 m .69084 .31348 L .6693 .30891 L p F P
0 g
s
.861 .992 .741 r
.27194 .38436 m .25512 .42169 L .27453 .40237 L p F P
0 g
s
.861 .992 .741 r
.27453 .40237 m .29049 .3674 L .27194 .38436 L p F P
0 g
s
.673 .967 .925 r
.39016 .29277 m .35774 .31553 L .37958 .31069 L p F P
0 g
s
.673 .967 .925 r
.37958 .31069 m .40796 .29088 L .39016 .29277 L p F P
0 g
s
.755 .239 0 r
.32331 .83517 m .36042 .85507 L .34846 .83879 L p F P
0 g
s
.755 .239 0 r
.34846 .83879 m .30842 .81718 L .32331 .83517 L p F P
0 g
s
0 0 .345 r
.84611 .5582 m .83538 .59885 L .83813 .62666 L p F P
0 g
s
0 0 .479 r
.83538 .59885 m .84611 .5582 L .83951 .53088 L p F P
0 g
s
.147 .545 .924 r
.64033 .28944 m .6693 .30891 L .69084 .31348 L p F P
0 g
s
.253 0 .066 r
.65094 .86933 m .69383 .85359 L .70607 .83719 L p F P
0 g
s
.029 0 0 r
.74546 .81519 m .70607 .83719 L .69383 .85359 L p F P
0 g
s
.149 0 .107 r
.70607 .83719 m .74546 .81519 L .75771 .79478 L p F P
0 g
s
0 .209 .735 r
.75856 .3646 m .77558 .39943 L .79494 .41856 L p F P
0 g
s
.063 .344 .82 r
.77558 .39943 m .75856 .3646 L .73785 .35074 L p F P
0 g
s
.658 .111 0 r
.37464 .86857 m .41414 .88247 L .40377 .87041 L p F P
0 g
s
.658 .111 0 r
.40377 .87041 m .36042 .85507 L .37464 .86857 L p F P
0 g
s
.31 0 0 r
.59685 .89128 m .64022 .88149 L .65094 .86933 L p F P
0 g
s
.134 0 0 r
.69383 .85359 m .65094 .86933 L .64022 .88149 L p F P
0 g
s
.906 .533 .088 r
.22789 .71173 m .25201 .74524 L .24463 .72003 L p F P
0 g
s
.906 .533 .088 r
.24463 .72003 m .21967 .68501 L .22789 .71173 L p F P
0 g
s
.504 .882 .972 r
.48198 .26603 m .44269 .27568 L .45594 .27963 L p F P
0 g
s
.504 .882 .972 r
.45594 .27963 m .48898 .27155 L .48198 .26603 L p F P
0 g
s
.812 .333 0 r
.27682 .7912 m .30842 .81718 L .29637 .79691 L p F P
0 g
s
.812 .333 0 r
.29637 .79691 m .26275 .76908 L .27682 .7912 L p F P
0 g
s
.285 .664 .971 r
.64033 .28944 m .60514 .27466 L .5924 .27878 L p F P
0 g
s
.289 .709 .971 r
.55912 .27111 m .5924 .27878 L .60514 .27466 L p F P
0 g
s
0 0 .067 r
.83273 .68197 m .80883 .71729 L .80135 .74262 L p F P
0 g
s
0 0 .236 r
.80883 .71729 m .83273 .68197 L .83727 .65447 L p F P
0 g
s
.925 .89 .478 r
.21473 .49246 m .21174 .5343 L .22183 .50802 L p F P
0 g
s
.925 .89 .478 r
.22183 .50802 m .22496 .46694 L .21473 .49246 L p F P
0 g
s
.48 0 0 r
.46504 .89969 m .50623 .90383 L .50394 .89654 L p F P
0 g
s
.48 0 0 r
.50394 .89654 m .45781 .89188 L .46504 .89969 L p F P
0 g
s
.413 0 0 r
.55086 .89634 m .50394 .89654 L .50623 .90383 L p F P
0 g
s
.413 0 0 r
.50623 .90383 m .54814 .90365 L .55086 .89634 L p F P
0 g
s
.314 0 0 r
.59685 .89128 m .55086 .89634 L .54814 .90365 L p F P
0 g
s
0 0 0 r
.79048 .7666 m .75771 .79478 L .74546 .81519 L p F P
0 g
s
0 0 .109 r
.75771 .79478 m .79048 .7666 L .80135 .74262 L p F P
0 g
s
0 0 .462 r
.82503 .46355 m .8294 .50466 L .83951 .53088 L p F P
0 g
s
0 .04 .6 r
.8294 .50466 m .82503 .46355 L .81151 .43999 L p F P
0 g
s
.924 .689 .199 r
.20311 .61827 m .21517 .65762 L .21434 .62987 L p F P
0 g
s
.924 .689 .199 r
.21434 .62987 m .20223 .58973 L .20311 .61827 L p F P
0 g
s
.404 .824 .969 r
.52372 .26257 m .48198 .26603 L .48898 .27155 L p F P
0 g
s
.404 .824 .969 r
.48898 .27155 m .52401 .26865 L .52372 .26257 L p F P
0 g
s
.727 .984 .781 r
.31869 .33503 m .29049 .3674 L .31136 .3533 L p F P
0 g
s
.727 .984 .781 r
.31136 .3533 m .33734 .32363 L .31869 .33503 L p F P
0 g
s
.289 .709 .971 r
.60514 .27466 m .56555 .26551 L .55912 .27111 L p F P
0 g
s
.328 .763 .969 r
.52401 .26865 m .55912 .27111 L .56555 .26551 L p F P
0 g
s
.515 0 0 r
.42612 .89134 m .46504 .89969 L .45781 .89188 L p F P
0 g
s
.515 0 0 r
.45781 .89188 m .41414 .88247 L .42612 .89134 L p F P
0 g
s
.314 0 0 r
.54814 .90365 m .58919 .89916 L .59685 .89128 L p F P
0 g
s
.172 0 0 r
.64022 .88149 m .59685 .89128 L .58919 .89916 L p F P
0 g
s
.823 .956 .617 r
.25603 .40407 m .23851 .44328 L .25512 .42169 L p F P
0 g
s
.823 .956 .617 r
.25512 .42169 m .27194 .38436 L .25603 .40407 L p F P
0 g
s
0 0 .176 r
.84902 .58632 m .83813 .62666 L .83727 .65447 L p F P
0 g
s
0 0 .345 r
.83813 .62666 m .84902 .58632 L .84611 .5582 L p F P
0 g
s
.328 .763 .969 r
.56555 .26551 m .52372 .26257 L .52401 .26865 L p F P
0 g
s
0 .285 .773 r
.71096 .32135 m .73785 .35074 L .75856 .3646 L p F P
0 g
s
.067 .43 .871 r
.73785 .35074 m .71096 .32135 L .69084 .31348 L p F P
0 g
s
.524 .917 .907 r
.43003 .27526 m .39016 .29277 L .40796 .29088 L p F P
0 g
s
.524 .917 .907 r
.40796 .29088 m .44269 .27568 L .43003 .27526 L p F P
0 g
s
0 .037 .604 r
.77697 .38137 m .79494 .41856 L .81151 .43999 L p F P
0 g
s
0 .209 .735 r
.79494 .41856 m .77697 .38137 L .75856 .3646 L p F P
0 g
s
.147 .545 .924 r
.69084 .31348 m .65773 .29111 L .64033 .28944 L p F P
0 g
s
.088 .565 .904 r
.60514 .27466 m .64033 .28944 L .65773 .29111 L p F P
0 g
s
.601 .951 .835 r
.37348 .29818 m .33734 .32363 L .35774 .31553 L p F P
0 g
s
.601 .951 .835 r
.35774 .31553 m .39016 .29277 L .37348 .29818 L p F P
0 g
s
.626 .064 0 r
.34094 .85058 m .37464 .86857 L .36042 .85507 L p F P
0 g
s
.626 .064 0 r
.36042 .85507 m .32331 .83517 L .34094 .85058 L p F P
0 g
s
0 .41 .829 r
.65773 .29111 m .69084 .31348 L .71096 .32135 L p F P
0 g
s
.806 .391 0 r
.23983 .73741 m .26275 .76908 L .25201 .74524 L p F P
0 g
s
.806 .391 0 r
.25201 .74524 m .22789 .71173 L .23983 .73741 L p F P
0 g
s
.134 0 0 r
.64022 .88149 m .67929 .86723 L .69383 .85359 L p F P
0 g
s
0 0 0 r
.73033 .83334 m .69383 .85359 L .67929 .86723 L p F P
0 g
s
.029 0 0 r
.69383 .85359 m .73033 .83334 L .74546 .81519 L p F P
0 g
s
.858 .799 .308 r
.20804 .51957 m .20515 .56163 L .21174 .5343 L p F P
0 g
s
.858 .799 .308 r
.21174 .5343 m .21473 .49246 L .20804 .51957 L p F P
0 g
s
0 0 0 r
.82444 .70882 m .80135 .74262 L .79048 .7666 L p F P
0 g
s
0 0 .067 r
.80135 .74262 m .82444 .70882 L .83273 .68197 L p F P
0 g
s
.506 0 0 r
.39101 .87903 m .42612 .89134 L .41414 .88247 L p F P
0 g
s
.506 0 0 r
.41414 .88247 m .37464 .86857 L .39101 .87903 L p F P
0 g
s
.682 .164 0 r
.29416 .81131 m .32331 .83517 L .30842 .81718 L p F P
0 g
s
.682 .164 0 r
.30842 .81718 m .27682 .7912 L .29416 .81131 L p F P
0 g
s
0 0 .284 r
.83523 .489 m .83951 .53088 L .84611 .5582 L p F P
0 g
s
0 0 .462 r
.83951 .53088 m .83523 .489 L .82503 .46355 L p F P
0 g
s
.172 0 0 r
.58919 .89916 m .62784 .89047 L .64022 .88149 L p F P
0 g
s
0 0 0 r
.67929 .86723 m .64022 .88149 L .62784 .89047 L p F P
0 g
s
.825 .555 .004 r
.2079 .64692 m .21967 .68501 L .21517 .65762 L p F P
0 g
s
.825 .555 .004 r
.21517 .65762 m .20311 .61827 L .2079 .64692 L p F P
0 g
s
0 0 0 r
.77625 .78889 m .74546 .81519 L .73033 .83334 L p F P
0 g
s
0 0 0 r
.74546 .81519 m .77625 .78889 L .79048 .7666 L p F P
0 g
s
.359 .83 .873 r
.47529 .26414 m .43003 .27526 L .44269 .27568 L p F P
0 g
s
.359 .83 .873 r
.44269 .27568 m .48198 .26603 L .47529 .26414 L p F P
0 g
s
0 0 0 r
.84812 .61493 m .83727 .65447 L .83273 .68197 L p F P
0 g
s
0 0 .176 r
.83727 .65447 m .84812 .61493 L .84902 .58632 L p F P
0 g
s
.088 .565 .904 r
.65773 .29111 m .61731 .27409 L .60514 .27466 L p F P
0 g
s
.072 .599 .871 r
.56555 .26551 m .60514 .27466 L .61731 .27409 L p F P
0 g
s
.739 .866 .442 r
.24302 .42638 m .22496 .46694 L .23851 .44328 L p F P
0 g
s
.739 .866 .442 r
.23851 .44328 m .25603 .40407 L .24302 .42638 L p F P
0 g
s
.638 .915 .624 r
.30206 .34971 m .27194 .38436 L .29049 .3674 L p F P
0 g
s
.638 .915 .624 r
.29049 .3674 m .31869 .33503 L .30206 .34971 L p F P
0 g
s
.299 0 0 r
.4732 .90398 m .50881 .90755 L .50623 .90383 L p F P
0 g
s
.299 0 0 r
.50623 .90383 m .46504 .89969 L .4732 .90398 L p F P
0 g
s
.237 0 0 r
.54814 .90365 m .50623 .90383 L .50881 .90755 L p F P
0 g
s
.237 0 0 r
.50881 .90755 m .54506 .9074 L .54814 .90365 L p F P
0 g
s
.132 0 0 r
.58919 .89916 m .54814 .90365 L .54506 .9074 L p F P
0 g
s
0 .094 .609 r
.72936 .33254 m .75856 .3646 L .77697 .38137 L p F P
0 g
s
0 .285 .773 r
.75856 .3646 m .72936 .33254 L .71096 .32135 L p F P
0 g
s
0 0 .42 r
.79277 .40093 m .81151 .43999 L .82503 .46355 L p F P
0 g
s
0 .037 .604 r
.81151 .43999 m .79277 .40093 L .77697 .38137 L p F P
0 g
s
.743 .659 .104 r
.20507 .54798 m .20223 .58973 L .20515 .56163 L p F P
0 g
s
.743 .659 .104 r
.20515 .56163 m .20804 .51957 L .20507 .54798 L p F P
0 g
s
.214 .735 .848 r
.52344 .26014 m .47529 .26414 L .48198 .26603 L p F P
0 g
s
.214 .735 .848 r
.48198 .26603 m .52372 .26257 L .52344 .26014 L p F P
0 g
s
.316 0 0 r
.43962 .89679 m .4732 .90398 L .46504 .89969 L p F P
0 g
s
.316 0 0 r
.46504 .89969 m .42612 .89134 L .43962 .89679 L p F P
0 g
s
.072 .599 .871 r
.61731 .27409 m .5717 .26353 L .56555 .26551 L p F P
0 g
s
.114 .655 .847 r
.52372 .26257 m .56555 .26551 L .5717 .26353 L p F P
0 g
s
.651 .211 0 r
.25544 .76172 m .27682 .7912 L .26275 .76908 L p F P
0 g
s
.651 .211 0 r
.26275 .76908 m .23983 .73741 L .25544 .76172 L p F P
0 g
s
.132 0 0 r
.54506 .9074 m .58055 .90352 L .58919 .89916 L p F P
0 g
s
0 0 0 r
.62784 .89047 m .58919 .89916 L .58055 .90352 L p F P
0 g
s
.374 .833 .752 r
.41815 .27855 m .37348 .29818 L .39016 .29277 L p F P
0 g
s
.374 .833 .752 r
.39016 .29277 m .43003 .27526 L .41815 .27855 L p F P
0 g
s
.471 .861 .663 r
.35819 .30719 m .31869 .33503 L .33734 .32363 L p F P
0 g
s
.471 .861 .663 r
.33734 .32363 m .37348 .29818 L .35819 .30719 L p F P
0 g
s
0 .41 .829 r
.71096 .32135 m .67402 .29632 L .65773 .29111 L p F P
0 g
s
0 .395 .744 r
.61731 .27409 m .65773 .29111 L .67402 .29632 L p F P
0 g
s
.114 .655 .847 r
.5717 .26353 m .52344 .26014 L .52372 .26257 L p F P
0 g
s
0 0 .076 r
.8419 .51609 m .84611 .5582 L .84902 .58632 L p F P
0 g
s
0 0 .284 r
.84611 .5582 m .8419 .51609 L .83523 .489 L p F P
0 g
s
0 0 0 r
.81241 .73467 m .79048 .7666 L .77625 .78889 L p F P
0 g
s
0 0 0 r
.79048 .7666 m .81241 .73467 L .82444 .70882 L p F P
0 g
s
0 .216 .65 r
.67402 .29632 m .71096 .32135 L .72936 .33254 L p F P
0 g
s
.428 0 0 r
.36121 .86314 m .39101 .87903 L .37464 .86857 L p F P
0 g
s
.428 0 0 r
.37464 .86857 m .34094 .85058 L .36121 .86314 L p F P
0 g
s
.677 .383 0 r
.21664 .67532 m .22789 .71173 L .21967 .68501 L p F P
0 g
s
.677 .383 0 r
.21967 .68501 m .2079 .64692 L .21664 .67532 L p F P
0 g
s
0 0 0 r
.62784 .89047 m .66255 .87785 L .67929 .86723 L p F P
0 g
s
0 0 0 r
.71241 .84893 m .67929 .86723 L .66255 .87785 L p F P
0 g
s
0 0 0 r
.67929 .86723 m .71241 .84893 L .73033 .83334 L p F P
0 g
s
.491 0 0 r
.31465 .82907 m .34094 .85058 L .32331 .83517 L p F P
0 g
s
.491 0 0 r
.32331 .83517 m .29416 .81131 L .31465 .82907 L p F P
0 g
s
.01 w
.83817 .66234 Mdot
.5 Mabswid
0 0 0 r
.83273 .68197 m .8433 .64369 L .84812 .61493 L p F P
0 g
s
.71 .744 .234 r
.8433 .64369 m .83273 .68197 L .82444 .70882 L p F P
0 g
s
0 0 0 r
.75871 .80919 m .73033 .83334 L .71241 .84893 L p F P
0 g
s
0 0 0 r
.73033 .83334 m .75871 .80919 L .77625 .78889 L p F P
0 g
s
.01 w
.83898 .65997 Mdot
.5 Mabswid
0 0 0 r
.23318 .45108 m .21473 .49246 L .22496 .46694 L p F P
0 g
s
0 0 0 r
.22496 .46694 m .24302 .42638 L .23318 .45108 L p F P
0 g
s
.01 w
.21143 .65867 Mdot
.83976 .6576 Mdot
.5 Mabswid
.279 0 0 r
.40944 .88621 m .43962 .89679 L .42612 .89134 L p F P
0 g
s
.279 0 0 r
.42612 .89134 m .39101 .87903 L .40944 .88621 L p F P
0 g
s
0 0 0 r
.28776 .36759 m .25603 .40407 L .27194 .38436 L p F P
0 g
s
0 0 0 r
.27194 .38436 m .30206 .34971 L .28776 .36759 L p F P
0 g
s
0 0 0 r
.58055 .90352 m .61389 .89604 L .62784 .89047 L p F P
0 g
s
0 0 0 r
.66255 .87785 m .62784 .89047 L .61389 .89604 L p F P
0 g
s
.01 w
.8405 .65526 Mdot
.5 Mabswid
0 0 .42 r
.82503 .46355 m .80568 .42313 L .79277 .40093 L p F P
0 g
s
.724 .363 0 r
.80568 .42313 m .82503 .46355 L .83523 .489 L p F P
0 g
s
.01 w
.21086 .6574 Mdot
.5 Mabswid
0 .094 .609 r
.77697 .38137 m .74575 .34703 L .72936 .33254 L p F P
0 g
s
.606 .121 0 r
.74575 .34703 m .77697 .38137 L .79277 .40093 L p F P
0 g
s
.01 w
.84121 .65294 Mdot
.21033 .65618 Mdot
.5 Mabswid
0 0 .109 r
.20597 .57736 m .20311 .61827 L .20223 .58973 L p F P
0 g
s
0 0 .109 r
.20223 .58973 m .20507 .54798 L .20597 .57736 L p F P
0 g
s
.01 w
.84189 .65064 Mdot
.5 Mabswid
0 0 0 r
.469 .26605 m .41815 .27855 L .43003 .27526 L p F P
0 g
s
0 0 0 r
.43003 .27526 m .47529 .26414 L .469 .26605 L p F P
0 g
s
.01 w
.20984 .655 Mdot
.5 Mabswid
0 .395 .744 r
.67402 .29632 m .62873 .27724 L .61731 .27409 L p F P
0 g
s
.193 0 0 r
.5717 .26353 m .61731 .27409 L .62873 .27724 L p F P
0 g
s
.01 w
.84252 .64836 Mdot
.5 Mabswid
0 0 .532 r
.27462 .78429 m .29416 .81131 L .27682 .7912 L p F P
0 g
s
0 0 .532 r
.27682 .7912 m .25544 .76172 L .27462 .78429 L p F P
0 g
s
0 0 .076 r
.84902 .58632 m .84484 .54453 L .8419 .51609 L p F P
0 g
s
.838 .676 .136 r
.84484 .54453 m .84902 .58632 L .84812 .61493 L p F P
0 g
s
.01 w
.20939 .65386 Mdot
.84312 .64611 Mdot
.5 Mabswid
0 0 0 r
.77625 .78889 m .79668 .75916 L .81241 .73467 L p F P
0 g
s
.667 .897 .552 r
.79668 .75916 m .77625 .78889 L .75871 .80919 L p F P
0 g
s
0 0 .407 r
.2293 .70308 m .23983 .73741 L .22789 .71173 L p F P
0 g
s
0 0 .407 r
.22789 .71173 m .21664 .67532 L .2293 .70308 L p F P
0 g
s
.01 w
.82072 .71698 Mdot
.5 Mabswid
0 .537 .727 r
.48225 .90453 m .51168 .90748 L .50881 .90755 L p F P
0 g
s
0 .537 .727 r
.50881 .90755 m .4732 .90398 L .48225 .90453 L p F P
0 g
s
.007 .583 .711 r
.54506 .9074 m .50881 .90755 L .51168 .90748 L p F P
0 g
s
.007 .583 .711 r
.51168 .90748 m .54166 .90735 L .54506 .9074 L p F P
0 g
s
.102 .657 .73 r
.58055 .90352 m .54506 .9074 L .54166 .90735 L p F P
0 g
s
.01 w
.84367 .64388 Mdot
.209 .65278 Mdot
.5 Mabswid
0 0 0 r
.34453 .31982 m .30206 .34971 L .31869 .33503 L p F P
0 g
s
0 0 0 r
.31869 .33503 m .35819 .30719 L .34453 .31982 L p F P
0 g
s
.01 w
.82063 .71742 Mdot
.84419 .64169 Mdot
.5 Mabswid
0 0 0 r
.40723 .28566 m .35819 .30719 L .37348 .29818 L p F P
0 g
s
0 0 0 r
.37348 .29818 m .41815 .27855 L .40723 .28566 L p F P
0 g
s
.812 .87 .43 r
.83452 .67223 m .82444 .70882 L .81241 .73467 L p F P
0 g
s
.71 .744 .234 r
.82444 .70882 m .83452 .67223 L .8433 .64369 L p F P
0 g
s
.01 w
.20864 .65174 Mdot
.82051 .71788 Mdot
.5 Mabswid
0 .216 .65 r
.72936 .33254 m .68896 .30515 L .67402 .29632 L p F P
0 g
s
.565 .009 0 r
.68896 .30515 m .72936 .33254 L .74575 .34703 L p F P
0 g
s
.01 w
.84467 .63952 Mdot
.5 Mabswid
.426 0 0 r
.62873 .27724 m .67402 .29632 L .68896 .30515 L p F P
0 g
s
0 0 0 r
.22673 .47794 m .20804 .51957 L .21473 .49246 L p F P
0 g
s
0 0 0 r
.21473 .49246 m .23318 .45108 L .22673 .47794 L p F P
0 g
s
.01 w
.82036 .71835 Mdot
.5 Mabswid
0 .518 .773 r
.45455 .89859 m .48225 .90453 L .4732 .90398 L p F P
0 g
s
0 .518 .773 r
.4732 .90398 m .43962 .89679 L .45455 .89859 L p F P
0 g
s
.031 0 0 r
.52317 .26155 m .469 .26605 L .47529 .26414 L p F P
0 g
s
.031 0 0 r
.47529 .26414 m .52344 .26014 L .52317 .26155 L p F P
0 g
s
0 .364 .749 r
.38395 .87259 m .40944 .88621 L .39101 .87903 L p F P
0 g
s
0 .364 .749 r
.39101 .87903 m .36121 .86314 L .38395 .87259 L p F P
0 g
s
.102 .657 .73 r
.54166 .90735 m .57098 .90415 L .58055 .90352 L p F P
0 g
s
.235 .753 .778 r
.61389 .89604 m .58055 .90352 L .57098 .90415 L p F P
0 g
s
.193 0 0 r
.62873 .27724 m .57748 .26537 L .5717 .26353 L p F P
0 g
s
.146 0 0 r
.52344 .26014 m .5717 .26353 L .57748 .26537 L p F P
0 g
s
0 .246 .705 r
.33813 .8442 m .36121 .86314 L .34094 .85058 L p F P
0 g
s
0 .246 .705 r
.34094 .85058 m .31465 .82907 L .33813 .8442 L p F P
0 g
s
.01 w
.20833 .65075 Mdot
.8202 .71884 Mdot
.8451 .63738 Mdot
.5 Mabswid
0 0 0 r
.61389 .89604 m .64373 .88519 L .66255 .87785 L p F P
0 g
s
0 0 0 r
.66255 .87785 m .69183 .86169 L .71241 .84893 L p F P
0 g
s
.443 .87 .759 r
.69183 .86169 m .66255 .87785 L .64373 .88519 L p F P
0 g
s
0 0 0 r
.71241 .84893 m .738 .82716 L .75871 .80919 L p F P
0 g
s
.568 .918 .718 r
.738 .82716 m .71241 .84893 L .69183 .86169 L p F P
0 g
s
.01 w
.82001 .71935 Mdot
.20806 .64981 Mdot
.5 Mabswid
.867 .534 .022 r
.81545 .44776 m .83523 .489 L .8419 .51609 L p F P
0 g
s
.724 .363 0 r
.83523 .489 m .81545 .44776 L .80568 .42313 L p F P
0 g
s
.146 0 0 r
.57748 .26537 m .52317 .26155 L .52344 .26014 L p F P
0 g
s
.01 w
.8455 .63528 Mdot
.5 Mabswid
0 0 0 r
.27605 .38856 m .24302 .42638 L .25603 .40407 L p F P
0 g
s
0 0 0 r
.25603 .40407 m .28776 .36759 L .27605 .38856 L p F P
0 g
s
.01 w
.8198 .71987 Mdot
.5 Mabswid
0 0 .305 r
.21084 .60734 m .2079 .64692 L .20311 .61827 L p F P
0 g
s
0 0 .305 r
.20311 .61827 m .20597 .57736 L .21084 .60734 L p F P
0 g
s
.01 w
.20784 .64892 Mdot
.81958 .7204 Mdot
.84585 .63321 Mdot
.5 Mabswid
.782 .318 0 r
.75986 .36477 m .79277 .40093 L .80568 .42313 L p F P
0 g
s
.606 .121 0 r
.79277 .40093 m .75986 .36477 L .74575 .34703 L p F P
0 g
s
.01 w
.81933 .72094 Mdot
.20766 .64807 Mdot
.84616 .63118 Mdot
.81908 .72149 Mdot
.5 Mabswid
.926 .796 .327 r
.84393 .57397 m .84812 .61493 L .8433 .64369 L p F P
0 g
s
.838 .676 .136 r
.84812 .61493 m .84393 .57397 L .84484 .54453 L p F P
0 g
s
0 .522 .836 r
.42975 .88988 m .45455 .89859 L .43962 .89679 L p F P
0 g
s
0 .522 .836 r
.43962 .89679 m .40944 .88621 L .42975 .88988 L p F P
0 g
s
.01 w
.8188 .72205 Mdot
.5 Mabswid
0 .179 .699 r
.29722 .8048 m .31465 .82907 L .29416 .81131 L p F P
0 g
s
0 .179 .699 r
.29416 .81131 m .27462 .78429 L .29722 .8048 L p F P
0 g
s
.01 w
.84643 .62918 Mdot
.84643 .62918 Mdot
.20752 .64728 Mdot
.5 Mabswid
.235 .753 .778 r
.57098 .90415 m .59847 .89798 L .61389 .89604 L p F P
0 g
s
.393 .852 .842 r
.64373 .88519 m .61389 .89604 L .59847 .89798 L p F P
0 g
s
.01 w
.81852 .72262 Mdot
.5 Mabswid
0 0 .574 r
.24583 .72982 m .25544 .76172 L .23983 .73741 L p F P
0 g
s
0 0 .574 r
.23983 .73741 m .2293 .70308 L .24583 .72982 L p F P
0 g
s
.01 w
.81822 .72319 Mdot
.84665 .62722 Mdot
.5 Mabswid
.738 .971 .712 r
.77736 .78196 m .75871 .80919 L .738 .82716 L p F P
0 g
s
.667 .897 .552 r
.75871 .80919 m .77736 .78196 L .79668 .75916 L p F P
0 g
s
.01 w
.20742 .64654 Mdot
.81792 .72376 Mdot
.8176 .72434 Mdot
.5 Mabswid
.87 .948 .59 r
.8218 .70017 m .81241 .73467 L .79668 .75916 L p F P
0 g
s
.812 .87 .43 r
.81241 .73467 m .8218 .70017 L .83452 .67223 L p F P
0 g
s
.01 w
.84683 .62531 Mdot
.81728 .72492 Mdot
.20736 .64584 Mdot
.5 Mabswid
.079 0 0 r
.46321 .27193 m .40723 .28566 L .41815 .27855 L p F P
0 g
s
.079 0 0 r
.41815 .27855 m .469 .26605 L .46321 .27193 L p F P
0 g
s
.01 w
.81696 .7255 Mdot
.5 Mabswid
0 0 .195 r
.22387 .50664 m .20507 .54798 L .20804 .51957 L p F P
0 g
s
0 0 .195 r
.20804 .51957 m .22673 .47794 L .22387 .50664 L p F P
0 g
s
.01 w
.84696 .62343 Mdot
.5 Mabswid
.426 0 0 r
.68896 .30515 m .63923 .28422 L .62873 .27724 L p F P
0 g
s
.433 0 0 r
.57748 .26537 m .62873 .27724 L .63923 .28422 L p F P
0 g
s
.01 w
.81663 .72607 Mdot
.20735 .6452 Mdot
.5 Mabswid
0 0 0 r
.33275 .33606 m .28776 .36759 L .30206 .34971 L p F P
0 g
s
0 0 0 r
.30206 .34971 m .34453 .31982 L .33275 .33606 L p F P
0 g
s
.01 w
.8163 .72664 Mdot
.81596 .72721 Mdot
.84706 .6216 Mdot
.81563 .72777 Mdot
.20737 .6446 Mdot
.5 Mabswid
.735 .211 0 r
.70231 .31763 m .74575 .34703 L .75986 .36477 L p F P
0 g
s
.565 .009 0 r
.74575 .34703 m .70231 .31763 L .68896 .30515 L p F P
0 g
s
.951 .66 .216 r
.82184 .47459 m .8419 .51609 L .84484 .54453 L p F P
0 g
s
.867 .534 .022 r
.8419 .51609 m .82184 .47459 L .81545 .44776 L p F P
0 g
s
.01 w
.8153 .72832 Mdot
.5 Mabswid
0 .422 .847 r
.36436 .85641 m .38395 .87259 L .36121 .86314 L p F P
0 g
s
0 .422 .847 r
.36121 .86314 m .33813 .8442 L .36436 .85641 L p F P
0 g
s
0 0 .466 r
.2197 .63753 m .21664 .67532 L .2079 .64692 L p F P
0 g
s
0 0 .466 r
.2079 .64692 m .21084 .60734 L .2197 .63753 L p F P
0 g
s
.01 w
.81497 .72887 Mdot
.8471 .61981 Mdot
.5 Mabswid
.031 0 0 r
.39746 .29667 m .34453 .31982 L .35819 .30719 L p F P
0 g
s
.031 0 0 r
.35819 .30719 m .40723 .28566 L .39746 .29667 L p F P
0 g
s
.01 w
.81464 .7294 Mdot
.20744 .64405 Mdot
.81432 .72992 Mdot
.5 Mabswid
.211 .706 .917 r
.49209 .90117 m .5148 .90345 L .51168 .90748 L p F P
0 g
s
.211 .706 .917 r
.51168 .90748 m .48225 .90453 L .49209 .90117 L p F P
0 g
s
.252 .746 .911 r
.54166 .90735 m .51168 .90748 L .5148 .90345 L p F P
0 g
s
0 0 .053 r
.26717 .41245 m .23318 .45108 L .24302 .42638 L p F P
0 g
s
0 0 .053 r
.24302 .42638 m .27605 .38856 L .26717 .41245 L p F P
0 g
s
.252 .746 .911 r
.5148 .90345 m .53795 .90335 L .54166 .90735 L p F P
0 g
s
.322 .796 .918 r
.57098 .90415 m .54166 .90735 L .53795 .90335 L p F P
0 g
s
.443 .87 .759 r
.64373 .88519 m .66876 .87135 L .69183 .86169 L p F P
0 g
s
.642 .967 .853 r
.71428 .84252 m .69183 .86169 L .66876 .87135 L p F P
0 g
s
.568 .918 .718 r
.69183 .86169 m .71428 .84252 L .738 .82716 L p F P
0 g
s
.01 w
.82528 .70564 Mdot
.81401 .73043 Mdot
.82459 .70734 Mdot
.82598 .7039 Mdot
.82391 .70898 Mdot
.82668 .70212 Mdot
.5 Mabswid
.062 .537 .894 r
.40893 .8787 m .42975 .88988 L .40944 .88621 L p F P
0 g
s
.062 .537 .894 r
.40944 .88621 m .38395 .87259 L .40893 .8787 L p F P
0 g
s
.01 w
.82323 .71058 Mdot
.82739 .70029 Mdot
.82256 .71213 Mdot
.82809 .69841 Mdot
.8219 .71362 Mdot
.8288 .69649 Mdot
.82126 .71507 Mdot
.5 Mabswid
.621 .055 0 r
.63923 .28422 m .68896 .30515 L .70231 .31763 L p F P
0 g
s
.01 w
.82951 .69452 Mdot
.82062 .71647 Mdot
.84711 .61806 Mdot
.8137 .73092 Mdot
.82 .71782 Mdot
.83021 .69251 Mdot
.81939 .71912 Mdot
.83092 .69046 Mdot
.8188 .72037 Mdot
.83161 .68837 Mdot
.81823 .72157 Mdot
.81341 .7314 Mdot
.81767 .72272 Mdot
.83231 .68623 Mdot
.20754 .64356 Mdot
.5 Mabswid
.393 .852 .842 r
.59847 .89798 m .62298 .88905 L .64373 .88519 L p F P
0 g
s
.549 .929 .899 r
.66876 .87135 m .64373 .88519 L .62298 .88905 L p F P
0 g
s
.968 .873 .481 r
.83905 .60406 m .8433 .64369 L .83452 .67223 L p F P
0 g
s
.926 .796 .327 r
.8433 .64369 m .83905 .60406 L .84393 .57397 L p F P
0 g
s
.01 w
.81713 .72382 Mdot
.81312 .73186 Mdot
.83299 .68406 Mdot
.8166 .72486 Mdot
.8161 .72586 Mdot
.83367 .68185 Mdot
.81561 .72681 Mdot
.81285 .7323 Mdot
.81515 .7277 Mdot
.83434 .6796 Mdot
.8147 .72855 Mdot
.81258 .73272 Mdot
.5 Mabswid
.889 .47 .073 r
.77141 .38564 m .80568 .42313 L .81545 .44776 L p F P
0 g
s
.782 .318 0 r
.80568 .42313 m .77141 .38564 L .75986 .36477 L p F P
0 g
s
.01 w
.81428 .72935 Mdot
.83499 .67732 Mdot
.84707 .61636 Mdot
.81233 .73312 Mdot
.81388 .7301 Mdot
.8135 .73079 Mdot
.83564 .675 Mdot
.8121 .7335 Mdot
.5 Mabswid
.201 .679 .934 r
.47078 .89658 m .49209 .90117 L .48225 .90453 L p F P
0 g
s
.201 .679 .934 r
.48225 .90453 m .45455 .89859 L .47078 .89658 L p F P
0 g
s
.01 w
.81315 .73145 Mdot
.81282 .73205 Mdot
.81188 .73385 Mdot
.83627 .67264 Mdot
.20768 .64311 Mdot
.81251 .7326 Mdot
.5 Mabswid
.322 .796 .918 r
.53795 .90335 m .56057 .90087 L .57098 .90415 L p F P
0 g
s
.413 .85 .935 r
.59847 .89798 m .57098 .90415 L .56057 .90087 L p F P
0 g
s
.257 0 0 r
.52293 .26699 m .46321 .27193 L .469 .26605 L p F P
0 g
s
.257 0 0 r
.469 .26605 m .52317 .26155 L .52293 .26699 L p F P
0 g
s
.01 w
.81167 .73417 Mdot
.81222 .73311 Mdot
.81196 .73357 Mdot
.83688 .67026 Mdot
.5 Mabswid
0 .162 .701 r
.2661 .75515 m .27462 .78429 L .25544 .76172 L p F P
0 g
s
0 .162 .701 r
.25544 .76172 m .24583 .72982 L .2661 .75515 L p F P
0 g
s
.01 w
.81149 .73447 Mdot
.81173 .73398 Mdot
.81132 .73474 Mdot
.81151 .73435 Mdot
.5 Mabswid
.433 0 0 r
.63923 .28422 m .58279 .27118 L .57748 .26537 L p F P
0 g
s
.373 0 0 r
.52317 .26155 m .57748 .26537 L .58279 .27118 L p F P
0 g
s
0 .341 .818 r
.32302 .8229 m .33813 .8442 L .31465 .82907 L p F P
0 g
s
0 .341 .818 r
.31465 .82907 m .29722 .8048 L .32302 .8229 L p F P
0 g
s
.01 w
.81117 .73499 Mdot
.81133 .73468 Mdot
.83748 .66784 Mdot
.81116 .73496 Mdot
.81103 .7352 Mdot
.81102 .7352 Mdot
.81092 .73538 Mdot
.81091 .73539 Mdot
.81083 .73552 Mdot
.81082 .73554 Mdot
.81076 .73564 Mdot
.81075 .73566 Mdot
.81071 .73572 Mdot
.81071 .73573 Mdot
.81069 .73576 Mdot
.81069 .73576 Mdot
.81068 .73577 Mdot
.84698 .61471 Mdot
.83806 .66539 Mdot
.83862 .66292 Mdot
.20786 .64271 Mdot
.83916 .66042 Mdot
.5 Mabswid
.769 .997 .823 r
.75461 .8027 m .738 .82716 L .71428 .84252 L p F P
0 g
s
.738 .971 .712 r
.738 .82716 m .75461 .8027 L .77736 .78196 L p F P
0 g
s
.889 .984 .71 r
.80521 .72712 m .79668 .75916 L .77736 .78196 L p F P
0 g
s
.87 .948 .59 r
.79668 .75916 m .80521 .72712 L .8218 .70017 L p F P
0 g
s
.01 w
.83967 .65789 Mdot
.84686 .61311 Mdot
.5 Mabswid
.373 0 0 r
.58279 .27118 m .52293 .26699 L .52317 .26155 L p F P
0 g
s
.01 w
.84017 .65534 Mdot
.20808 .64236 Mdot
.84064 .65276 Mdot
.84108 .65017 Mdot
.84668 .61156 Mdot
.5 Mabswid
0 0 .357 r
.22474 .53684 m .20597 .57736 L .20507 .54798 L p F P
0 g
s
0 0 .357 r
.20507 .54798 m .22387 .50664 L .22474 .53684 L p F P
0 g
s
.01 w
.8415 .64755 Mdot
.20832 .64206 Mdot
.5 Mabswid
.22 .662 .953 r
.45176 .88986 m .47078 .89658 L .45455 .89859 L p F P
0 g
s
.22 .662 .953 r
.45455 .89859 m .42975 .88988 L .45176 .88986 L p F P
0 g
s
.01 w
.84188 .64492 Mdot
.5 Mabswid
.413 .85 .935 r
.56057 .90087 m .58173 .8961 L .59847 .89798 L p F P
0 g
s
.512 .897 .954 r
.62298 .88905 m .59847 .89798 L .58173 .8961 L p F P
0 g
s
.01 w
.84224 .64227 Mdot
.84647 .61006 Mdot
.20861 .64181 Mdot
.5 Mabswid
0 .047 .591 r
.23253 .66751 m .2293 .70308 L .21664 .67532 L p F P
0 g
s
0 .047 .591 r
.21664 .67532 m .2197 .63753 L .23253 .66751 L p F P
0 g
s
.01 w
.84257 .63961 Mdot
.5 Mabswid
.99 .743 .372 r
.82467 .50331 m .84484 .54453 L .84393 .57397 L p F P
0 g
s
.951 .66 .216 r
.84484 .54453 m .82467 .50331 L .82184 .47459 L p F P
0 g
s
.01 w
.84286 .63694 Mdot
.84621 .6086 Mdot
.20893 .6416 Mdot
.84312 .63425 Mdot
.5 Mabswid
.057 0 .056 r
.32309 .35582 m .27605 .38856 L .28776 .36759 L p F P
0 g
s
.057 0 .056 r
.28776 .36759 m .33275 .33606 L .32309 .35582 L p F P
0 g
s
.01 w
.84335 .63156 Mdot
.5 Mabswid
.977 .915 .6 r
.83019 .6344 m .83452 .67223 L .8218 .70017 L p F P
0 g
s
.968 .873 .481 r
.83452 .67223 m .83019 .6344 L .83905 .60406 L p F P
0 g
s
.01 w
.84591 .60721 Mdot
.20927 .64144 Mdot
.84354 .62886 Mdot
.5 Mabswid
.161 .552 .929 r
.39308 .86546 m .40893 .8787 L .38395 .87259 L p F P
0 g
s
.161 .552 .929 r
.38395 .87259 m .36436 .85641 L .39308 .86546 L p F P
0 g
s
0 0 .231 r
.26135 .43902 m .22673 .47794 L .23318 .45108 L p F P
0 g
s
0 0 .231 r
.23318 .45108 m .26717 .41245 L .26135 .43902 L p F P
0 g
s
.833 .364 .07 r
.71382 .33375 m .75986 .36477 L .77141 .38564 L p F P
0 g
s
.735 .211 0 r
.75986 .36477 m .71382 .33375 L .70231 .31763 L p F P
0 g
s
.259 0 0 r
.45802 .28188 m .39746 .29667 L .40723 .28566 L p F P
0 g
s
.259 0 0 r
.40723 .28566 m .46321 .27193 L .45802 .28188 L p F P
0 g
s
.01 w
.84369 .62615 Mdot
.5 Mabswid
.549 .929 .899 r
.62298 .88905 m .64341 .87768 L .66876 .87135 L p F P
0 g
s
.675 .966 .93 r
.68779 .85498 m .66876 .87135 L .64341 .87768 L p F P
0 g
s
.642 .967 .853 r
.66876 .87135 m .68779 .85498 L .71428 .84252 L p F P
0 g
s
.01 w
.20965 .64132 Mdot
.5 Mabswid
.621 .055 0 r
.70231 .31763 m .64862 .29511 L .63923 .28422 L p F P
0 g
s
.593 .048 0 r
.58279 .27118 m .63923 .28422 L .64862 .29511 L p F P
0 g
s
.01 w
.84557 .60586 Mdot
.5 Mabswid
.026 .299 .791 r
.28989 .7787 m .29722 .8048 L .27462 .78429 L p F P
0 g
s
.026 .299 .791 r
.27462 .78429 m .2661 .75515 L .28989 .7787 L p F P
0 g
s
.01 w
.8438 .62344 Mdot
.84388 .62073 Mdot
.5 Mabswid
.942 .576 .245 r
.78017 .40946 m .81545 .44776 L .82184 .47459 L p F P
0 g
s
.889 .47 .073 r
.81545 .44776 m .78017 .40946 L .77141 .38564 L p F P
0 g
s
.01 w
.21006 .64125 Mdot
.5 Mabswid
.124 .467 .892 r
.35174 .83829 m .36436 .85641 L .33813 .8442 L p F P
0 g
s
.124 .467 .892 r
.33813 .8442 m .32302 .8229 L .35174 .83829 L p F P
0 g
s
.01 w
.84518 .60457 Mdot
.5 Mabswid
.19 0 .006 r
.38901 .31159 m .33275 .33606 L .34453 .31982 L p F P
0 g
s
.19 0 .006 r
.34453 .31982 m .39746 .29667 L .38901 .31159 L p F P
0 g
s
.01 w
.84392 .61801 Mdot
.5 Mabswid
.261 .65 .965 r
.4359 .88127 m .45176 .88986 L .42975 .88988 L p F P
0 g
s
.261 .65 .965 r
.42975 .88988 m .40893 .8787 L .4359 .88127 L p F P
0 g
s
.884 .99 .795 r
.78489 .75269 m .77736 .78196 L .75461 .8027 L p F P
0 g
s
.889 .984 .71 r
.77736 .78196 m .78489 .75269 L .80521 .72712 L p F P
0 g
s
.512 .897 .954 r
.58173 .8961 m .6005 .88922 L .62298 .88905 L p F P
0 g
s
.606 .928 .966 r
.64341 .87768 m .62298 .88905 L .6005 .88922 L p F P
0 g
s
.01 w
.2105 .64123 Mdot
.84391 .6153 Mdot
.5 Mabswid
.772 .989 .894 r
.72865 .82106 m .71428 .84252 L .68779 .85498 L p F P
0 g
s
.769 .997 .823 r
.71428 .84252 m .72865 .82106 L .75461 .8027 L p F P
0 g
s
.735 .228 .016 r
.64862 .29511 m .70231 .31763 L .71382 .33375 L p F P
0 g
s
.01 w
.84476 .60333 Mdot
.84387 .6126 Mdot
.21097 .64125 Mdot
.5 Mabswid
.004 0 .482 r
.22943 .56817 m .21084 .60734 L .20597 .57736 L p F P
0 g
s
.004 0 .482 r
.20597 .57736 m .22474 .53684 L .22943 .56817 L p F P
0 g
s
.403 .783 .992 r
.50264 .89376 m .51815 .89533 L .5148 .90345 L p F P
0 g
s
.403 .783 .992 r
.5148 .90345 m .49209 .90117 L .50264 .89376 L p F P
0 g
s
.431 .811 .991 r
.53795 .90335 m .5148 .90345 L .51815 .89533 L p F P
0 g
s
.01 w
.84378 .6099 Mdot
.84429 .60215 Mdot
.5 Mabswid
.431 .811 .991 r
.51815 .89533 m .53397 .89526 L .53795 .90335 L p F P
0 g
s
.473 .839 .992 r
.56057 .90087 m .53795 .90335 L .53397 .89526 L p F P
0 g
s
.01 w
.21146 .64131 Mdot
.5 Mabswid
.034 .179 .684 r
.24923 .69686 m .24583 .72982 L .2293 .70308 L p F P
0 g
s
.034 .179 .684 r
.2293 .70308 m .23253 .66751 L .24923 .69686 L p F P
0 g
s
.01 w
.84364 .60721 Mdot
.84378 .60102 Mdot
.84347 .60453 Mdot
.5 Mabswid
.391 .758 .992 r
.48812 .89061 m .50264 .89376 L .49209 .90117 L p F P
0 g
s
.391 .758 .992 r
.49209 .90117 m .47078 .89658 L .48812 .89061 L p F P
0 g
s
.999 .795 .491 r
.82379 .53359 m .84393 .57397 L .83905 .60406 L p F P
0 g
s
.99 .743 .372 r
.84393 .57397 m .82379 .53359 L .82467 .50331 L p F P
0 g
s
.01 w
.21197 .64141 Mdot
.5 Mabswid
.473 .839 .992 r
.53397 .89526 m .54941 .89356 L .56057 .90087 L p F P
0 g
s
.524 .865 .993 r
.58173 .8961 m .56057 .90087 L .54941 .89356 L p F P
0 g
s
.414 0 0 r
.52271 .27655 m .45802 .28188 L .46321 .27193 L p F P
0 g
s
.414 0 0 r
.46321 .27193 m .52293 .26699 L .52271 .27655 L p F P
0 g
s
.01 w
.84324 .60186 Mdot
.5 Mabswid
.593 .048 0 r
.64862 .29511 m .58756 .28107 L .58279 .27118 L p F P
0 g
s
.522 0 0 r
.52293 .26699 m .58279 .27118 L .58756 .28107 L p F P
0 g
s
.967 .933 .688 r
.81736 .66457 m .8218 .70017 L .80521 .72712 L p F P
0 g
s
.977 .915 .6 r
.8218 .70017 m .81736 .66457 L .83019 .6344 L p F P
0 g
s
.01 w
.84324 .59995 Mdot
.21251 .64156 Mdot
.84298 .59921 Mdot
.21307 .64174 Mdot
.84265 .59894 Mdot
.84266 .59657 Mdot
.5 Mabswid
.155 .409 .852 r
.31694 .80009 m .32302 .8229 L .29722 .8048 L p F P
0 g
s
.155 .409 .852 r
.29722 .8048 m .28989 .7787 L .31694 .80009 L p F P
0 g
s
.522 0 0 r
.58756 .28107 m .52271 .27655 L .52293 .26699 L p F P
0 g
s
.394 .736 .992 r
.47523 .88602 m .48812 .89061 L .47078 .89658 L p F P
0 g
s
.394 .736 .992 r
.47078 .89658 m .45176 .88986 L .47523 .88602 L p F P
0 g
s
.01 w
.21366 .64197 Mdot
.5 Mabswid
.106 0 .367 r
.25876 .46798 m .22387 .50664 L .22673 .47794 L p F P
0 g
s
.106 0 .367 r
.22673 .47794 m .26135 .43902 L .25876 .46798 L p F P
0 g
s
.01 w
.8423 .59395 Mdot
.5 Mabswid
.177 0 .224 r
.31575 .37896 m .26717 .41245 L .27605 .38856 L p F P
0 g
s
.177 0 .224 r
.27605 .38856 m .32309 .35582 L .31575 .37896 L p F P
0 g
s
.01 w
.84203 .59798 Mdot
.5 Mabswid
.524 .865 .993 r
.54941 .89356 m .56382 .89029 L .58173 .8961 L p F P
0 g
s
.579 .885 .991 r
.6005 .88922 m .58173 .8961 L .56382 .89029 L p F P
0 g
s
.315 .642 .967 r
.42395 .87114 m .4359 .88127 L .40893 .8787 L p F P
0 g
s
.315 .642 .967 r
.40893 .8787 m .39308 .86546 L .42395 .87114 L p F P
0 g
s
.863 .979 .853 r
.76104 .7765 m .75461 .8027 L .72865 .82106 L p F P
0 g
s
.884 .99 .795 r
.75461 .8027 m .76104 .7765 L .78489 .75269 L p F P
0 g
s
.01 w
.84189 .59135 Mdot
.21426 .64223 Mdot
.5 Mabswid
.606 .928 .966 r
.6005 .88922 m .61605 .88049 L .64341 .87768 L p F P
0 g
s
.681 .936 .966 r
.65879 .8643 m .64341 .87768 L .61605 .88049 L p F P
0 g
s
.675 .966 .93 r
.64341 .87768 m .65879 .8643 L .68779 .85498 L p F P
0 g
s
.262 .563 .935 r
.38304 .85071 m .39308 .86546 L .36436 .85641 L p F P
0 g
s
.262 .563 .935 r
.36436 .85641 m .35174 .83829 L .38304 .85071 L p F P
0 g
s
.01 w
.84137 .59708 Mdot
.5 Mabswid
.88 .47 .235 r
.72326 .35341 m .77141 .38564 L .78017 .40946 L p F P
0 g
s
.833 .364 .07 r
.77141 .38564 m .72326 .35341 L .71382 .33375 L p F P
0 g
s
.962 .647 .376 r
.7859 .43601 m .82184 .47459 L .82467 .50331 L p F P
0 g
s
.942 .576 .245 r
.82184 .47459 m .7859 .43601 L .78017 .40946 L p F P
0 g
s
.01 w
.84144 .58877 Mdot
.21488 .64252 Mdot
.5 Mabswid
.757 .962 .934 r
.69977 .83673 m .68779 .85498 L .65879 .8643 L p F P
0 g
s
.772 .989 .894 r
.68779 .85498 m .69977 .83673 L .72865 .82106 L p F P
0 g
s
.01 w
.84093 .58621 Mdot
.84068 .59623 Mdot
.5 Mabswid
.107 .109 .577 r
.23795 .60018 m .2197 .63753 L .21084 .60734 L p F P
0 g
s
.107 .109 .577 r
.21084 .60734 m .22943 .56817 L .23795 .60018 L p F P
0 g
s
.01 w
.21551 .64286 Mdot
.5 Mabswid
.141 .287 .753 r
.26965 .72514 m .2661 .75515 L .24583 .72982 L p F P
0 g
s
.141 .287 .753 r
.24583 .72982 m .24923 .69686 L .26965 .72514 L p F P
0 g
s
.01 w
.84038 .58368 Mdot
.21616 .64322 Mdot
.5 Mabswid
.381 0 .098 r
.45354 .29594 m .38901 .31159 L .39746 .29667 L p F P
0 g
s
.381 0 .098 r
.39746 .29667 m .45802 .28188 L .45354 .29594 L p F P
0 g
s
.01 w
.83995 .59545 Mdot
.83978 .58118 Mdot
.5 Mabswid
.409 .717 .987 r
.46455 .88016 m .47523 .88602 L .45176 .88986 L p F P
0 g
s
.409 .717 .987 r
.45176 .88986 m .4359 .88127 L .46455 .88016 L p F P
0 g
s
.735 .228 .016 r
.71382 .33375 m .65673 .30994 L .64862 .29511 L p F P
0 g
s
.683 .203 .103 r
.58756 .28107 m .64862 .29511 L .65673 .30994 L p F P
0 g
s
.991 .827 .582 r
.81912 .56502 m .83905 .60406 L .83019 .6344 L p F P
0 g
s
.999 .795 .491 r
.83905 .60406 m .81912 .56502 L .82379 .53359 L p F P
0 g
s
.01 w
.21683 .64362 Mdot
.5 Mabswid
.301 0 .182 r
.38208 .33037 m .32309 .35582 L .33275 .33606 L p F P
0 g
s
.301 0 .182 r
.33275 .33606 m .38901 .31159 L .38208 .33037 L p F P
0 g
s
.945 .937 .755 r
.80067 .69414 m .80521 .72712 L .78489 .75269 L p F P
0 g
s
.967 .933 .688 r
.80521 .72712 m .80067 .69414 L .81736 .66457 L p F P
0 g
s
.579 .885 .991 r
.56382 .89029 m .57655 .88558 L .6005 .88922 L p F P
0 g
s
.63 .895 .986 r
.61605 .88049 m .6005 .88922 L .57655 .88558 L p F P
0 g
s
.01 w
.83919 .59472 Mdot
.83913 .57871 Mdot
.2175 .64405 Mdot
.5 Mabswid
.795 .35 .19 r
.65673 .30994 m .71382 .33375 L .72326 .35341 L p F P
0 g
s
.01 w
.83839 .59405 Mdot
.83843 .57627 Mdot
.21819 .64451 Mdot
.5 Mabswid
.262 .498 .894 r
.34692 .81897 m .35174 .83829 L .32302 .8229 L p F P
0 g
s
.262 .498 .894 r
.32302 .8229 m .31694 .80009 L .34692 .81897 L p F P
0 g
s
.01 w
.21889 .645 Mdot
.83768 .57387 Mdot
.83757 .59344 Mdot
.5 Mabswid
.834 .958 .893 r
.73393 .79817 m .72865 .82106 L .69977 .83673 L p F P
0 g
s
.863 .979 .853 r
.72865 .82106 m .73393 .79817 L .76104 .7765 L p F P
0 g
s
.01 w
.21959 .64551 Mdot
.83688 .5715 Mdot
.83671 .59288 Mdot
.5 Mabswid
.195 .068 .47 r
.25955 .49896 m .22474 .53684 L .22387 .50664 L p F P
0 g
s
.195 .068 .47 r
.22387 .50664 m .25876 .46798 L .25955 .49896 L p F P
0 g
s
.01 w
.2203 .64605 Mdot
.5 Mabswid
.525 .799 .996 r
.51379 .88224 m .52169 .88304 L .51815 .89533 L p F P
0 g
s
.525 .799 .996 r
.51815 .89533 m .50264 .89376 L .51379 .88224 L p F P
0 g
s
.54 .814 .997 r
.53397 .89526 m .51815 .89533 L .52169 .88304 L p F P
0 g
s
.54 .814 .997 r
.52169 .88304 m .52976 .88301 L .53397 .89526 L p F P
0 g
s
.561 .828 .996 r
.54941 .89356 m .53397 .89526 L .52976 .88301 L p F P
0 g
s
.01 w
.83603 .56916 Mdot
.5 Mabswid
.372 .635 .956 r
.41652 .8599 m .42395 .87114 L .39308 .86546 L p F P
0 g
s
.372 .635 .956 r
.39308 .86546 m .38304 .85071 L .41652 .8599 L p F P
0 g
s
.01 w
.22102 .64662 Mdot
.5 Mabswid
.229 .377 .805 r
.29354 .75191 m .28989 .7787 L .2661 .75515 L p F P
0 g
s
.229 .377 .805 r
.2661 .75515 m .26965 .72514 L .29354 .75191 L p F P
0 g
s
.01 w
.83582 .59238 Mdot
.5 Mabswid
.516 .784 .993 r
.5064 .88062 m .51379 .88224 L .50264 .89376 L p F P
0 g
s
.516 .784 .993 r
.50264 .89376 m .48812 .89061 L .5064 .88062 L p F P
0 g
s
.191 .21 .65 r
.25028 .63243 m .23253 .66751 L .2197 .63753 L p F P
0 g
s
.191 .21 .65 r
.2197 .63753 m .23795 .60018 L .25028 .63243 L p F P
0 g
s
.561 .828 .996 r
.52976 .88301 m .53764 .88213 L .54941 .89356 L p F P
0 g
s
.585 .839 .993 r
.56382 .89029 m .54941 .89356 L .53764 .88213 L p F P
0 g
s
.433 .702 .978 r
.45658 .87329 m .46455 .88016 L .4359 .88127 L p F P
0 g
s
.433 .702 .978 r
.4359 .88127 m .42395 .87114 L .45658 .87329 L p F P
0 g
s
.01 w
.83514 .56687 Mdot
.5 Mabswid
.681 .936 .966 r
.61605 .88049 m .62764 .87025 L .65879 .8643 L p F P
0 g
s
.734 .925 .955 r
.6683 .84944 m .65879 .8643 L .62764 .87025 L p F P
0 g
s
.757 .962 .934 r
.65879 .8643 m .6683 .84944 L .69977 .83673 L p F P
0 g
s
.266 .025 .349 r
.31094 .40525 m .26135 .43902 L .26717 .41245 L p F P
0 g
s
.266 .025 .349 r
.26717 .41245 m .31575 .37896 L .31094 .40525 L p F P
0 g
s
.01 w
.22174 .6472 Mdot
.5 Mabswid
.963 .694 .476 r
.78844 .46498 m .82467 .50331 L .82379 .53359 L p F P
0 g
s
.962 .647 .376 r
.82467 .50331 m .78844 .46498 L .7859 .43601 L p F P
0 g
s
.63 .895 .986 r
.57655 .88558 m .58701 .87963 L .61605 .88049 L p F P
0 g
s
.673 .895 .977 r
.62764 .87025 m .61605 .88049 L .58701 .87963 L p F P
0 g
s
.511 .071 .139 r
.52251 .29029 m .45354 .29594 L .45802 .28188 L p F P
0 g
s
.511 .071 .139 r
.45802 .28188 m .52271 .27655 L .52251 .29029 L p F P
0 g
s
.01 w
.83491 .59194 Mdot
.22246 .64781 Mdot
.5 Mabswid
.683 .203 .103 r
.65673 .30994 m .59167 .29508 L .58756 .28107 L p F P
0 g
s
.608 .15 .14 r
.52271 .27655 m .58756 .28107 L .59167 .29508 L p F P
0 g
s
.01 w
.83419 .56462 Mdot
.5 Mabswid
.916 .932 .805 r
.78028 .72267 m .78489 .75269 L .76104 .7765 L p F P
0 g
s
.945 .937 .755 r
.78489 .75269 m .78028 .72267 L .80067 .69414 L p F P
0 g
s
.01 w
.22318 .64843 Mdot
.5 Mabswid
.9 .542 .356 r
.73043 .3765 m .78017 .40946 L .7859 .43601 L p F P
0 g
s
.88 .47 .235 r
.78017 .40946 m .73043 .3765 L .72326 .35341 L p F P
0 g
s
.974 .845 .653 r
.81062 .59718 m .83019 .6344 L .81736 .66457 L p F P
0 g
s
.991 .827 .582 r
.83019 .6344 m .81062 .59718 L .81912 .56502 L p F P
0 g
s
.01 w
.83397 .59155 Mdot
.5 Mabswid
.513 .768 .989 r
.49988 .87826 m .5064 .88062 L .48812 .89061 L p F P
0 g
s
.513 .768 .989 r
.48812 .89061 m .47523 .88602 L .49988 .87826 L p F P
0 g
s
.01 w
.8332 .56241 Mdot
.5 Mabswid
.585 .839 .993 r
.53764 .88213 m .54496 .88045 L .56382 .89029 L p F P
0 g
s
.61 .847 .988 r
.57655 .88558 m .56382 .89029 L .54496 .88045 L p F P
0 g
s
.01 w
.22391 .64908 Mdot
.22463 .64974 Mdot
.5 Mabswid
.351 .57 .921 r
.37945 .83505 m .38304 .85071 L .35174 .83829 L p F P
0 g
s
.351 .57 .921 r
.35174 .83829 m .34692 .81897 L .37945 .83505 L p F P
0 g
s
.608 .15 .14 r
.59167 .29508 m .52251 .29029 L .52271 .27655 L p F P
0 g
s
.01 w
.83216 .56024 Mdot
.83301 .59122 Mdot
.22534 .65041 Mdot
.5 Mabswid
.8 .931 .919 r
.70389 .81735 m .69977 .83673 L .6683 .84944 L p F P
0 g
s
.834 .958 .893 r
.69977 .83673 m .70389 .81735 L .73393 .79817 L p F P
0 g
s
.01 w
.83107 .55812 Mdot
.22605 .65109 Mdot
.83202 .59094 Mdot
.22676 .65179 Mdot
.5 Mabswid
.516 .755 .983 r
.49451 .87527 m .49988 .87826 L .47523 .88602 L p F P
0 g
s
.516 .755 .983 r
.47523 .88602 m .46455 .88016 L .49451 .87527 L p F P
0 g
s
.01 w
.82993 .55605 Mdot
.831 .59072 Mdot
.22746 .65249 Mdot
.5 Mabswid
.61 .847 .988 r
.54496 .88045 m .5514 .87804 L .57655 .88558 L p F P
0 g
s
.635 .85 .982 r
.58701 .87963 m .57655 .88558 L .5514 .87804 L p F P
0 g
s
.305 .453 .845 r
.3206 .77677 m .31694 .80009 L .28989 .7787 L p F P
0 g
s
.305 .453 .845 r
.28989 .7787 m .29354 .75191 L .3206 .77677 L p F P
0 g
s
.01 w
.22815 .6532 Mdot
.5 Mabswid
.379 .07 .311 r
.3768 .35289 m .31575 .37896 L .32309 .35582 L p F P
0 g
s
.379 .07 .311 r
.32309 .35582 m .38208 .33037 L .3768 .35289 L p F P
0 g
s
.459 .088 .247 r
.44984 .31408 m .38208 .33037 L .38901 .31159 L p F P
0 g
s
.459 .088 .247 r
.38901 .31159 m .45354 .29594 L .44984 .31408 L p F P
0 g
s
.01 w
.82874 .55403 Mdot
.22883 .65391 Mdot
.82997 .59056 Mdot
.5 Mabswid
.26 .294 .708 r
.2663 .66443 m .24923 .69686 L .23253 .66751 L p F P
0 g
s
.26 .294 .708 r
.23253 .66751 m .25028 .63243 L .2663 .66443 L p F P
0 g
s
.264 .164 .549 r
.26378 .53157 m .22943 .56817 L .22474 .53684 L p F P
0 g
s
.264 .164 .549 r
.22474 .53684 m .25955 .49896 L .26378 .53157 L p F P
0 g
s
.462 .689 .965 r
.45174 .86569 m .45658 .87329 L .42395 .87114 L p F P
0 g
s
.462 .689 .965 r
.42395 .87114 m .41652 .8599 L .45174 .86569 L p F P
0 g
s
.01 w
.2295 .65463 Mdot
.5 Mabswid
.884 .921 .843 r
.75642 .74971 m .76104 .7765 L .73393 .79817 L p F P
0 g
s
.916 .932 .805 r
.76104 .7765 m .75642 .74971 L .78028 .72267 L p F P
0 g
s
.795 .35 .19 r
.72326 .35341 m .6634 .32866 L .65673 .30994 L p F P
0 g
s
.731 .311 .25 r
.59167 .29508 m .65673 .30994 L .6634 .32866 L p F P
0 g
s
.823 .434 .316 r
.6634 .32866 m .72326 .35341 L .73043 .3765 L p F P
0 g
s
.01 w
.82751 .55205 Mdot
.82751 .55205 Mdot
.5 Mabswid
.673 .895 .977 r
.58701 .87963 m .59473 .87268 L .62764 .87025 L p F P
0 g
s
.705 .885 .964 r
.63466 .85894 m .62764 .87025 L .59473 .87268 L p F P
0 g
s
.734 .925 .955 r
.62764 .87025 m .63466 .85894 L .6683 .84944 L p F P
0 g
s
.01 w
.23016 .65535 Mdot
.82892 .59044 Mdot
.2308 .65607 Mdot
.5 Mabswid
.952 .855 .708 r
.79836 .62962 m .81736 .66457 L .80067 .69414 L p F P
0 g
s
.974 .845 .653 r
.81736 .66457 m .79836 .62962 L .81062 .59718 L p F P
0 g
s
.01 w
.23143 .65679 Mdot
.82623 .55013 Mdot
.5 Mabswid
.955 .727 .553 r
.78765 .49603 m .82379 .53359 L .81912 .56502 L p F P
0 g
s
.963 .694 .476 r
.82379 .53359 m .78765 .49603 L .78844 .46498 L p F P
0 g
s
.01 w
.82785 .59038 Mdot
.23205 .6575 Mdot
.5 Mabswid
.524 .742 .975 r
.49055 .87178 m .49451 .87527 L .46455 .88016 L p F P
0 g
s
.524 .742 .975 r
.46455 .88016 m .45658 .87329 L .49055 .87178 L p F P
0 g
s
.427 .63 .939 r
.41407 .84804 m .41652 .8599 L .38304 .85071 L p F P
0 g
s
.427 .63 .939 r
.38304 .85071 m .37945 .83505 L .41407 .84804 L p F P
0 g
s
.01 w
.23265 .65821 Mdot
.5 Mabswid
.635 .85 .982 r
.5514 .87804 m .55665 .875 L .58701 .87963 L p F P
0 g
s
.656 .849 .974 r
.59473 .87268 m .58701 .87963 L .55665 .875 L p F P
0 g
s
.01 w
.82491 .54826 Mdot
.23323 .65891 Mdot
.82676 .59037 Mdot
.5 Mabswid
.332 .126 .444 r
.3088 .43442 m .25876 .46798 L .26135 .43902 L p F P
0 g
s
.332 .126 .444 r
.26135 .43902 m .31094 .40525 L .3088 .43442 L p F P
0 g
s
.764 .901 .937 r
.67132 .83374 m .6683 .84944 L .63466 .85894 L p F P
0 g
s
.8 .931 .919 r
.6683 .84944 m .67132 .83374 L .70389 .81735 L p F P
0 g
s
.01 w
.2338 .6596 Mdot
.23434 .66028 Mdot
.82354 .54645 Mdot
.23487 .66095 Mdot
.82566 .59042 Mdot
.23537 .6616 Mdot
.5 Mabswid
.369 .518 .875 r
.35046 .79932 m .34692 .81897 L .31694 .80009 L p F P
0 g
s
.369 .518 .875 r
.31694 .80009 m .3206 .77677 L .35046 .79932 L p F P
0 g
s
.01 w
.23586 .66224 Mdot
.5 Mabswid
.904 .594 .448 r
.73512 .40277 m .7859 .43601 L .78844 .46498 L p F P
0 g
s
.9 .542 .356 r
.7859 .43601 m .73512 .40277 L .73043 .3765 L p F P
0 g
s
.01 w
.23632 .66286 Mdot
.82213 .54469 Mdot
.23676 .66346 Mdot
.82455 .59051 Mdot
.23718 .66403 Mdot
.5 Mabswid
.599 .789 .972 r
.52169 .88304 m .51379 .88224 L .52538 .86658 L closepath p F P
0 g
s
.604 .794 .972 r
.52976 .88301 m .52169 .88304 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23758 .66459 Mdot
.5 Mabswid
.61 .798 .971 r
.53764 .88213 m .52976 .88301 L .52538 .86658 L closepath p F P
0 g
s
.85 .906 .873 r
.72942 .77486 m .73393 .79817 L .70389 .81735 L p F P
0 g
s
.884 .921 .843 r
.73393 .79817 m .72942 .77486 L .75642 .74971 L p F P
0 g
s
.01 w
.23332 .64656 Mdot
.23365 .6481 Mdot
.23299 .64496 Mdot
.23399 .64958 Mdot
.23267 .64331 Mdot
.23434 .65102 Mdot
.23795 .66512 Mdot
.23236 .64161 Mdot
.23468 .6524 Mdot
.23206 .63986 Mdot
.23503 .65372 Mdot
.23538 .65499 Mdot
.23177 .63806 Mdot
.23572 .6562 Mdot
.2315 .63621 Mdot
.23607 .65736 Mdot
.23829 .66563 Mdot
.23124 .63431 Mdot
.2364 .65847 Mdot
.23674 .65951 Mdot
.23101 .63237 Mdot
.23706 .6605 Mdot
.5 Mabswid
.319 .366 .754 r
.28582 .6957 m .26965 .72514 L .24923 .69686 L p F P
0 g
s
.319 .366 .754 r
.24923 .69686 m .2663 .66443 L .28582 .6957 L p F P
0 g
s
.01 w
.23861 .6661 Mdot
.5 Mabswid
.596 .784 .97 r
.51379 .88224 m .5064 .88062 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23079 .63037 Mdot
.23738 .66144 Mdot
.82068 .54299 Mdot
.5 Mabswid
.616 .801 .97 r
.54496 .88045 m .53764 .88213 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23769 .66232 Mdot
.82342 .59065 Mdot
.23059 .62833 Mdot
.23891 .66655 Mdot
.23799 .66315 Mdot
.23827 .66392 Mdot
.23041 .62624 Mdot
.23918 .66697 Mdot
.23854 .66463 Mdot
.2388 .66529 Mdot
.23026 .62411 Mdot
.23943 .66736 Mdot
.23905 .6659 Mdot
.23928 .66645 Mdot
.23965 .66771 Mdot
.23013 .62194 Mdot
.23949 .66695 Mdot
.23985 .66803 Mdot
.23968 .6674 Mdot
.23986 .6678 Mdot
.24002 .66831 Mdot
.23003 .61972 Mdot
.24002 .66814 Mdot
.24017 .66856 Mdot
.24015 .66843 Mdot
.24029 .66876 Mdot
.24027 .66868 Mdot
.24038 .66893 Mdot
.24036 .66887 Mdot
.22995 .61747 Mdot
.24044 .66902 Mdot
.24045 .66905 Mdot
.24049 .66912 Mdot
.2405 .66913 Mdot
.24051 .66917 Mdot
.24052 .66917 Mdot
.24052 .66918 Mdot
.5 Mabswid
.57 .186 .274 r
.52235 .30819 m .44984 .31408 L .45354 .29594 L p F P
0 g
s
.57 .186 .274 r
.45354 .29594 m .52251 .29029 L .52235 .30819 L p F P
0 g
s
.535 .732 .965 r
.4882 .86795 m .49055 .87178 L .45658 .87329 L p F P
0 g
s
.535 .732 .965 r
.45658 .87329 m .45174 .86569 L .4882 .86795 L p F P
0 g
s
.01 w
.22991 .61517 Mdot
.5 Mabswid
.594 .779 .969 r
.5064 .88062 m .49988 .87826 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.82228 .59083 Mdot
.81919 .54135 Mdot
.2299 .61284 Mdot
.5 Mabswid
.623 .803 .968 r
.5514 .87804 m .54496 .88045 L .52538 .86658 L closepath p F P
0 g
s
.731 .311 .25 r
.6634 .32866 m .59506 .31319 L .59167 .29508 L p F P
0 g
s
.657 .257 .275 r
.52251 .29029 m .59167 .29508 L .59506 .31319 L p F P
0 g
s
.656 .849 .974 r
.55665 .875 m .56048 .87148 L .59473 .87268 L p F P
0 g
s
.674 .844 .964 r
.59929 .86505 m .59473 .87268 L .56048 .87148 L p F P
0 g
s
.705 .885 .964 r
.59473 .87268 m .59929 .86505 L .63466 .85894 L p F P
0 g
s
.01 w
.22992 .61047 Mdot
.5 Mabswid
.32 .244 .612 r
.27148 .56534 m .23795 .60018 L .22943 .56817 L p F P
0 g
s
.32 .244 .612 r
.22943 .56817 m .26378 .53157 L .27148 .56534 L p F P
0 g
s
.927 .859 .753 r
.78243 .66184 m .80067 .69414 L .78028 .72267 L p F P
0 g
s
.952 .855 .708 r
.80067 .69414 m .78243 .66184 L .79836 .62962 L p F P
0 g
s
.01 w
.22997 .60807 Mdot
.5 Mabswid
.492 .68 .949 r
.45029 .85772 m .45174 .86569 L .41652 .8599 L p F P
0 g
s
.492 .68 .949 r
.41652 .8599 m .41407 .84804 L .45029 .85772 L p F P
0 g
s
.01 w
.23006 .60563 Mdot
.82113 .59107 Mdot
.23019 .60317 Mdot
.5 Mabswid
.726 .869 .948 r
.63667 .84705 m .63466 .85894 L .59929 .86505 L p F P
0 g
s
.764 .901 .937 r
.63466 .85894 m .63667 .84705 L .67132 .83374 L p F P
0 g
s
.01 w
.81765 .53977 Mdot
.23035 .60067 Mdot
.23056 .59814 Mdot
.5 Mabswid
.594 .774 .966 r
.49988 .87826 m .49451 .87527 L .52538 .86658 L closepath p F P
0 g
s
.63 .803 .966 r
.55665 .875 m .5514 .87804 L .52538 .86658 L closepath p F P
0 g
s
.426 .576 .899 r
.3827 .81919 m .37945 .83505 L .34692 .81897 L p F P
0 g
s
.426 .576 .899 r
.34692 .81897 m .35046 .79932 L .3827 .81919 L p F P
0 g
s
.01 w
.2308 .59559 Mdot
.81998 .59135 Mdot
.23109 .59301 Mdot
.5 Mabswid
.942 .749 .613 r
.78345 .52874 m .81912 .56502 L .81062 .59718 L p F P
0 g
s
.955 .727 .553 r
.81912 .56502 m .78345 .52874 L .78765 .49603 L p F P
0 g
s
.01 w
.81607 .53825 Mdot
.23142 .59041 Mdot
.5 Mabswid
.657 .257 .275 r
.59506 .31319 m .52235 .30819 L .52251 .29029 L p F P
0 g
s
.01 w
.2318 .58778 Mdot
.5 Mabswid
.814 .889 .897 r
.69963 .79771 m .70389 .81735 L .67132 .83374 L p F P
0 g
s
.85 .906 .873 r
.70389 .81735 m .69963 .79771 L .72942 .77486 L p F P
0 g
s
.01 w
.81882 .59167 Mdot
.5 Mabswid
.433 .165 .407 r
.37334 .37896 m .31094 .40525 L .31575 .37896 L p F P
0 g
s
.433 .165 .407 r
.31575 .37896 m .3768 .35289 L .37334 .37896 L p F P
0 g
s
.01 w
.23222 .58514 Mdot
.81446 .53679 Mdot
.23269 .58248 Mdot
.5 Mabswid
.595 .77 .963 r
.49451 .87527 m .49055 .87178 L .52538 .86658 L closepath p F P
0 g
s
.636 .803 .963 r
.56048 .87148 m .55665 .875 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.81765 .59203 Mdot
.2332 .5798 Mdot
.5 Mabswid
.369 .429 .792 r
.30859 .72574 m .29354 .75191 L .26965 .72514 L p F P
0 g
s
.369 .429 .792 r
.26965 .72514 m .28582 .6957 L .30859 .72574 L p F P
0 g
s
.835 .494 .41 r
.66846 .35114 m .73043 .3765 L .73512 .40277 L p F P
0 g
s
.823 .434 .316 r
.73043 .3765 m .66846 .35114 L .6634 .32866 L p F P
0 g
s
.01 w
.23377 .57711 Mdot
.81281 .53539 Mdot
.5 Mabswid
.51 .186 .354 r
.44704 .3362 m .3768 .35289 L .38208 .33037 L p F P
0 g
s
.51 .186 .354 r
.38208 .33037 m .44984 .31408 L .44704 .3362 L p F P
0 g
s
.01 w
.81649 .59244 Mdot
.23438 .57441 Mdot
.5 Mabswid
.55 .724 .955 r
.48758 .86394 m .4882 .86795 L .45174 .86569 L p F P
0 g
s
.55 .724 .955 r
.45174 .86569 m .45029 .85772 L .48758 .86394 L p F P
0 g
s
.382 .207 .516 r
.30944 .46608 m .25955 .49896 L .25876 .46798 L p F P
0 g
s
.382 .207 .516 r
.25876 .46798 m .3088 .43442 L .30944 .46608 L p F P
0 g
s
.01 w
.23505 .5717 Mdot
.5 Mabswid
.756 .388 .356 r
.59506 .31319 m .6634 .32866 L .66846 .35114 L p F P
0 g
s
.674 .844 .964 r
.56048 .87148 m .56269 .86762 L .59929 .86505 L p F P
0 g
s
.687 .835 .954 r
.60044 .85706 m .59929 .86505 L .56269 .86762 L p F P
0 g
s
.726 .869 .948 r
.59929 .86505 m .60044 .85706 L .63667 .84705 L p F P
0 g
s
.477 .627 .918 r
.41683 .83609 m .41407 .84804 L .37945 .83505 L p F P
0 g
s
.477 .627 .918 r
.37945 .83505 m .3827 .81919 L .41683 .83609 L p F P
0 g
s
.01 w
.81112 .53406 Mdot
.81532 .59288 Mdot
.5 Mabswid
.901 .859 .791 r
.76302 .69335 m .78028 .72267 L .75642 .74971 L p F P
0 g
s
.927 .859 .753 r
.78028 .72267 m .76302 .69335 L .78243 .66184 L p F P
0 g
s
.01 w
.23577 .56898 Mdot
.5 Mabswid
.597 .766 .96 r
.49055 .87178 m .4882 .86795 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.23654 .56625 Mdot
.5 Mabswid
.642 .801 .96 r
.56269 .86762 m .56048 .87148 L .52538 .86658 L closepath p F P
0 g
s
.777 .869 .916 r
.66748 .8179 m .67132 .83374 L .63667 .84705 L p F P
0 g
s
.814 .889 .897 r
.67132 .83374 m .66748 .8179 L .69963 .79771 L p F P
0 g
s
.01 w
.81415 .59337 Mdot
.5 Mabswid
.901 .631 .519 r
.7372 .43195 m .78844 .46498 L .78765 .49603 L p F P
0 g
s
.904 .594 .448 r
.78844 .46498 m .7372 .43195 L .73512 .40277 L p F P
0 g
s
.01 w
.23737 .56352 Mdot
.8094 .53279 Mdot
.23825 .56079 Mdot
.5 Mabswid
.366 .311 .663 r
.28259 .59976 m .25028 .63243 L .23795 .60018 L p F P
0 g
s
.366 .311 .663 r
.23795 .60018 m .27148 .56534 L .28259 .59976 L p F P
0 g
s
.01 w
.81298 .59389 Mdot
.23919 .55807 Mdot
.80765 .53159 Mdot
.24018 .55534 Mdot
.81182 .59444 Mdot
.5 Mabswid
.523 .674 .933 r
.45235 .84974 m .45029 .85772 L .41407 .84804 L p F P
0 g
s
.523 .674 .933 r
.41407 .84804 m .41683 .83609 L .45235 .84974 L p F P
0 g
s
.601 .763 .956 r
.4882 .86795 m .48758 .86394 L .52538 .86658 L closepath p F P
0 g
s
.412 .484 .824 r
.33428 .75408 m .3206 .77677 L .29354 .75191 L p F P
0 g
s
.412 .484 .824 r
.29354 .75191 m .30859 .72574 L .33428 .75408 L p F P
0 g
s
.01 w
.24123 .55262 Mdot
.5 Mabswid
.646 .799 .956 r
.56316 .86361 m .56269 .86762 L .52538 .86658 L closepath p F P
0 g
s
.687 .835 .954 r
.56269 .86762 m .56316 .86361 L .60044 .85706 L p F P
0 g
s
.01 w
.80586 .53045 Mdot
.5 Mabswid
.926 .766 .663 r
.77583 .56264 m .81062 .59718 L .79836 .62962 L p F P
0 g
s
.942 .749 .613 r
.81062 .59718 m .77583 .56264 L .78345 .52874 L p F P
0 g
s
.01 w
.81066 .59503 Mdot
.5 Mabswid
.737 .847 .932 r
.63346 .83511 m .63667 .84705 L .60044 .85706 L p F P
0 g
s
.777 .869 .916 r
.63667 .84705 m .63346 .83511 L .66748 .8179 L p F P
0 g
s
.01 w
.24234 .5499 Mdot
.80951 .59565 Mdot
.2435 .5472 Mdot
.5 Mabswid
.873 .856 .822 r
.7404 .72365 m .75642 .74971 L .72942 .77486 L p F P
0 g
s
.901 .859 .791 r
.75642 .74971 m .7404 .72365 L .76302 .69335 L p F P
0 g
s
.01 w
.80404 .52938 Mdot
.5 Mabswid
.565 .718 .944 r
.48872 .85995 m .48758 .86394 L .45029 .85772 L p F P
0 g
s
.565 .718 .944 r
.45029 .85772 m .45235 .84974 L .48872 .85995 L p F P
0 g
s
.01 w
.24472 .54451 Mdot
.80836 .5963 Mdot
.5 Mabswid
.695 .823 .944 r
.59808 .84909 m .60044 .85706 L .56316 .86361 L p F P
0 g
s
.737 .847 .932 r
.60044 .85706 m .59808 .84909 L .63346 .83511 L p F P
0 g
s
.01 w
.246 .54183 Mdot
.8022 .52837 Mdot
.5 Mabswid
.652 .787 .946 r
.55424 .85251 m .55885 .85586 L .52538 .86658 L closepath p F P
0 g
s
.611 .758 .949 r
.48872 .85995 m .4916 .85616 L .52538 .86658 L closepath p F P
0 g
s
.606 .76 .953 r
.48758 .86394 m .48872 .85995 L .52538 .86658 L closepath p F P
0 g
s
.65 .795 .952 r
.56187 .85963 m .56316 .86361 L .52538 .86658 L closepath p F P
0 g
s
.652 .791 .949 r
.55885 .85586 m .56187 .85963 L .52538 .86658 L closepath p F P
0 g
s
.652 .782 .943 r
.54824 .84971 m .55424 .85251 L .52538 .86658 L closepath p F P
0 g
s
.65 .777 .941 r
.54114 .84762 m .54824 .84971 L .52538 .86658 L closepath p F P
0 g
s
.647 .772 .94 r
.53328 .84634 m .54114 .84762 L .52538 .86658 L closepath p F P
0 g
s
.644 .768 .939 r
.52503 .84593 m .53328 .84634 L .52538 .86658 L closepath p F P
0 g
s
.639 .765 .939 r
.5168 .84641 m .52503 .84593 L .52538 .86658 L closepath p F P
0 g
s
.634 .762 .94 r
.50899 .84776 m .5168 .84641 L .52538 .86658 L closepath p F P
0 g
s
.628 .759 .941 r
.50197 .84992 m .50899 .84776 L .52538 .86658 L closepath p F P
0 g
s
.622 .758 .943 r
.49608 .85276 m .50197 .84992 L .52538 .86658 L closepath p F P
0 g
s
.617 .758 .946 r
.4916 .85616 m .49608 .85276 L .52538 .86658 L closepath p F P
0 g
s
.01 w
.80723 .59697 Mdot
.5 Mabswid
.695 .823 .944 r
.56316 .86361 m .56187 .85963 L .59808 .84909 L p F P
0 g
s
.01 w
.24734 .53917 Mdot
.5 Mabswid
.452 .535 .852 r
.36251 .78027 m .35046 .79932 L .3206 .77677 L p F P
0 g
s
.452 .535 .852 r
.3206 .77677 m .33428 .75408 L .36251 .78027 L p F P
0 g
s
.01 w
.8061 .59767 Mdot
.80032 .52743 Mdot
.24873 .53652 Mdot
.5 Mabswid
.607 .269 .372 r
.52223 .33016 m .44704 .3362 L .44984 .31408 L p F P
0 g
s
.607 .269 .372 r
.44984 .31408 m .52235 .30819 L .52223 .33016 L p F P
0 g
s
.01 w
.80499 .5984 Mdot
.5 Mabswid
.756 .388 .356 r
.66846 .35114 m .59763 .33528 L .59506 .31319 L p F P
0 g
s
.686 .334 .373 r
.52235 .30819 m .59506 .31319 L .59763 .33528 L p F P
0 g
s
.01 w
.25019 .5339 Mdot
.5 Mabswid
.473 .24 .479 r
.3718 .40828 m .3088 .43442 L .31094 .40525 L p F P
0 g
s
.473 .24 .479 r
.31094 .40525 m .37334 .37896 L .3718 .40828 L p F P
0 g
s
.404 .368 .705 r
.29699 .63431 m .2663 .66443 L .25028 .63243 L p F P
0 g
s
.404 .368 .705 r
.25028 .63243 m .28259 .59976 L .29699 .63431 L p F P
0 g
s
.843 .851 .85 r
.71488 .75228 m .72942 .77486 L .69963 .79771 L p F P
0 g
s
.873 .856 .822 r
.72942 .77486 m .71488 .75228 L .7404 .72365 L p F P
0 g
s
.421 .274 .574 r
.31294 .49983 m .26378 .53157 L .25955 .49896 L p F P
0 g
s
.421 .274 .574 r
.25955 .49896 m .30944 .46608 L .31294 .49983 L p F P
0 g
s
.01 w
.79842 .52656 Mdot
.80389 .59915 Mdot
.2517 .5313 Mdot
.5 Mabswid
.582 .715 .934 r
.4916 .85616 m .48872 .85995 L .45235 .84974 L p F P
0 g
s
.01 w
.8028 .59992 Mdot
.5 Mabswid
.699 .81 .934 r
.56187 .85963 m .55885 .85586 L .59224 .84152 L p F P
0 g
s
.699 .81 .934 r
.59224 .84152 m .59808 .84909 L .56187 .85963 L p F P
0 g
s
.01 w
.25328 .52873 Mdot
.7965 .52576 Mdot
.5 Mabswid
.839 .539 .482 r
.67178 .37719 m .73512 .40277 L .7372 .43195 L p F P
0 g
s
.835 .494 .41 r
.73512 .40277 m .67178 .37719 L .66846 .35114 L p F P
0 g
s
.487 .583 .876 r
.39285 .80391 m .3827 .81919 L .35046 .79932 L p F P
0 g
s
.487 .583 .876 r
.35046 .79932 m .36251 .78027 L .39285 .80391 L p F P
0 g
s
.01 w
.80173 .60071 Mdot
.5 Mabswid
.908 .778 .705 r
.76485 .59724 m .79836 .62962 L .78243 .66184 L p F P
0 g
s
.926 .766 .663 r
.79836 .62962 m .76485 .59724 L .77583 .56264 L p F P
0 g
s
.894 .659 .576 r
.73655 .46367 m .78765 .49603 L .78345 .52874 L p F P
0 g
s
.901 .631 .519 r
.78765 .49603 m .73655 .46367 L .7372 .43195 L p F P
0 g
s
.01 w
.25491 .52618 Mdot
.5 Mabswid
.686 .334 .373 r
.59763 .33528 m .52223 .33016 L .52235 .30819 L p F P
0 g
s
.01 w
.80068 .60151 Mdot
.79455 .52502 Mdot
.5 Mabswid
.812 .844 .874 r
.68685 .77876 m .69963 .79771 L .66748 .8179 L p F P
0 g
s
.843 .851 .85 r
.69963 .79771 m .68685 .77876 L .71488 .75228 L p F P
0 g
s
.01 w
.2566 .52366 Mdot
.5 Mabswid
.582 .715 .934 r
.45235 .84974 m .4579 .84212 L .4916 .85616 L p F P
0 g
s
.552 .672 .917 r
.4579 .84212 m .45235 .84974 L .41683 .83609 L p F P
0 g
s
.546 .261 .434 r
.44519 .3621 m .37334 .37896 L .3768 .35289 L p F P
0 g
s
.546 .261 .434 r
.3768 .35289 m .44704 .3362 L .44519 .3621 L p F P
0 g
s
.521 .628 .898 r
.42481 .82462 m .41683 .83609 L .3827 .81919 L p F P
0 g
s
.521 .628 .898 r
.3827 .81919 m .39285 .80391 L .42481 .82462 L p F P
0 g
s
.01 w
.79964 .60233 Mdot
.5 Mabswid
.741 .824 .916 r
.59808 .84909 m .59224 .84152 L .62505 .82372 L p F P
0 g
s
.741 .824 .916 r
.62505 .82372 m .63346 .83511 L .59808 .84909 L p F P
0 g
s
.01 w
.25835 .52118 Mdot
.5 Mabswid
.552 .672 .917 r
.41683 .83609 m .42481 .82462 L .4579 .84212 L p F P
0 g
s
.598 .714 .925 r
.49608 .85276 m .4916 .85616 L .4579 .84212 L p F P
0 g
s
.01 w
.79863 .60316 Mdot
.79259 .52435 Mdot
.5 Mabswid
.699 .795 .925 r
.55885 .85586 m .55424 .85251 L .58316 .83472 L p F P
0 g
s
.699 .795 .925 r
.58316 .83472 m .59224 .84152 L .55885 .85586 L p F P
0 g
s
.769 .444 .436 r
.59763 .33528 m .66846 .35114 L .67178 .37719 L p F P
0 g
s
.778 .835 .896 r
.65675 .8027 m .66748 .8179 L .63346 .83511 L p F P
0 g
s
.812 .844 .874 r
.66748 .8179 m .65675 .8027 L .68685 .77876 L p F P
0 g
s
.01 w
.26015 .51872 Mdot
.5 Mabswid
.778 .835 .896 r
.63346 .83511 m .62505 .82372 L .65675 .8027 L p F P
0 g
s
.01 w
.79763 .60401 Mdot
.79666 .60486 Mdot
.7906 .52374 Mdot
.26202 .51631 Mdot
.5 Mabswid
.437 .42 .742 r
.3145 .66843 m .28582 .6957 L .2663 .66443 L p F P
0 g
s
.437 .42 .742 r
.2663 .66443 m .29699 .63431 L .3145 .66843 L p F P
0 g
s
.01 w
.7957 .60572 Mdot
.26394 .51393 Mdot
.79477 .60658 Mdot
.7886 .52321 Mdot
.5 Mabswid
.615 .716 .918 r
.50197 .84992 m .49608 .85276 L .46671 .83525 L p F P
0 g
s
.598 .714 .925 r
.4579 .84212 m .46671 .83525 L .49608 .85276 L p F P
0 g
s
.696 .781 .917 r
.55424 .85251 m .54824 .84971 L .57125 .82905 L p F P
0 g
s
.696 .781 .917 r
.57125 .82905 m .58316 .83472 L .55424 .85251 L p F P
0 g
s
.01 w
.79387 .60745 Mdot
.26591 .51159 Mdot
.79299 .60831 Mdot
.5 Mabswid
.889 .786 .741 r
.75061 .63198 m .78243 .66184 L .76302 .69335 L p F P
0 g
s
.908 .778 .705 r
.78243 .66184 m .75061 .63198 L .76485 .59724 L p F P
0 g
s
.01 w
.78658 .52274 Mdot
.26794 .5093 Mdot
.79214 .60918 Mdot
.79131 .61004 Mdot
.5 Mabswid
.453 .33 .622 r
.31931 .53515 m .27148 .56534 L .26378 .53157 L p F P
0 g
s
.453 .33 .622 r
.26378 .53157 m .31294 .49983 L .31931 .53515 L p F P
0 g
s
.01 w
.27003 .50705 Mdot
.5 Mabswid
.63 .72 .912 r
.50899 .84776 m .50197 .84992 L .47841 .82947 L p F P
0 g
s
.615 .716 .918 r
.46671 .83525 m .47841 .82947 L .50197 .84992 L p F P
0 g
s
.579 .673 .903 r
.46671 .83525 m .4579 .84212 L .42481 .82462 L p F P
0 g
s
.01 w
.79051 .6109 Mdot
.78455 .52233 Mdot
.5 Mabswid
.69 .768 .911 r
.54824 .84971 m .54114 .84762 L .55705 .82478 L p F P
0 g
s
.69 .768 .911 r
.55705 .82478 m .57125 .82905 L .54824 .84971 L p F P
0 g
s
.738 .8 .902 r
.59224 .84152 m .58316 .83472 L .61172 .81344 L p F P
0 g
s
.738 .8 .902 r
.61172 .81344 m .62505 .82372 L .59224 .84152 L p F P
0 g
s
.01 w
.78973 .61175 Mdot
.27217 .50484 Mdot
.78899 .61259 Mdot
.7825 .522 Mdot
.78827 .61342 Mdot
.5 Mabswid
.466 .467 .774 r
.33486 .70158 m .30859 .72574 L .28582 .6957 L p F P
0 g
s
.466 .467 .774 r
.28582 .6957 m .3145 .66843 L .33486 .70158 L p F P
0 g
s
.645 .726 .907 r
.5168 .84641 m .50899 .84776 L .49244 .82508 L p F P
0 g
s
.63 .72 .912 r
.47841 .82947 m .49244 .82508 L .50899 .84776 L p F P
0 g
s
.884 .681 .623 r
.73311 .49749 m .78345 .52874 L .77583 .56264 L p F P
0 g
s
.894 .659 .576 r
.78345 .52874 m .73311 .49749 L .73655 .46367 L p F P
0 g
s
.01 w
.27437 .50269 Mdot
.78759 .61424 Mdot
.5 Mabswid
.681 .755 .907 r
.54114 .84762 m .53328 .84634 L .54126 .82216 L p F P
0 g
s
.681 .755 .907 r
.54126 .82216 m .55705 .82478 L .54114 .84762 L p F P
0 g
s
.01 w
.78693 .61504 Mdot
.5 Mabswid
.502 .3 .537 r
.37226 .44048 m .30944 .46608 L .3088 .43442 L p F P
0 g
s
.502 .3 .537 r
.3088 .43442 m .3718 .40828 L .37226 .44048 L p F P
0 g
s
.01 w
.7863 .61582 Mdot
.78045 .52172 Mdot
.27661 .50058 Mdot
.7857 .61659 Mdot
.5 Mabswid
.658 .734 .905 r
.52503 .84593 m .5168 .84641 L .50812 .82231 L p F P
0 g
s
.645 .726 .907 r
.49244 .82508 m .50812 .82231 L .5168 .84641 L p F P
0 g
s
.671 .744 .905 r
.53328 .84634 m .52503 .84593 L .52467 .82132 L p F P
0 g
s
.671 .744 .905 r
.52467 .82132 m .54126 .82216 L .53328 .84634 L p F P
0 g
s
.01 w
.78514 .61734 Mdot
.5 Mabswid
.658 .734 .905 r
.50812 .82231 m .52467 .82132 L .52503 .84593 L p F P
0 g
s
.869 .793 .773 r
.73331 .66633 m .76302 .69335 L .7404 .72365 L p F P
0 g
s
.889 .786 .741 r
.76302 .69335 m .73331 .66633 L .75061 .63198 L p F P
0 g
s
.01 w
.7846 .61806 Mdot
.7841 .61876 Mdot
.27891 .49852 Mdot
.5 Mabswid
.838 .573 .538 r
.67324 .40652 m .7372 .43195 L .73655 .46367 L p F P
0 g
s
.839 .539 .482 r
.7372 .43195 m .67324 .40652 L .67178 .37719 L p F P
0 g
s
.01 w
.77838 .52152 Mdot
.78362 .61944 Mdot
.5 Mabswid
.579 .673 .903 r
.42481 .82462 m .43774 .81423 L .46671 .83525 L p F P
0 g
s
.559 .632 .88 r
.43774 .81423 m .42481 .82462 L .39285 .80391 L p F P
0 g
s
.01 w
.78318 .62008 Mdot
.5 Mabswid
.631 .333 .446 r
.52214 .35601 m .44519 .3621 L .44704 .3362 L p F P
0 g
s
.631 .333 .446 r
.44704 .3362 m .52223 .33016 L .52214 .35601 L p F P
0 g
s
.01 w
.78277 .6207 Mdot
.78238 .62129 Mdot
.78387 .60635 Mdot
.78374 .60779 Mdot
.78399 .60485 Mdot
.78359 .60918 Mdot
.78409 .6033 Mdot
.78203 .62184 Mdot
.28126 .49652 Mdot
.78343 .61051 Mdot
.78417 .60169 Mdot
.5 Mabswid
.771 .802 .879 r
.62505 .82372 m .61172 .81344 L .63944 .78891 L p F P
0 g
s
.771 .802 .879 r
.63944 .78891 m .65675 .8027 L .62505 .82372 L p F P
0 g
s
.01 w
.78326 .61179 Mdot
.78423 .60004 Mdot
.78308 .61301 Mdot
.78427 .59833 Mdot
.7829 .61417 Mdot
.5 Mabswid
.769 .444 .436 r
.67178 .37719 m .59931 .36118 L .59763 .33528 L p F P
0 g
s
.703 .391 .447 r
.52223 .33016 m .59763 .33528 L .59931 .36118 L p F P
0 g
s
.01 w
.78428 .59657 Mdot
.78271 .61527 Mdot
.78171 .62237 Mdot
.78251 .61632 Mdot
.78427 .59476 Mdot
.78231 .61731 Mdot
.78423 .5929 Mdot
.78211 .61824 Mdot
.78142 .62285 Mdot
.78191 .61912 Mdot
.78416 .59099 Mdot
.5 Mabswid
.492 .51 .804 r
.35775 .73322 m .33428 .75408 L .30859 .72574 L p F P
0 g
s
.492 .51 .804 r
.30859 .72574 m .33486 .70158 L .35775 .73322 L p F P
0 g
s
.01 w
.78172 .61993 Mdot
.78115 .6233 Mdot
.78406 .58903 Mdot
.78153 .62069 Mdot
.77632 .52138 Mdot
.78134 .62139 Mdot
.78092 .62371 Mdot
.78393 .58703 Mdot
.78116 .62204 Mdot
.78099 .62262 Mdot
.78071 .62408 Mdot
.78082 .62315 Mdot
.78376 .58499 Mdot
.78067 .62363 Mdot
.78053 .62441 Mdot
.78053 .62404 Mdot
.78038 .62469 Mdot
.78356 .5829 Mdot
.78041 .62441 Mdot
.7803 .62471 Mdot
.78026 .62494 Mdot
.7802 .62497 Mdot
.78016 .62514 Mdot
.78013 .62517 Mdot
.78009 .62529 Mdot
.78007 .62532 Mdot
.78332 .58077 Mdot
.78004 .62539 Mdot
.78003 .62541 Mdot
.78001 .62545 Mdot
.78001 .62545 Mdot
.78001 .62546 Mdot
.28366 .49458 Mdot
.5 Mabswid
.605 .676 .891 r
.47841 .82947 m .46671 .83525 L .43774 .81423 L p F P
0 g
s
.01 w
.78304 .57861 Mdot
.78273 .5764 Mdot
.78237 .57415 Mdot
.5 Mabswid
.73 .777 .891 r
.58316 .83472 m .57125 .82905 L .59405 .80481 L p F P
0 g
s
.73 .777 .891 r
.59405 .80481 m .61172 .81344 L .58316 .83472 L p F P
0 g
s
.01 w
.78196 .57187 Mdot
.77424 .5213 Mdot
.78151 .56956 Mdot
.5 Mabswid
.559 .632 .88 r
.39285 .80391 m .40962 .78998 L .43774 .81423 L p F P
0 g
s
.538 .592 .856 r
.40962 .78998 m .39285 .80391 L .36251 .78027 L p F P
0 g
s
.848 .798 .802 r
.71321 .69972 m .7404 .72365 L .71488 .75228 L p F P
0 g
s
.869 .793 .773 r
.7404 .72365 m .71321 .69972 L .73331 .66633 L p F P
0 g
s
.01 w
.78102 .56721 Mdot
.2861 .49269 Mdot
.78047 .56483 Mdot
.5 Mabswid
.516 .551 .831 r
.38281 .76284 m .36251 .78027 L .33428 .75408 L p F P
0 g
s
.516 .551 .831 r
.33428 .75408 m .35775 .73322 L .38281 .76284 L p F P
0 g
s
.571 .32 .497 r
.44436 .39151 m .3718 .40828 L .37334 .37896 L p F P
0 g
s
.571 .32 .497 r
.37334 .37896 m .44519 .3621 L .44436 .39151 L p F P
0 g
s
.01 w
.77988 .56242 Mdot
.77924 .55999 Mdot
.5 Mabswid
.799 .802 .854 r
.65675 .8027 m .63944 .78891 L .66589 .7615 L p F P
0 g
s
.799 .802 .854 r
.66589 .7615 m .68685 .77876 L .65675 .8027 L p F P
0 g
s
.538 .592 .856 r
.36251 .78027 m .38281 .76284 L .40962 .78998 L p F P
0 g
s
.01 w
.77217 .52128 Mdot
.5 Mabswid
.479 .378 .663 r
.32848 .5715 m .28259 .59976 L .27148 .56534 L p F P
0 g
s
.479 .378 .663 r
.27148 .56534 m .31931 .53515 L .32848 .5715 L p F P
0 g
s
.01 w
.77854 .55753 Mdot
.28859 .49086 Mdot
.7778 .55504 Mdot
.5 Mabswid
.703 .391 .447 r
.59931 .36118 m .52214 .35601 L .52223 .33016 L p F P
0 g
s
.01 w
.77699 .55254 Mdot
.5 Mabswid
.776 .487 .498 r
.59931 .36118 m .67178 .37719 L .67324 .40652 L p F P
0 g
s
.825 .801 .829 r
.69061 .73162 m .71488 .75228 L .68685 .77876 L p F P
0 g
s
.848 .798 .802 r
.71488 .75228 m .69061 .73162 L .71321 .69972 L p F P
0 g
s
.01 w
.77614 .55001 Mdot
.29113 .48909 Mdot
.5 Mabswid
.825 .801 .829 r
.68685 .77876 m .66589 .7615 L .69061 .73162 L p F P
0 g
s
.01 w
.77009 .52133 Mdot
.77522 .54747 Mdot
.77425 .54491 Mdot
.5 Mabswid
.873 .699 .663 r
.72687 .53293 m .77583 .56264 L .76485 .59724 L p F P
0 g
s
.884 .681 .623 r
.77583 .56264 m .72687 .53293 L .73311 .49749 L p F P
0 g
s
.01 w
.77323 .54234 Mdot
.29371 .48738 Mdot
.77214 .53976 Mdot
.76801 .52143 Mdot
.77099 .53717 Mdot
.5 Mabswid
.629 .683 .882 r
.49244 .82508 m .47841 .82947 L .45507 .80545 L p F P
0 g
s
.605 .676 .891 r
.43774 .81423 m .45507 .80545 L .47841 .82947 L p F P
0 g
s
.01 w
.76978 .53457 Mdot
.29633 .48574 Mdot
.5 Mabswid
.719 .756 .882 r
.57125 .82905 m .55705 .82478 L .57286 .79831 L p F P
0 g
s
.719 .756 .882 r
.57286 .79831 m .59405 .80481 L .57125 .82905 L p F P
0 g
s
.01 w
.76851 .53197 Mdot
.76594 .5216 Mdot
.76718 .52936 Mdot
.299 .48415 Mdot
.299 .48416 Mdot
.76578 .52675 Mdot
.76388 .52182 Mdot
.76433 .52415 Mdot
.5 Mabswid
.526 .349 .585 r
.37477 .47512 m .31294 .49983 L .30944 .46608 L p F P
0 g
s
.526 .349 .585 r
.30944 .46608 m .37226 .44048 L .37477 .47512 L p F P
0 g
s
.594 .639 .865 r
.45507 .80545 m .43774 .81423 L .40962 .78998 L p F P
0 g
s
.01 w
.3017 .48264 Mdot
.76281 .52155 Mdot
.5 Mabswid
.758 .772 .864 r
.61172 .81344 m .59405 .80481 L .61627 .7773 L p F P
0 g
s
.758 .772 .864 r
.61627 .7773 m .63944 .78891 L .61172 .81344 L p F P
0 g
s
.01 w
.76122 .51896 Mdot
.76181 .5221 Mdot
.75957 .51638 Mdot
.30444 .48119 Mdot
.5 Mabswid
.501 .422 .698 r
.34034 .60831 m .29699 .63431 L .28259 .59976 L p F P
0 g
s
.501 .422 .698 r
.28259 .59976 m .32848 .5715 L .34034 .60831 L p F P
0 g
s
.834 .601 .585 r
.67278 .43875 m .73655 .46367 L .73311 .49749 L p F P
0 g
s
.838 .573 .538 r
.73655 .46367 m .67278 .43875 L .67324 .40652 L p F P
0 g
s
.65 .693 .876 r
.50812 .82231 m .49244 .82508 L .47599 .79876 L p F P
0 g
s
.629 .683 .882 r
.45507 .80545 m .47599 .79876 L .49244 .82508 L p F P
0 g
s
.01 w
.75785 .5138 Mdot
.5 Mabswid
.705 .737 .876 r
.55705 .82478 m .54126 .82216 L .54921 .7943 L p F P
0 g
s
.705 .737 .876 r
.54921 .7943 m .57286 .79831 L .55705 .82478 L p F P
0 g
s
.01 w
.75976 .52244 Mdot
.75608 .51125 Mdot
.30721 .47981 Mdot
.75423 .5087 Mdot
.75772 .52283 Mdot
.75232 .50618 Mdot
.31002 .4785 Mdot
.5 Mabswid
.861 .714 .698 r
.71788 .56943 m .76485 .59724 L .75061 .63198 L p F P
0 g
s
.873 .699 .663 r
.76485 .59724 m .71788 .56943 L .72687 .53293 L p F P
0 g
s
.01 w
.75035 .50368 Mdot
.5 Mabswid
.67 .705 .873 r
.52467 .82132 m .50812 .82231 L .49948 .79453 L p F P
0 g
s
.65 .693 .876 r
.47599 .79876 m .49948 .79453 L .50812 .82231 L p F P
0 g
s
.689 .72 .873 r
.54126 .82216 m .52467 .82132 L .52432 .79302 L p F P
0 g
s
.689 .72 .873 r
.52432 .79302 m .54921 .7943 L .54126 .82216 L p F P
0 g
s
.01 w
.75569 .52328 Mdot
.31286 .47725 Mdot
.74831 .5012 Mdot
.5 Mabswid
.67 .705 .873 r
.49948 .79453 m .52432 .79302 L .52467 .82132 L p F P
0 g
s
.01 w
.74621 .49875 Mdot
.75368 .52377 Mdot
.5 Mabswid
.647 .382 .504 r
.5221 .38546 m .44436 .39151 L .44519 .3621 L p F P
0 g
s
.647 .382 .504 r
.44519 .3621 m .52214 .35601 L .5221 .38546 L p F P
0 g
s
.594 .639 .865 r
.40962 .78998 m .43233 .77816 L .45507 .80545 L p F P
0 g
s
.581 .603 .84 r
.43233 .77816 m .40962 .78998 L .38281 .76284 L p F P
0 g
s
.01 w
.31572 .47608 Mdot
.74404 .49632 Mdot
.5 Mabswid
.776 .487 .498 r
.67324 .40652 m .60006 .3906 L .59931 .36118 L p F P
0 g
s
.714 .436 .504 r
.52214 .35601 m .59931 .36118 L .60006 .3906 L p F P
0 g
s
.01 w
.74181 .49392 Mdot
.5 Mabswid
.781 .765 .838 r
.63944 .78891 m .61627 .7773 L .63755 .74691 L p F P
0 g
s
.781 .765 .838 r
.63755 .74691 m .66589 .7615 L .63944 .78891 L p F P
0 g
s
.01 w
.75168 .52432 Mdot
.31862 .47498 Mdot
.5 Mabswid
.521 .461 .73 r
.35474 .64496 m .3145 .66843 L .29699 .63431 L p F P
0 g
s
.521 .461 .73 r
.29699 .63431 m .34034 .60831 L .35474 .64496 L p F P
0 g
s
.589 .367 .547 r
.4446 .42406 m .37226 .44048 L .3718 .40828 L p F P
0 g
s
.589 .367 .547 r
.3718 .40828 m .44436 .39151 L .4446 .42406 L p F P
0 g
s
.01 w
.73952 .49156 Mdot
.73717 .48923 Mdot
.5 Mabswid
.624 .649 .854 r
.47599 .79876 m .45507 .80545 L .43233 .77816 L p F P
0 g
s
.01 w
.74969 .52491 Mdot
.32154 .47395 Mdot
.5 Mabswid
.779 .522 .548 r
.60006 .3906 m .67324 .40652 L .67278 .43875 L p F P
0 g
s
.741 .744 .854 r
.59405 .80481 m .57286 .79831 L .58832 .76852 L p F P
0 g
s
.741 .744 .854 r
.58832 .76852 m .61627 .7773 L .59405 .80481 L p F P
0 g
s
.01 w
.73475 .48694 Mdot
.5 Mabswid
.848 .726 .729 r
.70626 .6064 m .75061 .63198 L .73331 .66633 L p F P
0 g
s
.861 .714 .698 r
.75061 .63198 m .70626 .6064 L .71788 .56943 L p F P
0 g
s
.01 w
.74773 .52556 Mdot
.73227 .48469 Mdot
.32449 .473 Mdot
.5 Mabswid
.545 .392 .625 r
.37934 .51167 m .31931 .53515 L .31294 .49983 L p F P
0 g
s
.545 .392 .625 r
.31294 .49983 m .37477 .47512 L .37934 .51167 L p F P
0 g
s
.581 .603 .84 r
.38281 .76284 m .41056 .74799 L .43233 .77816 L p F P
0 g
s
.568 .568 .813 r
.41056 .74799 m .38281 .76284 L .35775 .73322 L p F P
0 g
s
.01 w
.72974 .48247 Mdot
.5 Mabswid
.714 .436 .504 r
.60006 .3906 m .5221 .38546 L .52214 .35601 L p F P
0 g
s
.01 w
.74579 .52624 Mdot
.32745 .47212 Mdot
.5 Mabswid
.538 .498 .759 r
.37143 .68085 m .33486 .70158 L .3145 .66843 L p F P
0 g
s
.538 .498 .759 r
.3145 .66843 m .35474 .64496 L .37143 .68085 L p F P
0 g
s
.01 w
.72714 .48031 Mdot
.5 Mabswid
.801 .757 .812 r
.66589 .7615 m .63755 .74691 L .65751 .71408 L p F P
0 g
s
.801 .757 .812 r
.65751 .71408 m .69061 .73162 L .66589 .7615 L p F P
0 g
s
.01 w
.74387 .52697 Mdot
.72449 .47818 Mdot
.33044 .47131 Mdot
.5 Mabswid
.829 .624 .625 r
.67034 .47345 m .73311 .49749 L .72687 .53293 L p F P
0 g
s
.834 .601 .585 r
.73311 .49749 m .67034 .47345 L .67278 .43875 L p F P
0 g
s
.568 .568 .813 r
.35775 .73322 m .39015 .71538 L .41056 .74799 L p F P
0 g
s
.554 .534 .787 r
.39015 .71538 m .35775 .73322 L .33486 .70158 L p F P
0 g
s
.01 w
.72178 .47611 Mdot
.74197 .52774 Mdot
.5 Mabswid
.554 .534 .787 r
.33486 .70158 m .37143 .68085 L .39015 .71538 L p F P
0 g
s
.834 .738 .758 r
.69216 .64324 m .73331 .66633 L .71321 .69972 L p F P
0 g
s
.848 .726 .729 r
.73331 .66633 m .69216 .64324 L .70626 .6064 L p F P
0 g
s
.01 w
.33344 .47057 Mdot
.71901 .47408 Mdot
.7401 .52855 Mdot
.5 Mabswid
.818 .748 .786 r
.69061 .73162 m .65751 .71408 L .67582 .67933 L p F P
0 g
s
.818 .748 .786 r
.67582 .67933 m .71321 .69972 L .69061 .73162 L p F P
0 g
s
.01 w
.71619 .47211 Mdot
.33646 .46991 Mdot
.5 Mabswid
.834 .738 .758 r
.71321 .69972 m .67582 .67933 L .69216 .64324 L p F P
0 g
s
.652 .662 .847 r
.49948 .79453 m .47599 .79876 L .45992 .76913 L p F P
0 g
s
.624 .649 .854 r
.43233 .77816 m .45992 .76913 L .47599 .79876 L p F P
0 g
s
.01 w
.71331 .47019 Mdot
.73825 .5294 Mdot
.5 Mabswid
.722 .719 .847 r
.57286 .79831 m .54921 .7943 L .557 .7631 L p F P
0 g
s
.722 .719 .847 r
.557 .7631 m .58832 .76852 L .57286 .79831 L p F P
0 g
s
.01 w
.33949 .46933 Mdot
.71039 .46833 Mdot
.73644 .53029 Mdot
.70741 .46652 Mdot
.34254 .46882 Mdot
.73465 .5312 Mdot
.70439 .46477 Mdot
.5 Mabswid
.619 .617 .827 r
.45992 .76913 m .43233 .77816 L .41056 .74799 L p F P
0 g
s
.01 w
.73289 .53215 Mdot
.34559 .46838 Mdot
.70131 .46308 Mdot
.5 Mabswid
.759 .731 .826 r
.61627 .7773 m .58832 .76852 L .60316 .73583 L p F P
0 g
s
.759 .731 .826 r
.60316 .73583 m .63755 .74691 L .61627 .7773 L p F P
0 g
s
.01 w
.73117 .53313 Mdot
.6982 .46146 Mdot
.5 Mabswid
.678 .678 .843 r
.52432 .79302 m .49948 .79453 L .49102 .76341 L p F P
0 g
s
.652 .662 .847 r
.45992 .76913 m .49102 .76341 L .49948 .79453 L p F P
0 g
s
.56 .43 .66 r
.38593 .54956 m .32848 .5715 L .31931 .53515 L p F P
0 g
s
.56 .43 .66 r
.31931 .53515 m .37934 .51167 L .38593 .54956 L p F P
0 g
s
.01 w
.34864 .46801 Mdot
.5 Mabswid
.701 .697 .843 r
.54921 .7943 m .52432 .79302 L .52397 .76136 L p F P
0 g
s
.701 .697 .843 r
.52397 .76136 m .557 .7631 L .54921 .7943 L p F P
0 g
s
.01 w
.69504 .4599 Mdot
.72948 .53414 Mdot
.5 Mabswid
.604 .408 .589 r
.44594 .45928 m .37477 .47512 L .37226 .44048 L p F P
0 g
s
.604 .408 .589 r
.37226 .44048 m .4446 .42406 L .44594 .45928 L p F P
0 g
s
.01 w
.3517 .46773 Mdot
.5 Mabswid
.659 .423 .551 r
.5221 .41813 m .4446 .42406 L .44436 .39151 L p F P
0 g
s
.659 .423 .551 r
.44436 .39151 m .5221 .38546 L .5221 .41813 L p F P
0 g
s
.678 .678 .843 r
.49102 .76341 m .52397 .76136 L .52432 .79302 L p F P
0 g
s
.01 w
.69183 .4584 Mdot
.72782 .53517 Mdot
.5 Mabswid
.823 .643 .66 r
.66593 .51009 m .72687 .53293 L .71788 .56943 L p F P
0 g
s
.829 .624 .625 r
.72687 .53293 m .66593 .51009 L .67034 .47345 L p F P
0 g
s
.779 .522 .548 r
.67278 .43875 m .59982 .42316 L .60006 .3906 L p F P
0 g
s
.72 .473 .551 r
.5221 .38546 m .60006 .3906 L .59982 .42316 L p F P
0 g
s
.779 .55 .589 r
.59982 .42316 m .67278 .43875 L .67034 .47345 L p F P
0 g
s
.01 w
.68859 .45697 Mdot
.35476 .46751 Mdot
.7262 .53622 Mdot
.68531 .45561 Mdot
.72462 .53729 Mdot
.35782 .46737 Mdot
.68199 .45432 Mdot
.72307 .53839 Mdot
.36088 .4673 Mdot
.67864 .4531 Mdot
.72156 .53949 Mdot
.5 Mabswid
.619 .617 .827 r
.41056 .74799 m .4445 .7366 L .45992 .76913 L p F P
0 g
s
.612 .587 .801 r
.4445 .7366 m .41056 .74799 L .39015 .71538 L p F P
0 g
s
.01 w
.67526 .45195 Mdot
.72009 .54062 Mdot
.36393 .4673 Mdot
.5 Mabswid
.72 .473 .551 r
.59982 .42316 m .5221 .41813 L .5221 .38546 L p F P
0 g
s
.01 w
.67185 .45087 Mdot
.71866 .54175 Mdot
.5 Mabswid
.774 .718 .8 r
.63755 .74691 m .60316 .73583 L .61713 .70073 L p F P
0 g
s
.774 .718 .8 r
.61713 .70073 m .65751 .71408 L .63755 .74691 L p F P
0 g
s
.574 .464 .691 r
.39443 .58815 m .34034 .60831 L .32848 .5715 L p F P
0 g
s
.574 .464 .691 r
.32848 .5715 m .38593 .54956 L .39443 .58815 L p F P
0 g
s
.01 w
.36698 .46737 Mdot
.71727 .5429 Mdot
.66841 .44986 Mdot
.66841 .44987 Mdot
.5 Mabswid
.652 .634 .819 r
.49102 .76341 m .45992 .76913 L .4445 .7366 L p F P
0 g
s
.01 w
.71592 .54405 Mdot
.5 Mabswid
.735 .702 .819 r
.58832 .76852 m .557 .7631 L .56449 .72898 L p F P
0 g
s
.735 .702 .819 r
.56449 .72898 m .60316 .73583 L .58832 .76852 L p F P
0 g
s
.01 w
.66495 .44894 Mdot
.37001 .46751 Mdot
.71461 .54521 Mdot
.5 Mabswid
.815 .661 .691 r
.65958 .54808 m .71788 .56943 L .70626 .6064 L p F P
0 g
s
.823 .643 .66 r
.71788 .56943 m .65958 .54808 L .66593 .51009 L p F P
0 g
s
.01 w
.66147 .44808 Mdot
.71335 .54637 Mdot
.37303 .46773 Mdot
.65796 .4473 Mdot
.71212 .54753 Mdot
.37604 .46801 Mdot
.71094 .54869 Mdot
.65444 .4466 Mdot
.5 Mabswid
.612 .587 .801 r
.39015 .71538 m .42999 .70165 L .4445 .7366 L p F P
0 g
s
.604 .557 .775 r
.42999 .70165 m .39015 .71538 L .37143 .68085 L p F P
0 g
s
.01 w
.70981 .54984 Mdot
.6509 .44597 Mdot
.37903 .46836 Mdot
.5 Mabswid
.585 .496 .72 r
.40473 .6268 m .35474 .64496 L .34034 .60831 L p F P
0 g
s
.585 .496 .72 r
.34034 .60831 m .39443 .58815 L .40473 .6268 L p F P
0 g
s
.01 w
.70871 .55099 Mdot
.5 Mabswid
.615 .442 .625 r
.44837 .49663 m .37934 .51167 L .37477 .47512 L p F P
0 g
s
.615 .442 .625 r
.37477 .47512 m .44594 .45928 L .44837 .49663 L p F P
0 g
s
.787 .705 .774 r
.65751 .71408 m .61713 .70073 L .62997 .66378 L p F P
0 g
s
.787 .705 .774 r
.62997 .66378 m .67582 .67933 L .65751 .71408 L p F P
0 g
s
.01 w
.70766 .55213 Mdot
.64735 .44542 Mdot
.382 .46877 Mdot
.70666 .55326 Mdot
.64379 .44494 Mdot
.70569 .55438 Mdot
.5 Mabswid
.777 .575 .625 r
.59857 .45841 m .67034 .47345 L .66593 .51009 L p F P
0 g
s
.779 .55 .589 r
.67034 .47345 m .59857 .45841 L .59982 .42316 L p F P
0 g
s
.682 .653 .815 r
.52397 .76136 m .49102 .76341 L .48288 .72937 L p F P
0 g
s
.652 .634 .819 r
.4445 .7366 m .48288 .72937 L .49102 .76341 L p F P
0 g
s
.807 .676 .72 r
.65138 .5868 m .70626 .6064 L .69216 .64324 L p F P
0 g
s
.815 .661 .691 r
.70626 .6064 m .65138 .5868 L .65958 .54808 L p F P
0 g
s
.01 w
.70477 .55548 Mdot
.5 Mabswid
.604 .557 .775 r
.37143 .68085 m .41665 .66485 L .42999 .70165 L p F P
0 g
s
.595 .527 .748 r
.41665 .66485 m .37143 .68085 L .35474 .64496 L p F P
0 g
s
.71 .676 .815 r
.557 .7631 m .52397 .76136 L .52364 .72678 L p F P
0 g
s
.71 .676 .815 r
.52364 .72678 m .56449 .72898 L .557 .7631 L p F P
0 g
s
.01 w
.38496 .46925 Mdot
.5 Mabswid
.595 .527 .748 r
.35474 .64496 m .40473 .6268 L .41665 .66485 L p F P
0 g
s
.01 w
.64022 .44455 Mdot
.70389 .55657 Mdot
.70306 .55764 Mdot
.5 Mabswid
.668 .457 .591 r
.52215 .45356 m .44594 .45928 L .4446 .42406 L p F P
0 g
s
.668 .457 .591 r
.4446 .42406 m .5221 .41813 L .52215 .45356 L p F P
0 g
s
.01 w
.38788 .46979 Mdot
.63664 .44423 Mdot
.70227 .55869 Mdot
.5 Mabswid
.797 .691 .747 r
.67582 .67933 m .62997 .66378 L .64145 .62559 L p F P
0 g
s
.797 .691 .747 r
.64145 .62559 m .69216 .64324 L .67582 .67933 L p F P
0 g
s
.01 w
.70152 .55972 Mdot
.5 Mabswid
.724 .504 .591 r
.5221 .41813 m .59982 .42316 L .59857 .45841 L p F P
0 g
s
.682 .653 .815 r
.48288 .72937 m .52364 .72678 L .52397 .76136 L p F P
0 g
s
.01 w
.70081 .56072 Mdot
.5 Mabswid
.807 .676 .72 r
.69216 .64324 m .64145 .62559 L .65138 .5868 L p F P
0 g
s
.01 w
.63306 .44399 Mdot
.39079 .4704 Mdot
.70015 .56169 Mdot
.69952 .56264 Mdot
.62949 .44382 Mdot
.69894 .56355 Mdot
.69839 .56444 Mdot
.39366 .47106 Mdot
.69788 .56529 Mdot
.69741 .5661 Mdot
.62591 .44374 Mdot
.69698 .56688 Mdot
.5 Mabswid
.65 .607 .793 r
.48288 .72937 m .4445 .7366 L .42999 .70165 L p F P
0 g
s
.01 w
.69659 .56762 Mdot
.69623 .56832 Mdot
.69296 .54827 Mdot
.69329 .5499 Mdot
.69258 .5466 Mdot
.69359 .55147 Mdot
.69217 .54488 Mdot
.69385 .553 Mdot
.69171 .54312 Mdot
.69408 .55448 Mdot
.6912 .54132 Mdot
.69427 .55591 Mdot
.69065 .53947 Mdot
.6959 .56898 Mdot
.69444 .55728 Mdot
.69006 .53759 Mdot
.69457 .55861 Mdot
.68941 .53566 Mdot
.69468 .55987 Mdot
.39651 .47179 Mdot
.68871 .53371 Mdot
.69476 .56109 Mdot
.69483 .56224 Mdot
.68796 .53171 Mdot
.6956 .5696 Mdot
.69487 .56334 Mdot
.68716 .52969 Mdot
.62234 .44372 Mdot
.69489 .56439 Mdot
.6863 .52763 Mdot
.69489 .56538 Mdot
.69534 .57017 Mdot
.69488 .56631 Mdot
.68538 .52555 Mdot
.5 Mabswid
.746 .685 .792 r
.60316 .73583 m .56449 .72898 L .57155 .69245 L p F P
0 g
s
.746 .685 .792 r
.57155 .69245 m .61713 .70073 L .60316 .73583 L p F P
0 g
s
.01 w
.69485 .56718 Mdot
.69511 .57069 Mdot
.68441 .52343 Mdot
.69482 .56799 Mdot
.69477 .56874 Mdot
.68338 .5213 Mdot
.69491 .57117 Mdot
.69472 .56944 Mdot
.68228 .51914 Mdot
.69466 .57007 Mdot
.69473 .5716 Mdot
.6946 .57065 Mdot
.68113 .51695 Mdot
.69453 .57116 Mdot
.69459 .57198 Mdot
.69447 .57162 Mdot
.69446 .57231 Mdot
.69441 .57202 Mdot
.67991 .51475 Mdot
.69435 .57236 Mdot
.69437 .57259 Mdot
.6943 .57264 Mdot
.69429 .57282 Mdot
.69425 .57286 Mdot
.69423 .57299 Mdot
.69422 .57302 Mdot
.67863 .51254 Mdot
.6942 .57311 Mdot
.69419 .57313 Mdot
.69418 .57317 Mdot
.69418 .57318 Mdot
.69418 .57318 Mdot
.67729 .51031 Mdot
.67588 .50806 Mdot
.61877 .44379 Mdot
.67441 .50581 Mdot
.39933 .47257 Mdot
.67287 .50354 Mdot
.67126 .50128 Mdot
.66959 .49901 Mdot
.66785 .49673 Mdot
.66604 .49446 Mdot
.61522 .44393 Mdot
.66416 .4922 Mdot
.66221 .48994 Mdot
.5 Mabswid
.724 .504 .591 r
.59857 .45841 m .52215 .45356 L .5221 .41813 L p F P
0 g
s
.01 w
.6602 .48769 Mdot
.40211 .47341 Mdot
.65811 .48545 Mdot
.65596 .48322 Mdot
.65374 .48101 Mdot
.61168 .44414 Mdot
.65145 .47882 Mdot
.64909 .47665 Mdot
.64667 .4745 Mdot
.64417 .47238 Mdot
.40486 .4743 Mdot
.5 Mabswid
.624 .474 .657 r
.45186 .53552 m .38593 .54956 L .37934 .51167 L p F P
0 g
s
.624 .474 .657 r
.37934 .51167 m .44837 .49663 L .45186 .53552 L p F P
0 g
s
.01 w
.64161 .47029 Mdot
.60815 .44443 Mdot
.63899 .46822 Mdot
.6363 .46619 Mdot
.63354 .4642 Mdot
.63073 .46224 Mdot
.62785 .46033 Mdot
.40757 .47525 Mdot
.62491 .45845 Mdot
.60464 .44479 Mdot
.62191 .45662 Mdot
.61885 .45484 Mdot
.61573 .4531 Mdot
.5 Mabswid
.775 .596 .657 r
.59632 .49581 m .66593 .51009 L .65958 .54808 L p F P
0 g
s
.777 .575 .625 r
.66593 .51009 m .59632 .49581 L .59857 .45841 L p F P
0 g
s
.01 w
.61256 .45142 Mdot
.60933 .44979 Mdot
.60115 .44523 Mdot
.60605 .44821 Mdot
.41024 .47624 Mdot
.60273 .4467 Mdot
.59935 .44523 Mdot
.59592 .44383 Mdot
.59245 .4425 Mdot
.58894 .44122 Mdot
.59768 .44573 Mdot
.58538 .44001 Mdot
.58179 .43887 Mdot
.57816 .4378 Mdot
.57449 .4368 Mdot
.41288 .47729 Mdot
.57079 .43586 Mdot
.56706 .435 Mdot
.56331 .43422 Mdot
.55953 .4335 Mdot
.55572 .43286 Mdot
.5519 .4323 Mdot
.59423 .44631 Mdot
.54806 .43182 Mdot
.5442 .43141 Mdot
.54034 .43108 Mdot
.53646 .43083 Mdot
.53257 .43065 Mdot
.52868 .43056 Mdot
.52479 .43054 Mdot
.41547 .47838 Mdot
.59081 .44695 Mdot
.5 Mabswid
.65 .607 .793 r
.42999 .70165 m .47522 .69293 L .48288 .72937 L p F P
0 g
s
.647 .581 .767 r
.47522 .69293 m .42999 .70165 L .41665 .66485 L p F P
0 g
s
.684 .63 .789 r
.52364 .72678 m .48288 .72937 L .47522 .69293 L p F P
0 g
s
.01 w
.58742 .44767 Mdot
.41802 .47951 Mdot
.5 Mabswid
.716 .656 .788 r
.56449 .72898 m .52364 .72678 L .52332 .68979 L p F P
0 g
s
.716 .656 .788 r
.52332 .68979 m .57155 .69245 L .56449 .72898 L p F P
0 g
s
.754 .668 .766 r
.61713 .70073 m .57155 .69245 L .57805 .65411 L p F P
0 g
s
.754 .668 .766 r
.57805 .65411 m .62997 .66378 L .61713 .70073 L p F P
0 g
s
.674 .487 .625 r
.52224 .4912 m .44837 .49663 L .44594 .45928 L p F P
0 g
s
.674 .487 .625 r
.44594 .45928 m .52215 .45356 L .52224 .4912 L p F P
0 g
s
.01 w
.58406 .44845 Mdot
.42052 .48069 Mdot
.58074 .44929 Mdot
.5 Mabswid
.727 .53 .625 r
.52215 .45356 m .59857 .45841 L .59632 .49581 L p F P
0 g
s
.01 w
.42298 .4819 Mdot
.57745 .4502 Mdot
.5 Mabswid
.632 .502 .687 r
.45638 .57527 m .39443 .58815 L .38593 .54956 L p F P
0 g
s
.632 .502 .687 r
.38593 .54956 m .45186 .53552 L .45638 .57527 L p F P
0 g
s
.684 .63 .789 r
.47522 .69293 m .52332 .68979 L .52364 .72678 L p F P
0 g
s
.01 w
.42539 .48316 Mdot
.57419 .45117 Mdot
.57098 .45219 Mdot
.42776 .48445 Mdot
.5 Mabswid
.771 .616 .686 r
.59309 .53475 m .65958 .54808 L .65138 .5868 L p F P
0 g
s
.775 .596 .657 r
.65958 .54808 m .59309 .53475 L .59632 .49581 L p F P
0 g
s
.01 w
.56781 .45328 Mdot
.43007 .48577 Mdot
.56468 .45442 Mdot
.5 Mabswid
.647 .581 .767 r
.41665 .66485 m .46816 .65466 L .47522 .69293 L p F P
0 g
s
.643 .555 .741 r
.46816 .65466 m .41665 .66485 L .40473 .6268 L p F P
0 g
s
.01 w
.43233 .48713 Mdot
.56159 .45562 Mdot
.43454 .48851 Mdot
.55856 .45687 Mdot
.5 Mabswid
.761 .651 .74 r
.62997 .66378 m .57805 .65411 L .58388 .61459 L p F P
0 g
s
.761 .651 .74 r
.58388 .61459 m .64145 .62559 L .62997 .66378 L p F P
0 g
s
.638 .529 .714 r
.46185 .61522 m .40473 .6268 L .39443 .58815 L p F P
0 g
s
.638 .529 .714 r
.39443 .58815 m .45638 .57527 L .46185 .61522 L p F P
0 g
s
.727 .53 .625 r
.59632 .49581 m .52224 .4912 L .52215 .45356 L p F P
0 g
s
.01 w
.55557 .45817 Mdot
.4367 .48992 Mdot
.5 Mabswid
.643 .555 .741 r
.40473 .6268 m .46185 .61522 L .46816 .65466 L p F P
0 g
s
.01 w
.55263 .45952 Mdot
.43881 .49136 Mdot
.5 Mabswid
.767 .634 .714 r
.58892 .57457 m .65138 .5868 L .64145 .62559 L p F P
0 g
s
.771 .616 .686 r
.65138 .5868 m .58892 .57457 L .59309 .53475 L p F P
0 g
s
.01 w
.54974 .46092 Mdot
.44086 .49281 Mdot
.5469 .46236 Mdot
.5 Mabswid
.767 .634 .714 r
.64145 .62559 m .58388 .61459 L .58892 .57457 L p F P
0 g
s
.01 w
.44286 .49429 Mdot
.54412 .46385 Mdot
.5414 .46537 Mdot
.5 Mabswid
.685 .607 .763 r
.52332 .68979 m .47522 .69293 L .46816 .65466 L p F P
0 g
s
.01 w
.4448 .49578 Mdot
.53873 .46693 Mdot
.5 Mabswid
.721 .636 .762 r
.57155 .69245 m .52332 .68979 L .52304 .651 L p F P
0 g
s
.721 .636 .762 r
.52304 .651 m .57805 .65411 L .57155 .69245 L p F P
0 g
s
.01 w
.44668 .49729 Mdot
.5 Mabswid
.678 .514 .656 r
.52238 .53045 m .45186 .53552 L .44837 .49663 L p F P
0 g
s
.678 .514 .656 r
.44837 .49663 m .52224 .4912 L .52238 .53045 L p F P
0 g
s
.01 w
.53612 .46853 Mdot
.44851 .49881 Mdot
.53357 .47016 Mdot
.5 Mabswid
.727 .554 .656 r
.52224 .4912 m .59632 .49581 L .59309 .53475 L p F P
0 g
s
.01 w
.53108 .47182 Mdot
.45028 .50034 Mdot
.52865 .4735 Mdot
.452 .50188 Mdot
.52628 .47522 Mdot
.45365 .50342 Mdot
.52397 .47696 Mdot
.45525 .50497 Mdot
.52173 .47872 Mdot
.5 Mabswid
.685 .607 .763 r
.46816 .65466 m .52304 .651 L .52332 .68979 L p F P
0 g
s
.01 w
.51955 .48049 Mdot
.45679 .50651 Mdot
.51743 .48229 Mdot
.45828 .50806 Mdot
.51538 .48409 Mdot
.45971 .5096 Mdot
.51339 .48591 Mdot
.51147 .48774 Mdot
.46108 .51113 Mdot
.50961 .48957 Mdot
.46239 .51265 Mdot
.50782 .49141 Mdot
.46365 .51417 Mdot
.5 Mabswid
.727 .554 .656 r
.59309 .53475 m .52238 .53045 L .52224 .4912 L p F P
0 g
s
.01 w
.50609 .49325 Mdot
.50442 .49509 Mdot
.46485 .51567 Mdot
.5 Mabswid
.685 .585 .737 r
.52304 .651 m .46816 .65466 L .46185 .61522 L p F P
0 g
s
.01 w
.50282 .49693 Mdot
.466 .51715 Mdot
.50129 .49876 Mdot
.5 Mabswid
.682 .539 .684 r
.52256 .57063 m .45638 .57527 L .45186 .53552 L p F P
0 g
s
.682 .539 .684 r
.45186 .53552 m .52238 .53045 L .52256 .57063 L p F P
0 g
s
.01 w
.46709 .51862 Mdot
.5 Mabswid
.724 .616 .737 r
.57805 .65411 m .52304 .651 L .52278 .61105 L p F P
0 g
s
.724 .616 .737 r
.52278 .61105 m .58388 .61459 L .57805 .65411 L p F P
0 g
s
.01 w
.49981 .50058 Mdot
.4984 .50239 Mdot
.46812 .52006 Mdot
.49705 .50419 Mdot
.46911 .52149 Mdot
.5 Mabswid
.727 .576 .684 r
.52238 .53045 m .59309 .53475 L .58892 .57457 L p F P
0 g
s
.01 w
.49576 .50598 Mdot
.47004 .52289 Mdot
.49454 .50775 Mdot
.49337 .50949 Mdot
.47091 .52426 Mdot
.49226 .51122 Mdot
.47174 .52561 Mdot
.49122 .51293 Mdot
.49022 .51461 Mdot
.47252 .52693 Mdot
.48929 .51626 Mdot
.47325 .52821 Mdot
.48841 .51788 Mdot
.47393 .52947 Mdot
.48758 .51947 Mdot
.48681 .52103 Mdot
.47457 .53068 Mdot
.48608 .52256 Mdot
.47516 .53186 Mdot
.48541 .52405 Mdot
.48478 .5255 Mdot
.4757 .533 Mdot
.5 Mabswid
.685 .585 .737 r
.46185 .61522 m .52278 .61105 L .52304 .651 L p F P
0 g
s
.684 .562 .711 r
.52278 .61105 m .46185 .61522 L .45638 .57527 L p F P
0 g
s
.01 w
.48421 .52691 Mdot
.4762 .5341 Mdot
.48367 .52827 Mdot
.5 Mabswid
.684 .562 .711 r
.45638 .57527 m .52256 .57063 L .52278 .61105 L p F P
0 g
s
.01 w
.47667 .53516 Mdot
.48318 .5296 Mdot
.48274 .53088 Mdot
.47709 .53617 Mdot
.48233 .53211 Mdot
.47747 .53714 Mdot
.48196 .5333 Mdot
.48163 .53444 Mdot
.47782 .53807 Mdot
.5 Mabswid
.726 .596 .711 r
.58388 .61459 m .52278 .61105 L .52256 .57063 L p F P
0 g
s
.726 .596 .711 r
.52256 .57063 m .58892 .57457 L .58388 .61459 L p F P
0 g
s
.01 w
.48133 .53553 Mdot
.47813 .53895 Mdot
.48107 .53657 Mdot
.47841 .53977 Mdot
.48084 .53756 Mdot
.5 Mabswid
.727 .576 .684 r
.58892 .57457 m .52256 .57063 L .52238 .53045 L p F P
0 g
s
.01 w
.48064 .53849 Mdot
.47866 .54055 Mdot
.48047 .53938 Mdot
.47888 .54128 Mdot
.48032 .5402 Mdot
.47907 .54195 Mdot
.48019 .54097 Mdot
.47923 .54258 Mdot
.48009 .54169 Mdot
.48001 .54235 Mdot
.47937 .54314 Mdot
.47994 .54295 Mdot
.47948 .54366 Mdot
.4799 .54349 Mdot
.47958 .54412 Mdot
.47986 .54397 Mdot
.47966 .54452 Mdot
.47984 .5444 Mdot
.47972 .54486 Mdot
.47982 .54477 Mdot
.47982 .54507 Mdot
.47976 .54515 Mdot
.47982 .54532 Mdot
.47979 .54538 Mdot
.47982 .54551 Mdot
.47981 .54555 Mdot
.47982 .54564 Mdot
.47982 .54566 Mdot
.47983 .5457 Mdot
.47983 .54571 Mdot
.47983 .54572 Mdot
.25 Mabswid
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.08845 .24527 m
.67201 0 L
s
.09903 .24082 m
.10412 .24605 L
s
[(-1)] .08885 .23035 .97243 1 Mshowa
.22731 .1869 m
.23214 .19237 L
s
[(-0.5)] .21763 .17597 .88506 1 Mshowa
.36263 .13003 m
.36719 .13573 L
s
[(0)] .35353 .11861 .7977 1 Mshowa
.50562 .06993 m
.50984 .07588 L
s
[(0.5)] .49716 .05803 .71033 1 Mshowa
.65692 .00634 m
.66078 .01254 L
s
[(1)] .6492 -0.00605 .62296 1 Mshowa
.125 Mabswid
.12415 .23026 m
.12717 .23343 L
s
.14953 .21959 m
.15253 .22279 L
s
.17518 .20881 m
.17815 .21204 L
s
.2011 .19792 m
.20404 .20117 L
s
.25379 .17577 m
.25666 .17908 L
s
.28056 .16452 m
.28339 .16786 L
s
.30762 .15315 m
.31042 .15652 L
s
.33498 .14165 m
.33774 .14505 L
s
.3906 .11827 m
.39329 .12173 L
s
.41887 .10639 m
.42153 .10987 L
s
.44746 .09437 m
.45008 .09789 L
s
.47638 .08222 m
.47895 .08576 L
s
.53519 .0575 m
.53768 .0611 L
s
.5651 .04493 m
.56755 .04856 L
s
.59535 .03222 m
.59776 .03588 L
s
.62596 .01935 m
.62832 .02304 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-1)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-0.5)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(0.5)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(1)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{264.75, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004800017b000`400?l00000o`00003oo`3oool9
0?ooo`00o`3oool90?ooo`00Z`3oool4000005T0oooo002]0?ooo`030000003oool0oooo05P0oooo
002]0?ooo`030000003oool0oooo05P0oooo002]0?ooo`030000003oool0oooo05P0oooo002]0?oo
o`030000003oool0oooo05P0oooo002[0?ooo`<00000FP3oool00:d0oooo00<000000?ooo`3oool0
F03oool00?l0oooo2@3oool00;@0oooo0P00001B0?ooo`00/P3oool2000000030?ooo`0000000000
0540oooo002`0?ooo`8000000`3oool200000540oooo002]0?ooo`<000000P3oool01P000000oooo
0?ooo`000000oooo00000500oooo002[0?ooo`800000203oool00`000000oooo0000001@0?ooo`00
Z03oool3000000X0oooo00@000000?ooo`3oool00000C`3oool00:H0oooo0P0000020?ooo`030000
003oool0oooo00P0oooo00D000000?ooo`3oool0oooo0000001>0?ooo`00O@3oool2000000@0oooo
00<000000?ooo`3oool00P3oool3000001T0oooo0P00000?0?ooo`050000003oool0oooo0?ooo`00
0000CP3oool007`0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`0C0?ooo`<0
00004@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04/0oooo001l0?ooo`040000
003oool0oooo000000/0oooo00<000000?ooo`3oool04@3oool200000080oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04X0oooo001l0?ooo`040000
003oool0oooo000000P0oooo0`00000B0?ooo`8000005`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo04X0oooo001l0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3o
ool03`3oool3000001T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`190?ooo`00
O03oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00d0oooo0P0000000`3oool0
00000?ooo`0I0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0B@3oool007d0oooo
0P0000090?ooo`@000002P3oool2000001h0oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`180?ooo`00T`3oool300000200oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`170?ooo`00T@3oool2000000030?ooo`000000oooo0200oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`170?ooo`00SP3oool3000002D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`160?ooo`00S03oool2000002P0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`160?ooo`00RP3oool3000002T0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`150?ooo`00Q`3oool3000000<0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo04@0oooo00250?ooo`800000;`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo04@0oooo00230?ooo`80000000<0oooo0000003oool0;P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo04<0oooo001T0?ooo`8000006P3oool3000003<0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`120?ooo`00H`3oool010000000oooo
0?ooo`00000G0?ooo`800000=P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0480
oooo001S0?ooo`040000003oool0oooo000001D0oooo0P0000000`3oool000000?ooo`0e0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool0@@3oool006<0oooo00@000000?ooo`3oool0
00004P3oool3000003X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`110?ooo`00
H`3oool010000000oooo0?ooo`00000@0?ooo`800000?@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo0400oooo001S0?ooo`040000003oool0oooo000000d0oooo0`0000000`3oool0
00000?ooo`0m0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0?`3oool006@0oooo
0P00000<0?ooo`800000@`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03l0oooo
001`0?ooo`800000A@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03h0oooo001]
0?ooo`<0000000<0oooo0000003oool0A03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo03h0oooo001[0?ooo`800000BP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
03d0oooo001Y0?ooo`800000C03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo03`0
oooo001V0?ooo`<0000000<0oooo0000003oool0B`3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo03`0oooo001T0?ooo`800000D@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo03/0oooo001Q0?ooo`<00000D`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo03/0oooo000g0?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000006P3oool20000
05H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0j0?ooo`00=P3oool010000000
oooo0?ooo`00000;0?ooo`030000003oool0oooo01@0oooo0`00001H0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0>@3oool003H0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`0B0?ooo`@00000F@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
03T0oooo000`0?ooo`@000000P3oool010000000oooo0?ooo`0000080?ooo`<000004`3oool20000
05d0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0h0?ooo`00=P3oool010000000
oooo0?ooo`0000080?ooo`030000003oool0oooo0100oooo0`00001O0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0=`3oool003H0oooo00@000000?ooo`3oool00000203oool00`00
0000oooo0?ooo`0>0?ooo`@00000H03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
03L0oooo000g0?ooo`8000002@3oool4000000/0oooo0P00001T0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0=P3oool004l0oooo0P00001V0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0=P3oool004`0oooo0`0000000`3oool000000?ooo`1U0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0=@3oool004X0oooo0P00001/0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0=03oool004L0oooo0`00001^0?ooo`030000003oool0oooo
01H0oooo00<000000?ooo`3oool0=03oool004D0oooo0P0000020?ooo`800000K@3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo03<0oooo00120?ooo`<00000L`3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo03<0oooo000R0?ooo`@000006P3oool4000007@0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0b0?ooo`00903oool00`000000oooo0?ooo`0G
0?ooo`800000N03oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0340oooo000T0?oo
o`030000003oool0oooo01D0oooo0P00001j0?ooo`030000003oool0oooo01T0oooo00<000000?oo
o`3oool0<@3oool001`0oooo100000040?ooo`030000003oool0oooo0180oooo1000001k0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool0<03oool002@0oooo00<000000?ooo`3oool0
403oool2000007l0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0_0?ooo`008P3o
ool300000100oooo0P0000210?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0;`3o
ool002@0oooo00<000000?ooo`3oool02`3oool3000008<0oooo00<000000?ooo`3oool0703oool0
0`000000oooo0?ooo`0^0?ooo`00;`3oool3000008H0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`0^0?ooo`00;@3oool4000008L0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0]0?ooo`00:`3oool2000008/0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`0/0?ooo`00:@3oool2000008d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?oo
o`0/0?ooo`009`3oool2000000030?ooo`000000oooo08`0oooo00<000000?ooo`3oool07`3oool0
0`000000oooo0?ooo`0[0?ooo`009`3oool2000008l0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0[0?ooo`009`3oool3000008h0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`0Z0?ooo`009P3oool200000080oooo00<000000?ooo`3oool0GP3oool<00000280oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0Y0?ooo`007P3oool4000000@0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`1F0?oooa<0000000<09@000000000000001000
000K0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0:@3oool00200oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0540oooo8P00000G
0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0:03oool00200oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo04`0oooo3@00000706T0
0003000000250000Q@0000D0Q@003P00000C0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool09`3oool001P0oooo100000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`180?ooo`P0000000<0@P000000001Y00002@1Y0007000000/0
Q@0000<0000009L<002G30001`00000@0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool09`3oool00200oooo00<000000?ooo`3oool00P3oool2000000P0oooo00<000000?ooo`3oool0
A03oool30000000401@0000000000000000000@0@P0000@0000006T0001Y0000J@0020000003088B
8`040000002K9R<0VbHS09/V8`P00000102500000`000000U``009L<000309L<00H000003@3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02H0oooo000N0?ooo`<000001@3oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo0440oooo1P000005048000H000002`224R<00`00
0000VbHS09/V8`0909/V8`L00000202G3004000000X0oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`0V0?ooo`00803oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0?P3oool4000000@0@P001@00000206406@03000000224R<0PQ8S00`0
PQ8S00<0000009/V8`2K9R<03@2K9R<00`000000[S<J0:hc6P05000000H0U``00`0000080?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool09@3oool002D0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0j0?ooo`D0000000<0@P000000000000000`00000606406@030000
00224R<0PQ8S00D0PQ8S4@00000809/V8`030000002^<aX0[S<J00@0[S<J1@000000102G30000000
09h>002N3P03000000D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0T0?ooo`00
9@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03L0oooo2000000906406@X00000
202A;dH00`000000Z4560:Q1AP060:Q1APX000002P2^<aX400000080WPh00`0000030?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0903oool002D0oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0d0?ooo`<0000000D01`00000000000000<0010000000706406@@00000
0P1e5Sl00`000000TBm6094_AP0=094_AP030000002X@DH0Z45600h0Z45600<000000;]??`2kCcl0
0`0000080:hc6P040000002l>P@00000000000<0WPh00P0000000`3oool000000?ooo`0W0?ooo`03
0000003oool0oooo02<0oooo000T0?ooo`8000003`3oool00`000000oooo0?ooo`0a0?ooo`<00000
00<01`000000000000000P0`00400`000000H@0I06406@0206406@@000001P1e5Sl00`000000TBm6
094_AP0=094_AP030000002X@DH0Z45600h0Z45600<000000;]??`2kCcl00`2kCcl4000000D0[S<J
00<000000;`j102l>P@00`00000209h>00800000:03oool00`000000oooo0?ooo`0S0?ooo`009@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02l0oooo0P0000000`07000000000000
000403000@D000002@1e5Sl00`000000TBm6094_AP0:094_APd000002@2X@DH00`000000^dlo0;]?
?`060;]??`@0000000<0[S<J0000002l>P@0102l>P@6000002L0oooo00<000000?ooo`3oool08P3o
ool002@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0]0?ooo`04000000070000
0000000000@0<0010`00000=07DF?`030000002A;dH0TBm60080TBm62000000409]4G`030000002_
EEl0[eEO00H0[eEO3000000:0;]??`@000001P2l>P@4000002L0oooo00<000000?ooo`3oool08@3o
ool002@0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0Z0?ooo`@00000100`0042
0000000304d0;P000000MAHo00/0MAHo1`00000<09]4G`030000002_EEl0[eEO00l0[eEO00<00000
0<5SF`31He/0100000080;]??`030000003;FC000000008000000`2l>P@00`000000_3X400000002
000002H0oooo00<000000?ooo`3oool08@3oool002@0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0X0?ooo`<00000100`004200000080C@0^00<0000007DF?`1e5Sl01`1e5Sl40000
0080PRmJ00<0000009]4G`2KA5l03P2KA5l00`000000[eEO0:mEG`0?0:mEG`0300000031He/0`F=K
00@0`F=K100000050;]??`040000003;FC00beT`0<]I<080000000<0_3X40000002l>P@00P2l>P@3
000002D0oooo00<000000?ooo`3oool0803oool002<0oooo0P00000E0?ooo`030000003oool0oooo
02H0oooo0P00000303000@<00000101=02h00`000000MAHo07DF?`0307DF?`@000001P22;eX00`00
0000VdAO09]4G`0>09]4G`030000002_EEl0[eEO00l0[eEO00<000000<5SF`31He/02031He/40000
00030;]??`000000beT`00@0beT`0`0000020;`j10040000002l=P000000000002@0oooo00<00000
0?ooo`3oool0803oool002@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0S0?oo
o`@0000000<0<0010000000000001P1=02h00`000000MAHo07DF?`04000000T0PRmJ00<0000009]4
G`2KA5l03`2KA5l00`000000[eEO0:mEG`0@0:mEG`0300000031He/0`F=K00/0`F=K100000040<]I
<0030000003;FC00000000<0000000@0_3H000000000000000008`3oool00`000000oooo0?ooo`0O
0?ooo`00903oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0280oooo1P00000704d0
;P@000003@22;eX00`000000VdAO09]4G`0609]4Ga<000002@2_EEl00`000000`F=K0<5SF`0=0<5S
F`040000003BKe000000000000<0beT`00@000000<]I<03;FC00beT`0P000000102l=P0000000000
0000000S0?ooo`030000003oool0oooo01h0oooo000S0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0803oool5000000L0C@0^0P0000000`1Q4Dl00000088_FP0<088_FP/000002@2Q
EG800`000000/fAb0;=TLP070;=TLP`000003@31He/010000000dVm@0=9_D03BKe02000000030<]I
<0000000beT`00<0beT`00@000000=EM4@000000_3H00P00000R0?ooo`030000003oool0oooo01h0
oooo000S0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool07@3oool6000000H0C@0^
0P000003064AC`0300000022;eX0PRmJ00L0PRmJ1000000208]2K`030000002QEG80XEEb00l0XEEb
00<000000;=TLP2cI780402cI7800`000000a75_0<AaK`04000000T0`F=K00<000000=9_D03BKe00
0`3BKe03000000@0beT`00@000000=EM4@000000_3H00P00000R0?ooo`030000003oool0oooo01d0
oooo000S0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06`3oool40000000300h0
3P000000C@0^00<0C@0^0`000004064AC`0300000022;eX0PRmJ00@0PRmJ1000000608]2K`030000
002QEG80XEEb00l0XEEb00<000000;=TLP2cI780402cI7800`000000a75_0<AaK`040<AaK`@00000
1P31He/00`000000dVm@0=9_D0030=9_D0040000003BKe00000000000080beT`00D000000=EM4@3E
GA4000000;`f000200000280oooo00<000000?ooo`3oool0703oool002<0oooo0P00000J0?ooo`03
0000003oool0oooo01T0oooo1000000200h03P030000001=02h0C@0^008000001`1Q4Dl00`000000
PRmJ088_FP04000000X0Rd9_00<000000:5ELP2QEG803`2QEG800`000000/fAb0;=TLP0@0;=TLP03
00000034LFl0a75_00P0a75_100000020<5SF`030000003BKe00dVm@00<0dVm@00@000000=9_D03B
Ke00dVm@0P000000103;FC0000000=EM4@3EGA42000000030;`f00000000oooo0200oooo00<00000
0?ooo`3oool0703oool002<0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0G0?oo
o`@000000P0>00h010000000C@0^000000000008064AC`@000003@2;@Vl00`000000XEEb0:5ELP0@
0:5ELP030000002cI780/fAb0100/fAb00<000000<AaK`34LFl03034LFl4000000@0dVm@00<00000
0=9_D03BKe000`3BKe02000000@0eEdA00<000000;`f000000008@3oool00`000000oooo0?ooo`0K
0?ooo`008`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01D0oooo0`00000400h0
3P800000201Q4Dl20000000306hZJ0000000Rd9_00h0Rd9_00<000000:5ELP2QEG801`2QEG8C0000
00T0/fAb00<000000<AaK`34LFl03P34LFl010000000eGiX0000000000020=9_D0030000003BKe00
dVm@00@0dVm@0`0000030=EM4@<00000803oool00`000000oooo0?ooo`0K0?ooo`008P3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo01<0oooo0`00000300h03P<000001P1Q4Dl30000
00<0KRYX00<0000008]2K`2;@Vl02`2;@Vl<000000T0YF6100<000000;I_P@2fKh401`2fKh4<0000
00h0a75_00@000000=EnJ03EOVP0eGiX0`0000070=9_D0030000003QN3`0000000<0eEdA0`00000P
0?ooo`030000003oool0oooo01X0oooo000R0?ooo`030000003oool0oooo01h0oooo00<000000?oo
o`3oool04@3oool3000000<03P0>00<0000002d0>@0000001@1Q4Dl2000000H0KRYX00<0000008]2
K`2;@Vl01`2;@Vl400000080TU5o00<000000:EQP@2UHH40402UHH400`000000]Vn10;I_P@0@0;I_
P@0300000036O7l0aWao00@000002P34LFl00`000000eGiX0=EnJ0030=EnJ0<000001@3BKe000`00
0000hGPl0>5h?002000000<0eEdA00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0I0?oo
o`008P3oool200000200oooo00<000000?ooo`3oool0403oool0100000003P0>00h03P0>00h20000
0080;@0i00<00000064AC`1Q4Dl00`00000706hZJ0030000002;@Vl0Rd9_00@0Rd9_10000006099A
O`030000002UHH40YF610100YF6100<000000;I_P@2fKh40402fKh400`000000aWao0<IlO`040<Il
O`D000001P34LFl00`000000eGiX0=EnJ0020=EnJ0030000003EOVP0eGiX00<000000P3BKe000`00
0000hGPl0>5h?0020>5h?0050000003EGA40eEdA0=EM4@000000803oool00`000000oooo0?ooo`0I
0?ooo`008P3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00h0oooo00D0000000h0
3P0>00h03P0>0000000302d0>@040000001Q4Dl00000000000X0KRYX00<0000008]2K`2;@Vl01000
000:099AO`030000002UHH40YF610100YF6100<000000;I_P@2fKh40402fKh400`000000aWao0<Il
O`090<IlO`@000000P34LFl00`000000eGiX0=EnJ0020=EnJ0030000003EOVP0eGiX00<0eGiX0P00
00000`3BKe0000000>5h?0030>5h?080000000<0eEdA000000000000803oool00`000000oooo0?oo
o`0H0?ooo`003P3oool2000000@0oooo00<000000?ooo`3oool00P3oool3000000H0oooo00<00000
0?ooo`3oool08@3oool00`000000oooo0?ooo`0<0?ooo`80000000<03P0>000000000000100]03T2
000000/0KRYX1000000>099AO`030000002UHH40YF610100YF6100<000000;I_P@2fKh40402fKh40
0`000000aWao0<IlO`0=0<IlO`@000000`3EOVP00`000000eGiX0=EnJ0050=EnJ08000001P3QN3`0
10000000eEdA00000000000O0?ooo`030000003oool0oooo01P0oooo000=0?ooo`040000003oool0
oooo000000/0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0R0?ooo`030000003o
ool0oooo00X0oooo0P0000000`0>00h0000002d0>@0302d0>@<000002P1^:VP20000000307TmNP00
0000TU5o00l0TU5o00<000000:EQP@2UHH40402UHH400`000000]Vn10;I_P@0@0;I_P@0300000036
O7l0aWao00l0aWao00H000000=J9N`00000000000=EnJ00000080=EnJ0<000001@3QN3`200000003
0<QA00000000oooo01h0oooo00<000000?ooo`3oool05`3oool000d0oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool0203oool4000000@0;@0i00@0000004@6F@141UT00000201^:VP2000000<0NCej00<00000099A
O`2BDGl03P2BDGl00`000000YF610:EQP@070:EQPA<000002@2fKh400`000000aWao0<IlO`0?0<Il
O`040000003FRG/0eXUk0=J9N`<000001`3EOVP010000000iXYK0>J:F`0000060>5h?0<000007`3o
ool00`000000oooo0?ooo`0F0?ooo`001`3oool400000080oooo00@000000?ooo`3oool00000203o
ool3000000D0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`060?ooo`<000001@0]
03T01@000000A0II04@6F@141UT0000000H0KRYX0P00000507TmNP030000002BDGl0TU5o00d0TU5o
2`0000090:Q/S@030000002hNHd0^7V=00L0^7V=3000000?0<IlO`030000003FRG/0eXUk0080eXUk
00@000000=J9N`00000000001@3EOVP010000000iXYK0>J:F`3VRU/2000000@0hGPl1000000N0?oo
o`030000003oool0oooo01H0oooo000=0?ooo`040000003oool0oooo000000P0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00@0oooo1000000302d0
>@8000000`141UT00`000000KRYX06hZJ00306hZJ08000001`1i?GX00`000000TU5o099AO`09099A
O`@0000000<0UUf<0000002XK8d04@2XK8d00`000000^7V=0;QiS@0@0;QiS@0300000037QH`0ahF<
00@000002`36O7l00`000000eXUk0=J9N`020=J9N`040000003FRG/0eXUk0=J9N`<000000`3EOVP0
0`000000iXYK0>J:F`020>J:F`030000003QN3`0hGPl0080hGPl0`00000O0?ooo`030000003oool0
oooo01D0oooo000=0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool2
000002P0oooo00<000000?ooo`3oool00`3oool3000000<0;@0i00<0000004@6F@141UT00`141UT0
10000000KRYX06hZJ01^:VP2000000T0NCej00<00000099AO`2BDGl01P2BDGl3000000D0UUf<00<0
00000:Q/S@2XK8d0402XK8d00`000000^7V=0;QiS@0@0;QiS@0300000037QH`0ahF<00@0ahF<1@00
00060<IlO`030000003FRG/0eXUk0080eXUk00<000000=J9N`3FRG/0103FRG/2000000030=EnJ000
0000iXYK00@0iXYK0P0000020>5h?0040000003SN1800000000001l0oooo00<000000?ooo`3oool0
503oool000h0oooo0P0000090?ooo`@00000103oool00`000000oooo0?ooo`0X0?ooo`040000003o
ool0oooo0?ooo`80000000D0000=0000000]03T0;@0i0000000604@6F@040000001^:VP000000000
00/0NCej00<00000099AO`2BDGl00`2BDGl3000000P0UUf<00<000000:Q/S@2XK8d0402XK8d00`00
0000^7V=0;QiS@0@0;QiS@0300000037QH`0ahF<00T0ahF<100000020<IlO`030000003FRG/0eXUk
0080eXUk00<000000=J9N`3FRG/01P3FRG/2000000L0iXYK00<000000>5h?00000000P3SN1820000
01h0oooo00<000000?ooo`3oool0503oool00240oooo00<000000?ooo`3oool0:@3oool010000000
oooo00000000000200003@<000001`141UT2000000d0NCej00<00000099AO`0000000`00000;09IM
S0030000002XK8d0Z6b=0100Z6b=00<000000;QiS@2hNHd0402hNHd00`000000ahF<0<N5S00=0<N5
S0@00000103FRG/00`000000eXUk0=J9N`060=J9N`<000001P3VRU/3000000040>=h4P000000b540
000001h0oooo00<000000?ooo`3oool04`3oool00240oooo00<000000?ooo`3oool0:P3oool30000
000300003@000000000000L0A0II0`00000=07TmNP<000003`2FGH`00`000000Z6b=0:Q/S@0@0:Q/
S@030000002hNHd0^7V=0100^7V=00<000000<N5S037QH`03`37QH`010000000eY:9000000000002
0=J9N`030000003FRG/0eXUk00H0eXUk00<000000>NHLP3WV7800P0000060>J:F`030000003SN180
hgPB008000007P3oool00`000000oooo0?ooo`0C0?ooo`00803oool00`000000oooo0?ooo`0[0?oo
o`8000000P0000d00`000000A0II04@6F@0504@6F@040000001D8740E21a000000X0NCej0`000000
0`20C8T0000009IMS00?09IMS0030000002XK8d0Z6b=0100Z6b=00<000000;QiS@2hNHd0402hNHd0
0`000000ahF<0<N5S00?0<N5S0040000003FTXT0eY:90=JBR@<00000203FRG/00`000000iiQb0>NH
LP020>NHLP030000003VRU/0iXYK00<0iXYK0P0000020>=h4P8000007@3oool2000001@0oooo000P
0?ooo`030000003oool0oooo02X0oooo0P00000200003@8000001@141UT2000000<0E21a00<00000
07TmNP1i?GX01P1i?GX2000000@0P4b900<0000009IMS02FGH`03P2FGH`00`000000Z6b=0:Q/S@07
0:Q/SA<000002@2hNHd00`000000ahF<0<N5S00?0<N5S0030000003FTXT0eY:900<0eY:910000006
0=J9N`030000003WV780iiQb0080iiQb0P0000040>J:F`8000000P3SN1800`000000oooo0?ooo`0H
0?ooo`<0000000<0oooo0000003oool04`3oool00200oooo0P00000[0?ooo`060000000000d0000=
0000000003/0000010141UT00`000000E21a05@PL@0205@PL@030000001i?GX0NCej00@0NCej0`00
0006081<R@030000002FGH`0UUf<00`0UUf<300000090:]dU`030000002iPIL0^H6G00L0^H6G3000
000?0<N5S0030000003FTXT0eY:900<0eY:900@000000=JBR@3FTXT0eY:90P0000040=J9N`030000
003WV780iiQb00@0iiQb00L000000>J:F`3VRU/0iXYK0000003aTch000000080hgPB00<000000?oo
o`3oool0503oool3000000@0oooo00<000000?ooo`3oool04P3oool00200oooo00<000000?ooo`3o
ool0:@3oool010000000000=00003@0000020000>`03000000141UT0A0II008000001@1D87401000
0000NCej07TmNP1i?GX3000000T0P4b900<0000009IMS02FGH`0202FGH`400000080VVRF00<00000
0:]dU`2[M9L0402[M9L00`000000^H6G0;V1U`0@0;V1U`0300000037S9H0ahbF00@000002`37QH`0
0`000000eY:90=JBR@030=JBR@030000003FTXT0eY:900<0eY:90`0000000`3FRG/000000>NHLP06
0>NHLP80000000L0iXYK0000003aTch0lI<n0000003SN180000001<0oooo0`0000070?ooo`030000
003oool0oooo0180oooo000P0?ooo`030000003oool0oooo02T0oooo00<0000000003@0000000P00
03/010000000A0II04@6F@00000705@PL@040000001i?GX00000000000`0P4b900<0000009IMS02F
GH`0102FGH`4000000H0VVRF00<000000:]dU`2[M9L0402[M9L;000000P0^H6G00<000000<N<UP37
S9H01037S9H5000000H0ahF<00<000000=JBR@3FTXT00`3FTXT00`000000eY:90=JBR@060=JBR@80
00002@3WV78300000080lI<n00<000000>=h4P0000003`3oool3000000/0oooo00<000000?ooo`3o
ool04@3oool00200oooo00<000000?ooo`3oool0:03oool010000000000=00003@0000020000>`<0
0000201D8742000000h0P4b900<0000009IMS02FGH`01000000:09YXUP030000002[M9L0ZgBG0100
ZgBG3`0000040;V1U`0300000037S9H0ahbF00T0ahbF100000020<N5S0030000003FTXT0eY:900<0
eY:900<000000=JBR@3FTXT01`3FTXT3000000T0iiQb00@000000?6C?P3aTch0lI<n0P00000<0?oo
o`<000003P3oool00`000000oooo0?ooo`0A0?ooo`007`3oool00`000000oooo0?ooo`0Y0?ooo`03
0000000000d0000000<0000k00<0000005@PL@1D87401P1D8743000000h0P4b91000000>09YXUP03
0000002[M9L0ZgBG0100ZgBG00<000000;V1U`2iPIL0202iPIL7000000030;V1U`000000ahbF00h0
ahbF100000040=JBR@030000003FTXT0eY:900L0eY:900@000000>JQQ03VXH@00000203WV7820000
00<0lI<n0P0000080?ooo`<000004@3oool00`000000oooo0?ooo`0A0?ooo`007`3oool00`000000
oooo0?ooo`0X0?ooo`<000000`0003/2000000L0E21a00@00000064dQ01Q=8@000003020C8T20000
000308IIU@000000VVRF0100VVRF00<000000:]dU`2[M9L03`2[M9L00`000000^H6G0;V1U`0<0;V1
Ua8000001037S9H010000000eIVE0000000000020=JBR@030000003FTXT0eY:900L0eY:900@00000
0>JQQ03VXH@0iZ640P0000060>NHLP030000003fYF00000000<0lI<n00<000000?ooo`3oool00`3o
ool3000001@0oooo00<000000?ooo`3oool04@3oool001l0oooo0P00000Y0?ooo`8000000`0003/0
0`0000006`1M0000000505@PL@8000000`1Q=8@00`000000P4b9081<R@08081<R@8000000`26FID0
0`000000VVRF09YXUP0?09YXUP030000002[M9L0ZgBG00l0ZgBG00<000000;V1U`2iPIL02P2iPILI
000000<0eIVE0`0000090=JBR@030000003VXH@0iZ6400<0iZ6400<000000>NHLP3WV7800`3WV780
0`000000mZEP000000040?6C?P030000003oool00000008000005`3oool00`000000oooo0?ooo`0A
0?ooo`007`3oool00`000000oooo0?ooo`0X0?ooo`050000000003/0000k0000>`0000000P0K05d0
0`000000E21a05@PL@0205@PL@030000001Q=8@0HCB400<0HCB400<00000081<R@20C8T01@20C8T3
000000D0QUVE00<0000009YXUP2JJ9H03`2JJ9H00`000000ZgBG0:]dU`0?0:]dU`030000002iPIL0
^H6G00L0^H6G3P0000090<N<UPP000000P3EVID3000000H0eY:900<000000>JQQ03VXH@01@3VXH@2
000000<0iiQb00@000000?JUH03fYF0000000`3aTch2000001X0oooo00<000000?ooo`3oool04@3o
ool001l0oooo00<000000?ooo`3oool09`3oool200000080000k00@0000001/0G@0K05d000000`1D
8742000000H0HCB400<00000081<R@20C8T00`20C8T2000000P0QUVE00<0000009YXUP2JJ9H03`2J
J9H00`000000ZgBG0:]dU`060:]dUaL000001@2iPIL010000000ahbF0<N<UP37S9H4000000X0ahbF
1`0000020=FIU@<000000`3FTXT00`000000iZ640>JQQ0070>JQQ0040000003WV780iiQb000000<0
mZEP00<000000?6C?P3aTch00P00000J0?ooo`030000003oool0oooo0140oooo000O0?ooo`030000
003oool0oooo02L0oooo00D000000000>`0003/0000k0000000201/0G@040000001D8740E21a0000
00P0HCB400@00000081<R@20C8T0P4b90P00000:08IIU@030000002JJ9H0VVRF00d0VVRF2`000009
0:alW`030000002jQil0^XNO00<0^XNO400000020<N<UP@000002037S9H010000000eIVE0=FIU@3E
VID4000000D0eIVE0P0000000`3FTXT000000>JQQ0090>JQQ0<00000103fYF0010000000lI<n0000
003MR0DK0?ooo`030000003oool0oooo0100oooo000N0?ooo`030000003oool0oooo02L0oooo0P00
00020000>`040000000K05d06`1M01/0G@<000002@1Q=8@010000000P4b900000000000<08IIU@03
0000002JJ9H0VVRF00T0VVRF1000000209eaW`030000002/O9l0[7bO00l0[7bO00@000000;Z7W`2j
Qil0^XNO1@00000:0;Z7W`0300000036Til0aY>O00L000001`37S9H00`000000eIVE0=FIU@040=FI
U@@00000103EVID2000000`0iZ6400<000000?JUH03fYF000`3fYF0010000000lI<n00000000000J
0?ooo`030000003oool0oooo0100oooo000N0?ooo`030000003oool0oooo02L0oooo0P0000000`00
03/0000001/0G@0301/0G@030000001Q=8@0HCB400T0HCB40P00000408IIUA00000000<0VVRF0000
000000000`00000609eaW`030000002/O9l0[7bO00l0[7bO00<000000;Z7W`0000001000000<0;Z7
W`0300000036Til0aY>O00H0aY>O1P0000020<N<UP030000003EVID0eIVE00@0eIVE1@0000040=FI
U@<000002P3VXH@2000000@0mZEP00@000000?6C?P00000000006P3oool00`000000oooo0?ooo`0@
0?ooo`007P3oool2000002P0oooo0`00000401/0G@8000002@1Q=8@300000080QUVE5P00000909ea
W`030000002/O9l0[7bO00l0[7bO1P00000=0;Z7W`0300000036Til0aY>O00L0aY>O0`0000020<JC
W`@000001@3EVID00`000000eIVE0=FIU@0400000080eIVE00<000000>BXT`3TZ9<00P0000080>JQ
Q0030000003f/GT0000000@0mZEP0P0000000`3MR0D000000?ooo`0H0?ooo`030000003oool0oooo
0100oooo000N0?ooo`030000003oool0oooo02H0oooo0`00000401/0G@030000000a4GP0000000P0
HCB400<0000006]6TP1[AY801`00000808IIU@@000000P2MLIl7000000H0WG6O00<000000:alW`2/
O9l03P2/O9l5000000l0^XNO00<000000<JCW`36Til02036Til3000000<0aY>O00@000000=BOW`00
000000000`3EVID00`000000eIVE0=FIU@020=FIU@<0000000<0eIVE0000003TZ9<00`3TZ9<00`00
0000iZ640>JQQ0050>JQQ0040000003f/GT0m[5i000000@0mZEP00<000000=f81@0000006@3oool0
0`000000oooo0?ooo`0@0?ooo`007P3oool00`000000oooo0?ooo`0V0?ooo`8000001@0K05d00`00
0000<A5h00000006064dQ080000000<0JdJB0000000000001000000908IIU@80000000<0RfBO0000
002MLIl01`2MLIl5000000@0WG6O00<000000:alW`2/O9l03@2/O9l5000000l0^XNO00<000000<JC
W`36Til02P36Til300000080aY>O00@000000=BOW`3DWil0e9nO0`0000000`3EVID000000=FIU@03
0=FIU@@000001@3TZ9<2000000D0iZ6400D000000?JaN@3f/GT0m[5i000000030?JUH0040000003M
R0D0gHP5000001P0oooo00<000000?ooo`3oool0403oool001h0oooo00<000000?ooo`3oool09@3o
ool3000000@06`1M00@00000034AN00a4GP000001@1Q=8@00`000000JdJB06]6TP04000000T0QUVE
0`00000308]TW`030000002MLIl0WG6O00P0WG6O1@00000209eaW`030000002/O9l0[7bO00`0[7bO
1000000A0;Z7W`0300000036Til0aY>O00/0aY>O0`0000000`36Til000000=BOW`050=BOW`<00000
1@3EVID2000000L0i:RC00<000000>JQQ03VXH@00P3VXH@01@000000m[5i0?JaN@3f/GT0000000<0
mZEP0P0000000`3MR0D000000?ooo`0G0?ooo`030000003oool0oooo0100oooo000M0?ooo`030000
003oool0oooo02H0oooo0`00000301/0G@050000000a4GP0<A5h034AN00000000`1Q=8@200000003
06]6TP0000000000008000000P1[AY800`000000QUVE08IIU@0408IIU@8000001P2;I9l00`000000
WG6O09eaW`0;09eaW`<0000000<0WG6O0000002/O9l0302/O9l500000140^XNO00<000000<JCW`36
Til03036Til4000000L0e9nO00@000000=BOW`0000000000103EVID2000000L0i:RC0P0000020>JQ
Q0030000003f/GT0m[5i0080m[5i00D000000?JUH03fYF0000000?>X=`020=f81@030000003oool0
oooo01D0oooo00<000000?ooo`3oool0403oool001d0oooo00<000000?ooo`3oool09@3oool40000
00806`1M00<00000034AN00a4GP00P0a4GP01@000000HCB4064dQ0000000JdJB00D000000`1[AY80
10000000QUVE08IIU@26FID3000000P0RfBO00<0000009eaW`2MLIl0302MLIl4000000P0[7bO4P00
00090;Z7W`0300000036Til0aY>O00d0aY>O0`0000070=BOW`040000003DWil0e9nO0=BOW`<00000
00@0eIVE0000000000000000203TZ9<3000000D0m[5i00<000000?JUH03fYF000P0000000`3MR0D0
00000?ooo`0G0?ooo`030000003oool0oooo00l0oooo000M0?ooo`8000009P3oool2000000040000
<@0000006`1M000000D0<A5h0`0000000`1[AY80000000000002000000D0JdJB00@0000008IIU@00
00000000302;I9l00`000000WG6O09eaW`0<09eaW`/000000`2]PjL400000080[H>W00<000000;Z=
Y`2jSJL01P2jSJL<000000h0aY>O0P0000070=BOW`030000003DWil0e9nO00@0e9nO0P0000000`3T
Z9<00000000000090>BXT`030000003f/GT0m[5i00@0m[5i00H000000?JUH000000000000=f81@00
000H0?ooo`030000003oool0oooo00l0oooo000M0?ooo`030000003oool0oooo02D0oooo0P000000
10000340000001/0G@000005034AN0030000001[AY80JdJB00@000001P1[AY82000000h0RfBO00<0
000009eaW`2MLIl0202MLIl400000080WgVX0`0000090:f3Y`<000000`2]PjL00`000000^XfW0;Z=
Y`0?0;Z=Y`0300000036V:P0aYRX00H000002036Til3000000H0e9nO00<000000=BOW`3DWil01@3D
Wil5000000P0i:RC0P0000060?JaN@80000000<0ljPg000000000000603oool00`000000oooo0?oo
o`0?0?ooo`005@3oool2000000H0oooo00<000000?ooo`3oool09@3oool2000000030000<@000000
000000D0<A5h0P0000000`1[AY80000000000002000000D0JdJB0`00000?08]TW`030000002MLIl0
WG6O00@0WG6O1000000609miZ0@000001`2]PjL3000000@0[H>W00<000000;Z=Y`2jSJL03`2jSJL0
0`000000aYRX0<JHZ0060<JHZ0H000000P36Til010000000e9nO0000000000050=BOW`030000003D
Wil0e9nO00D0e9nO00<000000>:^W`3R[Yl00`0000070>BXT`030000003d^Xd0000000H0m[5i00D0
00000?>X=`000000gHP50000000G0?ooo`030000003oool0oooo00l0oooo000D0?ooo`040000003o
ool0oooo000000D0oooo00<000000?ooo`3oool0903oool200000080000a00<00000034AN00a4GP0
0`0a4GP00`000000@bV<00000004000000D0JdJB00@0000007=DW`1cE9l000003`2;I9l00`000000
WG6O09eaW`04000000X0WgVX00<000000:f3Y`0000000P0000050:f3Y`<000001@2]PjL00`000000
^XfW0;Z=Y`0?0;Z=Y`0300000036V:P0aYRX00`0aYRX1P0000050=BOW`030000003DWil0e9nO00@0
e9nO00<000000>:^W`3R[Yl00P3R[Yl3000000H0i:RC00@000000?BjS@3d^Xd000001@3f/GT00`00
0000ljPg0?>X=`02000001L0oooo00<000000?ooo`3oool03`3oool001@0oooo00@000000?ooo`3o
ool00000103oool00`000000oooo0?ooo`0U0?ooo`8000000P0003400`000000<A5h034AN002034A
N00300000013:H`0@bV<00@00000101[AY82000000@0LeBO00<0000008]TW`2;I9l02`2;I9l40000
00h0WgVX00<000000:f3Y`2]PjL00`0000040:f3Y`<000001@2]PjL00`000000^XfW0;Z=Y`0?0;Z=
Y`0300000036V:P0aYRX00h0aYRX00<000000=:TZ00000000P0000040=BOW`030000003DWil0e9nO
00@0e9nO00<000000>:^W`3R[Yl00`3R[Yl2000000H0i:RC00D000000?BjS@3d^Xd0m;Z=00000004
0?JaN@80000000<0ljPg0000000000005`3oool00`000000oooo0?ooo`0?0?ooo`00503oool01000
0000oooo0?ooo`0000040?ooo`030000003oool0oooo02D0oooo00<000000000<@0003400P000003
034AN00400000013:H`0@bV<04<YS0<00000101[AY800`000000LeBO07=DW`0407=DW`030000002;
I9l0RfBO00P0RfBO0`0000000`2?KZP0000009miZ00?09miZ0040000002]PjL0[H>W0:f3Y`800000
0`2]PjL3000000H0[H>W00<000000;Z=Y`2jSJL03`2jSJL00`000000aYRX0<JHZ00>0<JHZ0030000
003BY:P0dZBX00@000000P3DWil00`000000e9nO0=BOW`040=BOW`030000003R[Yl0hZjO00<0hZjO
100000030>BXT`030000003d^Xd0m;Z=00<0m;Z=00@000000?JaN@3f/GT0m[5i0P0000020?>X=`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool03`3oool001@0oooo00@000000?ooo`3oool0
0000103oool00`000000oooo0?ooo`0U0?ooo`03000000000340000a008000000`0a4GP00`000000
@bV<04<YS003000000<0JdJB0P00000707=DW`030000002;I9l0RfBO00D0RfBO0`00000408m^Z003
0000002ONJP0WgVX00l0WgVX00@000000:f3Y`2]PjL0[H>W0P0000020:f3Y`<000001P2]PjL00`00
0000^XfW0;Z=Y`0?0;Z=Y`0300000036V:P0aYRX00h0aYRX00@000000=:TZ03BY:P0dZBX0P000000
103BY:P000000000000000060=BOW`030000003R[Yl0hZjO0080hZjO2`0000040?BjS@080000003f
/GT0m[5i0000003m_Ul000000?>X=`00000H0?ooo`030000003oool0oooo00h0oooo000D0?ooo`04
0000003oool0oooo000000@0oooo0P00000V0?ooo`0500000000034000000000F`0000000P0a4GP0
0`000000@bV<04<YS00400000080JdJB00<0000007=DW`1cE9l01`1cE9l00`000000RfBO08]TW`03
08]TW`800000202?KZP00`000000WgVX09miZ00>09miZ0040000002]PjL0[H>W0:f3Y`H000001`2]
PjL00`000000^XfW0;Z=Y`0?0;Z=Y`0300000036V:P0aYRX00h0aYRX00@000000=:TZ03BY:P0dZBX
0`0000020=:TZ0<000000`3DWil00`000000hZjO0>:^W`0@000000<0m;Z=00L000000?JaN@000000
oKiO0000003cZ3L0000001P0oooo00<000000?ooo`3oool03P3oool001D0oooo0P0000050?ooo`03
0000003oool0oooo02D0oooo00L000000000<@000000001K0000000a4GP0000000<0@bV<0P000000
1013:H`0000000000000000;07=DW`030000002;I9l00000008000002P2?KZP00`000000WgVX09mi
Z00>09miZ0030000002]PjL0[H>W0080[H>W100000040:f3Y`d000002@2jSJL00`000000aYRX0<JH
Z00>0<JHZ0030000003BY:P0dZBX0080dZBX0P0000020=:TZ0030000003BY:P0dZBX0080000000<0
e9nO0000000000001@0000020>:^W`<000000P3R[Yl00`000000m;Z=0000000400000080m;Z=0P00
00020?fnG`800000603oool00`000000oooo0?ooo`0>0?ooo`00703oool00`000000oooo0?ooo`0U
0?ooo`8000000P0005/2000000<0@bV<0`0000000`13:H`0000007=DW`0<07=DW`8000003@2?KZP0
0`000000WgVX09miZ00>09miZ0030000002]PjL0[H>W0080[H>W200000040:j9[`030000002jTjl0
^Y>_00H0^Y>_2`00000>0<JHZ0030000003BY:P0dZBX00<0dZBX0P0000020=:TZ0030000003BY:P0
dZBX0080dZBX1P0000050>:^W`8000000P3R[Yl2000000<0m;Z=0`0000020?BjS@060000003m_Ul0
oKiO0000003cZ3L000005`3oool00`000000oooo0?ooo`0>0?ooo`00703oool00`000000oooo0?oo
o`0T0?ooo`0300000000034000000080001K00<0000004<YS013:H`00P13:H`20000000304<YS000
0000000000/0LeBO0`00000>08m^Z0030000002ONJP0WgVX00`0WgVX1`000000102^RJl000000000
000000080:j9[`030000002jTjl0^Y>_00l0^Y>_00<000000<FM[`0000000`00000:0<JHZ0030000
003BY:P0dZBX00<0dZBX0`0000000`3BY:P000000=:TZ0020=:TZ0D000001`3R[Yl200000080hZjO
00<000000?6oW0000000103d^Xd4000000<0oKiO0P00000G0?ooo`030000003oool0oooo00h0oooo
000K0?ooo`030000003oool0oooo02D0oooo0P0000030000F`0400000013:H`0@bV<04<YS0@00000
00<0DCjL0000001cE9l02@1cE9l010000000NV2Y07YPZ@00000?08m^Z0030000002ONJP0WgVX00D0
WgVX1P0000020:60[`030000002^RJl0[XV_00<0[XV_0`0000080:j9[`030000002jTjl0^Y>_00l0
^Y>_00<000000<FM[`35WJl00`35WJl4000000H0aYRX00<000000=:TZ03BY:P0103BY:P200000004
0=:TZ0000000dZBX0=:TZ0@000000P3O/ZT2000000H0hZjO0`0000030?6oW0030000003d^Xd0m;Z=
0080m;Z=100000020?fnG`8000005`3oool00`000000oooo0?ooo`0>0?ooo`006`3oool00`000000
oooo0?ooo`0U0?ooo`8000000P0005/2000000<0@bV<0`000003054nW0030000001cE9l0LeBO00D0
LeBO0P00000407YPZ@030000002?KZP0SfjX00`0SfjX00<0000009miZ02ONJP01@0000080:60[`03
0000002^RJl0[XV_00<0[XV_0P0000090:j9[`030000002jTjl0^Y>_00l0^Y>_00<000000<FM[`35
WJl01`35WJl400000080aYRX00<000000=:TZ03BY:P0103BY:P2000000030=:TZ0000000dZBX00@0
00001@3O/ZT00`000000hZjO0>:^W`030>:^W`<00000103a_i`00`000000m;Z=0?BjS@020?BjS@<0
00000`3m_Ul00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00h0oooo000K0?ooo`030000
003oool0oooo02D0oooo00@000000000F`0005/0001K0P00000204<YS0<00000101A?Y`00`000000
LeBO07=DW`0407=DW`030000001jH:T0NV2Y00@0NV2Y00<0000008m^Z02?KZP02`2?KZP4000000d0
XH2_00<000000:j9[`2^RJl0102^RJl00`000000[XV_0:j9[`070:j9[`030000002jTjl0^Y>_00l0
^Y>_00<000000<FM[`35WJl02`35WJl4000000D0dZBX0P0000000`3BY:P000000000000200000003
0=:TZ0000000gk:Y00D0gk:Y0P0000030>:^W`<000001@3a_i`00`000000m;Z=0?BjS@020?BjS@<0
00000P3m_Ul00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00d0oooo000K0?ooo`800000
9P3oool01P000000001K0000F`0000000@1k00000080@bV<0`000004054nW0030000001cE9l0LeBO
0080LeBO0P00000707YPZ@030000002?KZP0SfjX00P0SfjX0`0000000`2BM[0000000:60[`0>0:60
[`030000002^RJl0[XV_00h0[XV_00<000000;ZC[`2jTjl03`2jTjl00`000000aIf_0<FM[`0=0<FM
[`030000003@ZK000000008000000P3BY:P600000080dZBX00<000000=nbZ@3O/ZT01P3O/ZT20000
0080hZjO0P0000060?6oW0030000003d^Xd0m;Z=00@000000P3m_Ul00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo00d0oooo000K0?ooo`030000003oool0oooo02D0oooo00@000000000F`00
05/000000P0107/4000000D0DCjL00D0000007=DW`1cE9l0LeBO0000000907YPZ@030000002?KZP0
SfjX00D0SfjX0`000004099f/0030000002QP:l0XH2_00h0XH2_00<000000:j9[`2^RJl03@2^RJl0
0`000000^Y>_0;ZC[`0>0;ZC[`0300000035WJl0aIf_00h0aIf_00<000000=2Y/03@ZK000P3@ZK02
000000030=:TZ0000000000000<000000P3BY:P00`000000gk:Y0=nbZ@080=nbZ@@000001`3a_i`0
10000000m;Z=0000003obgd3000000030?fnG`000000oooo01L0oooo00<000000?ooo`3oool03@3o
ool001/0oooo00<000000?ooo`3oool09@3oool00`000000001K000000030040N`@000001P1A?Y`3
000000/0NV2Y00<0000008m^Z02?KZP00P2?KZP2000000P0TWJ`00<000000:60[`2QP:l03@2QP:l0
0`000000[XV_0:j9[`0=0:j9[`030000002jTjl0^Y>_00h0^Y>_00<000000<FM[`35WJl03@35WJl0
0`000000d:V`0=2Y/0050=2Y/0D000000P3BY:P00`000000gk:Y0=nbZ@0;0=nbZ@<000001`3a_i`2
000000060?o;O@00000000000000003m_Ul00000603oool00`000000oooo0?ooo`0=0?ooo`006P3o
ool00`000000oooo0?ooo`0V0?ooo`030000000005/0000000<00@1k0`000007054nW0030000001j
H:T0NV2Y00/0NV2Y00<0000008m^Z00000000P00000:099f/0030000002QP:l0XH2_00d0XH2_00<0
00000:j9[`2^RJl03@2^RJl00`000000^Y>_0;ZC[`0>0;ZC[`0300000035WJl0aIf_00d0aIf_00<0
00000=2Y/03@ZK001P3@ZK05000000030=:TZ0000000gk:Y00`0gk:Y0`0000080?6oW0030000003o
bgd0ol]m00@00000603oool00`000000oooo0?ooo`0=0?ooo`006P3oool00`000000oooo0?ooo`0V
0?ooo`800000100107/3000000H0DCjL0P00000=07YPZ@8000003@2BM[000`000000XH2_0:60[`0=
0:60[`030000002^RJl0[XV_00D0[XV_4@0000080;ZC[`0300000035WJl0aIf_00d0aIf_00<00000
0=2Y/03@ZK001@3@ZK03000000030=2Y/0000000d:V`00800000303O/ZT010000000kLBY00000000
00080?6oW0030000003obgd0ol]m00D000005`3oool00`000000oooo0?ooo`0=0?ooo`006P3oool0
0`000000oooo0?ooo`0U0?ooo`<000000`0107/4000000D0DCjL00@0000005e?Z@1MCjT000002P1j
H:T3000000h0TWJ`00<000000:60[`2QP:l02`2QP:l:000000P0[hnf00<000000;VH]P2iV;H01P2i
V;H;000000d0aIf_00<000000=2Y/03@ZK001P3@ZK02000000040=2Y/0000000d:V`0=2Y/0<00000
2P3O/ZT00`000000kLBY00000002000000L0lKnL0P0000000`3obgd0000000000003000001L0oooo
00<000000?ooo`3oool03@3oool001X0oooo0P00000V0?ooo`800000100107/3000000D0DCjL00D0
000005e?Z@1MCjT0GDnY0000000907YPZ@0500000020K;80P6bb081//P0000003P2BM[000`000000
XH2_0:60[`050:60[`D000000P2SQkH00`000000[hnf0:n?]P0=0:n?]P030000002iV;H0^IRf00h0
^IRf00<000000<BR]P34X[H01@0000070<FM[`030000003@ZK00d:V`00X0d:V`00<000000=2Y/000
00000`3L][800`000000gk:Y0=nbZ@070=nbZ@060000003]a:T000000000003]a:T000001@3a_i`0
0`000000oM>D000000020?o;O@@000005`3oool00`000000oooo0?ooo`0=0?ooo`006P3oool00`00
0000oooo0?ooo`0U0?ooo`8000000`0107/0100000006a^C000000000004054nW0030000001MCjT0
GDnY0080GDnY00<0000007YPZ@1jH:T01@1jH:T2000000@0P6bb00<00000099f/02BM[00302BM[00
0`000000XH2_0:60[`05000000L0XhNf00<000000:n?]P2_SkH03@2_SkH00`000000^IRf0;VH]P0>
0;VH]P0300000034X[H0a::f00D0a::f1@0000020<FM[`030000003@ZK00d:V`00X0d:V`00<00000
0=2Y/0000000103L][82000000H0gk:Y00<000000>g4Z@3]a:T00P0000020>g4Z@030000003a_i`0
lKnL0080lKnL00D000000?gCU03mdi@000000?o;O@04000001P0oooo00<000000?ooo`3oool0303o
ool001X0oooo00<000000?ooo`3oool09@3oool2000000<00@1k00@0000001/KT`00000000000`1A
?Y`00`000000GDnY05e?Z@0405e?Z@030000001jH:T0NV2Y0080NV2Y0P000006081//P030000002B
M[00TWJ`00/0TWJ`1000000=0:>7]P030000002_SkH0[hnf00`0[hnf00<000000;VH]P2iV;H03@2i
V;H00`000000a::f0<BR]P0;0<BR]P@000002P3@ZK02000000030=2Y/0000000g;Jb00D0g;Jb0P00
00040=nbZ@030000003]a:T0kLBY008000000`3]a:T01@000000lKnL0?6oW03a_i`000000080oM>D
00<000000?o;O@0000000`00000H0?ooo`030000003oool0oooo00`0oooo000I0?ooo`030000003o
ool0oooo02H0oooo0P0000020040N`030000000K6i<06a^C008000000P1A?Y`00`000000GDnY05e?
Z@0505e?Z@050000001jH:T0NV2Y07YPZ@0000002@20K;800`000000TWJ`099f/008099f/0800000
00<0UGjh0000002SQkH03P2SQkH00`000000[hnf0:n?]P0<0:n?]P030000002iV;H0^IRf00d0^IRf
00<000000<BR]P34X[H03@34X[H010000000cZfh0000000000050=2Y/0<000000P3@ZK000`000000
g;Jb0=bf/P070=bf/P050000003O/ZT0gk:Y0=nbZ@0000000P3]a:T2000000@0kLBY00<000000?6o
W00000002@00000H0?ooo`030000003oool0oooo00`0oooo000I0?ooo`030000003oool0oooo02H0
oooo0`000000100107/0000001/KT`0K6i<4000000T0GDnY0`00000:081//P030000002BM[00TWJ`
00D0TWJ`0`00000409En^0030000002SQkH0XhNf00`0XhNf00<000000:n?]P2_SkH0302_SkH00`00
0000^IRf0;VH]P0=0;VH]P0300000034X[H0a::f00`0a::f00<000000<j]^03>[KP00P3>[KP50000
00D0d:V`0P0000090=bf/P<000000`3]a:T2000000@0kLBY3000000H0?ooo`030000003oool0oooo
00`0oooo000I0?ooo`030000003oool0oooo02H0oooo1000000201/KT`@000002P1MCjT00`000000
P6bb081//P0:081//P030000002BM[00TWJ`0080TWJ`0`00000709En^0030000002SQkH0XhNf00`0
XhNf00<000000:n?]P2_SkH0302_SkH00`000000^IRf0;VH]P0=0;VH]P0300000034X[H0a::f00`0
a::f00<000000<j]^03>[KP00`0000020<j]^0<00000103@ZK02000000/0g;Jb00@000000>g4Z@3]
a:T0kLBY0P0000020>g4Z@D000001@3mdi@4000001P0oooo00<000000?ooo`3oool0303oool001T0
oooo00<000000?ooo`3oool09P3oool010000000001>00000000000201/KT`80000000<06a^C0000
001MCjT0201MCjT2000000d0P6bb00@00000099f/000000000002P2EO[P00`000000XhNf0:>7]P0<
0:>7]P030000002_SkH0[hnf00`0[hnf00<000000;VH]P2iV;H03@2iV;H00`000000a::f0<BR]P0<
0<BR]P<00000203>[KP2000000050=2Y/0000000g;Jb0=bf/P0000002P3L][8200000080kLBY0P00
00000`3]a:T0000000000002000000030>g4Z@000000oM>D00@0oM>D1000000H0?ooo`030000003o
ool0oooo00`0oooo000I0?ooo`8000009`3oool00`000000001>0000000301/KT`<0000000<0<3FV
0000001MCjT01P1MCjT010000000Iejd06MN]000000<081//P800000302EO[P00`000000XhNf0:>7
]P0=0:>7]P030000002_SkH0[hnf00/0[hnf00<000000;VH]P2iV;H0302iV;H00`000000a::f0<BR
]P0:0<BR]P@00000303>[KP2000000<0g;Jb00<000000=bf/P3L][801P3L][801@000000j<Nd0>S7
]0000000kLBY00H0000000@0kLBY0000003if:L00000103mdi@4000001P0oooo00<000000?ooo`3o
ool0303oool001T0oooo00<000000?ooo`3oool09P3oool00`000000001>0000000301/KT`<00000
00<0<3FV0000001MCjT01@1MCjT01@000000Iejd06MN]01WG[@0000000X0P6bb0`00000>09En^003
0000002SQkH0XhNf00`0XhNf00<000000:n?]P2_SkH0102_SkH?000000L0^IRf00<000000<BR]P34
X[H01P34X[H400000080a::f00<000000<j]^03>[KP0303>[KP300000080g;Jb00<000000=bf/P3L
][801@3L][8010000000j<Nd0>S7]03Xak@600000080kLBY00<000000?WHY`000000103mdi@40000
01T0oooo00<000000?ooo`3oool02`3oool001P0oooo00<000000?ooo`3oool09`3oool010000000
001>00000000000201/KT`8000000P0`=JH00`000000GDnY05e?Z@0305e?Z@030000001WG[@0Iejd
0080Iejd00<00000081//P20K;801`20K;801@000000QGJj08Ef^P25M[X0000000d0UGjh00<00000
0:>7]P2SQkH02P2SQkH9000000L0[iFl00<000000;VM_02iWK`01@2iWK`:000000<0a::f0`000006
0<BR]P030000003>[KP0cZfh00/0cZfh00@000000=Vi^P3I^KX0fKVj0P0000000`3L][8000000=bf
/P050=bf/P030000003Xak@0j<Nd0080j<Nd100000030>g4Z@040000003if:L0nMRW00000080oM>D
00<000000?OON`0000000P00000I0?ooo`030000003oool0oooo00/0oooo000H0?ooo`030000003o
ool0oooo02L0oooo00@000000000CP00000000000P0K6i<2000000<0<3FV00D0000005e?Z@1MCjT0
GDnY0000000606MN]00300000020K;80P6bb00@0P6bb0P00000408Ef^P030000002EO[P0UGjh00/0
UGjh00<000000:>7]P2SQkH01@2SQkH500000080Y8jm00<000000:nE_02_UK`02`2_UK`00`000000
^Ifl0;VM_00<0;VM_00300000032Y[d0`ZJm00@000002034X[H00`000000cZfh0<j]^00;0<j]^003
0000003I^KX0fKVj00<0fKVj0P0000050=bf/P030000003Xak@0j<Nd00<0j<Nd0`0000030>g4Z@05
0000003if:L0nMRW0?WHY`0000000P3mdi@00`000000mmmk00000002000001T0oooo00<000000?oo
o`3oool02`3oool001P0oooo00<000000?ooo`3oool09`3oool01P000000001>0000000007L00000
01/KT`8000000`0`=JH010000000GDnY05e?Z@00000706MN]00300000020K;80P6bb0080P6bb0P00
000608Ef^P030000002EO[P0UGjh00`0UGjh00<000000:>7]P2SQkH0100000070:B>_@030000002_
UK`0[iFl00/0[iFl00<000000;VM_02iWK`0302iWK`3000000@0`ZJm1@0000020<BR]P030000003>
[KP0cZfh00`0cZfh00<000000=Vi^P3I^KX01@3I^KX2000000<0g;Jb00<000000>S7]03Xak@00P3X
ak@3000000050>S7]0000000kLBY0>g4Z@000000103if:L010000000oM>D0000003ggg/3000001T0
oooo00<000000?ooo`3oool02`3oool001P0oooo00<000000?ooo`3oool0:03oool2000000030000
M`0000006a^C00<000000`0`=JH2000000P0Iejd00D00000081//P20K;80P6bb0000000908Ef^P03
0000002EO[P0UGjh00X0UGjh1000000;0:B>_@030000002_UK`0[iFl00/0[iFl00<000000;VM_02i
WK`0202iWK`5000000/0`ZJm1000000<0<j]^0030000003I^KX0fKVj00L0fKVj100000060>S7]080
00000P3Xak@2000000D0nMRW00@000000?gCU0000000mmmk0`00000I0?ooo`030000003oool0oooo
00/0oooo000H0?ooo`030000003oool0oooo02P0oooo0P0000020000M`040000000`=JH000000000
00<0<3FV00<0000006MN]01WG[@0201WG[@3000000X0QGJj00<0000009En^02EO[P01`2EO[P30000
000309R6_`000000Y8jm00`0Y8jm00<000000:nE_02_UK`02`2_UK`00`000000^Ifl0;VM_0050;VM
_0<00000102iWK`00`000000`ZJm0<:V_@0;0<:V_@030000003</;l00000008000002@3>[KP00`00
0000fKVj0=Vi^P080=Vi^P030000003I^KX0000000/0j<Nd00<000000?WHY`3if:L0103if:L00`00
0000mmmk0?OON`03000001T0oooo00<000000?ooo`3oool02`3oool001P0oooo0P00000Y0?ooo`80
00000P0007L010000000<3FV000000000003030eYP030000001WG[@0Iejd00P0Iejd00<0000008Ef
^P25M[X02P25M[X00`000000UGjh09En^00309En^0@000001@2HQ[l00`000000Y8jm0:B>_@0:0:B>
_@030000002_UK`0[iFl00/0[iFl00<000000;VM_02iWK`00P2iWK`3000000H0^Ifl00<000000<:V
_@32Y[d03032Y[d00`000000c;2o0<b`_`020<b`_`@000001@3>[KP00`000000fKVj0=Vi^P090=Vi
^P<000002@3Xak@2000000H0nMRW00<000000?OON`3ggg/00`00000I0?ooo`030000003oool0oooo
00/0oooo00040?ooo`800000103oool00`000000oooo0?ooo`020?ooo`<000001@3oool00`000000
oooo0?ooo`0Y0?ooo`D0000000<0<3FV0000000000000P0`=JH00`000000@T^e0000000806MN]003
0000001_Jkd0000000`0QGJj00<0000009En^00000000P00000909R6_`030000002TS[d0Y8jm00/0
Y8jm00<000000:nE_02_UK`02P2_UK`00`000000^Ifl00000002000000T0^Ifl00<000000<:V_@32
Y[d02`32Y[d00`000000c;2o0<b`_`070<b`_`<0000000<0cZfh0000003I^KX02`3I^KX200000003
0>?9_@000000j<Nd00L0j<Nd00<000000??J]@0000001@3if:L00`000000mmmk0?OON`02000001/0
oooo00<000000?ooo`3oool02P3oool000<0oooo00@000000?ooo`3oool000002`3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo02T0oooo20000002030eYP0300000012BkD0000000L0
Iejd00@0000006m[_@1_Jkd000003025M[X2000000`0V8Jo00<000000:B>_@2TS[d02`2TS[d00`00
0000[iFl0:nE_0080:nE_0@00000302iWK`00`000000`ZJm0<:V_@0;0<:V_@030000003</;l0c;2o
00X0c;2o0P00000<0=Vi^P8000000P3SbKd00`000000j<Nd0>S7]0040>S7]0040000003cf[D0lmZe
000000@0nMRW0P000000103ggg/0000000000000000K0?ooo`030000003oool0oooo00X0oooo0003
0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0Y0?ooo`80000000<0001g0000000000000`0000000`0`=JH00000049;]@02049;]@030000001W
G[@0Iejd00<0Iejd00<0000006m[_@1_Jkd00P1_Jkd00`000000QGJj08Ef^P0708Ef^P<000003P2H
Q[l00`000000Y8jm0:B>_@0:0:B>_@030000002_UK`0[iFl00D0[iFl0`0000020:nE_0030000002i
WK`0^Ifl00/0^Ifl00<000000<:V_@32Y[d02`32Y[d00`000000c;2o0<b`_`0;0<b`_`<000002@3I
^KX010000000hlVm0>?9_@0000020>?9_@800000103Xak@01@000000lmZe0??J]@3cf[D0000000<0
nMRW0P000000103ggg/0000000000000000K0?ooo`030000003oool0oooo00X0oooo00030?ooo`04
0000003oool0oooo000000P0oooo0`0000050?ooo`030000003oool0oooo02T0oooo0P0000020000
M`H000000`12BkD00`000000Iejd06MN]00206MN]0030000001_Jkd0Kf^m00<0Kf^m00<0000008Ef
^P25M[X01P25M[X01@000000RGo208Uo`P29Ol80000000d0V8Jo00<000000:B>_@2TS[d02P2TS[d0
0`000000[iFl0:nE_0020:nE_1T000002`32Y[d00`000000c;2o0<b`_`0:0<b`_`040000003E_<80
eKc20=Fl`P8000001`3I^KX01@000000hlVm0>?9_@3SbKd0000000<0hlVm00@000000>S7]03Xak@0
0000103cf[D01`000000nMRW0?WHY`000000n^ZI0000003ggg/00`00000K0?ooo`030000003oool0
oooo00X0oooo00030?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0Z0?ooo`80000000<0001g0000000039L00`000005049;]@040000001WG[@0
Iejd000000L0Kf^m00<0000008Ef^P25M[X00`25M[X2000000@0RGo200<0000009R6_`2HQ[l02`2H
Q[l00`000000Y8jm0:B>_@070:B>_@X000001P2_Vl<00`000000^:;30;RR``0;0;RR``0300000031
Zl@0`J_400@000001P32Y[d00`000000c;2o0<b`_`0;0<b`_`030000003E_<80eKc200<0eKc20P00
00040=Vi^P030000003SbKd0hlVm00<0hlVm00L000000>?9_@3SbKd0hlVm0000003Xak@0000000D0
lmZe00<000000?WHY`0000000P3jjYT3000001`0oooo00<000000?ooo`3oool02P3oool000<0oooo
00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02/0
oooo0P000002000<U`<000001@12BkD00`000000Iejd0000000906m[_@0500000025M[X0QGJj08Ef
^P0000001`29Ol800`000000V8Jo09R6_`0;09R6_`030000002TS[d0Y8jm00H0000000<0YIC40000
000000000P00000;0:nK``030000002hX/<0^:;300/0^:;300<000000<6[a031Zl@01031Zl@40000
0080`ZJm00<000000<b`_`3</;l02P3</;l00`000000eKc20=Fl`P060=Fl`P8000000P3I^KX00`00
0000hlVm0>?9_@040>?9_@050000003SbKd0hlVm0>?9_@0000001P3cf[D2000000<0n^ZI0`00000L
0?ooo`030000003oool0oooo00X0oooo00040?ooo`8000002@3oool4000000@0oooo00<000000?oo
o`3oool0:`3oool2000000<000bG0`000005049;]@030000001_Jkd0Kf^m00P0Kf^m00@0000008Ef
^P00000000002029Ol800`000000V8Jo09R6_`0:09R6_`@00000102UU<@300000080YIC400<00000
0:nK``2_Vl<02P2_Vl<00`000000^:;30;RR``0:0;RR``0300000031Zl@0`J_400T0`J_41000000;
0<b`_`030000003E_<80eKc200P0eKc20P0000070>?9_@030000003SbKd0hlVm008000001`3cf[D0
10000000n^ZI0?[ZV@3jjYT3000001`0oooo00<000000?ooo`3oool02P3oool001H0oooo00<00000
0?ooo`3oool0;03oool2000000<000bG0`000005049;]@8000002P1_Jkd00`000000RGo208Uo`P09
08Uo`P030000002HQ[l0V8Jo00H0V8Jo0`0000000`2JS/H000000:FDa0020:FDa0<000001P2UU<@0
0`000000[i_30:nK``090:nK``030000002hX/<0^:;300X0^:;300<000000<6[a031Zl@02`31Zl@0
0`000000bKC600000002000000L0c;2o00<000000=Fl`P3E_<802@3E_<800`000000g/_500000007
0>?9_@050000003SbKd000000>gK`00000001@3cf[D2000000<0n^ZI0`00000M0?ooo`030000003o
ool0oooo00T0oooo000F0?ooo`030000003oool0oooo02d0oooo00@00000000<U`0039L000bG0`00
0004049;]@030000001AGL40000000T0Kf^m00<0000007MgaP0000002P29Ol800`000000V8Jo09R6
_`0309R6_`<000001@2JS/H3000000T0YIC400<000000:nK``2_Vl<02P2_Vl<00`000000^:;30;RR
``090;RR``0300000031Zl@0`J_400X0`J_400<000000<VdaP39]<H00`39]<H2000000D0c;2o00<0
00000=Fl`P3E_<802@3E_<8010000000g/_50=k;a@0000070>?9_@040000003]fl00kM_0000000D0
lmZe0P0000030?[ZV@8000007P3oool00`000000oooo0?ooo`090?ooo`005P3oool00`000000oooo
0?ooo`0]0?ooo`040000000039L000bG000<U`8000001@12BkD010000000DEg1055M`@00000706m[
_@040000001gMlH0MgO6000000/0RGo200<0000009R6_`0000000P00000409Z>aPD000002`2UU<@0
0`000000[i_30:nK``0:0:nK``030000002hX/<0^:;300T0^:;300<000000<6[a031Zl@02P31Zl@0
0`000000bKC60<VdaP050<VdaP<0000000<0c;2o0000003E_<802P3E_<800`000000g/_50=k;a@02
0=k;a@030000003SbKd0hlVm00@0hlVm0P0000020>gK`0070000003cf[D0lmZe0??J]@000000mnj`
000000030?[ZV@8000007P3oool00`000000oooo0?ooo`090?ooo`005P3oool00`000000oooo0?oo
o`0]0?ooo`070000000039L000bG000<U`00000022f_00000003049;]@050000001AGL40DEg1055M
`@0000001P1_Jkd00`000000MgO607MgaP0207MgaP0300000029Ol80RGo200P0RGo20P00000409Z>
aP<00000102JS/H00`000000YIC40:FDa0090:FDa0030000002_Vl<0[i_300X0[i_300<000000;RR
``2hX/<02@2hX/<00`000000`J_40<6[a0090<6[a00300000039]<H0bKC600T0bKC60P00000;0=Fl
`P030000003NblD0g/_500<0g/_500<000000>?9_@3SbKd00P3SbKd01P000000kM_00>gK`0000000
kM_0000000<0lmZe00<000000?O^/00000000P3jjYT3000001h0oooo00<000000?ooo`3oool02@3o
ool001H0oooo00<000000?ooo`3oool0;P3oool01P00000000bG000<U`00000022f_000000<0@T^e
00<00000055M`@1AGL400P1AGL400`000000Kf^m06m[_@0206m[_@030000001gMlH0MgO600<0MgO6
00<0000008Uo`P29Ol801P29Ol820000000308f8b@000000VXk600<00000202JS/H00`000000YIC4
0:FDa0090:FDa0030000002_Vl<0[i_300T0[i_300<000000;RR``2hX/<0202hX/<00`000000`J_4
0<6[a00:0<6[a00300000039]<H0bKC600T0bKC600@000000=6ob@0000000000203E_<800`000000
g/_50=k;a@050=k;a@040000003SbKd0hlVm000000<0kM_000H000000>gK`03]fl0000000??J]@00
00030?O^/0040000003jjYT00000000001l0oooo00<000000?ooo`3oool02@3oool001H0oooo00<0
00000?ooo`3oool0;P3oool00`00000000bG0000000300P][`0300000012BkD0000000H0DEg100@0
000006m[_@1_Jkd000001`1gMlH00`000000RGo208Uo`P0308Uo`P8000000P2=R<T3000000/0VXk6
00<000000:FDa02UU<@02@2UU<@00`000000[i_30:nK``030:nK```000001@2hX/<00`000000`J_4
0<6[a0090<6[a00300000039]<H0bKC600X0bKC600@000000=6ob@3A_lT0dKo90P0000060=Fl`P03
0000003NblD0g/_500H0g/_500<000000>?9_@000000103]fl001@000000kM_00000003cf[D00000
00<0mnj`1000000O0?ooo`030000003oool0oooo00T0oooo000E0?ooo`030000003oool0oooo02l0
oooo0`00000300P][`0300000012BkD0000000H0DEg100<0000006m[_@0000002@1gMlH010000000
RGo208Uo`P29Ol8500000080SHS900<0000009Z>aP2JS/H02@2JS/H00`000000YIC40:FDa0070:FD
a0P000001P2_XLT00`000000]jO90;NWb@030;NWb@P000002@31Zl@00`000000bKC60<VdaP090<Vd
aP030000003A_lT0dKo900@0dKo90P0000030=Fl`P030000003NblD0g/_500P0g/_500<000000>gK
`03]fl00103]fl000`000000kM_0000000040?O^/0@000007`3oool00`000000oooo0?ooo`090?oo
o`005@3oool200000340oooo0P00000400P][`030000001AGL40DEg100H0DEg100<0000007MgaP1g
MlH0201gMlH00`000000RGo200000002000000H0SHS900<0000009Z>aP2JS/H02P2JS/H00`000000
YIC40:FDa00600000080YY_;00<000000:nQb@2_XLT02@2_XLT00`000000]jO90;NWb@080;NWb@03
0000002n[lX0_Zo:00H000000P31Zl@00`000000bKC60<VdaP0:0<VdaP030000003A_lT0dKo900H0
dKo90P0000000`3E_<8000000=k;a@080=k;a@030000003VflX0000000H0kM_00P0000040?O^/0@0
00007`3oool00`000000oooo0?ooo`090?ooo`005@3oool00`000000oooo0?ooo`0`0?ooo`800000
1008;Jl2000000H0DEg100<0000005i]bP000000201gMlH3000000X0SHS900<0000009Z>aP2JS/H0
202JS/H4000000P0YY_;00<000000:nQb@2_XLT02@2_XLT00`000000]jO90;NWb@080;NWb@030000
002n[lX0_Zo:00H0_Zo:1000000:0<VdaP030000003A_lT0dKo900T0dKo900<000000=k;a@3NblD0
1`3NblD010000000i]_:0>KKbP0000060>gK`0800000103gk[0300000240oooo00<000000?ooo`3o
ool0203oool001D0oooo00<000000?ooo`3oool0<03oool3000000<022f_0P000006055M`@030000
001NKLX0000000D0MgO60`000000101gMlH0000007f2c@00000:08f8b@030000002JS/H0VXk600<0
VXk6100000000`2LU/d000000:JKb`0:0:JKb`030000002_XLT0[j7900P0[j7900<000000;NWb@2g
YlT0202gYlT00`000000_Zo:0;j_bP080;j_bP0300000036]l`00000008000001P39]<H00`000000
dKo90=6ob@090=6ob@030000003Ic<d0000000L0g/_500<000000>KKbP3VflX00P3VflX00`000000
kM_00>gK`0020>gK`0030000003akl40000000<0mnj`1000000Q0?ooo`030000003oool0oooo00P0
oooo000E0?ooo`030000003oool0oooo0340oooo0P00000300P][`030000000TBL00000000@0DEg1
00H0000005i]bP1NKLX0GVg:0000001gMlH3000000<0MgO600@0000007f2c@1mP/d000002P2=R<T0
0`000000VXk609Z>aP03000000H0W9K=00<000000:JKb`2VVl/0202VVl/00`000000[j790:nQb@08
0:nQb@030000002gYlT0]jO900P0]jO900<000000;j_bP2n[lX01`2n[lX00`000000a[O<0<Jgc003
0<Jgc0@000000P39]<H00`000000dKo90=6ob@080=6ob@050000003Ic<d0fLc=0=W<c@0000001P3N
blD00`000000i]_:0>KKbP020>KKbP050000003]fl00kM_00>gK`00000000P3akl4200000080mnj`
0`00000R0?ooo`030000003oool0oooo00P0oooo000E0?ooo`030000003oool0oooo0340oooo0`00
000200P][`040000000TBL0094W0000000<0DEg100<0000005i]bP0000000`00000407MgaP800000
101mP/d00`000000SHS908f8b@0808f8b@8000002@2LU/d00`000000YY_;0:JKb`080:JKb`030000
002_XLT0[j7900P0[j7900<000000;NWb@2gYlT01`2gYlT00`000000_Zo:0;j_bP080;j_bP030000
0036]l`0a[O<00L0a[O<0P00000:0=6ob@030000003Ic<d0fLc=00<0fLc=0P0000030=k;a@030000
003VflX0i]_:00@0i]_:00<000000>gK`0000000103akl4600000280oooo00<000000?ooo`3oool0
203oool001@0oooo00<000000?ooo`3oool0<P3oool30000000300P][`00000094W000<094W000<0
0000055M`@0000000P00000405i]bP040000001gMlH0MgO6000000H0OH;=00<0000008f8b@2=R<T0
1P2=R<T200000003096Ad0000000W9K=00P0W9K=00<000000:JKb`2VVl/0202VVl/00`000000[j79
0:nQb@080:nQb@030000002gYlT0]jO900L0]jO900<000000;j_bP2n[lX0202n[lX00`000000a[O<
0<Jgc0070<Jgc0040000003=`Ll00000000000P0dKo900<000000=W<c@3Ic<d01@3Ic<d00`000000
g/_5000000070>KKbP030000003]fl00000000@0lNo11P00000R0?ooo`030000003oool0oooo00P0
oooo000D0?ooo`030000003oool0oooo03<0oooo00@000000000TP00000000000`0TBL04000000H0
GVg:00<0000007MgaP000000201mP/d00`000000SHS908f8b@0308f8b@8000000`2ATM000`000000
W9K=09bFc@0809bFc@030000002VVl/0YY_;00P0YY_;00<000000:nQb@2_XLT01`2_XLT00`000000
]jO90;NWb@070;NWb@030000002n[lX0_Zo:00L0_Zo:00<000000<Jgc036]l`02036]l`010000000
cL7?0<g1c`3=`Ll2000000D0dKo900<000000=W<c@3Ic<d01`3Ic<d00`000000i]_:0>KKbP070>KK
bP030000003akl40lNo100<0lNo11@00000S0?ooo`030000003oool0oooo00P0oooo000D0?ooo`80
0000=03oool00`000000002B000000040000008094W000<0000005i]bP1NKLX01P1NKLX00`000000
OH;=07f2c@0807f2c@050000002=R<T0SHS908f8b@0000001P2ATM000`000000W9K=09bFc@0709bF
c@030000002VVl/0YY_;00P0YY_;00<000000:nQb@2_XLT00P2_XLT:000000D0]jO900<000000;j_
bP2n[lX01`2n[lX00`000000a[O<0<Jgc0070<Jgc0030000003=`Ll0cL7?00@0cL7?0P0000020=6o
b@030000003Ic<d0fLc=00L0fLc=00<000000=oKdP0000001`3VflX2000000D0lNo100<000000=kb
U`0000000P00000S0?ooo`030000003oool0oooo00P0oooo000D0?ooo`030000003oool0oooo03<0
oooo1000000502A9`08000001`1NKLX2000000T0OH;=00@0000008f8b@00000000001`2ATM000`00
0000W9K=09bFc@0709bFc@030000002VVl/0YY_;00H0YY_;1`0000050:jWd0030000002e[M00]Jg@
0080]Jg@2P0000040;j_bP0300000036]l`0a[O<00P0a[O<00<000000<g1c`3=`Ll01P3=`Ll20000
00T0fLc=00@000000=oKdP3Ofm8000001P3VflX00`000000j^k>000000040?7_`@H00000903oool0
0`000000oooo0?ooo`070?ooo`00503oool00`000000oooo0?ooo`0`0?ooo`<0000000<0oooo0000
000009800P00000402A9`0030000000jH<h0000000D0GVg:00@0000006UkdP1YNm8000002@1mP/d0
0`000000TI7@096Ad008096Ad0030000002LU/d0W9K=00L0W9K=00<000000:JKb`2VVl/01@000002
0:JRd@030000002^Ym00[ZO@00L0[ZO@00<000000;F]d02e[M001`2e[M000`000000_;?A0;bcd@02
0;bcd@H000002036]l`00`000000cL7?0<g1c`070<g1c`030000003CcM@0000000L0fLc=00<00000
0=oKdP3Ofm800P3Ofm800`000000i]_:0>KKbP020>KKbP040000003Zk/h0j^k>000000@0lNo11@00
00000`3oool000000?ooo`0R0?ooo`030000003oool0oooo00L0oooo000D0?ooo`030000003oool0
oooo02d0oooo0`0000040?ooo`050000000009800000000Y/`0000000`0TBL0010000000>V3>03YP
cP00000405i]bP050000001YNm80JG_B06UkdP0000001`1mP/d00`000000Q8gD0000000:096Ad003
0000002LU/d0W9K=00@0W9K=1@0000070:JRd@030000002^Ym00[ZO@00L0[ZO@00<000000;F]d02e
[M001`2e[M000`000000_;?A0;bcd@060;bcd@0400000032^m<00000000000D0a[O<00<000000<g1
c`3=`Ll0203=`Ll010000000dlgD0=?=e00000060=W<c@030000003Ofm80gm_B0080gm_B00<00000
0>KKbP3VflX00P3VflX010000000j^k>0>[^cP0000030?7_`@80000000<0g_:G0000000000000`3o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00L0oooo000C0?ooo`030000003oool0
oooo02/0oooo0`0000080?ooo`0400000000098000000000008094W000<0000003YPcP0jH<h00P0j
H<h010000000GVg:05i]bP00000406UkdP030000001mP/d0OH;=00<0OH;=0P00000308B=e0030000
002ATM00TI7@00L0TI7@00<0000009bFc@2LU/d01000000209jMd`030000002VX]40YZ;A00P0YZ;A
00<000000:jWd02^Ym001P2^Ym000`000000]Jg@0;F]d0060;F]d0030000002l/m40_;?A00H0_;?A
00<000000<:kd`32^m<00P32^m<300000080a[O<00<000000<g1c`3=`Ll01`3=`Ll00`000000dlgD
0=?=e0020=?=e08000000`3Ic<d00`000000gm_B0=oKdP040=oKdP040000003VflX0i]_:000000@0
j^k>00L000000?7_`@000000ho^e0000003NlYL0000000D0oooo00<000000?ooo`3oool07`3oool0
0`000000oooo0?ooo`070?ooo`004`3oool00`000000oooo0?ooo`0W0?ooo`@000002`3oool01`00
0000002B00000000:K<0000002A9`00000001@0jH<h00`000000GVg:0000000506UkdP050000001m
P/d0OH;=07f2c@0000001P24SM@00`000000TI7@096Ad007096Ad08000001`2NWM<00`000000YZ;A
0:JRd@070:JRd@030000002^Ym00[ZO@00H0[ZO@00<000000;F]d02e[M001P2e[M000`000000_;?A
0;bcd@060;bcd@0300000032^m<0`[_C00D0`[_C0P0000090<g1c`030000003CcM@0dlgD00D0dlgD
00<000000=W<c@0000001`3Ofm800`000000i]_:000000050>[^cP8000000P3SnkD2000000L0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`070?ooo`004`3oool00`000000oooo0?oo
o`0T0?ooo`<00000403oool20000008002Vc0P00000603YPcP030000001YNm80JG_B00D0JG_B00<0
000007f2c@0000001`24SM@00`000000TI7@096Ad005096Ad080000000<0U9[G0000002NWM<01P2N
WM<00`000000YZ;A0:JRd@070:JRd@030000002^Ym00[ZO@00H0[ZO@00<000000;F]d02e[M001P2e
[M000`000000_;?A0;bcd@050;bcd@0300000032^m<0`[_C00H0`[_C00@000000<O3eP0000000000
1P3=`Ll00`000000dlgD0=?=e0070=?=e0030000003Ofm80gm_B00L0gm_B00<000000>[^cP3Zk/h0
103Zk/h200000080ho^e0P0000070?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
1`3oool001<0oooo00<000000?ooo`3oool08@3oool3000001@0oooo00D00000000Y/`00:K<002Vc
0000000603YPcP8000001`1YNm800`000000Q8gD08B=e00708B=e0030000002ATM00TI7@0080TI7@
0P00000309BJe`030000002NWM<0WYgC00H0WYgC00<000000:JRd@2VX]401P2VX]400`000000[ZO@
0:jWd0060:jWd0030000002e[M00]Jg@00H0]Jg@00<000000;bcd@2l/m401@2l/m400`000000`[_C
0<:kd`060<:kd`0400000037`mH0al?F0<O3eP800000103=`Ll00`000000dlgD0=?=e0060=?=e003
0000003GfMT0000000L0gm_B0P0000060>[^cP030000003SnkD0ho^e008000002@3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo00L0oooo000C0?ooo`8000007`3oool3000001L0oooo
0P000002000Y/`8000001@0jH<h00`000000CW?H0000000506UkdP030000001cR=X0000000T0Q8gD
00@00000096Ad000000000001P2DV]L00`000000WYgC09jMd`0509jMd`030000002VX]40YZ;A00L0
YZ;A00<000000:jWd02^Ym001@2^Ym000`000000]Jg@0;F]d0050;F]d0030000002l/m40_;?A00D0
_;?A00<000000<:kd`32^m<01P32^m<00`000000al?F0<O3eP040<O3eP80000000<0cL7?0000003C
cM@01`3CcM@010000000emWI0=OIf@0000060=oKdP030000003RjmL0000000D0j^k>0P0000020>?k
]@030000003oool0oooo00T0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`060?oo
o`004`3oool00`000000oooo0?ooo`0J0?ooo`@000006`3oool01000000002Vc000Y/`00:K<20000
00@0>V3>00@0000004icf01>LmP00000101YNm8010000000LhSJ07>8fP00000908B=e0030000002D
V]L0U9[G00H0U9[G00<0000009jMd`2NWM<01P2NWM<00`000000YZ;A0:JRd@040:JRdAH00000102l
/m400`000000`[_C0<:kd`060<:kd`0300000037`mH0al?F00H0al?F00<000000=?=e03CcM@01P3C
cM@00`000000emWI0=OIf@020=OIf@030000003Ofm80gm_B0080gm_B00@000000>;[e`3RjmL00000
0`3Zk/h300000080ho^e0P00000<0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0
1P3oool00180oooo00<000000?ooo`3oool0603oool300000200oooo00H00000000Y/`00:K<00000
00I<bP00000203YPcP030000001>LmP0CW?H0080CW?H00@0000006UkdP1YNm800000101cR=X20000
00H0Q8gD00<0000008VGf`000000202DV]L00`000000WYgC09jMd`0509jMd`030000002VX]40YZ;A
00@000000P2VZMP00`000000[JgG0:f]e`050:f]e`030000002c/]L0/k;G00D0/k;G00@000000;Rh
f02h^=P0^;SH1@0000070<:kd`0300000037`mH0al?F00H0al?F00<000000<c=fP0000001P3CcM@0
0`000000emWI0=OIf@040=OIf@040000003Ofm80gm_B000000@0h^_G00<000000>[^cP0000000P3R
oL/010000000ho^e00000000000>0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
1P3oool00180oooo00<000000?ooo`3oool05@3oool3000002<0oooo0P0000001`00:K<0000000I<
bP06C<X0000003YPcP0000001@1>LmP00`000000JG_B0000000607>8fP0400000024SM@0Q8gD08B=
e08000000`29Um/00`000000U9[G09BJe`0609BJe`030000002NWM<0WYgC00@0WYgC0`0000060:JY
f0030000002][ML0[JgG00D0[JgG00<000000;>be`2c/]L01@2c/]L00`000000^;SH0;Rhf0040;Rh
f0040000002m_]X00000000000@0`[_C00<000000<O3eP37`mH01P37`mH010000000c<gJ0<c=fP3<
cMX2000000<0dlgD00<000000=OIf@3GfMT01@3GfMT00`000000gm_B000000050>;[e`8000000`3R
oL/00`000000ho^e0000000?0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool01P3o
ool00180oooo00<000000?ooo`3oool04P3oool3000002L0oooo0`00000300I<bP8000001P1>LmP0
0`000000LhSJ07>8fP0607>8fP0300000024SM@0000000H0RIOK00<0000009BJe`2DV]L01@2DV]L0
0`000000WYgC09jMd`0400000080WjKJ00<000000:JYf02VZMP01@2VZMP00`000000[JgG0:f]e`04
0:f]e`030000002c/]L0/k;G00@0/k;G00<000000;Rhf02h^=P0102h^=P00`000000_KkJ0;fnfP02
0;fnfP8000000P32^m<00`000000al?F0<O3eP050<O3eP030000003<cMX0c<gJ00@0c<gJ00<00000
0=?=e00000002@3GfMT00`000000h^_G0>;[e`040>;[e`030000003RoL/0h_g;0080h_g;0P00000A
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool01P3oool00180oooo00<000000?oo
o`3oool03P3oool4000002/0oooo0`00000300I<bP030000001>LmP0CW?H00@0CW?H0P00000807>8
fP0300000029Um/0RIOK00H0RIOK00<0000009BJe`2DV]L01@2DV]L2000000H0WjKJ00<000000:JY
f02VZMP01@2VZMP00`000000[JgG0:f]e`040:f]e`030000002c/]L0/k;G00@0/k;G00<000000;Rh
f02h^=P0102h^=P00`000000_KkJ0;fnfP040;fnfP<000001P37`mH00`000000c<gJ0<c=fP060<c=
fP030000003GfMT0emWI00H0emWI0`0000050>;[e`8000000`3RoL/300000180oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`060?ooo`004P3oool00`000000oooo0?ooo`0;0?ooo`<0
0000<03oool2000000<01Tc:0P00000504icf0030000001NQ=l0000000H0LhSJ00<0000007bEh000
00002029Um/00`000000U9[G09BJe`0209BJe`80000000<0V:?M0000002OY]X01P2OY]X00`000000
YZWH0:JYf0040:JYf0030000002][ML0[JgG00@0[JgG00<000000;>be`2c/]L0102c/]L00`000000
^;SH0;Rhf0040;Rhf0030000002m_]X0_KkJ00@0_KkJ00<000000<;5g@32aMd00`0000020<O3eP03
0000003<cMX0c<gJ00H0c<gJ00<000000<oHg`0000001@3GfMT200000080fNOO00<000000>;[e`3R
jmL00P3RjmL00`000000g?[J000000030>;mb`800000503oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo00H0oooo000B0?ooo`8000002@3oool3000003<0oooo00<000000000R0000000
0P06C<X00`0000009fSJ0000000404icf0030000001NQ=l0GXCO00800000101cR=X00`000000O9GP
07bEh002000000L0RIOK00@0000009BJe`0000000000102HXmd00`000000WjKJ09nVfP0409nVfP03
0000002VZMP0YZWH00@0YZWH00<000000:f]e`2][ML0102][ML00`000000/k;G0;>be`040;>be`03
0000002h^=P0^;SH00<0^;SH00<000000;fnfP2m_]X0102m_]X00`000000`/GM0<;5g@040<;5g@80
0000203<cMX010000000cmSO0<oHg`0000040=OIf@030000003Iiml0fNOO0080fNOO00D000000>;[
e`3RjmL0h^_G000000020=cjfP030000003RoL/0h_g;008000005P3oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo00D0oooo00090?ooo`@00000103oool2000000L0oooo0`00000g0?oo
o`<0000000@01Tc:0000000WJ=X09fSJ0P0000000`1>LmP0000005j4g`0405j4g`040000001cR=X0
LhSJ000000D0O9GP00<0000008VGf`29Um/01@29Um/00`000000V:?M09RSg@0509RSg@030000002O
Y]X0WjKJ00@0WjKJ00<000000:JYf02VZMP0102VZMP00`000000[JgG0:f]e`06000000<0/k;G00<0
00000;Rhf02h^=P0102h^=P00`000000_KkJ0;fnfP040;fnfP0300000032aMd0`/GM00@0`/GM00<0
00000<G=h@0000001@3<cMX2000000@0cmSO00@000000=OIf@00000000001P3Iiml00`000000h^_G
000000020=cjfP030000003RoL/0h_g;008000005`3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo00D0oooo000;0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3o
ool4000003/0oooo0`0000000`06C<X0000002MXfP0202MXfP8000001P1NQ=l00`000000LhSJ0000
000607bEh00300000029Um/0RIOK0080RIOK0P0000000`2?XN40000009RSg@0609RSg@030000002O
Y]X0WjKJ00<0WjKJ00@000000:JYf02VZMP0YZWH1P0000030:^dg`030000002`^=l0/;SO00H00000
0`2h^=P00`000000_KkJ0;fnfP040;fnfP0300000032aMd0`/GM00@0`/GM00D000000<G=h@35cN40
aLgQ000000030<c=fP030000003?f=l0cmSO00D0cmSO00<000000=WWg`3Iiml01P3Iiml2000000<0
g?[J00@000000>;mb`00000000006@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
00D0oooo000;0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P0000100?ooo`@0
0000100WJ=X00`000000GXCO05j4g`0505j4g`030000001lUN00O9GP00H0O9GP0P0000000`29Um/0
000008nQh@0308nQh@030000002HXmd0V:?M00D0V:?M00@0000009nVfP2OY]X0WjKJ1@0000030:Ja
h0030000002[]=l0ZkCO00<0ZkCO00<000000;2hg`2`^=l00`2`^=l00`000000];cP0;Blh0060000
00<0_KkJ00<000000<;5g@32aMd00`32aMd2000000D0aLgQ00<000000<c=fP0000001P3?f=l30000
00P0fNOO00<000000=cjfP3Ln]X00P3Ln]X4000001X0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`050?ooo`002`3oool00`000000oooo0?ooo`030?ooo`800000A03oool3000000@0
9fSJ0`00000505j4g`<00000201lUN000`000000Sj7Q08nQh@0408nQh@8000001P2HXmd3000000<0
XJkQ00<000000:Jah02V/N000`2V/N000`000000ZkCO0:^dg`020:^dg`030000002`^=l0/;SO0080
/;SO00<000000;Blh02d_>000`2d_>0010000000^<7Q0;S1h@2h`N43000000D0`/GM00<000000<G=
h@35cN401P35cN400`000000cmSO0<oHg`040<oHg`050000003@hnD0d>?U0=3Si@0000001@3Iiml3
000000@0g?[J00<000000;ch]P000000703oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo00D0oooo000;0?ooo`030000003oool0oooo00@0oooo0`0000130?ooo`0400000000;K800000
000000<09fSJ00<0000004=oi0000000101NQ=l010000000KI?V06fCiP00000607bEh00400000025
X>D00000000000H0Sj7Q00@0000009RSg@2HXmd0V:?M0P0000000`2J[N@000000:6^h@030:6^h@03
0000002V/N00Y[7P00<0Y[7P00<000000:^dg`2[]=l00P2[]=l00`000000/;SO0;2hg`020;2hg`03
0000002d_>00];cP00<0];cP00<000000;S1h@2h`N400P2h`N4010000000^/KT0000000000020<;5
g@0300000035cN40aLgQ00D0aLgQ0P0000000`37eND000000<oHg`030<oHg`030000003@hnD0d>?U
0080d>?U00@000000=WWg`3Iiml0fNOO0P0000020=Gei0030000003Ln]X0g?[J0080000000<0_?Rf
0000003oool07@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00D0oooo00090?oo
o`<00000203oool00`000000oooo0?ooo`120?ooo`0400000000;K800000000000809fSJ00<00000
04=oi013On@00P00000205j4g`040000001]TnH0KI?V06fCiP800000101lUN001@000000QJ3U08FP
i@25X>D0000000H0Sj7Q00<0000009RSg@000000102J[N@00`000000XJkQ0:6^h@020:6^h@030000
002V/N00Y[7P0080Y[7P00<000000:^dg`2[]=l00P2[]=l00`000000/;SO0;2hg`020;2hg`030000
002d_>00];cP0080];cP00<000000;S1h@2h`N400P2h`N400`000000^/KT0;[6i0020;[6i0800000
1P35cN42000000@0amGU00@000000<oHg`00000000001P3@hnD3000000<0eOGT00D000000=cjfP3L
n]X000000<CodP02000001l0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`050?oo
o`002`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0480oooo0P0000001000Em40
000002MXfP00000404=oi0<000001@1]TnH20000000307bEh0000000QJ3U00@0QJ3U0P00000508nQ
h@030000002J[N@0VZgT00@0VZgT00<000000:6^h@2Q[^400P2Q[^400`000000Y[7P0:Jah0020:Ja
h0050000002[]=l0ZkCO0:^dg`0000000`2`^=l00`000000];cP0;Blh0020;Blh0030000002h`N40
^<7Q0080^<7Q00<000000;[6i02ja^@00`2ja^@00`000000_<cV000000040<G=h@0300000037eND0
amGU00D0amGU00<000000=3Si@3@hnD01@3@hnD2000000D0eOGT0`0000000`34om8000000000000Q
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool01@3oool001H0oooo0P0000130?oo
o`80000000@005OA00000000000000001@13On@00`000000KI?V06fCiP0506fCiP0300000025X>D0
QJ3U00H0QJ3U0P000000102?XN4000000000002D[>L2000000D0VZgT00D000000:6^h@2Q[^40XJkQ
000000020:Jah0`000000`2d_>001@000000^<7Q0;S1h@2h`N40000000D0^/KT00H000000;c<iP2l
c>H0_<cV00000035cN42000000H0amGU0`0000050=3Si@80000000<0c>k[0000003EmN@0103EmN@0
0`000000a?oB0<CodP02000002<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`04
0?ooo`00603oool200000480oooo0P000002001Gd@8000001013On@3000000D0KI?V00@0000007ZP
j`00000000001`25X>D00`000000U:cW09B/i`0309B/i`030000002J[N@0VZgT00<0VZgT00<00000
0:6^h@2Q[^400`0000020:Fij0050000002X^nL0Z;_W0:Rki`0000000`2[_^L00`000000[/7X0000
000300000080^<7Q00<000000;[6i02ja^@00P2ja^@2000000@0_<cV0P0000060<OEi@8000000P36
g^X010000000d>?U0=3Si@3@hnD2000000<0c>k[00@000000=Gei03EmN@0eOGT0P0000030<CodP03
0000003oool0oooo02<0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`040?ooo`00
6@3oool2000004<0oooo00<00000001Gd@00Em400`00000204=oi0030000001ITN/0FI7[00800000
0`1]TnH010000000NZ3[07ZPj`1jX>/2000000@0QJ3U00@0000008f/jP0000000000102D[>L00`00
0000VZgT09Z]i00309Z]i08000000P2Q^>T01@000000YKWX0:Fij02U^NP000000080Z;_W00@00000
0:^ni`2[_^L000000`2^`NP00`000000/<CY0;34j@02000000@0^/KT00<000000;c<iP2lc>H00P2l
c>H200000080_M;Z00@000000<OEi@37eND0amGU0P0000050<KNjP<00000103<k^/00`000000eOGT
0=Gei00300000080a?oB0P00000W0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
103oool001/0oooo00<000000?ooo`3oool0@@3oool00`00000005OA0000000201mgi080000000<0
@goT0000001ITN/00P1ITN/3000000H0NZ3[0P00000208FPi@040000002=[>X0SJcZ08f/jP800000
0`2D[>L20000000509Z]i0000000000009fgj`0000000P2Q^>T01@000000YKWX0:Fij02U^NP00000
0080Z;_W00@000000:^ni`2[_^L000000`2^`NP01@000000/<CY0;34j@000000//OZ0080000000<0
^/KT0000002lc>H00P2lc>H2000000@0_M;Z00@000000<OEi@00000000001P36g^X2000000H0c>k[
0`0000020<Gmi0@00000:@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00@0oooo
000L0?ooo`800000@P3oool3000000<07gOT0P00000505VAj`030000001jX>/0NZ3[00H0NZ3[0P00
000608f/jP8000000P2D[>L2000000@0WKO[00@000000:6hj@2Q^>T000000P2U^NP010000000Z;_W
0:Rki`0000020:^ni`040000002^`NP0[/7X00000080/<CY00<000000;;7jP2banX00P2banX00`00
0000_<cV0;c<iP02000000H0_M;Z0P0000060<KNjP80000000<0`nK_0000003<k^/0103<k^/20000
00<0aOgT0P0000000`2AjkL000000?ooo`0Y0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0103oool001<0oooo100000070?ooo`800000@@3oool2000000D07gOT0`00000205VAj`03
0000001]XO000000008000001@1jX>/010000000QJc^00000000000508f/jP8000000P2I]^`20000
00<0WKO[00@000000:6hj@2Q^>T000000P2U^NP01@000000Z;_W0000002[_^L000000080[/7X00@0
00000;34j@2`a>T000000`2banX2000000030;;;k0000000000000D0_M;Z0`0000000`2lf>h00000
0<KNjP030<KNjP8000000`33i^l00`000000c>k[0<c^j`0400000080aOgT0P0000000`2AjkL00000
0?ooo`0/0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0103oool001D0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`100?ooo`<000000`0OMn@00`000000@i3_04>@
k`020000000305VAj`000000KJ7`0080KJ7`0`0000000`1jX>/0000008F/kP0308F/kP<000000P2=
[>X010000000U;O_00000000000209Vfk08000000P2M]n/010000000XKSY0000002U^NP600000080
[/7X00<000000;34j@0000000P2banX2000000030;;;k000000000000080//o_00<000000;gBjP2m
d^X00P0000050;cHkP0400000036g^X00000000000@0`nK_00@000000<c^j`00000000000`31m^l4
00000003097[]`000000oooo02h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`04
0?ooo`005@3oool00`000000oooo0?ooo`080?ooo`800000@P3oool3000000807gOT00@0000004>@
k`13T>l0@i3_0P00000606fQl08000001`25[>h2000000@0U;O_0P00000209Vfk080000000T0WKO[
00000000000000000:;3l0000000Xl?`0000002Ta?001@000000102banX000000000002bbn`20000
00@0//o_0`0000050;cHkP@000001033i^l4000000@0`OK_0P000000102TmmX00000097[]`00000a
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool00`3oool000d0oooo100000040?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool0@03oool5000000D0@i3_0`00000406fQ
l0030000001m[_80OJkb00@000000P25[>h00`000000T;Oa0000000200000080U;O_0P00000209Vf
k0D0000000D0X/?`00000000000000000:G5l005000000030;;;k0000000000000<0//o_0`000000
102ad_4000000;cHkP2lf>h400000080^Mkb00<000000<?Vk`0000000`0000020;_/m00400000031
m^l0`OK_0<7fk`8000000P2TmmX3000003<0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`030?ooo`005@3oool00`000000oooo0?ooo`0;0?ooo`800000@P3oool5000000<0@i3_00<0
000005nRm01OX_@00`0000000`1]XO00000007f^lP0507f^lP<00000102@]o430000000509Bgk`00
000000000000002M`_803P0000020;;?k`<000000P2ad_45000000@0^Mkb100000050;_/m0030000
0031m^l0`OK_00<000000P2TmmX2000003D0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`030?ooo`004`3oool3000000h0oooo0P0000120?ooo`80000000<006cH0000000000001000
000405nRm0H00000101m[_800`000000S;Wd08bim00400000003092gl@000000000001<0000000<0
/M;a0000000000000P0000020:oEm0030000002ig_80^Mkb00@0000000<0]>;f0000002kk?@01P2k
k?@5000000030:CgfP000000000003P0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`030?ooo`005@3oool00`000000oooo0?ooo`0>0?ooo`800000@P3oool400000080:Hg]1@000002
05nRm0040000001f/?L0M[3g07J`m`D000001P2<^O@G00000080[mGd1`0000050;CRmP030000002k
k?@0^ncd00H0000000<0[?O^0000000000000P00000k0?ooo`030000003oool0oooo00/0oooo00<0
00000?ooo`3oool00`3oool002P0oooo00<000000?ooo`3oool0@@3oool3000000<0:Hg]00<00000
052Tm`1@Y?L01`00000307J`m`0300000028^oL0R;_g0080R;_g6`0000040:cHmP030000002dh_H0
]>;f00P000000P2^koL2000000030:cgkP000000000000800000?P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00<0oooo000Y0?ooo`800000@P3oool50000000302V=k@0000000000
00@0D:Cg00<0000006jcnP1^/oX03`0000000`2Ha_L0000000000008000000040:7=m`0000000000
000000@0YmWi200000030:cUnP030000002^koL0[^og00<0[^og1P0000110?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool00`3oool002X0oooo0P0000130?ooo`T000000P1@Y?L00`00
0000K[?j06jcnP0406jcnP0300000026_OT0Q[gi0080Q[gi0P00000208C1n`80000000<0V<Oh0000
002Hb?P00P000000102JboP000000000002McOP3000000D0X]Wk1`0000040:cUnP030000002^koL0
[^og00D0000000<0S>gV000000000000@`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo0080oooo000/0?ooo`030000003oool0oooo04<0oooo0P00000200n9i0h000000`24`O/30000
000308?4o@000000000000X000000P2Lf?`300000080X]Wk0P0000040:7Uo0L0000000@0Vngg0000
00000000S>gV0P0000160?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00P3oool0
02d0oooo0`0000140?ooo`H000000P12Y_L2000000@0J;Ol1@00000208?4o@8000000P24b?h01P00
0000Q/cn08K<oP000000R]3o00000080Sm?n00@0000009GFoP00000000000`2Lf?`4000000@0XNGl
0P00000409_]m`D00000B@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0080oooo
000_0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`0000002P00000506Blo@<000000P24
b?h010000000Q/cn08K<oP00000308[@o`040000002?doh0Sm?n00000080UMKn0`00000409CRo@d0
0000C03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo000`0?ooo`030000
003oool0oooo0480oooo00@000000?ooo`3oool0oooo0P0000001000QMH0000000000000000203RY
l`8000000P1T_?d2000000<0I<;m3`00000408KMoP@000001023iO@400000540oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`020?ooo`00<@3oool200000440oooo00<000000?ooo`3o
ool0103oool<000000<0I<;m00<0000006O8o@1Wb?d00P1Wb?d01@000000K/om06k?o@1^cod00000
00@0NMKm0P00000208KMoP8000000`1YfNl4000005D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`020?ooo`00<`3oool2000003l0oooo00<000000?ooo`3oool02@3oool600000003
03>]k`000000000001P00000FP3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0080
oooo000d0?ooo`800000?P3oool00`000000oooo0?ooo`0?0?oooa@00000HP3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0080oooo000f0?ooo`030000003oool0oooo03/0oooo00<0
00000?ooo`3oool0QP3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0040oooo000g
0?ooo`<00000>P3oool00`000000oooo0?ooo`270?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00@3oool002T0oooo0P0000040?ooo`030000003oool0oooo0080oooo0`0000020?oo
o`030000003oool0oooo03P0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0040oooo000X0?ooo`040000003oool0oooo000000/0oooo00@000000?oo
o`3oool00000>@3oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00@3oool002P0oooo00@000000?ooo`3oool000002`3oool010000000oooo0?ooo`3o
ool2000003L0oooo00<000000?ooo`3oool0R@3oool01@000000oooo0?ooo`3oool0000000<0oooo
000R0?ooo`@000000P3oool010000000oooo0?ooo`0000080?ooo`<000001P3oool2000003D0oooo
00<000000?ooo`3oool0RP3oool010000000oooo0?ooo`0000030?ooo`00:03oool010000000oooo
0?ooo`0000080?ooo`030000003oool0oooo00L0oooo0P00000d0?ooo`030000003oool0oooo08/0
oooo00<000000?ooo`0000000`3oool002P0oooo00@000000?ooo`3oool00000203oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0S03oool00`000000
oooo000000020?ooo`00:@3oool2000000T0oooo100000090?ooo`800000<@3oool00`000000oooo
0?ooo`2<0?ooo`030000003oool000000080oooo00120?ooo`800000<03oool00`000000oooo0?oo
o`2=0?ooo`8000000P3oool004@0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`2<
0?ooo`<000000P3oool004D0oooo0`00000/0?ooo`030000003oool0oooo08P0oooo100000050?oo
o`00A`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo08<0oooo1@0000090?ooo`00
A`3oool3000002X0oooo00<000000?ooo`3oool0O`3oool4000000h0oooo001:0?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool0N`3oool400000180oooo001;0?ooo`8000009`3oool0
0`000000oooo0?ooo`1f0?ooo`D000005P3oool004`0oooo0P00000V0?ooo`030000003oool0oooo
0780oooo1000000K0?ooo`00CP3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo06d0
oooo1@00000O0?ooo`00C`3oool2000002<0oooo00<000000?ooo`3oool0J@3oool4000002@0oooo
00150?ooo`8000002@3oool200000280oooo00<000000?ooo`3oool0I03oool5000002P0oooo0014
0?ooo`040000003oool0oooo000000X0oooo0P00000P0?ooo`030000003oool0oooo0600oooo1000
000]0?ooo`00A03oool010000000oooo0?ooo`00000<0?ooo`8000007P3oool00`000000oooo0?oo
o`1L0?ooo`@00000<@3oool004@0oooo00@000000?ooo`3oool00000303oool2000001h0oooo00<0
00000?ooo`3oool0E`3oool5000003D0oooo00140?ooo`040000003oool0oooo000000h0oooo0P00
000L0?ooo`030000003oool0oooo05<0oooo1000000j0?ooo`00A03oool010000000oooo0?ooo`00
000@0?ooo`8000006P3oool00`000000oooo0?ooo`1>0?ooo`D00000?P3oool004D0oooo0P00000B
0?ooo`8000006@3oool00`000000oooo0?ooo`1:0?ooo`@00000@`3oool005/0oooo00<000000?oo
o`0000005P3oool00`000000oooo0?ooo`150?ooo`D00000A`3oool005`0oooo0P00000F0?ooo`03
0000003oool0oooo0440oooo1000001<0?ooo`00G@3oool2000001@0oooo00<000000?ooo`3oool0
?P3oool400000500oooo001O0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0>@3o
ool5000005@0oooo001P0?ooo`8000004@3oool00`000000oooo0?ooo`0e0?ooo`@00000F@3oool0
0640oooo0P00000@0?ooo`030000003oool0oooo0300oooo1@00001M0?ooo`00H`3oool2000000h0
oooo00<000000?ooo`3oool0;03oool400000680oooo001U0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0:03oool4000006H0oooo001E0?ooo`800000103oool00`000000oooo0?oo
o`020?ooo`<000000P3oool2000000`0oooo00<000000?ooo`3oool08`3oool5000006X0oooo001D
0?ooo`040000003oool0oooo000000/0oooo00@000000?ooo`3oool0oooo0`0000090?ooo`030000
003oool0oooo01l0oooo1000001_0?ooo`00E03oool010000000oooo0?ooo`00000;0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0J0?ooo`D00000
L`3oool005@0oooo00@000000?ooo`3oool00000203oool3000000H0oooo0`0000070?ooo`030000
003oool0oooo01H0oooo1000001h0?ooo`00E03oool010000000oooo0?ooo`0000080?ooo`030000
003oool0oooo00T0oooo0P0000050?ooo`030000003oool0oooo0140oooo1@00001l0?ooo`00E03o
ool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00X0oooo0P0000040?ooo`030000
003oool0oooo00d0oooo100000210?ooo`00E@3oool2000000T0oooo1000000;0?ooo`050000003o
ool000000?ooo`0000002`3oool4000008D0oooo001`0?ooo`80000000<0oooo0000003oool01@3o
ool5000008T0oooo001a0?ooo`<000000P3oool4000008h0oooo001c0?ooo`<00000TP3oool00?l0
oooo2@3oool00?l0oooo2@3oool00?l0oooo2@3oool00?l0oooo2@3oool006l0oooo1000002E0?oo
o`00L@3oool00`000000oooo0?ooo`2D0?ooo`00L@3oool00`000000oooo0?ooo`2D0?ooo`00L@3o
ool00`000000oooo0?ooo`2D0?ooo`00L@3oool00`000000oooo0?ooo`2D0?ooo`00K`3oool30000
09H0oooo001a0?ooo`030000003oool0oooo09@0oooo0000\
\>"],
  ImageRangeCache->{{{91.5625, 302.312}, {704.688, 475.375}} -> {-0.414409, \
2.05273, 0.00351649, 0.00351649}}]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{947, 674},
WindowMargins->{{Automatic, 133}, {102, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"PostScriptOutputFile":>FrontEnd`FileName[{$RootDirectory, "home", \
"tatuomin"}, "hyrra2.nb.ps", CharacterEncoding -> "iso8859-1"],
"Magnification"->1}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 56, 1, 27, "Input"],
Cell[1813, 54, 38, 0, 34, "Text"],
Cell[1854, 56, 120, 2, 27, "Input"],
Cell[1977, 60, 109, 3, 34, "Text"],

Cell[CellGroupData[{
Cell[2111, 67, 718, 13, 171, "Input"],
Cell[2832, 82, 109, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2978, 89, 41, 1, 27, "Input"],
Cell[3022, 92, 53, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3112, 98, 59, 1, 27, "Input"],
Cell[3174, 101, 19673, 462, 186, 3766, 261, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[22862, 566, 28, 0, 34, "Text"],
Cell[22893, 568, 74, 1, 27, "Input"],
Cell[22970, 571, 111, 3, 34, "Text"],
Cell[23084, 576, 925, 17, 219, "Input"],
Cell[24012, 595, 58, 0, 34, "Text"],

Cell[CellGroupData[{
Cell[24095, 599, 162, 2, 43, "Input"],
Cell[24260, 603, 51, 1, 27, "Output"]
}, Open  ]],
Cell[24326, 607, 105, 1, 34, "Text"],
Cell[24434, 610, 182, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[24641, 617, 60, 1, 27, "Input"],
Cell[24704, 620, 23162, 598, 186, 5320, 373, "GraphicsData", "PostScript", \
"Graphics"],
Cell[47869, 1220, 130, 3, 27, "Output"]
}, Open  ]],
Cell[48014, 1226, 37, 0, 34, "Text"],
Cell[48054, 1228, 75, 1, 27, "Input"],
Cell[48132, 1231, 91, 1, 34, "Text"],

Cell[CellGroupData[{
Cell[48248, 1236, 1788, 30, 379, "Input"],
Cell[50039, 1268, 369, 6, 20, "Message"],
Cell[50411, 1276, 361, 5, 20, "Message"],
Cell[50775, 1283, 365, 5, 20, "Message"],
Cell[51143, 1290, 367, 6, 20, "Message"],
Cell[51513, 1298, 148, 3, 23, "Print"],
Cell[51664, 1303, 148, 3, 23, "Print"],
Cell[51815, 1308, 148, 3, 23, "Print"],
Cell[51966, 1313, 148, 3, 23, "Print"],
Cell[52117, 1318, 148, 3, 23, "Print"],
Cell[52268, 1323, 148, 3, 23, "Print"],
Cell[52419, 1328, 148, 3, 23, "Print"],
Cell[52570, 1333, 148, 3, 23, "Print"],
Cell[52721, 1338, 148, 3, 23, "Print"],
Cell[52872, 1343, 150, 3, 23, "Print"],
Cell[53025, 1348, 150, 3, 23, "Print"],
Cell[53178, 1353, 150, 3, 23, "Print"],
Cell[53331, 1358, 150, 3, 23, "Print"],
Cell[53484, 1363, 150, 3, 23, "Print"],
Cell[53637, 1368, 150, 3, 23, "Print"],
Cell[53790, 1373, 150, 3, 23, "Print"]
}, Open  ]],
Cell[53955, 1379, 337, 7, 59, "Input"],
Cell[54295, 1388, 199, 6, 96, "Text"],

Cell[CellGroupData[{
Cell[54519, 1398, 49, 1, 27, "Input"],
Cell[54571, 1401, 224982, 9271, 296, 149625, 8336, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[279568, 10675, 199, 6, 96, "Text"],

Cell[CellGroupData[{
Cell[279792, 10685, 49, 1, 27, "Input"],
Cell[279844, 10688, 230516, 9521, 296, 154373, 8577, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[510375, 20212, 270, 9, 96, "Text"],

Cell[CellGroupData[{
Cell[510670, 20225, 49, 1, 27, "Input"],
Cell[510722, 20228, 228149, 9424, 296, 152508, 8486, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

