% Mat-5.3701 
% Exercise 8, Problem 1a

% -------------------------------------------------
% Solution curves as intersections of the surfaces:
% -------------------------------------------------
disp('Ex. 8 Pr. 1a');
clear all;

% One example with one choice of constants:
% -----------------------------------------

% Principal moments of inertia
I1 = 1;
I2 = 2;
I3 = 3;

% Constants of motion
% T = 1/2*(I1*ome1^2 + I2*ome2^2 + I3*ome3^2)
T = 1;
% L^2 = I1^2 + I2^2 + I3^2
R2 = 4;

% Constants for the ellipsoid and sphere
C1 = 1/I1 - 1/I3;
C2 = 1/I2 - 1/I3;
C3 = 2*T - R2/I3;

% Limits for the grid
xmax = sqrt(2*T*I1) + 1;
ymax = sqrt(2*T*I2) + 1;

% x,y grid
[x, y] = meshgrid([0: 0.05: xmax],[0: 0.05: ymax]);

% Sphere
z1 = sqrt( R2 - x.^2 - y.^2 );

% Ellipsoid
z2 = sqrt( 2*T*I3*( 1 - x.^2/(2*T*I1) - y.^2/(2*T*I2) ) );

% Surface plots
disp('Plot the surfaces');

figure(1); clf;

surf(x, y, z1); hold on;
surf(x, -y, z1); hold on;
surf(-x, y, z1); hold on;
surf(-x, -y, z1); hold on;

surf(x, y, z2); hold on;
surf(x, -y, z2); hold on;
surf(-x, y, z2); hold on;
surf(-x, -y, z2); 

xlabel('L1')
ylabel('L2')
zlabel('L3')
hold off;


% Curves of intersection with a series of constants:
% --------------------------------------------------

% Surface plots
disp('Plot the surfaces');

% Ellipsoid
figure(2); clf
mesh(x, y, z2); hold on;
mesh(-x, y, z2); hold on;
mesh(x, -y, z2); hold on;
mesh(-x, -y, z2); hold on;
grid on;

% Intersection curves
for i = 5:12

    % Principal moments of inertia
    I1 = 1;
    I2 = 2;
    I3 = 3;

    % Constants of motion
    % T = 1/2*(I1*ome1^2 + I2*ome2^2 + I3*ome3^2)
    T = 1;
    % L^2 = I1^2 + I2^2 + I3^2
    R2 = i*0.5;

    % Constants for the ellipsoid and sphere
    C1 = 1/I1 - 1/I3;
    C2 = 1/I2 - 1/I3;
    C3 = 2*T - R2/I3;

    % Curve
    xP = -sqrt( C3/C1 ): 0.01: sqrt( C3/C1 );

    yP = sqrt( (C3 - C1*xP.^2)/C2 );
    zP = sqrt( R2 - xP.^2 - yP.^2 );

    plot3(xP, yP, zP, 'k*','Linewidth', 3); 
    hold on;

    yP = -sqrt( (C3 - C1*xP.^2)/C2 );
    zP = sqrt( R2 - xP.^2 - yP.^2 );

    plot3(xP, yP, zP, 'k*','Linewidth', 3); 
    hold on;

end;

xlabel('L1')
ylabel('L2')
zlabel('L3')
hold off;