function y = Hami1a(x, m1, m2, l1, l2)

% Hamilton formalism

q = x(1:2)';
p = x(3:4)';

g = 9.81;


% Compute M and DM

M = [ (m1 +m2)*l1^2           m2*l1*l2*cos(q(2)-q(1)) ;
      m2*l1*l2*cos(q(2)-q(1)) m2*l2^2];


DM1 = [ 0 m2*l1*l2*sin(q(2)-q(1)) ; m2*l1*l2*sin(q(2)-q(1)) 0];

DM2 = [ 0 m2*l1*l2*sin(q(2)-q(1))  ; 0 m2*l1*l2*sin(q(2)-q(1))];


qq = inv(M)*p';

pp(1) = 0.5*p*inv(M)*DM1*inv(M)*p' - (m1+m2)*g*l1*sin(q(1));
pp(2) = 0.5*p*inv(M)*DM2*inv(M)*p' - m2*g*l2*sin(q(2));

y = [qq(1) qq(2) pp(1) pp(2)]';