function nyiso = importNYenergydata(filename, startRow, endRow)
%IMPORTFILE Import numeric data from a text file as a matrix.
%   NYISO = IMPORTFILE(FILENAME) Reads data from text file FILENAME for the
%   default selection.
%
%   NYISO = IMPORTFILE(FILENAME, STARTROW, ENDROW) Reads data from rows
%   STARTROW through ENDROW of text file FILENAME.
%
% Example:
%   nyiso = importfile('20150701pal.csv', 2, 3169);
%
%    See also TEXTSCAN.

% Auto-generated by MATLAB on 2016/11/07 22:26:06

%% Initialize variables.
delimiter = ',';
if nargin<=2
    startRow = 2;
    endRow = inf;
end

%% Format for each line of text:
%   column1: datetimes (%{MM/dd/yy HH:mm:ss}D)
%	column3: text (%q)
%   column5: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%{MM/dd/yy HH:mm:ss}D%*q%q%*q%f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to the format.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', delimiter, 'EmptyValue' ,NaN,'HeaderLines', startRow(1)-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');
for block=2:length(startRow)
    frewind(fileID);
    dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', delimiter, 'EmptyValue' ,NaN,'HeaderLines', startRow(block)-1, 'ReturnOnError', false, 'EndOfLine', '\r\n');
    for col=1:length(dataArray)
        dataArray{col} = [dataArray{col};dataArrayBlock{col}];
    end
end

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Create output variable
nyiso = table(dataArray{1:end-1}, 'VariableNames', {'TimeStamp','Name','Load'});

% For code requiring serial dates (datenum) instead of datetime, uncomment
% the following line(s) below to return the imported dates as datenum(s).

% nyiso.TimeStamp=datenum(nyiso.TimeStamp);

