(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   5478402,     207852]*)
(*NotebookOutlinePosition[   5479146,     207877]*)
(*  CellTagsIndexPosition[   5479102,     207873]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING IN FRONT OF NONHOMOGENEITY", "Text",
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  is  incident from the left.\n\nThe nonhomogeneity  \
",
    FontSize->12],
  StyleBox["is located on the positive ",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["x",
    FontSize->12,
    FontSlant->"Italic",
    CharacterEncoding->"WindowsANSI"],
  StyleBox["-axis.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  \n\nThe wavefront enters the nonhomogeneity at time t=0. \n\n\
The potential   v[x], which is ",
    FontSize->12],
  StyleBox["the nonhomogeneity, is strictly positive.  \n\nThe transmission \
coefficient, left reflection coefficient, and right reflection coefficient, \
respectively, are denoted by  T[k],  L[k],  R[k].\n\nThe tail of the wave is \
denoted by  g[x,t]; there is no tail until the wavefront interacts with the \
nonhomogeneity. \n\nThis is the same as focusing to the point x0=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(Clear[v, T, L, R, x0, g, e]; 
    v[x_] = \ UnitStep[
          x]\ 80\ \((Sqrt[5] + 1)\) \((Sqrt[5] + 
            2)\)\ E^\((2\ Sqrt[
                  5]\ x)\)/\((\((1 + Sqrt[5])\) \((2 + 
                      Sqrt[5])\)\ E^\((2\ Sqrt[5]\ x)\) - 2)\)^2;\), "\n", 
    \(\(T[k_] = 
        k \((k + I\ Sqrt[5])\)/\((\((k + I)\) \((k + 2\ I)\))\);\)\), "\n", 
    \(\(L[k_] = 2/\((\((k + I)\) \((k + 2\ I)\))\);\)\), "\n", 
    \(\(R[
          k_] = \(-2\)\ \((k + 
                I\ Sqrt[5])\)/\((\((k + I)\) \((k + 2\ I)\) \((k - 
                    I\ Sqrt[5])\))\);\)\)}], "Input",
  CellOpen->False],

Cell["Specify the focusing location  x0, as equal to zero, next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(x0 = 0;\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(\(e[x_] = 
        4\ Sqrt[5]/\((\((1 + Sqrt[5])\) \((2 + 
                      Sqrt[5])\)\ E^\((2\ Sqrt[5]\ x)\) - 2)\);\)\(\n\)
    \)\t\t\), "\n", 
    \(\(\(q25[x_, t_] = \ 
        2 \((Sqrt[5] - 2 + 
                e[x])\)\ E^\((2 \((\ x - x0 - t)\))\)\  - \((Sqrt[5] - 1 + 
                e[x])\)\ E^\((x - x0 - t)\);\)\(\n\)
    \)\t\), "\n", 
    \(\t\(q26[x_, t_] = 
        2 \((E^\((\(-2\) \((\ x + x0 + t)\))\)\  - 
              E^\((\(-\((\ x + x0 + t)\)\))\))\)\ ;\)\n\n\), "\n", 
    \(\(g[x_, t_] = \ 
        UnitStep[x]\ \ \ UnitStep[\(-x\) + x0 + t]\ q25[x, t] + 
          UnitStep[\(-x\)]\ \ \ UnitStep[x + x0 + t]\ q26[x, 
              t];\)\)}], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-1\), \ 
              2}, \ PlotRange -> {\(-1\), 4}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-1\), \ 2}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-1\), 
                1}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-1\), \ 2}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-1\), 
                1}]}, \[IndentingNewLine]\ {t, \ \(-0.9\), \ 1.9,  .02}, 
        PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.0503 .12361 L
.05288 .12361 L
.05405 .12361 L
.05528 .12361 L
s
.05528 .12361 m
.05554 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`05oooo00?o
09Woooooool07Oooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool001koool00ol0VOooooooo`16
oooo00<0000co`0co`00Ac?o00D0001Zoooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol0
048co`050000Koooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000m<ol01@0007Coool0
01koool00ol0VOooooooo`16oooo00<0000co`0co`00>C?o00@0001ioooo000Noooo00?o09Wooooo
ool0A_ooo`80000h<ol00P0007goool001koool00ol0VOooooooo`16oooo00<0000co`0co`00=C?o
0080001ooooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol003<co`020000POooo`007_oo
o`03o`2Ioooooooo04Koool00`0003?o03?o000a<ol00P0008?oool001koool00ol0VOooooooo`16
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool001koool00ol0VOooooooo`16oooo00<0
000co`0co`00;S?o00800026oooo000Noooo00?o09Woooooool0A_ooo`80000]<ol00P0008Soool0
01koool00ol0VOooooooo`16oooo00<0000co`0co`00:c?o00030000oooooooo08Soool001koool0
0ol0VOooooooo`16oooo00<0000co`0co`00:S?o00030000oooooooo08Woool001koool00ol0VOoo
ooooo`16oooo00<0000co`0co`00:C?o00030000oooooooo08[oool001koool00ol0VOooooooo`16
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool001koool00ol0VOooooooo`16oooo00<0
000co`0co`00:3?o00030000oooooooo08_oool001koool00ol0VOooooooo`16oooo0P0002Pco`00
0`000?ooooooo`2<oooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000N
oooo00?o09Woooooool0A_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Noooo00?o
09Woooooool0A_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Noooo00?o09Wooooo
ool0A_ooo`80000S<ol000<0003oooooool0TOooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`007_ooo`03o`2Ioooooooo03koool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000Noooo00?o09Woooooool0@?ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`007_ooo`03o`2Ioooooooo043oool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000Noooo00?o09Woooooool0@?ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`007_ooo`03o`2Ioooooooo043oool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool001koool00ol0VOooooooo`0o
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`007_ooo`03o`2Ioooooooo
04Koool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`007_ooo`03o`2Ioooooooo04Koool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`007_ooo`03o`2Ioooooooo04Koool2000073?o
00030000oooooooo09Soool001koool00ol0VOooooooo`16oooo00<0000co`0co`006S?o00030000
oooooooo09Woool001koool00ol0VOooooooo`16oooo00<0000co`0co`006S?o00030000oooooooo
09Woool001koool00ol0VOooooooo`16oooo00<0000co`0co`006C?o00030000oooooooo09[oool0
01koool00ol0VOooooooo`16oooo00<0000co`0co`006C?o00030000oooooooo09[oool001koool0
0ol0VOooooooo`16oooo00<0000co`0co`0063?o00030000oooooooo09_oool001koool00ol0VOoo
ooooo`16oooo0P0001Tco`000`000?ooooooo`2Koooo000Noooo00?o09Woooooool0A_ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000N
oooo00?o09Woooooool0A_ooo`80000F<ol000<0003oooooool0W_ooo`007_ooo`03o`2Ioooooooo
04Koool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`007_ooo`03o`2Ioooooooo04Koool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`007_ooo`03o`2Ioooooooo04Koool200005C?o00030000oooooooo09ooool0
01koool00ol0VOooooooo`16oooo00<0000co`0co`004c?o00030000oooooooo0:3oool001koool0
0ol0VOooooooo`16oooo00<0000co`0co`004c?o00030000oooooooo0:3oool001koool00ol0VOoo
ooooo`16oooo00<0000co`0co`004c?o00030000oooooooo0:3oool001koool00ol0VOooooooo`0n
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`007_ooo`03o`2Ioooooooo
03koool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool001koool0
0ol0VOooooooo`0ooooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`007_oo
o`03o`2Ioooooooo043oool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool001koool00ol0VOooooooo`0noooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool001koool00ol0VOooooooo`0ooooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`007_ooo`03o`2Ioooooooo04Koool200004C?o00030000oooooooo0:?oool001koool0
0ol0VOooooooo`16oooo00<0000co`0co`0043?o00030000oooooooo0:?oool001koool00ol0VOoo
ooooo`16oooo00<0000co`0co`0043?o00030000oooooooo0:?oool001koool00ol0VOooooooo`16
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool001koool00ol0VOooooooo`16oooo00<0
000co`0co`003c?o00030000oooooooo0:Coool001koool00ol0VOooooooo`16oooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool001koool00ol0VOooooooo`16oooo00<0000co`0co`003c?o
00030000oooooooo0:Coool001koool00ol0VOooooooo`16oooo0P00010co`000`000?ooooooo`2T
oooo000Noooo00?o09Woooooool0A_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000N
oooo00?o09Woooooool0A_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Noooo00?o
09Woooooool0A_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Noooo00?o09Wooooo
ool0A_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Noooo00?o09Woooooool0A_oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000Noooo00?o09Woooooool0A_ooo`80000>
<ol000<0003oooooool0Y_ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`007_oo
o`03o`2Ioooooooo04Koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`007_ooo`03o`2I
oooooooo04Koool200003C?o00030000oooooooo0:Ooool001koool00ol0VOooooooo`16oooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool001koool00ol0VOooooooo`16oooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool001koool00ol0VOooooooo`16oooo00<0000co`0co`002c?o
00030000oooooooo0:Soool001koool00ol0VOooooooo`0ooooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`007_ooo`03o`2Ioooooooo03koool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`007_ooo`03o`2Ioooooooo043oool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000Noooo00?o09Woooooool0@Oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`007_ooo`03o`2Ioooooooo
03koool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`007_oo
o`03o`2Ioooooooo03ooool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000N
oooo00?o09Woooooool0A_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Noooo00?o
09Woooooool0A_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Noooo00?o09Wooooo
ool0A_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Noooo00?o09Woooooool0A_oo
o`80000;<ol000<0003oooooool0ZOooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`007_oo
o`03o`2Ioooooooo04Koool200002S?o00030000oooooooo0:[oool001koool00ol0VOooooooo`16
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool001koool00ol0VOooooooo`16oooo00<0
000co`0co`002C?o00030000oooooooo0:[oool001koool00ol0VOooooooo`16oooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool001koool00ol0VOooooooo`16oooo00<0000co`0co`0023?o
00030000oooooooo0:_oool001koool00ol0VOooooooo`16oooo00<0000co`0co`0023?o00030000
oooooooo0:_oool001koool00ol0VOooooooo`16oooo0P0000Tco`000`000?ooooooo`2[oooo000N
oooo00?o09Woooooool0A_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Noooo00?o
09Woooooool0A_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Noooo00?o09Wooooo
ool0A_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Noooo00?o09Woooooool0A_oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Noooo00?o09Woooooool0A_ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000Noooo00?o09Woooooool0A_ooo`800008<ol000<0
003oooooool0[?ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`007_ooo`03o`2Ioooooooo04Koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`007_oo
o`03o`2Ioooooooo04Koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`007_ooo`03o`2I
oooooooo043oool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Noooo00?o
09Woooooool0@Oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`007_ooo`03o`2Ioooooooo03koool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol02Ooo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001Woooo2C?o00Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool006Ooool9<ol02?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo0`0000Coool00`000?oo
ooooo`1hoooo001Woooo2C?o00Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002_ooo`030000oooooooo00;oool0
0`000?ooooooo`1hoooo001Woooo2C?o00Ooool00`000?ooooooo`02oooo00<0003oooooool04ooo
o`040000oooooooo00002Oooo`<00004oooo00<0003oooooool0Moooo`00Ioooo`Tco`08oooo00<0
003oooooool01@0001;oool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001Woooo2C?o00Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Ioooo`Tco`09oooo00<0003ooooo
ool05oooo`80000:oooo0`0000;oool00`000?ooooooo`1ioooo001Woooo2C?o0;3oool006Ooool8
<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {290.125, 148.813}} -> {-0.349561, \
1.05307, 0.00349883, 0.00566123}, {{79.875, 308.563}, {290.125, 148.813}} -> \
{-2.52168, 4.80237, 0.0124465, 0.0319664}, {{79.875, 308.563}, {290.125, \
148.813}} -> {-2.52168, 4.80237, 0.0124465, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.88) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.05546 .12361 L
.05789 .12361 L
.06007 .12361 L
.06131 .12361 L
s
.06131 .12361 m
.06176 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.88) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooool0V@05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`07oooo00?o
09Woooooool06oooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool0023oool00ol0VOooooooo`14
oooo00<0000co`0co`00Ac?o00D0001Zoooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol0
048co`050000Koooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000m<ol01@0007Coool0
023oool00ol0VOooooooo`14oooo00<0000co`0co`00>C?o00@0001ioooo000Poooo00?o09Wooooo
ool0A?ooo`80000h<ol00P0007goool0023oool00ol0VOooooooo`14oooo00<0000co`0co`00=C?o
0080001ooooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol003<co`020000POooo`008?oo
o`03o`2Ioooooooo04Coool00`0003?o03?o000a<ol00P0008?oool0023oool00ol0VOooooooo`14
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool0023oool00ol0VOooooooo`14oooo00<0
000co`0co`00;S?o00800026oooo000Poooo00?o09Woooooool0A?ooo`80000]<ol00P0008Soool0
023oool00ol0VOooooooo`14oooo00<0000co`0co`00:c?o00030000oooooooo08Soool0023oool0
0ol0VOooooooo`14oooo00<0000co`0co`00:S?o00030000oooooooo08Woool0023oool00ol0VOoo
ooooo`14oooo00<0000co`0co`00:C?o00030000oooooooo08[oool0023oool00ol0VOooooooo`14
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool0023oool00ol0VOooooooo`14oooo00<0
000co`0co`00:3?o00030000oooooooo08_oool0023oool00ol0VOooooooo`14oooo0P0002Pco`00
0`000?ooooooo`2<oooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000P
oooo00?o09Woooooool0A?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Poooo00?o
09Woooooool0A?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Poooo00?o09Wooooo
ool0A?ooo`80000S<ol000<0003oooooool0TOooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`008?ooo`03o`2Ioooooooo03coool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000Poooo00?o09Woooooool0?_ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`008?ooo`03o`2Ioooooooo03koool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000Poooo00?o09Woooooool0?_ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`008?ooo`03o`2Ioooooooo03koool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool0023oool00ol0VOooooooo`0m
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`008?ooo`03o`2Ioooooooo
04Coool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`008?ooo`03o`2Ioooooooo04Coool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`008?ooo`03o`2Ioooooooo04Coool2000073?o
00030000oooooooo09Soool0023oool00ol0VOooooooo`14oooo00<0000co`0co`006S?o00030000
oooooooo09Woool0023oool00ol0VOooooooo`14oooo00<0000co`0co`006S?o00030000oooooooo
09Woool0023oool00ol0VOooooooo`14oooo00<0000co`0co`006C?o00030000oooooooo09[oool0
023oool00ol0VOooooooo`14oooo00<0000co`0co`006C?o00030000oooooooo09[oool0023oool0
0ol0VOooooooo`14oooo00<0000co`0co`0063?o00030000oooooooo09_oool0023oool00ol0VOoo
ooooo`14oooo0P0001Tco`000`000?ooooooo`2Koooo000Poooo00?o09Woooooool0A?ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000P
oooo00?o09Woooooool0A?ooo`80000F<ol000<0003oooooool0W_ooo`008?ooo`03o`2Ioooooooo
04Coool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`008?ooo`03o`2Ioooooooo04Coool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`008?ooo`03o`2Ioooooooo04Coool200005C?o00030000oooooooo09ooool0
023oool00ol0VOooooooo`14oooo00<0000co`0co`004c?o00030000oooooooo0:3oool0023oool0
0ol0VOooooooo`14oooo00<0000co`0co`004c?o00030000oooooooo0:3oool0023oool00ol0VOoo
ooooo`14oooo00<0000co`0co`004c?o00030000oooooooo0:3oool0023oool00ol0VOooooooo`0l
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`008?ooo`03o`2Ioooooooo
03coool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool0023oool0
0ol0VOooooooo`0moooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`008?oo
o`03o`2Ioooooooo03koool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool0023oool00ol0VOooooooo`0loooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool0023oool00ol0VOooooooo`0moooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`008?ooo`03o`2Ioooooooo04Coool200004C?o00030000oooooooo0:?oool0023oool0
0ol0VOooooooo`14oooo00<0000co`0co`0043?o00030000oooooooo0:?oool0023oool00ol0VOoo
ooooo`14oooo00<0000co`0co`0043?o00030000oooooooo0:?oool0023oool00ol0VOooooooo`14
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool0023oool00ol0VOooooooo`14oooo00<0
000co`0co`003c?o00030000oooooooo0:Coool0023oool00ol0VOooooooo`14oooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool0023oool00ol0VOooooooo`14oooo00<0000co`0co`003c?o
00030000oooooooo0:Coool0023oool00ol0VOooooooo`14oooo0P00010co`000`000?ooooooo`2T
oooo000Poooo00?o09Woooooool0A?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000P
oooo00?o09Woooooool0A?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Poooo00?o
09Woooooool0A?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Poooo00?o09Wooooo
ool0A?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Poooo00?o09Woooooool0A?oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000Poooo00?o09Woooooool0A?ooo`80000>
<ol000<0003oooooool0Y_ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`008?oo
o`03o`2Ioooooooo04Coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`008?ooo`03o`2I
oooooooo04Coool200003C?o00030000oooooooo0:Ooool0023oool00ol0VOooooooo`14oooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool0023oool00ol0VOooooooo`14oooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool0023oool00ol0VOooooooo`14oooo00<0000co`0co`002c?o
00030000oooooooo0:Soool0023oool00ol0VOooooooo`0moooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`008?ooo`03o`2Ioooooooo03coool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`008?ooo`03o`2Ioooooooo03koool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000Poooo00?o09Woooooool0?oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`008?ooo`03o`2Ioooooooo
03coool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`008?oo
o`03o`2Ioooooooo03goool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000P
oooo00?o09Woooooool0A?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Poooo00?o
09Woooooool0A?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Poooo00?o09Wooooo
ool0A?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Poooo00?o09Woooooool0A?oo
o`80000;<ol000<0003oooooool0ZOooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`008?oo
o`03o`2Ioooooooo04Coool200002S?o00030000oooooooo0:[oool0023oool00ol0VOooooooo`14
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool0023oool00ol0VOooooooo`14oooo00<0
000co`0co`002C?o00030000oooooooo0:[oool0023oool00ol0VOooooooo`14oooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool0023oool00ol0VOooooooo`14oooo00<0000co`0co`0023?o
00030000oooooooo0:_oool0023oool00ol0VOooooooo`14oooo00<0000co`0co`0023?o00030000
oooooooo0:_oool0023oool00ol0VOooooooo`14oooo0P0000Tco`000`000?ooooooo`2[oooo000P
oooo00?o09Woooooool0A?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Poooo00?o
09Woooooool0A?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Poooo00?o09Wooooo
ool0A?ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Poooo00?o09Woooooool0A?oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Poooo00?o09Woooooool0A?ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000Poooo00?o09Woooooool0A?ooo`800008<ol000<0
003oooooool0[?ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`008?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`008?oo
o`03o`2Ioooooooo04Coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`008?ooo`03o`2I
oooooooo03koool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Poooo00?o
09Woooooool0?oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`008?ooo`03o`2Ioooooooo03coool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000Coool200001?oo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00Ioooo`Tco`04oooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Soool010000?ooooooo`00
00;oool010000?ooooooo`0000Coool00`000?ooooooo`1doooo001Woooo2C?o00Goool00`000?oo
ooooo`0500004_ooo`040000oooooooo00002Oooo`800004oooo0P0000Coool00`000?ooooooo`1e
oooo001Woooo2C?o00Goool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0
003oooooool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00Ioooo`Tco`06
oooo00<0003oooooool05oooo`80000:oooo0P0000Coool200000oooo`030000oooooooo07Koool0
06Ooool9<ol0/?ooo`00Ioooo`Pco`2aoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.86) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.04262 .12361 L
.0522 .12361 L
.06244 .12361 L
.06525 .12361 L
.06662 .12361 L
.0679 .12361 L
s
.0679 .12361 m
.06836 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.86) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool010000?ooooooool0
V@Coool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo00Soool0
0ol0VOooooooo`0Joooo00<0003oooooool09_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T
<ol0400001Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`008Oooo`03o`2Ioooooooo
04?oool00`0003?o03?o0017<ol01@0006[oool0027oool00ol0VOooooooo`13oooo00<0000co`0c
o`00@S?o00D0001_oooo000Qoooo00?o09Woooooool0@oooo`030000<ol0<ol003dco`050000M?oo
o`008Oooo`03o`2Ioooooooo04?oool00`0003?o03?o000i<ol0100007Woool0027oool00ol0VOoo
ooooo`13oooo0P0003Pco`020000OOooo`008Oooo`03o`2Ioooooooo04?oool00`0003?o03?o000e
<ol00P0007ooool0027oool00ol0VOooooooo`13oooo00<0000co`0co`00<c?o00800021oooo000Q
oooo00?o09Woooooool0@oooo`030000<ol0<ol0034co`020000Poooo`008Oooo`03o`2Ioooooooo
04?oool00`0003?o03?o000`<ol000<0003oooooool0Poooo`008Oooo`03o`2Ioooooooo04?oool0
0`0003?o03?o000^<ol00P0008Koool0027oool00ol0VOooooooo`13oooo0P0002dco`020000R?oo
o`008Oooo`03o`2Ioooooooo04?oool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`008Ooo
o`03o`2Ioooooooo04?oool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`008Oooo`03o`2I
oooooooo04?oool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`008Oooo`03o`2Ioooooooo
04?oool00`0003?o03?o000X<ol000<0003oooooool0Roooo`008Oooo`03o`2Ioooooooo04?oool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`008Oooo`03o`2Ioooooooo04?oool20000:3?o
00030000oooooooo08coool0027oool00ol0VOooooooo`13oooo00<0000co`0co`009S?o00030000
oooooooo08goool0027oool00ol0VOooooooo`13oooo00<0000co`0co`009C?o00030000oooooooo
08koool0027oool00ol0VOooooooo`13oooo00<0000co`0co`0093?o00030000oooooooo08ooool0
027oool00ol0VOooooooo`13oooo00<0000co`0co`008c?o00030000oooooooo093oool0027oool0
0ol0VOooooooo`13oooo00<0000co`0co`008c?o00030000oooooooo093oool0027oool00ol0VOoo
ooooo`13oooo0P0002<co`000`000?ooooooo`2Aoooo000Qoooo00?o09Woooooool0@oooo`030000
<ol0<ol0024co`000`000?ooooooo`2Boooo000Qoooo00?o09Woooooool0@oooo`030000<ol0<ol0
020co`000`000?ooooooo`2Coooo000Qoooo00?o09Woooooool0@oooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo000Qoooo00?o09Woooooool0@oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000Qoooo00?o09Woooooool0>oooo`D00003oooo00<0000co`0co`007c?o00030000
oooooooo09Coool0027oool00ol0VOooooooo`0moooo00<0003oooooool00oooo`030000<ol0<ol0
01hco`000`000?ooooooo`2Eoooo000Qoooo00?o09Woooooool0?Oooo`030000oooooooo00?oool2
00007c?o00030000oooooooo09Goool0027oool00ol0VOooooooo`0moooo00<0003oooooool00ooo
o`030000<ol0<ol001dco`000`000?ooooooo`2Foooo000Qoooo00?o09Woooooool0?Oooo`030000
oooooooo00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`008Oooo`03o`2Ioooooooo
03coool200001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000Qoooo00?o09Wooooo
ool0@oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000Qoooo00?o09Woooooool0@ooo
o`030000<ol0<ol001/co`000`000?ooooooo`2Hoooo000Qoooo00?o09Woooooool0@oooo`80000L
<ol000<0003oooooool0V?ooo`008Oooo`03o`2Ioooooooo04?oool00`0003?o03?o000J<ol000<0
003oooooool0VOooo`008Oooo`03o`2Ioooooooo04?oool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`008Oooo`03o`2Ioooooooo04?oool00`0003?o03?o000I<ol000<0003oooooool0V_oo
o`008Oooo`03o`2Ioooooooo04?oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`008Ooo
o`03o`2Ioooooooo04?oool00`0003?o03?o000H<ol000<0003oooooool0Voooo`008Oooo`03o`2I
oooooooo04?oool200006C?o00030000oooooooo09_oool0027oool00ol0VOooooooo`13oooo00<0
000co`0co`005c?o00030000oooooooo09coool0027oool00ol0VOooooooo`13oooo00<0000co`0c
o`005c?o00030000oooooooo09coool0027oool00ol0VOooooooo`13oooo00<0000co`0co`005S?o
00030000oooooooo09goool0027oool00ol0VOooooooo`13oooo00<0000co`0co`005S?o00030000
oooooooo09goool0027oool00ol0VOooooooo`13oooo00<0000co`0co`005S?o00030000oooooooo
09goool0027oool00ol0VOooooooo`13oooo00<0000co`0co`005C?o00030000oooooooo09koool0
027oool00ol0VOooooooo`13oooo0P0001Hco`000`000?ooooooo`2Noooo000Qoooo00?o09Wooooo
ool0@oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000Qoooo00?o09Woooooool0@ooo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000Qoooo00?o09Woooooool0@oooo`030000
<ol0<ol001@co`000`000?ooooooo`2Ooooo000Qoooo00?o09Woooooool0@oooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo000Qoooo00?o09Woooooool0@oooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo000Qoooo00?o09Woooooool0@oooo`80000E<ol000<0003oooooool0Wooo
o`008Oooo`03o`2Ioooooooo04?oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`008Ooo
o`03o`2Ioooooooo04?oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`008Oooo`03o`2I
oooooooo04?oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`008Oooo`03o`2Ioooooooo
03_oool400001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo000Qoooo00?o09Wooooo
ool0>oooo`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`008Ooo
o`03o`2Ioooooooo03coool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo000R
oooo00?o09Woooooool0??ooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003ooooo
ool0XOooo`008_ooo`03o`2Ioooooooo03[oool010000?ooooooo`0000Coool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`008_ooo`03o`2Ioooooooo03_oool200001Oooo`030000<ol0<ol0
014co`000`000?ooooooo`2Roooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo000Roooo00?o09Woooooool0@_ooo`80000A<ol000<0003oooooool0Xoooo`008_oo
o`03o`2Ioooooooo04;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`008_ooo`03o`2I
oooooooo04;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`008_ooo`03o`2Ioooooooo
04;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`008_ooo`03o`2Ioooooooo04;oool0
0`0003?o03?o000?<ol000<0003oooooool0Y?ooo`008_ooo`03o`2Ioooooooo04;oool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`008_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`008_ooo`03o`2Ioooooooo04;oool2000043?o00030000oooooooo
0:Coool002;oool00ol0VOooooooo`12oooo00<0000co`0co`003S?o00030000oooooooo0:Goool0
02;oool00ol0VOooooooo`12oooo00<0000co`0co`003S?o00030000oooooooo0:Goool002;oool0
0ol0VOooooooo`12oooo00<0000co`0co`003S?o00030000oooooooo0:Goool002;oool00ol0VOoo
ooooo`12oooo00<0000co`0co`003S?o00030000oooooooo0:Goool002;oool00ol0VOooooooo`12
oooo00<0000co`0co`003C?o00030000oooooooo0:Koool002;oool00ol0VOooooooo`12oooo0P00
00hco`000`000?ooooooo`2Voooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000dco`00
0`000?ooooooo`2Voooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000`co`000`000?ooooooo`2W
oooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000R
oooo00?o09Woooooool0@_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000Roooo00?o
09Woooooool0@_ooo`80000=<ol000<0003oooooool0Yoooo`008_ooo`03o`2Ioooooooo04;oool0
0`0003?o03?o000<<ol000<0003oooooool0Yoooo`008_ooo`03o`2Ioooooooo04;oool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`008_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`008_ooo`03o`2Ioooooooo03_oool200001Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`2Xoooo000Roooo00?o09Woooooool0>_ooo`040000oooooooo00001?oo
o`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000Roooo00?o09Woooooool0??ooo`030000
oooooooo00?oool2000033?o00030000oooooooo0:Soool002;oool00ol0VOooooooo`0moooo00<0
003oooooool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000Roooo00?o09Wooooo
ool0>_ooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000R
oooo00?o09Woooooool0>oooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0
02;oool00ol0VOooooooo`12oooo00<0000co`0co`002S?o00030000oooooooo0:Woool002;oool0
0ol0VOooooooo`12oooo00<0000co`0co`002S?o00030000oooooooo0:Woool002;oool00ol0VOoo
ooooo`12oooo00<0000co`0co`002S?o00030000oooooooo0:Woool002;oool00ol0VOooooooo`12
oooo0P0000/co`000`000?ooooooo`2Yoooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol0
00Xco`000`000?ooooooo`2Yoooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`2Zoooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000R
oooo00?o09Woooooool0@_ooo`80000:<ol000<0003oooooool0Z_ooo`008_ooo`03o`2Ioooooooo
04;oool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`008_ooo`03o`2Ioooooooo04;oool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`008_ooo`03o`2Ioooooooo04;oool00`0003?o
03?o0008<ol000<0003oooooool0Zoooo`008_ooo`03o`2Ioooooooo04;oool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`008_ooo`03o`2Ioooooooo04;oool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`008_ooo`03o`2Ioooooooo04;oool200002C?o00030000oooooooo0:_oool0
02;oool00ol0VOooooooo`12oooo00<0000co`0co`0023?o00030000oooooooo0:_oool002;oool0
0ol0VOooooooo`12oooo00<0000co`0co`0023?o00030000oooooooo0:_oool002;oool00ol0VOoo
ooooo`12oooo00<0000co`0co`001c?o00030000oooooooo0:coool002;oool00ol0VOooooooo`12
oooo00<0000co`0co`001c?o00030000oooooooo0:coool002;oool00ol0VOooooooo`12oooo00<0
000co`0co`001c?o00030000oooooooo0:coool002;oool00ol0VOooooooo`12oooo0P0000Pco`00
0`000?ooooooo`2/oooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000Lco`000`000?oo
ooooo`2/oooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000Roooo00?o09Woooooool0@_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000R
oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Roooo00?o
09Woooooool0??ooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool002;oool0
0ol0VOooooooo`0moooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000Roooo00?o09Woooooool0>_ooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001O
oooo00@0003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0
067oool200001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo
00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Coool200000oooo`<00004
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001Woooo2C?o00Coool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo
00000_ooo`040000oooooooo00001?ooo`030000oooooooo07Coool006Ooool9<ol01Oooo`030000
oooooooo00D0000Boooo00@0003oooooool00009oooo0P0000?oool300001?ooo`030000oooooooo
07Goool006Ooool9<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`03oooo00<0003oooooool0MOooo`00Ioooo`Tco`06
oooo00<0003oooooool05oooo`80000:oooo0P0000Coool300000_ooo`030000oooooooo07Koool0
06Ooool9<ol0/?ooo`00Ioooo`Pco`2aoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.84) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.04262 .12361 L
.06244 .12361 L
.06747 .12361 L
.07024 .12361 L
.0716 .12361 L
.07286 .12361 L
.07404 .12361 L
s
.07404 .12361 m
.07454 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.84) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`02
oooo00Co09Woooooool00007oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo00[oool0
0ol0VOooooooo`0Hoooo00<0003oooooool09_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T
<ol0400001Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`008oooo`03o`2Ioooooooo
047oool00`0003?o03?o0017<ol01@0006[oool002?oool00ol0VOooooooo`11oooo00<0000co`0c
o`00@S?o00D0001_oooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol003dco`050000M?oo
o`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000i<ol0100007Woool002?oool00ol0VOoo
ooooo`11oooo0P0003Pco`020000OOooo`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000e
<ol00P0007ooool002?oool00ol0VOooooooo`11oooo00<0000co`0co`00<c?o00800021oooo000S
oooo00?o09Woooooool0@Oooo`030000<ol0<ol0034co`020000Poooo`008oooo`03o`2Ioooooooo
047oool00`0003?o03?o000`<ol000<0003oooooool0Poooo`008oooo`03o`2Ioooooooo047oool0
0`0003?o03?o000^<ol00P0008Koool002?oool00ol0VOooooooo`11oooo0P0002dco`020000R?oo
o`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`008ooo
o`03o`2Ioooooooo047oool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`008oooo`03o`2I
oooooooo047oool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`008oooo`03o`2Ioooooooo
047oool00`0003?o03?o000X<ol000<0003oooooool0Roooo`008oooo`03o`2Ioooooooo047oool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`008oooo`03o`2Ioooooooo047oool20000:3?o
00030000oooooooo08coool002?oool00ol0VOooooooo`11oooo00<0000co`0co`009S?o00030000
oooooooo08goool002?oool00ol0VOooooooo`11oooo00<0000co`0co`009C?o00030000oooooooo
08koool002?oool00ol0VOooooooo`11oooo00<0000co`0co`0093?o00030000oooooooo08ooool0
02?oool00ol0VOooooooo`11oooo00<0000co`0co`008c?o00030000oooooooo093oool002?oool0
0ol0VOooooooo`11oooo00<0000co`0co`008c?o00030000oooooooo093oool002?oool00ol0VOoo
ooooo`11oooo0P0002<co`000`000?ooooooo`2Aoooo000Soooo00?o09Woooooool0@Oooo`030000
<ol0<ol0024co`000`000?ooooooo`2Boooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol0
020co`000`000?ooooooo`2Coooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000Soooo00?o09Woooooool0>Oooo`D00003oooo00<0000co`0co`007c?o00030000
oooooooo09Coool002?oool00ol0VOooooooo`0koooo00<0003oooooool00oooo`030000<ol0<ol0
01hco`000`000?ooooooo`2Eoooo000Soooo00?o09Woooooool0>oooo`030000oooooooo00?oool2
00007c?o00030000oooooooo09Goool002?oool00ol0VOooooooo`0koooo00<0003oooooool00ooo
o`030000<ol0<ol001dco`000`000?ooooooo`2Foooo000Soooo00?o09Woooooool0>oooo`030000
oooooooo00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`008oooo`03o`2Ioooooooo
03[oool200001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000Soooo00?o09Wooooo
ool0@Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000Soooo00?o09Woooooool0@Ooo
o`030000<ol0<ol001/co`000`000?ooooooo`2Hoooo000Soooo00?o09Woooooool0@Oooo`80000L
<ol000<0003oooooool0V?ooo`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000J<ol000<0
003oooooool0VOooo`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000I<ol000<0003oooooool0V_oo
o`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`008ooo
o`03o`2Ioooooooo047oool00`0003?o03?o000H<ol000<0003oooooool0Voooo`008oooo`03o`2I
oooooooo047oool200006C?o00030000oooooooo09_oool002?oool00ol0VOooooooo`11oooo00<0
000co`0co`005c?o00030000oooooooo09coool002?oool00ol0VOooooooo`11oooo00<0000co`0c
o`005c?o00030000oooooooo09coool002?oool00ol0VOooooooo`11oooo00<0000co`0co`005S?o
00030000oooooooo09goool002?oool00ol0VOooooooo`11oooo00<0000co`0co`005S?o00030000
oooooooo09goool002?oool00ol0VOooooooo`11oooo00<0000co`0co`005S?o00030000oooooooo
09goool002?oool00ol0VOooooooo`11oooo00<0000co`0co`005C?o00030000oooooooo09koool0
02?oool00ol0VOooooooo`11oooo0P0001Hco`000`000?ooooooo`2Noooo000Soooo00?o09Wooooo
ool0@Oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000Soooo00?o09Woooooool0@Ooo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000Soooo00?o09Woooooool0@Oooo`030000
<ol0<ol001@co`000`000?ooooooo`2Ooooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo000Soooo00?o09Woooooool0@Oooo`80000E<ol000<0003oooooool0Wooo
o`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`008ooo
o`03o`2Ioooooooo047oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`008oooo`03o`2I
oooooooo047oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`008oooo`03o`2Ioooooooo
03Woool400001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo000Soooo00?o09Wooooo
ool0>Oooo`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`008ooo
o`03o`2Ioooooooo03[oool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo000S
oooo00?o09Woooooool0>oooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003ooooo
ool0XOooo`008oooo`03o`2Ioooooooo03Woool010000?ooooooo`0000Coool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`008oooo`03o`2Ioooooooo03[oool200001Oooo`030000<ol0<ol0
014co`000`000?ooooooo`2Roooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo000Soooo00?o09Woooooool0@Oooo`80000A<ol000<0003oooooool0Xoooo`008ooo
o`03o`2Ioooooooo047oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`008oooo`03o`2I
oooooooo047oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`008oooo`03o`2Ioooooooo
047oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`008oooo`03o`2Ioooooooo047oool0
0`0003?o03?o000?<ol000<0003oooooool0Y?ooo`008oooo`03o`2Ioooooooo047oool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`008oooo`03o`2Ioooooooo047oool2000043?o00030000oooooooo
0:Coool002?oool00ol0VOooooooo`11oooo00<0000co`0co`003S?o00030000oooooooo0:Goool0
02?oool00ol0VOooooooo`11oooo00<0000co`0co`003S?o00030000oooooooo0:Goool002?oool0
0ol0VOooooooo`11oooo00<0000co`0co`003S?o00030000oooooooo0:Goool002?oool00ol0VOoo
ooooo`11oooo00<0000co`0co`003S?o00030000oooooooo0:Goool002?oool00ol0VOooooooo`11
oooo00<0000co`0co`003C?o00030000oooooooo0:Koool002?oool00ol0VOooooooo`11oooo0P00
00hco`000`000?ooooooo`2Voooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000dco`00
0`000?ooooooo`2Voooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000`co`000`000?ooooooo`2W
oooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000S
oooo00?o09Woooooool0@Oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000Soooo00?o
09Woooooool0@Oooo`80000=<ol000<0003oooooool0Yoooo`008oooo`03o`2Ioooooooo047oool0
0`0003?o03?o000<<ol000<0003oooooool0Yoooo`008oooo`03o`2Ioooooooo047oool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`008oooo`03o`2Ioooooooo047oool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`008oooo`03o`2Ioooooooo03[oool200001Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`2Xoooo000Soooo00?o09Woooooool0>Oooo`040000oooooooo00001?oo
o`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000Soooo00?o09Woooooool0>oooo`030000
oooooooo00?oool2000033?o00030000oooooooo0:Soool002?oool00ol0VOooooooo`0loooo00<0
003oooooool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000Soooo00?o09Wooooo
ool0>Oooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000S
oooo00?o09Woooooool0>_ooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0
02?oool00ol0VOooooooo`11oooo00<0000co`0co`002S?o00030000oooooooo0:Woool002?oool0
0ol0VOooooooo`11oooo00<0000co`0co`002S?o00030000oooooooo0:Woool002?oool00ol0VOoo
ooooo`11oooo00<0000co`0co`002S?o00030000oooooooo0:Woool002?oool00ol0VOooooooo`11
oooo0P0000/co`000`000?ooooooo`2Yoooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol0
00Xco`000`000?ooooooo`2Yoooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000Tco`00
0`000?ooooooo`2Zoooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000S
oooo00?o09Woooooool0@Oooo`80000:<ol000<0003oooooool0Z_ooo`008oooo`03o`2Ioooooooo
047oool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`008oooo`03o`2Ioooooooo047oool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`008oooo`03o`2Ioooooooo047oool00`0003?o
03?o0008<ol000<0003oooooool0Zoooo`008oooo`03o`2Ioooooooo047oool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`008oooo`03o`2Ioooooooo047oool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`008oooo`03o`2Ioooooooo047oool200002C?o00030000oooooooo0:_oool0
02?oool00ol0VOooooooo`11oooo00<0000co`0co`0023?o00030000oooooooo0:_oool002?oool0
0ol0VOooooooo`11oooo00<0000co`0co`0023?o00030000oooooooo0:_oool002?oool00ol0VOoo
ooooo`11oooo00<0000co`0co`001c?o00030000oooooooo0:coool002?oool00ol0VOooooooo`11
oooo00<0000co`0co`001c?o00030000oooooooo0:coool002?oool00ol0VOooooooo`11oooo00<0
000co`0co`001c?o00030000oooooooo0:coool002?oool00ol0VOooooooo`11oooo0P0000Pco`00
0`000?ooooooo`2/oooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000Lco`000`000?oo
ooooo`2/oooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000Soooo00?o09Woooooool0@Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000S
oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Soooo00?o
09Woooooool0>oooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool002?oool0
0ol0VOooooooo`0loooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000Soooo00?o09Woooooool0>Oooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001O
oooo00@0003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0
067oool200001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo
00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Coool200001Oooo`<00002
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool01@000?ooooooooooo`00001goooo001Woooo2C?o00Coool00`000?ooooooo`02
oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`D00003
oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000Woool200000oooo`040000oooooooo00000oooo`030000oooooooo07Goool006Ooool9
<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`00
00?oool00`000?ooo`000003oooo00<0003oooooool0MOooo`00Ioooo`Tco`06oooo00<0003ooooo
ool05oooo`80000:oooo0P0000Goool200000_ooo`030000oooooooo07Koool006Ooool9<ol0/?oo
o`00Ioooo`Pco`2aoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.82) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.04262 .12361 L
.06244 .12361 L
.06747 .12361 L
.07286 .12361 L
.07547 .12361 L
.07793 .12361 L
.07901 .12361 L
.08015 .12361 L
s
.08015 .12361 m
.08065 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.82) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`04
oooo00?o09T0003oool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0<oooo00?o
09Woooooool05_ooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool002Goool00ol0VOooooooo`0o
oooo00<0000co`0co`00Ac?o00D0001Zoooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol0
048co`050000Koooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000m<ol01@0007Coool0
02Goool00ol0VOooooooo`0ooooo00<0000co`0co`00>C?o00@0001ioooo000Uoooo00?o09Wooooo
ool0?oooo`80000h<ol00P0007goool002Goool00ol0VOooooooo`0ooooo00<0000co`0co`00=C?o
0080001ooooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol003<co`020000POooo`009Ooo
o`03o`2Ioooooooo03ooool00`0003?o03?o000a<ol00P0008?oool002Goool00ol0VOooooooo`0o
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool002Goool00ol0VOooooooo`0ooooo00<0
000co`0co`00;S?o00800026oooo000Uoooo00?o09Woooooool0?oooo`80000]<ol00P0008Soool0
02Goool00ol0VOooooooo`0ooooo00<0000co`0co`00:c?o00030000oooooooo08Soool002Goool0
0ol0VOooooooo`0ooooo00<0000co`0co`00:S?o00030000oooooooo08Woool002Goool00ol0VOoo
ooooo`0ooooo00<0000co`0co`00:C?o00030000oooooooo08[oool002Goool00ol0VOooooooo`0o
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool002Goool00ol0VOooooooo`0ooooo00<0
000co`0co`00:3?o00030000oooooooo08_oool002Goool00ol0VOooooooo`0ooooo0P0002Pco`00
0`000?ooooooo`2<oooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000U
oooo00?o09Woooooool0?oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Uoooo00?o
09Woooooool0?oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Uoooo00?o09Wooooo
ool0?oooo`80000S<ol000<0003oooooool0TOooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`009Oooo`03o`2Ioooooooo03Ooool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000Uoooo00?o09Woooooool0>Oooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`009Oooo`03o`2Ioooooooo03Woool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000Uoooo00?o09Woooooool0>Oooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`009Oooo`03o`2Ioooooooo03Woool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool002Goool00ol0VOooooooo`0h
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`009Oooo`03o`2Ioooooooo
03ooool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`009Oooo`03o`2Ioooooooo03ooool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`009Oooo`03o`2Ioooooooo03ooool2000073?o
00030000oooooooo09Soool002Goool00ol0VOooooooo`0ooooo00<0000co`0co`006S?o00030000
oooooooo09Woool002Goool00ol0VOooooooo`0ooooo00<0000co`0co`006S?o00030000oooooooo
09Woool002Goool00ol0VOooooooo`0ooooo00<0000co`0co`006C?o00030000oooooooo09[oool0
02Goool00ol0VOooooooo`0ooooo00<0000co`0co`006C?o00030000oooooooo09[oool002Goool0
0ol0VOooooooo`0ooooo00<0000co`0co`0063?o00030000oooooooo09_oool002Goool00ol0VOoo
ooooo`0ooooo0P0001Tco`000`000?ooooooo`2Koooo000Uoooo00?o09Woooooool0?oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000U
oooo00?o09Woooooool0?oooo`80000F<ol000<0003oooooool0W_ooo`009Oooo`03o`2Ioooooooo
03ooool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`009Oooo`03o`2Ioooooooo03ooool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`009Oooo`03o`2Ioooooooo03ooool200005C?o00030000oooooooo09ooool0
02Goool00ol0VOooooooo`0ooooo00<0000co`0co`004c?o00030000oooooooo0:3oool002Goool0
0ol0VOooooooo`0ooooo00<0000co`0co`004c?o00030000oooooooo0:3oool002Goool00ol0VOoo
ooooo`0ooooo00<0000co`0co`004c?o00030000oooooooo0:3oool002Goool00ol0VOooooooo`0g
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`009Oooo`03o`2Ioooooooo
03Ooool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool002Goool0
0ol0VOooooooo`0hoooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`009Ooo
o`03o`2Ioooooooo03Woool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool002Goool00ol0VOooooooo`0goooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool002Goool00ol0VOooooooo`0hoooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`009Oooo`03o`2Ioooooooo03ooool200004C?o00030000oooooooo0:?oool002Goool0
0ol0VOooooooo`0ooooo00<0000co`0co`0043?o00030000oooooooo0:?oool002Goool00ol0VOoo
ooooo`0ooooo00<0000co`0co`0043?o00030000oooooooo0:?oool002Goool00ol0VOooooooo`0o
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool002Goool00ol0VOooooooo`0ooooo00<0
000co`0co`003c?o00030000oooooooo0:Coool002Goool00ol0VOooooooo`0ooooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool002Goool00ol0VOooooooo`0ooooo00<0000co`0co`003c?o
00030000oooooooo0:Coool002Goool00ol0VOooooooo`0ooooo0P00010co`000`000?ooooooo`2T
oooo000Uoooo00?o09Woooooool0?oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000U
oooo00?o09Woooooool0?oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Uoooo00?o
09Woooooool0?oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Uoooo00?o09Wooooo
ool0?oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Uoooo00?o09Woooooool0?ooo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000Uoooo00?o09Woooooool0?oooo`80000>
<ol000<0003oooooool0Y_ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`009Ooo
o`03o`2Ioooooooo03ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`009Oooo`03o`2I
oooooooo03ooool200003C?o00030000oooooooo0:Ooool002Goool00ol0VOooooooo`0ooooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool002Goool00ol0VOooooooo`0ooooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool002Goool00ol0VOooooooo`0ooooo00<0000co`0co`002c?o
00030000oooooooo0:Soool002Goool00ol0VOooooooo`0hoooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`009Oooo`03o`2Ioooooooo03Ooool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`009Oooo`03o`2Ioooooooo03Woool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000Uoooo00?o09Woooooool0>_ooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`009Oooo`03o`2Ioooooooo
03Ooool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`009Ooo
o`03o`2Ioooooooo03Soool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000U
oooo00?o09Woooooool0?oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Uoooo00?o
09Woooooool0?oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Uoooo00?o09Wooooo
ool0?oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Uoooo00?o09Woooooool0?ooo
o`80000;<ol000<0003oooooool0ZOooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`009Ooo
o`03o`2Ioooooooo03ooool200002S?o00030000oooooooo0:[oool002Goool00ol0VOooooooo`0o
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool002Goool00ol0VOooooooo`0ooooo00<0
000co`0co`002C?o00030000oooooooo0:[oool002Goool00ol0VOooooooo`0ooooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool002Goool00ol0VOooooooo`0ooooo00<0000co`0co`0023?o
00030000oooooooo0:_oool002Goool00ol0VOooooooo`0ooooo00<0000co`0co`0023?o00030000
oooooooo0:_oool002Goool00ol0VOooooooo`0ooooo0P0000Tco`000`000?ooooooo`2[oooo000U
oooo00?o09Woooooool0?oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Uoooo00?o
09Woooooool0?oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Uoooo00?o09Wooooo
ool0?oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Uoooo00?o09Woooooool0?ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Uoooo00?o09Woooooool0?oooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000Uoooo00?o09Woooooool0?oooo`800008<ol000<0
003oooooool0[?ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`009Oooo`03o`2Ioooooooo03ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`009Ooo
o`03o`2Ioooooooo03ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`009Oooo`03o`2I
oooooooo03Woool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Uoooo00?o
09Woooooool0>_ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`009Oooo`03o`2Ioooooooo03Ooool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000?oool400000ooo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00002oooo00<0003oooooool01?ooo`030000oooooooo07Goool006Ooool9<ol01?ooo`030000
oooooooo00;oool00`000?ooooooo`0Coooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool01?ooo`030000oooooooo07Coool006Ooool9<ol01Oooo`030000oooooooo
00D0000Boooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`02oooo00<0003ooooo
ool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?oo
o`040000oooooooo00000_ooo`040000oooooooo00000oooo`030000oooooooo07Goool006Ooool9
<ol01_ooo`030000oooooooo01Ooool200002_ooo`800004oooo0P0000?oool00`000?ooooooo`1f
oooo001Woooo2C?o0;3oool006Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.04262 .12361 L
.06244 .12361 L
.07216 .12361 L
.0775 .12361 L
.08255 .12361 L
.08542 .12361 L
.0862 .12361 L
.08703 .12361 L
s
.08703 .12361 m
.08732 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0=oooo00?o
09Woooooool05Oooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool002Koool00ol0VOooooooo`0n
oooo00<0000co`0co`00Ac?o00D0001Zoooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol0
048co`050000Koooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000m<ol01@0007Coool0
02Koool00ol0VOooooooo`0noooo00<0000co`0co`00>C?o00@0001ioooo000Voooo00?o09Wooooo
ool0?_ooo`80000h<ol00P0007goool002Koool00ol0VOooooooo`0noooo00<0000co`0co`00=C?o
0080001ooooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol003<co`020000POooo`009_oo
o`03o`2Ioooooooo03koool00`0003?o03?o000a<ol00P0008?oool002Koool00ol0VOooooooo`0n
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool002Koool00ol0VOooooooo`0noooo00<0
000co`0co`00;S?o00800026oooo000Voooo00?o09Woooooool0?_ooo`80000]<ol00P0008Soool0
02Koool00ol0VOooooooo`0noooo00<0000co`0co`00:c?o00030000oooooooo08Soool002Koool0
0ol0VOooooooo`0noooo00<0000co`0co`00:S?o00030000oooooooo08Woool002Koool00ol0VOoo
ooooo`0noooo00<0000co`0co`00:C?o00030000oooooooo08[oool002Koool00ol0VOooooooo`0n
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool002Koool00ol0VOooooooo`0noooo00<0
000co`0co`00:3?o00030000oooooooo08_oool002Koool00ol0VOooooooo`0noooo0P0002Pco`00
0`000?ooooooo`2<oooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000V
oooo00?o09Woooooool0?_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Voooo00?o
09Woooooool0?_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Voooo00?o09Wooooo
ool0?_ooo`80000S<ol000<0003oooooool0TOooo`009_ooo`03o`2Ioooooooo03koool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`009_ooo`03o`2Ioooooooo03Koool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000Voooo00?o09Woooooool0>?ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`009_ooo`03o`2Ioooooooo03Soool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000Voooo00?o09Woooooool0>?ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`009_ooo`03o`2Ioooooooo03Soool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool002Koool00ol0VOooooooo`0g
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`009_ooo`03o`2Ioooooooo
03koool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`009_ooo`03o`2Ioooooooo03koool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`009_ooo`03o`2Ioooooooo03koool2000073?o
00030000oooooooo09Soool002Koool00ol0VOooooooo`0noooo00<0000co`0co`006S?o00030000
oooooooo09Woool002Koool00ol0VOooooooo`0noooo00<0000co`0co`006S?o00030000oooooooo
09Woool002Koool00ol0VOooooooo`0noooo00<0000co`0co`006C?o00030000oooooooo09[oool0
02Koool00ol0VOooooooo`0noooo00<0000co`0co`006C?o00030000oooooooo09[oool002Koool0
0ol0VOooooooo`0noooo00<0000co`0co`0063?o00030000oooooooo09_oool002Koool00ol0VOoo
ooooo`0noooo0P0001Tco`000`000?ooooooo`2Koooo000Voooo00?o09Woooooool0?_ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000V
oooo00?o09Woooooool0?_ooo`80000F<ol000<0003oooooool0W_ooo`009_ooo`03o`2Ioooooooo
03koool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`009_ooo`03o`2Ioooooooo03koool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`009_ooo`03o`2Ioooooooo03koool200005C?o00030000oooooooo09ooool0
02Koool00ol0VOooooooo`0noooo00<0000co`0co`004c?o00030000oooooooo0:3oool002Koool0
0ol0VOooooooo`0noooo00<0000co`0co`004c?o00030000oooooooo0:3oool002Koool00ol0VOoo
ooooo`0noooo00<0000co`0co`004c?o00030000oooooooo0:3oool002Koool00ol0VOooooooo`0f
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`009_ooo`03o`2Ioooooooo
03Koool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool002Koool0
0ol0VOooooooo`0goooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`009_oo
o`03o`2Ioooooooo03Soool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool002Koool00ol0VOooooooo`0foooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool002Koool00ol0VOooooooo`0goooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`009_ooo`03o`2Ioooooooo03koool200004C?o00030000oooooooo0:?oool002Koool0
0ol0VOooooooo`0noooo00<0000co`0co`0043?o00030000oooooooo0:?oool002Koool00ol0VOoo
ooooo`0noooo00<0000co`0co`0043?o00030000oooooooo0:?oool002Koool00ol0VOooooooo`0n
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool002Koool00ol0VOooooooo`0noooo00<0
000co`0co`003c?o00030000oooooooo0:Coool002Koool00ol0VOooooooo`0noooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool002Koool00ol0VOooooooo`0noooo00<0000co`0co`003c?o
00030000oooooooo0:Coool002Koool00ol0VOooooooo`0noooo0P00010co`000`000?ooooooo`2T
oooo000Voooo00?o09Woooooool0?_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000V
oooo00?o09Woooooool0?_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Voooo00?o
09Woooooool0?_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Voooo00?o09Wooooo
ool0?_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Voooo00?o09Woooooool0?_oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000Voooo00?o09Woooooool0?_ooo`80000>
<ol000<0003oooooool0Y_ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`009_oo
o`03o`2Ioooooooo03koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`009_ooo`03o`2I
oooooooo03koool200003C?o00030000oooooooo0:Ooool002Koool00ol0VOooooooo`0noooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool002Koool00ol0VOooooooo`0noooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool002Koool00ol0VOooooooo`0noooo00<0000co`0co`002c?o
00030000oooooooo0:Soool002Koool00ol0VOooooooo`0goooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`009_ooo`03o`2Ioooooooo03Koool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`009_ooo`03o`2Ioooooooo03Soool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000Voooo00?o09Woooooool0>Oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`009_ooo`03o`2Ioooooooo
03Koool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`009_oo
o`03o`2Ioooooooo03Ooool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000V
oooo00?o09Woooooool0?_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Voooo00?o
09Woooooool0?_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Voooo00?o09Wooooo
ool0?_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Voooo00?o09Woooooool0?_oo
o`80000;<ol000<0003oooooool0ZOooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`009_oo
o`03o`2Ioooooooo03koool200002S?o00030000oooooooo0:[oool002Koool00ol0VOooooooo`0n
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool002Koool00ol0VOooooooo`0noooo00<0
000co`0co`002C?o00030000oooooooo0:[oool002Koool00ol0VOooooooo`0noooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool002Koool00ol0VOooooooo`0noooo00<0000co`0co`0023?o
00030000oooooooo0:_oool002Koool00ol0VOooooooo`0noooo00<0000co`0co`0023?o00030000
oooooooo0:_oool002Koool00ol0VOooooooo`0noooo0P0000Tco`000`000?ooooooo`2[oooo000V
oooo00?o09Woooooool0?_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Voooo00?o
09Woooooool0?_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Voooo00?o09Wooooo
ool0?_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Voooo00?o09Woooooool0?_oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Voooo00?o09Woooooool0?_ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000Voooo00?o09Woooooool0?_ooo`800008<ol000<0
003oooooool0[?ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`009_ooo`03o`2Ioooooooo03koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`009_oo
o`03o`2Ioooooooo03koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`009_ooo`03o`2I
oooooooo03Soool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Voooo00?o
09Woooooool0>Oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`009_ooo`03o`2Ioooooooo03Koool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol02Ooo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001Woooo2C?o00Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool006Ooool9<ol02?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000Coool00`000?oo
ooooo`1hoooo001Woooo2C?o00Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool006Ooool9<ol01oooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0003oooooool0Moooo`00Iooo
o`Tco`08oooo00<0003oooooool01@0001;oool010000?ooooooo`0000Woool200001?ooo`030000
oooooooo07Soool006Ooool9<ol02?ooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001Woooo2C?o00Woool00`000?oo
ooooo`0Goooo0P0000[oool200000oooo`030000oooooooo07Woool006Ooool9<ol0/?ooo`00Iooo
o`Pco`2aoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.78) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.04262 .12361 L
.06244 .12361 L
.07216 .12361 L
.08255 .12361 L
.08562 .12361 L
.08852 .12361 L
.09113 .12361 L
.09184 .12361 L
.0926 .12361 L
.09325 .12361 L
s
.09325 .12361 m
.09353 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.78) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003ooooo09T01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0?oooo00?o
09Woooooool04oooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool002Soool00ol0VOooooooo`0l
oooo00<0000co`0co`00Ac?o00D0001Zoooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol0
048co`050000Koooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000m<ol01@0007Coool0
02Soool00ol0VOooooooo`0loooo00<0000co`0co`00>C?o00@0001ioooo000Xoooo00?o09Wooooo
ool0??ooo`80000h<ol00P0007goool002Soool00ol0VOooooooo`0loooo00<0000co`0co`00=C?o
0080001ooooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol003<co`020000POooo`00:?oo
o`03o`2Ioooooooo03coool00`0003?o03?o000a<ol00P0008?oool002Soool00ol0VOooooooo`0l
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool002Soool00ol0VOooooooo`0loooo00<0
000co`0co`00;S?o00800026oooo000Xoooo00?o09Woooooool0??ooo`80000]<ol00P0008Soool0
02Soool00ol0VOooooooo`0loooo00<0000co`0co`00:c?o00030000oooooooo08Soool002Soool0
0ol0VOooooooo`0loooo00<0000co`0co`00:S?o00030000oooooooo08Woool002Soool00ol0VOoo
ooooo`0loooo00<0000co`0co`00:C?o00030000oooooooo08[oool002Soool00ol0VOooooooo`0l
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool002Soool00ol0VOooooooo`0loooo00<0
000co`0co`00:3?o00030000oooooooo08_oool002Soool00ol0VOooooooo`0loooo0P0002Pco`00
0`000?ooooooo`2<oooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000X
oooo00?o09Woooooool0??ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Xoooo00?o
09Woooooool0??ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000Xoooo00?o09Wooooo
ool0??ooo`80000S<ol000<0003oooooool0TOooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00:?ooo`03o`2Ioooooooo03Coool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000Xoooo00?o09Woooooool0=_ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00:?ooo`03o`2Ioooooooo03Koool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000Xoooo00?o09Woooooool0=_ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00:?ooo`03o`2Ioooooooo03Koool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool002Soool00ol0VOooooooo`0e
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00:?ooo`03o`2Ioooooooo
03coool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00:?ooo`03o`2Ioooooooo03coool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00:?ooo`03o`2Ioooooooo03coool2000073?o
00030000oooooooo09Soool002Soool00ol0VOooooooo`0loooo00<0000co`0co`006S?o00030000
oooooooo09Woool002Soool00ol0VOooooooo`0loooo00<0000co`0co`006S?o00030000oooooooo
09Woool002Soool00ol0VOooooooo`0loooo00<0000co`0co`006C?o00030000oooooooo09[oool0
02Soool00ol0VOooooooo`0loooo00<0000co`0co`006C?o00030000oooooooo09[oool002Soool0
0ol0VOooooooo`0loooo00<0000co`0co`0063?o00030000oooooooo09_oool002Soool00ol0VOoo
ooooo`0loooo0P0001Tco`000`000?ooooooo`2Koooo000Xoooo00?o09Woooooool0??ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000X
oooo00?o09Woooooool0??ooo`80000F<ol000<0003oooooool0W_ooo`00:?ooo`03o`2Ioooooooo
03coool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00:?ooo`03o`2Ioooooooo03coool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00:?ooo`03o`2Ioooooooo03coool200005C?o00030000oooooooo09ooool0
02Soool00ol0VOooooooo`0loooo00<0000co`0co`004c?o00030000oooooooo0:3oool002Soool0
0ol0VOooooooo`0loooo00<0000co`0co`004c?o00030000oooooooo0:3oool002Soool00ol0VOoo
ooooo`0loooo00<0000co`0co`004c?o00030000oooooooo0:3oool002Soool00ol0VOooooooo`0d
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00:?ooo`03o`2Ioooooooo
03Coool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool002Soool0
0ol0VOooooooo`0eoooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00:?oo
o`03o`2Ioooooooo03Koool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool002Soool00ol0VOooooooo`0doooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool002Soool00ol0VOooooooo`0eoooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00:?ooo`03o`2Ioooooooo03coool200004C?o00030000oooooooo0:?oool002Soool0
0ol0VOooooooo`0loooo00<0000co`0co`0043?o00030000oooooooo0:?oool002Soool00ol0VOoo
ooooo`0loooo00<0000co`0co`0043?o00030000oooooooo0:?oool002Soool00ol0VOooooooo`0l
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool002Soool00ol0VOooooooo`0loooo00<0
000co`0co`003c?o00030000oooooooo0:Coool002Soool00ol0VOooooooo`0loooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool002Soool00ol0VOooooooo`0loooo00<0000co`0co`003c?o
00030000oooooooo0:Coool002Soool00ol0VOooooooo`0loooo0P00010co`000`000?ooooooo`2T
oooo000Xoooo00?o09Woooooool0??ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000X
oooo00?o09Woooooool0??ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Xoooo00?o
09Woooooool0??ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Xoooo00?o09Wooooo
ool0??ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000Xoooo00?o09Woooooool0??oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000Xoooo00?o09Woooooool0??ooo`80000>
<ol000<0003oooooool0Y_ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00:?oo
o`03o`2Ioooooooo03coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00:?ooo`03o`2I
oooooooo03coool200003C?o00030000oooooooo0:Ooool002Soool00ol0VOooooooo`0loooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool002Soool00ol0VOooooooo`0loooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool002Soool00ol0VOooooooo`0loooo00<0000co`0co`002c?o
00030000oooooooo0:Soool002Soool00ol0VOooooooo`0eoooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00:?ooo`03o`2Ioooooooo03Coool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00:?ooo`03o`2Ioooooooo03Koool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000Xoooo00?o09Woooooool0=oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00:?ooo`03o`2Ioooooooo
03Coool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00:?oo
o`03o`2Ioooooooo03Goool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000X
oooo00?o09Woooooool0??ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Xoooo00?o
09Woooooool0??ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Xoooo00?o09Wooooo
ool0??ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000Xoooo00?o09Woooooool0??oo
o`80000;<ol000<0003oooooool0ZOooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00:?oo
o`03o`2Ioooooooo03coool200002S?o00030000oooooooo0:[oool002Soool00ol0VOooooooo`0l
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool002Soool00ol0VOooooooo`0loooo00<0
000co`0co`002C?o00030000oooooooo0:[oool002Soool00ol0VOooooooo`0loooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool002Soool00ol0VOooooooo`0loooo00<0000co`0co`0023?o
00030000oooooooo0:_oool002Soool00ol0VOooooooo`0loooo00<0000co`0co`0023?o00030000
oooooooo0:_oool002Soool00ol0VOooooooo`0loooo0P0000Tco`000`000?ooooooo`2[oooo000X
oooo00?o09Woooooool0??ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Xoooo00?o
09Woooooool0??ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000Xoooo00?o09Wooooo
ool0??ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Xoooo00?o09Woooooool0??oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Xoooo00?o09Woooooool0??ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000Xoooo00?o09Woooooool0??ooo`800008<ol000<0
003oooooool0[?ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00:?ooo`03o`2Ioooooooo03coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00:?oo
o`03o`2Ioooooooo03coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00:?ooo`03o`2I
oooooooo03Koool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Xoooo00?o
09Woooooool0=oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00:?ooo`03o`2Ioooooooo03Coool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005oooo00<0003oooooool00_oo
o`800004oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000[oool0
1@000?ooooooooooo`000002oooo00D0003oooooooooool00000Moooo`00Ioooo`Tco`04oooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo07Coool006Ooool9<ol01Oooo`030000
oooooooo00D0000Boooo00@0003oooooool0000;oooo00@0003oooooooooool200001?ooo`030000
oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Soool010000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001W
oooo2C?o00Koool00`000?ooooooo`0Goooo0P0000Woool400000oooo`800003oooo00<0003ooooo
ool0M_ooo`00Ioooo`Tco`2`oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.76) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.04262 .12361 L
.06244 .12361 L
.08255 .12361 L
.08806 .12361 L
.09396 .12361 L
.09682 .12361 L
.09822 .12361 L
.09952 .12361 L
s
.09952 .12361 m
.09999 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.76) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00@0003ooooooooo09T4oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo013oool0
0ol0VOooooooo`0Boooo00<0003oooooool09_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T
<ol0400001Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00:Oooo`03o`2Ioooooooo
03_oool00`0003?o03?o0017<ol01@0006[oool002Woool00ol0VOooooooo`0koooo00<0000co`0c
o`00@S?o00D0001_oooo000Yoooo00?o09Woooooool0>oooo`030000<ol0<ol003dco`050000M?oo
o`00:Oooo`03o`2Ioooooooo03_oool00`0003?o03?o000i<ol0100007Woool002Woool00ol0VOoo
ooooo`0koooo0P0003Pco`020000OOooo`00:Oooo`03o`2Ioooooooo03_oool00`0003?o03?o000e
<ol00P0007ooool002Woool00ol0VOooooooo`0koooo00<0000co`0co`00<c?o00800021oooo000Y
oooo00?o09Woooooool0>oooo`030000<ol0<ol0034co`020000Poooo`00:Oooo`03o`2Ioooooooo
03_oool00`0003?o03?o000`<ol000<0003oooooool0Poooo`00:Oooo`03o`2Ioooooooo03_oool0
0`0003?o03?o000^<ol00P0008Koool002Woool00ol0VOooooooo`0koooo0P0002dco`020000R?oo
o`00:Oooo`03o`2Ioooooooo03_oool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00:Ooo
o`03o`2Ioooooooo03_oool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`00:Oooo`03o`2I
oooooooo03_oool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`00:Oooo`03o`2Ioooooooo
03_oool00`0003?o03?o000X<ol000<0003oooooool0Roooo`00:Oooo`03o`2Ioooooooo03_oool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`00:Oooo`03o`2Ioooooooo03_oool20000:3?o
00030000oooooooo08coool002Woool00ol0VOooooooo`0koooo00<0000co`0co`009S?o00030000
oooooooo08goool002Woool00ol0VOooooooo`0koooo00<0000co`0co`009C?o00030000oooooooo
08koool002Woool00ol0VOooooooo`0koooo00<0000co`0co`0093?o00030000oooooooo08ooool0
02Woool00ol0VOooooooo`0koooo00<0000co`0co`008c?o00030000oooooooo093oool002Woool0
0ol0VOooooooo`0koooo00<0000co`0co`008c?o00030000oooooooo093oool002Woool00ol0VOoo
ooooo`0koooo0P0002<co`000`000?ooooooo`2Aoooo000Yoooo00?o09Woooooool0>oooo`030000
<ol0<ol0024co`000`000?ooooooo`2Boooo000Yoooo00?o09Woooooool0>oooo`030000<ol0<ol0
020co`000`000?ooooooo`2Coooo000Yoooo00?o09Woooooool0>oooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo000Yoooo00?o09Woooooool0>oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000Yoooo00?o09Woooooool0<oooo`D00003oooo00<0000co`0co`007c?o00030000
oooooooo09Coool002Woool00ol0VOooooooo`0eoooo00<0003oooooool00oooo`030000<ol0<ol0
01hco`000`000?ooooooo`2Eoooo000Yoooo00?o09Woooooool0=Oooo`030000oooooooo00?oool2
00007c?o00030000oooooooo09Goool002Woool00ol0VOooooooo`0eoooo00<0003oooooool00ooo
o`030000<ol0<ol001dco`000`000?ooooooo`2Foooo000Yoooo00?o09Woooooool0=Oooo`030000
oooooooo00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00:Oooo`03o`2Ioooooooo
03Coool200001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000Yoooo00?o09Wooooo
ool0>oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000Yoooo00?o09Woooooool0>ooo
o`030000<ol0<ol001/co`000`000?ooooooo`2Hoooo000Yoooo00?o09Woooooool0>oooo`80000L
<ol000<0003oooooool0V?ooo`00:Oooo`03o`2Ioooooooo03_oool00`0003?o03?o000J<ol000<0
003oooooool0VOooo`00:Oooo`03o`2Ioooooooo03_oool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`00:Oooo`03o`2Ioooooooo03_oool00`0003?o03?o000I<ol000<0003oooooool0V_oo
o`00:Oooo`03o`2Ioooooooo03_oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00:Ooo
o`03o`2Ioooooooo03_oool00`0003?o03?o000H<ol000<0003oooooool0Voooo`00:Oooo`03o`2I
oooooooo03_oool200006C?o00030000oooooooo09_oool002Woool00ol0VOooooooo`0koooo00<0
000co`0co`005c?o00030000oooooooo09coool002Woool00ol0VOooooooo`0koooo00<0000co`0c
o`005c?o00030000oooooooo09coool002Woool00ol0VOooooooo`0koooo00<0000co`0co`005S?o
00030000oooooooo09goool002Woool00ol0VOooooooo`0koooo00<0000co`0co`005S?o00030000
oooooooo09goool002Woool00ol0VOooooooo`0koooo00<0000co`0co`005S?o00030000oooooooo
09goool002Woool00ol0VOooooooo`0koooo00<0000co`0co`005C?o00030000oooooooo09koool0
02Woool00ol0VOooooooo`0koooo0P0001Hco`000`000?ooooooo`2Noooo000Yoooo00?o09Wooooo
ool0>oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000Yoooo00?o09Woooooool0>ooo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000Yoooo00?o09Woooooool0>oooo`030000
<ol0<ol001@co`000`000?ooooooo`2Ooooo000Yoooo00?o09Woooooool0>oooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo000Yoooo00?o09Woooooool0>oooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo000Yoooo00?o09Woooooool0>oooo`80000E<ol000<0003oooooool0Wooo
o`00:Oooo`03o`2Ioooooooo03_oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00:Ooo
o`03o`2Ioooooooo03_oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00:Oooo`03o`2I
oooooooo03_oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00:Oooo`03o`2Ioooooooo
03?oool400001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo000Yoooo00?o09Wooooo
ool0<oooo`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00:Ooo
o`03o`2Ioooooooo03Coool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo000Z
oooo00?o09Woooooool0=?ooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003ooooo
ool0XOooo`00:_ooo`03o`2Ioooooooo03;oool010000?ooooooo`0000Coool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00:_ooo`03o`2Ioooooooo03?oool200001Oooo`030000<ol0<ol0
014co`000`000?ooooooo`2Roooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo000Zoooo00?o09Woooooool0>_ooo`80000A<ol000<0003oooooool0Xoooo`00:_oo
o`03o`2Ioooooooo03[oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00:_ooo`03o`2I
oooooooo03[oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00:_ooo`03o`2Ioooooooo
03[oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00:_ooo`03o`2Ioooooooo03[oool0
0`0003?o03?o000?<ol000<0003oooooool0Y?ooo`00:_ooo`03o`2Ioooooooo03[oool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`00:_ooo`03o`2Ioooooooo03[oool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`00:_ooo`03o`2Ioooooooo03[oool2000043?o00030000oooooooo
0:Coool002[oool00ol0VOooooooo`0joooo00<0000co`0co`003S?o00030000oooooooo0:Goool0
02[oool00ol0VOooooooo`0joooo00<0000co`0co`003S?o00030000oooooooo0:Goool002[oool0
0ol0VOooooooo`0joooo00<0000co`0co`003S?o00030000oooooooo0:Goool002[oool00ol0VOoo
ooooo`0joooo00<0000co`0co`003S?o00030000oooooooo0:Goool002[oool00ol0VOooooooo`0j
oooo00<0000co`0co`003C?o00030000oooooooo0:Koool002[oool00ol0VOooooooo`0joooo0P00
00hco`000`000?ooooooo`2Voooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000dco`00
0`000?ooooooo`2Voooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000`co`000`000?ooooooo`2W
oooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000Z
oooo00?o09Woooooool0>_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000Zoooo00?o
09Woooooool0>_ooo`80000=<ol000<0003oooooool0Yoooo`00:_ooo`03o`2Ioooooooo03[oool0
0`0003?o03?o000<<ol000<0003oooooool0Yoooo`00:_ooo`03o`2Ioooooooo03[oool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`00:_ooo`03o`2Ioooooooo03[oool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00:_ooo`03o`2Ioooooooo03?oool200001Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`2Xoooo000Zoooo00?o09Woooooool0<_ooo`040000oooooooo00001?oo
o`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000Zoooo00?o09Woooooool0=?ooo`030000
oooooooo00?oool2000033?o00030000oooooooo0:Soool002[oool00ol0VOooooooo`0eoooo00<0
003oooooool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000Zoooo00?o09Wooooo
ool0<_ooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000Z
oooo00?o09Woooooool0<oooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0
02[oool00ol0VOooooooo`0joooo00<0000co`0co`002S?o00030000oooooooo0:Woool002[oool0
0ol0VOooooooo`0joooo00<0000co`0co`002S?o00030000oooooooo0:Woool002[oool00ol0VOoo
ooooo`0joooo00<0000co`0co`002S?o00030000oooooooo0:Woool002[oool00ol0VOooooooo`0j
oooo0P0000/co`000`000?ooooooo`2Yoooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol0
00Xco`000`000?ooooooo`2Yoooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`2Zoooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000Z
oooo00?o09Woooooool0>_ooo`80000:<ol000<0003oooooool0Z_ooo`00:_ooo`03o`2Ioooooooo
03[oool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00:_ooo`03o`2Ioooooooo03[oool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00:_ooo`03o`2Ioooooooo03[oool00`0003?o
03?o0008<ol000<0003oooooool0Zoooo`00:_ooo`03o`2Ioooooooo03[oool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`00:_ooo`03o`2Ioooooooo03[oool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`00:_ooo`03o`2Ioooooooo03[oool200002C?o00030000oooooooo0:_oool0
02[oool00ol0VOooooooo`0joooo00<0000co`0co`0023?o00030000oooooooo0:_oool002[oool0
0ol0VOooooooo`0joooo00<0000co`0co`0023?o00030000oooooooo0:_oool002[oool00ol0VOoo
ooooo`0joooo00<0000co`0co`001c?o00030000oooooooo0:coool002[oool00ol0VOooooooo`0j
oooo00<0000co`0co`001c?o00030000oooooooo0:coool002[oool00ol0VOooooooo`0joooo00<0
000co`0co`001c?o00030000oooooooo0:coool002[oool00ol0VOooooooo`0joooo0P0000Pco`00
0`000?ooooooo`2/oooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000Lco`000`000?oo
ooooo`2/oooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000Zoooo00?o09Woooooool0>_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Z
oooo00?o09Woooooool0>_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000Zoooo00?o
09Woooooool0=?ooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool002[oool0
0ol0VOooooooo`0eoooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000Zoooo00?o09Woooooool0<_ooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001O
oooo00@0003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0
067oool200001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo
00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Goool010000?oooooooooo
o`<00004oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000[oool0
1@000?ooooooooooo`000002oooo00D0003oooooooooool00000Moooo`00Ioooo`Tco`04oooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo07Coool006Ooool9<ol01Oooo`030000
oooooooo00D0000Boooo00@0003oooooool0000;oooo00<0003oooooool00`0000Coool00`000?oo
ooooo`1eoooo001Woooo2C?o00Goool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool00oooo`030000oooooooo07Goool006Ooool9
<ol01_ooo`030000oooooooo01Ooool200002Oooo`@00003oooo0`0000;oool00`000?ooooooo`1f
oooo001Woooo2C?o0;3oool006Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.74) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.08255 .12361 L
.0932 .12361 L
.09905 .12361 L
.10192 .12361 L
.10319 .12361 L
.10458 .12361 L
.10587 .12361 L
s
.10587 .12361 m
.10635 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.74) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool00_ooo`04o`2Ioooooooo00001oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo01;oool0
0ol0VOooooooo`0@oooo00<0003oooooool09_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T
<ol0400001Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00:oooo`03o`2Ioooooooo
03Woool00`0003?o03?o0017<ol01@0006[oool002_oool00ol0VOooooooo`0ioooo00<0000co`0c
o`00@S?o00D0001_oooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol003dco`050000M?oo
o`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000i<ol0100007Woool002_oool00ol0VOoo
ooooo`0ioooo0P0003Pco`020000OOooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000e
<ol00P0007ooool002_oool00ol0VOooooooo`0ioooo00<0000co`0co`00<c?o00800021oooo000[
oooo00?o09Woooooool0>Oooo`030000<ol0<ol0034co`020000Poooo`00:oooo`03o`2Ioooooooo
03Woool00`0003?o03?o000`<ol000<0003oooooool0Poooo`00:oooo`03o`2Ioooooooo03Woool0
0`0003?o03?o000^<ol00P0008Koool002_oool00ol0VOooooooo`0ioooo0P0002dco`020000R?oo
o`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00:ooo
o`03o`2Ioooooooo03Woool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`00:oooo`03o`2I
oooooooo03Woool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`00:oooo`03o`2Ioooooooo
03Woool00`0003?o03?o000X<ol000<0003oooooool0Roooo`00:oooo`03o`2Ioooooooo03Woool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`00:oooo`03o`2Ioooooooo03Woool20000:3?o
00030000oooooooo08coool002_oool00ol0VOooooooo`0ioooo00<0000co`0co`009S?o00030000
oooooooo08goool002_oool00ol0VOooooooo`0ioooo00<0000co`0co`009C?o00030000oooooooo
08koool002_oool00ol0VOooooooo`0ioooo00<0000co`0co`0093?o00030000oooooooo08ooool0
02_oool00ol0VOooooooo`0ioooo00<0000co`0co`008c?o00030000oooooooo093oool002_oool0
0ol0VOooooooo`0ioooo00<0000co`0co`008c?o00030000oooooooo093oool002_oool00ol0VOoo
ooooo`0ioooo0P0002<co`000`000?ooooooo`2Aoooo000[oooo00?o09Woooooool0>Oooo`030000
<ol0<ol0024co`000`000?ooooooo`2Boooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol0
020co`000`000?ooooooo`2Coooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000[oooo00?o09Woooooool0<Oooo`D00003oooo00<0000co`0co`007c?o00030000
oooooooo09Coool002_oool00ol0VOooooooo`0coooo00<0003oooooool00oooo`030000<ol0<ol0
01hco`000`000?ooooooo`2Eoooo000[oooo00?o09Woooooool0<oooo`030000oooooooo00?oool2
00007c?o00030000oooooooo09Goool002_oool00ol0VOooooooo`0coooo00<0003oooooool00ooo
o`030000<ol0<ol001dco`000`000?ooooooo`2Foooo000[oooo00?o09Woooooool0<oooo`030000
oooooooo00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00:oooo`03o`2Ioooooooo
03;oool200001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000[oooo00?o09Wooooo
ool0>Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000[oooo00?o09Woooooool0>Ooo
o`030000<ol0<ol001/co`000`000?ooooooo`2Hoooo000[oooo00?o09Woooooool0>Oooo`80000L
<ol000<0003oooooool0V?ooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000J<ol000<0
003oooooool0VOooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000I<ol000<0003oooooool0V_oo
o`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00:ooo
o`03o`2Ioooooooo03Woool00`0003?o03?o000H<ol000<0003oooooool0Voooo`00:oooo`03o`2I
oooooooo03Woool200006C?o00030000oooooooo09_oool002_oool00ol0VOooooooo`0ioooo00<0
000co`0co`005c?o00030000oooooooo09coool002_oool00ol0VOooooooo`0ioooo00<0000co`0c
o`005c?o00030000oooooooo09coool002_oool00ol0VOooooooo`0ioooo00<0000co`0co`005S?o
00030000oooooooo09goool002_oool00ol0VOooooooo`0ioooo00<0000co`0co`005S?o00030000
oooooooo09goool002_oool00ol0VOooooooo`0ioooo00<0000co`0co`005S?o00030000oooooooo
09goool002_oool00ol0VOooooooo`0ioooo00<0000co`0co`005C?o00030000oooooooo09koool0
02_oool00ol0VOooooooo`0ioooo0P0001Hco`000`000?ooooooo`2Noooo000[oooo00?o09Wooooo
ool0>Oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000[oooo00?o09Woooooool0>Ooo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000[oooo00?o09Woooooool0>Oooo`030000
<ol0<ol001@co`000`000?ooooooo`2Ooooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo000[oooo00?o09Woooooool0>Oooo`80000E<ol000<0003oooooool0Wooo
o`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00:ooo
o`03o`2Ioooooooo03Woool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00:oooo`03o`2I
oooooooo03Woool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00:oooo`03o`2Ioooooooo
037oool400001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo000[oooo00?o09Wooooo
ool0<Oooo`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00:ooo
o`03o`2Ioooooooo03;oool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo000[
oooo00?o09Woooooool0<oooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003ooooo
ool0XOooo`00:oooo`03o`2Ioooooooo037oool010000?ooooooo`0000Coool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00:oooo`03o`2Ioooooooo03;oool200001Oooo`030000<ol0<ol0
014co`000`000?ooooooo`2Roooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo000[oooo00?o09Woooooool0>Oooo`80000A<ol000<0003oooooool0Xoooo`00:ooo
o`03o`2Ioooooooo03Woool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00:oooo`03o`2I
oooooooo03Woool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00:oooo`03o`2Ioooooooo
03Woool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00:oooo`03o`2Ioooooooo03Woool0
0`0003?o03?o000?<ol000<0003oooooool0Y?ooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`00:oooo`03o`2Ioooooooo03Woool2000043?o00030000oooooooo
0:Coool002_oool00ol0VOooooooo`0ioooo00<0000co`0co`003S?o00030000oooooooo0:Goool0
02_oool00ol0VOooooooo`0ioooo00<0000co`0co`003S?o00030000oooooooo0:Goool002_oool0
0ol0VOooooooo`0ioooo00<0000co`0co`003S?o00030000oooooooo0:Goool002_oool00ol0VOoo
ooooo`0ioooo00<0000co`0co`003S?o00030000oooooooo0:Goool002_oool00ol0VOooooooo`0i
oooo00<0000co`0co`003C?o00030000oooooooo0:Koool002_oool00ol0VOooooooo`0ioooo0P00
00hco`000`000?ooooooo`2Voooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000dco`00
0`000?ooooooo`2Voooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000`co`000`000?ooooooo`2W
oooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000[
oooo00?o09Woooooool0>Oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000[oooo00?o
09Woooooool0>Oooo`80000=<ol000<0003oooooool0Yoooo`00:oooo`03o`2Ioooooooo03Woool0
0`0003?o03?o000<<ol000<0003oooooool0Yoooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00:oooo`03o`2Ioooooooo03;oool200001Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`2Xoooo000[oooo00?o09Woooooool0<Oooo`040000oooooooo00001?oo
o`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000[oooo00?o09Woooooool0<oooo`030000
oooooooo00?oool2000033?o00030000oooooooo0:Soool002_oool00ol0VOooooooo`0doooo00<0
003oooooool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000[oooo00?o09Wooooo
ool0<Oooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000[
oooo00?o09Woooooool0<_ooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0
02_oool00ol0VOooooooo`0ioooo00<0000co`0co`002S?o00030000oooooooo0:Woool002_oool0
0ol0VOooooooo`0ioooo00<0000co`0co`002S?o00030000oooooooo0:Woool002_oool00ol0VOoo
ooooo`0ioooo00<0000co`0co`002S?o00030000oooooooo0:Woool002_oool00ol0VOooooooo`0i
oooo0P0000/co`000`000?ooooooo`2Yoooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol0
00Xco`000`000?ooooooo`2Yoooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Tco`00
0`000?ooooooo`2Zoooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000[
oooo00?o09Woooooool0>Oooo`80000:<ol000<0003oooooool0Z_ooo`00:oooo`03o`2Ioooooooo
03Woool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00:oooo`03o`2Ioooooooo03Woool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o
03?o0008<ol000<0003oooooool0Zoooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`00:oooo`03o`2Ioooooooo03Woool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`00:oooo`03o`2Ioooooooo03Woool200002C?o00030000oooooooo0:_oool0
02_oool00ol0VOooooooo`0ioooo00<0000co`0co`0023?o00030000oooooooo0:_oool002_oool0
0ol0VOooooooo`0ioooo00<0000co`0co`0023?o00030000oooooooo0:_oool002_oool00ol0VOoo
ooooo`0ioooo00<0000co`0co`001c?o00030000oooooooo0:coool002_oool00ol0VOooooooo`0i
oooo00<0000co`0co`001c?o00030000oooooooo0:coool002_oool00ol0VOooooooo`0ioooo00<0
000co`0co`001c?o00030000oooooooo0:coool002_oool00ol0VOooooooo`0ioooo0P0000Pco`00
0`000?ooooooo`2/oooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Lco`000`000?oo
ooooo`2/oooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000[oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000[
oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000[oooo00?o
09Woooooool0<oooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool002_oool0
0ol0VOooooooo`0doooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000[oooo00?o09Woooooool0<Oooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001O
oooo00@0003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0
067oool200001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo
00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Goool00`000?ooooooo`03
oooo0`0000;oool00`000?ooooooo`1eoooo001Woooo2C?o00Goool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002_oo
o`030000oooooooo00Coool01@000?ooooooooooo`00001goooo001Woooo2C?o00Coool00`000?oo
ooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002_ooo`040000oooooooooooo1@00
00?oool00`000?ooooooo`1doooo001Woooo2C?o00Goool00`000?ooooooo`0500004_ooo`040000
oooooooo00002oooo`040000oooooooo00000_ooo`050000oooooooooooo000007Ooool006Ooool9
<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`00
00?oool00`000?ooo`000003oooo00<0003oooooool0MOooo`00Ioooo`Tco`06oooo00<0003ooooo
ool05oooo`800009oooo100000Coool200000_ooo`030000oooooooo07Koool006Ooool9<ol0/?oo
o`00Ioooo`Pco`2aoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.72) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.08255 .12361 L
.0932 .12361 L
.09905 .12361 L
.10458 .12361 L
.10972 .12361 L
.11113 .12361 L
.1119 .12361 L
.11263 .12361 L
s
.11263 .12361 m
.11314 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.72) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01?ooo`03o`2I0000oooo00Koool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Doooo00?o
09Woooooool03_ooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool002goool00ol0VOooooooo`0g
oooo00<0000co`0co`00Ac?o00D0001Zoooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol0
048co`050000Koooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000m<ol01@0007Coool0
02goool00ol0VOooooooo`0goooo00<0000co`0co`00>C?o00@0001ioooo000]oooo00?o09Wooooo
ool0=oooo`80000h<ol00P0007goool002goool00ol0VOooooooo`0goooo00<0000co`0co`00=C?o
0080001ooooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol003<co`020000POooo`00;Ooo
o`03o`2Ioooooooo03Ooool00`0003?o03?o000a<ol00P0008?oool002goool00ol0VOooooooo`0g
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool002goool00ol0VOooooooo`0goooo00<0
000co`0co`00;S?o00800026oooo000]oooo00?o09Woooooool0=oooo`80000]<ol00P0008Soool0
02goool00ol0VOooooooo`0goooo00<0000co`0co`00:c?o00030000oooooooo08Soool002goool0
0ol0VOooooooo`0goooo00<0000co`0co`00:S?o00030000oooooooo08Woool002goool00ol0VOoo
ooooo`0goooo00<0000co`0co`00:C?o00030000oooooooo08[oool002goool00ol0VOooooooo`0g
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool002goool00ol0VOooooooo`0goooo00<0
000co`0co`00:3?o00030000oooooooo08_oool002goool00ol0VOooooooo`0goooo0P0002Pco`00
0`000?ooooooo`2<oooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000]
oooo00?o09Woooooool0=oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000]oooo00?o
09Woooooool0=oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000]oooo00?o09Wooooo
ool0=oooo`80000S<ol000<0003oooooool0TOooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00;Oooo`03o`2Ioooooooo02ooool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000]oooo00?o09Woooooool0<Oooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00;Oooo`03o`2Ioooooooo037oool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000]oooo00?o09Woooooool0<Oooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00;Oooo`03o`2Ioooooooo037oool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool002goool00ol0VOooooooo`0`
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00;Oooo`03o`2Ioooooooo
03Ooool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00;Oooo`03o`2Ioooooooo03Ooool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00;Oooo`03o`2Ioooooooo03Ooool2000073?o
00030000oooooooo09Soool002goool00ol0VOooooooo`0goooo00<0000co`0co`006S?o00030000
oooooooo09Woool002goool00ol0VOooooooo`0goooo00<0000co`0co`006S?o00030000oooooooo
09Woool002goool00ol0VOooooooo`0goooo00<0000co`0co`006C?o00030000oooooooo09[oool0
02goool00ol0VOooooooo`0goooo00<0000co`0co`006C?o00030000oooooooo09[oool002goool0
0ol0VOooooooo`0goooo00<0000co`0co`0063?o00030000oooooooo09_oool002goool00ol0VOoo
ooooo`0goooo0P0001Tco`000`000?ooooooo`2Koooo000]oooo00?o09Woooooool0=oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000]
oooo00?o09Woooooool0=oooo`80000F<ol000<0003oooooool0W_ooo`00;Oooo`03o`2Ioooooooo
03Ooool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00;Oooo`03o`2Ioooooooo03Ooool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00;Oooo`03o`2Ioooooooo03Ooool200005C?o00030000oooooooo09ooool0
02goool00ol0VOooooooo`0goooo00<0000co`0co`004c?o00030000oooooooo0:3oool002goool0
0ol0VOooooooo`0goooo00<0000co`0co`004c?o00030000oooooooo0:3oool002goool00ol0VOoo
ooooo`0goooo00<0000co`0co`004c?o00030000oooooooo0:3oool002goool00ol0VOooooooo`0_
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00;Oooo`03o`2Ioooooooo
02ooool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool002goool0
0ol0VOooooooo`0`oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00;Ooo
o`03o`2Ioooooooo037oool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool002goool00ol0VOooooooo`0_oooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool002goool00ol0VOooooooo`0`oooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00;Oooo`03o`2Ioooooooo03Ooool200004C?o00030000oooooooo0:?oool002goool0
0ol0VOooooooo`0goooo00<0000co`0co`0043?o00030000oooooooo0:?oool002goool00ol0VOoo
ooooo`0goooo00<0000co`0co`0043?o00030000oooooooo0:?oool002goool00ol0VOooooooo`0g
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool002goool00ol0VOooooooo`0goooo00<0
000co`0co`003c?o00030000oooooooo0:Coool002goool00ol0VOooooooo`0goooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool002goool00ol0VOooooooo`0goooo00<0000co`0co`003c?o
00030000oooooooo0:Coool002goool00ol0VOooooooo`0goooo0P00010co`000`000?ooooooo`2T
oooo000]oooo00?o09Woooooool0=oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000]
oooo00?o09Woooooool0=oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000]oooo00?o
09Woooooool0=oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000]oooo00?o09Wooooo
ool0=oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000]oooo00?o09Woooooool0=ooo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000]oooo00?o09Woooooool0=oooo`80000>
<ol000<0003oooooool0Y_ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00;Ooo
o`03o`2Ioooooooo03Ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00;Oooo`03o`2I
oooooooo03Ooool200003C?o00030000oooooooo0:Ooool002goool00ol0VOooooooo`0goooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool002goool00ol0VOooooooo`0goooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool002goool00ol0VOooooooo`0goooo00<0000co`0co`002c?o
00030000oooooooo0:Soool002goool00ol0VOooooooo`0`oooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00;Oooo`03o`2Ioooooooo02ooool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00;Oooo`03o`2Ioooooooo037oool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000]oooo00?o09Woooooool0<_ooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00;Oooo`03o`2Ioooooooo
02ooool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00;Ooo
o`03o`2Ioooooooo033oool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000]
oooo00?o09Woooooool0=oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000]oooo00?o
09Woooooool0=oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000]oooo00?o09Wooooo
ool0=oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000]oooo00?o09Woooooool0=ooo
o`80000;<ol000<0003oooooool0ZOooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00;Ooo
o`03o`2Ioooooooo03Ooool200002S?o00030000oooooooo0:[oool002goool00ol0VOooooooo`0g
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool002goool00ol0VOooooooo`0goooo00<0
000co`0co`002C?o00030000oooooooo0:[oool002goool00ol0VOooooooo`0goooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool002goool00ol0VOooooooo`0goooo00<0000co`0co`0023?o
00030000oooooooo0:_oool002goool00ol0VOooooooo`0goooo00<0000co`0co`0023?o00030000
oooooooo0:_oool002goool00ol0VOooooooo`0goooo0P0000Tco`000`000?ooooooo`2[oooo000]
oooo00?o09Woooooool0=oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000]oooo00?o
09Woooooool0=oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000]oooo00?o09Wooooo
ool0=oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000]oooo00?o09Woooooool0=ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000]oooo00?o09Woooooool0=oooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000]oooo00?o09Woooooool0=oooo`800008<ol000<0
003oooooool0[?ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00;Oooo`03o`2Ioooooooo03Ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00;Ooo
o`03o`2Ioooooooo03Ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00;Oooo`03o`2I
oooooooo037oool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000]oooo00?o
09Woooooool0<_ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00;Oooo`03o`2Ioooooooo02ooool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005oooo00@0003oooooooooool4
00000oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool0000:oooo00D0
003oooooooooool000001_ooo`030000oooooooo07Goool006Ooool9<ol01?ooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`030000
oooooooo00Coool00`000?ooooooo`1doooo001Woooo2C?o00Goool00`000?ooooooo`0500004_oo
o`040000oooooooo00002oooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003ooooo
ool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?oo
o`040000oooooooo00000_ooo`040000oooooooo00000oooo`030000oooooooo07Goool006Ooool9
<ol01_ooo`030000oooooooo01Ooool200002Oooo`@00003oooo0P0000?oool00`000?ooooooo`1f
oooo001Woooo2C?o0;3oool006Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.08255 .12361 L
.0932 .12361 L
.10458 .12361 L
.11009 .12361 L
.1128 .12361 L
.11531 .12361 L
.11758 .12361 L
.11872 .12361 L
s
.11872 .12361 m
.11923 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Eoooo00?o
09Woooooool03Oooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool002koool00ol0VOooooooo`0f
oooo00<0000co`0co`00Ac?o00D0001Zoooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol0
048co`050000Koooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000m<ol01@0007Coool0
02koool00ol0VOooooooo`0foooo00<0000co`0co`00>C?o00@0001ioooo000^oooo00?o09Wooooo
ool0=_ooo`80000h<ol00P0007goool002koool00ol0VOooooooo`0foooo00<0000co`0co`00=C?o
0080001ooooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol003<co`020000POooo`00;_oo
o`03o`2Ioooooooo03Koool00`0003?o03?o000a<ol00P0008?oool002koool00ol0VOooooooo`0f
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool002koool00ol0VOooooooo`0foooo00<0
000co`0co`00;S?o00800026oooo000^oooo00?o09Woooooool0=_ooo`80000]<ol00P0008Soool0
02koool00ol0VOooooooo`0foooo00<0000co`0co`00:c?o00030000oooooooo08Soool002koool0
0ol0VOooooooo`0foooo00<0000co`0co`00:S?o00030000oooooooo08Woool002koool00ol0VOoo
ooooo`0foooo00<0000co`0co`00:C?o00030000oooooooo08[oool002koool00ol0VOooooooo`0f
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool002koool00ol0VOooooooo`0foooo00<0
000co`0co`00:3?o00030000oooooooo08_oool002koool00ol0VOooooooo`0foooo0P0002Pco`00
0`000?ooooooo`2<oooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000^
oooo00?o09Woooooool0=_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000^oooo00?o
09Woooooool0=_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000^oooo00?o09Wooooo
ool0=_ooo`80000S<ol000<0003oooooool0TOooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00;_ooo`03o`2Ioooooooo02koool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000^oooo00?o09Woooooool0<?ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00;_ooo`03o`2Ioooooooo033oool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000^oooo00?o09Woooooool0<?ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00;_ooo`03o`2Ioooooooo033oool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool002koool00ol0VOooooooo`0_
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00;_ooo`03o`2Ioooooooo
03Koool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00;_ooo`03o`2Ioooooooo03Koool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00;_ooo`03o`2Ioooooooo03Koool2000073?o
00030000oooooooo09Soool002koool00ol0VOooooooo`0foooo00<0000co`0co`006S?o00030000
oooooooo09Woool002koool00ol0VOooooooo`0foooo00<0000co`0co`006S?o00030000oooooooo
09Woool002koool00ol0VOooooooo`0foooo00<0000co`0co`006C?o00030000oooooooo09[oool0
02koool00ol0VOooooooo`0foooo00<0000co`0co`006C?o00030000oooooooo09[oool002koool0
0ol0VOooooooo`0foooo00<0000co`0co`0063?o00030000oooooooo09_oool002koool00ol0VOoo
ooooo`0foooo0P0001Tco`000`000?ooooooo`2Koooo000^oooo00?o09Woooooool0=_ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000^
oooo00?o09Woooooool0=_ooo`80000F<ol000<0003oooooool0W_ooo`00;_ooo`03o`2Ioooooooo
03Koool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00;_ooo`03o`2Ioooooooo03Koool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00;_ooo`03o`2Ioooooooo03Koool200005C?o00030000oooooooo09ooool0
02koool00ol0VOooooooo`0foooo00<0000co`0co`004c?o00030000oooooooo0:3oool002koool0
0ol0VOooooooo`0foooo00<0000co`0co`004c?o00030000oooooooo0:3oool002koool00ol0VOoo
ooooo`0foooo00<0000co`0co`004c?o00030000oooooooo0:3oool002koool00ol0VOooooooo`0^
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00;_ooo`03o`2Ioooooooo
02koool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool002koool0
0ol0VOooooooo`0_oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00;_oo
o`03o`2Ioooooooo033oool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool002koool00ol0VOooooooo`0^oooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool002koool00ol0VOooooooo`0_oooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00;_ooo`03o`2Ioooooooo03Koool200004C?o00030000oooooooo0:?oool002koool0
0ol0VOooooooo`0foooo00<0000co`0co`0043?o00030000oooooooo0:?oool002koool00ol0VOoo
ooooo`0foooo00<0000co`0co`0043?o00030000oooooooo0:?oool002koool00ol0VOooooooo`0f
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool002koool00ol0VOooooooo`0foooo00<0
000co`0co`003c?o00030000oooooooo0:Coool002koool00ol0VOooooooo`0foooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool002koool00ol0VOooooooo`0foooo00<0000co`0co`003c?o
00030000oooooooo0:Coool002koool00ol0VOooooooo`0foooo0P00010co`000`000?ooooooo`2T
oooo000^oooo00?o09Woooooool0=_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000^
oooo00?o09Woooooool0=_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000^oooo00?o
09Woooooool0=_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000^oooo00?o09Wooooo
ool0=_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000^oooo00?o09Woooooool0=_oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000^oooo00?o09Woooooool0=_ooo`80000>
<ol000<0003oooooool0Y_ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00;_oo
o`03o`2Ioooooooo03Koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00;_ooo`03o`2I
oooooooo03Koool200003C?o00030000oooooooo0:Ooool002koool00ol0VOooooooo`0foooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool002koool00ol0VOooooooo`0foooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool002koool00ol0VOooooooo`0foooo00<0000co`0co`002c?o
00030000oooooooo0:Soool002koool00ol0VOooooooo`0_oooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00;_ooo`03o`2Ioooooooo02koool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00;_ooo`03o`2Ioooooooo033oool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000^oooo00?o09Woooooool0<Oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00;_ooo`03o`2Ioooooooo
02koool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00;_oo
o`03o`2Ioooooooo02ooool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000^
oooo00?o09Woooooool0=_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000^oooo00?o
09Woooooool0=_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000^oooo00?o09Wooooo
ool0=_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000^oooo00?o09Woooooool0=_oo
o`80000;<ol000<0003oooooool0ZOooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00;_oo
o`03o`2Ioooooooo03Koool200002S?o00030000oooooooo0:[oool002koool00ol0VOooooooo`0f
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool002koool00ol0VOooooooo`0foooo00<0
000co`0co`002C?o00030000oooooooo0:[oool002koool00ol0VOooooooo`0foooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool002koool00ol0VOooooooo`0foooo00<0000co`0co`0023?o
00030000oooooooo0:_oool002koool00ol0VOooooooo`0foooo00<0000co`0co`0023?o00030000
oooooooo0:_oool002koool00ol0VOooooooo`0foooo0P0000Tco`000`000?ooooooo`2[oooo000^
oooo00?o09Woooooool0=_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000^oooo00?o
09Woooooool0=_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000^oooo00?o09Wooooo
ool0=_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000^oooo00?o09Woooooool0=_oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000^oooo00?o09Woooooool0=_ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000^oooo00?o09Woooooool0=_ooo`800008<ol000<0
003oooooool0[?ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00;_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00;_oo
o`03o`2Ioooooooo03Koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00;_ooo`03o`2I
oooooooo033oool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000^oooo00?o
09Woooooool0<Oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00;_ooo`03o`2Ioooooooo02koool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol02Ooo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001Woooo2C?o00Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool006Ooool9<ol02?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005oooo00<0003oooooool00_oo
o`030000oooooooo07Soool006Ooool9<ol02?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool0000:oooo00<0003ooooo
ool00_ooo`030000oooooooo07Soool006Ooool9<ol01oooo`030000oooooooo00;oool00`000?oo
ooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool00oooo`030000oooooooo07Ooool0
06Ooool9<ol02?ooo`030000oooooooo00D0000Boooo00@0003oooooool0000;oooo00D0003ooooo
ooooool00000N_ooo`00Ioooo`Tco`08oooo00D0003oooooooooool000005Oooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool006Ooool9<ol02Oooo`030000
oooooooo01Ooool200002Oooo`@00002oooo00<0003oooooool0NOooo`00Ioooo`Tco`2`oooo001W
oooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.68) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.08255 .12361 L
.10458 .12361 L
.11448 .12361 L
.11992 .12361 L
.1226 .12361 L
.12377 .12361 L
.12507 .12361 L
s
.12507 .12361 m
.12555 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.68) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000ooooo`2I00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Goooo00?o
09Woooooool02oooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool0033oool00ol0VOooooooo`0d
oooo00<0000co`0co`00Ac?o00D0001Zoooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol0
048co`050000Koooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000m<ol01@0007Coool0
033oool00ol0VOooooooo`0doooo00<0000co`0co`00>C?o00@0001ioooo000`oooo00?o09Wooooo
ool0=?ooo`80000h<ol00P0007goool0033oool00ol0VOooooooo`0doooo00<0000co`0co`00=C?o
0080001ooooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol003<co`020000POooo`00<?oo
o`03o`2Ioooooooo03Coool00`0003?o03?o000a<ol00P0008?oool0033oool00ol0VOooooooo`0d
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool0033oool00ol0VOooooooo`0doooo00<0
000co`0co`00;S?o00800026oooo000`oooo00?o09Woooooool0=?ooo`80000]<ol00P0008Soool0
033oool00ol0VOooooooo`0doooo00<0000co`0co`00:c?o00030000oooooooo08Soool0033oool0
0ol0VOooooooo`0doooo00<0000co`0co`00:S?o00030000oooooooo08Woool0033oool00ol0VOoo
ooooo`0doooo00<0000co`0co`00:C?o00030000oooooooo08[oool0033oool00ol0VOooooooo`0d
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool0033oool00ol0VOooooooo`0doooo00<0
000co`0co`00:3?o00030000oooooooo08_oool0033oool00ol0VOooooooo`0doooo0P0002Pco`00
0`000?ooooooo`2<oooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000`
oooo00?o09Woooooool0=?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000`oooo00?o
09Woooooool0=?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000`oooo00?o09Wooooo
ool0=?ooo`80000S<ol000<0003oooooool0TOooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00<?ooo`03o`2Ioooooooo02coool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000`oooo00?o09Woooooool0;_ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00<?ooo`03o`2Ioooooooo02koool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000`oooo00?o09Woooooool0;_ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00<?ooo`03o`2Ioooooooo02koool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool0033oool00ol0VOooooooo`0]
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00<?ooo`03o`2Ioooooooo
03Coool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00<?ooo`03o`2Ioooooooo03Coool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00<?ooo`03o`2Ioooooooo03Coool2000073?o
00030000oooooooo09Soool0033oool00ol0VOooooooo`0doooo00<0000co`0co`006S?o00030000
oooooooo09Woool0033oool00ol0VOooooooo`0doooo00<0000co`0co`006S?o00030000oooooooo
09Woool0033oool00ol0VOooooooo`0doooo00<0000co`0co`006C?o00030000oooooooo09[oool0
033oool00ol0VOooooooo`0doooo00<0000co`0co`006C?o00030000oooooooo09[oool0033oool0
0ol0VOooooooo`0doooo00<0000co`0co`0063?o00030000oooooooo09_oool0033oool00ol0VOoo
ooooo`0doooo0P0001Tco`000`000?ooooooo`2Koooo000`oooo00?o09Woooooool0=?ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000`
oooo00?o09Woooooool0=?ooo`80000F<ol000<0003oooooool0W_ooo`00<?ooo`03o`2Ioooooooo
03Coool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00<?ooo`03o`2Ioooooooo03Coool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00<?ooo`03o`2Ioooooooo03Coool200005C?o00030000oooooooo09ooool0
033oool00ol0VOooooooo`0doooo00<0000co`0co`004c?o00030000oooooooo0:3oool0033oool0
0ol0VOooooooo`0doooo00<0000co`0co`004c?o00030000oooooooo0:3oool0033oool00ol0VOoo
ooooo`0doooo00<0000co`0co`004c?o00030000oooooooo0:3oool0033oool00ol0VOooooooo`0/
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00<?ooo`03o`2Ioooooooo
02coool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool0033oool0
0ol0VOooooooo`0]oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00<?oo
o`03o`2Ioooooooo02koool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool0033oool00ol0VOooooooo`0/oooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool0033oool00ol0VOooooooo`0]oooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00<?ooo`03o`2Ioooooooo03Coool200004C?o00030000oooooooo0:?oool0033oool0
0ol0VOooooooo`0doooo00<0000co`0co`0043?o00030000oooooooo0:?oool0033oool00ol0VOoo
ooooo`0doooo00<0000co`0co`0043?o00030000oooooooo0:?oool0033oool00ol0VOooooooo`0d
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool0033oool00ol0VOooooooo`0doooo00<0
000co`0co`003c?o00030000oooooooo0:Coool0033oool00ol0VOooooooo`0doooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool0033oool00ol0VOooooooo`0doooo00<0000co`0co`003c?o
00030000oooooooo0:Coool0033oool00ol0VOooooooo`0doooo0P00010co`000`000?ooooooo`2T
oooo000`oooo00?o09Woooooool0=?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000`
oooo00?o09Woooooool0=?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000`oooo00?o
09Woooooool0=?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000`oooo00?o09Wooooo
ool0=?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000`oooo00?o09Woooooool0=?oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000`oooo00?o09Woooooool0=?ooo`80000>
<ol000<0003oooooool0Y_ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00<?oo
o`03o`2Ioooooooo03Coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00<?ooo`03o`2I
oooooooo03Coool200003C?o00030000oooooooo0:Ooool0033oool00ol0VOooooooo`0doooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool0033oool00ol0VOooooooo`0doooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool0033oool00ol0VOooooooo`0doooo00<0000co`0co`002c?o
00030000oooooooo0:Soool0033oool00ol0VOooooooo`0]oooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00<?ooo`03o`2Ioooooooo02coool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00<?ooo`03o`2Ioooooooo02koool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000`oooo00?o09Woooooool0;oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00<?ooo`03o`2Ioooooooo
02coool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00<?oo
o`03o`2Ioooooooo02goool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000`
oooo00?o09Woooooool0=?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000`oooo00?o
09Woooooool0=?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000`oooo00?o09Wooooo
ool0=?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000`oooo00?o09Woooooool0=?oo
o`80000;<ol000<0003oooooool0ZOooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00<?oo
o`03o`2Ioooooooo03Coool200002S?o00030000oooooooo0:[oool0033oool00ol0VOooooooo`0d
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool0033oool00ol0VOooooooo`0doooo00<0
000co`0co`002C?o00030000oooooooo0:[oool0033oool00ol0VOooooooo`0doooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool0033oool00ol0VOooooooo`0doooo00<0000co`0co`0023?o
00030000oooooooo0:_oool0033oool00ol0VOooooooo`0doooo00<0000co`0co`0023?o00030000
oooooooo0:_oool0033oool00ol0VOooooooo`0doooo0P0000Tco`000`000?ooooooo`2[oooo000`
oooo00?o09Woooooool0=?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000`oooo00?o
09Woooooool0=?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000`oooo00?o09Wooooo
ool0=?ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000`oooo00?o09Woooooool0=?oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000`oooo00?o09Woooooool0=?ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000`oooo00?o09Woooooool0=?ooo`800008<ol000<0
003oooooool0[?ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00<?ooo`03o`2Ioooooooo03Coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00<?oo
o`03o`2Ioooooooo03Coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00<?ooo`03o`2I
oooooooo02koool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000`oooo00?o
09Woooooool0;oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00<?ooo`03o`2Ioooooooo02coool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo0`0000Coool200001?oo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00Ioooo`Tco`04oooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Soool010000?ooooooo`00
00;oool010000?ooooooo`0000Coool00`000?ooooooo`1doooo001Woooo2C?o00Goool00`000?oo
ooooo`0500004_ooo`040000oooooooo00002?ooo`<00004oooo0P0000Coool00`000?ooooooo`1e
oooo001Woooo2C?o00Goool01@000?ooooooooooo`00000Eoooo00@0003oooooool00009oooo00<0
003oooooool00_ooo`040000oooooooo00000oooo`030000oooooooo07Goool006Ooool9<ol01_oo
o`030000oooooooo01Ooool200002_ooo`<00003oooo0P0000?oool00`000?ooooooo`1foooo001W
oooo2C?o0;3oool006Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.66) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.08255 .12361 L
.10458 .12361 L
.11448 .12361 L
.11992 .12361 L
.12507 .12361 L
.12739 .12361 L
.12986 .12361 L
.13115 .12361 L
s
.13115 .12361 m
.13144 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.66) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`040000ooooooooo`2I1?ooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo01Soool0
0ol0VOooooooo`0:oooo00<0003oooooool09_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T
<ol0400001Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00<Oooo`03o`2Ioooooooo
03?oool00`0003?o03?o0017<ol01@0006[oool0037oool00ol0VOooooooo`0coooo00<0000co`0c
o`00@S?o00D0001_oooo000aoooo00?o09Woooooool0<oooo`030000<ol0<ol003dco`050000M?oo
o`00<Oooo`03o`2Ioooooooo03?oool00`0003?o03?o000i<ol0100007Woool0037oool00ol0VOoo
ooooo`0coooo0P0003Pco`020000OOooo`00<Oooo`03o`2Ioooooooo03?oool00`0003?o03?o000e
<ol00P0007ooool0037oool00ol0VOooooooo`0coooo00<0000co`0co`00<c?o00800021oooo000a
oooo00?o09Woooooool0<oooo`030000<ol0<ol0034co`020000Poooo`00<Oooo`03o`2Ioooooooo
03?oool00`0003?o03?o000`<ol000<0003oooooool0Poooo`00<Oooo`03o`2Ioooooooo03?oool0
0`0003?o03?o000^<ol00P0008Koool0037oool00ol0VOooooooo`0coooo0P0002dco`020000R?oo
o`00<Oooo`03o`2Ioooooooo03?oool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00<Ooo
o`03o`2Ioooooooo03?oool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`00<Oooo`03o`2I
oooooooo03?oool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`00<Oooo`03o`2Ioooooooo
03?oool00`0003?o03?o000X<ol000<0003oooooool0Roooo`00<Oooo`03o`2Ioooooooo03?oool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`00<Oooo`03o`2Ioooooooo03?oool20000:3?o
00030000oooooooo08coool0037oool00ol0VOooooooo`0coooo00<0000co`0co`009S?o00030000
oooooooo08goool0037oool00ol0VOooooooo`0coooo00<0000co`0co`009C?o00030000oooooooo
08koool0037oool00ol0VOooooooo`0coooo00<0000co`0co`0093?o00030000oooooooo08ooool0
037oool00ol0VOooooooo`0coooo00<0000co`0co`008c?o00030000oooooooo093oool0037oool0
0ol0VOooooooo`0coooo00<0000co`0co`008c?o00030000oooooooo093oool0037oool00ol0VOoo
ooooo`0coooo0P0002<co`000`000?ooooooo`2Aoooo000aoooo00?o09Woooooool0<oooo`030000
<ol0<ol0024co`000`000?ooooooo`2Boooo000aoooo00?o09Woooooool0<oooo`030000<ol0<ol0
020co`000`000?ooooooo`2Coooo000aoooo00?o09Woooooool0<oooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo000aoooo00?o09Woooooool0<oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000aoooo00?o09Woooooool0:oooo`D00003oooo00<0000co`0co`007c?o00030000
oooooooo09Coool0037oool00ol0VOooooooo`0]oooo00<0003oooooool00oooo`030000<ol0<ol0
01hco`000`000?ooooooo`2Eoooo000aoooo00?o09Woooooool0;Oooo`030000oooooooo00?oool2
00007c?o00030000oooooooo09Goool0037oool00ol0VOooooooo`0]oooo00<0003oooooool00ooo
o`030000<ol0<ol001dco`000`000?ooooooo`2Foooo000aoooo00?o09Woooooool0;Oooo`030000
oooooooo00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00<Oooo`03o`2Ioooooooo
02coool200001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000aoooo00?o09Wooooo
ool0<oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000aoooo00?o09Woooooool0<ooo
o`030000<ol0<ol001/co`000`000?ooooooo`2Hoooo000aoooo00?o09Woooooool0<oooo`80000L
<ol000<0003oooooool0V?ooo`00<Oooo`03o`2Ioooooooo03?oool00`0003?o03?o000J<ol000<0
003oooooool0VOooo`00<Oooo`03o`2Ioooooooo03?oool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`00<Oooo`03o`2Ioooooooo03?oool00`0003?o03?o000I<ol000<0003oooooool0V_oo
o`00<Oooo`03o`2Ioooooooo03?oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00<Ooo
o`03o`2Ioooooooo03?oool00`0003?o03?o000H<ol000<0003oooooool0Voooo`00<Oooo`03o`2I
oooooooo03?oool200006C?o00030000oooooooo09_oool0037oool00ol0VOooooooo`0coooo00<0
000co`0co`005c?o00030000oooooooo09coool0037oool00ol0VOooooooo`0coooo00<0000co`0c
o`005c?o00030000oooooooo09coool0037oool00ol0VOooooooo`0coooo00<0000co`0co`005S?o
00030000oooooooo09goool0037oool00ol0VOooooooo`0coooo00<0000co`0co`005S?o00030000
oooooooo09goool0037oool00ol0VOooooooo`0coooo00<0000co`0co`005S?o00030000oooooooo
09goool0037oool00ol0VOooooooo`0coooo00<0000co`0co`005C?o00030000oooooooo09koool0
037oool00ol0VOooooooo`0coooo0P0001Hco`000`000?ooooooo`2Noooo000aoooo00?o09Wooooo
ool0<oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000aoooo00?o09Woooooool0<ooo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000aoooo00?o09Woooooool0<oooo`030000
<ol0<ol001@co`000`000?ooooooo`2Ooooo000aoooo00?o09Woooooool0<oooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo000aoooo00?o09Woooooool0<oooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo000aoooo00?o09Woooooool0<oooo`80000E<ol000<0003oooooool0Wooo
o`00<Oooo`03o`2Ioooooooo03?oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00<Ooo
o`03o`2Ioooooooo03?oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00<Oooo`03o`2I
oooooooo03?oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00<Oooo`03o`2Ioooooooo
02_oool400001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo000aoooo00?o09Wooooo
ool0:oooo`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00<Ooo
o`03o`2Ioooooooo02coool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo000b
oooo00?o09Woooooool0;?ooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003ooooo
ool0XOooo`00<_ooo`03o`2Ioooooooo02[oool010000?ooooooo`0000Coool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00<_ooo`03o`2Ioooooooo02_oool200001Oooo`030000<ol0<ol0
014co`000`000?ooooooo`2Roooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo000boooo00?o09Woooooool0<_ooo`80000A<ol000<0003oooooool0Xoooo`00<_oo
o`03o`2Ioooooooo03;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00<_ooo`03o`2I
oooooooo03;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00<_ooo`03o`2Ioooooooo
03;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00<_ooo`03o`2Ioooooooo03;oool0
0`0003?o03?o000?<ol000<0003oooooool0Y?ooo`00<_ooo`03o`2Ioooooooo03;oool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`00<_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`00<_ooo`03o`2Ioooooooo03;oool2000043?o00030000oooooooo
0:Coool003;oool00ol0VOooooooo`0boooo00<0000co`0co`003S?o00030000oooooooo0:Goool0
03;oool00ol0VOooooooo`0boooo00<0000co`0co`003S?o00030000oooooooo0:Goool003;oool0
0ol0VOooooooo`0boooo00<0000co`0co`003S?o00030000oooooooo0:Goool003;oool00ol0VOoo
ooooo`0boooo00<0000co`0co`003S?o00030000oooooooo0:Goool003;oool00ol0VOooooooo`0b
oooo00<0000co`0co`003C?o00030000oooooooo0:Koool003;oool00ol0VOooooooo`0boooo0P00
00hco`000`000?ooooooo`2Voooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000dco`00
0`000?ooooooo`2Voooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000`co`000`000?ooooooo`2W
oooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000b
oooo00?o09Woooooool0<_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000boooo00?o
09Woooooool0<_ooo`80000=<ol000<0003oooooool0Yoooo`00<_ooo`03o`2Ioooooooo03;oool0
0`0003?o03?o000<<ol000<0003oooooool0Yoooo`00<_ooo`03o`2Ioooooooo03;oool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`00<_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00<_ooo`03o`2Ioooooooo02_oool200001Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`2Xoooo000boooo00?o09Woooooool0:_ooo`040000oooooooo00001?oo
o`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000boooo00?o09Woooooool0;?ooo`030000
oooooooo00?oool2000033?o00030000oooooooo0:Soool003;oool00ol0VOooooooo`0]oooo00<0
003oooooool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000boooo00?o09Wooooo
ool0:_ooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000b
oooo00?o09Woooooool0:oooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0
03;oool00ol0VOooooooo`0boooo00<0000co`0co`002S?o00030000oooooooo0:Woool003;oool0
0ol0VOooooooo`0boooo00<0000co`0co`002S?o00030000oooooooo0:Woool003;oool00ol0VOoo
ooooo`0boooo00<0000co`0co`002S?o00030000oooooooo0:Woool003;oool00ol0VOooooooo`0b
oooo0P0000/co`000`000?ooooooo`2Yoooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol0
00Xco`000`000?ooooooo`2Yoooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`2Zoooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000b
oooo00?o09Woooooool0<_ooo`80000:<ol000<0003oooooool0Z_ooo`00<_ooo`03o`2Ioooooooo
03;oool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00<_ooo`03o`2Ioooooooo03;oool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00<_ooo`03o`2Ioooooooo03;oool00`0003?o
03?o0008<ol000<0003oooooool0Zoooo`00<_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`00<_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`00<_ooo`03o`2Ioooooooo03;oool200002C?o00030000oooooooo0:_oool0
03;oool00ol0VOooooooo`0boooo00<0000co`0co`0023?o00030000oooooooo0:_oool003;oool0
0ol0VOooooooo`0boooo00<0000co`0co`0023?o00030000oooooooo0:_oool003;oool00ol0VOoo
ooooo`0boooo00<0000co`0co`001c?o00030000oooooooo0:coool003;oool00ol0VOooooooo`0b
oooo00<0000co`0co`001c?o00030000oooooooo0:coool003;oool00ol0VOooooooo`0boooo00<0
000co`0co`001c?o00030000oooooooo0:coool003;oool00ol0VOooooooo`0boooo0P0000Pco`00
0`000?ooooooo`2/oooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000Lco`000`000?oo
ooooo`2/oooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000boooo00?o09Woooooool0<_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000b
oooo00?o09Woooooool0<_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000boooo00?o
09Woooooool0;?ooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool003;oool0
0ol0VOooooooo`0]oooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000boooo00?o09Woooooool0:_ooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001O
oooo00@0003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0
067oool200001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo
00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000?oool300000oooo`<00004
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001Woooo2C?o00Coool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo
00000_ooo`040000oooooooo00001?ooo`030000oooooooo07Coool006Ooool9<ol01Oooo`030000
oooooooo00D0000Boooo00@0003oooooool00008oooo0`0000?oool300001?ooo`030000oooooooo
07Goool006Ooool9<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo07Goool006Ooool9<ol01_oo
o`030000oooooooo01Ooool200002_ooo`<00003oooo0`0000;oool00`000?ooooooo`1foooo001W
oooo2C?o0;3oool006Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.64) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.08255 .12361 L
.10458 .12361 L
.11448 .12361 L
.12507 .12361 L
.1302 .12361 L
.13273 .12361 L
.13506 .12361 L
.13615 .12361 L
.13718 .12361 L
s
.13718 .12361 m
.1376 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.64) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00;oool01?l0VOooooooo`0000Ooool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo01[oool0
0ol0VOooooooo`08oooo00<0003oooooool09_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T
<ol0400001Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00<oooo`03o`2Ioooooooo
037oool00`0003?o03?o0017<ol01@0006[oool003?oool00ol0VOooooooo`0aoooo00<0000co`0c
o`00@S?o00D0001_oooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol003dco`050000M?oo
o`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000i<ol0100007Woool003?oool00ol0VOoo
ooooo`0aoooo0P0003Pco`020000OOooo`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000e
<ol00P0007ooool003?oool00ol0VOooooooo`0aoooo00<0000co`0co`00<c?o00800021oooo000c
oooo00?o09Woooooool0<Oooo`030000<ol0<ol0034co`020000Poooo`00<oooo`03o`2Ioooooooo
037oool00`0003?o03?o000`<ol000<0003oooooool0Poooo`00<oooo`03o`2Ioooooooo037oool0
0`0003?o03?o000^<ol00P0008Koool003?oool00ol0VOooooooo`0aoooo0P0002dco`020000R?oo
o`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00<ooo
o`03o`2Ioooooooo037oool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`00<oooo`03o`2I
oooooooo037oool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`00<oooo`03o`2Ioooooooo
037oool00`0003?o03?o000X<ol000<0003oooooool0Roooo`00<oooo`03o`2Ioooooooo037oool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`00<oooo`03o`2Ioooooooo037oool20000:3?o
00030000oooooooo08coool003?oool00ol0VOooooooo`0aoooo00<0000co`0co`009S?o00030000
oooooooo08goool003?oool00ol0VOooooooo`0aoooo00<0000co`0co`009C?o00030000oooooooo
08koool003?oool00ol0VOooooooo`0aoooo00<0000co`0co`0093?o00030000oooooooo08ooool0
03?oool00ol0VOooooooo`0aoooo00<0000co`0co`008c?o00030000oooooooo093oool003?oool0
0ol0VOooooooo`0aoooo00<0000co`0co`008c?o00030000oooooooo093oool003?oool00ol0VOoo
ooooo`0aoooo0P0002<co`000`000?ooooooo`2Aoooo000coooo00?o09Woooooool0<Oooo`030000
<ol0<ol0024co`000`000?ooooooo`2Boooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol0
020co`000`000?ooooooo`2Coooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000coooo00?o09Woooooool0:Oooo`D00003oooo00<0000co`0co`007c?o00030000
oooooooo09Coool003?oool00ol0VOooooooo`0[oooo00<0003oooooool00oooo`030000<ol0<ol0
01hco`000`000?ooooooo`2Eoooo000coooo00?o09Woooooool0:oooo`030000oooooooo00?oool2
00007c?o00030000oooooooo09Goool003?oool00ol0VOooooooo`0[oooo00<0003oooooool00ooo
o`030000<ol0<ol001dco`000`000?ooooooo`2Foooo000coooo00?o09Woooooool0:oooo`030000
oooooooo00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00<oooo`03o`2Ioooooooo
02[oool200001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000coooo00?o09Wooooo
ool0<Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000coooo00?o09Woooooool0<Ooo
o`030000<ol0<ol001/co`000`000?ooooooo`2Hoooo000coooo00?o09Woooooool0<Oooo`80000L
<ol000<0003oooooool0V?ooo`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000J<ol000<0
003oooooool0VOooo`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000I<ol000<0003oooooool0V_oo
o`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00<ooo
o`03o`2Ioooooooo037oool00`0003?o03?o000H<ol000<0003oooooool0Voooo`00<oooo`03o`2I
oooooooo037oool200006C?o00030000oooooooo09_oool003?oool00ol0VOooooooo`0aoooo00<0
000co`0co`005c?o00030000oooooooo09coool003?oool00ol0VOooooooo`0aoooo00<0000co`0c
o`005c?o00030000oooooooo09coool003?oool00ol0VOooooooo`0aoooo00<0000co`0co`005S?o
00030000oooooooo09goool003?oool00ol0VOooooooo`0aoooo00<0000co`0co`005S?o00030000
oooooooo09goool003?oool00ol0VOooooooo`0aoooo00<0000co`0co`005S?o00030000oooooooo
09goool003?oool00ol0VOooooooo`0aoooo00<0000co`0co`005C?o00030000oooooooo09koool0
03?oool00ol0VOooooooo`0aoooo0P0001Hco`000`000?ooooooo`2Noooo000coooo00?o09Wooooo
ool0<Oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000coooo00?o09Woooooool0<Ooo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000coooo00?o09Woooooool0<Oooo`030000
<ol0<ol001@co`000`000?ooooooo`2Ooooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo000coooo00?o09Woooooool0<Oooo`80000E<ol000<0003oooooool0Wooo
o`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00<ooo
o`03o`2Ioooooooo037oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00<oooo`03o`2I
oooooooo037oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00<oooo`03o`2Ioooooooo
02Woool400001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo000coooo00?o09Wooooo
ool0:Oooo`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00<ooo
o`03o`2Ioooooooo02[oool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo000c
oooo00?o09Woooooool0:oooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003ooooo
ool0XOooo`00<oooo`03o`2Ioooooooo02Woool010000?ooooooo`0000Coool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00<oooo`03o`2Ioooooooo02[oool200001Oooo`030000<ol0<ol0
014co`000`000?ooooooo`2Roooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo000coooo00?o09Woooooool0<Oooo`80000A<ol000<0003oooooool0Xoooo`00<ooo
o`03o`2Ioooooooo037oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00<oooo`03o`2I
oooooooo037oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00<oooo`03o`2Ioooooooo
037oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00<oooo`03o`2Ioooooooo037oool0
0`0003?o03?o000?<ol000<0003oooooool0Y?ooo`00<oooo`03o`2Ioooooooo037oool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`00<oooo`03o`2Ioooooooo037oool2000043?o00030000oooooooo
0:Coool003?oool00ol0VOooooooo`0aoooo00<0000co`0co`003S?o00030000oooooooo0:Goool0
03?oool00ol0VOooooooo`0aoooo00<0000co`0co`003S?o00030000oooooooo0:Goool003?oool0
0ol0VOooooooo`0aoooo00<0000co`0co`003S?o00030000oooooooo0:Goool003?oool00ol0VOoo
ooooo`0aoooo00<0000co`0co`003S?o00030000oooooooo0:Goool003?oool00ol0VOooooooo`0a
oooo00<0000co`0co`003C?o00030000oooooooo0:Koool003?oool00ol0VOooooooo`0aoooo0P00
00hco`000`000?ooooooo`2Voooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000dco`00
0`000?ooooooo`2Voooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000`co`000`000?ooooooo`2W
oooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000c
oooo00?o09Woooooool0<Oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000coooo00?o
09Woooooool0<Oooo`80000=<ol000<0003oooooool0Yoooo`00<oooo`03o`2Ioooooooo037oool0
0`0003?o03?o000<<ol000<0003oooooool0Yoooo`00<oooo`03o`2Ioooooooo037oool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00<oooo`03o`2Ioooooooo02[oool200001Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`2Xoooo000coooo00?o09Woooooool0:Oooo`040000oooooooo00001?oo
o`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000coooo00?o09Woooooool0:oooo`030000
oooooooo00?oool2000033?o00030000oooooooo0:Soool003?oool00ol0VOooooooo`0/oooo00<0
003oooooool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000coooo00?o09Wooooo
ool0:Oooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000c
oooo00?o09Woooooool0:_ooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0
03?oool00ol0VOooooooo`0aoooo00<0000co`0co`002S?o00030000oooooooo0:Woool003?oool0
0ol0VOooooooo`0aoooo00<0000co`0co`002S?o00030000oooooooo0:Woool003?oool00ol0VOoo
ooooo`0aoooo00<0000co`0co`002S?o00030000oooooooo0:Woool003?oool00ol0VOooooooo`0a
oooo0P0000/co`000`000?ooooooo`2Yoooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol0
00Xco`000`000?ooooooo`2Yoooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000Tco`00
0`000?ooooooo`2Zoooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000c
oooo00?o09Woooooool0<Oooo`80000:<ol000<0003oooooool0Z_ooo`00<oooo`03o`2Ioooooooo
037oool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00<oooo`03o`2Ioooooooo037oool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00<oooo`03o`2Ioooooooo037oool00`0003?o
03?o0008<ol000<0003oooooool0Zoooo`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`00<oooo`03o`2Ioooooooo037oool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`00<oooo`03o`2Ioooooooo037oool200002C?o00030000oooooooo0:_oool0
03?oool00ol0VOooooooo`0aoooo00<0000co`0co`0023?o00030000oooooooo0:_oool003?oool0
0ol0VOooooooo`0aoooo00<0000co`0co`0023?o00030000oooooooo0:_oool003?oool00ol0VOoo
ooooo`0aoooo00<0000co`0co`001c?o00030000oooooooo0:coool003?oool00ol0VOooooooo`0a
oooo00<0000co`0co`001c?o00030000oooooooo0:coool003?oool00ol0VOooooooo`0aoooo00<0
000co`0co`001c?o00030000oooooooo0:coool003?oool00ol0VOooooooo`0aoooo0P0000Pco`00
0`000?ooooooo`2/oooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000Lco`000`000?oo
ooooo`2/oooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000coooo00?o09Woooooool0<Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000c
oooo00?o09Woooooool0<Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000coooo00?o
09Woooooool0:oooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool003?oool0
0ol0VOooooooo`0/oooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000coooo00?o09Woooooool0:Oooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001O
oooo00@0003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0
067oool200001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo
00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000?oool300001Oooo`<00002
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool01@000?ooooooooooo`00001goooo001Woooo2C?o00Coool00`000?ooooooo`02
oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`D00003
oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000Soool300000oooo`040000oooooooo00000oooo`030000oooooooo07Goool006Ooool9
<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooooooo`03
oooo00<0003oool000000oooo`030000oooooooo07Goool006Ooool9<ol01_ooo`030000oooooooo
01Ooool200002_ooo`<00004oooo0P0000;oool00`000?ooooooo`1foooo001Woooo2C?o0;3oool0
06Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.62) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.12507 .12361 L
.13506 .12361 L
.13979 .12361 L
.14186 .12361 L
.14305 .12361 L
.14415 .12361 L
s
.14415 .12361 m
.14458 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.62) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Coool00ol0V@000?ooo`06oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Loooo00?o
09Woooooool01_ooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool003Goool00ol0VOooooooo`0_
oooo00<0000co`0co`00Ac?o00D0001Zoooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol0
048co`050000Koooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000m<ol01@0007Coool0
03Goool00ol0VOooooooo`0_oooo00<0000co`0co`00>C?o00@0001ioooo000eoooo00?o09Wooooo
ool0;oooo`80000h<ol00P0007goool003Goool00ol0VOooooooo`0_oooo00<0000co`0co`00=C?o
0080001ooooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol003<co`020000POooo`00=Ooo
o`03o`2Ioooooooo02ooool00`0003?o03?o000a<ol00P0008?oool003Goool00ol0VOooooooo`0_
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool003Goool00ol0VOooooooo`0_oooo00<0
000co`0co`00;S?o00800026oooo000eoooo00?o09Woooooool0;oooo`80000]<ol00P0008Soool0
03Goool00ol0VOooooooo`0_oooo00<0000co`0co`00:c?o00030000oooooooo08Soool003Goool0
0ol0VOooooooo`0_oooo00<0000co`0co`00:S?o00030000oooooooo08Woool003Goool00ol0VOoo
ooooo`0_oooo00<0000co`0co`00:C?o00030000oooooooo08[oool003Goool00ol0VOooooooo`0_
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool003Goool00ol0VOooooooo`0_oooo00<0
000co`0co`00:3?o00030000oooooooo08_oool003Goool00ol0VOooooooo`0_oooo0P0002Pco`00
0`000?ooooooo`2<oooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000e
oooo00?o09Woooooool0;oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000eoooo00?o
09Woooooool0;oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000eoooo00?o09Wooooo
ool0;oooo`80000S<ol000<0003oooooool0TOooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00=Oooo`03o`2Ioooooooo02Ooool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000eoooo00?o09Woooooool0:Oooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00=Oooo`03o`2Ioooooooo02Woool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000eoooo00?o09Woooooool0:Oooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00=Oooo`03o`2Ioooooooo02Woool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool003Goool00ol0VOooooooo`0X
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00=Oooo`03o`2Ioooooooo
02ooool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00=Oooo`03o`2Ioooooooo02ooool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00=Oooo`03o`2Ioooooooo02ooool2000073?o
00030000oooooooo09Soool003Goool00ol0VOooooooo`0_oooo00<0000co`0co`006S?o00030000
oooooooo09Woool003Goool00ol0VOooooooo`0_oooo00<0000co`0co`006S?o00030000oooooooo
09Woool003Goool00ol0VOooooooo`0_oooo00<0000co`0co`006C?o00030000oooooooo09[oool0
03Goool00ol0VOooooooo`0_oooo00<0000co`0co`006C?o00030000oooooooo09[oool003Goool0
0ol0VOooooooo`0_oooo00<0000co`0co`0063?o00030000oooooooo09_oool003Goool00ol0VOoo
ooooo`0_oooo0P0001Tco`000`000?ooooooo`2Koooo000eoooo00?o09Woooooool0;oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000e
oooo00?o09Woooooool0;oooo`80000F<ol000<0003oooooool0W_ooo`00=Oooo`03o`2Ioooooooo
02ooool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00=Oooo`03o`2Ioooooooo02ooool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00=Oooo`03o`2Ioooooooo02ooool200005C?o00030000oooooooo09ooool0
03Goool00ol0VOooooooo`0_oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003Goool0
0ol0VOooooooo`0_oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003Goool00ol0VOoo
ooooo`0_oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003Goool00ol0VOooooooo`0W
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00=Oooo`03o`2Ioooooooo
02Ooool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool003Goool0
0ol0VOooooooo`0Xoooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00=Ooo
o`03o`2Ioooooooo02Woool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool003Goool00ol0VOooooooo`0Woooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool003Goool00ol0VOooooooo`0Xoooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00=Oooo`03o`2Ioooooooo02ooool200004C?o00030000oooooooo0:?oool003Goool0
0ol0VOooooooo`0_oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003Goool00ol0VOoo
ooooo`0_oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003Goool00ol0VOooooooo`0_
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003Goool00ol0VOooooooo`0_oooo00<0
000co`0co`003c?o00030000oooooooo0:Coool003Goool00ol0VOooooooo`0_oooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool003Goool00ol0VOooooooo`0_oooo00<0000co`0co`003c?o
00030000oooooooo0:Coool003Goool00ol0VOooooooo`0_oooo0P00010co`000`000?ooooooo`2T
oooo000eoooo00?o09Woooooool0;oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000e
oooo00?o09Woooooool0;oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000eoooo00?o
09Woooooool0;oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000eoooo00?o09Wooooo
ool0;oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000eoooo00?o09Woooooool0;ooo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000eoooo00?o09Woooooool0;oooo`80000>
<ol000<0003oooooool0Y_ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00=Ooo
o`03o`2Ioooooooo02ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00=Oooo`03o`2I
oooooooo02ooool200003C?o00030000oooooooo0:Ooool003Goool00ol0VOooooooo`0_oooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool003Goool00ol0VOooooooo`0_oooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool003Goool00ol0VOooooooo`0_oooo00<0000co`0co`002c?o
00030000oooooooo0:Soool003Goool00ol0VOooooooo`0Xoooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00=Oooo`03o`2Ioooooooo02Ooool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00=Oooo`03o`2Ioooooooo02Woool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000eoooo00?o09Woooooool0:_ooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00=Oooo`03o`2Ioooooooo
02Ooool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00=Ooo
o`03o`2Ioooooooo02Soool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000e
oooo00?o09Woooooool0;oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000eoooo00?o
09Woooooool0;oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000eoooo00?o09Wooooo
ool0;oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000eoooo00?o09Woooooool0;ooo
o`80000;<ol000<0003oooooool0ZOooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00=Ooo
o`03o`2Ioooooooo02ooool200002S?o00030000oooooooo0:[oool003Goool00ol0VOooooooo`0_
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool003Goool00ol0VOooooooo`0_oooo00<0
000co`0co`002C?o00030000oooooooo0:[oool003Goool00ol0VOooooooo`0_oooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool003Goool00ol0VOooooooo`0_oooo00<0000co`0co`0023?o
00030000oooooooo0:_oool003Goool00ol0VOooooooo`0_oooo00<0000co`0co`0023?o00030000
oooooooo0:_oool003Goool00ol0VOooooooo`0_oooo0P0000Tco`000`000?ooooooo`2[oooo000e
oooo00?o09Woooooool0;oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000eoooo00?o
09Woooooool0;oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000eoooo00?o09Wooooo
ool0;oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000eoooo00?o09Woooooool0;ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000eoooo00?o09Woooooool0;oooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000eoooo00?o09Woooooool0;oooo`800008<ol000<0
003oooooool0[?ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00=Oooo`03o`2Ioooooooo02ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00=Ooo
o`03o`2Ioooooooo02ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00=Oooo`03o`2I
oooooooo02Woool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000eoooo00?o
09Woooooool0:_ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00=Oooo`03o`2Ioooooooo02Ooool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo0`0000?oool400000ooo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00002oooo00<0003oooooool01?ooo`030000oooooooo07Goool006Ooool9<ol01?ooo`030000
oooooooo00;oool00`000?ooooooo`0Coooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool01?ooo`030000oooooooo07Coool006Ooool9<ol01Oooo`030000oooooooo
00D0000Boooo00@0003oooooool00008oooo0`0000Goool00`000?ooooooo`02oooo00<0003ooooo
ool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000005Oooo`040000oooooooo00002Ooo
o`030000oooooooo00;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001Woooo2C?o
00Koool00`000?ooooooo`0Goooo0P0000[oool300000oooo`800003oooo00<0003oooooool0M_oo
o`00Ioooo`Tco`2`oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.12507 .12361 L
.13506 .12361 L
.14415 .12361 L
.14635 .12361 L
.14868 .12361 L
.1499 .12361 L
.15059 .12361 L
s
.15059 .12361 m
.15085 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Moooo00?o
09Woooooool01Oooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool003Koool00ol0VOooooooo`0^
oooo00<0000co`0co`00Ac?o00D0001Zoooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol0
048co`050000Koooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000m<ol01@0007Coool0
03Koool00ol0VOooooooo`0^oooo00<0000co`0co`00>C?o00@0001ioooo000foooo00?o09Wooooo
ool0;_ooo`80000h<ol00P0007goool003Koool00ol0VOooooooo`0^oooo00<0000co`0co`00=C?o
0080001ooooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol003<co`020000POooo`00=_oo
o`03o`2Ioooooooo02koool00`0003?o03?o000a<ol00P0008?oool003Koool00ol0VOooooooo`0^
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool003Koool00ol0VOooooooo`0^oooo00<0
000co`0co`00;S?o00800026oooo000foooo00?o09Woooooool0;_ooo`80000]<ol00P0008Soool0
03Koool00ol0VOooooooo`0^oooo00<0000co`0co`00:c?o00030000oooooooo08Soool003Koool0
0ol0VOooooooo`0^oooo00<0000co`0co`00:S?o00030000oooooooo08Woool003Koool00ol0VOoo
ooooo`0^oooo00<0000co`0co`00:C?o00030000oooooooo08[oool003Koool00ol0VOooooooo`0^
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool003Koool00ol0VOooooooo`0^oooo00<0
000co`0co`00:3?o00030000oooooooo08_oool003Koool00ol0VOooooooo`0^oooo0P0002Pco`00
0`000?ooooooo`2<oooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000f
oooo00?o09Woooooool0;_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000foooo00?o
09Woooooool0;_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000foooo00?o09Wooooo
ool0;_ooo`80000S<ol000<0003oooooool0TOooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00=_ooo`03o`2Ioooooooo02Koool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000foooo00?o09Woooooool0:?ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00=_ooo`03o`2Ioooooooo02Soool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000foooo00?o09Woooooool0:?ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00=_ooo`03o`2Ioooooooo02Soool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool003Koool00ol0VOooooooo`0W
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00=_ooo`03o`2Ioooooooo
02koool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00=_ooo`03o`2Ioooooooo02koool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00=_ooo`03o`2Ioooooooo02koool2000073?o
00030000oooooooo09Soool003Koool00ol0VOooooooo`0^oooo00<0000co`0co`006S?o00030000
oooooooo09Woool003Koool00ol0VOooooooo`0^oooo00<0000co`0co`006S?o00030000oooooooo
09Woool003Koool00ol0VOooooooo`0^oooo00<0000co`0co`006C?o00030000oooooooo09[oool0
03Koool00ol0VOooooooo`0^oooo00<0000co`0co`006C?o00030000oooooooo09[oool003Koool0
0ol0VOooooooo`0^oooo00<0000co`0co`0063?o00030000oooooooo09_oool003Koool00ol0VOoo
ooooo`0^oooo0P0001Tco`000`000?ooooooo`2Koooo000foooo00?o09Woooooool0;_ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000f
oooo00?o09Woooooool0;_ooo`80000F<ol000<0003oooooool0W_ooo`00=_ooo`03o`2Ioooooooo
02koool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00=_ooo`03o`2Ioooooooo02koool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00=_ooo`03o`2Ioooooooo02koool200005C?o00030000oooooooo09ooool0
03Koool00ol0VOooooooo`0^oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003Koool0
0ol0VOooooooo`0^oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003Koool00ol0VOoo
ooooo`0^oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003Koool00ol0VOooooooo`0V
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00=_ooo`03o`2Ioooooooo
02Koool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool003Koool0
0ol0VOooooooo`0Woooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00=_oo
o`03o`2Ioooooooo02Soool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool003Koool00ol0VOooooooo`0Voooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool003Koool00ol0VOooooooo`0Woooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00=_ooo`03o`2Ioooooooo02koool200004C?o00030000oooooooo0:?oool003Koool0
0ol0VOooooooo`0^oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003Koool00ol0VOoo
ooooo`0^oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003Koool00ol0VOooooooo`0^
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003Koool00ol0VOooooooo`0^oooo00<0
000co`0co`003c?o00030000oooooooo0:Coool003Koool00ol0VOooooooo`0^oooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool003Koool00ol0VOooooooo`0^oooo00<0000co`0co`003c?o
00030000oooooooo0:Coool003Koool00ol0VOooooooo`0^oooo0P00010co`000`000?ooooooo`2T
oooo000foooo00?o09Woooooool0;_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000f
oooo00?o09Woooooool0;_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000foooo00?o
09Woooooool0;_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000foooo00?o09Wooooo
ool0;_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000foooo00?o09Woooooool0;_oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000foooo00?o09Woooooool0;_ooo`80000>
<ol000<0003oooooool0Y_ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00=_oo
o`03o`2Ioooooooo02koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00=_ooo`03o`2I
oooooooo02koool200003C?o00030000oooooooo0:Ooool003Koool00ol0VOooooooo`0^oooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool003Koool00ol0VOooooooo`0^oooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool003Koool00ol0VOooooooo`0^oooo00<0000co`0co`002c?o
00030000oooooooo0:Soool003Koool00ol0VOooooooo`0Woooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00=_ooo`03o`2Ioooooooo02Koool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00=_ooo`03o`2Ioooooooo02Soool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000foooo00?o09Woooooool0:Oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00=_ooo`03o`2Ioooooooo
02Koool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00=_oo
o`03o`2Ioooooooo02Ooool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000f
oooo00?o09Woooooool0;_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000foooo00?o
09Woooooool0;_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000foooo00?o09Wooooo
ool0;_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000foooo00?o09Woooooool0;_oo
o`80000;<ol000<0003oooooool0ZOooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00=_oo
o`03o`2Ioooooooo02koool200002S?o00030000oooooooo0:[oool003Koool00ol0VOooooooo`0^
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool003Koool00ol0VOooooooo`0^oooo00<0
000co`0co`002C?o00030000oooooooo0:[oool003Koool00ol0VOooooooo`0^oooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool003Koool00ol0VOooooooo`0^oooo00<0000co`0co`0023?o
00030000oooooooo0:_oool003Koool00ol0VOooooooo`0^oooo00<0000co`0co`0023?o00030000
oooooooo0:_oool003Koool00ol0VOooooooo`0^oooo0P0000Tco`000`000?ooooooo`2[oooo000f
oooo00?o09Woooooool0;_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000foooo00?o
09Woooooool0;_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000foooo00?o09Wooooo
ool0;_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000foooo00?o09Woooooool0;_oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000foooo00?o09Woooooool0;_ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000foooo00?o09Woooooool0;_ooo`800008<ol000<0
003oooooool0[?ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00=_ooo`03o`2Ioooooooo02koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00=_oo
o`03o`2Ioooooooo02koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00=_ooo`03o`2I
oooooooo02Soool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000foooo00?o
09Woooooool0:Oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00=_ooo`03o`2Ioooooooo02Koool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol02Ooo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001Woooo2C?o00Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool006Ooool9<ol02?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo0`0000Coool00`000?oo
ooooo`1hoooo001Woooo2C?o00Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool006Ooool9<ol01oooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0003oooooool0Moooo`00Iooo
o`Tco`08oooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool300001?ooo`030000
oooooooo07Soool006Ooool9<ol02?ooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Woool00`000?ooooooo`03oooo00<0003oooooool0N?ooo`00Ioooo`Tco`09oooo00<0003ooooo
ool05oooo`80000:oooo0`0000;oool00`000?ooooooo`1ioooo001Woooo2C?o0;3oool006Ooool8
<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.58) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.12507 .12361 L
.13506 .12361 L
.14415 .12361 L
.14868 .12361 L
.15107 .12361 L
.1536 .12361 L
.15581 .12361 L
.15707 .12361 L
s
.15707 .12361 m
.15754 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.58) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooool0V@05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Ooooo00?o
09Woooooool00oooo`030000oooooooo02Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool003Soool00ol0VOooooooo`0/
oooo00<0000co`0co`00Ac?o00D0001Zoooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol0
048co`050000Koooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000m<ol01@0007Coool0
03Soool00ol0VOooooooo`0/oooo00<0000co`0co`00>C?o00@0001ioooo000hoooo00?o09Wooooo
ool0;?ooo`80000h<ol00P0007goool003Soool00ol0VOooooooo`0/oooo00<0000co`0co`00=C?o
0080001ooooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol003<co`020000POooo`00>?oo
o`03o`2Ioooooooo02coool00`0003?o03?o000a<ol00P0008?oool003Soool00ol0VOooooooo`0/
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool003Soool00ol0VOooooooo`0/oooo00<0
000co`0co`00;S?o00800026oooo000hoooo00?o09Woooooool0;?ooo`80000]<ol00P0008Soool0
03Soool00ol0VOooooooo`0/oooo00<0000co`0co`00:c?o00030000oooooooo08Soool003Soool0
0ol0VOooooooo`0/oooo00<0000co`0co`00:S?o00030000oooooooo08Woool003Soool00ol0VOoo
ooooo`0/oooo00<0000co`0co`00:C?o00030000oooooooo08[oool003Soool00ol0VOooooooo`0/
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool003Soool00ol0VOooooooo`0/oooo00<0
000co`0co`00:3?o00030000oooooooo08_oool003Soool00ol0VOooooooo`0/oooo0P0002Pco`00
0`000?ooooooo`2<oooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000h
oooo00?o09Woooooool0;?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000hoooo00?o
09Woooooool0;?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000hoooo00?o09Wooooo
ool0;?ooo`80000S<ol000<0003oooooool0TOooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00>?ooo`03o`2Ioooooooo02Coool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000hoooo00?o09Woooooool09_ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00>?ooo`03o`2Ioooooooo02Koool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo000hoooo00?o09Woooooool09_ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00>?ooo`03o`2Ioooooooo02Koool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool003Soool00ol0VOooooooo`0U
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00>?ooo`03o`2Ioooooooo
02coool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00>?ooo`03o`2Ioooooooo02coool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00>?ooo`03o`2Ioooooooo02coool2000073?o
00030000oooooooo09Soool003Soool00ol0VOooooooo`0/oooo00<0000co`0co`006S?o00030000
oooooooo09Woool003Soool00ol0VOooooooo`0/oooo00<0000co`0co`006S?o00030000oooooooo
09Woool003Soool00ol0VOooooooo`0/oooo00<0000co`0co`006C?o00030000oooooooo09[oool0
03Soool00ol0VOooooooo`0/oooo00<0000co`0co`006C?o00030000oooooooo09[oool003Soool0
0ol0VOooooooo`0/oooo00<0000co`0co`0063?o00030000oooooooo09_oool003Soool00ol0VOoo
ooooo`0/oooo0P0001Tco`000`000?ooooooo`2Koooo000hoooo00?o09Woooooool0;?ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000h
oooo00?o09Woooooool0;?ooo`80000F<ol000<0003oooooool0W_ooo`00>?ooo`03o`2Ioooooooo
02coool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00>?ooo`03o`2Ioooooooo02coool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00>?ooo`03o`2Ioooooooo02coool200005C?o00030000oooooooo09ooool0
03Soool00ol0VOooooooo`0/oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003Soool0
0ol0VOooooooo`0/oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003Soool00ol0VOoo
ooooo`0/oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003Soool00ol0VOooooooo`0T
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00>?ooo`03o`2Ioooooooo
02Coool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool003Soool0
0ol0VOooooooo`0Uoooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00>?oo
o`03o`2Ioooooooo02Koool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool003Soool00ol0VOooooooo`0Toooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool003Soool00ol0VOooooooo`0Uoooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00>?ooo`03o`2Ioooooooo02coool200004C?o00030000oooooooo0:?oool003Soool0
0ol0VOooooooo`0/oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003Soool00ol0VOoo
ooooo`0/oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003Soool00ol0VOooooooo`0/
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003Soool00ol0VOooooooo`0/oooo00<0
000co`0co`003c?o00030000oooooooo0:Coool003Soool00ol0VOooooooo`0/oooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool003Soool00ol0VOooooooo`0/oooo00<0000co`0co`003c?o
00030000oooooooo0:Coool003Soool00ol0VOooooooo`0/oooo0P00010co`000`000?ooooooo`2T
oooo000hoooo00?o09Woooooool0;?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000h
oooo00?o09Woooooool0;?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000hoooo00?o
09Woooooool0;?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000hoooo00?o09Wooooo
ool0;?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000hoooo00?o09Woooooool0;?oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000hoooo00?o09Woooooool0;?ooo`80000>
<ol000<0003oooooool0Y_ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00>?oo
o`03o`2Ioooooooo02coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00>?ooo`03o`2I
oooooooo02coool200003C?o00030000oooooooo0:Ooool003Soool00ol0VOooooooo`0/oooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool003Soool00ol0VOooooooo`0/oooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool003Soool00ol0VOooooooo`0/oooo00<0000co`0co`002c?o
00030000oooooooo0:Soool003Soool00ol0VOooooooo`0Uoooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00>?ooo`03o`2Ioooooooo02Coool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00>?ooo`03o`2Ioooooooo02Koool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo000hoooo00?o09Woooooool09oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00>?ooo`03o`2Ioooooooo
02Coool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00>?oo
o`03o`2Ioooooooo02Goool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000h
oooo00?o09Woooooool0;?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000hoooo00?o
09Woooooool0;?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000hoooo00?o09Wooooo
ool0;?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000hoooo00?o09Woooooool0;?oo
o`80000;<ol000<0003oooooool0ZOooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00>?oo
o`03o`2Ioooooooo02coool200002S?o00030000oooooooo0:[oool003Soool00ol0VOooooooo`0/
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool003Soool00ol0VOooooooo`0/oooo00<0
000co`0co`002C?o00030000oooooooo0:[oool003Soool00ol0VOooooooo`0/oooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool003Soool00ol0VOooooooo`0/oooo00<0000co`0co`0023?o
00030000oooooooo0:_oool003Soool00ol0VOooooooo`0/oooo00<0000co`0co`0023?o00030000
oooooooo0:_oool003Soool00ol0VOooooooo`0/oooo0P0000Tco`000`000?ooooooo`2[oooo000h
oooo00?o09Woooooool0;?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000hoooo00?o
09Woooooool0;?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000hoooo00?o09Wooooo
ool0;?ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000hoooo00?o09Woooooool0;?oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000hoooo00?o09Woooooool0;?ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000hoooo00?o09Woooooool0;?ooo`800008<ol000<0
003oooooool0[?ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00>?ooo`03o`2Ioooooooo02coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00>?oo
o`03o`2Ioooooooo02coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00>?ooo`03o`2I
oooooooo02Koool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000hoooo00?o
09Woooooool09oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00>?ooo`03o`2Ioooooooo02Coool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000Coool200001?oo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00Ioooo`Tco`04oooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000_oool010000?ooooooo`00
00;oool00`000?ooooooo`02oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0003ooooo
ool01@0001;oool010000?ooooooo`0000Woool200001?ooo`800004oooo00<0003oooooool0MOoo
o`00Ioooo`Tco`05oooo00D0003oooooooooool000005Oooo`040000oooooooo00002Oooo`030000
oooooooo00;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001Woooo2C?o00Koool0
0`000?ooooooo`0Goooo0P0000[oool300000oooo`800003oooo00<0003oooooool0M_ooo`00Iooo
o`Tco`2`oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.56) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.12507 .12361 L
.14415 .12361 L
.1536 .12361 L
.15825 .12361 L
.16029 .12361 L
.16137 .12361 L
.16254 .12361 L
s
.16254 .12361 m
.16303 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.56) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool010000?ooooooool0V@Coool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo023oool0
0ol0VOooooooo`02oooo00<0003oooooool09_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T
<ol0400001Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00>Oooo`03o`2Ioooooooo
02_oool00`0003?o03?o0017<ol01@0006[oool003Woool00ol0VOooooooo`0[oooo00<0000co`0c
o`00@S?o00D0001_oooo000ioooo00?o09Woooooool0:oooo`030000<ol0<ol003dco`050000M?oo
o`00>Oooo`03o`2Ioooooooo02_oool00`0003?o03?o000i<ol0100007Woool003Woool00ol0VOoo
ooooo`0[oooo0P0003Pco`020000OOooo`00>Oooo`03o`2Ioooooooo02_oool00`0003?o03?o000e
<ol00P0007ooool003Woool00ol0VOooooooo`0[oooo00<0000co`0co`00<c?o00800021oooo000i
oooo00?o09Woooooool0:oooo`030000<ol0<ol0034co`020000Poooo`00>Oooo`03o`2Ioooooooo
02_oool00`0003?o03?o000`<ol000<0003oooooool0Poooo`00>Oooo`03o`2Ioooooooo02_oool0
0`0003?o03?o000^<ol00P0008Koool003Woool00ol0VOooooooo`0[oooo0P0002dco`020000R?oo
o`00>Oooo`03o`2Ioooooooo02_oool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00>Ooo
o`03o`2Ioooooooo02_oool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`00>Oooo`03o`2I
oooooooo02_oool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`00>Oooo`03o`2Ioooooooo
02_oool00`0003?o03?o000X<ol000<0003oooooool0Roooo`00>Oooo`03o`2Ioooooooo02_oool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`00>Oooo`03o`2Ioooooooo02_oool20000:3?o
00030000oooooooo08coool003Woool00ol0VOooooooo`0[oooo00<0000co`0co`009S?o00030000
oooooooo08goool003Woool00ol0VOooooooo`0[oooo00<0000co`0co`009C?o00030000oooooooo
08koool003Woool00ol0VOooooooo`0[oooo00<0000co`0co`0093?o00030000oooooooo08ooool0
03Woool00ol0VOooooooo`0[oooo00<0000co`0co`008c?o00030000oooooooo093oool003Woool0
0ol0VOooooooo`0[oooo00<0000co`0co`008c?o00030000oooooooo093oool003Woool00ol0VOoo
ooooo`0[oooo0P0002<co`000`000?ooooooo`2Aoooo000ioooo00?o09Woooooool0:oooo`030000
<ol0<ol0024co`000`000?ooooooo`2Boooo000ioooo00?o09Woooooool0:oooo`030000<ol0<ol0
020co`000`000?ooooooo`2Coooo000ioooo00?o09Woooooool0:oooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo000ioooo00?o09Woooooool0:oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo000ioooo00?o09Woooooool08oooo`D00003oooo00<0000co`0co`007c?o00030000
oooooooo09Coool003Woool00ol0VOooooooo`0Uoooo00<0003oooooool00oooo`030000<ol0<ol0
01hco`000`000?ooooooo`2Eoooo000ioooo00?o09Woooooool09Oooo`030000oooooooo00?oool2
00007c?o00030000oooooooo09Goool003Woool00ol0VOooooooo`0Uoooo00<0003oooooool00ooo
o`030000<ol0<ol001dco`000`000?ooooooo`2Foooo000ioooo00?o09Woooooool09Oooo`030000
oooooooo00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00>Oooo`03o`2Ioooooooo
02Coool200001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000ioooo00?o09Wooooo
ool0:oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo000ioooo00?o09Woooooool0:ooo
o`030000<ol0<ol001/co`000`000?ooooooo`2Hoooo000ioooo00?o09Woooooool0:oooo`80000L
<ol000<0003oooooool0V?ooo`00>Oooo`03o`2Ioooooooo02_oool00`0003?o03?o000J<ol000<0
003oooooool0VOooo`00>Oooo`03o`2Ioooooooo02_oool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`00>Oooo`03o`2Ioooooooo02_oool00`0003?o03?o000I<ol000<0003oooooool0V_oo
o`00>Oooo`03o`2Ioooooooo02_oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00>Ooo
o`03o`2Ioooooooo02_oool00`0003?o03?o000H<ol000<0003oooooool0Voooo`00>Oooo`03o`2I
oooooooo02_oool200006C?o00030000oooooooo09_oool003Woool00ol0VOooooooo`0[oooo00<0
000co`0co`005c?o00030000oooooooo09coool003Woool00ol0VOooooooo`0[oooo00<0000co`0c
o`005c?o00030000oooooooo09coool003Woool00ol0VOooooooo`0[oooo00<0000co`0co`005S?o
00030000oooooooo09goool003Woool00ol0VOooooooo`0[oooo00<0000co`0co`005S?o00030000
oooooooo09goool003Woool00ol0VOooooooo`0[oooo00<0000co`0co`005S?o00030000oooooooo
09goool003Woool00ol0VOooooooo`0[oooo00<0000co`0co`005C?o00030000oooooooo09koool0
03Woool00ol0VOooooooo`0[oooo0P0001Hco`000`000?ooooooo`2Noooo000ioooo00?o09Wooooo
ool0:oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000ioooo00?o09Woooooool0:ooo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000ioooo00?o09Woooooool0:oooo`030000
<ol0<ol001@co`000`000?ooooooo`2Ooooo000ioooo00?o09Woooooool0:oooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo000ioooo00?o09Woooooool0:oooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo000ioooo00?o09Woooooool0:oooo`80000E<ol000<0003oooooool0Wooo
o`00>Oooo`03o`2Ioooooooo02_oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00>Ooo
o`03o`2Ioooooooo02_oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00>Oooo`03o`2I
oooooooo02_oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00>Oooo`03o`2Ioooooooo
02?oool400001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo000ioooo00?o09Wooooo
ool08oooo`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00>Ooo
o`03o`2Ioooooooo02Coool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo000j
oooo00?o09Woooooool09?ooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003ooooo
ool0XOooo`00>_ooo`03o`2Ioooooooo02;oool010000?ooooooo`0000Coool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00>_ooo`03o`2Ioooooooo02?oool200001Oooo`030000<ol0<ol0
014co`000`000?ooooooo`2Roooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo000joooo00?o09Woooooool0:_ooo`80000A<ol000<0003oooooool0Xoooo`00>_oo
o`03o`2Ioooooooo02[oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00>_ooo`03o`2I
oooooooo02[oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00>_ooo`03o`2Ioooooooo
02[oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00>_ooo`03o`2Ioooooooo02[oool0
0`0003?o03?o000?<ol000<0003oooooool0Y?ooo`00>_ooo`03o`2Ioooooooo02[oool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`00>_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`00>_ooo`03o`2Ioooooooo02[oool2000043?o00030000oooooooo
0:Coool003[oool00ol0VOooooooo`0Zoooo00<0000co`0co`003S?o00030000oooooooo0:Goool0
03[oool00ol0VOooooooo`0Zoooo00<0000co`0co`003S?o00030000oooooooo0:Goool003[oool0
0ol0VOooooooo`0Zoooo00<0000co`0co`003S?o00030000oooooooo0:Goool003[oool00ol0VOoo
ooooo`0Zoooo00<0000co`0co`003S?o00030000oooooooo0:Goool003[oool00ol0VOooooooo`0Z
oooo00<0000co`0co`003C?o00030000oooooooo0:Koool003[oool00ol0VOooooooo`0Zoooo0P00
00hco`000`000?ooooooo`2Voooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000dco`00
0`000?ooooooo`2Voooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000`co`000`000?ooooooo`2W
oooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000j
oooo00?o09Woooooool0:_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000joooo00?o
09Woooooool0:_ooo`80000=<ol000<0003oooooool0Yoooo`00>_ooo`03o`2Ioooooooo02[oool0
0`0003?o03?o000<<ol000<0003oooooool0Yoooo`00>_ooo`03o`2Ioooooooo02[oool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`00>_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00>_ooo`03o`2Ioooooooo02?oool200001Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`2Xoooo000joooo00?o09Woooooool08_ooo`040000oooooooo00001?oo
o`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000joooo00?o09Woooooool09?ooo`030000
oooooooo00?oool2000033?o00030000oooooooo0:Soool003[oool00ol0VOooooooo`0Uoooo00<0
003oooooool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000joooo00?o09Wooooo
ool08_ooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000j
oooo00?o09Woooooool08oooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0
03[oool00ol0VOooooooo`0Zoooo00<0000co`0co`002S?o00030000oooooooo0:Woool003[oool0
0ol0VOooooooo`0Zoooo00<0000co`0co`002S?o00030000oooooooo0:Woool003[oool00ol0VOoo
ooooo`0Zoooo00<0000co`0co`002S?o00030000oooooooo0:Woool003[oool00ol0VOooooooo`0Z
oooo0P0000/co`000`000?ooooooo`2Yoooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol0
00Xco`000`000?ooooooo`2Yoooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`2Zoooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000j
oooo00?o09Woooooool0:_ooo`80000:<ol000<0003oooooool0Z_ooo`00>_ooo`03o`2Ioooooooo
02[oool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00>_ooo`03o`2Ioooooooo02[oool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00>_ooo`03o`2Ioooooooo02[oool00`0003?o
03?o0008<ol000<0003oooooool0Zoooo`00>_ooo`03o`2Ioooooooo02[oool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`00>_ooo`03o`2Ioooooooo02[oool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`00>_ooo`03o`2Ioooooooo02[oool200002C?o00030000oooooooo0:_oool0
03[oool00ol0VOooooooo`0Zoooo00<0000co`0co`0023?o00030000oooooooo0:_oool003[oool0
0ol0VOooooooo`0Zoooo00<0000co`0co`0023?o00030000oooooooo0:_oool003[oool00ol0VOoo
ooooo`0Zoooo00<0000co`0co`001c?o00030000oooooooo0:coool003[oool00ol0VOooooooo`0Z
oooo00<0000co`0co`001c?o00030000oooooooo0:coool003[oool00ol0VOooooooo`0Zoooo00<0
000co`0co`001c?o00030000oooooooo0:coool003[oool00ol0VOooooooo`0Zoooo0P0000Pco`00
0`000?ooooooo`2/oooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000Lco`000`000?oo
ooooo`2/oooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000joooo00?o09Woooooool0:_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000j
oooo00?o09Woooooool0:_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000joooo00?o
09Woooooool09?ooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool003[oool0
0ol0VOooooooo`0Uoooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo000joooo00?o09Woooooool08_ooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001O
oooo00@0003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0
067oool200001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo
00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Coool200000oooo`<00004
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001Woooo2C?o00Coool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002oooo`040000oooooooo
00000_ooo`030000oooooooo00;oool00`000?ooooooo`1doooo001Woooo2C?o00Goool00`000?oo
ooooo`0500004_ooo`040000oooooooo00002Oooo`800003oooo0`0000Coool00`000?ooooooo`1e
oooo001Woooo2C?o00Goool01@000?ooooooooooo`00000Eoooo00@0003oooooool00009oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`1eoooo001Woooo2C?o00Koool0
0`000?ooooooo`0Goooo0P0000[oool300000oooo`<00002oooo00<0003oooooool0M_ooo`00Iooo
o`Tco`2`oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.54) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.12507 .12361 L
.14415 .12361 L
.1536 .12361 L
.16254 .12361 L
.16494 .12361 L
.16748 .12361 L
.1688 .12361 L
.16956 .12361 L
s
.16956 .12361 m
.16984 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.54) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo00Co09Wooooo
ool00008oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02;oool0
1?l0VOooooooo`0002Soool00`0003?o03?o000U<ol000<0000co`0co`0093?o0100000Ioooo00<0
003oooooool09_ooo`030000oooooooo01Goool003_oool00ol0VOooooooo`0Yoooo00<0000co`0c
o`00Ac?o00D0001Zoooo000koooo00?o09Woooooool0:Oooo`030000<ol0<ol0048co`050000Kooo
o`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000m<ol01@0007Coool003_oool00ol0VOoo
ooooo`0Yoooo00<0000co`0co`00>C?o00@0001ioooo000koooo00?o09Woooooool0:Oooo`80000h
<ol00P0007goool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`00=C?o0080001ooooo000k
oooo00?o09Woooooool0:Oooo`030000<ol0<ol003<co`020000POooo`00>oooo`03o`2Ioooooooo
02Woool00`0003?o03?o000a<ol00P0008?oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0c
o`00<3?o00030000oooooooo08?oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`00;S?o
00800026oooo000koooo00?o09Woooooool0:Oooo`80000]<ol00P0008Soool003_oool00ol0VOoo
ooooo`0Yoooo00<0000co`0co`00:c?o00030000oooooooo08Soool003_oool00ol0VOooooooo`0Y
oooo00<0000co`0co`00:S?o00030000oooooooo08Woool003_oool00ol0VOooooooo`0Yoooo00<0
000co`0co`00:C?o00030000oooooooo08[oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0c
o`00:3?o00030000oooooooo08_oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`00:3?o
00030000oooooooo08_oool003_oool00ol0VOooooooo`0Yoooo0P0002Pco`000`000?ooooooo`2<
oooo000koooo00?o09Woooooool0:Oooo`030000<ol0<ol002Hco`000`000?ooooooo`2=oooo000k
oooo00?o09Woooooool0:Oooo`030000<ol0<ol002Dco`000`000?ooooooo`2>oooo000koooo00?o
09Woooooool0:Oooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo000koooo00?o09Wooooo
ool0:Oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000koooo00?o09Woooooool0:Ooo
o`030000<ol0<ol002<co`000`000?ooooooo`2@oooo000koooo00?o09Woooooool0:Oooo`80000S
<ol000<0003oooooool0TOooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000Q<ol000<0
003oooooool0T_ooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000P<ol000<0003ooooo
ool0Toooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000P<ol000<0003oooooool0Tooo
o`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000O<ol000<0003oooooool0U?ooo`00>ooo
o`03o`2Ioooooooo027oool500000oooo`030000<ol0<ol001lco`000`000?ooooooo`2Doooo000k
oooo00?o09Woooooool08oooo`030000oooooooo00?oool00`0003?o03?o000N<ol000<0003ooooo
ool0UOooo`00>oooo`03o`2Ioooooooo02?oool00`000?ooooooo`03oooo0P0001lco`000`000?oo
ooooo`2Eoooo000koooo00?o09Woooooool08oooo`030000oooooooo00?oool00`0003?o03?o000M
<ol000<0003oooooool0U_ooo`00>oooo`03o`2Ioooooooo02?oool00`000?ooooooo`03oooo00<0
000co`0co`007C?o00030000oooooooo09Koool003_oool00ol0VOooooooo`0Roooo0P0000Goool0
0`0003?o03?o000L<ol000<0003oooooool0Uoooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o
03?o000L<ol000<0003oooooool0Uoooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000K
<ol000<0003oooooool0V?ooo`00>oooo`03o`2Ioooooooo02Woool2000073?o00030000oooooooo
09Soool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`006S?o00030000oooooooo09Woool0
03_oool00ol0VOooooooo`0Yoooo00<0000co`0co`006S?o00030000oooooooo09Woool003_oool0
0ol0VOooooooo`0Yoooo00<0000co`0co`006C?o00030000oooooooo09[oool003_oool00ol0VOoo
ooooo`0Yoooo00<0000co`0co`006C?o00030000oooooooo09[oool003_oool00ol0VOooooooo`0Y
oooo00<0000co`0co`0063?o00030000oooooooo09_oool003_oool00ol0VOooooooo`0Yoooo0P00
01Tco`000`000?ooooooo`2Koooo000koooo00?o09Woooooool0:Oooo`030000<ol0<ol001Lco`00
0`000?ooooooo`2Loooo000koooo00?o09Woooooool0:Oooo`030000<ol0<ol001Lco`000`000?oo
ooooo`2Loooo000koooo00?o09Woooooool0:Oooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo000koooo00?o09Woooooool0:Oooo`030000<ol0<ol001Hco`000`000?ooooooo`2Moooo000k
oooo00?o09Woooooool0:Oooo`030000<ol0<ol001Hco`000`000?ooooooo`2Moooo000koooo00?o
09Woooooool0:Oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo000koooo00?o09Wooooo
ool0:Oooo`80000F<ol000<0003oooooool0W_ooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o
03?o000E<ol000<0003oooooool0W_ooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000E
<ol000<0003oooooool0W_ooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000D<ol000<0003ooooo
ool0Woooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000D<ol000<0003oooooool0Wooo
o`00>oooo`03o`2Ioooooooo02Woool200005C?o00030000oooooooo09ooool003_oool00ol0VOoo
ooooo`0Yoooo00<0000co`0co`004c?o00030000oooooooo0:3oool003_oool00ol0VOooooooo`0Y
oooo00<0000co`0co`004c?o00030000oooooooo0:3oool003_oool00ol0VOooooooo`0Yoooo00<0
000co`0co`004c?o00030000oooooooo0:3oool003_oool00ol0VOooooooo`0Qoooo100000Coool0
0`0003?o03?o000C<ol000<0003oooooool0X?ooo`00>oooo`03o`2Ioooooooo027oool00`000?oo
ooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool003_oool00ol0VOooooooo`0R
oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00>oooo`03o`2Ioooooooo
02?oool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo0:7oool003_oool0
0ol0VOooooooo`0Qoooo00@0003oooooool00004oooo00<0000co`0co`004C?o00030000oooooooo
0:;oool003_oool00ol0VOooooooo`0Roooo0P0000Goool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000A<ol000<0003oooooool0X_oo
o`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000A<ol000<0003oooooool0X_ooo`00>ooo
o`03o`2Ioooooooo02Woool200004C?o00030000oooooooo0:?oool003_oool00ol0VOooooooo`0Y
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool003_oool00ol0VOooooooo`0Yoooo00<0
000co`0co`0043?o00030000oooooooo0:?oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0c
o`0043?o00030000oooooooo0:?oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`003c?o
00030000oooooooo0:Coool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`003c?o00030000
oooooooo0:Coool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`003c?o00030000oooooooo
0:Coool003_oool00ol0VOooooooo`0Yoooo0P00010co`000`000?ooooooo`2Toooo000koooo00?o
09Woooooool0:Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000koooo00?o09Wooooo
ool0:Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000koooo00?o09Woooooool0:Ooo
o`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo000koooo00?o09Woooooool0:Oooo`030000
<ol0<ol000hco`000`000?ooooooo`2Uoooo000koooo00?o09Woooooool0:Oooo`030000<ol0<ol0
00dco`000`000?ooooooo`2Voooo000koooo00?o09Woooooool0:Oooo`80000><ol000<0003ooooo
ool0Y_ooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000=<ol000<0003oooooool0Y_oo
o`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000=<ol000<0003oooooool0Y_ooo`00>ooo
o`03o`2Ioooooooo02Woool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00>oooo`03o`2I
oooooooo02Woool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00>oooo`03o`2Ioooooooo
02Woool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00>oooo`03o`2Ioooooooo02Woool2
00003C?o00030000oooooooo0:Ooool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`0033?o
00030000oooooooo0:Ooool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`0033?o00030000
oooooooo0:Ooool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`002c?o00030000oooooooo
0:Soool003_oool00ol0VOooooooo`0Roooo0P0000Goool00`0003?o03?o000;<ol000<0003ooooo
ool0Z?ooo`00>oooo`03o`2Ioooooooo027oool010000?ooooooo`0000Coool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00>oooo`03o`2Ioooooooo02?oool00`000?ooooooo`03oooo0P00
00`co`000`000?ooooooo`2Xoooo000koooo00?o09Woooooool09?ooo`030000oooooooo00;oool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00>oooo`03o`2Ioooooooo027oool010000?oo
ooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00>oooo`03o`2Ioooooooo
02;oool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000koooo00?o09Wooooo
ool0:Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000koooo00?o09Woooooool0:Ooo
o`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo000koooo00?o09Woooooool0:Oooo`030000
<ol0<ol000Xco`000`000?ooooooo`2Yoooo000koooo00?o09Woooooool0:Oooo`80000;<ol000<0
003oooooool0ZOooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o000:<ol000<0003ooooo
ool0ZOooo`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00>ooo
o`03o`2Ioooooooo02Woool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00>oooo`03o`2I
oooooooo02Woool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00>oooo`03o`2Ioooooooo
02Woool200002S?o00030000oooooooo0:[oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0c
o`002C?o00030000oooooooo0:[oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`002C?o
00030000oooooooo0:[oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`0023?o00030000
oooooooo0:_oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`0023?o00030000oooooooo
0:_oool003_oool00ol0VOooooooo`0Yoooo00<0000co`0co`0023?o00030000oooooooo0:_oool0
03_oool00ol0VOooooooo`0Yoooo0P0000Tco`000`000?ooooooo`2[oooo000koooo00?o09Wooooo
ool0:Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000koooo00?o09Woooooool0:Ooo
o`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo000koooo00?o09Woooooool0:Oooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo000koooo00?o09Woooooool0:Oooo`030000<ol0<ol0
00Lco`000`000?ooooooo`2/oooo000koooo00?o09Woooooool0:Oooo`030000<ol0<ol000Lco`00
0`000?ooooooo`2/oooo000koooo00?o09Woooooool0:Oooo`800008<ol000<0003oooooool0[?oo
o`00>oooo`03o`2Ioooooooo02Woool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00>ooo
o`03o`2Ioooooooo02Woool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00>oooo`03o`2I
oooooooo02Woool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00>oooo`03o`2Ioooooooo
02Woool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00>oooo`03o`2Ioooooooo02?oool3
00000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000koooo00?o09Woooooool09?oo
o`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00>oooo`03o`2I
oooooooo027oool500000oooo`800008<ol000<0003oooooool0[?ooo`00Goooo`040000oooooooo
00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Qoooo0P0000Coool:
<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_ooo`030000oooooooo
02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08oooo00<0003ooooo
ool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo00;oool200001?oo
o`030000oooooooo00goool200001?ooo`800004oooo0P0000Goool300000_ooo`030000oooooooo
07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00D0
003oooooooooool00000Moooo`00Ioooo`Tco`04oooo00<0003oooooool00_ooo`030000oooooooo
01?oool010000?ooooooo`0000_oool00`000?ooooooo`0500000oooo`030000oooooooo07Coool0
06Ooool9<ol01Oooo`030000oooooooo00D0000Boooo00@0003oooooool00009oooo0P0000?oool0
10000?ooooooo`0000?oool00`000?ooooooo`1eoooo001Woooo2C?o00Goool01@000?oooooooooo
o`00000Eoooo00@0003oooooool00009oooo00<0003oooooool00oooo`030000oooo000000?oool0
0`000?ooooooo`1eoooo001Woooo2C?o00Koool00`000?ooooooo`0Goooo0P0000[oool300001?oo
o`800002oooo00<0003oooooool0M_ooo`00Ioooo`Tco`2`oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.52) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.12507 .12361 L
.14415 .12361 L
.16254 .12361 L
.16783 .12361 L
.17044 .12361 L
.17284 .12361 L
.17502 .12361 L
.17612 .12361 L
s
.17612 .12361 m
.1766 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.52) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`04oooo00?o09T0003o
ool01oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Toooo00?o
09T0003oool09oooo`030000<ol0<ol002Dco`000`0003?o03?o000T<ol0400001Woool00`000?oo
ooooo`0Voooo00<0003oooooool05Oooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o0017
<ol01@0006[oool003goool00ol0VOooooooo`0Woooo00<0000co`0co`00@S?o00D0001_oooo000m
oooo00?o09Woooooool09oooo`030000<ol0<ol003dco`050000M?ooo`00?Oooo`03o`2Ioooooooo
02Ooool00`0003?o03?o000i<ol0100007Woool003goool00ol0VOooooooo`0Woooo0P0003Pco`02
0000OOooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000e<ol00P0007ooool003goool0
0ol0VOooooooo`0Woooo00<0000co`0co`00<c?o00800021oooo000moooo00?o09Woooooool09ooo
o`030000<ol0<ol0034co`020000Poooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000`
<ol000<0003oooooool0Poooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000^<ol00P00
08Koool003goool00ol0VOooooooo`0Woooo0P0002dco`020000R?ooo`00?Oooo`03o`2Ioooooooo
02Ooool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00?Oooo`03o`2Ioooooooo02Ooool0
0`0003?o03?o000Z<ol000<0003oooooool0ROooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o
03?o000Y<ol000<0003oooooool0R_ooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000X
<ol000<0003oooooool0Roooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000X<ol000<0
003oooooool0Roooo`00?Oooo`03o`2Ioooooooo02Ooool20000:3?o00030000oooooooo08coool0
03goool00ol0VOooooooo`0Woooo00<0000co`0co`009S?o00030000oooooooo08goool003goool0
0ol0VOooooooo`0Woooo00<0000co`0co`009C?o00030000oooooooo08koool003goool00ol0VOoo
ooooo`0Woooo00<0000co`0co`0093?o00030000oooooooo08ooool003goool00ol0VOooooooo`0W
oooo00<0000co`0co`008c?o00030000oooooooo093oool003goool00ol0VOooooooo`0Woooo00<0
000co`0co`008c?o00030000oooooooo093oool003goool00ol0VOooooooo`0Woooo0P0002<co`00
0`000?ooooooo`2Aoooo000moooo00?o09Woooooool09oooo`030000<ol0<ol0024co`000`000?oo
ooooo`2Boooo000moooo00?o09Woooooool09oooo`030000<ol0<ol0020co`000`000?ooooooo`2C
oooo000moooo00?o09Woooooool09oooo`030000<ol0<ol0020co`000`000?ooooooo`2Coooo000m
oooo00?o09Woooooool09oooo`030000<ol0<ol001lco`000`000?ooooooo`2Doooo000moooo00?o
09Woooooool07oooo`D00003oooo00<0000co`0co`007c?o00030000oooooooo09Coool003goool0
0ol0VOooooooo`0Qoooo00<0003oooooool00oooo`030000<ol0<ol001hco`000`000?ooooooo`2E
oooo000moooo00?o09Woooooool08Oooo`030000oooooooo00?oool200007c?o00030000oooooooo
09Goool003goool00ol0VOooooooo`0Qoooo00<0003oooooool00oooo`030000<ol0<ol001dco`00
0`000?ooooooo`2Foooo000moooo00?o09Woooooool08Oooo`030000oooooooo00?oool00`0003?o
03?o000M<ol000<0003oooooool0U_ooo`00?Oooo`03o`2Ioooooooo023oool200001Oooo`030000
<ol0<ol001`co`000`000?ooooooo`2Goooo000moooo00?o09Woooooool09oooo`030000<ol0<ol0
01`co`000`000?ooooooo`2Goooo000moooo00?o09Woooooool09oooo`030000<ol0<ol001/co`00
0`000?ooooooo`2Hoooo000moooo00?o09Woooooool09oooo`80000L<ol000<0003oooooool0V?oo
o`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000J<ol000<0003oooooool0VOooo`00?Ooo
o`03o`2Ioooooooo02Ooool00`0003?o03?o000J<ol000<0003oooooool0VOooo`00?Oooo`03o`2I
oooooooo02Ooool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00?Oooo`03o`2Ioooooooo
02Ooool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00?Oooo`03o`2Ioooooooo02Ooool0
0`0003?o03?o000H<ol000<0003oooooool0Voooo`00?Oooo`03o`2Ioooooooo02Ooool200006C?o
00030000oooooooo09_oool003goool00ol0VOooooooo`0Woooo00<0000co`0co`005c?o00030000
oooooooo09coool003goool00ol0VOooooooo`0Woooo00<0000co`0co`005c?o00030000oooooooo
09coool003goool00ol0VOooooooo`0Woooo00<0000co`0co`005S?o00030000oooooooo09goool0
03goool00ol0VOooooooo`0Woooo00<0000co`0co`005S?o00030000oooooooo09goool003goool0
0ol0VOooooooo`0Woooo00<0000co`0co`005S?o00030000oooooooo09goool003goool00ol0VOoo
ooooo`0Woooo00<0000co`0co`005C?o00030000oooooooo09koool003goool00ol0VOooooooo`0W
oooo0P0001Hco`000`000?ooooooo`2Noooo000moooo00?o09Woooooool09oooo`030000<ol0<ol0
01Dco`000`000?ooooooo`2Noooo000moooo00?o09Woooooool09oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`2Noooo000moooo00?o09Woooooool09oooo`030000<ol0<ol001@co`000`000?oo
ooooo`2Ooooo000moooo00?o09Woooooool09oooo`030000<ol0<ol001@co`000`000?ooooooo`2O
oooo000moooo00?o09Woooooool09oooo`030000<ol0<ol001@co`000`000?ooooooo`2Ooooo000m
oooo00?o09Woooooool09oooo`80000E<ol000<0003oooooool0Woooo`00?Oooo`03o`2Ioooooooo
02Ooool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00?Oooo`03o`2Ioooooooo02Ooool0
0`0003?o03?o000C<ol000<0003oooooool0X?ooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o
03?o000C<ol000<0003oooooool0X?ooo`00?Oooo`03o`2Ioooooooo01ooool400001?ooo`030000
<ol0<ol001<co`000`000?ooooooo`2Poooo000moooo00?o09Woooooool07oooo`030000oooooooo
00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00?Oooo`03o`2Ioooooooo023oool0
0`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo000moooo00?o09Woooooool08Ooo
o`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00?Oooo`03o`2I
oooooooo01ooool010000?ooooooo`0000Coool00`0003?o03?o000A<ol000<0003oooooool0X_oo
o`00?Oooo`03o`2Ioooooooo023oool200001Oooo`030000<ol0<ol0014co`000`000?ooooooo`2R
oooo000moooo00?o09Woooooool09oooo`030000<ol0<ol0014co`000`000?ooooooo`2Roooo000m
oooo00?o09Woooooool09oooo`030000<ol0<ol0014co`000`000?ooooooo`2Roooo000moooo00?o
09Woooooool09oooo`80000A<ol000<0003oooooool0Xoooo`00?Oooo`03o`2Ioooooooo02Ooool0
0`0003?o03?o000@<ol000<0003oooooool0Xoooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o
03?o000@<ol000<0003oooooool0Xoooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000@
<ol000<0003oooooool0Xoooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000?<ol000<0
003oooooool0Y?ooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000?<ol000<0003ooooo
ool0Y?ooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000?<ol000<0003oooooool0Y?oo
o`00?Oooo`03o`2Ioooooooo02Ooool2000043?o00030000oooooooo0:Coool003goool00ol0VOoo
ooooo`0Woooo00<0000co`0co`003S?o00030000oooooooo0:Goool003goool00ol0VOooooooo`0W
oooo00<0000co`0co`003S?o00030000oooooooo0:Goool003goool00ol0VOooooooo`0Woooo00<0
000co`0co`003S?o00030000oooooooo0:Goool003goool00ol0VOooooooo`0Woooo00<0000co`0c
o`003S?o00030000oooooooo0:Goool003goool00ol0VOooooooo`0Woooo00<0000co`0co`003C?o
00030000oooooooo0:Koool003goool00ol0VOooooooo`0Woooo0P0000hco`000`000?ooooooo`2V
oooo000moooo00?o09Woooooool09oooo`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000m
oooo00?o09Woooooool09oooo`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000moooo00?o
09Woooooool09oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000moooo00?o09Wooooo
ool09oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000moooo00?o09Woooooool09ooo
o`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000moooo00?o09Woooooool09oooo`80000=
<ol000<0003oooooool0Yoooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000<<ol000<0
003oooooool0Yoooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000<<ol000<0003ooooo
ool0Yoooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o000;<ol000<0003oooooool0Z?oo
o`00?Oooo`03o`2Ioooooooo023oool200001Oooo`030000<ol0<ol000/co`000`000?ooooooo`2X
oooo000moooo00?o09Woooooool07oooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`00
0`000?ooooooo`2Xoooo000moooo00?o09Woooooool08Oooo`030000oooooooo00?oool2000033?o
00030000oooooooo0:Soool003goool00ol0VOooooooo`0Roooo00<0003oooooool00_ooo`030000
<ol0<ol000/co`000`000?ooooooo`2Xoooo000moooo00?o09Woooooool07oooo`040000oooooooo
00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000moooo00?o09Woooooool08?oo
o`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool003goool00ol0VOooooooo`0W
oooo00<0000co`0co`002S?o00030000oooooooo0:Woool003goool00ol0VOooooooo`0Woooo00<0
000co`0co`002S?o00030000oooooooo0:Woool003goool00ol0VOooooooo`0Woooo00<0000co`0c
o`002S?o00030000oooooooo0:Woool003goool00ol0VOooooooo`0Woooo0P0000/co`000`000?oo
ooooo`2Yoooo000moooo00?o09Woooooool09oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Y
oooo000moooo00?o09Woooooool09oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000m
oooo00?o09Woooooool09oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000moooo00?o
09Woooooool09oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000moooo00?o09Wooooo
ool09oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000moooo00?o09Woooooool09ooo
o`80000:<ol000<0003oooooool0Z_ooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o0009
<ol000<0003oooooool0Z_ooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o0008<ol000<0003ooooo
ool0Zoooo`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o0008<ol000<0003oooooool0Zooo
o`00?Oooo`03o`2Ioooooooo02Ooool00`0003?o03?o0008<ol000<0003oooooool0Zoooo`00?Ooo
o`03o`2Ioooooooo02Ooool200002C?o00030000oooooooo0:_oool003goool00ol0VOooooooo`0W
oooo00<0000co`0co`0023?o00030000oooooooo0:_oool003goool00ol0VOooooooo`0Woooo00<0
000co`0co`0023?o00030000oooooooo0:_oool003goool00ol0VOooooooo`0Woooo00<0000co`0c
o`001c?o00030000oooooooo0:coool003goool00ol0VOooooooo`0Woooo00<0000co`0co`001c?o
00030000oooooooo0:coool003goool00ol0VOooooooo`0Woooo00<0000co`0co`001c?o00030000
oooooooo0:coool003goool00ol0VOooooooo`0Woooo0P0000Pco`000`000?ooooooo`2/oooo000m
oooo00?o09Woooooool09oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000moooo00?o
09Woooooool09oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000moooo00?o09Wooooo
ool09oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000moooo00?o09Woooooool09ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000moooo00?o09Woooooool08Oooo`<00003
oooo00<0000co`0co`001c?o00030000oooooooo0:coool003goool00ol0VOooooooo`0Roooo00<0
003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000moooo00?o09Wooooo
ool07oooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001Ooooo00@0003oooooool00004
oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0067oool200001?ooo`Xco`2_
oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06oooo00<0003oooooool0;_oo
o`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo00Soool00`000?ooooooo`0U
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03Oooo`800004oooo0P0000Coool200000oooo`@00003oooo00<0003oooooool0MOoo
o`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?ooooooo`0000;oool00`000?oo
ooooo`04oooo00<0003oooooool0MOooo`00Ioooo`Tco`04oooo00<0003oooooool00_ooo`030000
oooooooo01?oool010000?ooooooo`0000_oool01@000?ooooooooooo`000006oooo00<0003ooooo
ool0M?ooo`00Ioooo`Tco`05oooo00<0003oooooool01@0001;oool010000?ooooooo`0000Woool2
00001Oooo`030000oooooooo00;oool00`000?ooooooo`1eoooo001Woooo2C?o00Goool01@000?oo
ooooooooo`00000Eoooo00@0003oooooool00009oooo00<0003oooooool00_ooo`040000oooooooo
00000oooo`030000oooooooo07Goool006Ooool9<ol01_ooo`030000oooooooo01Ooool200002_oo
o`<00003oooo0P0000?oool00`000?ooooooo`1foooo001Woooo2C?o0;3oool006Ooool8<ol0/Ooo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.16408 .12361 L
.17277 .12361 L
.17735 .12361 L
.17986 .12361 L
.18109 .12361 L
.18221 .12361 L
s
.18221 .12361 m
.18269 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool09_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T<ol0400001Woool00`000?oo
ooooo`0Voooo00<0003oooooool05Oooo`00?_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0017
<ol01@0006[oool003koool00ol0VOooooooo`0Voooo00<0000co`0co`00@S?o00D0001_oooo000n
oooo00?o09Woooooool09_ooo`030000<ol0<ol003dco`050000M?ooo`00?_ooo`03o`2Ioooooooo
02Koool00`0003?o03?o000i<ol0100007Woool003koool00ol0VOooooooo`0Voooo0P0003Pco`02
0000OOooo`00?_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000e<ol00P0007ooool003koool0
0ol0VOooooooo`0Voooo00<0000co`0co`00<c?o00800021oooo000noooo00?o09Woooooool09_oo
o`030000<ol0<ol0034co`020000Poooo`00?_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000`
<ol000<0003oooooool0Poooo`00?_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000^<ol00P00
08Koool003koool00ol0VOooooooo`0Voooo0P0002dco`020000R?ooo`00?_ooo`03o`2Ioooooooo
02Koool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00?_ooo`03o`2Ioooooooo02Koool0
0`0003?o03?o000Z<ol000<0003oooooool0ROooo`00?_ooo`03o`2Ioooooooo02Koool00`0003?o
03?o000Y<ol000<0003oooooool0R_ooo`00?_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000X
<ol000<0003oooooool0Roooo`00?_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000X<ol000<0
003oooooool0Roooo`00?_ooo`03o`2Ioooooooo02Koool20000:3?o00030000oooooooo08coool0
03koool00ol0VOooooooo`0Voooo00<0000co`0co`009S?o00030000oooooooo08goool003koool0
0ol0VOooooooo`0Voooo00<0000co`0co`009C?o00030000oooooooo08koool003koool00ol0VOoo
ooooo`0Voooo00<0000co`0co`0093?o00030000oooooooo08ooool003koool00ol0VOooooooo`0V
oooo00<0000co`0co`008c?o00030000oooooooo093oool003koool00ol0VOooooooo`0Voooo00<0
000co`0co`008c?o00030000oooooooo093oool003koool00ol0VOooooooo`0Voooo0P0002<co`00
0`000?ooooooo`2Aoooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol0024co`000`000?oo
ooooo`2Boooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol0020co`000`000?ooooooo`2C
oooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol0020co`000`000?ooooooo`2Coooo000n
oooo00?o09Woooooool09_ooo`030000<ol0<ol001lco`000`000?ooooooo`2Doooo000noooo00?o
09Woooooool07_ooo`D00003oooo00<0000co`0co`007c?o00030000oooooooo09Coool003koool0
0ol0VOooooooo`0Poooo00<0003oooooool00oooo`030000<ol0<ol001hco`000`000?ooooooo`2E
oooo000noooo00?o09Woooooool08?ooo`030000oooooooo00?oool200007c?o00030000oooooooo
09Goool003koool00ol0VOooooooo`0Poooo00<0003oooooool00oooo`030000<ol0<ol001dco`00
0`000?ooooooo`2Foooo000noooo00?o09Woooooool08?ooo`030000oooooooo00?oool00`0003?o
03?o000M<ol000<0003oooooool0U_ooo`00?_ooo`03o`2Ioooooooo01ooool200001Oooo`030000
<ol0<ol001`co`000`000?ooooooo`2Goooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol0
01`co`000`000?ooooooo`2Goooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol001/co`00
0`000?ooooooo`2Hoooo000noooo00?o09Woooooool09_ooo`80000L<ol000<0003oooooool0V?oo
o`00?_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000J<ol000<0003oooooool0VOooo`00?_oo
o`03o`2Ioooooooo02Koool00`0003?o03?o000J<ol000<0003oooooool0VOooo`00?_ooo`03o`2I
oooooooo02Koool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00?_ooo`03o`2Ioooooooo
02Koool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00?_ooo`03o`2Ioooooooo02Koool0
0`0003?o03?o000H<ol000<0003oooooool0Voooo`00?_ooo`03o`2Ioooooooo02Koool200006C?o
00030000oooooooo09_oool003koool00ol0VOooooooo`0Voooo00<0000co`0co`005c?o00030000
oooooooo09coool003koool00ol0VOooooooo`0Voooo00<0000co`0co`005c?o00030000oooooooo
09coool003koool00ol0VOooooooo`0Voooo00<0000co`0co`005S?o00030000oooooooo09goool0
03koool00ol0VOooooooo`0Voooo00<0000co`0co`005S?o00030000oooooooo09goool003koool0
0ol0VOooooooo`0Voooo00<0000co`0co`005S?o00030000oooooooo09goool003koool00ol0VOoo
ooooo`0Voooo00<0000co`0co`005C?o00030000oooooooo09koool003koool00ol0VOooooooo`0V
oooo0P0001Hco`000`000?ooooooo`2Noooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol0
01Dco`000`000?ooooooo`2Noooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol001Dco`00
0`000?ooooooo`2Noooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol001@co`000`000?oo
ooooo`2Ooooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol001@co`000`000?ooooooo`2O
oooo000noooo00?o09Woooooool09_ooo`030000<ol0<ol001@co`000`000?ooooooo`2Ooooo000n
oooo00?o09Woooooool09_ooo`80000E<ol000<0003oooooool0Woooo`00?_ooo`03o`2Ioooooooo
02Koool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00?_ooo`03o`2Ioooooooo02Koool0
0`0003?o03?o000C<ol000<0003oooooool0X?ooo`00?_ooo`03o`2Ioooooooo02Koool00`0003?o
03?o000C<ol000<0003oooooool0X?ooo`00?_ooo`03o`2Ioooooooo01koool400001?ooo`030000
<ol0<ol001<co`000`000?ooooooo`2Poooo000noooo00?o09Woooooool07_ooo`030000oooooooo
00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00?_ooo`03o`2Ioooooooo01ooool0
0`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo000ooooo00?o09Woooooool07ooo
o`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00?oooo`03o`2I
oooooooo01goool010000?ooooooo`0000Coool00`0003?o03?o000A<ol000<0003oooooool0X_oo
o`00?oooo`03o`2Ioooooooo01koool200001Oooo`030000<ol0<ol0014co`000`000?ooooooo`2R
oooo000ooooo00?o09Woooooool09Oooo`030000<ol0<ol0014co`000`000?ooooooo`2Roooo000o
oooo00?o09Woooooool09Oooo`030000<ol0<ol0014co`000`000?ooooooo`2Roooo000ooooo00?o
09Woooooool09Oooo`80000A<ol000<0003oooooool0Xoooo`00?oooo`03o`2Ioooooooo02Goool0
0`0003?o03?o000@<ol000<0003oooooool0Xoooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o
03?o000@<ol000<0003oooooool0Xoooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o000@
<ol000<0003oooooool0Xoooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o000?<ol000<0
003oooooool0Y?ooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o000?<ol000<0003ooooo
ool0Y?ooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o000?<ol000<0003oooooool0Y?oo
o`00?oooo`03o`2Ioooooooo02Goool2000043?o00030000oooooooo0:Coool003ooool00ol0VOoo
ooooo`0Uoooo00<0000co`0co`003S?o00030000oooooooo0:Goool003ooool00ol0VOooooooo`0U
oooo00<0000co`0co`003S?o00030000oooooooo0:Goool003ooool00ol0VOooooooo`0Uoooo00<0
000co`0co`003S?o00030000oooooooo0:Goool003ooool00ol0VOooooooo`0Uoooo00<0000co`0c
o`003S?o00030000oooooooo0:Goool003ooool00ol0VOooooooo`0Uoooo00<0000co`0co`003C?o
00030000oooooooo0:Koool003ooool00ol0VOooooooo`0Uoooo0P0000hco`000`000?ooooooo`2V
oooo000ooooo00?o09Woooooool09Oooo`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000o
oooo00?o09Woooooool09Oooo`030000<ol0<ol000dco`000`000?ooooooo`2Voooo000ooooo00?o
09Woooooool09Oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000ooooo00?o09Wooooo
ool09Oooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000ooooo00?o09Woooooool09Ooo
o`030000<ol0<ol000`co`000`000?ooooooo`2Woooo000ooooo00?o09Woooooool09Oooo`80000=
<ol000<0003oooooool0Yoooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o000<<ol000<0
003oooooool0Yoooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o000<<ol000<0003ooooo
ool0Yoooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o000;<ol000<0003oooooool0Z?oo
o`00?oooo`03o`2Ioooooooo01koool200001Oooo`030000<ol0<ol000/co`000`000?ooooooo`2X
oooo000ooooo00?o09Woooooool07Oooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`00
0`000?ooooooo`2Xoooo000ooooo00?o09Woooooool07oooo`030000oooooooo00?oool2000033?o
00030000oooooooo0:Soool003ooool00ol0VOooooooo`0Poooo00<0003oooooool00_ooo`030000
<ol0<ol000/co`000`000?ooooooo`2Xoooo000ooooo00?o09Woooooool07Oooo`040000oooooooo
00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo000ooooo00?o09Woooooool07_oo
o`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool003ooool00ol0VOooooooo`0U
oooo00<0000co`0co`002S?o00030000oooooooo0:Woool003ooool00ol0VOooooooo`0Uoooo00<0
000co`0co`002S?o00030000oooooooo0:Woool003ooool00ol0VOooooooo`0Uoooo00<0000co`0c
o`002S?o00030000oooooooo0:Woool003ooool00ol0VOooooooo`0Uoooo0P0000/co`000`000?oo
ooooo`2Yoooo000ooooo00?o09Woooooool09Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Y
oooo000ooooo00?o09Woooooool09Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000o
oooo00?o09Woooooool09Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000ooooo00?o
09Woooooool09Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000ooooo00?o09Wooooo
ool09Oooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo000ooooo00?o09Woooooool09Ooo
o`80000:<ol000<0003oooooool0Z_ooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o0009
<ol000<0003oooooool0Z_ooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o0008<ol000<0003ooooo
ool0Zoooo`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o0008<ol000<0003oooooool0Zooo
o`00?oooo`03o`2Ioooooooo02Goool00`0003?o03?o0008<ol000<0003oooooool0Zoooo`00?ooo
o`03o`2Ioooooooo02Goool200002C?o00030000oooooooo0:_oool003ooool00ol0VOooooooo`0U
oooo00<0000co`0co`0023?o00030000oooooooo0:_oool003ooool00ol0VOooooooo`0Uoooo00<0
000co`0co`0023?o00030000oooooooo0:_oool003ooool00ol0VOooooooo`0Uoooo00<0000co`0c
o`001c?o00030000oooooooo0:coool003ooool00ol0VOooooooo`0Uoooo00<0000co`0co`001c?o
00030000oooooooo0:coool003ooool00ol0VOooooooo`0Uoooo00<0000co`0co`001c?o00030000
oooooooo0:coool003ooool00ol0VOooooooo`0Uoooo0P0000Pco`000`000?ooooooo`2/oooo000o
oooo00?o09Woooooool09Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000ooooo00?o
09Woooooool09Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000ooooo00?o09Wooooo
ool09Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000ooooo00?o09Woooooool09Ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000ooooo00?o09Woooooool07oooo`<00003
oooo00<0000co`0co`001c?o00030000oooooooo0:coool003ooool00ol0VOooooooo`0Poooo00<0
003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo000ooooo00?o09Wooooo
ool07Oooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001Ooooo00@0003oooooool00004
oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0067oool200001?ooo`Xco`2_
oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`09oooo00<0003oooooool0:?oo
o`030000oooooooo07Woool006Ooool9<ol02?ooo`030000oooooooo00Soool00`000?ooooooo`0O
oooo00<0003oooooool0N?ooo`00Ioooo`Tco`08oooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03Oooo`800004oooo0P0000Coool200001?ooo`030000oooooooo07Soool006Ooool9
<ol02?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00003oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00Ioooo`Tco`07oooo00<0003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo00<0003oooooool0Moooo`00Ioooo`Tco`08oooo00<0003ooooo
ool01@0001;oool010000?ooooooo`0000Woool200001?ooo`030000oooooooo07Soool006Ooool9
<ol02?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooooooo`03
oooo00<0003oooooool0N?ooo`00Ioooo`Tco`09oooo00<0003oooooool05oooo`80000:oooo0`00
00;oool00`000?ooooooo`1ioooo001Woooo2C?o0;3oool006Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.48) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.16408 .12361 L
.17277 .12361 L
.18221 .12361 L
.18475 .12361 L
.18614 .12361 L
.18744 .12361 L
.18855 .12361 L
s
.18855 .12361 m
.18902 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.48) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
09T01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003ooooo09T09_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T<ol0400001Woool00`000?oo
ooooo`0Voooo00<0003oooooool05Oooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o0017
<ol01@0006[oool0043oool00ol0VOooooooo`0Toooo00<0000co`0co`00@S?o00D0001_oooo0010
oooo00?o09Woooooool09?ooo`030000<ol0<ol003dco`050000M?ooo`00@?ooo`03o`2Ioooooooo
02Coool00`0003?o03?o000i<ol0100007Woool0043oool00ol0VOooooooo`0Toooo0P0003Pco`02
0000OOooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000e<ol00P0007ooool0043oool0
0ol0VOooooooo`0Toooo00<0000co`0co`00<c?o00800021oooo0010oooo00?o09Woooooool09?oo
o`030000<ol0<ol0034co`020000Poooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000`
<ol000<0003oooooool0Poooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000^<ol00P00
08Koool0043oool00ol0VOooooooo`0Toooo0P0002dco`020000R?ooo`00@?ooo`03o`2Ioooooooo
02Coool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00@?ooo`03o`2Ioooooooo02Coool0
0`0003?o03?o000Z<ol000<0003oooooool0ROooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o
03?o000Y<ol000<0003oooooool0R_ooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000X
<ol000<0003oooooool0Roooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000X<ol000<0
003oooooool0Roooo`00@?ooo`03o`2Ioooooooo02Coool20000:3?o00030000oooooooo08coool0
043oool00ol0VOooooooo`0Toooo00<0000co`0co`009S?o00030000oooooooo08goool0043oool0
0ol0VOooooooo`0Toooo00<0000co`0co`009C?o00030000oooooooo08koool0043oool00ol0VOoo
ooooo`0Toooo00<0000co`0co`0093?o00030000oooooooo08ooool0043oool00ol0VOooooooo`0T
oooo00<0000co`0co`008c?o00030000oooooooo093oool0043oool00ol0VOooooooo`0Toooo00<0
000co`0co`008c?o00030000oooooooo093oool0043oool00ol0VOooooooo`0Toooo0P0002<co`00
0`000?ooooooo`2Aoooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol0024co`000`000?oo
ooooo`2Boooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol0020co`000`000?ooooooo`2C
oooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol0020co`000`000?ooooooo`2Coooo0010
oooo00?o09Woooooool09?ooo`030000<ol0<ol001lco`000`000?ooooooo`2Doooo0010oooo00?o
09Woooooool07?ooo`D00003oooo00<0000co`0co`007c?o00030000oooooooo09Coool0043oool0
0ol0VOooooooo`0Noooo00<0003oooooool00oooo`030000<ol0<ol001hco`000`000?ooooooo`2E
oooo0010oooo00?o09Woooooool07_ooo`030000oooooooo00?oool200007c?o00030000oooooooo
09Goool0043oool00ol0VOooooooo`0Noooo00<0003oooooool00oooo`030000<ol0<ol001dco`00
0`000?ooooooo`2Foooo0010oooo00?o09Woooooool07_ooo`030000oooooooo00?oool00`0003?o
03?o000M<ol000<0003oooooool0U_ooo`00@?ooo`03o`2Ioooooooo01goool200001Oooo`030000
<ol0<ol001`co`000`000?ooooooo`2Goooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol0
01`co`000`000?ooooooo`2Goooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol001/co`00
0`000?ooooooo`2Hoooo0010oooo00?o09Woooooool09?ooo`80000L<ol000<0003oooooool0V?oo
o`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000J<ol000<0003oooooool0VOooo`00@?oo
o`03o`2Ioooooooo02Coool00`0003?o03?o000J<ol000<0003oooooool0VOooo`00@?ooo`03o`2I
oooooooo02Coool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00@?ooo`03o`2Ioooooooo
02Coool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00@?ooo`03o`2Ioooooooo02Coool0
0`0003?o03?o000H<ol000<0003oooooool0Voooo`00@?ooo`03o`2Ioooooooo02Coool200006C?o
00030000oooooooo09_oool0043oool00ol0VOooooooo`0Toooo00<0000co`0co`005c?o00030000
oooooooo09coool0043oool00ol0VOooooooo`0Toooo00<0000co`0co`005c?o00030000oooooooo
09coool0043oool00ol0VOooooooo`0Toooo00<0000co`0co`005S?o00030000oooooooo09goool0
043oool00ol0VOooooooo`0Toooo00<0000co`0co`005S?o00030000oooooooo09goool0043oool0
0ol0VOooooooo`0Toooo00<0000co`0co`005S?o00030000oooooooo09goool0043oool00ol0VOoo
ooooo`0Toooo00<0000co`0co`005C?o00030000oooooooo09koool0043oool00ol0VOooooooo`0T
oooo0P0001Hco`000`000?ooooooo`2Noooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol0
01Dco`000`000?ooooooo`2Noooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol001Dco`00
0`000?ooooooo`2Noooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol001@co`000`000?oo
ooooo`2Ooooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol001@co`000`000?ooooooo`2O
oooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol001@co`000`000?ooooooo`2Ooooo0010
oooo00?o09Woooooool09?ooo`80000E<ol000<0003oooooool0Woooo`00@?ooo`03o`2Ioooooooo
02Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00@?ooo`03o`2Ioooooooo02Coool0
0`0003?o03?o000C<ol000<0003oooooool0X?ooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o
03?o000C<ol000<0003oooooool0X?ooo`00@?ooo`03o`2Ioooooooo01coool400001?ooo`030000
<ol0<ol001<co`000`000?ooooooo`2Poooo0010oooo00?o09Woooooool07?ooo`030000oooooooo
00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00@?ooo`03o`2Ioooooooo01goool0
0`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo0010oooo00?o09Woooooool07_oo
o`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00@?ooo`03o`2I
oooooooo01coool010000?ooooooo`0000Coool00`0003?o03?o000A<ol000<0003oooooool0X_oo
o`00@?ooo`03o`2Ioooooooo01goool200001Oooo`030000<ol0<ol0014co`000`000?ooooooo`2R
oooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol0014co`000`000?ooooooo`2Roooo0010
oooo00?o09Woooooool09?ooo`030000<ol0<ol0014co`000`000?ooooooo`2Roooo0010oooo00?o
09Woooooool09?ooo`80000A<ol000<0003oooooool0Xoooo`00@?ooo`03o`2Ioooooooo02Coool0
0`0003?o03?o000@<ol000<0003oooooool0Xoooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o
03?o000@<ol000<0003oooooool0Xoooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000@
<ol000<0003oooooool0Xoooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000?<ol000<0
003oooooool0Y?ooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000?<ol000<0003ooooo
ool0Y?ooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000?<ol000<0003oooooool0Y?oo
o`00@?ooo`03o`2Ioooooooo02Coool2000043?o00030000oooooooo0:Coool0043oool00ol0VOoo
ooooo`0Toooo00<0000co`0co`003S?o00030000oooooooo0:Goool0043oool00ol0VOooooooo`0T
oooo00<0000co`0co`003S?o00030000oooooooo0:Goool0043oool00ol0VOooooooo`0Toooo00<0
000co`0co`003S?o00030000oooooooo0:Goool0043oool00ol0VOooooooo`0Toooo00<0000co`0c
o`003S?o00030000oooooooo0:Goool0043oool00ol0VOooooooo`0Toooo00<0000co`0co`003C?o
00030000oooooooo0:Koool0043oool00ol0VOooooooo`0Toooo0P0000hco`000`000?ooooooo`2V
oooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol000dco`000`000?ooooooo`2Voooo0010
oooo00?o09Woooooool09?ooo`030000<ol0<ol000dco`000`000?ooooooo`2Voooo0010oooo00?o
09Woooooool09?ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo0010oooo00?o09Wooooo
ool09?ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo0010oooo00?o09Woooooool09?oo
o`030000<ol0<ol000`co`000`000?ooooooo`2Woooo0010oooo00?o09Woooooool09?ooo`80000=
<ol000<0003oooooool0Yoooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000<<ol000<0
003oooooool0Yoooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000<<ol000<0003ooooo
ool0Yoooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000;<ol000<0003oooooool0Z?oo
o`00@?ooo`03o`2Ioooooooo01goool200001Oooo`030000<ol0<ol000/co`000`000?ooooooo`2X
oooo0010oooo00?o09Woooooool07?ooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`00
0`000?ooooooo`2Xoooo0010oooo00?o09Woooooool07_ooo`030000oooooooo00?oool2000033?o
00030000oooooooo0:Soool0043oool00ol0VOooooooo`0Ooooo00<0003oooooool00_ooo`030000
<ol0<ol000/co`000`000?ooooooo`2Xoooo0010oooo00?o09Woooooool07?ooo`040000oooooooo
00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo0010oooo00?o09Woooooool07Ooo
o`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0043oool00ol0VOooooooo`0T
oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0043oool00ol0VOooooooo`0Toooo00<0
000co`0co`002S?o00030000oooooooo0:Woool0043oool00ol0VOooooooo`0Toooo00<0000co`0c
o`002S?o00030000oooooooo0:Woool0043oool00ol0VOooooooo`0Toooo0P0000/co`000`000?oo
ooooo`2Yoooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Y
oooo0010oooo00?o09Woooooool09?ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo0010
oooo00?o09Woooooool09?ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo0010oooo00?o
09Woooooool09?ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo0010oooo00?o09Wooooo
ool09?ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo0010oooo00?o09Woooooool09?oo
o`80000:<ol000<0003oooooool0Z_ooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o0009
<ol000<0003oooooool0Z_ooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o0008<ol000<0003ooooo
ool0Zoooo`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o0008<ol000<0003oooooool0Zooo
o`00@?ooo`03o`2Ioooooooo02Coool00`0003?o03?o0008<ol000<0003oooooool0Zoooo`00@?oo
o`03o`2Ioooooooo02Coool200002C?o00030000oooooooo0:_oool0043oool00ol0VOooooooo`0T
oooo00<0000co`0co`0023?o00030000oooooooo0:_oool0043oool00ol0VOooooooo`0Toooo00<0
000co`0co`0023?o00030000oooooooo0:_oool0043oool00ol0VOooooooo`0Toooo00<0000co`0c
o`001c?o00030000oooooooo0:coool0043oool00ol0VOooooooo`0Toooo00<0000co`0co`001c?o
00030000oooooooo0:coool0043oool00ol0VOooooooo`0Toooo00<0000co`0co`001c?o00030000
oooooooo0:coool0043oool00ol0VOooooooo`0Toooo0P0000Pco`000`000?ooooooo`2/oooo0010
oooo00?o09Woooooool09?ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0010oooo00?o
09Woooooool09?ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0010oooo00?o09Wooooo
ool09?ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0010oooo00?o09Woooooool09?oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0010oooo00?o09Woooooool07_ooo`<00003
oooo00<0000co`0co`001c?o00030000oooooooo0:coool0043oool00ol0VOooooooo`0Ooooo00<0
003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0010oooo00?o09Wooooo
ool07?ooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001Ooooo00@0003oooooool00004
oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0067oool200001?ooo`Xco`2_
oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06oooo00<0003oooooool0;_oo
o`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo00Soool00`000?ooooooo`0U
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03Oooo`800004oooo0P0000Goool300000_ooo`800004oooo00<0003oooooool0MOoo
o`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`04oooo100000?oool010000?ooooooo`0000_oool010000?ooooooo`0000;oool01@000?oo
ooooooooo`00001goooo001Woooo2C?o00Coool00`000?ooooooo`02oooo00<0003oooooool04ooo
o`040000oooooooo00002?ooo`D000001Oooo`000?ooooooo`000004oooo00<0003oooooool0M?oo
o`00Ioooo`Tco`05oooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool200001?ooo`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooo
oooo000001Goool010000?ooooooo`0000Woool00`000?ooo`000002oooo00@0003oooooool00003
oooo00<0003oooooool0MOooo`00Ioooo`Tco`06oooo00<0003oooooool05oooo`80000;oooo0P00
00?oool200000oooo`030000oooooooo07Koool006Ooool9<ol0/?ooo`00Ioooo`Pco`2aoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.46) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.16408 .12361 L
.18221 .12361 L
.18703 .12361 L
.18957 .12361 L
.19227 .12361 L
.1934 .12361 L
.19462 .12361 L
s
.19462 .12361 m
.1949 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.46) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00D0003ooooo
oooooooo09T01?ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0
000co`0co`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0U
oooo00D0003ooooooooooooo09T09?ooo`030000<ol0<ol002Dco`000`0003?o03?o000T<ol04000
01Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00@_ooo`03o`2Ioooooooo02;oool0
0`0003?o03?o0017<ol01@0006[oool004;oool00ol0VOooooooo`0Roooo00<0000co`0co`00@S?o
00D0001_oooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol003dco`050000M?ooo`00@_oo
o`03o`2Ioooooooo02;oool00`0003?o03?o000i<ol0100007Woool004;oool00ol0VOooooooo`0R
oooo0P0003Pco`020000OOooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o000e<ol00P00
07ooool004;oool00ol0VOooooooo`0Roooo00<0000co`0co`00<c?o00800021oooo0012oooo00?o
09Woooooool08_ooo`030000<ol0<ol0034co`020000Poooo`00@_ooo`03o`2Ioooooooo02;oool0
0`0003?o03?o000`<ol000<0003oooooool0Poooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o
03?o000^<ol00P0008Koool004;oool00ol0VOooooooo`0Roooo0P0002dco`020000R?ooo`00@_oo
o`03o`2Ioooooooo02;oool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00@_ooo`03o`2I
oooooooo02;oool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`00@_ooo`03o`2Ioooooooo
02;oool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`00@_ooo`03o`2Ioooooooo02;oool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o
03?o000X<ol000<0003oooooool0Roooo`00@_ooo`03o`2Ioooooooo02;oool20000:3?o00030000
oooooooo08coool004;oool00ol0VOooooooo`0Roooo00<0000co`0co`009S?o00030000oooooooo
08goool004;oool00ol0VOooooooo`0Roooo00<0000co`0co`009C?o00030000oooooooo08koool0
04;oool00ol0VOooooooo`0Roooo00<0000co`0co`0093?o00030000oooooooo08ooool004;oool0
0ol0VOooooooo`0Roooo00<0000co`0co`008c?o00030000oooooooo093oool004;oool00ol0VOoo
ooooo`0Roooo00<0000co`0co`008c?o00030000oooooooo093oool004;oool00ol0VOooooooo`0R
oooo0P0002<co`000`000?ooooooo`2Aoooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol0
024co`000`000?ooooooo`2Boooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol0020co`000`000?oo
ooooo`2Coooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol001lco`000`000?ooooooo`2D
oooo0012oooo00?o09Woooooool06_ooo`D00003oooo00<0000co`0co`007c?o00030000oooooooo
09Coool004;oool00ol0VOooooooo`0Loooo00<0003oooooool00oooo`030000<ol0<ol001hco`00
0`000?ooooooo`2Eoooo0012oooo00?o09Woooooool07?ooo`030000oooooooo00?oool200007c?o
00030000oooooooo09Goool004;oool00ol0VOooooooo`0Loooo00<0003oooooool00oooo`030000
<ol0<ol001dco`000`000?ooooooo`2Foooo0012oooo00?o09Woooooool07?ooo`030000oooooooo
00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00@_ooo`03o`2Ioooooooo01_oool2
00001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo0012oooo00?o09Woooooool08_oo
o`030000<ol0<ol001`co`000`000?ooooooo`2Goooo0012oooo00?o09Woooooool08_ooo`030000
<ol0<ol001/co`000`000?ooooooo`2Hoooo0012oooo00?o09Woooooool08_ooo`80000L<ol000<0
003oooooool0V?ooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o000J<ol000<0003oooooool0VOoo
o`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00@_oo
o`03o`2Ioooooooo02;oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00@_ooo`03o`2I
oooooooo02;oool00`0003?o03?o000H<ol000<0003oooooool0Voooo`00@_ooo`03o`2Ioooooooo
02;oool200006C?o00030000oooooooo09_oool004;oool00ol0VOooooooo`0Roooo00<0000co`0c
o`005c?o00030000oooooooo09coool004;oool00ol0VOooooooo`0Roooo00<0000co`0co`005c?o
00030000oooooooo09coool004;oool00ol0VOooooooo`0Roooo00<0000co`0co`005S?o00030000
oooooooo09goool004;oool00ol0VOooooooo`0Roooo00<0000co`0co`005S?o00030000oooooooo
09goool004;oool00ol0VOooooooo`0Roooo00<0000co`0co`005S?o00030000oooooooo09goool0
04;oool00ol0VOooooooo`0Roooo00<0000co`0co`005C?o00030000oooooooo09koool004;oool0
0ol0VOooooooo`0Roooo0P0001Hco`000`000?ooooooo`2Noooo0012oooo00?o09Woooooool08_oo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo0012oooo00?o09Woooooool08_ooo`030000
<ol0<ol001Dco`000`000?ooooooo`2Noooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol001@co`000`000?oo
ooooo`2Ooooo0012oooo00?o09Woooooool08_ooo`80000E<ol000<0003oooooool0Woooo`00@_oo
o`03o`2Ioooooooo02;oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00@_ooo`03o`2I
oooooooo02;oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00@_ooo`03o`2Ioooooooo
02;oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00@_ooo`03o`2Ioooooooo01[oool4
00001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo0012oooo00?o09Woooooool06_oo
o`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00@_ooo`03o`2I
oooooooo01_oool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo0012oooo00?o
09Woooooool07?ooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003oooooool0XOoo
o`00@_ooo`03o`2Ioooooooo01[oool010000?ooooooo`0000Coool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00@_ooo`03o`2Ioooooooo01_oool200001Oooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol0014co`000`000?ooooooo`2R
oooo0012oooo00?o09Woooooool08_ooo`80000A<ol000<0003oooooool0Xoooo`00@_ooo`03o`2I
oooooooo02;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00@_ooo`03o`2Ioooooooo
02;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00@_ooo`03o`2Ioooooooo02;oool0
0`0003?o03?o000@<ol000<0003oooooool0Xoooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o000?<ol000<0
003oooooool0Y?ooo`00@_ooo`03o`2Ioooooooo02;oool2000043?o00030000oooooooo0:Coool0
04;oool00ol0VOooooooo`0Roooo00<0000co`0co`003S?o00030000oooooooo0:Goool004;oool0
0ol0VOooooooo`0Roooo00<0000co`0co`003S?o00030000oooooooo0:Goool004;oool00ol0VOoo
ooooo`0Roooo00<0000co`0co`003S?o00030000oooooooo0:Goool004;oool00ol0VOooooooo`0R
oooo00<0000co`0co`003S?o00030000oooooooo0:Goool004;oool00ol0VOooooooo`0Roooo00<0
000co`0co`003C?o00030000oooooooo0:Koool004;oool00ol0VOooooooo`0Roooo0P0000hco`00
0`000?ooooooo`2Voooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol000dco`000`000?ooooooo`2V
oooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo0012
oooo00?o09Woooooool08_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo0012oooo00?o
09Woooooool08_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo0012oooo00?o09Wooooo
ool08_ooo`80000=<ol000<0003oooooool0Yoooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o000<
<ol000<0003oooooool0Yoooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o000;<ol000<0
003oooooool0Z?ooo`00@_ooo`03o`2Ioooooooo01_oool200001Oooo`030000<ol0<ol000/co`00
0`000?ooooooo`2Xoooo0012oooo00?o09Woooooool06_ooo`040000oooooooo00001?ooo`030000
<ol0<ol000/co`000`000?ooooooo`2Xoooo0012oooo00?o09Woooooool07?ooo`030000oooooooo
00?oool2000033?o00030000oooooooo0:Soool004;oool00ol0VOooooooo`0Moooo00<0003ooooo
ool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo0012oooo00?o09Woooooool06_oo
o`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo0012oooo00?o
09Woooooool06oooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool004;oool0
0ol0VOooooooo`0Roooo00<0000co`0co`002S?o00030000oooooooo0:Woool004;oool00ol0VOoo
ooooo`0Roooo00<0000co`0co`002S?o00030000oooooooo0:Woool004;oool00ol0VOooooooo`0R
oooo00<0000co`0co`002S?o00030000oooooooo0:Woool004;oool00ol0VOooooooo`0Roooo0P00
00/co`000`000?ooooooo`2Yoooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol000Xco`00
0`000?ooooooo`2Yoooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo0012
oooo00?o09Woooooool08_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo0012oooo00?o
09Woooooool08_ooo`80000:<ol000<0003oooooool0Z_ooo`00@_ooo`03o`2Ioooooooo02;oool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o
03?o0009<ol000<0003oooooool0Z_ooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`00@_ooo`03o`2Ioooooooo02;oool00`0003?o03?o0008<ol000<0003ooooo
ool0Zoooo`00@_ooo`03o`2Ioooooooo02;oool200002C?o00030000oooooooo0:_oool004;oool0
0ol0VOooooooo`0Roooo00<0000co`0co`0023?o00030000oooooooo0:_oool004;oool00ol0VOoo
ooooo`0Roooo00<0000co`0co`0023?o00030000oooooooo0:_oool004;oool00ol0VOooooooo`0R
oooo00<0000co`0co`001c?o00030000oooooooo0:coool004;oool00ol0VOooooooo`0Roooo00<0
000co`0co`001c?o00030000oooooooo0:coool004;oool00ol0VOooooooo`0Roooo00<0000co`0c
o`001c?o00030000oooooooo0:coool004;oool00ol0VOooooooo`0Roooo0P0000Pco`000`000?oo
ooooo`2/oooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo0012oooo00?o09Woooooool08_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0012
oooo00?o09Woooooool08_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0012oooo00?o
09Woooooool08_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0012oooo00?o09Wooooo
ool07?ooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool004;oool00ol0VOoo
ooooo`0Moooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0012
oooo00?o09Woooooool06_ooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001Ooooo00@0
003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0067oool2
00001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06oooo00<0
003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo00Soool0
0`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003oooooool00_oo
o`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Goool3000000Coool0000000000004
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000_oool010000?oo
ooooo`0000;oool01@000?ooooooooooo`00001goooo001Woooo2C?o00Coool00`000?ooooooo`02
oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`D000001Oooo`000?ooooooo`000004
oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000Soool010000?ooooooo`0000;oool300001?ooo`030000oooooooo07Goool006Ooool9
<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooo`000003
oooo00<0003oooooool00oooo`030000oooooooo07Goool006Ooool9<ol01_ooo`030000oooooooo
01Ooool200002oooo`800003oooo0`0000;oool00`000?ooooooo`1foooo001Woooo2C?o0;3oool0
06Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.44) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.16408 .12361 L
.18221 .12361 L
.18703 .12361 L
.19227 .12361 L
.19467 .12361 L
.19721 .12361 L
.19939 .12361 L
.20062 .12361 L
s
.20062 .12361 m
.20109 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.44) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool00_ooo`05o`2Ioooooooooooo000000Ooool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0
000co`0co`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0U
oooo00<0003oooooool00_ooo`03o`2Ioooooooo027oool00`0003?o03?o000U<ol000<0000co`0c
o`0093?o0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool004?oool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`00Ac?o00D0001Zoooo0013oooo00?o09Woooooool08Oooo`030000
<ol0<ol0048co`050000Koooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000m<ol01@00
07Coool004?oool00ol0VOooooooo`0Qoooo00<0000co`0co`00>C?o00@0001ioooo0013oooo00?o
09Woooooool08Oooo`80000h<ol00P0007goool004?oool00ol0VOooooooo`0Qoooo00<0000co`0c
o`00=C?o0080001ooooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol003<co`020000POoo
o`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000a<ol00P0008?oool004?oool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`00<3?o00030000oooooooo08?oool004?oool00ol0VOooooooo`0Q
oooo00<0000co`0co`00;S?o00800026oooo0013oooo00?o09Woooooool08Oooo`80000]<ol00P00
08Soool004?oool00ol0VOooooooo`0Qoooo00<0000co`0co`00:c?o00030000oooooooo08Soool0
04?oool00ol0VOooooooo`0Qoooo00<0000co`0co`00:S?o00030000oooooooo08Woool004?oool0
0ol0VOooooooo`0Qoooo00<0000co`0co`00:C?o00030000oooooooo08[oool004?oool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`00:3?o00030000oooooooo08_oool004?oool00ol0VOooooooo`0Q
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool004?oool00ol0VOooooooo`0Qoooo0P00
02Pco`000`000?ooooooo`2<oooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol002Hco`00
0`000?ooooooo`2=oooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol002Dco`000`000?oo
ooooo`2>oooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol002@co`000`000?ooooooo`2?
oooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo0013
oooo00?o09Woooooool08Oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo0013oooo00?o
09Woooooool08Oooo`80000S<ol000<0003oooooool0TOooo`00@oooo`03o`2Ioooooooo027oool0
0`0003?o03?o000Q<ol000<0003oooooool0T_ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o
03?o000P<ol000<0003oooooool0Toooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000O<ol000<0
003oooooool0U?ooo`00@oooo`03o`2Ioooooooo01Woool500000oooo`030000<ol0<ol001lco`00
0`000?ooooooo`2Doooo0013oooo00?o09Woooooool06oooo`030000oooooooo00?oool00`0003?o
03?o000N<ol000<0003oooooool0UOooo`00@oooo`03o`2Ioooooooo01_oool00`000?ooooooo`03
oooo0P0001lco`000`000?ooooooo`2Eoooo0013oooo00?o09Woooooool06oooo`030000oooooooo
00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00@oooo`03o`2Ioooooooo01_oool0
0`000?ooooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool004?oool00ol0VOoo
ooooo`0Joooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00@oooo`03o`2I
oooooooo027oool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00@oooo`03o`2Ioooooooo
027oool00`0003?o03?o000K<ol000<0003oooooool0V?ooo`00@oooo`03o`2Ioooooooo027oool2
000073?o00030000oooooooo09Soool004?oool00ol0VOooooooo`0Qoooo00<0000co`0co`006S?o
00030000oooooooo09Woool004?oool00ol0VOooooooo`0Qoooo00<0000co`0co`006S?o00030000
oooooooo09Woool004?oool00ol0VOooooooo`0Qoooo00<0000co`0co`006C?o00030000oooooooo
09[oool004?oool00ol0VOooooooo`0Qoooo00<0000co`0co`006C?o00030000oooooooo09[oool0
04?oool00ol0VOooooooo`0Qoooo00<0000co`0co`0063?o00030000oooooooo09_oool004?oool0
0ol0VOooooooo`0Qoooo0P0001Tco`000`000?ooooooo`2Koooo0013oooo00?o09Woooooool08Ooo
o`030000<ol0<ol001Lco`000`000?ooooooo`2Loooo0013oooo00?o09Woooooool08Oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol0
01Hco`000`000?ooooooo`2Moooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol001Dco`000`000?ooooooo`2N
oooo0013oooo00?o09Woooooool08Oooo`80000F<ol000<0003oooooool0W_ooo`00@oooo`03o`2I
oooooooo027oool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00@oooo`03o`2Ioooooooo
027oool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00@oooo`03o`2Ioooooooo027oool0
0`0003?o03?o000D<ol000<0003oooooool0Woooo`00@oooo`03o`2Ioooooooo027oool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00@oooo`03o`2Ioooooooo027oool200005C?o00030000oooooooo
09ooool004?oool00ol0VOooooooo`0Qoooo00<0000co`0co`004c?o00030000oooooooo0:3oool0
04?oool00ol0VOooooooo`0Qoooo00<0000co`0co`004c?o00030000oooooooo0:3oool004?oool0
0ol0VOooooooo`0Qoooo00<0000co`0co`004c?o00030000oooooooo0:3oool004?oool00ol0VOoo
ooooo`0Ioooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00@oooo`03o`2I
oooooooo01Woool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool0
04?oool00ol0VOooooooo`0Joooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOoo
o`00@oooo`03o`2Ioooooooo01_oool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000
oooooooo0:7oool004?oool00ol0VOooooooo`0Ioooo00@0003oooooool00004oooo00<0000co`0c
o`004C?o00030000oooooooo0:;oool004?oool00ol0VOooooooo`0Joooo0P0000Goool00`0003?o
03?o000A<ol000<0003oooooool0X_ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00@oooo`03o`2Ioooooooo027oool200004C?o00030000oooooooo0:?oool0
04?oool00ol0VOooooooo`0Qoooo00<0000co`0co`0043?o00030000oooooooo0:?oool004?oool0
0ol0VOooooooo`0Qoooo00<0000co`0co`0043?o00030000oooooooo0:?oool004?oool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`0043?o00030000oooooooo0:?oool004?oool00ol0VOooooooo`0Q
oooo00<0000co`0co`003c?o00030000oooooooo0:Coool004?oool00ol0VOooooooo`0Qoooo00<0
000co`0co`003c?o00030000oooooooo0:Coool004?oool00ol0VOooooooo`0Qoooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool004?oool00ol0VOooooooo`0Qoooo0P00010co`000`000?oo
ooooo`2Toooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol000hco`000`000?ooooooo`2U
oooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0013
oooo00?o09Woooooool08Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0013oooo00?o
09Woooooool08Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0013oooo00?o09Wooooo
ool08Oooo`030000<ol0<ol000dco`000`000?ooooooo`2Voooo0013oooo00?o09Woooooool08Ooo
o`80000><ol000<0003oooooool0Y_ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000=
<ol000<0003oooooool0Y_ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000<<ol000<0003ooooo
ool0Yoooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00@ooo
o`03o`2Ioooooooo027oool200003C?o00030000oooooooo0:Ooool004?oool00ol0VOooooooo`0Q
oooo00<0000co`0co`0033?o00030000oooooooo0:Ooool004?oool00ol0VOooooooo`0Qoooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool004?oool00ol0VOooooooo`0Qoooo00<0000co`0c
o`002c?o00030000oooooooo0:Soool004?oool00ol0VOooooooo`0Joooo0P0000Goool00`0003?o
03?o000;<ol000<0003oooooool0Z?ooo`00@oooo`03o`2Ioooooooo01Woool010000?ooooooo`00
00Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00@oooo`03o`2Ioooooooo01_oool0
0`000?ooooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo0013oooo00?o09Woooooool07?oo
o`030000oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00@oooo`03o`2I
oooooooo01Woool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?oo
o`00@oooo`03o`2Ioooooooo01[oool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Y
oooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0013
oooo00?o09Woooooool08Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0013oooo00?o
09Woooooool08Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0013oooo00?o09Wooooo
ool08Oooo`80000;<ol000<0003oooooool0ZOooo`00@oooo`03o`2Ioooooooo027oool00`0003?o
03?o000:<ol000<0003oooooool0ZOooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o0009
<ol000<0003oooooool0Z_ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00@oooo`03o`2Ioooooooo027oool200002S?o00030000oooooooo0:[oool004?oool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`002C?o00030000oooooooo0:[oool004?oool00ol0VOooooooo`0Q
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool004?oool00ol0VOooooooo`0Qoooo00<0
000co`0co`0023?o00030000oooooooo0:_oool004?oool00ol0VOooooooo`0Qoooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool004?oool00ol0VOooooooo`0Qoooo00<0000co`0co`0023?o
00030000oooooooo0:_oool004?oool00ol0VOooooooo`0Qoooo0P0000Tco`000`000?ooooooo`2[
oooo0013oooo00?o09Woooooool08Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo0013
oooo00?o09Woooooool08Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo0013oooo00?o
09Woooooool08Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0013oooo00?o09Wooooo
ool08Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0013oooo00?o09Woooooool08Ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0013oooo00?o09Woooooool08Oooo`800008
<ol000<0003oooooool0[?ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o0007<ol000<0
003oooooool0[?ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00@oooo`03o`2Ioooooooo027oool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00@ooo
o`03o`2Ioooooooo01_oool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0013
oooo00?o09Woooooool07?ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00@oooo`03o`2Ioooooooo01Woool500000oooo`800008<ol000<0003oooooool0[?oo
o`00Goooo`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_
oooo001Qoooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9
<ol01_ooo`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?oo
ooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005oooo0`0000?oool3
00000_ooo`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool0000;oooo00<0
003oooooool00oooo`050000oooooooooooo000007Ooool006Ooool9<ol01?ooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool00008oooo1@000003oooo0000000000<00003
oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000Soool010000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1e
oooo001Woooo2C?o00Goool01@000?ooooooooooo`00000Eoooo00@0003oooooool00009oooo00<0
003oool000000oooo`030000oooo000000?oool00`000?ooooooo`1eoooo001Woooo2C?o00Koool0
0`000?ooooooo`0Goooo0P0000_oool200001?ooo`800002oooo00<0003oooooool0M_ooo`00Iooo
o`Tco`2`oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.42) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.19227 .12361 L
.20178 .12361 L
.20433 .12361 L
.20573 .12361 L
.20704 .12361 L
.20772 .12361 L
s
.20772 .12361 m
.20801 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.42) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01?ooo`03o`2Ioooo000000Ooool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool01?ooo`03o`2Ioooooooo01ooool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool004Goool00ol0VOooooooo`0O
oooo00<0000co`0co`00Ac?o00D0001Zoooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol0
048co`050000Koooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000m<ol01@0007Coool0
04Goool00ol0VOooooooo`0Ooooo00<0000co`0co`00>C?o00@0001ioooo0015oooo00?o09Wooooo
ool07oooo`80000h<ol00P0007goool004Goool00ol0VOooooooo`0Ooooo00<0000co`0co`00=C?o
0080001ooooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol003<co`020000POooo`00AOoo
o`03o`2Ioooooooo01ooool00`0003?o03?o000a<ol00P0008?oool004Goool00ol0VOooooooo`0O
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool004Goool00ol0VOooooooo`0Ooooo00<0
000co`0co`00;S?o00800026oooo0015oooo00?o09Woooooool07oooo`80000]<ol00P0008Soool0
04Goool00ol0VOooooooo`0Ooooo00<0000co`0co`00:c?o00030000oooooooo08Soool004Goool0
0ol0VOooooooo`0Ooooo00<0000co`0co`00:S?o00030000oooooooo08Woool004Goool00ol0VOoo
ooooo`0Ooooo00<0000co`0co`00:C?o00030000oooooooo08[oool004Goool00ol0VOooooooo`0O
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool004Goool00ol0VOooooooo`0Ooooo00<0
000co`0co`00:3?o00030000oooooooo08_oool004Goool00ol0VOooooooo`0Ooooo0P0002Pco`00
0`000?ooooooo`2<oooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo0015
oooo00?o09Woooooool07oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo0015oooo00?o
09Woooooool07oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo0015oooo00?o09Wooooo
ool07oooo`80000S<ol000<0003oooooool0TOooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00AOooo`03o`2Ioooooooo01Ooool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo0015oooo00?o09Woooooool06Oooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00AOooo`03o`2Ioooooooo01Woool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo0015oooo00?o09Woooooool06Oooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00AOooo`03o`2Ioooooooo01Woool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool004Goool00ol0VOooooooo`0H
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00AOooo`03o`2Ioooooooo
01ooool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00AOooo`03o`2Ioooooooo01ooool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00AOooo`03o`2Ioooooooo01ooool2000073?o
00030000oooooooo09Soool004Goool00ol0VOooooooo`0Ooooo00<0000co`0co`006S?o00030000
oooooooo09Woool004Goool00ol0VOooooooo`0Ooooo00<0000co`0co`006S?o00030000oooooooo
09Woool004Goool00ol0VOooooooo`0Ooooo00<0000co`0co`006C?o00030000oooooooo09[oool0
04Goool00ol0VOooooooo`0Ooooo00<0000co`0co`006C?o00030000oooooooo09[oool004Goool0
0ol0VOooooooo`0Ooooo00<0000co`0co`0063?o00030000oooooooo09_oool004Goool00ol0VOoo
ooooo`0Ooooo0P0001Tco`000`000?ooooooo`2Koooo0015oooo00?o09Woooooool07oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo0015
oooo00?o09Woooooool07oooo`80000F<ol000<0003oooooool0W_ooo`00AOooo`03o`2Ioooooooo
01ooool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00AOooo`03o`2Ioooooooo01ooool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00AOooo`03o`2Ioooooooo01ooool200005C?o00030000oooooooo09ooool0
04Goool00ol0VOooooooo`0Ooooo00<0000co`0co`004c?o00030000oooooooo0:3oool004Goool0
0ol0VOooooooo`0Ooooo00<0000co`0co`004c?o00030000oooooooo0:3oool004Goool00ol0VOoo
ooooo`0Ooooo00<0000co`0co`004c?o00030000oooooooo0:3oool004Goool00ol0VOooooooo`0G
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00AOooo`03o`2Ioooooooo
01Ooool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool004Goool0
0ol0VOooooooo`0Hoooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00AOoo
o`03o`2Ioooooooo01Woool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool004Goool00ol0VOooooooo`0Goooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool004Goool00ol0VOooooooo`0Hoooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00AOooo`03o`2Ioooooooo01ooool200004C?o00030000oooooooo0:?oool004Goool0
0ol0VOooooooo`0Ooooo00<0000co`0co`0043?o00030000oooooooo0:?oool004Goool00ol0VOoo
ooooo`0Ooooo00<0000co`0co`0043?o00030000oooooooo0:?oool004Goool00ol0VOooooooo`0O
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool004Goool00ol0VOooooooo`0Ooooo00<0
000co`0co`003c?o00030000oooooooo0:Coool004Goool00ol0VOooooooo`0Ooooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool004Goool00ol0VOooooooo`0Ooooo00<0000co`0co`003c?o
00030000oooooooo0:Coool004Goool00ol0VOooooooo`0Ooooo0P00010co`000`000?ooooooo`2T
oooo0015oooo00?o09Woooooool07oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0015
oooo00?o09Woooooool07oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0015oooo00?o
09Woooooool07oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0015oooo00?o09Wooooo
ool07oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0015oooo00?o09Woooooool07ooo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo0015oooo00?o09Woooooool07oooo`80000>
<ol000<0003oooooool0Y_ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00AOoo
o`03o`2Ioooooooo01ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00AOooo`03o`2I
oooooooo01ooool200003C?o00030000oooooooo0:Ooool004Goool00ol0VOooooooo`0Ooooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool004Goool00ol0VOooooooo`0Ooooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool004Goool00ol0VOooooooo`0Ooooo00<0000co`0co`002c?o
00030000oooooooo0:Soool004Goool00ol0VOooooooo`0Hoooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00AOooo`03o`2Ioooooooo01Ooool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00AOooo`03o`2Ioooooooo01Woool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo0015oooo00?o09Woooooool06_ooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00AOooo`03o`2Ioooooooo
01Ooool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00AOoo
o`03o`2Ioooooooo01Soool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0015
oooo00?o09Woooooool07oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0015oooo00?o
09Woooooool07oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0015oooo00?o09Wooooo
ool07oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0015oooo00?o09Woooooool07ooo
o`80000;<ol000<0003oooooool0ZOooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00AOoo
o`03o`2Ioooooooo01ooool200002S?o00030000oooooooo0:[oool004Goool00ol0VOooooooo`0O
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool004Goool00ol0VOooooooo`0Ooooo00<0
000co`0co`002C?o00030000oooooooo0:[oool004Goool00ol0VOooooooo`0Ooooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool004Goool00ol0VOooooooo`0Ooooo00<0000co`0co`0023?o
00030000oooooooo0:_oool004Goool00ol0VOooooooo`0Ooooo00<0000co`0co`0023?o00030000
oooooooo0:_oool004Goool00ol0VOooooooo`0Ooooo0P0000Tco`000`000?ooooooo`2[oooo0015
oooo00?o09Woooooool07oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo0015oooo00?o
09Woooooool07oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo0015oooo00?o09Wooooo
ool07oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0015oooo00?o09Woooooool07ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0015oooo00?o09Woooooool07oooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo0015oooo00?o09Woooooool07oooo`800008<ol000<0
003oooooool0[?ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00AOooo`03o`2Ioooooooo01ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00AOoo
o`03o`2Ioooooooo01ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00AOooo`03o`2I
oooooooo01Woool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0015oooo00?o
09Woooooool06_ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00AOooo`03o`2Ioooooooo01Ooool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005oooo0`000003oooo00000000
00800003oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000_oool0
10000?ooooooo`0000Koool00`000?ooooooo`1eoooo001Woooo2C?o00Coool00`000?ooooooo`02
oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`D00002oooo00<0003oooooool01?oo
o`030000oooooooo07Coool006Ooool9<ol01Oooo`030000oooooooo00D0000Boooo00@0003ooooo
ool00008oooo00@0003oooooool00004oooo00<0003oooooool00_ooo`030000oooooooo07Goool0
06Ooool9<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?oo
o`000002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00Ioooo`Tco`06oooo00<0
003oooooool05oooo`80000;oooo0P0000?oool200000oooo`030000oooooooo07Koool006Ooool9
<ol0/?ooo`00Ioooo`Pco`2aoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20178 .12361 L
.20742 .12361 L
.21019 .12361 L
.2114 .12361 L
.21274 .12361 L
.21394 .12361 L
s
.21394 .12361 m
.21439 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`03o`2I0000oooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool01Oooo`03o`2Ioooooooo01koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool004Koool00ol0VOooooooo`0N
oooo00<0000co`0co`00Ac?o00D0001Zoooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol0
048co`050000Koooo`00A_ooo`03o`2Ioooooooo01koool00`0003?o03?o000m<ol01@0007Coool0
04Koool00ol0VOooooooo`0Noooo00<0000co`0co`00>C?o00@0001ioooo0016oooo00?o09Wooooo
ool07_ooo`80000h<ol00P0007goool004Koool00ol0VOooooooo`0Noooo00<0000co`0co`00=C?o
0080001ooooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol003<co`020000POooo`00A_oo
o`03o`2Ioooooooo01koool00`0003?o03?o000a<ol00P0008?oool004Koool00ol0VOooooooo`0N
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool004Koool00ol0VOooooooo`0Noooo00<0
000co`0co`00;S?o00800026oooo0016oooo00?o09Woooooool07_ooo`80000]<ol00P0008Soool0
04Koool00ol0VOooooooo`0Noooo00<0000co`0co`00:c?o00030000oooooooo08Soool004Koool0
0ol0VOooooooo`0Noooo00<0000co`0co`00:S?o00030000oooooooo08Woool004Koool00ol0VOoo
ooooo`0Noooo00<0000co`0co`00:C?o00030000oooooooo08[oool004Koool00ol0VOooooooo`0N
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool004Koool00ol0VOooooooo`0Noooo00<0
000co`0co`00:3?o00030000oooooooo08_oool004Koool00ol0VOooooooo`0Noooo0P0002Pco`00
0`000?ooooooo`2<oooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo0016
oooo00?o09Woooooool07_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo0016oooo00?o
09Woooooool07_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo0016oooo00?o09Wooooo
ool07_ooo`80000S<ol000<0003oooooool0TOooo`00A_ooo`03o`2Ioooooooo01koool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00A_ooo`03o`2Ioooooooo01koool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00A_ooo`03o`2Ioooooooo01koool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00A_ooo`03o`2Ioooooooo01koool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00A_ooo`03o`2Ioooooooo01Koool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo0016oooo00?o09Woooooool06?ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00A_ooo`03o`2Ioooooooo01Soool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo0016oooo00?o09Woooooool06?ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00A_ooo`03o`2Ioooooooo01Soool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool004Koool00ol0VOooooooo`0G
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00A_ooo`03o`2Ioooooooo
01koool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00A_ooo`03o`2Ioooooooo01koool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00A_ooo`03o`2Ioooooooo01koool2000073?o
00030000oooooooo09Soool004Koool00ol0VOooooooo`0Noooo00<0000co`0co`006S?o00030000
oooooooo09Woool004Koool00ol0VOooooooo`0Noooo00<0000co`0co`006S?o00030000oooooooo
09Woool004Koool00ol0VOooooooo`0Noooo00<0000co`0co`006C?o00030000oooooooo09[oool0
04Koool00ol0VOooooooo`0Noooo00<0000co`0co`006C?o00030000oooooooo09[oool004Koool0
0ol0VOooooooo`0Noooo00<0000co`0co`0063?o00030000oooooooo09_oool004Koool00ol0VOoo
ooooo`0Noooo0P0001Tco`000`000?ooooooo`2Koooo0016oooo00?o09Woooooool07_ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo0016oooo00?o09Woooooool07_ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo0016
oooo00?o09Woooooool07_ooo`80000F<ol000<0003oooooool0W_ooo`00A_ooo`03o`2Ioooooooo
01koool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00A_ooo`03o`2Ioooooooo01koool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00A_ooo`03o`2Ioooooooo01koool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00A_ooo`03o`2Ioooooooo01koool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00A_ooo`03o`2Ioooooooo01koool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00A_ooo`03o`2Ioooooooo01koool200005C?o00030000oooooooo09ooool0
04Koool00ol0VOooooooo`0Noooo00<0000co`0co`004c?o00030000oooooooo0:3oool004Koool0
0ol0VOooooooo`0Noooo00<0000co`0co`004c?o00030000oooooooo0:3oool004Koool00ol0VOoo
ooooo`0Noooo00<0000co`0co`004c?o00030000oooooooo0:3oool004Koool00ol0VOooooooo`0F
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00A_ooo`03o`2Ioooooooo
01Koool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool004Koool0
0ol0VOooooooo`0Goooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00Aooo
o`03o`2Ioooooooo01Ooool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool004Ooool00ol0VOooooooo`0Eoooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool004Ooool00ol0VOooooooo`0Foooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00Aoooo`03o`2Ioooooooo01goool200004C?o00030000oooooooo0:?oool004Ooool0
0ol0VOooooooo`0Moooo00<0000co`0co`0043?o00030000oooooooo0:?oool004Ooool00ol0VOoo
ooooo`0Moooo00<0000co`0co`0043?o00030000oooooooo0:?oool004Ooool00ol0VOooooooo`0M
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool004Ooool00ol0VOooooooo`0Moooo00<0
000co`0co`003c?o00030000oooooooo0:Coool004Ooool00ol0VOooooooo`0Moooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool004Ooool00ol0VOooooooo`0Moooo00<0000co`0co`003c?o
00030000oooooooo0:Coool004Ooool00ol0VOooooooo`0Moooo0P00010co`000`000?ooooooo`2T
oooo0017oooo00?o09Woooooool07Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0017
oooo00?o09Woooooool07Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0017oooo00?o
09Woooooool07Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0017oooo00?o09Wooooo
ool07Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0017oooo00?o09Woooooool07Ooo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo0017oooo00?o09Woooooool07Oooo`80000>
<ol000<0003oooooool0Y_ooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00Aooo
o`03o`2Ioooooooo01goool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00Aoooo`03o`2I
oooooooo01goool200003C?o00030000oooooooo0:Ooool004Ooool00ol0VOooooooo`0Moooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool004Ooool00ol0VOooooooo`0Moooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool004Ooool00ol0VOooooooo`0Moooo00<0000co`0co`002c?o
00030000oooooooo0:Soool004Ooool00ol0VOooooooo`0Foooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00Aoooo`03o`2Ioooooooo01Goool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Aoooo`03o`2Ioooooooo01Ooool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo0017oooo00?o09Woooooool06?ooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Aoooo`03o`2Ioooooooo
01Goool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Aooo
o`03o`2Ioooooooo01Koool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0017
oooo00?o09Woooooool07Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0017oooo00?o
09Woooooool07Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0017oooo00?o09Wooooo
ool07Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0017oooo00?o09Woooooool07Ooo
o`80000;<ol000<0003oooooool0ZOooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00Aooo
o`03o`2Ioooooooo01goool200002S?o00030000oooooooo0:[oool004Ooool00ol0VOooooooo`0M
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool004Ooool00ol0VOooooooo`0Moooo00<0
000co`0co`002C?o00030000oooooooo0:[oool004Ooool00ol0VOooooooo`0Moooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool004Ooool00ol0VOooooooo`0Moooo00<0000co`0co`0023?o
00030000oooooooo0:_oool004Ooool00ol0VOooooooo`0Moooo00<0000co`0co`0023?o00030000
oooooooo0:_oool004Ooool00ol0VOooooooo`0Moooo0P0000Tco`000`000?ooooooo`2[oooo0017
oooo00?o09Woooooool07Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo0017oooo00?o
09Woooooool07Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo0017oooo00?o09Wooooo
ool07Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0017oooo00?o09Woooooool07Ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0017oooo00?o09Woooooool07Oooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo0017oooo00?o09Woooooool07Oooo`800008<ol000<0
003oooooool0[?ooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00Aoooo`03o`2Ioooooooo01goool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00Aooo
o`03o`2Ioooooooo01goool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00Aoooo`03o`2I
oooooooo01Ooool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0017oooo00?o
09Woooooool06?ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00Aoooo`03o`2Ioooooooo01Goool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol02Ooo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001Woooo2C?o00Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool006Ooool9<ol02?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005oooo0`0000;oool00`000?oo
ooooo`1hoooo001Woooo2C?o00Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002oooo`050000oooooooooooo0000
07[oool006Ooool9<ol01oooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0003ooooo
ool00008oooo1@0000?oool00`000?ooooooo`1goooo001Woooo2C?o00Soool00`000?ooooooo`05
00004_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool0
06Ooool9<ol02?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?oo
o`000003oooo00<0003oooooool0N?ooo`00Ioooo`Tco`09oooo00<0003oooooool05oooo`80000;
oooo0P0000;oool00`000?ooooooo`1ioooo001Woooo2C?o0;3oool006Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.38) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20178 .12361 L
.20742 .12361 L
.21274 .12361 L
.21753 .12361 L
.21884 .12361 L
.21955 .12361 L
.22022 .12361 L
s
.22022 .12361 m
.2207 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.38) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000o`2Ioooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool01oooo`03o`2Ioooooooo01coool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool004Soool00ol0VOooooooo`0L
oooo00<0000co`0co`00Ac?o00D0001Zoooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol0
048co`050000Koooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000m<ol01@0007Coool0
04Soool00ol0VOooooooo`0Loooo00<0000co`0co`00>C?o00@0001ioooo0018oooo00?o09Wooooo
ool07?ooo`80000h<ol00P0007goool004Soool00ol0VOooooooo`0Loooo00<0000co`0co`00=C?o
0080001ooooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol003<co`020000POooo`00B?oo
o`03o`2Ioooooooo01coool00`0003?o03?o000a<ol00P0008?oool004Soool00ol0VOooooooo`0L
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool004Soool00ol0VOooooooo`0Loooo00<0
000co`0co`00;S?o00800026oooo0018oooo00?o09Woooooool07?ooo`80000]<ol00P0008Soool0
04Soool00ol0VOooooooo`0Loooo00<0000co`0co`00:c?o00030000oooooooo08Soool004Soool0
0ol0VOooooooo`0Loooo00<0000co`0co`00:S?o00030000oooooooo08Woool004Soool00ol0VOoo
ooooo`0Loooo00<0000co`0co`00:C?o00030000oooooooo08[oool004Soool00ol0VOooooooo`0L
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool004Soool00ol0VOooooooo`0Loooo00<0
000co`0co`00:3?o00030000oooooooo08_oool004Soool00ol0VOooooooo`0Loooo0P0002Pco`00
0`000?ooooooo`2<oooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo0018
oooo00?o09Woooooool07?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo0018oooo00?o
09Woooooool07?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo0018oooo00?o09Wooooo
ool07?ooo`80000S<ol000<0003oooooool0TOooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00B?ooo`03o`2Ioooooooo01Coool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo0018oooo00?o09Woooooool05_ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00B?ooo`03o`2Ioooooooo01Koool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo0018oooo00?o09Woooooool05_ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00B?ooo`03o`2Ioooooooo01Koool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool004Soool00ol0VOooooooo`0E
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00B?ooo`03o`2Ioooooooo
01coool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00B?ooo`03o`2Ioooooooo01coool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00B?ooo`03o`2Ioooooooo01coool2000073?o
00030000oooooooo09Soool004Soool00ol0VOooooooo`0Loooo00<0000co`0co`006S?o00030000
oooooooo09Woool004Soool00ol0VOooooooo`0Loooo00<0000co`0co`006S?o00030000oooooooo
09Woool004Soool00ol0VOooooooo`0Loooo00<0000co`0co`006C?o00030000oooooooo09[oool0
04Soool00ol0VOooooooo`0Loooo00<0000co`0co`006C?o00030000oooooooo09[oool004Soool0
0ol0VOooooooo`0Loooo00<0000co`0co`0063?o00030000oooooooo09_oool004Soool00ol0VOoo
ooooo`0Loooo0P0001Tco`000`000?ooooooo`2Koooo0018oooo00?o09Woooooool07?ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo0018
oooo00?o09Woooooool07?ooo`80000F<ol000<0003oooooool0W_ooo`00B?ooo`03o`2Ioooooooo
01coool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00B?ooo`03o`2Ioooooooo01coool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00B?ooo`03o`2Ioooooooo01coool200005C?o00030000oooooooo09ooool0
04Soool00ol0VOooooooo`0Loooo00<0000co`0co`004c?o00030000oooooooo0:3oool004Soool0
0ol0VOooooooo`0Loooo00<0000co`0co`004c?o00030000oooooooo0:3oool004Soool00ol0VOoo
ooooo`0Loooo00<0000co`0co`004c?o00030000oooooooo0:3oool004Soool00ol0VOooooooo`0D
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00B?ooo`03o`2Ioooooooo
01Coool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool004Soool0
0ol0VOooooooo`0Eoooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00B?oo
o`03o`2Ioooooooo01Koool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool004Soool00ol0VOooooooo`0Doooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool004Soool00ol0VOooooooo`0Eoooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00B?ooo`03o`2Ioooooooo01coool200004C?o00030000oooooooo0:?oool004Soool0
0ol0VOooooooo`0Loooo00<0000co`0co`0043?o00030000oooooooo0:?oool004Soool00ol0VOoo
ooooo`0Loooo00<0000co`0co`0043?o00030000oooooooo0:?oool004Soool00ol0VOooooooo`0L
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool004Soool00ol0VOooooooo`0Loooo00<0
000co`0co`003c?o00030000oooooooo0:Coool004Soool00ol0VOooooooo`0Loooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool004Soool00ol0VOooooooo`0Loooo00<0000co`0co`003c?o
00030000oooooooo0:Coool004Soool00ol0VOooooooo`0Loooo0P00010co`000`000?ooooooo`2T
oooo0018oooo00?o09Woooooool07?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0018
oooo00?o09Woooooool07?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0018oooo00?o
09Woooooool07?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0018oooo00?o09Wooooo
ool07?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo0018oooo00?o09Woooooool07?oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo0018oooo00?o09Woooooool07?ooo`80000>
<ol000<0003oooooool0Y_ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00B?oo
o`03o`2Ioooooooo01coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00B?ooo`03o`2I
oooooooo01coool200003C?o00030000oooooooo0:Ooool004Soool00ol0VOooooooo`0Loooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool004Soool00ol0VOooooooo`0Loooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool004Soool00ol0VOooooooo`0Loooo00<0000co`0co`002c?o
00030000oooooooo0:Soool004Soool00ol0VOooooooo`0Eoooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00B?ooo`03o`2Ioooooooo01Coool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00B?ooo`03o`2Ioooooooo01Koool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo0018oooo00?o09Woooooool05oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00B?ooo`03o`2Ioooooooo
01Coool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00B?oo
o`03o`2Ioooooooo01Goool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0018
oooo00?o09Woooooool07?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0018oooo00?o
09Woooooool07?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0018oooo00?o09Wooooo
ool07?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo0018oooo00?o09Woooooool07?oo
o`80000;<ol000<0003oooooool0ZOooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00B?oo
o`03o`2Ioooooooo01coool200002S?o00030000oooooooo0:[oool004Soool00ol0VOooooooo`0L
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool004Soool00ol0VOooooooo`0Loooo00<0
000co`0co`002C?o00030000oooooooo0:[oool004Soool00ol0VOooooooo`0Loooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool004Soool00ol0VOooooooo`0Loooo00<0000co`0co`0023?o
00030000oooooooo0:_oool004Soool00ol0VOooooooo`0Loooo00<0000co`0co`0023?o00030000
oooooooo0:_oool004Soool00ol0VOooooooo`0Loooo0P0000Tco`000`000?ooooooo`2[oooo0018
oooo00?o09Woooooool07?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo0018oooo00?o
09Woooooool07?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo0018oooo00?o09Wooooo
ool07?ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0018oooo00?o09Woooooool07?oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0018oooo00?o09Woooooool07?ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo0018oooo00?o09Woooooool07?ooo`800008<ol000<0
003oooooool0[?ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00B?ooo`03o`2Ioooooooo01coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00B?oo
o`03o`2Ioooooooo01coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00B?ooo`03o`2I
oooooooo01Koool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo0018oooo00?o
09Woooooool05oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00B?ooo`03o`2Ioooooooo01Coool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000Coool200001?oo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00Ioooo`Tco`04oooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo07Coool006Ooool9<ol01Oooo`030000
oooooooo00D0000Boooo00@0003oooooool0000;oooo00@0003oooooooooool200001?ooo`030000
oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Soool010000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001W
oooo2C?o00Koool00`000?ooooooo`0Goooo0P0000[oool200001?ooo`800003oooo00<0003ooooo
ool0M_ooo`00Ioooo`Tco`2`oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.36) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.21345 .12361 L
.21786 .12361 L
.22037 .12361 L
.22272 .12361 L
.22496 .12361 L
.22623 .12361 L
s
.22623 .12361 m
.22669 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.36) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`040000ooooooooo`2I1?ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Goool0
0`000?ooooooo`09oooo00?o09Woooooool06_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T
<ol0400001Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00B_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o0017<ol01@0006[oool004[oool00ol0VOooooooo`0Joooo00<0000co`0c
o`00@S?o00D0001_oooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol003dco`050000M?oo
o`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000i<ol0100007Woool004[oool00ol0VOoo
ooooo`0Joooo0P0003Pco`020000OOooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000e
<ol00P0007ooool004[oool00ol0VOooooooo`0Joooo00<0000co`0co`00<c?o00800021oooo001:
oooo00?o09Woooooool06_ooo`030000<ol0<ol0034co`020000Poooo`00B_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o000`<ol000<0003oooooool0Poooo`00B_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o000^<ol00P0008Koool004[oool00ol0VOooooooo`0Joooo0P0002dco`020000R?oo
o`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00B_oo
o`03o`2Ioooooooo01[oool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`00B_ooo`03o`2I
oooooooo01[oool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`00B_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o000X<ol000<0003oooooool0Roooo`00B_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`00B_ooo`03o`2Ioooooooo01[oool20000:3?o
00030000oooooooo08coool004[oool00ol0VOooooooo`0Joooo00<0000co`0co`009S?o00030000
oooooooo08goool004[oool00ol0VOooooooo`0Joooo00<0000co`0co`009C?o00030000oooooooo
08koool004[oool00ol0VOooooooo`0Joooo00<0000co`0co`0093?o00030000oooooooo08ooool0
04[oool00ol0VOooooooo`0Joooo00<0000co`0co`008c?o00030000oooooooo093oool004[oool0
0ol0VOooooooo`0Joooo00<0000co`0co`008c?o00030000oooooooo093oool004[oool00ol0VOoo
ooooo`0Joooo0P0002<co`000`000?ooooooo`2Aoooo001:oooo00?o09Woooooool06_ooo`030000
<ol0<ol0024co`000`000?ooooooo`2Boooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol0
020co`000`000?ooooooo`2Coooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo001:oooo00?o09Woooooool04_ooo`D00003oooo00<0000co`0co`007c?o00030000
oooooooo09Coool004[oool00ol0VOooooooo`0Doooo00<0003oooooool00oooo`030000<ol0<ol0
01hco`000`000?ooooooo`2Eoooo001:oooo00?o09Woooooool05?ooo`030000oooooooo00?oool2
00007c?o00030000oooooooo09Goool004[oool00ol0VOooooooo`0Doooo00<0003oooooool00ooo
o`030000<ol0<ol001dco`000`000?ooooooo`2Foooo001:oooo00?o09Woooooool05?ooo`030000
oooooooo00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00B_ooo`03o`2Ioooooooo
01?oool200001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo001:oooo00?o09Wooooo
ool06_ooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo001:oooo00?o09Woooooool06_oo
o`030000<ol0<ol001/co`000`000?ooooooo`2Hoooo001:oooo00?o09Woooooool06_ooo`80000L
<ol000<0003oooooool0V?ooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000J<ol000<0
003oooooool0VOooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000I<ol000<0003oooooool0V_oo
o`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00B_oo
o`03o`2Ioooooooo01[oool00`0003?o03?o000H<ol000<0003oooooool0Voooo`00B_ooo`03o`2I
oooooooo01[oool200006C?o00030000oooooooo09_oool004[oool00ol0VOooooooo`0Joooo00<0
000co`0co`005c?o00030000oooooooo09coool004[oool00ol0VOooooooo`0Joooo00<0000co`0c
o`005c?o00030000oooooooo09coool004[oool00ol0VOooooooo`0Joooo00<0000co`0co`005S?o
00030000oooooooo09goool004[oool00ol0VOooooooo`0Joooo00<0000co`0co`005S?o00030000
oooooooo09goool004[oool00ol0VOooooooo`0Joooo00<0000co`0co`005S?o00030000oooooooo
09goool004[oool00ol0VOooooooo`0Joooo00<0000co`0co`005C?o00030000oooooooo09koool0
04[oool00ol0VOooooooo`0Joooo0P0001Hco`000`000?ooooooo`2Noooo001:oooo00?o09Wooooo
ool06_ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001:oooo00?o09Woooooool06_oo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001:oooo00?o09Woooooool06_ooo`030000
<ol0<ol001@co`000`000?ooooooo`2Ooooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo001:oooo00?o09Woooooool06_ooo`80000E<ol000<0003oooooool0Wooo
o`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00B_oo
o`03o`2Ioooooooo01[oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00B_ooo`03o`2I
oooooooo01[oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00B_ooo`03o`2Ioooooooo
01;oool400001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo001:oooo00?o09Wooooo
ool04_ooo`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00B_oo
o`03o`2Ioooooooo01?oool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo001:
oooo00?o09Woooooool05?ooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003ooooo
ool0XOooo`00B_ooo`03o`2Ioooooooo01;oool010000?ooooooo`0000Coool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00B_ooo`03o`2Ioooooooo01?oool200001Oooo`030000<ol0<ol0
014co`000`000?ooooooo`2Roooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo001:oooo00?o09Woooooool06_ooo`80000A<ol000<0003oooooool0Xoooo`00B_oo
o`03o`2Ioooooooo01[oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00B_ooo`03o`2I
oooooooo01[oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00B_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00B_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o000?<ol000<0003oooooool0Y?ooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`00B_ooo`03o`2Ioooooooo01[oool2000043?o00030000oooooooo
0:Coool004[oool00ol0VOooooooo`0Joooo00<0000co`0co`003S?o00030000oooooooo0:Goool0
04[oool00ol0VOooooooo`0Joooo00<0000co`0co`003S?o00030000oooooooo0:Goool004[oool0
0ol0VOooooooo`0Joooo00<0000co`0co`003S?o00030000oooooooo0:Goool004[oool00ol0VOoo
ooooo`0Joooo00<0000co`0co`003S?o00030000oooooooo0:Goool004[oool00ol0VOooooooo`0J
oooo00<0000co`0co`003C?o00030000oooooooo0:Koool004[oool00ol0VOooooooo`0Joooo0P00
00hco`000`000?ooooooo`2Voooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000dco`00
0`000?ooooooo`2Voooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000`co`000`000?ooooooo`2W
oooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo001:
oooo00?o09Woooooool06_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo001:oooo00?o
09Woooooool06_ooo`80000=<ol000<0003oooooool0Yoooo`00B_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o000<<ol000<0003oooooool0Yoooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00B_ooo`03o`2Ioooooooo01?oool200001Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`2Xoooo001:oooo00?o09Woooooool04_ooo`040000oooooooo00001?oo
o`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo001:oooo00?o09Woooooool05?ooo`030000
oooooooo00?oool2000033?o00030000oooooooo0:Soool004[oool00ol0VOooooooo`0Eoooo00<0
003oooooool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo001:oooo00?o09Wooooo
ool04_ooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo001:
oooo00?o09Woooooool04oooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0
04[oool00ol0VOooooooo`0Joooo00<0000co`0co`002S?o00030000oooooooo0:Woool004[oool0
0ol0VOooooooo`0Joooo00<0000co`0co`002S?o00030000oooooooo0:Woool004[oool00ol0VOoo
ooooo`0Joooo00<0000co`0co`002S?o00030000oooooooo0:Woool004[oool00ol0VOooooooo`0J
oooo0P0000/co`000`000?ooooooo`2Yoooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol0
00Xco`000`000?ooooooo`2Yoooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`2Zoooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo001:
oooo00?o09Woooooool06_ooo`80000:<ol000<0003oooooool0Z_ooo`00B_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00B_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o
03?o0008<ol000<0003oooooool0Zoooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`00B_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`00B_ooo`03o`2Ioooooooo01[oool200002C?o00030000oooooooo0:_oool0
04[oool00ol0VOooooooo`0Joooo00<0000co`0co`0023?o00030000oooooooo0:_oool004[oool0
0ol0VOooooooo`0Joooo00<0000co`0co`0023?o00030000oooooooo0:_oool004[oool00ol0VOoo
ooooo`0Joooo00<0000co`0co`001c?o00030000oooooooo0:coool004[oool00ol0VOooooooo`0J
oooo00<0000co`0co`001c?o00030000oooooooo0:coool004[oool00ol0VOooooooo`0Joooo00<0
000co`0co`001c?o00030000oooooooo0:coool004[oool00ol0VOooooooo`0Joooo0P0000Pco`00
0`000?ooooooo`2/oooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Lco`000`000?oo
ooooo`2/oooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo001:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001:
oooo00?o09Woooooool06_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001:oooo00?o
09Woooooool05?ooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool004[oool0
0ol0VOooooooo`0Eoooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo001:oooo00?o09Woooooool04_ooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001O
oooo00@0003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0
067oool200001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo
00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Coool200000oooo`<00004
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001Woooo2C?o00Coool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002_ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0
003oooooool01@0001;oool010000?ooooooo`0000_oool00`000?ooooooo`0300001?ooo`030000
oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool00`000?ooooooo`03oooo00<0003oooooool0MOooo`00Iooo
o`Tco`06oooo00<0003oooooool05oooo`80000:oooo0P0000Coool300000_ooo`030000oooooooo
07Koool006Ooool9<ol0/?ooo`00Ioooo`Pco`2aoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.34) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.22738 .12361 L
.22994 .12361 L
.23119 .12361 L
.23233 .12361 L
s
.23233 .12361 m
.23283 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.34) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`050000ooooooooooooo`2I00?oool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0
000co`0co`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0U
oooo00<0003oooooool02_ooo`03o`2Ioooooooo01Woool00`0003?o03?o000U<ol000<0000co`0c
o`0093?o0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool004_oool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`00Ac?o00D0001Zoooo001;oooo00?o09Woooooool06Oooo`030000
<ol0<ol0048co`050000Koooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000m<ol01@00
07Coool004_oool00ol0VOooooooo`0Ioooo00<0000co`0co`00>C?o00@0001ioooo001;oooo00?o
09Woooooool06Oooo`80000h<ol00P0007goool004_oool00ol0VOooooooo`0Ioooo00<0000co`0c
o`00=C?o0080001ooooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol003<co`020000POoo
o`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000a<ol00P0008?oool004_oool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`00<3?o00030000oooooooo08?oool004_oool00ol0VOooooooo`0I
oooo00<0000co`0co`00;S?o00800026oooo001;oooo00?o09Woooooool06Oooo`80000]<ol00P00
08Soool004_oool00ol0VOooooooo`0Ioooo00<0000co`0co`00:c?o00030000oooooooo08Soool0
04_oool00ol0VOooooooo`0Ioooo00<0000co`0co`00:S?o00030000oooooooo08Woool004_oool0
0ol0VOooooooo`0Ioooo00<0000co`0co`00:C?o00030000oooooooo08[oool004_oool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`00:3?o00030000oooooooo08_oool004_oool00ol0VOooooooo`0I
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool004_oool00ol0VOooooooo`0Ioooo0P00
02Pco`000`000?ooooooo`2<oooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol002Hco`00
0`000?ooooooo`2=oooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol002Dco`000`000?oo
ooooo`2>oooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol002@co`000`000?ooooooo`2?
oooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001;
oooo00?o09Woooooool06Oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001;oooo00?o
09Woooooool06Oooo`80000S<ol000<0003oooooool0TOooo`00Boooo`03o`2Ioooooooo01Woool0
0`0003?o03?o000Q<ol000<0003oooooool0T_ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o
03?o000P<ol000<0003oooooool0Toooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000O<ol000<0
003oooooool0U?ooo`00Boooo`03o`2Ioooooooo017oool500000oooo`030000<ol0<ol001lco`00
0`000?ooooooo`2Doooo001;oooo00?o09Woooooool04oooo`030000oooooooo00?oool00`0003?o
03?o000N<ol000<0003oooooool0UOooo`00Boooo`03o`2Ioooooooo01?oool00`000?ooooooo`03
oooo0P0001lco`000`000?ooooooo`2Eoooo001;oooo00?o09Woooooool04oooo`030000oooooooo
00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00Boooo`03o`2Ioooooooo01?oool0
0`000?ooooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool004_oool00ol0VOoo
ooooo`0Boooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00Boooo`03o`2I
oooooooo01Woool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00Boooo`03o`2Ioooooooo
01Woool00`0003?o03?o000K<ol000<0003oooooool0V?ooo`00Boooo`03o`2Ioooooooo01Woool2
000073?o00030000oooooooo09Soool004_oool00ol0VOooooooo`0Ioooo00<0000co`0co`006S?o
00030000oooooooo09Woool004_oool00ol0VOooooooo`0Ioooo00<0000co`0co`006S?o00030000
oooooooo09Woool004_oool00ol0VOooooooo`0Ioooo00<0000co`0co`006C?o00030000oooooooo
09[oool004_oool00ol0VOooooooo`0Ioooo00<0000co`0co`006C?o00030000oooooooo09[oool0
04_oool00ol0VOooooooo`0Ioooo00<0000co`0co`0063?o00030000oooooooo09_oool004_oool0
0ol0VOooooooo`0Ioooo0P0001Tco`000`000?ooooooo`2Koooo001;oooo00?o09Woooooool06Ooo
o`030000<ol0<ol001Lco`000`000?ooooooo`2Loooo001;oooo00?o09Woooooool06Oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol0
01Hco`000`000?ooooooo`2Moooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol001Dco`000`000?ooooooo`2N
oooo001;oooo00?o09Woooooool06Oooo`80000F<ol000<0003oooooool0W_ooo`00Boooo`03o`2I
oooooooo01Woool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00Boooo`03o`2Ioooooooo
01Woool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00Boooo`03o`2Ioooooooo01Woool0
0`0003?o03?o000D<ol000<0003oooooool0Woooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00Boooo`03o`2Ioooooooo01Woool200005C?o00030000oooooooo
09ooool004_oool00ol0VOooooooo`0Ioooo00<0000co`0co`004c?o00030000oooooooo0:3oool0
04_oool00ol0VOooooooo`0Ioooo00<0000co`0co`004c?o00030000oooooooo0:3oool004_oool0
0ol0VOooooooo`0Ioooo00<0000co`0co`004c?o00030000oooooooo0:3oool004_oool00ol0VOoo
ooooo`0Aoooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00Boooo`03o`2I
oooooooo017oool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool0
04_oool00ol0VOooooooo`0Boooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOoo
o`00Boooo`03o`2Ioooooooo01?oool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000
oooooooo0:7oool004_oool00ol0VOooooooo`0Aoooo00@0003oooooool00004oooo00<0000co`0c
o`004C?o00030000oooooooo0:;oool004_oool00ol0VOooooooo`0Boooo0P0000Goool00`0003?o
03?o000A<ol000<0003oooooool0X_ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00Boooo`03o`2Ioooooooo01Woool200004C?o00030000oooooooo0:?oool0
04_oool00ol0VOooooooo`0Ioooo00<0000co`0co`0043?o00030000oooooooo0:?oool004_oool0
0ol0VOooooooo`0Ioooo00<0000co`0co`0043?o00030000oooooooo0:?oool004_oool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`0043?o00030000oooooooo0:?oool004_oool00ol0VOooooooo`0I
oooo00<0000co`0co`003c?o00030000oooooooo0:Coool004_oool00ol0VOooooooo`0Ioooo00<0
000co`0co`003c?o00030000oooooooo0:Coool004_oool00ol0VOooooooo`0Ioooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool004_oool00ol0VOooooooo`0Ioooo0P00010co`000`000?oo
ooooo`2Toooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol000hco`000`000?ooooooo`2U
oooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001;
oooo00?o09Woooooool06Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001;oooo00?o
09Woooooool06Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001;oooo00?o09Wooooo
ool06Oooo`030000<ol0<ol000dco`000`000?ooooooo`2Voooo001;oooo00?o09Woooooool06Ooo
o`80000><ol000<0003oooooool0Y_ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000=
<ol000<0003oooooool0Y_ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000<<ol000<0003ooooo
ool0Yoooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00Booo
o`03o`2Ioooooooo01Woool200003C?o00030000oooooooo0:Ooool004_oool00ol0VOooooooo`0I
oooo00<0000co`0co`0033?o00030000oooooooo0:Ooool004_oool00ol0VOooooooo`0Ioooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool004_oool00ol0VOooooooo`0Ioooo00<0000co`0c
o`002c?o00030000oooooooo0:Soool004_oool00ol0VOooooooo`0Boooo0P0000Goool00`0003?o
03?o000;<ol000<0003oooooool0Z?ooo`00Boooo`03o`2Ioooooooo017oool010000?ooooooo`00
00Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Boooo`03o`2Ioooooooo01?oool0
0`000?ooooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo001;oooo00?o09Woooooool05?oo
o`030000oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Boooo`03o`2I
oooooooo017oool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?oo
o`00Boooo`03o`2Ioooooooo01;oool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Y
oooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001;
oooo00?o09Woooooool06Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001;oooo00?o
09Woooooool06Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001;oooo00?o09Wooooo
ool06Oooo`80000;<ol000<0003oooooool0ZOooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o
03?o000:<ol000<0003oooooool0ZOooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o0009
<ol000<0003oooooool0Z_ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00Boooo`03o`2Ioooooooo01Woool200002S?o00030000oooooooo0:[oool004_oool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`002C?o00030000oooooooo0:[oool004_oool00ol0VOooooooo`0I
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool004_oool00ol0VOooooooo`0Ioooo00<0
000co`0co`0023?o00030000oooooooo0:_oool004_oool00ol0VOooooooo`0Ioooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool004_oool00ol0VOooooooo`0Ioooo00<0000co`0co`0023?o
00030000oooooooo0:_oool004_oool00ol0VOooooooo`0Ioooo0P0000Tco`000`000?ooooooo`2[
oooo001;oooo00?o09Woooooool06Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001;
oooo00?o09Woooooool06Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001;oooo00?o
09Woooooool06Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001;oooo00?o09Wooooo
ool06Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001;oooo00?o09Woooooool06Ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001;oooo00?o09Woooooool06Oooo`800008
<ol000<0003oooooool0[?ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o0007<ol000<0
003oooooool0[?ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00Boooo`03o`2Ioooooooo01Woool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00Booo
o`03o`2Ioooooooo01?oool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001;
oooo00?o09Woooooool05?ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00Boooo`03o`2Ioooooooo017oool500000oooo`800008<ol000<0003oooooool0[?oo
o`00Goooo`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_
oooo001Qoooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9
<ol01_ooo`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?oo
ooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000Goool3
00000_ooo`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0
003oooooool00005oooo00D0003oooooooooool00000Moooo`00Ioooo`Tco`04oooo00<0003ooooo
ool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool010000?ooooooooooo`D00003
oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000_oool010000?ooooooo`0000;oool01@000?ooooooooooo`00001goooo001Woooo2C?o
00Goool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oool000000oooo`030000oooooooo07Goool006Ooool9<ol01_ooo`030000oooooooo
01Ooool200002_ooo`800005oooo0P0000;oool00`000?ooooooo`1foooo001Woooo2C?o0;3oool0
06Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.32) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.23496 .12361 L
.2364 .12361 L
.23775 .12361 L
.2389 .12361 L
s
.2389 .12361 m
.2394 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.32) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00?oool00ol0VOooo`000007oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool03?ooo`03o`2Ioooooooo01Ooool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool004goool00ol0VOooooooo`0G
oooo00<0000co`0co`00Ac?o00D0001Zoooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol0
048co`050000Koooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000m<ol01@0007Coool0
04goool00ol0VOooooooo`0Goooo00<0000co`0co`00>C?o00@0001ioooo001=oooo00?o09Wooooo
ool05oooo`80000h<ol00P0007goool004goool00ol0VOooooooo`0Goooo00<0000co`0co`00=C?o
0080001ooooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol003<co`020000POooo`00COoo
o`03o`2Ioooooooo01Ooool00`0003?o03?o000a<ol00P0008?oool004goool00ol0VOooooooo`0G
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool004goool00ol0VOooooooo`0Goooo00<0
000co`0co`00;S?o00800026oooo001=oooo00?o09Woooooool05oooo`80000]<ol00P0008Soool0
04goool00ol0VOooooooo`0Goooo00<0000co`0co`00:c?o00030000oooooooo08Soool004goool0
0ol0VOooooooo`0Goooo00<0000co`0co`00:S?o00030000oooooooo08Woool004goool00ol0VOoo
ooooo`0Goooo00<0000co`0co`00:C?o00030000oooooooo08[oool004goool00ol0VOooooooo`0G
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool004goool00ol0VOooooooo`0Goooo00<0
000co`0co`00:3?o00030000oooooooo08_oool004goool00ol0VOooooooo`0Goooo0P0002Pco`00
0`000?ooooooo`2<oooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo001=
oooo00?o09Woooooool05oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001=oooo00?o
09Woooooool05oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001=oooo00?o09Wooooo
ool05oooo`80000S<ol000<0003oooooool0TOooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00COooo`03o`2Ioooooooo00ooool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo001=oooo00?o09Woooooool04Oooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00COooo`03o`2Ioooooooo017oool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo001=oooo00?o09Woooooool04Oooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00COooo`03o`2Ioooooooo017oool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool004goool00ol0VOooooooo`0@
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00COooo`03o`2Ioooooooo
01Ooool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00COooo`03o`2Ioooooooo01Ooool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00COooo`03o`2Ioooooooo01Ooool2000073?o
00030000oooooooo09Soool004goool00ol0VOooooooo`0Goooo00<0000co`0co`006S?o00030000
oooooooo09Woool004goool00ol0VOooooooo`0Goooo00<0000co`0co`006S?o00030000oooooooo
09Woool004goool00ol0VOooooooo`0Goooo00<0000co`0co`006C?o00030000oooooooo09[oool0
04goool00ol0VOooooooo`0Goooo00<0000co`0co`006C?o00030000oooooooo09[oool004goool0
0ol0VOooooooo`0Goooo00<0000co`0co`0063?o00030000oooooooo09_oool004goool00ol0VOoo
ooooo`0Goooo0P0001Tco`000`000?ooooooo`2Koooo001=oooo00?o09Woooooool05oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001=
oooo00?o09Woooooool05oooo`80000F<ol000<0003oooooool0W_ooo`00COooo`03o`2Ioooooooo
01Ooool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00COooo`03o`2Ioooooooo01Ooool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00COooo`03o`2Ioooooooo01Ooool200005C?o00030000oooooooo09ooool0
04goool00ol0VOooooooo`0Goooo00<0000co`0co`004c?o00030000oooooooo0:3oool004goool0
0ol0VOooooooo`0Goooo00<0000co`0co`004c?o00030000oooooooo0:3oool004goool00ol0VOoo
ooooo`0Goooo00<0000co`0co`004c?o00030000oooooooo0:3oool004goool00ol0VOooooooo`0?
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00COooo`03o`2Ioooooooo
00ooool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool004goool0
0ol0VOooooooo`0@oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00COoo
o`03o`2Ioooooooo017oool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool004goool00ol0VOooooooo`0?oooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool004goool00ol0VOooooooo`0@oooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00COooo`03o`2Ioooooooo01Ooool200004C?o00030000oooooooo0:?oool004goool0
0ol0VOooooooo`0Goooo00<0000co`0co`0043?o00030000oooooooo0:?oool004goool00ol0VOoo
ooooo`0Goooo00<0000co`0co`0043?o00030000oooooooo0:?oool004goool00ol0VOooooooo`0G
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool004goool00ol0VOooooooo`0Goooo00<0
000co`0co`003c?o00030000oooooooo0:Coool004goool00ol0VOooooooo`0Goooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool004goool00ol0VOooooooo`0Goooo00<0000co`0co`003c?o
00030000oooooooo0:Coool004goool00ol0VOooooooo`0Goooo0P00010co`000`000?ooooooo`2T
oooo001=oooo00?o09Woooooool05oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001=
oooo00?o09Woooooool05oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001=oooo00?o
09Woooooool05oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001=oooo00?o09Wooooo
ool05oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001=oooo00?o09Woooooool05ooo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo001=oooo00?o09Woooooool05oooo`80000>
<ol000<0003oooooool0Y_ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00COoo
o`03o`2Ioooooooo01Ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00COooo`03o`2I
oooooooo01Ooool200003C?o00030000oooooooo0:Ooool004goool00ol0VOooooooo`0Goooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool004goool00ol0VOooooooo`0Goooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool004goool00ol0VOooooooo`0Goooo00<0000co`0co`002c?o
00030000oooooooo0:Soool004goool00ol0VOooooooo`0@oooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00COooo`03o`2Ioooooooo00ooool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00COooo`03o`2Ioooooooo017oool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo001=oooo00?o09Woooooool04_ooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00COooo`03o`2Ioooooooo
00ooool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00COoo
o`03o`2Ioooooooo013oool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001=
oooo00?o09Woooooool05oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001=oooo00?o
09Woooooool05oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001=oooo00?o09Wooooo
ool05oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001=oooo00?o09Woooooool05ooo
o`80000;<ol000<0003oooooool0ZOooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00COoo
o`03o`2Ioooooooo01Ooool200002S?o00030000oooooooo0:[oool004goool00ol0VOooooooo`0G
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool004goool00ol0VOooooooo`0Goooo00<0
000co`0co`002C?o00030000oooooooo0:[oool004goool00ol0VOooooooo`0Goooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool004goool00ol0VOooooooo`0Goooo00<0000co`0co`0023?o
00030000oooooooo0:_oool004goool00ol0VOooooooo`0Goooo00<0000co`0co`0023?o00030000
oooooooo0:_oool004goool00ol0VOooooooo`0Goooo0P0000Tco`000`000?ooooooo`2[oooo001=
oooo00?o09Woooooool05oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001=oooo00?o
09Woooooool05oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001=oooo00?o09Wooooo
ool05oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001=oooo00?o09Woooooool05ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001=oooo00?o09Woooooool05oooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo001=oooo00?o09Woooooool05oooo`800008<ol000<0
003oooooool0[?ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00COooo`03o`2Ioooooooo01Ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00COoo
o`03o`2Ioooooooo01Ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00COooo`03o`2I
oooooooo017oool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001=oooo00?o
09Woooooool04_ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00COooo`03o`2Ioooooooo00ooool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000?oool400000ooo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00002oooo00<0003oooooool01?ooo`030000oooooooo07Goool006Ooool9<ol01?ooo`030000
oooooooo00;oool00`000?ooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool00_oo
o`030000oooooooo00Coool00`000?ooooooo`1doooo001Woooo2C?o00Goool00`000?ooooooo`05
00004_ooo`040000oooooooo00002oooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0
003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000005Oooo`040000oooooooo
00002?ooo`040000oooooooo00000_ooo`040000oooooooo00000oooo`030000oooooooo07Goool0
06Ooool9<ol01_ooo`030000oooooooo01Ooool200002_ooo`800004oooo0P0000?oool00`000?oo
ooooo`1foooo001Woooo2C?o0;3oool006Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.23739 .12361 L
.24016 .12361 L
.24276 .12361 L
.24392 .12361 L
.24502 .12361 L
s
.24502 .12361 m
.24553 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Coool00ol0V@000?ooo`06oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool03Oooo`03o`2Ioooooooo01Koool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool004koool00ol0VOooooooo`0F
oooo00<0000co`0co`00Ac?o00D0001Zoooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol0
048co`050000Koooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000m<ol01@0007Coool0
04koool00ol0VOooooooo`0Foooo00<0000co`0co`00>C?o00@0001ioooo001>oooo00?o09Wooooo
ool05_ooo`80000h<ol00P0007goool004koool00ol0VOooooooo`0Foooo00<0000co`0co`00=C?o
0080001ooooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol003<co`020000POooo`00C_oo
o`03o`2Ioooooooo01Koool00`0003?o03?o000a<ol00P0008?oool004koool00ol0VOooooooo`0F
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool004koool00ol0VOooooooo`0Foooo00<0
000co`0co`00;S?o00800026oooo001>oooo00?o09Woooooool05_ooo`80000]<ol00P0008Soool0
04koool00ol0VOooooooo`0Foooo00<0000co`0co`00:c?o00030000oooooooo08Soool004koool0
0ol0VOooooooo`0Foooo00<0000co`0co`00:S?o00030000oooooooo08Woool004koool00ol0VOoo
ooooo`0Foooo00<0000co`0co`00:C?o00030000oooooooo08[oool004koool00ol0VOooooooo`0F
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool004koool00ol0VOooooooo`0Foooo00<0
000co`0co`00:3?o00030000oooooooo08_oool004koool00ol0VOooooooo`0Foooo0P0002Pco`00
0`000?ooooooo`2<oooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo001>
oooo00?o09Woooooool05_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001>oooo00?o
09Woooooool05_ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001>oooo00?o09Wooooo
ool05_ooo`80000S<ol000<0003oooooool0TOooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00C_ooo`03o`2Ioooooooo00koool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo001>oooo00?o09Woooooool04?ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00C_ooo`03o`2Ioooooooo013oool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo001>oooo00?o09Woooooool04?ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00C_ooo`03o`2Ioooooooo013oool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool004koool00ol0VOooooooo`0?
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00C_ooo`03o`2Ioooooooo
01Koool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00C_ooo`03o`2Ioooooooo01Koool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00C_ooo`03o`2Ioooooooo01Koool2000073?o
00030000oooooooo09Soool004koool00ol0VOooooooo`0Foooo00<0000co`0co`006S?o00030000
oooooooo09Woool004koool00ol0VOooooooo`0Foooo00<0000co`0co`006S?o00030000oooooooo
09Woool004koool00ol0VOooooooo`0Foooo00<0000co`0co`006C?o00030000oooooooo09[oool0
04koool00ol0VOooooooo`0Foooo00<0000co`0co`006C?o00030000oooooooo09[oool004koool0
0ol0VOooooooo`0Foooo00<0000co`0co`0063?o00030000oooooooo09_oool004koool00ol0VOoo
ooooo`0Foooo0P0001Tco`000`000?ooooooo`2Koooo001>oooo00?o09Woooooool05_ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001>
oooo00?o09Woooooool05_ooo`80000F<ol000<0003oooooool0W_ooo`00C_ooo`03o`2Ioooooooo
01Koool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00C_ooo`03o`2Ioooooooo01Koool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00C_ooo`03o`2Ioooooooo01Koool200005C?o00030000oooooooo09ooool0
04koool00ol0VOooooooo`0Foooo00<0000co`0co`004c?o00030000oooooooo0:3oool004koool0
0ol0VOooooooo`0Foooo00<0000co`0co`004c?o00030000oooooooo0:3oool004koool00ol0VOoo
ooooo`0Foooo00<0000co`0co`004c?o00030000oooooooo0:3oool004koool00ol0VOooooooo`0>
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00C_ooo`03o`2Ioooooooo
00koool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool004koool0
0ol0VOooooooo`0?oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00C_oo
o`03o`2Ioooooooo013oool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool004koool00ol0VOooooooo`0>oooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool004koool00ol0VOooooooo`0?oooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00C_ooo`03o`2Ioooooooo01Koool200004C?o00030000oooooooo0:?oool004koool0
0ol0VOooooooo`0Foooo00<0000co`0co`0043?o00030000oooooooo0:?oool004koool00ol0VOoo
ooooo`0Foooo00<0000co`0co`0043?o00030000oooooooo0:?oool004koool00ol0VOooooooo`0F
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool004koool00ol0VOooooooo`0Foooo00<0
000co`0co`003c?o00030000oooooooo0:Coool004koool00ol0VOooooooo`0Foooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool004koool00ol0VOooooooo`0Foooo00<0000co`0co`003c?o
00030000oooooooo0:Coool004koool00ol0VOooooooo`0Foooo0P00010co`000`000?ooooooo`2T
oooo001>oooo00?o09Woooooool05_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001>
oooo00?o09Woooooool05_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001>oooo00?o
09Woooooool05_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001>oooo00?o09Wooooo
ool05_ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001>oooo00?o09Woooooool05_oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo001>oooo00?o09Woooooool05_ooo`80000>
<ol000<0003oooooool0Y_ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00C_oo
o`03o`2Ioooooooo01Koool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00C_ooo`03o`2I
oooooooo01Koool200003C?o00030000oooooooo0:Ooool004koool00ol0VOooooooo`0Foooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool004koool00ol0VOooooooo`0Foooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool004koool00ol0VOooooooo`0Foooo00<0000co`0co`002c?o
00030000oooooooo0:Soool004koool00ol0VOooooooo`0?oooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00C_ooo`03o`2Ioooooooo00koool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00C_ooo`03o`2Ioooooooo013oool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo001>oooo00?o09Woooooool04Oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00C_ooo`03o`2Ioooooooo
00koool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00C_oo
o`03o`2Ioooooooo00ooool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001>
oooo00?o09Woooooool05_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001>oooo00?o
09Woooooool05_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001>oooo00?o09Wooooo
ool05_ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001>oooo00?o09Woooooool05_oo
o`80000;<ol000<0003oooooool0ZOooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00C_oo
o`03o`2Ioooooooo01Koool200002S?o00030000oooooooo0:[oool004koool00ol0VOooooooo`0F
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool004koool00ol0VOooooooo`0Foooo00<0
000co`0co`002C?o00030000oooooooo0:[oool004koool00ol0VOooooooo`0Foooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool004koool00ol0VOooooooo`0Foooo00<0000co`0co`0023?o
00030000oooooooo0:_oool004koool00ol0VOooooooo`0Foooo00<0000co`0co`0023?o00030000
oooooooo0:_oool004koool00ol0VOooooooo`0Foooo0P0000Tco`000`000?ooooooo`2[oooo001>
oooo00?o09Woooooool05_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001>oooo00?o
09Woooooool05_ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001>oooo00?o09Wooooo
ool05_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001>oooo00?o09Woooooool05_oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001>oooo00?o09Woooooool05_ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo001>oooo00?o09Woooooool05_ooo`800008<ol000<0
003oooooool0[?ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00C_ooo`03o`2Ioooooooo01Koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00C_oo
o`03o`2Ioooooooo01Koool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00C_ooo`03o`2I
oooooooo013oool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001>oooo00?o
09Woooooool04Oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00C_ooo`03o`2Ioooooooo00koool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol02Ooo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001Woooo2C?o00Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool006Ooool9<ol02?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000Coool00`000?oo
ooooo`1hoooo001Woooo2C?o00Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool006Ooool9<ol01oooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo00@0003oooooool0000:oooo00<0003oooooool00oooo`030000oooooooo07Ooool006Ooool9
<ol02?ooo`030000oooooooo00D0000Boooo00@0003oooooool0000;oooo00D0003oooooooooool0
0000N_ooo`00Ioooo`Tco`08oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`030000oooooooo07Soool006Ooool9<ol02Oooo`030000oooooooo
01Ooool200002_ooo`800003oooo00<0003oooooool0NOooo`00Ioooo`Tco`2`oooo001Woooo23?o
0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.28) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.23739 .12361 L
.24276 .12361 L
.24745 .12361 L
.24873 .12361 L
.25012 .12361 L
.25142 .12361 L
s
.25142 .12361 m
.2519 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.28) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?l0VOooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool03oooo`03o`2Ioooooooo01Coool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool0053oool00ol0VOooooooo`0D
oooo00<0000co`0co`00Ac?o00D0001Zoooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol0
048co`050000Koooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000m<ol01@0007Coool0
053oool00ol0VOooooooo`0Doooo00<0000co`0co`00>C?o00@0001ioooo001@oooo00?o09Wooooo
ool05?ooo`80000h<ol00P0007goool0053oool00ol0VOooooooo`0Doooo00<0000co`0co`00=C?o
0080001ooooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol003<co`020000POooo`00D?oo
o`03o`2Ioooooooo01Coool00`0003?o03?o000a<ol00P0008?oool0053oool00ol0VOooooooo`0D
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool0053oool00ol0VOooooooo`0Doooo00<0
000co`0co`00;S?o00800026oooo001@oooo00?o09Woooooool05?ooo`80000]<ol00P0008Soool0
053oool00ol0VOooooooo`0Doooo00<0000co`0co`00:c?o00030000oooooooo08Soool0053oool0
0ol0VOooooooo`0Doooo00<0000co`0co`00:S?o00030000oooooooo08Woool0053oool00ol0VOoo
ooooo`0Doooo00<0000co`0co`00:C?o00030000oooooooo08[oool0053oool00ol0VOooooooo`0D
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool0053oool00ol0VOooooooo`0Doooo00<0
000co`0co`00:3?o00030000oooooooo08_oool0053oool00ol0VOooooooo`0Doooo0P0002Pco`00
0`000?ooooooo`2<oooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo001@
oooo00?o09Woooooool05?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001@oooo00?o
09Woooooool05?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001@oooo00?o09Wooooo
ool05?ooo`80000S<ol000<0003oooooool0TOooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00D?ooo`03o`2Ioooooooo00coool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo001@oooo00?o09Woooooool03_ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00D?ooo`03o`2Ioooooooo00koool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo001@oooo00?o09Woooooool03_ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00D?ooo`03o`2Ioooooooo00koool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool0053oool00ol0VOooooooo`0=
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00D?ooo`03o`2Ioooooooo
01Coool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00D?ooo`03o`2Ioooooooo01Coool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00D?ooo`03o`2Ioooooooo01Coool2000073?o
00030000oooooooo09Soool0053oool00ol0VOooooooo`0Doooo00<0000co`0co`006S?o00030000
oooooooo09Woool0053oool00ol0VOooooooo`0Doooo00<0000co`0co`006S?o00030000oooooooo
09Woool0053oool00ol0VOooooooo`0Doooo00<0000co`0co`006C?o00030000oooooooo09[oool0
053oool00ol0VOooooooo`0Doooo00<0000co`0co`006C?o00030000oooooooo09[oool0053oool0
0ol0VOooooooo`0Doooo00<0000co`0co`0063?o00030000oooooooo09_oool0053oool00ol0VOoo
ooooo`0Doooo0P0001Tco`000`000?ooooooo`2Koooo001@oooo00?o09Woooooool05?ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001@
oooo00?o09Woooooool05?ooo`80000F<ol000<0003oooooool0W_ooo`00D?ooo`03o`2Ioooooooo
01Coool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00D?ooo`03o`2Ioooooooo01Coool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00D?ooo`03o`2Ioooooooo01Coool200005C?o00030000oooooooo09ooool0
053oool00ol0VOooooooo`0Doooo00<0000co`0co`004c?o00030000oooooooo0:3oool0053oool0
0ol0VOooooooo`0Doooo00<0000co`0co`004c?o00030000oooooooo0:3oool0053oool00ol0VOoo
ooooo`0Doooo00<0000co`0co`004c?o00030000oooooooo0:3oool0053oool00ol0VOooooooo`0<
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00D?ooo`03o`2Ioooooooo
00coool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool0053oool0
0ol0VOooooooo`0=oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00D?oo
o`03o`2Ioooooooo00koool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool0053oool00ol0VOooooooo`0<oooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool0053oool00ol0VOooooooo`0=oooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00D?ooo`03o`2Ioooooooo01Coool200004C?o00030000oooooooo0:?oool0053oool0
0ol0VOooooooo`0Doooo00<0000co`0co`0043?o00030000oooooooo0:?oool0053oool00ol0VOoo
ooooo`0Doooo00<0000co`0co`0043?o00030000oooooooo0:?oool0053oool00ol0VOooooooo`0D
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool0053oool00ol0VOooooooo`0Doooo00<0
000co`0co`003c?o00030000oooooooo0:Coool0053oool00ol0VOooooooo`0Doooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool0053oool00ol0VOooooooo`0Doooo00<0000co`0co`003c?o
00030000oooooooo0:Coool0053oool00ol0VOooooooo`0Doooo0P00010co`000`000?ooooooo`2T
oooo001@oooo00?o09Woooooool05?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001@
oooo00?o09Woooooool05?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001@oooo00?o
09Woooooool05?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001@oooo00?o09Wooooo
ool05?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001@oooo00?o09Woooooool05?oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo001@oooo00?o09Woooooool05?ooo`80000>
<ol000<0003oooooool0Y_ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00D?oo
o`03o`2Ioooooooo01Coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00D?ooo`03o`2I
oooooooo01Coool200003C?o00030000oooooooo0:Ooool0053oool00ol0VOooooooo`0Doooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool0053oool00ol0VOooooooo`0Doooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool0053oool00ol0VOooooooo`0Doooo00<0000co`0co`002c?o
00030000oooooooo0:Soool0053oool00ol0VOooooooo`0=oooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00D?ooo`03o`2Ioooooooo00coool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00D?ooo`03o`2Ioooooooo00koool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo001@oooo00?o09Woooooool03oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00D?ooo`03o`2Ioooooooo
00coool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00D?oo
o`03o`2Ioooooooo00goool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001@
oooo00?o09Woooooool05?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001@oooo00?o
09Woooooool05?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001@oooo00?o09Wooooo
ool05?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001@oooo00?o09Woooooool05?oo
o`80000;<ol000<0003oooooool0ZOooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00D?oo
o`03o`2Ioooooooo01Coool200002S?o00030000oooooooo0:[oool0053oool00ol0VOooooooo`0D
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool0053oool00ol0VOooooooo`0Doooo00<0
000co`0co`002C?o00030000oooooooo0:[oool0053oool00ol0VOooooooo`0Doooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool0053oool00ol0VOooooooo`0Doooo00<0000co`0co`0023?o
00030000oooooooo0:_oool0053oool00ol0VOooooooo`0Doooo00<0000co`0co`0023?o00030000
oooooooo0:_oool0053oool00ol0VOooooooo`0Doooo0P0000Tco`000`000?ooooooo`2[oooo001@
oooo00?o09Woooooool05?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001@oooo00?o
09Woooooool05?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001@oooo00?o09Wooooo
ool05?ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001@oooo00?o09Woooooool05?oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001@oooo00?o09Woooooool05?ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo001@oooo00?o09Woooooool05?ooo`800008<ol000<0
003oooooool0[?ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00D?ooo`03o`2Ioooooooo01Coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00D?oo
o`03o`2Ioooooooo01Coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00D?ooo`03o`2I
oooooooo00koool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001@oooo00?o
09Woooooool03oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00D?ooo`03o`2Ioooooooo00coool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo100000?oool200001?oo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00<0003ooooo
ool00oooo`040000oooooooo00000oooo`030000oooooooo07Goool006Ooool9<ol01?ooo`030000
oooooooo00;oool00`000?ooooooo`0Coooo00@0003oooooool00009oooo00<0003oooooool00_oo
o`040000oooooooo00001?ooo`030000oooooooo07Coool006Ooool9<ol01Oooo`030000oooooooo
00D0000Boooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?oo
o`040000oooooooo00000_ooo`040000oooooooo00000oooo`030000oooooooo07Goool006Ooool9
<ol01_ooo`030000oooooooo01Ooool200002_ooo`800004oooo0P0000?oool00`000?ooooooo`1f
oooo001Woooo2C?o0;3oool006Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.26) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.24276 .12361 L
.24754 .12361 L
.25261 .12361 L
.2547 .12361 L
.25694 .12361 L
.25823 .12361 L
s
.25823 .12361 m
.2587 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.26) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool010000?ooooooool0V@Coool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`0013?o02P00002oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Goool0
0`000?ooooooo`0Aoooo00?o09Woooooool04_ooo`030000<ol0<ol002Dco`000`0003?o03?o000T
<ol0400001Woool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00D_ooo`03o`2Ioooooooo
01;oool00`0003?o03?o0017<ol01@0006[oool005;oool00ol0VOooooooo`0Boooo00<0000co`0c
o`00@S?o00D0001_oooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol003dco`050000M?oo
o`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000i<ol0100007Woool005;oool00ol0VOoo
ooooo`0Boooo0P0003Pco`020000OOooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000e
<ol00P0007ooool005;oool00ol0VOooooooo`0Boooo00<0000co`0co`00<c?o00800021oooo001B
oooo00?o09Woooooool04_ooo`030000<ol0<ol0034co`020000Poooo`00D_ooo`03o`2Ioooooooo
01;oool00`0003?o03?o000`<ol000<0003oooooool0Poooo`00D_ooo`03o`2Ioooooooo01;oool0
0`0003?o03?o000^<ol00P0008Koool005;oool00ol0VOooooooo`0Boooo0P0002dco`020000R?oo
o`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000[<ol000<0003oooooool0R?ooo`00D_oo
o`03o`2Ioooooooo01;oool00`0003?o03?o000Z<ol000<0003oooooool0ROooo`00D_ooo`03o`2I
oooooooo01;oool00`0003?o03?o000Y<ol000<0003oooooool0R_ooo`00D_ooo`03o`2Ioooooooo
01;oool00`0003?o03?o000X<ol000<0003oooooool0Roooo`00D_ooo`03o`2Ioooooooo01;oool0
0`0003?o03?o000X<ol000<0003oooooool0Roooo`00D_ooo`03o`2Ioooooooo01;oool20000:3?o
00030000oooooooo08coool005;oool00ol0VOooooooo`0Boooo00<0000co`0co`009S?o00030000
oooooooo08goool005;oool00ol0VOooooooo`0Boooo00<0000co`0co`009C?o00030000oooooooo
08koool005;oool00ol0VOooooooo`0Boooo00<0000co`0co`0093?o00030000oooooooo08ooool0
05;oool00ol0VOooooooo`0Boooo00<0000co`0co`008c?o00030000oooooooo093oool005;oool0
0ol0VOooooooo`0Boooo00<0000co`0co`008c?o00030000oooooooo093oool005;oool00ol0VOoo
ooooo`0Boooo0P0002<co`000`000?ooooooo`2Aoooo001Boooo00?o09Woooooool04_ooo`030000
<ol0<ol0024co`000`000?ooooooo`2Boooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol0
020co`000`000?ooooooo`2Coooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol0020co`00
0`000?ooooooo`2Coooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo001Boooo00?o09Woooooool02_ooo`D00003oooo00<0000co`0co`007c?o00030000
oooooooo09Coool005;oool00ol0VOooooooo`0<oooo00<0003oooooool00oooo`030000<ol0<ol0
01hco`000`000?ooooooo`2Eoooo001Boooo00?o09Woooooool03?ooo`030000oooooooo00?oool2
00007c?o00030000oooooooo09Goool005;oool00ol0VOooooooo`0<oooo00<0003oooooool00ooo
o`030000<ol0<ol001dco`000`000?ooooooo`2Foooo001Boooo00?o09Woooooool03?ooo`030000
oooooooo00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00D_ooo`03o`2Ioooooooo
00_oool200001Oooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo001Boooo00?o09Wooooo
ool04_ooo`030000<ol0<ol001`co`000`000?ooooooo`2Goooo001Boooo00?o09Woooooool04_oo
o`030000<ol0<ol001/co`000`000?ooooooo`2Hoooo001Boooo00?o09Woooooool04_ooo`80000L
<ol000<0003oooooool0V?ooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000J<ol000<0
003oooooool0VOooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000J<ol000<0003ooooo
ool0VOooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000I<ol000<0003oooooool0V_oo
o`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000I<ol000<0003oooooool0V_ooo`00D_oo
o`03o`2Ioooooooo01;oool00`0003?o03?o000H<ol000<0003oooooool0Voooo`00D_ooo`03o`2I
oooooooo01;oool200006C?o00030000oooooooo09_oool005;oool00ol0VOooooooo`0Boooo00<0
000co`0co`005c?o00030000oooooooo09coool005;oool00ol0VOooooooo`0Boooo00<0000co`0c
o`005c?o00030000oooooooo09coool005;oool00ol0VOooooooo`0Boooo00<0000co`0co`005S?o
00030000oooooooo09goool005;oool00ol0VOooooooo`0Boooo00<0000co`0co`005S?o00030000
oooooooo09goool005;oool00ol0VOooooooo`0Boooo00<0000co`0co`005S?o00030000oooooooo
09goool005;oool00ol0VOooooooo`0Boooo00<0000co`0co`005C?o00030000oooooooo09koool0
05;oool00ol0VOooooooo`0Boooo0P0001Hco`000`000?ooooooo`2Noooo001Boooo00?o09Wooooo
ool04_ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001Boooo00?o09Woooooool04_oo
o`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001Boooo00?o09Woooooool04_ooo`030000
<ol0<ol001@co`000`000?ooooooo`2Ooooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol0
01@co`000`000?ooooooo`2Ooooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol001@co`00
0`000?ooooooo`2Ooooo001Boooo00?o09Woooooool04_ooo`80000E<ol000<0003oooooool0Wooo
o`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00D_oo
o`03o`2Ioooooooo01;oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00D_ooo`03o`2I
oooooooo01;oool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00D_ooo`03o`2Ioooooooo
00[oool400001?ooo`030000<ol0<ol001<co`000`000?ooooooo`2Poooo001Boooo00?o09Wooooo
ool02_ooo`030000oooooooo00Goool00`0003?o03?o000B<ol000<0003oooooool0XOooo`00D_oo
o`03o`2Ioooooooo00_oool00`000?ooooooo`04oooo0P0001<co`000`000?ooooooo`2Qoooo001B
oooo00?o09Woooooool03?ooo`030000oooooooo00?oool00`0003?o03?o000B<ol000<0003ooooo
ool0XOooo`00D_ooo`03o`2Ioooooooo00[oool010000?ooooooo`0000Coool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00D_ooo`03o`2Ioooooooo00_oool200001Oooo`030000<ol0<ol0
014co`000`000?ooooooo`2Roooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol0014co`00
0`000?ooooooo`2Roooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol0014co`000`000?oo
ooooo`2Roooo001Boooo00?o09Woooooool04_ooo`80000A<ol000<0003oooooool0Xoooo`00D_oo
o`03o`2Ioooooooo01;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00D_ooo`03o`2I
oooooooo01;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00D_ooo`03o`2Ioooooooo
01;oool00`0003?o03?o000@<ol000<0003oooooool0Xoooo`00D_ooo`03o`2Ioooooooo01;oool0
0`0003?o03?o000?<ol000<0003oooooool0Y?ooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o
03?o000?<ol000<0003oooooool0Y?ooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000?
<ol000<0003oooooool0Y?ooo`00D_ooo`03o`2Ioooooooo01;oool2000043?o00030000oooooooo
0:Coool005;oool00ol0VOooooooo`0Boooo00<0000co`0co`003S?o00030000oooooooo0:Goool0
05;oool00ol0VOooooooo`0Boooo00<0000co`0co`003S?o00030000oooooooo0:Goool005;oool0
0ol0VOooooooo`0Boooo00<0000co`0co`003S?o00030000oooooooo0:Goool005;oool00ol0VOoo
ooooo`0Boooo00<0000co`0co`003S?o00030000oooooooo0:Goool005;oool00ol0VOooooooo`0B
oooo00<0000co`0co`003C?o00030000oooooooo0:Koool005;oool00ol0VOooooooo`0Boooo0P00
00hco`000`000?ooooooo`2Voooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000dco`00
0`000?ooooooo`2Voooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000dco`000`000?oo
ooooo`2Voooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000`co`000`000?ooooooo`2W
oooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo001B
oooo00?o09Woooooool04_ooo`030000<ol0<ol000`co`000`000?ooooooo`2Woooo001Boooo00?o
09Woooooool04_ooo`80000=<ol000<0003oooooool0Yoooo`00D_ooo`03o`2Ioooooooo01;oool0
0`0003?o03?o000<<ol000<0003oooooool0Yoooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o
03?o000<<ol000<0003oooooool0Yoooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00D_ooo`03o`2Ioooooooo00_oool200001Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`2Xoooo001Boooo00?o09Woooooool02_ooo`040000oooooooo00001?oo
o`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo001Boooo00?o09Woooooool03?ooo`030000
oooooooo00?oool2000033?o00030000oooooooo0:Soool005;oool00ol0VOooooooo`0=oooo00<0
003oooooool00_ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo001Boooo00?o09Wooooo
ool02_ooo`040000oooooooo00001?ooo`030000<ol0<ol000/co`000`000?ooooooo`2Xoooo001B
oooo00?o09Woooooool02oooo`800005oooo00<0000co`0co`002S?o00030000oooooooo0:Woool0
05;oool00ol0VOooooooo`0Boooo00<0000co`0co`002S?o00030000oooooooo0:Woool005;oool0
0ol0VOooooooo`0Boooo00<0000co`0co`002S?o00030000oooooooo0:Woool005;oool00ol0VOoo
ooooo`0Boooo00<0000co`0co`002S?o00030000oooooooo0:Woool005;oool00ol0VOooooooo`0B
oooo0P0000/co`000`000?ooooooo`2Yoooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol0
00Xco`000`000?ooooooo`2Yoooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`2Zoooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`2Zoooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Z
oooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000Tco`000`000?ooooooo`2Zoooo001B
oooo00?o09Woooooool04_ooo`80000:<ol000<0003oooooool0Z_ooo`00D_ooo`03o`2Ioooooooo
01;oool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00D_ooo`03o`2Ioooooooo01;oool0
0`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o
03?o0008<ol000<0003oooooool0Zoooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o0008
<ol000<0003oooooool0Zoooo`00D_ooo`03o`2Ioooooooo01;oool00`0003?o03?o0008<ol000<0
003oooooool0Zoooo`00D_ooo`03o`2Ioooooooo01;oool200002C?o00030000oooooooo0:_oool0
05;oool00ol0VOooooooo`0Boooo00<0000co`0co`0023?o00030000oooooooo0:_oool005;oool0
0ol0VOooooooo`0Boooo00<0000co`0co`0023?o00030000oooooooo0:_oool005;oool00ol0VOoo
ooooo`0Boooo00<0000co`0co`001c?o00030000oooooooo0:coool005;oool00ol0VOooooooo`0B
oooo00<0000co`0co`001c?o00030000oooooooo0:coool005;oool00ol0VOooooooo`0Boooo00<0
000co`0co`001c?o00030000oooooooo0:coool005;oool00ol0VOooooooo`0Boooo0P0000Pco`00
0`000?ooooooo`2/oooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000Lco`000`000?oo
ooooo`2/oooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo001Boooo00?o09Woooooool04_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001B
oooo00?o09Woooooool04_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Boooo00?o
09Woooooool03?ooo`<00003oooo00<0000co`0co`001c?o00030000oooooooo0:coool005;oool0
0ol0VOooooooo`0=oooo00<0003oooooool00_ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/
oooo001Boooo00?o09Woooooool02_ooo`D00003oooo0P0000Pco`000`000?ooooooo`2/oooo001O
oooo00@0003oooooool00004oooo2S?o0:ooool0063oool00`000?ooo`000004oooo2S?o0:ooool0
067oool200001?ooo`Xco`2_oooo001Woooo2C?o0;3oool006Ooool9<ol0/?ooo`00Ioooo`Tco`06
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool006Ooool9<ol01Oooo`030000oooooooo
00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000?oool400000_ooo`<00004
oooo00<0003oooooool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool00`000?oo
ooooo`03oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00Ioooo`Tco`04oooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Woool00`000?ooooooo`02
oooo00@0003oooooool00004oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0003ooooo
ool01@0001;oool010000?ooooooo`0000[oool010000?ooooooooooo`<00004oooo00<0003ooooo
ool0MOooo`00Ioooo`Tco`05oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`030000oooooooo00?oool00`000?ooooooo`1eoooo001Woooo2C?o
00Koool00`000?ooooooo`0Goooo0P0000[oool200001?ooo`<00002oooo00<0003oooooool0M_oo
o`00Ioooo`Tco`2`oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.24) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.25127 .12361 L
.25666 .12361 L
.26171 .12361 L
.26301 .12361 L
.26425 .12361 L
.26493 .12361 L
s
.26493 .12361 m
.26523 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.24) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool01@000?ooooooooooool0V@03oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0
000co`0co`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0U
oooo00<0003oooooool04_ooo`03o`2Ioooooooo017oool00`0003?o03?o000U<ol000<0000co`0c
o`0093?o0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool005?oool00ol0VOoo
ooooo`0Aoooo00<0000co`0co`00Ac?o00D0001Zoooo001Coooo00?o09Woooooool04Oooo`030000
<ol0<ol0048co`050000Koooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000m<ol01@00
07Coool005?oool00ol0VOooooooo`0Aoooo00<0000co`0co`00>C?o00@0001ioooo001Coooo00?o
09Woooooool04Oooo`80000h<ol00P0007goool005?oool00ol0VOooooooo`0Aoooo00<0000co`0c
o`00=C?o0080001ooooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol003<co`020000POoo
o`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000a<ol00P0008?oool005?oool00ol0VOoo
ooooo`0Aoooo00<0000co`0co`00<3?o00030000oooooooo08?oool005?oool00ol0VOooooooo`0A
oooo00<0000co`0co`00;S?o00800026oooo001Coooo00?o09Woooooool04Oooo`80000]<ol00P00
08Soool005?oool00ol0VOooooooo`0Aoooo00<0000co`0co`00:c?o00030000oooooooo08Soool0
05?oool00ol0VOooooooo`0Aoooo00<0000co`0co`00:S?o00030000oooooooo08Woool005?oool0
0ol0VOooooooo`0Aoooo00<0000co`0co`00:C?o00030000oooooooo08[oool005?oool00ol0VOoo
ooooo`0Aoooo00<0000co`0co`00:3?o00030000oooooooo08_oool005?oool00ol0VOooooooo`0A
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool005?oool00ol0VOooooooo`0Aoooo0P00
02Pco`000`000?ooooooo`2<oooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol002Hco`00
0`000?ooooooo`2=oooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol002Dco`000`000?oo
ooooo`2>oooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol002@co`000`000?ooooooo`2?
oooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001C
oooo00?o09Woooooool04Oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001Coooo00?o
09Woooooool04Oooo`80000S<ol000<0003oooooool0TOooo`00Doooo`03o`2Ioooooooo017oool0
0`0003?o03?o000Q<ol000<0003oooooool0T_ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o
03?o000P<ol000<0003oooooool0Toooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000O<ol000<0
003oooooool0U?ooo`00Doooo`03o`2Ioooooooo00Woool500000oooo`030000<ol0<ol001lco`00
0`000?ooooooo`2Doooo001Coooo00?o09Woooooool02oooo`030000oooooooo00?oool00`0003?o
03?o000N<ol000<0003oooooool0UOooo`00Doooo`03o`2Ioooooooo00_oool00`000?ooooooo`03
oooo0P0001lco`000`000?ooooooo`2Eoooo001Coooo00?o09Woooooool02oooo`030000oooooooo
00?oool00`0003?o03?o000M<ol000<0003oooooool0U_ooo`00Doooo`03o`2Ioooooooo00_oool0
0`000?ooooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool005?oool00ol0VOoo
ooooo`0:oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00Doooo`03o`2I
oooooooo017oool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00Doooo`03o`2Ioooooooo
017oool00`0003?o03?o000K<ol000<0003oooooool0V?ooo`00Doooo`03o`2Ioooooooo017oool2
000073?o00030000oooooooo09Soool005?oool00ol0VOooooooo`0Aoooo00<0000co`0co`006S?o
00030000oooooooo09Woool005?oool00ol0VOooooooo`0Aoooo00<0000co`0co`006S?o00030000
oooooooo09Woool005?oool00ol0VOooooooo`0Aoooo00<0000co`0co`006C?o00030000oooooooo
09[oool005?oool00ol0VOooooooo`0Aoooo00<0000co`0co`006C?o00030000oooooooo09[oool0
05?oool00ol0VOooooooo`0Aoooo00<0000co`0co`0063?o00030000oooooooo09_oool005?oool0
0ol0VOooooooo`0Aoooo0P0001Tco`000`000?ooooooo`2Koooo001Coooo00?o09Woooooool04Ooo
o`030000<ol0<ol001Lco`000`000?ooooooo`2Loooo001Coooo00?o09Woooooool04Oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol0
01Hco`000`000?ooooooo`2Moooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol001Dco`000`000?ooooooo`2N
oooo001Coooo00?o09Woooooool04Oooo`80000F<ol000<0003oooooool0W_ooo`00Doooo`03o`2I
oooooooo017oool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00Doooo`03o`2Ioooooooo
017oool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00Doooo`03o`2Ioooooooo017oool0
0`0003?o03?o000D<ol000<0003oooooool0Woooo`00Doooo`03o`2Ioooooooo017oool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00Doooo`03o`2Ioooooooo017oool200005C?o00030000oooooooo
09ooool005?oool00ol0VOooooooo`0Aoooo00<0000co`0co`004c?o00030000oooooooo0:3oool0
05?oool00ol0VOooooooo`0Aoooo00<0000co`0co`004c?o00030000oooooooo0:3oool005?oool0
0ol0VOooooooo`0Aoooo00<0000co`0co`004c?o00030000oooooooo0:3oool005?oool00ol0VOoo
ooooo`09oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00Doooo`03o`2I
oooooooo00Woool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool0
05?oool00ol0VOooooooo`0:oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOoo
o`00Doooo`03o`2Ioooooooo00_oool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000
oooooooo0:7oool005?oool00ol0VOooooooo`09oooo00@0003oooooool00004oooo00<0000co`0c
o`004C?o00030000oooooooo0:;oool005?oool00ol0VOooooooo`0:oooo0P0000Goool00`0003?o
03?o000A<ol000<0003oooooool0X_ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00Doooo`03o`2Ioooooooo017oool200004C?o00030000oooooooo0:?oool0
05?oool00ol0VOooooooo`0Aoooo00<0000co`0co`0043?o00030000oooooooo0:?oool005?oool0
0ol0VOooooooo`0Aoooo00<0000co`0co`0043?o00030000oooooooo0:?oool005?oool00ol0VOoo
ooooo`0Aoooo00<0000co`0co`0043?o00030000oooooooo0:?oool005?oool00ol0VOooooooo`0A
oooo00<0000co`0co`003c?o00030000oooooooo0:Coool005?oool00ol0VOooooooo`0Aoooo00<0
000co`0co`003c?o00030000oooooooo0:Coool005?oool00ol0VOooooooo`0Aoooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool005?oool00ol0VOooooooo`0Aoooo0P00010co`000`000?oo
ooooo`2Toooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol000hco`000`000?ooooooo`2U
oooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001C
oooo00?o09Woooooool04Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Coooo00?o
09Woooooool04Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Coooo00?o09Wooooo
ool04Oooo`030000<ol0<ol000dco`000`000?ooooooo`2Voooo001Coooo00?o09Woooooool04Ooo
o`80000><ol000<0003oooooool0Y_ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000=
<ol000<0003oooooool0Y_ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000<<ol000<0003ooooo
ool0Yoooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00Dooo
o`03o`2Ioooooooo017oool200003C?o00030000oooooooo0:Ooool005?oool00ol0VOooooooo`0A
oooo00<0000co`0co`0033?o00030000oooooooo0:Ooool005?oool00ol0VOooooooo`0Aoooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool005?oool00ol0VOooooooo`0Aoooo00<0000co`0c
o`002c?o00030000oooooooo0:Soool005?oool00ol0VOooooooo`0:oooo0P0000Goool00`0003?o
03?o000;<ol000<0003oooooool0Z?ooo`00Doooo`03o`2Ioooooooo00Woool010000?ooooooo`00
00Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Doooo`03o`2Ioooooooo00_oool0
0`000?ooooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo001Coooo00?o09Woooooool03?oo
o`030000oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Doooo`03o`2I
oooooooo00Woool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?oo
o`00Doooo`03o`2Ioooooooo00[oool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Y
oooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001C
oooo00?o09Woooooool04Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Coooo00?o
09Woooooool04Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Coooo00?o09Wooooo
ool04Oooo`80000;<ol000<0003oooooool0ZOooo`00Doooo`03o`2Ioooooooo017oool00`0003?o
03?o000:<ol000<0003oooooool0ZOooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o0009
<ol000<0003oooooool0Z_ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00Doooo`03o`2Ioooooooo017oool200002S?o00030000oooooooo0:[oool005?oool00ol0VOoo
ooooo`0Aoooo00<0000co`0co`002C?o00030000oooooooo0:[oool005?oool00ol0VOooooooo`0A
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool005?oool00ol0VOooooooo`0Aoooo00<0
000co`0co`0023?o00030000oooooooo0:_oool005?oool00ol0VOooooooo`0Aoooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool005?oool00ol0VOooooooo`0Aoooo00<0000co`0co`0023?o
00030000oooooooo0:_oool005?oool00ol0VOooooooo`0Aoooo0P0000Tco`000`000?ooooooo`2[
oooo001Coooo00?o09Woooooool04Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001C
oooo00?o09Woooooool04Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001Coooo00?o
09Woooooool04Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Coooo00?o09Wooooo
ool04Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Coooo00?o09Woooooool04Ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Coooo00?o09Woooooool04Oooo`800008
<ol000<0003oooooool0[?ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o0007<ol000<0
003oooooool0[?ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00Doooo`03o`2Ioooooooo017oool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00Dooo
o`03o`2Ioooooooo00_oool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001C
oooo00?o09Woooooool03?ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00Doooo`03o`2Ioooooooo00Woool500000oooo`800008<ol000<0003oooooool0[?oo
o`00Goooo`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_
oooo001Qoooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9
<ol01_ooo`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?oo
ooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo100000Coool3
00000_ooo`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00<0
003oooooool01_ooo`050000oooooooooooo000007Ooool006Ooool9<ol01?ooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool00009oooo00<0003oooooool00_ooo`D00003
oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00D0003oooooooooool00000Moooo`00Iooo
o`Tco`05oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooo000000?oool00`000?ooooooo`1eoooo001Woooo2C?o00Koool00`000?oo
ooooo`0Goooo0P0000[oool200001Oooo`800002oooo00<0003oooooool0M_ooo`00Ioooo`Tco`2`
oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.22) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.25127 .12361 L
.26171 .12361 L
.26698 .12361 L
.26843 .12361 L
.26922 .12361 L
.26998 .12361 L
.27068 .12361 L
s
.27068 .12361 m
.27099 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.22) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`03oooo00?o09Woool000001oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool05?ooo`03o`2Ioooooooo00ooool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool005Goool00ol0VOooooooo`0?
oooo00<0000co`0co`00Ac?o00D0001Zoooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol0
048co`050000Koooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000m<ol01@0007Coool0
05Goool00ol0VOooooooo`0?oooo00<0000co`0co`00>C?o00@0001ioooo001Eoooo00?o09Wooooo
ool03oooo`80000h<ol00P0007goool005Goool00ol0VOooooooo`0?oooo00<0000co`0co`00=C?o
0080001ooooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol003<co`020000POooo`00EOoo
o`03o`2Ioooooooo00ooool00`0003?o03?o000a<ol00P0008?oool005Goool00ol0VOooooooo`0?
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool005Goool00ol0VOooooooo`0?oooo00<0
000co`0co`00;S?o00800026oooo001Eoooo00?o09Woooooool03oooo`80000]<ol00P0008Soool0
05Goool00ol0VOooooooo`0?oooo00<0000co`0co`00:c?o00030000oooooooo08Soool005Goool0
0ol0VOooooooo`0?oooo00<0000co`0co`00:S?o00030000oooooooo08Woool005Goool00ol0VOoo
ooooo`0?oooo00<0000co`0co`00:C?o00030000oooooooo08[oool005Goool00ol0VOooooooo`0?
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool005Goool00ol0VOooooooo`0?oooo00<0
000co`0co`00:3?o00030000oooooooo08_oool005Goool00ol0VOooooooo`0?oooo0P0002Pco`00
0`000?ooooooo`2<oooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo001E
oooo00?o09Woooooool03oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001Eoooo00?o
09Woooooool03oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001Eoooo00?o09Wooooo
ool03oooo`80000S<ol000<0003oooooool0TOooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00EOooo`03o`2Ioooooooo00Ooool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo001Eoooo00?o09Woooooool02Oooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00EOooo`03o`2Ioooooooo00Woool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo001Eoooo00?o09Woooooool02Oooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00EOooo`03o`2Ioooooooo00Woool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool005Goool00ol0VOooooooo`08
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00EOooo`03o`2Ioooooooo
00ooool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00EOooo`03o`2Ioooooooo00ooool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00EOooo`03o`2Ioooooooo00ooool2000073?o
00030000oooooooo09Soool005Goool00ol0VOooooooo`0?oooo00<0000co`0co`006S?o00030000
oooooooo09Woool005Goool00ol0VOooooooo`0?oooo00<0000co`0co`006S?o00030000oooooooo
09Woool005Goool00ol0VOooooooo`0?oooo00<0000co`0co`006C?o00030000oooooooo09[oool0
05Goool00ol0VOooooooo`0?oooo00<0000co`0co`006C?o00030000oooooooo09[oool005Goool0
0ol0VOooooooo`0?oooo00<0000co`0co`0063?o00030000oooooooo09_oool005Goool00ol0VOoo
ooooo`0?oooo0P0001Tco`000`000?ooooooo`2Koooo001Eoooo00?o09Woooooool03oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001E
oooo00?o09Woooooool03oooo`80000F<ol000<0003oooooool0W_ooo`00EOooo`03o`2Ioooooooo
00ooool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00EOooo`03o`2Ioooooooo00ooool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00EOooo`03o`2Ioooooooo00ooool200005C?o00030000oooooooo09ooool0
05Goool00ol0VOooooooo`0?oooo00<0000co`0co`004c?o00030000oooooooo0:3oool005Goool0
0ol0VOooooooo`0?oooo00<0000co`0co`004c?o00030000oooooooo0:3oool005Goool00ol0VOoo
ooooo`0?oooo00<0000co`0co`004c?o00030000oooooooo0:3oool005Goool00ol0VOooooooo`07
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00EOooo`03o`2Ioooooooo
00Ooool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool005Goool0
0ol0VOooooooo`08oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00EOoo
o`03o`2Ioooooooo00Woool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool005Goool00ol0VOooooooo`07oooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool005Goool00ol0VOooooooo`08oooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00EOooo`03o`2Ioooooooo00ooool200004C?o00030000oooooooo0:?oool005Goool0
0ol0VOooooooo`0?oooo00<0000co`0co`0043?o00030000oooooooo0:?oool005Goool00ol0VOoo
ooooo`0?oooo00<0000co`0co`0043?o00030000oooooooo0:?oool005Goool00ol0VOooooooo`0?
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool005Goool00ol0VOooooooo`0?oooo00<0
000co`0co`003c?o00030000oooooooo0:Coool005Goool00ol0VOooooooo`0?oooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool005Goool00ol0VOooooooo`0?oooo00<0000co`0co`003c?o
00030000oooooooo0:Coool005Goool00ol0VOooooooo`0?oooo0P00010co`000`000?ooooooo`2T
oooo001Eoooo00?o09Woooooool03oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001E
oooo00?o09Woooooool03oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Eoooo00?o
09Woooooool03oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Eoooo00?o09Wooooo
ool03oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Eoooo00?o09Woooooool03ooo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo001Eoooo00?o09Woooooool03oooo`80000>
<ol000<0003oooooool0Y_ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00EOoo
o`03o`2Ioooooooo00ooool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00EOooo`03o`2I
oooooooo00ooool200003C?o00030000oooooooo0:Ooool005Goool00ol0VOooooooo`0?oooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool005Goool00ol0VOooooooo`0?oooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool005Goool00ol0VOooooooo`0?oooo00<0000co`0co`002c?o
00030000oooooooo0:Soool005Goool00ol0VOooooooo`08oooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00EOooo`03o`2Ioooooooo00Ooool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00EOooo`03o`2Ioooooooo00Woool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo001Eoooo00?o09Woooooool02_ooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00EOooo`03o`2Ioooooooo
00Ooool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00EOoo
o`03o`2Ioooooooo00Soool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001E
oooo00?o09Woooooool03oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Eoooo00?o
09Woooooool03oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Eoooo00?o09Wooooo
ool03oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Eoooo00?o09Woooooool03ooo
o`80000;<ol000<0003oooooool0ZOooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00EOoo
o`03o`2Ioooooooo00ooool200002S?o00030000oooooooo0:[oool005Goool00ol0VOooooooo`0?
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool005Goool00ol0VOooooooo`0?oooo00<0
000co`0co`002C?o00030000oooooooo0:[oool005Goool00ol0VOooooooo`0?oooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool005Goool00ol0VOooooooo`0?oooo00<0000co`0co`0023?o
00030000oooooooo0:_oool005Goool00ol0VOooooooo`0?oooo00<0000co`0co`0023?o00030000
oooooooo0:_oool005Goool00ol0VOooooooo`0?oooo0P0000Tco`000`000?ooooooo`2[oooo001E
oooo00?o09Woooooool03oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001Eoooo00?o
09Woooooool03oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001Eoooo00?o09Wooooo
ool03oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Eoooo00?o09Woooooool03ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Eoooo00?o09Woooooool03oooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo001Eoooo00?o09Woooooool03oooo`800008<ol000<0
003oooooool0[?ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00EOooo`03o`2Ioooooooo00ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00EOoo
o`03o`2Ioooooooo00ooool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00EOooo`03o`2I
oooooooo00Woool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Eoooo00?o
09Woooooool02_ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00EOooo`03o`2Ioooooooo00Ooool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo100000;oool400000ooo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`1eoooo001Woooo2C?o00Coool00`000?oo
ooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002Oooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool0M?ooo`00Ioooo`Tco`05oooo00<0003oooooool01@00
01;oool010000?ooooooo`0000[oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`030000
oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Soool010000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001W
oooo2C?o00Koool00`000?ooooooo`0Goooo0P0000[oool200001?ooo`800003oooo00<0003ooooo
ool0M_ooo`00Ioooo`Tco`2`oooo001Woooo23?o0;7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.26171 .12361 L
.26709 .12361 L
.27279 .12361 L
.27513 .12361 L
.27643 .12361 L
.27765 .12361 L
s
.27765 .12361 m
.27793 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool05_ooo`03o`2Ioooooooo00goool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool005Ooool00ol0VOooooooo`0=
oooo00<0000co`0co`00Ac?o00D0001Zoooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol0
048co`050000Koooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000m<ol01@0007Coool0
05Ooool00ol0VOooooooo`0=oooo00<0000co`0co`00>C?o00@0001ioooo001Goooo00?o09Wooooo
ool03Oooo`80000h<ol00P0007goool005Ooool00ol0VOooooooo`0=oooo00<0000co`0co`00=C?o
0080001ooooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol003<co`020000POooo`00Eooo
o`03o`2Ioooooooo00goool00`0003?o03?o000a<ol00P0008?oool005Ooool00ol0VOooooooo`0=
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool005Ooool00ol0VOooooooo`0=oooo00<0
000co`0co`00;S?o00800026oooo001Goooo00?o09Woooooool03Oooo`80000]<ol00P0008Soool0
05Ooool00ol0VOooooooo`0=oooo00<0000co`0co`00:c?o00030000oooooooo08Soool005Ooool0
0ol0VOooooooo`0=oooo00<0000co`0co`00:S?o00030000oooooooo08Woool005Ooool00ol0VOoo
ooooo`0=oooo00<0000co`0co`00:C?o00030000oooooooo08[oool005Ooool00ol0VOooooooo`0=
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool005Ooool00ol0VOooooooo`0=oooo00<0
000co`0co`00:3?o00030000oooooooo08_oool005Ooool00ol0VOooooooo`0=oooo0P0002Pco`00
0`000?ooooooo`2<oooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo001G
oooo00?o09Woooooool03Oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001Goooo00?o
09Woooooool03Oooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001Goooo00?o09Wooooo
ool03Oooo`80000S<ol000<0003oooooool0TOooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00Eoooo`03o`2Ioooooooo00Goool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo001Goooo00?o09Woooooool01oooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00Eoooo`03o`2Ioooooooo00Ooool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo001Goooo00?o09Woooooool01oooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00Eoooo`03o`2Ioooooooo00Ooool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool005Ooool00ol0VOooooooo`06
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00Eoooo`03o`2Ioooooooo
00goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00Eoooo`03o`2Ioooooooo00goool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00Eoooo`03o`2Ioooooooo00goool2000073?o
00030000oooooooo09Soool005Ooool00ol0VOooooooo`0=oooo00<0000co`0co`006S?o00030000
oooooooo09Woool005Ooool00ol0VOooooooo`0=oooo00<0000co`0co`006S?o00030000oooooooo
09Woool005Ooool00ol0VOooooooo`0=oooo00<0000co`0co`006C?o00030000oooooooo09[oool0
05Ooool00ol0VOooooooo`0=oooo00<0000co`0co`006C?o00030000oooooooo09[oool005Ooool0
0ol0VOooooooo`0=oooo00<0000co`0co`0063?o00030000oooooooo09_oool005Ooool00ol0VOoo
ooooo`0=oooo0P0001Tco`000`000?ooooooo`2Koooo001Goooo00?o09Woooooool03Oooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001G
oooo00?o09Woooooool03Oooo`80000F<ol000<0003oooooool0W_ooo`00Eoooo`03o`2Ioooooooo
00goool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00Eoooo`03o`2Ioooooooo00goool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00Eoooo`03o`2Ioooooooo00goool200005C?o00030000oooooooo09ooool0
05Ooool00ol0VOooooooo`0=oooo00<0000co`0co`004c?o00030000oooooooo0:3oool005Ooool0
0ol0VOooooooo`0=oooo00<0000co`0co`004c?o00030000oooooooo0:3oool005Ooool00ol0VOoo
ooooo`0=oooo00<0000co`0co`004c?o00030000oooooooo0:3oool005Ooool00ol0VOooooooo`05
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00Eoooo`03o`2Ioooooooo
00Goool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool005Ooool0
0ol0VOooooooo`06oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00Eooo
o`03o`2Ioooooooo00Ooool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool005Ooool00ol0VOooooooo`05oooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool005Ooool00ol0VOooooooo`06oooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00Eoooo`03o`2Ioooooooo00goool200004C?o00030000oooooooo0:?oool005Ooool0
0ol0VOooooooo`0=oooo00<0000co`0co`0043?o00030000oooooooo0:?oool005Ooool00ol0VOoo
ooooo`0=oooo00<0000co`0co`0043?o00030000oooooooo0:?oool005Ooool00ol0VOooooooo`0=
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool005Ooool00ol0VOooooooo`0=oooo00<0
000co`0co`003c?o00030000oooooooo0:Coool005Ooool00ol0VOooooooo`0=oooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool005Ooool00ol0VOooooooo`0=oooo00<0000co`0co`003c?o
00030000oooooooo0:Coool005Ooool00ol0VOooooooo`0=oooo0P00010co`000`000?ooooooo`2T
oooo001Goooo00?o09Woooooool03Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001G
oooo00?o09Woooooool03Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Goooo00?o
09Woooooool03Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Goooo00?o09Wooooo
ool03Oooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Goooo00?o09Woooooool03Ooo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo001Goooo00?o09Woooooool03Oooo`80000>
<ol000<0003oooooool0Y_ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00Eooo
o`03o`2Ioooooooo00goool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00Eoooo`03o`2I
oooooooo00goool200003C?o00030000oooooooo0:Ooool005Ooool00ol0VOooooooo`0=oooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool005Ooool00ol0VOooooooo`0=oooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool005Ooool00ol0VOooooooo`0=oooo00<0000co`0co`002c?o
00030000oooooooo0:Soool005Ooool00ol0VOooooooo`06oooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00Eoooo`03o`2Ioooooooo00Goool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Eoooo`03o`2Ioooooooo00Ooool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo001Goooo00?o09Woooooool02?ooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Eoooo`03o`2Ioooooooo
00Goool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00Eooo
o`03o`2Ioooooooo00Koool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001G
oooo00?o09Woooooool03Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Goooo00?o
09Woooooool03Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Goooo00?o09Wooooo
ool03Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Goooo00?o09Woooooool03Ooo
o`80000;<ol000<0003oooooool0ZOooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00Eooo
o`03o`2Ioooooooo00goool200002S?o00030000oooooooo0:[oool005Ooool00ol0VOooooooo`0=
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool005Ooool00ol0VOooooooo`0=oooo00<0
000co`0co`002C?o00030000oooooooo0:[oool005Ooool00ol0VOooooooo`0=oooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool005Ooool00ol0VOooooooo`0=oooo00<0000co`0co`0023?o
00030000oooooooo0:_oool005Ooool00ol0VOooooooo`0=oooo00<0000co`0co`0023?o00030000
oooooooo0:_oool005Ooool00ol0VOooooooo`0=oooo0P0000Tco`000`000?ooooooo`2[oooo001G
oooo00?o09Woooooool03Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001Goooo00?o
09Woooooool03Oooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001Goooo00?o09Wooooo
ool03Oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Goooo00?o09Woooooool03Ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Goooo00?o09Woooooool03Oooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo001Goooo00?o09Woooooool03Oooo`800008<ol000<0
003oooooool0[?ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00Eoooo`03o`2Ioooooooo00goool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00Eooo
o`03o`2Ioooooooo00goool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00Eoooo`03o`2I
oooooooo00Ooool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Goooo00?o
09Woooooool02?ooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00Eoooo`03o`2Ioooooooo00Goool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol02Ooo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001Woooo2C?o00Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool006Ooool9<ol02?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo100000?oool00`000?oo
ooooo`1hoooo001Woooo2C?o00Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`030000oooooooo00Coool0
0`000?ooooooo`1hoooo001Woooo2C?o00Ooool00`000?ooooooo`02oooo00<0003oooooool04ooo
o`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`1goooo001Woooo2C?o
00Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool0
0`000?ooooooo`1hoooo001Woooo2C?o00Soool01@000?ooooooooooo`00000Eoooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Ioooo`Tco`09oooo00<0
003oooooool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1ioooo001Woooo2C?o0;3oool0
06Ooool8<ol0/Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.18) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 1.10126 L
.34309 1.07923 L
.36276 .79311 L
.37376 .67763 L
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34132 .61803 L
s
.38073 .61803 m
.38373 .59243 L
.40298 .46673 L
.41382 .41276 L
.4238 .37124 L
.44262 .3094 L
.46328 .25997 L
.48279 .22587 L
.50371 .19899 L
.52495 .17907 L
.54507 .16515 L
.56498 .15486 L
.5834 .14765 L
.60206 .14205 L
.62267 .13738 L
.64201 .13408 L
.66287 .1314 L
.68291 .12948 L
.70401 .12797 L
.72375 .12691 L
.74212 .12615 L
.76257 .12552 L
.78116 .12508 L
.80035 .12473 L
.82114 .12444 L
.84102 .12424 L
.86206 .12408 L
.88164 .12396 L
.89995 .12388 L
.92024 .12381 L
.93877 .12377 L
.95668 .12373 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.27731 .12361 L
.28025 .12361 L
.2817 .12361 L
.28302 .12361 L
s
.28302 .12361 m
.28351 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .37082 m
.34752 .37082 L
s
[(2)] .32877 .37082 1 0 Mshowa
.34127 .49443 m
.34752 .49443 L
s
[(3)] .32877 .49443 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(4)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .02472 m
.34502 .02472 L
s
.34127 .04944 m
.34502 .04944 L
s
.34127 .07416 m
.34502 .07416 L
s
.34127 .09889 m
.34502 .09889 L
s
.34127 .14833 m
.34502 .14833 L
s
.34127 .17305 m
.34502 .17305 L
s
.34127 .19777 m
.34502 .19777 L
s
.34127 .22249 m
.34502 .22249 L
s
.34127 .27193 m
.34502 .27193 L
s
.34127 .29666 m
.34502 .29666 L
s
.34127 .32138 m
.34502 .32138 L
s
.34127 .3461 m
.34502 .3461 L
s
.34127 .39554 m
.34502 .39554 L
s
.34127 .42026 m
.34502 .42026 L
s
.34127 .44498 m
.34502 .44498 L
s
.34127 .46971 m
.34502 .46971 L
s
.34127 .51915 m
.34502 .51915 L
s
.34127 .54387 m
.34502 .54387 L
s
.34127 .56859 m
.34502 .56859 L
s
.34127 .59331 m
.34502 .59331 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.18) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_oo
o`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`005oooo`D0000Noooo0P0000Coool2
00001?ooo`80000Ooooo00<0003oooooool07_ooo`800004oooo0P0000Coool200007oooo`D0000M
oooo1@0000;oool200001?ooo`80000Poooo100001Koool001Woool00`000?ooooooo`0Moooo00@0
003oooooool00008oooo00@0003oooooool0000Noooo00<0003oooooool07Oooo`040000oooooooo
00002?ooo`040000oooooooo00008?ooo`030000oooooooo01ooool00`000?ooooooo`07oooo00@0
003oooooool0000Ooooo00<0003oooooool05oooo`006Oooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Loooo00<0003oooooool07Oooo`040000oooooooo00002ooo
o`030000oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool02_ooo`030000oooooooo
01koool00`000?ooooooo`0Foooo000Aoooo100000Coool00`000?ooooooo`0Goooo100000;oool0
10000?ooooooo`0000Woool200007oooo`030000oooooooo01goool010000?ooooooo`0000Woool2
00008Oooo`030000oooooooo01ooool00`000?ooooooo`08oooo0P0002;oool00`000?ooooooo`0E
oooo000Ioooo00<0003oooooool07Oooo`040000oooooooo00002Oooo`030000oooooooo01koool0
0`000?ooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool08?ooo`030000oooooooo
01ooool00`000?ooooooo`08oooo00<0003oooooool07oooo`040000oooooooo00005_ooo`006?oo
o`80000Poooo0P0000[oool300007_ooo`80000Ooooo0P0000[oool300007oooo`80000Poooo0P00
00[oool300008?ooo`80000Goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000
oooooooo0;Koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003o09Woool01Oooo`030000
oooooooo00Goool00`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005
<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0c
o`001C?o00030000<ol0<ol000@co`0X00000_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0
003oooooool05oooo`03o`2Ioooooooo00coool00`0003?o03?o000U<ol000<0000co`0co`0093?o
0100000Ioooo00<0003oooooool09_ooo`030000oooooooo01Goool005Soool00ol0VOooooooo`0<
oooo00<0000co`0co`00Ac?o00D0001Zoooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol0
048co`050000Koooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000m<ol01@0007Coool0
05Soool00ol0VOooooooo`0<oooo00<0000co`0co`00>C?o00@0001ioooo001Hoooo00?o09Wooooo
ool03?ooo`80000h<ol00P0007goool005Soool00ol0VOooooooo`0<oooo00<0000co`0co`00=C?o
0080001ooooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol003<co`020000POooo`00F?oo
o`03o`2Ioooooooo00coool00`0003?o03?o000a<ol00P0008?oool005Soool00ol0VOooooooo`0<
oooo00<0000co`0co`00<3?o00030000oooooooo08?oool005Soool00ol0VOooooooo`0<oooo00<0
000co`0co`00;S?o00800026oooo001Hoooo00?o09Woooooool03?ooo`80000]<ol00P0008Soool0
05Soool00ol0VOooooooo`0<oooo00<0000co`0co`00:c?o00030000oooooooo08Soool005Soool0
0ol0VOooooooo`0<oooo00<0000co`0co`00:S?o00030000oooooooo08Woool005Soool00ol0VOoo
ooooo`0<oooo00<0000co`0co`00:C?o00030000oooooooo08[oool005Soool00ol0VOooooooo`0<
oooo00<0000co`0co`00:3?o00030000oooooooo08_oool005Soool00ol0VOooooooo`0<oooo00<0
000co`0co`00:3?o00030000oooooooo08_oool005Soool00ol0VOooooooo`0<oooo0P0002Pco`00
0`000?ooooooo`2<oooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol002Hco`000`000?oo
ooooo`2=oooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol002Dco`000`000?ooooooo`2>
oooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol002@co`000`000?ooooooo`2?oooo001H
oooo00?o09Woooooool03?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001Hoooo00?o
09Woooooool03?ooo`030000<ol0<ol002<co`000`000?ooooooo`2@oooo001Hoooo00?o09Wooooo
ool03?ooo`80000S<ol000<0003oooooool0TOooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o
03?o000Q<ol000<0003oooooool0T_ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000P
<ol000<0003oooooool0Toooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000P<ol000<0
003oooooool0Toooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000O<ol000<0003ooooo
ool0U?ooo`00F?ooo`03o`2Ioooooooo00Coool500000oooo`030000<ol0<ol001lco`000`000?oo
ooooo`2Doooo001Hoooo00?o09Woooooool01_ooo`030000oooooooo00?oool00`0003?o03?o000N
<ol000<0003oooooool0UOooo`00F?ooo`03o`2Ioooooooo00Koool00`000?ooooooo`03oooo0P00
01lco`000`000?ooooooo`2Eoooo001Hoooo00?o09Woooooool01_ooo`030000oooooooo00?oool0
0`0003?o03?o000M<ol000<0003oooooool0U_ooo`00F?ooo`03o`2Ioooooooo00Koool00`000?oo
ooooo`03oooo00<0000co`0co`007C?o00030000oooooooo09Koool005Soool00ol0VOooooooo`05
oooo0P0000Goool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00F?ooo`03o`2Ioooooooo
00coool00`0003?o03?o000L<ol000<0003oooooool0Uoooo`00F?ooo`03o`2Ioooooooo00coool0
0`0003?o03?o000K<ol000<0003oooooool0V?ooo`00F?ooo`03o`2Ioooooooo00coool2000073?o
00030000oooooooo09Soool005Soool00ol0VOooooooo`0<oooo00<0000co`0co`006S?o00030000
oooooooo09Woool005Soool00ol0VOooooooo`0<oooo00<0000co`0co`006S?o00030000oooooooo
09Woool005Soool00ol0VOooooooo`0<oooo00<0000co`0co`006C?o00030000oooooooo09[oool0
05Soool00ol0VOooooooo`0<oooo00<0000co`0co`006C?o00030000oooooooo09[oool005Soool0
0ol0VOooooooo`0<oooo00<0000co`0co`0063?o00030000oooooooo09_oool005Soool00ol0VOoo
ooooo`0<oooo0P0001Tco`000`000?ooooooo`2Koooo001Hoooo00?o09Woooooool03?ooo`030000
<ol0<ol001Lco`000`000?ooooooo`2Loooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol0
01Lco`000`000?ooooooo`2Loooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol001Hco`00
0`000?ooooooo`2Moooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol001Hco`000`000?oo
ooooo`2Moooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol001Hco`000`000?ooooooo`2M
oooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol001Dco`000`000?ooooooo`2Noooo001H
oooo00?o09Woooooool03?ooo`80000F<ol000<0003oooooool0W_ooo`00F?ooo`03o`2Ioooooooo
00coool00`0003?o03?o000E<ol000<0003oooooool0W_ooo`00F?ooo`03o`2Ioooooooo00coool0
0`0003?o03?o000E<ol000<0003oooooool0W_ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o
03?o000D<ol000<0003oooooool0Woooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000D
<ol000<0003oooooool0Woooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000D<ol000<0
003oooooool0Woooo`00F?ooo`03o`2Ioooooooo00coool200005C?o00030000oooooooo09ooool0
05Soool00ol0VOooooooo`0<oooo00<0000co`0co`004c?o00030000oooooooo0:3oool005Soool0
0ol0VOooooooo`0<oooo00<0000co`0co`004c?o00030000oooooooo0:3oool005Soool00ol0VOoo
ooooo`0<oooo00<0000co`0co`004c?o00030000oooooooo0:3oool005Soool00ol0VOooooooo`04
oooo100000Coool00`0003?o03?o000C<ol000<0003oooooool0X?ooo`00F?ooo`03o`2Ioooooooo
00Coool00`000?ooooooo`05oooo00<0000co`0co`004S?o00030000oooooooo0:7oool005Soool0
0ol0VOooooooo`05oooo00<0003oooooool01?ooo`80000C<ol000<0003oooooool0XOooo`00F?oo
o`03o`2Ioooooooo00Koool00`000?ooooooo`03oooo00<0000co`0co`004S?o00030000oooooooo
0:7oool005Soool00ol0VOooooooo`04oooo00@0003oooooool00004oooo00<0000co`0co`004C?o
00030000oooooooo0:;oool005Soool00ol0VOooooooo`05oooo0P0000Goool00`0003?o03?o000A
<ol000<0003oooooool0X_ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000A<ol000<0
003oooooool0X_ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000A<ol000<0003ooooo
ool0X_ooo`00F?ooo`03o`2Ioooooooo00coool200004C?o00030000oooooooo0:?oool005Soool0
0ol0VOooooooo`0<oooo00<0000co`0co`0043?o00030000oooooooo0:?oool005Soool00ol0VOoo
ooooo`0<oooo00<0000co`0co`0043?o00030000oooooooo0:?oool005Soool00ol0VOooooooo`0<
oooo00<0000co`0co`0043?o00030000oooooooo0:?oool005Soool00ol0VOooooooo`0<oooo00<0
000co`0co`003c?o00030000oooooooo0:Coool005Soool00ol0VOooooooo`0<oooo00<0000co`0c
o`003c?o00030000oooooooo0:Coool005Soool00ol0VOooooooo`0<oooo00<0000co`0co`003c?o
00030000oooooooo0:Coool005Soool00ol0VOooooooo`0<oooo0P00010co`000`000?ooooooo`2T
oooo001Hoooo00?o09Woooooool03?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001H
oooo00?o09Woooooool03?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Hoooo00?o
09Woooooool03?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Hoooo00?o09Wooooo
ool03?ooo`030000<ol0<ol000hco`000`000?ooooooo`2Uoooo001Hoooo00?o09Woooooool03?oo
o`030000<ol0<ol000dco`000`000?ooooooo`2Voooo001Hoooo00?o09Woooooool03?ooo`80000>
<ol000<0003oooooool0Y_ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000=<ol000<0
003oooooool0Y_ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000=<ol000<0003ooooo
ool0Y_ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000<<ol000<0003oooooool0Yooo
o`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00F?oo
o`03o`2Ioooooooo00coool00`0003?o03?o000<<ol000<0003oooooool0Yoooo`00F?ooo`03o`2I
oooooooo00coool200003C?o00030000oooooooo0:Ooool005Soool00ol0VOooooooo`0<oooo00<0
000co`0co`0033?o00030000oooooooo0:Ooool005Soool00ol0VOooooooo`0<oooo00<0000co`0c
o`0033?o00030000oooooooo0:Ooool005Soool00ol0VOooooooo`0<oooo00<0000co`0co`002c?o
00030000oooooooo0:Soool005Soool00ol0VOooooooo`05oooo0P0000Goool00`0003?o03?o000;
<ol000<0003oooooool0Z?ooo`00F?ooo`03o`2Ioooooooo00Coool010000?ooooooo`0000Coool0
0`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00F?ooo`03o`2Ioooooooo00Koool00`000?oo
ooooo`03oooo0P0000`co`000`000?ooooooo`2Xoooo001Hoooo00?o09Woooooool01oooo`030000
oooooooo00;oool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00F?ooo`03o`2Ioooooooo
00Coool010000?ooooooo`0000Coool00`0003?o03?o000;<ol000<0003oooooool0Z?ooo`00F?oo
o`03o`2Ioooooooo00Goool200001Oooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001H
oooo00?o09Woooooool03?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Hoooo00?o
09Woooooool03?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Hoooo00?o09Wooooo
ool03?ooo`030000<ol0<ol000Xco`000`000?ooooooo`2Yoooo001Hoooo00?o09Woooooool03?oo
o`80000;<ol000<0003oooooool0ZOooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o000:
<ol000<0003oooooool0ZOooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o0009<ol000<0
003oooooool0Z_ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o0009<ol000<0003ooooo
ool0Z_ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o0009<ol000<0003oooooool0Z_oo
o`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o0009<ol000<0003oooooool0Z_ooo`00F?oo
o`03o`2Ioooooooo00coool200002S?o00030000oooooooo0:[oool005Soool00ol0VOooooooo`0<
oooo00<0000co`0co`002C?o00030000oooooooo0:[oool005Soool00ol0VOooooooo`0<oooo00<0
000co`0co`002C?o00030000oooooooo0:[oool005Soool00ol0VOooooooo`0<oooo00<0000co`0c
o`0023?o00030000oooooooo0:_oool005Soool00ol0VOooooooo`0<oooo00<0000co`0co`0023?o
00030000oooooooo0:_oool005Soool00ol0VOooooooo`0<oooo00<0000co`0co`0023?o00030000
oooooooo0:_oool005Soool00ol0VOooooooo`0<oooo0P0000Tco`000`000?ooooooo`2[oooo001H
oooo00?o09Woooooool03?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001Hoooo00?o
09Woooooool03?ooo`030000<ol0<ol000Pco`000`000?ooooooo`2[oooo001Hoooo00?o09Wooooo
ool03?ooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Hoooo00?o09Woooooool03?oo
o`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Hoooo00?o09Woooooool03?ooo`030000
<ol0<ol000Lco`000`000?ooooooo`2/oooo001Hoooo00?o09Woooooool03?ooo`800008<ol000<0
003oooooool0[?ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o0007<ol000<0003ooooo
ool0[?ooo`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00F?ooo`03o`2Ioooooooo00coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00F?oo
o`03o`2Ioooooooo00coool00`0003?o03?o0007<ol000<0003oooooool0[?ooo`00F?ooo`03o`2I
oooooooo00Koool300000oooo`030000<ol0<ol000Lco`000`000?ooooooo`2/oooo001Hoooo00?o
09Woooooool01oooo`030000oooooooo00;oool00`0003?o03?o0007<ol000<0003oooooool0[?oo
o`00F?ooo`03o`2Ioooooooo00Coool500000oooo`800008<ol000<0003oooooool0[?ooo`00Gooo
o`040000oooooooo00001?ooo`Xco`2_oooo001Poooo00<0003oool000001?ooo`Xco`2_oooo001Q
oooo0P0000Coool:<ol0[oooo`00Ioooo`Tco`2`oooo001Woooo2C?o0;3oool006Ooool9<ol01_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001Woooo2C?o00Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool006Ooool9<ol01Oooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo1@0000;oool200001?oo
o`030000oooooooo07Goool006Ooool9<ol01Oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool0000:oooo00D0003ooooo
ooooool000000_ooo`050000oooooooooooo000007Ooool006Ooool9<ol01?ooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool0000:oooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`1doooo001Woooo2C?o00Goool00`000?ooooooo`05
00004_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
07Goool006Ooool9<ol01Oooo`050000oooooooooooo000001Goool010000?ooooooo`0000[oool0
1@000?ooooooooooo`000002oooo00D0003oooooooooool00000Moooo`00Ioooo`Tco`06oooo00<0
003oooooool05oooo`80000:oooo0P0000Coool200000oooo`030000oooooooo07Koool006Ooool9
<ol0/?ooo`00Ioooo`Pco`2aoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-1.28237, \
-1.14361, 0.0124234, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-1.28237, -1.14361, 0.0124234, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.18254 .11111 -12 -9 ]
[.18254 .11111 12 0 ]
[.5 .11111 -9 -9 ]
[.5 .11111 9 0 ]
[.65873 .11111 -3 -9 ]
[.65873 .11111 3 0 ]
[.81746 .11111 -9 -9 ]
[.81746 .11111 9 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .24721 -6 -4.5 ]
[.32877 .24721 0 4.5 ]
[.32877 .37082 -6 -4.5 ]
[.32877 .37082 0 4.5 ]
[.32877 .49443 -6 -4.5 ]
[.32877 .49443 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-1)] .02381 .11111 0 1 Mshowa
.18254 .12361 m
.18254 .12986 L
s
[(-0.5)] .18254 .11111 0 1 Mshowa
.5 .12361 m
.5 .12986 L
s
[(0.5)] .5 .11111 0 1 Mshowa
.65873 .12361 m
.65873 .12986 L
s
[(1)] .65873 .11111 0 1 Mshowa
.81746 .12361 m
.81746 .12986 L
s
[(1.5)] .81746 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.05556 .12361 m
.05556 .12736 L
s
.0873 .12361 m
.0873 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.15079 .12361 m
.15079 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.24603 .12361 m
.24603 .12736 L
s
.27778 .12361 m
.27778 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.37302 .12361 m
.37302 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.43651 .12361 m
.43651 .12736 L
s
.46825 .12361 m
.46825 .12736 L
s
.53175 .12361 m
.53175 .12736 L
s
.56349 .12361 m
.56349 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.62698 .12361 m
.62698 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.72222 .12361 m
.72222 .12736 L
s
.75397 .12361 m
.75397 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.84921 .12361 m
.84921 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.9127 .12361 m
.9127 .12736 L
s
.94444 .12361 m
.94444 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .24721 m
.34752 .24721 L
s
[(1)] .32877 .24721 1 0 Mshowa
.34127 .370