(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2167348,      82647]*)
(*NotebookOutlinePosition[   2168092,      82672]*)
(*  CellTagsIndexPosition[   2168048,      82668]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING BEHIND A NEGATIVE DELTA-FUNCTION \
NONHOMOGENEITY", "Text",
  CellFrame->True,
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  v[x]  ",
    FontSize->12],
  StyleBox["is a delta-function of strength  c0, positive or negative, \
located at  x=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  The potential has one bound state if  c0<0  and no bound states \
if  c0>0.\n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" >0, is behind the nonhomogeneity and needs to be specified. ",
    FontSize->12],
  StyleBox["\n\nThe transmission coefficient, left reflection coefficient, \
and right reflection coefficient, respectively, are denoted by  T[k],  L[k],  \
R[k].\n\nThe tail of the wave is denoted by  g[x,t].\n\nThe focusing moment \
is chosen as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(Clear[v, T, L, R, c0, x0, g];\)\), "\[IndentingNewLine]", 
    \(\(v[x_] = \ c0\ \ DiracDelta[x]\ ;\)\), "\n", 
    \(\(T[k_] = k/\((k + I\ \ c0/2)\);\)\), "\n", 
    \(\(L[k_] = \((\(-I\)\ c0/2)\)/\((k + I\ \ c0/2)\);\)\), "\n", 
    \(\(R[k_] = \((\(-I\)\ c0/2)\)/\((k + I\ \ c0/2)\);\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the strength of the potential, c0, a negative number;
also specify the focusing location  x0, a positive number, next:\
\>", "Text",\

  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(c0 = \(-1\)\)\(;\)\(\ \ \)\(\(x0 = 1\) \)\(;\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(\n\)\(g[x_, 
          t_] = \ \(-\ \((c0/2)\)\)\ UnitStep[
              x]\ \ UnitStep[\(-x\) - x0 + 
                t]\ E^\((c0 \((x + x0 - t)\)/2)\) + \((c0/2)\) 
            UnitStep[\(-x\)]\ \((UnitStep[\(-x\) + x0 + t]\  - \ 
                UnitStep[\(-x\) - x0 + t]\  - \ UnitStep[x + x0 + t] + \ 
                UnitStep[x - x0 + t] - \ 
                UnitStep[
                    x - x0 + 
                      t]\ E^\((c0 \((\(-x\) + x0 - t)\)/
                          2)\))\);\)\)\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-4\), \ 
              4}, \ PlotRange -> {\(-1\), 1.5}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-4\), \ 4}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-1\), 
                1.5}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-4\), \ 4}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-1\), 
                1.5}]}, \[IndentingNewLine]\ {t, \ \(-2\), \ 2.9, 0.05}, 
        PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.34309 .24721 L
.36173 .24721 L
.37114 .24721 L
.37372 .24721 L
.37649 .24721 L
.37783 .24721 L
.3791 .24721 L
.38025 .24721 L
s
.38025 .24721 m
.38044 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.08255 .24721 L
.10458 .24721 L
.11448 .24721 L
.12507 .24721 L
.1302 .24721 L
.13506 .24721 L
.13942 .24721 L
.14061 .24721 L
.14188 .24721 L
.14296 .12361 L
.14415 .12361 L
.18444 .12361 L
.22321 .12361 L
.26444 .12361 L
.30414 .12361 L
.34234 .12361 L
.36201 .12361 L
.36767 .12361 L
.37301 .12361 L
.3778 .12361 L
.37911 .12361 L
.37983 .12361 L
.3805 .12361 L
.38168 .24721 L
.38298 .24721 L
.42189 .24721 L
.46325 .24721 L
.5031 .24721 L
.54143 .24721 L
.58221 .24721 L
.62148 .24721 L
.65923 .24721 L
.69943 .24721 L
.73812 .24721 L
.77926 .24721 L
.81888 .24721 L
.85699 .24721 L
.89755 .24721 L
.9366 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00=?oooch0I_l9oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo000doooo00<0I_ooooooool0>_ooo`0406Kooooooooo
oooo100000;oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool003Coool0
0`1Vooooooooo`0joooo00<0I_ooooooool01oooo`040000oooooooo00002Oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Soool2
00002_ooo`<00004oooo00<0003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0Koooo00<0003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0K
oooo00<0003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Koooo00<0
003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Koooo0P0008ooool0
03Coool00`1Vooooooooo`0joooo00<0I_ooooooool06oooo`030000oooooooo08koool003Coool0
0`1Vooooooooo`0joooo00<0I_ooooooool06oooo`030000oooooooo08koool003Coool00`1Voooo
ooooo`0joooo00<0I_ooooooool06oooo`030000oooooooo08koool003Coool00`1Vooooooooo`0j
oooo00<0I_ooooooool06oooo`030000oooooooo08koool003Coool00`1Vooooooooo`0joooo00<0
I_ooooooool06oooo`030000oooooooo08koool003Coool00`1Vooooooooo`0joooo00<0I_oooooo
ool06oooo`80002?oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?oo
ooooo`2>oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>
oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>oooo000d
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>oooo000doooo00<0
I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>oooo000doooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo01_oool20000Soooo`00=?ooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0Koooo00<0003oooooool0S_ooo`006Oooo`<0000Hoooo00<0I_ooooooool07Oooo`@0000I
oooo00<0I_ooooooool06oooo`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0
003oooooool05oooo`0306Kooooooooo01goool00`000?ooooooo`0Joooo00<0I_ooooooool06ooo
o`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003oooooool05?ooo`005oooo`D0000H
oooo00<0I_ooooooool07_ooo`030000oooooooo01Woool00`1Vooooooooo`0Koooo00<0003ooooo
ool0>?ooo`030000oooooooo03Woool500005Oooo`004Oooo`@00002oooo00@0003oooooool0000I
oooo00<0I_ooooooool05oooo`@00004oooo00<0003oooooool06?ooo`0306Kooooooooo01_oool0
0`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000
oooo000001Woool00`1Vooooooooo`0Moooo00@0003oooooool0000Ioooo00<0I_ooooooool06ooo
o`80000hoooo00@0003oooooool0000joooo00<0003oool000005_ooo`006Oooo`80000Ioooo00<0
I_ooooooool07_ooo`80000Joooo00<0I_ooooooool06oooo`030000oooooooo03Soool20000??oo
o`80000Foooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>
oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>oooo000d
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>oooo000doooo00<0
I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>oooo000doooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>oooo000@ooooo`00017oool001Koool0
0`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool05Oooo`00LOooo`03o`2Ioooooooo01_oool00`000?oo
ooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOoo
ooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>
oooo001aoooo00?o09Woooooool06oooo`80002?oooo001aoooo00?o09Woooooool06oooo`030000
oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2I
oooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo
08koool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo
01_oool20000Soooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o
09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0003ooooo
ool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Wooooo
ool06oooo`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_oo
o`00LOooo`03o`2Ioooooooo01_oool20000Soooo`00LOooo`03o`2Ioooooooo01_oool00`000?oo
ooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOoo
ooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>
oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOooooooo`0K
oooo0P0008ooool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2I
oooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo
08koool0077oool00ol0VOooooooo`08oooo0P0000Coool200001?ooo`800005oooo00<0003ooooo
ool0S_ooo`00LOooo`03o`2Ioooooooo00Ooool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool01oooo`040000oooooooo00002ooo
o`030000oooooooo00;oool30000S_ooo`00LOooo`03o`2Ioooooooo00Ooool010000?ooooooo`00
00Woool200001Oooo`030000oooooooo08koool0077oool00ol0VOooooooo`07oooo00@0003ooooo
ool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0077oool00ol0VOooooooo`08
oooo0P0000[oool300001?ooo`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0
003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o
09Woooooool06oooo`80002?oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0
077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool0
0`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool0
0ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?oo
ooooo`2>oooo001aoooo00?o09Woooooool06oooo`80002?oooo001aoooo00?o09Woooooool06ooo
o`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOoo
o`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000
oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2I
oooooooo01_oool20000Soooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001a
oooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0
003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o
09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo0P0008ooool0
077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool0
0`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool0
0ol0VOooooooo`0Coooo1@0000?oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool05Ooo
o`030000oooooooo00?oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool05Oooo`030000
oooooooo00?oool30000S_ooo`00LOooo`03o`2Ioooooooo01Goool00`000?ooooooo`03oooo00<0
003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01Goool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00LOooo`03o`2Ioooooooo01Coool200001Oooo`030000oooooooo08koool0077oool0
0ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?oo
ooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOoo
ooooo`0Koooo0P0008ooool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOoo
o`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000
oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2I
oooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`80002?oooo001a
oooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0
003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o
09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0003ooooo
ool0S_ooo`00LOooo`03o`2Ioooooooo01_oool20000Soooo`00LOooo`03o`2Ioooooooo01_oool0
0`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool0
0ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?oo
ooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOoo
ooooo`0Koooo0P0008ooool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOoo
o`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000
oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2I
oooooooo00Ooool500000_ooo`800004oooo0P0000Goool00`000?ooooooo`2>oooo001aoooo00?o
09Woooooool02Oooo`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`2>
oooo001aoooo00?o09Woooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`02oooo0`00
08koool007goool00`000?ooooooo`08oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0
003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00Oooo
o`030000oooooooo01coool00`000?ooooooo`1ooooo001noooo00<0003oooooool02?ooo`030000
oooooooo01?oool00`000?ooooooo`1noooo001noooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03?ooo`@00003oooo00<0003oooooool0O_ooo`00O_ooo`050000oooooooooooo0000
00;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00<0003oooooool01?oo
o`030000oooooooo07koool007goool00`000?ooooooo`02oooo00<0003oooooool05?ooo`030000
oooooooo00Coool00`000?ooooooo`1moooo001noooo00<0003oooooool01@0001Coool00`000?oo
ooooo`02oooo00<0003oooooool0O_ooo`00O_ooo`050000oooooooooooo000001Goool010000?oo
ooooo`0000?oool00`000?ooooooo`1noooo001ooooo00<0003oooooool05oooo`800003oooo00<0
003oooooool0Ooooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {290.125, 148.813}} -> {-0.349561, \
1.05307, 0.00349883, 0.00566123}, {{79.875, 308.563}, {290.125, 148.813}} -> \
{-8.05779, 1.90119, 0.0331906, 0.0159832}, {{79.875, 308.563}, {290.125, \
148.813}} -> {-8.05779, 1.90119, 0.0331906, 0.0159832}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.36136 .24721 L
.37176 .24721 L
.37685 .24721 L
.3815 .24721 L
.38384 .24721 L
.38508 .24721 L
.3864 .24721 L
s
.3864 .24721 m
.38659 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.12507 .24721 L
.13506 .24721 L
.14415 .24721 L
.14635 .24721 L
.14756 .24721 L
.14868 .24721 L
.1499 .12361 L
.15055 .12361 L
.15124 .12361 L
.1536 .12361 L
.16254 .12361 L
.18221 .12361 L
.22343 .12361 L
.26314 .12361 L
.30133 .12361 L
.34198 .12361 L
.36078 .12361 L
.37066 .12361 L
.38111 .12361 L
.38367 .12361 L
.38509 .12361 L
.38578 .12361 L
.38643 .12361 L
.38718 .24721 L
.388 .24721 L
.38944 .24721 L
.39226 .24721 L
.40252 .24721 L
.42269 .24721 L
.46196 .24721 L
.49971 .24721 L
.53991 .24721 L
.5786 .24721 L
.61974 .24721 L
.65936 .24721 L
.69747 .24721 L
.73803 .24721 L
.77708 .24721 L
.81858 .24721 L
.85856 .24721 L
.89702 .24721 L
.93794 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00=_ooocd0I_l8oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo
00@00002oooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo000foooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00Koool010000?ooooooo`0000Woool00`000?ooooooo`04
oooo00<0003oooooool0S_ooo`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`07oooo0P00
00[oool300001?ooo`030000oooooooo08koool003Koool00`1Vooooooooo`0ioooo00<0I_oooooo
ool06_ooo`030000oooooooo08koool003Koool00`1Vooooooooo`0ioooo00<0I_ooooooool06_oo
o`030000oooooooo08koool003Koool00`1Vooooooooo`0ioooo00<0I_ooooooool06_ooo`030000
oooooooo08koool003Koool00`1Vooooooooo`0ioooo00<0I_ooooooool06_ooo`80002?oooo000f
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo01[oool00`000?ooooooo`2>oooo000foooo00<0
I_ooooooool0>Oooo`0306Kooooooooo01[oool00`000?ooooooo`2>oooo000foooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo01[oool00`000?ooooooo`2>oooo000foooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo01[oool00`000?ooooooo`2>oooo000foooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo01[oool00`000?ooooooo`2>oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo
01[oool20000Soooo`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0003ooooo
ool0S_ooo`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_oo
o`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_oo
o`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_ooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Joooo0P0008ooool003Koool00`1Vooooooooo`0ioooo00<0I_oooooo
ool06_ooo`030000oooooooo08koool001Woool300006_ooo`0306Kooooooooo01_oool400006_oo
o`0306Kooooooooo01[oool00`000?ooooooo`0goooo100003_oool300005Oooo`006_ooo`030000
oooooooo01Woool00`1Vooooooooo`0Koooo00<0003oooooool06oooo`0306Kooooooooo01[oool0
0`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool001Ooool500006_oo
o`0306Kooooooooo01coool00`000?ooooooo`0Joooo00<0I_ooooooool06_ooo`030000oooooooo
03Soool00`000?ooooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo00006ooo
o`0306Kooooooooo01Goool400001?ooo`030000oooooooo01Woool00`1Vooooooooo`0Joooo00<0
003oooooool0>Oooo`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool00`000?oo
o`00000Koooo00<0I_ooooooool06oooo`040000oooooooo00006_ooo`0306Kooooooooo01[oool2
0000>?ooo`040000oooooooo0000>_ooo`030000oooo000001Koool001Woool200006oooo`0306Ko
oooooooo01coool200006oooo`0306Kooooooooo01[oool00`000?ooooooo`0hoooo0P0003coool2
00005_ooo`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_oo
o`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_oo
o`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_ooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`004?ooool0000Aoooo000Foooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003o09Woool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo01Goool007;oool00ol0VOooooooo`0Joooo00<0003ooooo
ool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Wooooo
ool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_oo
o`00L_ooo`03o`2Ioooooooo01[oool20000Soooo`00L_ooo`03o`2Ioooooooo01[oool00`000?oo
ooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOoo
ooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>
oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0J
oooo0P0008ooool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2I
oooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000oooooooo
08koool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo
01[oool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool0
07;oool00ol0VOooooooo`0Joooo0P0008ooool007;oool00ol0VOooooooo`0Joooo00<0003ooooo
ool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Wooooo
ool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_oo
o`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_oo
o`80002?oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOoo
ooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>
oooo001boooo00?o09Woooooool01oooo`800004oooo0P0000Coool200001Oooo`030000oooooooo
08koool007;oool00ol0VOooooooo`06oooo00@0003oooooool00008oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo00Koool010000?ooooooo`0000_oool0
0`000?ooooooo`02oooo0`0008koool007;oool00ol0VOooooooo`06oooo00@0003oooooool00009
oooo0P0000Goool00`000?ooooooo`2>oooo001boooo00?o09Woooooool01_ooo`040000oooooooo
00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001boooo00?o09Woooooool01ooo
o`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000
oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2I
oooooooo01[oool20000Soooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001b
oooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0
003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o
09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003ooooo
ool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool20000Soooo`00L_ooo`03o`2Ioooooooo01[oool0
0`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool0
0ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?oo
ooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOoo
ooooo`0Joooo0P0008ooool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_oo
o`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000
oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2I
oooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`80002?oooo001b
oooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0
003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o
09Woooooool04_ooo`D00003oooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01Coool0
0`000?ooooooo`03oooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`03oooo0`0008koool007;oool00ol0VOooooooo`0Doooo00<0003oooooool00oooo`030000
oooooooo08koool007;oool00ol0VOooooooo`0Doooo00<0003oooooool00oooo`030000oooooooo
08koool007;oool00ol0VOooooooo`0Coooo0P0000Goool00`000?ooooooo`2>oooo001boooo00?o
09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003ooooo
ool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Wooooo
ool06_ooo`80002?oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool0
0ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?oo
ooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOoo
ooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool20000Soooo`00L_oo
o`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000
oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2I
oooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000oooooooo
08koool007;oool00ol0VOooooooo`0Joooo0P0008ooool007;oool00ol0VOooooooo`0Joooo00<0
003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o
09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003ooooo
ool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Wooooo
ool06_ooo`80002?oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool0
0ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?oo
ooooo`2>oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOoo
ooooo`06oooo1@0000;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00L_ooo`03o`2I
oooooooo00Soool00`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_oo
o`00L_ooo`03o`2Ioooooooo00Soool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>
oooo001moooo00<0003oooooool02?ooo`80002Foooo001moooo00<0003oooooool02?ooo`030000
oooooooo09Goool007coool200002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool007Koool0
0`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000oooooooo00Soool00`000?oo
ooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00coool500000_ooo`800003oooo0`0000Coool200001?ooo`030000oooooooo07Goool0
07Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool4
00001Oooo`030000oooooooo00Woool01@000?ooooooooooo`000002oooo00D0003oooooooooool0
0000Moooo`00M?ooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool02?oo
o`<00005oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`05
00005?ooo`030000oooooooo00Ooool010000?ooooooo`0000?oool200001?ooo`030000oooooooo
07Goool007Goool01@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05ooo
o`80000:oooo0`0000?oool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Ooo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.36136 .24721 L
.37176 .24721 L
.3815 .24721 L
.3864 .24721 L
.38881 .24721 L
.39106 .24721 L
.3923 .24721 L
s
.3923 .24721 m
.3924 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.12507 .24721 L
.13506 .24721 L
.14415 .24721 L
.14868 .24721 L
.15107 .24721 L
.15238 .24721 L
.1536 .24721 L
.15467 .24721 L
.15581 .12361 L
.15709 .12361 L
.15825 .12361 L
.16254 .12361 L
.18221 .12361 L
.22192 .12361 L
.26011 .12361 L
.30075 .12361 L
.33988 .12361 L
.35986 .12361 L
.37037 .12361 L
.38147 .12361 L
.38627 .12361 L
.38891 .12361 L
.39141 .12361 L
.3921 .12361 L
.39283 .12361 L
.39363 .24721 L
.39437 .24721 L
.39706 .24721 L
.40233 .24721 L
.42153 .24721 L
.45928 .24721 L
.49949 .24721 L
.53817 .24721 L
.57931 .24721 L
.61894 .24721 L
.65705 .24721 L
.69761 .24721 L
.73665 .24721 L
.77815 .24721 L
.81813 .24721 L
.8566 .24721 L
.89752 .24721 L
.93692 .24721 L
.97481 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00>?ooocd0I_l6oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo000hoooo00<0I_ooooooool0>Oooo`0306Ko00000000
00800002oooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo000hoooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00Coool010000?ooooooo`0000Woool00`000?ooooooo`04
oooo00<0003oooooool0S_ooo`00>?ooo`0306Kooooooooo03Woool00`1Vooooooooo`05oooo0P00
00[oool300001?ooo`030000oooooooo08koool003Soool00`1Vooooooooo`0ioooo00<0I_oooooo
ool06?ooo`030000oooooooo08koool003Soool00`1Vooooooooo`0ioooo00<0I_ooooooool06?oo
o`030000oooooooo08koool003Soool00`1Vooooooooo`0ioooo00<0I_ooooooool06?ooo`030000
oooooooo08koool003Soool00`1Vooooooooo`0ioooo00<0I_ooooooool06?ooo`80002?oooo000h
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000hoooo00<0
I_ooooooool0>Oooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000hoooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000hoooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000hoooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo01Soool00`000?ooooooo`2>oooo000hoooo00<0I_ooooooool0>Oooo`0306Kooooooooo
01Soool20000Soooo`00>?ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Hoooo00<0003ooooo
ool0S_ooo`00>?ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Hoooo00<0003oooooool0S_oo
o`00=oooo`0306Kooooooooo03[oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00=ooo
o`0306Kooooooooo03[oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00=oooo`0306Ko
oooooooo03[oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00=oooo`0306Kooooooooo
03[oool00`1Vooooooooo`0Hoooo0P0008ooool003Ooool00`1Vooooooooo`0joooo00<0I_oooooo
ool06?ooo`030000oooooooo08koool001Woool300006oooo`0306Kooooooooo01[oool400007?oo
o`0306Kooooooooo01Soool00`000?ooooooo`0goooo100003_oool300005Oooo`006_ooo`030000
oooooooo01[oool00`1Vooooooooo`0Joooo00<0003oooooool07Oooo`0306Kooooooooo01Soool0
0`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool001Ooool500006ooo
o`0306Kooooooooo01_oool00`000?ooooooo`0Loooo00<0I_ooooooool06?ooo`030000oooooooo
03Soool00`000?ooooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo00007?oo
o`0306Kooooooooo01Coool400001?ooo`030000oooooooo01_oool00`1Vooooooooo`0Hoooo00<0
003oooooool0>Oooo`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool00`000?oo
o`00000Loooo00<0I_ooooooool06_ooo`040000oooooooo00007?ooo`0306Kooooooooo01Soool2
0000>?ooo`040000oooooooo0000>_ooo`030000oooo000001Koool001Woool200007?ooo`0306Ko
oooooooo01_oool200007Oooo`0306Kooooooooo01Soool00`000?ooooooo`0hoooo0P0003coool2
00005_ooo`00=oooo`0306Kooooooooo03[oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_oo
o`00=oooo`0306Kooooooooo03[oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00=ooo
o`0306Kooooooooo03[oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00=oooo`0306Ko
oooooooo03[oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00=oooo`0306Kooooooooo
03[oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`004?ooool0000Aoooo000Foooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00@0003ooooooooo09T;oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool05Oooo`00M?ooo`03o`2Ioooooooo01Soool00`000?oo
ooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOoo
ooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>
oooo001doooo00?o09Woooooool06?ooo`80002?oooo001doooo00?o09Woooooool06?ooo`030000
oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2I
oooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo
08koool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo
01Soool20000Soooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o
09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0003ooooo
ool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o09Wooooo
ool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_oo
o`00M?ooo`03o`2Ioooooooo01Soool20000Soooo`00M?ooo`03o`2Ioooooooo01Soool00`000?oo
ooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOoo
ooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>
oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0H
oooo0P0008ooool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2I
oooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo
08koool007Coool00ol0VOooooooo`05oooo0P0000Coool200001?ooo`800005oooo00<0003ooooo
ool0S_ooo`00M?ooo`03o`2Ioooooooo00Coool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo001doooo00?o09Woooooool01?ooo`040000oooooooo00002ooo
o`030000oooooooo00;oool30000S_ooo`00M?ooo`03o`2Ioooooooo00Coool010000?ooooooo`00
00Woool200001Oooo`030000oooooooo08koool007Coool00ol0VOooooooo`04oooo00@0003ooooo
ool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`05
oooo0P0000[oool300001?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0
003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o
09Woooooool06?ooo`80002?oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool0
07Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool0
0`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool0
0ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?oo
ooooo`2>oooo001doooo00?o09Woooooool06?ooo`80002?oooo001doooo00?o09Woooooool06?oo
o`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?oo
o`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000
oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2I
oooooooo01Soool20000Soooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001d
oooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0
003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o
09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo0P0008ooool0
07Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool0
0`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool0
0ol0VOooooooo`0@oooo1@0000?oool00`000?ooooooo`2>oooo001doooo00?o09Woooooool04_oo
o`030000oooooooo00?oool00`000?ooooooo`2>oooo001doooo00?o09Woooooool04_ooo`030000
oooooooo00?oool30000S_ooo`00M?ooo`03o`2Ioooooooo01;oool00`000?ooooooo`03oooo00<0
003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01;oool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00M?ooo`03o`2Ioooooooo017oool200001Oooo`030000oooooooo08koool007Coool0
0ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?oo
ooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOoo
ooooo`0Hoooo0P0008ooool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?oo
o`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000
oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2I
oooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`80002?oooo001d
oooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0
003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o
09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0003ooooo
ool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool20000Soooo`00M?ooo`03o`2Ioooooooo01Soool0
0`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool0
0ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?oo
ooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOoo
ooooo`0Hoooo0P0008ooool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?oo
o`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000
oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2I
oooooooo00Coool500000_ooo`800004oooo0P0000Goool00`000?ooooooo`2>oooo001doooo00?o
09Woooooool01_ooo`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`2>
oooo001doooo00?o09Woooooool01_ooo`030000oooooooo00[oool00`000?ooooooo`02oooo0`00
08koool007goool00`000?ooooooo`08oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0
003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00NOoo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03?ooo`D00002oooo0P0000?oool300001?ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Ooo
o`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00Moooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool02?ooo`<00004oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Goooo00<0003ooooo
ool01oooo`040000oooooooo00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0G
oooo0P0000[oool300000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.36136 .24721 L
.37176 .24721 L
.3815 .24721 L
.39106 .24721 L
.39381 .24721 L
.39642 .24721 L
.39756 .24721 L
.39877 .24721 L
s
.39877 .24721 m
.39888 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.12507 .24721 L
.13506 .24721 L
.14415 .24721 L
.14868 .24721 L
.1536 .24721 L
.15586 .24721 L
.15825 .24721 L
.15923 .24721 L
.16029 .24721 L
.16145 .12361 L
.16254 .12361 L
.18221 .12361 L
.22343 .12361 L
.26314 .12361 L
.30133 .12361 L
.34198 .12361 L
.36078 .12361 L
.38111 .12361 L
.38653 .12361 L
.39226 .12361 L
.39462 .12361 L
.39715 .12361 L
.3979 .12361 L
.3986 .12361 L
.39924 .24721 L
.39993 .24721 L
.40252 .24721 L
.42269 .24721 L
.46347 .24721 L
.50274 .24721 L
.54049 .24721 L
.58069 .24721 L
.61938 .24721 L
.66052 .24721 L
.70014 .24721 L
.73825 .24721 L
.77881 .24721 L
.81786 .24721 L
.85936 .24721 L
.89934 .24721 L
.93781 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00>Oooocd0I_l5oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo000ioooo00<0I_ooooooool0>Oooo`@00002oooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo00?oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003ooooo
ool0S_ooo`00>Oooo`0306Kooooooooo03Woool00`1Vooooooooo`04oooo0P0000[oool300001?oo
o`030000oooooooo08koool003Woool00`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`030000
oooooooo08koool003Woool00`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`030000oooooooo
08koool003Woool00`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`030000oooooooo08koool0
03Woool00`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`80002?oooo000ioooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo01Ooool00`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo01Ooool00`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo01Ooool00`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo
01Ooool00`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Ooool0
0`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Ooool20000Sooo
o`00>Oooo`0306Kooooooooo03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Ooo
o`0306Kooooooooo03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Goooo0P0008ooool003Woool00`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`030000
oooooooo08koool001Woool300007Oooo`0306Kooooooooo01Soool400007Oooo`0306Kooooooooo
01Ooool00`000?ooooooo`0goooo100003_oool300005Oooo`006_ooo`030000oooooooo01coool0
0`1Vooooooooo`0Hoooo00<0003oooooool07_ooo`0306Kooooooooo01Ooool00`000?ooooooo`0g
oooo00<0003oooooool0?Oooo`030000oooooooo01Coool001Ooool500007Oooo`0306Kooooooooo
01Woool00`000?ooooooo`0Moooo00<0I_ooooooool05oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo00007_ooo`0306Kooooooooo
01;oool400001?ooo`030000oooooooo01coool00`1Vooooooooo`0Goooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool00`000?ooo`00000Noooo00<0
I_ooooooool06?ooo`040000oooooooo00007Oooo`0306Kooooooooo01Ooool20000>?ooo`040000
oooooooo0000>_ooo`030000oooo000001Koool001Woool200007_ooo`0306Kooooooooo01Woool2
00007_ooo`0306Kooooooooo01Ooool00`000?ooooooo`0hoooo0P0003coool200005_ooo`00>Ooo
o`0306Kooooooooo03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Goooo00<0003oooooool0S_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00D0003ooooooooooooo09T02_ooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo01Goool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_oo
o`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05ooo
o`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOoo
o`03o`2Ioooooooo01Ooool20000Soooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>
oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0G
oooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001e
oooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo0P00
08ooool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo
01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool0
07Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool0
0`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool0
0ol0VOooooooo`0Goooo0P0008ooool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_oo
o`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05ooo
o`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOoo
o`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`80002?
oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0G
oooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001e
oooo00?o09Woooooool01?ooo`800004oooo0P0000Coool200001Oooo`030000oooooooo08koool0
07Goool00ol0VOooooooo`03oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0
003oooooool0S_ooo`00MOooo`03o`2Ioooooooo00?oool010000?ooooooo`0000_oool00`000?oo
ooooo`02oooo0`0008koool007Goool00ol0VOooooooo`03oooo00@0003oooooool00009oooo0P00
00Goool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool00oooo`040000oooooooo00002Ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool01?ooo`80000:
oooo0`0000Coool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`030000oooooooo
08koool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo
01Ooool20000Soooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o
09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo00<0003ooooo
ool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Wooooo
ool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_oo
o`00MOooo`03o`2Ioooooooo01Ooool20000Soooo`00MOooo`03o`2Ioooooooo01Ooool00`000?oo
ooooo`2>oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOoo
ooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>
oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0G
oooo0P0008ooool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2I
oooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`030000oooooooo
08koool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo
01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`80002?oooo001eoooo00?o
09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo00<0003ooooo
ool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Wooooo
ool03oooo`D00003oooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo017oool00`000?oo
ooooo`03oooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo017oool00`000?ooooooo`03
oooo0`0008koool007Goool00ol0VOooooooo`0Aoooo00<0003oooooool00oooo`030000oooooooo
08koool007Goool00ol0VOooooooo`0Aoooo00<0003oooooool00oooo`030000oooooooo08koool0
07Goool00ol0VOooooooo`0@oooo0P0000Goool00`000?ooooooo`2>oooo001eoooo00?o09Wooooo
ool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_oo
o`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05ooo
o`80002?oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOoo
ooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>
oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0G
oooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool20000Soooo`00MOooo`03o`2I
oooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`030000oooooooo
08koool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo
01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool0
07Goool00ol0VOooooooo`0Goooo0P0008ooool007Goool00ol0VOooooooo`0Goooo00<0003ooooo
ool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Wooooo
ool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_oo
o`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05ooo
o`80002?oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOoo
ooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>
oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`03
oooo1@0000;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo
00Goool00`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00MOoo
o`03o`2Ioooooooo00Goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001m
oooo00<0003oooooool02?ooo`80002Foooo001moooo00<0003oooooool02?ooo`030000oooooooo
09Goool007coool200002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool007Koool00`000?oo
ooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0U
oooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool500000_ooo`800004oooo0P0000Coool200001?ooo`030000oooooooo07Goool007Goool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Ooo
o`030000oooooooo00Ooool010000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?oo
ooooo`1eoooo001doooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`07
oooo00@0003oooooool00005oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool0
0`000?ooooooo`0500005?ooo`030000oooooooo00Soool200001?ooo`800004oooo00<0003ooooo
ool0MOooo`00MOooo`050000oooooooooooo000001Ooool00`000?ooooooo`07oooo00@0003ooooo
ool00003oooo00<0003oooooool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0G
oooo0P0000[oool200001?ooo`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQ
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.39174 .24721 L
.39675 .24721 L
.40134 .24721 L
.40252 .24721 L
.40381 .24721 L
s
.40381 .24721 m
.40399 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.12507 .24721 L
.14415 .24721 L
.1536 .24721 L
.15825 .24721 L
.16254 .24721 L
.16494 .24721 L
.16615 .24721 L
.16683 .12361 L
.16748 .12361 L
.17284 .12361 L
.18221 .12361 L
.22098 .12361 L
.2622 .12361 L
.30191 .12361 L
.34011 .12361 L
.36142 .12361 L
.38075 .12361 L
.39043 .12361 L
.39552 .12361 L
.3983 .12361 L
.4009 .12361 L
.40317 .12361 L
.40445 .12361 L
.40561 .24721 L
.40688 .24721 L
.40827 .24721 L
.41079 .24721 L
.41988 .24721 L
.46066 .24721 L
.49993 .24721 L
.53768 .24721 L
.57788 .24721 L
.61657 .24721 L
.65771 .24721 L
.69733 .24721 L
.73544 .24721 L
.776 .24721 L
.81505 .24721 L
.85655 .24721 L
.89653 .24721 L
.935 .24721 L
.97591 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00>_oooch0I_l3oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo000joooo00<0I_ooooooool0>?ooo`@00002oooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo000joooo00<0I_ooooooool0>_oo
o`0506Kooooooooooooo000000;oool00`000?ooooooo`07oooo00<0003oooooool01?ooo`030000
oooooooo08koool003[oool00`1Vooooooooo`0joooo00<0I_ooooooool00_ooo`80000:oooo0`00
00Coool00`000?ooooooo`2>oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool0
0`000?ooooooo`2>oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool00`000?oo
ooooo`2>oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool00`000?ooooooo`2>
oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool20000Soooo`00>_ooo`0306Ko
oooooooo03[oool00`1Vooooooooo`0Eoooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo
03[oool00`1Vooooooooo`0Eoooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo03[oool0
0`1Vooooooooo`0Eoooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0Eoooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0E
oooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Eoooo0P00
08ooool003[oool00`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool0
03[oool00`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool0
0`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Voooo
ooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Vooooooooo`0j
oooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Vooooooooo`0joooo00<0
I_ooooooool05Oooo`80002?oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool0
0`000?ooooooo`2>oooo000Ioooo0`0001koool00`1Vooooooooo`0Goooo100001ooool00`1Voooo
ooooo`0Eoooo00<0003oooooool0=oooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0M
oooo00<0I_ooooooool05oooo`030000oooooooo023oool00`1Vooooooooo`0Eoooo00<0003ooooo
ool0=oooo`030000oooooooo03goool00`000?ooooooo`0Doooo000Goooo1@0001koool00`1Voooo
ooooo`0Hoooo00<0003oooooool07oooo`0306Kooooooooo01Goool00`000?ooooooo`0hoooo00<0
003oooooool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0001ooool00`1Voooo
ooooo`0Aoooo100000Coool00`000?ooooooo`0Noooo00<0I_ooooooool05Oooo`030000oooooooo
03Woool00`000?ooooooo`0hoooo00@0003oooooool0000Foooo000Hoooo00<0003oool000007ooo
o`0306Kooooooooo01Ooool010000?ooooooo`0001ooool00`1Vooooooooo`0Eoooo0P0003Soool0
10000?ooooooo`0003[oool00`000?ooo`00000Foooo000Ioooo0P0001ooool00`1Vooooooooo`0H
oooo0P00023oool00`1Vooooooooo`0Eoooo00<0003oooooool0>?ooo`80000loooo0P0001Koool0
03[oool00`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool0
0`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Voooo
ooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Vooooooooo`0j
oooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Vooooooooo`0joooo00<0
I_ooooooool05Oooo`030000oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00?oool00ol0VOooooooo`06oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool05Oooo`00Moooo`03o`2Ioooooooo01Goool0
0`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool0
0ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?oo
ooooo`2>oooo001goooo00?o09Woooooool05Oooo`80002?oooo001goooo00?o09Woooooool05Ooo
o`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Mooo
o`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000
oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2I
oooooooo01Goool20000Soooo`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001g
oooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0
003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o
09Woooooool05Oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0003ooooo
ool0S_ooo`00Moooo`03o`2Ioooooooo01Goool20000Soooo`00Moooo`03o`2Ioooooooo01Goool0
0`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool0
0ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?oo
ooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool00ol0VOoo
ooooo`0Eoooo0P0008ooool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Mooo
o`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000
oooooooo08koool007Ooool00ol0VOooooooo`02oooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool0S_ooo`00Moooo`05o`2Ioooooooooooo000000;oool00`000?ooooooo`06oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Moooo`05o`2Ioooooooooooo000000;oool0
0`000?ooooooo`09oooo00<0003oooooool00_ooo`<0002>oooo001goooo00Go09Woooooooooool0
00000_ooo`030000oooooooo00Ooool200001Oooo`030000oooooooo08koool007Ooool01Ol0VOoo
ooooooooo`000002oooo00<0003oooooool01oooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo001goooo00?o09Woooooool00_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001g
oooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0
003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool20000Soooo`00Moooo`03o`2Ioooooooo
01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool0
07Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool0
0`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool0
0ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool20000Sooo
o`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Ooo
o`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Mooo
o`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000
oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo0P0008ooool007Ooool00ol0VOooooooo`0E
oooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001g
oooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0
003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o
09Woooooool05Oooo`80002?oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool0
07Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool0
0`000?ooooooo`2>oooo001goooo00?o09Woooooool03Oooo`D00003oooo00<0003oooooool0S_oo
o`00Moooo`03o`2Ioooooooo00ooool00`000?ooooooo`03oooo00<0003oooooool0S_ooo`00Mooo
o`03o`2Ioooooooo00ooool00`000?ooooooo`03oooo0`0008koool007Ooool00ol0VOooooooo`0?
oooo00<0003oooooool00oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0?oooo00<0
003oooooool00oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0>oooo0P0000Goool0
0`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool0
0ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?oo
ooooo`2>oooo001goooo00?o09Woooooool05Oooo`80002?oooo001goooo00?o09Woooooool05Ooo
o`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Mooo
o`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000
oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2I
oooooooo01Goool20000Soooo`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001g
oooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0
003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o
09Woooooool05Oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo0P0008ooool0
07Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool0
0`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool0
0ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?oo
ooooo`2>oooo001goooo00?o09Woooooool05Oooo`80002?oooo001goooo00?o09Woooooool05Ooo
o`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Mooo
o`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000
oooooooo08koool007Ooool01?l0VOooooooooooo`D00002oooo0P0000Coool200001Oooo`030000
oooooooo08koool007Ooool00ol0VOooooooo`03oooo00<0003oooooool01oooo`040000oooooooo
00001?ooo`030000oooooooo08koool007Ooool00ol0VOooooooo`03oooo00<0003oooooool02_oo
o`030000oooooooo00;oool30000S_ooo`00OOooo`030000oooooooo00Soool20000U_ooo`00OOoo
o`030000oooooooo00Soool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOooo`00oooo
ob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool0
0`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?oo
ooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`800004oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000
oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000oooooooo
00Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@00
01Coool00`000?ooooooo`08oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1h
oooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003o
oooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.39174 .24721 L
.40134 .24721 L
.40616 .24721 L
.40755 .24721 L
.40887 .24721 L
.41005 .24721 L
s
.41005 .24721 m
.41024 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.12507 .24721 L
.14415 .24721 L
.1536 .24721 L
.16254 .24721 L
.16748 .24721 L
.16883 .24721 L
.17026 .24721 L
.17149 .24721 L
.17219 .24721 L
.17284 .12361 L
.17405 .12361 L
.1752 .12361 L
.17735 .12361 L
.18221 .12361 L
.2204 .12361 L
.26105 .12361 L
.30018 .12361 L
.34176 .12361 L
.36263 .12361 L
.38182 .12361 L
.40057 .12361 L
.40513 .12361 L
.40764 .12361 L
.40887 .12361 L
.41001 .12361 L
.41066 .12361 L
.41135 .24721 L
.41205 .24721 L
.41282 .24721 L
.41537 .24721 L
.42038 .24721 L
.46058 .24721 L
.49927 .24721 L
.54041 .24721 L
.58003 .24721 L
.61814 .24721 L
.6587 .24721 L
.69774 .24721 L
.73924 .24721 L
.77922 .24721 L
.81769 .24721 L
.85861 .24721 L
.89801 .24721 L
.9359 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00??ooocd0I_l2oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo000loooo00<0I_ooooooool0=_ooo`@00002oooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo000loooo00<0I_ooooooool0>Ooo
o`0406Kooooooooo00000_ooo`030000oooooooo00Ooool00`000?ooooooo`04oooo00<0003ooooo
ool0S_ooo`00??ooo`0306Kooooooooo03Woool0101Vooooooooooooo`80000:oooo0`0000Coool0
0`000?ooooooo`2>oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool00`000?oo
ooooo`2>oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool00`000?ooooooo`2>
oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool00`000?ooooooo`2>oooo000l
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool20000Soooo`00??ooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Doooo00<0003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0Doooo00<0003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Doooo00<0003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool00`1Vooooooooo`0D
oooo00<0003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Doooo00<0
003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Doooo0P0008ooool0
03coool00`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool0
0`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Voooo
ooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Vooooooooo`0i
oooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Vooooooooo`0ioooo00<0
I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Vooooooooo`0ioooo00<0I_oooooo
ool05?ooo`80002?oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool00`000?oo
ooooo`2>oooo000Ioooo0`00023oool00`1Vooooooooo`0Eoooo1000023oool00`1Vooooooooo`0D
oooo00<0003oooooool0=oooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0Ooooo00<0
I_ooooooool05Oooo`030000oooooooo027oool00`1Vooooooooo`0Doooo00<0003oooooool0=ooo
o`030000oooooooo03goool00`000?ooooooo`0Doooo000Goooo1@00023oool00`1Vooooooooo`0F
oooo00<0003oooooool08?ooo`0306Kooooooooo01Coool00`000?ooooooo`0hoooo00<0003ooooo
ool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?ooooooo`00027oool00`1Vooooooooo`0?
oooo100000Coool00`000?ooooooo`0Ooooo00<0I_ooooooool05?ooo`030000oooooooo03Woool0
0`000?ooooooo`0hoooo00@0003oooooool0000Foooo000Hoooo00<0003oool000008Oooo`0306Ko
oooooooo01Goool010000?ooooooo`00023oool00`1Vooooooooo`0Doooo0P0003Soool010000?oo
ooooo`0003[oool00`000?ooo`00000Foooo000Ioooo0P00027oool00`1Vooooooooo`0Foooo0P00
027oool00`1Vooooooooo`0Doooo00<0003oooooool0>?ooo`80000loooo0P0001Koool003coool0
0`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Voooo
ooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Vooooooooo`0i
oooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Vooooooooo`0ioooo00<0
I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Vooooooooo`0ioooo00<0I_oooooo
ool05?ooo`030000oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00Coool00ol0VOooooooo`05oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool05Oooo`00N?ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOoo
ooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>
oooo001hoooo00?o09Woooooool05?ooo`80002?oooo001hoooo00?o09Woooooool05?ooo`030000
oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2I
oooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo
08koool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo
01Coool20000Soooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o
09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003ooooo
ool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Wooooo
ool05?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_oo
o`00N?ooo`03o`2Ioooooooo01Coool20000Soooo`00N?ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOoo
ooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>
oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0D
oooo0P0008ooool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2I
oooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo
08koool007Soool01?l0VOooooooooooo`800004oooo0P0000Coool200001Oooo`030000oooooooo
08koool007Soool01?l0VOooooooo`0000;oool00`000?ooooooo`06oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00N?ooo`04o`2Ioooooooo00000_ooo`030000oooooooo00Woool0
0`000?ooooooo`02oooo0`0008koool007Soool01?l0VOooooooo`0000;oool00`000?ooooooo`07
oooo0P0000Goool00`000?ooooooo`2>oooo001hoooo00Co09Woooooool00002oooo00<0003ooooo
ool01oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001hoooo00Co09Woooooooooool2
00002_ooo`<00004oooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOoo
ooooo`0Doooo0P0008ooool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?oo
o`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000
oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2I
oooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo
08koool007Soool00ol0VOooooooo`0Doooo0P0008ooool007Soool00ol0VOooooooo`0Doooo00<0
003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o
09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003ooooo
ool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Wooooo
ool05?ooo`80002?oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo08koool007Soool0
0ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOoo
ooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool20000Soooo`00N?oo
o`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000
oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2I
oooooooo00coool500000oooo`030000oooooooo08koool007Soool00ol0VOooooooo`0>oooo00<0
003oooooool00oooo`030000oooooooo08koool007Soool00ol0VOooooooo`0>oooo00<0003ooooo
ool00oooo`<0002>oooo001hoooo00?o09Woooooool03_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001hoooo00?o09Woooooool03_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001hoooo00?o09Woooooool03Oooo`800005oooo00<0003oooooool0S_ooo`00N?ooo`03o`2I
oooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo
08koool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo
01Coool20000Soooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o
09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003ooooo
ool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Wooooo
ool05?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0Doooo0P0008ooool007Soool0
0ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOoo
ooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>
oooo001hoooo00?o09Woooooool05?ooo`80002?oooo001hoooo00?o09Woooooool05?ooo`030000
oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2I
oooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo
08koool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo
01Coool20000Soooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o
09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003ooooo
ool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Wooooo
ool01@0000;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo
00;oool00`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00N?oo
o`03o`2Ioooooooo00;oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001m
oooo00<0003oooooool02?ooo`80002Foooo001moooo00<0003oooooool02?ooo`030000oooooooo
09Goool007coool200002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool007Koool00`000?oo
ooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0U
oooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool500000_ooo`800005oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool0MOoo
o`00MOooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00005oooo00<0003oooooool02Oooo`050000oooooooooooo000000;oool01@000?oooooooooo
o`00001goooo001doooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`09
oooo00<0003oooooool01?ooo`030000oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0
003oooooool01@0001Coool00`000?ooooooo`0:oooo00@0003oooooooooool200001?ooo`030000
oooooooo07Goool007Goool01@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000
oooooooo00000oooo`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003ooooo
ool05oooo`800009oooo100000?oool300000_ooo`030000oooooooo07Koool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.40134 .24721 L
.40616 .24721 L
.41134 .24721 L
.41287 .24721 L
.41432 .24721 L
.41562 .24721 L
.41635 .24721 L
s
.41635 .24721 m
.41645 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.12507 .24721 L
.14415 .24721 L
.16254 .24721 L
.16783 .24721 L
.17284 .24721 L
.17502 .24721 L
.17733 .24721 L
.17854 .24721 L
.17922 .12361 L
.17987 .12361 L
.18221 .12361 L
.22098 .12361 L
.2622 .12361 L
.30191 .12361 L
.34011 .12361 L
.36142 .12361 L
.38075 .12361 L
.39043 .12361 L
.4009 .12361 L
.40571 .12361 L
.41079 .12361 L
.41288 .12361 L
.41512 .12361 L
.41641 .12361 L
.41758 .24721 L
.41876 .24721 L
.41988 .24721 L
.45821 .24721 L
.49899 .24721 L
.53826 .24721 L
.57601 .24721 L
.61621 .24721 L
.6549 .24721 L
.69604 .24721 L
.73566 .24721 L
.77377 .24721 L
.81433 .24721 L
.85338 .24721 L
.89488 .24721 L
.93486 .24721 L
.97332 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00?_ooocd0I_l010000?ooooooo`0000_oool0
0`000?ooooooo`02oooo0`0008koool003koool00`1Vooooooooo`0doooo10000003oooo06Ko0000
00;oool00`000?ooooooo`07oooo0P0000Goool00`000?ooooooo`2>oooo000noooo00<0I_oooooo
ool0>Oooo`0506Ko0000oooooooo000000Woool00`000?ooooooo`04oooo00<0003oooooool0S_oo
o`00?_ooo`0306Kooooooooo03Woool0101Vooooo`00000000[oool300001?ooo`030000oooooooo
08koool003koool00`1Vooooooooo`0ioooo00<0I_ooooooool04_ooo`030000oooooooo08koool0
03koool00`1Vooooooooo`0ioooo00<0I_ooooooool04_ooo`030000oooooooo08koool003koool0
0`1Vooooooooo`0ioooo00<0I_ooooooool04_ooo`030000oooooooo08koool003koool00`1Voooo
ooooo`0ioooo00<0I_ooooooool04_ooo`80002?oooo000noooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo01;oool00`000?ooooooo`2>oooo000noooo00<0I_ooooooool0>Oooo`0306Kooooooooo
01;oool00`000?ooooooo`2>oooo000noooo00<0I_ooooooool0>Oooo`0306Kooooooooo01;oool0
0`000?ooooooo`2>oooo000noooo00<0I_ooooooool0>Oooo`0306Kooooooooo01;oool00`000?oo
ooooo`2>oooo000noooo00<0I_ooooooool0>Oooo`0306Kooooooooo01;oool00`000?ooooooo`2>
oooo000noooo00<0I_ooooooool0>Oooo`0306Kooooooooo01;oool20000Soooo`00?_ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00?_ooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool0
0`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0Boooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool00`1Vooooooooo`0B
oooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool00`1Vooooooooo`0Boooo0P00
08ooool003goool00`1Vooooooooo`0joooo00<0I_ooooooool04_ooo`030000oooooooo08koool0
01Woool300008Oooo`0306Kooooooooo01Coool400008_ooo`0306Kooooooooo01;oool00`000?oo
ooooo`0goooo100003_oool300005Oooo`006_ooo`030000oooooooo023oool00`1Vooooooooo`0D
oooo00<0003oooooool08oooo`0306Kooooooooo01;oool00`000?ooooooo`0goooo00<0003ooooo
ool0?Oooo`030000oooooooo01Coool001Ooool500008Oooo`0306Kooooooooo01Goool00`000?oo
ooooo`0Roooo00<0I_ooooooool04_ooo`030000oooooooo03Soool00`000?ooooooo`0ioooo1@00
01Goool0017oool400000_ooo`040000oooooooo00008_ooo`0306Kooooooooo00koool400001?oo
o`030000oooooooo027oool00`1Vooooooooo`0Boooo00<0003oooooool0>Oooo`030000oooooooo
03Soool010000?ooooooo`0001Koool001Soool00`000?ooo`00000Roooo00<0I_ooooooool05?oo
o`040000oooooooo00008_ooo`0306Kooooooooo01;oool20000>?ooo`040000oooooooo0000>_oo
o`030000oooo000001Koool001Woool200008_ooo`0306Kooooooooo01Goool200008oooo`0306Ko
oooooooo01;oool00`000?ooooooo`0hoooo0P0003coool200005_ooo`00?Oooo`0306Kooooooooo
03[oool00`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool0
0`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0Boooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool00`1Vooooooooo`0B
oooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool00`1Vooooooooo`0Boooo00<0
003oooooool0S_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool01_ooo`03o`2Ioooooooo00?oool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0Eoooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool0
07[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool0
0`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool0
0ol0VOooooooo`0Boooo0P0008ooool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_oo
o`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_oo
o`030000oooooooo08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_oo
o`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`80002?
oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0B
oooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001j
oooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0Boooo00<0
003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o
09Woooooool04_ooo`80002?oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool0
07[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool0
0`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool0
0ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool20000Sooo
o`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_oo
o`030000oooooooo08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_oo
o`04o`2Ioooo000000001?ooo`800004oooo0P0000Goool00`000?ooooooo`2>oooo001joooo00Go
09T0003oooooool000002?ooo`040000oooooooo00001?ooo`030000oooooooo08koool007[oool0
1Ol0V@000?ooooooo`00000;oooo00<0003oooooool00_ooo`<0002>oooo001joooo00Go09T0003o
ooooool000002Oooo`800005oooo00<0003oooooool0S_ooo`00N_ooo`05o`2I0000oooooooo0000
00Woool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00N_ooo`04o`2Ioooo000000002_oo
o`<00004oooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>
oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0B
oooo0P0008ooool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2I
oooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`030000oooooooo
08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo
01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool0
07[oool00ol0VOooooooo`0Boooo0P0008ooool007[oool00ol0VOooooooo`0Boooo00<0003ooooo
ool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Wooooo
ool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_oo
o`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_oo
o`80002?oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool00ol0VOoo
ooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>
oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0B
oooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool20000Soooo`00N_ooo`03o`2I
oooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`030000oooooooo
08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo
00[oool500000oooo`030000oooooooo08koool007[oool00ol0VOooooooo`0<oooo00<0003ooooo
ool00oooo`030000oooooooo08koool007[oool00ol0VOooooooo`0<oooo00<0003oooooool00ooo
o`<0002>oooo001joooo00?o09Woooooool03?ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001joooo00?o09Woooooool03?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001j
oooo00?o09Woooooool02oooo`800005oooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo
01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool0
07[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool2
0000Soooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Wooooo
ool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_oo
o`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_oo
o`030000oooooooo08koool007[oool00ol0VOooooooo`0Boooo0P0008ooool007[oool00ol0VOoo
ooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>
oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0B
oooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001j
oooo00?o09Woooooool04_ooo`80002?oooo001joooo00?o09Woooooool04_ooo`030000oooooooo
08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo
01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool0
07[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool2
0000Soooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Wooooo
ool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_oo
o`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09T0000000000`00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00N_ooo`04o`2Ioooooooo00002Ooo
o`040000oooooooo00001?ooo`030000oooooooo08koool007[oool01?l0VOooooooo`0000coool0
0`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool007goool0
0`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool00?oooolQ
oooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0
003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03?ooo`D00002oooo0P0000Goool00`000?ooooooo`02
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02Oooo`030000oooooooo00;oool0
0`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?oo
ooooo`09oooo00<0003oooooool00oooo`030000oooooooo07Ooool007Soool00`000?ooooooo`05
00005?ooo`030000oooooooo00[oool01@000?ooooooooooo`00001joooo001hoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1h
oooo001ioooo00<0003oooooool05oooo`800009oooo100000;oool00`000?ooooooo`1ioooo003o
oooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.40095 .24721 L
.41127 .24721 L
.41696 .24721 L
.41976 .24721 L
.42113 .24721 L
.42237 .24721 L
s
.42237 .24721 m
.42256 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.16408 .24721 L
.17277 .24721 L
.17735 .24721 L
.17986 .24721 L
.18221 .24721 L
.18341 .24721 L
.1847 .12361 L
.18543 .12361 L
.18613 .12361 L
.18744 .12361 L
.19227 .12361 L
.20178 .12361 L
.22272 .12361 L
.26091 .12361 L
.30156 .12361 L
.34068 .12361 L
.38227 .12361 L
.40313 .12361 L
.41229 .12361 L
.41714 .12361 L
.4198 .12361 L
.42112 .12361 L
.42233 .12361 L
.42351 .24721 L
.42476 .24721 L
.4274 .24721 L
.43203 .24721 L
.44108 .24721 L
.46088 .24721 L
.49863 .24721 L
.53884 .24721 L
.57753 .24721 L
.61867 .24721 L
.65829 .24721 L
.6964 .24721 L
.73696 .24721 L
.776 .24721 L
.8175 .24721 L
.85748 .24721 L
.89595 .24721 L
.93687 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00?ooooc`0I_l010000?ooooooo`0000_oool0
0`000?ooooooo`02oooo0`0008koool003ooool00`1Vooooooooo`0coooo100000;oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool003ooool00`1Vooooooooo`0ioooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool003ooool00`1Voooo
ooooo`0ioooo00<0I_l0000000002_ooo`<00004oooo00<0003oooooool0S_ooo`00?oooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`00?oooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`00?oooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`00?oooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Aoooo0P0008ooool003ooool00`1Vooooooooo`0ioooo00<0I_ooooooool04Oooo`030000
oooooooo08koool003ooool00`1Vooooooooo`0ioooo00<0I_ooooooool04Oooo`030000oooooooo
08koool003ooool00`1Vooooooooo`0ioooo00<0I_ooooooool04Oooo`030000oooooooo08koool0
03ooool00`1Vooooooooo`0ioooo00<0I_ooooooool04Oooo`030000oooooooo08koool003ooool0
0`1Vooooooooo`0ioooo00<0I_ooooooool04Oooo`030000oooooooo08koool003ooool00`1Voooo
ooooo`0ioooo00<0I_ooooooool04Oooo`80002?oooo000ooooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo017oool00`000?ooooooo`2>oooo000ooooo00<0I_ooooooool0>Oooo`0306Kooooooooo
017oool00`000?ooooooo`2>oooo000ooooo00<0I_ooooooool0>Oooo`0306Kooooooooo017oool0
0`000?ooooooo`2>oooo000ooooo00<0I_ooooooool0>_ooo`0306Kooooooooo013oool00`000?oo
ooooo`2>oooo000ooooo00<0I_ooooooool0>_ooo`0306Kooooooooo013oool00`000?ooooooo`2>
oooo000ooooo00<0I_ooooooool0>_ooo`0306Kooooooooo013oool20000Soooo`00?oooo`0306Ko
oooooooo03[oool00`1Vooooooooo`0@oooo00<0003oooooool0S_ooo`006Oooo`<0000Soooo00<0
I_ooooooool04_ooo`@0000Toooo00<0I_ooooooool04?ooo`030000oooooooo03Ooool40000>ooo
o`<0000Eoooo000Joooo00<0003oooooool08_ooo`0306Kooooooooo01;oool00`000?ooooooo`0U
oooo00<0I_ooooooool04?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000Soooo00<0I_ooooooool04oooo`030000oooooooo02Coool00`1Voooo
ooooo`0@oooo00<0003oooooool0>?ooo`030000oooooooo03Woool500005Oooo`004Oooo`@00002
oooo00@0003oooooool0000Toooo00<0I_ooooooool03?ooo`@00004oooo00<0003oooooool08ooo
o`0306Kooooooooo013oool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo
00005_ooo`006?ooo`030000oooo000002Coool00`1Vooooooooo`0Boooo00@0003oooooool0000T
oooo00<0I_ooooooool04?ooo`80000hoooo00@0003oooooool0000joooo00<0003oool000005_oo
o`006Oooo`80000Toooo00<0I_ooooooool04oooo`80000Uoooo00<0I_ooooooool04?ooo`030000
oooooooo03Soool20000??ooo`80000Foooo000ooooo00<0I_ooooooool0>_ooo`0306Kooooooooo
013oool00`000?ooooooo`2>oooo000ooooo00<0I_ooooooool0>_ooo`0306Kooooooooo013oool0
0`000?ooooooo`2>oooo000ooooo00<0I_ooooooool0>_ooo`0306Kooooooooo013oool00`000?oo
ooooo`2>oooo000ooooo00<0I_ooooooool0>_ooo`0306Kooooooooo013oool00`000?ooooooo`2>
oooo000ooooo00<0I_ooooooool0>_ooo`0306Kooooooooo013oool00`000?ooooooo`2>oooo000@
ooooo`00017oool001Koool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`07oooo00?o09Woooooool00_ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
01Goool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo
017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool0
07_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool2
0000Soooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Wooooo
ool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_oo
o`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Ooo
o`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo0P0008ooool007_oool00ol0VOoo
ooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>
oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0A
oooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001k
oooo00?o09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo0P00
08ooool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo
017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool0
07_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool0
0`000?ooooooo`2>oooo001koooo00?o09Woooooool04Oooo`80002?oooo001koooo00?o09Wooooo
ool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_oo
o`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09T0000000001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002oooo`030000
oooooooo00;oool30000S_ooo`00Noooo`040000oooooooo00002Oooo`800005oooo00<0003ooooo
ool0S_ooo`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo001koooo00?o09T0000000002_ooo`<00004oooo00<0003oooooool0S_ooo`00Noooo`03o`2I
oooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo
08koool007_oool00ol0VOooooooo`0Aoooo0P0008ooool007_oool00ol0VOooooooo`0Aoooo00<0
003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o
09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo00<0003ooooo
ool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Wooooo
ool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo0P0008ooool007_oool0
0ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?oo
ooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOoo
ooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>
oooo001koooo00?o09Woooooool04Oooo`80002?oooo001koooo00?o09Woooooool04Oooo`030000
oooooooo08koool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2I
oooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo
08koool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo
017oool20000Soooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o
09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo00<0003ooooo
ool0S_ooo`00Noooo`03o`2Ioooooooo00Woool500000oooo`030000oooooooo08koool007_oool0
0ol0VOooooooo`0;oooo00<0003oooooool00oooo`030000oooooooo08koool007_oool00ol0VOoo
ooooo`0;oooo00<0003oooooool00oooo`<0002>oooo001koooo00?o09Woooooool02oooo`030000
oooooooo00?oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool02oooo`030000oooooooo
00?oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool02_ooo`800005oooo00<0003ooooo
ool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Wooooo
ool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_oo
o`00Noooo`03o`2Ioooooooo017oool20000Soooo`00Noooo`03o`2Ioooooooo017oool00`000?oo
ooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOoo
ooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>
oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0A
oooo0P0008ooool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2I
oooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo
08koool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo
017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Oooo`80002?oooo001koooo00?o
09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo00<0003ooooo
ool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Wooooo
ool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_oo
o`00Noooo`03o`2Ioooooooo017oool20000Soooo`00Noooo`03o`2Ioooooooo017oool00`000?oo
ooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOoo
ooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>
oooo001koooo1@0000;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00Noooo`03o`2I
oooo000000Woool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001koooo00?o09Woool0
00003?ooo`030000oooooooo00;oool30000S_ooo`00OOooo`030000oooooooo00Soool20000U_oo
o`00OOooo`030000oooooooo00Soool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000oooo`<00004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`040000oooooooo00001Oooo`030000
oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001Coool00`000?oo
ooooo`07oooo0`0000Coool200001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`00000Goooo00<0003oooooool02?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`<00003oooo0`0000;oool0
0`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.40095 .24721 L
.41127 .24721 L
.41696 .24721 L
.42237 .24721 L
.42482 .24721 L
.42617 .24721 L
.42744 .24721 L
.42816 .24721 L
s
.42816 .24721 m
.42828 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.16408 .24721 L
.17277 .24721 L
.18221 .24721 L
.18475 .24721 L
.18744 .24721 L
.18855 .24721 L
.18974 .24721 L
.19104 .12361 L
.19227 .12361 L
.20178 .12361 L
.22272 .12361 L
.26394 .12361 L
.30365 .12361 L
.34184 .12361 L
.38249 .12361 L
.40128 .12361 L
.41117 .12361 L
.42162 .12361 L
.42418 .12361 L
.42693 .12361 L
.42774 .12361 L
.42851 .12361 L
.4292 .24721 L
.42995 .24721 L
.43277 .24721 L
.44303 .24721 L
.4632 .24721 L
.50398 .24721 L
.54325 .24721 L
.581 .24721 L
.6212 .24721 L
.65989 .24721 L
.70103 .24721 L
.74065 .24721 L
.77876 .24721 L
.81932 .24721 L
.85837 .24721 L
.89987 .24721 L
.93985 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00@OooocX0I_l01000001Vo`1Vo`0000_oool0
0`000?ooooooo`02oooo0`0008koool0047oool00`1Vooooooooo`0aoooo100000;oool010000?oo
o`1Vo`0000Woool200001Oooo`030000oooooooo08koool0047oool00`1Vooooooooo`0goooo00@0
003oool0I_l00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0047oool00`1Voooo
ooooo`0hoooo0P0000[oool300001?ooo`030000oooooooo08koool0047oool00`1Vooooooooo`0i
oooo00<0I_ooooooool03oooo`030000oooooooo08koool0047oool00`1Vooooooooo`0ioooo00<0
I_ooooooool03oooo`030000oooooooo08koool0047oool00`1Vooooooooo`0ioooo00<0I_oooooo
ool03oooo`030000oooooooo08koool0047oool00`1Vooooooooo`0ioooo00<0I_ooooooool03ooo
o`80002?oooo0011oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>
oooo0011oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo0011
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo0011oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo0011oooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo0011oooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo00ooool20000Soooo`00@Oooo`0306Kooooooooo03Woool00`1Vooooooooo`0?
oooo00<0003oooooool0S_ooo`00@Oooo`0306Kooooooooo03Woool00`1Vooooooooo`0?oooo00<0
003oooooool0S_ooo`00@?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003ooooo
ool0S_ooo`00@?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003oooooool0S_oo
o`00@?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`00@?oo
o`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo0P0008ooool0043oool00`1Vooooooooo`0j
oooo00<0I_ooooooool03oooo`030000oooooooo08koool001Woool300009?ooo`0306Kooooooooo
017oool400009Oooo`0306Kooooooooo00ooool00`000?ooooooo`0goooo100003_oool300005Ooo
o`006_ooo`030000oooooooo02?oool00`1Vooooooooo`0Aoooo00<0003oooooool09_ooo`0306Ko
oooooooo00ooool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool0
01Ooool500009?ooo`0306Kooooooooo01;oool00`000?ooooooo`0Uoooo00<0I_ooooooool03ooo
o`030000oooooooo03Soool00`000?ooooooo`0ioooo1@0001Goool0017oool400000_ooo`040000
oooooooo00009Oooo`0306Kooooooooo00_oool400001?ooo`030000oooooooo02Coool00`1Voooo
ooooo`0?oooo00<0003oooooool0>Oooo`030000oooooooo03Soool010000?ooooooo`0001Koool0
01Soool00`000?ooo`00000Uoooo00<0I_ooooooool04Oooo`040000oooooooo00009Oooo`0306Ko
oooooooo00ooool20000>?ooo`040000oooooooo0000>_ooo`030000oooo000001Koool001Woool2
00009Oooo`0306Kooooooooo01;oool200009_ooo`0306Kooooooooo00ooool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00@?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0
003oooooool0S_ooo`00@?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003ooooo
ool0S_ooo`00@?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003oooooool0S_oo
o`00@?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`00@?oo
o`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`004?ooool0000A
oooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool02Ooo
o`04o`2Ioooooooo00003_ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool05Oooo`00OOooo`03o`2Ioooooooo
00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool0
07goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool0
0`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`80002?oooo001moooo00?o09Wooooo
ool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_oo
o`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03ooo
o`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOoo
o`03o`2Ioooooooo00ooool20000Soooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>
oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?
oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001m
oooo00?o09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0
003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool20000Soooo`00OOooo`03o`2Ioooooooo
00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool0
07goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool0
0`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool007goool0
0ol0VOooooooo`0?oooo0P0008ooool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_oo
o`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03ooo
o`030000oooooooo08koool007coool200001?ooo`800004oooo0P0000Goool00`000?ooooooo`2>
oooo001koooo00@0003ooooo09T00008oooo00@0003oooooool00004oooo00<0003oooooool0S_oo
o`00Noooo`040000ooooo`2I00002oooo`030000oooooooo00;oool30000S_ooo`00Noooo`040000
ooooo`2I00002Oooo`800005oooo00<0003oooooool0S_ooo`00Noooo`040000ooooo`2I00002Ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001loooo0P0000[oool300001?ooo`030000
oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2I
oooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`80002?oooo001m
oooo00?o09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0
003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o
09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0003ooooo
ool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Wooooo
ool03oooo`80002?oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool007goool0
0ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?oo
ooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOoo
ooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool20000Soooo`00OOoo
o`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`030000
oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2I
oooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo
08koool007goool00ol0VOooooooo`0?oooo0P0008ooool007goool00ol0VOooooooo`0?oooo00<0
003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o
09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`07oooo1@0000?oool0
0`000?ooooooo`2>oooo001moooo00?o09Woooooool02Oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001moooo00?o09Woooooool02Oooo`030000oooooooo00?oool30000S_ooo`00OOoo
o`03o`2Ioooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0S_ooo`00OOooo`03o`2I
oooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo
00Soool200001Oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0003ooooo
ool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Wooooo
ool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo0P0008ooool007goool0
0ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?oo
ooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOoo
ooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>
oooo001moooo00?o09Woooooool03oooo`80002?oooo001moooo00?o09Woooooool03oooo`030000
oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2I
oooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo
08koool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo
00ooool20000Soooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o
09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0003ooooo
ool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Wooooo
ool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo0P0008ooool007goool0
0ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?oo
ooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOoo
ooooo`0?oooo00<0003oooooool0S_ooo`00Noooo`D00002oooo0P0000Coool200001Oooo`030000
oooooooo08koool007goool00`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003ooooo
ool0S_ooo`00OOooo`030000oooooooo00[oool00`000?ooooooo`02oooo0`0008koool007goool0
0`000?ooooooo`08oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0003oooooool0UOoo
o`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?oo
o`D00002oooo0P0000?oool300001?ooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo
00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01Goool00`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool01oooo`<00004oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Ooool00`000?ooooooo`08oooo00<0
003oooooool00oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool3
00000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.40095 .24721 L
.41127 .24721 L
.42237 .24721 L
.42781 .24721 L
.43049 .24721 L
.43179 .24721 L
.43298 .24721 L
.43413 .24721 L
s
.43413 .24721 m
.4343 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.16408 .24721 L
.18221 .24721 L
.18703 .24721 L
.18957 .24721 L
.19227 .24721 L
.19462 .24721 L
.19527 .24721 L
.19596 .24721 L
.19721 .12361 L
.19844 .12361 L
.1996 .12361 L
.20178 .12361 L
.22272 .12361 L
.26091 .12361 L
.30156 .12361 L
.34068 .12361 L
.38227 .12361 L
.40313 .12361 L
.41229 .12361 L
.42233 .12361 L
.42701 .12361 L
.42959 .12361 L
.43203 .12361 L
.43313 .12361 L
.4343 .12361 L
.43558 .24721 L
.43676 .24721 L
.44108 .24721 L
.46088 .24721 L
.49863 .24721 L
.53884 .24721 L
.57753 .24721 L
.61867 .24721 L
.65829 .24721 L
.6964 .24721 L
.73696 .24721 L
.776 .24721 L
.8175 .24721 L
.85748 .24721 L
.89595 .24721 L
.93687 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00@_ooocT0I_l01000001Vo`1Vo`0000_oool0
0`000?ooooooo`02oooo0`0008koool004;oool00`1Vooooooooo`0`oooo100000;oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool004;oool00`1Vooooooooo`0foooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004;oool00`1Voooo
ooooo`0goooo0P00000306Kooooooooo00Ooool300001?ooo`030000oooooooo08koool004;oool0
0`1Vooooooooo`0ioooo00<0I_ooooooool03_ooo`030000oooooooo08koool004;oool00`1Voooo
ooooo`0ioooo00<0I_ooooooool03_ooo`030000oooooooo08koool004;oool00`1Vooooooooo`0i
oooo00<0I_ooooooool03_ooo`030000oooooooo08koool004;oool00`1Vooooooooo`0ioooo00<0
I_ooooooool03_ooo`80002?oooo0012oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00koool0
0`000?ooooooo`2>oooo0012oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00koool00`000?oo
ooooo`2>oooo0012oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00koool00`000?ooooooo`2>
oooo0012oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00koool00`000?ooooooo`2>oooo0012
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00koool00`000?ooooooo`2>oooo0012oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00koool20000Soooo`00@_ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0>oooo00<0003oooooool0S_ooo`00@_ooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0>oooo00<0003oooooool0S_ooo`00@_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0>
oooo00<0003oooooool0S_ooo`00@_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0=oooo00<0
003oooooool0S_ooo`00@_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0=oooo00<0003ooooo
ool0S_ooo`00@_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0=oooo0P0008ooool004;oool0
0`1Vooooooooo`0joooo00<0I_ooooooool03Oooo`030000oooooooo08koool001Woool300009_oo
o`0306Kooooooooo00ooool400009oooo`0306Kooooooooo00goool00`000?ooooooo`0goooo1000
03_oool300005Oooo`006_ooo`030000oooooooo02Goool00`1Vooooooooo`0?oooo00<0003ooooo
ool0:?ooo`0306Kooooooooo00goool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000
oooooooo01Coool001Ooool500009_ooo`0306Kooooooooo013oool00`000?ooooooo`0Woooo00<0
I_ooooooool03Oooo`030000oooooooo03Soool00`000?ooooooo`0ioooo1@0001Goool0017oool4
00000_ooo`040000oooooooo00009oooo`0306Kooooooooo00Woool400001?ooo`030000oooooooo
02Koool00`1Vooooooooo`0=oooo00<0003oooooool0>Oooo`030000oooooooo03Soool010000?oo
ooooo`0001Koool001Soool00`000?ooo`00000Woooo00<0I_ooooooool03oooo`040000oooooooo
00009oooo`0306Kooooooooo00goool20000>?ooo`040000oooooooo0000>_ooo`030000oooo0000
01Koool001Woool200009oooo`0306Kooooooooo013oool20000:?ooo`0306Kooooooooo00goool0
0`000?ooooooo`0hoooo0P0003coool200005_ooo`00@_ooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0=oooo00<0003oooooool0S_ooo`00@_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0=
oooo00<0003oooooool0S_ooo`00@_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0=oooo00<0
003oooooool0S_ooo`00@_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0=oooo00<0003ooooo
ool0S_ooo`00@_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0=oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool02_ooo`03o`2Ioooo000000koool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool007koool0
0ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?oo
ooooo`2>oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOoo
ooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool20000Soooo`00O_oo
o`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_ooo`030000
oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2I
oooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_ooo`030000oooooooo
08koool007koool00ol0VOooooooo`0>oooo0P0008ooool007koool00ol0VOooooooo`0>oooo00<0
003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o
09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003ooooo
ool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Wooooo
ool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo0P0008ooool007koool0
0ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?oo
ooooo`2>oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOoo
ooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>
oooo001noooo00?o09Woooooool03_ooo`80002?oooo001noooo00?o09Woooooool03_ooo`030000
oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2I
oooooooo00koool00`000?ooooooo`2>oooo001loooo0P000004o`2Ioooooooooooo0P0000Coool2
00001Oooo`030000oooooooo08koool007_oool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo001koooo00@0003oooooool0000;oooo00<0003oooooool00_oo
o`<0002>oooo001koooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo001k
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool007coool2
000000?o09Woooooool01oooo`<00004oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo
00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool0
07koool00ol0VOooooooo`0>oooo0P0008ooool007koool00ol0VOooooooo`0>oooo00<0003ooooo
ool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Wooooo
ool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_oo
o`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_oo
o`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo0P0008ooool007koool00ol0VOoo
ooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>
oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>
oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001n
oooo00?o09Woooooool03_ooo`80002?oooo001noooo00?o09Woooooool03_ooo`030000oooooooo
08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo
00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool0
07koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool2
0000Soooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Wooooo
ool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_oo
o`00O_ooo`03o`2Ioooooooo00Koool500000oooo`030000oooooooo08koool007koool00ol0VOoo
ooooo`08oooo00<0003oooooool00oooo`030000oooooooo08koool007koool00ol0VOooooooo`08
oooo00<0003oooooool00oooo`<0002>oooo001noooo00?o09Woooooool02?ooo`030000oooooooo
00?oool00`000?ooooooo`2>oooo001noooo00?o09Woooooool02?ooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo001noooo00?o09Woooooool01oooo`800005oooo00<0003oooooool0S_oo
o`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_oo
o`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_oo
o`03o`2Ioooooooo00koool20000Soooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>
oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>
oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001n
oooo00?o09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo0P00
08ooool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo
00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool0
07koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool0
0`000?ooooooo`2>oooo001noooo00?o09Woooooool03_ooo`80002?oooo001noooo00?o09Wooooo
ool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_oo
o`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_oo
o`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_oo
o`03o`2Ioooooooo00koool20000Soooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>
oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>
oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001k
oooo1@0000;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00OOooo`030000o`2Ioooo
00Ooool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001moooo00<0003o09Woool02_oo
o`030000oooooooo00;oool30000S_ooo`00OOooo`030000oooooooo00Soool20000U_ooo`00OOoo
o`030000oooooooo00Soool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOooo`00oooo
ob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool007Goool0
0`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool00`000?oo
ooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`800004oooo0P00
00Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0003oooooool00002
oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Eoooo00<0003oooooool02_ooo`030000oooooooo00?oool00`000?ooooooo`02
oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Doooo00<0003oooooool02?oo
o`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005ooo
o`030000oooooooo00Soool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool300000oooo`<00002oooo00<0003ooooo
ool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.40095 .24721 L
.41127 .24721 L
.42237 .24721 L
.42781 .24721 L
.43298 .24721 L
.43762 .24721 L
.43889 .24721 L
.43959 .24721 L
.44024 .24721 L
s
.44024 .24721 m
.44044 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.19227 .24721 L
.19721 .24721 L
.19939 .24721 L
.20054 .24721 L
.20178 .24721 L
.2031 .12361 L
.20433 .12361 L
.20704 .12361 L
.21274 .12361 L
.22272 .12361 L
.26394 .12361 L
.30365 .12361 L
.34184 .12361 L
.38249 .12361 L
.40128 .12361 L
.42162 .12361 L
.42704 .12361 L
.43277 .12361 L
.43766 .12361 L
.439 .12361 L
.43974 .12361 L
.44044 .12361 L
.44109 .24721 L
.44179 .24721 L
.44303 .24721 L
.4632 .24721 L
.50398 .24721 L
.54325 .24721 L
.581 .24721 L
.6212 .24721 L
.65989 .24721 L
.70103 .24721 L
.74065 .24721 L
.77876 .24721 L
.81932 .24721 L
.85837 .24721 L
.89987 .24721 L
.93985 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00A?ooocL0I_l01000001Vo`1Vo`000080I_l9
oooo00<0003oooooool00_ooo`<0002>oooo0014oooo00<0I_ooooooool0;_ooo`@00002oooo00H0
003oooooool0003oool0I_l7oooo0P0000Goool00`000?ooooooo`2>oooo0014oooo00<0I_oooooo
ool0=?ooo`060000oooooooo0000oooo06Ko1oooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo0014oooo00<0I_ooooooool0=Oooo`800002oooo00<0I_ooooooool01Oooo`<00004oooo00<0
003oooooool0S_ooo`00A?ooo`0306Kooooooooo03Woool00`1Vooooooooo`0<oooo00<0003ooooo
ool0S_ooo`00A?ooo`0306Kooooooooo03Woool00`1Vooooooooo`0<oooo00<0003oooooool0S_oo
o`00A?ooo`0306Kooooooooo03Woool00`1Vooooooooo`0<oooo00<0003oooooool0S_ooo`00A?oo
o`0306Kooooooooo03Woool00`1Vooooooooo`0<oooo0P0008ooool004Coool00`1Vooooooooo`0i
oooo00<0I_ooooooool03?ooo`030000oooooooo08koool004Coool00`1Vooooooooo`0ioooo00<0
I_ooooooool03?ooo`030000oooooooo08koool004Coool00`1Vooooooooo`0ioooo00<0I_oooooo
ool03?ooo`030000oooooooo08koool004Coool00`1Vooooooooo`0ioooo00<0I_ooooooool03?oo
o`030000oooooooo08koool004Coool00`1Vooooooooo`0ioooo00<0I_ooooooool03?ooo`030000
oooooooo08koool004Coool00`1Vooooooooo`0ioooo00<0I_ooooooool03?ooo`80002?oooo0014
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo0014oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo0013oooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo0013oooo00<0I_ooooooool0>_oo
o`0306Kooooooooo00coool00`000?ooooooo`2>oooo0013oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00coool00`000?ooooooo`2>oooo0013oooo00<0I_ooooooool0>_ooo`0306Kooooooooo
00coool20000Soooo`00@oooo`0306Kooooooooo03[oool00`1Vooooooooo`0<oooo00<0003ooooo
ool0S_ooo`006Oooo`<0000Woooo00<0I_ooooooool03_ooo`@0000Xoooo00<0I_ooooooool03?oo
o`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool09_ooo`0306Ko
oooooooo00koool00`000?ooooooo`0Yoooo00<0I_ooooooool03?ooo`030000oooooooo03Ooool0
0`000?ooooooo`0moooo00<0003oooooool05?ooo`005oooo`D0000Woooo00<0I_ooooooool03ooo
o`030000oooooooo02Soool00`1Vooooooooo`0<oooo00<0003oooooool0>?ooo`030000oooooooo
03Woool500005Oooo`004Oooo`@00002oooo00@0003oooooool0000Xoooo00<0I_ooooooool02?oo
o`@00004oooo00<0003oooooool09oooo`0306Kooooooooo00coool00`000?ooooooo`0ioooo00<0
003oooooool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000oooo000002Soool00`1Voooo
ooooo`0>oooo00@0003oooooool0000Xoooo00<0I_ooooooool03?ooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000Xoooo00<0I_ooooooool03oooo`80000Y
oooo00<0I_ooooooool03?ooo`030000oooooooo03Soool20000??ooo`80000Foooo0013oooo00<0
I_ooooooool0>_ooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo0013oooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo0013oooo00<0I_ooooooool0>_oo
o`0306Kooooooooo00coool00`000?ooooooo`2>oooo0013oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00coool00`000?ooooooo`2>oooo0013oooo00<0I_ooooooool0>_ooo`0306Kooooooooo
00coool00`000?ooooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool05Oooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o
09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo00<0003ooooo
ool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Wooooo
ool03?ooo`80002?oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo08koool0083oool0
0ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?oo
ooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOoo
ooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool20000Soooo`00P?oo
o`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000
oooooooo08koool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2I
oooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo
08koool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo
00coool20000Soooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o
09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo00<0003ooooo
ool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Wooooo
ool03?ooo`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo0P0008ooool0083oool0
0ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?oo
ooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo08koool007coool200000_oo
o`04o`2Ioooo000000001?ooo`800005oooo00<0003oooooool0S_ooo`00Noooo`060000oooooooo
0000ooooo`2I1_ooo`040000oooooooo00001?ooo`030000oooooooo08koool007_oool01P000?oo
ooooo`000?ooool0V@Woool00`000?ooooooo`02oooo0`0008koool007_oool01P000?ooooooo`00
0?ooool0V@Ooool200001Oooo`030000oooooooo08koool007_oool01P000?ooooooo`000?ooool0
V@Ooool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00O?ooo`800002oooo00?o09Wooooo
ool01Oooo`<00004oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?oo
ooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOoo
ooooo`0<oooo0P0008ooool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?oo
o`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000
oooooooo08koool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2I
oooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo
08koool0083oool00ol0VOooooooo`0<oooo0P0008ooool0083oool00ol0VOooooooo`0<oooo00<0
003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o
09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo00<0003ooooo
ool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Wooooo
ool03?ooo`80002?oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo08koool0083oool0
0ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?oo
ooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOoo
ooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool20000Soooo`00P?oo
o`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000
oooooooo08koool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2I
oooooooo00Coool500000oooo`030000oooooooo08koool0083oool00ol0VOooooooo`06oooo00<0
003oooooool00oooo`030000oooooooo08koool0083oool00ol0VOooooooo`06oooo00<0003ooooo
ool00oooo`<0002>oooo0020oooo00?o09Woooooool01_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo0020oooo00?o09Woooooool01_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo0020oooo00?o09Woooooool01Oooo`800005oooo00<0003oooooool0S_ooo`00P?ooo`03o`2I
oooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo
08koool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo
00coool20000Soooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o
09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo00<0003ooooo
ool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Wooooo
ool03?ooo`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo0P0008ooool0083oool0
0ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?oo
ooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOoo
ooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>
oooo0020oooo00?o09Woooooool03?ooo`80002?oooo0020oooo00?o09Woooooool03?ooo`030000
oooooooo08koool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2I
oooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo
08koool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo
00coool20000Soooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o
09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo00<0003ooooo
ool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo001koooo1@000004o`2I
oooo000000001?ooo`800005oooo00<0003oooooool0S_ooo`00OOooo`040000ooooooooo`2I1_oo
o`040000oooooooo00001?ooo`030000oooooooo08koool007goool010000?ooooooool0V@Woool0
0`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool007goool0
0`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool00?oooolQ
oooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0
003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03?ooo`D00002oooo0P0000Coool200001?ooo`030000
oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Coool400001Oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`0:
oooo00<0003oooooool00_ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005?oo
o`030000oooooooo00Soool200001?ooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`00000Goooo00<0003oooooool02?ooo`030000oooooooo00?oool00`000?ooooooo`1hoooo001i
oooo00<0003oooooool05oooo`80000:oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Ooo
o`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.40095 .24721 L
.42237 .24721 L
.43215 .24721 L
.43755 .24721 L
.44021 .24721 L
.44268 .24721 L
.44498 .24721 L
.44627 .24721 L
s
.44627 .24721 m
.44644 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.19227 .24721 L
.20178 .24721 L
.20433 .24721 L
.20573 .24721 L
.20704 .24721 L
.20772 .24721 L
.20845 .12361 L
.20926 .12361 L
.21 .12361 L
.21274 .12361 L
.22272 .12361 L
.26243 .12361 L
.30062 .12361 L
.34126 .12361 L
.38039 .12361 L
.40037 .12361 L
.42198 .12361 L
.43212 .12361 L
.43767 .12361 L
.44037 .12361 L
.44284 .12361 L
.44393 .12361 L
.44511 .12361 L
.44623 .12361 L
.44726 .24721 L
.44835 .24721 L
.44956 .24721 L
.452 .24721 L
.46204 .24721 L
.50225 .24721 L
.54093 .24721 L
.58207 .24721 L
.6217 .24721 L
.65981 .24721 L
.70037 .24721 L
.73941 .24721 L
.78091 .24721 L
.82089 .24721 L
.85936 .24721 L
.90028 .24721 L
.93968 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00AOooocH0I_l01000001Vo`1Vo`0000<0I_l8
oooo00<0003oooooool00_ooo`<0002>oooo0015oooo00<0I_ooooooool0;Oooo`@00002oooo00@0
003oooooool00002oooo00<0I_ooooooool01?ooo`800005oooo00<0003oooooool0S_ooo`00AOoo
o`0306Kooooooooo03?oool010000?ooooooo`0000;oool00`1Vooooooooo`04oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool004Goool00`1Vooooooooo`0doooo0P0000?oool00`1Voooo
ooooo`04oooo0`0000Coool00`000?ooooooo`2>oooo0015oooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo00_oool00`000?ooooooo`2>oooo0015oooo00<0I_ooooooool0>Oooo`0306Kooooooooo
00_oool00`000?ooooooo`2>oooo0015oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00_oool0
0`000?ooooooo`2>oooo0015oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00_oool20000Sooo
o`00AOooo`0306Kooooooooo03Woool00`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00AOoo
o`0306Kooooooooo03Woool00`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00AOooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00AOooo`0306Kooooooooo
03Woool00`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00AOooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00AOooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0;oooo0P0008ooool004Goool00`1Vooooooooo`0ioooo00<0I_ooooooool02oooo`030000
oooooooo08koool004Goool00`1Vooooooooo`0ioooo00<0I_ooooooool02oooo`030000oooooooo
08koool004Goool00`1Vooooooooo`0ioooo00<0I_ooooooool02oooo`030000oooooooo08koool0
04Goool00`1Vooooooooo`0joooo00<0I_ooooooool02_ooo`030000oooooooo08koool004Goool0
0`1Vooooooooo`0joooo00<0I_ooooooool02_ooo`030000oooooooo08koool004Goool00`1Voooo
ooooo`0joooo00<0I_ooooooool02_ooo`80002?oooo0015oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00[oool00`000?ooooooo`2>oooo000Ioooo0`0002Woool00`1Vooooooooo`0<oooo1000
02[oool00`1Vooooooooo`0:oooo00<0003oooooool0=oooo`@0000koooo0`0001Goool001[oool0
0`000?ooooooo`0Xoooo00<0I_ooooooool03?ooo`030000oooooooo02_oool00`1Vooooooooo`0:
oooo00<0003oooooool0=oooo`030000oooooooo03goool00`000?ooooooo`0Doooo000Goooo1@00
02Woool00`1Vooooooooo`0=oooo00<0003oooooool0:_ooo`0306Kooooooooo00[oool00`000?oo
ooooo`0hoooo00<0003oooooool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?ooooooo`00
02[oool00`1Vooooooooo`06oooo100000Coool00`000?ooooooo`0Yoooo00<0I_ooooooool02_oo
o`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000Foooo000Hoooo00<0
003oool00000:_ooo`0306Kooooooooo00coool010000?ooooooo`0002[oool00`1Vooooooooo`0:
oooo0P0003Soool010000?ooooooo`0003[oool00`000?ooo`00000Foooo000Ioooo0P0002[oool0
0`1Vooooooooo`0=oooo0P0002_oool00`1Vooooooooo`0:oooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool004Goool00`1Vooooooooo`0joooo00<0I_ooooooool02_ooo`030000oooooooo
08koool004Goool00`1Vooooooooo`0joooo00<0I_ooooooool02_ooo`030000oooooooo08koool0
04Goool00`1Vooooooooo`0joooo00<0I_ooooooool02_ooo`030000oooooooo08koool004Goool0
0`1Vooooooooo`0joooo00<0I_ooooooool02_ooo`030000oooooooo08koool004Goool00`1Voooo
ooooo`0joooo00<0I_ooooooool02_ooo`030000oooooooo08koool0013ooooo00004Oooo`005_oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?l0
VOooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0Eoooo0021oooo00?o09Woooooool02oooo`030000
oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2I
oooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo
08koool0087oool00ol0VOooooooo`0;oooo0P0008ooool0087oool00ol0VOooooooo`0;oooo00<0
003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o
09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003ooooo
ool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Wooooo
ool02oooo`80002?oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool0
0ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?oo
ooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOoo
ooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>
oooo0021oooo00?o09Woooooool02oooo`80002?oooo0021oooo00?o09Woooooool02oooo`030000
oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2I
oooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo
08koool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo
00_oool20000Soooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o
09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003ooooo
ool0S_ooo`00O?ooo`800003oooo00?o09T0000000001?ooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00000_ooo`03o`2Ioooooooo00?oool010000?ooooooo`0000Coool0
0`000?ooooooo`2>oooo001koooo00@0003oooooool00002oooo00?o09Woooooool01_ooo`030000
oooooooo00;oool30000S_ooo`00Noooo`040000oooooooo00000_ooo`03o`2Ioooooooo00Coool2
00001Oooo`030000oooooooo08koool007_oool010000?ooooooo`0000;oool00ol0VOooooooo`04
oooo00<0003oooooool01?ooo`030000oooooooo08koool007coool200000oooo`03o`2Ioooooooo
00Coool300001?ooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003ooooo
ool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Wooooo
ool02oooo`80002?oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool0
0ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?oo
ooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOoo
ooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>
oooo0021oooo00?o09Woooooool02oooo`80002?oooo0021oooo00?o09Woooooool02oooo`030000
oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2I
oooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo
08koool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo
00_oool20000Soooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o
09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003ooooo
ool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Wooooo
ool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;oooo0P0008ooool0087oool0
0ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?oo
ooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOoo
ooooo`03oooo1@0000?oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool01Oooo`030000
oooooooo00?oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool01Oooo`030000oooooooo
00?oool30000S_ooo`00POooo`03o`2Ioooooooo00Goool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00POooo`03o`2Ioooooooo00Goool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00POooo`03o`2Ioooooooo00Coool200001Oooo`030000oooooooo08koool0087oool00ol0VOoo
ooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>
oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;
oooo0P0008ooool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2I
oooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo
08koool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo
00_oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02oooo`80002?oooo0021oooo00?o
09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003ooooo
ool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Wooooo
ool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_oo
o`00POooo`03o`2Ioooooooo00_oool20000Soooo`00POooo`03o`2Ioooooooo00_oool00`000?oo
ooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOoo
ooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>
oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;
oooo0P0008ooool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2I
oooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo
08koool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00Noooo`D000001?ooool0
V@00000000Coool200001Oooo`030000oooooooo08koool007goool01@000?ooooooooooool0V@05
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00OOooo`050000ooooooooooooo`2I
00Soool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07goool00`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool0
0?oooolQoooo003ooooo8Oooo`00M_ooo`030000oooooooo02koool00`000?ooooooo`1foooo001e
oooo00<0003oooooool02?ooo`030000oooooooo02Goool00`000?ooooooo`1eoooo001eoooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`D00002oooo0P0000Goool300000_oo
o`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02_ooo`040000oooooooo
00000_ooo`050000oooooooooooo000007Ooool007Coool00`000?ooooooo`02oooo00<0003ooooo
ool05Oooo`030000oooooooo00Ooool500001?ooo`030000oooooooo00;oool00`000?ooooooo`1d
oooo001eoooo00<0003oooooool01@0001Coool00`000?ooooooo`07oooo00@0003oooooool00003
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005oooo`030000
oooooooo00Soool00`000?ooo`000003oooo00<0003oooooool00oooo`030000oooooooo07Goool0
07Koool00`000?ooooooo`0Goooo0P0000_oool200000oooo`<00002oooo00<0003oooooool0M_oo
o`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.40095 .24721 L
.42237 .24721 L
.43215 .24721 L
.43755 .24721 L
.44268 .24721 L
.44744 .24721 L
.44874 .24721 L
.45013 .24721 L
.45143 .24721 L
s
.45143 .24721 m
.45161 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.20178 .24721 L
.20742 .24721 L
.21019 .24721 L
.2114 .24721 L
.21274 .24721 L
.21394 .24721 L
.21506 .12361 L
.21625 .12361 L
.21753 .12361 L
.22272 .12361 L
.26394 .12361 L
.30365 .12361 L
.34184 .12361 L
.38249 .12361 L
.42162 .12361 L
.4319 .12361 L
.43731 .12361 L
.44303 .12361 L
.44804 .12361 L
.44941 .12361 L
.45088 .12361 L
.45159 .12361 L
.45227 .12361 L
.45353 .24721 L
.4547 .24721 L
.45594 .24721 L
.45816 .24721 L
.4632 .24721 L
.50095 .24721 L
.54115 .24721 L
.57984 .24721 L
.62098 .24721 L
.66061 .24721 L
.69871 .24721 L
.73927 .24721 L
.77832 .24721 L
.81982 .24721 L
.8598 .24721 L
.89827 .24721 L
.93918 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Aooooc@0I_l01000001Vo`1Vo`0000D0I_l6
oooo00<0003oooooool00_ooo`<0002>oooo0017oooo00<0I_ooooooool0:oooo`@00002oooo00@0
003oooooool00004oooo00<0I_ooooooool00_ooo`800005oooo00<0003oooooool0S_ooo`00Aooo
o`0306Kooooooooo037oool010000?ooooooo`0000Coool00`1Vooooooooo`02oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool004Ooool00`1Vooooooooo`0boooo0P0000Goool00`1Voooo
ooooo`02oooo0`0000Coool00`000?ooooooo`2>oooo0017oooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo00Woool00`000?ooooooo`2>oooo0017oooo00<0I_ooooooool0>Oooo`0306Kooooooooo
00Woool00`000?ooooooo`2>oooo0017oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Woool0
0`000?ooooooo`2>oooo0017oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Woool20000Sooo
o`00Aoooo`0306Kooooooooo03Woool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Aooo
o`0306Kooooooooo03Woool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Aoooo`0306Ko
oooooooo03Woool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Aoooo`0306Kooooooooo
03Woool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Aoooo`0306Kooooooooo03Woool0
0`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Aoooo`0306Kooooooooo03Woool00`1Voooo
ooooo`09oooo0P0008ooool004Ooool00`1Vooooooooo`0ioooo00<0I_ooooooool02Oooo`030000
oooooooo08koool004Ooool00`1Vooooooooo`0ioooo00<0I_ooooooool02Oooo`030000oooooooo
08koool004Koool00`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`030000oooooooo08koool0
04Koool00`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`030000oooooooo08koool004Koool0
0`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`030000oooooooo08koool004Koool00`1Voooo
ooooo`0joooo00<0I_ooooooool02Oooo`80002?oooo0016oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00Woool00`000?ooooooo`2>oooo000Ioooo0`0002[oool00`1Vooooooooo`0;oooo1000
02_oool00`1Vooooooooo`09oooo00<0003oooooool0=oooo`@0000koooo0`0001Goool001[oool0
0`000?ooooooo`0Yoooo00<0I_ooooooool02oooo`030000oooooooo02coool00`1Vooooooooo`09
oooo00<0003oooooool0=oooo`030000oooooooo03goool00`000?ooooooo`0Doooo000Goooo1@00
02[oool00`1Vooooooooo`0<oooo00<0003oooooool0:oooo`0306Kooooooooo00Woool00`000?oo
ooooo`0hoooo00<0003oooooool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?ooooooo`00
02_oool00`1Vooooooooo`05oooo100000Coool00`000?ooooooo`0Zoooo00<0I_ooooooool02Ooo
o`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000Foooo000Hoooo00<0
003oool00000:oooo`0306Kooooooooo00_oool010000?ooooooo`0002_oool00`1Vooooooooo`09
oooo0P0003Soool010000?ooooooo`0003[oool00`000?ooo`00000Foooo000Ioooo0P0002_oool0
0`1Vooooooooo`0<oooo0P0002coool00`1Vooooooooo`09oooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool004Koool00`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`030000oooooooo
08koool004Koool00`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`030000oooooooo08koool0
04Koool00`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`030000oooooooo08koool004Koool0
0`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`030000oooooooo08koool004Koool00`1Voooo
ooooo`0joooo00<0I_ooooooool02Oooo`030000oooooooo08koool0013ooooo00004Oooo`005_oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool010000?oo
ooooool0V@_oool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo01Goool008?oool00ol0VOooooooo`09oooo00<0
003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o
09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003ooooo
ool0S_ooo`00Poooo`03o`2Ioooooooo00Woool20000Soooo`00Poooo`03o`2Ioooooooo00Woool0
0`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool008?oool0
0ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?oo
ooooo`2>oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOoo
ooooo`09oooo0P0008ooool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Pooo
o`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`030000
oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2I
oooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo
08koool008?oool00ol0VOooooooo`09oooo0P0008ooool008?oool00ol0VOooooooo`09oooo00<0
003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o
09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003ooooo
ool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Wooooo
ool02Oooo`80002?oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool008?oool0
0ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?oo
ooooo`2>oooo001loooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00Nooo
o`040000oooooooo00001?ooo`05o`2Ioooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00Noooo`040000oooooooo00001?ooo`03o`2Ioooooooo00Coool00`000?oo
ooooo`02oooo0`0008koool007_oool010000?ooooooo`0000Coool00ol0VOooooooo`02oooo0P00
00Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00004oooo00?o09Woooooool00_oo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001loooo0P0000Goool00ol0VOooooooo`02
oooo0`0000Coool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo
08koool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo
00Woool20000Soooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o
09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003ooooo
ool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Wooooo
ool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_oo
o`00Poooo`03o`2Ioooooooo00Woool20000Soooo`00Poooo`03o`2Ioooooooo00Woool00`000?oo
ooooo`2>oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOoo
ooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>
oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09
oooo0P0008ooool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2I
oooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo
08koool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo
00Woool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`80002?oooo0023oooo00?o
09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003ooooo
ool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00Co09Wooooo
ooooool500000oooo`030000oooooooo08koool008?oool00ol0VOooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo08koool008?oool00ol0VOooooooo`03oooo00<0003oooooool00ooo
o`<0002>oooo0023oooo00?o09Woooooool00oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo0023oooo00?o09Woooooool00oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0023
oooo00?o09Woooooool00_ooo`800005oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo
00Woool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool0
08?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool2
0000Soooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Wooooo
ool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_oo
o`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Ooo
o`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo0P0008ooool008?oool00ol0VOoo
ooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>
oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09
oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023
oooo00?o09Woooooool02Oooo`80002?oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo
08koool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo
00Woool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool0
08?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool2
0000Soooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Wooooo
ool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_oo
o`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo001koooo1@0000;oool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00OOooo`030000oooooooo00?oool01Ol0VOoooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo08koool007goool00`000?ooooooo`03
oooo00?o09Woooooool01?ooo`030000oooooooo00;oool30000S_ooo`00OOooo`030000oooooooo
00Soool20000U_ooo`00OOooo`030000oooooooo00Soool00`000?ooooooo`2Eoooo001loooo0P00
00[oool30000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000
oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo
07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool2
00001Oooo`<00002oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02_ooo`050000
oooooooooooo000007[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000
oooooooo00Ooool500000oooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005?oo
o`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000005oooo`030000oooooooo00Soool00`000?ooo`000003oooo00<0003ooooo
ool0N?ooo`00NOooo`030000oooooooo01Ooool200002oooo`800002oooo00<0003oooooool0NOoo
o`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.40095 .24721 L
.42237 .24721 L
.43215 .24721 L
.44268 .24721 L
.44778 .24721 L
.45262 .24721 L
.45473 .24721 L
.45697 .24721 L
.45826 .24721 L
s
.45826 .24721 m
.45844 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.20178 .24721 L
.20742 .24721 L
.21274 .24721 L
.21753 .24721 L
.21884 .24721 L
.21955 .24721 L
.22022 .24721 L
.22141 .12361 L
.22272 .12361 L
.26149 .12361 L
.30271 .12361 L
.34242 .12361 L
.38061 .12361 L
.40193 .12361 L
.42126 .12361 L
.43094 .12361 L
.44141 .12361 L
.44622 .12361 L
.45129 .12361 L
.45563 .12361 L
.45682 .12361 L
.45809 .12361 L
.45929 .24721 L
.46039 .24721 L
.50023 .24721 L
.53856 .24721 L
.57935 .24721 L
.61861 .24721 L
.65636 .24721 L
.69657 .24721 L
.73525 .24721 L
.77639 .24721 L
.81602 .24721 L
.85413 .24721 L
.89469 .24721 L
.93373 .24721 L
.97523 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00B?oooc<0I_l01000001Vo`1Vo`0000H0I_l5
oooo00<0003oooooool00_ooo`<0002>oooo0018oooo00<0I_ooooooool0:_ooo`@00002oooo00@0
003oooooool00005oooo00@0I_ooooooooooool200001Oooo`030000oooooooo08koool004Soool0
0`1Vooooooooo`0`oooo00@0003oooooool00005oooo00D0I_ooooooooooool000001_ooo`030000
oooooooo08koool004Soool00`1Vooooooooo`0aoooo0P0000Koool0101Vooooooooooooo`<00004
oooo00<0003oooooool0S_ooo`00B?ooo`0306Kooooooooo03Woool00`1Vooooooooo`08oooo00<0
003oooooool0S_ooo`00B?ooo`0306Kooooooooo03Woool00`1Vooooooooo`08oooo00<0003ooooo
ool0S_ooo`00B?ooo`0306Kooooooooo03Woool00`1Vooooooooo`08oooo00<0003oooooool0S_oo
o`00B?ooo`0306Kooooooooo03Woool00`1Vooooooooo`08oooo0P0008ooool004Soool00`1Voooo
ooooo`0ioooo00<0I_ooooooool02?ooo`030000oooooooo08koool004Soool00`1Vooooooooo`0i
oooo00<0I_ooooooool02?ooo`030000oooooooo08koool004Soool00`1Vooooooooo`0ioooo00<0
I_ooooooool02?ooo`030000oooooooo08koool004Soool00`1Vooooooooo`0ioooo00<0I_oooooo
ool02?ooo`030000oooooooo08koool004Soool00`1Vooooooooo`0ioooo00<0I_ooooooool02?oo
o`030000oooooooo08koool004Soool00`1Vooooooooo`0ioooo00<0I_ooooooool02?ooo`80002?
oooo0018oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Soool00`000?ooooooo`2>oooo0018
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Soool00`000?ooooooo`2>oooo0018oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00Soool00`000?ooooooo`2>oooo0018oooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0>_oo
o`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00Ooool20000Soooo`00B?ooo`0306Kooooooooo03[oool00`1Vooooooooo`07oooo00<0
003oooooool0S_ooo`006Oooo`<0000/oooo00<0I_ooooooool02Oooo`@0000]oooo00<0I_oooooo
ool01oooo`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0:ooo
o`0306Kooooooooo00Woool00`000?ooooooo`0^oooo00<0I_ooooooool01oooo`030000oooooooo
03Ooool00`000?ooooooo`0moooo00<0003oooooool05?ooo`005oooo`D0000/oooo00<0I_oooooo
ool02_ooo`030000oooooooo02goool00`1Vooooooooo`07oooo00<0003oooooool0>?ooo`030000
oooooooo03Woool500005Oooo`004Oooo`@00002oooo00@0003oooooool0000]oooo00<0I_oooooo
ool00oooo`@00004oooo00<0003oooooool0;?ooo`0306Kooooooooo00Ooool00`000?ooooooo`0i
oooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000oooo000002goool0
0`1Vooooooooo`09oooo00@0003oooooool0000]oooo00<0I_ooooooool01oooo`80000hoooo00@0
003oooooool0000joooo00<0003oool000005_ooo`006Oooo`80000]oooo00<0I_ooooooool02_oo
o`80000^oooo00<0I_ooooooool01oooo`030000oooooooo03Soool20000??ooo`80000Foooo0018
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo0018oooo00<0
I_ooooooool0>_ooo`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo0018oooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0>_oo
o`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00Ooool00`000?ooooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00D0003ooooooooooooo09T02_oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>
oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08
oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024
oooo00?o09Woooooool02?ooo`80002?oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo
08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo
00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool0
08Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool2
0000Soooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Wooooo
ool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_oo
o`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?oo
o`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?oo
o`03o`2Ioooooooo00Soool20000Soooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>
oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08
oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024
oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo0P00
08ooool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo
00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool0
07coool200001?ooo`8000001?l0VOooooooooooo`800005oooo00<0003oooooool0S_ooo`00Nooo
o`040000oooooooo00001Oooo`04o`2Ioooooooo00000_ooo`030000oooooooo00;oool00`000?oo
ooooo`2>oooo001koooo00@0003oooooool00005oooo00?o09Woooooool00oooo`030000oooooooo
00;oool30000S_ooo`00Noooo`040000oooooooo00001Oooo`04o`2Ioooooooooooo0P0000Goool0
0`000?ooooooo`2>oooo001koooo00@0003oooooool00005oooo00Go09Woooooooooool000001_oo
o`030000oooooooo08koool007coool200001_ooo`04o`2Ioooooooooooo0`0000Coool00`000?oo
ooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOoo
ooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool20000Soooo`00Q?oo
o`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000
oooooooo08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2I
oooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo
08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo
00Soool20000Soooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o
09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo00<0003ooooo
ool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Wooooo
ool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo0P0008ooool008Coool0
0ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?oo
ooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOoo
ooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>
oooo0024oooo00?o09Woooooool02?ooo`80002?oooo0024oooo00?o09Woooooool02?ooo`030000
oooooooo08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2I
oooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool01@0000?oool00`000?oo
ooooo`2>oooo0024oooo00?o09Woooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo0024oooo00?o09Woooooool00_ooo`030000oooooooo00?oool30000S_ooo`00Q?ooo`03o`2I
oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo
00;oool00`000?ooooooo`03oooo00<0003oooooool0S_ooo`00Q?ooo`04o`2Ioooooooooooo0P00
00Goool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool0
08Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool0
0`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`80002?oooo0024oooo00?o09Wooooo
ool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_oo
o`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?oo
o`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?oo
o`03o`2Ioooooooo00Soool20000Soooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>
oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08
oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024
oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo0P00
08ooool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo
00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool0
08Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool0
0`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`80002?oooo0024oooo00?o09Wooooo
ool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_oo
o`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?oo
o`030000oooooooo08koool007_oool500000_ooo`8000001?l0VOooooooooooo`800005oooo00<0
003oooooool0S_ooo`00OOooo`030000oooooooo00Coool01?l0VOooooooo`0000;oool00`000?oo
ooooo`02oooo00<0003oooooool0S_ooo`00OOooo`030000oooooooo00Coool00ol0VOooooooo`03
oooo00<0003oooooool00_ooo`<0002>oooo001moooo00<0003oooooool02?ooo`80002Foooo001m
oooo00<0003oooooool02?ooo`030000oooooooo09Goool007coool200002_ooo`<0002Eoooo003o
oooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOoo
o`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00coool500000_ooo`800004oooo0P0000Coool2
00001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo00Ooool010000?ooooooo`00
00;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003oooooool00_oo
o`030000oooooooo01Goool00`000?ooooooo`09oooo00<0003oooooool01?ooo`030000oooooooo
00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001Coool00`000?ooooooo`0:
oooo00@0003oooooooooool200001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`00000Goooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo00?oool0
0`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0P0000Coool300000_oo
o`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.44268 .24721 L
.45262 .24721 L
.45734 .24721 L
.46172 .24721 L
.46283 .24721 L
.46388 .24721 L
s
.46388 .24721 m
.46406 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.20342 .24721 L
.21345 .24721 L
.21786 .24721 L
.22037 .24721 L
.22272 .24721 L
.22387 .24721 L
.22496 .24721 L
.22623 .12361 L
.22738 .12361 L
.23233 .12361 L
.24276 .12361 L
.26171 .12361 L
.2999 .12361 L
.34055 .12361 L
.37968 .12361 L
.42126 .12361 L
.44213 .12361 L
.45128 .12361 L
.45613 .12361 L
.4588 .12361 L
.46133 .12361 L
.4625 .12361 L
.46376 .12361 L
.46441 .24721 L
.46513 .24721 L
.4664 .24721 L
.47102 .24721 L
.48007 .24721 L
.49988 .24721 L
.54008 .24721 L
.57877 .24721 L
.61991 .24721 L
.65953 .24721 L
.69764 .24721 L
.7382 .24721 L
.77725 .24721 L
.81874 .24721 L
.85873 .24721 L
.89719 .24721 L
.93811 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00B_oooc40I_l01000001Vo`1Vo`0000P0I_l3
oooo00<0003oooooool00_ooo`<0002>oooo001:oooo00<0I_ooooooool0:?ooo`@00002oooo00@0
003oooooool00007oooo00@0I_ooool000000005oooo00<0003oooooool0S_ooo`00B_ooo`0306Ko
oooooooo02koool010000?ooooooo`0000Ooool00`1Vooooo`000006oooo00<0003oooooool0S_oo
o`00B_ooo`0306Kooooooooo02ooool200002?ooo`0306Kooooo000000800004oooo00<0003ooooo
ool0S_ooo`00B_ooo`0306Kooooooooo03Woool00`1Vooooooooo`06oooo00<0003oooooool0S_oo
o`00B_ooo`0306Kooooooooo03Woool00`1Vooooooooo`06oooo00<0003oooooool0S_ooo`00B_oo
o`0306Kooooooooo03Woool00`1Vooooooooo`06oooo00<0003oooooool0S_ooo`00B_ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`06oooo0P0008ooool004[oool00`1Vooooooooo`0ioooo00<0
I_ooooooool01_ooo`030000oooooooo08koool004[oool00`1Vooooooooo`0ioooo00<0I_oooooo
ool01_ooo`030000oooooooo08koool004[oool00`1Vooooooooo`0ioooo00<0I_ooooooool01_oo
o`030000oooooooo08koool004[oool00`1Vooooooooo`0ioooo00<0I_ooooooool01_ooo`030000
oooooooo08koool004[oool00`1Vooooooooo`0ioooo00<0I_ooooooool01_ooo`030000oooooooo
08koool004[oool00`1Vooooooooo`0ioooo00<0I_ooooooool01_ooo`80002?oooo001:oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo001:oooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0>_oo
o`0306Kooooooooo00Koool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00Koool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0>_ooo`0306Kooooooooo
00Koool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Koool2
0000Soooo`00BOooo`0306Kooooooooo03[oool00`1Vooooooooo`06oooo00<0003oooooool0S_oo
o`006Oooo`<0000]oooo00<0I_ooooooool02?ooo`@0000^oooo00<0I_ooooooool01_ooo`030000
oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0;?ooo`0306Kooooooooo
00Soool00`000?ooooooo`0_oooo00<0I_ooooooool01_ooo`030000oooooooo03Ooool00`000?oo
ooooo`0moooo00<0003oooooool05?ooo`005oooo`D0000]oooo00<0I_ooooooool02Oooo`030000
oooooooo02koool00`1Vooooooooo`06oooo00<0003oooooool0>?ooo`030000oooooooo03Woool5
00005Oooo`004Oooo`@00002oooo00@0003oooooool0000^oooo00<0I_ooooooool00_ooo`@00004
oooo00<0003oooooool0;Oooo`0306Kooooooooo00Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000oooo000002koool00`1Vooooooooo`08
oooo00@0003oooooool0000^oooo00<0I_ooooooool01_ooo`80000hoooo00@0003oooooool0000j
oooo00<0003oool000005_ooo`006Oooo`80000^oooo00<0I_ooooooool02Oooo`80000_oooo00<0
I_ooooooool01_ooo`030000oooooooo03Soool20000??ooo`80000Foooo0019oooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0>_oo
o`0306Kooooooooo00Koool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00Koool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0>_ooo`0306Kooooooooo
00Koool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Koool0
0`000?ooooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool00oooo`03o`2Ioooooooo00Koool0
0`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo01Goool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_oo
o`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_oo
o`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_oo
o`03o`2Ioooooooo00Koool20000Soooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>
oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06
oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026
oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo0P00
08ooool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo
00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool0
08Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool0
0`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool0
0ol0VOooooooo`06oooo0P0008ooool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_oo
o`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_oo
o`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_oo
o`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`80002?
oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06
oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo001l
oooo0P0000Coool200000_ooo`04o`2Ioooo000000001Oooo`030000oooooooo08koool007_oool0
10000?ooooooo`0000Ooool01Ol0V@000?ooooooo`000004oooo00<0003oooooool0S_ooo`00Nooo
o`040000oooooooo00001oooo`05o`2Ioooooooooooo000000Coool30000S_ooo`00Noooo`040000
oooooooo00001oooo`04o`2Ioooo000000001Oooo`030000oooooooo08koool007_oool010000?oo
ooooo`0000Ooool00ol0VOooo`000006oooo00<0003oooooool0S_ooo`00O?ooo`800008oooo00?o
09Woool000000P0000Coool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000
oooooooo08koool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2I
oooooooo00Koool20000Soooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026
oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo00<0
003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o
09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo00<0003ooooo
ool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool20000Soooo`00Q_ooo`03o`2Ioooooooo00Koool0
0`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool0
0ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?oo
ooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOoo
ooooo`06oooo0P0008ooool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_oo
o`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000
oooooooo08koool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2I
oooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`80002?oooo0026
oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo00<0
003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o
09T0000000000`0000?oool00`000?ooooooo`2>oooo0026oooo00Co09Woooooool00005oooo00<0
003oooooool0S_ooo`00Q_ooo`04o`2Ioooooooo00001Oooo`<0002>oooo0026oooo00Co09Wooooo
ool00005oooo00<0003oooooool0S_ooo`00Q_ooo`04o`2Ioooooooo00001Oooo`030000oooooooo
08koool008Koool01?l0VOooo`00000000Goool00`000?ooooooo`2>oooo0026oooo00?o09Wooooo
ool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_oo
o`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_oo
o`80002?oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOoo
ooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>
oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06
oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool20000Soooo`00Q_ooo`03o`2I
oooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo
08koool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo
00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool0
08Koool00ol0VOooooooo`06oooo0P0008ooool008Koool00ol0VOooooooo`06oooo00<0003ooooo
ool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Wooooo
ool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_oo
o`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_oo
o`80002?oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOoo
ooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>
oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool007_oool500000_ooo`800002
oooo00Co09Woool000000005oooo00<0003oooooool0S_ooo`00OOooo`030000oooooooo00Koool0
1Ol0V@000?ooooooo`000004oooo00<0003oooooool0S_ooo`00OOooo`030000oooooooo00Koool0
1Ol0VOooooooooooo`000004oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07goool00`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool0
0?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001h
oooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`D00002oooo0P0000Coool200001?oo
o`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400001Oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool0
0`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?oo
ooooo`09oooo00<0003oooooool00oooo`030000oooooooo07Ooool007Soool00`000?ooooooo`05
00005?ooo`030000oooooooo00[oool01@000?ooooooooooo`00001joooo001hoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1h
oooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003o
oooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.44268 .24721 L
.45262 .24721 L
.46172 .24721 L
.46618 .24721 L
.46741 .24721 L
.46871 .24721 L
.46994 .24721 L
s
.46994 .24721 m
.47011 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.20342 .24721 L
.21345 .24721 L
.22272 .24721 L
.22738 .24721 L
.22974 .24721 L
.23038 .24721 L
.23107 .24721 L
.23233 .12361 L
.23302 .12361 L
.23366 .12361 L
.23512 .12361 L
.23778 .12361 L
.24276 .12361 L
.26171 .12361 L
.30084 .12361 L
.34242 .12361 L
.38249 .12361 L
.42104 .12361 L
.44059 .12361 L
.45094 .12361 L
.45664 .12361 L
.46204 .12361 L
.46716 .12361 L
.46856 .12361 L
.46933 .12361 L
.47005 .12361 L
.47132 .24721 L
.472 .24721 L
.47272 .24721 L
.48246 .24721 L
.50153 .24721 L
.54267 .24721 L
.58229 .24721 L
.6204 .24721 L
.66096 .24721 L
.70001 .24721 L
.74151 .24721 L
.78149 .24721 L
.81995 .24721 L
.86087 .24721 L
.90028 .24721 L
.93816 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Booooc00I_l01000001Vo`1Vo`0000T0I_l2
oooo00<0003oooooool00_ooo`<0002>oooo001;oooo00<0I_ooooooool09oooo`@00002oooo00@0
003oooooool00008oooo00<0I_l0000000001Oooo`030000oooooooo08koool004_oool00`1Voooo
ooooo`0]oooo00@0003oooooool00008oooo00<0I_l0003oool01Oooo`030000oooooooo08koool0
04_oool00`1Vooooooooo`0^oooo0P0000Woool0101Vo`000000000000Coool00`000?ooooooo`2>
oooo001;oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Goool00`000?ooooooo`2>oooo001;
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Goool00`000?ooooooo`2>oooo001;oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00Goool00`000?ooooooo`2>oooo001;oooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo00Goool20000Soooo`00Boooo`0306Kooooooooo03Woool00`1Voooo
ooooo`05oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo03Woool00`1Vooooooooo`05
oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo03Woool00`1Vooooooooo`05oooo00<0
003oooooool0S_ooo`00Boooo`0306Kooooooooo03Woool00`1Vooooooooo`05oooo00<0003ooooo
ool0S_ooo`00Boooo`0306Kooooooooo03Woool00`1Vooooooooo`05oooo00<0003oooooool0S_oo
o`00Boooo`0306Kooooooooo03Woool00`1Vooooooooo`05oooo0P0008ooool004_oool00`1Voooo
ooooo`0ioooo00<0I_ooooooool01Oooo`030000oooooooo08koool004_oool00`1Vooooooooo`0i
oooo00<0I_ooooooool01Oooo`030000oooooooo08koool004_oool00`1Vooooooooo`0ioooo00<0
I_ooooooool01Oooo`030000oooooooo08koool004_oool00`1Vooooooooo`0joooo00<0I_oooooo
ool01?ooo`030000oooooooo08koool004_oool00`1Vooooooooo`0joooo00<0I_ooooooool01?oo
o`030000oooooooo08koool004_oool00`1Vooooooooo`0joooo00<0I_ooooooool01?ooo`80002?
oooo001;oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Coool00`000?ooooooo`2>oooo000I
oooo0`0002ooool00`1Vooooooooo`06oooo1000033oool00`1Vooooooooo`04oooo00<0003ooooo
ool0=oooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0^oooo00<0I_ooooooool01_oo
o`030000oooooooo037oool00`1Vooooooooo`04oooo00<0003oooooool0=oooo`030000oooooooo
03goool00`000?ooooooo`0Doooo000Goooo1@0002ooool00`1Vooooooooo`07oooo00<0003ooooo
ool0<?ooo`0306Kooooooooo00Coool00`000?ooooooo`0hoooo00<0003oooooool0>Oooo`D0000E
oooo000Aoooo100000;oool010000?ooooooo`00033oool00`1Vooooooooo`0400001?ooo`030000
oooooooo02ooool00`1Vooooooooo`04oooo00<0003oooooool0>Oooo`030000oooooooo03Soool0
10000?ooooooo`0001Koool001Soool00`000?ooo`00000`oooo00<0I_ooooooool01_ooo`040000
oooooooo0000<?ooo`0306Kooooooooo00Coool20000>?ooo`040000oooooooo0000>_ooo`030000
oooo000001Koool001Woool20000<?ooo`0306Kooooooooo00Ooool20000<Oooo`0306Kooooooooo
00Coool00`000?ooooooo`0hoooo0P0003coool200005_ooo`00Boooo`0306Kooooooooo03[oool0
0`1Vooooooooo`04oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo03[oool00`1Voooo
ooooo`04oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo03[oool00`1Vooooooooo`04
oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo03[oool00`1Vooooooooo`04oooo00<0
003oooooool0S_ooo`00Boooo`0306Kooooooooo03[oool00`1Vooooooooo`04oooo00<0003ooooo
ool0S_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool0
0`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00Coool00ol0VOooooooo`05oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool0
0`000?ooooooo`0Eoooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool0
0ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?oo
ooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOoo
ooooo`05oooo0P0008ooool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qooo
o`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000
oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2I
oooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`80002?oooo0027
oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0
003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o
09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003ooooo
ool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Wooooo
ool01Oooo`80002?oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool0
0ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?oo
ooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOoo
ooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool20000Soooo`00Qooo
o`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000
oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00O?ooo`800004
oooo0P0000?oool00ol0V@0000000005oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo
00002?ooo`040000oooooooo00001?ooo`030000oooooooo08koool007_oool010000?ooooooo`00
00Soool01?l0VOooooooo`0000Coool30000S_ooo`00Noooo`040000oooooooo00002?ooo`03o`2I
0000000000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00?o09T0003o
ool01Oooo`030000oooooooo08koool007coool200002Oooo`04o`2I0000000000001?ooo`030000
oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2I
oooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`80002?oooo0027
oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0
003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o
09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003ooooo
ool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Wooooo
ool01Oooo`80002?oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool0
0ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?oo
ooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOoo
ooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool20000Soooo`00Qooo
o`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000
oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2I
oooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo
08koool008Ooool00ol0VOooooooo`05oooo0P0008ooool008Ooool00ol0VOooooooo`05oooo00<0
003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o
09Woooooool01Oooo`030000oooooooo08koool008Ooool500000oooo`030000oooooooo08koool0
08Ooool00ol0VOooo`000005oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooo000000Goool3
0000S_ooo`00Qoooo`03o`2Ioooo000000Goool00`000?ooooooo`2>oooo0027oooo00?o09Woool0
00001Oooo`030000oooooooo08koool008Ooool00ol0V@0000000005oooo00<0003oooooool0S_oo
o`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Ooo
o`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qooo
o`03o`2Ioooooooo00Goool20000Soooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>
oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05
oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027
oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo0P00
08ooool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo
00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool0
08Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool0
0`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`80002?oooo0027oooo00?o09Wooooo
ool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_oo
o`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Ooo
o`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qooo
o`03o`2Ioooooooo00Goool20000Soooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>
oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05
oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo001k
oooo1@0000;oool200000oooo`03o`2I0000000000Goool00`000?ooooooo`2>oooo001moooo00<0
003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo08koool007goool00`000?oo
ooooo`07oooo00Co09Woooooool00004oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007goool00`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?ooo`80000:oooo0`00
09Goool00?oooolQoooo003ooooo8Oooo`00M_ooo`030000oooooooo02koool00`000?ooooooo`1f
oooo001eoooo00<0003oooooool02?ooo`030000oooooooo02Goool00`000?ooooooo`1eoooo001e
oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`D00002oooo0P0000?oool4
00000oooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`030000
oooooooo00?oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003ooooo
ool00_ooo`030000oooooooo01Goool00`000?ooooooo`08oooo00<0003oooooool01Oooo`030000
oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001Coool00`000?oo
ooooo`09oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000
oooooooooooo000001Ooool00`000?ooooooo`07oooo00@0003oooooool00003oooo00<0003ooooo
ool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool200001?oo
o`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.44268 .24721 L
.45262 .24721 L
.46172 .24721 L
.46618 .24721 L
.47106 .24721 L
.47329 .24721 L
.47451 .24721 L
.47567 .24721 L
s
.47567 .24721 m
.47583 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.20342 .24721 L
.22272 .24721 L
.23233 .24721 L
.23496 .24721 L
.2364 .24721 L
.23711 .24721 L
.23775 .24721 L
.2389 .12361 L
.24014 .12361 L
.24276 .12361 L
.26171 .12361 L
.30142 .12361 L
.33961 .12361 L
.38026 .12361 L
.41939 .12361 L
.43936 .12361 L
.44987 .12361 L
.46097 .12361 L
.46577 .12361 L
.47092 .12361 L
.47243 .12361 L
.47387 .12361 L
.47516 .12361 L
.47589 .12361 L
.47656 .24721 L
.47778 .24721 L
.47912 .24721 L
.48184 .24721 L
.50104 .24721 L
.54124 .24721 L
.57993 .24721 L
.62107 .24721 L
.66069 .24721 L
.6988 .24721 L
.73936 .24721 L
.7784 .24721 L
.8199 .24721 L
.85988 .24721 L
.89835 .24721 L
.93927 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00COooobh0I_l01000001Vo`1Vo`0000/0I_l0
0`000?ooooooo`02oooo0`0008koool004goool00`1Vooooooooo`0Uoooo100000;oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool004goool00`1Vooooooooo`0[oooo00@0
003oooooool00009oooo00<00000I_ooool01?ooo`030000oooooooo08koool004goool00`1Voooo
ooooo`0/oooo0P0000[oool300001?ooo`030000oooooooo08koool004goool00`1Vooooooooo`0i
oooo00<0I_ooooooool00oooo`030000oooooooo08koool004goool00`1Vooooooooo`0ioooo00<0
I_ooooooool00oooo`030000oooooooo08koool004goool00`1Vooooooooo`0ioooo00<0I_oooooo
ool00oooo`030000oooooooo08koool004goool00`1Vooooooooo`0ioooo00<0I_ooooooool00ooo
o`80002?oooo001=oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>
oooo001=oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001=
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001=oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001=oooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001=oooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo00?oool20000Soooo`00COooo`0306Kooooooooo03Woool00`1Vooooooooo`03
oooo00<0003oooooool0S_ooo`00COooo`0306Kooooooooo03Woool00`1Vooooooooo`03oooo00<0
003oooooool0S_ooo`00C?ooo`0306Kooooooooo03[oool00`1Vooooooooo`03oooo00<0003ooooo
ool0S_ooo`00C?ooo`0306Kooooooooo03[oool00`1Vooooooooo`03oooo00<0003oooooool0S_oo
o`00C?ooo`0306Kooooooooo03[oool00`1Vooooooooo`03oooo00<0003oooooool0S_ooo`00C?oo
o`0306Kooooooooo03[oool00`1Vooooooooo`03oooo0P0008ooool004coool00`1Vooooooooo`0j
oooo00<0I_ooooooool00oooo`030000oooooooo08koool001Woool30000<?ooo`0306Kooooooooo
00Goool40000<Oooo`0306Kooooooooo00?oool00`000?ooooooo`0goooo100003_oool300005Ooo
o`006_ooo`030000oooooooo02ooool00`1Vooooooooo`05oooo00<0003oooooool0<_ooo`0306Ko
oooooooo00?oool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool0
01Ooool50000<?ooo`0306Kooooooooo00Koool00`000?ooooooo`0aoooo00<0I_ooooooool00ooo
o`030000oooooooo03Soool00`000?ooooooo`0ioooo1@0001Goool0017oool400000_ooo`040000
oooooooo0000<Oooo`0306Kooooo000000<00004oooo00<0003oooooool0<?ooo`0306Kooooooooo
00?oool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?oo
o`030000oooo0000037oool00`1Vooooooooo`05oooo00@0003oooooool0000aoooo00<0I_oooooo
ool00oooo`80000hoooo00@0003oooooool0000joooo00<0003oool000005_ooo`006Oooo`80000a
oooo00<0I_ooooooool01_ooo`80000boooo00<0I_ooooooool00oooo`030000oooooooo03Soool2
0000??ooo`80000Foooo001<oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00?oool00`000?oo
ooooo`2>oooo001<oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00?oool00`000?ooooooo`2>
oooo001<oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001<
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001<oooo00<0
I_ooooooool0>_ooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo000@ooooo`00017oool0
01Koool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool01_ooo`03o`2Ioooooooo00?oool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool008Woool0
0ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?oo
ooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool008Woool00ol0VOoo
ooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool20000Soooo`00ROoo
o`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000
oooooooo08koool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2I
oooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000oooooooo
08koool008Woool00ol0VOooooooo`03oooo0P0008ooool008Woool00ol0VOooooooo`03oooo00<0
003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o
09Woooooool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03oooo00<0003ooooo
ool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o09Wooooo
ool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03oooo0P0008ooool008Woool0
0ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?oo
ooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool008Woool00ol0VOoo
ooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>
oooo0029oooo00?o09Woooooool00oooo`80002?oooo0029oooo00?o09Woooooool00oooo`030000
oooooooo08koool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2I
oooooooo00?oool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000ooooo`2I00001?ooo`030000
oooooooo08koool007_oool010000?ooooooo`0000[oool00ol0V@000?ooo`03oooo0`0008koool0
07_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool007_oool010000?oo
ooooo`0000Woool00`000?l0VOooo`04oooo00<0003oooooool0S_ooo`00O?ooo`80000:oooo0`00
00Coool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool0
08Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool2
0000Soooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o09Wooooo
ool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00ooo
o`030000oooooooo08koool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROoo
o`03o`2Ioooooooo00?oool20000Soooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>
oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03
oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029
oooo00?o09Woooooool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03oooo0P00
08ooool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo
00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool0
08Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool0
0`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`80002?oooo0029oooo00?o09Wooooo
ool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0027oooo1@0000?oool00`000?oo
ooooo`2>oooo0029oooo00<0003oooooool00oooo`030000oooooooo08koool008Woool00`000?oo
ooooo`03oooo0`0008koool008Woool00`000?ooooooo`03oooo00<0003oooooool0S_ooo`00ROoo
o`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?ooooooo`2>
oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03
oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029
oooo00?o09Woooooool00oooo`80002?oooo0029oooo00?o09Woooooool00oooo`030000oooooooo
08koool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo
00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool0
08Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool2
0000Soooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o09Wooooo
ool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00ooo
o`030000oooooooo08koool008Woool00ol0VOooooooo`03oooo0P0008ooool008Woool00ol0VOoo
ooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>
oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03
oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029
oooo00?o09Woooooool00oooo`80002?oooo0029oooo00?o09Woooooool00oooo`030000oooooooo
08koool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo
00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool0
07_oool500000_ooo`800004oooo0P0000Goool00`000?ooooooo`2>oooo001moooo00<0003ooooo
ool01oooo`040000ooooo`2I00001?ooo`030000oooooooo08koool007goool00`000?ooooooo`09
oooo00?o09T0003oool00oooo`<0002>oooo001moooo00<0003oooooool02?ooo`80002Foooo001m
oooo00<0003oooooool02?ooo`030000oooooooo09Goool007coool200002_ooo`<0002Eoooo003o
oooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?oo
o`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00coool500000_ooo`800003oooo100000?oool0
0`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00<0003oooooool01?ooo`030000
oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000oooooooo
00Soool00`000?ooooooo`04oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000D
oooo00<0003oooooool02Oooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1i
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.44268 .24721 L
.46172 .24721 L
.47106 .24721 L
.47567 .24721 L
.47791 .24721 L
.47994 .24721 L
.48116 .24721 L
s
.48116 .24721 m
.48134 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.20342 .24721 L
.22272 .24721 L
.23233 .24721 L
.23739 .24721 L
.24016 .24721 L
.24152 .24721 L
.24276 .24721 L
.24392 .24721 L
.24502 .12361 L
.24618 .12361 L
.24745 .12361 L
.25261 .12361 L
.26171 .12361 L
.30236 .12361 L
.34148 .12361 L
.38307 .12361 L
.42313 .12361 L
.46168 .12361 L
.472 .12361 L
.47703 .12361 L
.47923 .12361 L
.48039 .12361 L
.48162 .12361 L
.48292 .24721 L
.48411 .24721 L
.48647 .24721 L
.49166 .24721 L
.50269 .24721 L
.54044 .24721 L
.58064 .24721 L
.61933 .24721 L
.66047 .24721 L
.70009 .24721 L
.7382 .24721 L
.77876 .24721 L
.81781 .24721 L
.85931 .24721 L
.89929 .24721 L
.93775 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00C_ooobd0I_l01000001Vo`1Vo`0000/0I_l0
0`000?ooooooo`02oooo0`0008koool004koool00`1Vooooooooo`0Toooo100000;oool010000?oo
ooooo`0000Woool2000000<0I_ooooooool00_ooo`030000oooooooo08koool004koool00`1Voooo
ooooo`0Zoooo00@0003oooooool00009oooo00<0003oool0I_l01?ooo`030000oooooooo08koool0
04koool00`1Vooooooooo`0[oooo0P0000[oool300001?ooo`030000oooooooo08koool004koool0
0`1Vooooooooo`0ioooo00<0I_ooooooool00_ooo`030000oooooooo08koool004koool00`1Voooo
ooooo`0ioooo00<0I_ooooooool00_ooo`030000oooooooo08koool004koool00`1Vooooooooo`0i
oooo00<0I_ooooooool00_ooo`030000oooooooo08koool004koool00`1Vooooooooo`0ioooo00<0
I_ooooooool00_ooo`80002?oooo001>oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00;oool0
0`000?ooooooo`2>oooo001>oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00;oool00`000?oo
ooooo`2>oooo001>oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00;oool00`000?ooooooo`2>
oooo001>oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00;oool00`000?ooooooo`2>oooo001>
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00;oool00`000?ooooooo`2>oooo001>oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00;oool20000Soooo`00C_ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`02oooo00<0003oooooool0S_ooo`00C_ooo`0306Kooooooooo03Woool00`1Voooo
ooooo`02oooo00<0003oooooool0S_ooo`00C_ooo`0306Kooooooooo03Woool00`1Vooooooooo`02
oooo00<0003oooooool0S_ooo`00C_ooo`0306Kooooooooo03[oool01@1Vooooooooooooo`00002@
oooo001>oooo00<0I_ooooooool0>_ooo`0506Kooooooooooooo0000093oool004koool00`1Voooo
ooooo`0joooo00@0I_ooooooooooool20000Soooo`00C_ooo`0306Kooooooooo03[oool01@1Voooo
ooooooooo`00002@oooo000Ioooo0`0003;oool00`1Vooooooooo`03oooo100003?oool01@1Voooo
ooooooooo`00000ioooo100003_oool300005Oooo`006_ooo`030000oooooooo037oool00`1Voooo
ooooo`03oooo00<0003oooooool0=?ooo`0506Kooooooooooooo000003Woool00`000?ooooooo`0m
oooo00<0003oooooool05?ooo`005oooo`D0000boooo00<0I_ooooooool01?ooo`030000oooooooo
03?oool01@1Vooooooooooooo`00000joooo00<0003oooooool0>Oooo`D0000Eoooo000Aoooo1000
00;oool010000?ooooooo`0003?oool400001?ooo`030000oooooooo03;oool01@1Voooooooooooo
o`00000koooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000oooo0000
03?oool00`1Vooooooooo`03oooo00@0003oooooool0000coooo00@0I_ooooooooooool20000>?oo
o`040000oooooooo0000>_ooo`030000oooo000001Koool001Woool20000<oooo`0306Kooooooooo
00Coool20000=?ooo`0506Kooooooooooooo000003[oool20000??ooo`80000Foooo001>oooo00<0
I_ooooooool0>_ooo`0506Kooooooooooooo0000093oool004koool00`1Vooooooooo`0joooo00D0
I_ooooooooooool00000T?ooo`00C_ooo`0306Kooooooooo03[oool01@1Vooooooooooooo`00002@
oooo001>oooo00<0I_ooooooool0>_ooo`0506Kooooooooooooo0000093oool004koool00`1Voooo
ooooo`0joooo00D0I_ooooooooooool00000T?ooo`004?ooool0000Aoooo000Foooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00Ooool0
0ol0VOooooooo`02oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0Eoooo002:oooo00?o09Woooooool00_oo
o`030000oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_oo
o`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000
oooooooo08koool008[oool00ol0VOooooooo`02oooo0P0008ooool008[oool00ol0VOooooooo`02
oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:
oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0
003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o
09Woooooool00_ooo`80002?oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool0
08[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool0
0`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool0
0ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?oo
ooooo`2>oooo002:oooo00?o09Woooooool00_ooo`80002?oooo002:oooo00?o09Woooooool00_oo
o`030000oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_oo
o`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000
oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2I
oooooooo00;oool20000Soooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:
oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0
003oooooool0S_ooo`00O?ooo`800004oooo0P0000Coool2000000?o09Woooooool00_ooo`030000
oooooooo08koool007_oool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo001koooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`<0002>oooo001k
oooo00@0003oooooool00009oooo0P000003o`2Ioooooooo00;oool00`000?ooooooo`2>oooo001k
oooo00@0003oooooool00009oooo00<0003ooooo09T01?ooo`030000oooooooo08koool007coool2
00002_ooo`<00004oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?oo
ooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOoo
ooooo`02oooo0P0008ooool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_oo
o`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000
oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2I
oooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo
08koool008[oool00ol0VOooooooo`02oooo0P0008ooool008[oool00ol0VOooooooo`02oooo00<0
003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o
09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0003ooooo
ool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Wooooo
ool00_ooo`80002?oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool0
0ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?oo
ooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOoo
ooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool20000Soooo`00R_oo
o`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000
oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00Qoooo`D00003
oooo00<0003oooooool0S_ooo`00ROooo`030000o`2Ioooo00?oool00`000?ooooooo`2>oooo0029
oooo00<0003o09Woool00oooo`<0002>oooo0029oooo00<0003o09Woool00oooo`030000oooooooo
08koool008Woool00`000?l0VOooo`03oooo00<0003oooooool0S_ooo`00R?ooo`8000000ol0VOoo
ooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>
oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOooooooo`02
oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool20000Soooo`00R_ooo`03o`2I
oooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo
08koool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo
00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool0
08[oool00ol0VOooooooo`02oooo0P0008ooool008[oool00ol0VOooooooo`02oooo00<0003ooooo
ool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Wooooo
ool00_ooo`030000oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_oo
o`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_oo
o`80002?oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOoo
ooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>
oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOooooooo`02
oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool20000Soooo`00R_ooo`03o`2I
oooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo
08koool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo
00;oool00`000?ooooooo`2>oooo001koooo1@0000;oool200001?ooo`8000000ol0VOooooooo`02
oooo00<0003oooooool0S_ooo`00OOooo`030000oooooooo00Ooool010000?ooooooo`0000Coool0
0`000?ooooooo`2>oooo001moooo00<0003oooooool02_ooo`030000oooooooo00;oool30000S_oo
o`00OOooo`030000oooooooo00Soool20000U_ooo`00OOooo`030000oooooooo00Soool00`000?oo
ooooo`2Eoooo001loooo0P0000[oool30000UOooo`00ooooob7oool00?oooolQoooo001foooo00<0
003oooooool0;_ooo`030000oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0003ooooo
ool09Oooo`030000oooooooo07Goool007Goool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`0<oooo1@0000;oool200000oooo`D00002oooo0P0000Coool00`000?ooooooo`1eoooo001e
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo1000
00Goool00`000?ooooooo`09oooo00D0003oooooooooool000000_ooo`050000oooooooooooo0000
07Ooool007Coool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000oooooooo00Woool0
0`000?ooooooo`04oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?oo
ooooo`0500005?ooo`030000oooooooo00Woool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`1eoooo001eoooo00D0003oooooooooool000005oooo`030000oooooooo00Woool00`000?oo
ooooo`02oooo00<0003oooooool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0G
oooo0P0000[oool200001?ooo`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQ
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.44268 .24721 L
.46172 .24721 L
.47106 .24721 L
.47994 .24721 L
.48484 .24721 L
.48618 .24721 L
.48692 .24721 L
.48761 .24721 L
s
.48761 .24721 m
.48771 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.20342 .24721 L
.22272 .24721 L
.23233 .24721 L
.23739 .24721 L
.24276 .24721 L
.24502 .24721 L
.24745 .24721 L
.24816 .24721 L
.24884 .24721 L
.25012 .12361 L
.25131 .12361 L
.25261 .12361 L
.26171 .12361 L
.30236 .12361 L
.34148 .12361 L
.38307 .12361 L
.42313 .12361 L
.46168 .12361 L
.472 .12361 L
.48162 .12361 L
.48411 .12361 L
.48647 .12361 L
.48777 .12361 L
.48851 .24721 L
.48919 .24721 L
.49166 .24721 L
.50269 .24721 L
.54195 .24721 L
.5797 .24721 L
.61991 .24721 L
.65859 .24721 L
.69973 .24721 L
.73936 .24721 L
.77747 .24721 L
.81803 .24721 L
.85707 .24721 L
.89857 .24721 L
.93855 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00D?ooob/0I_l01000001Vo`1Vo`0000/0I_l0
0`00001Vo`1Vo`02oooo0`0008koool0053oool00`1Vooooooooo`0Roooo100000;oool010000?oo
ooooo`0000Woool200000_ooo`0406Kooooooooo0000T?ooo`00D?ooo`0306Kooooooooo02Soool0
10000?ooooooo`0000Woool01@000?ooooooooooo`1Vo`02oooo00<0003oooooool0S_ooo`00D?oo
o`0306Kooooooooo02Woool200002_ooo`<000001Oooo`1Vooooooooo`00002@oooo001@oooo00<0
I_ooooooool0>Oooo`0406Kooooooooo0000T?ooo`00D?ooo`0306Kooooooooo03Woool0101Voooo
ooooo`00093oool0053oool00`1Vooooooooo`0ioooo00@0I_ooooooool0002@oooo001@oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo0080002?oooo001@oooo00<0I_ooooooool0>Oooo`0406Ko
oooooooo0000T?ooo`00D?ooo`0306Kooooooooo03Woool0101Vooooooooo`00093oool0053oool0
0`1Vooooooooo`0ioooo00@0I_ooooooool0002@oooo001@oooo00<0I_ooooooool0>Oooo`0406Ko
oooooooo0000T?ooo`00D?ooo`0306Kooooooooo03Woool0101Vooooooooo`00093oool0053oool0
0`1Vooooooooo`0ioooo00<0I_ooooooool00P0008ooool0053oool00`1Vooooooooo`0ioooo00@0
I_ooooooool0002@oooo001@oooo00<0I_ooooooool0>Oooo`0406Kooooooooo0000T?ooo`00Cooo
o`0306Kooooooooo03[oool0101Vooooooooo`00093oool004ooool00`1Vooooooooo`0joooo00@0
I_ooooooool0002@oooo001?oooo00<0I_ooooooool0>_ooo`0406Kooooooooo0000T?ooo`00Cooo
o`0306Kooooooooo03[oool00`1Vooooooooo`020000Soooo`00Coooo`0306Kooooooooo03[oool0
101Vooooooooo`00093oool001Woool30000<oooo`0306Kooooooooo00;oool40000=?ooo`0406Ko
oooooooo0000>Oooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0boooo00<0I_oooooo
ool00_ooo`030000oooooooo03Goool0101Vooooooooo`0003Woool00`000?ooooooo`0moooo00<0
003oooooool05?ooo`005oooo`D0000coooo00<0I_ooooooool00oooo`030000oooooooo03Coool0
101Vooooooooo`0003[oool00`000?ooooooo`0ioooo1@0001Goool0017oool400000_ooo`040000
oooooooo0000<oooo`@00004oooo00<0003oooooool0<oooo`0406Kooooooooo0000>oooo`030000
oooooooo03Soool010000?ooooooo`0001Koool001Soool00`000?ooo`00000doooo00<0I_oooooo
ool00_ooo`040000oooooooo0000=?ooo`0306Kooooooooo0080000hoooo00@0003oooooool0000j
oooo00<0003oool000005_ooo`006Oooo`80000doooo00<0I_ooooooool00oooo`80000eoooo00@0
I_ooooooool0000joooo0P0003coool200005_ooo`00Coooo`0306Kooooooooo03[oool0101Voooo
ooooo`00093oool004ooool00`1Vooooooooo`0joooo00@0I_ooooooool0002@oooo001?oooo00<0
I_ooooooool0>_ooo`0406Kooooooooo0000T?ooo`00Coooo`0306Kooooooooo03[oool0101Voooo
ooooo`00093oool004ooool00`1Vooooooooo`0joooo00@0I_ooooooool0002@oooo000@ooooo`00
017oool001Koool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool0
0`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool02Oooo`04o`2Ioooooooo00003_ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0Eoooo002<oooo00Co09Wooooo
ool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<
oooo00Co09Woooooool0002@oooo002<oooo00?o09Woooooool00P0008ooool008coool01?l0VOoo
ooooo`00093oool008coool01?l0VOooooooo`00093oool008coool01?l0VOooooooo`00093oool0
08coool01?l0VOooooooo`00093oool008coool01?l0VOooooooo`00093oool008coool00ol0VOoo
ooooo`020000Soooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?oo
o`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2I
oooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`03o`2Ioooooooo0080002?
oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co
09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@
oooo002<oooo00?o09Woooooool00P0008ooool008coool01?l0VOooooooo`00093oool008coool0
1?l0VOooooooo`00093oool008coool01?l0VOooooooo`00093oool007coool200001?ooo`800004
oooo0P0000;oool01?l0VOooooooo`00093oool007_oool010000?ooooooo`0000Soool01P000?oo
ooooo`000?ooool0V@;oool00`000?ooooooo`2>oooo001koooo00@0003oooooool0000;oooo00<0
003ooooo09T00_ooo`<0002>oooo001koooo00@0003oooooool00009oooo0P0000;oool01?l0VOoo
ooooo`00093oool007_oool010000?ooooooo`0000Woool01@000?ooooooooooool0V@02oooo00<0
003oooooool0S_ooo`00O?ooo`80000:oooo0`000005ooooo`2Ioooooooo0000093oool008coool0
1?l0VOooooooo`00093oool008coool01?l0VOooooooo`00093oool008coool00ol0VOooooooo`02
0000Soooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?oo
o`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo
0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`03o`2Ioooooooo0080002?oooo002<
oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co09Wooooo
ool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<
oooo00?o09Woooooool00P0008ooool008coool01?l0VOooooooo`00093oool008coool01?l0VOoo
ooooo`00093oool008coool01?l0VOooooooo`00093oool008coool01?l0VOooooooo`00093oool0
08coool01?l0VOooooooo`00093oool008coool00ol0VOooooooo`020000Soooo`00S?ooo`04o`2I
oooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?oo
o`00Qoooo`D000001?l0VOooooooo`00093oool008Woool010000?ooooooool0V@;oool00`000?oo
ooooo`2>oooo0029oooo00@0003ooooooooo09T2oooo0`0008koool008Woool010000?ooooooool0
V@;oool00`000?ooooooo`2>oooo0029oooo00@0003ooooooooo09T2oooo00<0003oooooool0S_oo
o`00R?ooo`800002oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<
oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00?o09Wooooo
ool00P0008ooool008coool01?l0VOooooooo`00093oool008coool01?l0VOooooooo`00093oool0
08coool01?l0VOooooooo`00093oool008coool01?l0VOooooooo`00093oool008coool01?l0VOoo
ooooo`00093oool008coool00ol0VOooooooo`020000Soooo`00S?ooo`04o`2Ioooooooo0000T?oo
o`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2I
oooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`03o`2Ioooooooo0080002?
oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co
09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@
oooo002<oooo00?o09Woooooool00P0008ooool008coool01?l0VOooooooo`00093oool008coool0
1?l0VOooooooo`00093oool008coool01?l0VOooooooo`00093oool008coool01?l0VOooooooo`00
093oool007_oool500000_ooo`800004oooo0P0000;oool01?l0VOooooooo`00093oool007goool0
0`000?ooooooo`07oooo00H0003oooooool0003ooooo09T2oooo00<0003oooooool0S_ooo`00OOoo
o`030000oooooooo00[oool00`000?ooool0V@02oooo0`0008koool007goool00`000?ooooooo`08
oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?ooo`80000:
oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?oo
ooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1h
oooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`D00002oooo0P00
00?oool500000_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo00Woool00`000?oo
ooooo`02oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0E
oooo00<0003oooooool02Oooo`030000oooooooo00?oool00`000?ooooooo`1goooo001hoooo00<0
003oooooool01@0001Coool00`000?ooooooo`09oooo00<0003oooooool00_ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`00000Goooo00<0003oooooool02Oooo`030000oooooooo
00;oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool0
0`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.44268 .24721 L
.46172 .24721 L
.47994 .24721 L
.48519 .24721 L
.48778 .24721 L
.49018 .24721 L
.49235 .24721 L
.49356 .24721 L
s
.49356 .24721 m
.49373 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.20342 .24721 L
.22272 .24721 L
.23233 .24721 L
.24276 .24721 L
.24754 .24721 L
.25016 .24721 L
.25261 .24721 L
.2547 .24721 L
.25587 .24721 L
.25694 .12361 L
.25811 .12361 L
.25939 .12361 L
.26171 .12361 L
.30236 .12361 L
.34148 .12361 L
.38307 .12361 L
.42313 .12361 L
.46168 .12361 L
.48162 .12361 L
.48647 .12361 L
.48914 .12361 L
.49166 .12361 L
.49309 .12361 L
.4939 .12361 L
.49465 .24721 L
.49596 .24721 L
.49737 .24721 L
.50269 .24721 L
.54044 .24721 L
.58064 .24721 L
.61933 .24721 L
.66047 .24721 L
.70009 .24721 L
.7382 .24721 L
.77876 .24721 L
.81781 .24721 L
.85931 .24721 L
.89929 .24721 L
.93775 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00DOooobX0I_l01000001Vo`1Vo`0000/0I_l0
1@00001Vo`1Vo`1Vooooo`030000S_ooo`00DOooo`0306Kooooooooo027oool400000_ooo`040000
oooooooo00002Oooo`800003oooo00<0I_ooool00000T?ooo`00DOooo`0306Kooooooooo02Ooool0
10000?ooooooo`0000Woool00`000?ooooooo`02oooo00<0I_ooool00000T?ooo`00DOooo`0306Ko
oooooooo02Soool200002_ooo`<00002oooo00<0I_ooool00000T?ooo`00DOooo`0306Kooooooooo
03Woool00`1Vooooo`00002@oooo001Aoooo00<0I_ooooooool0>Oooo`0306Kooooo0000093oool0
057oool00`1Vooooooooo`0ioooo00<0I_ooool00000T?ooo`00DOooo`0306Kooooooooo03Woool0
101Vooooo`00000008ooool0057oool00`1Vooooooooo`0ioooo00<0I_ooool00000T?ooo`00DOoo
o`0306Kooooooooo03Woool00`1Vooooo`00002@oooo001Aoooo00<0I_ooooooool0>Oooo`0306Ko
oooo0000093oool0057oool00`1Vooooooooo`0ioooo00<0I_ooool00000T?ooo`00DOooo`0306Ko
oooooooo03Woool00`1Vooooo`00002@oooo001Aoooo00<0I_ooooooool0>Oooo`0406Kooooo0000
0000Soooo`00DOooo`0306Kooooooooo03Woool00`1Vooooo`00002@oooo001Aoooo00<0I_oooooo
ool0>Oooo`0306Kooooo0000093oool0057oool00`1Vooooooooo`0ioooo00<0I_ooool00000T?oo
o`00DOooo`0306Kooooooooo03[oool00`1Vo`000?ooo`2?oooo001Aoooo00<0I_ooooooool0>_oo
o`0306Ko0000oooo08ooool0057oool00`1Vooooooooo`0joooo00<0I_l000000000Soooo`00DOoo
o`0306Kooooooooo03[oool00`1Vo`000?ooo`2?oooo000Ioooo0`0003Goool00`1Vooooooooo`04
0000=_ooo`0306Ko0000oooo03Soool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=?oo
o`0406Kooooooooo0000>Oooo`0306Ko0000oooo03Soool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000eoooo00D0I_ooooooooooool00000>?ooo`0306Ko0000oooo03Woool0
0`000?ooooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004
oooo00<0003oooooool0=Oooo`0306Ko0000oooo03[oool00`000?ooooooo`0hoooo00@0003ooooo
ool0000Foooo000Hoooo00<0003oool00000=_ooo`0406Kooooooooo00000_ooo`030000oooooooo
03Coool00`1Vo`000000000hoooo00@0003oooooool0000joooo00<0003oool000005_ooo`006Ooo
o`80000foooo00@0I_ooooooooooool20000=oooo`0306Ko0000oooo03Woool20000??ooo`80000F
oooo001Aoooo00<0I_ooooooool0>_ooo`0306Ko0000oooo08ooool0057oool00`1Vooooooooo`0j
oooo00<0I_l0003oool0Soooo`00DOooo`0306Kooooooooo03[oool00`1Vo`000?ooo`2?oooo001A
oooo00<0I_ooooooool0>_ooo`0306Ko0000oooo08ooool0057oool00`1Vooooooooo`0joooo00<0
I_l0003oool0Soooo`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00[oool00ol0VOooo`00000>oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
01Goool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`03o`2I
oooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00Co09Woool00000002?oooo002=
oooo00?o09Woool00000T?ooo`00SOooo`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@
oooo002=oooo00?o09Woool00000T?ooo`00SOooo`03o`2Ioooo0000093oool008goool01?l0VOoo
o`00000008ooool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOoo
o`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?oo
o`00SOooo`03o`2Ioooo0000093oool008goool01?l0VOooo`00000008ooool008goool00ol0VOoo
o`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`03o`2Ioooo0000093oool008goool0
0ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`04o`2Ioooo00000000Sooo
o`00SOooo`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool0
0000T?ooo`00O?ooo`800004oooo0P0000Coool200000oooo`03o`2Ioooo0000093oool007_oool0
10000?ooooooo`0000Soool010000?ooooooo`0000;oool00ol0VOooo`00002@oooo001koooo00@0
003oooooool0000;oooo00D0003ooooooooo09Woool00`0008koool007_oool010000?ooooooo`00
00Woool200000oooo`03o`2Ioooo0000093oool007_oool010000?ooooooo`0000Woool00`000?oo
ooooo`02oooo00?o09Woool00000T?ooo`00O?ooo`80000:oooo0`0000;oool00ol0VOooo`00002@
oooo002=oooo00?o09Woool00000T?ooo`00SOooo`03o`2Ioooo0000093oool008goool01?l0VOoo
o`00000008ooool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOoo
o`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?oo
o`00SOooo`03o`2Ioooo0000093oool008goool01?l0VOooo`00000008ooool008goool00ol0VOoo
o`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`03o`2Ioooo0000093oool008goool0
0ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`04o`2Ioooo00000000Sooo
o`00SOooo`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool0
0000T?ooo`00SOooo`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00Co
09Woool00000002?oooo002=oooo00?o09Woool00000T?ooo`00SOooo`03o`2Ioooo0000093oool0
08goool00ol0VOooo`00002@oooo0027oooo1@000004ooooo`2Ioooo0000T?ooo`00ROooo`070000
ooooooooooooo`2Ioooo0000093oool008Woool01P000?ooooooooooool0VOooo`<0002>oooo0029
oooo00L0003ooooooooooooo09Woool00000T?ooo`00ROooo`070000ooooooooooooo`2Ioooo0000
093oool008Soool200000oooo`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=
oooo00?o09Woool00000T?ooo`00SOooo`03o`2Ioooo0000093oool008goool01?l0VOooo`000000
08ooool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`03o`2I
oooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOoo
o`04o`2Ioooo00000000Soooo`00SOooo`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@
oooo002=oooo00?o09Woool00000T?ooo`00SOooo`03o`2Ioooo0000093oool008goool00ol0VOoo
o`00002@oooo002=oooo00Co09Woool00000002?oooo002=oooo00?o09Woool00000T?ooo`00SOoo
o`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?oo
o`00SOooo`03o`2Ioooo0000093oool008goool01?l0VOooo`00000008ooool008goool00ol0VOoo
o`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`03o`2Ioooo0000093oool008goool0
0ol0VOooo`00002@oooo001koooo1@0000;oool200001?ooo`800003oooo00?o09Woool00000T?oo
o`00OOooo`030000oooooooo00Ooool010000?ooooooo`0000;oool00ol0VOooo`00002@oooo001m
oooo00<0003oooooool02_ooo`050000ooooooooo`2Ioooo00<0002>oooo001moooo00<0003ooooo
ool02?ooo`80002Foooo001moooo00<0003oooooool02?ooo`030000oooooooo09Goool007coool2
00002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0
003oooooool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003ooooo
ool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_oo
o`800004oooo0P0000Coool200001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo
00Ooool010000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001d
oooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`07oooo00@0003ooooo
ool00005oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`05
00005?ooo`030000oooooooo00Ooool010000?ooooooo`0000?oool200001?ooo`030000oooooooo
07Goool007Goool01@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05ooo
o`80000:oooo0P0000Coool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Ooo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.48147 .24721 L
.49012 .24721 L
.49468 .24721 L
.49719 .24721 L
.49842 .24721 L
.49955 .24721 L
s
.49955 .24721 m
.49975 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.24141 .24721 L
.25127 .24721 L
.25666 .24721 L
.2593 .24721 L
.26045 .24721 L
.26171 .24721 L
.26301 .12361 L
.26425 .12361 L
.26698 .12361 L
.27279 .12361 L
.28302 .12361 L
.30316 .12361 L
.3438 .12361 L
.38293 .12361 L
.42451 .12361 L
.44538 .12361 L
.46458 .12361 L
.48333 .12361 L
.49277 .12361 L
.49535 .12361 L
.49678 .12361 L
.49813 .12361 L
.49938 .12361 L
.50009 .24721 L
.50074 .24721 L
.50313 .24721 L
.5424 .24721 L
.58015 .24721 L
.62035 .24721 L
.65904 .24721 L
.70018 .24721 L
.7398 .24721 L
.77791 .24721 L
.81847 .24721 L
.85752 .24721 L
.89901 .24721 L
.939 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00DoooobP0I_l01000001Vo`1Vo`0000/0I_l0
0`00001Vo`1Vo`0206Ko0`0008koool005?oool00`1Vooooooooo`0Ooooo100000;oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool005?oool00`1Vooooooooo`0Uoooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool005?oool00`1Voooo
ooooo`0Voooo0P0000[oool300001?ooo`030000oooooooo08koool005?oool00`1Vooooooooo`0i
oooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo03Woool00`000?ooooooo`2>oooo001C
oooo00<0I_ooooooool0>Oooo`030000oooooooo08koool005?oool00`1Vooooooooo`0ioooo0P00
08ooool005?oool00`1Vooooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo
03Woool00`000?ooooooo`2>oooo001Coooo00<0I_ooooooool0>Oooo`030000oooooooo08koool0
05?oool00`1Vooooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo03Woool0
0`000?ooooooo`2>oooo001Coooo00<0I_ooooooool0>Oooo`80002?oooo001Coooo00<0I_oooooo
ool0>Oooo`030000oooooooo08koool005?oool00`1Vooooooooo`0ioooo00<0003oooooool0S_oo
o`00Doooo`0306Kooooooooo03Woool00`000?ooooooo`2>oooo001Coooo00<0I_ooooooool0>Ooo
o`030000oooooooo08koool005?oool00`1Vooooooooo`0ioooo00<0003oooooool0S_ooo`00Dooo
o`0306Kooooooooo03Woool20000Soooo`00Doooo`0306Kooooooooo03Woool00`000?ooooooo`2>
oooo000Ioooo0`0003Ooool00`1Vo`00000000020000=oooo`030000oooooooo03Ooool40000>ooo
o`<0000Eoooo000Joooo00<0003oooooool0=_ooo`0306Ko0000oooo03Woool00`000?ooooooo`0g
oooo00<0003oooooool0?Oooo`030000oooooooo01Coool001Ooool50000=oooo`0306Kooooo0000
03Woool00`000?ooooooo`0hoooo00<0003oooooool0>Oooo`D0000Eoooo000Aoooo100000;oool0
10000?ooooooo`0003?oool4000000Goool0I_ooooooool00000>?ooo`030000oooooooo03Woool0
0`000?ooooooo`0hoooo00@0003oooooool0000Foooo000Hoooo00<0003oool00000>?ooo`0506Ko
0000oooooooo000003Ooool20000>?ooo`040000oooooooo0000>_ooo`030000oooo000001Koool0
01Woool20000>?ooo`0406Kooooo00000000>?ooo`030000oooooooo03Soool20000??ooo`80000F
oooo001Coooo00<0I_ooooooool0>Oooo`030000oooooooo08koool005?oool00`1Vooooooooo`0i
oooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo03Woool00`000?ooooooo`2>oooo001C
oooo00<0I_ooooooool0>Oooo`030000oooooooo08koool005?oool00`1Vooooooooo`0ioooo00<0
003oooooool0S_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
01Goool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>
oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000
oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`0008koool0
07_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool007_oool010000?oo
ooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00O?ooo`80000:oooo0`00
00Coool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool0
08Ooool500000oooo`030000oooooooo08koool008Woool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00ROooo`030000oooooooo00?oool30000S_ooo`00ROooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo0029oooo00<0003oooooool00oooo`030000oooooooo08koool008Soool2
00001Oooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool007_oool500000_ooo`800004oooo0P0000Goool00`000?oo
ooooo`2>oooo001moooo00<0003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo
08koool007goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001moooo00<0
003oooooool02?ooo`80002Foooo001moooo00<0003oooooool02?ooo`030000oooooooo09Goool0
07coool200002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool007coool00`000?ooooooo`0R
oooo00<0003oooooool0O?ooo`00Noooo`030000oooooooo00Soool00`000?ooooooo`0Ioooo00<0
003oooooool0Noooo`00Noooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool5
00000_ooo`800004oooo00<0003oooooool0Noooo`00Noooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02?ooo`030000
oooooooo07_oool007[oool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000oooooooo
00Woool00`000?ooooooo`1joooo001koooo00<0003oooooool01@0001Coool00`000?ooooooo`08
oooo00<0003oooooool0Noooo`00Noooo`050000oooooooooooo000001Ooool00`000?ooooooo`08
oooo00<0003oooooool0Noooo`00O?ooo`030000oooooooo01Ooool200002Oooo`030000oooooooo
07coool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.48147 .24721 L
.49012 .24721 L
.49955 .24721 L
.50205 .24721 L
.50342 .24721 L
.50471 .24721 L
.50592 .24721 L
s
.50592 .24721 m
.50611 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.24141 .24721 L
.25127 .24721 L
.26171 .24721 L
.26425 .24721 L
.26565 .24721 L
.26698 .24721 L
.26773 .24721 L
.26855 .12361 L
.26929 .12361 L
.26998 .12361 L
.27279 .12361 L
.28302 .12361 L
.30316 .12361 L
.34228 .12361 L
.38387 .12361 L
.42393 .12361 L
.46248 .12361 L
.48242 .12361 L
.48727 .12361 L
.48994 .12361 L
.49246 .12361 L
.49316 .12361 L
.49389 .12361 L
.4947 .24721 L
.49545 .24721 L
.49817 .24721 L
.50349 .24721 L
.54124 .24721 L
.58144 .24721 L
.62013 .24721 L
.66127 .24721 L
.70089 .24721 L
.739 .24721 L
.77956 .24721 L
.81861 .24721 L
.86011 .24721 L
.90009 .24721 L
.93855 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00E?ooobL0I_l01000001Vo`1Vo`0000/0I_l0
1@00001Vo`1Vo`1Vooooo`030000S_ooo`00E?ooo`0306Kooooooooo01koool400000_ooo`040000
oooooooo00002Oooo`800003oooo00<0I_ooool00000T?ooo`00E?ooo`0306Kooooooooo02Coool0
10000?ooooooo`0000Woool00`000?ooooooo`02oooo00<0I_ooool00000T?ooo`00E?ooo`0306Ko
oooooooo02Goool200002_ooo`<00002oooo00<0I_ooool00000T?ooo`00E?ooo`0306Kooooooooo
03Koool00`1Vooooo`00002@oooo001Doooo00<0I_ooooooool0=_ooo`0306Kooooo0000093oool0
05Coool00`1Vooooooooo`0foooo00<0I_ooool00000T?ooo`00E?ooo`0306Kooooooooo03Koool0
101Vooooo`00000008ooool005Coool00`1Vooooooooo`0foooo00<0I_ooool00000T?ooo`00E?oo
o`0306Kooooooooo03Koool00`1Vooooo`00002@oooo001Doooo00<0I_ooooooool0=_ooo`0306Ko
oooo0000093oool005Coool00`1Vooooooooo`0foooo00<0I_ooool00000T?ooo`00E?ooo`0306Ko
oooooooo03Koool00`1Vooooo`00002@oooo001Doooo00<0I_ooooooool0=_ooo`0406Kooooo0000
0000Soooo`00E?ooo`0306Kooooooooo03Koool00`1Vooooo`00002@oooo001Doooo00<0I_oooooo
ool0=_ooo`0306Kooooo0000093oool005Coool00`1Vooooooooo`0foooo00<0I_ooool00000T?oo
o`00E?ooo`0306Kooooooooo03Ooool00`1Vo`000?ooo`2?oooo001Doooo00<0I_ooooooool0=ooo
o`0306Ko0000oooo08ooool005Coool00`1Vooooooooo`0goooo00<0I_l000000000Soooo`00E?oo
o`0306Kooooooooo03Ooool00`1Vo`000?ooo`2?oooo000Ioooo0`0003Soool40000=_ooo`0306Ko
0000oooo03Soool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000oooooooo
03Ooool00`1Vo`000?ooo`0hoooo00<0003oooooool0?Oooo`030000oooooooo01Coool001Ooool5
0000>?ooo`0306Ko0000oooo03Ooool00`1Vo`000?ooo`0ioooo00<0003oooooool0>Oooo`D0000E
oooo000Aoooo100000;oool010000?ooooooo`0003?oool400000_ooo`0306Kooooo000003Ooool0
0`1Vo`000?ooo`0joooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000
oooo000003Woool010000?ooooooo`0003Koool00`1Vo`000000000hoooo00@0003oooooool0000j
oooo00<0003oool000005_ooo`006Oooo`80000ioooo00<0I_l000000000=oooo`0306Ko0000oooo
03Woool20000??ooo`80000Foooo001Doooo00<0I_ooooooool0=oooo`0306Ko0000oooo08ooool0
05Coool00`1Vooooooooo`0goooo00<0I_l0003oool0Soooo`00E?ooo`0306Kooooooooo03Ooool0
0`1Vo`000?ooo`2?oooo001Doooo00<0I_ooooooool0=oooo`0306Ko0000oooo08ooool005Coool0
0`1Vooooooooo`0goooo00<0I_l0003oool0Soooo`004?ooool0000Aoooo000Foooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool0
0`000?l0VOooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo01Goool008ooool00`000?l0VOooo`2>oooo002?oooo00<0003o09Wo
ool0S_ooo`00Soooo`030000o`2Ioooo08koool008ooool00`000?l0VOooo`2>oooo002?oooo0P00
08ooool008ooool00`000?l0VOooo`2>oooo002?oooo00<0003o09Woool0S_ooo`00Soooo`030000
o`2Ioooo08koool008ooool00`000?l0VOooo`2>oooo002?oooo00<0003o09Woool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003o09Woool0S_ooo`00Soooo`030000o`2Ioooo08koool008ooool0
0`000?l0VOooo`2>oooo002?oooo00<0003o09Woool0S_ooo`00Soooo`030000o`2Ioooo08koool0
08ooool00`000?l0VOooo`2>oooo002?oooo0P0008ooool008ooool00`000?l0VOooo`2>oooo002?
oooo00<0003o09Woool0S_ooo`00Soooo`030000o`2Ioooo08koool008ooool00`000?l0VOooo`2>
oooo002?oooo00<0003o09Woool0S_ooo`00Soooo`80002?oooo002?oooo00<0003o09Woool0S_oo
o`00Soooo`030000o`2Ioooo08koool008ooool00`000?l0VOooo`2>oooo001loooo0P0000Coool2
00001?ooo`800005oooo00<0003o09Woool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000
oooooooo00001?ooo`030000o`2Ioooo08koool007_oool010000?ooooooo`0000_oool00`000?oo
ooooo`02oooo0`0008koool007_oool010000?ooooooo`0000Woool200001Oooo`030000o`2Ioooo
08koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003o09Woool0S_oo
o`00O?ooo`80000:oooo0`0000Coool00`000?l0VOooo`2>oooo002?oooo00<0003o09Woool0S_oo
o`00Soooo`030000o`2Ioooo08koool008ooool20000Soooo`00Soooo`030000o`2Ioooo08koool0
08ooool00`000?l0VOooo`2>oooo002?oooo00<0003o09Woool0S_ooo`00Soooo`030000o`2Ioooo
08koool008ooool00`000?l0VOooo`2>oooo002?oooo00<0003o09Woool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003o09Woool0S_ooo`00Soooo`030000o`2Ioooo08koool008ooool00`000?l0
VOooo`2>oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I08koool008ooool2
000000?o09Woooooool0S?ooo`00Soooo`030000ooooo`2I08koool008ooool00`000?ooool0V@2>
oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I08koool008ooool00`000?oo
ool0V@2>oooo002?oooo0P000003o`2Ioooooooo08coool008ooool00`000?ooool0V@2>oooo002?
oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I08koool008Ooool500000oooo`030000
ooooo`2I08koool008Woool00`000?ooooooo`03oooo00<0003ooooo09T0S_ooo`00ROooo`030000
oooooooo00?oool30000S_ooo`00ROooo`030000oooooooo00?oool00`000?ooool0V@2>oooo0029
oooo00<0003oooooool00oooo`030000ooooo`2I08koool008Soool200001Oooo`030000ooooo`2I
08koool008ooool00`000?ooool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000
ooooo`2I08koool008ooool2000000?o09Woooooool0S?ooo`00Soooo`030000ooooo`2I08koool0
08ooool00`000?ooool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I
08koool008ooool00`000?ooool0V@2>oooo002?oooo0P000003o`2Ioooooooo08coool008ooool0
0`000?ooool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I08koool0
08ooool00`000?ooool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`8000000ol0VOoo
ooooo`2<oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I08koool008ooool0
0`000?ooool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I08koool0
08ooool2000000?o09Woooooool0S?ooo`00Soooo`030000ooooo`2I08koool008ooool00`000?oo
ool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I08koool007_oool5
00000_ooo`800004oooo0P0000Goool00`000?ooool0V@2>oooo001moooo00<0003oooooool01ooo
o`040000oooooooo00001?ooo`030000ooooo`2I08koool007goool00`000?ooooooo`0:oooo00<0
003oooooool00_ooo`<0002>oooo001moooo00<0003oooooool02?ooo`80002Foooo001moooo00<0
003oooooool02?ooo`030000oooooooo09Goool007coool200002_ooo`<0002Eoooo003ooooo8Ooo
o`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000
oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo0`0000Coool200001?oo
o`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002_ooo`050000oooooooooooo0000
00;oool01@000?ooooooooooo`00001goooo001doooo00<0003oooooool00_ooo`030000oooooooo
01?oool010000?ooooooo`0000Woool300001Oooo`030000oooooooo00;oool00`000?ooooooo`1d
oooo001eoooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool010000?ooooooo`00
00?oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`00000Eoooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool00oooo`030000oooooooo
07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool300000oooo`<00002oooo00<0003ooooo
ool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.48147 .24721 L
.49955 .24721 L
.50431 .24721 L
.50682 .24721 L
.5082 .24721 L
.5095 .24721 L
.51074 .24721 L
.51143 .24721 L
s
.51143 .24721 m
.51153 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.24141 .24721 L
.26171 .24721 L
.26709 .24721 L
.27003 .24721 L
.27147 .24721 L
.27279 .24721 L
.27399 .12361 L
.27513 .12361 L
.27765 .12361 L
.28302 .12361 L
.30316 .12361 L
.34135 .12361 L
.38199 .12361 L
.42112 .12361 L
.4411 .12361 L
.46271 .12361 L
.47285 .12361 L
.4784 .12361 L
.48357 .12361 L
.48584 .12361 L
.48696 .12361 L
.48799 .12361 L
.48918 .24721 L
.49047 .24721 L
.49273 .24721 L
.50277 .24721 L
.54204 .24721 L
.57979 .24721 L
.61999 .24721 L
.65868 .24721 L
.69982 .24721 L
.73944 .24721 L
.77755 .24721 L
.81811 .24721 L
.85716 .24721 L
.89866 .24721 L
.93864 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00E_ooobD0I_l01000001Vo`1Vo`0000/0I_l0
0`00001Vo`1Vo`02oooo0`0008koool005Koool00`1Vooooooooo`0Loooo100000;oool010000?oo
ooooo`0000Woool200000_ooo`0406Kooooooooo0000T?ooo`00E_ooo`0306Kooooooooo02;oool0
10000?ooooooo`0000Woool01@000?ooooooooooo`1Vo`02oooo00<0003oooooool0S_ooo`00E_oo
o`0306Kooooooooo02?oool200002_ooo`<000001Oooo`1Vooooooooo`00002@oooo001Foooo00<0
I_ooooooool0<oooo`0406Kooooooooo0000T?ooo`00E_ooo`0306Kooooooooo03?oool0101Voooo
ooooo`00093oool005Koool00`1Vooooooooo`0coooo00@0I_ooooooool0002@oooo001Foooo00<0
I_ooooooool0<oooo`0306Kooooooooo0080002?oooo001Foooo00<0I_ooooooool0<oooo`0406Ko
oooooooo0000T?ooo`00E_ooo`0306Kooooooooo03?oool0101Vooooooooo`00093oool005Koool0
0`1Vooooooooo`0coooo00@0I_ooooooool0002@oooo001Foooo00<0I_ooooooool0<oooo`0406Ko
oooooooo0000T?ooo`00E_ooo`0306Kooooooooo03?oool0101Vooooooooo`00093oool005Koool0
0`1Vooooooooo`0coooo00<0I_ooooooool00P0008ooool005Koool00`1Vooooooooo`0coooo00@0
I_ooooooool0002@oooo001Foooo00<0I_ooooooool0<oooo`0406Kooooooooo0000T?ooo`00EOoo
o`0306Kooooooooo03Coool0101Vooooooooo`00093oool005Goool00`1Vooooooooo`0doooo00@0
I_ooooooool0002@oooo001Eoooo00<0I_ooooooool0=?ooo`0406Kooooooooo0000T?ooo`00EOoo
o`0306Kooooooooo03Coool00`1Vooooooooo`020000Soooo`00EOooo`0306Kooooooooo03Coool0
101Vooooooooo`00093oool001Woool30000>?ooo`@0000doooo00@0I_ooooooool0000ioooo1000
03_oool300005Oooo`006_ooo`030000oooooooo03Ooool00`00001Vooooo`0eoooo00@0I_oooooo
ool0000ioooo00<0003oooooool0?Oooo`030000oooooooo01Coool001Ooool50000>Oooo`030000
oooooooo03Coool0101Vooooooooo`0003[oool00`000?ooooooo`0ioooo1@0001Goool0017oool4
00000_ooo`040000oooooooo0000<oooo`@00003oooo00<0I_l0003oool0=?ooo`0406Kooooooooo
0000>oooo`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool00`000?ooo`00000i
oooo00@00000I_ooool0000doooo00<0I_ooooooool00P0003Soool010000?ooooooo`0003[oool0
0`000?ooo`00000Foooo000Ioooo0P0003[oool20000=Oooo`0406Kooooooooo0000>_ooo`80000l
oooo0P0001Koool005Goool00`1Vooooooooo`0doooo00@0I_ooooooool0002@oooo001Eoooo00<0
I_ooooooool0=?ooo`0406Kooooooooo0000T?ooo`00EOooo`0306Kooooooooo03Coool0101Voooo
ooooo`00093oool005Goool00`1Vooooooooo`0doooo00@0I_ooooooool0002@oooo001Eoooo00<0
I_ooooooool0=?ooo`0406Kooooooooo0000T?ooo`004?ooool0000Aoooo000Foooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool0
10000?ooooooool0V@_oool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000
ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOoo
o`00Soooo`8000000oooool0VOooo`2<oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0
003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=
oooo002?oooo00@0003ooooooooo09V=oooo002?oooo0P000003ooooo`2Ioooo08coool008ooool0
10000?ooooooool0VHgoool008ooool010000?ooooooool0VHgoool008ooool010000?ooooooool0
VHgoool008ooool010000?ooooooool0VHgoool008ooool010000?ooooooool0VHgoool008ooool0
10000?ooooooool0VHgoool008ooool2000000?ooooo09Woool0S?ooo`00Soooo`040000oooooooo
o`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Sooo
o`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`8000000oooool0
VOooo`2<oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?
oooo00@0003ooooooooo09V=oooo001loooo0P0000Coool200001?ooo`800005oooo00@0003ooooo
oooo09V=oooo001koooo00@0003oooooool00008oooo00@0003oooooool00004oooo00@0003ooooo
oooo09V=oooo001koooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`<000000ol0VOoo
ooooo`2;oooo001koooo00@0003oooooool00009oooo0P0000Goool010000?ooooooool0VHgoool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00@0003ooooooooo09V=oooo001l
oooo0P0000[oool300001?ooo`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOoo
o`00Soooo`040000ooooooooo`2ISOooo`00Soooo`8000000oooool0VOooo`2<oooo002?oooo00@0
003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=
oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0
003ooooooooo09V=oooo002?oooo0P000003ooooo`2Ioooo08coool008ooool010000?ooooooool0
VHgoool008ooool010000?ooooooool0VHgoool008ooool010000?ooooooool0VHgoool008ooool0
10000?ooooooool0VHgoool008ooool010000?ooooooool0VHgoool008ooool2000000?ooooo09Wo
ool0S?ooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Sooo
o`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000oooooooo
o`2ISOooo`00Soooo`8000000oooool0VOooo`2<oooo002?oooo00@0003ooooooooo09V=oooo002?
oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo0027oooo1@0000?oool0
10000?ooooooool0VHgoool008Woool00`000?ooooooo`03oooo00@0003ooooooooo09V=oooo0029
oooo00<0003oooooool00oooo`<000000ol0VOooooooo`2;oooo0029oooo00<0003oooooool00ooo
o`040000ooooooooo`2ISOooo`00ROooo`030000oooooooo00?oool010000?ooooooool0VHgoool0
08Soool200001Oooo`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Sooo
o`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`8000000oooool0
VOooo`2<oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?
oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooo
oooo09V=oooo002?oooo0P000003ooooo`2Ioooo08coool008ooool010000?ooooooool0VHgoool0
08ooool010000?ooooooool0VHgoool008ooool010000?ooooooool0VHgoool008ooool010000?oo
ooooool0VHgoool008ooool010000?ooooooool0VHgoool008ooool2000000?ooooo09Woool0S?oo
o`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000
ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOoo
o`00Soooo`8000000oooool0VOooo`2<oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0
003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=
oooo001koooo1@0000;oool200001?ooo`800005oooo00@0003ooooooooo09V=oooo001moooo00<0
003oooooool01oooo`040000oooooooo00001?ooo`040000ooooooooo`2ISOooo`00OOooo`030000
oooooooo00[oool00`000?ooooooo`02oooo0`000003o`2Ioooooooo08_oool007goool00`000?oo
ooooo`08oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?oo
o`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool0
0`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?oo
ooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004
oooo0P0000?oool300001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002_oo
o`030000oooooooo00;oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000
oooooooo01?oool010000?ooooooo`0000Woool300001?ooo`030000oooooooo07Ooool007Soool0
0`000?ooooooo`0500004_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_oo
o`<00002oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.48147 .24721 L
.49955 .24721 L
.50431 .24721 L
.5095 .24721 L
.51188 .24721 L
.51441 .24721 L
.51564 .24721 L
.5168 .24721 L
.51784 .24721 L
s
.51784 .24721 m
.518 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.24141 .24721 L
.26171 .24721 L
.26709 .24721 L
.27279 .24721 L
.27513 .24721 L
.27765 .24721 L
.2784 .24721 L
.2791 .24721 L
.28042 .12361 L
.28166 .12361 L
.28302 .12361 L
.30316 .12361 L
.3438 .12361 L
.38293 .12361 L
.42451 .12361 L
.44538 .12361 L
.45453 .12361 L
.46458 .12361 L
.46926 .12361 L
.47427 .12361 L
.47671 .12361 L
.47901 .12361 L
.48001 .12361 L
.48108 .12361 L
.48224 .24721 L
.48333 .24721 L
.50313 .24721 L
.54088 .24721 L
.58108 .24721 L
.61977 .24721 L
.66091 .24721 L
.70054 .24721 L
.73864 .24721 L
.7792 .24721 L
.81825 .24721 L
.85975 .24721 L
.89973 .24721 L
.9382 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Eoooob@0I_l01000001Vo`1Vo`0000/0I_l0
0`000?ooooooo`02oooo0`0008koool005Ooool00`1Vooooooooo`0Koooo100000;oool010000?oo
ooooo`0000Woool2000000<0I_ooooooool00_ooo`030000oooooooo08koool005Ooool00`1Voooo
ooooo`0Qoooo00@0003oooooool00009oooo00<0003oool0I_l01?ooo`030000oooooooo08koool0
05Ooool00`1Vooooooooo`0Roooo0P0000[oool300001?ooo`030000oooooooo08koool005Ooool0
0`1Vooooooooo`0`oooo00<0I_ooooooool00_ooo`030000oooooooo08koool005Ooool00`1Voooo
ooooo`0`oooo00<0I_ooooooool00_ooo`030000oooooooo08koool005Ooool00`1Vooooooooo`0`
oooo00<0I_ooooooool00_ooo`030000oooooooo08koool005Ooool00`1Vooooooooo`0`oooo00<0
I_ooooooool00_ooo`80002?oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool0
0`000?ooooooo`2>oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool00`000?oo
ooooo`2>oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool00`000?ooooooo`2>
oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool00`000?ooooooo`2>oooo001G
oooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool00`000?ooooooo`2>oooo001Goooo00<0
I_ooooooool0<?ooo`0306Kooooooooo00;oool20000Soooo`00Eoooo`0306Kooooooooo033oool0
0`1Vooooooooo`02oooo00<0003oooooool0S_ooo`00Eoooo`0306Kooooooooo033oool00`1Voooo
ooooo`02oooo00<0003oooooool0S_ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02
oooo00<0003oooooool0S_ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02oooo00<0
003oooooool0S_ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02oooo00<0003ooooo
ool0S_ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02oooo0P0008ooool005Ooool0
0`1Vooooooooo`0`oooo00<0I_ooooooool00_ooo`030000oooooooo08koool001Woool30000>?oo
o`@0000boooo00<0I_ooooooool00_ooo`030000oooooooo03Ooool40000>oooo`<0000Eoooo000J
oooo00<0003oooooool0=oooo`040000oooooooo06Ko<_ooo`0306Kooooooooo00;oool00`000?oo
ooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool001Ooool50000>Oooo`030000
oooo06Ko03;oool00`1Vooooooooo`02oooo00<0003oooooool0>?ooo`030000oooooooo03Woool5
00005Oooo`004Oooo`@00002oooo00@0003oooooool0000coooo100000Coool00`00001Vooooo`0a
oooo00<0I_ooooooool00_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003ooooo
ool0000Foooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000<_ooo`0306Kooooooooo
00;oool20000>?ooo`040000oooooooo0000>_ooo`030000oooo000001Koool001Woool20000>_oo
o`8000000`1Vooooooooo`0`oooo00<0I_ooooooool00_ooo`030000oooooooo03Soool20000??oo
o`80000Foooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool00`000?ooooooo`2>
oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool00`000?ooooooo`2>oooo001G
oooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool00`000?ooooooo`2>oooo001Goooo00<0
I_ooooooool0<?ooo`0306Kooooooooo00;oool00`000?ooooooo`2>oooo001Goooo00<0I_oooooo
ool0<?ooo`0306Kooooooooo00;oool00`000?ooooooo`2>oooo000@ooooo`00017oool001Koool0
0`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`050000ooooooooooooo`2I00[oool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool05Oooo`00Soooo`050000ooooooooooooo`2I
08coool008ooool01@000?ooooooooooool0V@2<oooo002?oooo00D0003ooooooooooooo09T0S?oo
o`00Soooo`050000ooooooooooooo`2I08coool008ooool200000_ooo`03o`2Ioooooooo08[oool0
08ooool01@000?ooooooooooool0V@2<oooo002?oooo00D0003ooooooooooooo09T0S?ooo`00Sooo
o`050000ooooooooooooo`2I08coool008ooool01@000?ooooooooooool0V@2<oooo002?oooo00D0
003ooooooooooooo09T0S?ooo`00Soooo`800002oooo00?o09Woooooool0R_ooo`00Soooo`050000
ooooooooooooo`2I08coool008ooool01@000?ooooooooooool0V@2<oooo002?oooo00D0003ooooo
oooooooo09T0S?ooo`00Soooo`050000ooooooooooooo`2I08coool008ooool01@000?oooooooooo
ool0V@2<oooo002?oooo00D0003ooooooooooooo09T0S?ooo`00Soooo`800002oooo00?o09Wooooo
ool0R_ooo`00Soooo`050000ooooooooooooo`2I08coool008ooool01@000?ooooooooooool0V@2<
oooo002?oooo00D0003ooooooooooooo09T0S?ooo`00Soooo`050000ooooooooooooo`2I08coool0
08ooool01@000?ooooooooooool0V@2<oooo002?oooo0P0000;oool00ol0VOooooooo`2:oooo002?
oooo00D0003ooooooooooooo09T0S?ooo`00Soooo`050000ooooooooooooo`2I08coool008ooool0
1@000?ooooooooooool0V@2<oooo001loooo0P0000Coool200001?ooo`800005oooo00D0003ooooo
oooooooo09T0S?ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`050000
ooooooooooooo`2I08coool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
0003ooooo`2Ioooo08_oool007_oool010000?ooooooo`0000Woool200001Oooo`050000oooooooo
ooooo`2I08coool007_oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00D0003ooooo
oooooooo09T0S?ooo`00O?ooo`80000:oooo0`0000Coool01@000?ooooooooooool0V@2<oooo002?
oooo00D0003ooooooooooooo09T0S?ooo`00Soooo`050000ooooooooooooo`2I08coool008ooool2
00000_ooo`03o`2Ioooooooo08[oool008ooool01@000?ooooooooooool0V@2<oooo002?oooo00D0
003ooooooooooooo09T0S?ooo`00Soooo`050000ooooooooooooo`2I08coool008ooool01@000?oo
ooooooooool0V@2<oooo002?oooo00D0003ooooooooooooo09T0S?ooo`00Soooo`050000oooooooo
ooooo`2I08coool008ooool200000_ooo`03o`2Ioooooooo08[oool008ooool01@000?oooooooooo
ool0V@2<oooo002?oooo00D0003ooooooooooooo09T0S?ooo`00Soooo`050000ooooooooooooo`2I
08coool008ooool00`000?ooooooo`02oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo
00;oool00ol0VOooooooo`29oooo002?oooo0P0000?oool00ol0VOooooooo`29oooo002?oooo00<0
003oooooool00_ooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02oooo00?o09Wooooo
ool0ROooo`00Soooo`030000oooooooo00;oool00ol0VOooooooo`29oooo002?oooo00<0003ooooo
ool00_ooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02oooo00?o09Woooooool0ROoo
o`00Soooo`800003oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo00;oool00ol0VOoo
ooooo`29oooo002?oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool008ooool00`000?oo
ooooo`02oooo00?o09Woooooool0ROooo`00Qoooo`D00003oooo00<0003oooooool00_ooo`03o`2I
oooooooo08Woool008Woool00`000?ooooooo`03oooo00<0003oooooool00_ooo`03o`2Ioooooooo
08Woool008Woool00`000?ooooooo`03oooo0`0000;oool00ol0VOooooooo`29oooo0029oooo00<0
003oooooool00oooo`030000oooooooo00;oool00ol0VOooooooo`29oooo0029oooo00<0003ooooo
ool00oooo`030000oooooooo00;oool00ol0VOooooooo`29oooo0028oooo0P0000Goool00`000?oo
ooooo`02oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo00;oool00ol0VOooooooo`29
oooo002?oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02
oooo00?o09Woooooool0ROooo`00Soooo`800003oooo00?o09Woooooool0ROooo`00Soooo`030000
oooooooo00;oool00ol0VOooooooo`29oooo002?oooo00<0003oooooool00_ooo`03o`2Ioooooooo
08Woool008ooool00`000?ooooooo`02oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo
00;oool00ol0VOooooooo`29oooo002?oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool0
08ooool200000oooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02oooo00?o09Wooooo
ool0ROooo`00Soooo`030000oooooooo00;oool00ol0VOooooooo`29oooo002?oooo00<0003ooooo
ool00_ooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02oooo00?o09Woooooool0ROoo
o`00Soooo`030000oooooooo00;oool00ol0VOooooooo`29oooo002?oooo0P0000?oool00ol0VOoo
ooooo`29oooo002?oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool008ooool00`000?oo
ooooo`02oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo00;oool00ol0VOooooooo`29
oooo002?oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02
oooo00?o09Woooooool0ROooo`00Soooo`800003oooo00?o09Woooooool0ROooo`00Soooo`030000
oooooooo00;oool00ol0VOooooooo`29oooo002?oooo00<0003oooooool00_ooo`03o`2Ioooooooo
08Woool008ooool00`000?ooooooo`02oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo
00;oool00ol0VOooooooo`29oooo001koooo1@0000;oool200001?ooo`800005oooo00<0003ooooo
ool00_ooo`03o`2Ioooooooo08Woool007goool00`000?ooooooo`07oooo00@0003oooooool00004
oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool007goool00`000?ooooooo`0:oooo00<0
003oooooool00_ooo`<00002oooo00?o09Woooooool0ROooo`00OOooo`030000oooooooo00Soool2
0000U_ooo`00OOooo`030000oooooooo00Soool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?oo
o`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool0
10000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Soool010000?ooooooo`00
00Goool00`000?ooooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000B
oooo00@0003oooooool00009oooo0P0000Coool200001?ooo`030000oooooooo07Goool007Goool0
1@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0
003oooooool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool2
00001?ooo`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.5095 .24721 L
.51441 .24721 L
.51896 .24721 L
.52148 .24721 L
.52221 .24721 L
.52289 .24721 L
s
.52289 .24721 m
.52309 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.27193 .24721 L
.27731 .24721 L
.28025 .24721 L
.28302 .24721 L
.28425 .24721 L
.28542 .24721 L
.28606 .12361 L
.28676 .12361 L
.288 .12361 L
.29349 .12361 L
.30316 .12361 L
.3438 .12361 L
.38293 .12361 L
.42451 .12361 L
.44538 .12361 L
.45453 .12361 L
.46458 .12361 L
.46926 .12361 L
.47183 .12361 L
.4731 .12361 L
.47427 .12361 L
.47537 .12361 L
.47654 .24721 L
.47771 .24721 L
.47901 .24721 L
.48333 .24721 L
.50313 .24721 L
.54333 .24721 L
.58202 .24721 L
.62316 .24721 L
.66278 .24721 L
.70089 .24721 L
.74145 .24721 L
.7805 .24721 L
.822 .24721 L
.86198 .24721 L
.90044 .24721 L
.94136 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00FOooob80I_l01000001Vo`1Vo`0000/0I_l0
0`000?ooooooo`02oooo0`0008koool005Woool00`1Vooooooooo`0Ioooo100000;oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool005Woool00`1Vooooooooo`0Ooooo00@0
003oooooool00009oooo00<00000I_ooool01?ooo`030000oooooooo08koool005Woool00`1Voooo
ooooo`0Poooo0P0000[oool300001?ooo`030000oooooooo08koool005Woool00`1Vooooooooo`0]
oooo00<0I_ooooooool00oooo`030000oooooooo08koool005Woool00`1Vooooooooo`0]oooo00<0
I_ooooooool00oooo`030000oooooooo08koool005Woool00`1Vooooooooo`0]oooo00<0I_oooooo
ool00oooo`030000oooooooo08koool005Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00ooo
o`80002?oooo001Ioooo00<0I_ooooooool0;Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>
oooo001Ioooo00<0I_ooooooool0;Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001I
oooo00<0I_ooooooool0;Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001Ioooo00<0
I_ooooooool0;Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001Ioooo00<0I_oooooo
ool0;Oooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001Ioooo00<0I_ooooooool0;Ooo
o`0306Kooooooooo00?oool20000Soooo`00FOooo`0306Kooooooooo02goool00`1Vooooooooo`03
oooo00<0003oooooool0S_ooo`00FOooo`0306Kooooooooo02goool00`1Vooooooooo`03oooo00<0
003oooooool0S_ooo`00FOooo`0306Kooooooooo02goool00`1Vooooooooo`03oooo00<0003ooooo
ool0S_ooo`00FOooo`0306Kooooooooo02goool00`1Vooooooooo`03oooo00<0003oooooool0S_oo
o`00FOooo`0306Kooooooooo02goool00`1Vooooooooo`03oooo00<0003oooooool0S_ooo`00FOoo
o`0306Kooooooooo02goool00`1Vooooooooo`03oooo0P0008ooool005Woool00`1Vooooooooo`0]
oooo00<0I_ooooooool00oooo`030000oooooooo08koool001Woool30000>?ooo`@000000oooo`1V
ooooo`0^oooo00<0I_ooooooool00oooo`030000oooooooo03Ooool40000>oooo`<0000Eoooo000J
oooo00<0003oooooool0=oooo`030000oooooooo00;oool00`1Vooooooooo`0]oooo00<0I_oooooo
ool00oooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003oooooool05?ooo`005ooo
o`D0000ioooo00D0003oooooooooool0I_l0;oooo`0306Kooooooooo00?oool00`000?ooooooo`0h
oooo00<0003oooooool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0003?oool4
00001?ooo`040000oooooooo06Ko;oooo`0306Kooooooooo00?oool00`000?ooooooo`0ioooo00<0
003oooooool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000oooo000003Woool01P000?oo
ooooo`000?ooo`1Vobooool00`1Vooooooooo`03oooo0P0003Soool010000?ooooooo`0003[oool0
0`000?ooo`00000Foooo000Ioooo0P0003[oool200000_ooo`0306Kooooooooo02goool00`1Voooo
ooooo`03oooo00<0003oooooool0>?ooo`80000loooo0P0001Koool005Woool00`1Vooooooooo`0]
oooo00<0I_ooooooool00oooo`030000oooooooo08koool005Woool00`1Vooooooooo`0]oooo00<0
I_ooooooool00oooo`030000oooooooo08koool005Woool00`1Vooooooooo`0]oooo00<0I_oooooo
ool00oooo`030000oooooooo08koool005Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00ooo
o`030000oooooooo08koool005Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00oooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool00oooo`03o`2I
oooooooo00Koool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool05Oooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?
oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o
09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo0P00
00Coool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool0
08ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool0
0ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool0
0`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`800004oooo00?o09Woooooool0R?oo
o`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00ooo
o`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Sooo
o`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2I
oooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`800004
oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?
oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o
09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo00<0
003oooooool00oooo`03o`2Ioooooooo08Soool008ooool200001?ooo`03o`2Ioooooooo08Soool0
08ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool0
0ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool007coool2
00001?ooo`800004oooo0P0000Goool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Nooo
o`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000oooooooo00?oool00ol0VOoo
ooooo`28oooo001koooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`<00003oooo00?o
09Woooooool0R?ooo`00Noooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool00ooo
o`03o`2Ioooooooo08Soool007_oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0
003oooooool00oooo`03o`2Ioooooooo08Soool007coool200002_ooo`<00004oooo00<0003ooooo
ool00oooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?oo
o`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo0P0000Coool00ol0VOoo
ooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool00`000?oo
ooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28
oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03
oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?
oooo0P0000Coool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo
08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo
00?oool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool0
08ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`800004oooo00?o09Wooooo
ool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo00<0003ooooo
ool00oooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?oo
o`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00ooo
o`03o`2Ioooooooo08Soool008ooool200001?ooo`03o`2Ioooooooo08Soool008ooool00`000?oo
ooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28
oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008Ooool500000oooo`030000
oooooooo00?oool00ol0VOooooooo`28oooo0029oooo00<0003oooooool00oooo`030000oooooooo
00?oool00ol0VOooooooo`28oooo0029oooo00<0003oooooool00oooo`<00003oooo00?o09Wooooo
ool0R?ooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`03oooo00?o09Woooooool0R?oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00R?oo
o`800005oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03
oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?
oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool200001?ooo`03o`2Ioooooooo
08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo
00?oool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool0
08ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool0
0ol0VOooooooo`28oooo002?oooo0P0000Coool00ol0VOooooooo`28oooo002?oooo00<0003ooooo
ool00oooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?oo
o`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00ooo
o`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Sooo
o`800004oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28
oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03
oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?
oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool200001?ooo`03o`2Ioooooooo
08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo
00?oool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool0
08ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Noooo`D00002oooo0P0000Coool2
00001Oooo`030000oooooooo00?oool00ol0VOooooooo`28oooo001moooo00<0003oooooool01ooo
o`040000oooooooo00001?ooo`030000oooooooo00?oool00ol0VOooooooo`28oooo001moooo00<0
003oooooool02_ooo`030000oooooooo00;oool300000oooo`03o`2Ioooooooo08Soool007goool0
0`000?ooooooo`08oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0003oooooool0UOoo
o`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Ooo
o`800004oooo0P0000Coool200001?ooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000
oooooooo07Ooool007Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002Oooo`800004
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05ooo
o`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.5095 .24721 L
.51896 .24721 L
.52417 .24721 L
.5256 .24721 L
.52712 .24721 L
.52786 .24721 L
.52856 .24721 L
s
.52856 .24721 m
.52876 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.27193 .24721 L
.27731 .24721 L
.28302 .24721 L
.288 .24721 L
.28936 .24721 L
.29012 .24721 L
.29083 .24721 L
.2915 .24721 L
.29222 .12361 L
.29349 .12361 L
.30316 .12361 L
.3438 .12361 L
.38293 .12361 L
.42451 .12361 L
.44538 .12361 L
.45453 .12361 L
.45938 .12361 L
.46458 .12361 L
.46718 .12361 L
.46846 .12361 L
.46965 .12361 L
.47072 .24721 L
.47186 .24721 L
.47427 .24721 L
.48333 .24721 L
.50313 .24721 L
.54088 .24721 L
.58108 .24721 L
.61977 .24721 L
.66091 .24721 L
.70054 .24721 L
.73864 .24721 L
.7792 .24721 L
.81825 .24721 L
.85975 .24721 L
.89973 .24721 L
.9382 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00F_ooob40I_l01000001Vo`1Vo`0000T0I_l2
oooo00<0003oooooool00_ooo`<0002>oooo001Joooo00<0I_ooooooool06?ooo`@00002oooo00@0
003oooooool00008oooo00<0I_l0000000001Oooo`030000oooooooo08koool005[oool00`1Voooo
ooooo`0Noooo00@0003oooooool00008oooo00<0I_l0003oool01Oooo`030000oooooooo08koool0
05[oool00`1Vooooooooo`0Ooooo0P0000Woool0101Vo`000000000000Coool00`000?ooooooo`2>
oooo001Joooo00<0I_ooooooool0:_ooo`0306Kooooooooo00Goool00`000?ooooooo`2>oooo001J
oooo00<0I_ooooooool0:_ooo`0306Kooooooooo00Goool00`000?ooooooo`2>oooo001Joooo00<0
I_ooooooool0:_ooo`0306Kooooooooo00Goool00`000?ooooooo`2>oooo001Joooo00<0I_oooooo
ool0:_ooo`0306Kooooooooo00Goool20000Soooo`00F_ooo`0306Kooooooooo02[oool00`1Voooo
ooooo`05oooo00<0003oooooool0S_ooo`00F_ooo`0306Kooooooooo02[oool00`1Vooooooooo`05
oooo00<0003oooooool0S_ooo`00F_ooo`0306Kooooooooo02[oool00`1Vooooooooo`05oooo00<0
003oooooool0S_ooo`00F_ooo`0306Kooooooooo02[oool00`1Vooooooooo`05oooo00<0003ooooo
ool0S_ooo`00F_ooo`0306Kooooooooo02[oool00`1Vooooooooo`05oooo00<0003oooooool0S_oo
o`00F_ooo`0306Kooooooooo02[oool00`1Vooooooooo`05oooo0P0008ooool005[oool00`1Voooo
ooooo`0Zoooo00<0I_ooooooool01Oooo`030000oooooooo08koool005[oool00`1Vooooooooo`0Z
oooo00<0I_ooooooool01Oooo`030000oooooooo08koool005[oool00`1Vooooooooo`0Zoooo00<0
I_ooooooool01Oooo`030000oooooooo08koool005[oool00`1Vooooooooo`0[oooo00<0I_oooooo
ool01?ooo`030000oooooooo08koool005[oool00`1Vooooooooo`0[oooo00<0I_ooooooool01?oo
o`030000oooooooo08koool005[oool00`1Vooooooooo`0[oooo00<0I_ooooooool01?ooo`80002?
oooo001Joooo00<0I_ooooooool0:oooo`0306Kooooooooo00Coool00`000?ooooooo`2>oooo000I
oooo0`0003Soool400000_ooo`0306Kooooooooo02_oool00`1Vooooooooo`04oooo00<0003ooooo
ool0=oooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0goooo00<0003oooooool00ooo
o`0306Kooooooooo02_oool00`1Vooooooooo`04oooo00<0003oooooool0=oooo`030000oooooooo
03goool00`000?ooooooo`0Doooo000Goooo1@0003Woool00`000?ooooooo`02oooo00<0I_oooooo
ool0:oooo`0306Kooooooooo00Coool00`000?ooooooo`0hoooo00<0003oooooool0>Oooo`D0000E
oooo000Aoooo100000;oool010000?ooooooo`0003?oool400001?ooo`050000oooooooooooo06Ko
02goool00`1Vooooooooo`04oooo00<0003oooooool0>Oooo`030000oooooooo03Soool010000?oo
ooooo`0001Koool001Soool00`000?ooo`00000ioooo00@0003oooooool00002oooo00<0I_oooooo
ool0:oooo`0306Kooooooooo00Coool20000>?ooo`040000oooooooo0000>_ooo`030000oooo0000
01Koool001Woool20000>_ooo`800003oooo00<0I_ooooooool0:oooo`0306Kooooooooo00Coool0
0`000?ooooooo`0hoooo0P0003coool200005_ooo`00F_ooo`0306Kooooooooo02_oool00`1Voooo
ooooo`04oooo00<0003oooooool0S_ooo`00F_ooo`0306Kooooooooo02_oool00`1Vooooooooo`04
oooo00<0003oooooool0S_ooo`00F_ooo`0306Kooooooooo02_oool00`1Vooooooooo`04oooo00<0
003oooooool0S_ooo`00F_ooo`0306Kooooooooo02_oool00`1Vooooooooo`04oooo00<0003ooooo
ool0S_ooo`00F_ooo`0306Kooooooooo02_oool00`1Vooooooooo`04oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`04oooo00?o09Woooooool01Ooo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0Eoooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?oo
ooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27
oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool200001Oooo`03o`2I
oooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000
oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo
08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo
00Coool00ol0VOooooooo`27oooo002?oooo0P0000Goool00ol0VOooooooo`27oooo002?oooo00<0
003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Wooooo
ool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0003ooooo
ool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qooo
o`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo0P0000Goool00ol0VOoo
ooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?oo
ooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27
oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04
oooo00?o09Woooooool0Qoooo`00Soooo`800005oooo00?o09Woooooool0Qoooo`00Soooo`030000
oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo
08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00O?ooo`800004oooo0P00
00Coool200001Oooo`030000oooooooo00Coool00ol0VOooooooo`27oooo001koooo00@0003ooooo
ool00008oooo00@0003oooooool00004oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool0
07_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`0000Coool00ol0VOooooooo`27
oooo001koooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`04oooo00?o09Wooooo
ool0Qoooo`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`04
oooo00?o09Woooooool0Qoooo`00O?ooo`80000:oooo0`0000Coool00`000?ooooooo`04oooo00?o
09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0
003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool200001Oooo`03o`2Ioooooooo08Ooool0
08ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool0
0ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool0
0`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOoo
ooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool200001Ooo
o`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Sooo
o`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2I
oooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000
oooooooo00Coool00ol0VOooooooo`27oooo002?oooo0P0000Goool00ol0VOooooooo`27oooo002?
oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o
09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0
003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Wooooo
ool0Qoooo`00Soooo`800005oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool0
0ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool0
0`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Qoooo`D00003oooo00<0003oooooool01?oo
o`03o`2Ioooooooo08Ooool008Woool00`000?ooooooo`03oooo00<0003oooooool01?ooo`03o`2I
oooooooo08Ooool008Woool00`000?ooooooo`03oooo0`0000Coool00ol0VOooooooo`27oooo0029
oooo00<0003oooooool00oooo`030000oooooooo00Coool00ol0VOooooooo`27oooo0029oooo00<0
003oooooool00oooo`030000oooooooo00Coool00ol0VOooooooo`27oooo0028oooo0P0000Goool0
0`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOoo
ooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?oo
ooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`800005oooo00?o09Woooooool0Qoooo`00Sooo
o`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2I
oooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000
oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo
08Ooool008ooool200001Oooo`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o
09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0
003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Wooooo
ool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo0P0000Goool0
0ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool0
0`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOoo
ooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?oo
ooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`800005oooo00?o09Woooooool0Qoooo`00Sooo
o`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2I
oooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000
oooooooo00Coool00ol0VOooooooo`27oooo001koooo1@0000;oool200001?ooo`800005oooo00<0
003oooooool01?ooo`03o`2Ioooooooo08Ooool007goool00`000?ooooooo`07oooo00@0003ooooo
ool00004oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool007goool00`000?ooooooo`0:
oooo00<0003oooooool00_ooo`<00004oooo00?o09Woooooool0Qoooo`00OOooo`030000oooooooo
00Soool20000U_ooo`00OOooo`030000oooooooo00Soool00`000?ooooooo`2Eoooo001loooo0P00
00[oool30000UOooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000
oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo
07Goool007Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001?ooo`030000oooooooo07Goool007Goool01@000?oo
ooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000
oooooooo00002_ooo`050000oooooooooooo000000;oool01@000?ooooooooooo`00001goooo001d
oooo00<0003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`05
00004_ooo`040000oooooooo00002oooo`040000oooooooooooo0P0000Coool00`000?ooooooo`1e
oooo001eoooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05ooo
o`800009oooo100000?oool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Ooo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.51896 .24721 L
.52455 .24721 L
.52986 .24721 L
.53217 .24721 L
.53344 .24721 L
.53463 .24721 L
.53531 .24721 L
s
.53531 .24721 m
.53542 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.27193 .24721 L
.28302 .24721 L
.2881 .24721 L
.29088 .24721 L
.29349 .24721 L
.2957 .24721 L
.29695 .24721 L
.29809 .12361 L
.29933 .12361 L
.30069 .12361 L
.30316 .12361 L
.3438 .12361 L
.38293 .12361 L
.40291 .12361 L
.42451 .12361 L
.43466 .12361 L
.44538 .12361 L
.45453 .12361 L
.45704 .12361 L
.45973 .12361 L
.46103 .12361 L
.46227 .12361 L
.46337 .12361 L
.46458 .24721 L
.4658 .24721 L
.46691 .24721 L
.46943 .24721 L
.47398 .24721 L
.48435 .24721 L
.50536 .24721 L
.54499 .24721 L
.58309 .24721 L
.62365 .24721 L
.6627 .24721 L
.7042 .24721 L
.74418 .24721 L
.78265 .24721 L
.82356 .24721 L
.86297 .24721 L
.90085 .24721 L
.94119 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00G?oooal0I_l01000001Vo`1Vo`0000P0I_l3
oooo00<0003oooooool00_ooo`<0002>oooo001Loooo00<0I_ooooooool05_ooo`@00002oooo00@0
003oooooool00007oooo00@0I_ooool000000005oooo00<0003oooooool0S_ooo`00G?ooo`0306Ko
oooooooo01coool010000?ooooooo`0000Ooool00`1Vooooo`000006oooo00<0003oooooool0S_oo
o`00G?ooo`0306Kooooooooo01goool200002?ooo`0306Kooooo000000800004oooo00<0003ooooo
ool0S_ooo`00G?ooo`0306Kooooooooo02Ooool00`1Vooooooooo`06oooo00<0003oooooool0S_oo
o`00G?ooo`0306Kooooooooo02Ooool00`1Vooooooooo`06oooo00<0003oooooool0S_ooo`00G?oo
o`0306Kooooooooo02Ooool00`1Vooooooooo`06oooo00<0003oooooool0S_ooo`00G?ooo`0306Ko
oooooooo02Ooool00`1Vooooooooo`06oooo0P0008ooool005coool00`1Vooooooooo`0Woooo00<0
I_ooooooool01_ooo`030000oooooooo08koool005coool00`1Vooooooooo`0Woooo00<0I_oooooo
ool01_ooo`030000oooooooo08koool005coool00`1Vooooooooo`0Woooo00<0I_ooooooool01_oo
o`030000oooooooo08koool005coool00`1Vooooooooo`0Woooo00<0I_ooooooool01_ooo`030000
oooooooo08koool005coool00`1Vooooooooo`0Woooo00<0I_ooooooool01_ooo`030000oooooooo
08koool005coool00`1Vooooooooo`0Woooo00<0I_ooooooool01_ooo`80002?oooo001Loooo00<0
I_ooooooool09oooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo001Loooo00<0I_oooooo
ool09oooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo001Koooo00<0I_ooooooool0:?oo
o`0306Kooooooooo00Koool00`000?ooooooo`2>oooo001Koooo00<0I_ooooooool0:?ooo`0306Ko
oooooooo00Koool00`000?ooooooo`2>oooo001Koooo00<0I_ooooooool0:?ooo`0306Kooooooooo
00Koool00`000?ooooooo`2>oooo001Koooo00<0I_ooooooool0:?ooo`0306Kooooooooo00Koool2
0000Soooo`00Foooo`0306Kooooooooo02Soool00`1Vooooooooo`06oooo00<0003oooooool0S_oo
o`006Oooo`<0000hoooo100000?oool00`1Vooooooooo`0Xoooo00<0I_ooooooool01_ooo`030000
oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000oooooooo
00Coool00`1Vooooooooo`0Xoooo00<0I_ooooooool01_ooo`030000oooooooo03Ooool00`000?oo
ooooo`0moooo00<0003oooooool05?ooo`005oooo`D0000ioooo00<0003oooooool00oooo`0306Ko
oooooooo02Soool00`1Vooooooooo`06oooo00<0003oooooool0>?ooo`030000oooooooo03Woool5
00005Oooo`004Oooo`@00002oooo00@0003oooooool0000coooo100000Coool00`000?ooooooo`02
oooo00<0I_ooooooool0:?ooo`0306Kooooooooo00Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000oooo000003Woool010000?ooooooo`00
00?oool00`1Vooooooooo`0Xoooo00<0I_ooooooool01_ooo`80000hoooo00@0003oooooool0000j
oooo00<0003oool000005_ooo`006Oooo`80000joooo0P0000Coool00`1Vooooooooo`0Xoooo00<0
I_ooooooool01_ooo`030000oooooooo03Soool20000??ooo`80000Foooo001Koooo00<0I_oooooo
ool0:?ooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo001Koooo00<0I_ooooooool0:?oo
o`0306Kooooooooo00Koool00`000?ooooooo`2>oooo001Koooo00<0I_ooooooool0:?ooo`0306Ko
oooooooo00Koool00`000?ooooooo`2>oooo001Koooo00<0I_ooooooool0:?ooo`0306Kooooooooo
00Koool00`000?ooooooo`2>oooo001Koooo00<0I_ooooooool0:?ooo`0306Kooooooooo00Koool0
0`000?ooooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00Koool0
0ol0VOooooooo`03oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo01Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOoo
o`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_oo
o`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Sooo
o`800007oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25
oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06
oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?
oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool200001oooo`03o`2Ioooooooo
08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo
00Koool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool0
08ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool0
0ol0VOooooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool2
00001oooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOoo
o`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_oo
o`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Sooo
o`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo0P0000Ooool00ol0VOooooooo`25
oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06
oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo001l
oooo0P0000Coool200001?ooo`800005oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool0
07_oool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?ooooooo`06oooo00?o
09Woooooool0QOooo`00Noooo`040000oooooooo00002oooo`030000oooooooo00;oool300001_oo
o`03o`2Ioooooooo08Goool007_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo
00Koool00ol0VOooooooo`25oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?oo
o`030000oooooooo00Koool00ol0VOooooooo`25oooo001loooo0P0000[oool300001?ooo`030000
oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo
08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Soooo`800007oooo00?o
09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0
003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Wooooo
ool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0003ooooo
ool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOoo
o`00Soooo`800007oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOoo
ooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?oo
ooooo`06oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25
oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool200001oooo`03o`2I
oooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Soooo`030000
oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo
08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo
00Koool00ol0VOooooooo`25oooo002?oooo0P0000Ooool00ol0VOooooooo`25oooo002?oooo00<0
003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Wooooo
ool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo0027oooo1@0000?oool0
0`000?ooooooo`06oooo00?o09Woooooool0QOooo`00ROooo`030000oooooooo00?oool00`000?oo
ooooo`06oooo00?o09Woooooool0QOooo`00ROooo`030000oooooooo00?oool300001_ooo`03o`2I
oooooooo08Goool008Woool00`000?ooooooo`03oooo00<0003oooooool01_ooo`03o`2Ioooooooo
08Goool008Woool00`000?ooooooo`03oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool0
08Soool200001Oooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0003ooooo
ool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOoo
o`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo0P0000Ooool00ol0VOoo
ooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?oo
ooooo`06oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25
oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06
oooo00?o09Woooooool0QOooo`00Soooo`800007oooo00?o09Woooooool0QOooo`00Soooo`030000
oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo
08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo
00Koool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool0
08ooool200001oooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Wooooo
ool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0003ooooo
ool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOoo
o`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo0P0000Ooool00ol0VOoo
ooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?oo
ooooo`06oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25
oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool007_oool500000_ooo`800004
oooo0P0000Goool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00OOooo`030000oooooooo
00Ooool010000?ooooooo`0000Coool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00OOoo
o`030000oooooooo00[oool00`000?ooooooo`02oooo0`0000Koool00ol0VOooooooo`25oooo001m
oooo00<0003oooooool02?ooo`80002Foooo001moooo00<0003oooooool02?ooo`030000oooooooo
09Goool007coool200002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool007Woool00`000?oo
ooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0O
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00goool200001?ooo`800005oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000ooo
o`040000oooooooo00002_ooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001goooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool00`000?ooooooo`03
oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool0000;
oooo00D0003oooooooooool00000N_ooo`00N?ooo`050000oooooooooooo000001Goool010000?oo
ooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003ooooo
ool05oooo`800009oooo100000;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool0
0001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.52059 .24721 L
.53057 .24721 L
.53543 .24721 L
.53755 .24721 L
.53984 .24721 L
.54107 .24721 L
s
.54107 .24721 m
.54124 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.28158 .24721 L
.29205 .24721 L
.29779 .24721 L
.30059 .24721 L
.30182 .24721 L
.30246 .24721 L
.30316 .24721 L
.30442 .12361 L
.3056 .12361 L
.30791 .12361 L
.31304 .12361 L
.32392 .12361 L
.34309 .12361 L
.38467 .12361 L
.40553 .12361 L
.42473 .12361 L
.44348 .12361 L
.45292 .12361 L
.45551 .12361 L
.45693 .12361 L
.45763 .12361 L
.45828 .12361 L
.45953 .24721 L
.4602 .24721 L
.4609 .24721 L
.46328 .24721 L
.50104 .24721 L
.54124 .24721 L
.57993 .24721 L
.62107 .24721 L
.66069 .24721 L
.6988 .24721 L
.73936 .24721 L
.7784 .24721 L
.8199 .24721 L
.85988 .24721 L
.89835 .24721 L
.93927 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00GOoooah0I_l01000001Vo`1Vo`0000H0I_l5
oooo00<0003oooooool00_ooo`<0002>oooo001Moooo00<0I_ooooooool05Oooo`@00002oooo00@0
003oooooool00005oooo00@0I_ooooooooooool200001Oooo`030000oooooooo08koool005goool0
0`1Vooooooooo`0Koooo00@0003oooooool00005oooo00D0I_ooooooooooool000001_ooo`030000
oooooooo08koool005goool00`1Vooooooooo`0Loooo0P0000Koool0101Vooooooooooooo`<00004
oooo00<0003oooooool0S_ooo`00GOooo`0306Kooooooooo02Coool00`1Vooooooooo`08oooo00<0
003oooooool0S_ooo`00GOooo`0306Kooooooooo02Coool00`1Vooooooooo`08oooo00<0003ooooo
ool0S_ooo`00GOooo`0306Kooooooooo02Coool00`1Vooooooooo`08oooo00<0003oooooool0S_oo
o`00GOooo`0306Kooooooooo02Coool00`1Vooooooooo`08oooo0P0008ooool005goool00`1Voooo
ooooo`0Toooo00<0I_ooooooool02?ooo`030000oooooooo08koool005goool00`1Vooooooooo`0T
oooo00<0I_ooooooool02?ooo`030000oooooooo08koool005goool00`1Vooooooooo`0Toooo00<0
I_ooooooool02?ooo`030000oooooooo08koool005goool00`1Vooooooooo`0Toooo00<0I_oooooo
ool02?ooo`030000oooooooo08koool005goool00`1Vooooooooo`0Toooo00<0I_ooooooool02?oo
o`030000oooooooo08koool005goool00`1Vooooooooo`0Toooo00<0I_ooooooool02?ooo`80002?
oooo001Moooo00<0I_ooooooool09?ooo`0306Kooooooooo00Soool00`000?ooooooo`2>oooo001M
oooo00<0I_ooooooool09?ooo`0306Kooooooooo00Soool00`000?ooooooo`2>oooo001Moooo00<0
I_ooooooool09?ooo`0306Kooooooooo00Soool00`000?ooooooo`2>oooo001Moooo00<0I_oooooo
ool09Oooo`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo001Moooo00<0I_ooooooool09Ooo
o`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo001Moooo00<0I_ooooooool09Oooo`0306Ko
oooooooo00Ooool20000Soooo`00GOooo`0306Kooooooooo02Goool00`1Vooooooooo`07oooo00<0
003oooooool0S_ooo`006Oooo`<0000hoooo100000Goool00`1Vooooooooo`0Uoooo00<0I_oooooo
ool01oooo`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=ooo
o`030000oooooooo00Koool00`1Vooooooooo`0Uoooo00<0I_ooooooool01oooo`030000oooooooo
03Ooool00`000?ooooooo`0moooo00<0003oooooool05?ooo`005oooo`D0000ioooo00<0003ooooo
ool01Oooo`0306Kooooooooo02Goool00`1Vooooooooo`07oooo00<0003oooooool0>?ooo`030000
oooooooo03Woool500005Oooo`004Oooo`@00002oooo00@0003oooooool0000coooo100000Coool0
0`000?ooooooo`04oooo00<0I_ooooooool09Oooo`0306Kooooooooo00Ooool00`000?ooooooo`0i
oooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000oooo000003Woool0
10000?ooooooo`0000Goool00`1Vooooooooo`0Uoooo00<0I_ooooooool01oooo`80000hoooo00@0
003oooooool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0000Koool00`1Voooo
ooooo`0Uoooo00<0I_ooooooool01oooo`030000oooooooo03Soool20000??ooo`80000Foooo001M
oooo00<0I_ooooooool09Oooo`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo001Moooo00<0
I_ooooooool09Oooo`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo001Moooo00<0I_oooooo
ool09Oooo`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo001Moooo00<0I_ooooooool09Ooo
o`0306Kooooooooo00Ooool00`000?ooooooo`2>oooo001Moooo00<0I_ooooooool09Oooo`0306Ko
oooooooo00Ooool00`000?ooooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00Ooool00ol0VOooooooo`02oooo00<0003oooooool03?ooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo01Goool008ooool00`000?ooooooo`07oooo00?o
09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo00<0
003oooooool01oooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Wooooo
ool0Q?ooo`00Soooo`800008oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool0
0ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool0
0`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOoo
ooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool200002?oo
o`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Sooo
o`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2I
oooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`030000
oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo
08Coool008ooool200002?ooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o
09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo00<0
003oooooool01oooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Wooooo
ool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo0P0000Soool0
0ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool0
0`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOoo
ooooo`24oooo001loooo0P0000Coool200001?ooo`800005oooo00<0003oooooool01oooo`03o`2I
oooooooo08Coool007_oool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?oo
ooooo`07oooo00?o09Woooooool0Q?ooo`00Noooo`040000oooooooo00002oooo`030000oooooooo
00;oool300001oooo`03o`2Ioooooooo08Coool007_oool010000?ooooooo`0000Woool200001Ooo
o`030000oooooooo00Ooool00ol0VOooooooo`24oooo001koooo00@0003oooooool00009oooo00<0
003oooooool01?ooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo001loooo0P0000[oool3
00001?ooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01ooo
o`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Sooo
o`800008oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24
oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07
oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?
oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o
09Woooooool0Q?ooo`00Soooo`800008oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo
00Ooool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool0
08ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool0
0ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool2
00002?ooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?oo
o`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01ooo
o`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Sooo
o`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo0P0000Soool00ol0VOooooooo`24
oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07
oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo0027
oooo1@0000?oool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00ROooo`030000oooooooo
00?oool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00ROooo`030000oooooooo00?oool3
00001oooo`03o`2Ioooooooo08Coool008Woool00`000?ooooooo`03oooo00<0003oooooool01ooo
o`03o`2Ioooooooo08Coool008Woool00`000?ooooooo`03oooo00<0003oooooool01oooo`03o`2I
oooooooo08Coool008Soool200001Oooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?
oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o
09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo0P00
00Soool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool0
08ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool0
0ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool0
0`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`800008oooo00?o09Woooooool0Q?oo
o`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01ooo
o`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Sooo
o`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2I
oooooooo08Coool008ooool200002?ooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07
oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?
oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o
09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo0P00
00Soool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool0
08ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool0
0ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool007_oool5
00000_ooo`800004oooo0P0000Goool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00OOoo
o`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`07oooo00?o09Wooooo
ool0Q?ooo`00OOooo`030000oooooooo00[oool00`000?ooooooo`02oooo0`0000Ooool00ol0VOoo
ooooo`24oooo001moooo00<0003oooooool02?ooo`80002Foooo001moooo00<0003oooooool02?oo
o`030000oooooooo09Goool007coool200002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool0
07Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000oooooooo00Soool0
0`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?oo
o`030000oooooooo00goool200001?ooo`800003oooo0`0000Coool200001?ooo`030000oooooooo
07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo
00000oooo`030000oooooooo07Goool007Coool00`000?ooooooo`02oooo00<0003oooooool04ooo
o`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo00;oool00`000?oo
ooooo`1doooo001eoooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool300001?oo
o`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000001Goool010000?oo
ooooo`0000Woool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo07Goool0
07Koool00`000?ooooooo`0Goooo0P0000[oool300000oooo`<00002oooo00<0003oooooool0M_oo
o`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.52059 .24721 L
.53057 .24721 L
.53984 .24721 L
.54444 .24721 L
.54576 .24721 L
.54701 .24721 L
s
.54701 .24721 m
.54718 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.28158 .24721 L
.29205 .24721 L
.29779 .24721 L
.30316 .24721 L
.3056 .24721 L
.30791 .24721 L
.30919 .24721 L
.30992 .12361 L
.31059 .12361 L
.31304 .12361 L
.32392 .12361 L
.34309 .12361 L
.38221 .12361 L
.40219 .12361 L
.4238 .12361 L
.43394 .12361 L
.43949 .12361 L
.44466 .12361 L
.44908 .12361 L
.45035 .12361 L
.45156 .12361 L
.45264 .24721 L
.45382 .24721 L
.46386 .24721 L
.50465 .24721 L
.54391 .24721 L
.58166 .24721 L
.62187 .24721 L
.66055 .24721 L
.70169 .24721 L
.74132 .24721 L
.77943 .24721 L
.81999 .24721 L
.85903 .24721 L
.90053 .24721 L
.94051 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Gooooa`0I_l01000001Vo`1Vo`0000D0I_l6
oooo00<0003oooooool00_ooo`<0002>oooo001Ooooo00<0I_ooooooool04oooo`@00002oooo00@0
003oooooool00004oooo00<0I_ooooooool00_ooo`800005oooo00<0003oooooool0S_ooo`00Gooo
o`0306Kooooooooo01Woool010000?ooooooo`0000Coool00`1Vooooooooo`02oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool005ooool00`1Vooooooooo`0Joooo0P0000Goool00`1Voooo
ooooo`02oooo0`0000Coool00`000?ooooooo`2>oooo001Ooooo00<0I_ooooooool08Oooo`0306Ko
oooooooo00Woool00`000?ooooooo`2>oooo001Ooooo00<0I_ooooooool08Oooo`0306Kooooooooo
00Woool00`000?ooooooo`2>oooo001Ooooo00<0I_ooooooool08Oooo`0306Kooooooooo00Woool0
0`000?ooooooo`2>oooo001Ooooo00<0I_ooooooool08Oooo`0306Kooooooooo00Woool20000Sooo
o`00Goooo`0306Kooooooooo027oool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Gooo
o`0306Kooooooooo027oool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Goooo`0306Ko
oooooooo027oool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Goooo`0306Kooooooooo
027oool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Goooo`0306Kooooooooo027oool0
0`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00Goooo`0306Kooooooooo027oool00`1Voooo
ooooo`09oooo0P0008ooool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000
oooooooo08koool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo
08koool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo08koool0
05ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo08koool005ooool0
0`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo08koool005ooool00`1Voooo
ooooo`0Qoooo00<0I_ooooooool02Oooo`80002?oooo001Ooooo00<0I_ooooooool08Oooo`0306Ko
oooooooo00Woool00`000?ooooooo`2>oooo000Ioooo0`0003Soool400001oooo`0306Kooooooooo
027oool00`1Vooooooooo`09oooo00<0003oooooool0=oooo`@0000koooo0`0001Goool001[oool0
0`000?ooooooo`0goooo00<0003oooooool02?ooo`0306Kooooooooo027oool00`1Vooooooooo`09
oooo00<0003oooooool0=oooo`030000oooooooo03goool00`000?ooooooo`0Doooo000Goooo1@00
03Woool00`000?ooooooo`07oooo00<0I_ooooooool08Oooo`0306Kooooooooo00Woool00`000?oo
ooooo`0hoooo00<0003oooooool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?ooooooo`00
03?oool400001?ooo`030000oooooooo00Koool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Ooo
o`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000Foooo000Hoooo00<0
003oool00000>Oooo`040000oooooooo00001oooo`0306Kooooooooo027oool00`1Vooooooooo`09
oooo0P0003Soool010000?ooooooo`0003[oool00`000?ooo`00000Foooo000Ioooo0P0003[oool2
00002?ooo`0306Kooooooooo027oool00`1Vooooooooo`09oooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo
08koool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo08koool0
05ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo08koool005ooool0
0`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo08koool005ooool00`1Voooo
ooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo08koool0013ooooo00004Oooo`005_oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool02Oooo`04o`2Ioooooooo00003_ooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo01Goool008ooool00`000?ooooooo`09oooo00?o
09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0
003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Wooooo
ool0P_ooo`00Soooo`80000:oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool0
0ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool0
0`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOoo
ooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool200002_oo
o`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Sooo
o`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2I
oooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`030000
oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo
08;oool008ooool200002_ooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o
09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0
003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Wooooo
ool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo0P0000[oool0
0ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool0
0`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOoo
ooooo`22oooo001loooo0P0000Coool200001?ooo`800005oooo00<0003oooooool02Oooo`03o`2I
oooooooo08;oool007_oool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?oo
ooooo`09oooo00?o09Woooooool0P_ooo`00Noooo`040000oooooooo00002oooo`030000oooooooo
00;oool300002Oooo`03o`2Ioooooooo08;oool007_oool010000?ooooooo`0000Woool200001Ooo
o`030000oooooooo00Woool00ol0VOooooooo`22oooo001koooo00@0003oooooool00009oooo00<0
003oooooool01?ooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001loooo0P0000[oool3
00001?ooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Ooo
o`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Sooo
o`80000:oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22
oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09
oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?
oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o
09Woooooool0P_ooo`00Soooo`80000:oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo
00Woool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool0
08ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool0
0ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool2
00002_ooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Woooooool0P_oo
o`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Ooo
o`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Sooo
o`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo0P0000[oool00ol0VOooooooo`22
oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09
oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo0027
oooo1@0000?oool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00ROooo`030000oooooooo
00?oool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00ROooo`030000oooooooo00?oool3
00002Oooo`03o`2Ioooooooo08;oool008Woool00`000?ooooooo`03oooo00<0003oooooool02Ooo
o`03o`2Ioooooooo08;oool008Woool00`000?ooooooo`03oooo00<0003oooooool02Oooo`03o`2I
oooooooo08;oool008Soool200001Oooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?
oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o
09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo0P00
00[oool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool0
08ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool0
0ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool0
0`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`80000:oooo00?o09Woooooool0P_oo
o`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Ooo
o`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Sooo
o`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2I
oooooooo08;oool008ooool200002_ooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09
oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?
oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o
09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo0P00
00[oool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool0
08ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool0
0ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool007_oool5
00000_ooo`800004oooo0P0000Goool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00OOoo
o`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`09oooo00?o09Wooooo
ool0P_ooo`00OOooo`030000oooooooo00[oool00`000?ooooooo`02oooo0`0000Woool00ol0VOoo
ooooo`22oooo001moooo00<0003oooooool02?ooo`80002Foooo001moooo00<0003oooooool02?oo
o`030000oooooooo09Goool007coool200002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool0
07Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool0
0`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?oo
o`030000oooooooo00goool200001?ooo`800003oooo0`0000Coool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo1000
00?oool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001g
oooo00<0003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000Soool300001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000E
oooo00@0003oooooool00009oooo00<0003oooooool00oooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Goooo0P0000[oool300000_ooo`030000oooooooo07Woool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.52059 .24721 L
.53984 .24721 L
.54444 .24721 L
.54934 .24721 L
.5508 .24721 L
.55216 .24721 L
.55339 .24721 L
s
.55339 .24721 m
.5535 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.28158 .24721 L
.29205 .24721 L
.30316 .24721 L
.30791 .24721 L
.31054 .24721 L
.31304 .24721 L
.31444 .24721 L
.31523 .24721 L
.31597 .12361 L
.31727 .12361 L
.31865 .12361 L
.32392 .12361 L
.34309 .12361 L
.38467 .12361 L
.40553 .12361 L
.42473 .12361 L
.43443 .12361 L
.43916 .12361 L
.44348 .12361 L
.4446 .12361 L
.44582 .12361 L
.44697 .24721 L
.44804 .24721 L
.45292 .24721 L
.46328 .24721 L
.50255 .24721 L
.5403 .24721 L
.5805 .24721 L
.61919 .24721 L
.66033 .24721 L
.69996 .24721 L
.73806 .24721 L
.77863 .24721 L
.81767 .24721 L
.85917 .24721 L
.89915 .24721 L
.93762 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00H?oooa/0I_l01000001Vo`1Vo`0000<0I_l8
oooo00<0003oooooool00_ooo`<0002>oooo001Poooo00<0I_ooooooool04_ooo`@00002oooo00@0
003oooooool00002oooo00<0I_ooooooool01?ooo`800005oooo00<0003oooooool0S_ooo`00H?oo
o`0306Kooooooooo01Soool010000?ooooooo`0000;oool00`1Vooooooooo`04oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool0063oool00`1Vooooooooo`0Ioooo0P0000?oool00`1Voooo
ooooo`04oooo0`0000Coool00`000?ooooooo`2>oooo001Poooo00<0I_ooooooool07_ooo`0306Ko
oooooooo00_oool00`000?ooooooo`2>oooo001Poooo00<0I_ooooooool07_ooo`0306Kooooooooo
00_oool00`000?ooooooo`2>oooo001Poooo00<0I_ooooooool07_ooo`0306Kooooooooo00_oool0
0`000?ooooooo`2>oooo001Poooo00<0I_ooooooool07_ooo`0306Kooooooooo00_oool20000Sooo
o`00H?ooo`0306Kooooooooo01koool00`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00H?oo
o`0306Kooooooooo01koool00`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00H?ooo`0306Ko
oooooooo01koool00`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00H?ooo`0306Kooooooooo
01koool00`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00H?ooo`0306Kooooooooo01koool0
0`1Vooooooooo`0;oooo00<0003oooooool0S_ooo`00H?ooo`0306Kooooooooo01koool00`1Voooo
ooooo`0;oooo0P0008ooool0063oool00`1Vooooooooo`0Noooo00<0I_ooooooool02oooo`030000
oooooooo08koool0063oool00`1Vooooooooo`0Noooo00<0I_ooooooool02oooo`030000oooooooo
08koool0063oool00`1Vooooooooo`0Noooo00<0I_ooooooool02oooo`030000oooooooo08koool0
063oool00`1Vooooooooo`0Ooooo00<0I_ooooooool02_ooo`030000oooooooo08koool0063oool0
0`1Vooooooooo`0Ooooo00<0I_ooooooool02_ooo`030000oooooooo08koool0063oool00`1Voooo
ooooo`0Ooooo00<0I_ooooooool02_ooo`80002?oooo001Poooo00<0I_ooooooool07oooo`0306Ko
oooooooo00[oool00`000?ooooooo`2>oooo000Ioooo0`0003Soool400002?ooo`0306Kooooooooo
01ooool00`1Vooooooooo`0:oooo00<0003oooooool0=oooo`@0000koooo0`0001Goool001[oool0
0`000?ooooooo`0goooo00<0003oooooool02Oooo`0306Kooooooooo01ooool00`1Vooooooooo`0:
oooo00<0003oooooool0=oooo`030000oooooooo03goool00`000?ooooooo`0Doooo000Goooo1@00
03Woool00`000?ooooooo`08oooo00<0I_ooooooool07oooo`0306Kooooooooo00[oool00`000?oo
ooooo`0hoooo00<0003oooooool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?ooooooo`00
03?oool400001?ooo`030000oooooooo00Ooool00`1Vooooooooo`0Ooooo00<0I_ooooooool02_oo
o`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000Foooo000Hoooo00<0
003oool00000>Oooo`040000oooooooo00002?ooo`0306Kooooooooo01ooool00`1Vooooooooo`0:
oooo0P0003Soool010000?ooooooo`0003[oool00`000?ooo`00000Foooo000Ioooo0P0003[oool2
00002Oooo`0306Kooooooooo01ooool00`1Vooooooooo`0:oooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool0063oool00`1Vooooooooo`0Ooooo00<0I_ooooooool02_ooo`030000oooooooo
08koool0063oool00`1Vooooooooo`0Ooooo00<0I_ooooooool02_ooo`030000oooooooo08koool0
063oool00`1Vooooooooo`0Ooooo00<0I_ooooooool02_ooo`030000oooooooo08koool0063oool0
0`1Vooooooooo`0Ooooo00<0I_ooooooool02_ooo`030000oooooooo08koool0063oool00`1Voooo
ooooo`0Ooooo00<0I_ooooooool02_ooo`030000oooooooo08koool0013ooooo00004Oooo`005_oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool02oooo`03o`2I0000oooo00goool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0Eoooo002?oooo00<0003oooooool02oooo`03o`2I
oooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`030000
oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo
083oool008ooool200003?ooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o
09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0
003oooooool02oooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Wooooo
ool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo0P0000coool0
0ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool0
0`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOoo
ooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool00`000?oo
ooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20
oooo002?oooo0P0000coool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2I
oooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`030000
oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo
083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`80000<oooo00?o
09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0
003oooooool02oooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Wooooo
ool0P?ooo`00O?ooo`800004oooo0P0000Coool200001Oooo`030000oooooooo00_oool00ol0VOoo
ooooo`20oooo001koooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0003ooooo
ool02oooo`03o`2Ioooooooo083oool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02
oooo0`0000_oool00ol0VOooooooo`20oooo001koooo00@0003oooooool00009oooo0P0000Goool0
0`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Noooo`040000oooooooo00002Oooo`030000
oooooooo00Coool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00O?ooo`80000:oooo0`00
00Coool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool0
0ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool2
00003?ooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?oo
o`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02ooo
o`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Sooo
o`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2I
oooooooo083oool008ooool200003?ooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;
oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?
oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o
09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo0P00
00coool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool0
08ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool0
0ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool0
0`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`80000<oooo00?o09Woooooool0P?oo
o`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02ooo
o`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Qooo
o`D00003oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008Woool00`000?ooooooo`03
oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008Woool00`000?ooooooo`03oooo0`00
00_oool00ol0VOooooooo`20oooo0029oooo00<0003oooooool00oooo`030000oooooooo00_oool0
0ol0VOooooooo`20oooo0029oooo00<0003oooooool00oooo`030000oooooooo00_oool00ol0VOoo
ooooo`20oooo0028oooo0P0000Goool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Sooo
o`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2I
oooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`80000<
oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?
oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o
09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0
003oooooool02oooo`03o`2Ioooooooo083oool008ooool200003?ooo`03o`2Ioooooooo083oool0
08ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool0
0ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool0
0`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOoo
ooooo`20oooo002?oooo0P0000coool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02ooo
o`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Sooo
o`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2I
oooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`80000<
oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?
oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o
09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo001koooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool007goool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool02oooo`03o`2Ioooooooo
083oool007goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0000;oooo00?o09Wooooo
ool0P?ooo`00OOooo`030000oooooooo00Soool20000U_ooo`00OOooo`030000oooooooo00Soool0
0`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOooo`00ooooob7oool00?oooolQoooo001f
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0
003oooooool09Oooo`030000oooooooo07Goool007Goool00`000?ooooooo`02oooo0P0000Coool0
0`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004oooo0P0000Coool00`000?ooooooo`1e
oooo001eoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04
oooo100000?oool010000?ooooooo`0000Soool010000?ooooooo`0000;oool010000?ooooooo`00
00?oool00`000?ooooooo`1eoooo001doooo00<0003oooooool00_ooo`030000oooooooo01?oool0
10000?ooooooo`0000_oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`030000oooooooo
07Coool007Goool00`000?ooooooo`0500004_ooo`040000oooooooo00002Oooo`800004oooo0P00
00Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005Oooo`040000oooooooo
00002Oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool0MOooo`00M_oo
o`030000oooooooo01Ooool200002_ooo`<00003oooo0`0000;oool00`000?ooooooo`1foooo003o
oooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.52059 .24721 L
.53984 .24721 L
.54934 .24721 L
.55195 .24721 L
.55472 .24721 L
.55607 .24721 L
.55734 .24721 L
.55848 .24721 L
s
.55848 .24721 m
.55867 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.28158 .24721 L
.29205 .24721 L
.30316 .24721 L
.31304 .24721 L
.31574 .24721 L
.31865 .24721 L
.32006 .24721 L
.32076 .24721 L
.3214 .24721 L
.3226 .12361 L
.32392 .12361 L
.34309 .12361 L
.38221 .12361 L
.40219 .12361 L
.4127 .12361 L
.4238 .12361 L
.43374 .12361 L
.43647 .12361 L
.43797 .12361 L
.43871 .12361 L
.43939 .12361 L
.44071 .24721 L
.44141 .24721 L
.44215 .24721 L
.44466 .24721 L
.46386 .24721 L
.50161 .24721 L
.54182 .24721 L
.5805 .24721 L
.62164 .24721 L
.66127 .24721 L
.69938 .24721 L
.73994 .24721 L
.77898 .24721 L
.82048 .24721 L
.86046 .24721 L
.89893 .24721 L
.93985 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00H_oooaT0I_l01000001Vo`1Vo`000080I_l9
oooo00<0003oooooool00_ooo`<0002>oooo001Roooo00<0I_ooooooool04?ooo`@00002oooo00H0
003oooooool0003oool0I_l7oooo0P0000Goool00`000?ooooooo`2>oooo001Roooo00<0I_oooooo
ool05_ooo`060000oooooooo0000oooo06Ko1oooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo001Roooo00<0I_ooooooool05oooo`800002oooo00<0I_ooooooool01Oooo`<00004oooo00<0
003oooooool0S_ooo`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003ooooo
ool0S_ooo`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003oooooool0S_oo
o`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003oooooool0S_ooo`00H_oo
o`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo0P0008ooool006;oool00`1Vooooooooo`0K
oooo00<0I_ooooooool03?ooo`030000oooooooo08koool006;oool00`1Vooooooooo`0Koooo00<0
I_ooooooool03?ooo`030000oooooooo08koool006;oool00`1Vooooooooo`0Koooo00<0I_oooooo
ool03?ooo`030000oooooooo08koool006;oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?oo
o`030000oooooooo08koool006;oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?ooo`030000
oooooooo08koool006;oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?ooo`80002?oooo001R
oooo00<0I_ooooooool06oooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo001Roooo00<0
I_ooooooool06oooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo001Roooo00<0I_oooooo
ool06oooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo001Roooo00<0I_ooooooool06ooo
o`0306Kooooooooo00coool00`000?ooooooo`2>oooo001Roooo00<0I_ooooooool06oooo`0306Ko
oooooooo00coool00`000?ooooooo`2>oooo001Roooo00<0I_ooooooool06oooo`0306Kooooooooo
00coool20000Soooo`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003ooooo
ool0S_ooo`006Oooo`<0000hoooo100000[oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?oo
o`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000
oooooooo00_oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?ooo`030000oooooooo03Ooool0
0`000?ooooooo`0moooo00<0003oooooool05?ooo`005oooo`D0000ioooo00<0003oooooool02_oo
o`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003oooooool0>?ooo`030000oooooooo
03Woool500005Oooo`004Oooo`@00002oooo00@0003oooooool0000coooo100000Coool00`000?oo
ooooo`09oooo00<0I_ooooooool06oooo`0306Kooooooooo00coool00`000?ooooooo`0ioooo00<0
003oooooool0>?ooo`040000oooooooo00005_ooo`006?ooo`030000oooo000003Woool010000?oo
ooooo`0000[oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?ooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0000_oool00`1Vooooooooo`0K
oooo00<0I_ooooooool03?ooo`030000oooooooo03Soool20000??ooo`80000Foooo001Roooo00<0
I_ooooooool06oooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo001Roooo00<0I_oooooo
ool06oooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo001Roooo00<0I_ooooooool06ooo
o`0306Kooooooooo00coool00`000?ooooooo`2>oooo001Roooo00<0I_ooooooool06oooo`0306Ko
oooooooo00coool00`000?ooooooo`2>oooo001Roooo00<0I_ooooooool06oooo`0306Kooooooooo
00coool00`000?ooooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool05Oooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0
003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Wooooo
ool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo0P0000goool0
0ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool0
0`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOoo
ooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool00`000?oo
ooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`80000=oooo00?o09Woooooool0Ooooo`00Sooo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2I
oooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`030000
oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo
07ooool008ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`80000=oooo00?o
09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0
003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Wooooo
ool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0003ooooo
ool03?ooo`03o`2Ioooooooo07ooool008ooool200003Oooo`03o`2Ioooooooo07ooool008ooool0
0`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOoo
ooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Noooo`040000
oooooooo00002?ooo`040000oooooooo00001?ooo`030000oooooooo00coool00ol0VOooooooo`1o
oooo001koooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`<0000<oooo00?o09Wooooo
ool0Ooooo`00Noooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool03?ooo`03o`2I
oooooooo07ooool007_oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003ooooo
ool03?ooo`03o`2Ioooooooo07ooool007coool200002_ooo`<00004oooo00<0003oooooool03?oo
o`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Sooo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo0P0000goool00ol0VOooooooo`1o
oooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<
oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?
oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o
09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo0P00
00goool00ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool0
08ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool0
0ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool0
0`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`80000=oooo00?o09Woooooool0Oooo
o`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?oo
o`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Sooo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2I
oooooooo07ooool008ooool200003Oooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<
oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?
oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008Ooool500000oooo`030000oooooooo
00coool00ol0VOooooooo`1ooooo0029oooo00<0003oooooool00oooo`030000oooooooo00coool0
0ol0VOooooooo`1ooooo0029oooo00<0003oooooool00oooo`<0000<oooo00?o09Woooooool0Oooo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00ROoo
o`030000oooooooo00?oool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00R?ooo`800005
oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o
09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0
003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool200003Oooo`03o`2Ioooooooo07ooool0
08ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool0
0ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool0
0`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOoo
ooooo`1ooooo002?oooo0P0000goool00ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?oo
o`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Sooo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2I
oooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`80000=
oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?
oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o
09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0
003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool200003Oooo`03o`2Ioooooooo07ooool0
08ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool0
0ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool0
0`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Noooo`D00002oooo0P0000Coool200001Ooo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo001moooo00<0003oooooool01oooo`040000
oooooooo00001?ooo`030000oooooooo00coool00ol0VOooooooo`1ooooo001moooo00<0003ooooo
ool02_ooo`030000oooooooo00;oool300003?ooo`03o`2Ioooooooo07ooool007goool00`000?oo
ooooo`08oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?oo
o`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool0
0`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?oo
ooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004
oooo0P0000Coool200001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0
003oooooool04oooo`040000oooooooo00002oooo`030000oooooooo00;oool00`000?ooooooo`1g
oooo001hoooo00<0003oooooool01@0001;oool010000?ooooooo`0000Woool200001?ooo`030000
oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00009oooo00<0
003oooooool00oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool3
00000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.52059 .24721 L
.53984 .24721 L
.54934 .24721 L
.55436 .24721 L
.55972 .24721 L
.56236 .24721 L
.56366 .24721 L
.56486 .24721 L
s
.56486 .24721 m
.56502 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.28158 .24721 L
.30316 .24721 L
.31323 .24721 L
.31875 .24721 L
.32145 .24721 L
.32392 .24721 L
.32499 .24721 L
.32617 .24721 L
.32728 .24721 L
.32831 .12361 L
.32951 .12361 L
.3306 .12361 L
.33304 .12361 L
.34309 .12361 L
.38315 .12361 L
.40153 .12361 L
.41196 .12361 L
.4217 .12361 L
.42664 .12361 L
.43133 .12361 L
.43258 .12361 L
.43326 .12361 L
.43391 .12361 L
.4346 .24721 L
.43537 .24721 L
.43672 .24721 L
.44164 .24721 L
.46271 .24721 L
.50139 .24721 L
.54253 .24721 L
.58216 .24721 L
.62027 .24721 L
.66083 .24721 L
.69987 .24721 L
.74137 .24721 L
.78135 .24721 L
.81982 .24721 L
.86074 .24721 L
.90014 .24721 L
.93803 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00HooooaP0I_l01000001Vo`1Vo`0000_oool0
0`000?ooooooo`02oooo0`0008koool006?oool00`1Vooooooooo`0?oooo100000;oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool006?oool00`1Vooooooooo`0Eoooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006?oool00`1Voooo
ooooo`0Foooo0P00000306Kooooooooo00Ooool300001?ooo`030000oooooooo08koool006?oool0
0`1Vooooooooo`0Hoooo00<0I_ooooooool03_ooo`030000oooooooo08koool006?oool00`1Voooo
ooooo`0Hoooo00<0I_ooooooool03_ooo`030000oooooooo08koool006?oool00`1Vooooooooo`0H
oooo00<0I_ooooooool03_ooo`030000oooooooo08koool006?oool00`1Vooooooooo`0Hoooo00<0
I_ooooooool03_ooo`80002?oooo001Soooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool0
0`000?ooooooo`2>oooo001Soooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool00`000?oo
ooooo`2>oooo001Soooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool00`000?ooooooo`2>
oooo001Soooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool00`000?ooooooo`2>oooo001S
oooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool00`000?ooooooo`2>oooo001Soooo00<0
I_ooooooool06?ooo`0306Kooooooooo00koool20000Soooo`00Hoooo`0306Kooooooooo01Soool0
0`1Vooooooooo`0>oooo00<0003oooooool0S_ooo`00Hoooo`0306Kooooooooo01Soool00`1Voooo
ooooo`0>oooo00<0003oooooool0S_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>
oooo00<0003oooooool0S_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0
003oooooool0S_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0003ooooo
ool0S_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo0P0008ooool006?oool0
0`1Vooooooooo`0Hoooo00<0I_ooooooool03_ooo`030000oooooooo08koool001Woool30000>?oo
o`@0000;oooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool00`000?ooooooo`0goooo1000
03_oool300005Oooo`006_ooo`030000oooooooo03Ooool00`000?ooooooo`0<oooo00<0I_oooooo
ool06?ooo`0306Kooooooooo00koool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000
oooooooo01Coool001Ooool50000>Oooo`030000oooooooo00_oool00`1Vooooooooo`0Hoooo00<0
I_ooooooool03_ooo`030000oooooooo03Soool00`000?ooooooo`0ioooo1@0001Goool0017oool4
00000_ooo`040000oooooooo0000<oooo`@00004oooo00<0003oooooool02_ooo`0306Kooooooooo
01Soool00`1Vooooooooo`0>oooo00<0003oooooool0>Oooo`030000oooooooo03Soool010000?oo
ooooo`0001Koool001Soool00`000?ooo`00000ioooo00@0003oooooool0000;oooo00<0I_oooooo
ool06?ooo`0306Kooooooooo00koool20000>?ooo`040000oooooooo0000>_ooo`030000oooo0000
01Koool001Woool20000>_ooo`80000<oooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool0
0`000?ooooooo`0hoooo0P0003coool200005_ooo`00Hoooo`0306Kooooooooo01Soool00`1Voooo
ooooo`0>oooo00<0003oooooool0S_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>
oooo00<0003oooooool0S_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0
003oooooool0S_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0003ooooo
ool0S_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003o09Woool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool008ooool0
0`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOoo
ooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool00`000?oo
ooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`80000>oooo00?o09Woooooool0O_ooo`00Sooo
o`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2I
oooooooo07koool008ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000
oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo
07koool008ooool200003_ooo`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o
09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0
003oooooool03Oooo`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o09Wooooo
ool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0003ooooo
ool03Oooo`03o`2Ioooooooo07koool008ooool200003_ooo`03o`2Ioooooooo07koool008ooool0
0`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOoo
ooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool00`000?oo
ooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOooooooo`1n
oooo002?oooo0P0000koool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2I
oooooooo07koool008ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000
oooooooo00goool00ol0VOooooooo`1noooo001loooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool03Oooo`03o`2Ioooooooo07koool007_oool010000?ooooooo`0000Soool010000?oo
ooooo`0000Coool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Noooo`040000oooooooo
00002oooo`030000oooooooo00;oool300003Oooo`03o`2Ioooooooo07koool007_oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo00goool00ol0VOooooooo`1noooo001koooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo00goool00ol0VOooooooo`1n
oooo001loooo0P0000[oool300001?ooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?
oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o
09Woooooool0O_ooo`00Soooo`80000>oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo
00goool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool0
08ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool0
0ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool0
0`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`80000>oooo00?o09Woooooool0O_oo
o`00Soooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Ooo
o`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Sooo
o`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2I
oooooooo07koool008ooool200003_ooo`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=
oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?
oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o
09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo0P00
00koool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool0
08ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool0
0ol0VOooooooo`1noooo0027oooo1@0000?oool00`000?ooooooo`0=oooo00?o09Woooooool0O_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00ROoo
o`030000oooooooo00?oool300003Oooo`03o`2Ioooooooo07koool008Woool00`000?ooooooo`03
oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008Woool00`000?ooooooo`03oooo00<0
003oooooool03Oooo`03o`2Ioooooooo07koool008Soool200001Oooo`030000oooooooo00goool0
0ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool0
0`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOoo
ooooo`1noooo002?oooo0P0000koool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Ooo
o`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Sooo
o`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2I
oooooooo07koool008ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`80000>
oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?
oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o
09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0
003oooooool03Oooo`03o`2Ioooooooo07koool008ooool200003_ooo`03o`2Ioooooooo07koool0
08ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool0
0ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool0
0`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOoo
ooooo`1noooo002?oooo0P0000koool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Ooo
o`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Sooo
o`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2I
oooooooo07koool007_oool500000_ooo`800004oooo0P0000Goool00`000?ooooooo`0=oooo00?o
09Woooooool0O_ooo`00OOooo`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?oo
ooooo`0=oooo00?o09Woooooool0O_ooo`00OOooo`030000oooooooo00[oool00`000?ooooooo`02
oooo0`0000goool00ol0VOooooooo`1noooo001moooo00<0003oooooool02?ooo`80002Foooo001m
oooo00<0003oooooool02?ooo`030000oooooooo09Goool007coool200002_ooo`<0002Eoooo003o
oooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOoo
o`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005oooo0`0000;oool2
00001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002oooo`040000oooooooo
00000_ooo`050000oooooooooooo000007Ooool007Coool00`000?ooooooo`02oooo00<0003ooooo
ool04oooo`040000oooooooo00002?ooo`D00004oooo00<0003oooooool00_ooo`030000oooooooo
07Coool007Goool00`000?ooooooo`0500004_ooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000001Goool0
10000?ooooooo`0000Woool00`000?ooo`000003oooo00<0003oooooool00oooo`030000oooooooo
07Goool007Koool00`000?ooooooo`0Goooo0P0000_oool200000oooo`<00002oooo00<0003ooooo
ool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.52059 .24721 L
.53984 .24721 L
.54934 .24721 L
.55972 .24721 L
.56446 .24721 L
.56706 .24721 L
.56834 .24721 L
.56951 .24721 L
.57063 .24721 L
s
.57063 .24721 m
.57081 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.28158 .24721 L
.30316 .24721 L
.31323 .24721 L
.32392 .24721 L
.32831 .24721 L
.33073 .24721 L
.33193 .24721 L
.33304 .24721 L
.33433 .12361 L
.33502 .12361 L
.33575 .12361 L
.33823 .12361 L
.34309 .12361 L
.38467 .12361 L
.40553 .12361 L
.41469 .12361 L
.41954 .12361 L
.42221 .12361 L
.42473 .12361 L
.42716 .12361 L
.42783 .12361 L
.42854 .12361 L
.4298 .24721 L
.43094 .24721 L
.432 .24721 L
.43443 .24721 L
.44348 .24721 L
.46328 .24721 L
.50197 .24721 L
.54311 .24721 L
.58274 .24721 L
.62084 .24721 L
.66141 .24721 L
.70045 .24721 L
.74195 .24721 L
.78193 .24721 L
.8204 .24721 L
.86132 .24721 L
.90072 .24721 L
.93861 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00IOoooaH0I_l01000001Vo`1Vo`0000_oool0
0`000?ooooooo`02oooo0`0008koool006Goool00`1Vooooooooo`0=oooo100000;oool010000?oo
o`1Vo`0000Woool200001Oooo`030000oooooooo08koool006Goool00`1Vooooooooo`0Coooo00@0
003oool0I_l00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006Goool00`1Voooo
ooooo`0Doooo0P0000[oool300001?ooo`030000oooooooo08koool006Goool00`1Vooooooooo`0E
oooo00<0I_ooooooool03oooo`030000oooooooo08koool006Goool00`1Vooooooooo`0Eoooo00<0
I_ooooooool03oooo`030000oooooooo08koool006Goool00`1Vooooooooo`0Eoooo00<0I_oooooo
ool03oooo`030000oooooooo08koool006Goool00`1Vooooooooo`0Eoooo00<0I_ooooooool03ooo
o`80002?oooo001Uoooo00<0I_ooooooool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>
oooo001Uoooo00<0I_ooooooool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo001U
oooo00<0I_ooooooool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo001Uoooo00<0
I_ooooooool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo001Uoooo00<0I_oooooo
ool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo001Uoooo00<0I_ooooooool05Ooo
o`0306Kooooooooo00ooool20000Soooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?
oooo00<0003oooooool0S_ooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0
003oooooool0S_ooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003ooooo
ool0S_ooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool0S_oo
o`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`00IOoo
o`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo0P0008ooool006Goool00`1Vooooooooo`0E
oooo00<0I_ooooooool03oooo`030000oooooooo08koool001Woool30000>?ooo`@0000=oooo00<0
I_ooooooool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`0goooo100003_oool300005Ooo
o`006_ooo`030000oooooooo03Ooool00`000?ooooooo`0>oooo00<0I_ooooooool05Oooo`0306Ko
oooooooo00ooool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool0
01Ooool50000>Oooo`030000oooooooo00goool00`1Vooooooooo`0Eoooo00<0I_ooooooool03ooo
o`030000oooooooo03Soool00`000?ooooooo`0ioooo1@0001Goool0017oool400000_ooo`040000
oooooooo0000<oooo`@00004oooo00<0003oooooool03?ooo`0306Kooooooooo01Goool00`1Voooo
ooooo`0?oooo00<0003oooooool0>Oooo`030000oooooooo03Soool010000?ooooooo`0001Koool0
01Soool00`000?ooo`00000ioooo00@0003oooooool0000=oooo00<0I_ooooooool05Oooo`0306Ko
oooooooo00ooool20000>?ooo`040000oooooooo0000>_ooo`030000oooo000001Koool001Woool2
0000>_ooo`80000>oooo00<0I_ooooooool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0
003oooooool0S_ooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003ooooo
ool0S_ooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool0S_oo
o`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`00IOoo
o`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`004?ooool0000A
oooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00@0003ooooooooo09T;oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool05Oooo`00Soooo`030000oooooooo
00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool0
08ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool0
0ol0VOooooooo`1loooo002?oooo0P00013oool00ol0VOooooooo`1loooo002?oooo00<0003ooooo
ool03oooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?oo
o`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03ooo
o`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Sooo
o`80000@oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1l
oooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?
oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1loooo002?
oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o
09Woooooool0O?ooo`00Soooo`80000@oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo
00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool0
08ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool0
0ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool2
00004?ooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?oo
o`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03ooo
o`03o`2Ioooooooo07coool007coool200001?ooo`800004oooo0P0000Goool00`000?ooooooo`0?
oooo00?o09Woooooool0O?ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo00ooool00ol0VOooooooo`1loooo001koooo00@0003oooooool0000;oooo00<0
003oooooool00_ooo`<0000?oooo00?o09Woooooool0O?ooo`00Noooo`040000oooooooo00002Ooo
o`800005oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool007_oool010000?ooooooo`00
00Woool00`000?ooooooo`04oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool007coool2
00002_ooo`<00004oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool00`000?oo
ooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1l
oooo002?oooo0P00013oool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2I
oooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000
oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo
07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo
00ooool00ol0VOooooooo`1loooo002?oooo0P00013oool00ol0VOooooooo`1loooo002?oooo00<0
003oooooool03oooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Wooooo
ool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003ooooo
ool03oooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?oo
o`00Soooo`80000@oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOoo
ooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool00`000?oo
ooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1l
oooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool200004?ooo`03o`2I
oooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000
oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo
07coool008Ooool500000oooo`030000oooooooo00ooool00ol0VOooooooo`1loooo0029oooo00<0
003oooooool00oooo`030000oooooooo00ooool00ol0VOooooooo`1loooo0029oooo00<0003ooooo
ool00oooo`<0000?oooo00?o09Woooooool0O?ooo`00ROooo`030000oooooooo00?oool00`000?oo
ooooo`0?oooo00?o09Woooooool0O?ooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0?
oooo00?o09Woooooool0O?ooo`00R?ooo`800005oooo00<0003oooooool03oooo`03o`2Ioooooooo
07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo
00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool0
08ooool200004?ooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Wooooo
ool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003ooooo
ool03oooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?oo
o`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo0P00013oool00ol0VOoo
ooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool00`000?oo
ooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1l
oooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?
oooo00?o09Woooooool0O?ooo`00Soooo`80000@oooo00?o09Woooooool0O?ooo`00Soooo`030000
oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo
07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo
00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool0
08ooool200004?ooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Wooooo
ool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003ooooo
ool03oooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?oo
o`00Noooo`D00002oooo0P0000Coool200001Oooo`030000oooooooo00ooool00ol0VOooooooo`1l
oooo001moooo00<0003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo00ooool0
0ol0VOooooooo`1loooo001moooo00<0003oooooool02_ooo`030000oooooooo00;oool300003ooo
o`03o`2Ioooooooo07coool007goool00`000?ooooooo`08oooo0P0009Koool007goool00`000?oo
ooooo`08oooo00<0003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003o
oooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003ooooo
ool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_oo
o`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Goool300000_ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Coool400000oooo`040000oooooooo00002oooo`050000oooooooooooo000007[oool007Ooool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`D00003oooo00<0
003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Goool0
10000?ooooooo`0000Woool00`000?ooo`000003oooo00<0003oooooool0N?ooo`00NOooo`030000
oooooooo01Ooool200002oooo`800002oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQ
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.52059 .24721 L
.53984 .24721 L
.54934 .24721 L
.55972 .24721 L
.56446 .24721 L
.56951 .24721 L
.57197 .24721 L
.57429 .24721 L
.5753 .24721 L
.57636 .24721 L
s
.57636 .24721 m
.57654 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.28158 .24721 L
.30316 .24721 L
.31323 .24721 L
.32392 .24721 L
.33304 .24721 L
.33554 .24721 L
.33692 .24721 L
.33823 .24721 L
.33944 .12361 L
.34013 .12361 L
.34076 .12361 L
.34309 .12361 L
.38221 .12361 L
.3925 .12361 L
.40363 .12361 L
.40873 .12361 L
.41413 .12361 L
.41874 .12361 L
.42 .12361 L
.4207 .12361 L
.42135 .12361 L
.42263 .24721 L
.4238 .24721 L
.46213 .24721 L
.50291 .24721 L
.54217 .24721 L
.57993 .24721 L
.62013 .24721 L
.65882 .24721 L
.69996 .24721 L
.73958 .24721 L
.77769 .24721 L
.81825 .24721 L
.85729 .24721 L
.89879 .24721 L
.93877 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00I_oooaD0I_l010000?ooooooo`0000_oool0
0`000?ooooooo`02oooo0`0008koool006Koool00`1Vooooooooo`0<oooo100000;oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool006Koool00`1Vooooooooo`0Boooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006Koool00`1Voooo
ooooo`0Boooo00<0I_l0000000002_ooo`<00004oooo00<0003oooooool0S_ooo`00I_ooo`0306Ko
oooooooo01;oool00`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`00I_ooo`0306Kooooooooo
01;oool00`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`00I_ooo`0306Kooooooooo01;oool0
0`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`00I_ooo`0306Kooooooooo01;oool00`1Voooo
ooooo`0Aoooo0P0008ooool006Koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`030000
oooooooo08koool006Koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`030000oooooooo
08koool006Koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`030000oooooooo08koool0
06Koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`030000oooooooo08koool006Koool0
0`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`030000oooooooo08koool006Koool00`1Voooo
ooooo`0Boooo00<0I_ooooooool04Oooo`80002?oooo001Voooo00<0I_ooooooool04_ooo`0306Ko
oooooooo017oool00`000?ooooooo`2>oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo
017oool00`000?ooooooo`2>oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool0
0`000?ooooooo`2>oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool00`000?oo
ooooo`2>oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool00`000?ooooooo`2>
oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool20000Soooo`00I_ooo`0306Ko
oooooooo01;oool00`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`006Oooo`<0000hoooo1000
00koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`030000oooooooo03Ooool40000>ooo
o`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000oooooooo00ooool00`1Vooooooooo`0B
oooo00<0I_ooooooool04Oooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool03_ooo`0306Kooooooooo01;oool00`1Voooo
ooooo`0Aoooo00<0003oooooool0>?ooo`030000oooooooo03Woool500005Oooo`004Oooo`@00002
oooo00@0003oooooool0000coooo100000Coool00`000?ooooooo`0=oooo00<0I_ooooooool04_oo
o`0306Kooooooooo017oool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo
00005_ooo`006?ooo`030000oooo000003Woool010000?ooooooo`0000koool00`1Vooooooooo`0B
oooo00<0I_ooooooool04Oooo`80000hoooo00@0003oooooool0000joooo00<0003oool000005_oo
o`006Oooo`80000joooo0P0000ooool00`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`030000
oooooooo03Soool20000??ooo`80000Foooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo
017oool00`000?ooooooo`2>oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool0
0`000?ooooooo`2>oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool00`000?oo
ooooo`2>oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool00`000?ooooooo`2>
oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool00`000?ooooooo`2>oooo000@
ooooo`00017oool001Koool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool01@000?ooooooooooool0V@0:
oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool05Oooo`00Sooo
o`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2I
oooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000
oooooooo013oool00ol0VOooooooo`1koooo002?oooo0P00017oool00ol0VOooooooo`1koooo002?
oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o
09Woooooool0Noooo`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0
003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Wooooo
ool0Noooo`00Soooo`80000Aoooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool0
0ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool0
0`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool00ol0VOoo
ooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?oo
ooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`80000Aoooo00?o09Woooooool0Noooo`00Sooo
o`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2I
oooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000
oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo
07_oool008ooool200004Oooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o
09Woooooool0Noooo`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0
003oooooool04?ooo`03o`2Ioooooooo07_oool007coool200001?ooo`800004oooo0P0000Goool0
0`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Noooo`040000oooooooo00002?ooo`040000
oooooooo00001?ooo`030000oooooooo013oool00ol0VOooooooo`1koooo001koooo00@0003ooooo
ool0000;oooo00<0003oooooool00_ooo`<0000@oooo00?o09Woooooool0Noooo`00Noooo`040000
oooooooo00002Oooo`800005oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool007_oool0
10000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool04?ooo`03o`2Ioooooooo
07_oool007coool200002_ooo`<00004oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool0
08ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool0
0ol0VOooooooo`1koooo002?oooo0P00017oool00ol0VOooooooo`1koooo002?oooo00<0003ooooo
ool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Nooo
o`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?oo
o`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Sooo
o`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo0P00017oool00ol0VOooooooo`1k
oooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@
oooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?
oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o
09Woooooool0Noooo`00Soooo`80000Aoooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo
013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool0
08ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool0
0ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool2
00004Oooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Nooo
o`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?oo
o`03o`2Ioooooooo07_oool008Ooool500000oooo`030000oooooooo013oool00ol0VOooooooo`1k
oooo0029oooo00<0003oooooool00oooo`030000oooooooo013oool00ol0VOooooooo`1koooo0029
oooo00<0003oooooool00oooo`<0000@oooo00?o09Woooooool0Noooo`00ROooo`030000oooooooo
00?oool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00ROooo`030000oooooooo00?oool0
0`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00R?ooo`800005oooo00<0003oooooool04?oo
o`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Sooo
o`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2I
oooooooo07_oool008ooool200004Oooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@
oooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?
oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o
09Woooooool0Noooo`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo0P00
017oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool0
08ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool0
0ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool0
0`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`80000Aoooo00?o09Woooooool0Nooo
o`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?oo
o`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Sooo
o`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2I
oooooooo07_oool008ooool200004Oooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@
oooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?
oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o
09Woooooool0Noooo`00Noooo`D00002oooo0P0000Coool200001Oooo`030000oooooooo013oool0
0ol0VOooooooo`1koooo001moooo00<0003oooooool01oooo`040000oooooooo00001?ooo`030000
oooooooo013oool00ol0VOooooooo`1koooo001moooo00<0003oooooool02_ooo`030000oooooooo
00;oool300004?ooo`03o`2Ioooooooo07_oool007goool00`000?ooooooo`08oooo0P0009Koool0
07goool00`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool0
0?oooolQoooo003ooooo8Oooo`00M_ooo`030000oooooooo02koool00`000?ooooooo`1foooo001e
oooo00<0003oooooool02?ooo`030000oooooooo02Goool00`000?ooooooo`1eoooo001eoooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Coool200001?oo
o`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000
oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000_oool010000?ooooooooooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000
oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004
oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.55838 .24721 L
.56817 .24721 L
.57355 .24721 L
.57861 .24721 L
.58137 .24721 L
.58213 .24721 L
.58293 .24721 L
s
.58293 .24721 m
.58303 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.33304 .24721 L
.33788 .24721 L
.34055 .24721 L
.34186 .24721 L
.34309 .24721 L
.34425 .24721 L
.34549 .12361 L
.3462 .12361 L
.34686 .12361 L
.34811 .12361 L
.35271 .12361 L
.36173 .12361 L
.3815 .12361 L
.39126 .12361 L
.40158 .12361 L
.41038 .12361 L
.4128 .12361 L
.41412 .12361 L
.41538 .12361 L
.41655 .12361 L
.41782 .24721 L
.41898 .24721 L
.42005 .24721 L
.45932 .24721 L
.49707 .24721 L
.53727 .24721 L
.57596 .24721 L
.6171 .24721 L
.65672 .24721 L
.69483 .24721 L
.73539 .24721 L
.77444 .24721 L
.81593 .24721 L
.85592 .24721 L
.89438 .24721 L
.9353 .24721 L
.9747 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00J?oooa<0I_l010000?ooooooo`0000_oool0
0`000?ooooooo`02oooo0`0008koool006Soool00`1Vooooooooo`0:oooo10000003oooo06Ko0000
00;oool00`000?ooooooo`07oooo0P0000Goool00`000?ooooooo`2>oooo001Xoooo00<0I_oooooo
ool03oooo`0506Ko0000oooooooo000000Woool00`000?ooooooo`04oooo00<0003oooooool0S_oo
o`00J?ooo`0306Kooooooooo00ooool0101Vooooo`00000000[oool300001?ooo`030000oooooooo
08koool006Soool00`1Vooooooooo`0?oooo00<0I_ooooooool04_ooo`030000oooooooo08koool0
06Soool00`1Vooooooooo`0?oooo00<0I_ooooooool04_ooo`030000oooooooo08koool006Soool0
0`1Vooooooooo`0?oooo00<0I_ooooooool04_ooo`030000oooooooo08koool006Soool00`1Voooo
ooooo`0?oooo00<0I_ooooooool04_ooo`80002?oooo001Xoooo00<0I_ooooooool03oooo`0306Ko
oooooooo01;oool00`000?ooooooo`2>oooo001Xoooo00<0I_ooooooool03oooo`0306Kooooooooo
01;oool00`000?ooooooo`2>oooo001Xoooo00<0I_ooooooool03oooo`0306Kooooooooo01;oool0
0`000?ooooooo`2>oooo001Xoooo00<0I_ooooooool03oooo`0306Kooooooooo01;oool00`000?oo
ooooo`2>oooo001Xoooo00<0I_ooooooool03oooo`0306Kooooooooo01;oool00`000?ooooooo`2>
oooo001Xoooo00<0I_ooooooool03oooo`0306Kooooooooo01;oool20000Soooo`00J?ooo`0306Ko
oooooooo00ooool00`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00J?ooo`0306Kooooooooo
00ooool00`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00Ioooo`0306Kooooooooo013oool0
0`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00Ioooo`0306Kooooooooo013oool00`1Voooo
ooooo`0Boooo00<0003oooooool0S_ooo`00Ioooo`0306Kooooooooo013oool00`1Vooooooooo`0B
oooo00<0003oooooool0S_ooo`00Ioooo`0306Kooooooooo013oool00`1Vooooooooo`0Boooo0P00
08ooool006Ooool00`1Vooooooooo`0@oooo00<0I_ooooooool04_ooo`030000oooooooo08koool0
01Woool30000>?ooo`@0000?oooo00<0I_ooooooool04?ooo`0306Kooooooooo01;oool00`000?oo
ooooo`0goooo100003_oool300005Oooo`006_ooo`030000oooooooo03Ooool00`000?ooooooo`0@
oooo00<0I_ooooooool04?ooo`0306Kooooooooo01;oool00`000?ooooooo`0goooo00<0003ooooo
ool0?Oooo`030000oooooooo01Coool001Ooool50000>Oooo`030000oooooooo00ooool00`1Voooo
ooooo`0@oooo00<0I_ooooooool04_ooo`030000oooooooo03Soool00`000?ooooooo`0ioooo1@00
01Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0003oooooool03_oo
o`0306Kooooooooo013oool00`1Vooooooooo`0Boooo00<0003oooooool0>Oooo`030000oooooooo
03Soool010000?ooooooo`0001Koool001Soool00`000?ooo`00000ioooo00@0003oooooool0000?
oooo00<0I_ooooooool04?ooo`0306Kooooooooo01;oool20000>?ooo`040000oooooooo0000>_oo
o`030000oooo000001Koool001Woool20000>_ooo`80000@oooo00<0I_ooooooool04?ooo`0306Ko
oooooooo01;oool00`000?ooooooo`0hoooo0P0003coool200005_ooo`00Ioooo`0306Kooooooooo
013oool00`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00Ioooo`0306Kooooooooo013oool0
0`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00Ioooo`0306Kooooooooo013oool00`1Voooo
ooooo`0Boooo00<0003oooooool0S_ooo`00Ioooo`0306Kooooooooo013oool00`1Vooooooooo`0B
oooo00<0003oooooool0S_ooo`00Ioooo`0306Kooooooooo013oool00`1Vooooooooo`0Boooo00<0
003oooooool0S_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool00oooo`03o`2Ioooooooo00Koool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0Eoooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool0
08ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo01;oool0
0ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool2
00004oooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOoo
o`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_oo
o`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Sooo
o`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo0P0001?oool00ol0VOooooooo`1i
oooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0B
oooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?
oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o
09Woooooool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo0P00
01?oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool0
08ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo01;oool0
0ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool0
0`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`80000Coooo00?o09Woooooool0NOoo
o`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_oo
o`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00O?oo
o`800004oooo0P0000Coool200001Oooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo001k
oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0003oooooool04_ooo`03o`2I
oooooooo07Woool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`0001;oool0
0ol0VOooooooo`1ioooo001koooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`0B
oooo00?o09Woooooool0NOooo`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool0
0`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00O?ooo`80000:oooo0`0000Coool00`000?oo
ooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1i
oooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool200004oooo`03o`2I
oooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000
oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo
07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo
01;oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool0
08ooool200004oooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Wooooo
ool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0003ooooo
ool04_ooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOoo
o`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo0P0001?oool00ol0VOoo
ooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool00`000?oo
ooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1i
oooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0B
oooo00?o09Woooooool0NOooo`00Soooo`80000Coooo00?o09Woooooool0NOooo`00Soooo`030000
oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo
07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Qoooo`D00003oooo00<0
003oooooool04_ooo`03o`2Ioooooooo07Woool008Woool00`000?ooooooo`03oooo00<0003ooooo
ool04_ooo`03o`2Ioooooooo07Woool008Woool00`000?ooooooo`03oooo0`0001;oool00ol0VOoo
ooooo`1ioooo0029oooo00<0003oooooool00oooo`030000oooooooo01;oool00ol0VOooooooo`1i
oooo0029oooo00<0003oooooool00oooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo0028
oooo0P0000Goool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo
01;oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool0
08ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`80000Coooo00?o09Wooooo
ool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0003ooooo
ool04_ooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOoo
o`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_oo
o`03o`2Ioooooooo07Woool008ooool200004oooo`03o`2Ioooooooo07Woool008ooool00`000?oo
ooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1i
oooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0B
oooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?
oooo0P0001?oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo
07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo
01;oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool0
08ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`80000Coooo00?o09Wooooo
ool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0003ooooo
ool04_ooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOoo
o`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo001koooo1@0000;oool200001?oo
o`800005oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool007goool00`000?ooooooo`07
oooo00@0003oooooool00004oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool007goool0
0`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0000Boooo00?o09Woooooool0NOooo`00OOoo
o`030000oooooooo00Soool20000U_ooo`00OOooo`030000oooooooo00Soool00`000?ooooooo`2E
oooo001loooo0P0000[oool30000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003ooooo
ool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07ooo
o`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=
oooo0P0000Coool200001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool00oooo`030000
oooooooo07Ooool007Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002oooo`050000
oooooooooooo000007[oool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool2
00002_ooo`800003oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.55838 .24721 L
.56817 .24721 L
.57861 .24721 L
.58157 .24721 L
.58436 .24721 L
.58686 .24721 L
.58755 .24721 L
.58827 .24721 L
s
.58827 .24721 m
.58847 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.33304 .24721 L
.33788 .24721 L
.34309 .24721 L
.34566 .24721 L
.34811 .24721 L
.34918 .24721 L
.35031 .24721 L
.35156 .12361 L
.35271 .12361 L
.36173 .12361 L
.3815 .12361 L
.39178 .12361 L
.39719 .12361 L
.40291 .12361 L
.40533 .12361 L
.40792 .12361 L
.40868 .12361 L
.40941 .12361 L
.41006 .12361 L
.41076 .24721 L
.41143 .24721 L
.41214 .24721 L
.41342 .24721 L
.42308 .24721 L
.46083 .24721 L
.50104 .24721 L
.53972 .24721 L
.58086 .24721 L
.62049 .24721 L
.65859 .24721 L
.69916 .24721 L
.7382 .24721 L
.7797 .24721 L
.81968 .24721 L
.85815 .24721 L
.89907 .24721 L
.93847 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00JOoooa00I_l2oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo001Yoooo00<0I_ooooooool02Oooo`@00002oooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo001Yoooo00<0I_ooooooool03?oo
o`0406Kooooooooo00000_ooo`030000oooooooo00Ooool00`000?ooooooo`04oooo00<0003ooooo
ool0S_ooo`00JOooo`0306Kooooooooo00coool0101Vooooooooooooo`80000:oooo0`0000Coool0
0`000?ooooooo`2>oooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?oo
ooooo`2>oooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`2>
oooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`2>oooo001Y
oooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool20000Soooo`00JOooo`0306Kooooooooo
00coool00`1Vooooooooo`0Doooo00<0003oooooool0S_ooo`00JOooo`0306Kooooooooo00coool0
0`1Vooooooooo`0Doooo00<0003oooooool0S_ooo`00JOooo`0306Kooooooooo00coool00`1Voooo
ooooo`0Doooo00<0003oooooool0S_ooo`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0D
oooo00<0003oooooool0S_ooo`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo00<0
003oooooool0S_ooo`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo0P0008ooool0
06Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo08koool006Woool0
0`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo08koool006Woool00`1Voooo
ooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo08koool006Woool00`1Vooooooooo`0<
oooo00<0I_ooooooool05?ooo`030000oooooooo08koool006Woool00`1Vooooooooo`0<oooo00<0
I_ooooooool05?ooo`030000oooooooo08koool006Woool00`1Vooooooooo`0<oooo00<0I_oooooo
ool05?ooo`80002?oooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?oo
ooooo`2>oooo000Ioooo0`0003Soool400004Oooo`0306Kooooooooo00coool00`1Vooooooooo`0D
oooo00<0003oooooool0=oooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0goooo00<0
003oooooool04_ooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo00<0003oooooool0=ooo
o`030000oooooooo03goool00`000?ooooooo`0Doooo000Goooo1@0003Woool00`000?ooooooo`0A
oooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`0hoooo00<0003ooooo
ool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0003?oool400001?ooo`030000
oooooooo013oool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo03Woool0
0`000?ooooooo`0hoooo00@0003oooooool0000Foooo000Hoooo00<0003oool00000>Oooo`040000
oooooooo00004Oooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo0P0003Soool010000?oo
ooooo`0003[oool00`000?ooo`00000Foooo000Ioooo0P0003[oool200004_ooo`0306Kooooooooo
00coool00`1Vooooooooo`0Doooo00<0003oooooool0>?ooo`80000loooo0P0001Koool006Woool0
0`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo08koool006Woool00`1Voooo
ooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo08koool006Woool00`1Vooooooooo`0<
oooo00<0I_ooooooool05?ooo`030000oooooooo08koool006Woool00`1Vooooooooo`0<oooo00<0
I_ooooooool05?ooo`030000oooooooo08koool006Woool00`1Vooooooooo`0<oooo00<0I_oooooo
ool05?ooo`030000oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00Coool00ol0VOooooooo`05oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool05Oooo`00Soooo`030000oooooooo01?oool00ol0VOoo
ooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?oo
ooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1h
oooo002?oooo0P0001Coool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2I
oooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000
oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo
07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`80000Doooo00?o
09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0
003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Wooooo
ool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0003ooooo
ool04oooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?oo
o`00Soooo`80000Doooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOoo
ooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?oo
ooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1h
oooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool200005?ooo`03o`2I
oooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000
oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo
07Soool007coool200001?ooo`800004oooo0P0000Goool00`000?ooooooo`0Coooo00?o09Wooooo
ool0N?ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000oooooooo
01?oool00ol0VOooooooo`1hoooo001koooo00@0003oooooool0000;oooo00<0003oooooool00_oo
o`<0000Coooo00?o09Woooooool0N?ooo`00Noooo`040000oooooooo00002Oooo`800005oooo00<0
003oooooool04oooo`03o`2Ioooooooo07Soool007_oool010000?ooooooo`0000Woool00`000?oo
ooooo`04oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool007coool200002_ooo`<00004
oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o
09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo0P00
01Coool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool0
08ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool0
0ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool0
0`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOoo
ooooo`1hoooo002?oooo0P0001Coool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04ooo
o`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Sooo
o`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2I
oooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`80000D
oooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?
oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o
09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0
003oooooool04oooo`03o`2Ioooooooo07Soool008ooool200005?ooo`03o`2Ioooooooo07Soool0
08ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool0
0ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008Ooool5
00000oooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo0029oooo00<0003oooooool00ooo
o`030000oooooooo01?oool00ol0VOooooooo`1hoooo0029oooo00<0003oooooool00oooo`<0000C
oooo00?o09Woooooool0N?ooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0Coooo00?o
09Woooooool0N?ooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0Coooo00?o09Wooooo
ool0N?ooo`00R?ooo`800005oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool0
0`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOoo
ooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool200005?oo
o`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Sooo
o`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2I
oooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000
oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo0P0001Coool00ol0VOooooooo`1hoooo002?
oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o
09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0
003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Wooooo
ool0N?ooo`00Soooo`80000Doooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool0
0ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool0
0`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOoo
ooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool200005?oo
o`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Sooo
o`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2I
oooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Noooo`D00002
oooo0P0000Coool200001Oooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo001moooo00<0
003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo01?oool00ol0VOooooooo`1h
oooo001moooo00<0003oooooool02_ooo`030000oooooooo00;oool300004oooo`03o`2Ioooooooo
07Soool007goool00`000?ooooooo`08oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0
003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00M_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001eoooo00<0003oooooool02?ooo`030000
oooooooo02Goool00`000?ooooooo`1eoooo001eoooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03Oooo`800004oooo0P0000?oool400000oooo`800004oooo00<0003oooooool0MOoo
o`00MOooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00003oooo00@0003oooooool00008oooo00<0003oooooool00oooo`040000oooooooo00000ooo
o`030000oooooooo07Goool007Coool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo00<0003oooooool0M?oo
o`00MOooo`030000oooooooo00D0000Boooo00@0003oooooool0000:oooo00<0003oooooool00_oo
o`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000001Goool010000?oo
ooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`03oooo00<0003oooooool0MOoo
o`00M_ooo`030000oooooooo01Ooool200002_ooo`800004oooo0`0000;oool00`000?ooooooo`1f
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.55838 .24721 L
.57861 .24721 L
.58392 .24721 L
.58957 .24721 L
.59232 .24721 L
.59367 .24721 L
.59491 .24721 L
s
.59491 .24721 m
.59508 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.33304 .24721 L
.34309 .24721 L
.34772 .24721 L
.35028 .24721 L
.35271 .24721 L
.35496 .24721 L
.35624 .24721 L
.35742 .12361 L
.35852 .12361 L
.35951 .12361 L
.36173 .12361 L
.3815 .12361 L
.39086 .12361 L
.39597 .12361 L
.40075 .12361 L
.40324 .12361 L
.40396 .12361 L
.40464 .12361 L
.40592 .24721 L
.4066 .24721 L
.40733 .24721 L
.40863 .24721 L
.41159 .24721 L
.42157 .24721 L
.45932 .24721 L
.49952 .24721 L
.53821 .24721 L
.57935 .24721 L
.61897 .24721 L
.65708 .24721 L
.69764 .24721 L
.73669 .24721 L
.77818 .24721 L
.81817 .24721 L
.85663 .24721 L
.89755 .24721 L
.93695 .24721 L
.97484 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Joooo`d0I_l3oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo001[oooo00<0I_ooooooool01oooo`@00002oooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo001[oooo00<0I_ooooooool02Ooo
o`0506Kooooooooooooo000000;oool00`000?ooooooo`07oooo00<0003oooooool01?ooo`030000
oooooooo08koool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool00_ooo`80000:oooo0`00
00Coool00`000?ooooooo`2>oooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool0
0`000?ooooooo`2>oooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool00`000?oo
ooooo`2>oooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool00`000?ooooooo`2>
oooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool20000Soooo`00Joooo`0306Ko
oooooooo00Woool00`1Vooooooooo`0Eoooo00<0003oooooool0S_ooo`00Joooo`0306Kooooooooo
00Woool00`1Vooooooooo`0Eoooo00<0003oooooool0S_ooo`00Joooo`0306Kooooooooo00Woool0
0`1Vooooooooo`0Eoooo00<0003oooooool0S_ooo`00Joooo`0306Kooooooooo00Woool00`1Voooo
ooooo`0Eoooo00<0003oooooool0S_ooo`00Joooo`0306Kooooooooo00Woool00`1Vooooooooo`0E
oooo00<0003oooooool0S_ooo`00Joooo`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo0P00
08ooool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo08koool0
06_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo08koool006_oool0
0`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo08koool006_oool00`1Voooo
ooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo08koool006_oool00`1Vooooooooo`09
oooo00<0I_ooooooool05Oooo`030000oooooooo08koool006_oool00`1Vooooooooo`09oooo00<0
I_ooooooool05Oooo`80002?oooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool0
0`000?ooooooo`2>oooo000Ioooo0`0003Soool400004oooo`0306Kooooooooo00Woool00`1Voooo
ooooo`0Eoooo00<0003oooooool0=oooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool05?ooo`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo00<0003ooooo
ool0=oooo`030000oooooooo03goool00`000?ooooooo`0Doooo000Goooo1@0003Woool00`000?oo
ooooo`0Coooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool00`000?ooooooo`0hoooo00<0
003oooooool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0003?oool400001?oo
o`030000oooooooo01;oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo
03Woool00`000?ooooooo`0hoooo00@0003oooooool0000Foooo000Hoooo00<0003oool00000>Ooo
o`040000oooooooo00004oooo`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo0P0003Soool0
10000?ooooooo`0003[oool00`000?ooo`00000Foooo000Ioooo0P0003[oool200005?ooo`0306Ko
oooooooo00Woool00`1Vooooooooo`0Eoooo00<0003oooooool0>?ooo`80000loooo0P0001Koool0
06_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo08koool006_oool0
0`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo08koool006_oool00`1Voooo
ooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo08koool006_oool00`1Vooooooooo`09
oooo00<0I_ooooooool05Oooo`030000oooooooo08koool006_oool00`1Vooooooooo`09oooo00<0
I_ooooooool05Oooo`030000oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00Koool00ol0VOooooooo`03oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool05Oooo`00Soooo`030000oooooooo01Goool0
0ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool0
0`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOoo
ooooo`1foooo002?oooo0P0001Koool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Ooo
o`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Sooo
o`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2I
oooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`80000F
oooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?
oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o
09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo00<0
003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Wooooo
ool0M_ooo`00Soooo`80000Foooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool0
0ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool0
0`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOoo
ooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool200005_oo
o`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Sooo
o`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2I
oooooooo07Koool007coool200001?ooo`800004oooo0P0000Goool00`000?ooooooo`0Eoooo00?o
09Woooooool0M_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000
oooooooo01Goool00ol0VOooooooo`1foooo001koooo00@0003oooooool0000;oooo00<0003ooooo
ool00_ooo`<0000Eoooo00?o09Woooooool0M_ooo`00Noooo`040000oooooooo00002Oooo`800005
oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool007_oool010000?ooooooo`0000Woool0
0`000?ooooooo`04oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool007coool200002_oo
o`<00004oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0E
oooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?
oooo0P0001Koool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo
07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo
01Goool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool0
08ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool0
0ol0VOooooooo`1foooo002?oooo0P0001Koool00ol0VOooooooo`1foooo002?oooo00<0003ooooo
ool05Oooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_oo
o`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Ooo
o`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Sooo
o`80000Foooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1f
oooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0E
oooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?
oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool200005_ooo`03o`2Ioooooooo
07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo
01Goool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool0
08Ooool500000oooo`030000oooooooo01Goool00ol0VOooooooo`1foooo0029oooo00<0003ooooo
ool00oooo`030000oooooooo01Goool00ol0VOooooooo`1foooo0029oooo00<0003oooooool00ooo
o`<0000Eoooo00?o09Woooooool0M_ooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0E
oooo00?o09Woooooool0M_ooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0Eoooo00?o
09Woooooool0M_ooo`00R?ooo`800005oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool0
08ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool0
0ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool2
00005_ooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_oo
o`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Ooo
o`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Sooo
o`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo0P0001Koool00ol0VOooooooo`1f
oooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0E
oooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?
oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o
09Woooooool0M_ooo`00Soooo`80000Foooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo
01Goool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool0
08ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool0
0ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool2
00005_ooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_oo
o`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Ooo
o`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Nooo
o`D00002oooo0P0000Coool200001Oooo`030000oooooooo01Goool00ol0VOooooooo`1foooo001m
oooo00<0003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo01Goool00ol0VOoo
ooooo`1foooo001moooo00<0003oooooool02_ooo`030000oooooooo00;oool300005Oooo`03o`2I
oooooooo07Koool007goool00`000?ooooooo`08oooo0P0009Koool007goool00`000?ooooooo`08
oooo00<0003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Ooo
o`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?oo
o`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004
oooo00<0003oooooool03Oooo`800004oooo0P0000?oool400000oooo`030000oooooooo07Soool0
07Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool4
00000oooo`040000oooooooo00002?ooo`030000oooooooo00Coool00`000?ooooooo`1hoooo001g
oooo00<0003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Woool00`000?oo
ooooo`04oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0003ooooo
ool0000:oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00NOooo`030000oooooooo01Ooool200002_ooo`800003oooo00<0003oooooool0NOooo`00oooo
ob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.58872 .24721 L
.59405 .24721 L
.59698 .24721 L
.59842 .24721 L
.59975 .24721 L
.60102 .24721 L
s
.60102 .24721 m
.60112 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.34309 .24721 L
.35271 .24721 L
.35742 .24721 L
.35948 .24721 L
.36173 .24721 L
.36294 .24721 L
.36405 .12361 L
.36512 .12361 L
.36626 .12361 L
.37114 .12361 L
.3815 .12361 L
.39178 .12361 L
.3946 .12361 L
.39614 .12361 L
.39758 .12361 L
.39881 .12361 L
.40012 .24721 L
.40087 .24721 L
.40158 .24721 L
.40291 .24721 L
.42308 .24721 L
.46141 .24721 L
.50219 .24721 L
.54146 .24721 L
.57921 .24721 L
.61941 .24721 L
.6581 .24721 L
.69924 .24721 L
.73886 .24721 L
.77697 .24721 L
.81753 .24721 L
.85658 .24721 L
.89808 .24721 L
.93806 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00KOooo`T0I_l5oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo001]oooo00<0I_ooooooool01Oooo`@00002oooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo001]oooo00<0I_ooooooool01Ooo
o`0306Kooooooooo00?oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003ooooo
ool0S_ooo`00KOooo`0306Kooooooooo00Goool00`1Vooooooooo`04oooo0P0000[oool300001?oo
o`030000oooooooo08koool006goool00`1Vooooooooo`05oooo00<0I_ooooooool05oooo`030000
oooooooo08koool006goool00`1Vooooooooo`05oooo00<0I_ooooooool05oooo`030000oooooooo
08koool006goool00`1Vooooooooo`05oooo00<0I_ooooooool05oooo`030000oooooooo08koool0
06goool00`1Vooooooooo`05oooo00<0I_ooooooool05oooo`80002?oooo001]oooo00<0I_oooooo
ool01Oooo`0306Kooooooooo01Ooool00`000?ooooooo`2>oooo001]oooo00<0I_ooooooool01Ooo
o`0306Kooooooooo01Ooool00`000?ooooooo`2>oooo001]oooo00<0I_ooooooool01Oooo`0306Ko
oooooooo01Ooool00`000?ooooooo`2>oooo001]oooo00<0I_ooooooool01Oooo`0306Kooooooooo
01Ooool00`000?ooooooo`2>oooo001]oooo00<0I_ooooooool01Oooo`0306Kooooooooo01Ooool0
0`000?ooooooo`2>oooo001]oooo00<0I_ooooooool01Oooo`0306Kooooooooo01Ooool20000Sooo
o`00KOooo`0306Kooooooooo00Goool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00KOoo
o`0306Kooooooooo00Goool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00K?ooo`0306Ko
oooooooo00Koool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00K?ooo`0306Kooooooooo
00Ooool00`1Vooooooooo`0Foooo00<0003oooooool0S_ooo`00K?ooo`0306Kooooooooo00Ooool0
0`1Vooooooooo`0Foooo00<0003oooooool0S_ooo`00K?ooo`0306Kooooooooo00Ooool00`1Voooo
ooooo`0Foooo0P0008ooool006coool00`1Vooooooooo`07oooo00<0I_ooooooool05_ooo`030000
oooooooo08koool001Woool30000>?ooo`@0000Doooo00<0I_ooooooool01oooo`0306Kooooooooo
01Koool00`000?ooooooo`0goooo100003_oool300005Oooo`006_ooo`030000oooooooo03Ooool0
0`000?ooooooo`0Eoooo00<0I_ooooooool01oooo`0306Kooooooooo01Koool00`000?ooooooo`0g
oooo00<0003oooooool0?Oooo`030000oooooooo01Coool001Ooool50000>Oooo`030000oooooooo
01Coool00`1Vooooooooo`07oooo00<0I_ooooooool05_ooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool04oooo`0306Kooooooooo00Ooool00`1Vooooooooo`0Foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool00`000?ooo`00000ioooo00@0
003oooooool0000Doooo00<0I_ooooooool01oooo`0306Kooooooooo01Koool20000>?ooo`040000
oooooooo0000>_ooo`030000oooo000001Koool001Woool20000>_ooo`80000Eoooo00<0I_oooooo
ool01oooo`0306Kooooooooo01Koool00`000?ooooooo`0hoooo0P0003coool200005_ooo`00K?oo
o`0306Kooooooooo00Ooool00`1Vooooooooo`0Foooo00<0003oooooool0S_ooo`00K?ooo`0306Ko
oooooooo00Ooool00`1Vooooooooo`0Foooo00<0003oooooool0S_ooo`00K?ooo`0306Kooooooooo
00Ooool00`1Vooooooooo`0Foooo00<0003oooooool0S_ooo`00K?ooo`0306Kooooooooo00Ooool0
0`1Vooooooooo`0Foooo00<0003oooooool0S_ooo`00K?ooo`0306Kooooooooo00Ooool00`1Voooo
ooooo`0Foooo00<0003oooooool0S_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool02?ooo`05o`2Ioooooooooooo000000koool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo01Goool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?oo
o`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0003oooooool05ooo
o`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Sooo
o`80000Hoooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1d
oooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0G
oooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?
oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool200006?ooo`03o`2Ioooooooo
07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo
01Ooool00ol0VOooooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool0
08ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool0
0ol0VOooooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool2
00006?ooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?oo
o`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0003oooooool05ooo
o`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Sooo
o`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo0P0001Soool00ol0VOooooooo`1d
oooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0G
oooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo001l
oooo0P0000Coool200001?ooo`800005oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool0
07_oool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?ooooooo`0Goooo00?o
09Woooooool0M?ooo`00Noooo`040000oooooooo00002oooo`030000oooooooo00;oool300005ooo
o`03o`2Ioooooooo07Coool007_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo
01Ooool00ol0VOooooooo`1doooo001koooo00@0003oooooool00009oooo00<0003oooooool01?oo
o`030000oooooooo01Ooool00ol0VOooooooo`1doooo001loooo0P0000[oool300001?ooo`030000
oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo
07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`80000Hoooo00?o
09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0
003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Wooooo
ool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0003ooooo
ool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?oo
o`00Soooo`80000Hoooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOoo
ooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?oo
ooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1d
oooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool200006?ooo`03o`2I
oooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000
oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo
07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo
01Ooool00ol0VOooooooo`1doooo002?oooo0P0001Soool00ol0VOooooooo`1doooo002?oooo00<0
003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Wooooo
ool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo0027oooo1@0000?oool0
0`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00ROooo`030000oooooooo00?oool00`000?oo
ooooo`0Goooo00?o09Woooooool0M?ooo`00ROooo`030000oooooooo00?oool300005oooo`03o`2I
oooooooo07Coool008Woool00`000?ooooooo`03oooo00<0003oooooool05oooo`03o`2Ioooooooo
07Coool008Woool00`000?ooooooo`03oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool0
08Soool200001Oooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0003ooooo
ool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?oo
o`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo0P0001Soool00ol0VOoo
ooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?oo
ooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1d
oooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0G
oooo00?o09Woooooool0M?ooo`00Soooo`80000Hoooo00?o09Woooooool0M?ooo`00Soooo`030000
oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo
07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo
01Ooool00ol0VOooooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool0
08ooool200006?ooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Wooooo
ool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0003ooooo
ool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?oo
o`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo0P0001Soool00ol0VOoo
ooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?oo
ooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1d
oooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool007_oool500000_ooo`800004
oooo0P0000Goool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00OOooo`030000oooooooo
00Ooool010000?ooooooo`0000Coool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00OOoo
o`030000oooooooo00[oool00`000?ooooooo`02oooo0`0001Ooool00ol0VOooooooo`1doooo001m
oooo00<0003oooooool02?ooo`80002Foooo001moooo00<0003oooooool02?ooo`030000oooooooo
09Goool007coool200002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool007Koool00`000?oo
ooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0U
oooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00goool200001?ooo`800003oooo1@0000;oool200001?ooo`030000oooooooo07Goool007Goool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000ooo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool01@000?ooooooooooo`00001g
oooo001doooo00<0003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?oo
ooooo`0500004_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001?ooo`030000
oooooooo07Goool007Goool01@000?ooooooooooo`00000Eoooo00@0003oooooool0000:oooo00<0
003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003ooooo
ool05oooo`80000:oooo0P0000Coool300000_ooo`030000oooooooo07Koool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.58872 .24721 L
.59405 .24721 L
.59975 .24721 L
.60256 .24721 L
.60394 .24721 L
.60521 .24721 L
.60637 .24721 L
s
.60637 .24721 m
.60655 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.34309 .24721 L
.35271 .24721 L
.36173 .24721 L
.36626 .24721 L
.36757 .24721 L
.36881 .24721 L
.36992 .12361 L
.37114 .12361 L
.3815 .12361 L
.38681 .12361 L
.38942 .12361 L
.39056 .12361 L
.39182 .12361 L
.39295 .24721 L
.394 .24721 L
.39631 .24721 L
.40117 .24721 L
.42214 .24721 L
.46105 .24721 L
.50241 .24721 L
.54226 .24721 L
.58059 .24721 L
.62137 .24721 L
.66064 .24721 L
.69839 .24721 L
.73859 .24721 L
.77728 .24721 L
.81842 .24721 L
.85804 .24721 L
.89615 .24721 L
.93671 .24721 L
.97576 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00K_ooo`L0I_l6oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo001^oooo00<0I_ooooooool00oooo`0306Ko00000000
00800002oooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo001^oooo00<0
I_ooooooool00oooo`0306Kooooooooo00Coool010000?ooooooo`0000Woool00`000?ooooooo`04
oooo00<0003oooooool0S_ooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`05oooo0P00
00[oool300001?ooo`030000oooooooo08koool006koool00`1Vooooooooo`03oooo00<0I_oooooo
ool06?ooo`030000oooooooo08koool006koool00`1Vooooooooo`03oooo00<0I_ooooooool06?oo
o`030000oooooooo08koool006koool00`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`030000
oooooooo08koool006koool00`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`80002?oooo001^
oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo001^oooo00<0
I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo001^oooo00<0I_oooooo
ool00oooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo001^oooo00<0I_ooooooool00ooo
o`0306Kooooooooo01Soool00`000?ooooooo`2>oooo001^oooo00<0I_ooooooool00oooo`0306Ko
oooooooo01Soool00`000?ooooooo`2>oooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo
01Soool20000Soooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003ooooo
ool0S_ooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_oo
o`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00K_oo
o`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00K_ooo`0306Ko
oooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00K_ooo`0306Kooooooooo
00?oool00`1Vooooooooo`0Hoooo0P0008ooool006koool00`1Vooooooooo`03oooo00<0I_oooooo
ool06?ooo`030000oooooooo08koool001Woool30000>?ooo`@0000Foooo00<0I_ooooooool00ooo
o`0306Kooooooooo01Soool00`000?ooooooo`0goooo100003_oool300005Oooo`006_ooo`030000
oooooooo03Ooool00`000?ooooooo`0Goooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool0
0`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool001Ooool50000>Ooo
o`030000oooooooo01Koool00`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`030000oooooooo
03Soool00`000?ooooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<ooo
o`@00004oooo00<0003oooooool05Oooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0
003oooooool0>Oooo`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool00`000?oo
o`00000ioooo00@0003oooooool0000Foooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool2
0000>?ooo`040000oooooooo0000>_ooo`030000oooo000001Koool001Woool20000>_ooo`80000G
oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0hoooo0P0003coool2
00005_ooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_oo
o`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00K_oo
o`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00K_ooo`0306Ko
oooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00K_ooo`0306Kooooooooo
00?oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`004?ooool0000Aoooo000Foooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool02Oooo`04o`2Ioooooooo00003_ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool05Oooo`00Soooo`030000oooooooo01Soool00ol0VOoo
ooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool00`000?oo
ooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1c
oooo002?oooo0P0001Woool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2I
oooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000
oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo
07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`80000Ioooo00?o
09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0
003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Wooooo
ool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0003ooooo
ool06?ooo`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Looo
o`00Soooo`80000Ioooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOoo
ooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool00`000?oo
ooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1c
oooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool200006Oooo`03o`2I
oooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000
oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo
07?oool007coool200001?ooo`800004oooo0P0000Goool00`000?ooooooo`0Hoooo00?o09Wooooo
ool0Loooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000oooooooo
01Soool00ol0VOooooooo`1coooo001koooo00@0003oooooool0000;oooo00<0003oooooool00_oo
o`<0000Hoooo00?o09Woooooool0Loooo`00Noooo`040000oooooooo00002Oooo`800005oooo00<0
003oooooool06?ooo`03o`2Ioooooooo07?oool007_oool010000?ooooooo`0000Woool00`000?oo
ooooo`04oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool007coool200002_ooo`<00004
oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o
09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo0P00
01Woool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool0
08ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool0
0ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool0
0`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOoo
ooooo`1coooo002?oooo0P0001Woool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?oo
o`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Sooo
o`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2I
oooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`80000I
oooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1coooo002?
oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o
09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0
003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool200006Oooo`03o`2Ioooooooo07?oool0
08ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool0
0ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008Ooool5
00000oooo`030000oooooooo01Soool00ol0VOooooooo`1coooo0029oooo00<0003oooooool00ooo
o`030000oooooooo01Soool00ol0VOooooooo`1coooo0029oooo00<0003oooooool00oooo`<0000H
oooo00?o09Woooooool0Loooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0Hoooo00?o
09Woooooool0Loooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0Hoooo00?o09Wooooo
ool0Loooo`00R?ooo`800005oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool0
0`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOoo
ooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool200006Ooo
o`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Sooo
o`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2I
oooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000
oooooooo01Soool00ol0VOooooooo`1coooo002?oooo0P0001Woool00ol0VOooooooo`1coooo002?
oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o
09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0
003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Wooooo
ool0Loooo`00Soooo`80000Ioooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool0
0ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool0
0`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOoo
ooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool200006Ooo
o`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Sooo
o`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2I
oooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Noooo`D00002
oooo0P0000Coool200001Oooo`030000oooooooo01Soool00ol0VOooooooo`1coooo001moooo00<0
003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo01Soool00ol0VOooooooo`1c
oooo001moooo00<0003oooooool02_ooo`030000oooooooo00;oool300006?ooo`03o`2Ioooooooo
07?oool007goool00`000?ooooooo`08oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0
003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00NOoo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03Oooo`800004oooo0P0000?oool500000_ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000ooo
o`040000oooooooo00002_ooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001goooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool00`000?ooooooo`03
oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool0000:
oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000E
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Goooo0P0000[oool200000oooo`030000oooooooo07Woool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.58872 .24721 L
.59975 .24721 L
.60479 .24721 L
.60756 .24721 L
.61016 .24721 L
.61135 .24721 L
.6126 .24721 L
s
.6126 .24721 m
.6127 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.34309 .24721 L
.36173 .24721 L
.36626 .24721 L
.37114 .24721 L
.37257 .24721 L
.37328 .24721 L
.37393 .24721 L
.37515 .12361 L
.3758 .12361 L
.37649 .12361 L
.3815 .12361 L
.3841 .12361 L
.38553 .12361 L
.38622 .12361 L
.38686 .12361 L
.38799 .24721 L
.38921 .24721 L
.39178 .24721 L
.40291 .24721 L
.42308 .24721 L
.46293 .24721 L
.50126 .24721 L
.54204 .24721 L
.5813 .24721 L
.61906 .24721 L
.65926 .24721 L
.69795 .24721 L
.73909 .24721 L
.77871 .24721 L
.81682 .24721 L
.85738 .24721 L
.89642 .24721 L
.93792 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Koooo`@0I_l8oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0002>oooo001_oooo00@0I_ooooooool0I_l2oooo100000;oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool006ooool0101Vooooooooo`1V
o`Soool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00Kooo
o`0406Kooooooooo06Ko2Oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001_oooo00@0
I_ooooooool0I_lLoooo00<0003oooooool0S_ooo`00Koooo`0406Kooooooooo06Ko7?ooo`030000
oooooooo08koool006ooool0101Vooooooooo`1Voacoool00`000?ooooooo`2>oooo001_oooo00@0
I_ooooooool0I_lLoooo0P0008ooool006ooool0101Vooooooooo`1Voacoool00`000?ooooooo`2>
oooo001_oooo00@0I_ooooooool0I_lLoooo00<0003oooooool0S_ooo`00Koooo`0406Kooooooooo
06Ko7?ooo`030000oooooooo08koool006ooool0101Vooooooooo`1Voacoool00`000?ooooooo`2>
oooo001_oooo00@0I_ooooooool0I_lLoooo00<0003oooooool0S_ooo`00Koooo`0406Kooooooooo
06Ko7?ooo`80002?oooo001_oooo00@0I_ooooooool0I_lLoooo00<0003oooooool0S_ooo`00Kooo
o`0406Kooooooooo06Ko7?ooo`030000oooooooo08koool006ooool0101Vooooooooo`1Voacoool0
0`000?ooooooo`2>oooo001_oooo00D0I_ooooooooooool0I_l06oooo`030000oooooooo08koool0
06ooool01@1Vooooooooooooo`1Vo`0Koooo00<0003oooooool0S_ooo`00Koooo`0506Kooooooooo
oooo06Ko01_oool20000Soooo`00Koooo`0506Kooooooooooooo06Ko01_oool00`000?ooooooo`2>
oooo000Ioooo0`0003Soool400005oooo`0506Kooooooooooooo06Ko01_oool00`000?ooooooo`0g
oooo100003_oool300005Oooo`006_ooo`030000oooooooo03Ooool00`000?ooooooo`0Hoooo00D0
I_ooooooooooool0I_l06oooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool05oooo`0506Kooooooooooooo06Ko01_oool0
0`000?ooooooo`0hoooo00<0003oooooool0>Oooo`D0000Eoooo000Aoooo100000;oool010000?oo
ooooo`0003?oool400001?ooo`030000oooooooo01Koool01@1Vooooooooooooo`1Vo`0Koooo00<0
003oooooool0>Oooo`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool00`000?oo
o`00000ioooo00@0003oooooool0000Goooo00D0I_ooooooooooool0I_l06oooo`80000hoooo00@0
003oooooool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0001Soool01@1Voooo
ooooooooo`1Vo`0Koooo00<0003oooooool0>?ooo`80000loooo0P0001Koool006ooool01@1Voooo
ooooooooo`1Vo`0Koooo00<0003oooooool0S_ooo`00Koooo`0506Kooooooooooooo06Ko01_oool0
0`000?ooooooo`2>oooo001_oooo00D0I_ooooooooooool0I_l06oooo`030000oooooooo08koool0
06ooool01@1Vooooooooooooo`1Vo`0Koooo00<0003oooooool0S_ooo`00Koooo`0506Kooooooooo
oooo06Ko01_oool00`000?ooooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0;oooo00?o09T0003oool03Oooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool05Oooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?
oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o
09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo0P00
01_oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool0
08ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool0
0ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool0
0`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`80000Koooo00?o09Woooooool0LOoo
o`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_oo
o`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Sooo
o`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2I
oooooooo077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`80000K
oooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?
oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o
09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo00<0
003oooooool06_ooo`03o`2Ioooooooo077oool008ooool200006oooo`03o`2Ioooooooo077oool0
08ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool0
0ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool007coool2
00001?ooo`800004oooo0P0000Goool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Nooo
o`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000oooooooo01[oool00ol0VOoo
ooooo`1aoooo001koooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`<0000Joooo00?o
09Woooooool0LOooo`00Noooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool06_oo
o`03o`2Ioooooooo077oool007_oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0
003oooooool06_ooo`03o`2Ioooooooo077oool007coool200002_ooo`<00004oooo00<0003ooooo
ool06_ooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOoo
o`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo0P0001_oool00ol0VOoo
ooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool00`000?oo
ooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0J
oooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?
oooo0P0001_oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo
077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo
01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool0
08ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`80000Koooo00?o09Wooooo
ool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo00<0003ooooo
ool06_ooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOoo
o`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_oo
o`03o`2Ioooooooo077oool008ooool200006oooo`03o`2Ioooooooo077oool008ooool00`000?oo
ooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008Ooool500000oooo`030000
oooooooo01[oool00ol0VOooooooo`1aoooo0029oooo00<0003oooooool00oooo`030000oooooooo
01[oool00ol0VOooooooo`1aoooo0029oooo00<0003oooooool00oooo`<0000Joooo00?o09Wooooo
ool0LOooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0Joooo00?o09Woooooool0LOoo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00R?oo
o`800005oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0J
oooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?
oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool200006oooo`03o`2Ioooooooo
077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo
01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool0
08ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool0
0ol0VOooooooo`1aoooo002?oooo0P0001_oool00ol0VOooooooo`1aoooo002?oooo00<0003ooooo
ool06_ooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOoo
o`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_oo
o`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Sooo
o`80000Koooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0J
oooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?
oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool200006oooo`03o`2Ioooooooo
077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo
01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool0
08ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Noooo`D00002oooo0P0000Coool2
00001Oooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo001moooo00<0003oooooool01ooo
o`040000oooooooo00001?ooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo001moooo00<0
003oooooool02_ooo`030000oooooooo00;oool300006_ooo`03o`2Ioooooooo077oool007goool0
0`000?ooooooo`08oooo0P0009Koool007goool00`000?ooooooo`08oooo00<0003oooooool0UOoo
o`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00M_ooo`030000oooooooo
02koool00`000?ooooooo`1foooo001eoooo00<0003oooooool02?ooo`030000oooooooo02Goool0
0`000?ooooooo`1eoooo001eoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Ooo
o`800004oooo0P0000Coool200001?ooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0
003oooooool00008oooo00@0003oooooool00002oooo00@0003oooooool00003oooo00<0003ooooo
ool0MOooo`00M?ooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0003oooooool00008
oooo00@0003oooooool00005oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool0
0`000?ooooooo`0500004_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`800004
oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool00`000?ooooooo`03oooo00<0003oooooool0MOooo`00M_oo
o`030000oooooooo01Ooool200002_ooo`800004oooo0`0000;oool00`000?ooooooo`1foooo003o
oooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.58872 .24721 L
.59975 .24721 L
.60479 .24721 L
.61016 .24721 L
.61278 .24721 L
.61524 .24721 L
.61745 .24721 L
.61869 .24721 L
s
.61869 .24721 m
.61886 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002oooo`030000
oooooooo00;oool30000S_ooo`00MOooo`@00002oooo00@0003oooooool00009oooo0P0000Goool0
0`000?ooooooo`2>oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000
oooooooo08koool007coool200002_ooo`<00004oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool0
08ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>
oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo000Ioooo0`0003Soool40000=ooo
o`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000
oooooooo03Soool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool0
01Ooool50000>Oooo`030000oooooooo03Ooool00`000?ooooooo`0hoooo00<0003oooooool0>Ooo
o`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0003?oool400001?ooo`030000oooooooo
03Koool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?oo
o`030000oooo000003Woool010000?ooooooo`0003Ooool20000>?ooo`040000oooooooo0000>_oo
o`030000oooo000001Koool001Woool20000>_ooo`80000hoooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool008ooool0
0`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOoo
ooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool00`000?oo
ooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Woooooool0L?ooo`00Sooo
o`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2I
oooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000
oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo
073oool008ooool200007?ooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o
09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0
003oooooool06oooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Wooooo
ool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003ooooo
ool06oooo`03o`2Ioooooooo073oool008ooool200007?ooo`03o`2Ioooooooo073oool008ooool0
0`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOoo
ooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool00`000?oo
ooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`
oooo002?oooo0P0001coool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2I
oooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000
oooooooo01_oool00ol0VOooooooo`1`oooo001loooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool06oooo`03o`2Ioooooooo073oool007_oool010000?ooooooo`0000Soool010000?oo
ooooo`0000Coool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Noooo`040000oooooooo
00002oooo`030000oooooooo00;oool300006oooo`03o`2Ioooooooo073oool007_oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo001koooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo01_oool00ol0VOooooooo`1`
oooo001loooo0P0000[oool300001?ooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?
oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o
09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo
01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool0
08ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool0
0ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool0
0`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Woooooool0L?oo
o`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06ooo
o`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Sooo
o`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2I
oooooooo073oool008ooool200007?ooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0K
oooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?
oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o
09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo0P00
01coool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool0
08ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool0
0ol0VOooooooo`1`oooo0027oooo1@0000?oool00`000?ooooooo`0Koooo00?o09Woooooool0L?oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00ROoo
o`030000oooooooo00?oool300006oooo`03o`2Ioooooooo073oool008Woool00`000?ooooooo`03
oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008Woool00`000?ooooooo`03oooo00<0
003oooooool06oooo`03o`2Ioooooooo073oool008Soool200001Oooo`030000oooooooo01_oool0
0ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool0
0`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOoo
ooooo`1`oooo002?oooo0P0001coool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06ooo
o`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Sooo
o`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2I
oooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000L
oooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?
oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o
09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0
003oooooool06oooo`03o`2Ioooooooo073oool008ooool200007?ooo`03o`2Ioooooooo073oool0
08ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool0
0ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool0
0`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOoo
ooooo`1`oooo002?oooo0P0001coool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06ooo
o`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Sooo
o`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2I
oooooooo073oool007_oool500000_ooo`800004oooo0P0000Goool00`000?ooooooo`0Koooo00?o
09Woooooool0L?ooo`00OOooo`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?oo
ooooo`0Koooo00?o09Woooooool0L?ooo`00OOooo`030000oooooooo00[oool00`000?ooooooo`02
oooo0`0001_oool00ol0VOooooooo`1`oooo001moooo00<0003oooooool02?ooo`80002Foooo001m
oooo00<0003oooooool02?ooo`030000oooooooo09Goool007coool200002_ooo`<0002Eoooo003o
oooo8Oooo`00ooooob7oool007ooool00`000?ooooooo`0Loooo00<0003oooooool0Ooooo`00O_oo
o`030000oooooooo00Soool00`000?ooooooo`0Coooo00<0003oooooool0O_ooo`00O_ooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00Ooool200001?ooo`800004oooo00<0003ooooo
ool0O_ooo`00O_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool01Oooo`040000oooooooo00002Oooo`030000oooooooo07koool007goool00`000?ooooooo`02
oooo00<0003oooooool03Oooo`040000oooooooo00002_ooo`030000oooooooo07goool007koool0
0`000?ooooooo`0500003?ooo`040000oooooooo00002Oooo`030000oooooooo07koool007koool0
1@000?ooooooooooo`00000?oooo00@0003oooooool00009oooo00<0003oooooool0O_ooo`00Oooo
o`030000oooooooo017oool200002Oooo`030000oooooooo07ooool00?oooolQoooo003ooooo8Ooo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.59832 .24721 L
.60873 .24721 L
.61445 .24721 L
.61726 .24721 L
.61984 .24721 L
.62236 .24721 L
.62363 .24721 L
.62435 .24721 L
s
.62435 .24721 m
.62445 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.34309 .24721 L
.36173 .24721 L
.36626 .24721 L
.37114 .24721 L
.37257 .24721 L
.37328 .24721 L
.37393 .24721 L
.37515 .37082 L
.3758 .37082 L
.37649 .37082 L
.3815 .37082 L
.3841 .37082 L
.38553 .37082 L
.38622 .37082 L
.38686 .37082 L
.38799 .24721 L
.38921 .24721 L
.39178 .24721 L
.40291 .24721 L
.42308 .24721 L
.46293 .24721 L
.50126 .24721 L
.54204 .24721 L
.5813 .24721 L
.61906 .24721 L
.65926 .24721 L
.69795 .24721 L
.73909 .24721 L
.77871 .24721 L
.81682 .24721 L
.85738 .24721 L
.89642 .24721 L
.93792 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002oooo`030000
oooooooo00;oool30000S_ooo`00MOooo`@00002oooo00@0003oooooool00009oooo0P0000Goool0
0`000?ooooooo`2>oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000
oooooooo08koool007coool200002_ooo`<00004oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool0
08ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>
oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo000Ioooo0`0003Soool40000=ooo
o`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000
oooooooo03Soool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool0
01Ooool50000>Oooo`030000oooooooo03Ooool00`000?ooooooo`0hoooo00<0003oooooool0>Ooo
o`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0003?oool400001?ooo`030000oooooooo
03Koool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?oo
o`030000oooo000003Woool010000?ooooooo`0003Ooool20000>?ooo`040000oooooooo0000>_oo
o`030000oooo000001Koool001Woool20000>_ooo`80000hoooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0:oooo00D0
I_ooool0003oool0I_l03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000ooooo`2I00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool0
06ooool01@1Vooooooooooooo`1Vo`0Koooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool0
06ooool01@1Vooooooooooooo`1Vo`0Koooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool0
06ooool01@1Vooooooooooooo`1Vo`0Koooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool0
06ooool01@1Vooooooooooooo`1Vo`0Koooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool0
06ooool01@1Vooooooooooooo`1Vo`0Koooo0P0001koool00ol0VOooooooo`1^oooo001_oooo00D0
I_ooooooooooool0I_l06oooo`030000oooooooo01goool00ol0VOooooooo`1^oooo001_oooo00D0
I_ooooooooooool0I_l06oooo`030000oooooooo01goool00ol0VOooooooo`1^oooo001_oooo00D0
I_ooooooooooool0I_l06oooo`030000oooooooo01goool00ol0VOooooooo`1^oooo001_oooo00D0
I_ooooooooooool0I_l06oooo`030000oooooooo01goool00ol0VOooooooo`1^oooo001_oooo00D0
I_ooooooooooool0I_l06oooo`030000oooooooo01goool00ol0VOooooooo`1^oooo001_oooo00D0
I_ooooooooooool0I_l06oooo`80000Noooo00?o09Woooooool0K_ooo`00Koooo`0506Kooooooooo
oooo06Ko01_oool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Koooo`0506Kooooooooo
oooo06Ko01_oool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Koooo`0506Kooooooooo
oooo06Ko01_oool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Koooo`0406Kooooooooo
06Ko7?ooo`030000oooooooo01goool00ol0VOooooooo`1^oooo001_oooo00@0I_ooooooool0I_lL
oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool006ooool0101Vooooooooo`1Voacoool0
0`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Koooo`0406Kooooooooo06Ko7?ooo`80000N
oooo00?o09Woooooool0K_ooo`00Koooo`0406Kooooooooo06Ko7?ooo`030000oooooooo01goool0
0ol0VOooooooo`1^oooo001_oooo00@0I_ooooooool0I_lLoooo00<0003oooooool07Oooo`03o`2I
oooooooo06koool006ooool0101Vooooooooo`1Voacoool00`000?ooooooo`0Moooo00?o09Wooooo
ool0K_ooo`00Koooo`0406Kooooooooo06Ko7?ooo`030000oooooooo01goool00ol0VOooooooo`1^
oooo001_oooo00@0I_ooooooool0I_lLoooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool0
06ooool0101Vooooooooo`1Voacoool200007_ooo`03o`2Ioooooooo06koool006ooool0101Voooo
ooooo`1Voacoool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Koooo`0406Kooooooooo
06Ko7?ooo`030000oooooooo01goool00ol0VOooooooo`1^oooo001_oooo00@0I_ooooooool0I_lL
oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool006ooool0101Vooooooooo`1Vo`Woool2
00001?ooo`800004oooo0P0000Goool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Kooo
o`0406Kooooooooo06Ko2?ooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000
oooooooo01goool00ol0VOooooooo`1^oooo001_oooo101Vo`Soool010000?ooooooo`0000_oool0
0`000?ooooooo`02oooo0`0001goool00ol0VOooooooo`1^oooo001koooo00@0003oooooool00009
oooo0P0000Goool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Noooo`040000oooooooo
00002Oooo`030000oooooooo00Coool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00O?oo
o`80000:oooo0`0000Coool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000
oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo
06koool008ooool200007_ooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o
09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0
003oooooool07Oooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Wooooo
ool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0003ooooo
ool07Oooo`03o`2Ioooooooo06koool008ooool200007_ooo`03o`2Ioooooooo06koool008ooool0
0`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOoo
ooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008ooool00`000?oo
ooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^
oooo002?oooo0P0001koool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2I
oooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000
oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo
06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`80000Noooo00?o
09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0
003oooooool07Oooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Wooooo
ool0K_ooo`00Qoooo`D00003oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008Woool0
0`000?ooooooo`03oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008Woool00`000?oo
ooooo`03oooo0`0001goool00ol0VOooooooo`1^oooo0029oooo00<0003oooooool00oooo`030000
oooooooo01goool00ol0VOooooooo`1^oooo0029oooo00<0003oooooool00oooo`030000oooooooo
01goool00ol0VOooooooo`1^oooo0028oooo0P0000Goool00`000?ooooooo`0Moooo00?o09Wooooo
ool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0003ooooo
ool07Oooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_oo
o`00Soooo`80000Noooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOoo
ooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008ooool00`000?oo
ooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^
oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008ooool200007_ooo`03o`2I
oooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000
oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo
06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo
01goool00ol0VOooooooo`1^oooo002?oooo0P0001koool00ol0VOooooooo`1^oooo002?oooo00<0
003oooooool07Oooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Wooooo
ool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0003ooooo
ool07Oooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_oo
o`00Soooo`80000Noooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOoo
ooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008ooool00`000?oo
ooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^
oooo001koooo1@0000;oool200001?ooo`800005oooo00<0003oooooool07Oooo`03o`2Ioooooooo
06koool007goool00`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool07Ooo
o`03o`2Ioooooooo06koool007goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0000M
oooo00?o09Woooooool0K_ooo`00OOooo`030000oooooooo00Soool20000U_ooo`00OOooo`030000
oooooooo00Soool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOooo`00ooooob7oool0
0?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?oo
ooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02
oooo0P0000Coool00`000?ooooooo`07oooo0P0000Coool200001?ooo`800004oooo0P0000Coool0
0`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`05oooo00@0003oooooool00008oooo00@0003oooooool00002oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=
oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool00_ooo`030000
oooooooo07Ooool007Soool00`000?ooooooo`0500003?ooo`040000oooooooo00002?ooo`040000
oooooooo00000oooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
00ooool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`03oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo017oool200002_ooo`800004oooo0`0000;oool0
0`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.59832 .24721 L
.60873 .24721 L
.61984 .24721 L
.6254 .24721 L
.62812 .24721 L
.62932 .24721 L
.63064 .24721 L
s
.63064 .24721 m
.63081 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.34309 .24721 L
.35271 .24721 L
.36173 .24721 L
.36626 .24721 L
.36757 .24721 L
.36881 .24721 L
.36992 .37082 L
.37114 .37082 L
.3815 .37082 L
.38681 .37082 L
.38942 .37082 L
.39056 .37082 L
.39182 .37082 L
.39295 .24721 L
.394 .24721 L
.39631 .24721 L
.40117 .24721 L
.42214 .24721 L
.46105 .24721 L
.50241 .24721 L
.54226 .24721 L
.58059 .24721 L
.62137 .24721 L
.66064 .24721 L
.69839 .24721 L
.73859 .24721 L
.77728 .24721 L
.81842 .24721 L
.85804 .24721 L
.89615 .24721 L
.93671 .24721 L
.97576 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002oooo`030000
oooooooo00;oool30000S_ooo`00MOooo`@00002oooo00@0003oooooool00009oooo0P0000Goool0
0`000?ooooooo`2>oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000
oooooooo08koool007coool200002_ooo`<00004oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool0
08ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>
oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo000Ioooo0`0003Soool40000=ooo
o`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000
oooooooo03Soool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool0
01Ooool50000>Oooo`030000oooooooo03Ooool00`000?ooooooo`0hoooo00<0003oooooool0>Ooo
o`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0003?oool400001?ooo`030000oooooooo
03Koool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?oo
o`030000oooo000003Woool010000?ooooooo`0003Ooool20000>?ooo`040000oooooooo0000>_oo
o`030000oooo000001Koool001Woool20000>_ooo`80000hoooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`09oooo00@0
I_ooooooool00002oooo00<0I_ooooooool02Oooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`040000ooooooooo`2I2oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool05Oooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003ooooo
ool07_ooo`03o`2Ioooooooo06goool006koool00`1Vooooooooo`03oooo00<0I_ooooooool06?oo
o`030000oooooooo01koool00ol0VOooooooo`1]oooo001^oooo00<0I_ooooooool00oooo`0306Ko
oooooooo01Soool00`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00K_ooo`0306Kooooooooo
00?oool00`1Vooooooooo`0Hoooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool006koool0
0`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`80000Ooooo00?o09Woooooool0KOooo`00K_oo
o`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool07_ooo`03o`2Ioooooooo
06goool006koool00`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`030000oooooooo01koool0
0ol0VOooooooo`1]oooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool00`000?oo
ooooo`0Noooo00?o09Woooooool0KOooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0H
oooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool006koool00`1Vooooooooo`03oooo00<0
I_ooooooool06?ooo`030000oooooooo01koool00ol0VOooooooo`1]oooo001^oooo00<0I_oooooo
ool00oooo`0306Kooooooooo01Soool200007oooo`03o`2Ioooooooo06goool006koool00`1Voooo
ooooo`03oooo00<0I_ooooooool06?ooo`030000oooooooo01koool00ol0VOooooooo`1]oooo001^
oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0Noooo00?o09Wooooo
ool0KOooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool07_oo
o`03o`2Ioooooooo06goool006koool00`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`030000
oooooooo01koool00ol0VOooooooo`1]oooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo
01Soool00`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00K_ooo`0306Kooooooooo00?oool0
0`1Vooooooooo`0Hoooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool006koool00`1Voooo
ooooo`03oooo00<0I_ooooooool06?ooo`80000Ooooo00?o09Woooooool0KOooo`00K_ooo`0306Ko
oooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool0
06koool00`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`030000oooooooo01koool00ol0VOoo
ooooo`1]oooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0N
oooo00?o09Woooooool0KOooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0
003oooooool07_ooo`03o`2Ioooooooo06goool006koool00`1Vooooooooo`03oooo00<0I_oooooo
ool06?ooo`030000oooooooo01koool00ol0VOooooooo`1]oooo001^oooo00<0I_ooooooool00ooo
o`0306Kooooooooo01Soool200007oooo`03o`2Ioooooooo06goool006koool00`1Vooooooooo`03
oooo00<0I_ooooooool06?ooo`030000oooooooo01koool00ol0VOooooooo`1]oooo001^oooo00<0
I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0Noooo00?o09Woooooool0KOoo
o`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool07_ooo`03o`2I
oooooooo06goool006koool00`1Vooooooooo`03oooo00<0I_ooooooool01Oooo`800004oooo0P00
00Coool200001Oooo`030000oooooooo01koool00ol0VOooooooo`1]oooo001^oooo00<0I_oooooo
ool00oooo`0306Kooooooooo00Coool010000?ooooooo`0000Soool010000?ooooooo`0000Coool0
0`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00K_ooo`L0I_l6oooo00@0003oooooool0000;
oooo00<0003oooooool00_ooo`<0000Noooo00?o09Woooooool0KOooo`00Noooo`040000oooooooo
00002Oooo`800005oooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool007_oool010000?oo
ooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool0
07coool200002_ooo`<00004oooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool008ooool0
0`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00Soooo`030000oooooooo01koool00ol0VOoo
ooooo`1]oooo002?oooo0P0001ooool00ol0VOooooooo`1]oooo002?oooo00<0003oooooool07_oo
o`03o`2Ioooooooo06goool008ooool00`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00Sooo
o`030000oooooooo01koool00ol0VOooooooo`1]oooo002?oooo00<0003oooooool07_ooo`03o`2I
oooooooo06goool008ooool00`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00Soooo`030000
oooooooo01koool00ol0VOooooooo`1]oooo002?oooo0P0001ooool00ol0VOooooooo`1]oooo002?
oooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool008ooool00`000?ooooooo`0Noooo00?o
09Woooooool0KOooo`00Soooo`030000oooooooo01koool00ol0VOooooooo`1]oooo002?oooo00<0
003oooooool07_ooo`03o`2Ioooooooo06goool008ooool00`000?ooooooo`0Noooo00?o09Wooooo
ool0KOooo`00Soooo`80000Ooooo00?o09Woooooool0KOooo`00Soooo`030000oooooooo01koool0
0ol0VOooooooo`1]oooo002?oooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool008ooool0
0`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00Soooo`030000oooooooo01koool00ol0VOoo
ooooo`1]oooo002?oooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool008ooool200007ooo
o`03o`2Ioooooooo06goool008ooool00`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00Sooo
o`030000oooooooo01koool00ol0VOooooooo`1]oooo002?oooo00<0003oooooool07_ooo`03o`2I
oooooooo06goool008Ooool500000oooo`030000oooooooo01koool00ol0VOooooooo`1]oooo0029
oooo00<0003oooooool00oooo`030000oooooooo01koool00ol0VOooooooo`1]oooo0029oooo00<0
003oooooool00oooo`<0000Noooo00?o09Woooooool0KOooo`00ROooo`030000oooooooo00?oool0
0`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00ROooo`030000oooooooo00?oool00`000?oo
ooooo`0Noooo00?o09Woooooool0KOooo`00R?ooo`800005oooo00<0003oooooool07_ooo`03o`2I
oooooooo06goool008ooool00`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00Soooo`030000
oooooooo01koool00ol0VOooooooo`1]oooo002?oooo00<0003oooooool07_ooo`03o`2Ioooooooo
06goool008ooool200007oooo`03o`2Ioooooooo06goool008ooool00`000?ooooooo`0Noooo00?o
09Woooooool0KOooo`00Soooo`030000oooooooo01koool00ol0VOooooooo`1]oooo002?oooo00<0
003oooooool07_ooo`03o`2Ioooooooo06goool008ooool00`000?ooooooo`0Noooo00?o09Wooooo
ool0KOooo`00Soooo`030000oooooooo01koool00ol0VOooooooo`1]oooo002?oooo0P0001ooool0
0ol0VOooooooo`1]oooo002?oooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool008ooool0
0`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00Soooo`030000oooooooo01koool00ol0VOoo
ooooo`1]oooo002?oooo00<0003oooooool07_ooo`03o`2Ioooooooo06goool008ooool00`000?oo
ooooo`0Noooo00?o09Woooooool0KOooo`00Soooo`80000Ooooo00?o09Woooooool0KOooo`00Sooo
o`030000oooooooo01koool00ol0VOooooooo`1]oooo002?oooo00<0003oooooool07_ooo`03o`2I
oooooooo06goool008ooool00`000?ooooooo`0Noooo00?o09Woooooool0KOooo`00Soooo`030000
oooooooo01koool00ol0VOooooooo`1]oooo002?oooo00<0003oooooool07_ooo`03o`2Ioooooooo
06goool008ooool200007oooo`03o`2Ioooooooo06goool008ooool00`000?ooooooo`0Noooo00?o
09Woooooool0KOooo`00Soooo`030000oooooooo01koool00ol0VOooooooo`1]oooo002?oooo00<0
003oooooool07_ooo`03o`2Ioooooooo06goool008ooool00`000?ooooooo`0Noooo00?o09Wooooo
ool0KOooo`00Noooo`D00002oooo0P0000Coool200001Oooo`030000oooooooo01koool00ol0VOoo
ooooo`1]oooo001moooo00<0003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo
01koool00ol0VOooooooo`1]oooo001moooo00<0003oooooool02_ooo`030000oooooooo00;oool3
00007_ooo`03o`2Ioooooooo06goool007goool00`000?ooooooo`08oooo0P0009Koool007goool0
0`000?ooooooo`08oooo00<0003oooooool0UOooo`00O?ooo`80000:oooo0`0009Goool00?oooolQ
oooo003ooooo8Oooo`00O?ooo`030000oooooooo02;oool00`000?ooooooo`1loooo001koooo00<0
003oooooool02?ooo`030000oooooooo01Woool00`000?ooooooo`1koooo001koooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool01oooo`800004oooo0P0000?oool500000_ooo`030000
oooooooo07_oool007_oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Goool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003oooooool0Nooo
o`00N_ooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0003oooooool0000:oooo00<0
003oooooool00oooo`030000oooooooo07[oool007_oool00`000?ooooooo`0500003?ooo`040000
oooooooo00002_ooo`030000oooooooo00;oool00`000?ooooooo`1koooo001koooo00D0003ooooo
ooooool000003oooo`040000oooooooo00002_ooo`030000oooooooo00;oool00`000?ooooooo`1k
oooo001loooo00<0003oooooool04Oooo`80000:oooo0P0000?oool00`000?ooooooo`1loooo003o
oooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.59832 .24721 L
.60873 .24721 L
.61984 .24721 L
.6254 .24721 L
.63064 .24721 L
.63292 .24721 L
.63534 .24721 L
.6366 .24721 L
s
.6366 .24721 m
.63671 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.34309 .24721 L
.35271 .24721 L
.35742 .24721 L
.35948 .24721 L
.36173 .24721 L
.36294 .24721 L
.36405 .37082 L
.36512 .37082 L
.36626 .37082 L
.37114 .37082 L
.3815 .37082 L
.39178 .37082 L
.3946 .37082 L
.39614 .37082 L
.39758 .37082 L
.39881 .37082 L
.40012 .24721 L
.40087 .24721 L
.40158 .24721 L
.40291 .24721 L
.42308 .24721 L
.46141 .24721 L
.50219 .24721 L
.54146 .24721 L
.57921 .24721 L
.61941 .24721 L
.6581 .24721 L
.69924 .24721 L
.73886 .24721 L
.77697 .24721 L
.81753 .24721 L
.85658 .24721 L
.89808 .24721 L
.93806 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002oooo`030000
oooooooo00;oool30000S_ooo`00MOooo`@00002oooo00@0003oooooool00009oooo0P0000Goool0
0`000?ooooooo`2>oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000
oooooooo08koool007coool200002_ooo`<00004oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool0
08ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>
oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo000Ioooo0`0003Soool40000=ooo
o`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000
oooooooo03Soool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool0
01Ooool50000>Oooo`030000oooooooo03Ooool00`000?ooooooo`0hoooo00<0003oooooool0>Ooo
o`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0003?oool400001?ooo`030000oooooooo
03Koool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?oo
o`030000oooo000003Woool010000?ooooooo`0003Ooool20000>?ooo`040000oooooooo0000>_oo
o`030000oooo000001Koool001Woool20000>_ooo`80000hoooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`07oooo00<0
I_ooooooool00_ooo`030000oooooooo00;oool00`1Vooooooooo`07oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool00_ooo`03o`2Ioooooooo
00Ooool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool006coool00`1Vooooooooo`07
oooo00<0I_ooooooool05_ooo`030000oooooooo023oool00ol0VOooooooo`1[oooo001/oooo00<0
I_ooooooool01oooo`0306Kooooooooo01Koool00`000?ooooooo`0Poooo00?o09Woooooool0Jooo
o`00K?ooo`0306Kooooooooo00Ooool00`1Vooooooooo`0Foooo00<0003oooooool08?ooo`03o`2I
oooooooo06_oool006coool00`1Vooooooooo`07oooo00<0I_ooooooool05_ooo`030000oooooooo
023oool00ol0VOooooooo`1[oooo001/oooo00<0I_ooooooool01oooo`0306Kooooooooo01Koool2
00008Oooo`03o`2Ioooooooo06_oool006coool00`1Vooooooooo`07oooo00<0I_ooooooool05_oo
o`030000oooooooo023oool00ol0VOooooooo`1[oooo001/oooo00<0I_ooooooool01oooo`0306Ko
oooooooo01Koool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00K?ooo`0306Kooooooooo
00Ooool00`1Vooooooooo`0Foooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool006coool0
0`1Vooooooooo`07oooo00<0I_ooooooool05_ooo`030000oooooooo023oool00ol0VOooooooo`1[
oooo001/oooo00<0I_ooooooool01oooo`0306Kooooooooo01Koool00`000?ooooooo`0Poooo00?o
09Woooooool0Joooo`00K?ooo`0306Kooooooooo00Ooool00`1Vooooooooo`0Foooo0P00027oool0
0ol0VOooooooo`1[oooo001/oooo00<0I_ooooooool01oooo`0306Kooooooooo01Koool00`000?oo
ooooo`0Poooo00?o09Woooooool0Joooo`00K?ooo`0306Kooooooooo00Ooool00`1Vooooooooo`0F
oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool006coool00`1Vooooooooo`07oooo00<0
I_ooooooool05_ooo`030000oooooooo023oool00ol0VOooooooo`1[oooo001]oooo00<0I_oooooo
ool01Oooo`0306Kooooooooo01Ooool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00KOoo
o`0306Kooooooooo00Goool00`1Vooooooooo`0Goooo00<0003oooooool08?ooo`03o`2Ioooooooo
06_oool006goool00`1Vooooooooo`05oooo00<0I_ooooooool05oooo`030000oooooooo023oool0
0ol0VOooooooo`1[oooo001]oooo00<0I_ooooooool01Oooo`0306Kooooooooo01Ooool200008Ooo
o`03o`2Ioooooooo06_oool006goool00`1Vooooooooo`05oooo00<0I_ooooooool05oooo`030000
oooooooo023oool00ol0VOooooooo`1[oooo001]oooo00<0I_ooooooool01Oooo`0306Kooooooooo
01Ooool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00KOooo`0306Kooooooooo00Goool0
0`1Vooooooooo`0Goooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool006goool00`1Voooo
ooooo`05oooo00<0I_ooooooool05oooo`030000oooooooo023oool00ol0VOooooooo`1[oooo001]
oooo00<0I_ooooooool01Oooo`0306Kooooooooo01Ooool00`000?ooooooo`0Poooo00?o09Wooooo
ool0Joooo`00KOooo`0306Kooooooooo00Goool00`1Vooooooooo`0Goooo0P00027oool00ol0VOoo
ooooo`1[oooo001]oooo00<0I_ooooooool01Oooo`0306Kooooooooo01Ooool00`000?ooooooo`0P
oooo00?o09Woooooool0Joooo`00KOooo`0306Kooooooooo00Goool00`1Vooooooooo`0Goooo00<0
003oooooool08?ooo`03o`2Ioooooooo06_oool006goool00`1Vooooooooo`05oooo00<0I_oooooo
ool05oooo`030000oooooooo023oool00ol0VOooooooo`1[oooo001]oooo00<0I_ooooooool01Ooo
o`0306Kooooooooo00Coool200001?ooo`800004oooo0P0000Goool00`000?ooooooo`0Poooo00?o
09Woooooool0Joooo`00KOooo`0306Kooooooooo00Goool00`1Vooooooooo`03oooo00@0003ooooo
ool00008oooo00@0003oooooool00004oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool0
06goool906Ko1Oooo`040000oooooooo00002oooo`030000oooooooo00;oool300008?ooo`03o`2I
oooooooo06_oool007_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo023oool0
0ol0VOooooooo`1[oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000
oooooooo023oool00ol0VOooooooo`1[oooo001loooo0P0000[oool300001?ooo`030000oooooooo
023oool00ol0VOooooooo`1[oooo002?oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool0
08ooool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00Soooo`80000Qoooo00?o09Wooooo
ool0Joooo`00Soooo`030000oooooooo023oool00ol0VOooooooo`1[oooo002?oooo00<0003ooooo
ool08?ooo`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0Poooo00?o09Woooooool0Jooo
o`00Soooo`030000oooooooo023oool00ol0VOooooooo`1[oooo002?oooo00<0003oooooool08?oo
o`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00Sooo
o`80000Qoooo00?o09Woooooool0Joooo`00Soooo`030000oooooooo023oool00ol0VOooooooo`1[
oooo002?oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0P
oooo00?o09Woooooool0Joooo`00Soooo`030000oooooooo023oool00ol0VOooooooo`1[oooo002?
oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool008ooool200008Oooo`03o`2Ioooooooo
06_oool008ooool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00Soooo`030000oooooooo
023oool00ol0VOooooooo`1[oooo002?oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool0
08ooool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00Soooo`030000oooooooo023oool0
0ol0VOooooooo`1[oooo002?oooo0P00027oool00ol0VOooooooo`1[oooo002?oooo00<0003ooooo
ool08?ooo`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0Poooo00?o09Woooooool0Jooo
o`00Soooo`030000oooooooo023oool00ol0VOooooooo`1[oooo0027oooo1@0000?oool00`000?oo
ooooo`0Poooo00?o09Woooooool0Joooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0P
oooo00?o09Woooooool0Joooo`00ROooo`030000oooooooo00?oool300008?ooo`03o`2Ioooooooo
06_oool008Woool00`000?ooooooo`03oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool0
08Woool00`000?ooooooo`03oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool008Soool2
00001Oooo`030000oooooooo023oool00ol0VOooooooo`1[oooo002?oooo00<0003oooooool08?oo
o`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00Sooo
o`030000oooooooo023oool00ol0VOooooooo`1[oooo002?oooo0P00027oool00ol0VOooooooo`1[
oooo002?oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0P
oooo00?o09Woooooool0Joooo`00Soooo`030000oooooooo023oool00ol0VOooooooo`1[oooo002?
oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0Poooo00?o
09Woooooool0Joooo`00Soooo`80000Qoooo00?o09Woooooool0Joooo`00Soooo`030000oooooooo
023oool00ol0VOooooooo`1[oooo002?oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool0
08ooool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00Soooo`030000oooooooo023oool0
0ol0VOooooooo`1[oooo002?oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool008ooool2
00008Oooo`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0Poooo00?o09Woooooool0Jooo
o`00Soooo`030000oooooooo023oool00ol0VOooooooo`1[oooo002?oooo00<0003oooooool08?oo
o`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00Sooo
o`030000oooooooo023oool00ol0VOooooooo`1[oooo002?oooo0P00027oool00ol0VOooooooo`1[
oooo002?oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool008ooool00`000?ooooooo`0P
oooo00?o09Woooooool0Joooo`00Soooo`030000oooooooo023oool00ol0VOooooooo`1[oooo002?
oooo00<0003oooooool08?ooo`03o`2Ioooooooo06_oool007_oool500000_ooo`800004oooo0P00
00Goool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00OOooo`030000oooooooo00Ooool0
10000?ooooooo`0000Coool00`000?ooooooo`0Poooo00?o09Woooooool0Joooo`00OOooo`030000
oooooooo00[oool00`000?ooooooo`02oooo0`00023oool00ol0VOooooooo`1[oooo001moooo00<0
003oooooool02?ooo`80002Foooo001moooo00<0003oooooool02?ooo`030000oooooooo09Goool0
07coool200002_ooo`<0002Eoooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0X
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0
003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00Ooool2
00001?ooo`800003oooo1@0000;oool200001?ooo`030000oooooooo07Soool007Soool01@000?oo
ooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool010000?ooooooo`00
00[oool01@000?ooooooooooo`000002oooo00D0003oooooooooool00000N_ooo`00Moooo`030000
oooooooo00;oool00`000?ooooooo`0=oooo00@0003oooooool0000:oooo00<0003oooooool01?oo
o`030000oooooooo00;oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0000coool0
10000?ooooooo`0000[oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000003oooo`040000oooooooo00002_ooo`030000oooooooo00;oool0
0`000?ooooooo`03oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo017oool200002_oo
o`800004oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.59832 .24721 L
.61984 .24721 L
.6298 .24721 L
.63527 .24721 L
.63796 .24721 L
.64043 .24721 L
.64164 .24721 L
.64277 .24721 L
s
.64277 .24721 m
.64295 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.33304 .24721 L
.34309 .24721 L
.34772 .24721 L
.35028 .24721 L
.35271 .24721 L
.35496 .24721 L
.35624 .24721 L
.35742 .37082 L
.35852 .37082 L
.35951 .37082 L
.36173 .37082 L
.3815 .37082 L
.39086 .37082 L
.39597 .37082 L
.40075 .37082 L
.40324 .37082 L
.40396 .37082 L
.40464 .37082 L
.40592 .24721 L
.4066 .24721 L
.40733 .24721 L
.40863 .24721 L
.41159 .24721 L
.42157 .24721 L
.45932 .24721 L
.49952 .24721 L
.53821 .24721 L
.57935 .24721 L
.61897 .24721 L
.65708 .24721 L
.69764 .24721 L
.73669 .24721 L
.77818 .24721 L
.81817 .24721 L
.85663 .24721 L
.89755 .24721 L
.93695 .24721 L
.97484 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002oooo`030000
oooooooo00;oool30000S_ooo`00MOooo`@00002oooo00@0003oooooool00009oooo0P0000Goool0
0`000?ooooooo`2>oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000
oooooooo08koool007coool200002_ooo`<00004oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool0
08ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>
oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo000Ioooo0`0003Soool40000=ooo
o`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000
oooooooo03Soool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool0
01Ooool50000>Oooo`030000oooooooo03Ooool00`000?ooooooo`0hoooo00<0003oooooool0>Ooo
o`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0003?oool400001?ooo`030000oooooooo
03Koool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?oo
o`030000oooo000003Woool010000?ooooooo`0003Ooool20000>?ooo`040000oooooooo0000>_oo
o`030000oooo000001Koool001Woool20000>_ooo`80000hoooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`06oooo00<0
I_ooooooool00oooo`030000oooooooo00?oool00`1Vooooooooo`06oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool00oooo`03o`2Ioooooooo
00Koool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool006_oool00`1Vooooooooo`09
oooo00<0I_ooooooool05Oooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo001[oooo00<0
I_ooooooool02Oooo`0306Kooooooooo01Goool00`000?ooooooo`0Qoooo00?o09Woooooool0J_oo
o`00Joooo`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo00<0003oooooool08Oooo`03o`2I
oooooooo06[oool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo
027oool00ol0VOooooooo`1Zoooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool2
00008_ooo`03o`2Ioooooooo06[oool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Ooo
o`030000oooooooo027oool00ol0VOooooooo`1Zoooo001[oooo00<0I_ooooooool02Oooo`0306Ko
oooooooo01Goool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Joooo`0306Kooooooooo
00Woool00`1Vooooooooo`0Eoooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool006_oool0
0`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo027oool00ol0VOooooooo`1Z
oooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool00`000?ooooooo`0Qoooo00?o
09Woooooool0J_ooo`00Joooo`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo0P0002;oool0
0ol0VOooooooo`1Zoooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool00`000?oo
ooooo`0Qoooo00?o09Woooooool0J_ooo`00Joooo`0306Kooooooooo00Woool00`1Vooooooooo`0E
oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool006_oool00`1Vooooooooo`09oooo00<0
I_ooooooool05Oooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo001[oooo00<0I_oooooo
ool02Oooo`0306Kooooooooo01Goool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Jooo
o`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo00<0003oooooool08Oooo`03o`2Ioooooooo
06[oool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo027oool0
0ol0VOooooooo`1Zoooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool200008_oo
o`03o`2Ioooooooo06[oool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000
oooooooo027oool00ol0VOooooooo`1Zoooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo
01Goool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Joooo`0306Kooooooooo00Woool0
0`1Vooooooooo`0Eoooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool006_oool00`1Voooo
ooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo001[
oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool00`000?ooooooo`0Qoooo00?o09Wooooo
ool0J_ooo`00Joooo`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo0P0002;oool00ol0VOoo
ooooo`1Zoooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool00`000?ooooooo`0Q
oooo00?o09Woooooool0J_ooo`00Joooo`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo00<0
003oooooool08Oooo`03o`2Ioooooooo06[oool006_oool00`1Vooooooooo`09oooo00<0I_oooooo
ool05Oooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo001[oooo00<0I_ooooooool02Ooo
o`0306Kooooooooo00;oool200001?ooo`800004oooo0P0000Goool00`000?ooooooo`0Qoooo00?o
09Woooooool0J_ooo`00Joooo`0306Kooooooooo00Woool01@1Vooooooooooooo`000002oooo00<0
003oooooool01_ooo`040000oooooooo00001?ooo`030000oooooooo027oool00ol0VOooooooo`1Z
oooo001[oooo3@1Vo`?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00027oool0
0ol0VOooooooo`1Zoooo001koooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`0Q
oooo00?o09Woooooool0J_ooo`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool0
0`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00O?ooo`80000:oooo0`0000Coool00`000?oo
ooooo`0Qoooo00?o09Woooooool0J_ooo`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Z
oooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool008ooool200008_ooo`03o`2I
oooooooo06[oool008ooool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Soooo`030000
oooooooo027oool00ol0VOooooooo`1Zoooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo
06[oool008ooool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Soooo`030000oooooooo
027oool00ol0VOooooooo`1Zoooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool0
08ooool200008_ooo`03o`2Ioooooooo06[oool008ooool00`000?ooooooo`0Qoooo00?o09Wooooo
ool0J_ooo`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo002?oooo00<0003ooooo
ool08Oooo`03o`2Ioooooooo06[oool008ooool00`000?ooooooo`0Qoooo00?o09Woooooool0J_oo
o`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo002?oooo0P0002;oool00ol0VOoo
ooooo`1Zoooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool008ooool00`000?oo
ooooo`0Qoooo00?o09Woooooool0J_ooo`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Z
oooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool008ooool00`000?ooooooo`0Q
oooo00?o09Woooooool0J_ooo`00Soooo`80000Roooo00?o09Woooooool0J_ooo`00Soooo`030000
oooooooo027oool00ol0VOooooooo`1Zoooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo
06[oool008ooool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Qoooo`D00003oooo00<0
003oooooool08Oooo`03o`2Ioooooooo06[oool008Woool00`000?ooooooo`03oooo00<0003ooooo
ool08Oooo`03o`2Ioooooooo06[oool008Woool00`000?ooooooo`03oooo0`00027oool00ol0VOoo
ooooo`1Zoooo0029oooo00<0003oooooool00oooo`030000oooooooo027oool00ol0VOooooooo`1Z
oooo0029oooo00<0003oooooool00oooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo0028
oooo0P0000Goool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Soooo`030000oooooooo
027oool00ol0VOooooooo`1Zoooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool0
08ooool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Soooo`80000Roooo00?o09Wooooo
ool0J_ooo`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo002?oooo00<0003ooooo
ool08Oooo`03o`2Ioooooooo06[oool008ooool00`000?ooooooo`0Qoooo00?o09Woooooool0J_oo
o`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo002?oooo00<0003oooooool08Ooo
o`03o`2Ioooooooo06[oool008ooool200008_ooo`03o`2Ioooooooo06[oool008ooool00`000?oo
ooooo`0Qoooo00?o09Woooooool0J_ooo`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Z
oooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool008ooool00`000?ooooooo`0Q
oooo00?o09Woooooool0J_ooo`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo002?
oooo0P0002;oool00ol0VOooooooo`1Zoooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo
06[oool008ooool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Soooo`030000oooooooo
027oool00ol0VOooooooo`1Zoooo002?oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool0
08ooool00`000?ooooooo`0Qoooo00?o09Woooooool0J_ooo`00Soooo`80000Roooo00?o09Wooooo
ool0J_ooo`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo002?oooo00<0003ooooo
ool08Oooo`03o`2Ioooooooo06[oool008ooool00`000?ooooooo`0Qoooo00?o09Woooooool0J_oo
o`00Soooo`030000oooooooo027oool00ol0VOooooooo`1Zoooo001koooo1@0000;oool200001?oo
o`800005oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool007goool00`000?ooooooo`07
oooo00@0003oooooool00004oooo00<0003oooooool08Oooo`03o`2Ioooooooo06[oool007goool0
0`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0000Qoooo00?o09Woooooool0J_ooo`00OOoo
o`030000oooooooo00Soool20000U_ooo`00OOooo`030000oooooooo00Soool00`000?ooooooo`2E
oooo001loooo0P0000[oool30000UOooo`00ooooob7oool00?oooolQoooo001loooo00<0003ooooo
ool08_ooo`030000oooooooo07coool007_oool00`000?ooooooo`08oooo00<0003oooooool06Ooo
o`030000oooooooo07_oool007_oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`07
oooo0P0000Coool200000oooo`@00003oooo00<0003oooooool0Noooo`00Noooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01Oooo`040000oooooooo00002?oo
o`030000oooooooo00Coool00`000?ooooooo`1koooo001joooo00<0003oooooool00_ooo`030000
oooooooo00goool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool0N_oo
o`00Noooo`030000oooooooo00D0000<oooo00@0003oooooool0000:oooo00<0003oooooool00_oo
o`030000oooooooo07_oool007_oool01@000?ooooooooooo`00000?oooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool0Noooo`00O?ooo`030000oooooooo017oool2
00002_ooo`800003oooo00<0003oooooool0O?ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.59832 .24721 L
.61984 .24721 L
.6298 .24721 L
.63527 .24721 L
.64043 .24721 L
.64524 .24721 L
.64656 .24721 L
.64728 .24721 L
.64796 .24721 L
s
.64796 .24721 m
.64814 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.33304 .24721 L
.33788 .24721 L
.34309 .24721 L
.34566 .24721 L
.34811 .24721 L
.34918 .24721 L
.35031 .24721 L
.35156 .37082 L
.35271 .37082 L
.36173 .37082 L
.3815 .37082 L
.39178 .37082 L
.39719 .37082 L
.40291 .37082 L
.40533 .37082 L
.40792 .37082 L
.40868 .37082 L
.40941 .37082 L
.41006 .37082 L
.41076 .24721 L
.41143 .24721 L
.41214 .24721 L
.41342 .24721 L
.42308 .24721 L
.46083 .24721 L
.50104 .24721 L
.53972 .24721 L
.58086 .24721 L
.62049 .24721 L
.65859 .24721 L
.69916 .24721 L
.7382 .24721 L
.7797 .24721 L
.81968 .24721 L
.85815 .24721 L
.89907 .24721 L
.93847 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool0
08ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool007coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002oooo`030000
oooooooo00;oool30000S_ooo`00MOooo`@00002oooo00@0003oooooool00009oooo0P0000Goool0
0`000?ooooooo`2>oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000
oooooooo08koool007coool200002_ooo`<00004oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool0
08ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>
oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo000Ioooo0`0003Soool40000=ooo
o`030000oooooooo03Ooool40000>oooo`<0000Eoooo000Joooo00<0003oooooool0=oooo`030000
oooooooo03Soool00`000?ooooooo`0goooo00<0003oooooool0?Oooo`030000oooooooo01Coool0
01Ooool50000>Oooo`030000oooooooo03Ooool00`000?ooooooo`0hoooo00<0003oooooool0>Ooo
o`D0000Eoooo000Aoooo100000;oool010000?ooooooo`0003?oool400001?ooo`030000oooooooo
03Koool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000oooooooo00005_ooo`006?oo
o`030000oooo000003Woool010000?ooooooo`0003Ooool20000>?ooo`040000oooooooo0000>_oo
o`030000oooo000001Koool001Woool20000>_ooo`80000hoooo00<0003oooooool0>?ooo`80000l
oooo0P0001Koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`04oooo00<0
I_ooooooool01Oooo`030000oooooooo00Coool00`1Vooooooooo`05oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool01?ooo`03o`2Ioooooooo
00Goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool006Woool00`1Vooooooooo`0<
oooo00<0I_ooooooool05?ooo`030000oooooooo02;oool00ol0VOooooooo`1Yoooo001Yoooo00<0
I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`0Roooo00?o09Woooooool0JOoo
o`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo00<0003oooooool08_ooo`03o`2I
oooooooo06Woool006Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo
02;oool00ol0VOooooooo`1Yoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool2
00008oooo`03o`2Ioooooooo06Woool006Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?oo
o`030000oooooooo02;oool00ol0VOooooooo`1Yoooo001Yoooo00<0I_ooooooool03?ooo`0306Ko
oooooooo01Coool00`000?ooooooo`0Roooo00?o09Woooooool0JOooo`00JOooo`0306Kooooooooo
00coool00`1Vooooooooo`0Doooo00<0003oooooool08_ooo`03o`2Ioooooooo06Woool006Woool0
0`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo02;oool00ol0VOooooooo`1Y
oooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`0Roooo00?o
09Woooooool0JOooo`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo0P0002?oool0
0ol0VOooooooo`1Yoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?oo
ooooo`0Roooo00?o09Woooooool0JOooo`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0D
oooo00<0003oooooool08_ooo`03o`2Ioooooooo06Woool006Woool00`1Vooooooooo`0<oooo00<0
I_ooooooool05?ooo`030000oooooooo02;oool00ol0VOooooooo`1Yoooo001Yoooo00<0I_oooooo
ool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`0Roooo00?o09Woooooool0JOooo`00JOoo
o`0306Kooooooooo00coool00`1Vooooooooo`0Doooo00<0003oooooool08_ooo`03o`2Ioooooooo
06Woool006Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo02;oool0
0ol0VOooooooo`1Yoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool200008ooo
o`03o`2Ioooooooo06Woool006Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000
oooooooo02;oool00ol0VOooooooo`1Yoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo
01Coool00`000?ooooooo`0Roooo00?o09Woooooool0JOooo`00JOooo`0306Kooooooooo00coool0
0`1Vooooooooo`0Doooo00<0003oooooool08_ooo`03o`2Ioooooooo06Woool006Woool00`1Voooo
ooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo02;oool00ol0VOooooooo`1Yoooo001Y
oooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`0Roooo00?o09Wooooo
ool0JOooo`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo0P0002?oool00ol0VOoo
ooooo`1Yoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`0R
oooo00?o09Woooooool0JOooo`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo00<0
003oooooool08_ooo`03o`2Ioooooooo06Woool006Woool00`1Vooooooooo`0<oooo00<0I_oooooo
ool05?ooo`030000oooooooo02;oool00ol0VOooooooo`1Yoooo001Yoooo00<0I_ooooooool03?oo
o`0406Kooooooooooooo0P0000Coool200001?ooo`800005oooo00<0003oooooool08_ooo`03o`2I
oooooooo06Woool006Woool00`1Vooooooooo`0<oooo00@0I_ooooooool00002oooo00<0003ooooo
ool01_ooo`040000oooooooo00001?ooo`030000oooooooo02;oool00ol0VOooooooo`1Yoooo001Y
oooo401Vo`;oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`0002;oool00ol0VOoo
ooooo`1Yoooo001koooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`0Roooo00?o
09Woooooool0JOooo`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?oo
ooooo`0Roooo00?o09Woooooool0JOooo`00O?ooo`80000:oooo0`0000Coool00`000?ooooooo`0R
oooo00?o09Woooooool0JOooo`00Soooo`030000oooooooo02;oool00ol0VOooooooo`1Yoooo002?
oooo00<0003oooooool08_ooo`03o`2Ioooooooo06Woool008ooool200008oooo`03o`2Ioooooooo
06Woool008ooool00`000?ooooooo`0Roooo00?o09Woooooool0JOooo`00Soooo`030000oooooooo
02;oool00ol0VOooooooo`1Yoooo002?oooo00<0003oooooool08_ooo`03o`2Ioooooooo06Woool0
08ooool00`000?ooooooo`0Roooo00?o09Woooooool0JOooo`00Soooo`030000oooooooo02;oool0
0ol0VOooooooo`1Yoooo002?oooo00<0003oooooool08_ooo`03o`2Ioooooooo06Woool008ooool2
00008oooo`03o`2Ioooooooo06Woool008ooool00`000?ooooooo`0Roooo00?o09Woooooool0JOoo
o`00Soooo`030000oooooooo02;oool00ol0VOooooooo`1Yoooo002?oooo00<0003oooooool08_oo
o`03o`2Ioooooooo06Woool008ooool00`000?ooooooo`0Soooo00?o09Woooooool0J?ooo`00Sooo
o`030000oooooooo02?oool00ol0VOooooooo`1Xoooo002?oooo0P0002Coool00ol0VOooooooo`1X
oooo002?oooo00<0003oooooool08oooo`03o`2Ioooooooo06Soool008ooool00`000?ooooooo`0S
oooo00?o09Woooooool0J?ooo`00Soooo`030000oooooooo02?oool00ol0VOooooooo`1Xoooo002?
oooo00<0003oooooool08oooo`03o`2Ioooooooo06Soool008ooool00`000?ooooooo`0Soooo00?o
09Woooooool0J?ooo`00Soooo`80000Toooo00?o09Woooooool0J?ooo`00Soooo`030000oooooooo
02?oool00ol0VOooooooo`1Xoooo002?oooo00<0003oooooool08oooo`03o`2Ioooooooo06Soool0
08ooool00`000?ooooooo`0Soooo00?o09Woooooool0J?ooo`00Qoooo`D00003oooo00<0003ooooo
ool08oooo`03o`2Ioooooooo06Soool008Woool00`000?ooooooo`03oooo00<0003oooooool08ooo
o`03o`2Ioooooooo06Soool008Woool00`000?ooooooo`03oooo0`0002?oool00ol0VOooooooo`1X
oooo0029oooo00<0003oooooool00oooo`030000oooooooo02?oool00ol0VOooooooo`1Xoooo0029
oooo00<0003oooooool00oooo`030000oooooooo02?oool00ol0VOooooooo`1Xoooo0028oooo0P00
00Goool00`000?ooooooo`0Soooo00?o09Woooooool0J?ooo`00Soooo`030000oooooooo02?oool0
0ol0VOooooooo`1Xoooo002?oooo00<0003oooooool08oooo`03o`2Ioooooooo06Soool008ooool0
0`000?ooooooo`0Soooo00?o09Woooooool0J?ooo`00Soooo`80000Toooo00?o09Woooooool0J?oo
o`00Soooo`030000oooooooo02?oool00ol0VOooooooo`1Xoooo002?oooo00<0003oooooool08ooo
o`03o`2Ioooooooo06Soool008ooool00`000?ooooooo`0Soooo00?o09Woooooool0J?ooo`00Sooo
o`030000oooooooo02?oool00ol0VOooooooo`1Xoooo002?oooo00<0003oooooool08oooo`03o`2I
oooooooo06Soool008ooool200009?ooo`03o`2Ioooooooo06Soool008ooool00`000?ooooooo`0S
oooo00?o09Woooooool0J?ooo`00Soooo`030000oooooooo02?oool00ol0VOooooooo`1Xoooo002?
oooo00<0003oooooool08oooo`03o`2Ioooooooo06Soool008ooool00`000?ooooooo`0Soooo00?o
09Woooooool0J?ooo`00Soooo`030000oooooooo02?oool00ol0VOooooooo`1Xoooo002?oooo0P00
02Coool00ol0VOooooooo`1Xoooo002?oooo00<0003oooooool08oooo`03o`2Ioooooooo06Soool0
08ooool00`000?ooooooo`0Soooo00?o09Woooooool0J?ooo`00Soooo`030000oooooooo02?oool0
0ol0VOooooooo`1Xoooo002?oooo00<0003oooooool08oooo`03o`2Ioooooooo06Soool008ooool0
0`000?ooooooo`0Soooo00?o09Woooooool0J?ooo`00Soooo`80000Toooo00?o09Woooooool0J?oo
o`00Soooo`030000oooooooo02?oool00ol0VOooooooo`1Xoooo002?oooo00<0003oooooool08ooo
o`03o`2Ioooooooo06Soool008ooool00`000?ooooooo`0Soooo00?o09Woooooool0J?ooo`00Sooo
o`030000oooooooo02?oool00ol0VOooooooo`1Xoooo001koooo1@0000;oool200001?ooo`800005
oooo00<0003oooooool08oooo`03o`2Ioooooooo06Soool007goool00`000?ooooooo`07oooo00@0
003oooooool00004oooo00<0003oooooool08oooo`03o`2Ioooooooo06Soool007goool00`000?oo
ooooo`0:oooo00<0003oooooool00_ooo`<0000Soooo00?o09Woooooool0J?ooo`00OOooo`030000
oooooooo00Soool20000U_ooo`00OOooo`030000oooooooo00Soool00`000?ooooooo`2Eoooo001l
oooo0P0000[oool30000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000
oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`07oooo0P00
00Coool200000oooo`@00003oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`05oooo00@0003oooooool00008
oooo00<0003oooooool00oooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool0
0`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo00002Oooo`030000oooooooo
00Goool00`000?ooooooo`02oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000<
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000000ooool010000?ooooooo`0000Soool010000?ooooooo`00
00?oool00`000?ooooooo`03oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo017oool2
00002_ooo`800004oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool0
0001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.0718, 0.0331289, 0.0159535}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.0718, 0.0331289, 0.0159535}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
.2 1 0 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
.97619 .24721 L
.02381 .24721 L
F
0 g
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.61984 .24721 L
.65954 .24721 L
.69774 .24721 L
.73838 .24721 L
.77751 .24721 L
.81909 .24721 L
.85916 .24721 L
.89771 .24721 L
.93871 .24721 L
.97619 .24721 L
s
1 0 .6 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.34309 .24721 L
.3815 .24721 L
.42237 .24721 L
.46172 .24721 L
.49955 .24721 L
.53984 .24721 L
.57861 .24721 L
.59832 .24721 L
.61984 .24721 L
.6298 .24721 L
.64043 .24721 L
.64559 .24721 L
.64812 .24721 L
.65045 .24721 L
.65258 .24721 L
.65365 .24721 L
s
.65365 .24721 m
.65382 .61803 L
s
0 .4 1 r
.02381 .24721 m
.06244 .24721 L
.10458 .24721 L
.14415 .24721 L
.18221 .24721 L
.22272 .24721 L
.26171 .24721 L
.30316 .24721 L
.32392 .24721 L
.33304 .24721 L
.33788 .24721 L
.34055 .24721 L
.34186 .24721 L
.34309 .24721 L
.34425 .24721 L
.34549 .37082 L
.3462 .37082 L
.34686 .37082 L
.34811 .37082 L
.35271 .37082 L
.36173 .37082 L
.3815 .37082 L
.39126 .37082 L
.40158 .37082 L
.41038 .37082 L
.4128 .37082 L
.41412 .37082 L
.41538 .37082 L
.41655 .37082 L
.41782 .24721 L
.41898 .24721 L
.42005 .24721 L
.45932 .24721 L
.49707 .24721 L
.53727 .24721 L
.57596 .24721 L
.6171 .24721 L
.65672 .24721 L
.69483 .24721 L
.73539 .24721 L
.77444 .24721 L
.81593 .24721 L
.85592 .24721 L
.89438 .24721 L
.9353 .24721 L
.9747 .24721 L
.97619 .24721 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.247214 0.247214 [
[.02381 .23471 -6 -9 ]
[.02381 .23471 6 0 ]
[.2619 .23471 -6 -9 ]
[.2619 .23471 6 0 ]
[.7381 .23471 -3 -9 ]
[.7381 .23471 3 0 ]
[.97619 .23471 -3 -9 ]
[.97619 .23471 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .12361 -24 -4.5 ]
[.4875 .12361 0 4.5 ]
[.4875 .37082 -18 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .24721 m
.02381 .25346 L
s
[(-4)] .02381 .23471 0 1 Mshowa
.2619 .24721 m
.2619 .25346 L
s
[(-2)] .2619 .23471 0 1 Mshowa
.7381 .24721 m
.7381 .25346 L
s
[(2)] .7381 .23471 0 1 Mshowa
.97619 .24721 m
.97619 .25346 L
s
[(4)] .97619 .23471 0 1 Mshowa
.125 Mabswid
.08333 .24721 m
.08333 .25096 L
s
.14286 .24721 m
.14286 .25096 L
s
.20238 .24721 m
.20238 .25096 L
s
.32143 .24721 m
.32143 .25096 L
s
.38095 .24721 m
.38095 .25096 L
s
.44048 .24721 m
.44048 .25096 L
s
.55952 .24721 m
.55952 .25096 L
s
.61905 .24721 m
.61905 .25096 L
s
.67857 .24721 m
.67857 .25096 L
s
.79762 .24721 m
.79762 .25096 L
s
.85714 .24721 m
.85714 .25096 L
s
.91667 .24721 m
.91667 .25096 L
s
.25 Mabswid
0 .24721 m
1 .24721 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .12361 m
.50625 .12361 L
s
[(-0.5)] .4875 .12361 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(0.5)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(1)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s