(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   4356719,     179364]*)
(*NotebookOutlinePosition[   4357399,     179387]*)
(*  CellTagsIndexPosition[   4357355,     179383]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING WITH A BOUND STATE", "Text",
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  ",
    FontSize->12],
  StyleBox["is located on the entire ",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["x",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox["-axis.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  \n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0, ",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" any real number, is in the nonhomogeneity and needs to be \
specified. \n\nThe potential   v[x], which is ",
    FontSize->12],
  StyleBox["the nonhomogeneity, is strictly negative. It corresponds to a \
reflectionless potential with one bound state of norming constant, c>0.\n\n\
The transmission coefficient, left reflection coefficient, and right \
reflection coefficient, respectively, are denoted by  T[k],  L[k],  R[k].\n\n\
The tail of the wave is denoted by  g[x,t].\n\nThe focusing moment is chosen \
as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(Clear[v, T, L, R, x0, g, c];\)\), "\[IndentingNewLine]", 
    \(\(v[
          x_] = \(-\ 
            16\)\ c^2\ E^\((2\ x)\)/\((2\ E^\((2\ x)\) + 
                  c^2)\)^2\ ;\)\), "\n", 
    \(\(T[k_] = \((k + I\ )\)/\((k - I)\);\)\), "\n", 
    \(\(L[k_] = 0;\)\), "\n", 
    \(\(R[k_] = 0;\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the focusing location  x0, any real number, and the norming \
constant c, a positive number, next:\
\>", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(\(c = 1\) \)\(;\)\(\ \)\(\(x0 = \(-1\)\) \)\(;\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(g[x_, t_] = 
        UnitStep[\(-x\) + x0 + 
              t]\ \((4\ c^2\ E^\((x + x0)\)\ \((E^t - 
                    E^\((\(-t\))\))\))\)/\((\((2\ E^\((2\ x)\) + 
                    c^2)\) \((2\ E^\((2\ x0)\) + c^2)\))\);\)\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-5\), \ 
              2.5}, \ PlotRange -> {\(-3\), 4}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]Plot[{10\ UnitStep[
                  x - x0 - t]}, \ {x, \ \(-5\), \ 2.5}, \ 
            PlotStyle\  \[Rule] \ Hue[0.9], \ 
            PlotRange -> {\(-3\), 4}], \ \[IndentingNewLine]Plot[{g[x, 
                t]}, \ {x, \ \(-5\), \ 2.5}, 
            PlotStyle\  \[Rule] \ 
              Hue[ .6], \ \ PlotRange -> {\(-3\), 
                4}]}, \ \[IndentingNewLine]{t, \ \(-3.8\), \ 2.2, 0.1}, 
        PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.03279 .26487 L
.04262 .26487 L
.04517 .26487 L
.04758 .26487 L
.04822 .26487 L
.04891 .26487 L
s
.04891 .26487 m
.04921 .61803 L
s
0 .4 1 r
.02381 .23409 m
.03279 .23184 L
.04262 .22918 L
.04517 .22846 L
.04758 .22776 L
.04822 .22757 L
.04891 .22737 L
.04966 .26487 L
.05035 .26487 L
.05288 .26487 L
.06244 .26487 L
.10458 .26487 L
.14241 .26487 L
.1827 .26487 L
.22147 .26487 L
.2627 .26487 L
.30241 .26487 L
.3406 .26487 L
.38125 .26487 L
.42038 .26487 L
.46196 .26487 L
.50202 .26487 L
.54057 .26487 L
.58158 .26487 L
.62107 .26487 L
.65904 .26487 L
.69946 .26487 L
.73837 .26487 L
.77973 .26487 L
.81958 .26487 L
.85791 .26487 L
.89869 .26487 L
.93795 .26487 L
.97571 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool01000001Vo`1Vo`1V
oaWoool500007_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0000co`0c
o`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Oooo`@00000
0oooo`1Vo`1Vo`02000000@0I_ooooooool0I_lCoooo100000;oool010000?ooooooo`0001Ooool4
00001Oooo`030000oooooooo01Coool400001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J
<ol000<0000co`0co`007C?o00040000<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000H
oooo00<0003oooooool00_ooo`0306Kooooooooo01Soool00`000?ooo`00000Moooo00@0003ooooo
ool0000Loooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o00030000<ol0<ol0
00<co`0300005_ooo`040000oooooooo00009_ooo`006?ooo`<00002oooo00<0I_ooooooool06Ooo
o`80000Noooo0P0001_oool500007S?o0080000L<ol000<0000co`0co`0073?o00800008<ol01000
01?oool200009oooo`007Oooo`0306Kooooooooo05Coool20000@C?o00030000<ol0<ol002Xco`03
0000>Oooo`007Oooo`0306Kooooooooo053oool40000@c?o0080000^<ol00P0003Ooool001goool0
0`1Vooooooooo`1;oooo1@0004Lco`000`0003?o03?o000_<ol0100003?oool001goool00`1Voooo
ooooo`11oooo2P0004`co`000`0003?o03?o000c<ol02P0002Woool001goool00`1Vooooooooo`0f
oooo2`0005Hco`000`0003?o03?o000m<ol03`0001[oool0013ooooo00004Oooo`005_ooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool04_ooo`005_ooo`030000oooooooo00Coool00ol0VOooooooo`0Foooo00<0
003oooooool07_ooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Ooo
o`030000oooooooo01goool00`000?ooooooo`0Noooo00<0003oooooool09Oooo`007Oooo`03o`2I
oooooooo09Ooool00`000?ooooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`030000oooooooo
06Koool001goool00ol0VOooooooo`2Goooo0P0006Ooool001goool00ol0VOooooooo`2Goooo00<0
003oooooool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool00`000?ooooooo`1Voooo000Moooo00?o
09Woooooool0Uoooo`030000oooooooo06Koool001goool00ol0VOooooooo`2Goooo0P0006Ooool0
01goool00ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool0
0`000?ooooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`030000oooooooo06Koool001goool0
0ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool20000Iooo
o`007Oooo`03o`2Ioooooooo09Ooool00`000?ooooooo`1Voooo000Moooo00?o09Woooooool0Uooo
o`030000oooooooo06Koool001goool00ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Ooo
o`03o`2Ioooooooo09Ooool20000Ioooo`007Oooo`03o`2Ioooooooo09Ooool00`000?ooooooo`1V
oooo000Moooo00?o09Woooooool0Uoooo`030000oooooooo06Koool001goool00ol0VOooooooo`2?
oooo1@0000?oool00`000?ooooooo`1Voooo000Moooo00?o09Woooooool0TOooo`030000oooooooo
00?oool00`000?ooooooo`1Voooo000Moooo00?o09Woooooool0TOooo`030000oooooooo00?oool3
0000I_ooo`007Oooo`03o`2Ioooooooo097oool00`000?ooooooo`03oooo00<0003oooooool0I_oo
o`007Oooo`03o`2Ioooooooo097oool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`007Ooo
o`03o`2Ioooooooo093oool200001Oooo`030000oooooooo06Koool001goool00ol0VOooooooo`2G
oooo0P0006Ooool001goool00ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2I
oooooooo09Ooool00`000?ooooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`030000oooooooo
06Koool001goool00ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo
09Ooool20000Ioooo`007Oooo`03o`2Ioooooooo09Ooool00`000?ooooooo`1Voooo000Moooo00?o
09Woooooool0Uoooo`030000oooooooo06Koool001goool00ol0VOooooooo`2Goooo00<0003ooooo
ool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool20000Ioooo`007Oooo`03o`2Ioooooooo09Ooool0
0`000?ooooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`030000oooooooo06Koool001goool0
0ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool00`000?oo
ooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`80001Woooo000Moooo00?o09Woooooool0Uooo
o`030000oooooooo06Koool001goool00ol0VOooooooo`2?oooo100000Coool00`000?ooooooo`1V
oooo000Moooo00?o09Woooooool0Soooo`030000oooooooo00Goool00`000?ooooooo`1Voooo000M
oooo00?o09Woooooool0T?ooo`030000oooooooo00Coool30000I_ooo`007Oooo`03o`2Ioooooooo
097oool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo08ooool0
10000?ooooooo`0000Coool00`000?ooooooo`1Voooo000Moooo00?o09Woooooool0T?ooo`800005
oooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool20000Ioooo`007Oooo`03o`2I
oooooooo09Ooool00`000?ooooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`030000oooooooo
06Koool001goool00ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo
09Ooool00`000?ooooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`80001Woooo000Moooo00?o
09Woooooool0Uoooo`030000oooooooo06Koool001goool00ol0VOooooooo`2Goooo00<0003ooooo
ool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool00`000?ooooooo`1Voooo000Moooo00?o09Wooooo
ool0Uoooo`80001Woooo000Moooo00?o09Woooooool0Uoooo`030000oooooooo06Koool001goool0
0ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool00`000?oo
ooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`030000oooooooo06Koool001goool00ol0VOoo
ooooo`2Goooo0P0006Ooool001goool00ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Ooo
o`03o`2Ioooooooo093oool200001Oooo`030000oooooooo06Koool001goool00ol0VOooooooo`2?
oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo097oool0
0`000?ooooooo`03oooo0`0006Koool001goool00ol0VOooooooo`2Boooo00<0003oooooool00_oo
o`030000oooooooo06Koool001goool00ol0VOooooooo`2?oooo00@0003oooooool00004oooo00<0
003oooooool0I_ooo`007Oooo`03o`2Ioooooooo093oool200001Oooo`030000oooooooo06Koool0
01goool00ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool2
0000Ioooo`007Oooo`03o`2Ioooooooo09Ooool00`000?ooooooo`1Voooo000Moooo00?o09Wooooo
ool0Uoooo`030000oooooooo06Koool001goool00ol0VOooooooo`2Goooo00<0003oooooool0I_oo
o`007Oooo`03o`2Ioooooooo09Ooool20000Ioooo`007Oooo`03o`2Ioooooooo09Ooool00`000?oo
ooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`030000oooooooo06Koool001goool00ol0VOoo
ooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2Ioooooooo09Ooool00`000?ooooooo`1V
oooo000Moooo00?o09Woooooool0Uoooo`80001Woooo000Moooo00?o09Woooooool0Uoooo`030000
oooooooo06Koool001goool00ol0VOooooooo`2Goooo00<0003oooooool0I_ooo`007Oooo`03o`2I
oooooooo09Ooool00`000?ooooooo`1Voooo000Moooo00?o09Woooooool0Uoooo`80001Woooo000M
oooo00?o09Woooooool0Uoooo`030000oooooooo06Koool001goool00ol0VOooooooo`2Goooo00<0
003oooooool0I_ooo`007Oooo`03o`2Ioooooooo097oool300000oooo`030000oooooooo06Koool0
01goool00ol0VOooooooo`2Boooo00<0003oooooool00_ooo`030000oooooooo06Koool001goool0
0ol0VOooooooo`2?oooo1@0000?oool30000I_ooo`00[oooo`040000oooooooo0000KOooo`00/?oo
o`030000oooo000006goool00;7oool20000KOooo`00ooooob7oool00?oooolQoooo001ioooo00<0
003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003ooooo
ool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`0=oooo0P0000Coool200001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`040000oooooooo00001?oo
o`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005Oooo`030000oooooooo00Ooool2
00001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo
01Ooool200002_ooo`800003oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.03279 .26487 L
.04262 .26487 L
.04758 .26487 L
.05288 .26487 L
.05546 .26487 L
.05789 .26487 L
.06007 .26487 L
.06131 .26487 L
s
.06131 .26487 m
.06176 .61803 L
s
0 .4 1 r
.02381 .23703 m
.03279 .23499 L
.04262 .23258 L
.04758 .2313 L
.05288 .22986 L
.05546 .22915 L
.05789 .22846 L
.06007 .22782 L
.06131 .22746 L
.06244 .26487 L
.06371 .26487 L
.06487 .26487 L
.06747 .26487 L
.07218 .26487 L
.0829 .26487 L
.10458 .26487 L
.14429 .26487 L
.18248 .26487 L
.22313 .26487 L
.26226 .26487 L
.30384 .26487 L
.34391 .26487 L
.38246 .26487 L
.42346 .26487 L
.46295 .26487 L
.50092 .26487 L
.54134 .26487 L
.58025 .26487 L
.62161 .26487 L
.66146 .26487 L
.69979 .26487 L
.74057 .26487 L
.77984 .26487 L
.81759 .26487 L
.85779 .26487 L
.89648 .26487 L
.93762 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool010000?oooooooooo
o`<0I_lFoooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000
<ol0<ol001Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool4
00000oooo`8000001?ooo`1Vo`1Vo`1Vo`;oool00`1Vooooooooo`0>oooo100000;oool010000?oo
ooooo`0001Ooool400001Oooo`030000oooooooo01Coool400001?ooo`<0000E<ol0100000@co`00
0`0003?o03?o000J<ol000<0000co`0co`007C?o00040000<ol0<ol0<ol00P0001_oool00`000?oo
ooooo`0Uoooo000Foooo0P1Vo`03000006Ko06Ko00Goool00`1Vooooooooo`0Eoooo00<0003oool0
00007Oooo`040000oooooooo00007?ooo`@0000N<ol000<0000co`0co`006S?o00030000<ol0<ol0
01dco`000`0003?o03?o0003<ol00`0001Koool010000?ooooooo`0002Koool001Soool300001Ooo
o`0306Kooooooooo01Koool200007_ooo`80000Koooo1@0001hco`02000073?o00030000<ol0<ol0
01`co`02000023?o00@0000Coooo0P0002Ooool0023oool00`1Vooooooooo`1Aoooo0P00044co`00
0`0003?o03?o000Z<ol00`0003Woool0023oool00`1Vooooooooo`1=oooo100004<co`020000;S?o
0080000goooo000Poooo00<0I_ooooooool0B?ooo`D00017<ol000<0000co`0co`00;c?o00@0000c
oooo000Poooo00<0I_ooooooool0?_ooo`X0001<<ol000<0000co`0co`00<c?o00X0000Yoooo000P
oooo00<0I_ooooooool0<oooo`/0001F<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00
017oool001Koool00`000?ooooooo`04oooo00@0003ooooooooo09T2oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool04_ooo`005_ooo`030000oooooooo00Ooool0
0ol0VOooooooo`0Coooo00<0003oooooool07_ooo`030000oooooooo01goool00`000?ooooooo`0M
oooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?ooooooo`0Noooo00<0003ooooo
ool09Oooo`008?ooo`03o`2Ioooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Wooooo
ool0U?ooo`030000oooooooo06Koool0023oool00ol0VOooooooo`2Doooo0P0006Ooool0023oool0
0ol0VOooooooo`2Doooo00<0003oooooool0I_ooo`008?ooo`03o`2Ioooooooo09Coool00`000?oo
ooooo`1Voooo000Poooo00?o09Woooooool0U?ooo`030000oooooooo06Koool0023oool00ol0VOoo
ooooo`2Doooo0P0006Ooool0023oool00ol0VOooooooo`2Doooo00<0003oooooool0I_ooo`008?oo
o`03o`2Ioooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0U?ooo`030000
oooooooo06Koool0023oool00ol0VOooooooo`2Doooo00<0003oooooool0I_ooo`008?ooo`03o`2I
oooooooo09Coool20000Ioooo`008?ooo`03o`2Ioooooooo09Coool00`000?ooooooo`1Voooo000P
oooo00?o09Woooooool0U?ooo`030000oooooooo06Koool0023oool00ol0VOooooooo`2Doooo00<0
003oooooool0I_ooo`008?ooo`03o`2Ioooooooo09Coool20000Ioooo`008?ooo`03o`2Ioooooooo
09Coool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0U?ooo`030000oooooooo06Koool0
023oool00ol0VOooooooo`2<oooo1@0000?oool00`000?ooooooo`1Voooo000Poooo00?o09Wooooo
ool0S_ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0S_oo
o`030000oooooooo00?oool30000I_ooo`008?ooo`03o`2Ioooooooo08koool00`000?ooooooo`03
oooo00<0003oooooool0I_ooo`008?ooo`03o`2Ioooooooo08koool00`000?ooooooo`03oooo00<0
003oooooool0I_ooo`008?ooo`03o`2Ioooooooo08goool200001Oooo`030000oooooooo06Koool0
023oool00ol0VOooooooo`2Doooo0P0006Ooool0023oool00ol0VOooooooo`2Doooo00<0003ooooo
ool0I_ooo`008?ooo`03o`2Ioooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Wooooo
ool0U?ooo`030000oooooooo06Koool0023oool00ol0VOooooooo`2Doooo00<0003oooooool0I_oo
o`008?ooo`03o`2Ioooooooo09Coool20000Ioooo`008?ooo`03o`2Ioooooooo09Coool00`000?oo
ooooo`1Voooo000Poooo00?o09Woooooool0U?ooo`030000oooooooo06Koool0023oool00ol0VOoo
ooooo`2Doooo00<0003oooooool0I_ooo`008?ooo`03o`2Ioooooooo09Coool20000Ioooo`008?oo
o`03o`2Ioooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0U?ooo`030000
oooooooo06Koool0023oool00ol0VOooooooo`2Doooo00<0003oooooool0I_ooo`008?ooo`03o`2I
oooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0U?ooo`80001Woooo000P
oooo00?o09Woooooool0U?ooo`030000oooooooo06Koool0023oool00ol0VOooooooo`2<oooo1000
00Coool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0S?ooo`030000oooooooo00Goool0
0`000?ooooooo`1Voooo000Poooo00?o09Woooooool0SOooo`030000oooooooo00Coool30000I_oo
o`008?ooo`03o`2Ioooooooo08koool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`008?oo
o`03o`2Ioooooooo08coool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo000Poooo00?o
09Woooooool0SOooo`800005oooo00<0003oooooool0I_ooo`008?ooo`03o`2Ioooooooo09Coool2
0000Ioooo`008?ooo`03o`2Ioooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Wooooo
ool0U?ooo`030000oooooooo06Koool0023oool00ol0VOooooooo`2Doooo00<0003oooooool0I_oo
o`008?ooo`03o`2Ioooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0U?oo
o`80001Woooo000Poooo00?o09Woooooool0U?ooo`030000oooooooo06Koool0023oool00ol0VOoo
ooooo`2Doooo00<0003oooooool0I_ooo`008?ooo`03o`2Ioooooooo09Coool00`000?ooooooo`1V
oooo000Poooo00?o09Woooooool0U?ooo`80001Woooo000Poooo00?o09Woooooool0U?ooo`030000
oooooooo06Koool0023oool00ol0VOooooooo`2Doooo00<0003oooooool0I_ooo`008?ooo`03o`2I
oooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0U?ooo`030000oooooooo
06Koool0023oool00ol0VOooooooo`2Doooo0P0006Ooool0023oool00ol0VOooooooo`2Doooo00<0
003oooooool0I_ooo`008?ooo`03o`2Ioooooooo08goool200001Oooo`030000oooooooo06Koool0
023oool00ol0VOooooooo`2<oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`008?oo
o`03o`2Ioooooooo08koool00`000?ooooooo`03oooo0`0006Koool0023oool00ol0VOooooooo`2?
oooo00<0003oooooool00_ooo`030000oooooooo06Koool0023oool00ol0VOooooooo`2<oooo00@0
003oooooool00004oooo00<0003oooooool0I_ooo`008?ooo`03o`2Ioooooooo08goool200001Ooo
o`030000oooooooo06Koool0023oool00ol0VOooooooo`2Doooo00<0003oooooool0I_ooo`008?oo
o`03o`2Ioooooooo09Coool20000Ioooo`008?ooo`03o`2Ioooooooo09Coool00`000?ooooooo`1V
oooo000Poooo00?o09Woooooool0U?ooo`030000oooooooo06Koool0023oool00ol0VOooooooo`2D
oooo00<0003oooooool0I_ooo`008?ooo`03o`2Ioooooooo09Coool20000Ioooo`008?ooo`03o`2I
oooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0U?ooo`030000oooooooo
06Koool0023oool00ol0VOooooooo`2Doooo00<0003oooooool0I_ooo`008?ooo`03o`2Ioooooooo
09Coool00`000?ooooooo`1Voooo000Poooo00?o09Woooooool0U?ooo`80001Woooo000Poooo00?o
09Woooooool0U?ooo`030000oooooooo06Koool0023oool00ol0VOooooooo`2Doooo00<0003ooooo
ool0I_ooo`008?ooo`03o`2Ioooooooo09Coool00`000?ooooooo`1Voooo000Poooo00?o09Wooooo
ool0U?ooo`80001Woooo000Poooo00?o09Woooooool0U?ooo`030000oooooooo06Koool0023oool0
0ol0VOooooooo`2Doooo00<0003oooooool0I_ooo`008?ooo`03o`2Ioooooooo08koool300000ooo
o`030000oooooooo06Koool0023oool00ol0VOooooooo`2?oooo00<0003oooooool00_ooo`030000
oooooooo06Koool0023oool00ol0VOooooooo`2<oooo1@0000?oool30000I_ooo`00[oooo`040000
oooooooo0000KOooo`00/?ooo`030000oooo000006goool00;7oool20000KOooo`00ooooob7oool0
0?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?oo
ooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02
oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001Oooo`030000oooooooo00;oool0
0`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`04oooo100000?oool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0
003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0003ooooo
ool02Oooo`030000oooooooo00?oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@00
01Goool00`000?ooooooo`09oooo00D0003oooooooooool00000N_ooo`00N?ooo`050000oooooooo
oooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1h
oooo001ioooo00<0003oooooool05oooo`800009oooo100000;oool00`000?ooooooo`1ioooo003o
oooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.04262 .26487 L
.06244 .26487 L
.06747 .26487 L
.07024 .26487 L
.0716 .26487 L
.07286 .26487 L
.07404 .26487 L
s
.07404 .26487 m
.07454 .61803 L
s
0 .4 1 r
.02381 .23968 m
.04262 .23566 L
.06244 .23072 L
.06747 .22934 L
.07024 .22856 L
.0716 .22817 L
.07286 .22781 L
.07404 .22746 L
.07529 .26487 L
.07655 .26487 L
.07793 .26487 L
.08255 .26487 L
.10458 .26487 L
.14487 .26487 L
.18364 .26487 L
.22486 .26487 L
.26457 .26487 L
.30277 .26487 L
.34341 .26487 L
.38254 .26487 L
.42412 .26487 L
.46419 .26487 L
.50274 .26487 L
.54374 .26487 L
.58323 .26487 L
.6212 .26487 L
.66163 .26487 L
.70054 .26487 L
.7419 .26487 L
.78174 .26487 L
.82007 .26487 L
.86085 .26487 L
.90012 .26487 L
.93787 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`04
oooo0`1Voa?oool500007_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0000Coool306Ko0_ooo`0306Kooooooooo00_oool400000_ooo`040000oooooooo
00005oooo`@00005oooo00<0003oooooool05?ooo`@00004oooo0`0001Dco`04000013?o00030000
<ol0<ol001Xco`000`0003?o03?o000M<ol000@0000co`0co`0co`0200006oooo`030000oooooooo
02Goool001Soool00`00001Vo`1Vo`0306Ko1Oooo`0306Kooooooooo01;oool00`000?ooo`00000M
oooo00@0003oooooool0000Loooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o
00030000<ol0<ol000<co`0300005_ooo`040000oooooooo00009_ooo`005_ooo`80I_l300002?oo
o`0306Kooooooooo01?oool200007_ooo`80000Koooo1@0001hco`02000073?o00030000<ol0<ol0
01`co`02000023?o00@0000Coooo0P0002Ooool002?oool00`1Vooooooooo`1>oooo0P00044co`00
0`0003?o03?o000Z<ol00`0003Woool002?oool00`1Vooooooooo`1:oooo100004<co`020000;S?o
0080000goooo000Soooo00<0I_ooooooool0AOooo`D00017<ol000<0000co`0co`00;c?o00@0000c
oooo000Soooo00<0I_ooooooool0>oooo`X0001<<ol000<0000co`0co`00<c?o00X0000Yoooo000S
oooo00<0I_ooooooool0<?ooo`/0001F<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00
017oool001Koool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo01;oool001Koool00`000?ooooooo`0:oooo00?o
09Woooooool04?ooo`030000oooooooo01koool00`000?ooooooo`0Moooo00<0003oooooool07Ooo
o`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo
02Goool002?oool00ol0VOooooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo
097oool00`000?ooooooo`1Voooo000Soooo00?o09Woooooool0TOooo`80001Woooo000Soooo00?o
09Woooooool0TOooo`030000oooooooo06Koool002?oool00ol0VOooooooo`2Aoooo00<0003ooooo
ool0I_ooo`008oooo`03o`2Ioooooooo097oool00`000?ooooooo`1Voooo000Soooo00?o09Wooooo
ool0TOooo`80001Woooo000Soooo00?o09Woooooool0TOooo`030000oooooooo06Koool002?oool0
0ol0VOooooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo097oool00`000?oo
ooooo`1Voooo000Soooo00?o09Woooooool0TOooo`030000oooooooo06Koool002?oool00ol0VOoo
ooooo`2Aoooo0P0006Ooool002?oool00ol0VOooooooo`2Aoooo00<0003oooooool0I_ooo`008ooo
o`03o`2Ioooooooo097oool00`000?ooooooo`1Voooo000Soooo00?o09Woooooool0TOooo`030000
oooooooo06Koool002?oool00ol0VOooooooo`2Aoooo0P0006Ooool002?oool00ol0VOooooooo`2A
oooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo097oool00`000?ooooooo`1Voooo000S
oooo00?o09Woooooool0ROooo`D00003oooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo
08_oool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo08_oool0
0`000?ooooooo`03oooo0`0006Koool002?oool00ol0VOooooooo`2;oooo00<0003oooooool00ooo
o`030000oooooooo06Koool002?oool00ol0VOooooooo`2;oooo00<0003oooooool00oooo`030000
oooooooo06Koool002?oool00ol0VOooooooo`2:oooo0P0000Goool00`000?ooooooo`1Voooo000S
oooo00?o09Woooooool0TOooo`80001Woooo000Soooo00?o09Woooooool0TOooo`030000oooooooo
06Koool002?oool00ol0VOooooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo
097oool00`000?ooooooo`1Voooo000Soooo00?o09Woooooool0TOooo`030000oooooooo06Koool0
02?oool00ol0VOooooooo`2Aoooo0P0006Ooool002?oool00ol0VOooooooo`2Aoooo00<0003ooooo
ool0I_ooo`008oooo`03o`2Ioooooooo097oool00`000?ooooooo`1Voooo000Soooo00?o09Wooooo
ool0TOooo`030000oooooooo06Koool002?oool00ol0VOooooooo`2Aoooo0P0006Ooool002?oool0
0ol0VOooooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo097oool00`000?oo
ooooo`1Voooo000Soooo00?o09Woooooool0TOooo`030000oooooooo06Koool002?oool00ol0VOoo
ooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo097oool20000Ioooo`008ooo
o`03o`2Ioooooooo097oool00`000?ooooooo`1Voooo000Soooo00?o09Woooooool0ROooo`@00004
oooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo08Woool00`000?ooooooo`05oooo00<0
003oooooool0I_ooo`008oooo`03o`2Ioooooooo08[oool00`000?ooooooo`04oooo0`0006Koool0
02?oool00ol0VOooooooo`2;oooo00<0003oooooool00oooo`030000oooooooo06Koool002?oool0
0ol0VOooooooo`29oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`008oooo`03o`2I
oooooooo08[oool200001Oooo`030000oooooooo06Koool002?oool00ol0VOooooooo`2Aoooo0P00
06Ooool002?oool00ol0VOooooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo
097oool00`000?ooooooo`1Voooo000Soooo00?o09Woooooool0TOooo`030000oooooooo06Koool0
02?oool00ol0VOooooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo097oool2
0000Ioooo`008oooo`03o`2Ioooooooo097oool00`000?ooooooo`1Voooo000Soooo00?o09Wooooo
ool0TOooo`030000oooooooo06Koool002?oool00ol0VOooooooo`2Aoooo00<0003oooooool0I_oo
o`008oooo`03o`2Ioooooooo097oool20000Ioooo`008oooo`03o`2Ioooooooo097oool00`000?oo
ooooo`1Voooo000Soooo00?o09Woooooool0TOooo`030000oooooooo06Koool002?oool00ol0VOoo
ooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo097oool00`000?ooooooo`1V
oooo000Soooo00?o09Woooooool0TOooo`80001Woooo000Soooo00?o09Woooooool0TOooo`030000
oooooooo06Koool002?oool00ol0VOooooooo`2:oooo0P0000Goool00`000?ooooooo`1Voooo000S
oooo00?o09Woooooool0ROooo`040000oooooooo00001?ooo`030000oooooooo06Koool002?oool0
0ol0VOooooooo`2;oooo00<0003oooooool00oooo`<0001Voooo000Soooo00?o09Woooooool0S?oo
o`030000oooooooo00;oool00`000?ooooooo`1Voooo000Soooo00?o09Woooooool0ROooo`040000
oooooooo00001?ooo`030000oooooooo06Koool002?oool00ol0VOooooooo`2:oooo0P0000Goool0
0`000?ooooooo`1Voooo000Soooo00?o09Woooooool0TOooo`030000oooooooo06Koool002?oool0
0ol0VOooooooo`2Aoooo0P0006Ooool002?oool00ol0VOooooooo`2Aoooo00<0003oooooool0I_oo
o`008oooo`03o`2Ioooooooo097oool00`000?ooooooo`1Voooo000Soooo00?o09Woooooool0TOoo
o`030000oooooooo06Koool002?oool00ol0VOooooooo`2Aoooo0P0006Ooool002?oool00ol0VOoo
ooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo097oool00`000?ooooooo`1V
oooo000Soooo00?o09Woooooool0TOooo`030000oooooooo06Koool002?oool00ol0VOooooooo`2A
oooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo097oool20000Ioooo`008oooo`03o`2I
oooooooo097oool00`000?ooooooo`1Voooo000Soooo00?o09Woooooool0TOooo`030000oooooooo
06Koool002?oool00ol0VOooooooo`2Aoooo00<0003oooooool0I_ooo`008oooo`03o`2Ioooooooo
097oool20000Ioooo`008oooo`03o`2Ioooooooo097oool00`000?ooooooo`1Voooo000Soooo00?o
09Woooooool0TOooo`030000oooooooo06Koool002?oool00ol0VOooooooo`2;oooo0`0000?oool0
0`000?ooooooo`1Voooo000Soooo00?o09Woooooool0S?ooo`030000oooooooo00;oool00`000?oo
ooooo`1Voooo000Soooo00?o09Woooooool0ROooo`D00003oooo0`0006Koool00:ooool010000?oo
ooooo`0006goool00;3oool00`000?ooo`00001]oooo002aoooo0P0006goool00?oooolQoooo003o
oooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003ooooo
ool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_oo
o`800004oooo00<0003oooooool03Oooo`800004oooo0P0000?oool300001?ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000oooooooo00Ooool0
10000?ooooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001Goool0
0`000?ooooooo`06oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00005Oooo`040000oooooooo00002Oooo`030000oooooooo00?oool00`000?ooooooo`1hoooo001i
oooo00<0003oooooool05oooo`80000:oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Ooo
o`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.04262 .26487 L
.06244 .26487 L
.07216 .26487 L
.0775 .26487 L
.08255 .26487 L
.08542 .26487 L
.0862 .26487 L
.08703 .26487 L
s
.08703 .26487 m
.08732 .61803 L
s
0 .4 1 r
.02381 .24208 m
.04262 .23844 L
.06244 .23398 L
.07216 .23152 L
.0775 .23009 L
.08255 .22868 L
.08542 .22785 L
.0862 .22763 L
.08703 .22738 L
.08774 .26487 L
.08852 .26487 L
.09396 .26487 L
.10458 .26487 L
.14487 .26487 L
.18364 .26487 L
.22486 .26487 L
.26457 .26487 L
.30277 .26487 L
.34341 .26487 L
.38254 .26487 L
.42412 .26487 L
.46419 .26487 L
.50274 .26487 L
.54374 .26487 L
.58323 .26487 L
.6212 .26487 L
.66163 .26487 L
.70054 .26487 L
.7419 .26487 L
.78174 .26487 L
.82007 .26487 L
.86085 .26487 L
.90012 .26487 L
.93787 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`07
oooo0`1Voa3oool500007_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0000Goool506Ko0_ooo`0306Kooooooooo00Soool400000_ooo`040000oooooooo
00005oooo`@00005oooo00<0003oooooool05?ooo`@00004oooo0`0001Dco`04000013?o00030000
<ol0<ol001Xco`000`0003?o03?o000M<ol000@0000co`0co`0co`0200006oooo`030000oooooooo
02Goool001Soool00`000?ooooooo`02oooo0P1Vo`Ooool00`1Vooooooooo`0?oooo00<0003oool0
00007Oooo`040000oooooooo00007?ooo`@0000N<ol000<0000co`0co`006S?o00030000<ol0<ol0
01dco`000`0003?o03?o0003<ol00`0001Koool010000?ooooooo`0002Koool001Koool206Ko0`00
0080I_l9oooo00<0I_ooooooool04?ooo`80000Noooo0P0001_oool500007S?o0080000L<ol000<0
000co`0co`0073?o00800008<ol0100001?oool200009oooo`009_ooo`0306Kooooooooo04_oool2
0000@C?o00030000<ol0<ol002Xco`030000>Oooo`009_ooo`0306Kooooooooo04Ooool40000@c?o
0080000^<ol00P0003Ooool002Koool00`1Vooooooooo`12oooo1@0004Lco`000`0003?o03?o000_
<ol0100003?oool002Koool00`1Vooooooooo`0hoooo2P0004`co`000`0003?o03?o000c<ol02P00
02Woool002Koool00`1Vooooooooo`0]oooo2`0005Hco`000`0003?o03?o000m<ol03`0001[oool0
013ooooo00004Oooo`005_ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00@0003ooooo
oooo09T3oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`0Boooo000Foooo00<0003ooooo
ool03Oooo`03o`2Ioooooooo00goool00`000?ooooooo`0Noooo00<0003oooooool07Oooo`030000
oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo01koool0
0`000?ooooooo`0Uoooo000Voooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool0
0ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool20000Iooo
o`009_ooo`03o`2Ioooooooo08koool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0S_oo
o`030000oooooooo06Koool002Koool00ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_oo
o`03o`2Ioooooooo08koool20000Ioooo`009_ooo`03o`2Ioooooooo08koool00`000?ooooooo`1V
oooo000Voooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool00ol0VOooooooo`2>
oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool00`000?ooooooo`1Voooo000V
oooo00?o09Woooooool0S_ooo`80001Woooo000Voooo00?o09Woooooool0S_ooo`030000oooooooo
06Koool002Koool00ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo
08koool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0S_ooo`80001Woooo000Voooo00?o
09Woooooool0S_ooo`030000oooooooo06Koool002Koool00ol0VOooooooo`2>oooo00<0003ooooo
ool0I_ooo`009_ooo`03o`2Ioooooooo08Koool500000oooo`030000oooooooo06Koool002Koool0
0ol0VOooooooo`28oooo00<0003oooooool00oooo`030000oooooooo06Koool002Koool00ol0VOoo
ooooo`28oooo00<0003oooooool00oooo`<0001Voooo000Voooo00?o09Woooooool0R?ooo`030000
oooooooo00?oool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0R?ooo`030000oooooooo
00?oool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0Qoooo`800005oooo00<0003ooooo
ool0I_ooo`009_ooo`03o`2Ioooooooo08koool20000Ioooo`009_ooo`03o`2Ioooooooo08koool0
0`000?ooooooo`1Voooo000Voooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool0
0ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool00`000?oo
ooooo`1Voooo000Voooo00?o09Woooooool0S_ooo`80001Woooo000Voooo00?o09Woooooool0S_oo
o`030000oooooooo06Koool002Koool00ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_oo
o`03o`2Ioooooooo08koool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0S_ooo`80001W
oooo000Voooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool00ol0VOooooooo`2>
oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool00`000?ooooooo`1Voooo000V
oooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool00ol0VOooooooo`2>oooo0P00
06Ooool002Koool00ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo
08Koool400001?ooo`030000oooooooo06Koool002Koool00ol0VOooooooo`26oooo00<0003ooooo
ool01Oooo`030000oooooooo06Koool002Koool00ol0VOooooooo`27oooo00<0003oooooool01?oo
o`<0001Voooo000Voooo00?o09Woooooool0R?ooo`030000oooooooo00?oool00`000?ooooooo`1V
oooo000Voooo00?o09Woooooool0Q_ooo`040000oooooooo00001?ooo`030000oooooooo06Koool0
02Koool00ol0VOooooooo`27oooo0P0000Goool00`000?ooooooo`1Voooo000Voooo00?o09Wooooo
ool0S_ooo`80001Woooo000Voooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool0
0ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool00`000?oo
ooooo`1Voooo000Voooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool00ol0VOoo
ooooo`2>oooo0P0006Ooool002Koool00ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_oo
o`03o`2Ioooooooo08koool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0S_ooo`030000
oooooooo06Koool002Koool00ol0VOooooooo`2>oooo0P0006Ooool002Koool00ol0VOooooooo`2>
oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool00`000?ooooooo`1Voooo000V
oooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool00ol0VOooooooo`2>oooo00<0
003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool20000Ioooo`009_ooo`03o`2Ioooooooo
08koool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0Qoooo`800005oooo00<0003ooooo
ool0I_ooo`009_ooo`03o`2Ioooooooo08Koool010000?ooooooo`0000Coool00`000?ooooooo`1V
oooo000Voooo00?o09Woooooool0R?ooo`030000oooooooo00?oool30000I_ooo`009_ooo`03o`2I
oooooooo08Woool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo
08Koool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0Qooo
o`800005oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool00`000?ooooooo`1V
oooo000Voooo00?o09Woooooool0S_ooo`80001Woooo000Voooo00?o09Woooooool0S_ooo`030000
oooooooo06Koool002Koool00ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_ooo`03o`2I
oooooooo08koool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0S_ooo`80001Woooo000V
oooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool00ol0VOooooooo`2>oooo00<0
003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool00`000?ooooooo`1Voooo000Voooo00?o
09Woooooool0S_ooo`030000oooooooo06Koool002Koool00ol0VOooooooo`2>oooo0P0006Ooool0
02Koool00ol0VOooooooo`2>oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08koool0
0`000?ooooooo`1Voooo000Voooo00?o09Woooooool0S_ooo`030000oooooooo06Koool002Koool0
0ol0VOooooooo`2>oooo0P0006Ooool002Koool00ol0VOooooooo`2>oooo00<0003oooooool0I_oo
o`009_ooo`03o`2Ioooooooo08koool00`000?ooooooo`1Voooo000Voooo00?o09Woooooool0R?oo
o`<00003oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08Woool00`000?ooooooo`02
oooo00<0003oooooool0I_ooo`009_ooo`03o`2Ioooooooo08Koool500000oooo`<0001Voooo002_
oooo00@0003oooooool0001]oooo002`oooo00<0003oool00000KOooo`00/Oooo`80001]oooo003o
oooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?oo
o`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000Coool0
0`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?oo
ooooo`0:oooo00<0003oooooool00_ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`05
00005Oooo`030000oooooooo00Ooool200001?ooo`030000oooooooo07Soool007Soool01@000?oo
ooooooooo`00000Eoooo00@0003oooooool00009oooo00<0003oooooool00oooo`030000oooooooo
07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool300000_ooo`030000oooooooo07Woool0
0?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.04262 .26487 L
.06244 .26487 L
.08255 .26487 L
.08806 .26487 L
.09396 .26487 L
.09682 .26487 L
.09822 .26487 L
.09952 .26487 L
s
.09952 .26487 m
.09999 .61803 L
s
0 .4 1 r
.02381 .24425 m
.04262 .24096 L
.06244 .23692 L
.08255 .23213 L
.08806 .23068 L
.09396 .22906 L
.09682 .22824 L
.09822 .22783 L
.09952 .22745 L
.1007 .26487 L
.10195 .26487 L
.10458 .26487 L
.14241 .26487 L
.1827 .26487 L
.22147 .26487 L
.2627 .26487 L
.30241 .26487 L
.3406 .26487 L
.38125 .26487 L
.42038 .26487 L
.46196 .26487 L
.50202 .26487 L
.54057 .26487 L
.58158 .26487 L
.62107 .26487 L
.65904 .26487 L
.69946 .26487 L
.73837 .26487 L
.77973 .26487 L
.81958 .26487 L
.85791 .26487 L
.89869 .26487 L
.93795 .26487 L
.97571 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0;
oooo0P1Vo`goool500007_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0000Woool506Ko00?oool0I_ooool01_ooo`@00002oooo00@0003oooooool0000G
oooo100000Goool00`000?ooooooo`0Doooo100000Coool300005C?o00@00004<ol000<0000co`0c
o`006S?o00030000<ol0<ol001dco`00100003?o03?o03?o0080000Koooo00<0003oooooool09Ooo
o`006?ooo`030000oooooooo00?oool506Ko1_ooo`0306Kooooooooo00coool00`000?ooo`00000M
oooo00@0003oooooool0000Loooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o
00030000<ol0<ol000<co`0300005_ooo`040000oooooooo00009_ooo`006?ooo`<0000306Ko2ooo
o`0306Kooooooooo00goool200007_ooo`80000Koooo1@0001hco`02000073?o00030000<ol0<ol0
01`co`02000023?o00@0000Coooo0P0002Ooool001Koool306Ko4?ooo`0306Kooooooooo04Soool2
0000@C?o00030000<ol0<ol002Xco`030000>Oooo`00:_ooo`0306Kooooooooo04?oool40000@c?o
0080000^<ol00P0003Ooool002[oool00`1Vooooooooo`0noooo1@0004Lco`000`0003?o03?o000_
<ol0100003?oool002[oool00`1Vooooooooo`0doooo2P0004`co`000`0003?o03?o000c<ol02P00
02Woool002[oool00`1Vooooooooo`0Yoooo2`0005Hco`000`0003?o03?o000m<ol03`0001[oool0
013ooooo00004Oooo`005_ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`03o`2I0000oooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool04_ooo`005_ooo`030000oooooooo
013oool00ol0VOooooooo`0:oooo00<0003oooooool07_ooo`030000oooooooo01goool00`000?oo
ooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?ooooooo`0Noooo00<0
003oooooool09Oooo`00:Oooo`03o`2Ioooooooo08_oool00`000?ooooooo`1Voooo000Yoooo00?o
09Woooooool0Roooo`030000oooooooo06Koool002Woool00ol0VOooooooo`2;oooo0P0006Ooool0
02Woool00ol0VOooooooo`2;oooo00<0003oooooool0I_ooo`00:Oooo`03o`2Ioooooooo08_oool0
0`000?ooooooo`1Voooo000Yoooo00?o09Woooooool0Roooo`030000oooooooo06Koool002Woool0
0ol0VOooooooo`2;oooo0P0006Ooool002Woool00ol0VOooooooo`2;oooo00<0003oooooool0I_oo
o`00:Oooo`03o`2Ioooooooo08_oool00`000?ooooooo`1Voooo000Yoooo00?o09Woooooool0Rooo
o`030000oooooooo06Koool002Woool00ol0VOooooooo`2;oooo00<0003oooooool0I_ooo`00:Ooo
o`03o`2Ioooooooo08_oool20000Ioooo`00:Oooo`03o`2Ioooooooo08_oool00`000?ooooooo`1V
oooo000Yoooo00?o09Woooooool0Roooo`030000oooooooo06Koool002Woool00ol0VOooooooo`2;
oooo00<0003oooooool0I_ooo`00:Oooo`03o`2Ioooooooo08_oool20000Ioooo`00:Oooo`03o`2I
oooooooo08_oool00`000?ooooooo`1Voooo000Yoooo00?o09Woooooool0Roooo`030000oooooooo
06Koool002Woool00ol0VOooooooo`23oooo1@0000?oool00`000?ooooooo`1Voooo000Yoooo00?o
09Woooooool0QOooo`030000oooooooo00?oool00`000?ooooooo`1Voooo000Yoooo00?o09Wooooo
ool0QOooo`030000oooooooo00?oool30000I_ooo`00:Oooo`03o`2Ioooooooo08Goool00`000?oo
ooooo`03oooo00<0003oooooool0I_ooo`00:Oooo`03o`2Ioooooooo08Goool00`000?ooooooo`03
oooo00<0003oooooool0I_ooo`00:Oooo`03o`2Ioooooooo08Coool200001Oooo`030000oooooooo
06Koool002Woool00ol0VOooooooo`2;oooo0P0006Ooool002Woool00ol0VOooooooo`2;oooo00<0
003oooooool0I_ooo`00:Oooo`03o`2Ioooooooo08_oool00`000?ooooooo`1Voooo000Yoooo00?o
09Woooooool0Roooo`030000oooooooo06Koool002Woool00ol0VOooooooo`2;oooo00<0003ooooo
ool0I_ooo`00:Oooo`03o`2Ioooooooo08_oool20000Ioooo`00:Oooo`03o`2Ioooooooo08_oool0
0`000?ooooooo`1Voooo000Yoooo00?o09Woooooool0Roooo`030000oooooooo06Koool002Woool0
0ol0VOooooooo`2;oooo00<0003oooooool0I_ooo`00:Oooo`03o`2Ioooooooo08_oool20000Iooo
o`00:Oooo`03o`2Ioooooooo08_oool00`000?ooooooo`1Voooo000Yoooo00?o09Woooooool0Rooo
o`030000oooooooo06Koool002Woool00ol0VOooooooo`2;oooo00<0003oooooool0I_ooo`00:Ooo
o`03o`2Ioooooooo08_oool00`000?ooooooo`1Voooo000Yoooo00?o09Woooooool0Roooo`80001W
oooo000Yoooo00?o09Woooooool0Roooo`030000oooooooo06Koool002Woool00ol0VOooooooo`23
oooo100000Coool00`000?ooooooo`1Voooo000Yoooo00?o09Woooooool0Poooo`030000oooooooo
00Goool00`000?ooooooo`1Voooo000Yoooo00?o09Woooooool0Q?ooo`030000oooooooo00Coool3
0000I_ooo`00:_ooo`03o`2Ioooooooo08Coool00`000?ooooooo`03oooo00<0003oooooool0I_oo
o`00:_ooo`03o`2Ioooooooo08;oool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo000Z
oooo00?o09Woooooool0Poooo`800005oooo00<0003oooooool0I_ooo`00:_ooo`03o`2Ioooooooo
08[oool20000Ioooo`00:_ooo`03o`2Ioooooooo08[oool00`000?ooooooo`1Voooo000Zoooo00?o
09Woooooool0R_ooo`030000oooooooo06Koool002[oool00ol0VOooooooo`2:oooo00<0003ooooo
ool0I_ooo`00:_ooo`03o`2Ioooooooo08[oool00`000?ooooooo`1Voooo000Zoooo00?o09Wooooo
ool0R_ooo`80001Woooo000Zoooo00?o09Woooooool0R_ooo`030000oooooooo06Koool002[oool0
0ol0VOooooooo`2:oooo00<0003oooooool0I_ooo`00:_ooo`03o`2Ioooooooo08[oool00`000?oo
ooooo`1Voooo000Zoooo00?o09Woooooool0R_ooo`80001Woooo000Zoooo00?o09Woooooool0R_oo
o`030000oooooooo06Koool002[oool00ol0VOooooooo`2:oooo00<0003oooooool0I_ooo`00:_oo
o`03o`2Ioooooooo08[oool00`000?ooooooo`1Voooo000Zoooo00?o09Woooooool0R_ooo`030000
oooooooo06Koool002[oool00ol0VOooooooo`2:oooo0P0006Ooool002[oool00ol0VOooooooo`2:
oooo00<0003oooooool0I_ooo`00:_ooo`03o`2Ioooooooo08?oool200001Oooo`030000oooooooo
06Koool002[oool00ol0VOooooooo`22oooo00@0003oooooool00004oooo00<0003oooooool0I_oo
o`00:_ooo`03o`2Ioooooooo08Coool00`000?ooooooo`03oooo0`0006Koool002[oool00ol0VOoo
ooooo`25oooo00<0003oooooool00_ooo`030000oooooooo06Koool002[oool00ol0VOooooooo`22
oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00:_ooo`03o`2Ioooooooo08?oool2
00001Oooo`030000oooooooo06Koool002[oool00ol0VOooooooo`2:oooo00<0003oooooool0I_oo
o`00:_ooo`03o`2Ioooooooo08[oool20000Ioooo`00:_ooo`03o`2Ioooooooo08[oool00`000?oo
ooooo`1Voooo000Zoooo00?o09Woooooool0R_ooo`030000oooooooo06Koool002[oool00ol0VOoo
ooooo`2:oooo00<0003oooooool0I_ooo`00:_ooo`03o`2Ioooooooo08[oool20000Ioooo`00:_oo
o`03o`2Ioooooooo08[oool00`000?ooooooo`1Voooo000Zoooo00?o09Woooooool0R_ooo`030000
oooooooo06Koool002[oool00ol0VOooooooo`2:oooo00<0003oooooool0I_ooo`00:_ooo`03o`2I
oooooooo08[oool00`000?ooooooo`1Voooo000Zoooo00?o09Woooooool0R_ooo`80001Woooo000Z
oooo00?o09Woooooool0R_ooo`030000oooooooo06Koool002[oool00ol0VOooooooo`2:oooo00<0
003oooooool0I_ooo`00:_ooo`03o`2Ioooooooo08[oool00`000?ooooooo`1Voooo000Zoooo00?o
09Woooooool0R_ooo`80001Woooo000Zoooo00?o09Woooooool0R_ooo`030000oooooooo06Koool0
02[oool00ol0VOooooooo`2:oooo00<0003oooooool0I_ooo`00:_ooo`03o`2Ioooooooo08Coool3
00000oooo`030000oooooooo06Koool002[oool00ol0VOooooooo`25oooo00<0003oooooool00_oo
o`030000oooooooo06Koool002[oool00ol0VOooooooo`22oooo1@0000?oool30000I_ooo`00[ooo
o`040000oooooooo0000KOooo`00/?ooo`030000oooo000006goool00;7oool20000KOooo`00oooo
ob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool0
0`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?oo
ooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001Oooo`<00002oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool01?ooo`@00003oooo00@0003oooooool0000;oooo00D0003oooooooooool00000N_oo
o`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`D00003
oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Eoooo00<0003oooooool01_oo
o`040000oooooooo00000oooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000E
oooo00@0003oooooool00009oooo00<0003oool000000oooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Goooo0P0000_oool200000_ooo`030000oooooooo07Woool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.08255 .26487 L
.0932 .26487 L
.09905 .26487 L
.10458 .26487 L
.10972 .26487 L
.11113 .26487 L
.1119 .26487 L
.11263 .26487 L
s
.11263 .26487 m
.11314 .61803 L
s
0 .4 1 r
.02381 .24622 m
.06244 .23959 L
.08255 .23525 L
.0932 .23267 L
.09905 .23115 L
.10458 .22965 L
.10972 .22819 L
.11113 .22778 L
.1119 .22756 L
.11263 .22734 L
.1139 .26487 L
.11458 .26487 L
.11531 .26487 L
.12507 .26487 L
.14415 .26487 L
.18538 .26487 L
.22508 .26487 L
.26328 .26487 L
.30392 .26487 L
.34305 .26487 L
.38463 .26487 L
.4247 .26487 L
.46325 .26487 L
.50426 .26487 L
.54374 .26487 L
.58171 .26487 L
.62214 .26487 L
.66105 .26487 L
.70241 .26487 L
.74225 .26487 L
.78058 .26487 L
.82137 .26487 L
.86063 .26487 L
.89838 .26487 L
.93859 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0>
oooo0`1Vo`Woool500007_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0000goool406Ko0_ooo`0406Kooooooooooooo100000;oool010000?ooooooo`00
01Ooool400001Oooo`030000oooooooo01Coool400001?ooo`<0000E<ol0100000@co`000`0003?o
03?o000J<ol000<0000co`0co`007C?o00040000<ol0<ol0<ol00P0001_oool00`000?ooooooo`0U
oooo000Hoooo00<0003oooooool02?ooo`@0I_l6oooo00<0I_ooooooool02?ooo`030000oooo0000
01goool010000?ooooooo`0001coool400007S?o00030000<ol0<ol001Xco`000`0003?o03?o000M
<ol000<0000co`0co`000c?o00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`000003oooo
06Ko06Ko00D0I_l:oooo00<0I_ooooooool02Oooo`80000Noooo0P0001_oool500007S?o0080000L
<ol000<0000co`0co`0073?o00800008<ol0100001?oool200009oooo`005_ooo`H0I_lAoooo00<0
I_ooooooool0A?ooo`800011<ol000<0000co`0co`00:S?o00<0000ioooo000]oooo00<0I_oooooo
ool0@?ooo`@00013<ol00P0002hco`020000=oooo`00;Oooo`0306Kooooooooo03_oool50000Ac?o
00030000<ol0<ol002lco`040000<oooo`00;Oooo`0306Kooooooooo037oool:0000C3?o00030000
<ol0<ol003<co`0:0000:Oooo`00;Oooo`0306Kooooooooo02Koool;0000ES?o00030000<ol0<ol0
03dco`0?00006_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00@0003ooooooooo09T2oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo01;oool0
01Koool00`000?ooooooo`0Doooo00?o09Woooooool01_ooo`030000oooooooo01koool00`000?oo
ooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0
003oooooool07_ooo`030000oooooooo02Goool002goool00ol0VOooooooo`27oooo00<0003ooooo
ool0I_ooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?ooooooo`1Voooo000]oooo00?o09Wooooo
ool0Qoooo`80001Woooo000]oooo00?o09Woooooool0Qoooo`030000oooooooo06Koool002goool0
0ol0VOooooooo`27oooo00<0003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?oo
ooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`80001Woooo000]oooo00?o09Woooooool0Qooo
o`030000oooooooo06Koool002goool00ol0VOooooooo`27oooo00<0003oooooool0I_ooo`00;Ooo
o`03o`2Ioooooooo08Ooool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`030000
oooooooo06Koool002goool00ol0VOooooooo`27oooo0P0006Ooool002goool00ol0VOooooooo`27
oooo00<0003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?ooooooo`1Voooo000]
oooo00?o09Woooooool0Qoooo`030000oooooooo06Koool002goool00ol0VOooooooo`27oooo0P00
06Ooool002goool00ol0VOooooooo`27oooo00<0003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo
08Ooool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Ooooo`D00003oooo00<0003ooooo
ool0I_ooo`00;Oooo`03o`2Ioooooooo087oool00`000?ooooooo`03oooo00<0003oooooool0I_oo
o`00;Oooo`03o`2Ioooooooo087oool00`000?ooooooo`03oooo0`0006Koool002goool00ol0VOoo
ooooo`21oooo00<0003oooooool00oooo`030000oooooooo06Koool002goool00ol0VOooooooo`21
oooo00<0003oooooool00oooo`030000oooooooo06Koool002goool00ol0VOooooooo`20oooo0P00
00Goool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`80001Woooo000]oooo00?o
09Woooooool0Qoooo`030000oooooooo06Koool002goool00ol0VOooooooo`27oooo00<0003ooooo
ool0I_ooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?ooooooo`1Voooo000]oooo00?o09Wooooo
ool0Qoooo`030000oooooooo06Koool002goool00ol0VOooooooo`27oooo0P0006Ooool002goool0
0ol0VOooooooo`27oooo00<0003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?oo
ooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`030000oooooooo06Koool002goool00ol0VOoo
ooooo`27oooo0P0006Ooool002goool00ol0VOooooooo`27oooo00<0003oooooool0I_ooo`00;Ooo
o`03o`2Ioooooooo08Ooool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`030000
oooooooo06Koool002goool00ol0VOooooooo`27oooo00<0003oooooool0I_ooo`00;Oooo`03o`2I
oooooooo08Ooool20000Ioooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?ooooooo`1Voooo000]
oooo00?o09Woooooool0Ooooo`@00004oooo00<0003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo
07ooool00`000?ooooooo`05oooo00<0003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo083oool0
0`000?ooooooo`04oooo0`0006Koool002goool00ol0VOooooooo`21oooo00<0003oooooool00ooo
o`030000oooooooo06Koool002goool00ol0VOooooooo`1ooooo00@0003oooooool00004oooo00<0
003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo083oool200001Oooo`030000oooooooo06Koool0
02goool00ol0VOooooooo`27oooo0P0006Ooool002goool00ol0VOooooooo`27oooo00<0003ooooo
ool0I_ooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?ooooooo`1Voooo000]oooo00?o09Wooooo
ool0Qoooo`030000oooooooo06Koool002goool00ol0VOooooooo`27oooo00<0003oooooool0I_oo
o`00;Oooo`03o`2Ioooooooo08Ooool20000Ioooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?oo
ooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`030000oooooooo06Koool002goool00ol0VOoo
ooooo`27oooo00<0003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo08Ooool20000Ioooo`00;Ooo
o`03o`2Ioooooooo08Ooool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`030000
oooooooo06Koool002goool00ol0VOooooooo`27oooo00<0003oooooool0I_ooo`00;Oooo`03o`2I
oooooooo08Ooool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`80001Woooo000]
oooo00?o09Woooooool0Qoooo`030000oooooooo06Koool002goool00ol0VOooooooo`20oooo0P00
00Goool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Ooooo`040000oooooooo00001?oo
o`030000oooooooo06Koool002goool00ol0VOooooooo`21oooo00<0003oooooool00oooo`<0001V
oooo000]oooo00?o09Woooooool0P_ooo`030000oooooooo00;oool00`000?ooooooo`1Voooo000]
oooo00?o09Woooooool0Ooooo`040000oooooooo00001?ooo`030000oooooooo06Koool002goool0
0ol0VOooooooo`20oooo0P0000Goool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Qooo
o`030000oooooooo06Koool002goool00ol0VOooooooo`27oooo0P0006Ooool002goool00ol0VOoo
ooooo`27oooo00<0003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?ooooooo`1V
oooo000]oooo00?o09Woooooool0Qoooo`030000oooooooo06Koool002goool00ol0VOooooooo`27
oooo0P0006Ooool002goool00ol0VOooooooo`27oooo00<0003oooooool0I_ooo`00;Oooo`03o`2I
oooooooo08Ooool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`030000oooooooo
06Koool002goool00ol0VOooooooo`27oooo00<0003oooooool0I_ooo`00;Oooo`03o`2Ioooooooo
08Ooool20000Ioooo`00;Oooo`03o`2Ioooooooo08Ooool00`000?ooooooo`1Voooo000]oooo00?o
09Woooooool0Qoooo`030000oooooooo06Koool002goool00ol0VOooooooo`27oooo00<0003ooooo
ool0I_ooo`00;Oooo`03o`2Ioooooooo08Ooool20000Ioooo`00;Oooo`03o`2Ioooooooo08Ooool0
0`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Qoooo`030000oooooooo06Koool002goool0
0ol0VOooooooo`21oooo0`0000?oool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0P_oo
o`030000oooooooo00;oool00`000?ooooooo`1Voooo000]oooo00?o09Woooooool0Ooooo`D00003
oooo0`0006Koool00:ooool010000?ooooooo`0006goool00;3oool00`000?ooo`00001]oooo002a
oooo0P0006goool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?oo
ooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1h
oooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P00
00Coool200001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000
oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003ooooo
ool05Oooo`030000oooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0Moooo`00N?oo
o`030000oooooooo00D0000Eoooo00<0003oooooool02Oooo`050000oooooooooooo000007[oool0
07Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003oooo00<0
003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.08255 .26487 L
.10458 .26487 L
.11448 .26487 L
.11992 .26487 L
.1226 .26487 L
.12377 .26487 L
.12507 .26487 L
s
.12507 .26487 m
.12555 .61803 L
s
0 .4 1 r
.02381 .248 m
.06244 .242 L
.08255 .23808 L
.10458 .23301 L
.11448 .23043 L
.11992 .22892 L
.1226 .22815 L
.12377 .22781 L
.12507 .22743 L
.12627 .26487 L
.12739 .26487 L
.12986 .26487 L
.13506 .26487 L
.14415 .26487 L
.18292 .26487 L
.22415 .26487 L
.26386 .26487 L
.30205 .26487 L
.34269 .26487 L
.38182 .26487 L
.42341 .26487 L
.46347 .26487 L
.50202 .26487 L
.54303 .26487 L
.58251 .26487 L
.62049 .26487 L
.66091 .26487 L
.69982 .26487 L
.74118 .26487 L
.78103 .26487 L
.81936 .26487 L
.86014 .26487 L
.8994 .26487 L
.93715 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0@
oooo101Vo`Koool500007_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0000ooool406Ko0oooo`0306Ko0000000000800002oooo00@0003oooooool0000G
oooo100000Goool00`000?ooooooo`0Doooo100000Coool300005C?o00@00004<ol000<0000co`0c
o`006S?o00030000<ol0<ol001dco`00100003?o03?o03?o0080000Koooo00<0003oooooool09Ooo
o`006?ooo`030000oooooooo00Soool606Ko1oooo`0306Kooooooooo00Goool00`000?ooo`00000M
oooo00@0003oooooool0000Loooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o
00030000<ol0<ol000<co`0300005_ooo`040000oooooooo00009_ooo`006?ooo`<00003oooo1@1V
o`goool00`1Vooooooooo`06oooo0P0001koool200006oooo`D0000N<ol00P0001`co`000`0003?o
03?o000L<ol00P0000Pco`0400004oooo`80000Woooo000Ioooo1@1Voa;oool00`1Vooooooooo`11
oooo0P00044co`000`0003?o03?o000Z<ol00`0003Woool001Koool306Ko5oooo`0306Kooooooooo
03goool40000@c?o0080000^<ol00P0003Ooool0033oool00`1Vooooooooo`0hoooo1@0004Lco`00
0`0003?o03?o000_<ol0100003?oool0033oool00`1Vooooooooo`0^oooo2P0004`co`000`0003?o
03?o000c<ol02P0002Woool0033oool00`1Vooooooooo`0Soooo2`0005Hco`000`0003?o03?o000m
<ol03`0001[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool04_ooo`005_oo
o`030000oooooooo01Ooool00ol0VOooooooo`03oooo00<0003oooooool07_ooo`030000oooooooo
01goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?oo
ooooo`0Noooo00<0003oooooool09Oooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1V
oooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo06Koool0033oool00ol0VOooooooo`24
oooo0P0006Ooool0033oool00ol0VOooooooo`24oooo00<0003oooooool0I_ooo`00<?ooo`03o`2I
oooooooo08Coool00`000?ooooooo`1Voooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo
06Koool0033oool00ol0VOooooooo`24oooo0P0006Ooool0033oool00ol0VOooooooo`24oooo00<0
003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1Voooo000`oooo00?o
09Woooooool0Q?ooo`030000oooooooo06Koool0033oool00ol0VOooooooo`24oooo00<0003ooooo
ool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool20000Ioooo`00<?ooo`03o`2Ioooooooo08Coool0
0`000?ooooooo`1Voooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo06Koool0033oool0
0ol0VOooooooo`24oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool20000Iooo
o`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1Voooo000`oooo00?o09Woooooool0Q?oo
o`030000oooooooo06Koool0033oool00ol0VOooooooo`1loooo1@0000?oool00`000?ooooooo`1V
oooo000`oooo00?o09Woooooool0O_ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo000`
oooo00?o09Woooooool0O_ooo`030000oooooooo00?oool30000I_ooo`00<?ooo`03o`2Ioooooooo
07koool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo07koool0
0`000?ooooooo`03oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo07goool200001Ooo
o`030000oooooooo06Koool0033oool00ol0VOooooooo`24oooo0P0006Ooool0033oool00ol0VOoo
ooooo`24oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1V
oooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo06Koool0033oool00ol0VOooooooo`24
oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool20000Ioooo`00<?ooo`03o`2I
oooooooo08Coool00`000?ooooooo`1Voooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo
06Koool0033oool00ol0VOooooooo`24oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo
08Coool20000Ioooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1Voooo000`oooo00?o
09Woooooool0Q?ooo`030000oooooooo06Koool0033oool00ol0VOooooooo`24oooo00<0003ooooo
ool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1Voooo000`oooo00?o09Wooooo
ool0Q?ooo`80001Woooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo06Koool0033oool0
0ol0VOooooooo`1loooo100000Coool00`000?ooooooo`1Voooo000`oooo00?o09Woooooool0O?oo
o`030000oooooooo00Goool00`000?ooooooo`1Voooo000`oooo00?o09Woooooool0OOooo`030000
oooooooo00Coool30000I_ooo`00<?ooo`03o`2Ioooooooo07koool00`000?ooooooo`03oooo00<0
003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo07coool010000?ooooooo`0000Coool00`000?oo
ooooo`1Voooo000`oooo00?o09Woooooool0OOooo`800005oooo00<0003oooooool0I_ooo`00<?oo
o`03o`2Ioooooooo08Coool20000Ioooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1V
oooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo06Koool0033oool00ol0VOooooooo`24
oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1Voooo000`
oooo00?o09Woooooool0Q?ooo`80001Woooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo
06Koool0033oool00ol0VOooooooo`24oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo
08Coool00`000?ooooooo`1Voooo000`oooo00?o09Woooooool0Q?ooo`80001Woooo000`oooo00?o
09Woooooool0Q?ooo`030000oooooooo06Koool0033oool00ol0VOooooooo`24oooo00<0003ooooo
ool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1Voooo000`oooo00?o09Wooooo
ool0Q?ooo`030000oooooooo06Koool0033oool00ol0VOooooooo`24oooo0P0006Ooool0033oool0
0ol0VOooooooo`24oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo07goool200001Ooo
o`030000oooooooo06Koool0033oool00ol0VOooooooo`1loooo00@0003oooooool00004oooo00<0
003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo07koool00`000?ooooooo`03oooo0`0006Koool0
033oool00ol0VOooooooo`1ooooo00<0003oooooool00_ooo`030000oooooooo06Koool0033oool0
0ol0VOooooooo`1loooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00<?ooo`03o`2I
oooooooo07goool200001Oooo`030000oooooooo06Koool0033oool00ol0VOooooooo`24oooo00<0
003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool20000Ioooo`00<?ooo`03o`2Ioooooooo
08Coool00`000?ooooooo`1Voooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo06Koool0
033oool00ol0VOooooooo`24oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool2
0000Ioooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1Voooo000`oooo00?o09Wooooo
ool0Q?ooo`030000oooooooo06Koool0033oool00ol0VOooooooo`24oooo00<0003oooooool0I_oo
o`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1Voooo000`oooo00?o09Woooooool0Q?oo
o`80001Woooo000`oooo00?o09Woooooool0Q?ooo`030000oooooooo06Koool0033oool00ol0VOoo
ooooo`24oooo00<0003oooooool0I_ooo`00<?ooo`03o`2Ioooooooo08Coool00`000?ooooooo`1V
oooo000`oooo00?o09Woooooool0Q?ooo`80001Woooo000`oooo00?o09Woooooool0Q?ooo`030000
oooooooo06Koool0033oool00ol0VOooooooo`24oooo00<0003oooooool0I_ooo`00<?ooo`03o`2I
oooooooo07koool300000oooo`030000oooooooo06Koool0033oool00ol0VOooooooo`1ooooo00<0
003oooooool00_ooo`030000oooooooo06Koool0033oool00ol0VOooooooo`1loooo1@0000?oool3
0000I_ooo`00[oooo`040000oooooooo0000KOooo`00/?ooo`030000oooo000006goool00;7oool2
0000KOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000ooo
o`@00003oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00<0003ooooo
ool01?ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Ooo
o`030000oooooooo00Soool00`000?ooooooo`04oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000Eoooo00<0003oooooool02?ooo`030000oooooooo00;oool00`000?ooooooo`1h
oooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000ooo
o`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.08255 .26487 L
.10458 .26487 L
.11448 .26487 L
.12507 .26487 L
.1302 .26487 L
.13273 .26487 L
.13506 .26487 L
.13615 .26487 L
.13718 .26487 L
s
.13718 .26487 m
.1376 .61803 L
s
0 .4 1 r
.02381 .24961 m
.06244 .24419 L
.08255 .24064 L
.10458 .23605 L
.11448 .23372 L
.12507 .23101 L
.1302 .22961 L
.13273 .22891 L
.13506 .22824 L
.13615 .22792 L
.13718 .22762 L
.13824 .26487 L
.13942 .26487 L
.14415 .26487 L
.18292 .26487 L
.22415 .26487 L
.26386 .26487 L
.30205 .26487 L
.34269 .26487 L
.38182 .26487 L
.42341 .26487 L
.46347 .26487 L
.50202 .26487 L
.54303 .26487 L
.58251 .26487 L
.62049 .26487 L
.66091 .26487 L
.69982 .26487 L
.74118 .26487 L
.78103 .26487 L
.81936 .26487 L
.86014 .26487 L
.8994 .26487 L
.93715 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0D
oooo0`1Vo`?oool500007_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001?oool406Ko100000;oool010000?ooooooo`0001Ooool400001Oooo`030000
oooooooo01Coool400001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0c
o`007C?o00040000<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003ooooo
ool03_ooo`@0I_l6oooo00<0I_ooooooool00_ooo`030000oooo000001goool010000?ooooooo`00
01coool400007S?o00030000<ol0<ol001Xco`000`0003?o03?o000M<ol000<0000co`0co`000c?o
00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`0000Soool606Ko2_ooo`0306Kooooooooo
00?oool200007_ooo`80000Koooo1@0001hco`02000073?o00030000<ol0<ol001`co`02000023?o
00@0000Coooo0P0002Ooool001coool706Ko4?ooo`0306Kooooooooo03koool20000@C?o00030000
<ol0<ol002Xco`030000>Oooo`005_ooo`H0I_lGoooo00<0I_ooooooool0>_ooo`@00013<ol00P00
02hco`020000=oooo`00<oooo`0306Kooooooooo03Goool50000Ac?o00030000<ol0<ol002lco`04
0000<oooo`00<oooo`0306Kooooooooo02_oool:0000C3?o00030000<ol0<ol003<co`0:0000:Ooo
o`00<oooo`0306Kooooooooo023oool;0000ES?o00030000<ol0<ol003dco`0?00006_ooo`004?oo
ool0000Aoooo000Foooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`040000ooooooooo`2I0_ooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo01;oool001Koool00`000?ooooooo`0J
oooo00Co09Woooooool0000Poooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?oo
ooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`0Uoooo000c
oooo00?o09Woooooool0POooo`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo00<0
003oooooool0I_ooo`00<oooo`03o`2Ioooooooo087oool20000Ioooo`00<oooo`03o`2Ioooooooo
087oool00`000?ooooooo`1Voooo000coooo00?o09Woooooool0POooo`030000oooooooo06Koool0
03?oool00ol0VOooooooo`21oooo00<0003oooooool0I_ooo`00<oooo`03o`2Ioooooooo087oool2
0000Ioooo`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000coooo00?o09Wooooo
ool0POooo`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo00<0003oooooool0I_oo
o`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000coooo00?o09Woooooool0POoo
o`80001Woooo000coooo00?o09Woooooool0POooo`030000oooooooo06Koool003?oool00ol0VOoo
ooooo`21oooo00<0003oooooool0I_ooo`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1V
oooo000coooo00?o09Woooooool0POooo`80001Woooo000coooo00?o09Woooooool0POooo`030000
oooooooo06Koool003?oool00ol0VOooooooo`21oooo00<0003oooooool0I_ooo`00<oooo`03o`2I
oooooooo07Woool500000oooo`030000oooooooo06Koool003?oool00ol0VOooooooo`1koooo00<0
003oooooool00oooo`030000oooooooo06Koool003?oool00ol0VOooooooo`1koooo00<0003ooooo
ool00oooo`<0001Voooo000coooo00?o09Woooooool0Noooo`030000oooooooo00?oool00`000?oo
ooooo`1Voooo000coooo00?o09Woooooool0Noooo`030000oooooooo00?oool00`000?ooooooo`1V
oooo000coooo00?o09Woooooool0N_ooo`800005oooo00<0003oooooool0I_ooo`00<oooo`03o`2I
oooooooo087oool20000Ioooo`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000c
oooo00?o09Woooooool0POooo`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo00<0
003oooooool0I_ooo`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000coooo00?o
09Woooooool0POooo`80001Woooo000coooo00?o09Woooooool0POooo`030000oooooooo06Koool0
03?oool00ol0VOooooooo`21oooo00<0003oooooool0I_ooo`00<oooo`03o`2Ioooooooo087oool0
0`000?ooooooo`1Voooo000coooo00?o09Woooooool0POooo`80001Woooo000coooo00?o09Wooooo
ool0POooo`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo00<0003oooooool0I_oo
o`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000coooo00?o09Woooooool0POoo
o`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo0P0006Ooool003?oool00ol0VOoo
ooooo`21oooo00<0003oooooool0I_ooo`00<oooo`03o`2Ioooooooo07Woool400001?ooo`030000
oooooooo06Koool003?oool00ol0VOooooooo`1ioooo00<0003oooooool01Oooo`030000oooooooo
06Koool003?oool00ol0VOooooooo`1joooo00<0003oooooool01?ooo`<0001Voooo000coooo00?o
09Woooooool0Noooo`030000oooooooo00?oool00`000?ooooooo`1Voooo000coooo00?o09Wooooo
ool0NOooo`040000oooooooo00001?ooo`030000oooooooo06Koool003?oool00ol0VOooooooo`1j
oooo0P0000Goool00`000?ooooooo`1Voooo000coooo00?o09Woooooool0POooo`80001Woooo000c
oooo00?o09Woooooool0POooo`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo00<0
003oooooool0I_ooo`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000coooo00?o
09Woooooool0POooo`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo0P0006Ooool0
03?oool00ol0VOooooooo`21oooo00<0003oooooool0I_ooo`00<oooo`03o`2Ioooooooo087oool0
0`000?ooooooo`1Voooo000coooo00?o09Woooooool0POooo`030000oooooooo06Koool003?oool0
0ol0VOooooooo`21oooo0P0006Ooool003?oool00ol0VOooooooo`21oooo00<0003oooooool0I_oo
o`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000coooo00?o09Woooooool0POoo
o`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo00<0003oooooool0I_ooo`00<ooo
o`03o`2Ioooooooo087oool20000Ioooo`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1V
oooo000coooo00?o09Woooooool0N_ooo`800005oooo00<0003oooooool0I_ooo`00<oooo`03o`2I
oooooooo07Woool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo000coooo00?o09Wooooo
ool0Noooo`030000oooooooo00?oool30000I_ooo`00<oooo`03o`2Ioooooooo07coool00`000?oo
ooooo`02oooo00<0003oooooool0I_ooo`00<oooo`03o`2Ioooooooo07Woool010000?ooooooo`00
00Coool00`000?ooooooo`1Voooo000coooo00?o09Woooooool0N_ooo`800005oooo00<0003ooooo
ool0I_ooo`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000coooo00?o09Wooooo
ool0POooo`80001Woooo000coooo00?o09Woooooool0POooo`030000oooooooo06Koool003?oool0
0ol0VOooooooo`21oooo00<0003oooooool0I_ooo`00<oooo`03o`2Ioooooooo087oool00`000?oo
ooooo`1Voooo000coooo00?o09Woooooool0POooo`80001Woooo000coooo00?o09Woooooool0POoo
o`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo00<0003oooooool0I_ooo`00<ooo
o`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000coooo00?o09Woooooool0POooo`030000
oooooooo06Koool003?oool00ol0VOooooooo`21oooo0P0006Ooool003?oool00ol0VOooooooo`21
oooo00<0003oooooool0I_ooo`00<oooo`03o`2Ioooooooo087oool00`000?ooooooo`1Voooo000c
oooo00?o09Woooooool0POooo`030000oooooooo06Koool003?oool00ol0VOooooooo`21oooo0P00
06Ooool003?oool00ol0VOooooooo`21oooo00<0003oooooool0I_ooo`00<oooo`03o`2Ioooooooo
087oool00`000?ooooooo`1Voooo000coooo00?o09Woooooool0Noooo`<00003oooo00<0003ooooo
ool0I_ooo`00<oooo`03o`2Ioooooooo07coool00`000?ooooooo`02oooo00<0003oooooool0I_oo
o`00<oooo`03o`2Ioooooooo07Woool500000oooo`<0001Voooo002_oooo00@0003oooooool0001]
oooo002`oooo00<0003oool00000KOooo`00/Oooo`80001]oooo003ooooo8Oooo`00ooooob7oool0
07Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool0
0`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?oo
o`030000oooooooo00goool200001?ooo`800003oooo1@0000;oool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo1000
00?oool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00Mooo
o`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool02Oooo`030000oooooooo
00?oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001Goool00`000?ooooooo`08
oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000E
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Goooo0P0000[oool200000oooo`030000oooooooo07Woool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.12507 .26487 L
.13506 .26487 L
.14415 .26487 L
.14635 .26487 L
.14868 .26487 L
.1499 .26487 L
.15059 .26487 L
s
.15059 .26487 m
.15085 .61803 L
s
0 .4 1 r
.02381 .25107 m
.06244 .24616 L
.10458 .23881 L
.12507 .23425 L
.13506 .23174 L
.14415 .22928 L
.14635 .22866 L
.14868 .22799 L
.1499 .22764 L
.15059 .22743 L
.15124 .26487 L
.15238 .26487 L
.1536 .26487 L
.16254 .26487 L
.18221 .26487 L
.22343 .26487 L
.26314 .26487 L
.30133 .26487 L
.34198 .26487 L
.38111 .26487 L
.42269 .26487 L
.46276 .26487 L
.50131 .26487 L
.54231 .26487 L
.5818 .26487 L
.61977 .26487 L
.6602 .26487 L
.6991 .26487 L
.74046 .26487 L
.78031 .26487 L
.81864 .26487 L
.85942 .26487 L
.89869 .26487 L
.93644 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0G
oooo0`1Vo`D0000Noooo00<0003oooooool07?ooo`040000oooooooooooo0P0001/co`000`0003?o
03?o000J<ol00P0001hco`00100003?o0000000001coool00`000?ooooooo`0Voooo000Aoooo1000
00?oool200005Oooo`80I_l4000000?oool0I_l000000_ooo`030000oooooooo01Goool400001Ooo
o`030000oooooooo01Coool400001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0
000co`0co`007C?o00040000<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0
003oooooool04_ooo`80I_l7oooo00D0I_ooool0003oool000007Oooo`040000oooooooo00007?oo
o`@0000N<ol000<0000co`0co`006S?o00030000<ol0<ol001dco`000`0003?o03?o0003<ol00`00
01Koool010000?ooooooo`0002Koool001Soool300002oooo`L0I_l9oooo00<0I_ooooooool00P00
01koool200006oooo`D0000N<ol00P0001`co`000`0003?o03?o000L<ol00P0000Pco`0400004ooo
o`80000Woooo000Noooo201Voa3oool00`1Vooooooooo`0koooo0P00044co`000`0003?o03?o000Z
<ol00`0003Woool001Woool506Ko6Oooo`0306Kooooooooo03Koool40000@c?o0080000^<ol00P00
03Ooool001Koool306Ko7_ooo`0306Kooooooooo037oool50000Ac?o00030000<ol0<ol002lco`04
0000<oooo`00=oooo`0306Kooooooooo02Ooool:0000C3?o00030000<ol0<ol003<co`0:0000:Ooo
o`00=oooo`0306Kooooooooo01coool;0000ES?o00030000<ol0<ol003dco`0?00006_ooo`004?oo
ool0000Aoooo000Foooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`0Boooo000Foooo00<0003oooooool07Ooo
o`030000oooooooo01koool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo
01goool00`000?ooooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo02Goool003Koool0
0ol0VOooooooo`1noooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool00`000?oo
ooooo`1Voooo000foooo00?o09Woooooool0O_ooo`80001Woooo000foooo00?o09Woooooool0O_oo
o`030000oooooooo06Koool003Koool00ol0VOooooooo`1noooo00<0003oooooool0I_ooo`00=_oo
o`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000foooo00?o09Woooooool0O_ooo`80001W
oooo000foooo00?o09Woooooool0O_ooo`030000oooooooo06Koool003Koool00ol0VOooooooo`1n
oooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000f
oooo00?o09Woooooool0O_ooo`030000oooooooo06Koool003Koool00ol0VOooooooo`1noooo0P00
06Ooool003Koool00ol0VOooooooo`1noooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo
07koool00`000?ooooooo`1Voooo000foooo00?o09Woooooool0O_ooo`030000oooooooo06Koool0
03Koool00ol0VOooooooo`1noooo0P0006Ooool003Koool00ol0VOooooooo`1noooo00<0003ooooo
ool0I_ooo`00=_ooo`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000foooo00?o09Wooooo
ool0M_ooo`D00003oooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07Soool00`000?oo
ooooo`03oooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07Soool00`000?ooooooo`03
oooo0`0006Koool003Koool00ol0VOooooooo`1hoooo00<0003oooooool00oooo`030000oooooooo
06Koool003Koool00ol0VOooooooo`1hoooo00<0003oooooool00oooo`030000oooooooo06Koool0
03Koool00ol0VOooooooo`1goooo0P0000Goool00`000?ooooooo`1Voooo000foooo00?o09Wooooo
ool0O_ooo`80001Woooo000foooo00?o09Woooooool0O_ooo`030000oooooooo06Koool003Koool0
0ol0VOooooooo`1noooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool00`000?oo
ooooo`1Voooo000foooo00?o09Woooooool0O_ooo`030000oooooooo06Koool003Koool00ol0VOoo
ooooo`1noooo0P0006Ooool003Koool00ol0VOooooooo`1noooo00<0003oooooool0I_ooo`00=_oo
o`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000foooo00?o09Woooooool0O_ooo`030000
oooooooo06Koool003Koool00ol0VOooooooo`1noooo0P0006Ooool003Koool00ol0VOooooooo`1n
oooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000f
oooo00?o09Woooooool0O_ooo`030000oooooooo06Koool003Koool00ol0VOooooooo`1noooo00<0
003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool20000Ioooo`00=_ooo`03o`2Ioooooooo
07koool00`000?ooooooo`1Voooo000foooo00?o09Woooooool0M_ooo`@00004oooo00<0003ooooo
ool0I_ooo`00=_ooo`03o`2Ioooooooo07Koool00`000?ooooooo`05oooo00<0003oooooool0I_oo
o`00=_ooo`03o`2Ioooooooo07Ooool00`000?ooooooo`04oooo0`0006Koool003Koool00ol0VOoo
ooooo`1hoooo00<0003oooooool00oooo`030000oooooooo06Koool003Koool00ol0VOooooooo`1f
oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07Ooool2
00001Oooo`030000oooooooo06Koool003Koool00ol0VOooooooo`1noooo0P0006Ooool003Koool0
0ol0VOooooooo`1noooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool00`000?oo
ooooo`1Voooo000foooo00?o09Woooooool0O_ooo`030000oooooooo06Koool003Koool00ol0VOoo
ooooo`1noooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool20000Ioooo`00=_oo
o`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000foooo00?o09Woooooool0O_ooo`030000
oooooooo06Koool003Koool00ol0VOooooooo`1noooo00<0003oooooool0I_ooo`00=_ooo`03o`2I
oooooooo07koool20000Ioooo`00=_ooo`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000f
oooo00?o09Woooooool0O_ooo`030000oooooooo06Koool003Koool00ol0VOooooooo`1noooo00<0
003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000foooo00?o
09Woooooool0O_ooo`80001Woooo000foooo00?o09Woooooool0O_ooo`030000oooooooo06Koool0
03Koool00ol0VOooooooo`1goooo0P0000Goool00`000?ooooooo`1Voooo000foooo00?o09Wooooo
ool0M_ooo`040000oooooooo00001?ooo`030000oooooooo06Koool003Koool00ol0VOooooooo`1h
oooo00<0003oooooool00oooo`<0001Voooo000foooo00?o09Woooooool0NOooo`030000oooooooo
00;oool00`000?ooooooo`1Voooo000foooo00?o09Woooooool0M_ooo`040000oooooooo00001?oo
o`030000oooooooo06Koool003Koool00ol0VOooooooo`1goooo0P0000Goool00`000?ooooooo`1V
oooo000foooo00?o09Woooooool0O_ooo`030000oooooooo06Koool003Koool00ol0VOooooooo`1n
oooo0P0006Ooool003Koool00ol0VOooooooo`1noooo00<0003oooooool0I_ooo`00=_ooo`03o`2I
oooooooo07koool00`000?ooooooo`1Voooo000foooo00?o09Woooooool0O_ooo`030000oooooooo
06Koool003Koool00ol0VOooooooo`1noooo0P0006Ooool003Koool00ol0VOooooooo`1noooo00<0
003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000foooo00?o
09Woooooool0O_ooo`030000oooooooo06Koool003Koool00ol0VOooooooo`1noooo00<0003ooooo
ool0I_ooo`00=_ooo`03o`2Ioooooooo07koool20000Ioooo`00=_ooo`03o`2Ioooooooo07koool0
0`000?ooooooo`1Voooo000foooo00?o09Woooooool0O_ooo`030000oooooooo06Koool003Koool0
0ol0VOooooooo`1noooo00<0003oooooool0I_ooo`00=_ooo`03o`2Ioooooooo07koool20000Iooo
o`00=_ooo`03o`2Ioooooooo07koool00`000?ooooooo`1Voooo000foooo00?o09Woooooool0O_oo
o`030000oooooooo06Koool003Koool00ol0VOooooooo`1hoooo0`0000?oool00`000?ooooooo`1V
oooo000foooo00?o09Woooooool0NOooo`030000oooooooo00;oool00`000?ooooooo`1Voooo000f
oooo00?o09Woooooool0M_ooo`D00003oooo0`0006Koool00:ooool010000?ooooooo`0006goool0
0;3oool00`000?ooo`00001]oooo002aoooo0P0006goool00?oooolQoooo003ooooo8Oooo`00O?oo
o`030000oooooooo02;oool00`000?ooooooo`1loooo001koooo00<0003oooooool02?ooo`030000
oooooooo01Woool00`000?ooooooo`1koooo001koooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03Oooo`800004oooo0P0000Coool00`000?ooooooo`1koooo001koooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?oo
ooooo`0000Woool00`000?ooooooo`1koooo001joooo00<0003oooooool00_ooo`030000oooooooo
01Goool00`000?ooooooo`09oooo00<0003oooooool0N_ooo`00Noooo`030000oooooooo00D0000E
oooo00<0003oooooool01oooo`030000oooooooo07_oool007_oool01@000?ooooooooooo`00000E
oooo00@0003oooooool00009oooo00<0003oooooool0Noooo`00O?ooo`030000oooooooo01Ooool2
00002Oooo`030000oooooooo07coool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.12507 .26487 L
.14415 .26487 L
.1536 .26487 L
.15825 .26487 L
.16029 .26487 L
.16137 .26487 L
.16254 .26487 L
s
.16254 .26487 m
.16303 .61803 L
s
0 .4 1 r
.02381 .25239 m
.06244 .24795 L
.10458 .2413 L
.12507 .23718 L
.14415 .23269 L
.1536 .23021 L
.15825 .22892 L
.16029 .22833 L
.16137 .22802 L
.16254 .22768 L
.16378 .26487 L
.16494 .26487 L
.16748 .26487 L
.17284 .26487 L
.18221 .26487 L
.22343 .26487 L
.26314 .26487 L
.30133 .26487 L
.34198 .26487 L
.38111 .26487 L
.42269 .26487 L
.46276 .26487 L
.50131 .26487 L
.54231 .26487 L
.5818 .26487 L
.61977 .26487 L
.6602 .26487 L
.6991 .26487 L
.74046 .26487 L
.78031 .26487 L
.81864 .26487 L
.85942 .26487 L
.89869 .26487 L
.93644 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo10000080I_l010000?ooo`1Vo`0001Ooool400001Oooo`030000oooooooo01Coool4
00001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0co`007C?o00040000
<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003oooooool04oooo`D0I_l5
oooo00<00000I_l000007Oooo`040000oooooooo00007?ooo`@0000N<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`000`0003?o03?o0003<ol00`0001Koool010000?ooooooo`0002Koool0
01Soool300003_ooo`D0I_l;oooo0P0001koool200006oooo`D0000N<ol00P0001`co`000`0003?o
03?o000L<ol00P0000Pco`0400004oooo`80000Woooo000Soooo1P1Voa3oool00`1Vooooooooo`0h
oooo0P00044co`000`0003?o03?o000Z<ol00`0003Woool001coool706Ko5oooo`0306Kooooooooo
03?oool40000@c?o0080000^<ol00P0003Ooool001Koool606Ko7_ooo`0306Kooooooooo02koool5
0000Ac?o00030000<ol0<ol002lco`040000<oooo`00>_ooo`0306Kooooooooo02Coool:0000C3?o
00030000<ol0<ol003<co`0:0000:Oooo`00>_ooo`0306Kooooooooo01Woool;0000ES?o00030000
<ol0<ol003dco`0?00006_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool0
10000?ooooooool0V@?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
01;oool001Koool00`000?ooooooo`0Moooo00@0003ooooooooo09TMoooo00<0003oooooool07Ooo
o`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo
01koool00`000?ooooooo`0Uoooo000ioooo00?o09Woooooool0Noooo`030000oooooooo06Koool0
03Woool00ol0VOooooooo`1koooo00<0003oooooool0I_ooo`00>Oooo`03o`2Ioooooooo07_oool2
0000Ioooo`00>Oooo`03o`2Ioooooooo07_oool00`000?ooooooo`1Voooo000ioooo00?o09Wooooo
ool0Noooo`030000oooooooo06Koool003Woool00ol0VOooooooo`1koooo00<0003oooooool0I_oo
o`00>Oooo`03o`2Ioooooooo07_oool20000Ioooo`00>Oooo`03o`2Ioooooooo07_oool00`000?oo
ooooo`1Voooo000ioooo00?o09Woooooool0Noooo`030000oooooooo06Koool003Woool00ol0VOoo
ooooo`1koooo00<0003oooooool0I_ooo`00>Oooo`03o`2Ioooooooo07_oool00`000?ooooooo`1V
oooo000ioooo00?o09Woooooool0Noooo`80001Woooo000ioooo00?o09Woooooool0Noooo`030000
oooooooo06Koool003Woool00ol0VOooooooo`1koooo00<0003oooooool0I_ooo`00>Oooo`03o`2I
oooooooo07_oool00`000?ooooooo`1Voooo000ioooo00?o09Woooooool0Noooo`80001Woooo000i
oooo00?o09Woooooool0Noooo`030000oooooooo06Koool003Woool00ol0VOooooooo`1koooo00<0
003oooooool0I_ooo`00>Oooo`03o`2Ioooooooo07?oool500000oooo`030000oooooooo06Koool0
03Woool00ol0VOooooooo`1eoooo00<0003oooooool00oooo`030000oooooooo06Koool003Woool0
0ol0VOooooooo`1eoooo00<0003oooooool00oooo`<0001Voooo000ioooo00?o09Woooooool0MOoo
o`030000oooooooo00?oool00`000?ooooooo`1Voooo000ioooo00?o09Woooooool0MOooo`030000
oooooooo00?oool00`000?ooooooo`1Voooo000ioooo00?o09Woooooool0M?ooo`800005oooo00<0
003oooooool0I_ooo`00>Oooo`03o`2Ioooooooo07_oool20000Ioooo`00>Oooo`03o`2Ioooooooo
07_oool00`000?ooooooo`1Voooo000ioooo00?o09Woooooool0Noooo`030000oooooooo06Koool0
03Woool00ol0VOooooooo`1koooo00<0003oooooool0I_ooo`00>Oooo`03o`2Ioooooooo07_oool0
0`000?ooooooo`1Voooo000ioooo00?o09Woooooool0Noooo`80001Woooo000ioooo00?o09Wooooo
ool0Noooo`030000oooooooo06Koool003Woool00ol0VOooooooo`1koooo00<0003oooooool0I_oo
o`00>Oooo`03o`2Ioooooooo07_oool00`000?ooooooo`1Voooo000ioooo00?o09Woooooool0Nooo
o`80001Woooo000ioooo00?o09Woooooool0Noooo`030000oooooooo06Koool003Woool00ol0VOoo
ooooo`1koooo00<0003oooooool0I_ooo`00>Oooo`03o`2Ioooooooo07_oool00`000?ooooooo`1V
oooo000ioooo00?o09Woooooool0Noooo`030000oooooooo06Koool003Woool00ol0VOooooooo`1k
oooo0P0006Ooool003Woool00ol0VOooooooo`1koooo00<0003oooooool0I_ooo`00>Oooo`03o`2I
oooooooo07?oool400001?ooo`030000oooooooo06Koool003Woool00ol0VOooooooo`1coooo00<0
003oooooool01Oooo`030000oooooooo06Koool003Woool00ol0VOooooooo`1doooo00<0003ooooo
ool01?ooo`<0001Voooo000joooo00?o09Woooooool0M?ooo`030000oooooooo00?oool00`000?oo
ooooo`1Voooo000joooo00?o09Woooooool0L_ooo`040000oooooooo00001?ooo`030000oooooooo
06Koool003[oool00ol0VOooooooo`1coooo0P0000Goool00`000?ooooooo`1Voooo000joooo00?o
09Woooooool0N_ooo`80001Woooo000joooo00?o09Woooooool0N_ooo`030000oooooooo06Koool0
03[oool00ol0VOooooooo`1joooo00<0003oooooool0I_ooo`00>_ooo`03o`2Ioooooooo07[oool0
0`000?ooooooo`1Voooo000joooo00?o09Woooooool0N_ooo`030000oooooooo06Koool003[oool0
0ol0VOooooooo`1joooo0P0006Ooool003[oool00ol0VOooooooo`1joooo00<0003oooooool0I_oo
o`00>_ooo`03o`2Ioooooooo07[oool00`000?ooooooo`1Voooo000joooo00?o09Woooooool0N_oo
o`030000oooooooo06Koool003[oool00ol0VOooooooo`1joooo0P0006Ooool003[oool00ol0VOoo
ooooo`1joooo00<0003oooooool0I_ooo`00>_ooo`03o`2Ioooooooo07[oool00`000?ooooooo`1V
oooo000joooo00?o09Woooooool0N_ooo`030000oooooooo06Koool003[oool00ol0VOooooooo`1j
oooo00<0003oooooool0I_ooo`00>_ooo`03o`2Ioooooooo07[oool20000Ioooo`00>_ooo`03o`2I
oooooooo07[oool00`000?ooooooo`1Voooo000joooo00?o09Woooooool0Loooo`800005oooo00<0
003oooooool0I_ooo`00>_ooo`03o`2Ioooooooo07;oool010000?ooooooo`0000Coool00`000?oo
ooooo`1Voooo000joooo00?o09Woooooool0M?ooo`030000oooooooo00?oool30000I_ooo`00>_oo
o`03o`2Ioooooooo07Goool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00>_ooo`03o`2I
oooooooo07;oool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo000joooo00?o09Wooooo
ool0Loooo`800005oooo00<0003oooooool0I_ooo`00>_ooo`03o`2Ioooooooo07[oool00`000?oo
ooooo`1Voooo000joooo00?o09Woooooool0N_ooo`80001Woooo000joooo00?o09Woooooool0N_oo
o`030000oooooooo06Koool003[oool00ol0VOooooooo`1joooo00<0003oooooool0I_ooo`00>_oo
o`03o`2Ioooooooo07[oool00`000?ooooooo`1Voooo000joooo00?o09Woooooool0N_ooo`80001W
oooo000joooo00?o09Woooooool0N_ooo`030000oooooooo06Koool003[oool00ol0VOooooooo`1j
oooo00<0003oooooool0I_ooo`00>_ooo`03o`2Ioooooooo07[oool00`000?ooooooo`1Voooo000j
oooo00?o09Woooooool0N_ooo`030000oooooooo06Koool003[oool00ol0VOooooooo`1joooo0P00
06Ooool003[oool00ol0VOooooooo`1joooo00<0003oooooool0I_ooo`00>_ooo`03o`2Ioooooooo
07[oool00`000?ooooooo`1Voooo000joooo00?o09Woooooool0N_ooo`030000oooooooo06Koool0
03[oool00ol0VOooooooo`1joooo0P0006Ooool003[oool00ol0VOooooooo`1joooo00<0003ooooo
ool0I_ooo`00>_ooo`03o`2Ioooooooo07[oool00`000?ooooooo`1Voooo000joooo00?o09Wooooo
ool0M?ooo`<00003oooo00<0003oooooool0I_ooo`00>_ooo`03o`2Ioooooooo07Goool00`000?oo
ooooo`02oooo00<0003oooooool0I_ooo`00>_ooo`03o`2Ioooooooo07;oool500000oooo`<0001V
oooo002_oooo00@0003oooooool0001]oooo002`oooo00<0003oool00000KOooo`00/Oooo`80001]
oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?oo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00coool400000oooo`800003oooo0`00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000?oool00`000?ooooooo`0;oooo00<0003oooooool00_oo
o`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05?ooo`030000
oooooooo00Woool300001?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005?oo
o`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool300000_ooo`030000oooooooo
07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.12507 .26487 L
.14415 .26487 L
.16254 .26487 L
.16783 .26487 L
.17044 .26487 L
.17284 .26487 L
.17502 .26487 L
.17612 .26487 L
s
.17612 .26487 m
.1766 .61803 L
s
0 .4 1 r
.02381 .25359 m
.06244 .24957 L
.10458 .24356 L
.12507 .23983 L
.14415 .23577 L
.16254 .23124 L
.16783 .22981 L
.17044 .22909 L
.17284 .22841 L
.17502 .22778 L
.17612 .22746 L
.17733 .26487 L
.17854 .26487 L
.17985 .26487 L
.18221 .26487 L
.22343 .26487 L
.26314 .26487 L
.30133 .26487 L
.34198 .26487 L
.38111 .26487 L
.42269 .26487 L
.46276 .26487 L
.50131 .26487 L
.54231 .26487 L
.5818 .26487 L
.61977 .26487 L
.6602 .26487 L
.6991 .26487 L
.74046 .26487 L
.78031 .26487 L
.81864 .26487 L
.85942 .26487 L
.89869 .26487 L
.93644 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@000080I_lLoooo00<0003oooooool07?ooo`040000oooooooooooo0P0001/co`000`0003?o
03?o000J<ol00P0001hco`00100003?o0000000001coool00`000?ooooooo`0Voooo000Aoooo1000
00?oool200005oooo`@00002oooo00@00000I_l0I_l00002oooo00<0I_ooooooool04_ooo`@00005
oooo00<0003oooooool05?ooo`@00004oooo0`0001Dco`04000013?o00030000<ol0<ol001Xco`00
0`0003?o03?o000M<ol000@0000co`0co`0co`0200006oooo`030000oooooooo02Goool001Soool0
0`000?ooooooo`0Hoooo1@1Vo`030000oooo000000;oool00`1Vooooooooo`0Hoooo00@0003ooooo
ool0000Loooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o00030000<ol0<ol0
00<co`0300005_ooo`040000oooooooo00009_ooo`006?ooo`<0000Coooo1@1Vo`Koool200000_oo
o`0306Kooooooooo01Woool200006oooo`D0000N<ol00P0001`co`000`0003?o03?o000L<ol00P00
00Pco`0400004oooo`80000Woooo000Voooo201Vo`ooool00`1Vooooooooo`0doooo0P00044co`00
0`0003?o03?o000Z<ol00`0003Woool001coool:06Ko5oooo`0306Kooooooooo033oool40000@c?o
0080000^<ol00P0003Ooool001Koool606Ko8Oooo`0306Kooooooooo02_oool50000Ac?o00030000
<ol0<ol002lco`040000<oooo`00?Oooo`0306Kooooooooo027oool:0000C3?o00030000<ol0<ol0
03<co`0:0000:Oooo`00?Oooo`0306Kooooooooo01Koool;0000ES?o00030000<ol0<ol003dco`0?
00006_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`0Boooo000Foooo00<0
003oooooool07Oooo`030000oooooooo00Coool00ol0VOooooooo`0Goooo00<0003oooooool07Ooo
o`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo
01koool00`000?ooooooo`0Uoooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool0
03goool00ol0VOooooooo`1goooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool2
0000Ioooo`00?Oooo`03o`2Ioooooooo07Ooool00`000?ooooooo`1Voooo000moooo00?o09Wooooo
ool0Moooo`030000oooooooo06Koool003goool00ol0VOooooooo`1goooo00<0003oooooool0I_oo
o`00?Oooo`03o`2Ioooooooo07Ooool20000Ioooo`00?Oooo`03o`2Ioooooooo07Ooool00`000?oo
ooooo`1Voooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool003goool00ol0VOoo
ooooo`1goooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool00`000?ooooooo`1V
oooo000moooo00?o09Woooooool0Moooo`80001Woooo000moooo00?o09Woooooool0Moooo`030000
oooooooo06Koool003goool00ol0VOooooooo`1goooo00<0003oooooool0I_ooo`00?Oooo`03o`2I
oooooooo07Ooool00`000?ooooooo`1Voooo000moooo00?o09Woooooool0Moooo`80001Woooo000m
oooo00?o09Woooooool0Moooo`030000oooooooo06Koool003goool00ol0VOooooooo`1goooo00<0
003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo06ooool500000oooo`030000oooooooo06Koool0
03goool00ol0VOooooooo`1aoooo00<0003oooooool00oooo`030000oooooooo06Koool003goool0
0ol0VOooooooo`1aoooo00<0003oooooool00oooo`<0001Voooo000moooo00?o09Woooooool0LOoo
o`030000oooooooo00?oool00`000?ooooooo`1Voooo000moooo00?o09Woooooool0LOooo`030000
oooooooo00?oool00`000?ooooooo`1Voooo000moooo00?o09Woooooool0L?ooo`800005oooo00<0
003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool20000Ioooo`00?Oooo`03o`2Ioooooooo
07Ooool00`000?ooooooo`1Voooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool0
03goool00ol0VOooooooo`1goooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool0
0`000?ooooooo`1Voooo000moooo00?o09Woooooool0Moooo`80001Woooo000moooo00?o09Wooooo
ool0Moooo`030000oooooooo06Koool003goool00ol0VOooooooo`1goooo00<0003oooooool0I_oo
o`00?Oooo`03o`2Ioooooooo07Ooool00`000?ooooooo`1Voooo000moooo00?o09Woooooool0Mooo
o`80001Woooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool003goool00ol0VOoo
ooooo`1goooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool00`000?ooooooo`1V
oooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool003goool00ol0VOooooooo`1g
oooo0P0006Ooool003goool00ol0VOooooooo`1goooo00<0003oooooool0I_ooo`00?Oooo`03o`2I
oooooooo06ooool400001?ooo`030000oooooooo06Koool003goool00ol0VOooooooo`1_oooo00<0
003oooooool01Oooo`030000oooooooo06Koool003goool00ol0VOooooooo`1`oooo00<0003ooooo
ool01?ooo`<0001Voooo000moooo00?o09Woooooool0LOooo`030000oooooooo00?oool00`000?oo
ooooo`1Voooo000moooo00?o09Woooooool0Koooo`040000oooooooo00001?ooo`030000oooooooo
06Koool003goool00ol0VOooooooo`1`oooo0P0000Goool00`000?ooooooo`1Voooo000moooo00?o
09Woooooool0Moooo`80001Woooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool0
03goool00ol0VOooooooo`1goooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool0
0`000?ooooooo`1Voooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool003goool0
0ol0VOooooooo`1goooo0P0006Ooool003goool00ol0VOooooooo`1goooo00<0003oooooool0I_oo
o`00?Oooo`03o`2Ioooooooo07Ooool00`000?ooooooo`1Voooo000moooo00?o09Woooooool0Mooo
o`030000oooooooo06Koool003goool00ol0VOooooooo`1goooo0P0006Ooool003goool00ol0VOoo
ooooo`1goooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool00`000?ooooooo`1V
oooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool003goool00ol0VOooooooo`1g
oooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool20000Ioooo`00?Oooo`03o`2I
oooooooo07Ooool00`000?ooooooo`1Voooo000moooo00?o09Woooooool0L?ooo`800005oooo00<0
003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo06ooool010000?ooooooo`0000Coool00`000?oo
ooooo`1Voooo000moooo00?o09Woooooool0LOooo`030000oooooooo00?oool30000I_ooo`00?Ooo
o`03o`2Ioooooooo07;oool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00?Oooo`03o`2I
oooooooo06ooool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo000moooo00?o09Wooooo
ool0L?ooo`800005oooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool00`000?oo
ooooo`1Voooo000moooo00?o09Woooooool0Moooo`80001Woooo000moooo00?o09Woooooool0Mooo
o`030000oooooooo06Koool003goool00ol0VOooooooo`1goooo00<0003oooooool0I_ooo`00?Ooo
o`03o`2Ioooooooo07Ooool00`000?ooooooo`1Voooo000moooo00?o09Woooooool0Moooo`80001W
oooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool003goool00ol0VOooooooo`1g
oooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool00`000?ooooooo`1Voooo000m
oooo00?o09Woooooool0Moooo`030000oooooooo06Koool003goool00ol0VOooooooo`1goooo0P00
06Ooool003goool00ol0VOooooooo`1goooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo
07Ooool00`000?ooooooo`1Voooo000moooo00?o09Woooooool0Moooo`030000oooooooo06Koool0
03goool00ol0VOooooooo`1goooo0P0006Ooool003goool00ol0VOooooooo`1goooo00<0003ooooo
ool0I_ooo`00?Oooo`03o`2Ioooooooo07Ooool00`000?ooooooo`1Voooo000moooo00?o09Wooooo
ool0LOooo`<00003oooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo07;oool00`000?oo
ooooo`02oooo00<0003oooooool0I_ooo`00?Oooo`03o`2Ioooooooo06ooool500000oooo`<0001V
oooo002_oooo00@0003oooooool0001]oooo002`oooo00<0003oool00000KOooo`00/Oooo`80001]
oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?oo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00coool400000oooo`800004oooo0P00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000?oool00`000?ooooooo`09oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Doooo00<0
003oooooool02?ooo`040000oooooooo00001?ooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500005?ooo`030000oooooooo00Soool200001?ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003oooo00<0003ooooo
ool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.16408 .26487 L
.17277 .26487 L
.18221 .26487 L
.18475 .26487 L
.18614 .26487 L
.18744 .26487 L
.18855 .26487 L
s
.18855 .26487 m
.18902 .61803 L
s
0 .4 1 r
.02381 .25467 m
.06244 .25104 L
.10458 .2456 L
.14415 .23856 L
.16408 .2341 L
.17277 .23192 L
.18221 .22939 L
.18475 .22867 L
.18614 .22827 L
.18744 .2279 L
.18855 .22757 L
.18974 .26487 L
.19106 .26487 L
.19227 .26487 L
.20178 .26487 L
.22272 .26487 L
.26243 .26487 L
.30062 .26487 L
.34126 .26487 L
.38039 .26487 L
.42198 .26487 L
.46204 .26487 L
.50059 .26487 L
.5416 .26487 L
.58108 .26487 L
.61906 .26487 L
.65948 .26487 L
.69839 .26487 L
.73975 .26487 L
.77959 .26487 L
.81792 .26487 L
.85871 .26487 L
.89797 .26487 L
.93572 .26487 L
.97593 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0000;oool306Ko6Oooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooo06Ko00000`1Vo`;oool00`1Vooooooooo`0?
oooo100000Goool00`000?ooooooo`0Doooo100000Coool300005C?o00@00004<ol000<0000co`0c
o`006S?o00030000<ol0<ol001dco`00100003?o03?o03?o0080000Koooo00<0003oooooool09Ooo
o`006?ooo`030000oooooooo01coool0101Vo`000?ooo`0000Goool00`1Vooooooooo`0Eoooo00@0
003oooooool0000Loooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o00030000
<ol0<ol000<co`0300005_ooo`040000oooooooo00009_ooo`006?ooo`<0000Foooo1P1Vo`;oool2
00001Oooo`0306Kooooooooo01Koool200006oooo`D0000N<ol00P0001`co`000`0003?o03?o000L
<ol00P0000Pco`0400004oooo`80000Woooo000Yoooo201Vo`ooool00`1Vooooooooo`0aoooo0P00
044co`000`0003?o03?o000Z<ol00`0003Woool002?oool606Ko5oooo`0306Kooooooooo02goool4
0000@c?o0080000^<ol00P0003Ooool001coool706Ko7Oooo`0306Kooooooooo02Soool50000Ac?o
00030000<ol0<ol002lco`040000<oooo`005_ooo`H0I_lToooo00<0I_ooooooool07_ooo`X0001<
<ol000<0000co`0co`00<c?o00X0000Yoooo0010oooo00<0I_ooooooool04oooo`/0001F<ol000<0
000co`0co`00?C?o00l0000Joooo000@ooooo`00017oool001Koool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00Coool010000?ooooooool0V@;oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool04_ooo`005_ooo`030000oooooooo01goool00`000?ooooooo`07oooo00?o09Woooooool05?oo
o`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo
01goool00`000?ooooooo`0Noooo00<0003oooooool09Oooo`00@?ooo`03o`2Ioooooooo07Coool0
0`000?ooooooo`1Voooo0010oooo00?o09Woooooool0M?ooo`030000oooooooo06Koool0043oool0
0ol0VOooooooo`1doooo0P0006Ooool0043oool00ol0VOooooooo`1doooo00<0003oooooool0I_oo
o`00@?ooo`03o`2Ioooooooo07Coool00`000?ooooooo`1Voooo0010oooo00?o09Woooooool0M?oo
o`030000oooooooo06Koool0043oool00ol0VOooooooo`1doooo0P0006Ooool0043oool00ol0VOoo
ooooo`1doooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool00`000?ooooooo`1V
oooo0010oooo00?o09Woooooool0M?ooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1d
oooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool20000Ioooo`00@?ooo`03o`2I
oooooooo07Coool00`000?ooooooo`1Voooo0010oooo00?o09Woooooool0M?ooo`030000oooooooo
06Koool0043oool00ol0VOooooooo`1doooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo
07Coool20000Ioooo`00@?ooo`03o`2Ioooooooo07Coool00`000?ooooooo`1Voooo0010oooo00?o
09Woooooool0M?ooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1/oooo1@0000?oool0
0`000?ooooooo`1Voooo0010oooo00?o09Woooooool0K_ooo`030000oooooooo00?oool00`000?oo
ooooo`1Voooo0010oooo00?o09Woooooool0K_ooo`030000oooooooo00?oool30000I_ooo`00@?oo
o`03o`2Ioooooooo06koool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00@?ooo`03o`2I
oooooooo06koool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo
06goool200001Oooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1doooo0P0006Ooool0
043oool00ol0VOooooooo`1doooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool0
0`000?ooooooo`1Voooo0010oooo00?o09Woooooool0M?ooo`030000oooooooo06Koool0043oool0
0ol0VOooooooo`1doooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool20000Iooo
o`00@?ooo`03o`2Ioooooooo07Coool00`000?ooooooo`1Voooo0010oooo00?o09Woooooool0M?oo
o`030000oooooooo06Koool0043oool00ol0VOooooooo`1doooo00<0003oooooool0I_ooo`00@?oo
o`03o`2Ioooooooo07Coool20000Ioooo`00@?ooo`03o`2Ioooooooo07Coool00`000?ooooooo`1V
oooo0010oooo00?o09Woooooool0M?ooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1d
oooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool00`000?ooooooo`1Voooo0010
oooo00?o09Woooooool0M?ooo`80001Woooo0010oooo00?o09Woooooool0M?ooo`030000oooooooo
06Koool0043oool00ol0VOooooooo`1/oooo100000Coool00`000?ooooooo`1Voooo0010oooo00?o
09Woooooool0K?ooo`030000oooooooo00Goool00`000?ooooooo`1Voooo0010oooo00?o09Wooooo
ool0KOooo`030000oooooooo00Coool30000I_ooo`00@?ooo`03o`2Ioooooooo06koool00`000?oo
ooooo`03oooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo06coool010000?ooooooo`00
00Coool00`000?ooooooo`1Voooo0010oooo00?o09Woooooool0KOooo`800005oooo00<0003ooooo
ool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool20000Ioooo`00@?ooo`03o`2Ioooooooo07Coool0
0`000?ooooooo`1Voooo0010oooo00?o09Woooooool0M?ooo`030000oooooooo06Koool0043oool0
0ol0VOooooooo`1doooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool00`000?oo
ooooo`1Voooo0010oooo00?o09Woooooool0M?ooo`80001Woooo0010oooo00?o09Woooooool0M?oo
o`030000oooooooo06Koool0043oool00ol0VOooooooo`1doooo00<0003oooooool0I_ooo`00@?oo
o`03o`2Ioooooooo07Coool00`000?ooooooo`1Voooo0010oooo00?o09Woooooool0M?ooo`80001W
oooo0010oooo00?o09Woooooool0M?ooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1d
oooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool00`000?ooooooo`1Voooo0010
oooo00?o09Woooooool0M?ooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1doooo0P00
06Ooool0043oool00ol0VOooooooo`1doooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo
06goool200001Oooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1/oooo00@0003ooooo
ool00004oooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo06koool00`000?ooooooo`03
oooo0`0006Koool0043oool00ol0VOooooooo`1_oooo00<0003oooooool00_ooo`030000oooooooo
06Koool0043oool00ol0VOooooooo`1/oooo00@0003oooooool00004oooo00<0003oooooool0I_oo
o`00@?ooo`03o`2Ioooooooo06goool200001Oooo`030000oooooooo06Koool0043oool00ol0VOoo
ooooo`1doooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool20000Ioooo`00@?oo
o`03o`2Ioooooooo07Coool00`000?ooooooo`1Voooo0010oooo00?o09Woooooool0M?ooo`030000
oooooooo06Koool0043oool00ol0VOooooooo`1doooo00<0003oooooool0I_ooo`00@?ooo`03o`2I
oooooooo07Coool20000Ioooo`00@?ooo`03o`2Ioooooooo07Coool00`000?ooooooo`1Voooo0010
oooo00?o09Woooooool0M?ooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1doooo00<0
003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool00`000?ooooooo`1Voooo0010oooo00?o
09Woooooool0M?ooo`80001Woooo0010oooo00?o09Woooooool0M?ooo`030000oooooooo06Koool0
043oool00ol0VOooooooo`1doooo00<0003oooooool0I_ooo`00@?ooo`03o`2Ioooooooo07Coool0
0`000?ooooooo`1Voooo0010oooo00?o09Woooooool0M?ooo`80001Woooo0010oooo00?o09Wooooo
ool0M?ooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1doooo00<0003oooooool0I_oo
o`00@?ooo`03o`2Ioooooooo06koool300000oooo`030000oooooooo06Koool0043oool00ol0VOoo
ooooo`1_oooo00<0003oooooool00_ooo`030000oooooooo06Koool0043oool00ol0VOooooooo`1/
oooo1@0000?oool30000I_ooo`00[oooo`040000oooooooo0000KOooo`00/?ooo`030000oooo0000
06goool00;7oool20000KOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000
oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1000
00?oool200001Oooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool00`000?oo
ooooo`0;oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05?ooo`030000oooooooo00[oool00`000?ooooooo`03oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool02_ooo`050000oooooooo
oooo000007[oool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002Ooo
o`@00002oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.16408 .26487 L
.18221 .26487 L
.18703 .26487 L
.19227 .26487 L
.19467 .26487 L
.19721 .26487 L
.19939 .26487 L
.20062 .26487 L
s
.20062 .26487 m
.20109 .61803 L
s
0 .4 1 r
.02381 .25565 m
.06244 .25237 L
.10458 .24745 L
.14415 .24109 L
.16408 .23705 L
.18221 .23279 L
.18703 .23156 L
.19227 .23016 L
.19467 .2295 L
.19721 .22878 L
.19939 .22816 L
.20062 .2278 L
.20178 .26487 L
.20307 .26487 L
.20448 .26487 L
.20705 .26487 L
.21187 .26487 L
.22272 .26487 L
.26336 .26487 L
.30249 .26487 L
.34407 .26487 L
.38414 .26487 L
.42269 .26487 L
.46369 .26487 L
.50318 .26487 L
.54115 .26487 L
.58158 .26487 L
.62049 .26487 L
.66185 .26487 L
.70169 .26487 L
.74002 .26487 L
.7808 .26487 L
.82007 .26487 L
.85782 .26487 L
.89802 .26487 L
.93671 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0000Goool306Ko5_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00000_ooo`@0I_l2oooo00<0I_oooooo
ool03?ooo`@00005oooo00<0003oooooool05?ooo`@00004oooo0`0001Dco`04000013?o00030000
<ol0<ol001Xco`000`0003?o03?o000M<ol000@0000co`0co`0co`0200006oooo`030000oooooooo
02Goool001Soool00`000?ooooooo`0Moooo00<00000I_l000000P1Vo`Koool00`1Vooooooooo`0B
oooo00@0003oooooool0000Loooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o
00030000<ol0<ol000<co`0300005_ooo`040000oooooooo00009_ooo`006?ooo`<0000Hoooo1@1V
o`03oooo0000000000Soool00`1Vooooooooo`0Coooo0P0001_oool500007S?o0080000L<ol000<0
000co`0co`0073?o00800008<ol0100001?oool200009oooo`00;_ooo`D0I_l@oooo00<0I_oooooo
ool0;_ooo`800011<ol000<0000co`0co`00:S?o00<0000ioooo000Voooo201VoaGoool00`1Voooo
ooooo`0Zoooo100004<co`020000;S?o0080000goooo000Loooo2P1Voagoool00`1Vooooooooo`0U
oooo1@0004Lco`000`0003?o03?o000_<ol0100003?oool001Koool606Ko9oooo`0306Kooooooooo
01_oool:0000C3?o00030000<ol0<ol003<co`0:0000:Oooo`00@oooo`0306Kooooooooo013oool;
0000ES?o00030000<ol0<ol003dco`0?00006_ooo`004?ooool0000Aoooo000Foooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`0Boooo000Foooo00<0003oooooool07Oooo`030000oooooooo00[oool00ol0VOoo
ooooo`0Aoooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0
003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`0Uoooo0013oooo00?o09Wooooo
ool0LOooo`030000oooooooo06Koool004?oool00ol0VOooooooo`1aoooo00<0003oooooool0I_oo
o`00@oooo`03o`2Ioooooooo077oool20000Ioooo`00@oooo`03o`2Ioooooooo077oool00`000?oo
ooooo`1Voooo0013oooo00?o09Woooooool0LOooo`030000oooooooo06Koool004?oool00ol0VOoo
ooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo077oool20000Ioooo`00@ooo
o`03o`2Ioooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0LOooo`030000
oooooooo06Koool004?oool00ol0VOooooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2I
oooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0LOooo`80001Woooo0013
oooo00?o09Woooooool0LOooo`030000oooooooo06Koool004?oool00ol0VOooooooo`1aoooo00<0
003oooooool0I_ooo`00@oooo`03o`2Ioooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o
09Woooooool0LOooo`80001Woooo0013oooo00?o09Woooooool0LOooo`030000oooooooo06Koool0
04?oool00ol0VOooooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo06Woool5
00000oooo`030000oooooooo06Koool004?oool00ol0VOooooooo`1[oooo00<0003oooooool00ooo
o`030000oooooooo06Koool004?oool00ol0VOooooooo`1[oooo00<0003oooooool00oooo`<0001V
oooo0013oooo00?o09Woooooool0Joooo`030000oooooooo00?oool00`000?ooooooo`1Voooo0013
oooo00?o09Woooooool0Joooo`030000oooooooo00?oool00`000?ooooooo`1Voooo0013oooo00?o
09Woooooool0J_ooo`800005oooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo077oool2
0000Ioooo`00@oooo`03o`2Ioooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o09Wooooo
ool0LOooo`030000oooooooo06Koool004?oool00ol0VOooooooo`1aoooo00<0003oooooool0I_oo
o`00@oooo`03o`2Ioooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0LOoo
o`80001Woooo0013oooo00?o09Woooooool0LOooo`030000oooooooo06Koool004?oool00ol0VOoo
ooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo077oool00`000?ooooooo`1V
oooo0013oooo00?o09Woooooool0LOooo`80001Woooo0013oooo00?o09Woooooool0LOooo`030000
oooooooo06Koool004?oool00ol0VOooooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2I
oooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0LOooo`030000oooooooo
06Koool004?oool00ol0VOooooooo`1aoooo0P0006Ooool004?oool00ol0VOooooooo`1aoooo00<0
003oooooool0I_ooo`00@oooo`03o`2Ioooooooo06Woool400001?ooo`030000oooooooo06Koool0
04?oool00ol0VOooooooo`1Yoooo00<0003oooooool01Oooo`030000oooooooo06Koool004?oool0
0ol0VOooooooo`1Zoooo00<0003oooooool01?ooo`<0001Voooo0013oooo00?o09Woooooool0Jooo
o`030000oooooooo00?oool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0JOooo`040000
oooooooo00001?ooo`030000oooooooo06Koool004?oool00ol0VOooooooo`1Zoooo0P0000Goool0
0`000?ooooooo`1Voooo0013oooo00?o09Woooooool0LOooo`80001Woooo0013oooo00?o09Wooooo
ool0LOooo`030000oooooooo06Koool004?oool00ol0VOooooooo`1aoooo00<0003oooooool0I_oo
o`00@oooo`03o`2Ioooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0LOoo
o`030000oooooooo06Koool004?oool00ol0VOooooooo`1aoooo0P0006Ooool004?oool00ol0VOoo
ooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo077oool00`000?ooooooo`1V
oooo0013oooo00?o09Woooooool0LOooo`030000oooooooo06Koool004?oool00ol0VOooooooo`1a
oooo0P0006Ooool004?oool00ol0VOooooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2I
oooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0LOooo`030000oooooooo
06Koool004?oool00ol0VOooooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo
077oool20000Ioooo`00@oooo`03o`2Ioooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o
09Woooooool0J_ooo`800005oooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo06Woool0
10000?ooooooo`0000Coool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0Joooo`030000
oooooooo00?oool30000I_ooo`00@oooo`03o`2Ioooooooo06coool00`000?ooooooo`02oooo00<0
003oooooool0I_ooo`00@oooo`03o`2Ioooooooo06Woool010000?ooooooo`0000Coool00`000?oo
ooooo`1Voooo0013oooo00?o09Woooooool0J_ooo`800005oooo00<0003oooooool0I_ooo`00@ooo
o`03o`2Ioooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0LOooo`80001W
oooo0013oooo00?o09Woooooool0LOooo`030000oooooooo06Koool004?oool00ol0VOooooooo`1a
oooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo077oool00`000?ooooooo`1Voooo0013
oooo00?o09Woooooool0LOooo`80001Woooo0013oooo00?o09Woooooool0LOooo`030000oooooooo
06Koool004?oool00ol0VOooooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo
077oool00`000?ooooooo`1Voooo0013oooo00?o09Woooooool0LOooo`030000oooooooo06Koool0
04?oool00ol0VOooooooo`1aoooo0P0006Ooool004?oool00ol0VOooooooo`1aoooo00<0003ooooo
ool0I_ooo`00@oooo`03o`2Ioooooooo077oool00`000?ooooooo`1Voooo0013oooo00?o09Wooooo
ool0LOooo`030000oooooooo06Koool004?oool00ol0VOooooooo`1aoooo0P0006Ooool004?oool0
0ol0VOooooooo`1aoooo00<0003oooooool0I_ooo`00@oooo`03o`2Ioooooooo077oool00`000?oo
ooooo`1Voooo0013oooo00?o09Woooooool0Joooo`<00003oooo00<0003oooooool0I_ooo`00@ooo
o`03o`2Ioooooooo06coool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00@oooo`03o`2I
oooooooo06Woool500000oooo`<0001Voooo002_oooo00@0003oooooool0001]oooo002`oooo00<0
003oool00000KOooo`00/Oooo`80001]oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?oo
ooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0O
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool400000oooo`800003oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool00`000?oo
ooooo`09oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo
00;oool00`000?ooooooo`0Doooo00<0003oooooool02?ooo`040000oooooooo00001?ooo`030000
oooooooo07Ooool007Soool00`000?ooooooo`0500005?ooo`030000oooooooo00Ooool300001?oo
o`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00009
oooo00<0003oooooool00oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P00
00[oool300000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.20178 .26487 L
.20742 .26487 L
.21019 .26487 L
.2114 .26487 L
.21274 .26487 L
.21394 .26487 L
s
.21394 .26487 m
.21439 .61803 L
s
0 .4 1 r
.02381 .25654 m
.06244 .25357 L
.10458 .24913 L
.14415 .24338 L
.18221 .23588 L
.20178 .23107 L
.20742 .22954 L
.21019 .22876 L
.2114 .22841 L
.21274 .22803 L
.21394 .22768 L
.21506 .26487 L
.21625 .26487 L
.21753 .26487 L
.22272 .26487 L
.26394 .26487 L
.30365 .26487 L
.34184 .26487 L
.38249 .26487 L
.42162 .26487 L
.4632 .26487 L
.50327 .26487 L
.54182 .26487 L
.58282 .26487 L
.62231 .26487 L
.66028 .26487 L
.7007 .26487 L
.73961 .26487 L
.78097 .26487 L
.82082 .26487 L
.85915 .26487 L
.89993 .26487 L
.9392 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0000Woool206Ko4oooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00001_ooo`@0I_l00oooo`1Vooooo`0:
oooo100000Goool00`000?ooooooo`0Doooo100000Coool300005C?o00@00004<ol000<0000co`0c
o`006S?o00030000<ol0<ol001dco`00100003?o03?o03?o0080000Koooo00<0003oooooool09Ooo
o`006?ooo`030000oooooooo01goool010000?ooo`000?ooo`D0I_l5oooo00<0I_ooooooool03ooo
o`040000oooooooo00007?ooo`@0000N<ol000<0000co`0co`006S?o00030000<ol0<ol001dco`00
0`0003?o03?o0003<ol00`0001Koool010000?ooooooo`0002Koool001Soool300007Oooo`0406Ko
0000000006Ko2_ooo`0306Kooooooooo013oool200006oooo`D0000N<ol00P0001`co`000`0003?o
03?o000L<ol00P0000Pco`0400004oooo`80000Woooo000aoooo1`1Vo`koool00`1Vooooooooo`0[
oooo0P00044co`000`0003?o03?o000Z<ol00`0003Woool002Koool;06Ko5_ooo`0306Kooooooooo
02Koool40000@c?o0080000^<ol00P0003Ooool001coool:06Ko8Oooo`0306Kooooooooo027oool5
0000Ac?o00030000<ol0<ol002lco`040000<oooo`005_ooo`H0I_l[oooo00<0I_ooooooool05ooo
o`X0001<<ol000<0000co`0co`00<c?o00X0000Yoooo0017oooo00<0I_ooooooool03?ooo`/0001F
<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00017oool001Koool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00@0003ooooooooo09T3oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool04_ooo`005_ooo`030000oooooooo01goool00`000?ooooooo`0=oooo00?o09Wooooo
ool03_ooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000
oooooooo01goool00`000?ooooooo`0Noooo00<0003oooooool09Oooo`00A_ooo`03o`2Ioooooooo
06koool00`000?ooooooo`1Voooo0016oooo00?o09Woooooool0K_ooo`030000oooooooo06Koool0
04Koool00ol0VOooooooo`1^oooo0P0006Ooool004Koool00ol0VOooooooo`1^oooo00<0003ooooo
ool0I_ooo`00A_ooo`03o`2Ioooooooo06koool00`000?ooooooo`1Voooo0016oooo00?o09Wooooo
ool0K_ooo`030000oooooooo06Koool004Koool00ol0VOooooooo`1^oooo0P0006Ooool004Koool0
0ol0VOooooooo`1^oooo00<0003oooooool0I_ooo`00A_ooo`03o`2Ioooooooo06koool00`000?oo
ooooo`1Voooo0016oooo00?o09Woooooool0K_ooo`030000oooooooo06Koool004Koool00ol0VOoo
ooooo`1^oooo00<0003oooooool0I_ooo`00A_ooo`03o`2Ioooooooo06koool20000Ioooo`00A_oo
o`03o`2Ioooooooo06koool00`000?ooooooo`1Voooo0016oooo00?o09Woooooool0K_ooo`030000
oooooooo06Koool004Koool00ol0VOooooooo`1^oooo00<0003oooooool0I_ooo`00A_ooo`03o`2I
oooooooo06koool20000Ioooo`00A_ooo`03o`2Ioooooooo06koool00`000?ooooooo`1Voooo0016
oooo00?o09Woooooool0K_ooo`030000oooooooo06Koool004Koool00ol0VOooooooo`1Voooo1@00
00?oool00`000?ooooooo`1Voooo0016oooo00?o09Woooooool0J?ooo`030000oooooooo00?oool0
0`000?ooooooo`1Voooo0016oooo00?o09Woooooool0J?ooo`030000oooooooo00?oool30000I_oo
o`00A_ooo`03o`2Ioooooooo06Soool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00A_oo
o`03o`2Ioooooooo06Soool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00A_ooo`03o`2I
oooooooo06Ooool200001Oooo`030000oooooooo06Koool004Koool00ol0VOooooooo`1^oooo0P00
06Ooool004Koool00ol0VOooooooo`1^oooo00<0003oooooool0I_ooo`00A_ooo`03o`2Ioooooooo
06koool00`000?ooooooo`1Voooo0016oooo00?o09Woooooool0K_ooo`030000oooooooo06Koool0
04Koool00ol0VOooooooo`1^oooo00<0003oooooool0I_ooo`00A_ooo`03o`2Ioooooooo06koool2
0000Ioooo`00A_ooo`03o`2Ioooooooo06koool00`000?ooooooo`1Voooo0016oooo00?o09Wooooo
ool0K_ooo`030000oooooooo06Koool004Koool00ol0VOooooooo`1^oooo00<0003oooooool0I_oo
o`00A_ooo`03o`2Ioooooooo06koool20000Ioooo`00A_ooo`03o`2Ioooooooo06koool00`000?oo
ooooo`1Voooo0016oooo00?o09Woooooool0K_ooo`030000oooooooo06Koool004Koool00ol0VOoo
ooooo`1^oooo00<0003oooooool0I_ooo`00A_ooo`03o`2Ioooooooo06koool00`000?ooooooo`1V
oooo0016oooo00?o09Woooooool0K_ooo`80001Woooo0016oooo00?o09Woooooool0K_ooo`030000
oooooooo06Koool004Koool00ol0VOooooooo`1Voooo100000Coool00`000?ooooooo`1Voooo0016
oooo00?o09Woooooool0I_ooo`030000oooooooo00Goool00`000?ooooooo`1Voooo0016oooo00?o
09Woooooool0Ioooo`030000oooooooo00Coool30000I_ooo`00Aoooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`03oooo00<0003oooooool0I_ooo`00Aoooo`03o`2Ioooooooo06Goool010000?oo
ooooo`0000Coool00`000?ooooooo`1Voooo0017oooo00?o09Woooooool0I_ooo`800005oooo00<0
003oooooool0I_ooo`00Aoooo`03o`2Ioooooooo06goool20000Ioooo`00Aoooo`03o`2Ioooooooo
06goool00`000?ooooooo`1Voooo0017oooo00?o09Woooooool0KOooo`030000oooooooo06Koool0
04Ooool00ol0VOooooooo`1]oooo00<0003oooooool0I_ooo`00Aoooo`03o`2Ioooooooo06goool0
0`000?ooooooo`1Voooo0017oooo00?o09Woooooool0KOooo`80001Woooo0017oooo00?o09Wooooo
ool0KOooo`030000oooooooo06Koool004Ooool00ol0VOooooooo`1]oooo00<0003oooooool0I_oo
o`00Aoooo`03o`2Ioooooooo06goool00`000?ooooooo`1Voooo0017oooo00?o09Woooooool0KOoo
o`80001Woooo0017oooo00?o09Woooooool0KOooo`030000oooooooo06Koool004Ooool00ol0VOoo
ooooo`1]oooo00<0003oooooool0I_ooo`00Aoooo`03o`2Ioooooooo06goool00`000?ooooooo`1V
oooo0017oooo00?o09Woooooool0KOooo`030000oooooooo06Koool004Ooool00ol0VOooooooo`1]
oooo0P0006Ooool004Ooool00ol0VOooooooo`1]oooo00<0003oooooool0I_ooo`00Aoooo`03o`2I
oooooooo06Koool200001Oooo`030000oooooooo06Koool004Ooool00ol0VOooooooo`1Uoooo00@0
003oooooool00004oooo00<0003oooooool0I_ooo`00Aoooo`03o`2Ioooooooo06Ooool00`000?oo
ooooo`03oooo0`0006Koool004Ooool00ol0VOooooooo`1Xoooo00<0003oooooool00_ooo`030000
oooooooo06Koool004Ooool00ol0VOooooooo`1Uoooo00@0003oooooool00004oooo00<0003ooooo
ool0I_ooo`00Aoooo`03o`2Ioooooooo06Koool200001Oooo`030000oooooooo06Koool004Ooool0
0ol0VOooooooo`1]oooo00<0003oooooool0I_ooo`00Aoooo`03o`2Ioooooooo06goool20000Iooo
o`00Aoooo`03o`2Ioooooooo06goool00`000?ooooooo`1Voooo0017oooo00?o09Woooooool0KOoo
o`030000oooooooo06Koool004Ooool00ol0VOooooooo`1]oooo00<0003oooooool0I_ooo`00Aooo
o`03o`2Ioooooooo06goool20000Ioooo`00Aoooo`03o`2Ioooooooo06goool00`000?ooooooo`1V
oooo0017oooo00?o09Woooooool0KOooo`030000oooooooo06Koool004Ooool00ol0VOooooooo`1]
oooo00<0003oooooool0I_ooo`00Aoooo`03o`2Ioooooooo06goool00`000?ooooooo`1Voooo0017
oooo00?o09Woooooool0KOooo`80001Woooo0017oooo00?o09Woooooool0KOooo`030000oooooooo
06Koool004Ooool00ol0VOooooooo`1]oooo00<0003oooooool0I_ooo`00Aoooo`03o`2Ioooooooo
06goool00`000?ooooooo`1Voooo0017oooo00?o09Woooooool0KOooo`80001Woooo0017oooo00?o
09Woooooool0KOooo`030000oooooooo06Koool004Ooool00ol0VOooooooo`1]oooo00<0003ooooo
ool0I_ooo`00Aoooo`03o`2Ioooooooo06Ooool300000oooo`030000oooooooo06Koool004Ooool0
0ol0VOooooooo`1Xoooo00<0003oooooool00_ooo`030000oooooooo06Koool004Ooool00ol0VOoo
ooooo`1Uoooo1@0000?oool30000I_ooo`00[oooo`040000oooooooo0000KOooo`00/?ooo`030000
oooo000006goool00;7oool20000KOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003ooooo
ool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07ooo
o`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<
oooo100000?oool200001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00<0003ooooo
ool02Oooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05?ooo`030000oooooooo00_oool00`000?ooooooo`02oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool02?ooo`800004oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool0
0`000?ooooooo`03oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_oo
o`<00002oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.20342 .26487 L
.21345 .26487 L
.21786 .26487 L
.22037 .26487 L
.22272 .26487 L
.22496 .26487 L
.22623 .26487 L
s
.22623 .26487 m
.22669 .61803 L
s
0 .4 1 r
.02381 .25734 m
.06244 .25466 L
.10458 .25065 L
.14415 .24545 L
.18221 .23868 L
.20342 .23393 L
.21345 .2314 L
.21786 .23022 L
.22037 .22953 L
.22272 .22887 L
.22496 .22823 L
.22623 .22787 L
.22738 .26487 L
.22859 .26487 L
.22992 .26487 L
.23233 .26487 L
.24276 .26487 L
.26171 .26487 L
.30236 .26487 L
.34148 .26487 L
.38307 .26487 L
.42313 .26487 L
.46168 .26487 L
.50269 .26487 L
.54217 .26487 L
.58015 .26487 L
.62057 .26487 L
.65948 .26487 L
.70084 .26487 L
.74069 .26487 L
.77902 .26487 L
.8198 .26487 L
.85906 .26487 L
.89681 .26487 L
.93702 .26487 L
.97571 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0000_oool406Ko3oooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00002?ooo`@0I_l3oooo00<0I_oooooo
ool01Oooo`@00005oooo00<0003oooooool05?ooo`@00004oooo0`0001Dco`04000013?o00030000
<ol0<ol001Xco`000`0003?o03?o000M<ol000@0000co`0co`0co`0200006oooo`030000oooooooo
02Goool001Soool00`000?ooooooo`0Moooo00<0003oool000001Oooo`<0I_l7oooo00<0I_oooooo
ool02oooo`040000oooooooo00007?ooo`@0000N<ol000<0000co`0co`006S?o00030000<ol0<ol0
01dco`000`0003?o03?o0003<ol00`0001Koool010000?ooooooo`0002Koool001Soool300007_oo
o`80000506Ko2_ooo`0306Kooooooooo00coool200006oooo`D0000N<ol00P0001`co`000`0003?o
03?o000L<ol00P0000Pco`0400004oooo`80000Woooo000coooo1`1Voa3oool00`1Vooooooooo`0W
oooo0P00044co`000`0003?o03?o000Z<ol00`0003Woool002koool506Ko5oooo`0306Kooooooooo
02?oool40000@c?o0080000^<ol00P0003Ooool002Koool806Ko7?ooo`0306Kooooooooo01koool5
0000Ac?o00030000<ol0<ol002lco`040000<oooo`005_oooa00I_lToooo00<0I_ooooooool05?oo
o`X0001<<ol000<0000co`0co`00<c?o00X0000Yoooo001:oooo00<0I_ooooooool02Oooo`/0001F
<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00017oool001Koool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo01;oool001Koool00`000?ooooooo`0Moooo00<0003oooooool04Oooo`03o`2Ioooooooo
00[oool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?oo
ooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo02Goool004[oool00ol0VOooooooo`1Z
oooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`1Voooo001:
oooo00?o09Woooooool0J_ooo`80001Woooo001:oooo00?o09Woooooool0J_ooo`030000oooooooo
06Koool004[oool00ol0VOooooooo`1Zoooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo
06[oool00`000?ooooooo`1Voooo001:oooo00?o09Woooooool0J_ooo`80001Woooo001:oooo00?o
09Woooooool0J_ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Zoooo00<0003ooooo
ool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`1Voooo001:oooo00?o09Wooooo
ool0J_ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Zoooo0P0006Ooool004[oool0
0ol0VOooooooo`1Zoooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool00`000?oo
ooooo`1Voooo001:oooo00?o09Woooooool0J_ooo`030000oooooooo06Koool004[oool00ol0VOoo
ooooo`1Zoooo0P0006Ooool004[oool00ol0VOooooooo`1Zoooo00<0003oooooool0I_ooo`00B_oo
o`03o`2Ioooooooo06[oool00`000?ooooooo`1Voooo001:oooo00?o09Woooooool0H_ooo`D00003
oooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06Coool00`000?ooooooo`03oooo00<0
003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06Coool00`000?ooooooo`03oooo0`0006Koool0
04[oool00ol0VOooooooo`1Toooo00<0003oooooool00oooo`030000oooooooo06Koool004[oool0
0ol0VOooooooo`1Toooo00<0003oooooool00oooo`030000oooooooo06Koool004[oool00ol0VOoo
ooooo`1Soooo0P0000Goool00`000?ooooooo`1Voooo001:oooo00?o09Woooooool0J_ooo`80001W
oooo001:oooo00?o09Woooooool0J_ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Z
oooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`1Voooo001:
oooo00?o09Woooooool0J_ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Zoooo0P00
06Ooool004[oool00ol0VOooooooo`1Zoooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo
06[oool00`000?ooooooo`1Voooo001:oooo00?o09Woooooool0J_ooo`030000oooooooo06Koool0
04[oool00ol0VOooooooo`1Zoooo0P0006Ooool004[oool00ol0VOooooooo`1Zoooo00<0003ooooo
ool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`1Voooo001:oooo00?o09Wooooo
ool0J_ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Zoooo00<0003oooooool0I_oo
o`00B_ooo`03o`2Ioooooooo06[oool20000Ioooo`00B_ooo`03o`2Ioooooooo06[oool00`000?oo
ooooo`1Voooo001:oooo00?o09Woooooool0H_ooo`@00004oooo00<0003oooooool0I_ooo`00B_oo
o`03o`2Ioooooooo06;oool00`000?ooooooo`05oooo00<0003oooooool0I_ooo`00B_ooo`03o`2I
oooooooo06?oool00`000?ooooooo`04oooo0`0006Koool004[oool00ol0VOooooooo`1Toooo00<0
003oooooool00oooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Roooo00@0003ooooo
ool00004oooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06?oool200001Oooo`030000
oooooooo06Koool004[oool00ol0VOooooooo`1Zoooo0P0006Ooool004[oool00ol0VOooooooo`1Z
oooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`1Voooo001:
oooo00?o09Woooooool0J_ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Zoooo00<0
003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool20000Ioooo`00B_ooo`03o`2Ioooooooo
06[oool00`000?ooooooo`1Voooo001:oooo00?o09Woooooool0J_ooo`030000oooooooo06Koool0
04[oool00ol0VOooooooo`1Zoooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool2
0000Ioooo`00B_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`1Voooo001:oooo00?o09Wooooo
ool0J_ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Zoooo00<0003oooooool0I_oo
o`00B_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`1Voooo001:oooo00?o09Woooooool0J_oo
o`80001Woooo001:oooo00?o09Woooooool0J_ooo`030000oooooooo06Koool004[oool00ol0VOoo
ooooo`1Soooo0P0000Goool00`000?ooooooo`1Voooo001:oooo00?o09Woooooool0H_ooo`040000
oooooooo00001?ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Toooo00<0003ooooo
ool00oooo`<0001Voooo001:oooo00?o09Woooooool0IOooo`030000oooooooo00;oool00`000?oo
ooooo`1Voooo001:oooo00?o09Woooooool0H_ooo`040000oooooooo00001?ooo`030000oooooooo
06Koool004[oool00ol0VOooooooo`1Soooo0P0000Goool00`000?ooooooo`1Voooo001:oooo00?o
09Woooooool0J_ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Zoooo0P0006Ooool0
04[oool00ol0VOooooooo`1Zoooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool0
0`000?ooooooo`1Voooo001:oooo00?o09Woooooool0J_ooo`030000oooooooo06Koool004[oool0
0ol0VOooooooo`1Zoooo0P0006Ooool004[oool00ol0VOooooooo`1Zoooo00<0003oooooool0I_oo
o`00B_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`1Voooo001:oooo00?o09Woooooool0J_oo
o`030000oooooooo06Koool004[oool00ol0VOooooooo`1Zoooo00<0003oooooool0I_ooo`00B_oo
o`03o`2Ioooooooo06[oool20000Ioooo`00B_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`1V
oooo001:oooo00?o09Woooooool0J_ooo`030000oooooooo06Koool004[oool00ol0VOooooooo`1Z
oooo00<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo06[oool20000Ioooo`00B_ooo`03o`2I
oooooooo06[oool00`000?ooooooo`1Voooo001:oooo00?o09Woooooool0J_ooo`030000oooooooo
06Koool004[oool00ol0VOooooooo`1Toooo0`0000?oool00`000?ooooooo`1Voooo001:oooo00?o
09Woooooool0IOooo`030000oooooooo00;oool00`000?ooooooo`1Voooo001:oooo00?o09Wooooo
ool0H_ooo`D00003oooo0`0006Koool00:ooool010000?ooooooo`0006goool00;3oool00`000?oo
o`00001]oooo002aoooo0P0006goool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?oo
o`@00003oooo0P0000Goool300000_ooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`030000oooooooo
00coool01@000?ooooooooooo`00001joooo001goooo00<0003oooooool00_ooo`030000oooooooo
01Coool00`000?ooooooo`08oooo1@0000?oool00`000?ooooooo`1goooo001hoooo00<0003ooooo
ool01@0001Coool00`000?ooooooo`07oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooo`000003
oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002oooo`800002oooo00<0
003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.20342 .26487 L
.22272 .26487 L
.23233 .26487 L
.23496 .26487 L
.2364 .26487 L
.23775 .26487 L
.2389 .26487 L
s
.2389 .26487 m
.2394 .61803 L
s
0 .4 1 r
.02381 .25807 m
.06244 .25565 L
.10458 .25203 L
.14415 .24733 L
.18221 .24122 L
.20342 .23693 L
.22272 .23236 L
.23233 .22982 L
.23496 .22908 L
.2364 .22868 L
.23775 .22829 L
.2389 .22796 L
.24014 .26487 L
.24084 .26487 L
.24151 .26487 L
.24276 .26487 L
.26171 .26487 L
.2999 .26487 L
.34055 .26487 L
.37968 .26487 L
.42126 .26487 L
.46133 .26487 L
.49988 .26487 L
.54088 .26487 L
.58037 .26487 L
.61834 .26487 L
.65876 .26487 L
.69767 .26487 L
.73903 .26487 L
.77888 .26487 L
.81721 .26487 L
.85799 .26487 L
.89726 .26487 L
.93501 .26487 L
.97521 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0000ooool306Ko3?ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00003?ooo`@0I_l2oooo00<0I_oooooo
ool00_ooo`@00005oooo00<0003oooooool05?ooo`@00004oooo0`0001Dco`04000013?o00030000
<ol0<ol001Xco`000`0003?o03?o000M<ol000@0000co`0co`0co`0200006oooo`030000oooooooo
02Goool001Soool00`000?ooooooo`0Moooo00<0003oool000001oooo`D0I_l6oooo00<0I_oooooo
ool02?ooo`040000oooooooo00007?ooo`@0000N<ol000<0000co`0co`006S?o00030000<ol0<ol0
01dco`000`0003?o03?o0003<ol00`0001Koool010000?ooooooo`0002Koool001Soool300007_oo
o`8000000oooo`1Vo`1Vo`0406Ko2oooo`0306Kooooooooo00Woool200006oooo`D0000N<ol00P00
01`co`000`0003?o03?o000L<ol00P0000Pco`0400004oooo`80000Woooo000hoooo101Voa7oool0
0`1Vooooooooo`0Toooo0P00044co`000`0003?o03?o000Z<ol00`0003Woool0037oool706Ko5Ooo
o`0306Kooooooooo023oool40000@c?o0080000^<ol00P0003Ooool002Koool;06Ko7?ooo`0306Ko
oooooooo01_oool50000Ac?o00030000<ol0<ol002lco`040000<oooo`005_oooa00I_lWoooo00<0
I_ooooooool04Oooo`X0001<<ol000<0000co`0co`00<c?o00X0000Yoooo001=oooo00<0I_oooooo
ool01_ooo`/0001F<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00017oool001Koool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`040000ooooooooo`2I0_ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool04_ooo`005_ooo`030000oooooooo01goool00`000?ooooooo`0D
oooo00?o09Woooooool01oooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003ooooo
ool07Oooo`030000oooooooo01goool00`000?ooooooo`0Noooo00<0003oooooool09Oooo`00COoo
o`03o`2Ioooooooo06Ooool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`030000
oooooooo06Koool004goool00ol0VOooooooo`1Woooo0P0006Ooool004goool00ol0VOooooooo`1W
oooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo06Ooool00`000?ooooooo`1Voooo001=
oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool004goool00ol0VOooooooo`1Woooo0P00
06Ooool004goool00ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo
06Ooool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool0
04goool00ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo06Ooool2
0000Ioooo`00COooo`03o`2Ioooooooo06Ooool00`000?ooooooo`1Voooo001=oooo00?o09Wooooo
ool0Ioooo`030000oooooooo06Koool004goool00ol0VOooooooo`1Woooo00<0003oooooool0I_oo
o`00COooo`03o`2Ioooooooo06Ooool20000Ioooo`00COooo`03o`2Ioooooooo06Ooool00`000?oo
ooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool004goool00ol0VOoo
ooooo`1Ooooo1@0000?oool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0HOooo`030000
oooooooo00?oool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0HOooo`030000oooooooo
00?oool30000I_ooo`00COooo`03o`2Ioooooooo067oool00`000?ooooooo`03oooo00<0003ooooo
ool0I_ooo`00COooo`03o`2Ioooooooo067oool00`000?ooooooo`03oooo00<0003oooooool0I_oo
o`00COooo`03o`2Ioooooooo063oool200001Oooo`030000oooooooo06Koool004goool00ol0VOoo
ooooo`1Woooo0P0006Ooool004goool00ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COoo
o`03o`2Ioooooooo06Ooool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`030000
oooooooo06Koool004goool00ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COooo`03o`2I
oooooooo06Ooool20000Ioooo`00COooo`03o`2Ioooooooo06Ooool00`000?ooooooo`1Voooo001=
oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool004goool00ol0VOooooooo`1Woooo00<0
003oooooool0I_ooo`00COooo`03o`2Ioooooooo06Ooool20000Ioooo`00COooo`03o`2Ioooooooo
06Ooool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool0
04goool00ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`80001Woooo001=oooo00?o09Wooooo
ool0Ioooo`030000oooooooo06Koool004goool00ol0VOooooooo`1Ooooo100000Coool00`000?oo
ooooo`1Voooo001=oooo00?o09Woooooool0Goooo`030000oooooooo00Goool00`000?ooooooo`1V
oooo001=oooo00?o09Woooooool0H?ooo`030000oooooooo00Coool30000I_ooo`00COooo`03o`2I
oooooooo067oool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo
05ooool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0H?oo
o`800005oooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo06Ooool20000Ioooo`00COoo
o`03o`2Ioooooooo06Ooool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`030000
oooooooo06Koool004goool00ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COooo`03o`2I
oooooooo06Ooool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`80001Woooo001=
oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool004goool00ol0VOooooooo`1Woooo00<0
003oooooool0I_ooo`00COooo`03o`2Ioooooooo06Ooool00`000?ooooooo`1Voooo001=oooo00?o
09Woooooool0Ioooo`80001Woooo001=oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool0
04goool00ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool004goool0
0ol0VOooooooo`1Woooo0P0006Ooool004goool00ol0VOooooooo`1Woooo00<0003oooooool0I_oo
o`00COooo`03o`2Ioooooooo063oool200001Oooo`030000oooooooo06Koool004goool00ol0VOoo
ooooo`1Ooooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo
067oool00`000?ooooooo`03oooo0`0006Koool004goool00ol0VOooooooo`1Roooo00<0003ooooo
ool00_ooo`030000oooooooo06Koool004goool00ol0VOooooooo`1Ooooo00@0003oooooool00004
oooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo063oool200001Oooo`030000oooooooo
06Koool004goool00ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo
06Ooool20000Ioooo`00COooo`03o`2Ioooooooo06Ooool00`000?ooooooo`1Voooo001=oooo00?o
09Woooooool0Ioooo`030000oooooooo06Koool004goool00ol0VOooooooo`1Woooo00<0003ooooo
ool0I_ooo`00COooo`03o`2Ioooooooo06Ooool20000Ioooo`00COooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool004goool0
0ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo06Ooool00`000?oo
ooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`80001Woooo001=oooo00?o09Woooooool0Iooo
o`030000oooooooo06Koool004goool00ol0VOooooooo`1Woooo00<0003oooooool0I_ooo`00COoo
o`03o`2Ioooooooo06Ooool00`000?ooooooo`1Voooo001=oooo00?o09Woooooool0Ioooo`80001W
oooo001=oooo00?o09Woooooool0Ioooo`030000oooooooo06Koool004goool00ol0VOooooooo`1W
oooo00<0003oooooool0I_ooo`00COooo`03o`2Ioooooooo067oool300000oooo`030000oooooooo
06Koool004goool00ol0VOooooooo`1Roooo00<0003oooooool00_ooo`030000oooooooo06Koool0
04goool00ol0VOooooooo`1Ooooo1@0000?oool30000I_ooo`00[oooo`040000oooooooo0000KOoo
o`00/?ooo`030000oooo000006goool00;7oool20000KOooo`00ooooob7oool00?oooolQoooo001i
oooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0
003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool0
0`000?ooooooo`0<oooo100000?oool200001?ooo`800004oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003
oooo00<0003oooooool02Oooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool0
0`000?ooooooo`02oooo00<0003oooooool05?ooo`030000oooooooo00[oool00`000?ooooooo`03
oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool02_oo
o`050000oooooooooooo000007[oool007Soool01@000?ooooooooooo`00000Eoooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo
01Ooool200002_ooo`800003oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.20342 .26487 L
.22272 .26487 L
.23233 .26487 L
.23739 .26487 L
.24276 .26487 L
.24745 .26487 L
.24873 .26487 L
.25012 .26487 L
.25142 .26487 L
s
.25142 .26487 m
.2519 .61803 L
s
0 .4 1 r
.02381 .25873 m
.06244 .25655 L
.10458 .25327 L
.14415 .24904 L
.18221 .24352 L
.20342 .23964 L
.22272 .23552 L
.23233 .23322 L
.23739 .23194 L
.24276 .23053 L
.24745 .22924 L
.24873 .22888 L
.25012 .22849 L
.25142 .22812 L
.25261 .26487 L
.25377 .26487 L
.25484 .26487 L
.25728 .26487 L
.26171 .26487 L
.30084 .26487 L
.34242 .26487 L
.38249 .26487 L
.42104 .26487 L
.46204 .26487 L
.50153 .26487 L
.5395 .26487 L
.57993 .26487 L
.61883 .26487 L
.6602 .26487 L
.70004 .26487 L
.73837 .26487 L
.77915 .26487 L
.81842 .26487 L
.85617 .26487 L
.89637 .26487 L
.93506 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001?oool206Ko2Oooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00004?ooo`@0I_l00oooo`1Vooooo`04
00001Oooo`030000oooooooo01Coool400001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J
<ol000<0000co`0co`007C?o00040000<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000H
oooo00<0003oooooool07Oooo`030000oooo000000coool406Ko1Oooo`0306Kooooooooo00Goool0
10000?ooooooo`0001coool400007S?o00030000<ol0<ol001Xco`000`0003?o03?o000M<ol000<0
000co`0co`000c?o00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`0001koool200001ooo
o`D0I_l9oooo00<0I_ooooooool01_ooo`80000Koooo1@0001hco`02000073?o00030000<ol0<ol0
01`co`02000023?o00@0000Coooo0P0002Ooool003[oool806Ko3_ooo`0306Kooooooooo027oool2
0000@C?o00030000<ol0<ol002Xco`030000>Oooo`00<Oooo`T0I_lFoooo00<0I_ooooooool07Ooo
o`@00013<ol00P0002hco`020000=oooo`009_ooo`/0I_lOoooo00<0I_ooooooool06?ooo`D00017
<ol000<0000co`0co`00;c?o00@0000coooo000Loooo2P1Vob[oool00`1Vooooooooo`0>oooo2P00
04`co`000`0003?o03?o000c<ol02P0002Woool001Koool606Ko=?ooo`0306Kooooooooo00?oool;
0000ES?o00030000<ol0<ol003dco`0?00006_ooo`004?ooool0000Aoooo000Foooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`0Boooo000Foooo00<0003oooooool07Oooo`030000oooooooo01Ooool00ol0VOoo
ooooo`04oooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0
003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`0Uoooo001@oooo00?o09Wooooo
ool0I?ooo`030000oooooooo06Koool0053oool00ol0VOooooooo`1Toooo00<0003oooooool0I_oo
o`00D?ooo`03o`2Ioooooooo06Coool20000Ioooo`00D?ooo`03o`2Ioooooooo06Coool00`000?oo
ooooo`1Voooo001@oooo00?o09Woooooool0I?ooo`030000oooooooo06Koool0053oool00ol0VOoo
ooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo06Coool20000Ioooo`00D?oo
o`03o`2Ioooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0I?ooo`030000
oooooooo06Koool0053oool00ol0VOooooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2I
oooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0I?ooo`80001Woooo001@
oooo00?o09Woooooool0I?ooo`030000oooooooo06Koool0053oool00ol0VOooooooo`1Toooo00<0
003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o
09Woooooool0I?ooo`80001Woooo001@oooo00?o09Woooooool0I?ooo`030000oooooooo06Koool0
053oool00ol0VOooooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo05coool5
00000oooo`030000oooooooo06Koool0053oool00ol0VOooooooo`1Noooo00<0003oooooool00ooo
o`030000oooooooo06Koool0053oool00ol0VOooooooo`1Noooo00<0003oooooool00oooo`<0001V
oooo001@oooo00?o09Woooooool0G_ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001@
oooo00?o09Woooooool0G_ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001@oooo00?o
09Woooooool0GOooo`800005oooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo06Coool2
0000Ioooo`00D?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o09Wooooo
ool0I?ooo`030000oooooooo06Koool0053oool00ol0VOooooooo`1Toooo00<0003oooooool0I_oo
o`00D?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0I?oo
o`80001Woooo001@oooo00?o09Woooooool0I?ooo`030000oooooooo06Koool0053oool00ol0VOoo
ooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`1V
oooo001@oooo00?o09Woooooool0I?ooo`80001Woooo001@oooo00?o09Woooooool0I?ooo`030000
oooooooo06Koool0053oool00ol0VOooooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2I
oooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0I?ooo`030000oooooooo
06Koool0053oool00ol0VOooooooo`1Toooo0P0006Ooool0053oool00ol0VOooooooo`1Toooo00<0
003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo05coool400001?ooo`030000oooooooo06Koool0
053oool00ol0VOooooooo`1Loooo00<0003oooooool01Oooo`030000oooooooo06Koool0053oool0
0ol0VOooooooo`1Moooo00<0003oooooool01?ooo`<0001Voooo001@oooo00?o09Woooooool0G_oo
o`030000oooooooo00?oool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0G?ooo`040000
oooooooo00001?ooo`030000oooooooo06Koool0053oool00ol0VOooooooo`1Moooo0P0000Goool0
0`000?ooooooo`1Voooo001@oooo00?o09Woooooool0I?ooo`80001Woooo001@oooo00?o09Wooooo
ool0I?ooo`030000oooooooo06Koool0053oool00ol0VOooooooo`1Toooo00<0003oooooool0I_oo
o`00D?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0I?oo
o`030000oooooooo06Koool0053oool00ol0VOooooooo`1Toooo0P0006Ooool0053oool00ol0VOoo
ooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`1V
oooo001@oooo00?o09Woooooool0I?ooo`030000oooooooo06Koool0053oool00ol0VOooooooo`1T
oooo0P0006Ooool0053oool00ol0VOooooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2I
oooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0I?ooo`030000oooooooo
06Koool0053oool00ol0VOooooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo
06Coool20000Ioooo`00D?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o
09Woooooool0GOooo`800005oooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo05coool0
10000?ooooooo`0000Coool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0G_ooo`030000
oooooooo00?oool30000I_ooo`00D?ooo`03o`2Ioooooooo05ooool00`000?ooooooo`02oooo00<0
003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo05coool010000?ooooooo`0000Coool00`000?oo
ooooo`1Voooo001@oooo00?o09Woooooool0GOooo`800005oooo00<0003oooooool0I_ooo`00D?oo
o`03o`2Ioooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0I?ooo`80001W
oooo001@oooo00?o09Woooooool0I?ooo`030000oooooooo06Koool0053oool00ol0VOooooooo`1T
oooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`1Voooo001@
oooo00?o09Woooooool0I?ooo`80001Woooo001@oooo00?o09Woooooool0I?ooo`030000oooooooo
06Koool0053oool00ol0VOooooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo
06Coool00`000?ooooooo`1Voooo001@oooo00?o09Woooooool0I?ooo`030000oooooooo06Koool0
053oool00ol0VOooooooo`1Toooo0P0006Ooool0053oool00ol0VOooooooo`1Toooo00<0003ooooo
ool0I_ooo`00D?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`1Voooo001@oooo00?o09Wooooo
ool0I?ooo`030000oooooooo06Koool0053oool00ol0VOooooooo`1Toooo0P0006Ooool0053oool0
0ol0VOooooooo`1Toooo00<0003oooooool0I_ooo`00D?ooo`03o`2Ioooooooo06Coool00`000?oo
ooooo`1Voooo001@oooo00?o09Woooooool0G_ooo`<00003oooo00<0003oooooool0I_ooo`00D?oo
o`03o`2Ioooooooo05ooool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00D?ooo`03o`2I
oooooooo05coool500000oooo`<0001Voooo002_oooo00@0003oooooool0001]oooo002`oooo00<0
003oool00000KOooo`00/Oooo`80001]oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?oo
ooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0O
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool400000oooo`800003oooo100000?oool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool00`000?oo
ooooo`09oooo00<0003oooooool01?ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05?ooo`030000oooooooo00Woool00`000?ooooooo`04oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool02Oooo`030000oooooooo
00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0G
oooo0P0000[oool200000oooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.24141 .26487 L
.25127 .26487 L
.25666 .26487 L
.26171 .26487 L
.26301 .26487 L
.26425 .26487 L
.26493 .26487 L
s
.26493 .26487 m
.26523 .61803 L
s
0 .4 1 r
.02381 .25933 m
.06244 .25736 L
.10458 .25441 L
.14415 .25058 L
.18221 .2456 L
.22272 .23839 L
.24141 .23421 L
.25127 .23175 L
.25666 .23032 L
.26171 .22893 L
.26301 .22856 L
.26425 .22821 L
.26493 .22801 L
.26568 .26487 L
.26698 .26487 L
.27279 .26487 L
.28302 .26487 L
.30316 .26487 L
.3438 .26487 L
.38293 .26487 L
.42451 .26487 L
.46458 .26487 L
.50313 .26487 L
.54413 .26487 L
.58362 .26487 L
.62159 .26487 L
.66202 .26487 L
.70093 .26487 L
.74229 .26487 L
.78213 .26487 L
.82046 .26487 L
.86124 .26487 L
.90051 .26487 L
.93826 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001Goool306Ko1_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00004_ooo`@0I_l00oooo`0000000002
00001Oooo`030000oooooooo01Coool400001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J
<ol000<0000co`0co`007C?o00040000<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000H
oooo00<0003oooooool07Oooo`030000oooo0000013oool206Ko1_ooo`0306Kooooooooo00;oool0
10000?ooooooo`0001coool400007S?o00030000<ol0<ol001Xco`000`0003?o03?o000M<ol000<0
000co`0co`000c?o00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`0001koool200002Ooo
o`L0I_l8oooo00<0I_ooooooool00oooo`80000Koooo1@0001hco`02000073?o00030000<ol0<ol0
01`co`02000023?o00@0000Coooo0P0002Ooool003coool806Ko3oooo`0306Kooooooooo01koool2
0000@C?o00030000<ol0<ol002Xco`030000>Oooo`00>?ooo`@0I_lHoooo00<0I_ooooooool06Ooo
o`@00013<ol00P0002hco`020000=oooo`00<Oooo`L0I_lLoooo00<0I_ooooooool05?ooo`D00017
<ol000<0000co`0co`00;c?o00@0000coooo000Loooo5@1Vob?oool00`1Vooooooooo`0:oooo2P00
04`co`000`0003?o03?o000c<ol02P0002Woool001Koool606Ko>?ooo`0306Kooooo000000X0001F
<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00017oool001Koool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool010000?ooooooool0V@?oool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool04_ooo`005_ooo`030000oooooooo01goool00`000?ooooooo`0Joooo00Go09Wooooo
ooooool000007oooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Ooo
o`030000oooooooo01koool00`000?ooooooo`0Uoooo001Coooo00?o09Woooooool0HOooo`030000
oooooooo06Koool005?oool00ol0VOooooooo`1Qoooo00<0003oooooool0I_ooo`00Doooo`03o`2I
oooooooo067oool20000Ioooo`00Doooo`03o`2Ioooooooo067oool00`000?ooooooo`1Voooo001C
oooo00?o09Woooooool0HOooo`030000oooooooo06Koool005?oool00ol0VOooooooo`1Qoooo00<0
003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool20000Ioooo`00Doooo`03o`2Ioooooooo
067oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOooo`030000oooooooo06Koool0
05?oool00ol0VOooooooo`1Qoooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool0
0`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOooo`80001Woooo001Coooo00?o09Wooooo
ool0HOooo`030000oooooooo06Koool005?oool00ol0VOooooooo`1Qoooo00<0003oooooool0I_oo
o`00Doooo`03o`2Ioooooooo067oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOoo
o`80001Woooo001Coooo00?o09Woooooool0HOooo`030000oooooooo06Koool005?oool00ol0VOoo
ooooo`1Qoooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo05Woool500000oooo`030000
oooooooo06Koool005?oool00ol0VOooooooo`1Koooo00<0003oooooool00oooo`030000oooooooo
06Koool005?oool00ol0VOooooooo`1Koooo00<0003oooooool00oooo`<0001Voooo001Coooo00?o
09Woooooool0Foooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001Coooo00?o09Wooooo
ool0Foooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0F_oo
o`800005oooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool20000Ioooo`00Dooo
o`03o`2Ioooooooo067oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOooo`030000
oooooooo06Koool005?oool00ol0VOooooooo`1Qoooo00<0003oooooool0I_ooo`00Doooo`03o`2I
oooooooo067oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOooo`80001Woooo001C
oooo00?o09Woooooool0HOooo`030000oooooooo06Koool005?oool00ol0VOooooooo`1Qoooo00<0
003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool00`000?ooooooo`1Voooo001Coooo00?o
09Woooooool0HOooo`80001Woooo001Coooo00?o09Woooooool0HOooo`030000oooooooo06Koool0
05?oool00ol0VOooooooo`1Qoooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool0
0`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOooo`030000oooooooo06Koool005?oool0
0ol0VOooooooo`1Qoooo0P0006Ooool005?oool00ol0VOooooooo`1Qoooo00<0003oooooool0I_oo
o`00Doooo`03o`2Ioooooooo05Woool400001?ooo`030000oooooooo06Koool005?oool00ol0VOoo
ooooo`1Ioooo00<0003oooooool01Oooo`030000oooooooo06Koool005?oool00ol0VOooooooo`1J
oooo00<0003oooooool01?ooo`<0001Voooo001Coooo00?o09Woooooool0Foooo`030000oooooooo
00?oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0FOooo`040000oooooooo00001?oo
o`030000oooooooo06Koool005?oool00ol0VOooooooo`1Joooo0P0000Goool00`000?ooooooo`1V
oooo001Coooo00?o09Woooooool0HOooo`80001Woooo001Coooo00?o09Woooooool0HOooo`030000
oooooooo06Koool005?oool00ol0VOooooooo`1Qoooo00<0003oooooool0I_ooo`00Doooo`03o`2I
oooooooo067oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOooo`030000oooooooo
06Koool005?oool00ol0VOooooooo`1Qoooo0P0006Ooool005?oool00ol0VOooooooo`1Qoooo00<0
003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool00`000?ooooooo`1Voooo001Coooo00?o
09Woooooool0HOooo`030000oooooooo06Koool005?oool00ol0VOooooooo`1Qoooo0P0006Ooool0
05?oool00ol0VOooooooo`1Qoooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool0
0`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOooo`030000oooooooo06Koool005?oool0
0ol0VOooooooo`1Qoooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool20000Iooo
o`00Doooo`03o`2Ioooooooo067oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0F_oo
o`800005oooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo05Woool010000?ooooooo`00
00Coool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0Foooo`030000oooooooo00?oool3
0000I_ooo`00Doooo`03o`2Ioooooooo05coool00`000?ooooooo`02oooo00<0003oooooool0I_oo
o`00Doooo`03o`2Ioooooooo05Woool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo001C
oooo00?o09Woooooool0F_ooo`800005oooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo
067oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOooo`80001Woooo001Coooo00?o
09Woooooool0HOooo`030000oooooooo06Koool005?oool00ol0VOooooooo`1Qoooo00<0003ooooo
ool0I_ooo`00Doooo`03o`2Ioooooooo067oool00`000?ooooooo`1Voooo001Coooo00?o09Wooooo
ool0HOooo`80001Woooo001Coooo00?o09Woooooool0HOooo`030000oooooooo06Koool005?oool0
0ol0VOooooooo`1Qoooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool00`000?oo
ooooo`1Voooo001Coooo00?o09Woooooool0HOooo`030000oooooooo06Koool005?oool00ol0VOoo
ooooo`1Qoooo0P0006Ooool005?oool00ol0VOooooooo`1Qoooo00<0003oooooool0I_ooo`00Dooo
o`03o`2Ioooooooo067oool00`000?ooooooo`1Voooo001Coooo00?o09Woooooool0HOooo`030000
oooooooo06Koool005?oool00ol0VOooooooo`1Qoooo0P0006Ooool005?oool00ol0VOooooooo`1Q
oooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo067oool00`000?ooooooo`1Voooo001C
oooo00?o09Woooooool0Foooo`<00003oooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo
05coool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00Doooo`03o`2Ioooooooo05Woool5
00000oooo`<0001Voooo002_oooo00@0003oooooool0001]oooo002`oooo00<0003oool00000KOoo
o`00/Oooo`80001]oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0
003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003ooooo
ool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool400000ooo
o`800003oooo1@0000;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool00`000?ooooooo`0;oooo00<0
003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003ooooo
ool05?ooo`030000oooooooo00[oool00`000?ooooooo`03oooo00<0003oooooool0Moooo`00N?oo
o`030000oooooooo00D0000Doooo00<0003oooooool02Oooo`030000oooooooo00;oool00`000?oo
ooooo`1hoooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo00002_ooo`030000
oooooooo00;oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P00
00?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.24141 .26487 L
.26171 .26487 L
.26709 .26487 L
.27279 .26487 L
.27513 .26487 L
.27643 .26487 L
.27765 .26487 L
s
.27765 .26487 m
.27793 .61803 L
s
0 .4 1 r
.02381 .25987 m
.06244 .2581 L
.10458 .25543 L
.14415 .25199 L
.18221 .24749 L
.22272 .24099 L
.24141 .23722 L
.26171 .23246 L
.26709 .23107 L
.27279 .22953 L
.27513 .22888 L
.27643 .22851 L
.27765 .22816 L
.27835 .26487 L
.2791 .26487 L
.28042 .26487 L
.28302 .26487 L
.30316 .26487 L
.3438 .26487 L
.38293 .26487 L
.42451 .26487 L
.46458 .26487 L
.50313 .26487 L
.54413 .26487 L
.58362 .26487 L
.62159 .26487 L
.66202 .26487 L
.70093 .26487 L
.74229 .26487 L
.78213 .26487 L
.82046 .26487 L
.86124 .26487 L
.90051 .26487 L
.93826 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001Woool306Ko0_ooo`030000oooooooo01coool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00005_ooo`0306Ko0000000000800000
0oooo`1Vooooo`02oooo00<0003oooooool05?ooo`@00004oooo0`0001Dco`04000013?o00030000
<ol0<ol001Xco`000`0003?o03?o000M<ol000@0000co`0co`0co`0200006oooo`030000oooooooo
02Goool001Soool00`000?ooooooo`0Moooo00<0003oool000004Oooo`D0I_l6oooo00D0I_l0003o
ooooool000007?ooo`@0000N<ol000<0000co`0co`006S?o00030000<ol0<ol001dco`000`0003?o
03?o0003<ol00`0001Koool010000?ooooooo`0002Koool001Soool300007_ooo`80000<oooo1@1V
o`_oool0101Vooooo`00000001_oool500007S?o0080000L<ol000<0000co`0co`0073?o00800008
<ol0100001?oool200009oooo`00@Oooo`H0I_l@oooo00<0I_ooooooool06_ooo`800011<ol000<0
000co`0co`00:S?o00<0000ioooo000joooo1`1VoaKoool00`1Vooooooooo`0Foooo100004<co`02
0000;S?o0080000goooo000aoooo2@1Voagoool00`1Vooooooooo`0Aoooo1@0004Lco`000`0003?o
03?o000_<ol0100003?oool002Koool;06Ko9_ooo`0306Kooooooooo00Ooool:0000C3?o00030000
<ol0<ol003<co`0:0000:Oooo`005_oooa00I_l`oooo00<00000I_l00000200005Hco`000`0003?o
03?o000m<ol03`0001[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool04_oo
o`005_ooo`030000oooooooo01goool00`000?ooooooo`0Noooo00<0003oooooool07Oooo`030000
oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo01koool0
0`000?ooooooo`0Uoooo001Goooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool0
0ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool20000Iooo
o`00Eoooo`03o`2Ioooooooo05goool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0GOoo
o`030000oooooooo06Koool005Ooool00ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eooo
o`03o`2Ioooooooo05goool20000Ioooo`00Eoooo`03o`2Ioooooooo05goool00`000?ooooooo`1V
oooo001Goooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool00ol0VOooooooo`1M
oooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool00`000?ooooooo`1Voooo001G
oooo00?o09Woooooool0GOooo`80001Woooo001Goooo00?o09Woooooool0GOooo`030000oooooooo
06Koool005Ooool00ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo
05goool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0GOooo`80001Woooo001Goooo00?o
09Woooooool0GOooo`030000oooooooo06Koool005Ooool00ol0VOooooooo`1Moooo00<0003ooooo
ool0I_ooo`00Eoooo`03o`2Ioooooooo05Goool500000oooo`030000oooooooo06Koool005Ooool0
0ol0VOooooooo`1Goooo00<0003oooooool00oooo`030000oooooooo06Koool005Ooool00ol0VOoo
ooooo`1Goooo00<0003oooooool00oooo`<0001Voooo001Goooo00?o09Woooooool0Eoooo`030000
oooooooo00?oool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0Eoooo`030000oooooooo
00?oool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0E_ooo`800005oooo00<0003ooooo
ool0I_ooo`00Eoooo`03o`2Ioooooooo05goool20000Ioooo`00Eoooo`03o`2Ioooooooo05goool0
0`000?ooooooo`1Voooo001Goooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool0
0ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool00`000?oo
ooooo`1Voooo001Goooo00?o09Woooooool0GOooo`80001Woooo001Goooo00?o09Woooooool0GOoo
o`030000oooooooo06Koool005Ooool00ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eooo
o`03o`2Ioooooooo05goool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0GOooo`80001W
oooo001Goooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool00ol0VOooooooo`1M
oooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool00`000?ooooooo`1Voooo001G
oooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool00ol0VOooooooo`1Moooo0P00
06Ooool005Ooool00ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo
05Goool400001?ooo`030000oooooooo06Koool005Ooool00ol0VOooooooo`1Eoooo00<0003ooooo
ool01Oooo`030000oooooooo06Koool005Ooool00ol0VOooooooo`1Foooo00<0003oooooool01?oo
o`<0001Voooo001Goooo00?o09Woooooool0Eoooo`030000oooooooo00?oool00`000?ooooooo`1V
oooo001Goooo00?o09Woooooool0EOooo`040000oooooooo00001?ooo`030000oooooooo06Koool0
05Ooool00ol0VOooooooo`1Foooo0P0000Goool00`000?ooooooo`1Voooo001Goooo00?o09Wooooo
ool0GOooo`80001Woooo001Goooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool0
0ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool00`000?oo
ooooo`1Voooo001Goooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool00ol0VOoo
ooooo`1Moooo0P0006Ooool005Ooool00ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eooo
o`03o`2Ioooooooo05goool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0GOooo`030000
oooooooo06Koool005Ooool00ol0VOooooooo`1Moooo0P0006Ooool005Ooool00ol0VOooooooo`1M
oooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool00`000?ooooooo`1Voooo001G
oooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool00ol0VOooooooo`1Moooo00<0
003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool20000Ioooo`00Eoooo`03o`2Ioooooooo
05goool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0E_ooo`800005oooo00<0003ooooo
ool0I_ooo`00Eoooo`03o`2Ioooooooo05Goool010000?ooooooo`0000Coool00`000?ooooooo`1V
oooo001Goooo00?o09Woooooool0Eoooo`030000oooooooo00?oool30000I_ooo`00Eoooo`03o`2I
oooooooo05Soool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo
05Goool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0E_oo
o`800005oooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool00`000?ooooooo`1V
oooo001Goooo00?o09Woooooool0GOooo`80001Woooo001Goooo00?o09Woooooool0GOooo`030000
oooooooo06Koool005Ooool00ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eoooo`03o`2I
oooooooo05goool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0GOooo`80001Woooo001G
oooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool00ol0VOooooooo`1Moooo00<0
003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool00`000?ooooooo`1Voooo001Goooo00?o
09Woooooool0GOooo`030000oooooooo06Koool005Ooool00ol0VOooooooo`1Moooo0P0006Ooool0
05Ooool00ol0VOooooooo`1Moooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05goool0
0`000?ooooooo`1Voooo001Goooo00?o09Woooooool0GOooo`030000oooooooo06Koool005Ooool0
0ol0VOooooooo`1Moooo0P0006Ooool005Ooool00ol0VOooooooo`1Moooo00<0003oooooool0I_oo
o`00Eoooo`03o`2Ioooooooo05goool00`000?ooooooo`1Voooo001Goooo00?o09Woooooool0Eooo
o`<00003oooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05Soool00`000?ooooooo`02
oooo00<0003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo05Goool500000oooo`<0001Voooo002_
oooo00@0003oooooool0001]oooo002`oooo00<0003oool00000KOooo`00/Oooo`80001]oooo003o
oooo8Oooo`00ooooob7oool007coool00`000?ooooooo`0Roooo00<0003oooooool0O?ooo`00Nooo
o`030000oooooooo00Soool00`000?ooooooo`0Ioooo00<0003oooooool0Noooo`00Noooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00coool400000oooo`800004oooo00<0003ooooo
ool0Noooo`00Noooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool01?ooo`@00003oooo00<0003oooooool02_ooo`030000oooooooo07_oool007[oool00`000?oo
ooooo`02oooo00<0003oooooool05?ooo`030000oooooooo00[oool00`000?ooooooo`1joooo001k
oooo00<0003oooooool01@0001Coool00`000?ooooooo`08oooo00<0003oooooool0Noooo`00Nooo
o`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooooooo`1koooo001l
oooo00<0003oooooool05oooo`800009oooo00<0003oooooool0O?ooo`00ooooob7oool00?oooolQ
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.27193 .26487 L
.27731 .26487 L
.28302 .26487 L
.28542 .26487 L
.288 .26487 L
.28876 .26487 L
.28948 .26487 L
.29013 .26487 L
s
.29013 .26487 m
.29041 .61803 L
s
0 .4 1 r
.02381 .26037 m
.06244 .25877 L
.10458 .25637 L
.14415 .25326 L
.18221 .24921 L
.22272 .24335 L
.26171 .23567 L
.27193 .23324 L
.27731 .23188 L
.28302 .23038 L
.28542 .22973 L
.288 .22902 L
.28876 .22881 L
.28948 .2286 L
.29013 .22842 L
.29083 .26487 L
.2915 .26487 L
.29221 .26487 L
.29349 .26487 L
.30316 .26487 L
.34474 .26487 L
.3848 .26487 L
.42335 .26487 L
.46436 .26487 L
.50385 .26487 L
.54182 .26487 L
.58224 .26487 L
.62115 .26487 L
.66251 .26487 L
.70236 .26487 L
.74069 .26487 L
.78147 .26487 L
.82073 .26487 L
.85849 .26487 L
.89869 .26487 L
.93738 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001coool206Ko00<0003oooooool07?ooo`040000oooooooooooo0P0001/co`000`0003?o
03?o000J<ol00P0001hco`00100003?o0000000001coool00`000?ooooooo`0Voooo000Aoooo1000
00?oool200005oooo`@00002oooo00@0003oooooool0000Goooo10000080I_l2oooo00<0I_l0003o
ool05Oooo`@00004oooo0`0001Dco`04000013?o00030000<ol0<ol001Xco`000`0003?o03?o000M
<ol000@0000co`0co`0co`0200006oooo`030000oooooooo02Goool001Soool00`000?ooooooo`0M
oooo00<0003oool000005_ooo`@0I_l3oooo00@0003oool0I_l0000Loooo100001hco`000`0003?o
03?o000J<ol000<0000co`0co`007C?o00030000<ol0<ol000<co`0300005_ooo`040000oooooooo
00009_ooo`006?ooo`<0000Noooo0P00017oool506Ko2?ooo`80000Koooo1@0001hco`02000073?o
00030000<ol0<ol001`co`02000023?o00@0000Coooo0P0002Ooool004Coool806Ko3_ooo`0306Ko
oooooooo01Ooool20000@C?o00030000<ol0<ol002Xco`030000>Oooo`00>_ooo`X0I_lFoooo00<0
I_ooooooool04oooo`@00013<ol00P0002hco`020000=oooo`00<Oooo`T0I_lPoooo00<0I_oooooo
ool03_ooo`D00017<ol000<0000co`0co`00;c?o00@0000coooo000Voooo2`1VobWoool00`1Voooo
ooooo`04oooo2P0004`co`000`0003?o03?o000c<ol02P0002Woool001Koool@06Ko<?ooo`@00000
0`1Vo`00000000040000ES?o00030000<ol0<ol003dco`0?00006_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`040000ooooooooo`2I0_oo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo01;oool001Koool00`000?ooooooo`0Moooo00<0003ooooo
ool07_ooo`040000ooooooooo`2I7?ooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0
003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`0Uoooo001Joooo00?o09Wooooo
ool0F_ooo`030000oooooooo06Koool005[oool00ol0VOooooooo`1Joooo00<0003oooooool0I_oo
o`00F_ooo`03o`2Ioooooooo05[oool20000Ioooo`00F_ooo`03o`2Ioooooooo05[oool00`000?oo
ooooo`1Voooo001Joooo00?o09Woooooool0F_ooo`030000oooooooo06Koool005[oool00ol0VOoo
ooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05[oool20000Ioooo`00F_oo
o`03o`2Ioooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0F_ooo`030000
oooooooo06Koool005[oool00ol0VOooooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2I
oooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0F_ooo`80001Woooo001J
oooo00?o09Woooooool0F_ooo`030000oooooooo06Koool005[oool00ol0VOooooooo`1Joooo00<0
003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o
09Woooooool0F_ooo`80001Woooo001Joooo00?o09Woooooool0F_ooo`030000oooooooo06Koool0
05[oool00ol0VOooooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05;oool5
00000oooo`030000oooooooo06Koool005[oool00ol0VOooooooo`1Doooo00<0003oooooool00ooo
o`030000oooooooo06Koool005[oool00ol0VOooooooo`1Doooo00<0003oooooool00oooo`<0001V
oooo001Joooo00?o09Woooooool0E?ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001J
oooo00?o09Woooooool0E?ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001Joooo00?o
09Woooooool0Doooo`800005oooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05[oool2
0000Ioooo`00F_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o09Wooooo
ool0F_ooo`030000oooooooo06Koool005[oool00ol0VOooooooo`1Joooo00<0003oooooool0I_oo
o`00F_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0F_oo
o`80001Woooo001Joooo00?o09Woooooool0F_ooo`030000oooooooo06Koool005[oool00ol0VOoo
ooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`1V
oooo001Joooo00?o09Woooooool0F_ooo`80001Woooo001Joooo00?o09Woooooool0F_ooo`030000
oooooooo06Koool005[oool00ol0VOooooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2I
oooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0F_ooo`030000oooooooo
06Koool005[oool00ol0VOooooooo`1Joooo0P0006Ooool005[oool00ol0VOooooooo`1Joooo00<0
003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05;oool400001?ooo`030000oooooooo06Koool0
05[oool00ol0VOooooooo`1Boooo00<0003oooooool01Oooo`030000oooooooo06Koool005[oool0
0ol0VOooooooo`1Coooo00<0003oooooool01?ooo`<0001Voooo001Joooo00?o09Woooooool0E?oo
o`030000oooooooo00?oool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0D_ooo`040000
oooooooo00001?ooo`030000oooooooo06Koool005[oool00ol0VOooooooo`1Coooo0P0000Goool0
0`000?ooooooo`1Voooo001Joooo00?o09Woooooool0F_ooo`80001Woooo001Joooo00?o09Wooooo
ool0F_ooo`030000oooooooo06Koool005[oool00ol0VOooooooo`1Joooo00<0003oooooool0I_oo
o`00F_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0F_oo
o`030000oooooooo06Koool005[oool00ol0VOooooooo`1Joooo0P0006Ooool005[oool00ol0VOoo
ooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`1V
oooo001Joooo00?o09Woooooool0F_ooo`030000oooooooo06Koool005[oool00ol0VOooooooo`1J
oooo0P0006Ooool005[oool00ol0VOooooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2I
oooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0F_ooo`030000oooooooo
06Koool005[oool00ol0VOooooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo
05[oool20000Ioooo`00F_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o
09Woooooool0Doooo`800005oooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05;oool0
10000?ooooooo`0000Coool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0E?ooo`030000
oooooooo00?oool30000I_ooo`00F_ooo`03o`2Ioooooooo05Goool00`000?ooooooo`02oooo00<0
003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05;oool010000?ooooooo`0000Coool00`000?oo
ooooo`1Voooo001Joooo00?o09Woooooool0Doooo`800005oooo00<0003oooooool0I_ooo`00F_oo
o`03o`2Ioooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0F_ooo`80001W
oooo001Joooo00?o09Woooooool0F_ooo`030000oooooooo06Koool005[oool00ol0VOooooooo`1J
oooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`1Voooo001J
oooo00?o09Woooooool0F_ooo`80001Woooo001Joooo00?o09Woooooool0F_ooo`030000oooooooo
06Koool005[oool00ol0VOooooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo
05[oool00`000?ooooooo`1Voooo001Joooo00?o09Woooooool0F_ooo`030000oooooooo06Koool0
05[oool00ol0VOooooooo`1Joooo0P0006Ooool005[oool00ol0VOooooooo`1Joooo00<0003ooooo
ool0I_ooo`00F_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`1Voooo001Joooo00?o09Wooooo
ool0F_ooo`030000oooooooo06Koool005[oool00ol0VOooooooo`1Joooo0P0006Ooool005[oool0
0ol0VOooooooo`1Joooo00<0003oooooool0I_ooo`00F_ooo`03o`2Ioooooooo05[oool00`000?oo
ooooo`1Voooo001Joooo00?o09Woooooool0E?ooo`<00003oooo00<0003oooooool0I_ooo`00F_oo
o`03o`2Ioooooooo05Goool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00F_ooo`03o`2I
oooooooo05;oool500000oooo`<0001Voooo002_oooo00@0003oooooool0001]oooo002`oooo00<0
003oool00000KOooo`00/Oooo`80001]oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?oo
ooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0O
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool500000_ooo`800003oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?oo
ooooo`09oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Soool300001?ooo`030000oooooooo07Ooool0
07Soool00`000?ooooooo`0500005?ooo`030000oooooooo00Ooool010000?ooooooo`0000?oool0
0`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005oooo`030000oooooooo00Ooool0
10000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:
oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.28158 .26487 L
.29205 .26487 L
.29779 .26487 L
.30059 .26487 L
.30182 .26487 L
.30246 .26487 L
.30316 .26487 L
s
.30316 .26487 m
.30366 .61803 L
s
0 .4 1 r
.02381 .26082 m
.06244 .25938 L
.10458 .25722 L
.14415 .25442 L
.18221 .25077 L
.22272 .2455 L
.26171 .23858 L
.28158 .23417 L
.29205 .23156 L
.29779 .23004 L
.30059 .22928 L
.30182 .22893 L
.30246 .22875 L
.30316 .22856 L
.30442 .26487 L
.3056 .26487 L
.30791 .26487 L
.31304 .26487 L
.32392 .26487 L
.34309 .26487 L
.38467 .26487 L
.42473 .26487 L
.46328 .26487 L
.50429 .26487 L
.54378 .26487 L
.58175 .26487 L
.62217 .26487 L
.66108 .26487 L
.70244 .26487 L
.74229 .26487 L
.78062 .26487 L
.8214 .26487 L
.86066 .26487 L
.89841 .26487 L
.93862 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool010000?ooo`1Vo`1Voa_oool010000?ooooooooooo`80000K<ol000<0000co`0c
o`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Oooo`@00003
oooo0P0001Ooool400000_ooo`040000oooooooo00005oooo`@000000oooo`1Vo`1Vo`0206Ko00<0
003oool0I_l05?ooo`@00004oooo0`0001Dco`04000013?o00030000<ol0<ol001Xco`000`0003?o
03?o000M<ol000@0000co`0co`0co`0200006oooo`030000oooooooo02Goool001Soool00`000?oo
ooooo`0Moooo00<0003oool000006_ooo`80I_l01oooo`000?ooooooo`000?ooo`1Vo`0Joooo1000
01hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o00030000<ol0<ol000<co`0300005_oo
o`040000oooooooo00009_ooo`006?ooo`<0000Noooo0P0001Coool606Ko1?ooo`800002oooo00<0
I_ooooooool05_ooo`D0000N<ol00P0001`co`000`0003?o03?o000L<ol00P0000Pco`0400004ooo
o`80000Woooo0017oooo201Vo`koool00`1Vooooooooo`0Doooo0P00044co`000`0003?o03?o000Z
<ol00`0003Woool0047oool606Ko5_ooo`0306Kooooooooo013oool40000@c?o0080000^<ol00P00
03Ooool003[oool706Ko7?ooo`0306Kooooooooo00_oool50000Ac?o00030000<ol0<ol002lco`04
0000<oooo`009_oooa@0I_lSoooo00@0I_ooooooooooool:0000C3?o00030000<ol0<ol003<co`0:
0000:Oooo`005_oooa00I_l`oooo1`00000406Ko000000000000ES?o00030000<ol0<ol003dco`0?
00006_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`0Boooo000Foooo00<0
003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`03oooo00?o09Woooooool05ooo
o`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo
01koool00`000?ooooooo`0Uoooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool0
05goool00ol0VOooooooo`1Goooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool2
0000Ioooo`00GOooo`03o`2Ioooooooo05Ooool00`000?ooooooo`1Voooo001Moooo00?o09Wooooo
ool0Eoooo`030000oooooooo06Koool005goool00ol0VOooooooo`1Goooo00<0003oooooool0I_oo
o`00GOooo`03o`2Ioooooooo05Ooool20000Ioooo`00GOooo`03o`2Ioooooooo05Ooool00`000?oo
ooooo`1Voooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool005goool00ol0VOoo
ooooo`1Goooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool00`000?ooooooo`1V
oooo001Moooo00?o09Woooooool0Eoooo`80001Woooo001Moooo00?o09Woooooool0Eoooo`030000
oooooooo06Koool005goool00ol0VOooooooo`1Goooo00<0003oooooool0I_ooo`00GOooo`03o`2I
oooooooo05Ooool00`000?ooooooo`1Voooo001Moooo00?o09Woooooool0Eoooo`80001Woooo001M
oooo00?o09Woooooool0Eoooo`030000oooooooo06Koool005goool00ol0VOooooooo`1Goooo00<0
003oooooool0I_ooo`00GOooo`03o`2Ioooooooo04ooool500000oooo`030000oooooooo06Koool0
05goool00ol0VOooooooo`1Aoooo00<0003oooooool00oooo`030000oooooooo06Koool005goool0
0ol0VOooooooo`1Aoooo00<0003oooooool00oooo`<0001Voooo001Moooo00?o09Woooooool0DOoo
o`030000oooooooo00?oool00`000?ooooooo`1Voooo001Moooo00?o09Woooooool0DOooo`030000
oooooooo00?oool00`000?ooooooo`1Voooo001Moooo00?o09Woooooool0D?ooo`800005oooo00<0
003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool20000Ioooo`00GOooo`03o`2Ioooooooo
05Ooool00`000?ooooooo`1Voooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool0
05goool00ol0VOooooooo`1Goooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool0
0`000?ooooooo`1Voooo001Moooo00?o09Woooooool0Eoooo`80001Woooo001Moooo00?o09Wooooo
ool0Eoooo`030000oooooooo06Koool005goool00ol0VOooooooo`1Goooo00<0003oooooool0I_oo
o`00GOooo`03o`2Ioooooooo05Ooool00`000?ooooooo`1Voooo001Moooo00?o09Woooooool0Eooo
o`80001Woooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool005goool00ol0VOoo
ooooo`1Goooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool00`000?ooooooo`1V
oooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool005goool00ol0VOooooooo`1G
oooo0P0006Ooool005goool00ol0VOooooooo`1Goooo00<0003oooooool0I_ooo`00GOooo`03o`2I
oooooooo04ooool400001?ooo`030000oooooooo06Koool005goool00ol0VOooooooo`1?oooo00<0
003oooooool01Oooo`030000oooooooo06Koool005goool00ol0VOooooooo`1@oooo00<0003ooooo
ool01?ooo`<0001Voooo001Moooo00?o09Woooooool0DOooo`030000oooooooo00?oool00`000?oo
ooooo`1Voooo001Moooo00?o09Woooooool0Coooo`040000oooooooo00001?ooo`030000oooooooo
06Koool005goool00ol0VOooooooo`1@oooo0P0000Goool00`000?ooooooo`1Voooo001Moooo00?o
09Woooooool0Eoooo`80001Woooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool0
05goool00ol0VOooooooo`1Goooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool0
0`000?ooooooo`1Voooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool005goool0
0ol0VOooooooo`1Goooo0P0006Ooool005goool00ol0VOooooooo`1Goooo00<0003oooooool0I_oo
o`00GOooo`03o`2Ioooooooo05Ooool00`000?ooooooo`1Voooo001Moooo00?o09Woooooool0Eooo
o`030000oooooooo06Koool005goool00ol0VOooooooo`1Goooo0P0006Ooool005goool00ol0VOoo
ooooo`1Goooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool00`000?ooooooo`1V
oooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool005goool00ol0VOooooooo`1G
oooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool20000Ioooo`00GOooo`03o`2I
oooooooo05Ooool00`000?ooooooo`1Voooo001Moooo00?o09Woooooool0D?ooo`800005oooo00<0
003oooooool0I_ooo`00GOooo`03o`2Ioooooooo04ooool010000?ooooooo`0000Coool00`000?oo
ooooo`1Voooo001Moooo00?o09Woooooool0DOooo`030000oooooooo00?oool30000I_ooo`00GOoo
o`03o`2Ioooooooo05;oool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00GOooo`03o`2I
oooooooo04ooool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo001Moooo00?o09Wooooo
ool0D?ooo`800005oooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool00`000?oo
ooooo`1Voooo001Moooo00?o09Woooooool0Eoooo`80001Woooo001Moooo00?o09Woooooool0Eooo
o`030000oooooooo06Koool005goool00ol0VOooooooo`1Goooo00<0003oooooool0I_ooo`00GOoo
o`03o`2Ioooooooo05Ooool00`000?ooooooo`1Voooo001Moooo00?o09Woooooool0Eoooo`80001W
oooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool005goool00ol0VOooooooo`1G
oooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool00`000?ooooooo`1Voooo001M
oooo00?o09Woooooool0Eoooo`030000oooooooo06Koool005goool00ol0VOooooooo`1Goooo0P00
06Ooool005goool00ol0VOooooooo`1Goooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo
05Ooool00`000?ooooooo`1Voooo001Moooo00?o09Woooooool0Eoooo`030000oooooooo06Koool0
05goool00ol0VOooooooo`1Goooo0P0006Ooool005goool00ol0VOooooooo`1Goooo00<0003ooooo
ool0I_ooo`00GOooo`03o`2Ioooooooo05Ooool00`000?ooooooo`1Voooo001Moooo00?o09Wooooo
ool0DOooo`<00003oooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo05;oool00`000?oo
ooooo`02oooo00<0003oooooool0I_ooo`00GOooo`03o`2Ioooooooo04ooool500000oooo`<0001V
oooo002_oooo00@0003oooooool0001]oooo002`oooo00<0003oool00000KOooo`00/Oooo`80001]
oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?oo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_ooo`800004oooo0P00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0
003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500005?ooo`030000oooooooo00Soool200001?ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000
oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000oooo`030000oooooooo
07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.28158 .26487 L
.29205 .26487 L
.30316 .26487 L
.30791 .26487 L
.31054 .26487 L
.31304 .26487 L
.31444 .26487 L
.31523 .26487 L
s
.31523 .26487 m
.31553 .61803 L
s
0 .4 1 r
.02381 .26123 m
.06244 .25993 L
.10458 .25799 L
.14415 .25547 L
.18221 .2522 L
.22272 .24745 L
.26171 .24123 L
.28158 .23726 L
.29205 .23492 L
.30316 .23222 L
.30791 .23099 L
.31054 .2303 L
.31304 .22962 L
.31444 .22924 L
.31523 .22902 L
.31597 .26487 L
.31727 .26487 L
.31865 .26487 L
.32392 .26487 L
.34309 .26487 L
.38467 .26487 L
.42473 .26487 L
.46328 .26487 L
.50429 .26487 L
.54378 .26487 L
.58175 .26487 L
.62217 .26487 L
.66108 .26487 L
.70244 .26487 L
.74229 .26487 L
.78062 .26487 L
.8214 .26487 L
.86066 .26487 L
.89841 .26487 L
.93862 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`02oooo0P1VoaSoool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00005oooo`@00005oooo00H00000I_l0
I_l0I_ooool0I_lAoooo100000Coool300005C?o00@00004<ol000<0000co`0co`006S?o00030000
<ol0<ol001dco`00100003?o03?o03?o0080000Koooo00<0003oooooool09Oooo`006?ooo`030000
oooooooo01goool00`000?ooo`00000Koooo0P1Vo`04000006Ko06Ko00001?ooo`0306Kooooooooo
01Goool400007S?o00030000<ol0<ol001Xco`000`0003?o03?o000M<ol000<0000co`0co`000c?o
00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`0001koool200005_ooo`D0I_l3oooo0P00
00Goool00`1Vooooooooo`0Coooo1@0001hco`02000073?o00030000<ol0<ol001`co`02000023?o
00@0000Coooo0P0002Ooool004coool506Ko3oooo`0306Kooooooooo017oool20000@C?o00030000
<ol0<ol002Xco`030000>Oooo`00A?ooo`P0I_lDoooo00<0I_ooooooool03Oooo`@00013<ol00P00
02hco`020000=oooo`00>_ooo`X0I_lLoooo00<0I_ooooooool02?ooo`D00017<ol000<0000co`0c
o`00;c?o00@0000coooo000Voooo501VobKoool00`1Vo`00000000080000C3?o00030000<ol0<ol0
03<co`0:0000:Oooo`005_oooa00I_l`oooo2P00000306Ko<ol0<ol005@co`000`0003?o03?o000m
<ol03`0001[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00@0003ooooooooo09T3oooo00<0003oooooool00ooo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`0Boooo000F
oooo00<0003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`06oooo00?o09Wooooo
ool05?ooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000
oooooooo01koool00`000?ooooooo`0Uoooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo
06Koool0063oool00ol0VOooooooo`1Doooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo
05Coool20000Ioooo`00H?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`1Voooo001Poooo00?o
09Woooooool0E?ooo`030000oooooooo06Koool0063oool00ol0VOooooooo`1Doooo00<0003ooooo
ool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool20000Ioooo`00H?ooo`03o`2Ioooooooo05Coool0
0`000?ooooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo06Koool0063oool0
0ol0VOooooooo`1Doooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool00`000?oo
ooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`80001Woooo001Poooo00?o09Woooooool0E?oo
o`030000oooooooo06Koool0063oool00ol0VOooooooo`1Doooo00<0003oooooool0I_ooo`00H?oo
o`03o`2Ioooooooo05Coool00`000?ooooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`80001W
oooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo06Koool0063oool00ol0VOooooooo`1D
oooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo04coool500000oooo`030000oooooooo
06Koool0063oool00ol0VOooooooo`1>oooo00<0003oooooool00oooo`030000oooooooo06Koool0
063oool00ol0VOooooooo`1>oooo00<0003oooooool00oooo`<0001Voooo001Poooo00?o09Wooooo
ool0C_ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001Poooo00?o09Woooooool0C_oo
o`030000oooooooo00?oool00`000?ooooooo`1Voooo001Poooo00?o09Woooooool0COooo`800005
oooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool20000Ioooo`00H?ooo`03o`2I
oooooooo05Coool00`000?ooooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo
06Koool0063oool00ol0VOooooooo`1Doooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo
05Coool00`000?ooooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`80001Woooo001Poooo00?o
09Woooooool0E?ooo`030000oooooooo06Koool0063oool00ol0VOooooooo`1Doooo00<0003ooooo
ool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`1Voooo001Poooo00?o09Wooooo
ool0E?ooo`80001Woooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo06Koool0063oool0
0ol0VOooooooo`1Doooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool00`000?oo
ooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo06Koool0063oool00ol0VOoo
ooooo`1Doooo0P0006Ooool0063oool00ol0VOooooooo`1Doooo00<0003oooooool0I_ooo`00H?oo
o`03o`2Ioooooooo04coool400001?ooo`030000oooooooo06Koool0063oool00ol0VOooooooo`1<
oooo00<0003oooooool01Oooo`030000oooooooo06Koool0063oool00ol0VOooooooo`1=oooo00<0
003oooooool01?ooo`<0001Voooo001Poooo00?o09Woooooool0C_ooo`030000oooooooo00?oool0
0`000?ooooooo`1Voooo001Poooo00?o09Woooooool0C?ooo`040000oooooooo00001?ooo`030000
oooooooo06Koool0063oool00ol0VOooooooo`1=oooo0P0000Goool00`000?ooooooo`1Voooo001P
oooo00?o09Woooooool0E?ooo`80001Woooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo
06Koool0063oool00ol0VOooooooo`1Doooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo
05Coool00`000?ooooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo06Koool0
063oool00ol0VOooooooo`1Doooo0P0006Ooool0063oool00ol0VOooooooo`1Doooo00<0003ooooo
ool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`1Voooo001Poooo00?o09Wooooo
ool0E?ooo`030000oooooooo06Koool0063oool00ol0VOooooooo`1Doooo0P0006Ooool0063oool0
0ol0VOooooooo`1Doooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool00`000?oo
ooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo06Koool0063oool00ol0VOoo
ooooo`1Doooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool20000Ioooo`00H?oo
o`03o`2Ioooooooo05Coool00`000?ooooooo`1Voooo001Poooo00?o09Woooooool0COooo`800005
oooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo04coool010000?ooooooo`0000Coool0
0`000?ooooooo`1Voooo001Poooo00?o09Woooooool0C_ooo`030000oooooooo00?oool30000I_oo
o`00H?ooo`03o`2Ioooooooo04ooool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00H?oo
o`03o`2Ioooooooo04coool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo001Poooo00?o
09Woooooool0COooo`800005oooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool0
0`000?ooooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`80001Woooo001Poooo00?o09Wooooo
ool0E?ooo`030000oooooooo06Koool0063oool00ol0VOooooooo`1Doooo00<0003oooooool0I_oo
o`00H?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`1Voooo001Poooo00?o09Woooooool0E?oo
o`80001Woooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo06Koool0063oool00ol0VOoo
ooooo`1Doooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`1V
oooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo06Koool0063oool00ol0VOooooooo`1D
oooo0P0006Ooool0063oool00ol0VOooooooo`1Doooo00<0003oooooool0I_ooo`00H?ooo`03o`2I
oooooooo05Coool00`000?ooooooo`1Voooo001Poooo00?o09Woooooool0E?ooo`030000oooooooo
06Koool0063oool00ol0VOooooooo`1Doooo0P0006Ooool0063oool00ol0VOooooooo`1Doooo00<0
003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`1Voooo001Poooo00?o
09Woooooool0C_ooo`<00003oooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo04ooool0
0`000?ooooooo`02oooo00<0003oooooool0I_ooo`00H?ooo`03o`2Ioooooooo04coool500000ooo
o`<0001Voooo002_oooo00@0003oooooool0001]oooo002`oooo00<0003oool00000KOooo`00/Ooo
o`80001]oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003ooooo
ool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?oo
o`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_ooo`800005
oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo00Woool0
0`000?ooooooo`02oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?oo
ooooo`0Eoooo00<0003oooooool02Oooo`030000oooooooo00?oool00`000?ooooooo`1goooo001h
oooo00<0003oooooool01@0001Coool00`000?ooooooo`0:oooo00D0003oooooooooool00000N_oo
o`00N?ooo`050000oooooooooooo000001Ooool00`000?ooooooo`07oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002Oooo`@00002oooo00<0
003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.28158 .26487 L
.30316 .26487 L
.31323 .26487 L
.31875 .26487 L
.32392 .26487 L
.32617 .26487 L
.32728 .26487 L
.32831 .26487 L
s
.32831 .26487 m
.32878 .61803 L
s
0 .4 1 r
.02381 .2616 m
.06244 .26044 L
.10458 .25869 L
.14415 .25643 L
.18221 .25349 L
.22272 .24923 L
.26171 .24364 L
.28158 .24008 L
.30316 .23555 L
.31323 .23317 L
.31875 .23179 L
.32392 .23044 L
.32617 .22984 L
.32728 .22954 L
.32831 .22926 L
.32949 .26487 L
.33078 .26487 L
.33304 .26487 L
.34309 .26487 L
.38221 .26487 L
.4238 .26487 L
.46386 .26487 L
.50241 .26487 L
.54342 .26487 L
.5829 .26487 L
.62088 .26487 L
.6613 .26487 L
.70021 .26487 L
.74157 .26487 L
.78142 .26487 L
.81975 .26487 L
.86053 .26487 L
.89979 .26487 L
.93754 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`05oooo0P1VoaGoool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00005oooo`@00005oooo00@0003ooooo
ooooool306Ko00?oool0I_ooool03Oooo`@00004oooo0`0001Dco`04000013?o00030000<ol0<ol0
01Xco`000`0003?o03?o000M<ol000@0000co`0co`0co`0200006oooo`030000oooooooo02Goool0
01Soool00`000?ooooooo`0Moooo00<0003oool000007Oooo`040000oooooooo00000`1Vo`Coool0
0`1Vooooooooo`0Boooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o00030000
<ol0<ol000<co`0300005_ooo`040000oooooooo00009_ooo`006?ooo`<0000Noooo0P0001_oool3
06Ko0P0000Soool00`1Vooooooooo`0@oooo1@0001hco`02000073?o00030000<ol0<ol001`co`02
000023?o00@0000Coooo0P0002Ooool004ooool706Ko3Oooo`0306Kooooooooo00koool20000@C?o
00030000<ol0<ol002Xco`030000>Oooo`00A?ooo`/0I_lEoooo00<0I_ooooooool02Oooo`@00013
<ol00P0002hco`020000=oooo`00>_ooo`X0I_lPoooo00<0I_ooooooool01?ooo`D00017<ol000<0
000co`0co`00;c?o00@0000coooo000aoooo2@1VobOoool3000000<0I_l000000000100004`co`00
0`0003?o03?o000c<ol02P0002Woool001KooolK06Ko9Oooo`/00003<ol000<0I_lco`0co`00D3?o
00030000<ol0<ol003dco`0?00006_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00?o
09T0003oool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`0Boooo000Foooo00<0003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`09
oooo00?o09Woooooool04Oooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003ooooo
ool07Oooo`030000oooooooo01koool00`000?ooooooo`0Uoooo001Soooo00?o09Woooooool0DOoo
o`030000oooooooo06Koool006?oool00ol0VOooooooo`1Aoooo00<0003oooooool0I_ooo`00Hooo
o`03o`2Ioooooooo057oool20000Ioooo`00Hoooo`03o`2Ioooooooo057oool00`000?ooooooo`1V
oooo001Soooo00?o09Woooooool0DOooo`030000oooooooo06Koool006?oool00ol0VOooooooo`1A
oooo00<0003oooooool0I_ooo`00Hoooo`03o`2Ioooooooo057oool20000Ioooo`00Hoooo`03o`2I
oooooooo057oool00`000?ooooooo`1Voooo001Soooo00?o09Woooooool0DOooo`030000oooooooo
06Koool006?oool00ol0VOooooooo`1Aoooo00<0003oooooool0I_ooo`00Hoooo`03o`2Ioooooooo
057oool00`000?ooooooo`1Voooo001Soooo00?o09Woooooool0DOooo`80001Woooo001Soooo00?o
09Woooooool0DOooo`030000oooooooo06Koool006?oool00ol0VOooooooo`1Aoooo00<0003ooooo
ool0I_ooo`00Hoooo`03o`2Ioooooooo057oool00`000?ooooooo`1Voooo001Soooo00?o09Wooooo
ool0DOooo`80001Woooo001Soooo00?o09Woooooool0DOooo`030000oooooooo06Koool006?oool0
0ol0VOooooooo`1Aoooo00<0003oooooool0I_ooo`00Hoooo`03o`2Ioooooooo04Woool500000ooo
o`030000oooooooo06Koool006?oool00ol0VOooooooo`1;oooo00<0003oooooool00oooo`030000
oooooooo06Koool006?oool00ol0VOooooooo`1;oooo00<0003oooooool00oooo`<0001Voooo001S
oooo00?o09Woooooool0Boooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001Soooo00?o
09Woooooool0Boooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001Soooo00?o09Wooooo
ool0B_ooo`800005oooo00<0003oooooool0I_ooo`00Hoooo`03o`2Ioooooooo057oool20000Iooo
o`00Hoooo`03o`2Ioooooooo057oool00`000?ooooooo`1Voooo001Soooo00?o09Woooooool0DOoo
o`030000oooooooo06Koool006?oool00ol0VOooooooo`1Aoooo00<0003oooooool0I_ooo`00Hooo
o`03o`2Ioooooooo057oool00`000?ooooooo`1Voooo001Soooo00?o09Woooooool0DOooo`80001W
oooo001Soooo00?o09Woooooool0DOooo`030000oooooooo06Koool006?oool00ol0VOooooooo`1A
oooo00<0003oooooool0I_ooo`00Hoooo`03o`2Ioooooooo057oool00`000?ooooooo`1Voooo001S
oooo00?o09Woooooool0DOooo`80001Woooo001Soooo00?o09Woooooool0DOooo`030000oooooooo
06Koool006?oool00ol0VOooooooo`1Aoooo00<0003oooooool0I_ooo`00Hoooo`03o`2Ioooooooo
057oool00`000?ooooooo`1Voooo001Soooo00?o09Woooooool0DOooo`030000oooooooo06Koool0
06?oool00ol0VOooooooo`1Aoooo0P0006Ooool006?oool00ol0VOooooooo`1Aoooo00<0003ooooo
ool0I_ooo`00Hoooo`03o`2Ioooooooo04Woool400001?ooo`030000oooooooo06Koool006?oool0
0ol0VOooooooo`19oooo00<0003oooooool01Oooo`030000oooooooo06Koool006?oool00ol0VOoo
ooooo`1:oooo00<0003oooooool01?ooo`<0001Voooo001Toooo00?o09Woooooool0B_ooo`030000
oooooooo00?oool00`000?ooooooo`1Voooo001Toooo00?o09Woooooool0B?ooo`040000oooooooo
00001?ooo`030000oooooooo06Koool006Coool00ol0VOooooooo`19oooo0P0000Goool00`000?oo
ooooo`1Voooo001Toooo00?o09Woooooool0D?ooo`80001Woooo001Toooo00?o09Woooooool0D?oo
o`030000oooooooo06Koool006Coool00ol0VOooooooo`1@oooo00<0003oooooool0I_ooo`00I?oo
o`03o`2Ioooooooo053oool00`000?ooooooo`1Voooo001Toooo00?o09Woooooool0D?ooo`030000
oooooooo06Koool006Coool00ol0VOooooooo`1@oooo0P0006Ooool006Coool00ol0VOooooooo`1@
oooo00<0003oooooool0I_ooo`00I?ooo`03o`2Ioooooooo053oool00`000?ooooooo`1Voooo001T
oooo00?o09Woooooool0D?ooo`030000oooooooo06Koool006Coool00ol0VOooooooo`1@oooo0P00
06Ooool006Coool00ol0VOooooooo`1@oooo00<0003oooooool0I_ooo`00I?ooo`03o`2Ioooooooo
053oool00`000?ooooooo`1Voooo001Toooo00?o09Woooooool0D?ooo`030000oooooooo06Koool0
06Coool00ol0VOooooooo`1@oooo00<0003oooooool0I_ooo`00I?ooo`03o`2Ioooooooo053oool2
0000Ioooo`00I?ooo`03o`2Ioooooooo053oool00`000?ooooooo`1Voooo001Toooo00?o09Wooooo
ool0BOooo`800005oooo00<0003oooooool0I_ooo`00I?ooo`03o`2Ioooooooo04Soool010000?oo
ooooo`0000Coool00`000?ooooooo`1Voooo001Toooo00?o09Woooooool0B_ooo`030000oooooooo
00?oool30000I_ooo`00I?ooo`03o`2Ioooooooo04_oool00`000?ooooooo`02oooo00<0003ooooo
ool0I_ooo`00I?ooo`03o`2Ioooooooo04Soool010000?ooooooo`0000Coool00`000?ooooooo`1V
oooo001Toooo00?o09Woooooool0BOooo`800005oooo00<0003oooooool0I_ooo`00I?ooo`03o`2I
oooooooo053oool00`000?ooooooo`1Voooo001Toooo00?o09Woooooool0D?ooo`80001Woooo001T
oooo00?o09Woooooool0D?ooo`030000oooooooo06Koool006Coool00ol0VOooooooo`1@oooo00<0
003oooooool0I_ooo`00I?ooo`03o`2Ioooooooo053oool00`000?ooooooo`1Voooo001Toooo00?o
09Woooooool0D?ooo`80001Woooo001Toooo00?o09Woooooool0D?ooo`030000oooooooo06Koool0
06Coool00ol0VOooooooo`1@oooo00<0003oooooool0I_ooo`00I?ooo`03o`2Ioooooooo053oool0
0`000?ooooooo`1Voooo001Toooo00?o09Woooooool0D?ooo`030000oooooooo06Koool006Coool0
0ol0VOooooooo`1@oooo0P0006Ooool006Coool00ol0VOooooooo`1@oooo00<0003oooooool0I_oo
o`00I?ooo`03o`2Ioooooooo053oool00`000?ooooooo`1Voooo001Toooo00?o09Woooooool0D?oo
o`030000oooooooo06Koool006Coool00ol0VOooooooo`1@oooo0P0006Ooool006Coool00ol0VOoo
ooooo`1@oooo00<0003oooooool0I_ooo`00I?ooo`03o`2Ioooooooo053oool00`000?ooooooo`1V
oooo001Toooo00?o09Woooooool0B_ooo`<00003oooo00<0003oooooool0I_ooo`00I?ooo`03o`2I
oooooooo04_oool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00I?ooo`03o`2Ioooooooo
04Soool500000oooo`<0001Voooo002_oooo00@0003oooooool0001]oooo002`oooo00<0003oool0
0000KOooo`00/Oooo`80001]oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0X
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0
003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool5
00000_ooo`800003oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07
oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool0
0`000?ooooooo`0Eoooo00<0003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500005?ooo`030000oooooooo00Ooool300001?ooo`030000
oooooooo07Soool007Soool01@000?ooooooooooo`00000Goooo00<0003oooooool02?ooo`030000
oooooooo00?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0`00
00;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.28158 .26487 L
.30316 .26487 L
.31323 .26487 L
.32392 .26487 L
.33304 .26487 L
.33554 .26487 L
.33823 .26487 L
.33953 .26487 L
.34076 .26487 L
s
.34076 .26487 m
.34121 .61803 L
s
0 .4 1 r
.02381 .26194 m
.06244 .2609 L
.10458 .25933 L
.14415 .25731 L
.18221 .25467 L
.22272 .25085 L
.26171 .24584 L
.28158 .24265 L
.30316 .23859 L
.31323 .23646 L
.32392 .23401 L
.33304 .23177 L
.33554 .23112 L
.33823 .23042 L
.33953 .23007 L
.34076 .22974 L
.34187 .26487 L
.34309 .26487 L
.38373 .26487 L
.42286 .26487 L
.46444 .26487 L
.50451 .26487 L
.54306 .26487 L
.58406 .26487 L
.62355 .26487 L
.66152 .26487 L
.70195 .26487 L
.74085 .26487 L
.78222 .26487 L
.82206 .26487 L
.86039 .26487 L
.90117 .26487 L
.94044 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`09oooo0P1Voa7oool010000?ooooooooooo`80000K<ol000<0
000co`0co`006S?o0080000N<ol000@0000co`000000000Loooo00<0003oooooool09_ooo`004Ooo
o`@00003oooo0P0001Ooool400000_ooo`040000oooooooo00005oooo`@00005oooo00<0003ooooo
ool01?ooo`@0I_l00oooo`1Vooooo`09oooo100000Coool300005C?o00@00004<ol000<0000co`0c
o`006S?o00030000<ol0<ol001dco`00100003?o03?o03?o0080000Koooo00<0003oooooool09Ooo
o`006?ooo`030000oooooooo01goool00`000?ooo`00000Moooo00@0003oooooool00003oooo0`1V
o`Goool00`1Vooooooooo`0>oooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o
00030000<ol0<ol000<co`0300005_ooo`040000oooooooo00009_ooo`006?ooo`<0000Noooo0P00
01koool20000101Vo`Soool00`1Vooooooooo`0<oooo1@0001hco`02000073?o00030000<ol0<ol0
01`co`02000023?o00@0000Coooo0P0002Ooool0057oool:06Ko3?ooo`0306Kooooooooo00[oool2
0000@C?o00030000<ol0<ol002Xco`030000>Oooo`00C?ooo`D0I_lFoooo00<0I_ooooooool01_oo
o`@00013<ol00P0002hco`020000=oooo`00A?ooo`P0I_lKoooo00@0I_ooooooooooool50000Ac?o
00030000<ol0<ol002lco`040000<oooo`00<Ooooa<0I_lMoooo1P00000406Ko000000000000C3?o
00030000<ol0<ol003<co`0:0000:Oooo`005_oooa/0I_lUoooo2`0000Hco`000`1Voc?o03?o001=
<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00017oool001Koool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
10000?ooooooool0V@;oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool04_ooo`005_ooo`030000oooooooo01goool00`000?ooooooo`0Noooo00<0003ooooo
ool03Oooo`03o`2Ioooooooo00goool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000
oooooooo01goool00`000?ooooooo`0Noooo00<0003oooooool09Oooo`00Ioooo`03o`2Ioooooooo
04goool00`000?ooooooo`1Voooo001Woooo00?o09Woooooool0COooo`030000oooooooo06Koool0
06Ooool00ol0VOooooooo`1=oooo0P0006Ooool006Ooool00ol0VOooooooo`1=oooo00<0003ooooo
ool0I_ooo`00Ioooo`03o`2Ioooooooo04goool00`000?ooooooo`1Voooo001Woooo00?o09Wooooo
ool0COooo`030000oooooooo06Koool006Ooool00ol0VOooooooo`1=oooo0P0006Ooool006Ooool0
0ol0VOooooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04goool00`000?oo
ooooo`1Voooo001Woooo00?o09Woooooool0COooo`030000oooooooo06Koool006Ooool00ol0VOoo
ooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04goool20000Ioooo`00Iooo
o`03o`2Ioooooooo04goool00`000?ooooooo`1Voooo001Woooo00?o09Woooooool0COooo`030000
oooooooo06Koool006Ooool00ol0VOooooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2I
oooooooo04goool20000Ioooo`00Ioooo`03o`2Ioooooooo04goool00`000?ooooooo`1Voooo001W
oooo00?o09Woooooool0COooo`030000oooooooo06Koool006Ooool00ol0VOooooooo`15oooo1@00
00?oool00`000?ooooooo`1Voooo001Woooo00?o09Woooooool0Aoooo`030000oooooooo00?oool0
0`000?ooooooo`1Voooo001Woooo00?o09Woooooool0Aoooo`030000oooooooo00?oool30000I_oo
o`00Ioooo`03o`2Ioooooooo04Ooool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00Iooo
o`03o`2Ioooooooo04Ooool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00Ioooo`03o`2I
oooooooo04Koool200001Oooo`030000oooooooo06Koool006Ooool00ol0VOooooooo`1=oooo0P00
06Ooool006Ooool00ol0VOooooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo
04goool00`000?ooooooo`1Voooo001Woooo00?o09Woooooool0COooo`030000oooooooo06Koool0
06Ooool00ol0VOooooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04goool2
0000Ioooo`00Ioooo`03o`2Ioooooooo04goool00`000?ooooooo`1Voooo001Woooo00?o09Wooooo
ool0COooo`030000oooooooo06Koool006Ooool00ol0VOooooooo`1=oooo00<0003oooooool0I_oo
o`00Ioooo`03o`2Ioooooooo04goool20000Ioooo`00Ioooo`03o`2Ioooooooo04goool00`000?oo
ooooo`1Voooo001Woooo00?o09Woooooool0COooo`030000oooooooo06Koool006Ooool00ol0VOoo
ooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04goool00`000?ooooooo`1V
oooo001Woooo00?o09Woooooool0COooo`80001Woooo001Woooo00?o09Woooooool0COooo`030000
oooooooo06Koool006Ooool00ol0VOooooooo`15oooo100000Coool00`000?ooooooo`1Voooo001W
oooo00?o09Woooooool0AOooo`030000oooooooo00Goool00`000?ooooooo`1Voooo001Woooo00?o
09Woooooool0A_ooo`030000oooooooo00Coool30000I_ooo`00Ioooo`03o`2Ioooooooo04Ooool0
0`000?ooooooo`03oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04Goool010000?oo
ooooo`0000Coool00`000?ooooooo`1Voooo001Woooo00?o09Woooooool0A_ooo`800005oooo00<0
003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04goool20000Ioooo`00Ioooo`03o`2Ioooooooo
04goool00`000?ooooooo`1Voooo001Woooo00?o09Woooooool0COooo`030000oooooooo06Koool0
06Ooool00ol0VOooooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04goool0
0`000?ooooooo`1Voooo001Woooo00?o09Woooooool0COooo`80001Woooo001Woooo00?o09Wooooo
ool0COooo`030000oooooooo06Koool006Ooool00ol0VOooooooo`1=oooo00<0003oooooool0I_oo
o`00Ioooo`03o`2Ioooooooo04goool00`000?ooooooo`1Voooo001Woooo00?o09Woooooool0COoo
o`80001Woooo001Woooo00?o09Woooooool0COooo`030000oooooooo06Koool006Ooool00ol0VOoo
ooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04goool00`000?ooooooo`1V
oooo001Woooo00?o09Woooooool0COooo`030000oooooooo06Koool006Ooool00ol0VOooooooo`1=
oooo0P0006Ooool006Ooool00ol0VOooooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2I
oooooooo04Koool200001Oooo`030000oooooooo06Koool006Ooool00ol0VOooooooo`15oooo00@0
003oooooool00004oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04Ooool00`000?oo
ooooo`03oooo0`0006Koool006Ooool00ol0VOooooooo`18oooo00<0003oooooool00_ooo`030000
oooooooo06Koool006Ooool00ol0VOooooooo`15oooo00@0003oooooool00004oooo00<0003ooooo
ool0I_ooo`00Ioooo`03o`2Ioooooooo04Koool200001Oooo`030000oooooooo06Koool006Ooool0
0ol0VOooooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04goool20000Iooo
o`00Ioooo`03o`2Ioooooooo04goool00`000?ooooooo`1Voooo001Woooo00?o09Woooooool0COoo
o`030000oooooooo06Koool006Ooool00ol0VOooooooo`1=oooo00<0003oooooool0I_ooo`00Iooo
o`03o`2Ioooooooo04goool20000Ioooo`00Ioooo`03o`2Ioooooooo04goool00`000?ooooooo`1V
oooo001Woooo00?o09Woooooool0COooo`030000oooooooo06Koool006Ooool00ol0VOooooooo`1=
oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo04goool00`000?ooooooo`1Voooo001W
oooo00?o09Woooooool0COooo`80001Woooo001Woooo00?o09Woooooool0COooo`030000oooooooo
06Koool006Ooool00ol0VOooooooo`1=oooo00<0003oooooool0I_ooo`00Ioooo`03o`2Ioooooooo
04goool00`000?ooooooo`1Voooo001Woooo00?o09Woooooool0COooo`80001Woooo001Woooo00?o
09Woooooool0COooo`030000oooooooo06Koool006Ooool00ol0VOooooooo`1=oooo00<0003ooooo
ool0I_ooo`00Ioooo`03o`2Ioooooooo04Ooool300000oooo`030000oooooooo06Koool006Ooool0
0ol0VOooooooo`18oooo00<0003oooooool00_ooo`030000oooooooo06Koool006Ooool00ol0VOoo
ooooo`15oooo1@0000?oool30000I_ooo`00[oooo`040000oooooooo0000KOooo`00/?ooo`030000
oooo000006goool00;7oool20000KOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003ooooo
ool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07ooo
o`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<
oooo1@0000;oool200001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003ooooo
ool01oooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00[oool00`000?ooooooo`02oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool02?ooo`800004oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Ooool00`000?ooooooo`08oooo00<0
003oooooool00oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool3
00000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.32392 .26487 L
.33304 .26487 L
.34309 .26487 L
.34772 .26487 L
.35028 .26487 L
.35154 .26487 L
.35271 .26487 L
.3538 .26487 L
s
.3538 .26487 m
.35427 .61803 L
s
0 .4 1 r
.02381 .26225 m
.06244 .26132 L
.10458 .25992 L
.14415 .25811 L
.18221 .25575 L
.22272 .25233 L
.26171 .24785 L
.30316 .24137 L
.32392 .23727 L
.33304 .23526 L
.34309 .23289 L
.34772 .23173 L
.35028 .23108 L
.35154 .23075 L
.35271 .23045 L
.3538 .23016 L
.35496 .26487 L
.35625 .26487 L
.35742 .26487 L
.36173 .26487 L
.3815 .26487 L
.42157 .26487 L
.46012 .26487 L
.50112 .26487 L
.54061 .26487 L
.57858 .26487 L
.619 .26487 L
.65791 .26487 L
.69927 .26487 L
.73912 .26487 L
.77745 .26487 L
.81823 .26487 L
.8575 .26487 L
.89525 .26487 L
.93545 .26487 L
.97414 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0=oooo00<0I_ooooooool03?ooo`040000oooooooooooo0P00
01/co`000`0003?o03?o000J<ol00P0001hco`00100003?o0000000001coool00`000?ooooooo`0V
oooo000Aoooo100000?oool200005oooo`@00002oooo00@0003oooooool0000Goooo100000Goool0
0`000?ooooooo`09oooo101Vo`Ooool400001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J
<ol000<0000co`0co`007C?o00040000<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000H
oooo00<0003oooooool07Oooo`030000oooo000001goool010000?ooooooo`0000Coool706Ko0ooo
o`0306Kooooooooo00_oool400007S?o00030000<ol0<ol001Xco`000`0003?o03?o000M<ol000<0
000co`0co`000c?o00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`0001koool200007_oo
o`80000506Ko2_ooo`0306Kooooooooo00Woool500007S?o0080000L<ol000<0000co`0co`0073?o
00800008<ol0100001?oool200009oooo`00E_ooo`D0I_l?oooo00<0I_ooooooool01oooo`800011
<ol000<0000co`0co`00:S?o00<0000ioooo001?oooo1`1VoaCoool00`1Vooooooooo`03oooo1000
04<co`020000;S?o0080000goooo0014oooo2`1Voa_oool00`1Vo`00000000030000Ac?o00030000
<ol0<ol002lco`040000<oooo`00>_ooo`X0I_lMoooo2@00000306Ko<ol0<ol004Xco`000`0003?o
03?o000c<ol02P0002Woool001cooolN06Ko7?ooo`/00009<ol000<0I_lco`0co`00BS?o00030000
<ol0<ol003dco`0?00006_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`0B
oooo000Foooo00<0003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`0@oooo00?o
09Woooooool02_ooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07Ooo
o`030000oooooooo01koool00`000?ooooooo`0Uoooo001Zoooo00?o09Woooooool0B_ooo`030000
oooooooo06Koool006[oool00ol0VOooooooo`1:oooo00<0003oooooool0I_ooo`00J_ooo`03o`2I
oooooooo04[oool20000Ioooo`00J_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`1Voooo001Z
oooo00?o09Woooooool0B_ooo`030000oooooooo06Koool006[oool00ol0VOooooooo`1:oooo00<0
003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool20000Ioooo`00J_ooo`03o`2Ioooooooo
04[oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`030000oooooooo06Koool0
06[oool00ol0VOooooooo`1:oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`80001Woooo001Zoooo00?o09Wooooo
ool0B_ooo`030000oooooooo06Koool006[oool00ol0VOooooooo`1:oooo00<0003oooooool0I_oo
o`00J_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_oo
o`80001Woooo001Zoooo00?o09Woooooool0B_ooo`030000oooooooo06Koool006[oool00ol0VOoo
ooooo`1:oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04;oool500000oooo`030000
oooooooo06Koool006[oool00ol0VOooooooo`14oooo00<0003oooooool00oooo`030000oooooooo
06Koool006[oool00ol0VOooooooo`14oooo00<0003oooooool00oooo`<0001Voooo001Zoooo00?o
09Woooooool0A?ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001Zoooo00?o09Wooooo
ool0A?ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0@ooo
o`800005oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool20000Ioooo`00J_oo
o`03o`2Ioooooooo04[oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`030000
oooooooo06Koool006[oool00ol0VOooooooo`1:oooo00<0003oooooool0I_ooo`00J_ooo`03o`2I
oooooooo04[oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`80001Woooo001Z
oooo00?o09Woooooool0B_ooo`030000oooooooo06Koool006[oool00ol0VOooooooo`1:oooo00<0
003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`1Voooo001Zoooo00?o
09Woooooool0B_ooo`80001Woooo001Zoooo00?o09Woooooool0B_ooo`030000oooooooo06Koool0
06[oool00ol0VOooooooo`1:oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`030000oooooooo06Koool006[oool0
0ol0VOooooooo`1:oooo0P0006Ooool006[oool00ol0VOooooooo`1:oooo00<0003oooooool0I_oo
o`00J_ooo`03o`2Ioooooooo04;oool400001?ooo`030000oooooooo06Koool006[oool00ol0VOoo
ooooo`12oooo00<0003oooooool01Oooo`030000oooooooo06Koool006[oool00ol0VOooooooo`13
oooo00<0003oooooool01?ooo`<0001Voooo001Zoooo00?o09Woooooool0A?ooo`030000oooooooo
00?oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0@_ooo`040000oooooooo00001?oo
o`030000oooooooo06Koool006[oool00ol0VOooooooo`13oooo0P0000Goool00`000?ooooooo`1V
oooo001Zoooo00?o09Woooooool0B_ooo`80001Woooo001Zoooo00?o09Woooooool0B_ooo`030000
oooooooo06Koool006[oool00ol0VOooooooo`1:oooo00<0003oooooool0I_ooo`00J_ooo`03o`2I
oooooooo04[oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`030000oooooooo
06Koool006[oool00ol0VOooooooo`1:oooo0P0006Ooool006[oool00ol0VOooooooo`1:oooo00<0
003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`1Voooo001Zoooo00?o
09Woooooool0B_ooo`030000oooooooo06Koool006[oool00ol0VOooooooo`1:oooo0P0006Ooool0
06[oool00ol0VOooooooo`1:oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`030000oooooooo06Koool006[oool0
0ol0VOooooooo`1:oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool20000Iooo
o`00J_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0@ooo
o`800005oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04;oool010000?ooooooo`00
00Coool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0A?ooo`030000oooooooo00?oool3
0000I_ooo`00J_ooo`03o`2Ioooooooo04Goool00`000?ooooooo`02oooo00<0003oooooool0I_oo
o`00J_ooo`03o`2Ioooooooo04;oool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo001Z
oooo00?o09Woooooool0@oooo`800005oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo
04[oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`80001Woooo001Zoooo00?o
09Woooooool0B_ooo`030000oooooooo06Koool006[oool00ol0VOooooooo`1:oooo00<0003ooooo
ool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`1Voooo001Zoooo00?o09Wooooo
ool0B_ooo`80001Woooo001Zoooo00?o09Woooooool0B_ooo`030000oooooooo06Koool006[oool0
0ol0VOooooooo`1:oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool00`000?oo
ooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`030000oooooooo06Koool006[oool00ol0VOoo
ooooo`1:oooo0P0006Ooool006[oool00ol0VOooooooo`1:oooo00<0003oooooool0I_ooo`00J_oo
o`03o`2Ioooooooo04[oool00`000?ooooooo`1Voooo001Zoooo00?o09Woooooool0B_ooo`030000
oooooooo06Koool006[oool00ol0VOooooooo`1:oooo0P0006Ooool006[oool00ol0VOooooooo`1:
oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`1Voooo001Z
oooo00?o09Woooooool0A?ooo`<00003oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo
04Goool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00J_ooo`03o`2Ioooooooo04;oool5
00000oooo`<0001Voooo002_oooo00@0003oooooool0001]oooo002`oooo00<0003oool00000KOoo
o`00/Oooo`80001]oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0
003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003ooooo
ool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_oo
o`800005oooo0`0000;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`0:oooo00D0
003oooooooooool00000N_ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0
003oooooool01oooo`D00003oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000D
oooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`00000Goooo00<0003oooooool02?ooo`030000oooo000000?oool00`000?oo
ooooo`1hoooo001ioooo00<0003oooooool05oooo`80000;oooo0P0000;oool00`000?ooooooo`1i
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.32392 .26487 L
.34309 .26487 L
.35271 .26487 L
.36173 .26487 L
.36405 .26487 L
.3652 .26487 L
.36626 .26487 L
s
.36626 .26487 m
.36675 .61803 L
s
0 .4 1 r
.02381 .26253 m
.06244 .2617 L
.10458 .26045 L
.14415 .25884 L
.18221 .25673 L
.22272 .25369 L
.26171 .24969 L
.30316 .24391 L
.32392 .24026 L
.34309 .23635 L
.35271 .23417 L
.36173 .23199 L
.36405 .23141 L
.3652 .23111 L
.36626 .23084 L
.36748 .26487 L
.36812 .26487 L
.36881 .26487 L
.37114 .26487 L
.3815 .26487 L
.42308 .26487 L
.46315 .26487 L
.5017 .26487 L
.5427 .26487 L
.58219 .26487 L
.62016 .26487 L
.66059 .26487 L
.69949 .26487 L
.74085 .26487 L
.7807 .26487 L
.81903 .26487 L
.85981 .26487 L
.89908 .26487 L
.93683 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo00_oool5
06Ko1?ooo`@00004oooo0`0001Dco`04000013?o00030000<ol0<ol001Xco`000`0003?o03?o000M
<ol000@0000co`0co`0co`0200006oooo`030000oooooooo02Goool001Soool00`000?ooooooo`0M
oooo00<0003oool000007Oooo`040000oooooooo00002Oooo`@0I_l4oooo00<0I_ooooooool02?oo
o`@0000N<ol000<0000co`0co`006S?o00030000<ol0<ol001dco`000`0003?o03?o0003<ol00`00
01Koool010000?ooooooo`0002Koool001Soool300007_ooo`80000Noooo0P0000Goool506Ko2?oo
o`0306Kooooooooo00Koool500007S?o0080000L<ol000<0000co`0co`0073?o00800008<ol01000
01?oool200009oooo`00FOooo`L0I_l=oooo00<0I_ooooooool01?ooo`800011<ol000<0000co`0c
o`00:S?o00<0000ioooo001?oooo2P1VoaCoool00`1Vooooooooo`040000@c?o0080000^<ol00P00
03Ooool004Coool;06Ko7?ooo`8000000`1Vo`0000000017<ol000<0000co`0co`00;c?o00@0000c
oooo000joooo2P1Voagoool:00000S?o000306Ko<ol0<ol004Lco`000`0003?o03?o000c<ol02P00
02Woool001cooolN06Ko7?ooo`/0000<<ol000<0I_lco`0co`00Ac?o00030000<ol0<ol003dco`0?
00006_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`040000
ooooooooo`2I0_ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo01;oool001Koool0
0`000?ooooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo01?oool00ol0VOooooooo`07
oooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003ooooo
ool07_ooo`030000oooooooo02Goool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_oo
o`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aooo
o`80001Woooo001]oooo00?o09Woooooool0Aoooo`030000oooooooo06Koool006goool00ol0VOoo
ooooo`17oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1V
oooo001]oooo00?o09Woooooool0Aoooo`80001Woooo001]oooo00?o09Woooooool0Aoooo`030000
oooooooo06Koool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_ooo`00KOooo`03o`2I
oooooooo04Ooool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aoooo`030000oooooooo
06Koool006goool00ol0VOooooooo`17oooo0P0006Ooool006goool00ol0VOooooooo`17oooo00<0
003oooooool0I_ooo`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1Voooo001]oooo00?o
09Woooooool0Aoooo`030000oooooooo06Koool006goool00ol0VOooooooo`17oooo0P0006Ooool0
06goool00ol0VOooooooo`17oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo04Ooool0
0`000?ooooooo`1Voooo001]oooo00?o09Woooooool0?oooo`D00003oooo00<0003oooooool0I_oo
o`00KOooo`03o`2Ioooooooo047oool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00KOoo
o`03o`2Ioooooooo047oool00`000?ooooooo`03oooo0`0006Koool006goool00ol0VOooooooo`11
oooo00<0003oooooool00oooo`030000oooooooo06Koool006goool00ol0VOooooooo`11oooo00<0
003oooooool00oooo`030000oooooooo06Koool006goool00ol0VOooooooo`10oooo0P0000Goool0
0`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aoooo`80001Woooo001]oooo00?o09Wooooo
ool0Aoooo`030000oooooooo06Koool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_oo
o`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aooo
o`030000oooooooo06Koool006goool00ol0VOooooooo`17oooo0P0006Ooool006goool00ol0VOoo
ooooo`17oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1V
oooo001]oooo00?o09Woooooool0Aoooo`030000oooooooo06Koool006goool00ol0VOooooooo`17
oooo0P0006Ooool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_ooo`00KOooo`03o`2I
oooooooo04Ooool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aoooo`030000oooooooo
06Koool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo
04Ooool20000Ioooo`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1Voooo001]oooo00?o
09Woooooool0?oooo`@00004oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo03ooool0
0`000?ooooooo`05oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo043oool00`000?oo
ooooo`04oooo0`0006Koool006goool00ol0VOooooooo`11oooo00<0003oooooool00oooo`030000
oooooooo06Koool006goool00ol0VOooooooo`0ooooo00@0003oooooool00004oooo00<0003ooooo
ool0I_ooo`00KOooo`03o`2Ioooooooo043oool200001Oooo`030000oooooooo06Koool006goool0
0ol0VOooooooo`17oooo0P0006Ooool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_oo
o`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aooo
o`030000oooooooo06Koool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_ooo`00KOoo
o`03o`2Ioooooooo04Ooool20000Ioooo`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1V
oooo001]oooo00?o09Woooooool0Aoooo`030000oooooooo06Koool006goool00ol0VOooooooo`17
oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo04Ooool20000Ioooo`00KOooo`03o`2I
oooooooo04Ooool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aoooo`030000oooooooo
06Koool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo
04Ooool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aoooo`80001Woooo001]oooo00?o
09Woooooool0Aoooo`030000oooooooo06Koool006goool00ol0VOooooooo`10oooo0P0000Goool0
0`000?ooooooo`1Voooo001]oooo00?o09Woooooool0?oooo`040000oooooooo00001?ooo`030000
oooooooo06Koool006goool00ol0VOooooooo`11oooo00<0003oooooool00oooo`<0001Voooo001]
oooo00?o09Woooooool0@_ooo`030000oooooooo00;oool00`000?ooooooo`1Voooo001]oooo00?o
09Woooooool0?oooo`040000oooooooo00001?ooo`030000oooooooo06Koool006goool00ol0VOoo
ooooo`10oooo0P0000Goool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aoooo`030000
oooooooo06Koool006goool00ol0VOooooooo`17oooo0P0006Ooool006goool00ol0VOooooooo`17
oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1Voooo001]
oooo00?o09Woooooool0Aoooo`030000oooooooo06Koool006goool00ol0VOooooooo`17oooo0P00
06Ooool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo
04Ooool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0Aoooo`030000oooooooo06Koool0
06goool00ol0VOooooooo`17oooo00<0003oooooool0I_ooo`00KOooo`03o`2Ioooooooo04Ooool2
0000Ioooo`00KOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1Voooo001]oooo00?o09Wooooo
ool0Aoooo`030000oooooooo06Koool006goool00ol0VOooooooo`17oooo00<0003oooooool0I_oo
o`00KOooo`03o`2Ioooooooo04Ooool20000Ioooo`00KOooo`03o`2Ioooooooo04Ooool00`000?oo
ooooo`1Voooo001]oooo00?o09Woooooool0Aoooo`030000oooooooo06Koool006goool00ol0VOoo
ooooo`11oooo0`0000?oool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0@_ooo`030000
oooooooo00;oool00`000?ooooooo`1Voooo001]oooo00?o09Woooooool0?oooo`D00003oooo0`00
06Koool00:ooool010000?ooooooo`0006goool00;3oool00`000?ooo`00001]oooo002aoooo0P00
06goool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1i
oooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001h
oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`D00002oooo0P0000Coool2
00001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo00Ooool010000?ooooooo`00
00?oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool0
0`000?ooooooo`09oooo00<0003oooooool00oooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500005?ooo`030000oooooooo00[oool01@000?ooooooooooo`00001joooo001hoooo00D0
003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1i
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.32392 .26487 L
.34309 .26487 L
.36173 .26487 L
.37114 .26487 L
.37372 .26487 L
.37649 .26487 L
.37783 .26487 L
.3791 .26487 L
s
.3791 .26487 m
.37956 .61803 L
s
0 .4 1 r
.02381 .26279 m
.06244 .26205 L
.10458 .26094 L
.14415 .25951 L
.18221 .25764 L
.22272 .25493 L
.26171 .25138 L
.30316 .24624 L
.32392 .24299 L
.34309 .23952 L
.36173 .23565 L
.37114 .23349 L
.37372 .23288 L
.37649 .2322 L
.37783 .23187 L
.3791 .23155 L
.38025 .26487 L
.3815 .26487 L
.42214 .26487 L
.46127 .26487 L
.50286 .26487 L
.54292 .26487 L
.58147 .26487 L
.62248 .26487 L
.66196 .26487 L
.69994 .26487 L
.74036 .26487 L
.77927 .26487 L
.82063 .26487 L
.86048 .26487 L
.8988 .26487 L
.93959 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo013oool3
06Ko00?oool0000000000P0000Coool300005C?o00@00004<ol000<0000co`0co`006S?o00030000
<ol0<ol001dco`00100003?o03?o03?o0080000Koooo00<0003oooooool09Oooo`006?ooo`030000
oooooooo01goool00`000?ooo`00000Moooo00@0003oooooool0000>oooo101Vo`;oool00`1Voooo
ooooo`05oooo100001hco`000`0003?o03?o000J<ol000<0000co`0co`007C?o00030000<ol0<ol0
00<co`0300005_ooo`040000oooooooo00009_ooo`006?ooo`<0000Noooo0P0001koool200002_oo
o`D0I_l6oooo00<0I_ooooooool00oooo`D0000N<ol00P0001`co`000`0003?o03?o000L<ol00P00
00Pco`0400004oooo`80000Woooo001Koooo2P1Vo`_oool0101Vooooooooooooo`800011<ol000<0
000co`0co`00:S?o00<0000ioooo001Foooo1@1VoaGoool0101Vo`000000000004<co`020000;S?o
0080000goooo001?oooo1`1VoaGoool5000000<co`00I_lco`00A3?o00030000<ol0<ol002lco`04
0000<oooo`00>_oooaD0I_lBoooo2P0000Hco`000`1Voc?o03?o0013<ol000<0000co`0co`00<c?o
00X0000Yoooo000Voooo501Voacoool;000043?o000306Ko<ol0<ol004<co`000`0003?o03?o000m
<ol03`0001[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool04_ooo`005_oo
o`030000oooooooo01goool00`000?ooooooo`0Noooo00<0003oooooool05_ooo`03o`2Ioooooooo
00Coool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo01goool00`000?oo
ooooo`0Noooo00<0003oooooool09Oooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1V
oooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo06Koool0073oool00ol0VOooooooo`14
oooo0P0006Ooool0073oool00ol0VOooooooo`14oooo00<0003oooooool0I_ooo`00L?ooo`03o`2I
oooooooo04Coool00`000?ooooooo`1Voooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo
06Koool0073oool00ol0VOooooooo`14oooo0P0006Ooool0073oool00ol0VOooooooo`14oooo00<0
003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1Voooo001`oooo00?o
09Woooooool0A?ooo`030000oooooooo06Koool0073oool00ol0VOooooooo`14oooo00<0003ooooo
ool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool20000Ioooo`00L?ooo`03o`2Ioooooooo04Coool0
0`000?ooooooo`1Voooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo06Koool0073oool0
0ol0VOooooooo`14oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool20000Iooo
o`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1Voooo001`oooo00?o09Woooooool0A?oo
o`030000oooooooo06Koool0073oool00ol0VOooooooo`0loooo1@0000?oool00`000?ooooooo`1V
oooo001`oooo00?o09Woooooool0?_ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo001`
oooo00?o09Woooooool0?_ooo`030000oooooooo00?oool30000I_ooo`00L?ooo`03o`2Ioooooooo
03koool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo03koool0
0`000?ooooooo`03oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo03goool200001Ooo
o`030000oooooooo06Koool0073oool00ol0VOooooooo`14oooo0P0006Ooool0073oool00ol0VOoo
ooooo`14oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1V
oooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo06Koool0073oool00ol0VOooooooo`14
oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool20000Ioooo`00L?ooo`03o`2I
oooooooo04Coool00`000?ooooooo`1Voooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo
06Koool0073oool00ol0VOooooooo`14oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo
04Coool20000Ioooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1Voooo001`oooo00?o
09Woooooool0A?ooo`030000oooooooo06Koool0073oool00ol0VOooooooo`14oooo00<0003ooooo
ool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1Voooo001`oooo00?o09Wooooo
ool0A?ooo`80001Woooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo06Koool0073oool0
0ol0VOooooooo`0loooo100000Coool00`000?ooooooo`1Voooo001`oooo00?o09Woooooool0??oo
o`030000oooooooo00Goool00`000?ooooooo`1Voooo001`oooo00?o09Woooooool0?Oooo`030000
oooooooo00Coool30000I_ooo`00L?ooo`03o`2Ioooooooo03koool00`000?ooooooo`03oooo00<0
003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo03coool010000?ooooooo`0000Coool00`000?oo
ooooo`1Voooo001`oooo00?o09Woooooool0?Oooo`800005oooo00<0003oooooool0I_ooo`00L?oo
o`03o`2Ioooooooo04Coool20000Ioooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1V
oooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo06Koool0073oool00ol0VOooooooo`14
oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1Voooo001`
oooo00?o09Woooooool0A?ooo`80001Woooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo
06Koool0073oool00ol0VOooooooo`14oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo
04Coool00`000?ooooooo`1Voooo001`oooo00?o09Woooooool0A?ooo`80001Woooo001`oooo00?o
09Woooooool0A?ooo`030000oooooooo06Koool0073oool00ol0VOooooooo`14oooo00<0003ooooo
ool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1Voooo001`oooo00?o09Wooooo
ool0A?ooo`030000oooooooo06Koool0073oool00ol0VOooooooo`14oooo0P0006Ooool0073oool0
0ol0VOooooooo`14oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo03goool200001Ooo
o`030000oooooooo06Koool0073oool00ol0VOooooooo`0loooo00@0003oooooool00004oooo00<0
003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo03koool00`000?ooooooo`03oooo0`0006Koool0
073oool00ol0VOooooooo`0ooooo00<0003oooooool00_ooo`030000oooooooo06Koool0073oool0
0ol0VOooooooo`0loooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00L?ooo`03o`2I
oooooooo03goool200001Oooo`030000oooooooo06Koool0073oool00ol0VOooooooo`14oooo00<0
003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool20000Ioooo`00L?ooo`03o`2Ioooooooo
04Coool00`000?ooooooo`1Voooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo06Koool0
073oool00ol0VOooooooo`14oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool2
0000Ioooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1Voooo001`oooo00?o09Wooooo
ool0A?ooo`030000oooooooo06Koool0073oool00ol0VOooooooo`14oooo00<0003oooooool0I_oo
o`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1Voooo001`oooo00?o09Woooooool0A?oo
o`80001Woooo001`oooo00?o09Woooooool0A?ooo`030000oooooooo06Koool0073oool00ol0VOoo
ooooo`14oooo00<0003oooooool0I_ooo`00L?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`1V
oooo001`oooo00?o09Woooooool0A?ooo`80001Woooo001`oooo00?o09Woooooool0A?ooo`030000
oooooooo06Koool0073oool00ol0VOooooooo`14oooo00<0003oooooool0I_ooo`00L?ooo`03o`2I
oooooooo03koool300000oooo`030000oooooooo06Koool0073oool00ol0VOooooooo`0ooooo00<0
003oooooool00_ooo`030000oooooooo06Koool0073oool00ol0VOooooooo`0loooo1@0000?oool3
0000I_ooo`00[oooo`040000oooooooo0000KOooo`00/?ooo`030000oooo000006goool00;7oool2
0000KOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000ooo
o`@00003oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`030000oooooooo
00Coool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool0
0`000?ooooooo`08oooo00<0003oooooool01?ooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500005?ooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000001Ooool00`000?ooooooo`07oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003oooo00<0
003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.36136 .26487 L
.37176 .26487 L
.3815 .26487 L
.3864 .26487 L
.38881 .26487 L
.38999 .26487 L
.39106 .26487 L
s
.39106 .26487 m
.39155 .61803 L
s
0 .4 1 r
.02381 .26303 m
.06244 .26238 L
.10458 .2614 L
.14415 .26013 L
.18221 .25847 L
.22272 .25608 L
.26171 .25294 L
.30316 .24839 L
.34309 .24244 L
.36136 .23908 L
.37176 .23697 L
.3815 .23486 L
.3864 .23374 L
.38881 .23317 L
.38999 .2329 L
.39106 .23264 L
.3923 .26487 L
.39298 .26487 L
.39362 .26487 L
.39642 .26487 L
.40134 .26487 L
.42237 .26487 L
.46092 .26487 L
.50192 .26487 L
.54141 .26487 L
.57938 .26487 L
.6198 .26487 L
.65871 .26487 L
.70007 .26487 L
.73992 .26487 L
.77825 .26487 L
.81903 .26487 L
.8583 .26487 L
.89605 .26487 L
.93625 .26487 L
.97494 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo01Coool4
00001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0co`007C?o00040000
<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003oooooool07Oooo`030000
oooo000001goool010000?ooooooo`0001;oool406Ko00?oool0I_ooool00oooo`@0000N<ol000<0
000co`0co`006S?o00030000<ol0<ol001dco`000`0003?o03?o0003<ol00`0001Koool010000?oo
ooooo`0002Koool001Soool300007_ooo`80000Noooo0P0000ooool406Ko1Oooo`0306Kooooooooo
00D0000N<ol00P0001`co`000`0003?o03?o000L<ol00P0000Pco`0400004oooo`80000Woooo001S
oooo1`1Vo`Woool00`1Vo`0000000011<ol000<0000co`0co`00:S?o00<0000ioooo001Ioooo2P1V
o`goool3000000<0I_lco`0co`00@C?o0080000^<ol00P0003Ooool004ooool:06Ko4_ooo`D00004
<ol000<0I_lco`0co`00@3?o00030000<ol0<ol002lco`040000<oooo`00A?ooo`/0I_lBoooo2P00
00Tco`000`1Voc?o03?o0010<ol000<0000co`0co`00<c?o00X0000Yoooo000Voooo7P1Voa;oool;
00004c?o000306Ko<ol0<ol0040co`000`0003?o03?o000m<ol03`0001[oool0013ooooo00004Ooo
o`005_ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00@0003ooooo
oooo09T3oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`0Boooo000Foooo00<0003oooooool07Oooo`030000
oooooooo01koool00`000?ooooooo`0Ioooo00Go09Woooooooooool000007oooo`030000oooooooo
01goool00`000?ooooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo02Goool007?oool0
0ol0VOooooooo`11oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool00`000?oo
ooooo`1Voooo001coooo00?o09Woooooool0@Oooo`80001Woooo001coooo00?o09Woooooool0@Ooo
o`030000oooooooo06Koool007?oool00ol0VOooooooo`11oooo00<0003oooooool0I_ooo`00Looo
o`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001coooo00?o09Woooooool0@Oooo`80001W
oooo001coooo00?o09Woooooool0@Oooo`030000oooooooo06Koool007?oool00ol0VOooooooo`11
oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001c
oooo00?o09Woooooool0@Oooo`030000oooooooo06Koool007?oool00ol0VOooooooo`11oooo0P00
06Ooool007?oool00ol0VOooooooo`11oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo
047oool00`000?ooooooo`1Voooo001coooo00?o09Woooooool0@Oooo`030000oooooooo06Koool0
07?oool00ol0VOooooooo`11oooo0P0006Ooool007?oool00ol0VOooooooo`11oooo00<0003ooooo
ool0I_ooo`00Loooo`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001coooo00?o09Wooooo
ool0>Oooo`D00003oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo03_oool00`000?oo
ooooo`03oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo03_oool00`000?ooooooo`03
oooo0`0006Koool007?oool00ol0VOooooooo`0koooo00<0003oooooool00oooo`030000oooooooo
06Koool007?oool00ol0VOooooooo`0koooo00<0003oooooool00oooo`030000oooooooo06Koool0
07?oool00ol0VOooooooo`0joooo0P0000Goool00`000?ooooooo`1Voooo001coooo00?o09Wooooo
ool0@Oooo`80001Woooo001coooo00?o09Woooooool0@Oooo`030000oooooooo06Koool007?oool0
0ol0VOooooooo`11oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool00`000?oo
ooooo`1Voooo001coooo00?o09Woooooool0@Oooo`030000oooooooo06Koool007?oool00ol0VOoo
ooooo`11oooo0P0006Ooool007?oool00ol0VOooooooo`11oooo00<0003oooooool0I_ooo`00Looo
o`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001coooo00?o09Woooooool0@Oooo`030000
oooooooo06Koool007?oool00ol0VOooooooo`11oooo0P0006Ooool007?oool00ol0VOooooooo`11
oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001c
oooo00?o09Woooooool0@Oooo`030000oooooooo06Koool007?oool00ol0VOooooooo`11oooo00<0
003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool20000Ioooo`00Loooo`03o`2Ioooooooo
047oool00`000?ooooooo`1Voooo001coooo00?o09Woooooool0>Oooo`@00004oooo00<0003ooooo
ool0I_ooo`00Loooo`03o`2Ioooooooo03Woool00`000?ooooooo`05oooo00<0003oooooool0I_oo
o`00Loooo`03o`2Ioooooooo03[oool00`000?ooooooo`04oooo0`0006Koool007?oool00ol0VOoo
ooooo`0koooo00<0003oooooool00oooo`030000oooooooo06Koool007?oool00ol0VOooooooo`0i
oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo03[oool2
00001Oooo`030000oooooooo06Koool007?oool00ol0VOooooooo`11oooo0P0006Ooool007?oool0
0ol0VOooooooo`11oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool00`000?oo
ooooo`1Voooo001coooo00?o09Woooooool0@Oooo`030000oooooooo06Koool007?oool00ol0VOoo
ooooo`11oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool20000Ioooo`00Looo
o`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001coooo00?o09Woooooool0@Oooo`030000
oooooooo06Koool007?oool00ol0VOooooooo`11oooo00<0003oooooool0I_ooo`00Loooo`03o`2I
oooooooo047oool20000Ioooo`00Loooo`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001c
oooo00?o09Woooooool0@Oooo`030000oooooooo06Koool007?oool00ol0VOooooooo`11oooo00<0
003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001coooo00?o
09Woooooool0@Oooo`80001Woooo001coooo00?o09Woooooool0@Oooo`030000oooooooo06Koool0
07?oool00ol0VOooooooo`0joooo0P0000Goool00`000?ooooooo`1Voooo001coooo00?o09Wooooo
ool0>Oooo`040000oooooooo00001?ooo`030000oooooooo06Koool007?oool00ol0VOooooooo`0k
oooo00<0003oooooool00oooo`<0001Voooo001coooo00?o09Woooooool0??ooo`030000oooooooo
00;oool00`000?ooooooo`1Voooo001coooo00?o09Woooooool0>Oooo`040000oooooooo00001?oo
o`030000oooooooo06Koool007?oool00ol0VOooooooo`0joooo0P0000Goool00`000?ooooooo`1V
oooo001coooo00?o09Woooooool0@Oooo`030000oooooooo06Koool007?oool00ol0VOooooooo`11
oooo0P0006Ooool007?oool00ol0VOooooooo`11oooo00<0003oooooool0I_ooo`00Loooo`03o`2I
oooooooo047oool00`000?ooooooo`1Voooo001coooo00?o09Woooooool0@Oooo`030000oooooooo
06Koool007?oool00ol0VOooooooo`11oooo0P0006Ooool007?oool00ol0VOooooooo`11oooo00<0
003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001coooo00?o
09Woooooool0@Oooo`030000oooooooo06Koool007?oool00ol0VOooooooo`11oooo00<0003ooooo
ool0I_ooo`00Loooo`03o`2Ioooooooo047oool20000Ioooo`00Loooo`03o`2Ioooooooo047oool0
0`000?ooooooo`1Voooo001coooo00?o09Woooooool0@Oooo`030000oooooooo06Koool007?oool0
0ol0VOooooooo`11oooo00<0003oooooool0I_ooo`00Loooo`03o`2Ioooooooo047oool20000Iooo
o`00Loooo`03o`2Ioooooooo047oool00`000?ooooooo`1Voooo001coooo00?o09Woooooool0@Ooo
o`030000oooooooo06Koool007?oool00ol0VOooooooo`0koooo0`0000?oool00`000?ooooooo`1V
oooo001coooo00?o09Woooooool0??ooo`030000oooooooo00;oool00`000?ooooooo`1Voooo001c
oooo00?o09Woooooool0>Oooo`D00003oooo0`0006Koool00:ooool010000?ooooooo`0006goool0
0;3oool00`000?ooo`00001]oooo002aoooo0P0006goool00?oooolQoooo003ooooo8Oooo`00NOoo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03?ooo`D00002oooo0P0000?oool500000_ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Ooo
o`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00Moooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool02Oooo`030000oooooooo00?oool0
0`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001Coool00`000?ooooooo`09oooo00<0
003oooooool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Goooo00<0
003oooooool02Oooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001ioooo00<0003ooooo
ool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool0
0001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.39174 .26487 L
.39675 .26487 L
.40134 .26487 L
.40252 .26487 L
.40381 .26487 L
s
.40381 .26487 m
.4043 .61803 L
s
0 .4 1 r
.02381 .26325 m
.06244 .26268 L
.10458 .26181 L
.14415 .2607 L
.18221 .25924 L
.22272 .25713 L
.26171 .25437 L
.30316 .25037 L
.34309 .24513 L
.3815 .23846 L
.39174 .23637 L
.39675 .23529 L
.40134 .23428 L
.40252 .23401 L
.40381 .23372 L
.40503 .26487 L
.40616 .26487 L
.41134 .26487 L
.42237 .26487 L
.4615 .26487 L
.50308 .26487 L
.54314 .26487 L
.58169 .26487 L
.6227 .26487 L
.66219 .26487 L
.70016 .26487 L
.74058 .26487 L
.77949 .26487 L
.82085 .26487 L
.8607 .26487 L
.89903 .26487 L
.93981 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo01Coool4
00000P1Vo`;oool300005C?o00@00004<ol000<0000co`0co`006S?o00030000<ol0<ol001dco`00
100003?o03?o03?o0080000Koooo00<0003oooooool09Oooo`006?ooo`030000oooooooo01goool0
0`000?ooo`00000Moooo00@0003oooooool0000Goooo0`1Vo`03oooo06Ko000000<0000N<ol000<0
000co`0co`006S?o00030000<ol0<ol001dco`000`0003?o03?o0003<ol00`0001Koool010000?oo
ooooo`0002Koool001Soool300007_ooo`80000Noooo0P0001;oool606Ko0oooo`03000006Ko0000
0080000N<ol00P0001`co`000`0003?o03?o000L<ol00P0000Pco`0400004oooo`80000Woooo001U
oooo201Vo`Ooool2000000<co`00I_lco`00?S?o00030000<ol0<ol002Xco`030000>Oooo`00H?oo
o`D0I_l;oooo100000<co`000`1Voc?o03?o000m<ol00P0002hco`020000=oooo`00FOooo`L0I_l;
oooo1@0000Lco`000`1Voc?o03?o000m<ol000<0000co`0co`00;c?o00@0000coooo0014oooo5@1V
o`Soool:000033?o000306Ko<ol0<ol003dco`000`0003?o03?o000c<ol02P0002Woool002KooolN
06Ko4_ooo`/0000F<ol000<0I_lco`0co`00?C?o00030000<ol0<ol003dco`0?00006_ooo`004?oo
ool0000Aoooo000Foooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`0Boooo000Foooo00<0003oooooool07Ooo
o`030000oooooooo01koool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo
01goool00`000?ooooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo02Goool007Ooool0
0ol0VOooooooo`0moooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool00`000?oo
ooooo`1Voooo001goooo00?o09Woooooool0?Oooo`80001Woooo001goooo00?o09Woooooool0?Ooo
o`030000oooooooo06Koool007Ooool00ol0VOooooooo`0moooo00<0003oooooool0I_ooo`00Mooo
o`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001goooo00?o09Woooooool0?Oooo`80001W
oooo001goooo00?o09Woooooool0?Oooo`030000oooooooo06Koool007Ooool00ol0VOooooooo`0m
oooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001g
oooo00?o09Woooooool0?Oooo`030000oooooooo06Koool007Ooool00ol0VOooooooo`0moooo0P00
06Ooool007Ooool00ol0VOooooooo`0moooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo
03goool00`000?ooooooo`1Voooo001goooo00?o09Woooooool0?Oooo`030000oooooooo06Koool0
07Ooool00ol0VOooooooo`0moooo0P0006Ooool007Ooool00ol0VOooooooo`0moooo00<0003ooooo
ool0I_ooo`00Moooo`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001goooo00?o09Wooooo
ool0=Oooo`D00003oooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03Ooool00`000?oo
ooooo`03oooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03Ooool00`000?ooooooo`03
oooo0`0006Koool007Ooool00ol0VOooooooo`0goooo00<0003oooooool00oooo`030000oooooooo
06Koool007Ooool00ol0VOooooooo`0goooo00<0003oooooool00oooo`030000oooooooo06Koool0
07Ooool00ol0VOooooooo`0foooo0P0000Goool00`000?ooooooo`1Voooo001goooo00?o09Wooooo
ool0?Oooo`80001Woooo001goooo00?o09Woooooool0?Oooo`030000oooooooo06Koool007Ooool0
0ol0VOooooooo`0moooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool00`000?oo
ooooo`1Voooo001goooo00?o09Woooooool0?Oooo`030000oooooooo06Koool007Ooool00ol0VOoo
ooooo`0moooo0P0006Ooool007Ooool00ol0VOooooooo`0moooo00<0003oooooool0I_ooo`00Mooo
o`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001goooo00?o09Woooooool0?Oooo`030000
oooooooo06Koool007Ooool00ol0VOooooooo`0moooo0P0006Ooool007Ooool00ol0VOooooooo`0m
oooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001g
oooo00?o09Woooooool0?Oooo`030000oooooooo06Koool007Ooool00ol0VOooooooo`0moooo00<0
003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool20000Ioooo`00Moooo`03o`2Ioooooooo
03goool00`000?ooooooo`1Voooo001goooo00?o09Woooooool0=Oooo`@00004oooo00<0003ooooo
ool0I_ooo`00Moooo`03o`2Ioooooooo03Goool00`000?ooooooo`05oooo00<0003oooooool0I_oo
o`00Moooo`03o`2Ioooooooo03Koool00`000?ooooooo`04oooo0`0006Koool007Ooool00ol0VOoo
ooooo`0goooo00<0003oooooool00oooo`030000oooooooo06Koool007Ooool00ol0VOooooooo`0e
oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03Koool2
00001Oooo`030000oooooooo06Koool007Ooool00ol0VOooooooo`0moooo0P0006Ooool007Ooool0
0ol0VOooooooo`0moooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool00`000?oo
ooooo`1Voooo001goooo00?o09Woooooool0?Oooo`030000oooooooo06Koool007Ooool00ol0VOoo
ooooo`0moooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool20000Ioooo`00Mooo
o`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001goooo00?o09Woooooool0?Oooo`030000
oooooooo06Koool007Ooool00ol0VOooooooo`0moooo00<0003oooooool0I_ooo`00Moooo`03o`2I
oooooooo03goool20000Ioooo`00Moooo`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001g
oooo00?o09Woooooool0?Oooo`030000oooooooo06Koool007Ooool00ol0VOooooooo`0moooo00<0
003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001goooo00?o
09Woooooool0?Oooo`80001Woooo001goooo00?o09Woooooool0?Oooo`030000oooooooo06Koool0
07Ooool00ol0VOooooooo`0foooo0P0000Goool00`000?ooooooo`1Voooo001goooo00?o09Wooooo
ool0=Oooo`040000oooooooo00001?ooo`030000oooooooo06Koool007Ooool00ol0VOooooooo`0g
oooo00<0003oooooool00oooo`<0001Voooo001goooo00?o09Woooooool0>?ooo`030000oooooooo
00;oool00`000?ooooooo`1Voooo001goooo00?o09Woooooool0=Oooo`040000oooooooo00001?oo
o`030000oooooooo06Koool007Ooool00ol0VOooooooo`0foooo0P0000Goool00`000?ooooooo`1V
oooo001goooo00?o09Woooooool0?Oooo`030000oooooooo06Koool007Ooool00ol0VOooooooo`0m
oooo0P0006Ooool007Ooool00ol0VOooooooo`0moooo00<0003oooooool0I_ooo`00Moooo`03o`2I
oooooooo03goool00`000?ooooooo`1Voooo001goooo00?o09Woooooool0?Oooo`030000oooooooo
06Koool007Ooool00ol0VOooooooo`0moooo0P0006Ooool007Ooool00ol0VOooooooo`0moooo00<0
003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001goooo00?o
09Woooooool0?Oooo`030000oooooooo06Koool007Ooool00ol0VOooooooo`0moooo00<0003ooooo
ool0I_ooo`00Moooo`03o`2Ioooooooo03goool20000Ioooo`00Moooo`03o`2Ioooooooo03goool0
0`000?ooooooo`1Voooo001goooo00?o09Woooooool0?Oooo`030000oooooooo06Koool007Ooool0
0ol0VOooooooo`0moooo00<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo03goool20000Iooo
o`00Moooo`03o`2Ioooooooo03goool00`000?ooooooo`1Voooo001goooo00?o09Woooooool0?Ooo
o`030000oooooooo06Koool007Ooool00ol0VOooooooo`0goooo0`0000?oool00`000?ooooooo`1V
oooo001goooo00?o09Woooooool0>?ooo`030000oooooooo00;oool00`000?ooooooo`1Voooo001g
oooo00?o09Woooooool0=Oooo`D00003oooo0`0006Koool00:ooool010000?ooooooo`0006goool0
0;3oool00`000?ooo`00001]oooo002aoooo0P0006goool00?oooolQoooo003ooooo8Oooo`00O?oo
o`030000oooooooo02;oool00`000?ooooooo`1loooo001koooo00<0003oooooool02?ooo`030000
oooooooo01Woool00`000?ooooooo`1koooo001koooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03?ooo`D00002oooo0P0000Coool00`000?ooooooo`1koooo001koooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?oo
ooooo`08oooo00<0003oooooool0Noooo`00N_ooo`030000oooooooo00;oool00`000?ooooooo`0E
oooo00<0003oooooool02Oooo`030000oooooooo07[oool007_oool00`000?ooooooo`0500005?oo
o`030000oooooooo00Soool00`000?ooooooo`1koooo001koooo00D0003oooooooooool000005ooo
o`030000oooooooo00Soool00`000?ooooooo`1koooo001loooo00<0003oooooool05oooo`800009
oooo00<0003oooooool0O?ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.40134 .26487 L
.41134 .26487 L
.41408 .26487 L
.4156 .26487 L
.41634 .26487 L
.41703 .26487 L
s
.41703 .26487 m
.41729 .61803 L
s
0 .4 1 r
.02381 .26346 m
.06244 .26295 L
.10458 .2622 L
.14415 .26123 L
.18221 .25995 L
.22272 .25811 L
.26171 .2557 L
.30316 .2522 L
.34309 .24763 L
.3815 .2418 L
.40134 .23815 L
.41134 .23612 L
.41408 .23554 L
.4156 .23522 L
.41634 .23506 L
.41703 .23491 L
.41768 .26487 L
.41837 .26487 L
.41982 .26487 L
.42237 .26487 L
.46395 .26487 L
.50401 .26487 L
.54257 .26487 L
.58357 .26487 L
.62306 .26487 L
.66103 .26487 L
.70145 .26487 L
.74036 .26487 L
.78172 .26487 L
.82157 .26487 L
.8599 .26487 L
.90068 .26487 L
.93994 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo01Coool4
00001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0co`007C?o00040000
<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003oooooool07Oooo`030000
oooo000001goool010000?ooooooo`0001Soool406Ko00@00000I_l0I_l0000N<ol000<0000co`0c
o`006S?o00030000<ol0<ol001dco`000`0003?o03?o0003<ol00`0001Koool010000?ooooooo`00
02Koool001Soool300007_ooo`80000Noooo0P0001Coool506Ko0_ooo`D0000N<ol00P0001`co`00
0`0003?o03?o000L<ol00P0000Pco`0400004oooo`80000Woooo001Zoooo1@1Vo`Goool2000013?o
000306Ko<ol0<ol003Xco`000`0003?o03?o000Z<ol00`0003Woool006?oool706Ko1_ooo`@00006
<ol000<0I_lco`0co`00>S?o0080000^<ol00P0003Ooool005Woool:06Ko2?ooo`D0000:<ol000<0
I_lco`0co`00>S?o00030000<ol0<ol002lco`040000<oooo`00Coooo`X0I_l8oooo2P0000lco`00
0`1Voc?o03?o000j<ol000<0000co`0co`00<c?o00X0000Yoooo000aoooo7P1Vo`Ooool;00006C?o
000306Ko<ol0<ol003Xco`000`0003?o03?o000m<ol03`0001[oool0013ooooo00004Oooo`005_oo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`040000ooooooooo`2I0_ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`0Boooo000Foooo00<0003oooooool07Oooo`030000oooooooo
01koool00`000?ooooooo`0Moooo00@0003ooooooooo09TLoooo00<0003oooooool07Oooo`030000
oooooooo01goool00`000?ooooooo`0Noooo00<0003oooooool09Oooo`00N_ooo`03o`2Ioooooooo
03[oool00`000?ooooooo`1Voooo001joooo00?o09Woooooool0>_ooo`030000oooooooo06Koool0
07[oool00ol0VOooooooo`0joooo0P0006Ooool007[oool00ol0VOooooooo`0joooo00<0003ooooo
ool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool00`000?ooooooo`1Voooo001joooo00?o09Wooooo
ool0>_ooo`030000oooooooo06Koool007[oool00ol0VOooooooo`0joooo0P0006Ooool007[oool0
0ol0VOooooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool00`000?oo
ooooo`1Voooo001joooo00?o09Woooooool0>_ooo`030000oooooooo06Koool007[oool00ol0VOoo
ooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool20000Ioooo`00N_oo
o`03o`2Ioooooooo03[oool00`000?ooooooo`1Voooo001joooo00?o09Woooooool0>_ooo`030000
oooooooo06Koool007[oool00ol0VOooooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2I
oooooooo03[oool20000Ioooo`00N_ooo`03o`2Ioooooooo03[oool00`000?ooooooo`1Voooo001j
oooo00?o09Woooooool0>_ooo`030000oooooooo06Koool007[oool00ol0VOooooooo`0boooo1@00
00?oool00`000?ooooooo`1Voooo001joooo00?o09Woooooool0=?ooo`030000oooooooo00?oool0
0`000?ooooooo`1Voooo001joooo00?o09Woooooool0=?ooo`030000oooooooo00?oool30000I_oo
o`00N_ooo`03o`2Ioooooooo03Coool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00N_oo
o`03o`2Ioooooooo03Coool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00N_ooo`03o`2I
oooooooo03?oool200001Oooo`030000oooooooo06Koool007[oool00ol0VOooooooo`0joooo0P00
06Ooool007[oool00ol0VOooooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo
03[oool00`000?ooooooo`1Voooo001joooo00?o09Woooooool0>_ooo`030000oooooooo06Koool0
07[oool00ol0VOooooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool2
0000Ioooo`00N_ooo`03o`2Ioooooooo03[oool00`000?ooooooo`1Voooo001joooo00?o09Wooooo
ool0>_ooo`030000oooooooo06Koool007[oool00ol0VOooooooo`0joooo00<0003oooooool0I_oo
o`00N_ooo`03o`2Ioooooooo03[oool20000Ioooo`00N_ooo`03o`2Ioooooooo03[oool00`000?oo
ooooo`1Voooo001joooo00?o09Woooooool0>_ooo`030000oooooooo06Koool007[oool00ol0VOoo
ooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool00`000?ooooooo`1V
oooo001joooo00?o09Woooooool0>_ooo`80001Woooo001joooo00?o09Woooooool0>_ooo`030000
oooooooo06Koool007[oool00ol0VOooooooo`0boooo100000Coool00`000?ooooooo`1Voooo001j
oooo00?o09Woooooool0<_ooo`030000oooooooo00Goool00`000?ooooooo`1Voooo001joooo00?o
09Woooooool0<oooo`030000oooooooo00Coool30000I_ooo`00N_ooo`03o`2Ioooooooo03Coool0
0`000?ooooooo`03oooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03;oool010000?oo
ooooo`0000Coool00`000?ooooooo`1Voooo001joooo00?o09Woooooool0<oooo`800005oooo00<0
003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool20000Ioooo`00N_ooo`03o`2Ioooooooo
03[oool00`000?ooooooo`1Voooo001joooo00?o09Woooooool0>_ooo`030000oooooooo06Koool0
07[oool00ol0VOooooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool0
0`000?ooooooo`1Voooo001joooo00?o09Woooooool0>_ooo`80001Woooo001joooo00?o09Wooooo
ool0>_ooo`030000oooooooo06Koool007[oool00ol0VOooooooo`0joooo00<0003oooooool0I_oo
o`00N_ooo`03o`2Ioooooooo03[oool00`000?ooooooo`1Voooo001joooo00?o09Woooooool0>_oo
o`80001Woooo001joooo00?o09Woooooool0>_ooo`030000oooooooo06Koool007[oool00ol0VOoo
ooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool00`000?ooooooo`1V
oooo001joooo00?o09Woooooool0>_ooo`030000oooooooo06Koool007[oool00ol0VOooooooo`0j
oooo0P0006Ooool007[oool00ol0VOooooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2I
oooooooo03?oool200001Oooo`030000oooooooo06Koool007[oool00ol0VOooooooo`0boooo00@0
003oooooool00004oooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03Coool00`000?oo
ooooo`03oooo0`0006Koool007[oool00ol0VOooooooo`0eoooo00<0003oooooool00_ooo`030000
oooooooo06Koool007[oool00ol0VOooooooo`0boooo00@0003oooooool00004oooo00<0003ooooo
ool0I_ooo`00N_ooo`03o`2Ioooooooo03?oool200001Oooo`030000oooooooo06Koool007[oool0
0ol0VOooooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool20000Iooo
o`00N_ooo`03o`2Ioooooooo03[oool00`000?ooooooo`1Voooo001joooo00?o09Woooooool0>_oo
o`030000oooooooo06Koool007[oool00ol0VOooooooo`0joooo00<0003oooooool0I_ooo`00N_oo
o`03o`2Ioooooooo03[oool20000Ioooo`00N_ooo`03o`2Ioooooooo03[oool00`000?ooooooo`1V
oooo001joooo00?o09Woooooool0>_ooo`030000oooooooo06Koool007[oool00ol0VOooooooo`0j
oooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo03[oool00`000?ooooooo`1Voooo001j
oooo00?o09Woooooool0>_ooo`80001Woooo001joooo00?o09Woooooool0>_ooo`030000oooooooo
06Koool007[oool00ol0VOooooooo`0joooo00<0003oooooool0I_ooo`00N_ooo`03o`2Ioooooooo
03[oool00`000?ooooooo`1Voooo001joooo00?o09Woooooool0>_ooo`80001Woooo001joooo00?o
09Woooooool0>_ooo`030000oooooooo06Koool007[oool00ol0VOooooooo`0joooo00<0003ooooo
ool0I_ooo`00N_ooo`03o`2Ioooooooo03Coool300000oooo`030000oooooooo06Koool007[oool0
0ol0VOooooooo`0eoooo00<0003oooooool00_ooo`030000oooooooo06Koool007[oool00ol0VOoo
ooooo`0boooo1@0000?oool30000I_ooo`00[oooo`040000oooooooo0000KOooo`00/?ooo`030000
oooo000006goool00;7oool20000KOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003ooooo
ool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07ooo
o`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=
oooo0P0000Coool200000oooo`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003ooooo
ool0000:oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool04oooo`040000oooooooo00002Oooo`<00004oooo00<0003oooooool0Mooo
o`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05ooo
o`80000:oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.40095 .26487 L
.41127 .26487 L
.41696 .26487 L
.42237 .26487 L
.42482 .26487 L
.42744 .26487 L
.42821 .26487 L
.42894 .26487 L
.4296 .26487 L
s
.4296 .26487 m
.42988 .61803 L
s
0 .4 1 r
.02381 .26365 m
.06244 .26321 L
.10458 .26256 L
.14415 .26172 L
.18221 .26062 L
.22272 .25902 L
.26171 .25694 L
.30316 .25391 L
.34309 .24996 L
.3815 .24491 L
.40095 .24182 L
.41127 .24001 L
.41696 .23897 L
.42237 .23794 L
.42482 .23746 L
.42744 .23695 L
.42821 .2368 L
.42894 .23665 L
.4296 .23652 L
.43031 .26487 L
.43098 .26487 L
.4317 .26487 L
.43298 .26487 L
.44268 .26487 L
.46172 .26487 L
.49969 .26487 L
.54011 .26487 L
.57902 .26487 L
.62038 .26487 L
.66023 .26487 L
.69856 .26487 L
.73934 .26487 L
.77861 .26487 L
.81636 .26487 L
.85656 .26487 L
.89525 .26487 L
.93639 .26487 L
.97601 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo01Coool4
00001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0co`007C?o00040000
<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003oooooool07Oooo`030000
oooo000001goool010000?ooooooo`0001coool400000P1Voa`co`000`0003?o03?o000J<ol000<0
000co`0co`007C?o00030000<ol0<ol000<co`0300005_ooo`040000oooooooo00009_ooo`006?oo
o`<0000Noooo0P0001koool200006Oooo`D0I_l200000S?o000306Ko<ol0<ol001Tco`02000073?o
00030000<ol0<ol001`co`02000023?o00@0000Coooo0P0002Ooool006goool706Ko0P0000Lco`00
0`1Voc?o03?o000g<ol000<0000co`0co`00:S?o00<0000ioooo001Soooo2P1Vo`?oool400002C?o
000306Ko<ol0<ol003Lco`020000;S?o0080000goooo001Ioooo2P1Vo`Soool500003C?o000306Ko
<ol0<ol003Lco`000`0003?o03?o000_<ol0100003?oool004ooool:06Ko2?ooo`X0000B<ol000<0
I_lco`0co`00=c?o00030000<ol0<ol003<co`0:0000:Oooo`00<Ooooah0I_l7oooo2`0001`co`00
0`1Voc?o03?o000g<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00017oool001Koool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo01;oool001Koool00`000?ooooooo`0Moooo00<0003oooooool07_oo
o`030000oooooooo01goool00`000?ooooooo`03oooo00?o09Woooooool05oooo`030000oooooooo
01goool00`000?ooooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo02Goool007goool0
0ol0VOooooooo`0goooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool00`000?oo
ooooo`1Voooo001moooo00?o09Woooooool0=oooo`80001Woooo001moooo00?o09Woooooool0=ooo
o`030000oooooooo06Koool007goool00ol0VOooooooo`0goooo00<0003oooooool0I_ooo`00OOoo
o`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001moooo00?o09Woooooool0=oooo`80001W
oooo001moooo00?o09Woooooool0=oooo`030000oooooooo06Koool007goool00ol0VOooooooo`0g
oooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001m
oooo00?o09Woooooool0=oooo`030000oooooooo06Koool007goool00ol0VOooooooo`0goooo0P00
06Ooool007goool00ol0VOooooooo`0goooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo
03Ooool00`000?ooooooo`1Voooo001moooo00?o09Woooooool0=oooo`030000oooooooo06Koool0
07goool00ol0VOooooooo`0goooo0P0006Ooool007goool00ol0VOooooooo`0goooo00<0003ooooo
ool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001moooo00?o09Wooooo
ool0;oooo`D00003oooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo037oool00`000?oo
ooooo`03oooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo037oool00`000?ooooooo`03
oooo0`0006Koool007goool00ol0VOooooooo`0aoooo00<0003oooooool00oooo`030000oooooooo
06Koool007goool00ol0VOooooooo`0aoooo00<0003oooooool00oooo`030000oooooooo06Koool0
07goool00ol0VOooooooo`0`oooo0P0000Goool00`000?ooooooo`1Voooo001moooo00?o09Wooooo
ool0=oooo`80001Woooo001moooo00?o09Woooooool0=oooo`030000oooooooo06Koool007goool0
0ol0VOooooooo`0goooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool00`000?oo
ooooo`1Voooo001moooo00?o09Woooooool0=oooo`030000oooooooo06Koool007goool00ol0VOoo
ooooo`0goooo0P0006Ooool007goool00ol0VOooooooo`0goooo00<0003oooooool0I_ooo`00OOoo
o`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001moooo00?o09Woooooool0=oooo`030000
oooooooo06Koool007goool00ol0VOooooooo`0goooo0P0006Ooool007goool00ol0VOooooooo`0g
oooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001m
oooo00?o09Woooooool0=oooo`030000oooooooo06Koool007goool00ol0VOooooooo`0goooo00<0
003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool20000Ioooo`00OOooo`03o`2Ioooooooo
03Ooool00`000?ooooooo`1Voooo001moooo00?o09Woooooool0;oooo`@00004oooo00<0003ooooo
ool0I_ooo`00OOooo`03o`2Ioooooooo02ooool00`000?ooooooo`05oooo00<0003oooooool0I_oo
o`00OOooo`03o`2Ioooooooo033oool00`000?ooooooo`04oooo0`0006Koool007goool00ol0VOoo
ooooo`0aoooo00<0003oooooool00oooo`030000oooooooo06Koool007goool00ol0VOooooooo`0_
oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo033oool2
00001Oooo`030000oooooooo06Koool007goool00ol0VOooooooo`0goooo0P0006Ooool007goool0
0ol0VOooooooo`0goooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool00`000?oo
ooooo`1Voooo001moooo00?o09Woooooool0=oooo`030000oooooooo06Koool007goool00ol0VOoo
ooooo`0goooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool20000Ioooo`00OOoo
o`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001moooo00?o09Woooooool0=oooo`030000
oooooooo06Koool007goool00ol0VOooooooo`0goooo00<0003oooooool0I_ooo`00OOooo`03o`2I
oooooooo03Ooool20000Ioooo`00OOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001m
oooo00?o09Woooooool0=oooo`030000oooooooo06Koool007goool00ol0VOooooooo`0goooo00<0
003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001moooo00?o
09Woooooool0=oooo`80001Woooo001moooo00?o09Woooooool0=oooo`030000oooooooo06Koool0
07goool00ol0VOooooooo`0`oooo0P0000Goool00`000?ooooooo`1Voooo001moooo00?o09Wooooo
ool0;oooo`040000oooooooo00001?ooo`030000oooooooo06Koool007goool00ol0VOooooooo`0a
oooo00<0003oooooool00oooo`<0001Voooo001moooo00?o09Woooooool0<_ooo`030000oooooooo
00;oool00`000?ooooooo`1Voooo001moooo00?o09Woooooool0;oooo`040000oooooooo00001?oo
o`030000oooooooo06Koool007goool00ol0VOooooooo`0`oooo0P0000Goool00`000?ooooooo`1V
oooo001moooo00?o09Woooooool0=oooo`030000oooooooo06Koool007goool00ol0VOooooooo`0g
oooo0P0006Ooool007goool00ol0VOooooooo`0goooo00<0003oooooool0I_ooo`00OOooo`03o`2I
oooooooo03Ooool00`000?ooooooo`1Voooo001moooo00?o09Woooooool0=oooo`030000oooooooo
06Koool007goool00ol0VOooooooo`0goooo0P0006Ooool007goool00ol0VOooooooo`0goooo00<0
003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001moooo00?o
09Woooooool0=oooo`030000oooooooo06Koool007goool00ol0VOooooooo`0goooo00<0003ooooo
ool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool20000Ioooo`00OOooo`03o`2Ioooooooo03Ooool0
0`000?ooooooo`1Voooo001moooo00?o09Woooooool0=oooo`030000oooooooo06Koool007goool0
0ol0VOooooooo`0goooo00<0003oooooool0I_ooo`00OOooo`03o`2Ioooooooo03Ooool20000Iooo
o`00OOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`1Voooo001moooo00?o09Woooooool0=ooo
o`030000oooooooo06Koool007goool00ol0VOooooooo`0aoooo0`0000?oool00`000?ooooooo`1V
oooo001moooo00?o09Woooooool0<_ooo`030000oooooooo00;oool00`000?ooooooo`1Voooo001m
oooo00?o09Woooooool0;oooo`D00003oooo0`0006Koool00:ooool010000?ooooooo`0006goool0
0;3oool00`000?ooo`00001]oooo002aoooo0P0006goool00?oooolQoooo003ooooo8Oooo`00NOoo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03Oooo`800004oooo0P0000Coool200001?ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000ooo
o`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo
00001?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500004_ooo`040000oooooooo
00002Oooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Goool0
10000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0
003oooooool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00oooo
ob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.40095 .26487 L
.42237 .26487 L
.43215 .26487 L
.43755 .26487 L
.44021 .26487 L
.44151 .26487 L
.44268 .26487 L
s
.44268 .26487 m
.44316 .61803 L
s
0 .4 1 r
.02381 .26383 m
.06244 .26346 L
.10458 .2629 L
.14415 .26218 L
.18221 .26124 L
.22272 .25988 L
.26171 .25809 L
.30316 .25551 L
.34309 .25213 L
.3815 .24783 L
.40095 .24518 L
.42237 .24187 L
.43215 .24021 L
.43755 .23926 L
.44021 .23879 L
.44151 .23855 L
.44268 .23834 L
.44387 .26487 L
.44498 .26487 L
.44744 .26487 L
.45262 .26487 L
.46172 .26487 L
.50027 .26487 L
.54127 .26487 L
.58076 .26487 L
.61873 .26487 L
.65915 .26487 L
.69806 .26487 L
.73942 .26487 L
.77927 .26487 L
.8176 .26487 L
.85838 .26487 L
.89765 .26487 L
.9354 .26487 L
.9756 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo01Coool4
00001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0co`007C?o00040000
<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003oooooool07Oooo`030000
oooo000001goool010000?ooooooo`0001coool4000013?o000306Ko<ol0<ol001Lco`000`0003?o
03?o000J<ol000<0000co`0co`007C?o00030000<ol0<ol000<co`0300005_ooo`040000oooooooo
00009_ooo`006?ooo`<0000Noooo0P0001koool200006oooo`D0000606Ko63?o0080000L<ol000<0
000co`0co`0073?o00800008<ol0100001?oool200009oooo`00M?ooo`D0I_l7<ol000<0I_lco`0c
o`00=3?o00030000<ol0<ol002Xco`030000>Oooo`00KOooo`L0I_l<<ol000<0I_lco`0co`00=3?o
0080000^<ol00P0003Ooool006?oool:06Ko0`00014co`000`1Voc?o03?o000c<ol000<0000co`0c
o`00;c?o00@0000coooo001Ioooo2P1Vo`P0000F<ol000<0I_lco`0co`00<c?o00030000<ol0<ol0
03<co`0:0000:Oooo`00>_oooal0I_l8000083?o000306Ko<ol0<ol003<co`000`0003?o03?o000m
<ol03`0001[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool010000?ooooooool0
V@?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`0Boooo000F
oooo00<0003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`0Moooo00<0003ooooo
ool01_ooo`03o`2Ioooooooo01Coool00`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000
oooooooo01koool00`000?ooooooo`0Uoooo0020oooo00?o09Woooooool0=?ooo`030000oooooooo
06Koool0083oool00ol0VOooooooo`0doooo00<0003oooooool0I_ooo`00P?ooo`03o`2Ioooooooo
03Coool20000Ioooo`00P?ooo`03o`2Ioooooooo03Coool00`000?ooooooo`1Voooo0020oooo00?o
09Woooooool0=?ooo`030000oooooooo06Koool0083oool00ol0VOooooooo`0doooo00<0003ooooo
ool0I_ooo`00P?ooo`03o`2Ioooooooo03Coool20000Ioooo`00P?ooo`03o`2Ioooooooo03Coool0
0`000?ooooooo`1Voooo0020oooo00?o09Woooooool0=?ooo`030000oooooooo06Koool0083oool0
0ol0VOooooooo`0doooo00<0003oooooool0I_ooo`00P?ooo`03o`2Ioooooooo03Coool00`000?oo
ooooo`1Voooo0020oooo00?o09Woooooool0=?ooo`80001Woooo0020oooo00?o09Woooooool0=?oo
o`030000oooooooo06Koool0083oool00ol0VOooooooo`0doooo00<0003oooooool0I_ooo`00P?oo
o`03o`2Ioooooooo03Coool00`000?ooooooo`1Voooo0020oooo00?o09Woooooool0=?ooo`80001W
oooo0020oooo00?o09Woooooool0=?ooo`030000oooooooo06Koool0083oool00ol0VOooooooo`0d
oooo00<0003oooooool0I_ooo`00P?ooo`03o`2Ioooooooo02coool500000oooo`030000oooooooo
06Koool0083oool00ol0VOooooooo`0^oooo00<0003oooooool00oooo`030000oooooooo06Koool0
083oool00ol0VOooooooo`0^oooo00<0003oooooool00oooo`<0001Voooo0020oooo00?o09Wooooo
ool0;_ooo`030000oooooooo00?oool00`000?ooooooo`1Voooo0020oooo00?o09Woooooool0;_oo
o`030000oooooooo00?oool00`000?ooooooo`1Voooo0020oooo00?o09Woooooool0;Oooo`800005
oooo00<0003oooooool0I_ooo`00P?ooo`03o`2Ioooooooo03Coool20000Ioooo`00P?ooo`03o`2I
oooooooo03Coool00`000?ooooooo`1Voooo0020oooo00?o09Woooooool0=?ooo`030000oooooooo
06Koool0083oool00ol0VOooooooo`0doooo00<0003oooooool0I_ooo`00P?ooo`03o`2Ioooooooo
03Coool00`000?ooooooo`1Voooo0020oooo00?o09Woooooool0=?ooo`80001Woooo0020oooo00?o
09Woooooool0=?ooo`030000oooooooo06Koool0083oool00ol0VOooooooo`0doooo00<0003ooooo
ool0I_ooo`00P?ooo`03o`2Ioooooooo03Coool00`000?ooooooo`1Voooo0020oooo00?o09Wooooo
ool0=?ooo`80001Woooo0020oooo00?o09Woooooool0=?ooo`030000oooooooo06Koool0083oool0
0ol0VOooooooo`0doooo00<0003oooooool0I_ooo`00P?ooo`03o`2Ioooooooo03Coool00`000?oo
ooooo`1Voooo0020oooo00?o09Woooooool0=?ooo`030000oooooooo06Koool0083oool00ol0VOoo
ooooo`0doooo0P0006Ooool0083oool00ol0VOooooooo`0doooo00<0003oooooool0I_ooo`00P?oo
o`03o`2Ioooooooo02coool400001?ooo`030000oooooooo06Koool0083oool00ol0VOooooooo`0/
oooo00<0003oooooool01Oooo`030000oooooooo06Koool0083oool00ol0VOooooooo`0]oooo00<0
003oooooool01?ooo`<0001Voooo0021oooo00?o09Woooooool0;Oooo`030000oooooooo00?oool0
0`000?ooooooo`1Voooo0021oooo00?o09Woooooool0:oooo`040000oooooooo00001?ooo`030000
oooooooo06Koool0087oool00ol0VOooooooo`0/oooo0P0000Goool00`000?ooooooo`1Voooo0021
oooo00?o09Woooooool0<oooo`80001Woooo0021oooo00?o09Woooooool0<oooo`030000oooooooo
06Koool0087oool00ol0VOooooooo`0coooo00<0003oooooool0I_ooo`00POooo`03o`2Ioooooooo
03?oool00`000?ooooooo`1Voooo0021oooo00?o09Woooooool0<oooo`030000oooooooo06Koool0
087oool00ol0VOooooooo`0coooo0P0006Ooool0087oool00ol0VOooooooo`0coooo00<0003ooooo
ool0I_ooo`00POooo`03o`2Ioooooooo03?oool00`000?ooooooo`1Voooo0021oooo00?o09Wooooo
ool0<oooo`030000oooooooo06Koool0087oool00ol0VOooooooo`0coooo0P0006Ooool0087oool0
0ol0VOooooooo`0coooo00<0003oooooool0I_ooo`00POooo`03o`2Ioooooooo03?oool00`000?oo
ooooo`1Voooo0021oooo00?o09Woooooool0<oooo`030000oooooooo06Koool0087oool00ol0VOoo
ooooo`0coooo00<0003oooooool0I_ooo`00POooo`03o`2Ioooooooo03?oool20000Ioooo`00POoo
o`03o`2Ioooooooo03?oool00`000?ooooooo`1Voooo0021oooo00?o09Woooooool0;?ooo`800005
oooo00<0003oooooool0I_ooo`00POooo`03o`2Ioooooooo02_oool010000?ooooooo`0000Coool0
0`000?ooooooo`1Voooo0021oooo00?o09Woooooool0;Oooo`030000oooooooo00?oool30000I_oo
o`00POooo`03o`2Ioooooooo02koool00`000?ooooooo`02oooo00<0003oooooool0I_ooo`00POoo
o`03o`2Ioooooooo02_oool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo0021oooo00?o
09Woooooool0;?ooo`800005oooo00<0003oooooool0I_ooo`00POooo`03o`2Ioooooooo03?oool0
0`000?ooooooo`1Voooo0021oooo00?o09Woooooool0<oooo`80001Woooo0021oooo00?o09Wooooo
ool0<oooo`030000oooooooo06Koool0087oool00ol0VOooooooo`0coooo00<0003oooooool0I_oo
o`00POooo`03o`2Ioooooooo03?oool00`000?ooooooo`1Voooo0021oooo00?o09Woooooool0<ooo
o`80001Woooo0021oooo00?o09Woooooool0<oooo`030000oooooooo06Koool0087oool00ol0VOoo
ooooo`0coooo00<0003oooooool0I_ooo`00POooo`03o`2Ioooooooo03?oool00`000?ooooooo`1V
oooo0021oooo00?o09Woooooool0<oooo`030000oooooooo06Koool0087oool00ol0VOooooooo`0c
oooo0P0006Ooool0087oool00ol0VOooooooo`0coooo00<0003oooooool0I_ooo`00POooo`03o`2I
oooooooo03?oool00`000?ooooooo`1Voooo0021oooo00?o09Woooooool0<oooo`030000oooooooo
06Koool0087oool00ol0VOooooooo`0coooo0P0006Ooool0087oool00ol0VOooooooo`0coooo00<0
003oooooool0I_ooo`00POooo`03o`2Ioooooooo03?oool00`000?ooooooo`1Voooo0021oooo00?o
09Woooooool0;Oooo`<00003oooo00<0003oooooool0I_ooo`00POooo`03o`2Ioooooooo02koool0
0`000?ooooooo`02oooo00<0003oooooool0I_ooo`00POooo`03o`2Ioooooooo02_oool500000ooo
o`<0001Voooo002_oooo00@0003oooooool0001]oooo002`oooo00<0003oool00000KOooo`00/Ooo
o`80001]oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003ooooo
ool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?oo
o`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005
oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002_oo
o`030000oooooooo00;oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000
oooooooo01?oool010000?ooooooo`0000[oool00`000?ooooooo`03oooo00<0003oooooool0Mooo
o`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool0000;oooo00D0003oooooooooool0
0000N_ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`800009oooo1000
00;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.40095 .26487 L
.42237 .26487 L
.43215 .26487 L
.44268 .26487 L
.44778 .26487 L
.45029 .26487 L
.45262 .26487 L
.45371 .26487 L
.45473 .26487 L
s
.45473 .26487 m
.4552 .61803 L
s
0 .4 1 r
.02381 .26399 m
.06244 .26368 L
.10458 .26322 L
.14415 .26261 L
.18221 .26182 L
.22272 .26068 L
.26171 .25918 L
.30316 .25701 L
.34309 .25418 L
.3815 .25056 L
.40095 .24834 L
.42237 .24557 L
.43215 .24418 L
.44268 .2426 L
.44778 .24181 L
.45029 .24141 L
.45262 .24104 L
.45371 .24087 L
.45473 .2407 L
.4559 .26487 L
.45697 .26487 L
.46172 .26487 L
.50027 .26487 L
.54127 .26487 L
.58076 .26487 L
.61873 .26487 L
.65915 .26487 L
.69806 .26487 L
.73942 .26487 L
.77927 .26487 L
.8176 .26487 L
.85838 .26487 L
.89765 .26487 L
.9354 .26487 L
.9756 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo01Coool4
00001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0co`007C?o00040000
<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003oooooool07Oooo`030000
oooo000001goool010000?ooooooo`0001coool400007S?o00030000<ol0<ol001Xco`000`0003?o
03?o000M<ol000<0000co`0co`000c?o00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`00
01koool200007_ooo`80000Koooo1@0000Lco`0206Ko5C?o0080000L<ol000<0000co`0co`0073?o
00800008<ol0100001?oool200009oooo`00M?ooo`800003<ol02@1Vo`03<ol006Ko<ol0038co`00
0`0003?o03?o000Z<ol00`0003Woool0073oool400001@1Vo`Xco`000`1Voc?o03?o000a<ol00P00
02hco`020000=oooo`00Joooo`80000706Ko3c?o000306Ko<ol0<ol0034co`000`0003?o03?o000_
<ol0100003?oool005WooolD06Ko5c?o000306Ko<ol0<ol0030co`000`0003?o03?o000c<ol02P00
02Woool003[ooolO06Ko200002<co`000`1Voc?o03?o000`<ol000<0000co`0co`00?C?o00l0000J
oooo000@ooooo`00017oool001Koool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`03o`2I
0000oooo00Coool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo01;oool001Koool00`000?oo
ooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo01goool00`000?ooooooo`09oooo00?o
09Woooooool04Oooo`030000oooooooo01goool00`000?ooooooo`0Moooo00<0003oooooool07_oo
o`030000oooooooo02Goool008?oool00ol0VOooooooo`0aoooo00<0003oooooool0I_ooo`00Pooo
o`03o`2Ioooooooo037oool00`000?ooooooo`1Voooo0023oooo00?o09Woooooool0<Oooo`80001W
oooo0023oooo00?o09Woooooool0<Oooo`030000oooooooo06Koool008?oool00ol0VOooooooo`0a
oooo00<0003oooooool0I_ooo`00Poooo`03o`2Ioooooooo037oool00`000?ooooooo`1Voooo0023
oooo00?o09Woooooool0<Oooo`80001Woooo0023oooo00?o09Woooooool0<Oooo`030000oooooooo
06Koool008?oool00ol0VOooooooo`0aoooo00<0003oooooool0I_ooo`00Poooo`03o`2Ioooooooo
037oool00`000?ooooooo`1Voooo0023oooo00?o09Woooooool0<Oooo`030000oooooooo06Koool0
08?oool00ol0VOooooooo`0aoooo0P0006Ooool008?oool00ol0VOooooooo`0aoooo00<0003ooooo
ool0I_ooo`00Poooo`03o`2Ioooooooo037oool00`000?ooooooo`1Voooo0023oooo00?o09Wooooo
ool0<Oooo`030000oooooooo06Koool008?oool00ol0VOooooooo`0aoooo0P0006Ooool008?oool0
0ol0VOooooooo`0aoooo00<0003oooooool0I_ooo`00Poooo`03o`2Ioooooooo037oool00`000?oo
ooooo`1Voooo0023oooo00?o09Woooooool0:Oooo`D00003oooo00<0003oooooool0I_ooo`00Pooo
o`03o`2Ioooooooo02_oool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00Poooo`03o`2I
oooooooo02_oool00`000?ooooooo`03oooo0`0006Koool008?oool00ol0VOooooooo`0[oooo00<0
003oooooool00oooo`030000oooooooo06Koool008?oool00ol0VOooooooo`0[oooo00<0003ooooo
ool00oooo`030000oooooooo06Koool008?oool00ol0VOooooooo`0Zoooo0P0000Goool00`000?oo
ooooo`1Voooo0023oooo00?o09Woooooool0<Oooo`80001Woooo0023oooo00?o09Woooooool0<Ooo
o`030000oooooooo06Koool008?oool00ol0VOooooooo`0aoooo00<0003oooooool0I_ooo`00Pooo
o`03o`2Ioooooooo037oool00`000?ooooooo`1Voooo0023oooo00?o09Woooooool0<Oooo`030000
oooooooo06Koool008?oool00ol0VOooooooo`0aoooo0P0006Ooool008?oool00ol0VOooooooo`0a
oooo00<0003oooooool0I_ooo`00Poooo`03o`2Ioooooooo037oool00`000?ooooooo`1Voooo0023
oooo00?o09Woooooool0<Oooo`030000oooooooo06Koool008?oool00ol0VOooooooo`0aoooo0P00
06Ooool008?oool00ol0VOooooooo`0aoooo00<0003oooooool0I_ooo`00Poooo`03o`2Ioooooooo
037oool00`000?ooooooo`1Voooo0023oooo00?o09Woooooool0<Oooo`030000oooooooo06Koool0
08?oool00ol0VOooooooo`0aoooo00<0003oooooool0I_ooo`00Poooo`03o`2Ioooooooo037oool2
0000Ioooo`00Poooo`03o`2Ioooooooo037oool00`000?ooooooo`1Voooo0023oooo00?o09Wooooo
ool0:Oooo`@00004oooo00<0003oooooool0I_ooo`00Poooo`03o`2Ioooooooo02Woool00`000?oo
ooooo`05oooo00<0003oooooool0I_ooo`00Poooo`03o`2Ioooooooo02[oool00`000?ooooooo`04
oooo0`0006Koool008Coool00ol0VOooooooo`0Zoooo00<0003oooooool00oooo`030000oooooooo
06Koool008Coool00ol0VOooooooo`0Xoooo00@0003oooooool00004oooo00<0003oooooool0I_oo
o`00Q?ooo`03o`2Ioooooooo02Woool200001Oooo`030000oooooooo06Koool008Coool00ol0VOoo
ooooo`0`oooo0P0006Ooool008Coool00ol0VOooooooo`0`oooo00<0003oooooool0I_ooo`00Q?oo
o`03o`2Ioooooooo033oool00`000?ooooooo`1Voooo0024oooo00?o09Woooooool0<?ooo`030000
oooooooo06Koool008Coool00ol0VOooooooo`0`oooo00<0003oooooool0I_ooo`00Q?ooo`03o`2I
oooooooo033oool20000Ioooo`00Q?ooo`03o`2Ioooooooo033oool00`000?ooooooo`1Voooo0024
oooo00?o09Woooooool0<?ooo`030000oooooooo06Koool008Coool00ol0VOooooooo`0`oooo00<0
003oooooool0I_ooo`00Q?ooo`03o`2Ioooooooo033oool20000Ioooo`00Q?ooo`03o`2Ioooooooo
033oool00`000?ooooooo`1Voooo0024oooo00?o09Woooooool0<?ooo`030000oooooooo06Koool0
08Coool00ol0VOooooooo`0`oooo00<0003oooooool0I_ooo`00Q?ooo`03o`2Ioooooooo033oool0
0`000?ooooooo`1Voooo0024oooo00?o09Woooooool0<?ooo`80001Woooo0024oooo00?o09Wooooo
ool0<?ooo`030000oooooooo06Koool008Coool00ol0VOooooooo`0Yoooo0P0000Goool00`000?oo
ooooo`1Voooo0024oooo00?o09Woooooool0:?ooo`040000oooooooo00001?ooo`030000oooooooo
06Koool008Coool00ol0VOooooooo`0Zoooo00<0003oooooool00oooo`<0001Voooo0024oooo00?o
09Woooooool0:oooo`030000oooooooo00;oool00`000?ooooooo`1Voooo0024oooo00?o09Wooooo
ool0:?ooo`040000oooooooo00001?ooo`030000oooooooo06Koool008Coool00ol0VOooooooo`0Y
oooo0P0000Goool00`000?ooooooo`1Voooo0024oooo00?o09Woooooool0<?ooo`030000oooooooo
06Koool008Coool00ol0VOooooooo`0`oooo0P0006Ooool008Coool00ol0VOooooooo`0`oooo00<0
003oooooool0I_ooo`00Q?ooo`03o`2Ioooooooo033oool00`000?ooooooo`1Voooo0024oooo00?o
09Woooooool0<?ooo`030000oooooooo06Koool008Coool00ol0VOooooooo`0`oooo0P0006Ooool0
08Coool00ol0VOooooooo`0`oooo00<0003oooooool0I_ooo`00Q?ooo`03o`2Ioooooooo033oool0
0`000?ooooooo`1Voooo0024oooo00?o09Woooooool0<?ooo`030000oooooooo06Koool008Coool0
0ol0VOooooooo`0`oooo00<0003oooooool0I_ooo`00Q?ooo`03o`2Ioooooooo033oool20000Iooo
o`00Q?ooo`03o`2Ioooooooo033oool00`000?ooooooo`1Voooo0024oooo00?o09Woooooool0<?oo
o`030000oooooooo06Koool008Coool00ol0VOooooooo`0`oooo00<0003oooooool0I_ooo`00Q?oo
o`03o`2Ioooooooo033oool20000Ioooo`00Q?ooo`03o`2Ioooooooo033oool00`000?ooooooo`1V
oooo0024oooo00?o09Woooooool0<?ooo`030000oooooooo06Koool008Coool00ol0VOooooooo`0Z
oooo0`0000?oool00`000?ooooooo`1Voooo0024oooo00?o09Woooooool0:oooo`030000oooooooo
00;oool00`000?ooooooo`1Voooo0024oooo00?o09Woooooool0:?ooo`D00003oooo0`0006Koool0
0:ooool010000?ooooooo`0006goool00;3oool00`000?ooo`00001]oooo002aoooo0P0006goool0
0?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001h
oooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000?oool300001?oo
o`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000
oooooooo00002?ooo`040000oooooooo00001?ooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500004_ooo`040000oooooooo00002?ooo`<00004oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooooooo`03oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`<00002oooo00<0003ooooo
ool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.44268 .26487 L
.45262 .26487 L
.46172 .26487 L
.46388 .26487 L
.46618 .26487 L
.46687 .26487 L
.46751 .26487 L
s
.46751 .26487 m
.46799 .61803 L
s
0 .4 1 r
.02381 .26415 m
.06244 .2639 L
.10458 .26352 L
.14415 .26302 L
.18221 .26237 L
.22272 .26144 L
.26171 .26021 L
.30316 .25844 L
.34309 .25612 L
.3815 .25316 L
.42237 .24907 L
.44268 .24664 L
.45262 .24537 L
.46172 .24415 L
.46388 .24385 L
.46618 .24354 L
.46687 .24344 L
.46751 .24335 L
.46871 .26487 L
.46984 .26487 L
.47106 .26487 L
.47994 .26487 L
.49955 .26487 L
.54055 .26487 L
.58004 .26487 L
.61801 .26487 L
.65844 .26487 L
.69735 .26487 L
.73871 .26487 L
.77855 .26487 L
.81688 .26487 L
.85766 .26487 L
.89693 .26487 L
.93468 .26487 L
.97489 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo01Coool4
00001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0co`007C?o00040000
<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003oooooool07Oooo`030000
oooo000001goool010000?ooooooo`0001coool400007S?o00030000<ol0<ol001Xco`000`0003?o
03?o000M<ol000<0000co`0co`000c?o00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`00
01koool200007_ooo`80000Koooo1@0001hco`02000073?o00030000<ol0<ol001`co`02000023?o
00@0000Coooo0P0002Ooool007Coool2000033?o00H0I_l_<ol000<0000co`0co`00:S?o00<0000i
oooo001`oooo100000<co`0;06Ko1C?o000306Ko<ol0<ol002dco`020000;S?o0080000goooo001[
oooo0P0000X0I_l@<ol000<0I_lco`0co`00;C?o00030000<ol0<ol002lco`040000<oooo`00HOoo
o`80000:06Ko6S?o000306Ko<ol0<ol002dco`000`0003?o03?o000c<ol02P0002Woool004CooolO
06Ko93?o000306Ko<ol0<ol002dco`000`0003?o03?o000m<ol03`0001[oool0013ooooo00004Ooo
o`005_ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00@0003ooooooooo09T2oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`0Boooo000Foooo00<0003oooooool07Oooo`030000
oooooooo01koool00`000?ooooooo`0Moooo00<0003oooooool03Oooo`03o`2Ioooooooo00goool0
0`000?ooooooo`0Moooo00<0003oooooool07Oooo`030000oooooooo01koool00`000?ooooooo`0U
oooo0027oooo00?o09Woooooool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]
oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02goool20000Ioooo`00Qoooo`03o`2I
oooooooo02goool00`000?ooooooo`1Voooo0027oooo00?o09Woooooool0;Oooo`030000oooooooo
06Koool008Ooool00ol0VOooooooo`0]oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo
02goool20000Ioooo`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1Voooo0027oooo00?o
09Woooooool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]oooo00<0003ooooo
ool0I_ooo`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1Voooo0027oooo00?o09Wooooo
ool0;Oooo`80001Woooo0027oooo00?o09Woooooool0;Oooo`030000oooooooo06Koool008Ooool0
0ol0VOooooooo`0]oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02goool00`000?oo
ooooo`1Voooo0027oooo00?o09Woooooool0;Oooo`80001Woooo0027oooo00?o09Woooooool0;Ooo
o`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]oooo00<0003oooooool0I_ooo`00Qooo
o`03o`2Ioooooooo02Goool500000oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0W
oooo00<0003oooooool00oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0Woooo00<0
003oooooool00oooo`<0001Voooo0027oooo00?o09Woooooool09oooo`030000oooooooo00?oool0
0`000?ooooooo`1Voooo0027oooo00?o09Woooooool09oooo`030000oooooooo00?oool00`000?oo
ooooo`1Voooo0027oooo00?o09Woooooool09_ooo`800005oooo00<0003oooooool0I_ooo`00Qooo
o`03o`2Ioooooooo02goool20000Ioooo`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1V
oooo0027oooo00?o09Woooooool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]
oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1Voooo0027
oooo00?o09Woooooool0;Oooo`80001Woooo0027oooo00?o09Woooooool0;Oooo`030000oooooooo
06Koool008Ooool00ol0VOooooooo`0]oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo
02goool00`000?ooooooo`1Voooo0027oooo00?o09Woooooool0;Oooo`80001Woooo0027oooo00?o
09Woooooool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]oooo00<0003ooooo
ool0I_ooo`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1Voooo0027oooo00?o09Wooooo
ool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]oooo0P0006Ooool008Ooool0
0ol0VOooooooo`0]oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02Goool400001?oo
o`030000oooooooo06Koool008Ooool00ol0VOooooooo`0Uoooo00<0003oooooool01Oooo`030000
oooooooo06Koool008Ooool00ol0VOooooooo`0Voooo00<0003oooooool01?ooo`<0001Voooo0027
oooo00?o09Woooooool09oooo`030000oooooooo00?oool00`000?ooooooo`1Voooo0027oooo00?o
09Woooooool09Oooo`040000oooooooo00001?ooo`030000oooooooo06Koool008Ooool00ol0VOoo
ooooo`0Voooo0P0000Goool00`000?ooooooo`1Voooo0027oooo00?o09Woooooool0;Oooo`80001W
oooo0027oooo00?o09Woooooool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]
oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1Voooo0027
oooo00?o09Woooooool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]oooo0P00
06Ooool008Ooool00ol0VOooooooo`0]oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo
02goool00`000?ooooooo`1Voooo0027oooo00?o09Woooooool0;Oooo`030000oooooooo06Koool0
08Ooool00ol0VOooooooo`0]oooo0P0006Ooool008Ooool00ol0VOooooooo`0]oooo00<0003ooooo
ool0I_ooo`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1Voooo0027oooo00?o09Wooooo
ool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]oooo00<0003oooooool0I_oo
o`00Qoooo`03o`2Ioooooooo02goool20000Ioooo`00Qoooo`03o`2Ioooooooo02goool00`000?oo
ooooo`1Voooo0027oooo00?o09Woooooool09_ooo`800005oooo00<0003oooooool0I_ooo`00Qooo
o`03o`2Ioooooooo02Goool010000?ooooooo`0000Coool00`000?ooooooo`1Voooo0027oooo00?o
09Woooooool09oooo`030000oooooooo00?oool30000I_ooo`00Qoooo`03o`2Ioooooooo02Soool0
0`000?ooooooo`02oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02Goool010000?oo
ooooo`0000Coool00`000?ooooooo`1Voooo0027oooo00?o09Woooooool09_ooo`800005oooo00<0
003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1Voooo0027oooo00?o
09Woooooool0;Oooo`80001Woooo0027oooo00?o09Woooooool0;Oooo`030000oooooooo06Koool0
08Ooool00ol0VOooooooo`0]oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02goool0
0`000?ooooooo`1Voooo0027oooo00?o09Woooooool0;Oooo`80001Woooo0027oooo00?o09Wooooo
ool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]oooo00<0003oooooool0I_oo
o`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1Voooo0027oooo00?o09Woooooool0;Ooo
o`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]oooo0P0006Ooool008Ooool00ol0VOoo
ooooo`0]oooo00<0003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02goool00`000?ooooooo`1V
oooo0027oooo00?o09Woooooool0;Oooo`030000oooooooo06Koool008Ooool00ol0VOooooooo`0]
oooo0P0006Ooool008Ooool00ol0VOooooooo`0]oooo00<0003oooooool0I_ooo`00Qoooo`03o`2I
oooooooo02goool00`000?ooooooo`1Voooo0027oooo00?o09Woooooool09oooo`<00003oooo00<0
003oooooool0I_ooo`00Qoooo`03o`2Ioooooooo02Soool00`000?ooooooo`02oooo00<0003ooooo
ool0I_ooo`00Qoooo`03o`2Ioooooooo02Goool500000oooo`<0001Voooo002_oooo00@0003ooooo
ool0001]oooo002`oooo00<0003oool00000KOooo`00/Oooo`80001]oooo003ooooo8Oooo`00oooo
ob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo
00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool2
00001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000Coool00`000?ooooooo`1h
oooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04
oooo100000?oool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1h
oooo001goooo00<0003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000_oool0
0`000?ooooooo`02oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0
003oooooool00009oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00005Oooo`040000oooooooo00002Oooo`030000oooooooo00?oool00`000?ooooooo`1hoooo001i
oooo00<0003oooooool05oooo`80000:oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Ooo
o`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.44268 .26487 L
.46172 .26487 L
.47106 .26487 L
.47567 .26487 L
.47791 .26487 L
.47889 .26487 L
.47994 .26487 L
s
.47994 .26487 m
.48043 .61803 L
s
0 .4 1 r
.02381 .26431 m
.06244 .2641 L
.10458 .2638 L
.14415 .26341 L
.18221 .2629 L
.22272 .26217 L
.26171 .2612 L
.30316 .2598 L
.34309 .25797 L
.3815 .25564 L
.42237 .25242 L
.44268 .2505 L
.46172 .24854 L
.47106 .24752 L
.47567 .247 L
.47791 .24675 L
.47889 .24664 L
.47994 .24652 L
.48116 .26487 L
.48231 .26487 L
.48484 .26487 L
.49018 .26487 L
.49955 .26487 L
.54055 .26487 L
.58004 .26487 L
.61801 .26487 L
.65844 .26487 L
.69735 .26487 L
.73871 .26487 L
.77855 .26487 L
.81688 .26487 L
.85766 .26487 L
.89693 .26487 L
.93468 .26487 L
.97489 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo01Coool4
00001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0co`007C?o00040000
<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003oooooool07Oooo`030000
oooo000001goool010000?ooooooo`0001coool400007S?o00030000<ol0<ol001Xco`000`0003?o
03?o000M<ol000<0000co`0co`000c?o00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`00
01koool200007_ooo`80000Koooo1@0001hco`02000073?o00030000<ol0<ol001`co`02000023?o
00@0000Coooo0P0002Ooool007Coool20000@C?o00030000<ol0<ol002Xco`030000>Oooo`00L?oo
o`@0000?<ol0201Vob`co`020000;S?o0080000goooo001[oooo1@0000Lco`0<06Ko1c?o000306Ko
<ol0<ol002Xco`000`0003?o03?o000_<ol0100003?oool0067oool20000501Voa<co`000`1Voc?o
03?o000Z<ol000<0000co`0co`00<c?o00X0000Yoooo001?oooo501VobLco`000`1Voc?o03?o000Z
<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00017oool001Koool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000
oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo01;oool001Koool00`000?ooooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo
01goool00`000?ooooooo`0@oooo00?o09Woooooool02_ooo`030000oooooooo01goool00`000?oo
ooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo02Goool008[oool00ol0VOooooooo`0Z
oooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`1Voooo002:
oooo00?o09Woooooool0:_ooo`80001Woooo002:oooo00?o09Woooooool0:_ooo`030000oooooooo
06Koool008[oool00ol0VOooooooo`0Zoooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo
02[oool00`000?ooooooo`1Voooo002:oooo00?o09Woooooool0:_ooo`80001Woooo002:oooo00?o
09Woooooool0:_ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Zoooo00<0003ooooo
ool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`1Voooo002:oooo00?o09Wooooo
ool0:_ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Zoooo0P0006Ooool008[oool0
0ol0VOooooooo`0Zoooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool00`000?oo
ooooo`1Voooo002:oooo00?o09Woooooool0:_ooo`030000oooooooo06Koool008[oool00ol0VOoo
ooooo`0Zoooo0P0006Ooool008[oool00ol0VOooooooo`0Zoooo00<0003oooooool0I_ooo`00R_oo
o`03o`2Ioooooooo02[oool00`000?ooooooo`1Voooo002:oooo00?o09Woooooool08_ooo`D00003
oooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02Coool00`000?ooooooo`03oooo00<0
003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02Coool00`000?ooooooo`03oooo0`0006Koool0
08[oool00ol0VOooooooo`0Toooo00<0003oooooool00oooo`030000oooooooo06Koool008[oool0
0ol0VOooooooo`0Toooo00<0003oooooool00oooo`030000oooooooo06Koool008[oool00ol0VOoo
ooooo`0Soooo0P0000Goool00`000?ooooooo`1Voooo002:oooo00?o09Woooooool0:_ooo`80001W
oooo002:oooo00?o09Woooooool0:_ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Z
oooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`1Voooo002:
oooo00?o09Woooooool0:_ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Zoooo0P00
06Ooool008[oool00ol0VOooooooo`0Zoooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo
02[oool00`000?ooooooo`1Voooo002:oooo00?o09Woooooool0:_ooo`030000oooooooo06Koool0
08[oool00ol0VOooooooo`0Zoooo0P0006Ooool008[oool00ol0VOooooooo`0Zoooo00<0003ooooo
ool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`1Voooo002:oooo00?o09Wooooo
ool0:_ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Zoooo00<0003oooooool0I_oo
o`00R_ooo`03o`2Ioooooooo02[oool20000Ioooo`00R_ooo`03o`2Ioooooooo02[oool00`000?oo
ooooo`1Voooo002:oooo00?o09Woooooool08_ooo`@00004oooo00<0003oooooool0I_ooo`00R_oo
o`03o`2Ioooooooo02;oool00`000?ooooooo`05oooo00<0003oooooool0I_ooo`00R_ooo`03o`2I
oooooooo02?oool00`000?ooooooo`04oooo0`0006Koool008[oool00ol0VOooooooo`0Toooo00<0
003oooooool00oooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Roooo00@0003ooooo
ool00004oooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02?oool200001Oooo`030000
oooooooo06Koool008[oool00ol0VOooooooo`0Zoooo0P0006Ooool008[oool00ol0VOooooooo`0Z
oooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`1Voooo002:
oooo00?o09Woooooool0:_ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Zoooo00<0
003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool20000Ioooo`00R_ooo`03o`2Ioooooooo
02[oool00`000?ooooooo`1Voooo002:oooo00?o09Woooooool0:_ooo`030000oooooooo06Koool0
08[oool00ol0VOooooooo`0Zoooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool2
0000Ioooo`00R_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`1Voooo002:oooo00?o09Wooooo
ool0:_ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Zoooo00<0003oooooool0I_oo
o`00R_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`1Voooo002:oooo00?o09Woooooool0:_oo
o`80001Woooo002:oooo00?o09Woooooool0:_ooo`030000oooooooo06Koool008[oool00ol0VOoo
ooooo`0Soooo0P0000Goool00`000?ooooooo`1Voooo002:oooo00?o09Woooooool08_ooo`040000
oooooooo00001?ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Toooo00<0003ooooo
ool00oooo`<0001Voooo002:oooo00?o09Woooooool09Oooo`030000oooooooo00;oool00`000?oo
ooooo`1Voooo002:oooo00?o09Woooooool08_ooo`040000oooooooo00001?ooo`030000oooooooo
06Koool008[oool00ol0VOooooooo`0Soooo0P0000Goool00`000?ooooooo`1Voooo002:oooo00?o
09Woooooool0:_ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Zoooo0P0006Ooool0
08[oool00ol0VOooooooo`0Zoooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool0
0`000?ooooooo`1Voooo002:oooo00?o09Woooooool0:_ooo`030000oooooooo06Koool008[oool0
0ol0VOooooooo`0Zoooo0P0006Ooool008[oool00ol0VOooooooo`0Zoooo00<0003oooooool0I_oo
o`00R_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`1Voooo002:oooo00?o09Woooooool0:_oo
o`030000oooooooo06Koool008[oool00ol0VOooooooo`0Zoooo00<0003oooooool0I_ooo`00R_oo
o`03o`2Ioooooooo02[oool20000Ioooo`00R_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`1V
oooo002:oooo00?o09Woooooool0:_ooo`030000oooooooo06Koool008[oool00ol0VOooooooo`0Z
oooo00<0003oooooool0I_ooo`00R_ooo`03o`2Ioooooooo02[oool20000Ioooo`00R_ooo`03o`2I
oooooooo02[oool00`000?ooooooo`1Voooo002:oooo00?o09Woooooool0:_ooo`030000oooooooo
06Koool008[oool00ol0VOooooooo`0Toooo0`0000?oool00`000?ooooooo`1Voooo002:oooo00?o
09Woooooool09Oooo`030000oooooooo00;oool00`000?ooooooo`1Voooo002:oooo00?o09Wooooo
ool08_ooo`D00003oooo0`0006Koool00:ooool010000?ooooooo`0006goool00;3oool00`000?oo
o`00001]oooo002aoooo0P0006goool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Ooo
o`800004oooo0P0000Goool300000_ooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo
00002oooo`050000oooooooooooo000007[oool007Ooool00`000?ooooooo`02oooo00<0003ooooo
ool04oooo`040000oooooooo00002?ooo`D00003oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000Boooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?oo
o`000003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002oooo`800002
oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.04262 .26479 L
.06244 .26475 L
.08255 .26471 L
.10458 .26464 L
.12415 .26456 L
.14509 .26444 L
.16639 .26427 L
.18653 .26404 L
.20651 .26374 L
.22495 .26335 L
.24367 .26284 L
.2643 .26206 L
.28371 .26107 L
.30459 .25961 L
.32572 .25758 L
.34581 .25494 L
.36562 .25144 L
.384 .24716 L
.40453 .24088 L
.42313 .23346 L
.44238 .22371 L
.4632 .2104 L
.5042 .1752 L
.54369 .13377 L
.56355 .11412 L
.58166 .09974 L
.58646 .09676 L
.59168 .09398 L
.59619 .092 L
.60117 .09029 L
.60389 .08957 L
.60644 .08904 L
.60775 .08882 L
.60913 .08863 L
.60986 .08855 L
.61065 .08847 L
.61136 .08841 L
.61204 .08837 L
.61335 .08831 L
.61455 .08829 L
.61584 .0883 L
.61657 .08833 L
.61724 .08836 L
.61836 .08844 L
.6196 .08855 L
.62088 .08871 L
.62209 .08888 L
.62467 .08937 L
.62707 .08995 L
Mistroke
.63249 .09171 L
.63728 .09375 L
.64237 .09641 L
.66091 .10974 L
.70255 .15165 L
.74266 .19156 L
.78127 .22031 L
.80124 .23112 L
.82232 .23995 L
.842 .24623 L
.86035 .25072 L
.88074 .25449 L
.89931 .25706 L
.91843 .25906 L
.9392 .26066 L
.95715 .26169 L
.97619 .26251 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.44268 .26487 L
.46172 .26487 L
.47994 .26487 L
.48519 .26487 L
.48778 .26487 L
.49018 .26487 L
.49235 .26487 L
.49356 .26487 L
s
.49356 .26487 m
.494 .61803 L
s
0 .4 1 r
.02381 .26445 m
.06244 .2643 L
.10458 .26408 L
.14415 .26379 L
.18221 .26341 L
.22272 .26287 L
.26171 .26215 L
.30316 .26111 L
.34309 .25976 L
.3815 .25803 L
.42237 .25564 L
.44268 .25422 L
.46172 .25276 L
.47994 .25127 L
.48519 .25082 L
.48778 .2506 L
.49018 .25039 L
.49235 .25021 L
.49356 .2501 L
.49466 .26487 L
.49587 .26487 L
.49718 .26487 L
.49955 .26487 L
.54055 .26487 L
.58004 .26487 L
.61801 .26487 L
.65844 .26487 L
.69735 .26487 L
.73871 .26487 L
.77855 .26487 L
.81688 .26487 L
.85766 .26487 L
.89693 .26487 L
.93468 .26487 L
.97489 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .27112 L
s
[(2)] .9127 .25237 0 1 Mshowa
.125 Mabswid
.04921 .26487 m
.04921 .26862 L
s
.0746 .26487 m
.0746 .26862 L
s
.1 .26487 m
.1 .26862 L
s
.1254 .26487 m
.1254 .26862 L
s
.17619 .26487 m
.17619 .26862 L
s
.20159 .26487 m
.20159 .26862 L
s
.22698 .26487 m
.22698 .26862 L
s
.25238 .26487 m
.25238 .26862 L
s
.30317 .26487 m
.30317 .26862 L
s
.32857 .26487 m
.32857 .26862 L
s
.35397 .26487 m
.35397 .26862 L
s
.37937 .26487 m
.37937 .26862 L
s
.43016 .26487 m
.43016 .26862 L
s
.45556 .26487 m
.45556 .26862 L
s
.48095 .26487 m
.48095 .26862 L
s
.50635 .26487 m
.50635 .26862 L
s
.55714 .26487 m
.55714 .26862 L
s
.58254 .26487 m
.58254 .26862 L
s
.60794 .26487 m
.60794 .26862 L
s
.63333 .26487 m
.63333 .26862 L
s
.68413 .26487 m
.68413 .26862 L
s
.70952 .26487 m
.70952 .26862 L
s
.73492 .26487 m
.73492 .26862 L
s
.76032 .26487 m
.76032 .26862 L
s
.81111 .26487 m
.81111 .26862 L
s
.83651 .26487 m
.83651 .26862 L
s
.8619 .26487 m
.8619 .26862 L
s
.8873 .26487 m
.8873 .26862 L
s
.9381 .26487 m
.9381 .26862 L
s
.96349 .26487 m
.96349 .26862 L
s
.98889 .26487 m
.98889 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.65873 0 m
.66498 0 L
s
[(-3)] .64623 0 1 0 Mshowa
.65873 .08829 m
.66498 .08829 L
s
[(-2)] .64623 .08829 1 0 Mshowa
.65873 .17658 m
.66498 .17658 L
s
[(-1)] .64623 .17658 1 0 Mshowa
.65873 .35316 m
.66498 .35316 L
s
[(1)] .64623 .35316 1 0 Mshowa
.65873 .44145 m
.66498 .44145 L
s
[(2)] .64623 .44145 1 0 Mshowa
.65873 .52974 m
.66498 .52974 L
s
[(3)] .64623 .52974 1 0 Mshowa
.65873 .61803 m
.66498 .61803 L
s
[(4)] .64623 .61803 1 0 Mshowa
.125 Mabswid
.65873 .01766 m
.66248 .01766 L
s
.65873 .03532 m
.66248 .03532 L
s
.65873 .05297 m
.66248 .05297 L
s
.65873 .07063 m
.66248 .07063 L
s
.65873 .10595 m
.66248 .10595 L
s
.65873 .12361 m
.66248 .12361 L
s
.65873 .14126 m
.66248 .14126 L
s
.65873 .15892 m
.66248 .15892 L
s
.65873 .19424 m
.66248 .19424 L
s
.65873 .2119 m
.66248 .2119 L
s
.65873 .22956 m
.66248 .22956 L
s
.65873 .24721 m
.66248 .24721 L
s
.65873 .28253 m
.66248 .28253 L
s
.65873 .30019 m
.66248 .30019 L
s
.65873 .31785 m
.66248 .31785 L
s
.65873 .3355 m
.66248 .3355 L
s
.65873 .37082 m
.66248 .37082 L
s
.65873 .38848 m
.66248 .38848 L
s
.65873 .40614 m
.66248 .40614 L
s
.65873 .42379 m
.66248 .42379 L
s
.65873 .45911 m
.66248 .45911 L
s
.65873 .47677 m
.66248 .47677 L
s
.65873 .49443 m
.66248 .49443 L
s
.65873 .51209 m
.66248 .51209 L
s
.65873 .5474 m
.66248 .5474 L
s
.65873 .56506 m
.66248 .56506 L
s
.65873 .58272 m
.66248 .58272 L
s
.65873 .60038 m
.66248 .60038 L
s
.25 Mabswid
.65873 0 m
.65873 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002`oooo0P0006koool00:ooool010000?ooooooo`0006goool00;7oool00`000?oo
ooooo`03oooo0`0006Koool00:Woool400001Oooo`030000oooooooo00;oool00`000?ooooooo`1V
oooo002_oooo00@0003oooooool00004oooo00<0003oooooool0I_ooo`00/?ooo`800005oooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool20000Ioooo`00]oooo`030000
oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002goooo00<0003oooooool0I_ooo`00]ooo
o`80001Woooo002goooo00<0003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool0
0`000?ooooooo`1Voooo002goooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002goooo00<0
003oooooool0I_ooo`00]oooo`030000oooooooo06Koool00;Ooool00`000?ooooooo`1Voooo002g
oooo0P0006Ooool00;Ooool00`000?ooooooo`1Voooo002_oooo100000Coool00`000?ooooooo`1V
oooo002_oooo00<0003oooooool01Oooo`030000oooooooo06Koool00:_oool300000_ooo`030000
oooooooo00Coool30000I_ooo`00Yoooo`/00005oooo00<0003oooooool0I_ooo`00Y_ooo`030000
<ol0<ol000Hco`00100003?o03?o000000Coool00`000?ooooooo`1Voooo002Toooo0P0000Xco`02
000000<co`00003oool00_ooo`030000oooooooo06Koool00:?oool00`0003?o03?o000><ol00P00
0003oooo0000oooo06Ooool00:7oool200004c?o00<0001Woooo002Poooo00<0000co`0co`0053?o
0080001Woooo002Ooooo00<0000co`0co`005C?o00030000<ol0000006Koool009koool00`0003?o
03?o000F<ol000@0000co`0co`00001Uoooo002Moooo00<0000co`0co`005c?o00800002<ol000<0
003oooooool0H_ooo`00W?ooo`030000<ol0<ol001Pco`000`0003?o03?o0002<ol000<0003ooooo
ool0HOooo`00Voooo`030000<ol0<ol001Tco`000`0003?o03?o0003<ol000<0003oooooool0H?oo
o`00V_ooo`030000<ol0<ol001Xco`000`0003?o03?o0003<ol000<0003oooooool0H?ooo`00VOoo
o`030000<ol0<ol001/co`000`0003?o03?o0004<ol000<0003oooooool0Goooo`00V?ooo`030000
<ol0<ol001`co`0200001S?o00030000oooooooo05koool009Ooool00`0003?o03?o000M<ol000<0
000co`0co`001S?o00030000oooooooo05goool009Koool00`0003?o03?o000N<ol000<0000co`0c
o`001c?o00030000oooooooo05coool009Goool00`0003?o03?o000O<ol000<0000co`0co`0023?o
00030000oooooooo05_oool009Coool00`0003?o03?o000P<ol00P0000Xco`000`000?ooooooo`1J
oooo002Coooo00<0000co`0co`008C?o00030000<ol0<ol000Xco`000`000?ooooooo`1Ioooo002B
oooo00<0000co`0co`008S?o00030000<ol0<ol000/co`000`000?ooooooo`1Hoooo002Aoooo00<0
000co`0co`006c?o00D00003<ol000<0000co`0co`0033?o00030000oooooooo05Ooool0093oool0
0`0003?o03?o000N<ol000<0000co`0co`000c?o00030000<ol0<ol000dco`000`000?ooooooo`1F
oooo002?oooo00<0000co`0co`007c?o00030000<ol0<ol000<co`0300003S?o00030000oooooooo
05Goool008koool00`0003?o03?o000H<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`003c?o00030000oooooooo05Coool008goool00`0003?o03?o000Q<ol000<0000co`0co`000c?o
00030000<ol0<ol0010co`000`000?ooooooo`1Coooo002<oooo00<0000co`0co`008C?o00800005
<ol000<0000co`0co`004C?o00030000oooooooo05;oool008[oool20000:c?o0080000C<ol000<0
003oooooool0DOooo`00ROooo`030000<ol0<ol002/co`000`0003?o03?o000C<ol00P00057oool0
08Soool00`0003?o03?o000/<ol000<0000co`0co`005C?o00030000oooooooo04koool008Ooool0
0`0003?o03?o000]<ol000<0000co`0co`005S?o00030000oooooooo04goool008Koool00`0003?o
03?o000^<ol000<0000co`0co`005c?o0080001=oooo0024oooo0P00034co`0200006S?o00030000
oooooooo04[oool008?oool00`0003?o03?o000a<ol000<0000co`0co`006S?o0080001:oooo000H
oooo0P0001ooool300007Oooo`80000Moooo100000Goool200005C?o00D0000J<ol000<0000co`0c
o`006c?o00D0000Loooo100002Koool001Ooool010000?ooooooo`0001ooool00`000?ooooooo`0K
oooo00@0003oooooool0000Loooo00<0003oooooool01?ooo`80000I<ol000<0000co`0co`006S?o
00030000<ol0<ol001dco`0200007Oooo`030000oooooooo02Ooool001[oool00`000?ooooooo`0J
oooo1@0001koool00`000?ooooooo`0Loooo00@0003oooooooooool200006c?o00030000<ol0<ol0
01Xco`0200007S?o00040000<ol0000000007?ooo`030000oooooooo02Koool0017oool400000ooo
o`80000Goooo100000;oool010000?ooooooo`0001Ooool400001Oooo`030000oooooooo01Coool4
00001?ooo`<0000E<ol0100000@co`000`0003?o03?o000J<ol000<0000co`0co`007C?o00040000
<ol0<ol0<ol00P0001_oool00`000?ooooooo`0Uoooo000Hoooo00<0003oooooool07Oooo`030000
oooo000001goool010000?ooooooo`0001coool400007S?o00030000<ol0<ol001Xco`000`0003?o
03?o000M<ol000<0000co`0co`000c?o00<0000Foooo00@0003oooooool0000Voooo000Hoooo0`00
01koool200007_ooo`80000Koooo1@0001hco`02000073?o00030000<ol0<ol001`co`02000023?o
00@0000Coooo0P0002Ooool007Coool20000@C?o00030000<ol0<ol002Xco`030000>Oooo`00L?oo
o`@0000I<ol000<0I_lco`0co`009c?o0080000^<ol00P0003Ooool006_oool500004c?o00/0I_lY
<ol000<0000co`0co`00;c?o00@0000coooo001Qoooo2P00008co`0F06Ko2S?o000306Ko<ol0<ol0
02Lco`000`0003?o03?o000c<ol02P0002Woool005Koool30000501Vob4co`000`1Voc?o03?o000V
<ol000<0000co`0co`00?C?o00l0000Joooo000@ooooo`00017oool001Koool00`000?ooooooo`04
oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo00<0003oooooool01?ooo`030000oooooooo00?oool010000?ooooooool0V@?oool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0
003oooooool04_ooo`005_ooo`030000oooooooo01goool00`000?ooooooo`0Noooo00<0003ooooo
ool07Oooo`030000oooooooo01?oool00ol0VOooooooo`07oooo00<0003oooooool07Oooo`030000
oooooooo01goool00`000?ooooooo`0Noooo00<0003oooooool09Oooo`00SOooo`03o`2Ioooooooo
02Ooool00`000?ooooooo`1Voooo002=oooo00?o09Woooooool09oooo`030000oooooooo06Koool0
08goool00ol0VOooooooo`0Woooo0P0006Ooool008goool00ol0VOooooooo`0Woooo00<0003ooooo
ool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1Voooo002=oooo00?o09Wooooo
ool09oooo`030000oooooooo06Koool008goool00ol0VOooooooo`0Woooo0P0006Ooool008goool0
0ol0VOooooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool00`000?oo
ooooo`1Voooo002=oooo00?o09Woooooool09oooo`030000oooooooo06Koool008goool00ol0VOoo
ooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool20000Ioooo`00SOoo
o`03o`2Ioooooooo02Ooool00`000?ooooooo`1Voooo002=oooo00?o09Woooooool09oooo`030000
oooooooo06Koool008goool00ol0VOooooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2I
oooooooo02Ooool20000Ioooo`00SOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1Voooo002=
oooo00?o09Woooooool09oooo`030000oooooooo06Koool008goool00ol0VOooooooo`0Ooooo1@00
00?oool00`000?ooooooo`1Voooo002=oooo00?o09Woooooool08Oooo`030000oooooooo00?oool0
0`000?ooooooo`1Voooo002=oooo00?o09Woooooool08Oooo`030000oooooooo00?oool30000I_oo
o`00SOooo`03o`2Ioooooooo027oool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00SOoo
o`03o`2Ioooooooo027oool00`000?ooooooo`03oooo00<0003oooooool0I_ooo`00SOooo`03o`2I
oooooooo023oool200001Oooo`030000oooooooo06Koool008goool00ol0VOooooooo`0Woooo0P00
06Ooool008goool00ol0VOooooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo
02Ooool00`000?ooooooo`1Voooo002=oooo00?o09Woooooool09oooo`030000oooooooo06Koool0
08goool00ol0VOooooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool2
0000Ioooo`00SOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1Voooo002=oooo00?o09Wooooo
ool09oooo`030000oooooooo06Koool008goool00ol0VOooooooo`0Woooo00<0003oooooool0I_oo
o`00SOooo`03o`2Ioooooooo02Ooool20000Ioooo`00SOooo`03o`2Ioooooooo02Ooool00`000?oo
ooooo`1Voooo002=oooo00?o09Woooooool09oooo`030000oooooooo06Koool008goool00ol0VOoo
ooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1V
oooo002=oooo00?o09Woooooool09oooo`80001Woooo002=oooo00?o09Woooooool09oooo`030000
oooooooo06Koool008goool00ol0VOooooooo`0Ooooo100000Coool00`000?ooooooo`1Voooo002=
oooo00?o09Woooooool07oooo`030000oooooooo00Goool00`000?ooooooo`1Voooo002=oooo00?o
09Woooooool08?ooo`030000oooooooo00Coool30000I_ooo`00SOooo`03o`2Ioooooooo027oool0
0`000?ooooooo`03oooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo01ooool010000?oo
ooooo`0000Coool00`000?ooooooo`1Voooo002=oooo00?o09Woooooool08?ooo`800005oooo00<0
003oooooool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool20000Ioooo`00SOooo`03o`2Ioooooooo
02Ooool00`000?ooooooo`1Voooo002=oooo00?o09Woooooool09oooo`030000oooooooo06Koool0
08goool00ol0VOooooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool0
0`000?ooooooo`1Voooo002=oooo00?o09Woooooool09oooo`80001Woooo002=oooo00?o09Wooooo
ool09oooo`030000oooooooo06Koool008goool00ol0VOooooooo`0Woooo00<0003oooooool0I_oo
o`00SOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1Voooo002=oooo00?o09Woooooool09ooo
o`80001Woooo002=oooo00?o09Woooooool09oooo`030000oooooooo06Koool008goool00ol0VOoo
ooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1V
oooo002=oooo00?o09Woooooool09oooo`030000oooooooo06Koool008goool00ol0VOooooooo`0W
oooo0P0006Ooool008goool00ol0VOooooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2I
oooooooo023oool200001Oooo`030000oooooooo06Koool008goool00ol0VOooooooo`0Ooooo00@0
003oooooool00004oooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo027oool00`000?oo
ooooo`03oooo0`0006Koool008goool00ol0VOooooooo`0Roooo00<0003oooooool00_ooo`030000
oooooooo06Koool008goool00ol0VOooooooo`0Ooooo00@0003oooooool00004oooo00<0003ooooo
ool0I_ooo`00SOooo`03o`2Ioooooooo023oool200001Oooo`030000oooooooo06Koool008goool0
0ol0VOooooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool20000Iooo
o`00SOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1Voooo002=oooo00?o09Woooooool09ooo
o`030000oooooooo06Koool008goool00ol0VOooooooo`0Woooo00<0003oooooool0I_ooo`00SOoo
o`03o`2Ioooooooo02Ooool20000Ioooo`00SOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1V
oooo002=oooo00?o09Woooooool09oooo`030000oooooooo06Koool008goool00ol0VOooooooo`0W
oooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1Voooo002=
oooo00?o09Woooooool09oooo`80001Woooo002=oooo00?o09Woooooool09oooo`030000oooooooo
06Koool008goool00ol0VOooooooo`0Woooo00<0003oooooool0I_ooo`00SOooo`03o`2Ioooooooo
02Ooool00`000?ooooooo`1Voooo002=oooo00?o09Woooooool09oooo`80001Woooo002=oooo00?o
09Woooooool09oooo`030000oooooooo06Koool008goool00ol0VOooooooo`0Woooo00<0003ooooo
ool0I_ooo`00SOooo`03o`2Ioooooooo027oool300000oooo`030000oooooooo06Koool008goool0
0ol0VOooooooo`0Roooo00<0003oooooool00_ooo`030000oooooooo06Koool008goool00ol0VOoo
ooooo`0Ooooo1@0000?oool30000I_ooo`00[oooo`040000oooooooo0000KOooo`00/?ooo`030000
oooo000006goool00;7oool20000KOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003ooooo
ool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07ooo
o`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=
oooo0P0000Coool200001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool00oooo`030000
oooooooo07Ooool007Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002oooo`050000
oooooooooooo000007[oool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool2
00002_ooo`800003oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-5.70592, \
-3.20105, 0.0310585, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-5.70592, -3.20105, 0.0310585, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.126984 0.264872 0.0882906 [
[.02381 .25237 -6 -9 ]
[.02381 .25237 6 0 ]
[.15079 .25237 -6 -9 ]
[.15079 .25237 6 0 ]
[.27778 .25237 -6 -9 ]
[.27778 .25237 6 0 ]
[.40476 .25237 -6 -9 ]
[.40476 .25237 6 0 ]
[.53175 .25237 -6 -9 ]
[.53175 .25237 6 0 ]
[.78571 .25237 -3 -9 ]
[.78571 .25237 3 0 ]
[.9127 .25237 -3 -9 ]
[.9127 .25237 3 0 ]
[.64623 0 -12 -4.5 ]
[.64623 0 0 4.5 ]
[.64623 .08829 -12 -4.5 ]
[.64623 .08829 0 4.5 ]
[.64623 .17658 -12 -4.5 ]
[.64623 .17658 0 4.5 ]
[.64623 .35316 -6 -4.5 ]
[.64623 .35316 0 4.5 ]
[.64623 .44145 -6 -4.5 ]
[.64623 .44145 0 4.5 ]
[.64623 .52974 -6 -4.5 ]
[.64623 .52974 0 4.5 ]
[.64623 .61803 -6 -4.5 ]
[.64623 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .26487 m
.02381 .27112 L
s
[(-5)] .02381 .25237 0 1 Mshowa
.15079 .26487 m
.15079 .27112 L
s
[(-4)] .15079 .25237 0 1 Mshowa
.27778 .26487 m
.27778 .27112 L
s
[(-3)] .27778 .25237 0 1 Mshowa
.40476 .26487 m
.40476 .27112 L
s
[(-2)] .40476 .25237 0 1 Mshowa
.53175 .26487 m
.53175 .27112 L
s
[(-1)] .53175 .25237 0 1 Mshowa
.78571 .26487 m
.78571 .27112 L
s
[(1)] .78571 .25237 0 1 Mshowa
.9127 .26487 m
.9127 .2711