(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2469112,     102613]*)
(*NotebookOutlinePosition[   2469855,     102638]*)
(*  CellTagsIndexPosition[   2469811,     102634]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING WITHIN NONHOMOGENEITY", "Text",
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  ",
    FontSize->12],
  StyleBox["is located on the negative ",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["x",
    FontSize->12,
    FontSlant->"Italic",
    CharacterEncoding->"WindowsANSI"],
  StyleBox["-axis.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  \n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" <0, is within the nonhomogeneity and needs to be specified. \n\n\
The potential   v[x], which is ",
    FontSize->12],
  StyleBox["the nonhomogeneity, is strictly positive.  \n\nThe transmission \
coefficient, left reflection coefficient, and right reflection coefficient, \
respectively, are denoted by  T[k],  L[k],  R[k].\n\nThe tail of the wave is \
denoted by  g[x,t].\n\nThe focusing moment is chosen as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(Clear[v, T, L, R, x0, g]; 
    v[x_] = UnitStep[\(-x\)]\ 16 \((Sqrt[2] + 
              1)\)^2\ E^\((\(-2\)\ Sqrt[
                  2]\ x)\)/\((\((1 + 
                        Sqrt[2])\)^2\ \ E^\((\(-2\)\ Sqrt[2]\ x)\) - 
                1)\)^2;\ \), "\[IndentingNewLine]", 
    \(\(T[k_] = k \((k + I\ Sqrt[2])\)/\((k + I)\)^2;\)\), "\n", 
    \(\(L[
          k_] = \(-2\) \((k + 
                I\ Sqrt[2])\)/\((\((k + I)\)^2\ \((k - 
                    I\ Sqrt[2])\))\);\)\), "\n", 
    \(\(R[k_] = 1/\((k + I)\)^2;\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the focusing location  x0, a nonnegative number, \
next:\
\>", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(x0 = \(-1\);\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(q[x_] = 
        2\ Sqrt[2]/\((\((1 + Sqrt[2])\)^2\ \ E^\((\(-2\)\ Sqrt[2]\ x)\) - 
                1)\);\)\), "\[IndentingNewLine]", 
    \(\(q0 = q[x0];\)\), "\[IndentingNewLine]", 
    \(\(q27[x_, t_] = 
        q0 - 2 + 
          Sqrt[2] + \((q0 - 1 + Sqrt[2])\) \((x - x0 - 
                t)\);\)\), "\[IndentingNewLine]", 
    \(\(q28[x_, t_] = 
        q[x]\ \((1 + 
              q0/\((2\ Sqrt[2])\))\)\ \ E^\((\(-Sqrt[2]\) \((x - x0 - 
                    t)\))\);\)\), "\[IndentingNewLine]", 
    \(\(q29[x_, t_] = 
        q0\ \((1 + 
              q[x]/\((2\ Sqrt[2])\))\)\ E^\((Sqrt[
                  2] \((x - x0 - t)\))\);\)\), "\[IndentingNewLine]", 
    \(\(q30[x_, 
          t_] = \(-2\)\ \ Sqrt[
            2]\ \((Sqrt[2] - 1)\)^2 \((1 + q[x]/\((2\ Sqrt[2])\))\) \((1 + 
              q0/\((2\ Sqrt[2])\))\) 
          E^\((\ Sqrt[2] \((x + x0 + t)\))\);\)\), "\[IndentingNewLine]", 
    \(\(q31[x_, 
          t_] = \(-q[
              x]\)\ q0\ \((\((Sqrt[2] + 1)\)^2\ /\((2\ Sqrt[
                    2])\))\)\ E^\((\(-Sqrt[2]\) \((x + x0 + 
                    t)\))\);\)\), "\[IndentingNewLine]", 
    \(\(q32[x_, 
          t_] = \((2\ q[x]\ q0 - \((Sqrt[2] - 1)\)^2 \((q[x] + q0)\) - 
              2\ Sqrt[2] \((Sqrt[2] - 1)\)^2)\)\ \ E^\((\ \(-\((x + x0 + 
                    t)\)\))\);\)\), "\[IndentingNewLine]", 
    \(\(q33[x_, 
          t_] = \(-\((x + x0 + t)\)\) \((Sqrt[2] - 1 + q[x])\) \((Sqrt[2] - 
              1 + q0)\)\ E^\((\(-\((x + x0 + 
                    t)\)\))\);\)\[IndentingNewLine]\n\), \
"\[IndentingNewLine]", 
    \(\(g[x_, t_] = \ 
        UnitStep[x]\ \ q27[x, 
              t]\ \ E^\((x - x0 - t)\)\ \ UnitStep[\(-x\) + x0 + t]\  + 
          UnitStep[\(-x\)] \((q28[x, t]\ \n\t\tUnitStep[x - x0 - t]\  + \ 
                q29[x, t]\ UnitStep[\(-x\) + x0 + t]\  + 
                q30[x, t]\ UnitStep[\(-x\) - x0 - t]\n + \((q31[x, t]\  + 
                      q32[x, t] + q33[x, t])\)\ UnitStep[
                    x + x0 + t]\ )\);\)\)}], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-7\), \ 
              5}, \ PlotRange -> {\(-0.6\), 0.05}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-7\), \ 5}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-0.6\), 
                0.05}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-7\), \ 5}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-0.6\), 
                0.05}]}, \[IndentingNewLine]\ {t, \ \(-5\), \ 5.8,  .5}, 
        PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.04262 .57049 L
.06244 .57049 L
.08255 .57049 L
.08806 .57049 L
.09396 .57049 L
.09682 .57049 L
.09952 .57049 L
.1007 .57049 L
.10195 .57049 L
.1026 .57049 L
s
.1026 .57049 m
.1026 .61803 L
s
0 .4 1 r
.02381 .57719 m
.04262 .57986 L
.06244 .58383 L
.07286 .58654 L
.08255 .58957 L
.0932 .59356 L
.09626 .59485 L
.09916 .59614 L
.10042 .59672 L
.10176 .59736 L
.10246 .59769 L
.10322 .57049 L
.10392 .57049 L
.10458 .57049 L
.10583 .57049 L
.10652 .57049 L
.10715 .57049 L
.10838 .57049 L
.10954 .57049 L
.1102 .57049 L
.1109 .57049 L
.11214 .57049 L
.11284 .57049 L
.11349 .57049 L
.1142 .57049 L
.11496 .57049 L
.11623 .57049 L
.11695 .57049 L
.11761 .57049 L
.11883 .57049 L
.12012 .57049 L
.12127 .57049 L
.12236 .57049 L
.12355 .57049 L
.12483 .57049 L
.12599 .57049 L
.12708 .57049 L
.12826 .57049 L
.12953 .57049 L
.13018 .57049 L
.13087 .57049 L
.13213 .57049 L
.13336 .57049 L
.13449 .57049 L
.13555 .57049 L
.13654 .57049 L
.13763 .57049 L
.13879 .57049 L
.14002 .57049 L
.14118 .57049 L
Mistroke
.14222 .57049 L
.14335 .57049 L
.144 .57049 L
.14469 .57049 L
.14591 .57049 L
.14723 .57049 L
.14798 .57049 L
.14868 .57049 L
.14995 .57049 L
.1511 .57049 L
.15174 .57049 L
.15244 .57049 L
.1537 .57049 L
.15482 .57049 L
.15606 .57049 L
.15735 .57049 L
.15856 .57049 L
.1597 .57049 L
.16073 .57049 L
.16187 .57049 L
.16306 .57049 L
.16438 .57049 L
.16558 .57049 L
.16624 .57049 L
.16696 .57049 L
.16826 .57049 L
.16948 .57049 L
.17078 .57049 L
.17188 .57049 L
.17309 .57049 L
.17383 .57049 L
.17452 .57049 L
.17583 .57049 L
.17655 .57049 L
.17723 .57049 L
.17797 .57049 L
.17876 .57049 L
.18005 .57049 L
.18127 .57049 L
.18197 .57049 L
.18261 .57049 L
.18331 .57049 L
.18405 .57049 L
.18528 .57049 L
.18593 .57049 L
.18662 .57049 L
.18788 .57049 L
.18904 .57049 L
.19016 .57049 L
.1912 .57049 L
Mistroke
.19235 .57049 L
.19358 .57049 L
.19488 .57049 L
.19562 .57049 L
.19631 .57049 L
.19756 .57049 L
.19826 .57049 L
.1989 .57049 L
.2001 .57049 L
.20141 .57049 L
.20264 .57049 L
.20377 .57049 L
.20483 .57049 L
.20597 .57049 L
.20704 .57049 L
.20802 .57049 L
.20917 .57049 L
.21042 .57049 L
.2116 .57049 L
.2127 .57049 L
.21382 .57049 L
.21487 .57049 L
.21603 .57049 L
.21727 .57049 L
.2185 .57049 L
.2198 .57049 L
.22091 .57049 L
.22213 .57049 L
.22345 .57049 L
.22467 .57049 L
.2253 .57049 L
.226 .57049 L
.22673 .57049 L
.22742 .57049 L
.22868 .57049 L
.22982 .57049 L
.23046 .57049 L
.23115 .57049 L
.23241 .57049 L
.23364 .57049 L
.23476 .57049 L
.23605 .57049 L
.23726 .57049 L
.23838 .57049 L
.23942 .57049 L
.24055 .57049 L
.24175 .57049 L
.24306 .57049 L
.24425 .57049 L
.24491 .57049 L
Mistroke
.24563 .57049 L
.24693 .57049 L
.24814 .57049 L
.24943 .57049 L
.25054 .57049 L
.25175 .57049 L
.25248 .57049 L
.25317 .57049 L
.25447 .57049 L
.2552 .57049 L
.25588 .57049 L
.25662 .57049 L
.25741 .57049 L
.25809 .57049 L
.25884 .57049 L
.25954 .57049 L
.26019 .57049 L
.26141 .57049 L
.26271 .57049 L
.26392 .57049 L
.26461 .57049 L
.26525 .57049 L
.26642 .57049 L
.26766 .57049 L
.26877 .57049 L
.26981 .57049 L
.27095 .57049 L
.27218 .57049 L
.27341 .57049 L
.27411 .57049 L
.27476 .57049 L
.27607 .57049 L
.27681 .57049 L
.27748 .57049 L
.27867 .57049 L
.27997 .57049 L
.2812 .57049 L
.28233 .57049 L
.28339 .57049 L
.28452 .57049 L
.2856 .57049 L
.28657 .57049 L
.28772 .57049 L
.28897 .57049 L
.29014 .57049 L
.29124 .57049 L
.29247 .57049 L
.29363 .57049 L
.29468 .57049 L
.2958 .57049 L
Mistroke
.29704 .57049 L
.29834 .57049 L
.29945 .57049 L
.30067 .57049 L
.30197 .57049 L
.30318 .57049 L
.30381 .57049 L
.30451 .57049 L
.30524 .57049 L
.30592 .57049 L
.30717 .57049 L
.30831 .57049 L
.30957 .57049 L
.31089 .57049 L
.31201 .57049 L
.3132 .57049 L
.31432 .57049 L
.31534 .57049 L
.31654 .57049 L
.31784 .57049 L
.31907 .57049 L
.3202 .57049 L
.32141 .57049 L
.32271 .57049 L
.32393 .57049 L
.32505 .57049 L
.32636 .57049 L
.3271 .57049 L
.32778 .57049 L
.32904 .57049 L
.32967 .57049 L
.33037 .57049 L
.33105 .57049 L
.33176 .57049 L
.33304 .57049 L
.33375 .57049 L
.33441 .57049 L
.33514 .57049 L
.33592 .57049 L
.33659 .57049 L
.33732 .57049 L
.33801 .57049 L
.33865 .57049 L
.33985 .57049 L
.34113 .57049 L
.34234 .57049 L
.34365 .57049 L
.34489 .57049 L
.34605 .57049 L
.34719 .57049 L
Mistroke
.34822 .57049 L
.34942 .57049 L
.35054 .57049 L
.35178 .57049 L
.35308 .57049 L
.35419 .57049 L
.35541 .57049 L
.35672 .57049 L
.35746 .57049 L
.35813 .57049 L
.35943 .57049 L
.36067 .57049 L
.36172 .57049 L
.36288 .57049 L
.36409 .57049 L
.36522 .57049 L
.36628 .57049 L
.36725 .57049 L
.36832 .57049 L
.36944 .57049 L
.37058 .57049 L
.3718 .57049 L
.37295 .57049 L
.37399 .57049 L
.37522 .57049 L
.37591 .57049 L
.37655 .57049 L
.37773 .57049 L
.37897 .57049 L
.38018 .57049 L
.3815 .57049 L
.38275 .57049 L
.38391 .57049 L
.38505 .57049 L
.38609 .57049 L
.38729 .57049 L
.38841 .57049 L
.38965 .57049 L
.39095 .57049 L
.39207 .57049 L
.39329 .57049 L
.3946 .57049 L
.39534 .57049 L
.39601 .57049 L
.39732 .57049 L
.39855 .57049 L
.3997 .57049 L
.40077 .57049 L
.40188 .57049 L
.40312 .57049 L
Mistroke
.40418 .57049 L
.40515 .57049 L
.40627 .57049 L
.40733 .57049 L
.40848 .57049 L
.40969 .57049 L
.41085 .57049 L
.41189 .57049 L
.41312 .57049 L
.41381 .57049 L
.41445 .57049 L
.41561 .57049 L
.41687 .57049 L
.41813 .57049 L
.41932 .57049 L
.42048 .57049 L
.42156 .57049 L
.42272 .57049 L
.424 .57049 L
.42464 .57049 L
.42533 .57049 L
.42659 .57049 L
.42769 .57049 L
.4289 .57049 L
.43016 .57049 L
.43133 .57049 L
.43243 .57049 L
.43343 .57049 L
.43458 .57049 L
.43567 .57049 L
.43687 .57049 L
.43818 .57049 L
.43884 .57049 L
.43955 .57049 L
.44083 .57049 L
.4421 .57049 L
.44331 .57049 L
.4444 .57049 L
.44558 .57049 L
.44631 .57049 L
.447 .57049 L
.44828 .57049 L
.449 .57049 L
.44966 .57049 L
.45039 .57049 L
.45116 .57049 L
.45243 .57049 L
.45362 .57049 L
.45494 .57049 L
.4556 .57049 L
Mistroke
.45633 .57049 L
.45698 .57049 L
.45767 .57049 L
.45894 .57049 L
.46019 .57049 L
.46135 .57049 L
.46261 .57049 L
.46333 .57049 L
.464 .57049 L
.46471 .57049 L
.46535 .57049 L
.4661 .57049 L
.4668 .57049 L
.468 .57049 L
.46927 .57049 L
.47036 .57049 L
.47155 .57049 L
.47284 .57049 L
.47356 .57049 L
.47421 .57049 L
.47549 .57049 L
.4767 .57049 L
.47788 .57049 L
.47894 .57049 L
.48016 .57049 L
.48132 .57049 L
.48239 .57049 L
.48337 .57049 L
.48445 .57049 L
.48559 .57049 L
.48674 .57049 L
.48798 .57049 L
.48915 .57049 L
.49021 .57049 L
.49145 .57049 L
.49216 .57049 L
.49281 .57049 L
.494 .57049 L
.49527 .57049 L
.49647 .57049 L
.49779 .57049 L
.49903 .57049 L
.50018 .57049 L
.50132 .57049 L
.50236 .57049 L
.50355 .57049 L
.50468 .57049 L
.50591 .57049 L
.50721 .57049 L
.50832 .57049 L
Mistroke
.50954 .57049 L
.51085 .57049 L
.51159 .57049 L
.51226 .57049 L
.51356 .57049 L
.5148 .57049 L
.51585 .57049 L
.517 .57049 L
.51821 .57049 L
.51935 .57049 L
.52041 .57049 L
.52138 .57049 L
.52244 .57049 L
.52356 .57049 L
.5247 .57049 L
.52592 .57049 L
.52707 .57049 L
.52812 .57049 L
.52934 .57049 L
.53004 .57049 L
.53068 .57049 L
.53185 .57049 L
.5331 .57049 L
.53431 .57049 L
.53563 .57049 L
.53687 .57049 L
.53803 .57049 L
.53914 .57049 L
.54035 .57049 L
.54149 .57049 L
.54253 .57049 L
.54378 .57049 L
.54511 .57049 L
.54622 .57049 L
.54744 .57049 L
.54875 .57049 L
.54948 .57049 L
.55015 .57049 L
.55144 .57049 L
.55267 .57049 L
.55372 .57049 L
.55488 .57049 L
.55609 .57049 L
.55723 .57049 L
.55829 .57049 L
.55926 .57049 L
.56032 .57049 L
.56144 .57049 L
.5626 .57049 L
.56367 .57049 L
Mistroke
.56494 .57049 L
.56609 .57049 L
.5673 .57049 L
.56861 .57049 L
.56984 .57049 L
.57098 .57049 L
.57224 .57049 L
.57343 .57049 L
.5745 .57049 L
.57567 .57049 L
.57693 .57049 L
.57757 .57049 L
.57828 .57049 L
.57953 .57049 L
.5807 .57049 L
.58978 .57049 L
.61043 .57049 L
.64908 .57049 L
.69018 .57049 L
.72977 .57049 L
.76784 .57049 L
.80837 .57049 L
.84737 .57049 L
.88884 .57049 L
.92878 .57049 L
.96721 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00?o09T0003oool02?ooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oool0
0000300000Dco`000`0003?o03?o0008<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`00
0`0003?o03?o0008<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000
oooooooo01;oool001?oool306Ko4Oooo`03o`2I0000oooo02Ooool00`000?ooooooo`0Qoooo1P00
02Tco`000`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo02Ooool001Koool5
06Ko3?ooo`03o`2I06Kooooo053oool300009c?o00030000oooooooo07Woool001_oool606Ko1_oo
o`0306Kooooooooo05?oool200009C?o00030000oooooooo07Woool0027oool306Ko0oooo`0306Ko
oooooooo05Goool00`0003?o03?o000R<ol00P0007[oool002Coool206Ko00?oool0I_ooool0Eooo
o`030000<ol0<ol0024co`000`000?ooooooo`1ioooo000Voooo0P1VoeWoool200008C?o00030000
oooooooo07Woool002Ooool00ol0VOooooooo`1Ioooo00<0000co`0co`007S?o00030000oooooooo
07Woool002Ooool00ol0VOooooooo`1Ioooo00<0000co`0co`007S?o00030000oooooooo07Woool0
02Ooool00ol0VOooooooo`1Joooo00<0000co`0co`007C?o0080001joooo000Woooo00?o09Wooooo
ool0Foooo`030000<ol0<ol001`co`000`000?ooooooo`1ioooo000Woooo00?o09Woooooool0G?oo
o`030000<ol0<ol001/co`000`000?ooooooo`1ioooo000Woooo00?o09Woooooool0G?ooo`030000
<ol0<ol001/co`000`000?ooooooo`1ioooo0027oooo7C?o07coool008SooolL<ol0O?ooo`00R?oo
oa`co`1loooo0028oooo73?o07coool008WooolK<ol0O?ooo`00Ooooo`030000oooooooo00OooolE
<ol000<0000co`0co`000c?o07coool007koool00`000?ooooooo`08oooo00<0000co`0co`004c?o
00030000<ol0<ol0008co`1loooo001noooo00<0003oooooool00_ooo`800004oooo00<0000co`0c
o`003C?o00800004<ol000<0000co`0co`000S?o07coool007koool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000<ol0<ol000@co`0400000c?o00040000<ol0<ol000000c?o
00030000<ol0<ol0008co`1loooo001moooo00<0003oooooool00_ooo`030000oooooooo00Koool@
<ol000<0000co`0co`000S?o00040000<ol0<ol0<ol0O?ooo`00O_ooo`030000oooooooo00D00005
oooo3S?o00800004<ol000<0000co`0co`000S?o07coool007koool01@000?ooooooooooo`000009
oooo3C?o00030000<ol0<ol000<co`000`0003?o03?o0002<ol0O?ooo`00Ooooo`030000oooooooo
00[oool=<ol00`00008co`000`0003?o03?o0003<ol0O?ooo`00S?oooaPco`1loooo002<oooo63?o
07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.08255 .57049 L
.10458 .57049 L
.11448 .57049 L
.12507 .57049 L
.1302 .57049 L
.13506 .57049 L
.13942 .57049 L
.14061 .57049 L
.14188 .57049 L
s
.14188 .57049 m
.14189 .61803 L
s
0 .4 1 r
.02381 .5738 m
.04262 .57511 L
.06244 .57707 L
.07286 .57841 L
.08255 .5799 L
.09388 .582 L
.10458 .58442 L
.11437 .58708 L
.125 .59053 L
.12969 .59228 L
.13466 .5943 L
.1389 .59617 L
.14006 .59671 L
.14131 .5973 L
.14249 .59787 L
.14357 .57049 L
.14486 .57049 L
.14607 .57049 L
.14716 .57049 L
.14834 .57049 L
.14962 .57049 L
.15027 .57049 L
.15098 .57049 L
.15224 .57049 L
.15342 .57049 L
.1545 .57049 L
.15568 .57049 L
.1568 .57049 L
.15783 .57049 L
.15903 .57049 L
.1603 .57049 L
.16137 .57049 L
.16256 .57049 L
.16387 .57049 L
.16452 .57049 L
.16524 .57049 L
.16652 .57049 L
.1677 .57049 L
.16842 .57049 L
.16911 .57049 L
.17038 .57049 L
.1711 .57049 L
.17176 .57049 L
.17248 .57049 L
.17325 .57049 L
.17444 .57049 L
.17572 .57049 L
.17692 .57049 L
.17803 .57049 L
.17932 .57049 L
Mistroke
.18005 .57049 L
.18072 .57049 L
.18196 .57049 L
.18328 .57049 L
.18453 .57049 L
.18524 .57049 L
.1859 .57049 L
.18659 .57049 L
.18723 .57049 L
.18796 .57049 L
.18866 .57049 L
.18989 .57049 L
.19102 .57049 L
.19227 .57049 L
.1929 .57049 L
.19359 .57049 L
.1943 .57049 L
.19504 .57049 L
.19567 .57049 L
.19636 .57049 L
.19711 .57049 L
.19791 .57049 L
.19866 .57049 L
.19934 .57049 L
.20004 .57049 L
.20068 .57049 L
.20138 .57049 L
.20212 .57049 L
.20473 .57049 L
.20596 .57049 L
.20713 .57049 L
.20778 .57049 L
.20848 .57049 L
.20971 .57049 L
.21087 .57049 L
.21212 .57049 L
.21318 .57049 L
.21435 .57049 L
.21502 .57049 L
.21572 .57049 L
.21697 .57049 L
.21767 .57049 L
.21832 .57049 L
.21903 .57049 L
.2198 .57049 L
.22046 .57049 L
.22118 .57049 L
.22248 .57049 L
.22375 .57049 L
.22492 .57049 L
Mistroke
.22617 .57049 L
.22735 .57049 L
.22842 .57049 L
.22958 .57049 L
.23084 .57049 L
.23154 .57049 L
.23218 .57049 L
.23342 .57049 L
.23459 .57049 L
.23569 .57049 L
.23687 .57049 L
.23799 .57049 L
.239 .57049 L
.24014 .57049 L
.24122 .57049 L
.24239 .57049 L
.24366 .57049 L
.24496 .57049 L
.24561 .57049 L
.24634 .57049 L
.24762 .57049 L
.24882 .57049 L
.25002 .57049 L
.25113 .57049 L
.2523 .57049 L
.25357 .57049 L
.25487 .57049 L
.2556 .57049 L
.25626 .57049 L
.25753 .57049 L
.25873 .57049 L
.2594 .57049 L
.26012 .57049 L
.2614 .57049 L
.26211 .57049 L
.26277 .57049 L
.2635 .57049 L
.26429 .57049 L
.26498 .57049 L
.26563 .57049 L
.26684 .57049 L
.26814 .57049 L
.26888 .57049 L
.26955 .57049 L
.27068 .57049 L
.27192 .57049 L
.27322 .57049 L
.27443 .57049 L
.27512 .57049 L
.27586 .57049 L
Mistroke
.27657 .57049 L
.27722 .57049 L
.27846 .57049 L
.27977 .57049 L
.28044 .57049 L
.28117 .57049 L
.28248 .57049 L
.28328 .57049 L
.28405 .57049 L
.28473 .57049 L
.28548 .57049 L
.28613 .57049 L
.28684 .57049 L
.28812 .57049 L
.28937 .57049 L
.29052 .57049 L
.29177 .57049 L
.29248 .57049 L
.29314 .57049 L
.29382 .57049 L
.29456 .57049 L
.29526 .57049 L
.2959 .57049 L
.29709 .57049 L
.29834 .57049 L
.2994 .57049 L
.30057 .57049 L
.30182 .57049 L
.30252 .57049 L
.30316 .57049 L
.30434 .57049 L
.30558 .57049 L
.30682 .57049 L
.30751 .57049 L
.30815 .57049 L
.30933 .57049 L
.31058 .57049 L
.3117 .57049 L
.31274 .57049 L
.31389 .57049 L
.31512 .57049 L
.31643 .57049 L
.31717 .57049 L
.31785 .57049 L
.31911 .57049 L
.31981 .57049 L
.32045 .57049 L
.32165 .57049 L
.32296 .57049 L
.32418 .57049 L
Mistroke
.32532 .57049 L
.32638 .57049 L
.32752 .57049 L
.3286 .57049 L
.32958 .57049 L
.33073 .57049 L
.33198 .57049 L
.33316 .57049 L
.33425 .57049 L
.33537 .57049 L
.33643 .57049 L
.33758 .57049 L
.33882 .57049 L
.34006 .57049 L
.34136 .57049 L
.34257 .57049 L
.34368 .57049 L
.34492 .57049 L
.34557 .57049 L
.34626 .57049 L
.34742 .57049 L
.34869 .57049 L
.34983 .57049 L
.35105 .57049 L
.35219 .57049 L
.35324 .57049 L
.35455 .57049 L
.35575 .57049 L
.35638 .57049 L
.35707 .57049 L
.3578 .57049 L
.35848 .57049 L
.35973 .57049 L
.36087 .57049 L
.36213 .57049 L
.36276 .57049 L
.36345 .57049 L
.36469 .57049 L
.36586 .57049 L
.36691 .57049 L
.36805 .57049 L
.36929 .57049 L
.37061 .57049 L
.37173 .57049 L
.37297 .57049 L
.37412 .57049 L
.37517 .57049 L
.37639 .57049 L
.37754 .57049 L
.3786 .57049 L
Mistroke
.37959 .57049 L
.38067 .57049 L
.38183 .57049 L
.38307 .57049 L
.38378 .57049 L
.38443 .57049 L
.38513 .57049 L
.38576 .57049 L
.38649 .57049 L
.38719 .57049 L
.38841 .57049 L
.38955 .57049 L
.39079 .57049 L
.39142 .57049 L
.39212 .57049 L
.39282 .57049 L
.39356 .57049 L
.39488 .57049 L
.39562 .57049 L
.3963 .57049 L
.39705 .57049 L
.39786 .57049 L
.39855 .57049 L
.39931 .57049 L
.40002 .57049 L
.40068 .57049 L
.40193 .57049 L
.40324 .57049 L
.4045 .57049 L
.40564 .57049 L
.40696 .57049 L
.40821 .57049 L
.40936 .57049 L
.41043 .57049 L
.4116 .57049 L
.41285 .57049 L
.41357 .57049 L
.41423 .57049 L
.41495 .57049 L
.41571 .57049 L
.41699 .57049 L
.41772 .57049 L
.4184 .57049 L
.41967 .57049 L
.42082 .57049 L
.42146 .57049 L
.42216 .57049 L
.42342 .57049 L
.42464 .57049 L
.42576 .57049 L
Mistroke
.42697 .57049 L
.42828 .57049 L
.4295 .57049 L
.43062 .57049 L
.4317 .57049 L
.43285 .57049 L
.43355 .57049 L
.43419 .57049 L
.4349 .57049 L
.43565 .57049 L
.43691 .57049 L
.43763 .57049 L
.43829 .57049 L
.43953 .57049 L
.44085 .57049 L
.44207 .57049 L
.44324 .57049 L
.44444 .57049 L
.44513 .57049 L
.44577 .57049 L
.44707 .57049 L
.44773 .57049 L
.44846 .57049 L
.44969 .57049 L
.45099 .57049 L
.45219 .57049 L
.4533 .57049 L
.45399 .57049 L
.45473 .57049 L
.45543 .57049 L
.45608 .57049 L
.4573 .57049 L
.4586 .57049 L
.45927 .57049 L
.45999 .57049 L
.46129 .57049 L
.46209 .57049 L
.46284 .57049 L
.46358 .57049 L
.46426 .57049 L
.46551 .57049 L
.46616 .57049 L
.46685 .57049 L
.46802 .57049 L
.4693 .57049 L
.47044 .57049 L
.47166 .57049 L
.47281 .57049 L
.47386 .57049 L
.47517 .57049 L
Mistroke
.47638 .57049 L
.47701 .57049 L
.4777 .57049 L
.47843 .57049 L
.47911 .57049 L
.48036 .57049 L
.48151 .57049 L
.48276 .57049 L
.48409 .57049 L
.48524 .57049 L
.48629 .57049 L
.4875 .57049 L
.48864 .57049 L
.4897 .57049 L
.49067 .57049 L
.49174 .57049 L
.49287 .57049 L
.49401 .57049 L
.49524 .57049 L
.49639 .57049 L
.49745 .57049 L
.49869 .57049 L
.49938 .57049 L
.50003 .57049 L
.50122 .57049 L
.50248 .57049 L
.50373 .57049 L
.50444 .57049 L
.5051 .57049 L
.5058 .57049 L
.50643 .57049 L
.50717 .57049 L
.50786 .57049 L
.5091 .57049 L
.51023 .57049 L
.51148 .57049 L
.51211 .57049 L
.51281 .57049 L
.51355 .57049 L
.51425 .57049 L
.51489 .57049 L
.51558 .57049 L
.51633 .57049 L
.51712 .57049 L
.51788 .57049 L
.51856 .57049 L
.51926 .57049 L
.51989 .57049 L
.5206 .57049 L
.52134 .57049 L
Mistroke
.52258 .57049 L
.52329 .57049 L
.52395 .57049 L
.52521 .57049 L
.52591 .57049 L
.52657 .57049 L
.52777 .57049 L
.52905 .57049 L
.53019 .57049 L
.53126 .57049 L
.53243 .57049 L
.5337 .57049 L
.53496 .57049 L
.53568 .57049 L
.53635 .57049 L
.53706 .57049 L
.5377 .57049 L
.53844 .57049 L
.53915 .57049 L
.54039 .57049 L
.54154 .57049 L
.5428 .57049 L
.54344 .57049 L
.54414 .57049 L
.54544 .57049 L
.54664 .57049 L
.54795 .57049 L
.54869 .57049 L
.54935 .57049 L
.55058 .57049 L
.55127 .57049 L
.5519 .57049 L
.55307 .57049 L
.5543 .57049 L
.55541 .57049 L
.55659 .57049 L
.55771 .57049 L
.55873 .57049 L
.55993 .57049 L
.56123 .57049 L
.56245 .57049 L
.56359 .57049 L
.56472 .57049 L
.56591 .57049 L
.56721 .57049 L
.56841 .57049 L
.56972 .57049 L
.57046 .57049 L
.57115 .57049 L
.57239 .57049 L
Mistroke
.57309 .57049 L
.57372 .57049 L
.57439 .57049 L
.57511 .57049 L
.57638 .57049 L
.57775 .57049 L
.57853 .57049 L
.57926 .57049 L
.58057 .57049 L
.58178 .57049 L
.58448 .57049 L
.62429 .57049 L
.66258 .57049 L
.70332 .57049 L
.74255 .57049 L
.78027 .57049 L
.82043 .57049 L
.85908 .57049 L
.90019 .57049 L
.93977 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`03000006Ko06Ko00D0I_l2
oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooo000000`00005<ol000<0000co`0co`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0007
<ol000<0000co`0co`0023?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`0Boooo000Koooo1P1Vo`Ooool00`000?ooooooo`07oooo00<0I_ooooooool07?oo
o`030000oooooooo027oool60000:C?o00030000oooooooo02Koool00`000?ooooooo`0Voooo00<0
003oooooool09oooo`008Oooo`H0I_l;oooo00<0I_ooooooool0AOooo`<0000W<ol000<0003ooooo
ool0NOooo`009oooo`80I_l9oooo00<0I_ooooooool0B?ooo`80000U<ol000<0003oooooool0NOoo
o`00:Oooo`<0I_l6oooo00<0I_ooooooool0B_ooo`030000<ol0<ol0028co`020000N_ooo`00;?oo
o`D0I_l00oooo`1Vooooo`1<oooo00<0000co`0co`008C?o00030000oooooooo07Woool0037oool2
06KoC_ooo`80000Q<ol000<0003oooooool0NOooo`00<_ooo`03o`2Ioooooooo04koool00`0003?o
03?o000N<ol000<0003oooooool0NOooo`00<_ooo`03o`2Ioooooooo04koool00`0003?o03?o000N
<ol000<0003oooooool0NOooo`00<_ooo`03o`2Ioooooooo04ooool00`0003?o03?o000M<ol00P00
07[oool003;oool00ol0VOooooooo`1@oooo00<0000co`0co`0073?o00030000oooooooo07Woool0
03;oool00ol0VOooooooo`1Aoooo00<0000co`0co`006c?o00030000oooooooo07Woool003;oool0
0ol0VOooooooo`1Aoooo00<0000co`0co`006c?o00030000oooooooo07Woool008OooolM<ol0O?oo
o`00R?oooa`co`1loooo0028oooo73?o07coool008SooolL<ol0O?ooo`00ROoooa/co`1loooo001i
oooo00<0003oooooool03Ooooa/co`000`000?ooooooo`1ioooo001hoooo00<0003oooooool02?oo
o`030000oooooooo00CooolJ<ol000?oool0003oool0NOooo`00N?ooo`030000oooooooo00;oool2
00001?ooo`030000oooooooo00Coool:<ol00`00008co`02000013?o00800003<ol000?oool0003o
ool0NOooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool01?ooo`@00006<ol000<0000co`0co`001S?o00040000<ol0<ol000000S?o0003oooo0000oooo
07Woool007Ooool00`000?ooooooo`02oooo00<0003oooooool03?ooo`Lco`0500002S?o00030000
<ol0<ol000;oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0000_oool7<ol000@0
000co`0co`000009<ol00P0000<co`000oooo`000?ooo`1ioooo001hoooo00D0003oooooooooool0
00003oooo`Lco`000`0003?o00000009<ol000<0000co`0co`000S?o0003oooo0000oooo07Woool0
07Woool00`000?ooooooo`0@oooo23?o00800009<ol00`00008co`000`000?ooooooo`1ioooo002<
oooo63?o07coool008cooolH<ol0O?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.16408 .57049 L
.17277 .57049 L
.17735 .57049 L
.17986 .57049 L
.18109 .57049 L
.18221 .57049 L
s
.18221 .57049 m
.18221 .61803 L
s
0 .4 1 r
.02381 .57212 m
.04262 .57277 L
.06244 .57373 L
.07286 .5744 L
.08255 .57513 L
.09388 .57617 L
.10458 .57736 L
.125 .58037 L
.14357 .58425 L
.16355 .59013 L
.17243 .5935 L
.17733 .5956 L
.17974 .59671 L
.18092 .59726 L
.18199 .59777 L
.18316 .57049 L
.1844 .57049 L
.18505 .57049 L
.18576 .57049 L
.18704 .57049 L
.18821 .57049 L
.18944 .57049 L
.1905 .57049 L
.19166 .57049 L
.19284 .57049 L
.19392 .57049 L
.19516 .57049 L
.19634 .57049 L
.19743 .57049 L
.19843 .57049 L
.19954 .57049 L
.20071 .57049 L
.2019 .57049 L
.20315 .57049 L
.2038 .57049 L
.20451 .57049 L
.20577 .57049 L
.20696 .57049 L
.20823 .57049 L
.20943 .57049 L
.21052 .57049 L
.21181 .57049 L
.21247 .57049 L
.21319 .57049 L
.21397 .57049 L
.21469 .57049 L
.21536 .57049 L
.21608 .57049 L
.21676 .57049 L
.21749 .57049 L
Mistroke
.21819 .57049 L
.21883 .57049 L
.22004 .57049 L
.22134 .57049 L
.22259 .57049 L
.22329 .57049 L
.22395 .57049 L
.22465 .57049 L
.22529 .57049 L
.22602 .57049 L
.22671 .57049 L
.22794 .57049 L
.22908 .57049 L
.23033 .57049 L
.23096 .57049 L
.23165 .57049 L
.23235 .57049 L
.23309 .57049 L
.23373 .57049 L
.23442 .57049 L
.23517 .57049 L
.23596 .57049 L
.23672 .57049 L
.2374 .57049 L
.23809 .57049 L
.23873 .57049 L
.23943 .57049 L
.24017 .57049 L
.24142 .57049 L
.24213 .57049 L
.24279 .57049 L
.24404 .57049 L
.24475 .57049 L
.2454 .57049 L
.2466 .57049 L
.24788 .57049 L
.24902 .57049 L
.25009 .57049 L
.25126 .57049 L
.25253 .57049 L
.25379 .57049 L
.25451 .57049 L
.25518 .57049 L
.25589 .57049 L
.25653 .57049 L
.25728 .57049 L
.25797 .57049 L
.25921 .57049 L
.25986 .57049 L
.26054 .57049 L
Mistroke
.2617 .57049 L
.26297 .57049 L
.26426 .57049 L
.26546 .57049 L
.26677 .57049 L
.26751 .57049 L
.26817 .57049 L
.2694 .57049 L
.27072 .57049 L
.27197 .57049 L
.27312 .57049 L
.27423 .57049 L
.27527 .57049 L
.27641 .57049 L
.27763 .57049 L
.27891 .57049 L
.28012 .57049 L
.2824 .57049 L
.2837 .57049 L
.28492 .57049 L
.28619 .57049 L
.28687 .57049 L
.28759 .57049 L
.28882 .57049 L
.2901 .57049 L
.2912 .57049 L
.2924 .57049 L
.29307 .57049 L
.2938 .57049 L
.29449 .57049 L
.29513 .57049 L
.29587 .57049 L
.29665 .57049 L
.29731 .57049 L
.29804 .57049 L
.29934 .57049 L
.30008 .57049 L
.30075 .57049 L
.30205 .57049 L
.30328 .57049 L
.30453 .57049 L
.30524 .57049 L
.30588 .57049 L
.30707 .57049 L
.30833 .57049 L
.30946 .57049 L
.31051 .57049 L
.31167 .57049 L
.3129 .57049 L
.31422 .57049 L
Mistroke
.31497 .57049 L
.31566 .57049 L
.31692 .57049 L
.31756 .57049 L
.31826 .57049 L
.31947 .57049 L
.32078 .57049 L
.32201 .57049 L
.32314 .57049 L
.32427 .57049 L
.32548 .57049 L
.32662 .57049 L
.32765 .57049 L
.32887 .57049 L
.33018 .57049 L
.33143 .57049 L
.33257 .57049 L
.33366 .57049 L
.33483 .57049 L
.33593 .57049 L
.33694 .57049 L
.33806 .57049 L
.33913 .57049 L
.34029 .57049 L
.34154 .57049 L
.34276 .57049 L
.34388 .57049 L
.3451 .57049 L
.34639 .57049 L
.34751 .57049 L
.34856 .57049 L
.3497 .57049 L
.35094 .57049 L
.35164 .57049 L
.35229 .57049 L
.35356 .57049 L
.35472 .57049 L
.35595 .57049 L
.35727 .57049 L
.3585 .57049 L
.3592 .57049 L
.35986 .57049 L
.36062 .57049 L
.36131 .57049 L
.36199 .57049 L
.36263 .57049 L
.36383 .57049 L
.36513 .57049 L
.36579 .57049 L
.36652 .57049 L
Mistroke
.36775 .57049 L
.36904 .57049 L
.37024 .57049 L
.37136 .57049 L
.37266 .57049 L
.3734 .57049 L
.37408 .57049 L
.37532 .57049 L
.37595 .57049 L
.37665 .57049 L
.37739 .57049 L
.37818 .57049 L
.37893 .57049 L
.37961 .57049 L
.38093 .57049 L
.38159 .57049 L
.38231 .57049 L
.38296 .57049 L
.38364 .57049 L
.38486 .57049 L
.38617 .57049 L
.38692 .57049 L
.38761 .57049 L
.38887 .57049 L
.39002 .57049 L
.39066 .57049 L
.39135 .57049 L
.39261 .57049 L
.39373 .57049 L
.39496 .57049 L
.39625 .57049 L
.39746 .57049 L
.39859 .57049 L
.39962 .57049 L
.40076 .57049 L
.40195 .57049 L
.40327 .57049 L
.40446 .57049 L
.40512 .57049 L
.40583 .57049 L
.40713 .57049 L
.40835 .57049 L
.40964 .57049 L
.41075 .57049 L
.41196 .57049 L
.41269 .57049 L
.41338 .57049 L
.41468 .57049 L
.41541 .57049 L
.41609 .57049 L
Mistroke
.41683 .57049 L
.41762 .57049 L
.4183 .57049 L
.41905 .57049 L
.41975 .57049 L
.4204 .57049 L
.42162 .57049 L
.42292 .57049 L
.42414 .57049 L
.42482 .57049 L
.42546 .57049 L
.42663 .57049 L
.42788 .57049 L
.42898 .57049 L
.43002 .57049 L
.43117 .57049 L
.4324 .57049 L
.43363 .57049 L
.43433 .57049 L
.43498 .57049 L
.43629 .57049 L
.43703 .57049 L
.4377 .57049 L
.4389 .57049 L
.4402 .57049 L
.44143 .57049 L
.44256 .57049 L
.44362 .57049 L
.44475 .57049 L
.44582 .57049 L
.4468 .57049 L
.44795 .57049 L
.44919 .57049 L
.45037 .57049 L
.45147 .57049 L
.4527 .57049 L
.45386 .57049 L
.45491 .57049 L
.45603 .57049 L
.45727 .57049 L
.45857 .57049 L
.45968 .57049 L
.46089 .57049 L
.46221 .57049 L
.46342 .57049 L
.46405 .57049 L
.46475 .57049 L
.46547 .57049 L
.46615 .57049 L
.46741 .57049 L
Mistroke
.46855 .57049 L
.46987 .57049 L
.47113 .57049 L
.47225 .57049 L
.47344 .57049 L
.47456 .57049 L
.47558 .57049 L
.47679 .57049 L
.47809 .57049 L
.47932 .57049 L
.48045 .57049 L
.48165 .57049 L
.48279 .57049 L
.4841 .57049 L
.4853 .57049 L
.48662 .57049 L
.48736 .57049 L
.48805 .57049 L
.4893 .57049 L
.48993 .57049 L
.49062 .57049 L
.4913 .57049 L
.49201 .57049 L
.49329 .57049 L
.494 .57049 L
.49467 .57049 L
.49539 .57049 L
.49617 .57049 L
.49684 .57049 L
.49757 .57049 L
.49826 .57049 L
.4989 .57049 L
.5001 .57049 L
.50138 .57049 L
.50259 .57049 L
.5039 .57049 L
.50515 .57049 L
.5063 .57049 L
.50745 .57049 L
.50848 .57049 L
.50968 .57049 L
.5108 .57049 L
.51203 .57049 L
.51317 .57049 L
.51436 .57049 L
.51567 .57049 L
.51636 .57049 L
.517 .57049 L
.51772 .57049 L
.51841 .57049 L
Mistroke
.51962 .57049 L
.52093 .57049 L
.52207 .57049 L
.52313 .57049 L
.52429 .57049 L
.52555 .57049 L
.52679 .57049 L
.5281 .57049 L
.52924 .57049 L
.53045 .57049 L
.53159 .57049 L
.53262 .57049 L
.53367 .57049 L
.53465 .57049 L
.5358 .57049 L
.53685 .57049 L
.53801 .57049 L
.53924 .57049 L
.54045 .57049 L
.54178 .57049 L
.54302 .57049 L
.54418 .57049 L
.54533 .57049 L
.54637 .57049 L
.5475 .57049 L
.54869 .57049 L
.55 .57049 L
.55121 .57049 L
.5525 .57049 L
.55324 .57049 L
.55392 .57049 L
.55516 .57049 L
.5563 .57049 L
.5576 .57049 L
.55884 .57049 L
.55989 .57049 L
.56105 .57049 L
.56227 .57049 L
.5634 .57049 L
.56446 .57049 L
.56543 .57049 L
.56656 .57049 L
.56762 .57049 L
.56876 .57049 L
.56998 .57049 L
.57114 .57049 L
.57218 .57049 L
.57341 .57049 L
.5741 .57049 L
.57474 .57049 L
Mistroke
.57592 .57049 L
.57716 .57049 L
.57838 .57049 L
.57906 .57049 L
.5797 .57049 L
.58087 .57049 L
.58211 .57049 L
.58663 .57049 L
.59679 .57049 L
.61512 .57049 L
.65287 .57049 L
.69307 .57049 L
.73175 .57049 L
.77289 .57049 L
.81251 .57049 L
.85061 .57049 L
.89117 .57049 L
.93021 .57049 L
.9717 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0406Ko1?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooo000000`00005<ol000<0000co`0co`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0007
<ol000<0000co`0co`0023?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`0Boooo000Toooo101Vo`03000006Ko06Ko017oool00`1Vooooooooo`0Boooo00<0
003oooooool08Oooo`H0000Y<ol000<0003oooooool09_ooo`030000oooooooo02Koool00`000?oo
ooooo`0Woooo000[oooo1@1Vo`coool00`1Vooooooooo`0koooo0`0002Lco`000`000?ooooooo`1i
oooo000`oooo1@1Vo`Ooool00`1Vooooooooo`0noooo0P0002Dco`000`000?ooooooo`1ioooo000e
oooo101Vo`?oool00`1Vooooooooo`10oooo00<0000co`0co`008S?o0080001joooo000ioooo0P1V
o`03oooo06Kooooo04;oool00`0003?o03?o000Q<ol000<0003oooooool0NOooo`00>oooo`80I_m4
oooo0P00024co`000`000?ooooooo`1ioooo000loooo00?o09Woooooool0A?ooo`030000<ol0<ol0
01hco`000`000?ooooooo`1ioooo000loooo00?o09Woooooool0A?ooo`030000<ol0<ol001hco`00
0`000?ooooooo`1ioooo000loooo00?o09Woooooool0AOooo`030000<ol0<ol001dco`020000N_oo
o`00??ooo`03o`2Ioooooooo04Koool00`0003?o03?o000L<ol000<0003oooooool0NOooo`00??oo
o`03o`2Ioooooooo04Ooool00`0003?o03?o000K<ol000<0003oooooool0NOooo`00??ooo`03o`2I
oooooooo04Ooool00`0003?o03?o000K<ol000<0003oooooool0NOooo`00Qooooadco`1loooo0028
oooo73?o07coool008SooolL<ol0O?ooo`00R?oooa`co`1loooo0029oooo6c?o07coool007coool0
0`000?ooooooo`0:oooo63?o00030000<ol0<ol007coool007_oool00`000?ooooooo`08oooo00@0
003ooooooooooolH<ol000<0000co`3oool0Noooo`00Noooo`030000oooooooo00;oool200001?oo
o`040000oooooooooooo3C?o00<00002<ol00P0000@co`000`0003?o0?ooo`1koooo001koooo00D0
003oooooooooool000000_ooo`030000oooooooo00;oool010000?ooooooooooo`<co`0400001S?o
00030000<ol0<ol000Lco`000`0003?o0?ooo`1koooo001joooo00<0003oooooool00_ooo`030000
oooooooo00Woool:<ol01@0000Tco`000`000?ooooooo`1joooo001koooo00<0003oooooool01@00
00Soool:<ol000@0000co`0co`000009<ol000<0000co`3oool0Noooo`00Noooo`050000oooooooo
oooo000000coool:<ol000<0000co`0000002C?o00030000<ol0oooo07_oool007coool00`000?oo
ooooo`0=oooo2c?o00800008<ol000<0000co`0co`00O?ooo`00S?oooaPco`1loooo002<oooo63?o
07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.20178 .57049 L
.20742 .57049 L
.21274 .57049 L
.21753 .57049 L
.21884 .57049 L
.22022 .57049 L
.22141 .57049 L
s
.22141 .57049 m
.22142 .61803 L
s
0 .4 1 r
.02381 .5713 m
.04262 .57162 L
.06244 .57209 L
.07286 .57242 L
.08255 .57278 L
.09388 .57329 L
.10458 .57388 L
.125 .57537 L
.14357 .57728 L
.16355 .58018 L
.18199 .58394 L
.20071 .58927 L
.21136 .5932 L
.21653 .59539 L
.21905 .59653 L
.22015 .59704 L
.22134 .59761 L
.22257 .57049 L
.22374 .57049 L
.2263 .57049 L
.22701 .57049 L
.22767 .57049 L
.22836 .57049 L
.22912 .57049 L
.23037 .57049 L
.23108 .57049 L
.23172 .57049 L
.23298 .57049 L
.23414 .57049 L
.23542 .57049 L
.23607 .57049 L
.23678 .57049 L
.23798 .57049 L
.23926 .57049 L
.24047 .57049 L
.24158 .57049 L
.24266 .57049 L
.24382 .57049 L
.24491 .57049 L
.24589 .57049 L
.24706 .57049 L
.24832 .57049 L
.24951 .57049 L
.25061 .57049 L
.26011 .57049 L
.26992 .57049 L
.27058 .57049 L
.27128 .57049 L
.27204 .57049 L
.27275 .57049 L
Mistroke
.27348 .57049 L
.27416 .57049 L
.27543 .57049 L
.27669 .57049 L
.27785 .57049 L
.27912 .57049 L
.27976 .57049 L
.28047 .57049 L
.28175 .57049 L
.28296 .57049 L
.28405 .57049 L
.28523 .57049 L
.28651 .57049 L
.28716 .57049 L
.28788 .57049 L
.28914 .57049 L
.29032 .57049 L
.29145 .57049 L
.29263 .57049 L
.29364 .57049 L
.29475 .57049 L
.29594 .57049 L
.29722 .57049 L
.29842 .57049 L
.29951 .57049 L
.30064 .57049 L
.30188 .57049 L
.30318 .57049 L
.30439 .57049 L
.3055 .57049 L
.30655 .57049 L
.30777 .57049 L
.30888 .57049 L
.3101 .57049 L
.3114 .57049 L
.31251 .57049 L
.31373 .57049 L
.31504 .57049 L
.31578 .57049 L
.31645 .57049 L
.3177 .57049 L
.31901 .57049 L
.32014 .57049 L
.32121 .57049 L
.32244 .57049 L
.32356 .57049 L
.32461 .57049 L
.32559 .57049 L
.32666 .57049 L
.32779 .57049 L
Mistroke
.32893 .57049 L
.33015 .57049 L
.33131 .57049 L
.33236 .57049 L
.3336 .57049 L
.3343 .57049 L
.33495 .57049 L
.33613 .57049 L
.3374 .57049 L
.33864 .57049 L
.33936 .57049 L
.34001 .57049 L
.3407 .57049 L
.34143 .57049 L
.34212 .57049 L
.34276 .57049 L
.34399 .57049 L
.34513 .57049 L
.34637 .57049 L
.347 .57049 L
.3477 .57049 L
.3484 .57049 L
.34914 .57049 L
.35046 .57049 L
.3512 .57049 L
.35188 .57049 L
.35263 .57049 L
.35344 .57049 L
.35414 .57049 L
.35489 .57049 L
.3556 .57049 L
.35626 .57049 L
.35751 .57049 L
.35883 .57049 L
.36008 .57049 L
.36122 .57049 L
.36254 .57049 L
.36379 .57049 L
.36495 .57049 L
.36602 .57049 L
.36719 .57049 L
.36844 .57049 L
.36915 .57049 L
.36981 .57049 L
.37053 .57049 L
.37129 .57049 L
.37258 .57049 L
.3733 .57049 L
.37398 .57049 L
.37525 .57049 L
Mistroke
.37641 .57049 L
.37705 .57049 L
.37774 .57049 L
.379 .57049 L
.3802 .57049 L
.38135 .57049 L
.38267 .57049 L
.38387 .57049 L
.385 .57049 L
.38605 .57049 L
.38721 .57049 L
.38844 .57049 L
.38914 .57049 L
.38978 .57049 L
.39048 .57049 L
.39124 .57049 L
.39253 .57049 L
.39323 .57049 L
.39389 .57049 L
.39513 .57049 L
.39627 .57049 L
.39759 .57049 L
.39883 .57049 L
.40003 .57049 L
.40072 .57049 L
.40137 .57049 L
.40266 .57049 L
.40339 .57049 L
.40406 .57049 L
.40519 .57049 L
.40642 .57049 L
.4077 .57049 L
.4089 .57049 L
.40958 .57049 L
.41033 .57049 L
.41103 .57049 L
.41167 .57049 L
.4129 .57049 L
.4142 .57049 L
.41487 .57049 L
.41559 .57049 L
.41689 .57049 L
.41769 .57049 L
.41844 .57049 L
.41912 .57049 L
.41986 .57049 L
.42051 .57049 L
.42119 .57049 L
.42242 .57049 L
.42374 .57049 L
Mistroke
.42448 .57049 L
.42518 .57049 L
.42645 .57049 L
.4276 .57049 L
.42826 .57049 L
.42895 .57049 L
.43019 .57049 L
.43129 .57049 L
.4325 .57049 L
.43379 .57049 L
.43501 .57049 L
.43615 .57049 L
.4372 .57049 L
.43835 .57049 L
.43956 .57049 L
.44076 .57049 L
.44205 .57049 L
.44328 .57049 L
.44441 .57049 L
.44573 .57049 L
.44639 .57049 L
.44712 .57049 L
.4484 .57049 L
.44959 .57049 L
.45026 .57049 L
.45099 .57049 L
.45168 .57049 L
.45232 .57049 L
.45307 .57049 L
.45386 .57049 L
.45453 .57049 L
.45526 .57049 L
.45657 .57049 L
.45731 .57049 L
.45798 .57049 L
.45923 .57049 L
.46054 .57049 L
.46177 .57049 L
.46246 .57049 L
.46311 .57049 L
.46428 .57049 L
.46553 .57049 L
.46664 .57049 L
.46769 .57049 L
.46883 .57049 L
.47006 .57049 L
.47137 .57049 L
.47211 .57049 L
.47279 .57049 L
.47405 .57049 L
Mistroke
.47475 .57049 L
.47538 .57049 L
.47659 .57049 L
.47789 .57049 L
.47912 .57049 L
.48025 .57049 L
.48131 .57049 L
.48245 .57049 L
.48353 .57049 L
.48451 .57049 L
.48568 .57049 L
.48693 .57049 L
.488 .57049 L
.48918 .57049 L
.49037 .57049 L
.4915 .57049 L
.49271 .57049 L
.49402 .57049 L
.49518 .57049 L
.49641 .57049 L
.49746 .57049 L
.49861 .57049 L
.49993 .57049 L
.50114 .57049 L
.50245 .57049 L
.50315 .57049 L
.50389 .57049 L
.50515 .57049 L
.50632 .57049 L
.50701 .57049 L
.50766 .57049 L
.50888 .57049 L
.51001 .57049 L
.5112 .57049 L
.51233 .57049 L
.51335 .57049 L
.51456 .57049 L
.51586 .57049 L
.51709 .57049 L
.51822 .57049 L
.51944 .57049 L
.52074 .57049 L
.52197 .57049 L
.52309 .57049 L
.5244 .57049 L
.52514 .57049 L
.52583 .57049 L
.52708 .57049 L
.52772 .57049 L
.52842 .57049 L
Mistroke
.52913 .57049 L
.52981 .57049 L
.53109 .57049 L
.5318 .57049 L
.53247 .57049 L
.53319 .57049 L
.53397 .57049 L
.53464 .57049 L
.53537 .57049 L
.53606 .57049 L
.5367 .57049 L
.53797 .57049 L
.53917 .57049 L
.54035 .57049 L
.54163 .57049 L
.54279 .57049 L
.54387 .57049 L
.54502 .57049 L
.5463 .57049 L
.54695 .57049 L
.54764 .57049 L
.5489 .57049 L
.55009 .57049 L
.5512 .57049 L
.55236 .57049 L
.55363 .57049 L
.55465 .57049 L
.55572 .57049 L
.5569 .57049 L
.55798 .57049 L
.55926 .57049 L
.55999 .57049 L
.56067 .57049 L
.56189 .57049 L
.56321 .57049 L
.56448 .57049 L
.56569 .57049 L
.56678 .57049 L
.56796 .57049 L
.56869 .57049 L
.56937 .57049 L
.57064 .57049 L
.57136 .57049 L
.57202 .57049 L
.57274 .57049 L
.5735 .57049 L
.57477 .57049 L
.57595 .57049 L
.57725 .57049 L
.57797 .57049 L
Mistroke
.57864 .57049 L
.57982 .57049 L
.58093 .57049 L
.58345 .57049 L
.58856 .57049 L
.59774 .57049 L
.61851 .57049 L
.65722 .57049 L
.69839 .57049 L
.73804 .57049 L
.77618 .57049 L
.81677 .57049 L
.85584 .57049 L
.89737 .57049 L
.93738 .57049 L
.97587 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00L0I_l0
0`00001Vo`1Vo`0806Ko00<00000I_l0I_l01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00?o09T0003oool02?ooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oool0
0000300000Dco`000`0003?o03?o0008<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`00
0`0003?o03?o0008<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000
oooooooo01;oool002Soool00`000?ooooooo`0:06Ko4Oooo`03o`2I06Kooooo00Soool00`000?oo
ooooo`0Qoooo1P0002Tco`000`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool003Goool506Ko3?ooo`03o`2I06Kooooo037oool300009c?o00030000oooooooo07Woool0
03[oool506Ko1oooo`0306Kooooooooo03Coool200009C?o00030000oooooooo07Woool003ooool4
06Ko0oooo`0306Kooooooooo03Koool00`0003?o03?o000R<ol00P0007[oool004?oool206Ko00?o
ool0I_ooool0>?ooo`030000<ol0<ol0024co`000`000?ooooooo`1ioooo0015oooo0P1Voc[oool2
00008C?o00030000oooooooo07Woool004Koool00ol0VOooooooo`0joooo00<0000co`0co`007S?o
00030000oooooooo07Woool004Koool00ol0VOooooooo`0joooo00<0000co`0co`007S?o00030000
oooooooo07Woool004Koool00ol0VOooooooo`0koooo00<0000co`0co`007C?o0080001joooo0016
oooo00?o09Woooooool0??ooo`030000<ol0<ol001`co`000`000?ooooooo`1ioooo0016oooo00?o
09Woooooool0?Oooo`030000<ol0<ol001/co`000`000?ooooooo`1ioooo0016oooo00?o09Wooooo
ool0?Oooo`030000<ol0<ol001/co`000`000?ooooooo`1ioooo0027oooo7C?o07coool008SooolL
<ol0O?ooo`00R?oooa`co`1loooo0028oooo73?o07coool008WooolK<ol0O?ooo`00NOooo`030000
oooooooo00gooolK<ol000<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?oo
ooooo`04oooo6S?o0003oooo0000oooo07Woool007Soool00`000?ooooooo`02oooo0P0000Coool0
0`000?ooooooo`04oooo2C?o00800004<ol00P0000@co`0200000c?o0003oooo0000oooo07Woool0
07Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool4
00000c?o00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o0003oooo0000oooo07Woool0
07Ooool00`000?ooooooo`02oooo00<0003oooooool03?ooo`Tco`000`0003?o03?o000:<ol000<0
000co`0co`000_ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500002oooo`Xco`00
0`0003?o03?o0007<ol00P0000<co`000oooo`000?ooo`1ioooo001hoooo00D0003oooooooooool0
00003oooo`Hco`00100003?o03?o000000Tco`000`0003?o03?o0002<ol000?oool0003oool0NOoo
o`00NOooo`030000oooooooo013oool7<ol00P0000Xco`0300000S?o00030000oooooooo07Woool0
08cooolH<ol0O?ooo`00S?oooaPco`1loooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.24141 .57049 L
.25127 .57049 L
.25666 .57049 L
.2593 .57049 L
.26045 .57049 L
.26171 .57049 L
s
.26171 .57049 m
.26172 .61803 L
s
0 .4 1 r
.02381 .57089 m
.04262 .57105 L
.06244 .57128 L
.07286 .57144 L
.08255 .57162 L
.09388 .57187 L
.10458 .57216 L
.125 .57289 L
.14357 .57384 L
.16355 .57527 L
.18199 .57712 L
.20071 .57975 L
.21136 .58169 L
.22134 .58386 L
.24158 .58967 L
.25055 .59299 L
.25547 .59506 L
.25789 .59614 L
.26011 .59717 L
.26132 .59775 L
.26259 .57049 L
.26387 .57049 L
.2646 .57049 L
.26527 .57049 L
.26644 .57049 L
.26769 .57049 L
.26886 .57049 L
.26995 .57049 L
.27106 .57049 L
.27223 .57049 L
.27323 .57049 L
.27433 .57049 L
.27551 .57049 L
.27679 .57049 L
.27799 .57049 L
.27909 .57049 L
.2803 .57049 L
.28159 .57049 L
.28281 .57049 L
.28392 .57049 L
.28522 .57049 L
.28595 .57049 L
.28663 .57049 L
.28787 .57049 L
.28919 .57049 L
.29045 .57049 L
.29116 .57049 L
.2918 .57049 L
.29306 .57049 L
.29425 .57049 L
Mistroke
.29492 .57049 L
.29563 .57049 L
.29691 .57049 L
.29758 .57049 L
.2983 .57049 L
.29909 .57049 L
.29982 .57049 L
.30052 .57049 L
.30119 .57049 L
.30243 .57049 L
.30376 .57049 L
.3045 .57049 L
.30519 .57049 L
.30633 .57049 L
.30759 .57049 L
.3089 .57049 L
.31013 .57049 L
.31078 .57049 L
.3115 .57049 L
.31224 .57049 L
.31293 .57049 L
.31417 .57049 L
.31487 .57049 L
.31549 .57049 L
.31624 .57049 L
.31692 .57049 L
.31767 .57049 L
.31847 .57049 L
.31916 .57049 L
.3198 .57049 L
.32051 .57049 L
.32127 .57049 L
.32192 .57049 L
.32262 .57049 L
.32386 .57049 L
.32456 .57049 L
.32532 .57049 L
.32603 .57049 L
.32669 .57049 L
.32788 .57049 L
.32913 .57049 L
.33041 .57049 L
.33114 .57049 L
.33182 .57049 L
.33308 .57049 L
.33426 .57049 L
.33532 .57049 L
.33648 .57049 L
.33773 .57049 L
.33837 .57049 L
Mistroke
.33906 .57049 L
.3403 .57049 L
.34145 .57049 L
.3427 .57049 L
.34339 .57049 L
.34403 .57049 L
.34528 .57049 L
.34642 .57049 L
.34708 .57049 L
.34778 .57049 L
.34903 .57049 L
.34972 .57049 L
.35037 .57049 L
.35108 .57049 L
.35184 .57049 L
.35311 .57049 L
.35383 .57049 L
.3545 .57049 L
.35571 .57049 L
.35701 .57049 L
.35816 .57049 L
.35925 .57049 L
.36043 .57049 L
.36172 .57049 L
.36288 .57049 L
.36397 .57049 L
.36516 .57049 L
.36643 .57049 L
.36707 .57049 L
.36776 .57049 L
.36902 .57049 L
.37025 .57049 L
.37138 .57049 L
.37246 .57049 L
.37361 .57049 L
.3747 .57049 L
.37569 .57049 L
.3768 .57049 L
.37786 .57049 L
.379 .57049 L
.38024 .57049 L
.3809 .57049 L
.38158 .57049 L
.38281 .57049 L
.38413 .57049 L
.38488 .57049 L
.38558 .57049 L
.38685 .57049 L
.38801 .57049 L
.38864 .57049 L
Mistroke
.38934 .57049 L
.3906 .57049 L
.39172 .57049 L
.39296 .57049 L
.39426 .57049 L
.39547 .57049 L
.39651 .57049 L
.39762 .57049 L
.39884 .57049 L
.39997 .57049 L
.4007 .57049 L
.40139 .57049 L
.40268 .57049 L
.40391 .57049 L
.40461 .57049 L
.40525 .57049 L
.40637 .57049 L
.4076 .57049 L
.40888 .57049 L
.41008 .57049 L
.41076 .57049 L
.41149 .57049 L
.41219 .57049 L
.41283 .57049 L
.41404 .57049 L
.41533 .57049 L
.416 .57049 L
.41671 .57049 L
.41801 .57049 L
.41876 .57049 L
.41955 .57049 L
.42022 .57049 L
.42096 .57049 L
.42228 .57049 L
.4235 .57049 L
.42413 .57049 L
.42483 .57049 L
.42556 .57049 L
.42624 .57049 L
.4275 .57049 L
.42865 .57049 L
.42928 .57049 L
.42997 .57049 L
.43123 .57049 L
.43246 .57049 L
.43358 .57049 L
.43486 .57049 L
.43607 .57049 L
.4372 .57049 L
.43823 .57049 L
Mistroke
.43937 .57049 L
.44056 .57049 L
.44187 .57049 L
.44306 .57049 L
.44372 .57049 L
.44443 .57049 L
.44573 .57049 L
.44695 .57049 L
.44824 .57049 L
.44934 .57049 L
.45055 .57049 L
.45125 .57049 L
.45198 .57049 L
.45328 .57049 L
.454 .57049 L
.45468 .57049 L
.45542 .57049 L
.45621 .57049 L
.45689 .57049 L
.45764 .57049 L
.45834 .57049 L
.45899 .57049 L
.46021 .57049 L
.46151 .57049 L
.46273 .57049 L
.46405 .57049 L
.4653 .57049 L
.46645 .57049 L
.46758 .57049 L
.46864 .57049 L
.46975 .57049 L
.47097 .57049 L
.47221 .57049 L
.47351 .57049 L
.47463 .57049 L
.47585 .57049 L
.47717 .57049 L
.4779 .57049 L
.47857 .57049 L
.47988 .57049 L
.48111 .57049 L
.48217 .57049 L
.48333 .57049 L
.48455 .57049 L
.48568 .57049 L
.48675 .57049 L
.48772 .57049 L
.48884 .57049 L
.4899 .57049 L
.49105 .57049 L
Mistroke
.49227 .57049 L
.49342 .57049 L
.49446 .57049 L
.49569 .57049 L
.49639 .57049 L
.49702 .57049 L
.4982 .57049 L
.49944 .57049 L
.50066 .57049 L
.50135 .57049 L
.50199 .57049 L
.50316 .57049 L
.5044 .57049 L
.50551 .57049 L
.50655 .57049 L
.50769 .57049 L
.50892 .57049 L
.51016 .57049 L
.51085 .57049 L
.51148 .57049 L
.51271 .57049 L
.51387 .57049 L
.51506 .57049 L
.51636 .57049 L
.51705 .57049 L
.51778 .57049 L
.51908 .57049 L
.52021 .57049 L
.52128 .57049 L
.52251 .57049 L
.52364 .57049 L
.52488 .57049 L
.52558 .57049 L
.52623 .57049 L
.5274 .57049 L
.52865 .57049 L
.52979 .57049 L
.53102 .57049 L
.53218 .57049 L
.53325 .57049 L
.53422 .57049 L
.53528 .57049 L
.53639 .57049 L
.53742 .57049 L
.53868 .57049 L
.53932 .57049 L
.54003 .57049 L
.54127 .57049 L
.54244 .57049 L
.54315 .57049 L
Mistroke
.54381 .57049 L
.54507 .57049 L
.54577 .57049 L
.54642 .57049 L
.54714 .57049 L
.5479 .57049 L
.54918 .57049 L
.54991 .57049 L
.55058 .57049 L
.5518 .57049 L
.5531 .57049 L
.55426 .57049 L
.55535 .57049 L
.55654 .57049 L
.55782 .57049 L
.55905 .57049 L
.5602 .57049 L
.56146 .57049 L
.5621 .57049 L
.5628 .57049 L
.56397 .57049 L
.56524 .57049 L
.56643 .57049 L
.56753 .57049 L
.56859 .57049 L
.56959 .57049 L
.57068 .57049 L
.57184 .57049 L
.57306 .57049 L
.57422 .57049 L
.57526 .57049 L
.57639 .57049 L
.57761 .57049 L
.57874 .57049 L
.58004 .57049 L
.58127 .57049 L
.58584 .57049 L
.59624 .57049 L
.61728 .57049 L
.6555 .57049 L
.69617 .57049 L
.73533 .57049 L
.77694 .57049 L
.81703 .57049 L
.85561 .57049 L
.89664 .57049 L
.93616 .57049 L
.97416 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool0
0`000?ooo`1Vo`0806Ko00<00000I_l0I_l01`1Vo`03000006Ko06Ko00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oool0
0000300000Dco`000`0003?o03?o0008<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`00
0`0003?o03?o0008<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000
oooooooo01;oool002Soool00`000?ooooooo`0:oooo2P1Voa;oool00`000?ooooooo`0Qoooo1P00
02Tco`000`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo02Ooool003ooool6
06Ko3?ooo`0306Kooooooooo02Koool300009c?o00030000oooooooo07Woool004Goool406Ko2?oo
o`0306Kooooooooo02Woool200009C?o00030000oooooooo07Woool004Woool406Ko1?ooo`0306Ko
oooooooo02_oool00`0003?o03?o000R<ol00P0007[oool004goool206Ko0_ooo`0306Kooooooooo
02coool00`0003?o03?o000Q<ol000<0003oooooool0NOooo`00Coooo`<0I_l_oooo0P00024co`00
0`000?ooooooo`1ioooo001Aoooo00?o09Woooooool0;oooo`030000<ol0<ol001hco`000`000?oo
ooooo`1ioooo001Aoooo00?o09Woooooool0;oooo`030000<ol0<ol001hco`000`000?ooooooo`1i
oooo001Aoooo00?o09Woooooool0<?ooo`030000<ol0<ol001dco`020000N_ooo`00DOooo`03o`2I
oooooooo037oool00`0003?o03?o000L<ol000<0003oooooool0NOooo`00DOooo`03o`2Ioooooooo
03;oool00`0003?o03?o000K<ol000<0003oooooool0NOooo`00DOooo`03o`2Ioooooooo03;oool0
0`0003?o03?o000K<ol000<0003oooooool0NOooo`00Qooooadco`1loooo0028oooo73?o07coool0
08SooolL<ol0O?ooo`00R?oooa`co`1loooo0029oooo6c?o07coool007coool00`000?ooooooo`0:
oooo63?o00030000<ol0<ol007coool007_oool00`000?ooooooo`08oooo00@0003ooooooooooolH
<ol000<0000co`3oool0Noooo`00Noooo`030000oooooooo00;oool200001?ooo`040000oooooooo
oooo33?o00800004<ol00P0000@co`000`0003?o0?ooo`1koooo001koooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool010000?ooooooooooo`<co`0400000c?o00040000<ol0<ol0
00002C?o00030000<ol0oooo07_oool007[oool00`000?ooooooo`02oooo00<0003oooooool02Ooo
o``co`000`0003?o03?o0009<ol000<0003oooooool0N_ooo`00Noooo`030000oooooooo00D00008
oooo3C?o00030000<ol0<ol000Lco`000`0003?o0?ooo`1koooo001koooo00D0003oooooooooool0
00003?ooo`Tco`00100003?o03?o000000Tco`000`0003?o0?ooo`1koooo001loooo00<0003ooooo
ool03Oooo`Xco`0200002C?o00030000<ol0<ol007coool008cooolH<ol0O?ooo`00S?oooaPco`1l
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.27193 .57049 L
.28302 .57049 L
.2881 .57049 L
.29349 .57049 L
.29809 .57049 L
.29935 .57049 L
.30004 .57049 L
.3007 .57049 L
s
.3007 .57049 m
.30071 .61803 L
s
0 .4 1 r
.02381 .57069 m
.04262 .57077 L
.06244 .57088 L
.07286 .57096 L
.08255 .57105 L
.09388 .57117 L
.10458 .57132 L
.125 .57168 L
.14357 .57214 L
.16355 .57285 L
.18199 .57376 L
.20071 .57505 L
.21136 .57601 L
.22134 .57708 L
.24158 .57994 L
.26011 .58364 L
.27909 .58893 L
.28984 .59282 L
.29504 .59499 L
.29732 .596 L
.29861 .5966 L
.29982 .59717 L
.30101 .59774 L
.30229 .57049 L
.30299 .57049 L
.30365 .57049 L
.30489 .57049 L
.30556 .57049 L
.30626 .57049 L
.30752 .57049 L
.30823 .57049 L
.30888 .57049 L
.30961 .57049 L
.31039 .57049 L
.31159 .57049 L
.31292 .57049 L
.31358 .57049 L
.3143 .57049 L
.31558 .57049 L
.31686 .57049 L
.31807 .57049 L
.31916 .57049 L
.32034 .57049 L
.32151 .57049 L
.32277 .57049 L
.32396 .57049 L
.32504 .57049 L
.32626 .57049 L
.32741 .57049 L
.32866 .57049 L
Mistroke
.32937 .57049 L
.33002 .57049 L
.33119 .57049 L
.33229 .57049 L
.33328 .57049 L
.33435 .57049 L
.33551 .57049 L
.33674 .57049 L
.3378 .57049 L
.33895 .57049 L
.34026 .57049 L
.34147 .57049 L
.3421 .57049 L
.3428 .57049 L
.34352 .57049 L
.34421 .57049 L
.34546 .57049 L
.3466 .57049 L
.34786 .57049 L
.34918 .57049 L
.3503 .57049 L
.35149 .57049 L
.35261 .57049 L
.35363 .57049 L
.35483 .57049 L
.35614 .57049 L
.35736 .57049 L
.3585 .57049 L
.35971 .57049 L
.361 .57049 L
.36223 .57049 L
.36334 .57049 L
.36465 .57049 L
.36539 .57049 L
.36608 .57049 L
.36733 .57049 L
.36797 .57049 L
.36867 .57049 L
.36935 .57049 L
.37006 .57049 L
.37134 .57049 L
.37206 .57049 L
.37283 .57049 L
.37355 .57049 L
.37421 .57049 L
.37549 .57049 L
.3767 .57049 L
.37801 .57049 L
.37874 .57049 L
.37942 .57049 L
Mistroke
.38067 .57049 L
.38186 .57049 L
.38293 .57049 L
.38409 .57049 L
.38535 .57049 L
.38605 .57049 L
.38669 .57049 L
.3891 .57049 L
.39019 .57049 L
.39134 .57049 L
.39261 .57049 L
.39377 .57049 L
.39485 .57049 L
.39587 .57049 L
.39698 .57049 L
.39816 .57049 L
.39883 .57049 L
.39954 .57049 L
.40082 .57049 L
.40153 .57049 L
.40219 .57049 L
.40292 .57049 L
.40371 .57049 L
.40435 .57049 L
.40504 .57049 L
.40577 .57049 L
.40645 .57049 L
.40774 .57049 L
.40896 .57049 L
.41015 .57049 L
.41145 .57049 L
.41263 .57049 L
.41372 .57049 L
.41489 .57049 L
.41618 .57049 L
.41683 .57049 L
.41753 .57049 L
.4188 .57049 L
.41948 .57049 L
.42013 .57049 L
.42135 .57049 L
.42265 .57049 L
.42338 .57049 L
.42406 .57049 L
.42519 .57049 L
.42643 .57049 L
.42773 .57049 L
.42894 .57049 L
.42962 .57049 L
.43037 .57049 L
Mistroke
.43108 .57049 L
.43173 .57049 L
.43296 .57049 L
.43427 .57049 L
.43495 .57049 L
.43568 .57049 L
.43699 .57049 L
.43779 .57049 L
.43855 .57049 L
.43924 .57049 L
.43999 .57049 L
.44064 .57049 L
.44135 .57049 L
.44263 .57049 L
.44388 .57049 L
.44503 .57049 L
.44627 .57049 L
.44696 .57049 L
.44759 .57049 L
.44834 .57049 L
.44905 .57049 L
.4497 .57049 L
.45041 .57049 L
.4516 .57049 L
.45285 .57049 L
.45394 .57049 L
.45512 .57049 L
.45634 .57049 L
.45748 .57049 L
.45814 .57049 L
.45884 .57049 L
.46009 .57049 L
.46132 .57049 L
.46202 .57049 L
.46266 .57049 L
.46384 .57049 L
.46509 .57049 L
.46621 .57049 L
.46725 .57049 L
.46839 .57049 L
.46963 .57049 L
.47095 .57049 L
.4722 .57049 L
.47341 .57049 L
.47454 .57049 L
.47523 .57049 L
.47589 .57049 L
.4771 .57049 L
.47841 .57049 L
.47915 .57049 L
Mistroke
.47982 .57049 L
.48089 .57049 L
.48203 .57049 L
.48311 .57049 L
.48409 .57049 L
.48524 .57049 L
.48649 .57049 L
.48766 .57049 L
.48876 .57049 L
.48989 .57049 L
.49114 .57049 L
.49235 .57049 L
.49366 .57049 L
.49481 .57049 L
.49602 .57049 L
.49706 .57049 L
.49819 .57049 L
.49942 .57049 L
.50073 .57049 L
.50141 .57049 L
.50217 .57049 L
.50349 .57049 L
.50473 .57049 L
.50543 .57049 L
.50607 .57049 L
.50731 .57049 L
.50848 .57049 L
.50961 .57049 L
.51081 .57049 L
.51183 .57049 L
.51296 .57049 L
.51416 .57049 L
.51547 .57049 L
.5167 .57049 L
.51783 .57049 L
.51905 .57049 L
.52035 .57049 L
.52158 .57049 L
.5227 .57049 L
.52401 .57049 L
.52476 .57049 L
.52544 .57049 L
.5267 .57049 L
.52733 .57049 L
.52803 .57049 L
.52875 .57049 L
.52943 .57049 L
.53071 .57049 L
.53142 .57049 L
.53208 .57049 L
Mistroke
.53281 .57049 L
.53359 .57049 L
.53426 .57049 L
.53499 .57049 L
.53568 .57049 L
.53632 .57049 L
.53752 .57049 L
.53879 .57049 L
.54001 .57049 L
.5407 .57049 L
.54134 .57049 L
.54251 .57049 L
.54375 .57049 L
.54486 .57049 L
.5459 .57049 L
.54704 .57049 L
.54827 .57049 L
.5495 .57049 L
.5502 .57049 L
.55085 .57049 L
.55217 .57049 L
.5529 .57049 L
.55357 .57049 L
.55477 .57049 L
.55607 .57049 L
.5573 .57049 L
.55843 .57049 L
.55948 .57049 L
.56048 .57049 L
.56163 .57049 L
.56267 .57049 L
.56383 .57049 L
.56508 .57049 L
.56625 .57049 L
.56734 .57049 L
.56857 .57049 L
.56974 .57049 L
.57078 .57049 L
.57191 .57049 L
.57314 .57049 L
.57444 .57049 L
.57555 .57049 L
.57677 .57049 L
.57929 .57049 L
.57998 .57049 L
.58062 .57049 L
.58129 .57049 L
.58203 .57049 L
.58461 .57049 L
.587 .57049 L
Mistroke
.59632 .57049 L
.61725 .57049 L
.656 .57049 L
.6972 .57049 L
.73688 .57049 L
.77505 .57049 L
.81567 .57049 L
.85478 .57049 L
.89633 .57049 L
.93638 .57049 L
.9749 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool01`1Vo`03000006Ko06Ko00L0I_l00`00001Vo`1Vo`04
06Ko1?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooo000000`00005<ol000<0000co`0co`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0007
<ol000<0000co`0co`0023?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`0Boooo000Xoooo00<0003oooooool06?ooo`H0I_l8oooo00<0003oooooool01ooo
o`0306Kooooooooo01Ooool60000:C?o00030000oooooooo02Koool00`000?ooooooo`0Voooo00<0
003oooooool09oooo`00BOooo`D0I_l=oooo00<0I_ooooooool07?ooo`<0000W<ol000<0003ooooo
ool0NOooo`00C_ooo`D0I_l8oooo00<0I_ooooooool07oooo`80000U<ol000<0003oooooool0NOoo
o`00Doooo`@0I_l4oooo00<0I_ooooooool08Oooo`030000<ol0<ol0028co`020000N_ooo`00Eooo
o`80I_l2oooo00<0I_ooooooool08_ooo`030000<ol0<ol0024co`000`000?ooooooo`1ioooo001I
oooo0`1VobGoool200008C?o00030000oooooooo07Woool005_oool00ol0VOooooooo`0Uoooo00<0
000co`0co`007S?o00030000oooooooo07Woool005_oool00ol0VOooooooo`0Uoooo00<0000co`0c
o`007S?o00030000oooooooo07Woool005_oool00ol0VOooooooo`0Voooo00<0000co`0co`007C?o
0080001joooo001Koooo00?o09Woooooool09oooo`030000<ol0<ol001`co`000`000?ooooooo`1i
oooo001Koooo00?o09Woooooool0:?ooo`030000<ol0<ol001/co`000`000?ooooooo`1ioooo001K
oooo00?o09Woooooool0:?ooo`030000<ol0<ol001/co`000`000?ooooooo`1ioooo0027oooo7C?o
07coool008SooolL<ol0O?ooo`00R?oooa`co`1loooo0028oooo73?o07coool008WooolK<ol0O?oo
o`00NOooo`030000oooooooo00gooolK<ol000<0003oooooool0NOooo`00N?ooo`030000oooooooo
00Soool00`000?ooooooo`04oooo6S?o0003oooo0000oooo07Woool007Soool00`000?ooooooo`02
oooo0P0000Coool00`000?ooooooo`04oooo23?o00@00003<ol00P0000@co`0200000c?o0003oooo
0000oooo07Woool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Coool400000c?o00030000<ol0<ol000Tco`00100003?o03?o0000008co`000oooo`00
0?ooo`1ioooo001goooo00<0003oooooool00_ooo`030000oooooooo00coool8<ol000<0000co`0c
o`002c?o00030000<ol0<ol000;oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@00
00_oool9<ol000<0000co`0co`0023?o00800003<ol000?oool0003oool0NOooo`00N?ooo`050000
oooooooooooo000000ooool6<ol000@0000co`0co`000009<ol000<0000co`0co`000S?o0003oooo
0000oooo07Woool007Woool00`000?ooooooo`0@oooo1c?o0080000:<ol00`00008co`000`000?oo
ooooo`1ioooo002<oooo63?o07coool008cooolH<ol0O?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.28158 .57049 L
.30316 .57049 L
.31323 .57049 L
.32392 .57049 L
.33304 .57049 L
.33554 .57049 L
.33823 .57049 L
.33953 .57049 L
.34076 .57049 L
s
.34076 .57049 m
.34077 .61803 L
s
0 .4 1 r
.02381 .57059 m
.04262 .57063 L
.06244 .57068 L
.07286 .57072 L
.08255 .57077 L
.09388 .57083 L
.10458 .5709 L
.125 .57107 L
.14357 .5713 L
.16355 .57165 L
.18199 .5721 L
.20071 .57274 L
.21136 .5732 L
.22134 .57373 L
.24158 .57514 L
.26011 .57696 L
.27909 .57956 L
.28984 .58147 L
.29982 .58361 L
.32034 .5894 L
.32939 .59271 L
.33433 .59476 L
.33895 .59684 L
.34013 .5974 L
.34125 .59794 L
.34255 .57049 L
.34373 .57049 L
.34503 .57049 L
.34624 .57049 L
.34687 .57049 L
.34756 .57049 L
.34829 .57049 L
.34897 .57049 L
.3501 .57049 L
.35129 .57049 L
.3523 .57049 L
.35341 .57049 L
.35461 .57049 L
.35589 .57049 L
.3571 .57049 L
.35819 .57049 L
.35949 .57049 L
.36015 .57049 L
.36087 .57049 L
.36214 .57049 L
.36333 .57049 L
.36405 .57049 L
.36474 .57049 L
.36602 .57049 L
.36674 .57049 L
Mistroke
.3674 .57049 L
.36813 .57049 L
.3689 .57049 L
.37022 .57049 L
.37096 .57049 L
.37164 .57049 L
.37289 .57049 L
.37421 .57049 L
.3754 .57049 L
.3765 .57049 L
.37772 .57049 L
.37901 .57049 L
.38024 .57049 L
.38093 .57049 L
.38159 .57049 L
.3829 .57049 L
.38364 .57049 L
.38432 .57049 L
.38546 .57049 L
.3867 .57049 L
.388 .57049 L
.38921 .57049 L
.38991 .57049 L
.39066 .57049 L
.39137 .57049 L
.39202 .57049 L
.39326 .57049 L
.39458 .57049 L
.39525 .57049 L
.39598 .57049 L
.3973 .57049 L
.3981 .57049 L
.39887 .57049 L
.39955 .57049 L
.40029 .57049 L
.40154 .57049 L
.4027 .57049 L
.40398 .57049 L
.4047 .57049 L
.40536 .57049 L
.40661 .57049 L
.40732 .57049 L
.40798 .57049 L
.40868 .57049 L
.40932 .57049 L
.41001 .57049 L
.41075 .57049 L
.41199 .57049 L
.41314 .57049 L
.41437 .57049 L
Mistroke
.41507 .57049 L
.41573 .57049 L
.41691 .57049 L
.41799 .57049 L
.41916 .57049 L
.42043 .57049 L
.42172 .57049 L
.42293 .57049 L
.42411 .57049 L
.4252 .57049 L
.42638 .57049 L
.42767 .57049 L
.42832 .57049 L
.42902 .57049 L
.43028 .57049 L
.43146 .57049 L
.43274 .57049 L
.43395 .57049 L
.43507 .57049 L
.43607 .57049 L
.43718 .57049 L
.43834 .57049 L
.43943 .57049 L
.44074 .57049 L
.44196 .57049 L
.44324 .57049 L
.44391 .57049 L
.44463 .57049 L
.44592 .57049 L
.44713 .57049 L
.44822 .57049 L
.44941 .57049 L
.45071 .57049 L
.45142 .57049 L
.45209 .57049 L
.45328 .57049 L
.45457 .57049 L
.45528 .57049 L
.45606 .57049 L
.4568 .57049 L
.45749 .57049 L
.45878 .57049 L
.4595 .57049 L
.46016 .57049 L
.46137 .57049 L
.46249 .57049 L
.46373 .57049 L
.46442 .57049 L
.46505 .57049 L
.46633 .57049 L
Mistroke
.46704 .57049 L
.46771 .57049 L
.46892 .57049 L
.47022 .57049 L
.47131 .57049 L
.47249 .57049 L
.4736 .57049 L
.47461 .57049 L
.4758 .57049 L
.4771 .57049 L
.47832 .57049 L
.47946 .57049 L
.48076 .57049 L
.4815 .57049 L
.48218 .57049 L
.48343 .57049 L
.48474 .57049 L
.48593 .57049 L
.48703 .57049 L
.48824 .57049 L
.48954 .57049 L
.49021 .57049 L
.49092 .57049 L
.49171 .57049 L
.49243 .57049 L
.49373 .57049 L
.49447 .57049 L
.49517 .57049 L
.49645 .57049 L
.49763 .57049 L
.49893 .57049 L
.49958 .57049 L
.50029 .57049 L
.50161 .57049 L
.50283 .57049 L
.50346 .57049 L
.50416 .57049 L
.50489 .57049 L
.50558 .57049 L
.50683 .57049 L
.50798 .57049 L
.50861 .57049 L
.5093 .57049 L
.51056 .57049 L
.51179 .57049 L
.51291 .57049 L
.51419 .57049 L
.51541 .57049 L
.51653 .57049 L
.51756 .57049 L
Mistroke
.5187 .57049 L
.5199 .57049 L
.5212 .57049 L
.52239 .57049 L
.52305 .57049 L
.52377 .57049 L
.52507 .57049 L
.52989 .57049 L
.53057 .57049 L
.53131 .57049 L
.53196 .57049 L
.53265 .57049 L
.53338 .57049 L
.53404 .57049 L
.53478 .57049 L
.53558 .57049 L
.5369 .57049 L
.53764 .57049 L
.53831 .57049 L
.53961 .57049 L
.54084 .57049 L
.542 .57049 L
.54324 .57049 L
.54441 .57049 L
.54548 .57049 L
.54674 .57049 L
.54745 .57049 L
.5481 .57049 L
.54931 .57049 L
.55058 .57049 L
.5518 .57049 L
.55311 .57049 L
.55434 .57049 L
.55548 .57049 L
.55674 .57049 L
.55745 .57049 L
.55811 .57049 L
.55881 .57049 L
.55945 .57049 L
.56019 .57049 L
.56089 .57049 L
.56195 .57049 L
.56312 .57049 L
.56435 .57049 L
.56549 .57049 L
.56656 .57049 L
.56754 .57049 L
.56867 .57049 L
.56974 .57049 L
.57089 .57049 L
Mistroke
.57212 .57049 L
.57328 .57049 L
.57434 .57049 L
.57558 .57049 L
.57627 .57049 L
.57692 .57049 L
.5781 .57049 L
.57935 .57049 L
.58057 .57049 L
.5819 .57049 L
.58431 .57049 L
.58883 .57049 L
.59899 .57049 L
.61733 .57049 L
.65812 .57049 L
.69739 .57049 L
.73515 .57049 L
.77536 .57049 L
.81406 .57049 L
.8552 .57049 L
.89484 .57049 L
.93295 .57049 L
.97352 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00L0I_l00`00001Vo`1Vo`08
06Ko00<00000I_l0I_l0101Vo`?oool00`000?ooooooo`07oooo00<0003oooooool01oooo`03o`2I
0000oooo00d00005<ol000<0000co`0co`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0007
<ol000<0000co`0co`0023?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`0Boooo000Xoooo00<0003oooooool08oooo`<0I_l00`00001Vooooo`0Aoooo00?o
09T0I_ooool03Oooo`H0000Y<ol000<0003oooooool09_ooo`030000oooooooo02Koool00`000?oo
ooooo`0Woooo001Coooo1`1Vo`_oool00ol0V@1Vooooo`0Boooo0`0002Lco`000`000?ooooooo`1i
oooo001Joooo101Vo`Ooool00ol0V@1Vooooo`0Eoooo0P0002Dco`000`000?ooooooo`1ioooo001N
oooo0`1Vo`Coool00ol0V@1Vooooo`0Goooo00<0000co`0co`008S?o0080001joooo001Qoooo0P1V
o`;oool00ol0V@1Vooooo`0Hoooo00<0000co`0co`008C?o00030000oooooooo07Woool006?oool4
06Ko6_ooo`80000Q<ol000<0003oooooool0NOooo`00IOooo`03o`2Ioooooooo01_oool00`0003?o
03?o000N<ol000<0003oooooool0NOooo`00IOooo`03o`2Ioooooooo01_oool00`0003?o03?o000N
<ol000<0003oooooool0NOooo`00IOooo`03o`2Ioooooooo01coool00`0003?o03?o000M<ol00P00
07[oool006Goool00ol0VOooooooo`0Moooo00<0000co`0co`0073?o00030000oooooooo07Woool0
06Goool00ol0VOooooooo`0Noooo00<0000co`0co`006c?o00030000oooooooo07Woool006Goool0
0ol0VOooooooo`0Noooo00<0000co`0co`006c?o00030000oooooooo07Woool008OooolM<ol0O?oo
o`00R?oooa`co`1loooo0028oooo73?o07coool008SooolL<ol0O?ooo`00ROoooa/co`1loooo001l
oooo00<0003oooooool02_oooaPco`000`0003?o03?o001loooo001koooo00<0003oooooool02?oo
o`040000oooooooooooo63?o00030000<ol0oooo07_oool007_oool00`000?ooooooo`02oooo0P00
00Coool010000?ooooooooooo`/co`0400000c?o00800004<ol000<0000co`3oool0Noooo`00Nooo
o`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00@0003oooooooooool3<ol01000
00<co`000`0003?o03?o000:<ol000<0000co`3oool0Noooo`00N_ooo`030000oooooooo00;oool0
0`000?ooooooo`09oooo2c?o00030000<ol0<ol000Xco`000`000?ooooooo`1joooo001koooo00<0
003oooooool01@0000Soool<<ol000<0000co`0co`0023?o00030000<ol0oooo07_oool007_oool0
1@000?ooooooooooo`00000<oooo2C?o00040000<ol0<ol000002C?o00030000<ol0oooo07_oool0
07coool00`000?ooooooo`0=oooo2S?o00800009<ol000<0000co`0co`00O?ooo`00S?oooaPco`1l
oooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.32392 .57049 L
.34309 .57049 L
.36173 .57049 L
.37114 .57049 L
.37372 .57049 L
.37649 .57049 L
.37783 .57049 L
.3791 .57049 L
.38025 .57049 L
s
.38025 .57049 m
.38026 .61803 L
s
0 .4 1 r
.02381 .57054 m
.04262 .57056 L
.06244 .57059 L
.07286 .57061 L
.08255 .57063 L
.09388 .57066 L
.10458 .57069 L
.125 .57078 L
.14357 .57089 L
.16355 .57106 L
.18199 .57128 L
.20071 .57159 L
.21136 .57182 L
.22134 .57207 L
.24158 .57276 L
.26011 .57365 L
.27909 .57491 L
.28984 .57585 L
.29982 .57689 L
.32034 .57971 L
.33895 .58334 L
.35819 .5886 L
.36904 .59246 L
.37385 .59442 L
.3765 .59558 L
.37781 .59617 L
.37901 .59673 L
.3802 .59729 L
.38145 .57049 L
.38271 .57049 L
.38344 .57049 L
.38411 .57049 L
.38526 .57049 L
.3865 .57049 L
.3876 .57049 L
.38875 .57049 L
.38984 .57049 L
.391 .57049 L
.392 .57049 L
.39309 .57049 L
.39437 .57049 L
.39558 .57049 L
.39675 .57049 L
.39784 .57049 L
.39903 .57049 L
.40031 .57049 L
.40152 .57049 L
.40262 .57049 L
.40391 .57049 L
.40464 .57049 L
Mistroke
.40532 .57049 L
.40656 .57049 L
.40788 .57049 L
.40855 .57049 L
.40926 .57049 L
.41003 .57049 L
.41075 .57049 L
.41204 .57049 L
.41277 .57049 L
.41345 .57049 L
.41473 .57049 L
.41589 .57049 L
.41654 .57049 L
.41724 .57049 L
.4185 .57049 L
.4197 .57049 L
.4208 .57049 L
.42203 .57049 L
.42332 .57049 L
.42451 .57049 L
.42577 .57049 L
.4265 .57049 L
.42715 .57049 L
.42844 .57049 L
.42962 .57049 L
.43071 .57049 L
.43191 .57049 L
.43317 .57049 L
.43427 .57049 L
.43529 .57049 L
.43642 .57049 L
.43762 .57049 L
.4383 .57049 L
.43901 .57049 L
.44029 .57049 L
.44101 .57049 L
.44168 .57049 L
.44241 .57049 L
.4432 .57049 L
.44385 .57049 L
.44453 .57049 L
.44577 .57049 L
.44707 .57049 L
.44775 .57049 L
.44849 .57049 L
.44921 .57049 L
.44988 .57049 L
.45119 .57049 L
.45239 .57049 L
.45366 .57049 L
Mistroke
.45482 .57049 L
.45591 .57049 L
.45711 .57049 L
.4584 .57049 L
.45909 .57049 L
.45973 .57049 L
.46094 .57049 L
.46224 .57049 L
.46297 .57049 L
.46365 .57049 L
.46477 .57049 L
.46601 .57049 L
.46731 .57049 L
.46851 .57049 L
.4692 .57049 L
.46995 .57049 L
.47065 .57049 L
.4713 .57049 L
.47253 .57049 L
.47384 .57049 L
.47452 .57049 L
.47524 .57049 L
.47655 .57049 L
.47732 .57049 L
.47812 .57049 L
.4788 .57049 L
.47955 .57049 L
.4802 .57049 L
.48091 .57049 L
.48219 .57049 L
.48344 .57049 L
.48458 .57049 L
.48583 .57049 L
.48654 .57049 L
.4872 .57049 L
.48789 .57049 L
.48863 .57049 L
.48931 .57049 L
.48996 .57049 L
.49113 .57049 L
.49237 .57049 L
.49354 .57049 L
.49459 .57049 L
.49585 .57049 L
.49655 .57049 L
.4972 .57049 L
.49839 .57049 L
.49964 .57049 L
.5022 .57049 L
.50346 .57049 L
Mistroke
.50462 .57049 L
.50568 .57049 L
.5068 .57049 L
.50792 .57049 L
.50916 .57049 L
.51048 .57049 L
.51169 .57049 L
.51236 .57049 L
.51308 .57049 L
.51377 .57049 L
.51441 .57049 L
.51566 .57049 L
.51679 .57049 L
.5181 .57049 L
.51934 .57049 L
.5204 .57049 L
.52157 .57049 L
.52279 .57049 L
.52393 .57049 L
.52499 .57049 L
.52596 .57049 L
.52709 .57049 L
.52815 .57049 L
.5293 .57049 L
.53052 .57049 L
.53157 .57049 L
.53272 .57049 L
.53395 .57049 L
.53464 .57049 L
.53528 .57049 L
.53645 .57049 L
.53769 .57049 L
.53892 .57049 L
.53962 .57049 L
.54026 .57049 L
.54144 .57049 L
.54268 .57049 L
.5438 .57049 L
.54485 .57049 L
.54599 .57049 L
.54723 .57049 L
.54853 .57049 L
.54927 .57049 L
.54996 .57049 L
.55121 .57049 L
.55192 .57049 L
.55255 .57049 L
.55376 .57049 L
.55506 .57049 L
.55629 .57049 L
Mistroke
.55742 .57049 L
.55848 .57049 L
.55962 .57049 L
.5607 .57049 L
.56168 .57049 L
.56283 .57049 L
.56408 .57049 L
.56526 .57049 L
.56635 .57049 L
.56748 .57049 L
.56853 .57049 L
.56968 .57049 L
.57093 .57049 L
.57216 .57049 L
.57346 .57049 L
.57457 .57049 L
.57578 .57049 L
.57643 .57049 L
.57711 .57049 L
.57833 .57049 L
.57964 .57049 L
.58039 .57049 L
.58108 .57049 L
.58608 .57049 L
.59542 .57049 L
.61638 .57049 L
.65525 .57049 L
.69656 .57049 L
.73637 .57049 L
.77465 .57049 L
.81539 .57049 L
.85461 .57049 L
.89232 .57049 L
.93247 .57049 L
.97112 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
06Ko00<00000I_l0I_l01`1Vo`03000006Ko06Ko00<0I_l4oooo00<0003oooooool02?ooo`030000
oooo000000`00005<ol000<0000co`0co`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0007
<ol000<0000co`0co`0023?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`0Boooo000Xoooo00<0003oooooool09_ooo`030000oooooooo00?oool706Ko4_oo
o`0306Kooooooooo00;oool60000:C?o00030000oooooooo02Koool00`000?ooooooo`0Voooo00<0
003oooooool09oooo`00G_ooo`D0I_l=oooo00<0I_ooooooool01oooo`<0000W<ol000<0003ooooo
ool0NOooo`00Hoooo`D0I_l8oooo00<0I_ooooooool02_ooo`80000U<ol000<0003oooooool0NOoo
o`00J?ooo`@0I_l4oooo00<0I_ooooooool03?ooo`030000<ol0<ol0028co`020000N_ooo`00K?oo
o`80I_l2oooo00<0I_ooooooool03Oooo`030000<ol0<ol0024co`000`000?ooooooo`1ioooo001^
oooo0`1Voa3oool200008C?o00030000oooooooo07Woool0073oool00ol0VOooooooo`0@oooo00<0
000co`0co`007S?o00030000oooooooo07Woool0073oool00ol0VOooooooo`0@oooo00<0000co`0c
o`007S?o00030000oooooooo07Woool0073oool00ol0VOooooooo`0Aoooo00<0000co`0co`007C?o
0080001joooo001`oooo00?o09Woooooool04_ooo`030000<ol0<ol001`co`000`000?ooooooo`1i
oooo001`oooo00?o09Woooooool04oooo`030000<ol0<ol001/co`000`000?ooooooo`1ioooo001`
oooo00?o09Woooooool04oooo`030000<ol0<ol001/co`000`000?ooooooo`1ioooo0027oooo7C?o
07coool008SooolL<ol0O?ooo`00R?oooa`co`1loooo0028oooo73?o07coool008WooolK<ol0O?oo
o`00NOooo`030000oooooooo00gooolK<ol000<0003oooooool0NOooo`00N?ooo`030000oooooooo
00Soool00`000?ooooooo`04oooo6S?o0003oooo0000oooo07Woool007Soool00`000?ooooooo`02
oooo0P0000Coool00`000?ooooooo`04oooo23?o00D00002<ol00P0000@co`0200000c?o0003oooo
0000oooo07Woool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Coool400001C?o00030000<ol0<ol000Lco`00100003?o03?o0000008co`000oooo`00
0?ooo`1ioooo001goooo00<0003oooooool00_ooo`030000oooooooo00coool9<ol000<0000co`0c
o`002S?o00030000<ol0<ol000;oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@00
00_oool9<ol000<0000co`0co`0023?o00800003<ol000?oool0003oool0NOooo`00N?ooo`050000
oooooooooooo000000ooool8<ol000<0000co`0co`0023?o00030000<ol0<ol0008co`000oooo`00
0?ooo`1ioooo001ioooo00<0003oooooool04?ooo`Lco`0200002S?o00<00002<ol000<0003ooooo
ool0NOooo`00S?oooaPco`1loooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.40134 .57049 L
.41134 .57049 L
.41408 .57049 L
.41703 .57049 L
.41846 .57049 L
.41917 .57049 L
.41982 .57049 L
s
.41982 .57049 m
.41982 .61803 L
s
0 .4 1 r
.02381 .57051 m
.04262 .57052 L
.06244 .57054 L
.07286 .57055 L
.08255 .57056 L
.09388 .57057 L
.10458 .57059 L
.125 .57063 L
.14357 .57068 L
.16355 .57076 L
.18199 .57086 L
.20071 .57101 L
.21136 .57112 L
.22134 .57124 L
.24158 .57156 L
.26011 .57198 L
.27909 .57257 L
.28984 .57301 L
.29982 .5735 L
.32034 .57483 L
.33895 .57654 L
.35819 .57901 L
.36904 .58083 L
.37901 .58284 L
.39784 .58777 L
.40853 .59139 L
.41371 .59342 L
.41599 .59437 L
.41728 .59493 L
.4185 .59546 L
.41967 .59599 L
.42093 .57049 L
.42158 .57049 L
.42227 .57049 L
.42351 .57049 L
.42416 .57049 L
.42485 .57049 L
.42611 .57049 L
.42688 .57049 L
.4276 .57049 L
.42825 .57049 L
.42895 .57049 L
.43014 .57049 L
.43146 .57049 L
.43212 .57049 L
.43282 .57049 L
.4341 .57049 L
.43538 .57049 L
.43659 .57049 L
.43767 .57049 L
Mistroke
.43885 .57049 L
.44011 .57049 L
.4413 .57049 L
.44237 .57049 L
.44352 .57049 L
.44478 .57049 L
.44541 .57049 L
.44611 .57049 L
.44734 .57049 L
.44848 .57049 L
.44964 .57049 L
.45074 .57049 L
.45172 .57049 L
.45279 .57049 L
.45396 .57049 L
.45519 .57049 L
.45625 .57049 L
.45741 .57049 L
.45863 .57049 L
.45977 .57049 L
.46101 .57049 L
.46171 .57049 L
.46234 .57049 L
.46363 .57049 L
.46435 .57049 L
.46501 .57049 L
.46624 .57049 L
.46753 .57049 L
.46863 .57049 L
.46981 .57049 L
.47093 .57049 L
.47195 .57049 L
.47314 .57049 L
.47444 .57049 L
.47566 .57049 L
.4768 .57049 L
.47799 .57049 L
.47927 .57049 L
.48049 .57049 L
.4816 .57049 L
.48284 .57049 L
.48354 .57049 L
.48419 .57049 L
.4855 .57049 L
.48624 .57049 L
.48691 .57049 L
.48758 .57049 L
.48829 .57049 L
.48956 .57049 L
.49027 .57049 L
Mistroke
.49093 .57049 L
.49166 .57049 L
.49244 .57049 L
.49311 .57049 L
.49384 .57049 L
.49453 .57049 L
.49517 .57049 L
.49638 .57049 L
.49767 .57049 L
.49902 .57049 L
.50027 .57049 L
.50159 .57049 L
.50228 .57049 L
.50303 .57049 L
.50366 .57049 L
.50435 .57049 L
.50561 .57049 L
.50683 .57049 L
.50796 .57049 L
.5086 .57049 L
.50929 .57049 L
.51053 .57049 L
.51125 .57049 L
.51201 .57049 L
.51265 .57049 L
.51336 .57049 L
.5141 .57049 L
.5148 .57049 L
.5156 .57049 L
.51633 .57049 L
.51702 .57049 L
.51766 .57049 L
.51835 .57049 L
.51909 .57049 L
.52034 .57049 L
.52149 .57049 L
.52281 .57049 L
.52406 .57049 L
.52514 .57049 L
.52628 .57049 L
.52754 .57049 L
.5287 .57049 L
.52942 .57049 L
.53008 .57049 L
.53078 .57049 L
.53156 .57049 L
.53287 .57049 L
.53358 .57049 L
.53425 .57049 L
.53552 .57049 L
Mistroke
.53667 .57049 L
.53731 .57049 L
.53801 .57049 L
.53927 .57049 L
.54038 .57049 L
.5416 .57049 L
.54275 .57049 L
.54381 .57049 L
.54505 .57049 L
.54637 .57049 L
.54759 .57049 L
.5487 .57049 L
.54939 .57049 L
.55003 .57049 L
.55073 .57049 L
.55146 .57049 L
.5527 .57049 L
.55341 .57049 L
.55407 .57049 L
.55534 .57049 L
.55649 .57049 L
.55713 .57049 L
.55783 .57049 L
.5591 .57049 L
.56031 .57049 L
.56161 .57049 L
.56236 .57049 L
.56304 .57049 L
.5637 .57049 L
.56439 .57049 L
.56506 .57049 L
.56578 .57049 L
.56708 .57049 L
.56776 .57049 L
.56849 .57049 L
.56928 .57049 L
.57002 .57049 L
.57131 .57049 L
.57205 .57049 L
.57274 .57049 L
.57398 .57049 L
.57467 .57049 L
.57531 .57049 L
.57649 .57049 L
.57778 .57049 L
.57899 .57049 L
.58012 .57049 L
.58141 .57049 L
.58277 .57049 L
.58521 .57049 L
Mistroke
.59071 .57049 L
.60068 .57049 L
.61929 .57049 L
.6573 .57049 L
.69777 .57049 L
.73672 .57049 L
.77812 .57049 L
.818 .57049 L
.85637 .57049 L
.89719 .57049 L
.9365 .57049 L
.97429 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oool0I_l01`1Vo`03000006Ko06Ko00L0I_l00`00001Vo`1Vo`0506Ko0oooo`030000
oooo000000`00005<ol000<0000co`0co`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0007
<ol000<0000co`0co`0023?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`0Boooo000Xoooo00<0003oooooool09_ooo`030000oooooooo00ooool506Ko3Ooo
o`H0000Y<ol000<0003oooooool09_ooo`030000oooooooo02Koool00`000?ooooooo`0Woooo001X
oooo1P1Vo`coool00`1Vo`000000000W<ol000<0003oooooool0NOooo`00K_ooo`@0I_l8oooo00<0
I_ooooooool00P0002Dco`000`000?ooooooo`1ioooo001boooo101Vo`Coool00`1Vooooooooo`02
oooo00<0000co`0co`008S?o0080001joooo001foooo0`1Vo`03oooo06Kooooo00Coool00`0003?o
03?o000Q<ol000<0003oooooool0NOooo`00NOooo`80I_l6oooo0P00024co`000`000?ooooooo`1i
oooo001joooo00?o09Woooooool01_ooo`030000<ol0<ol001hco`000`000?ooooooo`1ioooo001j
oooo00?o09Woooooool01_ooo`030000<ol0<ol001hco`000`000?ooooooo`1ioooo001joooo00?o
09Woooooool01oooo`030000<ol0<ol001dco`020000N_ooo`00N_ooo`03o`2Ioooooooo00Soool0
0`0003?o03?o000L<ol000<0003oooooool0NOooo`00N_ooo`03o`2Ioooooooo00Woool00`0003?o
03?o000K<ol000<0003oooooool0NOooo`00N_ooo`03o`2Ioooooooo00Woool00`0003?o03?o000K
<ol000<0003oooooool0NOooo`00Qooooadco`1loooo0028oooo73?o07coool008SooolL<ol0O?oo
o`00R?oooa`co`1loooo0029oooo6c?o07coool007coool00`000?ooooooo`0:oooo63?o00030000
<ol0<ol007coool007_oool00`000?ooooooo`08oooo00@0003ooooooooooolH<ol000<0000co`3o
ool0Noooo`00Noooo`030000oooooooo00;oool200001?ooo`040000oooooooooooo2c?o00D00002
<ol00P0000@co`000`0003?o0?ooo`1koooo001koooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool010000?ooooooooooo`<co`0400001C?o00030000<ol0<ol000Pco`000`0003?o
0?ooo`1koooo001joooo00<0003oooooool00_ooo`030000oooooooo00Woool<<ol000<0000co`0c
o`002C?o00030000oooooooo07[oool007_oool00`000?ooooooo`0500002?ooo``co`000`0003?o
03?o0008<ol000<0000co`3oool0Noooo`00Noooo`050000oooooooooooo000000coool;<ol000<0
000co`0co`0023?o00030000<ol0oooo07_oool007coool00`000?ooooooo`0=oooo2S?o00800009
<ol000<0000co`0co`00O?ooo`00S?oooaPco`1loooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.40095 .57049 L
.42237 .57049 L
.43215 .57049 L
.44268 .57049 L
.44778 .57049 L
.45262 .57049 L
.45697 .57049 L
.45816 .57049 L
.45943 .57049 L
s
.45943 .57049 m
.45944 .61803 L
s
0 .4 1 r
.02381 .5705 m
.04262 .57051 L
.06244 .57051 L
.07286 .57051 L
.08255 .57052 L
.09388 .57052 L
.10458 .57053 L
.125 .57055 L
.14357 .57057 L
.16355 .5706 L
.18199 .57064 L
.20071 .5707 L
.21136 .57074 L
.22134 .57079 L
.24158 .57092 L
.26011 .57108 L
.27909 .57132 L
.28984 .57149 L
.29982 .57169 L
.32034 .57221 L
.33895 .57289 L
.35819 .57387 L
.36904 .57459 L
.37901 .57539 L
.39784 .57734 L
.40853 .57878 L
.4185 .5804 L
.43885 .58474 L
.44785 .58722 L
.45278 .58876 L
.45741 .59034 L
.45851 .59073 L
.45968 .59116 L
.46095 .57049 L
.46212 .57049 L
.46341 .57049 L
.46461 .57049 L
.46592 .57049 L
.46666 .57049 L
.46732 .57049 L
.4685 .57049 L
.46959 .57049 L
.47076 .57049 L
.47204 .57049 L
.47316 .57049 L
.4742 .57049 L
.47531 .57049 L
.4765 .57049 L
.47716 .57049 L
.47788 .57049 L
Mistroke
.47916 .57049 L
.47994 .57049 L
.48068 .57049 L
.48135 .57049 L
.48206 .57049 L
.48269 .57049 L
.48338 .57049 L
.4846 .57049 L
.48529 .57049 L
.48602 .57049 L
.48671 .57049 L
.48734 .57049 L
.48861 .57049 L
.48978 .57049 L
.49107 .57049 L
.49172 .57049 L
.49244 .57049 L
.49363 .57049 L
.49492 .57049 L
.49614 .57049 L
.49726 .57049 L
.49854 .57049 L
.49975 .57049 L
.50084 .57049 L
.50201 .57049 L
.5033 .57049 L
.50394 .57049 L
.50465 .57049 L
.50591 .57049 L
.50708 .57049 L
.50827 .57049 L
.50939 .57049 L
.51039 .57049 L
.51149 .57049 L
.51268 .57049 L
.51394 .57049 L
.51502 .57049 L
.51622 .57049 L
.51752 .57049 L
.51818 .57049 L
.5189 .57049 L
.52017 .57049 L
.52135 .57049 L
.52208 .57049 L
.52276 .57049 L
.52403 .57049 L
.52475 .57049 L
.52541 .57049 L
.52613 .57049 L
.5269 .57049 L
Mistroke
.52809 .57049 L
.52936 .57049 L
.53057 .57049 L
.53167 .57049 L
.53296 .57049 L
.53369 .57049 L
.53437 .57049 L
.53561 .57049 L
.53693 .57049 L
.53818 .57049 L
.53888 .57049 L
.53954 .57049 L
.54024 .57049 L
.54087 .57049 L
.5416 .57049 L
.5423 .57049 L
.54344 .57049 L
.54466 .57049 L
.54529 .57049 L
.54599 .57049 L
.54723 .57049 L
.54793 .57049 L
.54867 .57049 L
.54999 .57049 L
.55073 .57049 L
.55141 .57049 L
.55217 .57049 L
.55297 .57049 L
.55367 .57049 L
.55433 .57049 L
.55502 .57049 L
.55577 .57049 L
.55702 .57049 L
.55772 .57049 L
.55836 .57049 L
.559 .57049 L
.5597 .57049 L
.56097 .57049 L
.56168 .57049 L
.56234 .57049 L
.56311 .57049 L
.5638 .57049 L
.56508 .57049 L
.5658 .57049 L
.56646 .57049 L
.56766 .57049 L
.56893 .57049 L
.57008 .57049 L
.5713 .57049 L
.57246 .57049 L
Mistroke
.57351 .57049 L
.57475 .57049 L
.57545 .57049 L
.57609 .57049 L
.57728 .57049 L
.57853 .57049 L
.57974 .57049 L
.58105 .57049 L
.58344 .57049 L
.58794 .57049 L
.59806 .57049 L
.61636 .57049 L
.65699 .57049 L
.69611 .57049 L
.73768 .57049 L
.77773 .57049 L
.81627 .57049 L
.85726 .57049 L
.89674 .57049 L
.9347 .57049 L
.97511 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00?oool406Ko00<00000I_l0I_l0201Vo`030000
06Ko06Ko00D0I_l700001C?o00030000<ol0<ol000Lco`000ol0V@0003?o0008<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Pco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Soool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`07
oooo00<0003oooooool04_ooo`00:?ooo`030000oooooooo02Koool00`000?ooooooo`0Joooo2`1V
o`800009<ol000?o09T0I_lco`007C?o00030000oooooooo02Koool00`000?ooooooo`0Voooo00<0
003oooooool09oooo`00NOooo`@0I_l7<ol000<0I_lco`0co`007C?o00030000oooooooo07Woool0
07goool306Ko13?o000306Ko<ol0<ol001dco`000`000?ooooooo`1ioooo001ooooo00<00000I_l0
I_l00`1Voalco`020000N_ooo`00P?ooo`050000<ol0<ol0<ol006Ko01lco`000`000?ooooooo`1i
oooo0021oooo0P000003<ol0o`2I<ol001hco`000`000?ooooooo`1ioooo0023oooo00<0003o09Tc
o`007S?o00030000oooooooo07Woool008?oool00`000?l0VC?o000N<ol000<0003oooooool0NOoo
o`00Q?ooo`03o`2I<ol0<ol001dco`020000N_ooo`00Q?ooo`03o`2I0000<ol001dco`000`000?oo
ooooo`1ioooo0024oooo00?o09Woool000007C?o00030000oooooooo07Woool008Coool00ol0VOoo
o`00000M<ol000<0003oooooool0NOooo`00Qooooadco`1loooo0028oooo73?o07coool008SooolL
<ol0O?ooo`00R?oooa`co`1loooo0029oooo6c?o07coool007Woool00`000?ooooooo`0=oooo6c?o
00030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool01?oooaXco`00
0oooo`000?ooo`1ioooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool01?oo
o`Tco`02000013?o00800004<ol00P0000<co`000oooo`000?ooo`1ioooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000<co`00100003?o
03?o000000Pco`00100003?o03?o0000008co`000oooo`000?ooo`1ioooo001goooo00<0003ooooo
ool00_ooo`030000oooooooo00coool7<ol000@0000co`0co`00000;<ol000<0000co`0co`000_oo
o`030000oooooooo07Ooool007Soool00`000?ooooooo`0500002oooo`Lco`00100003?o03?o0000
00Tco`0200000c?o0003oooo0000oooo07Woool007Soool01@000?ooooooooooo`00000?oooo1S?o
00040000<ol0<ol000002C?o00030000<ol0<ol0008co`000oooo`000?ooo`1ioooo001ioooo00<0
003oooooool04?ooo`Lco`0200002S?o00<00002<ol000<0003oooooool0NOooo`00S?oooaPco`1l
oooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.48147 .57049 L
.49012 .57049 L
.49468 .57049 L
.49719 .57049 L
.49842 .57049 L
.49955 .57049 L
s
.49955 .57049 m
.49956 .61803 L
s
0 .4 1 r
.02381 .57049 m
.06244 .57049 L
.06361 .57049 L
.06484 .57049 L
.06548 .57049 L
.06619 .57049 L
.06744 .57049 L
.06861 .57049 L
.06988 .57049 L
.07107 .57049 L
.07216 .57049 L
.07285 .57049 L
.07349 .57049 L
.0742 .57049 L
.07495 .57049 L
.07567 .57049 L
.07634 .57049 L
.0776 .57049 L
.07884 .57049 L
.07998 .57049 L
.08123 .57049 L
.08255 .57049 L
.08326 .57049 L
.08391 .57049 L
.08466 .57049 L
.08537 .57049 L
.08662 .57049 L
.08733 .57049 L
.08799 .57049 L
.08865 .57049 L
.08937 .57049 L
.09015 .57049 L
.09088 .57049 L
.09166 .57049 L
.09249 .57049 L
.09326 .57049 L
.09396 .57049 L
.09523 .57049 L
.09588 .57049 L
.09658 .57049 L
.09784 .57049 L
.09903 .57049 L
.0997 .57049 L
.10043 .57049 L
.1012 .57049 L
.10192 .57049 L
.1032 .57049 L
.10392 .57049 L
.10458 .57049 L
.10586 .57049 L
Mistroke
.10702 .57049 L
.10766 .57049 L
.10836 .57049 L
.10962 .57049 L
.1108 .57049 L
.11205 .57049 L
.11312 .57049 L
.11429 .57049 L
.115 .57049 L
.11568 .57049 L
.11694 .57049 L
.11764 .57049 L
.1183 .57049 L
.11901 .57049 L
.11977 .57049 L
.12097 .57049 L
.12223 .57049 L
.12289 .57049 L
.12361 .57049 L
.12488 .57049 L
.12607 .57049 L
.12733 .57049 L
.12853 .57049 L
.12961 .57049 L
.13071 .57049 L
.13189 .57049 L
.13301 .57049 L
.13405 .57049 L
.13526 .57049 L
.13639 .57049 L
.13763 .57049 L
.13896 .57049 L
.14015 .57049 L
.14143 .57049 L
.14216 .57049 L
.14283 .57049 L
.14415 .57049 L
.1454 .57049 L
.14671 .57049 L
.14801 .57049 L
.14874 .57049 L
.14943 .57049 L
.15066 .57049 L
.15179 .57049 L
.15301 .57049 L
.15431 .57049 L
.15498 .57049 L
.15573 .57049 L
.15704 .57049 L
.15777 .57049 L
Mistroke
.15856 .57049 L
.15931 .57049 L
.15999 .57049 L
.16131 .57049 L
.16206 .57049 L
.16275 .57049 L
.16402 .57049 L
.16472 .57049 L
.16537 .57049 L
.16663 .57049 L
.16726 .57049 L
.16796 .57049 L
.16919 .57049 L
.17034 .57049 L
.17104 .57049 L
.1717 .57049 L
.17294 .57049 L
.17364 .57049 L
.17428 .57049 L
.17498 .57049 L
.17573 .57049 L
.17688 .57049 L
.17812 .57049 L
.17929 .57049 L
.18036 .57049 L
.18155 .57049 L
.18286 .57049 L
.18351 .57049 L
.18422 .57049 L
.18548 .57049 L
.18672 .57049 L
.18742 .57049 L
.18807 .57049 L
.18876 .57049 L
.1894 .57049 L
.19012 .57049 L
.19082 .57049 L
.19204 .57049 L
.19317 .57049 L
.19441 .57049 L
.19573 .57049 L
.19649 .57049 L
.19718 .57049 L
.19794 .57049 L
.19874 .57049 L
.19944 .57049 L
.20009 .57049 L
.20085 .57049 L
.20156 .57049 L
.2022 .57049 L
Mistroke
.2029 .57049 L
.20411 .57049 L
.2048 .57049 L
.20553 .57049 L
.20684 .57049 L
.20809 .57049 L
.20923 .57049 L
.21054 .57049 L
.21179 .57049 L
.21294 .57049 L
.21401 .57049 L
.21518 .57049 L
.21643 .57049 L
.2171 .57049 L
.2178 .57049 L
.21857 .57049 L
.21928 .57049 L
.22057 .57049 L
.22129 .57049 L
.22197 .57049 L
.22324 .57049 L
.2244 .57049 L
.22504 .57049 L
.22573 .57049 L
.227 .57049 L
.22821 .57049 L
.22933 .57049 L
.23055 .57049 L
.23184 .57049 L
.23297 .57049 L
.23401 .57049 L
.23516 .57049 L
.23639 .57049 L
.23709 .57049 L
.23773 .57049 L
.23844 .57049 L
.23919 .57049 L
.24044 .57049 L
.24116 .57049 L
.24182 .57049 L
.24307 .57049 L
.24421 .57049 L
.24552 .57049 L
.24676 .57049 L
.25163 .57049 L
.2523 .57049 L
.25303 .57049 L
.25435 .57049 L
.25552 .57049 L
.25681 .57049 L
Mistroke
.25756 .57049 L
.25825 .57049 L
.25905 .57049 L
.25977 .57049 L
.26109 .57049 L
.26182 .57049 L
.2625 .57049 L
.26379 .57049 L
.26448 .57049 L
.2652 .57049 L
.26642 .57049 L
.26712 .57049 L
.26777 .57049 L
.26895 .57049 L
.27021 .57049 L
.2713 .57049 L
.27248 .57049 L
.2732 .57049 L
.27386 .57049 L
.27517 .57049 L
.27644 .57049 L
.27762 .57049 L
.27878 .57049 L
.28002 .57049 L
.28073 .57049 L
.2814 .57049 L
.28266 .57049 L
.2833 .57049 L
.28398 .57049 L
.2852 .57049 L
.28652 .57049 L
.28727 .57049 L
.28798 .57049 L
.28906 .57049 L
.29024 .57049 L
.29147 .57049 L
.29262 .57049 L
.2937 .57049 L
.29468 .57049 L
.29582 .57049 L
.29689 .57049 L
.29805 .57049 L
.29928 .57049 L
.30033 .57049 L
.30149 .57049 L
.30274 .57049 L
.30344 .57049 L
.30408 .57049 L
.30532 .57049 L
.3065 .57049 L
Mistroke
.30765 .57049 L
.30887 .57049 L
.30951 .57049 L
.3102 .57049 L
.31143 .57049 L
.3126 .57049 L
.31384 .57049 L
.31501 .57049 L
.31609 .57049 L
.3174 .57049 L
.31815 .57049 L
.31884 .57049 L
.3201 .57049 L
.32074 .57049 L
.32145 .57049 L
.32265 .57049 L
.32395 .57049 L
.32518 .57049 L
.32631 .57049 L
.32738 .57049 L
.32852 .57049 L
.3296 .57049 L
.33059 .57049 L
.33174 .57049 L
.33299 .57049 L
.33418 .57049 L
.33527 .57049 L
.33639 .57049 L
.33745 .57049 L
.3386 .57049 L
.33985 .57049 L
.34115 .57049 L
.34238 .57049 L
.34349 .57049 L
.3447 .57049 L
.34535 .57049 L
.34603 .57049 L
.34726 .57049 L
.34858 .57049 L
.34933 .57049 L
.35003 .57049 L
.3513 .57049 L
.35245 .57049 L
.35309 .57049 L
.35378 .57049 L
.35504 .57049 L
.35617 .57049 L
.35741 .57049 L
.3587 .57049 L
.35991 .57049 L
Mistroke
.36095 .57049 L
.36206 .57049 L
.36328 .57049 L
.36441 .57049 L
.36514 .57049 L
.36583 .57049 L
.36712 .57049 L
.36835 .57049 L
.36899 .57049 L
.36969 .57049 L
.37091 .57049 L
.37221 .57049 L
.3734 .57049 L
.37452 .57049 L
.3752 .57049 L
.37593 .57049 L
.37662 .57049 L
.37727 .57049 L
.37856 .57049 L
.37977 .57049 L
.38107 .57049 L
.38176 .57049 L
.3825 .57049 L
.38324 .57049 L
.38401 .57049 L
.38468 .57049 L
.3854 .57049 L
.38672 .57049 L
.38793 .57049 L
.38857 .57049 L
.38927 .57049 L
.39 .57049 L
.39068 .57049 L
.39193 .57049 L
.39308 .57049 L
.39371 .57049 L
.39441 .57049 L
.39566 .57049 L
.39689 .57049 L
.39801 .57049 L
.39929 .57049 L
.4005 .57049 L
.40163 .57049 L
.40266 .57049 L
.4038 .57049 L
.40499 .57049 L
.4063 .57049 L
.40749 .57049 L
.40815 .57049 L
.40886 .57049 L
Mistroke
.41016 .57049 L
.41138 .57049 L
.41267 .57049 L
.41377 .57049 L
.41498 .57049 L
.41567 .57049 L
.4164 .57049 L
.4177 .57049 L
.41843 .57049 L
.4191 .57049 L
.41984 .57049 L
.42063 .57049 L
.42132 .57049 L
.42206 .57049 L
.42277 .57049 L
.42341 .57049 L
.42464 .57049 L
.42594 .57049 L
.42715 .57049 L
.42847 .57049 L
.42972 .57049 L
.43088 .57049 L
.43202 .57049 L
.43306 .57049 L
.43426 .57049 L
.43539 .57049 L
.43663 .57049 L
.43793 .57049 L
.43904 .57049 L
.44027 .57049 L
.44158 .57049 L
.44232 .57049 L
.44299 .57049 L
.4443 .57049 L
.44553 .57049 L
.44659 .57049 L
.44775 .57049 L
.44896 .57049 L
.4501 .57049 L
.45116 .57049 L
.45213 .57049 L
.45325 .57049 L
.45432 .57049 L
.45546 .57049 L
.45668 .57049 L
.45783 .57049 L
.45888 .57049 L
.46011 .57049 L
.4608 .57049 L
.46144 .57049 L
Mistroke
.46261 .57049 L
.46385 .57049 L
.46507 .57049 L
.46576 .57049 L
.4664 .57049 L
.46757 .57049 L
.46881 .57049 L
.46987 .57049 L
.47098 .57049 L
.47221 .57049 L
.47333 .57049 L
.47452 .57049 L
.47582 .57049 L
.47703 .57049 L
.47816 .57049 L
.47885 .57049 L
.47951 .57049 L
.48073 .57049 L
.48205 .57049 L
.4828 .57049 L
.48349 .57049 L
.48454 .57049 L
.48568 .57049 L
.48675 .57049 L
.48773 .57049 L
.48887 .57049 L
.49012 .57049 L
.4913 .57049 L
.49239 .57049 L
.49363 .57049 L
.49479 .57049 L
.49583 .57049 L
.49696 .57049 L
.49819 .57049 L
.49949 .57049 L
.5006 .57049 L
.50182 .57049 L
.50313 .57049 L
.50434 .57049 L
.50502 .57049 L
.50567 .57049 L
.50634 .57049 L
.50708 .57049 L
.50833 .57049 L
.50947 .57049 L
.51073 .57049 L
.51205 .57049 L
.51316 .57049 L
.51436 .57049 L
.51548 .57049 L
Mistroke
.5165 .57049 L
.5177 .57049 L
.519 .57049 L
.52023 .57049 L
.52136 .57049 L
.52257 .57049 L
.52387 .57049 L
.52509 .57049 L
.52621 .57049 L
.52752 .57049 L
.52826 .57049 L
.52894 .57049 L
.5302 .57049 L
.53083 .57049 L
.53154 .57049 L
.53221 .57049 L
.53293 .57049 L
.5342 .57049 L
.53491 .57049 L
.53558 .57049 L
.5363 .57049 L
.53708 .57049 L
.53775 .57049 L
.53848 .57049 L
.53917 .57049 L
.53981 .57049 L
.54101 .57049 L
.54229 .57049 L
.5435 .57049 L
.54481 .57049 L
.54606 .57049 L
.54721 .57049 L
.54833 .57049 L
.54939 .57049 L
.55061 .57049 L
.55171 .57049 L
.55408 .57049 L
.55537 .57049 L
.55658 .57049 L
.55788 .57049 L
.55857 .57049 L
.55932 .57049 L
.56064 .57049 L
.56184 .57049 L
.56297 .57049 L
.56418 .57049 L
.56521 .57049 L
.56634 .57049 L
.56756 .57049 L
.56887 .57049 L
Mistroke
.5701 .57049 L
.57124 .57049 L
.57231 .57049 L
.57331 .57049 L
.57441 .57049 L
.57558 .57049 L
.57681 .57049 L
.57797 .57049 L
.57901 .57049 L
.58014 .57049 L
.58137 .57049 L
.5825 .57049 L
.58504 .57049 L
.58961 .57049 L
.60003 .57049 L
.62108 .57049 L
.66085 .57049 L
.69911 .57049 L
.73982 .57049 L
.77902 .57049 L
.82067 .57049 L
.86081 .57049 L
.89942 .57049 L
.94049 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool002Woool30000:?ooo`<0000T
oooo100002Goool00`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo
0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Y
oooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000
oooooooo02Koool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00009_ooo`030000oooo000002Soool002[oool300009oooo`80000Voooo0P00
02Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oool0
0000300000Dco`000`0003?o03?o0008<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`00
0`0003?o03?o0008<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000
oooooooo01;oool002Soool00`000?ooooooo`0Voooo00<0003oooooool08Oooo`H0000D<ol000?o
09Tco`0co`004S?o00030000oooooooo02Koool00`000?ooooooo`0Voooo00<0003oooooool09ooo
o`00N_ooo`<0000B<ol000?o09Tco`0co`004S?o00030000oooooooo07Woool007goool2000043?o
0003o`2I<ol0<ol0018co`000`000?ooooooo`1ioooo001ooooo00<0000co`0co`003C?o0003o`2I
<ol0<ol0018co`020000N_ooo`00P?ooo`030000<ol0<ol000`co`000ol0VC?o03?o000B<ol000<0
003oooooool0NOooo`00POooo`80000<<ol000?o09Tco`0co`004S?o00030000oooooooo07Woool0
08?oool00`0003?o03?o0009<ol000?o09Tco`0co`004S?o00030000oooooooo07Woool008?oool0
0`0003?o03?o0009<ol000?o09Tco`0co`004S?o00030000oooooooo07Woool008Coool00`0003?o
03?o0008<ol000?o09Tco`0co`004S?o0080001joooo0025oooo00<0000co`0co`001c?o0003o`2I
<ol0<ol0018co`000`000?ooooooo`1ioooo0026oooo00<0000co`0co`001S?o0003o`2I<ol0<ol0
018co`000`000?ooooooo`1ioooo0026oooo00<0000co`0co`001S?o0003o`2I<ol0<ol0018co`00
0`000?ooooooo`1ioooo0027oooo7C?o07coool008SooolL<ol0O?ooo`00R?oooa`co`1loooo0028
oooo73?o07coool008WooolK<ol0O?ooo`00Ooooo`030000oooooooo00OooolE<ol000<0000co`0c
o`000c?o07coool007koool00`000?ooooooo`08oooo00<0000co`0co`004c?o00030000<ol0<ol0
008co`1loooo001noooo00<0003oooooool00_ooo`800004oooo00<0000co`0co`001c?o00800004
<ol00P0000@co`000`0003?o03?o0002<ol0O?ooo`00O_ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0000co`0co`001C?o00040000<ol0<ol000002C?o00030000<ol0<ol0
008co`1loooo001moooo00<0003oooooool00_ooo`030000oooooooo00Koool7<ol000@0000co`0c
o`00000:<ol000@0000co`0co`0co`1loooo001noooo00<0003oooooool01@0000Goool7<ol000@0
000co`0co`000009<ol000<0000co`0co`000S?o07coool007koool01@000?ooooooooooo`000009
oooo1S?o00040000<ol0<ol000002C?o00030000<ol0<ol0008co`1loooo001ooooo00<0003ooooo
ool02_ooo`Lco`0200002C?o00030000<ol0<ol000<co`1loooo002<oooo63?o07coool008cooolH
<ol0O?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.51896 .57049 L
.52455 .57049 L
.52986 .57049 L
.53463 .57049 L
.53594 .57049 L
.53733 .57049 L
.53865 .57049 L
s
.53865 .57049 m
.53865 .61803 L
s
0 .4 1 r
.02381 .57048 m
.04262 .57048 L
.06244 .57048 L
.07286 .57047 L
.08255 .57047 L
.09388 .57046 L
.10458 .57046 L
.125 .57044 L
.14357 .57042 L
.16355 .57039 L
.18199 .57035 L
.20071 .57029 L
.21136 .57025 L
.22134 .5702 L
.24158 .57007 L
.26011 .5699 L
.27909 .56967 L
.28984 .56949 L
.29982 .5693 L
.32034 .56877 L
.33895 .56809 L
.35819 .56711 L
.36904 .56639 L
.37901 .56559 L
.39784 .56364 L
.40853 .5622 L
.4185 .56059 L
.43885 .55625 L
.45741 .55065 L
.4765 .54255 L
.48728 .53656 L
.49726 .52984 L
.51592 .5133 L
.52655 .5008 L
.53131 .49424 L
.53383 .4905 L
.53652 .48628 L
.53789 .48402 L
.53919 .48183 L
.54035 .57049 L
.54162 .57049 L
.54281 .57049 L
.54408 .57049 L
.54516 .57049 L
.54635 .57049 L
.54704 .57049 L
.5477 .57049 L
.54893 .57049 L
.54962 .57049 L
.55026 .57049 L
Mistroke
.55096 .57049 L
.5517 .57049 L
.55235 .57049 L
.55305 .57049 L
.55433 .57049 L
.55557 .57049 L
.5567 .57049 L
.55778 .57049 L
.55893 .57049 L
.56001 .57049 L
.561 .57049 L
.56216 .57049 L
.56342 .57049 L
.56461 .57049 L
.56571 .57049 L
.56684 .57049 L
.5679 .57049 L
.56907 .57049 L
.57032 .57049 L
.57156 .57049 L
.57287 .57049 L
.57521 .57049 L
.57645 .57049 L
.5771 .57049 L
.57779 .57049 L
.57906 .57049 L
.58023 .57049 L
.58135 .57049 L
.5824 .57049 L
.58478 .57049 L
.59499 .57049 L
.61337 .57049 L
.65225 .57049 L
.69358 .57049 L
.73339 .57049 L
.77169 .57049 L
.81244 .57049 L
.85167 .57049 L
.88939 .57049 L
.92956 .57049 L
.96821 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOoo
o`00Y?ooo`030000oooooooo07Woool00:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool0
0:Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
07Woool008ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0007[oool008Woool4
00000_ooo`040000oooooooo00002Oooo`800006oooo00<0003oooooool0NOooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool3
00001Oooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool0
0:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?ooo`800004
oooo0P0000Goool300001?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`D00004
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0
003oooooool0NOooo`00T?ooo`80000;oooo0P0000Goool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`80001joooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Y?ooo`80001joooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`1i
oooo002?oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0NOoo
o`00Soooo`040000oooooooo00002_ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@00002
oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo07Woool008ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P00
00[oool200001_ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool0
0`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0
003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00T?oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`00
00Soool00`000?ooooooo`06oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`1ioooo002@oooo0P0000[oool200001_ooo`030000oooooooo
07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1i
oooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?oo
ooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003ooooo
ool0NOooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P00
07[oool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool00`000?oo
ooooo`1ioooo002@oooo0P0000Coool200000oooo`D00004oooo00<0003oooooool0NOooo`00Sooo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80001joooo0029oooo100000;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo
00001_ooo`0506Kooooooooooooo000000Koool00`000?ooooooo`1ioooo002@oooo0P0000Koool2
06Ko0_ooo`800006oooo00<0003oooooool0NOooo`00V?ooo`80I_l:oooo00<0003oooooool0NOoo
o`00Uoooo`0306Kooooo06Ko00[oool20000N_ooo`00U_ooo`0406Kooooooooo06Ko2_ooo`030000
oooooooo07Woool009Koool0101Vooooooooo`1Vo`[oool00`000?ooooooo`1ioooo002Eoooo00D0
I_ooooooooooool0I_l02_ooo`030000oooooooo07Woool009Coool00`1Vooooooooo`02oooo00<0
I_ooooooool02?ooo`030000oooooooo07Woool009?oool00`1Vooooooooo`03oooo00<0I_oooooo
ool02?ooo`80001joooo002Boooo00<0I_ooooooool01?ooo`0306Kooooooooo00Soool00`000?oo
ooooo`1ioooo002Aoooo00<0I_ooooooool01Oooo`0306Kooooooooo00Soool00`000?ooooooo`1i
oooo002@oooo00<0I_ooooooool01_ooo`0306Kooooooooo00Soool00`000?ooooooo`1ioooo000Y
oooo0`0002Soool300009?ooo`@0000@oooo00<0I_ooooooool01oooo`0306Kooooooooo00Soool0
0`000?ooooooo`0Toooo100002Ooool300009oooo`00:Oooo`040000oooooooo0000:?ooo`030000
oooooooo02?oool00`000?ooooooo`0@oooo00<0I_ooooooool02?ooo`0306Kooooooooo00Soool2
00009Oooo`030000oooooooo02Woool00`000?ooooooo`0Voooo000Yoooo00@0003oooooool0000U
oooo1@0002Goool00`000?ooooooo`0=oooo0P1Vo`_oool00`1Vooooooooo`08oooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool500009oooo`008oooo`@00002oooo0`00023oool400000_oo
o`040000oooooooo00007oooo`@00004oooo00<0003oooooool02_ooo`80I_l=oooo00<0I_oooooo
ool02?ooo`030000oooooooo02Koool00`000?ooooooo`0Toooo00@0003oooooool0000Xoooo000Z
oooo00<0003oooooool09_ooo`030000oooo000002Goool010000?ooooooo`0000Woool206Ko3ooo
o`0306Kooooooooo00Soool00`000?ooooooo`0Toooo00@0003oooooool0000Voooo00<0003oool0
0000:?ooo`00:_ooo`<0000Woooo0P0002Koool200002?ooo`80I_lAoooo00<0I_ooooooool02?oo
o`030000oooooooo02Goool20000:?ooo`80000Xoooo0023oooo0`1Voa?oool00`1Vooooooooo`08
oooo0P0007[oool0087oool206Ko5_ooo`0306Kooooooooo00Soool00`000?ooooooo`1ioooo001m
oooo101VoaSoool00`1Vooooooooo`08oooo00<0003oooooool0NOooo`00L_ooo`/0I_lLoooo00<0
I_ooooooool02?ooo`030000oooooooo07Woool006Soool:06Ko9oooo`0306Kooooooooo00Soool0
0`000?ooooooo`1ioooo000=ooooo`0000H0000>oooo000Coooo00<0003oooooool01oooo`030000
oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Soool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooo`00000<
00001C?o00030000<ol0<ol000Pco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000
<ol0<ol000Pco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Soool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003ooooo
ool04_ooo`00:?ooo`030000oooooooo02Koool00`000?ooooooo`0Qoooo1P0001hco`000ol0VC?o
03?o0008<ol000<0003oooooool09_ooo`030000oooooooo02Koool00`000?ooooooo`0Woooo001j
oooo0`0001`co`000ol0VC?o03?o0008<ol000<0003oooooool0NOooo`00OOooo`80000J<ol000?o
09Tco`0co`0023?o00030000oooooooo07Woool007ooool00`0003?o03?o000G<ol000?o09Tco`0c
o`0023?o0080001joooo0020oooo00<0000co`0co`005S?o0003o`2I<ol0<ol000Pco`000`000?oo
ooooo`1ioooo0021oooo0P0001Hco`000ol0VC?o03?o0008<ol000<0003oooooool0NOooo`00Pooo
o`030000<ol0<ol001<co`000ol0VC?o03?o0008<ol000<0003oooooool0NOooo`00Poooo`030000
<ol0<ol001<co`000ol0VC?o03?o0008<ol000<0003oooooool0NOooo`00Q?ooo`030000<ol0<ol0
018co`000ol0VC?o03?o0008<ol00P0007[oool008Goool00`0003?o03?o000A<ol000?o09Tco`0c
o`0023?o00030000oooooooo07Woool008Koool00`0003?o03?o000@<ol000?o09Tco`0co`0023?o
00030000oooooooo07Woool008Koool00`0003?o03?o000@<ol000?o09Tco`0co`0023?o00030000
oooooooo07Woool008OooolM<ol0O?ooo`00R?oooa`co`1loooo0028oooo73?o07coool008SooolL
<ol0O?ooo`00ROoooa/co`1loooo001loooo00<0003oooooool02_oooaPco`000`0003?o03?o001l
oooo001koooo00<0003oooooool02?ooo`040000oooooooooooo63?o00030000<ol0oooo07_oool0
07_oool00`000?ooooooo`02oooo0P0000Coool010000?ooooooooooo`Hco`02000013?o00800004
<ol00P0000@co`000`0003?o0?ooo`1koooo001koooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool010000?ooooooooooo`@co`00100003?o03?o000000Pco`00100003?o03?o0000
00<co`000`0003?o0?ooo`1koooo001joooo00<0003oooooool00_ooo`030000oooooooo00Woool4
<ol000@0000co`0co`00000;<ol000<0000co`0co`000S?o00030000oooooooo07[oool007_oool0
0`000?ooooooo`0500002?ooo`@co`00100003?o03?o000000Tco`02000013?o00030000<ol0oooo
07_oool007_oool01@000?ooooooooooo`00000<oooo0c?o00040000<ol0<ol000002C?o00030000
<ol0<ol000<co`000`0003?o0?ooo`1koooo001loooo00<0003oooooool03Oooo`@co`0200002S?o
00<00002<ol000<0000co`0co`00O?ooo`00S?oooaPco`1loooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.55838 .57049 L
.56817 .57049 L
.57355 .57049 L
.57618 .57049 L
.57734 .57049 L
.57861 .57049 L
.57931 .57049 L
s
.57931 .57049 m
.57931 .61803 L
s
0 .4 1 r
.02381 .57047 m
.04262 .57046 L
.06244 .57045 L
.07286 .57044 L
.08255 .57043 L
.09388 .57042 L
.10458 .5704 L
.125 .57036 L
.14357 .57031 L
.16355 .57023 L
.18199 .57012 L
.20071 .56998 L
.21136 .56987 L
.22134 .56975 L
.24158 .56943 L
.26011 .56901 L
.27909 .56841 L
.28984 .56797 L
.29982 .56748 L
.32034 .56615 L
.33895 .56445 L
.35819 .56197 L
.36904 .56015 L
.37901 .55814 L
.39784 .55322 L
.40853 .54959 L
.4185 .54552 L
.43885 .53459 L
.45741 .52046 L
.4765 .50004 L
.48728 .48494 L
.49726 .46801 L
.51592 .42631 L
.52655 .39478 L
.53652 .35817 L
.54635 .31333 L
.5567 .25334 L
.56554 .18751 L
.57018 .14556 L
.57521 .09248 L
.57655 .07679 L
.57796 .05934 L
.57917 .0437 L
.57985 .57049 L
.58049 .57049 L
.58548 .57049 L
.59482 .57049 L
.61577 .57049 L
.65459 .57049 L
.69587 .57049 L
Mistroke
.73563 .57049 L
.77388 .57049 L
.81457 .57049 L
.85376 .57049 L
.89539 .57049 L
.93551 .57049 L
.97411 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002T
oooo00<0003oooooool0NOooo`00Xoooo`0306Ko0000oooo07[oool00:?oool00`1Vo`000000001j
oooo002Soooo00<0I_l0003oool0N_ooo`00Xoooo`0306Ko0000oooo07[oool00:?oool00`1Vo`00
0?ooo`1joooo002Soooo00<0I_l0003oool0N_ooo`00Xoooo`0306Ko0000000007[oool00:?oool0
0`1Vo`000?ooo`1joooo002Soooo00<0I_l0003oool0N_ooo`00T?ooo`800004oooo0P0000Coool2
00001Oooo`0306Ko0000oooo07[oool008ooool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`1Vo`000?ooo`1joooo002?oooo00@0003oooooool0000;oooo00<0003oooooool00_oo
o`0306Ko0000000007[oool008Woool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0
I_l0003oool0N_ooo`00Soooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`1Vo`00
0?ooo`1joooo002@oooo0P0000[oool300001?ooo`0306Ko0000oooo07[oool00:;oool00`1Voooo
o`00001koooo002Roooo00@0I_ooool00000001joooo002Roooo00<0I_ooool00000Noooo`00X_oo
o`0306Kooooo000007_oool00:;oool00`1Vooooo`00001koooo002Roooo00<0I_ooool00000Nooo
o`00X_ooo`0406Kooooo00000000N_ooo`00XOooo`0406Kooooooooo0000Noooo`00XOooo`0406Ko
oooooooo0000Noooo`00XOooo`0406Kooooooooo0000Noooo`00XOooo`0406Kooooooooo0000Nooo
o`00XOooo`0306Kooooooooo0080001joooo002Qoooo00@0I_ooooooool0001koooo002Qoooo00@0
I_ooooooool0001koooo002Qoooo00@0I_ooooooool0001koooo002Poooo00D0I_ooooooooooool0
0000Noooo`00X?ooo`0406Kooooooooooooo0P0007[oool00:3oool01@1Vooooooooooooo`00001k
oooo002Poooo00D0I_ooooooooooool00000Noooo`00T?ooo`800004oooo0P0000Goool3000000D0
I_ooooooooooool00000Noooo`00Soooo`040000oooooooo00002oooo`030000oooo06Ko00?oool0
0`000?ooooooo`1ioooo002?oooo00@0003oooooool00008oooo1@00000406Kooooooooooooo0P00
07[oool008Woool400000_ooo`040000oooooooo00002?ooo`060000oooooooo0000oooo06Ko0ooo
o`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool01@000?ooo`000?ooo`1Vo`03
oooo00<0003oooooool0NOooo`00T?ooo`80000;oooo0P000003oooo06Kooooo00;oool00`000?oo
ooooo`1ioooo002Ooooo00<0I_ooooooool00_ooo`030000oooooooo07Woool009ooool00`1Voooo
ooooo`02oooo0P0007[oool009ooool00`1Vooooooooo`02oooo00<0003oooooool0NOooo`00Wooo
o`0306Kooooooooo00;oool00`000?ooooooo`1ioooo002Ooooo00<0I_ooooooool00_ooo`030000
oooooooo07Woool009ooool00`1Vooooooooo`02oooo00<0003oooooool0NOooo`00Woooo`0306Ko
oooooooo00;oool20000N_ooo`00Woooo`0306Kooooooooo00;oool00`000?ooooooo`1ioooo002O
oooo00<0I_ooooooool00_ooo`030000oooooooo07Woool009koool00`1Vooooooooo`03oooo00<0
003oooooool0NOooo`00W_ooo`0306Kooooooooo00?oool00`000?ooooooo`1ioooo002Noooo00<0
I_ooooooool00oooo`80001joooo002Noooo00<0I_ooooooool00oooo`030000oooooooo07Woool0
09koool00`1Vooooooooo`03oooo00<0003oooooool0NOooo`00W_ooo`0306Kooooooooo00?oool0
0`000?ooooooo`1ioooo002Noooo00<0I_ooooooool00oooo`030000oooooooo07Woool009goool0
0`1Vooooooooo`04oooo0P0007[oool009goool00`1Vooooooooo`04oooo00<0003oooooool0NOoo
o`00WOooo`0306Kooooooooo00Coool00`000?ooooooo`1ioooo002@oooo0P0000Coool200001?oo
o`800006oooo00<0003oooooool0NOooo`00Soooo`040000oooooooo00002?ooo`040000oooo06Ko
00001Oooo`030000oooooooo07Woool008ooool010000?ooooooo`0000Woool00`1Vo`000?ooo`05
oooo0P0007[oool008Woool400000_ooo`040000oooooooo00002Oooo`0306Kooooo000000Goool0
0`000?ooooooo`1ioooo002?oooo00@0003oooooool00008oooo00@00000I_ooool00005oooo00<0
003oooooool0NOooo`00T?ooo`80000:oooo0P0000Koool00`000?ooooooo`1ioooo002Loooo00<0
I_ooooooool01Oooo`030000oooooooo07Woool009_oool00`1Vooooooooo`06oooo0P0007[oool0
09_oool00`1Vooooooooo`06oooo00<0003oooooool0NOooo`00Voooo`0306Kooooooooo00Koool0
0`000?ooooooo`1ioooo002Koooo00<0I_ooooooool01_ooo`030000oooooooo07Woool009[oool0
0`1Vooooooooo`07oooo00<0003oooooool0NOooo`00V_ooo`0306Kooooooooo00Ooool20000N_oo
o`00V_ooo`0306Kooooooooo00Ooool00`000?ooooooo`1ioooo002Joooo00<0I_ooooooool01ooo
o`030000oooooooo07Woool009Woool00`1Vooooooooo`08oooo00<0003oooooool0NOooo`00VOoo
o`0306Kooooooooo00Soool00`000?ooooooo`1ioooo002Ioooo00<0I_ooooooool02?ooo`80001j
oooo002Ioooo00<0I_ooooooool02?ooo`030000oooooooo07Woool009Soool00`1Vooooooooo`09
oooo00<0003oooooool0NOooo`00V?ooo`0306Kooooooooo00Woool00`000?ooooooo`1ioooo002H
oooo00<0I_ooooooool02Oooo`030000oooooooo07Woool009Soool00`1Vooooooooo`09oooo0P00
07[oool009Soool00`1Vooooooooo`09oooo00<0003oooooool0NOooo`00Uoooo`0306Kooooooooo
00[oool00`000?ooooooo`1ioooo002@oooo0P0000Coool200000oooo`@00005oooo00<0003ooooo
ool0NOooo`00Soooo`040000oooooooo00001?ooo`0506Kooooooooooooo000000Soool00`000?oo
ooooo`1ioooo002?oooo00@0003oooooool00004oooo00<0I_ooooooool00_ooo`030000oooooooo
00Goool20000N_ooo`00ROooo`@00002oooo00@0003oooooool00003oooo00<0I_ooooooool01?oo
o`030000oooooooo00Coool00`000?ooooooo`1ioooo002?oooo00@0003oooooool00003oooo00<0
I_ooooooool00_ooo`040000oooooooo00001Oooo`030000oooooooo07Woool0093oool200001?oo
o`0306Kooooooooo00?oool200001_ooo`030000oooooooo07Woool009Koool00`1Vooooooooo`0;
oooo00<0003oooooool0NOooo`00UOooo`0306Kooooooooo00coool20000N_ooo`00UOooo`0306Ko
oooooooo00coool00`000?ooooooo`1ioooo002Eoooo00<0I_ooooooool03?ooo`030000oooooooo
07Woool009Coool00`1Vooooooooo`0=oooo00<0003oooooool0NOooo`00U?ooo`0306Kooooooooo
00goool00`000?ooooooo`1ioooo002Doooo00<0I_ooooooool03Oooo`80001joooo002Coooo00<0
I_ooooooool03_ooo`030000oooooooo07Woool009?oool00`1Vooooooooo`0>oooo00<0003ooooo
ool0NOooo`00Toooo`0306Kooooooooo00koool00`000?ooooooo`1ioooo002Boooo00<0I_oooooo
ool03oooo`030000oooooooo07Woool009;oool00`1Vooooooooo`0?oooo0P0007[oool0097oool0
0`1Vooooooooo`0@oooo00<0003oooooool0NOooo`00TOooo`0306Kooooooooo013oool00`000?oo
ooooo`1ioooo002@oooo00<0I_ooooooool04Oooo`030000oooooooo07Woool0093oool00`1Voooo
ooooo`0Aoooo00<0003oooooool0NOooo`00Soooo`0306Kooooooooo01;oool20000N_ooo`00Sooo
o`0306Kooooooooo01;oool00`000?ooooooo`1ioooo002>oooo00@0I_ooool000000004oooo0P00
00?oool500001?ooo`030000oooooooo07Woool008koool01@1Vo`000?ooooooo`00000:oooo00<0
003oooooool01?ooo`030000oooooooo07Woool008goool00`1Vooooo`000002oooo00<0003ooooo
ool02?ooo`030000oooooooo00Coool20000N_ooo`00ROooo`@000000`1Vooooo`000002oooo00<0
003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002<oooo00@0I_oooooo
ool00002oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`1ioooo002<
oooo00@0I_ooooooooooool200002_ooo`800006oooo00<0003oooooool0NOooo`00Roooo`0306Ko
oooooooo01Koool00`000?ooooooo`1ioooo002:oooo00<0I_ooooooool05oooo`80001joooo002:
oooo00<0I_ooooooool05oooo`030000oooooooo07Woool008Woool00`1Vooooooooo`0Hoooo00<0
003oooooool0NOooo`00R?ooo`0306Kooooooooo01Woool00`000?ooooooo`1ioooo0027oooo00<0
I_ooooooool06_ooo`030000oooooooo07Woool008Koool00`1Vooooooooo`0Koooo0P0007[oool0
08Goool00`1Vooooooooo`0Loooo00<0003oooooool0NOooo`00Q?ooo`0306Kooooooooo01goool0
0`000?ooooooo`1ioooo0023oooo00<0I_ooooooool07_ooo`030000oooooooo07Woool002Woool3
0000:?ooo`<0000Toooo100000;oool206Ko8Oooo`030000oooooooo02Coool400009oooo`<0000W
oooo000Yoooo00@0003oooooool0000Xoooo00<0003oooooool08oooo`030000oooooooo00;oool0
0`1Vooooooooo`0Qoooo0P0002Goool00`000?ooooooo`0Yoooo00<0003oooooool09_ooo`00:Ooo
o`040000oooooooo00009Oooo`D0000Uoooo00@0003oooooool0I_lToooo00<0003oooooool09Ooo
o`030000oooooooo02Goool500009oooo`008oooo`@00002oooo0`00023oool400000_ooo`040000
oooooooo00007oooo`@00004oooo00<00000I_ooool09?ooo`030000oooooooo02Koool00`000?oo
ooooo`0Toooo00@0003oooooool0000Xoooo000Zoooo00<0003oooooool09_ooo`030000oooo0000
02Goool01000001Vooooo`0002Goool00`000?ooooooo`0Toooo00@0003oooooool0000Voooo00<0
003oool00000:?ooo`00:_ooo`<0000Woooo0P0002?oool206Ko00?oool0000000009_ooo`030000
oooooooo02Goool20000:?ooo`80000Xoooo001foooo0`1Vob_oool20000N_ooo`00L_ooo`@0I_l^
oooo00<0003oooooool0NOooo`00Koooo`<0I_lboooo00<0003oooooool0NOooo`00J?ooo`L0I_le
oooo00<0003oooooool0NOooo`00F_ooo`h0I_lloooo00<0003oooooool0NOooo`003Oooool00006
00003_ooo`004oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`08oooo00<0003oool00000300000Dco`000`0003?o03?o0008<ol000<0
000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0008<ol000<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo01;oool002Soool00`000?ooooooo`0V
oooo00<0003oooooool08Oooo`H0000Y<ol000<0003oooooool09_ooo`030000oooooooo02Koool0
0`000?ooooooo`0Woooo001joooo0`0002Lco`000`000?ooooooo`1ioooo001moooo0P0002Dco`00
0`000?ooooooo`1ioooo001ooooo00<0000co`0co`008S?o0080001joooo0020oooo00<0000co`0c
o`008C?o00030000oooooooo07Woool0087oool200008C?o00030000oooooooo07Woool008?oool0
0`0003?o03?o000N<ol000<0003oooooool0NOooo`00Poooo`030000<ol0<ol001hco`000`000?oo
ooooo`1ioooo0024oooo00<0000co`0co`007C?o0080001joooo0025oooo00<0000co`0co`0073?o
00030000oooooooo07Woool008Koool00`0003?o03?o000K<ol000<0003oooooool0NOooo`00Q_oo
o`030000<ol0<ol001/co`000`000?ooooooo`1ioooo0027oooo7C?o07coool008SooolL<ol0O?oo
o`00R?oooa`co`1loooo0028oooo73?o07coool008WooolK<ol0O?ooo`00Ooooo`030000oooooooo
00OooolE<ol000<0000co`0co`000c?o07coool007koool00`000?ooooooo`08oooo00<0000co`0c
o`004c?o00030000<ol0<ol0008co`1loooo001noooo00<0003oooooool00_ooo`800004oooo00<0
000co`0co`001S?o00D00002<ol00P0000@co`000`0003?o03?o0002<ol0O?ooo`00O_ooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0000co`0co`001c?o00030000<ol0<ol0
00Pco`000`0003?o03?o0002<ol0O?ooo`00OOooo`030000oooooooo00;oool00`000?ooooooo`06
oooo2C?o00030000<ol0<ol000Tco`00100003?o03?o03?o07coool007koool00`000?ooooooo`05
00001Oooo`Tco`000`0003?o03?o0008<ol000<0000co`0co`000S?o07coool007koool01@000?oo
ooooooooo`000009oooo23?o00030000<ol0<ol000Pco`000`0003?o03?o0002<ol0O?ooo`00Oooo
o`030000oooooooo00[oool7<ol00P0000Tco`000`0003?o03?o0003<ol0O?ooo`00S?oooaPco`1l
oooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.57861 .57049 L
.58872 .57049 L
.59975 .57049 L
.60479 .57049 L
.61016 .57049 L
.61278 .57049 L
.61524 .57049 L
.61745 .57049 L
.61869 .57049 L
s
.61869 .57049 m
.6187 .61803 L
s
0 .4 1 r
.02381 .57045 m
.04262 .57043 L
.06244 .5704 L
.07286 .57038 L
.08255 .57036 L
.09388 .57033 L
.10458 .5703 L
.125 .57021 L
.14357 .5701 L
.16355 .56993 L
.18199 .56971 L
.20071 .5694 L
.21136 .56917 L
.22134 .56891 L
.24158 .56823 L
.26011 .56734 L
.27909 .56607 L
.28984 .56514 L
.29982 .5641 L
.32034 .56127 L
.33895 .55765 L
.35819 .55239 L
.36904 .54853 L
.37901 .54426 L
.39784 .53379 L
.40853 .52609 L
.4185 .51744 L
.43885 .49421 L
.45741 .4642 L
.4765 .42082 L
.48728 .38873 L
.49726 .35276 L
.51592 .26417 L
.52655 .19718 L
.53131 .16208 L
.53383 .14204 L
.53652 .1194 L
.53789 .10733 L
.53919 .09559 L
.54035 .09284 L
.54162 .09614 L
.54635 .1076 L
.55138 .11798 L
.55413 .12276 L
.5567 .1266 L
.5591 .12958 L
.56129 .13174 L
.56245 .13266 L
.56372 .13346 L
.56442 .13381 L
Mistroke
.56506 .13408 L
.56633 .13444 L
.5675 .13456 L
.56859 .13448 L
.56957 .13425 L
.57063 .13381 L
.57179 .1331 L
.57302 .13208 L
.57521 .1295 L
.57643 .1276 L
.57777 .12514 L
.58018 .11959 L
.58471 .10872 L
.59489 .0854 L
.60436 .06571 L
.61323 .04977 L
.61545 .04628 L
.61777 .04284 L
.61899 .04114 L
.61968 .57049 L
.62032 .57049 L
.62266 .57049 L
.63305 .57049 L
.65407 .57049 L
.69317 .57049 L
.73472 .57049 L
.77475 .57049 L
.81327 .57049 L
.85424 .57049 L
.89369 .57049 L
.93163 .57049 L
.97203 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo00Ooool00`1Vooooooooo`1_oooo002Toooo00<0
003oooooool01oooo`0306Kooooooooo06ooool00:Coool00`000?ooooooo`06oooo0P1Vog7oool0
0:Coool00`000?ooooooo`05oooo00<0I_ooool0I_l0LOooo`00Y?ooo`800005oooo00@0I_oooooo
ool0I_maoooo002Toooo00<0003oooooool01?ooo`0406Kooooooooo06KoLOooo`00Y?ooo`030000
oooooooo00?oool01@1Vooooooooooooo`1Vo`1aoooo002Toooo00<0003oooooool00oooo`0506Ko
oooooooooooo06Ko077oool00:Coool00`000?ooooooo`03oooo00D0I_ooooooooooool0I_l0LOoo
o`00Y?ooo`800003oooo00<0I_ooooooool00_ooo`0306Kooooooooo06ooool00:Coool00`000?oo
ooooo`02oooo00<0I_ooooooool00_ooo`0306Kooooooooo06ooool00:Coool01@000?oooooooooo
o`1Vo`05oooo00<0I_ooooooool0Koooo`00T?ooo`800004oooo0P0000Coool200001_ooo`050000
oooooooooooo06Ko00Goool00`1Vooooooooo`1_oooo002?oooo00@0003oooooool00008oooo00@0
003oooooool00005oooo00@0003oooooool0I_l6oooo00<0I_ooooooool0Koooo`00Soooo`040000
oooooooo00001_ooo`0306Kooooooooo00;oool00`000?ooooooo`03oooo0P000003oooo06Kooooo
00Goool00`1Vooooooooo`1_oooo0029oooo100000;oool010000?ooooooo`0000Koool206Ko00?o
ool0000000001_ooo`030000oooo06Ko00Ooool00`1Vooooooooo`1_oooo002?oooo00@0003ooooo
ool00006oooo0P1Vo`03oooo0000oooo00Koool00`000?ooo`1Vo`07oooo00<0I_ooooooool0Kooo
o`00T?ooo`800007oooo00<0I_ooool0I_l00`0000Goool00`00001Vooooo`07oooo00<0I_oooooo
ool0Koooo`00VOooo`0306Kooooo06Ko00Soool00`00001Vooooo`07oooo00<0I_ooooooool0Kooo
o`00VOooo`0306Kooooo06Ko00Soool200002?ooo`0306Kooooooooo06ooool009Soool01@1Voooo
ooooooooo`1Vo`07oooo00<0003oooooool01oooo`0306Kooooooooo06ooool009Soool01@1Voooo
ooooooooo`1Vo`07oooo00<0003oooooool01oooo`0306Kooooooooo06ooool009Soool00`1Voooo
ooooo`02oooo00<0I_ooooooool00oooo`0306Ko0000oooo00Soool00`1Vooooooooo`1_oooo002H
oooo00<0I_ooooooool00oooo`0306Kooooooooo00;oool00`1Vo`000?ooo`08oooo00<0I_oooooo
ool0Koooo`00V?ooo`0306Kooooooooo00Coool406Ko00?oool0000000002?ooo`0306Kooooooooo
06ooool009Soool00`1Vooooooooo`05oooo0P1Vo`;oool00`000?ooooooo`07oooo00<0I_oooooo
ool0Koooo`00V?ooo`0306Kooooooooo00Woool00`000?ooooooo`07oooo00<0I_ooooooool0Kooo
o`00V?ooo`0306Kooooooooo00Woool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00V?oo
o`0306Kooooooooo00Woool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00V?ooo`0306Ko
oooooooo00Woool200002?ooo`0306Kooooooooo06ooool009Ooool00`1Vooooooooo`0:oooo00<0
003oooooool01oooo`0306Kooooooooo06ooool009Ooool00`1Vooooooooo`0:oooo00<0003ooooo
ool01oooo`0306Kooooooooo06ooool009Ooool00`1Vooooooooo`0:oooo00<0003oooooool01ooo
o`0306Kooooooooo06ooool009Ooool00`1Vooooooooo`0:oooo00<0003oooooool01oooo`0306Ko
oooooooo06ooool009Ooool00`1Vooooooooo`0:oooo0P0000Soool00`1Vooooooooo`1_oooo002G
oooo00<0I_ooooooool02_ooo`030000oooooooo00Ooool00`1Vooooooooo`1_oooo002Goooo00<0
I_ooooooool02_ooo`030000oooooooo00Ooool00`1Vooooooooo`1_oooo002@oooo0P0000Coool2
00001Oooo`<00004oooo00<0003oooooool01oooo`0306Kooooooooo06ooool008ooool010000?oo
ooooo`0000?oool00`1Vooooooooo`05oooo00<0003oooooool00oooo`030000oooooooo00Ooool0
0`1Vooooooooo`1_oooo002?oooo00@0003oooooool00003oooo00<0I_ooooooool00_ooo`D00004
oooo0P0000Soool00`1Vooooooooo`1_oooo0029oooo100000;oool010000?ooooooo`0000?oool0
0`1Vooooooooo`02oooo00@0003oooooool00005oooo00<0003oooooool01oooo`0306Kooooooooo
06ooool008ooool010000?ooooooo`0000?oool00`1Vooooooooo`03oooo00<0003oool000001Ooo
o`030000oooooooo00Ooool00`1Vooooooooo`1_oooo002@oooo0P0000Coool00`1Vooooooooo`04
oooo0P0000Goool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00U_ooo`0306Kooooooooo
00_oool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00UOooo`0306Kooooooooo00coool2
00002?ooo`0306Kooooooooo06ooool009Goool00`1Vooooooooo`0<oooo00<0003oooooool01ooo
o`0306Kooooooooo06ooool009Goool00`1Vooooooooo`0<oooo00<0003oooooool01oooo`0306Ko
oooooooo06ooool009Goool00`1Vooooooooo`0<oooo00<0003oooooool01oooo`0306Kooooooooo
06ooool009Goool00`1Vooooooooo`0<oooo00<0003oooooool01oooo`0306Kooooooooo06ooool0
09Goool00`1Vooooooooo`0<oooo0P0000Soool00`1Vooooooooo`1_oooo002Doooo00<0I_oooooo
ool03Oooo`030000oooooooo00Ooool00`1Vooooooooo`1_oooo002Doooo00<0I_ooooooool03Ooo
o`030000oooooooo00Ooool00`1Vooooooooo`1_oooo002Doooo00<0I_ooooooool03Oooo`030000
oooooooo00Ooool00`1Vooooooooo`1_oooo002Doooo00<0I_ooooooool03Oooo`030000oooooooo
00Ooool00`1Vooooooooo`1_oooo002Doooo00<0I_ooooooool03Oooo`800008oooo00<0I_oooooo
ool0Koooo`00U?ooo`0306Kooooooooo00goool00`000?ooooooo`07oooo00<0I_ooooooool0Kooo
o`00Toooo`0306Kooooooooo00koool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00Tooo
o`0306Kooooooooo00koool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00Toooo`0306Ko
oooooooo00koool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00Toooo`0306Kooooooooo
00koool200002?ooo`0306Kooooooooo06ooool009?oool00`1Vooooooooo`0>oooo00<0003ooooo
ool01oooo`0306Kooooooooo06ooool009;oool00`1Vooooooooo`0?oooo00<0003oooooool01ooo
o`0306Kooooooooo06ooool0093oool2000000@0I_ooooooooooool200001?ooo`800006oooo00<0
003oooooool01oooo`0306Kooooooooo06ooool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00Soooo`040000oooooooo
00002_ooo`030000oooooooo00Coool200002?ooo`0306Kooooooooo06ooool008Woool400000_oo
o`040000oooooooo00002oooo`030000oooooooo00?oool00`000?ooooooo`07oooo00<0I_oooooo
ool0Koooo`00Soooo`040000oooo06Ko00002?ooo`040000oooooooo00001Oooo`030000oooooooo
00Ooool00`1Vooooooooo`1_oooo002@oooo0P0000[oool200001_ooo`030000oooooooo00Ooool0
0`1Vooooooooo`1_oooo002Aoooo00<0I_ooooooool04?ooo`030000oooooooo00Ooool00`1Voooo
ooooo`1_oooo002Aoooo00<0I_ooooooool04?ooo`800008oooo00<0I_ooooooool0Koooo`00T?oo
o`0306Kooooooooo017oool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00T?ooo`0306Ko
oooooooo017oool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00T?ooo`0306Kooooooooo
017oool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00T?ooo`0306Kooooooooo017oool0
0`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00T?ooo`0306Kooooooooo017oool200002?oo
o`0306Kooooooooo06ooool008ooool00`1Vooooooooo`0Boooo00<0003oooooool01oooo`0306Ko
oooooooo06ooool008ooool00`1Vooooooooo`0Boooo00<0003oooooool01oooo`0306Kooooooooo
06ooool008ooool00`1Vooooooooo`0Boooo00<0003oooooool01oooo`0306Kooooooooo06ooool0
08ooool00`1Vooooooooo`0Boooo00<0003oooooool01oooo`0306Kooooooooo06ooool008ooool0
0`1Vooooooooo`0Boooo0P0000Soool00`1Vooooooooo`1_oooo002>oooo00<0I_ooooooool04ooo
o`030000oooooooo00Ooool00`1Vooooooooo`1_oooo002>oooo00<0I_ooooooool04oooo`030000
oooooooo00Ooool00`1Vooooooooo`1_oooo002>oooo00<0I_ooooooool04oooo`030000oooooooo
00Ooool00`1Vooooooooo`1_oooo002>oooo00<0I_ooooooool04oooo`030000oooooooo00Ooool0
0`1Vooooooooo`1_oooo002>oooo00<0I_ooooooool04oooo`800008oooo00<0I_ooooooool0Kooo
o`00SOooo`0306Kooooooooo01Coool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00SOoo
o`0306Kooooooooo01Coool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00SOooo`0306Ko
oooooooo00800004oooo0P0000?oool400001Oooo`030000oooooooo00Ooool00`1Vooooooooo`1_
oooo002=oooo00<0I_ooool000000_ooo`030000oooooooo00Koool00`000?ooooooo`06oooo00<0
003oooooool01oooo`0306Kooooooooo06ooool008coool0101Vooooooooo`0000;oool00`000?oo
ooooo`07oooo00<0003oooooool01Oooo`800008oooo00<0I_ooooooool0Koooo`00ROooo`@00002
oooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000oooooooo00Ooool00`1Voooo
ooooo`1_oooo002<oooo00@0I_ooooooool00002oooo00<0003oooooool01_ooo`040000oooooooo
00001Oooo`030000oooooooo00Ooool00`1Vooooooooo`1_oooo002<oooo00@0I_ooooooooooool2
00002_ooo`800006oooo00<0003oooooool01oooo`0306Kooooooooo06ooool008_oool00`1Voooo
ooooo`0Foooo00<0003oooooool01oooo`0306Kooooooooo06ooool008_oool00`1Vooooooooo`0F
oooo0P0000Soool00`1Vooooooooo`1_oooo002:oooo00<0I_ooooooool05oooo`030000oooooooo
00Ooool00`1Vooooooooo`1_oooo002:oooo00<0I_ooooooool05oooo`030000oooooooo00Ooool0
0`1Vooooooooo`1_oooo002:oooo00<0I_ooooooool05oooo`030000oooooooo00Ooool00`1Voooo
ooooo`1_oooo0029oooo00<0I_ooooooool06?ooo`030000oooooooo00Ooool00`1Vooooooooo`1_
oooo0029oooo00<0I_ooooooool06?ooo`800008oooo00<0I_ooooooool0Koooo`00ROooo`0306Ko
oooooooo01Soool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00R?ooo`0306Kooooooooo
01Woool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00R?ooo`0306Kooooooooo01Woool0
0`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00Qoooo`0306Kooooooooo01[oool00`000?oo
ooooo`07oooo00<0I_ooooooool0Koooo`00Qoooo`0306Kooooooooo01[oool200002?ooo`0306Ko
oooooooo06ooool008Koool00`1Vooooooooo`0Koooo00<0003oooooool01oooo`0306Kooooooooo
06ooool008Koool00`1Vooooooooo`0Koooo00<0003oooooool01oooo`0306Kooooooooo06ooool0
08Koool00`1Vooooooooo`0Koooo00<0003oooooool01oooo`0306Kooooooooo06ooool008Goool0
0`1Vooooooooo`0Loooo00<0003oooooool01oooo`0306Kooooooooo06ooool008Goool00`1Voooo
ooooo`0Loooo0P0000Soool00`1Vooooooooo`1_oooo0024oooo00<0I_ooooooool07Oooo`030000
oooooooo00Ooool00`1Vooooooooo`1_oooo0024oooo00<0I_ooooooool02Oooo`800004oooo0P00
00?oool500001?ooo`030000oooooooo00Ooool00`1Vooooooooo`1_oooo0023oooo00<0I_oooooo
ool02Oooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`07oooo00<0
I_ooooooool0Koooo`00Poooo`0306Kooooooooo00Woool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo0P0000Soool00`1Vooooooooo`1_oooo0022oooo00<0I_ooooooool01?ooo`@00002
oooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000oooooooo00Ooool00`1Voooo
ooooo`1_oooo0021oooo00<0I_ooooooool02oooo`040000oooooooo00002_ooo`030000oooooooo
00Coool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00P?ooo`0306Kooooooooo00goool2
00002_ooo`800006oooo00<0003oooooool01oooo`0306Kooooooooo06ooool0083oool00`1Voooo
ooooo`0Qoooo00<0003oooooool01oooo`0306Kooooooooo06ooool007ooool00`1Vooooooooo`0R
oooo0P0000Soool00`1Vooooooooo`1_oooo001noooo00<0I_ooooooool08oooo`030000oooooooo
00Ooool00`1Vooooooooo`1_oooo001moooo00<0I_ooooooool09?ooo`030000oooooooo00Ooool0
0`1Vooooooooo`1_oooo001loooo00<0I_ooooooool09Oooo`030000oooooooo00Ooool00`1Voooo
ooooo`1_oooo001loooo00<0I_ooooooool09Oooo`030000oooooooo00Ooool00`1Vooooooooo`1_
oooo001koooo00<0I_ooooooool09_ooo`800008oooo00<0I_ooooooool0Koooo`00N_ooo`0306Ko
oooooooo02Ooool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00NOooo`0306Kooooooooo
02Soool00`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00N?ooo`0306Kooooooooo02Woool0
0`000?ooooooo`07oooo00<0I_ooooooool0Koooo`00:Oooo`<0000Xoooo0`00023oool0101Voooo
ooooooooo`@0000Uoooo00<0003oooooool01oooo`0306Kooooooooo01[oool400009oooo`<0000W
oooo000Yoooo00@0003oooooool0000Xoooo00<0003oooooool07Oooo`80I_l4oooo00<0003ooooo
ool09_ooo`800008oooo00<0I_ooooooool06_ooo`030000oooooooo02Woool00`000?ooooooo`0V
oooo000Yoooo00@0003oooooool0000Uoooo1@0001coool206Ko1oooo`030000oooooooo02Goool0
0`000?ooooooo`07oooo00<0I_ooooooool06oooo`030000oooooooo02Goool500009oooo`008ooo
o`@00002oooo0`00023oool400000_ooo`040000oooooooo00006oooo`80I_l2oooo100000Coool0
0`000?ooooooo`0Toooo00<0003oooooool01oooo`0306Kooooooooo01coool00`000?ooooooo`0T
oooo00@0003oooooool0000Xoooo000Zoooo00<0003oooooool09_ooo`030000oooo000001Woool2
06Ko2_ooo`040000oooooooo00009Oooo`030000oooooooo00Ooool00`1Vooooooooo`0Joooo00@0
003oooooool0000Voooo00<0003oool00000:?ooo`00:_ooo`<0000Woooo0P0001Soool00`1Voooo
ooooo`0;oooo0P0002Koool00`000?ooooooo`07oooo00<0I_ooooooool06oooo`80000Xoooo0P00
02Soool006coool206Ko=_ooo`800008oooo00<0I_ooooooool0Koooo`00J?ooo`@0I_lhoooo00<0
003oooooool01oooo`0306Kooooooooo06ooool006?oool506Ko??ooo`030000oooooooo00Ooool0
0`1Vooooooooo`1_oooo001Noooo1@1Vod7oool00`000?ooooooo`07oooo00<0I_ooooooool0Kooo
o`00Coooo`l0I_m6oooo00<0003oooooool01oooo`0306Kooooooooo06ooool000gooooo00001P00
00koool001?oool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool02?ooo`030000oooo000000`00005<ol000<0000co`0co`0023?o00030000
<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`0023?o00030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`0Boooo000Xoooo00<0003oooooool09_oo
o`030000oooooooo027oool60000:C?o00030000oooooooo00Ooool00ol0VOooooooo`0Loooo00<0
003oooooool09_ooo`030000oooooooo02Ooool007[oool300009c?o00030000oooooooo00Ooool0
0ol0VOooooooo`1_oooo001moooo0P0002Dco`000`000?ooooooo`07oooo00?o09Woooooool0Kooo
o`00Ooooo`030000<ol0<ol0028co`0200002?ooo`03o`2Ioooooooo06ooool0083oool00`0003?o
03?o000Q<ol000<0003oooooool01oooo`03o`2Ioooooooo06ooool0087oool200008C?o00030000
oooooooo00Ooool00ol0VOooooooo`1_oooo0023oooo00<0000co`0co`007S?o00030000oooooooo
00Ooool00ol0VOooooooo`1_oooo0023oooo00<0000co`0co`007S?o00030000oooooooo00Ooool0
0ol0VOooooooo`1_oooo0024oooo00<0000co`0co`007C?o00800008oooo00?o09Woooooool0Kooo
o`00QOooo`030000<ol0<ol001`co`000`000?ooooooo`07oooo00?o09Woooooool0Koooo`00Q_oo
o`030000<ol0<ol001/co`000`000?ooooooo`07oooo00?o09Woooooool0Koooo`00Q_ooo`030000
<ol0<ol001/co`000`000?ooooooo`07oooo00?o09Woooooool0Koooo`00Qooooadco`1loooo0028
oooo73?o07coool008SooolL<ol0O?ooo`00R?oooa`co`1loooo0029oooo6c?o07coool007coool0
0`000?ooooooo`0:oooo63?o00030000<ol0<ol007coool007_oool00`000?ooooooo`08oooo00@0
003ooooooooooolH<ol000<0000co`3oool0Noooo`00Noooo`030000oooooooo00;oool200001?oo
o`040000oooooooooooo1C?o00D00002<ol00P0000@co`02000013?o00030000<ol0oooo07_oool0
07_oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`040000oooooooooooo1S?o
00030000<ol0<ol000Lco`00100003?o03?o000000<co`000`0003?o0?ooo`1koooo001joooo00<0
003oooooool00_ooo`030000oooooooo00Woool6<ol000<0000co`0co`002S?o00030000<ol0<ol0
008co`000`000?ooooooo`1joooo001koooo00<0003oooooool01@0000Soool6<ol000<0000co`0c
o`0023?o00800004<ol000<0000co`3oool0Noooo`00Noooo`050000oooooooooooo000000coool5
<ol000<0000co`0co`0023?o00030000<ol0<ol000<co`000`0003?o0?ooo`1koooo001loooo00<0
003oooooool03Oooo`@co`0200002S?o00<00002<ol000<0000co`0co`00O?ooo`00S?oooaPco`1l
oooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.57861 .57049 L
.59832 .57049 L
.61984 .57049 L
.6298 .57049 L
.64043 .57049 L
.64559 .57049 L
.65045 .57049 L
.65482 .57049 L
.65602 .57049 L
.65728 .57049 L
.65836 .57049 L
s
.65836 .57049 m
.65837 .61803 L
s
0 .4 1 r
.02381 .5704 m
.04262 .57036 L
.06244 .5703 L
.07286 .57026 L
.08255 .57022 L
.09388 .57016 L
.10458 .57009 L
.125 .56991 L
.14357 .56968 L
.16355 .56934 L
.18199 .56889 L
.20071 .56825 L
.21136 .56778 L
.22134 .56725 L
.24158 .56585 L
.26011 .56403 L
.27909 .56143 L
.28984 .55951 L
.29982 .55738 L
.32034 .55158 L
.33895 .54415 L
.35819 .53337 L
.36904 .52546 L
.37901 .51669 L
.39784 .49524 L
.40853 .47945 L
.4185 .46171 L
.43885 .41407 L
.45741 .35253 L
.4765 .26358 L
.48728 .19779 L
.49208 .16401 L
.4946 .14502 L
.49726 .12404 L
.49842 .11454 L
.49965 .10416 L
.50037 .10248 L
.50101 .1047 L
.50228 .109 L
.50688 .12427 L
.51592 .15231 L
.52664 .1818 L
.53652 .20471 L
.54584 .22172 L
.55054 .22826 L
.55319 .23126 L
.55571 .2336 L
.557 .23459 L
.55841 .23551 L
.55971 .23619 L
Mistroke
.56089 .23667 L
.56161 .23689 L
.56229 .23705 L
.563 .23717 L
.56377 .23723 L
.56445 .23723 L
.56517 .23717 L
.56645 .23692 L
.56765 .2365 L
.56893 .23584 L
.57014 .235 L
.57125 .23406 L
.57395 .23095 L
.5765 .22684 L
.58111 .21642 L
.58618 .20384 L
.59645 .17807 L
.61489 .1318 L
.6359 .0825 L
.6451 .06367 L
.64996 .05477 L
.65262 .05025 L
.65514 .04626 L
.65634 .04446 L
.65761 .04263 L
.65827 .0417 L
.65899 .57049 L
.66027 .57049 L
.66493 .57049 L
.67403 .57049 L
.69388 .57049 L
.73427 .57049 L
.77315 .57049 L
.81448 .57049 L
.85429 .57049 L
.89259 .57049 L
.93334 .57049 L
.97257 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo002Toooo00<0
003oooooool04Oooo`0306Kooooooooo06Goool00:Coool00`000?ooooooo`0@oooo0P1VofOoool0
0:Coool00`000?ooooooo`0@oooo0P1VofOoool00:Coool200004?ooo`0306Kooooo06Ko06Ooool0
0:Coool00`000?ooooooo`0>oooo00@0I_ooooooool0I_mWoooo002Toooo00<0003oooooool03_oo
o`0406Kooooooooo06KoIoooo`00Y?ooo`030000oooooooo00goool01@1Vooooooooooooo`1Vo`1W
oooo002Toooo00<0003oooooool03Oooo`0506Kooooooooooooo06Ko06Ooool00:Coool200003Ooo
o`0306Kooooooooo00;oool00`1Vooooooooo`1Uoooo002Toooo00<0003oooooool03?ooo`0306Ko
oooooooo00;oool00`1Vooooooooo`1Uoooo002Toooo00<0003oooooool02oooo`0306Kooooooooo
00?oool00`1Vooooooooo`1Uoooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool02oooo`0306Kooooooooo00?oool00`1Vooooooooo`1Uoooo002?oooo00@0003oooooool00008
oooo00@0003oooooool00005oooo00<0003oooooool02_ooo`0306Kooooooooo00Coool00`1Voooo
ooooo`1Uoooo002?oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`80000;oooo00<0
I_ooooooool01?ooo`0306Kooooooooo06Goool008Woool400000_ooo`040000oooooooo00002Ooo
o`800006oooo00<0003oooooool02Oooo`0306Kooooooooo00Goool00`1Vooooooooo`1Uoooo002?
oooo00@0003oooooool00009oooo00<0003oooooool01Oooo`030000oooooooo00Woool00`1Voooo
ooooo`05oooo00<0I_ooooooool0IOooo`00Soooo`0306Ko0000000000[oool300001Oooo`030000
oooooooo00Woool00`1Vooooooooo`05oooo00<0I_ooooooool0IOooo`00Soooo`80I_lCoooo00<0
003oooooool02?ooo`0306Kooooooooo00Koool00`1Vooooooooo`1Uoooo002?oooo0P1Voa?oool2
00002Oooo`0306Kooooooooo00Koool00`1Vooooooooo`1Uoooo002?oooo0P1Voa?oool00`000?oo
ooooo`08oooo00<0I_ooooooool01_ooo`0306Kooooooooo06Goool008koool0101Vooooooooo`1V
oa;oool00`000?ooooooo`07oooo00<0I_ooooooool01oooo`0306Kooooooooo06Goool008koool0
101Vooooooooo`1Voa;oool00`000?ooooooo`07oooo00<0I_ooooooool01oooo`0306Kooooooooo
06Goool008koool0101Vooooooooo`1Voa;oool00`000?ooooooo`06oooo00<0I_ooooooool02?oo
o`0306Kooooooooo06Goool008koool01@1Vooooooooooooo`1Vo`0Aoooo0P0000Ooool00`1Voooo
ooooo`08oooo00<0I_ooooooool0IOooo`00S_ooo`0506Kooooooooooooo06Ko017oool00`000?oo
ooooo`06oooo00<0I_ooooooool02?ooo`0306Kooooooooo06Goool008koool01@1Voooooooooooo
o`1Vo`0Aoooo00<0003oooooool01Oooo`0306Kooooooooo00Woool00`1Vooooooooo`1Uoooo002>
oooo00D0I_ooooooooooool0I_l04Oooo`030000oooooooo00Goool00`1Vooooooooo`09oooo00<0
I_ooooooool0IOooo`00S_ooo`0306Kooooooooo00;oool00`1Vooooooooo`0>oooo00<0003ooooo
ool01?ooo`0306Kooooooooo00[oool00`1Vooooooooo`1Uoooo002>oooo00<0I_ooooooool00_oo
o`0306Kooooooooo00koool200001Oooo`0306Kooooooooo00[oool00`1Vooooooooo`1Uoooo002=
oooo00<0I_ooooooool00oooo`0306Kooooooooo00koool00`000?ooooooo`03oooo00<0I_oooooo
ool02oooo`0306Kooooooooo06Goool008goool00`1Vooooooooo`04oooo00<0I_ooooooool03Ooo
o`030000oooooooo00?oool00`1Vooooooooo`0;oooo00<0I_ooooooool0IOooo`00SOooo`0306Ko
oooooooo00Coool00`1Vooooooooo`0=oooo00<0003oooooool00oooo`0306Kooooooooo00_oool0
0`1Vooooooooo`1Uoooo002=oooo00<0I_ooooooool01?ooo`0306Kooooooooo00goool00`000?oo
ooooo`02oooo00<0I_ooooooool03?ooo`0306Kooooooooo06Goool008goool00`1Vooooooooo`05
oooo00<0I_ooooooool03?ooo`800003oooo00<0I_ooooooool03?ooo`0306Kooooooooo06Goool0
08goool00`1Vooooooooo`05oooo00<0I_ooooooool03?ooo`050000oooooooooooo06Ko00ooool0
0`1Vooooooooo`1Uoooo002=oooo00<0I_ooooooool01_ooo`0306Kooooooooo00_oool01@000?oo
ooooooooo`1Vo`0?oooo00<0I_ooooooool0IOooo`00S?ooo`0406Kooooooooooooo0P0000Coool2
00001Oooo`<00004oooo00D0003oooooooooool0I_l03oooo`0306Kooooooooo06Goool008coool0
101Vooooooooo`0000;oool01@000?ooooooooooo`1Vo`07oooo00<0003oooooool00oooo`040000
oooooooo06Ko4?ooo`0306Kooooooooo06Goool008coool0101Vooooooooo`0000;oool00`000?oo
ooooo`02oooo00@0I_ooooooooooool500001?ooo`8000000oooo`1Vooooo`0?oooo00<0I_oooooo
ool0IOooo`00ROooo`@00002oooo00@0003oooooool00004oooo00D0I_ooooooooooool000000_oo
o`030000oooooooo00?oool00`000?ooo`1Vo`0Aoooo00<0I_ooooooool0IOooo`00S?ooo`0406Ko
oooooooo00000_ooo`030000oooooooo00;oool00`1Vooooooooo`02oooo00<0003oool000001Ooo
o`030000oooo06Ko017oool00`1Vooooooooo`1Uoooo002<oooo00@0I_ooooooooooool200001_oo
o`0306Kooooooooo00;oool200001Oooo`03000006Kooooo017oool00`1Vooooooooo`1Uoooo002<
oooo00<0I_ooooooool02Oooo`0306Kooooooooo00Woool00`00001Vooooo`0Aoooo00<0I_oooooo
ool0IOooo`00Roooo`0306Kooooooooo00_oool00`1Vooooooooo`08oooo0P0001;oool00`1Voooo
ooooo`1Uoooo002;oooo00<0I_ooooooool02oooo`0306Kooooooooo00Soool00`000?ooooooo`0A
oooo00<0I_ooooooool0IOooo`00Roooo`0306Kooooooooo00coool00`1Vooooooooo`07oooo00<0
003oooooool04Oooo`0306Kooooooooo06Goool008_oool00`1Vooooooooo`0=oooo00<0I_oooooo
ool01_ooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo002;oooo00<0I_ooooooool03Ooo
o`0306Kooooooooo00Goool00`1Vo`000?ooo`0Boooo00<0I_ooooooool0IOooo`00Roooo`0306Ko
oooooooo00koool00`1Vooooooooo`04oooo00<0I_l0000000004_ooo`0306Kooooooooo06Goool0
08[oool00`1Vooooooooo`0@oooo00<0I_ooooooool00_ooo`0306Kooooo000001?oool00`1Voooo
ooooo`1Uoooo002:oooo00<0I_ooooooool04Oooo`D0I_l00oooo`000?ooo`0Boooo00<0I_oooooo
ool0IOooo`00R_ooo`0306Kooooooooo01Ooool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOoo
o`00R_ooo`0306Kooooooooo01Ooool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOooo`00R_oo
o`0306Kooooooooo01Ooool200004_ooo`0306Kooooooooo06Goool008[oool00`1Vooooooooo`0G
oooo00<0003oooooool04Oooo`0306Kooooooooo06Goool008Woool00`1Vooooooooo`0Hoooo00<0
003oooooool04Oooo`0306Kooooooooo06Goool008Woool00`1Vooooooooo`0Hoooo00<0003ooooo
ool04Oooo`0306Kooooooooo06Goool008Woool00`1Vooooooooo`0Hoooo00<0003oooooool04Ooo
o`0306Kooooooooo06Goool008Woool00`1Vooooooooo`0Hoooo0P0001;oool00`1Vooooooooo`1U
oooo0029oooo00<0I_ooooooool06?ooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo0028
oooo00<0I_ooooooool06Oooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo0028oooo00<0
I_ooooooool01Oooo`800004oooo0P0000Coool200001_ooo`030000oooooooo017oool00`1Voooo
ooooo`1Uoooo0028oooo00<0I_ooooooool01?ooo`040000oooooooo00002?ooo`040000oooooooo
00001Oooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo0028oooo00<0I_ooooooool01?oo
o`040000oooooooo00002_ooo`030000oooooooo00Coool200004_ooo`0306Kooooooooo06Goool0
08Ooool00`1Vooooo`00000300000_ooo`040000oooooooo00002oooo`030000oooooooo00?oool0
0`000?ooooooo`0Aoooo00<0I_ooooooool0IOooo`00Qoooo`0306Kooooooooo00Goool010000?oo
ooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOoo
o`00Qoooo`0306Kooooooooo00Koool200002_ooo`800006oooo00<0003oooooool04Oooo`0306Ko
oooooooo06Goool008Ooool00`1Vooooooooo`0Joooo00<0003oooooool04Oooo`0306Kooooooooo
06Goool008Ooool00`1Vooooooooo`0Joooo0P0001;oool00`1Vooooooooo`1Uoooo0026oooo00<0
I_ooooooool06oooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo0026oooo00<0I_oooooo
ool06oooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo0026oooo00<0I_ooooooool06ooo
o`030000oooooooo017oool00`1Vooooooooo`1Uoooo0026oooo00<0I_ooooooool06oooo`030000
oooooooo017oool00`1Vooooooooo`1Uoooo0026oooo00<0I_ooooooool06oooo`80000Boooo00<0
I_ooooooool0IOooo`00QOooo`0306Kooooooooo01coool00`000?ooooooo`0Aoooo00<0I_oooooo
ool0IOooo`00QOooo`0306Kooooooooo01coool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOoo
o`00QOooo`0306Kooooooooo01coool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOooo`00QOoo
o`0306Kooooooooo01coool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOooo`00Q?ooo`0306Ko
oooooooo01goool200004_ooo`0306Kooooooooo06Goool008Coool00`1Vooooooooo`0Moooo00<0
003oooooool04Oooo`0306Kooooooooo06Goool008Coool00`1Vooooooooo`0Moooo00<0003ooooo
ool04Oooo`0306Kooooooooo06Goool008Coool00`1Vooooooooo`0Moooo00<0003oooooool04Ooo
o`0306Kooooooooo06Goool008?oool00`1Vooooooooo`0Noooo00<0003oooooool04Oooo`0306Ko
oooooooo06Goool008?oool00`1Vooooooooo`0Noooo0P0001;oool00`1Vooooooooo`1Uoooo0023
oooo00<0I_ooooooool07_ooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo0023oooo00<0
I_ooooooool07_ooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo0022oooo00<0I_oooooo
ool02oooo`800004oooo0P0000?oool400001Oooo`030000oooooooo017oool00`1Vooooooooo`1U
oooo0022oooo00<0I_ooooooool02_ooo`040000oooooooo00002?ooo`030000oooooooo00Koool0
0`000?ooooooo`0Aoooo00<0I_ooooooool0IOooo`00P_ooo`0306Kooooooooo00[oool010000?oo
ooooo`0000Woool00`000?ooooooo`05oooo0P0001;oool00`1Vooooooooo`1Uoooo0021oooo00<0
I_ooooooool01Oooo`@00002oooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000
oooooooo017oool00`1Vooooooooo`1Uoooo0021oooo00<0I_ooooooool02oooo`040000oooooooo
00002?ooo`040000oooooooo00001Oooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo0021
oooo00<0I_ooooooool03?ooo`80000:oooo0P0000Koool00`000?ooooooo`0Aoooo00<0I_oooooo
ool0IOooo`00P?ooo`0306Kooooooooo027oool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOoo
o`00P?ooo`0306Kooooooooo027oool200004_ooo`0306Kooooooooo06Goool0083oool00`1Voooo
ooooo`0Qoooo00<0003oooooool04Oooo`0306Kooooooooo06Goool0083oool00`1Vooooooooo`0Q
oooo00<0003oooooool04Oooo`0306Kooooooooo06Goool007ooool00`1Vooooooooo`0Roooo00<0
003oooooool04Oooo`0306Kooooooooo06Goool007ooool00`1Vooooooooo`0Roooo00<0003ooooo
ool04Oooo`0306Kooooooooo06Goool007ooool00`1Vooooooooo`0Roooo0P0001;oool00`1Voooo
ooooo`1Uoooo001noooo00<0I_ooooooool08oooo`030000oooooooo017oool00`1Vooooooooo`1U
oooo001noooo00<0I_ooooooool08oooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo001m
oooo00<0I_ooooooool09?ooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo001moooo00<0
I_ooooooool09?ooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo001loooo00<0I_oooooo
ool09Oooo`80000Boooo00<0I_ooooooool0IOooo`00O?ooo`0306Kooooooooo02Goool00`000?oo
ooooo`0Aoooo00<0I_ooooooool0IOooo`00O?ooo`0306Kooooooooo02Goool00`000?ooooooo`0A
oooo00<0I_ooooooool0IOooo`00Noooo`0306Kooooooooo02Koool00`000?ooooooo`0Aoooo00<0
I_ooooooool0IOooo`00Noooo`0306Kooooooooo02Koool00`000?ooooooo`0Aoooo00<0I_oooooo
ool0IOooo`00N_ooo`0306Kooooooooo02Ooool200004_ooo`0306Kooooooooo06Goool007[oool0
0`1Vooooooooo`0Woooo00<0003oooooool04Oooo`0306Kooooooooo06Goool007Woool00`1Voooo
ooooo`0Doooo0P0000Coool200000oooo`D00004oooo00<0003oooooool04Oooo`0306Kooooooooo
06Goool007Woool00`1Vooooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool01?oo
o`030000oooooooo017oool00`1Vooooooooo`1Uoooo001hoooo00<0I_ooooooool05?ooo`040000
oooooooo00002_ooo`030000oooooooo00Coool200004_ooo`0306Kooooooooo06Goool007Soool0
0`1Vooooooooo`0>oooo100000;oool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0
003oooooool04Oooo`0306Kooooooooo06Goool007Ooool00`1Vooooooooo`0Eoooo00@0003ooooo
ool0000:oooo00<0003oooooool01?ooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo001f
oooo00<0I_ooooooool05oooo`80000:oooo0P0000Koool00`000?ooooooo`0Aoooo00<0I_oooooo
ool0IOooo`00MOooo`0306Kooooooooo02coool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOoo
o`00MOooo`0306Kooooooooo02coool200004_ooo`0306Kooooooooo06Goool007Coool00`1Voooo
ooooo`0]oooo00<0003oooooool04Oooo`0306Kooooooooo06Goool007?oool00`1Vooooooooo`0^
oooo00<0003oooooool04Oooo`0306Kooooooooo06Goool007;oool00`1Vooooooooo`0_oooo00<0
003oooooool04Oooo`0306Kooooooooo06Goool0077oool00`1Vooooooooo`0`oooo00<0003ooooo
ool04Oooo`0306Kooooooooo06Goool0073oool00`1Vooooooooo`0aoooo0P0001;oool00`1Voooo
ooooo`1Uoooo001_oooo00<0I_ooooooool0<_ooo`030000oooooooo017oool00`1Vooooooooo`1U
oooo001^oooo00<0I_ooooooool0<oooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo001^
oooo00<0I_ooooooool0<oooo`030000oooooooo017oool00`1Vooooooooo`1Uoooo000Yoooo0`00
02Soool300005_ooo`0306Kooooooooo00_oool400009Oooo`030000oooooooo017oool00`1Voooo
ooooo`0@oooo100002Ooool300009oooo`00:Oooo`040000oooooooo0000:?ooo`030000oooooooo
01?oool206Ko3_ooo`030000oooooooo02Koool200004_ooo`0306Kooooooooo013oool00`000?oo
ooooo`0Yoooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo00009Oooo`D0000Boooo0P1V
oa7oool00`000?ooooooo`0Uoooo00<0003oooooool04Oooo`0306Kooooooooo017oool00`000?oo
ooooo`0Uoooo1@0002Ooool002?oool400000_ooo`<0000Poooo100000;oool010000?ooooooo`00
017oool206Ko3?ooo`@00004oooo00<0003oooooool09?ooo`030000oooooooo017oool00`1Voooo
ooooo`0Boooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`00:_ooo`030000oooooooo
02Koool00`000?ooo`00000>oooo0`1VoaCoool010000?ooooooo`0002Goool00`000?ooooooo`0A
oooo00<0I_ooooooool04?ooo`040000oooooooo00009_ooo`030000oooo000002Soool002[oool3
00009oooo`80000<oooo0P1VoaSoool200009_ooo`030000oooooooo017oool00`1Vooooooooo`0A
oooo0P0002Soool20000:?ooo`00Goooo`<0I_m2oooo0P0001;oool00`1Vooooooooo`1Uoooo001M
oooo0P1VodGoool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOooo`00Eoooo`H0I_m7oooo00<0
003oooooool04Oooo`0306Kooooooooo06Goool005?oool406KoCOooo`030000oooooooo017oool0
0`1Vooooooooo`1Uoooo0016oooo3@1Voe7oool00`000?ooooooo`0Aoooo00<0I_ooooooool0IOoo
o`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oool00000300000Dco`000`0003?o
03?o0008<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0008<ol000<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo01;oool002Soool0
0`000?ooooooo`0Voooo00<0003oooooool08Oooo`H0000Y<ol000<0003oooooool04Oooo`03o`2I
oooooooo01;oool00`000?ooooooo`0Voooo00<0003oooooool09oooo`00N_ooo`<0000W<ol000<0
003oooooool04Oooo`03o`2Ioooooooo06Goool007goool200009C?o00030000oooooooo017oool0
0ol0VOooooooo`1Uoooo001ooooo00<0000co`0co`008S?o0080000Boooo00?o09Woooooool0IOoo
o`00P?ooo`030000<ol0<ol0024co`000`000?ooooooo`0Aoooo00?o09Woooooool0IOooo`00POoo
o`80000Q<ol000<0003oooooool04Oooo`03o`2Ioooooooo06Goool008?oool00`0003?o03?o000N
<ol000<0003oooooool04Oooo`03o`2Ioooooooo06Goool008?oool00`0003?o03?o000N<ol000<0
003oooooool04Oooo`03o`2Ioooooooo06Goool008Coool00`0003?o03?o000M<ol00P0001;oool0
0ol0VOooooooo`1Uoooo0025oooo00<0000co`0co`0073?o00030000oooooooo017oool00ol0VOoo
ooooo`1Uoooo0026oooo00<0000co`0co`006c?o00030000oooooooo017oool00ol0VOooooooo`1U
oooo0026oooo00<0000co`0co`006c?o00030000oooooooo017oool00ol0VOooooooo`1Uoooo0027
oooo7C?o07coool008SooolL<ol0O?ooo`00R?oooa`co`1loooo0028oooo73?o07coool008WooolK
<ol0O?ooo`00Ooooo`030000oooooooo00OooolE<ol000<0000co`0co`000c?o07coool007koool0
0`000?ooooooo`08oooo00<0000co`0co`004c?o00030000<ol0<ol0008co`1loooo001noooo00<0
003oooooool00_ooo`800004oooo00<0000co`0co`001S?o00@00003<ol00P0000@co`000`0003?o
03?o0002<ol0O?ooo`00O_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
000co`0co`001C?o00030000<ol0<ol000Xco`000`0003?o03?o0002<ol0O?ooo`00OOooo`030000
oooooooo00;oool00`000?ooooooo`06oooo23?o00030000<ol0<ol000Xco`00100003?o03?o03?o
07coool007koool00`000?ooooooo`0500001Oooo`Tco`000`0003?o03?o0008<ol000<0000co`0c
o`000S?o07coool007koool01@000?ooooooooooo`000009oooo1S?o00040000<ol0<ol000002C?o
00030000<ol0<ol0008co`1loooo001ooooo00<0003oooooool02_ooo`Lco`0200002C?o00030000
<ol0<ol000<co`1loooo002<oooo63?o07coool008cooolH<ol0O?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.57861 .57049 L
.61984 .57049 L
.65954 .57049 L
.67958 .57049 L
.6883 .57049 L
.69289 .57049 L
.6954 .57049 L
.69662 .57049 L
.69774 .57049 L
s
.69774 .57049 m
.69774 .61803 L
s
0 .4 1 r
.02381 .5703 m
.04262 .57022 L
.06244 .5701 L
.07286 .57003 L
.08255 .56994 L
.09388 .56981 L
.10458 .56967 L
.125 .56931 L
.14357 .56884 L
.16355 .56814 L
.18199 .56723 L
.20071 .56593 L
.21136 .56498 L
.22134 .5639 L
.24158 .56104 L
.26011 .55735 L
.27909 .55205 L
.28984 .54816 L
.29982 .54382 L
.32034 .53204 L
.33895 .51692 L
.35819 .49501 L
.36904 .47891 L
.37901 .46109 L
.39784 .41747 L
.40853 .38535 L
.4185 .34929 L
.43885 .2524 L
.44785 .19693 L
.45278 .1625 L
.45741 .12727 L
.45851 .11842 L
.45968 .10891 L
.46095 .10589 L
.46212 .11009 L
.46732 .12844 L
.4765 .15932 L
.49726 .2218 L
.51722 .271 L
.52593 .28862 L
.53536 .30467 L
.54061 .31204 L
.54545 .31772 L
.55008 .32204 L
.55264 .32392 L
.55497 .32528 L
.55616 .32584 L
.55746 .32634 L
.55817 .32657 L
.55883 .32674 L
Mistroke
.56013 .32699 L
.56135 .32711 L
.56246 .32712 L
.56375 .32699 L
.56495 .32675 L
.56559 .32656 L
.56629 .32632 L
.5677 .32568 L
.56901 .32491 L
.57023 .32402 L
.57298 .32139 L
.57593 .3175 L
.5785 .31306 L
.58123 .30743 L
.58612 .297 L
.59721 .27246 L
.61734 .22489 L
.65514 .13039 L
.67615 .08126 L
.68535 .06258 L
.69021 .05377 L
.69288 .04932 L
.6954 .04539 L
.69659 .04362 L
.69786 .04183 L
.69852 .57049 L
.69925 .57049 L
.70053 .57049 L
.70519 .57049 L
.71428 .57049 L
.73414 .57049 L
.77453 .57049 L
.8134 .57049 L
.85473 .57049 L
.89455 .57049 L
.93284 .57049 L
.97359 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo01coool00`1Vooooooooo`1Joooo002Toooo00<0
003oooooool06oooo`80I_mLoooo002Toooo00<0003oooooool06_ooo`0306Kooooo06Ko05coool0
0:Coool00`000?ooooooo`0Joooo00<0I_ooool0I_l0G?ooo`00Y?ooo`80000Koooo00<0I_ooool0
I_l0G?ooo`00Y?ooo`030000oooooooo01Woool0101Vooooooooo`1Voecoool00:Coool00`000?oo
ooooo`0Hoooo00D0I_ooooooooooool0I_l0G?ooo`00Y?ooo`030000oooooooo01Soool01@1Voooo
ooooooooo`1Vo`1Loooo002Toooo00<0003oooooool05oooo`0306Kooooooooo00;oool00`1Voooo
ooooo`1Joooo002Toooo0P0001Soool00`1Vooooooooo`02oooo00<0I_ooooooool0F_ooo`00Y?oo
o`030000oooooooo01Koool00`1Vooooooooo`03oooo00<0I_ooooooool0F_ooo`00Y?ooo`030000
oooooooo01Koool00`1Vooooooooo`03oooo00<0I_ooooooool0F_ooo`00T?ooo`800004oooo0P00
00Coool200001_ooo`030000oooooooo01Koool00`1Vooooooooo`03oooo00<0I_ooooooool0F_oo
o`00Soooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo01Goool0
0`1Vooooooooo`04oooo00<0I_ooooooool0F_ooo`00Soooo`040000oooooooo00002oooo`030000
oooooooo00?oool200005_ooo`0306Kooooooooo00Coool00`1Vooooooooo`1Joooo0029oooo1000
00;oool010000?ooooooo`0000Woool200001_ooo`030000oooooooo01Coool00`1Vooooooooo`05
oooo00<0I_ooooooool0F_ooo`00Soooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`0Doooo00<0I_ooooooool01Oooo`0306Kooooooooo05[oool008Goool00`1Voooo
ooooo`08oooo0P0000[oool300001Oooo`030000oooooooo01?oool00`1Vooooooooo`06oooo00<0
I_ooooooool0F_ooo`00Q?ooo`80I_lNoooo00<0003oooooool04oooo`0306Kooooooooo00Koool0
0`1Vooooooooo`1Joooo0024oooo0P1Voakoool200004oooo`0306Kooooooooo00Ooool00`1Voooo
ooooo`1Joooo0024oooo0P1Voakoool00`000?ooooooo`0Boooo00<0I_ooooooool01oooo`0306Ko
oooooooo05[oool008Coool00`1Vooooo`1Vo`0Moooo00<0003oooooool04Oooo`0306Kooooooooo
00Soool00`1Vooooooooo`1Joooo0024oooo00<0I_ooool0I_l07Oooo`030000oooooooo017oool0
0`1Vooooooooo`08oooo00<0I_ooooooool0F_ooo`00Q?ooo`0306Kooooo06Ko01goool00`000?oo
ooooo`0@oooo00<0I_ooooooool02Oooo`0306Kooooooooo05[oool008Coool00`1Vooooo`1Vo`0M
oooo0P00017oool00`1Vooooooooo`09oooo00<0I_ooooooool0F_ooo`00Q?ooo`0406Kooooooooo
06Ko7?ooo`030000oooooooo013oool00`1Vooooooooo`09oooo00<0I_ooooooool0F_ooo`00Q?oo
o`0406Kooooooooo06Ko7?ooo`030000oooooooo00ooool00`1Vooooooooo`0:oooo00<0I_oooooo
ool0F_ooo`00Q?ooo`0406Kooooooooo06Ko7?ooo`030000oooooooo00ooool00`1Vooooooooo`0:
oooo00<0I_ooooooool0F_ooo`00Poooo`0306Kooooooooo00;oool00`1Vooooooooo`0Ioooo00<0
003oooooool03_ooo`0306Kooooooooo00_oool00`1Vooooooooo`1Joooo0023oooo00<0I_oooooo
ool00_ooo`0306Kooooooooo01Woool200003oooo`0306Kooooooooo00_oool00`1Vooooooooo`1J
oooo0023oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0>oooo00<0
I_ooooooool02oooo`0306Kooooooooo05[oool008?oool00`1Vooooooooo`03oooo00<0I_oooooo
ool06?ooo`030000oooooooo00goool00`1Vooooooooo`0<oooo00<0I_ooooooool0F_ooo`00Pooo
o`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool03Oooo`0306Kooooooooo
00coool00`1Vooooooooo`1Joooo0023oooo00<0I_ooooooool01?ooo`0306Kooooooooo01Ooool0
0`000?ooooooo`0=oooo00<0I_ooooooool03?ooo`0306Kooooooooo05[oool008?oool00`1Voooo
ooooo`04oooo00<0I_ooooooool05oooo`80000=oooo00<0I_ooooooool03Oooo`0306Kooooooooo
05[oool008;oool00`1Vooooooooo`05oooo00<0I_ooooooool05oooo`030000oooooooo00coool0
0`1Vooooooooo`0=oooo00<0I_ooooooool0F_ooo`00P_ooo`0306Kooooooooo00Koool00`1Voooo
ooooo`0Foooo00<0003oooooool02oooo`0306Kooooooooo00koool00`1Vooooooooo`1Joooo0022
oooo00<0I_ooooooool01_ooo`0306Kooooooooo00;oool200001?ooo`800005oooo0`0000Coool0
0`000?ooooooo`0;oooo00<0I_ooooooool03_ooo`0306Kooooooooo05[oool008;oool00`1Voooo
ooooo`06oooo00D0I_ooooooooooool000000_ooo`030000oooooooo00Woool00`000?ooooooo`03
oooo00<0003oooooool02oooo`0306Kooooooooo00koool00`1Vooooooooo`1Joooo0021oooo00<0
I_ooooooool01oooo`0506Kooooooooooooo000000;oool00`000?ooooooo`06oooo1@0000Coool2
00002oooo`0306Kooooooooo00ooool00`1Vooooooooo`1Joooo0021oooo00<0I_ooooooool01Ooo
o`@00002oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool02_oo
o`0306Kooooooooo00ooool00`1Vooooooooo`1Joooo0021oooo00<0I_ooooooool02?ooo`0406Ko
oooooooo00000_ooo`030000oooooooo00Ooool00`000?ooo`000005oooo00<0003oooooool02_oo
o`0306Kooooooooo00ooool00`1Vooooooooo`1Joooo0021oooo00<0I_ooooooool02?ooo`0406Ko
oooooooooooo0P0000_oool200001Oooo`030000oooooooo00Woool00`1Vooooooooo`0@oooo00<0
I_ooooooool0F_ooo`00POooo`0306Kooooooooo00Woool00`1Vooooooooo`0Doooo00<0003ooooo
ool02Oooo`0306Kooooooooo013oool00`1Vooooooooo`1Joooo0021oooo00<0I_ooooooool02Ooo
o`0306Kooooooooo01Coool200002Oooo`0306Kooooooooo017oool00`1Vooooooooo`1Joooo0020
oooo00<0I_ooooooool02_ooo`0306Kooooooooo01Coool00`000?ooooooo`08oooo00<0I_oooooo
ool04Oooo`0306Kooooooooo05[oool0083oool00`1Vooooooooo`0;oooo00<0I_ooooooool04ooo
o`030000oooooooo00Soool00`1Vooooooooo`0Aoooo00<0I_ooooooool0F_ooo`00P?ooo`0306Ko
oooooooo00_oool00`1Vooooooooo`0Coooo00<0003oooooool01oooo`0306Kooooooooo01;oool0
0`1Vooooooooo`1Joooo0020oooo00<0I_ooooooool02oooo`0306Kooooooooo01?oool00`000?oo
ooooo`07oooo00<0I_ooooooool04_ooo`0306Kooooooooo05[oool0083oool00`1Vooooooooo`0<
oooo00<0I_ooooooool04_ooo`800008oooo00<0I_ooooooool04_ooo`0306Kooooooooo05[oool0
083oool00`1Vooooooooo`0<oooo00<0I_ooooooool04_ooo`030000oooooooo00Koool00`1Voooo
ooooo`0Coooo00<0I_ooooooool0F_ooo`00P?ooo`0306Kooooooooo00goool00`1Vooooooooo`0A
oooo00<0003oooooool01_ooo`0306Kooooooooo01?oool00`1Vooooooooo`1Joooo001ooooo00<0
I_ooooooool03_ooo`0306Kooooooooo017oool00`000?ooooooo`05oooo00<0I_ooooooool05?oo
o`0306Kooooooooo05[oool007ooool00`1Vooooooooo`0>oooo00<0I_ooooooool04Oooo`030000
oooooooo00Goool00`1Vooooooooo`0Doooo00<0I_ooooooool0F_ooo`00Ooooo`0306Kooooooooo
00ooool00`1Vooooooooo`0@oooo0P0000Goool00`1Vooooooooo`0Eoooo00<0I_ooooooool0F_oo
o`00Ooooo`0306Kooooooooo00ooool00`1Vooooooooo`0@oooo00<0003oooooool01?ooo`0306Ko
oooooooo01Goool00`1Vooooooooo`1Joooo001ooooo00<0I_ooooooool03oooo`0306Kooooooooo
013oool00`000?ooooooo`03oooo00<0I_ooooooool05_ooo`0306Kooooooooo05[oool007ooool0
0`1Vooooooooo`0@oooo00<0I_ooooooool03oooo`030000oooooooo00?oool00`1Vooooooooo`0F
oooo00<0I_ooooooool0F_ooo`00O_ooo`0306Kooooooooo017oool00`1Vooooooooo`0?oooo00<0
003oooooool00_ooo`0306Kooooooooo01Ooool00`1Vooooooooo`1Joooo001noooo00<0I_oooooo
ool04_ooo`0306Kooooooooo00koool200000oooo`0306Kooooooooo01Ooool00`1Vooooooooo`1J
oooo001noooo00<0I_ooooooool04_ooo`0306Kooooooooo00koool01@000?ooooooooooo`1Vo`0J
oooo00<0I_ooooooool0F_ooo`00O_ooo`0306Kooooooooo01?oool00`1Vooooooooo`0=oooo00D0
003oooooooooool0I_l06_ooo`0306Kooooooooo05[oool007koool00`1Vooooooooo`0?oooo0P00
00;oool0101Vooooo`00000000Coool200001_ooo`040000oooooooo06Ko6oooo`0306Kooooooooo
05[oool007goool00`1Vooooooooo`0?oooo00@0003oooooool00002oooo00<0I_ooooooool00ooo
o`040000oooooooo00001Oooo`040000oooooooo06Ko6oooo`0306Kooooooooo05[oool007goool0
0`1Vooooooooo`0?oooo00@0003oooooool00002oooo00<0I_ooooooool01Oooo`030000oooooooo
00Coool2000000<0I_ooooooool06_ooo`0306Kooooooooo05[oool007goool00`1Vooooooooo`09
oooo100000;oool010000?ooooooo`0000?oool00`1Vooooooooo`05oooo00<0003oooooool00ooo
o`030000oooo06Ko01coool00`1Vooooooooo`1Joooo001moooo00<0I_ooooooool03oooo`040000
oooooooo00000oooo`0306Kooooooooo00;oool010000?ooooooo`0000Goool00`00001Vooooo`0L
oooo00<0I_ooooooool0F_ooo`00OOooo`0306Kooooooooo013oool200001Oooo`0306Kooooooooo
00;oool200001_ooo`03000006Kooooo01coool00`1Vooooooooo`1Joooo001loooo00<0I_oooooo
ool06?ooo`0306Kooooooooo00[oool00`00001Vooooo`0Loooo00<0I_ooooooool0F_ooo`00O?oo
o`0306Kooooooooo01Woool00`1Vooooooooo`09oooo0P0001goool00`1Vooooooooo`1Joooo001l
oooo00<0I_ooooooool06_ooo`0306Kooooooooo00Soool00`000?ooooooo`0Loooo00<0I_oooooo
ool0F_ooo`00O?ooo`0306Kooooooooo01_oool00`1Vooooooooo`06oooo00<0I_l0003oool07Ooo
o`0306Kooooooooo05[oool007coool00`1Vooooooooo`0Loooo00<0I_ooooooool01Oooo`0306Ko
0000oooo01goool00`1Vooooooooo`1Joooo001loooo00<0I_ooooooool07?ooo`0306Kooooooooo
00Coool00`1Vooooo`00000Noooo00<0I_ooooooool0F_ooo`00Noooo`0306Kooooooooo01koool2
06Ko0oooo`0306Kooooooooo0080000Moooo00<0I_ooooooool0F_ooo`00Noooo`0306Kooooooooo
023oool306Ko0oooo`030000oooooooo01coool00`1Vooooooooo`1Joooo001koooo00<0I_oooooo
ool09_ooo`030000oooooooo01coool00`1Vooooooooo`1Joooo001koooo00<0I_ooooooool09_oo
o`030000oooooooo01coool00`1Vooooooooo`1Joooo001koooo00<0I_ooooooool09_ooo`030000
oooooooo01coool00`1Vooooooooo`1Joooo001joooo00<0I_ooooooool09oooo`80000Moooo00<0
I_ooooooool0F_ooo`00N_ooo`0306Kooooooooo02Ooool00`000?ooooooo`0Loooo00<0I_oooooo
ool0F_ooo`00N_ooo`0306Kooooooooo02Ooool00`000?ooooooo`0Loooo00<0I_ooooooool0F_oo
o`00N_ooo`0306Kooooooooo02Ooool00`000?ooooooo`0Loooo00<0I_ooooooool0F_ooo`00NOoo
o`0306Kooooooooo02Soool00`000?ooooooo`0Loooo00<0I_ooooooool0F_ooo`00NOooo`0306Ko
oooooooo02Soool200007Oooo`0306Kooooooooo05[oool007Woool00`1Vooooooooo`0Xoooo00<0
003oooooool07?ooo`0306Kooooooooo05[oool007Soool00`1Vooooooooo`0Yoooo00<0003ooooo
ool07?ooo`0306Kooooooooo05[oool007Soool00`1Vooooooooo`0Eoooo0P0000Coool200000ooo
o`@00005oooo00<0003oooooool07?ooo`0306Kooooooooo05[oool007Soool00`1Vooooooooo`0D
oooo00@0003oooooool00008oooo00<0003oooooool01_ooo`030000oooooooo01coool00`1Voooo
ooooo`1Joooo001goooo00<0I_ooooooool05Oooo`040000oooooooo00002Oooo`030000oooooooo
00Goool200007Oooo`0306Kooooooooo05[oool007Ooool00`1Vooooooooo`0?oooo100000;oool0
10000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool07?ooo`0306Kooooooooo
05[oool007Ooool00`1Vooooooooo`0Eoooo00@0003oooooool00008oooo00@0003oooooool00005
oooo00<0003oooooool07?ooo`0306Kooooooooo05[oool007Koool00`1Vooooooooo`0Goooo0P00
00[oool200001_ooo`030000oooooooo01coool00`1Vooooooooo`1Joooo001foooo00<0I_oooooo
ool0:oooo`030000oooooooo01coool00`1Vooooooooo`1Joooo001eoooo00<0I_ooooooool0;?oo
o`80000Moooo00<0I_ooooooool0F_ooo`00MOooo`0306Kooooooooo02coool00`000?ooooooo`0L
oooo00<0I_ooooooool0F_ooo`00MOooo`0306Kooooooooo02coool00`000?ooooooo`0Loooo00<0
I_ooooooool0F_ooo`00M?ooo`0306Kooooooooo02goool00`000?ooooooo`0Loooo00<0I_oooooo
ool0F_ooo`00M?ooo`0306Kooooooooo02goool00`000?ooooooo`0Loooo00<0I_ooooooool0F_oo
o`00M?ooo`0306Kooooooooo02goool200007Oooo`0306Kooooooooo05[oool007?oool00`1Voooo
ooooo`0^oooo00<0003oooooool07?ooo`0306Kooooooooo05[oool007?oool00`1Vooooooooo`0^
oooo00<0003oooooool07?ooo`0306Kooooooooo05[oool007;oool00`1Vooooooooo`0_oooo00<0
003oooooool07?ooo`0306Kooooooooo05[oool007;oool00`1Vooooooooo`0_oooo00<0003ooooo
ool07?ooo`0306Kooooooooo05[oool0077oool00`1Vooooooooo`0`oooo0P0001goool00`1Voooo
ooooo`1Joooo001aoooo00<0I_ooooooool0<?ooo`030000oooooooo01coool00`1Vooooooooo`1J
oooo001aoooo00<0I_ooooooool0<?ooo`030000oooooooo01coool00`1Vooooooooo`1Joooo001`
oooo00<0I_ooooooool0<Oooo`030000oooooooo01coool00`1Vooooooooo`1Joooo001`oooo00<0
I_ooooooool0<Oooo`030000oooooooo01coool00`1Vooooooooo`1Joooo001_oooo00<0I_oooooo
ool0<_ooo`80000Moooo00<0I_ooooooool0F_ooo`00Koooo`0306Kooooooooo03;oool00`000?oo
ooooo`0Loooo00<0I_ooooooool0F_ooo`00K_ooo`0306Kooooooooo01ooool200001?ooo`800003
oooo1@0000Coool00`000?ooooooo`0Loooo00<0I_ooooooool0F_ooo`00K_ooo`0306Kooooooooo
01koool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool07?ooo`0306Ko
oooooooo05[oool006goool00`1Vooooooooo`0Ooooo00@0003oooooool0000:oooo00<0003ooooo
ool01?ooo`80000Moooo00<0I_ooooooool0F_ooo`00KOooo`0306Kooooooooo01Woool400000_oo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`0Loooo00<0I_oooooo
ool0F_ooo`00K?ooo`0306Kooooooooo023oool010000?ooooooo`0000[oool00`000?ooooooo`04
oooo00<0003oooooool07?ooo`0306Kooooooooo05[oool006coool00`1Vooooooooo`0Qoooo0P00
00[oool200001_ooo`030000oooooooo01coool00`1Vooooooooo`1Joooo001[oooo00<0I_oooooo
ool0=_ooo`030000oooooooo01coool00`1Vooooooooo`1Joooo001[oooo00<0I_ooooooool0=_oo
o`80000Moooo00<0I_ooooooool0F_ooo`00J_ooo`0306Kooooooooo03Ooool00`000?ooooooo`0L
oooo00<0I_ooooooool0F_ooo`00JOooo`0306Kooooooooo03Soool00`000?ooooooo`0Loooo00<0
I_ooooooool0F_ooo`00J?ooo`0306Kooooooooo03Woool00`000?ooooooo`0Loooo00<0I_oooooo
ool0F_ooo`00Ioooo`0306Kooooooooo03[oool00`000?ooooooo`0Loooo00<0I_ooooooool0F_oo
o`00I_ooo`0306Kooooooooo03_oool200007Oooo`0306Kooooooooo05[oool006Goool00`1Voooo
ooooo`0loooo00<0003oooooool07?ooo`0306Kooooooooo05[oool006Coool00`1Vooooooooo`0m
oooo00<0003oooooool07?ooo`0306Kooooooooo05[oool006;oool206Ko@?ooo`030000oooooooo
01coool00`1Vooooooooo`1Joooo000Yoooo0`0002Soool300002_ooo`0306Kooooooooo01Ooool4
00009Oooo`030000oooooooo01coool00`1Vooooooooo`05oooo100002Ooool300009oooo`00:Ooo
o`040000oooooooo0000:?ooo`030000oooooooo00Soool00`1Vooooooooo`0Hoooo00<0003ooooo
ool09_ooo`80000Moooo00<0I_ooooooool01Oooo`030000oooooooo02Woool00`000?ooooooo`0V
oooo000Yoooo00@0003oooooool0000Uoooo1@0000Ooool206Ko7?ooo`030000oooooooo02Goool0
0`000?ooooooo`0Loooo00<0I_ooooooool01_ooo`030000oooooooo02Goool500009oooo`008ooo
o`@00002oooo0`00023oool400000_ooo`040000oooooooo00001_ooo`80I_lGoooo100000Coool0
0`000?ooooooo`0Toooo00<0003oooooool07?ooo`0306Kooooooooo00Ooool00`000?ooooooo`0T
oooo00@0003oooooool0000Xoooo000Zoooo00<0003oooooool09_ooo`030000oooo000000Coool2
06Ko7oooo`040000oooooooo00009Oooo`030000oooooooo01coool00`1Vooooooooo`05oooo00@0
003oooooool0000Voooo00<0003oool00000:?ooo`00:_ooo`<0000Woooo0P000004oooo06Ko06Ko
06Ko8_ooo`80000Voooo00<0003oooooool07?ooo`0306Kooooooooo00Koool20000:?ooo`80000X
oooo001Doooo0`1Vodgoool200007Oooo`0306Kooooooooo05[oool005;oool206KoD?ooo`030000
oooooooo01coool00`1Vooooooooo`1Joooo001?oooo0`1Voe;oool00`000?ooooooo`0Loooo00<0
I_ooooooool0F_ooo`00B_ooo`D0I_mEoooo00<0003oooooool07?ooo`0306Kooooooooo05[oool0
03[oool@06KoF_ooo`030000oooooooo01coool00`1Vooooooooo`1Joooo000=ooooo`0000H0000>
oooo000Coooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01ooo
o`030000oooooooo00Soool00`000?ooo`00000<00001C?o00030000<ol0<ol000Pco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Pco`000`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01ooo
o`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Soool00`000?ooooooo`07oooo00<0003oooooool04_ooo`00:?ooo`030000oooooooo02Koool0
0`000?ooooooo`0Qoooo1P0002Tco`000`000?ooooooo`0Loooo00?o09Woooooool01oooo`030000
oooooooo02Koool00`000?ooooooo`0Woooo001joooo0`0002Lco`000`000?ooooooo`0Loooo00?o
09Woooooool0F_ooo`00OOooo`80000U<ol000<0003oooooool07?ooo`03o`2Ioooooooo05[oool0
07ooool00`0003?o03?o000R<ol00P0001goool00ol0VOooooooo`1Joooo0020oooo00<0000co`0c
o`008C?o00030000oooooooo01coool00ol0VOooooooo`1Joooo0021oooo0P00024co`000`000?oo
ooooo`0Loooo00?o09Woooooool0F_ooo`00Poooo`030000<ol0<ol001hco`000`000?ooooooo`0L
oooo00?o09Woooooool0F_ooo`00Poooo`030000<ol0<ol001hco`000`000?ooooooo`0Loooo00?o
09Woooooool0F_ooo`00Q?ooo`030000<ol0<ol001dco`0200007Oooo`03o`2Ioooooooo05[oool0
08Goool00`0003?o03?o000L<ol000<0003oooooool07?ooo`03o`2Ioooooooo05[oool008Koool0
0`0003?o03?o000K<ol000<0003oooooool07?ooo`03o`2Ioooooooo05[oool008Koool00`0003?o
03?o000K<ol000<0003oooooool07?ooo`03o`2Ioooooooo05[oool008OooolM<ol0O?ooo`00R?oo
oa`co`1loooo0028oooo73?o07coool008SooolL<ol0O?ooo`00ROoooa/co`1loooo001loooo00<0
003oooooool02_oooaPco`000`0003?o03?o001loooo001koooo00<0003oooooool02?ooo`040000
oooooooooooo63?o00030000<ol0oooo07_oool007_oool00`000?ooooooo`02oooo0P0000Coool0
10000?ooooooooooo`Dco`0400000c?o00800004<ol00P0000@co`000`0003?o0?ooo`1koooo001k
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool010000?ooooooooooo`@co`00
0`0003?o03?o0009<ol000@0000co`0co`000003<ol000<0000co`3oool0Noooo`00N_ooo`030000
oooooooo00;oool00`000?ooooooo`09oooo1C?o00030000<ol0<ol000/co`000`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Noooo`030000oooooooo00D00008oooo1S?o00030000<ol0<ol0
00Pco`02000013?o00030000<ol0oooo07_oool007_oool01@000?ooooooooooo`00000<oooo0c?o
00040000<ol0<ol000002C?o00030000<ol0<ol000<co`000`0003?o0?ooo`1koooo001loooo00<0
003oooooool03Oooo`@co`0200002S?o00<00002<ol000<0000co`0co`00O?ooo`00S?oooaPco`1l
oooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.57861 .57049 L
.61984 .57049 L
.65954 .57049 L
.69774 .57049 L
.71741 .57049 L
.72307 .57049 L
.72841 .57049 L
.7332 .57049 L
.73451 .57049 L
.7359 .57049 L
.73708 .57049 L
s
.73708 .57049 m
.73709 .61803 L
s
0 .4 1 r
.02381 .5701 m
.04262 .56994 L
.06244 .5697 L
.07286 .56954 L
.08255 .56937 L
.09388 .56911 L
.10458 .56882 L
.125 .56809 L
.14357 .56715 L
.16355 .56572 L
.18199 .56386 L
.20071 .56124 L
.21136 .5593 L
.22134 .55712 L
.24158 .55131 L
.26011 .54381 L
.27909 .53307 L
.28984 .52518 L
.29982 .51636 L
.32034 .49246 L
.33895 .46178 L
.35819 .4173 L
.36904 .38464 L
.37901 .34847 L
.39784 .25994 L
.40853 .19476 L
.41371 .15837 L
.4185 .12158 L
.41975 .11144 L
.42093 .10524 L
.42215 .10971 L
.42351 .1146 L
.42895 .13395 L
.43885 .16758 L
.45741 .22513 L
.4961 .32128 L
.51614 .35792 L
.52634 .37277 L
.53195 .37971 L
.53724 .3854 L
.5422 .38991 L
.54758 .3938 L
.54996 .39515 L
.55247 .39632 L
.55462 .3971 L
.55584 .39744 L
.55698 .39769 L
.55811 .39787 L
.55935 .39799 L
.56052 .39803 L
Mistroke
.56161 .398 L
.56268 .39789 L
.56365 .39773 L
.56478 .39747 L
.56583 .39715 L
.56822 .39614 L
.57041 .39483 L
.57281 .39292 L
.57535 .39033 L
.58032 .38323 L
.58485 .37572 L
.59502 .35799 L
.61337 .32295 L
.65327 .23401 L
.69165 .13825 L
.71107 .09177 L
.72138 .06971 L
.72679 .05929 L
.73248 .04945 L
.73493 .04561 L
.73628 .04362 L
.73755 .04182 L
.73827 .57049 L
.73905 .57049 L
.74041 .57049 L
.74308 .57049 L
.75278 .57049 L
.7718 .57049 L
.81277 .57049 L
.85223 .57049 L
.89017 .57049 L
.93056 .57049 L
.96944 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo02Koool00`1Vooooooooo`1@oooo002Toooo00<0
003oooooool09Oooo`80I_mBoooo002Toooo00<0003oooooool09Oooo`80I_mBoooo002Toooo00<0
003oooooool09?ooo`0306Kooooo06Ko05;oool00:Coool200009Oooo`0306Kooooo06Ko05;oool0
0:Coool00`000?ooooooo`0Soooo00@0I_ooooooool0I_mBoooo002Toooo00<0003oooooool08ooo
o`0406Kooooooooo06KoD_ooo`00Y?ooo`030000oooooooo02;oool01@1Vooooooooooooo`1Vo`1B
oooo002Toooo00<0003oooooool08_ooo`0506Kooooooooooooo06Ko05;oool00:Coool200008_oo
o`0306Kooooooooo00;oool00`1Vooooooooo`1@oooo002Toooo00<0003oooooool08Oooo`0306Ko
oooooooo00;oool00`1Vooooooooo`1@oooo002Toooo00<0003oooooool08?ooo`0306Kooooooooo
00?oool00`1Vooooooooo`1@oooo002@oooo0P0000Coool200001?ooo`800006oooo00<0003ooooo
ool08?ooo`0306Kooooooooo00?oool00`1Vooooooooo`1@oooo002?oooo00@0003oooooool00008
oooo00@0003oooooool00005oooo00<0003oooooool07oooo`0306Kooooooooo00Coool00`1Voooo
ooooo`1@oooo002?oooo00@0003oooooool0000;oooo00<0003oooooool00oooo`80000Poooo00<0
I_ooooooool01?ooo`0306Kooooooooo053oool008Woool400000_ooo`040000oooooooo00002Ooo
o`800006oooo00<0003oooooool07_ooo`0306Kooooooooo00Goool00`1Vooooooooo`1@oooo002?
oooo00@0003oooooool00009oooo00<0003oooooool01Oooo`030000oooooooo01koool00`1Voooo
ooooo`05oooo00<0I_ooooooool0D?ooo`00N_ooo`0306Kooooooooo01?oool200002_ooo`<00005
oooo00<0003oooooool07Oooo`0306Kooooooooo00Koool00`1Vooooooooo`1@oooo001joooo0P1V
obSoool00`000?ooooooo`0Moooo00<0I_ooooooool01_ooo`0306Kooooooooo053oool007[oool2
06Ko:?ooo`80000Noooo00<0I_ooooooool01_ooo`0306Kooooooooo053oool007[oool206Ko:?oo
o`030000oooooooo01coool00`1Vooooooooo`07oooo00<0I_ooooooool0D?ooo`00N_ooo`80I_lX
oooo00<0003oooooool07?ooo`0306Kooooooooo00Ooool00`1Vooooooooo`1@oooo001joooo00<0
I_ooool0I_l09oooo`030000oooooooo01coool00`1Vooooooooo`07oooo00<0I_ooooooool0D?oo
o`00N_ooo`0306Kooooo06Ko02Ooool00`000?ooooooo`0Koooo00<0I_ooooooool02?ooo`0306Ko
oooooooo053oool007Woool0101Vooooooooo`1VobOoool200007?ooo`0306Kooooooooo00Soool0
0`1Vooooooooo`1@oooo001ioooo00@0I_ooooooool0I_lWoooo00<0003oooooool06_ooo`0306Ko
oooooooo00Woool00`1Vooooooooo`1@oooo001ioooo00D0I_ooooooooooool0I_l09_ooo`030000
oooooooo01[oool00`1Vooooooooo`09oooo00<0I_ooooooool0D?ooo`00NOooo`0506Kooooooooo
oooo06Ko02Koool00`000?ooooooo`0Joooo00<0I_ooooooool02Oooo`0306Kooooooooo053oool0
07Woool01@1Vooooooooooooo`1Vo`0Voooo00<0003oooooool06Oooo`0306Kooooooooo00[oool0
0`1Vooooooooo`1@oooo001hoooo00<0I_ooooooool00oooo`0306Kooooooooo02?oool200006_oo
o`0306Kooooooooo00[oool00`1Vooooooooo`1@oooo001hoooo00<0I_ooooooool00oooo`0306Ko
oooooooo02?oool00`000?ooooooo`0Hoooo00<0I_ooooooool02oooo`0306Kooooooooo053oool0
07Soool00`1Vooooooooo`03oooo00<0I_ooooooool08oooo`030000oooooooo01Soool00`1Voooo
ooooo`0;oooo00<0I_ooooooool0D?ooo`00N?ooo`0306Kooooooooo00Coool00`1Vooooooooo`0R
oooo00<0003oooooool06?ooo`0306Kooooooooo00_oool00`1Vooooooooo`1@oooo001hoooo00<0
I_ooooooool01?ooo`0306Kooooooooo02;oool00`000?ooooooo`0Goooo00<0I_ooooooool03?oo
o`0306Kooooooooo053oool007Soool00`1Vooooooooo`04oooo00<0I_ooooooool08_ooo`80000H
oooo00<0I_ooooooool03?ooo`0306Kooooooooo053oool007Soool00`1Vooooooooo`05oooo00<0
I_ooooooool08Oooo`030000oooooooo01Koool00`1Vooooooooo`0=oooo00<0I_ooooooool0D?oo
o`00Moooo`0306Kooooooooo00Koool00`1Vooooooooo`0Qoooo00<0003oooooool05_ooo`0306Ko
oooooooo00goool00`1Vooooooooo`1@oooo001goooo00<0I_ooooooool01_ooo`0306Kooooooooo
00goool200001?ooo`800005oooo0`0000Coool00`000?ooooooo`0Foooo00<0I_ooooooool03Ooo
o`0306Kooooooooo053oool007Ooool00`1Vooooooooo`07oooo00<0I_ooooooool02oooo`040000
oooooooo00002oooo`030000oooooooo00?oool00`000?ooooooo`0Eoooo00<0I_ooooooool03_oo
o`0306Kooooooooo053oool007Ooool00`1Vooooooooo`07oooo00<0I_ooooooool02oooo`040000
oooooooo00002?ooo`D00004oooo0P0001Koool00`1Vooooooooo`0>oooo00<0I_ooooooool0D?oo
o`00Moooo`0306Kooooooooo00Ooool00`1Vooooooooo`05oooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Goool00`000?ooooooo`0Doooo00<0I_ooooooool03oooo`0306Ko
oooooooo053oool007Ooool00`1Vooooooooo`08oooo00<0I_ooooooool02_ooo`040000oooooooo
00002Oooo`030000oooo000000Goool00`000?ooooooo`0Doooo00<0I_ooooooool03oooo`0306Ko
oooooooo053oool007Ooool00`1Vooooooooo`08oooo00<0I_ooooooool02oooo`80000;oooo0P00
00Goool00`000?ooooooo`0Doooo00<0I_ooooooool03oooo`0306Kooooooooo053oool007Koool0
0`1Vooooooooo`09oooo00<0I_ooooooool07oooo`030000oooooooo01?oool00`1Vooooooooo`0@
oooo00<0I_ooooooool0D?ooo`00M_ooo`0306Kooooooooo00[oool00`1Vooooooooo`0Noooo0P00
01Coool00`1Vooooooooo`0@oooo00<0I_ooooooool0D?ooo`00M_ooo`0306Kooooooooo00[oool0
0`1Vooooooooo`0Noooo00<0003oooooool04_ooo`0306Kooooooooo017oool00`1Vooooooooo`1@
oooo001foooo00<0I_ooooooool02_ooo`0306Kooooooooo01koool00`000?ooooooo`0Boooo00<0
I_ooooooool04Oooo`0306Kooooooooo053oool007Koool00`1Vooooooooo`0;oooo00<0I_oooooo
ool07Oooo`030000oooooooo01;oool00`1Vooooooooo`0Aoooo00<0I_ooooooool0D?ooo`00M_oo
o`0306Kooooooooo00_oool00`1Vooooooooo`0Moooo00<0003oooooool04Oooo`0306Kooooooooo
01;oool00`1Vooooooooo`1@oooo001eoooo00<0I_ooooooool03?ooo`0306Kooooooooo01goool2
00004_ooo`0306Kooooooooo01;oool00`1Vooooooooo`1@oooo001eoooo00<0I_ooooooool03Ooo
o`0306Kooooooooo01coool00`000?ooooooo`0@oooo00<0I_ooooooool04oooo`0306Kooooooooo
053oool007Goool00`1Vooooooooo`0=oooo00<0I_ooooooool07?ooo`030000oooooooo013oool0
0`1Vooooooooo`0Coooo00<0I_ooooooool0D?ooo`00MOooo`0306Kooooooooo00koool00`1Voooo
ooooo`0Koooo00<0003oooooool04?ooo`0306Kooooooooo01?oool00`1Vooooooooo`1@oooo001e
oooo00<0I_ooooooool03_ooo`0306Kooooooooo01_oool00`000?ooooooo`0?oooo00<0I_oooooo
ool05?ooo`0306Kooooooooo053oool007Goool00`1Vooooooooo`0>oooo00<0I_ooooooool06ooo
o`80000@oooo00<0I_ooooooool05?ooo`0306Kooooooooo053oool007Coool00`1Vooooooooo`0@
oooo00<0I_ooooooool06_ooo`030000oooooooo00koool00`1Vooooooooo`0Eoooo00<0I_oooooo
ool0D?ooo`00M?ooo`0306Kooooooooo013oool00`1Vooooooooo`0Joooo00<0003oooooool03_oo
o`0306Kooooooooo01Goool00`1Vooooooooo`1@oooo001doooo00<0I_ooooooool04Oooo`0306Ko
oooooooo01Woool00`000?ooooooo`0=oooo00<0I_ooooooool05_ooo`0306Kooooooooo053oool0
07Coool00`1Vooooooooo`0Aoooo00<0I_ooooooool06Oooo`030000oooooooo00goool00`1Voooo
ooooo`0Foooo00<0I_ooooooool0D?ooo`00M?ooo`0306Kooooooooo017oool00`1Vooooooooo`0I
oooo0P0000koool00`1Vooooooooo`0Foooo00<0I_ooooooool0D?ooo`00Loooo`0306Kooooooooo
01?oool00`1Vooooooooo`0Hoooo00<0003oooooool03?ooo`0306Kooooooooo01Ooool00`1Voooo
ooooo`1@oooo001coooo00<0I_ooooooool04oooo`0306Kooooooooo01Soool00`000?ooooooo`0<
oooo00<0I_ooooooool05oooo`0306Kooooooooo053oool007?oool00`1Vooooooooo`0Doooo00<0
I_ooooooool00oooo`800004oooo0P0000Coool200001_ooo`030000oooooooo00_oool00`1Voooo
ooooo`0Hoooo00<0I_ooooooool0D?ooo`00Loooo`0306Kooooooooo01Coool00`1Vooooooooo`02
oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool02oooo`0306Ko
oooooooo01Soool00`1Vooooooooo`1@oooo001boooo00<0I_ooooooool05Oooo`0306Kooooooooo
00;oool010000?ooooooo`0000[oool00`000?ooooooo`04oooo0P0000_oool00`1Vooooooooo`0I
oooo00<0I_ooooooool0D?ooo`00L_ooo`0306Kooooooooo01Coool400000_ooo`040000oooooooo
00002oooo`030000oooooooo00?oool00`000?ooooooo`0:oooo00<0I_ooooooool06Oooo`0306Ko
oooooooo053oool007;oool00`1Vooooooooo`0Foooo00D0I_ooooooooooool000000_ooo`030000
oooooooo00Koool010000?ooooooo`0000Goool00`000?ooooooo`09oooo00<0I_ooooooool06_oo
o`0306Kooooooooo053oool007;oool00`1Vooooooooo`0Goooo00@0I_ooooooooooool200002_oo
o`800006oooo00<0003oooooool02Oooo`0306Kooooooooo01[oool00`1Vooooooooo`1@oooo001b
oooo00<0I_ooooooool05oooo`0306Kooooooooo01Goool00`000?ooooooo`09oooo00<0I_oooooo
ool06_ooo`0306Kooooooooo053oool0077oool00`1Vooooooooo`0Hoooo00<0I_ooooooool05Ooo
o`800009oooo00<0I_ooooooool06oooo`0306Kooooooooo053oool0077oool00`1Vooooooooo`0I
oooo00<0I_ooooooool05?ooo`030000oooooooo00Soool00`1Vooooooooo`0Koooo00<0I_oooooo
ool0D?ooo`00LOooo`0306Kooooooooo01Woool00`1Vooooooooo`0Doooo00<0003oooooool01ooo
o`0306Kooooooooo01coool00`1Vooooooooo`1@oooo001aoooo00<0I_ooooooool06_ooo`0306Ko
oooooooo01?oool00`000?ooooooo`07oooo00<0I_ooooooool07?ooo`0306Kooooooooo053oool0
077oool00`1Vooooooooo`0Joooo00<0I_ooooooool04oooo`030000oooooooo00Koool00`1Voooo
ooooo`0Moooo00<0I_ooooooool0D?ooo`00L?ooo`0306Kooooooooo01_oool00`1Vooooooooo`0C
oooo0P0000Ooool00`1Vooooooooo`0Moooo00<0I_ooooooool0D?ooo`00L?ooo`0306Kooooooooo
01coool00`1Vooooooooo`0Boooo00<0003oooooool01Oooo`0306Kooooooooo01koool00`1Voooo
ooooo`1@oooo001`oooo00<0I_ooooooool07?ooo`0306Kooooooooo01;oool00`000?ooooooo`05
oooo00<0I_ooooooool07_ooo`0306Kooooooooo053oool0073oool00`1Vooooooooo`0Moooo00<0
I_ooooooool04Oooo`030000oooooooo00Coool00`1Vooooooooo`0Ooooo00<0I_ooooooool0D?oo
o`00Koooo`0306Kooooooooo01koool00`1Vooooooooo`0Aoooo00<0003oooooool01?ooo`0306Ko
oooooooo01ooool00`1Vooooooooo`1@oooo001_oooo00<0I_ooooooool07oooo`0306Kooooooooo
013oool200001?ooo`0306Kooooooooo023oool00`1Vooooooooo`1@oooo001_oooo00<0I_oooooo
ool07oooo`0306Kooooooooo013oool00`000?ooooooo`03oooo00<0I_ooooooool08?ooo`0306Ko
oooooooo053oool006ooool00`1Vooooooooo`0Poooo00<0I_ooooooool03oooo`030000oooooooo
00;oool00`1Vooooooooo`0Qoooo00<0I_ooooooool0D?ooo`00Koooo`0306Kooooooooo023oool0
0`1Vooooooooo`0?oooo00<0003oooooool00_ooo`0306Kooooooooo027oool00`1Vooooooooo`1@
oooo001^oooo00<0I_ooooooool08_ooo`0306Kooooooooo00koool01@000?ooooooooooo`1Vo`0T
oooo00<0I_ooooooool0D?ooo`00K_ooo`0306Kooooooooo02?oool00`1Vooooooooo`0=oooo0P00
0003oooo06Kooooo02Coool00`1Vooooooooo`1@oooo001^oooo00<0I_ooooooool08oooo`0306Ko
oooooooo00goool010000?ooooooo`1VobGoool00`1Vooooooooo`1@oooo001^oooo00<0I_oooooo
ool09?ooo`0306Kooooooooo00coool00`000?ooo`1Vo`0Voooo00<0I_ooooooool0D?ooo`00K_oo
o`0306Kooooooooo01ooool200001?ooo`800003oooo100000Goool00`000?ooo`1Vo`0Voooo00<0
I_ooooooool0D?ooo`00KOooo`0306Kooooooooo01ooool010000?ooooooo`0000?oool00`1Voooo
ooooo`02oooo00<0003oooooool01_ooo`03000006Kooooo02Koool00`1Vooooooooo`1@oooo001]
oooo00<0I_ooooooool07oooo`040000oooooooo00001?ooo`0306Kooooooooo00;oool00`000?oo
ooooo`05oooo0P0002Ooool00`1Vooooooooo`1@oooo001]oooo00<0I_ooooooool06Oooo`@00002
oooo00@0003oooooool00005oooo0P1Vo`?oool00`000?ooooooo`03oooo00<0I_l0003oool09ooo
o`0306Kooooooooo053oool006goool00`1Vooooooooo`0Ooooo00@0003oooooool00007oooo00D0
I_l0003oooooool000001?ooo`0306Ko0000oooo02Ooool00`1Vooooooooo`1@oooo001/oooo00<0
I_ooooooool08Oooo`800009oooo00<0I_l0000000000oooo`80I_l00oooo`000?ooo`0Woooo00<0
I_ooooooool0D?ooo`00K?ooo`0306Kooooooooo02goool606Ko0_ooo`030000oooooooo02Koool0
0`1Vooooooooo`1@oooo001[oooo00<0I_ooooooool0=_ooo`80000Woooo00<0I_ooooooool0D?oo
o`00Joooo`0306Kooooooooo03Koool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00Jooo
o`0306Kooooooooo03Koool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00J_ooo`0306Ko
oooooooo03Ooool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00J_ooo`0306Kooooooooo
03Ooool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00J_ooo`0306Kooooooooo03Ooool2
00009oooo`0306Kooooooooo053oool006Woool00`1Vooooooooo`0hoooo00<0003oooooool09_oo
o`0306Kooooooooo053oool006Woool00`1Vooooooooo`0hoooo00<0003oooooool09_ooo`0306Ko
oooooooo053oool006Soool00`1Vooooooooo`0ioooo00<0003oooooool09_ooo`0306Kooooooooo
053oool006Soool00`1Vooooooooo`0ioooo00<0003oooooool09_ooo`0306Kooooooooo053oool0
06Ooool00`1Vooooooooo`0joooo0P0002Ooool00`1Vooooooooo`1@oooo001Woooo00<0I_oooooo
ool0>_ooo`030000oooooooo02Koool00`1Vooooooooo`1@oooo001Woooo00<0I_ooooooool0>_oo
o`030000oooooooo02Koool00`1Vooooooooo`1@oooo001Voooo00<0I_ooooooool0>oooo`030000
oooooooo02Koool00`1Vooooooooo`1@oooo001Voooo00<0I_ooooooool0>oooo`030000oooooooo
02Koool00`1Vooooooooo`1@oooo001Uoooo00<0I_ooooooool0??ooo`80000Woooo00<0I_oooooo
ool0D?ooo`00IOooo`0306Kooooooooo03coool00`000?ooooooo`0Voooo00<0I_ooooooool0D?oo
o`00I?ooo`0306Kooooooooo02Woool200001?ooo`800003oooo1@0000Coool00`000?ooooooo`0V
oooo00<0I_ooooooool0D?ooo`00I?ooo`0306Kooooooooo02Soool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool09_ooo`0306Kooooooooo053oool006?oool00`1Voooo
ooooo`0Yoooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`80000Woooo00<0I_oooooo
ool0D?ooo`00H_ooo`0306Kooooooooo02Coool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00Coool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00H_ooo`0306Kooooooooo
02[oool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool09_ooo`0306Ko
oooooooo053oool0067oool00`1Vooooooooo`0/oooo0P0000[oool200001_ooo`030000oooooooo
02Koool00`1Vooooooooo`1@oooo001Qoooo00<0I_ooooooool0@?ooo`030000oooooooo02Koool0
0`1Vooooooooo`1@oooo001Poooo00<0I_ooooooool0@Oooo`80000Woooo00<0I_ooooooool0D?oo
o`00Goooo`0306Kooooooooo04;oool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00G_oo
o`0306Kooooooooo04?oool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00GOooo`0306Ko
oooooooo04Coool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00GOooo`0306Kooooooooo
04Coool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00G?ooo`0306Kooooooooo04Goool2
00009oooo`0306Kooooooooo053oool005_oool00`1Vooooooooo`16oooo00<0003oooooool09_oo
o`0306Kooooooooo053oool005Woool206KoBOooo`030000oooooooo02Koool00`1Vooooooooo`1@
oooo001Hoooo00<0I_ooooooool0BOooo`030000oooooooo02Koool00`1Vooooooooo`1@oooo000Y
oooo0`0002Soool3000000<0I_ooooooool08Oooo`@0000Uoooo00<0003oooooool09?ooo`@0000W
oooo0`0002Ooool002Woool010000?ooooooo`0002Soool00`00001Vooooo`0Soooo00<0003ooooo
ool09_ooo`80000Uoooo00<0003oool0I_l0:Oooo`030000oooooooo02Koool002Woool010000?oo
ooooo`0002Goool500009Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<00000I_oo
ool09Oooo`D0000Woooo000Soooo100000;oool300008?ooo`@00002oooo00@00000I_ooool0000O
oooo100000Coool00`000?ooooooo`0Toooo00<0003oooooool09_ooo`030000oooooooo02Coool0
10000?ooooooo`0002Soool002[oool00`000?ooooooo`0Soooo0P1Vo`04oooo0000oooo00009Ooo
o`040000oooooooo00009Oooo`030000oooooooo02Coool010000?ooo`1Vo`0002Koool00`000?oo
o`00000Xoooo000Zoooo0`00027oool206Ko1?ooo`80000Voooo0P0002Koool00`000?ooooooo`0U
oooo0P0002Soool20000:?ooo`00Boooo`<0I_mFoooo0P0002Ooool00`1Vooooooooo`1@oooo0018
oooo0`1VoeWoool00`000?ooooooo`0Voooo00<0I_ooooooool0D?ooo`00@oooo`D0I_mLoooo00<0
003oooooool09_ooo`0306Kooooooooo053oool003ooool406KoHOooo`030000oooooooo02Koool0
0`1Vooooooooo`1@oooo000`oooo3`1VofGoool00`000?ooooooo`0Voooo00<0I_ooooooool0D?oo
o`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oool00000300000Dco`000`0003?o
03?o0008<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0008<ol000<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo01;oool002Soool0
0`000?ooooooo`0Voooo00<0003oooooool08Oooo`H0000Y<ol000<0003oooooool09_ooo`030000
oooooooo02Koool00`000?ooooooo`0Woooo001joooo0`0002Lco`000`000?ooooooo`0Voooo00?o
09Woooooool0D?ooo`00OOooo`80000U<ol000<0003oooooool09_ooo`03o`2Ioooooooo053oool0
07ooool00`0003?o03?o000R<ol00P0002Ooool00ol0VOooooooo`1@oooo0020oooo00<0000co`0c
o`008C?o00030000oooooooo02Koool00ol0VOooooooo`1@oooo0021oooo0P00024co`000`000?oo
ooooo`0Voooo00?o09Woooooool0D?ooo`00Poooo`030000<ol0<ol001hco`000`000?ooooooo`0V
oooo00?o09Woooooool0D?ooo`00Poooo`030000<ol0<ol001hco`000`000?ooooooo`0Voooo00?o
09Woooooool0D?ooo`00Q?ooo`030000<ol0<ol001dco`0200009oooo`03o`2Ioooooooo053oool0
08Goool00`0003?o03?o000L<ol000<0003oooooool09_ooo`03o`2Ioooooooo053oool008Koool0
0`0003?o03?o000K<ol000<0003oooooool09_ooo`03o`2Ioooooooo053oool008Koool00`0003?o
03?o000K<ol000<0003oooooool09_ooo`03o`2Ioooooooo053oool008OooolM<ol0O?ooo`00R?oo
oa`co`1loooo0028oooo73?o07coool008SooolL<ol0O?ooo`00ROoooa/co`1loooo001ooooo00<0
003oooooool01ooooaDco`000`0003?o03?o0003<ol0O?ooo`00O_ooo`030000oooooooo00Soool0
0`0003?o03?o000C<ol000<0000co`0co`000S?o07coool007koool00`000?ooooooo`02oooo0P00
00Coool00`0003?o03?o0007<ol00P0000@co`02000013?o00030000<ol0<ol0008co`1loooo001n
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`0003?o03?o0005<ol000@0
000co`0co`000009<ol000<0000co`0co`000S?o07coool007goool00`000?ooooooo`02oooo00<0
003oooooool01_ooo`Tco`000`0003?o03?o0009<ol000@0000co`0co`0co`1loooo001noooo00<0
003oooooool01@0000Goool:<ol000<0000co`0co`001c?o00030000<ol0<ol0008co`1loooo001n
oooo00D0003oooooooooool000002Oooo`Hco`00100003?o03?o000000Tco`000`0003?o03?o0002
<ol0O?ooo`00Ooooo`030000oooooooo00[oool7<ol00P0000Tco`000`0003?o03?o0003<ol0O?oo
o`00S?oooaPco`1loooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.57861 .57049 L
.61984 .57049 L
.65954 .57049 L
.69774 .57049 L
.73838 .57049 L
.75718 .57049 L
.76707 .57049 L
.77247 .57049 L
.77511 .57049 L
.77626 .57049 L
.77751 .57049 L
s
.77751 .57049 m
.77752 .61803 L
s
0 .4 1 r
.02381 .56969 m
.04262 .56937 L
.06244 .56889 L
.07286 .56857 L
.08255 .56821 L
.09388 .56769 L
.10458 .56711 L
.125 .56562 L
.14357 .56371 L
.16355 .56081 L
.18199 .55704 L
.20071 .55171 L
.21136 .54779 L
.22134 .54337 L
.24158 .53159 L
.26011 .51638 L
.27909 .49459 L
.28984 .47857 L
.29982 .46069 L
.32034 .41221 L
.33895 .34997 L
.35819 .25974 L
.36904 .1935 L
.37385 .15972 L
.3765 .13985 L
.37901 .12013 L
.3802 .11054 L
.38145 .10614 L
.38211 .10854 L
.38283 .11117 L
.38411 .11579 L
.38875 .13235 L
.39784 .16355 L
.4185 .22831 L
.4587 .33 L
.49739 .39954 L
.51743 .42511 L
.52751 .43511 L
.53318 .43982 L
.53853 .4436 L
.54346 .44646 L
.54606 .44771 L
.54881 .44883 L
.55112 .4496 L
.55235 .44993 L
.55366 .45024 L
.55487 .45047 L
.55598 .45064 L
.55709 .45076 L
.55814 .45084 L
Mistroke
.55946 .45087 L
.56066 .45084 L
.56133 .4508 L
.56204 .45073 L
.56334 .45055 L
.56457 .45031 L
.56586 .44998 L
.56817 .44918 L
.57086 .44788 L
.57338 .44626 L
.57614 .44398 L
.57909 .44088 L
.62051 .38241 L
.6604 .30782 L
.69879 .21979 L
.71821 .17123 L
.73962 .11788 L
.74939 .09486 L
.75991 .07204 L
.76475 .06251 L
.76984 .05331 L
.77419 .04626 L
.77538 .04447 L
.77665 .04263 L
.77785 .57049 L
.77894 .57049 L
.81897 .57049 L
.85749 .57049 L
.89846 .57049 L
.93792 .57049 L
.97586 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`0`oooo00<0
I_ooooooool0A_ooo`00Y?ooo`030000oooooooo02ooool206KoB?ooo`00Y?ooo`030000oooooooo
02koool00`1Vooooo`1Vo`18oooo002Toooo0P0002ooool00`1Vooooo`1Vo`18oooo002Toooo00<0
003oooooool0;Oooo`0406Kooooooooo06KoB?ooo`00Y?ooo`030000oooooooo02goool0101Voooo
ooooo`1VodSoool00:Coool00`000?ooooooo`0/oooo00D0I_ooooooooooool0I_l0B?ooo`00Y?oo
o`030000oooooooo02coool01@1Vooooooooooooo`1Vo`18oooo002Toooo0P0002coool00`1Voooo
ooooo`02oooo00<0I_ooooooool0A_ooo`00Y?ooo`030000oooooooo02_oool00`1Vooooooooo`02
oooo00<0I_ooooooool0A_ooo`00Y?ooo`030000oooooooo02[oool00`1Vooooooooo`03oooo00<0
I_ooooooool0A_ooo`00T?ooo`800004oooo0P0000Coool200001_ooo`030000oooooooo02[oool0
0`1Vooooooooo`03oooo00<0I_ooooooool0A_ooo`00Soooo`040000oooooooo00002?ooo`040000
oooooooo00001Oooo`030000oooooooo02Woool00`1Vooooooooo`04oooo00<0I_ooooooool0A_oo
o`00Soooo`040000oooooooo00002oooo`030000oooooooo00?oool20000:_ooo`0306Kooooooooo
00Coool00`1Vooooooooo`16oooo0029oooo100000;oool010000?ooooooo`0000Woool200001_oo
o`030000oooooooo02Soool00`1Vooooooooo`05oooo00<0I_ooooooool0A_ooo`00Soooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`0Xoooo00<0I_ooooooool01Ooo
o`0306Kooooooooo04Koool0073oool00`1Vooooooooo`0Moooo0P0000[oool300001Oooo`030000
oooooooo02Ooool00`1Vooooooooo`06oooo00<0I_ooooooool0A_ooo`00L?ooo`0306Kooooooooo
037oool00`000?ooooooo`0Woooo00<0I_ooooooool01_ooo`0306Kooooooooo04Koool0073oool0
0`1Vooooooooo`0aoooo0P0002Ooool00`1Vooooooooo`07oooo00<0I_ooooooool0A_ooo`00Kooo
o`0306Kooooo06Ko03;oool00`000?ooooooo`0Voooo00<0I_ooooooool01oooo`0306Kooooooooo
04Koool006ooool00`1Vooooo`1Vo`0boooo00<0003oooooool09_ooo`0306Kooooooooo00Ooool0
0`1Vooooooooo`16oooo001_oooo00<0I_ooool0I_l0<_ooo`030000oooooooo02Goool00`1Voooo
ooooo`08oooo00<0I_ooooooool0A_ooo`00Koooo`0406Kooooooooo06Ko<Oooo`030000oooooooo
02Goool00`1Vooooooooo`08oooo00<0I_ooooooool0A_ooo`00Koooo`0406Kooooooooo06Ko<Ooo
o`80000Voooo00<0I_ooooooool02?ooo`0306Kooooooooo04Koool006ooool0101Vooooooooo`1V
oc7oool00`000?ooooooo`0Toooo00<0I_ooooooool02Oooo`0306Kooooooooo04Koool006ooool0
101Vooooooooo`1Voc7oool00`000?ooooooo`0Toooo00<0I_ooooooool02Oooo`0306Kooooooooo
04Koool006ooool01@1Vooooooooooooo`1Vo`0`oooo00<0003oooooool08oooo`0306Kooooooooo
00[oool00`1Vooooooooo`16oooo001_oooo00D0I_ooooooooooool0I_l0<?ooo`030000oooooooo
02?oool00`1Vooooooooo`0:oooo00<0I_ooooooool0A_ooo`00K_ooo`0306Kooooooooo00;oool0
0`1Vooooooooo`0^oooo0P0002Coool00`1Vooooooooo`0:oooo00<0I_ooooooool0A_ooo`00K_oo
o`0306Kooooooooo00;oool00`1Vooooooooo`0^oooo00<0003oooooool08_ooo`0306Kooooooooo
00_oool00`1Vooooooooo`16oooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo02goool0
0`000?ooooooo`0Roooo00<0I_ooooooool02oooo`0306Kooooooooo04Koool006koool00`1Voooo
ooooo`03oooo00<0I_ooooooool0;Oooo`030000oooooooo02;oool00`1Vooooooooo`0;oooo00<0
I_ooooooool0A_ooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0]oooo00<0003ooooo
ool08Oooo`0306Kooooooooo00coool00`1Vooooooooo`16oooo001^oooo00<0I_ooooooool01?oo
o`0306Kooooooooo02coool200008_ooo`0306Kooooooooo00coool00`1Vooooooooo`16oooo001^
oooo00<0I_ooooooool01?ooo`0306Kooooooooo02coool00`000?ooooooo`0Qoooo00<0I_oooooo
ool03?ooo`0306Kooooooooo04Koool006goool00`1Vooooooooo`05oooo00<0I_ooooooool0;?oo
o`030000oooooooo023oool00`1Vooooooooo`0=oooo00<0I_ooooooool0A_ooo`00KOooo`0306Ko
oooooooo00Koool00`1Vooooooooo`0Goooo0P0000Coool200001Oooo`<00004oooo00<0003ooooo
ool08?ooo`0306Kooooooooo00goool00`1Vooooooooo`16oooo001]oooo00<0I_ooooooool01_oo
o`0306Kooooooooo01Koool010000?ooooooo`0000_oool00`000?ooooooo`03oooo00<0003ooooo
ool07oooo`0306Kooooooooo00koool00`1Vooooooooo`16oooo001]oooo00<0I_ooooooool01_oo
o`0306Kooooooooo01Koool010000?ooooooo`0000Soool500001?ooo`80000Poooo00<0I_oooooo
ool03_ooo`0306Kooooooooo04Koool006goool00`1Vooooooooo`07oooo00<0I_ooooooool03ooo
o`@00002oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool07ooo
o`0306Kooooooooo00koool00`1Vooooooooo`16oooo001]oooo00<0I_ooooooool01oooo`0306Ko
oooooooo01Goool010000?ooooooo`0000Woool00`000?ooo`000005oooo00<0003oooooool07_oo
o`0306Kooooooooo00ooool00`1Vooooooooo`16oooo001]oooo00<0I_ooooooool02?ooo`0306Ko
oooooooo01Goool200002oooo`800005oooo00<0003oooooool07_ooo`0306Kooooooooo00ooool0
0`1Vooooooooo`16oooo001/oooo00<0I_ooooooool02Oooo`0306Kooooooooo02Woool00`000?oo
ooooo`0Noooo00<0I_ooooooool03oooo`0306Kooooooooo04Koool006coool00`1Vooooooooo`09
oooo00<0I_ooooooool0:Oooo`80000Noooo00<0I_ooooooool04?ooo`0306Kooooooooo04Koool0
06coool00`1Vooooooooo`0:oooo00<0I_ooooooool0:?ooo`030000oooooooo01goool00`1Voooo
ooooo`0@oooo00<0I_ooooooool0A_ooo`00K?ooo`0306Kooooooooo00[oool00`1Vooooooooo`0X
oooo00<0003oooooool07?ooo`0306Kooooooooo017oool00`1Vooooooooo`16oooo001/oooo00<0
I_ooooooool02_ooo`0306Kooooooooo02Soool00`000?ooooooo`0Loooo00<0I_ooooooool04Ooo
o`0306Kooooooooo04Koool006coool00`1Vooooooooo`0;oooo00<0I_ooooooool09oooo`030000
oooooooo01coool00`1Vooooooooo`0Aoooo00<0I_ooooooool0A_ooo`00Joooo`0306Kooooooooo
00coool00`1Vooooooooo`0Woooo0P0001coool00`1Vooooooooo`0Boooo00<0I_ooooooool0A_oo
o`00Joooo`0306Kooooooooo00coool00`1Vooooooooo`0Woooo00<0003oooooool06oooo`0306Ko
oooooooo01;oool00`1Vooooooooo`16oooo001[oooo00<0I_ooooooool03Oooo`0306Kooooooooo
02Koool00`000?ooooooo`0Joooo00<0I_ooooooool04oooo`0306Kooooooooo04Koool006_oool0
0`1Vooooooooo`0=oooo00<0I_ooooooool09_ooo`030000oooooooo01[oool00`1Vooooooooo`0C
oooo00<0I_ooooooool0A_ooo`00Joooo`0306Kooooooooo00goool00`1Vooooooooo`0Voooo00<0
003oooooool06Oooo`0306Kooooooooo01Coool00`1Vooooooooo`16oooo001[oooo00<0I_oooooo
ool03_ooo`0306Kooooooooo02Goool200006_ooo`0306Kooooooooo01Coool00`1Vooooooooo`16
oooo001Zoooo00<0I_ooooooool03oooo`0306Kooooooooo02Goool00`000?ooooooo`0Ioooo00<0
I_ooooooool05?ooo`0306Kooooooooo04Koool006[oool00`1Vooooooooo`0@oooo00<0I_oooooo
ool09?ooo`030000oooooooo01Soool00`1Vooooooooo`0Eoooo00<0I_ooooooool0A_ooo`00J_oo
o`0306Kooooooooo013oool00`1Vooooooooo`0Toooo00<0003oooooool06?ooo`0306Kooooooooo
01Goool00`1Vooooooooo`16oooo001Zoooo00<0I_ooooooool04?ooo`0306Kooooooooo02Coool0
0`000?ooooooo`0Goooo00<0I_ooooooool05_ooo`0306Kooooooooo04Koool006[oool00`1Voooo
ooooo`0Aoooo00<0I_ooooooool08oooo`80000Hoooo00<0I_ooooooool05_ooo`0306Kooooooooo
04Koool006Woool00`1Vooooooooo`0Boooo00<0I_ooooooool08oooo`030000oooooooo01Koool0
0`1Vooooooooo`0Goooo00<0I_ooooooool0A_ooo`00JOooo`0306Kooooooooo01;oool00`1Voooo
ooooo`0Soooo00<0003oooooool05_ooo`0306Kooooooooo01Ooool00`1Vooooooooo`16oooo001Y
oooo00<0I_ooooooool04oooo`0306Kooooooooo00koool200001?ooo`800004oooo0P0000Koool0
0`000?ooooooo`0Eoooo00<0I_ooooooool06?ooo`0306Kooooooooo04Koool006Woool00`1Voooo
ooooo`0Coooo00<0I_ooooooool03Oooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo01Goool00`1Vooooooooo`0Hoooo00<0I_ooooooool0A_ooo`00JOooo`0306Ko
oooooooo01Coool00`1Vooooooooo`0<oooo00@0003oooooool0000:oooo00<0003oooooool01?oo
o`80000Foooo00<0I_ooooooool06?ooo`0306Kooooooooo04Koool006Soool00`1Vooooooooo`0E
oooo00<0I_ooooooool01_ooo`@00002oooo00@0003oooooool0000;oooo00<0003oooooool00ooo
o`030000oooooooo01Coool00`1Vooooooooo`0Ioooo00<0I_ooooooool0A_ooo`00J?ooo`0306Ko
oooooooo01Goool00`1Vooooooooo`0<oooo00@0003oooooool00008oooo00@0003oooooool00005
oooo00<0003oooooool05?ooo`0306Kooooooooo01Woool00`1Vooooooooo`16oooo001Xoooo00<0
I_ooooooool05_ooo`0306Kooooooooo00coool200002_ooo`800006oooo00<0003oooooool04ooo
o`0306Kooooooooo01[oool00`1Vooooooooo`16oooo001Xoooo00<0I_ooooooool05_ooo`0306Ko
oooooooo023oool00`000?ooooooo`0Coooo00<0I_ooooooool06_ooo`0306Kooooooooo04Koool0
06Ooool00`1Vooooooooo`0Goooo00<0I_ooooooool08?ooo`80000Coooo00<0I_ooooooool06ooo
o`0306Kooooooooo04Koool006Ooool00`1Vooooooooo`0Hoooo00<0I_ooooooool07oooo`030000
oooooooo01;oool00`1Vooooooooo`0Koooo00<0I_ooooooool0A_ooo`00Ioooo`0306Kooooooooo
01Soool00`1Vooooooooo`0Ooooo00<0003oooooool04Oooo`0306Kooooooooo01coool00`1Voooo
ooooo`16oooo001Woooo00<0I_ooooooool06Oooo`0306Kooooooooo01koool00`000?ooooooo`0A
oooo00<0I_ooooooool07?ooo`0306Kooooooooo04Koool006Ooool00`1Vooooooooo`0Ioooo00<0
I_ooooooool07_ooo`030000oooooooo013oool00`1Vooooooooo`0Moooo00<0I_ooooooool0A_oo
o`00I_ooo`0306Kooooooooo01[oool00`1Vooooooooo`0Noooo0P00017oool00`1Vooooooooo`0M
oooo00<0I_ooooooool0A_ooo`00I_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0Moooo00<0
003oooooool03oooo`0306Kooooooooo01koool00`1Vooooooooo`16oooo001Voooo00<0I_oooooo
ool06oooo`0306Kooooooooo01goool00`000?ooooooo`0?oooo00<0I_ooooooool07_ooo`0306Ko
oooooooo04Koool006Koool00`1Vooooooooo`0Loooo00<0I_ooooooool07?ooo`030000oooooooo
00koool00`1Vooooooooo`0Ooooo00<0I_ooooooool0A_ooo`00I_ooo`0306Kooooooooo01coool0
0`1Vooooooooo`0Loooo00<0003oooooool03Oooo`0306Kooooooooo023oool00`1Vooooooooo`16
oooo001Uoooo00<0I_ooooooool07_ooo`0306Kooooooooo01_oool200003_ooo`0306Kooooooooo
023oool00`1Vooooooooo`16oooo001Uoooo00<0I_ooooooool07_ooo`0306Kooooooooo01_oool0
0`000?ooooooo`0<oooo00<0I_ooooooool08Oooo`0306Kooooooooo04Koool006Goool00`1Voooo
ooooo`0Ooooo00<0I_ooooooool06_ooo`030000oooooooo00coool00`1Vooooooooo`0Qoooo00<0
I_ooooooool0A_ooo`00IOooo`0306Kooooooooo01ooool00`1Vooooooooo`0Joooo00<0003ooooo
ool02oooo`0306Kooooooooo02;oool00`1Vooooooooo`16oooo001Toooo00<0I_ooooooool08Ooo
o`0306Kooooooooo01Woool00`000?ooooooo`0:oooo00<0I_ooooooool08oooo`0306Kooooooooo
04Koool006Coool00`1Vooooooooo`0Qoooo00<0I_ooooooool06Oooo`80000;oooo00<0I_oooooo
ool08oooo`0306Kooooooooo04Koool006Coool00`1Vooooooooo`0Roooo00<0I_ooooooool06?oo
o`030000oooooooo00Woool00`1Vooooooooo`0Toooo00<0I_ooooooool0A_ooo`00Hoooo`0306Ko
oooooooo02Coool00`1Vooooooooo`0Goooo00<0003oooooool02Oooo`0306Kooooooooo02Coool0
0`1Vooooooooo`16oooo001Soooo00<0I_ooooooool09?ooo`0306Kooooooooo00?oool200001?oo
o`800003oooo100000Goool00`000?ooooooo`08oooo00<0I_ooooooool09Oooo`0306Kooooooooo
04Koool006?oool00`1Vooooooooo`0Uoooo00D0I_ooooooooooool000000_ooo`030000oooooooo
00Koool00`000?ooooooo`06oooo00<0003oooooool02?ooo`0306Kooooooooo02Goool00`1Voooo
ooooo`16oooo001Roooo00<0I_ooooooool09_ooo`0506Kooooooooooooo000000;oool00`000?oo
ooooo`07oooo00<0003oooooool01Oooo`800008oooo00<0I_ooooooool09_ooo`0306Kooooooooo
04Koool006;oool00`1Vooooooooo`0Toooo100000;oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool01_ooo`0306Kooooooooo02Ooool00`1Vooooooooo`16oooo001R
oooo00<0I_ooooooool09oooo`0406Kooooooooo00000_ooo`030000oooooooo00Koool010000?oo
ooooo`0000Goool00`000?ooooooo`06oooo00<0I_ooooooool09oooo`0306Kooooooooo04Koool0
06;oool00`1Vooooooooo`0Xoooo00<0I_ooooooool00P0000[oool200001_ooo`030000oooooooo
00Goool00`1Vooooooooo`0Xoooo00<0I_ooooooool0A_ooo`00HOooo`0306Kooooooooo02Woool0
0`1Vooooooooo`0Doooo00<0003oooooool01?ooo`0306Kooooooooo02Woool00`1Vooooooooo`16
oooo001Qoooo00<0I_ooooooool0:_ooo`0306Kooooooooo01?oool200001Oooo`0306Kooooooooo
02Woool00`1Vooooooooo`16oooo001Qoooo00<0I_ooooooool0:oooo`0306Kooooooooo01;oool0
0`000?ooooooo`03oooo00<0I_ooooooool0:_ooo`0306Kooooooooo04Koool0063oool00`1Voooo
ooooo`0]oooo00<0I_ooooooool04Oooo`030000oooooooo00;oool00`1Vooooooooo`0[oooo00<0
I_ooooooool0A_ooo`00H?ooo`0306Kooooooooo02koool00`1Vooooooooo`0@oooo00<0003ooooo
ool00_ooo`0306Kooooooooo02_oool00`1Vooooooooo`16oooo001Poooo00<0I_ooooooool0;ooo
o`0306Kooooooooo00ooool01@000?ooooooooooo`1Vo`0^oooo00<0I_ooooooool0A_ooo`00Gooo
o`0306Kooooooooo037oool00`1Vooooooooo`0>oooo0P000003oooo06Kooooo02koool00`1Voooo
ooooo`16oooo001Ooooo00<0I_ooooooool0<_ooo`0306Kooooooooo00goool010000?ooooooo`1V
obooool00`1Vooooooooo`16oooo001Noooo00<0I_ooooooool0=?ooo`0306Kooooooooo00coool0
0`000?ooo`1Vo`0`oooo00<0I_ooooooool0A_ooo`00G_ooo`0306Kooooooooo03Coool00`1Voooo
ooooo`0<oooo00<00000I_ooool0<?ooo`0306Kooooooooo04Koool005koool00`1Vooooooooo`0e
oooo00<0I_ooooooool02oooo`03000006Kooooo033oool00`1Vooooooooo`16oooo001Moooo00<0
I_ooooooool0=oooo`80I_l;oooo0P00037oool00`1Vooooooooo`16oooo001Moooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo00Ooool00`1Vo`000?ooo`0aoooo00<0I_ooooooool0A_ooo`00GOoo
o`0306Kooooooooo03[oool206Ko1Oooo`80I_l00oooo`000?ooo`0aoooo00<0I_ooooooool0A_oo
o`00G?ooo`0306Kooooooooo03goool606Ko0_ooo`030000oooooooo033oool00`1Vooooooooo`16
oooo001Loooo00<0I_ooooooool0AOooo`030000oooooooo033oool00`1Vooooooooo`16oooo001K
oooo00<0I_ooooooool0A_ooo`80000aoooo00<0I_ooooooool0A_ooo`00Foooo`0306Kooooooooo
04Koool00`000?ooooooo`0`oooo00<0I_ooooooool0A_ooo`00F_ooo`0306Kooooooooo03?oool2
00001?ooo`800003oooo1@0000Coool00`000?ooooooo`0`oooo00<0I_ooooooool0A_ooo`00FOoo
o`0306Kooooooooo03?oool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003ooooo
ool0<?ooo`0306Kooooooooo04Koool005Woool00`1Vooooooooo`0coooo00@0003oooooool0000:
oooo00<0003oooooool01?ooo`80000aoooo00<0I_ooooooool0A_ooo`00F?ooo`0306Kooooooooo
02koool400000_ooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`0`
oooo00<0I_ooooooool0A_ooo`00Eoooo`0306Kooooooooo03Goool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool0<?ooo`0306Kooooooooo04Koool005Koool00`1Voooo
ooooo`0goooo0P0000[oool200001_ooo`030000oooooooo033oool00`1Vooooooooo`16oooo001F
oooo00<0I_ooooooool0Boooo`030000oooooooo033oool00`1Vooooooooo`16oooo001Eoooo00<0
I_ooooooool0C?ooo`80000aoooo00<0I_ooooooool0A_ooo`00E?ooo`0306Kooooooooo04goool0
0`000?ooooooo`0`oooo00<0I_ooooooool0A_ooo`00Doooo`0306Kooooooooo04koool00`000?oo
ooooo`0`oooo00<0I_ooooooool0A_ooo`00D_ooo`0306Kooooooooo04ooool00`000?ooooooo`0`
oooo00<0I_ooooooool0A_ooo`00D_ooo`0306Kooooooooo04ooool00`000?ooooooo`0`oooo00<0
I_ooooooool0A_ooo`00DOooo`0306Kooooooooo053oool20000<Oooo`0306Kooooooooo04Koool0
053oool00`1Vooooooooo`1Aoooo00<0003oooooool0<?ooo`0306Kooooooooo04Koool004ooool0
0`1Vooooooooo`1Boooo00<0003oooooool0<?ooo`0306Kooooooooo04Koool004koool00`1Voooo
ooooo`1Coooo00<0003oooooool0<?ooo`0306Kooooooooo04Koool002Woool300008Oooo`0306Ko
oooooooo00Coool300009?ooo`@0000Uoooo00<0003oooooool09?ooo`@00008oooo00<0I_oooooo
ool07?ooo`<0000Woooo000Yoooo00@0003oooooool0000Ooooo00<0I_ooooooool01_ooo`030000
oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`09oooo00<0I_oooooo
ool07Oooo`030000oooooooo02Koool002Woool010000?ooooooo`0001goool206Ko1_ooo`D0000U
oooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`08oooo00<0I_oooooo
ool06_ooo`D0000Woooo000Soooo100000;oool300007?ooo`80I_l2oooo100000;oool010000?oo
ooooo`0001ooool400001?ooo`030000oooooooo02Coool00`000?ooooooo`0Voooo00<0003ooooo
ool01oooo`0306Kooooooooo01[oool010000?ooooooo`0002Soool002[oool00`000?ooooooo`0I
oooo0P1Vo`_oool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00002?ooo`0306Kooooooooo01_oool00`000?ooo`00000Xoooo000Zoooo0`00
01Koool306Ko3_ooo`80000Voooo0P0002Koool00`000?ooooooo`0Uoooo0P0000Woool00`1Voooo
ooooo`0Loooo0P0002Soool0043oool306KoHOooo`80000aoooo00<0I_ooooooool0A_ooo`00?_oo
o`80I_mToooo00<0003oooooool0<?ooo`0306Kooooooooo04Koool003[oool406KoI_ooo`030000
oooooooo033oool00`1Vooooooooo`16oooo000eoooo1@1Vof[oool00`000?ooooooo`0`oooo00<0
I_ooooooool0A_ooo`009oooo`h0I_m_oooo00<0003oooooool0<?ooo`0306Kooooooooo04Koool0
00gooooo00001P0000koool001?oool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooo000000`00005<ol000<0000co`0c
o`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`0023?o00030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`0Boooo000Xoooo00<0
003oooooool09_ooo`030000oooooooo027oool60000:C?o00030000oooooooo02Koool00`000?oo
ooooo`07oooo00?o09Woooooool07?ooo`030000oooooooo02Ooool007[oool300009c?o00030000
oooooooo033oool00ol0VOooooooo`16oooo001moooo0P0002Dco`000`000?ooooooo`0`oooo00?o
09Woooooool0A_ooo`00Ooooo`030000<ol0<ol0028co`020000<Oooo`03o`2Ioooooooo04Koool0
083oool00`0003?o03?o000Q<ol000<0003oooooool0<?ooo`03o`2Ioooooooo04Koool0087oool2
00008C?o00030000oooooooo033oool00ol0VOooooooo`16oooo0023oooo00<0000co`0co`007S?o
00030000oooooooo033oool00ol0VOooooooo`16oooo0023oooo00<0000co`0co`007S?o00030000
oooooooo033oool00ol0VOooooooo`16oooo0024oooo00<0000co`0co`007C?o0080000aoooo00?o
09Woooooool0A_ooo`00QOooo`030000<ol0<ol001`co`000`000?ooooooo`0`oooo00?o09Wooooo
ool0A_ooo`00Q_ooo`030000<ol0<ol001/co`000`000?ooooooo`0`oooo00?o09Woooooool0A_oo
o`00Q_ooo`030000<ol0<ol001/co`000`000?ooooooo`0`oooo00?o09Woooooool0A_ooo`00Qooo
oadco`1loooo0028oooo73?o07coool008SooolL<ol0O?ooo`00R?oooa`co`1loooo0029oooo6c?o
07coool007coool00`000?ooooooo`0:oooo63?o00030000<ol0<ol007coool007_oool00`000?oo
ooooo`08oooo00@0003ooooooooooolH<ol000<0000co`3oool0Noooo`00Noooo`030000oooooooo
00;oool200001?ooo`040000oooooooooooo1S?o00800004<ol00P0000@co`02000013?o00030000
<ol0oooo07_oool007_oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`040000
oooooooooooo13?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000<ol0oooo
07_oool007[oool00`000?ooooooo`02oooo00<0003oooooool02Oooo`Hco`000`0003?o03?o000:
<ol000<0000co`0co`000S?o00030000oooooooo07[oool007_oool00`000?ooooooo`0500002?oo
o`Lco`000`0003?o03?o0007<ol00P0000@co`000`0003?o0?ooo`1koooo001koooo00D0003ooooo
ooooool000003?ooo`<co`00100003?o03?o000000Tco`000`0003?o03?o0003<ol000<0000co`3o
ool0Noooo`00O?ooo`030000oooooooo00goool4<ol00P0000Xco`0300000S?o00030000<ol0<ol0
07coool008cooolH<ol0O?ooo`00S?oooaPco`1loooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.57861 .57049 L
.61984 .57049 L
.65954 .57049 L
.69774 .57049 L
.73838 .57049 L
.77751 .57049 L
.7878 .57049 L
.79892 .57049 L
.80403 .57049 L
.80943 .57049 L
.81404 .57049 L
.8153 .57049 L
.81599 .57049 L
.81665 .57049 L
s
.81665 .57049 m
.81666 .61803 L
s
0 .4 1 r
.02381 .56886 m
.04262 .56822 L
.06244 .56725 L
.07286 .56659 L
.08255 .56585 L
.09388 .56482 L
.10458 .56362 L
.125 .56061 L
.14357 .55673 L
.16355 .55085 L
.18199 .54321 L
.20071 .53241 L
.21136 .52445 L
.22134 .51549 L
.24158 .49159 L
.26011 .46073 L
.27909 .41655 L
.28984 .38406 L
.29982 .34779 L
.32034 .24946 L
.32939 .19329 L
.33433 .15855 L
.33895 .12323 L
.34013 .11369 L
.34125 .10447 L
.34255 .10902 L
.34373 .11331 L
.34897 .13207 L
.35819 .16377 L
.37901 .22911 L
.41734 .3273 L
.43673 .36687 L
.45813 .40354 L
.47861 .43238 L
.49739 .45382 L
.51674 .47106 L
.5269 .47807 L
.5325 .48129 L
.5376 .48378 L
.54218 .48564 L
.54714 .48722 L
.54987 .48788 L
.55107 .48812 L
.55239 .48835 L
.55354 .48851 L
.55479 .48865 L
.55611 .48876 L
.55734 .48883 L
.55856 .48885 L
.55969 .48883 L
Mistroke
.56094 .48877 L
.56163 .48872 L
.56226 .48866 L
.56342 .48852 L
.56467 .48832 L
.56693 .48782 L
.56916 .48714 L
.5715 .48622 L
.5757 .48394 L
.57826 .48211 L
.58068 .48006 L
.58521 .47604 L
.59538 .46641 L
.61373 .44681 L
.65211 .39527 L
.69294 .32253 L
.73226 .2349 L
.77007 .14062 L
.79108 .09033 L
.80027 .07066 L
.80514 .06119 L
.81032 .05197 L
.81296 .04767 L
.81426 .04567 L
.81545 .0439 L
.81654 .04234 L
.81769 .57049 L
.81884 .57049 L
.82011 .57049 L
.8292 .57049 L
.84906 .57049 L
.88945 .57049 L
.92833 .57049 L
.96966 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`0joooo00<0
I_ooooooool0??ooo`00Y?ooo`030000oooooooo03[oool00`1Vooooooooo`0loooo002Toooo00<0
003oooooool0>Oooo`80I_lnoooo002Toooo0P0003[oool206Ko?_ooo`00Y?ooo`030000oooooooo
03Soool00`1Vooooo`1Vo`0noooo002Toooo00<0003oooooool0>?ooo`0306Kooooo06Ko03koool0
0:Coool00`000?ooooooo`0goooo00@0I_ooooooool0I_lnoooo002Toooo00<0003oooooool0=_oo
o`0506Kooooooooooooo06Ko03koool00:Coool20000=oooo`0506Kooooooooooooo06Ko03koool0
0:Coool00`000?ooooooo`0eoooo00<0I_ooooooool00_ooo`0306Kooooooooo03coool00:Coool0
0`000?ooooooo`0eoooo00<0I_ooooooool00_ooo`0306Kooooooooo03coool0093oool200001?oo
o`800004oooo0P0000Koool00`000?ooooooo`0doooo00<0I_ooooooool00oooo`0306Kooooooooo
03coool008ooool010000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`0d
oooo00<0I_ooooooool00oooo`0306Kooooooooo03coool008ooool010000?ooooooo`0000_oool0
0`000?ooooooo`03oooo0P0003Goool00`1Vooooooooo`03oooo00<0I_ooooooool0??ooo`00ROoo
o`@00002oooo00@0003oooooool00009oooo0P0000Koool00`000?ooooooo`0coooo00<0I_oooooo
ool01?ooo`0306Kooooooooo03coool008ooool010000?ooooooo`0000Woool00`000?ooooooo`05
oooo00<0003oooooool0<oooo`0306Kooooooooo00Coool00`1Vooooooooo`0loooo001Voooo00<0
I_ooooooool09oooo`80000:oooo0`0000Goool00`000?ooooooo`0boooo00<0I_ooooooool01Ooo
o`0306Kooooooooo03coool006Goool206Ko?Oooo`030000oooooooo03;oool00`1Vooooooooo`05
oooo00<0I_ooooooool0??ooo`00IOooo`80I_lmoooo0P0003;oool00`1Vooooooooo`06oooo00<0
I_ooooooool0??ooo`00IOooo`80I_lmoooo00<0003oooooool0<Oooo`0306Kooooooooo00Koool0
0`1Vooooooooo`0loooo001Uoooo00<0I_ooool0I_l0??ooo`030000oooooooo033oool00`1Voooo
ooooo`07oooo00<0I_ooooooool0??ooo`00IOooo`0306Kooooo06Ko03coool00`000?ooooooo`0`
oooo00<0I_ooooooool01oooo`0306Kooooooooo03coool006Goool0101Vooooooooo`1Voc_oool0
0`000?ooooooo`0_oooo00<0I_ooooooool02?ooo`0306Kooooooooo03coool006Goool0101Voooo
ooooo`1Voc_oool20000<?ooo`0306Kooooooooo00Soool00`1Vooooooooo`0loooo001Uoooo00@0
I_ooooooool0I_lkoooo00<0003oooooool0;_ooo`0306Kooooooooo00Woool00`1Vooooooooo`0l
oooo001Uoooo00@0I_ooooooool0I_lkoooo00<0003oooooool0;_ooo`0306Kooooooooo00Woool0
0`1Vooooooooo`0loooo001Toooo00<0I_ooooooool00_ooo`0306Kooooooooo03Soool00`000?oo
ooooo`0^oooo00<0I_ooooooool02Oooo`0306Kooooooooo03coool006Coool00`1Vooooooooo`02
oooo00<0I_ooooooool0>?ooo`030000oooooooo02goool00`1Vooooooooo`0:oooo00<0I_oooooo
ool0??ooo`00I?ooo`0306Kooooooooo00;oool00`1Vooooooooo`0hoooo0P0002koool00`1Voooo
ooooo`0:oooo00<0I_ooooooool0??ooo`00I?ooo`0306Kooooooooo00;oool00`1Vooooooooo`0h
oooo00<0003oooooool0;Oooo`0306Kooooooooo00[oool00`1Vooooooooo`0loooo001Toooo00<0
I_ooooooool00oooo`0306Kooooooooo03Ooool00`000?ooooooo`0/oooo00<0I_ooooooool02ooo
o`0306Kooooooooo03coool006Coool00`1Vooooooooo`03oooo00<0I_ooooooool0=oooo`030000
oooooooo02coool00`1Vooooooooo`0;oooo00<0I_ooooooool0??ooo`00I?ooo`0306Kooooooooo
00?oool00`1Vooooooooo`0goooo00<0003oooooool0:oooo`0306Kooooooooo00coool00`1Voooo
ooooo`0loooo001Soooo00<0I_ooooooool01Oooo`0306Kooooooooo03Koool20000;?ooo`0306Ko
oooooooo00coool00`1Vooooooooo`0loooo001Soooo00<0I_ooooooool01Oooo`0306Kooooooooo
03Koool00`000?ooooooo`0[oooo00<0I_ooooooool03?ooo`0306Kooooooooo03coool006?oool0
0`1Vooooooooo`05oooo00<0I_ooooooool0=_ooo`030000oooooooo02[oool00`1Vooooooooo`0=
oooo00<0I_ooooooool0??ooo`00Hoooo`0306Kooooooooo00Goool00`1Vooooooooo`0Roooo0P00
00Coool200001Oooo`<00004oooo00<0003oooooool0:_ooo`0306Kooooooooo00goool00`1Voooo
ooooo`0loooo001Roooo00<0I_ooooooool01oooo`0306Kooooooooo023oool010000?ooooooo`00
00_oool00`000?ooooooo`03oooo00<0003oooooool0:_ooo`0306Kooooooooo00goool00`1Voooo
ooooo`0loooo001Roooo00<0I_ooooooool01oooo`0306Kooooooooo023oool010000?ooooooo`00
00Soool500001?ooo`80000Zoooo00<0I_ooooooool03_ooo`0306Kooooooooo03coool006;oool0
0`1Vooooooooo`07oooo00<0I_ooooooool06_ooo`@00002oooo00@0003oooooool00008oooo00@0
003oooooool00005oooo00<0003oooooool0:Oooo`0306Kooooooooo00koool00`1Vooooooooo`0l
oooo001Roooo00<0I_ooooooool02?ooo`0306Kooooooooo01ooool010000?ooooooo`0000Woool0
0`000?ooo`000005oooo00<0003oooooool0:Oooo`0306Kooooooooo00koool00`1Vooooooooo`0l
oooo001Roooo00<0I_ooooooool02?ooo`0306Kooooooooo023oool200002oooo`800005oooo00<0
003oooooool0:?ooo`0306Kooooooooo00ooool00`1Vooooooooo`0loooo001Roooo00<0I_oooooo
ool02?ooo`0306Kooooooooo03Coool00`000?ooooooo`0Xoooo00<0I_ooooooool03oooo`0306Ko
oooooooo03coool0067oool00`1Vooooooooo`0:oooo00<0I_ooooooool0<oooo`80000Yoooo00<0
I_ooooooool03oooo`0306Kooooooooo03coool0067oool00`1Vooooooooo`0:oooo00<0I_oooooo
ool0<oooo`030000oooooooo02Ooool00`1Vooooooooo`0@oooo00<0I_ooooooool0??ooo`00HOoo
o`0306Kooooooooo00[oool00`1Vooooooooo`0coooo00<0003oooooool09oooo`0306Kooooooooo
013oool00`1Vooooooooo`0loooo001Qoooo00<0I_ooooooool02_ooo`0306Kooooooooo03?oool0
0`000?ooooooo`0Voooo00<0I_ooooooool04Oooo`0306Kooooooooo03coool0067oool00`1Voooo
ooooo`0;oooo00<0I_ooooooool0<_ooo`030000oooooooo02Koool00`1Vooooooooo`0Aoooo00<0
I_ooooooool0??ooo`00HOooo`0306Kooooooooo00_oool00`1Vooooooooo`0boooo0P0002Ooool0
0`1Vooooooooo`0Aoooo00<0I_ooooooool0??ooo`00HOooo`0306Kooooooooo00_oool00`1Voooo
ooooo`0boooo00<0003oooooool09Oooo`0306Kooooooooo01;oool00`1Vooooooooo`0loooo001Q
oooo00<0I_ooooooool03?ooo`0306Kooooooooo037oool00`000?ooooooo`0Uoooo00<0I_oooooo
ool04_ooo`0306Kooooooooo03coool0063oool00`1Vooooooooo`0=oooo00<0I_ooooooool0<Ooo
o`030000oooooooo02Goool00`1Vooooooooo`0Boooo00<0I_ooooooool0??ooo`00H?ooo`0306Ko
oooooooo00koool00`1Vooooooooo`0`oooo00<0003oooooool09?ooo`0306Kooooooooo01?oool0
0`1Vooooooooo`0loooo001Poooo00<0I_ooooooool03_ooo`0306Kooooooooo033oool200009Ooo
o`0306Kooooooooo01?oool00`1Vooooooooo`0loooo001Poooo00<0I_ooooooool03_ooo`0306Ko
oooooooo033oool00`000?ooooooo`0Soooo00<0I_ooooooool05?ooo`0306Kooooooooo03coool0
063oool00`1Vooooooooo`0?oooo00<0I_ooooooool0;oooo`030000oooooooo02?oool00`1Voooo
ooooo`0Doooo00<0I_ooooooool0??ooo`00H?ooo`0306Kooooooooo00ooool00`1Vooooooooo`0_
oooo00<0003oooooool08_ooo`0306Kooooooooo01Goool00`1Vooooooooo`0loooo001Ooooo00<0
I_ooooooool04?ooo`0306Kooooooooo02ooool00`000?ooooooo`0Roooo00<0I_ooooooool05Ooo
o`0306Kooooooooo03coool005ooool00`1Vooooooooo`0Aoooo00<0I_ooooooool0;_ooo`80000R
oooo00<0I_ooooooool05_ooo`0306Kooooooooo03coool005ooool00`1Vooooooooo`0Aoooo00<0
I_ooooooool0;_ooo`030000oooooooo027oool00`1Vooooooooo`0Foooo00<0I_ooooooool0??oo
o`00Goooo`0306Kooooooooo01;oool00`1Vooooooooo`0]oooo00<0003oooooool08?ooo`0306Ko
oooooooo01Ooool00`1Vooooooooo`0loooo001Ooooo00<0I_ooooooool04_ooo`0306Kooooooooo
01Woool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`0Poooo00<0I_ooooooool05ooo
o`0306Kooooooooo03coool005koool00`1Vooooooooo`0Coooo00<0I_ooooooool06?ooo`040000
oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo01ooool00`1Vooooooooo`0H
oooo00<0I_ooooooool0??ooo`00G_ooo`0306Kooooooooo01Coool00`1Vooooooooo`0Goooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`80000Poooo00<0I_ooooooool06?ooo`0306Ko
oooooooo03coool005koool00`1Vooooooooo`0Doooo00<0I_ooooooool04Oooo`@00002oooo00@0
003oooooool0000;oooo00<0003oooooool00oooo`030000oooooooo01koool00`1Vooooooooo`0I
oooo00<0I_ooooooool0??ooo`00G_ooo`0306Kooooooooo01Goool00`1Vooooooooo`0Foooo00@0
003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool07_ooo`0306Kooooooooo
01Woool00`1Vooooooooo`0loooo001Noooo00<0I_ooooooool05Oooo`0306Kooooooooo01Ooool2
00002_ooo`800006oooo00<0003oooooool07Oooo`0306Kooooooooo01[oool00`1Vooooooooo`0l
oooo001Moooo00<0I_ooooooool05_ooo`0306Kooooooooo02_oool00`000?ooooooo`0Moooo00<0
I_ooooooool06_ooo`0306Kooooooooo03coool005goool00`1Vooooooooo`0Goooo00<0I_oooooo
ool0:_ooo`80000Moooo00<0I_ooooooool06oooo`0306Kooooooooo03coool005goool00`1Voooo
ooooo`0Goooo00<0I_ooooooool0:_ooo`030000oooooooo01coool00`1Vooooooooo`0Loooo00<0
I_ooooooool0>oooo`00GOooo`0306Kooooooooo01Ooool00`1Vooooooooo`0Zoooo00<0003ooooo
ool06oooo`0306Kooooooooo01goool00`1Vooooooooo`0koooo001Moooo00<0I_ooooooool06?oo
o`0306Kooooooooo02Woool00`000?ooooooo`0Koooo00<0I_ooooooool07Oooo`0306Kooooooooo
03_oool005coool00`1Vooooooooo`0Ioooo00<0I_ooooooool0:Oooo`030000oooooooo01[oool0
0`1Vooooooooo`0Noooo00<0I_ooooooool0>oooo`00G?ooo`0306Kooooooooo01[oool00`1Voooo
ooooo`0Xoooo0P0001_oool00`1Vooooooooo`0Noooo00<0I_ooooooool0>oooo`00G?ooo`0306Ko
oooooooo01[oool00`1Vooooooooo`0Xoooo00<0003oooooool06Oooo`0306Kooooooooo01ooool0
0`1Vooooooooo`0koooo001Loooo00<0I_ooooooool06_ooo`0306Kooooooooo02Soool00`000?oo
ooooo`0Ioooo00<0I_ooooooool07oooo`0306Kooooooooo03_oool005coool00`1Vooooooooo`0K
oooo00<0I_ooooooool09oooo`030000oooooooo01Soool00`1Vooooooooo`0Poooo00<0I_oooooo
ool0>oooo`00Foooo`0306Kooooooooo01coool00`1Vooooooooo`0Woooo00<0003oooooool06?oo
o`0306Kooooooooo023oool00`1Vooooooooo`0koooo001Koooo00<0I_ooooooool07Oooo`0306Ko
oooooooo02Koool200006?ooo`0306Kooooooooo027oool00`1Vooooooooo`0koooo001Koooo00<0
I_ooooooool07Oooo`0306Kooooooooo02Koool00`000?ooooooo`0Goooo00<0I_ooooooool08Ooo
o`0306Kooooooooo03_oool005_oool00`1Vooooooooo`0Noooo00<0I_ooooooool09Oooo`030000
oooooooo01Koool00`1Vooooooooo`0Roooo00<0I_ooooooool0>oooo`00F_ooo`0306Kooooooooo
01ooool00`1Vooooooooo`0Uoooo00<0003oooooool05_ooo`0306Kooooooooo02;oool00`1Voooo
ooooo`0koooo001Joooo00<0I_ooooooool08?ooo`0306Kooooooooo02Coool00`000?ooooooo`0E
oooo00<0I_ooooooool08oooo`0306Kooooooooo03_oool005[oool00`1Vooooooooo`0Poooo00<0
I_ooooooool09?ooo`80000Foooo00<0I_ooooooool08oooo`0306Kooooooooo03_oool005Woool0
0`1Vooooooooo`0Roooo00<0I_ooooooool08oooo`030000oooooooo01Coool00`1Vooooooooo`0T
oooo00<0I_ooooooool0>oooo`00FOooo`0306Kooooooooo02?oool00`1Vooooooooo`0Roooo00<0
003oooooool05?ooo`0306Kooooooooo02Coool00`1Vooooooooo`0koooo001Ioooo00<0I_oooooo
ool08oooo`0306Kooooooooo00koool200001?ooo`800003oooo100000Goool00`000?ooooooo`0C
oooo00<0I_ooooooool09Oooo`0306Kooooooooo03_oool005Woool00`1Vooooooooo`0Toooo00<0
I_ooooooool03?ooo`040000oooooooo00002?ooo`030000oooooooo00Koool00`000?ooooooo`0C
oooo00<0I_ooooooool09Oooo`0306Kooooooooo03_oool005Soool00`1Vooooooooo`0Uoooo00<0
I_ooooooool03?ooo`040000oooooooo00002Oooo`030000oooooooo00Goool200004oooo`0306Ko
oooooooo02Koool00`1Vooooooooo`0koooo001Hoooo00<0I_ooooooool09_ooo`0306Kooooooooo
00Goool400000_ooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`0B
oooo00<0I_ooooooool09_ooo`0306Kooooooooo03_oool005Soool00`1Vooooooooo`0Woooo00<0
I_ooooooool02_ooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
017oool00`1Vooooooooo`0Woooo00<0I_ooooooool0>oooo`00Eoooo`0306Kooooooooo02Soool0
0`1Vooooooooo`0;oooo0P0000[oool200001_ooo`030000oooooooo017oool00`1Vooooooooo`0W
oooo00<0I_ooooooool0>oooo`00Eoooo`0306Kooooooooo02Woool00`1Vooooooooo`0Noooo00<0
003oooooool04?ooo`0306Kooooooooo02Soool00`1Vooooooooo`0koooo001Foooo00<0I_oooooo
ool0:_ooo`0306Kooooooooo01koool200004?ooo`0306Kooooooooo02Woool00`1Vooooooooo`0k
oooo001Foooo00<0I_ooooooool0:oooo`0306Kooooooooo01goool00`000?ooooooo`0>oooo00<0
I_ooooooool0:_ooo`0306Kooooooooo03_oool005Koool00`1Vooooooooo`0/oooo00<0I_oooooo
ool07?ooo`030000oooooooo00koool00`1Vooooooooo`0Zoooo00<0I_ooooooool0>oooo`00EOoo
o`0306Kooooooooo02goool00`1Vooooooooo`0Loooo00<0003oooooool03Oooo`0306Kooooooooo
02_oool00`1Vooooooooo`0koooo001Eoooo00<0I_ooooooool0;_ooo`0306Kooooooooo01_oool0
0`000?ooooooo`0<oooo00<0I_ooooooool0;?ooo`0306Kooooooooo03_oool005Goool00`1Voooo
ooooo`0_oooo00<0I_ooooooool06_ooo`80000<oooo00<0I_ooooooool0;Oooo`0306Kooooooooo
03_oool005Coool00`1Vooooooooo`0aoooo00<0I_ooooooool06Oooo`030000oooooooo00_oool0
0`1Vooooooooo`0]oooo00<0I_ooooooool0>oooo`00E?ooo`0306Kooooooooo037oool00`1Voooo
ooooo`0Ioooo00<0003oooooool02_ooo`0306Kooooooooo02koool00`1Vooooooooo`0koooo001C
oooo00<0I_ooooooool0<oooo`0306Kooooooooo01Soool00`000?ooooooo`09oooo00<0I_oooooo
ool0;oooo`0306Kooooooooo03_oool005?oool00`1Vooooooooo`0doooo00<0I_ooooooool05ooo
o`030000oooooooo00Soool00`1Vooooooooo`0`oooo00<0I_ooooooool0>oooo`00D_ooo`0306Ko
oooooooo03Koool00`1Vooooooooo`0Foooo0P0000Woool00`1Vooooooooo`0`oooo00<0I_oooooo
ool0>oooo`00D_ooo`0306Kooooooooo03Koool00`1Vooooooooo`0Foooo00<0003oooooool01ooo
o`0306Kooooooooo037oool00`1Vooooooooo`0koooo001Boooo00<0I_ooooooool0=oooo`0306Ko
oooooooo01Goool00`000?ooooooo`06oooo00<0I_ooooooool0<_ooo`0306Kooooooooo03_oool0
057oool00`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo00Goool00`1Voooo
ooooo`0coooo00<0I_ooooooool0>oooo`00DOooo`0306Kooooooooo03[oool00`1Vooooooooo`0C
oooo00<0003oooooool01?ooo`0306Kooooooooo03Coool00`1Vooooooooo`0koooo001@oooo00<0
I_ooooooool0??ooo`0306Kooooooooo01;oool200001?ooo`0306Kooooooooo03Goool00`1Voooo
ooooo`0koooo001@oooo00<0I_ooooooool0?Oooo`80I_lBoooo00<0003oooooool00_ooo`0306Ko
oooooooo03Koool00`1Vooooooooo`0koooo001?oooo00<0I_ooooooool0?_ooo`800000101Voooo
ooooooooo`800003oooo1@0000Coool01@000?ooooooooooo`1Vo`0ioooo00<0I_ooooooool0>ooo
o`00Coooo`0306Kooooooooo03goool01@000?ooooooo`00001Vo`09oooo00<0003oooooool01?oo
o`040000oooooooo06Ko>_ooo`0306Kooooooooo03_oool004koool00`1Vooooooooo`0noooo00D0
003oooooool0003oool00P1Vo`Ooool00`000?ooooooo`04oooo0P00000306Kooooooooo03Woool0
0`1Vooooooooo`0koooo001>oooo00<0I_ooooooool0>?ooo`@00002oooo00@0003oooooool00003
oooo00<0I_ooooooool01?ooo`030000oooooooo00Coool00`00001Vooooo`0koooo00<0I_oooooo
ool0>oooo`00COooo`0306Kooooooooo03ooool010000?ooooooo`0000Coool00`1Vooooooooo`03
oooo00<0003oooooool00oooo`0306Ko0000oooo03coool00`1Vooooooooo`0koooo001=oooo00<0
I_ooooooool0@?ooo`800006oooo0`1Vo`03oooo0000000000Coool206Ko00<0003oooooool0>ooo
o`0306Kooooooooo03_oool004coool00`1Vooooooooo`1<oooo1`1Vo`;oool00`000?ooooooo`0k
oooo00<0I_ooooooool0>oooo`00C?ooo`0306Kooooooooo05Goool20000??ooo`0306Kooooooooo
03_oool004_oool00`1Vooooooooo`1Foooo00<0003oooooool0>oooo`0306Kooooooooo03_oool0
04[oool00`1Vooooooooo`1Goooo00<0003oooooool0>oooo`0306Kooooooooo03_oool004Woool0
0`1Vooooooooo`1Hoooo00<0003oooooool0>oooo`0306Kooooooooo03_oool004Soool00`1Voooo
ooooo`1Ioooo00<0003oooooool0>oooo`0306Kooooooooo03_oool004Ooool00`1Vooooooooo`1J
oooo0P0003coool00`1Vooooooooo`0koooo0016oooo00<0I_ooooooool0Foooo`030000oooooooo
03_oool00`1Vooooooooo`0koooo0015oooo00<0I_ooooooool0G?ooo`030000oooooooo03_oool0
0`1Vooooooooo`0koooo0014oooo00<0I_ooooooool0GOooo`030000oooooooo03_oool00`1Voooo
ooooo`0koooo000Yoooo0`0001Koool206Ko4?ooo`<0000Toooo100002Goool00`000?ooooooo`0T
oooo100001?oool00`1Vooooooooo`0Aoooo0`0002Ooool002Woool010000?ooooooo`0001Coool0
0`1Vooooooooo`0Aoooo00<0003oooooool08oooo`030000oooooooo02Koool200009Oooo`030000
oooooooo01Coool00`1Vooooooooo`0Boooo00<0003oooooool09_ooo`00:Oooo`040000oooooooo
00004_ooo`80I_lAoooo1@0002Goool00`000?ooooooo`0Uoooo00<0003oooooool09Oooo`030000
oooooooo01?oool00`1Vooooooooo`0?oooo1@0002Ooool002?oool400000_ooo`<0000Aoooo0P1V
o`goool400000_ooo`040000oooooooo00007oooo`@00004oooo00<0003oooooool09?ooo`030000
oooooooo02Koool00`000?ooooooo`0Boooo00<0I_ooooooool03oooo`040000oooooooo0000:?oo
o`00:_ooo`030000oooooooo00koool206Ko5_ooo`030000oooo000002Goool010000?ooooooo`00
02Goool00`000?ooooooo`0Toooo00@0003oooooool0000Coooo00<0I_ooooooool04?ooo`030000
oooo000002Soool002[oool300003?ooo`80I_lIoooo0P0002Koool200009_ooo`030000oooooooo
02Goool200005?ooo`0306Kooooooooo017oool20000:?ooo`00=_ooo`<0I_m[oooo0P0003coool0
0`1Vooooooooo`0koooo000doooo0P1Vofkoool00`000?ooooooo`0koooo00<0I_ooooooool0>ooo
o`00<?ooo`@0I_m`oooo00<0003oooooool0>oooo`0306Kooooooooo03_oool002Ooool906KoM?oo
o`030000oooooooo03_oool00`1Vooooooooo`0koooo000Koooo301Voggoool00`000?ooooooo`0k
oooo00<0I_ooooooool0>oooo`003Oooool0000600003_ooo`004oooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oool0
0000300000Dco`000`0003?o03?o0008<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`00
0`0003?o03?o0008<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000
oooooooo01;oool002Soool00`000?ooooooo`0Voooo00<0003oooooool08Oooo`H0000Y<ol000<0
003oooooool09_ooo`030000oooooooo01;oool00ol0VOooooooo`0Aoooo00<0003oooooool09ooo
o`00N_ooo`<0000W<ol000<0003oooooool0>oooo`03o`2Ioooooooo03_oool007goool200009C?o
00030000oooooooo03_oool00ol0VOooooooo`0koooo001ooooo00<0000co`0co`008S?o0080000l
oooo00?o09Woooooool0>oooo`00P?ooo`030000<ol0<ol0024co`000`000?ooooooo`0koooo00?o
09Woooooool0>oooo`00POooo`80000Q<ol000<0003oooooool0>oooo`03o`2Ioooooooo03_oool0
08?oool00`0003?o03?o000N<ol000<0003oooooool0>oooo`03o`2Ioooooooo03_oool008?oool0
0`0003?o03?o000N<ol000<0003oooooool0>oooo`03o`2Ioooooooo03_oool008Coool00`0003?o
03?o000M<ol00P0003coool00ol0VOooooooo`0koooo0025oooo00<0000co`0co`0073?o00030000
oooooooo03_oool00ol0VOooooooo`0koooo0026oooo00<0000co`0co`006c?o00030000oooooooo
03_oool00ol0VOooooooo`0koooo0026oooo00<0000co`0co`006c?o00030000oooooooo03_oool0
0ol0VOooooooo`0koooo0027oooo7C?o07coool008SooolL<ol0O?ooo`00R?oooa`co`1loooo0028
oooo73?o07coool008WooolK<ol0O?ooo`00Ooooo`030000oooooooo00OooolE<ol000<0000co`0c
o`000c?o07coool007koool00`000?ooooooo`08oooo00<0000co`0co`004c?o00030000<ol0<ol0
008co`1loooo001noooo00<0003oooooool00_ooo`800004oooo00<0000co`0co`0023?o00<00002
<ol00P0000@co`000`0003?o03?o0002<ol0O?ooo`00O_ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0000co`0co`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0002
<ol0O?ooo`00OOooo`030000oooooooo00;oool00`000?ooooooo`06oooo1c?o00D00009<ol000@0
000co`0co`0co`1loooo001noooo00<0003oooooool01@0000Goool7<ol000@0000co`0co`000009
<ol000<0000co`0co`000S?o07coool007koool01@000?ooooooooooo`000009oooo1c?o00030000
<ol0000000Tco`000`0003?o03?o0002<ol0O?ooo`00Ooooo`030000oooooooo00[oool8<ol00P00
00Pco`000`0003?o03?o0003<ol0O?ooo`00S?oooaPco`1loooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.57861 .57049 L
.61984 .57049 L
.65954 .57049 L
.69774 .57049 L
.73838 .57049 L
.77751 .57049 L
.79749 .57049 L
.81909 .57049 L
.82924 .57049 L
.83996 .57049 L
.84911 .57049 L
.85162 .57049 L
.85431 .57049 L
.85561 .57049 L
.85685 .57049 L
s
.85685 .57049 m
.85685 .61803 L
s
0 .4 1 r
.02381 .56719 m
.04262 .56588 L
.06244 .56392 L
.07286 .56258 L
.08255 .56109 L
.09388 .55898 L
.10458 .55656 L
.125 .55045 L
.14357 .54259 L
.16355 .53066 L
.18199 .51516 L
.20071 .49325 L
.21136 .47711 L
.22134 .45894 L
.24158 .41047 L
.26011 .34789 L
.27909 .25828 L
.28984 .19238 L
.29504 .1557 L
.29732 .13851 L
.29861 .12843 L
.29982 .11881 L
.30101 .10912 L
.30229 .10691 L
.30299 .10947 L
.30365 .11189 L
.30489 .11639 L
.31039 .13594 L
.32034 .16988 L
.33895 .22803 L
.37728 .32667 L
.41806 .40375 L
.43831 .43308 L
.45733 .45602 L
.47572 .47445 L
.49508 .49021 L
.50472 .49673 L
.51526 .50286 L
.52478 .50748 L
.53376 .51099 L
.53869 .51253 L
.54404 .51387 L
.5464 .51434 L
.5489 .51476 L
.55103 .51505 L
.55215 .51517 L
.55337 .51528 L
.5541 .51533 L
.55477 .51537 L
.55547 .51541 L
Mistroke
.5561 .51544 L
.55731 .51546 L
.55859 .51547 L
.55932 .51545 L
.55998 .51543 L
.56071 .5154 L
.56148 .51535 L
.56278 .51525 L
.5642 .51509 L
.56673 .5147 L
.56944 .5141 L
.572 .51335 L
.57432 .51249 L
.57915 .5101 L
.58426 .50695 L
.59345 .50091 L
.61422 .48526 L
.65203 .4484 L
.69228 .39451 L
.73102 .32576 L
.77221 .23426 L
.81189 .13529 L
.83189 .0878 L
.84061 .06934 L
.85005 .05189 L
.85261 .04773 L
.85401 .04557 L
.85531 .04364 L
.85643 .04205 L
.85763 .57049 L
.85831 .57049 L
.85895 .57049 L
.86016 .57049 L
.8697 .57049 L
.89066 .57049 L
.92896 .57049 L
.96971 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`14oooo0P1V
oc?oool00:Coool00`000?ooooooo`14oooo0P1Voc?oool00:Coool00`000?ooooooo`13oooo00<0
I_ooool0I_l0<oooo`00Y?ooo`800014oooo00<0I_ooool0I_l0<oooo`00Y?ooo`030000oooooooo
04;oool0101Vooooooooo`1Voc?oool00:Coool00`000?ooooooo`12oooo00@0I_ooooooool0I_lc
oooo002Toooo00<0003oooooool0@Oooo`0506Kooooooooooooo06Ko03?oool00:Coool00`000?oo
ooooo`11oooo00D0I_ooooooooooool0I_l0<oooo`00Y?ooo`800011oooo00<0I_ooooooool00_oo
o`0306Kooooooooo037oool00:Coool00`000?ooooooo`0ooooo00<0I_ooooooool00oooo`0306Ko
oooooooo037oool00:Coool00`000?ooooooo`0ooooo00<0I_ooooooool00oooo`0306Kooooooooo
037oool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`0noooo00<0I_oooooo
ool01?ooo`0306Kooooooooo037oool008ooool010000?ooooooo`0000Soool010000?ooooooo`00
00Goool00`000?ooooooo`0noooo00<0I_ooooooool01?ooo`0306Kooooooooo037oool008ooool0
10000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0003koool00`1Vooooooooo`05oooo00<0
I_ooooooool0<Oooo`00ROooo`@00002oooo00@0003oooooool00009oooo0P0000Koool00`000?oo
ooooo`0moooo00<0I_ooooooool01Oooo`0306Kooooooooo037oool008ooool010000?ooooooo`00
00Woool00`000?ooooooo`05oooo00<0003oooooool0??ooo`0306Kooooooooo00Koool00`1Voooo
ooooo`0aoooo001Koooo00<0I_ooooooool0<_ooo`80000:oooo0`0000Goool00`000?ooooooo`0l
oooo00<0I_ooooooool01_ooo`0306Kooooooooo037oool005_oool206KoAoooo`030000oooooooo
03coool00`1Vooooooooo`06oooo00<0I_ooooooool0<Oooo`00Foooo`80I_m7oooo0P0003coool0
0`1Vooooooooo`07oooo00<0I_ooooooool0<Oooo`00Foooo`80I_m7oooo00<0003oooooool0>ooo
o`0306Kooooooooo00Ooool00`1Vooooooooo`0aoooo001Koooo0P1VodOoool00`000?ooooooo`0k
oooo00<0I_ooooooool01oooo`0306Kooooooooo037oool005[oool0101Vooooooooo`1VodKoool0
0`000?ooooooo`0joooo00<0I_ooooooool02?ooo`0306Kooooooooo037oool005[oool0101Voooo
ooooo`1VodKoool00`000?ooooooo`0joooo00<0I_ooooooool02?ooo`0306Kooooooooo037oool0
05[oool01@1Vooooooooooooo`1Vo`15oooo0P0003[oool00`1Vooooooooo`09oooo00<0I_oooooo
ool0<Oooo`00F_ooo`0506Kooooooooooooo06Ko04Goool00`000?ooooooo`0ioooo00<0I_oooooo
ool02Oooo`0306Kooooooooo037oool005[oool01@1Vooooooooooooo`1Vo`15oooo00<0003ooooo
ool0>Oooo`0306Kooooooooo00Woool00`1Vooooooooo`0aoooo001Joooo00D0I_ooooooooooool0
I_l0AOooo`030000oooooooo03Soool00`1Vooooooooo`0:oooo00<0I_ooooooool0<Oooo`00F_oo
o`0306Kooooooooo00;oool00`1Vooooooooo`12oooo00<0003oooooool0>?ooo`0306Kooooooooo
00[oool00`1Vooooooooo`0aoooo001Joooo00<0I_ooooooool00_ooo`0306Kooooooooo04;oool2
0000>?ooo`0306Kooooooooo00_oool00`1Vooooooooo`0aoooo001Joooo00<0I_ooooooool00_oo
o`0306Kooooooooo04;oool00`000?ooooooo`0goooo00<0I_ooooooool02oooo`0306Kooooooooo
037oool005[oool00`1Vooooooooo`02oooo00<0I_ooooooool0@_ooo`030000oooooooo03Ooool0
0`1Vooooooooo`0;oooo00<0I_ooooooool0<Oooo`00F_ooo`0306Kooooooooo00?oool00`1Voooo
ooooo`11oooo00<0003oooooool0=_ooo`0306Kooooooooo00coool00`1Vooooooooo`0aoooo001I
oooo00<0I_ooooooool01?ooo`0306Kooooooooo047oool00`000?ooooooo`0foooo00<0I_oooooo
ool03?ooo`0306Kooooooooo037oool005Woool00`1Vooooooooo`04oooo00<0I_ooooooool0@Ooo
o`80000goooo00<0I_ooooooool03?ooo`0306Kooooooooo037oool005Woool00`1Vooooooooo`04
oooo00<0I_ooooooool0@Oooo`030000oooooooo03Goool00`1Vooooooooo`0=oooo00<0I_oooooo
ool0<Oooo`00FOooo`0306Kooooooooo00Goool00`1Vooooooooo`10oooo00<0003oooooool0=Ooo
o`0306Kooooooooo00goool00`1Vooooooooo`0aoooo001Ioooo00<0I_ooooooool01Oooo`0306Ko
oooooooo02coool200001?ooo`800005oooo0`0000Coool00`000?ooooooo`0doooo00<0I_oooooo
ool03_ooo`0306Kooooooooo037oool005Soool00`1Vooooooooo`06oooo00<0I_ooooooool0:ooo
o`040000oooooooo00002oooo`030000oooooooo00?oool00`000?ooooooo`0doooo00<0I_oooooo
ool03_ooo`0306Kooooooooo037oool005Soool00`1Vooooooooo`07oooo00<0I_ooooooool0:_oo
o`040000oooooooo00002?ooo`D00004oooo0P0003Goool00`1Vooooooooo`0>oooo00<0I_oooooo
ool0<Oooo`00F?ooo`0306Kooooooooo00Ooool00`1Vooooooooo`0Toooo100000;oool010000?oo
ooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`0coooo00<0I_ooooooool03ooo
o`0306Kooooooooo037oool005Soool00`1Vooooooooo`07oooo00<0I_ooooooool0:_ooo`040000
oooooooo00002Oooo`030000oooo000000Goool00`000?ooooooo`0coooo00<0I_ooooooool03ooo
o`0306Kooooooooo037oool005Soool00`1Vooooooooo`08oooo00<0I_ooooooool0:_ooo`80000;
oooo0P0000Goool00`000?ooooooo`0boooo00<0I_ooooooool04?ooo`0306Kooooooooo037oool0
05Ooool00`1Vooooooooo`09oooo00<0I_ooooooool0?_ooo`030000oooooooo03;oool00`1Voooo
ooooo`0@oooo00<0I_ooooooool0<Oooo`00Eoooo`0306Kooooooooo00Woool00`1Vooooooooo`0n
oooo0P0003?oool00`1Vooooooooo`0@oooo00<0I_ooooooool0<Oooo`00Eoooo`0306Kooooooooo
00[oool00`1Vooooooooo`0moooo00<0003oooooool0<Oooo`0306Kooooooooo017oool00`1Voooo
ooooo`0aoooo001Goooo00<0I_ooooooool02_ooo`0306Kooooooooo03goool00`000?ooooooo`0a
oooo00<0I_ooooooool04Oooo`0306Kooooooooo037oool005Ooool00`1Vooooooooo`0:oooo00<0
I_ooooooool0?Oooo`030000oooooooo037oool00`1Vooooooooo`0Aoooo00<0I_ooooooool0<Ooo
o`00Eoooo`0306Kooooooooo00_oool00`1Vooooooooo`0loooo00<0003oooooool0<?ooo`0306Ko
oooooooo01;oool00`1Vooooooooo`0aoooo001Foooo00<0I_ooooooool03?ooo`0306Kooooooooo
03coool20000<Oooo`0306Kooooooooo01;oool00`1Vooooooooo`0aoooo001Foooo00<0I_oooooo
ool03?ooo`0306Kooooooooo03coool00`000?ooooooo`0_oooo00<0I_ooooooool04oooo`0306Ko
oooooooo037oool005Koool00`1Vooooooooo`0=oooo00<0I_ooooooool0>oooo`030000oooooooo
02ooool00`1Vooooooooo`0Coooo00<0I_ooooooool0<Oooo`00E_ooo`0306Kooooooooo00goool0
0`1Vooooooooo`0koooo00<0003oooooool0;oooo`0306Kooooooooo01?oool00`1Vooooooooo`0a
oooo001Foooo00<0I_ooooooool03_ooo`0306Kooooooooo03[oool00`000?ooooooo`0^oooo00<0
I_ooooooool05?ooo`0306Kooooooooo037oool005Koool00`1Vooooooooo`0>oooo00<0I_oooooo
ool0>_ooo`80000_oooo00<0I_ooooooool05?ooo`0306Kooooooooo037oool005Goool00`1Voooo
ooooo`0?oooo00<0I_ooooooool0>_ooo`030000oooooooo02goool00`1Vooooooooo`0Eoooo00<0
I_ooooooool0<Oooo`00EOooo`0306Kooooooooo013oool00`1Vooooooooo`0ioooo00<0003ooooo
ool0;Oooo`0306Kooooooooo01Goool00`1Vooooooooo`0aoooo001Eoooo00<0I_ooooooool04?oo
o`0306Kooooooooo03Woool00`000?ooooooo`0/oooo00<0I_ooooooool05_ooo`0306Kooooooooo
037oool005Goool00`1Vooooooooo`0@oooo00<0I_ooooooool0>Oooo`030000oooooooo02coool0
0`1Vooooooooo`0Foooo00<0I_ooooooool0<Oooo`00EOooo`0306Kooooooooo017oool00`1Voooo
ooooo`0hoooo0P0002coool00`1Vooooooooo`0Goooo00<0I_ooooooool0<Oooo`00E?ooo`0306Ko
oooooooo01;oool00`1Vooooooooo`0hoooo00<0003oooooool0:oooo`0306Kooooooooo01Ooool0
0`1Vooooooooo`0aoooo001Doooo00<0I_ooooooool04oooo`0306Kooooooooo03Ooool00`000?oo
ooooo`0Zoooo00<0I_ooooooool06?ooo`0306Kooooooooo037oool005Coool00`1Vooooooooo`0C
oooo00<0I_ooooooool08oooo`800004oooo0P0000Coool200001_ooo`030000oooooooo02[oool0
0`1Vooooooooo`0Hoooo00<0I_ooooooool0<Oooo`00E?ooo`0306Kooooooooo01?oool00`1Voooo
ooooo`0Roooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool0:Ooo
o`0306Kooooooooo01Woool00`1Vooooooooo`0aoooo001Coooo00<0I_ooooooool05Oooo`0306Ko
oooooooo027oool010000?ooooooo`0000[oool00`000?ooooooo`04oooo0P0002[oool00`1Voooo
ooooo`0Ioooo00<0I_ooooooool0<Oooo`00Doooo`0306Kooooooooo01Goool00`1Vooooooooo`0K
oooo100000;oool010000?ooooooo`0000_oool00`000?ooooooo`03oooo00<0003oooooool0:?oo
o`0306Kooooooooo01[oool00`1Vooooooooo`0aoooo001Coooo00<0I_ooooooool05_ooo`0306Ko
oooooooo023oool010000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`0X
oooo00<0I_ooooooool06_ooo`0306Kooooooooo037oool005?oool00`1Vooooooooo`0Foooo00<0
I_ooooooool08Oooo`80000:oooo0P0000Koool00`000?ooooooo`0Woooo00<0I_ooooooool06ooo
o`0306Kooooooooo037oool005?oool00`1Vooooooooo`0Foooo00<0I_ooooooool0=Oooo`030000
oooooooo02Ooool00`1Vooooooooo`0Koooo00<0I_ooooooool0<Oooo`00D_ooo`0306Kooooooooo
01Soool00`1Vooooooooo`0doooo0P0002Ooool00`1Vooooooooo`0Loooo00<0I_ooooooool0<Ooo
o`00D_ooo`0306Kooooooooo01Soool00`1Vooooooooo`0doooo00<0003oooooool09_ooo`0306Ko
oooooooo01coool00`1Vooooooooo`0aoooo001Boooo00<0I_ooooooool06?ooo`0306Kooooooooo
03Coool00`000?ooooooo`0Uoooo00<0I_ooooooool07Oooo`0306Kooooooooo037oool005;oool0
0`1Vooooooooo`0Ioooo00<0I_ooooooool0<oooo`030000oooooooo02Goool00`1Vooooooooo`0M
oooo00<0I_ooooooool0<Oooo`00D_ooo`0306Kooooooooo01Woool00`1Vooooooooo`0coooo00<0
003oooooool09?ooo`0306Kooooooooo01koool00`1Vooooooooo`0aoooo001Aoooo00<0I_oooooo
ool06oooo`0306Kooooooooo03;oool200009Oooo`0306Kooooooooo01koool00`1Vooooooooo`0a
oooo001Aoooo00<0I_ooooooool06oooo`0306Kooooooooo03;oool00`000?ooooooo`0Soooo00<0
I_ooooooool07oooo`0306Kooooooooo037oool0057oool00`1Vooooooooo`0Loooo00<0I_oooooo
ool0<Oooo`030000oooooooo02?oool00`1Vooooooooo`0Ooooo00<0I_ooooooool0<Oooo`00DOoo
o`0306Kooooooooo01coool00`1Vooooooooo`0aoooo00<0003oooooool08_ooo`0306Kooooooooo
023oool00`1Vooooooooo`0aoooo001@oooo00<0I_ooooooool07_ooo`0306Kooooooooo033oool0
0`000?ooooooo`0Roooo00<0I_ooooooool08?ooo`0306Kooooooooo037oool0053oool00`1Voooo
ooooo`0Noooo00<0I_ooooooool0<?ooo`80000Roooo00<0I_ooooooool08Oooo`0306Kooooooooo
037oool0053oool00`1Vooooooooo`0Ooooo00<0I_ooooooool0;oooo`030000oooooooo027oool0
0`1Vooooooooo`0Qoooo00<0I_ooooooool0<Oooo`00D?ooo`0306Kooooooooo01ooool00`1Voooo
ooooo`0_oooo00<0003oooooool08?ooo`0306Kooooooooo02;oool00`1Vooooooooo`0aoooo001@
oooo00<0I_ooooooool08?ooo`0306Kooooooooo02koool00`000?ooooooo`0Poooo00<0I_oooooo
ool08_ooo`0306Kooooooooo037oool004ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool0;_oo
o`030000oooooooo01ooool00`1Vooooooooo`0Soooo00<0I_ooooooool0<Oooo`00Coooo`0306Ko
oooooooo02;oool00`1Vooooooooo`0]oooo0P0001ooool00`1Vooooooooo`0Toooo00<0I_oooooo
ool0<Oooo`00Coooo`0306Kooooooooo02;oool00`1Vooooooooo`0]oooo00<0003oooooool07_oo
o`0306Kooooooooo02Coool00`1Vooooooooo`0aoooo001?oooo00<0I_ooooooool08oooo`0306Ko
oooooooo02coool00`000?ooooooo`0Moooo00<0I_ooooooool09Oooo`0306Kooooooooo037oool0
04koool00`1Vooooooooo`0Uoooo00<0I_ooooooool05oooo`800004oooo0P0000?oool400001Ooo
o`030000oooooooo01goool00`1Vooooooooo`0Uoooo00<0I_ooooooool0<Oooo`00C_ooo`0306Ko
oooooooo02Goool00`1Vooooooooo`0Foooo00@0003oooooool00008oooo00<0003oooooool01_oo
o`030000oooooooo01coool00`1Vooooooooo`0Voooo00<0I_ooooooool0<Oooo`00C_ooo`0306Ko
oooooooo02Koool00`1Vooooooooo`0Eoooo00@0003oooooool00009oooo00<0003oooooool01Ooo
o`80000Moooo00<0I_ooooooool09_ooo`0306Kooooooooo037oool004koool00`1Vooooooooo`0V
oooo00<0I_ooooooool03oooo`@00002oooo00@0003oooooool0000:oooo00<0003oooooool01?oo
o`030000oooooooo01_oool00`1Vooooooooo`0Woooo00<0I_ooooooool0<Oooo`00COooo`0306Ko
oooooooo02Soool00`1Vooooooooo`0Doooo00@0003oooooool00008oooo00@0003oooooool00005
oooo00<0003oooooool06oooo`0306Kooooooooo02Ooool00`1Vooooooooo`0aoooo001=oooo00<0
I_ooooooool0:?ooo`0306Kooooooooo01Goool200002_ooo`800006oooo00<0003oooooool06_oo
o`0306Kooooooooo02Soool00`1Vooooooooo`0aoooo001=oooo00<0I_ooooooool0:Oooo`0306Ko
oooooooo02Soool00`000?ooooooo`0Ioooo00<0I_ooooooool0:Oooo`0306Kooooooooo037oool0
04goool00`1Vooooooooo`0Yoooo00<0I_ooooooool0:?ooo`80000Joooo00<0I_ooooooool0:Ooo
o`0306Kooooooooo037oool004coool00`1Vooooooooo`0[oooo00<0I_ooooooool09oooo`030000
oooooooo01Soool00`1Vooooooooo`0Zoooo00<0I_ooooooool0<Oooo`00C?ooo`0306Kooooooooo
02coool00`1Vooooooooo`0Voooo00<0003oooooool05oooo`0306Kooooooooo02_oool00`1Voooo
ooooo`0aoooo001<oooo00<0I_ooooooool0;?ooo`0306Kooooooooo02Koool00`000?ooooooo`0F
oooo00<0I_ooooooool0;?ooo`0306Kooooooooo037oool004_oool00`1Vooooooooo`0^oooo00<0
I_ooooooool09Oooo`030000oooooooo01Koool00`1Vooooooooo`0/oooo00<0I_ooooooool0<Ooo
o`00Boooo`0306Kooooooooo02ooool00`1Vooooooooo`0Toooo0P0001Koool00`1Vooooooooo`0]
oooo00<0I_ooooooool0<Oooo`00B_ooo`0306Kooooooooo037oool00`1Vooooooooo`0Soooo00<0
003oooooool05?ooo`0306Kooooooooo02koool00`1Vooooooooo`0aoooo001:oooo00<0I_oooooo
ool0<Oooo`0306Kooooooooo02?oool00`000?ooooooo`0Doooo00<0I_ooooooool0;_ooo`0306Ko
oooooooo037oool004Woool00`1Vooooooooo`0coooo00<0I_ooooooool08_ooo`030000oooooooo
01?oool00`1Vooooooooo`0_oooo00<0I_ooooooool0<Oooo`00BOooo`0306Kooooooooo03Coool0
0`1Vooooooooo`0Qoooo00<0003oooooool04_ooo`0306Kooooooooo033oool00`1Vooooooooo`0a
oooo0018oooo00<0I_ooooooool0=_ooo`0306Kooooooooo023oool200004_ooo`0306Kooooooooo
037oool00`1Vooooooooo`0aoooo0018oooo00<0I_ooooooool0=_ooo`0306Kooooooooo023oool0
0`000?ooooooo`0Aoooo00<0I_ooooooool0<Oooo`0306Kooooooooo037oool004Ooool00`1Voooo
ooooo`0hoooo00<0I_ooooooool07oooo`030000oooooooo013oool00`1Vooooooooo`0boooo00<0
I_ooooooool0<Oooo`00Aoooo`0306Kooooooooo03Woool00`1Vooooooooo`0Noooo00<0003ooooo
ool03oooo`0306Kooooooooo03?oool00`1Vooooooooo`0aoooo0016oooo00<0I_ooooooool0>ooo
o`0306Kooooooooo01goool00`000?ooooooo`0>oooo00<0I_ooooooool0=?ooo`0306Kooooooooo
037oool004Koool00`1Vooooooooo`0loooo00<0I_ooooooool07?ooo`80000>oooo00<0I_oooooo
ool0=Oooo`0306Kooooooooo037oool004Koool00`1Vooooooooo`0moooo00<0I_ooooooool06ooo
o`030000oooooooo00coool00`1Vooooooooo`0foooo00<0I_ooooooool0<Oooo`00AOooo`0306Ko
oooooooo03ooool00`1Vooooooooo`06oooo0P0000Coool200000oooo`D00004oooo00<0003ooooo
ool02oooo`0306Kooooooooo03Ooool00`1Vooooooooo`0aoooo0015oooo00<0I_ooooooool0@?oo
o`0306Kooooooooo00Coool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003ooooo
ool02_ooo`0306Kooooooooo03Soool00`1Vooooooooo`0aoooo0014oooo00<0I_ooooooool0@_oo
o`0306Kooooooooo00?oool010000?ooooooo`0000[oool00`000?ooooooo`04oooo0P0000[oool0
0`1Vooooooooo`0ioooo00<0I_ooooooool0<Oooo`00A?ooo`0306Kooooooooo04;oool400000_oo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`08oooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo037oool004?oool00`1Vooooooooo`15oooo0P1Vo`;oool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool01oooo`0306Kooooooooo03_oool0
0`1Vooooooooo`0aoooo0012oooo00<0I_ooooooool0B?ooo`0306Kooooooooo0080000:oooo0P00
00Koool00`000?ooooooo`06oooo00<0I_ooooooool0??ooo`0306Kooooooooo037oool004;oool0
0`1Vooooooooo`19oooo00<0I_ooooooool04oooo`030000oooooooo00Coool206Ko?oooo`0306Ko
oooooooo037oool0047oool00`1Vooooooooo`1;oooo00<0I_ooooooool04_ooo`800004oooo00<0
I_ooooooool0?oooo`0306Kooooooooo037oool0043oool00`1Vooooooooo`1=oooo00<0I_oooooo
ool04Oooo`040000oooooooooooo0P1Vod;oool00`1Vooooooooo`0aoooo000ooooo00<0I_oooooo
ool0Coooo`80I_lAoooo00@0003oooooool0I_m4oooo00<0I_ooooooool0<Oooo`00?_ooo`0306Ko
oooooooo05;oool00`1Vooooooooo`0>oooo00<0003oool0I_l0AOooo`0306Kooooooooo037oool0
03koool00`1Vooooooooo`1Coooo0`1Vo`goool00`00001Vooooo`15oooo00<0I_ooooooool0<Ooo
o`00?Oooo`0306Kooooooooo05Ooool306Ko2?ooo`80I_l20000A_ooo`0306Kooooooooo037oool0
03coool00`1Vooooooooo`1Koooo201Vo`;oool00`000?ooooooo`15oooo00<0I_ooooooool0<Ooo
o`00>oooo`0306Kooooooooo06Koool00`000?ooooooo`15oooo00<0I_ooooooool0<Oooo`00>Ooo
o`80I_mYoooo00<0003oooooool0AOooo`0306Kooooooooo037oool002Woool300003?ooo`0306Ko
oooooooo01Woool300009?ooo`@0000Uoooo00<0003oooooool09?ooo`@0000Moooo00<0I_oooooo
ool01oooo`<0000Woooo000Yoooo00@0003oooooool0000:oooo00<0I_ooooooool06oooo`030000
oooooooo02?oool00`000?ooooooo`0Voooo0P0002Goool00`000?ooooooo`0Noooo00<0I_oooooo
ool02?ooo`030000oooooooo02Koool002Woool010000?ooooooo`0000Soool206Ko6oooo`D0000U
oooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Moooo00<0I_oooooo
ool01Oooo`D0000Woooo000Soooo100000;oool300001oooo`80I_lGoooo100000;oool010000?oo
ooooo`0001ooool400001?ooo`030000oooooooo02Coool00`000?ooooooo`0Voooo00<0003ooooo
ool07?ooo`0306Kooooooooo00Goool010000?ooooooo`0002Soool002[oool00`000?ooooooo`04
oooo0P1Vob3oool00`000?ooo`00000Uoooo00@0003oooooool0000Uoooo00<0003oooooool09?oo
o`040000oooooooo00007Oooo`0306Kooooooooo00Koool00`000?ooo`00000Xoooo000Zoooo0`00
00;oool206Ko8oooo`80000Voooo0P0002Koool00`000?ooooooo`0Uoooo0P0001koool00`1Voooo
ooooo`07oooo0P0002Soool002coool306KoMOooo`800016oooo00<0I_ooooooool0<Oooo`00:_oo
o`80I_mhoooo00<0003oooooool0AOooo`0306Kooooooooo037oool002Coool606KoN_ooo`030000
oooooooo04Goool00`1Vooooooooo`0aoooo000Ooooo1@1Voh3oool00`000?ooooooo`15oooo00<0
I_ooooooool0<Oooo`004oooo``0I_n5oooo00<0003oooooool0AOooo`0306Kooooooooo037oool0
00gooooo00001P0000koool001?oool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooo000000`00005<ol000<0000co`0c
o`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`0023?o00030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`0Boooo000Xoooo00<0
003oooooool09_ooo`030000oooooooo027oool60000:C?o00030000oooooooo02Koool00`000?oo
ooooo`0Loooo00?o09Woooooool01oooo`030000oooooooo02Ooool007[oool300009c?o00030000
oooooooo04Goool00ol0VOooooooo`0aoooo001moooo0P0002Dco`000`000?ooooooo`15oooo00?o
09Woooooool0<Oooo`00Ooooo`030000<ol0<ol0028co`020000A_ooo`03o`2Ioooooooo037oool0
083oool00`0003?o03?o000Q<ol000<0003oooooool0AOooo`03o`2Ioooooooo037oool0087oool2
00008C?o00030000oooooooo04Goool00ol0VOooooooo`0aoooo0023oooo00<0000co`0co`007S?o
00030000oooooooo04Goool00ol0VOooooooo`0aoooo0023oooo00<0000co`0co`007S?o00030000
oooooooo04Goool00ol0VOooooooo`0aoooo0024oooo00<0000co`0co`007C?o00800016oooo00?o
09Woooooool0<Oooo`00QOooo`030000<ol0<ol001`co`000`000?ooooooo`15oooo00?o09Wooooo
ool0<Oooo`00Q_ooo`030000<ol0<ol001/co`000`000?ooooooo`15oooo00?o09Woooooool0<Ooo
o`00Q_ooo`030000<ol0<ol001/co`000`000?ooooooo`15oooo00?o09Woooooool0<Oooo`00Qooo
oadco`1loooo0028oooo73?o07coool008SooolL<ol0O?ooo`00R?oooa`co`1loooo0029oooo6c?o
07coool007coool00`000?ooooooo`0:oooo63?o00030000<ol0<ol007coool007_oool00`000?oo
ooooo`08oooo00@0003ooooooooooolH<ol000<0000co`3oool0Noooo`00Noooo`030000oooooooo
00;oool200001?ooo`040000oooooooooooo1c?o00<00002<ol00P0000@co`02000013?o00030000
<ol0oooo07_oool007_oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`040000
oooooooooooo1c?o00030000<ol0<ol000Hco`00100003?o03?o000000<co`000`0003?o0?ooo`1k
oooo001joooo00<0003oooooool00_ooo`030000oooooooo00Woool4<ol01@0000Xco`000`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00Noooo`030000oooooooo00D00008oooo13?o00040000
<ol0<ol000002C?o00800004<ol000<0000co`3oool0Noooo`00Noooo`050000oooooooooooo0000
00coool4<ol000<0000co`0000002C?o00030000<ol0<ol000<co`000`0003?o0?ooo`1koooo001l
oooo00<0003oooooool03Oooo`Dco`0200002C?o00<00002<ol000<0000co`0co`00O?ooo`00S?oo
oaPco`1loooo002<oooo63?o07coool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.57861 .57049 L
.61984 .57049 L
.65954 .57049 L
.69774 .57049 L
.73838 .57049 L
.77751 .57049 L
.81909 .57049 L
.83996 .57049 L
.85916 .57049 L
.87791 .57049 L
.88735 .57049 L
.88993 .57049 L
.89271 .57049 L
.89405 .57049 L
.89533 .57049 L
.89647 .57049 L
s
.89647 .57049 m
.89647 .61803 L
s
0 .4 1 r
.02381 .56379 m
.04262 .56113 L
.06244 .55716 L
.07286 .55444 L
.08255 .55141 L
.09388 .54715 L
.10458 .54224 L
.125 .52985 L
.14357 .5139 L
.16355 .4897 L
.18199 .45828 L
.20071 .41383 L
.21136 .38109 L
.22134 .34425 L
.24158 .24595 L
.25055 .18973 L
.25547 .15483 L
.25789 .13655 L
.26011 .11902 L
.26132 .10922 L
.26259 .10686 L
.26387 .11153 L
.26527 .11662 L
.26995 .13331 L
.27909 .16468 L
.29982 .22967 L
.34024 .33255 L
.37915 .40517 L
.39896 .43388 L
.42051 .45981 L
.46036 .49577 L
.48013 .50884 L
.50114 .51975 L
.51051 .52368 L
.52061 .52727 L
.53008 .53 L
.53889 .53194 L
.54352 .53271 L
.54589 .53303 L
.54846 .53332 L
.54993 .53345 L
.55128 .53356 L
.55255 .53364 L
.55322 .53367 L
.55395 .53371 L
.5552 .53375 L
.55637 .53378 L
.55705 .53378 L
.55771 .53378 L
.55893 .53377 L
Mistroke
.55962 .53376 L
.56026 .53374 L
.56147 .53368 L
.56277 .5336 L
.56417 .53349 L
.5667 .53321 L
.56903 .53286 L
.57158 .53235 L
.57438 .53165 L
.58003 .52965 L
.59958 .52069 L
.62051 .50908 L
.64036 .4958 L
.66192 .47841 L
.70182 .43641 L
.74265 .37728 L
.78197 .3025 L
.81977 .21501 L
.84079 .16233 L
.86003 .1146 L
.87891 .07214 L
.8884 .05416 L
.891 .04979 L
.89378 .04544 L
.89512 .04346 L
.89639 .04166 L
.89753 .57049 L
.89877 .57049 L
.93974 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo04ooool00`1Vooooooooo`0Woooo002Toooo00<0
003oooooool0Coooo`0306Kooooooooo02Ooool00:Coool00`000?ooooooo`1>oooo0P1VobWoool0
0:Coool00`000?ooooooo`1>oooo0P1VobWoool00:Coool20000C_ooo`0306Kooooo06Ko02Woool0
0:Coool00`000?ooooooo`1<oooo00@0I_ooooooool0I_lYoooo002Toooo00<0003oooooool0C?oo
o`0406Kooooooooo06Ko:Oooo`00Y?ooo`030000oooooooo04_oool01@1Vooooooooooooo`1Vo`0Y
oooo002Toooo00<0003oooooool0Boooo`0506Kooooooooooooo06Ko02Woool00:Coool20000C?oo
o`0506Kooooooooooooo06Ko02Woool00:Coool00`000?ooooooo`1:oooo00<0I_ooooooool00_oo
o`0306Kooooooooo02Ooool00:Coool00`000?ooooooo`1:oooo00<0I_ooooooool00_ooo`0306Ko
oooooooo02Ooool0093oool200001?ooo`800004oooo0P0000Koool00`000?ooooooo`19oooo00<0
I_ooooooool00oooo`0306Kooooooooo02Ooool008ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`19oooo00<0I_ooooooool00oooo`0306Kooooooooo02Ooool0
08ooool010000?ooooooo`0000_oool00`000?ooooooo`03oooo0P0004Woool00`1Vooooooooo`04
oooo00<0I_ooooooool09oooo`00ROooo`@00002oooo00@0003oooooool00009oooo0P0000Koool0
0`000?ooooooo`18oooo00<0I_ooooooool01?ooo`0306Kooooooooo02Ooool008ooool010000?oo
ooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool0Aoooo`0306Kooooooooo00Goool0
0`1Vooooooooo`0Woooo001Aoooo00<0I_ooooooool0??ooo`80000:oooo0`0000Goool00`000?oo
ooooo`17oooo00<0I_ooooooool01Oooo`0306Kooooooooo02Ooool0057oool00`1Vooooooooo`1@
oooo00<0003oooooool0A_ooo`0306Kooooooooo00Koool00`1Vooooooooo`0Woooo001Aoooo00<0
I_ooooooool0D?ooo`800017oooo00<0I_ooooooool01_ooo`0306Kooooooooo02Ooool0053oool0
0`1Vooooo`1Vo`1Aoooo00<0003oooooool0A_ooo`0306Kooooooooo00Koool00`1Vooooooooo`0W
oooo001@oooo00<0I_ooool0I_l0DOooo`030000oooooooo04Goool00`1Vooooooooo`07oooo00<0
I_ooooooool09oooo`00D?ooo`0306Kooooo06Ko057oool00`000?ooooooo`15oooo00<0I_oooooo
ool01oooo`0306Kooooooooo02Ooool0053oool0101Vooooooooo`1Voe3oool00`000?ooooooo`14
oooo00<0I_ooooooool02?ooo`0306Kooooooooo02Ooool0053oool0101Vooooooooo`1Voe3oool2
0000AOooo`0306Kooooooooo00Soool00`1Vooooooooo`0Woooo001@oooo00@0I_ooooooool0I_m@
oooo00<0003oooooool0A?ooo`0306Kooooooooo00Soool00`1Vooooooooo`0Woooo001@oooo00@0
I_ooooooool0I_m@oooo00<0003oooooool0@oooo`0306Kooooooooo00Woool00`1Vooooooooo`0W
oooo001@oooo00D0I_ooooooooooool0I_l0Coooo`030000oooooooo04?oool00`1Vooooooooo`09
oooo00<0I_ooooooool09oooo`00Coooo`0306Kooooooooo00;oool00`1Vooooooooo`1=oooo00<0
003oooooool0@oooo`0306Kooooooooo00Woool00`1Vooooooooo`0Woooo001?oooo00<0I_oooooo
ool00_ooo`0306Kooooooooo04goool20000@oooo`0306Kooooooooo00[oool00`1Vooooooooo`0W
oooo001?oooo00<0I_ooooooool00_ooo`0306Kooooooooo04goool00`000?ooooooo`12oooo00<0
I_ooooooool02_ooo`0306Kooooooooo02Ooool004ooool00`1Vooooooooo`03oooo00<0I_oooooo
ool0C?ooo`030000oooooooo047oool00`1Vooooooooo`0;oooo00<0I_ooooooool09oooo`00Cooo
o`0306Kooooooooo00?oool00`1Vooooooooo`1<oooo00<0003oooooool0@Oooo`0306Kooooooooo
00_oool00`1Vooooooooo`0Woooo001?oooo00<0I_ooooooool00oooo`0306Kooooooooo04coool0
0`000?ooooooo`11oooo00<0I_ooooooool02oooo`0306Kooooooooo02Ooool004ooool00`1Voooo
ooooo`04oooo00<0I_ooooooool0Boooo`800011oooo00<0I_ooooooool03?ooo`0306Kooooooooo
02Ooool004koool00`1Vooooooooo`05oooo00<0I_ooooooool0Boooo`030000oooooooo043oool0
0`1Vooooooooo`0<oooo00<0I_ooooooool09oooo`00C_ooo`0306Kooooooooo00Goool00`1Voooo
ooooo`1;oooo00<0003oooooool0?oooo`0306Kooooooooo00goool00`1Vooooooooo`0Woooo001>
oooo00<0I_ooooooool01_ooo`0306Kooooooooo03Koool200001?ooo`800005oooo0`0000Coool0
0`000?ooooooo`0ooooo00<0I_ooooooool03Oooo`0306Kooooooooo02Ooool004koool00`1Voooo
ooooo`06oooo00<0I_ooooooool0=Oooo`040000oooooooo00002oooo`030000oooooooo00?oool0
0`000?ooooooo`0noooo00<0I_ooooooool03_ooo`0306Kooooooooo02Ooool004koool00`1Voooo
ooooo`06oooo00<0I_ooooooool0=Oooo`040000oooooooo00002?ooo`D00004oooo0P0003ooool0
0`1Vooooooooo`0>oooo00<0I_ooooooool09oooo`00C_ooo`0306Kooooooooo00Ooool00`1Voooo
ooooo`0^oooo100000;oool010000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?oo
ooooo`0noooo00<0I_ooooooool03_ooo`0306Kooooooooo02Ooool004koool00`1Vooooooooo`07
oooo00<0I_ooooooool0=?ooo`040000oooooooo00002Oooo`030000oooo000000Goool00`000?oo
ooooo`0moooo00<0I_ooooooool03oooo`0306Kooooooooo02Ooool004koool00`1Vooooooooo`08
oooo00<0I_ooooooool0=?ooo`80000;oooo0P0000Goool00`000?ooooooo`0moooo00<0I_oooooo
ool03oooo`0306Kooooooooo02Ooool004goool00`1Vooooooooo`09oooo00<0I_ooooooool0B?oo
o`030000oooooooo03coool00`1Vooooooooo`0@oooo00<0I_ooooooool09oooo`00COooo`0306Ko
oooooooo00Woool00`1Vooooooooo`18oooo0P0003goool00`1Vooooooooo`0@oooo00<0I_oooooo
ool09oooo`00COooo`0306Kooooooooo00[oool00`1Vooooooooo`17oooo00<0003oooooool0>ooo
o`0306Kooooooooo017oool00`1Vooooooooo`0Woooo001=oooo00<0I_ooooooool02_ooo`0306Ko
oooooooo04Ooool00`000?ooooooo`0koooo00<0I_ooooooool04Oooo`0306Kooooooooo02Ooool0
04goool00`1Vooooooooo`0:oooo00<0I_ooooooool0Aoooo`030000oooooooo03_oool00`1Voooo
ooooo`0Aoooo00<0I_ooooooool09oooo`00COooo`0306Kooooooooo00_oool00`1Vooooooooo`16
oooo00<0003oooooool0>_ooo`0306Kooooooooo01;oool00`1Vooooooooo`0Woooo001=oooo00<0
I_ooooooool02oooo`0306Kooooooooo04Koool20000>oooo`0306Kooooooooo01;oool00`1Voooo
ooooo`0Woooo001=oooo00<0I_ooooooool02oooo`0306Kooooooooo04Koool00`000?ooooooo`0i
oooo00<0I_ooooooool04oooo`0306Kooooooooo02Ooool004coool00`1Vooooooooo`0=oooo00<0
I_ooooooool0AOooo`030000oooooooo03Woool00`1Vooooooooo`0Coooo00<0I_ooooooool09ooo
o`00C?ooo`0306Kooooooooo00goool00`1Vooooooooo`15oooo00<0003oooooool0>?ooo`0306Ko
oooooooo01Coool00`1Vooooooooo`0Woooo001<oooo00<0I_ooooooool03Oooo`0306Kooooooooo
04Goool00`000?ooooooo`0hoooo00<0I_ooooooool05?ooo`0306Kooooooooo02Ooool004coool0
0`1Vooooooooo`0>oooo00<0I_ooooooool0A?ooo`80000hoooo00<0I_ooooooool05Oooo`0306Ko
oooooooo02Ooool004coool00`1Vooooooooo`0>oooo00<0I_ooooooool0A?ooo`030000oooooooo
03Ooool00`1Vooooooooo`0Eoooo00<0I_ooooooool09oooo`00C?ooo`0306Kooooooooo00ooool0
0`1Vooooooooo`13oooo00<0003oooooool0=_ooo`0306Kooooooooo01Koool00`1Vooooooooo`0W
oooo001;oooo00<0I_ooooooool04?ooo`0306Kooooooooo04?oool00`000?ooooooo`0foooo00<0
I_ooooooool05_ooo`0306Kooooooooo02Ooool004_oool00`1Vooooooooo`0@oooo00<0I_oooooo
ool0@oooo`030000oooooooo03Koool00`1Vooooooooo`0Foooo00<0I_ooooooool09oooo`00Booo
o`0306Kooooooooo017oool00`1Vooooooooo`12oooo0P0003Koool00`1Vooooooooo`0Goooo00<0
I_ooooooool09oooo`00Boooo`0306Kooooooooo017oool00`1Vooooooooo`12oooo00<0003ooooo
ool0=Oooo`0306Kooooooooo01Ooool00`1Vooooooooo`0Woooo001:oooo00<0I_ooooooool04_oo
o`0306Kooooooooo04;oool00`000?ooooooo`0doooo00<0I_ooooooool06?ooo`0306Kooooooooo
02Ooool004[oool00`1Vooooooooo`0Coooo00<0I_ooooooool0;Oooo`800004oooo0P0000Coool2
00001_ooo`030000oooooooo03Coool00`1Vooooooooo`0Hoooo00<0I_ooooooool09oooo`00B_oo
o`0306Kooooooooo01?oool00`1Vooooooooo`0/oooo00@0003oooooool00008oooo00@0003ooooo
ool00005oooo00<0003oooooool0<oooo`0306Kooooooooo01Woool00`1Vooooooooo`0Woooo001:
oooo00<0I_ooooooool05?ooo`0306Kooooooooo02_oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo0P0003Coool00`1Vooooooooo`0Ioooo00<0I_ooooooool09oooo`00BOooo`0306Ko
oooooooo01Goool00`1Vooooooooo`0Uoooo100000;oool010000?ooooooo`0000_oool00`000?oo
ooooo`03oooo00<0003oooooool0<_ooo`0306Kooooooooo01[oool00`1Vooooooooo`0Woooo0019
oooo00<0I_ooooooool05Oooo`0306Kooooooooo02_oool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`0boooo00<0I_ooooooool06_ooo`0306Kooooooooo02Ooool0
04Woool00`1Vooooooooo`0Foooo00<0I_ooooooool0:oooo`80000:oooo0P0000Koool00`000?oo
ooooo`0aoooo00<0I_ooooooool06oooo`0306Kooooooooo02Ooool004Woool00`1Vooooooooo`0F
oooo00<0I_ooooooool0?oooo`030000oooooooo037oool00`1Vooooooooo`0Koooo00<0I_oooooo
ool09oooo`00B?ooo`0306Kooooooooo01Ooool00`1Vooooooooo`0ooooo0P00037oool00`1Voooo
ooooo`0Loooo00<0I_ooooooool09oooo`00B?ooo`0306Kooooooooo01Soool00`1Vooooooooo`0n
oooo00<0003oooooool0<?ooo`0306Kooooooooo01goool00`1Vooooooooo`0Voooo0018oooo00<0
I_ooooooool06?ooo`0306Kooooooooo03koool00`000?ooooooo`0_oooo00<0I_ooooooool07_oo
o`0306Kooooooooo02Koool004Soool00`1Vooooooooo`0Ioooo00<0I_ooooooool0?Oooo`030000
oooooooo02ooool00`1Vooooooooo`0Noooo00<0I_ooooooool09_ooo`00Aoooo`0306Kooooooooo
01[oool00`1Vooooooooo`0moooo00<0003oooooool0;_ooo`0306Kooooooooo01ooool00`1Voooo
ooooo`0Voooo0017oooo00<0I_ooooooool06_ooo`0306Kooooooooo03goool20000;oooo`0306Ko
oooooooo01ooool00`1Vooooooooo`0Voooo0017oooo00<0I_ooooooool06oooo`0306Kooooooooo
03coool00`000?ooooooo`0]oooo00<0I_ooooooool08?ooo`0306Kooooooooo02Koool004Ooool0
0`1Vooooooooo`0Koooo00<0I_ooooooool0??ooo`030000oooooooo02goool00`1Vooooooooo`0P
oooo00<0I_ooooooool09_ooo`00A_ooo`0306Kooooooooo01goool00`1Vooooooooo`0koooo00<0
003oooooool0;?ooo`0306Kooooooooo027oool00`1Vooooooooo`0Voooo0016oooo00<0I_oooooo
ool07Oooo`0306Kooooooooo03_oool00`000?ooooooo`0/oooo00<0I_ooooooool08Oooo`0306Ko
oooooooo02Koool004Koool00`1Vooooooooo`0Noooo00<0I_ooooooool0>_ooo`80000/oooo00<0
I_ooooooool08_ooo`0306Kooooooooo02Koool004Koool00`1Vooooooooo`0Noooo00<0I_oooooo
ool0>_ooo`030000oooooooo02_oool00`1Vooooooooo`0Roooo00<0I_ooooooool09_ooo`00A_oo
o`0306Kooooooooo01ooool00`1Vooooooooo`0ioooo00<0003oooooool0:_ooo`0306Kooooooooo
02?oool00`1Vooooooooo`0Voooo0015oooo00<0I_ooooooool08?ooo`0306Kooooooooo03Woool0
0`000?ooooooo`0Zoooo00<0I_ooooooool08oooo`0306Kooooooooo02Koool004Goool00`1Voooo
ooooo`0Qoooo00<0I_ooooooool0>?ooo`030000oooooooo02Woool00`1Vooooooooo`0Toooo00<0
I_ooooooool09_ooo`00AOooo`0306Kooooooooo027oool00`1Vooooooooo`0hoooo0P0002[oool0
0`1Vooooooooo`0Toooo00<0I_ooooooool09_ooo`00AOooo`0306Kooooooooo02;oool00`1Voooo
ooooo`0goooo00<0003oooooool0:?ooo`0306Kooooooooo02Goool00`1Vooooooooo`0Voooo0015
oooo00<0I_ooooooool08_ooo`0306Kooooooooo03Ooool00`000?ooooooo`0Xoooo00<0I_oooooo
ool09Oooo`0306Kooooooooo02Koool004Coool00`1Vooooooooo`0Toooo00<0I_ooooooool08_oo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo02Ooool00`1Vooooooooo`0Voooo00<0
I_ooooooool09_ooo`00A?ooo`0306Kooooooooo02Coool00`1Vooooooooo`0Qoooo00@0003ooooo
ool00008oooo00<0003oooooool01_ooo`030000oooooooo02Ooool00`1Vooooooooo`0Voooo00<0
I_ooooooool09_ooo`00A?ooo`0306Kooooooooo02Goool00`1Vooooooooo`0Poooo00@0003ooooo
ool00009oooo00<0003oooooool01Oooo`80000Woooo00<0I_ooooooool09oooo`0306Kooooooooo
02Koool004Coool00`1Vooooooooo`0Uoooo00<0I_ooooooool06_ooo`@00002oooo00@0003ooooo
ool0000:oooo00<0003oooooool01?ooo`030000oooooooo02Koool00`1Vooooooooo`0Woooo00<0
I_ooooooool09_ooo`00@oooo`0306Kooooooooo02Ooool00`1Vooooooooo`0Ooooo00@0003ooooo
ool00008oooo00@0003oooooool00005oooo00<0003oooooool09Oooo`0306Kooooooooo02Soool0
0`1Vooooooooo`0Voooo0013oooo00<0I_ooooooool09oooo`0306Kooooooooo023oool200002_oo
o`800006oooo00<0003oooooool09?ooo`0306Kooooooooo02Woool00`1Vooooooooo`0Voooo0012
oooo00<0I_ooooooool0:Oooo`0306Kooooooooo03?oool00`000?ooooooo`0Toooo00<0I_oooooo
ool0:Oooo`0306Kooooooooo02Koool004;oool00`1Vooooooooo`0Yoooo00<0I_ooooooool0<ooo
o`80000Toooo00<0I_ooooooool0:_ooo`0306Kooooooooo02Koool004;oool00`1Vooooooooo`0Z
oooo00<0I_ooooooool0<_ooo`030000oooooooo02;oool00`1Vooooooooo`0[oooo00<0I_oooooo
ool09_ooo`00@Oooo`0306Kooooooooo02coool00`1Vooooooooo`0aoooo00<0003oooooool08_oo
o`0306Kooooooooo02_oool00`1Vooooooooo`0Voooo0011oooo00<0I_ooooooool0;?ooo`0306Ko
oooooooo037oool00`000?ooooooo`0Qoooo00<0I_ooooooool0;?ooo`0306Kooooooooo02Koool0
047oool00`1Vooooooooo`0]oooo00<0I_ooooooool0<?ooo`030000oooooooo023oool00`1Voooo
ooooo`0]oooo00<0I_ooooooool09_ooo`00@?ooo`0306Kooooooooo02ooool00`1Vooooooooo`0_
oooo0P00027oool00`1Vooooooooo`0]oooo00<0I_ooooooool09_ooo`00@?ooo`0306Kooooooooo
033oool00`1Vooooooooo`0^oooo00<0003oooooool07oooo`0306Kooooooooo02koool00`1Voooo
ooooo`0Voooo000ooooo00<0I_ooooooool0<Oooo`0306Kooooooooo02koool00`000?ooooooo`0N
oooo00<0I_ooooooool0;oooo`0306Kooooooooo02Koool003ooool00`1Vooooooooo`0boooo00<0
I_ooooooool0;Oooo`030000oooooooo01koool00`1Vooooooooo`0_oooo00<0I_ooooooool09_oo
o`00?_ooo`0306Kooooooooo03Coool00`1Vooooooooo`0/oooo00<0003oooooool07Oooo`0306Ko
oooooooo033oool00`1Vooooooooo`0Voooo000noooo00<0I_ooooooool0=Oooo`0306Kooooooooo
02_oool200007Oooo`0306Kooooooooo037oool00`1Vooooooooo`0Voooo000noooo00<0I_oooooo
ool0=_ooo`0306Kooooooooo02[oool00`000?ooooooo`0Koooo00<0I_ooooooool0<_ooo`0306Ko
oooooooo02Koool003goool00`1Vooooooooo`0goooo00<0I_ooooooool0:_ooo`030000oooooooo
01[oool00`1Vooooooooo`0coooo00<0I_ooooooool09_ooo`00?Oooo`0306Kooooooooo03Soool0
0`1Vooooooooo`0Yoooo00<0003oooooool06Oooo`0306Kooooooooo03Coool00`1Vooooooooo`0V
oooo000loooo00<0I_ooooooool0>_ooo`0306Kooooooooo02Soool00`000?ooooooo`0Hoooo00<0
I_ooooooool0=Oooo`0306Kooooooooo02Koool003coool00`1Vooooooooo`0koooo00<0I_oooooo
ool09oooo`80000Hoooo00<0I_ooooooool0=_ooo`0306Kooooooooo02Koool003_oool00`1Voooo
ooooo`0moooo00<0I_ooooooool09_ooo`030000oooooooo01Koool00`1Vooooooooo`0goooo00<0
I_ooooooool09_ooo`00>oooo`0306Kooooooooo03koool00`1Vooooooooo`0Aoooo0P0000Coool2
00000oooo`D00004oooo00<0003oooooool05Oooo`0306Kooooooooo03Soool00`1Vooooooooo`0V
oooo000joooo00<0I_ooooooool0@?ooo`0306Kooooooooo00ooool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool05?ooo`0306Kooooooooo03Woool00`1Vooooooooo`0V
oooo000ioooo00<0I_ooooooool0@_ooo`0306Kooooooooo00koool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo0P0001Coool00`1Vooooooooo`0joooo00<0I_ooooooool09_ooo`00>Ooo
o`0306Kooooooooo04?oool206Ko2?ooo`@00002oooo00@0003oooooool0000:oooo00<0003ooooo
ool01?ooo`030000oooooooo01;oool00`1Vooooooooo`0koooo00<0I_ooooooool09_ooo`00>?oo
o`0306Kooooooooo04Koool00`1Vooooooooo`0;oooo00@0003oooooool0000:oooo00<0003ooooo
ool01?ooo`030000oooooooo017oool00`1Vooooooooo`0loooo00<0I_ooooooool09_ooo`00>?oo
o`0306Kooooooooo04Ooool00`1Vooooooooo`0;oooo0P0000[oool200001_ooo`030000oooooooo
013oool00`1Vooooooooo`0moooo00<0I_ooooooool09_ooo`00=oooo`0306Kooooooooo04Woool0
0`1Vooooooooo`0Noooo00<0003oooooool03oooo`0306Kooooooooo03koool00`1Vooooooooo`0V
oooo000foooo00<0I_ooooooool0Boooo`0306Kooooooooo01goool200003oooo`0306Kooooooooo
03ooool00`1Vooooooooo`0Voooo000foooo00<0I_ooooooool0C?ooo`0306Kooooooooo01coool0
0`000?ooooooo`0=oooo00<0I_ooooooool0@?ooo`0306Kooooooooo02Koool003Goool00`1Voooo
ooooo`1>oooo0P1Voacoool00`000?ooooooo`0;oooo0P1Vod?oool00`1Vooooooooo`0Voooo000d
oooo00<0I_ooooooool0DOooo`80I_lJoooo00<0003oooooool02Oooo`80I_m5oooo00<0I_oooooo
ool09_ooo`00<oooo`0306Kooooooooo05Coool00`1Vooooooooo`0Goooo00<0003oooooool01ooo
o`80I_m7oooo00<0I_ooooooool09_ooo`00<oooo`0306Kooooooooo05Goool206Ko5oooo`800006
oooo0P1VodWoool00`1Vooooooooo`0Voooo000boooo00<0I_ooooooool0F?ooo`80I_lEoooo00<0
003oooooool00oooo`80I_m;oooo00<0I_ooooooool09_ooo`00<Oooo`0306Kooooooooo05_oool2
06Ko4oooo`030000oooooooo00;oool00`1Vooooooooo`1;oooo00<0I_ooooooool09_ooo`00;ooo
o`80I_mPoooo0P1Voa7oool00`000?ooooooo`0206KoC_ooo`0306Kooooooooo02Koool002Woool3
00000_ooo`0306Kooooooooo02?oool300009?ooo`@0000Doooo0`1Vo`koool00`00001Vo`1Vo`0T
oooo100002Ooool300009oooo`00:Oooo`050000oooooooo000006Ko02Ooool00`000?ooooooo`0S
oooo00<0003oooooool06?ooo`D0I_l6oooo0`1Vo`80000Uoooo00<0003oooooool0:Oooo`030000
oooooooo02Koool002Woool010000?ooo`1Vo`0002Goool500009Oooo`030000oooooooo01coool6
06Ko0oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo1@0002Ooool002?oool400000_oo
o`<0000Poooo100000;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo02Coool0
0`000?ooooooo`0Voooo00<0003oooooool09?ooo`040000oooooooo0000:?ooo`009oooo`80I_l0
0oooo`000?ooo`0Woooo00<0003oool000009Oooo`040000oooooooo00009Oooo`030000oooooooo
02Coool010000?ooooooo`0002Koool00`000?ooo`00000Xoooo000Toooo0`1Vo`?oool300009ooo
o`80000Voooo0P0002Koool00`000?ooooooo`0Uoooo0P0002Soool20000:?ooo`008_ooo`80I_n0
oooo0P00057oool00`1Vooooooooo`0Voooo000Ooooo0`1Voh;oool00`000?ooooooo`1@oooo00<0
I_ooooooool09_ooo`006oooo`@0I_n5oooo00<0003oooooool0D?ooo`0306Kooooooooo02Koool0
01Koool506KoROooo`030000oooooooo053oool00`1Vooooooooo`0Voooo000Coooo0`1Vohkoool0
0`000?ooooooo`1@oooo00<0I_ooooooool09_ooo`003Oooool0000600003_ooo`004oooo`030000
oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oool00000300000Dco`000`0003?o03?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`0003?o03?o0008<ol000<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003ooooo
ool01oooo`030000oooooooo01;oool002Soool00`000?ooooooo`0Voooo00<0003oooooool08Ooo
o`H0000Y<ol000<0003oooooool09_ooo`030000oooooooo02Koool00`000?ooooooo`0Woooo001j
oooo0`0002Lco`000`000?ooooooo`1?oooo00?o09Woooooool09oooo`00OOooo`80000U<ol000<0
003oooooool0Coooo`03o`2Ioooooooo02Ooool007ooool00`0003?o03?o000R<ol00P00053oool0
0ol0VOooooooo`0Woooo0020oooo00<0000co`0co`008C?o00030000oooooooo04ooool00ol0VOoo
ooooo`0Woooo0021oooo0P00024co`000`000?ooooooo`1?oooo00?o09Woooooool09oooo`00Pooo
o`030000<ol0<ol001hco`000`000?ooooooo`1?oooo00?o09Woooooool09oooo`00Poooo`030000
<ol0<ol001hco`000`000?ooooooo`1?oooo00?o09Woooooool09oooo`00Q?ooo`030000<ol0<ol0
01dco`020000D?ooo`03o`2Ioooooooo02Ooool008Goool00`0003?o03?o000L<ol000<0003ooooo
ool0Coooo`03o`2Ioooooooo02Ooool008Koool00`0003?o03?o000K<ol000<0003oooooool0Cooo
o`03o`2Ioooooooo02Ooool008Koool00`0003?o03?o000K<ol000<0003oooooool0Coooo`03o`2I
oooooooo02Ooool008OooolM<ol0O?ooo`00R?oooa`co`1loooo0028oooo73?o07coool008SooolL
<ol0O?ooo`00ROoooa/co`1loooo001ooooo00<0003oooooool01ooooaDco`000`0003?o03?o0003
<ol0O?ooo`00O_ooo`030000oooooooo00Soool00`0003?o03?o000C<ol000<0000co`0co`000S?o
07coool007koool00`000?ooooooo`02oooo0P0000Coool00`0003?o03?o0007<ol00P0000@co`02
000013?o00030000<ol0<ol0008co`1loooo001noooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`0003?o03?o0005<ol000@0000co`0co`000009<ol000<0000co`0co`000S?o
07coool007goool00`000?ooooooo`02oooo00<0003oooooool01_ooo`Xco`000`0003?o03?o0008
<ol000@0000co`0co`0co`1loooo001noooo00<0003oooooool01@0000Goool8<ol00P0000Xco`00
0`0003?o03?o0002<ol0O?ooo`00O_ooo`050000oooooooooooo000000Woool7<ol000<0000co`0c
o`002C?o00030000<ol0<ol0008co`1loooo001ooooo00<0003oooooool02_ooo`Lco`03000023?o
00030000<ol0<ol000<co`1loooo002<oooo63?o07coool008cooolH<ol0O?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
.2 1 0 r
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
.47015 .62411 L
.47512 .6346 L
.48444 .66014 L
.48965 .67871 L
.49447 .69932 L
.49972 .72635 L
.50537 .76197 L
.51041 .80076 L
.51502 .84337 L
.52407 .95233 L
.52887 1.02779 L
.53412 1.12849 L
.53956 1.25823 L
.54469 1.41066 L
.54963 1.59321 L
.55499 1.84183 L
.55944 2.10113 L
.56434 2.45844 L
.56964 2.96114 L
.57235 3.27835 L
.57525 3.67709 L
.57665 3.89402 L
.57797 4.1172 L
.57915 4.3336 L
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
.97619 .57049 L
.02381 .57049 L
F
0 g
.02381 .57049 m
.03279 .57049 L
.04262 .57049 L
.04758 .57049 L
.05288 .57049 L
.06244 .57049 L
.06788 .57049 L
.07379 .57049 L
.07899 .57049 L
.08451 .57049 L
.08947 .57049 L
.09494 .57049 L
.10458 .57049 L
.10978 .57049 L
.11472 .57049 L
.12399 .57049 L
.13397 .57049 L
.13962 .57049 L
.14487 .57049 L
.14994 .57049 L
.15543 .57049 L
.16539 .57049 L
.17508 .57049 L
.184 .57049 L
.19373 .5705 L
.20282 .5705 L
.21279 .5705 L
.21839 .5705 L
.22348 .5705 L
.2334 .5705 L
.24257 .57051 L
.25264 .57052 L
.25772 .57052 L
.26333 .57053 L
.27342 .57054 L
.28268 .57056 L
.29284 .57059 L
.29795 .57061 L
.30353 .57063 L
.31381 .5707 L
.32314 .57078 L
.32831 .57083 L
.33392 .57091 L
.34409 .57109 L
.35356 .57133 L
.35894 .5715 L
.36397 .5717 L
.37411 .57223 L
.37981 .57262 L
.38501 .57306 L
Mistroke
.39488 .57414 L
.40404 .57554 L
.41408 .57772 L
.41969 .57932 L
.42477 .58108 L
.43482 .58564 L
.44406 .59156 L
.4542 .60077 L
.4593 .60684 L
.46489 .6149 L
Mfstroke
.46489 .6149 m
.46668 .61803 L
s
.58043 .61803 m
.58045 .57049 L
.58167 .57049 L
.58297 .57049 L
.5853 .57049 L
.62302 .57049 L
.66319 .57049 L
.70184 .57049 L
.74295 .57049 L
.78254 .57049 L
.82062 .57049 L
.86115 .57049 L
.90016 .57049 L
.94163 .57049 L
.97619 .57049 L
s
1 0 .6 r
.02381 .57049 m
.06244 .57049 L
.10458 .57049 L
.14415 .57049 L
.18221 .57049 L
.22272 .57049 L
.26171 .57049 L
.30316 .57049 L
.34309 .57049 L
.3815 .57049 L
.42237 .57049 L
.46172 .57049 L
.49955 .57049 L
.53984 .57049 L
.57861 .57049 L
.61984 .57049 L
.65954 .57049 L
.69774 .57049 L
.73838 .57049 L
.77751 .57049 L
.81909 .57049 L
.85916 .57049 L
.89771 .57049 L
.91765 .57049 L
.92769 .57049 L
.93044 .57049 L
.93339 .57049 L
.93482 .57049 L
.93553 .57049 L
.93618 .57049 L
s
.93618 .57049 m
.93618 .61803 L
s
0 .4 1 r
.02381 .55691 m
.04262 .5515 L
.06244 .54345 L
.07286 .53794 L
.08255 .5318 L
.09388 .52315 L
.10458 .5132 L
.125 .48806 L
.14357 .45571 L
.16355 .40664 L
.18199 .34291 L
.20071 .25276 L
.21136 .18637 L
.21653 .14928 L
.21905 .12994 L
.22015 .12124 L
.22134 .11164 L
.22257 .10564 L
.22374 .1099 L
.2263 .11918 L
.23172 .13838 L
.24158 .1719 L
.26011 .2296 L
.30111 .33376 L
.3406 .407 L
.37857 .45748 L
.39808 .47739 L
.419 .49501 L
.43881 .5087 L
.46036 .52076 L
.4793 .52926 L
.5002 .53665 L
.51998 .54181 L
.53081 .54387 L
.53567 .54461 L
.54098 .54527 L
.54345 .54552 L
.54608 .54575 L
.54835 .54591 L
.55082 .54605 L
.55227 .54611 L
.55291 .54614 L
.55361 .54616 L
.55489 .54619 L
.55558 .5462 L
.55624 .5462 L
.55748 .54621 L
.55862 .5462 L
.55992 .54617 L
.56117 .54614 L
Mistroke
.56234 .54609 L
.56339 .54603 L
.56576 .54587 L
.56796 .54567 L
.57002 .54542 L
.57466 .54466 L
.57727 .54409 L
.57967 .54346 L
.60013 .53708 L
.61921 .52986 L
.65724 .51086 L
.67763 .49754 L
.6962 .48308 L
.73609 .44294 L
.77448 .39008 L
.81531 .31577 L
.85463 .22685 L
.89243 .13237 L
.91345 .083 L
.92264 .06411 L
.9275 .05517 L
.93017 .05063 L
.93269 .04662 L
.93388 .0448 L
.93515 .04296 L
.93581 .04202 L
.93654 .57049 L
.93782 .57049 L
.94248 .57049 L
.95157 .57049 L
.97143 .57049 L
.97619 .57049 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.570493 0.950822 [
[.10317 .55799 -6 -9 ]
[.10317 .55799 6 0 ]
[.2619 .55799 -6 -9 ]
[.2619 .55799 6 0 ]
[.42063 .55799 -6 -9 ]
[.42063 .55799 6 0 ]
[.7381 .55799 -3 -9 ]
[.7381 .55799 3 0 ]
[.89683 .55799 -3 -9 ]
[.89683 .55799 3 0 ]
[.56687 .09508 -24 -4.5 ]
[.56687 .09508 0 4.5 ]
[.56687 .19016 -24 -4.5 ]
[.56687 .19016 0 4.5 ]
[.56687 .28525 -24 -4.5 ]
[.56687 .28525 0 4.5 ]
[.56687 .38033 -24 -4.5 ]
[.56687 .38033 0 4.5 ]
[.56687 .47541 -24 -4.5 ]
[.56687 .47541 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .57049 m
.10317 .57674 L
s
[(-6)] .10317 .55799 0 1 Mshowa
.2619 .57049 m
.2619 .57674 L
s
[(-4)] .2619 .55799 0 1 Mshowa
.42063 .57049 m
.42063 .57674 L
s
[(-2)] .42063 .55799 0 1 Mshowa
.7381 .57049 m
.7381 .57674 L
s
[(2)] .7381 .55799 0 1 Mshowa
.89683 .57049 m
.89683 .57674 L
s
[(4)] .89683 .55799 0 1 Mshowa
.125 Mabswid
.14286 .57049 m
.14286 .57424 L
s
.18254 .57049 m
.18254 .57424 L
s
.22222 .57049 m
.22222 .57424 L
s
.30159 .57049 m
.30159 .57424 L
s
.34127 .57049 m
.34127 .57424 L
s
.38095 .57049 m
.38095 .57424 L
s
.46032 .57049 m
.46032 .57424 L
s
.5 .57049 m
.5 .57424 L
s
.53968 .57049 m
.53968 .57424 L
s
.61905 .57049 m
.61905 .57424 L
s
.65873 .57049 m
.65873 .57424 L
s
.69841 .57049 m
.69841 .57424 L
s
.77778 .57049 m
.77778 .57424 L
s
.81746 .57049 m
.81746 .57424 L
s
.85714 .57049 m
.85714 .57424 L
s
.06349 .57049 m
.06349 .57424 L
s
.02381 .57049 m
.02381 .57424 L
s
.93651 .57049 m
.93651 .57424 L
s
.97619 .57049 m
.97619 .57424 L
s
.25 Mabswid
0 .57049 m
1 .57049 L
s
.57937 .09508 m
.58562 .09508 L
s
[(-0.5)] .56687 .09508 1 0 Mshowa
.57937 .19016 m
.58562 .19016 L
s
[(-0.4)] .56687 .19016 1 0 Mshowa
.57937 .28525 m
.58562 .28525 L
s
[(-0.3)] .56687 .28525 1 0 Mshowa
.57937 .38033 m
.58562 .38033 L
s
[(-0.2)] .56687 .38033 1 0 Mshowa
.57937 .47541 m
.58562 .47541 L
s
[(-0.1)] .56687 .47541 1 0 Mshowa
.125 Mabswid
.57937 .01902 m
.58312 .01902 L
s
.57937 .03803 m
.58312 .03803 L
s
.57937 .05705 m
.58312 .05705 L
s
.57937 .07607 m
.58312 .07607 L
s
.57937 .1141 m
.58312 .1141 L
s
.57937 .13312 m
.58312 .13312 L
s
.57937 .15213 m
.58312 .15213 L
s
.57937 .17115 m
.58312 .17115 L
s
.57937 .20918 m
.58312 .20918 L
s
.57937 .2282 m
.58312 .2282 L
s
.57937 .24721 m
.58312 .24721 L
s
.57937 .26623 m
.58312 .26623 L
s
.57937 .30426 m
.58312 .30426 L
s
.57937 .32328 m
.58312 .32328 L
s
.57937 .3423 m
.58312 .3423 L
s
.57937 .36131 m
.58312 .36131 L
s
.57937 .39935 m
.58312 .39935 L
s
.57937 .41836 m
.58312 .41836 L
s
.57937 .43738 m
.58312 .43738 L
s
.57937 .45639 m
.58312 .45639 L
s
.57937 .49443 m
.58312 .49443 L
s
.57937 .51344 m
.58312 .51344 L
s
.57937 .53246 m
.58312 .53246 L
s
.57937 .55148 m
.58312 .55148 L
s
.57937 .58951 m
.58312 .58951 L
s
.57937 .60853 m
.58312 .60853 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oY?ooo`030000
oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?oo
o`030000oooooooo07Woool00:Coool00`000?ooooooo`1ioooo002Toooo0P0007[oool00:Coool0
0`000?ooooooo`1ioooo002Toooo00<0003oooooool0NOooo`00Y?ooo`030000oooooooo07Woool0
0:Coool20000N_ooo`00Y?ooo`030000oooooooo07Woool00:Coool00`000?ooooooo`1Ioooo0P1V
oakoool00:Coool00`000?ooooooo`1Ioooo0P1Voakoool00:Coool00`000?ooooooo`1Hoooo00<0
I_ooool0I_l07_ooo`00Y?ooo`80001Hoooo00@0I_ooooooool0I_lNoooo002Toooo00<0003ooooo
ool0E_ooo`0506Kooooooooooooo06Ko01koool00:Coool00`000?ooooooo`1Foooo00D0I_oooooo
ooooool0I_l07_ooo`00Y?ooo`030000oooooooo05Koool01@1Vooooooooooooo`1Vo`0Noooo002T
oooo00<0003oooooool0EOooo`0306Kooooooooo00;oool00`1Vooooooooo`0Loooo002Toooo0P00
05Koool00`1Vooooooooo`02oooo00<0I_ooooooool07?ooo`00Y?ooo`030000oooooooo05Coool0
0`1Vooooooooo`03oooo00<0I_ooooooool07?ooo`00Y?ooo`030000oooooooo05Coool00`1Voooo
ooooo`03oooo00<0I_ooooooool07?ooo`00T?ooo`800004oooo0P0000Coool200001_ooo`030000
oooooooo05Coool00`1Vooooooooo`03oooo00<0I_ooooooool07?ooo`00Soooo`040000oooooooo
00002?ooo`040000oooooooo00001Oooo`030000oooooooo05?oool00`1Vooooooooo`04oooo00<0
I_ooooooool07?ooo`00Soooo`040000oooooooo00002oooo`030000oooooooo00?oool20000E?oo
o`0306Kooooooooo00Coool00`1Vooooooooo`0Loooo0029oooo100000;oool010000?ooooooo`00
00Woool200001_ooo`030000oooooooo05;oool00`1Vooooooooo`05oooo00<0I_ooooooool07?oo
o`00Soooo`040000oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`1Boooo00<0
I_ooooooool01Oooo`0306Kooooooooo01coool004Ooool00`1Vooooooooo`16oooo0P0000[oool3
00001Oooo`030000oooooooo057oool00`1Vooooooooo`06oooo00<0I_ooooooool07?ooo`00A_oo
o`80I_mLoooo00<0003oooooool0DOooo`0306Kooooooooo00Koool00`1Vooooooooo`0Loooo0016
oooo0P1Voecoool20000DOooo`0306Kooooooooo00Ooool00`1Vooooooooo`0Loooo0016oooo00<0
I_ooool0I_l0Foooo`030000oooooooo053oool00`1Vooooooooo`07oooo00<0I_ooooooool07?oo
o`00A_ooo`0306Kooooo06Ko05_oool00`000?ooooooo`1?oooo00<0I_ooooooool02?ooo`0306Ko
oooooooo01coool004Koool00`1Vooooo`1Vo`1Koooo00<0003oooooool0Coooo`0306Kooooooooo
00Soool00`1Vooooooooo`0Loooo0016oooo00<0I_ooool0I_l0Foooo`030000oooooooo04koool0
0`1Vooooooooo`09oooo00<0I_ooooooool07?ooo`00A_ooo`0406Kooooooooo06KoF_ooo`80001?
oooo00<0I_ooooooool02Oooo`0306Kooooooooo01coool004Koool0101Vooooooooo`1Voe[oool0
0`000?ooooooo`1>oooo00<0I_ooooooool02Oooo`0306Kooooooooo01coool004Goool01@1Voooo
ooooooooo`1Vo`1Joooo00<0003oooooool0COooo`0306Kooooooooo00[oool00`1Vooooooooo`0L
oooo0015oooo00D0I_ooooooooooool0I_l0F_ooo`030000oooooooo04goool00`1Vooooooooo`0:
oooo00<0I_ooooooool07?ooo`00AOooo`0306Kooooooooo00;oool00`1Vooooooooo`1Goooo00<0
003oooooool0C?ooo`0306Kooooooooo00_oool00`1Vooooooooo`0Loooo0015oooo00<0I_oooooo
ool00_ooo`0306Kooooooooo05Ooool20000COooo`0306Kooooooooo00_oool00`1Vooooooooo`0L
oooo0015oooo00<0I_ooooooool00_ooo`0306Kooooooooo05Ooool00`000?ooooooo`1<oooo00<0
I_ooooooool02oooo`0306Kooooooooo01coool004Goool00`1Vooooooooo`03oooo00<0I_oooooo
ool0E_ooo`030000oooooooo04_oool00`1Vooooooooo`0<oooo00<0I_ooooooool07?ooo`00AOoo
o`0306Kooooooooo00?oool00`1Vooooooooo`1Foooo00<0003oooooool0Boooo`0306Kooooooooo
00coool00`1Vooooooooo`0Loooo0014oooo00<0I_ooooooool01Oooo`0306Kooooooooo05Goool0
0`000?ooooooo`1:oooo00<0I_ooooooool03Oooo`0306Kooooooooo01coool004Coool00`1Voooo
ooooo`05oooo00<0I_ooooooool0EOooo`80001;oooo00<0I_ooooooool03Oooo`0306Kooooooooo
01coool004Coool00`1Vooooooooo`05oooo00<0I_ooooooool0EOooo`030000oooooooo04[oool0
0`1Vooooooooo`0=oooo00<0I_ooooooool07?ooo`00A?ooo`0306Kooooooooo00Koool00`1Voooo
ooooo`1Doooo00<0003oooooool0BOooo`0306Kooooooooo00koool00`1Vooooooooo`0Loooo0014
oooo00<0I_ooooooool01_ooo`0306Kooooooooo043oool200001?ooo`800005oooo0`0000Coool0
0`000?ooooooo`19oooo00<0I_ooooooool03_ooo`0306Kooooooooo01coool004Coool00`1Voooo
ooooo`06oooo00<0I_ooooooool0?oooo`040000oooooooo00002oooo`030000oooooooo00?oool0
0`000?ooooooo`18oooo00<0I_ooooooool03oooo`0306Kooooooooo01coool004Coool00`1Voooo
ooooo`06oooo00<0I_ooooooool0?oooo`040000oooooooo00002?ooo`D00004oooo0P0004Woool0
0`1Vooooooooo`0?oooo00<0I_ooooooool07?ooo`00A?ooo`0306Kooooooooo00Ooool00`1Voooo
ooooo`0hoooo100000;oool010000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?oo
ooooo`18oooo00<0I_ooooooool03oooo`0306Kooooooooo01coool004?oool00`1Vooooooooo`08
oooo00<0I_ooooooool0?_ooo`040000oooooooo00002Oooo`030000oooo000000Goool00`000?oo
ooooo`17oooo00<0I_ooooooool04?ooo`0306Kooooooooo01coool004?oool00`1Vooooooooo`08
oooo00<0I_ooooooool0?oooo`80000;oooo0P0000Goool00`000?ooooooo`17oooo00<0I_oooooo
ool04?ooo`0306Kooooooooo01coool004?oool00`1Vooooooooo`08oooo00<0I_ooooooool0Dooo
o`030000oooooooo04Koool00`1Vooooooooo`0Aoooo00<0I_ooooooool07?ooo`00@oooo`0306Ko
oooooooo00Woool00`1Vooooooooo`1Boooo0P0004Ooool00`1Vooooooooo`0Aoooo00<0I_oooooo
ool07?ooo`00@oooo`0306Kooooooooo00Woool00`1Vooooooooo`1Boooo00<0003oooooool0A_oo
o`0306Kooooooooo017oool00`1Vooooooooo`0Loooo0013oooo00<0I_ooooooool02Oooo`0306Ko
oooooooo05;oool00`000?ooooooo`15oooo00<0I_ooooooool04_ooo`0306Kooooooooo01coool0
04;oool00`1Vooooooooo`0:oooo00<0I_ooooooool0D_ooo`030000oooooooo04Goool00`1Voooo
ooooo`0Boooo00<0I_ooooooool07?ooo`00@_ooo`0306Kooooooooo00_oool00`1Vooooooooo`1A
oooo00<0003oooooool0A?ooo`0306Kooooooooo01?oool00`1Vooooooooo`0Loooo0012oooo00<0
I_ooooooool02oooo`0306Kooooooooo057oool20000AOooo`0306Kooooooooo01?oool00`1Voooo
ooooo`0Loooo0012oooo00<0I_ooooooool02oooo`0306Kooooooooo057oool00`000?ooooooo`14
oooo00<0I_ooooooool04oooo`0306Kooooooooo01coool004;oool00`1Vooooooooo`0<oooo00<0
I_ooooooool0D?ooo`030000oooooooo04?oool00`1Vooooooooo`0Doooo00<0I_ooooooool07?oo
o`00@_ooo`0306Kooooooooo00coool00`1Vooooooooo`1@oooo00<0003oooooool0@oooo`0306Ko
oooooooo01Coool00`1Vooooooooo`0Loooo0011oooo00<0I_ooooooool03_ooo`0306Kooooooooo
04ooool00`000?ooooooo`12oooo00<0I_ooooooool05Oooo`0306Kooooooooo01coool0047oool0
0`1Vooooooooo`0>oooo00<0I_ooooooool0Coooo`800013oooo00<0I_ooooooool05Oooo`0306Ko
oooooooo01coool0047oool00`1Vooooooooo`0>oooo00<0I_ooooooool0Coooo`030000oooooooo
047oool00`1Vooooooooo`0Foooo00<0I_ooooooool07?ooo`00@Oooo`0306Kooooooooo00ooool0
0`1Vooooooooo`1>oooo00<0003oooooool0@Oooo`0306Kooooooooo01Koool00`1Vooooooooo`0L
oooo0011oooo00<0I_ooooooool03oooo`0306Kooooooooo04koool00`000?ooooooo`11oooo00<0
I_ooooooool05_ooo`0306Kooooooooo01coool0043oool00`1Vooooooooo`0Aoooo00<0I_oooooo
ool0COooo`030000oooooooo043oool00`1Vooooooooo`0Goooo00<0I_ooooooool07?ooo`00@?oo
o`0306Kooooooooo017oool00`1Vooooooooo`1=oooo0P00047oool00`1Vooooooooo`0Goooo00<0
I_ooooooool07?ooo`00@?ooo`0306Kooooooooo017oool00`1Vooooooooo`1=oooo00<0003ooooo
ool0?oooo`0306Kooooooooo01Soool00`1Vooooooooo`0Loooo0010oooo00<0I_ooooooool04_oo
o`0306Kooooooooo04coool00`000?ooooooo`0ooooo00<0I_ooooooool06?ooo`0306Kooooooooo
01coool0043oool00`1Vooooooooo`0Boooo00<0I_ooooooool0>?ooo`800004oooo0P0000Coool2
00001_ooo`030000oooooooo03koool00`1Vooooooooo`0Ioooo00<0I_ooooooool07?ooo`00?ooo
o`0306Kooooooooo01?oool00`1Vooooooooo`0goooo00@0003oooooool00008oooo00@0003ooooo
ool00005oooo00<0003oooooool0?_ooo`0306Kooooooooo01Woool00`1Vooooooooo`0Loooo000o
oooo00<0I_ooooooool05?ooo`0306Kooooooooo03Koool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo0P0003koool00`1Vooooooooo`0Joooo00<0I_ooooooool07?ooo`00?oooo`0306Ko
oooooooo01Coool00`1Vooooooooo`0`oooo100000;oool010000?ooooooo`0000_oool00`000?oo
ooooo`03oooo00<0003oooooool0?Oooo`0306Kooooooooo01[oool00`1Vooooooooo`0Loooo000o
oooo00<0I_ooooooool05Oooo`0306Kooooooooo03Goool010000?ooooooo`0000Soool010000?oo
ooooo`0000Goool00`000?ooooooo`0moooo00<0I_ooooooool06_ooo`0306Kooooooooo01coool0
03koool00`1Vooooooooo`0Foooo00<0I_ooooooool0=_ooo`80000:oooo0P0000Koool00`000?oo
ooooo`0loooo00<0I_ooooooool06oooo`0306Kooooooooo01coool003koool00`1Vooooooooo`0F
oooo00<0I_ooooooool0B_ooo`030000oooooooo03coool00`1Vooooooooo`0Koooo00<0I_oooooo
ool07?ooo`00?_ooo`0306Kooooooooo01Ooool00`1Vooooooooo`19oooo0P0003coool00`1Voooo
ooooo`0Loooo00<0I_ooooooool07?ooo`00?_ooo`0306Kooooooooo01Ooool00`1Vooooooooo`19
oooo00<0003oooooool0>oooo`0306Kooooooooo01coool00`1Vooooooooo`0Loooo000noooo00<0
I_ooooooool06?ooo`0306Kooooooooo04Soool00`000?ooooooo`0joooo00<0I_ooooooool07Ooo
o`0306Kooooooooo01coool003goool00`1Vooooooooo`0Ioooo00<0I_ooooooool0B?ooo`030000
oooooooo03[oool00`1Vooooooooo`0Moooo00<0I_ooooooool07?ooo`00?Oooo`0306Kooooooooo
01Woool00`1Vooooooooo`18oooo00<0003oooooool0>Oooo`0306Kooooooooo01koool00`1Voooo
ooooo`0Loooo000moooo00<0I_ooooooool06_ooo`0306Kooooooooo04Ooool20000>_ooo`0306Ko
oooooooo01koool00`1Vooooooooo`0Loooo000moooo00<0I_ooooooool06_ooo`0306Kooooooooo
04Ooool00`000?ooooooo`0hoooo00<0I_ooooooool07oooo`0306Kooooooooo01coool003goool0
0`1Vooooooooo`0Koooo00<0I_ooooooool0A_ooo`030000oooooooo03Soool00`1Vooooooooo`0O
oooo00<0I_ooooooool07?ooo`00??ooo`0306Kooooooooo01coool00`1Vooooooooo`16oooo00<0
003oooooool0=oooo`0306Kooooooooo023oool00`1Vooooooooo`0Loooo000loooo00<0I_oooooo
ool07Oooo`0306Kooooooooo04Goool00`000?ooooooo`0goooo00<0I_ooooooool08?ooo`0306Ko
oooooooo01coool003coool00`1Vooooooooo`0Moooo00<0I_ooooooool0AOooo`80000goooo00<0
I_ooooooool08Oooo`0306Kooooooooo01coool003coool00`1Vooooooooo`0Noooo00<0I_oooooo
ool0A?ooo`030000oooooooo03Koool00`1Vooooooooo`0Qoooo00<0I_ooooooool07?ooo`00>ooo
o`0306Kooooooooo01ooool00`1Vooooooooo`14oooo00<0003oooooool0=Oooo`0306Kooooooooo
02;oool00`1Vooooooooo`0Loooo000koooo00<0I_ooooooool08?ooo`0306Kooooooooo04?oool0
0`000?ooooooo`0eoooo00<0I_ooooooool08_ooo`0306Kooooooooo01coool003_oool00`1Voooo
ooooo`0Poooo00<0I_ooooooool0@oooo`030000oooooooo03Coool00`1Vooooooooo`0Soooo00<0
I_ooooooool07?ooo`00>oooo`0306Kooooooooo027oool00`1Vooooooooo`12oooo0P0003Goool0
0`1Vooooooooo`0Soooo00<0I_ooooooool07?ooo`00>_ooo`0306Kooooooooo02;oool00`1Voooo
ooooo`12oooo00<0003oooooool0<oooo`0306Kooooooooo02Coool00`1Vooooooooo`0Loooo000j
oooo00<0I_ooooooool08oooo`0306Kooooooooo047oool00`000?ooooooo`0coooo00<0I_oooooo
ool09?ooo`0306Kooooooooo01coool003[oool00`1Vooooooooo`0Soooo00<0I_ooooooool0;Ooo
o`800004oooo0P0000?oool400001Oooo`030000oooooooo03;oool00`1Vooooooooo`0Uoooo00<0
I_ooooooool07?ooo`00>Oooo`0306Kooooooooo02Goool00`1Vooooooooo`0[oooo00@0003ooooo
ool00008oooo00<0003oooooool01_ooo`030000oooooooo03;oool00`1Vooooooooo`0Uoooo00<0
I_ooooooool07?ooo`00>Oooo`0306Kooooooooo02Goool00`1Vooooooooo`0[oooo00@0003ooooo
ool00009oooo00<0003oooooool01Oooo`80000boooo00<0I_ooooooool09_ooo`0306Kooooooooo
01coool003Woool00`1Vooooooooo`0Voooo00<0I_ooooooool09?ooo`@00002oooo00@0003ooooo
ool0000:oooo00<0003oooooool01?ooo`030000oooooooo037oool00`1Vooooooooo`0Voooo00<0
I_ooooooool07?ooo`00>?ooo`0306Kooooooooo02Ooool00`1Vooooooooo`0Zoooo00@0003ooooo
ool00008oooo00@0003oooooool00005oooo00<0003oooooool0<?ooo`0306Kooooooooo02Ooool0
0`1Vooooooooo`0Loooo000hoooo00<0I_ooooooool0:?ooo`0306Kooooooooo02[oool200002_oo
o`800006oooo00<0003oooooool0;oooo`0306Kooooooooo02Soool00`1Vooooooooo`0Loooo000h
oooo00<0I_ooooooool0:?ooo`0306Kooooooooo03koool00`000?ooooooo`0_oooo00<0I_oooooo
ool0:?ooo`0306Kooooooooo01coool003Soool00`1Vooooooooo`0Yoooo00<0I_ooooooool0?Ooo
o`80000_oooo00<0I_ooooooool0:Oooo`0306Kooooooooo01coool003Ooool00`1Vooooooooo`0Z
oooo00<0I_ooooooool0?Oooo`030000oooooooo02goool00`1Vooooooooo`0Zoooo00<0I_oooooo
ool07?ooo`00=oooo`0306Kooooooooo02_oool00`1Vooooooooo`0loooo00<0003oooooool0;?oo
o`0306Kooooooooo02_oool00`1Vooooooooo`0Loooo000goooo00<0I_ooooooool0;?ooo`0306Ko
oooooooo03_oool00`000?ooooooo`0/oooo00<0I_ooooooool0:oooo`0306Kooooooooo01coool0
03Koool00`1Vooooooooo`0^oooo00<0I_ooooooool0>_ooo`030000oooooooo02_oool00`1Voooo
ooooo`0/oooo00<0I_ooooooool07?ooo`00=_ooo`0306Kooooooooo02koool00`1Vooooooooo`0j
oooo0P0002_oool00`1Vooooooooo`0]oooo00<0I_ooooooool07?ooo`00=Oooo`0306Kooooooooo
033oool00`1Vooooooooo`0ioooo00<0003oooooool0:_ooo`0306Kooooooooo02goool00`1Voooo
ooooo`0Loooo000eoooo00<0I_ooooooool0<Oooo`0306Kooooooooo03Soool00`000?ooooooo`0Y
oooo00<0I_ooooooool0;_ooo`0306Kooooooooo01coool003Coool00`1Vooooooooo`0coooo00<0
I_ooooooool0=oooo`030000oooooooo02Soool00`1Vooooooooo`0_oooo00<0I_ooooooool07?oo
o`00=?ooo`0306Kooooooooo03?oool00`1Vooooooooo`0goooo00<0003oooooool09oooo`0306Ko
oooooooo033oool00`1Vooooooooo`0Loooo000doooo00<0I_ooooooool0=?ooo`0306Kooooooooo
03Koool20000:?ooo`0306Kooooooooo033oool00`1Vooooooooo`0Loooo000coooo00<0I_oooooo
ool0=_ooo`0306Kooooooooo03Goool00`000?ooooooo`0Voooo00<0I_ooooooool0<Oooo`0306Ko
oooooooo01coool003?oool00`1Vooooooooo`0goooo00<0I_ooooooool0=?ooo`030000oooooooo
02Goool00`1Vooooooooo`0boooo00<0I_ooooooool07?ooo`00<_ooo`0306Kooooooooo03Soool0
0`1Vooooooooo`0doooo00<0003oooooool09?ooo`0306Kooooooooo03?oool00`1Vooooooooo`0L
oooo000boooo00<0I_ooooooool0>Oooo`0306Kooooooooo03?oool00`000?ooooooo`0Soooo00<0
I_ooooooool0=?ooo`0306Kooooooooo01coool0037oool00`1Vooooooooo`0koooo00<0I_oooooo
ool0<_ooo`80000Soooo00<0I_ooooooool0=Oooo`0306Kooooooooo01coool0037oool00`1Voooo
ooooo`0loooo00<0I_ooooooool0<Oooo`030000oooooooo023oool206Ko>?ooo`0306Kooooooooo
01coool0033oool00`1Vooooooooo`0noooo00<0I_ooooooool07?ooo`800004oooo0P0000?oool5
00001?ooo`030000oooooooo01ooool00`1Vooooooooo`0hoooo00<0I_ooooooool07?ooo`00<?oo
o`0306Kooooooooo03ooool00`1Vooooooooo`0Joooo00@0003oooooool0000:oooo00<0003ooooo
ool01?ooo`030000oooooooo01koool00`1Vooooooooo`0ioooo00<0I_ooooooool07?ooo`00;ooo
o`0306Kooooooooo047oool00`1Vooooooooo`0Ioooo00@0003oooooool0000:oooo00<0003ooooo
ool01?ooo`80000Noooo00<0I_ooooooool0>_ooo`0306Kooooooooo01coool002ooool00`1Voooo
ooooo`12oooo00<0I_ooooooool04_ooo`@00002oooo00@0003oooooool0000:oooo00<0003ooooo
ool01?ooo`030000oooooooo01coool00`1Vooooooooo`0koooo00<0I_ooooooool07?ooo`00;_oo
o`0306Kooooooooo04Coool00`1Vooooooooo`0Goooo00@0003oooooool0000:oooo00<0003ooooo
ool01?ooo`030000oooooooo01_oool00`1Vooooooooo`0loooo00<0I_ooooooool07?ooo`00;_oo
o`0306Kooooooooo04Goool00`1Vooooooooo`0Goooo0P0000[oool200001_ooo`030000oooooooo
01[oool00`1Vooooooooo`0moooo00<0I_ooooooool07?ooo`00;Oooo`0306Kooooooooo04Ooool2
06Ko:oooo`030000oooooooo01Soool206Ko@?ooo`0306Kooooooooo01coool002coool00`1Voooo
ooooo`1:oooo00<0I_ooooooool0:?ooo`80000Hoooo00<0I_ooooooool0@?ooo`0306Kooooooooo
01coool002_oool00`1Vooooooooo`1<oooo00<0I_ooooooool09oooo`030000oooooooo01Koool0
0`1Vooooooooo`11oooo00<0I_ooooooool07?ooo`00:_ooo`0306Kooooooooo04koool206Ko9ooo
o`030000oooooooo01Goool00`1Vooooooooo`12oooo00<0I_ooooooool07?ooo`00:_ooo`0306Ko
oooooooo053oool206Ko9Oooo`030000oooooooo01?oool206KoAOooo`0306Kooooooooo01coool0
02Woool00`1Vooooooooo`1Coooo00<0I_ooooooool08_ooo`030000oooooooo01;oool00`1Voooo
ooooo`15oooo00<0I_ooooooool07?ooo`00:?ooo`0306Kooooooooo05Goool206Ko8_ooo`80000B
oooo00<0I_ooooooool0A_ooo`0306Kooooooooo01coool002Ooool00`1Vooooooooo`1Hoooo0P1V
ob3oool00`000?ooooooo`0?oooo0P1VodWoool00`1Vooooooooo`0Loooo000Voooo00<0I_oooooo
ool0Foooo`80I_lNoooo00<0003oooooool03Oooo`80I_m;oooo00<0I_ooooooool07?ooo`009Ooo
o`0306Kooooooooo05koool206Ko7?ooo`030000oooooooo00_oool206KoCOooo`0306Kooooooooo
01coool002?oool206Ko1?ooo`<0000Xoooo0`0002Coool400002Oooo`80I_lJoooo00<0003ooooo
ool02Oooo`80I_lIoooo100002Ooool300002?ooo`0306Kooooooooo01coool002;oool00`1Voooo
ooooo`04oooo00@0003oooooool0000Xoooo00<0003oooooool08oooo`030000oooooooo00coool3
06Ko5oooo`800007oooo0`1Voa_oool00`000?ooooooo`0Yoooo00<0003oooooool01oooo`0306Ko
oooooooo01coool0027oool00`1Vooooooooo`05oooo00@0003oooooool0000Uoooo1@0002Goool0
0`000?ooooooo`0>oooo101Voa?oool00`000?ooooooo`04oooo0P1Voaooool00`000?ooooooo`0U
oooo1@0000Soool00`1Vooooooooo`0Loooo000Ooooo0P1Vo`;oool400000_ooo`<0000Poooo1000
00;oool010000?ooooooo`0001ooool400001?ooo`030000oooooooo017oool206Ko4Oooo`030000
oooooooo00@0I_lRoooo00<0003oooooool09?ooo`040000oooooooo00002Oooo`0306Kooooooooo
01coool001coool306Ko2oooo`030000oooooooo02Koool00`000?ooo`00000Uoooo00@0003ooooo
ool0000Doooo1@1Vo`_oool0101Vo`00001Vo`1VobCoool010000?ooooooo`0002Koool00`000?oo
o`000009oooo00<0I_ooooooool07?ooo`006_ooo`80I_l>oooo0`0002Ooool200009_ooo`80000J
oooo2`1Vo`03oooo0000oooo02Koool20000:?ooo`800009oooo00<0I_ooooooool07?ooo`005ooo
o`<0I_n:oooo0P0005_oool00`1Vooooooooo`0Loooo000Eoooo0P1Vohgoool00`000?ooooooo`1J
oooo00<0I_ooooooool07?ooo`004oooo`80I_n?oooo00<0003oooooool0F_ooo`0306Kooooooooo
01coool00:Coool00`000?ooooooo`1Joooo00<0I_ooooooool07?ooo`00Y?ooo`030000oooooooo
05[oool00`1Vooooooooo`0Loooo000=ooooo`0000H0000>oooo000Coooo00<0003oooooool01ooo
o`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?oo
o`00000<00001C?o00030000<ol0<ol000Pco`000`0003?o03?o0007<ol000<0000co`0co`001c?o
00030000<ol0<ol000Pco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?oo
ooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0
003oooooool04_ooo`00:?ooo`030000oooooooo02Koool00`000?ooooooo`0Qoooo1P0002Tco`00
0`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo00Soool00ol0VOooooooo`0L
oooo001joooo0`0002Lco`000`000?ooooooo`1Joooo00?o09Woooooool07?ooo`00OOooo`80000U
<ol000<0003oooooool0F_ooo`03o`2Ioooooooo01coool007ooool00`0003?o03?o000R<ol00P00
05_oool00ol0VOooooooo`0Loooo0020oooo00<0000co`0co`008C?o00030000oooooooo05[oool0
0ol0VOooooooo`0Loooo0021oooo0P00024co`000`000?ooooooo`1Joooo00?o09Woooooool07?oo
o`00Poooo`030000<ol0<ol001hco`000`000?ooooooo`1Joooo00?o09Woooooool07?ooo`00Pooo
o`030000<ol0<ol001hco`000`000?ooooooo`1Joooo00?o09Woooooool07?ooo`00Q?ooo`030000
<ol0<ol001dco`020000Foooo`03o`2Ioooooooo01coool008Goool00`0003?o03?o000L<ol000<0
003oooooool0F_ooo`03o`2Ioooooooo01coool008Koool00`0003?o03?o000K<ol000<0003ooooo
ool0F_ooo`03o`2Ioooooooo01coool008Koool00`0003?o03?o000K<ol000<0003oooooool0F_oo
o`03o`2Ioooooooo01coool008OooolM<ol0O?ooo`00R?oooa`co`1loooo0028oooo73?o07coool0
08SooolL<ol0O?ooo`00ROoooa/co`1loooo001loooo00<0003oooooool02_oooaPco`000`0003?o
03?o001loooo001koooo00<0003oooooool02?ooo`040000oooooooooooo63?o00030000<ol0oooo
07_oool007_oool00`000?ooooooo`02oooo0P0000Coool010000?ooooooooooo`Hco`02000013?o
00800004<ol00P0000@co`000`0003?o0?ooo`1koooo001koooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool010000?ooooooooooo`@co`00100003?o03?o000000Pco`00100003?o
03?o000000<co`000`0003?o0?ooo`1koooo001joooo00<0003oooooool00_ooo`030000oooooooo
00Woool7<ol000<0000co`0co`002C?o00030000<ol0<ol0008co`000`000?ooooooo`1joooo001k
oooo00<0003oooooool01@0000Soool5<ol00P0000Xco`02000013?o00030000<ol0oooo07_oool0
07_oool01@000?ooooooooooo`00000<oooo13?o00030000<ol0<ol000Tco`000`0003?o03?o0003
<ol000<0000co`3oool0Noooo`00O?ooo`030000oooooooo00goool4<ol00`0000Tco`0300000S?o
00030000<ol0<ol007coool008cooolH<ol0O?ooo`00S?oooaPco`1loooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-7.93429, \
-0.600003, 0.0483331, 0.00403436}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-7.93429, -0.600003, 0.0483331, 0.00403436}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-2\), \ 
              0.5}, \ PlotRange -> {\(- .05\),  .05}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-2\), \ 0.5}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(- .05\),  .05}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{g[x, t]}, {x, \ \(-2\), \ 0.5}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(- .05\),  .05}]}, \[IndentingNewLine]\ {t, \ \
\(-0.3\), \ 0.3,  .01}, PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.27731 .30902 L
.28302 .30902 L
.28542 .30902 L
.288 .30902 L
.28876 .30902 L
.28948 .30902 L
.29013 .30902 L
s
.29013 .30902 m
.29013 .61803 L
s
0 .4 1 r
.02381 .3471 m
.06244 .35298 L
.10458 .36044 L
.14415 .3686 L
.18221 .37768 L
.22272 .38888 L
.26171 .4014 L
.27193 .40499 L
.27731 .40695 L
.28302 .40906 L
.28542 .40996 L
.288 .41094 L
.28876 .41123 L
.28948 .41151 L
.29013 .41176 L
.29083 .30902 L
.2915 .30902 L
.29221 .30902 L
.29349 .30902 L
.29474 .30902 L
.29545 .30902 L
.2961 .30902 L
.29729 .30902 L
.29856 .30902 L
.29969 .30902 L
.30075 .30902 L
.30191 .30902 L
.30316 .30902 L
.30437 .30902 L
.30507 .30902 L
.30572 .30902 L
.30703 .30902 L
.30776 .30902 L
.30844 .30902 L
.30958 .30902 L
.31082 .30902 L
.31212 .30902 L
.31333 .30902 L
.31402 .30902 L
.31477 .30902 L
.31543 .30902 L
.31613 .30902 L
.31676 .30902 L
.31746 .30902 L
.31868 .30902 L
.31942 .30902 L
.3201 .30902 L
.32089 .30902 L
.32163 .30902 L
.32295 .30902 L
Mistroke
.3237 .30902 L
.3244 .30902 L
.32566 .30902 L
.32638 .30902 L
.32703 .30902 L
.32824 .30902 L
.32951 .30902 L
.33065 .30902 L
.33172 .30902 L
.33289 .30902 L
.33414 .30902 L
.33484 .30902 L
.33548 .30902 L
.33618 .30902 L
.33693 .30902 L
.33819 .30902 L
.3389 .30902 L
.33957 .30902 L
.34081 .30902 L
.34195 .30902 L
.3432 .30902 L
.34452 .30902 L
.34576 .30902 L
.34646 .30902 L
.3471 .30902 L
.34828 .30902 L
.34953 .30902 L
.35066 .30902 L
.3517 .30902 L
.35285 .30902 L
.35409 .30902 L
.3554 .30902 L
.35614 .30902 L
.35683 .30902 L
.35809 .30902 L
.35872 .30902 L
.35943 .30902 L
.36063 .30902 L
.36194 .30902 L
.36317 .30902 L
.3643 .30902 L
.36537 .30902 L
.36651 .30902 L
.3675 .30902 L
.36857 .30902 L
.36983 .30902 L
.37102 .30902 L
.37218 .30902 L
.37325 .30902 L
.37437 .30902 L
Mistroke
.37543 .30902 L
.37658 .30902 L
.37783 .30902 L
.37913 .30902 L
.38036 .30902 L
.38147 .30902 L
.38268 .30902 L
.38332 .30902 L
.38401 .30902 L
.38523 .30902 L
.38655 .30902 L
.3873 .30902 L
.388 .30902 L
.38926 .30902 L
.39041 .30902 L
.39105 .30902 L
.39175 .30902 L
.39301 .30902 L
.39413 .30902 L
.39536 .30902 L
.39666 .30902 L
.39787 .30902 L
.399 .30902 L
.40003 .30902 L
.40117 .30902 L
.40236 .30902 L
.40368 .30902 L
.40488 .30902 L
.40554 .30902 L
.40626 .30902 L
.40756 .30902 L
.40878 .30902 L
.41007 .30902 L
.41117 .30902 L
.41239 .30902 L
.41312 .30902 L
.41381 .30902 L
.41512 .30902 L
.41584 .30902 L
.41652 .30902 L
.41726 .30902 L
.41805 .30902 L
.41874 .30902 L
.41948 .30902 L
.42018 .30902 L
.42083 .30902 L
.42205 .30902 L
.42334 .30902 L
.42457 .30902 L
.42526 .30902 L
Mistroke
.4259 .30902 L
.42708 .30902 L
.42832 .30902 L
.42944 .30902 L
.43048 .30902 L
.43162 .30902 L
.43286 .30902 L
.43416 .30902 L
.4349 .30902 L
.43558 .30902 L
.43683 .30902 L
.43753 .30902 L
.43817 .30902 L
.43937 .30902 L
.44067 .30902 L
.4419 .30902 L
.44303 .30902 L
.4441 .30902 L
.44523 .30902 L
.44631 .30902 L
.44729 .30902 L
.44844 .30902 L
.44969 .30902 L
.45087 .30902 L
.45196 .30902 L
.45308 .30902 L
.45413 .30902 L
.45528 .30902 L
.45653 .30902 L
.45776 .30902 L
.45906 .30902 L
.46017 .30902 L
.46139 .30902 L
.4627 .30902 L
.46392 .30902 L
.46456 .30902 L
.46525 .30902 L
.46598 .30902 L
.46667 .30902 L
.46792 .30902 L
.46907 .30902 L
.46971 .30902 L
.4704 .30902 L
.47165 .30902 L
.47289 .30902 L
.474 .30902 L
.47529 .30902 L
.4765 .30902 L
.47762 .30902 L
.47866 .30902 L
Mistroke
.47979 .30902 L
.48099 .30902 L
.48229 .30902 L
.48348 .30902 L
.48414 .30902 L
.48486 .30902 L
.48616 .30902 L
.48737 .30902 L
.48866 .30902 L
.48976 .30902 L
.49098 .30902 L
.49167 .30902 L
.4924 .30902 L
.4937 .30902 L
.49443 .30902 L
.4951 .30902 L
.49584 .30902 L
.49663 .30902 L
.49732 .30902 L
.49806 .30902 L
.49941 .30902 L
.50073 .30902 L
.50193 .30902 L
.50319 .30902 L
.50438 .30902 L
.50545 .30902 L
.50662 .30902 L
.50789 .30902 L
.50852 .30902 L
.50923 .30902 L
.51048 .30902 L
.51165 .30902 L
.51276 .30902 L
.51393 .30902 L
.51492 .30902 L
.51601 .30902 L
.51719 .30902 L
.51845 .30902 L
.51964 .30902 L
.52073 .30902 L
.52201 .30902 L
.52266 .30902 L
.52337 .30902 L
.52464 .30902 L
.52582 .30902 L
.52653 .30902 L
.52721 .30902 L
.52848 .30902 L
.52919 .30902 L
.52985 .30902 L
Mistroke
.53057 .30902 L
.53134 .30902 L
.53265 .30902 L
.53338 .30902 L
.53405 .30902 L
.5353 .30902 L
.53661 .30902 L
.53778 .30902 L
.53888 .30902 L
.54009 .30902 L
.54138 .30902 L
.5426 .30902 L
.54329 .30902 L
.54394 .30902 L
.54525 .30902 L
.54599 .30902 L
.54666 .30902 L
.5478 .30902 L
.54905 .30902 L
.55035 .30902 L
.55156 .30902 L
.55225 .30902 L
.553 .30902 L
.55371 .30902 L
.55436 .30902 L
.5556 .30902 L
.55691 .30902 L
.55759 .30902 L
.55831 .30902 L
.55963 .30902 L
.56262 .30902 L
.58275 .30902 L
.59232 .30902 L
.59507 .30902 L
.59573 .30902 L
.59642 .30902 L
.59766 .30902 L
.59877 .30902 L
.59999 .30902 L
.60129 .30902 L
.6025 .30902 L
.6032 .30902 L
.60395 .30902 L
.60467 .30902 L
.60533 .30902 L
.60657 .30902 L
.6079 .30902 L
.60858 .30902 L
.60922 .30902 L
.60996 .30902 L
Mistroke
.61064 .30902 L
.61139 .30902 L
.61221 .30902 L
.61297 .30902 L
.61367 .30902 L
.61432 .30902 L
.61503 .30902 L
.6163 .30902 L
.61754 .30902 L
.61868 .30902 L
.61992 .30902 L
.62063 .30902 L
.62128 .30902 L
.62196 .30902 L
.62261 .30902 L
.62335 .30902 L
.62403 .30902 L
.6252 .30902 L
.62631 .30902 L
.62752 .30902 L
.62882 .30902 L
.63012 .30902 L
.63077 .30902 L
.63148 .30902 L
.63274 .30902 L
.63392 .30902 L
.63511 .30902 L
.63624 .30902 L
.63725 .30902 L
.63834 .30902 L
.63954 .30902 L
.6408 .30902 L
.64188 .30902 L
.64307 .30902 L
.64434 .30902 L
.64505 .30902 L
.64572 .30902 L
.64694 .30902 L
.64823 .30902 L
.64901 .30902 L
.64975 .30902 L
.65041 .30902 L
.65113 .30902 L
.6518 .30902 L
.65251 .30902 L
.65378 .30902 L
.65497 .30902 L
.65625 .30902 L
.65746 .30902 L
.65856 .30902 L
Mistroke
.65985 .30902 L
.66058 .30902 L
.66125 .30902 L
.66249 .30902 L
.6638 .30902 L
.66494 .30902 L
.66619 .30902 L
.66749 .30902 L
.6687 .30902 L
.66983 .30902 L
.67087 .30902 L
.67206 .30902 L
.67318 .30902 L
.67441 .30902 L
.67571 .30902 L
.67682 .30902 L
.67803 .30902 L
.67934 .30902 L
.68008 .30902 L
.68075 .30902 L
.68205 .30902 L
.68329 .30902 L
.68445 .30902 L
.68549 .30902 L
.6867 .30902 L
.68783 .30902 L
.68889 .30902 L
.68986 .30902 L
.69092 .30902 L
.69204 .30902 L
.69318 .30902 L
.6944 .30902 L
.69555 .30902 L
.69659 .30902 L
.69782 .30902 L
.69851 .30902 L
.69916 .30902 L
.70033 .30902 L
.70158 .30902 L
.70278 .30902 L
.7041 .30902 L
.70534 .30902 L
.70649 .30902 L
.70763 .30902 L
.70867 .30902 L
.70986 .30902 L
.71099 .30902 L
.71222 .30902 L
.71352 .30902 L
.71463 .30902 L
Mistroke
.71585 .30902 L
.71716 .30902 L
.7179 .30902 L
.71857 .30902 L
.71987 .30902 L
.72111 .30902 L
.72216 .30902 L
.72332 .30902 L
.72453 .30902 L
.72566 .30902 L
.72672 .30902 L
.72769 .30902 L
.72875 .30902 L
.72987 .30902 L
.73101 .30902 L
.73207 .30902 L
.73331 .30902 L
.73443 .30902 L
.73566 .30902 L
.73636 .30902 L
.73701 .30902 L
.73817 .30902 L
.73941 .30902 L
.74062 .30902 L
.74194 .30902 L
.74318 .30902 L
.74434 .30902 L
.74546 .30902 L
.74652 .30902 L
.74774 .30902 L
.74884 .30902 L
.75008 .30902 L
.75138 .30902 L
.75249 .30902 L
.75371 .30902 L
.75503 .30902 L
.75577 .30902 L
.75644 .30902 L
.75774 .30902 L
.75898 .30902 L
.76003 .30902 L
.76119 .30902 L
.7624 .30902 L
.76354 .30902 L
.7646 .30902 L
.76557 .30902 L
.76663 .30902 L
.76775 .30902 L
.7689 .30902 L
.77012 .30902 L
Mistroke
.77127 .30902 L
.77231 .30902 L
.77354 .30902 L
.77424 .30902 L
.77487 .30902 L
.77605 .30902 L
.77729 .30902 L
.77851 .30902 L
.77919 .30902 L
.77983 .30902 L
.781 .30902 L
.78224 .30902 L
.78334 .30902 L
.78438 .30902 L
.78552 .30902 L
.78675 .30902 L
.78798 .30902 L
.78933 .30902 L
.79204 .30902 L
.7969 .30902 L
.81523 .30902 L
.85575 .30902 L
.89476 .30902 L
.93622 .30902 L
.97616 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0
000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001c?o00030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`0Coooo000Aoooo00<0000co`0c
o`00;c?o00030000<ol0<ol0014co`000`1Voc?o03?o000K<ol000<0000co`0co`00;S?o00030000
<ol0<ol002lco`000`000?ooooooo`0_oooo00<0003oooooool04oooo`004OooodHco`000`1Voc?o
03?o001n<ol000<0003oooooool0AOooo`004OooodHco`000`1Voc?o03?o001n<ol000<0003ooooo
ool0AOooo`004OooodHco`000`1Voc?o03?o001n<ol000<0003oooooool0AOooo`004OooodHco`00
0`1Voc?o03?o001n<ol000<0003oooooool0AOooo`004OooodHco`000`1Voc?o03?o001n<ol000<0
003oooooool0AOooo`004OooodHco`000`1Voc?o03?o001n<ol00P0004Koool0017ooom6<ol000<0
I_lco`0co`00OS?o00030000oooooooo04Goool0017oool306Ko@c?o000306Ko<ol0<ol007hco`00
0`000?ooooooo`15oooo000Aoooo0c?o00H0I_lm<ol000<0I_lco`0co`00OS?o00030000oooooooo
04Goool0017oool9<ol01@1VocPco`000`1Voc?o03?o001n<ol000<0003oooooool0AOooo`004Ooo
o`hco`0506Ko<c?o000306Ko<ol0<ol007hco`000`000?ooooooo`15oooo000Aoooo4c?o00D0I_l^
<ol000<0I_lco`0co`00OS?o00030000oooooooo04Goool0017ooolH<ol01P1VobPco`000`1Voc?o
03?o001n<ol000<0003oooooool0AOooo`004Oooo`80000L<ol01@1Vob<co`000`1Voc?o03?o001n
<ol00P0004Koool001?oool200007c?o00D0I_lN<ol000<0I_lco`0co`00OS?o00030000oooooooo
04Goool001Goool200008S?o00@0I_lJ<ol000<0I_lco`0co`00OS?o00030000oooooooo04Goool0
01Ooool2000093?o00<0I_lG<ol000<0I_lco`0co`00OS?o00030000oooooooo04Goool001Woool2
00009C?o00@0I_lC<ol000<0I_lco`0co`00OS?o00030000oooooooo04Goool001_oool200009c?o
00<0I_l@<ol000<0I_lco`0co`00OS?o00030000oooooooo04Goool001goool20000:3?o00<0I_l=
<ol000<0I_lco`0co`00OS?o00030000oooooooo04Goool001ooool00`0003?o03?o000X<ol0101V
o`Tco`000`1Voc?o03?o001n<ol000<0003oooooool0AOooo`008?ooo`030000<ol0<ol002/co`03
06Ko1S?o000306Ko<ol0<ol007hco`020000A_ooo`008Oooo`80000^<ol00P1Vo`@co`000`1Voc?o
03?o001n<ol000<0003oooooool0AOooo`008oooo`030000<ol0<ol002dco`0506KoP3?o00030000
oooooooo04Goool002Coool20000<3?o0080I_n0<ol000<0003oooooool0AOooo`009_ooo`030000
<ol0<ol002hco`000ol0VC?o03?o001n<ol000<0003oooooool0AOooo`009oooo`030000<ol0<ol0
02dco`000ol0VC?o03?o001n<ol000<0003oooooool0AOooo`00:?ooo`030000<ol0<ol002`co`00
0ol0VC?o03?o001U<ol00P0000@co`02000013?o00800003<ol0100000@co`000`000?ooooooo`15
oooo000Yoooo00<0000co`0co`00:c?o0003o`2I<ol0<ol006@co`00100003?o03?o000000Pco`00
100003?o03?o0000008co`000`0003?o03?o0005<ol000<0003oooooool0AOooo`00:_ooo`030000
<ol0<ol002Xco`000ol0VC?o03?o001T<ol000@0000co`0co`000008<ol000@0000co`0co`000003
<ol000<0000co`0co`0013?o00<00015oooo000[oooo0P0002Xco`000ol0VC?o03?o001T<ol000@0
000co`0co`000008<ol000@0000co`0co`000004<ol000<0000co`0co`000c?o00030000oooooooo
04Goool002goool00`0003?o03?o000W<ol000?o09Tco`0co`00I3?o00040000<ol0<ol0000023?o
00040000<ol0<ol000000S?o00040000<ol0<ol0000013?o00030000oooooooo04Goool002koool0
0`0003?o03?o000V<ol000?o09Tco`0co`00IC?o0080000:<ol00P0000@co`0200001C?o00030000
oooooooo04Goool002ooool00`0003?o03?o000U<ol000?o09Tco`0co`00OS?o00030000oooooooo
04Goool0033oool00`0003?o03?o000T<ol000?o09Tco`0co`00OS?o00030000oooooooo04Goool0
037oool00`0003?o03?o000S<ol000?o09Tco`0co`00OS?o00030000oooooooo04Goool003;oool0
0`0003?o03?o000R<ol000?o09Tco`0co`00OS?o00030000oooooooo04Goool003?oool00`0003?o
03?o000Q<ol000?o09Tco`0co`00OS?o00800016oooo000coooo00<0000co`0co`008C?o0003o`2I
<ol0<ol007hco`000`000?ooooooo`15oooo000doooo00<0000co`0co`0083?o0003o`2I<ol0<ol0
07hco`000`000?ooooooo`15oooo000eoooo00<0000co`0co`007c?o0003o`2I<ol0<ol007hco`00
0`000?ooooooo`15oooo000foooo00<0000co`0co`007S?o0003o`2I<ol0<ol007hco`000`000?oo
ooooo`15oooo000goooo00<0000co`0co`007C?o0003o`2I<ol0<ol007hco`000`000?ooooooo`15
oooo000hoooo00<0000co`0co`0073?o0003o`2I<ol0<ol007hco`000`000?ooooooo`15oooo000h
oooo00<0000co`0co`0073?o0003o`2I<ol0<ol007hco`000`000?ooooooo`15oooo000ioooo00<0
000co`0co`006c?o0003o`2I<ol0<ol007hco`020000A_ooo`00>_ooo`030000<ol0<ol001Xco`00
0ol0VC?o03?o001n<ol000<0003oooooool0AOooo`00>oooo`030000<ol0<ol001Tco`000ol0VC?o
03?o001n<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001Pco`000ol0VC?o03?o001n
<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001Pco`000ol0VC?o03?o001n<ol000<0
003oooooool0AOooo`00?Oooo`030000<ol0<ol001Lco`000ol0VC?o03?o001n<ol000<0003ooooo
ool0AOooo`00?Oooo`030000<ol0<ol001Lco`000ol0VC?o03?o001n<ol000<0003oooooool0AOoo
o`00?_ooo`030000<ol0<ol001Hco`000ol0VC?o03?o001n<ol000<0003oooooool0AOooo`00?_oo
o`030000<ol0<ol001Hco`000ol0VC?o03?o001n<ol000<0003oooooool0AOooo`00?oooo`030000
<ol0<ol001Dco`000ol0VC?o03?o001n<ol00P0004Koool003ooool00`0003?o03?o000E<ol000?o
09Tco`0co`00OS?o00030000oooooooo04Goool0043oool00`0003?o03?o000D<ol000?o09Tco`0c
o`00OS?o00030000oooooooo04Goool0047oool00`0003?o03?o000C<ol000?o09Tco`0co`00OS?o
00030000oooooooo04Goool0047oool00`0003?o03?o000C<ol000?o09Tco`0co`00OS?o00030000
oooooooo04Goool004;oool00`0003?o03?o000B<ol000?o09Tco`0co`00OS?o00030000oooooooo
04Goool004;oool00`0003?o03?o000B<ol000?o09Tco`0co`00IC?o00800004<ol00P0000@co`02
00001C?o00<00003<ol000<0003oooooool0AOooo`00@oooo`030000<ol0<ol0014co`000ol0VC?o
03?o001T<ol000@0000co`0co`000008<ol000@0000co`0co`000005<ol000<0000co`0co`000S?o
00030000oooooooo04Goool004?oool00`0003?o03?o000A<ol000?o09Tco`0co`00I3?o00040000
<ol0<ol0000023?o00040000<ol0<ol000000S?o00D00003<ol00`0004Goool004Coool00`0003?o
03?o000@<ol000?o09Tco`0co`00I3?o00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o
00040000<ol0<ol0000013?o00030000oooooooo04Goool004Coool00`0003?o03?o000@<ol000?o
09Tco`0co`00I3?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000<ol00000
00@co`000`000?ooooooo`15oooo0015oooo00<0000co`0co`003c?o0003o`2I<ol0<ol006Dco`02
00002S?o00800005<ol00P0000@co`000`000?ooooooo`15oooo0015oooo00<0000co`0co`003c?o
0003o`2I<ol0<ol007hco`000`000?ooooooo`15oooo0016oooo00<0000co`0co`003S?o0003o`2I
<ol0<ol007hco`000`000?ooooooo`15oooo0016oooo00<0000co`0co`003S?o0003o`2I<ol0<ol0
07hco`000`000?ooooooo`15oooo0017oooo00<0000co`0co`003C?o0003o`2I<ol0<ol007hco`00
0`000?ooooooo`15oooo0017oooo00<0000co`0co`003C?o0003o`2I<ol0<ol007hco`020000A_oo
o`00B?ooo`030000<ol0<ol000`co`000ol0VC?o03?o001n<ol000<0003oooooool0AOooo`00B?oo
o`030000<ol0<ol000`co`000ol0VC?o03?o001n<ol000<0003oooooool0AOooo`00BOooo`030000
<ol0<ol000/co`000ol0VC?o03?o001n<ol000<0003oooooool0AOooo`00BOooo`030000<ol0<ol0
00/co`000ol0VC?o03?o001n<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol000Xco`00
0ol0VC?o03?o001n<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol000Xco`000ol0VC?o
03?o001n<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000Tco`000ol0VC?o03?o001n
<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000Tco`000ol0VC?o03?o001n<ol00P00
04Koool004cooon<<ol0B?ooo`00C?oooh`co`18oooo001<ooooS3?o04Soool004gooon;<ol0B?oo
o`00COoooh/co`18oooo001>oooo:C?o00030000<ol0<ol002Tco`000`0003?o03?o000b<ol0B?oo
o`00C_ooobPco`000`0003?o03?o0008<ol000<0000co`0co`0083?o00030000<ol0<ol0034co`18
oooo001?oooo9c?o00030000<ol0<ol0008co`02000013?o00030000<ol0<ol000hco`02000013?o
00800004<ol00P0000@co`000`0003?o03?o000a<ol0B?ooo`00CoooobLco`001@0003?o03?o03?o
00000002<ol000<0000co`0co`000S?o00030000<ol0<ol000Dco`0400000c?o00040000<ol0<ol0
000023?o00040000<ol0<ol000000c?o00030000<ol0<ol0034co`18oooo001?oooo9S?o00030000
<ol0<ol0008co`000`0003?o03?o000D<ol000@0000co`0co`00000:<ol000<0000co`0co`000c?o
00030000<ol0<ol0030co`18oooo001@oooo9S?o00030000<ol0<ol000D0000C<ol000@0000co`0c
o`00000;<ol000D0000co`0co`0co`000000<c?o04Soool0053ooolV<ol000D0000co`0co`0co`00
00005S?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000<ol0<ol0034co`18
oooo001@oooo9c?o00030000<ol0<ol001Pco`0200002S?o00800003<ol000<0000co`0co`00<S?o
04Soool0057ooon7<ol0B?ooo`00DOooohLco`18oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.29) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.28302 .30902 L
.2881 .30902 L
.29088 .30902 L
.29224 .30902 L
.29349 .30902 L
s
.29349 .30902 m
.29349 .61803 L
s
0 .4 1 r
.02381 .34576 m
.06244 .35144 L
.10458 .35863 L
.14415 .36651 L
.18221 .37526 L
.22272 .38606 L
.26171 .39814 L
.27193 .40161 L
.28302 .40554 L
.2881 .40739 L
.29088 .40842 L
.29224 .40893 L
.29349 .4094 L
.29462 .30902 L
.2957 .30902 L
.29684 .30902 L
.29809 .30902 L
.29936 .30902 L
.30006 .30902 L
.30072 .30902 L
.302 .30902 L
.30316 .30902 L
.30432 .30902 L
.30556 .30902 L
.30674 .30902 L
.30781 .30902 L
.30907 .30902 L
.30978 .30902 L
.31043 .30902 L
.31164 .30902 L
.31292 .30902 L
.31414 .30902 L
.31545 .30902 L
.31669 .30902 L
.31782 .30902 L
.31908 .30902 L
.31979 .30902 L
.32046 .30902 L
.32116 .30902 L
.3218 .30902 L
.32254 .30902 L
.32323 .30902 L
.3243 .30902 L
.32547 .30902 L
.3267 .30902 L
.32785 .30902 L
.3289 .30902 L
.32989 .30902 L
.33105 .30902 L
.3321 .30902 L
Mistroke
.33325 .30902 L
.33448 .30902 L
.33564 .30902 L
.33669 .30902 L
.33794 .30902 L
.33863 .30902 L
.33928 .30902 L
.34046 .30902 L
.34171 .30902 L
.34293 .30902 L
.34362 .30902 L
.34426 .30902 L
.34544 .30902 L
.34668 .30902 L
.34779 .30902 L
.34883 .30902 L
.34998 .30902 L
.35121 .30902 L
.35186 .30902 L
.35255 .30902 L
.3538 .30902 L
.3551 .30902 L
.35584 .30902 L
.35652 .30902 L
.35772 .30902 L
.35902 .30902 L
.36025 .30902 L
.36138 .30902 L
.36244 .30902 L
.36358 .30902 L
.36465 .30902 L
.36563 .30902 L
.36678 .30902 L
.36803 .30902 L
.36921 .30902 L
.3703 .30902 L
.37142 .30902 L
.37247 .30902 L
.37363 .30902 L
.37487 .30902 L
.3761 .30902 L
.3774 .30902 L
.37851 .30902 L
.37973 .30902 L
.38105 .30902 L
.38226 .30902 L
.38289 .30902 L
.38359 .30902 L
.38432 .30902 L
.385 .30902 L
Mistroke
.38626 .30902 L
.38741 .30902 L
.38804 .30902 L
.38873 .30902 L
.38999 .30902 L
.39122 .30902 L
.39233 .30902 L
.39362 .30902 L
.39483 .30902 L
.39595 .30902 L
.39698 .30902 L
.39812 .30902 L
.39932 .30902 L
.4006 .30902 L
.40181 .30902 L
.40248 .30902 L
.40321 .30902 L
.40448 .30902 L
.4057 .30902 L
.40699 .30902 L
.40809 .30902 L
.4093 .30902 L
.40999 .30902 L
.41072 .30902 L
.41202 .30902 L
.41275 .30902 L
.41342 .30902 L
.41416 .30902 L
.41496 .30902 L
.41564 .30902 L
.41639 .30902 L
.41709 .30902 L
.41773 .30902 L
.41896 .30902 L
.42026 .30902 L
.42147 .30902 L
.42279 .30902 L
.42404 .30902 L
.4252 .30902 L
.42634 .30902 L
.42738 .30902 L
.42858 .30902 L
.4297 .30902 L
.43094 .30902 L
.43225 .30902 L
.43336 .30902 L
.43458 .30902 L
.4359 .30902 L
.43662 .30902 L
.43731 .30902 L
Mistroke
.43795 .30902 L
.43864 .30902 L
.43985 .30902 L
.44098 .30902 L
.44205 .30902 L
.44321 .30902 L
.44447 .30902 L
.44578 .30902 L
.44703 .30902 L
.44815 .30902 L
.44937 .30902 L
.45053 .30902 L
.45158 .30902 L
.45279 .30902 L
.45393 .30902 L
.45499 .30902 L
.45597 .30902 L
.45704 .30902 L
.45817 .30902 L
.45938 .30902 L
.46003 .30902 L
.46071 .30902 L
.46196 .30902 L
.46312 .30902 L
.46423 .30902 L
.46527 .30902 L
.46641 .30902 L
.46764 .30902 L
.46887 .30902 L
.46957 .30902 L
.47022 .30902 L
.47153 .30902 L
.47227 .30902 L
.47294 .30902 L
.47413 .30902 L
.47543 .30902 L
.47666 .30902 L
.47779 .30902 L
.47885 .30902 L
.47998 .30902 L
.48105 .30902 L
.48203 .30902 L
.48318 .30902 L
.48443 .30902 L
.4856 .30902 L
.4867 .30902 L
.48793 .30902 L
.48909 .30902 L
.49014 .30902 L
.49126 .30902 L
Mistroke
.4925 .30902 L
.4938 .30902 L
.49491 .30902 L
.49613 .30902 L
.49743 .30902 L
.49864 .30902 L
.49927 .30902 L
.49997 .30902 L
.5007 .30902 L
.50138 .30902 L
.50263 .30902 L
.50377 .30902 L
.50503 .30902 L
.50635 .30902 L
.50747 .30902 L
.50866 .30902 L
.50969 .30902 L
.5108 .30902 L
.51211 .30902 L
.51335 .30902 L
.51455 .30902 L
.51566 .30902 L
.51686 .30902 L
.518 .30902 L
.51931 .30902 L
.52051 .30902 L
.52183 .30902 L
.52257 .30902 L
.52326 .30902 L
.52451 .30902 L
.52514 .30902 L
.52583 .30902 L
.52651 .30902 L
.52722 .30902 L
.5285 .30902 L
.52921 .30902 L
.52987 .30902 L
.53065 .30902 L
.53138 .30902 L
.5327 .30902 L
.5339 .30902 L
.53519 .30902 L
.53591 .30902 L
.53659 .30902 L
.53782 .30902 L
.53894 .30902 L
.54015 .30902 L
.54147 .30902 L
.54261 .30902 L
.54383 .30902 L
Mistroke
.54499 .30902 L
.54603 .30902 L
.54668 .30902 L
.54737 .30902 L
.54861 .30902 L
.54929 .30902 L
.54993 .30902 L
.55063 .30902 L
.55139 .30902 L
.55204 .30902 L
.55274 .30902 L
.55403 .30902 L
.55518 .30902 L
.55643 .30902 L
.55773 .30902 L
.55895 .30902 L
.55966 .30902 L
.5604 .30902 L
.56104 .30902 L
.56173 .30902 L
.56247 .30902 L
.56314 .30902 L
.56386 .30902 L
.56465 .30902 L
.56537 .30902 L
.56604 .30902 L
.56736 .30902 L
.56848 .30902 L
.5697 .30902 L
.57039 .30902 L
.57102 .30902 L
.57227 .30902 L
.57354 .30902 L
.57426 .30902 L
.57493 .30902 L
.57616 .30902 L
.57746 .30902 L
.57871 .30902 L
.57942 .30902 L
.58008 .30902 L
.58078 .30902 L
.58141 .30902 L
.58215 .30902 L
.58284 .30902 L
.58407 .30902 L
.58521 .30902 L
.58646 .30902 L
.58709 .30902 L
.58778 .30902 L
.58852 .30902 L
Mistroke
.58923 .30902 L
.58986 .30902 L
.59055 .30902 L
.5913 .30902 L
.59209 .30902 L
.59285 .30902 L
.59353 .30902 L
.59418 .30902 L
.59486 .30902 L
.59561 .30902 L
.59631 .30902 L
.59755 .30902 L
.59826 .30902 L
.59892 .30902 L
.60017 .30902 L
.60083 .30902 L
.60154 .30902 L
.60282 .30902 L
.60401 .30902 L
.60866 .30902 L
.60982 .30902 L
.61105 .30902 L
.61169 .30902 L
.61239 .30902 L
.61362 .30902 L
.61433 .30902 L
.61509 .30902 L
.6158 .30902 L
.61645 .30902 L
.61711 .30902 L
.61782 .30902 L
.61911 .30902 L
.62031 .30902 L
.62141 .30902 L
.62271 .30902 L
.62395 .30902 L
.62522 .30902 L
.6264 .30902 L
.62769 .30902 L
.62842 .30902 L
.62907 .30902 L
.63026 .30902 L
.63135 .30902 L
.63255 .30902 L
.63381 .30902 L
.63491 .30902 L
.63594 .30902 L
.63707 .30902 L
.63827 .30902 L
.63895 .30902 L
Mistroke
.63966 .30902 L
.64095 .30902 L
.64162 .30902 L
.64233 .30902 L
.64312 .30902 L
.64386 .30902 L
.64521 .30902 L
.64594 .30902 L
.64662 .30902 L
.64783 .30902 L
.64915 .30902 L
.65044 .30902 L
.65166 .30902 L
.65276 .30902 L
.65395 .30902 L
.65524 .30902 L
.65589 .30902 L
.65661 .30902 L
.65788 .30902 L
.65906 .30902 L
.66032 .30902 L
.66102 .30902 L
.66165 .30902 L
.66289 .30902 L
.66405 .30902 L
.66476 .30902 L
.66543 .30902 L
.66612 .30902 L
.66688 .30902 L
.66814 .30902 L
.66884 .30902 L
.66948 .30902 L
.67066 .30902 L
.67193 .30902 L
.67313 .30902 L
.67424 .30902 L
.67542 .30902 L
.67673 .30902 L
.67739 .30902 L
.67809 .30902 L
.67937 .30902 L
.6806 .30902 L
.68174 .30902 L
.683 .30902 L
.6837 .30902 L
.68434 .30902 L
.6855 .30902 L
.68677 .30902 L
.68796 .30902 L
.68905 .30902 L
Mistroke
.69012 .30902 L
.69111 .30902 L
.6922 .30902 L
.69336 .30902 L
.69459 .30902 L
.69574 .30902 L
.69678 .30902 L
.69791 .30902 L
.69913 .30902 L
.70025 .30902 L
.70147 .30902 L
.70276 .30902 L
.70389 .30902 L
.70493 .30902 L
.70608 .30902 L
.70731 .30902 L
.70801 .30902 L
.70865 .30902 L
.70936 .30902 L
.71011 .30902 L
.71136 .30902 L
.71208 .30902 L
.71275 .30902 L
.71399 .30902 L
.71513 .30902 L
.71644 .30902 L
.71769 .30902 L
.71837 .30902 L
.71901 .30902 L
.72021 .30902 L
.7215 .30902 L
.72223 .30902 L
.7229 .30902 L
.72402 .30902 L
.72525 .30902 L
.72654 .30902 L
.72774 .30902 L
.72842 .30902 L
.72916 .30902 L
.72986 .30902 L
.7305 .30902 L
.73173 .30902 L
.73303 .30902 L
.7337 .30902 L
.73442 .30902 L
.73572 .30902 L
.73648 .30902 L
.73727 .30902 L
.73795 .30902 L
.73869 .30902 L
Mistroke
.73934 .30902 L
.74002 .30902 L
.74124 .30902 L
.74255 .30902 L
.7433 .30902 L
.74399 .30902 L
.74525 .30902 L
.7464 .30902 L
.74704 .30902 L
.74773 .30902 L
.74899 .30902 L
.75011 .30902 L
.75134 .30902 L
.75263 .30902 L
.75384 .30902 L
.75497 .30902 L
.75601 .30902 L
.75714 .30902 L
.75834 .30902 L
.75965 .30902 L
.76084 .30902 L
.7615 .30902 L
.76222 .30902 L
.76352 .30902 L
.76474 .30902 L
.76603 .30902 L
.76713 .30902 L
.76834 .30902 L
.76907 .30902 L
.76977 .30902 L
.77107 .30902 L
.7718 .30902 L
.77247 .30902 L
.77321 .30902 L
.774 .30902 L
.77469 .30902 L
.77543 .30902 L
.77614 .30902 L
.77678 .30902 L
.77801 .30902 L
.7793 .30902 L
.78052 .30902 L
.78121 .30902 L
.78185 .30902 L
.78302 .30902 L
.78426 .30902 L
.78537 .30902 L
.78641 .30902 L
.78756 .30902 L
.78879 .30902 L
Mistroke
.79895 .30902 L
.81729 .30902 L
.85844 .30902 L
.89808 .30902 L
.93621 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.29) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`00001Voc?o0007<ol000<0
000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001c?o00030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`0Coooo000Aoooo00<0000co`0c
o`00;c?o00030000<ol0<ol0018co`000`1Voc?o03?o000J<ol000<0000co`0co`00;S?o00030000
<ol0<ol002lco`000`000?ooooooo`0_oooo00<0003oooooool04oooo`004OooodLco`000`1Voc?o
03?o001m<ol000<0003oooooool0AOooo`004OooodLco`000`1Voc?o03?o001m<ol000<0003ooooo
ool0AOooo`004OooodLco`000`1Voc?o03?o001m<ol000<0003oooooool0AOooo`004OooodLco`00
0`1Voc?o03?o001m<ol000<0003oooooool0AOooo`004OooodLco`000`1Voc?o03?o001m<ol000<0
003oooooool0AOooo`004OooodLco`000`1Voc?o03?o001m<ol00P0004Koool0017ooom7<ol000<0
I_lco`0co`00OC?o00030000oooooooo04Goool0017oool606Ko@C?o000306Ko<ol0<ol007dco`00
0`000?ooooooo`15oooo000Aoooo1S?o00P0I_li<ol000<0I_lco`0co`00OC?o00030000oooooooo
04Goool0017oool><ol01@1Voc@co`000`1Voc?o03?o001m<ol000<0003oooooool0AOooo`004Ooo
oa<co`0506Ko;c?o000306Ko<ol0<ol007dco`000`000?ooooooo`15oooo000Aoooo63?o00H0I_lY
<ol000<0I_lco`0co`00OC?o00030000oooooooo04Goool0017ooolN<ol01@1Vob@co`000`1Voc?o
03?o001m<ol000<0003oooooool0AOooo`004Oooo`80000Q<ol01@1Voalco`000`1Voc?o03?o001m
<ol00P0004Koool001?oool2000093?o00@0I_lK<ol000<0I_lco`0co`00OC?o00030000oooooooo
04Goool001Goool200009S?o00<0I_lH<ol000<0I_lco`0co`00OC?o00030000oooooooo04Goool0
01Ooool200009c?o00@0I_lD<ol000<0I_lco`0co`00OC?o00030000oooooooo04Goool001Woool2
0000:C?o00<0I_lA<ol000<0I_lco`0co`00OC?o00030000oooooooo04Goool001_oool20000:S?o
00<0I_l><ol000<0I_lco`0co`00OC?o00030000oooooooo04Goool001goool20000:c?o00@0I_l:
<ol000<0I_lco`0co`00OC?o00030000oooooooo04Goool001ooool00`0003?o03?o000/<ol00`1V
o`Lco`000`1Voc?o03?o001m<ol000<0003oooooool0AOooo`008?ooo`030000<ol0<ol002hco`03
06Ko13?o000306Ko<ol0<ol007dco`020000A_ooo`008Oooo`80000a<ol00P1Vo`8co`000`1Voc?o
03?o001m<ol000<0003oooooool0AOooo`008oooo`030000<ol0<ol0030co`0306KoOc?o00030000
oooooooo04Goool002Coool20000<S?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo000V
oooo00<0000co`0co`00;c?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo000Woooo00<0
000co`0co`00;S?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo000Xoooo00<0000co`0c
o`00;C?o0003o`2I<ol0<ol006@co`02000013?o00800004<ol00P0000<co`04000013?o00030000
oooooooo04Goool002Woool00`0003?o03?o000/<ol000?o09Tco`0co`00Hc?o00040000<ol0<ol0
000023?o00040000<ol0<ol000000S?o00030000<ol0<ol000Dco`000`000?ooooooo`15oooo000Z
oooo00<0000co`0co`00:c?o0003o`2I<ol0<ol006<co`00100003?o03?o000000Pco`00100003?o
03?o000000<co`000`0003?o03?o0004<ol00`0004Goool002_oool20000:c?o0003o`2I<ol0<ol0
06<co`00100003?o03?o000000Pco`00100003?o03?o000000@co`000`0003?o03?o0003<ol000<0
003oooooool0AOooo`00;Oooo`030000<ol0<ol002Pco`000ol0VC?o03?o001S<ol000@0000co`0c
o`000008<ol000@0000co`0co`000002<ol000@0000co`0co`000004<ol000<0003oooooool0AOoo
o`00;_ooo`030000<ol0<ol002Lco`000ol0VC?o03?o001T<ol00P0000Xco`02000013?o00800005
<ol000<0003oooooool0AOooo`00;oooo`030000<ol0<ol002Hco`000ol0VC?o03?o001m<ol000<0
003oooooool0AOooo`00<?ooo`030000<ol0<ol002Dco`000ol0VC?o03?o001m<ol000<0003ooooo
ool0AOooo`00<Oooo`030000<ol0<ol002@co`000ol0VC?o03?o001m<ol000<0003oooooool0AOoo
o`00<_ooo`030000<ol0<ol002<co`000ol0VC?o03?o001m<ol000<0003oooooool0AOooo`00<ooo
o`030000<ol0<ol0028co`000ol0VC?o03?o001m<ol00P0004Koool003?oool00`0003?o03?o000R
<ol000?o09Tco`0co`00OC?o00030000oooooooo04Goool003Coool00`0003?o03?o000Q<ol000?o
09Tco`0co`00OC?o00030000oooooooo04Goool003Goool00`0003?o03?o000P<ol000?o09Tco`0c
o`00OC?o00030000oooooooo04Goool003Koool00`0003?o03?o000O<ol000?o09Tco`0co`00OC?o
00030000oooooooo04Goool003Ooool00`0003?o03?o000N<ol000?o09Tco`0co`00OC?o00030000
oooooooo04Goool003Soool00`0003?o03?o000M<ol000?o09Tco`0co`00OC?o00030000oooooooo
04Goool003Soool00`0003?o03?o000M<ol000?o09Tco`0co`00OC?o00030000oooooooo04Goool0
03Woool00`0003?o03?o000L<ol000?o09Tco`0co`00OC?o00800016oooo000joooo00<0000co`0c
o`006c?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo000koooo00<0000co`0co`006S?o
0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo000loooo00<0000co`0co`006C?o0003o`2I
<ol0<ol007dco`000`000?ooooooo`15oooo000loooo00<0000co`0co`006C?o0003o`2I<ol0<ol0
07dco`000`000?ooooooo`15oooo000moooo00<0000co`0co`0063?o0003o`2I<ol0<ol007dco`00
0`000?ooooooo`15oooo000moooo00<0000co`0co`0063?o0003o`2I<ol0<ol007dco`000`000?oo
ooooo`15oooo000noooo00<0000co`0co`005c?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15
oooo000noooo00<0000co`0co`005c?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo000o
oooo00<0000co`0co`005S?o0003o`2I<ol0<ol007dco`020000A_ooo`00?oooo`030000<ol0<ol0
01Hco`000ol0VC?o03?o001m<ol000<0003oooooool0AOooo`00@?ooo`030000<ol0<ol001Dco`00
0ol0VC?o03?o001m<ol000<0003oooooool0AOooo`00@Oooo`030000<ol0<ol001@co`000ol0VC?o
03?o001m<ol000<0003oooooool0AOooo`00@Oooo`030000<ol0<ol001@co`000ol0VC?o03?o001m
<ol000<0003oooooool0AOooo`00@_ooo`030000<ol0<ol001<co`000ol0VC?o03?o001m<ol000<0
003oooooool0AOooo`00@_ooo`030000<ol0<ol001<co`000ol0VC?o03?o001T<ol00P0000@co`02
000013?o00800005<ol00`0000<co`000`000?ooooooo`15oooo0013oooo00<0000co`0co`004S?o
0003o`2I<ol0<ol006<co`00100003?o03?o000000Pco`00100003?o03?o000000Dco`000`0003?o
03?o0002<ol000<0003oooooool0AOooo`00@oooo`030000<ol0<ol0018co`000ol0VC?o03?o001S
<ol000@0000co`0co`000008<ol000@0000co`0co`000002<ol01@0000<co`030000AOooo`00A?oo
o`030000<ol0<ol0014co`000ol0VC?o03?o001S<ol000@0000co`0co`000008<ol000@0000co`0c
o`000002<ol000@0000co`0co`000004<ol000<0003oooooool0AOooo`00A?ooo`030000<ol0<ol0
014co`000ol0VC?o03?o001S<ol000@0000co`0co`000008<ol000@0000co`0co`000003<ol000<0
000co`00000013?o00030000oooooooo04Goool004Goool00`0003?o03?o000@<ol000?o09Tco`0c
o`00I3?o0080000:<ol00P0000Dco`02000013?o00030000oooooooo04Goool004Goool00`0003?o
03?o000@<ol000?o09Tco`0co`00OC?o00030000oooooooo04Goool004Koool00`0003?o03?o000?
<ol000?o09Tco`0co`00OC?o00030000oooooooo04Goool004Koool00`0003?o03?o000?<ol000?o
09Tco`0co`00OC?o00030000oooooooo04Goool004Ooool00`0003?o03?o000><ol000?o09Tco`0c
o`00OC?o00030000oooooooo04Goool004Ooool00`0003?o03?o000><ol000?o09Tco`0co`00OC?o
00800016oooo0018oooo00<0000co`0co`003C?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15
oooo0018oooo00<0000co`0co`003C?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo0019
oooo00<0000co`0co`0033?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo0019oooo00<0
000co`0co`0033?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo001:oooo00<0000co`0c
o`002c?o0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo001:oooo00<0000co`0co`002c?o
0003o`2I<ol0<ol007dco`000`000?ooooooo`15oooo001;oooo00<0000co`0co`002S?o0003o`2I
<ol0<ol007dco`000`000?ooooooo`15oooo001;oooo00<0000co`0co`002S?o0003o`2I<ol0<ol0
07dco`020000A_ooo`00C?oooh`co`18oooo001<ooooS3?o04Soool004cooon<<ol0B?ooo`00COoo
oh/co`18oooo001=ooooRc?o04Soool004kooolV<ol000<0000co`0co`00;c?o00030000<ol0<ol0
02lco`18oooo001>oooo9C?o00030000<ol0<ol000Pco`000`0003?o03?o000V<ol000<0000co`0c
o`00;S?o04Soool004oooolT<ol000<0000co`0co`000S?o00800004<ol000<0000co`0co`003S?o
00800004<ol00P0000<co`0400000S?o00<00004<ol000<0000co`0co`00;S?o04Soool004oooolT
<ol000D0000co`0co`0co`0000000S?o00030000<ol0<ol0008co`000`0003?o03?o0005<ol01000
00<co`00100003?o03?o000000Pco`000`0003?o03?o0005<ol000<0000co`0co`000S?o00030000
<ol0<ol002hco`18oooo001?oooo8c?o00030000<ol0<ol0008co`000`0003?o03?o000D<ol000@0
000co`0co`000009<ol000<0000co`0co`000c?o00<00004<ol000<0000co`0co`00;C?o04Soool0
053ooolS<ol000<0000co`0co`001@0001<co`00100003?o03?o000000Xco`001@0003?o03?o03?o
00000002<ol000D0000co`0co`0co`000000<3?o04Soool0053ooolS<ol000D0000co`0co`0co`00
00005S?o00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o00040000<ol0<ol000000c?o
00030000<ol0<ol002hco`18oooo001@oooo93?o00030000<ol0<ol001Pco`0200002S?o00800004
<ol00`00008co`000`0003?o03?o000_<ol0B?ooo`00DOooohLco`18oooo001AooooQc?o04Soool0
0001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.28) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.28302 .30902 L
.2881 .30902 L
.29349 .30902 L
.2957 .30902 L
.29693 .30902 L
.29809 .30902 L
s
.29809 .30902 m
.29809 .61803 L
s
0 .4 1 r
.02381 .34443 m
.06244 .3499 L
.10458 .35683 L
.14415 .36442 L
.18221 .37286 L
.22272 .38327 L
.26171 .39491 L
.27193 .39825 L
.28302 .40203 L
.2881 .40382 L
.29349 .40575 L
.2957 .40656 L
.29693 .40701 L
.29809 .40743 L
.29874 .30902 L
.29945 .30902 L
.3007 .30902 L
.30198 .30902 L
.30316 .30902 L
.30444 .30902 L
.30509 .30902 L
.3058 .30902 L
.30706 .30902 L
.30823 .30902 L
.30894 .30902 L
.30962 .30902 L
.31088 .30902 L
.31159 .30902 L
.31224 .30902 L
.31296 .30902 L
.31372 .30902 L
.3149 .30902 L
.31616 .30902 L
.31736 .30902 L
.31845 .30902 L
.31967 .30902 L
.32036 .30902 L
.321 .30902 L
.32229 .30902 L
.32302 .30902 L
.32368 .30902 L
.32484 .30902 L
.32607 .30902 L
.32712 .30902 L
.32827 .30902 L
.32951 .30902 L
.33021 .30902 L
.33084 .30902 L
.33208 .30902 L
.33325 .30902 L
Mistroke
.33434 .30902 L
.33549 .30902 L
.33658 .30902 L
.33757 .30902 L
.33874 .30902 L
.34 .30902 L
.34119 .30902 L
.34228 .30902 L
.34355 .30902 L
.34475 .30902 L
.34583 .30902 L
.347 .30902 L
.34827 .30902 L
.34891 .30902 L
.34962 .30902 L
.35087 .30902 L
.35205 .30902 L
.35316 .30902 L
.35433 .30902 L
.35534 .30902 L
.35643 .30902 L
.35761 .30902 L
.35887 .30902 L
.36007 .30902 L
.36115 .30902 L
.36244 .30902 L
.36315 .30902 L
.36381 .30902 L
.36498 .30902 L
.36626 .30902 L
.36697 .30902 L
.36765 .30902 L
.36893 .30902 L
.36964 .30902 L
.3703 .30902 L
.37102 .30902 L
.37179 .30902 L
.37297 .30902 L
.37425 .30902 L
.37545 .30902 L
.37656 .30902 L
.37778 .30902 L
.37848 .30902 L
.37912 .30902 L
.38043 .30902 L
.38116 .30902 L
.38182 .30902 L
.38301 .30902 L
.38413 .30902 L
.38535 .30902 L
Mistroke
.38666 .30902 L
.38732 .30902 L
.38804 .30902 L
.38934 .30902 L
.39061 .30902 L
.39179 .30902 L
.39299 .30902 L
.39413 .30902 L
.39514 .30902 L
.39624 .30902 L
.39743 .30902 L
.3987 .30902 L
.39989 .30902 L
.40099 .30902 L
.40228 .30902 L
.4035 .30902 L
.40482 .30902 L
.40556 .30902 L
.40625 .30902 L
.40754 .30902 L
.40827 .30902 L
.40895 .30902 L
.40967 .30902 L
.41033 .30902 L
.41105 .30902 L
.41182 .30902 L
.41302 .30902 L
.41413 .30902 L
.41482 .30902 L
.41546 .30902 L
.41667 .30902 L
.41794 .30902 L
.41912 .30902 L
.42041 .30902 L
.42106 .30902 L
.42177 .30902 L
.42298 .30902 L
.42427 .30902 L
.42501 .30902 L
.42568 .30902 L
.42699 .30902 L
.42822 .30902 L
.42891 .30902 L
.42955 .30902 L
.43071 .30902 L
.43195 .30902 L
.43306 .30902 L
.43424 .30902 L
.43536 .30902 L
.43638 .30902 L
Mistroke
.43758 .30902 L
.43888 .30902 L
.4401 .30902 L
.44124 .30902 L
.44244 .30902 L
.44373 .30902 L
.44495 .30902 L
.44606 .30902 L
.44736 .30902 L
.4481 .30902 L
.44879 .30902 L
.45004 .30902 L
.45074 .30902 L
.45138 .30902 L
.45205 .30902 L
.45276 .30902 L
.45404 .30902 L
.45475 .30902 L
.45541 .30902 L
.45618 .30902 L
.45692 .30902 L
.45823 .30902 L
.45943 .30902 L
.46073 .30902 L
.46146 .30902 L
.46213 .30902 L
.46331 .30902 L
.46455 .30902 L
.46562 .30902 L
.46676 .30902 L
.468 .30902 L
.46915 .30902 L
.46985 .30902 L
.47051 .30902 L
.47175 .30902 L
.47285 .30902 L
.47401 .30902 L
.475 .30902 L
.47609 .30902 L
.47726 .30902 L
.47852 .30902 L
.4797 .30902 L
.48079 .30902 L
.48206 .30902 L
.48277 .30902 L
.48341 .30902 L
.48466 .30902 L
.48584 .30902 L
.48652 .30902 L
.48722 .30902 L
Mistroke
.48849 .30902 L
.4892 .30902 L
.48986 .30902 L
.49058 .30902 L
.49135 .30902 L
.49265 .30902 L
.49338 .30902 L
.49405 .30902 L
.49529 .30902 L
.49661 .30902 L
.49888 .30902 L
.50017 .30902 L
.50139 .30902 L
.50257 .30902 L
.50383 .30902 L
.50492 .30902 L
.5061 .30902 L
.50682 .30902 L
.50748 .30902 L
.50879 .30902 L
.50998 .30902 L
.51124 .30902 L
.51247 .30902 L
.51379 .30902 L
.51504 .30902 L
.51618 .30902 L
.51687 .30902 L
.51751 .30902 L
.51821 .30902 L
.51896 .30902 L
.52022 .30902 L
.52093 .30902 L
.5216 .30902 L
.52268 .30902 L
.52386 .30902 L
.5251 .30902 L
.52624 .30902 L
.52732 .30902 L
.5283 .30902 L
.52944 .30902 L
.53051 .30902 L
.53167 .30902 L
.5329 .30902 L
.53395 .30902 L
.53511 .30902 L
.53636 .30902 L
.53706 .30902 L
.5377 .30902 L
.53894 .30902 L
.54012 .30902 L
Mistroke
.54136 .30902 L
.54206 .30902 L
.54271 .30902 L
.54389 .30902 L
.54515 .30902 L
.54627 .30902 L
.54732 .30902 L
.54847 .30902 L
.54971 .30902 L
.55102 .30902 L
.55176 .30902 L
.55245 .30902 L
.55371 .30902 L
.55435 .30902 L
.55505 .30902 L
.55626 .30902 L
.55757 .30902 L
.5588 .30902 L
.55993 .30902 L
.561 .30902 L
.56214 .30902 L
.56322 .30902 L
.56421 .30902 L
.56536 .30902 L
.56661 .30902 L
.5678 .30902 L
.56889 .30902 L
.57001 .30902 L
.57107 .30902 L
.57222 .30902 L
.57347 .30902 L
.57477 .30902 L
.576 .30902 L
.57721 .30902 L
.57832 .30902 L
.57957 .30902 L
.58022 .30902 L
.58092 .30902 L
.58208 .30902 L
.58336 .30902 L
.5845 .30902 L
.58573 .30902 L
.58688 .30902 L
.58793 .30902 L
.58924 .30902 L
.59045 .30902 L
.59109 .30902 L
.59178 .30902 L
.59251 .30902 L
.59319 .30902 L
Mistroke
.59444 .30902 L
.59559 .30902 L
.59691 .30902 L
.59817 .30902 L
.59932 .30902 L
.60037 .30902 L
.60158 .30902 L
.60273 .30902 L
.60372 .30902 L
.60476 .30902 L
.60591 .30902 L
.60696 .30902 L
.6081 .30902 L
.60933 .30902 L
.61049 .30902 L
.61154 .30902 L
.61278 .30902 L
.61348 .30902 L
.61412 .30902 L
.61531 .30902 L
.61657 .30902 L
.6177 .30902 L
.61895 .30902 L
.62024 .30902 L
.62145 .30902 L
.62258 .30902 L
.62361 .30902 L
.62474 .30902 L
.62593 .30902 L
.62722 .30902 L
.62842 .30902 L
.62909 .30902 L
.62981 .30902 L
.63112 .30902 L
.63234 .30902 L
.63345 .30902 L
.63477 .30902 L
.63602 .30902 L
.63717 .30902 L
.63822 .30902 L
.63942 .30902 L
.64055 .30902 L
.64161 .30902 L
.64258 .30902 L
.64364 .30902 L
.64476 .30902 L
.6459 .30902 L
.64711 .30902 L
.64826 .30902 L
.64931 .30902 L
Mistroke
.65054 .30902 L
.65123 .30902 L
.65187 .30902 L
.65305 .30902 L
.65429 .30902 L
.65553 .30902 L
.65668 .30902 L
.65788 .30902 L
.65919 .30902 L
.66033 .30902 L
.66136 .30902 L
.66255 .30902 L
.66368 .30902 L
.66491 .30902 L
.6662 .30902 L
.66731 .30902 L
.66853 .30902 L
.66984 .30902 L
.67058 .30902 L
.67125 .30902 L
.67248 .30902 L
.67379 .30902 L
.67501 .30902 L
.67612 .30902 L
.67724 .30902 L
.67828 .30902 L
.67949 .30902 L
.6808 .30902 L
.68195 .30902 L
.68317 .30902 L
.68423 .30902 L
.68537 .30902 L
.68644 .30902 L
.68742 .30902 L
.68857 .30902 L
.68981 .30902 L
.69099 .30902 L
.69207 .30902 L
.69332 .30902 L
.6945 .30902 L
.69557 .30902 L
.69673 .30902 L
.69799 .30902 L
.69868 .30902 L
.69933 .30902 L
.70059 .30902 L
.70174 .30902 L
.70284 .30902 L
.704 .30902 L
.705 .30902 L
Mistroke
.70609 .30902 L
.70726 .30902 L
.70852 .30902 L
.70971 .30902 L
.71079 .30902 L
.71207 .30902 L
.71272 .30902 L
.71343 .30902 L
.71469 .30902 L
.71587 .30902 L
.71654 .30902 L
.71725 .30902 L
.71852 .30902 L
.71918 .30902 L
.71989 .30902 L
.72066 .30902 L
.72139 .30902 L
.73142 .30902 L
.73639 .30902 L
.7377 .30902 L
.73844 .30902 L
.73911 .30902 L
.74042 .30902 L
.74166 .30902 L
.74297 .30902 L
.74372 .30902 L
.74441 .30902 L
.74518 .30902 L
.74587 .30902 L
.74668 .30902 L
.74744 .30902 L
.74808 .30902 L
.74877 .30902 L
.75 .30902 L
.75131 .30902 L
.75206 .30902 L
.75276 .30902 L
.75402 .30902 L
.75468 .30902 L
.75538 .30902 L
.75667 .30902 L
.75785 .30902 L
.75899 .30902 L
.76006 .30902 L
.76123 .30902 L
.76249 .30902 L
.76376 .30902 L
.76448 .30902 L
.76514 .30902 L
.76585 .30902 L
Mistroke
.76649 .30902 L
.76723 .30902 L
.76793 .30902 L
.76918 .30902 L
.77032 .30902 L
.77158 .30902 L
.77222 .30902 L
.77291 .30902 L
.77421 .30902 L
.77542 .30902 L
.77674 .30902 L
.7774 .30902 L
.77814 .30902 L
.77937 .30902 L
.78006 .30902 L
.7807 .30902 L
.78187 .30902 L
.7831 .30902 L
.78421 .30902 L
.7854 .30902 L
.78652 .30902 L
.78754 .30902 L
.79239 .30902 L
.8133 .30902 L
.85324 .30902 L
.89167 .30902 L
.93256 .30902 L
.97192 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.28) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o001Vo`07<ol000<0
000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001c?o00030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`0Coooo000Aoooo00<0000co`0c
o`00;c?o00030000<ol0<ol001<co`000`1Voc?o03?o000I<ol000<0000co`0co`00;S?o00030000
<ol0<ol002lco`000`000?ooooooo`0_oooo00<0003oooooool04oooo`004OooodPco`000`1Voc?o
03?o001l<ol000<0003oooooool0AOooo`004OooodPco`000`1Voc?o03?o001l<ol000<0003ooooo
ool0AOooo`004OooodPco`000`1Voc?o03?o001l<ol000<0003oooooool0AOooo`004OooodPco`00
0`1Voc?o03?o001l<ol000<0003oooooool0AOooo`004OooodPco`000`1Voc?o03?o001l<ol000<0
003oooooool0AOooo`004OooodPco`000`1Voc?o03?o001l<ol00P0004Koool0017oool306KoAC?o
000306Ko<ol0<ol007`co`000`000?ooooooo`15oooo000Aoooo0c?o00H0I_lo<ol000<0I_lco`0c
o`00O3?o00030000oooooooo04Goool0017oool9<ol01@1VocXco`000`1Voc?o03?o001l<ol000<0
003oooooool0AOooo`004Oooo`hco`0506Ko=C?o000306Ko<ol0<ol007`co`000`000?ooooooo`15
oooo000Aoooo4c?o00D0I_l`<ol000<0I_lco`0co`00O3?o00030000oooooooo04Goool0017ooolH
<ol01P1VobXco`000`1Voc?o03?o001l<ol000<0003oooooool0AOooo`004Ooooahco`0506Ko9C?o
000306Ko<ol0<ol007`co`000`000?ooooooo`15oooo000Aoooo0P00024co`0506Ko83?o000306Ko
<ol0<ol007`co`020000A_ooo`004oooo`80000T<ol01@1Voa/co`000`1Voc?o03?o001l<ol000<0
003oooooool0AOooo`005Oooo`80000W<ol01@1VoaHco`000`1Voc?o03?o001l<ol000<0003ooooo
ool0AOooo`005oooo`80000Z<ol0101Voa8co`000`1Voc?o03?o001l<ol000<0003oooooool0AOoo
o`006Oooo`80000/<ol00P1Voa0co`000`1Voc?o03?o001l<ol000<0003oooooool0AOooo`006ooo
o`80000/<ol00`1Vo`dco`000`1Voc?o03?o001l<ol000<0003oooooool0AOooo`007Oooo`80000]
<ol00P1Vo`/co`000`1Voc?o03?o001l<ol000<0003oooooool0AOooo`007oooo`030000<ol0<ol0
02`co`0606Ko1C?o000306Ko<ol0<ol007`co`000`000?ooooooo`15oooo000Poooo00<0000co`0c
o`00<C?o0080I_l3<ol000<0I_lco`0co`00O3?o00800016oooo000Qoooo0P0003<co`0406KoOS?o
00030000oooooooo04Goool002?oool00`0003?o03?o000b<ol00P1Voghco`000`000?ooooooo`15
oooo000Toooo0P0003<co`000ol0VC?o03?o001l<ol000<0003oooooool0AOooo`009_ooo`030000
<ol0<ol0030co`000ol0VC?o03?o001l<ol000<0003oooooool0AOooo`009oooo`030000<ol0<ol0
02lco`000ol0VC?o03?o001l<ol000<0003oooooool0AOooo`00:?ooo`030000<ol0<ol002hco`00
0ol0VC?o03?o001S<ol00P0000@co`02000013?o00800003<ol0100000@co`000`000?ooooooo`15
oooo000Yoooo00<0000co`0co`00;C?o0003o`2I<ol0<ol0068co`00100003?o03?o000000Pco`00
100003?o03?o0000008co`000`0003?o03?o0005<ol000<0003oooooool0AOooo`00:_ooo`030000
<ol0<ol002`co`000ol0VC?o03?o001R<ol000@0000co`0co`000008<ol000@0000co`0co`000003
<ol000<0000co`0co`0013?o00<00015oooo000[oooo0P0002`co`000ol0VC?o03?o001R<ol000@0
000co`0co`000008<ol000@0000co`0co`000004<ol000<0000co`0co`000c?o00030000oooooooo
04Goool002goool00`0003?o03?o000Y<ol000?o09Tco`0co`00HS?o00040000<ol0<ol0000023?o
00040000<ol0<ol000000S?o00040000<ol0<ol0000013?o00030000oooooooo04Goool002koool0
0`0003?o03?o000X<ol000?o09Tco`0co`00Hc?o0080000:<ol00P0000@co`0200001C?o00030000
oooooooo04Goool002ooool00`0003?o03?o000W<ol000?o09Tco`0co`00O3?o00030000oooooooo
04Goool0033oool00`0003?o03?o000V<ol000?o09Tco`0co`00O3?o00030000oooooooo04Goool0
037oool00`0003?o03?o000U<ol000?o09Tco`0co`00O3?o00030000oooooooo04Goool003;oool0
0`0003?o03?o000T<ol000?o09Tco`0co`00O3?o00030000oooooooo04Goool003?oool00`0003?o
03?o000S<ol000?o09Tco`0co`00O3?o00800016oooo000coooo00<0000co`0co`008c?o0003o`2I
<ol0<ol007`co`000`000?ooooooo`15oooo000doooo00<0000co`0co`008S?o0003o`2I<ol0<ol0
07`co`000`000?ooooooo`15oooo000eoooo00<0000co`0co`008C?o0003o`2I<ol0<ol007`co`00
0`000?ooooooo`15oooo000foooo00<0000co`0co`0083?o0003o`2I<ol0<ol007`co`000`000?oo
ooooo`15oooo000goooo00<0000co`0co`007c?o0003o`2I<ol0<ol007`co`000`000?ooooooo`15
oooo000hoooo00<0000co`0co`007S?o0003o`2I<ol0<ol007`co`000`000?ooooooo`15oooo000h
oooo00<0000co`0co`007S?o0003o`2I<ol0<ol007`co`000`000?ooooooo`15oooo000ioooo00<0
000co`0co`007C?o0003o`2I<ol0<ol007`co`020000A_ooo`00>_ooo`030000<ol0<ol001`co`00
0ol0VC?o03?o001l<ol000<0003oooooool0AOooo`00>oooo`030000<ol0<ol001/co`000ol0VC?o
03?o001l<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001Xco`000ol0VC?o03?o001l
<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001Xco`000ol0VC?o03?o001l<ol000<0
003oooooool0AOooo`00?Oooo`030000<ol0<ol001Tco`000ol0VC?o03?o001l<ol000<0003ooooo
ool0AOooo`00?Oooo`030000<ol0<ol001Tco`000ol0VC?o03?o001l<ol000<0003oooooool0AOoo
o`00?_ooo`030000<ol0<ol001Pco`000ol0VC?o03?o001l<ol000<0003oooooool0AOooo`00?_oo
o`030000<ol0<ol001Pco`000ol0VC?o03?o001l<ol000<0003oooooool0AOooo`00?oooo`030000
<ol0<ol001Lco`000ol0VC?o03?o001l<ol00P0004Koool003ooool00`0003?o03?o000G<ol000?o
09Tco`0co`00O3?o00030000oooooooo04Goool0043oool00`0003?o03?o000F<ol000?o09Tco`0c
o`00O3?o00030000oooooooo04Goool0047oool00`0003?o03?o000E<ol000?o09Tco`0co`00O3?o
00030000oooooooo04Goool0047oool00`0003?o03?o000E<ol000?o09Tco`0co`00O3?o00030000
oooooooo04Goool004;oool00`0003?o03?o000D<ol000?o09Tco`0co`00O3?o00030000oooooooo
04Goool004;oool00`0003?o03?o000D<ol000?o09Tco`0co`00Hc?o00800004<ol00P0000@co`02
00001C?o00<00003<ol000<0003oooooool0AOooo`00@oooo`030000<ol0<ol001<co`000ol0VC?o
03?o001R<ol000@0000co`0co`000008<ol000@0000co`0co`000005<ol000<0000co`0co`000S?o
00030000oooooooo04Goool004?oool00`0003?o03?o000C<ol000?o09Tco`0co`00HS?o00040000
<ol0<ol0000023?o00040000<ol0<ol000000S?o00D00003<ol00`0004Goool004Coool00`0003?o
03?o000B<ol000?o09Tco`0co`00HS?o00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o
00040000<ol0<ol0000013?o00030000oooooooo04Goool004Coool00`0003?o03?o000B<ol000?o
09Tco`0co`00HS?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000<ol00000
00@co`000`000?ooooooo`15oooo0015oooo00<0000co`0co`004C?o0003o`2I<ol0<ol006<co`02
00002S?o00800005<ol00P0000@co`000`000?ooooooo`15oooo0015oooo00<0000co`0co`004C?o
0003o`2I<ol0<ol007`co`000`000?ooooooo`15oooo0016oooo00<0000co`0co`0043?o0003o`2I
<ol0<ol007`co`000`000?ooooooo`15oooo0016oooo00<0000co`0co`0043?o0003o`2I<ol0<ol0
07`co`000`000?ooooooo`15oooo0017oooo00<0000co`0co`003c?o0003o`2I<ol0<ol007`co`00
0`000?ooooooo`15oooo0017oooo00<0000co`0co`003c?o0003o`2I<ol0<ol007`co`020000A_oo
o`00B?ooo`030000<ol0<ol000hco`000ol0VC?o03?o001l<ol000<0003oooooool0AOooo`00B?oo
o`030000<ol0<ol000hco`000ol0VC?o03?o001l<ol000<0003oooooool0AOooo`00BOooo`030000
<ol0<ol000dco`000ol0VC?o03?o001l<ol000<0003oooooool0AOooo`00BOooo`030000<ol0<ol0
00dco`000ol0VC?o03?o001l<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol000`co`00
0ol0VC?o03?o001l<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol000`co`000ol0VC?o
03?o001l<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000/co`000ol0VC?o03?o001l
<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000/co`000ol0VC?o03?o001l<ol00P00
04Koool004cooon<<ol0B?ooo`00C?oooh`co`18oooo001<ooooS3?o04Soool004gooon;<ol0B?oo
o`00COoooh/co`18oooo001>oooo9S?o00030000<ol0<ol002lco`000`0003?o03?o000_<ol0B?oo
o`00C_ooobDco`000`0003?o03?o0008<ol000<0000co`0co`009S?o00030000<ol0<ol002hco`18
oooo001?oooo93?o00030000<ol0<ol0008co`02000013?o00030000<ol0<ol000hco`02000013?o
00800003<ol0100000<co`02000013?o00030000<ol0<ol002hco`18oooo001?oooo93?o00050000
<ol0<ol0<ol00000008co`000`0003?o03?o0002<ol000<0000co`0co`001C?o00@00003<ol000@0
000co`0co`000008<ol000<0000co`0co`000c?o00040000<ol0<ol000000c?o00030000<ol0<ol0
02hco`18oooo001?oooo8c?o00030000<ol0<ol0008co`000`0003?o03?o000D<ol000@0000co`0c
o`000009<ol000<0000co`0co`000S?o00040000<ol0<ol0000013?o00030000<ol0<ol002dco`18
oooo001@oooo8c?o00030000<ol0<ol000D0000C<ol000@0000co`0co`00000:<ol000<0000co`0c
o`000S?o00800004<ol000<0000co`0co`00;S?o04Soool0053ooolS<ol000D0000co`0co`0co`00
00005S?o00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o00040000<ol0<ol000000c?o
00030000<ol0<ol002hco`18oooo001@oooo93?o00030000<ol0<ol001Pco`0200002S?o00800004
<ol00P0000<co`000`0003?o03?o000_<ol0B?ooo`00DOooohLco`18oooo001AooooQc?o04Soool0
0001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.27) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.28302 .30902 L
.2881 .30902 L
.29349 .30902 L
.29809 .30902 L
.29935 .30902 L
.30004 .30902 L
.3007 .30902 L
s
.3007 .30902 m
.30071 .61803 L
s
0 .4 1 r
.02381 .3431 m
.06244 .34837 L
.10458 .35504 L
.14415 .36234 L
.18221 .37047 L
.22272 .38049 L
.26171 .39169 L
.27193 .39491 L
.28302 .39855 L
.2881 .40027 L
.29349 .40213 L
.29809 .40375 L
.29935 .4042 L
.30004 .40444 L
.3007 .40468 L
.30198 .30902 L
.30316 .30902 L
.30553 .30902 L
.30618 .30902 L
.30686 .30902 L
.30809 .30902 L
.30924 .30902 L
.31031 .30902 L
.31148 .30902 L
.31274 .30902 L
.31343 .30902 L
.31418 .30902 L
.31489 .30902 L
.31555 .30902 L
.31678 .30902 L
.3181 .30902 L
.31929 .30902 L
.32041 .30902 L
.32164 .30902 L
.32296 .30902 L
.32412 .30902 L
.32519 .30902 L
.32637 .30902 L
.32763 .30902 L
.32827 .30902 L
.32896 .30902 L
.33021 .30902 L
.33143 .30902 L
.33255 .30902 L
.3336 .30902 L
.33459 .30902 L
.33567 .30902 L
.33683 .30902 L
.33804 .30902 L
.33919 .30902 L
Mistroke
.34022 .30902 L
.34135 .30902 L
.342 .30902 L
.34268 .30902 L
.34391 .30902 L
.34523 .30902 L
.34598 .30902 L
.34668 .30902 L
.34795 .30902 L
.3491 .30902 L
.34974 .30902 L
.35043 .30902 L
.35169 .30902 L
.35282 .30902 L
.35406 .30902 L
.35526 .30902 L
.35656 .30902 L
.35777 .30902 L
.35888 .30902 L
.35994 .30902 L
.36106 .30902 L
.36238 .30902 L
.36358 .30902 L
.36486 .30902 L
.36559 .30902 L
.36626 .30902 L
.36747 .30902 L
.36875 .30902 L
.36986 .30902 L
.37109 .30902 L
.37182 .30902 L
.37252 .30902 L
.37382 .30902 L
.37455 .30902 L
.37523 .30902 L
.37597 .30902 L
.37675 .30902 L
.37805 .30902 L
.37927 .30902 L
.37996 .30902 L
.3806 .30902 L
.38131 .30902 L
.38205 .30902 L
.38328 .30902 L
.38397 .30902 L
.38461 .30902 L
.38579 .30902 L
.38704 .30902 L
.38815 .30902 L
.3892 .30902 L
Mistroke
.39034 .30902 L
.39157 .30902 L
.39288 .30902 L
.39362 .30902 L
.3943 .30902 L
.39556 .30902 L
.39626 .30902 L
.3969 .30902 L
.3981 .30902 L
.3994 .30902 L
.40063 .30902 L
.40176 .30902 L
.40283 .30902 L
.40397 .30902 L
.40504 .30902 L
.40602 .30902 L
.40717 .30902 L
.40842 .30902 L
.4096 .30902 L
.41069 .30902 L
.41181 .30902 L
.41287 .30902 L
.41402 .30902 L
.41527 .30902 L
.4165 .30902 L
.4178 .30902 L
.41891 .30902 L
.42012 .30902 L
.42136 .30902 L
.42266 .30902 L
.42334 .30902 L
.42409 .30902 L
.42541 .30902 L
.42666 .30902 L
.42736 .30902 L
.42799 .30902 L
.42923 .30902 L
.43041 .30902 L
.43153 .30902 L
.43273 .30902 L
.43386 .30902 L
.43488 .30902 L
.43608 .30902 L
.43739 .30902 L
.43853 .30902 L
.43975 .30902 L
.44106 .30902 L
.44228 .30902 L
.44303 .30902 L
.44374 .30902 L
Mistroke
.44437 .30902 L
.44506 .30902 L
.44574 .30902 L
.44648 .30902 L
.4472 .30902 L
.44798 .30902 L
.4487 .30902 L
.44937 .30902 L
.45067 .30902 L
.45195 .30902 L
.45313 .30902 L
.45443 .30902 L
.45515 .30902 L
.45581 .30902 L
.45702 .30902 L
.45833 .30902 L
.45957 .30902 L
.4607 .30902 L
.46196 .30902 L
.46316 .30902 L
.46423 .30902 L
.4654 .30902 L
.46667 .30902 L
.46731 .30902 L
.46801 .30902 L
.46926 .30902 L
.47043 .30902 L
.47154 .30902 L
.47271 .30902 L
.47371 .30902 L
.4748 .30902 L
.47598 .30902 L
.47725 .30902 L
.47844 .30902 L
.47952 .30902 L
.48081 .30902 L
.48146 .30902 L
.48217 .30902 L
.48343 .30902 L
.48462 .30902 L
.48533 .30902 L
.48601 .30902 L
.48728 .30902 L
.48799 .30902 L
.48865 .30902 L
.48937 .30902 L
.49014 .30902 L
.49145 .30902 L
.49218 .30902 L
.49286 .30902 L
Mistroke
.4941 .30902 L
.49541 .30902 L
.49659 .30902 L
.49768 .30902 L
.49889 .30902 L
.50018 .30902 L
.5014 .30902 L
.5021 .30902 L
.50275 .30902 L
.50406 .30902 L
.5048 .30902 L
.50548 .30902 L
.50662 .30902 L
.50786 .30902 L
.50916 .30902 L
.51037 .30902 L
.51107 .30902 L
.51182 .30902 L
.51253 .30902 L
.51318 .30902 L
.51442 .30902 L
.51573 .30902 L
.51641 .30902 L
.51714 .30902 L
.51845 .30902 L
.51926 .30902 L
.52002 .30902 L
.5207 .30902 L
.52145 .30902 L
.52269 .30902 L
.52385 .30902 L
.52513 .30902 L
.52585 .30902 L
.52651 .30902 L
.52776 .30902 L
.52847 .30902 L
.52914 .30902 L
.52983 .30902 L
.53047 .30902 L
.53121 .30902 L
.5319 .30902 L
.53431 .30902 L
.535 .30902 L
.53566 .30902 L
.5369 .30902 L
.53806 .30902 L
.53914 .30902 L
.54032 .30902 L
.54158 .30902 L
.54283 .30902 L
Mistroke
.544 .30902 L
.54505 .30902 L
.54619 .30902 L
.54748 .30902 L
.54813 .30902 L
.54884 .30902 L
.5501 .30902 L
.55128 .30902 L
.55192 .30902 L
.55261 .30902 L
.55387 .30902 L
.5551 .30902 L
.55624 .30902 L
.55747 .30902 L
.55816 .30902 L
.55882 .30902 L
.56014 .30902 L
.56088 .30902 L
.56156 .30902 L
.56263 .30902 L
.56378 .30902 L
.56487 .30902 L
.56585 .30902 L
.56701 .30902 L
.56826 .30902 L
.56945 .30902 L
.57054 .30902 L
.57167 .30902 L
.57273 .30902 L
.57389 .30902 L
.57514 .30902 L
.57644 .30902 L
.57768 .30902 L
.57879 .30902 L
.58 .30902 L
.58065 .30902 L
.58134 .30902 L
.58256 .30902 L
.58389 .30902 L
.58463 .30902 L
.58533 .30902 L
.5866 .30902 L
.58776 .30902 L
.58839 .30902 L
.58909 .30902 L
.59035 .30902 L
.59147 .30902 L
.59271 .30902 L
.59401 .30902 L
.59522 .30902 L
Mistroke
.59635 .30902 L
.59739 .30902 L
.59858 .30902 L
.59972 .30902 L
.60104 .30902 L
.60223 .30902 L
.6029 .30902 L
.60362 .30902 L
.60492 .30902 L
.60614 .30902 L
.60743 .30902 L
.60854 .30902 L
.60975 .30902 L
.61042 .30902 L
.61115 .30902 L
.61184 .30902 L
.61248 .30902 L
.61323 .30902 L
.61402 .30902 L
.61468 .30902 L
.61541 .30902 L
.61673 .30902 L
.61747 .30902 L
.61814 .30902 L
.61939 .30902 L
.62071 .30902 L
.62194 .30902 L
.62263 .30902 L
.62327 .30902 L
.62445 .30902 L
.6257 .30902 L
.62682 .30902 L
.62786 .30902 L
.62901 .30902 L
.63024 .30902 L
.63154 .30902 L
.63228 .30902 L
.63297 .30902 L
.63422 .30902 L
.63493 .30902 L
.63556 .30902 L
.63677 .30902 L
.63807 .30902 L
.63929 .30902 L
.64043 .30902 L
.6415 .30902 L
.64265 .30902 L
.64508 .30902 L
.6464 .30902 L
.64765 .30902 L
Mistroke
.64877 .30902 L
.64999 .30902 L
.65105 .30902 L
.65221 .30902 L
.65343 .30902 L
.65456 .30902 L
.65563 .30902 L
.6566 .30902 L
.65765 .30902 L
.65879 .30902 L
.66007 .30902 L
.66128 .30902 L
.66245 .30902 L
.66354 .30902 L
.66471 .30902 L
.666 .30902 L
.66665 .30902 L
.66735 .30902 L
.66861 .30902 L
.66978 .30902 L
.67105 .30902 L
.67226 .30902 L
.67338 .30902 L
.67449 .30902 L
.67549 .30902 L
.67665 .30902 L
.67773 .30902 L
.67894 .30902 L
.68026 .30902 L
.68093 .30902 L
.68164 .30902 L
.68292 .30902 L
.68421 .30902 L
.68542 .30902 L
.68651 .30902 L
.68769 .30902 L
.68898 .30902 L
.68972 .30902 L
.6904 .30902 L
.69113 .30902 L
.69179 .30902 L
.69255 .30902 L
.69328 .30902 L
.69456 .30902 L
.69575 .30902 L
.69705 .30902 L
.69778 .30902 L
.69844 .30902 L
.69964 .30902 L
.70076 .30902 L
Mistroke
.70199 .30902 L
.70331 .30902 L
.70398 .30902 L
.7047 .30902 L
.70601 .30902 L
.70717 .30902 L
.70846 .30902 L
.70966 .30902 L
.71079 .30902 L
.71197 .30902 L
.71325 .30902 L
.71438 .30902 L
.71556 .30902 L
.71658 .30902 L
.71768 .30902 L
.71836 .30902 L
.71909 .30902 L
.71978 .30902 L
.72042 .30902 L
.72162 .30902 L
.7229 .30902 L
.72356 .30902 L
.72427 .30902 L
.72555 .30902 L
.72633 .30902 L
.72708 .30902 L
.72781 .30902 L
.72847 .30902 L
.72968 .30902 L
.73096 .30902 L
.73215 .30902 L
.73327 .30902 L
.73458 .30902 L
.73579 .30902 L
.73711 .30902 L
.73777 .30902 L
.7385 .30902 L
.73981 .30902 L
.74102 .30902 L
.74165 .30902 L
.74235 .30902 L
.74308 .30902 L
.74376 .30902 L
.74501 .30902 L
.74615 .30902 L
.74741 .30902 L
.74873 .30902 L
.75805 .30902 L
.76289 .30902 L
.76554 .30902 L
Mistroke
.76805 .30902 L
.76947 .30902 L
.77028 .30902 L
.77102 .30902 L
.77233 .30902 L
.77299 .30902 L
.77371 .30902 L
.77502 .30902 L
.77576 .30902 L
.77643 .30902 L
.77774 .30902 L
.77897 .30902 L
.78011 .30902 L
.78133 .30902 L
.78249 .30902 L
.78355 .30902 L
.78473 .30902 L
.78602 .30902 L
.78666 .30902 L
.78736 .30902 L
.78861 .30902 L
.79886 .30902 L
.81727 .30902 L
.85873 .30902 L
.89867 .30902 L
.9371 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.27) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`00100003?o03?o001Vo`Hco`00
0`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007
<ol000<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo01?oool0017oool00`0003?o
03?o000_<ol000<0000co`0co`0053?o000306Ko<ol0<ol001Pco`000`0003?o03?o000^<ol000<0
000co`0co`00;c?o00030000oooooooo02ooool00`000?ooooooo`0Coooo000AooooBC?o000306Ko
<ol0<ol007/co`000`000?ooooooo`15oooo000AooooBC?o000306Ko<ol0<ol007/co`000`000?oo
ooooo`15oooo000AooooBC?o000306Ko<ol0<ol007/co`000`000?ooooooo`15oooo000AooooBC?o
000306Ko<ol0<ol007/co`000`000?ooooooo`15oooo000AooooBC?o000306Ko<ol0<ol007/co`00
0`000?ooooooo`15oooo000AooooBC?o000306Ko<ol0<ol007/co`020000A_ooo`004Oooo`H0I_m3
<ol000<0I_lco`0co`00Nc?o00030000oooooooo04Goool0017oool6<ol0201Voc/co`000`1Voc?o
03?o001k<ol000<0003oooooool0AOooo`004Oooo`hco`0506Ko=S?o000306Ko<ol0<ol007/co`00
0`000?ooooooo`15oooo000Aoooo4c?o00D0I_la<ol000<0I_lco`0co`00Nc?o00030000oooooooo
04Goool0017ooolH<ol01P1Vob/co`000`1Voc?o03?o001k<ol000<0003oooooool0AOooo`004Ooo
oahco`0506Ko9S?o000306Ko<ol0<ol007/co`000`000?ooooooo`15oooo000Aoooo8c?o00D0I_lQ
<ol000<0I_lco`0co`00Nc?o00030000oooooooo04Goool0017oool200009S?o00@0I_lM<ol000<0
I_lco`0co`00Nc?o00800016oooo000Coooo0P0002Pco`0306Ko6S?o000306Ko<ol0<ol007/co`00
0`000?ooooooo`15oooo000Eoooo0P0002Tco`0406Ko5S?o000306Ko<ol0<ol007/co`000`000?oo
ooooo`15oooo000Goooo0P0002/co`0306Ko4c?o000306Ko<ol0<ol007/co`000`000?ooooooo`15
oooo000Ioooo0P0002`co`0306Ko43?o000306Ko<ol0<ol007/co`000`000?ooooooo`15oooo000K
oooo0P0002dco`0406Ko33?o000306Ko<ol0<ol007/co`000`000?ooooooo`15oooo000Moooo0P00
02lco`0306Ko2C?o000306Ko<ol0<ol007/co`000`000?ooooooo`15oooo000Ooooo00<0000co`0c
o`00;c?o00D0I_l4<ol000<0I_lco`0co`00Nc?o00030000oooooooo04Goool0023oool00`0003?o
03?o000c<ol00`1Vo`03<ol006Ko<ol007`co`020000A_ooo`008Oooo`80000f<ol00P1Vogdco`00
0`000?ooooooo`15oooo000Soooo00<0000co`0co`00=3?o0003o`2I<ol0<ol007/co`000`000?oo
ooooo`15oooo000Toooo0P0003@co`000ol0VC?o03?o001k<ol000<0003oooooool0AOooo`009_oo
o`030000<ol0<ol0034co`000ol0VC?o03?o001k<ol000<0003oooooool0AOooo`009oooo`030000
<ol0<ol0030co`000ol0VC?o03?o001k<ol000<0003oooooool0AOooo`00:?ooo`030000<ol0<ol0
02lco`000ol0VC?o03?o001R<ol00P0000@co`02000013?o00800003<ol0100000@co`000`000?oo
ooooo`15oooo000Yoooo00<0000co`0co`00;S?o0003o`2I<ol0<ol0064co`00100003?o03?o0000
00Pco`00100003?o03?o0000008co`000`0003?o03?o0005<ol000<0003oooooool0AOooo`00:_oo
o`030000<ol0<ol002dco`000ol0VC?o03?o001Q<ol000@0000co`0co`000008<ol000@0000co`0c
o`000003<ol000<0000co`0co`0013?o00<00015oooo000[oooo0P0002dco`000ol0VC?o03?o001Q
<ol000@0000co`0co`000008<ol000@0000co`0co`000004<ol000<0000co`0co`000c?o00030000
oooooooo04Goool002goool00`0003?o03?o000Z<ol000?o09Tco`0co`00HC?o00040000<ol0<ol0
000023?o00040000<ol0<ol000000S?o00040000<ol0<ol0000013?o00030000oooooooo04Goool0
02koool00`0003?o03?o000Y<ol000?o09Tco`0co`00HS?o0080000:<ol00P0000@co`0200001C?o
00030000oooooooo04Goool002ooool00`0003?o03?o000X<ol000?o09Tco`0co`00Nc?o00030000
oooooooo04Goool0033oool00`0003?o03?o000W<ol000?o09Tco`0co`00Nc?o00030000oooooooo
04Goool0037oool00`0003?o03?o000V<ol000?o09Tco`0co`00Nc?o00030000oooooooo04Goool0
03;oool00`0003?o03?o000U<ol000?o09Tco`0co`00Nc?o00030000oooooooo04Goool003?oool0
0`0003?o03?o000T<ol000?o09Tco`0co`00Nc?o00800016oooo000coooo00<0000co`0co`0093?o
0003o`2I<ol0<ol007/co`000`000?ooooooo`15oooo000doooo00<0000co`0co`008c?o0003o`2I
<ol0<ol007/co`000`000?ooooooo`15oooo000eoooo00<0000co`0co`008S?o0003o`2I<ol0<ol0
07/co`000`000?ooooooo`15oooo000foooo00<0000co`0co`008C?o0003o`2I<ol0<ol007/co`00
0`000?ooooooo`15oooo000goooo00<0000co`0co`0083?o0003o`2I<ol0<ol007/co`000`000?oo
ooooo`15oooo000hoooo00<0000co`0co`007c?o0003o`2I<ol0<ol007/co`000`000?ooooooo`15
oooo000hoooo00<0000co`0co`007c?o0003o`2I<ol0<ol007/co`000`000?ooooooo`15oooo000i
oooo00<0000co`0co`007S?o0003o`2I<ol0<ol007/co`020000A_ooo`00>_ooo`030000<ol0<ol0
01dco`000ol0VC?o03?o001k<ol000<0003oooooool0AOooo`00>oooo`030000<ol0<ol001`co`00
0ol0VC?o03?o001k<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001/co`000ol0VC?o
03?o001k<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001/co`000ol0VC?o03?o001k
<ol000<0003oooooool0AOooo`00?Oooo`030000<ol0<ol001Xco`000ol0VC?o03?o001k<ol000<0
003oooooool0AOooo`00?Oooo`030000<ol0<ol001Xco`000ol0VC?o03?o001k<ol000<0003ooooo
ool0AOooo`00?_ooo`030000<ol0<ol001Tco`000ol0VC?o03?o001k<ol000<0003oooooool0AOoo
o`00?_ooo`030000<ol0<ol001Tco`000ol0VC?o03?o001k<ol000<0003oooooool0AOooo`00?ooo
o`030000<ol0<ol001Pco`000ol0VC?o03?o001k<ol00P0004Koool003ooool00`0003?o03?o000H
<ol000?o09Tco`0co`00Nc?o00030000oooooooo04Goool0043oool00`0003?o03?o000G<ol000?o
09Tco`0co`00Nc?o00030000oooooooo04Goool0047oool00`0003?o03?o000F<ol000?o09Tco`0c
o`00Nc?o00030000oooooooo04Goool0047oool00`0003?o03?o000F<ol000?o09Tco`0co`00Nc?o
00030000oooooooo04Goool004;oool00`0003?o03?o000E<ol000?o09Tco`0co`00Nc?o00030000
oooooooo04Goool004;oool00`0003?o03?o000E<ol000?o09Tco`0co`00HS?o00800004<ol00P00
00@co`0200001C?o00<00003<ol000<0003oooooool0AOooo`00@oooo`030000<ol0<ol001@co`00
0ol0VC?o03?o001Q<ol000@0000co`0co`000008<ol000@0000co`0co`000005<ol000<0000co`0c
o`000S?o00030000oooooooo04Goool004?oool00`0003?o03?o000D<ol000?o09Tco`0co`00HC?o
00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o00D00003<ol00`0004Goool004Coool0
0`0003?o03?o000C<ol000?o09Tco`0co`00HC?o00040000<ol0<ol0000023?o00040000<ol0<ol0
00000S?o00040000<ol0<ol0000013?o00030000oooooooo04Goool004Coool00`0003?o03?o000C
<ol000?o09Tco`0co`00HC?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000
<ol0000000@co`000`000?ooooooo`15oooo0015oooo00<0000co`0co`004S?o0003o`2I<ol0<ol0
068co`0200002S?o00800005<ol00P0000@co`000`000?ooooooo`15oooo0015oooo00<0000co`0c
o`004S?o0003o`2I<ol0<ol007/co`000`000?ooooooo`15oooo0016oooo00<0000co`0co`004C?o
0003o`2I<ol0<ol007/co`000`000?ooooooo`15oooo0016oooo00<0000co`0co`004C?o0003o`2I
<ol0<ol007/co`000`000?ooooooo`15oooo0017oooo00<0000co`0co`0043?o0003o`2I<ol0<ol0
07/co`000`000?ooooooo`15oooo0017oooo00<0000co`0co`0043?o0003o`2I<ol0<ol007/co`02
0000A_ooo`00B?ooo`030000<ol0<ol000lco`000ol0VC?o03?o001k<ol000<0003oooooool0AOoo
o`00B?ooo`030000<ol0<ol000lco`000ol0VC?o03?o001k<ol000<0003oooooool0AOooo`00BOoo
o`030000<ol0<ol000hco`000ol0VC?o03?o001k<ol000<0003oooooool0AOooo`00BOooo`030000
<ol0<ol000hco`000ol0VC?o03?o001k<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol0
00dco`000ol0VC?o03?o001k<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol000dco`00
0ol0VC?o03?o001k<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000`co`000ol0VC?o
03?o001k<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000`co`000ol0VC?o03?o001k
<ol00P0004Koool004cooon<<ol0B?ooo`00C?oooh`co`18oooo001<ooooS3?o04Soool004gooon;
<ol0B?ooo`00COoooh/co`18oooo001>oooo9S?o00030000<ol0<ol002lco`000`0003?o03?o000_
<ol0B?ooo`00C_ooobDco`000`0003?o03?o0008<ol000<0000co`0co`009S?o00030000<ol0<ol0
02hco`18oooo001?oooo93?o00030000<ol0<ol0008co`02000013?o00030000<ol0<ol000hco`02
000013?o00800003<ol0100000@co`000`0003?o03?o0002<ol000<0000co`0co`00;S?o04Soool0
04oooolT<ol000D0000co`0co`0co`0000000S?o00030000<ol0<ol0008co`000`0003?o03?o0005
<ol0100000<co`00100003?o03?o000000Pco`000`0003?o03?o0005<ol000<0000co`0co`000S?o
00030000<ol0<ol002hco`18oooo001?oooo8c?o00030000<ol0<ol0008co`000`0003?o03?o000D
<ol000@0000co`0co`000009<ol000<0000co`0co`0013?o00030000<ol0<ol000<co`000`0003?o
03?o000]<ol0B?ooo`00D?ooob<co`000`0003?o03?o000500004c?o00040000<ol0<ol000002S?o
00030000<ol0<ol000@co`001@0003?o03?o03?o0000000`<ol0B?ooo`00D?ooob<co`001@0003?o
03?o03?o0000000F<ol000@0000co`0co`000008<ol000@0000co`0co`000002<ol000@0000co`0c
o`000003<ol000<0000co`0co`00;S?o04Soool0053ooolT<ol000<0000co`0co`0063?o0080000:
<ol00P0000<co`0400000S?o00030000<ol0<ol002lco`18oooo001AooooQc?o04Soool0057ooon7
<ol0B?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.26) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.29779 .30902 L
.30059 .30902 L
.30316 .30902 L
.30432 .30902 L
.3056 .30902 L
s
.3056 .30902 m
.3056 .61803 L
s
0 .4 1 r
.02381 .34178 m
.06244 .34684 L
.10458 .35326 L
.14415 .36028 L
.18221 .36809 L
.22272 .37772 L
.26171 .38849 L
.28158 .39462 L
.29205 .39804 L
.29779 .39998 L
.30059 .40094 L
.30316 .40182 L
.30432 .40223 L
.3056 .40268 L
.3068 .30902 L
.30791 .30902 L
.30921 .30902 L
.31039 .30902 L
.31105 .30902 L
.31175 .30902 L
.31304 .30902 L
.31435 .30902 L
.31509 .30902 L
.31579 .30902 L
.31657 .30902 L
.31731 .30902 L
.31798 .30902 L
.3187 .30902 L
.32001 .30902 L
.32122 .30902 L
.32253 .30902 L
.32319 .30902 L
.32392 .30902 L
.32513 .30902 L
.3264 .30902 L
.32749 .30902 L
.32867 .30902 L
.32996 .30902 L
.33068 .30902 L
.33133 .30902 L
.3326 .30902 L
.3338 .30902 L
.33493 .30902 L
.33612 .30902 L
.33714 .30902 L
.33826 .30902 L
.33946 .30902 L
.34075 .30902 L
.34197 .30902 L
.34309 .30902 L
Mistroke
.34438 .30902 L
.34559 .30902 L
.34669 .30902 L
.34787 .30902 L
.34916 .30902 L
.34981 .30902 L
.35052 .30902 L
.35178 .30902 L
.35296 .30902 L
.35414 .30902 L
.35527 .30902 L
.35628 .30902 L
.35738 .30902 L
.35857 .30902 L
.35984 .30902 L
.36094 .30902 L
.36211 .30902 L
.36339 .30902 L
.36456 .30902 L
.36582 .30902 L
.36654 .30902 L
.3672 .30902 L
.36841 .30902 L
.36951 .30902 L
.37078 .30902 L
.37197 .30902 L
.37329 .30902 L
.37396 .30902 L
.37469 .30902 L
.37598 .30902 L
.37719 .30902 L
.37793 .30902 L
.37862 .30902 L
.37992 .30902 L
.3806 .30902 L
.38132 .30902 L
.38211 .30902 L
.38285 .30902 L
.38398 .30902 L
.38522 .30902 L
.38652 .30902 L
.38772 .30902 L
.38886 .30902 L
.38989 .30902 L
.39108 .30902 L
.3922 .30902 L
.39342 .30902 L
.39472 .30902 L
.39582 .30902 L
.39704 .30902 L
Mistroke
.39835 .30902 L
.39908 .30902 L
.39975 .30902 L
.40106 .30902 L
.40229 .30902 L
.40344 .30902 L
.40449 .30902 L
.40569 .30902 L
.40683 .30902 L
.40788 .30902 L
.40885 .30902 L
.40991 .30902 L
.41103 .30902 L
.41323 .30902 L
.41446 .30902 L
.41558 .30902 L
.41621 .30902 L
.4169 .30902 L
.41816 .30902 L
.41941 .30902 L
.42056 .30902 L
.42174 .30902 L
.42298 .30902 L
.42404 .30902 L
.4252 .30902 L
.42646 .30902 L
.42716 .30902 L
.42779 .30902 L
.42905 .30902 L
.4302 .30902 L
.43129 .30902 L
.43243 .30902 L
.43359 .30902 L
.43485 .30902 L
.43595 .30902 L
.43712 .30902 L
.43823 .30902 L
.43924 .30902 L
.44052 .30902 L
.44123 .30902 L
.44187 .30902 L
.44314 .30902 L
.4443 .30902 L
.44497 .30902 L
.44567 .30902 L
.44637 .30902 L
.44715 .30902 L
.44781 .30902 L
.44853 .30902 L
.44982 .30902 L
Mistroke
.45103 .30902 L
.45233 .30902 L
.45356 .30902 L
.45469 .30902 L
.45595 .30902 L
.45714 .30902 L
.45844 .30902 L
.45917 .30902 L
.45985 .30902 L
.46054 .30902 L
.4612 .30902 L
.46242 .30902 L
.46373 .30902 L
.46448 .30902 L
.46516 .30902 L
.46629 .30902 L
.46754 .30902 L
.46884 .30902 L
.47006 .30902 L
.47075 .30902 L
.4715 .30902 L
.47216 .30902 L
.47286 .30902 L
.47349 .30902 L
.47418 .30902 L
.47541 .30902 L
.47615 .30902 L
.47683 .30902 L
.47757 .30902 L
.47837 .30902 L
.47907 .30902 L
.47972 .30902 L
.48041 .30902 L
.48115 .30902 L
.4818 .30902 L
.4825 .30902 L
.48375 .30902 L
.48444 .30902 L
.48509 .30902 L
.48581 .30902 L
.48657 .30902 L
.48723 .30902 L
.48794 .30902 L
.48925 .30902 L
.49052 .30902 L
.4917 .30902 L
.49295 .30902 L
.49413 .30902 L
.49519 .30902 L
.49634 .30902 L
Mistroke
.49759 .30902 L
.49822 .30902 L
.49892 .30902 L
.50014 .30902 L
.50128 .30902 L
.50255 .30902 L
.50319 .30902 L
.50389 .30902 L
.50514 .30902 L
.5063 .30902 L
.51176 .30902 L
.51693 .30902 L
.51919 .30902 L
.52047 .30902 L
.52167 .30902 L
.52277 .30902 L
.52377 .30902 L
.52493 .30902 L
.52602 .30902 L
.52717 .30902 L
.52822 .30902 L
.52938 .30902 L
.53061 .30902 L
.53175 .30902 L
.53298 .30902 L
.53413 .30902 L
.53519 .30902 L
.53643 .30902 L
.53713 .30902 L
.53778 .30902 L
.54023 .30902 L
.54497 .30902 L
.54612 .30902 L
.54735 .30902 L
.54806 .30902 L
.5487 .30902 L
.54996 .30902 L
.55066 .30902 L
.55131 .30902 L
.55202 .30902 L
.55277 .30902 L
.55403 .30902 L
.55475 .30902 L
.55543 .30902 L
.55669 .30902 L
.55785 .30902 L
.55849 .30902 L
.55918 .30902 L
.56045 .30902 L
.56174 .30902 L
Mistroke
.56295 .30902 L
.56404 .30902 L
.56522 .30902 L
.56651 .30902 L
.56716 .30902 L
.56787 .30902 L
.56913 .30902 L
.57031 .30902 L
.57149 .30902 L
.57262 .30902 L
.57362 .30902 L
.57472 .30902 L
.57591 .30902 L
.57718 .30902 L
.57826 .30902 L
.57945 .30902 L
.58059 .30902 L
.58183 .30902 L
.58313 .30902 L
.58434 .30902 L
.58547 .30902 L
.5865 .30902 L
.58769 .30902 L
.58881 .30902 L
.59004 .30902 L
.59133 .30902 L
.59244 .30902 L
.59366 .30902 L
.59496 .30902 L
.5957 .30902 L
.59637 .30902 L
.59767 .30902 L
.5989 .30902 L
.60006 .30902 L
.6011 .30902 L
.6023 .30902 L
.60344 .30902 L
.60449 .30902 L
.60546 .30902 L
.60652 .30902 L
.60764 .30902 L
.60877 .30902 L
.60999 .30902 L
.61104 .30902 L
.61218 .30902 L
.61288 .30902 L
.61352 .30902 L
.61479 .30902 L
.61594 .30902 L
.61716 .30902 L
Mistroke
.61836 .30902 L
.61967 .30902 L
.62091 .30902 L
.62207 .30902 L
.62321 .30902 L
.62424 .30902 L
.62543 .30902 L
.62656 .30902 L
.62779 .30902 L
.62909 .30902 L
.6302 .30902 L
.63142 .30902 L
.63209 .30902 L
.63283 .30902 L
.63352 .30902 L
.63417 .30902 L
.63538 .30902 L
.63668 .30902 L
.63779 .30902 L
.63884 .30902 L
.64 .30902 L
.64124 .30902 L
.64248 .30902 L
.64379 .30902 L
.64491 .30902 L
.64613 .30902 L
.64729 .30902 L
.64835 .30902 L
.64956 .30902 L
.65071 .30902 L
.65177 .30902 L
.65275 .30902 L
.65383 .30902 L
.65497 .30902 L
.65618 .30902 L
.6575 .30902 L
.65874 .30902 L
.65989 .30902 L
.66104 .30902 L
.66207 .30902 L
.66327 .30902 L
.66439 .30902 L
.66563 .30902 L
.66693 .30902 L
.66804 .30902 L
.66926 .30902 L
.67058 .30902 L
.67131 .30902 L
.67199 .30902 L
.67329 .30902 L
Mistroke
.67453 .30902 L
.67558 .30902 L
.67674 .30902 L
.67787 .30902 L
.67908 .30902 L
.68022 .30902 L
.68126 .30902 L
.68225 .30902 L
.6833 .30902 L
.68444 .30902 L
.68566 .30902 L
.68681 .30902 L
.68785 .30902 L
.68908 .30902 L
.68978 .30902 L
.69042 .30902 L
.69159 .30902 L
.69283 .30902 L
.69405 .30902 L
.69537 .30902 L
.69662 .30902 L
.69777 .30902 L
.69892 .30902 L
.69996 .30902 L
.70116 .30902 L
.70228 .30902 L
.70352 .30902 L
.70483 .30902 L
.70594 .30902 L
.70716 .30902 L
.70848 .30902 L
.70922 .30902 L
.70989 .30902 L
.71119 .30902 L
.71243 .30902 L
.71348 .30902 L
.71464 .30902 L
.71578 .30902 L
.717 .30902 L
.71813 .30902 L
.71917 .30902 L
.72022 .30902 L
.72121 .30902 L
.72236 .30902 L
.72358 .30902 L
.72473 .30902 L
.72577 .30902 L
.727 .30902 L
.7277 .30902 L
.72833 .30902 L
Mistroke
.72951 .30902 L
.73075 .30902 L
.73197 .30902 L
.73266 .30902 L
.73329 .30902 L
.73446 .30902 L
.7357 .30902 L
.73681 .30902 L
.73785 .30902 L
.73899 .30902 L
.74022 .30902 L
.74146 .30902 L
.74216 .30902 L
.7428 .30902 L
.74349 .30902 L
.74421 .30902 L
.74552 .30902 L
.74672 .30902 L
.74802 .30902 L
.74925 .30902 L
.75038 .30902 L
.75144 .30902 L
.75257 .30902 L
.75364 .30902 L
.75462 .30902 L
.75577 .30902 L
.75701 .30902 L
.75819 .30902 L
.75929 .30902 L
.76052 .30902 L
.76168 .30902 L
.76273 .30902 L
.76385 .30902 L
.76509 .30902 L
.76639 .30902 L
.7675 .30902 L
.76871 .30902 L
.77002 .30902 L
.77123 .30902 L
.77187 .30902 L
.77256 .30902 L
.77329 .30902 L
.77397 .30902 L
.77522 .30902 L
.77637 .30902 L
.77762 .30902 L
.77894 .30902 L
.78006 .30902 L
.78125 .30902 L
.78238 .30902 L
Mistroke
.7834 .30902 L
.7846 .30902 L
.7859 .30902 L
.78713 .30902 L
.78826 .30902 L
.80919 .30902 L
.84864 .30902 L
.88657 .30902 L
.92696 .30902 L
.96583 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.26) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`001@0003?o03?o03?o001Vo`05
<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`00
0`0003?o03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`0Coooo000Aoooo00<0
000co`0co`00;c?o00030000<ol0<ol001Dco`000`1Voc?o03?o000G<ol000<0000co`0co`00;S?o
00030000<ol0<ol002lco`000`000?ooooooo`0_oooo00<0003oooooool04oooo`004OooodXco`00
0`1Voc?o03?o001j<ol000<0003oooooool0AOooo`004OooodXco`000`1Voc?o03?o001j<ol000<0
003oooooool0AOooo`004OooodXco`000`1Voc?o03?o001j<ol000<0003oooooool0AOooo`004Ooo
odXco`000`1Voc?o03?o001j<ol000<0003oooooool0AOooo`004OooodXco`000`1Voc?o03?o001j
<ol000<0003oooooool0AOooo`004OooodXco`000`1Voc?o03?o001j<ol00P0004Koool0017oool6
06KoA3?o000306Ko<ol0<ol007Xco`000`000?ooooooo`15oooo000Aoooo1S?o00P0I_ll<ol000<0
I_lco`0co`00NS?o00030000oooooooo04Goool0017oool><ol01@1VocLco`000`1Voc?o03?o001j
<ol000<0003oooooool0AOooo`004Ooooa<co`0806Ko;c?o000306Ko<ol0<ol007Xco`000`000?oo
ooooo`15oooo000Aoooo6c?o00L0I_lX<ol000<0I_lco`0co`00NS?o00030000oooooooo04Goool0
017ooolR<ol00`1VobDco`000`1Voc?o03?o001j<ol000<0003oooooool0AOooo`004OooobDco`04
06Ko8C?o000306Ko<ol0<ol007Xco`000`000?ooooooo`15oooo000Aoooo0P0002Lco`0406Ko7C?o
000306Ko<ol0<ol007Xco`020000A_ooo`004oooo`80000Y<ol01@1VoaPco`000`1Voc?o03?o001j
<ol000<0003oooooool0AOooo`005Oooo`80000/<ol0101Voa@co`000`1Voc?o03?o001j<ol000<0
003oooooool0AOooo`005oooo`80000^<ol00`1Voa4co`000`1Voc?o03?o001j<ol000<0003ooooo
ool0AOooo`006Oooo`80000_<ol0101Vo`dco`000`1Voc?o03?o001j<ol000<0003oooooool0AOoo
o`006oooo`80000a<ol0101Vo`Tco`000`1Voc?o03?o001j<ol000<0003oooooool0AOooo`007Ooo
o`80000c<ol0101Vo`Dco`000`1Voc?o03?o001j<ol000<0003oooooool0AOooo`007oooo`030000
<ol0<ol003@co`0206Ko0c?o000306Ko<ol0<ol007Xco`000`000?ooooooo`15oooo000Poooo00<0
000co`0co`00=C?o00@0I_ml<ol00P0004Koool0027oool20000>3?o000306Ko<ol0<ol007Xco`00
0`000?ooooooo`15oooo000Soooo00<0000co`0co`00=C?o0003o`2I<ol0<ol007Xco`000`000?oo
ooooo`15oooo000Toooo0P0003Dco`000ol0VC?o03?o001j<ol000<0003oooooool0AOooo`009_oo
o`030000<ol0<ol0038co`000ol0VC?o03?o001j<ol000<0003oooooool0AOooo`009oooo`030000
<ol0<ol0034co`000ol0VC?o03?o001j<ol000<0003oooooool0AOooo`00:?ooo`030000<ol0<ol0
030co`000ol0VC?o03?o001Q<ol00P0000@co`02000013?o00800003<ol0100000@co`000`000?oo
ooooo`15oooo000Yoooo00<0000co`0co`00;c?o0003o`2I<ol0<ol0060co`00100003?o03?o0000
00Pco`00100003?o03?o0000008co`000`0003?o03?o0005<ol000<0003oooooool0AOooo`00:_oo
o`030000<ol0<ol002hco`000ol0VC?o03?o001P<ol000@0000co`0co`000008<ol000@0000co`0c
o`000003<ol000<0000co`0co`0013?o00<00015oooo000[oooo0P0002hco`000ol0VC?o03?o001P
<ol000@0000co`0co`000008<ol000@0000co`0co`000004<ol000<0000co`0co`000c?o00030000
oooooooo04Goool002goool00`0003?o03?o000[<ol000?o09Tco`0co`00H3?o00040000<ol0<ol0
000023?o00040000<ol0<ol000000S?o00040000<ol0<ol0000013?o00030000oooooooo04Goool0
02koool00`0003?o03?o000Z<ol000?o09Tco`0co`00HC?o0080000:<ol00P0000@co`0200001C?o
00030000oooooooo04Goool002ooool00`0003?o03?o000Y<ol000?o09Tco`0co`00NS?o00030000
oooooooo04Goool0033oool00`0003?o03?o000X<ol000?o09Tco`0co`00NS?o00030000oooooooo
04Goool0037oool00`0003?o03?o000W<ol000?o09Tco`0co`00NS?o00030000oooooooo04Goool0
03;oool00`0003?o03?o000V<ol000?o09Tco`0co`00NS?o00030000oooooooo04Goool003?oool0
0`0003?o03?o000U<ol000?o09Tco`0co`00NS?o00800016oooo000coooo00<0000co`0co`009C?o
0003o`2I<ol0<ol007Xco`000`000?ooooooo`15oooo000doooo00<0000co`0co`0093?o0003o`2I
<ol0<ol007Xco`000`000?ooooooo`15oooo000eoooo00<0000co`0co`008c?o0003o`2I<ol0<ol0
07Xco`000`000?ooooooo`15oooo000foooo00<0000co`0co`008S?o0003o`2I<ol0<ol007Xco`00
0`000?ooooooo`15oooo000goooo00<0000co`0co`008C?o0003o`2I<ol0<ol007Xco`000`000?oo
ooooo`15oooo000hoooo00<0000co`0co`0083?o0003o`2I<ol0<ol007Xco`000`000?ooooooo`15
oooo000hoooo00<0000co`0co`0083?o0003o`2I<ol0<ol007Xco`000`000?ooooooo`15oooo000i
oooo00<0000co`0co`007c?o0003o`2I<ol0<ol007Xco`020000A_ooo`00>_ooo`030000<ol0<ol0
01hco`000ol0VC?o03?o001j<ol000<0003oooooool0AOooo`00>oooo`030000<ol0<ol001dco`00
0ol0VC?o03?o001j<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001`co`000ol0VC?o
03?o001j<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001`co`000ol0VC?o03?o001j
<ol000<0003oooooool0AOooo`00?Oooo`030000<ol0<ol001/co`000ol0VC?o03?o001j<ol000<0
003oooooool0AOooo`00?Oooo`030000<ol0<ol001/co`000ol0VC?o03?o001j<ol000<0003ooooo
ool0AOooo`00?_ooo`030000<ol0<ol001Xco`000ol0VC?o03?o001j<ol000<0003oooooool0AOoo
o`00?_ooo`030000<ol0<ol001Xco`000ol0VC?o03?o001j<ol000<0003oooooool0AOooo`00?ooo
o`030000<ol0<ol001Tco`000ol0VC?o03?o001j<ol00P0004Koool003ooool00`0003?o03?o000I
<ol000?o09Tco`0co`00NS?o00030000oooooooo04Goool0043oool00`0003?o03?o000H<ol000?o
09Tco`0co`00NS?o00030000oooooooo04Goool0047oool00`0003?o03?o000G<ol000?o09Tco`0c
o`00NS?o00030000oooooooo04Goool0047oool00`0003?o03?o000G<ol000?o09Tco`0co`00NS?o
00030000oooooooo04Goool004;oool00`0003?o03?o000F<ol000?o09Tco`0co`00NS?o00030000
oooooooo04Goool004;oool00`0003?o03?o000F<ol000?o09Tco`0co`00HC?o00800004<ol00P00
00@co`0200001C?o00<00003<ol000<0003oooooool0AOooo`00@oooo`030000<ol0<ol001Dco`00
0ol0VC?o03?o001P<ol000@0000co`0co`000008<ol000@0000co`0co`000005<ol000<0000co`0c
o`000S?o00030000oooooooo04Goool004?oool00`0003?o03?o000E<ol000?o09Tco`0co`00H3?o
00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o00D00003<ol00`0004Goool004Coool0
0`0003?o03?o000D<ol000?o09Tco`0co`00H3?o00040000<ol0<ol0000023?o00040000<ol0<ol0
00000S?o00040000<ol0<ol0000013?o00030000oooooooo04Goool004Coool00`0003?o03?o000D
<ol000?o09Tco`0co`00H3?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000
<ol0000000@co`000`000?ooooooo`15oooo0015oooo00<0000co`0co`004c?o0003o`2I<ol0<ol0
064co`0200002S?o00800005<ol00P0000@co`000`000?ooooooo`15oooo0015oooo00<0000co`0c
o`004c?o0003o`2I<ol0<ol007Xco`000`000?ooooooo`15oooo0016oooo00<0000co`0co`004S?o
0003o`2I<ol0<ol007Xco`000`000?ooooooo`15oooo0016oooo00<0000co`0co`004S?o0003o`2I
<ol0<ol007Xco`000`000?ooooooo`15oooo0017oooo00<0000co`0co`004C?o0003o`2I<ol0<ol0
07Xco`000`000?ooooooo`15oooo0017oooo00<0000co`0co`004C?o0003o`2I<ol0<ol007Xco`02
0000A_ooo`00B?ooo`030000<ol0<ol0010co`000ol0VC?o03?o001j<ol000<0003oooooool0AOoo
o`00B?ooo`030000<ol0<ol0010co`000ol0VC?o03?o001j<ol000<0003oooooool0AOooo`00BOoo
o`030000<ol0<ol000lco`000ol0VC?o03?o001j<ol000<0003oooooool0AOooo`00BOooo`030000
<ol0<ol000lco`000ol0VC?o03?o001j<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol0
00hco`000ol0VC?o03?o001j<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol000hco`00
0ol0VC?o03?o001j<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000dco`000ol0VC?o
03?o001j<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000dco`000ol0VC?o03?o001j
<ol00P0004Koool004cooon<<ol0B?ooo`00C?oooh`co`18oooo001<ooooS3?o04Soool004gooon;
<ol0B?ooo`00COoooh/co`18oooo001>oooo9S?o00030000<ol0<ol002lco`000`0003?o03?o000_
<ol0B?ooo`00C_ooobDco`000`0003?o03?o0008<ol000<0000co`0co`009S?o00030000<ol0<ol0
02hco`18oooo001?oooo93?o00030000<ol0<ol0008co`02000013?o00030000<ol0<ol000hco`02
000013?o00800003<ol01000008co`03000013?o00030000<ol0<ol002hco`18oooo001?oooo93?o
00050000<ol0<ol0<ol00000008co`000`0003?o03?o0002<ol000<0000co`0co`001C?o00@00003
<ol000@0000co`0co`000008<ol000<0000co`0co`000c?o00040000<ol0<ol000000c?o00030000
<ol0<ol002hco`18oooo001?oooo8c?o00030000<ol0<ol0008co`000`0003?o03?o000D<ol000@0
000co`0co`000009<ol000<0000co`0co`000S?o00040000<ol0<ol0000013?o00030000<ol0<ol0
02dco`18oooo001@oooo8c?o00030000<ol0<ol000D0000C<ol000@0000co`0co`00000:<ol000@0
000co`0co`0co`03000013?o00030000<ol0<ol002hco`18oooo001@oooo8c?o00050000<ol0<ol0
<ol0000001Hco`00100003?o03?o000000Pco`00100003?o03?o000000<co`000`0003?o03?o0003
<ol000<0000co`0co`00;S?o04Soool0053ooolT<ol000<0000co`0co`0063?o0080000:<ol00P00
00@co`0300000S?o00030000<ol0<ol002lco`18oooo001AooooQc?o04Soool0057ooon7<ol0B?oo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.29779 .30902 L
.30316 .30902 L
.3056 .30902 L
.30791 .30902 L
.30919 .30902 L
s
.30919 .30902 m
.3092 .61803 L
s
0 .4 1 r
.02381 .34047 m
.06244 .34533 L
.10458 .35149 L
.14415 .35822 L
.18221 .36572 L
.22272 .37496 L
.26171 .3853 L
.28158 .39119 L
.29205 .39448 L
.29779 .39633 L
.30316 .39811 L
.3056 .39892 L
.30791 .39971 L
.30919 .40014 L
.30992 .30902 L
.31059 .30902 L
.31177 .30902 L
.31304 .30902 L
.31377 .30902 L
.31445 .30902 L
.31519 .30902 L
.31597 .30902 L
.31729 .30902 L
.31804 .30902 L
.31874 .30902 L
.32005 .30902 L
.32124 .30902 L
.3219 .30902 L
.32261 .30902 L
.32392 .30902 L
.3251 .30902 L
.32621 .30902 L
.32743 .30902 L
.32874 .30902 L
.33005 .30902 L
.3307 .30902 L
.33142 .30902 L
.33269 .30902 L
.33387 .30902 L
.33507 .30902 L
.33621 .30902 L
.33722 .30902 L
.33833 .30902 L
.3396 .30902 L
.34081 .30902 L
.3419 .30902 L
.34309 .30902 L
.34431 .30902 L
.34544 .30902 L
.34677 .30902 L
Mistroke
.34797 .30902 L
.34912 .30902 L
.35019 .30902 L
.35132 .30902 L
.35255 .30902 L
.35321 .30902 L
.35392 .30902 L
.35519 .30902 L
.35589 .30902 L
.35652 .30902 L
.35727 .30902 L
.35798 .30902 L
.35922 .30902 L
.36037 .30902 L
.36162 .30902 L
.36226 .30902 L
.36296 .30902 L
.3636 .30902 L
.36429 .30902 L
.36502 .30902 L
.36569 .30902 L
.3669 .30902 L
.36819 .30902 L
.36892 .30902 L
.36971 .30902 L
.37046 .30902 L
.37114 .30902 L
.37244 .30902 L
.3731 .30902 L
.37382 .30902 L
.3745 .30902 L
.37515 .30902 L
.37636 .30902 L
.37767 .30902 L
.3784 .30902 L
.37909 .30902 L
.38022 .30902 L
.38147 .30902 L
.38278 .30902 L
.384 .30902 L
.38514 .30902 L
.38635 .30902 L
.38704 .30902 L
.38769 .30902 L
.38891 .30902 L
.39022 .30902 L
.39087 .30902 L
.3916 .30902 L
.39288 .30902 L
.39408 .30902 L
Mistroke
.3952 .30902 L
.39622 .30902 L
.3974 .30902 L
.39852 .30902 L
.39971 .30902 L
.40082 .30902 L
.40203 .30902 L
.40333 .30902 L
.40401 .30902 L
.40474 .30902 L
.40603 .30902 L
.40676 .30902 L
.40743 .30902 L
.40817 .30902 L
.40896 .30902 L
.40964 .30902 L
.41039 .30902 L
.41109 .30902 L
.41173 .30902 L
.41296 .30902 L
.41426 .30902 L
.41543 .30902 L
.41669 .30902 L
.41789 .30902 L
.41898 .30902 L
.42019 .30902 L
.42087 .30902 L
.42151 .30902 L
.4228 .30902 L
.42352 .30902 L
.42417 .30902 L
.42537 .30902 L
.42649 .30902 L
.42771 .30902 L
.42903 .30902 L
.42969 .30902 L
.43041 .30902 L
.43171 .30902 L
.43299 .30902 L
.43417 .30902 L
.43537 .30902 L
.43651 .30902 L
.43753 .30902 L
.43863 .30902 L
.43983 .30902 L
.4411 .30902 L
.44219 .30902 L
.44337 .30902 L
.44405 .30902 L
.44477 .30902 L
Mistroke
.44546 .30902 L
.4461 .30902 L
.4473 .30902 L
.44858 .30902 L
.44923 .30902 L
.44994 .30902 L
.45122 .30902 L
.45201 .30902 L
.45275 .30902 L
.45341 .30902 L
.45414 .30902 L
.45544 .30902 L
.45666 .30902 L
.45734 .30902 L
.45807 .30902 L
.45934 .30902 L
.46057 .30902 L
.46186 .30902 L
.46296 .30902 L
.46418 .30902 L
.46548 .30902 L
.46668 .30902 L
.46731 .30902 L
.46801 .30902 L
.46873 .30902 L
.46941 .30902 L
.47058 .30902 L
.4718 .30902 L
.47244 .30902 L
.47314 .30902 L
.47438 .30902 L
.4756 .30902 L
.4767 .30902 L
.47798 .30902 L
.47919 .30902 L
.48031 .30902 L
.48134 .30902 L
.48248 .30902 L
.48368 .30902 L
.48497 .30902 L
.48616 .30902 L
.48681 .30902 L
.48752 .30902 L
.48882 .30902 L
.49003 .30902 L
.49132 .30902 L
.49252 .30902 L
.49363 .30902 L
.49433 .30902 L
.49506 .30902 L
Mistroke
.49579 .30902 L
.49659 .30902 L
.49729 .30902 L
.49804 .30902 L
.49874 .30902 L
.49938 .30902 L
.50066 .30902 L
.50134 .30902 L
.50206 .30902 L
.50337 .30902 L
.50459 .30902 L
.50583 .30902 L
.50698 .30902 L
.50818 .30902 L
.50949 .30902 L
.51063 .30902 L
.51166 .30902 L
.51285 .30902 L
.51398 .30902 L
.51521 .30902 L
.5165 .30902 L
.51761 .30902 L
.51883 .30902 L
.52409 .30902 L
.52643 .30902 L
.52865 .30902 L
.52987 .30902 L
.53057 .30902 L
.53121 .30902 L
.53234 .30902 L
.53354 .30902 L
.53458 .30902 L
.53571 .30902 L
.53677 .30902 L
.53774 .30902 L
.53882 .30902 L
.54 .30902 L
.54123 .30902 L
.54238 .30902 L
.54365 .30902 L
.54435 .30902 L
.545 .30902 L
.54615 .30902 L
.54741 .30902 L
.54812 .30902 L
.54879 .30902 L
.55005 .30902 L
.55075 .30902 L
.5514 .30902 L
.55212 .30902 L
Mistroke
.55288 .30902 L
.55417 .30902 L
.55489 .30902 L
.55556 .30902 L
.55676 .30902 L
.55808 .30902 L
.55927 .30902 L
.56038 .30902 L
.56155 .30902 L
.5628 .30902 L
.56396 .30902 L
.56519 .30902 L
.56583 .30902 L
.56654 .30902 L
.56779 .30902 L
.56897 .30902 L
.57023 .30902 L
.57143 .30902 L
.57252 .30902 L
.57359 .30902 L
.57458 .30902 L
.57567 .30902 L
.57684 .30902 L
.57806 .30902 L
.57922 .30902 L
.58025 .30902 L
.58138 .30902 L
.58261 .30902 L
.58374 .30902 L
.58504 .30902 L
.58627 .30902 L
.58741 .30902 L
.58846 .30902 L
.58962 .30902 L
.59085 .30902 L
.59151 .30902 L
.5922 .30902 L
.59296 .30902 L
.59366 .30902 L
.59493 .30902 L
.59565 .30902 L
.59631 .30902 L
.59756 .30902 L
.5987 .30902 L
.60002 .30902 L
.60126 .30902 L
.60247 .30902 L
.60316 .30902 L
.60381 .30902 L
.60511 .30902 L
Mistroke
.60577 .30902 L
.6065 .30902 L
.6078 .30902 L
.60903 .30902 L
.61023 .30902 L
.61135 .30902 L
.61204 .30902 L
.61279 .30902 L
.6141 .30902 L
.61484 .30902 L
.61562 .30902 L
.61629 .30902 L
.61703 .30902 L
.61835 .30902 L
.61908 .30902 L
.61976 .30902 L
.62107 .30902 L
.62231 .30902 L
.62344 .30902 L
.62467 .30902 L
.62583 .30902 L
.62689 .30902 L
.62806 .30902 L
.62935 .30902 L
.63 .30902 L
.6307 .30902 L
.63195 .30902 L
.63259 .30902 L
.63327 .30902 L
.63402 .30902 L
.63471 .30902 L
.63595 .30902 L
.63666 .30902 L
.63732 .30902 L
.63854 .30902 L
.63967 .30902 L
.64096 .30902 L
.6422 .30902 L
.64336 .30902 L
.64441 .30902 L
.64562 .30902 L
.64677 .30902 L
.64783 .30902 L
.6488 .30902 L
.64987 .30902 L
.651 .30902 L
.65214 .30902 L
.65322 .30902 L
.65446 .30902 L
.65559 .30902 L
Mistroke
.65683 .30902 L
.65753 .30902 L
.65819 .30902 L
.65936 .30902 L
.66061 .30902 L
.66175 .30902 L
.663 .30902 L
.6643 .30902 L
.66551 .30902 L
.66665 .30902 L
.66768 .30902 L
.66887 .30902 L
.66999 .30902 L
.67122 .30902 L
.67252 .30902 L
.67363 .30902 L
.67485 .30902 L
.67616 .30902 L
.67689 .30902 L
.67756 .30902 L
.67887 .30902 L
.6801 .30902 L
.68126 .30902 L
.6823 .30902 L
.68351 .30902 L
.68465 .30902 L
.6857 .30902 L
.68667 .30902 L
.68773 .30902 L
.68886 .30902 L
.68999 .30902 L
.69121 .30902 L
.69236 .30902 L
.6934 .30902 L
.69463 .30902 L
.69533 .30902 L
.69597 .30902 L
.69714 .30902 L
.69839 .30902 L
.69959 .30902 L
.70091 .30902 L
.70215 .30902 L
.7033 .30902 L
.70442 .30902 L
.70548 .30902 L
.70669 .30902 L
.7078 .30902 L
.70903 .30902 L
.71033 .30902 L
.71144 .30902 L
Mistroke
.71266 .30902 L
.71397 .30902 L
.71471 .30902 L
.71538 .30902 L
.71668 .30902 L
.71792 .30902 L
.71897 .30902 L
.72013 .30902 L
.72134 .30902 L
.72247 .30902 L
.72353 .30902 L
.7245 .30902 L
.72556 .30902 L
.72668 .30902 L
.72783 .30902 L
.72904 .30902 L
.73019 .30902 L
.73124 .30902 L
.73247 .30902 L
.73316 .30902 L
.7338 .30902 L
.73498 .30902 L
.73622 .30902 L
.73743 .30902 L
.73875 .30902 L
.73999 .30902 L
.74115 .30902 L
.74229 .30902 L
.74333 .30902 L
.74453 .30902 L
.74565 .30902 L
.74689 .30902 L
.74819 .30902 L
.75053 .30902 L
.75174 .30902 L
.75304 .30902 L
.75378 .30902 L
.75446 .30902 L
.75514 .30902 L
.75579 .30902 L
.75684 .30902 L
.758 .30902 L
.75922 .30902 L
.76035 .30902 L
.76141 .30902 L
.76238 .30902 L
.76345 .30902 L
.76457 .30902 L
.76571 .30902 L
.76693 .30902 L
Mistroke
.76808 .30902 L
.76912 .30902 L
.77035 .30902 L
.77105 .30902 L
.77169 .30902 L
.77286 .30902 L
.7741 .30902 L
.77532 .30902 L
.776 .30902 L
.77664 .30902 L
.77781 .30902 L
.77905 .30902 L
.78015 .30902 L
.78119 .30902 L
.78233 .30902 L
.78356 .30902 L
.78479 .30902 L
.78549 .30902 L
.78614 .30902 L
.78745 .30902 L
.78885 .30902 L
.79371 .30902 L
.81204 .30902 L
.8535 .30902 L
.89344 .30902 L
.93187 .30902 L
.97275 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0002<ol000<0
I_lco`0co`000S?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001S?o00030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool04ooo
o`004Oooo`030000<ol0<ol002lco`000`0003?o03?o000F<ol000<0I_lco`0co`005S?o00030000
<ol0<ol002hco`000`0003?o03?o000_<ol000<0003oooooool0;oooo`030000oooooooo01?oool0
017ooom;<ol000<0I_lco`0co`00NC?o00030000oooooooo04Goool0017ooom;<ol000<0I_lco`0c
o`00NC?o00030000oooooooo04Goool0017ooom;<ol000<0I_lco`0co`00NC?o00030000oooooooo
04Goool0017ooom;<ol000<0I_lco`0co`00NC?o00030000oooooooo04Goool0017ooom;<ol000<0
I_lco`0co`00NC?o00030000oooooooo04Goool0017oool306KoB3?o000306Ko<ol0<ol007Tco`02
0000A_ooo`004Oooo`<co`0606Ko@S?o000306Ko<ol0<ol007Tco`000`000?ooooooo`15oooo000A
oooo2C?o00L0I_lk<ol000<0I_lco`0co`00NC?o00030000oooooooo04Goool0017oool@<ol0201V
oc<co`000`1Voc?o03?o001i<ol000<0003oooooool0AOooo`004OoooaPco`0606Ko;C?o000306Ko
<ol0<ol007Tco`000`000?ooooooo`15oooo000Aoooo7S?o00D0I_lX<ol000<0I_lco`0co`00NC?o
00030000oooooooo04Goool0017ooolS<ol01@1Vob<co`000`1Voc?o03?o001i<ol000<0003ooooo
ool0AOooo`004OooobPco`0506Ko7S?o000306Ko<ol0<ol007Tco`000`000?ooooooo`15oooo000A
oooo0P0002/co`0506Ko6C?o000306Ko<ol0<ol007Tco`020000A_ooo`004oooo`80000^<ol0101V
oaDco`000`1Voc?o03?o001i<ol000<0003oooooool0AOooo`005Oooo`80000`<ol00`1Voa8co`00
0`1Voc?o03?o001i<ol000<0003oooooool0AOooo`005oooo`80000a<ol0101Vo`hco`000`1Voc?o
03?o001i<ol000<0003oooooool0AOooo`006Oooo`80000c<ol00`1Vo`/co`000`1Voc?o03?o001i
<ol000<0003oooooool0AOooo`006oooo`80000d<ol00`1Vo`Pco`000`1Voc?o03?o001i<ol000<0
003oooooool0AOooo`007Oooo`80000e<ol0101Vo`@co`000`1Voc?o03?o001i<ol000<0003ooooo
ool0AOooo`007oooo`030000<ol0<ol003Hco`0306Ko00<co`00I_lco`00NS?o00030000oooooooo
04Goool0023oool00`0003?o03?o000h<ol00P1Vog/co`020000A_ooo`008Oooo`80000i<ol000?o
09Tco`0co`00NC?o00030000oooooooo04Goool002?oool00`0003?o03?o000f<ol000?o09Tco`0c
o`00NC?o00030000oooooooo04Goool002Coool20000=S?o0003o`2I<ol0<ol007Tco`000`000?oo
ooooo`15oooo000Voooo00<0000co`0co`00<c?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15
oooo000Woooo00<0000co`0co`00<S?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15oooo000X
oooo00<0000co`0co`00<C?o0003o`2I<ol0<ol0060co`02000013?o00800004<ol00P0000<co`04
000013?o00030000oooooooo04Goool002Woool00`0003?o03?o000`<ol000?o09Tco`0co`00Gc?o
00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o00030000<ol0<ol000Dco`000`000?oo
ooooo`15oooo000Zoooo00<0000co`0co`00;c?o0003o`2I<ol0<ol005lco`00100003?o03?o0000
00Pco`00100003?o03?o000000<co`000`0003?o03?o0004<ol00`0004Goool002_oool20000;c?o
0003o`2I<ol0<ol005lco`00100003?o03?o000000Pco`00100003?o03?o000000@co`000`0003?o
03?o0003<ol000<0003oooooool0AOooo`00;Oooo`030000<ol0<ol002`co`000ol0VC?o03?o001O
<ol000@0000co`0co`000008<ol000@0000co`0co`000002<ol000@0000co`0co`000004<ol000<0
003oooooool0AOooo`00;_ooo`030000<ol0<ol002/co`000ol0VC?o03?o001P<ol00P0000Xco`02
000013?o00800005<ol000<0003oooooool0AOooo`00;oooo`030000<ol0<ol002Xco`000ol0VC?o
03?o001i<ol000<0003oooooool0AOooo`00<?ooo`030000<ol0<ol002Tco`000ol0VC?o03?o001i
<ol000<0003oooooool0AOooo`00<Oooo`030000<ol0<ol002Pco`000ol0VC?o03?o001i<ol000<0
003oooooool0AOooo`00<_ooo`030000<ol0<ol002Lco`000ol0VC?o03?o001i<ol000<0003ooooo
ool0AOooo`00<oooo`030000<ol0<ol002Hco`000ol0VC?o03?o001i<ol00P0004Koool003?oool0
0`0003?o03?o000V<ol000?o09Tco`0co`00NC?o00030000oooooooo04Goool003Coool00`0003?o
03?o000U<ol000?o09Tco`0co`00NC?o00030000oooooooo04Goool003Goool00`0003?o03?o000T
<ol000?o09Tco`0co`00NC?o00030000oooooooo04Goool003Koool00`0003?o03?o000S<ol000?o
09Tco`0co`00NC?o00030000oooooooo04Goool003Ooool00`0003?o03?o000R<ol000?o09Tco`0c
o`00NC?o00030000oooooooo04Goool003Soool00`0003?o03?o000Q<ol000?o09Tco`0co`00NC?o
00030000oooooooo04Goool003Soool00`0003?o03?o000Q<ol000?o09Tco`0co`00NC?o00030000
oooooooo04Goool003Woool00`0003?o03?o000P<ol000?o09Tco`0co`00NC?o00800016oooo000j
oooo00<0000co`0co`007c?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15oooo000koooo00<0
000co`0co`007S?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15oooo000loooo00<0000co`0c
o`007C?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15oooo000loooo00<0000co`0co`007C?o
0003o`2I<ol0<ol007Tco`000`000?ooooooo`15oooo000moooo00<0000co`0co`0073?o0003o`2I
<ol0<ol007Tco`000`000?ooooooo`15oooo000moooo00<0000co`0co`0073?o0003o`2I<ol0<ol0
07Tco`000`000?ooooooo`15oooo000noooo00<0000co`0co`006c?o0003o`2I<ol0<ol007Tco`00
0`000?ooooooo`15oooo000noooo00<0000co`0co`006c?o0003o`2I<ol0<ol007Tco`000`000?oo
ooooo`15oooo000ooooo00<0000co`0co`006S?o0003o`2I<ol0<ol007Tco`020000A_ooo`00?ooo
o`030000<ol0<ol001Xco`000ol0VC?o03?o001i<ol000<0003oooooool0AOooo`00@?ooo`030000
<ol0<ol001Tco`000ol0VC?o03?o001i<ol000<0003oooooool0AOooo`00@Oooo`030000<ol0<ol0
01Pco`000ol0VC?o03?o001i<ol000<0003oooooool0AOooo`00@Oooo`030000<ol0<ol001Pco`00
0ol0VC?o03?o001i<ol000<0003oooooool0AOooo`00@_ooo`030000<ol0<ol001Lco`000ol0VC?o
03?o001i<ol000<0003oooooool0AOooo`00@_ooo`030000<ol0<ol001Lco`000ol0VC?o03?o001P
<ol00P0000@co`02000013?o00800005<ol00`0000<co`000`000?ooooooo`15oooo0013oooo00<0
000co`0co`005S?o0003o`2I<ol0<ol005lco`00100003?o03?o000000Pco`00100003?o03?o0000
00Dco`000`0003?o03?o0002<ol000<0003oooooool0AOooo`00@oooo`030000<ol0<ol001Hco`00
0ol0VC?o03?o001O<ol000@0000co`0co`000008<ol000@0000co`0co`000002<ol01@0000<co`03
0000AOooo`00A?ooo`030000<ol0<ol001Dco`000ol0VC?o03?o001O<ol000@0000co`0co`000008
<ol000@0000co`0co`000002<ol000@0000co`0co`000004<ol000<0003oooooool0AOooo`00A?oo
o`030000<ol0<ol001Dco`000ol0VC?o03?o001O<ol000@0000co`0co`000008<ol000@0000co`0c
o`000003<ol000<0000co`00000013?o00030000oooooooo04Goool004Goool00`0003?o03?o000D
<ol000?o09Tco`0co`00H3?o0080000:<ol00P0000Dco`02000013?o00030000oooooooo04Goool0
04Goool00`0003?o03?o000D<ol000?o09Tco`0co`00NC?o00030000oooooooo04Goool004Koool0
0`0003?o03?o000C<ol000?o09Tco`0co`00NC?o00030000oooooooo04Goool004Koool00`0003?o
03?o000C<ol000?o09Tco`0co`00NC?o00030000oooooooo04Goool004Ooool00`0003?o03?o000B
<ol000?o09Tco`0co`00NC?o00030000oooooooo04Goool004Ooool00`0003?o03?o000B<ol000?o
09Tco`0co`00NC?o00800016oooo0018oooo00<0000co`0co`004C?o0003o`2I<ol0<ol007Tco`00
0`000?ooooooo`15oooo0018oooo00<0000co`0co`004C?o0003o`2I<ol0<ol007Tco`000`000?oo
ooooo`15oooo0019oooo00<0000co`0co`0043?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15
oooo0019oooo00<0000co`0co`0043?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15oooo001:
oooo00<0000co`0co`003c?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15oooo001:oooo00<0
000co`0co`003c?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15oooo001;oooo00<0000co`0c
o`003S?o0003o`2I<ol0<ol007Tco`000`000?ooooooo`15oooo001;oooo00<0000co`0co`003S?o
0003o`2I<ol0<ol007Tco`020000A_ooo`00C?oooh`co`18oooo001<ooooS3?o04Soool004cooon<
<ol0B?ooo`00COoooh/co`18oooo001=ooooRc?o04Soool004kooolV<ol000<0000co`0co`00;c?o
00030000<ol0<ol002lco`18oooo001>oooo9C?o00030000<ol0<ol000Pco`000`0003?o03?o000V
<ol000<0000co`0co`00;S?o04Soool004oooolT<ol000<0000co`0co`000S?o00800004<ol000<0
000co`0co`003S?o00800004<ol00P0000<co`0400000c?o00800004<ol000<0000co`0co`00;S?o
04Soool004oooolT<ol000D0000co`0co`0co`0000000S?o00030000<ol0<ol0008co`000`0003?o
03?o0005<ol0100000<co`00100003?o03?o000000Pco`000`0003?o03?o0003<ol000@0000co`0c
o`000003<ol000<0000co`0co`00;S?o04Soool004oooolS<ol000<0000co`0co`000S?o00030000
<ol0<ol001@co`00100003?o03?o000000Tco`000`0003?o03?o0005<ol000<0000co`0co`000S?o
00030000<ol0<ol002dco`18oooo001@oooo8c?o00030000<ol0<ol000D0000C<ol000@0000co`0c
o`00000:<ol000<0000co`0co`000S?o00800004<ol000<0000co`0co`00;S?o04Soool0053ooolS
<ol000D0000co`0co`0co`0000005S?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o
00030000<ol0<ol000<co`000`0003?o03?o000^<ol0B?ooo`00D?ooob@co`000`0003?o03?o000H
<ol00P0000Xco`02000013?o00<00002<ol000<0000co`0co`00;c?o04Soool0057ooon7<ol0B?oo
o`00DOooohLco`18oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.24) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.30316 .30902 L
.30791 .30902 L
.31054 .30902 L
.31183 .30902 L
.31304 .30902 L
s
.31304 .30902 m
.31304 .61803 L
s
0 .4 1 r
.02381 .33916 m
.06244 .34382 L
.10458 .34972 L
.14415 .35618 L
.18221 .36336 L
.22272 .37222 L
.26171 .38213 L
.28158 .38778 L
.29205 .39092 L
.30316 .3944 L
.30791 .39594 L
.31054 .3968 L
.31183 .39723 L
.31304 .39763 L
.31371 .30902 L
.31444 .30902 L
.31524 .30902 L
.31597 .30902 L
.31663 .30902 L
.31735 .30902 L
.31865 .30902 L
.31929 .30902 L
.31999 .30902 L
.32071 .30902 L
.32139 .30902 L
.32261 .30902 L
.32392 .30902 L
.3252 .30902 L
.32638 .30902 L
.32768 .30902 L
.32835 .30902 L
.32907 .30902 L
.33026 .30902 L
.33138 .30902 L
.33203 .30902 L
.33272 .30902 L
.33394 .30902 L
.33504 .30902 L
.33621 .30902 L
.33731 .30902 L
.33831 .30902 L
.33949 .30902 L
.34077 .30902 L
.34197 .30902 L
.34309 .30902 L
.34434 .30902 L
.34553 .30902 L
.34659 .30902 L
.34776 .30902 L
.34902 .30902 L
Mistroke
.34971 .30902 L
.35036 .30902 L
.35163 .30902 L
.35278 .30902 L
.35388 .30902 L
.35505 .30902 L
.35605 .30902 L
.35714 .30902 L
.35832 .30902 L
.35958 .30902 L
.36077 .30902 L
.36185 .30902 L
.36313 .30902 L
.36378 .30902 L
.36449 .30902 L
.36575 .30902 L
.36693 .30902 L
.36761 .30902 L
.36832 .30902 L
.36959 .30902 L
.37025 .30902 L
.37096 .30902 L
.37173 .30902 L
.37245 .30902 L
.37375 .30902 L
.37449 .30902 L
.37516 .30902 L
.3764 .30902 L
.37771 .30902 L
.37881 .30902 L
.37999 .30902 L
.38128 .30902 L
.38249 .30902 L
.3837 .30902 L
.38439 .30902 L
.38504 .30902 L
.38635 .30902 L
.38709 .30902 L
.38776 .30902 L
.3889 .30902 L
.39014 .30902 L
.39144 .30902 L
.39265 .30902 L
.39334 .30902 L
.39408 .30902 L
.39479 .30902 L
.39544 .30902 L
.39668 .30902 L
.39799 .30902 L
.39867 .30902 L
Mistroke
.39939 .30902 L
.40071 .30902 L
.40151 .30902 L
.40227 .30902 L
.40296 .30902 L
.4037 .30902 L
.40436 .30902 L
.40507 .30902 L
.40635 .30902 L
.4076 .30902 L
.40875 .30902 L
.40999 .30902 L
.41069 .30902 L
.41132 .30902 L
.41207 .30902 L
.41278 .30902 L
.41343 .30902 L
.41414 .30902 L
.41532 .30902 L
.41658 .30902 L
.41766 .30902 L
.41884 .30902 L
.42008 .30902 L
.42077 .30902 L
.42141 .30902 L
.42258 .30902 L
.42382 .30902 L
.42505 .30902 L
.42575 .30902 L
.42639 .30902 L
.42755 .30902 L
.42882 .30902 L
.42997 .30902 L
.43103 .30902 L
.43216 .30902 L
.43337 .30902 L
.43468 .30902 L
.43542 .30902 L
.43611 .30902 L
.43737 .30902 L
.43807 .30902 L
.4387 .30902 L
.43991 .30902 L
.44121 .30902 L
.44244 .30902 L
.44357 .30902 L
.44464 .30902 L
.44578 .30902 L
.44686 .30902 L
.44784 .30902 L
Mistroke
.44899 .30902 L
.45024 .30902 L
.45142 .30902 L
.45252 .30902 L
.45364 .30902 L
.45469 .30902 L
.45585 .30902 L
.45709 .30902 L
.45839 .30902 L
.45963 .30902 L
.46073 .30902 L
.46195 .30902 L
.46259 .30902 L
.46327 .30902 L
.4645 .30902 L
.46581 .30902 L
.46656 .30902 L
.46725 .30902 L
.46852 .30902 L
.46967 .30902 L
.4703 .30902 L
.471 .30902 L
.47226 .30902 L
.47338 .30902 L
.47461 .30902 L
.4759 .30902 L
.47711 .30902 L
.47824 .30902 L
.47928 .30902 L
.48041 .30902 L
.48161 .30902 L
.48292 .30902 L
.48412 .30902 L
.48478 .30902 L
.48549 .30902 L
.4868 .30902 L
.48801 .30902 L
.48931 .30902 L
.49162 .30902 L
.49292 .30902 L
.49365 .30902 L
.49432 .30902 L
.49561 .30902 L
.49684 .30902 L
.49753 .30902 L
.49826 .30902 L
.49958 .30902 L
.50039 .30902 L
.50116 .30902 L
.50184 .30902 L
Mistroke
.50258 .30902 L
.50382 .30902 L
.50496 .30902 L
.50627 .30902 L
.50751 .30902 L
.50865 .30902 L
.50971 .30902 L
.51087 .30902 L
.5121 .30902 L
.51334 .30902 L
.51403 .30902 L
.51467 .30902 L
.51584 .30902 L
.51707 .30902 L
.51773 .30902 L
.51843 .30902 L
.51969 .30902 L
.52046 .30902 L
.52119 .30902 L
.52184 .30902 L
.52255 .30902 L
.52386 .30902 L
.52509 .30902 L
.52579 .30902 L
.52643 .30902 L
.52717 .30902 L
.52788 .30902 L
.53352 .30902 L
.54362 .30902 L
.54859 .30902 L
.55102 .30902 L
.55209 .30902 L
.55325 .30902 L
.55439 .30902 L
.55559 .30902 L
.5569 .30902 L
.55812 .30902 L
.55882 .30902 L
.55948 .30902 L
.56072 .30902 L
.56141 .30902 L
.56205 .30902 L
.56275 .30902 L
.5635 .30902 L
.56464 .30902 L
.56568 .30902 L
.56688 .30902 L
.56802 .30902 L
.56907 .30902 L
.57005 .30902 L
Mistroke
.57112 .30902 L
.57226 .30902 L
.57351 .30902 L
.57417 .30902 L
.57486 .30902 L
.57614 .30902 L
.57732 .30902 L
.57845 .30902 L
.57951 .30902 L
.58066 .30902 L
.58191 .30902 L
.58313 .30902 L
.58447 .30902 L
.58578 .30902 L
.58652 .30902 L
.58719 .30902 L
.58842 .30902 L
.58972 .30902 L
.59085 .30902 L
.59208 .30902 L
.59744 .30902 L
.59812 .30902 L
.59885 .30902 L
.59964 .30902 L
.60038 .30902 L
.6017 .30902 L
.60245 .30902 L
.60315 .30902 L
.60386 .30902 L
.60453 .30902 L
.60579 .30902 L
.60649 .30902 L
.60714 .30902 L
.60785 .30902 L
.60862 .30902 L
.60926 .30902 L
.60996 .30902 L
.61122 .30902 L
.61245 .30902 L
.61358 .30902 L
.61474 .30902 L
.61583 .30902 L
.61702 .30902 L
.6183 .30902 L
.61894 .30902 L
.61964 .30902 L
.6209 .30902 L
.62214 .30902 L
.62328 .30902 L
.62452 .30902 L
Mistroke
.6257 .30902 L
.62677 .30902 L
.62793 .30902 L
.62918 .30902 L
.62988 .30902 L
.63052 .30902 L
.63178 .30902 L
.63293 .30902 L
.63402 .30902 L
.63517 .30902 L
.63632 .30902 L
.63759 .30902 L
.63869 .30902 L
.63986 .30902 L
.64097 .30902 L
.64198 .30902 L
.64326 .30902 L
.6439 .30902 L
.64461 .30902 L
.64587 .30902 L
.64705 .30902 L
.64773 .30902 L
.64844 .30902 L
.64971 .30902 L
.65041 .30902 L
.65107 .30902 L
.65179 .30902 L
.65257 .30902 L
.65378 .30902 L
.65508 .30902 L
.65631 .30902 L
.65744 .30902 L
.65862 .30902 L
.6599 .30902 L
.66062 .30902 L
.66128 .30902 L
.6626 .30902 L
.6633 .30902 L
.66395 .30902 L
.66518 .30902 L
.6665 .30902 L
.66724 .30902 L
.66792 .30902 L
.66906 .30902 L
.67031 .30902 L
.67161 .30902 L
.67283 .30902 L
.67352 .30902 L
.67427 .30902 L
.67498 .30902 L
Mistroke
.67563 .30902 L
.67687 .30902 L
.67819 .30902 L
.67887 .30902 L
.6796 .30902 L
.68092 .30902 L
.68167 .30902 L
.68248 .30902 L
.68324 .30902 L
.68393 .30902 L
.68519 .30902 L
.68638 .30902 L
.68766 .30902 L
.68838 .30902 L
.68905 .30902 L
.6897 .30902 L
.6904 .30902 L
.69167 .30902 L
.69299 .30902 L
.69375 .30902 L
.69444 .30902 L
.69567 .30902 L
.69681 .30902 L
.69806 .30902 L
.69875 .30902 L
.69938 .30902 L
.70055 .30902 L
.7018 .30902 L
.70299 .30902 L
.70407 .30902 L
.70535 .30902 L
.70655 .30902 L
.70763 .30902 L
.7088 .30902 L
.71007 .30902 L
.71072 .30902 L
.71142 .30902 L
.71268 .30902 L
.71385 .30902 L
.71502 .30902 L
.71614 .30902 L
.71714 .30902 L
.71824 .30902 L
.71942 .30902 L
.72068 .30902 L
.72188 .30902 L
.72296 .30902 L
.72425 .30902 L
.7249 .30902 L
.72562 .30902 L
Mistroke
.72689 .30902 L
.72807 .30902 L
.72879 .30902 L
.72947 .30902 L
.73074 .30902 L
.73141 .30902 L
.73212 .30902 L
.73289 .30902 L
.73361 .30902 L
.73479 .30902 L
.73607 .30902 L
.73727 .30902 L
.73838 .30902 L
.7396 .30902 L
.7403 .30902 L
.74094 .30902 L
.74225 .30902 L
.74298 .30902 L
.74364 .30902 L
.74483 .30902 L
.74595 .30902 L
.74717 .30902 L
.74849 .30902 L
.74915 .30902 L
.74986 .30902 L
.75117 .30902 L
.75244 .30902 L
.75362 .30902 L
.75483 .30902 L
.75596 .30902 L
.75698 .30902 L
.75808 .30902 L
.75926 .30902 L
.76053 .30902 L
.76173 .30902 L
.76282 .30902 L
.76412 .30902 L
.76534 .30902 L
.76666 .30902 L
.76741 .30902 L
.7681 .30902 L
.76938 .30902 L
.77011 .30902 L
.7708 .30902 L
.77152 .30902 L
.77218 .30902 L
.7729 .30902 L
.77366 .30902 L
.77485 .30902 L
.77613 .30902 L
Mistroke
.77733 .30902 L
.77842 .30902 L
.7797 .30902 L
.78043 .30902 L
.7811 .30902 L
.78232 .30902 L
.78362 .30902 L
.78483 .30902 L
.78552 .30902 L
.78616 .30902 L
.78732 .30902 L
.78856 .30902 L
.79308 .30902 L
.80323 .30902 L
.82155 .30902 L
.85927 .30902 L
.89943 .30902 L
.93808 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.24) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0003<ol000D0
I_lco`0co`0co`0000002C?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`00
0`0003?o03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`0Coooo000Aoooo00<0
000co`0co`00;c?o00030000<ol0<ol001Lco`000`1Voc?o03?o000E<ol000<0000co`0co`00;S?o
00030000<ol0<ol002lco`000`000?ooooooo`0_oooo00<0003oooooool04oooo`004Ooood`co`00
0`1Voc?o03?o001h<ol000<0003oooooool0AOooo`004Ooood`co`000`1Voc?o03?o001h<ol000<0
003oooooool0AOooo`004Ooood`co`000`1Voc?o03?o001h<ol000<0003oooooool0AOooo`004Ooo
od`co`000`1Voc?o03?o001h<ol000<0003oooooool0AOooo`004Ooood`co`000`1Voc?o03?o001h
<ol000<0003oooooool0AOooo`004Oooo`H0I_m6<ol000<0I_lco`0co`00N3?o00800016oooo000A
oooo1S?o00P0I_ln<ol000<0I_lco`0co`00N3?o00030000oooooooo04Goool0017oool><ol01@1V
ocTco`000`1Voc?o03?o001h<ol000<0003oooooool0AOooo`004Ooooa<co`0806Ko<C?o000306Ko
<ol0<ol007Pco`000`000?ooooooo`15oooo000Aoooo6c?o00P0I_lY<ol000<0I_lco`0co`00N3?o
00030000oooooooo04Goool0017ooolS<ol01@1Vob@co`000`1Voc?o03?o001h<ol000<0003ooooo
ool0AOooo`004OooobPco`0406Ko83?o000306Ko<ol0<ol007Pco`000`000?ooooooo`15oooo000A
oooo;3?o00<0I_lM<ol000<0I_lco`0co`00N3?o00030000oooooooo04Goool0017oool20000;C?o
00@0I_lI<ol000<0I_lco`0co`00N3?o00800016oooo000Coooo0P0002lco`0406Ko5C?o000306Ko
<ol0<ol007Pco`000`000?ooooooo`15oooo000Eoooo0P00034co`0506Ko43?o000306Ko<ol0<ol0
07Pco`000`000?ooooooo`15oooo000Goooo0P0003@co`0406Ko33?o000306Ko<ol0<ol007Pco`00
0`000?ooooooo`15oooo000Ioooo0P0003Hco`0306Ko2C?o000306Ko<ol0<ol007Pco`000`000?oo
ooooo`15oooo000Koooo0P0003Lco`0506Ko13?o000306Ko<ol0<ol007Pco`000`000?ooooooo`15
oooo000Moooo0P0003Xco`0206Ko0S?o000306Ko<ol0<ol007Pco`000`000?ooooooo`15oooo000O
oooo00<0000co`0co`00>C?o00<0I_mj<ol000<0003oooooool0AOooo`008?ooo`030000<ol0<ol0
03Xco`000ol0VC?o03?o001h<ol00P0004Koool0027oool20000>S?o0003o`2I<ol0<ol007Pco`00
0`000?ooooooo`15oooo000Soooo00<0000co`0co`00=c?o0003o`2I<ol0<ol007Pco`000`000?oo
ooooo`15oooo000Toooo0P0003Lco`000ol0VC?o03?o001h<ol000<0003oooooool0AOooo`009_oo
o`030000<ol0<ol003@co`000ol0VC?o03?o001h<ol000<0003oooooool0AOooo`009oooo`030000
<ol0<ol003<co`000ol0VC?o03?o001h<ol000<0003oooooool0AOooo`00:?ooo`030000<ol0<ol0
038co`000ol0VC?o03?o001O<ol00P0000@co`02000013?o00800003<ol0100000@co`000`000?oo
ooooo`15oooo000Yoooo00<0000co`0co`00<C?o0003o`2I<ol0<ol005hco`00100003?o03?o0000
00Pco`00100003?o03?o0000008co`000`0003?o03?o0005<ol000<0003oooooool0AOooo`00:_oo
o`030000<ol0<ol0030co`000ol0VC?o03?o001N<ol000@0000co`0co`000008<ol000@0000co`0c
o`000003<ol000<0000co`0co`0013?o00<00015oooo000[oooo0P00030co`000ol0VC?o03?o001N
<ol000@0000co`0co`000008<ol000@0000co`0co`000004<ol000<0000co`0co`000c?o00030000
oooooooo04Goool002goool00`0003?o03?o000]<ol000?o09Tco`0co`00GS?o00040000<ol0<ol0
000023?o00040000<ol0<ol000000S?o00040000<ol0<ol0000013?o00030000oooooooo04Goool0
02koool00`0003?o03?o000/<ol000?o09Tco`0co`00Gc?o0080000:<ol00P0000@co`0200001C?o
00030000oooooooo04Goool002ooool00`0003?o03?o000[<ol000?o09Tco`0co`00N3?o00030000
oooooooo04Goool0033oool00`0003?o03?o000Z<ol000?o09Tco`0co`00N3?o00030000oooooooo
04Goool0037oool00`0003?o03?o000Y<ol000?o09Tco`0co`00N3?o00030000oooooooo04Goool0
03;oool00`0003?o03?o000X<ol000?o09Tco`0co`00N3?o00030000oooooooo04Goool003?oool0
0`0003?o03?o000W<ol000?o09Tco`0co`00N3?o00800016oooo000coooo00<0000co`0co`009c?o
0003o`2I<ol0<ol007Pco`000`000?ooooooo`15oooo000doooo00<0000co`0co`009S?o0003o`2I
<ol0<ol007Pco`000`000?ooooooo`15oooo000eoooo00<0000co`0co`009C?o0003o`2I<ol0<ol0
07Pco`000`000?ooooooo`15oooo000foooo00<0000co`0co`0093?o0003o`2I<ol0<ol007Pco`00
0`000?ooooooo`15oooo000goooo00<0000co`0co`008c?o0003o`2I<ol0<ol007Pco`000`000?oo
ooooo`15oooo000hoooo00<0000co`0co`008S?o0003o`2I<ol0<ol007Pco`000`000?ooooooo`15
oooo000hoooo00<0000co`0co`008S?o0003o`2I<ol0<ol007Pco`000`000?ooooooo`15oooo000i
oooo00<0000co`0co`008C?o0003o`2I<ol0<ol007Pco`020000A_ooo`00>_ooo`030000<ol0<ol0
020co`000ol0VC?o03?o001h<ol000<0003oooooool0AOooo`00>oooo`030000<ol0<ol001lco`00
0ol0VC?o03?o001h<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001hco`000ol0VC?o
03?o001h<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001hco`000ol0VC?o03?o001h
<ol000<0003oooooool0AOooo`00?Oooo`030000<ol0<ol001dco`000ol0VC?o03?o001h<ol000<0
003oooooool0AOooo`00?Oooo`030000<ol0<ol001dco`000ol0VC?o03?o001h<ol000<0003ooooo
ool0AOooo`00?_ooo`030000<ol0<ol001`co`000ol0VC?o03?o001h<ol000<0003oooooool0AOoo
o`00?_ooo`030000<ol0<ol001`co`000ol0VC?o03?o001h<ol000<0003oooooool0AOooo`00?ooo
o`030000<ol0<ol001/co`000ol0VC?o03?o001h<ol00P0004Koool003ooool00`0003?o03?o000K
<ol000?o09Tco`0co`00N3?o00030000oooooooo04Goool0043oool00`0003?o03?o000J<ol000?o
09Tco`0co`00N3?o00030000oooooooo04Goool0047oool00`0003?o03?o000I<ol000?o09Tco`0c
o`00N3?o00030000oooooooo04Goool0047oool00`0003?o03?o000I<ol000?o09Tco`0co`00N3?o
00030000oooooooo04Goool004;oool00`0003?o03?o000H<ol000?o09Tco`0co`00N3?o00030000
oooooooo04Goool004;oool00`0003?o03?o000H<ol000?o09Tco`0co`00Gc?o00800004<ol00P00
00@co`0200001C?o00<00003<ol000<0003oooooool0AOooo`00@oooo`030000<ol0<ol001Lco`00
0ol0VC?o03?o001N<ol000@0000co`0co`000008<ol000@0000co`0co`000005<ol000<0000co`0c
o`000S?o00030000oooooooo04Goool004?oool00`0003?o03?o000G<ol000?o09Tco`0co`00GS?o
00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o00D00003<ol00`0004Goool004Coool0
0`0003?o03?o000F<ol000?o09Tco`0co`00GS?o00040000<ol0<ol0000023?o00040000<ol0<ol0
00000S?o00040000<ol0<ol0000013?o00030000oooooooo04Goool004Coool00`0003?o03?o000F
<ol000?o09Tco`0co`00GS?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000
<ol0000000@co`000`000?ooooooo`15oooo0015oooo00<0000co`0co`005C?o0003o`2I<ol0<ol0
05lco`0200002S?o00800005<ol00P0000@co`000`000?ooooooo`15oooo0015oooo00<0000co`0c
o`005C?o0003o`2I<ol0<ol007Pco`000`000?ooooooo`15oooo0016oooo00<0000co`0co`0053?o
0003o`2I<ol0<ol007Pco`000`000?ooooooo`15oooo0016oooo00<0000co`0co`0053?o0003o`2I
<ol0<ol007Pco`000`000?ooooooo`15oooo0017oooo00<0000co`0co`004c?o0003o`2I<ol0<ol0
07Pco`000`000?ooooooo`15oooo0017oooo00<0000co`0co`004c?o0003o`2I<ol0<ol007Pco`02
0000A_ooo`00B?ooo`030000<ol0<ol0018co`000ol0VC?o03?o001h<ol000<0003oooooool0AOoo
o`00B?ooo`030000<ol0<ol0018co`000ol0VC?o03?o001h<ol000<0003oooooool0AOooo`00BOoo
o`030000<ol0<ol0014co`000ol0VC?o03?o001h<ol000<0003oooooool0AOooo`00BOooo`030000
<ol0<ol0014co`000ol0VC?o03?o001h<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol0
010co`000ol0VC?o03?o001h<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol0010co`00
0ol0VC?o03?o001h<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000lco`000ol0VC?o
03?o001h<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol000lco`000ol0VC?o03?o001h
<ol00P0004Koool004cooon<<ol0B?ooo`00C?oooh`co`18oooo001<ooooS3?o04Soool004gooon;
<ol0B?ooo`00COoooh/co`18oooo001>oooo9S?o00030000<ol0<ol002lco`000`0003?o03?o000_
<ol0B?ooo`00C_ooobDco`000`0003?o03?o0008<ol000<0000co`0co`009S?o00030000<ol0<ol0
02hco`18oooo001?oooo93?o00030000<ol0<ol0008co`02000013?o00030000<ol0<ol000hco`02
000013?o00800003<ol0100000@co`0300000S?o00030000<ol0<ol002hco`18oooo001?oooo93?o
00050000<ol0<ol0<ol00000008co`000`0003?o03?o0002<ol000<0000co`0co`001C?o00@00003
<ol000@0000co`0co`000008<ol000<0000co`0co`001S?o00050000<ol0<ol0<ol00000030co`18
oooo001?oooo8c?o00030000<ol0<ol0008co`000`0003?o03?o000D<ol000@0000co`0co`000009
<ol000<0000co`0co`000S?o00D00003<ol000<0000co`0co`00;C?o04Soool0053ooolS<ol000<0
000co`0co`001@0001<co`00100003?o03?o000000Xco`001@0003?o03?o03?o00000002<ol000D0
000co`0co`0co`000000<3?o04Soool0053ooolS<ol000D0000co`0co`0co`0000005S?o00040000
<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000<ol0000000<co`000`0003?o03?o000^
<ol0B?ooo`00D?ooob@co`000`0003?o03?o000H<ol00P0000Xco`0200001C?o00800002<ol000<0
000co`0co`00;c?o04Soool0057ooon7<ol0B?ooo`00DOooohLco`18oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.23) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.30316 .30902 L
.30791 .30902 L
.31304 .30902 L
.31454 .30902 L
.31528 .30902 L
.31597 .30902 L
s
.31597 .30902 m
.31598 .61803 L
s
0 .4 1 r
.02381 .33786 m
.06244 .34231 L
.10458 .34796 L
.14415 .35414 L
.18221 .36102 L
.22272 .3695 L
.26171 .37898 L
.28158 .38438 L
.29205 .38739 L
.30316 .39072 L
.30791 .39219 L
.31304 .3938 L
.31454 .39428 L
.31528 .39452 L
.31597 .39474 L
.31725 .30902 L
.31793 .30902 L
.31865 .30902 L
.31934 .30902 L
.32008 .30902 L
.32077 .30902 L
.32141 .30902 L
.32263 .30902 L
.32392 .30902 L
.32511 .30902 L
.3262 .30902 L
.32745 .30902 L
.32864 .30902 L
.32974 .30902 L
.33076 .30902 L
.33187 .30902 L
.33305 .30902 L
.33424 .30902 L
.33551 .30902 L
.33672 .30902 L
.33782 .30902 L
.33905 .30902 L
.33974 .30902 L
.34039 .30902 L
.34169 .30902 L
.34241 .30902 L
.34309 .30902 L
.34432 .30902 L
.34497 .30902 L
.34567 .30902 L
.34641 .30902 L
.34711 .30902 L
.34841 .30902 L
.34964 .30902 L
.35079 .30902 L
Mistroke
.35143 .30902 L
.35212 .30902 L
.35333 .30902 L
.35403 .30902 L
.35476 .30902 L
.35608 .30902 L
.3573 .30902 L
.358 .30902 L
.35864 .30902 L
.35939 .30902 L
.3601 .30902 L
.36074 .30902 L
.36144 .30902 L
.36219 .30902 L
.36299 .30902 L
.36368 .30902 L
.36443 .30902 L
.36571 .30902 L
.36635 .30902 L
.36705 .30902 L
.36829 .30902 L
.36944 .30902 L
.37014 .30902 L
.37081 .30902 L
.37205 .30902 L
.37274 .30902 L
.37338 .30902 L
.37409 .30902 L
.37483 .30902 L
.37599 .30902 L
.37723 .30902 L
.37841 .30902 L
.37948 .30902 L
.38073 .30902 L
.38144 .30902 L
.3821 .30902 L
.3833 .30902 L
.38458 .30902 L
.38572 .30902 L
.38696 .30902 L
.38825 .30902 L
.38946 .30902 L
.39059 .30902 L
.39162 .30902 L
.39281 .30902 L
.39394 .30902 L
.39516 .30902 L
.39645 .30902 L
.39756 .30902 L
.39878 .30902 L
Mistroke
.40008 .30902 L
.40082 .30902 L
.40149 .30902 L
.40279 .30902 L
.40403 .30902 L
.40516 .30902 L
.40622 .30902 L
.40745 .30902 L
.40856 .30902 L
.40961 .30902 L
.41058 .30902 L
.41165 .30902 L
.41277 .30902 L
.4139 .30902 L
.41512 .30902 L
.41627 .30902 L
.41731 .30902 L
.41854 .30902 L
.41923 .30902 L
.41988 .30902 L
.42105 .30902 L
.4223 .30902 L
.42344 .30902 L
.42469 .30902 L
.42599 .30902 L
.4272 .30902 L
.42833 .30902 L
.42936 .30902 L
.43056 .30902 L
.43168 .30902 L
.43291 .30902 L
.43421 .30902 L
.43531 .30902 L
.43653 .30902 L
.43784 .30902 L
.43858 .30902 L
.43925 .30902 L
.44055 .30902 L
.44179 .30902 L
.44294 .30902 L
.44399 .30902 L
.44519 .30902 L
.44633 .30902 L
.44738 .30902 L
.44835 .30902 L
.44942 .30902 L
.45054 .30902 L
.45168 .30902 L
.45289 .30902 L
.45404 .30902 L
Mistroke
.45509 .30902 L
.45632 .30902 L
.45701 .30902 L
.45765 .30902 L
.45882 .30902 L
.46007 .30902 L
.46128 .30902 L
.46259 .30902 L
.46383 .30902 L
.46498 .30902 L
.46612 .30902 L
.46716 .30902 L
.46835 .30902 L
.46948 .30902 L
.47071 .30902 L
.47201 .30902 L
.47312 .30902 L
.47434 .30902 L
.47565 .30902 L
.47639 .30902 L
.47706 .30902 L
.47836 .30902 L
.4796 .30902 L
.48065 .30902 L
.4818 .30902 L
.48301 .30902 L
.48415 .30902 L
.4852 .30902 L
.48617 .30902 L
.48724 .30902 L
.48836 .30902 L
.4895 .30902 L
.49072 .30902 L
.49187 .30902 L
.49291 .30902 L
.49414 .30902 L
.49484 .30902 L
.49547 .30902 L
.49665 .30902 L
.49789 .30902 L
.4991 .30902 L
.50042 .30902 L
.50167 .30902 L
.50282 .30902 L
.50397 .30902 L
.505 .30902 L
.5062 .30902 L
.50732 .30902 L
.50856 .30902 L
.50986 .30902 L
Mistroke
.51098 .30902 L
.5122 .30902 L
.51351 .30902 L
.51425 .30902 L
.51492 .30902 L
.51622 .30902 L
.51746 .30902 L
.51851 .30902 L
.51967 .30902 L
.52088 .30902 L
.52202 .30902 L
.52308 .30902 L
.52405 .30902 L
.52511 .30902 L
.52623 .30902 L
.52738 .30902 L
.5286 .30902 L
.52975 .30902 L
.53079 .30902 L
.53193 .30902 L
.53316 .30902 L
.53387 .30902 L
.53451 .30902 L
.53577 .30902 L
.53696 .30902 L
.53826 .30902 L
.53949 .30902 L
.54063 .30902 L
.54181 .30902 L
.54312 .30902 L
.54378 .30902 L
.54449 .30902 L
.54577 .30902 L
.54689 .30902 L
.54811 .30902 L
.55057 .30902 L
.55284 .30902 L
.55498 .30902 L
.55629 .30902 L
.55703 .30902 L
.55771 .30902 L
.55891 .30902 L
.56019 .30902 L
.56085 .30902 L
.56156 .30902 L
.56284 .30902 L
.56362 .30902 L
.56436 .30902 L
.56503 .30902 L
.56576 .30902 L
Mistroke
.56708 .30902 L
.56828 .30902 L
.56894 .30902 L
.56966 .30902 L
.57096 .30902 L
.57218 .30902 L
.57348 .30902 L
.57458 .30902 L
.57579 .30902 L
.5771 .30902 L
.5783 .30902 L
.57893 .30902 L
.57963 .30902 L
.58035 .30902 L
.58103 .30902 L
.58228 .30902 L
.58342 .30902 L
.58468 .30902 L
.586 .30902 L
.58711 .30902 L
.5883 .30902 L
.58943 .30902 L
.59045 .30902 L
.59165 .30902 L
.59295 .30902 L
.59417 .30902 L
.59531 .30902 L
.59651 .30902 L
.59781 .30902 L
.59903 .30902 L
.60015 .30902 L
.60145 .30902 L
.60219 .30902 L
.60288 .30902 L
.60413 .30902 L
.60483 .30902 L
.60547 .30902 L
.60614 .30902 L
.60686 .30902 L
.60813 .30902 L
.6088 .30902 L
.60951 .30902 L
.61028 .30902 L
.61101 .30902 L
.61168 .30902 L
.61241 .30902 L
.6131 .30902 L
.61374 .30902 L
.61494 .30902 L
.61622 .30902 L
Mistroke
.61743 .30902 L
.61874 .30902 L
.61998 .30902 L
.62113 .30902 L
.62227 .30902 L
.6233 .30902 L
.6245 .30902 L
.62562 .30902 L
.62685 .30902 L
.62815 .30902 L
.62926 .30902 L
.63048 .30902 L
.63179 .30902 L
.63253 .30902 L
.6332 .30902 L
.6345 .30902 L
.63574 .30902 L
.63679 .30902 L
.63794 .30902 L
.63915 .30902 L
.64029 .30902 L
.64134 .30902 L
.64231 .30902 L
.64338 .30902 L
.6445 .30902 L
.64564 .30902 L
.64686 .30902 L
.64801 .30902 L
.64905 .30902 L
.65028 .30902 L
.65097 .30902 L
.65161 .30902 L
.65279 .30902 L
.65403 .30902 L
.65524 .30902 L
.65656 .30902 L
.6578 .30902 L
.65896 .30902 L
.6601 .30902 L
.66114 .30902 L
.66233 .30902 L
.66346 .30902 L
.66583 .30902 L
.66712 .30902 L
.66833 .30902 L
.66963 .30902 L
.67033 .30902 L
.67107 .30902 L
.67239 .30902 L
.67359 .30902 L
Mistroke
.67472 .30902 L
.67593 .30902 L
.67696 .30902 L
.6781 .30902 L
.67931 .30902 L
.68062 .30902 L
.68186 .30902 L
.68299 .30902 L
.68407 .30902 L
.68507 .30902 L
.68616 .30902 L
.68733 .30902 L
.68856 .30902 L
.68972 .30902 L
.69077 .30902 L
.6919 .30902 L
.69311 .30902 L
.69426 .30902 L
.69489 .30902 L
.69558 .30902 L
.69679 .30902 L
.69795 .30902 L
.69917 .30902 L
.70033 .30902 L
.70137 .30902 L
.70263 .30902 L
.70326 .30902 L
.70396 .30902 L
.70471 .30902 L
.70541 .30902 L
.70605 .30902 L
.70674 .30902 L
.7074 .30902 L
.7081 .30902 L
.70939 .30902 L
.71064 .30902 L
.71179 .30902 L
.713 .30902 L
.7143 .30902 L
.71553 .30902 L
.71665 .30902 L
.71797 .30902 L
.71866 .30902 L
.7194 .30902 L
.72011 .30902 L
.72075 .30902 L
.72201 .30902 L
.72269 .30902 L
.72341 .30902 L
.72469 .30902 L
Mistroke
.7254 .30902 L
.72607 .30902 L
.7268 .30902 L
.72759 .30902 L
.72826 .30902 L
.729 .30902 L
.72969 .30902 L
.73034 .30902 L
.73155 .30902 L
.73284 .30902 L
.73398 .30902 L
.73522 .30902 L
.73652 .30902 L
.73773 .30902 L
.73886 .30902 L
.7399 .30902 L
.74109 .30902 L
.74221 .30902 L
.74343 .30902 L
.74473 .30902 L
.74584 .30902 L
.74706 .30902 L
.74836 .30902 L
.7491 .30902 L
.74977 .30902 L
.75107 .30902 L
.75231 .30902 L
.75346 .30902 L
.75451 .30902 L
.75571 .30902 L
.75685 .30902 L
.7579 .30902 L
.75887 .30902 L
.75992 .30902 L
.76105 .30902 L
.7622 .30902 L
.76327 .30902 L
.76454 .30902 L
.76569 .30902 L
.7669 .30902 L
.76821 .30902 L
.76945 .30902 L
.77059 .30902 L
.77177 .30902 L
.77301 .30902 L
.77408 .30902 L
.77524 .30902 L
.77649 .30902 L
.77719 .30902 L
.77783 .30902 L
Mistroke
.77907 .30902 L
.78024 .30902 L
.78134 .30902 L
.7825 .30902 L
.78349 .30902 L
.78458 .30902 L
.78576 .30902 L
.78701 .30902 L
.78929 .30902 L
.8099 .30902 L
.85123 .30902 L
.89103 .30902 L
.92933 .30902 L
.97007 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.23) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0004<ol000@0
I_lco`0co`000009<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007
<ol000<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo01?oool0017oool00`0003?o
03?o000_<ol000<0000co`0co`0063?o000306Ko<ol0<ol001@co`000`0003?o03?o000^<ol000<0
000co`0co`00;c?o00030000oooooooo02ooool00`000?ooooooo`0Coooo000AooooCC?o000306Ko
<ol0<ol007Lco`000`000?ooooooo`15oooo000AooooCC?o000306Ko<ol0<ol007Lco`000`000?oo
ooooo`15oooo000AooooCC?o000306Ko<ol0<ol007Lco`000`000?ooooooo`15oooo000AooooCC?o
000306Ko<ol0<ol007Lco`000`000?ooooooo`15oooo000AooooCC?o000306Ko<ol0<ol007Lco`00
0`000?ooooooo`15oooo000Aoooo1P1VodLco`000`1Voc?o03?o001g<ol00P0004Koool0017oool6
<ol02P1Vocdco`000`1Voc?o03?o001g<ol000<0003oooooool0AOooo`004Ooooa0co`0806Ko=C?o
000306Ko<ol0<ol007Lco`000`000?ooooooo`15oooo000Aoooo63?o00H0I_l_<ol000<0I_lco`0c
o`00Mc?o00030000oooooooo04Goool0017ooolN<ol01@1VobXco`000`1Voc?o03?o001g<ol000<0
003oooooool0AOooo`004Oooob<co`0506Ko9C?o000306Ko<ol0<ol007Lco`000`000?ooooooo`15
oooo000Aoooo:3?o00D0I_lP<ol000<0I_lco`0co`00Mc?o00030000oooooooo04Goool0017oool]
<ol01@1Voa/co`000`1Voc?o03?o001g<ol000<0003oooooool0AOooo`004Oooo`80000`<ol01@1V
oaHco`000`1Voc?o03?o001g<ol00P0004Koool001?oool20000<c?o00D0I_lA<ol000<0I_lco`0c
o`00Mc?o00030000oooooooo04Goool001Goool20000=S?o00@0I_l=<ol000<0I_lco`0co`00Mc?o
00030000oooooooo04Goool001Ooool20000>3?o00<0I_l:<ol000<0I_lco`0co`00Mc?o00030000
oooooooo04Goool001Woool20000>C?o0080I_l8<ol000<0I_lco`0co`00Mc?o00030000oooooooo
04Goool001_oool20000>C?o00D0I_l3<ol000<0I_lco`0co`00Mc?o00030000oooooooo04Goool0
01goool20000?3?o00@0I_mi<ol000<0003oooooool0AOooo`007oooo`030000<ol0<ol003`co`00
0ol0VC?o03?o001g<ol000<0003oooooool0AOooo`008?ooo`030000<ol0<ol003/co`000ol0VC?o
03?o001g<ol00P0004Koool0027oool20000>c?o0003o`2I<ol0<ol007Lco`000`000?ooooooo`15
oooo000Soooo00<0000co`0co`00>3?o0003o`2I<ol0<ol007Lco`000`000?ooooooo`15oooo000T
oooo0P0003Pco`000ol0VC?o03?o001g<ol000<0003oooooool0AOooo`009_ooo`030000<ol0<ol0
03Dco`000ol0VC?o03?o001g<ol000<0003oooooool0AOooo`009oooo`030000<ol0<ol003@co`00
0ol0VC?o03?o001g<ol000<0003oooooool0AOooo`00:?ooo`030000<ol0<ol003<co`000ol0VC?o
03?o001N<ol00P0000@co`02000013?o00800003<ol0100000@co`000`000?ooooooo`15oooo000Y
oooo00<0000co`0co`00<S?o0003o`2I<ol0<ol005dco`00100003?o03?o000000Pco`00100003?o
03?o0000008co`000`0003?o03?o0005<ol000<0003oooooool0AOooo`00:_ooo`030000<ol0<ol0
034co`000ol0VC?o03?o001M<ol000@0000co`0co`000008<ol000@0000co`0co`000003<ol000<0
000co`0co`0013?o00<00015oooo000[oooo0P00034co`000ol0VC?o03?o001M<ol000@0000co`0c
o`000008<ol000@0000co`0co`000004<ol000<0000co`0co`000c?o00030000oooooooo04Goool0
02goool00`0003?o03?o000^<ol000?o09Tco`0co`00GC?o00040000<ol0<ol0000023?o00040000
<ol0<ol000000S?o00040000<ol0<ol0000013?o00030000oooooooo04Goool002koool00`0003?o
03?o000]<ol000?o09Tco`0co`00GS?o0080000:<ol00P0000@co`0200001C?o00030000oooooooo
04Goool002ooool00`0003?o03?o000/<ol000?o09Tco`0co`00Mc?o00030000oooooooo04Goool0
033oool00`0003?o03?o000[<ol000?o09Tco`0co`00Mc?o00030000oooooooo04Goool0037oool0
0`0003?o03?o000Z<ol000?o09Tco`0co`00Mc?o00030000oooooooo04Goool003;oool00`0003?o
03?o000Y<ol000?o09Tco`0co`00Mc?o00030000oooooooo04Goool003?oool00`0003?o03?o000X
<ol000?o09Tco`0co`00Mc?o00800016oooo000coooo00<0000co`0co`00:3?o0003o`2I<ol0<ol0
07Lco`000`000?ooooooo`15oooo000doooo00<0000co`0co`009c?o0003o`2I<ol0<ol007Lco`00
0`000?ooooooo`15oooo000eoooo00<0000co`0co`009S?o0003o`2I<ol0<ol007Lco`000`000?oo
ooooo`15oooo000foooo00<0000co`0co`009C?o0003o`2I<ol0<ol007Lco`000`000?ooooooo`15
oooo000goooo00<0000co`0co`0093?o0003o`2I<ol0<ol007Lco`000`000?ooooooo`15oooo000h
oooo00<0000co`0co`008c?o0003o`2I<ol0<ol007Lco`000`000?ooooooo`15oooo000hoooo00<0
000co`0co`008c?o0003o`2I<ol0<ol007Lco`000`000?ooooooo`15oooo000ioooo00<0000co`0c
o`008S?o0003o`2I<ol0<ol007Lco`020000A_ooo`00>_ooo`030000<ol0<ol0024co`000ol0VC?o
03?o001g<ol000<0003oooooool0AOooo`00>oooo`030000<ol0<ol0020co`000ol0VC?o03?o001g
<ol000<0003oooooool0AOooo`00??ooo`030000<ol0<ol001lco`000ol0VC?o03?o001g<ol000<0
003oooooool0AOooo`00??ooo`030000<ol0<ol001lco`000ol0VC?o03?o001g<ol000<0003ooooo
ool0AOooo`00?Oooo`030000<ol0<ol001hco`000ol0VC?o03?o001g<ol000<0003oooooool0AOoo
o`00?Oooo`030000<ol0<ol001hco`000ol0VC?o03?o001g<ol000<0003oooooool0AOooo`00?_oo
o`030000<ol0<ol001dco`000ol0VC?o03?o001g<ol000<0003oooooool0AOooo`00?_ooo`030000
<ol0<ol001dco`000ol0VC?o03?o001g<ol000<0003oooooool0AOooo`00?oooo`030000<ol0<ol0
01`co`000ol0VC?o03?o001g<ol00P0004Koool003ooool00`0003?o03?o000L<ol000?o09Tco`0c
o`00Mc?o00030000oooooooo04Goool0043oool00`0003?o03?o000K<ol000?o09Tco`0co`00Mc?o
00030000oooooooo04Goool0047oool00`0003?o03?o000J<ol000?o09Tco`0co`00Mc?o00030000
oooooooo04Goool0047oool00`0003?o03?o000J<ol000?o09Tco`0co`00Mc?o00030000oooooooo
04Goool004;oool00`0003?o03?o000I<ol000?o09Tco`0co`00Mc?o00030000oooooooo04Goool0
04;oool00`0003?o03?o000I<ol000?o09Tco`0co`00GS?o00800004<ol00P0000@co`0200001C?o
00<00003<ol000<0003oooooool0AOooo`00@oooo`030000<ol0<ol001Pco`000ol0VC?o03?o001M
<ol000@0000co`0co`000008<ol000@0000co`0co`000005<ol000<0000co`0co`000S?o00030000
oooooooo04Goool004?oool00`0003?o03?o000H<ol000?o09Tco`0co`00GC?o00040000<ol0<ol0
000023?o00040000<ol0<ol000000S?o00D00003<ol00`0004Goool004Coool00`0003?o03?o000G
<ol000?o09Tco`0co`00GC?o00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o00040000
<ol0<ol0000013?o00030000oooooooo04Goool004Coool00`0003?o03?o000G<ol000?o09Tco`0c
o`00GC?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000<ol0000000@co`00
0`000?ooooooo`15oooo0015oooo00<0000co`0co`005S?o0003o`2I<ol0<ol005hco`0200002S?o
00800005<ol00P0000@co`000`000?ooooooo`15oooo0015oooo00<0000co`0co`005S?o0003o`2I
<ol0<ol007Lco`000`000?ooooooo`15oooo0016oooo00<0000co`0co`005C?o0003o`2I<ol0<ol0
07Lco`000`000?ooooooo`15oooo0016oooo00<0000co`0co`005C?o0003o`2I<ol0<ol007Lco`00
0`000?ooooooo`15oooo0017oooo00<0000co`0co`0053?o0003o`2I<ol0<ol007Lco`000`000?oo
ooooo`15oooo0017oooo00<0000co`0co`0053?o0003o`2I<ol0<ol007Lco`020000A_ooo`00B?oo
o`030000<ol0<ol001<co`000ol0VC?o03?o001g<ol000<0003oooooool0AOooo`00B?ooo`030000
<ol0<ol001<co`000ol0VC?o03?o001g<ol000<0003oooooool0AOooo`00BOooo`030000<ol0<ol0
018co`000ol0VC?o03?o001g<ol000<0003oooooool0AOooo`00BOooo`030000<ol0<ol0018co`00
0ol0VC?o03?o001g<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol0014co`000ol0VC?o
03?o001g<ol000<0003oooooool0AOooo`00B_ooo`030000<ol0<ol0014co`000ol0VC?o03?o001g
<ol000<0003oooooool0AOooo`00Boooo`030000<ol0<ol0010co`000ol0VC?o03?o001g<ol000<0
003oooooool0AOooo`00Boooo`030000<ol0<ol0010co`000ol0VC?o03?o001g<ol00P0004Koool0
04cooon<<ol0B?ooo`00C?oooh`co`18oooo001<ooooS3?o04Soool004gooon;<ol0B?ooo`00COoo
oh/co`18oooo001>oooo9S?o00030000<ol0<ol002lco`000`0003?o03?o000_<ol0B?ooo`00C_oo
obDco`000`0003?o03?o0008<ol000<0000co`0co`009S?o00030000<ol0<ol002hco`18oooo001?
oooo93?o00030000<ol0<ol0008co`02000013?o00030000<ol0<ol000hco`02000013?o00800003
<ol0100000<co`02000013?o00030000<ol0<ol002hco`18oooo001?oooo93?o00050000<ol0<ol0
<ol00000008co`000`0003?o03?o0002<ol000<0000co`0co`001C?o00@00003<ol000@0000co`0c
o`000008<ol000<0000co`0co`000c?o00040000<ol0<ol000000c?o00030000<ol0<ol002hco`18
oooo001?oooo8c?o00030000<ol0<ol0008co`000`0003?o03?o000D<ol000@0000co`0co`000009
<ol000<0000co`0co`0013?o00030000<ol0<ol000<co`000`0003?o03?o000]<ol0B?ooo`00D?oo
ob<co`000`0003?o03?o000500004c?o00040000<ol0<ol000002S?o00030000<ol0<ol000@co`00
1@0003?o03?o03?o0000000`<ol0B?ooo`00D?ooob<co`001@0003?o03?o03?o0000000F<ol000@0
000co`0co`000008<ol000@0000co`0co`000002<ol000@0000co`0co`000003<ol000<0000co`0c
o`00;S?o04Soool0053ooolT<ol000<0000co`0co`0063?o0080000:<ol00P0000@co`0200000c?o
00030000<ol0<ol002lco`18oooo001AooooQc?o04Soool0057ooon7<ol0B?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.22) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.30316 .30902 L
.31304 .30902 L
.31574 .30902 L
.31723 .30902 L
.31865 .30902 L
.31997 .30902 L
.32071 .30902 L
s
.32071 .30902 m
.32072 .61803 L
s
0 .4 1 r
.02381 .33656 m
.06244 .34082 L
.10458 .34622 L
.14415 .35212 L
.18221 .35868 L
.22272 .36678 L
.26171 .37584 L
.28158 .38099 L
.29205 .38387 L
.30316 .38705 L
.31304 .38999 L
.31574 .39082 L
.31723 .39128 L
.31865 .39172 L
.31997 .39213 L
.32071 .39236 L
.3214 .30902 L
.32262 .30902 L
.32392 .30902 L
.32521 .30902 L
.3264 .30902 L
.32771 .30902 L
.32838 .30902 L
.32909 .30902 L
.3303 .30902 L
.33142 .30902 L
.3321 .30902 L
.33275 .30902 L
.33397 .30902 L
.33507 .30902 L
.33624 .30902 L
.33724 .30902 L
.33834 .30902 L
.33951 .30902 L
.34079 .30902 L
.34199 .30902 L
.34309 .30902 L
.34436 .30902 L
.34557 .30902 L
.34665 .30902 L
.34782 .30902 L
.3491 .30902 L
.34975 .30902 L
.35046 .30902 L
.35171 .30902 L
.35289 .30902 L
.35407 .30902 L
.35519 .30902 L
.35619 .30902 L
.35729 .30902 L
Mistroke
.35847 .30902 L
.35974 .30902 L
.36093 .30902 L
.36201 .30902 L
.36331 .30902 L
.36396 .30902 L
.36468 .30902 L
.36595 .30902 L
.36714 .30902 L
.36786 .30902 L
.36854 .30902 L
.36981 .30902 L
.37052 .30902 L
.37118 .30902 L
.37191 .30902 L
.37267 .30902 L
.37386 .30902 L
.37514 .30902 L
.37634 .30902 L
.37745 .30902 L
.37809 .30902 L
.37878 .30902 L
.38001 .30902 L
.3813 .30902 L
.38204 .30902 L
.38271 .30902 L
.38391 .30902 L
.38503 .30902 L
.38626 .30902 L
.38757 .30902 L
.38823 .30902 L
.38895 .30902 L
.39026 .30902 L
.39154 .30902 L
.39272 .30902 L
.39381 .30902 L
.39484 .30902 L
.39606 .30902 L
.39718 .30902 L
.3983 .30902 L
.39947 .30902 L
.40064 .30902 L
.40193 .30902 L
.40261 .30902 L
.40333 .30902 L
.40402 .30902 L
.40466 .30902 L
.40586 .30902 L
.40714 .30902 L
.4078 .30902 L
Mistroke
.40851 .30902 L
.40979 .30902 L
.41057 .30902 L
.41132 .30902 L
.41198 .30902 L
.41271 .30902 L
.41403 .30902 L
.41523 .30902 L
.41589 .30902 L
.41661 .30902 L
.41791 .30902 L
.41914 .30902 L
.42043 .30902 L
.42153 .30902 L
.42274 .30902 L
.42405 .30902 L
.42527 .30902 L
.42654 .30902 L
.42722 .30902 L
.42795 .30902 L
.4287 .30902 L
.42949 .30902 L
.43016 .30902 L
.43089 .30902 L
.43157 .30902 L
.4323 .30902 L
.43361 .30902 L
.43431 .30902 L
.43494 .30902 L
.43565 .30902 L
.43639 .30902 L
.43763 .30902 L
.43834 .30902 L
.43901 .30902 L
.44024 .30902 L
.44137 .30902 L
.44267 .30902 L
.4439 .30902 L
.44512 .30902 L
.44622 .30902 L
.4475 .30902 L
.44869 .30902 L
.44981 .30902 L
.45083 .30902 L
.45195 .30902 L
.45313 .30902 L
.45433 .30902 L
.45562 .30902 L
.45683 .30902 L
.45793 .30902 L
Mistroke
.45923 .30902 L
.45996 .30902 L
.46063 .30902 L
.46187 .30902 L
.46319 .30902 L
.46442 .30902 L
.46559 .30902 L
.46664 .30902 L
.46779 .30902 L
.46904 .30902 L
.46973 .30902 L
.47036 .30902 L
.47159 .30902 L
.47275 .30902 L
.47384 .30902 L
.47499 .30902 L
.47597 .30902 L
.47705 .30902 L
.47821 .30902 L
.47946 .30902 L
.48064 .30902 L
.48171 .30902 L
.48297 .30902 L
.48361 .30902 L
.48432 .30902 L
.48556 .30902 L
.48673 .30902 L
.48739 .30902 L
.4881 .30902 L
.48935 .30902 L
.49005 .30902 L
.49071 .30902 L
.49142 .30902 L
.49219 .30902 L
.49347 .30902 L
.49419 .30902 L
.49486 .30902 L
.49609 .30902 L
.49739 .30902 L
.49855 .30902 L
.49964 .30902 L
.50083 .30902 L
.50212 .30902 L
.5028 .30902 L
.50345 .30902 L
.50466 .30902 L
.50596 .30902 L
.5067 .30902 L
.50737 .30902 L
.5085 .30902 L
Mistroke
.50974 .30902 L
.51103 .30902 L
.51224 .30902 L
.51293 .30902 L
.51367 .30902 L
.51438 .30902 L
.51503 .30902 L
.51626 .30902 L
.51757 .30902 L
.51825 .30902 L
.51897 .30902 L
.52029 .30902 L
.52105 .30902 L
.52185 .30902 L
.52253 .30902 L
.52328 .30902 L
.52393 .30902 L
.52464 .30902 L
.52592 .30902 L
.52707 .30902 L
.52832 .30902 L
.52902 .30902 L
.52968 .30902 L
.53037 .30902 L
.53112 .30902 L
.53181 .30902 L
.53247 .30902 L
.5337 .30902 L
.53486 .30902 L
.5361 .30902 L
.53716 .30902 L
.53833 .30902 L
.53958 .30902 L
.54029 .30902 L
.54093 .30902 L
.54213 .30902 L
.54338 .30902 L
.54461 .30902 L
.54526 .30902 L
.54594 .30902 L
.5472 .30902 L
.54837 .30902 L
.54948 .30902 L
.55053 .30902 L
.55167 .30902 L
.5529 .30902 L
.55421 .30902 L
.55495 .30902 L
.55563 .30902 L
.55689 .30902 L
Mistroke
.55759 .30902 L
.55822 .30902 L
.55943 .30902 L
.56073 .30902 L
.56196 .30902 L
.56309 .30902 L
.56415 .30902 L
.56529 .30902 L
.56636 .30902 L
.56734 .30902 L
.56849 .30902 L
.56974 .30902 L
.57092 .30902 L
.57202 .30902 L
.57314 .30902 L
.57419 .30902 L
.57534 .30902 L
.57659 .30902 L
.57782 .30902 L
.57912 .30902 L
.58023 .30902 L
.58144 .30902 L
.58276 .30902 L
.58398 .30902 L
.58462 .30902 L
.58532 .30902 L
.58673 .30902 L
.58798 .30902 L
.58867 .30902 L
.58931 .30902 L
.59055 .30902 L
.59172 .30902 L
.59285 .30902 L
.59404 .30902 L
.59517 .30902 L
.59619 .30902 L
.5974 .30902 L
.5987 .30902 L
.59993 .30902 L
.60106 .30902 L
.60228 .30902 L
.60358 .30902 L
.60481 .30902 L
.60593 .30902 L
.60724 .30902 L
.60798 .30902 L
.60867 .30902 L
.60931 .30902 L
.61 .30902 L
.61126 .30902 L
Mistroke
.61255 .30902 L
.61374 .30902 L
.61441 .30902 L
.61514 .30902 L
.61583 .30902 L
.61648 .30902 L
.6172 .30902 L
.61788 .30902 L
.61916 .30902 L
.61982 .30902 L
.62053 .30902 L
.6213 .30902 L
.62201 .30902 L
.62323 .30902 L
.62392 .30902 L
.62455 .30902 L
.62572 .30902 L
.62696 .30902 L
.62807 .30902 L
.62911 .30902 L
.63025 .30902 L
.63148 .30902 L
.63271 .30902 L
.63341 .30902 L
.63406 .30902 L
.63537 .30902 L
.63611 .30902 L
.63677 .30902 L
.63797 .30902 L
.63927 .30902 L
.6405 .30902 L
.64163 .30902 L
.64269 .30902 L
.64382 .30902 L
.64489 .30902 L
.64587 .30902 L
.64701 .30902 L
.64826 .30902 L
.64944 .30902 L
.65053 .30902 L
.65177 .30902 L
.65293 .30902 L
.65397 .30902 L
.6551 .30902 L
.65633 .30902 L
.65763 .30902 L
.65874 .30902 L
.65996 .30902 L
.66127 .30902 L
.66248 .30902 L
Mistroke
.66311 .30902 L
.6638 .30902 L
.66453 .30902 L
.66521 .30902 L
.66646 .30902 L
.6676 .30902 L
.66886 .30902 L
.67018 .30902 L
.67129 .30902 L
.67233 .30902 L
.67353 .30902 L
.67463 .30902 L
.67584 .30902 L
.67715 .30902 L
.67837 .30902 L
.67949 .30902 L
.68474 .30902 L
.68966 .30902 L
.69092 .30902 L
.69213 .30902 L
.69279 .30902 L
.69351 .30902 L
.69478 .30902 L
.6962 .30902 L
.69699 .30902 L
.6977 .30902 L
.69837 .30902 L
.6991 .30902 L
.70041 .30902 L
.70166 .30902 L
.7028 .30902 L
.70411 .30902 L
.70535 .30902 L
.7065 .30902 L
.70756 .30902 L
.70872 .30902 L
.70996 .30902 L
.71119 .30902 L
.71189 .30902 L
.71252 .30902 L
.71376 .30902 L
.71493 .30902 L
.71559 .30902 L
.71629 .30902 L
.71755 .30902 L
.71832 .30902 L
.71905 .30902 L
.7197 .30902 L
.72041 .30902 L
.72173 .30902 L
Mistroke
.72296 .30902 L
.72366 .30902 L
.7243 .30902 L
.72505 .30902 L
.72575 .30902 L
.72643 .30902 L
.72715 .30902 L
.72845 .30902 L
.72912 .30902 L
.72985 .30902 L
.73064 .30902 L
.73139 .30902 L
.73262 .30902 L
.73331 .30902 L
.73396 .30902 L
.73527 .30902 L
.736 .30902 L
.73666 .30902 L
.73785 .30902 L
.73915 .30902 L
.74037 .30902 L
.74149 .30902 L
.74275 .30902 L
.74394 .30902 L
.745 .30902 L
.74617 .30902 L
.74743 .30902 L
.74813 .30902 L
.74877 .30902 L
.75002 .30902 L
.75119 .30902 L
.75229 .30902 L
.75346 .30902 L
.75445 .30902 L
.75555 .30902 L
.75672 .30902 L
.75798 .30902 L
.75917 .30902 L
.76025 .30902 L
.76154 .30902 L
.76218 .30902 L
.7629 .30902 L
.76416 .30902 L
.76534 .30902 L
.76601 .30902 L
.76673 .30902 L
.768 .30902 L
.76871 .30902 L
.76938 .30902 L
.77016 .30902 L
Mistroke
.77086 .30902 L
.77205 .30902 L
.77334 .30902 L
.77455 .30902 L
.77565 .30902 L
.77687 .30902 L
.77756 .30902 L
.7782 .30902 L
.7795 .30902 L
.78023 .30902 L
.78089 .30902 L
.78208 .30902 L
.78337 .30902 L
.78458 .30902 L
.78569 .30902 L
.78687 .30902 L
.78811 .30902 L
.79079 .30902 L
.79995 .30902 L
.8207 .30902 L
.85877 .30902 L
.8993 .30902 L
.93831 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.22) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0005<ol000<0
I_lco`0000002C?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001c?o00030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`0Coooo000Aoooo00<0000co`0c
o`00;c?o00030000<ol0<ol001Tco`000`1Voc?o03?o000C<ol000<0000co`0co`00;S?o00030000
<ol0<ol002lco`000`000?ooooooo`0_oooo00<0003oooooool04oooo`004Oooodhco`000`1Voc?o
03?o001f<ol000<0003oooooool0AOooo`004Oooodhco`000`1Voc?o03?o001f<ol000<0003ooooo
ool0AOooo`004Oooodhco`000`1Voc?o03?o001f<ol000<0003oooooool0AOooo`004Oooodhco`00
0`1Voc?o03?o001f<ol000<0003oooooool0AOooo`004Oooo`H0I_m8<ol000<0I_lco`0co`00MS?o
00030000oooooooo04Goool0017oool6<ol0201Vod0co`000`1Voc?o03?o001f<ol00P0004Koool0
017oool><ol01@1Voc/co`000`1Voc?o03?o001f<ol000<0003oooooool0AOooo`004Ooooa<co`08
06Ko<c?o000306Ko<ol0<ol007Hco`000`000?ooooooo`15oooo000Aoooo6c?o00P0I_l[<ol000<0
I_lco`0co`00MS?o00030000oooooooo04Goool0017ooolS<ol01@1VobHco`000`1Voc?o03?o001f
<ol000<0003oooooool0AOooo`004OooobPco`0506Ko8C?o000306Ko<ol0<ol007Hco`000`000?oo
ooooo`15oooo000Aoooo;C?o00D0I_lL<ol000<0I_lco`0co`00MS?o00030000oooooooo04Goool0
017ooolb<ol0101VoaPco`000`1Voc?o03?o001f<ol000<0003oooooool0AOooo`004Oooo`80000d
<ol00`1VoaDco`000`1Voc?o03?o001f<ol00P0004Koool001?oool20000=C?o00@0I_lA<ol000<0
I_lco`0co`00MS?o00030000oooooooo04Goool001Goool20000=c?o00@0I_l=<ol000<0I_lco`0c
o`00MS?o00030000oooooooo04Goool001Ooool20000>C?o00@0I_l9<ol000<0I_lco`0co`00MS?o
00030000oooooooo04Goool001Woool20000>c?o00H0I_l3<ol000<0I_lco`0co`00MS?o00030000
oooooooo04Goool001_oool20000?c?o00@0I_mh<ol000<0003oooooool0AOooo`007Oooo`80000o
<ol00P1VogPco`000`000?ooooooo`15oooo000Ooooo00<0000co`0co`00?C?o0003o`2I<ol0<ol0
07Hco`000`000?ooooooo`15oooo000Poooo00<0000co`0co`00?3?o0003o`2I<ol0<ol007Hco`02
0000A_ooo`008Oooo`80000l<ol000?o09Tco`0co`00MS?o00030000oooooooo04Goool002?oool0
0`0003?o03?o000i<ol000?o09Tco`0co`00MS?o00030000oooooooo04Goool002Coool20000>C?o
0003o`2I<ol0<ol007Hco`000`000?ooooooo`15oooo000Voooo00<0000co`0co`00=S?o0003o`2I
<ol0<ol007Hco`000`000?ooooooo`15oooo000Woooo00<0000co`0co`00=C?o0003o`2I<ol0<ol0
07Hco`000`000?ooooooo`15oooo000Xoooo00<0000co`0co`00=3?o0003o`2I<ol0<ol005dco`02
000013?o00800004<ol00P0000<co`04000013?o00030000oooooooo04Goool002Woool00`0003?o
03?o000c<ol000?o09Tco`0co`00G3?o00040000<ol0<ol0000023?o00040000<ol0<ol000000S?o
00030000<ol0<ol000Dco`000`000?ooooooo`15oooo000Zoooo00<0000co`0co`00<S?o0003o`2I
<ol0<ol005`co`00100003?o03?o000000Pco`00100003?o03?o000000<co`000`0003?o03?o0004
<ol00`0004Goool002_oool20000<S?o0003o`2I<ol0<ol005`co`00100003?o03?o000000Pco`00
100003?o03?o000000@co`000`0003?o03?o0003<ol000<0003oooooool0AOooo`00;Oooo`030000
<ol0<ol002lco`000ol0VC?o03?o001L<ol000@0000co`0co`000008<ol000@0000co`0co`000002
<ol000@0000co`0co`000004<ol000<0003oooooool0AOooo`00;_ooo`030000<ol0<ol002hco`00
0ol0VC?o03?o001M<ol00P0000Xco`02000013?o00800005<ol000<0003oooooool0AOooo`00;ooo
o`030000<ol0<ol002dco`000ol0VC?o03?o001f<ol000<0003oooooool0AOooo`00<?ooo`030000
<ol0<ol002`co`000ol0VC?o03?o001f<ol000<0003oooooool0AOooo`00<Oooo`030000<ol0<ol0
02/co`000ol0VC?o03?o001f<ol000<0003oooooool0AOooo`00<_ooo`030000<ol0<ol002Xco`00
0ol0VC?o03?o001f<ol000<0003oooooool0AOooo`00<oooo`030000<ol0<ol002Tco`000ol0VC?o
03?o001f<ol00P0004Koool003?oool00`0003?o03?o000Y<ol000?o09Tco`0co`00MS?o00030000
oooooooo04Goool003Coool00`0003?o03?o000X<ol000?o09Tco`0co`00MS?o00030000oooooooo
04Goool003Goool00`0003?o03?o000W<ol000?o09Tco`0co`00MS?o00030000oooooooo04Goool0
03Koool00`0003?o03?o000V<ol000?o09Tco`0co`00MS?o00030000oooooooo04Goool003Ooool0
0`0003?o03?o000U<ol000?o09Tco`0co`00MS?o00030000oooooooo04Goool003Soool00`0003?o
03?o000T<ol000?o09Tco`0co`00MS?o00030000oooooooo04Goool003Soool00`0003?o03?o000T
<ol000?o09Tco`0co`00MS?o00030000oooooooo04Goool003Woool00`0003?o03?o000S<ol000?o
09Tco`0co`00MS?o00800016oooo000joooo00<0000co`0co`008S?o0003o`2I<ol0<ol007Hco`00
0`000?ooooooo`15oooo000koooo00<0000co`0co`008C?o0003o`2I<ol0<ol007Hco`000`000?oo
ooooo`15oooo000loooo00<0000co`0co`0083?o0003o`2I<ol0<ol007Hco`000`000?ooooooo`15
oooo000loooo00<0000co`0co`0083?o0003o`2I<ol0<ol007Hco`000`000?ooooooo`15oooo000m
oooo00<0000co`0co`007c?o0003o`2I<ol0<ol007Hco`000`000?ooooooo`15oooo000moooo00<0
000co`0co`007c?o0003o`2I<ol0<ol007Hco`000`000?ooooooo`15oooo000noooo00<0000co`0c
o`007S?o0003o`2I<ol0<ol007Hco`000`000?ooooooo`15oooo000noooo00<0000co`0co`007S?o
0003o`2I<ol0<ol007Hco`000`000?ooooooo`15oooo000ooooo00<0000co`0co`007C?o0003o`2I
<ol0<ol007Hco`020000A_ooo`00?oooo`030000<ol0<ol001dco`000ol0VC?o03?o001f<ol000<0
003oooooool0AOooo`00@?ooo`030000<ol0<ol001`co`000ol0VC?o03?o001f<ol000<0003ooooo
ool0AOooo`00@Oooo`030000<ol0<ol001/co`000ol0VC?o03?o001f<ol000<0003oooooool0AOoo
o`00@Oooo`030000<ol0<ol001/co`000ol0VC?o03?o001f<ol000<0003oooooool0AOooo`00@_oo
o`030000<ol0<ol001Xco`000ol0VC?o03?o001f<ol000<0003oooooool0AOooo`00@_ooo`030000
<ol0<ol001Xco`000ol0VC?o03?o001M<ol00P0000@co`02000013?o00800005<ol00`0000<co`00
0`000?ooooooo`15oooo0013oooo00<0000co`0co`006C?o0003o`2I<ol0<ol005`co`00100003?o
03?o000000Pco`00100003?o03?o000000Dco`000`0003?o03?o0002<ol000<0003oooooool0AOoo
o`00@oooo`030000<ol0<ol001Tco`000ol0VC?o03?o001L<ol000@0000co`0co`000008<ol000@0
000co`0co`000002<ol01@0000<co`030000AOooo`00A?ooo`030000<ol0<ol001Pco`000ol0VC?o
03?o001L<ol000@0000co`0co`000008<ol000@0000co`0co`000002<ol000@0000co`0co`000004
<ol000<0003oooooool0AOooo`00A?ooo`030000<ol0<ol001Pco`000ol0VC?o03?o001L<ol000@0
000co`0co`000008<ol000@0000co`0co`000003<ol000<0000co`00000013?o00030000oooooooo
04Goool004Goool00`0003?o03?o000G<ol000?o09Tco`0co`00GC?o0080000:<ol00P0000Dco`02
000013?o00030000oooooooo04Goool004Goool00`0003?o03?o000G<ol000?o09Tco`0co`00MS?o
00030000oooooooo04Goool004Koool00`0003?o03?o000F<ol000?o09Tco`0co`00MS?o00030000
oooooooo04Goool004Koool00`0003?o03?o000F<ol000?o09Tco`0co`00MS?o00030000oooooooo
04Goool004Ooool00`0003?o03?o000E<ol000?o09Tco`0co`00MS?o00030000oooooooo04Goool0
04Ooool00`0003?o03?o000E<ol000?o09Tco`0co`00MS?o00800016oooo0018oooo00<0000co`0c
o`0053?o0003o`2I<ol0<ol007Hco`000`000?ooooooo`15oooo0018oooo00<0000co`0co`0053?o
0003o`2I<ol0<ol007Hco`000`000?ooooooo`15oooo0019oooo00<0000co`0co`004c?o0003o`2I
<ol0<ol007Hco`000`000?ooooooo`15oooo0019oooo00<0000co`0co`004c?o0003o`2I<ol0<ol0
07Hco`000`000?ooooooo`15oooo001:oooo00<0000co`0co`004S?o0003o`2I<ol0<ol007Hco`00
0`000?ooooooo`15oooo001:oooo00<0000co`0co`004S?o0003o`2I<ol0<ol007Hco`000`000?oo
ooooo`15oooo001;oooo00<0000co`0co`004C?o0003o`2I<ol0<ol007Hco`000`000?ooooooo`15
oooo001;oooo00<0000co`0co`004C?o0003o`2I<ol0<ol007Hco`020000A_ooo`00C?oooh`co`18
oooo001<ooooS3?o04Soool004cooon<<ol0B?ooo`00COoooh/co`18oooo001=ooooRc?o04Soool0
04kooolV<ol000<0000co`0co`00;c?o00030000<ol0<ol002lco`18oooo001>oooo9C?o00030000
<ol0<ol000Pco`000`0003?o03?o000V<ol000<0000co`0co`00;S?o04Soool004oooolT<ol000<0
000co`0co`000S?o00800004<ol000<0000co`0co`003S?o00800004<ol00P0000<co`0400000S?o
00@00003<ol000<0000co`0co`00;S?o04Soool004oooolT<ol000D0000co`0co`0co`0000000S?o
00030000<ol0<ol0008co`000`0003?o03?o0005<ol0100000<co`00100003?o03?o000000Pco`00
0`0003?o03?o0003<ol000<0000co`0co`0013?o00030000<ol0<ol002hco`18oooo001?oooo8c?o
00030000<ol0<ol0008co`000`0003?o03?o000D<ol000@0000co`0co`000009<ol000<0000co`0c
o`000c?o00030000<ol0<ol000@co`000`0003?o03?o000]<ol0B?ooo`00D?ooob<co`000`0003?o
03?o000500004c?o00040000<ol0<ol000002S?o00030000<ol0<ol000<co`000`0003?o03?o0002
<ol000<0000co`0co`00;S?o04Soool0053ooolS<ol000D0000co`0co`0co`0000005S?o00040000
<ol0<ol0000023?o00040000<ol0<ol000000S?o00040000<ol0<ol000000c?o00030000<ol0<ol0
02hco`18oooo001@oooo93?o00030000<ol0<ol001Pco`0200002S?o00800004<ol00P0000<co`00
0`0003?o03?o000_<ol0B?ooo`00DOooohLco`18oooo001AooooQc?o04Soool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.21) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.31875 .30902 L
.32145 .30902 L
.32263 .30902 L
.32392 .30902 L
s
.32392 .30902 m
.32392 .61803 L
s
0 .4 1 r
.02381 .33528 m
.06244 .33933 L
.10458 .34447 L
.14415 .3501 L
.18221 .35636 L
.22272 .36408 L
.26171 .37271 L
.28158 .37762 L
.30316 .3834 L
.31323 .38626 L
.31875 .38788 L
.32145 .38868 L
.32263 .38903 L
.32392 .38942 L
.32509 .30902 L
.32617 .30902 L
.32721 .30902 L
.32831 .30902 L
.32959 .30902 L
.33079 .30902 L
.33187 .30902 L
.33304 .30902 L
.33425 .30902 L
.33558 .30902 L
.33625 .30902 L
.33697 .30902 L
.33827 .30902 L
.33956 .30902 L
.34079 .30902 L
.34189 .30902 L
.34309 .30902 L
.3443 .30902 L
.34542 .30902 L
.34664 .30902 L
.34793 .30902 L
.34906 .30902 L
.35011 .30902 L
.35126 .30902 L
.35248 .30902 L
.35318 .30902 L
.35383 .30902 L
.35453 .30902 L
.35528 .30902 L
.35654 .30902 L
.35725 .30902 L
.35792 .30902 L
.35916 .30902 L
.3603 .30902 L
.36161 .30902 L
.36286 .30902 L
Mistroke
.36354 .30902 L
.36419 .30902 L
.36539 .30902 L
.36668 .30902 L
.36741 .30902 L
.36807 .30902 L
.3692 .30902 L
.37043 .30902 L
.37171 .30902 L
.37291 .30902 L
.37359 .30902 L
.37433 .30902 L
.37568 .30902 L
.3782 .30902 L
.37963 .30902 L
.38041 .30902 L
.38115 .30902 L
.38244 .30902 L
.38313 .30902 L
.38387 .30902 L
.38513 .30902 L
.38627 .30902 L
.3876 .30902 L
.38884 .30902 L
.39 .30902 L
.39106 .30902 L
.39223 .30902 L
.39346 .30902 L
.39471 .30902 L
.39541 .30902 L
.39605 .30902 L
.39728 .30902 L
.39846 .30902 L
.39912 .30902 L
.39982 .30902 L
.40109 .30902 L
.40179 .30902 L
.40245 .30902 L
.40317 .30902 L
.40395 .30902 L
.40459 .30902 L
.40527 .30902 L
.40651 .30902 L
.40726 .30902 L
.40797 .30902 L
.40861 .30902 L
.40931 .30902 L
.41004 .30902 L
.41073 .30902 L
.41145 .30902 L
Mistroke
.41225 .30902 L
.41355 .30902 L
.41429 .30902 L
.41496 .30902 L
.41624 .30902 L
.41743 .30902 L
.41874 .30902 L
.41947 .30902 L
.42014 .30902 L
.42136 .30902 L
.42267 .30902 L
.42392 .30902 L
.42506 .30902 L
.42632 .30902 L
.42752 .30902 L
.4286 .30902 L
.42976 .30902 L
.43103 .30902 L
.43168 .30902 L
.43238 .30902 L
.43363 .30902 L
.4348 .30902 L
.43592 .30902 L
.43709 .30902 L
.43809 .30902 L
.43918 .30902 L
.44036 .30902 L
.44163 .30902 L
.44282 .30902 L
.4439 .30902 L
.44519 .30902 L
.44584 .30902 L
.44655 .30902 L
.44782 .30902 L
.449 .30902 L
.44972 .30902 L
.4504 .30902 L
.45167 .30902 L
.45238 .30902 L
.45304 .30902 L
.45376 .30902 L
.45453 .30902 L
.45584 .30902 L
.45657 .30902 L
.45725 .30902 L
.45849 .30902 L
.4598 .30902 L
.46098 .30902 L
.46207 .30902 L
.46457 .30902 L
Mistroke
.46584 .30902 L
.46648 .30902 L
.46718 .30902 L
.46843 .30902 L
.4696 .30902 L
.4703 .30902 L
.47097 .30902 L
.47223 .30902 L
.47288 .30902 L
.47358 .30902 L
.47434 .30902 L
.47506 .30902 L
.47634 .30902 L
.47707 .30902 L
.47773 .30902 L
.47896 .30902 L
.48026 .30902 L
.48142 .30902 L
.48251 .30902 L
.4837 .30902 L
.48497 .30902 L
.48621 .30902 L
.48736 .30902 L
.48862 .30902 L
.48926 .30902 L
.48996 .30902 L
.49113 .30902 L
.4924 .30902 L
.49359 .30902 L
.49469 .30902 L
.49576 .30902 L
.49675 .30902 L
.49784 .30902 L
.499 .30902 L
.50023 .30902 L
.50138 .30902 L
.50242 .30902 L
.50355 .30902 L
.50478 .30902 L
.5059 .30902 L
.5072 .30902 L
.50843 .30902 L
.50957 .30902 L
.51062 .30902 L
.51178 .30902 L
.51301 .30902 L
.51371 .30902 L
.51436 .30902 L
.51507 .30902 L
.51582 .30902 L
Mistroke
.51708 .30902 L
.5178 .30902 L
.51847 .30902 L
.51972 .30902 L
.52086 .30902 L
.52217 .30902 L
.52341 .30902 L
.52462 .30902 L
.52532 .30902 L
.52596 .30902 L
.52663 .30902 L
.52735 .30902 L
.52865 .30902 L
.52978 .30902 L
.53101 .30902 L
.5323 .30902 L
.5335 .30902 L
.53418 .30902 L
.53493 .30902 L
.53563 .30902 L
.53628 .30902 L
.5375 .30902 L
.5388 .30902 L
.5401 .30902 L
.54083 .30902 L
.54149 .30902 L
.54228 .30902 L
.54302 .30902 L
.54371 .30902 L
.54445 .30902 L
.54567 .30902 L
.54678 .30902 L
.548 .30902 L
.54929 .30902 L
.55041 .30902 L
.55146 .30902 L
.5526 .30902 L
.55383 .30902 L
.55453 .30902 L
.55517 .30902 L
.55587 .30902 L
.55662 .30902 L
.55788 .30902 L
.55859 .30902 L
.55926 .30902 L
.5605 .30902 L
.56164 .30902 L
.56298 .30902 L
.5642 .30902 L
.56549 .30902 L
Mistroke
.5662 .30902 L
.56686 .30902 L
.56806 .30902 L
.56934 .30902 L
.57002 .30902 L
.57077 .30902 L
.57154 .30902 L
.57227 .30902 L
.57357 .30902 L
.5743 .30902 L
.57496 .30902 L
.57618 .30902 L
.57748 .30902 L
.57815 .30902 L
.5789 .30902 L
.58021 .30902 L
.58145 .30902 L
.58214 .30902 L
.58278 .30902 L
.58396 .30902 L
.58519 .30902 L
.58643 .30902 L
.58712 .30902 L
.58777 .30902 L
.58895 .30902 L
.59019 .30902 L
.59131 .30902 L
.59236 .30902 L
.59351 .30902 L
.59474 .30902 L
.59605 .30902 L
.59679 .30902 L
.59747 .30902 L
.59873 .30902 L
.59943 .30902 L
.60007 .30902 L
.60128 .30902 L
.60258 .30902 L
.60381 .30902 L
.60494 .30902 L
.606 .30902 L
.60715 .30902 L
.60822 .30902 L
.6092 .30902 L
.61035 .30902 L
.61161 .30902 L
.61278 .30902 L
.61388 .30902 L
.61501 .30902 L
.61626 .30902 L
Mistroke
.61747 .30902 L
.61878 .30902 L
.61999 .30902 L
.62114 .30902 L
.62218 .30902 L
.62331 .30902 L
.62395 .30902 L
.62463 .30902 L
.62585 .30902 L
.62717 .30902 L
.62792 .30902 L
.62861 .30902 L
.62987 .30902 L
.63102 .30902 L
.63166 .30902 L
.63235 .30902 L
.63361 .30902 L
.63473 .30902 L
.63597 .30902 L
.63726 .30902 L
.63847 .30902 L
.6396 .30902 L
.64063 .30902 L
.64185 .30902 L
.64296 .30902 L
.64418 .30902 L
.64549 .30902 L
.6467 .30902 L
.64784 .30902 L
.64848 .30902 L
.64917 .30902 L
.6504 .30902 L
.65172 .30902 L
.65247 .30902 L
.65317 .30902 L
.65384 .30902 L
.65456 .30902 L
.65588 .30902 L
.65716 .30902 L
.65836 .30902 L
.65909 .30902 L
.65977 .30902 L
.66105 .30902 L
.66177 .30902 L
.66244 .30902 L
.66316 .30902 L
.66393 .30902 L
.66515 .30902 L
.66584 .30902 L
.66648 .30902 L
Mistroke
.66765 .30902 L
.66889 .30902 L
.66996 .30902 L
.67107 .30902 L
.6723 .30902 L
.67342 .30902 L
.67461 .30902 L
.67591 .30902 L
.67713 .30902 L
.67825 .30902 L
.67895 .30902 L
.67961 .30902 L
.68083 .30902 L
.68216 .30902 L
.6829 .30902 L
.68359 .30902 L
.68465 .30902 L
.68578 .30902 L
.68685 .30902 L
.68783 .30902 L
.68901 .30902 L
.69025 .30902 L
.69143 .30902 L
.6925 .30902 L
.69369 .30902 L
.69481 .30902 L
.69603 .30902 L
.69734 .30902 L
.6985 .30902 L
.69973 .30902 L
.70078 .30902 L
.70193 .30902 L
.72313 .30902 L
.728 .30902 L
.72919 .30902 L
.73046 .30902 L
.73119 .30902 L
.73186 .30902 L
.73317 .30902 L
.73434 .30902 L
.73544 .30902 L
.73664 .30902 L
.73792 .30902 L
.73914 .30902 L
.74028 .30902 L
.74132 .30902 L
.74243 .30902 L
.74359 .30902 L
.74486 .30902 L
.74551 .30902 L
Mistroke
.74619 .30902 L
.74744 .30902 L
.74867 .30902 L
.74984 .30902 L
.75204 .30902 L
.7533 .30902 L
.75393 .30902 L
.75464 .30902 L
.75587 .30902 L
.75704 .30902 L
.7577 .30902 L
.7584 .30902 L
.75965 .30902 L
.76035 .30902 L
.761 .30902 L
.76177 .30902 L
.76247 .30902 L
.76366 .30902 L
.76494 .30902 L
.76607 .30902 L
.76727 .30902 L
.76834 .30902 L
.76935 .30902 L
.77045 .30902 L
.77163 .30902 L
.77289 .30902 L
.7736 .30902 L
.77426 .30902 L
.77546 .30902 L
.77675 .30902 L
.77801 .30902 L
.7792 .30902 L
.78027 .30902 L
.78142 .30902 L
.78267 .30902 L
.7838 .30902 L
.78511 .30902 L
.78635 .30902 L
.7875 .30902 L
.78855 .30902 L
.79095 .30902 L
.80139 .30902 L
.82247 .30902 L
.86178 .30902 L
.89958 .30902 L
.93983 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.21) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0
I_l0000co`0023?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001c?o00030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`0Coooo000Aoooo00<0000co`0c
o`00;c?o00030000<ol0<ol001Xco`000`1Voc?o03?o000B<ol000<0000co`0co`00;S?o00030000
<ol0<ol002lco`000`000?ooooooo`0_oooo00<0003oooooool04oooo`004Oooodlco`000`1Voc?o
03?o001e<ol000<0003oooooool0AOooo`004Oooodlco`000`1Voc?o03?o001e<ol000<0003ooooo
ool0AOooo`004Oooodlco`000`1Voc?o03?o001e<ol000<0003oooooool0AOooo`004Oooodlco`00
0`1Voc?o03?o001e<ol000<0003oooooool0AOooo`004Oooo`H0I_m9<ol000<0I_lco`0co`00MC?o
00030000oooooooo04Goool0017oool6<ol02P1Voclco`000`1Voc?o03?o001e<ol00P0004Koool0
017oool@<ol0201VocLco`000`1Voc?o03?o001e<ol000<0003oooooool0AOooo`004OoooaPco`06
06Ko<C?o000306Ko<ol0<ol007Dco`000`000?ooooooo`15oooo000Aoooo7S?o00L0I_lZ<ol000<0
I_lco`0co`00MC?o00030000oooooooo04Goool0017ooolU<ol0201Vob8co`000`1Voc?o03?o001e
<ol000<0003oooooool0AOooo`004Oooobdco`0506Ko7C?o000306Ko<ol0<ol007Dco`000`000?oo
ooooo`15oooo000Aoooo<S?o00@0I_lI<ol000<0I_lco`0co`00MC?o00030000oooooooo04Goool0
017ooolf<ol00`1VoaHco`000`1Voc?o03?o001e<ol000<0003oooooool0AOooo`004Oooo`80000g
<ol0101Voa8co`000`1Voc?o03?o001e<ol00P0004Koool001?oool20000>C?o00@0I_l><ol000<0
I_lco`0co`00MC?o00030000oooooooo04Goool001Goool20000>c?o00D0I_l9<ol000<0I_lco`0c
o`00MC?o00030000oooooooo04Goool001Ooool20000?S?o0080I_l7<ol000<0I_lco`0co`00MC?o
00030000oooooooo04Goool001Woool20000?S?o00D0I_l2<ol000<0I_lco`0co`00MC?o00030000
oooooooo04Goool001_oool20000@C?o00<0I_mg<ol000<0003oooooool0AOooo`007Oooo`800011
<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool001ooool00`0003?o03?o000n<ol000?o
09Tco`0co`00MC?o00030000oooooooo04Goool0023oool00`0003?o03?o000m<ol000?o09Tco`0c
o`00MC?o00800016oooo000Qoooo0P0003dco`000ol0VC?o03?o001e<ol000<0003oooooool0AOoo
o`008oooo`030000<ol0<ol003Xco`000ol0VC?o03?o001e<ol000<0003oooooool0AOooo`009?oo
o`80000j<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool002Koool00`0003?o03?o000g
<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool002Ooool00`0003?o03?o000f<ol000?o
09Tco`0co`00MC?o00030000oooooooo04Goool002Soool00`0003?o03?o000e<ol000?o09Tco`0c
o`00G3?o00800004<ol00P0000@co`0200000c?o00@00004<ol000<0003oooooool0AOooo`00:Ooo
o`030000<ol0<ol003@co`000ol0VC?o03?o001K<ol000@0000co`0co`000008<ol000@0000co`0c
o`000002<ol000<0000co`0co`001C?o00030000oooooooo04Goool002[oool00`0003?o03?o000c
<ol000?o09Tco`0co`00Fc?o00040000<ol0<ol0000023?o00040000<ol0<ol000000c?o00030000
<ol0<ol000@co`030000AOooo`00:oooo`80000c<ol000?o09Tco`0co`00Fc?o00040000<ol0<ol0
000023?o00040000<ol0<ol0000013?o00030000<ol0<ol000<co`000`000?ooooooo`15oooo000]
oooo00<0000co`0co`00<3?o0003o`2I<ol0<ol005/co`00100003?o03?o000000Pco`00100003?o
03?o0000008co`00100003?o03?o000000@co`000`000?ooooooo`15oooo000^oooo00<0000co`0c
o`00;c?o0003o`2I<ol0<ol005`co`0200002S?o00800004<ol00P0000Dco`000`000?ooooooo`15
oooo000_oooo00<0000co`0co`00;S?o0003o`2I<ol0<ol007Dco`000`000?ooooooo`15oooo000`
oooo00<0000co`0co`00;C?o0003o`2I<ol0<ol007Dco`000`000?ooooooo`15oooo000aoooo00<0
000co`0co`00;3?o0003o`2I<ol0<ol007Dco`000`000?ooooooo`15oooo000boooo00<0000co`0c
o`00:c?o0003o`2I<ol0<ol007Dco`000`000?ooooooo`15oooo000coooo00<0000co`0co`00:S?o
0003o`2I<ol0<ol007Dco`020000A_ooo`00<oooo`030000<ol0<ol002Xco`000ol0VC?o03?o001e
<ol000<0003oooooool0AOooo`00=?ooo`030000<ol0<ol002Tco`000ol0VC?o03?o001e<ol000<0
003oooooool0AOooo`00=Oooo`030000<ol0<ol002Pco`000ol0VC?o03?o001e<ol000<0003ooooo
ool0AOooo`00=_ooo`030000<ol0<ol002Lco`000ol0VC?o03?o001e<ol000<0003oooooool0AOoo
o`00=oooo`030000<ol0<ol002Hco`000ol0VC?o03?o001e<ol000<0003oooooool0AOooo`00>?oo
o`030000<ol0<ol002Dco`000ol0VC?o03?o001e<ol000<0003oooooool0AOooo`00>?ooo`030000
<ol0<ol002Dco`000ol0VC?o03?o001e<ol000<0003oooooool0AOooo`00>Oooo`030000<ol0<ol0
02@co`000ol0VC?o03?o001e<ol00P0004Koool003[oool00`0003?o03?o000S<ol000?o09Tco`0c
o`00MC?o00030000oooooooo04Goool003_oool00`0003?o03?o000R<ol000?o09Tco`0co`00MC?o
00030000oooooooo04Goool003coool00`0003?o03?o000Q<ol000?o09Tco`0co`00MC?o00030000
oooooooo04Goool003coool00`0003?o03?o000Q<ol000?o09Tco`0co`00MC?o00030000oooooooo
04Goool003goool00`0003?o03?o000P<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool0
03goool00`0003?o03?o000P<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool003koool0
0`0003?o03?o000O<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool003koool00`0003?o
03?o000O<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool003ooool00`0003?o03?o000N
<ol000?o09Tco`0co`00MC?o00800016oooo000ooooo00<0000co`0co`007S?o0003o`2I<ol0<ol0
07Dco`000`000?ooooooo`15oooo0010oooo00<0000co`0co`007C?o0003o`2I<ol0<ol007Dco`00
0`000?ooooooo`15oooo0011oooo00<0000co`0co`0073?o0003o`2I<ol0<ol007Dco`000`000?oo
ooooo`15oooo0011oooo00<0000co`0co`0073?o0003o`2I<ol0<ol007Dco`000`000?ooooooo`15
oooo0012oooo00<0000co`0co`006c?o0003o`2I<ol0<ol007Dco`000`000?ooooooo`15oooo0012
oooo00<0000co`0co`006c?o0003o`2I<ol0<ol005`co`02000013?o00800004<ol00P0000Dco`03
00000c?o00030000oooooooo04Goool004?oool00`0003?o03?o000J<ol000?o09Tco`0co`00Fc?o
00040000<ol0<ol0000023?o00040000<ol0<ol000001C?o00030000<ol0<ol0008co`000`000?oo
ooooo`15oooo0013oooo00<0000co`0co`006S?o0003o`2I<ol0<ol005/co`00100003?o03?o0000
00Pco`00100003?o03?o0000008co`0500000c?o00<00015oooo0014oooo00<0000co`0co`006C?o
0003o`2I<ol0<ol005/co`00100003?o03?o000000Pco`00100003?o03?o0000008co`00100003?o
03?o000000@co`000`000?ooooooo`15oooo0014oooo00<0000co`0co`006C?o0003o`2I<ol0<ol0
05/co`00100003?o03?o000000Pco`00100003?o03?o000000<co`000`0003?o00000004<ol000<0
003oooooool0AOooo`00AOooo`030000<ol0<ol001Pco`000ol0VC?o03?o001L<ol00P0000Xco`02
00001C?o00800004<ol000<0003oooooool0AOooo`00AOooo`030000<ol0<ol001Pco`000ol0VC?o
03?o001e<ol000<0003oooooool0AOooo`00A_ooo`030000<ol0<ol001Lco`000ol0VC?o03?o001e
<ol000<0003oooooool0AOooo`00A_ooo`030000<ol0<ol001Lco`000ol0VC?o03?o001e<ol000<0
003oooooool0AOooo`00Aoooo`030000<ol0<ol001Hco`000ol0VC?o03?o001e<ol000<0003ooooo
ool0AOooo`00Aoooo`030000<ol0<ol001Hco`000ol0VC?o03?o001e<ol00P0004Koool004Soool0
0`0003?o03?o000E<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool004Soool00`0003?o
03?o000E<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool004Woool00`0003?o03?o000D
<ol000?o09Tco`0co`00MC?o00030000oooooooo04Goool004Woool00`0003?o03?o000D<ol000?o
09Tco`0co`00MC?o00030000oooooooo04Goool004[oool00`0003?o03?o000C<ol000?o09Tco`0c
o`00MC?o00030000oooooooo04Goool004[oool00`0003?o03?o000C<ol000?o09Tco`0co`00MC?o
00030000oooooooo04Goool004_oool00`0003?o03?o000B<ol000?o09Tco`0co`00MC?o00030000
oooooooo04Goool004_oool00`0003?o03?o000B<ol000?o09Tco`0co`00MC?o00800016oooo001<
ooooS3?o04Soool004cooon<<ol0B?ooo`00C?oooh`co`18oooo001=ooooRc?o04Soool004gooon;
<ol0B?ooo`00C_ooobHco`000`0003?o03?o000_<ol000<0000co`0co`00;c?o04Soool004kooolU
<ol000<0000co`0co`0023?o00030000<ol0<ol002Hco`000`0003?o03?o000^<ol0B?ooo`00Cooo
ob@co`000`0003?o03?o0002<ol00P0000@co`000`0003?o03?o000><ol00P0000@co`0200000c?o
00@00002<ol01@00008co`000`0003?o03?o000^<ol0B?ooo`00Coooob@co`001@0003?o03?o03?o
00000002<ol000<0000co`0co`000S?o00030000<ol0<ol000Dco`0400000c?o00040000<ol0<ol0
000023?o00030000<ol0<ol000Dco`000`0003?o03?o0002<ol000<0000co`0co`00;S?o04Soool0
04oooolS<ol000<0000co`0co`000S?o00030000<ol0<ol001@co`00100003?o03?o000000Tco`00
0`0003?o03?o0004<ol000<0000co`0co`000c?o00030000<ol0<ol002dco`18oooo001@oooo8c?o
00030000<ol0<ol000D0000C<ol000@0000co`0co`00000:<ol000<0000co`0co`000c?o00030000
<ol0<ol0008co`000`0003?o03?o000^<ol0B?ooo`00D?ooob<co`001@0003?o03?o03?o0000000F
<ol000@0000co`0co`000008<ol000@0000co`0co`000004<ol000<0000co`0co`000S?o00030000
<ol0<ol002hco`18oooo001@oooo93?o00030000<ol0<ol001Pco`0200002S?o00800004<ol00P00
00<co`000`0003?o03?o000_<ol0B?ooo`00DOooohLco`18oooo001AooooQc?o04Soool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.18058, \
-0.0500005, 0.0100694, 0.000620672}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.18058, -0.0500005, 0.0100694, 0.000620672}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
.26171 .65815 L
.30316 .78516 L
.34309 .95159 L
.3815 1.16733 L
.42237 1.47871 L
.46172 1.88811 L
.49955 2.42176 L
.53984 3.20046 L
.57861 4.23918 L
.59832 4.91392 L
.61984 5.7959 L
.65954 7.95102 L
.67922 9.35688 L
.70019 11.1885 L
.72016 13.3412 L
.74177 16.2565 L
.76264 19.8432 L
.77257 21.8921 L
.77742 22.9887 L
.78184 24.0493 L
.78407 24.6088 L
.78534 24.9323 L
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .36836 m
.06244 .38811 L
.10458 .41722 L
.14415 .45428 L
.18221 .50189 L
.22272 .56993 L
s
.22272 .56993 m
.24398 .61803 L
s
.78649 .61803 m
.7865 .30902 L
.78752 .30902 L
.78865 .30902 L
.79092 .30902 L
.80066 .30902 L
.82133 .30902 L
.86153 .30902 L
.90022 .30902 L
.94136 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.31875 .30902 L
.32392 .30902 L
.32617 .30902 L
.32728 .30902 L
.32831 .30902 L
s
.32831 .30902 m
.32832 .61803 L
s
0 .4 1 r
.02381 .33399 m
.06244 .33785 L
.10458 .34274 L
.14415 .34809 L
.18221 .35404 L
.22272 .36138 L
.26171 .36959 L
.28158 .37427 L
.30316 .37976 L
.31323 .38248 L
.31875 .38402 L
.32392 .38549 L
.32617 .38614 L
.32728 .38646 L
.32831 .38676 L
.32949 .30902 L
.33078 .30902 L
.33187 .30902 L
.33304 .30902 L
.33434 .30902 L
.33508 .30902 L
.33575 .30902 L
.33699 .30902 L
.33831 .30902 L
.33949 .30902 L
.34059 .30902 L
.34179 .30902 L
.34309 .30902 L
.3443 .30902 L
.345 .30902 L
.34565 .30902 L
.34632 .30902 L
.34705 .30902 L
.34837 .30902 L
.34951 .30902 L
.35075 .30902 L
.35205 .30902 L
.35326 .30902 L
.35395 .30902 L
.3547 .30902 L
.35536 .30902 L
.35606 .30902 L
.35669 .30902 L
.35739 .30902 L
.35861 .30902 L
.35935 .30902 L
.36003 .30902 L
.36082 .30902 L
.36156 .30902 L
.36288 .30902 L
Mistroke
.36363 .30902 L
.36433 .30902 L
.36559 .30902 L
.3663 .30902 L
.36696 .30902 L
.36817 .30902 L
.36944 .30902 L
.37058 .30902 L
.37165 .30902 L
.37282 .30902 L
.37407 .30902 L
.37477 .30902 L
.37541 .30902 L
.37611 .30902 L
.37686 .30902 L
.37812 .30902 L
.37883 .30902 L
.3795 .30902 L
.38074 .30902 L
.38188 .30902 L
.38313 .30902 L
.38445 .30902 L
.38569 .30902 L
.38639 .30902 L
.38703 .30902 L
.38821 .30902 L
.38946 .30902 L
.39059 .30902 L
.39163 .30902 L
.39278 .30902 L
.39402 .30902 L
.39533 .30902 L
.39602 .30902 L
.39676 .30902 L
.3974 .30902 L
.39811 .30902 L
.39936 .30902 L
.40056 .30902 L
.40187 .30902 L
.4031 .30902 L
.40423 .30902 L
.4053 .30902 L
.40644 .30902 L
.40752 .30902 L
.4085 .30902 L
.40965 .30902 L
.4109 .30902 L
.41209 .30902 L
.41318 .30902 L
.41423 .30902 L
Mistroke
.41536 .30902 L
.4166 .30902 L
.41776 .30902 L
.41905 .30902 L
.42029 .30902 L
.4214 .30902 L
.42261 .30902 L
.42325 .30902 L
.42394 .30902 L
.42516 .30902 L
.42648 .30902 L
.42724 .30902 L
.42793 .30902 L
.42918 .30902 L
.42987 .30902 L
.43052 .30902 L
.43168 .30902 L
.43293 .30902 L
.43406 .30902 L
.43529 .30902 L
.43659 .30902 L
.4378 .30902 L
.43893 .30902 L
.43996 .30902 L
.4411 .30902 L
.44229 .30902 L
.44361 .30902 L
.44481 .30902 L
.44547 .30902 L
.44619 .30902 L
.44749 .30902 L
.44871 .30902 L
.45 .30902 L
.4511 .30902 L
.45232 .30902 L
.45305 .30902 L
.45374 .30902 L
.45505 .30902 L
.45577 .30902 L
.45645 .30902 L
.45719 .30902 L
.45798 .30902 L
.45867 .30902 L
.45941 .30902 L
.46011 .30902 L
.46076 .30902 L
.46198 .30902 L
.46327 .30902 L
.4645 .30902 L
.46519 .30902 L
Mistroke
.46583 .30902 L
.46701 .30902 L
.46825 .30902 L
.46937 .30902 L
.47041 .30902 L
.47155 .30902 L
.47279 .30902 L
.47409 .30902 L
.47482 .30902 L
.47551 .30902 L
.47676 .30902 L
.47746 .30902 L
.4781 .30902 L
.4793 .30902 L
.4806 .30902 L
.48183 .30902 L
.48296 .30902 L
.48403 .30902 L
.48516 .30902 L
.48624 .30902 L
.48722 .30902 L
.48837 .30902 L
.48962 .30902 L
.49079 .30902 L
.49189 .30902 L
.49301 .30902 L
.49406 .30902 L
.49521 .30902 L
.49646 .30902 L
.49769 .30902 L
.49899 .30902 L
.5001 .30902 L
.50132 .30902 L
.50263 .30902 L
.50385 .30902 L
.50454 .30902 L
.50518 .30902 L
.50586 .30902 L
.5066 .30902 L
.50785 .30902 L
.509 .30902 L
.50963 .30902 L
.51033 .30902 L
.51158 .30902 L
.51281 .30902 L
.51393 .30902 L
.51522 .30902 L
.51643 .30902 L
.51755 .30902 L
.51859 .30902 L
Mistroke
.51972 .30902 L
.52092 .30902 L
.52222 .30902 L
.52341 .30902 L
.5247 .30902 L
.52542 .30902 L
.52609 .30902 L
.52729 .30902 L
.52856 .30902 L
.52968 .30902 L
.53091 .30902 L
.5316 .30902 L
.53233 .30902 L
.53363 .30902 L
.53437 .30902 L
.53515 .30902 L
.53589 .30902 L
.53656 .30902 L
.53787 .30902 L
.5391 .30902 L
.53979 .30902 L
.54043 .30902 L
.54112 .30902 L
.54186 .30902 L
.54308 .30902 L
.5444 .30902 L
.54565 .30902 L
.54681 .30902 L
.54785 .30902 L
.54899 .30902 L
.55019 .30902 L
.55132 .30902 L
.55256 .30902 L
.55387 .30902 L
.55498 .30902 L
.5562 .30902 L
.55752 .30902 L
.55824 .30902 L
.55893 .30902 L
.55957 .30902 L
.56026 .30902 L
.56147 .30902 L
.56261 .30902 L
.56367 .30902 L
.56484 .30902 L
.56609 .30902 L
.56741 .30902 L
.56865 .30902 L
.56977 .30902 L
.571 .30902 L
Mistroke
.57216 .30902 L
.5732 .30902 L
.57442 .30902 L
.57556 .30902 L
.57662 .30902 L
.57759 .30902 L
.57979 .30902 L
.60022 .30902 L
.60141 .30902 L
.60267 .30902 L
.60333 .30902 L
.60406 .30902 L
.60534 .30902 L
.60655 .30902 L
.60784 .30902 L
.60907 .30902 L
.61019 .30902 L
.61129 .30902 L
.61231 .30902 L
.61343 .30902 L
.61462 .30902 L
.61588 .30902 L
.61707 .30902 L
.61813 .30902 L
.61929 .30902 L
.62044 .30902 L
.62168 .30902 L
.62285 .30902 L
.62392 .30902 L
.62504 .30902 L
.62626 .30902 L
.62757 .30902 L
.62883 .30902 L
.63104 .30902 L
.63225 .30902 L
.63339 .30902 L
.63446 .30902 L
.63561 .30902 L
.63666 .30902 L
.63762 .30902 L
.63876 .30902 L
.63998 .30902 L
.64113 .30902 L
.64218 .30902 L
.64341 .30902 L
.64411 .30902 L
.64475 .30902 L
.64593 .30902 L
.64718 .30902 L
.64837 .30902 L
Mistroke
.64966 .30902 L
.65087 .30902 L
.65198 .30902 L
.65327 .30902 L
.65401 .30902 L
.65469 .30902 L
.65594 .30902 L
.65663 .30902 L
.65727 .30902 L
.65847 .30902 L
.65959 .30902 L
.66081 .30902 L
.66213 .30902 L
.66279 .30902 L
.66351 .30902 L
.66482 .30902 L
.6661 .30902 L
.66728 .30902 L
.66837 .30902 L
.6694 .30902 L
.67062 .30902 L
.67175 .30902 L
.67286 .30902 L
.67403 .30902 L
.6753 .30902 L
.67649 .30902 L
.6778 .30902 L
.67898 .30902 L
.68026 .30902 L
.68098 .30902 L
.68164 .30902 L
.68284 .30902 L
.68397 .30902 L
.68514 .30902 L
.68643 .30902 L
.6871 .30902 L
.68784 .30902 L
.68853 .30902 L
.68917 .30902 L
.69038 .30902 L
.69167 .30902 L
.69241 .30902 L
.6932 .30902 L
.69394 .30902 L
.69463 .30902 L
.69593 .30902 L
.69659 .30902 L
.69731 .30902 L
.69862 .30902 L
.69982 .30902 L
Mistroke
.70045 .30902 L
.70115 .30902 L
.70188 .30902 L
.70256 .30902 L
.70381 .30902 L
.70495 .30902 L
.70621 .30902 L
.70753 .30902 L
.70864 .30902 L
.70983 .30902 L
.71096 .30902 L
.71198 .30902 L
.71318 .30902 L
.71448 .30902 L
.71571 .30902 L
.71684 .30902 L
.71805 .30902 L
.71934 .30902 L
.72056 .30902 L
.72168 .30902 L
.72299 .30902 L
.72373 .30902 L
.72441 .30902 L
.72567 .30902 L
.72637 .30902 L
.727 .30902 L
.72768 .30902 L
.72839 .30902 L
.72967 .30902 L
.73038 .30902 L
.73104 .30902 L
.73177 .30902 L
.73255 .30902 L
.73322 .30902 L
.73395 .30902 L
.73464 .30902 L
.73528 .30902 L
.73648 .30902 L
.73776 .30902 L
.73896 .30902 L
.74028 .30902 L
.74152 .30902 L
.74267 .30902 L
.74381 .30902 L
.74485 .30902 L
.74598 .30902 L
.74717 .30902 L
.74847 .30902 L
.74967 .30902 L
.75096 .30902 L
Mistroke
.7517 .30902 L
.75238 .30902 L
.75362 .30902 L
.75475 .30902 L
.75606 .30902 L
.75729 .30902 L
.75834 .30902 L
.7595 .30902 L
.76071 .30902 L
.76184 .30902 L
.7629 .30902 L
.76387 .30902 L
.76493 .30902 L
.76606 .30902 L
.7672 .30902 L
.76841 .30902 L
.76956 .30902 L
.77061 .30902 L
.77184 .30902 L
.77253 .30902 L
.77317 .30902 L
.77435 .30902 L
.77559 .30902 L
.7768 .30902 L
.77812 .30902 L
.77936 .30902 L
.78052 .30902 L
.78166 .30902 L
.7827 .30902 L
.7839 .30902 L
.78502 .30902 L
.78626 .30902 L
.78756 .30902 L
.7899 .30902 L
.79516 .30902 L
.81347 .30902 L
.85149 .30902 L
.89196 .30902 L
.93092 .30902 L
.97233 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.380952 0.309017 6.18034 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.21429 .29652 -12 -9 ]
[.21429 .29652 12 0 ]
[.40476 .29652 -6 -9 ]
[.40476 .29652 6 0 ]
[.59524 .29652 -12 -9 ]
[.59524 .29652 12 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[.77321 .0618 -30 -4.5 ]
[.77321 .0618 0 4.5 ]
[.77321 .18541 -30 -4.5 ]
[.77321 .18541 0 4.5 ]
[.77321 .43262 -24 -4.5 ]
[.77321 .43262 0 4.5 ]
[.77321 .55623 -24 -4.5 ]
[.77321 .55623 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-2)] .02381 .29652 0 1 Mshowa
.21429 .30902 m
.21429 .31527 L
s
[(-1.5)] .21429 .29652 0 1 Mshowa
.40476 .30902 m
.40476 .31527 L
s
[(-1)] .40476 .29652 0 1 Mshowa
.59524 .30902 m
.59524 .31527 L
s
[(-0.5)] .59524 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(0.5)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.0619 .30902 m
.0619 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.1381 .30902 m
.1381 .31277 L
s
.17619 .30902 m
.17619 .31277 L
s
.25238 .30902 m
.25238 .31277 L
s
.29048 .30902 m
.29048 .31277 L
s
.32857 .30902 m
.32857 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.44286 .30902 m
.44286 .31277 L
s
.48095 .30902 m
.48095 .31277 L
s
.51905 .30902 m
.51905 .31277 L
s
.55714 .30902 m
.55714 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.67143 .30902 m
.67143 .31277 L
s
.70952 .30902 m
.70952 .31277 L
s
.74762 .30902 m
.74762 .31277 L
s
.82381 .30902 m
.82381 .31277 L
s
.8619 .30902 m
.8619 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.9381 .30902 m
.9381 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.78571 .0618 m
.79196 .0618 L
s
[(-0.04)] .77321 .0618 1 0 Mshowa
.78571 .18541 m
.79196 .18541 L
s
[(-0.02)] .77321 .18541 1 0 Mshowa
.78571 .43262 m
.79196 .43262 L
s
[(0.02)] .77321 .43262 1 0 Mshowa
.78571 .55623 m
.79196 .55623 L
s
[(0.04)] .77321 .55623 1 0 Mshowa
.125 Mabswid
.78571 .09271 m
.78946 .09271 L
s
.78571 .12361 m
.78946 .12361 L
s
.78571 .15451 m
.78946 .15451 L
s
.78571 .21631 m
.78946 .21631 L
s
.78571 .24721 m
.78946 .24721 L
s
.78571 .27812 m
.78946 .27812 L
s
.78571 .33992 m
.78946 .33992 L
s
.78571 .37082 m
.78946 .37082 L
s
.78571 .40172 m
.78946 .40172 L
s
.78571 .46353 m
.78946 .46353 L
s
.78571 .49443 m
.78946 .49443 L
s
.78571 .52533 m
.78946 .52533 L
s
.78571 .0309 m
.78946 .0309 L
s
.78571 0 m
.78946 0 L
s
.78571 .58713 m
.78946 .58713 L
s
.78571 .61803 m
.78946 .61803 L
s
.25 Mabswid
.78571 0 m
.78571 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003of?ooo`800016
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00;ooool200001?ooo`800004
oooo0P0000Goool300000oooo`030000oooooooo04Goool00;koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0AOooo`00__ooo`040000
oooooooo00002?ooo`040000oooooooo00000_ooo`D00003oooo0`0004Goool00;Soool400000_oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
o`000004oooo00<0003oooooool0AOooo`00_oooo`80000:oooo0P0000Goool200001?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?oo
o`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool0
0`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool0
0=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo
04Goool00=Soool00`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?oo
ooooo`15oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool0
0`000?ooooooo`15oooo003Hoooo0P0004Koool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00_oooo`800004oooo0P0000Coool200000oooo`@00004oooo00<0
003oooooool0AOooo`00__ooo`040000oooooooo00002?ooo`040000oooooooo00000_ooo`030000
oooooooo00Goool00`000?ooooooo`15oooo002noooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`<00015oooo002hoooo100000;oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`03oooo00<0003oooooool0AOooo`00__oo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo04Goool00;ooool200002_ooo`800004oooo0P0000Goool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOoo
o`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003ooooo
ool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0
003oooooool0AOooo`00f?ooo`800016oooo003Hoooo00<0003oooooool0AOooo`00f?ooo`030000
oooooooo04Goool00=Soool00`000?ooooooo`15oooo003Hoooo00<0003oooooool0AOooo`004_oo
o`@0000Xoooo1@0000;oool200001?ooo`80000Yoooo1@0002Ooool200001?ooo`800004oooo0P00
02Soool00`000?ooooooo`0Xoooo0P0000Coool200001?ooo`80000?oooo000Boooo00<0003ooooo
ool0:oooo`030000oooooooo00Ooool010000?ooooooo`0002[oool00`000?ooooooo`0Voooo00@0
003oooooool00008oooo00@0003oooooool0000Woooo00<0003oooooool09oooo`040000oooooooo
00002?ooo`040000oooooooo00003_ooo`004oooo`030000oooooooo02[oool00`000?ooooooo`0:
oooo00<0003oooooool0:?ooo`030000oooooooo02Koool010000?ooooooo`0000_oool00`000?oo
ooooo`0Uoooo00<0003oooooool09oooo`040000oooooooo00002oooo`030000oooooooo00coool0
00coool400001?ooo`030000oooooooo027oool400001?ooo`030000oooooooo00Soool200008ooo
o`@00004oooo00<0003oooooool08?ooo`@00002oooo00@0003oooooool00009oooo0P0002Soool2
0000:?ooo`040000oooooooo00002Oooo`80000?oooo000Boooo00@0003oooooool0000Zoooo00<0
003oooooool02?ooo`030000oooooooo02[oool00`000?ooooooo`0Voooo00@0003oooooool00009
oooo00<0003oooooool09oooo`030000oooooooo02Ooool010000?ooooooo`0000Woool00`000?oo
ooooo`0>oooo000Coooo0P0002[oool200002_ooo`<0000Yoooo0P0002Woool200002_ooo`<0000W
oooo00<0003oooooool0:?ooo`80000:oooo0`0000koool00=Soool00`000?ooooooo`15oooo003H
oooo00<0003oooooool0AOooo`00f?ooo`030000oooooooo04Goool00=Soool00`000?ooooooo`15
oooo003Hoooo00<0003oooooool0AOooo`002oooool0000700003oooo`004Oooo`030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0
000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001c?o00030000<ol0<ol0
00Lco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01oooo`