(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1989288,      85323]*)
(*NotebookOutlinePosition[   1990032,      85348]*)
(*  CellTagsIndexPosition[   1989988,      85344]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING WITHIN NONHOMOGENEITY", "Text",
  CellFrame->True,
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  ",
    FontSize->12],
  StyleBox["is located on the positive ",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["x",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox["-axis.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  \n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" >0, is in the nonhomogeneity and needs to be specified. \n\nThe \
potential  v[x], which is ",
    FontSize->12],
  StyleBox["the nonhomogeneity, is strictly positive.  \n\nThe transmission \
coefficient, left reflection coefficient, and right reflection coefficient, \
respectively, are denoted by  T[k],  L[k],  R[k].\n\nThe tail of the wave is \
denoted by  g[x,t].\n\nThe focusing moment is chosen as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(Clear[v, T, L, R, x0, g, e]; 
    v[x_] = \ UnitStep[
          x]\ 80\ \((Sqrt[5] + 1)\) \((Sqrt[5] + 
            2)\)\ E^\((2\ Sqrt[
                  5]\ x)\)/\((\((1 + Sqrt[5])\) \((2 + 
                      Sqrt[5])\)\ E^\((2\ Sqrt[5]\ x)\) - 2)\)^2;\), "\n", 
    \(\(T[k_] = 
        k \((k + I\ Sqrt[5])\)/\((\((k + I)\) \((k + 2\ I)\))\);\)\), "\n", 
    \(\(L[k_] = 2/\((\((k + I)\) \((k + 2\ I)\))\);\)\), "\n", 
    \(\(R[
          k_] = \(-2\)\ \((k + 
                I\ Sqrt[5])\)/\((\((k + I)\) \((k + 2\ I)\) \((k - 
                    I\ Sqrt[5])\))\);\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the focusing location  x0, a nonnegative number, \
next:\
\>", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(x0 = 1;\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(e[x_] = 
        4\ Sqrt[5]/\((\((1 + Sqrt[5])\) \((2 + 
                      Sqrt[5])\)\ E^\((2\ Sqrt[5]\ x)\) - 
                2)\);\)\n\t\t\), "\n", 
    \(\(q1[x_, t_] = \ 
        E^\((\(-\ Sqrt[5]\) \((\ x - x0 - t)\))\)\ e[
            x0]\ \((1 + e[x]/\((2\ Sqrt[5])\))\);\)\n\t\), "\n", 
    \(\t\(q2[x_, t_] = 
        E^\((\ Sqrt[5] \((\ x - x0 - t)\))\)\ e[
            x]\ \((1 + e[x0]/\((2\ Sqrt[5])\))\);\)\n\), "\n", 
    \(\(\(q3[x_, 
          t_] = \(-4\)\ Sqrt[
            5]\ E^\((\(-\ Sqrt[5]\) \((\ x + x0 - t)\))\)\ \((1 + 
              e[x]/\((2\ Sqrt[5])\))\)\ \((1 + 
                e[x0]/\((2\ Sqrt[5])\))\)/\((\((1 + Sqrt[5])\) \((2 + 
                    Sqrt[5])\))\);\)\(\n\)
    \)\), "\n", 
    \(\(q4[x_, 
          t_] = \(-2\) \((Sqrt[5] - 1)\)\ E^\((x + x0 - t)\)\ \((1 + 
              e[x]/\((Sqrt[5] - 1)\))\) \((1 + 
                e[x0]/\((Sqrt[5] - 1)\))\)/\((Sqrt[5] + 
                1)\);\)\n\t\t\t\), "\n", 
    \(\t\t\t\(q5[x_, t_] = 
        2 \((Sqrt[5] - 2)\)\ E^\((2 \((x + x0 - t)\))\)\ \((1 + 
              e[x]/\((Sqrt[5] - 2)\))\) \((1 + 
                e[x0]/\((Sqrt[5] - 2)\))\)/\((Sqrt[5] + 
                2)\);\)\n\t\t\t\t\t\), "\n", 
    \(\t\t\(q6[x_, 
          t_] = \(-e[x]\)\ e[
            x0]\ \ E^\((Sqrt[5]\ \((x + x0 - t)\))\)\ /\((Sqrt[
                  5]\ \((\(-1\) + Sqrt[5])\) \((\(-2\) + 
                    Sqrt[5])\))\);\)\n\t\), "\n", 
    \(\t\(q7[x_, 
          t_] = \((1 + Sqrt[5])\) \((2 + Sqrt[5])\)\ e[
            x0]\ \ E^\((\(-Sqrt[5]\)\ \((x - x0 - t)\))\)/10;\)\n\), "\n", 
    \(\(\(q8[x_, t_] = \ 
        2 \((1 + e[x0]/Sqrt[5])\)/
              Sqrt[5] - \((\(-1\) + Sqrt[5])\) \((\(-2\) + 
                Sqrt[5])\)\ E^\((Sqrt[5]\ \((x - x0 - t)\))\)\ \ \((1 + 
                  e[x0]/\((2\ Sqrt[5])\))\)/Sqrt[5];\)\(\n\)
    \)\), "\n", 
    \(\(\(q9[x_, 
          t_] = \(-e[x0]\)\ E^\((Sqrt[5]\ \((x + x0 + t)\))\)/5;\)\(\n\)
    \)\), "\n", 
    \(\(\(q10[x_, t_] = \(-2\)\ \((1 + e[x0]/Sqrt[5])\)\ /Sqrt[5] + 
          2\ \ E^\((\(-Sqrt[5]\)\ \((x + x0 + t)\))\)\ \ \((1 + 
                  e[x0]/\((2\ Sqrt[5])\))\)/Sqrt[5];\)\(\n\)
    \)\), "\n", 
    \(\(\(q11[x_, 
          t_] = \(-2\)\ \ E^\((\(-Sqrt[5]\)\ \((x + x0 - t)\))\)\ \((1 + 
                  e[x0]/\((2\ Sqrt[5])\))\)/Sqrt[5] + 
          2\ \ \((1 + e[x0]/Sqrt[5])\)/Sqrt[5];\)\(\n\)
    \)\), "\n", 
    \(\(\(q12[x_, t_] = 
        e[x0]\ \ E^\((Sqrt[5]\ \((x + x0 - t)\))\)\ /5;\)\(\n\)
    \)\), "\n", 
    \(\(q13[x_, t_] = 
        4\ \ E^\((Sqrt[5]\ \((x - x0 + t)\))\)\ \((1 + 
                  e[x0]/\((2\ Sqrt[5])\))\)/\((Sqrt[
                    5] \((1 + Sqrt[5])\) \((2 + Sqrt[5])\))\) - 
          2\ \((1 + e[x0]/\ Sqrt[5])\)/Sqrt[5];\)\n\t\n\), "\n", 
    \(\(\(q14[x_, 
          t_] = \(-4\)\ E^\((\(-x\) + x0 - t)\) \((1 + 
                e[x0]/\((Sqrt[5] - 1)\))\)/\((Sqrt[5] + 1)\);\)\(\n\)
    \)\), "\n", 
    \(\(q15[x_, t_] = 
        2\ \ E^\((\(-2\) \((x - x0 + t)\))\)\ \((1 + 
                  e[x0]/\((Sqrt[5] - 2)\))\)/\((Sqrt[5] + 2)\) - 
          2\ e[x0]\ E^\((\(-Sqrt[5]\)\ \((x - x0 + t)\))\)/\((Sqrt[
                    5] \((\(-1\) + Sqrt[5])\) \((\(-2\) + 
                      Sqrt[5])\))\);\)\n\n\n\n\), "\n", 
    \(\(g[x_, t_] = \ 
        UnitStep[
              x]\ \((q1[x, t]\ UnitStep[x - x0 - t]\  + 
                q2[x, t]\ UnitStep[\(-x\) + x0 + t]\  + \ 
                q3[x, t]\ UnitStep[
                    x + x0 - t]\  + \((q4[x, t] + q5[x, t] + 
                      q6[x, t])\)\ UnitStep[\(-x\) - x0 + t])\) + 
          UnitStep[\(-x\)]\ \((\ 
              q7[x, t]\ UnitStep[x - x0 - t] + 
                q8[x, t]\ UnitStep[\(-x\) + x0 + t] + 
                q9[x, t]\ UnitStep[\(-x\) - x0 - t] + 
                q10[x, t]\ UnitStep[x + x0 + t]\n\t\t\t\t\t\t + 
                q11[x, t]\ UnitStep[x + x0 - t] + 
                q12[x, t]\ UnitStep[\(-x\) - x0 + t] + 
                q13[x, t]\ UnitStep[\(-x\) + x0 - t]\  + \((q14[x, t] + 
                      q15[x, t])\)\ UnitStep[x - x0 + t])\);\)\)}], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-3\), \ 
              2}, \ PlotRange -> {\(-1\), 4}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-3\), \ 2}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-1\), 
                1}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-3\), \ 2}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-1\), 1}]}, \[IndentingNewLine]\ {t, \ \(-2\), \ 
          2,  .2}, PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.39174 .12361 L
.39675 .12361 L
.40134 .12361 L
.40252 .12361 L
.40381 .12361 L
s
.40381 .12361 m
.4043 .61803 L
s
0 .4 1 r
.02381 .12361 m
.04262 .1455 L
.06244 .16388 L
.08255 .1786 L
.10458 .19115 L
.12415 .19984 L
.14509 .2071 L
.16639 .21278 L
.18653 .21689 L
.20651 .21999 L
.22495 .22213 L
.24367 .22371 L
.25432 .22437 L
.2643 .22485 L
.26926 .22503 L
.27468 .2252 L
.2798 .22532 L
.28224 .22537 L
.28455 .22541 L
.28681 .22544 L
.28925 .22546 L
.29033 .22547 L
.29147 .22548 L
.29244 .22548 L
.29351 .22549 L
.29476 .22549 L
.2959 .22549 L
.29721 .22549 L
.29846 .22549 L
.2996 .22548 L
.30067 .22548 L
.30183 .22547 L
.30307 .22546 L
.30545 .22544 L
.30796 .22541 L
.31244 .22533 L
.31726 .22522 L
.32254 .22506 L
.33201 .22468 L
.34082 .22423 L
.35134 .22353 L
.36128 .22273 L
.37987 .22078 L
.38959 .2195 L
.39491 .21872 L
.39988 .21794 L
.40205 .21758 L
.40312 .21739 L
.40412 .21722 L
.40525 .12361 L
Mistroke
.40649 .12361 L
.40867 .12361 L
.41833 .12361 L
.45751 .12361 L
.46783 .12361 L
.47897 .12361 L
.48408 .12361 L
.48948 .12361 L
.4941 .12361 L
.49536 .12361 L
.49671 .12361 L
.49799 .12361 L
.49915 .12361 L
.50033 .12361 L
.50144 .12361 L
.50397 .12361 L
.50909 .12361 L
.51827 .12361 L
.53905 .12361 L
.55756 .12361 L
.56804 .12361 L
.57779 .12361 L
.5875 .12361 L
.5903 .12361 L
.59167 .12361 L
.59293 .12361 L
.59409 .12361 L
.5953 .12361 L
.59652 .12361 L
.59722 .12361 L
.59787 .12361 L
.59917 .12361 L
.59991 .12361 L
.6006 .12361 L
.60186 .12361 L
.60249 .12361 L
.60319 .12361 L
.6044 .12361 L
.6057 .12361 L
.60692 .12361 L
.60805 .12361 L
.60937 .12361 L
.61059 .12361 L
.61129 .12361 L
.61193 .12361 L
.61267 .12361 L
.61337 .12361 L
.61468 .12361 L
.61534 .12361 L
.61606 .12361 L
Mistroke
.61684 .12361 L
.61758 .12361 L
.61825 .12361 L
.61898 .12361 L
.61966 .12361 L
.62031 .12361 L
.62152 .12361 L
.62282 .12361 L
.62355 .12361 L
.62422 .12361 L
.62535 .12361 L
.62659 .12361 L
.62789 .12361 L
.62909 .12361 L
.62978 .12361 L
.63052 .12361 L
.63118 .12361 L
.63188 .12361 L
.6332 .12361 L
.63442 .12361 L
.63509 .12361 L
.63582 .12361 L
.63713 .12361 L
.6379 .12361 L
.6387 .12361 L
.63943 .12361 L
.64013 .12361 L
.64139 .12361 L
.64253 .12361 L
.64377 .12361 L
.64446 .12361 L
.6451 .12361 L
.64617 .12361 L
.64735 .12361 L
.64858 .12361 L
.64973 .12361 L
.65038 .12361 L
.65108 .12361 L
.65237 .12361 L
.65363 .12361 L
.65479 .12361 L
.6555 .12361 L
.65617 .12361 L
.65742 .12361 L
.65812 .12361 L
.65877 .12361 L
.65953 .12361 L
.66022 .12361 L
.66138 .12361 L
.66264 .12361 L
Mistroke
.66382 .12361 L
.6649 .12361 L
.66608 .12361 L
.66739 .12361 L
.66804 .12361 L
.66875 .12361 L
.67002 .12361 L
.67134 .12361 L
.67209 .12361 L
.67279 .12361 L
.6735 .12361 L
.67417 .12361 L
.67542 .12361 L
.67657 .12361 L
.67781 .12361 L
.67913 .12361 L
.68036 .12361 L
.68143 .12361 L
.68259 .12361 L
.68387 .12361 L
.68504 .12361 L
.68625 .12361 L
.6869 .12361 L
.68758 .12361 L
.68883 .12361 L
.68998 .12361 L
.69103 .12361 L
.69216 .12361 L
.69322 .12361 L
.6942 .12361 L
.69528 .12361 L
.69646 .12361 L
.6977 .12361 L
.69885 .12361 L
.70012 .12361 L
.70076 .12361 L
.70147 .12361 L
.70272 .12361 L
.70389 .12361 L
.7046 .12361 L
.70527 .12361 L
.70653 .12361 L
.70723 .12361 L
.70788 .12361 L
.7086 .12361 L
.70936 .12361 L
.71065 .12361 L
.71138 .12361 L
.71205 .12361 L
.71328 .12361 L
Mistroke
.71457 .12361 L
.71574 .12361 L
.71682 .12361 L
.71802 .12361 L
.71929 .12361 L
.72054 .12361 L
.72169 .12361 L
.72295 .12361 L
.72359 .12361 L
.72429 .12361 L
.72547 .12361 L
.72673 .12361 L
.72793 .12361 L
.72902 .12361 L
.73009 .12361 L
.73108 .12361 L
.73217 .12361 L
.73334 .12361 L
.73456 .12361 L
.73572 .12361 L
.73676 .12361 L
.73788 .12361 L
.73911 .12361 L
.74024 .12361 L
.74155 .12361 L
.74278 .12361 L
.74393 .12361 L
.745 .12361 L
.74612 .12361 L
.74736 .12361 L
.74861 .12361 L
.74931 .12361 L
.74995 .12361 L
.75112 .12361 L
.75235 .12361 L
.753 .12361 L
.75369 .12361 L
.75494 .12361 L
.75571 .12361 L
.75643 .12361 L
.75708 .12361 L
.75778 .12361 L
.75909 .12361 L
.76031 .12361 L
.76106 .12361 L
.76177 .12361 L
.7624 .12361 L
.7631 .12361 L
.76378 .12361 L
.76451 .12361 L
Mistroke
.76581 .12361 L
.7666 .12361 L
.76734 .12361 L
.76801 .12361 L
.76873 .12361 L
.76995 .12361 L
.77064 .12361 L
.77129 .12361 L
.7726 .12361 L
.77333 .12361 L
.774 .12361 L
.77519 .12361 L
.77648 .12361 L
.77771 .12361 L
.77884 .12361 L
.78002 .12361 L
.78126 .12361 L
.78231 .12361 L
.78347 .12361 L
.78472 .12361 L
.78542 .12361 L
.78606 .12361 L
.7873 .12361 L
.78847 .12361 L
.78956 .12361 L
.79072 .12361 L
.79172 .12361 L
.79281 .12361 L
.79398 .12361 L
.79523 .12361 L
.79642 .12361 L
.79751 .12361 L
.79878 .12361 L
.79949 .12361 L
.80013 .12361 L
.80139 .12361 L
.80257 .12361 L
.80329 .12361 L
.80396 .12361 L
.80467 .12361 L
.80544 .12361 L
.80615 .12361 L
.80682 .12361 L
.80808 .12361 L
.80919 .12361 L
.81041 .12361 L
.8117 .12361 L
.8129 .12361 L
.8141 .12361 L
.81479 .12361 L
Mistroke
.81543 .12361 L
.81672 .12361 L
.81745 .12361 L
.81811 .12361 L
.81929 .12361 L
.82056 .12361 L
.82176 .12361 L
.82287 .12361 L
.82416 .12361 L
.82481 .12361 L
.82553 .12361 L
.82678 .12361 L
.82794 .12361 L
.82913 .12361 L
.83025 .12361 L
.83126 .12361 L
.83235 .12361 L
.83354 .12361 L
.83481 .12361 L
.83589 .12361 L
.83708 .12361 L
.83838 .12361 L
.83904 .12361 L
.83976 .12361 L
.84103 .12361 L
.84222 .12361 L
.84294 .12361 L
.84362 .12361 L
.8449 .12361 L
.84561 .12361 L
.84627 .12361 L
.84699 .12361 L
.84776 .12361 L
.84895 .12361 L
.85023 .12361 L
.85143 .12361 L
.85254 .12361 L
.85383 .12361 L
.85456 .12361 L
.85523 .12361 L
.85647 .12361 L
.8578 .12361 L
.85904 .12361 L
.85975 .12361 L
.86041 .12361 L
.8611 .12361 L
.86174 .12361 L
.86247 .12361 L
.86316 .12361 L
.86439 .12361 L
Mistroke
.86552 .12361 L
.86677 .12361 L
.8674 .12361 L
.86809 .12361 L
.8688 .12361 L
.86954 .12361 L
.87086 .12361 L
.8716 .12361 L
.87228 .12361 L
.87304 .12361 L
.87384 .12361 L
.87454 .12361 L
.8752 .12361 L
.87589 .12361 L
.87664 .12361 L
.87789 .12361 L
.87859 .12361 L
.87923 .12361 L
.87987 .12361 L
.88057 .12361 L
.88184 .12361 L
.88255 .12361 L
.88331 .12361 L
.88402 .12361 L
.88467 .12361 L
.88594 .12361 L
.88666 .12361 L
.88732 .12361 L
.88853 .12361 L
.8898 .12361 L
.89095 .12361 L
.89218 .12361 L
.89333 .12361 L
.89439 .12361 L
.89562 .12361 L
.89632 .12361 L
.89697 .12361 L
.89815 .12361 L
.8994 .12361 L
.90061 .12361 L
.90192 .12361 L
.90317 .12361 L
.90432 .12361 L
.90546 .12361 L
.90649 .12361 L
.90769 .12361 L
.90881 .12361 L
.91004 .12361 L
.91135 .12361 L
.91246 .12361 L
Mistroke
.91368 .12361 L
.91435 .12361 L
.91509 .12361 L
.91578 .12361 L
.91643 .12361 L
.91764 .12361 L
.91894 .12361 L
.92006 .12361 L
.92111 .12361 L
.92226 .12361 L
.9235 .12361 L
.92475 .12361 L
.92606 .12361 L
.92718 .12361 L
.9284 .12361 L
.92956 .12361 L
.93061 .12361 L
.93183 .12361 L
.93298 .12361 L
.93404 .12361 L
.93502 .12361 L
.9361 .12361 L
.93724 .12361 L
.93845 .12361 L
.93976 .12361 L
.94093 .12361 L
.94216 .12361 L
.94339 .12361 L
.9445 .12361 L
.94562 .12361 L
.94667 .12361 L
.9479 .12361 L
.94921 .12361 L
.95032 .12361 L
.95154 .12361 L
.95286 .12361 L
.95359 .12361 L
.95427 .12361 L
.95557 .12361 L
.95681 .12361 L
.95786 .12361 L
.95902 .12361 L
.96023 .12361 L
.96137 .12361 L
.96236 .12361 L
.9634 .12361 L
.96454 .12361 L
.96558 .12361 L
.96672 .12361 L
.96779 .12361 L
Mistroke
.96902 .12361 L
.97014 .12361 L
.97138 .12361 L
.97208 .12361 L
.97272 .12361 L
.97389 .12361 L
.97512 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<00000I_ooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooo06Ko02koool00`000?ooooooo`0]oooo00<0
003oooooool0;Oooo`030000<ol0<ol002dco`080000:Oooo`030000oooooooo01Goool001Soool0
0`1Vooooooooo`1Loooo00<0I_ooooooool0;Oooo`030000<ol0<ol002Xco`030000BOooo`006Ooo
o`0306Kooooooooo05_oool00`1Vooooooooo`0]oooo00<0000co`0co`009S?o00@0001<oooo000J
oooo00<0I_ooooooool0F_ooo`0306Kooooooooo02goool00`0003?o03?o000T<ol00P00053oool0
01_oool00`1Vooooooooo`1Ioooo00<0I_ooooooool0;Oooo`030000<ol0<ol002<co`000`000?oo
ooooo`1@oooo000Loooo00<0I_ooooooool0F?ooo`0306Kooooooooo02goool200008S?o0080001C
oooo000Moooo00<0I_ooooooool0Eoooo`0306Kooooooooo02goool00`0003?o03?o000O<ol00P00
05Goool001koool00`1Vooooooooo`1Foooo00<0I_ooooooool0;Oooo`030000<ol0<ol001hco`00
0`000?ooooooo`1Eoooo000Ooooo00<0I_ooooooool0EOooo`0306Kooooooooo02goool00`0003?o
03?o000M<ol000<0003oooooool0E_ooo`008?ooo`0306Kooooooooo05Coool00`1Vooooooooo`0]
oooo00<0000co`0co`0073?o00030000oooooooo05Ooool0027oool206KoE?ooo`0306Kooooooooo
02goool00`0003?o03?o000K<ol000<0003oooooool0F?ooo`008oooo`80I_mBoooo00<0I_oooooo
ool0;Oooo`80000L<ol000<0003oooooool0F?ooo`009Oooo`0306Kooooooooo04ooool00`1Voooo
ooooo`0]oooo00<0000co`0co`006S?o00030000oooooooo05Woool002Koool206KoCoooo`0306Ko
oooooooo02goool00`0003?o03?o000I<ol000<0003oooooool0F_ooo`00:?ooo`0306Kooooooooo
04coool00`1Vooooooooo`0]oooo00<0000co`0co`0063?o00030000oooooooo05_oool002Woool2
06KoC?ooo`0306Kooooooooo02goool00`0003?o03?o000G<ol000<0003oooooool0G?ooo`00:ooo
o`80I_m:oooo00<0I_ooooooool0;Oooo`030000<ol0<ol001Hco`000`000?ooooooo`1Moooo000]
oooo0P1VodSoool00`1Vooooooooo`0]oooo0P0001Lco`000`000?ooooooo`1Moooo000_oooo0`1V
odGoool00`1Vooooooooo`0]oooo00<0000co`0co`005C?o00030000oooooooo05koool003;oool2
06Ko@oooo`0306Kooooooooo02goool00`0003?o03?o000E<ol000<0003oooooool0G_ooo`00=?oo
o`@0I_looooo00<0I_ooooooool0;Oooo`030000<ol0<ol001Dco`000`000?ooooooo`1Noooo000h
oooo1@1Voc[oool00`1Vooooooooo`0]oooo00<0000co`0co`0053?o00030000oooooooo05ooool0
03goool506Ko=?ooo`80I_l_oooo00<0000co`0co`0053?o00030000oooooooo05ooool004;oool:
06Ko8oooo`L0I_l00oooool0VOooo`0^oooo0P0001@co`000`000?ooooooo`1Poooo001<oooo8`1V
o`Soool00ol0VOooooooo`0]oooo00<0000co`0co`004c?o00030000oooooooo063oool007Ooool0
0ol0VOooooooo`0]oooo00<0000co`0co`004c?o00030000oooooooo063oool007Ooool00ol0VOoo
ooooo`0]oooo00<0000co`0co`004S?o00030000oooooooo067oool007Ooool00ol0VOooooooo`0]
oooo00<0000co`0co`004S?o00030000oooooooo067oool007Ooool00ol0VOooooooo`0Uoooo1@00
00?oool00`0003?o03?o000A<ol000<0003oooooool0H_ooo`00Moooo`03o`2Ioooooooo02Ooool0
0`000?ooooooo`03oooo00<0000co`0co`004C?o00030000oooooooo06;oool007Ooool00ol0VOoo
ooooo`0Woooo00<0003oooooool00oooo`<0000A<ol000<0003oooooool0H_ooo`00Moooo`03o`2I
oooooooo02Ooool00`000?ooooooo`03oooo00<0000co`0co`0043?o00030000oooooooo06?oool0
07Ooool00ol0VOooooooo`0Woooo00<0003oooooool00oooo`030000<ol0<ol0010co`000`000?oo
ooooo`1Soooo001goooo00?o09Woooooool09_ooo`800005oooo00<0000co`0co`0043?o00030000
oooooooo06?oool007Ooool00ol0VOooooooo`0]oooo00<0000co`0co`0043?o00030000oooooooo
06?oool007Ooool00ol0VOooooooo`0]oooo00<0000co`0co`003c?o00030000oooooooo06Coool0
07Ooool00ol0VOooooooo`0]oooo0P00010co`000`000?ooooooo`1Toooo001goooo00?o09Wooooo
ool0;Oooo`030000<ol0<ol000lco`000`000?ooooooo`1Toooo001goooo00?o09Woooooool0;Ooo
o`030000<ol0<ol000lco`000`000?ooooooo`1Toooo001goooo00?o09Woooooool0;Oooo`030000
<ol0<ol000hco`000`000?ooooooo`1Uoooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol0
00hco`000`000?ooooooo`1Uoooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000hco`00
0`000?ooooooo`1Uoooo001goooo00?o09Woooooool0;Oooo`80000?<ol000<0003oooooool0IOoo
o`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o000=<ol000<0003oooooool0I_ooo`00Mooo
o`03o`2Ioooooooo02goool00`0003?o03?o000=<ol000<0003oooooool0I_ooo`00Moooo`03o`2I
oooooooo02goool00`0003?o03?o000=<ol000<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo
02goool00`0003?o03?o000=<ol000<0003oooooool0I_ooo`00Moooo`03o`2Ioooooooo02goool0
0`0003?o03?o000<<ol000<0003oooooool0Ioooo`00Moooo`03o`2Ioooooooo02goool00`0003?o
03?o000<<ol000<0003oooooool0Ioooo`00Moooo`03o`2Ioooooooo02goool200003C?o00030000
oooooooo06Ooool007Ooool00ol0VOooooooo`0]oooo00<0000co`0co`0033?o00030000oooooooo
06Ooool007Ooool00ol0VOooooooo`0]oooo00<0000co`0co`002c?o00030000oooooooo06Soool0
07Ooool00ol0VOooooooo`0]oooo00<0000co`0co`002c?o00030000oooooooo06Soool007Ooool0
0ol0VOooooooo`0]oooo00<0000co`0co`002c?o00030000oooooooo06Soool007Ooool00ol0VOoo
ooooo`0]oooo00<0000co`0co`002c?o00030000oooooooo06Soool007Ooool00ol0VOooooooo`0]
oooo0P0000`co`000`000?ooooooo`1Xoooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol0
00Xco`000`000?ooooooo`1Yoooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000Xco`00
0`000?ooooooo`1Yoooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000Xco`000`000?oo
ooooo`1Yoooo001goooo00?o09Woooooool09Oooo`@00004oooo00<0000co`0co`002S?o00030000
oooooooo06Woool007Ooool00ol0VOooooooo`0Uoooo00<0003oooooool01Oooo`030000<ol0<ol0
00Xco`000`000?ooooooo`1Yoooo001goooo00?o09Woooooool09_ooo`030000oooooooo00Coool3
00002S?o00030000oooooooo06Woool007Ooool00ol0VOooooooo`0Woooo00<0003oooooool00ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo001goooo00?o09Woooooool09Oooo`040000
oooooooo00001?ooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo001goooo00?o09Wooooo
ool09_ooo`800005oooo00<0000co`0co`002C?o00030000oooooooo06[oool007Ooool00ol0VOoo
ooooo`0]oooo00<0000co`0co`002C?o00030000oooooooo06[oool007Ooool00ol0VOooooooo`0]
oooo00<0000co`0co`002C?o00030000oooooooo06[oool007Ooool00ol0VOooooooo`0]oooo0P00
00Xco`000`000?ooooooo`1Zoooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000Pco`00
0`000?ooooooo`1[oooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000Pco`000`000?oo
ooooo`1[oooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000Pco`000`000?ooooooo`1[
oooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo001g
oooo00?o09Woooooool0;Oooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo001goooo00?o
09Woooooool0;Oooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo001goooo00?o09Wooooo
ool0;Oooo`800009<ol000<0003oooooool0Joooo`00Moooo`03o`2Ioooooooo02goool00`0003?o
03?o0008<ol000<0003oooooool0Joooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0007
<ol000<0003oooooool0K?ooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0007<ol000<0
003oooooool0K?ooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0007<ol000<0003ooooo
ool0K?ooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0007<ol000<0003oooooool0K?oo
o`00Moooo`03o`2Ioooooooo02goool2000023?o00030000oooooooo06coool007Ooool00ol0VOoo
ooooo`0]oooo00<0000co`0co`001c?o00030000oooooooo06coool007Ooool00ol0VOooooooo`0]
oooo00<0000co`0co`001c?o00030000oooooooo06coool007Ooool00ol0VOooooooo`0]oooo00<0
000co`0co`001c?o00030000oooooooo06coool007Ooool00ol0VOooooooo`0]oooo00<0000co`0c
o`001c?o00030000oooooooo06coool007Ooool00ol0VOooooooo`0]oooo00<0000co`0co`001c?o
00030000oooooooo06coool007Ooool00ol0VOooooooo`0]oooo0P0000Lco`000`000?ooooooo`1]
oooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo001g
oooo00?o09Woooooool0;Oooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo001goooo00?o
09Woooooool0;Oooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo001goooo00?o09Wooooo
ool09_ooo`800005oooo00<0000co`0co`001S?o00030000oooooooo06goool007Ooool00ol0VOoo
ooooo`0Uoooo00@0003oooooool00004oooo00<0000co`0co`001S?o00030000oooooooo06goool0
07Ooool00ol0VOooooooo`0Woooo00<0003oooooool00oooo`<00006<ol000<0003oooooool0KOoo
o`00Moooo`03o`2Ioooooooo02Soool00`000?ooooooo`02oooo00<0000co`0co`001S?o00030000
oooooooo06goool007Ooool00ol0VOooooooo`0Uoooo00@0003oooooool00004oooo00<0000co`0c
o`001S?o00030000oooooooo06goool007Ooool00ol0VOooooooo`0Voooo0P0000Goool00`0003?o
03?o0006<ol000<0003oooooool0KOooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0005
<ol000<0003oooooool0K_ooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0005<ol000<0
003oooooool0K_ooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0005<ol000<0003ooooo
ool0K_ooo`00Moooo`03o`2Ioooooooo02goool200001S?o00030000oooooooo06koool007Ooool0
0ol0VOooooooo`0]oooo00<0000co`0co`001C?o00030000oooooooo06koool007Ooool00ol0VOoo
ooooo`0]oooo00<0000co`0co`001C?o00030000oooooooo06koool007Ooool00ol0VOooooooo`0]
oooo00<0000co`0co`001C?o00030000oooooooo06koool007Ooool00ol0VOooooooo`0]oooo00<0
000co`0co`001C?o00030000oooooooo06koool007Ooool00ol0VOooooooo`0]oooo00<0000co`0c
o`001C?o00030000oooooooo06koool007Ooool00ol0VOooooooo`0]oooo0P0000Hco`000`000?oo
ooooo`1^oooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000@co`000`000?ooooooo`1_
oooo001goooo00?o09Woooooool0;Oooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo001g
oooo00?o09Woooooool0;Oooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo001goooo00?o
09Woooooool0;Oooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo001goooo00?o09Wooooo
ool0;Oooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo001goooo00?o09Woooooool0;Ooo
o`800005<ol000<0003oooooool0Koooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0004
<ol000<0003oooooool0Koooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0004<ol000<0
003oooooool0Koooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0004<ol000<0003ooooo
ool0Koooo`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0004<ol000<0003oooooool0Kooo
o`00Moooo`03o`2Ioooooooo02goool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00Mooo
o`03o`2Ioooooooo02goool2000013?o00030000oooooooo073oool007Ooool00ol0VOooooooo`0]
oooo00<0000co`0co`000c?o00030000oooooooo073oool007Ooool00ol0VOooooooo`0]oooo00<0
000co`0co`000c?o00030000oooooooo073oool007Ooool00ol0VOooooooo`0]oooo00<0000co`0c
o`000c?o00030000oooooooo073oool007Ooool00ol0VOooooooo`0]oooo00<0000co`0co`000c?o
00030000oooooooo073oool007Ooool00ol0VOooooooo`0Woooo0`0000?oool00`0003?o03?o0003
<ol000<0003oooooool0L?ooo`00Moooo`03o`2Ioooooooo02Soool00`000?ooooooo`02oooo00<0
000co`0co`000c?o00030000oooooooo073oool007Ooool00ol0VOooooooo`0Uoooo1@0000?oool3
00000c?o00030000oooooooo073oool009ooool010000?ooooooo`0000Coool6<ol0Loooo`00X?oo
o`030000oooo000000Coool6<ol0Loooo`00XOooo`800004oooo1S?o07?oool00:Ooool6<ol0Looo
o`00Yoooo`Hco`1coooo001ooooo00<0003oooooool07?ooo`030000oooooooo00Koool6<ol0Looo
o`00O_ooo`030000oooooooo00Soool00`000?ooooooo`0Coooo00<0003oooooool01Oooo`Hco`1c
oooo001noooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`@00003oooo00<0
003oooooool01Oooo`Hco`1coooo001noooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000?oool00`000?ooooooo`04oooo00<0003oooooool01Ooo
o`Hco`1coooo001moooo00<0003oooooool00_ooo`030000oooooooo01Coool00`000?ooooooo`04
oooo00<0003oooooool01?ooo`Hco`1coooo001noooo00<0003oooooool01@0001Coool00`000?oo
ooooo`02oooo00<0003oooooool01Oooo`Hco`1coooo001noooo00D0003oooooooooool000005Ooo
o`040000oooooooo00000oooo`030000oooooooo00Goool6<ol0Loooo`00Ooooo`030000oooooooo
01Ooool200000oooo`030000oooooooo00Koool6<ol0Loooo`00Yoooo`Hco`1coooo002Woooo1S?o
07?oool00001\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {290.125, 148.813}} -> {-0.349561, \
1.05307, 0.00349883, 0.00566123}, {{79.875, 308.563}, {290.125, 148.813}} -> \
{-5.53614, 4.80237, 0.0207442, 0.0319664}, {{79.875, 308.563}, {290.125, \
148.813}} -> {-5.53614, 4.80237, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.40095 .12361 L
.42237 .12361 L
.43215 .12361 L
.43755 .12361 L
.44021 .12361 L
.44151 .12361 L
.44268 .12361 L
s
.44268 .12361 m
.44316 .61803 L
s
0 .4 1 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.05546 .12361 L
.05789 .12361 L
.06007 .12361 L
.06131 .12361 L
.06244 .12431 L
.06371 .12592 L
.06487 .12738 L
.06747 .1306 L
.07218 .13616 L
.0829 .14774 L
.10458 .16713 L
.12357 .18046 L
.14429 .19195 L
.16396 .2005 L
.18493 .20763 L
.20635 .21321 L
.22652 .21722 L
.24659 .22025 L
.26507 .22233 L
.28389 .22386 L
.29458 .22449 L
.30455 .22493 L
.30956 .22511 L
.31501 .22526 L
.3175 .22531 L
.32015 .22537 L
.32244 .2254 L
.32491 .22544 L
.32728 .22546 L
.32832 .22547 L
.32946 .22548 L
.33046 .22548 L
.33154 .22549 L
.33267 .22549 L
.33373 .22549 L
.33499 .22549 L
.3357 .22549 L
.33635 .22549 L
.33755 .22549 L
.33883 .22548 L
.33997 .22547 L
.34103 .22546 L
.34346 .22544 L
.34605 .22541 L
.34844 .22537 L
Mistroke
.35387 .22525 L
.35866 .22512 L
.36375 .22495 L
.37348 .22452 L
.38229 .22402 L
.40157 .22253 L
.41243 .22142 L
.42241 .22022 L
.43152 .21895 L
.43653 .21817 L
.43899 .21777 L
.44127 .21739 L
.44257 .21716 L
.44323 .12361 L
.44395 .12361 L
.44687 .12361 L
.45197 .12361 L
.46195 .12361 L
.5022 .12361 L
.54094 .12361 L
.58213 .12361 L
.58725 .12361 L
.59208 .12361 L
.59338 .12361 L
.59409 .12361 L
.59476 .12361 L
.59547 .12361 L
.59626 .12361 L
.59693 .12361 L
.59765 .12361 L
.5983 .12361 L
.599 .12361 L
.60029 .12361 L
.60154 .12361 L
.6027 .12361 L
.60379 .12361 L
.60497 .12361 L
.60608 .12361 L
.6071 .12361 L
.60823 .12361 L
.60947 .12361 L
.61076 .12361 L
.61196 .12361 L
.61324 .12361 L
.61445 .12361 L
.61554 .12361 L
.61672 .12361 L
.61801 .12361 L
.61865 .12361 L
.61937 .12361 L
Mistroke
.62063 .12361 L
.62181 .12361 L
.62303 .12361 L
.62416 .12361 L
.62541 .12361 L
.6261 .12361 L
.62673 .12361 L
.62789 .12361 L
.62914 .12361 L
.63033 .12361 L
.63141 .12361 L
.63254 .12361 L
.63361 .12361 L
.63484 .12361 L
.63596 .12361 L
.63701 .12361 L
.63799 .12361 L
.63913 .12361 L
.6402 .12361 L
.64126 .12361 L
.64242 .12361 L
.64356 .12361 L
.64478 .12361 L
.64606 .12361 L
.64671 .12361 L
.64741 .12361 L
.64866 .12361 L
.64981 .12361 L
.65045 .12361 L
.65114 .12361 L
.65239 .12361 L
.6536 .12361 L
.65473 .12361 L
.65594 .12361 L
.65663 .12361 L
.65727 .12361 L
.65857 .12361 L
.65929 .12361 L
.65997 .12361 L
.66061 .12361 L
.66131 .12361 L
.66252 .12361 L
.66321 .12361 L
.66393 .12361 L
.66523 .12361 L
.66644 .12361 L
.66756 .12361 L
.66879 .12361 L
.67011 .12361 L
.67085 .12361 L
Mistroke
.67154 .12361 L
.67229 .12361 L
.67308 .12361 L
.67377 .12361 L
.67442 .12361 L
.67513 .12361 L
.67589 .12361 L
.67657 .12361 L
.6773 .12361 L
.678 .12361 L
.67864 .12361 L
.67986 .12361 L
.68116 .12361 L
.68182 .12361 L
.68252 .12361 L
.68377 .12361 L
.68446 .12361 L
.68511 .12361 L
.68582 .12361 L
.68659 .12361 L
.68725 .12361 L
.68796 .12361 L
.68926 .12361 L
.69053 .12361 L
.6917 .12361 L
.69284 .12361 L
.69391 .12361 L
.69508 .12361 L
.69634 .12361 L
.69759 .12361 L
.69891 .12361 L
.70003 .12361 L
.70127 .12361 L
.70258 .12361 L
.7038 .12361 L
.70443 .12361 L
.70513 .12361 L
.70586 .12361 L
.70655 .12361 L
.7078 .12361 L
.70895 .12361 L
.70958 .12361 L
.71028 .12361 L
.71153 .12361 L
.71274 .12361 L
.71388 .12361 L
.71519 .12361 L
.71638 .12361 L
.71743 .12361 L
.71853 .12361 L
Mistroke
.71975 .12361 L
.72087 .12361 L
.72217 .12361 L
.72336 .12361 L
.72402 .12361 L
.72474 .12361 L
.72604 .12361 L
.72725 .12361 L
.72854 .12361 L
.72964 .12361 L
.73086 .12361 L
.73155 .12361 L
.73228 .12361 L
.73358 .12361 L
.73431 .12361 L
.73498 .12361 L
.73572 .12361 L
.73651 .12361 L
.7372 .12361 L
.73794 .12361 L
.73864 .12361 L
.73929 .12361 L
.74052 .12361 L
.74181 .12361 L
.74303 .12361 L
.74435 .12361 L
.7456 .12361 L
.74676 .12361 L
.7478 .12361 L
.74894 .12361 L
.75014 .12361 L
.75127 .12361 L
.75251 .12361 L
.75382 .12361 L
.75493 .12361 L
.75615 .12361 L
.75747 .12361 L
.75821 .12361 L
.75888 .12361 L
.76018 .12361 L
.76142 .12361 L
.76256 .12361 L
.76364 .12361 L
.76476 .12361 L
.76599 .12361 L
.76705 .12361 L
.76802 .12361 L
.76914 .12361 L
.77021 .12361 L
.77135 .12361 L
Mistroke
.77257 .12361 L
.77372 .12361 L
.77477 .12361 L
.776 .12361 L
.77669 .12361 L
.77733 .12361 L
.7785 .12361 L
.77974 .12361 L
.78096 .12361 L
.78165 .12361 L
.78229 .12361 L
.78346 .12361 L
.7847 .12361 L
.78581 .12361 L
.78685 .12361 L
.78799 .12361 L
.78922 .12361 L
.79046 .12361 L
.79116 .12361 L
.79181 .12361 L
.79312 .12361 L
.79386 .12361 L
.79453 .12361 L
.79572 .12361 L
.79703 .12361 L
.79825 .12361 L
.79939 .12361 L
.80044 .12361 L
.80158 .12361 L
.80265 .12361 L
.80363 .12361 L
.80477 .12361 L
.80602 .12361 L
.8072 .12361 L
.80829 .12361 L
.80953 .12361 L
.81069 .12361 L
.81173 .12361 L
.81286 .12361 L
.81417 .12361 L
.8154 .12361 L
.81651 .12361 L
.81772 .12361 L
.81896 .12361 L
.8201 .12361 L
.82134 .12361 L
.82266 .12361 L
.82379 .12361 L
.82487 .12361 L
.82612 .12361 L
Mistroke
.82726 .12361 L
.82848 .12361 L
.82918 .12361 L
.82982 .12361 L
.83098 .12361 L
.83223 .12361 L
.83294 .12361 L
.8337 .12361 L
.83443 .12361 L
.8351 .12361 L
.83637 .12361 L
.837 .12361 L
.8377 .12361 L
.83838 .12361 L
.83912 .12361 L
.83981 .12361 L
.84045 .12361 L
.84167 .12361 L
.84296 .12361 L
.84425 .12361 L
.84498 .12361 L
.84564 .12361 L
.84639 .12361 L
.84717 .12361 L
.84785 .12361 L
.8486 .12361 L
.84929 .12361 L
.84994 .12361 L
.85115 .12361 L
.85246 .12361 L
.8532 .12361 L
.85388 .12361 L
.85501 .12361 L
.85626 .12361 L
.85756 .12361 L
.85878 .12361 L
.86003 .12361 L
.86073 .12361 L
.86136 .12361 L
.8626 .12361 L
.86376 .12361 L
.86442 .12361 L
.86511 .12361 L
.86636 .12361 L
.86706 .12361 L
.8677 .12361 L
.86842 .12361 L
.86918 .12361 L
.87045 .12361 L
.87112 .12361 L
Mistroke
.87183 .12361 L
.87314 .12361 L
.87435 .12361 L
.8755 .12361 L
.87658 .12361 L
.87777 .12361 L
.87905 .12361 L
.88014 .12361 L
.8813 .12361 L
.88258 .12361 L
.88376 .12361 L
.88441 .12361 L
.8851 .12361 L
.88636 .12361 L
.88759 .12361 L
.88872 .12361 L
.88978 .12361 L
.89077 .12361 L
.89186 .12361 L
.89303 .12361 L
.89425 .12361 L
.89541 .12361 L
.89645 .12361 L
.89758 .12361 L
.89824 .12361 L
.89892 .12361 L
.90015 .12361 L
.90147 .12361 L
.90222 .12361 L
.90292 .12361 L
.90419 .12361 L
.90535 .12361 L
.90599 .12361 L
.90668 .12361 L
.90794 .12361 L
.90907 .12361 L
.91031 .12361 L
.9116 .12361 L
.91282 .12361 L
.91395 .12361 L
.91498 .12361 L
.91618 .12361 L
.91732 .12361 L
.91864 .12361 L
.91983 .12361 L
.9205 .12361 L
.92122 .12361 L
.92252 .12361 L
.92374 .12361 L
.92504 .12361 L
Mistroke
.92614 .12361 L
.92735 .12361 L
.92809 .12361 L
.92878 .12361 L
.93009 .12361 L
.93082 .12361 L
.93149 .12361 L
.93223 .12361 L
.93302 .12361 L
.93432 .12361 L
.93553 .12361 L
.93623 .12361 L
.93687 .12361 L
.93757 .12361 L
.93831 .12361 L
.93954 .12361 L
.94023 .12361 L
.94087 .12361 L
.94204 .12361 L
.94328 .12361 L
.94439 .12361 L
.94543 .12361 L
.94657 .12361 L
.9478 .12361 L
.9491 .12361 L
.94983 .12361 L
.95051 .12361 L
.95176 .12361 L
.95246 .12361 L
.95309 .12361 L
.95429 .12361 L
.95559 .12361 L
.95681 .12361 L
.95793 .12361 L
.95907 .12361 L
.96015 .12361 L
.9614 .12361 L
.96253 .12361 L
.9636 .12361 L
.96458 .12361 L
.96567 .12361 L
.96682 .12361 L
.96791 .12361 L
.96894 .12361 L
.97007 .12361 L
.97129 .12361 L
.97254 .12361 L
.97385 .12361 L
.97497 .12361 L
.97619 .12361 L
Mistroke
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`03000006Kooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`00001Vooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo00Soool00`1Vooooooooo`0Soooo00<0
003oooooool0;Oooo`030000oooooooo00Koool00ol0V@1Vooooo`0Toooo00<0000co`0co`00;C?o
00P0000Yoooo00<0003oooooool05Oooo`008Oooo`0306Kooooooooo05coool00ol0V@1Vooooo`0T
oooo00<0000co`0co`00:S?o00<00019oooo000Roooo00<0I_ooooooool0Foooo`03o`2I06Kooooo
02Coool00`0003?o03?o000V<ol0100004coool002?oool00`1Vooooooooo`1Joooo00?o09T0I_oo
ool09?ooo`030000<ol0<ol002@co`020000D?ooo`009?ooo`0306Kooooooooo05Woool00ol0V@1V
ooooo`0Toooo00<0000co`0co`008c?o00030000oooooooo053oool002Goool00`1Vooooooooo`1H
oooo00?o09T0I_ooool09?ooo`80000R<ol00P0005?oool002Koool206KoF?ooo`03o`2I06Kooooo
02Coool00`0003?o03?o000O<ol00P0005Goool002Soool00`1Vooooooooo`1Eoooo00?o09T0I_oo
ool09?ooo`030000<ol0<ol001hco`000`000?ooooooo`1Eoooo000Yoooo0P1VoeGoool00ol0V@1V
ooooo`0Toooo00<0000co`0co`007C?o00030000oooooooo05Koool002_oool00`1Vooooooooo`1B
oooo00?o09T0I_ooool09?ooo`030000<ol0<ol001`co`000`000?ooooooo`1Goooo000/oooo00<0
I_ooooooool0DOooo`0306Kooooooooo02Coool00`0003?o03?o000K<ol000<0003oooooool0F?oo
o`00;Oooo`80I_mAoooo00<0I_ooooooool09?ooo`80000L<ol000<0003oooooool0F?ooo`00;ooo
o`0306Kooooooooo04koool00`1Vooooooooo`0Toooo00<0000co`0co`006S?o00030000oooooooo
05Woool0033oool00`1Vooooooooo`1=oooo00<0I_ooooooool09?ooo`030000<ol0<ol001Tco`00
0`000?ooooooo`1Joooo000aoooo0P1Vodgoool00`1Vooooooooo`0Toooo00<0000co`0co`0063?o
00030000oooooooo05_oool003?oool206KoBoooo`0306Kooooooooo02Coool00`0003?o03?o000G
<ol000<0003oooooool0G?ooo`00=Oooo`80I_m9oooo00<0I_ooooooool09?ooo`030000<ol0<ol0
01Hco`000`000?ooooooo`1Moooo000goooo0P1VodOoool00`1Vooooooooo`0Toooo0P0001Lco`00
0`000?ooooooo`1Moooo000ioooo0`1VodCoool00`1Vooooooooo`0Toooo00<0000co`0co`005C?o
00030000oooooooo05koool003coool206Ko@_ooo`0306Kooooooooo02Coool00`0003?o03?o000E
<ol000<0003oooooool0G_ooo`00?_ooo`@0I_lnoooo00<0I_ooooooool09?ooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1Noooo0012oooo1P1VocSoool00`1Vooooooooo`0Toooo00<0000co`0c
o`0053?o00030000oooooooo05ooool004Soool506Ko<_ooo`80I_lVoooo00<0000co`0co`0053?o
00030000oooooooo05ooool004goool906Ko7_ooo`/0I_l00oooool0VOooo`0Uoooo0P0001@co`00
0`000?ooooooo`1Poooo001Foooo7P1Vo`coool00ol0VOooooooo`0Toooo00<0000co`0co`004c?o
00030000oooooooo063oool0083oool00ol0VOooooooo`0Toooo00<0000co`0co`004c?o00030000
oooooooo063oool0083oool00ol0VOooooooo`0Toooo00<0000co`0co`004S?o00030000oooooooo
067oool0083oool00ol0VOooooooo`0Toooo00<0000co`0co`004S?o00030000oooooooo067oool0
083oool00ol0VOooooooo`0Loooo1@0000?oool00`0003?o03?o000A<ol000<0003oooooool0H_oo
o`00P?ooo`03o`2Ioooooooo01koool00`000?ooooooo`03oooo00<0000co`0co`004C?o00030000
oooooooo06;oool0083oool00ol0VOooooooo`0Noooo00<0003oooooool00oooo`<0000A<ol000<0
003oooooool0H_ooo`00P?ooo`03o`2Ioooooooo01koool00`000?ooooooo`03oooo00<0000co`0c
o`0043?o00030000oooooooo06?oool0083oool00ol0VOooooooo`0Noooo00<0003oooooool00ooo
o`030000<ol0<ol0010co`000`000?ooooooo`1Soooo0020oooo00?o09Woooooool07Oooo`800005
oooo00<0000co`0co`0043?o00030000oooooooo06?oool0083oool00ol0VOooooooo`0Toooo00<0
000co`0co`0043?o00030000oooooooo06?oool0083oool00ol0VOooooooo`0Toooo00<0000co`0c
o`003c?o00030000oooooooo06Coool0083oool00ol0VOooooooo`0Toooo0P00010co`000`000?oo
ooooo`1Toooo0020oooo00?o09Woooooool09?ooo`030000<ol0<ol000lco`000`000?ooooooo`1T
oooo0020oooo00?o09Woooooool09?ooo`030000<ol0<ol000lco`000`000?ooooooo`1Toooo0020
oooo00?o09Woooooool09?ooo`030000<ol0<ol000hco`000`000?ooooooo`1Uoooo0020oooo00?o
09Woooooool09?ooo`030000<ol0<ol000hco`000`000?ooooooo`1Uoooo0020oooo00?o09Wooooo
ool09?ooo`030000<ol0<ol000hco`000`000?ooooooo`1Uoooo0020oooo00?o09Woooooool09?oo
o`80000?<ol000<0003oooooool0IOooo`00P?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000=
<ol000<0003oooooool0I_ooo`00P?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000=<ol000<0
003oooooool0I_ooo`00P?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000=<ol000<0003ooooo
ool0I_ooo`00P?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000=<ol000<0003oooooool0I_oo
o`00P?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000<<ol000<0003oooooool0Ioooo`00P?oo
o`03o`2Ioooooooo02Coool00`0003?o03?o000<<ol000<0003oooooool0Ioooo`00P?ooo`03o`2I
oooooooo02Coool200003C?o00030000oooooooo06Ooool0083oool00ol0VOooooooo`0Toooo00<0
000co`0co`0033?o00030000oooooooo06Ooool0083oool00ol0VOooooooo`0Toooo00<0000co`0c
o`002c?o00030000oooooooo06Soool0083oool00ol0VOooooooo`0Toooo00<0000co`0co`002c?o
00030000oooooooo06Soool0083oool00ol0VOooooooo`0Toooo00<0000co`0co`002c?o00030000
oooooooo06Soool0083oool00ol0VOooooooo`0Toooo00<0000co`0co`002c?o00030000oooooooo
06Soool0083oool00ol0VOooooooo`0Toooo0P0000`co`000`000?ooooooo`1Xoooo0020oooo00?o
09Woooooool09?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo0020oooo00?o09Wooooo
ool09?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo0020oooo00?o09Woooooool09?oo
o`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo0020oooo00?o09Woooooool07?ooo`@00004
oooo00<0000co`0co`002S?o00030000oooooooo06Woool0083oool00ol0VOooooooo`0Loooo00<0
003oooooool01Oooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo0020oooo00?o09Wooooo
ool07Oooo`030000oooooooo00Coool300002S?o00030000oooooooo06Woool0087oool00ol0VOoo
ooooo`0Moooo00<0003oooooool00oooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo0021
oooo00?o09Woooooool06oooo`040000oooooooo00001?ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`1Zoooo0021oooo00?o09Woooooool07?ooo`800005oooo00<0000co`0co`002C?o00030000
oooooooo06[oool0087oool00ol0VOooooooo`0Soooo00<0000co`0co`002C?o00030000oooooooo
06[oool0087oool00ol0VOooooooo`0Soooo00<0000co`0co`002C?o00030000oooooooo06[oool0
087oool00ol0VOooooooo`0Soooo0P0000Xco`000`000?ooooooo`1Zoooo0021oooo00?o09Wooooo
ool08oooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo0021oooo00?o09Woooooool08ooo
o`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo0021oooo00?o09Woooooool08oooo`030000
<ol0<ol000Pco`000`000?ooooooo`1[oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol0
00Pco`000`000?ooooooo`1[oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol000Pco`00
0`000?ooooooo`1[oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol000Pco`000`000?oo
ooooo`1[oooo0021oooo00?o09Woooooool08oooo`800009<ol000<0003oooooool0Joooo`00POoo
o`03o`2Ioooooooo02?oool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00POooo`03o`2I
oooooooo02?oool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00POooo`03o`2Ioooooooo
02?oool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00POooo`03o`2Ioooooooo02?oool0
0`0003?o03?o0007<ol000<0003oooooool0K?ooo`00POooo`03o`2Ioooooooo02?oool00`0003?o
03?o0007<ol000<0003oooooool0K?ooo`00POooo`03o`2Ioooooooo02?oool2000023?o00030000
oooooooo06coool0087oool00ol0VOooooooo`0Soooo00<0000co`0co`001c?o00030000oooooooo
06coool0087oool00ol0VOooooooo`0Soooo00<0000co`0co`001c?o00030000oooooooo06coool0
087oool00ol0VOooooooo`0Soooo00<0000co`0co`001c?o00030000oooooooo06coool0087oool0
0ol0VOooooooo`0Soooo00<0000co`0co`001c?o00030000oooooooo06coool0087oool00ol0VOoo
ooooo`0Soooo00<0000co`0co`001c?o00030000oooooooo06coool0087oool00ol0VOooooooo`0S
oooo0P0000Lco`000`000?ooooooo`1]oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1]oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1]oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1]oooo0021oooo00?o09Woooooool07?ooo`800005oooo00<0000co`0co`001S?o00030000
oooooooo06goool0087oool00ol0VOooooooo`0Koooo00@0003oooooool00004oooo00<0000co`0c
o`001S?o00030000oooooooo06goool0087oool00ol0VOooooooo`0Moooo00<0003oooooool00ooo
o`<00006<ol000<0003oooooool0KOooo`00POooo`03o`2Ioooooooo01koool00`000?ooooooo`02
oooo00<0000co`0co`001S?o00030000oooooooo06goool0087oool00ol0VOooooooo`0Koooo00@0
003oooooool00004oooo00<0000co`0co`001S?o00030000oooooooo06goool0087oool00ol0VOoo
ooooo`0Loooo0P0000Goool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00POooo`03o`2I
oooooooo02?oool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00POooo`03o`2Ioooooooo
02?oool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00POooo`03o`2Ioooooooo02?oool0
0`0003?o03?o0005<ol000<0003oooooool0K_ooo`00POooo`03o`2Ioooooooo02?oool200001S?o
00030000oooooooo06koool0087oool00ol0VOooooooo`0Soooo00<0000co`0co`001C?o00030000
oooooooo06koool0087oool00ol0VOooooooo`0Soooo00<0000co`0co`001C?o00030000oooooooo
06koool0087oool00ol0VOooooooo`0Soooo00<0000co`0co`001C?o00030000oooooooo06koool0
087oool00ol0VOooooooo`0Soooo00<0000co`0co`001C?o00030000oooooooo06koool0087oool0
0ol0VOooooooo`0Soooo00<0000co`0co`001C?o00030000oooooooo06koool0087oool00ol0VOoo
ooooo`0Soooo0P0000Hco`000`000?ooooooo`1^oooo0021oooo00?o09Woooooool08oooo`030000
<ol0<ol000@co`000`000?ooooooo`1_oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol0
00@co`000`000?ooooooo`1_oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol000@co`00
0`000?ooooooo`1_oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol000@co`000`000?oo
ooooo`1_oooo0021oooo00?o09Woooooool08oooo`030000<ol0<ol000@co`000`000?ooooooo`1_
oooo0021oooo00?o09Woooooool08oooo`800005<ol000<0003oooooool0Koooo`00POooo`03o`2I
oooooooo02?oool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00POooo`03o`2Ioooooooo
02?oool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00POooo`03o`2Ioooooooo02?oool0
0`0003?o03?o0004<ol000<0003oooooool0Koooo`00POooo`03o`2Ioooooooo02?oool00`0003?o
03?o0004<ol000<0003oooooool0Koooo`00POooo`03o`2Ioooooooo02?oool00`0003?o03?o0003
<ol000<0003oooooool0L?ooo`00POooo`03o`2Ioooooooo02?oool2000013?o00030000oooooooo
073oool0087oool00ol0VOooooooo`0Soooo00<0000co`0co`000c?o00030000oooooooo073oool0
087oool00ol0VOooooooo`0Soooo00<0000co`0co`000c?o00030000oooooooo073oool0087oool0
0ol0VOooooooo`0Soooo00<0000co`0co`000c?o00030000oooooooo073oool0087oool00ol0VOoo
ooooo`0Soooo00<0000co`0co`000c?o00030000oooooooo073oool0087oool00ol0VOooooooo`0M
oooo0`0000?oool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00POooo`03o`2Ioooooooo
01koool00`000?ooooooo`02oooo00<0000co`0co`000c?o00030000oooooooo073oool0087oool0
0ol0VOooooooo`0Koooo1@0000?oool300000c?o00030000oooooooo073oool009ooool010000?oo
ooooo`0000Coool6<ol0Loooo`00X?ooo`030000oooo000000Coool6<ol0Loooo`00XOooo`800004
oooo1S?o07?oool00:Ooool6<ol0Loooo`00Yoooo`Hco`1coooo001ioooo00<0003oooooool0:?oo
o`030000oooooooo00Hco`1coooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?oooc?o0005<ol0Loooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool500000_ooo`800004oooo0P0000Coool00`000?oooc?o0005<ol0Loooo`00N?ooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0
003oooooool01oooo`040000oooooooo00000oooo`030000oooo<ol000Dco`1coooo001goooo00<0
003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`07oooo00@0003oooooool00004
oooo00<0000co`0co`0013?o07?oool007Soool00`000?ooooooo`0500005?ooo`030000oooooooo
00Soool200001?ooo`030000oooo<ol000Dco`1coooo001hoooo00D0003oooooooooool000005ooo
o`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oooc?o0005<ol0Loooo`00NOoo
o`030000oooooooo01Ooool200002_ooo`800003oooo00<0003oooooool01S?o07?oool00:Ooool6
<ol0Loooo`00Yoooo`Hco`1coooo0000\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {438.813, 297.5}} -> {-0.349561, \
2.10527, 0.00349883, 0.00566123}, {{79.875, 308.563}, {438.813, 297.5}} -> \
{-5.53614, 10.7436, 0.0207442, 0.0319664}, {{79.875, 308.563}, {438.813, \
297.5}} -> {-5.53614, 10.7436, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.44268 .12361 L
.46172 .12361 L
.47106 .12361 L
.47567 .12361 L
.47791 .12361 L
.47889 .12361 L
.47994 .12361 L
s
.47994 .12361 m
.48043 .61803 L
s
0 .4 1 r
.02381 .12361 m
.04262 .12361 L
.06244 .12361 L
.08255 .12361 L
.08806 .12361 L
.09396 .12361 L
.09682 .12361 L
.09822 .12361 L
.09952 .12361 L
.1007 .12451 L
.10195 .1261 L
.10458 .12939 L
.14241 .16692 L
.16182 .18056 L
.1827 .1921 L
.20384 .20118 L
.22393 .20789 L
.24373 .21305 L
.26212 .21678 L
.28264 .21998 L
.30125 .22214 L
.3205 .22376 L
.33134 .22442 L
.34132 .22488 L
.34601 .22505 L
.35105 .2252 L
.35581 .22532 L
.36014 .2254 L
.36278 .22543 L
.36522 .22546 L
.3665 .22547 L
.3679 .22548 L
.36861 .22548 L
.36937 .22549 L
.37009 .22549 L
.37075 .22549 L
.37196 .22549 L
.37309 .22549 L
.37433 .22549 L
.37565 .22549 L
.37631 .22548 L
.37704 .22548 L
.37835 .22547 L
.3808 .22545 L
.38316 .22542 L
.38569 .22538 L
.39027 .22529 L
.39571 .22515 L
.40068 .22499 L
.41147 .22453 L
Mistroke
.42172 .22394 L
.44157 .22235 L
.45997 .22029 L
.47056 .2188 L
.47576 .21799 L
.47803 .21761 L
.47924 .21741 L
.48053 .21718 L
.48171 .12361 L
.48278 .12361 L
.48386 .12361 L
.48489 .12361 L
.48603 .12361 L
.48709 .12361 L
.48948 .12361 L
.49915 .12361 L
.53847 .12361 L
.57627 .12361 L
.59566 .12361 L
.59634 .12361 L
.59699 .12361 L
.59773 .12361 L
.59841 .12361 L
.59964 .12361 L
.60033 .12361 L
.60097 .12361 L
.60226 .12361 L
.60292 .12361 L
.60364 .12361 L
.60436 .12361 L
.60514 .12361 L
.60588 .12361 L
.60655 .12361 L
.60782 .12361 L
.609 .12361 L
.6103 .12361 L
.61095 .12361 L
.61167 .12361 L
.61288 .12361 L
.61417 .12361 L
.6154 .12361 L
.61653 .12361 L
.6178 .12361 L
.619 .12361 L
.62008 .12361 L
.62126 .12361 L
.62253 .12361 L
.62318 .12361 L
.62389 .12361 L
.62514 .12361 L
Mistroke
.62631 .12361 L
.62749 .12361 L
.62861 .12361 L
.62961 .12361 L
.6307 .12361 L
.63189 .12361 L
.63315 .12361 L
.63435 .12361 L
.63543 .12361 L
.63672 .12361 L
.63738 .12361 L
.63809 .12361 L
.63936 .12361 L
.64055 .12361 L
.64127 .12361 L
.64195 .12361 L
.64322 .12361 L
.64393 .12361 L
.64459 .12361 L
.64532 .12361 L
.64608 .12361 L
.64727 .12361 L
.64854 .12361 L
.64975 .12361 L
.65085 .12361 L
.65208 .12361 L
.65277 .12361 L
.65342 .12361 L
.65472 .12361 L
.65545 .12361 L
.65612 .12361 L
.65731 .12361 L
.65843 .12361 L
.65966 .12361 L
.66097 .12361 L
.66163 .12361 L
.66235 .12361 L
.66366 .12361 L
.66493 .12361 L
.66611 .12361 L
.66732 .12361 L
.66845 .12361 L
.66947 .12361 L
.67057 .12361 L
.67177 .12361 L
.67304 .12361 L
.67413 .12361 L
.67532 .12361 L
.67599 .12361 L
.67672 .12361 L
Mistroke
.67741 .12361 L
.67804 .12361 L
.67924 .12361 L
.68052 .12361 L
.68118 .12361 L
.68189 .12361 L
.68317 .12361 L
.68395 .12361 L
.68469 .12361 L
.68542 .12361 L
.68609 .12361 L
.68729 .12361 L
.68857 .12361 L
.68976 .12361 L
.69088 .12361 L
.69219 .12361 L
.6934 .12361 L
.69408 .12361 L
.69472 .12361 L
.69539 .12361 L
.69612 .12361 L
.69854 .12361 L
.69918 .12361 L
.69987 .12361 L
.70112 .12361 L
.70182 .12361 L
.70247 .12361 L
.70319 .12361 L
.70395 .12361 L
.7052 .12361 L
.70591 .12361 L
.70656 .12361 L
.70785 .12361 L
.70907 .12361 L
.71016 .12361 L
.71135 .12361 L
.71264 .12361 L
.71329 .12361 L
.71401 .12361 L
.71528 .12361 L
.71646 .12361 L
.71761 .12361 L
.71886 .12361 L
.72004 .12361 L
.72113 .12361 L
.72222 .12361 L
.7232 .12361 L
.72434 .12361 L
.72541 .12361 L
.72658 .12361 L
Mistroke
.72781 .12361 L
.72887 .12361 L
.73002 .12361 L
.73127 .12361 L
.73197 .12361 L
.73261 .12361 L
.73384 .12361 L
.73502 .12361 L
.73616 .12361 L
.73739 .12361 L
.73855 .12361 L
.73962 .12361 L
.7408 .12361 L
.74209 .12361 L
.74274 .12361 L
.74344 .12361 L
.74469 .12361 L
.74534 .12361 L
.74602 .12361 L
.74677 .12361 L
.74746 .12361 L
.7487 .12361 L
.74941 .12361 L
.75007 .12361 L
.7513 .12361 L
.75243 .12361 L
.75372 .12361 L
.75496 .12361 L
.77339 .12361 L
.78302 .12361 L
.78416 .12361 L
.78536 .12361 L
.78667 .12361 L
.78788 .12361 L
.78857 .12361 L
.78921 .12361 L
.78991 .12361 L
.79066 .12361 L
.79136 .12361 L
.79202 .12361 L
.79326 .12361 L
.79432 .12361 L
.79549 .12361 L
.79671 .12361 L
.79785 .12361 L
.79892 .12361 L
.79989 .12361 L
.80102 .12361 L
.80209 .12361 L
.80324 .12361 L
Mistroke
.80447 .12361 L
.80562 .12361 L
.80667 .12361 L
.80791 .12361 L
.8086 .12361 L
.80925 .12361 L
.81042 .12361 L
.81167 .12361 L
.81289 .12361 L
.81358 .12361 L
.81422 .12361 L
.81539 .12361 L
.81663 .12361 L
.81766 .12361 L
.81878 .12361 L
.82 .12361 L
.82115 .12361 L
.82239 .12361 L
.82308 .12361 L
.82373 .12361 L
.82505 .12361 L
.82579 .12361 L
.82645 .12361 L
.82765 .12361 L
.82895 .12361 L
.83018 .12361 L
.83131 .12361 L
.83237 .12361 L
.83351 .12361 L
.83458 .12361 L
.83556 .12361 L
.8367 .12361 L
.83795 .12361 L
.83913 .12361 L
.84022 .12361 L
.84146 .12361 L
.84262 .12361 L
.84366 .12361 L
.84479 .12361 L
.84602 .12361 L
.84732 .12361 L
.84843 .12361 L
.84965 .12361 L
.85096 .12361 L
.85217 .12361 L
.8528 .12361 L
.8535 .12361 L
.85423 .12361 L
.85491 .12361 L
.85616 .12361 L
Mistroke
.85731 .12361 L
.85863 .12361 L
.85989 .12361 L
.861 .12361 L
.86219 .12361 L
.86332 .12361 L
.86434 .12361 L
.86554 .12361 L
.86684 .12361 L
.86807 .12361 L
.8692 .12361 L
.87041 .12361 L
.87171 .12361 L
.87294 .12361 L
.87405 .12361 L
.87536 .12361 L
.8761 .12361 L
.87679 .12361 L
.87804 .12361 L
.87868 .12361 L
.87938 .12361 L
.88006 .12361 L
.88077 .12361 L
.88205 .12361 L
.88276 .12361 L
.88342 .12361 L
.88415 .12361 L
.88492 .12361 L
.8856 .12361 L
.88633 .12361 L
.88702 .12361 L
.88765 .12361 L
.88886 .12361 L
.89013 .12361 L
.89134 .12361 L
.89266 .12361 L
.8939 .12361 L
.89506 .12361 L
.8962 .12361 L
.89724 .12361 L
.89843 .12361 L
.89956 .12361 L
.90079 .12361 L
.90209 .12361 L
.90321 .12361 L
.90443 .12361 L
.90584 .12361 L
.90654 .12361 L
.90718 .12361 L
.90838 .12361 L
Mistroke
.90969 .12361 L
.91074 .12361 L
.91191 .12361 L
.91312 .12361 L
.91426 .12361 L
.91549 .12361 L
.91662 .12361 L
.91786 .12361 L
.91916 .12361 L
.92022 .12361 L
.92135 .12361 L
.92241 .12361 L
.92338 .12361 L
.92452 .12361 L
.92576 .12361 L
.92692 .12361 L
.928 .12361 L
.92925 .12361 L
.93044 .12361 L
.93151 .12361 L
.93268 .12361 L
.93394 .12361 L
.93465 .12361 L
.93529 .12361 L
.93653 .12361 L
.9377 .12361 L
.93881 .12361 L
.93998 .12361 L
.94098 .12361 L
.94207 .12361 L
.94325 .12361 L
.94451 .12361 L
.9457 .12361 L
.94678 .12361 L
.94806 .12361 L
.94871 .12361 L
.94943 .12361 L
.95069 .12361 L
.95187 .12361 L
.95258 .12361 L
.95326 .12361 L
.95453 .12361 L
.95524 .12361 L
.9559 .12361 L
.95662 .12361 L
.95739 .12361 L
.95869 .12361 L
.95943 .12361 L
.9601 .12361 L
.96134 .12361 L
Mistroke
.96266 .12361 L
.96383 .12361 L
.96493 .12361 L
.96614 .12361 L
.96743 .12361 L
.96855 .12361 L
.96958 .12361 L
.97072 .12361 L
.97193 .12361 L
.97297 .12361 L
.97395 .12361 L
.97503 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo01;oool00`1Vooooooooo`0Ioooo00<0
003oooooool0;Oooo`030000oooooooo013oool00`1Vooooooooo`0Joooo00<0000co`0co`00;C?o
00P0000Yoooo00<0003oooooool05Oooo`00;?ooo`0306Kooooooooo05_oool00`1Vooooooooo`0J
oooo00<0000co`0co`00:S?o00<00019oooo000]oooo00<0I_ooooooool0F_ooo`0306Kooooooooo
01[oool00`0003?o03?o000V<ol0100004coool002koool00`1Vooooooooo`1Ioooo00<0I_oooooo
ool06_ooo`030000<ol0<ol002@co`020000D?ooo`00;oooo`0306Kooooooooo05Soool00`1Voooo
ooooo`0Joooo00<0000co`0co`008c?o00030000oooooooo053oool0033oool00`1Vooooooooo`1G
oooo00<0I_ooooooool06_ooo`80000R<ol00P0005?oool0037oool00`1Vooooooooo`1Foooo00<0
I_ooooooool06_ooo`030000<ol0<ol001lco`020000EOooo`00<_ooo`0306Kooooooooo05Goool0
0`1Vooooooooo`0Joooo00<0000co`0co`007S?o00030000oooooooo05Goool003?oool00`1Voooo
ooooo`1Doooo00<0I_ooooooool06_ooo`030000<ol0<ol001dco`000`000?ooooooo`1Foooo000d
oooo00<0I_ooooooool0Doooo`0306Kooooooooo01[oool00`0003?o03?o000L<ol000<0003ooooo
ool0Eoooo`00=Oooo`0306Kooooooooo05;oool00`1Vooooooooo`0Joooo00<0000co`0co`006c?o
00030000oooooooo05Soool003Koool206KoD_ooo`0306Kooooooooo01[oool2000073?o00030000
oooooooo05Soool003Soool00`1Vooooooooo`1?oooo00<0I_ooooooool06_ooo`030000<ol0<ol0
01Xco`000`000?ooooooo`1Ioooo000ioooo00<0I_ooooooool0C_ooo`0306Kooooooooo01[oool0
0`0003?o03?o000I<ol000<0003oooooool0F_ooo`00>_ooo`80I_m>oooo00<0I_ooooooool06_oo
o`030000<ol0<ol001Pco`000`000?ooooooo`1Koooo000loooo0P1Vodcoool00`1Vooooooooo`0J
oooo00<0000co`0co`005c?o00030000oooooooo05coool003koool306KoBOooo`0306Kooooooooo
01[oool00`0003?o03?o000F<ol000<0003oooooool0GOooo`00@Oooo`80I_m7oooo00<0I_oooooo
ool06_ooo`80000G<ol000<0003oooooool0GOooo`00@oooo`<0I_m4oooo00<0I_ooooooool06_oo
o`030000<ol0<ol001Dco`000`000?ooooooo`1Noooo0016oooo0P1Vod;oool00`1Vooooooooo`0J
oooo00<0000co`0co`005C?o00030000oooooooo05koool004Soool406Ko?_ooo`0306Kooooooooo
01[oool00`0003?o03?o000E<ol000<0003oooooool0G_ooo`00C?ooo`D0I_lioooo00<0I_oooooo
ool06_ooo`030000<ol0<ol001@co`000`000?ooooooo`1Ooooo001Aoooo1@1Voc?oool206Ko7?oo
o`030000<ol0<ol001@co`000`000?ooooooo`1Ooooo001Foooo2@1Voaooool;06Ko00?ooooo09Wo
ool06oooo`80000D<ol000<0003oooooool0H?ooo`00Gooooal0I_l<oooo00?o09Woooooool06_oo
o`030000<ol0<ol001<co`000`000?ooooooo`1Poooo002:oooo00?o09Woooooool06_ooo`030000
<ol0<ol001<co`000`000?ooooooo`1Poooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol0
018co`000`000?ooooooo`1Qoooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol0018co`00
0`000?ooooooo`1Qoooo002:oooo00?o09Woooooool04_ooo`D00003oooo00<0000co`0co`004C?o
00030000oooooooo06;oool008[oool00ol0VOooooooo`0Doooo00<0003oooooool00oooo`030000
<ol0<ol0014co`000`000?ooooooo`1Roooo002:oooo00?o09Woooooool05?ooo`030000oooooooo
00?oool300004C?o00030000oooooooo06;oool008[oool00ol0VOooooooo`0Doooo00<0003ooooo
ool00oooo`030000<ol0<ol0010co`000`000?ooooooo`1Soooo002:oooo00?o09Woooooool05?oo
o`030000oooooooo00?oool00`0003?o03?o000@<ol000<0003oooooool0Hoooo`00R_ooo`03o`2I
oooooooo01?oool200001Oooo`030000<ol0<ol0010co`000`000?ooooooo`1Soooo002:oooo00?o
09Woooooool06_ooo`030000<ol0<ol0010co`000`000?ooooooo`1Soooo002:oooo00?o09Wooooo
ool06_ooo`030000<ol0<ol000lco`000`000?ooooooo`1Toooo002:oooo00?o09Woooooool06_oo
o`80000@<ol000<0003oooooool0I?ooo`00R_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000?
<ol000<0003oooooool0I?ooo`00R_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000?<ol000<0
003oooooool0I?ooo`00R_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000><ol000<0003ooooo
ool0IOooo`00R_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000><ol000<0003oooooool0IOoo
o`00R_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000><ol000<0003oooooool0IOooo`00R_oo
o`03o`2Ioooooooo01[oool200003c?o00030000oooooooo06Goool008[oool00ol0VOooooooo`0J
oooo00<0000co`0co`003C?o00030000oooooooo06Koool008[oool00ol0VOooooooo`0Joooo00<0
000co`0co`003C?o00030000oooooooo06Koool008[oool00ol0VOooooooo`0Joooo00<0000co`0c
o`003C?o00030000oooooooo06Koool008[oool00ol0VOooooooo`0Joooo00<0000co`0co`003C?o
00030000oooooooo06Koool008[oool00ol0VOooooooo`0Joooo00<0000co`0co`0033?o00030000
oooooooo06Ooool008[oool00ol0VOooooooo`0Joooo00<0000co`0co`0033?o00030000oooooooo
06Ooool008[oool00ol0VOooooooo`0Joooo0P0000dco`000`000?ooooooo`1Woooo002:oooo00?o
09Woooooool06_ooo`030000<ol0<ol000`co`000`000?ooooooo`1Woooo002:oooo00?o09Wooooo
ool06_ooo`030000<ol0<ol000/co`000`000?ooooooo`1Xoooo002:oooo00?o09Woooooool06_oo
o`030000<ol0<ol000/co`000`000?ooooooo`1Xoooo002:oooo00?o09Woooooool06_ooo`030000
<ol0<ol000/co`000`000?ooooooo`1Xoooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol0
00/co`000`000?ooooooo`1Xoooo002:oooo00?o09Woooooool06_ooo`80000<<ol000<0003ooooo
ool0J?ooo`00R_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000:<ol000<0003oooooool0JOoo
o`00R_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000:<ol000<0003oooooool0JOooo`00R_oo
o`03o`2Ioooooooo01[oool00`0003?o03?o000:<ol000<0003oooooool0JOooo`00R_ooo`03o`2I
oooooooo01;oool400001?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002:oooo00?o
09Woooooool04_ooo`030000oooooooo00Goool00`0003?o03?o000:<ol000<0003oooooool0JOoo
o`00R_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`04oooo0`0000Xco`000`000?ooooooo`1Y
oooo002:oooo00?o09Woooooool05?ooo`030000oooooooo00?oool00`0003?o03?o0009<ol000<0
003oooooool0J_ooo`00R_ooo`03o`2Ioooooooo01;oool010000?ooooooo`0000Coool00`0003?o
03?o0009<ol000<0003oooooool0J_ooo`00R_ooo`03o`2Ioooooooo01?oool200001Oooo`030000
<ol0<ol000Tco`000`000?ooooooo`1Zoooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol0
00Tco`000`000?ooooooo`1Zoooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`1Zoooo002:oooo00?o09Woooooool06_ooo`80000:<ol000<0003oooooool0J_oo
o`00R_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00R_oo
o`03o`2Ioooooooo01[oool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00R_ooo`03o`2I
oooooooo01[oool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00R_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00R_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o0008<ol000<0003oooooool0Joooo`00R_ooo`03o`2Ioooooooo01[oool00`0003?o
03?o0008<ol000<0003oooooool0Joooo`00R_ooo`03o`2Ioooooooo01[oool200002C?o00030000
oooooooo06_oool008[oool00ol0VOooooooo`0Joooo00<0000co`0co`0023?o00030000oooooooo
06_oool008[oool00ol0VOooooooo`0Joooo00<0000co`0co`001c?o00030000oooooooo06coool0
08[oool00ol0VOooooooo`0Joooo00<0000co`0co`001c?o00030000oooooooo06coool008[oool0
0ol0VOooooooo`0Joooo00<0000co`0co`001c?o00030000oooooooo06coool008[oool00ol0VOoo
ooooo`0Joooo00<0000co`0co`001c?o00030000oooooooo06coool008[oool00ol0VOooooooo`0J
oooo0P0000Pco`000`000?ooooooo`1/oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol0
00Lco`000`000?ooooooo`1/oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Lco`00
0`000?ooooooo`1/oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Lco`000`000?oo
ooooo`1/oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Lco`000`000?ooooooo`1/
oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002:
oooo00?o09Woooooool06_ooo`800007<ol000<0003oooooool0KOooo`00R_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00R_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o0006<ol000<0003oooooool0KOooo`00R_ooo`03o`2Ioooooooo01[oool00`0003?o
03?o0006<ol000<0003oooooool0KOooo`00R_ooo`03o`2Ioooooooo01?oool200001Oooo`030000
<ol0<ol000Hco`000`000?ooooooo`1]oooo002:oooo00?o09Woooooool04_ooo`040000oooooooo
00001?ooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002:oooo00?o09Woooooool05?oo
o`030000oooooooo00?oool300001S?o00030000oooooooo06goool008[oool00ol0VOooooooo`0E
oooo00<0003oooooool00_ooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002:oooo00?o
09Woooooool04_ooo`040000oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?ooooooo`1]
oooo002:oooo00?o09Woooooool04oooo`800005oooo00<0000co`0co`001S?o00030000oooooooo
06goool008[oool00ol0VOooooooo`0Joooo00<0000co`0co`001C?o00030000oooooooo06koool0
08[oool00ol0VOooooooo`0Joooo00<0000co`0co`001C?o00030000oooooooo06koool008[oool0
0ol0VOooooooo`0Joooo00<0000co`0co`001C?o00030000oooooooo06koool008[oool00ol0VOoo
ooooo`0Joooo0P0000Hco`000`000?ooooooo`1^oooo002:oooo00?o09Woooooool06_ooo`030000
<ol0<ol000Dco`000`000?ooooooo`1^oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol0
00Dco`000`000?ooooooo`1^oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Dco`00
0`000?ooooooo`1^oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Dco`000`000?oo
ooooo`1^oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000Dco`000`000?ooooooo`1^
oooo002:oooo00?o09Woooooool06_ooo`800006<ol000<0003oooooool0K_ooo`00R_ooo`03o`2I
oooooooo01[oool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00R_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00R_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o0004<ol000<0003oooooool0Koooo`00R_ooo`03o`2Ioooooooo01[oool00`0003?o
03?o0004<ol000<0003oooooool0Koooo`00R_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0004
<ol000<0003oooooool0Koooo`00R_ooo`03o`2Ioooooooo01[oool200001C?o00030000oooooooo
06ooool008[oool00ol0VOooooooo`0Joooo00<0000co`0co`0013?o00030000oooooooo06ooool0
08[oool00ol0VOooooooo`0Joooo00<0000co`0co`0013?o00030000oooooooo06ooool008[oool0
0ol0VOooooooo`0Joooo00<0000co`0co`0013?o00030000oooooooo06ooool008[oool00ol0VOoo
ooooo`0Joooo00<0000co`0co`0013?o00030000oooooooo06ooool008[oool00ol0VOooooooo`0J
oooo00<0000co`0co`000c?o00030000oooooooo073oool008[oool00ol0VOooooooo`0Joooo0P00
00@co`000`000?ooooooo`1`oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000<co`00
0`000?ooooooo`1`oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000<co`000`000?oo
ooooo`1`oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000<co`000`000?ooooooo`1`
oooo002:oooo00?o09Woooooool06_ooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002:
oooo00?o09Woooooool05?ooo`<00003oooo00<0000co`0co`000c?o00030000oooooooo073oool0
08[oool00ol0VOooooooo`0Eoooo00<0003oooooool00_ooo`030000<ol0<ol000<co`000`000?oo
ooooo`1`oooo002:oooo00?o09Woooooool04_ooo`D00003oooo0`0000<co`000`000?ooooooo`1`
oooo002Ooooo00@0003oooooool00004oooo1S?o07?oool00:3oool00`000?ooo`000004oooo1S?o
07?oool00:7oool200001?ooo`Hco`1coooo002Woooo1S?o07?oool00:Ooool6<ol0Loooo`00NOoo
o`030000oooooooo02Soool00`000?ooooooo`06<ol0Loooo`00N?ooo`030000oooooooo00Soool0
0`000?ooooooo`0Ooooo00<0003ooolco`001C?o07?oool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`0<oooo1@0000;oool200000oooo`<00004oooo00<0003ooolco`001C?o
07?oool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Coool400001Oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oooc?o0005
<ol0Loooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool01ooo
o`040000oooooooo00001?ooo`030000<ol0<ol000@co`1coooo001hoooo00<0003oooooool01@00
01Coool00`000?ooooooo`07oooo0`0000Coool00`000?oooc?o0005<ol0Loooo`00N?ooo`050000
oooooooooooo000001Ooool00`000?ooooooo`08oooo00<0003oooooool00oooo`030000oooo<ol0
00Dco`1coooo001ioooo00<0003oooooool05oooo`80000:oooo0`0000;oool00`000?ooooooo`06
<ol0Loooo`00Yoooo`Hco`1coooo002Woooo1S?o07?oool00001\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {587.5, 446.188}} -> {-0.349561, \
3.15746, 0.00349883, 0.00566123}, {{79.875, 308.563}, {587.5, 446.188}} -> \
{-5.53614, 16.6849, 0.0207442, 0.0319664}, {{79.875, 308.563}, {587.5, \
446.188}} -> {-5.53614, 16.6849, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.5095 .12361 L
.51441 .12361 L
.5168 .12361 L
.51784 .12361 L
.51896 .12361 L
s
.51896 .12361 m
.51948 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.08255 .12361 L
.10458 .12361 L
.11448 .12361 L
.12507 .12361 L
.1302 .12361 L
.13273 .12361 L
.13506 .12361 L
.13615 .12361 L
.13718 .12361 L
.13824 .1238 L
.13942 .12531 L
.14415 .13119 L
.16269 .15132 L
.18292 .16879 L
.20406 .18308 L
.22415 .1937 L
.24382 .20188 L
.26479 .20869 L
.2862 .21402 L
.30638 .21784 L
.32645 .22071 L
.34493 .22267 L
.36375 .22409 L
.37444 .22467 L
.38441 .22506 L
.38942 .22521 L
.39487 .22534 L
.39736 .22538 L
.40001 .22542 L
.40227 .22545 L
.40349 .22546 L
.40477 .22547 L
.40591 .22548 L
.40717 .22548 L
.40831 .22549 L
.40937 .22549 L
.41063 .22549 L
.41177 .22549 L
.41309 .22549 L
.41434 .22548 L
.41543 .22548 L
.41658 .22547 L
.41865 .22545 L
.42087 .22542 L
.42332 .22539 L
.42854 .22529 L
.43348 .22516 L
.44277 .22484 L
Mistroke
.45277 .22436 L
.46366 .22368 L
.48337 .22198 L
.50436 .21943 L
.50938 .21869 L
.51467 .21785 L
.51744 .21739 L
.5182 .21726 L
.51901 .21712 L
.51978 .12361 L
.52048 .12361 L
.52581 .12361 L
.54599 .12361 L
.58589 .12361 L
.59018 .12361 L
.59251 .12361 L
.59365 .12361 L
.59468 .12361 L
.59583 .12361 L
.59704 .12361 L
.59768 .12361 L
.59837 .12361 L
.59962 .12361 L
.60077 .12361 L
.60198 .12361 L
.60301 .12361 L
.60415 .12361 L
.60484 .12361 L
.6055 .12361 L
.60674 .12361 L
.60743 .12361 L
.60807 .12361 L
.60877 .12361 L
.60952 .12361 L
.61075 .12361 L
.6119 .12361 L
.61317 .12361 L
.61388 .12361 L
.61454 .12361 L
.61571 .12361 L
.6168 .12361 L
.618 .12361 L
.61928 .12361 L
.61992 .12361 L
.62062 .12361 L
.62189 .12361 L
.62313 .12361 L
.62427 .12361 L
.62541 .12361 L
.62664 .12361 L
Mistroke
.62779 .12361 L
.62885 .12361 L
.63009 .12361 L
.63079 .12361 L
.63144 .12361 L
.63263 .12361 L
.63389 .12361 L
.63454 .12361 L
.63522 .12361 L
.63596 .12361 L
.63665 .12361 L
.63788 .12361 L
.63859 .12361 L
.63924 .12361 L
.64046 .12361 L
.64158 .12361 L
.64287 .12361 L
.64409 .12361 L
.64529 .12361 L
.64598 .12361 L
.64662 .12361 L
.64792 .12361 L
.64865 .12361 L
.64932 .12361 L
.65045 .12361 L
.65168 .12361 L
.65296 .12361 L
.65416 .12361 L
.65484 .12361 L
.65559 .12361 L
.65629 .12361 L
.65693 .12361 L
.65816 .12361 L
.65945 .12361 L
.66075 .12361 L
.66148 .12361 L
.66215 .12361 L
.66293 .12361 L
.66368 .12361 L
.66436 .12361 L
.66511 .12361 L
.66576 .12361 L
.66645 .12361 L
.66767 .12361 L
.669 .12361 L
.66975 .12361 L
.67044 .12361 L
.67169 .12361 L
.67287 .12361 L
.67352 .12361 L
Mistroke
.67423 .12361 L
.67546 .12361 L
.67659 .12361 L
.67783 .12361 L
.67912 .12361 L
.68033 .12361 L
.68147 .12361 L
.6825 .12361 L
.6837 .12361 L
.68483 .12361 L
.68615 .12361 L
.68735 .12361 L
.68802 .12361 L
.68873 .12361 L
.69004 .12361 L
.69126 .12361 L
.69255 .12361 L
.69366 .12361 L
.69487 .12361 L
.6956 .12361 L
.6963 .12361 L
.6976 .12361 L
.69833 .12361 L
.69901 .12361 L
.69975 .12361 L
.70053 .12361 L
.70183 .12361 L
.70305 .12361 L
.70375 .12361 L
.70438 .12361 L
.70509 .12361 L
.70583 .12361 L
.70706 .12361 L
.70771 .12361 L
.7084 .12361 L
.70966 .12361 L
.71082 .12361 L
.71194 .12361 L
.71298 .12361 L
.71413 .12361 L
.71536 .12361 L
.71667 .12361 L
.71741 .12361 L
.7181 .12361 L
.71935 .12361 L
.72005 .12361 L
.72069 .12361 L
.7219 .12361 L
.7232 .12361 L
.72443 .12361 L
Mistroke
.72556 .12361 L
.72662 .12361 L
.72776 .12361 L
.72884 .12361 L
.72982 .12361 L
.73097 .12361 L
.73222 .12361 L
.7334 .12361 L
.73449 .12361 L
.73561 .12361 L
.73667 .12361 L
.73782 .12361 L
.73907 .12361 L
.7403 .12361 L
.7416 .12361 L
.74271 .12361 L
.74392 .12361 L
.74457 .12361 L
.74525 .12361 L
.74647 .12361 L
.74778 .12361 L
.74852 .12361 L
.74922 .12361 L
.75048 .12361 L
.75163 .12361 L
.75227 .12361 L
.75296 .12361 L
.75422 .12361 L
.75533 .12361 L
.75657 .12361 L
.75786 .12361 L
.75907 .12361 L
.76019 .12361 L
.76123 .12361 L
.76236 .12361 L
.76356 .12361 L
.76487 .12361 L
.76606 .12361 L
.76672 .12361 L
.76744 .12361 L
.76874 .12361 L
.76996 .12361 L
.77125 .12361 L
.77235 .12361 L
.77357 .12361 L
.7743 .12361 L
.77499 .12361 L
.77629 .12361 L
.77702 .12361 L
.77769 .12361 L
Mistroke
.77843 .12361 L
.77922 .12361 L
.77991 .12361 L
.78065 .12361 L
.78136 .12361 L
.782 .12361 L
.78323 .12361 L
.78452 .12361 L
.78574 .12361 L
.78643 .12361 L
.78707 .12361 L
.78824 .12361 L
.78948 .12361 L
.79059 .12361 L
.79163 .12361 L
.79277 .12361 L
.794 .12361 L
.79524 .12361 L
.79594 .12361 L
.79659 .12361 L
.7979 .12361 L
.79858 .12361 L
.79931 .12361 L
.80062 .12361 L
.80185 .12361 L
.80306 .12361 L
.80417 .12361 L
.80522 .12361 L
.80636 .12361 L
.80743 .12361 L
.80841 .12361 L
.80955 .12361 L
.8108 .12361 L
.81198 .12361 L
.81307 .12361 L
.81431 .12361 L
.81547 .12361 L
.81651 .12361 L
.81764 .12361 L
.81887 .12361 L
.82017 .12361 L
.82128 .12361 L
.8225 .12361 L
.82381 .12361 L
.82502 .12361 L
.82566 .12361 L
.82635 .12361 L
.82708 .12361 L
.82776 .12361 L
.82901 .12361 L
Mistroke
.83016 .12361 L
.83148 .12361 L
.83274 .12361 L
.83385 .12361 L
.83505 .12361 L
.83617 .12361 L
.83719 .12361 L
.83839 .12361 L
.8397 .12361 L
.84092 .12361 L
.84206 .12361 L
.84327 .12361 L
.84456 .12361 L
.84579 .12361 L
.8469 .12361 L
.84821 .12361 L
.84895 .12361 L
.84964 .12361 L
.85089 .12361 L
.85153 .12361 L
.85223 .12361 L
.85291 .12361 L
.85362 .12361 L
.8549 .12361 L
.85561 .12361 L
.85627 .12361 L
.857 .12361 L
.85778 .12361 L
.85845 .12361 L
.85918 .12361 L
.85987 .12361 L
.8605 .12361 L
.86171 .12361 L
.86299 .12361 L
.86419 .12361 L
.86551 .12361 L
.86675 .12361 L
.86791 .12361 L
.86905 .12361 L
.87009 .12361 L
.87128 .12361 L
.87241 .12361 L
.87374 .12361 L
.87498 .12361 L
.87627 .12361 L
.87696 .12361 L
.87769 .12361 L
.87899 .12361 L
.88023 .12361 L
.88134 .12361 L
Mistroke
.88254 .12361 L
.8836 .12361 L
.88476 .12361 L
.88597 .12361 L
.88711 .12361 L
.88817 .12361 L
.88915 .12361 L
.89022 .12361 L
.89134 .12361 L
.89248 .12361 L
.89369 .12361 L
.89484 .12361 L
.89588 .12361 L
.89711 .12361 L
.8978 .12361 L
.89844 .12361 L
.89961 .12361 L
.90085 .12361 L
.90206 .12361 L
.90338 .12361 L
.90463 .12361 L
.90579 .12361 L
.90694 .12361 L
.90797 .12361 L
.90917 .12361 L
.9103 .12361 L
.91154 .12361 L
.91284 .12361 L
.91396 .12361 L
.91518 .12361 L
.91649 .12361 L
.91723 .12361 L
.9179 .12361 L
.91921 .12361 L
.92044 .12361 L
.9215 .12361 L
.92266 .12361 L
.92387 .12361 L
.92501 .12361 L
.92607 .12361 L
.92704 .12361 L
.92816 .12361 L
.92923 .12361 L
.93037 .12361 L
.93159 .12361 L
.93274 .12361 L
.93379 .12361 L
.93502 .12361 L
.93571 .12361 L
.93635 .12361 L
Mistroke
.93752 .12361 L
.93876 .12361 L
.93996 .12361 L
.94127 .12361 L
.94251 .12361 L
.94365 .12361 L
.94468 .12361 L
.94581 .12361 L
.94699 .12361 L
.9481 .12361 L
.94933 .12361 L
.95062 .12361 L
.95172 .12361 L
.95292 .12361 L
.95422 .12361 L
.95495 .12361 L
.95561 .12361 L
.9569 .12361 L
.95812 .12361 L
.95916 .12361 L
.96031 .12361 L
.96151 .12361 L
.96263 .12361 L
.96368 .12361 L
.96464 .12361 L
.96574 .12361 L
.96679 .12361 L
.96792 .12361 L
.96912 .12361 L
.97026 .12361 L
.97129 .12361 L
.9725 .12361 L
.97381 .12361 L
.97505 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<00000I_oo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo01coool00`1Vooooooooo`0?oooo00<0
003oooooool0;Oooo`030000oooooooo01[oool00`1Vooooooooo`0@oooo00<0000co`0co`00;C?o
00P0000Yoooo00<0003oooooool05Oooo`00=_ooo`0306Kooooooooo05_oool00`1Vooooooooo`0@
oooo00<0000co`0co`00:S?o00<00019oooo000goooo00<0I_ooooooool0F_ooo`0306Kooooooooo
013oool00`0003?o03?o000V<ol0100004coool003Ooool00`1Vooooooooo`1Joooo00<0I_oooooo
ool04?ooo`030000<ol0<ol002@co`020000D?ooo`00>?ooo`0306Kooooooooo05Woool00`1Voooo
ooooo`0@oooo00<0000co`0co`008c?o00030000oooooooo053oool003Woool00`1Vooooooooo`1H
oooo00<0I_ooooooool04?ooo`80000R<ol00P0005?oool003[oool00`1Vooooooooo`1Goooo00<0
I_ooooooool04?ooo`030000<ol0<ol001lco`020000EOooo`00>oooo`0306Kooooooooo05Koool0
0`1Vooooooooo`0@oooo00<0000co`0co`007S?o00030000oooooooo05Goool003coool206KoE_oo
o`0306Kooooooooo013oool00`0003?o03?o000M<ol000<0003oooooool0E_ooo`00?_ooo`0306Ko
oooooooo05?oool00`1Vooooooooo`0@oooo00<0000co`0co`0073?o00030000oooooooo05Ooool0
03ooool00`1Vooooooooo`1Boooo00<0I_ooooooool04?ooo`030000<ol0<ol001/co`000`000?oo
ooooo`1Hoooo0010oooo0P1Voe;oool00`1Vooooooooo`0@oooo0P0001`co`000`000?ooooooo`1H
oooo0012oooo0P1Voe3oool00`1Vooooooooo`0@oooo00<0000co`0co`006S?o00030000oooooooo
05Woool004Coool00`1Vooooooooo`1=oooo00<0I_ooooooool04?ooo`030000<ol0<ol001Tco`00
0`000?ooooooo`1Joooo0015oooo0P1Vodgoool00`1Vooooooooo`0@oooo00<0000co`0co`0063?o
00030000oooooooo05_oool004Ooool206KoBoooo`0306Kooooooooo013oool00`0003?o03?o000G
<ol000<0003oooooool0G?ooo`00BOooo`80I_m9oooo00<0I_ooooooool04?ooo`030000<ol0<ol0
01Hco`000`000?ooooooo`1Moooo001;oooo0P1VodOoool00`1Vooooooooo`0@oooo0P0001Lco`00
0`000?ooooooo`1Moooo001=oooo0`1VodCoool00`1Vooooooooo`0@oooo00<0000co`0co`005C?o
00030000oooooooo05koool0053oool206Ko@_ooo`0306Kooooooooo013oool00`0003?o03?o000E
<ol000<0003oooooool0G_ooo`00D_ooo`@0I_lnoooo00<0I_ooooooool04?ooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1Noooo001Foooo1P1VocSoool00`1Vooooooooo`0@oooo00<0000co`0c
o`0053?o00030000oooooooo05ooool005coool506Ko<_ooo`80I_lBoooo00<0000co`0co`0053?o
00030000oooooooo05ooool0067oool506Ko8oooo`X0I_l00oooool0VOooo`0Aoooo0P0001@co`00
0`000?ooooooo`1Poooo001Voooo8`1Vo`_oool00ol0VOooooooo`0@oooo00<0000co`0co`004c?o
00030000oooooooo063oool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`004c?o00030000
oooooooo063oool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`004S?o00030000oooooooo
067oool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`004S?o00030000oooooooo067oool0
09Coool00ol0VOooooooo`08oooo1@0000?oool00`0003?o03?o000A<ol000<0003oooooool0H_oo
o`00U?ooo`03o`2Ioooooooo00[oool00`000?ooooooo`03oooo00<0000co`0co`004C?o00030000
oooooooo06;oool009Coool00ol0VOooooooo`0:oooo00<0003oooooool00oooo`<0000A<ol000<0
003oooooool0H_ooo`00U?ooo`03o`2Ioooooooo00[oool00`000?ooooooo`03oooo00<0000co`0c
o`0043?o00030000oooooooo06?oool009Coool00ol0VOooooooo`0:oooo00<0003oooooool00ooo
o`030000<ol0<ol0010co`000`000?ooooooo`1Soooo002Doooo00?o09Woooooool02Oooo`800005
oooo00<0000co`0co`0043?o00030000oooooooo06?oool009Coool00ol0VOooooooo`0@oooo00<0
000co`0co`0043?o00030000oooooooo06?oool009Coool00ol0VOooooooo`0@oooo00<0000co`0c
o`003c?o00030000oooooooo06Coool009Coool00ol0VOooooooo`0@oooo0P00010co`000`000?oo
ooooo`1Toooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol000lco`000`000?ooooooo`1T
oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol000lco`000`000?ooooooo`1Toooo002D
oooo00?o09Woooooool04?ooo`030000<ol0<ol000hco`000`000?ooooooo`1Uoooo002Doooo00?o
09Woooooool04?ooo`030000<ol0<ol000hco`000`000?ooooooo`1Uoooo002Doooo00?o09Wooooo
ool04?ooo`030000<ol0<ol000hco`000`000?ooooooo`1Uoooo002Doooo00?o09Woooooool04?oo
o`80000?<ol000<0003oooooool0IOooo`00U?ooo`03o`2Ioooooooo013oool00`0003?o03?o000=
<ol000<0003oooooool0I_ooo`00U?ooo`03o`2Ioooooooo013oool00`0003?o03?o000=<ol000<0
003oooooool0I_ooo`00U?ooo`03o`2Ioooooooo013oool00`0003?o03?o000=<ol000<0003ooooo
ool0I_ooo`00U?ooo`03o`2Ioooooooo013oool00`0003?o03?o000=<ol000<0003oooooool0I_oo
o`00U?ooo`03o`2Ioooooooo013oool00`0003?o03?o000<<ol000<0003oooooool0Ioooo`00U?oo
o`03o`2Ioooooooo013oool00`0003?o03?o000<<ol000<0003oooooool0Ioooo`00U?ooo`03o`2I
oooooooo013oool200003C?o00030000oooooooo06Ooool009Coool00ol0VOooooooo`0@oooo00<0
000co`0co`0033?o00030000oooooooo06Ooool009Coool00ol0VOooooooo`0@oooo00<0000co`0c
o`002c?o00030000oooooooo06Soool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`002c?o
00030000oooooooo06Soool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`002c?o00030000
oooooooo06Soool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`002c?o00030000oooooooo
06Soool009Coool00ol0VOooooooo`0@oooo0P0000`co`000`000?ooooooo`1Xoooo002Doooo00?o
09Woooooool04?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Doooo00?o09Wooooo
ool04?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Doooo00?o09Woooooool04?oo
o`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Doooo00?o09Woooooool02?ooo`@00004
oooo00<0000co`0co`002S?o00030000oooooooo06Woool009Coool00ol0VOooooooo`08oooo00<0
003oooooool01Oooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Doooo00?o09Wooooo
ool02Oooo`030000oooooooo00Coool300002S?o00030000oooooooo06Woool009Coool00ol0VOoo
ooooo`0:oooo00<0003oooooool00oooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo002D
oooo00?o09Woooooool02?ooo`040000oooooooo00001?ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`1Zoooo002Doooo00?o09Woooooool02Oooo`800005oooo00<0000co`0co`002C?o00030000
oooooooo06[oool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`002C?o00030000oooooooo
06[oool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`002C?o00030000oooooooo06[oool0
09Coool00ol0VOooooooo`0@oooo0P0000Xco`000`000?ooooooo`1Zoooo002Doooo00?o09Wooooo
ool04?ooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo002Doooo00?o09Woooooool04?oo
o`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo002Doooo00?o09Woooooool04?ooo`030000
<ol0<ol000Pco`000`000?ooooooo`1[oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol0
00Pco`000`000?ooooooo`1[oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`1[oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol000Pco`000`000?oo
ooooo`1[oooo002Doooo00?o09Woooooool04?ooo`800009<ol000<0003oooooool0Joooo`00U?oo
o`03o`2Ioooooooo013oool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00U?ooo`03o`2I
oooooooo013oool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00U?ooo`03o`2Ioooooooo
013oool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00U?ooo`03o`2Ioooooooo013oool0
0`0003?o03?o0007<ol000<0003oooooool0K?ooo`00U?ooo`03o`2Ioooooooo013oool00`0003?o
03?o0007<ol000<0003oooooool0K?ooo`00U?ooo`03o`2Ioooooooo013oool2000023?o00030000
oooooooo06coool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`001c?o00030000oooooooo
06coool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`001c?o00030000oooooooo06coool0
09Coool00ol0VOooooooo`0@oooo00<0000co`0co`001c?o00030000oooooooo06coool009Coool0
0ol0VOooooooo`0@oooo00<0000co`0co`001c?o00030000oooooooo06coool009Coool00ol0VOoo
ooooo`0@oooo00<0000co`0co`001c?o00030000oooooooo06coool009Coool00ol0VOooooooo`0@
oooo0P0000Lco`000`000?ooooooo`1]oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1]oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1]oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1]oooo002Doooo00?o09Woooooool02Oooo`800005oooo00<0000co`0co`001S?o00030000
oooooooo06goool009Coool00ol0VOooooooo`08oooo00@0003oooooool00004oooo00<0000co`0c
o`001S?o00030000oooooooo06goool009Coool00ol0VOooooooo`0:oooo00<0003oooooool00ooo
o`<00006<ol000<0003oooooool0KOooo`00U?ooo`03o`2Ioooooooo00_oool00`000?ooooooo`02
oooo00<0000co`0co`001S?o00030000oooooooo06goool009Coool00ol0VOooooooo`08oooo00@0
003oooooool00004oooo00<0000co`0co`001S?o00030000oooooooo06goool009Coool00ol0VOoo
ooooo`09oooo0P0000Goool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00U?ooo`03o`2I
oooooooo013oool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00U?ooo`03o`2Ioooooooo
013oool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00U?ooo`03o`2Ioooooooo013oool0
0`0003?o03?o0005<ol000<0003oooooool0K_ooo`00U?ooo`03o`2Ioooooooo013oool200001S?o
00030000oooooooo06koool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`001C?o00030000
oooooooo06koool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`001C?o00030000oooooooo
06koool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`001C?o00030000oooooooo06koool0
09Coool00ol0VOooooooo`0@oooo00<0000co`0co`001C?o00030000oooooooo06koool009Coool0
0ol0VOooooooo`0@oooo00<0000co`0co`001C?o00030000oooooooo06koool009Coool00ol0VOoo
ooooo`0@oooo0P0000Hco`000`000?ooooooo`1^oooo002Doooo00?o09Woooooool04?ooo`030000
<ol0<ol000@co`000`000?ooooooo`1_oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol0
00@co`000`000?ooooooo`1_oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol000@co`00
0`000?ooooooo`1_oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol000@co`000`000?oo
ooooo`1_oooo002Doooo00?o09Woooooool04?ooo`030000<ol0<ol000@co`000`000?ooooooo`1_
oooo002Doooo00?o09Woooooool04?ooo`800005<ol000<0003oooooool0Koooo`00U?ooo`03o`2I
oooooooo013oool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00U?ooo`03o`2Ioooooooo
013oool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00U?ooo`03o`2Ioooooooo013oool0
0`0003?o03?o0004<ol000<0003oooooool0Koooo`00U?ooo`03o`2Ioooooooo013oool00`0003?o
03?o0004<ol000<0003oooooool0Koooo`00U?ooo`03o`2Ioooooooo013oool00`0003?o03?o0003
<ol000<0003oooooool0L?ooo`00U?ooo`03o`2Ioooooooo013oool2000013?o00030000oooooooo
073oool009Coool00ol0VOooooooo`0@oooo00<0000co`0co`000c?o00030000oooooooo073oool0
09Coool00ol0VOooooooo`0@oooo00<0000co`0co`000c?o00030000oooooooo073oool009Coool0
0ol0VOooooooo`0@oooo00<0000co`0co`000c?o00030000oooooooo073oool009Coool00ol0VOoo
ooooo`0@oooo00<0000co`0co`000c?o00030000oooooooo073oool009Coool00ol0VOooooooo`0:
oooo0`0000?oool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00U?ooo`03o`2Ioooooooo
00_oool00`000?ooooooo`02oooo00<0000co`0co`000c?o00030000oooooooo073oool009Coool0
0ol0VOooooooo`08oooo1@0000?oool300000c?o00030000oooooooo073oool009ooool010000?oo
ooooo`0000Coool6<ol0Loooo`00X?ooo`030000oooo000000Coool6<ol0Loooo`00XOooo`800004
oooo1S?o07?oool00:Ooool6<ol0Loooo`00Yoooo`Hco`1coooo001ioooo00<0003oooooool0:?oo
o`030000oooooooo00Hco`1coooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?oooc?o0005<ol0Loooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool500000_ooo`800005oooo0`0000;oool00`000?oooc?o0005<ol0Loooo`00N?ooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0
003oooooool02_ooo`060000oooooooooooo0000oooo1S?o07?oool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Ooool500000oooo`030000<ol0<ol000@co`1c
oooo001hoooo00<0003oooooool01@0001Coool00`000?ooooooo`07oooo00@0003oooooool00003
oooo00<0003ooolco`001C?o07?oool007Soool01@000?ooooooooooo`00000Goooo00<0003ooooo
ool02?ooo`030000oooo000000?oool00`000?oooc?o0005<ol0Loooo`00NOooo`030000oooooooo
01Ooool200002oooo`800002oooo00<0003oooooool01S?o07?oool00:Ooool6<ol0Loooo`00Yooo
o`Hco`1coooo0000\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {204.5, 63.1875}} -> {-0.349561, \
0.447144, 0.00349883, 0.00566123}, {{79.875, 308.563}, {204.5, 63.1875}} -> \
{-5.53614, 1.38097, 0.0207442, 0.0319664}, {{79.875, 308.563}, {204.5, \
63.1875}} -> {-5.53614, 1.38097, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.52059 .12361 L
.53984 .12361 L
.54934 .12361 L
.55195 .12361 L
.55338 .12361 L
.55472 .12361 L
.55598 .12361 L
.55669 .12361 L
s
.55669 .12361 m
.55695 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.12507 .12361 L
.14415 .12361 L
.16254 .12361 L
.16783 .12361 L
.17044 .12361 L
.17284 .12361 L
.17502 .12361 L
.17612 .12361 L
.17733 .12508 L
.18221 .13115 L
.20325 .15367 L
.2225 .16991 L
.2426 .18335 L
.26127 .19324 L
.28025 .20127 L
.30098 .20814 L
.3215 .2134 L
.34011 .2171 L
.35935 .22005 L
.36928 .22127 L
.38017 .22241 L
.40011 .22398 L
.411 .22459 L
.42118 .22502 L
.42618 .22518 L
.43163 .22531 L
.43412 .22536 L
.43677 .2254 L
.43906 .22543 L
.44153 .22546 L
.44268 .22547 L
.4439 .22548 L
.44494 .22548 L
.44608 .22549 L
.44715 .22549 L
.44829 .22549 L
.44937 .22549 L
.45035 .22549 L
.4516 .22549 L
.45275 .22548 L
.45402 .22547 L
.45536 .22546 L
.45761 .22544 L
.46008 .22541 L
.4653 .22532 L
.47025 .2252 L
.47953 .22489 L
Mistroke
.48953 .22443 L
.50042 .22377 L
.52014 .22212 L
.54112 .21962 L
.54614 .21889 L
.55143 .21807 L
.5542 .21761 L
.55496 .21749 L
.55577 .21735 L
.55654 .21722 L
.55724 .12361 L
.55855 .12361 L
.55998 .12361 L
.56257 .12361 L
.5672 .12361 L
.56846 .12361 L
.56979 .12361 L
.57093 .12361 L
.57217 .12361 L
.57289 .12361 L
.57354 .12361 L
.575 .12361 L
.57764 .12361 L
.58276 .12361 L
.58765 .12361 L
.59023 .12361 L
.59164 .12361 L
.59295 .12361 L
.5941 .12361 L
.59534 .12361 L
.59604 .12361 L
.59671 .12361 L
.59796 .12361 L
.59911 .12361 L
.60017 .12361 L
.60133 .12361 L
.60257 .12361 L
.60378 .12361 L
.60505 .12361 L
.60571 .12361 L
.60644 .12361 L
.60772 .12361 L
.60893 .12361 L
.61022 .12361 L
.61145 .12361 L
.61256 .12361 L
.61324 .12361 L
.61397 .12361 L
.61528 .12361 L
.616 .12361 L
Mistroke
.61668 .12361 L
.61743 .12361 L
.61823 .12361 L
.61892 .12361 L
.61967 .12361 L
.62103 .12361 L
.62167 .12361 L
.62236 .12361 L
.62359 .12361 L
.62483 .12361 L
.62554 .12361 L
.6262 .12361 L
.62689 .12361 L
.62753 .12361 L
.62826 .12361 L
.62895 .12361 L
.63018 .12361 L
.63132 .12361 L
.63256 .12361 L
.63319 .12361 L
.63389 .12361 L
.63459 .12361 L
.63533 .12361 L
.63665 .12361 L
.63734 .12361 L
.63807 .12361 L
.63888 .12361 L
.63963 .12361 L
.64033 .12361 L
.64108 .12361 L
.64179 .12361 L
.64245 .12361 L
.6437 .12361 L
.64502 .12361 L
.64627 .12361 L
.64741 .12361 L
.64873 .12361 L
.64998 .12361 L
.65114 .12361 L
.65221 .12361 L
.65337 .12361 L
.65463 .12361 L
.65535 .12361 L
.65601 .12361 L
.65731 .12361 L
.6585 .12361 L
.65975 .12361 L
.6604 .12361 L
.66109 .12361 L
.66234 .12361 L
Mistroke
.66311 .12361 L
.66384 .12361 L
.66449 .12361 L
.66519 .12361 L
.66642 .12361 L
.66754 .12361 L
.66883 .12361 L
.67006 .12361 L
.67119 .12361 L
.67224 .12361 L
.67339 .12361 L
.67463 .12361 L
.67533 .12361 L
.67598 .12361 L
.67726 .12361 L
.67843 .12361 L
.67966 .12361 L
.68098 .12361 L
.68221 .12361 L
.68292 .12361 L
.68357 .12361 L
.68431 .12361 L
.68502 .12361 L
.68623 .12361 L
.68691 .12361 L
.68756 .12361 L
.68885 .12361 L
.68952 .12361 L
.69025 .12361 L
.69148 .12361 L
.69277 .12361 L
.69397 .12361 L
.69509 .12361 L
.69577 .12361 L
.69652 .12361 L
.69722 .12361 L
.69786 .12361 L
.69909 .12361 L
.70039 .12361 L
.70106 .12361 L
.70178 .12361 L
.70308 .12361 L
.70388 .12361 L
.70463 .12361 L
.70531 .12361 L
.70605 .12361 L
.7067 .12361 L
.70738 .12361 L
.70861 .12361 L
.70993 .12361 L
Mistroke
.71067 .12361 L
.71137 .12361 L
.71264 .12361 L
.71379 .12361 L
.71443 .12361 L
.71512 .12361 L
.71638 .12361 L
.71751 .12361 L
.71875 .12361 L
.72004 .12361 L
.72125 .12361 L
.72238 .12361 L
.72342 .12361 L
.72455 .12361 L
.72575 .12361 L
.72707 .12361 L
.72826 .12361 L
.72893 .12361 L
.72964 .12361 L
.73095 .12361 L
.73217 .12361 L
.73346 .12361 L
.73456 .12361 L
.73578 .12361 L
.73651 .12361 L
.7372 .12361 L
.73851 .12361 L
.73924 .12361 L
.74003 .12361 L
.7407 .12361 L
.74144 .12361 L
.74274 .12361 L
.74397 .12361 L
.74466 .12361 L
.7453 .12361 L
.746 .12361 L
.74673 .12361 L
.76666 .12361 L
.76771 .12361 L
.76884 .12361 L
.76991 .12361 L
.77089 .12361 L
.77198 .12361 L
.77301 .12361 L
.77414 .12361 L
.77536 .12361 L
.77659 .12361 L
.7779 .12361 L
.77914 .12361 L
.78027 .12361 L
Mistroke
.78139 .12361 L
.7826 .12361 L
.78374 .12361 L
.7848 .12361 L
.786 .12361 L
.78713 .12361 L
.78837 .12361 L
.78906 .12361 L
.78969 .12361 L
.79096 .12361 L
.79163 .12361 L
.79235 .12361 L
.79365 .12361 L
.79486 .12361 L
.79598 .12361 L
.79719 .12361 L
.79834 .12361 L
.79938 .12361 L
.80054 .12361 L
.80181 .12361 L
.80246 .12361 L
.80314 .12361 L
.80437 .12361 L
.80569 .12361 L
.80635 .12361 L
.80708 .12361 L
.80787 .12361 L
.80861 .12361 L
.80933 .12361 L
.81002 .12361 L
.81066 .12361 L
.81136 .12361 L
.81259 .12361 L
.81328 .12361 L
.81402 .12361 L
.81471 .12361 L
.81534 .12361 L
.81663 .12361 L
.81781 .12361 L
.81911 .12361 L
.81977 .12361 L
.82048 .12361 L
.82169 .12361 L
.82298 .12361 L
.8242 .12361 L
.82531 .12361 L
.8265 .12361 L
.82761 .12361 L
.82883 .12361 L
.83014 .12361 L
Mistroke
.83079 .12361 L
.83151 .12361 L
.83281 .12361 L
.83408 .12361 L
.83526 .12361 L
.83645 .12361 L
.83759 .12361 L
.8386 .12361 L
.8397 .12361 L
.8409 .12361 L
.84217 .12361 L
.84325 .12361 L
.84444 .12361 L
.84511 .12361 L
.84583 .12361 L
.84715 .12361 L
.84843 .12361 L
.84962 .12361 L
.8509 .12361 L
.85163 .12361 L
.85232 .12361 L
.85299 .12361 L
.8537 .12361 L
.85447 .12361 L
.85518 .12361 L
.85638 .12361 L
.85766 .12361 L
.85887 .12361 L
.85997 .12361 L
.86127 .12361 L
.862 .12361 L
.86267 .12361 L
.86391 .12361 L
.86522 .12361 L
.86642 .12361 L
.86774 .12361 L
.86899 .12361 L
.87014 .12361 L
.87128 .12361 L
.87232 .12361 L
.87352 .12361 L
.87464 .12361 L
.87588 .12361 L
.87718 .12361 L
.87829 .12361 L
.87951 .12361 L
.88082 .12361 L
.88156 .12361 L
.88223 .12361 L
.88354 .12361 L
Mistroke
.88477 .12361 L
.88582 .12361 L
.88698 .12361 L
.88819 .12361 L
.88933 .12361 L
.89039 .12361 L
.89136 .12361 L
.89242 .12361 L
.89354 .12361 L
.89469 .12361 L
.89591 .12361 L
.89706 .12361 L
.8981 .12361 L
.89933 .12361 L
.90002 .12361 L
.90066 .12361 L
.90184 .12361 L
.90308 .12361 L
.90429 .12361 L
.90561 .12361 L
.90686 .12361 L
.90802 .12361 L
.90914 .12361 L
.91034 .12361 L
.91148 .12361 L
.91253 .12361 L
.91379 .12361 L
.91511 .12361 L
.91624 .12361 L
.91745 .12361 L
.91874 .12361 L
.91994 .12361 L
.92068 .12361 L
.92137 .12361 L
.92267 .12361 L
.92382 .12361 L
.92489 .12361 L
.92601 .12361 L
.92724 .12361 L
.9283 .12361 L
.92927 .12361 L
.93039 .12361 L
.93146 .12361 L
.93259 .12361 L
.93367 .12361 L
.9349 .12361 L
.93602 .12361 L
.93726 .12361 L
.93791 .12361 L
.9386 .12361 L
Mistroke
.93985 .12361 L
.94099 .12361 L
.94212 .12361 L
.94335 .12361 L
.94444 .12361 L
.94559 .12361 L
.94662 .12361 L
.94777 .12361 L
.94875 .12361 L
.94978 .12361 L
.951 .12361 L
.95212 .12361 L
.95332 .12361 L
.95464 .12361 L
.95586 .12361 L
.95702 .12361 L
.95815 .12361 L
.9592 .12361 L
.96019 .12361 L
.96124 .12361 L
.96229 .12361 L
.96345 .12361 L
.96458 .12361 L
.9658 .12361 L
.96695 .12361 L
.968 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Goool00`1Vooooooooo`06oooo00<0
003oooooool0;Oooo`030000oooooooo02?oool00`1Vooooooooo`07oooo00<0000co`0co`00;C?o
00P0000Yoooo00<0003oooooool05Oooo`00?oooo`0306Kooooooooo05_oool00`1Vooooooooo`07
oooo00<0000co`0co`00:S?o00<00019oooo0010oooo00<0I_ooooooool0F_ooo`0306Kooooooooo
00Ooool00`0003?o03?o000V<ol0100004coool0047oool00`1Vooooooooo`1Ioooo00<0I_oooooo
ool01oooo`030000<ol0<ol002@co`020000D?ooo`00@_ooo`0306Kooooooooo05Soool00`1Voooo
ooooo`07oooo00<0000co`0co`008c?o00030000oooooooo053oool004?oool00`1Vooooooooo`1G
oooo00<0I_ooooooool01oooo`80000R<ol00P0005?oool004Coool00`1Vooooooooo`1Foooo00<0
I_ooooooool01oooo`030000<ol0<ol001lco`020000EOooo`00AOooo`0306Kooooooooo05Goool0
0`1Vooooooooo`07oooo00<0000co`0co`007S?o00030000oooooooo05Goool004Koool206KoEOoo
o`0306Kooooooooo00Ooool00`0003?o03?o000M<ol000<0003oooooool0E_ooo`00B?ooo`0306Ko
oooooooo05;oool00`1Vooooooooo`07oooo00<0000co`0co`0073?o00030000oooooooo05Ooool0
04Woool00`1Vooooooooo`1Aoooo00<0I_ooooooool01oooo`030000<ol0<ol001/co`000`000?oo
ooooo`1Hoooo001:oooo00<0I_ooooooool0D?ooo`0306Kooooooooo00Ooool2000073?o00030000
oooooooo05Soool004_oool206KoD?ooo`0306Kooooooooo00Ooool00`0003?o03?o000J<ol000<0
003oooooool0FOooo`00COooo`0306Kooooooooo04goool00`1Vooooooooo`07oooo00<0000co`0c
o`006C?o00030000oooooooo05[oool004koool00`1Vooooooooo`1<oooo00<0I_ooooooool01ooo
o`030000<ol0<ol001Pco`000`000?ooooooo`1Koooo001?oooo0P1Vodcoool00`1Vooooooooo`07
oooo00<0000co`0co`005c?o00030000oooooooo05coool0057oool306KoBOooo`0306Kooooooooo
00Ooool00`0003?o03?o000F<ol000<0003oooooool0GOooo`00E?ooo`80I_m7oooo00<0I_oooooo
ool01oooo`80000G<ol000<0003oooooool0GOooo`00E_ooo`<0I_m4oooo00<0I_ooooooool01ooo
o`030000<ol0<ol001Dco`000`000?ooooooo`1Noooo001Ioooo0`1Vod7oool00`1Vooooooooo`07
oooo00<0000co`0co`005C?o00030000oooooooo05koool005coool406Ko?Oooo`0306Kooooooooo
00Ooool00`0003?o03?o000E<ol000<0003oooooool0G_ooo`00H?ooo`@0I_lioooo00<0I_oooooo
ool01oooo`030000<ol0<ol001@co`000`000?ooooooo`1Ooooo001Toooo1@1Voc?oool206Ko2Ooo
o`030000<ol0<ol001@co`000`000?ooooooo`1Ooooo001Yoooo2`1Voakoool:06Ko00?ooooo09Wo
ool02?ooo`80000D<ol000<0003oooooool0H?ooo`00M?oooah0I_l;oooo00?o09Woooooool01ooo
o`030000<ol0<ol001<co`000`000?ooooooo`1Poooo002Moooo00?o09Woooooool01oooo`030000
<ol0<ol001<co`000`000?ooooooo`1Poooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol0
018co`000`000?ooooooo`1Qoooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol0018co`00
0`000?ooooooo`1Qoooo002Moooo00?o09Woool00000100000?oool00`0003?o03?o000A<ol000<0
003oooooool0H_ooo`00WOooo`05o`2Ioooooooooooo000000Goool00`0003?o03?o000A<ol000<0
003oooooool0H_ooo`00WOooo`05o`2Ioooooooooooo000000Goool300004C?o00030000oooooooo
06;oool009goool01Ol0VOooooooooooo`000005oooo00<0000co`0co`0043?o00030000oooooooo
06?oool009goool01Ol0VOooooooooooo`000005oooo00<0000co`0co`0043?o00030000oooooooo
06?oool009goool00ol0VOooooooo`0200001Oooo`030000<ol0<ol0010co`000`000?ooooooo`1S
oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol0010co`000`000?ooooooo`1Soooo002M
oooo00?o09Woooooool01oooo`030000<ol0<ol000lco`000`000?ooooooo`1Toooo002Moooo00?o
09Woooooool01oooo`80000@<ol000<0003oooooool0I?ooo`00WOooo`03o`2Ioooooooo00Ooool0
0`0003?o03?o000?<ol000<0003oooooool0I?ooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o
03?o000?<ol000<0003oooooool0I?ooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o03?o000>
<ol000<0003oooooool0IOooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o03?o000><ol000<0
003oooooool0IOooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o03?o000><ol000<0003ooooo
ool0IOooo`00WOooo`03o`2Ioooooooo00Ooool200003c?o00030000oooooooo06Goool009goool0
0ol0VOooooooo`07oooo00<0000co`0co`003C?o00030000oooooooo06Koool009goool00ol0VOoo
ooooo`07oooo00<0000co`0co`003C?o00030000oooooooo06Koool009goool00ol0VOooooooo`07
oooo00<0000co`0co`003C?o00030000oooooooo06Koool009goool00ol0VOooooooo`07oooo00<0
000co`0co`003C?o00030000oooooooo06Koool009goool00ol0VOooooooo`07oooo00<0000co`0c
o`0033?o00030000oooooooo06Ooool009goool00ol0VOooooooo`07oooo00<0000co`0co`0033?o
00030000oooooooo06Ooool009goool00ol0VOooooooo`07oooo0P0000dco`000`000?ooooooo`1W
oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000`co`000`000?ooooooo`1Woooo002M
oooo00?o09Woooooool01oooo`030000<ol0<ol000/co`000`000?ooooooo`1Xoooo002Moooo00?o
09Woooooool01oooo`030000<ol0<ol000/co`000`000?ooooooo`1Xoooo002Moooo00?o09Wooooo
ool01oooo`030000<ol0<ol000/co`000`000?ooooooo`1Xoooo002Moooo00?o09Woooooool01ooo
o`030000<ol0<ol000/co`000`000?ooooooo`1Xoooo002Moooo00?o09Woooooool01oooo`80000<
<ol000<0003oooooool0J?ooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o03?o000:<ol000<0
003oooooool0JOooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o03?o000:<ol000<0003ooooo
ool0JOooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o03?o000:<ol000<0003oooooool0JOoo
o`00WOooo`03o`2Ioooo000000<00004oooo00<0000co`0co`002S?o00030000oooooooo06Woool0
09goool00ol0VOooo`000007oooo00<0000co`0co`002S?o00030000oooooooo06Woool009goool0
1?l0VOooooooo`0000Koool300002S?o00030000oooooooo06Woool009goool01Ol0VOoooooooooo
o`000005oooo00<0000co`0co`002C?o00030000oooooooo06[oool009goool00ol0VOooo`000002
oooo00<0003oooooool00_ooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo002Moooo00?o
09Woooooool00P0000Goool00`0003?o03?o0009<ol000<0003oooooool0J_ooo`00WOooo`03o`2I
oooooooo00Ooool00`0003?o03?o0009<ol000<0003oooooool0J_ooo`00WOooo`03o`2Ioooooooo
00Ooool00`0003?o03?o0009<ol000<0003oooooool0J_ooo`00WOooo`03o`2Ioooooooo00Ooool2
00002S?o00030000oooooooo06[oool009goool00ol0VOooooooo`07oooo00<0000co`0co`0023?o
00030000oooooooo06_oool009goool00ol0VOooooooo`07oooo00<0000co`0co`0023?o00030000
oooooooo06_oool009goool00ol0VOooooooo`07oooo00<0000co`0co`0023?o00030000oooooooo
06_oool009goool00ol0VOooooooo`07oooo00<0000co`0co`0023?o00030000oooooooo06_oool0
09goool00ol0VOooooooo`07oooo00<0000co`0co`0023?o00030000oooooooo06_oool009goool0
0ol0VOooooooo`07oooo00<0000co`0co`0023?o00030000oooooooo06_oool009goool00ol0VOoo
ooooo`07oooo0P0000Tco`000`000?ooooooo`1[oooo002Moooo00?o09Woooooool01oooo`030000
<ol0<ol000Pco`000`000?ooooooo`1[oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol0
00Lco`000`000?ooooooo`1/oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000Lco`00
0`000?ooooooo`1/oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000Lco`000`000?oo
ooooo`1/oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000Lco`000`000?ooooooo`1/
oooo002Moooo00?o09Woooooool01oooo`800008<ol000<0003oooooool0K?ooo`00WOooo`03o`2I
oooooooo00Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00WOooo`03o`2Ioooooooo
00Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00WOooo`03o`2Ioooooooo00Ooool0
0`0003?o03?o0007<ol000<0003oooooool0K?ooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o
03?o0007<ol000<0003oooooool0K?ooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o03?o0007
<ol000<0003oooooool0K?ooo`00WOooo`03o`2Ioooooooo00Ooool200001c?o00030000oooooooo
06goool009goool00ol0VOooooooo`07oooo00<0000co`0co`001S?o00030000oooooooo06goool0
09goool00ol0VOooooooo`07oooo00<0000co`0co`001S?o00030000oooooooo06goool009goool0
0ol0VOooooooo`07oooo00<0000co`0co`001S?o00030000oooooooo06goool009goool00ol0VOoo
ooooo`0200001Oooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002Moooo00?o09Woool0
00000_ooo`030000oooooooo00;oool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00WOoo
o`05o`2Ioooooooooooo000000Goool300001S?o00030000oooooooo06goool009goool00ol0VOoo
ooooo`02oooo00<0003oooooool00_ooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002M
oooo00?o09Woool000000_ooo`030000oooooooo00;oool00`0003?o03?o0006<ol000<0003ooooo
ool0KOooo`00WOooo`03o`2Ioooooooo00800005oooo00<0000co`0co`001S?o00030000oooooooo
06goool009goool00ol0VOooooooo`07oooo00<0000co`0co`001C?o00030000oooooooo06koool0
09goool00ol0VOooooooo`07oooo00<0000co`0co`001C?o00030000oooooooo06koool009goool0
0ol0VOooooooo`07oooo00<0000co`0co`001C?o00030000oooooooo06koool009goool00ol0VOoo
ooooo`07oooo0P0000Hco`000`000?ooooooo`1^oooo002Moooo00?o09Woooooool01oooo`030000
<ol0<ol000Dco`000`000?ooooooo`1^oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol0
00Dco`000`000?ooooooo`1^oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000Dco`00
0`000?ooooooo`1^oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000Dco`000`000?oo
ooooo`1^oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000Dco`000`000?ooooooo`1^
oooo002Moooo00?o09Woooooool01oooo`800006<ol000<0003oooooool0K_ooo`00WOooo`03o`2I
oooooooo00Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00WOooo`03o`2Ioooooooo
00Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00WOooo`03o`2Ioooooooo00Ooool0
0`0003?o03?o0004<ol000<0003oooooool0Koooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o
03?o0004<ol000<0003oooooool0Koooo`00WOooo`03o`2Ioooooooo00Ooool00`0003?o03?o0004
<ol000<0003oooooool0Koooo`00WOooo`03o`2Ioooooooo00Ooool200001C?o00030000oooooooo
06ooool009goool00ol0VOooooooo`07oooo00<0000co`0co`0013?o00030000oooooooo06ooool0
09goool00ol0VOooooooo`07oooo00<0000co`0co`0013?o00030000oooooooo06ooool009goool0
0ol0VOooooooo`07oooo00<0000co`0co`0013?o00030000oooooooo06ooool009goool00ol0VOoo
ooooo`07oooo00<0000co`0co`0013?o00030000oooooooo06ooool009goool00ol0VOooooooo`07
oooo00<0000co`0co`000c?o00030000oooooooo073oool009goool00ol0VOooooooo`07oooo0P00
00@co`000`000?ooooooo`1`oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1`oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1`oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000<co`000`000?ooooooo`1`
oooo002Moooo00?o09Woooooool01oooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002M
oooo00Co09Woooooooooool300000oooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002M
oooo00?o09Woooooool00_ooo`030000oooooooo00;oool00`0003?o03?o0003<ol000<0003ooooo
ool0L?ooo`00WOooo`03o`2Ioooo000000@00003oooo0`0000<co`000`000?ooooooo`1`oooo002O
oooo00@0003oooooool00004oooo1S?o07?oool00:3oool00`000?ooo`000004oooo1S?o07?oool0
0:7oool200001?ooo`Hco`1coooo002Woooo1S?o07?oool00:Ooool6<ol0Loooo`00NOooo`030000
oooooooo02Soool00`000?ooooooo`06<ol0Loooo`00N?ooo`030000oooooooo00Soool00`000?oo
ooooo`0Ooooo00<0003ooolco`001C?o07?oool007Soool00`000?ooooooo`02oooo0P0000Coool0
0`000?ooooooo`0<oooo1@0000;oool200000oooo`@00003oooo00<0003ooolco`001C?o07?oool0
07Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool4
00001Oooo`030000oooooooo00Ooool00`000?ooooooo`04oooo00<0003ooolco`001C?o07?oool0
07Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000oooooooo00Soool00`000?oo
ooooo`04oooo00<0000co`0co`0013?o07?oool007Soool00`000?ooooooo`0500005?ooo`030000
oooooooo00Woool00`000?ooooooo`02oooo00<0003ooolco`001C?o07?oool007Soool01@000?oo
ooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooo<ol0
00Dco`1coooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?ooooooo`06
<ol0Loooo`00Yoooo`Hco`1coooo002Woooo1S?o07?oool00001\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {353.188, 211.875}} -> {-0.349561, \
1.49934, 0.00349883, 0.00566123}, {{79.875, 308.563}, {353.188, 211.875}} -> \
{-5.53614, 7.32223, 0.0207442, 0.0319664}, {{79.875, 308.563}, {353.188, \
211.875}} -> {-5.53614, 7.32223, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59536 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20178 .12361 L
.20742 .12361 L
.21019 .12361 L
.2114 .12361 L
.21274 .12361 L
.21394 .12361 L
.21506 .12461 L
.21753 .12773 L
.22272 .13402 L
.24125 .15359 L
.26149 .17058 L
.28262 .18447 L
.30271 .19479 L
.32239 .20275 L
.34336 .20936 L
.36477 .21453 L
.38494 .21823 L
.40502 .221 L
.42349 .22288 L
.43258 .2236 L
.44232 .22423 L
.453 .22477 L
.46298 .22514 L
.46826 .22528 L
.47315 .22538 L
.4757 .22542 L
.47852 .22545 L
.47993 .22546 L
.48146 .22547 L
.48216 .22548 L
.4829 .22548 L
.48422 .22549 L
.48548 .22549 L
.48663 .22549 L
.48795 .22549 L
.4892 .22549 L
.49035 .22548 L
.49142 .22548 L
.49383 .22546 L
.49626 .22543 L
.49893 .2254 L
.50434 .2253 L
.50955 .22517 L
.5145 .22501 L
.52379 .22462 L
Mistroke
.53378 .22408 L
.54468 .22332 L
.56439 .22147 L
.57533 .22015 L
.58538 .21872 L
.5904 .21793 L
.59292 .21751 L
.59361 .21739 L
.59435 .21726 L
.59505 .21714 L
.59569 .12361 L
.59638 .12361 L
.59712 .12361 L
.59843 .12361 L
.59917 .12361 L
.59997 .12361 L
.60072 .12361 L
.60141 .12361 L
.60267 .12361 L
.60399 .12361 L
.60469 .12361 L
.60535 .12361 L
.60606 .12361 L
.60683 .12361 L
.60749 .12361 L
.60819 .12361 L
.60944 .12361 L
.61014 .12361 L
.61079 .12361 L
.61151 .12361 L
.61228 .12361 L
.61294 .12361 L
.61365 .12361 L
.61496 .12361 L
.61623 .12361 L
.61741 .12361 L
.61855 .12361 L
.61962 .12361 L
.6208 .12361 L
.62206 .12361 L
.6227 .12361 L
.6234 .12361 L
.62466 .12361 L
.62588 .12361 L
.62701 .12361 L
.62817 .12361 L
.6294 .12361 L
.63062 .12361 L
.63131 .12361 L
.63196 .12361 L
Mistroke
.63312 .12361 L
.63418 .12361 L
.6354 .12361 L
.63657 .12361 L
.63782 .12361 L
.63853 .12361 L
.63916 .12361 L
.6404 .12361 L
.64157 .12361 L
.64223 .12361 L
.64294 .12361 L
.64419 .12361 L
.64485 .12361 L
.64554 .12361 L
.64631 .12361 L
.64703 .12361 L
.64771 .12361 L
.64844 .12361 L
.64974 .12361 L
.65047 .12361 L
.65115 .12361 L
.65189 .12361 L
.6527 .12361 L
.6534 .12361 L
.65406 .12361 L
.65475 .12361 L
.6555 .12361 L
.65674 .12361 L
.65743 .12361 L
.65806 .12361 L
.65936 .12361 L
.66055 .12361 L
.66185 .12361 L
.66251 .12361 L
.66324 .12361 L
.66445 .12361 L
.66576 .12361 L
.66699 .12361 L
.66812 .12361 L
.66941 .12361 L
.67063 .12361 L
.67174 .12361 L
.67291 .12361 L
.67418 .12361 L
.67536 .12361 L
.67662 .12361 L
.67733 .12361 L
.678 .12361 L
.67919 .12361 L
.68032 .12361 L
Mistroke
.68133 .12361 L
.68242 .12361 L
.68362 .12361 L
.68488 .12361 L
.68597 .12361 L
.68716 .12361 L
.68782 .12361 L
.68854 .12361 L
.68985 .12361 L
.69113 .12361 L
.69232 .12361 L
.69304 .12361 L
.69372 .12361 L
.695 .12361 L
.69572 .12361 L
.69638 .12361 L
.6971 .12361 L
.69787 .12361 L
.69906 .12361 L
.70034 .12361 L
.70155 .12361 L
.70265 .12361 L
.70394 .12361 L
.70467 .12361 L
.70534 .12361 L
.70658 .12361 L
.7079 .12361 L
.70904 .12361 L
.71026 .12361 L
.71141 .12361 L
.71246 .12361 L
.71364 .12361 L
.71475 .12361 L
.71596 .12361 L
.71726 .12361 L
.7179 .12361 L
.71859 .12361 L
.71932 .12361 L
.72 .12361 L
.72122 .12361 L
.72253 .12361 L
.72383 .12361 L
.72506 .12361 L
.72616 .12361 L
.72736 .12361 L
.7286 .12361 L
.72977 .12361 L
.73082 .12361 L
.73195 .12361 L
.73319 .12361 L
Mistroke
.7345 .12361 L
.73563 .12361 L
.73684 .12361 L
.73798 .12361 L
.73901 .12361 L
.74005 .12361 L
.74104 .12361 L
.74218 .12361 L
.74324 .12361 L
.74441 .12361 L
.74564 .12361 L
.74678 .12361 L
.74803 .12361 L
.74933 .12361 L
.75054 .12361 L
.75168 .12361 L
.75271 .12361 L
.7539 .12361 L
.75503 .12361 L
.75626 .12361 L
.75755 .12361 L
.75866 .12361 L
.75988 .12361 L
.76119 .12361 L
.76193 .12361 L
.7626 .12361 L
.7639 .12361 L
.76514 .12361 L
.76619 .12361 L
.76734 .12361 L
.76855 .12361 L
.76968 .12361 L
.77074 .12361 L
.77171 .12361 L
.77277 .12361 L
.77389 .12361 L
.77503 .12361 L
.77625 .12361 L
.7774 .12361 L
.77845 .12361 L
.77967 .12361 L
.78037 .12361 L
.78101 .12361 L
.78218 .12361 L
.78343 .12361 L
.78463 .12361 L
.78595 .12361 L
.78719 .12361 L
.78835 .12361 L
.78949 .12361 L
Mistroke
.79052 .12361 L
.79172 .12361 L
.79284 .12361 L
.79408 .12361 L
.79538 .12361 L
.79649 .12361 L
.79771 .12361 L
.79902 .12361 L
.79976 .12361 L
.80043 .12361 L
.80173 .12361 L
.80297 .12361 L
.80402 .12361 L
.80518 .12361 L
.80639 .12361 L
.80752 .12361 L
.80858 .12361 L
.80955 .12361 L
.81062 .12361 L
.81174 .12361 L
.81288 .12361 L
.8141 .12361 L
.81525 .12361 L
.81629 .12361 L
.81752 .12361 L
.81821 .12361 L
.81885 .12361 L
.82003 .12361 L
.82127 .12361 L
.82248 .12361 L
.8238 .12361 L
.82505 .12361 L
.82621 .12361 L
.82735 .12361 L
.82839 .12361 L
.82959 .12361 L
.83071 .12361 L
.83195 .12361 L
.83325 .12361 L
.83437 .12361 L
.83559 .12361 L
.8369 .12361 L
.83764 .12361 L
.83831 .12361 L
.83962 .12361 L
.84085 .12361 L
.8419 .12361 L
.84307 .12361 L
.84428 .12361 L
.84542 .12361 L
Mistroke
.84648 .12361 L
.84745 .12361 L
.84857 .12361 L
.84963 .12361 L
.85077 .12361 L
.85199 .12361 L
.85314 .12361 L
.85419 .12361 L
.85542 .12361 L
.85611 .12361 L
.85675 .12361 L
.85793 .12361 L
.85917 .12361 L
.86038 .12361 L
.86107 .12361 L
.86171 .12361 L
.86412 .12361 L
.86525 .12361 L
.86631 .12361 L
.86741 .12361 L
.86863 .12361 L
.86987 .12361 L
.87118 .12361 L
.8723 .12361 L
.87352 .12361 L
.87484 .12361 L
.87557 .12361 L
.87625 .12361 L
.87755 .12361 L
.87879 .12361 L
.87984 .12361 L
.88101 .12361 L
.88222 .12361 L
.88336 .12361 L
.88442 .12361 L
.88539 .12361 L
.88651 .12361 L
.88758 .12361 L
.88872 .12361 L
.88994 .12361 L
.8911 .12361 L
.89214 .12361 L
.89337 .12361 L
.89406 .12361 L
.8947 .12361 L
.89587 .12361 L
.89711 .12361 L
.89834 .12361 L
.89903 .12361 L
.89966 .12361 L
Mistroke
.90084 .12361 L
.90208 .12361 L
.90319 .12361 L
.90423 .12361 L
.90537 .12361 L
.9066 .12361 L
.90784 .12361 L
.90854 .12361 L
.90919 .12361 L
.91051 .12361 L
.91124 .12361 L
.91191 .12361 L
.91311 .12361 L
.91441 .12361 L
.91564 .12361 L
.91677 .12361 L
.91783 .12361 L
.91897 .12361 L
.92004 .12361 L
.92102 .12361 L
.92216 .12361 L
.92341 .12361 L
.92459 .12361 L
.92568 .12361 L
.92692 .12361 L
.92808 .12361 L
.92913 .12361 L
.93025 .12361 L
.93149 .12361 L
.93279 .12361 L
.9339 .12361 L
.93511 .12361 L
.93643 .12361 L
.93764 .12361 L
.93827 .12361 L
.93897 .12361 L
.9397 .12361 L
.94038 .12361 L
.94163 .12361 L
.94278 .12361 L
.94341 .12361 L
.9441 .12361 L
.94536 .12361 L
.94659 .12361 L
.9477 .12361 L
.94898 .12361 L
.95019 .12361 L
.95132 .12361 L
.95235 .12361 L
.95348 .12361 L
Mistroke
.95468 .12361 L
.95598 .12361 L
.95717 .12361 L
.95783 .12361 L
.95854 .12361 L
.95984 .12361 L
.96106 .12361 L
.96235 .12361 L
.96345 .12361 L
.96466 .12361 L
.96535 .12361 L
.96608 .12361 L
.96738 .12361 L
.96811 .12361 L
.96878 .12361 L
.96952 .12361 L
.97031 .12361 L
.971 .12361 L
.97174 .12361 L
.97244 .12361 L
.97309 .12361 L
.97432 .12361 L
.97562 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02koool00`00001Vooooo`0]oooo00<0
003oooooool0;Oooo`030000<ol0<ol002dco`080000:Oooo`030000oooooooo01Goool004Woool0
0`1Vooooooooo`1Koooo00<0000co`0co`00:S?o00<00019oooo001:oooo00<0I_ooooooool0F_oo
o`030000<ol0<ol002Hco`040000C?ooo`00Boooo`0306Kooooooooo05Woool00`0003?o03?o000T
<ol00P00053oool004_oool00`1Vooooooooo`1Ioooo00<0000co`0co`008c?o00030000oooooooo
053oool004coool00`1Vooooooooo`1Hoooo0P00028co`020000Doooo`00COooo`0306Kooooooooo
05Ooool00`0003?o03?o000O<ol00P0005Goool004koool00`1Vooooooooo`1Foooo00<0000co`0c
o`007S?o00030000oooooooo05Goool004ooool206KoE_ooo`030000<ol0<ol001dco`000`000?oo
ooooo`1Foooo001Aoooo00<0I_ooooooool0Doooo`030000<ol0<ol001`co`000`000?ooooooo`1G
oooo001Boooo00<0I_ooooooool0D_ooo`030000<ol0<ol001/co`000`000?ooooooo`1Hoooo001C
oooo0P1Voe;oool2000073?o00030000oooooooo05Soool005Goool00`1Vooooooooo`1?oooo00<0
000co`0co`006S?o00030000oooooooo05Woool005Koool206KoCoooo`030000<ol0<ol001Tco`00
0`000?ooooooo`1Joooo001Hoooo0P1Vodgoool00`0003?o03?o000H<ol000<0003oooooool0Fooo
o`00F_ooo`80I_m;oooo00<0000co`0co`005c?o00030000oooooooo05coool005coool306KoB?oo
o`030000<ol0<ol001Hco`000`000?ooooooo`1Moooo001Ooooo0P1VodKoool200005c?o00030000
oooooooo05goool0067oool306Ko@oooo`030000<ol0<ol001Dco`000`000?ooooooo`1Noooo001T
oooo0P1Vod7oool00`0003?o03?o000E<ol000<0003oooooool0G_ooo`00I_ooo`@0I_lmoooo00<0
000co`0co`005C?o00030000oooooooo05koool006[oool606Ko=oooo`030000<ol0<ol001@co`00
0`000?ooooooo`1Ooooo001`oooo1@1Voc7oool00`1Vo`0003?o000E<ol000<0003oooooool0Gooo
o`00MOooo`D0I_lSoooo2@1Vo`03oooo0000000001@co`000`000?ooooooo`1Poooo001joooo8`1V
o`[oool00`0003?o03?o000C<ol000<0003oooooool0H?ooo`00Yoooo`030000<ol0<ol001<co`00
0`000?ooooooo`1Poooo002Woooo00<0000co`0co`004S?o00030000oooooooo067oool00:Ooool0
0`0003?o03?o000B<ol000<0003oooooool0HOooo`00Woooo`D00003oooo00<0000co`0co`004C?o
00030000oooooooo06;oool00:7oool00`000?ooooooo`03oooo00<0000co`0co`004C?o00030000
oooooooo06;oool00:7oool00`000?ooooooo`03oooo0`00014co`000`000?ooooooo`1Roooo002Q
oooo00<0003oooooool00oooo`030000<ol0<ol0010co`000`000?ooooooo`1Soooo002Qoooo00<0
003oooooool00oooo`030000<ol0<ol0010co`000`000?ooooooo`1Soooo002Poooo0P0000Goool0
0`0003?o03?o000@<ol000<0003oooooool0Hoooo`00Yoooo`030000<ol0<ol0010co`000`000?oo
ooooo`1Soooo002Woooo00<0000co`0co`003c?o00030000oooooooo06Coool00:Ooool2000043?o
00030000oooooooo06Coool00:Ooool00`0003?o03?o000?<ol000<0003oooooool0I?ooo`00Yooo
o`030000<ol0<ol000lco`000`000?ooooooo`1Toooo002Woooo00<0000co`0co`003S?o00030000
oooooooo06Goool00:Ooool00`0003?o03?o000><ol000<0003oooooool0IOooo`00Yoooo`030000
<ol0<ol000hco`000`000?ooooooo`1Uoooo002Woooo0P0000lco`000`000?ooooooo`1Uoooo002W
oooo00<0000co`0co`003C?o00030000oooooooo06Koool00:Ooool00`0003?o03?o000=<ol000<0
003oooooool0I_ooo`00Yoooo`030000<ol0<ol000dco`000`000?ooooooo`1Voooo002Woooo00<0
000co`0co`003C?o00030000oooooooo06Koool00:Ooool00`0003?o03?o000<<ol000<0003ooooo
ool0Ioooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`1Woooo002Woooo0P0000dco`00
0`000?ooooooo`1Woooo002Woooo00<0000co`0co`0033?o00030000oooooooo06Ooool00:Ooool0
0`0003?o03?o000;<ol000<0003oooooool0J?ooo`00Yoooo`030000<ol0<ol000/co`000`000?oo
ooooo`1Xoooo002Woooo00<0000co`0co`002c?o00030000oooooooo06Soool00:Ooool00`0003?o
03?o000;<ol000<0003oooooool0J?ooo`00Yoooo`80000<<ol000<0003oooooool0J?ooo`00Yooo
o`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Woooo00<0000co`0co`002S?o00030000
oooooooo06Woool00:Ooool00`0003?o03?o000:<ol000<0003oooooool0JOooo`00Woooo`@00004
oooo00<0000co`0co`002S?o00030000oooooooo06Woool009ooool00`000?ooooooo`05oooo00<0
000co`0co`002S?o00030000oooooooo06Woool00:3oool00`000?ooooooo`04oooo0`0000Xco`00
0`000?ooooooo`1Yoooo002Qoooo00<0003oooooool00oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`1Zoooo002Ooooo00@0003oooooool00004oooo00<0000co`0co`002C?o00030000oooooooo
06[oool00:3oool200001Oooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo002Woooo00<0
000co`0co`002C?o00030000oooooooo06[oool00:Ooool00`0003?o03?o0009<ol000<0003ooooo
ool0J_ooo`00Yoooo`80000:<ol000<0003oooooool0J_ooo`00Yoooo`030000<ol0<ol000Pco`00
0`000?ooooooo`1[oooo002Woooo00<0000co`0co`0023?o00030000oooooooo06_oool00:Ooool0
0`0003?o03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000<ol0<ol000Pco`000`000?oo
ooooo`1[oooo002Woooo00<0000co`0co`0023?o00030000oooooooo06_oool00:Ooool00`0003?o
03?o0008<ol000<0003oooooool0Joooo`00Yoooo`800009<ol000<0003oooooool0Joooo`00Yooo
o`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo002Woooo00<0000co`0co`001c?o00030000
oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yoooo`030000
<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo00<0000co`0co`001c?o00030000oooooooo
06coool00:Ooool2000023?o00030000oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0
003oooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo00<0
000co`0co`001c?o00030000oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0003ooooo
ool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo0P0000Lco`00
0`000?ooooooo`1]oooo002Woooo00<0000co`0co`001S?o00030000oooooooo06goool00:Ooool0
0`0003?o03?o0006<ol000<0003oooooool0KOooo`00Yoooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1]oooo002Poooo0P0000Goool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00Wooo
o`040000oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002Qoooo00<0
003oooooool00oooo`<00006<ol000<0003oooooool0KOooo`00X_ooo`030000oooooooo00;oool0
0`0003?o03?o0006<ol000<0003oooooool0KOooo`00Woooo`040000oooooooo00001?ooo`030000
<ol0<ol000Hco`000`000?ooooooo`1]oooo002Poooo0P0000Goool00`0003?o03?o0006<ol000<0
003oooooool0KOooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002Woooo00<0
000co`0co`001C?o00030000oooooooo06koool00:Ooool00`0003?o03?o0005<ol000<0003ooooo
ool0K_ooo`00Yoooo`800006<ol000<0003oooooool0K_ooo`00Yoooo`030000<ol0<ol000Dco`00
0`000?ooooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo06koool00:Ooool0
0`0003?o03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?oo
ooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo06koool00:Ooool200001S?o
00030000oooooooo06koool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yooo
o`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o00030000
oooooooo06ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yoooo`030000
<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo0P0000Dco`000`000?ooooooo`1_oooo002W
oooo00<0000co`0co`0013?o00030000oooooooo06ooool00:Ooool00`0003?o03?o0004<ol000<0
003oooooool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0
000co`0co`0013?o00030000oooooooo06ooool00:Ooool00`0003?o03?o0003<ol000<0003ooooo
ool0L?ooo`00Yoooo`800004<ol000<0003oooooool0L?ooo`00Yoooo`030000<ol0<ol000<co`00
0`000?ooooooo`1`oooo002Woooo00<0000co`0co`000c?o00030000oooooooo073oool00:Ooool0
0`0003?o03?o0003<ol000<0003oooooool0L?ooo`00Yoooo`030000<ol0<ol000<co`000`000?oo
ooooo`1`oooo002Qoooo0`0000?oool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00X_oo
o`030000oooooooo00;oool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00Woooo`D00003
oooo0`0000<co`000`000?ooooooo`1`oooo002Ooooo00@0003oooooool00004oooo1S?o07?oool0
0:3oool00`000?ooo`000004oooo1S?o07?oool00:7oool200001?ooo`Hco`1coooo002Woooo1S?o
07?oool00:Ooool6<ol0Loooo`00O?ooo`030000oooooooo02;oool00`000?ooooooo`03oooo1S?o
07?oool007_oool00`000?ooooooo`08oooo00<0003oooooool06Oooo`030000oooooooo00;oool6
<ol0Loooo`00Noooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_oo
o`800004oooo00<0003oooooool00_ooo`Hco`1coooo001koooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`08oooo00<0
003oooooool00_ooo`Hco`1coooo001joooo00<0003oooooool00_ooo`030000oooooooo01Goool0
0`000?ooooooo`09oooo00@0003oooooooooool6<ol0Loooo`00Noooo`030000oooooooo00D0000D
oooo00<0003oooooool02?ooo`030000oooooooo00;oool6<ol0Loooo`00Noooo`050000oooooooo
oooo000001Ooool00`000?ooooooo`08oooo00<0003oooooool00_ooo`Hco`1coooo001loooo00<0
003oooooool05oooo`800009oooo00<0003oooooool00oooo`Hco`1coooo002Woooo1S?o07?oool0
0:Ooool6<ol0Loooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {501.875, 360.563}} -> {-0.349561, \
2.55153, 0.00349883, 0.00566123}, {{79.875, 308.563}, {501.875, 360.563}} -> \
{-5.53614, 13.2635, 0.0207442, 0.0319664}, {{79.875, 308.563}, {501.875, \
360.563}} -> {-5.53614, 13.2635, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.59832 .12361 L
.60873 .12361 L
.61984 .12361 L
.6254 .12361 L
.62812 .12361 L
.63064 .12361 L
.63182 .12361 L
.63292 .12361 L
s
.63292 .12361 m
.63338 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.23739 .12361 L
.24276 .12361 L
.24745 .12361 L
.24873 .12361 L
.25012 .12361 L
.25142 .12361 L
.25261 .12391 L
.25377 .12539 L
.25484 .12676 L
.25728 .12978 L
.26171 .13507 L
.28051 .15468 L
.30084 .17151 L
.32225 .18535 L
.34242 .19552 L
.36236 .20341 L
.38342 .20989 L
.40306 .21457 L
.4214 .21796 L
.44175 .22084 L
.46031 .22277 L
.47939 .22417 L
.49017 .22473 L
.49497 .22493 L
.50015 .22511 L
.50517 .22525 L
.50978 .22535 L
.51418 .22542 L
.51639 .22545 L
.51881 .22547 L
.52021 .22548 L
.52152 .22548 L
.5227 .22549 L
.52397 .22549 L
.52464 .22549 L
.52537 .22549 L
.52613 .22549 L
.52684 .22549 L
.52812 .22548 L
.52883 .22548 L
.52949 .22548 L
.53192 .22546 L
Mistroke
.5333 .22545 L
.53458 .22543 L
.53942 .22536 L
.54451 .22525 L
.55001 .22509 L
.55254 .22501 L
.55392 .22496 L
.55521 .22491 L
.55631 .22487 L
.55748 .22438 L
.55879 .22265 L
.55998 .22109 L
.5786 .19903 L
.6185 .16535 L
.62729 .16062 L
.6297 .15944 L
.63101 .15882 L
.63223 .15825 L
.63327 .15778 L
.63439 .12361 L
.63563 .12361 L
.63675 .12361 L
.6374 .12361 L
.63809 .12361 L
.63932 .12361 L
.64 .12361 L
.64064 .12361 L
.64135 .12361 L
.6421 .12361 L
.64275 .12361 L
.64345 .12361 L
.64473 .12361 L
.64598 .12361 L
.64714 .12361 L
.6483 .12361 L
.64938 .12361 L
.65057 .12361 L
.65186 .12361 L
.65313 .12361 L
.65377 .12361 L
.65448 .12361 L
.65572 .12361 L
.65688 .12361 L
.65811 .12361 L
.65881 .12361 L
.65946 .12361 L
.66064 .12361 L
.66189 .12361 L
.66294 .12361 L
.66406 .12361 L
Mistroke
.6653 .12361 L
.66645 .12361 L
.66776 .12361 L
.66851 .12361 L
.6692 .12361 L
.67046 .12361 L
.67116 .12361 L
.6718 .12361 L
.67301 .12361 L
.67432 .12361 L
.67556 .12361 L
.67669 .12361 L
.67791 .12361 L
.67921 .12361 L
.68044 .12361 L
.68157 .12361 L
.68288 .12361 L
.68363 .12361 L
.68431 .12361 L
.68558 .12361 L
.68621 .12361 L
.68692 .12361 L
.6876 .12361 L
.68831 .12361 L
.6896 .12361 L
.69031 .12361 L
.69098 .12361 L
.69175 .12361 L
.69249 .12361 L
.69312 .12361 L
.69381 .12361 L
.69501 .12361 L
.6957 .12361 L
.69642 .12361 L
.69771 .12361 L
.69892 .12361 L
.70025 .12361 L
.70141 .12361 L
.70265 .12361 L
.70388 .12361 L
.70499 .12361 L
.70611 .12361 L
.70716 .12361 L
.7084 .12361 L
.7097 .12361 L
.71081 .12361 L
.71204 .12361 L
.71335 .12361 L
.71409 .12361 L
.71476 .12361 L
Mistroke
.71607 .12361 L
.7173 .12361 L
.71836 .12361 L
.71952 .12361 L
.72073 .12361 L
.72187 .12361 L
.72293 .12361 L
.7239 .12361 L
.72502 .12361 L
.72608 .12361 L
.72723 .12361 L
.72845 .12361 L
.7296 .12361 L
.73064 .12361 L
.73187 .12361 L
.73257 .12361 L
.7332 .12361 L
.73562 .12361 L
.73688 .12361 L
.73808 .12361 L
.73915 .12361 L
.74031 .12361 L
.74158 .12361 L
.74222 .12361 L
.74293 .12361 L
.74418 .12361 L
.74535 .12361 L
.74646 .12361 L
.74763 .12361 L
.74864 .12361 L
.74972 .12361 L
.75089 .12361 L
.75197 .12361 L
.75326 .12361 L
.75444 .12361 L
.75572 .12361 L
.75637 .12361 L
.75709 .12361 L
.75835 .12361 L
.75953 .12361 L
.76025 .12361 L
.76092 .12361 L
.7622 .12361 L
.76291 .12361 L
.76357 .12361 L
.76429 .12361 L
.76506 .12361 L
.76636 .12361 L
.7671 .12361 L
.76777 .12361 L
Mistroke
.76901 .12361 L
.77033 .12361 L
.7715 .12361 L
.7726 .12361 L
.7738 .12361 L
.77509 .12361 L
.77573 .12361 L
.77642 .12361 L
.77766 .12361 L
.77896 .12361 L
.77971 .12361 L
.78039 .12361 L
.78163 .12361 L
.78278 .12361 L
.78398 .12361 L
.78529 .12361 L
.78598 .12361 L
.78673 .12361 L
.78744 .12361 L
.7881 .12361 L
.78934 .12361 L
.79065 .12361 L
.79133 .12361 L
.79206 .12361 L
.79337 .12361 L
.79417 .12361 L
.79494 .12361 L
.79562 .12361 L
.79637 .12361 L
.79761 .12361 L
.79877 .12361 L
.80005 .12361 L
.80077 .12361 L
.80143 .12361 L
.80268 .12361 L
.8034 .12361 L
.80405 .12361 L
.80474 .12361 L
.80548 .12361 L
.80617 .12361 L
.80682 .12361 L
.80799 .12361 L
.80923 .12361 L
.81029 .12361 L
.81146 .12361 L
.81271 .12361 L
.81342 .12361 L
.81406 .12361 L
.81531 .12361 L
.8165 .12361 L
Mistroke
.81774 .12361 L
.81844 .12361 L
.81909 .12361 L
.82027 .12361 L
.82153 .12361 L
.82265 .12361 L
.8237 .12361 L
.82485 .12361 L
.82609 .12361 L
.8274 .12361 L
.82814 .12361 L
.82883 .12361 L
.83007 .12361 L
.83077 .12361 L
.83143 .12361 L
.83267 .12361 L
.8338 .12361 L
.835 .12361 L
.83631 .12361 L
.83738 .12361 L
.83852 .12361 L
.8396 .12361 L
.84059 .12361 L
.84174 .12361 L
.84299 .12361 L
.84417 .12361 L
.84527 .12361 L
.8464 .12361 L
.84765 .12361 L
.84887 .12361 L
.85017 .12361 L
.85139 .12361 L
.85254 .12361 L
.85357 .12361 L
.8547 .12361 L
.85535 .12361 L
.85603 .12361 L
.85726 .12361 L
.85858 .12361 L
.85934 .12361 L
.86003 .12361 L
.86128 .12361 L
.86197 .12361 L
.86262 .12361 L
.86378 .12361 L
.86504 .12361 L
.86626 .12361 L
.86741 .12361 L
.8686 .12361 L
.86991 .12361 L
Mistroke
.87208 .12361 L
.8733 .12361 L
.87441 .12361 L
.8757 .12361 L
.87642 .12361 L
.87708 .12361 L
.87835 .12361 L
.87955 .12361 L
.88024 .12361 L
.88096 .12361 L
.88225 .12361 L
.88297 .12361 L
.88364 .12361 L
.88438 .12361 L
.88517 .12361 L
.88649 .12361 L
.88723 .12361 L
.88792 .12361 L
.88918 .12361 L
.88982 .12361 L
.89052 .12361 L
.89173 .12361 L
.89304 .12361 L
.89427 .12361 L
.8954 .12361 L
.89668 .12361 L
.89788 .12361 L
.89896 .12361 L
.90013 .12361 L
.90141 .12361 L
.90206 .12361 L
.90276 .12361 L
.90402 .12361 L
.90519 .12361 L
.90627 .12361 L
.90745 .12361 L
.90856 .12361 L
.90959 .12361 L
.91078 .12361 L
.91205 .12361 L
.91324 .12361 L
.91431 .12361 L
.91561 .12361 L
.91626 .12361 L
.91698 .12361 L
.91825 .12361 L
.91943 .12361 L
.92015 .12361 L
.92083 .12361 L
.9221 .12361 L
Mistroke
.92282 .12361 L
.92347 .12361 L
.9242 .12361 L
.92497 .12361 L
.92615 .12361 L
.92743 .12361 L
.92863 .12361 L
.92974 .12361 L
.93096 .12361 L
.93166 .12361 L
.9323 .12361 L
.93361 .12361 L
.93434 .12361 L
.935 .12361 L
.9362 .12361 L
.93731 .12361 L
.93854 .12361 L
.93986 .12361 L
.94052 .12361 L
.94124 .12361 L
.94254 .12361 L
.94382 .12361 L
.945 .12361 L
.9462 .12361 L
.94734 .12361 L
.94837 .12361 L
.94946 .12361 L
.95065 .12361 L
.95174 .12361 L
.95292 .12361 L
.95421 .12361 L
.95488 .12361 L
.95561 .12361 L
.95629 .12361 L
.95693 .12361 L
.95813 .12361 L
.95941 .12361 L
.96007 .12361 L
.96078 .12361 L
.96206 .12361 L
.96284 .12361 L
.96358 .12361 L
.96425 .12361 L
.96498 .12361 L
.9663 .12361 L
.96749 .12361 L
.96878 .12361 L
.96951 .12361 L
.97018 .12361 L
.97139 .12361 L
Mistroke
.97267 .12361 L
.97378 .12361 L
.97501 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<00000I_ooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02koool00`000?ooooooo`07oooo00<0
I_ooooooool08oooo`030000oooooooo02goool00`0003?o03?o0007<ol000<0I_lco`0co`008c?o
00P0000Yoooo00<0003oooooool05Oooo`00D_ooo`80I_mCoooo00<0000co`0co`001c?o000306Ko
<ol0<ol0020co`030000BOooo`00E?ooo`0306Kooooooooo053oool00`0003?o03?o0007<ol000<0
I_lco`0co`0073?o00@0001<oooo001Eoooo00<0I_ooooooool0Coooo`030000<ol0<ol000Lco`00
0`1Voc?o03?o000J<ol00P00053oool005Goool00`1Vooooooooo`1?oooo00<0000co`0co`001c?o
000306Ko<ol0<ol001Tco`000`000?ooooooo`1@oooo001Foooo00<0I_ooooooool0C_ooo`800008
<ol000<0I_lco`0co`005c?o0080001Coooo001Goooo00<0I_ooooooool0COooo`030000<ol0<ol0
00Lco`000`1Voc?o03?o000E<ol00P0005Goool005Soool00`1Vooooooooo`1<oooo00<0000co`0c
o`001S?o0080I_lF<ol000<0003oooooool0EOooo`00FOooo`0306Kooooooooo04_oool00`0003?o
03?o0005<ol000<0I_lco`3o09T05C?o00030000oooooooo05Koool005[oool00`1Vooooooooo`1:
oooo00<0000co`0co`000c?o0080I_l2<ol000?o09Tco`0co`004S?o00030000oooooooo05Ooool0
05_oool00`1Vooooooooo`19oooo00<0000co`0co`000S?o000306Ko<ol0<ol0008co`000ol0VC?o
03?o000A<ol000<0003oooooool0F?ooo`00G?ooo`0306Kooooooooo04Soool200000S?o000306Ko
<ol0<ol000<co`000ol0VC?o03?o000A<ol000<0003oooooool0F?ooo`00GOooo`80I_m8oooo00@0
000co`0co`00I_l6<ol000?o09Tco`0co`0043?o00030000oooooooo05Woool005ooool206KoA_oo
o`030000<ol006Ko00Lco`000ol0VC?o03?o000?<ol000<0003oooooool0F_ooo`00HOooo`80I_m4
oooo00<00000I_lco`001c?o0003o`2I<ol0<ol000hco`000`000?ooooooo`1Koooo001Soooo0P1V
od7oool00`1Vo`0003?o0008<ol000?o09Tco`0co`003C?o00030000oooooooo05coool006Goool2
06Ko?_ooo`0306Kooooo000000Tco`000ol0VC?o03?o000<<ol000<0003oooooool0GOooo`00Iooo
o`80I_lkoooo00<0I_ooooooool00P0000Pco`000ol0VC?o03?o000<<ol000<0003oooooool0GOoo
o`00JOooo`80I_lhoooo00D0I_ooooooooooool000002C?o0003o`2I<ol0<ol000/co`000`000?oo
ooooo`1Noooo001[oooo101Voc?oool00`1Vooooooooo`02oooo00<0000co`0co`001c?o0003o`2I
<ol0<ol000/co`000`000?ooooooo`1Noooo001_oooo1@1Vobgoool00`1Vooooooooo`03oooo00<0
000co`0co`001c?o0003o`2I<ol0<ol000/co`000`000?ooooooo`1Noooo001doooo1@1VobOoool0
0`1Vooooooooo`04oooo00<0000co`0co`001c?o0003o`2I<ol0<ol000Xco`000`000?ooooooo`1O
oooo001ioooo1@1Vob7oool00`1Vooooooooo`05oooo00<0000co`0co`001c?o0003o`2I<ol0<ol0
00Xco`000`000?ooooooo`1Ooooo001noooo1@1Voa_oool00`1Vooooooooo`06oooo0P0000Pco`00
0ol0VC?o03?o0009<ol000<0003oooooool0H?ooo`00Pooooa`0I_l8oooo00<0000co`0co`001c?o
0003o`2I<ol0<ol000Tco`000`000?ooooooo`1Poooo002Woooo00<0000co`0co`001c?o0003o`2I
<ol0<ol000Tco`000`000?ooooooo`1Poooo002Woooo00<0000co`0co`001c?o0003o`2I<ol0<ol0
00Pco`000`000?ooooooo`1Qoooo002Woooo00<0000co`0co`001c?o0003o`2I<ol0<ol000Pco`00
0`000?ooooooo`1Qoooo002Ooooo1@0000?oool00`0003?o03?o0007<ol000?o09Tco`0co`001c?o
00030000oooooooo06;oool00:7oool00`000?ooooooo`03oooo00<0000co`0co`001c?o0003o`2I
<ol0<ol000Lco`000`000?ooooooo`1Roooo002Qoooo00<0003oooooool00oooo`<00007<ol000?o
09Tco`0co`001c?o00030000oooooooo06;oool00:7oool00`000?ooooooo`03oooo00<0000co`0c
o`001c?o0003o`2I<ol0<ol000Hco`000`000?ooooooo`1Soooo002Qoooo00<0003oooooool00ooo
o`030000<ol0<ol000Lco`000ol0VC?o03?o0006<ol000<0003oooooool0Hoooo`00X?ooo`800005
oooo00<0000co`0co`001c?o0003o`2I<ol0<ol000Hco`000`000?ooooooo`1Soooo002Woooo00<0
000co`0co`001c?o0003o`2I<ol0<ol000Hco`000`000?ooooooo`1Soooo002Woooo00<0000co`0c
o`001c?o0003o`2I<ol0<ol000Dco`000`000?ooooooo`1Toooo002Woooo0P0000Pco`000ol0VC?o
03?o0005<ol000<0003oooooool0I?ooo`00Yoooo`030000<ol0<ol000Lco`000ol0VC?o03?o0005
<ol000<0003oooooool0I?ooo`00Yoooo`030000<ol0<ol000Lco`000ol0VC?o03?o0005<ol000<0
003oooooool0I?ooo`00Yoooo`030000<ol0<ol000Lco`000ol0VC?o03?o0004<ol000<0003ooooo
ool0IOooo`00Yoooo`030000<ol0<ol000Lco`000ol0VC?o03?o0004<ol000<0003oooooool0IOoo
o`00Yoooo`030000<ol0<ol000Lco`000ol0VC?o03?o0004<ol000<0003oooooool0IOooo`00Yooo
o`800008<ol000?o09Tco`0co`0013?o00030000oooooooo06Goool00:Ooool00`0003?o03?o0007
<ol000?o09Tco`0co`000c?o00030000oooooooo06Koool00:Ooool00`0003?o03?o0007<ol000?o
09Tco`0co`000c?o00030000oooooooo06Koool00:Ooool00`0003?o03?o0007<ol000?o09Tco`0c
o`000c?o00030000oooooooo06Koool00:Ooool00`0003?o03?o0007<ol000?o09Tco`0co`000c?o
00030000oooooooo06Koool00:Ooool00`0003?o03?o0007<ol000?o09Tco`0co`000S?o00030000
oooooooo06Ooool00:Ooool00`0003?o03?o0007<ol000?o09Tco`0co`000S?o00030000oooooooo
06Ooool00:Ooool2000023?o0003o`2I<ol0<ol0008co`000`000?ooooooo`1Woooo002Woooo00<0
000co`0co`001c?o0003o`2I<ol0<ol0008co`000`000?ooooooo`1Woooo002Woooo00<0000co`0c
o`001c?o0005o`2I<ol0<ol0<ol0000006[oool00:Ooool00`0003?o03?o0007<ol000Go09Tco`0c
o`0co`000000J_ooo`00Yoooo`030000<ol0<ol000Lco`001Ol0VC?o03?o03?o0000001Zoooo002W
oooo00<0000co`0co`001c?o0005o`2I<ol0<ol0<ol0000006[oool00:Ooool2000023?o0005o`2I
<ol0<ol0<ol0000006[oool00:Ooool00`0003?o03?o0007<ol000Co09Tco`0co`00001[oooo002W
oooo00<0000co`0co`001c?o0004o`2I<ol0<ol00000Joooo`00Yoooo`030000<ol0<ol000Lco`00
1?l0VC?o03?o000006_oool009ooool400001?ooo`030000<ol0<ol000Lco`001?l0VC?o03?o0000
06_oool009ooool00`000?ooooooo`05oooo00<0000co`0co`001c?o0004o`2I<ol0<ol00000Jooo
o`00X?ooo`030000oooooooo00Coool300001c?o0004o`2I<ol0<ol00000Joooo`00XOooo`030000
oooooooo00?oool00`0003?o03?o0007<ol000?o09Tco`000000K?ooo`00Woooo`040000oooooooo
00001?ooo`030000<ol0<ol000Lco`000ol0VC?o0000001/oooo002Poooo0P0000Goool00`0003?o
03?o0007<ol000?o09Tco`000000K?ooo`00Yoooo`030000<ol0<ol000Lco`000ol0VC?o0000001/
oooo002Woooo00<0000co`0co`001c?o0003o`2I<ol0000006coool00:Ooool2000023?o0003o`2I
<ol0000006coool00:Ooool00`0003?o03?o0007<ol000?o09T0003oool0K?ooo`00Yoooo`030000
<ol0<ol000Lco`000ol0V@000?ooo`1/oooo002Woooo00<0000co`0co`001c?o0003o`2I0000oooo
06coool00:Ooool00`0003?o03?o0007<ol000?o09T0003oool0K?ooo`00Yoooo`030000<ol0<ol0
00Lco`000ol0V@000?ooo`1/oooo002Woooo00<0000co`0co`001c?o0003o`2I0000oooo06coool0
0:Ooool2000023?o0003o`2I0000oooo06coool00:Ooool00`0003?o03?o0007<ol000?o09T0003o
ool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000ol0VOooooooo`1/oooo002Woooo00<0000co`0c
o`001c?o0003o`2Ioooooooo06coool00:Ooool00`0003?o03?o0007<ol000?o09Woooooool0K?oo
o`00Yoooo`030000<ol0<ol000Lco`000ol0VOooooooo`1/oooo002Woooo0P0000Pco`000ol0VOoo
ooooo`1/oooo002Woooo00<0000co`0co`001c?o0003o`2Ioooooooo06coool00:Ooool00`0003?o
03?o0007<ol000?o09Woooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000ol0VOooooooo`1/
oooo002Woooo00<0000co`0co`001c?o0003o`2Ioooooooo06coool00:Ooool00`0003?o03?o0007
<ol000?o09Woooooool0K?ooo`00Yoooo`800007<ol000<0003o09Woool0KOooo`00Yoooo`030000
<ol0<ol000Hco`000`000?l0VOooo`1]oooo002Woooo00<0000co`0co`001S?o00030000o`2Ioooo
06goool00:Ooool00`0003?o03?o0006<ol000<0003o09Woool0KOooo`00X?ooo`800005oooo00<0
000co`0co`001S?o00030000o`2Ioooo06goool009ooool010000?ooooooo`0000Coool00`0003?o
03?o0006<ol000<0003o09Woool0KOooo`00XOooo`030000oooooooo00?oool300001S?o00030000
o`2Ioooo06goool00:;oool00`000?ooooooo`02oooo00<0000co`0co`001S?o00030000o`2Ioooo
06goool009ooool010000?ooooooo`0000Coool00`0003?o03?o0006<ol000<0003o09Woool0KOoo
o`00X?ooo`800005oooo00<0000co`0co`001S?o00030000o`2Ioooo06goool00:Ooool00`0003?o
03?o0005<ol000<0003ooooo09T0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooool0V@1^
oooo002Woooo00<0000co`0co`001C?o00030000ooooo`2I06koool00:Ooool200001S?o00030000
ooooo`2I06koool00:Ooool00`0003?o03?o0005<ol000<0003ooooo09T0K_ooo`00Yoooo`030000
<ol0<ol000Dco`000`000?ooool0V@1^oooo002Woooo00<0000co`0co`001C?o00030000ooooo`2I
06koool00:Ooool00`0003?o03?o0005<ol000<0003ooooo09T0K_ooo`00Yoooo`030000<ol0<ol0
00Dco`000`000?ooool0V@1^oooo002Woooo0P0000Hco`000`000?ooool0V@1^oooo002Woooo00<0
000co`0co`0013?o00040000ooooooooo`2IK_ooo`00Yoooo`030000<ol0<ol000@co`0010000?oo
ooooool0VFkoool00:Ooool00`0003?o03?o0004<ol000@0003ooooooooo09U^oooo002Woooo00<0
000co`0co`0013?o00040000ooooooooo`2IK_ooo`00Yoooo`030000<ol0<ol000@co`0010000?oo
ooooool0VFkoool00:Ooool200001C?o00040000ooooooooo`2IK_ooo`00Yoooo`030000<ol0<ol0
00@co`0010000?ooooooool0VFkoool00:Ooool00`0003?o03?o0004<ol000@0003ooooooooo09U^
oooo002Woooo00<0000co`0co`0013?o00040000ooooooooo`2IK_ooo`00Yoooo`030000<ol0<ol0
00@co`0010000?ooooooool0VFkoool00:Ooool00`0003?o03?o0003<ol000D0003ooooooooooooo
09T0K_ooo`00Yoooo`800004<ol000D0003ooooooooooooo09T0K_ooo`00Yoooo`030000<ol0<ol0
00<co`001@000?ooooooooooool0V@1^oooo002Woooo00<0000co`0co`000c?o00050000oooooooo
ooooo`2I06koool00:Ooool00`0003?o03?o0003<ol000D0003ooooooooooooo09T0K_ooo`00Yooo
o`030000<ol0<ol000<co`001@000?ooooooooooool0V@1^oooo002Qoooo0`0000?oool00`0003?o
03?o0003<ol000D0003ooooooooooooo09T0K_ooo`00X_ooo`030000oooooooo00;oool00`0003?o
03?o0003<ol000D0003ooooooooooooo09T0K_ooo`00Woooo`D00003oooo0`0000<co`001@000?oo
ooooooooool0V@1^oooo002Ooooo00@0003oooooool00004oooo1S?o07?oool00:3oool00`000?oo
o`000004oooo1S?o07?oool00:7oool200001?ooo`Hco`1coooo002Woooo1S?o07?oool00:Ooool6
<ol0Loooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`06<ol0Loooo`00N?ooo`030000
oooooooo00Soool00`000?ooooooo`0Ooooo00<0003ooolco`001C?o07?oool007Soool00`000?oo
ooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004oooo00<0
003ooolco`001C?o07?oool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooo<ol000Dco`1coooo001goooo00<0003oooooool00_ooo`030000oooooooo01?oool0
10000?ooooooo`0000Soool010000?ooooooo`0000Coool00`0003?o03?o0004<ol0Loooo`00N?oo
o`030000oooooooo00D0000Boooo00@0003oooooool00009oooo0P0000Coool00`000?oooc?o0005
<ol0Loooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?oooc?o0005<ol0Loooo`00NOooo`030000oooooooo01Ooool200002_oo
o`800003oooo00<0003oooooool01S?o07?oool00:Ooool6<ol0Loooo`00Yoooo`Hco`1coooo0000
\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {650.563, 509.25}} -> {-0.349561, \
3.60372, 0.00349883, 0.00566123}, {{79.875, 308.563}, {650.563, 509.25}} -> \
{-5.53614, 19.2047, 0.0207442, 0.0319664}, {{79.875, 308.563}, {650.563, \
509.25}} -> {-5.53614, 19.2047, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.64043 .12361 L
.65045 .12361 L
.65954 .12361 L
.66412 .12361 L
.66652 .12361 L
.66906 .12361 L
.67014 .12361 L
.67129 .12361 L
s
.67129 .12361 m
.67179 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.27731 .12361 L
.28302 .12361 L
.28542 .12361 L
.288 .12361 L
.28876 .12361 L
.28948 .12361 L
.29013 .12361 L
.29083 .12407 L
.2915 .12493 L
.29221 .12583 L
.29349 .12745 L
.30316 .13889 L
.32313 .15878 L
.34474 .17562 L
.3656 .18824 L
.3848 .19738 L
.40523 .20503 L
.42429 .21063 L
.44262 .21487 L
.46226 .21841 L
.4835 .22127 L
.49326 .22229 L
.50362 .22321 L
.51309 .2239 L
.51568 .22406 L
.51704 .22415 L
.51778 .22419 L
.51848 .22423 L
.51974 .22341 L
.5204 .2226 L
.52111 .22173 L
.52353 .21884 L
.54195 .19916 L
.56187 .18186 L
.58345 .16669 L
.59356 .1606 L
.60425 .15499 L
.62343 .14751 L
.64301 .14205 L
.65177 .14009 L
.66132 .13822 L
.66394 .13776 L
Mistroke
.66672 .13727 L
.66807 .13705 L
.66935 .13684 L
.67049 .13665 L
.67173 .12361 L
.67292 .12361 L
.67423 .12361 L
.67489 .12361 L
.6756 .12361 L
.67688 .12361 L
.67815 .12361 L
.67935 .12361 L
.68043 .12361 L
.68161 .12361 L
.68268 .12361 L
.68383 .12361 L
.6851 .12361 L
.68628 .12361 L
.68754 .12361 L
.68818 .12361 L
.68887 .12361 L
.6901 .12361 L
.69124 .12361 L
.6924 .12361 L
.6935 .12361 L
.69448 .12361 L
.69555 .12361 L
.69671 .12361 L
.69794 .12361 L
.69899 .12361 L
.70014 .12361 L
.70145 .12361 L
.70265 .12361 L
.70397 .12361 L
.70464 .12361 L
.70537 .12361 L
.7066 .12361 L
.7073 .12361 L
.70793 .12361 L
.7091 .12361 L
.71033 .12361 L
.71144 .12361 L
.71263 .12361 L
.71375 .12361 L
.71477 .12361 L
.71597 .12361 L
.71727 .12361 L
.7185 .12361 L
.71963 .12361 L
.72083 .12361 L
Mistroke
.72213 .12361 L
.72335 .12361 L
.72446 .12361 L
.72577 .12361 L
.72651 .12361 L
.72719 .12361 L
.72844 .12361 L
.72915 .12361 L
.72978 .12361 L
.73046 .12361 L
.73117 .12361 L
.73244 .12361 L
.73315 .12361 L
.73382 .12361 L
.73454 .12361 L
.73532 .12361 L
.73599 .12361 L
.73672 .12361 L
.73741 .12361 L
.73805 .12361 L
.73926 .12361 L
.74054 .12361 L
.74168 .12361 L
.74292 .12361 L
.74422 .12361 L
.74543 .12361 L
.74657 .12361 L
.7476 .12361 L
.74879 .12361 L
.74992 .12361 L
.75114 .12361 L
.75244 .12361 L
.75355 .12361 L
.75477 .12361 L
.75608 .12361 L
.75681 .12361 L
.75748 .12361 L
.75879 .12361 L
.76002 .12361 L
.76116 .12361 L
.76222 .12361 L
.76345 .12361 L
.76456 .12361 L
.76562 .12361 L
.76659 .12361 L
.76765 .12361 L
.76877 .12361 L
.76991 .12361 L
.77113 .12361 L
.77228 .12361 L
Mistroke
.77332 .12361 L
.77455 .12361 L
.77524 .12361 L
.77588 .12361 L
.77706 .12361 L
.77831 .12361 L
.77951 .12361 L
.78082 .12361 L
.78207 .12361 L
.78322 .12361 L
.78436 .12361 L
.78539 .12361 L
.78659 .12361 L
.78771 .12361 L
.78894 .12361 L
.79024 .12361 L
.79135 .12361 L
.79257 .12361 L
.79389 .12361 L
.79462 .12361 L
.79529 .12361 L
.7966 .12361 L
.79783 .12361 L
.79888 .12361 L
.80004 .12361 L
.80125 .12361 L
.80238 .12361 L
.80344 .12361 L
.80441 .12361 L
.80547 .12361 L
.8066 .12361 L
.80774 .12361 L
.80895 .12361 L
.8101 .12361 L
.81115 .12361 L
.81238 .12361 L
.81307 .12361 L
.81371 .12361 L
.81489 .12361 L
.81613 .12361 L
.81734 .12361 L
.81866 .12361 L
.8199 .12361 L
.82106 .12361 L
.8222 .12361 L
.82324 .12361 L
.82443 .12361 L
.82556 .12361 L
.8268 .12361 L
.8281 .12361 L
Mistroke
.83043 .12361 L
.83173 .12361 L
.83294 .12361 L
.83364 .12361 L
.83427 .12361 L
.835 .12361 L
.8357 .12361 L
.83675 .12361 L
.83791 .12361 L
.83912 .12361 L
.84026 .12361 L
.84131 .12361 L
.84228 .12361 L
.84335 .12361 L
.84447 .12361 L
.84561 .12361 L
.84683 .12361 L
.84798 .12361 L
.84903 .12361 L
.85026 .12361 L
.85095 .12361 L
.85159 .12361 L
.85276 .12361 L
.85401 .12361 L
.85522 .12361 L
.85654 .12361 L
.85779 .12361 L
.85895 .12361 L
.85999 .12361 L
.86114 .12361 L
.86233 .12361 L
.86346 .12361 L
.8647 .12361 L
.86601 .12361 L
.86712 .12361 L
.86834 .12361 L
.86966 .12361 L
.8704 .12361 L
.87107 .12361 L
.87238 .12361 L
.87361 .12361 L
.87467 .12361 L
.87583 .12361 L
.87704 .12361 L
.87818 .12361 L
.87924 .12361 L
.88021 .12361 L
.88133 .12361 L
.8824 .12361 L
.88354 .12361 L
Mistroke
.88476 .12361 L
.88591 .12361 L
.88696 .12361 L
.88819 .12361 L
.88888 .12361 L
.88952 .12361 L
.89069 .12361 L
.89193 .12361 L
.89315 .12361 L
.89384 .12361 L
.89448 .12361 L
.89565 .12361 L
.89689 .12361 L
.898 .12361 L
.89904 .12361 L
.90018 .12361 L
.90141 .12361 L
.90265 .12361 L
.90335 .12361 L
.904 .12361 L
.90531 .12361 L
.90605 .12361 L
.90672 .12361 L
.90792 .12361 L
.90922 .12361 L
.91044 .12361 L
.91158 .12361 L
.91263 .12361 L
.91377 .12361 L
.91484 .12361 L
.91582 .12361 L
.91696 .12361 L
.91821 .12361 L
.91939 .12361 L
.92048 .12361 L
.92172 .12361 L
.92288 .12361 L
.92392 .12361 L
.92505 .12361 L
.92628 .12361 L
.92758 .12361 L
.92869 .12361 L
.92991 .12361 L
.93122 .12361 L
.93243 .12361 L
.93307 .12361 L
.93376 .12361 L
.93449 .12361 L
.93517 .12361 L
.93642 .12361 L
Mistroke
.93757 .12361 L
.93889 .12361 L
.94015 .12361 L
.94126 .12361 L
.94246 .12361 L
.94358 .12361 L
.9446 .12361 L
.9458 .12361 L
.94711 .12361 L
.94833 .12361 L
.94947 .12361 L
.95068 .12361 L
.95197 .12361 L
.9532 .12361 L
.95431 .12361 L
.95562 .12361 L
.95636 .12361 L
.95705 .12361 L
.95769 .12361 L
.95838 .12361 L
.95964 .12361 L
.96093 .12361 L
.96212 .12361 L
.96281 .12361 L
.96345 .12361 L
.96412 .12361 L
.96485 .12361 L
.96558 .12361 L
.96626 .12361 L
.96753 .12361 L
.96825 .12361 L
.96891 .12361 L
.96963 .12361 L
.9704 .12361 L
.97115 .12361 L
.97184 .12361 L
.97263 .12361 L
.97339 .12361 L
.97408 .12361 L
.97473 .12361 L
.97544 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
06Kooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`00001Voc?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02koool00`000?ooooooo`0Boooo00<0
I_ooooooool06?ooo`030000oooooooo02goool00`0003?o03?o000@<ol000<0I_lco`0co`006S?o
00P0000Yoooo00<0003oooooool05Oooo`00G?ooo`0306Kooooooooo04Soool00`0003?o03?o000@
<ol000<0I_lco`0co`005c?o00<00019oooo001Moooo00<0I_ooooooool0Aoooo`030000<ol0<ol0
00dco`0406Ko5C?o00@0001<oooo001Noooo00<0I_ooooooool0A_ooo`030000<ol0<ol000Lco`06
06Ko0c?o0003o`2I<ol0<ol0014co`020000D?ooo`00Goooo`0306Kooooooooo04Goool00`0003?o
03?o0003<ol0101Vo`Tco`000ol0VC?o03?o000@<ol000<0003oooooool0D?ooo`00H?ooo`0306Ko
oooooooo04Coool200000S?o0080I_l=<ol000?o09Tco`0co`003S?o0080001Coooo001Qoooo00<0
I_ooooooool0@oooo`040000<ol006Ko06Ko3c?o0003o`2I<ol0<ol000`co`020000EOooo`00H_oo
o`0306Kooooooooo04;oool00`00001Voc?o000@<ol000?o09Tco`0co`002c?o00030000oooooooo
05Goool006?oool00`1Vooooooooo`10oooo00<0I_l0000co`004C?o0003o`2I<ol0<ol000Xco`00
0`000?ooooooo`1Foooo001Toooo00<0I_ooooooool0?Oooo`80I_l00oooo`0003?o000A<ol000?o
09Tco`0co`002C?o00030000oooooooo05Ooool006Goool206Ko??ooo`0506Kooooooooooooo0000
018co`000ol0VC?o03?o0008<ol000<0003oooooool0F?ooo`00Ioooo`0306Kooooooooo03Ooool2
06Ko1?ooo`80000A<ol000?o09Tco`0co`0023?o00030000oooooooo05Soool006Soool00`1Voooo
ooooo`0eoooo00<0I_ooooooool01?ooo`030000<ol0<ol0010co`000ol0VC?o03?o0007<ol000<0
003oooooool0FOooo`00JOooo`80I_ldoooo00<0I_ooooooool01Oooo`030000<ol0<ol0010co`00
0ol0VC?o03?o0006<ol000<0003oooooool0F_ooo`00Joooo`80I_laoooo00<0I_ooooooool01_oo
o`030000<ol0<ol0010co`000ol0VC?o03?o0005<ol000<0003oooooool0Foooo`00KOooo`80I_l^
oooo00<0I_ooooooool01oooo`030000<ol0<ol0010co`000ol0VC?o03?o0004<ol000<0003ooooo
ool0G?ooo`00Koooo`80I_l[oooo00<0I_ooooooool02?ooo`030000<ol0<ol0010co`000ol0VC?o
03?o0003<ol000<0003oooooool0GOooo`00LOooo`<0I_lWoooo00<0I_ooooooool02Oooo`80000A
<ol000?o09Tco`0co`000c?o00030000oooooooo05goool007Coool206Ko9?ooo`0306Kooooooooo
00[oool00`0003?o03?o000@<ol000?o09Tco`0co`000S?o00030000oooooooo05koool007Koool4
06Ko7oooo`0306Kooooooooo00_oool00`0003?o03?o000@<ol000?o09Tco`0co`000S?o00030000
oooooooo05koool007[oool306Ko6oooo`0306Kooooooooo00coool00`0003?o03?o000@<ol000?o
09Tco`0co`000S?o00030000oooooooo05koool007goool206Ko6?ooo`0306Kooooooooo00goool0
0`0003?o03?o000@<ol000Go09Tco`0co`0co`000000HOooo`00Ooooo`T0I_l>oooo00<0I_oooooo
ool03_ooo`030000<ol0<ol0010co`001Ol0VC?o03?o03?o0000001Qoooo0028oooo1`1Vo`Goool2
06Ko4Oooo`80000A<ol000Co09Tco`0co`00001Roooo002?oooo1P1Voa;oool00`0003?o03?o000@
<ol000Co09Tco`0co`00001Roooo002Woooo00<0000co`0co`0043?o0004o`2I<ol0<ol00000H_oo
o`00Yoooo`030000<ol0<ol0010co`000ol0VC?o0000001Soooo002Woooo00<0000co`0co`0043?o
0003o`2I<ol0000006?oool009ooool500000oooo`030000<ol0<ol0010co`000ol0V@000?ooo`1S
oooo002Qoooo00<0003oooooool00oooo`030000<ol0<ol0010co`000ol0V@000?ooo`1Soooo002Q
oooo00<0003oooooool00oooo`<0000@<ol000?o09T0003oool0Hoooo`00XOooo`030000oooooooo
00?oool00`0003?o03?o000@<ol000?o09Woooooool0Hoooo`00XOooo`030000oooooooo00?oool0
0`0003?o03?o000@<ol000?o09Woooooool0Hoooo`00X?ooo`800005oooo00<0000co`0co`0043?o
0003o`2Ioooooooo06?oool00:Ooool00`0003?o03?o000@<ol000?o09Woooooool0Hoooo`00Yooo
o`030000<ol0<ol000lco`000`000?l0VOooo`1Toooo002Woooo0P00010co`000`000?l0VOooo`1T
oooo002Woooo00<0000co`0co`003c?o00030000o`2Ioooo06Coool00:Ooool00`0003?o03?o000?
<ol000<0003o09Woool0I?ooo`00Yoooo`030000<ol0<ol000hco`000`000?ooool0V@1Uoooo002W
oooo00<0000co`0co`003S?o00030000ooooo`2I06Goool00:Ooool00`0003?o03?o000><ol000<0
003ooooo09T0IOooo`00Yoooo`80000?<ol000<0003ooooo09T0IOooo`00Yoooo`030000<ol0<ol0
00dco`0010000?ooooooool0VFGoool00:Ooool00`0003?o03?o000=<ol000@0003ooooooooo09UU
oooo002Woooo00<0000co`0co`003C?o00040000ooooooooo`2IIOooo`00Yoooo`030000<ol0<ol0
00dco`0010000?ooooooool0VFGoool00:Ooool00`0003?o03?o000<<ol000D0003ooooooooooooo
09T0IOooo`00Yoooo`030000<ol0<ol000`co`001@000?ooooooooooool0V@1Uoooo002Woooo0P00
00dco`001@000?ooooooooooool0V@1Uoooo002Woooo00<0000co`0co`0033?o00050000oooooooo
ooooo`2I06Goool00:Ooool00`0003?o03?o000;<ol000<0003oooooool00_ooo`03o`2Ioooooooo
06?oool00:Ooool00`0003?o03?o000;<ol000<0003oooooool00_ooo`03o`2Ioooooooo06?oool0
0:Ooool00`0003?o03?o000;<ol000<0003oooooool00_ooo`03o`2Ioooooooo06?oool00:Ooool0
0`0003?o03?o000;<ol000<0003oooooool00_ooo`03o`2Ioooooooo06?oool00:Ooool2000033?o
00030000oooooooo00;oool00ol0VOooooooo`1Soooo002Woooo00<0000co`0co`002S?o00030000
oooooooo00?oool00ol0VOooooooo`1Soooo002Woooo00<0000co`0co`002S?o00030000oooooooo
00?oool00ol0VOooooooo`1Soooo002Woooo00<0000co`0co`002S?o00030000oooooooo00?oool0
0ol0VOooooooo`1Soooo002Ooooo100000Coool00`0003?o03?o000:<ol000<0003oooooool00ooo
o`03o`2Ioooooooo06?oool009ooool00`000?ooooooo`05oooo00<0000co`0co`002S?o00030000
oooooooo00?oool00ol0VOooooooo`1Soooo002Poooo00<0003oooooool01?ooo`<0000:<ol000<0
003oooooool00oooo`03o`2Ioooooooo06?oool00:7oool00`000?ooooooo`03oooo00<0000co`0c
o`002C?o00030000oooooooo00Goool00ol0VOooooooo`1Roooo002Ooooo00@0003oooooool00004
oooo00<0000co`0co`002C?o00030000oooooooo00Goool00ol0VOooooooo`1Roooo002Poooo0P00
00Goool00`0003?o03?o0009<ol000<0003oooooool01Oooo`03o`2Ioooooooo06;oool00:Ooool0
0`0003?o03?o0009<ol000<0003oooooool01Oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o
03?o0009<ol000<0003oooooool01Oooo`03o`2Ioooooooo06;oool00:Ooool200002S?o00030000
oooooooo00Goool00ol0VOooooooo`1Roooo002Woooo00<0000co`0co`0023?o00030000oooooooo
00Koool00ol0VOooooooo`1Roooo002Woooo00<0000co`0co`0023?o00030000oooooooo00Koool0
0ol0VOooooooo`1Roooo002Woooo00<0000co`0co`0023?o00030000oooooooo00Koool00ol0VOoo
ooooo`1Roooo002Woooo00<0000co`0co`0023?o00030000oooooooo00Koool00ol0VOooooooo`1R
oooo002Woooo00<0000co`0co`0023?o00030000oooooooo00Koool00ol0VOooooooo`1Roooo002W
oooo00<0000co`0co`0023?o00030000oooooooo00Koool00ol0VOooooooo`1Roooo002Woooo0P00
00Tco`000`000?ooooooo`06oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000Pco`00
0`000?ooooooo`06oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000Lco`000`000?oo
ooooo`07oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`07
oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`07oooo00?o
09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`07oooo00?o09Wooooo
ool0H_ooo`00Yoooo`800008<ol000<0003oooooool01oooo`03o`2Ioooooooo06;oool00:Ooool0
0`0003?o03?o0007<ol000<0003oooooool01oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o
03?o0007<ol000<0003oooooool01oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o03?o0007
<ol000<0003oooooool01oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o03?o0007<ol000<0
003oooooool01oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o03?o0007<ol000<0003ooooo
ool01oooo`03o`2Ioooooooo06;oool00:Ooool200001c?o00030000oooooooo00Soool00ol0VOoo
ooooo`1Roooo002Woooo00<0000co`0co`001S?o00030000oooooooo00Soool00ol0VOooooooo`1R
oooo002Woooo00<0000co`0co`001S?o00030000oooooooo00Soool00ol0VOooooooo`1Roooo002W
oooo00<0000co`0co`001S?o00030000oooooooo00Soool00ol0VOooooooo`1Roooo002Poooo0P00
00Goool00`0003?o03?o0006<ol000<0003oooooool02?ooo`03o`2Ioooooooo06;oool009ooool0
10000?ooooooo`0000Coool00`0003?o03?o0006<ol000<0003oooooool02?ooo`03o`2Ioooooooo
06;oool00:7oool00`000?ooooooo`03oooo0`0000Hco`000`000?ooooooo`08oooo00?o09Wooooo
ool0H_ooo`00X_ooo`030000oooooooo00;oool00`0003?o03?o0006<ol000<0003oooooool02?oo
o`03o`2Ioooooooo06;oool009ooool010000?ooooooo`0000Coool00`0003?o03?o0006<ol000<0
003oooooool02?ooo`03o`2Ioooooooo06;oool00:3oool200001Oooo`030000<ol0<ol000Hco`00
0`000?ooooooo`08oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?oo
ooooo`09oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`09
oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`09oooo00?o
09Woooooool0H_ooo`00Yoooo`800006<ol000<0003oooooool02Oooo`03o`2Ioooooooo06;oool0
0:Ooool00`0003?o03?o0005<ol000<0003oooooool02Oooo`03o`2Ioooooooo06;oool00:Ooool0
0`0003?o03?o0005<ol000<0003oooooool02Oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o
03?o0005<ol000<0003oooooool02Oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o03?o0005
<ol000<0003oooooool02Oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o03?o0005<ol000<0
003oooooool02Oooo`03o`2Ioooooooo06;oool00:Ooool200001S?o00030000oooooooo00Woool0
0ol0VOooooooo`1Roooo002Woooo00<0000co`0co`0013?o00030000oooooooo00[oool00ol0VOoo
ooooo`1Roooo002Woooo00<0000co`0co`0013?o00030000oooooooo00[oool00ol0VOooooooo`1R
oooo002Woooo00<0000co`0co`0013?o00030000oooooooo00[oool00ol0VOooooooo`1Roooo002W
oooo00<0000co`0co`0013?o00030000oooooooo00[oool00ol0VOooooooo`1Roooo002Woooo00<0
000co`0co`0013?o00030000oooooooo00[oool00ol0VOooooooo`1Roooo002Woooo0P0000Dco`00
0`000?ooooooo`0:oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000@co`000`000?oo
ooooo`0:oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`0:
oooo00?o09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`0:oooo00?o
09Woooooool0H_ooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`0:oooo00?o09Wooooo
ool0H_ooo`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`0;oooo00?o09Woooooool0H_oo
o`00Yoooo`800004<ol000<0003oooooool02oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o
03?o0003<ol000<0003oooooool02oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o03?o0003
<ol000<0003oooooool02oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o03?o0003<ol000<0
003oooooool02oooo`03o`2Ioooooooo06;oool00:Ooool00`0003?o03?o0003<ol000<0003ooooo
ool02oooo`03o`2Ioooooooo06;oool00:7oool300000oooo`030000<ol0<ol000<co`000`000?oo
ooooo`0;oooo00?o09Woooooool0H_ooo`00X_ooo`030000oooooooo00;oool00`0003?o03?o0003
<ol000<0003oooooool02oooo`03o`2Ioooooooo06;oool009ooool500000oooo`<00003<ol000<0
003oooooool02oooo`03o`2Ioooooooo06;oool009ooool010000?ooooooo`0000Coool6<ol0Looo
o`00X?ooo`030000oooo000000Coool6<ol0Loooo`00XOooo`800004oooo1S?o07?oool00:Ooool6
<ol0Loooo`00Yoooo`Hco`1coooo001ioooo00<0003oooooool0:?ooo`030000oooooooo00Hco`1c
oooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?oooc?o0005<ol0Looo
o`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003
oooo0`0000Coool00`000?oooc?o0005<ol0Loooo`00N?ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003ooolco`001C?o07?oool007Ooool00`000?ooooooo`02oooo00<0
003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000<ol0<ol0
00@co`1coooo001hoooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool300001?oo
o`030000oooo<ol000Dco`1coooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo
00002Oooo`030000oooooooo00?oool00`000?oooc?o0005<ol0Loooo`00NOooo`030000oooooooo
01Ooool200002_ooo`<00002oooo00<0003oooooool01S?o07?oool00:Ooool6<ol0Loooo`00Yooo
o`Hco`1coooo0000\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {204.5, 63.1875}} -> {-0.349561, \
0.447144, 0.00349883, 0.00566123}, {{79.875, 308.563}, {204.5, 63.1875}} -> \
{-5.53614, 1.38097, 0.0207442, 0.0319664}, {{79.875, 308.563}, {204.5, \
63.1875}} -> {-5.53614, 1.38097, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.67958 .12361 L
.69774 .12361 L
.7026 .12361 L
.70516 .12361 L
.70656 .12361 L
.70787 .12361 L
.70901 .12361 L
s
.70901 .12361 m
.7095 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.28302 .12361 L
.2881 .12361 L
.29349 .12361 L
.29809 .12361 L
.29935 .12361 L
.3007 .12361 L
.30198 .12361 L
.30316 .12361 L
.30444 .12361 L
.30565 .12361 L
.30792 .12361 L
.313 .12361 L
.32214 .12361 L
.32466 .12361 L
.32604 .12361 L
.32733 .12361 L
.32842 .12361 L
.3296 .12493 L
.3321 .12809 L
.34286 .14068 L
.36267 .16005 L
.38422 .17656 L
.40492 .18889 L
.42407 .19787 L
.44432 .20536 L
.45424 .2084 L
.46334 .21087 L
.47219 .21302 L
.47664 .21401 L
.47786 .21427 L
.47916 .21455 L
.48039 .2148 L
.4815 .21432 L
.48273 .213 L
.48402 .21162 L
.48634 .20921 L
.49158 .20398 L
.50109 .19526 L
.53897 .16846 L
.55842 .15847 L
.57931 .14976 L
.58945 .14613 L
Mistroke
.60049 .14259 L
.61104 .13985 L
.62059 .13781 L
.6403 .13452 L
.66129 .13197 L
.68057 .1302 L
.69051 .12945 L
.69577 .12909 L
.70141 .12873 L
.70419 .12856 L
.70682 .1284 L
.70796 .12834 L
.70918 .12827 L
.70981 .12361 L
.71051 .12361 L
.71175 .12361 L
.713 .12361 L
.71414 .12361 L
.7154 .12361 L
.71672 .12361 L
.71788 .12361 L
.71895 .12361 L
.72013 .12361 L
.72138 .12361 L
.72208 .12361 L
.72281 .12361 L
.72412 .12361 L
.72484 .12361 L
.72552 .12361 L
.72627 .12361 L
.72707 .12361 L
.72776 .12361 L
.72851 .12361 L
.72922 .12361 L
.72988 .12361 L
.73112 .12361 L
.73244 .12361 L
.73362 .12361 L
.73489 .12361 L
.7361 .12361 L
.7372 .12361 L
.73842 .12361 L
.73912 .12361 L
.73976 .12361 L
.74107 .12361 L
.7418 .12361 L
.74246 .12361 L
.74365 .12361 L
.74477 .12361 L
.74599 .12361 L
Mistroke
.7473 .12361 L
.74796 .12361 L
.74867 .12361 L
.74998 .12361 L
.75125 .12361 L
.75243 .12361 L
.75363 .12361 L
.75476 .12361 L
.75578 .12361 L
.75688 .12361 L
.75808 .12361 L
.75935 .12361 L
.76044 .12361 L
.76162 .12361 L
.76229 .12361 L
.76302 .12361 L
.76434 .12361 L
.76563 .12361 L
.76682 .12361 L
.7681 .12361 L
.76883 .12361 L
.76951 .12361 L
.77023 .12361 L
.77089 .12361 L
.77162 .12361 L
.77238 .12361 L
.77358 .12361 L
.77486 .12361 L
.77607 .12361 L
.77717 .12361 L
.77847 .12361 L
.77915 .12361 L
.77987 .12361 L
.7805 .12361 L
.78119 .12361 L
.78241 .12361 L
.78362 .12361 L
.78491 .12361 L
.78565 .12361 L
.78632 .12361 L
.78763 .12361 L
.78886 .12361 L
.78955 .12361 L
.79018 .12361 L
.79135 .12361 L
.79258 .12361 L
.79369 .12361 L
.79488 .12361 L
.796 .12361 L
.79702 .12361 L
Mistroke
.79821 .12361 L
.79951 .12361 L
.80074 .12361 L
.80187 .12361 L
.80307 .12361 L
.80437 .12361 L
.80558 .12361 L
.8067 .12361 L
.808 .12361 L
.80874 .12361 L
.80943 .12361 L
.81068 .12361 L
.81138 .12361 L
.81202 .12361 L
.81331 .12361 L
.81396 .12361 L
.81468 .12361 L
.81545 .12361 L
.81617 .12361 L
.81684 .12361 L
.81755 .12361 L
.81823 .12361 L
.81896 .12361 L
.81964 .12361 L
.82028 .12361 L
.82149 .12361 L
.82277 .12361 L
.82391 .12361 L
.82515 .12361 L
.82645 .12361 L
.82766 .12361 L
.82879 .12361 L
.82982 .12361 L
.83101 .12361 L
.83214 .12361 L
.83336 .12361 L
.83466 .12361 L
.83576 .12361 L
.83698 .12361 L
.83829 .12361 L
.83902 .12361 L
.83969 .12361 L
.841 .12361 L
.84223 .12361 L
.84337 .12361 L
.84443 .12361 L
.84566 .12361 L
.84677 .12361 L
.85098 .12361 L
.85214 .12361 L
Mistroke
.85336 .12361 L
.85441 .12361 L
.85556 .12361 L
.8568 .12361 L
.85748 .12361 L
.85812 .12361 L
.85937 .12361 L
.86051 .12361 L
.86165 .12361 L
.86288 .12361 L
.86405 .12361 L
.86511 .12361 L
.86629 .12361 L
.86758 .12361 L
.86828 .12361 L
.86895 .12361 L
.87018 .12361 L
.87142 .12361 L
.87206 .12361 L
.87276 .12361 L
.87345 .12361 L
.87419 .12361 L
.8755 .12361 L
.88045 .12361 L
.88505 .12361 L
.88568 .12361 L
.88637 .12361 L
.88762 .12361 L
.88884 .12361 L
.88998 .12361 L
.89103 .12361 L
.89203 .12361 L
.89312 .12361 L
.89429 .12361 L
.89546 .12361 L
.89668 .12361 L
.89773 .12361 L
.89888 .12361 L
.90019 .12361 L
.90141 .12361 L
.90204 .12361 L
.90274 .12361 L
.90347 .12361 L
.90415 .12361 L
.9054 .12361 L
.90655 .12361 L
.90718 .12361 L
.90787 .12361 L
.90913 .12361 L
.91147 .12361 L
Mistroke
.91276 .12361 L
.91397 .12361 L
.9151 .12361 L
.91632 .12361 L
.91743 .12361 L
.91846 .12361 L
.91967 .12361 L
.92097 .12361 L
.92219 .12361 L
.92331 .12361 L
.924 .12361 L
.92465 .12361 L
.92533 .12361 L
.92608 .12361 L
.92731 .12361 L
.92801 .12361 L
.92864 .12361 L
.92993 .12361 L
.93058 .12361 L
.93129 .12361 L
.93201 .12361 L
.93278 .12361 L
.9335 .12361 L
.93416 .12361 L
.93546 .12361 L
.93618 .12361 L
.93686 .12361 L
.93809 .12361 L
.9394 .12361 L
.94057 .12361 L
.94185 .12361 L
.94306 .12361 L
.94419 .12361 L
.9453 .12361 L
.94631 .12361 L
.94747 .12361 L
.94856 .12361 L
.94976 .12361 L
.95103 .12361 L
.95211 .12361 L
.9533 .12361 L
.95457 .12361 L
.95529 .12361 L
.95594 .12361 L
.95721 .12361 L
.95841 .12361 L
.95943 .12361 L
.96056 .12361 L
.96173 .12361 L
.96284 .12361 L
Mistroke
.96387 .12361 L
.96481 .12361 L
.9659 .12361 L
.96693 .12361 L
.96804 .12361 L
.96923 .12361 L
.97034 .12361 L
.97136 .12361 L
.97255 .12361 L
.97385 .12361 L
.97507 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02koool00`000?ooooooo`0Joooo00<0
I_ooooooool04?ooo`030000oooooooo02goool00`0003?o03?o000A<ol02P1Voa8co`080000:Ooo
o`030000oooooooo01Goool006Goool00`1Vooooooooo`0ooooo00<0000co`0co`001c?o00X0I_l9
<ol000?o09Tco`0co`003C?o00<00019oooo001Voooo00<0I_ooooooool0?_ooo`030000<ol0<ol0
00<co`0406Ko4c?o0003o`2I<ol0<ol000Tco`040000C?ooo`00Ioooo`0306Kooooooooo03goool0
0`00001Vo`1Vo`0306Ko5c?o0003o`2I<ol0<ol000Lco`020000D?ooo`00J?ooo`0306Kooooooooo
03[oool206Ko00<0000co`0co`006S?o0003o`2I<ol0<ol000Hco`000`000?ooooooo`1@oooo001Y
oooo00<0I_ooooooool0=_ooo`<0I_l2oooo0P0001/co`000ol0VC?o03?o0004<ol00P0005?oool0
06[oool00`1Vooooooooo`0coooo0P1Vo`Goool00`0003?o03?o000J<ol000?o09Tco`0co`000S?o
0080001Eoooo001[oooo00<0I_ooooooool0<?ooo`80I_l7oooo00<0000co`0co`006S?o0005o`2I
<ol0<ol0<ol0000005Ooool006coool00`1Vooooooooo`0]oooo0P1Vo`Woool00`0003?o03?o000J
<ol000Co09Tco`0co`00001Hoooo001]oooo0P1Vob_oool206Ko2oooo`030000<ol0<ol001Xco`00
0ol0VC?o0000001Ioooo001_oooo00<0I_ooooooool09oooo`0306Kooooooooo00_oool00`0003?o
03?o000J<ol000?o09T0003oool0FOooo`00L?ooo`80I_lUoooo0P1Vo`koool200006c?o0003o`2I
0000oooo05Woool007;oool00`1Vooooooooo`0Qoooo00<0I_ooooooool03_ooo`030000<ol0<ol0
01Xco`000ol0VOooooooo`1Ioooo001coooo0P1Vob3oool00`1Vooooooooo`0?oooo00<0000co`0c
o`006C?o00030000o`2Ioooo05[oool007Goool206Ko7?ooo`80I_lBoooo00<0000co`0co`0063?o
00030000ooooo`2I05_oool007Ooool206Ko6Oooo`0306Kooooooooo01;oool00`0003?o03?o000G
<ol000@0003ooooooooo09UKoooo001ioooo0P1VoaGoool206Ko5Oooo`030000<ol0<ol001Hco`00
1@000?ooooooooooool0V@1Koooo001koooo0`1Voa7oool00`1Vooooooooo`0Eoooo0P0001Lco`00
1@000?ooooooooooool0V@1Koooo001noooo0P1Vo`koool00`1Vooooooooo`0Foooo00<0000co`0c
o`005C?o00030000oooooooo00;oool00ol0VOooooooo`1Ioooo0020oooo0P1Vo`_oool00`1Voooo
ooooo`0Goooo00<0000co`0co`005C?o00030000oooooooo00;oool00ol0VOooooooo`1Ioooo0022
oooo0`1Vo`Ooool00`1Vooooooooo`0Hoooo00<0000co`0co`005C?o00030000oooooooo00;oool0
0ol0VOooooooo`1Ioooo0025oooo1`1Voa_oool00`0003?o03?o000D<ol000<0003oooooool00ooo
o`03o`2Ioooooooo05Woool008[oool00`1Vooooooooo`0Joooo00<0000co`0co`0053?o00030000
oooooooo00?oool00ol0VOooooooo`1Ioooo002Woooo0P0001@co`000`000?ooooooo`04oooo00?o
09Woooooool0FOooo`00Yoooo`030000<ol0<ol001<co`000`000?ooooooo`04oooo00?o09Wooooo
ool0FOooo`00Yoooo`030000<ol0<ol001<co`000`000?ooooooo`04oooo00?o09Woooooool0FOoo
o`00Yoooo`030000<ol0<ol0018co`000`000?ooooooo`05oooo00?o09Woooooool0FOooo`00Yooo
o`030000<ol0<ol0018co`000`000?ooooooo`05oooo00?o09Woooooool0FOooo`00Woooo`D00003
oooo00<0000co`0co`004C?o00030000oooooooo00Koool00ol0VOooooooo`1Ioooo002Qoooo00<0
003oooooool00oooo`030000<ol0<ol0014co`000`000?ooooooo`06oooo00?o09Woooooool0FOoo
o`00XOooo`030000oooooooo00?oool300004C?o00030000oooooooo00Koool00ol0VOooooooo`1I
oooo002Qoooo00<0003oooooool00oooo`030000<ol0<ol0010co`000`000?ooooooo`07oooo00?o
09Woooooool0FOooo`00XOooo`030000oooooooo00?oool00`0003?o03?o000@<ol000<0003ooooo
ool01oooo`03o`2Ioooooooo05Woool00:3oool200001Oooo`030000<ol0<ol0010co`000`000?oo
ooooo`07oooo00?o09Woooooool0FOooo`00Yoooo`030000<ol0<ol0010co`000`000?ooooooo`07
oooo00?o09Woooooool0FOooo`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`08oooo00?o
09Woooooool0FOooo`00Yoooo`80000@<ol000<0003oooooool02?ooo`03o`2Ioooooooo05Woool0
0:Ooool00`0003?o03?o000?<ol000<0003oooooool02?ooo`03o`2Ioooooooo05Woool00:Ooool0
0`0003?o03?o000?<ol000<0003oooooool02?ooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o
03?o000><ol000<0003oooooool02Oooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o000>
<ol000<0003oooooool02Oooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o000><ol000<0
003oooooool02Oooo`03o`2Ioooooooo05Woool00:Ooool200003c?o00030000oooooooo00Woool0
0ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`003C?o00030000oooooooo00[oool00ol0VOoo
ooooo`1Ioooo002Woooo00<0000co`0co`003C?o00030000oooooooo00[oool00ol0VOooooooo`1I
oooo002Woooo00<0000co`0co`003C?o00030000oooooooo00[oool00ol0VOooooooo`1Ioooo002W
oooo00<0000co`0co`003C?o00030000oooooooo00[oool00ol0VOooooooo`1Ioooo002Woooo00<0
000co`0co`0033?o00030000oooooooo00_oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0c
o`0033?o00030000oooooooo00_oool00ol0VOooooooo`1Ioooo002Woooo0P0000dco`000`000?oo
ooooo`0;oooo00?o09Woooooool0FOooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`0;
oooo00?o09Woooooool0FOooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`0<oooo00?o
09Woooooool0FOooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`0<oooo00?o09Wooooo
ool0FOooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`0<oooo00?o09Woooooool0FOoo
o`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`0<oooo00?o09Woooooool0FOooo`00Yooo
o`80000<<ol000<0003oooooool03?ooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o000:
<ol000<0003oooooool03Oooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o000:<ol000<0
003oooooool03Oooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o000:<ol000<0003ooooo
ool03Oooo`03o`2Ioooooooo05Woool009ooool400001?ooo`030000<ol0<ol000Xco`000`000?oo
ooooo`0=oooo00?o09Woooooool0FOooo`00Woooo`030000oooooooo00Goool00`0003?o03?o000:
<ol000<0003oooooool03Oooo`03o`2Ioooooooo05Woool00:3oool00`000?ooooooo`04oooo0`00
00Xco`000`000?ooooooo`0=oooo00?o09Woooooool0FOooo`00XOooo`030000oooooooo00?oool0
0`0003?o03?o0009<ol000<0003oooooool03_ooo`03o`2Ioooooooo05Woool009ooool010000?oo
ooooo`0000Coool00`0003?o03?o0009<ol000<0003oooooool03_ooo`03o`2Ioooooooo05Woool0
0:3oool200001Oooo`030000<ol0<ol000Tco`000`000?ooooooo`0>oooo00?o09Woooooool0FOoo
o`00Yoooo`030000<ol0<ol000Tco`000`000?ooooooo`0>oooo00?o09Woooooool0FOooo`00Yooo
o`030000<ol0<ol000Tco`000`000?ooooooo`0>oooo00?o09Woooooool0FOooo`00Yoooo`80000:
<ol000<0003oooooool03_ooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o0008<ol000<0
003oooooool03oooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o0008<ol000<0003ooooo
ool03oooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o0008<ol000<0003oooooool03ooo
o`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o0008<ol000<0003oooooool03oooo`03o`2I
oooooooo05Woool00:Ooool00`0003?o03?o0008<ol000<0003oooooool03oooo`03o`2Ioooooooo
05Woool00:Ooool00`0003?o03?o0008<ol000<0003oooooool03oooo`03o`2Ioooooooo05Woool0
0:Ooool200002C?o00030000oooooooo00ooool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0c
o`0023?o00030000oooooooo00ooool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`001c?o
00030000oooooooo013oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`001c?o00030000
oooooooo013oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`001c?o00030000oooooooo
013oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`001c?o00030000oooooooo013oool0
0ol0VOooooooo`1Ioooo002Woooo0P0000Pco`000`000?ooooooo`0@oooo00?o09Woooooool0FOoo
o`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`0@oooo00?o09Woooooool0FOooo`00Yooo
o`030000<ol0<ol000Lco`000`000?ooooooo`0@oooo00?o09Woooooool0FOooo`00Yoooo`030000
<ol0<ol000Lco`000`000?ooooooo`0@oooo00?o09Woooooool0FOooo`00Yoooo`030000<ol0<ol0
00Lco`000`000?ooooooo`0@oooo00?o09Woooooool0FOooo`00Yoooo`030000<ol0<ol000Lco`00
0`000?ooooooo`0@oooo00?o09Woooooool0FOooo`00Yoooo`800007<ol000<0003oooooool04Ooo
o`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o0006<ol000<0003oooooool04Oooo`03o`2I
oooooooo05Woool00:Ooool00`0003?o03?o0006<ol000<0003oooooool04Oooo`03o`2Ioooooooo
05Woool00:Ooool00`0003?o03?o0006<ol000<0003oooooool04Oooo`03o`2Ioooooooo05Woool0
0:3oool200001Oooo`030000<ol0<ol000Hco`000`000?ooooooo`0Aoooo00?o09Woooooool0FOoo
o`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?ooooooo`0Aoooo00?o
09Woooooool0FOooo`00XOooo`030000oooooooo00?oool300001S?o00030000oooooooo017oool0
0ol0VOooooooo`1Ioooo002Roooo00<0003oooooool00_ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`0Aoooo00?o09Woooooool0FOooo`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`0Aoooo00?o09Woooooool0FOooo`00X?ooo`800005oooo00<0000co`0c
o`001S?o00030000oooooooo017oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`001C?o
00030000oooooooo01;oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`001C?o00030000
oooooooo01;oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`001C?o00030000oooooooo
01;oool00ol0VOooooooo`1Ioooo002Woooo0P0000Hco`000`000?ooooooo`0Boooo00?o09Wooooo
ool0FOooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`0Boooo00?o09Woooooool0FOoo
o`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`0Boooo00?o09Woooooool0FOooo`00Yooo
o`030000<ol0<ol000Dco`000`000?ooooooo`0Boooo00?o09Woooooool0FOooo`00Yoooo`030000
<ol0<ol000Dco`000`000?ooooooo`0Boooo00?o09Woooooool0FOooo`00Yoooo`030000<ol0<ol0
00Dco`000`000?ooooooo`0Boooo00?o09Woooooool0FOooo`00Yoooo`800006<ol000<0003ooooo
ool04_ooo`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o0004<ol000<0003oooooool04ooo
o`03o`2Ioooooooo05Woool00:Ooool00`0003?o03?o0004<ol000<0003oooooool04oooo`03o`2I
oooooooo05Woool00:Ooool00`0003?o03?o0004<ol000<0003oooooool04oooo`03o`2Ioooooooo
05Woool00:Ooool00`0003?o03?o0004<ol000<0003oooooool04oooo`03o`2Ioooooooo05Woool0
0:Ooool00`0003?o03?o0004<ol000<0003oooooool04oooo`03o`2Ioooooooo05Woool00:Ooool2
00001C?o00030000oooooooo01?oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`0013?o
00030000oooooooo01?oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`0013?o00030000
oooooooo01?oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`0013?o00030000oooooooo
01?oool00ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`0013?o00030000oooooooo01?oool0
0ol0VOooooooo`1Ioooo002Woooo00<0000co`0co`000c?o00030000oooooooo01Coool00ol0VOoo
ooooo`1Ioooo002Woooo0P0000@co`000`000?ooooooo`0Doooo00?o09Woooooool0FOooo`00Yooo
o`030000<ol0<ol000<co`000`000?ooooooo`0Doooo00?o09Woooooool0FOooo`00Yoooo`030000
<ol0<ol000<co`000`000?ooooooo`0Doooo00?o09Woooooool0FOooo`00Yoooo`030000<ol0<ol0
00<co`000`000?ooooooo`0Doooo00?o09Woooooool0FOooo`00Yoooo`030000<ol0<ol000<co`00
0`000?ooooooo`0Doooo00?o09Woooooool0FOooo`00XOooo`<00003oooo00<0000co`0co`000c?o
00030000oooooooo01Coool00ol0VOooooooo`1Ioooo002Roooo00<0003oooooool00_ooo`030000
<ol0<ol000<co`000`000?ooooooo`0Doooo00?o09Woooooool0FOooo`00Woooo`D00003oooo0`00
00<co`000`000?ooooooo`0Doooo00?o09Woooooool0FOooo`00Woooo`040000oooooooo00001?oo
o`Hco`1coooo002Poooo00<0003oool000001?ooo`Hco`1coooo002Qoooo0P0000Coool6<ol0Looo
o`00Yoooo`Hco`1coooo002Woooo1S?o07?oool007Woool00`000?ooooooo`0Xoooo00<0003ooooo
ool01S?o07?oool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooo<ol0
00Dco`1coooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004
oooo0P0000Goool300000_ooo`030000oooo<ol000Dco`1coooo001hoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`00
00_oool01P000?ooooooooooo`000?ooo`Hco`1coooo001goooo00<0003oooooool00_ooo`030000
oooooooo01?oool010000?ooooooo`0000Soool500000oooo`030000<ol0<ol000@co`1coooo001h
oooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?oooc?o0005<ol0Loooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Woool00`000?ooo`000003oooo00<0003ooolco`001C?o07?oool007Woool00`000?ooooooo`0G
oooo0P0000_oool200000_ooo`030000oooooooo00Hco`1coooo002Woooo1S?o07?oool00:Ooool6
<ol0Loooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {353.188, 211.875}} -> {-0.349561, \
1.49934, 0.00349883, 0.00566123}, {{79.875, 308.563}, {353.188, 211.875}} -> \
{-5.53614, 7.32223, 0.0207442, 0.0319664}, {{79.875, 308.563}, {353.188, \
211.875}} -> {-5.53614, 7.32223, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.71905 .12361 L
.72912 .12361 L
.73838 .12361 L
.74309 .12361 L
.74546 .12361 L
.74611 .12361 L
.7468 .12361 L
s
.7468 .12361 m
.74731 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.35271 .12361 L
.36173 .12361 L
.36405 .12361 L
.3652 .12361 L
.36626 .12361 L
.36748 .12466 L
.36812 .12548 L
.36881 .12635 L
.37114 .12926 L
.3815 .14127 L
.40147 .16066 L
.41198 .16916 L
.42308 .17707 L
.43303 .18332 L
.43575 .18491 L
.43868 .18655 L
.44009 .18733 L
.44143 .18805 L
.44264 .18869 L
.44395 .18797 L
.46315 .17486 L
.48253 .16427 L
.50393 .15502 L
.5432 .1429 L
.56254 .13858 L
.5834 .13479 L
.60344 .13185 L
.61352 .13072 L
.62454 .12971 L
.64415 .12832 L
.6651 .12722 L
.68645 .12639 L
.7066 .12579 L
.72661 .12533 L
.73551 .12515 L
.74041 .12507 L
.74506 .12499 L
.74624 .12497 L
.74749 .12495 L
.74821 .12361 L
Mistroke
.74886 .12361 L
.75013 .12361 L
.75128 .12361 L
.75251 .12361 L
.75368 .12361 L
.75476 .12361 L
.75585 .12361 L
.75686 .12361 L
.75798 .12361 L
.75917 .12361 L
.76042 .12361 L
.76161 .12361 L
.76267 .12361 L
.76383 .12361 L
.76511 .12361 L
.7663 .12361 L
.76762 .12361 L
.76829 .12361 L
.76903 .12361 L
.76976 .12361 L
.77044 .12361 L
.77115 .12361 L
.77192 .12361 L
.77263 .12361 L
.7733 .12361 L
.77456 .12361 L
.77576 .12361 L
.77703 .12361 L
.77812 .12361 L
.77931 .12361 L
.7806 .12361 L
.78132 .12361 L
.78198 .12361 L
.78326 .12361 L
.78447 .12361 L
.78556 .12361 L
.78675 .12361 L
.78806 .12361 L
.78926 .12361 L
.79045 .12361 L
.79175 .12361 L
.7924 .12361 L
.7931 .12361 L
.79436 .12361 L
.79555 .12361 L
.79683 .12361 L
.79796 .12361 L
.79916 .12361 L
.80024 .12361 L
.80143 .12361 L
Mistroke
.80252 .12361 L
.80353 .12361 L
.80481 .12361 L
.80553 .12361 L
.80621 .12361 L
.80744 .12361 L
.80875 .12361 L
.81004 .12361 L
.81126 .12361 L
.81235 .12361 L
.81353 .12361 L
.81483 .12361 L
.81557 .12361 L
.81625 .12361 L
.81698 .12361 L
.81764 .12361 L
.81841 .12361 L
.81913 .12361 L
.8204 .12361 L
.82107 .12361 L
.82178 .12361 L
.82297 .12361 L
.82428 .12361 L
.82542 .12361 L
.82663 .12361 L
.82733 .12361 L
.82796 .12361 L
.8292 .12361 L
.83048 .12361 L
.8312 .12361 L
.83187 .12361 L
.83309 .12361 L
.83438 .12361 L
.83548 .12361 L
.83667 .12361 L
.8378 .12361 L
.83885 .12361 L
.84006 .12361 L
.84135 .12361 L
.84255 .12361 L
.84364 .12361 L
.84491 .12361 L
.84563 .12361 L
.84629 .12361 L
.8475 .12361 L
.84878 .12361 L
.84996 .12361 L
.85107 .12361 L
.85228 .12361 L
.85358 .12361 L
Mistroke
.85431 .12361 L
.85499 .12361 L
.85573 .12361 L
.85652 .12361 L
.85784 .12361 L
.85859 .12361 L
.8593 .12361 L
.86061 .12361 L
.86181 .12361 L
.86247 .12361 L
.86319 .12361 L
.8645 .12361 L
.8658 .12361 L
.867 .12361 L
.8681 .12361 L
.86926 .12361 L
.87043 .12361 L
.87169 .12361 L
.8724 .12361 L
.87306 .12361 L
.87434 .12361 L
.87543 .12361 L
.87659 .12361 L
.87786 .12361 L
.87903 .12361 L
.88012 .12361 L
.88115 .12361 L
.88227 .12361 L
.88348 .12361 L
.88478 .12361 L
.88599 .12361 L
.88669 .12361 L
.88732 .12361 L
.88805 .12361 L
.88874 .12361 L
.88942 .12361 L
.89013 .12361 L
.8914 .12361 L
.89211 .12361 L
.89278 .12361 L
.8935 .12361 L
.89429 .12361 L
.89556 .12361 L
.89628 .12361 L
.89694 .12361 L
.89817 .12361 L
.89947 .12361 L
.90075 .12361 L
.90195 .12361 L
.90303 .12361 L
Mistroke
.9042 .12361 L
.90545 .12361 L
.90658 .12361 L
.90789 .12361 L
.90913 .12361 L
.91027 .12361 L
.91133 .12361 L
.91248 .12361 L
.91372 .12361 L
.91497 .12361 L
.91613 .12361 L
.91681 .12361 L
.91752 .12361 L
.91879 .12361 L
.91943 .12361 L
.92012 .12361 L
.92136 .12361 L
.92212 .12361 L
.92283 .12361 L
.92347 .12361 L
.92417 .12361 L
.92548 .12361 L
.92671 .12361 L
.92741 .12361 L
.92805 .12361 L
.9288 .12361 L
.9295 .12361 L
.93018 .12361 L
.9309 .12361 L
.9322 .12361 L
.93292 .12361 L
.9336 .12361 L
.93434 .12361 L
.93514 .12361 L
.93636 .12361 L
.93706 .12361 L
.9377 .12361 L
.93838 .12361 L
.9391 .12361 L
.94041 .12361 L
.9416 .12361 L
.94289 .12361 L
.94411 .12361 L
.94524 .12361 L
.94622 .12361 L
.94716 .12361 L
.94799 .12361 L
.94891 .12361 L
.9499 .12361 L
.95095 .12361 L
Mistroke
.95195 .12361 L
.95285 .12361 L
.95377 .12361 L
.95461 .12361 L
.95554 .12361 L
.95652 .12361 L
.95737 .12361 L
.95816 .12361 L
.95997 .12361 L
.96098 .12361 L
.96207 .12361 L
.96311 .12361 L
.96407 .12361 L
.96493 .12361 L
.96588 .12361 L
.96687 .12361 L
.9678 .12361 L
.96883 .12361 L
.96991 .12361 L
.97083 .12361 L
.97184 .12361 L
.97293 .12361 L
.97409 .12361 L
.97519 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<00000I_ooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000<co`0306Ko00<00000I_l0I_l01`1Vo`030000
06Ko06Ko00L0I_l00`0003?o03?o0006<ol000<0000co`0co`001C?o01X00005oooo00<0003ooooo
ool01oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0^oooo00<0003oooooool09?oo
o`0306Kooooooooo00Koool00`000?ooooooo`0]oooo00<00000I_l0I_l03@1VoaLco`000ol0VC?o
03?o0006<ol0200002Woool00`000?ooooooo`0Eoooo001_oooo00<0I_ooooooool0<?ooo`D0I_l0
0`0003?o03?o000T<ol000?o09Tco`0co`000c?o00<00019oooo001`oooo00<0I_ooooooool0:_oo
o`D0I_l5oooo00<0000co`0co`0093?o0003o`2I<ol0000000<0001<oooo001aoooo00<0I_oooooo
ool09Oooo`@0I_l:oooo00<0000co`0co`0093?o0003o`2I0000oooo04ooool007;oool00`1Voooo
ooooo`0Qoooo0`1Vo`koool00`0003?o03?o000S<ol000<0003o09Woool0D?ooo`00Loooo`0306Ko
oooooooo01coool406Ko4Oooo`80000R<ol00P000003ooooo`2Ioooo053oool007Coool00`1Voooo
ooooo`0Ioooo0P1VoaGoool00`0003?o03?o000O<ol00P0000?oool00ol0VOooooooo`1?oooo001e
oooo00<0I_ooooooool05_ooo`80I_lGoooo00<0000co`0co`007S?o00030000oooooooo00?oool0
0ol0VOooooooo`1?oooo001foooo00<0I_ooooooool04oooo`80I_lIoooo00<0000co`0co`007C?o
00030000oooooooo00Coool00ol0VOooooooo`1?oooo001goooo0P1Voa7oool206Ko6oooo`030000
<ol0<ol001`co`000`000?ooooooo`05oooo00?o09Woooooool0Coooo`00NOooo`0306Kooooooooo
00coool206Ko7Oooo`030000<ol0<ol001/co`000`000?ooooooo`06oooo00?o09Woooooool0Cooo
o`00N_ooo`0306Kooooooooo00Woool206Ko7oooo`80000L<ol000<0003oooooool01_ooo`03o`2I
oooooooo04ooool007_oool00`1Vooooooooo`07oooo00<0I_ooooooool07oooo`030000<ol0<ol0
01Xco`000`000?ooooooo`07oooo00?o09Woooooool0Coooo`00O?ooo`80I_l5oooo0P1Vob;oool0
0`0003?o03?o000I<ol000<0003oooooool02?ooo`03o`2Ioooooooo04ooool007koool206Ko0_oo
o`0306Kooooooooo02;oool00`0003?o03?o000H<ol000<0003oooooool02Oooo`03o`2Ioooooooo
04ooool0083oool206Ko9Oooo`030000<ol0<ol001Lco`000`000?ooooooo`0:oooo00?o09Wooooo
ool0Coooo`00Yoooo`030000<ol0<ol001Hco`000`000?ooooooo`0;oooo00?o09Woooooool0Cooo
o`00Yoooo`80000G<ol000<0003oooooool02oooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o
03?o000E<ol000<0003oooooool03?ooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o000E
<ol000<0003oooooool03?ooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o000E<ol000<0
003oooooool03?ooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o000D<ol000<0003ooooo
ool03Oooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o000D<ol000<0003oooooool03Ooo
o`03o`2Ioooooooo04ooool00:Ooool2000053?o00030000oooooooo00koool00ol0VOooooooo`1?
oooo002Woooo00<0000co`0co`004c?o00030000oooooooo00koool00ol0VOooooooo`1?oooo002W
oooo00<0000co`0co`004c?o00030000oooooooo00koool00ol0VOooooooo`1?oooo002Woooo00<0
000co`0co`004S?o00030000oooooooo00ooool00ol0VOooooooo`1?oooo002Woooo00<0000co`0c
o`004S?o00030000oooooooo00ooool00ol0VOooooooo`1?oooo002Ooooo1@0000?oool00`0003?o
03?o000A<ol000<0003oooooool04?ooo`03o`2Ioooooooo04ooool00:7oool00`000?ooooooo`03
oooo00<0000co`0co`004C?o00030000oooooooo013oool00ol0VOooooooo`1?oooo002Qoooo00<0
003oooooool00oooo`<0000A<ol000<0003oooooool04?ooo`03o`2Ioooooooo04ooool00:7oool0
0`000?ooooooo`03oooo00<0000co`0co`0043?o00030000oooooooo017oool00ol0VOooooooo`1?
oooo002Qoooo00<0003oooooool00oooo`030000<ol0<ol0010co`000`000?ooooooo`0Aoooo00?o
09Woooooool0Coooo`00X?ooo`800005oooo00<0000co`0co`0043?o00030000oooooooo017oool0
0ol0VOooooooo`1?oooo002Woooo00<0000co`0co`0043?o00030000oooooooo017oool00ol0VOoo
ooooo`1?oooo002Woooo00<0000co`0co`003c?o00030000oooooooo01;oool00ol0VOooooooo`1?
oooo002Woooo0P00010co`000`000?ooooooo`0Boooo00?o09Woooooool0Coooo`00Yoooo`030000
<ol0<ol000lco`000`000?ooooooo`0Boooo00?o09Woooooool0Coooo`00Yoooo`030000<ol0<ol0
00lco`000`000?ooooooo`0Boooo00?o09Woooooool0Coooo`00Yoooo`030000<ol0<ol000hco`00
0`000?ooooooo`0Coooo00?o09Woooooool0Coooo`00Yoooo`030000<ol0<ol000hco`000`000?oo
ooooo`0Coooo00?o09Woooooool0Coooo`00Yoooo`030000<ol0<ol000hco`000`000?ooooooo`0C
oooo00?o09Woooooool0Coooo`00Yoooo`80000?<ol000<0003oooooool04oooo`03o`2Ioooooooo
04ooool00:Ooool00`0003?o03?o000=<ol000<0003oooooool05?ooo`03o`2Ioooooooo04ooool0
0:Ooool00`0003?o03?o000=<ol000<0003oooooool05?ooo`03o`2Ioooooooo04ooool00:Ooool0
0`0003?o03?o000=<ol000<0003oooooool05?ooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o
03?o000=<ol000<0003oooooool05?ooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o000<
<ol000<0003oooooool05Oooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o000<<ol000<0
003oooooool05Oooo`03o`2Ioooooooo04ooool00:Ooool200003C?o00030000oooooooo01Goool0
0ol0VOooooooo`1?oooo002Woooo00<0000co`0co`0033?o00030000oooooooo01Goool00ol0VOoo
ooooo`1?oooo002Woooo00<0000co`0co`002c?o00030000oooooooo01Koool00ol0VOooooooo`1?
oooo002Woooo00<0000co`0co`002c?o00030000oooooooo01Koool00ol0VOooooooo`1?oooo002W
oooo00<0000co`0co`002c?o00030000oooooooo01Koool00ol0VOooooooo`1?oooo002Woooo00<0
000co`0co`002c?o00030000oooooooo01Koool00ol0VOooooooo`1?oooo002Woooo0P0000`co`00
0`000?ooooooo`0Foooo00?o09Woooooool0Coooo`00Yoooo`030000<ol0<ol000Xco`000`000?oo
ooooo`0Goooo00?o09Woooooool0Coooo`00Yoooo`030000<ol0<ol000Xco`000`000?ooooooo`0G
oooo00?o09Woooooool0Coooo`00Yoooo`030000<ol0<ol000Xco`000`000?ooooooo`0Goooo00?o
09Woooooool0Coooo`00Woooo`@00004oooo00<0000co`0co`002S?o00030000oooooooo01Ooool0
0ol0VOooooooo`1?oooo002Ooooo00<0003oooooool01Oooo`030000<ol0<ol000Xco`000`000?oo
ooooo`0Goooo00?o09Woooooool0Coooo`00X?ooo`030000oooooooo00Coool300002S?o00030000
oooooooo01Ooool00ol0VOooooooo`1?oooo002Qoooo00<0003oooooool00oooo`030000<ol0<ol0
00Tco`000`000?ooooooo`0Hoooo00?o09Woooooool0Coooo`00Woooo`040000oooooooo00001?oo
o`030000<ol0<ol000Tco`000`000?ooooooo`0Hoooo00?o09Woooooool0Coooo`00X?ooo`800005
oooo00<0000co`0co`002C?o00030000oooooooo01Soool00ol0VOooooooo`1?oooo002Woooo00<0
000co`0co`002C?o00030000oooooooo01Soool00ol0VOooooooo`1?oooo002Woooo00<0000co`0c
o`002C?o00030000oooooooo01Soool00ol0VOooooooo`1?oooo002Woooo0P0000Xco`000`000?oo
ooooo`0Hoooo00?o09Woooooool0Coooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`0I
oooo00?o09Woooooool0Coooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`0Ioooo00?o
09Woooooool0Coooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`0Ioooo00?o09Wooooo
ool0Coooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`0Ioooo00?o09Woooooool0Cooo
o`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`0Ioooo00?o09Woooooool0Coooo`00Yooo
o`030000<ol0<ol000Pco`000`000?ooooooo`0Ioooo00?o09Woooooool0Coooo`00Yoooo`800009
<ol000<0003oooooool06Oooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0008<ol000<0
003oooooool06Oooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0007<ol000<0003ooooo
ool06_ooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0007<ol000<0003oooooool06_oo
o`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0007<ol000<0003oooooool06_ooo`03o`2I
oooooooo04ooool00:Ooool00`0003?o03?o0007<ol000<0003oooooool06_ooo`03o`2Ioooooooo
04ooool00:Ooool2000023?o00030000oooooooo01[oool00ol0VOooooooo`1?oooo002Woooo00<0
000co`0co`001c?o00030000oooooooo01[oool00ol0VOooooooo`1?oooo002Woooo00<0000co`0c
o`001c?o00030000oooooooo01[oool00ol0VOooooooo`1?oooo002Woooo00<0000co`0co`001c?o
00030000oooooooo01[oool00ol0VOooooooo`1?oooo002Woooo00<0000co`0co`001c?o00030000
oooooooo01[oool00ol0VOooooooo`1?oooo002Woooo00<0000co`0co`001c?o00030000oooooooo
01[oool00ol0VOooooooo`1?oooo002Woooo0P0000Lco`000`000?ooooooo`0Koooo00?o09Wooooo
ool0Coooo`00Yoooo`030000<ol0<ol000Hco`000`000?ooooooo`0Koooo00?o09Woooooool0Cooo
o`00Yoooo`030000<ol0<ol000Hco`000`000?ooooooo`0Koooo00?o09Woooooool0Coooo`00Yooo
o`030000<ol0<ol000Hco`000`000?ooooooo`0Koooo00?o09Woooooool0Coooo`00X?ooo`800005
oooo00<0000co`0co`001S?o00030000oooooooo01_oool00ol0VOooooooo`1?oooo002Ooooo00@0
003oooooool00004oooo00<0000co`0co`001S?o00030000oooooooo01_oool00ol0VOooooooo`1?
oooo002Qoooo00<0003oooooool00oooo`<00006<ol000<0003oooooool06oooo`03o`2Ioooooooo
04ooool00:;oool00`000?ooooooo`02oooo00<0000co`0co`001S?o00030000oooooooo01_oool0
0ol0VOooooooo`1?oooo002Ooooo00@0003oooooool00004oooo00<0000co`0co`001S?o00030000
oooooooo01_oool00ol0VOooooooo`1?oooo002Poooo0P0000Goool00`0003?o03?o0006<ol000<0
003oooooool06oooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0005<ol000<0003ooooo
ool07?ooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0005<ol000<0003oooooool07?oo
o`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0005<ol000<0003oooooool07?ooo`03o`2I
oooooooo04ooool00:Ooool200001S?o00030000oooooooo01coool00ol0VOooooooo`1?oooo002W
oooo00<0000co`0co`001C?o00030000oooooooo01coool00ol0VOooooooo`1?oooo002Woooo00<0
000co`0co`001C?o00030000oooooooo01coool00ol0VOooooooo`1?oooo002Woooo00<0000co`0c
o`001C?o00030000oooooooo01coool00ol0VOooooooo`1?oooo002Woooo00<0000co`0co`001C?o
00030000oooooooo01coool00ol0VOooooooo`1?oooo002Woooo00<0000co`0co`001C?o00030000
oooooooo01coool00ol0VOooooooo`1?oooo002Woooo0P0000Hco`000`000?ooooooo`0Loooo00?o
09Woooooool0Coooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`0Moooo00?o09Wooooo
ool0Coooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`0Moooo00?o09Woooooool0Cooo
o`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`0Moooo00?o09Woooooool0Coooo`00Yooo
o`030000<ol0<ol000@co`000`000?ooooooo`0Moooo00?o09Woooooool0Coooo`00Yoooo`030000
<ol0<ol000@co`000`000?ooooooo`0Moooo00?o09Woooooool0Coooo`00Yoooo`800005<ol000<0
003oooooool07Oooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0004<ol000<0003ooooo
ool07Oooo`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool07Ooo
o`03o`2Ioooooooo04ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool07Oooo`03o`2I
oooooooo04ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool07Oooo`03o`2Ioooooooo
04ooool00:Ooool00`0003?o03?o0003<ol000<0003oooooool07_ooo`03o`2Ioooooooo04ooool0
0:Ooool2000013?o00030000oooooooo01koool00ol0VOooooooo`1?oooo002Woooo00<0000co`0c
o`000c?o00030000oooooooo01koool00ol0VOooooooo`1?oooo002Woooo00<0000co`0co`000c?o
00030000oooooooo01koool00ol0VOooooooo`1?oooo002Woooo00<0000co`0co`000c?o00030000
oooooooo01koool00ol0VOooooooo`1?oooo002Woooo00<0000co`0co`000c?o00030000oooooooo
01koool00ol0VOooooooo`1?oooo002Qoooo0`0000?oool00`0003?o03?o0003<ol000<0003ooooo
ool07_ooo`03o`2Ioooooooo04ooool00:;oool00`000?ooooooo`02oooo00<0000co`0co`000c?o
00030000oooooooo01koool00ol0VOooooooo`1?oooo002Ooooo1@0000?oool300000c?o00030000
oooooooo01koool00ol0VOooooooo`1?oooo002Ooooo00@0003oooooool00004oooo1S?o07?oool0
0:3oool00`000?ooo`000004oooo1S?o07?oool00:7oool200001?ooo`Hco`1coooo002Woooo1S?o
07?oool00:Ooool6<ol0Loooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`06<ol0Looo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003ooolco`001C?o07?oool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000ooo
o`@00003oooo00<0003ooolco`001C?o07?oool007Soool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`030000
oooooooo00Coool00`000?oooc?o0005<ol0Loooo`00Moooo`030000oooooooo00;oool00`000?oo
ooooo`0Coooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000<ol0<ol000@co`1c
oooo001hoooo00<0003oooooool01@0001;oool010000?ooooooo`0000[oool00`000?ooooooo`02
oooo00<0003ooolco`001C?o07?oool007Soool01@000?ooooooooooo`00000Eoooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003ooolco`001C?o07?oool007Woool00`000?oo
ooooo`0Goooo0P0000[oool200000oooo`030000oooooooo00Hco`1coooo002Woooo1S?o07?oool0
0:Ooool6<ol0Loooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {501.875, 360.563}} -> {-0.349561, \
2.55153, 0.00349883, 0.00566123}, {{79.875, 308.563}, {501.875, 360.563}} -> \
{-5.53614, 13.2635, 0.0207442, 0.0319664}, {{79.875, 308.563}, {501.875, \
360.563}} -> {-5.53614, 13.2635, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.75718 .12361 L
.76707 .12361 L
.77751 .12361 L
.78008 .12361 L
.78283 .12361 L
.78364 .12361 L
.78441 .12361 L
.7851 .12361 L
s
.7851 .12361 m
.7854 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.44268 .12361 L
.46172 .12361 L
.47994 .12361 L
.48519 .12361 L
.49018 .12361 L
.49466 .12361 L
.49589 .12361 L
.4972 .12361 L
.49843 .12361 L
.49955 .12361 L
.50075 .12361 L
.50188 .12361 L
.50443 .12361 L
.50958 .12361 L
.5188 .12361 L
.53962 .12361 L
.55825 .12361 L
.57853 .12361 L
.58388 .12361 L
.58956 .12361 L
.59189 .12361 L
.59312 .12361 L
.59441 .12361 L
.5951 .12361 L
.59585 .12361 L
.59717 .12361 L
.59782 .12361 L
.59852 .12361 L
.59977 .12361 L
.60042 .12361 L
.60112 .12361 L
.60237 .12361 L
.60306 .12361 L
.60371 .12361 L
.60442 .12361 L
.60519 .12361 L
.60585 .12361 L
.60656 .12361 L
.60786 .12361 L
Mistroke
.60915 .12361 L
.61031 .12361 L
.61155 .12361 L
.61272 .12361 L
.61395 .12361 L
.61464 .12361 L
.61528 .12361 L
.61635 .12361 L
.61752 .12361 L
.61875 .12361 L
.61989 .12361 L
.62115 .12361 L
.62179 .12361 L
.6225 .12361 L
.62374 .12361 L
.62491 .12361 L
.62558 .12361 L
.62628 .12361 L
.62754 .12361 L
.62824 .12361 L
.62891 .12361 L
.62967 .12361 L
.63037 .12361 L
.63155 .12361 L
.63282 .12361 L
.63401 .12361 L
.6351 .12361 L
.63639 .12361 L
.63712 .12361 L
.63778 .12361 L
.63898 .12361 L
.64028 .12361 L
.64143 .12361 L
.64249 .12361 L
.6435 .12361 L
.64458 .12361 L
.64574 .12361 L
.64683 .12361 L
.64802 .12361 L
.64931 .12361 L
.65046 .12361 L
.65173 .12361 L
.65305 .12361 L
.65428 .12361 L
.65543 .12361 L
.6565 .12361 L
.65762 .12361 L
.65885 .12361 L
.66011 .12361 L
.66082 .12361 L
Mistroke
.66147 .12361 L
.66271 .12361 L
.66389 .12361 L
.66454 .12361 L
.66524 .12361 L
.6665 .12361 L
.66727 .12361 L
.668 .12361 L
.66865 .12361 L
.66935 .12361 L
.67055 .12361 L
.67187 .12361 L
.67253 .12361 L
.67324 .12361 L
.67453 .12361 L
.6758 .12361 L
.67701 .12361 L
.6781 .12361 L
.67928 .12361 L
.68043 .12361 L
.68151 .12361 L
.68269 .12361 L
.68396 .12361 L
.68523 .12361 L
.68586 .12361 L
.68656 .12361 L
.68779 .12361 L
.68893 .12361 L
.6901 .12361 L
.6912 .12361 L
.69218 .12361 L
.69325 .12361 L
.69442 .12361 L
.69565 .12361 L
.6967 .12361 L
.69786 .12361 L
.69916 .12361 L
.70036 .12361 L
.70168 .12361 L
.70241 .12361 L
.70308 .12361 L
.70431 .12361 L
.705 .12361 L
.70563 .12361 L
.7068 .12361 L
.70803 .12361 L
.70914 .12361 L
.71033 .12361 L
.71145 .12361 L
.71247 .12361 L
Mistroke
.71366 .12361 L
.71496 .12361 L
.71619 .12361 L
.71732 .12361 L
.71851 .12361 L
.71965 .12361 L
.72095 .12361 L
.72215 .12361 L
.72346 .12361 L
.72415 .12361 L
.72489 .12361 L
.72559 .12361 L
.72623 .12361 L
.72747 .12361 L
.72814 .12361 L
.72885 .12361 L
.73013 .12361 L
.73083 .12361 L
.7315 .12361 L
.73222 .12361 L
.733 .12361 L
.73548 .12361 L
.73616 .12361 L
.7369 .12361 L
.73759 .12361 L
.73822 .12361 L
.73947 .12361 L
.74078 .12361 L
.74208 .12361 L
.74282 .12361 L
.7435 .12361 L
.74474 .12361 L
.74586 .12361 L
.74716 .12361 L
.74839 .12361 L
.74903 .12361 L
.74973 .12361 L
.75046 .12361 L
.75115 .12361 L
.75238 .12361 L
.7537 .12361 L
.75443 .12361 L
.75524 .12361 L
.756 .12361 L
.7567 .12361 L
.7574 .12361 L
.75803 .12361 L
.75876 .12361 L
.75945 .12361 L
.76062 .12361 L
Mistroke
.7619 .12361 L
.76255 .12361 L
.76324 .12361 L
.76449 .12361 L
.76574 .12361 L
.76691 .12361 L
.76797 .12361 L
.76912 .12361 L
.77037 .12361 L
.77109 .12361 L
.77176 .12361 L
.77246 .12361 L
.7731 .12361 L
.77381 .12361 L
.77455 .12361 L
.77579 .12361 L
.77695 .12361 L
.77822 .12361 L
.77893 .12361 L
.77957 .12361 L
.78077 .12361 L
.78189 .12361 L
.78311 .12361 L
.78443 .12361 L
.78509 .12361 L
.78581 .12361 L
.78712 .12361 L
.78839 .12361 L
.78957 .12361 L
.79066 .12361 L
.79169 .12361 L
.79282 .12361 L
.79404 .12361 L
.79524 .12361 L
.79651 .12361 L
.7976 .12361 L
.79878 .12361 L
.79946 .12361 L
.80019 .12361 L
.80087 .12361 L
.80151 .12361 L
.80271 .12361 L
.80399 .12361 L
.80465 .12361 L
.80536 .12361 L
.80664 .12361 L
.80742 .12361 L
.80816 .12361 L
.80883 .12361 L
.80956 .12361 L
Mistroke
.81088 .12361 L
.81208 .12361 L
.81274 .12361 L
.81346 .12361 L
.81476 .12361 L
.81598 .12361 L
.81728 .12361 L
.81838 .12361 L
.81959 .12361 L
.82081 .12361 L
.8221 .12361 L
.82278 .12361 L
.82352 .12361 L
.82483 .12361 L
.82607 .12361 L
.8274 .12361 L
.82865 .12361 L
.8298 .12361 L
.83092 .12361 L
.83197 .12361 L
.83311 .12361 L
.83433 .12361 L
.83562 .12361 L
.83684 .12361 L
.83793 .12361 L
.83911 .12361 L
.84041 .12361 L
.84162 .12361 L
.84231 .12361 L
.84296 .12361 L
.84371 .12361 L
.84439 .12361 L
.84507 .12361 L
.84578 .12361 L
.84707 .12361 L
.84786 .12361 L
.8486 .12361 L
.84927 .12361 L
.84999 .12361 L
.8512 .12361 L
.85189 .12361 L
.85254 .12361 L
.85383 .12361 L
.85522 .12361 L
.86002 .12361 L
.86125 .12361 L
.86195 .12361 L
.86258 .12361 L
.86381 .12361 L
.86497 .12361 L
Mistroke
.86617 .12361 L
.86747 .12361 L
.86816 .12361 L
.8689 .12361 L
.8696 .12361 L
.87023 .12361 L
.87097 .12361 L
.87165 .12361 L
.8724 .12361 L
.87319 .12361 L
.87388 .12361 L
.87452 .12361 L
.87523 .12361 L
.87599 .12361 L
.87667 .12361 L
.87742 .12361 L
.87812 .12361 L
.87877 .12361 L
.88 .12361 L
.88131 .12361 L
.88255 .12361 L
.88368 .12361 L
.88493 .12361 L
.88624 .12361 L
.88739 .12361 L
.88846 .12361 L
.88963 .12361 L
.89088 .12361 L
.89159 .12361 L
.89224 .12361 L
.89296 .12361 L
.89372 .12361 L
.895 .12361 L
.89573 .12361 L
.89641 .12361 L
.89768 .12361 L
.89884 .12361 L
.89948 .12361 L
.90017 .12361 L
.90144 .12361 L
.90269 .12361 L
.904 .12361 L
.90469 .12361 L
.90544 .12361 L
.90613 .12361 L
.90677 .12361 L
.90803 .12361 L
.90919 .12361 L
.90982 .12361 L
.91052 .12361 L
Mistroke
.91178 .12361 L
.91299 .12361 L
.91414 .12361 L
.91533 .12361 L
.91664 .12361 L
.91777 .12361 L
.91881 .12361 L
.91994 .12361 L
.92114 .12361 L
.92245 .12361 L
.92365 .12361 L
.92431 .12361 L
.92503 .12361 L
.92633 .12361 L
.92755 .12361 L
.92885 .12361 L
.92995 .12361 L
.93116 .12361 L
.93189 .12361 L
.93259 .12361 L
.93389 .12361 L
.93462 .12361 L
.93529 .12361 L
.93604 .12361 L
.93682 .12361 L
.93751 .12361 L
.93826 .12361 L
.93896 .12361 L
.9396 .12361 L
.94083 .12361 L
.94212 .12361 L
.94322 .12361 L
.94441 .12361 L
.94554 .12361 L
.94658 .12361 L
.94752 .12361 L
.94855 .12361 L
.94963 .12361 L
.95064 .12361 L
.95181 .12361 L
.95293 .12361 L
.95394 .12361 L
.95503 .12361 L
.95622 .12361 L
.95748 .12361 L
.95867 .12361 L
.95976 .12361 L
.96079 .12361 L
.96187 .12361 L
.9628 .12361 L
Mistroke
.96382 .12361 L
.96492 .12361 L
.96609 .12361 L
.96721 .12361 L
.96822 .12361 L
.96924 .12361 L
.97018 .12361 L
.97121 .12361 L
.97231 .12361 L
.97326 .12361 L
.97416 .12361 L
.97513 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Yooo
o`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_oo
o`00Yoooo`030000oooooooo07Koool00:Ooool20000Moooo`006?ooo`80000^oooo100002coool5
0000:_ooo`030000oooooooo02_oool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool0;?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool0;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000oooooooo
01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000oooooooo02Goool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000
oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?ooooooo`0002koool00`000?oo
ooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000^oooo0P0002coool20000;Oooo`80000_oooo0P0001Ooool00:Ooool0
0`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0
0:Ooool00`000?ooooooo`1foooo002Woooo00<0003oooooool0M_ooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02koool00`000?ooooooo`0]oooo00<0
003oooooool0;Oooo`030000<ol0<ol002dco`080000:Oooo`030000oooooooo01Goool00:Ooool0
0`0003?o03?o000Z<ol00`000003o`2Ioooooooo04Koool00:Ooool00`0003?o03?o000V<ol01000
00?oool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`0093?o00800007oooo00?o09Wooooo
ool0A_ooo`00Yoooo`030000<ol0<ol002<co`000`000?ooooooo`07oooo00?o09Woooooool0A_oo
o`00Yoooo`80000R<ol00P0000[oool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`007c?o
0080000<oooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol001hco`000`000?ooooooo`0<
oooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol001dco`000`000?ooooooo`0=oooo00?o
09Woooooool0A_ooo`00Yoooo`030000<ol0<ol001`co`000`000?ooooooo`0>oooo00?o09Wooooo
ool0A_ooo`00Yoooo`030000<ol0<ol001/co`000`000?ooooooo`0?oooo00?o09Woooooool0A_oo
o`00Yoooo`80000L<ol000<0003oooooool03oooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o
03?o000J<ol000<0003oooooool04?ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o000I
<ol000<0003oooooool04Oooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o000H<ol000<0
003oooooool04_ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o000G<ol000<0003ooooo
ool04oooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o000F<ol000<0003oooooool05?oo
o`03o`2Ioooooooo04Koool00:Ooool200005c?o00030000oooooooo01Coool00ol0VOooooooo`16
oooo002Woooo00<0000co`0co`005C?o00030000oooooooo01Goool00ol0VOooooooo`16oooo002W
oooo00<0000co`0co`005C?o00030000oooooooo01Goool00ol0VOooooooo`16oooo002Woooo00<0
000co`0co`005C?o00030000oooooooo01Goool00ol0VOooooooo`16oooo002Woooo00<0000co`0c
o`0053?o00030000oooooooo01Koool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`0053?o
00030000oooooooo01Koool00ol0VOooooooo`16oooo002Woooo0P0001@co`000`000?ooooooo`0G
oooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol001<co`000`000?ooooooo`0Goooo00?o
09Woooooool0A_ooo`00Yoooo`030000<ol0<ol001<co`000`000?ooooooo`0Goooo00?o09Wooooo
ool0A_ooo`00Yoooo`030000<ol0<ol0018co`000`000?ooooooo`0Hoooo00?o09Woooooool0A_oo
o`00Yoooo`030000<ol0<ol0018co`000`000?ooooooo`0Hoooo00?o09Woooooool0A_ooo`00Wooo
o`D00003oooo00<0000co`0co`004C?o00030000oooooooo01Woool00ol0VOooooooo`16oooo002Q
oooo00<0003oooooool00oooo`030000<ol0<ol0014co`000`000?ooooooo`0Ioooo00?o09Wooooo
ool0A_ooo`00XOooo`030000oooooooo00?oool300004C?o00030000oooooooo01Woool00ol0VOoo
ooooo`16oooo002Qoooo00<0003oooooool00oooo`030000<ol0<ol0010co`000`000?ooooooo`0J
oooo00?o09Woooooool0A_ooo`00XOooo`030000oooooooo00?oool00`0003?o03?o000@<ol000<0
003oooooool06_ooo`03o`2Ioooooooo04Koool00:3oool200001Oooo`030000<ol0<ol0010co`00
0`000?ooooooo`0Joooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol0010co`000`000?oo
ooooo`0Joooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`0K
oooo00?o09Woooooool0A_ooo`00Yoooo`80000@<ol000<0003oooooool06oooo`03o`2Ioooooooo
04Koool00:Ooool00`0003?o03?o000?<ol000<0003oooooool06oooo`03o`2Ioooooooo04Koool0
0:Ooool00`0003?o03?o000?<ol000<0003oooooool06oooo`03o`2Ioooooooo04Koool00:Ooool0
0`0003?o03?o000><ol000<0003oooooool07?ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o
03?o000><ol000<0003oooooool07?ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o000>
<ol000<0003oooooool07?ooo`03o`2Ioooooooo04Koool00:Ooool200003c?o00030000oooooooo
01coool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`003C?o00030000oooooooo01goool0
0ol0VOooooooo`16oooo002Woooo00<0000co`0co`003C?o00030000oooooooo01goool00ol0VOoo
ooooo`16oooo002Woooo00<0000co`0co`003C?o00030000oooooooo01goool00ol0VOooooooo`16
oooo002Woooo00<0000co`0co`003C?o00030000oooooooo01goool00ol0VOooooooo`16oooo002W
oooo00<0000co`0co`0033?o00030000oooooooo01koool00ol0VOooooooo`16oooo002Woooo00<0
000co`0co`0033?o00030000oooooooo01koool00ol0VOooooooo`16oooo002Woooo0P0000dco`00
0`000?ooooooo`0Noooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol000`co`000`000?oo
ooooo`0Noooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`0O
oooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`0Ooooo00?o
09Woooooool0A_ooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`0Ooooo00?o09Wooooo
ool0A_ooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`0Ooooo00?o09Woooooool0A_oo
o`00Yoooo`80000<<ol000<0003oooooool07oooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o
03?o000:<ol000<0003oooooool08?ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o000:
<ol000<0003oooooool08?ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o000:<ol000<0
003oooooool08?ooo`03o`2Ioooooooo04Koool009ooool400001?ooo`030000<ol0<ol000Xco`00
0`000?ooooooo`0Poooo00?o09Woooooool0A_ooo`00Woooo`030000oooooooo00Goool00`0003?o
03?o000:<ol000<0003oooooool08?ooo`03o`2Ioooooooo04Koool00:3oool00`000?ooooooo`04
oooo0`0000Xco`000`000?ooooooo`0Poooo00?o09Woooooool0A_ooo`00XOooo`030000oooooooo
00?oool00`0003?o03?o0009<ol000<0003oooooool08Oooo`03o`2Ioooooooo04Koool009ooool0
10000?ooooooo`0000Coool00`0003?o03?o0009<ol000<0003oooooool08Oooo`03o`2Ioooooooo
04Koool00:3oool200001Oooo`030000<ol0<ol000Tco`000`000?ooooooo`0Qoooo00?o09Wooooo
ool0A_ooo`00Yoooo`030000<ol0<ol000Tco`000`000?ooooooo`0Qoooo00?o09Woooooool0A_oo
o`00Yoooo`030000<ol0<ol000Tco`000`000?ooooooo`0Qoooo00?o09Woooooool0A_ooo`00Yooo
o`80000:<ol000<0003oooooool08Oooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0008
<ol000<0003oooooool08_ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0008<ol000<0
003oooooool08_ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0008<ol000<0003ooooo
ool08_ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0008<ol000<0003oooooool08_oo
o`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0008<ol000<0003oooooool08_ooo`03o`2I
oooooooo04Koool00:Ooool00`0003?o03?o0008<ol000<0003oooooool08_ooo`03o`2Ioooooooo
04Koool00:Ooool200002C?o00030000oooooooo02;oool00ol0VOooooooo`16oooo002Woooo00<0
000co`0co`0023?o00030000oooooooo02;oool00ol0VOooooooo`16oooo002Woooo00<0000co`0c
o`001c?o00030000oooooooo02?oool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`001c?o
00030000oooooooo02?oool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`001c?o00030000
oooooooo02?oool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`001c?o00030000oooooooo
02?oool00ol0VOooooooo`16oooo002Woooo0P0000Pco`000`000?ooooooo`0Soooo00?o09Wooooo
ool0A_ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`0Soooo00?o09Woooooool0A_oo
o`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`0Soooo00?o09Woooooool0A_ooo`00Yooo
o`030000<ol0<ol000Lco`000`000?ooooooo`0Soooo00?o09Woooooool0A_ooo`00Yoooo`030000
<ol0<ol000Lco`000`000?ooooooo`0Soooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol0
00Lco`000`000?ooooooo`0Soooo00?o09Woooooool0A_ooo`00Yoooo`800007<ol000<0003ooooo
ool09?ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0006<ol000<0003oooooool09?oo
o`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0006<ol000<0003oooooool09?ooo`03o`2I
oooooooo04Koool00:Ooool00`0003?o03?o0006<ol000<0003oooooool09?ooo`03o`2Ioooooooo
04Koool00:3oool200001Oooo`030000<ol0<ol000Hco`000`000?ooooooo`0Toooo00?o09Wooooo
ool0A_ooo`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?ooooooo`0T
oooo00?o09Woooooool0A_ooo`00XOooo`030000oooooooo00?oool300001S?o00030000oooooooo
02Coool00ol0VOooooooo`16oooo002Roooo00<0003oooooool00_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`0Toooo00?o09Woooooool0A_ooo`00Woooo`040000oooooooo00001?ooo`030000
<ol0<ol000Hco`000`000?ooooooo`0Toooo00?o09Woooooool0A_ooo`00X?ooo`800005oooo00<0
000co`0co`001S?o00030000oooooooo02Coool00ol0VOooooooo`16oooo002Woooo00<0000co`0c
o`001C?o00030000oooooooo02Goool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`001C?o
00030000oooooooo02Goool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`001C?o00030000
oooooooo02Goool00ol0VOooooooo`16oooo002Woooo0P0000Hco`000`000?ooooooo`0Uoooo00?o
09Woooooool0A_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`0Uoooo00?o09Wooooo
ool0A_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`0Uoooo00?o09Woooooool0A_oo
o`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`0Uoooo00?o09Woooooool0A_ooo`00Yooo
o`030000<ol0<ol000Dco`000`000?ooooooo`0Uoooo00?o09Woooooool0A_ooo`00Yoooo`030000
<ol0<ol000Dco`000`000?ooooooo`0Uoooo00?o09Woooooool0A_ooo`00Yoooo`800006<ol000<0
003oooooool09Oooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0004<ol000<0003ooooo
ool09_ooo`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0004<ol000<0003oooooool09_oo
o`03o`2Ioooooooo04Koool00:Ooool00`0003?o03?o0004<ol000<0003oooooool09_ooo`03o`2I
oooooooo04Koool00:Ooool00`0003?o03?o0004<ol000<0003oooooool09_ooo`03o`2Ioooooooo
04Koool00:Ooool00`0003?o03?o0004<ol000<0003oooooool09_ooo`03o`2Ioooooooo04Koool0
0:Ooool200001C?o00030000oooooooo02Koool00ol0VOooooooo`16oooo002Woooo00<0000co`0c
o`0013?o00030000oooooooo02Koool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`0013?o
00030000oooooooo02Koool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`0013?o00030000
oooooooo02Koool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`0013?o00030000oooooooo
02Koool00ol0VOooooooo`16oooo002Woooo00<0000co`0co`000c?o00030000oooooooo02Ooool0
0ol0VOooooooo`16oooo002Woooo0P0000@co`000`000?ooooooo`0Woooo00?o09Woooooool0A_oo
o`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`0Woooo00?o09Woooooool0A_ooo`00Yooo
o`030000<ol0<ol000<co`000`000?ooooooo`0Woooo00?o09Woooooool0A_ooo`00Yoooo`030000
<ol0<ol000<co`000`000?ooooooo`0Woooo00?o09Woooooool0A_ooo`00Yoooo`030000<ol0<ol0
00<co`000`000?ooooooo`0Woooo00?o09Woooooool0A_ooo`00XOooo`<00003oooo00<0000co`0c
o`000c?o00030000oooooooo02Ooool00ol0VOooooooo`16oooo002Roooo00<0003oooooool00_oo
o`030000<ol0<ol000<co`000`000?ooooooo`0Woooo00?o09Woooooool0A_ooo`00Woooo`D00003
oooo0`0000<co`000`000?ooooooo`0Woooo00?o09Woooooool0A_ooo`00Woooo`040000oooooooo
00001?ooo`Hco`1coooo002Poooo00<0003oool000001?ooo`Hco`1coooo002Qoooo0P0000Coool6
<ol0Loooo`00Yoooo`Hco`1coooo002Woooo1S?o07?oool007ooool00`000?ooooooo`0Loooo00<0
003oooooool01_ooo`Hco`1coooo001noooo00<0003oooooool02?ooo`030000oooooooo01?oool0
0`000?ooooooo`05oooo1S?o07?oool007koool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`07oooo0P0000Coool200001?ooo`030000oooooooo00Goool6<ol0Loooo`00O_ooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01Oooo`040000oooooooo
00002Oooo`030000oooooooo00Goool6<ol0Loooo`00OOooo`030000oooooooo00;oool00`000?oo
ooooo`0=oooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`Hco`1coooo001noooo00<0
003oooooool01@0000coool010000?ooooooo`0000Woool00`000?ooooooo`05oooo1S?o07?oool0
07koool01@000?ooooooooooo`00000?oooo00@0003oooooool00009oooo00<0003oooooool01Ooo
o`Hco`1coooo001ooooo00<0003oooooool04Oooo`800009oooo00<0003oooooool01_ooo`Hco`1c
oooo002Woooo1S?o07?oool00:Ooool6<ol0Loooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {650.563, 509.25}} -> {-0.349561, \
3.60372, 0.00349883, 0.00566123}, {{79.875, 308.563}, {650.563, 509.25}} -> \
{-5.53614, 19.2047, 0.0207442, 0.0319664}, {{79.875, 308.563}, {650.563, \
509.25}} -> {-5.53614, 19.2047, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.79749 .12361 L
.80799 .12361 L
.81373 .12361 L
.81654 .12361 L
.81909 .12361 L
.82028 .12361 L
.82156 .12361 L
.82277 .12361 L
s
.82277 .12361 m
.82322 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.35271 .12361 L
.36173 .12361 L
.36405 .12361 L
.3652 .12361 L
.36626 .12361 L
.36748 .12256 L
.36812 .12173 L
.36881 .12086 L
.37114 .11795 L
.3815 .10594 L
.40147 .08655 L
.41198 .07805 L
.42308 .07015 L
.43303 .0639 L
.43575 .06231 L
.43868 .06066 L
.44009 .05989 L
.44143 .05916 L
.44264 .05852 L
.44395 .05924 L
.46315 .07236 L
.48253 .08294 L
.50393 .09219 L
.5432 .10432 L
.56254 .10863 L
.5834 .11242 L
.60344 .11537 L
.61352 .11649 L
.62454 .1175 L
.64415 .11889 L
.6651 .11999 L
.68645 .12082 L
.7066 .12142 L
.72661 .12189 L
.74506 .12223 L
.76542 .12252 L
.78447 .12274 L
.8039 .12292 L
.81348 .12299 L
.81814 .12302 L
Mistroke
.82016 .12304 L
.82235 .12305 L
.82362 .12306 L
.82478 .12361 L
.82589 .12361 L
.82706 .12361 L
.82829 .12361 L
.82944 .12361 L
.83071 .12361 L
.83142 .12361 L
.83206 .12361 L
.83272 .12361 L
.83342 .12361 L
.83467 .12361 L
.83536 .12361 L
.83601 .12361 L
.83673 .12361 L
.8375 .12361 L
.83881 .12361 L
.83946 .12361 L
.84018 .12361 L
.84146 .12361 L
.84264 .12361 L
.8438 .12361 L
.84506 .12361 L
.84625 .12361 L
.84734 .12361 L
.84841 .12361 L
.84955 .12361 L
.85063 .12361 L
.85161 .12361 L
.85275 .12361 L
.85383 .12361 L
.85499 .12361 L
.85626 .12361 L
.8575 .12361 L
.85881 .12361 L
.85994 .12361 L
.86118 .12361 L
.86239 .12361 L
.86352 .12361 L
.86421 .12361 L
.86486 .12361 L
.86609 .12361 L
.86728 .12361 L
.86858 .12361 L
.86986 .12361 L
.87058 .12361 L
.87126 .12361 L
.87238 .12361 L
Mistroke
.87359 .12361 L
.87488 .12361 L
.87606 .12361 L
.87715 .12361 L
.87834 .12361 L
.87946 .12361 L
.8805 .12361 L
.88181 .12361 L
.88255 .12361 L
.88323 .12361 L
.88448 .12361 L
.8858 .12361 L
.88698 .12361 L
.88808 .12361 L
.88929 .12361 L
.8906 .12361 L
.89132 .12361 L
.89199 .12361 L
.89331 .12361 L
.89451 .12361 L
.89579 .12361 L
.89644 .12361 L
.89715 .12361 L
.89843 .12361 L
.89917 .12361 L
.89995 .12361 L
.90062 .12361 L
.90135 .12361 L
.90267 .12361 L
.90389 .12361 L
.90453 .12361 L
.90523 .12361 L
.90596 .12361 L
.90664 .12361 L
.9079 .12361 L
.90905 .12361 L
.90968 .12361 L
.91038 .12361 L
.91163 .12361 L
.91284 .12361 L
.91398 .12361 L
.91529 .12361 L
.91648 .12361 L
.91761 .12361 L
.91864 .12361 L
.91978 .12361 L
.92097 .12361 L
.92228 .12361 L
.92348 .12361 L
.92413 .12361 L
Mistroke
.92485 .12361 L
.92615 .12361 L
.92737 .12361 L
.92866 .12361 L
.92976 .12361 L
.93097 .12361 L
.93164 .12361 L
.93237 .12361 L
.93306 .12361 L
.9337 .12361 L
.93444 .12361 L
.93523 .12361 L
.93596 .12361 L
.93663 .12361 L
.93794 .12361 L
.93868 .12361 L
.93936 .12361 L
.94061 .12361 L
.94193 .12361 L
.94303 .12361 L
.94423 .12361 L
.94536 .12361 L
.9464 .12361 L
.94734 .12361 L
.94838 .12361 L
.94946 .12361 L
.95048 .12361 L
.9516 .12361 L
.95278 .12361 L
.95379 .12361 L
.95489 .12361 L
.95608 .12361 L
.95735 .12361 L
.95855 .12361 L
.95965 .12361 L
.96068 .12361 L
.96177 .12361 L
.9627 .12361 L
.96373 .12361 L
.96483 .12361 L
.96602 .12361 L
.96713 .12361 L
.96816 .12361 L
.96919 .12361 L
.97031 .12361 L
.9713 .12361 L
.97235 .12361 L
.97339 .12361 L
.97437 .12361 L
.97524 .12361 L
Mistroke
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002Woooo00<0
003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool00`000?ooooooo`1foooo002W
oooo00<0003oooooool0M_ooo`00Yoooo`80001goooo002Woooo00<0003oooooool0M_ooo`00Oooo
o`<0I_lUoooo00<0003oooooool0M_ooo`00O_ooo`80I_l2oooo0P1Vob?oool00`000?ooooooo`1f
oooo001loooo0P1Vo`Koool206Ko8Oooo`030000oooooooo07Koool007_oool00`1Vooooooooo`08
oooo00<0I_ooooooool07_ooo`030000oooooooo07Koool007[oool00`1Vooooooooo`0:oooo0P1V
oakoool20000Moooo`006?ooo`80000^oooo100002coool500003?ooo`80I_lLoooo00<0003ooooo
ool0:oooo`D0000/oooo100001Koool001Ooool010000?ooooooo`0002goool00`000?ooooooo`0/
oooo0P1Vo`03oooo0000oooo00ooool206Ko6_ooo`030000oooooooo02goool00`000?ooooooo`0/
oooo00<0003oooooool05oooo`006Oooo`030000oooooooo02goool00`000?ooooooo`0Zoooo00D0
I_ooooooooooool000004_ooo`80I_lHoooo00<0003oooooool0;Oooo`030000oooooooo02goool0
0`000?ooooooo`0Foooo000Aoooo100000Goool00`000?ooooooo`0Uoooo100000Coool00`000?oo
ooooo`0Uoooo100000Coool00`000?ooooooo`0Boooo0`1VoaGoool00`000?ooooooo`0]oooo00<0
003oooooool0;_ooo`030000oooooooo01Goool001Ooool010000?ooooooo`0002goool010000?oo
ooooo`0002Soool00`1Vooooooooo`03oooo00<0003oooooool05Oooo`80I_lCoooo00<0003ooooo
ool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool001Soool20000;oooo`80000X
oooo00<0I_ooooooool00oooo`80000Ioooo0`1Voa3oool20000;Oooo`80000_oooo0P0001Ooool0
07;oool00`1Vooooooooo`0Roooo0P1Vo`koool00`000?ooooooo`1foooo001aoooo00<0I_oooooo
ool09Oooo`@0I_l:oooo00<0003oooooool0M_ooo`00L?ooo`0306Kooooooooo02[oool506Ko1Ooo
o`030000oooooooo07Koool006ooool00`1Vooooooooo`0`oooo1@1Vo`04000006Ko06Ko06KoMOoo
o`00K_ooo`0306Kooooooooo03Koool010000?oooooooooooa40I_mToooo000@ooooo`00017oool0
01Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?oo
ooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01_oo
o`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo
00Ooool00`0003?o03?o0007<ol000<0000co`0co`001S?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001S?o00030000<ol0<ol000Dco`0J00001Oooo`030000oooooooo
00Ooool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0;_ooo`030000oooooooo02goool0
0`000?ooooooo`0]oooo00<0000co`0co`00;C?o00P00002oooo00?o09Woooooool09?ooo`030000
oooooooo01Goool00:Ooool00`0003?o03?o000Z<ol00`0000[oool00ol0VOooooooo`0loooo002W
oooo00<0000co`0co`009S?o00@0000=oooo00?o09Woooooool0??ooo`00Yoooo`030000<ol0<ol0
02@co`0200004Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000S<ol000<0003ooooo
ool04Oooo`03o`2Ioooooooo03coool00:Ooool200008S?o0080000Doooo00?o09Woooooool0??oo
o`00Yoooo`030000<ol0<ol001lco`0200005_ooo`03o`2Ioooooooo03coool00:Ooool00`0003?o
03?o000N<ol000<0003oooooool05_ooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000M
<ol000<0003oooooool05oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000L<ol000<0
003oooooool06?ooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000K<ol000<0003ooooo
ool06Oooo`03o`2Ioooooooo03coool00:Ooool2000073?o00030000oooooooo01Woool00ol0VOoo
ooooo`0loooo002Woooo00<0000co`0co`006S?o00030000oooooooo01[oool00ol0VOooooooo`0l
oooo002Woooo00<0000co`0co`006C?o00030000oooooooo01_oool00ol0VOooooooo`0loooo002W
oooo00<0000co`0co`0063?o00030000oooooooo01coool00ol0VOooooooo`0loooo002Woooo00<0
000co`0co`005c?o00030000oooooooo01goool00ol0VOooooooo`0loooo002Woooo00<0000co`0c
o`005S?o00030000oooooooo01koool00ol0VOooooooo`0loooo002Woooo0P0001Lco`000`000?oo
ooooo`0Noooo00?o09Woooooool0??ooo`00Yoooo`030000<ol0<ol001Dco`000`000?ooooooo`0O
oooo00?o09Woooooool0??ooo`00Yoooo`030000<ol0<ol001Dco`000`000?ooooooo`0Ooooo00?o
09Woooooool0??ooo`00Yoooo`030000<ol0<ol001Dco`000`000?ooooooo`0Ooooo00?o09Wooooo
ool0??ooo`00Yoooo`030000<ol0<ol001@co`000`000?ooooooo`0Poooo00?o09Woooooool0??oo
o`00Yoooo`030000<ol0<ol001@co`000`000?ooooooo`0Poooo00?o09Woooooool0??ooo`00Yooo
o`80000D<ol000<0003oooooool08Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000C
<ol000<0003oooooool08Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000C<ol000<0
003oooooool08Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000B<ol000<0003ooooo
ool08_ooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000B<ol000<0003oooooool08_oo
o`03o`2Ioooooooo03coool009ooool500000oooo`030000<ol0<ol0014co`000`000?ooooooo`0S
oooo00?o09Woooooool0??ooo`00XOooo`030000oooooooo00?oool00`0003?o03?o000A<ol000<0
003oooooool08oooo`03o`2Ioooooooo03coool00:7oool00`000?ooooooo`03oooo0`00014co`00
0`000?ooooooo`0Soooo00?o09Woooooool0??ooo`00XOooo`030000oooooooo00?oool00`0003?o
03?o000@<ol000<0003oooooool09?ooo`03o`2Ioooooooo03coool00:7oool00`000?ooooooo`03
oooo00<0000co`0co`0043?o00030000oooooooo02Coool00ol0VOooooooo`0loooo002Poooo0P00
00Goool00`0003?o03?o000@<ol000<0003oooooool09?ooo`03o`2Ioooooooo03coool00:Ooool0
0`0003?o03?o000@<ol000<0003oooooool09?ooo`03o`2Ioooooooo03coool00:Ooool00`0003?o
03?o000?<ol000<0003oooooool09Oooo`03o`2Ioooooooo03coool00:Ooool2000043?o00030000
oooooooo02Goool00ol0VOooooooo`0loooo002Woooo00<0000co`0co`003c?o00030000oooooooo
02Goool00ol0VOooooooo`0loooo002Woooo00<0000co`0co`003c?o00030000oooooooo02Goool0
0ol0VOooooooo`0loooo002Woooo00<0000co`0co`003S?o00030000oooooooo02Koool00ol0VOoo
ooooo`0loooo002Woooo00<0000co`0co`003S?o00030000oooooooo02Koool00ol0VOooooooo`0l
oooo002Woooo00<0000co`0co`003S?o00030000oooooooo02Koool00ol0VOooooooo`0loooo002W
oooo0P0000lco`000`000?ooooooo`0Voooo00?o09Woooooool0??ooo`00Yoooo`030000<ol0<ol0
00dco`000`000?ooooooo`0Woooo00?o09Woooooool0??ooo`00Yoooo`030000<ol0<ol000dco`00
0`000?ooooooo`0Woooo00?o09Woooooool0??ooo`00Yoooo`030000<ol0<ol000dco`000`000?oo
ooooo`0Woooo00?o09Woooooool0??ooo`00Yoooo`030000<ol0<ol000dco`000`000?ooooooo`0W
oooo00?o09Woooooool0??ooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`0Xoooo00?o
09Woooooool0??ooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`0Xoooo00?o09Wooooo
ool0??ooo`00Yoooo`80000=<ol000<0003oooooool0:?ooo`03o`2Ioooooooo03coool00:Ooool0
0`0003?o03?o000<<ol000<0003oooooool0:?ooo`03o`2Ioooooooo03coool00:Ooool00`0003?o
03?o000;<ol000<0003oooooool0:Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000;
<ol000<0003oooooool0:Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000;<ol000<0
003oooooool0:Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o000;<ol000<0003ooooo
ool0:Oooo`03o`2Ioooooooo03coool00:Ooool2000033?o00030000oooooooo02Woool00ol0VOoo
ooooo`0loooo002Woooo00<0000co`0co`002S?o00030000oooooooo02[oool00ol0VOooooooo`0l
oooo002Woooo00<0000co`0co`002S?o00030000oooooooo02[oool00ol0VOooooooo`0loooo002W
oooo00<0000co`0co`002S?o00030000oooooooo02[oool00ol0VOooooooo`0loooo002Ooooo1000
00Coool00`0003?o03?o000:<ol000<0003oooooool0:_ooo`03o`2Ioooooooo03coool009ooool0
0`000?ooooooo`05oooo00<0000co`0co`002S?o00030000oooooooo02[oool00ol0VOooooooo`0l
oooo002Poooo00<0003oooooool01?ooo`<0000:<ol000<0003oooooool0:_ooo`03o`2Ioooooooo
03coool00:7oool00`000?ooooooo`03oooo00<0000co`0co`002C?o00030000oooooooo02_oool0
0ol0VOooooooo`0loooo002Ooooo00@0003oooooool00004oooo00<0000co`0co`002C?o00030000
oooooooo02_oool00ol0VOooooooo`0loooo002Poooo0P0000Goool00`0003?o03?o0009<ol000<0
003oooooool0:oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0009<ol000<0003ooooo
ool0:oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0009<ol000<0003oooooool0:ooo
o`03o`2Ioooooooo03coool00:Ooool200002S?o00030000oooooooo02_oool00ol0VOooooooo`0l
oooo002Woooo00<0000co`0co`0023?o00030000oooooooo02coool00ol0VOooooooo`0loooo002W
oooo00<0000co`0co`0023?o00030000oooooooo02coool00ol0VOooooooo`0loooo002Woooo00<0
000co`0co`0023?o00030000oooooooo02coool00ol0VOooooooo`0loooo002Woooo00<0000co`0c
o`0023?o00030000oooooooo02coool00ol0VOooooooo`0loooo002Woooo00<0000co`0co`0023?o
00030000oooooooo02coool00ol0VOooooooo`0loooo002Woooo00<0000co`0co`0023?o00030000
oooooooo02coool00ol0VOooooooo`0loooo002Woooo0P0000Tco`000`000?ooooooo`0/oooo00?o
09Woooooool0??ooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`0/oooo00?o09Wooooo
ool0??ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`0]oooo00?o09Woooooool0??oo
o`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`0]oooo00?o09Woooooool0??ooo`00Yooo
o`030000<ol0<ol000Lco`000`000?ooooooo`0]oooo00?o09Woooooool0??ooo`00Yoooo`030000
<ol0<ol000Lco`000`000?ooooooo`0]oooo00?o09Woooooool0??ooo`00Yoooo`800008<ol000<0
003oooooool0;Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0007<ol000<0003ooooo
ool0;Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0;Ooo
o`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0;Oooo`03o`2I
oooooooo03coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0;Oooo`03o`2Ioooooooo
03coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0;Oooo`03o`2Ioooooooo03coool0
0:Ooool200001c?o00030000oooooooo02koool00ol0VOooooooo`0loooo002Woooo00<0000co`0c
o`001S?o00030000oooooooo02koool00ol0VOooooooo`0loooo002Woooo00<0000co`0co`001S?o
00030000oooooooo02koool00ol0VOooooooo`0loooo002Woooo00<0000co`0co`001S?o00030000
oooooooo02koool00ol0VOooooooo`0loooo002Poooo0P0000Goool00`0003?o03?o0006<ol000<0
003oooooool0;_ooo`03o`2Ioooooooo03coool009ooool010000?ooooooo`0000Coool00`0003?o
03?o0006<ol000<0003oooooool0;_ooo`03o`2Ioooooooo03coool00:7oool00`000?ooooooo`03
oooo0`0000Hco`000`000?ooooooo`0^oooo00?o09Woooooool0??ooo`00X_ooo`030000oooooooo
00;oool00`0003?o03?o0006<ol000<0003oooooool0;_ooo`03o`2Ioooooooo03coool009ooool0
10000?ooooooo`0000Coool00`0003?o03?o0006<ol000<0003oooooool0;_ooo`03o`2Ioooooooo
03coool00:3oool200001Oooo`030000<ol0<ol000Hco`000`000?ooooooo`0^oooo00?o09Wooooo
ool0??ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`0_oooo00?o09Woooooool0??oo
o`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`0_oooo00?o09Woooooool0??ooo`00Yooo
o`030000<ol0<ol000Dco`000`000?ooooooo`0_oooo00?o09Woooooool0??ooo`00Yoooo`800006
<ol000<0003oooooool0;oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0005<ol000<0
003oooooool0;oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0005<ol000<0003ooooo
ool0;oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0005<ol000<0003oooooool0;ooo
o`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0005<ol000<0003oooooool0;oooo`03o`2I
oooooooo03coool00:Ooool00`0003?o03?o0005<ol000<0003oooooool0;oooo`03o`2Ioooooooo
03coool00:Ooool200001S?o00030000oooooooo02ooool00ol0VOooooooo`0loooo002Woooo00<0
000co`0co`0013?o00030000oooooooo033oool00ol0VOooooooo`0loooo002Woooo00<0000co`0c
o`0013?o00030000oooooooo033oool00ol0VOooooooo`0loooo002Woooo00<0000co`0co`0013?o
00030000oooooooo033oool00ol0VOooooooo`0loooo002Woooo00<0000co`0co`0013?o00030000
oooooooo033oool00ol0VOooooooo`0loooo002Woooo00<0000co`0co`0013?o00030000oooooooo
033oool00ol0VOooooooo`0loooo002Woooo0P0000Dco`000`000?ooooooo`0`oooo00?o09Wooooo
ool0??ooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`0`oooo00?o09Woooooool0??oo
o`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`0`oooo00?o09Woooooool0??ooo`00Yooo
o`030000<ol0<ol000@co`000`000?ooooooo`0`oooo00?o09Woooooool0??ooo`00Yoooo`030000
<ol0<ol000@co`000`000?ooooooo`0`oooo00?o09Woooooool0??ooo`00Yoooo`030000<ol0<ol0
00<co`000`000?ooooooo`0aoooo00?o09Woooooool0??ooo`00Yoooo`800004<ol000<0003ooooo
ool0<Oooo`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0003<ol000<0003oooooool0<Ooo
o`03o`2Ioooooooo03coool00:Ooool00`0003?o03?o0003<ol000<0003oooooool0<Oooo`03o`2I
oooooooo03coool00:Ooool00`0003?o03?o0003<ol000<0003oooooool0<Oooo`03o`2Ioooooooo
03coool00:Ooool00`0003?o03?o0003<ol000<0003oooooool0<Oooo`03o`2Ioooooooo03coool0
0:7oool300000oooo`030000<ol0<ol000<co`000`000?ooooooo`0aoooo00?o09Woooooool0??oo
o`00X_ooo`030000oooooooo00;oool00`0003?o03?o0003<ol000<0003oooooool0<Oooo`03o`2I
oooooooo03coool009ooool500000oooo`<00003<ol000<0003oooooool0<Oooo`03o`2Ioooooooo
03coool009ooool010000?ooooooo`0000Coool6<ol0Loooo`00X?ooo`030000oooo000000Coool6
<ol0Loooo`00XOooo`800004oooo1S?o07?oool00:Ooool6<ol0Loooo`00Yoooo`Hco`1coooo001l
oooo00<0003oooooool08_ooo`030000oooooooo00?oool6<ol0Loooo`00Noooo`030000oooooooo
00Soool00`000?ooooooo`0Ioooo00<0003oooooool00_ooo`Hco`1coooo001koooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool01oooo`800004oooo0P0000?oool400000oooo`030000
oooooooo00;oool6<ol0Loooo`00Noooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01Oooo`040000oooooooo00002?ooo`030000oooooooo00Coool00`000?oo
ooooo`02oooo1S?o07?oool007[oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000
oooooooo00002Oooo`030000oooooooo00Coool010000?ooooooooooo`Hco`1coooo001koooo00<0
003oooooool01@0000coool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`Hco`1coooo001koooo00D0003oooooooooool000003oooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`030000oooooooo00;oool6<ol0Loooo`00O?ooo`030000oooooooo
017oool200002_ooo`800003oooo00<0003oooooool00oooo`Hco`1coooo002Woooo1S?o07?oool0
0:Ooool6<ol0Loooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {204.5, 63.1875}} -> {-0.349561, \
0.447144, 0.00349883, 0.00566123}, {{79.875, 308.563}, {204.5, 63.1875}} -> \
{-5.53614, 1.38097, 0.0207442, 0.0319664}, {{79.875, 308.563}, {204.5, \
63.1875}} -> {-5.53614, 1.38097, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.83996 .12361 L
.84911 .12361 L
.85396 .12361 L
.85663 .12361 L
.85916 .12361 L
.86034 .12361 L
.86159 .12361 L
s
.86159 .12361 m
.86185 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.31875 .12361 L
.32392 .12361 L
.32617 .12361 L
.32728 .12361 L
.32831 .12361 L
.32949 .12242 L
.33078 .12078 L
.33304 .11796 L
.34309 .10629 L
.36188 .08785 L
.38221 .07202 L
.40363 .05901 L
.4238 .04945 L
.44374 .04205 L
.4539 .03891 L
.4648 .03597 L
.47008 .03468 L
.47507 .03354 L
.47725 .03307 L
.47956 .03258 L
.48076 .03233 L
.48145 .03284 L
.48209 .03353 L
.48444 .03603 L
.50277 .05341 L
.54146 .08015 L
.5615 .09015 L
.5826 .09867 L
.60234 .10515 L
.62071 .10943 L
.64116 .11281 L
.65975 .11509 L
.67894 .11689 L
.69973 .11838 L
.71961 .11949 L
.74065 .1204 L
.77854 .12156 L
.79799 .12198 L
.81888 .12233 L
.84006 .12261 L
Mistroke
.84979 .12272 L
.85477 .12277 L
.85758 .1228 L
.86016 .12282 L
.8614 .12283 L
.86211 .12361 L
.86277 .12361 L
.86346 .12361 L
.8641 .12361 L
.86483 .12361 L
.86552 .12361 L
.87057 .12361 L
.8718 .12361 L
.87295 .12361 L
.87415 .12361 L
.87479 .12361 L
.87547 .12361 L
.87663 .12361 L
.87784 .12361 L
.87887 .12361 L
.88 .12361 L
.88116 .12361 L
.88221 .12361 L
.88343 .12361 L
.88457 .12361 L
.88564 .12361 L
.88661 .12361 L
.88769 .12361 L
.88882 .12361 L
.88996 .12361 L
.89118 .12361 L
.89233 .12361 L
.89339 .12361 L
.89462 .12361 L
.89532 .12361 L
.89596 .12361 L
.89714 .12361 L
.8984 .12361 L
.89954 .12361 L
.90078 .12361 L
.90207 .12361 L
.90328 .12361 L
.90441 .12361 L
.90544 .12361 L
.90663 .12361 L
.90776 .12361 L
.90898 .12361 L
.91027 .12361 L
.91138 .12361 L
.9126 .12361 L
Mistroke
.9139 .12361 L
.91464 .12361 L
.91531 .12361 L
.91661 .12361 L
.91785 .12361 L
.919 .12361 L
.92004 .12361 L
.92125 .12361 L
.92238 .12361 L
.92343 .12361 L
.9244 .12361 L
.92547 .12361 L
.92659 .12361 L
.92781 .12361 L
.92851 .12361 L
.92915 .12361 L
.93033 .12361 L
.93158 .12361 L
.93269 .12361 L
.93374 .12361 L
.93488 .12361 L
.93612 .12361 L
.93727 .12361 L
.93853 .12361 L
.93985 .12361 L
.94107 .12361 L
.94222 .12361 L
.94327 .12361 L
.94447 .12361 L
.94561 .12361 L
.94684 .12361 L
.94815 .12361 L
.94926 .12361 L
.95049 .12361 L
.9518 .12361 L
.95254 .12361 L
.95322 .12361 L
.95453 .12361 L
.95577 .12361 L
.95693 .12361 L
.95798 .12361 L
.95919 .12361 L
.96033 .12361 L
.96139 .12361 L
.96236 .12361 L
.96343 .12361 L
.96455 .12361 L
.96569 .12361 L
.96691 .12361 L
.96806 .12361 L
Mistroke
.96911 .12361 L
.97035 .12361 L
.97104 .12361 L
.97168 .12361 L
.97286 .12361 L
.97411 .12361 L
.97519 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool00:Ooool2
0000Moooo`00Yoooo`030000oooooooo07Koool008Woool206Ko7?ooo`030000oooooooo07Koool0
08Goool706Ko6oooo`030000oooooooo07Koool008?oool206Ko1oooo`0306Kooooooooo01Soool0
0`000?ooooooo`1foooo0020oooo0`1Vo`[oool00`1Vooooooooo`0Goooo00<0003oooooool0M_oo
o`00O_ooo`80I_l>oooo00<0I_ooooooool05_ooo`030000oooooooo07Koool007_oool306Ko4Ooo
o`0306Kooooooooo01Goool20000Moooo`00NOooo`80I_lEoooo00<0I_ooooooool05?ooo`030000
oooooooo07Koool007Ooool206Ko6?ooo`80I_lDoooo00<0003oooooool0M_ooo`00MOooo`80I_lL
oooo00<0I_ooooooool04Oooo`030000oooooooo07Koool007?oool206Ko7oooo`80I_lAoooo00<0
003oooooool0M_ooo`00LOooo`80I_lSoooo00<0I_ooooooool03_ooo`030000oooooooo07Koool0
073oool00`1Vooooooooo`0Toooo0P1Vo`koool20000Moooo`006?ooo`80000^oooo100002;oool2
06Ko2?ooo`D0000Loooo00<0I_ooooooool02oooo`030000oooooooo02_oool50000;?ooo`@0000F
oooo000Goooo00@0003oooooool0000]oooo00<0003oooooool08_ooo`0306Kooooooooo00[oool0
0`000?ooooooo`0Moooo0P1Vo`_oool00`000?ooooooo`0]oooo00<0003oooooool0;?ooo`030000
oooooooo01Ooool001Woool00`000?ooooooo`0]oooo00<0003oooooool08?ooo`0306Kooooooooo
00_oool00`000?ooooooo`0Ooooo0P1Vo`Woool00`000?ooooooo`0]oooo00<0003oooooool0;Ooo
o`030000oooooooo01Koool0017oool400001Oooo`030000oooooooo02Goool400001?ooo`030000
oooooooo01koool00`1Vooooooooo`04oooo100000Coool00`000?ooooooo`0Qoooo0`1Vo`Koool0
0`000?ooooooo`0]oooo00<0003oooooool0;_ooo`030000oooooooo01Goool001Ooool010000?oo
ooooo`0002goool010000?ooooooo`0001koool00`1Vooooooooo`0=oooo00<0003oooooool09?oo
o`80I_l4oooo00<0003oooooool0;Oooo`030000oooooooo02coool010000?ooooooo`0001Koool0
01Soool20000;oooo`80000Noooo00<0I_ooooooool03Oooo`80000Xoooo0`1Vo`03oooo00000000
02goool20000;oooo`80000Goooo001Xoooo00<0I_ooooooool0>oooo`0306Ko0000oooo07Ooool0
06Ooool00`1Vooooooooo`0moooo00<00000I_l0I_l00P1VogCoool006Koool00`1Vooooooooo`0n
oooo00<0003oooooool00_ooo`D0I_m_oooo001Voooo00<0I_ooooooool0?_ooo`030000oooooooo
00Ooool906KoI_ooo`00IOooo`0306Kooooooooo03ooool00`000?ooooooo`0@oooo401VoeKoool0
013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001C?o01X00005
oooo00<0003oooooool01oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0^oooo00<0
003oooooool0;Oooo`030000oooooooo02goool00`0003?o03?o000]<ol0200000coool00ol0VOoo
ooooo`0Joooo00<0003oooooool05Oooo`00Yoooo`030000<ol0<ol002Xco`0300005?ooo`03o`2I
oooooooo03;oool00:Ooool00`0003?o03?o000V<ol0100001Ooool00ol0VOooooooo`0boooo002W
oooo00<0000co`0co`0093?o0080000Koooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol0
02<co`000`000?ooooooo`0Koooo00?o09Woooooool0<_ooo`00Yoooo`80000R<ol00P0001koool0
0ol0VOooooooo`0boooo002Woooo00<0000co`0co`007c?o0080000Poooo00?o09Woooooool0<_oo
o`00Yoooo`030000<ol0<ol001hco`000`000?ooooooo`0Poooo00?o09Woooooool0<_ooo`00Yooo
o`030000<ol0<ol001dco`000`000?ooooooo`0Qoooo00?o09Woooooool0<_ooo`00Yoooo`030000
<ol0<ol001`co`000`000?ooooooo`0Roooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol0
01/co`000`000?ooooooo`0Soooo00?o09Woooooool0<_ooo`00Yoooo`80000L<ol000<0003ooooo
ool08oooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o000J<ol000<0003oooooool09?oo
o`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o000I<ol000<0003oooooool09Oooo`03o`2I
oooooooo03;oool00:Ooool00`0003?o03?o000H<ol000<0003oooooool09_ooo`03o`2Ioooooooo
03;oool00:Ooool00`0003?o03?o000G<ol000<0003oooooool09oooo`03o`2Ioooooooo03;oool0
0:Ooool00`0003?o03?o000F<ol000<0003oooooool0:?ooo`03o`2Ioooooooo03;oool00:Ooool2
00005c?o00030000oooooooo02Soool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`005C?o
00030000oooooooo02Woool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`005C?o00030000
oooooooo02Woool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`005C?o00030000oooooooo
02Woool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`0053?o00030000oooooooo02[oool0
0ol0VOooooooo`0boooo002Woooo00<0000co`0co`0053?o00030000oooooooo02[oool00ol0VOoo
ooooo`0boooo002Woooo0P0001@co`000`000?ooooooo`0[oooo00?o09Woooooool0<_ooo`00Yooo
o`030000<ol0<ol001<co`000`000?ooooooo`0[oooo00?o09Woooooool0<_ooo`00Yoooo`030000
<ol0<ol001<co`000`000?ooooooo`0[oooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol0
018co`000`000?ooooooo`0/oooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol0018co`00
0`000?ooooooo`0/oooo00?o09Woooooool0<_ooo`00Woooo`D00003oooo00<0000co`0co`004C?o
00030000oooooooo02goool00ol0VOooooooo`0boooo002Qoooo00<0003oooooool00oooo`030000
<ol0<ol0014co`000`000?ooooooo`0]oooo00?o09Woooooool0<_ooo`00XOooo`030000oooooooo
00?oool300004C?o00030000oooooooo02goool00ol0VOooooooo`0boooo002Qoooo00<0003ooooo
ool00oooo`030000<ol0<ol0010co`000`000?ooooooo`0^oooo00?o09Woooooool0<_ooo`00XOoo
o`030000oooooooo00?oool00`0003?o03?o000@<ol000<0003oooooool0;_ooo`03o`2Ioooooooo
03;oool00:3oool200001Oooo`030000<ol0<ol0010co`000`000?ooooooo`0^oooo00?o09Wooooo
ool0<_ooo`00Yoooo`030000<ol0<ol0010co`000`000?ooooooo`0^oooo00?o09Woooooool0<_oo
o`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`0_oooo00?o09Woooooool0<_ooo`00Yooo
o`80000@<ol000<0003oooooool0;oooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o000?
<ol000<0003oooooool0;oooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o000?<ol000<0
003oooooool0;oooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o000><ol000<0003ooooo
ool0<?ooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o000><ol000<0003oooooool0<?oo
o`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o000><ol000<0003oooooool0<?ooo`03o`2I
oooooooo03;oool00:Ooool200003c?o00030000oooooooo033oool00ol0VOooooooo`0boooo002W
oooo00<0000co`0co`003C?o00030000oooooooo037oool00ol0VOooooooo`0boooo002Woooo00<0
000co`0co`003C?o00030000oooooooo037oool00ol0VOooooooo`0boooo002Woooo00<0000co`0c
o`003C?o00030000oooooooo037oool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`003C?o
00030000oooooooo037oool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`0033?o00030000
oooooooo03;oool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`0033?o00030000oooooooo
03;oool00ol0VOooooooo`0boooo002Woooo0P0000dco`000`000?ooooooo`0boooo00?o09Wooooo
ool0<_ooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`0boooo00?o09Woooooool0<_oo
o`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`0coooo00?o09Woooooool0<_ooo`00Yooo
o`030000<ol0<ol000/co`000`000?ooooooo`0coooo00?o09Woooooool0<_ooo`00Yoooo`030000
<ol0<ol000/co`000`000?ooooooo`0coooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol0
00/co`000`000?ooooooo`0coooo00?o09Woooooool0<_ooo`00Yoooo`80000<<ol000<0003ooooo
ool0<oooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o000:<ol000<0003oooooool0=?oo
o`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o000:<ol000<0003oooooool0=?ooo`03o`2I
oooooooo03;oool00:Ooool00`0003?o03?o000:<ol000<0003oooooool0=?ooo`03o`2Ioooooooo
03;oool009ooool400001?ooo`030000<ol0<ol000Xco`000`000?ooooooo`0doooo00?o09Wooooo
ool0<_ooo`00Woooo`030000oooooooo00Goool00`0003?o03?o000:<ol000<0003oooooool0=?oo
o`03o`2Ioooooooo03;oool00:3oool00`000?ooooooo`04oooo0`0000Xco`000`000?ooooooo`0d
oooo00?o09Woooooool0<_ooo`00XOooo`030000oooooooo00?oool00`0003?o03?o0009<ol000<0
003oooooool0=Oooo`03o`2Ioooooooo03;oool009ooool010000?ooooooo`0000Coool00`0003?o
03?o0009<ol000<0003oooooool0=Oooo`03o`2Ioooooooo03;oool00:3oool200001Oooo`030000
<ol0<ol000Tco`000`000?ooooooo`0eoooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol0
00Tco`000`000?ooooooo`0eoooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000Tco`00
0`000?ooooooo`0eoooo00?o09Woooooool0<_ooo`00Yoooo`80000:<ol000<0003oooooool0=Ooo
o`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0=_ooo`03o`2I
oooooooo03;oool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0=_ooo`03o`2Ioooooooo
03;oool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0=_ooo`03o`2Ioooooooo03;oool0
0:Ooool00`0003?o03?o0008<ol000<0003oooooool0=_ooo`03o`2Ioooooooo03;oool00:Ooool0
0`0003?o03?o0008<ol000<0003oooooool0=_ooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o
03?o0008<ol000<0003oooooool0=_ooo`03o`2Ioooooooo03;oool00:Ooool200002C?o00030000
oooooooo03Koool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`0023?o00030000oooooooo
03Koool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`001c?o00030000oooooooo03Ooool0
0ol0VOooooooo`0boooo002Woooo00<0000co`0co`001c?o00030000oooooooo03Ooool00ol0VOoo
ooooo`0boooo002Woooo00<0000co`0co`001c?o00030000oooooooo03Ooool00ol0VOooooooo`0b
oooo002Woooo00<0000co`0co`001c?o00030000oooooooo03Ooool00ol0VOooooooo`0boooo002W
oooo0P0000Pco`000`000?ooooooo`0goooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol0
00Lco`000`000?ooooooo`0goooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000Lco`00
0`000?ooooooo`0goooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000Lco`000`000?oo
ooooo`0goooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`0g
oooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`0goooo00?o
09Woooooool0<_ooo`00Yoooo`800007<ol000<0003oooooool0>?ooo`03o`2Ioooooooo03;oool0
0:Ooool00`0003?o03?o0006<ol000<0003oooooool0>?ooo`03o`2Ioooooooo03;oool00:Ooool0
0`0003?o03?o0006<ol000<0003oooooool0>?ooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o
03?o0006<ol000<0003oooooool0>?ooo`03o`2Ioooooooo03;oool00:3oool200001Oooo`030000
<ol0<ol000Hco`000`000?ooooooo`0hoooo00?o09Woooooool0<_ooo`00Woooo`040000oooooooo
00001?ooo`030000<ol0<ol000Hco`000`000?ooooooo`0hoooo00?o09Woooooool0<_ooo`00XOoo
o`030000oooooooo00?oool300001S?o00030000oooooooo03Soool00ol0VOooooooo`0boooo002R
oooo00<0003oooooool00_ooo`030000<ol0<ol000Hco`000`000?ooooooo`0hoooo00?o09Wooooo
ool0<_ooo`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?ooooooo`0h
oooo00?o09Woooooool0<_ooo`00X?ooo`800005oooo00<0000co`0co`001S?o00030000oooooooo
03Soool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`001C?o00030000oooooooo03Woool0
0ol0VOooooooo`0boooo002Woooo00<0000co`0co`001C?o00030000oooooooo03Woool00ol0VOoo
ooooo`0boooo002Woooo00<0000co`0co`001C?o00030000oooooooo03Woool00ol0VOooooooo`0b
oooo002Woooo0P0000Hco`000`000?ooooooo`0ioooo00?o09Woooooool0<_ooo`00Yoooo`030000
<ol0<ol000Dco`000`000?ooooooo`0ioooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol0
00Dco`000`000?ooooooo`0ioooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000Dco`00
0`000?ooooooo`0ioooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?oo
ooooo`0ioooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`0i
oooo00?o09Woooooool0<_ooo`00Yoooo`800006<ol000<0003oooooool0>Oooo`03o`2Ioooooooo
03;oool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0>_ooo`03o`2Ioooooooo03;oool0
0:Ooool00`0003?o03?o0004<ol000<0003oooooool0>_ooo`03o`2Ioooooooo03;oool00:Ooool0
0`0003?o03?o0004<ol000<0003oooooool0>_ooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o
03?o0004<ol000<0003oooooool0>_ooo`03o`2Ioooooooo03;oool00:Ooool00`0003?o03?o0004
<ol000<0003oooooool0>_ooo`03o`2Ioooooooo03;oool00:Ooool200001C?o00030000oooooooo
03[oool00ol0VOooooooo`0boooo002Woooo00<0000co`0co`0013?o00030000oooooooo03[oool0
0ol0VOooooooo`0boooo002Woooo00<0000co`0co`0013?o00030000oooooooo03[oool00ol0VOoo
ooooo`0boooo002Woooo00<0000co`0co`0013?o00030000oooooooo03[oool00ol0VOooooooo`0b
oooo002Woooo00<0000co`0co`0013?o00030000oooooooo03[oool00ol0VOooooooo`0boooo002W
oooo00<0000co`0co`000c?o00030000oooooooo03_oool00ol0VOooooooo`0boooo002Woooo0P00
00@co`000`000?ooooooo`0koooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000<co`00
0`000?ooooooo`0koooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000<co`000`000?oo
ooooo`0koooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`0k
oooo00?o09Woooooool0<_ooo`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`0koooo00?o
09Woooooool0<_ooo`00XOooo`<00003oooo00<0000co`0co`000c?o00030000oooooooo03_oool0
0ol0VOooooooo`0boooo002Roooo00<0003oooooool00_ooo`030000<ol0<ol000<co`000`000?oo
ooooo`0koooo00?o09Woooooool0<_ooo`00Woooo`D00003oooo0`0000<co`000`000?ooooooo`0k
oooo00?o09Woooooool0<_ooo`00Woooo`040000oooooooo00001?ooo`Hco`1coooo002Poooo00<0
003oool000001?ooo`Hco`1coooo002Qoooo0P0000Coool6<ol0Loooo`00Yoooo`Hco`1coooo002W
oooo1S?o07?oool007coool00`000?ooooooo`0Roooo00<0003oooooool00oooo`Hco`1coooo001k
oooo00<0003oooooool02?ooo`030000oooooooo01Woool00`000?ooooooo`02oooo1S?o07?oool0
07_oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`07oooo0P0000Coool200001Ooo
o`<00002oooo00<0003oooooool00_ooo`Hco`1coooo001koooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`05oooo00@0003oooooool0000;oooo00D0003ooooo
ooooool000001?ooo`Hco`1coooo001joooo00<0003oooooool00_ooo`030000oooooooo00goool0
10000?ooooooo`0000Soool500000oooo`040000oooooooooooo1S?o07?oool007_oool00`000?oo
ooooo`0500003?ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00;oool6<ol0Loooo`00Noooo`050000oooooooooooo000000ooool010000?ooooooo`0000Woool0
0`000?ooo`000003oooo00<0003oooooool00_ooo`Hco`1coooo001loooo00<0003oooooool04Ooo
o`80000;oooo0P0000;oool00`000?ooooooo`03oooo1S?o07?oool00:Ooool6<ol0Loooo`00Yooo
o`Hco`1coooo0000\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {353.188, 211.875}} -> {-0.349561, \
1.49934, 0.00349883, 0.00566123}, {{79.875, 308.563}, {353.188, 211.875}} -> \
{-5.53614, 7.32223, 0.0207442, 0.0319664}, {{79.875, 308.563}, {353.188, \
211.875}} -> {-5.53614, 7.32223, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.87754 .12361 L
.88797 .12361 L
.89307 .12361 L
.89548 .12361 L
.89771 .12361 L
.89886 .12361 L
s
.89886 .12361 m
.89935 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.27731 .12361 L
.28302 .12361 L
.28542 .12361 L
.288 .12361 L
.28876 .12361 L
.28948 .12361 L
.29013 .12361 L
.29083 .12315 L
.2915 .12229 L
.29221 .12138 L
.29349 .11977 L
.30316 .10832 L
.32313 .08843 L
.34474 .0716 L
.3656 .05897 L
.3848 .04983 L
.40523 .04218 L
.42429 .03659 L
.44262 .03234 L
.46226 .02881 L
.4835 .02595 L
.49326 .02492 L
.50362 .024 L
.51309 .02331 L
.51568 .02315 L
.51704 .02307 L
.51778 .02302 L
.51848 .02298 L
.51974 .0238 L
.5204 .02462 L
.52111 .02548 L
.52353 .02838 L
.54195 .04805 L
.56187 .06535 L
.58345 .08052 L
.59356 .08662 L
.60425 .09222 L
.62343 .09971 L
.64301 .10517 L
.66132 .10899 L
.68161 .11222 L
.70014 .11451 L
Mistroke
.71917 .11637 L
.73991 .11795 L
.75962 .11913 L
.7806 .12011 L
.80206 .12089 L
.82224 .12146 L
.86084 .12224 L
.88082 .12253 L
.89087 .12265 L
.89363 .12268 L
.89658 .12271 L
.89801 .12273 L
.89871 .12273 L
.89936 .12274 L
.90058 .12361 L
.9019 .12361 L
.90308 .12361 L
.90432 .12361 L
.90538 .12361 L
.90654 .12361 L
.9078 .12361 L
.9085 .12361 L
.90914 .12361 L
.91038 .12361 L
.91155 .12361 L
.91265 .12361 L
.91381 .12361 L
.9148 .12361 L
.91589 .12361 L
.91707 .12361 L
.91833 .12361 L
.91951 .12361 L
.9206 .12361 L
.92186 .12361 L
.92305 .12361 L
.92429 .12361 L
.92495 .12361 L
.92567 .12361 L
.92639 .12361 L
.92716 .12361 L
.92781 .12361 L
.92853 .12361 L
.92919 .12361 L
.9299 .12361 L
.93118 .12361 L
.93248 .12361 L
.93321 .12361 L
.93388 .12361 L
.93512 .12361 L
.93644 .12361 L
Mistroke
.93753 .12361 L
.93871 .12361 L
.94 .12361 L
.94121 .12361 L
.94234 .12361 L
.94337 .12361 L
.94455 .12361 L
.94566 .12361 L
.9467 .12361 L
.94765 .12361 L
.94869 .12361 L
.94979 .12361 L
.95091 .12361 L
.9521 .12361 L
.95313 .12361 L
.95425 .12361 L
.95557 .12361 L
.95682 .12361 L
.95803 .12361 L
.95915 .12361 L
.96013 .12361 L
.96118 .12361 L
.96217 .12361 L
.96308 .12361 L
.96409 .12361 L
.96519 .12361 L
.96634 .12361 L
.96741 .12361 L
.96846 .12361 L
.9696 .12361 L
.97067 .12361 L
.97166 .12361 L
.97281 .12361 L
.97403 .12361 L
.97506 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool008goool8
06Ko4_ooo`80001goooo0023oooo2P1Vo`Ooool206Ko4Oooo`030000oooooooo07Koool007ooool4
06Ko4oooo`0306Kooooooooo00koool00`000?ooooooo`1foooo001koooo101VoaSoool00`1Voooo
ooooo`0=oooo00<0003oooooool0M_ooo`00NOooo`80I_lMoooo00<0I_ooooooool03?ooo`030000
oooooooo07Koool007Koool306Ko8?ooo`0306Kooooooooo00_oool00`000?ooooooo`1foooo001d
oooo0P1VobCoool00`1Vooooooooo`0:oooo00<0003oooooool0M_ooo`00LOooo`<0I_lWoooo00<0
I_ooooooool02Oooo`80001goooo001_oooo0P1Vob_oool00`1Vooooooooo`08oooo00<0003ooooo
ool0M_ooo`00KOooo`80I_l^oooo00<0I_ooooooool01oooo`030000oooooooo07Koool006_oool2
06Ko<Oooo`0306Kooooooooo00Koool00`000?ooooooo`1foooo001Yoooo0P1VocCoool00`1Voooo
ooooo`05oooo00<0003oooooool0M_ooo`00J?ooo`0306Kooooooooo03Goool206Ko1Oooo`030000
oooooooo07Koool006Koool206Ko>_ooo`80I_l3oooo0P0007Ooool001Soool20000;_ooo`@0000I
oooo00<0I_ooooooool04?ooo`D0000Woooo00@0I_ooooooool0000]oooo1@0002coool400005_oo
o`005oooo`040000oooooooo0000;Oooo`030000oooooooo01Soool206Ko5Oooo`030000oooooooo
02Soool206Ko00<0003oooooool0;Oooo`030000oooooooo02coool00`000?ooooooo`0Goooo000I
oooo00<0003oooooool0;Oooo`030000oooooooo01Koool00`1Vooooooooo`0Eoooo00<0003ooooo
ool0:_ooo`030000oooooooo02goool00`000?ooooooo`0]oooo00<0003oooooool05_ooo`004Ooo
o`@00005oooo00<0003oooooool09Oooo`@00004oooo00<0003oooooool05?ooo`0306Kooooooooo
00koool400001?ooo`030000oooooooo02[oool01000001Vo`1Vo`1Vobcoool00`000?ooooooo`0^
oooo00<0003oooooool05Oooo`005oooo`040000oooooooo0000;Oooo`040000oooooooo00005?oo
o`0306Kooooooooo01Ooool00`000?ooooooo`0Zoooo00@0003oooooooooool206Ko:_ooo`030000
oooooooo02coool010000?ooooooo`0001Koool001Soool20000;oooo`80000Doooo00<0I_oooooo
ool05oooo`80000/oooo0P0000Coool306Ko9_ooo`80000_oooo0P0001Ooool005ooool00`1Voooo
ooooo`15oooo00<0003oooooool01_ooo`80I_m^oooo001Noooo00<0I_ooooooool0A_ooo`030000
oooooooo00Soool406KoJ_ooo`00GOooo`0306Kooooooooo04Ooool00`000?ooooooo`0<oooo1@1V
ofGoool005coool00`1Vooooooooo`18oooo00<0003oooooool04Oooo`X0I_mKoooo001Koooo00<0
I_ooooooool0BOooo`030000oooooooo01_oool?06KoC?ooo`004?ooool0000Aoooo000Foooo00<0
003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?oo
ooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0
000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0co`001c?o
00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07oooo00<0
003oooooool05Oooo`005_ooo`030000oooooooo02koool00`000?ooooooo`0]oooo00<0003ooooo
ool0;Oooo`030000<ol0<ol002dco`0800005Oooo`03o`2Ioooooooo017oool00`000?ooooooo`0E
oooo002Woooo00<0000co`0co`00:S?o00<0000Moooo00?o09Woooooool0:Oooo`00Yoooo`030000
<ol0<ol002Hco`0400008?ooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o03?o000T<ol00P00
02Coool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`008c?o00030000oooooooo02Coool0
0ol0VOooooooo`0Yoooo002Woooo0P00028co`0200009oooo`03o`2Ioooooooo02Woool00:Ooool0
0`0003?o03?o000O<ol00P0002Woool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`007S?o
00030000oooooooo02Woool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`007C?o00030000
oooooooo02[oool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`0073?o00030000oooooooo
02_oool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`006c?o00030000oooooooo02coool0
0ol0VOooooooo`0Yoooo002Woooo0P0001`co`000`000?ooooooo`0/oooo00?o09Woooooool0:Ooo
o`00Yoooo`030000<ol0<ol001Xco`000`000?ooooooo`0]oooo00?o09Woooooool0:Oooo`00Yooo
o`030000<ol0<ol001Tco`000`000?ooooooo`0^oooo00?o09Woooooool0:Oooo`00Yoooo`030000
<ol0<ol001Pco`000`000?ooooooo`0_oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol0
01Lco`000`000?ooooooo`0`oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol001Hco`00
0`000?ooooooo`0aoooo00?o09Woooooool0:Oooo`00Yoooo`80000G<ol000<0003oooooool0<Ooo
o`03o`2Ioooooooo02Woool00:Ooool00`0003?o03?o000E<ol000<0003oooooool0<_ooo`03o`2I
oooooooo02Woool00:Ooool00`0003?o03?o000E<ol000<0003oooooool0<_ooo`03o`2Ioooooooo
02Woool00:Ooool00`0003?o03?o000E<ol000<0003oooooool0<_ooo`03o`2Ioooooooo02Woool0
0:Ooool00`0003?o03?o000D<ol000<0003oooooool0<oooo`03o`2Ioooooooo02Woool00:Ooool0
0`0003?o03?o000D<ol000<0003oooooool0<oooo`03o`2Ioooooooo02Woool00:Ooool2000053?o
00030000oooooooo03Coool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`004c?o00030000
oooooooo03Coool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`004c?o00030000oooooooo
03Coool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`004S?o00030000oooooooo03Goool0
0ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`004S?o00030000oooooooo03Goool00ol0VOoo
ooooo`0Yoooo002Ooooo1@0000?oool00`0003?o03?o000A<ol000<0003oooooool0=_ooo`03o`2I
oooooooo02Woool00:7oool00`000?ooooooo`03oooo00<0000co`0co`004C?o00030000oooooooo
03Koool00ol0VOooooooo`0Yoooo002Qoooo00<0003oooooool00oooo`<0000A<ol000<0003ooooo
ool0=_ooo`03o`2Ioooooooo02Woool00:7oool00`000?ooooooo`03oooo00<0000co`0co`0043?o
00030000oooooooo03Ooool00ol0VOooooooo`0Yoooo002Qoooo00<0003oooooool00oooo`030000
<ol0<ol0010co`000`000?ooooooo`0goooo00?o09Woooooool0:Oooo`00X?ooo`800005oooo00<0
000co`0co`0043?o00030000oooooooo03Ooool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0c
o`0043?o00030000oooooooo03Ooool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`003c?o
00030000oooooooo03Soool00ol0VOooooooo`0Yoooo002Woooo0P00010co`000`000?ooooooo`0h
oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`0hoooo00?o
09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`0hoooo00?o09Wooooo
ool0:Oooo`00Yoooo`030000<ol0<ol000hco`000`000?ooooooo`0ioooo00?o09Woooooool0:Ooo
o`00Yoooo`030000<ol0<ol000hco`000`000?ooooooo`0ioooo00?o09Woooooool0:Oooo`00Yooo
o`030000<ol0<ol000hco`000`000?ooooooo`0ioooo00?o09Woooooool0:Oooo`00Yoooo`80000?
<ol000<0003oooooool0>Oooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o03?o000=<ol000<0
003oooooool0>_ooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o03?o000=<ol000<0003ooooo
ool0>_ooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o03?o000=<ol000<0003oooooool0>_oo
o`03o`2Ioooooooo02Woool00:Ooool00`0003?o03?o000=<ol000<0003oooooool0>_ooo`03o`2I
oooooooo02Woool00:Ooool00`0003?o03?o000<<ol000<0003oooooool0>oooo`03o`2Ioooooooo
02Woool00:Ooool00`0003?o03?o000<<ol000<0003oooooool0>oooo`03o`2Ioooooooo02Woool0
0:Ooool200003C?o00030000oooooooo03_oool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0c
o`0033?o00030000oooooooo03_oool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`002c?o
00030000oooooooo03coool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`002c?o00030000
oooooooo03coool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`002c?o00030000oooooooo
03coool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`002c?o00030000oooooooo03coool0
0ol0VOooooooo`0Yoooo002Woooo0P0000`co`000`000?ooooooo`0loooo00?o09Woooooool0:Ooo
o`00Yoooo`030000<ol0<ol000Xco`000`000?ooooooo`0moooo00?o09Woooooool0:Oooo`00Yooo
o`030000<ol0<ol000Xco`000`000?ooooooo`0moooo00?o09Woooooool0:Oooo`00Yoooo`030000
<ol0<ol000Xco`000`000?ooooooo`0moooo00?o09Woooooool0:Oooo`00Woooo`@00004oooo00<0
000co`0co`002S?o00030000oooooooo03goool00ol0VOooooooo`0Yoooo002Ooooo00<0003ooooo
ool01Oooo`030000<ol0<ol000Xco`000`000?ooooooo`0moooo00?o09Woooooool0:Oooo`00X?oo
o`030000oooooooo00Coool300002S?o00030000oooooooo03goool00ol0VOooooooo`0Yoooo002Q
oooo00<0003oooooool00oooo`030000<ol0<ol000Tco`000`000?ooooooo`0noooo00?o09Wooooo
ool0:Oooo`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol000Tco`000`000?ooooooo`0n
oooo00?o09Woooooool0:Oooo`00X?ooo`800005oooo00<0000co`0co`002C?o00030000oooooooo
03koool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`002C?o00030000oooooooo03koool0
0ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`002C?o00030000oooooooo03koool00ol0VOoo
ooooo`0Yoooo002Woooo0P0000Xco`000`000?ooooooo`0noooo00?o09Woooooool0:Oooo`00Yooo
o`030000<ol0<ol000Pco`000`000?ooooooo`0ooooo00?o09Woooooool0:Oooo`00Yoooo`030000
<ol0<ol000Pco`000`000?ooooooo`0ooooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol0
00Pco`000`000?ooooooo`0ooooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000Pco`00
0`000?ooooooo`0ooooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000Pco`000`000?oo
ooooo`0ooooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`0o
oooo00?o09Woooooool0:Oooo`00Yoooo`800009<ol000<0003oooooool0?oooo`03o`2Ioooooooo
02Woool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0?oooo`03o`2Ioooooooo02Woool0
0:Ooool00`0003?o03?o0007<ol000<0003oooooool0@?ooo`03o`2Ioooooooo02Woool00:Ooool0
0`0003?o03?o0007<ol000<0003oooooool0@?ooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o
03?o0007<ol000<0003oooooool0@?ooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o03?o0007
<ol000<0003oooooool0@?ooo`03o`2Ioooooooo02Woool00:Ooool2000023?o00030000oooooooo
043oool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`001c?o00030000oooooooo043oool0
0ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`001c?o00030000oooooooo043oool00ol0VOoo
ooooo`0Yoooo002Woooo00<0000co`0co`001c?o00030000oooooooo043oool00ol0VOooooooo`0Y
oooo002Woooo00<0000co`0co`001c?o00030000oooooooo043oool00ol0VOooooooo`0Yoooo002W
oooo00<0000co`0co`001c?o00030000oooooooo043oool00ol0VOooooooo`0Yoooo002Woooo0P00
00Lco`000`000?ooooooo`11oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000Hco`00
0`000?ooooooo`11oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000Hco`000`000?oo
ooooo`11oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000Hco`000`000?ooooooo`11
oooo00?o09Woooooool0:Oooo`00X?ooo`800005oooo00<0000co`0co`001S?o00030000oooooooo
047oool00ol0VOooooooo`0Yoooo002Ooooo00@0003oooooool00004oooo00<0000co`0co`001S?o
00030000oooooooo047oool00ol0VOooooooo`0Yoooo002Qoooo00<0003oooooool00oooo`<00006
<ol000<0003oooooool0@Oooo`03o`2Ioooooooo02Woool00:;oool00`000?ooooooo`02oooo00<0
000co`0co`001S?o00030000oooooooo047oool00ol0VOooooooo`0Yoooo002Ooooo00@0003ooooo
ool00004oooo00<0000co`0co`001S?o00030000oooooooo047oool00ol0VOooooooo`0Yoooo002P
oooo0P0000Goool00`0003?o03?o0006<ol000<0003oooooool0@Oooo`03o`2Ioooooooo02Woool0
0:Ooool00`0003?o03?o0005<ol000<0003oooooool0@_ooo`03o`2Ioooooooo02Woool00:Ooool0
0`0003?o03?o0005<ol000<0003oooooool0@_ooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o
03?o0005<ol000<0003oooooool0@_ooo`03o`2Ioooooooo02Woool00:Ooool200001S?o00030000
oooooooo04;oool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`001C?o00030000oooooooo
04;oool00ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`001C?o00030000oooooooo04;oool0
0ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`001C?o00030000oooooooo04;oool00ol0VOoo
ooooo`0Yoooo002Woooo00<0000co`0co`001C?o00030000oooooooo04;oool00ol0VOooooooo`0Y
oooo002Woooo00<0000co`0co`001C?o00030000oooooooo04;oool00ol0VOooooooo`0Yoooo002W
oooo0P0000Hco`000`000?ooooooo`12oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol0
00@co`000`000?ooooooo`13oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000@co`00
0`000?ooooooo`13oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000@co`000`000?oo
ooooo`13oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`13
oooo00?o09Woooooool0:Oooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`13oooo00?o
09Woooooool0:Oooo`00Yoooo`800005<ol000<0003oooooool0@oooo`03o`2Ioooooooo02Woool0
0:Ooool00`0003?o03?o0004<ol000<0003oooooool0@oooo`03o`2Ioooooooo02Woool00:Ooool0
0`0003?o03?o0004<ol000<0003oooooool0@oooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o
03?o0004<ol000<0003oooooool0@oooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o03?o0004
<ol000<0003oooooool0@oooo`03o`2Ioooooooo02Woool00:Ooool00`0003?o03?o0003<ol000<0
003oooooool0A?ooo`03o`2Ioooooooo02Woool00:Ooool2000013?o00030000oooooooo04Coool0
0ol0VOooooooo`0Yoooo002Woooo00<0000co`0co`000c?o00030000oooooooo04Coool00ol0VOoo
ooooo`0Yoooo002Woooo00<0000co`0co`000c?o00030000oooooooo04Coool00ol0VOooooooo`0Y
oooo002Woooo00<0000co`0co`000c?o00030000oooooooo04Coool00ol0VOooooooo`0Yoooo002W
oooo00<0000co`0co`000c?o00030000oooooooo04Coool00ol0VOooooooo`0Yoooo002Qoooo0`00
00?oool00`0003?o03?o0003<ol000<0003oooooool0A?ooo`03o`2Ioooooooo02Woool00:;oool0
0`000?ooooooo`02oooo00<0000co`0co`000c?o00030000oooooooo04Coool00ol0VOooooooo`0Y
oooo002Ooooo1@0000?oool300000c?o00030000oooooooo04Coool00ol0VOooooooo`0Yoooo002O
oooo00@0003oooooool00004oooo1S?o07?oool00:3oool00`000?ooo`000004oooo1S?o07?oool0
0:7oool200001?ooo`Hco`1coooo002Woooo1S?o07?oool00:Ooool6<ol0Loooo`00O?ooo`030000
oooooooo02;oool00`000?ooooooo`03oooo1S?o07?oool007_oool00`000?ooooooo`08oooo00<0
003oooooool06Oooo`030000oooooooo00;oool6<ol0Loooo`00Noooo`030000oooooooo00;oool2
00001?ooo`030000oooooooo00Ooool200001?ooo`800003oooo0`0000Coool00`000?ooooooo`02
oooo1S?o07?oool007_oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`02
oooo1S?o07?oool007[oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo
00002?ooo`040000oooooooo00001?ooo`040000oooooooooooo1S?o07?oool007_oool00`000?oo
ooooo`0500003?ooo`040000oooooooo00002?ooo`<00004oooo00<0003oooooool00_ooo`Hco`1c
oooo001koooo00D0003oooooooooool000003oooo`040000oooooooo00002Oooo`030000oooooooo
00?oool00`000?ooooooo`02oooo1S?o07?oool007coool00`000?ooooooo`0Aoooo0P0000[oool3
00000_ooo`030000oooooooo00?oool6<ol0Loooo`00Yoooo`Hco`1coooo002Woooo1S?o07?oool0
0001\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {501.875, 360.563}} -> {-0.349561, \
2.55153, 0.00349883, 0.00566123}, {{79.875, 308.563}, {501.875, 360.563}} -> \
{-5.53614, 13.2635, 0.0207442, 0.0319664}, {{79.875, 308.563}, {501.875, \
360.563}} -> {-5.53614, 13.2635, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.91765 .12361 L
.92769 .12361 L
.93044 .12361 L
.93339 .12361 L
.93482 .12361 L
.93618 .12361 L
.93739 .12361 L
s
.93739 .12361 m
.93792 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.23739 .12361 L
.24276 .12361 L
.24745 .12361 L
.24873 .12361 L
.25012 .12361 L
.25142 .12361 L
.25261 .12331 L
.25377 .12182 L
.25484 .12046 L
.25728 .11743 L
.26171 .11214 L
.28051 .09254 L
.30084 .0757 L
.32225 .06186 L
.34242 .05169 L
.36236 .0438 L
.38342 .03732 L
.40306 .03265 L
.4214 .02925 L
.44175 .02638 L
.46031 .02444 L
.47939 .02304 L
.49017 .02248 L
.49497 .02228 L
.50015 .0221 L
.50517 .02196 L
.50978 .02186 L
.51418 .02179 L
.51639 .02177 L
.51881 .02174 L
.52021 .02174 L
.52152 .02173 L
.5227 .02173 L
.52397 .02172 L
.52464 .02172 L
.52537 .02172 L
.52613 .02172 L
.52684 .02172 L
.52812 .02173 L
.52883 .02173 L
.52949 .02174 L
.53192 .02175 L
Mistroke
.5333 .02177 L
.53458 .02178 L
.53942 .02185 L
.54451 .02196 L
.55001 .02212 L
.55254 .0222 L
.55392 .02225 L
.55521 .0223 L
.55631 .02235 L
.55748 .02284 L
.55879 .02457 L
.55998 .02612 L
.5786 .04819 L
.59934 .06844 L
.6185 .08187 L
.63712 .09112 L
.65688 .09839 L
.67639 .10381 L
.69468 .10776 L
.7149 .11117 L
.73342 .11363 L
.75399 .11579 L
.7731 .11737 L
.79274 .11866 L
.81126 .11963 L
.83175 .12048 L
.85035 .12109 L
.88887 .12201 L
.90879 .12234 L
.91895 .12248 L
.92454 .12255 L
.92984 .12262 L
.93475 .12267 L
.9361 .12269 L
.93684 .1227 L
.93753 .1227 L
.93875 .12361 L
.9394 .12361 L
.9401 .12361 L
.94123 .12361 L
.94248 .12361 L
.94377 .12361 L
.94498 .12361 L
.94611 .12361 L
.94714 .12361 L
.94833 .12361 L
.94946 .12361 L
.95051 .12361 L
.95168 .12361 L
.95289 .12361 L
Mistroke
.95403 .12361 L
.95509 .12361 L
.95606 .12361 L
.95718 .12361 L
.95825 .12361 L
.95939 .12361 L
.96061 .12361 L
.96176 .12361 L
.96281 .12361 L
.96404 .12361 L
.96473 .12361 L
.96537 .12361 L
.96654 .12361 L
.96778 .12361 L
.96888 .12361 L
.96988 .12361 L
.97104 .12361 L
.97213 .12361 L
.97314 .12361 L
.97408 .12361 L
.9751 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool008?ooolL
06Ko2?ooo`80001goooo001ioooo2P1Voa_oool00`1Vooooooooo`06oooo00<0003oooooool0M_oo
o`00MOooo`@0I_lVoooo00<0I_ooooooool01Oooo`030000oooooooo07Koool007?oool206Ko:ooo
o`0306Kooooooooo00Coool00`000?ooooooo`1foooo001_oooo101Vobkoool00`1Vooooooooo`03
oooo00<0003oooooool0M_ooo`00Joooo`@0I_lcoooo00<0I_ooooooool00_ooo`030000oooooooo
07Koool006Woool206Ko>?ooo`0506Kooooooooooooo000007Soool006Ooool206Ko>oooo`0306Ko
oooooooo0080001goooo001Uoooo0P1Vockoool00`1Vooooo`00001hoooo001Soooo0P1Vod7oool0
0`1Vo`000?ooo`1goooo001Roooo00<0I_ooooooool0@_ooo`030000oooooooo07Koool0063oool2
06KoAOooo`03000006Kooooo07Koool005koool206KoAoooo`030000oooo06Ko07Koool005coool2
06KoBOooo`8000000oooo`1Vo`1Vo`1doooo000Hoooo0P0002koool400003oooo`0306Kooooooooo
01[oool50000:_ooo`030000oooooooo00;oool00`1Vooooooooo`0Voooo1@0002coool400005_oo
o`005oooo`040000oooooooo0000;Oooo`030000oooooooo00ooool00`1Vooooooooo`0Moooo00<0
003oooooool0:_ooo`030000oooooooo00?oool206Ko:?ooo`030000oooooooo02coool00`000?oo
ooooo`0Goooo000Ioooo00<0003oooooool0;Oooo`030000oooooooo00goool00`1Vooooooooo`0N
oooo00<0003oooooool0:_ooo`030000oooooooo00Goool206Ko9_ooo`030000oooooooo02goool0
0`000?ooooooo`0Foooo000Aoooo100000Goool00`000?ooooooo`0Uoooo100000Coool00`000?oo
ooooo`0;oooo00<0I_ooooooool05oooo`@00004oooo00<0003oooooool0:_ooo`030000oooooooo
00Ooool306Ko8oooo`030000oooooooo02koool00`000?ooooooo`0Eoooo000Goooo00@0003ooooo
ool0000]oooo00@0003oooooool0000;oooo00<0I_ooooooool08?ooo`030000oooooooo02[oool0
0`000?ooooooo`0:oooo0P1Vob7oool00`000?ooooooo`0/oooo00@0003oooooool0000Foooo000H
oooo0P0002ooool200002oooo`0306Kooooooooo023oool20000;?ooo`80000=oooo101Voacoool2
0000;oooo`80000Goooo001Eoooo00<0I_ooooooool0Coooo`030000oooooooo013oool406KoH_oo
o`00E?ooo`0306Kooooooooo053oool00`000?ooooooo`0Doooo1@1Voegoool005?oool00`1Voooo
ooooo`1Aoooo00<0003oooooool06Oooo`D0I_mHoooo001Boooo00<0I_ooooooool0D_ooo`030000
oooooooo01koool:06KoC_ooo`00DOooo`0306Kooooooooo05?oool00`000?ooooooo`0Xoooo3`1V
ocooool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_oo
o`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo
00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`06oooo00<0003oooooool01oooo`030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0
000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0co`001C?o
01X00005oooo00<0003oooooool01oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0^
oooo00<0003oooooool0;Oooo`030000oooooooo02goool00`0003?o03?o000]<ol0200001ooool0
0ol0VOooooooo`07oooo00<0003oooooool05Oooo`00Yoooo`030000<ol0<ol002Xco`0300009ooo
o`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000V<ol0100002[oool00ol0VOooooooo`0O
oooo002Woooo00<0000co`0co`0093?o0080000^oooo00?o09Woooooool07oooo`00Yoooo`030000
<ol0<ol002<co`000`000?ooooooo`0^oooo00?o09Woooooool07oooo`00Yoooo`80000R<ol00P00
037oool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`007c?o0080000coooo00?o09Wooooo
ool07oooo`00Yoooo`030000<ol0<ol001hco`000`000?ooooooo`0coooo00?o09Woooooool07ooo
o`00Yoooo`030000<ol0<ol001dco`000`000?ooooooo`0doooo00?o09Woooooool07oooo`00Yooo
o`030000<ol0<ol001`co`000`000?ooooooo`0eoooo00?o09Woooooool07oooo`00Yoooo`030000
<ol0<ol001/co`000`000?ooooooo`0foooo00?o09Woooooool07oooo`00Yoooo`80000L<ol000<0
003oooooool0=_ooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000J<ol000<0003ooooo
ool0=oooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000I<ol000<0003oooooool0>?oo
o`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000H<ol000<0003oooooool0>Oooo`03o`2I
oooooooo01ooool00:Ooool00`0003?o03?o000G<ol000<0003oooooool0>_ooo`03o`2Ioooooooo
01ooool00:Ooool00`0003?o03?o000F<ol000<0003oooooool0>oooo`03o`2Ioooooooo01ooool0
0:Ooool200005c?o00030000oooooooo03_oool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0c
o`005C?o00030000oooooooo03coool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`005C?o
00030000oooooooo03coool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`005C?o00030000
oooooooo03coool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`0053?o00030000oooooooo
03goool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`0053?o00030000oooooooo03goool0
0ol0VOooooooo`0Ooooo002Woooo0P0001@co`000`000?ooooooo`0noooo00?o09Woooooool07ooo
o`00Yoooo`030000<ol0<ol001<co`000`000?ooooooo`0noooo00?o09Woooooool07oooo`00Yooo
o`030000<ol0<ol001<co`000`000?ooooooo`0noooo00?o09Woooooool07oooo`00Yoooo`030000
<ol0<ol0018co`000`000?ooooooo`0ooooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol0
018co`000`000?ooooooo`0ooooo00?o09Woooooool07oooo`00Woooo`D00003oooo00<0000co`0c
o`004C?o00030000oooooooo043oool00ol0VOooooooo`0Ooooo002Qoooo00<0003oooooool00ooo
o`030000<ol0<ol0014co`000`000?ooooooo`10oooo00?o09Woooooool07oooo`00XOooo`030000
oooooooo00?oool300004C?o00030000oooooooo043oool00ol0VOooooooo`0Ooooo002Qoooo00<0
003oooooool00oooo`030000<ol0<ol0010co`000`000?ooooooo`11oooo00?o09Woooooool07ooo
o`00XOooo`030000oooooooo00?oool00`0003?o03?o000@<ol000<0003oooooool0@Oooo`03o`2I
oooooooo01ooool00:3oool200001Oooo`030000<ol0<ol0010co`000`000?ooooooo`11oooo00?o
09Woooooool07oooo`00Yoooo`030000<ol0<ol0010co`000`000?ooooooo`11oooo00?o09Wooooo
ool07oooo`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`12oooo00?o09Woooooool07ooo
o`00Yoooo`80000@<ol000<0003oooooool0@_ooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o
03?o000?<ol000<0003oooooool0@_ooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000?
<ol000<0003oooooool0@_ooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000><ol000<0
003oooooool0@oooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000><ol000<0003ooooo
ool0@oooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000><ol000<0003oooooool0@ooo
o`03o`2Ioooooooo01ooool00:Ooool200003c?o00030000oooooooo04?oool00ol0VOooooooo`0O
oooo002Woooo00<0000co`0co`003C?o00030000oooooooo04Coool00ol0VOooooooo`0Ooooo002W
oooo00<0000co`0co`003C?o00030000oooooooo04Coool00ol0VOooooooo`0Ooooo002Woooo00<0
000co`0co`003C?o00030000oooooooo04Coool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0c
o`003C?o00030000oooooooo04Coool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`0033?o
00030000oooooooo04Goool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`0033?o00030000
oooooooo04Goool00ol0VOooooooo`0Ooooo002Woooo0P0000dco`000`000?ooooooo`15oooo00?o
09Woooooool07oooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`15oooo00?o09Wooooo
ool07oooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`16oooo00?o09Woooooool07ooo
o`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`16oooo00?o09Woooooool07oooo`00Yooo
o`030000<ol0<ol000/co`000`000?ooooooo`16oooo00?o09Woooooool07oooo`00Yoooo`030000
<ol0<ol000/co`000`000?ooooooo`16oooo00?o09Woooooool07oooo`00Yoooo`80000<<ol000<0
003oooooool0A_ooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000:<ol000<0003ooooo
ool0Aoooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000:<ol000<0003oooooool0Aooo
o`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o000:<ol000<0003oooooool0Aoooo`03o`2I
oooooooo01ooool009ooool400001?ooo`030000<ol0<ol000Xco`000`000?ooooooo`17oooo00?o
09Woooooool07oooo`00Woooo`030000oooooooo00Goool00`0003?o03?o000:<ol000<0003ooooo
ool0Aoooo`03o`2Ioooooooo01ooool00:3oool00`000?ooooooo`04oooo0`0000Xco`000`000?oo
ooooo`17oooo00?o09Woooooool07oooo`00XOooo`030000oooooooo00?oool00`0003?o03?o0009
<ol000<0003oooooool0B?ooo`03o`2Ioooooooo01ooool009ooool010000?ooooooo`0000Coool0
0`0003?o03?o0009<ol000<0003oooooool0B?ooo`03o`2Ioooooooo01ooool00:3oool200001Ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`18oooo00?o09Woooooool07oooo`00Yoooo`030000
<ol0<ol000Tco`000`000?ooooooo`18oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol0
00Tco`000`000?ooooooo`18oooo00?o09Woooooool07oooo`00Yoooo`80000:<ol000<0003ooooo
ool0B?ooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0BOoo
o`03o`2Ioooooooo01ooool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0BOooo`03o`2I
oooooooo01ooool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0BOooo`03o`2Ioooooooo
01ooool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0BOooo`03o`2Ioooooooo01ooool0
0:Ooool00`0003?o03?o0008<ol000<0003oooooool0BOooo`03o`2Ioooooooo01ooool00:Ooool0
0`0003?o03?o0008<ol000<0003oooooool0BOooo`03o`2Ioooooooo01ooool00:Ooool200002C?o
00030000oooooooo04Woool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`0023?o00030000
oooooooo04Woool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`001c?o00030000oooooooo
04[oool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`001c?o00030000oooooooo04[oool0
0ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`001c?o00030000oooooooo04[oool00ol0VOoo
ooooo`0Ooooo002Woooo00<0000co`0co`001c?o00030000oooooooo04[oool00ol0VOooooooo`0O
oooo002Woooo0P0000Pco`000`000?ooooooo`1:oooo00?o09Woooooool07oooo`00Yoooo`030000
<ol0<ol000Lco`000`000?ooooooo`1:oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol0
00Lco`000`000?ooooooo`1:oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol000Lco`00
0`000?ooooooo`1:oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol000Lco`000`000?oo
ooooo`1:oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1:
oooo00?o09Woooooool07oooo`00Yoooo`800007<ol000<0003oooooool0Boooo`03o`2Ioooooooo
01ooool00:Ooool00`0003?o03?o0006<ol000<0003oooooool0Boooo`03o`2Ioooooooo01ooool0
0:Ooool00`0003?o03?o0006<ol000<0003oooooool0Boooo`03o`2Ioooooooo01ooool00:Ooool0
0`0003?o03?o0006<ol000<0003oooooool0Boooo`03o`2Ioooooooo01ooool00:3oool200001Ooo
o`030000<ol0<ol000Hco`000`000?ooooooo`1;oooo00?o09Woooooool07oooo`00Woooo`040000
oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?ooooooo`1;oooo00?o09Woooooool07ooo
o`00XOooo`030000oooooooo00?oool300001S?o00030000oooooooo04_oool00ol0VOooooooo`0O
oooo002Roooo00<0003oooooool00_ooo`030000<ol0<ol000Hco`000`000?ooooooo`1;oooo00?o
09Woooooool07oooo`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1;oooo00?o09Woooooool07oooo`00X?ooo`800005oooo00<0000co`0co`001S?o00030000
oooooooo04_oool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`001C?o00030000oooooooo
04coool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`001C?o00030000oooooooo04coool0
0ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`001C?o00030000oooooooo04coool00ol0VOoo
ooooo`0Ooooo002Woooo0P0000Hco`000`000?ooooooo`1<oooo00?o09Woooooool07oooo`00Yooo
o`030000<ol0<ol000Dco`000`000?ooooooo`1<oooo00?o09Woooooool07oooo`00Yoooo`030000
<ol0<ol000Dco`000`000?ooooooo`1<oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol0
00Dco`000`000?ooooooo`1<oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol000Dco`00
0`000?ooooooo`1<oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol000Dco`000`000?oo
ooooo`1<oooo00?o09Woooooool07oooo`00Yoooo`800006<ol000<0003oooooool0C?ooo`03o`2I
oooooooo01ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0COooo`03o`2Ioooooooo
01ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0COooo`03o`2Ioooooooo01ooool0
0:Ooool00`0003?o03?o0004<ol000<0003oooooool0COooo`03o`2Ioooooooo01ooool00:Ooool0
0`0003?o03?o0004<ol000<0003oooooool0COooo`03o`2Ioooooooo01ooool00:Ooool00`0003?o
03?o0004<ol000<0003oooooool0COooo`03o`2Ioooooooo01ooool00:Ooool200001C?o00030000
oooooooo04goool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`0013?o00030000oooooooo
04goool00ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`0013?o00030000oooooooo04goool0
0ol0VOooooooo`0Ooooo002Woooo00<0000co`0co`0013?o00030000oooooooo04goool00ol0VOoo
ooooo`0Ooooo002Woooo00<0000co`0co`0013?o00030000oooooooo04goool00ol0VOooooooo`0O
oooo002Woooo00<0000co`0co`000c?o00030000oooooooo04koool00ol0VOooooooo`0Ooooo002W
oooo0P0000@co`000`000?ooooooo`1>oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol0
00<co`000`000?ooooooo`1>oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol000<co`00
0`000?ooooooo`1>oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol000<co`000`000?oo
ooooo`1>oooo00?o09Woooooool07oooo`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`1>
oooo00?o09Woooooool07oooo`00XOooo`<00003oooo00<0000co`0co`000c?o00030000oooooooo
04koool00ol0VOooooooo`0Ooooo002Roooo00<0003oooooool00_ooo`030000<ol0<ol000<co`00
0`000?ooooooo`1>oooo00?o09Woooooool07oooo`00Woooo`D00003oooo0`0000<co`000`000?oo
ooooo`1>oooo00?o09Woooooool07oooo`00Woooo`040000oooooooo00001?ooo`Hco`1coooo002P
oooo00<0003oool000001?ooo`Hco`1coooo002Qoooo0P0000Coool6<ol0Loooo`00Yoooo`Hco`1c
oooo002Woooo1S?o07?oool007coool00`000?ooooooo`0Roooo00<0003oooooool00oooo`Hco`1c
oooo001koooo00<0003oooooool02?ooo`030000oooooooo01Woool00`000?ooooooo`02oooo1S?o
07?oool007_oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`07oooo0P0000Coool2
00001?ooo`800004oooo00<0003oooooool00_ooo`Hco`1coooo001koooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`05oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool00_ooo`Hco`1coooo001joooo00<0003oooooool00_oo
o`030000oooooooo00goool010000?ooooooo`0000Soool010000?ooooooo`0000Coool010000?oo
ooooooooo`Hco`1coooo001koooo00<0003oooooool01@0000coool010000?ooooooo`0000Woool2
00001?ooo`030000oooooooo00;oool6<ol0Loooo`00Noooo`050000oooooooooooo000000ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`02oooo1S?o07?oool0
07coool00`000?ooooooo`0Aoooo0P0000[oool200000oooo`030000oooooooo00?oool6<ol0Looo
o`00Yoooo`Hco`1coooo002Woooo1S?o07?oool00001\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {650.563, 509.25}} -> {-0.349561, \
3.60372, 0.00349883, 0.00566123}, {{79.875, 308.563}, {650.563, 509.25}} -> \
{-5.53614, 19.2047, 0.0207442, 0.0319664}, {{79.875, 308.563}, {650.563, \
509.25}} -> {-5.53614, 19.2047, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20178 .12361 L
.20742 .12361 L
.21019 .12361 L
.2114 .12361 L
.21274 .12361 L
.21394 .12361 L
.21506 .1226 L
.21753 .11948 L
.22272 .11319 L
.24125 .09362 L
.26149 .07663 L
.28262 .06274 L
.30271 .05242 L
.32239 .04447 L
.34336 .03786 L
.36477 .03269 L
.38494 .02899 L
.40502 .02621 L
.42349 .02433 L
.43258 .02361 L
.44232 .02298 L
.453 .02244 L
.46298 .02208 L
.46826 .02194 L
.47315 .02184 L
.4757 .0218 L
.47852 .02176 L
.47993 .02175 L
.48146 .02174 L
.48216 .02174 L
.4829 .02173 L
.48422 .02173 L
.48548 .02172 L
.48663 .02172 L
.48795 .02172 L
.4892 .02173 L
.49035 .02173 L
.49142 .02174 L
.49383 .02175 L
.49626 .02178 L
.49893 .02181 L
.50434 .02192 L
.50955 .02205 L
.5145 .02221 L
.52379 .02259 L
Mistroke
.53378 .02314 L
.54468 .0239 L
.56439 .02575 L
.57533 .02707 L
.58538 .02849 L
.5904 .02928 L
.59292 .0297 L
.59361 .02982 L
.59435 .02995 L
.59505 .03007 L
.59569 .03076 L
.60683 .04519 L
.62701 .06452 L
.64613 .07764 L
.66691 .08822 L
.68672 .09585 L
.70774 .10206 L
.72725 .10654 L
.74555 .10987 L
.76406 .11257 L
.78429 .11491 L
.80437 .11674 L
.82548 .11825 L
.84513 .11936 L
.86609 .12028 L
.88748 .12102 L
.90764 .12157 L
.92636 .12197 L
.94616 .12231 L
.97619 .12269 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool007[ooolS
06Ko2_ooo`80001goooo001`oooo2P1Vob?oool:06Ko00<0003oooooool0M_ooo`00K?ooo`@0I_lg
oooo00<0003oooooool0M_ooo`00JOooo`<0I_lkoooo00<00000I_ooool0M_ooo`00IOooo`@0I_ln
oooo00<00000I_ooool0M_ooo`00HOooo`@0I_m2oooo00<0003oool0I_l0M_ooo`00Goooo`80I_m6
oooo00@0003oooooool0I_meoooo001Moooo0P1VodSoool200000_ooo`0306Kooooooooo07;oool0
05_oool206KoB_ooo`030000oooooooo00;oool206KoL_ooo`00FOooo`80I_m<oooo00<0003ooooo
ool01?ooo`0306Kooooooooo06ooool005Soool00`1Vooooooooo`1<oooo00<0003oooooool01Ooo
o`0306Kooooooooo06koool005Koool206KoCoooo`030000oooooooo00Koool00`1Vooooooooo`1]
oooo001Doooo0P1Voe7oool00`000?ooooooo`07oooo0P1Vofgoool005;oool206KoDoooo`80000:
oooo00<0I_ooooooool0J_ooo`006?ooo`80000^oooo100000Goool00`1Vooooooooo`0Toooo1@00
02[oool00`000?ooooooo`0:oooo0P1Voaooool50000;?ooo`@0000Foooo000Goooo00@0003ooooo
ool0000]oooo00<0003oooooool01Oooo`0306Kooooooooo02Ooool00`000?ooooooo`0Zoooo00<0
003oooooool03?ooo`80I_lOoooo00<0003oooooool0;?ooo`030000oooooooo01Ooool001Woool0
0`000?ooooooo`0]oooo00<0003oooooool00oooo`0306Kooooooooo02Soool00`000?ooooooo`0Z
oooo00<0003oooooool03_ooo`<0I_lLoooo00<0003oooooool0;Oooo`030000oooooooo01Koool0
017oool400001Oooo`030000oooooooo02Goool400001?ooo`050000oooooooooooo06Ko02?oool4
00001?ooo`030000oooooooo02[oool00`000?ooooooo`0Aoooo0P1Voa[oool00`000?ooooooo`0^
oooo00<0003oooooool05Oooo`005oooo`040000oooooooo0000;Oooo`060000oooooooo0000oooo
06Ko;?ooo`030000oooooooo02[oool00`000?ooooooo`0Coooo0`1VoaOoool00`000?ooooooo`0/
oooo00@0003oooooool0000Foooo000Hoooo0P0002ooool2000000?oool0I_ooool0:oooo`80000/
oooo0P0001Ooool306Ko4oooo`80000_oooo0P0001Ooool004_oool00`1Vooooooooo`1Ioooo00<0
003oooooool06Oooo`@0I_mIoooo001;oooo00<0I_ooooooool0FOooo`030000oooooooo01goool4
06KoEOooo`00B_ooo`0306Kooooooooo05[oool00`000?ooooooo`0Qoooo1@1Voe3oool004Woool0
0`1Vooooooooo`1Koooo00<0003oooooool09_ooo`X0I_m6oooo0017oooo0P1Voekoool00`000?oo
ooooo`0`oooo3`1VocOoool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_oo
o`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000<ol0<ol000Lco`000`0003?o
03?o0006<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0
000co`0co`001C?o01X00005oooo00<0003oooooool01oooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0^oooo00<0003oooooool0;Oooo`030000oooooooo02goool00`0003?o03?o000]
<ol0200002Woool00`000?ooooooo`0Eoooo002Woooo00<0000co`0co`00:S?o00<00019oooo002W
oooo00<0000co`0co`009S?o00@0001<oooo002Woooo00<0000co`0co`0093?o0080001@oooo002W
oooo00<0000co`0co`008c?o00030000oooooooo053oool00:Ooool200008S?o0080001Coooo002W
oooo00<0000co`0co`007c?o0080001Eoooo002Woooo00<0000co`0co`007S?o00030000oooooooo
05Goool00:Ooool00`0003?o03?o000M<ol000<0003oooooool0E_ooo`00Yoooo`030000<ol0<ol0
01`co`000`000?ooooooo`1Goooo002Woooo00<0000co`0co`006c?o00030000oooooooo05Soool0
0:Ooool2000073?o00030000oooooooo05Soool00:Ooool00`0003?o03?o000J<ol000<0003ooooo
ool0FOooo`00Yoooo`030000<ol0<ol001Tco`000`000?ooooooo`1Joooo002Woooo00<0000co`0c
o`0063?o00030000oooooooo05_oool00:Ooool00`0003?o03?o000G<ol000<0003oooooool0G?oo
o`00Yoooo`030000<ol0<ol001Hco`000`000?ooooooo`1Moooo002Woooo0P0001Lco`000`000?oo
ooooo`1Moooo002Woooo00<0000co`0co`005C?o00030000oooooooo05koool00:Ooool00`0003?o
03?o000E<ol000<0003oooooool0G_ooo`00Yoooo`030000<ol0<ol001Dco`000`000?ooooooo`1N
oooo002Woooo00<0000co`0co`0053?o00030000oooooooo05ooool00:Ooool00`0003?o03?o000D
<ol000<0003oooooool0Goooo`00Yoooo`80000D<ol000<0003oooooool0H?ooo`00Yoooo`030000
<ol0<ol001<co`000`000?ooooooo`1Poooo002Woooo00<0000co`0co`004c?o00030000oooooooo
063oool00:Ooool00`0003?o03?o000B<ol000<0003oooooool0HOooo`00Yoooo`030000<ol0<ol0
018co`000`000?ooooooo`1Qoooo002Ooooo1@0000?oool00`0003?o03?o000A<ol000<0003ooooo
ool0H_ooo`00XOooo`030000oooooooo00?oool00`0003?o03?o000A<ol000<0003oooooool0H_oo
o`00XOooo`030000oooooooo00?oool300004C?o00030000oooooooo06;oool00:7oool00`000?oo
ooooo`03oooo00<0000co`0co`0043?o00030000oooooooo06?oool00:7oool00`000?ooooooo`03
oooo00<0000co`0co`0043?o00030000oooooooo06?oool00:3oool200001Oooo`030000<ol0<ol0
010co`000`000?ooooooo`1Soooo002Woooo00<0000co`0co`0043?o00030000oooooooo06?oool0
0:Ooool00`0003?o03?o000?<ol000<0003oooooool0I?ooo`00Yoooo`80000@<ol000<0003ooooo
ool0I?ooo`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`1Toooo002Woooo00<0000co`0c
o`003c?o00030000oooooooo06Coool00:Ooool00`0003?o03?o000><ol000<0003oooooool0IOoo
o`00Yoooo`030000<ol0<ol000hco`000`000?ooooooo`1Uoooo002Woooo00<0000co`0co`003S?o
00030000oooooooo06Goool00:Ooool200003c?o00030000oooooooo06Goool00:Ooool00`0003?o
03?o000=<ol000<0003oooooool0I_ooo`00Yoooo`030000<ol0<ol000dco`000`000?ooooooo`1V
oooo002Woooo00<0000co`0co`003C?o00030000oooooooo06Koool00:Ooool00`0003?o03?o000=
<ol000<0003oooooool0I_ooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`1Woooo002W
oooo00<0000co`0co`0033?o00030000oooooooo06Ooool00:Ooool200003C?o00030000oooooooo
06Ooool00:Ooool00`0003?o03?o000<<ol000<0003oooooool0Ioooo`00Yoooo`030000<ol0<ol0
00/co`000`000?ooooooo`1Xoooo002Woooo00<0000co`0co`002c?o00030000oooooooo06Soool0
0:Ooool00`0003?o03?o000;<ol000<0003oooooool0J?ooo`00Yoooo`030000<ol0<ol000/co`00
0`000?ooooooo`1Xoooo002Woooo0P0000`co`000`000?ooooooo`1Xoooo002Woooo00<0000co`0c
o`002S?o00030000oooooooo06Woool00:Ooool00`0003?o03?o000:<ol000<0003oooooool0JOoo
o`00Yoooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Ooooo100000Coool00`0003?o
03?o000:<ol000<0003oooooool0JOooo`00Woooo`030000oooooooo00Goool00`0003?o03?o000:
<ol000<0003oooooool0JOooo`00X?ooo`030000oooooooo00Coool300002S?o00030000oooooooo
06Woool00:7oool00`000?ooooooo`03oooo00<0000co`0co`002C?o00030000oooooooo06[oool0
09ooool010000?ooooooo`0000Coool00`0003?o03?o0009<ol000<0003oooooool0J_ooo`00X?oo
o`800005oooo00<0000co`0co`002C?o00030000oooooooo06[oool00:Ooool00`0003?o03?o0009
<ol000<0003oooooool0J_ooo`00Yoooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo002W
oooo0P0000Xco`000`000?ooooooo`1Zoooo002Woooo00<0000co`0co`0023?o00030000oooooooo
06_oool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000<ol0<ol0
00Pco`000`000?ooooooo`1[oooo002Woooo00<0000co`0co`0023?o00030000oooooooo06_oool0
0:Ooool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000<ol0<ol000Pco`00
0`000?ooooooo`1[oooo002Woooo0P0000Tco`000`000?ooooooo`1[oooo002Woooo00<0000co`0c
o`0023?o00030000oooooooo06_oool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?oo
o`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo00<0000co`0co`001c?o
00030000oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yooo
o`800008<ol000<0003oooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/
oooo002Woooo00<0000co`0co`001c?o00030000oooooooo06coool00:Ooool00`0003?o03?o0007
<ol000<0003oooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002W
oooo00<0000co`0co`001c?o00030000oooooooo06coool00:Ooool200001c?o00030000oooooooo
06goool00:Ooool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00Yoooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1]oooo002Woooo00<0000co`0co`001S?o00030000oooooooo06goool0
0:3oool200001Oooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002Ooooo00@0003ooooo
ool00004oooo00<0000co`0co`001S?o00030000oooooooo06goool00:7oool00`000?ooooooo`03
oooo0`0000Hco`000`000?ooooooo`1]oooo002Roooo00<0003oooooool00_ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1]oooo002Ooooo00@0003oooooool00004oooo00<0000co`0co`001S?o
00030000oooooooo06goool00:3oool200001Oooo`030000<ol0<ol000Hco`000`000?ooooooo`1]
oooo002Woooo00<0000co`0co`001C?o00030000oooooooo06koool00:Ooool00`0003?o03?o0005
<ol000<0003oooooool0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002W
oooo0P0000Hco`000`000?ooooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo
06koool00:Ooool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`030000<ol0<ol0
00Dco`000`000?ooooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo06koool0
0:Ooool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`800006<ol000<0003ooooo
ool0K_ooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0c
o`0013?o00030000oooooooo06ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0Kooo
o`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o
00030000oooooooo06ooool00:Ooool200001C?o00030000oooooooo06ooool00:Ooool00`0003?o
03?o0004<ol000<0003oooooool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_
oooo002Woooo00<0000co`0co`0013?o00030000oooooooo06ooool00:Ooool00`0003?o03?o0004
<ol000<0003oooooool0Koooo`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002W
oooo0P0000@co`000`000?ooooooo`1`oooo002Woooo00<0000co`0co`000c?o00030000oooooooo
073oool00:Ooool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00Yoooo`030000<ol0<ol0
00<co`000`000?ooooooo`1`oooo002Woooo00<0000co`0co`000c?o00030000oooooooo073oool0
0:7oool300000oooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002Roooo00<0003ooooo
ool00_ooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002Ooooo1@0000?oool300000c?o
00030000oooooooo073oool009ooool010000?ooooooo`0000Coool6<ol0Loooo`00X?ooo`030000
oooo000000Coool6<ol0Loooo`00XOooo`800004oooo1S?o07?oool00:Ooool6<ol0Loooo`00Yooo
o`Hco`1coooo001ooooo00<0003oooooool07?ooo`030000oooooooo00Koool6<ol0Loooo`00O_oo
o`030000oooooooo00Soool00`000?ooooooo`0Coooo00<0003oooooool01Oooo`Hco`1coooo001n
oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool01_ooo`D00002oooo0P0000Coool0
0`000?ooooooo`05oooo1S?o07?oool007koool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01Oooo`Hco`1c
oooo001moooo00<0003oooooool00_ooo`030000oooooooo00ooool00`000?ooooooo`09oooo00<0
003oooooool01?ooo`Hco`1coooo001noooo00<0003oooooool01@0000koool00`000?ooooooo`08
oooo00<0003oooooool01Oooo`Hco`1coooo001noooo00D0003oooooooooool000004Oooo`030000
oooooooo00Soool00`000?ooooooo`05oooo1S?o07?oool007ooool00`000?ooooooo`0Aoooo0P00
00Woool00`000?ooooooo`06oooo1S?o07?oool00:Ooool6<ol0Loooo`00Yoooo`Hco`1coooo0000
\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {204.5, 63.1875}} -> {-0.349561, \
0.447144, 0.00349883, 0.00566123}, {{79.875, 308.563}, {204.5, 63.1875}} -> \
{-5.53614, 1.38097, 0.0207442, 0.0319664}, {{79.875, 308.563}, {204.5, \
63.1875}} -> {-5.53614, 1.38097, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.12507 .12361 L
.14415 .12361 L
.16254 .12361 L
.16783 .12361 L
.17044 .12361 L
.17284 .12361 L
.17502 .12361 L
.17612 .12361 L
.17733 .12214 L
.18221 .11607 L
.20325 .09354 L
.2225 .0773 L
.2426 .06387 L
.26127 .05397 L
.28025 .04595 L
.30098 .03907 L
.3215 .03381 L
.34011 .03011 L
.35935 .02716 L
.36928 .02594 L
.38017 .0248 L
.40011 .02323 L
.411 .02262 L
.42118 .0222 L
.42618 .02204 L
.43163 .0219 L
.43412 .02185 L
.43677 .02181 L
.43906 .02178 L
.44153 .02175 L
.44268 .02174 L
.4439 .02174 L
.44494 .02173 L
.44608 .02173 L
.44715 .02172 L
.44829 .02172 L
.44937 .02172 L
.45035 .02172 L
.4516 .02173 L
.45275 .02173 L
.45402 .02174 L
.45536 .02175 L
.45761 .02177 L
.46008 .0218 L
.4653 .0219 L
.47025 .02201 L
.47953 .02232 L
Mistroke
.48953 .02278 L
.50042 .02344 L
.52014 .0251 L
.54112 .02759 L
.58276 .03409 L
.59293 .03655 L
.59359 .03671 L
.59431 .03689 L
.59561 .0382 L
.59639 .03838 L
.59712 .03853 L
.59848 .0388 L
.60095 .0392 L
.60366 .03953 L
.60477 .03964 L
.60596 .03974 L
.60699 .03981 L
.60811 .03988 L
.60931 .03993 L
.61057 .03996 L
.61174 .03998 L
.61283 .03998 L
.61414 .03997 L
.61538 .03994 L
.61649 .03991 L
.61769 .03985 L
.62039 .03969 L
.62287 .03948 L
.6275 .03896 L
.62971 .03866 L
.63182 .03834 L
.633 .03815 L
.63429 .03918 L
.63655 .04165 L
.64164 .0469 L
.66148 .06399 L
.68123 .07687 L
.70223 .08736 L
.72167 .09489 L
.73995 .10049 L
.7584 .10503 L
.7786 .10897 L
.79862 .11204 L
.81971 .11458 L
.8393 .11644 L
.86024 .118 L
.88156 .11924 L
.9017 .12016 L
.92036 .12084 L
.94014 .12141 L
Mistroke
.97619 .12217 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool0073ooolW
06Ko4?ooo`80001goooo001Yoooo1`1VobOoool506Ko2oooo`030000oooooooo07Koool006Goool4
06Ko<oooo`H0I_l5oooo00<0003oooooool0M_ooo`00H?ooo`D0I_lmoooo1@1Vo`030000oooooooo
07Koool005coool406KoAoooo`03000006Ko06Ko00P0I_m^oooo001Ioooo0`1Vod_oool00`000?oo
ooooo`08oooo00<0I_ooooooool0Joooo`00E_ooo`<0I_m>oooo00<0003oooooool02Oooo`0306Ko
oooooooo06[oool005Coool206KoDOooo`80000;oooo00<0I_ooooooool0JOooo`00D_ooo`80I_mC
oooo00<0003oooooool02oooo`80I_mYoooo001@oooo0P1VoeGoool00`000?ooooooo`0=oooo00<0
I_ooooooool0I_ooo`00C_ooo`80I_mGoooo00<0003oooooool03_ooo`0306Kooooooooo06Goool0
04goool00`1Vooooooooo`1Goooo00<0003oooooool03oooo`0306Kooooooooo06Coool004_oool2
06KoF_ooo`030000oooooooo013oool206KoI?ooo`00B_ooo`0306Kooooooooo05[oool200004ooo
o`0306Kooooooooo067oool001Soool20000;_ooo`@0000/oooo1@0002[oool00`000?ooooooo`0C
oooo0P1VoaKoool50000;?ooo`@0000Foooo000Goooo00@0003oooooool0000]oooo00<0003ooooo
ool0;oooo`030000oooooooo02[oool00`000?ooooooo`0Eoooo0P1VoaKoool00`000?ooooooo`0/
oooo00<0003oooooool05oooo`006Oooo`030000oooooooo02[oool206Ko00?oool0003oool0;ooo
o`030000oooooooo02[oool00`000?ooooooo`0Goooo0`1Voa?oool00`000?ooooooo`0]oooo00<0
003oooooool05_ooo`004Oooo`@00005oooo00<0003oooooool09Oooo`@00004oooo00<0003ooooo
ool09Oooo`@00004oooo00<0003oooooool0:_ooo`030000oooooooo01[oool206Ko4Oooo`030000
oooooooo02koool00`000?ooooooo`0Eoooo000Goooo00@0003oooooool0000Yoooo00D0I_oooooo
ooooool000000_ooo`030000oooooooo02coool00`000?ooooooo`0Zoooo00<0003oooooool07?oo
o`<0I_l>oooo00<0003oooooool0;?ooo`040000oooooooo00005_ooo`006?ooo`80000Yoooo00<0
I_ooooooool00oooo`80000^oooo0P0002coool200008?ooo`80I_l;oooo0P0002ooool200005ooo
o`00@_ooo`0306Kooooooooo06;oool00`000?ooooooo`0Qoooo0`1Voe;oool0043oool206KoIOoo
o`030000oooooooo02Coool506KoCOooo`00?oooo`0306Kooooooooo06Goool00`000?ooooooo`0Y
oooo2`1Vod;oool003koool00`1Vooooooooo`1Voooo00<0003oooooool0=?ooo`D0I_lmoooo000m
oooo00<0I_ooooooool0Ioooo`030000oooooooo03Woool@06Ko;Oooo`004?ooool0000Aoooo000F
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0000co`0co`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0c
o`001c?o00030000<ol0<ol000Hco`000`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07
oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02koool00`000?ooooooo`0]oooo00<0
003oooooool0;Oooo`030000<ol0<ol002dco`080000:Oooo`030000oooooooo01Goool00:Ooool0
0`0003?o03?o000Z<ol00`0004Woool00:Ooool00`0003?o03?o000V<ol0100004coool00:Ooool0
0`0003?o03?o000T<ol00P00053oool00:Ooool00`0003?o03?o000S<ol000<0003oooooool0D?oo
o`00Yoooo`80000R<ol00P0005?oool00:Ooool00`0003?o03?o000O<ol00P0005Goool00:Ooool0
0`0003?o03?o000N<ol000<0003oooooool0EOooo`00Yoooo`030000<ol0<ol001dco`000`000?oo
ooooo`1Foooo002Woooo00<0000co`0co`0073?o00030000oooooooo05Ooool00:Ooool00`0003?o
03?o000K<ol000<0003oooooool0F?ooo`00Yoooo`80000L<ol000<0003oooooool0F?ooo`00Yooo
o`030000<ol0<ol001Xco`000`000?ooooooo`1Ioooo002Woooo00<0000co`0co`006C?o00030000
oooooooo05[oool00:Ooool00`0003?o03?o000H<ol000<0003oooooool0Foooo`00Yoooo`030000
<ol0<ol001Lco`000`000?ooooooo`1Loooo002Woooo00<0000co`0co`005S?o00030000oooooooo
05goool00:Ooool200005c?o00030000oooooooo05goool00:Ooool00`0003?o03?o000E<ol000<0
003oooooool0G_ooo`00Yoooo`030000<ol0<ol001Dco`000`000?ooooooo`1Noooo002Woooo00<0
000co`0co`005C?o00030000oooooooo05koool00:Ooool00`0003?o03?o000D<ol000<0003ooooo
ool0Goooo`00Yoooo`030000<ol0<ol001@co`000`000?ooooooo`1Ooooo002Woooo0P0001@co`00
0`000?ooooooo`1Poooo002Woooo00<0000co`0co`004c?o00030000oooooooo063oool00:Ooool0
0`0003?o03?o000C<ol000<0003oooooool0H?ooo`00Yoooo`030000<ol0<ol0018co`000`000?oo
ooooo`1Qoooo002Woooo00<0000co`0co`004S?o00030000oooooooo067oool009ooool500000ooo
o`030000<ol0<ol0014co`000`000?ooooooo`1Roooo002Qoooo00<0003oooooool00oooo`030000
<ol0<ol0014co`000`000?ooooooo`1Roooo002Qoooo00<0003oooooool00oooo`<0000A<ol000<0
003oooooool0H_ooo`00XOooo`030000oooooooo00?oool00`0003?o03?o000@<ol000<0003ooooo
ool0Hoooo`00XOooo`030000oooooooo00?oool00`0003?o03?o000@<ol000<0003oooooool0Hooo
o`00X?ooo`800005oooo00<0000co`0co`0043?o00030000oooooooo06?oool00:Ooool00`0003?o
03?o000@<ol000<0003oooooool0Hoooo`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`1T
oooo002Woooo0P00010co`000`000?ooooooo`1Toooo002Woooo00<0000co`0co`003c?o00030000
oooooooo06Coool00:Ooool00`0003?o03?o000?<ol000<0003oooooool0I?ooo`00Yoooo`030000
<ol0<ol000hco`000`000?ooooooo`1Uoooo002Woooo00<0000co`0co`003S?o00030000oooooooo
06Goool00:Ooool00`0003?o03?o000><ol000<0003oooooool0IOooo`00Yoooo`80000?<ol000<0
003oooooool0IOooo`00Yoooo`030000<ol0<ol000dco`000`000?ooooooo`1Voooo002Woooo00<0
000co`0co`003C?o00030000oooooooo06Koool00:Ooool00`0003?o03?o000=<ol000<0003ooooo
ool0I_ooo`00Yoooo`030000<ol0<ol000dco`000`000?ooooooo`1Voooo002Woooo00<0000co`0c
o`0033?o00030000oooooooo06Ooool00:Ooool00`0003?o03?o000<<ol000<0003oooooool0Iooo
o`00Yoooo`80000=<ol000<0003oooooool0Ioooo`00Yoooo`030000<ol0<ol000`co`000`000?oo
ooooo`1Woooo002Woooo00<0000co`0co`002c?o00030000oooooooo06Soool00:Ooool00`0003?o
03?o000;<ol000<0003oooooool0J?ooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`1X
oooo002Woooo00<0000co`0co`002c?o00030000oooooooo06Soool00:Ooool2000033?o00030000
oooooooo06Soool00:Ooool00`0003?o03?o000:<ol000<0003oooooool0JOooo`00Yoooo`030000
<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Woooo00<0000co`0co`002S?o00030000oooooooo
06Woool009ooool400001?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Ooooo00<0
003oooooool01Oooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Poooo00<0003ooooo
ool01?ooo`<0000:<ol000<0003oooooool0JOooo`00XOooo`030000oooooooo00?oool00`0003?o
03?o0009<ol000<0003oooooool0J_ooo`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol0
00Tco`000`000?ooooooo`1Zoooo002Poooo0P0000Goool00`0003?o03?o0009<ol000<0003ooooo
ool0J_ooo`00Yoooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo002Woooo00<0000co`0c
o`002C?o00030000oooooooo06[oool00:Ooool200002S?o00030000oooooooo06[oool00:Ooool0
0`0003?o03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000<ol0<ol000Pco`000`000?oo
ooooo`1[oooo002Woooo00<0000co`0co`0023?o00030000oooooooo06_oool00:Ooool00`0003?o
03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`1[
oooo002Woooo00<0000co`0co`0023?o00030000oooooooo06_oool00:Ooool200002C?o00030000
oooooooo06_oool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000
<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo00<0000co`0co`001c?o00030000oooooooo
06coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yoooo`030000<ol0<ol0
00Lco`000`000?ooooooo`1/oooo002Woooo0P0000Pco`000`000?ooooooo`1/oooo002Woooo00<0
000co`0co`001c?o00030000oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0003ooooo
ool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo00<0000co`0c
o`001c?o00030000oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?oo
o`00Yoooo`800007<ol000<0003oooooool0KOooo`00Yoooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1]oooo002Woooo00<0000co`0co`001S?o00030000oooooooo06goool00:Ooool00`0003?o
03?o0006<ol000<0003oooooool0KOooo`00X?ooo`800005oooo00<0000co`0co`001S?o00030000
oooooooo06goool009ooool010000?ooooooo`0000Coool00`0003?o03?o0006<ol000<0003ooooo
ool0KOooo`00XOooo`030000oooooooo00?oool300001S?o00030000oooooooo06goool00:;oool0
0`000?ooooooo`02oooo00<0000co`0co`001S?o00030000oooooooo06goool009ooool010000?oo
ooooo`0000Coool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00X?ooo`800005oooo00<0
000co`0co`001S?o00030000oooooooo06goool00:Ooool00`0003?o03?o0005<ol000<0003ooooo
ool0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002Woooo00<0000co`0c
o`001C?o00030000oooooooo06koool00:Ooool200001S?o00030000oooooooo06koool00:Ooool0
0`0003?o03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?oo
ooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo06koool00:Ooool00`0003?o
03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`1^
oooo002Woooo0P0000Hco`000`000?ooooooo`1^oooo002Woooo00<0000co`0co`0013?o00030000
oooooooo06ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yoooo`030000
<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o00030000oooooooo
06ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yoooo`800005<ol000<0
003oooooool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0
000co`0co`0013?o00030000oooooooo06ooool00:Ooool00`0003?o03?o0004<ol000<0003ooooo
ool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0c
o`000c?o00030000oooooooo073oool00:Ooool2000013?o00030000oooooooo073oool00:Ooool0
0`0003?o03?o0003<ol000<0003oooooool0L?ooo`00Yoooo`030000<ol0<ol000<co`000`000?oo
ooooo`1`oooo002Woooo00<0000co`0co`000c?o00030000oooooooo073oool00:Ooool00`0003?o
03?o0003<ol000<0003oooooool0L?ooo`00XOooo`<00003oooo00<0000co`0co`000c?o00030000
oooooooo073oool00:;oool00`000?ooooooo`02oooo00<0000co`0co`000c?o00030000oooooooo
073oool009ooool500000oooo`<00003<ol000<0003oooooool0L?ooo`00Woooo`040000oooooooo
00001?ooo`Hco`1coooo002Poooo00<0003oool000001?ooo`Hco`1coooo002Qoooo0P0000Coool6
<ol0Loooo`00Yoooo`Hco`1coooo002Woooo1S?o07?oool007coool00`000?ooooooo`0Roooo00<0
003oooooool00oooo`Hco`1coooo001koooo00<0003oooooool02?ooo`030000oooooooo01Woool0
0`000?ooooooo`02oooo1S?o07?oool007_oool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`06oooo1@0000;oool200000oooo`@00003oooo00<0003oooooool00_ooo`Hco`1coooo001k
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Coool00`000?ooooooo`02oooo1S?o07?oool007[oool0
0`000?ooooooo`02oooo00<0003oooooool03oooo`030000oooooooo00Soool00`000?ooooooo`04
oooo00@0003oooooooooool6<ol0Loooo`00Noooo`030000oooooooo00D0000>oooo00<0003ooooo
ool02Oooo`030000oooooooo00;oool00`000?ooooooo`02oooo1S?o07?oool007_oool01@000?oo
ooooooooo`00000Aoooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo
00;oool6<ol0Loooo`00O?ooo`030000oooooooo017oool200002_ooo`800003oooo00<0003ooooo
ool00oooo`Hco`1coooo002Woooo1S?o07?oool00:Ooool6<ol0Loooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {353.188, 211.875}} -> {-0.349561, \
1.49934, 0.00349883, 0.00566123}, {{79.875, 308.563}, {353.188, 211.875}} -> \
{-5.53614, 7.32223, 0.0207442, 0.0319664}, {{79.875, 308.563}, {353.188, \
211.875}} -> {-5.53614, 7.32223, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.08255 .12361 L
.10458 .12361 L
.11448 .12361 L
.12507 .12361 L
.1302 .12361 L
.13273 .12361 L
.13506 .12361 L
.13615 .12361 L
.13718 .12361 L
.13824 .12341 L
.13942 .1219 L
.14415 .11602 L
.16269 .0959 L
.18292 .07842 L
.20406 .06413 L
.22415 .05351 L
.24382 .04533 L
.26479 .03852 L
.2862 .03319 L
.30638 .02937 L
.32645 .0265 L
.34493 .02454 L
.36375 .02312 L
.37444 .02255 L
.38441 .02215 L
.38942 .022 L
.39487 .02188 L
.39736 .02183 L
.40001 .02179 L
.40227 .02176 L
.40349 .02175 L
.40477 .02174 L
.40591 .02174 L
.40717 .02173 L
.40831 .02173 L
.40937 .02172 L
.41063 .02172 L
.41177 .02172 L
.41309 .02173 L
.41434 .02173 L
.41543 .02174 L
.41658 .02174 L
.41865 .02176 L
.42087 .02179 L
.42332 .02182 L
.42854 .02192 L
.43348 .02205 L
.44277 .02238 L
Mistroke
.45277 .02286 L
.46366 .02354 L
.48337 .02523 L
.50436 .02778 L
.5141 .02927 L
.51647 .02966 L
.51777 .02988 L
.519 .03009 L
.5197 .02866 L
.52046 .02881 L
.52178 .02907 L
.52437 .0296 L
.53564 .03201 L
.54599 .0344 L
.58611 .04458 L
.59104 .04587 L
.59239 .04623 L
.5938 .04661 L
.59502 .04693 L
.5957 .04774 L
.59634 .0479 L
.60098 .04884 L
.60357 .04924 L
.60593 .04952 L
.6084 .04975 L
.60979 .04985 L
.61107 .04993 L
.6122 .04998 L
.61343 .05002 L
.61472 .05004 L
.61592 .05006 L
.61661 .05006 L
.61735 .05005 L
.61805 .05004 L
.61871 .05003 L
.61993 .05 L
.62124 .04996 L
.62264 .04989 L
.62395 .04982 L
.62695 .04961 L
.63163 .04915 L
.63676 .0485 L
.64711 .04677 L
.65662 .04475 L
.6656 .04254 L
.66799 .0419 L
.6693 .04155 L
.67052 .04121 L
.67184 .04138 L
.67255 .04209 L
Mistroke
.6733 .04284 L
.67586 .04534 L
.68519 .05377 L
.70613 .06937 L
.72728 .08147 L
.74738 .09041 L
.78559 .10246 L
.80528 .10684 L
.82625 .1105 L
.84768 .11342 L
.86786 .11557 L
.90643 .1185 L
.92638 .11956 L
.94745 .12045 L
.97619 .12135 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool006KooolX
06Ko6Oooo`80001goooo001Qoooo1@1VobSoool706Ko4_ooo`030000oooooooo07Koool005Soool9
06Ko<_ooo`L0I_l=oooo00<0003oooooool0M_ooo`00EOooo`<0I_m2oooo101Vo`Woool00`000?oo
ooooo`1foooo001Boooo0`1VodWoool506Ko1?ooo`030000oooooooo07Koool0053oool206KoDOoo
o`<0I_l00oooo`000?ooo`0=oooo1P1VofCoool004goool306KoE_ooo`0406Ko000006Ko06Ko2?oo
o`@0I_l6oooo00<0I_ooooooool0HOooo`00Boooo`80I_mJoooo0P0000T0I_l;oooo00<0I_oooooo
ool0H?ooo`00B?ooo`<0I_mLoooo00<0003oooooool05?ooo`0306Kooooooooo05ooool004Koool2
06KoGoooo`030000oooooooo01Goool00`1Vooooooooo`1Noooo0014oooo0P1Vof7oool00`000?oo
ooooo`0Foooo0P1Voekoool004?oool00`1Vooooooooo`1Qoooo00<0003oooooool06?ooo`0306Ko
oooooooo05_oool0047oool206KoI?ooo`030000oooooooo01Woool00`1Vooooooooo`1Joooo0010
oooo00<0I_ooooooool0I?ooo`80000Koooo0P1Voe[oool001Soool200009Oooo`0306Kooooooooo
00Koool40000;?ooo`D0000Zoooo00<0003oooooool07?ooo`80I_l=oooo1@0002coool400005_oo
o`005oooo`040000oooooooo00008_ooo`80I_l9oooo00<0003oooooool0;oooo`030000oooooooo
02[oool00`000?ooooooo`0Noooo0`1Vo`coool00`000?ooooooo`0/oooo00<0003oooooool05ooo
o`006Oooo`030000oooooooo023oool00`1Vooooooooo`0:oooo00<0003oooooool0;_ooo`030000
oooooooo02[oool00`000?ooooooo`0Qoooo0P1Vo`[oool00`000?ooooooo`0]oooo00<0003ooooo
ool05_ooo`004Oooo`@00005oooo00<0003oooooool07Oooo`80I_l6oooo100000Coool00`000?oo
ooooo`0Uoooo100000Coool00`000?ooooooo`0Zoooo00<0003oooooool08oooo`<0I_l7oooo00<0
003oooooool0;_ooo`030000oooooooo01Goool001Ooool010000?ooooooo`0001koool00`1Voooo
ooooo`0<oooo00@0003oooooool0000^oooo00<0003oooooool0:_ooo`030000oooooooo02Koool3
06Ko1?ooo`030000oooooooo02coool010000?ooooooo`0001Koool001Soool200007_ooo`0306Ko
oooooooo00koool20000;_ooo`80000/oooo0P0002[oool306Ko0P0002ooool200005oooo`00=ooo
o`0306Kooooooooo06goool00`000?ooooooo`0/oooo101VodKoool003Ooool00`1Vooooooooo`1]
oooo00<0003oooooool0<?ooo`D0I_m1oooo000foooo00<0I_ooooooool0K_ooo`030000oooooooo
03Goool606Ko>oooo`00=Oooo`0306Kooooooooo06ooool00`000?ooooooo`0koooo301Vobooool0
03Coool00`1Vooooooooo`1`oooo00<0003oooooool0Aoooo`d0I_lRoooo000@ooooo`00017oool0
01Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?oo
ooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01_oo
o`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo
00Ooool00`0003?o03?o0007<ol000<0000co`0co`001S?o00030000<ol0<ol000Lco`000`0003?o
03?o0007<ol000<0000co`0co`001S?o00030000<ol0<ol000Dco`0J00001Oooo`030000oooooooo
00Ooool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0;_ooo`030000oooooooo02goool0
0`000?ooooooo`0]oooo00<0000co`0co`00;C?o00P0000Yoooo00<0003oooooool05Oooo`00Yooo
o`030000<ol0<ol002Xco`030000BOooo`00Yoooo`030000<ol0<ol002Hco`040000C?ooo`00Yooo
o`030000<ol0<ol002@co`020000D?ooo`00Yoooo`030000<ol0<ol002<co`000`000?ooooooo`1@
oooo002Woooo0P00028co`020000Doooo`00Yoooo`030000<ol0<ol001lco`020000EOooo`00Yooo
o`030000<ol0<ol001hco`000`000?ooooooo`1Eoooo002Woooo00<0000co`0co`007C?o00030000
oooooooo05Koool00:Ooool00`0003?o03?o000L<ol000<0003oooooool0Eoooo`00Yoooo`030000
<ol0<ol001/co`000`000?ooooooo`1Hoooo002Woooo0P0001`co`000`000?ooooooo`1Hoooo002W
oooo00<0000co`0co`006S?o00030000oooooooo05Woool00:Ooool00`0003?o03?o000I<ol000<0
003oooooool0F_ooo`00Yoooo`030000<ol0<ol001Pco`000`000?ooooooo`1Koooo002Woooo00<0
000co`0co`005c?o00030000oooooooo05coool00:Ooool00`0003?o03?o000F<ol000<0003ooooo
ool0GOooo`00Yoooo`80000G<ol000<0003oooooool0GOooo`00Yoooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1Noooo002Woooo00<0000co`0co`005C?o00030000oooooooo05koool00:Ooool0
0`0003?o03?o000E<ol000<0003oooooool0G_ooo`00Yoooo`030000<ol0<ol001@co`000`000?oo
ooooo`1Ooooo002Woooo00<0000co`0co`0053?o00030000oooooooo05ooool00:Ooool2000053?o
00030000oooooooo063oool00:Ooool00`0003?o03?o000C<ol000<0003oooooool0H?ooo`00Yooo
o`030000<ol0<ol001<co`000`000?ooooooo`1Poooo002Woooo00<0000co`0co`004S?o00030000
oooooooo067oool00:Ooool00`0003?o03?o000B<ol000<0003oooooool0HOooo`00Woooo`D00003
oooo00<0000co`0co`004C?o00030000oooooooo06;oool00:7oool00`000?ooooooo`03oooo00<0
000co`0co`004C?o00030000oooooooo06;oool00:7oool00`000?ooooooo`03oooo0`00014co`00
0`000?ooooooo`1Roooo002Qoooo00<0003oooooool00oooo`030000<ol0<ol0010co`000`000?oo
ooooo`1Soooo002Qoooo00<0003oooooool00oooo`030000<ol0<ol0010co`000`000?ooooooo`1S
oooo002Poooo0P0000Goool00`0003?o03?o000@<ol000<0003oooooool0Hoooo`00Yoooo`030000
<ol0<ol0010co`000`000?ooooooo`1Soooo002Woooo00<0000co`0co`003c?o00030000oooooooo
06Coool00:Ooool2000043?o00030000oooooooo06Coool00:Ooool00`0003?o03?o000?<ol000<0
003oooooool0I?ooo`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`1Toooo002Woooo00<0
000co`0co`003S?o00030000oooooooo06Goool00:Ooool00`0003?o03?o000><ol000<0003ooooo
ool0IOooo`00Yoooo`030000<ol0<ol000hco`000`000?ooooooo`1Uoooo002Woooo0P0000lco`00
0`000?ooooooo`1Uoooo002Woooo00<0000co`0co`003C?o00030000oooooooo06Koool00:Ooool0
0`0003?o03?o000=<ol000<0003oooooool0I_ooo`00Yoooo`030000<ol0<ol000dco`000`000?oo
ooooo`1Voooo002Woooo00<0000co`0co`003C?o00030000oooooooo06Koool00:Ooool00`0003?o
03?o000<<ol000<0003oooooool0Ioooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`1W
oooo002Woooo0P0000dco`000`000?ooooooo`1Woooo002Woooo00<0000co`0co`0033?o00030000
oooooooo06Ooool00:Ooool00`0003?o03?o000;<ol000<0003oooooool0J?ooo`00Yoooo`030000
<ol0<ol000/co`000`000?ooooooo`1Xoooo002Woooo00<0000co`0co`002c?o00030000oooooooo
06Soool00:Ooool00`0003?o03?o000;<ol000<0003oooooool0J?ooo`00Yoooo`80000<<ol000<0
003oooooool0J?ooo`00Yoooo`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Woooo00<0
000co`0co`002S?o00030000oooooooo06Woool00:Ooool00`0003?o03?o000:<ol000<0003ooooo
ool0JOooo`00Woooo`@00004oooo00<0000co`0co`002S?o00030000oooooooo06Woool009ooool0
0`000?ooooooo`05oooo00<0000co`0co`002S?o00030000oooooooo06Woool00:3oool00`000?oo
ooooo`04oooo0`0000Xco`000`000?ooooooo`1Yoooo002Qoooo00<0003oooooool00oooo`030000
<ol0<ol000Tco`000`000?ooooooo`1Zoooo002Ooooo00@0003oooooool00004oooo00<0000co`0c
o`002C?o00030000oooooooo06[oool00:3oool200001Oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`1Zoooo002Woooo00<0000co`0co`002C?o00030000oooooooo06[oool00:Ooool00`0003?o
03?o0009<ol000<0003oooooool0J_ooo`00Yoooo`80000:<ol000<0003oooooool0J_ooo`00Yooo
o`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo002Woooo00<0000co`0co`0023?o00030000
oooooooo06_oool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000
<ol0<ol000Pco`000`000?ooooooo`1[oooo002Woooo00<0000co`0co`0023?o00030000oooooooo
06_oool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00Yoooo`800009<ol000<0
003oooooool0Joooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo002Woooo00<0
000co`0co`001c?o00030000oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0003ooooo
ool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo00<0000co`0c
o`001c?o00030000oooooooo06coool00:Ooool2000023?o00030000oooooooo06coool00:Ooool0
0`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?oo
ooooo`1/oooo002Woooo00<0000co`0co`001c?o00030000oooooooo06coool00:Ooool00`0003?o
03?o0007<ol000<0003oooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/
oooo002Woooo0P0000Lco`000`000?ooooooo`1]oooo002Woooo00<0000co`0co`001S?o00030000
oooooooo06goool00:Ooool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00Yoooo`030000
<ol0<ol000Hco`000`000?ooooooo`1]oooo002Poooo0P0000Goool00`0003?o03?o0006<ol000<0
003oooooool0KOooo`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1]oooo002Qoooo00<0003oooooool00oooo`<00006<ol000<0003oooooool0KOooo`00X_oo
o`030000oooooooo00;oool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00Woooo`040000
oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002Poooo0P0000Goool0
0`0003?o03?o0006<ol000<0003oooooool0KOooo`00Yoooo`030000<ol0<ol000Dco`000`000?oo
ooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo06koool00:Ooool00`0003?o
03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`800006<ol000<0003oooooool0K_ooo`00Yooo
o`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000
oooooooo06koool00:Ooool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`030000
<ol0<ol000Dco`000`000?ooooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo
06koool00:Ooool200001S?o00030000oooooooo06koool00:Ooool00`0003?o03?o0004<ol000<0
003oooooool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0
000co`0co`0013?o00030000oooooooo06ooool00:Ooool00`0003?o03?o0004<ol000<0003ooooo
ool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo0P0000Dco`00
0`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o00030000oooooooo06ooool00:Ooool0
0`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?oo
ooooo`1_oooo002Woooo00<0000co`0co`0013?o00030000oooooooo06ooool00:Ooool00`0003?o
03?o0003<ol000<0003oooooool0L?ooo`00Yoooo`800004<ol000<0003oooooool0L?ooo`00Yooo
o`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002Woooo00<0000co`0co`000c?o00030000
oooooooo073oool00:Ooool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00Yoooo`030000
<ol0<ol000<co`000`000?ooooooo`1`oooo002Qoooo0`0000?oool00`0003?o03?o0003<ol000<0
003oooooool0L?ooo`00X_ooo`030000oooooooo00;oool00`0003?o03?o0003<ol000<0003ooooo
ool0L?ooo`00Woooo`D00003oooo0`0000<co`000`000?ooooooo`1`oooo002Ooooo00@0003ooooo
ool00004oooo1S?o07?oool00:3oool00`000?ooo`000004oooo1S?o07?oool00:7oool200001?oo
o`Hco`1coooo002Woooo1S?o07?oool00:Ooool6<ol0Loooo`00O?ooo`030000oooooooo02;oool0
0`000?ooooooo`03oooo1S?o07?oool007_oool00`000?ooooooo`08oooo00<0003oooooool06Ooo
o`030000oooooooo00;oool6<ol0Loooo`00Noooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00Koool500000_ooo`800005oooo0`0000;oool00`000?ooooooo`02oooo1S?o07?oool0
07_oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Ooool0
0`000?ooooooo`0:oooo00D0003oooooooooool000001?ooo`Hco`1coooo001joooo00<0003ooooo
ool00_ooo`030000oooooooo00ooool00`000?ooooooo`07oooo1@0000?oool010000?oooooooooo
o`Hco`1coooo001koooo00<0003oooooool01@0000koool00`000?ooooooo`07oooo00@0003ooooo
ool00003oooo00<0003oooooool00_ooo`Hco`1coooo001koooo00D0003oooooooooool000004Ooo
o`030000oooooooo00Soool00`000?ooo`000003oooo00<0003oooooool00_ooo`Hco`1coooo001l
oooo00<0003oooooool04Oooo`80000;oooo0P0000;oool00`000?ooooooo`03oooo1S?o07?oool0
0:Ooool6<ol0Loooo`00Yoooo`Hco`1coooo0000\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {501.875, 360.563}} -> {-0.349561, \
2.55153, 0.00349883, 0.00566123}, {{79.875, 308.563}, {501.875, 360.563}} -> \
{-5.53614, 13.2635, 0.0207442, 0.0319664}, {{79.875, 308.563}, {501.875, \
360.563}} -> {-5.53614, 13.2635, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
0 .4 1 r
.02381 .12361 m
.04262 .12361 L
.06244 .12361 L
.08255 .12361 L
.08806 .12361 L
.09396 .12361 L
.09682 .12361 L
.09822 .12361 L
.09952 .12361 L
.1007 .12271 L
.10195 .12111 L
.10458 .11782 L
.14241 .08029 L
.16182 .06666 L
.1827 .05511 L
.20384 .04603 L
.22393 .03932 L
.24373 .03417 L
.26212 .03043 L
.28264 .02723 L
.30125 .02507 L
.3205 .02346 L
.33134 .0228 L
.34132 .02233 L
.34601 .02216 L
.35105 .02201 L
.35581 .0219 L
.36014 .02182 L
.36278 .02178 L
.36522 .02175 L
.3665 .02174 L
.3679 .02174 L
.36861 .02173 L
.36937 .02173 L
.37009 .02173 L
.37075 .02172 L
.37196 .02172 L
.37309 .02172 L
.37433 .02172 L
.37565 .02173 L
.37631 .02173 L
.37704 .02174 L
.37835 .02174 L
.3808 .02177 L
.38316 .02179 L
.38569 .02183 L
.39027 .02192 L
.39571 .02206 L
.40068 .02222 L
.41147 .02269 L
Mistroke
.42172 .02328 L
.44157 .02486 L
.45997 .02693 L
.4788 .02973 L
.48007 .02995 L
.48128 .0286 L
.48194 .02873 L
.48266 .02887 L
.48393 .02912 L
.4887 .0301 L
.49369 .03116 L
.49915 .03237 L
.51033 .03498 L
.5206 .0375 L
.54078 .04268 L
.56021 .0478 L
.58162 .05344 L
.59139 .05598 L
.59268 .05631 L
.59338 .0565 L
.59405 .05667 L
.59534 .05741 L
.59652 .05769 L
.5991 .05825 L
.60191 .05876 L
.60668 .05941 L
.60937 .05966 L
.61184 .05984 L
.61395 .05995 L
.61514 .05999 L
.61626 .06002 L
.61744 .06004 L
.61852 .06005 L
.61976 .06005 L
.62094 .06004 L
.62207 .06002 L
.6233 .05999 L
.62445 .05995 L
.62552 .0599 L
.62798 .05978 L
.63057 .0596 L
.63547 .05917 L
.64082 .05856 L
.65036 .05714 L
.65923 .05551 L
.67795 .05123 L
.69825 .04558 L
.70363 .04393 L
.70658 .04301 L
.70802 .04255 L
Mistroke
.70934 .04213 L
.71054 .04306 L
.71168 .04415 L
.71421 .04651 L
.71957 .05129 L
.73971 .06669 L
.77793 .08737 L
.79761 .09487 L
.81859 .10115 L
.84002 .10615 L
.86019 .10984 L
.89876 .11485 L
.91872 .11668 L
.93979 .1182 L
.97619 .12008 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool005_ooolX
06Ko9?ooo`80001goooo001Foooo1@1VobSoool506Ko0_ooo`80I_lKoooo00<0003oooooool0M_oo
o`00DOooo`D0I_lboooo0`1Vo`03oooo06Ko06Ko00<0I_lFoooo00<0003oooooool0M_ooo`00C?oo
o`D0I_m0oooo0P1VoaCoool00`000?ooooooo`1foooo0018oooo101VodOoool406Ko4?ooo`030000
oooooooo07Koool004Koool206KoCoooo`D0I_l;oooo00<0003oooooool06Oooo`<0I_mJoooo0013
oooo0`1VoeKoool406Ko1oooo`030000oooooooo01Goool406Ko0_ooo`0306Kooooooooo05Soool0
047oool206KoGOooo`<0I_l4oooo0P00017oool506Ko1oooo`80I_mHoooo000ooooo0P1Vof;oool4
06Ko00<0003oooooool03Oooo`<0I_l>oooo00<0I_ooooooool0EOooo`00?Oooo`80I_mXoooo00<0
0000I_l0I_l03@1Voa;oool206KoEOooo`00>oooo`80I_mZoooo00<0003oooooool08Oooo`0306Ko
oooooooo05;oool003Woool206KoK?ooo`030000oooooooo02;oool00`1Vooooooooo`1Aoooo000g
oooo0P1Vofkoool00`000?ooooooo`0Soooo0P1Voe7oool003Goool206KoL?ooo`80000Voooo0P1V
odooool001Soool200006_ooo`0306Kooooooooo017oool40000;?ooo`D0000Zoooo00<0003ooooo
ool09oooo`80I_l2oooo1@0002coool400005_ooo`005oooo`040000oooooooo00006?ooo`0306Ko
oooooooo01;oool00`000?ooooooo`0_oooo00<0003oooooool0:_ooo`030000oooooooo02Woool2
06Ko0_ooo`030000oooooooo02coool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool05_oo
o`0306Kooooooooo01Coool00`000?ooooooo`0^oooo00<0003oooooool0:_ooo`030000oooooooo
02_oool206Ko00<0003oooooool0;Oooo`030000oooooooo01Koool0017oool400001Oooo`030000
oooooooo01Coool00`1Vooooooooo`0>oooo100000Coool00`000?ooooooo`0Uoooo100000Coool0
0`000?ooooooo`0Zoooo00<0003oooooool0;Oooo`03000006Kooooo02koool00`000?ooooooo`0E
oooo000Goooo00@0003oooooool0000Eoooo00<0I_ooooooool05Oooo`040000oooooooo0000;_oo
o`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003oool0I_l00P1Vob[oool010000?oo
ooooo`0001Koool001Soool200005Oooo`0306Kooooooooo01Ooool20000;_ooo`80000/oooo0P00
02goool200001?ooo`<0I_lXoooo0P0001Ooool002ooool00`1Vooooooooo`1eoooo00<0003ooooo
ool0=Oooo`@0I_lmoooo000^oooo00<0I_ooooooool0M_ooo`030000oooooooo03Woool506Ko>?oo
o`00;Oooo`0306Kooooooooo07Ooool00`000?ooooooo`0noooo1`1Voc7oool002coool00`1Voooo
ooooo`1hoooo00<0003oooooool0AOooo`P0I_lYoooo000[oooo00<0I_ooooooool0NOooo`030000
oooooooo04goool<06Ko7Oooo`004?ooool0000Aoooo000Foooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0000co`0co`001c?o00030000
<ol0<ol000Hco`000`0003?o03?o0007<ol000<0000co`0co`001c?o00030000<ol0<ol000Hco`00
0`0003?o03?o0005<ol06P0000Goool00`000?ooooooo`07oooo00<0003oooooool05Oooo`005_oo
o`030000oooooooo02koool00`000?ooooooo`0]oooo00<0003oooooool0;Oooo`030000<ol0<ol0
02dco`080000:Oooo`030000oooooooo01Goool00:Ooool00`0003?o03?o000Z<ol00`0004Woool0
0:Ooool00`0003?o03?o000V<ol0100004coool00:Ooool00`0003?o03?o000T<ol00P00053oool0
0:Ooool00`0003?o03?o000S<ol000<0003oooooool0D?ooo`00Yoooo`80000R<ol00P0005?oool0
0:Ooool00`0003?o03?o000O<ol00P0005Goool00:Ooool00`0003?o03?o000N<ol000<0003ooooo
ool0EOooo`00Yoooo`030000<ol0<ol001dco`000`000?ooooooo`1Foooo002Woooo00<0000co`0c
o`0073?o00030000oooooooo05Ooool00:Ooool00`0003?o03?o000K<ol000<0003oooooool0F?oo
o`00Yoooo`80000L<ol000<0003oooooool0F?ooo`00Yoooo`030000<ol0<ol001Xco`000`000?oo
ooooo`1Ioooo002Woooo00<0000co`0co`006C?o00030000oooooooo05[oool00:Ooool00`0003?o
03?o000H<ol000<0003oooooool0Foooo`00Yoooo`030000<ol0<ol001Lco`000`000?ooooooo`1L
oooo002Woooo00<0000co`0co`005S?o00030000oooooooo05goool00:Ooool200005c?o00030000
oooooooo05goool00:Ooool00`0003?o03?o000E<ol000<0003oooooool0G_ooo`00Yoooo`030000
<ol0<ol001Dco`000`000?ooooooo`1Noooo002Woooo00<0000co`0co`005C?o00030000oooooooo
05koool00:Ooool00`0003?o03?o000D<ol000<0003oooooool0Goooo`00Yoooo`030000<ol0<ol0
01@co`000`000?ooooooo`1Ooooo002Woooo0P0001@co`000`000?ooooooo`1Poooo002Woooo00<0
000co`0co`004c?o00030000oooooooo063oool00:Ooool00`0003?o03?o000C<ol000<0003ooooo
ool0H?ooo`00Yoooo`030000<ol0<ol0018co`000`000?ooooooo`1Qoooo002Woooo00<0000co`0c
o`004S?o00030000oooooooo067oool009ooool500000oooo`030000<ol0<ol0014co`000`000?oo
ooooo`1Roooo002Qoooo00<0003oooooool00oooo`030000<ol0<ol0014co`000`000?ooooooo`1R
oooo002Qoooo00<0003oooooool00oooo`<0000A<ol000<0003oooooool0H_ooo`00XOooo`030000
oooooooo00?oool00`0003?o03?o000@<ol000<0003oooooool0Hoooo`00XOooo`030000oooooooo
00?oool00`0003?o03?o000@<ol000<0003oooooool0Hoooo`00X?ooo`800005oooo00<0000co`0c
o`0043?o00030000oooooooo06?oool00:Ooool00`0003?o03?o000@<ol000<0003oooooool0Hooo
o`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`1Toooo002Woooo0P00010co`000`000?oo
ooooo`1Toooo002Woooo00<0000co`0co`003c?o00030000oooooooo06Coool00:Ooool00`0003?o
03?o000?<ol000<0003oooooool0I?ooo`00Yoooo`030000<ol0<ol000hco`000`000?ooooooo`1U
oooo002Woooo00<0000co`0co`003S?o00030000oooooooo06Goool00:Ooool00`0003?o03?o000>
<ol000<0003oooooool0IOooo`00Yoooo`80000?<ol000<0003oooooool0IOooo`00Yoooo`030000
<ol0<ol000dco`000`000?ooooooo`1Voooo002Woooo00<0000co`0co`003C?o00030000oooooooo
06Koool00:Ooool00`0003?o03?o000=<ol000<0003oooooool0I_ooo`00Yoooo`030000<ol0<ol0
00dco`000`000?ooooooo`1Voooo002Woooo00<0000co`0co`0033?o00030000oooooooo06Ooool0
0:Ooool00`0003?o03?o000<<ol000<0003oooooool0Ioooo`00Yoooo`80000=<ol000<0003ooooo
ool0Ioooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`1Woooo002Woooo00<0000co`0c
o`002c?o00030000oooooooo06Soool00:Ooool00`0003?o03?o000;<ol000<0003oooooool0J?oo
o`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`1Xoooo002Woooo00<0000co`0co`002c?o
00030000oooooooo06Soool00:Ooool2000033?o00030000oooooooo06Soool00:Ooool00`0003?o
03?o000:<ol000<0003oooooool0JOooo`00Yoooo`030000<ol0<ol000Xco`000`000?ooooooo`1Y
oooo002Woooo00<0000co`0co`002S?o00030000oooooooo06Woool009ooool400001?ooo`030000
<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Ooooo00<0003oooooool01Oooo`030000<ol0<ol0
00Xco`000`000?ooooooo`1Yoooo002Poooo00<0003oooooool01?ooo`<0000:<ol000<0003ooooo
ool0JOooo`00XOooo`030000oooooooo00?oool00`0003?o03?o0009<ol000<0003oooooool0J_oo
o`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo002P
oooo0P0000Goool00`0003?o03?o0009<ol000<0003oooooool0J_ooo`00Yoooo`030000<ol0<ol0
00Tco`000`000?ooooooo`1Zoooo002Woooo00<0000co`0co`002C?o00030000oooooooo06[oool0
0:Ooool200002S?o00030000oooooooo06[oool00:Ooool00`0003?o03?o0008<ol000<0003ooooo
ool0Joooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo002Woooo00<0000co`0c
o`0023?o00030000oooooooo06_oool00:Ooool00`0003?o03?o0008<ol000<0003oooooool0Jooo
o`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo002Woooo00<0000co`0co`0023?o
00030000oooooooo06_oool00:Ooool200002C?o00030000oooooooo06_oool00:Ooool00`0003?o
03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/
oooo002Woooo00<0000co`0co`001c?o00030000oooooooo06coool00:Ooool00`0003?o03?o0007
<ol000<0003oooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002W
oooo0P0000Pco`000`000?ooooooo`1/oooo002Woooo00<0000co`0co`001c?o00030000oooooooo
06coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yoooo`030000<ol0<ol0
00Lco`000`000?ooooooo`1/oooo002Woooo00<0000co`0co`001c?o00030000oooooooo06coool0
0:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yoooo`800007<ol000<0003ooooo
ool0KOooo`00Yoooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002Woooo00<0000co`0c
o`001S?o00030000oooooooo06goool00:Ooool00`0003?o03?o0006<ol000<0003oooooool0KOoo
o`00X?ooo`800005oooo00<0000co`0co`001S?o00030000oooooooo06goool009ooool010000?oo
ooooo`0000Coool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00XOooo`030000oooooooo
00?oool300001S?o00030000oooooooo06goool00:;oool00`000?ooooooo`02oooo00<0000co`0c
o`001S?o00030000oooooooo06goool009ooool010000?ooooooo`0000Coool00`0003?o03?o0006
<ol000<0003oooooool0KOooo`00X?ooo`800005oooo00<0000co`0co`001S?o00030000oooooooo
06goool00:Ooool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`030000<ol0<ol0
00Dco`000`000?ooooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo06koool0
0:Ooool200001S?o00030000oooooooo06koool00:Ooool00`0003?o03?o0005<ol000<0003ooooo
ool0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002Woooo00<0000co`0c
o`001C?o00030000oooooooo06koool00:Ooool00`0003?o03?o0005<ol000<0003oooooool0K_oo
o`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002Woooo0P0000Hco`000`000?oo
ooooo`1^oooo002Woooo00<0000co`0co`0013?o00030000oooooooo06ooool00:Ooool00`0003?o
03?o0004<ol000<0003oooooool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_
oooo002Woooo00<0000co`0co`0013?o00030000oooooooo06ooool00:Ooool00`0003?o03?o0004
<ol000<0003oooooool0Koooo`00Yoooo`800005<ol000<0003oooooool0Koooo`00Yoooo`030000
<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o00030000oooooooo
06ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yoooo`030000<ol0<ol0
00@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0co`000c?o00030000oooooooo073oool0
0:Ooool2000013?o00030000oooooooo073oool00:Ooool00`0003?o03?o0003<ol000<0003ooooo
ool0L?ooo`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002Woooo00<0000co`0c
o`000c?o00030000oooooooo073oool00:Ooool00`0003?o03?o0003<ol000<0003oooooool0L?oo
o`00XOooo`<00003oooo00<0000co`0co`000c?o00030000oooooooo073oool00:;oool00`000?oo
ooooo`02oooo00<0000co`0co`000c?o00030000oooooooo073oool009ooool500000oooo`<00003
<ol000<0003oooooool0L?ooo`00Woooo`040000oooooooo00001?ooo`Hco`1coooo002Poooo00<0
003oool000001?ooo`Hco`1coooo002Qoooo0P0000Coool6<ol0Loooo`00Yoooo`Hco`1coooo002W
oooo1S?o07?oool007coool00`000?ooooooo`0Roooo00<0003oooooool00oooo`Hco`1coooo001k
oooo00<0003oooooool02?ooo`030000oooooooo01Woool00`000?ooooooo`02oooo1S?o07?oool0
07_oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`06oooo1@0000;oool200000ooo
o`<00004oooo00<0003oooooool00_ooo`Hco`1coooo001koooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo00;oool6<ol0Loooo`00N_ooo`030000oooooooo00;oool00`000?oo
ooooo`0?oooo00<0003oooooool01oooo`040000oooooooo00001?ooo`040000oooooooooooo1S?o
07?oool007_oool00`000?ooooooo`0500003_ooo`030000oooooooo00Ooool300001?ooo`030000
oooooooo00;oool6<ol0Loooo`00Noooo`050000oooooooooooo0000017oool00`000?ooooooo`08
oooo00<0003oooooool00oooo`030000oooooooo00;oool6<ol0Loooo`00O?ooo`030000oooooooo
017oool200002_ooo`<00002oooo00<0003oooooool00oooo`Hco`1coooo002Woooo1S?o07?oool0
0:Ooool6<ol0Loooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {650.563, 509.25}} -> {-0.349561, \
3.60372, 0.00349883, 0.00566123}, {{79.875, 308.563}, {650.563, 509.25}} -> \
{-5.53614, 19.2047, 0.0207442, 0.0319664}, {{79.875, 308.563}, {650.563, \
509.25}} -> {-5.53614, 19.2047, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
0 .4 1 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.05546 .12361 L
.05789 .12361 L
.06007 .12361 L
.06131 .12361 L
.06244 .12291 L
.06371 .12129 L
.06487 .11983 L
.06747 .11662 L
.07218 .11105 L
.0829 .09947 L
.10458 .08009 L
.12357 .06676 L
.14429 .05527 L
.16396 .04671 L
.18493 .03959 L
.20635 .03401 L
.22652 .02999 L
.24659 .02696 L
.26507 .02488 L
.28389 .02336 L
.29458 .02273 L
.30455 .02228 L
.30956 .02211 L
.31501 .02196 L
.3175 .0219 L
.32015 .02185 L
.32244 .02181 L
.32491 .02178 L
.32728 .02175 L
.32832 .02174 L
.32946 .02174 L
.33046 .02173 L
.33154 .02173 L
.33267 .02172 L
.33373 .02172 L
.33499 .02172 L
.3357 .02172 L
.33635 .02172 L
.33755 .02173 L
.33883 .02173 L
.33997 .02174 L
.34103 .02175 L
.34346 .02177 L
.34605 .02181 L
.34844 .02185 L
Mistroke
.35387 .02196 L
.35866 .02209 L
.36375 .02227 L
.37348 .02269 L
.38229 .02319 L
.40157 .02469 L
.41243 .02579 L
.42241 .027 L
.43229 .02838 L
.43513 .02882 L
.43783 .02925 L
.44024 .02965 L
.4409 .02977 L
.44161 .02989 L
.44287 .02854 L
.44404 .02877 L
.44512 .02898 L
.44755 .02947 L
.45194 .03038 L
.46195 .03258 L
.49997 .04197 L
.53965 .05242 L
.57781 .0622 L
.58792 .06468 L
.59288 .06587 L
.59506 .06639 L
.59622 .06692 L
.59746 .06719 L
.59878 .06745 L
.60002 .06768 L
.60273 .06812 L
.60567 .06851 L
.60845 .0688 L
.61094 .06901 L
.61226 .0691 L
.61366 .06918 L
.61483 .06923 L
.61613 .06928 L
.61731 .06932 L
.61842 .06934 L
.61959 .06935 L
.62085 .06936 L
.62203 .06936 L
.62311 .06935 L
.62437 .06933 L
.62508 .06931 L
.62574 .0693 L
.62823 .06921 L
.63063 .06909 L
.63326 .06894 L
Mistroke
.63858 .06851 L
.64813 .06746 L
.65707 .06617 L
.67734 .06235 L
.69587 .05799 L
.71647 .05235 L
.7265 .04934 L
.73559 .04648 L
.74017 .045 L
.74258 .0442 L
.74512 .04336 L
.7462 .043 L
.74735 .04261 L
.74862 .04347 L
.7498 .04458 L
.7541 .0485 L
.77381 .06409 L
.79506 .07727 L
.81519 .08704 L
.85354 .10031 L
.87333 .10514 L
.89434 .10918 L
.93211 .11435 L
.95147 .11623 L
.97233 .11783 L
.97619 .11809 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool005;ooolV
06Ko;oooo`80001goooo001=oooo1@1VobKoool:06Ko9Oooo`030000oooooooo07Koool004Soool5
06Ko<oooo`0306Kooooo06Ko00@0I_lPoooo00<0003oooooool0M_ooo`00@oooo`D0I_looooo0`1V
oagoool00`000?ooooooo`1foooo000noooo1@1VodOoool406Ko6Oooo`030000oooooooo07Koool0
03coool206KoD?ooo`@0I_lEoooo00<0003oooooool08_ooo`<0I_mAoooo000ioooo0`1VoeKoool5
06Ko4?ooo`030000oooooooo023oool206Ko0oooo`0306Kooooooooo04koool003Ooool206KoG_oo
o`@0I_l<oooo0P0001coool506Ko1_ooo`0306Kooooooooo04goool003Goool206KoI?ooo`<0I_l9
oooo00<0003oooooool06Oooo`80I_l<oooo0P1Vodgoool003?oool206KoJOooo`@0I_l5oooo00<0
003oooooool05Oooo`@0I_l@oooo00<0I_ooooooool0B_ooo`00<Oooo`80I_m_oooo101Vo`03oooo
0000oooo017oool506Ko5Oooo`0306Kooooooooo04Woool0033oool00`1Vooooooooo`1coooo00<0
I_l00000I_l00P1Vo`Ooool806Ko6oooo`80I_m9oooo000^oooo0P1VogOoool00`000?ooooooo`08
06Ko9Oooo`0306Kooooooooo04Koool002coool206KoNOooo`80000_oooo0P1VodKoool001Soool2
00004Oooo`0306Kooooooooo01[oool40000;?ooo`D0000Zoooo00<0003oooooool0:oooo`D00002
06Ko:_ooo`@0000Foooo000Goooo00@0003oooooool0000?oooo00<0I_ooooooool06oooo`030000
oooooooo02ooool00`000?ooooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo00;oool2
06Ko:?ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0=oooo00<0I_ooooooool07Ooo
o`030000oooooooo02koool00`000?ooooooo`0Zoooo00<0003oooooool0;Oooo`030000oooooooo
00Coool306Ko9_ooo`030000oooooooo01Koool0017oool400001Oooo`030000oooooooo00[oool2
06Ko6Oooo`@00004oooo00<0003oooooool09Oooo`@00004oooo00<0003oooooool0:_ooo`030000
oooooooo02goool00`000?ooooooo`07oooo0`1VobCoool00`000?ooooooo`0Eoooo000Goooo00@0
003oooooool0000;oooo00<0I_ooooooool07oooo`040000oooooooo0000;_ooo`030000oooooooo
02[oool00`000?ooooooo`0]oooo00<0003oooooool02_ooo`@0I_lNoooo00@0003oooooool0000F
oooo000Hoooo0P0000_oool00`1Vooooooooo`0Qoooo0P0002koool20000;?ooo`80000]oooo0P00
013oool306Ko7?ooo`80000Goooo000Toooo00<0I_ooooooool0P?ooo`030000oooooooo047oool2
06Ko<oooo`008oooo`0306Kooooooooo087oool00`000?ooooooo`13oooo101Vobooool002;oool0
0`1Vooooooooo`22oooo00<0003oooooool0Aoooo`L0I_lXoooo000Qoooo00<0I_ooooooool0Pooo
o`030000oooooooo04koool706Ko8Oooo`008Oooo`0306Kooooooooo08?oool00`000?ooooooo`1E
oooo2P1VoaOoool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000<ol0<ol000Lco`000`0003?o03?o0006
<ol000<0000co`0co`001c?o00030000<ol0<ol000Lco`000`0003?o03?o0006<ol000<0000co`0c
o`001C?o01X00005oooo00<0003oooooool01oooo`030000oooooooo01Goool001Koool00`000?oo
ooooo`0^oooo00<0003oooooool0;Oooo`030000oooooooo02goool00`0003?o03?o000]<ol02000
02Woool00`000?ooooooo`0Eoooo002Woooo00<0000co`0co`00:S?o00<00019oooo002Woooo00<0
000co`0co`009S?o00@0001<oooo002Woooo00<0000co`0co`0093?o0080001@oooo002Woooo00<0
000co`0co`008c?o00030000oooooooo053oool00:Ooool200008S?o0080001Coooo002Woooo00<0
000co`0co`007c?o0080001Eoooo002Woooo00<0000co`0co`007S?o00030000oooooooo05Goool0
0:Ooool00`0003?o03?o000M<ol000<0003oooooool0E_ooo`00Yoooo`030000<ol0<ol001`co`00
0`000?ooooooo`1Goooo002Woooo00<0000co`0co`006c?o00030000oooooooo05Soool00:Ooool2
000073?o00030000oooooooo05Soool00:Ooool00`0003?o03?o000J<ol000<0003oooooool0FOoo
o`00Yoooo`030000<ol0<ol001Tco`000`000?ooooooo`1Joooo002Woooo00<0000co`0co`0063?o
00030000oooooooo05_oool00:Ooool00`0003?o03?o000G<ol000<0003oooooool0G?ooo`00Yooo
o`030000<ol0<ol001Hco`000`000?ooooooo`1Moooo002Woooo0P0001Lco`000`000?ooooooo`1M
oooo002Woooo00<0000co`0co`005C?o00030000oooooooo05koool00:Ooool00`0003?o03?o000E
<ol000<0003oooooool0G_ooo`00Yoooo`030000<ol0<ol001Dco`000`000?ooooooo`1Noooo002W
oooo00<0000co`0co`0053?o00030000oooooooo05ooool00:Ooool00`0003?o03?o000D<ol000<0
003oooooool0Goooo`00Yoooo`80000D<ol000<0003oooooool0H?ooo`00Yoooo`030000<ol0<ol0
01<co`000`000?ooooooo`1Poooo002Woooo00<0000co`0co`004c?o00030000oooooooo063oool0
0:Ooool00`0003?o03?o000B<ol000<0003oooooool0HOooo`00Yoooo`030000<ol0<ol0018co`00
0`000?ooooooo`1Qoooo002Ooooo1@0000?oool00`0003?o03?o000A<ol000<0003oooooool0H_oo
o`00XOooo`030000oooooooo00?oool00`0003?o03?o000A<ol000<0003oooooool0H_ooo`00XOoo
o`030000oooooooo00?oool300004C?o00030000oooooooo06;oool00:7oool00`000?ooooooo`03
oooo00<0000co`0co`0043?o00030000oooooooo06?oool00:7oool00`000?ooooooo`03oooo00<0
000co`0co`0043?o00030000oooooooo06?oool00:3oool200001Oooo`030000<ol0<ol0010co`00
0`000?ooooooo`1Soooo002Woooo00<0000co`0co`0043?o00030000oooooooo06?oool00:Ooool0
0`0003?o03?o000?<ol000<0003oooooool0I?ooo`00Yoooo`80000@<ol000<0003oooooool0I?oo
o`00Yoooo`030000<ol0<ol000lco`000`000?ooooooo`1Toooo002Woooo00<0000co`0co`003c?o
00030000oooooooo06Coool00:Ooool00`0003?o03?o000><ol000<0003oooooool0IOooo`00Yooo
o`030000<ol0<ol000hco`000`000?ooooooo`1Uoooo002Woooo00<0000co`0co`003S?o00030000
oooooooo06Goool00:Ooool200003c?o00030000oooooooo06Goool00:Ooool00`0003?o03?o000=
<ol000<0003oooooool0I_ooo`00Yoooo`030000<ol0<ol000dco`000`000?ooooooo`1Voooo002W
oooo00<0000co`0co`003C?o00030000oooooooo06Koool00:Ooool00`0003?o03?o000=<ol000<0
003oooooool0I_ooo`00Yoooo`030000<ol0<ol000`co`000`000?ooooooo`1Woooo002Woooo00<0
000co`0co`0033?o00030000oooooooo06Ooool00:Ooool200003C?o00030000oooooooo06Ooool0
0:Ooool00`0003?o03?o000<<ol000<0003oooooool0Ioooo`00Yoooo`030000<ol0<ol000/co`00
0`000?ooooooo`1Xoooo002Woooo00<0000co`0co`002c?o00030000oooooooo06Soool00:Ooool0
0`0003?o03?o000;<ol000<0003oooooool0J?ooo`00Yoooo`030000<ol0<ol000/co`000`000?oo
ooooo`1Xoooo002Woooo0P0000`co`000`000?ooooooo`1Xoooo002Woooo00<0000co`0co`002S?o
00030000oooooooo06Woool00:Ooool00`0003?o03?o000:<ol000<0003oooooool0JOooo`00Yooo
o`030000<ol0<ol000Xco`000`000?ooooooo`1Yoooo002Ooooo100000Coool00`0003?o03?o000:
<ol000<0003oooooool0JOooo`00Woooo`030000oooooooo00Goool00`0003?o03?o000:<ol000<0
003oooooool0JOooo`00X?ooo`030000oooooooo00Coool300002S?o00030000oooooooo06Woool0
0:7oool00`000?ooooooo`03oooo00<0000co`0co`002C?o00030000oooooooo06[oool009ooool0
10000?ooooooo`0000Coool00`0003?o03?o0009<ol000<0003oooooool0J_ooo`00X?ooo`800005
oooo00<0000co`0co`002C?o00030000oooooooo06[oool00:Ooool00`0003?o03?o0009<ol000<0
003oooooool0J_ooo`00Yoooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo002Woooo0P00
00Xco`000`000?ooooooo`1Zoooo002Woooo00<0000co`0co`0023?o00030000oooooooo06_oool0
0:Ooool00`0003?o03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000<ol0<ol000Pco`00
0`000?ooooooo`1[oooo002Woooo00<0000co`0co`0023?o00030000oooooooo06_oool00:Ooool0
0`0003?o03?o0008<ol000<0003oooooool0Joooo`00Yoooo`030000<ol0<ol000Pco`000`000?oo
ooooo`1[oooo002Woooo0P0000Tco`000`000?ooooooo`1[oooo002Woooo00<0000co`0co`0023?o
00030000oooooooo06_oool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yooo
o`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo00<0000co`0co`001c?o00030000
oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yoooo`800008
<ol000<0003oooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002W
oooo00<0000co`0co`001c?o00030000oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0
003oooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo00<0
000co`0co`001c?o00030000oooooooo06coool00:Ooool200001c?o00030000oooooooo06goool0
0:Ooool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00Yoooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1]oooo002Woooo00<0000co`0co`001S?o00030000oooooooo06goool00:3oool2
00001Oooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002Ooooo00@0003oooooool00004
oooo00<0000co`0co`001S?o00030000oooooooo06goool00:7oool00`000?ooooooo`03oooo0`00
00Hco`000`000?ooooooo`1]oooo002Roooo00<0003oooooool00_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1]oooo002Ooooo00@0003oooooool00004oooo00<0000co`0co`001S?o00030000
oooooooo06goool00:3oool200001Oooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002W
oooo00<0000co`0co`001C?o00030000oooooooo06koool00:Ooool00`0003?o03?o0005<ol000<0
003oooooool0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002Woooo0P00
00Hco`000`000?ooooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo06koool0
0:Ooool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`030000<ol0<ol000Dco`00
0`000?ooooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000oooooooo06koool00:Ooool0
0`0003?o03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`800006<ol000<0003oooooool0K_oo
o`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o
00030000oooooooo06ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yooo
o`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o00030000
oooooooo06ooool00:Ooool200001C?o00030000oooooooo06ooool00:Ooool00`0003?o03?o0004
<ol000<0003oooooool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002W
oooo00<0000co`0co`0013?o00030000oooooooo06ooool00:Ooool00`0003?o03?o0004<ol000<0
003oooooool0Koooo`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002Woooo0P00
00@co`000`000?ooooooo`1`oooo002Woooo00<0000co`0co`000c?o00030000oooooooo073oool0
0:Ooool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00Yoooo`030000<ol0<ol000<co`00
0`000?ooooooo`1`oooo002Woooo00<0000co`0co`000c?o00030000oooooooo073oool00:7oool3
00000oooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002Roooo00<0003oooooool00_oo
o`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002Ooooo1@0000?oool300000c?o00030000
oooooooo073oool009ooool010000?ooooooo`0000Coool6<ol0Loooo`00X?ooo`030000oooo0000
00Coool6<ol0Loooo`00XOooo`800004oooo1S?o07?oool00:Ooool6<ol0Loooo`00Yoooo`Hco`1c
oooo001loooo00<0003oooooool08_ooo`030000oooooooo00?oool6<ol0Loooo`00Noooo`030000
oooooooo00Soool00`000?ooooooo`0Ioooo00<0003oooooool00_ooo`Hco`1coooo001koooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool01_ooo`D00002oooo0P0000Coool200001?oo
o`030000oooooooo00;oool6<ol0Loooo`00Noooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool0
0`000?ooooooo`02oooo1S?o07?oool007[oool00`000?ooooooo`02oooo00<0003oooooool03ooo
o`030000oooooooo00Ooool010000?ooooooo`0000Coool010000?ooooooooooo`Hco`1coooo001k
oooo00<0003oooooool01@0000koool00`000?ooooooo`08oooo0P0000Coool00`000?ooooooo`02
oooo1S?o07?oool007_oool01@000?ooooooooooo`00000Aoooo00<0003oooooool01oooo`040000
oooooooo00000oooo`030000oooooooo00;oool6<ol0Loooo`00O?ooo`030000oooooooo017oool2
00002_ooo`800003oooo00<0003oooooool00oooo`Hco`1coooo002Woooo1S?o07?oool00:Ooool6
<ol0Loooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {204.5, 63.1875}} -> {-0.349561, \
0.447144, 0.00349883, 0.00566123}, {{79.875, 308.563}, {204.5, 63.1875}} -> \
{-5.53614, 1.38097, 0.0207442, 0.0319664}, {{79.875, 308.563}, {204.5, \
63.1875}} -> {-5.53614, 1.38097, 0.0207442, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
.59604 1.08795 L
.59723 1.05269 L
.59975 .98341 L
.60932 .77032 L
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.55838 .12361 L
.57861 .12361 L
.58392 .12361 L
.58957 .12361 L
.59232 .12361 L
.59367 .12361 L
.59491 .12361 L
s
.59491 .12361 m
.59549 .61803 L
s
.61895 .61803 m
.61984 .60395 L
.63004 .48764 L
.63935 .40845 L
.65009 .33967 L
.66026 .29076 L
.66991 .25511 L
.68017 .22583 L
.68892 .20621 L
.69859 .18901 L
.70801 .17575 L
.71794 .16474 L
.72882 .15535 L
.73879 .14865 L
.74834 .14358 L
.75853 .1393 L
.7769 .13378 L
.78714 .1316 L
.79825 .12976 L
.80873 .12842 L
.8184 .12744 L
.82744 .1267 L
.83716 .12607 L
.84783 .12553 L
.8578 .12512 L
.86793 .1248 L
.87898 .12453 L
.88941 .12433 L
.89908 .12418 L
.90967 .12406 L
.91964 .12396 L
.93826 .12384 L
.94788 .12379 L
.95803 .12375 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
0 .4 1 r
.02381 .12361 m
.04262 .10171 L
.06244 .08333 L
.08255 .06861 L
.10458 .05606 L
.12415 .04738 L
.14509 .04011 L
.16639 .03443 L
.18653 .03032 L
.20651 .02722 L
.22495 .02508 L
.24367 .0235 L
.25432 .02284 L
.2643 .02237 L
.26926 .02218 L
.27468 .02201 L
.2798 .02189 L
.28224 .02185 L
.28455 .02181 L
.28681 .02178 L
.28925 .02175 L
.29033 .02174 L
.29147 .02174 L
.29244 .02173 L
.29351 .02173 L
.29476 .02172 L
.2959 .02172 L
.29721 .02172 L
.29846 .02173 L
.2996 .02173 L
.30067 .02173 L
.30183 .02174 L
.30307 .02175 L
.30545 .02177 L
.30796 .02181 L
.31244 .02189 L
.31726 .022 L
.32254 .02216 L
.33201 .02253 L
.34082 .02299 L
.35134 .02368 L
.36128 .02449 L
.37987 .02644 L
.39818 .029 L
.40076 .02942 L
.4032 .02983 L
.40386 .02994 L
.40455 .03007 L
.40531 .02865 L
.40602 .02878 L
Mistroke
.40859 .02929 L
.41833 .03134 L
.43821 .03597 L
.45925 .04129 L
.50089 .05225 L
.541 .06252 L
.57961 .07162 L
.58995 .0739 L
.59499 .07499 L
.59606 .07538 L
.59719 .0756 L
.59844 .07583 L
.59959 .07602 L
.60208 .07641 L
.60444 .07672 L
.60964 .07724 L
.61235 .07743 L
.61488 .07756 L
.61634 .07762 L
.61767 .07766 L
.61913 .0777 L
.61986 .07771 L
.62066 .07772 L
.62131 .07772 L
.62199 .07773 L
.62321 .07773 L
.62452 .07772 L
.62527 .07771 L
.62597 .0777 L
.62723 .07767 L
.62838 .07764 L
.63096 .07755 L
.63326 .07745 L
.63576 .07731 L
.64031 .07699 L
.6512 .07594 L
.66128 .07464 L
.67992 .07156 L
.70051 .06731 L
.74068 .05697 L
.75913 .05144 L
.7696 .0481 L
.7747 .04643 L
.77934 .04487 L
.78172 .04406 L
.78298 .04364 L
.78431 .04318 L
.78547 .04278 L
.78675 .04368 L
.78901 .04578 L
Mistroke
.79935 .0547 L
.82044 .06984 L
.83987 .08081 L
.86075 .09012 L
.8819 .09749 L
.902 .10298 L
.9205 .10701 L
.94021 .11044 L
.97619 .11497 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.595238 0.190476 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.21429 .11111 -6 -9 ]
[.21429 .11111 6 0 ]
[.40476 .11111 -6 -9 ]
[.40476 .11111 6 0 ]
[.78571 .11111 -3 -9 ]
[.78571 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.58274 0 -12 -4.5 ]
[.58274 0 0 4.5 ]
[.58274 .24721 -6 -4.5 ]
[.58274 .24721 0 4.5 ]
[.58274 .37082 -6 -4.5 ]
[.58274 .37082 0 4.5 ]
[.58274 .49443 -6 -4.5 ]
[.58274 .49443 0 4.5 ]
[.58274 .61803 -6 -4.5 ]
[.58274 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-3)] .02381 .11111 0 1 Mshowa
.21429 .12361 m
.21429 .12986 L
s
[(-2)] .21429 .11111 0 1 Mshowa
.40476 .12361 m
.40476 .12986 L
s
[(-1)] .40476 .11111 0 1 Mshowa
.78571 .12361 m
.78571 .12986 L
s
[(1)] .78571 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.0619 .12361 m
.0619 .12736 L
s
.1 .12361 m
.1 .12736 L
s
.1381 .12361 m
.1381 .12736 L
s
.17619 .12361 m
.17619 .12736 L
s
.25238 .12361 m
.25238 .12736 L
s
.29048 .12361 m
.29048 .12736 L
s
.32857 .12361 m
.32857 .12736 L
s
.36667 .12361 m
.36667 .12736 L
s
.44286 .12361 m
.44286 .12736 L
s
.48095 .12361 m
.48095 .12736 L
s
.51905 .12361 m
.51905 .12736 L
s
.55714 .12361 m
.55714 .12736 L
s
.63333 .12361 m
.63333 .12736 L
s
.67143 .12361 m
.67143 .12736 L
s
.70952 .12361 m
.70952 .12736 L
s
.74762 .12361 m
.74762 .12736 L
s
.82381 .12361 m
.82381 .12736 L
s
.8619 .12361 m
.8619 .12736 L
s
.9 .12361 m
.9 .12736 L
s
.9381 .12361 m
.9381 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.59524 0 m
.60149 0 L
s
[(-1)] .58274 0 1 0 Mshowa
.59524 .24721 m
.60149 .24721 L
s
[(1)] .58274 .24721 1 0 Mshowa
.59524 .37082 m
.60149 .37082 L
s
[(2)] .58274 .37082 1 0 Mshowa
.59524 .49443 m
.60149 .49443 L
s
[(3)] .58274 .49443 1 0 Mshowa
.59524 .61803 m
.60149 .61803 L
s
[(4)] .58274 .61803 1 0 Mshowa
.125 Mabswid
.59524 .02472 m
.59899 .02472 L
s
.59524 .04944 m
.59899 .04944 L
s
.59524 .07416 m
.59899 .07416 L
s
.59524 .09889 m
.59899 .09889 L
s
.59524 .14833 m
.59899 .14833 L
s
.59524 .17305 m
.59899 .17305 L
s
.59524 .19777 m
.59899 .19777 L
s
.59524 .22249 m
.59899 .22249 L
s
.59524 .27193 m
.59899 .27193 L
s
.59524 .29666 m
.59899 .29666 L
s
.59524 .32138 m
.59899 .32138 L
s
.59524 .3461 m
.59899 .3461 L
s
.59524 .39554 m
.59899 .39554 L
s
.59524 .42026 m
.59899 .42026 L
s
.59524 .44498 m
.59899 .44498 L
s
.59524 .46971 m
.59899 .46971 L
s
.59524 .51915 m
.59899 .51915 L
s
.59524 .54387 m
.59899 .54387 L
s
.59524 .56859 m
.59899 .56859 L
s
.59524 .59331 m
.59899 .59331 L
s
.25 Mabswid
.59524 0 m
.59524 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Ooooo1@0007coool00:7oool00`000?ooooooo`1loooo002Qoooo00<0003ooooo
ool00oooo`<0001foooo002Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0M_oo
o`00XOooo`030000oooooooo00?oool00`000?ooooooo`1foooo002Poooo0P0000Goool00`000?oo
ooooo`1foooo002Woooo00<0003oooooool0M_ooo`00Yoooo`030000oooooooo07Koool004SooolW
06Ko>?ooo`80001goooo0013oooo1@1VobOoool706Ko00?oool0I_l0I_l0;_ooo`030000oooooooo
07Koool003goool606Ko<oooo`80I_l00oooo`1Vo`1Vo`0206Ko:_ooo`030000oooooooo07Koool0
03Soool506Ko@?ooo`@0I_lVoooo00<0003oooooool0M_ooo`00=?ooo`@0I_m9oooo0`1Vob?oool0
0`000?ooooooo`1foooo000boooo0P1Voe3oool406Ko7oooo`030000oooooooo02coool306KoAooo
o`00;oooo`<0I_mFoooo1@1Voa[oool00`000?ooooooo`0Yoooo0`1Vo`;oool00`1Vooooooooo`15
oooo000]oooo0P1Voekoool406Ko5_ooo`80000Woooo0`1Vo`Koool206KoAOooo`00:oooo`80I_mT
oooo0`1Voa?oool00`000?ooooooo`0Toooo0P1Vo`_oool00`1Vooooooooo`12oooo000Yoooo0P1V
ofWoool406Ko3oooo`030000oooooooo023oool406Ko3_ooo`0306Kooooooooo047oool002Ooool2
06KoKoooo`@0I_l;oooo00<0003oooooool06oooo`D0I_lCoooo0P1Vod7oool002Goool206KoMOoo
o`D0I_l6oooo00<0003oooooool05_ooo`D0I_lJoooo00<0I_ooooooool0?_ooo`009?ooo`0306Ko
oooooooo07[oool406Ko0_ooo`030000oooooooo017oool506Ko8?ooo`0306Kooooooooo03goool0
02;oool206KoPOooo`80I_l2000000<0I_ooooooool02Oooo`H0I_lVoooo0P1Vocgoool001Soool2
00001oooo`0306Kooooooooo02Coool40000;?ooo`D0000Zoooo00<0003oool0I_l02`1Vob3oool5
00002Oooo`80I_lQoooo100001Koool001Ooool010000?ooooooo`0000Goool00`1Vooooooooo`0U
oooo00<0003oooooool0;oooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0003ooooo
ool02oooo`80I_lOoooo00<0003oooooool05oooo`006Oooo`030000oooooooo00?oool00`1Voooo
ooooo`0Woooo00<0003oooooool0;_ooo`030000oooooooo02[oool00`000?ooooooo`0]oooo00<0
003oooooool03Oooo`80I_lNoooo00<0003oooooool05_ooo`004Oooo`@00005oooo00D0003ooooo
ooooool0I_l08oooo`@00004oooo00<0003oooooool09Oooo`@00004oooo00<0003oooooool0:_oo
o`030000oooooooo02goool00`000?ooooooo`0?oooo0`1Voacoool00`000?ooooooo`0Eoooo000G
oooo00@0003oooooool00002oooo00<0I_ooooooool0:?ooo`040000oooooooo0000;_ooo`030000
oooooooo02[oool00`000?ooooooo`0]oooo00<0003oooooool04_ooo`<0I_lGoooo00@0003ooooo
ool0000Foooo000Hoooo0P0000;oool00`1Vooooooooo`0Zoooo0P0002koool20000;?ooo`80000]
oooo0P0001Ooool406Ko5?ooo`80000Goooo000Koooo00<0I_ooooooool0ROooo`030000oooooooo
04Woool506Ko:?ooo`006_ooo`0306Kooooooooo08[oool00`000?ooooooo`1>oooo1@1Vob?oool0
01Woool00`1Vooooooooo`2;oooo00<0003oooooool0Doooo`L0I_lLoooo000Hoooo00<0I_oooooo
ool0S?ooo`030000oooooooo05[oool506Ko5oooo`005oooo`0306Kooooooooo08goool00`000?oo
ooooo`1foooo000@ooooo`00017oool001Koool00`000?ooooooo`07oooo00<0003oooooool01ooo
o`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?oo
ooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01_ooo`030000oooooooo00Ooool00`0003?o03?o0007<ol000<0000co`0co`001S?o
00030000<ol0<ol000Lco`000`0003?o03?o0007<ol000<0000co`0co`001S?o00030000<ol0<ol0
00Dco`0J00001Oooo`030000oooooooo00Ooool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool0;_ooo`030000oooooooo02goool00`000?ooooooo`0]oooo00<0000co`0co`00;C?o00P0000Y
oooo00<0003oooooool05Oooo`00Yoooo`030000<ol0<ol002Xco`030000BOooo`00Yoooo`030000
<ol0<ol002Hco`040000C?ooo`00Yoooo`030000<ol0<ol002@co`020000D?ooo`00Yoooo`030000
<ol0<ol002<co`000`000?ooooooo`1@oooo002Woooo0P00028co`020000Doooo`00Yoooo`030000
<ol0<ol001lco`020000EOooo`00Yoooo`030000<ol0<ol001hco`000`000?ooooooo`1Eoooo002W
oooo00<0000co`0co`007C?o00030000oooooooo05Koool00:Ooool00`0003?o03?o000L<ol000<0
003oooooool0Eoooo`00Yoooo`030000<ol0<ol001/co`000`000?ooooooo`1Hoooo002Woooo0P00
01`co`000`000?ooooooo`1Hoooo002Woooo00<0000co`0co`006S?o00030000oooooooo05Woool0
0:Ooool00`0003?o03?o000I<ol000<0003oooooool0F_ooo`00Yoooo`030000<ol0<ol001Pco`00
0`000?ooooooo`1Koooo002Woooo00<0000co`0co`005c?o00030000oooooooo05coool00:Ooool0
0`0003?o03?o000F<ol000<0003oooooool0GOooo`00Yoooo`80000G<ol000<0003oooooool0GOoo
o`00Yoooo`030000<ol0<ol001Dco`000`000?ooooooo`1Noooo002Woooo00<0000co`0co`005C?o
00030000oooooooo05koool00:Ooool00`0003?o03?o000E<ol000<0003oooooool0G_ooo`00Yooo
o`030000<ol0<ol001@co`000`000?ooooooo`1Ooooo002Woooo00<0000co`0co`0053?o00030000
oooooooo05ooool00:Ooool2000053?o00030000oooooooo063oool00:Ooool00`0003?o03?o000C
<ol000<0003oooooool0H?ooo`00Yoooo`030000<ol0<ol001<co`000`000?ooooooo`1Poooo002W
oooo00<0000co`0co`004S?o00030000oooooooo067oool00:Ooool00`0003?o03?o000B<ol000<0
003oooooool0HOooo`00Woooo`D00003oooo00<0000co`0co`004C?o00030000oooooooo06;oool0
0:7oool00`000?ooooooo`03oooo00<0000co`0co`004C?o00030000oooooooo06;oool00:7oool0
0`000?ooooooo`03oooo0`00014co`000`000?ooooooo`1Roooo002Qoooo00<0003oooooool00ooo
o`030000<ol0<ol0010co`000`000?ooooooo`1Soooo002Qoooo00<0003oooooool00oooo`030000
<ol0<ol0010co`000`000?ooooooo`1Soooo002Poooo0P0000Goool00`0003?o03?o000@<ol000<0
003oooooool0Hoooo`00Yoooo`030000<ol0<ol0010co`000`000?ooooooo`1Soooo002Woooo00<0
000co`0co`003c?o00030000oooooooo06Coool00:Ooool2000043?o00030000oooooooo06Coool0
0:Ooool00`0003?o03?o000?<ol000<0003oooooool0I?ooo`00Yoooo`030000<ol0<ol000lco`00
0`000?ooooooo`1Toooo002Woooo00<0000co`0co`003S?o00030000oooooooo06Goool00:Ooool0
0`0003?o03?o000><ol000<0003oooooool0IOooo`00Yoooo`030000<ol0<ol000hco`000`000?oo
ooooo`1Uoooo002Woooo0P0000lco`000`000?ooooooo`1Uoooo002Woooo00<0000co`0co`003C?o
00030000oooooooo06Koool00:Ooool00`0003?o03?o000=<ol000<0003oooooool0I_ooo`00Yooo
o`030000<ol0<ol000dco`000`000?ooooooo`1Voooo002Woooo00<0000co`0co`003C?o00030000
oooooooo06Koool00:Ooool00`0003?o03?o000<<ol000<0003oooooool0Ioooo`00Yoooo`030000
<ol0<ol000`co`000`000?ooooooo`1Woooo002Woooo0P0000dco`000`000?ooooooo`1Woooo002W
oooo00<0000co`0co`0033?o00030000oooooooo06Ooool00:Ooool00`0003?o03?o000;<ol000<0
003oooooool0J?ooo`00Yoooo`030000<ol0<ol000/co`000`000?ooooooo`1Xoooo002Woooo00<0
000co`0co`002c?o00030000oooooooo06Soool00:Ooool00`0003?o03?o000;<ol000<0003ooooo
ool0J?ooo`00Yoooo`80000<<ol000<0003oooooool0J?ooo`00Yoooo`030000<ol0<ol000Xco`00
0`000?ooooooo`1Yoooo002Woooo00<0000co`0co`002S?o00030000oooooooo06Woool00:Ooool0
0`0003?o03?o000:<ol000<0003oooooool0JOooo`00Woooo`@00004oooo00<0000co`0co`002S?o
00030000oooooooo06Woool009ooool00`000?ooooooo`05oooo00<0000co`0co`002S?o00030000
oooooooo06Woool00:3oool00`000?ooooooo`04oooo0`0000Xco`000`000?ooooooo`1Yoooo002Q
oooo00<0003oooooool00oooo`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo002Ooooo00@0
003oooooool00004oooo00<0000co`0co`002C?o00030000oooooooo06[oool00:3oool200001Ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`1Zoooo002Woooo00<0000co`0co`002C?o00030000
oooooooo06[oool00:Ooool00`0003?o03?o0009<ol000<0003oooooool0J_ooo`00Yoooo`80000:
<ol000<0003oooooool0J_ooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo002W
oooo00<0000co`0co`0023?o00030000oooooooo06_oool00:Ooool00`0003?o03?o0008<ol000<0
003oooooool0Joooo`00Yoooo`030000<ol0<ol000Pco`000`000?ooooooo`1[oooo002Woooo00<0
000co`0co`0023?o00030000oooooooo06_oool00:Ooool00`0003?o03?o0008<ol000<0003ooooo
ool0Joooo`00Yoooo`800009<ol000<0003oooooool0Joooo`00Yoooo`030000<ol0<ol000Pco`00
0`000?ooooooo`1[oooo002Woooo00<0000co`0co`001c?o00030000oooooooo06coool00:Ooool0
0`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yoooo`030000<ol0<ol000Lco`000`000?oo
ooooo`1/oooo002Woooo00<0000co`0co`001c?o00030000oooooooo06coool00:Ooool2000023?o
00030000oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yooo
o`030000<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo00<0000co`0co`001c?o00030000
oooooooo06coool00:Ooool00`0003?o03?o0007<ol000<0003oooooool0K?ooo`00Yoooo`030000
<ol0<ol000Lco`000`000?ooooooo`1/oooo002Woooo0P0000Lco`000`000?ooooooo`1]oooo002W
oooo00<0000co`0co`001S?o00030000oooooooo06goool00:Ooool00`0003?o03?o0006<ol000<0
003oooooool0KOooo`00Yoooo`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002Poooo0P00
00Goool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00Woooo`040000oooooooo00001?oo
o`030000<ol0<ol000Hco`000`000?ooooooo`1]oooo002Qoooo00<0003oooooool00oooo`<00006
<ol000<0003oooooool0KOooo`00X_ooo`030000oooooooo00;oool00`0003?o03?o0006<ol000<0
003oooooool0KOooo`00Woooo`040000oooooooo00001?ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1]oooo002Poooo0P0000Goool00`0003?o03?o0006<ol000<0003oooooool0KOooo`00Yooo
o`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002Woooo00<0000co`0co`001C?o00030000
oooooooo06koool00:Ooool00`0003?o03?o0005<ol000<0003oooooool0K_ooo`00Yoooo`800006
<ol000<0003oooooool0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002W
oooo00<0000co`0co`001C?o00030000oooooooo06koool00:Ooool00`0003?o03?o0005<ol000<0
003oooooool0K_ooo`00Yoooo`030000<ol0<ol000Dco`000`000?ooooooo`1^oooo002Woooo00<0
000co`0co`001C?o00030000oooooooo06koool00:Ooool200001S?o00030000oooooooo06koool0
0:Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yoooo`030000<ol0<ol000@co`00
0`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o00030000oooooooo06ooool00:Ooool0
0`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yoooo`030000<ol0<ol000@co`000`000?oo
ooooo`1_oooo002Woooo0P0000Dco`000`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o
00030000oooooooo06ooool00:Ooool00`0003?o03?o0004<ol000<0003oooooool0Koooo`00Yooo
o`030000<ol0<ol000@co`000`000?ooooooo`1_oooo002Woooo00<0000co`0co`0013?o00030000
oooooooo06ooool00:Ooool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00Yoooo`800004
<ol000<0003oooooool0L?ooo`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002W
oooo00<0000co`0co`000c?o00030000oooooooo073oool00:Ooool00`0003?o03?o0003<ol000<0
003oooooool0L?ooo`00Yoooo`030000<ol0<ol000<co`000`000?ooooooo`1`oooo002Qoooo0`00
00?oool00`0003?o03?o0003<ol000<0003oooooool0L?ooo`00X_ooo`030000oooooooo00;oool0
0`0003?o03?o0003<ol000<0003oooooool0L?ooo`00Woooo`D00003oooo0`0000<co`000`000?oo
ooooo`1`oooo002Ooooo00@0003oooooool00004oooo1S?o07?oool00:3oool00`000?ooo`000004
oooo1S?o07?oool00:7oool200001?ooo`Hco`1coooo002Woooo1S?o07?oool00:Ooool6<ol0Looo
o`00Ooooo`030000oooooooo01coool00`000?ooooooo`06oooo1S?o07?oool007koool00`000?oo
ooooo`08oooo00<0003oooooool04oooo`030000oooooooo00Goool6<ol0Loooo`00O_ooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00Koool400000oooo`800004oooo00<0003ooooo
ool01Oooo`Hco`1coooo001noooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`05oooo00<0003oooooool02_ooo`030000oooooooo00Goool6<ol0Loooo`00OOoo
o`030000oooooooo00;oool00`000?ooooooo`0>oooo00<0003oooooool02_ooo`030000oooooooo
00Coool6<ol0Loooo`00O_ooo`030000oooooooo00D0000>oooo00<0003oooooool02?ooo`030000
oooooooo00Goool6<ol0Loooo`00O_ooo`050000oooooooooooo000000ooool010000?ooooooo`00
00Woool00`000?ooooooo`05oooo1S?o07?oool007ooool00`000?ooooooo`0Aoooo0P0000Woool0
0`000?ooooooo`06oooo1S?o07?oool00:Ooool6<ol0Loooo`00Yoooo`Hco`1coooo0000\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {353.188, 211.875}} -> {-0.349561, \
1.49934, 0.00349883, 0.00566123}, {{79.875, 308.563}, {353.188, 211.875}} -> \
{-5.53614, 7.32223, 0.0207442, 0.0319664}, {{79.875, 308.563}, {353.188, \
211.875}} -> {-5.53614, 7.32223, 0.0207442, 0.0319664}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-1\), \ 
              2}, \ PlotRange -> {\(-1\), 1}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-1\), \ 2}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-1\), 
                1}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-1\), \ 2}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-1\), 
                1}]}, \[IndentingNewLine]\ {t, \ \(- .2\), \  .2,  .01}, 
        PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.55838 .30902 L
.57861 .30902 L
.58392 .30902 L
.58957 .30902 L
.59232 .30902 L
.59367 .30902 L
.59491 .30902 L
s
.59491 .30902 m
.59502 .61803 L
s
0 .4 1 r
.02381 .40859 m
.04262 .43045 L
.06244 .45054 L
.07216 .45939 L
.0775 .464 L
.08255 .4682 L
.08542 .47052 L
.0862 .47114 L
.08703 .4718 L
.08774 .47151 L
.08852 .47061 L
.09396 .46449 L
.10458 .45317 L
.14487 .41713 L
.18364 .39074 L
.22486 .36937 L
.26457 .35365 L
.30277 .34185 L
.32408 .33636 L
.34341 .33192 L
.38254 .32526 L
.40179 .32291 L
.42261 .32082 L
.46361 .31767 L
.5031 .3155 L
.54107 .31395 L
.56221 .31325 L
.58149 .31271 L
.58613 .31259 L
.59106 .31247 L
.59363 .3124 L
.59434 .31239 L
.5951 .31237 L
.59581 .30902 L
.59647 .30902 L
.59764 .30902 L
.59891 .30902 L
.59955 .30902 L
.60024 .30902 L
.60147 .30902 L
.60267 .30902 L
.60395 .30902 L
.60515 .30902 L
.60626 .30902 L
.60749 .30902 L
.60867 .30902 L
.60994 .30902 L
.61066 .30902 L
.61132 .30902 L
.61251 .30902 L
Mistroke
.61363 .30902 L
.61463 .30902 L
.61572 .30902 L
.61691 .30902 L
.61816 .30902 L
.61923 .30902 L
.6204 .30902 L
.62109 .30902 L
.62174 .30902 L
.62296 .30902 L
.62428 .30902 L
.62502 .30902 L
.6257 .30902 L
.62684 .30902 L
.6281 .30902 L
.62941 .30902 L
.63064 .30902 L
.63129 .30902 L
.63201 .30902 L
.63275 .30902 L
.63344 .30902 L
.63467 .30902 L
.63599 .30902 L
.63674 .30902 L
.63754 .30902 L
.63831 .30902 L
.63901 .30902 L
.6397 .30902 L
.64034 .30902 L
.64101 .30902 L
.64175 .30902 L
.643 .30902 L
.6437 .30902 L
.64436 .30902 L
.64556 .30902 L
.64683 .30902 L
.65147 .30902 L
.6527 .30902 L
.65339 .30902 L
.65402 .30902 L
.65519 .30902 L
.65643 .30902 L
.65708 .30902 L
.65778 .30902 L
.65904 .30902 L
.65981 .30902 L
.66054 .30902 L
.66119 .30902 L
.6619 .30902 L
.66313 .30902 L
Mistroke
.66425 .30902 L
.66555 .30902 L
.66678 .30902 L
.66791 .30902 L
.66896 .30902 L
.67012 .30902 L
.67135 .30902 L
.67205 .30902 L
.6727 .30902 L
.67341 .30902 L
.67416 .30902 L
.67542 .30902 L
.67614 .30902 L
.67681 .30902 L
.67806 .30902 L
.67919 .30902 L
.68051 .30902 L
.68175 .30902 L
.68296 .30902 L
.68365 .30902 L
.68429 .30902 L
.68559 .30902 L
.68632 .30902 L
.68699 .30902 L
.68811 .30902 L
.68935 .30902 L
.69063 .30902 L
.69183 .30902 L
.69252 .30902 L
.69326 .30902 L
.69396 .30902 L
.69461 .30902 L
.69583 .30902 L
.69713 .30902 L
.6978 .30902 L
.69852 .30902 L
.69982 .30902 L
.70062 .30902 L
.70137 .30902 L
.70205 .30902 L
.70279 .30902 L
.70344 .30902 L
.70412 .30902 L
.70535 .30902 L
.70667 .30902 L
.70742 .30902 L
.70812 .30902 L
.70939 .30902 L
.71055 .30902 L
.71119 .30902 L
Mistroke
.71188 .30902 L
.71314 .30902 L
.71427 .30902 L
.71551 .30902 L
.7168 .30902 L
.71801 .30902 L
.71914 .30902 L
.72018 .30902 L
.72138 .30902 L
.72251 .30902 L
.72383 .30902 L
.72503 .30902 L
.72569 .30902 L
.72641 .30902 L
.72772 .30902 L
.72894 .30902 L
.73023 .30902 L
.73134 .30902 L
.73255 .30902 L
.73328 .30902 L
.73398 .30902 L
.73528 .30902 L
.73601 .30902 L
.73669 .30902 L
.73743 .30902 L
.73821 .30902 L
.73951 .30902 L
.74073 .30902 L
.74142 .30902 L
.74206 .30902 L
.74276 .30902 L
.7435 .30902 L
.74474 .30902 L
.74543 .30902 L
.74607 .30902 L
.74725 .30902 L
.7485 .30902 L
.74962 .30902 L
.75066 .30902 L
.7518 .30902 L
.75304 .30902 L
.75436 .30902 L
.75561 .30902 L
.75683 .30902 L
.75796 .30902 L
.75865 .30902 L
.7593 .30902 L
.76051 .30902 L
.76182 .30902 L
.76256 .30902 L
Mistroke
.76324 .30902 L
.7643 .30902 L
.76544 .30902 L
.76652 .30902 L
.7675 .30902 L
.76865 .30902 L
.7699 .30902 L
.77108 .30902 L
.77217 .30902 L
.77329 .30902 L
.77435 .30902 L
.7755 .30902 L
.77675 .30902 L
.77805 .30902 L
.77929 .30902 L
.7804 .30902 L
.7816 .30902 L
.78285 .30902 L
.784 .30902 L
.78525 .30902 L
.78657 .30902 L
.78771 .30902 L
.78877 .30902 L
.78994 .30902 L
.79119 .30902 L
.79189 .30902 L
.79254 .30902 L
.79325 .30902 L
.794 .30902 L
.79527 .30902 L
.79599 .30902 L
.79667 .30902 L
.79792 .30902 L
.79907 .30902 L
.80034 .30902 L
.80097 .30902 L
.80167 .30902 L
.80235 .30902 L
.80309 .30902 L
.80379 .30902 L
.80444 .30902 L
.80566 .30902 L
.80695 .30902 L
.80762 .30902 L
.80834 .30902 L
.80964 .30902 L
.81043 .30902 L
.81119 .30902 L
.81186 .30902 L
.8126 .30902 L
Mistroke
.81329 .30902 L
.81394 .30902 L
.81516 .30902 L
.81646 .30902 L
.8172 .30902 L
.81788 .30902 L
.81902 .30902 L
.82026 .30902 L
.82156 .30902 L
.82278 .30902 L
.82404 .30902 L
.82468 .30902 L
.82538 .30902 L
.82662 .30902 L
.82779 .30902 L
.82845 .30902 L
.82916 .30902 L
.83041 .30902 L
.83111 .30902 L
.83176 .30902 L
.83247 .30902 L
.83324 .30902 L
.83452 .30902 L
.83524 .30902 L
.8359 .30902 L
.83713 .30902 L
.83842 .30902 L
.83958 .30902 L
.84067 .30902 L
.84186 .30902 L
.84314 .30902 L
.84437 .30902 L
.84552 .30902 L
.84678 .30902 L
.84748 .30902 L
.84811 .30902 L
.84928 .30902 L
.85055 .30902 L
.85174 .30902 L
.85284 .30902 L
.8539 .30902 L
.85489 .30902 L
.85598 .30902 L
.85715 .30902 L
.85837 .30902 L
.85953 .30902 L
.86057 .30902 L
.8617 .30902 L
.86292 .30902 L
.86404 .30902 L
Mistroke
.86533 .30902 L
.86656 .30902 L
.86769 .30902 L
.86874 .30902 L
.86989 .30902 L
.87112 .30902 L
.87183 .30902 L
.87247 .30902 L
.87318 .30902 L
.87393 .30902 L
.87519 .30902 L
.8759 .30902 L
.87657 .30902 L
.87782 .30902 L
.87896 .30902 L
.88027 .30902 L
.88151 .30902 L
.88272 .30902 L
.8834 .30902 L
.88405 .30902 L
.88534 .30902 L
.88607 .30902 L
.88674 .30902 L
.88787 .30902 L
.8891 .30902 L
.89038 .30902 L
.89158 .30902 L
.89227 .30902 L
.89301 .30902 L
.89371 .30902 L
.89435 .30902 L
.89558 .30902 L
.89688 .30902 L
.89755 .30902 L
.89827 .30902 L
.89957 .30902 L
.90037 .30902 L
.90112 .30902 L
.9018 .30902 L
.90254 .30902 L
.90319 .30902 L
.90387 .30902 L
.9051 .30902 L
.90641 .30902 L
.90716 .30902 L
.90786 .30902 L
.90913 .30902 L
.91028 .30902 L
.91092 .30902 L
.91161 .30902 L
Mistroke
.91287 .30902 L
.91399 .30902 L
.91523 .30902 L
.91652 .30902 L
.91773 .30902 L
.91877 .30902 L
.91988 .30902 L
.9211 .30902 L
.92223 .30902 L
.92292 .30902 L
.92358 .30902 L
.9248 .30902 L
.9261 .30902 L
.92683 .30902 L
.9275 .30902 L
.92862 .30902 L
.92985 .30902 L
.93113 .30902 L
.93233 .30902 L
.93363 .30902 L
.93485 .30902 L
.93553 .30902 L
.93626 .30902 L
.93754 .30902 L
.93829 .30902 L
.93907 .30902 L
.93975 .30902 L
.94048 .30902 L
.94117 .30902 L
.9419 .30902 L
.94321 .30902 L
.94435 .30902 L
.94559 .30902 L
.94676 .30902 L
.94784 .30902 L
.94882 .30902 L
.94989 .30902 L
.95101 .30902 L
.95206 .30902 L
.95314 .30902 L
.95417 .30902 L
.95509 .30902 L
.9561 .30902 L
.95719 .30902 L
.95836 .30902 L
.95945 .30902 L
.96045 .30902 L
.96144 .30902 L
.96248 .30902 L
.96337 .30902 L
Mistroke
.96434 .30902 L
.96539 .30902 L
.96652 .30902 L
.96758 .30902 L
.96855 .30902 L
.96953 .30902 L
.97043 .30902 L
.97142 .30902 L
.97248 .30902 L
.97339 .30902 L
.97424 .30902 L
.97518 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00<co`0206Ko00<00000I_l0I_l01@1Vo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0
000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`000c?o
02`00007oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Goool00`000?ooooooo`0V
oooo00<0000co`0co`008S?o00<0I_l00`00001Vo`1Vo`0;06Ko2S?o0003o`2I<ol0<ol000dco`00
0`0003?o03?o000A<ol02P0000[oool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00Iooo
o`030000<ol0<ol000lco`0C06Ko6c?o0003o`2I<ol0<ol001Lco`0:0000EOooo`00Ioooo`80000;
<ol01@1Vobhco`000ol0VC?o03?o000A<ol01P0005ooool006Ooool00`0003?o03?o0003<ol01`1V
oc<co`000ol0VC?o03?o000=<ol0100006Goool006Goool206Ko00<00000I_l0I_l00`1VocXco`00
0ol0VC?o03?o000;<ol00P0006Woool0067oool406Ko0_ooo`030000<ol0<ol003dco`000ol0VC?o
03?o0008<ol00`0006_oool005ooool206Ko1_ooo`80000n<ol000?o09Tco`0co`001S?o0080001^
oooo001Loooo0`1Vo`Soool00`0003?o03?o000m<ol000?o09Tco`0co`0013?o0080001`oooo001I
oooo0`1Vo`_oool00`0003?o03?o000m<ol000?o09Tco`0co`000S?o0080001boooo001Eoooo101V
o`koool00`0003?o03?o000m<ol000?o09Tco`0co`000P0007Coool005;oool306Ko4_ooo`80000n
<ol000?o09Tco`000000M_ooo`00D?ooo`80I_lEoooo00<0000co`0co`00?C?o0003o`2I0000oooo
07Koool004goool306Ko5oooo`030000<ol0<ol003`co`000`000?l0VOooo`1goooo001;oooo0P1V
oa[oool00`0003?o03?o000k<ol000<0003ooooo09T0N?ooo`00BOooo`80I_lLoooo0P0003/co`00
10000?ooooooool0VGSoool004Ooool206Ko7_ooo`030000<ol0<ol003Tco`001@000?oooooooooo
ool0V@1hoooo0015oooo0P1Vo`Ooool200001?ooo`800003oooo100000?oool200001Oooo`030000
<ol0<ol003Lco`0200001?ooo`03o`2Ioooooooo07Koool004?oool206Ko2?ooo`040000oooooooo
00002?ooo`030000oooooooo00?oool010000?ooooooo`0000Coool00`0003?o03?o000f<ol000<0
003oooooool01?ooo`03o`2Ioooooooo07Koool0047oool206Ko2_ooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool00`000?ooooooo`02oooo0P0003Hco`000`000?ooooooo`05oooo00?o
09Woooooool0M_ooo`00?oooo`80I_l<oooo00@0003oooooool0000:oooo00<0003oooooool00_oo
o`800005oooo00<0000co`0co`00=3?o00030000oooooooo00Koool00ol0VOooooooo`1foooo000m
oooo0P1Vo`koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`04
oooo00<0000co`0co`00=3?o00030000oooooooo00Koool00ol0VOooooooo`1foooo000loooo00<0
I_ooooooool03oooo`80000:oooo0P0000Coool300001?ooo`030000<ol0<ol003<co`000`000?oo
ooooo`07oooo00?o09Woooooool0M_ooo`00>oooo`0306Kooooooooo02Woool20000<c?o00030000
oooooooo00Soool00ol0VOooooooo`1foooo000ioooo0P1Vobcoool00`0003?o03?o000a<ol000<0
003oooooool02Oooo`03o`2Ioooooooo07Koool001Koool00`1Vooooooooo`0Ooooo00<0I_oooooo
ool0;?ooo`030000<ol0<ol0034co`000`000?ooooooo`09oooo00?o09Woooooool0M_ooo`005ooo
o`0306Kooooooooo01coool206Ko;oooo`030000<ol0<ol0030co`000`000?ooooooo`0:oooo00?o
09Woooooool0M_ooo`006?ooo`0306Kooooooooo01[oool00`1Vooooooooo`0_oooo0P00030co`00
0`000?ooooooo`0;oooo00?o09Woooooool0M_ooo`006Oooo`0306Kooooooooo01Soool00`1Voooo
ooooo`0`oooo00<0000co`0co`00;c?o00030000oooooooo00_oool00ol0VOooooooo`1foooo000J
oooo00<0I_ooooooool05_ooo`0306Kooooooooo037oool00`0003?o03?o000^<ol000<0003ooooo
ool03?ooo`03o`2Ioooooooo07Koool001_oool00`1Vooooooooo`0Doooo00<0I_ooooooool0<_oo
o`030000<ol0<ol002hco`000`000?ooooooo`0<oooo00?o09Woooooool0M_ooo`007?ooo`0306Ko
oooooooo01;oool00`1Vooooooooo`0coooo0P0002hco`000`000?ooooooo`0=oooo00?o09Wooooo
ool0M_ooo`007Oooo`0306Kooooooooo00ooool206Ko=_ooo`030000<ol0<ol002dco`000`000?oo
ooooo`0=oooo00?o09Woooooool0M_ooo`007_ooo`0306Kooooooooo00goool00`1Vooooooooo`0f
oooo00<0000co`0co`00;3?o00030000oooooooo00koool00ol0VOooooooo`1foooo000Ooooo00<0
I_ooooooool02oooo`0306Kooooooooo03Ooool00`0003?o03?o000/<ol000<0003oooooool03_oo
o`03o`2Ioooooooo07Koool0023oool00`1Vooooooooo`09oooo00<0I_ooooooool0>?ooo`80000/
<ol000<0003oooooool03oooo`03o`2Ioooooooo07Koool0027oool00`1Vooooooooo`07oooo00<0
I_ooooooool0>Oooo`030000<ol0<ol002/co`000`000?ooooooo`0?oooo00?o09Woooooool0M_oo
o`008Oooo`0306Kooooooooo00Koool00`1Vooooooooo`0Woooo0P0000Coool200001?ooo`800005
oooo00<0000co`0co`00:S?o00030000oooooooo013oool00ol0VOooooooo`1foooo000Roooo00<0
I_ooooooool01?ooo`0306Kooooooooo02Ooool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`0003?o03?o000Z<ol000<0003oooooool04?ooo`03o`2Ioooooooo07Koool002?oool2
06Ko0oooo`0306Kooooooooo02Soool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
02Xco`000`000?ooooooo`0Aoooo00?o09Woooooool0M_ooo`009Oooo`<0I_l[oooo00@0003ooooo
ool00009oooo0P0000Goool00`0003?o03?o000Y<ol000<0003oooooool04Oooo`03o`2Ioooooooo
07Koool002Koool00`1Vooooooooo`0Zoooo00@0003oooooool00009oooo00<0003oooooool01?oo
o`030000<ol0<ol002Pco`000`000?ooooooo`0Boooo00?o09Woooooool0M_ooo`00E?ooo`80000:
oooo0`0000Coool00`0003?o03?o000X<ol000<0003oooooool04_ooo`03o`2Ioooooooo07Koool0
06Ooool20000:C?o00030000oooooooo01;oool00ol0VOooooooo`1foooo001Woooo00<0000co`0c
o`009c?o00030000oooooooo01?oool00ol0VOooooooo`1foooo001Woooo00<0000co`0co`009c?o
00030000oooooooo01?oool00ol0VOooooooo`1foooo001Woooo0P0002Lco`000`000?ooooooo`0D
oooo00?o09Woooooool0M_ooo`00Ioooo`030000<ol0<ol002Hco`000`000?ooooooo`0Doooo00?o
09Woooooool0M_ooo`00Ioooo`030000<ol0<ol002Hco`000`000?ooooooo`0Doooo00?o09Wooooo
ool0M_ooo`00Ioooo`030000<ol0<ol002Dco`000`000?ooooooo`0Eoooo00?o09Woooooool0M_oo
o`00Ioooo`80000V<ol000<0003oooooool05Oooo`03o`2Ioooooooo07Koool006Ooool00`0003?o
03?o000U<ol000<0003oooooool05Oooo`03o`2Ioooooooo07Koool006Ooool00`0003?o03?o000U
<ol000<0003oooooool05Oooo`03o`2Ioooooooo07Koool006Ooool00`0003?o03?o000T<ol000<0
003oooooool05_ooo`03o`2Ioooooooo07Koool006Ooool200009C?o00030000oooooooo01Koool0
0ol0VOooooooo`1foooo001Woooo00<0000co`0co`0093?o00030000oooooooo01Koool00ol0VOoo
ooooo`1foooo001>oooo0P0000Coool200001Oooo`030000oooooooo00;oool200001Oooo`030000
<ol0<ol002<co`000`000?ooooooo`0Goooo00?o09Woooooool0M_ooo`00COooo`040000oooooooo
00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0000co`0co`008c?o
00030000oooooooo01Ooool00ol0VOooooooo`1foooo001=oooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo00;oool2000093?o00030000oooooooo01Ooool00ol0VOoo
ooooo`1foooo001=oooo00@0003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000
<ol0<ol0028co`000`000?ooooooo`0Hoooo00?o09Woooooool0M_ooo`00COooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`030000oooooooo00Coool00`0003?o03?o000R<ol000<0
003oooooool06?ooo`03o`2Ioooooooo07Koool004koool200002Oooo`@00003oooo0`0000Coool0
0`0003?o03?o000R<ol000<0003oooooool06?ooo`03o`2Ioooooooo07Koool006Ooool200008c?o
00030000oooooooo01Soool00ol0VOooooooo`1foooo001Woooo00<0000co`0co`008C?o00030000
oooooooo01Woool00ol0VOooooooo`1foooo001Woooo00<0000co`0co`008C?o00030000oooooooo
01Woool00ol0VOooooooo`1foooo001Woooo00<0000co`0co`008C?o00030000oooooooo01Woool0
0ol0VOooooooo`1foooo001Woooo0P00028co`000`000?ooooooo`0Ioooo00?o09Woooooool0M_oo
o`00Ioooo`030000<ol0<ol0020co`000`000?ooooooo`0Joooo00?o09Woooooool0M_ooo`00Iooo
o`030000<ol0<ol0020co`000`000?ooooooo`0Joooo00?o09Woooooool0M_ooo`00Ioooo`030000
<ol0<ol0020co`000`000?ooooooo`0Joooo00?o09Woooooool0M_ooo`00Ioooo`80000Q<ol000<0
003oooooool06_ooo`03o`2Ioooooooo07Koool006Ooool00`0003?o03?o000O<ol000<0003ooooo
ool06oooo`03o`2Ioooooooo07Koool006Ooool00`0003?o03?o000O<ol000<0003oooooool06ooo
o`03o`2Ioooooooo07Koool006Ooool00`0003?o03?o000O<ol000<0003oooooool06oooo`03o`2I
oooooooo07Koool006Ooool2000083?o00030000oooooooo01_oool00ol0VOooooooo`1foooo001W
oooo00<0000co`0co`007c?o00030000oooooooo01_oool00ol0VOooooooo`1foooo001Ooooo1@00
00?oool00`0003?o03?o000N<ol000<0003oooooool07?ooo`03o`2Ioooooooo07Koool0067oool0
0`000?ooooooo`03oooo00<0000co`0co`007S?o00030000oooooooo01coool00ol0VOooooooo`1f
oooo001Qoooo00<0003oooooool00oooo`80000O<ol000<0003oooooool07?ooo`03o`2Ioooooooo
07Koool0067oool00`000?ooooooo`03oooo8C?o09Soool0067oool00`000?ooooooo`03oooo8C?o
09Soool0063oool200001Oooob4co`2Hoooo001Woooo83?o09Woool006OooolP<ol0VOooo`00Iooo
oa8co`000`0003?o03?o000;<ol07Oooo`030000oooooooo07Woool006OooolA<ol000<0000co`0c
o`0023?o00040000<ol0<ol0<ol07_ooo`030000oooooooo07Soool006OooolA<ol000<0000co`0c
o`000S?o00800004<ol000<0000co`0co`003Oooo`800004oooo0P0000?oool400000oooo`030000
oooooooo07Soool006OooolA<ol000D0000co`0co`0co`0000000S?o00030000<ol0<ol0008co`00
0`0003?o0?ooo`04oooo100000?oool010000?ooooooo`0000Soool00`000?ooooooo`04oooo00<0
003oooooool0N?ooo`00Iooooa0co`000`0003?o03?o0002<ol000<0000co`0co`001c?o00coool0
10000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool0Moooo`00Iooooa4co`00
0`0003?o03?o000500001S?o00coool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0
003oooooool0N?ooo`00Iooooa4co`001@0003?o03?o03?o00000009<ol03?ooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool006OooolB<ol000<0000co`0c
o`002S?o00goool200002_ooo`800003oooo00<0003oooooool0NOooo`00Iooooahco`2Koooo001W
oooo7S?o09_oool00001\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {524.438, 383.125}} -> {-0.349561, \
2.71119, 0.00349883, 0.00566123}, {{79.875, 308.563}, {524.438, 383.125}} -> \
{-2.52168, 5.06602, 0.0124465, 0.0127866}, {{79.875, 308.563}, {524.438, \
383.125}} -> {-2.52168, 5.06602, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.19) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.55838 .30902 L
.57861 .30902 L
.58392 .30902 L
.58957 .30902 L
.59232 .30902 L
.59491 .30902 L
.59604 .30902 L
.59723 .30902 L
s
.59723 .30902 m
.59736 .61803 L
s
0 .4 1 r
.02381 .4046 m
.04262 .42696 L
.06244 .44751 L
.07216 .45657 L
.0775 .46128 L
.08013 .46354 L
.08255 .46558 L
.08327 .46618 L
.08394 .46674 L
.08464 .46631 L
.08542 .46545 L
.08852 .46203 L
.09396 .45624 L
.10458 .44553 L
.14335 .41251 L
.18458 .38588 L
.22428 .36641 L
.26248 .35197 L
.30312 .34002 L
.34225 .33094 L
.36366 .32708 L
.38383 .32424 L
.42239 .32021 L
.44232 .31863 L
.46339 .31723 L
.50136 .31523 L
.54178 .31366 L
.56042 .31308 L
.58069 .31253 L
.58604 .3124 L
.59173 .31227 L
.59406 .31222 L
.59658 .31216 L
.59728 .31214 L
.59802 .31213 L
.59934 .30902 L
.60058 .30902 L
.60128 .30902 L
.60193 .30902 L
.60319 .30902 L
.6039 .30902 L
.60456 .30902 L
.60576 .30902 L
.60703 .30902 L
.60817 .30902 L
.60924 .30902 L
.61041 .30902 L
.61166 .30902 L
.61235 .30902 L
.61299 .30902 L
Mistroke
.6137 .30902 L
.61445 .30902 L
.61516 .30902 L
.61584 .30902 L
.61709 .30902 L
.61834 .30902 L
.61948 .30902 L
.62073 .30902 L
.62136 .30902 L
.62205 .30902 L
.62336 .30902 L
.62457 .30902 L
.62521 .30902 L
.6259 .30902 L
.62663 .30902 L
.62731 .30902 L
.62856 .30902 L
.62971 .30902 L
.63096 .30902 L
.63229 .30902 L
.6334 .30902 L
.63459 .30902 L
.63572 .30902 L
.63674 .30902 L
.63794 .30902 L
.63924 .30902 L
.64047 .30902 L
.6416 .30902 L
.64281 .30902 L
.64411 .30902 L
.64533 .30902 L
.64645 .30902 L
.64776 .30902 L
.6485 .30902 L
.64918 .30902 L
.65044 .30902 L
.65107 .30902 L
.65178 .30902 L
.65245 .30902 L
.65317 .30902 L
.65444 .30902 L
.65515 .30902 L
.65582 .30902 L
.65654 .30902 L
.65732 .30902 L
.65799 .30902 L
.65872 .30902 L
.65941 .30902 L
.66005 .30902 L
.66125 .30902 L
Mistroke
.66253 .30902 L
.66374 .30902 L
.66505 .30902 L
.6663 .30902 L
.66745 .30902 L
.67195 .30902 L
.67328 .30902 L
.67452 .30902 L
.67564 .30902 L
.67686 .30902 L
.67749 .30902 L
.67818 .30902 L
.6789 .30902 L
.67958 .30902 L
.68079 .30902 L
.68208 .30902 L
.68331 .30902 L
.68444 .30902 L
.68568 .30902 L
.687 .30902 L
.68814 .30902 L
.68921 .30902 L
.69039 .30902 L
.69166 .30902 L
.69272 .30902 L
.69388 .30902 L
.69509 .30902 L
.69621 .30902 L
.69727 .30902 L
.69823 .30902 L
.70039 .30902 L
.7016 .30902 L
.70289 .30902 L
.70412 .30902 L
.70524 .30902 L
.7065 .30902 L
.70769 .30902 L
.70897 .30902 L
.7097 .30902 L
.71038 .30902 L
.71158 .30902 L
.71272 .30902 L
.71374 .30902 L
.71484 .30902 L
.71604 .30902 L
.71731 .30902 L
.7184 .30902 L
.71959 .30902 L
.72026 .30902 L
.72099 .30902 L
Mistroke
.72167 .30902 L
.72231 .30902 L
.72351 .30902 L
.72479 .30902 L
.73035 .30902 L
.73153 .30902 L
.73265 .30902 L
.73395 .30902 L
.73513 .30902 L
.73643 .30902 L
.73716 .30902 L
.73784 .30902 L
.73907 .30902 L
.74039 .30902 L
.74163 .30902 L
.74233 .30902 L
.74299 .30902 L
.74368 .30902 L
.74432 .30902 L
.74505 .30902 L
.74574 .30902 L
.74697 .30902 L
.7481 .30902 L
.74934 .30902 L
.75067 .30902 L
.75198 .30902 L
.75272 .30902 L
.75339 .30902 L
.75464 .30902 L
.75595 .30902 L
.75665 .30902 L
.7574 .30902 L
.7581 .30902 L
.75874 .30902 L
.75949 .30902 L
.76031 .30902 L
.76108 .30902 L
.76179 .30902 L
.76295 .30902 L
.7642 .30902 L
.76538 .30902 L
.76645 .30902 L
.76771 .30902 L
.76842 .30902 L
.76909 .30902 L
.7703 .30902 L
.77158 .30902 L
.77229 .30902 L
.77293 .30902 L
.77364 .30902 L
Mistroke
.77439 .30902 L
.77565 .30902 L
.77636 .30902 L
.77703 .30902 L
.77827 .30902 L
.77941 .30902 L
.78072 .30902 L
.78196 .30902 L
.7831 .30902 L
.78433 .30902 L
.78549 .30902 L
.78656 .30902 L
.78774 .30902 L
.78903 .30902 L
.78968 .30902 L
.79038 .30902 L
.79163 .30902 L
.79228 .30902 L
.79296 .30902 L
.79371 .30902 L
.7944 .30902 L
.79565 .30902 L
.79635 .30902 L
.79701 .30902 L
.79824 .30902 L
.79937 .30902 L
.80067 .30902 L
.8019 .30902 L
.80295 .30902 L
.80412 .30902 L
.80525 .30902 L
.80648 .30902 L
.80762 .30902 L
.80866 .30902 L
.80967 .30902 L
.81072 .30902 L
.81187 .30902 L
.81309 .30902 L
.81425 .30902 L
.81531 .30902 L
.81654 .30902 L
.81724 .30902 L
.81789 .30902 L
.81907 .30902 L
.82033 .30902 L
.82153 .30902 L
.82285 .30902 L
.82409 .30902 L
.82524 .30902 L
.82639 .30902 L
Mistroke
.82742 .30902 L
.82855 .30902 L
.82974 .30902 L
.83105 .30902 L
.83225 .30902 L
.83354 .30902 L
.83427 .30902 L
.83496 .30902 L
.83617 .30902 L
.83733 .30902 L
.83796 .30902 L
.83866 .30902 L
.83987 .30902 L
.841 .30902 L
.84206 .30902 L
.84332 .30902 L
.84448 .30902 L
.84563 .30902 L
.84684 .30902 L
.84806 .30902 L
.84938 .30902 L
.85052 .30902 L
.85155 .30902 L
.85259 .30902 L
.85358 .30902 L
.85472 .30902 L
.85578 .30902 L
.85694 .30902 L
.85817 .30902 L
.85938 .30902 L
.8607 .30902 L
.86195 .30902 L
.8631 .30902 L
.86425 .30902 L
.86529 .30902 L
.86648 .30902 L
.86761 .30902 L
.86885 .30902 L
.87015 .30902 L
.87126 .30902 L
.87248 .30902 L
.8738 .30902 L
.87454 .30902 L
.87521 .30902 L
.87652 .30902 L
.87775 .30902 L
.8788 .30902 L
.87996 .30902 L
.88118 .30902 L
.88231 .30902 L
Mistroke
.88337 .30902 L
.88434 .30902 L
.88546 .30902 L
.88653 .30902 L
.88767 .30902 L
.88889 .30902 L
.88995 .30902 L
.89109 .30902 L
.89179 .30902 L
.89243 .30902 L
.8937 .30902 L
.89485 .30902 L
.89606 .30902 L
.89728 .30902 L
.89797 .30902 L
.89861 .30902 L
.89977 .30902 L
.90101 .30902 L
.90212 .30902 L
.90316 .30902 L
.9043 .30902 L
.90553 .30902 L
.90676 .30902 L
.90746 .30902 L
.90811 .30902 L
.90942 .30902 L
.9101 .30902 L
.91083 .30902 L
.91213 .30902 L
.91337 .30902 L
.91457 .30902 L
.91568 .30902 L
.91674 .30902 L
.91787 .30902 L
.91894 .30902 L
.91992 .30902 L
.92106 .30902 L
.92231 .30902 L
.92349 .30902 L
.92458 .30902 L
.92571 .30902 L
.92694 .30902 L
.92809 .30902 L
.92915 .30902 L
.93039 .30902 L
.9317 .30902 L
.9328 .30902 L
.93401 .30902 L
.93532 .30902 L
.93653 .30902 L
Mistroke
.93783 .30902 L
.93857 .30902 L
.93926 .30902 L
.94042 .30902 L
.94167 .30902 L
.94232 .30902 L
.94301 .30902 L
.94423 .30902 L
.94535 .30902 L
.94654 .30902 L
.94766 .30902 L
.94868 .30902 L
.94988 .30902 L
.95118 .30902 L
.95241 .30902 L
.95354 .30902 L
.95475 .30902 L
.95604 .30902 L
.95727 .30902 L
.95838 .30902 L
.95969 .30902 L
.96043 .30902 L
.96112 .30902 L
.96237 .30902 L
.96307 .30902 L
.96371 .30902 L
.96438 .30902 L
.9651 .30902 L
.96637 .30902 L
.96709 .30902 L
.96775 .30902 L
.96847 .30902 L
.96925 .30902 L
.96992 .30902 L
.97065 .30902 L
.97134 .30902 L
.97198 .30902 L
.97319 .30902 L
.97446 .30902 L
.97536 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.19) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00<co`0206Ko00<00000I_l0I_l01@1Vo`03000006Ko<ol000Dco`000`0003?o03?o0005<ol000<0
000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`000c?o
02`00007oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Goool00`000?ooooooo`0V
oooo00<0000co`0co`006S?o00/0I_l00`00001Vo`1Vo`0;06Ko2c?o0003o`2I<ol0<ol000`co`00
0`0003?o03?o000A<ol02P0000[oool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00Iooo
o`030000<ol0<ol000dco`0=06Ko93?o0003o`2I<ol0<ol001Hco`0:0000EOooo`00Ioooo`800007
<ol01`1Voc4co`000ol0VC?o03?o000@<ol01P0005ooool006Ooool00`0003?o03?o000606Ko>3?o
0003o`2I<ol0<ol000`co`040000IOooo`00IOooo`80I_l00`00001Vo`1Vo`0n<ol000?o09Tco`0c
o`002S?o0080001Yoooo001Poooo1@1Vo`;oool00`0003?o03?o000n<ol000?o09Tco`0co`001c?o
00<0001[oooo001Loooo101Vo`Ooool20000?c?o0003o`2I<ol0<ol000Dco`020000K_ooo`00FOoo
o`<0I_l;oooo00<0000co`0co`00?S?o0003o`2I<ol0<ol000<co`020000L?ooo`00EOooo`@0I_l>
oooo00<0000co`0co`00?S?o0004o`2I<ol0<ol0<ol00P0007;oool005;oool306Ko4_ooo`030000
<ol0<ol003hco`001?l0VC?o0000000007Coool0053oool206Ko5Oooo`80000o<ol000?o09T0003o
ool0MOooo`00COooo`<0I_lGoooo00<0000co`0co`00?S?o0003o`2Ioooooooo07Goool004_oool2
06Ko6_ooo`030000<ol0<ol003`co`02000000?o09Woooooool0MOooo`00BOooo`80I_lLoooo00<0
000co`0co`00>c?o00040000ooooooooo`2IMoooo`00Aoooo`80I_lNoooo0P0003/co`001@000?oo
ooooooooool0V@1goooo0015oooo0P1Vob3oool00`0003?o03?o000i<ol000<0003oooooool00_oo
o`03o`2Ioooooooo07Goool004?oool206Ko2Oooo`800004oooo0P0000?oool400000oooo`800005
oooo00<0000co`0co`00=c?o00800005oooo00?o09Woooooool0MOooo`00@Oooo`80I_l:oooo00@0
003oooooool00008oooo00<0003oooooool00oooo`040000oooooooo00001?ooo`030000<ol0<ol0
03Hco`000`000?ooooooo`05oooo00?o09Woooooool0MOooo`00?oooo`80I_l<oooo00@0003ooooo
ool00009oooo00<0003oooooool01Oooo`030000oooooooo00;oool20000=S?o00030000oooooooo
00Koool00ol0VOooooooo`1eoooo000moooo0P1Vo`koool010000?ooooooo`0000[oool00`000?oo
ooooo`02oooo0P0000Goool00`0003?o03?o000d<ol000<0003oooooool01oooo`03o`2Ioooooooo
07Goool003coool00`1Vooooooooo`0>oooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool01?ooo`030000<ol0<ol003@co`000`000?ooooooo`07oooo00?o09Wooooo
ool0MOooo`00>oooo`0306Kooooooooo013oool200002_ooo`800004oooo0`0000Coool00`0003?o
03?o000c<ol000<0003oooooool02?ooo`03o`2Ioooooooo07Goool003Woool206Ko;?ooo`80000c
<ol000<0003oooooool02Oooo`03o`2Ioooooooo07Goool001Koool00`1Vooooooooo`0Ooooo00<0
I_ooooooool0;?ooo`030000<ol0<ol0034co`000`000?ooooooo`0:oooo00?o09Woooooool0MOoo
o`005oooo`0306Kooooooooo01coool206Ko;oooo`030000<ol0<ol0034co`000`000?ooooooo`0:
oooo00?o09Woooooool0MOooo`006?ooo`0306Kooooooooo01[oool00`1Vooooooooo`0_oooo00<0
000co`0co`00<3?o00030000oooooooo00_oool00ol0VOooooooo`1eoooo000Ioooo00<0I_oooooo
ool06?ooo`0306Kooooooooo033oool20000<3?o00030000oooooooo00coool00ol0VOooooooo`1e
oooo000Joooo00<0I_ooooooool05Oooo`80I_lcoooo00<0000co`0co`00;c?o00030000oooooooo
00coool00ol0VOooooooo`1eoooo000Koooo00<0I_ooooooool04oooo`0306Kooooooooo03?oool0
0`0003?o03?o000^<ol000<0003oooooool03Oooo`03o`2Ioooooooo07Goool001coool00`1Voooo
ooooo`0Aoooo00<0I_ooooooool0=?ooo`030000<ol0<ol002hco`000`000?ooooooo`0=oooo00?o
09Woooooool0MOooo`007Oooo`0306Kooooooooo00ooool00`1Vooooooooo`0eoooo0P0002hco`00
0`000?ooooooo`0>oooo00?o09Woooooool0MOooo`007Oooo`0306Kooooooooo00goool206Ko>?oo
o`030000<ol0<ol002dco`000`000?ooooooo`0>oooo00?o09Woooooool0MOooo`007_ooo`0306Ko
oooooooo00_oool00`1Vooooooooo`0hoooo00<0000co`0co`00;3?o00030000oooooooo00ooool0
0ol0VOooooooo`1eoooo000Ooooo00<0I_ooooooool02Oooo`0306Kooooooooo03Woool00`0003?o
03?o000/<ol000<0003oooooool03oooo`03o`2Ioooooooo07Goool0023oool00`1Vooooooooo`07
oooo00<0I_ooooooool0>_ooo`80000/<ol000<0003oooooool04?ooo`03o`2Ioooooooo07Goool0
027oool00`1Vooooooooo`05oooo00<0I_ooooooool0>oooo`030000<ol0<ol002/co`000`000?oo
ooooo`0@oooo00?o09Woooooool0MOooo`008_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Y
oooo0P0000Coool200001?ooo`800005oooo00<0000co`0co`00:S?o00030000oooooooo017oool0
0ol0VOooooooo`1eoooo000Soooo0P1Vo`;oool00`1Vooooooooo`0Yoooo00@0003oooooool00008
oooo00@0003oooooool00004oooo00<0000co`0co`00:S?o00030000oooooooo017oool00ol0VOoo
ooooo`1eoooo000Uoooo0P1Vobcoool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
02Xco`000`000?ooooooo`0Boooo00?o09Woooooool0MOooo`00Doooo`040000oooooooo00002Ooo
o`800005oooo00<0000co`0co`00:C?o00030000oooooooo01;oool00ol0VOooooooo`1eoooo001C
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000<ol0<ol002Pco`000`000?oo
ooooo`0Coooo00?o09Woooooool0MOooo`00E?ooo`80000:oooo0`0000Coool00`0003?o03?o000X
<ol000<0003oooooool04oooo`03o`2Ioooooooo07Goool006Ooool20000:C?o00030000oooooooo
01?oool00ol0VOooooooo`1eoooo001Woooo00<0000co`0co`009c?o00030000oooooooo01Coool0
0ol0VOooooooo`1eoooo001Woooo00<0000co`0co`009c?o00030000oooooooo01Coool00ol0VOoo
ooooo`1eoooo001Woooo0P0002Lco`000`000?ooooooo`0Eoooo00?o09Woooooool0MOooo`00Iooo
o`030000<ol0<ol002Hco`000`000?ooooooo`0Eoooo00?o09Woooooool0MOooo`00Ioooo`030000
<ol0<ol002Hco`000`000?ooooooo`0Eoooo00?o09Woooooool0MOooo`00Ioooo`030000<ol0<ol0
02Dco`000`000?ooooooo`0Foooo00?o09Woooooool0MOooo`00Ioooo`80000V<ol000<0003ooooo
ool05_ooo`03o`2Ioooooooo07Goool006Ooool00`0003?o03?o000U<ol000<0003oooooool05_oo
o`03o`2Ioooooooo07Goool006Ooool00`0003?o03?o000U<ol000<0003oooooool05_ooo`03o`2I
oooooooo07Goool006Ooool00`0003?o03?o000T<ol000<0003oooooool05oooo`03o`2Ioooooooo
07Goool006Ooool200009C?o00030000oooooooo01Ooool00ol0VOooooooo`1eoooo001Woooo00<0
000co`0co`0093?o00030000oooooooo01Ooool00ol0VOooooooo`1eoooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000<ol0<ol002<co`000`000?ooooooo`0H
oooo00?o09Woooooool0MOooo`00COooo`040000oooooooo00002_ooo`050000oooooooooooo0000
00;oool00`000?ooooooo`02oooo00<0000co`0co`008c?o00030000oooooooo01Soool00ol0VOoo
ooooo`1eoooo001=oooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000oooooooo
00;oool2000093?o00030000oooooooo01Soool00ol0VOooooooo`1eoooo001=oooo00@0003ooooo
ool0000;oooo00@0003oooooooooool200001Oooo`030000<ol0<ol0028co`000`000?ooooooo`0I
oooo00?o09Woooooool0MOooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`0003?o03?o000R<ol000<0003oooooool06Oooo`03o`2Ioooooooo
07Goool004koool200002Oooo`@00003oooo0`0000Coool00`0003?o03?o000R<ol000<0003ooooo
ool06Oooo`03o`2Ioooooooo07Goool006Ooool200008c?o00030000oooooooo01Woool00ol0VOoo
ooooo`1eoooo001Woooo00<0000co`0co`008C?o00030000oooooooo01[oool00ol0VOooooooo`1e
oooo001Woooo00<0000co`0co`008C?o00030000oooooooo01[oool00ol0VOooooooo`1eoooo001W
oooo00<0000co`0co`008C?o00030000oooooooo01[oool00ol0VOooooooo`1eoooo001Woooo0P00
028co`000`000?ooooooo`0Joooo00?o09Woooooool0MOooo`00Ioooo`030000<ol0<ol0020co`00
0`000?ooooooo`0Koooo00?o09Woooooool0MOooo`00Ioooo`030000<ol0<ol0020co`000`000?oo
ooooo`0Koooo00?o09Woooooool0MOooo`00Ioooo`030000<ol0<ol0020co`000`000?ooooooo`0K
oooo00?o09Woooooool0MOooo`00Ioooo`80000Q<ol000<0003oooooool06oooo`03o`2Ioooooooo
07Goool006Ooool00`0003?o03?o000O<ol000<0003oooooool07?ooo`03o`2Ioooooooo07Goool0
06Ooool00`0003?o03?o000O<ol000<0003oooooool07?ooo`03o`2Ioooooooo07Goool006Ooool0
0`0003?o03?o000O<ol000<0003oooooool07?ooo`03o`2Ioooooooo07Goool006Ooool2000083?o
00030000oooooooo01coool00ol0VOooooooo`1eoooo001Woooo00<0000co`0co`007c?o00030000
oooooooo01coool00ol0VOooooooo`1eoooo001Ooooo1@0000?oool00`0003?o03?o000N<ol000<0
003oooooool07Oooo`03o`2Ioooooooo07Goool0067oool00`000?ooooooo`03oooo00<0000co`0c
o`007S?o00030000oooooooo01goool00ol0VOooooooo`1eoooo001Qoooo00<0003oooooool00ooo
o`80000O<ol000<0003oooooool07Oooo`03o`2Ioooooooo07Goool0067oool00`000?ooooooo`03
oooo8C?o09Soool0067oool00`000?ooooooo`03oooo8C?o09Soool0063oool200001Oooob4co`2H
oooo001Woooo83?o09Woool006OooolP<ol0VOooo`00Ioooo`lco`000`0003?o03?o000><ol08?oo
o`030000oooooooo07Koool006Ooool><ol000<0000co`0co`0023?o00030000<ol0<ol000@co`0Q
oooo00<0003oooooool0MOooo`00Ioooo`hco`000`0003?o03?o0002<ol00P0000@co`000`0003?o
03?o0003<ol02_ooo`800004oooo0P0000?oool5000000Coool0000000000004oooo00<0003ooooo
ool0MOooo`00Ioooo`hco`001@0003?o03?o03?o00000002<ol000<0000co`0co`000S?o00030000
<ol0<ol0008co`02oooo100000?oool010000?ooooooo`0000[oool00`000?ooooooo`03oooo00<0
003oooooool00_ooo`030000oooooooo07Goool006Ooool=<ol000<0000co`0co`000S?o00030000
<ol0<ol000Xco`09oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`<00004oooo00<0
003oooooool0M?ooo`00Ioooo`hco`000`0003?o03?o000500002C?o00Woool010000?ooooooo`00
00[oool01@000?ooooooooooo`000002oooo00D0003oooooooooool00000Moooo`00Ioooo`hco`00
1@0003?o03?o03?o0000000<<ol02Oooo`040000oooooooo00002_ooo`050000oooooooooooo0000
00;oool01@000?ooooooooooo`00001goooo001Woooo3c?o00030000<ol0<ol000dco`0:oooo0P00
00[oool200001?ooo`<00002oooo00<0003oooooool0M_ooo`00Iooooahco`2Koooo001Woooo7S?o
09_oool00001\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {204.5, 63.1875}} -> {-0.349561, \
0.447144, 0.00349883, 0.00566123}, {{79.875, 308.563}, {204.5, 63.1875}} -> \
{-2.52168, -0.0476099, 0.0124465, 0.0127866}, {{79.875, 308.563}, {204.5, \
63.1875}} -> {-2.52168, -0.0476099, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.18) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59405 .30902 L
.59698 .30902 L
.59842 .30902 L
.59975 .30902 L
.60102 .30902 L
s
.60102 .30902 m
.60109 .61803 L
s
0 .4 1 r
.02381 .40052 m
.04262 .42339 L
.06244 .44441 L
.07216 .45368 L
.07496 .45623 L
.0776 .45859 L
.07876 .45961 L
.07998 .46067 L
.08061 .46123 L
.08132 .46113 L
.08255 .4598 L
.09396 .44807 L
.10458 .43795 L
.14487 .40571 L
.18364 .38211 L
.22486 .36299 L
.26457 .34893 L
.30277 .33839 L
.32408 .33347 L
.34341 .3295 L
.38254 .32355 L
.40179 .32144 L
.42261 .31957 L
.46361 .31676 L
.5031 .31481 L
.54107 .31342 L
.56221 .31281 L
.58149 .31232 L
.59106 .3121 L
.59611 .31199 L
.59888 .31194 L
.60023 .31191 L
.60147 .31188 L
.60257 .30902 L
.60372 .30902 L
.60488 .30902 L
.60615 .30902 L
.60744 .30902 L
.60816 .30902 L
.60882 .30902 L
.6101 .30902 L
.61131 .30902 L
.61241 .30902 L
.61358 .30902 L
.61457 .30902 L
.61567 .30902 L
.61686 .30902 L
.61813 .30902 L
.61932 .30902 L
.6204 .30902 L
Mistroke
.62169 .30902 L
.6229 .30902 L
.6242 .30902 L
.62494 .30902 L
.62562 .30902 L
.62676 .30902 L
.62802 .30902 L
.62934 .30902 L
.63056 .30902 L
.63177 .30902 L
.63291 .30902 L
.63394 .30902 L
.63505 .30902 L
.63626 .30902 L
.63754 .30902 L
.63864 .30902 L
.63985 .30902 L
.64117 .30902 L
.64183 .30902 L
.64256 .30902 L
.64385 .30902 L
.64504 .30902 L
.64577 .30902 L
.64646 .30902 L
.64775 .30902 L
.64847 .30902 L
.64913 .30902 L
.64986 .30902 L
.65063 .30902 L
.65183 .30902 L
.65312 .30902 L
.65434 .30902 L
.65545 .30902 L
.65675 .30902 L
.65749 .30902 L
.65817 .30902 L
.65941 .30902 L
.66005 .30902 L
.66074 .30902 L
.66195 .30902 L
.66308 .30902 L
.66432 .30902 L
.66502 .30902 L
.66565 .30902 L
.66692 .30902 L
.66764 .30902 L
.66831 .30902 L
.66953 .30902 L
.67082 .30902 L
.67191 .30902 L
Mistroke
.67309 .30902 L
.6742 .30902 L
.67522 .30902 L
.67641 .30902 L
.6777 .30902 L
.67893 .30902 L
.68007 .30902 L
.68138 .30902 L
.68206 .30902 L
.68279 .30902 L
.68343 .30902 L
.68413 .30902 L
.68536 .30902 L
.68656 .30902 L
.68784 .30902 L
.68905 .30902 L
.69016 .30902 L
.69083 .30902 L
.69153 .30902 L
.6928 .30902 L
.69351 .30902 L
.69417 .30902 L
.6949 .30902 L
.69568 .30902 L
.69637 .30902 L
.69701 .30902 L
.69768 .30902 L
.69841 .30902 L
.69962 .30902 L
.70091 .30902 L
.70215 .30902 L
.70285 .30902 L
.70351 .30902 L
.7042 .30902 L
.70483 .30902 L
.70556 .30902 L
.70625 .30902 L
.70747 .30902 L
.7086 .30902 L
.70984 .30902 L
.71117 .30902 L
.71192 .30902 L
.71261 .30902 L
.71337 .30902 L
.71417 .30902 L
.71487 .30902 L
.71552 .30902 L
.71623 .30902 L
.717 .30902 L
.71768 .30902 L
Mistroke
.71842 .30902 L
.71911 .30902 L
.71976 .30902 L
.72098 .30902 L
.72227 .30902 L
.7235 .30902 L
.72466 .30902 L
.7253 .30902 L
.726 .30902 L
.72722 .30902 L
.72839 .30902 L
.72963 .30902 L
.73079 .30902 L
.73186 .30902 L
.73253 .30902 L
.73323 .30902 L
.73394 .30902 L
.73472 .30902 L
.73539 .30902 L
.73611 .30902 L
.73741 .30902 L
.73805 .30902 L
.73875 .30902 L
.74003 .30902 L
.74128 .30902 L
.74243 .30902 L
.74361 .30902 L
.74484 .30902 L
.7459 .30902 L
.74706 .30902 L
.74831 .30902 L
.74901 .30902 L
.74964 .30902 L
.75088 .30902 L
.75205 .30902 L
.75315 .30902 L
.75431 .30902 L
.7553 .30902 L
.75639 .30902 L
.75756 .30902 L
.75881 .30902 L
.76 .30902 L
.76109 .30902 L
.76236 .30902 L
.76307 .30902 L
.76371 .30902 L
.76496 .30902 L
.76614 .30902 L
.76743 .30902 L
.76808 .30902 L
Mistroke
.76879 .30902 L
.76956 .30902 L
.77028 .30902 L
.77094 .30902 L
.77165 .30902 L
.77294 .30902 L
.77367 .30902 L
.77435 .30902 L
.77559 .30902 L
.7769 .30902 L
.77808 .30902 L
.77918 .30902 L
.78038 .30902 L
.78168 .30902 L
.78294 .30902 L
.78409 .30902 L
.78541 .30902 L
.78665 .30902 L
.78781 .30902 L
.78887 .30902 L
.79004 .30902 L
.79127 .30902 L
.79252 .30902 L
.79321 .30902 L
.79386 .30902 L
.79512 .30902 L
.79627 .30902 L
.79693 .30902 L
.79763 .30902 L
.79889 .30902 L
.79959 .30902 L
.80025 .30902 L
.80098 .30902 L
.80175 .30902 L
.80244 .30902 L
.8031 .30902 L
.80385 .30902 L
.80453 .30902 L
.80518 .30902 L
.80587 .30902 L
.80711 .30902 L
.80841 .30902 L
.80907 .30902 L
.80981 .30902 L
.81054 .30902 L
.81133 .30902 L
.81208 .30902 L
.81276 .30902 L
.81405 .30902 L
.81524 .30902 L
Mistroke
.81655 .30902 L
.81728 .30902 L
.81794 .30902 L
.81916 .30902 L
.82048 .30902 L
.82172 .30902 L
.82286 .30902 L
.82413 .30902 L
.82532 .30902 L
.8264 .30902 L
.82757 .30902 L
.82883 .30902 L
.82953 .30902 L
.83018 .30902 L
.83133 .30902 L
.8326 .30902 L
.83372 .30902 L
.83489 .30902 L
.83589 .30902 L
.83698 .30902 L
.83816 .30902 L
.83942 .30902 L
.84061 .30902 L
.84169 .30902 L
.84298 .30902 L
.84363 .30902 L
.84435 .30902 L
.84561 .30902 L
.8468 .30902 L
.84751 .30902 L
.84819 .30902 L
.84946 .30902 L
.85017 .30902 L
.85083 .30902 L
.85156 .30902 L
.85233 .30902 L
.85363 .30902 L
.85436 .30902 L
.85504 .30902 L
.85628 .30902 L
.85759 .30902 L
.85877 .30902 L
.85987 .30902 L
.86107 .30902 L
.86236 .30902 L
.86358 .30902 L
.86428 .30902 L
.86493 .30902 L
.86625 .30902 L
.86699 .30902 L
Mistroke
.86766 .30902 L
.86886 .30902 L
.87017 .30902 L
.87141 .30902 L
.87256 .30902 L
.87401 .30902 L
.87472 .30902 L
.87537 .30902 L
.8766 .30902 L
.87724 .30902 L
.87793 .30902 L
.87861 .30902 L
.87933 .30902 L
.88065 .30902 L
.88146 .30902 L
.88222 .30902 L
.8829 .30902 L
.88365 .30902 L
.88489 .30902 L
.88605 .30902 L
.88733 .30902 L
.88805 .30902 L
.88871 .30902 L
.88997 .30902 L
.89068 .30902 L
.89134 .30902 L
.89204 .30902 L
.89267 .30902 L
.89341 .30902 L
.8941 .30902 L
.89527 .30902 L
.89652 .30902 L
.89758 .30902 L
.89874 .30902 L
.9 .30902 L
.9007 .30902 L
.90135 .30902 L
.90259 .30902 L
.90378 .30902 L
.90503 .30902 L
.90637 .30902 L
.90756 .30902 L
.90882 .30902 L
.90995 .30902 L
.91119 .30902 L
.91233 .30902 L
.91338 .30902 L
.91402 .30902 L
.91471 .30902 L
.91596 .30902 L
Mistroke
.91719 .30902 L
.91832 .30902 L
.91954 .30902 L
.92023 .30902 L
.92088 .30902 L
.92219 .30902 L
.92288 .30902 L
.92361 .30902 L
.92476 .30902 L
.92584 .30902 L
.92712 .30902 L
.92828 .30902 L
.9295 .30902 L
.93082 .30902 L
.93206 .30902 L
.93321 .30902 L
.93426 .30902 L
.93524 .30902 L
.93632 .30902 L
.93748 .30902 L
.93869 .30902 L
.93984 .30902 L
.94088 .30902 L
.942 .30902 L
.94312 .30902 L
.94416 .30902 L
.94529 .30902 L
.94648 .30902 L
.94752 .30902 L
.94849 .30902 L
.94956 .30902 L
.9507 .30902 L
.95171 .30902 L
.95282 .30902 L
.95386 .30902 L
.95482 .30902 L
.95568 .30902 L
.95664 .30902 L
.95763 .30902 L
.95857 .30902 L
.95965 .30902 L
.96084 .30902 L
.96196 .30902 L
.963 .30902 L
.96403 .30902 L
.96496 .30902 L
.96604 .30902 L
.96706 .30902 L
.96817 .30902 L
.96934 .30902 L
Mistroke
.97034 .30902 L
.97144 .30902 L
.97263 .30902 L
.9739 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.18) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00<co`0206Ko00<00000I_l0I_l01@1Vo`03000006Ko06Ko00Dco`000`0003?o03?o0005<ol000<0
000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`000c?o
02`00007oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Goool00`000?ooooooo`0V
oooo00<0000co`0co`005c?o00h0I_l00`00001Vo`1Vo`0;06Ko33?o0003o`2I<ol0<ol000/co`00
0`0003?o03?o000A<ol02P0000[oool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00Iooo
o`030000<ol0<ol000lco`0806Ko:3?o0003o`2I<ol0<ol001Dco`0:0000EOooo`00Ioooo`800006
<ol02P1Voc0co`000ol0VC?o03?o000?<ol01P0005ooool006Ooool00`0003?o03?o000506Ko>S?o
0003o`2I<ol0<ol000/co`040000IOooo`00IOooo`80I_l00`00001Vo`1Vo`0o<ol000?o09Tco`0c
o`002C?o0080001Yoooo001Poooo1@1Vo`;oool00`0003?o03?o000o<ol000?o09Tco`0co`001S?o
00<0001[oooo001Loooo101Vo`Ooool20000@3?o0003o`2I<ol0<ol000@co`020000K_ooo`00FOoo
o`<0I_l;oooo00<0000co`0co`00?c?o0003o`2I<ol0<ol0008co`020000L?ooo`00EOooo`@0I_l>
oooo00<0000co`0co`00?c?o0003o`2I<ol0<ol00080001boooo001Boooo0`1Voa;oool00`0003?o
03?o000o<ol000?o09T000000000M?ooo`00Coooo`<0I_lEoooo0P00040co`000ol0VOooooooo`1d
oooo001;oooo101VoaSoool00`0003?o03?o000n<ol000<0003o09Woool0MOooo`00BOooo`80I_lL
oooo00<0000co`0co`00?3?o008000000oooool0VOooo`1eoooo0017oooo0P1Voakoool00`0003?o
03?o000k<ol000D0003ooooooooooooo09T0M_ooo`00AOooo`80I_lPoooo0P0003/co`000`000?oo
ooooo`02oooo00?o09Woooooool0M?ooo`00@oooo`80I_lRoooo00<0000co`0co`00>C?o00030000
oooooooo00?oool00ol0VOooooooo`1doooo0011oooo0P1Vo`_oool200001?ooo`800003oooo1000
00?oool200001Oooo`030000<ol0<ol003Lco`0200001_ooo`03o`2Ioooooooo07Coool003ooool2
06Ko3?ooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`0000Coool0
0`0003?o03?o000f<ol000<0003oooooool01_ooo`03o`2Ioooooooo07Coool003goool206Ko3_oo
o`040000oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0P0003Hco`00
0`000?ooooooo`07oooo00?o09Woooooool0M?ooo`00>oooo`80I_l@oooo00@0003oooooool0000:
oooo00<0003oooooool00_ooo`800005oooo00<0000co`0co`00=3?o00030000oooooooo00Soool0
0ol0VOooooooo`1doooo000joooo00<0I_ooooooool04?ooo`040000oooooooo00002?ooo`040000
oooooooo00000oooo`030000oooooooo00Coool00`0003?o03?o000d<ol000<0003oooooool02?oo
o`03o`2Ioooooooo07Coool003Soool206Ko5?ooo`80000:oooo0P0000Coool300001?ooo`030000
<ol0<ol003<co`000`000?ooooooo`09oooo00?o09Woooooool0M?ooo`005_ooo`0306Kooooooooo
01goool206Ko;oooo`80000c<ol000<0003oooooool02_ooo`03o`2Ioooooooo07Coool001Ooool0
0`1Vooooooooo`0Koooo00<0I_ooooooool0;oooo`030000<ol0<ol0034co`000`000?ooooooo`0;
oooo00?o09Woooooool0M?ooo`006?ooo`0306Kooooooooo01Woool00`1Vooooooooo`0`oooo00<0
000co`0co`00<C?o00030000oooooooo00_oool00ol0VOooooooo`1doooo000Ioooo00<0I_oooooo
ool05_ooo`80I_lcoooo00<0000co`0co`00<3?o00030000oooooooo00coool00ol0VOooooooo`1d
oooo000Joooo00<0I_ooooooool05?ooo`0306Kooooooooo03?oool20000<3?o00030000oooooooo
00goool00ol0VOooooooo`1doooo000Koooo00<0I_ooooooool04_ooo`0306Kooooooooo03Coool0
0`0003?o03?o000_<ol000<0003oooooool03Oooo`03o`2Ioooooooo07Coool001coool00`1Voooo
ooooo`0@oooo00<0I_ooooooool0=Oooo`030000<ol0<ol002hco`000`000?ooooooo`0>oooo00?o
09Woooooool0M?ooo`007Oooo`0306Kooooooooo00goool206Ko>?ooo`030000<ol0<ol002hco`00
0`000?ooooooo`0>oooo00?o09Woooooool0M?ooo`007Oooo`0306Kooooooooo00coool00`1Voooo
ooooo`0hoooo0P0002hco`000`000?ooooooo`0?oooo00?o09Woooooool0M?ooo`007_ooo`0306Ko
oooooooo00[oool00`1Vooooooooo`0ioooo00<0000co`0co`00;C?o00030000oooooooo00ooool0
0ol0VOooooooo`1doooo000Ooooo00<0I_ooooooool02?ooo`0306Kooooooooo03[oool00`0003?o
03?o000/<ol000<0003oooooool04?ooo`03o`2Ioooooooo07Coool0023oool00`1Vooooooooo`06
oooo00<0I_ooooooool0>oooo`030000<ol0<ol002`co`000`000?ooooooo`0@oooo00?o09Wooooo
ool0M?ooo`008Oooo`0306Kooooooooo00Coool00`1Vooooooooo`0loooo0P0002`co`000`000?oo
ooooo`0Aoooo00?o09Woooooool0M?ooo`008_ooo`0306Kooooooooo00;oool00`1Vooooooooo`0m
oooo00<0000co`0co`00:c?o00030000oooooooo017oool00ol0VOooooooo`1doooo000Soooo0P1V
o`03oooo06Kooooo02coool200001?ooo`800004oooo0P0000Goool00`0003?o03?o000Z<ol000<0
003oooooool04_ooo`03o`2Ioooooooo07Coool002Coool206Ko;Oooo`040000oooooooo00002?oo
o`040000oooooooo00001?ooo`030000<ol0<ol002Xco`000`000?ooooooo`0Boooo00?o09Wooooo
ool0M?ooo`00Doooo`040000oooooooo00002oooo`030000oooooooo00;oool20000:S?o00030000
oooooooo01?oool00ol0VOooooooo`1doooo001Coooo00@0003oooooool00009oooo0P0000Goool0
0`0003?o03?o000Y<ol000<0003oooooool04oooo`03o`2Ioooooooo07Coool005?oool010000?oo
ooooo`0000Woool00`000?ooooooo`04oooo00<0000co`0co`00:3?o00030000oooooooo01Coool0
0ol0VOooooooo`1doooo001Doooo0P0000[oool300001?ooo`030000<ol0<ol002Pco`000`000?oo
ooooo`0Doooo00?o09Woooooool0M?ooo`00Ioooo`80000Y<ol000<0003oooooool05?ooo`03o`2I
oooooooo07Coool006Ooool00`0003?o03?o000W<ol000<0003oooooool05Oooo`03o`2Ioooooooo
07Coool006Ooool00`0003?o03?o000W<ol000<0003oooooool05Oooo`03o`2Ioooooooo07Coool0
06Ooool200009c?o00030000oooooooo01Koool00ol0VOooooooo`1doooo001Woooo00<0000co`0c
o`009S?o00030000oooooooo01Koool00ol0VOooooooo`1doooo001Woooo00<0000co`0co`009S?o
00030000oooooooo01Koool00ol0VOooooooo`1doooo001Woooo00<0000co`0co`009C?o00030000
oooooooo01Ooool00ol0VOooooooo`1doooo001Woooo0P0002Hco`000`000?ooooooo`0Goooo00?o
09Woooooool0M?ooo`00Ioooo`030000<ol0<ol002Dco`000`000?ooooooo`0Goooo00?o09Wooooo
ool0M?ooo`00Ioooo`030000<ol0<ol002Dco`000`000?ooooooo`0Goooo00?o09Woooooool0M?oo
o`00Ioooo`030000<ol0<ol002@co`000`000?ooooooo`0Hoooo00?o09Woooooool0M?ooo`00Iooo
o`80000U<ol000<0003oooooool06?ooo`03o`2Ioooooooo07Coool006Ooool00`0003?o03?o000T
<ol000<0003oooooool06?ooo`03o`2Ioooooooo07Coool004koool200001?ooo`800005oooo00<0
003oooooool00_ooo`800005oooo00<0000co`0co`008c?o00030000oooooooo01Woool00ol0VOoo
ooooo`1doooo001=oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`0003?o03?o000S<ol000<0003oooooool06Oooo`03o`2Ioooooooo07Coool0
04goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_ooo`80000T
<ol000<0003oooooool06Oooo`03o`2Ioooooooo07Coool004goool010000?ooooooo`0000_oool0
10000?ooooooooooo`800005oooo00<0000co`0co`008S?o00030000oooooooo01[oool00ol0VOoo
ooooo`1doooo001=oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool01?ooo`030000<ol0<ol0028co`000`000?ooooooo`0Joooo00?o09Woooooool0M?ooo`00C_oo
o`800009oooo100000?oool300001?ooo`030000<ol0<ol0028co`000`000?ooooooo`0Joooo00?o
09Woooooool0M?ooo`00Ioooo`80000S<ol000<0003oooooool06_ooo`03o`2Ioooooooo07Coool0
06Ooool00`0003?o03?o000Q<ol000<0003oooooool06oooo`03o`2Ioooooooo07Coool006Ooool0
0`0003?o03?o000Q<ol000<0003oooooool06oooo`03o`2Ioooooooo07Coool006Ooool00`0003?o
03?o000Q<ol000<0003oooooool06oooo`03o`2Ioooooooo07Coool006Ooool200008S?o00030000
oooooooo01_oool00ol0VOooooooo`1doooo001Woooo00<0000co`0co`0083?o00030000oooooooo
01coool00ol0VOooooooo`1doooo001Woooo00<0000co`0co`0083?o00030000oooooooo01coool0
0ol0VOooooooo`1doooo001Woooo00<0000co`0co`0083?o00030000oooooooo01coool00ol0VOoo
ooooo`1doooo001Woooo0P00024co`000`000?ooooooo`0Loooo00?o09Woooooool0M?ooo`00Iooo
o`030000<ol0<ol001lco`000`000?ooooooo`0Moooo00?o09Woooooool0M?ooo`00Ioooo`030000
<ol0<ol001lco`000`000?ooooooo`0Moooo00?o09Woooooool0M?ooo`00Ioooo`030000<ol0<ol0
01lco`000`000?ooooooo`0Moooo00?o09Woooooool0M?ooo`00Ioooo`80000P<ol000<0003ooooo
ool07Oooo`03o`2Ioooooooo07Coool006Ooool00`0003?o03?o000O<ol000<0003oooooool07Ooo
o`03o`2Ioooooooo07Coool005ooool500000oooo`030000<ol0<ol001hco`000`000?ooooooo`0N
oooo00?o09Woooooool0M?ooo`00HOooo`030000oooooooo00?oool00`0003?o03?o000N<ol000<0
003oooooool07_ooo`03o`2Ioooooooo07Coool0067oool00`000?ooooooo`03oooo0P0001lco`00
0`000?ooooooo`0Noooo00?o09Woooooool0M?ooo`00HOooo`030000oooooooo00?ooolQ<ol0V?oo
o`00HOooo`030000oooooooo00?ooolQ<ol0V?ooo`00H?ooo`800005oooo8C?o09Soool006OooolP
<ol0VOooo`00Ioooob0co`2Ioooo001Woooo3c?o00030000<ol0<ol000hco`0Poooo00<0003ooooo
ool0M_ooo`00Ioooo`hco`000`0003?o03?o0008<ol000<0000co`0co`0013?o027oool00`000?oo
ooooo`1eoooo001Woooo3S?o00030000<ol0<ol0008co`02000013?o00030000<ol0<ol000<co`0:
oooo0P0000Coool200000oooo`D00002oooo0P0000Coool00`000?ooooooo`1eoooo001Woooo3S?o
00050000<ol0<ol0<ol00000008co`000`0003?o03?o0002<ol000<0000co`0co`000S?o00;oool4
00000oooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool01@000?oooooooooo
o`00001goooo001Woooo3C?o00030000<ol0<ol0008co`000`0003?o03?o000:<ol02Oooo`040000
oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool0M?ooo`00Ioooo`hco`000`0003?o03?o000500002C?o00Woool010000?ooooooo`0000[oool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001Woooo3S?o00050000<ol0<ol0
<ol0000000`co`09oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`050000
oooooooooooo000007Ooool006Ooool?<ol000<0000co`0co`003C?o00[oool200002_ooo`800004
oooo0P0000?oool00`000?ooooooo`1foooo001Woooo7S?o09_oool006OooolN<ol0Voooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {353.188, 211.875}} -> {-0.349561, \
1.49934, 0.00349883, 0.00566123}, {{79.875, 308.563}, {353.188, 211.875}} -> \
{-2.52168, 2.3289, 0.0124465, 0.0127866}, {{79.875, 308.563}, {353.188, \
211.875}} -> {-2.52168, 2.3289, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.17) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59405 .30902 L
.59698 .30902 L
.59975 .30902 L
.60237 .30902 L
.60309 .30902 L
.60385 .30902 L
.6045 .30902 L
s
.6045 .30902 m
.60457 .61803 L
s
0 .4 1 r
.02381 .39635 m
.04262 .41975 L
.06244 .44124 L
.06747 .44623 L
.07286 .45137 L
.07547 .4538 L
.07675 .45497 L
.07793 .45574 L
.07901 .45463 L
.08015 .45345 L
.08255 .45101 L
.10458 .43044 L
.14241 .40169 L
.1827 .37832 L
.22147 .36115 L
.2627 .34716 L
.30241 .33676 L
.3406 .32882 L
.36192 .32533 L
.38125 .32285 L
.42038 .31913 L
.43962 .31774 L
.46044 .31648 L
.50145 .31454 L
.54093 .31317 L
.5789 .31219 L
.58892 .31197 L
.59841 .31178 L
.60095 .31173 L
.60235 .3117 L
.60365 .31167 L
.60433 .31166 L
.60506 .30902 L
.60587 .30902 L
.60661 .30902 L
.60725 .30902 L
.60795 .30902 L
.60868 .30902 L
.60935 .30902 L
.61065 .30902 L
.61188 .30902 L
.61298 .30902 L
.61418 .30902 L
.61548 .30902 L
.61614 .30902 L
.61686 .30902 L
.61813 .30902 L
.61933 .30902 L
.62057 .30902 L
.62174 .30902 L
Mistroke
.62239 .30902 L
.62309 .30902 L
.62431 .30902 L
.62502 .30902 L
.62578 .30902 L
.62642 .30902 L
.62712 .30902 L
.62778 .30902 L
.62848 .30902 L
.62974 .30902 L
.63101 .30902 L
.63173 .30902 L
.63239 .30902 L
.63361 .30902 L
.63491 .30902 L
.63606 .30902 L
.63715 .30902 L
.63834 .30902 L
.63962 .30902 L
.64078 .30902 L
.64187 .30902 L
.64306 .30902 L
.64433 .30902 L
.64498 .30902 L
.64567 .30902 L
.64693 .30902 L
.64816 .30902 L
.64929 .30902 L
.65035 .30902 L
.65134 .30902 L
.65243 .30902 L
.6536 .30902 L
.65482 .30902 L
.65598 .30902 L
.65702 .30902 L
.65815 .30902 L
.65937 .30902 L
.66048 .30902 L
.6617 .30902 L
.66299 .30902 L
.66411 .30902 L
.66516 .30902 L
.66631 .30902 L
.66754 .30902 L
.66823 .30902 L
.66888 .30902 L
.66958 .30902 L
.67033 .30902 L
.67158 .30902 L
.6723 .30902 L
Mistroke
.67297 .30902 L
.67421 .30902 L
.67535 .30902 L
.67666 .30902 L
.6779 .30902 L
.6792 .30902 L
.68043 .30902 L
.6811 .30902 L
.68183 .30902 L
.68311 .30902 L
.68434 .30902 L
.68563 .30902 L
.68673 .30902 L
.68795 .30902 L
.68868 .30902 L
.68938 .30902 L
.69068 .30902 L
.69141 .30902 L
.69209 .30902 L
.69283 .30902 L
.69361 .30902 L
.69491 .30902 L
.69613 .30902 L
.69683 .30902 L
.69746 .30902 L
.69816 .30902 L
.6989 .30902 L
.70014 .30902 L
.70084 .30902 L
.70148 .30902 L
.70266 .30902 L
.70391 .30902 L
.70503 .30902 L
.70608 .30902 L
.70722 .30902 L
.70846 .30902 L
.70977 .30902 L
.71051 .30902 L
.71119 .30902 L
.71245 .30902 L
.71315 .30902 L
.71379 .30902 L
.715 .30902 L
.7163 .30902 L
.71752 .30902 L
.71866 .30902 L
.71973 .30902 L
.72088 .30902 L
.72216 .30902 L
.72332 .30902 L
Mistroke
.72453 .30902 L
.72585 .30902 L
.72709 .30902 L
.72824 .30902 L
.72928 .30902 L
.73027 .30902 L
.73134 .30902 L
.7325 .30902 L
.73372 .30902 L
.73487 .30902 L
.7359 .30902 L
.73703 .30902 L
.73827 .30902 L
.73958 .30902 L
.74027 .30902 L
.74102 .30902 L
.74234 .30902 L
.74359 .30902 L
.74429 .30902 L
.74493 .30902 L
.74617 .30902 L
.74734 .30902 L
.74847 .30902 L
.74967 .30902 L
.75069 .30902 L
.75182 .30902 L
.75303 .30902 L
.75433 .30902 L
.75557 .30902 L
.75669 .30902 L
.75792 .30902 L
.75922 .30902 L
.76045 .30902 L
.76157 .30902 L
.76289 .30902 L
.76363 .30902 L
.76432 .30902 L
.76557 .30902 L
.76621 .30902 L
.76691 .30902 L
.76757 .30902 L
.76828 .30902 L
.76959 .30902 L
.77037 .30902 L
.77109 .30902 L
.77176 .30902 L
.77246 .30902 L
.77314 .30902 L
.77387 .30902 L
.77456 .30902 L
Mistroke
.77519 .30902 L
.7764 .30902 L
.77766 .30902 L
.77889 .30902 L
.77958 .30902 L
.78022 .30902 L
.78139 .30902 L
.78263 .30902 L
.78375 .30902 L
.78479 .30902 L
.78593 .30902 L
.78716 .30902 L
.7884 .30902 L
.7891 .30902 L
.78975 .30902 L
.79106 .30902 L
.7918 .30902 L
.79247 .30902 L
.79367 .30902 L
.79497 .30902 L
.7962 .30902 L
.79733 .30902 L
.79839 .30902 L
.79953 .30902 L
.8006 .30902 L
.80158 .30902 L
.80273 .30902 L
.80398 .30902 L
.80515 .30902 L
.80625 .30902 L
.80729 .30902 L
.80842 .30902 L
.80965 .30902 L
.81082 .30902 L
.81205 .30902 L
.81335 .30902 L
.81446 .30902 L
.81568 .30902 L
.81699 .30902 L
.8182 .30902 L
.81884 .30902 L
.81953 .30902 L
.82026 .30902 L
.82095 .30902 L
.8222 .30902 L
.82335 .30902 L
.82398 .30902 L
.82467 .30902 L
.82593 .30902 L
.82716 .30902 L
Mistroke
.82827 .30902 L
.82955 .30902 L
.83076 .30902 L
.83189 .30902 L
.83292 .30902 L
.83406 .30902 L
.83525 .30902 L
.83656 .30902 L
.83775 .30902 L
.8384 .30902 L
.83912 .30902 L
.84042 .30902 L
.84163 .30902 L
.84292 .30902 L
.84524 .30902 L
.84653 .30902 L
.84726 .30902 L
.84792 .30902 L
.84915 .30902 L
.85044 .30902 L
.85113 .30902 L
.85177 .30902 L
.85251 .30902 L
.85319 .30902 L
.85394 .30902 L
.85475 .30902 L
.8555 .30902 L
.85619 .30902 L
.85745 .30902 L
.85864 .30902 L
.8597 .30902 L
.86087 .30902 L
.86213 .30902 L
.86284 .30902 L
.86347 .30902 L
.86472 .30902 L
.86589 .30902 L
.867 .30902 L
.86816 .30902 L
.86916 .30902 L
.87025 .30902 L
.87143 .30902 L
.87269 .30902 L
.87388 .30902 L
.87496 .30902 L
.87624 .30902 L
.87689 .30902 L
.8776 .30902 L
.87886 .30902 L
.88005 .30902 L
Mistroke
.88076 .30902 L
.88143 .30902 L
.88271 .30902 L
.88342 .30902 L
.88407 .30902 L
.8848 .30902 L
.88557 .30902 L
.88687 .30902 L
.8876 .30902 L
.88828 .30902 L
.88952 .30902 L
.89083 .30902 L
.89201 .30902 L
.8931 .30902 L
.89431 .30902 L
.8956 .30902 L
.89682 .30902 L
.89752 .30902 L
.89816 .30902 L
.89883 .30902 L
.89956 .30902 L
.90088 .30902 L
.90201 .30902 L
.90326 .30902 L
.90456 .30902 L
.90576 .30902 L
.90645 .30902 L
.9072 .30902 L
.90791 .30902 L
.90856 .30902 L
.9098 .30902 L
.91111 .30902 L
.91179 .30902 L
.91251 .30902 L
.91383 .30902 L
.91463 .30902 L
.91539 .30902 L
.91608 .30902 L
.91682 .30902 L
.91748 .30902 L
.91819 .30902 L
.91947 .30902 L
.92073 .30902 L
.92188 .30902 L
.92312 .30902 L
.92383 .30902 L
.92449 .30902 L
.92519 .30902 L
.92583 .30902 L
.92652 .30902 L
Mistroke
.92726 .30902 L
.9285 .30902 L
.92964 .30902 L
.93087 .30902 L
.93157 .30902 L
.93223 .30902 L
.93341 .30902 L
.9345 .30902 L
.93569 .30902 L
.93694 .30902 L
.93818 .30902 L
.93887 .30902 L
.93952 .30902 L
.9407 .30902 L
.94195 .30902 L
.94299 .30902 L
.94412 .30902 L
.94535 .30902 L
.9465 .30902 L
.94781 .30902 L
.94855 .30902 L
.94923 .30902 L
.95049 .30902 L
.9512 .30902 L
.95183 .30902 L
.95304 .30902 L
.95434 .30902 L
.95557 .30902 L
.9567 .30902 L
.95777 .30902 L
.95891 .30902 L
.95999 .30902 L
.96097 .30902 L
.96215 .30902 L
.9634 .30902 L
.96456 .30902 L
.96565 .30902 L
.96675 .30902 L
.96797 .30902 L
.96918 .30902 L
.97049 .30902 L
.97172 .30902 L
.97289 .30902 L
.97393 .30902 L
.97508 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.17) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`000c?o0080I_l00`00001V
o`1Vo`0506Ko00<00000I_l0I_l01@1Vo`03000006Ko06Ko00Dco`000`0003?o03?o0005<ol000<0
000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`000c?o
02`00007oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Goool00`000?ooooooo`0V
oooo00<0000co`0co`006C?o00`0I_l00`00001Vo`1Vo`0306Ko53?o0003o`2I<ol0<ol000/co`00
0`0003?o03?o000A<ol02P0000[oool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00Iooo
o`030000<ol0<ol000dco`0<06Ko9S?o0003o`2I<ol0<ol001Dco`0:0000EOooo`00Ioooo`800006
<ol0201Voc8co`000ol0VC?o03?o000?<ol01P0005ooool006Goool206Ko00<00000I_l0I_l01@1V
ocXco`000ol0VC?o03?o000;<ol0100006Goool0063oool506Ko0_ooo`030000<ol0<ol003lco`00
0ol0VC?o03?o0009<ol00P0006Woool005coool406Ko1oooo`030000<ol0<ol003lco`000ol0VC?o
03?o0006<ol00`0006_oool005Woool306Ko2oooo`800010<ol000?o09Tco`0co`0013?o0080001^
oooo001Eoooo101Vo`koool00`0003?o03?o000o<ol000?o09Tco`0co`000S?o0080001`oooo001B
oooo0`1Voa;oool00`0003?o03?o000o<ol000?o09Tco`0co`000P0007;oool004ooool306Ko5Ooo
o`030000<ol0<ol003lco`000ol0V@000000001doooo001=oooo0P1VoaSoool20000@3?o0003o`2I
oooooooo07Coool004[oool306Ko6_ooo`030000<ol0<ol003hco`000`000?l0VOooo`1eoooo0017
oooo0`1Voagoool00`0003?o03?o000l<ol00P000003ooooo`2Ioooo07Goool004Goool206Ko8?oo
o`030000<ol0<ol003/co`001@000?ooooooooooool0V@1foooo0013oooo0P1Vob;oool20000>c?o
00030000oooooooo00;oool00ol0VOooooooo`1doooo0011oooo0P1VobCoool00`0003?o03?o000i
<ol000<0003oooooool00oooo`03o`2Ioooooooo07Coool003ooool206Ko3Oooo`800004oooo0P00
00?oool400000oooo`800005oooo00<0000co`0co`00=c?o00800006oooo00?o09Woooooool0M?oo
o`00?Oooo`80I_l>oooo00@0003oooooool00008oooo00<0003oooooool00oooo`040000oooooooo
00001?ooo`030000<ol0<ol003Hco`000`000?ooooooo`06oooo00?o09Woooooool0M?ooo`00>ooo
o`80I_l@oooo00@0003oooooool00009oooo00<0003oooooool01Oooo`030000oooooooo00;oool2
0000=S?o00030000oooooooo00Ooool00ol0VOooooooo`1doooo000ioooo0P1Voa;oool010000?oo
ooooo`0000[oool00`000?ooooooo`02oooo0P0000Goool00`0003?o03?o000d<ol000<0003ooooo
ool02?ooo`03o`2Ioooooooo07Coool003Ooool206Ko5?ooo`040000oooooooo00002?ooo`040000
oooooooo00000oooo`030000oooooooo00Coool00`0003?o03?o000d<ol000<0003oooooool02?oo
o`03o`2Ioooooooo07Coool001Koool00`1Vooooooooo`0Loooo0P1VoaOoool200002_ooo`800004
oooo0`0000Coool00`0003?o03?o000c<ol000<0003oooooool02Oooo`03o`2Ioooooooo07Coool0
01Ooool00`1Vooooooooo`0Joooo00<0I_ooooooool0<?ooo`80000c<ol000<0003oooooool02_oo
o`03o`2Ioooooooo07Coool001Soool00`1Vooooooooo`0Hoooo00<0I_ooooooool0<Oooo`030000
<ol0<ol0034co`000`000?ooooooo`0;oooo00?o09Woooooool0M?ooo`006Oooo`0306Kooooooooo
01Goool206Ko=?ooo`030000<ol0<ol0034co`000`000?ooooooo`0;oooo00?o09Woooooool0M?oo
o`006_ooo`0306Kooooooooo01?oool00`1Vooooooooo`0doooo00<0000co`0co`00<3?o00030000
oooooooo00coool00ol0VOooooooo`1doooo000Koooo00<0I_ooooooool04Oooo`0306Kooooooooo
03Goool20000<3?o00030000oooooooo00goool00ol0VOooooooo`1doooo000Loooo00<0I_oooooo
ool03_ooo`80I_lhoooo00<0000co`0co`00;c?o00030000oooooooo00goool00ol0VOooooooo`1d
oooo000Moooo00<0I_ooooooool03?ooo`0306Kooooooooo03Soool00`0003?o03?o000^<ol000<0
003oooooool03_ooo`03o`2Ioooooooo07Coool001goool00`1Vooooooooo`0;oooo00<0I_oooooo
ool0>Oooo`030000<ol0<ol002hco`000`000?ooooooo`0>oooo00?o09Woooooool0M?ooo`007_oo
o`0306Kooooooooo00Woool00`1Vooooooooo`0joooo0P0002hco`000`000?ooooooo`0?oooo00?o
09Woooooool0M?ooo`007oooo`0306Kooooooooo00Ooool00`1Vooooooooo`0koooo00<0000co`0c
o`00;C?o00030000oooooooo00ooool00ol0VOooooooo`1doooo000Poooo00<0I_ooooooool01?oo
o`80I_lnoooo00<0000co`0co`00;3?o00030000oooooooo013oool00ol0VOooooooo`1doooo000Q
oooo00<0I_ooooooool00_ooo`0306Kooooooooo03koool00`0003?o03?o000/<ol000<0003ooooo
ool04?ooo`03o`2Ioooooooo07Coool002;oool0101Vooooooooo`1Vod7oool20000;3?o00030000
oooooooo017oool00ol0VOooooooo`1doooo000Soooo0`1Vod7oool00`0003?o03?o000[<ol000<0
003oooooool04Oooo`03o`2Ioooooooo07Coool002Coool00`1Vooooooooo`0]oooo0P0000Coool2
00001?ooo`800005oooo00<0000co`0co`00:S?o00030000oooooooo01;oool00ol0VOooooooo`1d
oooo001Coooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0000co`0co`00:S?o
00030000oooooooo01;oool00ol0VOooooooo`1doooo001Coooo00@0003oooooool0000;oooo00<0
003oooooool00_ooo`80000Z<ol000<0003oooooool04oooo`03o`2Ioooooooo07Coool005?oool0
10000?ooooooo`0000Woool200001Oooo`030000<ol0<ol002Tco`000`000?ooooooo`0Coooo00?o
09Woooooool0M?ooo`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`0003?o
03?o000X<ol000<0003oooooool05?ooo`03o`2Ioooooooo07Coool005Coool200002_ooo`<00004
oooo00<0000co`0co`00:3?o00030000oooooooo01Coool00ol0VOooooooo`1doooo001Woooo0P00
02Tco`000`000?ooooooo`0Doooo00?o09Woooooool0M?ooo`00Ioooo`030000<ol0<ol002Lco`00
0`000?ooooooo`0Eoooo00?o09Woooooool0M?ooo`00Ioooo`030000<ol0<ol002Lco`000`000?oo
ooooo`0Eoooo00?o09Woooooool0M?ooo`00Ioooo`80000W<ol000<0003oooooool05_ooo`03o`2I
oooooooo07Coool006Ooool00`0003?o03?o000V<ol000<0003oooooool05_ooo`03o`2Ioooooooo
07Coool006Ooool00`0003?o03?o000V<ol000<0003oooooool05_ooo`03o`2Ioooooooo07Coool0
06Ooool00`0003?o03?o000U<ol000<0003oooooool05oooo`03o`2Ioooooooo07Coool006Ooool2
00009S?o00030000oooooooo01Ooool00ol0VOooooooo`1doooo001Woooo00<0000co`0co`009C?o
00030000oooooooo01Ooool00ol0VOooooooo`1doooo001Woooo00<0000co`0co`009C?o00030000
oooooooo01Ooool00ol0VOooooooo`1doooo001Woooo00<0000co`0co`0093?o00030000oooooooo
01Soool00ol0VOooooooo`1doooo001Woooo0P0002Dco`000`000?ooooooo`0Hoooo00?o09Wooooo
ool0M?ooo`00Ioooo`030000<ol0<ol002@co`000`000?ooooooo`0Hoooo00?o09Woooooool0M?oo
o`00C_ooo`800004oooo0P0000Goool00`000?ooooooo`02oooo0P0000Goool00`0003?o03?o000S
<ol000<0003oooooool06Oooo`03o`2Ioooooooo07Coool004goool010000?ooooooo`0000[oool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000<ol0<ol002<co`000`000?oo
ooooo`0Ioooo00?o09Woooooool0M?ooo`00COooo`040000oooooooo00002_ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo0P0002@co`000`000?ooooooo`0Ioooo00?o09Woooooool0M?oo
o`00COooo`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`0003?o03?o000R
<ol000<0003oooooool06_ooo`03o`2Ioooooooo07Coool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0000co`0co`008S?o00030000oooooooo
01[oool00ol0VOooooooo`1doooo001>oooo0P0000Woool400000oooo`<00004oooo00<0000co`0c
o`008S?o00030000oooooooo01[oool00ol0VOooooooo`1doooo001Woooo0P0002<co`000`000?oo
ooooo`0Joooo00?o09Woooooool0M?ooo`00Ioooo`030000<ol0<ol0024co`000`000?ooooooo`0K
oooo00?o09Woooooool0M?ooo`00Ioooo`030000<ol0<ol0024co`000`000?ooooooo`0Koooo00?o
09Woooooool0M?ooo`00Ioooo`030000<ol0<ol0024co`000`000?ooooooo`0Koooo00?o09Wooooo
ool0M?ooo`00Ioooo`80000R<ol000<0003oooooool06oooo`03o`2Ioooooooo07Coool006Ooool0
0`0003?o03?o000P<ol000<0003oooooool07?ooo`03o`2Ioooooooo07Coool006Ooool00`0003?o
03?o000P<ol000<0003oooooool07?ooo`03o`2Ioooooooo07Coool006Ooool00`0003?o03?o000P
<ol000<0003oooooool07?ooo`03o`2Ioooooooo07Coool006Ooool200008C?o00030000oooooooo
01coool00ol0VOooooooo`1doooo001Woooo00<0000co`0co`007c?o00030000oooooooo01goool0
0ol0VOooooooo`1doooo001Woooo00<0000co`0co`007c?o00030000oooooooo01goool00ol0VOoo
ooooo`1doooo001Woooo00<0000co`0co`007c?o00030000oooooooo01goool00ol0VOooooooo`1d
oooo001Woooo0P00020co`000`000?ooooooo`0Moooo00?o09Woooooool0M?ooo`00Ioooo`030000
<ol0<ol001lco`000`000?ooooooo`0Moooo00?o09Woooooool0M?ooo`00Goooo`D00003oooo00<0
000co`0co`007S?o00030000oooooooo01koool00ol0VOooooooo`1doooo001Qoooo00<0003ooooo
ool00oooo`030000<ol0<ol001hco`000`000?ooooooo`0Noooo00?o09Woooooool0M?ooo`00HOoo
o`030000oooooooo00?oool200007c?o00030000oooooooo01koool00ol0VOooooooo`1doooo001Q
oooo00<0003oooooool00oooob4co`2Hoooo001Qoooo00<0003oooooool00oooob4co`2Hoooo001P
oooo0P0000GooolQ<ol0V?ooo`00Ioooob0co`2Ioooo001Woooo83?o09Woool006Ooool?<ol000<0
000co`0co`003S?o023oool00`000?ooooooo`1foooo001Woooo3S?o00030000<ol0<ol000Pco`00
0`0003?o03?o0004<ol08Oooo`030000oooooooo07Goool006Ooool><ol000<0000co`0co`000S?o
00800004<ol000<0000co`0co`000c?o00[oool200001?ooo`800003oooo1@0000?oool00`000?oo
ooooo`02oooo00<0003oooooool0MOooo`00Ioooo`hco`001@0003?o03?o03?o00000002<ol000<0
000co`0co`000S?o00030000<ol0<ol0008co`02oooo100000?oool010000?ooooooo`0000[oool0
0`000?ooooooo`03oooo00<0003oooooool00_ooo`030000oooooooo07Goool006Ooool=<ol000<0
000co`0co`000S?o00030000<ol0<ol000Xco`09oooo00@0003oooooool0000:oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`1doooo001Woooo3S?o00030000<ol0<ol0
00D00009<ol02Oooo`040000oooooooo00002_ooo`030000oooooooo00Coool01@000?oooooooooo
o`00001goooo001Woooo3S?o00050000<ol0<ol0<ol0000000`co`09oooo00@0003oooooool0000:
oooo00D0003oooooooooool000000_ooo`050000oooooooooooo000007Ooool006Ooool?<ol000<0
000co`0co`003C?o00[oool200002_ooo`800003oooo100000;oool00`000?ooooooo`1foooo001W
oooo7S?o09_oool006OooolN<ol0Voooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {501.875, 360.563}} -> {-0.349561, \
2.55153, 0.00349883, 0.00566123}, {{79.875, 308.563}, {501.875, 360.563}} -> \
{-2.52168, 4.7054, 0.0124465, 0.0127866}, {{79.875, 308.563}, {501.875, \
360.563}} -> {-2.52168, 4.7054, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59405 .30902 L
.59975 .30902 L
.60256 .30902 L
.60521 .30902 L
.60637 .30902 L
.60759 .30902 L
s
.60759 .30902 m
.60765 .61803 L
s
0 .4 1 r
.02381 .39209 m
.04262 .41601 L
.06244 .438 L
.06747 .4431 L
.07024 .44583 L
.0716 .44715 L
.07286 .44836 L
.07404 .44949 L
.07529 .44934 L
.07655 .4481 L
.07793 .44674 L
.08255 .44229 L
.10458 .42298 L
.14487 .39448 L
.18364 .37362 L
.22486 .35673 L
.26457 .3443 L
.30277 .33498 L
.32408 .33063 L
.34341 .32712 L
.38254 .32186 L
.40179 .32 L
.42261 .31835 L
.46361 .31586 L
.5031 .31414 L
.54107 .31291 L
.56221 .31237 L
.58149 .31194 L
.59106 .31174 L
.59611 .31165 L
.60147 .31155 L
.60372 .31151 L
.60615 .31147 L
.60682 .31146 L
.60754 .31144 L
.60881 .30902 L
.61 .30902 L
.61131 .30902 L
.6125 .30902 L
.61358 .30902 L
.61484 .30902 L
.61602 .30902 L
.61711 .30902 L
.61812 .30902 L
.61923 .30902 L
.6204 .30902 L
.62161 .30902 L
.62293 .30902 L
.62418 .30902 L
.62533 .30902 L
Mistroke
.62648 .30902 L
.62752 .30902 L
.62871 .30902 L
.62984 .30902 L
.63107 .30902 L
.63238 .30902 L
.63349 .30902 L
.63471 .30902 L
.63603 .30902 L
.63676 .30902 L
.63744 .30902 L
.63867 .30902 L
.63998 .30902 L
.64109 .30902 L
.64232 .30902 L
.64344 .30902 L
.64449 .30902 L
.64572 .30902 L
.64685 .30902 L
.64808 .30902 L
.64939 .30902 L
.65045 .30902 L
.65159 .30902 L
.65267 .30902 L
.65364 .30902 L
.65479 .30902 L
.65603 .30902 L
.65721 .30902 L
.65829 .30902 L
.65955 .30902 L
.66074 .30902 L
.66181 .30902 L
.66298 .30902 L
.66424 .30902 L
.66488 .30902 L
.66559 .30902 L
.66684 .30902 L
.66801 .30902 L
.66912 .30902 L
.67029 .30902 L
.67128 .30902 L
.67238 .30902 L
.67356 .30902 L
.67482 .30902 L
.67601 .30902 L
.67709 .30902 L
.67838 .30902 L
.67903 .30902 L
.67974 .30902 L
.681 .30902 L
Mistroke
.68218 .30902 L
.6829 .30902 L
.68358 .30902 L
.68485 .30902 L
.68551 .30902 L
.68622 .30902 L
.68699 .30902 L
.68771 .30902 L
.68901 .30902 L
.68975 .30902 L
.69042 .30902 L
.69166 .30902 L
.69297 .30902 L
.69415 .30902 L
.69525 .30902 L
.69645 .30902 L
.69774 .30902 L
.69896 .30902 L
.69967 .30902 L
.70031 .30902 L
.70099 .30902 L
.70172 .30902 L
.70304 .30902 L
.70557 .30902 L
.70681 .30902 L
.70793 .30902 L
.70917 .30902 L
.70986 .30902 L
.71051 .30902 L
.71121 .30902 L
.71186 .30902 L
.71257 .30902 L
.71332 .30902 L
.714 .30902 L
.71472 .30902 L
.71603 .30902 L
.71682 .30902 L
.71758 .30902 L
.71826 .30902 L
.719 .30902 L
.71966 .30902 L
.72037 .30902 L
.72166 .30902 L
.72291 .30902 L
.72406 .30902 L
.72531 .30902 L
.72602 .30902 L
.72668 .30902 L
.72738 .30902 L
.72802 .30902 L
Mistroke
.72875 .30902 L
.72945 .30902 L
.73062 .30902 L
.73186 .30902 L
.73292 .30902 L
.73409 .30902 L
.73534 .30902 L
.73604 .30902 L
.73669 .30902 L
.73794 .30902 L
.73913 .30902 L
.74037 .30902 L
.74107 .30902 L
.74171 .30902 L
.7429 .30902 L
.74415 .30902 L
.74527 .30902 L
.74632 .30902 L
.74747 .30902 L
.74871 .30902 L
.75002 .30902 L
.75076 .30902 L
.75145 .30902 L
.75271 .30902 L
.75335 .30902 L
.75405 .30902 L
.75526 .30902 L
.75656 .30902 L
.75779 .30902 L
.75892 .30902 L
.75999 .30902 L
.76114 .30902 L
.76222 .30902 L
.7632 .30902 L
.76435 .30902 L
.7656 .30902 L
.76679 .30902 L
.76788 .30902 L
.769 .30902 L
.77006 .30902 L
.77121 .30902 L
.77246 .30902 L
.77376 .30902 L
.77499 .30902 L
.7761 .30902 L
.77731 .30902 L
.77796 .30902 L
.77864 .30902 L
.77987 .30902 L
.78119 .30902 L
Mistroke
.78193 .30902 L
.78263 .30902 L
.7839 .30902 L
.78505 .30902 L
.78569 .30902 L
.78638 .30902 L
.78764 .30902 L
.78886 .30902 L
.79001 .30902 L
.7912 .30902 L
.79251 .30902 L
.79364 .30902 L
.79468 .30902 L
.79581 .30902 L
.79701 .30902 L
.79833 .30902 L
.79952 .30902 L
.80019 .30902 L
.8009 .30902 L
.80221 .30902 L
.80343 .30902 L
.80472 .30902 L
.80582 .30902 L
.80704 .30902 L
.80771 .30902 L
.80844 .30902 L
.80913 .30902 L
.80977 .30902 L
.81051 .30902 L
.8113 .30902 L
.81196 .30902 L
.8127 .30902 L
.81401 .30902 L
.81475 .30902 L
.81543 .30902 L
.81668 .30902 L
.81799 .30902 L
.81922 .30902 L
.81991 .30902 L
.82056 .30902 L
.82173 .30902 L
.82298 .30902 L
.82409 .30902 L
.82514 .30902 L
.82628 .30902 L
.82751 .30902 L
.82882 .30902 L
.82956 .30902 L
.83024 .30902 L
.83094 .30902 L
Mistroke
.8316 .30902 L
.83283 .30902 L
.83397 .30902 L
.83519 .30902 L
.8365 .30902 L
.8377 .30902 L
.83876 .30902 L
.8399 .30902 L
.84098 .30902 L
.84196 .30902 L
.8431 .30902 L
.84435 .30902 L
.84553 .30902 L
.84663 .30902 L
.84776 .30902 L
.849 .30902 L
.85032 .30902 L
.85152 .30902 L
.85259 .30902 L
.85371 .30902 L
.85483 .30902 L
.85606 .30902 L
.85738 .30902 L
.85859 .30902 L
.85923 .30902 L
.85993 .30902 L
.86066 .30902 L
.86134 .30902 L
.8626 .30902 L
.86375 .30902 L
.86438 .30902 L
.86508 .30902 L
.86633 .30902 L
.86757 .30902 L
.86868 .30902 L
.86997 .30902 L
.87118 .30902 L
.87231 .30902 L
.87334 .30902 L
.87447 .30902 L
.87567 .30902 L
.87698 .30902 L
.87817 .30902 L
.87883 .30902 L
.87955 .30902 L
.88085 .30902 L
.88206 .30902 L
.88335 .30902 L
.88445 .30902 L
.88567 .30902 L
Mistroke
.8864 .30902 L
.88709 .30902 L
.88839 .30902 L
.88912 .30902 L
.88979 .30902 L
.89053 .30902 L
.89132 .30902 L
.89201 .30902 L
.89275 .30902 L
.89346 .30902 L
.8941 .30902 L
.89533 .30902 L
.89662 .30902 L
.89784 .30902 L
.89853 .30902 L
.89917 .30902 L
.90033 .30902 L
.90157 .30902 L
.90268 .30902 L
.90372 .30902 L
.90486 .30902 L
.90609 .30902 L
.90732 .30902 L
.90802 .30902 L
.90867 .30902 L
.90998 .30902 L
.91072 .30902 L
.91139 .30902 L
.91258 .30902 L
.91388 .30902 L
.91511 .30902 L
.91624 .30902 L
.9173 .30902 L
.91843 .30902 L
.9195 .30902 L
.92048 .30902 L
.92162 .30902 L
.92287 .30902 L
.92405 .30902 L
.92514 .30902 L
.92638 .30902 L
.92754 .30902 L
.92859 .30902 L
.92971 .30902 L
.93093 .30902 L
.93204 .30902 L
.93336 .30902 L
.93457 .30902 L
.93579 .30902 L
.93644 .30902 L
Mistroke
.93712 .30902 L
.93827 .30902 L
.93954 .30902 L
.94066 .30902 L
.94187 .30902 L
.94301 .30902 L
.94406 .30902 L
.94529 .30902 L
.94643 .30902 L
.94768 .30902 L
.94838 .30902 L
.94902 .30902 L
.9503 .30902 L
.95103 .30902 L
.9517 .30902 L
.95293 .30902 L
.95423 .30902 L
.95537 .30902 L
.95641 .30902 L
.95761 .30902 L
.95875 .30902 L
.9598 .30902 L
.96079 .30902 L
.96193 .30902 L
.96297 .30902 L
.96411 .30902 L
.96535 .30902 L
.9665 .30902 L
.96756 .30902 L
.96873 .30902 L
.97 .30902 L
.97064 .30902 L
.97133 .30902 L
.97257 .30902 L
.97346 .30902 L
.97443 .30902 L
.97535 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`000c?o0080I_l00`00001V
o`1Vo`0506Ko00<00000I_l0I_l01@1Vo`04000006Ko06Ko06Ko13?o00030000<ol0<ol000Dco`00
0`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0003
<ol0;00000Ooool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool09Oooo`030000oooooooo
02Koool00`0003?o03?o000G<ol03P1Vo`03000006Ko06Ko00<0I_lE<ol000?o09Tco`0co`002S?o
00030000<ol0<ol0014co`0:00002_ooo`030000oooooooo02Koool00`000?ooooooo`0Eoooo001W
oooo00<0000co`0co`002S?o00d0I_lY<ol000?o09Tco`0co`0053?o00X0001Eoooo001Woooo0P00
00@co`0706Ko=S?o0003o`2I<ol0<ol000hco`060000Goooo`00IOooo`80I_l00`00001Vo`1Vo`03
06Ko?C?o0003o`2I<ol0<ol000Xco`040000IOooo`00H?ooo`D0I_l2oooo00<0000co`0co`00@3?o
0003o`2I<ol0<ol000Pco`020000JOooo`00Foooo`D0I_l7oooo00<0000co`0co`00@3?o0003o`2I
<ol0<ol000Dco`030000Joooo`00E_ooo`D0I_l<oooo0P00044co`000ol0VC?o03?o0003<ol00P00
06koool005;oool406Ko4Oooo`030000<ol0<ol0040co`001?l0VC?o03?o03?o0080001`oooo001@
oooo0P1VoaGoool00`0003?o03?o0010<ol000Co09Tco`000000001boooo001=oooo0`1VoaOoool0
0`0003?o03?o0010<ol000?o09T0003oool0Loooo`00Boooo`80I_lJoooo0P00040co`000`000?l0
VOooo`1doooo0018oooo0`1Voacoool00`0003?o03?o000n<ol000<0003ooooo09T0MOooo`00A_oo
o`80I_lOoooo00<0000co`0co`00?3?o00800002oooo00?o09Woooooool0Loooo`00@oooo`<0I_lQ
oooo00<0000co`0co`00>c?o00030000oooooooo00;oool00ol0VOooooooo`1coooo0011oooo0P1V
obCoool20000>c?o00030000oooooooo00?oool00ol0VOooooooo`1coooo000ooooo0P1VobKoool0
0`0003?o03?o000i<ol000<0003oooooool01?ooo`03o`2Ioooooooo07?oool003goool206Ko3ooo
o`800004oooo0P0000?oool400000oooo`800005oooo00<0000co`0co`00=c?o00800007oooo00?o
09Woooooool0Loooo`00>oooo`80I_l@oooo00@0003oooooool00008oooo00<0003oooooool00ooo
o`040000oooooooo00001?ooo`030000<ol0<ol003Hco`000`000?ooooooo`07oooo00?o09Wooooo
ool0Loooo`00>Oooo`80I_lBoooo00@0003oooooool00009oooo00<0003oooooool01Oooo`030000
oooooooo00;oool20000=S?o00030000oooooooo00Soool00ol0VOooooooo`1coooo000Foooo00<0
I_ooooooool07_ooo`80I_lDoooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005
oooo00<0000co`0co`00=3?o00030000oooooooo00Woool00ol0VOooooooo`1coooo000Goooo00<0
I_ooooooool06oooo`80I_lFoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0
003oooooool01?ooo`030000<ol0<ol003@co`000`000?ooooooo`09oooo00?o09Woooooool0Looo
o`005oooo`0306Kooooooooo01Woool206Ko6Oooo`80000:oooo0P0000Coool300001?ooo`030000
<ol0<ol003<co`000`000?ooooooo`0:oooo00?o09Woooooool0Loooo`006?ooo`0306Kooooooooo
01Ooool00`1Vooooooooo`0boooo0P0003<co`000`000?ooooooo`0;oooo00?o09Woooooool0Looo
o`006Oooo`0306Kooooooooo01Goool00`1Vooooooooo`0coooo00<0000co`0co`00<C?o00030000
oooooooo00coool00ol0VOooooooo`1coooo000Joooo00<0I_ooooooool04_ooo`80I_lfoooo00<0
000co`0co`00<C?o00030000oooooooo00coool00ol0VOooooooo`1coooo000Joooo00<0I_oooooo
ool04Oooo`0306Kooooooooo03Koool00`0003?o03?o000`<ol000<0003oooooool03Oooo`03o`2I
oooooooo07?oool001_oool00`1Vooooooooo`0>oooo0P1VocWoool20000<3?o00030000oooooooo
00koool00ol0VOooooooo`1coooo000Loooo00<0I_ooooooool03?ooo`0306Kooooooooo03Woool0
0`0003?o03?o000_<ol000<0003oooooool03_ooo`03o`2Ioooooooo07?oool001goool00`1Voooo
ooooo`0:oooo00<0I_ooooooool0>_ooo`030000<ol0<ol002hco`000`000?ooooooo`0?oooo00?o
09Woooooool0Loooo`007_ooo`0306Kooooooooo00Soool00`1Vooooooooo`0koooo00<0000co`0c
o`00;S?o00030000oooooooo00ooool00ol0VOooooooo`1coooo000Ooooo00<0I_ooooooool01Ooo
o`80I_lnoooo0P0002hco`000`000?ooooooo`0@oooo00?o09Woooooool0Loooo`008?ooo`0306Ko
oooooooo00?oool00`1Vooooooooo`0noooo00<0000co`0co`00;C?o00030000oooooooo013oool0
0ol0VOooooooo`1coooo000Qoooo00D0I_ooooooooooool0I_l0@Oooo`030000<ol0<ol002`co`00
0`000?ooooooo`0Aoooo00?o09Woooooool0Loooo`008_ooo`0306Kooooo06Ko04;oool00`0003?o
03?o000/<ol000<0003oooooool04Oooo`03o`2Ioooooooo07?oool002?oool206Ko@_ooo`80000/
<ol000<0003oooooool04_ooo`03o`2Ioooooooo07?oool006Ooool00`0003?o03?o000[<ol000<0
003oooooool04_ooo`03o`2Ioooooooo07?oool005Coool200001?ooo`800004oooo0P0000Goool0
0`0003?o03?o000Z<ol000<0003oooooool04oooo`03o`2Ioooooooo07?oool005?oool010000?oo
ooooo`0000Soool010000?ooooooo`0000Coool00`0003?o03?o000Z<ol000<0003oooooool04ooo
o`03o`2Ioooooooo07?oool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
02Xco`000`000?ooooooo`0Doooo00?o09Woooooool0Loooo`00Doooo`040000oooooooo00002Ooo
o`800005oooo00<0000co`0co`00:C?o00030000oooooooo01Coool00ol0VOooooooo`1coooo001C
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000<ol0<ol002Pco`000`000?oo
ooooo`0Eoooo00?o09Woooooool0Loooo`00E?ooo`80000:oooo0`0000Coool00`0003?o03?o000X
<ol000<0003oooooool05Oooo`03o`2Ioooooooo07?oool006Ooool20000:C?o00030000oooooooo
01Goool00ol0VOooooooo`1coooo001Woooo00<0000co`0co`009c?o00030000oooooooo01Koool0
0ol0VOooooooo`1coooo001Woooo00<0000co`0co`009c?o00030000oooooooo01Koool00ol0VOoo
ooooo`1coooo001Woooo0P0002Lco`000`000?ooooooo`0Goooo00?o09Woooooool0Loooo`00Iooo
o`030000<ol0<ol002Hco`000`000?ooooooo`0Goooo00?o09Woooooool0Loooo`00Ioooo`030000
<ol0<ol002Hco`000`000?ooooooo`0Goooo00?o09Woooooool0Loooo`00Ioooo`030000<ol0<ol0
02Dco`000`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Ioooo`80000V<ol000<0003ooooo
ool06?ooo`03o`2Ioooooooo07?oool006Ooool00`0003?o03?o000U<ol000<0003oooooool06?oo
o`03o`2Ioooooooo07?oool006Ooool00`0003?o03?o000U<ol000<0003oooooool06?ooo`03o`2I
oooooooo07?oool006Ooool00`0003?o03?o000T<ol000<0003oooooool06Oooo`03o`2Ioooooooo
07?oool006Ooool200009C?o00030000oooooooo01Woool00ol0VOooooooo`1coooo001Woooo00<0
000co`0co`0093?o00030000oooooooo01Woool00ol0VOooooooo`1coooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000<ol0<ol002<co`000`000?ooooooo`0J
oooo00?o09Woooooool0Loooo`00COooo`040000oooooooo00002_ooo`050000oooooooooooo0000
00;oool00`000?ooooooo`02oooo00<0000co`0co`008c?o00030000oooooooo01[oool00ol0VOoo
ooooo`1coooo001=oooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000oooooooo
00;oool2000093?o00030000oooooooo01[oool00ol0VOooooooo`1coooo001=oooo00@0003ooooo
ool0000;oooo00@0003oooooooooool200001Oooo`030000<ol0<ol0028co`000`000?ooooooo`0K
oooo00?o09Woooooool0Loooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`0003?o03?o000R<ol000<0003oooooool06oooo`03o`2Ioooooooo
07?oool004koool200002Oooo`@00003oooo0`0000Coool00`0003?o03?o000R<ol000<0003ooooo
ool06oooo`03o`2Ioooooooo07?oool006Ooool200008c?o00030000oooooooo01_oool00ol0VOoo
ooooo`1coooo001Woooo00<0000co`0co`008C?o00030000oooooooo01coool00ol0VOooooooo`1c
oooo001Woooo00<0000co`0co`008C?o00030000oooooooo01coool00ol0VOooooooo`1coooo001W
oooo00<0000co`0co`008C?o00030000oooooooo01coool00ol0VOooooooo`1coooo001Woooo0P00
028co`000`000?ooooooo`0Loooo00?o09Woooooool0Loooo`00Ioooo`030000<ol0<ol0020co`00
0`000?ooooooo`0Moooo00?o09Woooooool0Loooo`00Ioooo`030000<ol0<ol0020co`000`000?oo
ooooo`0Moooo00?o09Woooooool0Loooo`00Ioooo`030000<ol0<ol0020co`000`000?ooooooo`0M
oooo00?o09Woooooool0Loooo`00Ioooo`80000Q<ol000<0003oooooool07Oooo`03o`2Ioooooooo
07?oool006Ooool00`0003?o03?o000O<ol000<0003oooooool07_ooo`03o`2Ioooooooo07?oool0
06Ooool00`0003?o03?o000O<ol000<0003oooooool07_ooo`03o`2Ioooooooo07?oool006Ooool0
0`0003?o03?o000O<ol000<0003oooooool07_ooo`03o`2Ioooooooo07?oool006Ooool2000083?o
00030000oooooooo01koool00ol0VOooooooo`1coooo001Woooo00<0000co`0co`007c?o00030000
oooooooo01koool00ol0VOooooooo`1coooo001Ooooo1@0000?oool00`0003?o03?o000N<ol000<0
003oooooool07oooo`03o`2Ioooooooo07?oool0067oool00`000?ooooooo`03oooo00<0000co`0c
o`007S?o00030000oooooooo01ooool00ol0VOooooooo`1coooo001Qoooo00<0003oooooool00ooo
o`80000O<ol000<0003oooooool07oooo`03o`2Ioooooooo07?oool0067oool00`000?ooooooo`03
oooo8C?o09Soool0067oool00`000?ooooooo`03oooo8C?o09Soool0063oool200001Oooob4co`2H
oooo001Woooo83?o09Woool006OooolP<ol0VOooo`00Ioooo`lco`000`0003?o03?o000><ol08?oo
o`030000oooooooo07Koool006Ooool><ol000<0000co`0co`0023?o00030000<ol0<ol000@co`0Q
oooo00<0003oooooool0MOooo`00Ioooo`hco`000`0003?o03?o0002<ol00P0000@co`000`0003?o
03?o0003<ol02_ooo`800004oooo0P0000?oool5000000Coool0000000000004oooo00<0003ooooo
ool0MOooo`00Ioooo`hco`001@0003?o03?o03?o00000002<ol000<0000co`0co`000S?o00030000
<ol0<ol0008co`02oooo100000?oool010000?ooooooo`0000[oool01@000?ooooooooooo`000002
oooo00D0003oooooooooool00000Moooo`00Ioooo`dco`000`0003?o03?o0002<ol000<0000co`0c
o`002S?o00Woool010000?ooooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo07Coool006Ooool><ol000<0000co`0co`001@0000Tco`09oooo00@0
003oooooool0000:oooo00@0003oooooooooool300001?ooo`030000oooooooo07Goool006Ooool>
<ol000D0000co`0co`0co`00000033?o00Woool010000?ooooooo`0000[oool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo07Goool006Ooool?<ol000<0000co`0co`003C?o
00[oool200002_ooo`800004oooo0`0000;oool00`000?ooooooo`1foooo001Woooo7S?o09_oool0
06OooolN<ol0Voooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {650.563, 509.25}} -> {-0.349561, \
3.60372, 0.00349883, 0.00566123}, {{79.875, 308.563}, {650.563, 509.25}} -> \
{-2.52168, 7.08191, 0.0124465, 0.0127866}, {{79.875, 308.563}, {650.563, \
509.25}} -> {-2.52168, 7.08191, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59975 .30902 L
.60479 .30902 L
.60756 .30902 L
.60891 .30902 L
.61016 .30902 L
s
.61016 .30902 m
.61028 .61803 L
s
0 .4 1 r
.02381 .38772 m
.04262 .4122 L
.0522 .42346 L
.06244 .43469 L
.06525 .43762 L
.0679 .44033 L
.07027 .44273 L
.07093 .44338 L
.07162 .4437 L
.07286 .44252 L
.08255 .43364 L
.10458 .41559 L
.14241 .39035 L
.1827 .36984 L
.22147 .35477 L
.2627 .34249 L
.30241 .33336 L
.3406 .3264 L
.36192 .32333 L
.38125 .32116 L
.42038 .31789 L
.43962 .31668 L
.46044 .31557 L
.50145 .31387 L
.54093 .31266 L
.5789 .3118 L
.59841 .31144 L
.60403 .31134 L
.6068 .3113 L
.60801 .31128 L
.60935 .31126 L
.61055 .31124 L
.61167 .30902 L
.61285 .30902 L
.61413 .30902 L
.61545 .30902 L
.61612 .30902 L
.61684 .30902 L
.61813 .30902 L
.61933 .30902 L
.6206 .30902 L
.62178 .30902 L
.62302 .30902 L
.62367 .30902 L
.62438 .30902 L
.62514 .30902 L
.62587 .30902 L
.62652 .30902 L
.62723 .30902 L
.62789 .30902 L
Mistroke
.62859 .30902 L
.62985 .30902 L
.63114 .30902 L
.63182 .30902 L
.63254 .30902 L
.63385 .30902 L
.63507 .30902 L
.63623 .30902 L
.63732 .30902 L
.63851 .30902 L
.63979 .30902 L
.64218 .30902 L
.64284 .30902 L
.64353 .30902 L
.64479 .30902 L
.64595 .30902 L
.64703 .30902 L
.64823 .30902 L
.64951 .30902 L
.65059 .30902 L
.65177 .30902 L
.65292 .30902 L
.65414 .30902 L
.65529 .30902 L
.65633 .30902 L
.65738 .30902 L
.65837 .30902 L
.65953 .30902 L
.66078 .30902 L
.66195 .30902 L
.66302 .30902 L
.66427 .30902 L
.66498 .30902 L
.66564 .30902 L
.66684 .30902 L
.66812 .30902 L
.66934 .30902 L
.67065 .30902 L
.67188 .30902 L
.67302 .30902 L
.67428 .30902 L
.67499 .30902 L
.67565 .30902 L
.67635 .30902 L
.67699 .30902 L
.67773 .30902 L
.67843 .30902 L
.67958 .30902 L
.68066 .30902 L
.68179 .30902 L
Mistroke
.68303 .30902 L
.6841 .30902 L
.68508 .30902 L
.68621 .30902 L
.68728 .30902 L
.68844 .30902 L
.68967 .30902 L
.69083 .30902 L
.69188 .30902 L
.69312 .30902 L
.69382 .30902 L
.69446 .30902 L
.69564 .30902 L
.69689 .30902 L
.69811 .30902 L
.6988 .30902 L
.69944 .30902 L
.70061 .30902 L
.70186 .30902 L
.70297 .30902 L
.70401 .30902 L
.70515 .30902 L
.70638 .30902 L
.70703 .30902 L
.70772 .30902 L
.70896 .30902 L
.71026 .30902 L
.71101 .30902 L
.71168 .30902 L
.71288 .30902 L
.71419 .30902 L
.71541 .30902 L
.71655 .30902 L
.7176 .30902 L
.71874 .30902 L
.71981 .30902 L
.72079 .30902 L
.72194 .30902 L
.72318 .30902 L
.72436 .30902 L
.72546 .30902 L
.72669 .30902 L
.72785 .30902 L
.7289 .30902 L
.73002 .30902 L
.73126 .30902 L
.73256 .30902 L
.73367 .30902 L
.73488 .30902 L
.73611 .30902 L
Mistroke
.73741 .30902 L
.73809 .30902 L
.73883 .30902 L
.74015 .30902 L
.74139 .30902 L
.74207 .30902 L
.74272 .30902 L
.74398 .30902 L
.74513 .30902 L
.74624 .30902 L
.74744 .30902 L
.74856 .30902 L
.74958 .30902 L
.75078 .30902 L
.75209 .30902 L
.75332 .30902 L
.75445 .30902 L
.75566 .30902 L
.75696 .30902 L
.75818 .30902 L
.7593 .30902 L
.76061 .30902 L
.76135 .30902 L
.76203 .30902 L
.76329 .30902 L
.76392 .30902 L
.76462 .30902 L
.7653 .30902 L
.76602 .30902 L
.76729 .30902 L
.76801 .30902 L
.76867 .30902 L
.76939 .30902 L
.77017 .30902 L
.77084 .30902 L
.77157 .30902 L
.77226 .30902 L
.7729 .30902 L
.7741 .30902 L
.77538 .30902 L
.77659 .30902 L
.77791 .30902 L
.77915 .30902 L
.78031 .30902 L
.78145 .30902 L
.78249 .30902 L
.78368 .30902 L
.78481 .30902 L
.78605 .30902 L
.78735 .30902 L
Mistroke
.78846 .30902 L
.78968 .30902 L
.791 .30902 L
.79173 .30902 L
.79241 .30902 L
.79371 .30902 L
.79495 .30902 L
.796 .30902 L
.79716 .30902 L
.79837 .30902 L
.79951 .30902 L
.80056 .30902 L
.80153 .30902 L
.8026 .30902 L
.80372 .30902 L
.80486 .30902 L
.80608 .30902 L
.80723 .30902 L
.80828 .30902 L
.80951 .30902 L
.8102 .30902 L
.81084 .30902 L
.81201 .30902 L
.81326 .30902 L
.81447 .30902 L
.81579 .30902 L
.81704 .30902 L
.8182 .30902 L
.81924 .30902 L
.82039 .30902 L
.82158 .30902 L
.82271 .30902 L
.82395 .30902 L
.82526 .30902 L
.82637 .30902 L
.82759 .30902 L
.82891 .30902 L
.82965 .30902 L
.83032 .30902 L
.83163 .30902 L
.83286 .30902 L
.83392 .30902 L
.83508 .30902 L
.83629 .30902 L
.83743 .30902 L
.83849 .30902 L
.83946 .30902 L
.84058 .30902 L
.84165 .30902 L
.84279 .30902 L
Mistroke
.84401 .30902 L
.84516 .30902 L
.84621 .30902 L
.84744 .30902 L
.84813 .30902 L
.84877 .30902 L
.84994 .30902 L
.85118 .30902 L
.8524 .30902 L
.85309 .30902 L
.85373 .30902 L
.8549 .30902 L
.85614 .30902 L
.85725 .30902 L
.85829 .30902 L
.85943 .30902 L
.86066 .30902 L
.8619 .30902 L
.8626 .30902 L
.86325 .30902 L
.86456 .30902 L
.8653 .30902 L
.86597 .30902 L
.86717 .30902 L
.86847 .30902 L
.86969 .30902 L
.87083 .30902 L
.87188 .30902 L
.87302 .30902 L
.87409 .30902 L
.87507 .30902 L
.87621 .30902 L
.87746 .30902 L
.87864 .30902 L
.87973 .30902 L
.88097 .30902 L
.88213 .30902 L
.88317 .30902 L
.8843 .30902 L
.88553 .30902 L
.88683 .30902 L
.88794 .30902 L
.88916 .30902 L
.89047 .30902 L
.89168 .30902 L
.89232 .30902 L
.89301 .30902 L
.89375 .30902 L
.89442 .30902 L
.89566 .30902 L
Mistroke
.89634 .30902 L
.89699 .30902 L
.89814 .30902 L
.8994 .30902 L
.9006 .30902 L
.90173 .30902 L
.90304 .30902 L
.90423 .30902 L
.90526 .30902 L
.90637 .30902 L
.90758 .30902 L
.90872 .30902 L
.9094 .30902 L
.91005 .30902 L
.91126 .30902 L
.91255 .30902 L
.91328 .30902 L
.91395 .30902 L
.91506 .30902 L
.91628 .30902 L
.91756 .30902 L
.91877 .30902 L
.9194 .30902 L
.9201 .30902 L
.92082 .30902 L
.9215 .30902 L
.92271 .30902 L
.924 .30902 L
.92473 .30902 L
.92552 .30902 L
.92627 .30902 L
.92696 .30902 L
.92826 .30902 L
.92892 .30902 L
.92965 .30902 L
.93094 .30902 L
.93214 .30902 L
.93287 .30902 L
.93356 .30902 L
.93485 .30902 L
.936 .30902 L
.93725 .30902 L
.93789 .30902 L
.93857 .30902 L
.9398 .30902 L
.9409 .30902 L
.94209 .30902 L
.9432 .30902 L
.94422 .30902 L
.94542 .30902 L
Mistroke
.94671 .30902 L
.94794 .30902 L
.94908 .30902 L
.95027 .30902 L
.95156 .30902 L
.95278 .30902 L
.95389 .30902 L
.95454 .30902 L
.95523 .30902 L
.95648 .30902 L
.95778 .30902 L
.95853 .30902 L
.95921 .30902 L
.95988 .30902 L
.96059 .30902 L
.96186 .30902 L
.96257 .30902 L
.96323 .30902 L
.96396 .30902 L
.96474 .30902 L
.96541 .30902 L
.96614 .30902 L
.96683 .30902 L
.96747 .30902 L
.96868 .30902 L
.96996 .30902 L
.97077 .30902 L
.97151 .30902 L
.97232 .30902 L
.97317 .30902 L
.97392 .30902 L
.97461 .30902 L
.97537 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`000c?o0080I_l00`00001V
o`1Vo`0506Ko00<00000I_l0I_l01@1Vo`03000006Ko06Ko0080I_l3<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00<co`0/00001oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0003ooooo
ool09_ooo`030000<ol0<ol001@co`0A06Ko00<00000I_l0I_l00`1VoaHco`000ol0VC?o03?o0009
<ol000<0000co`0co`004C?o00X0000:oooo00<0003oooooool09_ooo`030000oooooooo01Goool0
06Ooool00`0003?o03?o0005<ol03`1Vobdco`000ol0VC?o03?o000C<ol02P0005Goool006Ooool2
000000<co`00I_l0I_l00`1Voc`co`000ol0VC?o03?o000=<ol01P0005ooool006Goool206Ko00<0
0000I_l0I_l0@C?o0003o`2I<ol0<ol000Tco`040000IOooo`00H?ooo`D0I_l2oooo00<0000co`0c
o`00@C?o0003o`2I<ol0<ol000Lco`020000JOooo`00Foooo`D0I_l7oooo00<0000co`0co`00@C?o
0003o`2I<ol0<ol000@co`030000Joooo`00E_ooo`D0I_l<oooo0P00048co`000ol0VC?o03?o0002
<ol00P0006koool005;oool406Ko4Oooo`030000<ol0<ol0044co`000ol0VC?o03?o00020000L?oo
o`00C_ooo`@0I_lEoooo00<0000co`0co`00@C?o0003o`2I0000000007;oool004[oool406Ko6Ooo
o`030000<ol0<ol0040co`000`000?l0VOooo`1coooo0017oooo0`1Voagoool20000@3?o00030000
ooooo`2I07Coool004Goool206Ko8?ooo`030000<ol0<ol003hco`0010000?ooooooool0VGCoool0
04?oool206Ko8_ooo`030000<ol0<ol003`co`0200000oooo`03o`2Ioooooooo07;oool0047oool2
06Ko9?ooo`030000<ol0<ol003/co`000`000?ooooooo`03oooo00?o09Woooooool0L_ooo`00?_oo
o`<0I_lVoooo0P0003/co`000`000?ooooooo`04oooo00?o09Woooooool0L_ooo`00??ooo`80I_lY
oooo00<0000co`0co`00>C?o00030000oooooooo00Goool00ol0VOooooooo`1boooo000joooo0P1V
oa;oool200001?ooo`800003oooo100000?oool200001Oooo`030000<ol0<ol003Lco`0200002?oo
o`03o`2Ioooooooo07;oool003Soool206Ko4oooo`040000oooooooo00002?ooo`030000oooooooo
00?oool010000?ooooooo`0000Coool00`0003?o03?o000f<ol000<0003oooooool02?ooo`03o`2I
oooooooo07;oool001Koool00`1Vooooooooo`0Moooo0P1VoaGoool010000?ooooooo`0000Woool0
0`000?ooooooo`05oooo00<0003oooooool00_ooo`80000f<ol000<0003oooooool02Oooo`03o`2I
oooooooo07;oool001Ooool00`1Vooooooooo`0Joooo0P1VoaOoool010000?ooooooo`0000[oool0
0`000?ooooooo`02oooo0P0000Goool00`0003?o03?o000d<ol000<0003oooooool02_ooo`03o`2I
oooooooo07;oool001Ooool00`1Vooooooooo`0Hoooo0P1VoaWoool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0000co`0co`00=3?o00030000oooooooo
00[oool00ol0VOooooooo`1boooo000Hoooo00<0I_ooooooool05_ooo`0306Kooooooooo01[oool2
00002_ooo`800004oooo0`0000Coool00`0003?o03?o000c<ol000<0003oooooool02oooo`03o`2I
oooooooo07;oool001Woool00`1Vooooooooo`0Coooo0P1VocKoool20000<c?o00030000oooooooo
00coool00ol0VOooooooo`1boooo000Joooo00<0I_ooooooool04Oooo`0306Kooooooooo03Koool0
0`0003?o03?o000a<ol000<0003oooooool03Oooo`03o`2Ioooooooo07;oool001[oool00`1Voooo
ooooo`0?oooo0P1VocWoool00`0003?o03?o000a<ol000<0003oooooool03Oooo`03o`2Ioooooooo
07;oool001_oool00`1Vooooooooo`0=oooo00<0I_ooooooool0>Oooo`030000<ol0<ol0030co`00
0`000?ooooooo`0>oooo00?o09Woooooool0L_ooo`007?ooo`0306Kooooooooo00_oool00`1Voooo
ooooo`0joooo0P00030co`000`000?ooooooo`0?oooo00?o09Woooooool0L_ooo`007Oooo`0306Ko
oooooooo00Woool00`1Vooooooooo`0koooo00<0000co`0co`00;c?o00030000oooooooo00ooool0
0ol0VOooooooo`1boooo000Noooo00<0I_ooooooool01_ooo`80I_lnoooo00<0000co`0co`00;S?o
00030000oooooooo013oool00ol0VOooooooo`1boooo000Ooooo00<0I_ooooooool01?ooo`0306Ko
oooooooo03koool00`0003?o03?o000^<ol000<0003oooooool04?ooo`03o`2Ioooooooo07;oool0
023oool00`1Vooooooooo`02oooo00<0I_ooooooool0?oooo`80000^<ol000<0003oooooool04Ooo
o`03o`2Ioooooooo07;oool0027oool0101Vooooooooo`1Vod;oool00`0003?o03?o000]<ol000<0
003oooooool04Oooo`03o`2Ioooooooo07;oool0027oool306Ko@oooo`030000<ol0<ol002`co`00
0`000?ooooooo`0Boooo00?o09Woooooool0L_ooo`008_ooo`0306Kooooooooo04;oool00`0003?o
03?o000/<ol000<0003oooooool04_ooo`03o`2Ioooooooo07;oool006Ooool20000;3?o00030000
oooooooo01?oool00ol0VOooooooo`1boooo001Woooo00<0000co`0co`00:c?o00030000oooooooo
01?oool00ol0VOooooooo`1boooo001Doooo0P0000Coool200001?ooo`800005oooo00<0000co`0c
o`00:S?o00030000oooooooo01Coool00ol0VOooooooo`1boooo001Coooo00@0003oooooool00008
oooo00@0003oooooool00004oooo00<0000co`0co`00:S?o00030000oooooooo01Coool00ol0VOoo
ooooo`1boooo001Coooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`80000Z<ol000<0
003oooooool05Oooo`03o`2Ioooooooo07;oool005?oool010000?ooooooo`0000Woool200001Ooo
o`030000<ol0<ol002Tco`000`000?ooooooo`0Eoooo00?o09Woooooool0L_ooo`00Doooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`0003?o03?o000X<ol000<0003oooooool05_oo
o`03o`2Ioooooooo07;oool005Coool200002_ooo`<00004oooo00<0000co`0co`00:3?o00030000
oooooooo01Koool00ol0VOooooooo`1boooo001Woooo0P0002Tco`000`000?ooooooo`0Foooo00?o
09Woooooool0L_ooo`00Ioooo`030000<ol0<ol002Lco`000`000?ooooooo`0Goooo00?o09Wooooo
ool0L_ooo`00Ioooo`030000<ol0<ol002Lco`000`000?ooooooo`0Goooo00?o09Woooooool0L_oo
o`00Ioooo`80000W<ol000<0003oooooool06?ooo`03o`2Ioooooooo07;oool006Ooool00`0003?o
03?o000V<ol000<0003oooooool06?ooo`03o`2Ioooooooo07;oool006Ooool00`0003?o03?o000V
<ol000<0003oooooool06?ooo`03o`2Ioooooooo07;oool006Ooool00`0003?o03?o000U<ol000<0
003oooooool06Oooo`03o`2Ioooooooo07;oool006Ooool200009S?o00030000oooooooo01Woool0
0ol0VOooooooo`1boooo001Woooo00<0000co`0co`009C?o00030000oooooooo01Woool00ol0VOoo
ooooo`1boooo001Woooo00<0000co`0co`009C?o00030000oooooooo01Woool00ol0VOooooooo`1b
oooo001Woooo00<0000co`0co`0093?o00030000oooooooo01[oool00ol0VOooooooo`1boooo001W
oooo0P0002Dco`000`000?ooooooo`0Joooo00?o09Woooooool0L_ooo`00Ioooo`030000<ol0<ol0
02@co`000`000?ooooooo`0Joooo00?o09Woooooool0L_ooo`00C_ooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`0003?o03?o000S<ol000<0003oooooool06oooo`03o`2I
oooooooo07;oool004goool010000?ooooooo`0000[oool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000<ol0<ol002<co`000`000?ooooooo`0Koooo00?o09Woooooool0L_oo
o`00COooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`02oooo0P00
02@co`000`000?ooooooo`0Koooo00?o09Woooooool0L_ooo`00COooo`040000oooooooo00002ooo
o`040000oooooooooooo0P0000Goool00`0003?o03?o000R<ol000<0003oooooool07?ooo`03o`2I
oooooooo07;oool004goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ooooo`04oooo00<0000co`0co`008S?o00030000oooooooo01coool00ol0VOooooooo`1boooo001>
oooo0P0000Woool400000oooo`<00004oooo00<0000co`0co`008S?o00030000oooooooo01coool0
0ol0VOooooooo`1boooo001Woooo0P0002<co`000`000?ooooooo`0Loooo00?o09Woooooool0L_oo
o`00Ioooo`030000<ol0<ol0024co`000`000?ooooooo`0Moooo00?o09Woooooool0L_ooo`00Iooo
o`030000<ol0<ol0024co`000`000?ooooooo`0Moooo00?o09Woooooool0L_ooo`00Ioooo`030000
<ol0<ol0024co`000`000?ooooooo`0Moooo00?o09Woooooool0L_ooo`00Ioooo`80000R<ol000<0
003oooooool07Oooo`03o`2Ioooooooo07;oool006Ooool00`0003?o03?o000P<ol000<0003ooooo
ool07_ooo`03o`2Ioooooooo07;oool006Ooool00`0003?o03?o000P<ol000<0003oooooool07_oo
o`03o`2Ioooooooo07;oool006Ooool00`0003?o03?o000P<ol000<0003oooooool07_ooo`03o`2I
oooooooo07;oool006Ooool200008C?o00030000oooooooo01koool00ol0VOooooooo`1boooo001W
oooo00<0000co`0co`007c?o00030000oooooooo01ooool00ol0VOooooooo`1boooo001Woooo00<0
000co`0co`007c?o00030000oooooooo01ooool00ol0VOooooooo`1boooo001Woooo00<0000co`0c
o`007c?o00030000oooooooo01ooool00ol0VOooooooo`1boooo001Woooo0P00020co`000`000?oo
ooooo`0Ooooo00?o09Woooooool0L_ooo`00Ioooo`030000<ol0<ol001lco`000`000?ooooooo`0O
oooo00?o09Woooooool0L_ooo`00Goooo`D00003oooo00<0000co`0co`007S?o00030000oooooooo
023oool00ol0VOooooooo`1boooo001Qoooo00<0003oooooool00oooo`030000<ol0<ol001hco`00
0`000?ooooooo`0Poooo00?o09Woooooool0L_ooo`00HOooo`030000oooooooo00?oool200007c?o
00030000oooooooo023oool00ol0VOooooooo`1boooo001Qoooo00<0003oooooool00oooob4co`2H
oooo001Qoooo00<0003oooooool00oooob4co`2Hoooo001Poooo0P0000GooolQ<ol0V?ooo`00Iooo
ob0co`2Ioooo001Woooo83?o09Woool006Ooool?<ol000<0000co`0co`003S?o023oool00`000?oo
ooooo`1foooo001Woooo3S?o00030000<ol0<ol000Pco`000`0003?o03?o0004<ol08Oooo`030000
oooooooo07Goool006Ooool><ol000<0000co`0co`000S?o00800004<ol000<0000co`0co`000c?o
00[oool200001?ooo`800003oooo1@0000;oool200001?ooo`030000oooooooo07Goool006Ooool>
<ol000D0000co`0co`0co`0000000S?o00030000<ol0<ol0008co`000`0003?o03?o0002<ol00_oo
o`@00003oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`050000oooooooo
oooo000007Ooool006Ooool=<ol000<0000co`0co`000S?o00030000<ol0<ol000Xco`09oooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`030000oooooooo00;oool00`000?ooooooo`1d
oooo001Woooo3S?o00030000<ol0<ol000D00009<ol02Oooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001?ooo`030000oooooooo07Goool006Ooool><ol000D0000co`0co`0co`00
000033?o00Woool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo07Goool006Ooool?<ol000<0000co`0co`003C?o00[oool200002_ooo`800004
oooo0`0000;oool00`000?ooooooo`1foooo001Woooo7S?o09_oool006OooolN<ol0Voooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {204.5, 63.1875}} -> {-0.349561, \
0.447144, 0.00349883, 0.00566123}, {{79.875, 308.563}, {204.5, 63.1875}} -> \
{-2.52168, -0.0476099, 0.0124465, 0.0127866}, {{79.875, 308.563}, {204.5, \
63.1875}} -> {-2.52168, -0.0476099, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.14) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59975 .30902 L
.60479 .30902 L
.60756 .30902 L
.61016 .30902 L
.6126 .30902 L
.61327 .30902 L
.61397 .30902 L
s
.61397 .30902 m
.6141 .61803 L
s
0 .4 1 r
.02381 .38326 m
.04262 .40829 L
.0522 .41981 L
.06244 .4313 L
.06525 .43429 L
.06662 .43574 L
.0679 .43707 L
.06905 .43672 L
.07027 .43562 L
.07286 .43332 L
.08255 .42506 L
.10458 .40824 L
.14241 .38475 L
.1827 .36565 L
.22147 .35162 L
.2627 .34019 L
.30241 .33169 L
.3406 .3252 L
.36192 .32235 L
.38125 .32032 L
.42038 .31728 L
.43962 .31615 L
.46044 .31512 L
.50145 .31353 L
.54093 .31241 L
.5789 .31161 L
.59841 .31127 L
.60403 .31118 L
.60935 .3111 L
.61167 .31107 L
.61294 .31105 L
.61413 .31103 L
.61541 .30902 L
.6161 .30902 L
.61683 .30902 L
.61813 .30902 L
.61933 .30902 L
.62061 .30902 L
.62181 .30902 L
.62289 .30902 L
.62407 .30902 L
.62535 .30902 L
.62599 .30902 L
.6267 .30902 L
.62796 .30902 L
.62913 .30902 L
.63031 .30902 L
.63143 .30902 L
.63243 .30902 L
.63353 .30902 L
Mistroke
.63472 .30902 L
.63598 .30902 L
.63717 .30902 L
.63825 .30902 L
.63955 .30902 L
.64021 .30902 L
.64092 .30902 L
.64219 .30902 L
.64338 .30902 L
.6441 .30902 L
.64478 .30902 L
.64605 .30902 L
.64677 .30902 L
.64743 .30902 L
.64815 .30902 L
.64892 .30902 L
.6501 .30902 L
.65138 .30902 L
.65259 .30902 L
.65369 .30902 L
.65492 .30902 L
.65561 .30902 L
.65626 .30902 L
.65756 .30902 L
.65829 .30902 L
.65895 .30902 L
.66015 .30902 L
.66127 .30902 L
.6625 .30902 L
.66382 .30902 L
.66448 .30902 L
.6652 .30902 L
.66651 .30902 L
.66778 .30902 L
.66896 .30902 L
.67005 .30902 L
.67108 .30902 L
.67221 .30902 L
.67343 .30902 L
.67463 .30902 L
.6759 .30902 L
.67699 .30902 L
.67818 .30902 L
.67885 .30902 L
.67958 .30902 L
.68027 .30902 L
.6809 .30902 L
.68211 .30902 L
.68338 .30902 L
.68404 .30902 L
Mistroke
.68475 .30902 L
.68603 .30902 L
.68682 .30902 L
.68756 .30902 L
.68823 .30902 L
.68895 .30902 L
.69027 .30902 L
.69147 .30902 L
.69214 .30902 L
.69286 .30902 L
.69416 .30902 L
.69538 .30902 L
.69667 .30902 L
.69778 .30902 L
.69899 .30902 L
.70029 .30902 L
.7015 .30902 L
.70218 .30902 L
.70283 .30902 L
.7035 .30902 L
.70423 .30902 L
.70548 .30902 L
.70663 .30902 L
.70788 .30902 L
.7092 .30902 L
.71032 .30902 L
.71151 .30902 L
.71263 .30902 L
.71365 .30902 L
.71485 .30902 L
.71615 .30902 L
.71738 .30902 L
.71851 .30902 L
.71972 .30902 L
.72101 .30902 L
.72224 .30902 L
.72335 .30902 L
.72466 .30902 L
.7254 .30902 L
.72608 .30902 L
.72734 .30902 L
.72804 .30902 L
.72868 .30902 L
.72935 .30902 L
.73006 .30902 L
.73134 .30902 L
.73205 .30902 L
.73271 .30902 L
.73344 .30902 L
.73422 .30902 L
Mistroke
.73489 .30902 L
.73562 .30902 L
.73631 .30902 L
.73695 .30902 L
.73815 .30902 L
.73943 .30902 L
.74063 .30902 L
.74195 .30902 L
.74319 .30902 L
.74434 .30902 L
.74548 .30902 L
.74652 .30902 L
.74771 .30902 L
.74884 .30902 L
.75007 .30902 L
.75137 .30902 L
.75248 .30902 L
.7537 .30902 L
.75501 .30902 L
.75575 .30902 L
.75642 .30902 L
.75772 .30902 L
.75896 .30902 L
.76001 .30902 L
.76116 .30902 L
.76351 .30902 L
.7657 .30902 L
.76667 .30902 L
.76772 .30902 L
.76887 .30902 L
.77009 .30902 L
.77141 .30902 L
.77264 .30902 L
.77381 .30902 L
.77487 .30902 L
.7761 .30902 L
.77725 .30902 L
.77841 .30902 L
.77964 .30902 L
.78081 .30902 L
.78188 .30902 L
.78313 .30902 L
.78383 .30902 L
.78449 .30902 L
.78569 .30902 L
.78697 .30902 L
.78762 .30902 L
.78831 .30902 L
.78906 .30902 L
.78975 .30902 L
Mistroke
.791 .30902 L
.79171 .30902 L
.79237 .30902 L
.7936 .30902 L
.79473 .30902 L
.79603 .30902 L
.79726 .30902 L
.79832 .30902 L
.79949 .30902 L
.80071 .30902 L
.80185 .30902 L
.80292 .30902 L
.8039 .30902 L
.80497 .30902 L
.8061 .30902 L
.80725 .30902 L
.80848 .30902 L
.80964 .30902 L
.81069 .30902 L
.81193 .30902 L
.81263 .30902 L
.81327 .30902 L
.81446 .30902 L
.81571 .30902 L
.81692 .30902 L
.81825 .30902 L
.81949 .30902 L
.82065 .30902 L
.82169 .30902 L
.82284 .30902 L
.82404 .30902 L
.82516 .30902 L
.8264 .30902 L
.82771 .30902 L
.82882 .30902 L
.83004 .30902 L
.83136 .30902 L
.8321 .30902 L
.83277 .30902 L
.83408 .30902 L
.83531 .30902 L
.83637 .30902 L
.83753 .30902 L
.83874 .30902 L
.83988 .30902 L
.84094 .30902 L
.84191 .30902 L
.84303 .30902 L
.8441 .30902 L
.84524 .30902 L
Mistroke
.84646 .30902 L
.84762 .30902 L
.84866 .30902 L
.84989 .30902 L
.85058 .30902 L
.85122 .30902 L
.8524 .30902 L
.85364 .30902 L
.85486 .30902 L
.85554 .30902 L
.85618 .30902 L
.85735 .30902 L
.8586 .30902 L
.8597 .30902 L
.86074 .30902 L
.86189 .30902 L
.86312 .30902 L
.86435 .30902 L
.86505 .30902 L
.8657 .30902 L
.86701 .30902 L
.86775 .30902 L
.86842 .30902 L
.86962 .30902 L
.87092 .30902 L
.87215 .30902 L
.87328 .30902 L
.87434 .30902 L
.87547 .30902 L
.87654 .30902 L
.87752 .30902 L
.87867 .30902 L
.87991 .30902 L
.88109 .30902 L
.88219 .30902 L
.88342 .30902 L
.88458 .30902 L
.88563 .30902 L
.88675 .30902 L
.88799 .30902 L
.88929 .30902 L
.8904 .30902 L
.89161 .30902 L
.89293 .30902 L
.89414 .30902 L
.89477 .30902 L
.89546 .30902 L
.89619 .30902 L
.89687 .30902 L
.89813 .30902 L
Mistroke
.89927 .30902 L
.90059 .30902 L
.90185 .30902 L
.90297 .30902 L
.90416 .30902 L
.90528 .30902 L
.9063 .30902 L
.90751 .30902 L
.90881 .30902 L
.91004 .30902 L
.91117 .30902 L
.91238 .30902 L
.91368 .30902 L
.9149 .30902 L
.91602 .30902 L
.91733 .30902 L
.91807 .30902 L
.91875 .30902 L
.92001 .30902 L
.92064 .30902 L
.92134 .30902 L
.92202 .30902 L
.92273 .30902 L
.92401 .30902 L
.92467 .30902 L
.92538 .30902 L
.92616 .30902 L
.92689 .30902 L
.92756 .30902 L
.92829 .30902 L
.92898 .30902 L
.92962 .30902 L
.93082 .30902 L
.9321 .30902 L
.93331 .30902 L
.93462 .30902 L
.93587 .30902 L
.93702 .30902 L
.93817 .30902 L
.9392 .30902 L
.9404 .30902 L
.94152 .30902 L
.94276 .30902 L
.94406 .30902 L
.94517 .30902 L
.94639 .30902 L
.94771 .30902 L
.94844 .30902 L
.94911 .30902 L
.95042 .30902 L
Mistroke
.95165 .30902 L
.95279 .30902 L
.95386 .30902 L
.95498 .30902 L
.95621 .30902 L
.95727 .30902 L
.95824 .30902 L
.95931 .30902 L
.96043 .30902 L
.96157 .30902 L
.96279 .30902 L
.96394 .30902 L
.96498 .30902 L
.96621 .30902 L
.9669 .30902 L
.96754 .30902 L
.96872 .30902 L
.96996 .30902 L
.97077 .30902 L
.97151 .30902 L
.97237 .30902 L
.97318 .30902 L
.97393 .30902 L
.97462 .30902 L
.97538 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.14) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`000c?o0080I_l00`00001V
o`1Vo`0506Ko00<00000I_l0I_l01@1Vo`03000006Ko06Ko00<0I_l2<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol0
00<co`0/00001oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0003ooooo
ool09_ooo`030000<ol0<ol001@co`0A06Ko00<00000I_l0I_l00`1VoaLco`000ol0VC?o03?o0008
<ol000<0000co`0co`004C?o00X0000:oooo00<0003oooooool09_ooo`030000oooooooo01Goool0
06Ooool00`0003?o03?o0005<ol03`1Vobhco`000ol0VC?o03?o000B<ol02P0005Goool006Ooool2
000000<co`00I_l0I_l00`1Vocdco`000ol0VC?o03?o000<<ol01P0005ooool006?oool406Ko00<0
0000I_l0I_l0@S?o0003o`2I<ol0<ol000Pco`040000IOooo`00Foooo`P0I_l4oooo00<0000co`0c
o`00@S?o0003o`2I<ol0<ol000Hco`020000JOooo`00E_ooo`D0I_l<oooo00<0000co`0co`00@S?o
0003o`2I<ol0<ol000<co`030000Joooo`00D_ooo`@0I_lAoooo0P0004<co`001?l0VC?o03?o03?o
0080001^oooo001>oooo101VoaGoool00`0003?o03?o0012<ol000Co09Tco`000000001`oooo001:
oooo101VoaWoool00`0003?o03?o0012<ol000?o09T0003oool0LOooo`00Aoooo`<0I_lMoooo00<0
000co`0co`00@3?o008000000ol0VOooooooo`1aoooo0015oooo0P1Vob3oool20000@3?o00040000
ooooooooo`2ILoooo`00@oooo`80I_lRoooo00<0000co`0co`00?S?o00050000ooooooooooooo`2I
07?oool0047oool206Ko9?ooo`030000<ol0<ol003`co`0200001?ooo`03o`2Ioooooooo077oool0
03koool306Ko9_ooo`030000<ol0<ol003/co`000`000?ooooooo`04oooo00?o09Woooooool0LOoo
o`00??ooo`80I_lYoooo0P0003/co`000`000?ooooooo`05oooo00?o09Woooooool0LOooo`00>_oo
o`80I_l[oooo00<0000co`0co`00>C?o00030000oooooooo00Koool00ol0VOooooooo`1aoooo000h
oooo0P1VoaCoool200001?ooo`800003oooo100000?oool200001Oooo`030000<ol0<ol003Lco`02
00002Oooo`03o`2Ioooooooo077oool001Koool00`1Vooooooooo`0Moooo0P1VoaGoool010000?oo
ooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004oooo00<0000co`0co`00=S?o
00030000oooooooo00Woool00ol0VOooooooo`1aoooo000Goooo00<0I_ooooooool06_ooo`80I_lG
oooo00@0003oooooool00009oooo00<0003oooooool01Oooo`030000oooooooo00;oool20000=S?o
00030000oooooooo00[oool00ol0VOooooooo`1aoooo000Goooo00<0I_ooooooool06?ooo`80I_lI
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0000co`0co`00=3?o
00030000oooooooo00_oool00ol0VOooooooo`1aoooo000Hoooo00<0I_ooooooool05_ooo`0306Ko
oooooooo01Woool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`04
oooo00<0000co`0co`00=3?o00030000oooooooo00_oool00ol0VOooooooo`1aoooo000Ioooo00<0
I_ooooooool04oooo`80I_lMoooo0P0000[oool200001?ooo`<00004oooo00<0000co`0co`00<c?o
00030000oooooooo00coool00ol0VOooooooo`1aoooo000Joooo00<0I_ooooooool04Oooo`0306Ko
oooooooo03Koool20000<c?o00030000oooooooo00goool00ol0VOooooooo`1aoooo000Joooo00<0
I_ooooooool03oooo`80I_lioooo00<0000co`0co`00<C?o00030000oooooooo00koool00ol0VOoo
ooooo`1aoooo000Koooo00<0I_ooooooool03Oooo`0306Kooooooooo03Woool00`0003?o03?o000a
<ol000<0003oooooool03_ooo`03o`2Ioooooooo077oool001coool00`1Vooooooooo`0:oooo0P1V
occoool00`0003?o03?o000`<ol000<0003oooooool03oooo`03o`2Ioooooooo077oool001coool0
0`1Vooooooooo`09oooo00<0I_ooooooool0??ooo`80000`<ol000<0003oooooool04?ooo`03o`2I
oooooooo077oool001goool00`1Vooooooooo`06oooo0P1Vocooool00`0003?o03?o000_<ol000<0
003oooooool04?ooo`03o`2Ioooooooo077oool001koool206Ko1Oooo`0306Kooooooooo03ooool0
0`0003?o03?o000^<ol000<0003oooooool04Oooo`03o`2Ioooooooo077oool0023oool01@1Voooo
ooooooooo`1Vo`12oooo00<0000co`0co`00;S?o00030000oooooooo017oool00ol0VOooooooo`1a
oooo000Qoooo00<0I_ooool0I_l0@oooo`80000^<ol000<0003oooooool04_ooo`03o`2Ioooooooo
077oool0027oool206KoA?ooo`030000<ol0<ol002dco`000`000?ooooooo`0Boooo00?o09Wooooo
ool0LOooo`00Ioooo`030000<ol0<ol002`co`000`000?ooooooo`0Coooo00?o09Woooooool0LOoo
o`00Ioooo`030000<ol0<ol002`co`000`000?ooooooo`0Coooo00?o09Woooooool0LOooo`00Iooo
o`80000/<ol000<0003oooooool05?ooo`03o`2Ioooooooo077oool006Ooool00`0003?o03?o000[
<ol000<0003oooooool05?ooo`03o`2Ioooooooo077oool005Coool200001?ooo`800004oooo0P00
00Goool00`0003?o03?o000Z<ol000<0003oooooool05Oooo`03o`2Ioooooooo077oool005?oool0
10000?ooooooo`0000Soool010000?ooooooo`0000Coool00`0003?o03?o000Z<ol000<0003ooooo
ool05Oooo`03o`2Ioooooooo077oool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02
oooo0P0002Xco`000`000?ooooooo`0Foooo00?o09Woooooool0LOooo`00Doooo`040000oooooooo
00002Oooo`800005oooo00<0000co`0co`00:C?o00030000oooooooo01Koool00ol0VOooooooo`1a
oooo001Coooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000<ol0<ol002Pco`00
0`000?ooooooo`0Goooo00?o09Woooooool0LOooo`00E?ooo`80000:oooo0`0000Coool00`0003?o
03?o000X<ol000<0003oooooool05oooo`03o`2Ioooooooo077oool006Ooool20000:C?o00030000
oooooooo01Ooool00ol0VOooooooo`1aoooo001Woooo00<0000co`0co`009c?o00030000oooooooo
01Soool00ol0VOooooooo`1aoooo001Woooo00<0000co`0co`009c?o00030000oooooooo01Soool0
0ol0VOooooooo`1aoooo001Woooo0P0002Lco`000`000?ooooooo`0Ioooo00?o09Woooooool0LOoo
o`00Ioooo`030000<ol0<ol002Hco`000`000?ooooooo`0Ioooo00?o09Woooooool0LOooo`00Iooo
o`030000<ol0<ol002Hco`000`000?ooooooo`0Ioooo00?o09Woooooool0LOooo`00Ioooo`030000
<ol0<ol002Dco`000`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Ioooo`80000V<ol000<0
003oooooool06_ooo`03o`2Ioooooooo077oool006Ooool00`0003?o03?o000U<ol000<0003ooooo
ool06_ooo`03o`2Ioooooooo077oool006Ooool00`0003?o03?o000U<ol000<0003oooooool06_oo
o`03o`2Ioooooooo077oool006Ooool00`0003?o03?o000T<ol000<0003oooooool06oooo`03o`2I
oooooooo077oool006Ooool200009C?o00030000oooooooo01_oool00ol0VOooooooo`1aoooo001W
oooo00<0000co`0co`0093?o00030000oooooooo01_oool00ol0VOooooooo`1aoooo001>oooo0P00
00Coool200001Oooo`030000oooooooo00;oool200001Oooo`030000<ol0<ol002<co`000`000?oo
ooooo`0Loooo00?o09Woooooool0LOooo`00COooo`040000oooooooo00002_ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0000co`0co`008c?o00030000oooooooo01coool0
0ol0VOooooooo`1aoooo001=oooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000
oooooooo00;oool2000093?o00030000oooooooo01coool00ol0VOooooooo`1aoooo001=oooo00@0
003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000<ol0<ol0028co`000`000?oo
ooooo`0Moooo00?o09Woooooool0LOooo`00COooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo00Coool00`0003?o03?o000R<ol000<0003oooooool07Oooo`03o`2I
oooooooo077oool004koool200002Oooo`@00003oooo0`0000Coool00`0003?o03?o000R<ol000<0
003oooooool07Oooo`03o`2Ioooooooo077oool006Ooool200008c?o00030000oooooooo01goool0
0ol0VOooooooo`1aoooo001Woooo00<0000co`0co`008C?o00030000oooooooo01koool00ol0VOoo
ooooo`1aoooo001Woooo00<0000co`0co`008C?o00030000oooooooo01koool00ol0VOooooooo`1a
oooo001Woooo00<0000co`0co`008C?o00030000oooooooo01koool00ol0VOooooooo`1aoooo001W
oooo0P00028co`000`000?ooooooo`0Noooo00?o09Woooooool0LOooo`00Ioooo`030000<ol0<ol0
020co`000`000?ooooooo`0Ooooo00?o09Woooooool0LOooo`00Ioooo`030000<ol0<ol0020co`00
0`000?ooooooo`0Ooooo00?o09Woooooool0LOooo`00Ioooo`030000<ol0<ol0020co`000`000?oo
ooooo`0Ooooo00?o09Woooooool0LOooo`00Ioooo`80000Q<ol000<0003oooooool07oooo`03o`2I
oooooooo077oool006Ooool00`0003?o03?o000O<ol000<0003oooooool08?ooo`03o`2Ioooooooo
077oool006Ooool00`0003?o03?o000O<ol000<0003oooooool08?ooo`03o`2Ioooooooo077oool0
06Ooool00`0003?o03?o000O<ol000<0003oooooool08?ooo`03o`2Ioooooooo077oool006Ooool2
000083?o00030000oooooooo023oool00ol0VOooooooo`1aoooo001Woooo00<0000co`0co`007c?o
00030000oooooooo023oool00ol0VOooooooo`1aoooo001Ooooo1@0000?oool00`0003?o03?o000N
<ol000<0003oooooool08Oooo`03o`2Ioooooooo077oool0067oool00`000?ooooooo`03oooo00<0
000co`0co`007S?o00030000oooooooo027oool00ol0VOooooooo`1aoooo001Qoooo00<0003ooooo
ool00oooo`80000O<ol000<0003oooooool08Oooo`03o`2Ioooooooo077oool0067oool00`000?oo
ooooo`03oooo8C?o09Soool0067oool00`000?ooooooo`03oooo8C?o09Soool0063oool200001Ooo
ob4co`2Hoooo001Woooo83?o09Woool006OooolP<ol0VOooo`00Ioooo`lco`000`0003?o03?o000>
<ol08?ooo`030000oooooooo07Koool006Ooool><ol000<0000co`0co`0023?o00030000<ol0<ol0
00@co`0Qoooo00<0003oooooool0MOooo`00Ioooo`hco`000`0003?o03?o0002<ol00P0000@co`00
0`0003?o03?o0003<ol02_ooo`800004oooo0P0000?oool500000oooo`<00002oooo00<0003ooooo
ool0MOooo`00Ioooo`hco`001@0003?o03?o03?o00000002<ol000<0000co`0co`000S?o00030000
<ol0<ol0008co`02oooo100000?oool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00D0
003oooooooooool00000Moooo`00Ioooo`dco`000`0003?o03?o0002<ol000<0000co`0co`002S?o
00Woool010000?ooooooo`0000[oool010000?ooooooooooo`D00003oooo00<0003oooooool0M?oo
o`00Ioooo`hco`000`0003?o03?o000500002C?o00Woool010000?ooooooo`0000[oool01@000?oo
ooooooooo`000002oooo00D0003oooooooooool00000Moooo`00Ioooo`hco`001@0003?o03?o03?o
0000000<<ol02Oooo`040000oooooooo00002_ooo`030000oooooooo00;oool00`000?ooo`000003
oooo00<0003oooooool0MOooo`00Ioooo`lco`000`0003?o03?o000=<ol02_ooo`80000:oooo0P00
00Goool200000_ooo`030000oooooooo07Koool006OooolN<ol0Voooo`00Iooooahco`2Koooo0000
\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {353.188, 211.875}} -> {-0.349561, \
1.49934, 0.00349883, 0.00566123}, {{79.875, 308.563}, {353.188, 211.875}} -> \
{-2.52168, 2.3289, 0.0124465, 0.0127866}, {{79.875, 308.563}, {353.188, \
211.875}} -> {-2.52168, 2.3289, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.13) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59975 .30902 L
.60479 .30902 L
.61016 .30902 L
.61278 .30902 L
.61524 .30902 L
.61631 .30902 L
.61745 .30902 L
s
.61745 .30902 m
.61757 .61803 L
s
0 .4 1 r
.02381 .3787 m
.04262 .4043 L
.0522 .41608 L
.05746 .42222 L
.06244 .42783 L
.06371 .42922 L
.06441 .42998 L
.06506 .43069 L
.06576 .43012 L
.06653 .42946 L
.0679 .42831 L
.07286 .42418 L
.08255 .41653 L
.10458 .40095 L
.14335 .37871 L
.18458 .36078 L
.22428 .34767 L
.26248 .33795 L
.30312 .3299 L
.34225 .32378 L
.36366 .32118 L
.38383 .31927 L
.42239 .31656 L
.44232 .31549 L
.46339 .31455 L
.50136 .3132 L
.54178 .31214 L
.58069 .31139 L
.59087 .31122 L
.60193 .31105 L
.607 .31098 L
.61238 .31091 L
.6146 .31088 L
.61576 .31086 L
.61698 .31085 L
.61763 .30902 L
.61835 .30902 L
.6196 .30902 L
.62079 .30902 L
.62205 .30902 L
.62337 .30902 L
.62459 .30902 L
.6259 .30902 L
.62664 .30902 L
.62734 .30902 L
.6286 .30902 L
.62975 .30902 L
.63038 .30902 L
.63107 .30902 L
.63233 .30902 L
Mistroke
.63356 .30902 L
.63468 .30902 L
.63596 .30902 L
.63717 .30902 L
.6383 .30902 L
.63933 .30902 L
.64047 .30902 L
.64167 .30902 L
.64297 .30902 L
.64416 .30902 L
.64482 .30902 L
.64554 .30902 L
.64684 .30902 L
.64805 .30902 L
.64934 .30902 L
.65045 .30902 L
.65166 .30902 L
.65235 .30902 L
.65308 .30902 L
.65438 .30902 L
.65511 .30902 L
.65578 .30902 L
.65652 .30902 L
.65731 .30902 L
.658 .30902 L
.65874 .30902 L
.65945 .30902 L
.66009 .30902 L
.66132 .30902 L
.66262 .30902 L
.66383 .30902 L
.66452 .30902 L
.66516 .30902 L
.66632 .30902 L
.66756 .30902 L
.66867 .30902 L
.66971 .30902 L
.67085 .30902 L
.67208 .30902 L
.67331 .30902 L
.67401 .30902 L
.67466 .30902 L
.67597 .30902 L
.6767 .30902 L
.67737 .30902 L
.67857 .30902 L
.67987 .30902 L
.6811 .30902 L
.68223 .30902 L
.68328 .30902 L
Mistroke
.68442 .30902 L
.68549 .30902 L
.68646 .30902 L
.68761 .30902 L
.68886 .30902 L
.69003 .30902 L
.69113 .30902 L
.69236 .30902 L
.69352 .30902 L
.69456 .30902 L
.69569 .30902 L
.69692 .30902 L
.69823 .30902 L
.69934 .30902 L
.70055 .30902 L
.70186 .30902 L
.70307 .30902 L
.7037 .30902 L
.70439 .30902 L
.70512 .30902 L
.7058 .30902 L
.70705 .30902 L
.70819 .30902 L
.70945 .30902 L
.71077 .30902 L
.71188 .30902 L
.71307 .30902 L
.7142 .30902 L
.71522 .30902 L
.71642 .30902 L
.71772 .30902 L
.71895 .30902 L
.72008 .30902 L
.72129 .30902 L
.72258 .30902 L
.7238 .30902 L
.72492 .30902 L
.72623 .30902 L
.72697 .30902 L
.72765 .30902 L
.72891 .30902 L
.72961 .30902 L
.73024 .30902 L
.73092 .30902 L
.73163 .30902 L
.73291 .30902 L
.73362 .30902 L
.73428 .30902 L
.73501 .30902 L
.73579 .30902 L
Mistroke
.73646 .30902 L
.73719 .30902 L
.73788 .30902 L
.73852 .30902 L
.73972 .30902 L
.741 .30902 L
.7422 .30902 L
.74352 .30902 L
.74476 .30902 L
.74591 .30902 L
.74705 .30902 L
.74808 .30902 L
.74928 .30902 L
.7504 .30902 L
.75163 .30902 L
.75294 .30902 L
.75405 .30902 L
.75526 .30902 L
.75658 .30902 L
.75731 .30902 L
.75798 .30902 L
.75929 .30902 L
.76052 .30902 L
.76157 .30902 L
.76273 .30902 L
.76394 .30902 L
.76508 .30902 L
.76613 .30902 L
.7671 .30902 L
.76817 .30902 L
.76929 .30902 L
.77043 .30902 L
.77165 .30902 L
.7728 .30902 L
.77384 .30902 L
.77507 .30902 L
.77576 .30902 L
.7764 .30902 L
.77758 .30902 L
.77882 .30902 L
.78003 .30902 L
.78135 .30902 L
.78259 .30902 L
.78375 .30902 L
.78489 .30902 L
.78593 .30902 L
.78825 .30902 L
.78948 .30902 L
.79062 .30902 L
.79182 .30902 L
Mistroke
.79312 .30902 L
.79382 .30902 L
.79445 .30902 L
.79518 .30902 L
.79587 .30902 L
.79707 .30902 L
.79839 .30902 L
.79952 .30902 L
.80076 .30902 L
.80207 .30902 L
.80329 .30902 L
.80443 .30902 L
.80547 .30902 L
.80662 .30902 L
.80782 .30902 L
.80888 .30902 L
.81002 .30902 L
.81109 .30902 L
.81206 .30902 L
.81321 .30902 L
.81445 .30902 L
.8156 .30902 L
.8167 .30902 L
.81793 .30902 L
.81906 .30902 L
.82038 .30902 L
.8216 .30902 L
.82266 .30902 L
.82379 .30902 L
.82493 .30902 L
.82618 .30902 L
.82684 .30902 L
.82753 .30902 L
.82876 .30902 L
.82945 .30902 L
.8301 .30902 L
.8308 .30902 L
.83155 .30902 L
.8322 .30902 L
.83291 .30902 L
.8342 .30902 L
.83545 .30902 L
.8366 .30902 L
.83781 .30902 L
.83911 .30902 L
.84034 .30902 L
.84147 .30902 L
.84278 .30902 L
.84352 .30902 L
.84421 .30902 L
Mistroke
.84548 .30902 L
.84618 .30902 L
.84682 .30902 L
.8475 .30902 L
.84822 .30902 L
.8495 .30902 L
.85022 .30902 L
.85088 .30902 L
.85162 .30902 L
.8524 .30902 L
.85308 .30902 L
.85381 .30902 L
.85451 .30902 L
.85515 .30902 L
.85636 .30902 L
.85766 .30902 L
.85879 .30902 L
.86004 .30902 L
.86134 .30902 L
.86255 .30902 L
.86368 .30902 L
.86471 .30902 L
.86591 .30902 L
.86703 .30902 L
.86825 .30902 L
.86955 .30902 L
.87066 .30902 L
.87188 .30902 L
.87319 .30902 L
.87392 .30902 L
.87459 .30902 L
.8759 .30902 L
.87713 .30902 L
.87829 .30902 L
.87933 .30902 L
.88054 .30902 L
.88167 .30902 L
.88273 .30902 L
.88369 .30902 L
.88476 .30902 L
.88588 .30902 L
.88702 .30902 L
.88823 .30902 L
.88938 .30902 L
.89043 .30902 L
.89166 .30902 L
.89235 .30902 L
.89299 .30902 L
.89417 .30902 L
.89541 .30902 L
Mistroke
.89662 .30902 L
.89793 .30902 L
.89917 .30902 L
.90032 .30902 L
.90144 .30902 L
.90249 .30902 L
.90371 .30902 L
.90481 .30902 L
.90604 .30902 L
.90734 .30902 L
.90845 .30902 L
.90967 .30902 L
.91098 .30902 L
.91171 .30902 L
.91239 .30902 L
.91303 .30902 L
.91372 .30902 L
.91493 .30902 L
.91606 .30902 L
.91712 .30902 L
.91828 .30902 L
.91953 .30902 L
.92078 .30902 L
.92209 .30902 L
.92321 .30902 L
.92443 .30902 L
.92556 .30902 L
.92663 .30902 L
.92786 .30902 L
.92898 .30902 L
.93003 .30902 L
.93103 .30902 L
.93218 .30902 L
.93322 .30902 L
.93437 .30902 L
.93561 .30902 L
.93677 .30902 L
.93785 .30902 L
.93914 .30902 L
.94031 .30902 L
.94096 .30902 L
.94166 .30902 L
.94293 .30902 L
.94418 .30902 L
.94489 .30902 L
.94554 .30902 L
.94623 .30902 L
.94696 .30902 L
.94765 .30902 L
.94829 .30902 L
Mistroke
.94952 .30902 L
.95065 .30902 L
.9519 .30902 L
.95322 .30902 L
.95436 .30902 L
.9554 .30902 L
.95654 .30902 L
.95774 .30902 L
.9588 .30902 L
.95977 .30902 L
.96084 .30902 L
.96199 .30902 L
.96325 .30902 L
.96444 .30902 L
.9656 .30902 L
.96667 .30902 L
.96783 .30902 L
.9691 .30902 L
.96974 .30902 L
.97042 .30902 L
.97167 .30902 L
.97278 .30902 L
.97399 .30902 L
.97513 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.13) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`00100003?o03?o03?o00@0I_l00`00001Vo`1Vo`0506Ko00<00000I_l0
I_l01@1Vo`03000006Ko06Ko00D0I_l00`00001Vo`1Vo`0406Ko00<co`00000co`001S?o00030000
<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000<co`0/
00001oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0003oooooool09_oo
o`030000<ol0<ol000dco`0D06Ko13?o00030000<ol0<ol001/co`000ol0VC?o03?o0007<ol000<0
000co`0co`004C?o00X0000:oooo00<0003oooooool09_ooo`030000oooooooo01Goool006Ooool0
0`0003?o03?o000=06Ko=S?o0003o`2I<ol0<ol0014co`0:0000EOooo`00IOooo`80I_l2000000<0
I_lco`0co`00@C?o0003o`2I<ol0<ol000/co`060000Goooo`00H?ooo`D0I_l2oooo00<0000co`0c
o`00@c?o0003o`2I<ol0<ol000Lco`040000IOooo`00Foooo`D0I_l7oooo00<0000co`0co`00@c?o
0003o`2I<ol0<ol000Dco`020000JOooo`00E_ooo`D0I_l<oooo00<0000co`0co`00@c?o0003o`2I
<ol0<ol0008co`030000Joooo`00DOooo`D0I_lAoooo0P0004@co`000ol0VC?o03?o00020000K_oo
o`00C?ooo`D0I_lFoooo00<0000co`0co`00@c?o0003o`2I00000000073oool004Soool406Ko6ooo
o`030000<ol0<ol0048co`000`000?l0VOooo`1aoooo0016oooo0P1Voaooool00`0003?o03?o0010
<ol00P000003ooooo`2Ioooo077oool004?oool306Ko8Oooo`800010<ol000D0003ooooooooooooo
09T0L_ooo`00@Oooo`80I_lToooo00<0000co`0co`00?S?o00030000oooooooo00;oool00ol0VOoo
ooooo`1`oooo000noooo0`1VobKoool00`0003?o03?o000l<ol00P0000Goool00ol0VOooooooo`1`
oooo000loooo0P1VobWoool00`0003?o03?o000k<ol000<0003oooooool01Oooo`03o`2Ioooooooo
073oool003Woool306Ko:oooo`80000k<ol000<0003oooooool01_ooo`03o`2Ioooooooo073oool0
03Ooool206Ko;_ooo`030000<ol0<ol003Tco`000`000?ooooooo`07oooo00?o09Woooooool0L?oo
o`005_ooo`0306Kooooooooo01coool206Ko5oooo`800004oooo0P0000?oool400000oooo`800005
oooo00<0000co`0co`00=c?o0080000:oooo00?o09Woooooool0L?ooo`005oooo`0306Kooooooooo
01Woool206Ko6?ooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`00
00Coool00`0003?o03?o000f<ol000<0003oooooool02_ooo`03o`2Ioooooooo073oool001Ooool0
0`1Vooooooooo`0Goooo0P1Voa[oool010000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0
003oooooool00_ooo`80000f<ol000<0003oooooool02oooo`03o`2Ioooooooo073oool001Soool0
0`1Vooooooooo`0Eoooo00<0I_ooooooool06_ooo`040000oooooooo00002_ooo`030000oooooooo
00;oool200001Oooo`030000<ol0<ol003@co`000`000?ooooooo`0<oooo00?o09Woooooool0L?oo
o`006Oooo`0306Kooooooooo01;oool206Ko7Oooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo00Coool00`0003?o03?o000d<ol000<0003oooooool03?ooo`03o`2I
oooooooo073oool001[oool00`1Vooooooooo`0?oooo0P1Vob3oool200002_ooo`800004oooo0`00
00Coool00`0003?o03?o000c<ol000<0003oooooool03Oooo`03o`2Ioooooooo073oool001[oool0
0`1Vooooooooo`0>oooo00<0I_ooooooool0>Oooo`80000c<ol000<0003oooooool03_ooo`03o`2I
oooooooo073oool001_oool00`1Vooooooooo`0;oooo0P1Voccoool00`0003?o03?o000a<ol000<0
003oooooool03oooo`03o`2Ioooooooo073oool001coool00`1Vooooooooo`09oooo00<0I_oooooo
ool0??ooo`030000<ol0<ol0034co`000`000?ooooooo`0?oooo00?o09Woooooool0L?ooo`007?oo
o`0306Kooooooooo00Ooool206Ko?oooo`030000<ol0<ol0030co`000`000?ooooooo`0@oooo00?o
09Woooooool0L?ooo`007Oooo`0306Kooooooooo00Goool00`1Vooooooooo`0ooooo0P00030co`00
0`000?ooooooo`0Aoooo00?o09Woooooool0L?ooo`007_ooo`80I_l4oooo00<0I_ooooooool0@?oo
o`030000<ol0<ol002lco`000`000?ooooooo`0Aoooo00?o09Woooooool0L?ooo`007oooo`0506Ko
oooooooooooo06Ko04?oool00`0003?o03?o000^<ol000<0003oooooool04_ooo`03o`2Ioooooooo
073oool0023oool306KoA?ooo`030000<ol0<ol002hco`000`000?ooooooo`0Boooo00?o09Wooooo
ool0L?ooo`00Ioooo`80000^<ol000<0003oooooool04oooo`03o`2Ioooooooo073oool006Ooool0
0`0003?o03?o000]<ol000<0003oooooool04oooo`03o`2Ioooooooo073oool006Ooool00`0003?o
03?o000/<ol000<0003oooooool05?ooo`03o`2Ioooooooo073oool006Ooool00`0003?o03?o000/
<ol000<0003oooooool05?ooo`03o`2Ioooooooo073oool006Ooool20000;3?o00030000oooooooo
01Goool00ol0VOooooooo`1`oooo001Woooo00<0000co`0co`00:c?o00030000oooooooo01Goool0
0ol0VOooooooo`1`oooo001Doooo0P0000Coool200001?ooo`800005oooo00<0000co`0co`00:S?o
00030000oooooooo01Koool00ol0VOooooooo`1`oooo001Coooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0000co`0co`00:S?o00030000oooooooo01Koool00ol0VOooooooo`1`
oooo001Coooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`80000Z<ol000<0003ooooo
ool05oooo`03o`2Ioooooooo073oool005?oool010000?ooooooo`0000Woool200001Oooo`030000
<ol0<ol002Tco`000`000?ooooooo`0Goooo00?o09Woooooool0L?ooo`00Doooo`040000oooooooo
00002Oooo`030000oooooooo00Coool00`0003?o03?o000X<ol000<0003oooooool06?ooo`03o`2I
oooooooo073oool005Coool200002_ooo`<00004oooo00<0000co`0co`00:3?o00030000oooooooo
01Soool00ol0VOooooooo`1`oooo001Woooo0P0002Tco`000`000?ooooooo`0Hoooo00?o09Wooooo
ool0L?ooo`00Ioooo`030000<ol0<ol002Lco`000`000?ooooooo`0Ioooo00?o09Woooooool0L?oo
o`00Ioooo`030000<ol0<ol002Lco`000`000?ooooooo`0Ioooo00?o09Woooooool0L?ooo`00Iooo
o`80000W<ol000<0003oooooool06_ooo`03o`2Ioooooooo073oool006Ooool00`0003?o03?o000V
<ol000<0003oooooool06_ooo`03o`2Ioooooooo073oool006Ooool00`0003?o03?o000V<ol000<0
003oooooool06_ooo`03o`2Ioooooooo073oool006Ooool00`0003?o03?o000U<ol000<0003ooooo
ool06oooo`03o`2Ioooooooo073oool006Ooool200009S?o00030000oooooooo01_oool00ol0VOoo
ooooo`1`oooo001Woooo00<0000co`0co`009C?o00030000oooooooo01_oool00ol0VOooooooo`1`
oooo001Woooo00<0000co`0co`009C?o00030000oooooooo01_oool00ol0VOooooooo`1`oooo001W
oooo00<0000co`0co`0093?o00030000oooooooo01coool00ol0VOooooooo`1`oooo001Woooo0P00
02Dco`000`000?ooooooo`0Loooo00?o09Woooooool0L?ooo`00Ioooo`030000<ol0<ol002@co`00
0`000?ooooooo`0Loooo00?o09Woooooool0L?ooo`00C_ooo`800004oooo0P0000Goool00`000?oo
ooooo`02oooo0P0000Goool00`0003?o03?o000S<ol000<0003oooooool07Oooo`03o`2Ioooooooo
073oool004goool010000?ooooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000<ol0<ol002<co`000`000?ooooooo`0Moooo00?o09Woooooool0L?ooo`00COoo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`02oooo0P0002@co`00
0`000?ooooooo`0Moooo00?o09Woooooool0L?ooo`00COooo`040000oooooooo00002oooo`040000
oooooooooooo0P0000Goool00`0003?o03?o000R<ol000<0003oooooool07_ooo`03o`2Ioooooooo
073oool004goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`04
oooo00<0000co`0co`008S?o00030000oooooooo01koool00ol0VOooooooo`1`oooo001>oooo0P00
00Woool400000oooo`<00004oooo00<0000co`0co`008S?o00030000oooooooo01koool00ol0VOoo
ooooo`1`oooo001Woooo0P0002<co`000`000?ooooooo`0Noooo00?o09Woooooool0L?ooo`00Iooo
o`030000<ol0<ol0024co`000`000?ooooooo`0Ooooo00?o09Woooooool0L?ooo`00Ioooo`030000
<ol0<ol0024co`000`000?ooooooo`0Ooooo00?o09Woooooool0L?ooo`00Ioooo`030000<ol0<ol0
024co`000`000?ooooooo`0Ooooo00?o09Woooooool0L?ooo`00Ioooo`80000R<ol000<0003ooooo
ool07oooo`03o`2Ioooooooo073oool006Ooool00`0003?o03?o000P<ol000<0003oooooool08?oo
o`03o`2Ioooooooo073oool006Ooool00`0003?o03?o000P<ol000<0003oooooool08?ooo`03o`2I
oooooooo073oool006Ooool00`0003?o03?o000P<ol000<0003oooooool08?ooo`03o`2Ioooooooo
073oool006Ooool200008C?o00030000oooooooo023oool00ol0VOooooooo`1`oooo001Woooo00<0
000co`0co`007c?o00030000oooooooo027oool00ol0VOooooooo`1`oooo001Woooo00<0000co`0c
o`007c?o00030000oooooooo027oool00ol0VOooooooo`1`oooo001Woooo00<0000co`0co`007c?o
00030000oooooooo027oool00ol0VOooooooo`1`oooo001Woooo0P00020co`000`000?ooooooo`0Q
oooo00?o09Woooooool0L?ooo`00Ioooo`030000<ol0<ol001lco`000`000?ooooooo`0Qoooo00?o
09Woooooool0L?ooo`00Goooo`D00003oooo00<0000co`0co`007S?o00030000oooooooo02;oool0
0ol0VOooooooo`1`oooo001Qoooo00<0003oooooool00oooo`030000<ol0<ol001hco`000`000?oo
ooooo`0Roooo00?o09Woooooool0L?ooo`00HOooo`030000oooooooo00?oool200007c?o00030000
oooooooo02;oool00ol0VOooooooo`1`oooo001Qoooo00<0003oooooool00oooob4co`2Hoooo001Q
oooo00<0003oooooool00oooob4co`2Hoooo001Poooo0P0000GooolQ<ol0V?ooo`00Ioooob0co`2I
oooo001Woooo83?o09Woool006Ooool?<ol000<0000co`0co`003S?o023oool00`000?ooooooo`1f
oooo001Woooo3S?o00030000<ol0<ol000Pco`000`0003?o03?o0004<ol08Oooo`030000oooooooo
07Goool006Ooool><ol000<0000co`0co`000S?o00800004<ol000<0000co`0co`000c?o00[oool2
00001?ooo`800003oooo1@0000;oool200001?ooo`030000oooooooo07Goool006Ooool><ol000D0
000co`0co`0co`0000000S?o00030000<ol0<ol0008co`000`0003?o03?o0002<ol00_ooo`@00003
oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`050000oooooooooooo0000
07Ooool006Ooool=<ol000<0000co`0co`000S?o00030000<ol0<ol000Xco`09oooo00@0003ooooo
ool0000:oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`1doooo001W
oooo3S?o00030000<ol0<ol000D00009<ol02Oooo`040000oooooooo00002_ooo`030000oooooooo
00Coool01@000?ooooooooooo`00001goooo001Woooo3S?o00050000<ol0<ol0<ol0000000`co`09
oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`050000oooooooooooo0000
07Ooool006Ooool?<ol000<0000co`0co`003C?o00[oool200002_ooo`800004oooo0P0000?oool0
0`000?ooooooo`1foooo001Woooo7S?o09_oool006OooolN<ol0Voooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {501.875, 360.563}} -> {-0.349561, \
2.55153, 0.00349883, 0.00566123}, {{79.875, 308.563}, {501.875, 360.563}} -> \
{-2.52168, 4.7054, 0.0124465, 0.0127866}, {{79.875, 308.563}, {501.875, \
360.563}} -> {-2.52168, 4.7054, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.12) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.59832 .30902 L
.60873 .30902 L
.61445 .30902 L
.61726 .30902 L
.61849 .30902 L
.61914 .30902 L
.61984 .30902 L
s
.61984 .30902 m
.61997 .61803 L
s
0 .4 1 r
.02381 .37403 m
.04262 .40021 L
.0522 .41226 L
.05746 .41855 L
.05872 .42001 L
.06005 .42155 L
.06119 .42286 L
.06244 .42323 L
.06309 .4227 L
.06379 .42214 L
.06506 .42113 L
.0679 .4189 L
.07286 .41511 L
.08255 .40805 L
.10458 .3937 L
.1458 .3721 L
.18551 .35637 L
.22371 .34478 L
.26435 .33528 L
.30348 .32819 L
.32346 .32517 L
.34506 .32226 L
.38513 .31836 L
.40507 .31697 L
.42613 .31576 L
.4641 .31408 L
.50453 .31278 L
.54344 .31186 L
.56325 .31149 L
.5848 .31114 L
.59483 .31099 L
.6055 .31085 L
.6146 .31073 L
.61709 .3107 L
.6184 .31069 L
.61911 .31068 L
.61978 .31067 L
.62099 .30902 L
.62163 .30902 L
.62232 .30902 L
.62354 .30902 L
.62464 .30902 L
.62584 .30902 L
.62695 .30902 L
.62818 .30902 L
.62949 .30902 L
.63015 .30902 L
.63087 .30902 L
.63217 .30902 L
.63345 .30902 L
Mistroke
.63463 .30902 L
.63583 .30902 L
.63696 .30902 L
.63798 .30902 L
.63908 .30902 L
.64029 .30902 L
.64156 .30902 L
.64264 .30902 L
.64383 .30902 L
.6445 .30902 L
.64523 .30902 L
.64655 .30902 L
.64784 .30902 L
.64903 .30902 L
.65031 .30902 L
.65104 .30902 L
.65173 .30902 L
.65245 .30902 L
.65311 .30902 L
.65382 .30902 L
.65459 .30902 L
.6558 .30902 L
.65693 .30902 L
.65762 .30902 L
.65827 .30902 L
.65948 .30902 L
.66077 .30902 L
.66195 .30902 L
.66325 .30902 L
.66391 .30902 L
.66463 .30902 L
.66584 .30902 L
.66713 .30902 L
.6678 .30902 L
.66855 .30902 L
.66986 .30902 L
.67109 .30902 L
.67178 .30902 L
.67241 .30902 L
.67358 .30902 L
.67481 .30902 L
.67593 .30902 L
.67711 .30902 L
.67823 .30902 L
.67925 .30902 L
.68045 .30902 L
.68175 .30902 L
.68298 .30902 L
.68411 .30902 L
.68531 .30902 L
Mistroke
.68661 .30902 L
.68783 .30902 L
.68894 .30902 L
.69025 .30902 L
.69099 .30902 L
.69167 .30902 L
.69293 .30902 L
.69363 .30902 L
.69426 .30902 L
.69494 .30902 L
.69565 .30902 L
.69692 .30902 L
.69763 .30902 L
.6983 .30902 L
.69902 .30902 L
.6998 .30902 L
.70047 .30902 L
.7012 .30902 L
.70189 .30902 L
.70253 .30902 L
.70374 .30902 L
.70502 .30902 L
.70616 .30902 L
.7074 .30902 L
.7087 .30902 L
.70991 .30902 L
.71105 .30902 L
.71208 .30902 L
.71327 .30902 L
.7144 .30902 L
.71562 .30902 L
.71692 .30902 L
.71803 .30902 L
.71925 .30902 L
.72056 .30902 L
.72128 .30902 L
.72196 .30902 L
.7226 .30902 L
.72329 .30902 L
.7245 .30902 L
.72575 .30902 L
.72692 .30902 L
.72797 .30902 L
.7291 .30902 L
.73034 .30902 L
.73165 .30902 L
.73277 .30902 L
.73399 .30902 L
.73515 .30902 L
.73619 .30902 L
Mistroke
.7374 .30902 L
.73855 .30902 L
.7396 .30902 L
.74058 .30902 L
.74165 .30902 L
.74279 .30902 L
.74399 .30902 L
.74531 .30902 L
.74655 .30902 L
.7477 .30902 L
.74884 .30902 L
.74987 .30902 L
.75107 .30902 L
.75219 .30902 L
.75342 .30902 L
.75472 .30902 L
.75585 .30902 L
.75705 .30902 L
.75835 .30902 L
.75956 .30902 L
.7603 .30902 L
.761 .30902 L
.76231 .30902 L
.76337 .30902 L
.7645 .30902 L
.76551 .30902 L
.76656 .30902 L
.76768 .30902 L
.76871 .30902 L
.76993 .30902 L
.77108 .30902 L
.77222 .30902 L
.77344 .30902 L
.77414 .30902 L
.7748 .30902 L
.77603 .30902 L
.77717 .30902 L
.77823 .30902 L
.77938 .30902 L
.78061 .30902 L
.78182 .30902 L
.78314 .30902 L
.78438 .30902 L
.78554 .30902 L
.78668 .30902 L
.78772 .30902 L
.78892 .30902 L
.79004 .30902 L
.79128 .30902 L
.79258 .30902 L
Mistroke
.79369 .30902 L
.79491 .30902 L
.79623 .30902 L
.79696 .30902 L
.79764 .30902 L
.79894 .30902 L
.80018 .30902 L
.80123 .30902 L
.80239 .30902 L
.8036 .30902 L
.80474 .30902 L
.8058 .30902 L
.80677 .30902 L
.80783 .30902 L
.80895 .30902 L
.81009 .30902 L
.81131 .30902 L
.81246 .30902 L
.81351 .30902 L
.81474 .30902 L
.81543 .30902 L
.81607 .30902 L
.81724 .30902 L
.81849 .30902 L
.8197 .30902 L
.82102 .30902 L
.82227 .30902 L
.82343 .30902 L
.82447 .30902 L
.82562 .30902 L
.82682 .30902 L
.82794 .30902 L
.82918 .30902 L
.83049 .30902 L
.8316 .30902 L
.83282 .30902 L
.83414 .30902 L
.83488 .30902 L
.83555 .30902 L
.83686 .30902 L
.83809 .30902 L
.83915 .30902 L
.84031 .30902 L
.84152 .30902 L
.84266 .30902 L
.84372 .30902 L
.84469 .30902 L
.84581 .30902 L
.84688 .30902 L
.84802 .30902 L
Mistroke
.84924 .30902 L
.85039 .30902 L
.85144 .30902 L
.85267 .30902 L
.85336 .30902 L
.854 .30902 L
.85517 .30902 L
.85641 .30902 L
.85763 .30902 L
.85832 .30902 L
.85896 .30902 L
.86011 .30902 L
.86137 .30902 L
.8625 .30902 L
.86357 .30902 L
.86469 .30902 L
.86589 .30902 L
.86713 .30902 L
.86783 .30902 L
.86848 .30902 L
.86979 .30902 L
.87053 .30902 L
.8712 .30902 L
.8724 .30902 L
.8737 .30902 L
.87492 .30902 L
.87606 .30902 L
.87711 .30902 L
.87825 .30902 L
.87932 .30902 L
.8803 .30902 L
.88144 .30902 L
.88269 .30902 L
.88387 .30902 L
.88496 .30902 L
.8862 .30902 L
.88736 .30902 L
.8884 .30902 L
.88953 .30902 L
.89076 .30902 L
.89206 .30902 L
.89318 .30902 L
.89439 .30902 L
.8957 .30902 L
.89691 .30902 L
.89755 .30902 L
.89824 .30902 L
.89897 .30902 L
.89965 .30902 L
.9009 .30902 L
Mistroke
.90205 .30902 L
.9027 .30902 L
.90339 .30902 L
.90463 .30902 L
.90582 .30902 L
.90691 .30902 L
.90819 .30902 L
.9094 .30902 L
.91054 .30902 L
.91159 .30902 L
.91273 .30902 L
.91395 .30902 L
.91525 .30902 L
.91643 .30902 L
.91709 .30902 L
.9178 .30902 L
.9191 .30902 L
.92032 .30902 L
.92161 .30902 L
.92271 .30902 L
.92392 .30902 L
.92461 .30902 L
.92534 .30902 L
.92664 .30902 L
.92736 .30902 L
.92804 .30902 L
.92878 .30902 L
.92957 .30902 L
.93026 .30902 L
.931 .30902 L
.9317 .30902 L
.93235 .30902 L
.93358 .30902 L
.93488 .30902 L
.93608 .30902 L
.9374 .30902 L
.93865 .30902 L
.9398 .30902 L
.94094 .30902 L
.94198 .30902 L
.94318 .30902 L
.9443 .30902 L
.94553 .30902 L
.94684 .30902 L
.94795 .30902 L
.94917 .30902 L
.95048 .30902 L
.95122 .30902 L
.95189 .30902 L
.9532 .30902 L
Mistroke
.95443 .30902 L
.95548 .30902 L
.95664 .30902 L
.95785 .30902 L
.95899 .30902 L
.95998 .30902 L
.96102 .30902 L
.96216 .30902 L
.9632 .30902 L
.96435 .30902 L
.96556 .30902 L
.96672 .30902 L
.96776 .30902 L
.96899 .30902 L
.96964 .30902 L
.97032 .30902 L
.97158 .30902 L
.97274 .30902 L
.9736 .30902 L
.97452 .30902 L
.97539 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.12) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`000`0003?o03?o0002<ol00`1Vo`03000006Ko06Ko00D0I_l00`00001V
o`1Vo`0506Ko00<00000I_l0I_l01@1Vo`03000006Ko06Ko00@0I_l00c?o000003?o0006<ol000<0
000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`000c?o
02`00007oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Goool00`000?ooooooo`0V
oooo00<0000co`0co`002c?o01L0I_l3<ol000<0000co`0co`006c?o0003o`2I<ol0<ol000Lco`00
0`0003?o03?o000A<ol02P0000[oool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00Iooo
o`030000<ol0<ol000@co`0706Ko>3?o0003o`2I<ol0<ol0014co`0:0000EOooo`00I_ooo`0306Ko
0000000000D0I_lo<ol000?o09Tco`0co`002c?o00H0001Ooooo001Koooo2`1Vo`03oooo0000<ol0
04@co`000ol0VC?o03?o0007<ol0100006Goool005Koool506Ko3?ooo`030000<ol0<ol004<co`00
0ol0VC?o03?o0005<ol00P0006Woool0057oool506Ko4Oooo`030000<ol0<ol004<co`000ol0VC?o
03?o0002<ol00`0006_oool004coool506Ko5_ooo`800014<ol000?o09Tco`0co`000P0006koool0
04Soool406Ko6oooo`030000<ol0<ol004<co`000ol0V@000000001`oooo0015oooo0`1Voaooool0
0`0003?o03?o0012<ol000<0003o09Woool0LOooo`00@Oooo`@0I_lRoooo00<0000co`0co`00@3?o
008000000oooool0VOooo`1aoooo000noooo0`1VobKoool20000@3?o00050000ooooooooooooo`2I
07;oool003coool206Ko:Oooo`030000<ol0<ol003hco`000`000?ooooooo`02oooo00?o09Wooooo
ool0L?ooo`00>Oooo`<0I_l[oooo00<0000co`0co`00?3?o00800005oooo00?o09Woooooool0L?oo
o`00=oooo`80I_l^oooo00<0000co`0co`00>c?o00030000oooooooo00Goool00ol0VOooooooo`1`
oooo000eoooo0P1Voc3oool20000>c?o00030000oooooooo00Koool00ol0VOooooooo`1`oooo000F
oooo00<0I_ooooooool06_ooo`80I_lboooo00<0000co`0co`00>C?o00030000oooooooo00Ooool0
0ol0VOooooooo`1`oooo000Goooo00<0I_ooooooool05oooo`80I_lKoooo0P0000Coool200000ooo
o`@00003oooo0P0000Goool00`0003?o03?o000g<ol00P0000[oool00ol0VOooooooo`1`oooo000G
oooo00<0I_ooooooool05_ooo`0306Kooooooooo01[oool010000?ooooooo`0000Soool00`000?oo
ooooo`03oooo00@0003oooooool00004oooo00<0000co`0co`00=S?o00030000oooooooo00[oool0
0ol0VOooooooo`1`oooo000Hoooo00<0I_ooooooool04oooo`80I_lMoooo00@0003oooooool00009
oooo00<0003oooooool01Oooo`030000oooooooo00;oool20000=S?o00030000oooooooo00_oool0
0ol0VOooooooo`1`oooo000Ioooo00<0I_ooooooool04?ooo`80I_lOoooo00@0003oooooool0000:
oooo00<0003oooooool00_ooo`800005oooo00<0000co`0co`00=3?o00030000oooooooo00coool0
0ol0VOooooooo`1`oooo000Joooo00<0I_ooooooool03_ooo`0306Kooooooooo01ooool010000?oo
ooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0000co`0co`00=3?o
00030000oooooooo00coool00ol0VOooooooo`1`oooo000Joooo00<0I_ooooooool03?ooo`80I_lS
oooo0P0000[oool200001?ooo`<00004oooo00<0000co`0co`00<c?o00030000oooooooo00goool0
0ol0VOooooooo`1`oooo000Koooo00<0I_ooooooool02_ooo`0306Kooooooooo03coool20000<c?o
00030000oooooooo00koool00ol0VOooooooo`1`oooo000Loooo00<0I_ooooooool01oooo`80I_lo
oooo00<0000co`0co`00<C?o00030000oooooooo00ooool00ol0VOooooooo`1`oooo000Loooo00<0
I_ooooooool01_ooo`0306Kooooooooo03ooool00`0003?o03?o000a<ol000<0003oooooool03ooo
o`03o`2Ioooooooo073oool001goool00`1Vooooooooo`03oooo0P1Vod;oool00`0003?o03?o000`
<ol000<0003oooooool04?ooo`03o`2Ioooooooo073oool001koool206Ko00?oool0I_l0I_l0A?oo
o`80000`<ol000<0003oooooool04Oooo`03o`2Ioooooooo073oool001ooool306KoAOooo`030000
<ol0<ol002lco`000`000?ooooooo`0Aoooo00?o09Woooooool0L?ooo`00Ioooo`030000<ol0<ol0
02hco`000`000?ooooooo`0Boooo00?o09Woooooool0L?ooo`00Ioooo`030000<ol0<ol002hco`00
0`000?ooooooo`0Boooo00?o09Woooooool0L?ooo`00Ioooo`80000^<ol000<0003oooooool04ooo
o`03o`2Ioooooooo073oool006Ooool00`0003?o03?o000]<ol000<0003oooooool04oooo`03o`2I
oooooooo073oool006Ooool00`0003?o03?o000/<ol000<0003oooooool05?ooo`03o`2Ioooooooo
073oool006Ooool00`0003?o03?o000/<ol000<0003oooooool05?ooo`03o`2Ioooooooo073oool0
06Ooool20000;3?o00030000oooooooo01Goool00ol0VOooooooo`1`oooo001Woooo00<0000co`0c
o`00:c?o00030000oooooooo01Goool00ol0VOooooooo`1`oooo001Doooo0P0000Coool200001?oo
o`800005oooo00<0000co`0co`00:S?o00030000oooooooo01Koool00ol0VOooooooo`1`oooo001C
oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0000co`0co`00:S?o00030000
oooooooo01Koool00ol0VOooooooo`1`oooo001Coooo00@0003oooooool0000;oooo00<0003ooooo
ool00_ooo`80000Z<ol000<0003oooooool05oooo`03o`2Ioooooooo073oool005?oool010000?oo
ooooo`0000Woool200001Oooo`030000<ol0<ol002Tco`000`000?ooooooo`0Goooo00?o09Wooooo
ool0L?ooo`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`0003?o03?o000X
<ol000<0003oooooool06?ooo`03o`2Ioooooooo073oool005Coool200002_ooo`<00004oooo00<0
000co`0co`00:3?o00030000oooooooo01Soool00ol0VOooooooo`1`oooo001Woooo0P0002Tco`00
0`000?ooooooo`0Hoooo00?o09Woooooool0L?ooo`00Ioooo`030000<ol0<ol002Lco`000`000?oo
ooooo`0Ioooo00?o09Woooooool0L?ooo`00Ioooo`030000<ol0<ol002Lco`000`000?ooooooo`0I
oooo00?o09Woooooool0L?ooo`00Ioooo`80000W<ol000<0003oooooool06_ooo`03o`2Ioooooooo
073oool006Ooool00`0003?o03?o000V<ol000<0003oooooool06_ooo`03o`2Ioooooooo073oool0
06Ooool00`0003?o03?o000V<ol000<0003oooooool06_ooo`03o`2Ioooooooo073oool006Ooool0
0`0003?o03?o000U<ol000<0003oooooool06oooo`03o`2Ioooooooo073oool006Ooool200009S?o
00030000oooooooo01_oool00ol0VOooooooo`1`oooo001Woooo00<0000co`0co`009C?o00030000
oooooooo01_oool00ol0VOooooooo`1`oooo001Woooo00<0000co`0co`009C?o00030000oooooooo
01_oool00ol0VOooooooo`1`oooo001Woooo00<0000co`0co`0093?o00030000oooooooo01coool0
0ol0VOooooooo`1`oooo001Woooo0P0002Dco`000`000?ooooooo`0Loooo00?o09Woooooool0L?oo
o`00Ioooo`030000<ol0<ol002@co`000`000?ooooooo`0Loooo00?o09Woooooool0L?ooo`00C_oo
o`800004oooo0P0000Goool00`000?ooooooo`02oooo0P0000Goool00`0003?o03?o000S<ol000<0
003oooooool07Oooo`03o`2Ioooooooo073oool004goool010000?ooooooo`0000[oool01@000?oo
ooooooooo`000002oooo00<0003oooooool00_ooo`030000<ol0<ol002<co`000`000?ooooooo`0M
oooo00?o09Woooooool0L?ooo`00COooo`040000oooooooo00002_ooo`030000oooooooo00Coool0
0`000?ooooooo`02oooo0P0002@co`000`000?ooooooo`0Moooo00?o09Woooooool0L?ooo`00COoo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`0003?o03?o000R<ol000<0
003oooooool07_ooo`03o`2Ioooooooo073oool004goool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`04oooo00<0000co`0co`008S?o00030000oooooooo01koool0
0ol0VOooooooo`1`oooo001>oooo0P0000Woool400000oooo`<00004oooo00<0000co`0co`008S?o
00030000oooooooo01koool00ol0VOooooooo`1`oooo001Woooo0P0002<co`000`000?ooooooo`0N
oooo00?o09Woooooool0L?ooo`00Ioooo`030000<ol0<ol0024co`000`000?ooooooo`0Ooooo00?o
09Woooooool0L?ooo`00Ioooo`030000<ol0<ol0024co`000`000?ooooooo`0Ooooo00?o09Wooooo
ool0L?ooo`00Ioooo`030000<ol0<ol0024co`000`000?ooooooo`0Ooooo00?o09Woooooool0L?oo
o`00Ioooo`80000R<ol000<0003oooooool07oooo`03o`2Ioooooooo073oool006Ooool00`0003?o
03?o000P<ol000<0003oooooool08?ooo`03o`2Ioooooooo073oool006Ooool00`0003?o03?o000P
<ol000<0003oooooool08?ooo`03o`2Ioooooooo073oool006Ooool00`0003?o03?o000P<ol000<0
003oooooool08?ooo`03o`2Ioooooooo073oool006Ooool200008C?o00030000oooooooo023oool0
0ol0VOooooooo`1`oooo001Woooo00<0000co`0co`007c?o00030000oooooooo027oool00ol0VOoo
ooooo`1`oooo001Woooo00<0000co`0co`007c?o00030000oooooooo027oool00ol0VOooooooo`1`
oooo001Woooo00<0000co`0co`007c?o00030000oooooooo027oool00ol0VOooooooo`1`oooo001W
oooo0P00020co`000`000?ooooooo`0Qoooo00?o09Woooooool0L?ooo`00Ioooo`030000<ol0<ol0
01lco`000`000?ooooooo`0Qoooo00?o09Woooooool0L?ooo`00Goooo`D00003oooo00<0000co`0c
o`007S?o00030000oooooooo02;oool00ol0VOooooooo`1`oooo001Qoooo00<0003oooooool00ooo
o`030000<ol0<ol001hco`000`000?ooooooo`0Roooo00?o09Woooooool0L?ooo`00HOooo`030000
oooooooo00?oool200007c?o00030000oooooooo02;oool00ol0VOooooooo`1`oooo001Qoooo00<0
003oooooool00oooob4co`2Hoooo001Qoooo00<0003oooooool00oooob4co`2Hoooo001Poooo0P00
00GooolQ<ol0V?ooo`00Ioooob0co`2Ioooo001Woooo83?o09Woool006Ooool?<ol000<0000co`0c
o`003S?o023oool00`000?ooooooo`1foooo001Woooo3S?o00030000<ol0<ol000Pco`000`0003?o
03?o0004<ol08Oooo`030000oooooooo07Goool006Ooool><ol000<0000co`0co`000S?o00800004
<ol000<0000co`0co`000c?o00[oool200001?ooo`800003oooo1@000003oooo0000000000800003
oooo00<0003oooooool0MOooo`00Ioooo`hco`001@0003?o03?o03?o00000002<ol000<0000co`0c
o`000S?o00030000<ol0<ol0008co`02oooo100000?oool010000?ooooooo`0000[oool01@000?oo
ooooooooo`000006oooo00<0003oooooool0MOooo`00Ioooo`dco`000`0003?o03?o0002<ol000<0
000co`0co`002S?o00Woool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003ooooo
ool01?ooo`030000oooooooo07Coool006Ooool><ol000<0000co`0co`001@0000Tco`09oooo00@0
003oooooool0000:oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`1e
oooo001Woooo3S?o00050000<ol0<ol0<ol0000000`co`09oooo00@0003oooooool0000:oooo00D0
003oooooooooool000000_ooo`050000oooooooooooo000007Ooool006Ooool?<ol000<0000co`0c
o`003C?o00[oool200002_ooo`800004oooo0P0000?oool00`000?ooooooo`1foooo001Woooo7S?o
09_oool006OooolN<ol0Voooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {650.563, 509.25}} -> {-0.349561, \
3.60372, 0.00349883, 0.00566123}, {{79.875, 308.563}, {650.563, 509.25}} -> \
{-2.52168, 7.08191, 0.0124465, 0.0127866}, {{79.875, 308.563}, {650.563, \
509.25}} -> {-2.52168, 7.08191, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.11) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.59832 .30902 L
.60873 .30902 L
.61445 .30902 L
.61726 .30902 L
.61984 .30902 L
.62236 .30902 L
.62363 .30902 L
s
.62363 .30902 m
.6237 .61803 L
s
0 .4 1 r
.02381 .36926 m
.03279 .38248 L
.04262 .39603 L
.04758 .40252 L
.05288 .40921 L
.05546 .41237 L
.05672 .4139 L
.05789 .4153 L
.05895 .41613 L
.06007 .41528 L
.06244 .41351 L
.10458 .3865 L
.14241 .36815 L
.1827 .35324 L
.22147 .34228 L
.2627 .33336 L
.30241 .32672 L
.3406 .32165 L
.36192 .31943 L
.38125 .31784 L
.42038 .31547 L
.43962 .31459 L
.46044 .31378 L
.50145 .31254 L
.54093 .31167 L
.5789 .31104 L
.60005 .31076 L
.61006 .31064 L
.61447 .31059 L
.61697 .31056 L
.61933 .31053 L
.62156 .31051 L
.62282 .3105 L
.62397 .30902 L
.62512 .30902 L
.62637 .30902 L
.62768 .30902 L
.6289 .30902 L
.62955 .30902 L
.63026 .30902 L
.63154 .30902 L
.63278 .30902 L
.63393 .30902 L
.63518 .30902 L
.63588 .30902 L
.63654 .30902 L
.63724 .30902 L
.63788 .30902 L
.63861 .30902 L
.63931 .30902 L
Mistroke
.6405 .30902 L
.64159 .30902 L
.64283 .30902 L
.64401 .30902 L
.6451 .30902 L
.6461 .30902 L
.6472 .30902 L
.64837 .30902 L
.64954 .30902 L
.6508 .30902 L
.65199 .30902 L
.65307 .30902 L
.65435 .30902 L
.65506 .30902 L
.65573 .30902 L
.65695 .30902 L
.65824 .30902 L
.65948 .30902 L
.66063 .30902 L
.66183 .30902 L
.66314 .30902 L
.66428 .30902 L
.66531 .30902 L
.66651 .30902 L
.66763 .30902 L
.66886 .30902 L
.67016 .30902 L
.67127 .30902 L
.67249 .30902 L
.6738 .30902 L
.67454 .30902 L
.67521 .30902 L
.67651 .30902 L
.67775 .30902 L
.67879 .30902 L
.67995 .30902 L
.68116 .30902 L
.68229 .30902 L
.68335 .30902 L
.68432 .30902 L
.68538 .30902 L
.68651 .30902 L
.68764 .30902 L
.68886 .30902 L
.69001 .30902 L
.69106 .30902 L
.69229 .30902 L
.69298 .30902 L
.69362 .30902 L
.69479 .30902 L
Mistroke
.69604 .30902 L
.69725 .30902 L
.69856 .30902 L
.69981 .30902 L
.70096 .30902 L
.7021 .30902 L
.70314 .30902 L
.70434 .30902 L
.70546 .30902 L
.70669 .30902 L
.708 .30902 L
.70911 .30902 L
.71033 .30902 L
.71164 .30902 L
.71236 .30902 L
.71305 .30902 L
.71369 .30902 L
.71438 .30902 L
.71559 .30902 L
.71672 .30902 L
.71778 .30902 L
.71895 .30902 L
.7202 .30902 L
.72145 .30902 L
.72276 .30902 L
.72388 .30902 L
.7251 .30902 L
.72623 .30902 L
.7273 .30902 L
.72854 .30902 L
.72966 .30902 L
.73072 .30902 L
.73169 .30902 L
.73276 .30902 L
.7339 .30902 L
.73511 .30902 L
.73643 .30902 L
.73768 .30902 L
.73883 .30902 L
.73998 .30902 L
.74102 .30902 L
.74221 .30902 L
.74334 .30902 L
.74458 .30902 L
.74588 .30902 L
.747 .30902 L
.74822 .30902 L
.74954 .30902 L
.75027 .30902 L
.75094 .30902 L
Mistroke
.75225 .30902 L
.75348 .30902 L
.75454 .30902 L
.7557 .30902 L
.75691 .30902 L
.75805 .30902 L
.75911 .30902 L
.76008 .30902 L
.7612 .30902 L
.76227 .30902 L
.76341 .30902 L
.76463 .30902 L
.76578 .30902 L
.76682 .30902 L
.76806 .30902 L
.76875 .30902 L
.76939 .30902 L
.77056 .30902 L
.7718 .30902 L
.77302 .30902 L
.77371 .30902 L
.77435 .30902 L
.77551 .30902 L
.77676 .30902 L
.77786 .30902 L
.7789 .30902 L
.78004 .30902 L
.78127 .30902 L
.78251 .30902 L
.7832 .30902 L
.78385 .30902 L
.78517 .30902 L
.7859 .30902 L
.78657 .30902 L
.78777 .30902 L
.78907 .30902 L
.7903 .30902 L
.79143 .30902 L
.79249 .30902 L
.79362 .30902 L
.79469 .30902 L
.79567 .30902 L
.79681 .30902 L
.79806 .30902 L
.79924 .30902 L
.80033 .30902 L
.80157 .30902 L
.80273 .30902 L
.80377 .30902 L
.8049 .30902 L
Mistroke
.80613 .30902 L
.80743 .30902 L
.80854 .30902 L
.80976 .30902 L
.81107 .30902 L
.81228 .30902 L
.81291 .30902 L
.81361 .30902 L
.81433 .30902 L
.81502 .30902 L
.81626 .30902 L
.81741 .30902 L
.81867 .30902 L
.81999 .30902 L
.8211 .30902 L
.82229 .30902 L
.82342 .30902 L
.82444 .30902 L
.82564 .30902 L
.82694 .30902 L
.82817 .30902 L
.8293 .30902 L
.8305 .30902 L
.83164 .30902 L
.83295 .30902 L
.83415 .30902 L
.83546 .30902 L
.83621 .30902 L
.8369 .30902 L
.83814 .30902 L
.83877 .30902 L
.83947 .30902 L
.84015 .30902 L
.84086 .30902 L
.84214 .30902 L
.84285 .30902 L
.84351 .30902 L
.84424 .30902 L
.84501 .30902 L
.84569 .30902 L
.84642 .30902 L
.84711 .30902 L
.84774 .30902 L
.84895 .30902 L
.85023 .30902 L
.85143 .30902 L
.85275 .30902 L
.85399 .30902 L
.85514 .30902 L
.85628 .30902 L
Mistroke
.85732 .30902 L
.85852 .30902 L
.85964 .30902 L
.86087 .30902 L
.86217 .30902 L
.86329 .30902 L
.86451 .30902 L
.86582 .30902 L
.86656 .30902 L
.86723 .30902 L
.86846 .30902 L
.86977 .30902 L
.87088 .30902 L
.87211 .30902 L
.87322 .30902 L
.87427 .30902 L
.8755 .30902 L
.87663 .30902 L
.87786 .30902 L
.87917 .30902 L
.88023 .30902 L
.88137 .30902 L
.88244 .30902 L
.88342 .30902 L
.88457 .30902 L
.88581 .30902 L
.88699 .30902 L
.88807 .30902 L
.88932 .30902 L
.89051 .30902 L
.89158 .30902 L
.89274 .30902 L
.89518 .30902 L
.89582 .30902 L
.89651 .30902 L
.89777 .30902 L
.89905 .30902 L
.90024 .30902 L
.90133 .30902 L
.90247 .30902 L
.90355 .30902 L
.90456 .30902 L
.90566 .30902 L
.90684 .30902 L
.90751 .30902 L
.90822 .30902 L
.9095 .30902 L
.91021 .30902 L
.91087 .30902 L
.9116 .30902 L
Mistroke
.91239 .30902 L
.91306 .30902 L
.9138 .30902 L
.91449 .30902 L
.91513 .30902 L
.91635 .30902 L
.91764 .30902 L
.91892 .30902 L
.91964 .30902 L
.9203 .30902 L
.92151 .30902 L
.9228 .30902 L
.92395 .30902 L
.92503 .30902 L
.92621 .30902 L
.92748 .30902 L
.92869 .30902 L
.92939 .30902 L
.93004 .30902 L
.93134 .30902 L
.93208 .30902 L
.93276 .30902 L
.93389 .30902 L
.93513 .30902 L
.93643 .30902 L
.93764 .30902 L
.93833 .30902 L
.93908 .30902 L
.93979 .30902 L
.94044 .30902 L
.94168 .30902 L
.94299 .30902 L
.94366 .30902 L
.94439 .30902 L
.94571 .30902 L
.94651 .30902 L
.94727 .30902 L
.94801 .30902 L
.9487 .30902 L
.94997 .30902 L
.95112 .30902 L
.95235 .30902 L
.95305 .30902 L
.95369 .30902 L
.95477 .30902 L
.95594 .30902 L
.95717 .30902 L
.95832 .30902 L
.95897 .30902 L
.95968 .30902 L
Mistroke
.96097 .30902 L
.96223 .30902 L
.96339 .30902 L
.96464 .30902 L
.96535 .30902 L
.96602 .30902 L
.96667 .30902 L
.96736 .30902 L
.96811 .30902 L
.96882 .30902 L
.9698 .30902 L
.97069 .30902 L
.97171 .30902 L
.97266 .30902 L
.97355 .30902 L
.97436 .30902 L
.97525 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.11) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol0<ol000Dco`00100003?o03?o03?o00@0I_l00`00001Vo`1Vo`0506Ko00<00000I_l0
I_l01@1Vo`03000006Ko06Ko00D0I_l00`00001Vo`1Vo`0506Ko00<0000co`0co`001C?o00030000
<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000<co`0/
00001oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0Uoooo00<0003oooooool09_oo
o`030000<ol0<ol000dco`0D06Ko13?o00030000<ol0<ol001`co`000ol0VC?o03?o0006<ol000<0
000co`0co`004C?o00X0000:oooo00<0003oooooool09_ooo`030000oooooooo01Goool006Ooool0
0`0003?o03?o000=06Ko=c?o0003o`2I<ol0<ol0010co`0:0000EOooo`00Hoooo`@0I_l2000000<0
I_lco`0co`00@S?o0003o`2I<ol0<ol000Xco`060000Goooo`00Foooo`P0I_l4oooo00<0000co`0c
o`00A3?o0003o`2I<ol0<ol000Hco`040000IOooo`00E_ooo`D0I_l<oooo00<0000co`0co`00A3?o
0003o`2I<ol0<ol000@co`020000JOooo`00DOooo`D0I_lAoooo00<0000co`0co`00A3?o0004o`2I
<ol0<ol0<ol00`0006_oool004_oool606Ko5_ooo`800015<ol000Co09Tco`000000001^oooo0017
oooo101Voacoool00`0003?o03?o0014<ol000?o09T0003oool0Koooo`00A?ooo`<0I_lPoooo00<0
000co`0co`00@S?o008000000ol0VOooooooo`1_oooo0011oooo0`1Vob?oool00`0003?o03?o0010
<ol00P0000;oool00ol0VOooooooo`1_oooo000noooo0`1VobKoool20000@3?o00030000oooooooo
00;oool00ol0VOooooooo`1_oooo000joooo101VobWoool00`0003?o03?o000n<ol000<0003ooooo
ool00oooo`03o`2Ioooooooo06ooool003Koool406Ko;Oooo`030000<ol0<ol003`co`0200001_oo
o`03o`2Ioooooooo06ooool003Coool206Ko<Oooo`030000<ol0<ol003/co`000`000?ooooooo`06
oooo00?o09Woooooool0Koooo`005_ooo`0306Kooooooooo01Woool206Ko<oooo`80000k<ol000<0
003oooooool01oooo`03o`2Ioooooooo06ooool001Ooool00`1Vooooooooo`0Foooo0P1VocGoool0
0`0003?o03?o000i<ol000<0003oooooool02?ooo`03o`2Ioooooooo06ooool001Soool00`1Voooo
ooooo`0Coooo0P1Voakoool200001?ooo`800003oooo100000?oool200001Oooo`030000<ol0<ol0
03Lco`0200002oooo`03o`2Ioooooooo06ooool001Woool00`1Vooooooooo`0@oooo0P1Voaooool0
10000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004oooo00<0000co`0c
o`00=S?o00030000oooooooo00_oool00ol0VOooooooo`1_oooo000Joooo00<0I_ooooooool03_oo
o`0306Kooooooooo01ooool010000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003ooooo
ool00_ooo`80000f<ol000<0003oooooool03?ooo`03o`2Ioooooooo06ooool001[oool00`1Voooo
ooooo`0<oooo0P1Vob;oool010000?ooooooo`0000[oool00`000?ooooooo`02oooo0P0000Goool0
0`0003?o03?o000d<ol000<0003oooooool03Oooo`03o`2Ioooooooo06ooool001_oool00`1Voooo
ooooo`0:oooo00<0I_ooooooool08_ooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`0003?o03?o000d<ol000<0003oooooool03Oooo`03o`2Ioooooooo
06ooool001_oool00`1Vooooooooo`08oooo0P1VobKoool200002_ooo`800004oooo0`0000Coool0
0`0003?o03?o000c<ol000<0003oooooool03_ooo`03o`2Ioooooooo06ooool001coool00`1Voooo
ooooo`05oooo0P1Vod7oool20000<c?o00030000oooooooo00ooool00ol0VOooooooo`1_oooo000M
oooo00<0I_ooooooool00oooo`0306Kooooooooo047oool00`0003?o03?o000a<ol000<0003ooooo
ool04?ooo`03o`2Ioooooooo06ooool001koool00`1Vooooooooo`0206KoA?ooo`030000<ol0<ol0
034co`000`000?ooooooo`0@oooo00?o09Woooooool0Koooo`007_ooo`<0I_m6oooo00<0000co`0c
o`00<3?o00030000oooooooo017oool00ol0VOooooooo`1_oooo000Ooooo00<0I_ooooooool0AOoo
o`80000`<ol000<0003oooooool04_ooo`03o`2Ioooooooo06ooool006Ooool00`0003?o03?o000_
<ol000<0003oooooool04_ooo`03o`2Ioooooooo06ooool006Ooool00`0003?o03?o000^<ol000<0
003oooooool04oooo`03o`2Ioooooooo06ooool006Ooool00`0003?o03?o000^<ol000<0003ooooo
ool04oooo`03o`2Ioooooooo06ooool006Ooool20000;S?o00030000oooooooo01Coool00ol0VOoo
ooooo`1_oooo001Woooo00<0000co`0co`00;C?o00030000oooooooo01Coool00ol0VOooooooo`1_
oooo001Woooo00<0000co`0co`00;3?o00030000oooooooo01Goool00ol0VOooooooo`1_oooo001W
oooo00<0000co`0co`00;3?o00030000oooooooo01Goool00ol0VOooooooo`1_oooo001Woooo0P00
02`co`000`000?ooooooo`0Foooo00?o09Woooooool0Koooo`00Ioooo`030000<ol0<ol002/co`00
0`000?ooooooo`0Foooo00?o09Woooooool0Koooo`00E?ooo`800004oooo0P0000Coool200001Ooo
o`030000<ol0<ol002Xco`000`000?ooooooo`0Goooo00?o09Woooooool0Koooo`00Doooo`040000
oooooooo00002?ooo`040000oooooooo00001?ooo`030000<ol0<ol002Xco`000`000?ooooooo`0G
oooo00?o09Woooooool0Koooo`00Doooo`040000oooooooo00002oooo`030000oooooooo00;oool2
0000:S?o00030000oooooooo01Soool00ol0VOooooooo`1_oooo001Coooo00@0003oooooool00009
oooo0P0000Goool00`0003?o03?o000Y<ol000<0003oooooool06?ooo`03o`2Ioooooooo06ooool0
05?oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0000co`0co`00:3?o00030000
oooooooo01Woool00ol0VOooooooo`1_oooo001Doooo0P0000[oool300001?ooo`030000<ol0<ol0
02Pco`000`000?ooooooo`0Ioooo00?o09Woooooool0Koooo`00Ioooo`80000Y<ol000<0003ooooo
ool06Oooo`03o`2Ioooooooo06ooool006Ooool00`0003?o03?o000W<ol000<0003oooooool06_oo
o`03o`2Ioooooooo06ooool006Ooool00`0003?o03?o000W<ol000<0003oooooool06_ooo`03o`2I
oooooooo06ooool006Ooool200009c?o00030000oooooooo01_oool00ol0VOooooooo`1_oooo001W
oooo00<0000co`0co`009S?o00030000oooooooo01_oool00ol0VOooooooo`1_oooo001Woooo00<0
000co`0co`009S?o00030000oooooooo01_oool00ol0VOooooooo`1_oooo001Woooo00<0000co`0c
o`009C?o00030000oooooooo01coool00ol0VOooooooo`1_oooo001Woooo0P0002Hco`000`000?oo
ooooo`0Loooo00?o09Woooooool0Koooo`00Ioooo`030000<ol0<ol002Dco`000`000?ooooooo`0L
oooo00?o09Woooooool0Koooo`00Ioooo`030000<ol0<ol002Dco`000`000?ooooooo`0Loooo00?o
09Woooooool0Koooo`00Ioooo`030000<ol0<ol002@co`000`000?ooooooo`0Moooo00?o09Wooooo
ool0Koooo`00Ioooo`80000U<ol000<0003oooooool07Oooo`03o`2Ioooooooo06ooool006Ooool0
0`0003?o03?o000T<ol000<0003oooooool07Oooo`03o`2Ioooooooo06ooool004koool200001?oo
o`800005oooo00<0003oooooool00_ooo`800005oooo00<0000co`0co`008c?o00030000oooooooo
01koool00ol0VOooooooo`1_oooo001=oooo00@0003oooooool0000:oooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`0003?o03?o000S<ol000<0003oooooool07_ooo`03o`2I
oooooooo06ooool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003ooooo
ool00_ooo`80000T<ol000<0003oooooool07_ooo`03o`2Ioooooooo06ooool004goool010000?oo
ooooo`0000_oool010000?ooooooooooo`800005oooo00<0000co`0co`008S?o00030000oooooooo
01ooool00ol0VOooooooo`1_oooo001=oooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool01?ooo`030000<ol0<ol0028co`000`000?ooooooo`0Ooooo00?o09Wooooo
ool0Koooo`00C_ooo`800009oooo100000?oool300001?ooo`030000<ol0<ol0028co`000`000?oo
ooooo`0Ooooo00?o09Woooooool0Koooo`00Ioooo`80000S<ol000<0003oooooool07oooo`03o`2I
oooooooo06ooool006Ooool00`0003?o03?o000Q<ol000<0003oooooool08?ooo`03o`2Ioooooooo
06ooool006Ooool00`0003?o03?o000Q<ol000<0003oooooool08?ooo`03o`2Ioooooooo06ooool0
06Ooool00`0003?o03?o000Q<ol000<0003oooooool08?ooo`03o`2Ioooooooo06ooool006Ooool2
00008S?o00030000oooooooo023oool00ol0VOooooooo`1_oooo001Woooo00<0000co`0co`0083?o
00030000oooooooo027oool00ol0VOooooooo`1_oooo001Woooo00<0000co`0co`0083?o00030000
oooooooo027oool00ol0VOooooooo`1_oooo001Woooo00<0000co`0co`0083?o00030000oooooooo
027oool00ol0VOooooooo`1_oooo001Woooo0P00024co`000`000?ooooooo`0Qoooo00?o09Wooooo
ool0Koooo`00Ioooo`030000<ol0<ol001lco`000`000?ooooooo`0Roooo00?o09Woooooool0Kooo
o`00Ioooo`030000<ol0<ol001lco`000`000?ooooooo`0Roooo00?o09Woooooool0Koooo`00Iooo
o`030000<ol0<ol001lco`000`000?ooooooo`0Roooo00?o09Woooooool0Koooo`00Ioooo`80000P
<ol000<0003oooooool08_ooo`03o`2Ioooooooo06ooool006Ooool00`0003?o03?o000O<ol000<0
003oooooool08_ooo`03o`2Ioooooooo06ooool005ooool500000oooo`030000<ol0<ol001hco`00
0`000?ooooooo`0Soooo00?o09Woooooool0Koooo`00HOooo`030000oooooooo00?oool00`0003?o
03?o000N<ol000<0003oooooool08oooo`03o`2Ioooooooo06ooool0067oool00`000?ooooooo`03
oooo0P0001lco`000`000?ooooooo`0Soooo00?o09Woooooool0Koooo`00HOooo`030000oooooooo
00?ooolQ<ol0V?ooo`00HOooo`030000oooooooo00?ooolQ<ol0V?ooo`00H?ooo`800005oooo8C?o
09Soool006OooolP<ol0VOooo`00Ioooob0co`2Ioooo001Woooo3c?o00030000<ol0<ol000hco`0P
oooo00<0003oooooool0M_ooo`00Ioooo`hco`000`0003?o03?o0008<ol000<0000co`0co`0013?o
027oool00`000?ooooooo`1eoooo001Woooo3S?o00030000<ol0<ol0008co`02000013?o00030000
<ol0<ol000<co`0:oooo0P0000Coool200000oooo`D000000oooo`000000000300000_ooo`030000
oooooooo07Goool006Ooool><ol000D0000co`0co`0co`0000000S?o00030000<ol0<ol0008co`00
0`0003?o03?o0002<ol00_ooo`@00003oooo00@0003oooooool0000:oooo00<0003oooooool00ooo
o`030000oooooooo00;oool00`000?ooooooo`1eoooo001Woooo3C?o00030000<ol0<ol0008co`00
0`0003?o03?o000:<ol02Oooo`040000oooooooo00002_ooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<0003oooooool0M?ooo`00Ioooo`hco`000`0003?o03?o000500002C?o00Woool0
10000?ooooooo`0000[oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`030000oooooooo
07Goool006Ooool><ol000D0000co`0co`0co`00000033?o00Woool010000?ooooooo`0000[oool0
0`000?ooooooo`03oooo00<0003oooooool00_ooo`030000oooooooo07Goool006Ooool?<ol000<0
000co`0co`003C?o00[oool200002_ooo`800004oooo0P0000?oool00`000?ooooooo`1foooo001W
oooo7S?o09_oool006OooolN<ol0Voooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {204.5, 63.1875}} -> {-0.349561, \
0.447144, 0.00349883, 0.00566123}, {{79.875, 308.563}, {204.5, 63.1875}} -> \
{-2.52168, -0.0476099, 0.0124465, 0.0127866}, {{79.875, 308.563}, {204.5, \
63.1875}} -> {-2.52168, -0.0476099, 0.0124465, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
.34187 2.75315 L
.34309 2.69809 L
.36276 1.98278 L
.37376 1.69407 L
.38373 1.48107 L
.40298 1.16682 L
.41382 1.0319 L
.4238 .9281 L
.44262 .77349 L
.46328 .64992 L
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.3409 .61803 L
s
.47058 .61803 m
.48279 .56469 L
.50371 .49749 L
.52495 .44767 L
.54507 .41288 L
.56498 .38716 L
.5834 .36913 L
.60206 .35512 L
.62267 .34345 L
.64201 .3352 L
.66287 .32851 L
.68291 .32371 L
.70401 .31992 L
.72375 .31727 L
.74212 .31539 L
.76257 .31379 L
.78116 .31269 L
.80035 .31182 L
.82114 .31111 L
.84102 .3106 L
.86206 .31019 L
.88164 .30991 L
.89995 .30971 L
.92024 .30953 L
.93877 .30942 L
.95668 .30933 L
.97619 .30925 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.59832 .30902 L
.60873 .30902 L
.61445 .30902 L
.61984 .30902 L
.62236 .30902 L
.62502 .30902 L
.6257 .30902 L
.62642 .30902 L
s
.62642 .30902 m
.6265 .61803 L
s
0 .4 1 r
.02381 .36437 m
.03279 .3779 L
.04262 .39176 L
.04758 .39839 L
.0503 .40194 L
.05288 .40524 L
.05405 .40671 L
.05528 .40825 L
.05593 .40833 L
.05664 .40783 L
.05789 .40696 L
.06244 .40385 L
.10458 .37933 L
.14487 .36175 L
.18364 .34888 L
.22486 .33845 L
.26457 .33079 L
.30277 .32503 L
.32408 .32235 L
.34341 .32019 L
.38254 .31694 L
.40179 .31579 L
.42261 .31477 L
.46361 .31324 L
.5031 .31218 L
.54107 .31142 L
.58149 .31082 L
.60013 .31059 L
.60996 .31049 L
.6204 .31038 L
.62293 .31036 L
.62425 .31035 L
.62565 .31033 L
.62639 .31033 L
.6272 .30902 L
.62794 .30902 L
.62863 .30902 L
.62934 .30902 L
.62999 .30902 L
.63073 .30902 L
.63143 .30902 L
.63267 .30902 L
.63398 .30902 L
.6351 .30902 L
.63633 .30902 L
.63765 .30902 L
.6384 .30902 L
.63908 .30902 L
.64039 .30902 L
.64164 .30902 L
Mistroke
.64291 .30902 L
.64406 .30902 L
.6447 .30902 L
.64539 .30902 L
.64664 .30902 L
.64781 .30902 L
.64905 .30902 L
.65011 .30902 L
.65127 .30902 L
.65197 .30902 L
.65264 .30902 L
.65389 .30902 L
.65459 .30902 L
.65524 .30902 L
.65595 .30902 L
.6567 .30902 L
.65794 .30902 L
.65911 .30902 L
.66039 .30902 L
.66111 .30902 L
.66176 .30902 L
.66305 .30902 L
.66426 .30902 L
.66534 .30902 L
.66652 .30902 L
.6678 .30902 L
.66845 .30902 L
.66916 .30902 L
.67042 .30902 L
.67159 .30902 L
.67277 .30902 L
.6739 .30902 L
.6749 .30902 L
.676 .30902 L
.67719 .30902 L
.67845 .30902 L
.67953 .30902 L
.68072 .30902 L
.68203 .30902 L
.68269 .30902 L
.6834 .30902 L
.68468 .30902 L
.68586 .30902 L
.68658 .30902 L
.68727 .30902 L
.68854 .30902 L
.68926 .30902 L
.68991 .30902 L
.69064 .30902 L
.6914 .30902 L
Mistroke
.69259 .30902 L
.69387 .30902 L
.69508 .30902 L
.69618 .30902 L
.69747 .30902 L
.6982 .30902 L
.69888 .30902 L
.70012 .30902 L
.70144 .30902 L
.70268 .30902 L
.70339 .30902 L
.70405 .30902 L
.70474 .30902 L
.70538 .30902 L
.70611 .30902 L
.7068 .30902 L
.70803 .30902 L
.70917 .30902 L
.71041 .30902 L
.71104 .30902 L
.71174 .30902 L
.71244 .30902 L
.71318 .30902 L
.7145 .30902 L
.71524 .30902 L
.71592 .30902 L
.71667 .30902 L
.71748 .30902 L
.71818 .30902 L
.71893 .30902 L
.71964 .30902 L
.7203 .30902 L
.72155 .30902 L
.72287 .30902 L
.72412 .30902 L
.72526 .30902 L
.72658 .30902 L
.72783 .30902 L
.72899 .30902 L
.73005 .30902 L
.73123 .30902 L
.73248 .30902 L
.73319 .30902 L
.73385 .30902 L
.73457 .30902 L
.73533 .30902 L
.73601 .30902 L
.73673 .30902 L
.73802 .30902 L
.73925 .30902 L
Mistroke
.74042 .30902 L
.74108 .30902 L
.74179 .30902 L
.74304 .30902 L
.74427 .30902 L
.74539 .30902 L
.74668 .30902 L
.74791 .30902 L
.74904 .30902 L
.75009 .30902 L
.75125 .30902 L
.75248 .30902 L
.75318 .30902 L
.75382 .30902 L
.75453 .30902 L
.75528 .30902 L
.75654 .30902 L
.75726 .30902 L
.75793 .30902 L
.75917 .30902 L
.76031 .30902 L
.76162 .30902 L
.76287 .30902 L
.76407 .30902 L
.76476 .30902 L
.7654 .30902 L
.7667 .30902 L
.76743 .30902 L
.7681 .30902 L
.76922 .30902 L
.77046 .30902 L
.77174 .30902 L
.77294 .30902 L
.77362 .30902 L
.77437 .30902 L
.77507 .30902 L
.77571 .30902 L
.77694 .30902 L
.77824 .30902 L
.77891 .30902 L
.77963 .30902 L
.78093 .30902 L
.78173 .30902 L
.78248 .30902 L
.78316 .30902 L
.7839 .30902 L
.78454 .30902 L
.78523 .30902 L
.78646 .30902 L
.78778 .30902 L
Mistroke
.78852 .30902 L
.78922 .30902 L
.79049 .30902 L
.79164 .30902 L
.79228 .30902 L
.79297 .30902 L
.79423 .30902 L
.79536 .30902 L
.7966 .30902 L
.79789 .30902 L
.7991 .30902 L
.80023 .30902 L
.80127 .30902 L
.80249 .30902 L
.8036 .30902 L
.80482 .30902 L
.80613 .30902 L
.80734 .30902 L
.80849 .30902 L
.80913 .30902 L
.80982 .30902 L
.81105 .30902 L
.81173 .30902 L
.81237 .30902 L
.81307 .30902 L
.81383 .30902 L
.81671 .30902 L
.8174 .30902 L
.81813 .30902 L
.81945 .30902 L
.82062 .30902 L
.82191 .30902 L
.82257 .30902 L
.82328 .30902 L
.82458 .30902 L
.82583 .30902 L
.82697 .30902 L
.82828 .30902 L
.82953 .30902 L
.83067 .30902 L
.83173 .30902 L
.8329 .30902 L
.83413 .30902 L
.83537 .30902 L
.83606 .30902 L
.8367 .30902 L
.83793 .30902 L
.83911 .30902 L
.83977 .30902 L
.84047 .30902 L
Mistroke
.84173 .30902 L
.8425 .30902 L
.84323 .30902 L
.84388 .30902 L
.84459 .30902 L
.84591 .30902 L
.84714 .30902 L
.84784 .30902 L
.84848 .30902 L
.84923 .30902 L
.84993 .30902 L
.85061 .30902 L
.85133 .30902 L
.85263 .30902 L
.85335 .30902 L
.85403 .30902 L
.85477 .30902 L
.85557 .30902 L
.8568 .30902 L
.85749 .30902 L
.85814 .30902 L
.85945 .30902 L
.86018 .30902 L
.86084 .30902 L
.86204 .30902 L
.86333 .30902 L
.86455 .30902 L
.86568 .30902 L
.86693 .30902 L
.86812 .30902 L
.86919 .30902 L
.87035 .30902 L
.87161 .30902 L
.87232 .30902 L
.87296 .30902 L
.8742 .30902 L
.87537 .30902 L
.87648 .30902 L
.87765 .30902 L
.87864 .30902 L
.87974 .30902 L
.88091 .30902 L
.88217 .30902 L
.88336 .30902 L
.88445 .30902 L
.88573 .30902 L
.88638 .30902 L
.88709 .30902 L
.88835 .30902 L
.88953 .30902 L
Mistroke
.89024 .30902 L
.89092 .30902 L
.89219 .30902 L
.8929 .30902 L
.89356 .30902 L
.89428 .30902 L
.89505 .30902 L
.89635 .30902 L
.89709 .30902 L
.89776 .30902 L
.899 .30902 L
.90031 .30902 L
.90149 .30902 L
.90259 .30902 L
.90379 .30902 L
.90509 .30902 L
.9063 .30902 L
.90699 .30902 L
.90764 .30902 L
.90895 .30902 L
.90963 .30902 L
.91036 .30902 L
.9116 .30902 L
.91291 .30902 L
.91412 .30902 L
.91525 .30902 L
.91594 .30902 L
.91669 .30902 L
.9174 .30902 L
.91805 .30902 L
.91928 .30902 L
.92059 .30902 L
.92127 .30902 L
.922 .30902 L
.92331 .30902 L
.92412 .30902 L
.92488 .30902 L
.92556 .30902 L
.92631 .30902 L
.92696 .30902 L
.92767 .30902 L
.92896 .30902 L
.93021 .30902 L
.93136 .30902 L
.93261 .30902 L
.93332 .30902 L
.93398 .30902 L
.93468 .30902 L
.93531 .30902 L
.93605 .30902 L
Mistroke
.93674 .30902 L
.9379 .30902 L
.93899 .30902 L
.94013 .30902 L
.94138 .30902 L
.94264 .30902 L
.94335 .30902 L
.944 .30902 L
.94518 .30902 L
.94642 .30902 L
.94739 .30902 L
.94844 .30902 L
.94942 .30902 L
.95033 .30902 L
.95116 .30902 L
.95206 .30902 L
.953 .30902 L
.95388 .30902 L
.95491 .30902 L
.95589 .30902 L
.95677 .30902 L
.95773 .30902 L
.95884 .30902 L
.95989 .30902 L
.96083 .30902 L
.96185 .30902 L
.96276 .30902 L
.96373 .30902 L
.96455 .30902 L
.96546 .30902 L
.96642 .30902 L
.96744 .30902 L
.96841 .30902 L
.96929 .30902 L
.97018 .30902 L
.97099 .30902 L
.97189 .30902 L
.97284 .30902 L
.97366 .30902 L
.97443 .30902 L
.97528 .30902 L
.97619 .30902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.31746 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -12 -9 ]
[.18254 .29652 12 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -9 -9 ]
[.81746 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.32877 0 -12 -4.5 ]
[.32877 0 0 4.5 ]
[.32877 .07725 -30 -4.5 ]
[.32877 .07725 0 4.5 ]
[.32877 .15451 -24 -4.5 ]
[.32877 .15451 0 4.5 ]
[.32877 .23176 -30 -4.5 ]
[.32877 .23176 0 4.5 ]
[.32877 .38627 -24 -4.5 ]
[.32877 .38627 0 4.5 ]
[.32877 .46353 -18 -4.5 ]
[.32877 .46353 0 4.5 ]
[.32877 .54078 -24 -4.5 ]
[.32877 .54078 0 4.5 ]
[.32877 .61803 -6 -4.5 ]
[.32877 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-0.5)] .18254 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.5)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1.5)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.34127 0 m
.34752 0 L
s
[(-1)] .32877 0 1 0 Mshowa
.34127 .07725 m
.34752 .07725 L
s
[(-0.75)] .32877 .07725 1 0 Mshowa
.34127 .15451 m
.34752 .15451 L
s
[(-0.5)] .32877 .15451 1 0 Mshowa
.34127 .23176 m
.34752 .23176 L
s
[(-0.25)] .32877 .23176 1 0 Mshowa
.34127 .38627 m
.34752 .38627 L
s
[(0.25)] .32877 .38627 1 0 Mshowa
.34127 .46353 m
.34752 .46353 L
s
[(0.5)] .32877 .46353 1 0 Mshowa
.34127 .54078 m
.34752 .54078 L
s
[(0.75)] .32877 .54078 1 0 Mshowa
.34127 .61803 m
.34752 .61803 L
s
[(1)] .32877 .61803 1 0 Mshowa
.125 Mabswid
.34127 .01545 m
.34502 .01545 L
s
.34127 .0309 m
.34502 .0309 L
s
.34127 .04635 m
.34502 .04635 L
s
.34127 .0618 m
.34502 .0618 L
s
.34127 .09271 m
.34502 .09271 L
s
.34127 .10816 m
.34502 .10816 L
s
.34127 .12361 m
.34502 .12361 L
s
.34127 .13906 m
.34502 .13906 L
s
.34127 .16996 m
.34502 .16996 L
s
.34127 .18541 m
.34502 .18541 L
s
.34127 .20086 m
.34502 .20086 L
s
.34127 .21631 m
.34502 .21631 L
s
.34127 .24721 m
.34502 .24721 L
s
.34127 .26266 m
.34502 .26266 L
s
.34127 .27812 m
.34502 .27812 L
s
.34127 .29357 m
.34502 .29357 L
s
.34127 .32447 m
.34502 .32447 L
s
.34127 .33992 m
.34502 .33992 L
s
.34127 .35537 m
.34502 .35537 L
s
.34127 .37082 m
.34502 .37082 L
s
.34127 .40172 m
.34502 .40172 L
s
.34127 .41717 m
.34502 .41717 L
s
.34127 .43262 m
.34502 .43262 L
s
.34127 .44807 m
.34502 .44807 L
s
.34127 .47898 m
.34502 .47898 L
s
.34127 .49443 m
.34502 .49443 L
s
.34127 .50988 m
.34502 .50988 L
s
.34127 .52533 m
.34502 .52533 L
s
.34127 .55623 m
.34502 .55623 L
s
.34127 .57168 m
.34502 .57168 L
s
.34127 .58713 m
.34502 .58713 L
s
.34127 .60258 m
.34502 .60258 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001Ooooo1@000;coool0067oool00`000?ooooooo`2loooo001Qoooo00<0003ooooo
ool00oooo`80002goooo001Ioooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0]_oo
o`00HOooo`030000oooooooo00?oool00`000?ooooooo`2foooo001Poooo0P0000Goool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0003ooooo
ool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo
0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002g
oooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?oo
ooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001>oooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`80002goooo0017oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2foooo001>oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Ioooo`80002goooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001W
oooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0]_ooo`00Doooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo0;Koool005?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0P00
0;Ooool004goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0]_oo
o`00Doooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2foooo001D
oooo0P0000[oool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`00Iooo
o`80002goooo001Woooo00<0003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool0
0`000?ooooooo`2foooo001Woooo0P000;Ooool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`00Ioooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool004koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
0;Koool004goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0]_ooo`00COooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0P000;Ooool004Ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo0;Koool004goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0]_ooo`00C_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo0;Koool006Ooool20000]oooo`00Ioooo`030000
oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0003oooooool0]_ooo`005ooo
o`D0000Noooo0P0000Coool200001?ooo`80000Ooooo0P0001ooool200001?ooo`800004oooo0P00
01ooool500007Oooo`D00002oooo0P0000Coool200008?ooo`@0000Foooo000Ioooo00<0003ooooo
ool07Oooo`040000oooooooo00002?ooo`040000oooooooo00007_ooo`030000oooooooo01goool0
10000?ooooooo`0000Soool010000?ooooooo`00023oool00`000?ooooooo`0Ooooo00<0003ooooo
ool01oooo`040000oooooooo00007oooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0M
oooo00@0003oooooool0000;oooo00<0003oooooool07?ooo`030000oooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`0Noooo00<0003oooooool07oooo`030000oooooooo00[oool0
0`000?ooooooo`0Noooo00<0003oooooool05_ooo`004Oooo`@00004oooo00<0003oooooool05ooo
o`@00002oooo00@0003oooooool00009oooo0P0001ooool00`000?ooooooo`0Moooo00@0003ooooo
ool00009oooo0P00027oool00`000?ooooooo`0Ooooo00<0003oooooool02?ooo`80000Roooo00<0
003oooooool05Oooo`006Oooo`030000oooooooo01goool010000?ooooooo`0000Woool00`000?oo
ooooo`0Noooo0P0001koool010000?ooooooo`0000Woool00`000?ooooooo`0Poooo00<0003ooooo
ool07oooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00@0003oooooool0000Foooo000H
oooo0P00023oool200002_ooo`<0000Noooo00<0003oooooool07_ooo`80000:oooo0`0001ooool2
00008?ooo`80000:oooo0`00023oool200005oooo`00Ioooo`030000oooooooo0;Koool006Ooool2
0000]oooo`00Ioooo`030000oooooooo0;Koool006Ooool00`000?ooooooo`2foooo001Woooo00<0
003oooooool0]_ooo`004?ooool0000Aoooo000Foooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000<ol0<ol000Dco`000`0003?o03?o0005<ol000<0000co`0co`001C?o
00030000<ol006Ko00D0I_l00`00001Vo`1Vo`0506Ko00<00000I_l0I_l01@1Vo`03000006Ko06Ko
00D0I_l00`00001Vo`1Vo`0506Ko00<00000I_l0I_l01@1Vo`030000<ol0<ol000Dco`000`0003?o
03?o0005<ol000<0000co`0co`001C?o00030000<ol0<ol000Dco`000`0003?o03?o0003<ol0;000
00Ooool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool09Oooo`030000oooooooo02Koool0
0`0003?o03?o0003<ol0501Vo`hco`000`0003?o03?o000M<ol000?o09Tco`0co`001C?o00030000
<ol0<ol0014co`0:00002_ooo`030000oooooooo02Koool00`000?ooooooo`0Eoooo001Uoooo0P1V
o`03000006Ko06Ko00<0I_m2<ol000?o09Tco`0co`003c?o00X0001Eoooo001Koooo2P1Vo`;oool2
0000AS?o0003o`2I<ol0<ol000Tco`060000Goooo`00E_ooo`D0I_l<oooo00<0000co`0co`00AC?o
0003o`2I<ol0<ol000Dco`040000IOooo`00DOooo`D0I_lAoooo00<0000co`0co`00AC?o0003o`2I
<ol0<ol000<co`020000JOooo`00C?ooo`D0I_lFoooo00<0000co`0co`00AC?o0003o`2I<ol0<ol0
00<0001[oooo0018oooo101Voa_oool20000AS?o0003o`2I0000000006koool004Goool306Ko7ooo
o`030000<ol0<ol004@co`000`000?l0VOooo`1_oooo0011oooo101Vob;oool00`0003?o03?o0012
<ol00P000003ooooo`2Ioooo06ooool003koool306Ko9_ooo`030000<ol0<ol0040co`0200000ooo
o`03o`2Ioooooooo06koool003_oool306Ko:Oooo`800010<ol000<0003oooooool00oooo`03o`2I
oooooooo06koool003Ooool406Ko;?ooo`030000<ol0<ol003hco`000`000?ooooooo`04oooo00?o
09Woooooool0K_ooo`005_ooo`0306Kooooooooo01_oool306Ko<?ooo`030000<ol0<ol003`co`02
00001oooo`03o`2Ioooooooo06koool001Ooool00`1Vooooooooo`0Hoooo0P1Voc?oool00`0003?o
03?o000k<ol000<0003oooooool01oooo`03o`2Ioooooooo06koool001Ooool00`1Vooooooooo`0E
oooo0`1VocGoool20000>c?o00030000oooooooo00Soool00ol0VOooooooo`1^oooo000Hoooo00<0
I_ooooooool04_ooo`80I_lhoooo00<0000co`0co`00>C?o00030000oooooooo00Woool00ol0VOoo
ooooo`1^oooo000Ioooo00<0I_ooooooool03oooo`80I_lQoooo0P0000Coool200000oooo`@00003
oooo0P0000Goool00`0003?o03?o000g<ol00P0000coool00ol0VOooooooo`1^oooo000Joooo00<0
I_ooooooool03?ooo`80I_lRoooo00@0003oooooool00008oooo00<0003oooooool00oooo`040000
oooooooo00001?ooo`030000<ol0<ol003Hco`000`000?ooooooo`0<oooo00?o09Woooooool0K_oo
o`006_ooo`0306Kooooooooo00[oool206Ko9?ooo`040000oooooooo00002Oooo`030000oooooooo
00Goool00`000?ooooooo`02oooo0P0003Hco`000`000?ooooooo`0=oooo00?o09Woooooool0K_oo
o`006oooo`0306Kooooooooo00Ooool206Ko9_ooo`040000oooooooo00002_ooo`030000oooooooo
00;oool200001Oooo`030000<ol0<ol003@co`000`000?ooooooo`0>oooo00?o09Woooooool0K_oo
o`006oooo`0306Kooooooooo00Goool206Ko:?ooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo00Coool00`0003?o03?o000d<ol000<0003oooooool03_ooo`03o`2I
oooooooo06koool001coool00`1Vooooooooo`02oooo0P1Vob_oool200002_ooo`800004oooo0`00
00Coool00`0003?o03?o000c<ol000<0003oooooool03oooo`03o`2Ioooooooo06koool001goool0
101Vooooooooo`1VodKoool20000<c?o00030000oooooooo013oool00ol0VOooooooo`1^oooo000N
oooo0P1VodOoool00`0003?o03?o000a<ol000<0003oooooool04Oooo`03o`2Ioooooooo06koool0
01koool00`1Vooooooooo`16oooo00<0000co`0co`00<C?o00030000oooooooo017oool00ol0VOoo
ooooo`1^oooo001Woooo00<0000co`0co`00<3?o00030000oooooooo01;oool00ol0VOooooooo`1^
oooo001Woooo0P00030co`000`000?ooooooo`0Coooo00?o09Woooooool0K_ooo`00Ioooo`030000
<ol0<ol002lco`000`000?ooooooo`0Coooo00?o09Woooooool0K_ooo`00Ioooo`030000<ol0<ol0
02hco`000`000?ooooooo`0Doooo00?o09Woooooool0K_ooo`00Ioooo`030000<ol0<ol002hco`00
0`000?ooooooo`0Doooo00?o09Woooooool0K_ooo`00Ioooo`80000^<ol000<0003oooooool05Ooo
o`03o`2Ioooooooo06koool006Ooool00`0003?o03?o000]<ol000<0003oooooool05Oooo`03o`2I
oooooooo06koool006Ooool00`0003?o03?o000/<ol000<0003oooooool05_ooo`03o`2Ioooooooo
06koool006Ooool00`0003?o03?o000/<ol000<0003oooooool05_ooo`03o`2Ioooooooo06koool0
06Ooool20000;3?o00030000oooooooo01Ooool00ol0VOooooooo`1^oooo001Woooo00<0000co`0c
o`00:c?o00030000oooooooo01Ooool00ol0VOooooooo`1^oooo001Doooo0P0000Coool200001?oo
o`800005oooo00<0000co`0co`00:S?o000