(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2822017,     109176]*)
(*NotebookOutlinePosition[   2822761,     109201]*)
(*  CellTagsIndexPosition[   2822717,     109197]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING IN FRONT OF A NEGATIVE DELTA-FUNCTION \
NONHOMOGENEITY", "Text",
  CellFrame->True,
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  v[x]  ",
    FontSize->12],
  StyleBox["is a delta-function of strength  c0, positive or negative, \
located at  x=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  The potential has one bound state if  c0<0  and no bound states \
if  c0>0.\n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" <0, is in front of  the nonhomogeneity and needs to be \
specified. ",
    FontSize->12],
  StyleBox["\n\nThe transmission coefficient, left reflection coefficient, \
and right reflection coefficient, respectively, are denoted by  T[k],  L[k],  \
R[k].\n\nThe tail of the wave is denoted by  g[x,t].\n\nThe focusing moment \
is chosen as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(Clear[v, T, L, R, c0, x0, g];\)\), "\[IndentingNewLine]", 
    \(\(v[x_] = \ c0\ \ DiracDelta[x]\ ;\)\), "\n", 
    \(\(T[k_] = k/\((k + I\ \ c0/2)\);\)\), "\n", 
    \(\(L[k_] = \((\(-I\)\ c0/2)\)/\((k + I\ \ c0/2)\);\)\), "\n", 
    \(\(R[k_] = \((\(-I\)\ c0/2)\)/\((k + I\ \ c0/2)\);\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the strength of the potential, c0, a negative number;
also specify the focusing location  x0, a negative number, next:\
\>", "Text",\

  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(c0 = \(-1\)\)\(;\)\(\ \ \)\(\(x0 = \(-1\)\) \)\(;\)\(\ \)\)\)], \
"Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(\n\)\(g[x_, 
          t_] = \ \(-\ \((c0/
                2)\)\)\ \((UnitStep[
                  x]\ \ UnitStep[\(-x\) + x0 + 
                    t]\ E^\((c0 \((x - x0 - t)\)/2)\) + 
              UnitStep[\(-x\)]\ UnitStep[
                  x + x0 + 
                    t]\ \ E^\((\(-c0\) \((x + x0 + t)\)/
                        2)\))\);\)\)\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-3\), \ 
              3}, \ PlotRange -> {\(-0.2\), 2.5}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-3\), \ 3}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-0.2\), 
                2.5}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-3\), \ 3}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-0.2\), 
                2.5}]}, \[IndentingNewLine]\ {t, \ \(-1.9\), \ 3.9, 0.05}, 
        PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.02846 .04578 L
.03279 .04578 L
.03523 .04578 L
.03754 .04578 L
.03881 .04578 L
.03953 .04578 L
s
.03953 .04578 m
.0397 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool01@000?ooooooooooool0V@03oooo00<0003oooooool01_ooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo000Goooo00?o09Woooooool0MOooo`030000oooooooo
08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo
07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool0
01Ooool00ol0VOooooooo`1eoooo0P0008ooool001Ooool00ol0VOooooooo`1eoooo00<0003ooooo
ool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Wooooo
ool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_oo
o`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOoo
o`80002?oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOoo
ooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>
oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1e
oooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool20000Soooo`005oooo`03o`2I
oooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo
08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo
07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool0
01Ooool00ol0VOooooooo`1eoooo0P0008ooool001Ooool00ol0VOooooooo`1eoooo00<0003ooooo
ool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Wooooo
ool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1Roooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo067oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0HOoo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`005oooo`03o`2Ioooooooo
067oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool001Ooool00ol0VOoo
ooooo`1Qoooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
01Ooool00ol0VOooooooo`1Roooo0P0000[oool300001?ooo`030000oooooooo08koool001Ooool0
0ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?oo
ooooo`2>oooo000Goooo00?o09Woooooool0MOooo`80002?oooo000Goooo00?o09Woooooool0MOoo
o`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005ooo
o`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000
oooooooo08koool001Ooool00ol0VOooooooo`1eoooo0P0008ooool001Ooool00ol0VOooooooo`1e
oooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000G
oooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0
003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o
09Woooooool0MOooo`80002?oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool0
01Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool0
0`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool0
0ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool20000Sooo
o`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOoo
o`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005ooo
o`03o`2Ioooooooo06goool500000oooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1_
oooo00<0003oooooool00oooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1_oooo00<0
003oooooool00oooo`<0002>oooo000Goooo00?o09Woooooool0Koooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo000Goooo00?o09Woooooool0Koooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000Goooo00?o09Woooooool0K_ooo`800005oooo00<0003oooooool0S_ooo`005ooo
o`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000
oooooooo08koool001Ooool00ol0VOooooooo`1eoooo0P0008ooool001Ooool00ol0VOooooooo`1e
oooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000G
oooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0
003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o
09Woooooool0MOooo`80002?oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool0
01Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool0
0`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool0
0ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool20000Sooo
o`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOoo
o`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005ooo
o`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000
oooooooo08koool001Ooool00ol0VOooooooo`1eoooo0P0008ooool001Ooool00ol0VOooooooo`1e
oooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000G
oooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1Qoooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo06?oool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`005oooo`03o`2I
oooooooo06?oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000Goooo00?o
09Woooooool0Hoooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool001Ooool0
0ol0VOooooooo`1Soooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo000Goooo00?o09Woooooool0H_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000G
oooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0
003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool20000Soooo`005oooo`03o`2Ioooooooo
07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool0
01Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool0
0`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool0
0ol0VOooooooo`1eoooo0P0008ooool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_oo
o`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOoo
o`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005ooo
o`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`80002?
oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1e
oooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000G
oooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0
003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool20000Soooo`005oooo`03o`2Ioooooooo
07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool0
01Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo06goool4
00001?ooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1]oooo00<0003oooooool01Ooo
o`030000oooooooo08koool001Ooool00ol0VOooooooo`1^oooo00<0003oooooool01?ooo`<0002>
oooo000Goooo00?o09Woooooool0Koooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000G
oooo00?o09Woooooool0KOooo`040000oooooooo00001?ooo`030000oooooooo08koool001Ooool0
0ol0VOooooooo`1^oooo0P0000Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOoo
o`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005ooo
o`03o`2Ioooooooo07Goool20000Soooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>
oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1e
oooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000G
oooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo0P00
08ooool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo
07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool0
01Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo07Goool0
0`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOooo`80002?oooo000Goooo00?o09Wooooo
ool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_oo
o`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0MOoo
o`030000oooooooo08koool001Ooool00ol0VOooooooo`1eoooo00<0003oooooool0S_ooo`005ooo
o`03o`2Ioooooooo07Goool20000Soooo`005oooo`03o`2Ioooooooo07Goool00`000?ooooooo`2>
oooo000Goooo00?o09Woooooool0MOooo`030000oooooooo08koool001Ooool00ol0VOooooooo`1e
oooo00<0003oooooool0S_ooo`005oooo`03o`2Ioooooooo067oool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0HOooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Goooo00?o09Woooooool0H_ooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000ooo
o`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02Oooo`030000oooooooo
00;oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool0
0`000?ooooooo`08oooo0`0000Coool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@00
01Coool00`000?ooooooo`07oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000001Ooool00`000?ooooooo`07oooo00@0003oooooool00003oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`<00002oooo00<0003ooooo
ool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {290.125, 148.813}} -> {-0.349561, \
1.05307, 0.00349883, 0.00566123}, {{79.875, 308.563}, {290.125, 148.813}} -> \
{-5.8905, 2.92371, 0.0242634, 0.0168253}, {{79.875, 308.563}, {290.125, \
148.813}} -> {-5.8905, 2.92371, 0.0242634, 0.0168253}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.03279 .04578 L
.04262 .04578 L
.04517 .04578 L
.04642 .04578 L
.04758 .04578 L
s
.04758 .04578 m
.04774 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`03oooo00?o09Woool000002?ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool0
01Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool0
0`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool0
0ol0VOooooooo`1coooo0P0008ooool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_oo
o`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Looo
o`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Ooo
o`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`80002?
oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1c
oooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000I
oooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0
003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool20000Soooo`006Oooo`03o`2Ioooooooo
07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool0
01Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool0
0`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool0
0ol0VOooooooo`1coooo0P0008ooool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_oo
o`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Looo
o`030000oooooooo08koool001Woool00ol0VOooooooo`1Poooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo05ooool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Goooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`006Oooo`03o`2Ioooooooo05ooool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool001Woool00ol0VOooooooo`1O
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool001Woool0
0ol0VOooooooo`1Poooo0P0000[oool300001?ooo`030000oooooooo08koool001Woool00ol0VOoo
ooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>
oooo000Ioooo00?o09Woooooool0Loooo`80002?oooo000Ioooo00?o09Woooooool0Loooo`030000
oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2I
oooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo
08koool001Woool00ol0VOooooooo`1coooo0P0008ooool001Woool00ol0VOooooooo`1coooo00<0
003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o
09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003ooooo
ool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Wooooo
ool0Loooo`80002?oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool0
0ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?oo
ooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOoo
ooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool20000Soooo`006Ooo
o`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000
oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2I
oooooooo06_oool500000oooo`030000oooooooo08koool001Woool00ol0VOooooooo`1]oooo00<0
003oooooool00oooo`030000oooooooo08koool001Woool00ol0VOooooooo`1]oooo00<0003ooooo
ool00oooo`<0002>oooo000Ioooo00?o09Woooooool0KOooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000Ioooo00?o09Woooooool0KOooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000Ioooo00?o09Woooooool0K?ooo`800005oooo00<0003oooooool0S_ooo`006Oooo`03o`2I
oooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo
08koool001Woool00ol0VOooooooo`1coooo0P0008ooool001Woool00ol0VOooooooo`1coooo00<0
003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o
09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003ooooo
ool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Wooooo
ool0Loooo`80002?oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool0
0ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?oo
ooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOoo
ooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool20000Soooo`006Ooo
o`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000
oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2I
oooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo
08koool001Woool00ol0VOooooooo`1coooo0P0008ooool001Woool00ol0VOooooooo`1coooo00<0
003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o
09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1Ooooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo067oool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo
067oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000Ioooo00?o09Wooooo
ool0HOooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool001Woool00ol0VOoo
ooooo`1Qoooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000I
oooo00?o09Woooooool0H?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Ioooo00?o
09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003ooooo
ool0S_ooo`006Oooo`03o`2Ioooooooo07?oool20000Soooo`006Oooo`03o`2Ioooooooo07?oool0
0`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool0
0ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?oo
ooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOoo
ooooo`1coooo0P0008ooool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Ooo
o`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000
oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2I
oooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`80002?oooo000I
oooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0
003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o
09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003ooooo
ool0S_ooo`006Oooo`03o`2Ioooooooo07?oool20000Soooo`006Oooo`03o`2Ioooooooo07?oool0
0`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool0
0ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo06_oool400001?oo
o`030000oooooooo08koool001Woool00ol0VOooooooo`1[oooo00<0003oooooool01Oooo`030000
oooooooo08koool001Woool00ol0VOooooooo`1/oooo00<0003oooooool01?ooo`<0002>oooo000I
oooo00?o09Woooooool0KOooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000Ioooo00?o
09Woooooool0Joooo`040000oooooooo00001?ooo`030000oooooooo08koool001Woool00ol0VOoo
ooooo`1/oooo0P0000Goool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000
oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2I
oooooooo07?oool20000Soooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000I
oooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0
003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o
09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo0P0008ooool0
01Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool0
0`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool0
0ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2Ioooooooo07?oool00`000?oo
ooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`80002?oooo000Ioooo00?o09Woooooool0Looo
o`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Ooo
o`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Loooo`030000
oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0003oooooool0S_ooo`006Oooo`03o`2I
oooooooo07?oool20000Soooo`006Oooo`03o`2Ioooooooo07?oool00`000?ooooooo`2>oooo000I
oooo00?o09Woooooool0Loooo`030000oooooooo08koool001Woool00ol0VOooooooo`1coooo00<0
003oooooool0S_ooo`006Oooo`03o`2Ioooooooo05ooool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0Goooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000Ioooo00?o09Woooooool0H?ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`800004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`040000oooooooo00001Oooo`030000
oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001Coool00`000?oo
ooooo`08oooo0P0000Coool200001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`00000Goooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo00?oool0
0`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0P0000Coool300000_oo
o`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.03279 .04578 L
.04262 .04578 L
.04758 .04578 L
.0503 .04578 L
.05288 .04578 L
.05405 .04578 L
.05528 .04578 L
s
.05528 .04578 m
.05544 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool0
01_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool0
0`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool0
0ol0VOooooooo`1aoooo0P0008ooool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_oo
o`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOoo
o`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006ooo
o`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`80002?
oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1a
oooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000K
oooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0
003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool20000Soooo`006oooo`03o`2Ioooooooo
077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool0
01_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool0
0`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool0
0ol0VOooooooo`1aoooo0P0008ooool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_oo
o`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOoo
o`030000oooooooo08koool001_oool00ol0VOooooooo`1Noooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo05goool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0GOooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`006oooo`03o`2Ioooooooo05goool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool001_oool00ol0VOooooooo`1M
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool001_oool0
0ol0VOooooooo`1Noooo0P0000[oool300001?ooo`030000oooooooo08koool001_oool00ol0VOoo
ooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>
oooo000Koooo00?o09Woooooool0LOooo`80002?oooo000Koooo00?o09Woooooool0LOooo`030000
oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2I
oooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo
08koool001_oool00ol0VOooooooo`1aoooo0P0008ooool001_oool00ol0VOooooooo`1aoooo00<0
003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o
09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003ooooo
ool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Wooooo
ool0LOooo`80002?oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool0
0ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?oo
ooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOoo
ooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool20000Soooo`006ooo
o`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000
oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2I
oooooooo06Woool500000oooo`030000oooooooo08koool001_oool00ol0VOooooooo`1[oooo00<0
003oooooool00oooo`030000oooooooo08koool001_oool00ol0VOooooooo`1[oooo00<0003ooooo
ool00oooo`<0002>oooo000Koooo00?o09Woooooool0Joooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000Koooo00?o09Woooooool0Joooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000Koooo00?o09Woooooool0J_ooo`800005oooo00<0003oooooool0S_ooo`006oooo`03o`2I
oooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo
08koool001_oool00ol0VOooooooo`1aoooo0P0008ooool001_oool00ol0VOooooooo`1aoooo00<0
003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o
09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003ooooo
ool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Wooooo
ool0LOooo`80002?oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool0
0ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?oo
ooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOoo
ooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool20000Soooo`006ooo
o`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000
oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2I
oooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo
08koool001_oool00ol0VOooooooo`1aoooo0P0008ooool001_oool00ol0VOooooooo`1aoooo00<0
003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o
09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1Moooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo05ooool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo
05ooool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000Koooo00?o09Wooooo
ool0Goooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool001_oool00ol0VOoo
ooooo`1Ooooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000K
oooo00?o09Woooooool0G_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Koooo00?o
09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003ooooo
ool0S_ooo`006oooo`03o`2Ioooooooo077oool20000Soooo`006oooo`03o`2Ioooooooo077oool0
0`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool0
0ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?oo
ooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOoo
ooooo`1aoooo0P0008ooool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006ooo
o`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000
oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2I
oooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`80002?oooo000K
oooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0
003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o
09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003ooooo
ool0S_ooo`006oooo`03o`2Ioooooooo077oool20000Soooo`006oooo`03o`2Ioooooooo077oool0
0`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool0
0ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo06Woool400001?oo
o`030000oooooooo08koool001_oool00ol0VOooooooo`1Yoooo00<0003oooooool01Oooo`030000
oooooooo08koool001_oool00ol0VOooooooo`1Zoooo00<0003oooooool01?ooo`<0002>oooo000K
oooo00?o09Woooooool0Joooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000Koooo00?o
09Woooooool0JOooo`040000oooooooo00001?ooo`030000oooooooo08koool001_oool00ol0VOoo
ooooo`1Zoooo0P0000Goool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000
oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2I
oooooooo077oool20000Soooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000K
oooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0
003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o
09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo0P0008ooool0
01_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool0
0`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool0
0ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2Ioooooooo077oool00`000?oo
ooooo`2>oooo000Koooo00?o09Woooooool0LOooo`80002?oooo000Koooo00?o09Woooooool0LOoo
o`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006ooo
o`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0LOooo`030000
oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0003oooooool0S_ooo`006oooo`03o`2I
oooooooo077oool20000Soooo`006oooo`03o`2Ioooooooo077oool00`000?ooooooo`2>oooo000K
oooo00?o09Woooooool0LOooo`030000oooooooo08koool001_oool00ol0VOooooooo`1aoooo00<0
003oooooool0S_ooo`006oooo`03o`2Ioooooooo05goool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000Koooo00?o09Woooooool0GOooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000Koooo00?o09Woooooool0G_ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`800004
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000
oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0003ooooo
ool01@0001Coool00`000?ooooooo`08oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1i
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.04262 .04578 L
.0522 .04578 L
.05746 .04578 L
.06005 .04578 L
.06119 .04578 L
.06244 .04578 L
s
.06244 .04578 m
.06276 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003ooooo09T01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool0
01goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool0
0`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool0
0ol0VOooooooo`1_oooo0P0008ooool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_oo
o`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Kooo
o`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Ooo
o`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`80002?
oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_
oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000M
oooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0
003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool20000Soooo`007Oooo`03o`2Ioooooooo
06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool0
01goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool0
0`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool0
0ol0VOooooooo`1_oooo0P0008ooool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_oo
o`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Kooo
o`030000oooooooo08koool001goool00ol0VOooooooo`1Loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo05_oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Foooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`007Oooo`03o`2Ioooooooo05_oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool001goool00ol0VOooooooo`1K
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool001goool0
0ol0VOooooooo`1Loooo0P0000[oool300001?ooo`030000oooooooo08koool001goool00ol0VOoo
ooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>
oooo000Moooo00?o09Woooooool0Koooo`80002?oooo000Moooo00?o09Woooooool0Koooo`030000
oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2I
oooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo
08koool001goool00ol0VOooooooo`1_oooo0P0008ooool001goool00ol0VOooooooo`1_oooo00<0
003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o
09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003ooooo
ool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Wooooo
ool0Koooo`80002?oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool0
0ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?oo
ooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOoo
ooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool20000Soooo`007Ooo
o`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000
oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2I
oooooooo06Ooool500000oooo`030000oooooooo08koool001goool00ol0VOooooooo`1Yoooo00<0
003oooooool00oooo`030000oooooooo08koool001goool00ol0VOooooooo`1Yoooo00<0003ooooo
ool00oooo`<0002>oooo000Moooo00?o09Woooooool0JOooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000Moooo00?o09Woooooool0JOooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000Moooo00?o09Woooooool0J?ooo`800005oooo00<0003oooooool0S_ooo`007Oooo`03o`2I
oooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo
08koool001goool00ol0VOooooooo`1_oooo0P0008ooool001goool00ol0VOooooooo`1_oooo00<0
003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o
09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003ooooo
ool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Wooooo
ool0Koooo`80002?oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool0
0ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?oo
ooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOoo
ooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool20000Soooo`007Ooo
o`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000
oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2I
oooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo
08koool001goool00ol0VOooooooo`1_oooo0P0008ooool001goool00ol0VOooooooo`1_oooo00<0
003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o
09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1Koooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo05goool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo
05goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000Moooo00?o09Wooooo
ool0GOooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool001goool00ol0VOoo
ooooo`1Moooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000M
oooo00?o09Woooooool0G?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Moooo00?o
09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003ooooo
ool0S_ooo`007Oooo`03o`2Ioooooooo06ooool20000Soooo`007Oooo`03o`2Ioooooooo06ooool0
0`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool0
0ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?oo
ooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOoo
ooooo`1_oooo0P0008ooool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Ooo
o`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000
oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2I
oooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`80002?oooo000M
oooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0
003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o
09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003ooooo
ool0S_ooo`007Oooo`03o`2Ioooooooo06ooool20000Soooo`007Oooo`03o`2Ioooooooo06ooool0
0`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool0
0ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06Ooool400001?oo
o`030000oooooooo08koool001goool00ol0VOooooooo`1Woooo00<0003oooooool01Oooo`030000
oooooooo08koool001goool00ol0VOooooooo`1Xoooo00<0003oooooool01?ooo`<0002>oooo000M
oooo00?o09Woooooool0JOooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000Moooo00?o
09Woooooool0Ioooo`040000oooooooo00001?ooo`030000oooooooo08koool001goool00ol0VOoo
ooooo`1Xoooo0P0000Goool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000
oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2I
oooooooo06ooool20000Soooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000M
oooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0
003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o
09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo0P0008ooool0
01goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool0
0`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool0
0ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2Ioooooooo06ooool00`000?oo
ooooo`2>oooo000Moooo00?o09Woooooool0Koooo`80002?oooo000Moooo00?o09Woooooool0Kooo
o`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Ooo
o`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Koooo`030000
oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0003oooooool0S_ooo`007Oooo`03o`2I
oooooooo06ooool20000Soooo`007Oooo`03o`2Ioooooooo06ooool00`000?ooooooo`2>oooo000M
oooo00?o09Woooooool0Koooo`030000oooooooo08koool001goool00ol0VOooooooo`1_oooo00<0
003oooooool0S_ooo`007Oooo`03o`2Ioooooooo05_oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000Moooo00?o09Woooooool0Foooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000Moooo00?o09Woooooool0G?ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001Oooo`030000
oooooooo00;oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo00Woool0
1@000?ooooooooooo`000002oooo00D0003oooooooooool00000Moooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Eoooo00<0003oooooool02Oooo`030000oooooooo00Coool00`000?oo
ooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Doooo00<0003ooooo
ool02_ooo`040000oooooooooooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`03
oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002Oooo`@00003oooo0`00
00;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.04262 .04578 L
.0522 .04578 L
.06244 .04578 L
.06525 .04578 L
.0679 .04578 L
.06905 .04578 L
.07027 .04578 L
.07091 .04578 L
s
.07091 .04578 m
.07109 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00D0003ooooooooooooo09T01?ooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo
08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo
06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool0
01ooool00ol0VOooooooo`1]oooo0P0008ooool001ooool00ol0VOooooooo`1]oooo00<0003ooooo
ool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Wooooo
ool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_oo
o`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOoo
o`80002?oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOoo
ooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>
oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]
oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool20000Soooo`007oooo`03o`2I
oooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo
08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo
06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool0
01ooool00ol0VOooooooo`1]oooo0P0008ooool001ooool00ol0VOooooooo`1]oooo00<0003ooooo
ool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Wooooo
ool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1Joooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo05Woool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0FOoo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`007oooo`03o`2Ioooooooo
05Woool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool001ooool00ol0VOoo
ooooo`1Ioooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
01ooool00ol0VOooooooo`1Joooo0P0000[oool300001?ooo`030000oooooooo08koool001ooool0
0ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?oo
ooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`80002?oooo000Ooooo00?o09Woooooool0KOoo
o`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007ooo
o`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000
oooooooo08koool001ooool00ol0VOooooooo`1]oooo0P0008ooool001ooool00ol0VOooooooo`1]
oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000O
oooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0
003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o
09Woooooool0KOooo`80002?oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool0
01ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool0
0`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool0
0ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool20000Sooo
o`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOoo
o`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007ooo
o`03o`2Ioooooooo06Goool500000oooo`030000oooooooo08koool001ooool00ol0VOooooooo`1W
oooo00<0003oooooool00oooo`030000oooooooo08koool001ooool00ol0VOooooooo`1Woooo00<0
003oooooool00oooo`<0002>oooo000Ooooo00?o09Woooooool0Ioooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0Ioooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000Ooooo00?o09Woooooool0I_ooo`800005oooo00<0003oooooool0S_ooo`007ooo
o`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000
oooooooo08koool001ooool00ol0VOooooooo`1]oooo0P0008ooool001ooool00ol0VOooooooo`1]
oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000O
oooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0
003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o
09Woooooool0KOooo`80002?oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool0
01ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool0
0`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool0
0ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool20000Sooo
o`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOoo
o`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007ooo
o`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000
oooooooo08koool001ooool00ol0VOooooooo`1]oooo0P0008ooool001ooool00ol0VOooooooo`1]
oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000O
oooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1Ioooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo05_oool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`007oooo`03o`2I
oooooooo05_oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000Ooooo00?o
09Woooooool0Foooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool001ooool0
0ol0VOooooooo`1Koooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo000Ooooo00?o09Woooooool0F_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000O
oooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0
003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool20000Soooo`007oooo`03o`2Ioooooooo
06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool0
01ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool0
0`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool0
0ol0VOooooooo`1]oooo0P0008ooool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_oo
o`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOoo
o`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007ooo
o`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`80002?
oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]
oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000O
oooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0
003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool20000Soooo`007oooo`03o`2Ioooooooo
06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool0
01ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06Goool4
00001?ooo`030000oooooooo08koool001ooool00ol0VOooooooo`1Uoooo00<0003oooooool01Ooo
o`030000oooooooo08koool001ooool00ol0VOooooooo`1Voooo00<0003oooooool01?ooo`<0002>
oooo000Ooooo00?o09Woooooool0Ioooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000O
oooo00?o09Woooooool0IOooo`040000oooooooo00001?ooo`030000oooooooo08koool001ooool0
0ol0VOooooooo`1Voooo0P0000Goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOoo
o`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007ooo
o`03o`2Ioooooooo06goool20000Soooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>
oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]
oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000O
oooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo0P00
08ooool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo
06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool0
01ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo06goool0
0`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOooo`80002?oooo000Ooooo00?o09Wooooo
ool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_oo
o`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0KOoo
o`030000oooooooo08koool001ooool00ol0VOooooooo`1]oooo00<0003oooooool0S_ooo`007ooo
o`03o`2Ioooooooo06goool20000Soooo`007oooo`03o`2Ioooooooo06goool00`000?ooooooo`2>
oooo000Ooooo00?o09Woooooool0KOooo`030000oooooooo08koool001ooool00ol0VOooooooo`1]
oooo00<0003oooooool0S_ooo`007oooo`03o`2Ioooooooo05Woool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0FOooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Ooooo00?o09Woooooool0F_ooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001Ooo
o`030000oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`09oooo00<0
003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003ooooo
ool05Oooo`030000oooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0Moooo`00N?oo
o`030000oooooooo00D0000Doooo00<0003oooooool02_ooo`050000oooooooooooo000007[oool0
07Soool01@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000Woool400000_ooo`030000
oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.04262 .04578 L
.06244 .04578 L
.06747 .04578 L
.07286 .04578 L
.07547 .04578 L
.07675 .04578 L
.07793 .04578 L
.07901 .04578 L
s
.07901 .04578 m
.07929 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool00oooo`04o`2Ioooooooo00001oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo01;oool0027oool00ol0VOooooooo`1[oooo00<0003oooooool0S_oo
o`008Oooo`03o`2Ioooooooo06_oool00`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Jooo
o`030000oooooooo08koool0027oool00ol0VOooooooo`1[oooo00<0003oooooool0S_ooo`008Ooo
o`03o`2Ioooooooo06_oool20000Soooo`008Oooo`03o`2Ioooooooo06_oool00`000?ooooooo`2>
oooo000Qoooo00?o09Woooooool0Joooo`030000oooooooo08koool0027oool00ol0VOooooooo`1[
oooo00<0003oooooool0S_ooo`008Oooo`03o`2Ioooooooo06_oool00`000?ooooooo`2>oooo000Q
oooo00?o09Woooooool0Joooo`030000oooooooo08koool0027oool00ol0VOooooooo`1[oooo0P00
08ooool0027oool00ol0VOooooooo`1[oooo00<0003oooooool0S_ooo`008Oooo`03o`2Ioooooooo
06_oool00`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`030000oooooooo08koool0
027oool00ol0VOooooooo`1[oooo00<0003oooooool0S_ooo`008Oooo`03o`2Ioooooooo06_oool0
0`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`80002?oooo000Qoooo00?o09Wooooo
ool0Joooo`030000oooooooo08koool0027oool00ol0VOooooooo`1[oooo00<0003oooooool0S_oo
o`008Oooo`03o`2Ioooooooo06_oool00`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Jooo
o`030000oooooooo08koool0027oool00ol0VOooooooo`1[oooo00<0003oooooool0S_ooo`008Ooo
o`03o`2Ioooooooo06_oool20000Soooo`008Oooo`03o`2Ioooooooo06_oool00`000?ooooooo`2>
oooo000Qoooo00?o09Woooooool0Joooo`030000oooooooo08koool0027oool00ol0VOooooooo`1[
oooo00<0003oooooool0S_ooo`008Oooo`03o`2Ioooooooo05Soool200001?ooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Eoooo`040000oooooooo00002?oo
o`040000oooooooo00001?ooo`030000oooooooo08koool0027oool00ol0VOooooooo`1Goooo00@0
003oooooool0000;oooo00<0003oooooool00_ooo`<0002>oooo000Qoooo00?o09Woooooool0Eooo
o`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_ooo`008Oooo`03o`2Ioooooooo
05Ooool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`008Ooo
o`03o`2Ioooooooo05Soool200002_ooo`<00004oooo00<0003oooooool0S_ooo`008Oooo`03o`2I
oooooooo06_oool00`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`030000oooooooo
08koool0027oool00ol0VOooooooo`1[oooo0P0008ooool0027oool00ol0VOooooooo`1[oooo00<0
003oooooool0S_ooo`008Oooo`03o`2Ioooooooo06_oool00`000?ooooooo`2>oooo000Qoooo00?o
09Woooooool0Joooo`030000oooooooo08koool0027oool00ol0VOooooooo`1[oooo00<0003ooooo
ool0S_ooo`008Oooo`03o`2Ioooooooo06_oool20000Soooo`008Oooo`03o`2Ioooooooo06_oool0
0`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`030000oooooooo08koool0027oool0
0ol0VOooooooo`1[oooo00<0003oooooool0S_ooo`008Oooo`03o`2Ioooooooo06_oool00`000?oo
ooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`030000oooooooo08koool0027oool00ol0VOoo
ooooo`1[oooo0P0008ooool0027oool00ol0VOooooooo`1[oooo00<0003oooooool0S_ooo`008Ooo
o`03o`2Ioooooooo06_oool00`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`030000
oooooooo08koool0027oool00ol0VOooooooo`1[oooo00<0003oooooool0S_ooo`008Oooo`03o`2I
oooooooo06_oool00`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`80002?oooo000Q
oooo00?o09Woooooool0Joooo`030000oooooooo08koool0027oool00ol0VOooooooo`1[oooo00<0
003oooooool0S_ooo`008Oooo`03o`2Ioooooooo06_oool00`000?ooooooo`2>oooo000Qoooo00?o
09Woooooool0Hoooo`D00003oooo00<0003oooooool0S_ooo`008Oooo`03o`2Ioooooooo06Goool0
0`000?ooooooo`03oooo00<0003oooooool0S_ooo`008Oooo`03o`2Ioooooooo06Goool00`000?oo
ooooo`03oooo0`0008koool0027oool00ol0VOooooooo`1Uoooo00<0003oooooool00oooo`030000
oooooooo08koool0027oool00ol0VOooooooo`1Uoooo00<0003oooooool00oooo`030000oooooooo
08koool0027oool00ol0VOooooooo`1Toooo0P0000Goool00`000?ooooooo`2>oooo000Qoooo00?o
09Woooooool0Joooo`030000oooooooo08koool0027oool00ol0VOooooooo`1[oooo00<0003ooooo
ool0S_ooo`008Oooo`03o`2Ioooooooo06_oool20000Soooo`008Oooo`03o`2Ioooooooo06_oool0
0`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`030000oooooooo08koool0027oool0
0ol0VOooooooo`1[oooo00<0003oooooool0S_ooo`008Oooo`03o`2Ioooooooo06_oool00`000?oo
ooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`030000oooooooo08koool0027oool00ol0VOoo
ooooo`1[oooo0P0008ooool0027oool00ol0VOooooooo`1[oooo00<0003oooooool0S_ooo`008Ooo
o`03o`2Ioooooooo06_oool00`000?ooooooo`2>oooo000Qoooo00?o09Woooooool0Joooo`030000
oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2I
oooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`80002?oooo000R
oooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0
003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o
09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003ooooo
ool0S_ooo`008_ooo`03o`2Ioooooooo06[oool20000Soooo`008_ooo`03o`2Ioooooooo06[oool0
0`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool0
0ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo05Koool500000_oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0F?ooo`030000
oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Roooo00?o09Wooooo
ool0F?ooo`030000oooooooo00[oool00`000?ooooooo`02oooo0`0008koool002;oool00ol0VOoo
ooooo`1Hoooo00<0003oooooool02?ooo`800005oooo00<0003oooooool0S_ooo`008_ooo`03o`2I
oooooooo05Soool00`000?ooooooo`08oooo00<0003oooooool01?ooo`030000oooooooo08koool0
02;oool00ol0VOooooooo`1Goooo0P0000[oool300001?ooo`030000oooooooo08koool002;oool0
0ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool00`000?oo
ooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`80002?oooo000Roooo00?o09Woooooool0J_oo
o`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_oo
o`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`030000
oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2I
oooooooo06[oool20000Soooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000R
oooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0
003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o
09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo0P0008ooool0
02;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool0
0`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool0
0ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool00`000?oo
ooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`80002?oooo000Roooo00?o09Woooooool0J_oo
o`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_oo
o`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0H_ooo`@00004
oooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`05oooo00<0
003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06?oool00`000?ooooooo`04oooo0`0008koool0
02;oool00ol0VOooooooo`1Toooo00<0003oooooool00oooo`030000oooooooo08koool002;oool0
0ol0VOooooooo`1Roooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`008_ooo`03o`2I
oooooooo06?oool200001Oooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0
003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o
09Woooooool0J_ooo`80002?oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool0
02;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool0
0`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool0
0ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool20000Sooo
o`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_oo
o`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_oo
o`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`030000
oooooooo08koool002;oool00ol0VOooooooo`1Zoooo0P0008ooool002;oool00ol0VOooooooo`1Z
oooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000R
oooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0
003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o
09Woooooool0J_ooo`80002?oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool0
02;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool0
0`000?ooooooo`2>oooo000Roooo00?o09Woooooool0E_ooo`@00003oooo0P0000Coool200001Ooo
o`030000oooooooo08koool002;oool00ol0VOooooooo`1Foooo00<0003oooooool02Oooo`040000
oooooooo00001?ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Goooo00<0003ooooo
ool02oooo`030000oooooooo00;oool30000S_ooo`00OOooo`030000oooooooo00Soool20000U_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo09Goool007coool200002_ooo`<0002E
oooo003ooooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_oo
o`00MOooo`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOoo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_ooo`800003oooo0`00
00Coool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo00Ooool010000?oo
ooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003ooooo
ool00_ooo`030000oooooooo01Goool00`000?ooooooo`07oooo00@0003oooooool00005oooo00<0
003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000
oooooooo00Ooool300001?ooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooo
oooo000001Ooool00`000?ooooooo`08oooo00<0003oooooool00oooo`030000oooooooo00?oool0
0`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0`0000?oool300000_oo
o`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.04262 .04578 L
.06244 .04578 L
.07216 .04578 L
.0775 .04578 L
.08255 .04578 L
.08542 .04578 L
.0862 .04578 L
.08703 .04578 L
s
.08703 .04578 m
.08721 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool0
02Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool0
0`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool0
0ol0VOooooooo`1Xoooo0P0008ooool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_oo
o`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?oo
o`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?oo
o`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`80002?
oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1X
oooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000T
oooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo
06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool0
02Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool0
0`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool0
0ol0VOooooooo`1Xoooo0P0008ooool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_oo
o`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?oo
o`030000oooooooo08koool002Coool00ol0VOooooooo`1Eoooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo05Coool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0E?ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`009?ooo`03o`2Ioooooooo05Coool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool002Coool00ol0VOooooooo`1D
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool002Coool0
0ol0VOooooooo`1Eoooo0P0000[oool300001?ooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>
oooo000Toooo00?o09Woooooool0J?ooo`80002?oooo000Toooo00?o09Woooooool0J?ooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo
08koool002Coool00ol0VOooooooo`1Xoooo0P0008ooool002Coool00ol0VOooooooo`1Xoooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o
09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003ooooo
ool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Wooooo
ool0J?ooo`80002?oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool0
0ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?oo
ooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?oo
o`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo063oool500000oooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Roooo00<0
003oooooool00oooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Roooo00<0003ooooo
ool00oooo`<0002>oooo000Toooo00?o09Woooooool0H_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000Toooo00?o09Woooooool0H_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000Toooo00?o09Woooooool0HOooo`800005oooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo
08koool002Coool00ol0VOooooooo`1Xoooo0P0008ooool002Coool00ol0VOooooooo`1Xoooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o
09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003ooooo
ool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Wooooo
ool0J?ooo`80002?oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool0
0ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?oo
ooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?oo
o`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo
08koool002Coool00ol0VOooooooo`1Xoooo0P0008ooool002Coool00ol0VOooooooo`1Xoooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o
09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Doooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo05Koool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo
05Koool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000Toooo00?o09Wooooo
ool0E_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1Foooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000T
oooo00?o09Woooooool0EOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Toooo00?o
09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003ooooo
ool0S_ooo`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo06Soool0
0`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool0
0ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?oo
ooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1Xoooo0P0008ooool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?oo
o`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`80002?oooo000T
oooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o
09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003ooooo
ool0S_ooo`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo06Soool0
0`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool0
0ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo063oool400001?oo
o`030000oooooooo08koool002Coool00ol0VOooooooo`1Poooo00<0003oooooool01Oooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Qoooo00<0003oooooool01?ooo`<0002>oooo000T
oooo00?o09Woooooool0H_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000Toooo00?o
09Woooooool0H?ooo`040000oooooooo00001?ooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1Qoooo0P0000Goool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000T
oooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o
09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo0P0008ooool0
02Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool0
0`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool0
0ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?oo
ooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`80002?oooo000Toooo00?o09Woooooool0J?oo
o`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?oo
o`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000T
oooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo05Coool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000Toooo00?o09Woooooool0E?ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0EOooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000oooo`<00004
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000
oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0003ooooo
ool01@0001Coool00`000?ooooooo`07oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000005oooo`030000oooooooo00Soool00`000?ooooooo`03oooo00<0003ooooo
ool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`<00002oooo00<0003oooooool0NOoo
o`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.04262 .04578 L
.06244 .04578 L
.08255 .04578 L
.08806 .04578 L
.09109 .04578 L
.09258 .04578 L
.09324 .04578 L
.09396 .04578 L
s
.09396 .04578 m
.09428 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000o`2Ioooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool0
02Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool0
0ol0VOooooooo`1Woooo0P0008ooool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_oo
o`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Iooo
o`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Ooo
o`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`80002?
oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1W
oooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000U
oooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0
003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool20000Soooo`009Oooo`03o`2Ioooooooo
06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool0
02Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool0
0ol0VOooooooo`1Woooo0P0008ooool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_oo
o`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Iooo
o`030000oooooooo08koool002Goool00ol0VOooooooo`1Doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo05?oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Doooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`009Oooo`03o`2Ioooooooo05?oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool002Goool00ol0VOooooooo`1C
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool002Goool0
0ol0VOooooooo`1Doooo0P0000[oool300001?ooo`030000oooooooo08koool002Goool00ol0VOoo
ooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>
oooo000Uoooo00?o09Woooooool0Ioooo`80002?oooo000Uoooo00?o09Woooooool0Ioooo`030000
oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2I
oooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo
08koool002Goool00ol0VOooooooo`1Woooo0P0008ooool002Goool00ol0VOooooooo`1Woooo00<0
003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o
09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003ooooo
ool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Wooooo
ool0Ioooo`80002?oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool0
0ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?oo
ooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOoo
ooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool20000Soooo`009Ooo
o`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000
oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2I
oooooooo05ooool500000oooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Qoooo00<0
003oooooool00oooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Qoooo00<0003ooooo
ool00oooo`<0002>oooo000Uoooo00?o09Woooooool0HOooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000Uoooo00?o09Woooooool0HOooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000Uoooo00?o09Woooooool0H?ooo`800005oooo00<0003oooooool0S_ooo`009Oooo`03o`2I
oooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo
08koool002Goool00ol0VOooooooo`1Woooo0P0008ooool002Goool00ol0VOooooooo`1Woooo00<0
003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o
09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003ooooo
ool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Wooooo
ool0Ioooo`80002?oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool0
0ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?oo
ooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOoo
ooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool20000Soooo`009Ooo
o`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000
oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2I
oooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo
08koool002Goool00ol0VOooooooo`1Woooo0P0008ooool002Goool00ol0VOooooooo`1Woooo00<0
003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o
09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Coooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo05Goool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo
05Goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000Uoooo00?o09Wooooo
ool0EOooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool002Goool00ol0VOoo
ooooo`1Eoooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000U
oooo00?o09Woooooool0E?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Uoooo00?o
09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003ooooo
ool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool20000Soooo`009Oooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool0
0ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?oo
ooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOoo
ooooo`1Woooo0P0008ooool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Ooo
o`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000
oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2I
oooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`80002?oooo000U
oooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0
003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o
09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003ooooo
ool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool20000Soooo`009Oooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool0
0ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo05ooool400001?oo
o`030000oooooooo08koool002Goool00ol0VOooooooo`1Ooooo00<0003oooooool01Oooo`030000
oooooooo08koool002Goool00ol0VOooooooo`1Poooo00<0003oooooool01?ooo`<0002>oooo000U
oooo00?o09Woooooool0HOooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000Uoooo00?o
09Woooooool0Goooo`040000oooooooo00001?ooo`030000oooooooo08koool002Goool00ol0VOoo
ooooo`1Poooo0P0000Goool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000
oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2I
oooooooo06Ooool20000Soooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000U
oooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0
003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o
09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo0P0008ooool0
02Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool0
0ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2Ioooooooo06Ooool00`000?oo
ooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`80002?oooo000Uoooo00?o09Woooooool0Iooo
o`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Ooo
o`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Ioooo`030000
oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0003oooooool0S_ooo`009Oooo`03o`2I
oooooooo06Ooool20000Soooo`009Oooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2>oooo000U
oooo00?o09Woooooool0Ioooo`030000oooooooo08koool002Goool00ol0VOooooooo`1Woooo00<0
003oooooool0S_ooo`009Oooo`03o`2Ioooooooo05?oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0Doooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000Uoooo00?o09Woooooool0E?ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`800004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Eoooo00<0003oooooool02_ooo`030000oooooooo00?oool00`000?oo
ooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Doooo00<0003ooooo
ool02?ooo`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool0
00005oooo`030000oooooooo00Soool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000
oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool300000oooo`<00002oooo00<0
003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.04262 .04578 L
.06244 .04578 L
.08255 .04578 L
.08806 .04578 L
.09396 .04578 L
.09682 .04578 L
.09952 .04578 L
.1007 .04578 L
.10195 .04578 L
.1026 .04578 L
s
.1026 .04578 m
.10278 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`050000ooooooooooooo`2I00?oool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo
08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo
06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool0
02Soool00ol0VOooooooo`1Toooo0P0008ooool002Soool00ol0VOooooooo`1Toooo00<0003ooooo
ool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Wooooo
ool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_oo
o`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?oo
o`80002?oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOoo
ooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>
oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1T
oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool20000Soooo`00:?ooo`03o`2I
oooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo
08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo
06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool0
02Soool00ol0VOooooooo`1Toooo0P0008ooool002Soool00ol0VOooooooo`1Toooo00<0003ooooo
ool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Wooooo
ool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Aoooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo053oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0D?oo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00:?ooo`03o`2Ioooooooo
053oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool002Soool00ol0VOoo
ooooo`1@oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
02Soool00ol0VOooooooo`1Aoooo0P0000[oool300001?ooo`030000oooooooo08koool002Soool0
0ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?oo
ooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`80002?oooo000Xoooo00?o09Woooooool0I?oo
o`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?oo
o`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000
oooooooo08koool002Soool00ol0VOooooooo`1Toooo0P0008ooool002Soool00ol0VOooooooo`1T
oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0
003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o
09Woooooool0I?ooo`80002?oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool0
02Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool0
0`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool0
0ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool20000Sooo
o`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?oo
o`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?oo
o`03o`2Ioooooooo05coool500000oooo`030000oooooooo08koool002Soool00ol0VOooooooo`1N
oooo00<0003oooooool00oooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Noooo00<0
003oooooool00oooo`<0002>oooo000Xoooo00?o09Woooooool0G_ooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0G_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000Xoooo00?o09Woooooool0GOooo`800005oooo00<0003oooooool0S_ooo`00:?oo
o`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000
oooooooo08koool002Soool00ol0VOooooooo`1Toooo0P0008ooool002Soool00ol0VOooooooo`1T
oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0
003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o
09Woooooool0I?ooo`80002?oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool0
02Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool0
0`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool0
0ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool20000Sooo
o`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?oo
o`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?oo
o`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000
oooooooo08koool002Soool00ol0VOooooooo`1Toooo0P0008ooool002Soool00ol0VOooooooo`1T
oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1@oooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo05;oool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00:?ooo`03o`2I
oooooooo05;oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000Xoooo00?o
09Woooooool0D_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool002Soool0
0ol0VOooooooo`1Boooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo000Xoooo00?o09Woooooool0DOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0
003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo
06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool0
02Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool0
0`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool0
0ol0VOooooooo`1Toooo0P0008ooool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_oo
o`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?oo
o`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?oo
o`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`80002?
oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1T
oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0
003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo
06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool0
02Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo05coool4
00001?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Loooo00<0003oooooool01Ooo
o`030000oooooooo08koool002Soool00ol0VOooooooo`1Moooo00<0003oooooool01?ooo`<0002>
oooo000Xoooo00?o09Woooooool0G_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0G?ooo`040000oooooooo00001?ooo`030000oooooooo08koool002Soool0
0ol0VOooooooo`1Moooo0P0000Goool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?oo
o`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?oo
o`03o`2Ioooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>
oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1T
oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo0P00
08ooool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo
06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool0
02Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool0
0`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`80002?oooo000Xoooo00?o09Wooooo
ool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_oo
o`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?oo
o`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?oo
o`03o`2Ioooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>
oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1T
oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo053oool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0D?ooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0DOooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?oo
o`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Ooo
o`030000oooooooo00[oool00`000?ooooooo`02oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000Doooo00<0003oooooool02?ooo`800004oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000001Ooool00`000?ooooooo`08oooo00<0003oooooool00oooo`030000
oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool300000_ooo`030000oooooooo
07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.08255 .04578 L
.0932 .04578 L
.09905 .04578 L
.10458 .04578 L
.10708 .04578 L
.10972 .04578 L
.11039 .04578 L
.1111 .04578 L
s
.1111 .04578 m
.1113 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00?oool00ol0VOoo
o`000007oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool0
02[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo0P0008ooool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_oo
o`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_oo
o`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_oo
o`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`80002?
oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1R
oooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Z
oooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0
003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo
06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool0
02[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo0P0008ooool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_oo
o`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_oo
o`030000oooooooo08koool002[oool00ol0VOooooooo`1?oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo04koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0C_ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00:_ooo`03o`2Ioooooooo04koool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool002[oool00ol0VOooooooo`1>
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1?oooo0P0000[oool300001?ooo`030000oooooooo08koool002[oool00ol0VOoo
ooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>
oooo000Zoooo00?o09Woooooool0H_ooo`80002?oooo000Zoooo00?o09Woooooool0H_ooo`030000
oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2I
oooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo
08koool002[oool00ol0VOooooooo`1Roooo0P0008ooool002[oool00ol0VOooooooo`1Roooo00<0
003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003ooooo
ool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Wooooo
ool0H_ooo`80002?oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?oo
ooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOoo
ooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Soooo`00:_oo
o`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000
oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2I
oooooooo05[oool500000oooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Loooo00<0
003oooooool00oooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Loooo00<0003ooooo
ool00oooo`<0002>oooo000Zoooo00?o09Woooooool0G?ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000Zoooo00?o09Woooooool0G?ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000Zoooo00?o09Woooooool0Foooo`800005oooo00<0003oooooool0S_ooo`00:_ooo`03o`2I
oooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo
08koool002[oool00ol0VOooooooo`1Roooo0P0008ooool002[oool00ol0VOooooooo`1Roooo00<0
003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003ooooo
ool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Wooooo
ool0H_ooo`80002?oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?oo
ooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOoo
ooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Soooo`00:_oo
o`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000
oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2I
oooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo
08koool002[oool00ol0VOooooooo`1Roooo0P0008ooool002[oool00ol0VOooooooo`1Roooo00<0
003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1>oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo053oool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo
053oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000Zoooo00?o09Wooooo
ool0D?ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool002[oool00ol0VOoo
ooooo`1@oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000Z
oooo00?o09Woooooool0Coooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003ooooo
ool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?oo
ooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOoo
ooooo`1Roooo0P0008ooool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_oo
o`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000
oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2I
oooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`80002?oooo000Z
oooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0
003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003ooooo
ool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo05[oool400001?oo
o`030000oooooooo08koool002[oool00ol0VOooooooo`1Joooo00<0003oooooool01Oooo`030000
oooooooo08koool002[oool00ol0VOooooooo`1Koooo00<0003oooooool01?ooo`<0002>oooo000Z
oooo00?o09Woooooool0G?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0F_ooo`040000oooooooo00001?ooo`030000oooooooo08koool002[oool00ol0VOoo
ooooo`1Koooo0P0000Goool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000
oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2I
oooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Z
oooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0
003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo0P0008ooool0
02[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?oo
ooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`80002?oooo000Zoooo00?o09Woooooool0H_oo
o`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_oo
o`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000
oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2I
oooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Z
oooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0
003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo04koool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0C_ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0Coooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001Oooo`<00002
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`0:oooo00@0003ooooo
ool00002oooo00D0003oooooooooool00000Moooo`00M?ooo`030000oooooooo00;oool00`000?oo
ooooo`0Eoooo00<0003oooooool01oooo`D00004oooo00<0003oooooool00_ooo`030000oooooooo
07Coool007Goool00`000?ooooooo`0500005?ooo`030000oooooooo00Ooool010000?ooooooo`00
00?oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`00000Goooo00<0
003oooooool02?ooo`030000oooo000000?oool00`000?ooooooo`03oooo00<0003oooooool0MOoo
o`00M_ooo`030000oooooooo01Ooool200002oooo`800003oooo0`0000;oool00`000?ooooooo`1f
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.08255 .04578 L
.0932 .04578 L
.10458 .04578 L
.11009 .04578 L
.1128 .04578 L
.11531 .04578 L
.11758 .04578 L
.11872 .04578 L
s
.11872 .04578 m
.11904 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool0
02coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool0
0`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool0
0ol0VOooooooo`1Poooo0P0008ooool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_oo
o`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?oo
o`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?oo
o`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`80002?
oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1P
oooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/
oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo
063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool0
02coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool0
0`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool0
0ol0VOooooooo`1Poooo0P0008ooool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_oo
o`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?oo
o`030000oooooooo08koool002coool00ol0VOooooooo`1=oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo04coool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0C?ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00;?ooo`03o`2Ioooooooo04coool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool002coool00ol0VOooooooo`1<
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool002coool0
0ol0VOooooooo`1=oooo0P0000[oool300001?ooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>
oooo000/oooo00?o09Woooooool0H?ooo`80002?oooo000/oooo00?o09Woooooool0H?ooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo
08koool002coool00ol0VOooooooo`1Poooo0P0008ooool002coool00ol0VOooooooo`1Poooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o
09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003ooooo
ool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Wooooo
ool0H?ooo`80002?oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool0
0ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?oo
ooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?oo
o`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo05Soool500000oooo`030000oooooooo08koool002coool00ol0VOooooooo`1Joooo00<0
003oooooool00oooo`030000oooooooo08koool002coool00ol0VOooooooo`1Joooo00<0003ooooo
ool00oooo`<0002>oooo000/oooo00?o09Woooooool0F_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000/oooo00?o09Woooooool0F_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000/oooo00?o09Woooooool0FOooo`800005oooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo
08koool002coool00ol0VOooooooo`1Poooo0P0008ooool002coool00ol0VOooooooo`1Poooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o
09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003ooooo
ool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Wooooo
ool0H?ooo`80002?oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool0
0ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?oo
ooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?oo
o`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo
08koool002coool00ol0VOooooooo`1Poooo0P0008ooool002coool00ol0VOooooooo`1Poooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o
09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1<oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo04koool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo
04koool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000/oooo00?o09Wooooo
ool0C_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`1>oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000/
oooo00?o09Woooooool0COooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000/oooo00?o
09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003ooooo
ool0S_ooo`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo063oool0
0`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool0
0ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?oo
ooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`1Poooo0P0008ooool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?oo
o`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`80002?oooo000/
oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o
09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003ooooo
ool0S_ooo`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo063oool0
0`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool0
0ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo05Soool400001?oo
o`030000oooooooo08koool002coool00ol0VOooooooo`1Hoooo00<0003oooooool01Oooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Ioooo00<0003oooooool01?ooo`<0002>oooo000/
oooo00?o09Woooooool0F_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000/oooo00?o
09Woooooool0F?ooo`040000oooooooo00001?ooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`1Ioooo0P0000Goool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/
oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o
09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo0P0008ooool0
02coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool0
0`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool0
0ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?oo
ooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`80002?oooo000/oooo00?o09Woooooool0H?oo
o`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?oo
o`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/
oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo04coool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000/oooo00?o09Woooooool0C?ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0COooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001Oooo`<00002
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02_ooo`050000oooooooooooo0000
07[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000oooooooo00Ooool5
00000oooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005?ooo`030000oooooooo
00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00005oooo`030000oooooooo00Soool00`000?ooo`000003oooo00<0003oooooool0N?ooo`00NOoo
o`030000oooooooo01Ooool200002oooo`800002oooo00<0003oooooool0NOooo`00ooooob7oool0
0?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.08255 .04578 L
.10458 .04578 L
.11448 .04578 L
.11992 .04578 L
.1226 .04578 L
.12377 .04578 L
.12507 .04578 L
.12627 .04578 L
s
.12627 .04578 m
.12655 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ool0V@05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool0
02koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool0
0`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool0
0ol0VOooooooo`1Noooo0P0008ooool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_oo
o`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_oo
o`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_oo
o`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`80002?
oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1N
oooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^
oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo
05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool0
02koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool0
0`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool0
0ol0VOooooooo`1Noooo0P0008ooool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_oo
o`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_oo
o`030000oooooooo08koool002koool00ol0VOooooooo`1;oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo04[oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0B_ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00;_ooo`03o`2Ioooooooo04[oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool002koool00ol0VOooooooo`1:
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool002koool0
0ol0VOooooooo`1;oooo0P0000[oool300001?ooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>
oooo000^oooo00?o09Woooooool0G_ooo`80002?oooo000^oooo00?o09Woooooool0G_ooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo
08koool002koool00ol0VOooooooo`1Noooo0P0008ooool002koool00ol0VOooooooo`1Noooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o
09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003ooooo
ool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Wooooo
ool0G_ooo`80002?oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool0
0ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?oo
ooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_oo
o`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05Koool500000oooo`030000oooooooo08koool002koool00ol0VOooooooo`1Hoooo00<0
003oooooool00oooo`030000oooooooo08koool002koool00ol0VOooooooo`1Hoooo00<0003ooooo
ool00oooo`<0002>oooo000^oooo00?o09Woooooool0F?ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000^oooo00?o09Woooooool0F?ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000^oooo00?o09Woooooool0Eoooo`800005oooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo
08koool002koool00ol0VOooooooo`1Noooo0P0008ooool002koool00ol0VOooooooo`1Noooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o
09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003ooooo
ool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Wooooo
ool0G_ooo`80002?oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool0
0ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?oo
ooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_oo
o`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo
08koool002koool00ol0VOooooooo`1Noooo0P0008ooool002koool00ol0VOooooooo`1Noooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o
09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1:oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo04coool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo
04coool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000^oooo00?o09Wooooo
ool0C?ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`1<oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000^
oooo00?o09Woooooool0Boooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000^oooo00?o
09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003ooooo
ool0S_ooo`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo05koool0
0`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool0
0ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?oo
ooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`1Noooo0P0008ooool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_oo
o`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`80002?oooo000^
oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o
09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003ooooo
ool0S_ooo`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo05koool0
0`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool0
0ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05Koool400001?oo
o`030000oooooooo08koool002koool00ol0VOooooooo`1Foooo00<0003oooooool01Oooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Goooo00<0003oooooool01?ooo`<0002>oooo000^
oooo00?o09Woooooool0F?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000^oooo00?o
09Woooooool0E_ooo`040000oooooooo00001?ooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`1Goooo0P0000Goool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^
oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o
09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo0P0008ooool0
02koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool0
0`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool0
0ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?oo
ooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`80002?oooo000^oooo00?o09Woooooool0G_oo
o`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_oo
o`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^
oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo04[oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000^oooo00?o09Woooooool0B_ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0Boooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`800004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Eoooo00<0003oooooool02Oooo`030000oooooooo00Coool00`000?oo
ooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Doooo00<0003ooooo
ool02_ooo`040000oooooooooooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`03
oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004oooo0`00
00;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.08255 .04578 L
.10458 .04578 L
.11448 .04578 L
.11992 .04578 L
.12507 .04578 L
.12986 .04578 L
.13117 .04578 L
.13256 .04578 L
.13375 .04578 L
s
.13375 .04578 m
.13408 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool01@000?oo
ooooooooool0V@03oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo
08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo
05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0
033oool00ol0VOooooooo`1Loooo0P0008ooool0033oool00ol0VOooooooo`1Loooo00<0003ooooo
ool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Wooooo
ool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_oo
o`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?oo
o`80002?oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOoo
ooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>
oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1L
oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool20000Soooo`00<?ooo`03o`2I
oooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo
08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo
05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0
033oool00ol0VOooooooo`1Loooo0P0008ooool0033oool00ol0VOooooooo`1Loooo00<0003ooooo
ool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Wooooo
ool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`19oooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo04Soool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0B?oo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00<?ooo`03o`2Ioooooooo
04Soool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool0033oool00ol0VOoo
ooooo`18oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
033oool00ol0VOooooooo`19oooo0P0000[oool300001?ooo`030000oooooooo08koool0033oool0
0ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?oo
ooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`80002?oooo000`oooo00?o09Woooooool0G?oo
o`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?oo
o`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000
oooooooo08koool0033oool00ol0VOooooooo`1Loooo0P0008ooool0033oool00ol0VOooooooo`1L
oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0
003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o
09Woooooool0G?ooo`80002?oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0
033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool0
0`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool0
0ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool20000Sooo
o`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?oo
o`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?oo
o`03o`2Ioooooooo05Coool500000oooo`030000oooooooo08koool0033oool00ol0VOooooooo`1F
oooo00<0003oooooool00oooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Foooo00<0
003oooooool00oooo`<0002>oooo000`oooo00?o09Woooooool0E_ooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo000`oooo00?o09Woooooool0E_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000`oooo00?o09Woooooool0EOooo`800005oooo00<0003oooooool0S_ooo`00<?oo
o`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000
oooooooo08koool0033oool00ol0VOooooooo`1Loooo0P0008ooool0033oool00ol0VOooooooo`1L
oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0
003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o
09Woooooool0G?ooo`80002?oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0
033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool0
0`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool0
0ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool20000Sooo
o`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?oo
o`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?oo
o`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000
oooooooo08koool0033oool00ol0VOooooooo`1Loooo0P0008ooool0033oool00ol0VOooooooo`1L
oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`18oooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00<?ooo`03o`2I
oooooooo04[oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000`oooo00?o
09Woooooool0B_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool0033oool0
0ol0VOooooooo`1:oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo000`oooo00?o09Woooooool0BOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0
003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo
05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0
033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool0
0`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool0
0ol0VOooooooo`1Loooo0P0008ooool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_oo
o`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?oo
o`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?oo
o`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`80002?
oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1L
oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0
003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo
05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0
033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05Coool4
00001?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Doooo00<0003oooooool01Ooo
o`030000oooooooo08koool0033oool00ol0VOooooooo`1Eoooo00<0003oooooool01?ooo`<0002>
oooo000`oooo00?o09Woooooool0E_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0E?ooo`040000oooooooo00001?ooo`030000oooooooo08koool0033oool0
0ol0VOooooooo`1Eoooo0P0000Goool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?oo
o`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?oo
o`03o`2Ioooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>
oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1L
oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo0P00
08ooool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo
05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0
033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool0
0`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`80002?oooo000`oooo00?o09Wooooo
ool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_oo
o`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?oo
o`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?oo
o`03o`2Ioooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>
oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1L
oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo04Soool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0B?ooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0BOooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?oo
o`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Ooo
o`030000oooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000Doooo00<0003oooooool02_ooo`050000oooooooooooo000007[oool007Soool0
1@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000
oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000oooo`030000oooooooo
07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.08255 .04578 L
.10458 .04578 L
.11448 .04578 L
.12507 .04578 L
.1302 .04578 L
.13506 .04578 L
.13942 .04578 L
.14061 .04578 L
.14188 .04578 L
s
.14188 .04578 m
.14215 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`03oooo00?o09Woool000001oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool0
03;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool0
0`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo0P0008ooool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_oo
o`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_oo
o`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_oo
o`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`80002?
oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1J
oooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000b
oooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0
003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo
05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool0
03;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool0
0`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo0P0008ooool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_oo
o`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_oo
o`030000oooooooo08koool003;oool00ol0VOooooooo`17oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo04Koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0A_ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00<_ooo`03o`2Ioooooooo04Koool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool003;oool00ol0VOooooooo`16
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`17oooo0P0000[oool300001?ooo`030000oooooooo08koool003;oool00ol0VOoo
ooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>
oooo000boooo00?o09Woooooool0F_ooo`80002?oooo000boooo00?o09Woooooool0F_ooo`030000
oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2I
oooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo
08koool003;oool00ol0VOooooooo`1Joooo0P0008ooool003;oool00ol0VOooooooo`1Joooo00<0
003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003ooooo
ool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Wooooo
ool0F_ooo`80002?oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?oo
ooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOoo
ooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Soooo`00<_oo
o`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000
oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2I
oooooooo05;oool500000oooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Doooo00<0
003oooooool00oooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Doooo00<0003ooooo
ool00oooo`<0002>oooo000boooo00?o09Woooooool0E?ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000boooo00?o09Woooooool0E?ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000boooo00?o09Woooooool0Doooo`800005oooo00<0003oooooool0S_ooo`00<_ooo`03o`2I
oooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo
08koool003;oool00ol0VOooooooo`1Joooo0P0008ooool003;oool00ol0VOooooooo`1Joooo00<0
003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003ooooo
ool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Wooooo
ool0F_ooo`80002?oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?oo
ooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOoo
ooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Soooo`00<_oo
o`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000
oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2I
oooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo
08koool003;oool00ol0VOooooooo`1Joooo0P0008ooool003;oool00ol0VOooooooo`1Joooo00<0
003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`16oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo04Soool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo
04Soool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000boooo00?o09Wooooo
ool0B?ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool003;oool00ol0VOoo
ooooo`18oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000b
oooo00?o09Woooooool0Aoooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003ooooo
ool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool0
0`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?oo
ooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOoo
ooooo`1Joooo0P0008ooool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_oo
o`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000
oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2I
oooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`80002?oooo000b
oooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0
003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003ooooo
ool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool0
0`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05;oool400001?oo
o`030000oooooooo08koool003;oool00ol0VOooooooo`1Boooo00<0003oooooool01Oooo`030000
oooooooo08koool003;oool00ol0VOooooooo`1Coooo00<0003oooooool01?ooo`<0002>oooo000b
oooo00?o09Woooooool0E?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0D_ooo`040000oooooooo00001?ooo`030000oooooooo08koool003;oool00ol0VOoo
ooooo`1Coooo0P0000Goool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000
oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2I
oooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000b
oooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0
003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo0P0008ooool0
03;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool0
0`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?oo
ooooo`2>oooo000boooo00?o09Woooooool0F_ooo`80002?oooo000boooo00?o09Woooooool0F_oo
o`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_oo
o`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000
oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2I
oooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000b
oooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0
003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo04Koool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000boooo00?o09Woooooool0A_ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0Aoooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000oooo`@00003
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00<0003ooooo
ool00oooo`040000oooooooo00000oooo`030000oooooooo07Goool007Coool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Soool00`000?ooooooo`05oooo00<0003ooooo
ool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000oooooooo
00Woool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`03
oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004oooo0`00
00;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.12507 .04578 L
.13506 .04578 L
.14415 .04578 L
.14635 .04578 L
.14868 .04578 L
.1499 .04578 L
.15059 .04578 L
s
.15059 .04578 m
.15076 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool0
03Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool0
0`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool0
0ol0VOooooooo`1Hoooo0P0008ooool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_oo
o`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?oo
o`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?oo
o`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`80002?
oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1H
oooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000d
oooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo
05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool0
03Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool0
0`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool0
0ol0VOooooooo`1Hoooo0P0008ooool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_oo
o`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?oo
o`030000oooooooo08koool003Coool00ol0VOooooooo`15oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo04Coool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0A?ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00=?ooo`03o`2Ioooooooo04Coool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool003Coool00ol0VOooooooo`14
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool003Coool0
0ol0VOooooooo`15oooo0P0000[oool300001?ooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>
oooo000doooo00?o09Woooooool0F?ooo`80002?oooo000doooo00?o09Woooooool0F?ooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo
08koool003Coool00ol0VOooooooo`1Hoooo0P0008ooool003Coool00ol0VOooooooo`1Hoooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o
09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003ooooo
ool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Wooooo
ool0F?ooo`80002?oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool0
0ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?oo
ooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?oo
o`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo053oool500000oooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Boooo00<0
003oooooool00oooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Boooo00<0003ooooo
ool00oooo`<0002>oooo000doooo00?o09Woooooool0D_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000doooo00?o09Woooooool0D_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000doooo00?o09Woooooool0DOooo`800005oooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo
08koool003Coool00ol0VOooooooo`1Hoooo0P0008ooool003Coool00ol0VOooooooo`1Hoooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o
09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003ooooo
ool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Wooooo
ool0F?ooo`80002?oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool0
0ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?oo
ooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?oo
o`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo
08koool003Coool00ol0VOooooooo`1Hoooo0P0008ooool003Coool00ol0VOooooooo`1Hoooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o
09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`14oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo04Koool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo
04Koool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000doooo00?o09Wooooo
ool0A_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`16oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000d
oooo00?o09Woooooool0AOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000doooo00?o
09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003ooooo
ool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo05Soool0
0`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool0
0ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?oo
ooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`1Hoooo0P0008ooool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?oo
o`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`80002?oooo000d
oooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o
09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003ooooo
ool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo05Soool0
0`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool0
0ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo053oool400001?oo
o`030000oooooooo08koool003Coool00ol0VOooooooo`1@oooo00<0003oooooool01Oooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Aoooo00<0003oooooool01?ooo`<0002>oooo000d
oooo00?o09Woooooool0D_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000doooo00?o
09Woooooool0D?ooo`040000oooooooo00001?ooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`1Aoooo0P0000Goool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000d
oooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o
09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo0P0008ooool0
03Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool0
0`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool0
0ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?oo
ooooo`2>oooo000doooo00?o09Woooooool0F?ooo`80002?oooo000doooo00?o09Woooooool0F?oo
o`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?oo
o`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000d
oooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo04Coool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000doooo00?o09Woooooool0A?ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0AOooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000oooo`@00003
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`030000oooooooo00Coool0
0`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?oo
ooooo`08oooo00<0003oooooool01?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`05
00005?ooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000001Ooool00`000?ooooooo`07oooo00@0003oooooool00003oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003oooo00<0003ooooo
ool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.12507 .04578 L
.13506 .04578 L
.14415 .04578 L
.14868 .04578 L
.1536 .04578 L
.15586 .04578 L
.15709 .04578 L
.15825 .04578 L
s
.15825 .04578 m
.1585 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003ooooo09T01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool0
03Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool0
0`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool0
0ol0VOooooooo`1Foooo0P0008ooool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_oo
o`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_oo
o`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_oo
o`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`80002?
oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1F
oooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000f
oooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo
05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool0
03Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool0
0`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool0
0ol0VOooooooo`1Foooo0P0008ooool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_oo
o`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_oo
o`030000oooooooo08koool003Koool00ol0VOooooooo`13oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo04;oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0@_ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00=_ooo`03o`2Ioooooooo04;oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool003Koool00ol0VOooooooo`12
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool003Koool0
0ol0VOooooooo`13oooo0P0000[oool300001?ooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>
oooo000foooo00?o09Woooooool0E_ooo`80002?oooo000foooo00?o09Woooooool0E_ooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo
08koool003Koool00ol0VOooooooo`1Foooo0P0008ooool003Koool00ol0VOooooooo`1Foooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o
09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003ooooo
ool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Wooooo
ool0E_ooo`80002?oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool0
0ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?oo
ooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_oo
o`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo04koool500000oooo`030000oooooooo08koool003Koool00ol0VOooooooo`1@oooo00<0
003oooooool00oooo`030000oooooooo08koool003Koool00ol0VOooooooo`1@oooo00<0003ooooo
ool00oooo`<0002>oooo000foooo00?o09Woooooool0D?ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000foooo00?o09Woooooool0D?ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000foooo00?o09Woooooool0Coooo`800005oooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo
08koool003Koool00ol0VOooooooo`1Foooo0P0008ooool003Koool00ol0VOooooooo`1Foooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o
09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003ooooo
ool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Wooooo
ool0E_ooo`80002?oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool0
0ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?oo
ooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_oo
o`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo
08koool003Koool00ol0VOooooooo`1Foooo0P0008ooool003Koool00ol0VOooooooo`1Foooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o
09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`12oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo04Coool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo
04Coool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000foooo00?o09Wooooo
ool0A?ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`14oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000f
oooo00?o09Woooooool0@oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000foooo00?o
09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003ooooo
ool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo05Koool0
0`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool0
0ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?oo
ooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`1Foooo0P0008ooool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_oo
o`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`80002?oooo000f
oooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o
09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003ooooo
ool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo05Koool0
0`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool0
0ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo04koool400001?oo
o`030000oooooooo08koool003Koool00ol0VOooooooo`1>oooo00<0003oooooool01Oooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1?oooo00<0003oooooool01?ooo`<0002>oooo000f
oooo00?o09Woooooool0D?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000foooo00?o
09Woooooool0C_ooo`040000oooooooo00001?ooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`1?oooo0P0000Goool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000f
oooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o
09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo0P0008ooool0
03Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool0
0`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool0
0ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?oo
ooooo`2>oooo000foooo00?o09Woooooool0E_ooo`80002?oooo000foooo00?o09Woooooool0E_oo
o`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_oo
o`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000f
oooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo04;oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000foooo00?o09Woooooool0@_ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0@oooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000oooo`D00002
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`09oooo00D0003ooooo
ooooool000000_ooo`050000oooooooooooo000007Ooool007Coool00`000?ooooooo`02oooo00<0
003oooooool05Oooo`030000oooooooo00Woool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000oooooooo00Woool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool0
00005oooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000
oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool200001?ooo`<00002oooo00<0
003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.12507 .04578 L
.14415 .04578 L
.1536 .04578 L
.15825 .04578 L
.16254 .04578 L
.16494 .04578 L
.16615 .04578 L
s
.16615 .04578 m
.16632 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00D0003ooooooooooooo09T00oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo
08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo
05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool0
03Soool00ol0VOooooooo`1Doooo0P0008ooool003Soool00ol0VOooooooo`1Doooo00<0003ooooo
ool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Wooooo
ool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_oo
o`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?oo
o`80002?oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOoo
ooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>
oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1D
oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool20000Soooo`00>?ooo`03o`2I
oooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo
08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo
05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool0
03Soool00ol0VOooooooo`1Doooo0P0008ooool003Soool00ol0VOooooooo`1Doooo00<0003ooooo
ool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Wooooo
ool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`11oooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo043oool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0@?oo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00>?ooo`03o`2Ioooooooo
043oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool003Soool00ol0VOoo
ooooo`10oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
03Soool00ol0VOooooooo`11oooo0P0000[oool300001?ooo`030000oooooooo08koool003Soool0
0ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?oo
ooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`80002?oooo000hoooo00?o09Woooooool0E?oo
o`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?oo
o`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000
oooooooo08koool003Soool00ol0VOooooooo`1Doooo0P0008ooool003Soool00ol0VOooooooo`1D
oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0
003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o
09Woooooool0E?ooo`80002?oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool0
03Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool0
0`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool0
0ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool20000Sooo
o`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?oo
o`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?oo
o`03o`2Ioooooooo04coool500000oooo`030000oooooooo08koool003Soool00ol0VOooooooo`1>
oooo00<0003oooooool00oooo`030000oooooooo08koool003Soool00ol0VOooooooo`1>oooo00<0
003oooooool00oooo`<0002>oooo000hoooo00?o09Woooooool0C_ooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo000hoooo00?o09Woooooool0C_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000hoooo00?o09Woooooool0COooo`800005oooo00<0003oooooool0S_ooo`00>?oo
o`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000
oooooooo08koool003Soool00ol0VOooooooo`1Doooo0P0008ooool003Soool00ol0VOooooooo`1D
oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0
003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o
09Woooooool0E?ooo`80002?oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool0
03Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool0
0`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool0
0ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool20000Sooo
o`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?oo
o`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?oo
o`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000
oooooooo08koool003Soool00ol0VOooooooo`1Doooo0P0008ooool003Soool00ol0VOooooooo`1D
oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`10oooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo04;oool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00>?ooo`03o`2I
oooooooo04;oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000hoooo00?o
09Woooooool0@_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool003Soool0
0ol0VOooooooo`12oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo000hoooo00?o09Woooooool0@Oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0
003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo
05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool0
03Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool0
0`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool0
0ol0VOooooooo`1Doooo0P0008ooool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_oo
o`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?oo
o`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?oo
o`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`80002?
oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1D
oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0
003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo
05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool0
03Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo04coool4
00001?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1<oooo00<0003oooooool01Ooo
o`030000oooooooo08koool003Soool00ol0VOooooooo`1=oooo00<0003oooooool01?ooo`<0002>
oooo000hoooo00?o09Woooooool0C_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0C?ooo`040000oooooooo00001?ooo`030000oooooooo08koool003Soool0
0ol0VOooooooo`1=oooo0P0000Goool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?oo
o`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?oo
o`03o`2Ioooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>
oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1D
oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo0P00
08ooool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo
05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool0
03Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool0
0`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`80002?oooo000hoooo00?o09Wooooo
ool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_oo
o`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?oo
o`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?oo
o`03o`2Ioooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>
oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1D
oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo043oool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0@?ooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0@Oooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000ooo
o`D00002oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02Oooo`030000oooooooo
00;oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool0
0`000?ooooooo`09oooo00<0003oooooool00oooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500005?ooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000001Ooool00`000?ooooooo`09oooo00<0003oooooool00_oo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000oooo`030000
oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.12507 .04578 L
.14415 .04578 L
.16254 .04578 L
.16783 .04578 L
.17044 .04578 L
.17158 .04578 L
.17284 .04578 L
.17396 .04578 L
s
.17396 .04578 m
.17423 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool00oooo`03o`2Ioooo000000Soool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool0
03[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool0
0`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo0P0008ooool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_oo
o`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_oo
o`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_oo
o`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`80002?
oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1B
oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000j
oooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0
003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool20000Soooo`00>_ooo`03o`2Ioooooooo
05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool0
03[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool0
0`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo0P0008ooool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_oo
o`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_oo
o`030000oooooooo08koool003[oool00ol0VOooooooo`0ooooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo03koool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0?_ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00>_ooo`03o`2Ioooooooo03koool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool003[oool00ol0VOooooooo`0n
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`0ooooo0P0000[oool300001?ooo`030000oooooooo08koool003[oool00ol0VOoo
ooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>
oooo000joooo00?o09Woooooool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_ooo`030000
oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2I
oooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo
08koool003[oool00ol0VOooooooo`1Boooo0P0008ooool003[oool00ol0VOooooooo`1Boooo00<0
003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o
09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003ooooo
ool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Wooooo
ool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?oo
ooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOoo
ooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool20000Soooo`00>_oo
o`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000
oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2I
oooooooo04[oool500000oooo`030000oooooooo08koool003[oool00ol0VOooooooo`1<oooo00<0
003oooooool00oooo`030000oooooooo08koool003[oool00ol0VOooooooo`1<oooo00<0003ooooo
ool00oooo`<0002>oooo000joooo00?o09Woooooool0C?ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000joooo00?o09Woooooool0C?ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000joooo00?o09Woooooool0Boooo`800005oooo00<0003oooooool0S_ooo`00>_ooo`03o`2I
oooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo
08koool003[oool00ol0VOooooooo`1Boooo0P0008ooool003[oool00ol0VOooooooo`1Boooo00<0
003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o
09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003ooooo
ool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Wooooo
ool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?oo
ooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOoo
ooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool20000Soooo`00>_oo
o`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000
oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2I
oooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo
08koool003[oool00ol0VOooooooo`1Boooo0P0008ooool003[oool00ol0VOooooooo`1Boooo00<0
003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o
09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`0noooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo043oool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo
043oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000joooo00?o09Wooooo
ool0@?ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool003[oool00ol0VOoo
ooooo`10oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000j
oooo00?o09Woooooool0?oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000joooo00?o
09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003ooooo
ool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool20000Soooo`00>_ooo`03o`2Ioooooooo05;oool0
0`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?oo
ooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOoo
ooooo`1Boooo0P0008ooool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_oo
o`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000
oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2I
oooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`80002?oooo000j
oooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0
003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o
09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003ooooo
ool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool20000Soooo`00>_ooo`03o`2Ioooooooo05;oool0
0`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo04[oool400001?oo
o`030000oooooooo08koool003[oool00ol0VOooooooo`1:oooo00<0003oooooool01Oooo`030000
oooooooo08koool003[oool00ol0VOooooooo`1;oooo00<0003oooooool01?ooo`<0002>oooo000j
oooo00?o09Woooooool0C?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000joooo00?o
09Woooooool0B_ooo`040000oooooooo00001?ooo`030000oooooooo08koool003[oool00ol0VOoo
ooooo`1;oooo0P0000Goool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000
oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2I
oooooooo05;oool20000Soooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000j
oooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0
003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o
09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo0P0008ooool0
03[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool0
0`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?oo
ooooo`2>oooo000joooo00?o09Woooooool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_oo
o`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_oo
o`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000
oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2I
oooooooo05;oool20000Soooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000j
oooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0
003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo03koool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000joooo00?o09Woooooool0?_ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0?oooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`800004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`040000oooooooo00001Oooo`030000
oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001Coool00`000?oo
ooooo`07oooo00@0003oooooool00003oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004
oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.16408 .04578 L
.17277 .04578 L
.17735 .04578 L
.17986 .04578 L
.18109 .04578 L
.18221 .04578 L
s
.18221 .04578 m
.18251 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool0
03coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool0
0`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`1@oooo0P0008ooool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_oo
o`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?oo
o`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??oo
o`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?
oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@
oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000l
oooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0
003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool20000Soooo`00??ooo`03o`2Ioooooooo
053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool0
03coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool0
0`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`1@oooo0P0008ooool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_oo
o`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?oo
o`030000oooooooo08koool003coool00ol0VOooooooo`0moooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo03coool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0??ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00??ooo`03o`2Ioooooooo03coool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool003coool00ol0VOooooooo`0l
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`0moooo0P0000[oool300001?ooo`030000oooooooo08koool003coool00ol0VOoo
ooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>
oooo000loooo00?o09Woooooool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?ooo`030000
oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2I
oooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo
08koool003coool00ol0VOooooooo`1@oooo0P0008ooool003coool00ol0VOooooooo`1@oooo00<0
003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o
09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003ooooo
ool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Wooooo
ool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?oo
ooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOoo
ooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool20000Soooo`00??oo
o`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000
oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2I
oooooooo04Soool500000oooo`030000oooooooo08koool003coool00ol0VOooooooo`1:oooo00<0
003oooooool00oooo`030000oooooooo08koool003coool00ol0VOooooooo`1:oooo00<0003ooooo
ool00oooo`<0002>oooo000loooo00?o09Woooooool0B_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000loooo00?o09Woooooool0B_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000loooo00?o09Woooooool0BOooo`800005oooo00<0003oooooool0S_ooo`00??ooo`03o`2I
oooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo
08koool003coool00ol0VOooooooo`1@oooo0P0008ooool003coool00ol0VOooooooo`1@oooo00<0
003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o
09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003ooooo
ool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Wooooo
ool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?oo
ooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOoo
ooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool20000Soooo`00??oo
o`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000
oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2I
oooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo
08koool003coool00ol0VOooooooo`1@oooo0P0008ooool003coool00ol0VOooooooo`1@oooo00<0
003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o
09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`0loooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo03koool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo
03koool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000loooo00?o09Wooooo
ool0?_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool003coool00ol0VOoo
ooooo`0noooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000l
oooo00?o09Woooooool0?Oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000loooo00?o
09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003ooooo
ool0S_ooo`00??ooo`03o`2Ioooooooo053oool20000Soooo`00??ooo`03o`2Ioooooooo053oool0
0`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?oo
ooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOoo
ooooo`1@oooo0P0008ooool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??oo
o`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000
oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2I
oooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?oooo000l
oooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0
003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o
09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003ooooo
ool0S_ooo`00??ooo`03o`2Ioooooooo053oool20000Soooo`00??ooo`03o`2Ioooooooo053oool0
0`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo04Soool400001?oo
o`030000oooooooo08koool003coool00ol0VOooooooo`18oooo00<0003oooooool01Oooo`030000
oooooooo08koool003coool00ol0VOooooooo`19oooo00<0003oooooool01?ooo`<0002>oooo000l
oooo00?o09Woooooool0B_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000loooo00?o
09Woooooool0B?ooo`040000oooooooo00001?ooo`030000oooooooo08koool003coool00ol0VOoo
ooooo`19oooo0P0000Goool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000
oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2I
oooooooo053oool20000Soooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000l
oooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0
003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o
09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo0P0008ooool0
03coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool0
0`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?oo
ooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?oo
o`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??oo
o`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000
oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2I
oooooooo053oool20000Soooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000l
oooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0
003oooooool0S_ooo`00??ooo`03o`2Ioooooooo03coool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000loooo00?o09Woooooool0??ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0?Oooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001loooo00<0003oooooool08_ooo`030000oooooooo07coool0
07_oool00`000?ooooooo`08oooo00<0003oooooool06Oooo`030000oooooooo07_oool007_oool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`030000
oooooooo07_oool007_oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Coool400001Oooo`030000oooooooo00Soool00`000?ooooooo`1koooo001joooo00<0
003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`09oooo00<0003oooooool0N_oo
o`00Noooo`030000oooooooo00D0000Doooo00<0003oooooool02?ooo`030000oooooooo07_oool0
07_oool01@000?ooooooooooo`00000Goooo00<0003oooooool02?ooo`030000oooooooo07_oool0
07coool00`000?ooooooo`0Goooo0P0000Woool00`000?ooooooo`1loooo003ooooo8Oooo`00oooo
ob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.16408 .04578 L
.17277 .04578 L
.18221 .04578 L
.18475 .04578 L
.18744 .04578 L
.18855 .04578 L
.18974 .04578 L
s
.18974 .04578 m
.19006 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000ooooo`2I00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool0
03koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool0
0`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`1>oooo0P0008ooool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_oo
o`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_oo
o`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_oo
o`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?
oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>
oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000n
oooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0
003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool20000Soooo`00?_ooo`03o`2Ioooooooo
04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool0
03koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool0
0`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`1>oooo0P0008ooool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_oo
o`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_oo
o`030000oooooooo08koool003koool00ol0VOooooooo`0koooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo03[oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0>_ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00?_ooo`03o`2Ioooooooo03[oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool003koool00ol0VOooooooo`0j
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`0koooo0P0000[oool300001?ooo`030000oooooooo08koool003koool00ol0VOoo
ooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>
oooo000noooo00?o09Woooooool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_ooo`030000
oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2I
oooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo
08koool003koool00ol0VOooooooo`1>oooo0P0008ooool003koool00ol0VOooooooo`1>oooo00<0
003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o
09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003ooooo
ool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Wooooo
ool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?oo
ooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOoo
ooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool20000Soooo`00?_oo
o`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000
oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2I
oooooooo04Koool500000oooo`030000oooooooo08koool003koool00ol0VOooooooo`18oooo00<0
003oooooool00oooo`030000oooooooo08koool003koool00ol0VOooooooo`18oooo00<0003ooooo
ool00oooo`<0002>oooo000noooo00?o09Woooooool0B?ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo000noooo00?o09Woooooool0B?ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo000noooo00?o09Woooooool0Aoooo`800005oooo00<0003oooooool0S_ooo`00?_ooo`03o`2I
oooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo
08koool003koool00ol0VOooooooo`1>oooo0P0008ooool003koool00ol0VOooooooo`1>oooo00<0
003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o
09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003ooooo
ool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Wooooo
ool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?oo
ooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOoo
ooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool20000Soooo`00?_oo
o`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000
oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2I
oooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo
08koool003koool00ol0VOooooooo`1>oooo0P0008ooool003koool00ol0VOooooooo`1>oooo00<0
003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o
09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`0joooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo03coool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo
03coool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo000noooo00?o09Wooooo
ool0??ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool003koool00ol0VOoo
ooooo`0loooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000n
oooo00?o09Woooooool0>oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000noooo00?o
09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003ooooo
ool0S_ooo`00?_ooo`03o`2Ioooooooo04koool20000Soooo`00?_ooo`03o`2Ioooooooo04koool0
0`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?oo
ooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOoo
ooooo`1>oooo0P0008ooool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_oo
o`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000
oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2I
oooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?oooo000n
oooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0
003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o
09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003ooooo
ool0S_ooo`00?_ooo`03o`2Ioooooooo04koool20000Soooo`00?_ooo`03o`2Ioooooooo04koool0
0`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04Koool400001?oo
o`030000oooooooo08koool003koool00ol0VOooooooo`16oooo00<0003oooooool01Oooo`030000
oooooooo08koool003koool00ol0VOooooooo`17oooo00<0003oooooool01?ooo`<0002>oooo000n
oooo00?o09Woooooool0B?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo000noooo00?o
09Woooooool0A_ooo`040000oooooooo00001?ooo`030000oooooooo08koool003koool00ol0VOoo
ooooo`17oooo0P0000Goool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000
oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2I
oooooooo04koool20000Soooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000n
oooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0
003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o
09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo0P0008ooool0
03koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool0
0`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?oo
ooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_oo
o`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_oo
o`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000
oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2I
oooooooo04koool20000Soooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000n
oooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0
003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo03[oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo000noooo00?o09Woooooool0>_ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0>oooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000oooo`<00004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000[oool01@000?oo
ooooooooo`000002oooo00D0003oooooooooool00000Moooo`00M?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Coooo00@0003oooooool00009oooo0`0000Goool00`000?ooooooo`02oooo00<0
003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Boooo00@0003oooooool00008oooo00@0
003oooooool00003oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool0
00005Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo00?oool0
0`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0`0000?oool300000_oo
o`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.16408 .04578 L
.18221 .04578 L
.18703 .04578 L
.19227 .04578 L
.19467 .04578 L
.19598 .04578 L
.19721 .04578 L
.19826 .04578 L
s
.19826 .04578 m
.19854 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`050000ooooooooooooo`2I00Coool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo
08koool0043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo
04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0
043oool00ol0VOooooooo`1<oooo0P0008ooool0043oool00ol0VOooooooo`1<oooo00<0003ooooo
ool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Wooooo
ool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_oo
o`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?oo
o`80002?oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOoo
ooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>
oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<
oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool20000Soooo`00@?ooo`03o`2I
oooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo
08koool0043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo
04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0
043oool00ol0VOooooooo`1<oooo0P0008ooool0043oool00ol0VOooooooo`1<oooo00<0003ooooo
ool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Wooooo
ool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`0ioooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo03Soool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0>?oo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00@?ooo`03o`2Ioooooooo
03Soool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool0043oool00ol0VOoo
ooooo`0hoooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
043oool00ol0VOooooooo`0ioooo0P0000[oool300001?ooo`030000oooooooo08koool0043oool0
0ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?oo
ooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`80002?oooo0010oooo00?o09Woooooool0C?oo
o`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?oo
o`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`030000
oooooooo08koool0043oool00ol0VOooooooo`1<oooo0P0008ooool0043oool00ol0VOooooooo`1<
oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010
oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0
003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o
09Woooooool0C?ooo`80002?oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0
043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool0
0`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool0
0ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool20000Sooo
o`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?oo
o`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?oo
o`03o`2Ioooooooo04Coool500000oooo`030000oooooooo08koool0043oool00ol0VOooooooo`16
oooo00<0003oooooool00oooo`030000oooooooo08koool0043oool00ol0VOooooooo`16oooo00<0
003oooooool00oooo`<0002>oooo0010oooo00?o09Woooooool0A_ooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo0010oooo00?o09Woooooool0A_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo0010oooo00?o09Woooooool0AOooo`800005oooo00<0003oooooool0S_ooo`00@?oo
o`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`030000
oooooooo08koool0043oool00ol0VOooooooo`1<oooo0P0008ooool0043oool00ol0VOooooooo`1<
oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010
oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0
003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o
09Woooooool0C?ooo`80002?oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0
043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool0
0`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Boooo`030000oooooooo08koool0047oool0
0ol0VOooooooo`1;oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo04_oool20000Sooo
o`00@Oooo`03o`2Ioooooooo04_oool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Booo
o`030000oooooooo08koool0047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_ooo`00@Ooo
o`03o`2Ioooooooo04_oool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Boooo`030000
oooooooo08koool0047oool00ol0VOooooooo`1;oooo0P0008ooool0047oool00ol0VOooooooo`1;
oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo04_oool00`000?ooooooo`2>oooo0011
oooo00?o09Woooooool0Boooo`030000oooooooo08koool0047oool00ol0VOooooooo`0goooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo03Woool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00@Oooo`03o`2I
oooooooo03Woool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo0011oooo00?o
09Woooooool0>Oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool0047oool0
0ol0VOooooooo`0ioooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo0011oooo00?o09Woooooool0>?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo0011
oooo00?o09Woooooool0Boooo`030000oooooooo08koool0047oool00ol0VOooooooo`1;oooo00<0
003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo04_oool20000Soooo`00@Oooo`03o`2Ioooooooo
04_oool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Boooo`030000oooooooo08koool0
047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo04_oool0
0`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Boooo`030000oooooooo08koool0047oool0
0ol0VOooooooo`1;oooo0P0008ooool0047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_oo
o`00@Oooo`03o`2Ioooooooo04_oool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Booo
o`030000oooooooo08koool0047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_ooo`00@Ooo
o`03o`2Ioooooooo04_oool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Boooo`80002?
oooo0011oooo00?o09Woooooool0Boooo`030000oooooooo08koool0047oool00ol0VOooooooo`1;
oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo04_oool00`000?ooooooo`2>oooo0011
oooo00?o09Woooooool0Boooo`030000oooooooo08koool0047oool00ol0VOooooooo`1;oooo00<0
003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo04_oool20000Soooo`00@Oooo`03o`2Ioooooooo
04_oool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Boooo`030000oooooooo08koool0
047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo04?oool4
00001?ooo`030000oooooooo08koool0047oool00ol0VOooooooo`13oooo00<0003oooooool01Ooo
o`030000oooooooo08koool0047oool00ol0VOooooooo`14oooo00<0003oooooool01?ooo`<0002>
oooo0011oooo00?o09Woooooool0AOooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0011
oooo00?o09Woooooool0@oooo`040000oooooooo00001?ooo`030000oooooooo08koool0047oool0
0ol0VOooooooo`14oooo0P0000Goool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Booo
o`030000oooooooo08koool0047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_ooo`00@Ooo
o`03o`2Ioooooooo04_oool20000Soooo`00@Oooo`03o`2Ioooooooo04_oool00`000?ooooooo`2>
oooo0011oooo00?o09Woooooool0Boooo`030000oooooooo08koool0047oool00ol0VOooooooo`1;
oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo04_oool00`000?ooooooo`2>oooo0011
oooo00?o09Woooooool0Boooo`030000oooooooo08koool0047oool00ol0VOooooooo`1;oooo0P00
08ooool0047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo
04_oool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Boooo`030000oooooooo08koool0
047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo04_oool0
0`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Boooo`80002?oooo0011oooo00?o09Wooooo
ool0Boooo`030000oooooooo08koool0047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_oo
o`00@Oooo`03o`2Ioooooooo04_oool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0Booo
o`030000oooooooo08koool0047oool00ol0VOooooooo`1;oooo00<0003oooooool0S_ooo`00@Ooo
o`03o`2Ioooooooo04_oool20000Soooo`00@Oooo`03o`2Ioooooooo04_oool00`000?ooooooo`2>
oooo0011oooo00?o09Woooooool0Boooo`030000oooooooo08koool0047oool00ol0VOooooooo`1;
oooo00<0003oooooool0S_ooo`00@Oooo`03o`2Ioooooooo03Ooool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0=oooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo0011oooo00?o09Woooooool0>?ooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000ooo
o`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool0000:oooo00<0003ooooo
ool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool04ooo
o`040000oooooooo00002Oooo`<00004oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo
00D0000Boooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`00
00?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0`0000;oool0
0`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.19227 .04578 L
.19721 .04578 L
.20178 .04578 L
.20433 .04578 L
.20562 .04578 L
s
.20562 .04578 m
.2058 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00?oool01?l0VOooooooo`0000Ooool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo01;oool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_oo
o`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_oo
o`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_oo
o`03o`2Ioooooooo04[oool20000Soooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>
oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:
oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012
oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo0P00
08ooool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo
04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool0
04;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?oooo0012oooo00?o09Wooooo
ool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_oo
o`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_oo
o`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_oo
o`03o`2Ioooooooo04[oool20000Soooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>
oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:
oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo03Ooool200001?ooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0=_ooo`040000oooooooo00002?oo
o`040000oooooooo00001?ooo`030000oooooooo08koool004;oool00ol0VOooooooo`0foooo00@0
003oooooool0000;oooo00<0003oooooool00_ooo`<0002>oooo0012oooo00?o09Woooooool0=_oo
o`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo
03Koool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00@_oo
o`03o`2Ioooooooo03Ooool200002_ooo`<00004oooo00<0003oooooool0S_ooo`00@_ooo`03o`2I
oooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo
08koool004;oool00ol0VOooooooo`1:oooo0P0008ooool004;oool00ol0VOooooooo`1:oooo00<0
003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o
09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003ooooo
ool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool20000Soooo`00@_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?oo
ooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOoo
ooooo`1:oooo0P0008ooool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_oo
o`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000
oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2I
oooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?oooo0012
oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0
003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o
09Woooooool0@_ooo`D00003oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04Coool0
0`000?ooooooo`03oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04Coool00`000?oo
ooooo`03oooo0`0008koool004;oool00ol0VOooooooo`14oooo00<0003oooooool00oooo`030000
oooooooo08koool004;oool00ol0VOooooooo`14oooo00<0003oooooool00oooo`030000oooooooo
08koool004;oool00ol0VOooooooo`13oooo0P0000Goool00`000?ooooooo`2>oooo0012oooo00?o
09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003ooooo
ool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool20000Soooo`00@_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?oo
ooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOoo
ooooo`1:oooo0P0008ooool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_oo
o`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000
oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2I
oooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?oooo0012
oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0
003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o
09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003ooooo
ool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool20000Soooo`00@_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo03Koool500000_oo
o`800004oooo0P0000Goool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0>?ooo`030000
oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo0012oooo00?o09Wooooo
ool0>?ooo`030000oooooooo00[oool00`000?ooooooo`02oooo0`0008koool004;oool00ol0VOoo
ooooo`0hoooo00<0003oooooool02?ooo`800005oooo00<0003oooooool0S_ooo`00@_ooo`03o`2I
oooooooo03Soool00`000?ooooooo`08oooo00<0003oooooool01?ooo`030000oooooooo08koool0
04;oool00ol0VOooooooo`0goooo0P0000[oool300001?ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?oo
ooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_oo
o`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_oo
o`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000
oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2I
oooooooo04[oool20000Soooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012
oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0
003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o
09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo0P0008ooool0
04;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?oo
ooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_oo
o`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_oo
o`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0@_ooo`@00004
oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04;oool00`000?ooooooo`05oooo00<0
003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04?oool00`000?ooooooo`04oooo0`0008koool0
04;oool00ol0VOooooooo`14oooo00<0003oooooool00oooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`12oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00@_ooo`03o`2I
oooooooo04?oool200001Oooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0
003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o
09Woooooool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool0
04;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool20000Sooo
o`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_oo
o`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_oo
o`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000
oooooooo08koool004;oool00ol0VOooooooo`1:oooo0P0008ooool004;oool00ol0VOooooooo`1:
oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012
oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0
003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o
09Woooooool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool0
04;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`2>oooo0012oooo00?o09Woooooool0=_ooo`@00003oooo0P0000Coool200001Ooo
o`030000oooooooo08koool004;oool00ol0VOooooooo`0foooo00<0003oooooool02Oooo`040000
oooooooo00001?ooo`030000oooooooo08koool004;oool00ol0VOooooooo`0goooo00<0003ooooo
ool02oooo`030000oooooooo00;oool30000S_ooo`00OOooo`030000oooooooo00Soool20000U_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo09Goool007coool200002_ooo`<0002E
oooo003ooooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_oo
o`00MOooo`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOoo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P00
00Coool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000
oooooooo00000_ooo`040000oooooooo00000oooo`030000oooooooo07Goool007Coool00`000?oo
ooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo00001Ooo
o`030000oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001;oool0
10000?ooooooo`0000Woool200001?ooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000
oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004
oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.20178 .04578 L
.20742 .04578 L
.21019 .04578 L
.2114 .04578 L
.21274 .04578 L
.21394 .04578 L
s
.21394 .04578 m
.21422 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool0
04Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool0
0`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool0
0ol0VOooooooo`17oooo0P0008ooool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_oo
o`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aooo
o`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOoo
o`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`80002?
oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17
oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015
oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0
003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool20000Soooo`00AOooo`03o`2Ioooooooo
04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool0
04Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool0
0`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool0
0ol0VOooooooo`17oooo0P0008ooool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_oo
o`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aooo
o`030000oooooooo08koool004Goool00ol0VOooooooo`0doooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo03?oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0<oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00AOooo`03o`2Ioooooooo03?oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool004Goool00ol0VOooooooo`0c
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004Goool0
0ol0VOooooooo`0doooo0P0000[oool300001?ooo`030000oooooooo08koool004Goool00ol0VOoo
ooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>
oooo0015oooo00?o09Woooooool0Aoooo`80002?oooo0015oooo00?o09Woooooool0Aoooo`030000
oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2I
oooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo
08koool004Goool00ol0VOooooooo`17oooo0P0008ooool004Goool00ol0VOooooooo`17oooo00<0
003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o
09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003ooooo
ool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Wooooo
ool0Aoooo`80002?oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool0
0ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?oo
ooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOoo
ooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool20000Soooo`00AOoo
o`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000
oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2I
oooooooo03ooool500000oooo`030000oooooooo08koool004Goool00ol0VOooooooo`11oooo00<0
003oooooool00oooo`030000oooooooo08koool004Goool00ol0VOooooooo`11oooo00<0003ooooo
ool00oooo`<0002>oooo0015oooo00?o09Woooooool0@Oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo0015oooo00?o09Woooooool0@Oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo0015oooo00?o09Woooooool0@?ooo`800005oooo00<0003oooooool0S_ooo`00AOooo`03o`2I
oooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo
08koool004Goool00ol0VOooooooo`17oooo0P0008ooool004Goool00ol0VOooooooo`17oooo00<0
003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o
09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003ooooo
ool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Wooooo
ool0Aoooo`80002?oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool0
0ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?oo
ooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOoo
ooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool20000Soooo`00AOoo
o`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000
oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2I
oooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo
08koool004Goool00ol0VOooooooo`17oooo0P0008ooool004Goool00ol0VOooooooo`17oooo00<0
003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o
09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`0coooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo03Goool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo
03Goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo0015oooo00?o09Wooooo
ool0=Oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool004Goool00ol0VOoo
ooooo`0eoooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo0015
oooo00?o09Woooooool0=?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo0015oooo00?o
09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003ooooo
ool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool20000Soooo`00AOooo`03o`2Ioooooooo04Ooool0
0`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool0
0ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?oo
ooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOoo
ooooo`17oooo0P0008ooool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOoo
o`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000
oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2I
oooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`80002?oooo0015
oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0
003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o
09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003ooooo
ool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool20000Soooo`00AOooo`03o`2Ioooooooo04Ooool0
0`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool0
0ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo03ooool400001?oo
o`030000oooooooo08koool004Goool00ol0VOooooooo`0ooooo00<0003oooooool01Oooo`030000
oooooooo08koool004Goool00ol0VOooooooo`10oooo00<0003oooooool01?ooo`<0002>oooo0015
oooo00?o09Woooooool0@Oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0015oooo00?o
09Woooooool0?oooo`040000oooooooo00001?ooo`030000oooooooo08koool004Goool00ol0VOoo
ooooo`10oooo0P0000Goool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000
oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2I
oooooooo04Ooool20000Soooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015
oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0
003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o
09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo0P0008ooool0
04Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool0
0`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool0
0ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2Ioooooooo04Ooool00`000?oo
ooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`80002?oooo0015oooo00?o09Woooooool0Aooo
o`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOoo
o`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0Aoooo`030000
oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0003oooooool0S_ooo`00AOooo`03o`2I
oooooooo04Ooool20000Soooo`00AOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`2>oooo0015
oooo00?o09Woooooool0Aoooo`030000oooooooo08koool004Goool00ol0VOooooooo`17oooo00<0
003oooooool0S_ooo`00AOooo`03o`2Ioooooooo03?oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo0015oooo00?o09Woooooool0<oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo0015oooo00?o09Woooooool0=?ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0
003oooooool00008oooo00@0003oooooool00004oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000Boooo00@0003oooooool00009oooo0P0000Coool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000oooo`030000
oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.20178 .04578 L
.20742 .04578 L
.21274 .04578 L
.21753 .04578 L
.21884 .04578 L
.22022 .04578 L
.22141 .04578 L
s
.22141 .04578 m
.22174 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?l0VOooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool0
04Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool0
0`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool0
0ol0VOooooooo`16oooo0P0008ooool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_oo
o`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_oo
o`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_oo
o`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`80002?
oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16
oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016
oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0
003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool20000Soooo`00A_ooo`03o`2Ioooooooo
04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool0
04Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool0
0`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool0
0ol0VOooooooo`16oooo0P0008ooool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_oo
o`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_oo
o`030000oooooooo08koool004Koool00ol0VOooooooo`0coooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo03;oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0<_ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00A_ooo`03o`2Ioooooooo03;oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool004Koool00ol0VOooooooo`0b
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004Koool0
0ol0VOooooooo`0coooo0P0000[oool300001?ooo`030000oooooooo08koool004Koool00ol0VOoo
ooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>
oooo0016oooo00?o09Woooooool0A_ooo`80002?oooo0016oooo00?o09Woooooool0A_ooo`030000
oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2I
oooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo
08koool004Koool00ol0VOooooooo`16oooo0P0008ooool004Koool00ol0VOooooooo`16oooo00<0
003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o
09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0003ooooo
ool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Wooooo
ool0A_ooo`80002?oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool0
0ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?oo
ooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOoo
ooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool20000Soooo`00A_oo
o`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000
oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2I
oooooooo03koool500000oooo`030000oooooooo08koool004Koool00ol0VOooooooo`10oooo00<0
003oooooool00oooo`030000oooooooo08koool004Koool00ol0VOooooooo`10oooo00<0003ooooo
ool00oooo`<0002>oooo0016oooo00?o09Woooooool0@?ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo0016oooo00?o09Woooooool0@?ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo0016oooo00?o09Woooooool0?oooo`800005oooo00<0003oooooool0S_ooo`00A_ooo`03o`2I
oooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo
08koool004Koool00ol0VOooooooo`16oooo0P0008ooool004Koool00ol0VOooooooo`16oooo00<0
003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o
09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0003ooooo
ool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Wooooo
ool0A_ooo`80002?oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool0
0ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?oo
ooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000oooooooo08koool004Ooool00ol0VOoo
ooooo`15oooo00<0003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo04Goool20000Soooo`00Aooo
o`03o`2Ioooooooo04Goool00`000?ooooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000
oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aoooo`03o`2I
oooooooo04Goool00`000?ooooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000oooooooo
08koool004Ooool00ol0VOooooooo`15oooo0P0008ooool004Ooool00ol0VOooooooo`15oooo00<0
003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo04Goool00`000?ooooooo`2>oooo0017oooo00?o
09Woooooool0AOooo`030000oooooooo08koool004Ooool00ol0VOooooooo`0aoooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo03?oool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo
03?oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo0017oooo00?o09Wooooo
ool0<oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool004Ooool00ol0VOoo
ooooo`0coooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo0017
oooo00?o09Woooooool0<_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo0017oooo00?o
09Woooooool0AOooo`030000oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0003ooooo
ool0S_ooo`00Aoooo`03o`2Ioooooooo04Goool20000Soooo`00Aoooo`03o`2Ioooooooo04Goool0
0`000?ooooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000oooooooo08koool004Ooool0
0ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo04Goool00`000?oo
ooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000oooooooo08koool004Ooool00ol0VOoo
ooooo`15oooo0P0008ooool004Ooool00ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aooo
o`03o`2Ioooooooo04Goool00`000?ooooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000
oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aoooo`03o`2I
oooooooo04Goool00`000?ooooooo`2>oooo0017oooo00?o09Woooooool0AOooo`80002?oooo0017
oooo00?o09Woooooool0AOooo`030000oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0
003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo04Goool00`000?ooooooo`2>oooo0017oooo00?o
09Woooooool0AOooo`030000oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0003ooooo
ool0S_ooo`00Aoooo`03o`2Ioooooooo04Goool20000Soooo`00Aoooo`03o`2Ioooooooo04Goool0
0`000?ooooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000oooooooo08koool004Ooool0
0ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo03goool400001?oo
o`030000oooooooo08koool004Ooool00ol0VOooooooo`0moooo00<0003oooooool01Oooo`030000
oooooooo08koool004Ooool00ol0VOooooooo`0noooo00<0003oooooool01?ooo`<0002>oooo0017
oooo00?o09Woooooool0?oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0017oooo00?o
09Woooooool0?Oooo`040000oooooooo00001?ooo`030000oooooooo08koool004Ooool00ol0VOoo
ooooo`0noooo0P0000Goool00`000?ooooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000
oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aoooo`03o`2I
oooooooo04Goool20000Soooo`00Aoooo`03o`2Ioooooooo04Goool00`000?ooooooo`2>oooo0017
oooo00?o09Woooooool0AOooo`030000oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0
003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo04Goool00`000?ooooooo`2>oooo0017oooo00?o
09Woooooool0AOooo`030000oooooooo08koool004Ooool00ol0VOooooooo`15oooo0P0008ooool0
04Ooool00ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo04Goool0
0`000?ooooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000oooooooo08koool004Ooool0
0ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo04Goool00`000?oo
ooooo`2>oooo0017oooo00?o09Woooooool0AOooo`80002?oooo0017oooo00?o09Woooooool0AOoo
o`030000oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aooo
o`03o`2Ioooooooo04Goool00`000?ooooooo`2>oooo0017oooo00?o09Woooooool0AOooo`030000
oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0003oooooool0S_ooo`00Aoooo`03o`2I
oooooooo04Goool20000Soooo`00Aoooo`03o`2Ioooooooo04Goool00`000?ooooooo`2>oooo0017
oooo00?o09Woooooool0AOooo`030000oooooooo08koool004Ooool00ol0VOooooooo`15oooo00<0
003oooooool0S_ooo`00Aoooo`03o`2Ioooooooo037oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo0017oooo00?o09Woooooool0<Oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo0017oooo00?o09Woooooool0<_ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001Oooo`030000
oooooooo00;oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002_oo
o`050000oooooooooooo000000;oool01@000?ooooooooooo`00001goooo001doooo00<0003ooooo
ool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0
003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500004_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`800009oooo1000
00?oool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.20342 .04578 L
.21345 .04578 L
.22272 .04578 L
.22738 .04578 L
.22852 .04578 L
.22974 .04578 L
s
.22974 .04578 m
.22991 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool01@000?ooooooooooool0V@03
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo0019oooo00?o09Woooooool0@oooo`030000oooooooo
08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo
04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool0
04Woool00ol0VOooooooo`13oooo0P0008ooool004Woool00ol0VOooooooo`13oooo00<0003ooooo
ool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Wooooo
ool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_oo
o`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@ooo
o`80002?oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOoo
ooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>
oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13
oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool20000Soooo`00BOooo`03o`2I
oooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo
08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo
04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool0
04Woool00ol0VOooooooo`13oooo0P0008ooool004Woool00ol0VOooooooo`13oooo00<0003ooooo
ool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Wooooo
ool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`0`oooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo02ooool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0;ooo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00BOooo`03o`2Ioooooooo
02ooool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool004Woool00ol0VOoo
ooooo`0_oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
04Woool00ol0VOooooooo`0`oooo0P0000[oool300001?ooo`030000oooooooo08koool004Woool0
0ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?oo
ooooo`2>oooo0019oooo00?o09Woooooool0@oooo`80002?oooo0019oooo00?o09Woooooool0@ooo
o`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOoo
o`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000
oooooooo08koool004Woool00ol0VOooooooo`13oooo0P0008ooool004Woool00ol0VOooooooo`13
oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019
oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0
003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o
09Woooooool0@oooo`80002?oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool0
04Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool0
0`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool0
0ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool20000Sooo
o`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@ooo
o`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOoo
o`03o`2Ioooooooo03_oool500000oooo`030000oooooooo08koool004Woool00ol0VOooooooo`0m
oooo00<0003oooooool00oooo`030000oooooooo08koool004Woool00ol0VOooooooo`0moooo00<0
003oooooool00oooo`<0002>oooo0019oooo00?o09Woooooool0?Oooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo0019oooo00?o09Woooooool0?Oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo0019oooo00?o09Woooooool0??ooo`800005oooo00<0003oooooool0S_ooo`00BOoo
o`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000
oooooooo08koool004Woool00ol0VOooooooo`13oooo0P0008ooool004Woool00ol0VOooooooo`13
oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019
oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0
003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o
09Woooooool0@oooo`80002?oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool0
04Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool0
0`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool0
0ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool20000Sooo
o`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@ooo
o`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOoo
o`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000
oooooooo08koool004Woool00ol0VOooooooo`13oooo0P0008ooool004Woool00ol0VOooooooo`13
oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019
oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`0_oooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo037oool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00BOooo`03o`2I
oooooooo037oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo0019oooo00?o
09Woooooool0<Oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool004Woool0
0ol0VOooooooo`0aoooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo0019oooo00?o09Woooooool0<?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo0019
oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0
003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool20000Soooo`00BOooo`03o`2Ioooooooo
04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool0
04Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool0
0`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool0
0ol0VOooooooo`13oooo0P0008ooool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_oo
o`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@ooo
o`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOoo
o`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`80002?
oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13
oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019
oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0
003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool20000Soooo`00BOooo`03o`2Ioooooooo
04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool0
04Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo03_oool4
00001?ooo`030000oooooooo08koool004Woool00ol0VOooooooo`0koooo00<0003oooooool01Ooo
o`030000oooooooo08koool004Woool00ol0VOooooooo`0loooo00<0003oooooool01?ooo`<0002>
oooo0019oooo00?o09Woooooool0?Oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0019
oooo00?o09Woooooool0>oooo`040000oooooooo00001?ooo`030000oooooooo08koool004Woool0
0ol0VOooooooo`0loooo0P0000Goool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@ooo
o`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOoo
o`03o`2Ioooooooo04?oool20000Soooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>
oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13
oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019
oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo0P00
08ooool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo
04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool0
04Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo04?oool0
0`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@oooo`80002?oooo0019oooo00?o09Wooooo
ool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_oo
o`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0@ooo
o`030000oooooooo08koool004Woool00ol0VOooooooo`13oooo00<0003oooooool0S_ooo`00BOoo
o`03o`2Ioooooooo04?oool20000Soooo`00BOooo`03o`2Ioooooooo04?oool00`000?ooooooo`2>
oooo0019oooo00?o09Woooooool0@oooo`030000oooooooo08koool004Woool00ol0VOooooooo`13
oooo00<0003oooooool0S_ooo`00BOooo`03o`2Ioooooooo02ooool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0;oooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo0019oooo00?o09Woooooool0<?ooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001Ooo
o`030000oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000[oool0
0`000?ooooooo`02oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?oo
ooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool00oooo`030000oooooooo07Ooool0
07Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002oooo`050000oooooooooooo0000
07[oool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002Oooo`@00002
oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.20342 .04578 L
.22272 .04578 L
.23233 .04578 L
.23496 .04578 L
.2364 .04578 L
.23711 .04578 L
.23775 .04578 L
s
.23775 .04578 m
.23804 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`03oooo00?o
09Woool000001oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool0
04_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool0
0`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool0
0ol0VOooooooo`11oooo0P0008ooool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_oo
o`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Ooo
o`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Booo
o`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`80002?
oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11
oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;
oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0
003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool20000Soooo`00Boooo`03o`2Ioooooooo
047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool0
04_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool0
0`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool0
0ol0VOooooooo`11oooo0P0008ooool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_oo
o`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Ooo
o`030000oooooooo08koool004_oool00ol0VOooooooo`0^oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo02goool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0;Oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00Boooo`03o`2Ioooooooo02goool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`0]
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004_oool0
0ol0VOooooooo`0^oooo0P0000[oool300001?ooo`030000oooooooo08koool004_oool00ol0VOoo
ooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>
oooo001;oooo00?o09Woooooool0@Oooo`80002?oooo001;oooo00?o09Woooooool0@Oooo`030000
oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2I
oooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo
08koool004_oool00ol0VOooooooo`11oooo0P0008ooool004_oool00ol0VOooooooo`11oooo00<0
003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o
09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003ooooo
ool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Wooooo
ool0@Oooo`80002?oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool0
0ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?oo
ooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOoo
ooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool20000Soooo`00Booo
o`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000
oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2I
oooooooo03Woool500000oooo`030000oooooooo08koool004_oool00ol0VOooooooo`0koooo00<0
003oooooool00oooo`030000oooooooo08koool004_oool00ol0VOooooooo`0koooo00<0003ooooo
ool00oooo`<0002>oooo001;oooo00?o09Woooooool0>oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001;oooo00?o09Woooooool0>oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001;oooo00?o09Woooooool0>_ooo`800005oooo00<0003oooooool0S_ooo`00Boooo`03o`2I
oooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo
08koool004_oool00ol0VOooooooo`11oooo0P0008ooool004_oool00ol0VOooooooo`11oooo00<0
003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o
09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003ooooo
ool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Wooooo
ool0@Oooo`80002?oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool0
0ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?oo
ooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOoo
ooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool20000Soooo`00Booo
o`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000
oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2I
oooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo
08koool004_oool00ol0VOooooooo`11oooo0P0008ooool004_oool00ol0VOooooooo`11oooo00<0
003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o
09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`0]oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo02ooool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo
02ooool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001;oooo00?o09Wooooo
ool0;oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool004_oool00ol0VOoo
ooooo`0_oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001;
oooo00?o09Woooooool0;_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001;oooo00?o
09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003ooooo
ool0S_ooo`00Boooo`03o`2Ioooooooo047oool20000Soooo`00Boooo`03o`2Ioooooooo047oool0
0`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool0
0ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?oo
ooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOoo
ooooo`11oooo0P0008ooool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Booo
o`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000
oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2I
oooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`80002?oooo001;
oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0
003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o
09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003ooooo
ool0S_ooo`00Boooo`03o`2Ioooooooo047oool20000Soooo`00Boooo`03o`2Ioooooooo047oool0
0`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool0
0ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo03Woool400001?oo
o`030000oooooooo08koool004_oool00ol0VOooooooo`0ioooo00<0003oooooool01Oooo`030000
oooooooo08koool004_oool00ol0VOooooooo`0joooo00<0003oooooool01?ooo`<0002>oooo001;
oooo00?o09Woooooool0>oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001;oooo00?o
09Woooooool0>Oooo`040000oooooooo00001?ooo`030000oooooooo08koool004_oool00ol0VOoo
ooooo`0joooo0P0000Goool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000
oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2I
oooooooo047oool20000Soooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;
oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0
003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o
09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo0P0008ooool0
04_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool0
0`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool0
0ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2Ioooooooo047oool00`000?oo
ooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`80002?oooo001;oooo00?o09Woooooool0@Ooo
o`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Booo
o`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0@Oooo`030000
oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0003oooooool0S_ooo`00Boooo`03o`2I
oooooooo047oool20000Soooo`00Boooo`03o`2Ioooooooo047oool00`000?ooooooo`2>oooo001;
oooo00?o09Woooooool0@Oooo`030000oooooooo08koool004_oool00ol0VOooooooo`11oooo00<0
003oooooool0S_ooo`00Boooo`03o`2Ioooooooo02goool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001;oooo00?o09Woooooool0;Oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001;oooo00?o09Woooooool0;_ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000oooo`<00004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003ooooo
ool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Soool010000?ooooooo`0000Goool0
0`000?ooooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Boooo00@0
003oooooool00008oooo0`0000Coool200001?ooo`030000oooooooo07Goool007Goool01@000?oo
ooooooooo`00000Eoooo00@0003oooooool00009oooo00<0003oooooool00oooo`030000oooooooo
00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0`0000?oool3
00000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.20342 .04578 L
.22272 .04578 L
.23233 .04578 L
.23739 .04578 L
.24016 .04578 L
.24276 .04578 L
.24392 .04578 L
.24502 .04578 L
s
.24502 .04578 m
.24534 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool0
04goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool0
0`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool0
0ol0VOooooooo`0ooooo0P0008ooool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_oo
o`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?ooo
o`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COoo
o`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`80002?
oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0o
oooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=
oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0
003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool20000Soooo`00COooo`03o`2Ioooooooo
03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool0
04goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool0
0`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool0
0ol0VOooooooo`0ooooo0P0008ooool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_oo
o`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?ooo
o`030000oooooooo08koool004goool00ol0VOooooooo`0/oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo02_oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0:oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00COooo`03o`2Ioooooooo02_oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool004goool00ol0VOooooooo`0[
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004goool0
0ol0VOooooooo`0/oooo0P0000[oool300001?ooo`030000oooooooo08koool004goool00ol0VOoo
ooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>
oooo001=oooo00?o09Woooooool0?oooo`80002?oooo001=oooo00?o09Woooooool0?oooo`030000
oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2I
oooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo
08koool004goool00ol0VOooooooo`0ooooo0P0008ooool004goool00ol0VOooooooo`0ooooo00<0
003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o
09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003ooooo
ool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Wooooo
ool0?oooo`80002?oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool0
0ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?oo
ooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOoo
ooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool20000Soooo`00COoo
o`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000
oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2I
oooooooo03Ooool500000oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ioooo00<0
003oooooool00oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ioooo00<0003ooooo
ool00oooo`<0002>oooo001=oooo00?o09Woooooool0>Oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001=oooo00?o09Woooooool0>Oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001=oooo00?o09Woooooool0>?ooo`800005oooo00<0003oooooool0S_ooo`00COooo`03o`2I
oooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo
08koool004goool00ol0VOooooooo`0ooooo0P0008ooool004goool00ol0VOooooooo`0ooooo00<0
003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o
09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003ooooo
ool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Wooooo
ool0?oooo`80002?oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool0
0ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?oo
ooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOoo
ooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool20000Soooo`00COoo
o`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000
oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2I
oooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo
08koool004goool00ol0VOooooooo`0ooooo0P0008ooool004goool00ol0VOooooooo`0ooooo00<0
003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o
09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0[oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo02goool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo
02goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001=oooo00?o09Wooooo
ool0;Oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool004goool00ol0VOoo
ooooo`0]oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001=
oooo00?o09Woooooool0;?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001=oooo00?o
09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003ooooo
ool0S_ooo`00COooo`03o`2Ioooooooo03ooool20000Soooo`00COooo`03o`2Ioooooooo03ooool0
0`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool0
0ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?oo
ooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOoo
ooooo`0ooooo0P0008ooool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COoo
o`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000
oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2I
oooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`80002?oooo001=
oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0
003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o
09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003ooooo
ool0S_ooo`00COooo`03o`2Ioooooooo03ooool20000Soooo`00COooo`03o`2Ioooooooo03ooool0
0`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool0
0ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03Ooool400001?oo
o`030000oooooooo08koool004goool00ol0VOooooooo`0goooo00<0003oooooool01Oooo`030000
oooooooo08koool004goool00ol0VOooooooo`0hoooo00<0003oooooool01?ooo`<0002>oooo001=
oooo00?o09Woooooool0>Oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001=oooo00?o
09Woooooool0=oooo`040000oooooooo00001?ooo`030000oooooooo08koool004goool00ol0VOoo
ooooo`0hoooo0P0000Goool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000
oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2I
oooooooo03ooool20000Soooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=
oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0
003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o
09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo0P0008ooool0
04goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool0
0`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool0
0ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?oo
ooooo`2>oooo001=oooo00?o09Woooooool0?oooo`80002?oooo001=oooo00?o09Woooooool0?ooo
o`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COoo
o`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000
oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2I
oooooooo03ooool20000Soooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=
oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0
003oooooool0S_ooo`00COooo`03o`2Ioooooooo02_oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001=oooo00?o09Woooooool0:oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0;?ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000oooo`<00004
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0
003oooooool00008oooo00@0003oooooool00004oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000Boooo00@0003oooooool00008oooo0`0000Coool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000005Oooo`040000oooooooo00002Oooo`030000oooooooo00?oool0
0`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0`0000;oool00`000?oo
ooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.20342 .04578 L
.22272 .04578 L
.23233 .04578 L
.24276 .04578 L
.24754 .04578 L
.25016 .04578 L
.25144 .04578 L
.25261 .04578 L
.25368 .04578 L
s
.25368 .04578 m
.25394 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003ooooo09T01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool0
04ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool0
0`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool0
0ol0VOooooooo`0moooo0P0008ooool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_oo
o`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Ooo
o`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Cooo
o`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`80002?
oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0m
oooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?
oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0
003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool20000Soooo`00Coooo`03o`2Ioooooooo
03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool0
04ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool0
0`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool0
0ol0VOooooooo`0moooo0P0008ooool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_oo
o`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Ooo
o`030000oooooooo08koool004ooool00ol0VOooooooo`0Zoooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo02Woool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0:Oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00Coooo`03o`2Ioooooooo02Woool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0Y
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004ooool0
0ol0VOooooooo`0Zoooo0P0000[oool300001?ooo`030000oooooooo08koool004ooool00ol0VOoo
ooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>
oooo001?oooo00?o09Woooooool0?Oooo`80002?oooo001?oooo00?o09Woooooool0?Oooo`030000
oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2I
oooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo
08koool004ooool00ol0VOooooooo`0moooo0P0008ooool004ooool00ol0VOooooooo`0moooo00<0
003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o
09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003ooooo
ool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Wooooo
ool0?Oooo`80002?oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool0
0ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?oo
ooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOoo
ooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool20000Soooo`00Cooo
o`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000
oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2I
oooooooo03Goool500000oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0goooo00<0
003oooooool00oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0goooo00<0003ooooo
ool00oooo`<0002>oooo001?oooo00?o09Woooooool0=oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001?oooo00?o09Woooooool0=oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001?oooo00?o09Woooooool0=_ooo`800005oooo00<0003oooooool0S_ooo`00Coooo`03o`2I
oooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo
08koool004ooool00ol0VOooooooo`0moooo0P0008ooool004ooool00ol0VOooooooo`0moooo00<0
003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o
09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003ooooo
ool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Wooooo
ool0?Oooo`80002?oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool0
0ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?oo
ooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOoo
ooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool20000Soooo`00Cooo
o`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000
oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2I
oooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo
08koool004ooool00ol0VOooooooo`0moooo0P0008ooool004ooool00ol0VOooooooo`0moooo00<0
003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o
09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0Yoooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo02_oool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo
02_oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001?oooo00?o09Wooooo
ool0:oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool004ooool00ol0VOoo
ooooo`0[oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001?
oooo00?o09Woooooool0:_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001?oooo00?o
09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003ooooo
ool0S_ooo`00Coooo`03o`2Ioooooooo03goool20000Soooo`00Coooo`03o`2Ioooooooo03goool0
0`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool0
0ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?oo
ooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOoo
ooooo`0moooo0P0008ooool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Cooo
o`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000
oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2I
oooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`80002?oooo001?
oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0
003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o
09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003ooooo
ool0S_ooo`00Coooo`03o`2Ioooooooo03goool20000Soooo`00Coooo`03o`2Ioooooooo03goool0
0`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool0
0ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03Goool400001?oo
o`030000oooooooo08koool004ooool00ol0VOooooooo`0eoooo00<0003oooooool01Oooo`030000
oooooooo08koool004ooool00ol0VOooooooo`0foooo00<0003oooooool01?ooo`<0002>oooo001?
oooo00?o09Woooooool0=oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001?oooo00?o
09Woooooool0=Oooo`040000oooooooo00001?ooo`030000oooooooo08koool004ooool00ol0VOoo
ooooo`0foooo0P0000Goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000
oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2I
oooooooo03goool20000Soooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?
oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0
003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o
09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo0P0008ooool0
04ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool0
0`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool0
0ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2Ioooooooo03goool00`000?oo
ooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`80002?oooo001?oooo00?o09Woooooool0?Ooo
o`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Cooo
o`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0?Oooo`030000
oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0003oooooool0S_ooo`00Coooo`03o`2I
oooooooo03goool20000Soooo`00Coooo`03o`2Ioooooooo03goool00`000?ooooooo`2>oooo001?
oooo00?o09Woooooool0?Oooo`030000oooooooo08koool004ooool00ol0VOooooooo`0moooo00<0
003oooooool0S_ooo`00Coooo`03o`2Ioooooooo02Woool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001?oooo00?o09Woooooool0:Oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001?oooo00?o09Woooooool0:_ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003ooooo
ool00_ooo`030000oooooooo01?oool010000?ooooooo`0000_oool00`000?ooooooo`03oooo00<0
003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500004_ooo`040000
oooooooo00002Oooo`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000005Oooo`040000oooooooo00002Oooo`030000oooooooo00?oool00`000?ooooooo`03
oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`<00003oooo0`00
00;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.24141 .04578 L
.25127 .04578 L
.25666 .04578 L
.2593 .04578 L
.26045 .04578 L
.26171 .04578 L
s
.26171 .04578 m
.26204 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00D0
003ooooooooooooo09T00oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo
08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo
03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0
057oool00ol0VOooooooo`0koooo0P0008ooool0057oool00ol0VOooooooo`0koooo00<0003ooooo
ool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Wooooo
ool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_oo
o`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>ooo
o`80002?oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOoo
ooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>
oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0k
oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool20000Soooo`00DOooo`03o`2I
oooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo
08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo
03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0
057oool00ol0VOooooooo`0koooo0P0008ooool0057oool00ol0VOooooooo`0koooo00<0003ooooo
ool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Wooooo
ool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0Xoooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo02Ooool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool09ooo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00DOooo`03o`2Ioooooooo
02Ooool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool0057oool00ol0VOoo
ooooo`0Woooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
057oool00ol0VOooooooo`0Xoooo0P0000[oool300001?ooo`030000oooooooo08koool0057oool0
0ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?oo
ooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`80002?oooo001Aoooo00?o09Woooooool0>ooo
o`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOoo
o`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000
oooooooo08koool0057oool00ol0VOooooooo`0koooo0P0008ooool0057oool00ol0VOooooooo`0k
oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0
003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o
09Woooooool0>oooo`80002?oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0
057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool0
0`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool0
0ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool20000Sooo
o`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>ooo
o`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOoo
o`03o`2Ioooooooo03?oool500000oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0e
oooo00<0003oooooool00oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0eoooo00<0
003oooooool00oooo`<0002>oooo001Aoooo00?o09Woooooool0=Oooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0=Oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Aoooo00?o09Woooooool0=?ooo`800005oooo00<0003oooooool0S_ooo`00DOoo
o`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000
oooooooo08koool0057oool00ol0VOooooooo`0koooo0P0008ooool0057oool00ol0VOooooooo`0k
oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0
003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o
09Woooooool0>oooo`80002?oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0
057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool0
0`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool0
0ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool20000Sooo
o`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>ooo
o`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOoo
o`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000
oooooooo08koool0057oool00ol0VOooooooo`0koooo0P0008ooool0057oool00ol0VOooooooo`0k
oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0Woooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo02Woool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00DOooo`03o`2I
oooooooo02Woool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Aoooo00?o
09Woooooool0:Oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool0057oool0
0ol0VOooooooo`0Yoooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo001Aoooo00?o09Woooooool0:?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0
003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo
03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0
057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool0
0`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool0
0ol0VOooooooo`0koooo0P0008ooool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_oo
o`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>ooo
o`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOoo
o`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`80002?
oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0k
oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0
003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo
03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0
057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03?oool4
00001?ooo`030000oooooooo08koool0057oool00ol0VOooooooo`0coooo00<0003oooooool01Ooo
o`030000oooooooo08koool0057oool00ol0VOooooooo`0doooo00<0003oooooool01?ooo`<0002>
oooo001Aoooo00?o09Woooooool0=Oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0<oooo`040000oooooooo00001?ooo`030000oooooooo08koool0057oool0
0ol0VOooooooo`0doooo0P0000Goool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>ooo
o`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOoo
o`03o`2Ioooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>
oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0k
oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo0P00
08ooool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo
03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0
057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool0
0`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`80002?oooo001Aoooo00?o09Wooooo
ool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_oo
o`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>ooo
o`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOoo
o`03o`2Ioooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>
oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0k
oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo02Ooool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool09oooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0:?ooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?oo
o`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`030000oooooooo07Ooool007Soool0
0`000?ooooooo`0500004_ooo`040000oooooooo00002Oooo`800004oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooooooo`03
oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`<00002oooo00<0
003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.24141 .04578 L
.25127 .04578 L
.26171 .04578 L
.26425 .04578 L
.26698 .04578 L
.26778 .04578 L
.26855 .04578 L
.26923 .04578 L
s
.26923 .04578 m
.26942 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool00oooo`03o`2Ioooo000000Ooool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool0
05?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool0
0`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo0P0008ooool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_oo
o`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Ooo
o`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Dooo
o`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`80002?
oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0i
oooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001C
oooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0
003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo
03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool0
05?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool0
0`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo0P0008ooool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_oo
o`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Ooo
o`030000oooooooo08koool005?oool00ol0VOooooooo`0Voooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo02Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool09Oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00Doooo`03o`2Ioooooooo02Goool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0U
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0Voooo0P0000[oool300001?ooo`030000oooooooo08koool005?oool00ol0VOoo
ooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>
oooo001Coooo00?o09Woooooool0>Oooo`80002?oooo001Coooo00?o09Woooooool0>Oooo`030000
oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2I
oooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo
08koool005?oool00ol0VOooooooo`0ioooo0P0008ooool005?oool00ol0VOooooooo`0ioooo00<0
003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003ooooo
ool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Wooooo
ool0>Oooo`80002?oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?oo
ooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOoo
ooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Soooo`00Dooo
o`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000
oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2I
oooooooo037oool500000oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0coooo00<0
003oooooool00oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0coooo00<0003ooooo
ool00oooo`<0002>oooo001Coooo00?o09Woooooool0<oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Coooo00?o09Woooooool0<oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001Coooo00?o09Woooooool0<_ooo`800005oooo00<0003oooooool0S_ooo`00Doooo`03o`2I
oooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo
08koool005?oool00ol0VOooooooo`0ioooo0P0008ooool005?oool00ol0VOooooooo`0ioooo00<0
003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003ooooo
ool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Wooooo
ool0>Oooo`80002?oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?oo
ooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOoo
ooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Soooo`00Dooo
o`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000
oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2I
oooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo
08koool005?oool00ol0VOooooooo`0ioooo0P0008ooool005?oool00ol0VOooooooo`0ioooo00<0
003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0Uoooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo02Ooool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo
02Ooool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Coooo00?o09Wooooo
ool09oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool005?oool00ol0VOoo
ooooo`0Woooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001C
oooo00?o09Woooooool09_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003ooooo
ool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool0
0`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?oo
ooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOoo
ooooo`0ioooo0P0008ooool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Dooo
o`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000
oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2I
oooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`80002?oooo001C
oooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0
003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003ooooo
ool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool0
0`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo037oool400001?oo
o`030000oooooooo08koool005?oool00ol0VOooooooo`0aoooo00<0003oooooool01Oooo`030000
oooooooo08koool005?oool00ol0VOooooooo`0boooo00<0003oooooool01?ooo`<0002>oooo001C
oooo00?o09Woooooool0<oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool0<Oooo`040000oooooooo00001?ooo`030000oooooooo08koool005?oool00ol0VOoo
ooooo`0boooo0P0000Goool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000
oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2I
oooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001C
oooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0
003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo0P0008ooool0
05?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool0
0`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?oo
ooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`80002?oooo001Coooo00?o09Woooooool0>Ooo
o`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Dooo
o`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000
oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2I
oooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001C
oooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0
003oooooool0S_ooo`00Doooo`03o`2Ioooooooo02Goool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001Coooo00?o09Woooooool09Oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool09_ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001Oooo`<00002
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000_oool010000?oo
ooooo`0000;oool01@000?ooooooooooo`00001goooo001doooo00<0003oooooool00_ooo`030000
oooooooo01?oool010000?ooooooo`0000Soool500001?ooo`030000oooooooo00;oool00`000?oo
ooooo`1doooo001eoooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`00000E
oooo00@0003oooooool00009oooo00<0003oool000000oooo`030000oooooooo00?oool00`000?oo
ooooo`1eoooo001foooo00<0003oooooool05oooo`80000;oooo0P0000?oool300000_ooo`030000
oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.24141 .04578 L
.26171 .04578 L
.26709 .04578 L
.27279 .04578 L
.27513 .04578 L
.27643 .04578 L
.27765 .04578 L
s
.27765 .04578 m
.27783 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool0
05Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool0
0`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool0
0ol0VOooooooo`0goooo0P0008ooool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_oo
o`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=ooo
o`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOoo
o`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`80002?
oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0g
oooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001E
oooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0
003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool20000Soooo`00EOooo`03o`2Ioooooooo
03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool0
05Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool0
0`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool0
0ol0VOooooooo`0goooo0P0008ooool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_oo
o`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=ooo
o`030000oooooooo08koool005Goool00ol0VOooooooo`0Toooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo02?oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool08oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00EOooo`03o`2Ioooooooo02?oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0S
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool005Goool0
0ol0VOooooooo`0Toooo0P0000[oool300001?ooo`030000oooooooo08koool005Goool00ol0VOoo
ooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>
oooo001Eoooo00?o09Woooooool0=oooo`80002?oooo001Eoooo00?o09Woooooool0=oooo`030000
oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2I
oooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo
08koool005Goool00ol0VOooooooo`0goooo0P0008ooool005Goool00ol0VOooooooo`0goooo00<0
003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o
09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003ooooo
ool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Wooooo
ool0=oooo`80002?oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool0
0ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?oo
ooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOoo
ooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool20000Soooo`00EOoo
o`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000
oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2I
oooooooo02ooool500000oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0aoooo00<0
003oooooool00oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0aoooo00<0003ooooo
ool00oooo`<0002>oooo001Eoooo00?o09Woooooool0<Oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Eoooo00?o09Woooooool0<Oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001Eoooo00?o09Woooooool0<?ooo`800005oooo00<0003oooooool0S_ooo`00EOooo`03o`2I
oooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo
08koool005Goool00ol0VOooooooo`0goooo0P0008ooool005Goool00ol0VOooooooo`0goooo00<0
003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o
09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003ooooo
ool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Wooooo
ool0=oooo`80002?oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool0
0ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?oo
ooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOoo
ooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool20000Soooo`00EOoo
o`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000
oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2I
oooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo
08koool005Goool00ol0VOooooooo`0goooo0P0008ooool005Goool00ol0VOooooooo`0goooo00<0
003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o
09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0Soooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo02Goool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo
02Goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Eoooo00?o09Wooooo
ool09Oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool005Goool00ol0VOoo
ooooo`0Uoooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001E
oooo00?o09Woooooool09?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Eoooo00?o
09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003ooooo
ool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool20000Soooo`00EOooo`03o`2Ioooooooo03Ooool0
0`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool0
0ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?oo
ooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOoo
ooooo`0goooo0P0008ooool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOoo
o`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000
oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2I
oooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`80002?oooo001E
oooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0
003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o
09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003ooooo
ool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool20000Soooo`00EOooo`03o`2Ioooooooo03Ooool0
0`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool0
0ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo02ooool400001?oo
o`030000oooooooo08koool005Goool00ol0VOooooooo`0_oooo00<0003oooooool01Oooo`030000
oooooooo08koool005Goool00ol0VOooooooo`0`oooo00<0003oooooool01?ooo`<0002>oooo001E
oooo00?o09Woooooool0<Oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001Eoooo00?o
09Woooooool0;oooo`040000oooooooo00001?ooo`030000oooooooo08koool005Goool00ol0VOoo
ooooo`0`oooo0P0000Goool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000
oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2I
oooooooo03Ooool20000Soooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001E
oooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0
003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o
09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo0P0008ooool0
05Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool0
0`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool0
0ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2Ioooooooo03Ooool00`000?oo
ooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`80002?oooo001Eoooo00?o09Woooooool0=ooo
o`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOoo
o`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool0=oooo`030000
oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0003oooooool0S_ooo`00EOooo`03o`2I
oooooooo03Ooool20000Soooo`00EOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`2>oooo001E
oooo00?o09Woooooool0=oooo`030000oooooooo08koool005Goool00ol0VOooooooo`0goooo00<0
003oooooool0S_ooo`00EOooo`03o`2Ioooooooo02?oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001Eoooo00?o09Woooooool08oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Eoooo00?o09Woooooool09?ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001Oooo`<00002
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool0000;oooo00D0003oooooooooool0
0000N_ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0003oooooool00008
oooo1@0000?oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000005Oooo`040000oooooooo00002Oooo`030000oooo000000?oool00`000?ooooooo`1h
oooo001ioooo00<0003oooooool05oooo`80000;oooo0P0000;oool00`000?ooooooo`1ioooo003o
oooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.27193 .04578 L
.27731 .04578 L
.28025 .04578 L
.28302 .04578 L
.28425 .04578 L
.28542 .04578 L
s
.28542 .04578 m
.28558 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000ooooo`2I00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool0
05Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool0
0`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool0
0ol0VOooooooo`0eoooo0P0008ooool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_oo
o`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Ooo
o`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eooo
o`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`80002?
oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0e
oooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001G
oooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo
03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool0
05Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool0
0`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool0
0ol0VOooooooo`0eoooo0P0008ooool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_oo
o`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Ooo
o`030000oooooooo08koool005Ooool00ol0VOooooooo`0Roooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo027oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool08Oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00Eoooo`03o`2Ioooooooo027oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0Q
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool005Ooool0
0ol0VOooooooo`0Roooo0P0000[oool300001?ooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>
oooo001Goooo00?o09Woooooool0=Oooo`80002?oooo001Goooo00?o09Woooooool0=Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo
08koool005Ooool00ol0VOooooooo`0eoooo0P0008ooool005Ooool00ol0VOooooooo`0eoooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o
09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003ooooo
ool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Wooooo
ool0=Oooo`80002?oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool0
0ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?oo
ooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eooo
o`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo02goool500000oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0_oooo00<0
003oooooool00oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0_oooo00<0003ooooo
ool00oooo`<0002>oooo001Goooo00?o09Woooooool0;oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Goooo00?o09Woooooool0;oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001Goooo00?o09Woooooool0;_ooo`800005oooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo
08koool005Ooool00ol0VOooooooo`0eoooo0P0008ooool005Ooool00ol0VOooooooo`0eoooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o
09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003ooooo
ool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Wooooo
ool0=Oooo`80002?oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool0
0ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?oo
ooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eooo
o`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo
08koool005Ooool00ol0VOooooooo`0eoooo0P0008ooool005Ooool00ol0VOooooooo`0eoooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o
09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0Qoooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo02?oool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo
02?oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Goooo00?o09Wooooo
ool08oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0Soooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001G
oooo00?o09Woooooool08_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Goooo00?o
09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003ooooo
ool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo03Goool0
0`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool0
0ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?oo
ooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0eoooo0P0008ooool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eooo
o`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`80002?oooo001G
oooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o
09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003ooooo
ool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo03Goool0
0`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool0
0ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo02goool400001?oo
o`030000oooooooo08koool005Ooool00ol0VOooooooo`0]oooo00<0003oooooool01Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0^oooo00<0003oooooool01?ooo`<0002>oooo001G
oooo00?o09Woooooool0;oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001Goooo00?o
09Woooooool0;Oooo`040000oooooooo00001?ooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0^oooo0P0000Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001G
oooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o
09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo0P0008ooool0
05Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool0
0`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool0
0ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?oo
ooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`80002?oooo001Goooo00?o09Woooooool0=Ooo
o`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eooo
o`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001G
oooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo027oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001Goooo00?o09Woooooool08Oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool08_ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003ooooo
ool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0
003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500004_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0P00
00Coool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.27193 .04578 L
.28302 .04578 L
.2881 .04578 L
.29088 .04578 L
.29224 .04578 L
.29349 .04578 L
s
.29349 .04578 m
.29377 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`050000ooooooooooooo`2I00?oool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo
08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo
03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool0
05Woool00ol0VOooooooo`0coooo0P0008ooool005Woool00ol0VOooooooo`0coooo00<0003ooooo
ool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Wooooo
ool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_oo
o`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<ooo
o`80002?oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOoo
ooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>
oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0c
oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool20000Soooo`00FOooo`03o`2I
oooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo
08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo
03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool0
05Woool00ol0VOooooooo`0coooo0P0008ooool005Woool00ol0VOooooooo`0coooo00<0003ooooo
ool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Wooooo
ool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0Poooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo01ooool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool07ooo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00FOooo`03o`2Ioooooooo
01ooool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool005Woool00ol0VOoo
ooooo`0Ooooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
05Woool00ol0VOooooooo`0Poooo0P0000[oool300001?ooo`030000oooooooo08koool005Woool0
0ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?oo
ooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`80002?oooo001Ioooo00?o09Woooooool0<ooo
o`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOoo
o`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000
oooooooo08koool005Woool00ol0VOooooooo`0coooo0P0008ooool005Woool00ol0VOooooooo`0c
oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0
003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o
09Woooooool0<oooo`80002?oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool0
05Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool0
0`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool0
0ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool20000Sooo
o`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<ooo
o`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOoo
o`03o`2Ioooooooo02_oool500000oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0]
oooo00<0003oooooool00oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0]oooo00<0
003oooooool00oooo`<0002>oooo001Ioooo00?o09Woooooool0;Oooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0;Oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Ioooo00?o09Woooooool0;?ooo`800005oooo00<0003oooooool0S_ooo`00FOoo
o`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000
oooooooo08koool005Woool00ol0VOooooooo`0coooo0P0008ooool005Woool00ol0VOooooooo`0c
oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0
003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o
09Woooooool0<oooo`80002?oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool0
05Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool0
0`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool0
0ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool20000Sooo
o`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<ooo
o`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOoo
o`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000
oooooooo08koool005Woool00ol0VOooooooo`0coooo0P0008ooool005Woool00ol0VOooooooo`0c
oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0Ooooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo027oool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00FOooo`03o`2I
oooooooo027oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Ioooo00?o
09Woooooool08Oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool005Woool0
0ol0VOooooooo`0Qoooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo001Ioooo00?o09Woooooool08?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0
003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo
03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool0
05Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool0
0`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool0
0ol0VOooooooo`0coooo0P0008ooool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_oo
o`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<ooo
o`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOoo
o`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`80002?
oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0c
oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0
003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo
03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool0
05Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo02_oool4
00001?ooo`030000oooooooo08koool005Woool00ol0VOooooooo`0[oooo00<0003oooooool01Ooo
o`030000oooooooo08koool005Woool00ol0VOooooooo`0/oooo00<0003oooooool01?ooo`<0002>
oooo001Ioooo00?o09Woooooool0;Oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0:oooo`040000oooooooo00001?ooo`030000oooooooo08koool005Woool0
0ol0VOooooooo`0/oooo0P0000Goool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<ooo
o`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOoo
o`03o`2Ioooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>
oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0c
oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo0P00
08ooool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo
03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool0
05Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool0
0`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`80002?oooo001Ioooo00?o09Wooooo
ool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_oo
o`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<ooo
o`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOoo
o`03o`2Ioooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>
oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0c
oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo01ooool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool07oooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool08?ooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?oo
o`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo00@0003oooooool0000:oooo00<0003oooooool00oooo`030000oooooooo07Ooool007Soool0
0`000?ooooooo`0500004_ooo`040000oooooooo00002oooo`050000oooooooooooo000007[oool0
07Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003oooo00<0
003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.27193 .04578 L
.28302 .04578 L
.2881 .04578 L
.29349 .04578 L
.29809 .04578 L
.29935 .04578 L
.30004 .04578 L
.3007 .04578 L
s
.3007 .04578 m
.30102 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00?oool00ol0VOooo`000008oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool0
05_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool0
0`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo0P0008ooool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_oo
o`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Ooo
o`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Fooo
o`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`80002?
oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0a
oooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001K
oooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0
003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo
037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool0
05_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool0
0`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo0P0008ooool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_oo
o`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Ooo
o`030000oooooooo08koool005_oool00ol0VOooooooo`0Noooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo01goool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool07Oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00Foooo`03o`2Ioooooooo01goool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0M
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0Noooo0P0000[oool300001?ooo`030000oooooooo08koool005_oool00ol0VOoo
ooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>
oooo001Koooo00?o09Woooooool0<Oooo`80002?oooo001Koooo00?o09Woooooool0<Oooo`030000
oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2I
oooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo
08koool005_oool00ol0VOooooooo`0aoooo0P0008ooool005_oool00ol0VOooooooo`0aoooo00<0
003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003ooooo
ool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Wooooo
ool0<Oooo`80002?oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?oo
ooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOoo
ooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Soooo`00Fooo
o`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000
oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2I
oooooooo02Woool500000oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0[oooo00<0
003oooooool00oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0[oooo00<0003ooooo
ool00oooo`<0002>oooo001Koooo00?o09Woooooool0:oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Koooo00?o09Woooooool0:oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001Koooo00?o09Woooooool0:_ooo`800005oooo00<0003oooooool0S_ooo`00Foooo`03o`2I
oooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo
08koool005_oool00ol0VOooooooo`0aoooo0P0008ooool005_oool00ol0VOooooooo`0aoooo00<0
003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003ooooo
ool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Wooooo
ool0<Oooo`80002?oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?oo
ooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOoo
ooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Soooo`00Fooo
o`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000
oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2I
oooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo
08koool005_oool00ol0VOooooooo`0aoooo0P0008ooool005_oool00ol0VOooooooo`0aoooo00<0
003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0Moooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo01ooool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo
01ooool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Koooo00?o09Wooooo
ool07oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool005_oool00ol0VOoo
ooooo`0Ooooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001K
oooo00?o09Woooooool07_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003ooooo
ool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool0
0`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?oo
ooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOoo
ooooo`0aoooo0P0008ooool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Fooo
o`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000
oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2I
oooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`80002?oooo001K
oooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0
003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003ooooo
ool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool0
0`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo02Woool400001?oo
o`030000oooooooo08koool005_oool00ol0VOooooooo`0Yoooo00<0003oooooool01Oooo`030000
oooooooo08koool005_oool00ol0VOooooooo`0Zoooo00<0003oooooool01?ooo`<0002>oooo001K
oooo00?o09Woooooool0:oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool0:Oooo`040000oooooooo00001?ooo`030000oooooooo08koool005_oool00ol0VOoo
ooooo`0Zoooo0P0000Goool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000
oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2I
oooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001K
oooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0
003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo0P0008ooool0
05_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool0
0`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?oo
ooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`80002?oooo001Koooo00?o09Woooooool0<Ooo
o`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Fooo
o`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000
oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2I
oooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001K
oooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0
003oooooool0S_ooo`00Foooo`03o`2Ioooooooo01goool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001Koooo00?o09Woooooool07Oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool07_ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000oooo`@00003
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool00`000?oo
ooooo`03oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool00009oooo00<0003oooooool01Oooo`030000
oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000[oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0P00
00Coool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.28158 .04578 L
.29205 .04578 L
.29779 .04578 L
.30316 .04578 L
.3056 .04578 L
.30791 .04578 L
.30919 .04578 L
s
.30919 .04578 m
.30937 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool0
05goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool0
0`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool0
0ol0VOooooooo`0_oooo0P0008ooool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_oo
o`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;ooo
o`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOoo
o`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`80002?
oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_
oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001M
oooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0
003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool20000Soooo`00GOooo`03o`2Ioooooooo
02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool0
05goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool0
0`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool0
0ol0VOooooooo`0_oooo0P0008ooool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_oo
o`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;ooo
o`030000oooooooo08koool005goool00ol0VOooooooo`0Loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo01_oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool06oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00GOooo`03o`2Ioooooooo01_oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool005goool00ol0VOooooooo`0K
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool005goool0
0ol0VOooooooo`0Loooo0P0000[oool300001?ooo`030000oooooooo08koool005goool00ol0VOoo
ooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>
oooo001Moooo00?o09Woooooool0;oooo`80002?oooo001Moooo00?o09Woooooool0;oooo`030000
oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2I
oooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo
08koool005goool00ol0VOooooooo`0_oooo0P0008ooool005goool00ol0VOooooooo`0_oooo00<0
003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o
09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003ooooo
ool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Wooooo
ool0;oooo`80002?oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool0
0ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?oo
ooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOoo
ooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool20000Soooo`00GOoo
o`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000
oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2I
oooooooo02Ooool500000oooo`030000oooooooo08koool005goool00ol0VOooooooo`0Yoooo00<0
003oooooool00oooo`030000oooooooo08koool005goool00ol0VOooooooo`0Yoooo00<0003ooooo
ool00oooo`<0002>oooo001Moooo00?o09Woooooool0:Oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Moooo00?o09Woooooool0:Oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001Moooo00?o09Woooooool0:?ooo`800005oooo00<0003oooooool0S_ooo`00GOooo`03o`2I
oooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo
08koool005goool00ol0VOooooooo`0_oooo0P0008ooool005goool00ol0VOooooooo`0_oooo00<0
003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o
09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003ooooo
ool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Wooooo
ool0;oooo`80002?oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool0
0ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?oo
ooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOoo
ooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool20000Soooo`00GOoo
o`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000
oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2I
oooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo
08koool005goool00ol0VOooooooo`0_oooo0P0008ooool005goool00ol0VOooooooo`0_oooo00<0
003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o
09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0Koooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo01goool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo
01goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Moooo00?o09Wooooo
ool07Oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool005goool00ol0VOoo
ooooo`0Moooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001M
oooo00?o09Woooooool07?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Moooo00?o
09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003ooooo
ool0S_ooo`00GOooo`03o`2Ioooooooo02ooool20000Soooo`00GOooo`03o`2Ioooooooo02ooool0
0`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool0
0ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?oo
ooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOoo
ooooo`0_oooo0P0008ooool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOoo
o`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000
oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2I
oooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`80002?oooo001M
oooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0
003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o
09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003ooooo
ool0S_ooo`00GOooo`03o`2Ioooooooo02ooool20000Soooo`00GOooo`03o`2Ioooooooo02ooool0
0`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool0
0ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02Ooool400001?oo
o`030000oooooooo08koool005goool00ol0VOooooooo`0Woooo00<0003oooooool01Oooo`030000
oooooooo08koool005goool00ol0VOooooooo`0Xoooo00<0003oooooool01?ooo`<0002>oooo001M
oooo00?o09Woooooool0:Oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001Moooo00?o
09Woooooool09oooo`040000oooooooo00001?ooo`030000oooooooo08koool005goool00ol0VOoo
ooooo`0Xoooo0P0000Goool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000
oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2I
oooooooo02ooool20000Soooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001M
oooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0
003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o
09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo0P0008ooool0
05goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool0
0`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool0
0ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2Ioooooooo02ooool00`000?oo
ooooo`2>oooo001Moooo00?o09Woooooool0;oooo`80002?oooo001Moooo00?o09Woooooool0;ooo
o`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOoo
o`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool0;oooo`030000
oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0003oooooool0S_ooo`00GOooo`03o`2I
oooooooo02ooool20000Soooo`00GOooo`03o`2Ioooooooo02ooool00`000?ooooooo`2>oooo001M
oooo00?o09Woooooool0;oooo`030000oooooooo08koool005goool00ol0VOooooooo`0_oooo00<0
003oooooool0S_ooo`00GOooo`03o`2Ioooooooo01_oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001Moooo00?o09Woooooool06oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Moooo00?o09Woooooool07?ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000oooo`@00003
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00<0003oooooool01?oo
o`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`1goooo001hoooo00<0003ooooo
ool01@0001;oool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`00
00?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool0
0`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.28158 .04578 L
.29205 .04578 L
.30316 .04578 L
.30791 .04578 L
.31304 .04578 L
.31454 .04578 L
.31597 .04578 L
.31725 .04578 L
s
.31725 .04578 m
.31743 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooool0V@06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool0
05ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool0
0`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool0
0ol0VOooooooo`0]oooo0P0008ooool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_oo
o`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Ooo
o`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Gooo
o`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`80002?
oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]
oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001O
oooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo
02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool0
05ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool0
0`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool0
0ol0VOooooooo`0]oooo0P0008ooool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_oo
o`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Ooo
o`030000oooooooo08koool005ooool00ol0VOooooooo`0Joooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo01Woool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool06Oooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00Goooo`03o`2Ioooooooo01Woool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0I
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool005ooool0
0ol0VOooooooo`0Joooo0P0000[oool300001?ooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>
oooo001Ooooo00?o09Woooooool0;Oooo`80002?oooo001Ooooo00?o09Woooooool0;Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo
08koool005ooool00ol0VOooooooo`0]oooo0P0008ooool005ooool00ol0VOooooooo`0]oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o
09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003ooooo
ool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Wooooo
ool0;Oooo`80002?oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool0
0ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?oo
ooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Gooo
o`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02Goool500000oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0Woooo00<0
003oooooool00oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0Woooo00<0003ooooo
ool00oooo`<0002>oooo001Ooooo00?o09Woooooool09oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Ooooo00?o09Woooooool09oooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001Ooooo00?o09Woooooool09_ooo`800005oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo
08koool005ooool00ol0VOooooooo`0]oooo0P0008ooool005ooool00ol0VOooooooo`0]oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o
09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003ooooo
ool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Wooooo
ool0;Oooo`80002?oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool0
0ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?oo
ooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Gooo
o`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo
08koool005ooool00ol0VOooooooo`0]oooo0P0008ooool005ooool00ol0VOooooooo`0]oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o
09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0Ioooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo01_oool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo
01_oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Ooooo00?o09Wooooo
ool06oooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0Koooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001O
oooo00?o09Woooooool06_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Ooooo00?o
09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003ooooo
ool0S_ooo`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo02goool0
0`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool0
0ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?oo
ooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0]oooo0P0008ooool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Gooo
o`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`80002?oooo001O
oooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o
09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003ooooo
ool0S_ooo`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo02goool0
0`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool0
0ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02Goool400001?oo
o`030000oooooooo08koool005ooool00ol0VOooooooo`0Uoooo00<0003oooooool01Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0Voooo00<0003oooooool01?ooo`<0002>oooo001O
oooo00?o09Woooooool09oooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001Ooooo00?o
09Woooooool09Oooo`040000oooooooo00001?ooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0Voooo0P0000Goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001O
oooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o
09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo0P0008ooool0
05ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool0
0`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool0
0ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?oo
ooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`80002?oooo001Ooooo00?o09Woooooool0;Ooo
o`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Gooo
o`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001O
oooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo01Woool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001Ooooo00?o09Woooooool06Oooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool06_ooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000oooo`D00002
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000[oool01@000?oo
ooooooooo`000002oooo00D0003oooooooooool00000Moooo`00M?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000oooooooo
00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001;oool010000?ooooooo`00
00[oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000005Oooo`040000oooooooo00002_ooo`030000oooooooo00;oool00`000?ooooooo`03
oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004oooo0`00
00;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.28158 .04578 L
.30316 .04578 L
.31323 .04578 L
.31875 .04578 L
.32145 .04578 L
.32263 .04578 L
.32392 .04578 L
.32509 .04578 L
s
.32509 .04578 m
.32536 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool01@000?ooooooooooool0V@04oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo
08koool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo
02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0
067oool00ol0VOooooooo`0[oooo0P0008ooool0067oool00ol0VOooooooo`0[oooo00<0003ooooo
ool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Wooooo
ool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_oo
o`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:ooo
o`80002?oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOoo
ooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>
oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[
oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool20000Soooo`00HOooo`03o`2I
oooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo
08koool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo
02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0
067oool00ol0VOooooooo`0[oooo0P0008ooool0067oool00ol0VOooooooo`0[oooo00<0003ooooo
ool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Wooooo
ool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0Hoooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo01Ooool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool05ooo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00HOooo`03o`2Ioooooooo
01Ooool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool0067oool00ol0VOoo
ooooo`0Goooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
067oool00ol0VOooooooo`0Hoooo0P0000[oool300001?ooo`030000oooooooo08koool0067oool0
0ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?oo
ooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`80002?oooo001Qoooo00?o09Woooooool0:ooo
o`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOoo
o`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000
oooooooo08koool0067oool00ol0VOooooooo`0[oooo0P0008ooool0067oool00ol0VOooooooo`0[
oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Q
oooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0
003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o
09Woooooool0:oooo`80002?oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0
067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool0
0`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool0
0ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool20000Sooo
o`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:ooo
o`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOoo
o`03o`2Ioooooooo02?oool500000oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0U
oooo00<0003oooooool00oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0Uoooo00<0
003oooooool00oooo`<0002>oooo001Qoooo00?o09Woooooool09Oooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo001Qoooo00?o09Woooooool09Oooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Qoooo00?o09Woooooool09?ooo`800005oooo00<0003oooooool0S_ooo`00HOoo
o`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000
oooooooo08koool0067oool00ol0VOooooooo`0[oooo0P0008ooool0067oool00ol0VOooooooo`0[
oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Q
oooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0
003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o
09Woooooool0:oooo`80002?oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0
067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool0
0`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_ooo`030000oooooooo08koool006;oool0
0ol0VOooooooo`0Zoooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo02[oool20000Sooo
o`00H_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_oo
o`030000oooooooo08koool006;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_ooo`00H_oo
o`03o`2Ioooooooo02[oool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_ooo`030000
oooooooo08koool006;oool00ol0VOooooooo`0Zoooo0P0008ooool006;oool00ol0VOooooooo`0Z
oooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`2>oooo001R
oooo00?o09Woooooool0:_ooo`030000oooooooo08koool006;oool00ol0VOooooooo`0Foooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo01Soool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00H_ooo`03o`2I
oooooooo01Soool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Roooo00?o
09Woooooool06?ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool006;oool0
0ol0VOooooooo`0Hoooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo001Roooo00?o09Woooooool05oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001R
oooo00?o09Woooooool0:_ooo`030000oooooooo08koool006;oool00ol0VOooooooo`0Zoooo00<0
003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo02[oool20000Soooo`00H_ooo`03o`2Ioooooooo
02[oool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_ooo`030000oooooooo08koool0
06;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo02[oool0
0`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_ooo`030000oooooooo08koool006;oool0
0ol0VOooooooo`0Zoooo0P0008ooool006;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_oo
o`00H_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_oo
o`030000oooooooo08koool006;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_ooo`00H_oo
o`03o`2Ioooooooo02[oool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_ooo`80002?
oooo001Roooo00?o09Woooooool0:_ooo`030000oooooooo08koool006;oool00ol0VOooooooo`0Z
oooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`2>oooo001R
oooo00?o09Woooooool0:_ooo`030000oooooooo08koool006;oool00ol0VOooooooo`0Zoooo00<0
003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo02[oool20000Soooo`00H_ooo`03o`2Ioooooooo
02[oool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_ooo`030000oooooooo08koool0
06;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo02;oool4
00001?ooo`030000oooooooo08koool006;oool00ol0VOooooooo`0Roooo00<0003oooooool01Ooo
o`030000oooooooo08koool006;oool00ol0VOooooooo`0Soooo00<0003oooooool01?ooo`<0002>
oooo001Roooo00?o09Woooooool09?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001R
oooo00?o09Woooooool08_ooo`040000oooooooo00001?ooo`030000oooooooo08koool006;oool0
0ol0VOooooooo`0Soooo0P0000Goool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_oo
o`030000oooooooo08koool006;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_ooo`00H_oo
o`03o`2Ioooooooo02[oool20000Soooo`00H_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`2>
oooo001Roooo00?o09Woooooool0:_ooo`030000oooooooo08koool006;oool00ol0VOooooooo`0Z
oooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`2>oooo001R
oooo00?o09Woooooool0:_ooo`030000oooooooo08koool006;oool00ol0VOooooooo`0Zoooo0P00
08ooool006;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo
02[oool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_ooo`030000oooooooo08koool0
06;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo02[oool0
0`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_ooo`80002?oooo001Roooo00?o09Wooooo
ool0:_ooo`030000oooooooo08koool006;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_oo
o`00H_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool0:_oo
o`030000oooooooo08koool006;oool00ol0VOooooooo`0Zoooo00<0003oooooool0S_ooo`00H_oo
o`03o`2Ioooooooo02[oool20000Soooo`00H_ooo`03o`2Ioooooooo02[oool00`000?ooooooo`2>
oooo001Roooo00?o09Woooooool0:_ooo`030000oooooooo08koool006;oool00ol0VOooooooo`0Z
oooo00<0003oooooool0S_ooo`00H_ooo`03o`2Ioooooooo01Koool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool05_ooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Roooo00?o09Woooooool05oooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000ooo
o`D00002oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool0000:oooo00<0003ooooo
ool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool04ooo
o`040000oooooooo00002_ooo`030000oooooooo00?oool00`000?ooooooo`1goooo001hoooo00<0
003oooooool01@0001;oool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000[oool00`000?oo
ooooo`02oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003
oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.28158 .04578 L
.30316 .04578 L
.31323 .04578 L
.32392 .04578 L
.32831 .04578 L
.33073 .04578 L
.33193 .04578 L
.33304 .04578 L
s
.33304 .04578 m
.33336 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`04oooo00?o09Woool000001ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool0
06Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool0
0`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool0
0ol0VOooooooo`0Xoooo0P0008ooool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_oo
o`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?oo
o`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?oo
o`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`80002?
oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0X
oooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001T
oooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0
003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool20000Soooo`00I?ooo`03o`2Ioooooooo
02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool0
06Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool0
0`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool0
0ol0VOooooooo`0Xoooo0P0008ooool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_oo
o`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?oo
o`030000oooooooo08koool006Coool00ol0VOooooooo`0Eoooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo01Coool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool05?ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00I?ooo`03o`2Ioooooooo01Coool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool006Coool00ol0VOooooooo`0D
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006Coool0
0ol0VOooooooo`0Eoooo0P0000[oool300001?ooo`030000oooooooo08koool006Coool00ol0VOoo
ooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>
oooo001Toooo00?o09Woooooool0:?ooo`80002?oooo001Toooo00?o09Woooooool0:?ooo`030000
oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2I
oooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo
08koool006Coool00ol0VOooooooo`0Xoooo0P0008ooool006Coool00ol0VOooooooo`0Xoooo00<0
003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o
09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003ooooo
ool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Wooooo
ool0:?ooo`80002?oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool0
0ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?oo
ooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOoo
ooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool20000Soooo`00I?oo
o`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000
oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2I
oooooooo023oool500000oooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Roooo00<0
003oooooool00oooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Roooo00<0003ooooo
ool00oooo`<0002>oooo001Toooo00?o09Woooooool08_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Toooo00?o09Woooooool08_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001Toooo00?o09Woooooool08Oooo`800005oooo00<0003oooooool0S_ooo`00I?ooo`03o`2I
oooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo
08koool006Coool00ol0VOooooooo`0Xoooo0P0008ooool006Coool00ol0VOooooooo`0Xoooo00<0
003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o
09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003ooooo
ool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Wooooo
ool0:?ooo`80002?oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool0
0ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?oo
ooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOoo
ooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool20000Soooo`00I?oo
o`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000
oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2I
oooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo
08koool006Coool00ol0VOooooooo`0Xoooo0P0008ooool006Coool00ol0VOooooooo`0Xoooo00<0
003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o
09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Doooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo01Koool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo
01Koool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Toooo00?o09Wooooo
ool05_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool006Coool00ol0VOoo
ooooo`0Foooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001T
oooo00?o09Woooooool05Oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Toooo00?o
09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003ooooo
ool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool20000Soooo`00I?ooo`03o`2Ioooooooo02Soool0
0`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool0
0ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?oo
ooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOoo
ooooo`0Xoooo0P0008ooool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?oo
o`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000
oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2I
oooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`80002?oooo001T
oooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0
003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o
09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003ooooo
ool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool20000Soooo`00I?ooo`03o`2Ioooooooo02Soool0
0`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool0
0ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo023oool400001?oo
o`030000oooooooo08koool006Coool00ol0VOooooooo`0Poooo00<0003oooooool01Oooo`030000
oooooooo08koool006Coool00ol0VOooooooo`0Qoooo00<0003oooooool01?ooo`<0002>oooo001T
oooo00?o09Woooooool08_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001Toooo00?o
09Woooooool08?ooo`040000oooooooo00001?ooo`030000oooooooo08koool006Coool00ol0VOoo
ooooo`0Qoooo0P0000Goool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000
oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2I
oooooooo02Soool20000Soooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001T
oooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0
003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o
09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo0P0008ooool0
06Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool0
0`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool0
0ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo02Soool00`000?oo
ooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`80002?oooo001Toooo00?o09Woooooool0:?oo
o`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?oo
o`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool0:?ooo`030000
oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0003oooooool0S_ooo`00I?ooo`03o`2I
oooooooo02Soool20000Soooo`00I?ooo`03o`2Ioooooooo02Soool00`000?ooooooo`2>oooo001T
oooo00?o09Woooooool0:?ooo`030000oooooooo08koool006Coool00ol0VOooooooo`0Xoooo00<0
003oooooool0S_ooo`00I?ooo`03o`2Ioooooooo01Coool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001Toooo00?o09Woooooool05?ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Toooo00?o09Woooooool05Oooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?oo
ooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003ooooo
ool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Soool010000?ooooooo`0000Goool0
0`000?ooooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Boooo00@0
003oooooool00008oooo00@0003oooooool00003oooo0P0000Coool00`000?ooooooo`1eoooo001e
oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:
oooo0P0000Coool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -54.125 0 ]
[.5 .63053 54.125 13.375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -115.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.625 moveto
(8) show
69.000 13.625 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 13.625 moveto
(,) show
84.563 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.22045) show
128.375 13.625 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
136.188 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
148.188 9.438 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
152.375 9.438 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
161.250 13.625 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.28158 .04578 L
.30316 .04578 L
.31323 .04578 L
.32392 .04578 L
.33304 .04578 L
.33554 .04578 L
.33823 .04578 L
.33953 .04578 L
.34076 .04578 L
s
.34076 .04578 m
.34104 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -54.125 0 ]
[.5 .63053 54.125 13.375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -115.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.625 moveto
(8) show
69.000 13.625 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 13.625 moveto
(,) show
84.563 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.22045) show
128.375 13.625 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
136.188 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
148.188 9.438 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
152.375 9.438 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
161.250 13.625 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Koool200009_ooo`@0000Uoooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Coool400009_ooo`80000Eoooo000Eoooo00@0003oooooool0000Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09?ooo`030000oooooooo
02Koool010000?ooooooo`0001Coool001Ooool00`000?ooooooo`0Uoooo00<0003oooooool09ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Ooool00`000?ooooooo`0Coooo000?oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Noooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Koool00`000?ooooooo`0Woooo00<0003oooooool04_ooo`005Oooo`040000oooooooo
00009Oooo`040000oooooooo00009oooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09?ooo`040000oooooooo00009Oooo`040000oooooooo00005?ooo`005_ooo`80000W
oooo0P0002Ooool200009Oooo`80000Voooo0P0002Ooool200009oooo`80000Eoooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000kooooo0000100000ooool0
01Coool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`0Coooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool0
06Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool0
0`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool0
0ol0VOooooooo`0Voooo0P0008ooool006Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_oo
o`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_oo
o`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_oo
o`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`80002?
oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0V
oooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001V
oooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0
003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool20000Soooo`00I_ooo`03o`2Ioooooooo
02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool0
06Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool0
0`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`80002?oooo001Voooo00?o09Wooooo
ool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_oo
o`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool04ooo
o`800004oooo0P0000Coool200001Oooo`030000oooooooo08koool006Koool00ol0VOooooooo`0B
oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00I_oo
o`03o`2Ioooooooo01;oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`0008koool0
06Koool00ol0VOooooooo`0Boooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`2>
oooo001Voooo00?o09Woooooool04_ooo`040000oooooooo00002Oooo`030000oooooooo00Coool0
0`000?ooooooo`2>oooo001Voooo00?o09Woooooool04oooo`80000:oooo0`0000Coool00`000?oo
ooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOoo
ooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool20000Soooo`00I_oo
o`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000
oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2I
oooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo
08koool006Koool00ol0VOooooooo`0Voooo0P0008ooool006Koool00ol0VOooooooo`0Voooo00<0
003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o
09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003ooooo
ool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Wooooo
ool09_ooo`80002?oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool0
0ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?oo
ooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOoo
ooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool20000Soooo`00I_oo
o`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000
oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2I
oooooooo01koool500000oooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Poooo00<0
003oooooool00oooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Poooo00<0003ooooo
ool00oooo`<0002>oooo001Voooo00?o09Woooooool08?ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Voooo00?o09Woooooool08?ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001Voooo00?o09Woooooool07oooo`800005oooo00<0003oooooool0S_ooo`00I_ooo`03o`2I
oooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo
08koool006Koool00ol0VOooooooo`0Voooo0P0008ooool006Koool00ol0VOooooooo`0Voooo00<0
003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o
09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003ooooo
ool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Wooooo
ool09_ooo`80002?oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool0
0ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?oo
ooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOoo
ooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool20000Soooo`00I_oo
o`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000
oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2I
oooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo
08koool006Koool00ol0VOooooooo`0Voooo0P0008ooool006Koool00ol0VOooooooo`0Voooo00<0
003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o
09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Boooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo
01Coool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Voooo00?o09Wooooo
ool05?ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool006Koool00ol0VOoo
ooooo`0Doooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001V
oooo00?o09Woooooool04oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Voooo00?o
09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003ooooo
ool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool20000Soooo`00I_ooo`03o`2Ioooooooo02Koool0
0`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool0
0ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?oo
ooooo`2>oooo001Voooo00?o09Woooooool09_ooo`80002?oooo001Voooo00?o09Woooooool09_oo
o`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_oo
o`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000
oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2I
oooooooo02Koool20000Soooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001V
oooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0
003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o
09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo0P0008ooool0
06Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool0
0`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool0
0ol0VOooooooo`0Noooo100000Coool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool07_oo
o`030000oooooooo00Goool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool07oooo`030000
oooooooo00Coool30000S_ooo`00I_ooo`03o`2Ioooooooo023oool00`000?ooooooo`03oooo00<0
003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo01koool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo001Voooo00?o09Woooooool07oooo`800005oooo00<0003oooooool0S_ooo`00I_oo
o`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000
oooooooo08koool006Koool00ol0VOooooooo`0Voooo0P0008ooool006Koool00ol0VOooooooo`0V
oooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001V
oooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0
003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o
09Woooooool09_ooo`80002?oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool0
06Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool0
0`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool0
0ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool20000Sooo
o`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_oo
o`030000oooooooo08koool006Koool00ol0VOooooooo`0Voooo00<0003oooooool0S_ooo`00I_oo
o`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001Voooo00?o09Woooooool09_ooo`030000
oooooooo08koool006Koool00ol0VOooooooo`0Voooo0P0008ooool006Koool00ol0VOooooooo`0V
oooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo02Koool00`000?ooooooo`2>oooo001V
oooo00?o09Woooooool09_ooo`030000oooooooo08koool006Koool00ol0VOooooooo`0Boooo1000
00?oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00I_ooo`03o`2Ioooooooo01;oool0
0`000?ooooooo`09oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00I_ooo`03o`2I
oooooooo01?oool00`000?ooooooo`0;oooo00<0003oooooool00_ooo`<0002>oooo001moooo00<0
003oooooool02?ooo`80002Foooo001koooo00@0003oooooool00009oooo00<0003oooooool0UOoo
o`00O?ooo`80000:oooo0`0009Goool00?oooolQoooo003ooooo8Oooo`00Goooo`030000oooooooo
05coool00`000?ooooooo`1Ooooo001Noooo00<0003oooooool02?ooo`030000oooooooo05?oool0
0`000?ooooooo`1Noooo001Noooo00<0003oooooool00_ooo`800004oooo00<0003oooooool01Ooo
o`@00003oooo0P0000?oool400000_ooo`@00003oooo0P0000Goool300000_ooo`800005oooo00D0
003oooooooooool000000oooo`D00002oooo0P00017oool00`000?ooooooo`1Noooo001Noooo00D0
003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo00<0003ooooo
ool02Oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00@0003oooooool00005oooo00@0
003oooooool00002oooo00<0003oooooool00oooo`030000oooo000000Koool01@000?oooooooooo
o`000002oooo00<0003oooooool03_ooo`030000oooooooo05koool005goool00`000?ooooooo`02
oooo00<0003oooooool03Oooo`030000oooooooo00Woool00`000?ooooooo`03oooo00<0003ooooo
ool00_ooo`040000oooooooo00000_ooo`D00004oooo00<0003oooooool01?ooo`030000oooooooo
00Goool01@000?ooooooooooo`000002oooo00<0003oooooool03oooo`030000oooooooo05goool0
05koool00`000?ooooooo`0500003Oooo`030000oooooooo00Woool00`000?ooooooo`03oooo00D0
003oooooooooool000000_ooo`040000oooooooo00000_ooo`040000oooooooooooo0P0000Koool0
0`000?ooo`000006oooo00D0003oooooooooool000000_ooo`030000oooooooo00koool00`000?oo
ooooo`1Noooo001Noooo00D0003oooooooooool000003_ooo`040000oooooooo00002?ooo`040000
oooooooo00000_ooo`040000oooooooo00000_ooo`040000oooooooo00000oooo`030000oooo0000
00?oool00`000?ooooooo`04oooo00D0003oooooooooool000001Oooo`050000oooooooooooo0000
00;oool00`000?ooooooo`04oooo0P0000;oool300000oooo`030000oooooooo05koool005ooool0
0`000?ooooooo`0@oooo0P0000[oool200001?ooo`800004oooo0P0000Goool200000oooo`<0000=
oooo0P0000Coool200000oooo`<00002oooo00H0003oooooool0003oool00002oooo00<0003ooooo
ool0Goooo`00]_ooo`030000oooooooo0080001Uoooo002eoooo0P0000;oool30000I?ooo`00oooo
ob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.49265, \
-0.206556, 0.0243443, 0.0168814}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.49265, -0.206556, 0.0243443, 0.0168814}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.32392 .04578 L
.33304 .04578 L
.33788 .04578 L
.34309 .04578 L
.34566 .04578 L
.34693 .04578 L
.34811 .04578 L
.34918 .04578 L
s
.34918 .04578 m
.34946 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo09T01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool0
06Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool0
0`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool0
0ol0VOooooooo`0Toooo0P0008ooool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_oo
o`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?oo
o`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?oo
o`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`80002?
oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0T
oooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001X
oooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0
003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool20000Soooo`00J?ooo`03o`2Ioooooooo
02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool0
06Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool0
0`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool0
0ol0VOooooooo`0Toooo0P0008ooool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_oo
o`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?oo
o`030000oooooooo08koool006Soool00ol0VOooooooo`0Aoooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo013oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool04?ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00J?ooo`03o`2Ioooooooo013oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool006Soool00ol0VOooooooo`0@
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006Soool0
0ol0VOooooooo`0Aoooo0P0000[oool300001?ooo`030000oooooooo08koool006Soool00ol0VOoo
ooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>
oooo001Xoooo00?o09Woooooool09?ooo`80002?oooo001Xoooo00?o09Woooooool09?ooo`030000
oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2I
oooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo
08koool006Soool00ol0VOooooooo`0Toooo0P0008ooool006Soool00ol0VOooooooo`0Toooo00<0
003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o
09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003ooooo
ool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Wooooo
ool09?ooo`80002?oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool0
0ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?oo
ooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOoo
ooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool20000Soooo`00J?oo
o`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000
oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2I
oooooooo01coool500000oooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Noooo00<0
003oooooool00oooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Noooo00<0003ooooo
ool00oooo`<0002>oooo001Xoooo00?o09Woooooool07_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Xoooo00?o09Woooooool07_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001Xoooo00?o09Woooooool07Oooo`800005oooo00<0003oooooool0S_ooo`00J?ooo`03o`2I
oooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo
08koool006Soool00ol0VOooooooo`0Toooo0P0008ooool006Soool00ol0VOooooooo`0Toooo00<0
003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o
09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003ooooo
ool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Wooooo
ool09?ooo`80002?oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool0
0ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?oo
ooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOoo
ooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool20000Soooo`00J?oo
o`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000
oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2I
oooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo
08koool006Soool00ol0VOooooooo`0Toooo0P0008ooool006Soool00ol0VOooooooo`0Toooo00<0
003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o
09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0@oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo01;oool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo
01;oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Xoooo00?o09Wooooo
ool04_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool006Soool00ol0VOoo
ooooo`0Boooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001X
oooo00?o09Woooooool04Oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Xoooo00?o
09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003ooooo
ool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool20000Soooo`00J?ooo`03o`2Ioooooooo02Coool0
0`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool0
0ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?oo
ooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOoo
ooooo`0Toooo0P0008ooool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?oo
o`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000
oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2I
oooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`80002?oooo001X
oooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0
003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o
09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003ooooo
ool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool20000Soooo`00J?ooo`03o`2Ioooooooo02Coool0
0`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool0
0ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo01coool400001?oo
o`030000oooooooo08koool006Soool00ol0VOooooooo`0Loooo00<0003oooooool01Oooo`030000
oooooooo08koool006Soool00ol0VOooooooo`0Moooo00<0003oooooool01?ooo`<0002>oooo001X
oooo00?o09Woooooool07_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001Xoooo00?o
09Woooooool07?ooo`040000oooooooo00001?ooo`030000oooooooo08koool006Soool00ol0VOoo
ooooo`0Moooo0P0000Goool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000
oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2I
oooooooo02Coool20000Soooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001X
oooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0
003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o
09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo0P0008ooool0
06Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool0
0`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool0
0ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo02Coool00`000?oo
ooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`80002?oooo001Xoooo00?o09Woooooool09?oo
o`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?oo
o`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool09?ooo`030000
oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0003oooooool0S_ooo`00J?ooo`03o`2I
oooooooo02Coool20000Soooo`00J?ooo`03o`2Ioooooooo02Coool00`000?ooooooo`2>oooo001X
oooo00?o09Woooooool09?ooo`030000oooooooo08koool006Soool00ol0VOooooooo`0Toooo00<0
003oooooool0S_ooo`00J?ooo`03o`2Ioooooooo013oool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001Xoooo00?o09Woooooool04?ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Xoooo00?o09Woooooool04Oooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`07oooo0P0000Coool200001?ooo`800004
oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`05oooo00@0003oooooool00008oooo00@0003oooooool00002
oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool0
0`000?ooooooo`0=oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003ooooo
ool00_ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500003?ooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000000ooool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo017oool200002_ooo`800004
oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.32392 .04578 L
.33304 .04578 L
.34309 .04578 L
.34772 .04578 L
.35028 .04578 L
.35271 .04578 L
.35496 .04578 L
.35624 .04578 L
s
.35624 .04578 m
.35653 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00D0003ooooooooooooo
09T00oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`0Boooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo
08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo
02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool0
06[oool00ol0VOooooooo`0Roooo0P0008ooool006[oool00ol0VOooooooo`0Roooo00<0003ooooo
ool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Wooooo
ool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_oo
o`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_oo
o`80002?oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOoo
ooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>
oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0R
oooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool20000Soooo`00J_ooo`03o`2I
oooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo
08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo
02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool0
06[oool00ol0VOooooooo`0Roooo0P0008ooool006[oool00ol0VOooooooo`0Roooo00<0003ooooo
ool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Wooooo
ool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0?oooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo00koool010000?ooooooo`00
00Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool03_oo
o`040000oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00J_ooo`03o`2Ioooooooo
00koool010000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool006[oool00ol0VOoo
ooooo`0>oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool0
06[oool00ol0VOooooooo`0?oooo0P0000[oool300001?ooo`030000oooooooo08koool006[oool0
0ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?oo
ooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`80002?oooo001Zoooo00?o09Woooooool08_oo
o`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_oo
o`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000
oooooooo08koool006[oool00ol0VOooooooo`0Roooo0P0008ooool006[oool00ol0VOooooooo`0R
oooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Z
oooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0
003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o
09Woooooool08_ooo`80002?oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool0
06[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool0
0`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool0
0ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool20000Sooo
o`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_oo
o`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_oo
o`03o`2Ioooooooo01[oool500000oooo`030000oooooooo08koool006[oool00ol0VOooooooo`0L
oooo00<0003oooooool00oooo`030000oooooooo08koool006[oool00ol0VOooooooo`0Loooo00<0
003oooooool00oooo`<0002>oooo001Zoooo00?o09Woooooool07?ooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo001Zoooo00?o09Woooooool07?ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001Zoooo00?o09Woooooool06oooo`800005oooo00<0003oooooool0S_ooo`00J_oo
o`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000
oooooooo08koool006[oool00ol0VOooooooo`0Roooo0P0008ooool006[oool00ol0VOooooooo`0R
oooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Z
oooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0
003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o
09Woooooool08_ooo`80002?oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool0
06[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool0
0`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool0
0ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool20000Sooo
o`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_oo
o`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_oo
o`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000
oooooooo08koool006[oool00ol0VOooooooo`0Roooo0P0008ooool006[oool00ol0VOooooooo`0R
oooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Z
oooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0>oooo1@00
00;oool200001?ooo`800005oooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo013oool0
0`000?ooooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00J_ooo`03o`2I
oooooooo013oool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001Zoooo00?o
09Woooooool04?ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool006[oool0
0ol0VOooooooo`0@oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>
oooo001Zoooo00?o09Woooooool03oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Z
oooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0
003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool20000Soooo`00J_ooo`03o`2Ioooooooo
02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool0
06[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool0
0`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool0
0ol0VOooooooo`0Roooo0P0008ooool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_oo
o`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_oo
o`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_oo
o`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`80002?
oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0R
oooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Z
oooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0
003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool20000Soooo`00J_ooo`03o`2Ioooooooo
02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool0
06[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo01[oool4
00001?ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0Joooo00<0003oooooool01Ooo
o`030000oooooooo08koool006[oool00ol0VOooooooo`0Koooo00<0003oooooool01?ooo`<0002>
oooo001Zoooo00?o09Woooooool07?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001Z
oooo00?o09Woooooool06_ooo`040000oooooooo00001?ooo`030000oooooooo08koool006[oool0
0ol0VOooooooo`0Koooo0P0000Goool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_oo
o`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_oo
o`03o`2Ioooooooo02;oool20000Soooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>
oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0R
oooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Z
oooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo0P00
08ooool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo
02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool0
06[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo02;oool0
0`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_ooo`80002?oooo001Zoooo00?o09Wooooo
ool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_oo
o`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool08_oo
o`030000oooooooo08koool006[oool00ol0VOooooooo`0Roooo00<0003oooooool0S_ooo`00J_oo
o`03o`2Ioooooooo02;oool20000Soooo`00J_ooo`03o`2Ioooooooo02;oool00`000?ooooooo`2>
oooo001Zoooo00?o09Woooooool08_ooo`030000oooooooo08koool006[oool00ol0VOooooooo`0R
oooo00<0003oooooool0S_ooo`00J_ooo`03o`2Ioooooooo00koool400000oooo`800004oooo0P00
00Goool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool03_ooo`030000oooooooo00Woool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Zoooo00?o09Woooooool03oooo`030000
oooooooo00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P00
09Koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool3
0000UOooo`00ooooob7oool00?oooolQoooo001loooo00<0003oooooool08_ooo`030000oooooooo
07coool007_oool00`000?ooooooo`08oooo00<0003oooooool06Oooo`030000oooooooo07_oool0
07_oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`07oooo0P0000Coool200000ooo
o`D00002oooo00<0003oooooool0Noooo`00Noooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01Oooo`040000oooooooo00002_ooo`030000oooooooo00;oool0
0`000?ooooooo`1koooo001joooo00<0003oooooool00_ooo`030000oooooooo00goool010000?oo
ooooo`0000[oool00`000?ooooooo`03oooo00<0003oooooool0N_ooo`00Noooo`030000oooooooo
00D0000<oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`030000oooooooo07_oool0
07_oool01@000?ooooooooooo`00000?oooo00@0003oooooool0000:oooo00<0003oooooool00_oo
o`030000oooooooo07_oool007coool00`000?ooooooo`0Aoooo0P0000[oool200000oooo`030000
oooooooo07coool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.32392 .04578 L
.34309 .04578 L
.35271 .04578 L
.35742 .04578 L
.36173 .04578 L
.36284 .04578 L
.36405 .04578 L
s
.36405 .04578 m
.36434 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool00ooo
o`03o`2Ioooo000000Ooool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool0
06coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool0
0`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool0
0ol0VOooooooo`0Poooo0P0008ooool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_oo
o`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?oo
o`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?oo
o`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`80002?
oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0P
oooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/
oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0
003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool20000Soooo`00K?ooo`03o`2Ioooooooo
023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool0
06coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool0
0`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool0
0ol0VOooooooo`0Poooo0P0008ooool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_oo
o`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?oo
o`030000oooooooo08koool006coool00ol0VOooooooo`0=oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo00coool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool03?ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00K?ooo`03o`2Ioooooooo00coool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool006coool00ol0VOooooooo`0<
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006coool0
0ol0VOooooooo`0=oooo0P0000[oool300001?ooo`030000oooooooo08koool006coool00ol0VOoo
ooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>
oooo001/oooo00?o09Woooooool08?ooo`80002?oooo001/oooo00?o09Woooooool08?ooo`030000
oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2I
oooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo
08koool006coool00ol0VOooooooo`0Poooo0P0008ooool006coool00ol0VOooooooo`0Poooo00<0
003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o
09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003ooooo
ool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Wooooo
ool08?ooo`80002?oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool0
0ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?oo
ooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOoo
ooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool20000Soooo`00K?oo
o`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000
oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2I
oooooooo01Soool500000oooo`030000oooooooo08koool006coool00ol0VOooooooo`0Joooo00<0
003oooooool00oooo`030000oooooooo08koool006coool00ol0VOooooooo`0Joooo00<0003ooooo
ool00oooo`<0002>oooo001/oooo00?o09Woooooool06_ooo`030000oooooooo00?oool00`000?oo
ooooo`2>oooo001/oooo00?o09Woooooool06_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001/oooo00?o09Woooooool06Oooo`800005oooo00<0003oooooool0S_ooo`00K?ooo`03o`2I
oooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo
08koool006coool00ol0VOooooooo`0Poooo0P0008ooool006coool00ol0VOooooooo`0Poooo00<0
003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o
09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003ooooo
ool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Wooooo
ool08?ooo`80002?oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool0
0ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?oo
ooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOoo
ooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool20000Soooo`00K?oo
o`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000
oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2I
oooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo
08koool006coool00ol0VOooooooo`0Poooo0P0008ooool006coool00ol0VOooooooo`0Poooo00<0
003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o
09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0<oooo1@0000;oool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo00koool00`000?oo
ooooo`07oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo
00koool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`<0002>oooo001/oooo00?o09Wooooo
ool03_ooo`030000oooooooo00Soool200001Oooo`030000oooooooo08koool006coool00ol0VOoo
ooooo`0>oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001/
oooo00?o09Woooooool03Oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001/oooo00?o
09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003ooooo
ool0S_ooo`00K?ooo`03o`2Ioooooooo023oool20000Soooo`00K?ooo`03o`2Ioooooooo023oool0
0`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool0
0ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?oo
ooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOoo
ooooo`0Poooo0P0008ooool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?oo
o`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000
oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2I
oooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`80002?oooo001/
oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0
003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o
09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003ooooo
ool0S_ooo`00K?ooo`03o`2Ioooooooo023oool20000Soooo`00K?ooo`03o`2Ioooooooo023oool0
0`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool0
0ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo01Soool400001?oo
o`030000oooooooo08koool006coool00ol0VOooooooo`0Hoooo00<0003oooooool01Oooo`030000
oooooooo08koool006coool00ol0VOooooooo`0Ioooo00<0003oooooool01?ooo`<0002>oooo001/
oooo00?o09Woooooool06_ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001/oooo00?o
09Woooooool06?ooo`040000oooooooo00001?ooo`030000oooooooo08koool006coool00ol0VOoo
ooooo`0Ioooo0P0000Goool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000
oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2I
oooooooo023oool20000Soooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/
oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0
003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o
09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo0P0008ooool0
06coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool0
0`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool0
0ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo023oool00`000?oo
ooooo`2>oooo001/oooo00?o09Woooooool08?ooo`80002?oooo001/oooo00?o09Woooooool08?oo
o`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?oo
o`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool08?ooo`030000
oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0003oooooool0S_ooo`00K?ooo`03o`2I
oooooooo023oool20000Soooo`00K?ooo`03o`2Ioooooooo023oool00`000?ooooooo`2>oooo001/
oooo00?o09Woooooool08?ooo`030000oooooooo08koool006coool00ol0VOooooooo`0Poooo00<0
003oooooool0S_ooo`00K?ooo`03o`2Ioooooooo00coool400000oooo`800004oooo0P0000Goool0
0`000?ooooooo`2>oooo001/oooo00?o09Woooooool03?ooo`030000oooooooo00Woool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001/oooo00?o09Woooooool03Oooo`030000oooooooo
00_oool00`000?ooooooo`02oooo0`0008koool007goool00`000?ooooooo`08oooo0P0009Koool0
07_oool010000?ooooooo`0000Woool00`000?ooooooo`2Eoooo001loooo0P0000[oool30000UOoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`07oooo0P0000Coool200000oooo`D00002
oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`05oooo00@0003oooooool0000:oooo00D0003oooooooooool0
00000_ooo`050000oooooooooooo000007[oool007Ooool00`000?ooooooo`02oooo00<0003ooooo
ool03Oooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`02oooo00<0
003oooooool0Moooo`00N?ooo`030000oooooooo00D0000<oooo00@0003oooooool0000:oooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
00ooool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000
oooooooo07Soool007Woool00`000?ooooooo`0Aoooo0P0000[oool200001?ooo`<00002oooo00<0
003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.47438, \
-0.205761, 0.024217, 0.0167931}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.47438, -0.205761, 0.024217, 0.0167931}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
.2 1 0 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
.97619 .04578 L
.02381 .04578 L
F
0 g
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
1 0 .6 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.32392 .04578 L
.34309 .04578 L
.36173 .04578 L
.36626 .04578 L
.36876 .04578 L
.37114 .04578 L
.37178 .04578 L
.37247 .04578 L
s
.37247 .04578 m
.37266 .61803 L
s
0 .4 1 r
.02381 .04578 m
.06244 .04578 L
.10458 .04578 L
.14415 .04578 L
.18221 .04578 L
.22272 .04578 L
.26171 .04578 L
.30316 .04578 L
.34309 .04578 L
.3815 .04578 L
.42237 .04578 L
.46172 .04578 L
.49955 .04578 L
.53984 .04578 L
.57861 .04578 L
.61984 .04578 L
.65954 .04578 L
.69774 .04578 L
.73838 .04578 L
.77751 .04578 L
.81909 .04578 L
.85916 .04578 L
.89771 .04578 L
.93871 .04578 L
.97619 .04578 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.0457803 0.228901 [
[.02381 .03328 -6 -9 ]
[.02381 .03328 6 0 ]
[.18254 .03328 -6 -9 ]
[.18254 .03328 6 0 ]
[.34127 .03328 -6 -9 ]
[.34127 .03328 6 0 ]
[.65873 .03328 -3 -9 ]
[.65873 .03328 3 0 ]
[.81746 .03328 -3 -9 ]
[.81746 .03328 3 0 ]
[.97619 .03328 -3 -9 ]
[.97619 .03328 3 0 ]
[.4875 .16023 -18 -4.5 ]
[.4875 .16023 0 4.5 ]
[.4875 .27468 -6 -4.5 ]
[.4875 .27468 0 4.5 ]
[.4875 .38913 -18 -4.5 ]
[.4875 .38913 0 4.5 ]
[.4875 .50358 -6 -4.5 ]
[.4875 .50358 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .04578 m
.02381 .05203 L
s
[(-3)] .02381 .03328 0 1 Mshowa
.18254 .04578 m
.18254 .05203 L
s
[(-2)] .18254 .03328 0 1 Mshowa
.34127 .04578 m
.34127 .05203 L
s
[(-1)] .34127 .03328 0 1 Mshowa
.65873 .04578 m
.65873 .05203 L
s
[(1)] .65873 .03328 0 1 Mshowa
.81746 .04578 m
.81746 .05203 L
s
[(2)] .81746 .03328 0 1 Mshowa
.97619 .04578 m
.97619 .05203 L
s
[(3)] .97619 .03328 0 1 Mshowa
.125 Mabswid
.05556 .04578 m
.05556 .04953 L
s
.0873 .04578 m
.0873 .04953 L
s
.11905 .04578 m
.11905 .04953 L
s
.15079 .04578 m
.15079 .04953 L
s
.21429 .04578 m
.21429 .04953 L
s
.24603 .04578 m
.24603 .04953 L
s
.27778 .04578 m
.27778 .04953 L
s
.30952 .04578 m
.30952 .04953 L
s
.37302 .04578 m
.37302 .04953 L
s
.40476 .04578 m
.40476 .04953 L
s
.43651 .04578 m
.43651 .04953 L
s
.46825 .04578 m
.46825 .04953 L
s
.53175 .04578 m
.53175 .04953 L
s
.56349 .04578 m
.56349 .04953 L
s
.59524 .04578 m
.59524 .04953 L
s
.62698 .04578 m
.62698 .04953 L
s
.69048 .04578 m
.69048 .04953 L
s
.72222 .04578 m
.72222 .04953 L
s
.75397 .04578 m
.75397 .04953 L
s
.78571 .04578 m
.78571 .04953 L
s
.84921 .04578 m
.84921 .04953 L
s
.88095 .04578 m
.88095 .04953 L
s
.9127 .04578 m
.9127 .04953 L
s
.94444 .04578 m
.94444 .04953 L
s
.25 Mabswid
0 .04578 m
1 .04578 L
s
.5 .16023 m
.50625 .16023 L
s
[(0.5)] .4875 .16023 1 0 Mshowa
.5 .27468 m
.50625 .27468 L
s
[(1)] .4875 .27468 1 0 Mshowa
.5 .38913 m
.50625 .38913 L
s
[(1.5)] .4875 .38913 1 0 Mshowa
.5 .50358 m
.50625 .50358 L
s
[(2)] .4875 .50358 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(2.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .06867 m
.50375 .06867 L
s
.5 .09156 m
.50375 .09156 L
s
.5 .11445 m
.50375 .11445 L
s
.5 .13734 m
.50375 .13734 L
s
.5 .18312 m
.50375 .18312 L
s
.5 .20601 m
.50375 .20601 L
s
.5 .2289 m
.50375 .2289 L
s
.5 .25179 m
.50375 .25179 L
s
.5 .29757 m
.50375 .29757 L
s
.5 .32046 m
.50375 .32046 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36624 m
.50375 .36624 L
s
.5 .41202 m
.50375 .41202 L
s
.5 .43491 m
.50375 .43491 L
s
.5 .4578 m
.50375 .4578 L
s
.5 .48069 m
.50375 .48069 L
s
.5 .52647 m
.50375 .52647 L
s
.5 .54936 m
.50375 .54936 L
s
.5 .57225 m
.50375 .57225 L
s
.5 .59514 m
.50375 .59514 L
s
.5 .02289 m
.50375 .02289 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool001Goool200009_ooo`@0000Voooo1@0002?oool00`000?ooooooo`0Toooo1@00
02Goool400009_ooo`80000Doooo000Doooo00@0003oooooool0000Uoooo00<0003oooooool0:Ooo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000oooooooo
02Koool010000?ooooooo`0001?oool001Koool00`000?ooooooo`0Uoooo00<0003oooooool0:?oo
o`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0003oooooool09_ooo`030000oooooooo
02Ooool00`000?ooooooo`0Boooo000>oooo100000Goool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Ooooo100000Coool00`000?ooooooo`0Soooo00<0003oooooool09_ooo`030000
oooooooo02Ooool00`000?ooooooo`0Woooo00<0003oooooool04Oooo`005?ooo`040000oooooooo
00009Oooo`040000oooooooo0000:?ooo`030000oooooooo02?oool00`000?ooooooo`0Voooo00<0
003oooooool09Oooo`040000oooooooo00009Oooo`040000oooooooo00004oooo`005Oooo`80000W
oooo0P0002Soool200009Oooo`80000Voooo0P0002Soool200009oooo`80000Doooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool000gooooo00001P0000koool0
01?oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`0Boooo001^oooo00?o09Woooooool07_ooo`030000oooooooo08koool0
06koool00ol0VOooooooo`0Noooo00<0003oooooool0S_ooo`00K_ooo`03o`2Ioooooooo01koool0
0`000?ooooooo`2>oooo001^oooo00?o09Woooooool07_ooo`030000oooooooo08koool006koool0
0ol0VOooooooo`0Noooo0P0008ooool006koool00ol0VOooooooo`0Noooo00<0003oooooool0S_oo
o`00K_ooo`03o`2Ioooooooo01koool00`000?ooooooo`2>oooo001^oooo00?o09Woooooool07_oo
o`030000oooooooo08koool006koool00ol0VOooooooo`0Noooo00<0003oooooool0S_ooo`00K_oo
o`03o`2Ioooooooo01koool00`000?ooooooo`2>oooo001^oooo00?o09Woooooool07_ooo`80002?
oooo001^oooo00?o09Woooooool07_ooo`030000oooooooo08koool006koool00ol0VOooooooo`0N
oooo00<0003oooooool0S_ooo`00K_ooo`03o`2Ioooooooo01koool00`000?ooooooo`2>oooo001^
oooo00?o09Woooooool07_ooo`030000oooooooo08koool006koool00ol0VOooooooo`0Noooo00<0
003oooooool0S_ooo`00K_ooo`03o`2Ioooooooo01koool20000Soooo`00K_ooo`03o`2Ioooooooo
01koool00`000?ooooooo`2>oooo001^oooo00?o09Woooooool07_ooo`030000oooooooo08koool0
06koool00ol0VOooooooo`0Noooo00<0003oooooool0S_ooo`00K_ooo`03o`2Ioooooooo01koool0
0`000?ooooooo`2>oooo001^oooo00?o09Woooooool07_ooo`030000oooooooo08koool006koool0
0ol0VOooooooo`0Noooo0P0008ooool006koool00ol0VOooooooo`0Noooo00<0003oooooool0S_oo
o`00K_ooo`03o`2Ioooooooo01koool00`000?ooooooo`2>oooo001^oooo00?o09Woooooool07_oo
o`030000oooooooo08koool006koool00ol0VOooooooo`0;oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00K_ooo`03o`2Ioooooooo00[oool010000?ooooooo`0000Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001^oooo00?o09Woooooool02_ooo`040000
oooooooo00002oooo`030000oooooooo00;oool30000S_ooo`00K_ooo`03o`2Ioooooooo00[oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo08koool006koool00ol0VOooooooo`0:
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006koool0
0ol0VOooooooo`0;oooo0P0000[oool300001?ooo`030000oooooooo08koool006koool00ol0VOoo
ooooo`0Noooo00<0003oooooool0S_ooo`00K_ooo`03o`2Ioooooooo01koool00`000?ooooooo`2>
oooo001^oooo00?o09Woooooool07_ooo`80002?oooo001^oooo00?o09Woooooool07_ooo`030000
oooooooo08koool006koool00ol0VOooooooo`0Noooo00<0003oooooool0S_ooo`00K_ooo`03o`2I
oooooooo01koool00`000?ooooooo`2>oooo001^oooo00?o09Woooooool07_ooo`030000oooooooo
08koool006koool00ol0VOooooooo`0Noooo0P0008ooool006koool00ol0VOooooooo`0Noooo00<0
003oooooool0S_ooo`00K_ooo`03o`2Ioooooooo01koool00`000?ooooooo`2>oooo001^oooo00?o
09Woooooool07_ooo`030000oooooooo08koool006koool00ol0VOooooooo`0Noooo00<0003ooooo
ool0S_ooo`00K_ooo`03o`2Ioooooooo01koool00`000?ooooooo`2>oooo001^oooo00?o09Wooooo
ool07_ooo`80002?oooo001^oooo00?o09Woooooool07_ooo`030000oooooooo08koool006koool0
0ol0VOooooooo`0Noooo00<0003oooooool0S_ooo`00K_ooo`03o`2Ioooooo